/*
 * Decompiled with CFR 0.152.
 */
package com.hp.mx.core.protocol.snmp.trap.components;

import com.hp.mx.core.alertmanager.AlertSeverity;
import com.hp.mx.core.controllers.MxNodeController;
import com.hp.mx.core.nodemanager.MxNode;
import com.hp.mx.core.nodemanager.NodeAssociationsManager;
import com.hp.mx.core.nodemanager.NodeAssociationsPersistenceException;
import com.hp.mx.core.protocol.snmp.trap.TrapInfo;
import com.hp.mx.core.protocol.snmp.trap.components.CommonInfrastructureTrapRuleHandler;
import com.hp.mx.core.protocol.snmp.trap.components.GenericTrapRuleHandler;
import com.hp.mx.core.protocol.snmp.trap.components.TrapForwarding;
import com.hp.mx.core.protocol.snmp.trap.components.TrapProcessor;
import com.hp.mx.core.tools.identification.associations.AssociationHandlerUtil;
import com.hp.mx.core.tools.identification.associations.HandlerException;
import com.hp.mx.portal.OAXml.OAException;
import com.hp.mx.portal.OAXml.OAHelper;
import com.hp.mx.portal.OAXml.OnboardAdministrator;
import com.hp.mx.portal.utils.BladeIMELogger;
import java.util.Vector;

public class OARoleTrapHandler
extends GenericTrapRuleHandler {
    String m_sourceDevsrlNum;
    MxNode m_servEncl;

    public int filterTrap(TrapInfo trap, AlertSeverity severity_id, boolean bService, TrapProcessor trapProc, TrapProcessor.TrapDbData dbData, TrapForwarding trapForwarding) {
        BladeIMELogger.log("Start:OARoleTrapHandler.filterTrap(" + trap + "," + severity_id + "," + bService + "," + trapProc + "," + dbData + "," + trapForwarding);
        int retval = 0;
        this.setSourceAndEnclosureNode(trap);
        MxNode sourceDev = null;
        try {
            sourceDev = AssociationHandlerUtil.getNodeBySerialNumber(this.m_sourceDevsrlNum);
        }
        catch (HandlerException e1) {
            BladeIMELogger.log(e1, "Unable to obtain the source dev node,Trap not handled.");
        }
        if (this.m_servEncl != null && sourceDev != null) {
            int sourceDevKey = sourceDev.getDeviceKey();
            int srvEnclDevKey = this.m_servEncl.getDeviceKey();
            NodeAssociationsManager nodeAssociationsManager = null;
            try {
                nodeAssociationsManager = NodeAssociationsManager.getDefaultManager();
            }
            catch (NodeAssociationsPersistenceException e) {
                BladeIMELogger.log((Exception)((Object)e), "Unable to obtain an instance of NodeAssociationsManager.");
                BladeIMELogger.log("End:OARoleTrapHandler.filterTrap()");
                return 0;
            }
            OAHelper oaHelper = OAHelper.getOAHelper();
            Vector oaDeviceKeyVect = nodeAssociationsManager.getAssociatedDevicesUsingATNs(srvEnclDevKey, "MgmtProcToEnclosure");
            BladeIMELogger.log("associatedDeviceKeyVect.size:" + oaDeviceKeyVect.size());
            Integer oaDevKeyObj = null;
            int oaDevKey = 0;
            for (int j = 0; j < oaDeviceKeyVect.size(); ++j) {
                oaDevKeyObj = (Integer)oaDeviceKeyVect.elementAt(j);
                oaDevKey = oaDevKeyObj;
                MxNode oaNode = MxNodeController.getDefaultControllerNoEx().getNodeByKey(new Integer(oaDevKey));
                OnboardAdministrator oaAdmin = null;
                BladeIMELogger.log("oaNode:" + oaNode.getNameString());
                try {
                    oaAdmin = (OnboardAdministrator)oaHelper.getOLDevice(oaNode, oaNode);
                }
                catch (OAException e) {
                    BladeIMELogger.log(e, "Unable to obtain an instance of OnboardAdministrator for the OA.");
                    BladeIMELogger.log("End:OARoleTrapHandler.filterTrap()");
                    return 0;
                }
                if (oaDevKey == sourceDevKey) {
                    BladeIMELogger.log("Setting " + oaNode.getNameString() + " active.");
                    oaAdmin.setIsPrimary(oaNode, true);
                    continue;
                }
                BladeIMELogger.log("Setting " + oaNode.getNameString() + " standby.");
                oaAdmin.setIsPrimary(oaNode, false);
            }
            if (sourceDev == null) {
                sourceDev = this.m_servEncl;
            }
            BladeIMELogger.log("sourceDev.getNameString():" + sourceDev.getNameString());
            CommonInfrastructureTrapRuleHandler commonHandler = new CommonInfrastructureTrapRuleHandler();
            retval = commonHandler.filterTrap(trap, severity_id, bService, trapProc, dbData, trapForwarding, sourceDev);
            BladeIMELogger.log("retval:" + retval);
        }
        BladeIMELogger.log("retVal:" + retval);
        BladeIMELogger.log("End:OARoleTrapHandler.filterTrap(" + trap + "," + severity_id + "," + bService + "," + trapProc + "," + dbData + "," + trapForwarding);
        return retval;
    }

    private void setSourceAndEnclosureNode(TrapInfo trap) {
        BladeIMELogger.log("Start:OARoleTrapHandler.getSourceNode(" + trap + ")");
        BladeIMELogger.log("Trap IPAddress:" + trap.getTrapAddress());
        String sourceDevSrlNum = null;
        String enclSrlNum = null;
        String varbindName = null;
        String emOID = "1.3.6.1.4.1.232.22.2.3.1.6.1.8";
        String srvEnclOID = "1.3.6.1.4.1.232.22.2.3.1.1.1.7";
        BladeIMELogger.log("trap.getTrapVarbindCount():" + trap.getTrapVarbindCount());
        for (int i = 0; i < trap.getTrapVarbindCount(); ++i) {
            varbindName = trap.getTrapVarbindName(i);
            if (varbindName.startsWith("1.3.6.1.4.1.232.22.2.3.1.6.1.8")) {
                sourceDevSrlNum = trap.getTrapVarbindValue(i);
            } else if (varbindName.startsWith("1.3.6.1.4.1.232.22.2.3.1.1.1.7")) {
                enclSrlNum = trap.getTrapVarbindValue(i);
            }
            BladeIMELogger.log("Varbind Name:" + trap.getTrapVarbindName(i));
            BladeIMELogger.log("Value:" + trap.getTrapVarbindValue(i));
        }
        try {
            this.m_servEncl = AssociationHandlerUtil.getNodeBySerialNumber(enclSrlNum);
        }
        catch (HandlerException hex) {
            BladeIMELogger.log(hex, "Exception in retrieving the MxNode of the server enclosure from the serial number.");
        }
        this.m_sourceDevsrlNum = sourceDevSrlNum;
        BladeIMELogger.log("Enclosure Manager{OA}Serial Number from the trap:" + sourceDevSrlNum);
        BladeIMELogger.log("Enclosure Serial Number from the trap:" + enclSrlNum);
        BladeIMELogger.log("End:OARoleTrapHandler.getSourceNode(" + trap + ")");
    }
}

