#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for nx/nc 61xx HP Notebook System BIOS (68DTD)  - Linux-Based"
BIOS_VERSION="F.13"
FILENAME="sp32938.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<FreeDOS    @	             )0ROMPAQ461  FAT12   1ؽ | ^|  ` ؎Ѝf~$uV$F F  FreeDOS v~v v҉~ԊFf׉v։~؋^F1Fƃ vډ~܋F֋V؋~^Z r/~Z }W_&Et &= urYP^Z~FҋVk XrF^\  s=r1^Z  	t$HH~
 FV$ s  err 0^$nZ1۴^V< uVFȉVʌFƉ^ĴAUV$trTu
v^̉^δB,NȋVʊFfvшƆɊF(^ĸV$s0뢋FvFƃFV OuF^KERNEL  SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ROMPAQ461            dKD1      KERNEL  SYS  -KD1D1  80 ~  R o m p a  ?q . e x e     OMPAQ  EXE  1LD1D1  ;1[   CONFIG  SYS \LD1D1  71[ 8   GPL2    TXT 1K1    h/-\ G  AR o m p a  ?q . e x e     ROMPAQ  EXE  o45  {]3   8YDU   BIN  
o4o4   n4    8YOP   BIN  Ao4o4  Ln4    8DTV   BIN  UL44  s4    8DTA   BIN  Wq55  -o4    8DTU   BIN  9q55  n4    8DTH   BIN  gr55  TM4    68DTD   BIN  r55  Q4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CONFIG    nused9W䯉 .ls璯 UUPX!
!5Zj  * CONFIG   PS1 [XꐤY A]o1ؠ$.  t.&<u ÿ,. u	t= ru.&..>t$*/.mtG
bAe=6w[&G)ƆPVWUS[]_^XP@ ؀q XSXR-LF,@:,4. ,($"(,,0,4
8,< RPȎء2;4v*҉6&V0)n	XZ [	,.W.VGVPPkvp0B[kb! BH~PQRiS^ct G$:wbƗS. .TYYg
OW,5>+dRoGo	[ZYX^˩vꍱ)J.~7bG۶?CYa+,'QPRU,rlq6+_.Y&rA]ZX^wy["
7xWFH t
/=]^ *&t tF 3h
6ZFkq7}-3c~</
h'_f
 Ӂõìލ. u6 5t/GKum4	ruO0$0<0n_t)[t$
o-<QS1ln%HݻFYt0o؄?;YeP]f>}
7E&}U<et<Eu&
5V\]n-  @PRN# AUXFALPT192s_3G,kM1>A2yP#y3b)4ti~LOCK$[ O
 " bܜ nO0_}	-s'3h s=OiqjbNUL"elX Rbckpro{< "l &/8b 
65S9` DG> ALUC  PCRemove diskettinnriX:
 #ރo!U"yh&QOod[ ov nyfsEK^=<V,N8=F>՚ 6\.&4_?S.[˴Po>&;@u(
,<V\X.>su	7tP Xϰ ErrorthDJ mechanm! Insert Pressby k(to cont5u. m *LBA-Trsf1v eS6:#yl"d> 1023
?PANIC[Sysom kld ^C
ig]awoaneao9fnok@|[qkj0dtsam*iȦ1CHKDSKstrygacc
vcio8clus@Q0x :<|>+=, /"[]<>|.A}MCB +s׼wupbef4aT`afMplwen+n\ofcB> INT2F/12 {+lm@;,$vir_mcb=pv1tMZBaN\mikComm+/agIs(]o E(mlvmsuc+e$\DEV\ 
g(chnpavh yHCngmka03456789abcm%f
+#/=n#w{*3	#^K; YNxۂf%+$0a-E4smEAAEl IOOUUYAIK^KAc."/\A:|<;M;,M	

 !"#$%&'()*+,-./W:;<=>?@ABC/FGHIJKLMNOtSTKXYZ[\]^_`a_{|}~CU C
OO;o$ NN?~!""BSHg! ; Z x   j0Nm< [ y   
1OnF7eDOSZ%$evs}1.35 (Builv20) [Man~30
042:0/:36]]*?O\"ZbVQƉY^ɿf9rӉ1RPމu[痉@)Y!!1_kO(?Un]PFFX]$ve ϱ$<
i/pbsUp3n4v!e by zko}Vz<pk:6%t
F<m1 oFF

L!^xzOpZ;Nr믴 UWVRQSPKi1Pڀ%to3t/5t/Pt
/Qt/bu` UhTM֌.AV_StV"n%!
<~#  	">n M։X[T:W]ϣ:P*XÃ3 1QP.%  slfLӼmcPyWq"UK[[]˞fBf_~v
n/0&60 >r?&kE\)ً&}$.{ݎՋ"J\Z-57~|J .<16f
g<t5váFXd tv^tLN2L&R FZêSGgWiR=7a߉+DqFDi9wu
;~w3^"D2C*V&D&:~rw|
]3'
v,+[5BݠV˶SG3!$0=[M0C"mw_h_09}W:Tu
T,00K@a+mj
BErAh}Gn,䲍ޞyd3߀O3 
Dh}We%.	B[HVD37=nt2
f7{ƞ=*u~4
UJ^ZYQ߳G4ۀg47|3@t3&D+茵BWwOy K[;[g;hWr,YtV'؍PwjPۆ  وÒX^WѮ7vo	
>ƆE=1 eTWWBgÅ/?
[x]L%Hc_lM7#G0<O0Õ{	xW5\RvffL0hP_ 
U['BS7V)R 4S.lP<
UDwTyDkPE%{PW1eA
0Vg
Pc׭
iy
H6wʉo!/ma5]Off&\&\2-~^
|Hu*&_`rvfrvgt~FrvXG=J=g׉^ȍVR\ړnVߤv\oƋOtz^Nz-/gfba`GFo@Ch
5/(p
H#b}luSǱS pF}Y:
mGE(>n}Ot=m2E$	
s3nz&9+DVQW~h4c5
amYA ]	4&M.]6C*2
_e;%gq©seoo
t+YBQ5= f-"=
~ ctf:9PzPVV@̾`5[0 i2x(P	k2AVn_r,<	`mPkRgt#t
~.KR_SyuYF
fFmFBTۿ~^ڊ9;XqvYv7wRl5*b1׊N>^0Zc:~OnsIrf&~r-ulM[O
(z dDoDDk\Dk=^O_SUn|' C ǩcphQ*BGD1ME9x1[	.3 Ca0;z\XR2
5 QLZ:։4ac"`CBXKy='ыngmuBwTkR"nMGƴ{q
$ضsvI4G묩f9/5<rvj7uݘCfLPE4uhX6qwTe>D!Q]:V唁`^^|	N4 +LYs$n5Ll%7V9r
GX;9;^S&{;\?B.[t¦"uCc|	GbRn%0/r	vCt^ZwM @O4_(0:m R
tHX
,	ҶVh09[
+Nv6t|#kE9	=B`>nTر	9s,a
vwuՈ&S^(櫻mS#  {;J1F:GV)ܫ(Qv	QmT9ց s)w(
[!JT,Cu;bWZ#fQ.=+~)𜍓oe}Xm4UOr6  3y
5|RtVPz݃]ÖQq!5mPۑĶVSωX)8/z +kx^м@Q+F8:BͣD4ѷڸ
Oգ^ l,Н$9&=迓'[
NuJ;u!}
u{ݓv{ǣ]GF^
4Da)GQaqѶ?zvRh_ I
EE@m$
qmxd Ǯ]#7
o= 
 X-$Ҥ
6
 ި
tǖ-gspgV1Pk37p)\U(JGV662!d
ƺצ'J$M+(
#}j@YnzVj[r=']ld3Jym# XhORh㹼mx;\A+o]B/
sisCd{F}䶂£:ڹY.EؘcȘpUEX
T=NApB_s+~

]"xs4sPɷ6ݵrk	AlkiWAX4e
vuHk\	ZfhgHMU,85/7M;~⍠d8uڌ:PwkY!u<0<^D
^
^]v#c,@1[CXz@?+	 L-ϋ-Dob&)Vt] #ǆ cNnmnXH )Xt[6Xs
ZQnl/]AX3plj;Yeg*>!wiBfb<Fb0)(B!%1X,~M[ttY=JtT=O=3Jbmt/U!D]P$
f]2[h,F$}g)5ov/+ƅ`[^[T
Z[
`c
6w_
VkB܉ˋ]2r/Oo_ sba;X<im<ѡbǿ^<
t<!t<"tf<#t\Q<t6<<D=[s;VE]McUu}
n~[r6_rcl"B뺒5׊nǴ^'p8!]	[ w~Z[XK!rRwP?n
s!`ýO<GYTV	tZGmw
\74CqS֤od6m Ȁ2RaB/u1tu(KD t!vK'-d9t:sg <*p)*,X:<7uݕ\%$fE
e}j7b,׶OLbie
pcUmmwKu<
Gw3Ou+r%ɚGYGĶ	k~\0DkP,OVL){1i8m$9;c%VtGKST>$Jg	S.(ŉQ%(\pPik|`kv;l^摣7uEe*3->u
@^6Q=U$`<`L[JɍDjJh 	gT
;GE6|mT'2=: uu7
-1\ _3Uv"h5WkBjPehX#	eq׮-tG@_p,M*&(gX V.]avowB^R5sx'E]h
nK%BKw##|A}%	
X!grAF.\1	0Rr+nf>%ZEՁ9r`lZpy Sz | ^wuR5c[P:"&ھ'p6f%
Ak>ZF-xmPe;=_=nt3H|*>vf,Ê\=R
=wP)'Z0ymIA؃qe 
s>9v6&d6k
~9Su7.MnBc-Iu`n[zu?E\[Ц]6
ZZ"^t#u	 
tP8lڔ0R">hjؼ
7Ђt=v\1@QoS٫QG;
g="efЀr45LvR0]Z 
šA8aTѡ204 .׈,n	k]SR.081&]ʐm7?@iGWr	k_,:E3\ݎgp Y
STJũ[@F,v
VLBТ$&ŀm#@$(Ĉf YB&?<w<ZM_K$m!
pN]
!C)O9b^U|uS,8=?$L)m;4sG-ikPj/}hA(ՈNoUF^	"$ñ	f%/
_
׃x=zۈʂ8?&Prq
x\< s=	.=
=
8m^/_G@xr5+R-c>h^e֡ uNt N~G	/CA<KX#4tU4O[yX
K=

y@C-G9>9
V7#
sl\
b?6C~c1u09C9h ^_l E'Ȫ;7%6+R~9S
҄fíxMql1:^Phz {;![BJ> ? @ K M R8]#"!"!!#"_""#
|"Z#'#dBN2N`+[h=[6&CM5P 
?sà~sF5(mg[V% %m='۸

Z6+*;Ss#H[b5.Nm*SC{g}:1y
8%ǼGGWW q)P)@]>t-_xs" u֋stvr@@^JPS0w Fu
C{vPKCm99s 뀽	/r]BKEB@pw]{vN7Wl24C\OS'KsK 
; rK
66	a^2&GrU{.m_
\
>_>"lB
+[2:h9iSMg]|0n~#1k0V=
&4 CCû+UGvFp^ȻdWV6	Y7Y6aP/uQ[ՁsZ_ãJ{m-m؁Gq?RPm.ahGu[
סAǀ?
ec.IF<ۢBA
B{|c=t
\~.0 /:gKWgR`)Hε,ܤ;LFB+~;r߰*Dh5Q[.N-dmWmnvCVr&3w nirw6O
h +Gm10Kw>cɔ X~Rwu}{p}
|j}8XSSj_E$QSzŸoNJ܃
}*4R0P84%Cѡyqq2h$pHR^
eW٫69¢щ54-CJl_$A=^_`'tol$2ז,CD|^^K-G hru06кX(#<Tt7C 	c MG MEG<t1
Vw6CsbU5s,z=nCEG䎘D["/xV[]Rz^Z $[2?6
*^6, .| [x}<;-V)-V9붿+Th&+	f~tgn2s'W455֚ܥXBzJ`
x
a]?THs6lNap	FCqU
u!Wm靹p[tY,6á.[
 Tи>,Z.A~ ^
	P!VX_V%WJ{f_ K&u	F!dG )VDE1u+\v'F(3 .}~&V4C~qR; cN1@pp|ls0w^`p=`1SVe@K;{0|Yu+s3 |$6yt3A0	C.#9E'ϠFʊFK5FN"&PxŰ nT.\/|Dgv!1o8(鯺I|;~lrS
^3p !R#VhBj-tYB=mEHyo03mGǩ]Uډ+mȺ(
ZL
_ݫ
fe&/
vO4w6PQhPlzw2	Aw|)ș͊k#(wR8#W(H6Jǃ<УN[9;)n7,Z	6ĐFvH'PDVJK</t<\T<:uCG$g+uC*Z3NE%0;_%G nE
Y6dW[   HD \7s.|O	d
c@ZxԃQP=ɣ%O	t㣲E`Z}Pl(Q.
j3}28Ζ]314@;؀1G1{	nGN 50`nU&տlto׹m#3J>p[(is>ҀjV04.<87O
|]QYp	Rj^	ڮI-ʫXO0x#.*2u*P#xā{P	
xc]5p@؈ؕ	`w=.4^Ep]s`c$
t67,vMĻ5D-A =Vэ\ kW9
X[b뭗amĽz 	!?C_,W2hJ#`վh'J-}H=G4`%Mw(7*lu׵>t'0,;|ЃE<&)kYI- ^s刌ۦnelhRTN<
B_U"EJ5&m.?U4\E6жϵ d=ۤűn-ssw_ _GkQhy{|qKh	\6B%}x%\W|E~~HkHAh,:N܇ `(z}d=AE=`5[aԽa3'CNF0K
dRŠwbt;tQR Q.5ϋUѦUJfQjx*=\E6EGF(tOTR~><cC'uy@SD[L
m5aO07F3~E-h/V*iB"U
j{Dv#~ sfn$~nї1+~?Ohͅ `%j
=qж!W÷
H@v2,-?s s`^?9"66$)uP%=mm/u:t(l6lq?A#EّKW\bV8 |:i
yy 0f]}Wwü%Gȅ{Z@%
-j/481%p55A~52;#9.WM "tMaYV*Iaϛ2T$V7H& GUZ=|~a&ݸX5޾5 7>u)-xl =^(Bz\EW"v6BFsQWFV݋Zp8i?W9s*tD?CX*:bkVtN=C swlv/Җ5/+~:Bؤ>Nh݀>{	\(-Ȗ@G=B
W/_B<jq
6RF`EW^aWfmm;s!bKlK	@ukTC 
ߒ@ČVp? Pr޲JoCF}
f.uF9L%;PWuK܉~ C$6h0;MHM./1kj3͙ +,kAR
/۸(]]΀O܌~E~^{o}ݚF|bN%$c2t

Wg
V<ANBA*Q⹧O@-O
X;uDFE `F*A	 h@k{wDj  E;U-AR$v>_k1X|z1P_t6q_7*pĘ=/ƠG ZXWi=i^YCs	S=CFl*N؊:ʥƲw.aWۡCEHqi*"L*gx>^5`=Xp G>|7 5t(^3hܹ9u[=hv<LNGGRXǴ 0Cv
ݧ.9",m}	QSf,5]6cKS»H ^e_'KtHeCa<.@x3.x7L< b<Ԇe!0e8tߢ
g-	J7`jX2;鰡gƏʙK<叭2
 ZS#cC]
WV
]aЅ!hN(V8RN
6P$tpW4K
& 024=6
	u\,7:qRt7(L*ֿ\8:p8Chctbw(E^\̆vNE,U.oE
nѫ 
gKE2/G\}5%1@1[ mCGr(H}suK' Saq
+KK	.-GnU͜P(ATo@dE$~7zXk\>e027)ÈEJ W/
$ 8`:|j# e]Cx=Ѿire۹ E*u-J&/y	sg\*\*<&G]M7I(4&l	JәҲWhaM/@­8LmgKh,Hx)X`nu$P|,qUWu,\RQsdʨs|Ep);tswt`*^Wǵ[ץ\|2.T*8:[<Rr$ؓ_O*SReMW[э,
D.H
*	tGg/ÄEdGww2j%l(A_P6H%s lJ/D,
=\?
@.|!Y2=c	 ,A
LlX\ӿK,Ovt<;6^ĸC$PPOV	<P'v6()G_
zare
|7_\.4_f
~$Ob-ơ<mFcZhlYVyC .j08]Ӧj=xnmc*Wux͍.Et/uTGYWr;J6~w!XPr{JlpCQ#H>hc=\t@Ba =8rES.FHBRD- ELݹ"QM}	_ZX@	$
^B6JШ0W
8H P~&u'
-
g>5;'5L֍
Bw)&+iwbZ wBfIlB[bQU	kgL|TD !Al
UhޝF[od4D8(0L(lrF0$=
uF	Uo7wXw_J7OEuEz^xbдv6+<ve`4U
p39Jp,Gt+m9k$^7wrA-'a kT#*ɗ4I Z@-2$8:$M^vI0.n

<6#E>83phlALhH	!K<?tA:3G+xFG5`x3
3wnX'Ǎ8LϳWPeOXv=j~+DwoPSqe17)S˽L?s՛׊մp奸w"R&\dIBZP;~Q鳼':?ڀʏ!ds C8!ώYf*2\&pO&6v8Xuu[O
6<T@/F~kM%[ueԙ|VM; sNSȿ0ԡ,R?-ͅtI;NtDv?kFE4{1e@[$!ؾ H`LA8>s 'Lw% MJWlG:;&Ru^E`uJC2iG:4=D+N1;u)(l
**j;[fhe_.9Bd9I'F]VM  ,"HG"m$lrXGQ^=ѝJLIPGKr.)ӹPi|15=os1i$K<&[Ő k1
EhX"
2sM\\G{~Lg[.T
0 
߁{2qUwt
(Ї*+Wp*])&BA
dr_
Q Gtomk3n<g[gvZBƲoN>,kuy:nL51oe^|WvyU_I.VZUP߉,DEB)V`X
.E
]SpLGG^AALXW`)4U;N~	tJpTбA;$/jnD;&9h|;e79)uv.Xz9!%72I]`WR&[ҳVg[vi:? '"`0<LA%]YupVƋ|<.xfv<>,tu2q[ lvf:J^sGljG+]JcϯUx^Y&j._7$R[$QTs
UV64orP rX2U{h
ovQ[
u'9WO SU 9/PsKv6"9"$ 4a0.X1t
p.
q!%	ӣ ]'-3/d8
;	!B;
!En\w2h0	F-؜c4`Z.9[v6vn9l;lkEZa0g_(t"q$XFaWmr`m`J(,*T"kc#ܟ:-VԏW
:GtѺ>IB\XclMP5P,[@
dg?|Tl*x#K.Lc
`7[չ/ #Kf(8LB}TqE7kf5u
ǻF( pI8gN4@wET>(O&+`G0E
ݎ|[ƱGo?cUc>$W7ZI֨ng\GăٛaZ?p[FT0Fk`\:\8RRKkb8[:7	+8)7!s>)0mU_Jd^,k.PTc9]7s6Cy\ (]pj^p0.\둮X _hmӬK4,D'<LFVXJ=ZM eIZ;T6vb-;s(|28
au.A!6ߵr4&Xc` R3"۸%@Loi\:*ƗǩO6G2^$r,
/"v%RM))#GA#$rU÷j	Ͻt |K. <J/pvA	>(LJYaGIq#e4e\AUDt%[u>[D.D$z"r
x
	) >B|r0AyH輮|YE;ŞM t _SNAn/fe`;ѣ=fȝ$+l#;;s+2%p<v
)z& ;&G+~nsh>P]nfݝli4]^lۚu& wuC*4d{@a^2ȡȉ"z[
]P'^q}NlGbĄ^]/l63%Nhfdjrxe 11`[ę5#\+VkRvZF!{D|DY|zw\9-i

/LXX7lmbV-G[jGVunmc)	G"QX:17u%v)cHi(
Un8<	T঵Op"[)[Z&!6HTO2mP| rGWbB.?vj	3ࢋE&|z#)w!uB~?&T!|!	7n\BF)xw!
0nZV-͘|ZSF!,RDSQH5cMB}z IX>n6<hKsk~*6RآOρ>	
x /VLW|zğ<+dm-NXȏX
	A<1>@IvKjU/SKq@(5&o+3'm8랻QuztvC!L-(,pUT؍?Ёo,mQ^={n G FҊB~-TlEE=S1;%tKt
"ةF~[Jۣimd&P=~SnwHP̦ dm)[RQ_CЊ@=D)#iy_w0t.=|
v== @sAFj 
wJ
QNGj Mi0gVFVۮl01XV57H!#%'57۪=)
+
-h/*jn#i%f'C	FO
`KA[1/3|
pyU)L+5+mʀ;vҊ 7 /Fi73YY `aX|  }~Uj׋j\F,0P`mV,1 0	|軐Yx0{e!;Z 2I7/Sڏԩ+~	A>5`#baj#ñQHk|Pސ)!BiGW&򋇊zH#;]wK\,tz@P#Ne<mJps}+=ov9w1ZQ#(}Kμ
X%~(jf&Fa%) 1mRڃ	
X^dH:^ ""ppA)D}Q[$(o5SS^)D/
<$ONN
,W/4^RX<~{G g"-
Q¨Xv}LO
|H#mV#F"GRyxXYoŊ%Zssk9 |5b4{W$_v_\;v[@䫻&`MSgwK9t;
늠pC/*Omj.T-q,GibvFr-9v).eF5A*+mFh9EGELюU_Hms$wлOf
n g	!@ɣIYx&/UC!
+#? :m55L >򌗔k5S\
KrИpnG(^CH7w3]]!Lcó2yxy/M%kbE'Trǔ#^WF4D߷DF==~$J=KCոF0ҺE%X9kB@%d	bq'陊 A@ehA
Nz^sqpAu[pWh#
ѵ~REpIqEv6L;Pw_;} cSUkZ}	B@ǿ|F
@$tN+@i.8v34t Q2T3XĮl)x؁HVhXp^`Q#	B'55ef01 D0C2xHhh?@uXR%YqAe^%tGU[@yuVLk81G(-*> ?l^P?觲Awwg),&(:L@o:P?,A:G[B7 rFF#~!!cG.>	FiZ4ZL
xɨh_C``^b(4+"ChZnaY&@=Bg 	C-W3 3ۥfRw vLøf<;N
}7]*uw7P? s?uD4 }F.>w륈S)Q˰_G r	|T{;
DX gW 0BJAHQYP4xAՇT: &,7_9r?ΐLh)_	ELժǷn>Tܬ]$P.(IDF}}/
%R(~S1'Awt Mvt=vϥ+K!6#)|hnω 5: tpCAZm}ELnRhNKmEZ9?,ֻM]Y6tS
 	D
9k^1RI>6ڽnB!#݂	L3k{y`29GlW#"ܕC!$7 
2cwZZ۴By@>|+G+.*UMNF#
UȠ x	ك YPVd QHQEerg #e=:>
lv}3{)bpFE3ZL,0DO  !DzDR)N\a㛓


45Y]-RW_Aۡ2k 2~0Q0ȇɊ
9@Xс@?p:CCNa\T0wX%/w4E j0(z	LW+*(kjwD0O(۪̥ZCg;|@a1U@> ?:@PG@2c/46't .en&FY2¾+Ǐ E k^
v?F򍐘KR&:qЋvTCFEJt\H4,d/*W uSr,[2Л`k)}(%hL(.	%Sj		=jU藾E
NcT 	<`QO=61\]zMG/Qr,Vr
zEv6X4OU5#`,UOٲx?+Ta1,0-l.>Kr@1;̉%
8j'dZ0!1RvT̴34WHۢ!۸CBR7pnP6tW4VKP_v"`kFqclmdF䆨sF*?
h&ψDlKBJe /Cװh> {BZ)%`GzM[* ^rkk9kMkRzkŌkC^[DZo<5rve<Qsa<bt]*<PtkV%rJv<3AB8"F 6>.*1
ȕjj7`
Nt$+~
cg7lۈ&Zi_z̠ c6 Krw=$( 뙐9n_A똞&[.n*0d0v
J
kXllnlmmmbn Kk^k0#Zko4?skD
lx E΄}vV$[TUW=7٧Õ
&Jm,rvvhqUb-, EY+L
tB4s>v׺'Yt`6* -j~7wD+@-|WKtsEH`I%K6u7^u1!(L;U/w;;E-wmMu
u-v׍UutM;coM
w>l
w[/Ngݕp+ᴻw?@x|%Yߦv]\|
9J1V"?AS$pb\U#Vt MCa)=wzW_4dL`jA
;na&dG`_	UG@Mip
[oz7UVF<	pv$b EQɲ?wP|Ku .w+ے,ЋBEMw6Hkpw	qAG7lb۸L^3wlq}qqqqqqqqqr&rWr`rjrxrrrrrrrr rrrr	Ytr
sss	&s6sGsLsmsussssss-t}%tt	uP`ukuuuuuuuvQvqvzvvvvvw8wwwwewww߅xxMxx
yy"yJyy
z~z!zxz5{b{k{zn{'|.|g r_xkxxx\yysy#"! {zzz{zz {1v!@48.:0*2P
ΛcVUpy~~8rOv*V\vi^`viejvluvA
Yjx$&>7)HvgrwCD0swY^{:o&NO&SfK%躶r_ '~Z">,96ܒ4#/ el`moL5@]kDP!~(rVMC<$tgxҬ!>92wSvKt:^4?Ѫ>x9Kj??f	wipo>Ի+
0
q+>\\]`뭡XoM`o땻f.IV
G0k-l%oewuVep^p`0bZ@\O!38d[fv	jd
覱
5yPP%l2]q!=5ACk15[um2#ؕ`ۋ)\=ueF~qt!';/ww<w$uRuK2D',6a_a˛Ds}.Ѐ4_0D^[`͖P
?p7I&(8Y#-(×^aD!l]P,8j1(Wv|W
%C<^ )[o衩Zi=[]0+'vJ/t
\ZH`
ٿTea8F`9?V,p!mmU=vO潅hĲƻ7G{wA],	W[{ƓedŻK]51	-ctgg/bI 7K@(}p=]m@hdBm^Ҝ,k+=#<v,N,^W-Y|(A+p8:1tgnk)α׵pmj*
%"k!=}
t#SK=겛L
GtX} Bɨj+=M
bQAK0g~t5g4
lCnA95@ׁ~XE"oRA $w\묠Ppܐ[b|+}z?; .<mllA 
=f[lx wO$?<ۘFq ͷ> !0N $*X(K'렙&l #8S(qi$U$ bVXՅ
8eϩ}ZK
@0FPS	[OIqW@q	wrI؅ptF|{"ۺ)S9~к:)|nH.%6Fh0@, 8+'7`M(^F-c[bZZ
E2#rۋDF[(OD@骢DQ8t//	v`#`$0M*8
x!x#~AK p[X-R*%{$L%Z?T%e$%W,׃$;*Ȣ!BA(ݡdt
a	p%~9U鷿Ѭ
D 3/N[ !|+<6>u\fV5F߄
>wCx $eVw7ED}p	^Tm
|8fO~rra}tA!Z5(Eu/P#QR10a܊tu@Xr5(z
ӯ߀&Q{D:2AP^MR P|_܀=VF".,qj#
ڙ}}4~/~h~v~~~~~
+QcLy*pJu;@I[^

#\
(;N(B^Lir1}NE}.Y0uΰࢴ!KK
eF!$6 C%I!xKn3]E-s%DJ;p@සd!]} 6
V,R	r+$.뿷{Kv뱡
>F<a|<z!t, 
</\(u6DTn@@e 5?8wNn:D(:ީd'm*ӠV'KM ?
-*&m)k}ft.mmo\a(8
]FiG4JFٖԄmz
UD*HV%#~H\~k1kb>m#<;##vo
@,l|F',1_nw
	Xsx}҂SׂYCq
Gq<v@Ci(
turAghۣmvboFkNrlhjCZPU9Iksh)oȧE2GiEJ^	Y.eD	uhۅ1hd4c*fxUUD0whtS.?N1.
D'
@VH@g-
/l@() 4	_k@[
t%u7uzw
@tD\
ZWu$tUgӡ]0Pcgh-v`ww|]2,ɊT
$J[zV1E [	p9^PKb](w]Oc70k%bA|,jA5
Dx
h0ǂjGs Z6
T޿Jhjt`u	|-#`	[pXy褐6CȤjp$HD'e MxVN@[55ZAHh)}b1 ,F^Fr7P!򤏆\ sP#q+F#9KO,4 wc2Z$QՅwkyGz붅)PPaW||\tUuPl1P8:K|7mtb" Z4[̵}mFN,=V
SWfق? P MuBMмE][-0tZtp"`,	@Z5K%R.ZtCBAo7?nR7a ;P?U&Tkܟch`,%"
O)u ˳=#Mtܛ|_v'ڭM}%;s	|=BAnr%q@= OYc0;w1g&)plE "fv&6 "k{
'$Uj֭ML
eFx9/9
1lMY	^x''tOIj;tC:BHV.ۂ<53^#@$)]°W.CB&;
M,=!`a!Ca4ъHStfGMD -	"¼td0pEDkuQQ'
oNȎvV0cHBkqe+\R3u,"P!辊 Fv0HV`3A W]le0U]uY%sFwF)1gOɎډ#>ƑGoGVP,W5>bKJˣ

"|,w&{>FBǴ/Wwm
l$]
l_P(h벁wQ*4Y-}A+ls۶V8O̎Ơןox u	bj΃D@H1뗋zMOweh#`;/;!t#sG}WYAmu4uZ:uf[SÙۨ)7_Wm(R&O([RĞF*p1
X5_,#ru_,i]E^4\/#1ḆDFX3bb}C	Z=GuRzWzWS V߇(_r¸-eiR"U̈-t
>߃xV¸"Ӽ
v#
$*_Q.EP 7 W08:2 Q.{PҒ4Е6 4}%Qw`ėM4߉@نj)\cxD]bǆl4mͲp
 qRHPеxZjtĺFJV_E% (\V(dlf
/%U	kCBU,N
F)p
[܊/-:rv
(
2/Ԡؓm @iw
W]`|?.Z*a|ƻz8? 0B(um'FElm
\KT	t948lWW*V].0Pg

PjW}eo^\PyKfD(pNKqM]
 9wSİflk|a3;pή&?@ Pް;v; wP j&IS[Y6A.u65Ǡ[si;!Eq_
%Zx;
so7PHr3N /Z$ r_jãW(J}-vA(!Vz:/Z9[֙lj'xn p*.LJhZ A͟S2 ~n7Ѹu
 z	1gԩc^m˺ih9O@M_-NNA4EH
A.RSP뭭
s\UsnA +Vf4\b+vwT 
QTzrMQD*"K@XtR:
~; =-
@!z@Pu!3cI;]2'C 6
u[6euvh.:0Eié
#H2
0_.nL<,UPR>Bm^ӱ+F8a2hUF/>Hǈ"^,oumWH
5iJ}~wsV	ۡEu

S0c1-\Rٱnv@Xa
a3H:F7,d:KGu3< Gp48B~Us	Lw+ =rT;|%v.[KViJ=^`";DsYQHA=c7hᣡDTwP2Z)[UoI䚜ye>]M_Oˤm<]4zL$eNTb\lTR]KBp>R@eNnhd[@vnP"(j~腥z}裘#}7s(:}R(x}m=u"MԾZλaBޛ`fC?p%t*tV"81c}1QHd^.>hpEA	~R}õr	}As$X &4.LIIˀKb&FIEl~ Q,u
6E(ȷ1lPr~րw

@@m?׌
h1uCa`Uz L12wfQOs 4.W) !psSV [64R|
GQ]_|J|2kQz6j1:T|1vƦ9-;t:lFSj\C<{G୳Cm\+6A#fhzWg>O"} }(@?
 
bGЃ4žK}☽)6@X.=Lڷu:ڤ4!c}<PhJt"U/<.rv<?
h;<o7</	<*)ʴw:9s%?CP몃s&;BTNw̍	keA^<ZLI\)<u:G$^<v3Ԉ5aP_u*VtU葎 ,AFܣtirUnj.U+Pfǁ[@
/:$/ Qc.PU-}M+@
Q(f?q$P8Zɘ<n\.6 k#Ga[p[&,!89u4Dз.Pitp{y%mU}\l	\aFN-@{dP8zPΕ/*K\ʉ6/ A\uKT8 oOyF$!hpx#sM-L2@[OVUƒ0#,v:a_2?\ zDo
yM+&Nh9s/0ID $(A,t
Ehq٣_/5D"M	v(v
&=X9"C r~ktw:.ro!B/؎x<kT\lyxzQ6LB羋^DE3kRX\m(`F&ZXM&D2a>bVQnQdY-q.Q.NuR]tEΎHT1M;S\0Ռ>"ht-nZ L(!z>*
QM~K%wBiT{l[ki@`w`3RP$RKK@^dPnZv$Eq !Gյs'3>-չXvT=6)2\F'Su/#:L
| B\n%U]
&"
SPڍ訹`iZo)h Ah&x~C^Vt1VIx]^
Fb#UE(Y;We;U
JDw:uS9rH}H[F_-	Se[
 斟tbף(0 õB0K=a r=z / P?v
+T%G`IuC QKpIQA:r+!&FƅFPU7-OAZ#[R̷	6߱jP6TJE]K4ADg
40i::
 L 0
Eu|T-~ Q*ś4&&%jJlka&(C ҟw뵟A)U -Tޱ.D

uHtAo6
fXtK9SS	s#zDS>"B_3uF6!]5h6Hs*jwBv+lSs9p4R&2[vZ[_rΣ3%pgI ׀Olbcj&{0ٔqDtQ
O
~_8	gl( W[9Q1p Q6IPRQuh-W6ZP8,@{ӡOШQE;u< COT#"w&"֡ġ⡘}1
ء\8iZTluqvSBSLϠ^?Fň%-s1R1-
N+E$oKP@ap mAScKpE
.яst
QGc	~CSYa=
߂͈)1\s(U.~!
pEUp}Q@[:lP1^ | `-S9}%B}˱';Im( 7+AX-r"r`!}csb.
b85%,يDqX)h 6pD|o.B
Nz4]
eC  wZP{@
Vk[
sAHH؍
	p[!wlz
p@
V+q?} U7-	Z`=^]*[~SX[YWIP?ٴnrt,K`zEd>x %1Y۱WrnNr ֘Pi@{[]sb @B2?м!Eີ[tz)^ֺ9Ⱥؾ[LK=F8%	o+쾎oPztk3i3o/o_ <u!t`PQR$A:+ߧ.} ThuoQ/ЎG[ ^66m%l,ˉ/GP/][ZXYSːC/<aS[a=${>=nZ?pۗP$YGjS/7|$H	Hޏpj3<+EP)0ݍ42
"'sim
t8
{k^_؄+=@4n: ~-	PlZVQi»bktl
"7kP3&^-4hE{(!e 03)krDieYkq :q Ȃmkh {nRwk)7
HnMkS~ƏGC GFV%A ^k; &[,?` U~} &]6_	Rt8k:m,Uٲ	CUr*trjm]6] U)jm@mv-Ƈh596pyou?~m\ \s~,mɾo	 5P5- fTh)\*H`/`} f\އ 
iʾ\!x^7w jU͌ޞčr`4OݠRGG4#Ϣ~1ц> rt
/w
DѠnj/
R0o|Bn	5Kbw&.(Ik<C(
RGtOjA,X&W<(> we@6*mhO >EF902T| ]'zزEX@C{T5w(&SmIKMOA ۺc_i_S}ݸ54
)8m=NV
3	)r(͞6t5
 g|;!u/{~~s
Y~ހz
uzs_e.^t	
MRv>2s6Q[	3?l"nB"9rTNS`g-gC0DBuҜMU	R|
8,,
W#kFpa
,[BP`!m
F|
k/UFt0O= ⺖Eߨƶ2"&tp$<@( eFJ-2="f"
0@E;@!\
I1V9Gs?FYl ezJ%Xe [h#9\[8<39,*z-)@X7'h*X|B<\ [/=g߈_N	C@09tM젊XBՂY׮o
:*8
7A^aҢn8VEf$`׈<}@k=BD2t+N!PDY"׈42uUM
J3w2t.4}ZHZ!@A~VaFk钉fW렠j%%RlFcu} TLP$4B&EA\	L٣ ^ap޻KVڍQwܸ|'Լ6(PH(c8KG [AHu:i[@Q$I+A.=h7=H t6!e,@Ggpjh7Oo |U>yQA͢Oàwhn@{TOUmmFOOF|Vc Pd'<6. z ,)l뿶kB(`sw1kWD.jb	Qd*qUQ2,J"?@/d4k)(}BiQ?3,и¸Wqt&(pe(* ,TG\L[
D<h>Be('W$>ob2
ab.n;-z.~&+6rJZHO*,z[F·np
"oXx$lPVrSEu3I0']
ۇƠ7{xw%6'1
[Q`)GFs	F!GJ7[6l\7^4fc#-R2oZ͢,.1@p0퐍`h#n>ls&S)6j9GIi8>p
@|,Z?t$hA9,PJGSC9RMrx9s*>M_CVm!G T]dulj5$͖~(:H{ &MOVn(#m>Ju#蔷JJMnhzh,Yq37V3:'YsS0{E@bv++suHćRg2mHl->ߞ)JuF=<AA03Yab=nZLAD0P?.|;DҺ 
v ErE
omgWL6tURj'պHHXƹHo' #Xj	"8O|@}M1`WyGPBȤojqo@#  wʁ%t&(=t	Ѹ*%
g1#uwzrm
	
 HTB7=@>c
 d] +l*X'2ld4);9r;Dvu1 'UyynYN
@4w/#={iDx|M~
I*Dc?J6	]
Bu+7/z@>v:ue[SpɊXvtOOol''R`QC@[P@^Wik&l봾"̾\7ZYTYaj׶,
1@-u~UkS{CUNbX]B"eV'[ xa! /n؉#5ݧV6$=,MWRR[s.EW8+E-0 X	O@yFS59}A"bמZ:u^C-ghYk欢DB!G
. ݹZUCAb`d4hb(+oٖ^A=^	5Ci͜M5;0}nh:D#+-DD-aEö<A|[2Z~^E,@:%[[;Wn<0oiܐ7l#
Tv͗4;u8,(x#,X	3\`(jL%"l J.!R P$Yl';B*3n33׍=@&GvC?R<Frv.<K/
<Nt5`E\{pR5Խ-M	ߴlk=kabP~W1CN:u=K8pK C.
0|&,
ʄ$ƗVpz>^͓@pNyߠGRu=
@!|헠ՠkP %yW
!
Ǭj3	q/+j轣t)[
 sA, |k#@~α|/蘩6GR+._W[/) R?ǟ(Cĺo~7(@g0ċ%'4pu ĝU Z"UEJƎdl\	 m*^sD-%@yA3"P"dB]<G$AAΪN޶|P~XZ* $4m VlVtBN@5I|XlD"AkE=OHKJ<
'hH݋NOJu!Fwj+	5h\]*s2	ꊇHǭo
	pJ.%#'f?[g	
4~B9n%v2Dn_0´2
k96D$7Au!
&|^AFJ"QmwD	Da G)5
})g|=Q{E
Q
Tk
|T@u.BU(2@ߍTZStQ.q:X[+5$QLU8
Sn ӆcO=Ru#^e	 5ZgzJNQC ?w	>0>
!)gX;P.)k$Iuj6FGs(F_d]<+v9Yz, u	]0XTJS۬R-v[6nSRA
'&kCj¿8k	D0^H[bh-uE}+h nD/}[	{c~cv}c 9EُvLex:Dm8kBW{90A4B@~/u;UDJ
X^
&V>EyWQ!ыMo .OGz5|"moI'j m-l7Hu(=)XAP?]LjX<&V{z{,࿖Emo`
qhDsgbQa!B;;?rns:'z;E:#r￷u)Ƞx/O ~RPSPJ-µ$Dh2M$ve<}	Cg݃L1'R<gg7FX&&[foh0ݸw\ 0QsѨ_t	Ptфn+`h!jDp|+}w6H
Ih\	t͵̵PI`CT=o~	y`(aX
UFn&݇|B`IWv0fu*wPu$g+?	}'A%05b
(zo.yXbq
0,0-Od-5mʚ	A
{L HB1'V1=!7CdidSM[ ^KP@6J@~@  :,S@oSW4S}߈FVvњ%v07n("V݈c ,u#ߊn
mĈ

q[=;u47 Es&h5L%̉
뽱fPb77I
l	$s^*a
vU
.M/2nB.	`HYLG}LR4б@և$dĈ/_vZO~AKvL^d(ݎ

r/^vt
|J~xzmq"ރvQ0Id!.E'5XB8
MY oʸ!aۢ<hm;(}Ţ#."
BÂpU3ʏD$9tNAw
o'
aF:hK[i+LA }T2KC@(y
0پ!<݈aır#nRZ(ܒJP.b*#^9u*=s%,&;Dd8?wj%k)	^NA']JÀqrn8
_p":mkki-͂܄: ADv@T
O;l7j `ܢ5xph]P516 +yxt!
S(eU/I. ?]@,g3
hQh0orpZ
NaVʡc	6
P"n% OjkjW%)`hs   );+rЕmWH5JٌfKABJsG;wu\duU@c%c#FxNRLFHA0OmbA1JjQ
wjĀyOO"E}`#~/KGwtdPx_)FH\DDx~ttp mA[u!R6 jԽLJkRm@BBEmE*S6@@
->mU=+VZPC[*ZF PKIAZ  E:ǅC4qCX/4OF;FwQ*MN9shF%,GDYEKkB`Fk
/Z-.[xuspoidcXS+pq͒&̓.f͍p9Jg:ڷL%t	T](FF	 j0nF0%p|׊ٔ
˦Dm3\ Ն
1lWY1Z
?
 u<6
CC46G5,ZPw	TnvѨ݀6gE	-T-r_A~ac_~M(i

9̻`)#E&U[tJn@v{)]7t%9T.к0"b~o?
*lJAE
T>qLc*5+D+}o渁kn[|<rPl%]b@`٠!қ>֊lD(PYovmRR$ͺmE1DZ8T	4	 d=D֋T
6Md	E^%Q1! $@1TMThT	bQ6C=a5+r!CZuvrQ
77W)p&uj
ӯV D0F{H4lޕXAzhQ VC]ΡTJ O\xvL>\l+cb~enuSNm8$,=vkbHf|7F{
?&^zw	~vPKp N6/f*'>ߒVKns/F?PUtMO#_4'̛.[j1ؠHY)vr(ur_ np/vdi:|P,4@SPcıVkư@m  Yyre	 N#,vt.p^3Z:T.(G	,.	"]
*p$:' v(=+ux,/rr
,u'(pQ x߃IF#G}!	#%' EgX&@Ƈ#AU_<>Dn/@~,[!R&MXt O.0Fg 7|
){_l|v,n[ 3
m/'-=!E;h*Ut
ދd4,QuGm67 2'̲	F-D?ge
HTJ}]oTLNh
/'U(]M+p:{wxVzy4
<K	D3b2
po G$>t/FC[x@ 
vX@̆F辄m/Ļ$W{@PEZ/>vF
MknVP=W4OFf|]Fe0Q'76 WXkfR:
_O>ɷF `=`UANzddUu uK t !sMTfmdC,=J*VtSHLiTmyKYeږYh1;߲,VڶX*OqO+k#a@S@/	L[?	a@w[D)S,p\h6C7sp.g	,+t=LHalW5mDklGZc*U_`$X<VI;þ&mWhVShGDWvARƣx|^U(	
'j*Zzہ?v<m;OAi1,El6G[ڸ8'ʸ
0$
-4l;) \&@J-

lNq\LE ;W#$4nTTH^E~Deݸ4X4) w
2Ul|Z {P=[P۸@]b74ևn~o>DGPLFuwtpt /s6n/&p"-gttn@tu&
3e^7tXR1Zfyof#cu@bxP 0	;9`*;[  `/eLE($:6Ċ[JE@
}hkiAD44]KOMSv6WaEQ~S7 BlIU1Y@
߶̂OE6Wxީ0
 -mZg^.E[Au8p!<T];kQRb|"+8l 1:4hB}7,"!DL(,W=5

}T\y)-h##1ۀ}n`;ƀz>pBoBd>+S4azҋ
X4 spFG$ Q"+8
' 3 /R>C: 6'w(;F遼T\T7I2t=P(k56	n3.hk gH6ګVߞ:xRp)m4&6"-	\v zs#hRbq!`6_ko	 Lޭ7/ɘ0.@<m=UjYoY9}BiU;BXO =:5P
SG^*,%nX#BZWMc$HiĴ:Li`1mC)=h%9胈{vőU;.Zmc
Pl?Qpz/@p2I
Zb
rWG+w;
AS+1ov׫!yӠx|
w@-^y/_
na:c3|3'x
(C)pyright995-Pasq-le J. Villi 6Th Projec
A R@seved.)ikf- softwa	C!ޛ% with ABSOLUTELY NO
WARRANTY; youk&+m 1dBtݜbuD
t}>/ATonfyuT? vrmUg
GNU Genk¦ublic Ls6$ps&[by;FSCFoUaPGw;
e9`@H=2, ~(8_%)PWnl(
'A:-@JUNK@-.TMUV !"$f%&'(*/jVE63 /Co$<μ|ؼ%,%7
/V/t/	/#/)/.3/7=/kK/MS}1Ycju0~Q徼yƮƺǾ߳A>* MUgfSCPRG/;_]]R+ bBRfB ;+EUR.0Al 	!'+$$HU&&YB'W	)@oA.*,W  r/r-<DKK.ASEK3/+afW0+PLN&1¯l6V[r 7 =d=Q mB_vfX@{gWBGL	|PUAH' [DISKF~  vp 	q `	 "!O@	  t$  # w$`7]2\oAUX8YRv
%Ũ+n7pЖb*Քo%+cx - 4T*MC	F32^juppt

%s?oH=.n/YD 
IlkSP;j,*FloHy/X	-;l  H}_inve5js(@qbo t {_<''H'Ewa<b21HVd0JDY.PzE:2O
>vWIHESqEM ;WELOR	iHLTL&OXBREAKUFFERh9h<M6tD.TR(s+D:mACBLE`HfLASTDRIVE	dMkvLLl[#AmSA6`jЇIY}EVICE6Z{IN=TziTCqDPBfdh@f.sy
50IPstf-w
jv
1F8yfwac$[r58^xip 3.SYS/AUTOEXEC.BAT79s
#pLlg'#
[Y,N]?YC{0wGgYKq-#
FbO9Qnh_Kmh:3)'s:oadSs=.av[D*kw Ic7?r>h ͠v"^
0=%u=c&Q,uc{k+)I+3|E
VD-ff = DByspHi49M"[xc ]]pc[mT](+3#vd)-bk 
&
x:S/ɂp(3m:0X ClIcw%uldb5,3tVmfmrID
cu4hKa0i؇3  To:33na%"mv=kx)=
/envirom[G,u5-C'd[d."%s"QS: S/beN3 f
3	aajamk܌jA]	),svo(a:r;/??j*egk#eF#h VpDy63ludu%.|x:%4u-%| )6s32%tPZprIt93hjQPiC,}ditxtc:qD%ܫ%2dr	S%ŚR6,6ѪBvize
ApDrԴtl(ge di(?v1l1mF maG2 d2Зs7rg,pB9=0x
xv08S0]00/_k,Іml63WCaNG:sSip}FS(Yccul#fuћizO`5(ad3]U	{K-4~(Aks*x'^tN L{<es,$䧘dogg=SKvPl˹P]~FC4-?ˑd.7):tDNVeVbF:dLtE)SG!`-G-`/[d[tu@ '30x׎YdDxs,?h3nr/~IL`H-0 
ߎ ^1 .xn fo`,V$n *xR(5q! 2#O"#&G}+d&h? `<4    @ uu rAsU fsIItɉ͊F19 uA1 sAA )r؍(󤖎P1X u  u<F][Î1&-Ht@uGG&=u&9Uw r  ` )  YHH1  &  7м1P &Cp2`t   +,-.-..-0-p,,+P+  t" ~}|}Pp"{ z}!tu t+} |tl$7%P '%($('&"!&3&6@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PTg~P%&$ |Q
!0@Q
!DD @#((buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


                                                                               MZ ]  `  .   c             F  /    I  
     &  o  A  )    %  z
  T
  
      U      y      n      n          "    	          ;  "  "  "  "  
"     }   g   '       %  %  )$  $  #  #   u
 u
 u
)  )  )  )  )  U)  8)   u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
~u
zu
vu
ru
nu
ju
fu
bu
^u
Zu
Vu
Ru
Nu
Ju
Fu
Bu
>u
:u
6u
2u
.u
*u
&u
"u
u
u
u
u
u

u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
~u
zu
vu
ru
nu
ju
fu
bu
^u
Zu
Vu
Ru
Nu
Ju
Fu
Bu
>u
:u
6u
2u
.u
*u
&u
"u
u
u
u
u
u
#C  C  B  B  B  H  H  }H  =F  ,F  E  E  E  Vu
&u
u
u
u
u
u
xu
Nu
0u
u
u
u
u
u
u
pu
Ru
4u
 uS  2S  !S  S  S   `  `  `  `  `  c  nd  d    	u
2u
,u
u
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          3Ðj薓ː
  F  F~ F F^9 uvfv')}fvfv)~h	h jMRP詎Vtj
fvvPƏ
h	h jN~RP|Vtj
fvvP虏
 Ð3f>^  tf6^ *f>  tf6 j b荇  V  h j胐h jxh jmh  h jah ~KF ^v&v& =c   -!  - tHHt-2 tHtp   T  F^v&v&8 ^v&v& t^v&v&   ~L  T  T  P  N  >T  uT  zH  J  kF^vf&0hn ÄF^v&v&8 uNV  *=p t -d jHH|f6B jRPjjzRP莈jjRP~jZRPnjJRP^j:RPNj	*RP>j
RP.j
RPjRPj
RPjaT-r - @- (FF9F}-^v&&?-t^F&&?/uF V]=sjxtRP與ja,]tjyURPij`a>V   h	h hn fvxvuj fh  ! hq
h@蝌f6vfh   hq
h@`f| f6vDefF    .^
~ ^&0@^&@F~	vF  F| 9F|jF= t= ujRP蜆j`.]\fh  j X^ ` ^ ujzMRPajX`s>R  t!G  \t( !  9  =  A  E  I jJj1fjއ   ujzRP煃j_
t(b       ؎f&fjxRP蝅j_>P  t>R  t\  Z  L  >\ t>\ u& & & >\ uaH>T  u	>L   >L   >\ u3T Ht	HtHt8j uwjJ9ulj?j.>\ u?T Ht
HtHtHtIjj MȐj?u+jRP跄jT HHtH
>T  t7>N  t0f|A  h|h|j
> tjJRP^>J  t
j H^vt  F >t >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uF'~ tfj fj /F   =HtkI-
 -!- - - 
tFf> ~ H  6 H;~  ߃> ~ H6Ĵ &@u H;~  6Ĵ &@u  FV^& &G|&Wpfj lCd   F >J  t1@Kt B= M- K- '-M- 0- )fjTD>J  tzj "\^ÐU
^&L&NÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ð|"~
 hh|h|j)}X >R  fFffFf+fFFfFPj ff-    fPfvFPfvFPff-    fFffHf#FfFƃ~ uf~uF      Á~ s  fFffFfFfFcfFf9Ftfj fvfvFPfvFPBfFfFffHf#FfFfFf9Ft3ÐfF   fFfFf+Ff-   f;Fvfv_WFVՐf~ uF+Ҋ*ҋN^+ډN^fFfFVf9FvRPVFᐃ~ p  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP5
k3ÐSfv
 ÐT  Vfh  P FPcf|K  Fhh|h|jh> t3^ÐFPzBFVh	h FP΁RPhTzh	h fv貁RPhd 8zfvhd y ^Ð  F@Fq
|"~FFhh|h|j辀}*ÐU~uh	h  Ð~ fh` j 	h	h hd ]vxvu3Ðfp    
fp   ff9psVfh   f6pfh  `f6^ u*u%f6vfh  f6^ +^= uv&G
 tf6v[놐f6v[?~ uh	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP荁
fh   vfh`  j f6^ @v>  WV	~ľ" f~ th	h FPw~qFPu3^_h	h hd [vxvtj ff-   fPf6vy
f6vjFPy
f6v|j ff-    fPf6vky
f6vjFPx
f6v{~ uo~|ij ff-  fPf6v)y
uLf6vjFPx
f6v{F8FtF8FtF8FuF  vB܈BF~|~ uF.~uF6f 8Fug 8Fuh 8Ftf6vXFPhVf6vX ^_Ð~ fh  h	h hd Yvxvcfp    	prff9psTf6vfh  f6^ wY= Yv&G
 Lfh   f6pfh  `f6^ 
*t"f6v Xfh  `^^_Ðfh   vfh`  j f6^ 
     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP~
<F> tjJj1j f6 <~jh	h(      RP}
6 hq
h@     RP}
     ء` +^  &&W    f&        ؎f&       ؎&  ;&  FF܌VF Z   R   \   f|
S h|h|j@t
> u_>@Z Rf|N  f    FޣFܣhh|h|jz> t>}uR   hMNu~ t\   Ft
F$p*\ Ð&  VFF܌Vf|D QChh|h|jy> t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	|&|Zhh|h|j/y> tjk\RPpv  fh  ! hq
h@{j3RPXF  @ +FHuF F^
&@VxR&*RhRj*OYF 9F}j }Ĉf<t<uh	h2 3XÐ  = t= u%F  F~}
Fau~|3Ð Ð>Z  u#jIpRPujJ`RPtu3ø VxR&RhRjXh܁tuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPnfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPKFVfFf  fPK;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRPKې~  fF    fFffFȸ	~4 fffFfFfFfFf-   f;Fvfv]JFVِf~qhXku2f+fFfFf~svBPƋVFVRP>Jِ^_   jF "hRj
VjRPUFF*;s6PjRPTF*PuVxR&
R뫐VxR&
RhRj
Uj|9RPMrj7u,jCRP1rjD
RP!r>J  thhd jRPYTÐ  [@7fh  hht"jMRPqjNRPqj{RPqfh  UujEF jWRPh	hH SF~  FF*;s>  u+ҊN*+= utԊF*PjRPoSj F*Pu>X X}jKRPh	h> >SjLRPh	hD (S>J  SÐt~ h	h2 RF 8VxR&
RhRj
SF~sF F FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&RPfRj F*PujRPh	hH hhd jRP)Rj[RPjZRPh	hN 	RÐ  4+fh UhhCt"jMURPiojNERPYoj{3RPGofh  ujEF  jRPh	hH qQF~  FF*;s>  u+ҊN*+= utԊF*PjRPQjF*Pu>X X}jKRPh	h> PjLnRPh	hD P>J  Ð9t~ F 8VxR&
RhRj
QF~sF F !FF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&RP"PjF*PujRPh	hH hhd j uRPOj[eRPjZ[RPh	hN OÐ  F >\ ut~ th	hV h	hb FPih	h FPeLFVu3vPfh  f6^ \L= s^&G
 tF  fv0KO>\ u~ t	h	hn h	hz FPhh	h FPKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfP9CȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPC  F .u3tF f6^ FPY1F~rh	h h	hV JFVtvPfh  f6^ 1L= s^&G
 tF  fvI~ uj#RPMh	hV j!RP{MF*  F vu3%.t(t~ th	hV FPfj"h	hb FPfj#RPFPfh	h FPIFVtvPfh  f6^ I= s^&G
 tF  fvH~ tj$ARPL0F~  F ohRj
MF  hRj mMFj$;F~VxR& R܊F*PjRPCLf6^ FP0FF~s#~ t~ uVwR&
RtFPFPj%{RPK~ u~ tjj[RPKF  F f6^ FP	/~uPh	h h	hV yHFVu3vPfh  f6^ I= s^&G
 tF  fvDGFÐUf6^ FP/Ð  F u3F F~s7F*PjRP
Kf6^ FP_=uh	h2 Jh	h h	hn GFVtvPfh   f6^ "I= s^&G
 tF  fvFVxR&
R
hRj
iKF hRj WKFj N*;~VxR& RՐVxR&
RhRj
K~ ujRPJh	hn j!}RPIF*  F u3t~ th	hn FP1cj"h	hz FPcj#$RPFPch	h FP^FFVtvPfh   f6^ YF= s^&G
 tF  fv-E~  j$RP)I:EF phRj
IF  hRj IFj$T;F~VxR& R܊F*PjORPHf6^ FP:FF~s#~ t~ uVwR&
Rt~ tFPFPj%RPaH~ u~ tjjRPAHF  F f6^ FP:u3À~uLh	h h	hn DFVtvPfh   f6^ RF= s^&G
 tF  fvCFÐUf6^ FP9ÐÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà*P Pfj   FPNQ*PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ*;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2J>J 	J  jÐJuj  ~ t	h8FNuÐ  FjfvFP^
F FPNQVRh	h ^S?c~uvvh	h fvbÃ~P|FlFFPvvh	h fvbÐ  FPNQVRh	h fvbvvvh	h FPPbFPNQVRh	h fvbvvvh	h FPbFPFPQ]ÐUvߋRPh]
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fv]F
^v&  FF9F|^v&  ^UVfvfvc\FN^v&8 t&@ ^fj <fh  vfh   !j-ރRPf6B p\*+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
& FF  @
&ğ &0݃FVRP[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6&Ĵ &@t2j>vjqj+jFvv^
6&Ĵ &@ F  F j9Fu
F F  ^
6&Ĵ &@tF vv}
&ğ v&0,܃FVRPtZFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^9FuFPFP%fjNj l
^& ڃRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>
 tF
^fvj_ڃFVRPX*+ȃQ *P%jj fvvvvv9ÐUj=fvh
dX
 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7@كRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w0؃RP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN*+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F*+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0ԃRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0D҃RPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j *P HPfj
'
6&Ĵ &psуRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0σRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;H}HF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FHPv~ 7
FHF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP="ÐFP>\ u!ÐU>\ uFP)ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh@FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh@vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh@htth@hِ = t= ut у>Z  t fj h4N3  FL1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 LShAhR*F*PʃuFL| j hAhR jʃ]FUtKjʃhq
hd j hjlfj hG=thAhREtÐhq
hhq
h~&Ð&ÐU~ u hq
hjhHhq
hjh7F  F~ ujFÐF Df>   F{ j h6Chfh  ˃uF  FuF~  ~1 F  Fff   ffffN*+;|;sF*@N*1 Sh6Ch`>  u)ff   ffffN*+ = utj F*Pʃq>X X<fj hF~4F 1 F ;Fff   ffffN*+; |; jSF*PShSf6^ كfh   F*Pfh`  j f6^ =ڃF*@N*1 j h6Ch[>  u+ff   ffffN*+ = uFj F*PɃ2~ fj hF#  fh  Ƀhq
hd fh  uɃt"hq
hhq
h[t"fj hEfj hn#=uhCht!h6Chtjfj hU~ u hq
hjh.hq
hjhF  F~ ujFÐF Df>   F{ j hPFhfh ȃuF  FquF~  ~m1 F  Fff   ffffN*+;|;sF*@N*1 ShPFhF>  u)ff   ffffN*+ = utjF*Pǃq>X X<fj hF~4F 1 F ;Fff   ffffN*+;t|;snjSF*PShSf6^ փfh   F*Pfh`  j f6^ '׃F*@N*1 j hPFhEjF*Pƃh~  5fj hF?  fh ƃhq
hd fh ƃt"hq
hhq
hwt"fj hEfj hn?=uh"Fh9t!hPFh(tfj hÃ>J  tj h tt t   1 ~ ujރFÐF Dj ԃud j h*Ih$tF F~s3c F*1 j h*Ih$FPuFA j h*Ih$he>\ utTtMtFj t:h"Fhefj hn=th*Ih$tÐ  <1 ~ uj݃FÐF DF F~s-F*1 <j h>JhBFPuF<A j h>JhBh/또>\ ut>t7j hj<fj h=th>JhBtÐ  Z1 ~ uj	݃FÐj҃uÐF DTd j h
Kh`tF F~s3Tj F*1 Zj h
Kh`FPuFZA j h
Kh`h/c>\ utTtMtFj1t:h"Fh%fj hn=th
Kh`tÐUfvh  zF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NzOÐU*FPPKz*PKÐU*FPPKF*PzPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBzÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졮FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FPHtFPhq
hՃ~ th	hHh	hTFP3h	h FPUFVu3vPfh0  FPLfv4FPhq
hո UXՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hԃh 
ufh  h j
u  fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  HPhhӃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
҃hx<BPhx>Bj
҃F  hxB$PhxBohxBPhxB`F~|hxA$PhxAhp  fhx AF  F~
}YhxA$PhxAj23҃hxAPhxAh҃fh  gFhу~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhfуm$PÐUj
LыFPh fh  	jmj$ыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
ЋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hYσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2΃fh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hs̓fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h 6̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth &Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF   
& FPгtFPhq
hȃ~ th	h`h	hlFP&h	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhq
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..bf^gef[UfS..bf^gef[UfS..bf^gfeff[UPfS..bf^Fgef[XUPfS..bf^Fgef[XUfPfS..bf^fFgfef[fX                           UfPS^tf3ffb  f.c.c "  u  $" u [fX 0!<s3P˿q
6 + r ׁsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666͜P.dظ WeP.dۚi  y>	uXP 
 Pq
 5! %Td!
)&6, 

3

sx

 

&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.#Q
u'"bt bbz 

b >	u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>$ t$ P]ø Y+r
;(rQ3 V3B 22Ut
 Pt ^Ï* <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &*U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV*
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v,טÊ  UWVFG
@tG
  D
u VށF:FVD*P{|]~ tZ@PNQ!FFV~\tBPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWRPFPvvRPFRPWF_]ÐU#
t]UVWvD
t^@uZuGD
F6u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
F63ۊ\uPuuGRt^tvu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށF6tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7DFȁF6؊FG
+EEEFEيF3EGǌ^_]ÐUVWv*Rt.^t	2vuVF6D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvF6t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vF6@t^*&GPy= ^]ÐUWV3F؋O
рuGuF6t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVF3~~ uD
tV@uF96&r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr<t)ǆr6FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.{twdydydyH{ wH{H{H{H{TywwH{H{tH{wH{H{wH{H{tRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] }(}>}r}}}}~UwVW3FFv&vF
t~ }F>, <Xw$ FF.|V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVF+FF96&r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33Bq
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96&s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁF6؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVRvv&RPFRPW Pvv;u)VxRR&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFV
TFPv
vVpx

& V3P,^_]ÐUV IFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3q
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	bt	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5![t#%!u
sʻ 

FV]U컱 .8tK
I	]PPR.d؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUq
ء
F
F]XSQRq
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ$%!3]UWVRQSP.dۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y(;s+3UVv&L^]UVWNwi	tH&6		VW_^s+_;uX6	&t	;u؅t؅^&t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]          q
              4.68  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update System BIOS with new version         /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                  MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM                $ ( , 0 ( ) zE  + , B  . / ^H  \ ] I a b I e f J h i K '  q
 `  q
  D10/17/2001  O                                                                           	 	 	 	 	0	p				J	|			4	R	n					,	N	n	~					 		2	F	n										.	6	X	n	v												$	4	F	X	l								D	d						(		b														
	*
	J
	^
	r
	
	
	
	
	
	
	,		B	^		.			n			:	X	r							,
	Z
	
	
	
	
		(	8	                                  E    F    B l bq
      C    D    B l q
      G    H    B l q
      K    L    B l q
      M    N    B l q
      Q    R l q
      P    O n q
      I    J    R l (q
      -     1    + o Fq
      V     S n dq
      *    1    ( o |q
      T    U     W   
X   
S m q
      Z    [    Y l q
      0     1    . o q
      _    ^ m  q
      c     1    a o q
      g     1    e o 6q
      j     1    h o Tq
      q    r    s    t     u     p l rq
               ^e                           _C_FILE_INFO=                                                         q
               
	
\ \                                  [q
  [q
                                                                                                                                                                                                                                                                                                                                                                                                                                             *q
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          @f@f@f@f@f@f@f               (((((                  H                                                                                                                                        "                                                     SdSdSd                  mq
q
q
q
q
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ABSOLUTEP       VBT             $VBT ALVISO         d 0 
  0                   BIOS_DATA_BLOCK x  
  d3412Intel(r)Alviso PCI Accelerated SVGA BIOS 
Contact joe.david@hp.com
                                                                                      Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ 9                 (  8  [0    ( e `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                     @   H `   H                                           =                       $    (     
 
                                                                                                                                                                   !  R`SI-1362-A   p                                                                                                                                                                               M X <      
 2	 Z (-  	
                                                                                          	                                                                                                                                                          
                                     <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                            (  s ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a N  XN  XJXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                                    U)CompuTrace V80.817' \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      w OPO WWUPX!	l;WO &f`a UVW~
3vNWXZ_^]
 !d~#^"!B @WWVX''K
u".H?t2`1_r <ar<zw$ߓ&G+tM!OoF	f%}UoV%FUrsk	rHY1 _#+mfo>c3ɊF0r	wk
`xnW^`~f	E	p	G_w<Wf  79nGKvEA\Gunc^|mRs,eު+74YD07v5|"Fk- t^- tt
_^tuJ~tu>D9/u6]yUu,}7
W t}v3^_sE+}Ff;fOs)GC*#D'^4
Fm	[/Pj>3PtlXȷ;NFPr	+snV
D/Cvs)/sam
MEPW*
^3vNrM[a j$
F¶{t
j 5M4ON<H{k{V,u<=t MF u7-]
q#ÅۺP(t~vI<k
';Φ֧h0Dj3T#httF|#8S
P,
vShD&hm?+et!NAQǶhnni+r	 s)!Ͻ
J|8@oduI |F# JٚFu
\Dll
vlyT8vnFiDLGgtV;{hR"L2fRf9nKt8av$'WF	hD;߄P`EdPK?]lt\\s=Fh
{CMv?(|etsRPز'sJd!!jhxDh&PY+|:43tf6s&GO@`)Vjn8x,wtt[V
lj$8^8#A\mUdF^LKrCusuu]ᆗ'"umDVOf2Zqv;/ ۹th.Jyͤ"	lwM 
>_lκP+' i;iL':,;v5=`k1 +G
jPx :	4VI|x-aEuF+Fv*"E-$1[/@sPm|Cjd`A먉Dl}l'VL5QTY5:hh>JrkE,|le!#cEB&\Dr0۠,D$\ 1S\^F:cӄ`R6?5u89o$t<(d?puBc[X|. {k]+$΋	Aw84WB.YGRԊwno|:hAX:BV37xT!I]BtR0<	D(PP(&FMn+"iW	(-zk58V[aBf)eZPPϾk~	9	^XR0#8D>W_fEK8}Il
) ͖ w uh&j moF r}DWkkpض U[f%޲Tltv
o"d[B)H/RPSo$W%,1@][.	 Vu=Gvamk	\XUbLL-N]$gfñf!R
`	 \ݚD2.%ǳhM;-ȉNl48w@M3QNQV[[q9(v*krۙl7V{Nw7~*
9s7W1-TO;v)
P0g0H6['FB'O,*9X[O
o wqw 	6ڀ$+ak|(lվ+07G2$^ oΆP)
yl{ur8R7g)R`6ݓ;µ9_~FgF	f5pa.+
_uE$0ݶ(4
 5dUhڦ
$c\JeV@br%H
D"T"6R;"\BM,zIo%f blUuAW<D, v>oyrbX}C&lo6P%^GlLАf:р{L7H^29BS9PujJ^'ݷ e\كh
56䆩4@3k}f'
bdn5+~u&Ǯ
F*.qٱ(/|(v,lafl4]F
-snm9Wt\Z)#D٢ ml{BHn,H`}F^-EV9A
oEm	
@'E^^>+-VO @\y;V
BGG=2NzI'\:a+Mɦ\D?'f
^u_\t F)b`"9Gted7ORu<"GH#FD^ô9ǜfHm#{$7#H;f`NWY9(U*PMMu"`,.Հ$E(Jw W/~rEBJIxjZ[/7[	lG7pU$<u@(O@t.%?/	WFN;up	8n[AEFT۞Pط`:Ā
J^k(d7gM$&	(
" 7;fJƅ6/,nkJHpoq=`ogn\t?<R/;u/}.GV$'U@!ƾF+|~+= 4r3K'] e v&ouyw|, Jxpir{@KFeI@x3};u;VCX@ddfjt-'	CC+wtT
3śa]ht3+Kz H8$tkN;9tkND7EG7-~Y-\o=c0Ku:R8*tAtD<\ݮu/e,*$V t
.6-7L;Í8V -TVٖZZX%Xa&IwO2-S3vѺn9;0"HP
.0ܝ2#wR
L,POd$ly %^o.O,̐1_|RO\߱ -Z[9 cu"߮5U#VV!q>U
GXy,[!bHBW~eJuVBX!`3m~-:=Wt@qG0-DRIG!H;޵%*vu'e+]O@FGupԗ/Q|$)iҪ8
CK:QX7{,fbl&<j0ڢfn{#MfU<	]ܭveetV;
;jGr%V${ĔD,G$/
>}W	G@
Bٲpr,
* w&j Ht 74vk=
826DO\upDH	@N#
YҋoL,
gCD(諏+,HDphk-%#ΞJ- #bbT#:9j2VE=MWC|b$-B@q ]۞xئtOw"Nds Nxq5"U2wƾlKAUoDA= w(.bM6 03L<9 ܴ齝5ennN+@1]t<=|@	LB
;
uaV?8=C:76?+1+$|$S}γ6. d+
{;~fc.
j.ް2>KCvGR76U+zpc@5섨	 ]]m1dRb
Yt9S:g
ɾIKiG6g0
R5l
 5VKf!o~O#<o@fP%ep%?0Nn ŁgWl8#IjoWUON~k
*q(>~Ҷm	4?5wE'uQK@B囙b4<ܤF6P(9	VtIV%ƠjhCڝЦa#VƄJ|!Bթc~۹GFR?(* A9*F Z囋EPR
jZIzNl~CuF~BQ	ke]Խ }F 
V
=K%Э"dN!uNI?Ff
Q("`Q,1o{̓T>({BNVz/8%RV0FFG;wD9`HD/5].JpxG4;ueHLQp?(:W&];t K)o	}Zu|]"g| u&>FtW{ѫD _LuM&8S"+Ҕ0c4ԊXЖ틃`ffw1Mf9G8r,v7' ,hRZA:	Ձ¹-}f'O@B;!xc떼پ$NQ\|a該>fNEv3Fy'^8!źī`tDD>&OGN=Qw-z1K(6$XF<>j0!$)K Z:A>$bQ#)yW"w'
9Uu>s65 rwS2rr$vz!Tx86;pL)xtd+PbJVY*GVУc?LK/aA*l.	tT)1{L R@r@И ,Rj6`~D;4G3
X`sd
 μfp40cR
;
feI-?m܇3(4n@@ %.=P@4%niaPWh A 5ͶAL2tHo{ 継OP;f#ǳt -itζ),lXwF&5z;vvK!+UFa;WKn
mjԓ=Wb6]S5PFVuiI`&v!G2k&GuF	%ٶk/ڎMQf\
jι@|$_Tun/HHl}w6E{q<x
WO'VgXNkHm9w!<y;cuf.P(Gݩ2ȁ0ݲpT7jxශB;tj
s)^fQ.ll%(2%j0VV][8l2Ȉ
`oVW-p0ɵ81sZY&_tV|i2[
Z,)sZ|j :Z\Z
oR u2Vc)6Υ Zޠo 9RuHuC2QP/Ԯ=)bӹ{UV7N8;q('ҿ;vVNQV,J
)*L( af3-M1!W,IĐ}'u!xw6>WG;0W;	DHiY$T1V✁s@? t"mo=jDG+=
t
Ejht]S7DNPn (p/L+baAk!ưfO<9TV9sD#܋ڃýێ+¿mk Th<3<R"	.fR,i yqW208zͯ!x'8sW	Yz٫a1d#ma4 B1WvfP"F(t3l4;5;%uuV۝RR1-Ŋ|걱45|P0 \9"@ò$x^;bϢrD
kP	ԉW8^E(VzSL|ηew v^	w|o亅ÒDrM"CP4)bԻVj1)`fhZV?n-9dK}wrr@wk(5(,gmsy}XGC#:<iR4,Hs0&E-K*KXXYrIWVrê	>2=$j\܇DwDpZԆ=Cʧ}N&'0L$3]&NG?5qRZxޞ5	bAuS.+<`_^Yu-.P)Nj%p{8W[!?W@)^r
AQtu0D#]|7 ei__+;ʾr;r6X\qoBs6.#ԵVDIz
S*(6 CXl BWs(x RV"$!577pwz.Tss+;(FfG^w+ƶ%!zM؛_V#i T8дU#^%}'YjkV-dc7
^~fA5Z60בm"L5@ Xtk@7GJw;cG
RֶPLNH@.H[zLJjDDt:
FR@B[Ǳ
r+,L/x\w%4B&j nG${L?,ry޶Td W"2YV(yWDF?9ZHTJlo<>Z+D3EA/P=9kD6fgIͮl@4HFCFD&Rz&,v%V]Ci=NU٪)G6t18N
]6	:p$}9&:Z?M..ʍ9!<GtĂ^s[ȡSW0l(WRVv[%'t)zYAQVϙ=6 Np5[PL *
*թHE4ޖ:
&|hS2ۃ4 ǣxHztl	{,I@rf*^Ww0V+] &kl@и5P!yܠXu
 V`np`,S
1DV/q8"b&6thQf! %F$Vz&p,+V)&PWU$zGL%/2uvW #"AD#)h?$!oa!V;U"26l	
	/]!vLcDrր,'=ca6,0]hP5J@ٸ#b	%l
`px=3з5R[2wp$bD
}xIazDg]k&;Tp,$\&KDVc/8׈8`!\ ri&@b-N_ck4 sFJ dܬ
D/ùf;FD7`nmUOxUJ 18leT.R
xtRu`;EiP
>q{R~	N٧	k4oE(Dz4t
,AIVhOr[
r&wvrN H;+pTH@jY͉CaACC:z	"=t(4(<r>2p22I_`|GGx:9|%ff5+t+Wl!rRLCOwMcBczrܾDvwbF*DTfЊct{H+6/xFgd0H$|\
	a/{?,jco`
(P	9
0y6Vl@AupiC
^X-NTsнT@
'&0~8 ؓ3l!+	&lbmVl
UۍD)QxLdQwp)wȸҥ2f|<Q?,MvY_!XT,+v^,.:?:SNp_btNf[ug5P0',x_TZ*`6e	o>OT+NBF;s>}v;s,)N-fP4CVi:"[%,dOF{)&8thY%`W"f#&p@Xu<R)ǌS8C&
%
N"05pl-=Hdd.6?AUTOCHK.EXE )rdisk( partivon
 mul	\MSDOS.SYSSystem32 $I30WinBootDir}cBOW.INI}%tK Menu/rogramsYk{}BAK^8-ެrpcnetp.exeo&&ړ&MZcTmPK@1I(ǻOǶ$ǷǴ/RichSPEL wC/ s$`]  l'e&+dW(P  d<.tt_na#`.daKݰ
.cu(D0`'mtsR`'rel7oc'%MV";B  i(G
*i4DiRbli=Z

4_2Dt7	R \??\C:/8R#5	:\] %%l, o\Regi-ry\XMachi&-ur+ntC[{olSEUervices ?Local Obj+ectNhKImagePeh TypEGo`rF {G : 9]Iathl@ d7$lVo+SVfEeE9EEdÀެ,V]YO=P. N3V"jhn7V#kPhCyPǕu	@ma C{{|+E5ۜ940Q3ud,m@f#(ZŷRt/܋@-)e  MH{k{ ;{
k2MI-A3"H
A@ۭ8ۃ}
t'on!)͹8w?m]_^[:|N葶F8ػo> t*3pG4`P+L4aR@fJbAFE1#8w*H_K##@|(dWj8)N)af;Y-YC̒WWfWI}ɗ}}b囅[9=	
VVx=
t}SNQ	W	PSPpWvM)p@f86r,	9>u9~u[dM>LS <Pj2> (GnR	GlX4;!%Q&yTY2Ij)OYY,34-+[uj0(g
j.?;+K NWCZ0+L9}V#9ۊ	0VLd v>}Cs(}f3^d	
%0((8$S[o8UF}Wo?  ''=o	O첰$qMeLav4Ӟ(n86:vWP
QJ`u6);S̠% mMR׬W/1BB"*xX X .+<dQfljhoJ|Mn>6Mc[=֨LqYB>
^`Ë"7 ᵝ9|]4 9DH|o N
eFilrwcscatRtlQuyEn
nme{Viab(}_U c9ns4CDelelRRd
F69lKKey |archr nInitUcoden
\ng%ٓs[/P?TmkkaskW.rupy\WSmOw-d_tdll. 
j9z>9,b9~<9?9"#9#0s v 6
#$-PoX]wwFT>d~ p  8'HL\%56=3T:|S<`r<&Gp'H@Y@*HfiziКvA4.@VMj~44MeBi.FTf~iiĚiC4&2DMT`v44Me Di0<R`inzD]w46MEM&84JZE7):ssE -0oLXgagIi.0U\-Lgth: %d
%ss
xsvMoIcoftwav\MsM
\W;ovwsVos\Apsp mi>pkFI~rnA۰ x\&o\.b}bQ^͝DfRm_j_ܝm{hF#tTX5/Ac{D]AvaXثkHaÃ+0*?[Add.qLH5=cln;AKOpMozioa/4.0 (cow͈; MpSIE 6;)a/OSTǀ7OwSREA#./''K((..0//</^K.b˙!!""+&/&./HLKJ@Nz9H~`n _*K$h@6}c`eZ/AHwoD)f[G@
=Ke7zAvjaH#ljlT6HujWqRֽLPbտn3 n͔ Y̠(uS_䷻+xZ;cF9'ouva+ȹQ:snpnxlmF7O9]ev uVQLжύQPL+Tg0RP(uk֙xOtj
,n	_N"(w0w۹vn/KYhׁ	`\MQ5R/:-9{,"h0[9О8 xYѫgeYEⶑVSiW9.$WVx<hb	I~8KlC`a7QQWjl8LhJPlM#(جAw@?tmWhPg:
D N2 hdD.A@@=mL|toj[S^  #'t< xNVP'hXlHp7~gl3,'j4-XQh=<t
$u$|$Sw
hP&d&no^ް
` ,0>V}WS53չH+}na}Ы]9\t0C .S
,NM+ⓞek=]\]@	`,:_kcM4V~xza%gܖB%m7\ \%Giv	aQUV
3E}6i)yHDQ{E	$*vb-(	.;ƣ1
0ň8/$ yVzE=x&dh5_2o~%@#5_8k[uuÿ35<Q~t^l4h
u	*c`Uy_n[^]Yi('3G}ĉ'l\btB4;:jD_Ey64af:}6w!,׳z9*
|2lx )4	A'z H˸c *dhd d:{c^oCle7S0olt,>%d20dvtz@V0ayoV<Fwp4$fu:0t?ldHX=7H@y"954Ou\P88,76;~6M*0:9/P?McƁXwk6^u

8zoWtt	j(hXi@6̈5AA֣"]h_&R|	Ԫ|rW0`VUZ/	Dnl|mtċcF<<@hPdP8oYY'1vD\P^ea0j,YV:bA
+EXp'\syA
lh 6NEi`m7SU\}9P=tbUy
VMowk-#;t`B@V=X(V>4c.} W@(aF;tmDu9xNƛ=)(;Ò]'$MgZtbۂS )wPSzSͷl*YJj֐^'֓Soސ9\6טJx\l][uo=,6>|Bt(؞o":7u]¸3l]"J|W}]P}+4o,
[o3ר@m\t;u"PRCVPtT\)*,ZEbn_d g t JIRmzl1W$LLbf<dlma =@s>
*@w<8 F洁tB.[w9u9'ހW?xhƭ!fT[&tku*peFlƶU]H%3E%Bm#pv[d&/FxPQfuQG-\Mm##7`@&fuhI:**PZ_<DNHH[Eޙ¯l-oE-uqb
W
r07dujdp3=4x4Vٖ45$ TAmivpiǂ4d/*((68N`vP2TS z;jjZܸPt:kP@SKLtujHa1tEL;/X;l8`.R8ĨK '<v(!
P	ɈH'VuG9G_su%A*?AAVބprU,E;E#P@@Cوpklh"rP<	pAC=;E7K'K¸ݡ'+m `~$	̀8g609	EF$\(0L,$8/Ho9u-e8T0ֈ]*mp lQlؚgXE;o޲[*~Zm5HV CSV}z~TVk\D nO9^ht3ۣި܆X$x苙&ۜ	89Cu^G4( ہvS$ǃcF %pk/MrV$RhR^\pT,cDW%p2`i&5l{ f't
Aη̤ى=2D + 	%G
7Aôm4.k|@Fo24Wv4M&޾t&c(r<?G|Fc7#^4JxZU
S#?vnQV􈑾F@YWh`$Ke|v
ahh[h}(=i;T$hH 2A>c<I88su 0IbXZh~bdђ`w9c`?pt<Ťf	.cª@@pY|hfp&da
q=d(|h0W5
fPm);Yru`P9̺1X5d\[۠!0xE(J3-u	췉t`ATqõ2pޟ3ĪDF@	K^B?xYN]iW(0s	XW	!Vw<bWzHMP94~sF,s9(Jh=L0C@3ҋ~JHN0N<v8Dr[Qw_H^DHޢf,0 HP	K
V̎xA~y
; 6)sLў+ .|$Kw+WVn4:Coq
^F2\Ɓ	б%f:$aw[Jwjp(qIVA<V׀ ۿ<"%Vj3jBDX\(W/`xG@@Ft
]NH>1
|*w~ 37+j ڳ0_A"@[G[s0:2|t
S^BY;os6|DD#G	&N;6)!Vo"CNb_!q1 L-]Q	PAҥu	܉#ɋT%+ 4Z[c
0mۉ1DuJo>DNd`!@\pp_9VD6[x0@KNHj	n0Ve};wu_  \jH$wX]zqaf{{<t{4Plf(KVtkg6Q;-3:aP=]ujXf{aq^l>D什8@X.UM߲mvk(H+ͬh;u	cZmjp!q־<QYm(;Wҝs<HKt A0^tilNpNYlS^XPw.+>ZP,b[WW#^tjFl
۽<x:0 C3s	6Q.xQBAuSFp?xWE5g&
@8]-tXN!LpAE,|c~焢p tQ'R9RQR4I@I

]ˈy> Z-v'MnpSwX}|P@ j-{K
Wt51Mtf6x#(
M7 0|[pVp^Yrp'>Fh}Zhcg;b;N	gD^8K[;Ծx720s<U{$Aǧ{XJpeuPف7n:rƴSِLTo[Èj-8@׮rwN`D6$j13(yr{(D^xbdИ;|A
X9${{hJ2Aoh.rekA@1?A
,װu4-;&OcV l
a	&'f4KW <
t<
)<<XwD
x9=1&B4V^hj8CYh::̀Ō )N)!cu4ՀJDy>,
	ɂ$n*޾ ڋn'<@j~@_>Q9%tYfϵhG'M:N7w"-'1],0{.|5 Ptc845SIf:x.ǽ\8֠FA6BWl0^m}(HC坷tSo<<ȋ+Ѓ9KUB*K*߁Ї"MJgLRa)ޝ&-%؀	`"OS#6q+A5Ȱ{(zV;KPBg<HJ[6%UW$!U}v@=tVP@GJIӃ'D>Ӌ\Ul][cZh|Dn$Vt
ՠduP0>.j=$x [
A!G 5Wu]چcB7@KYbW7fR؊3э
@CQ9 3pYd4XF@ ;| +7'oϤha4ȡ	sX$L(ՋCR(2p4T.&YRj uS`1zt5}ITm,vCM>wr
C~^N :tuKKF7Ei`?$p-2D)GV!K+=	M
 )W.kVOUj4h_>lȨKDPEJT+ԬeI[в^>uݭvBOk f?DJo
@jmAPh|(UR݀~%@z;9<>T7s9JPhuOGo}+ L6
!#pуw$Q:jpRQG>kSK9
HK<-V
u7"O 3
[{
f$ݮș;˓uG:	F:;x96M :Y`
<΃/D9XNkaZ
+QHP
Q܄	KfuV@@A)=Bt(JRt
0]0f~ιpf:,
ۿhfV2sf!uh:o
^j~qmJd;u;}q?tbr;_/k	h;5\Wv@	xsj}g[  G9n|Ѱ~<956nGپeDV<CdlE|FH	
ӍY\7x4}tIuB;27фt /*e2IUtB;}
5ZW|{~3 ]-5zK]2f+x%À
w8~w
}}-}rhTwwbYH])	D4[
mS}_4	L8}t%Gᜰ8*t<.];ڞ;2^\0!T	 , ~mm PrGې\1VO;bP}O;|Ԋ.x?dtSO<*6vUWtFܱtٹn+|N,}pÑԬF]S~BKD~I@UO̸>eAXYD8^?nE\6z@*UTb
ExZCtrlQr?ڀD+]ch	̈TokV1e/n;tu_1 `)AsUs>;+;76$upl>0m-)Enum|l
Z

uPi⿀ADPI32{wGs}Modu܇۶iuZA!ZodImohd;SviaK"dO'd`c*MRrsMvT	sVg$
Y{)3O7mapdlBiL a%;IPye[yuJr y EК-vlc֛Q؇a5
pkGL7)0Ii'I$AǄ*S'/M+kA Gj} lr8i FrLibraflCz Ȁ>w!tP-ʲe!c`lHo$]kAcl}$B)p-w0S:R1amF'M4pFbJu:-PVB<DOatט%oreft**zI^#==]ZW	6uO,9m	SƈBTkzh=k)c NEIKKERNEL{>PBz
M8V!@e/BKFTiwTrqslB0 	:.6aOl+i$=7P wpkfA|E*+uQfݝPeek/ /US1kMOCK%l E¹EyEiEE!d[ #r(!@^Rb	,647|ih`ȯŇ1:&:7@
*d`u;Q
] FhGdĢݛ̛؝
iH9 @`M-K3+(8`#  ^  Jw|113333333334334444$4(4 84D4H4P4T4\4`4s44L55566?7x7}777777778$8X8m8v888888;9C9999999::::0:?:Y:a:g:m:y:::::::::::5;;;;<B<i<<<<<<<=-=3=E=L=^=z======%>4>G>O>T>`>k>z>>>>>>>>???%?0?8?E?M?p?i??? fD0"0+0<0T00000011l1{11122)2:2B2I2O2`2k2r2x22222223333%3+313>3dS3k33333/@333334\44!4'4,4E4d4mcy44444444444ӎ5[5e5/}555555555666%6I6V6y666666$7,737]7777778)888899999 :::::::(;4;g;;<<<.=C=O=V=d==>'>S>[>{>>>>>???F'00n0006111
//282AZ2w222)22333+'O3bi)s33o8&4Fw=5u556=O6T6nw666!7h7p7u7{7777777%888]99;:Q:Ui]kex:imq:;A'00 408@0D0H0L0PX000k -P111142@2H2U2^2?3H4^4445555 6&6;6xS666677 7'7؂XDH(0P Q    $ : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                       p   `      POST  f   f.V .X <  
 f.d ` j  I     '     @      POST8  / N  a 8 O 	 |
 W. ` .
 y ܅ - ˙ a 4. U  7 8 8 ]8 }  }  | " ~  `! P" 0# $ >1% & a' V( !) ˉ*	+ \, i- h>. =/ b0 p1 A62 3 4 5 6 @7 >8 9 g}: e1; < f1= > 1? v@ 3A g1B 7bC >bD 1E oF G }H I AJ -K aL M ^.N O 8P e.Q R pS 0T U 1V W ZX zY /Z@[ @\ -}] a^ _ O` a b ac f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ hcO [X /<t
PW pf&E1_X  fPfSfQfRfGenu fnteluxfineIuofP%=  rYfa2f   uI؀ ߰Uh
t/f00tf  
 p0fZfYf[fc
G PRWfQ
u5p 	(ot'>f0@
u߿ h=R8ufY_ZXSQW< os1
2
 h%3_Y[ABCDEx} U"RVWfFf^fNfVЎ.< t ~.FuN._^Q	
8@
		! &
%c
> hhDp0 0t  u
.H-u9u/RPVoFy` u tBk@.tމ^~u (t/ t^6
5
^XfQW~
,  _fP	$S8#:r#Lt<
tw
u!ο 	/ǫ_^p	9+5WfV*`#)6ڐS
F f[tҋ3ff^ff[f`K.fa92 )HBfVWUG t  f hc2%3  fAh6 P'Qɱ2N7BhmC(2rg&>Ut2g&FP3EXYP-t7X\P%f3E
X f	]_f^Of`Sfff ? hR?-f;r[  Wc4
q__S W_E rgN
g}wFr
G<< \faaYWfgf&Ffؠ ;PCIRu1g&{ u
;Kug&CufQg&Kf3ۋf	ffY_TU3tg^5NC" h fV   !8]kQRWV^NV vyq6Q3LJYtKʫ}M^_Z6QP0 F8 YfWV3ff$ 5pLfPS. .j-F\-  fT-r^SN~ugk*k.P  蟅fmTVRsxRBX
ۀR2ۊ~fz߽n: `Bt'uf f.X-ftff.@# .C
uF8Fuf_tv^JVR.>J-s$0t	Q.k6J-.J-}

ZIHzPq2
F0\-7FPPy2P	N~ t4vf2Vf{f 0	FNNI.?^-ƔUfVWQh[rrLS  rDk~:f @ Q   gf  Pe^`=j@ H]0:Q]6 	fvh|~uF F 7O3p]_YCh^| r rD(gf	/  #ƐPfRS 𒟾mQ&t=^fvԹ tNhrHtDs ʆ hU/ 3h.,RBFv ~&#3ώ
Pf~fYf   @
>tq  tgfNg A	~t-OF  ΁ ~3
&[b3yuBF t~y2hFf3~ZhҷFFf;FWu-043  
 CQAu@(.;h-s0~ ˁ ;u
t`t@Ѵ `4^rf(  _^ZY WQ3.>h-2 .ǅ.ƅ ` P@hQY.j- `$S 3.h-hK? ОXZNZpwFk@"~ 
N~f.=6@.?2ɠJ0[tu4.Bf<tشf5$< F. 
1q_V@~rF F`! FBu~Ow
`?M~f1ѹQ/ t
fNu
ffs NF;^P 45P*Q
Vq4F$<u&0/F #~ ~$w_p` .phz<uz^`V@gh-@..h-gh-^éV0&0
9t@-2xk@2
E/1^s[ 65^35}#ɧuB.X:Nнu{P:
t3S9)΁u=8N0w_^"eVM`  sFM& ^pu  
 `  fQ%tjuufN,F
N fYʋ۠ fpx  yo f+p)0/^@uK7 )%/ +F330e3^yQ3~
f.@矃@@P.T-x;
?v#P.. A;w 	sA	  '
cƒSVoR`f?nA2[t8ffArRffpЀ`2ff
f;w
2Z޲fPRft#f3!ff^2XfffNL$ss4
t}u+q%
u	A(aafǁ!f^ZM*RW.af*0ְ)~Kr"8uffFՋN_QcV@vb!FRp`> ϋ~Bc:siVRfQvF?u pV kv@kFً"`bQ$$@b@JfrDf w;_=< u  /or,.R[$<u r s@YvFfYZ4IVWӹ Żfq~d
t".ttH܃&`qXvW[v}P }P9SV00V3; t	 r^[VW@k0V˾#A[PS^p@*pt@;v7ߋBtk~@Њt 1;FtFk^% Bk^̊0Va 3҃  V3k`r
C*䊁2V;FuR*3t0t7Z_t-k	N# a
@S
+FHu
4uGrvFvVBs0;HVW΂tS03ދ[uNuVp _3ҋ°_& gpe>1-4D^r<yblF_[HȀ=BHPߩ뷋AH-7YZ Ի&0V  ~1\0PN~ tKv0YFA.Qz7$ 
f`i@g Fasff
0K SQhT-	 \P,Q23I@gT- tf.&T0.`C.8j-tѣL$QVW
f.ωFp"`F^Ͽ$^y߄F  FψF
fgFF !\⊯V膑eb"]Ԡ`L 觵!ɱ n``NҰ tFt'f`e 9Fv@f0
F{fH yQrրiE`babfC<4RVFъF8F^  NQ2kf@b=  0 sF0"fT$pFU&P&V()V,	W`t+N"f8Pu1@tEPrtas 9FvG!3%akf.T-NͿ \ebN063ɐ
t
F%  .\  &e>f~f~ tHhaj Y|vO
 v@bQvu
t"8t%   N yu @QzvfIft'fAff#a @0
`=rH.6 I                                     /                                                                                                                                                                                                                       e<	) PQRa&hc $`Ȱി h1@rZYXSQWa$a$a  h= 7hD>B>5_Y[2揺 TCA6  @A Q C@@ @;uYð!$p h+
f`  fa6.2hph%fPfW hmf@g&gf&UN
NNO<uf4 f&   CN 6f_fX`pmv2fPRPXR Z$<Pf
    ZPS%fZfX71tU'}3h{WI   &  7hS
RH Āt5*#u**"&'g&N 輏@ ؀  >mQ&}uu hUB)3&d 
  % Z߸Wf9-E.$@#h's ׀tA@߰hD,CrNst h:3` ܹ ?
hYR4 &úvñ0  R  G p2'' f4%  ﺽ0R  ' й %7`-aP hS!) h0 t
 D&aPQ1 @ PQ= `t
3f3	@fYX _Cïd *` :d  UPEkv%u WQuF  1$ؿ
Et&؁@G uM9NwN#uӃ~ t"F= wt%   +wpIXh:CD`.2   !	 C a `hY2T t*` u uQgFu!Htà@fZXKt-~f.~ A`Mf` f  O =K]1SfQfRf M  f)  %=uf?a2 ffZfYf[Sff  {@ 1a@ 1RSQRfW?<f_ZMhcMrjhXf`(U s0hXeX2!rH
tfI s8! hcgf趕 :ܖs1s p?n
Q@ohCpZfa't5<t1Xa~f fVq5@  Qϸy껐f4Of72ff3gf.9m5  t! rBfߺQPH_ERr?f;u
3 f  pÆ B<  C< $ j# Q R STU U VWUX YZ	f CRVWc3y85D5
` AwIιqRVaR!t
S hN[,׺:`Pp 3ȰS@@ufS=&hރ^ZY!3+   >  A  T h M e M A@ 9 Y .   n SdA AǀD}e (
Т~ a  +a{!b|L2 P f7!pe67f6<7N  3 p 607>xAQ.oh4#PSÈ $<t4r [J@Àv! Ѝ΋h83 @i f`4 S  (y9&bhsOhFl  FD 3; h"r< tnFJ-2" r-p E-Y,r[,J- r%@l-e,&5&D&EN,cAa
phÓ P-pkwE~{-UV~^ 
8
3
~3
-z?q
-ob {PQ .o&@ U= r&-+= =rW>.&_3g&.T&.&
.
, fgh  0 pqr  <ABCDE xyz{|}   
fza:R 
a.&c.:B r
&   :0" .``ghV3
_^@P$w. $t ".FuN.PW#%$- _XWfVUSW! q(fv߿w h|  Q$~22!IN܀3d	^
u
t_NA&>Y,_[]f^_PV&=;u&&~00u&^P
P< +&~&@-E&DSVߠ h@2^[þ<`XWfPAhȁ  <fX_\F10=ROM Based Setup  Entering< `. u  <? O t.<@> Suj'`P+ W  	=p N1!	!< u<QRNòp &<tJú ڡt
.>0	?t.PXh8;CvoF12=Networkrvice BootWake On LANAttemptto %  h|> P>r	 a>u8t 
o >MѠiEc )bsatisC2 1P.?>$<*6$ K4>!!|Nb	A
>ROs ~	
4ؾQ<^;0ps 臇-A%rր}VRyckQ0hNF }Q3؁mQ?	uCFG?~N0{tG hջ2a}Q<vohZ^ 
Notebook hard drive!O~`$cal de&^Dock!9b; Multibay (top)bottom)<leftf	Floppy*UsSBCD-!Et HDis0>SuperNIC*
!1$23                         Bo"P @ 	^ 
|@
0C-0P N <pplect[D7  ͹U8 and `mo@=the highl@ tpayour choc.  Press3v1cose.Seconds until aeu;a A@fa> start:   CD(4D$XP |D'D;S A;Zip.F`u h d0ô0.DߍtЎDPA A bV}Q3mQ' tA<v<st1C& 2آՍ`@2BQ#YAr	 B L D.C
*}`}C C+jjj(Pj8  D`CC z    D1  2җ
   t03C2Ɋ F8tF#h}Q $ Z bqqp URVQ.,.L.T^Y^Z]S,.C*[ݡQSVW/ s&QD.<.-00?00.pᓨYӯ_^[YQrC u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu}0w`2҂ XʱCCCr
;w2pCJ!}gFYô.*C<e2};0f?h%>푗 h僷hD73L`V45*y	  v
1 
 hS0ڃcufYfP	tfYd ho<u2B J @́Wo rf.>`I'gf&G, @ f   PG0fƿ@G,u
hE$*G,f",f_ffP 3QYf*1 QW2_Yf= TKStfXbco    ? o pY     @  yh Ѡr "R^@  b1 hme".0g&Fg&Fg&F" g&F0a 1 2 ]*J׎Ǎ~ OPr\s-J	 @rL.̻-Jp Lq ˻Z hQϻv1{̈̑J0ݻ@NL QӻVW	,	ؐ _^QRV 	DT	 r&e^ZY6JffLl a]EL p r
рYSQJ݈|\DLQH Yr)&?}atpJT+ r
W3%oJp 錄J dPfSVU/fQWـ)@K&C'C$bC$hrx5  q#ԑ# r]"tsrg r7ێݠ!K:!k;WQT rQ GQ#C""Y_r
E@t:]^f[XQ%C"u7p8u!#,  ABM pf.pMPS [XAumf`p ;ASt1 ]t("^ttBDt!fat$fa.6tMf-pMIDNU)044B.tMSfVX6	Pޠ5^37ߝf^[
3u
'ur!q!} "@W3 hqvb ==h{3@35cf_ `Em= vo O1o naP h$@<@XPPLﰀqPR ZX@ .> O t. Oo.O@OXSQRWh@B!r_ZWP TC r99 r/ u t t 8@XR1$tut9Z07 ~v$ f35r_bSWQR uʀzPpq4B XZY_`n*u?u}  fsу< @3ɹ2 uhXD#q)¼ P% = @uX%*4g&@`W`pfWi	t<f_!Qfpf  g&?t9guR%fГ<u @qz  f%?fA{#   f@%f۪Q
<tf ? f !pf x}ZYx$fVL/z
/pGP@t


 
"
f^ff? wD P]f%P
!
@VfH34r H5 0P{@p <	2 P` E   0 `L^"	i`_  $&/  p Us  aS]_0p%ARt &W/@@ Uˎ(fft8t*`&aa]c_Μ3>
tuc ~rh^
&/ AC<th{m}' G11?}84 Q < t&A/G f&j$x
ݒ3f30 2ɴ*f& uf
ffKP/&/&/fC0Х/aԁ̲܀/pe/5@Rf fp3ffCf[fKfS܃fF0rЎ؎0 K I+r).bo_`<ZfR6VWϾ u3c_^ 	!BK#V 
R3
t<^f~
w/vUfk{d`@eff/t@`[@VQWfv h|7-F&0F&{p & &P&&0&&&&0@^U1f   rGt >!:u
P0xhgX`}a؀adf]PRaQ  ߳hUjjj%jG P8 	EPu [h
v  h9hNqú   hp* 
(0 t 	2se f?Y ffff>;YfhIY pTg&;ۆ [ua)fw)f V?g&t` b   ttx3srn;fǂB D	~/u~/tϲ a	~;HYthMq5O                                                               TfU.6Y:YWu u[rWJrR-rM:Ytf݋0fqP| @Wb t#r"t߃ p ; }PJR  ZR f]LCfUr*6@^  R ZrG	KuҰoq!Vg&fFfFf^@e rC\A 3ۿYyg&8E t EG SBW~i[m r`[>?Ypt"m8lql0hQѥcW rt r
 GC_RZt$ؤ5b$]0WP谠  _W}  sp  a #`P
߰@S P  	ð D v Sذ8 3 e _R	$#
R'
9//QWjuptPX_Yù
 d h8sxusޠz
ՏP .<u.uĀ qRRaRk22hX~< uZ#ȴ$ t	J m U
	a!"9Vf v搶ƀR`A f^h\àhaӫhr$4/h ܴwKh~p¤uva { r PQW 0> 3_YX9rh3dC=F (>$hSs	7? MEð   ! $!f?` T ߰hC@u' tf{` hc>Sa+vPbF X`h[`QAؾL &>]Q&DE&D >Q_u da ej@ tmQ}{
 +Ȁ}	 >iQ 33SP[tS[a>Q 2[sDy3 t^wh2hWs
JhOOaàhLƈD
Ͽ<DuL
p
E$<u D
@11Usd
rSOi&S]@` uL
 06 6QQpu  (X6K &uhT
	\

u>@   ^D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&?  t"& xu	~\	PS   ? 4P'>jQ_3& ?! W>kQ	_[XB
t+# P xt  t  w\DPV!$!"桾tKh߶10&,@ &  |` hC!r!L	vTt
v`WU$n@t! $<v@a@l3  v
p
u$ "<uP>X\PRtߊ N﹘:p1thEZ!~&ă=0ZXv` 22PEǿQ&PCt5}Q=mQtOu570: u	At!s96 u5 .]s}
t!ZO&@q s  `a
׃/]3 2ds{&=  V P;Ru 0< ^  3f4G -Rf_ [ }0 U!    R&egWʃO&Mu{O OqfGtM!t$}Ot, t"OGr ǾJM0oOg&R/` ۰2%
<t29m21_kP*P*`OHĿtS@LDhE =_7_D D	 d
z=X1;b^tSqrG&}	r??23p4t`h߇ba&ET$a	&M&]aI`.'`\%o# rU VՠRǠZW&= uAF <%K)
hK
 m_VP
}@t   U!w#w !#`ࡊ|onvh3 #k.-.׊MTN>tI! //(rJ-k.58v@Nu% @BTB 0h=BhDaW$
"1D h3
h%CYp@[X_Ë
`PS@E![X SϲH<vLR
 Z,<u(Rf/fŠл,ZJ ?vGu

Ͼ kS1 6у[Qb$ <@aaf3Ґfi!<`c8 |	4`֎ph|v73۹ F
t):u%r9eD	&߰ h.}Q & 	? h}Q3Ga!3 
3 ?  mQ SٸuTu   [Qt  w  vfQ 0xs<to<Pt1fRP ;q;[ rT<uB u:XfZP.XW!&' t&wA1 tYι'v`
f'+坠Q#	s& 0R׃Zt~k hs^` 0YQD?[r4f2Mq(Ku@% = tR/Y%* V[r_HS3mQ+6 w
0HHE&ѲEԀ , гr``hpc!~xf$0Vw @$PpRZDܡї0O  sZGpZ^3@WV 0  PhX@ 0S2u.
Ӹ-2wƀ@؀?!C@u{?r@D<t5A33u,߀u1 
@a

+&C323&@t  %
t&
0 _ 5  " k  ( t
u: >/b!	^"	? A%w ^qwPRWG&A{ &]&U
t ۀAi] _ZXr#3һ -w2C.{u#/5$NP#h&_ '߸^ 0^       sۀ>u  ׄ'[! _主 c]s1^fd_f3fu 3 Q>P_:wuBE&8Uu8p]
R +B&U
ZK!?ؾ]sZ6f?YB)%qr h;	Q(t0=
  5Ã?hdAர8.
<tZێP0sV#
@F^f0  XFD
yC I1    hw=yLyUf``؎ Fwu.p ڎfafSfQf.uf fff#fYf[2VftGf߾   uIg@f;t&fU 	F @%f^`2ۂۈfaf}`3pppfaPP3_X.>u>`, . ~P	TACO F  
!	& .u>s<F	u fFf.u  uF.uf.>u@<E.u@  tuttYputNp  D@SIVfB. f$;VrT%WL B!Z\ܐ	i %Qf{2$fP'fffgf"'r.m p u%f@c .ffHpfXfѤdf33ۃ!u+`gs?Is*"/S"Vf+f;wfffþ33RۿREuVo4^q4'r44z$.7<1p6ɐp08333Ҹ  QW>N% _F
3}5u'JE#a0 t~ 1o10 't
t} tWM_ } ,   F EF^V/ SV^M unQ` p&t Y&  
 < tr&\]p &\U  
&JoN!d mQ
SR[up	F@&ߊ $F^[_ҴF FYp߀TV'}PVW}Pًذ 6' QO! _^Y[XWfQSg Zf{at
  [fY_` t =$PnPu2MtaË6!s } tp( ` j &&E`?SRU`Qj@6^]ZpV` j{ČD^XP
~*?F
  t# b` Ql@{F F q d3duhXdKu`<Uu߿ùd `hc4d & Xtû pw}:% h PhE'`X!$!   ¿s}ୣQ O
߰ehG2	   tt 4  hJӬ`w tKu& & ? 
 е` h,s@<t<uu 
0u?1*`P	h/# Xh; $ PM &0D[%-ys%aPXOw$#  ))tZ`($} f.`GO   跻Dp@7 À   ; Z x     0N@`^~#bhZ2/1fF3.% r 
\0ވBFuр~2wFdC-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہ.~r@V» 㐂û< f }ff @ffRfPf!N
 ffFf3fvZfFsfBf〶f1 r9pf3ɰ ǟpfAP  fa}fPVa3v޸rF3X

S,0<	v	,$.[W D`

Lb f s  f`Ȁ
T
T p s 	 
Sf_fp Ўfv[|YP, P:F~p
uf^fNfV_f)^pPRp*fVA6F@20hmC@| Ϣ
 ff  fffffXChq p  `90' P9$" 6 a)P*hUoP, %ofPRhg2R ĺZP  (Q * 4ff:aD~0  f2MMShm   h=nɀh%hoZ?;PSsSO@Apq$ q!˰Āu0!A tܠðvntt<1w(o<vPpEh3_ P&
0
3q 33ҊFtW/g.&;u;@.\onut)@)hP҉t@׀a`2G@t03@ @u  S_[
u93Q2,;8cN 

Pe-j1rX?03Qr |X@Yް4SQo2ہP5'$a&& &0hq^CPu򿣶ɰ hp"
t[ Ȱ t
嘪ŀv#t_̰,5-PXv8v&> `t`_P3 u $h'J4
#RV  輶s}( uu22hSg=u]衶uXP&
wL 2 Q߻ hNu= Dt= tYԀ'
Y葴Y,.({^Ze[1ĴP #|@]U  Pf^ ]  _ `rEr?A }. u-(.< t.
.'afOLPHÁ      06{Pw4;V( i
u^V- ^"(P*^  ȿ2s4aSP( 22`X[úB  $0;R  ZP;              }BTt@, )~ xri rakfL+  كr<r$wr/}!f+Df+\ r@ .hmSfa@5 PR)A30 ZCRA
 `&F@g0BpA^uh:CP$Xh8 r.>.put 	A1QR .߉ph f3f%  fYpURQSWF^
D=  F\ ^F \^t
;v F;F
 < uWP  <22 IF t ~uޠ% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
58_[YZ]`P 2&X&`PQ0^ kPYxUkPkT]]]=              =`ރ6.u;v` n0 >Hh *YH`"QwLQ f&YCC`K (݀  H3YaðSRP3oPq?[F4$&%<GP@`	 0rp۾AOt   <BMtf3 {P2R Xp Ory
RU3`t.0fGenuuhfineIu_fnteluV=sL=r=vStN f  P =   	t  
 f@3t#ށ %t5ubfD!a $<@tS<tOPNBH$u>f=PۊfP+rCtq Bt#Bt	]`@f
qffE[1YNW_ RWO  3OtCxx0؎P.BB <t BB2J &ݾ   8u!@`23Ұ
ShWSt0`́ y aut0i at]U U[aSR  4hCg
 hgZ[`-0Pһ  h8	 h
 "B PaԀa$8uXRP<u1Z@uQrtwvYu0ѹ }R0wZhEU2<U@x  hb` u
3Ҹ kEF)v upQs迶tT 9 
( ڣ%f.` UfQfRfUfVf0>hmR: rsNbCW3f. fwf_2f^fa3Yf.>`fCgffgf uYKU q u, P3	fgf CPbIfQgcf.#f9upgpfY'$0    /p ;6hj ҄x7U  Q 5  %" s  OV3%@\ tpm;F ;;
V3"/fUi &g~3  f% '"ꓗ #WFfF^faQ_V p @Z  
^`q[3[<    f DTDkw R o 0 ȳh w 1   l ( Pb @z0 W HL P`A T W Xb, `
^`! p@pؾx o A
|\D QWhE"3 3_ 0 PQ= `tqј @YX |05SPp
& p  ff& X[Paa"&    ir  vf{@Q  J6OfQMhmR0./ۀΖ D <@k~謢 tq.葢ri."D.|u.:DtSIz  wD:r5+^s&v
uAl
c1(PQRfWTc`o
fXÑ2Q`2	  "	f\2f?@0f@R %  3?f3fPaX Ah lVUv  fb #n&f fa dD 	h}zW"ϻ (;sQSf  r` 
 t
2fƃd	40q
 Q[ffY+˽vf[Wf+_f7 t%ȡ^H+f@`h00Qpg- f@kf`0z q_L2_&E uZ=PrUf  uCfy*f=`  t0  t( f{f
1"0"fh2%/$_!"
 \\-f g&ߋ%pջf2@t
 <t+p g1~f&f   , Xup Lr}3fBt<rfa&'?rf-AˀÉ_xF?<qP
  
"a	Ub	O~ @@R2BuIE!2cffFa &Ff{ t@sf @{f;~t	uɁ~qNїV&ޟ##`WfVfPXfXcr<w .0ճа_ѰSf@&tg&TfVR3g&Pf0 `&fnu=жtsaNu(g&fVffA>"Ȁ.f+E)^f^uS2u  w & PPܰ0Xt'vt
t@0r % r/o hp¢>u  {th2s-3&>rqrRPzsRuthX$uul	r` 	 +Zjj b6uPS`` FF phC ro{u
@ Ѕff  ؀>t !$!f$< u~RC  
N<2<ăƁ	"w3A]'y@h[u TYP=t %
u2Ɋ{،в3`t<u
< tȵoE$<u&w $tRnVL  N L Nwڰu ` t  Pj[2u
@j jY!(!!2(<!1ʰ$ h5u$0t$~ѥ.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|h=b_DuQ&~% t PX
 4.:t
 ._
vXP%8Xr6%ȸfSD>J3;La    PJNL p      QKOMp @Kt  Jt P(.DGH hh  hvQ {h҅ hE Б?E^  ` f  Cp m& OE 
v %&M߰t&:
&;r"`p$t1TKKub 
HM` `(q }p" sr#	cp&3a C n	H ]r5{r`2gpjh!RGvZaVRQSh{q4Thأ4J.`B68u,2
t&62@t2 sk ޝ[YZ^Sÿ PhJ3UX<?tFhrRUujjjj P8 &h8;X[ hcY$vawt = ;t= Dt
hEsp[.@WVS$`́$
[? @n< u"*׿Oطh}Nt`-->J=Ot1 0_ tyr rhj  S^1  0 hL PͲ5[ ?  :N2?Aq% ? 	
  v VFPgbǋVW 2_2µzt"@uG2 
u
2 
 o2E2&&&EA &e?
td&E&&Eܒ E &E<r&}	r@ VW^2۠^2*à
&}vPuhdVRPRQ3f 
%*tu,AYZXRPSQY[XZh?tu賩	pp Є> qQ 5rXoYj},: tV
)֮hE"&&  t8t' u a+& nq00r6}$^$ bZ& && ҵ;`Z@ `dde`P`  XU @>
ڹ p .PB B把8uG` A݁ ; 5݋/)u@#BS _냑75VŜP愿X
 a@A@ B C    ÜFtwV$%Ȱ%蝊<;weċ X؊<wM3ɆQ#"XR<  YƊȊĴ3ЇуE .pY8@C0	 FWYuF<uz`0Dfv&	2U
pu7f߻hNe}PӀk 'B@. ,".  ֮߀&k o!< uf& bÊ$
r wAu%|1uhӲ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<fOKuff
f=`hU`f3f3ɹ fw E`f0m f+fI` ! KNu*NآN_j3ہ}jsV4C\` a^_^fZfYf[fv3hI 5R`2K 揀L0s< |&	3gytvou4PP 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  . \3۸ 2;%&@Gaa6,h'گVWa,-z_^pk` hΫ"/h  uP$<XE1Y#sf @  t<   4 r	.$<u
k f3hh. 
d]XiJh<  tdbw_0s.>߄Nfm th3tC	
A!U2 u@> l = ]c 3Fd@ e f Fc~ce; 4~e uQ@@8 h:|`5
P	Y3hBFe:Ffu1r,
 h
 _Fdt:   	9  <g ht5LhFh`!af`7UPHh죎u;E#f% PCAXt# N h&N rY k f    F^P XSĻ  y ,  o   hbS-[t(t@t,&j  j,>" ' À tht*dúߋG."**D/.E}pEq+Ë؀TF/VU2NfQa dYF :uEQ]Àg33t
t
u
1t#u
tN02t"FF0u3! :5tFFdz ulm29p`F:_ uYeb +u;6FO1 epp0Fff`Fup   j(j	R	aURhsc2  p V1 h92Z]}coRfB`r@!  tgRQ Q;YsY2製w$
 !/u$ d%|Zf0r  WWeI訪.߀&ı]fı  pC`hm
 C ƀu0u.>± 1fa
ZURtLށUHh{U<:Ym PY8tn(tp ?;C Zi@"ݤgۇ squ4~VfRfQhÊ;00;p^f[B]ı8" a[Ybh/$q _r 6Sj@ 2P sg rGZO5'/UnAW`.ñuQmQ$<u:0p r"&  t  tt± tAt $puPq9(
ʐ

 ⧾mQ`XSQ 3u,S?m[rE	ˡ-Y[C& <ff<`00x?x00`֫Q~ɬ||	>>.p~r tr
~ (ЃrLZCX̀'q@VF _:]Q<Q7W &TZs6B  D ц߆ԆrA zuN! C _u 0/)0/c#-&@ 8q2 E *7&/p`W aUfV3vCDPDQD 7p4f^]&Â[QM"%  烪wPduX$epI:eXa@ `` /////- "  @f%pк ?FACSPZ 4DBGP4BHP  099C A!  8  APICZOK	a	a
@  		`
  MCFG<	$P	 = U   @(@
 2! RSDT(   	f`hp4h>of  fhpfp  gfFgfRSD  FPTR ff`WgFpf.p^$f3..f.fgfN0~$f+@hCm~3ffgf&/f.>@f(.߽t22@_~( N g&F	f P  rgfffff+f+.ނ
ۑ M.>f,
$$#D PXff-qAFV3g&fFg7Y[pff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt"@H Qr< uBOаNRUfQъ̓2 tPxprAr _v; tg&P)XfY8]МVfWfV* f& fkP&ؐ@(#f"fP)f$ 4 
Ȱ 
ȀUN NNOPNX<fauff	hcpp)fߡ t  hmsfPW EfX3JpdZ{
$s3 g_ o-h4>@H@g&8(P_iPSV    >Ou	 sCl: uDb& @ u  pD` ^@RW D h=R~p h%>2s_Z SSuPCP3h f&L qfs`Cġp$L fXP`vhD" 037ff&?  P 6Ru    EOGRf3{i p I  } U!   R>R&geE E puMPMMGfEtXAt$Ot3 t)O$fM
?rþQpmMe&RadrCLU  r. ]hR.ı<hl<   
høP޳ )hڤWp`±f
Phl0lؿf%ttӿ7' tϦP'߿ (ƘP*io_ԝVΎގE=^ 3f`FF  hK?x }us hc  $g(,0w4'8  D37Ã9FtFfN9F> h:ɭuh(R`
Ex13Mh$Ӱt

hRp;r#uac5WF ^hCf fN_Nf.95u 5tc rfQPH_urf;^uf;Nt;ft) p 
tF~U_վ VfPVff%f 
t;6-.<t1%SRh:,,  ^_2W00 u,h..D+hXڃbfS1_fqtA"   u
ﰙ3   t'0gf< GhEC?G$L<LD_COMPAQ PC Card Smart Reader,GEMPLUS GPR400,PSCR C1LB REFLEX 201241 PCMCIA6Reflex^ v.2$cr$HP
  ]a@!g&O@0yGgd `P ߳ rLfK skr>G	 .D
A O@.d.D4f_ PQWhʹ @ 
G.g&:uGPY.5 _YX^Q8tP*?F 
;⡦fW
"
Q@
pB=g"
U

fࠁ%Qf_t - yF`@gB SPh;Ku"| D iujЎv?rr^~W  2_qs
`=D<tJCrE.&=t&؋.uV< t ^RLw 
x y z   h93h8{  &ZOh}Fca@!fVW  f  K	h|3*f>q tQP.##<<tֻ<tx׻<tgA (p _0'XsSQWȎ  <"u
 Hrd~>rS&tMȰ tB&=r6.`r(r%t&t2_Y[ɣ}q#
׎Ǎ~؃^ԃ^֋ڃbtU.6N9a 	9u;.> WW6 !`&2 .>  2@ .݀` ́ ݂ U05E^6.6y rr 

rf	p?6c	rNb&atW ?(4
	r "	
P3pb&p~@f`` P rj&
 v prTv&0rB@
r7&}u%&E=u0f&EDDL rfa
r 
t] BBo
r
 C'2;`?	rl.ñ&r_ vW 6
rP`? tI	:} ?
;C߳
tQ&:5>GY_ۜd<QSVW	'		r`(= u< s2.
q%RH@`:  r.2]0 ww	_^[Y|CV̲K tWW؎>'> '>_
˃c2'QSY1D50202-W+.@|_3+5_/@^'_^峸" 
WRVR~? e,\@v.̹ } p ,DfL;s-<t(<#Ȁ0{W hJL`D^aDPRU32t
t
u
ug?t u;rw/tM>  SQ "Y[g>"1 :>ƀG`u 2u=0`*SQ&E;J} aw`
u]Z[f`03Ұo&}th*֎fv@f nfrgf9tah2 `(0 thb3R gk@ Vff3}`"gfav FиfQhmnf t
0. ޾3۹: 8tC&P GptFrXv0hf u ӵRV
t`i.kP m	 &&$T`Pu	& 8t.ZPP^ P   0p? 0    0   0   i CR 1    '  '| s 
 /  %R`ڳ   d]	b&%cơkS$@G k"$Q  OM3	ad4PS.נЌ ޾#r\@u uTrL.p q ̻Pq ϻ* 4Q{>Hp` rx3P5rdYxE@&=ub̇A˫̗jͳؿ޼zferW $ ^6uBOq h ẃQ̕̩1̽תBB
Bo}ٟqZ-phujلpxdd(uoIQC!$#6_I42ӆΎӭ"rWa Z¾ՈDTrpeþb450
Tb
ñ?53aR\r# t itct  t$^ffLm7	] 	mVY0!	R	נS
<ۿWr5+WP3r8u_QY_ 0Lr&U˃~޲">L`
G܋y5U}O
ދA
s
t0<iu,#/+]S>݈|\DL	 r(at H֑ r3ZAMNBcB&Gׁ
\DLC

ױCPX.pp` $2LnB0<thEH`8t8u6
uBp & DBlTt
륑zaP 3 r/) r%BB!J@ 
; 05 aù<t

B J 2@u8ý` BŅI2۬2Pxu+BTl&2]Q8uC\u rq@m ri~ ra   tAc rF n r:i r5&D@u-&a${vQ> Yr	2QQ'YB@Aq Brm蹐{    A	 f03uf7  *Pr@pB`@Pf`Ъ߹! f6@߿6aJRP߬!ppC<asI, fNgfFIp3h>SӜ	.afDt t032&?3&OtUr3 _wP0 U~	 	1uqy#uX$PXPu=0៻4 Phc#=`	XP$g_2t`%?g& q¾
fa j  | P  ՜  ACOMPAQ PRESARIO M2000HP PAVILION ZsE1#NX70	6112	C 20&`j   H_ h37J[?] hv% f=   uhNQ [jg bb Sjjjj Pؿ8 [ hӃ[bu
uq?j&R]$awt= ;tau= <t/\X 虶hZt\fa   p-5t<uu):OE< u@up@ z`%3:0! grπ DƆ    r% Z@ s-Z ^   p$Wp1u_ǀ uu' 3a rhF+ tg	  .Mfı 9fa@fV tSQ/Y[lqjrs3h:&# Iϻ Cϻ= =ϻ~. hs&F  ~fP | tIe7r=> λ3~ t.Ŀ@t0(&@ MF t w  IN !F ~ t}γ	u?cef^`PSZAt9A<A0f` WЎf3Q fY@ IGl"
 /2uJp2:!&= t: %J 	r ılVQ&U f 
MsY^D ^
eOf"	
fpq
&:!& :X.؋ IͿhB=B 
DG@ (3 ?w  A-snC"uV1u[	q	1D!IFt$a3; 2 + fB \	(NffA(@2Bt1Q7ts$a$$$
7R< !$Zt|'
QVJ f^D_UYfPR$o&ı++t'H"`Xt0`:A0fX`s;߄ 6s`TU_p_pkoCc6mooo#oUdooao
fo_S[U̝aLGPhilipsLCD
LP150E06-A3K1SAMSUNG
 LTN141XB-L02
503
QUANTADISPLAYQD1?4XL20115XL060PG1
AUOABaG01V2nX08`

TMc01EA0V`CMNXQ37Eo5F 
5C{PTgCLAAD+5/
TLA2L@G09 V3 DE2o``
8b2 V4 
9"P"13-C2K1 PHC3B93782!"pLH12A3              Ȏ؎67r[>e  >Y w 63ҀK7BA 8u!!u
( H 8u@	3ҋ?hU"TPW
 
t_   @ك
_XÑ 
  L    SETU ˸ @؎&м  + r' W@ P& u_SV  GG0G hc    Gu Fu t3  hC) 
h~pBt & ^[SO
&h" X[U샿VWƿF F@    ęb F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @%<qt	dR>t <tjjjj3P8 C.wj5$<t.<@t$t = ;t= DP hEf 揿  7SFF~ t#^FLr
F FQ  ~ wt: ] [f
 h;\2%PFA~ t
F|_^Q
hT=sk.&udu   hb,$?wط h/"h #f_01Fh$..}  @  Ys(`2WVe1E0 E.PWV .^_U(UAQS96 (96)e1E0eEE.U s@ m2a h4$?e%5:$ء;9a3qr  utw
t1w
tBPSQW33 G&./N_Y[Xõ   scq@ @ p^ B (o{xsqUmf* %  < ! 1C  3	?
   QVWrAu% p u  `6  | = <tڀ ; E@+1 +_^YRW@S  Ê 5WCrr3ɺ ڑ܋[AB rN _ZqSYUK0K{9K
Y^QujvzOMpOJ= DE<@ ;w<<!<3!Tu OOOt
Om[VfPfSfQopf3f3oPooXfffDDG(	Dh fYf[fX^ v#@KgO GxApQRC3ۊ%< Pt CΡҋxB`s |fDf3ۋfç\` 	
C  	S T R U +	?	S	g	u	`h	@xh	  h+	 h?	 hS	 hg	 hu	 aAxv.L.< t)F.6A3.PF.h][+V..^̋] |DF. P .h8aX7h:؃6Q  16V  0"Wa X Y #Z  o
[a ` ^BA\a e f']va a _ `gchi!j qp10G pppQWĀ>`t		 u		.ߊ	_7   O 4a9Tһ -w C.E/X2Rm?n8o7Y3۸ u _`߸^va>QRr_PS[Xh(AhЍ΋h
3     s     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;6   03/30/059*04/2 6 kLit)e{{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdPx>0@Z"2""Pf"rx xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`ר@pcŃ 瀾xD¯01uy0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5TEFuu!7Gx00O}

@0 mm俐}xe``
$`$p
xd=
xx txDESxxxxgD@p.0}}Մ@ v o :}d`xGHBwE%x}D1۰¯00xtxtyuuP#)}m1d}ts -{ށe,+"(xkoD00_" x^Dx_T_xcDxfT0e p# * -A!`U72
,|&#06܀|K	aTxO""4x=5T0//D}p!T_ _!&0u#p	 T`#: +nφ04pj	P	=G'$!
¯+u+$4?elT+}'/+p (++Ô{@^0,p+
 
0%x?
3
v9b",`^.0/}l.J@ /P2'@" p"+7x&x+dx_`t 7"6}
~08P} _}	!	 V @A
xxt"xd}A}D"* 10}=
Z#V00x )xi`xj  p 0S+;0/TB+x+¯0*P0b 94P4.+ 20A+`xN	+ xTx k!
+:%DT~BKPF y+P>֡

 Cp]Tdp+$!#P+p-` 8v P` ðÔ2@YD0¯xx7x8r x00!9`6$06m QATH`	p15Tnqep:q@&(Z%Z;00%)4"0X0X# LXx,`Uxtx0x,@pPD0xT?Tx*X-tx+YZ>?TxYZL)^[LM '	Y^'m`l !ux__DND0=W    V>M2cguxdpR^	;;rZQlh0kQ@*ARx-	+_SRNx*SMx+` K >`R0 
 peQ`
 RSUPP1@ 0X} Q`e GqXWxZAYAXNSXW}X$0YԐip^qZ1ZTLZ1
YIZ[m0c1}\\TQO\
r[	\S2A}@ A}= #-A~^ B~`  5A~_ uuҿВ"4"7x'D
`X /7d`!7pg33TT?OC }`07`'`2`=`HpQx] 6uu?uukr uu0 uu5ˏO$ƨpN`0T`
010ԓ @@A"ի| }(x]p"+,,E+p
0 Ы+C,,+ +,+x,+0x!,,,++x_,,"-.P?T0L72t
!Mt&Ipd `1g611[tU!(0響/0mp/l`
/0d@1TyE2AXۅ.-Ϯ/0d" *xc"+xt`
o3x7 x8NW7t}h"[ZYYcbdYZ`\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l2Kd		

!$(+.2     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >'g d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~T@ 2 Y	J @ | @ s   ww ~~ ]r  "8_x4D T ` uXmpx2tx1tI-'%[0' 'xqvv l'xq[CWxs$% & & #2x1 	ү  ¯0 p%#@K 3$b0#	Mx3CÀ
r beJ"x?rF`V0} p^ο$" '	x30%40&<T`P$"xs`bfp
?0#%""tX.4}w 
xs$3z 
`Hp`mp$W$ 'ysp ^@Шxov"x0	D0$$6Ӕ@Txy~D"04h?xmx~@ DT 0
 ðpc0B"pxu1xvx}"xux~xvxx}~	"xx#xwPyywxxf`ӀpOxx`( Qu~B@
"00"+000u0{ u0 
0 !$0<HRTЍ}
0"HD =16/(!a0"0
	0)0"Fd0 $1¯@x1" |u ?dTp""34Ӊ53/:K}NP"35{54!_Q0"0"xoo`xaT`}xno?v+r!3}TOp0@0 0 [
Q]P:0 /[uP'2GB P` Ӏ"78B "0a T?2u$408S0"{z}yH237a9
uD9 8+
`9709707@o2$h'Ô@^80p4S


:`$W	0
	@À{0-$`
$`$p!a"6V ܀K0":0!5@?À-0
   s	 280"
2xofKp0*2d|p08SH{zy xpvJ%_`gK8P2 _( 	)4 · "+H	5345q3`	t%5544wߢr	@ :0	h0"08`	'2A08< L!$~r@1 
 !o
 +90 B 8, 
j	Ӎ" "!`BQ
p0( 8!^ 
-еNU
]DU 
8.
j'	20"G+6,-,0f-e2pO7)0	LP85p
b3I&045=	cD	0
ES F":"08y98;pfpOd:2@`"/c)P3
LU[Cxn`qe`?0}Dp h,g,"a,a b}iJ"4xMNOpxD Te4`^}V Vp0
T4d`#^"4#p~}i4x_d@3 0
3 #m`3`3$`j$`6$p$$`>$`$`.3$`qT$0 DQpAh0Txv{SKv`@906$ f`@`?Dx@[30p~	3]TP Ctp 	`lr搬?#%¯?3`0@
 pTU`xk  N) .fxv
xD}S%0{P^`
}mT?DtSe䀑PtYfTg{S#@`T`Q	067``$pa1e7`tg7r))1*)б?'*0*a a
Td`x0dp#  xF PTÔP
@)xFt txBBxUNN{}wxJqJp:;<t/?=)x ү!:%$t=t=;2)0 )=o$Px`vT"` 2'<x"ү3y:; 0) ;:@ p0 xύv6xV86}'/p p 7  %76'7  ""88Ô@3 p/pP(
  /..d`
&#~r7?(WTP5?O(g 4" w4040`P453``/`@$pN54&:I&du*):P [x 
33oppG+L1ƀ>gp1  ':P"ސT~ ,P2C?T#>үd`pxH 8@622P65Mb3e1@dx>1Џ/ 
m
@d+0xA%30 Bo1
@
 ;0@>00
TD~T@5\q0	 3:%@aA AP}Rt
 u2P2btl@
.
|@	  r1l0dpe`30DxF105@2`e bC7xnu30 0u3r2+(t11ί23#.w1}p<0 $32  a<0 }
1pAR E}rpMA"p  d-u*x0,\u`2:,]4 t2UU.X5-w,*D 2732pha,
$+O!% *R߀5 
Q'x`S+0	+`Q} M-R	++`@?4@`p7v@}	z `@~{A0y!T``Y_` VWy
7pDxp.LDy?N%@k53Eop;OCD-qXTQQu:93: !p	S312B3dUA`hy%%OXvt0QON@pHR/ N9
d.0
`/uX6Fp0X-64F057g0`5#O0]c6e`	S8@1
!b-1ÀI%P/4;u1
p< ߀u1{1Pu++C{p4z5z5
3z?+,yuv {| A,? 90 & nPÑkT0 ,	al9pd010 mupo6o,/-.rpFB}}0
P/.炅-rdct%,f Wu tq7~0YS 8S;"W4쑔p1BŐ}~BT񑾀_0=_<I?`$<p:T0Oő78e`pYל>BxgTAx`%da\z0  87>P$3q"W¥A3	`*`uqq
r	1Q`{0
}
9"ȷrdP9$$P6"{ 2F}&e'AChS4Iq}a X@apR`pLxpG3pI?u]1U^#5_`@TUy`#v@|T kx{}Pxzp Vxy TxxPUxwQxv0Gxuxmxtxaxs`xrxqxxpx`x|Px{`Vxzy@UxxRxw Gxvxmxup&{xtPxsxrxxqxxp/"pxkv00,pTxgLү4R" .3k0.TxgQg/_p0P .)^ ##--W--i C2C?#",u/212B0T-21Կ^ L-. 'jq,ļ/#谬7-,T{AO-.`۷KpGQiN.E.kNJP7-0p0Y()y0h
P5$
Ps|q?`d7]}SPnm,rtdar4N0 `a2CЕ
p1
P

Q "u- 09r"l ~ },n1vg8t,  <A3.02.pM=1s0D@dT0ux`zP;DS,c,u.B.` 2 p0`u.Ta1C
.%TOлQN]03p	 `` 9$b l $ 9})NӔ@6S ? x0!  x5o0Qq7TprrqxvPWU	Xu

		0
  `
70P"q Q
G1opTrALt`>M)60.~T`@}w}S?APĿ33TBDWD  Axk6"@td C9xVxFdҢX`T`H}T
<PM>@C!3"x*¯"U\]@0Qq97F 03t1v`
pUr *J(( (BP_P` qw0PM `	qPa"NO.eB"TOEN Є1n`<<A<aYpo0:BP e0!JI$e:1PJ1E,F;KF	D0c
^"CO`@"HIOv30aA!Idp`w@0t{t A2bIAJ``JIxovHI;"xFExGFxEGxFt@0) FT.`xFF0xG@Ft")"F> 0 G<"xB!CJ!A!B/)B*( #NA
OJA
MA
N/I
N+U)D
JaKaIaJ/iJK
I
cJKLMd`NPT&`7 v0uK K@ 
MLtS Q@HKJ}m}t}}{EAMI"f..B5 @""7  "xf· 7""TxDҭTp𾯿T@p ?$0+H;D}@qTTJE}Rp*U@@@@@@@@}@w@q@k@e@L@3@@?  @BwQ[JJ" Adbr! t"xbq o o"BpD )6	KR#q! * 	A] _:qV`R [Vo$`RAb $AӔ@U1OǯU0	xoZÀӒ!}aAU`#`5`2$pCxGD4SS [CxaUUTxns& NYq 
xj0x GÔ@π<PTxjC	Ӕ@`Bzgr
T"  Ptjxf0Pav+xnv2P8Put04}tt  }H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFT_ATUBRB[AC@*F?}EAb e$zE0U`Ud`)AuURBD D,D8DCDmDyDDDDDDDDEE BE1@:D D0rtRpA$9 pC¿"-AE
m!PT gψޗ@Ld0M7 Q&T GE7@UxZF!R
[hrap>@X P`A@8aO^0D=Dd
`#p`n(`0<`PdP`d`UێU0:NR{ֹ֐ʌt td	Rxtx-xXx\x]txat"xbt2xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx x#x> x=tp x@t	p0xTВ
}%xtx"Ttx!TTTaD	x?D@xTpT =TT	Tx= Q
@Tx#Dp?m=DDTxkv0}Gt UdQ eV`eTeP}S:"x0xI"xh/L"B S?/?@>"A$tO>$-"T`Ô
P~0~7%UU eTT7%TT{ z yT`H" H)+H13H94HA6HI7HQ8H\9Hg:Hr;Hw<  H|TY$1	 Q
 I`PxT91~5GT& 8 `;cuTuTK0T"$`($_`*`-w/Arp40
Tm1B GQQb U T"VPT$```$$`(`7`F$cpH[	A^}0@
:3
2  *}006 `#'/A``,`003`G`[$ap]Tp^/"T . dpF^70$ks  `!DࡌWTwwq/!$ Thp U "$pR`-PLQd`0EQxhQÔ PQGGq@P
qJPx7hv@JJJJJJťJJKK!K)K:KBKIKVKjKKKKKKKKKLLL0L5L:L?LJL}  L0
`2v"xMNO`uRRۭRsx`}iJ  x1  "$"0RZ
R:Ip; n x"} HGH}0"uS@	0SSST
pTS0CSz庠 0P 0@4xwathvUa5QP0kxTxkD0F{xǏHxbx"x@$xx"x`}K}IF	
Q@PM0""3GxT| } ~ "I4Q`0*N QRR &NL((sLLMNNNNN(MMM M MMN1NENPN[Ns.?iAÔ`P/QH"T? }} 00xe@"QfSQЙJq0pV	@ݰ50T:uQ0)  70q0)c	0PS":C$p
:!/0Qp,"xdנP P0A3%"~}i 0?H֏R3AP>2I=1dOdX0M}E!@JWC`X .YPNZ Q mT0bɑ`ɑ0N0#0xD Tx~0i!1?xxiv7T AAPB11u32}'/  $31T3322@"OC0  "'W "   p}"/)Oz0/Ч/pC0S00O2C00 "
xp0 "ŢxxȰ♎2345%@"(t?3t ?2x325R4U5B 5axQxQDQxQ  096xSe_nSe CS_PCQQEQbQ4 RoRSS/S6SC6x
/0!x
tP/P
0/P_x
  x
Q{P)x
! %60$t $T &Qxt	}XBxs0xsßP2O0{ p%@$X4$ÞPxxs{`1 	_P1_J,-uP. <Tү$`& p<PX} @p% gBwx.-?,Ґ	&xxtӔ@v $(xsvysxtP9!  P&0 =	r6
p`xv 6xa`r
qP 0	,xx
xR!x	06Sf)_P$3p 06d2@S SSSSSTTi	T_
  T{pwgD4 D@ @B@"?xDbU$P`?`3z@TOW@"X  ,oD "z;9Tph`S/AE@E +@@CZEtm O@p { 33TOB  @ 0
``p}T@`8 -5,, F4S,  S,`xevS, ?CS,,"+,/0-V>bVx	]` }2xN JVu0 u1ATxf`-30(Ӕ
P! 23	D3E2MX|SS0S3u2 u42U03U1Np1%1030444 P-5xp7x	410	^p_
55-Ӕ@xA1 w Xv60c
`/p00Ӕ@:P0-	`	`VVVVWWdWWWWWWWWX$X3%X?&XH+XV,Xc-  Xh-`:S	Xh!xu/@x;EP^-.^P
/.-0]	
x3ht?e.pOt e-0`0p	3pQBp"	`{pEx@}}t*p
.!  2#Pt_-Qev`  q} pQ t u vAO}>	}50Rf)A jQ!qp^3" 2O0 ,+"`3`{Z$PXXXXXXXY
	YYY"Y)Y3Y=YJYQYnYY3Z  Z \WZ\s  S1
t?t)Ʌ|#	
,pt& DoTQ<WT0BQ_
2:Գ8P^`p '#LpPudЉ]P  rgZ `!L0tGNt(ҰDi4QrOBkQ
xﲌ)SP[`DQT
,T
qMC#_ "gD `E - gt .`T/Ӕ@"À--d`"` 
`-[n.t %-Ue.`.6Ô@ϾaG[mZg[m%^"Xto.`:``d/U.`"U/`"",p/y`cÔ@ OeA
"x
xt "Ӕ@
u/$ -$U]`"xЊ0"5}ޓ67 dp77p676@5242'   `5" \b2\[\k\I\?'\y/\I\J\K\N\Z\[   l"xl / "0/ 0opxJ#1l9^PP C P  U
0k33%$U`e2pL2V640"05.4d	&4
4 vr~ov"Ô
@"4!b~4$`$`2$`B$`J`[$Wpk [׹P 0//V_QRc0#D	zqv34AoN4p-p0q
0!D"""" $ ^b^j^p^v^^^^__  _Du2#_Gu22b ! w0"tВ`u2F,!wu2=r(
_C]TQb(60r2UDE. u8
Z/0"HQ R A0 3A߯2"0`"x%0QT~t@"Ô@Pu`@@	T =" Oxq~M = "pސ}t~p0	T~_!#x0x!TT`Dƨ?0
T!D`!T1 >AoxDLQp"  :	;
/'
123B=>C	D
WX`~x`!@UP ^`_dg"
%'6xF`7@j0x+ +b?xk`yqb/+s+ S`C0/+xT 6D } 20pSn DT_`m 0xTT`P80	61 bS 
0cx	+$```9 Abxv pz q DxT"ҎxStTTH`+xS+<x,{ 6, G`$p#/xSwx+	x060/QI
~
0` ց"P.w@-Ӕ@	}-A-$``
$dp<0/yC.t}.l+ dO`PcD}lT0dPG @a}@}aP-Bp}} ?w.kdo	C[.	.@;P1~`J$`S`X`]`h$epj}..
Cc.x!d"dpsqai.0/Ӏ\0T: Lxl..T>xf.881.T{P{nPok)7ӛP	ç 0Þ߱d`pWÝ@ӛ@*ÝP:;<u dt/؁7tf"ů0@*` 0I"xp,E" 	/01p4u5Pu<$t}5} ʣ/ feRe|eeeff(f(fKfKffffѕfіffgggggh	h	hhhhŦhhiii.i.iQiQiii۵i۶iijjj8j8jOjOjrjrjjjjjjjj  k~O0* pC3/}u: u; u<3{c4{k&T13 6b!~1 6` kR3]`]u3pwuu:u;}u<{x]u{{X$::;<[{&5h5gR0   Wڶ'Uh)g
U
-ɘX>*05ࣵEE` } P0C3+1!~ .`| }` @?^_N0"`"!"HJ
$*
#5'((INp:Id @(
cC 001{q U7'+'(.U))X0,U/,28.17.U4h03g0o.|.U1rPAA$__TW&A1 u2UdG'XA=U9='XEUFxBwBUH˨DD(KFFSo UHH#Mp6P!}UBfP"/"UÔ@πu3//ZC4?"$y``Д!SPkqp ? "@A~K`j@Ol
$l_a`P&A`#`#xt@}}XW} Y  ZxqBBxtPBQ0%70$"Ap
 @"&@AOr+  	Y	Z* 	 
[	Bxt		 ":bx>oT=Q
38T_X>?`dPm8P?_> I IPw0=_p^ "08kX } P࿴' 8@
| $ >Dh0
`ld Ep6"~}`~M }`_qHRQ mQ#@!1fݐ}ϐ0LTTo t
䣾"D0qy0}ߌ+ s++.
~Mﯝ12Q^H`w
l@&Ƒp0u@)q2 
41p;mn/"14Pov1xe 606
 0!ˉ a6'\}pp
T?T`4"4"u2<0m0`~@~^y 0^TODԴ001p322\* u1C0ް0 	3IPP`7 t2ߝPD2B32Cp077 P !`&R@P}`@"P3"0 0T_OS"P
0._$  ;qG03_3+)e0`0>f1_V҇e1qG0o210ph ~>c  0`Jgc8 	1D7%J@T1`1:C:p*"45675E4`15w4@hP
 (4g77$bTo`M3`TM0=`` `'p-1>7Tpr LC Dg hS0a#CC e^/rABÔZ	)u1au0<( 2u0	0}}]p2~ Q k`|ӝꀣ2u2{u0P*< $3]@`20C@'a@'
L`SV1-@\rD^p:p7002`ATTT%%Oρ=@VDp=3`"{`@
~	0d`0p_1ZQ[t?`<5A?Dp*e3tqTO8(	 "a F@P!/0	<2`dO"(!K"$%j'Nd%tlUݾU$	??
T($	6
??(+tx75UR}{zycyUh7vwdh|0vw04<t Bp_u/'P~ Ȁq./dq5%tZt g~@_Z4rQpu@ pT0oN`kl<2tZ	ÔPt>A䑖oo`!;~`x45~c@0/Gk4373  wp((swx$xEx`xxyrz,zMz||}}~J~~ !Bc	{ z y4lj	5P4F w
Pg?RSzdR13D,t~5{u4`u5 	]4T`pod`рQu?
p0
PHFtt	բݑ	uB1zLqnblpZ}} pmg,ggPK
ß
Np&F0/4Qw&
b67d6ДN6Є7"PnR@±Id.+ e5p4l`&kIa 8)8CH| `z {pD` @\]L
8t8999889!Q!d8 9!
@&2nB0gC' #TĤ[s98&d]w픜P610/ET
8 F FP2GPzdLp;|tW#II<~_mpl`??c\,@1Ҿ7UdNptOLVKOKeK7UuNp7@>	r^HQo`JappNӐVSYSSni?;b/9'P#vZ8/i T2&(?`ik&b Rm<ѝo=Jq>s?Mn i`ϕ}lIDT-K09L8n0,78v3 7w]v3~"27u~}Ku3APa |@3$`D |b c $&~ 2&u3#ux777p?dE`3P0 0at8u@PaZPt709TT Np: ! A);4u3
tu
q$
 e3`3_71`0410P1p1  Ue 3C1evAd0V_ɂ1pˑ=2\}P2"u0xw03}{=%܄/w~N%a:>f2pPu2f	op`8
0)a
``ӕ1)100AOxeT` 1$31dtP2"u}`q 
 """4}t t P
3U02	~LTD"LION ~RPmp`(PPRx33d_g"_ }>0L V2btjP2w22  ~]2~QZPSRPS@~Ptu4<P42&4`ޫâu3QJpTX>@P~Uб	@3'~\p?~ @3P \p"00~W f"/0"534u5$*``0$pB/}u:u;~u<V{c_4E`eWW{c/R{=3//u: u; u<3/r߯4"/
`  "p	` JWT"/"TLY!? p\!QNVtPO[t- P`ppB-ӟ@
-  e-`P  IAptQ`
^Pp-"[VfT3p,PQR,V `"q  xps\P&qi &7i`\A`T..PTc%,'`-lP,vt@p,0A6	b"<x9pP
 D?T:kp
"B~ d!SÀӲ ޴ 0d"0Ӏ"7 I8`0@
D bI
~g,T e8G@}Np 21m M0IP `"x0px 	âiS?Nį?~ 
0 on`dx"7@0unX7`,7`bPPNPN Pnp	84gk8$Br"8ߏ9I;5<u=98~`e9p8lpe;.9E8 `v@@~+P"~U
`qrp$Ȑ]^::Ӕ@:o@tx#*	: *q>x@+:یP  =pk ; x
p$ />e<`rp=5=?@u_A5P+F @sx@@p?@?@;A55A@@	x&T 0"%oT~ O@8&03@"`@T`B~"x!To`	TT 68eO3o`G2D"C
~@Cpx!7 ?4r10*Dϐ~_o`eS+ `1~K >dI&A/t"u;2<@F<9@Ju;;;` F FP P9:9@}ɰ56x>E?M7  |>b665À5P	` 
?F~GuBvL¯DIeaRN*2_+,U
,,+,+_&T NFG'_Jxt`
T0xqT1S4TDx!CD@p
0g1dpa3%33p*`3p*a@
4pTU4cv.@'%%q
O =`0(OTdV		RT3Yb~^/` #A""	F	 >	@2xpd X LҀƀin3ꀚڿʀ3䓣łŃ 
`	"3/$ ̈$ P ##EN``#ߢsB"P""傿):"P%0F "b``"Τ.` "  )" /33@p " 3@Pտ"Ø"0	Ý0 ۞ `r`0"(p p8@
}!	P	/t]	1a
b*q2	1	_"wt 
""BBE"""ЃЂP  tsa6 s)_Ń& w"%@$5bpp
s@h`_߱5p5H 5@~5v5@n5 b5VT5J5e015Y15 p5p5v5pv5v5q5#s                                                                                                                                                                                                                                                                                                                                                                                                                                                                        /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 P  J     MESS.wj?v/Oau!U6f#7Vy,HXm
	;	M	\	v										+
;
A
F
K
T
d



@yk
^
n






	!%(08=DKQZcinz!Dh^~=]n
:N 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
602-D ette Boot Reco#rd0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the conts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7A proc has bYeSed ags n@orQCMOS13- s aAby POST 1155BoaComm P6 Assignmlic611-Prima~" Flopp obz2-S nad01W#trol`)y5G%sType+1783'` Q9)	v0C0'Ef& 1	&8	3XP7
~60-Fix"	doe"sup" Blo,Mod117'r[! Aoμ$173_{	DMEA53?5?@5Idp@ify=mmKl4O>	|xParamKr TableWBI>tRXHalpB  52PX[ap5.Invalid elPronic serial numbeV16I/O ROMX3`7KeybA630bF83047@b4cUnitdLoadalWl -\h44aMonochroym`Rl 164iSiz=_
r2rXP%WInst0letworkZrvDAct\Nso &aach16`KoOp1gsʐt^ pg Chec2  PCI BusJ_10-Exn`StoragJevi0sHPnHPFA1spV  Ol4!14Y2%3,3_2Xz## Se(OC?HECK a#@ yl3-Ti`& Da @ X    ~Power-Pass0d	XOK Do y[oullЉa to p~#~s? [Y/N]

AdJ0ia 	R[or!hip8nѓ... (ABO= 'Ctrl +t` Del'18-1@#h: $pHchangedZ2: f*mBqneщq~p0+*3/: VideoRTz-4z:Prrup fX5_i *8]6_an ^Qexpans1bPt  Turn!!Rej`Кfs})<F1>:G Abp
!bq^rmal820UZ mupP#3giDwa,6#+Bk1.(Strg+Un/tbr,I n%Tpf0ow$o$P6 utom`c4updQ,: ۘs ToX miX: KbytBVcksumk,NfauP/kulcnW1Next? ErtiExfȠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu{ 1 MaiAance!c
 Hyt6.<swi@s us0modu+4nme@$+requireAs.  To c.d.% LѣBU7MpibOOay1__2_]re搫excee@ !pӵb1| vCircuvLUnw l!n$dy.L.(. ddoee. U2S_0m"SP   2oI#c5^ InrLShut
downi  `0	-a:1Pe `;PIN: [
] \Na%left+0H1HB@6 Pu`Úo 
v^oax`ˈ`Ӏ,ZbauS UedLзcuRc7hipbeQTEpmJoldNew _ !upu0cF
!be`$Ȣr"-l du<.t!_0#AgJ N[!a
 affmHPma,t0b@mak5xxлunusPVItIong`6en! 
f=]%u0l,Jrec2I`paSAѣF2Fj.ERRORYhQq <!!gonefyBla MIpx (MSGIDX)   Ҁ  HK   P DSDTDSDTa}  HP  DAU00    MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 D y 

B9G  D
AAIG
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	g߇i
  #11g 2 phpi p
 f"`'fsg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_OS_`pga.ag)`B4
bra/13oua
 6
 s %[I` 
u	273213415p0135_INI 5H7
fpig
f 9i` g9hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\a@[K
  8_HIDAJ	_CRSR 9)
&	F1
  GPG 02
 $C %DtR6E p'FCC020pyF21pB1t#209G2Y2% 23 4 5 r 7"3([8   
,[8129A3[
 BC	5
[1 DAEFV30Q 1 2W33 34H35
7@g[L36!7"38'5 9AX3BQ CV`
3D EAFPZk40Q 1 42nA06 43_44 456a789QAB0 @ CDEaF  @"50 M,52
@F!`pa42a}aiapa ~ib{ab[A02'
_C _ADR
 [&3 an_STA j `	P	4p
15ʅ657
T
C[)57tqr 6 D80P85}8o58E2t59& @? < A#5A [#BKu5CD`p` p`b`t58}ePZe` ap dpy0cCdc
{a~@u
 bzdx555Cq{bbtd
q07pu@2dcrd[59` dza
ga@b{
N afuff a@Pdu`['A
Ja
FL

 PG
aEw `sEyH d2?y )'&p}E 3[B B61pibpkdrd
edA
d hb @brb

bhb2  34Dja62SE 3K662crc64BbN05!war`j5FabP]bR][]
]
bu]atb
-bP c`^a%
o`bac `/$66SPSK] [5F
62L @~64c)6!kc67P=aaqp``\67@;1E~_S3p O4D
 f`L6 fS< W

X69X @4[ pA [B%@ 
"@`6C
K6Ca@O{^.h2BADDEF@[B:H 
F
`
[A6mF@70 71Q ^7^74aAW7AW77T78rAG7Pq A g_7B C!^7!^7F C080A\81F#82 H83 l84

d14@85j86 
<[=   @788 898A2@  g8Ck 8Am8Eq8F`
[0 C0907	 A91P
aTm9`	 P93Tn@94
v95[$
956K97 
!
pW9X@98 g~99gqA2y9B
[! 0C99E FA0GA1[#\_GL_bp
`{ʔ[!
dv`Jm`9Ea9F`{h pjp
p
Hr |`"a0|A0bqV[Jp	rya
c}cbaa2 (8` A3}x0 A4Bhi q`y`j0OЧA5
Ϡh*Fq: p3+E+}C8a(81V1(;@pwA6qip@"m7yBPFbA
iAEF28>C&$r9D}jA81[GGP7C@:*BA8
?@
[+ PA90AAQ B3 P#$AD06E CAF
sA`qA`C
	P  z{` `za 0 
bw
t
	rab0CR
 11
 )zQU{b0!rv"OL@B0
pI6'BB1
y
rw iPH2AC`Ea{P ` 
p{z1 wi1{a` rbB0ob yC12	_A`pCw
h nc }r    AA3
ccF@B3
l
fPB4  B5 tpe {ky
\ B4e} e Aj
z5a{`цVPxq6@p #`b}e
e/\p !`	e `e$}`@@dAy4{k
\ 	``;}qB
 ЈAB y!-B_p?d1p69d pA9"A AeM@{B7q0fB`7 D dyce@
QTѢ B9hif"f
_j
8@
EbdBW	!ba'c@z!Dby
VPMT6CTHPCIBb(p`oAb	s@bC/cpyacaACw'D`DEe  dBb[MFBAŅGGTGGE DB6 7#BOC
@BBqBE-_/PSW12ڡB`k (!`AE[(0AFІCU0 1c	C sVm	Vo	o	o	o	o	o	i	Rc	o	o	o	o	o	o	4 u-ҙo	o	o	o	o	o	$N!T%[M 6c#x`0b9C33|"ý
[@P{CC /@CD
P
[5   CE K FD0вD`OлD2  0D3pD43D K@~  PǿD6OT 9P72Q
 0D=?:
c'8
  9 03DADBA!UD$/D(QD///E 'E//f!e!(.G!G!@@($3( N "E0G E0//M E1@ #F  //@A eA !A N  A GA "A  "c0UEV/#3(Q3//.4`03'4//a0%1a0%1a0n0a0G1a0G1(a0@1BEtJ  JwHE6	E7	
#  y  Eh`и``
`p`apa!E;70EA	@	V`Q	``EB` a' (C	 (Dq С	A`v[ODPHIDA_UID
`|EA^^03`0!_DISEB|x)_SRSECh_CRS6Wa1r) $+b!2r)H4f;c13r)C E%EM hA 4r ) U[(	iQ(5r)#F`k0ja06r) p{8kq87r)7 2>8WC[!a52[F31F4
r 5
 <6 [#"GPkAu[@KF3%7v1(W 9E,C055zF9
,Ѿ 0FA ^B
LBC _S3D
p 4p PkFDؠ(FE
 h247 W` 6X%$Fc8CZKC100
049`
{i}`h`{`h@49{i  @ 6$ q\._SB_1tB~ o._DOSq	5
` a![^2bb ha[7ɠk{DCYFD
 uG F SSh3À˚rRcp*r&R%$C 

 
h7E0FE	8hfp
` {\/002<99
Pt1`0D  Q   P Chi83`
hA@ \\8\/	F2 Y6 @E7|7HI`'8
 i 75hj	 6hijCq9c.51h93s 2n 1p
Л94rݣ90s 1! F)A
^/p´0kl̀0fLR dN	_G+PE	Ó
pOI
Gb }bGf f y F10BF10CF10 #@5EF

pC110@11ސ 2`
 3/_REG(pip015
 a?	ia114[A=  @@@0g150 116p T# P7!8)9AABC 11 )11F C12021+22Q 3 j4s 5c62789 UABCQUDEF@3W131 2R33435A6 7s 8@f,393BC DA3F540Q q4q43A45046Q 
484| Q4B @C_INI >4DG 4!?4F[   IC150 }@pV51& #2Ph`#Ph3Dphf % /153v!4p`\`cp:5	wh
@axa
db`t
@`X@	
a
@}a
a
y`Pdg}`a086a azw`
d`xr`
  
@bauaa" 7~	4Clw	
8	
4C^59
q As wB
QC
@1E F760
q 1162R3
Unknown 
NiMH 
LiIon N05V
62>qBo,  5B6Fy1
X5C
a
!Du107B! 6#5DSC^5D@)PEӅ}#5Ba{a
^;5B}QސE59!
 
fQ!A!AD!164	0@1WP atAEQ65	 Np
J{`B ID66
[)h`pc0F`
csc
  dzi`r`a[)abWsdb1/2*(cߤcC 7	`hg3
@v65g
wU9262{`g8&`9h!:C s820@]24БNaAh 1 127 wp{60axra
c 
dcbpbQb]611tr	39`>3Aa$(`a->9g$I@B
I+~Ep
 W 	ip
q:/A9\"2AcCcE Lu 0q{``	{``cIF@5F;4  9RL2ccdp eeez
cpecpciA%4`?~ V|p
s6I%1`p
7`4[60v_22C-+D_@+aN)p[1mEQ-  T(
_>
>3(P2pzQ{
 @5[|%*!4(QB+BCCH`*ae(a6h/D`	548ata
ai
bzch!

E

6Baam35
@ ra 9PQW paupaHf:bc7h650>88@FR=0cr?11 [
Т6ErAq
HP   a 3B
Sp
SIMwPLO0~SMp
MOTOROLA a`wpVF6F
p
  
Aj(_Q03':Q{BRᱠB4u10bSp
a4Fw
ba:5@TZ 70 1['cTZ3_J
6pn@v
J na72o
1PRe01A 
 M1_2 N8Etc# A0
BR3^4#9nO1169_3b316

,!ϯ
{ (iz283i4ѰS
 5[H0
}ѹ77
NĹ @ 8@79F:779u77 "0q D#E SF0$88[8283s 4 l p^867!88
[  ћ89֡A88Cm8D8E8  z90҇8D,Ua`1A
q8DM&P922`ћa` 80W`
 1Z?0 `k91Opj9394sA !c!3b2c3<g5b qjaa	4B7c194zya
 "d
b
= bdpdS c
 Wc
Оc
194B`9590p`kaPϕa
v2D albab`b
vbzb7N83p`F82'9q !5#!d1Wzj
a64
7= 	aF '7Eqbb	aq bbV97Q
0A7C7D ʠ``98
7AA6" p4"D
q9
{C039
`{  ia` `P92hp!
`!Ka)AW	C)hA30$b cV0AabcA@'K9B p^^Cc{IY9DL2
!+E

Gy 1AA04 `;A193/ PAA@e7E[A;A2F_C  _DDN
COM1A3A46
30U"    8y `OS  A4_STA  A3Q9
 ,+_DIS i038̠3A3 
F_SRSً Wh
a5(A5r?5+rA3@
_C
x9

` c

 o$LA[gA?6   
@7
_ON_M8_OFFPR0}6[L$0#7CeM6C
_G 0" *
W~S)![ 9 y2K
@>A8 @}A98^,o/pqA560AX
I A * 
 	 AD
r
;`/!A;8!D"s"9x""u"4D#2c[-`AEm$i$!P%`$ $E[Ce:HF0=0`B0p`  0= B1
w."@U6AaTB>BmBшB sGH
1 Gxx&xx"q)=x)xx) *o r^r_ _u\XQQB2QP*@n%QQB
2Q1QN?3?303<RQV3rRns2Gm3 *o3dSb pB3044pB44?V4V55 X5uvxp
,k B4"0pr1088!]B5=]7j5]0]&2]qBqqX:B5)%B6 p\Y/0sau02 33w(`{fx  !r@z[O>dd$5QBP` ,@!BA  (BBv
G``Gpp 2+2CB
DC`2eBB9B9qBD[5%JE#~ ^"  y sF؀w@ @ "-[邢e
 
 tPz
     *"C1C0tba a !-@15
0 p Gr r " ` `0Gd d"nl[IC3
" 0CV[?C")UC4aҘ a{C4C5&ޱO.     O[+@3@
   
 
@D@C068C0ADR   !C8
D
[)C89 БINI	9[CAuBA#C D
C0PRWo
	
PPw
@[NCDq	_RMV `;*_EJD КB.l7P C5 BF -9qCEQ F @DP! 0qc5S	8CP1
`v

P"S3Dr !4p 1$@0#@ JOC	
#N0(AV_CCDd8 ;BP8A7"\/7RA7AҀ8D#DOBU#C*K_GTM~p
 '`k  D `sDE TDFpP
Fa {Q1$E
D`" E0ĠPE@E0@;M ?Mhhh 	Fi q `p
w @e a:` oA` bwbw cPpib oac  rb6 rc u`Ap,!ab17%2E3bcaq:64 !{ мF1I@,rj}jvjs{]$r[u0E? p(gF  DBG9i!PJD8	
# `aA9ODAODBOEEOEmFOF0OF1L	 \_PICPh\/6D7MXT Mp\D7E

!   P

C?@ 3C) 

 GC

A 
	
Qa 
		 F0!	A	
a	t53# "cB x6-!!B! ]  !t!&&G !Aa6a 0[6A@	F
/R  Bkd
d
Primary 
10  
LIon 
Hewlett-Packard EyTraveloka	9Qsi@ 8-5CPL`67	004h`/`u%
 
tz
" 
 
]6AhEAABA0^E7a!p7rxp Bha`9h7T
__UID@ 0O BI0\Q[ ST p\CL\[qH1t7'"ms"E7
ACPI3B_PSROq005`O5C pr &\PR01082`^@E[:l
LI `{^99`p
	/15?@SXՀ!4sN3ˋjA PEB 
CD֡k@k`Qh`piaFa ?E a{`
Pes }a
aap`׈k
@ap  à % ECP4 KEYA  GErt

[  P `2`hp}
yj e >Җ1 h)h`ИѨE` ibPpbasabcpcau`a[31F ;F0
P! `b  !1I<N2p3 &F4 q5F6	3`"   p
`M
R P   r
` a@	7 8~F6eܠe[wre
 
9q9$02BpFAIL@qL)F3SEgCUpppAMA 
RAPCp^@AbwrB}CRD]E-3aP
caFMc

W200
	r1U
2R3f@2Oa5
  sF0t\@4	O!	w420518206207"208i9
EABEC4!  uA//SIMW&@20wT__F&O) Pb`I"+JT72aQ=0 `AӠPASS14v#A4}11aOpOC04DA `4Dap	a aa4FpLR2M;@2PQC7abbaꃐP ob ubrNq5uH0 ph<piKF#L10L11.F
6mc@Mq 0 1@q _WDG?
<4_c,E=DAAyB{M4C~ !f )ABWMAAF2ij=DtBZnsp{7
jDQ4{h
`?{uN4G,ג`p6048pGPEP2
 Z55
:PvFB  p_ 8 G!@}
p,98221nJ1#<0T0ͤQ0CM`
`;{o79 
A@V8	8	KOD3:<0D*14B5
512]!hxRDh	)^:aр
1?;!m !S1%%b57
&&QQ@15[8h&#J63
G?$ 

p
1',!,C=ep
ob
!G8E0rG6q?	p
y_\
p
_z3O6p
oF
)117ћjq12)
w1133C)KOqT?A4LqX pm)Q  ;)! M_WEDsZX`aS`p10ZWqZݱYr 1\r F0WQABNFOMPS   l:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'a^2]8O.m (.ܣ?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=X|gMsb31/~[A70x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC z--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[401[ 14l[#\_GL_yh
C[piqpj2k0050\C0F2hP50`	l['['`[5

[ 678 b9AC224}8phV87748@a6p{zh
  .2Ah7	Z 9 5 D9i	
9E8A	PH\_TZ_031G,n6

0Q
h

b f[ 2

a3
d
K
7
(
 34s 5
6
7
8
E93#BCD!pE F`W @)4@117}0(171
q 5
"1	py
h a{a`4pL2
ði `h
}`
`40IOaqRb cpb
 {bトc ` b
pz~abrc
coa3`B43p`phaەhbFi `rP	 q! 1*Z4 a}2bEc5 PC :
1pb! 140A t
a	t xa

`br0bA1

bt
 2

	P_!

E1Q" "OA2F!p&6	Fh
!dp1
d# p{rv3bQLb (b
P bbwb

araMpLa[op%B]1Dp148a0]pab)a;&Dh 1A+Eh+ apbpa#b5bC{Q7b Ma<)*	*hvAa=`R*B  v 8 s	_<`#5hf3B-p `D E7`h  `TZ3_
Rb"10awM
%O9I9@hP
^9t`04`x` !fi
 f?
p{tf'$apf 啱t7cbyb8@Kb&q,`bkbFi
p

ep
d
i7p
 d?1 ?do<@efi620(1 !M	4baBPa[48   _STA41#]_wON_Z2
ЅF FF d9U#A-U.+
B


[3zmCINI ([_HIDA_UID~v_PR0`48[AoDMH9CEAFB[{O_ALC 1PAL2܃	AL3C
F_AC02 TxQ1V6W253PSVF8}SLXPRv0GC250!S3A]prBBn(R\B4D5pA36p
!p
O8$Z8SQQQ7_TSP
dp C&q 2"_CRT Z=0ut-TMP[J
2P)2p
22,GA1 x/3 +2[MTZ4_;
S:H`
`rrrC13F`r	`
dp
d`wY`rZтED}2538 48 &415 6W17 8b59 @)A 29  5B`5A
[ C@(Av5D2E h C5EAF@60`UyA
	Rp`@qF06275CaaaJac
``rd
  b}y   @baya
a9@54c!  eraye
	 evepe5c uc?dcM
	R=61cpc  bpbgC	bdpqeߢ)ecb54eofg
fape`pfafgvdueA{`b5` gTkb 	`55<$b pg1Dagg7agubdM305%apP58p0`ck@"r56 7` u`pyR1 DC  E "  5h H
bhQĐPĭr Ec0ad\a
e6%-adOft`f	ru'adSuc2ftd gpr:I`4b0 P#641,7&-A12 63`Q&A/
BmBC061pibhbp+5p[@65DU6
j167"e77"@F/8 w6
arC019abpb0+b0``bab{uaaP `buUa/HSQ9`319PHt2-I8DR`]t 64`` `Q9XD!

	          y q39[K\/6K26AmHH
F6BF
RGGP   @    Ps3	0	p  1	[F&26'	 k19CF
rG G$ $ GN N 
P P Gc c Ge e g gt t      Y DA
T (3 W(4w*
a1B7a
p_*3p{
`^^.`6B\_S0_!P 3R    4  5   M?\_PTS7HM Oj62P1E 7M#\_WAaK@q 42]93?@11A'0vyvy"110P115yy67ÀIŀ\ A5
8̿4 5ˏ1?0F

O@qcbcc:c72
#<01c
 
h?0C+BB--0x0DL\_GPEDFrO
_L901
bV1

P`I{` ~{`
M/a 1NXP@|
 a'a a"BVI#TL01 ߠI{Z68"jA@Z9IP98CCC0DA4c}
0CF["
do34OM}@9 H1*_ooQ
4>
3B6C/(D'#E/*N	_L17 +q83_?`} %@pL(55C0FE+
`^{P5 Q܍1255o7Kw1EFC209 	8%wIr0D?2󰤜!$a:		ˠ!&bF
፠6a}` 3P900D$1yF0>5bA`@>WcA0``
Q1 mJ``pJ12BhV4QF R\U\P
 ^ ["SSDTq`HP  HPQPpc<MSFT L4C270@	o1  f   2  #_3_T	_w 
_	O71wj
ar_a
a4 72P]3 7?2ij\k73 hf!k2Ed"2F 274_275!4$"5 Jv(3m031yjQ2@Ɣ `j9p6
D`t *bb71hA70a b 24pE1 21AXg2Dr8yw77,
b+ѭy U  )V,8'*[!/9LPDCo{hp
ahPCT  79P78q 7	_PPC > _PSS!       	 CPQL_BM  vp }( <  >0_  Hi O O  ! B f (&  $~" `ܾ `a!  B!

 zZ `  %!a   * `
! 5@b	Ya	!
"$b@ 	 a	!
 	͚$&Ra `AE
 D
A! `(d
`  A!NB 
Ϡd#b
@	"	&da*	H'a C	$ ~ #%'"h`-a))ޡ 	aA* b*/!'" 8a& 
- 1,0`%`!05΀(3A
@# `51*8@:-@2aD;%aρ/7B2"Χ`6	$b =a :%	1	3EE9C?HE /1' A;a@@d@?AAaA%a*"BC
 7 @@A@!9,aE
 %";J9 +Q;H@ F" C5!$(%C;AFP>@F@9BD :S	BPb<;DNA@(Z4: D+a>@UR\!$	@ݡT'E
O+@IX3$ ]*d H!ie@`A5C F"T]aV&#e "C
?Aa"D b^c"[+#"C CD(3#^ Sg_xkDj$  uCme)H$ ` RJ7p%pD2! .!!d^
}Bp5I3x S&`5 %!jcnH~G;wj4'a?JD yGe$}F5AI!  iZB#	"d E"A`Aȁ@ bAG'FF 
"!AK$Ic"{
6/"ă!QJ5B	7@"j  G&a|geĩfC'D H7!rdP G7 pE$
R " g0xHߤ ha$
hbdߡĀX!iܦ6¥@̢ Br ŊB8
c
0sdV0B} ţN %ae
@`A@@`ǀ a! !!aaԠa!A@@ `Ab,pA,$c`BObŅ³AA@c B
dǀĈ` 0A$ AaL"a̡(>ac$AdZA aPM@B @K B!! b<
!!  bീa@ `ߠD'"ޠ "}B  %d@ۢ  `Fh&" a\ ?  Bf         	 OSBI_BM  |p ( n s0  b C %   Ƹ   d d> F . F !  n  f f   j       (!"320$4Vw
v_T ,D a%he/@
WS "h$u/"dxvUDD g?~d0?Eg"
Xu05x`/%'cq 
@@"`b&6 sXr*&_`	@`&/7R"G qh `8`hc	8bf@ 	e
o
*` 
7/E`(X]bx qH p/ A
-`@@N`1A_hU@DEb#horHa
Ox_%	 #	/D?H_$F`#? ':%H	!)_@ 1_ (a  !+$ %
#$"B%2`CB`&
(!?*O"_bo-,!)a`*(d $*t >.F?!H@5!=7H.b(&%'HH@9Q& AaoB1sbp"(b*#-eX僠;8U!( <O`5a_( <@CF N<h`@o> 2a`3`?b+O" A")E	=Ap`>!>A_@A _/@ 5!G b!-_]@ChcCU"$
#A"-,1"EfaB@ T @ j:'!D 
oEQ`Uc[Ra>	?oed-)IxB@Z$$9"XLAXHoEc6A"BTnAltZ"CvAO [`ZG
c	(q]#[^%$P
MoBM%	8'
%
#Y!`So`e6'M"S!H a*e[bdhuB5p 2`k#kExN
PUH
2cZby,_a[$Y<A l
R/bn!H"K(bcjAQ_D@>(?AfODoE#T,@/!L@FhhDBS t:`A@FCk@A.MIA]@ ~y`^!C:AR?`"P eB!AmHNGB~OvC"JZ[qE)%S ~!U/p~AuA8m@gkbf"tB1Bc	2B!s /	o!*c:}?dArp !d(
a_	_Y$Ba6Diq fh	C(:#s a:B!
ŘDVDBAdWWrZ`A*q8 v aK"Ayr a!gaH@\0c |H,&a/z_` ?  #[ř E7#p
OazaG"Gc! "dBa!EB.baExh r P%P#`x`% 	qOWAtXӑtE!?@CZ" ͅP6," v/eȀ`#@%΂]H`ӇA"
x`bE`ڠBҢwb B  G ݇`ޠ@ `xET8#}c`ffw @ "( !`f^W.)@넅4BTR%84D     f!  f n@    ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ     "
   	 OSBP_BM   p ( n x0    C % uf T>B \ 3  G?  f  2  J !   Pentium(R) 4 M -( ^  H3EUV
Ua UwuUQ"3@35
UW 9}6@U.2  #f  "`0Ā "A=Uw
"
`/t a 2
?  3>=U^
 @	$AWb&
	##4@
w,
@d(A_A "el*@AF3(b'@$a/@C#`))H(!5$e" $a*!)-C'(A*'.$a6`,^"40") 50)B663`7""7A#?W!Q "6 >O@5<!BDe	c
A
E GcCF`H0HWw(@WJ MiDB FM6E  =	@J
@T@UK 
g  u
NI"uW'
P&0AB?.A QE# A2`!=g2,`!
8C	A>&΀BhDMH`d
̀!
ܠ8q8( ̀h`:` JA*@	>ߠ"@]`"a_# ;	"		Be	_#`0 mСg!ah5B  
 "@#s 
: 2 &E`mx" hpb `#`n %.
"p& U 'BD0A(@E.`+#.A eS0@, 
Ha>	 `>yP@!` $` fj2 :`"{cL/F\`#_!A !^2eC_
lt>@oA*A㡎Drb+␠3
#2blj !?! (!.BvfaaA )%| o"yeAca"AC2 :eAA0a"'N @BB#/dI&!Ic( @8!aB `	,?:#{#C`( 5 A  O@:EB$c	
"/ =	`ࡠ#=a%
C3)waD¾qB o  T#
aB5R2b/? f"N#A!@D@}"2"OE7M0g @EDBOO@B4A/AϢaX`v/dLb!Qc9?f	B? A!s cO od0oNA`z$>!ba D %cÿ#Cj @Ѐ #e*CetcfdF"_@ cZAa#|,	BgbY3³cA >#9#7BDL
n00W@1 @&#Dl?> 袋 P	VH> VB!%t *b2 R "kpetp`yfb0b {@;k @(!@dch @?	`/	aA"m$Ty⡙L *D!-atI@ᝡh`@A
	!@bB0AA'2"`NAñ. `# : e!A`baED@e0A#!3.'H f@ &`B@@3  L$@$@"*@ '`g+(l*"# 	`F`u   C`   F ^ @Z   \
   I  x	   	 OSBP_BMI  p ( e }0    C % 4 hG  f H  ɼ         
 Pentium(R) 4  H ",    
"#
  P@"{o"o r"nAb  ?b@
	 b | _
p"'HO 
U'
@HC/!/

 @	+do
$`*BY ooh/x@OOMA 2"#I $a}('"a#
Q a  # 
C*)b  %%)BZdr/$U*uP2_)@W@+*A "Z6 6A
&
7 .@2%	!:0j&J4U&<3\,=B `'>P;`a
>6AB>OD A& ߪU` 
F 1[=Z@A*sm @_4a"2A>G2""F"KaLYL%J@HmR22KXBL^}CM"QU
U,c(֡	&!JRT@"f&$`!#U)S&1  $A F
2@Ȁ`	 FD*X@ ,"Z)P[ 
 \
T 2`]Q h 	X@UY(c 	 UPrAY ,Ppt
"@$AR`] Zkk)
Ae
Ac>	0g@"] @c$aA_ c	u
%Zb 1L[ 	Ja`4]
Ex YA*P_@qF-vԀ#M_NQ	,!{!
H!w /AnBAГ$akD #YPAn&AQx 1!"_~I \4A_Cbxp a 3zIU
8v∕
$H ea:b5 B!7e2:  	`@QB ,!P!B2nD"$Awa䗇+aa9! FQ@@Bcjc	" 4!b@S3EBu[C'
`_%A~	E( PDf#C.eaA
\B)C.B@#@a`Z
B3P@ "9E'aA3" %B	A0 ON)|)C%)/!#a<Xv C8 a#@=-b//Z!<"b=!jd'HO4II
V  dE /h Oc-)#&!d@L AOPO5!"_¾ %# L c H{0	¹,X`:A"u"Aܱ!~O6Fa		Ba*e^b~
·d} el! ZD_!2 "f#!_ᓡbt
ȃeCch'
NDzN #Dh@AzHbb Yč Q)boY\ c8aAaB}@! a:`doA(abH!sC ¹zoP!a!@e	a}G b`a`( "Kya㎁ᴿBo!ɡ$瀓	_PHɷk"C{!ɬ#Wlp`T"{ ? @ɶ!a} |rx
i A@@
aC=A|)Ţa @wĦɩi
d
&_Ϡб hI۠b塣-[ A 
bUi'&`0	 ǡ$Lѡ@
@Gj@@@2aJ"U    OND\!db           VIDEU[0  @ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`. aP b  cH dP e  fb gP h  i|o jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0 
b3 _DATA_BLOCK x  
`3412Intel(r)Alviso   Accelerated Sa 
Contact joe.david@?hp.comP~    Z Copyright (C) 2p-P 3 2`rp. All RAs Re?servedP!	     $		


	 ! 	TV׾D "L#FPiz( `     | 02468:<@BDFHJLPRTVXZ\ 9{   (  8  [0  @ Ā ( e `ࣀ W   @eDԄHL  p_ ! !Ԓ    {     80܂ 17 L		 ގ @   H `   _ ` =  # 1" $ (/
 v:V}           A !  R`SI-136{2-!Up1 !_2o4  i7 M X <D 2	 Z (-  	OV     	>N Ia(  QVV C dS?4V  
 D c<  \* 
ZcTZcu$M
 2s ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*!P @ X  ' 0hPR	 `"c62  1X (a$np$C	d @A &066 <0* Q 0@0p8
wxx Q@ϯ(/xQ&@X!k @H?@0b_2@@
|/d  ?P 
00 d = @
%,@`5@	
)(<p#Y%%%
 PB. $<~ 00C"2/<@PpQ_X 82

,{ +a N  Xc JUXL"o o o o , K  UfPfVfWfVtRu.t
fF䠆   w FF}\  耹*ƿFXF <u϶=?Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^pZffq_f^f !;F}Nnߋ߈^f~f~`.sf~ t$:V^:nQ:ND~tPfFtF;u )  
f~v  t2:~s}Pv0߀v^*ߊfދfV2fX]P!Rf3ffZfXþ   
@|   @M` +sw.2 t 
؃p.	 
 
f.aИVW6 tM r/u*B
 tVff" v f..L^ .pff^3_^28ev t&B1t1߿U
PSRV<v
W_2G$fWb  < t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufRe.u5 P.f
fZ
fVPf!0% `= `Xf^2dfP r  of D 耈f ;r;r.T" 6f"?2P#ESfQ@tfY-ffX@G=-fS fYf.; r$ )[fVlu8u p+^`@H b,VW7u%f{-2f1/O%o1f^b퟿,t$5&-rp%ufÂ 1fQf"s UP/ffXu
RJ8Zsfn5b1J7uf-qB7c1q9J1, >1AJQ9[Q,tt22<6	<"tR7Zr.
 @) j7Zs b	4.#_tu
 ?`, *az@f ` }uVuÿ0f'}0 0"P.0nroooopept<wwyzi{
||}{!' < .  @[ &a[(8)8U!a*d!e!f%g<#h!$P!fWU.64eހs u.Hw.p p=Ou
uFa=_ i %)6I=OuFt=Ot=_t
=OtPfIXOuF
_u pt~ n)]XZ-Ͼ.<t.:u.T!_F`.a   .aPw2143  p%(VFE ^(p 
Oq  m@=,. f@-"-u
/-F t f#00.f}B,fPo*# I"7 n.tJf4%w90h,fF$ 6+6u 2c0Sf[ u	uN I$Vp !"%"P""""	#
# Ǿ!%A!-(u, xR-rk=PPt(0.u\

^qP9 2ۄtq  P'1\Sfr/w*]'u{+`	,_s`!+
"	Trq&s
!bt&S
[t t fM,ru%B_		ls
B0(f"Q(*fR*P$8X$@
؉b1	/f`2(qQ	f#.8u@rin#u]3ZR,p
 )  [+a   ufj) + ffUQA3+M*Y+6dZ+4+!c<uw+pzkr{`q
W+faPSQmQ	2;YtlQ
 srYTZAQDt茯p^Ű@t@uY*Y_"utH/r.D$tt	Æf^ZY[~Sv w/u#
 u3 /-"ba@   0@1ʊٺ 
[`}.tN0˶V uf`.VPQX	.r0 k%.8tYX^r
gf&⢊f_C	f`	so	qt!рtSRط0Z[633xu0KbP<'$ {p)|$' ?^Xz!&+&U$tԲ Wh.QYS.Lw2푘.pe
QPfY
8Xt+$YIЦ+.W tG#t
2tPS#[;Xu)½&t0uq

uPSߋ~YSQY[rʟ[/(cQRvPu8ك zALtS=[rt?  p#/M2,,`U 0#; qF
1Gs 0
p RB	&Ыx$fS :8!ux?'%PQ`UL%<vYX%r2%P PO`w% #`vX%	#XTw#@#G.&6
?~";a`ozQ4
81w0YyGpò_&@?XrPu(s#0 ѩz Wf_ V.4.tf^0^0ѱ m0/D! fs'${t#f%@ }8ue u̲t,rE,s@t9@ ̀C &Zf*3fK
f^	 f0ڸQ4,r0S̃>cs ?e%YE?# t3O!akʺT%V1`QXw

SX$w
؊ˣ"3Ҩ 8
.[ *o+++;,_,p,,,	,*R{h"u\uS"u@$#P"BtPPP!(#fSf[A!#Xa0tX"dab!$u  Q.20;YrWot  !fP$ff ff3g&fG#f^%T2#QB #Yӯ8@!8##p ѱ2 z 0 c ?r	 Uw	t .:\s^\0W*.$tBuIP⢛  ^Xu,.8 #.t/s!P~//XSB#[dĀt
 ?S+r!0ÿ
"f?f" H릂'`k&r7
f^&?E$x $ 4.
f+أ20t2p/fPWPJ	&!QPYP4e,4!2P`V CΦ! T <!F C9%$t`u@uUtQ!2I's#f w<fQ%yxfYvt&wu!C;Htw Q>..Ͷ.G$ r
Q2Srs[Yr
rL rQjY߂\PPtª<v>rs	 hPfWjrZ,㿏 . u.Mpm2ft!"oSQP2~Y8[r2QAsYf_XSWJ_H_[drFsr}?
D
t+8t$P`ՊX8udѡȱЀ`ʰ8px3
a ڀi	dA0`@4C&f ¢I]Еu1
&&Ks"*f~4pp끃 tހ hut
ъ-4Pb$
u$XB	X[	3`1
>J~U^ FVv
nB]FPW s&!Gt8uXuD>L t=+pMs4
й @B8e tC:er3vD6e3UX?&2VS2.6e3RF8r *[Y22@]F]W.>>et>Àt&}&t2,(-)*.)` O4eÿ~<v<t
ц<vєÜȫP 3bN<w<?t0f`u2e*s
2&J&P &L&ģ`&&pK L`  aÀ3 43333
333444w54
sIuM@B? &<w
2RtE>
tH&38pl
и 7a3۱R u t?F@r!tƿu!WV ^_諹 
?GW _uGG d a `Zj	 QIגڃ. `(.[IXuπð/؁7YP%@@t	pTFF!Gpu YsssQS&G&w&_t0B JKu[pr&OP0 &
tuȋcPQV2
$̊
FY^Y0_ s0&G
Pp&W&w@
p߀?ZotHH,2>tr:osr&9p,uh 30p?o1 

$0_Gs'
 4G_.>`;`;9ëzp 0&$F@[e;	@su Ǻ ܺ@+o  4t<v<tP&X@F20հ @&[f` P1ftJf &&W	7
aTugׇQc$<0tqZt2[- u "}E aE1^X qqyѾ7P.8u*f0 @)"}aq`A(  `	s63ftft\eU} t$D ut' $d4 AǀX$1>&0 )1VWS t#`IF[_^ rZf fV 2~Ê߹  r:<w40r*%uf21Sf[fPDV@gs05`t*Q.LYt  u
"8u^ZSQ"s	.S[ Yrߊ̀vXgqPSf #brcŀtʀ tO<ЛrCQoYr?I`PPf;Xr-u f.;vuq	 `kr_aYf@MRVSӆit|.<t.9uk.|t.9\u^.|} 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ0e.DYXuP!
~[` 0"`Rf
2f&ffȐX&e&o} ]~@.Dufp0 tR3Z[t	pp   t HK%nQ Ms, f+VmP 	XW^[0
 ^^94S
B^HQKotE>&E`JE aJ ^oйL[HKDA&< <  I m  @   	 -`pPPд 1-l#PSPS +׀χ `3 s<s at< rj7I<S<.97H<r[._{E#[t/u..s߃l6&=	r	ǿ;v1SSWм|@*t
 #u[[_[ø RvvZvxЖnQrg  0K YPVPV<v	 rL^ r WffP@X2A5?$_@lsPDl
o
f*2L<w 7PEXffsfB f^
`p
f3f;w<<R i.8ab.<usv@C pQ2<v+<t'<v! tƐtw"DS_polQf
QPX@. p
.&R Qs] gP;sf>0  w| =YrVI^w
PZfXuEu$Pu
$0VW#ksB d @&|&\CrwP#
Xu Ѻ	 Z07
 u^C7
f ts  {  	

#
Fr=.t 35W`@`8u
X@P@_2.@S6&[X<`r<qwRoZP$<pw s2S#(S[2ۀvESp%RfﰿfZ{fp k
[pP =.cfqY.1sfARm	Ca@?0aS,0Rb#MQN[sSuNqz5u `2ɸ,"y:.F+o9sau\Uص÷ zMيm3
x`@!2 g80~"
Xr+5}r 45uUӊǋz% 2BVP3Q^5 M3
N `WP1ݡPS ^@0[HF`ۋY.6~VWRԊr;~s8 ~JuZ_^N t0S[_`\
Đ}2110CVz 
  j2r@p  2Ph@ & PX60"2P	X uA0`2RZΐ !拄P?[ ؆! PX_ PҪ C"	ƀu̀<$
z2`aesUDtMrEWfV.4.tc.TP&} _w(&
&Ut.9
u.9Uu?A>fQs^r
~\ r"DfPP@?XÀP݀  V"E`fa[f.Vf&f!u
$'tPAfG%`b:Eaq`5j#t
^tqtftY
0t'uo`C1ȵqڀ \`^PreFHc4PdpЯ @pS P P J	Ӣ&/	&  u"A#P
	tAfX_f^r s  r߀tХ̀_u
_ma<XQVW_^YS. 	sKk;p`0a@s  C B jVS3۬
t
<a|<zw$C`^#V    AO 72PP2}@i心t.:u23PV .^f.<Inteu   	  
 	 RaPa C` PB BA B;rXas  .oH@uSb@ uP4[.oHBar+~ 6  ;`&  f8;f%f;19RC`VPMp 3f.f
`+wҖfAJ\ Iu	fSff@ܰP/sP
 3{WI pWI^YRA.WI0PRf6 0.df 
00.DPR.ff.V` I .FFMȋF 
tJHa  FACFARR A䀀@`*
:  )]!9p#1_$<AP-<uX.>Jt  +.J< P.tfcARtsZf²Ĳeg|t5r	Hr2dR?]ۀt¥ `.ȃ v(.жuc.<s.tFbf u.t-.5ut.'"pe1
fQ̀Y ]  @FV *O`5P@DXe<DG$hZ0kt=	jf'`p- _P4=DHPCCotN`	DM 4Qbb< PrQQbU FvдS+	s3TQgQܡs

rRR
RZR   $ bPBBCZQ
Q QQ0_P<fƊ$f==fffX°"t
p tf0ZYQ Q `  	Qq` S{
 tPP첺P q;4P U'o$@``` wЖS S2  1dQ$d[$P5}0aɀS
S߻` 
  Rf>`
 P`P @8ftsr섿g ZX UdPҩΏ ` aܟPS""
[X"GCc^p!%!ff6}QPAQ`  PA%
  fS%f%PŀrЌP tn%2'ff)f#ff#fahfA(--('RA'@u fP('fXӋ#ك#[uX.=               @QSr|rwKHs؂1 V 迠;v7 xZ+q+±2\\sRfZf+`fwaf 蔱GU`F FFP.8\uE.T;u2	u	Ff$ f"uPfVe.  ^0!

uC⦾DD  + A<u /f^a]3s(13Pprif^@=wA@_`SRWVPtCO	r<.|t4.Et"0t.\Q" YsÀtǀ>P^_Z`UЎ Qs"~0f&;u Eu&M]p ArA	ȋ+;r1;r-fQ&
 8s;fYuaSR _sZ[.6P.8u.| P.;6PrSRVWr;uǿ6b	;M1 	_^ZV3St Uu2
^`WV_rGf^u4t@u&u!SQRP XZY[s`^_X@0`Q  qQ,U .8utPYf$ADDfIN30 (>Et_'WuA &1/f^T4r$/<t<~R?r~f&E   3@zG$<<<f RVr
.|!!^\`Ȏ `# t8.D;..\f^t@ 

sV! 
r.PP

]a`'r~yRӊP` X Zun1tQtLM4s@Ass45s
7=v<Wf_JJ^uS6BЅЅ<P't0BN-C.
t<2,!+t.
,Gw<|`$QET:< ϐPW4 ht@YV6ϋڵ6`1PVH9""bl@#ur;dWfA6fQ6PrUwP2B#u߆<z mk EZXv]_֊|PXt}	+t8} o  d %-Ph%[pM  := f^Vr+;t"s	Eu
< u	f3@h3m[pt#|=p@fpQJSAH[8 rQZYs
R sf=RDZtr$qC}Kr. u)"XбbtkLUsqPSQfVQ  rٰ6.&:
Qyf tFf^Ya`s%(TsHQf 3휔0QѓsxuK= w4 w.HKPPaU=Z;v| Q+tN z[[[[ twǾT[`P÷ p  wf~%L t@f_fRZXQ`;v
t
 
 F
" p0ƒ΀wWRZsNp/p  .:?u0.>`(bJ pZu.n2`Ґ0 
30k;} .Ĳ	fvfQ
P pZ
@JZyhyۑHp	iAZ3f
 Q1VWfǀvf`K1ZP	-rs$vD)`) ! 	
PSfV[PMrA!$@uc] .@^PPPPPPPP P!P$P%PSwf3_]a0!{Ct3`
(ZAt2 2h2ۨ#q7q+ 8 !)} s@PWvijRfZP[tuU  updsEjtz Rs3 @	<wPpXs 3uP !Gb'_1G G
t$ 1C ]#;ttAjF{G R*N_@uNQIM_____``@sþ_-ðFF3߉F 6.ޠ:Q0=Y 024/sR Zk>B p!K2^@7 V```aaFaaa
4`~2C<vS[t{q&fa/ q'@^'f^@T#t,x
<pŰgĊ,+ ,2s2Su; xx |s Z þ/.0p  ȉNucfCp7: cm0Y ;f P(fu t7f<*) i!ff f4Af% ;WF  ΀u#\"dnR \gQ-00
Őh*ab_bp}bae@ Wf_fVBE/fFPzOA
@C1r0f« f fߡf+À ?f
f p	4
qf# $0-p8u2uA\4 c/ctr  2SE4
/Zs
 u6@$ .(v߀vu
RSpڷQ[Zb[S 3߶6u}6F #Q5$d"i@ PQRVtHc. pVP<?	r`9f t4W_s)v!f&=&} u &G
a`SasSRZ q{3ҋ>rU]deddF5
s;pw S.)d[,JP@t  5r$ ? r@o:Hp7
cr" ^N2$1`8t\tCf	gtwAf@btira< tA@C1a[PMIDn_    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS  Corpoion#ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq  5  0  2   fg;iiiii7j<k	kn/daM`bf .<t.:utOFûE2&+]=OuMWPESAP Ÿ@efefP@fXfQv4F@;t/aQ@wetf s tfffYfS_uV f&E-  ߷aXðQ .V@Ύ޾eJ  @e suVO$ G֨_  uڵo к a^@ @`^֠ ^_nիz  {ppՊwfmۊơ ܀rfo
P rf@@f2tmQRf`af3ZY 
LՁ
u߃9p
mr;g$:Iͤr	߰ @p`O%nNӏͰLrf
VÀ>Ivm@wdtYw@t$;wR?$;v@fc1qߺ t@`3xcjjcjjjjkR^ۃ`܀  )j.$fat*R`@	ZP	XfN H ~6


F wf f` _tva fI | B0a"_ $+Ca6_tE#>âw1gia% _nft}ԛt)vGwAºBffP S }BBu젡T 
RVIݺ P!=ݰvp,8 t3
9P%ҀsZ2fQf;BQP
fT0fYR CIR[:Tt` uZP̃XVD u.fߋD
f=8w"Њf`IR VfZ	[D^ÿf0.E.e! *$P	^P0
 +$pE0	f .4e{ ֿfڐȊ	߀8u$?
!32IBߨu	pVr
.
 @$
yÑߨaV.|g^Á"2f^PP> t"tt+t.D@t au V^r

2^û< <#t2 <"t
+ <!t  Q`u7
0Q2ъȀ
ufPqu;pusY@>݋иO O sOYˀ' u3u"*D\讬u> &p`uu t kudu^sY8s
tQG8s8s8t3 t-0vv&8swˊ
r*ˋc
q㉗P8bu J NذrP2ۋq`R
tB@a1p@2$b&LN{ @<v0	r	eߋP鑘F ^Sr{Bgtw%gvk&J`֋&FsBuՃ{dr' wP酓zu$0<0 t**F Ɗ
t*02P ؊š	a>`@P~tAr<w!#tte$XZ;Ju˰ f'
tQVP^YuQW_Y[uC B~	2@s
2@PP *ڀ n@
  toXZQ2	/ ++(+t؋X  +) 
"a݁BtG:#sNOFGuxsOG$	B y*w2䠃10>K , !+ 'k'ȋPH&1u'&`'$4$p&  %2C3g B"pCR S ؎
ȑ'Jur&^=ց3?Jup=>wP67t)4&	55Fb1BZ6c5 XqJrv
t-r^ <G!M`sw r
&XtR٭àQqQ~0QP2GtB2E tO FƮS PЎ،Ȏ~ 0u.&>| t
Ò$c-0@}ȱ\,ًppRC&ԿPD+(w2 _6t
0sus@a#Pb0 2&<u2ۭypWUƋ0t
Ju]+
ɟ]Q wLп㋟Paz x͋Y$r!v$$:ˀu　?60{0Ql$$s$guz
׫3*48*0*^OFH,G`/${ְ Ë?*) j
y$6| 62 u>
xĪm?í&0  &_0%Ê)"r>!Mu:0+,Yr3,+K'B2NĀu9@ZZVWѤ ts
_^GMu ]3@ø&ҋ$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>f߀  
T ٟfR@
 F$
 r7uɊ PW.>eu>&}JPbQ_XwLԸoǀr#Yts-" (&"%
Ī&#Z
r\sي
u7!~y@s
x`ALou1x  w| 
pd!! esX @
Off

,z	0	2ɸ,"yNu6@	@	ʸ ߰(⨀Pbr$$pt<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFοR
tp8rSbƇP [蛀Dorp^3ɸa0
uVЊdЊPSQRaPaDnXaZY[X|*v
ĀՈF0F02<}:}C}\}}}	}}}}}~~~&~G~<s<trtt|0ù 2ۋ&<F 4w t3&ee!3<
E}Q.~TO  @@5 Ê`P&0y OuۋÀ8 0
1>ǀh  fnNEϊĊ嫊Nuúq 2Fó ?} Q ` K#Nu	f&ׅK͉DSRP$?.&\~RP ^ `~[[c   XʊZ[PΊXPvXP) ~~~~l|8 8| <<<80    <fBBf< Ù}x<fff<~

x rT88T  >>;`ZZpff f { "8DD8p
~~~  Q  	 0``0A>$BB$@

V` l$Q  ll  l ||f6j 8L8xz 0 0```0 @  <;<f00'0  || 8x~ |p <| <l |& | b ~H  a0!2  
x | ff|ff    bhxhb `>~ @< p flxlf bf ߂ ΀|}`||~Z<ȁql)Ƃ  88lt#<2 }xp``x w x -/0 U x|v `` p 60x00x3v|xw`lv 8K 1̀b~ P7ܢ-| :p| v .| q$4-4x ll3
6|p&0d (1B 00 # v܄?&qp|8̅
|!f!&88 `x`:|~~ ~ȃ΀)".a0~%||`?l``p9PH~ ̿?؋p

6ff+ 8<448ll8 60` BU6F \E1S6ll6W` l  "# U# w#A 4T d  %6 P [ 5 NOqP_U1UQ2d77[0?d?0aa66R9 ja	
 R>     tv Q@bC8~llHO3O rgg8 s 8||`rTXl?( <"CBfa||"|DPh4"  l~`l~ Y%r[& Qp0joG<8p(5ly}Xlq<p&Pl~0QEP< cSld$DtUtZZNTvTuW32xQ2)
{xpbn|ll|}220 a4֕BP{ |`Sl8>70k  B sV &
Rg#Zs8|||8x;ff""0AR	+p+q`llҒLMv܃o d $ 5)/ԑ#|1DVs r  Pb
1up bᔳ2ES6 7
 ц%25R$FPB@S9byA1  	Q$(f P C='# 7%7 @Pa"D"%
tÝ
0l`6$6~~$E47㠃#
l|8@s\3OƆpb#-<,00PcRr-Lu;T3'$D bZЦ e 1d23] %`aB=`_ְr;b95Qp$R"ëBfӬ3*Pw~Ry Apotmeۯk5ܓOh0xpӰ`0HH0i ! Ѕah tC[D0 0AxxAcl>j%Uڨ	%SQ#x FΤW1hPr!`xC0q C'7!1 ^H(F/`1L!<0[	<\Qj0FespfS_dx0`> lܬ>ҚdwưD) ew ) )üut  (Yǳ x7ȥ WU>ɈT  4˳^S ds͢Ͳ 5Uc	 &
JTӄK$ %҇Kӧikso̓@"bR``0`&"b ct"1 آ1vetn v ||-@<`p` v3 9tt !Kpܶܵ *$1R3C.o0`
7| /  %4FU} '27Whu -7t u #8]@/䳔TJ}8&00 %7]i4&4E b6‸ <B eaְ "8Fdv D%Eu\f RU閝\ 
5cхե΀&C`et %EWu  %Em  'D~+ NWB^]Ë 
 1 
M et4G =&tDf tt0
" $d#$% e23401hK"r5BVgv 	!"f,`G 'awD 	8Fif .G@eEt8Bm`lx -Mo
 /on	 /Oi .Mm +Ok /Imtܠk$5Fpct q=FTfv||6 <]}RR@fyѯU<ر p>| o` ,4@IXg v!"#ԥ$0v?ѤË5ц&) ~ð 	!S P 豃  1 0 a.Ԝ&6| &>~ 
*r
t	2.ò`_  ~   ц~є! w<
u&| ϲ 2.^FFF3ҹ `P߸` Ԩ ΨȨ X  * : aQYSظ s2t  [ø{u ic
>ct?SÐ/    ^^ >Isu
^ t 36ȢJ2 Lc&̀>Iu	B$P
	JX̀v`
p uH- <ĩtQ @ rw
2F..̀N$F $FF.q(  _ZUoȨè<w$u 4$
p À0&&_Q"	_@Z<w?1 A tSD[S
!&VUNq<w4#@tÂ u5Bcb?Ft#!)#
o 荥`԰8 u{ 3ҴugĠtb(u]̊.-QYR  
 8 t$8u
(
=
28u2ɋZ aR23Z%t<vÊ>bSu
㋗PRYNVQ~ċюF&<
vu^Ft&FVRU r,]Z:Jr92:6v/RS=b=ƇP [
tZV t^^YuZO[
<t<t<
t<
tx@(` t
t$0<0tur N`u6s%&2?Ft0 u*ш)s&:s2&W #   a     ? t"<(* II `ga!īI<v}	.ǫ.﫪tI<tE2<t?<r<v7<	r
<v/<v)W  WuCt	t`2ۊêSPm@X[$t   ъ?$`Ip
P4
Ī3RQ$2.>euZ&G&Gt͕  
 &_t%
&;G 
 2     @    fPQV fVf.Da 4f^^YfX< !!ȭ14f3ڡf^FF{fPfSLqfa#fbff f Qf%^ ;u@[`PSQRQmଊ+YZY[Q Ƞ@KYbMfp/Pf..7/
CCRRt׭!Q̀YZ軓7t&p
t&wG  x  ]  b螡2
f X蚠=Q3&&&I1󥿄󤿨fW P tQ | fYÀVFF30^XtJ՞QF	 DYPRfW#0f "!fP   f3迀  [ 0@P *sg  ['u P
Dys-pCR{*  CA	  
~ f$ q	y
Ჴ`F0
!3
ٲ1
{
f[X@f_Z) QVV߰?^B*&5%&&&^0 &T@pRV0&$F@&F{  PX@F2ܜ q`^ZRD}MZ@ h$Āu[Y27VĊ嫊ߪNu^D7Q盆İOC7Rf<Z4QfV}6qf^Y55`4h s4?蛾t47t4\@̗4c464
/Qqc2U2222e222RV2B3۾ހ2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              Ŕ!!!!!! !!     #v1xx">V==8f=,=.$=@===HՖ===3=y==BG=0== = ==
=v_{f=Y=[=O2%>DU>.P>SQ0!2Št$L-`}$Od   : ,?ĪaAUc	PCP@P @ UqD"ΗX# ԙ0] 
gh2  ,h	PX^oƮ`. fȎ؎1)`.>f; lf3AHr(|$utD rq  m.6rPgT^P r   r{Wށ
 g !^f t-
f&af&_ M f+W. T&= tof&)!_qffanPfq EQ M  aR $fpf	u(ff(`m}p r} tUl pA跏w<f+;%}+"l r&;f&HIBM
fHQf=ؽQ
 r2u&} s
PQS-[  <
QW 
 ftV`^tuA_Y `VqeB ^
Dƣa&Eǣc\ ;v++\P{=;6as;>crڿqa .qǾ覎ñu6xPt'ࢱ %+	@赔Px N ð  t%uo7趋!P{fpۀ? @6 S衖[ 虖[ f $ADDIN30,ϺVͻ AIM3b0A  @ X@~ Q Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Ef.> v `pb 0p8fX 2ZY2 о0sbuL.;w.;v
RWfVvTtOBf.G} u"ҰuD0R j`ZR Zr
`
yf^_fZ~ fV$< v99f<b #V}? s1Ĝ 3LҸUq_S fVѓ2П[S @t 3ɐRW칀t
_ZP9.$ W4J0_ `@n$<u<.\.r   PXfTA2f`1 #`Z`@.&<
UKs....@  "PO  5bOukRK6	~f.d..\= rw rL<&]fff.	\. .FG@ P	3@  .G$0<0uo.afVf.t2A.QfP/uPd H0gZf^[ Q2fuf %	f ͫqEd34UDpĳcŝƿ
D	V  AY >DDPU@DSDTY@ " HD|   G 	  
@  $ 6 d_   IL  J B 	 @ , "	eJz ,,Sg[ 00?	s  i,,_


j6Kd@Xkl 
 
PÖ` q@Q@kQm v lC q \ l݆ @AEq@k6
-2-3 A  ``  3 dj 
=z 
< FL "Z  L } "V 

 ?E SJ   
E 
y 
Ou 

SZ  MnE(.  02<@(@(<2 3 = < @3`= @<`3=0; 3 ;1 0 4 >`; `4@> ;4 :` 5>@( (`:@1 0@5ྠ ( :  w5 ? 9  6@?906`? 90@06 (8  7} (`8@7   `07?7`0r `;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 0=p    
>* *8 ;1 )  @? 7@1`?*)   2 )6@2*)  `2@( 5  3``)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0=H`)`' >H )@??X(`E$@#a6@-@6-6 -,5,7@-,@ 7-@,4-8 .+@ 8 .+ @9@.@+3`*:`. +@3: * ^ @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ @w? /`61 1)/)1  `p< < + + `0* `"ú0*  1X (& @A &06DPѐ  蠠Ń mP鈱 f%Ѣf=u_跕XПfP R@efu= w
`}w6fQWP3܅tf
@@@$	Xr/Q菔Yv
wfD f0-W_{fؠt
!c@C"A_T2. t.w軇f~7?01)@ൣנrWRZ_Sr3F!f%?Spt@f
qT\afQ2<n܆ `2f2!t&2"@t f0fXf^q 
fш"[ @:=vL= v^m"@RSfP0e
گ薈d+3
0ub(  <  wrP+ Sg[0]uB1
j  ! R b r "2B !Rz r [   dteuVfvW V
f_q  %"
vﶾ
r 
~ #¿ւ %B
  8#  #  & & F $Д e Vf W ظz@ оǻP0 	ǻP`S8t< u	[Xجu@0F f fpG G1誆^0 u4!+ ^ع  `J ^V @KfRPA3 mۆX/ ΁K J G!OGfZ	 .8t.L
ǃ	!p91= SQ¶UT;AfxWaŅf@t>Xa覅bZ$̥̉  ͼ  ą  ʚʼʡOGDGoration Generic Device 12 A N@1f^t" gr	c@a	ÿ@tdaQW&]rfS+~f[r$
ط]}Y@00_  @  8WPXEtpD(2f Yt2Q"Y[Z? jAWvdlaw{wuLff@#
M[ZQV:˹,t.9Tr.9\r	^Y 8t&;Ew-&;]w'f0PYr;rp WsQ@sVfW^W &  &E _^rC&E
t{&E&E0QW  _Y@ffZr
4ps,i_^ t`mItuȊȰfu}<u,."/\pE QrH&
5qqEq
	.\Io7fX/~{'_[5  ()bc./1 24 7 8 :; !  {t	M;8 Y͹ *m͹ !Hf2~QRZYéa [<Q+ +
P>SQWO60#t&#E_QVfS zt!`h"2BRbr#3CcshWj[zV  6zu	 
 fftF.vfSVй-PQ3PFffsf  ff^}qz{~ {ffI  .`^s fPHfXϊ蠍sfxQ@6Q@2߃tQ^qUۄs`+e6(XP?q_`f3*r`gfe  7br   rOҀ8 9 f&]\ R      f&	Ua WIf3fƱD<	t<tQ<"tm<ˠ c<<<<tt    BfP
-B}?p. 
@@t^@@"f@  )   9y 0 f@ t3TX1  f&U&]" sSY t;Q7FYd15_ҩ2Q
ffڹ)r'}SS
S  } P`;C&]_X|RVJr.|QQ.S}6[rPXff_YqޤfPp )SQPXPSe| [#[ \n #
RSL[rS =ArIr@	yr9<uu͊΀t"tt
rfPffXQQ t!` u@rt@nr
dcwπPtdx @x0u!̱t`pt `|RXD8tտmrZ6f?a``!scT KgֹArQ9rIԹ-SKQr3&ttsms](a!&0']'M'ag I!]Qޡlr ;E]#`;`rMfa%q_ftdЏѰ #21P@U#Rpf;r)glsPR$4
ZX	@CRրZr-kH&}_uu4 e
$?rӦbQxTotal time for VGA POST:   Seconds 0.000 
 initializ" < 10 Milli 
 `.&Zx.ԃ.߸@FA.Կt.ԋ.u  6*Qjn` 1.&0
qs .aPVJP% t*.?
.8tFF.L2t黀<cs^X	
>
2.A֢ k09
ps4pWoꀰ4@
;
jps.$߲f#9y52
?ps2O2w@q"ʀ)2Pr0kptN3pp.>,uyp2 6pt$.ppbZ 0nHpf.f.+Բ"rp{p(sp .
&t y:0fg	fPf.>1l
UsOsIs &Cv { 0@f`RupA1@f.A~`JpAa
P`+ qfpf tpwpI8a`p+qXf-wfwffI sQp% uf1vYP.
hXú#c& `	 2 "ĊRZ$`
s$.
tAP0ԋ	tA.
t*. 	23.. úUpUuu&
#0F.Ի e* ˿@   Y ~ | тPëO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 Z     t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@by      %  D` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VWσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7hؚc t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPhBfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀h$Pwh X[õ 3@Ĵ$<sAl r.ˠU訿rO!` OA (tD_rq XPנ"Q!ؿf0ѣ!ES  gf /u
> up[PȰ&  cB`&Xq!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .}2[S[W>  t> _`W} v	0EAC r3_ۉ_`?2St]AM][QM_Ϡ &
`9P
PR<w. [SZrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hΫ\bar1TaP<u< <up. .:.p .7c>`2p .>bs:P	d.e> e,@p ˀu 8r f΀g[ø0
.a.&b΋p1p.mΎ7X@E2@g.*f΀ v&.f&˸ Laap7*c5.PC{3`Α0b  ϊ* # PQW`
 _YXR.i
 Z k@@ZÆBB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.q}u#rp t
ArZwG ߊZYS2
dؿ0 PR7 r  dI r`.pr`@ d`QR	 .ߠp`qQ
t
Qh{EYnus33`8u" f;`Ph @F F@ &} tC t;k0Tta30h &b<&E pظ@ P ^ X Wu-  apPfatQ@ ϰ YeQRW.. w#&.!
tff..A_0Y}u..nf/.ӱ cߏQ޹ޙR'@lۋ۩ۼmcЛЂ{?Qvd1>+ r.觳  cPPJ <t<t<
)SQVWێ-<t<wPXrs<v\.>Թ &_^Yy3	0		ԯQ @~Y!<8t	 `<PVtu=EIAc
<
t0FXAP QpRt @Qȵ$0<:|uFP ff PffXV	 Xio
Pj}^Vf3
f^  Z  f`
Qߜf
*  >"Orf0f3ftY "++x fa

E   ۽ 1C< tN< XÀ Ttu7A!Vu`U߬<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ o_!]SVW31rKt	s<<t<p; <w
t+,<Pu	& u`< r 
A`< u4 _P&OIVN ۩0QVSQWU3t!;wOQ
G:Yu
;t} tۋ]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fw7<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*򮿋HHH
uÊG O?ÀM=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Yj#)Y+PT P G WIN @BDF8U$<w%.JGu~0
t;wP
ߤȰ
 3]8QW C  1 [n6f.)ܑ0IQjY f.>)R[ 8svp $h 'Qv t7H485 26r SHz ueaJ2?  UuQK7e	$ <C EuAm"' ;l  Xcސ3PQfR1[3; Bf>@>Q mAB CPkDހQ@ہRSABC DpPOP R S c?[ QSWP).X.܀ uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)R+<[ ]Op^?pu18x f;tu/G2p _1kSfa u<] Pɰ݃f   `ſ4gB00t  t t !״rer cZfAA Uta	$`<`ut
*B5
u0
t		 u]
l. + ( k@
ݐr.ݰ

=ZE"R@rρ r}0M~dZrB BU
ǃa" rq"<0oP w  "
 B$<  wu֐S0p@ "8دt2Tu}NuF;J t> l@ u.Su;tյ "1
 " hۍa.'yuη ˟                              |x KJغII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ] 7HĴJ!R~:$ ̀u#@G@6J B3tB  DECBc@CЭZNBD r0`1	$
 D[_m rPf j qbA$<+`mb+
cJ$<u	f k rPpc\ Ḇ[ h:I:  3  P O O 	   h=r@῀ gh%>rA6~BȎ؎zЍ΋wh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                               F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` a b c acD Y   i 0 0j Uhp``ϋ;@:Wff > hp
 DϊfPff
fр aVWߤA+S@)'WŢpr;_t[s(`(F['_^aWf` f vru߀p6fffGfY܂h R1Xfߊ$
(ffw ~A	S22*{OPr'!$߿ 
 uf 8s֊ҊʠXQ;RP
t0^-r#XPX  uf a/uSf{UPfPfXZ+ ]f0)ff]rff~m`e#n z= osrsc:B
Cb_ 1f^ |w @t; *f驀@Ikow  B)ђuU6ѩȢ+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu Fߊ1KMuY ^Ys]Pg>!f0rRg'QSVfNVFfL z^[YrfqXftA3PXQM| N O蛂P}QA` XPhWUQ^PԀ3ʡ A1sд 謱 ]dXÀ}-p΋_P^Z`Wᐊ f} mp_;p0                                                                            -  8o% ݜ @8gsUv V ufou`wQ2=fA<t1 u!ϱ n #r.V sfYZ]fT߆f;Pf;fZWf!r@nurf+Br
@d`|s
ua

<1GxM	krrBaoP诜XPQr?r Pp}$Ss[ORBMIϜEƺ{/|JO ~90p`XE)t fat/+f %#fSfQ< tl0dQ2"D ҥUYt?$7 
3#tc֦ꪫ0
ð-@WVu@ ~WB Q Y_W
t^9lst6]V! <5u G	F^B^= t訔s.
<5 = 
un>9r@  Xf[2P
X^#WfVf桖0t
P Er&< u P[`B} S f^cô P9xXs #M #1$!$¦#$P`)
u $Q C'SWpI&_fD[t t
) R!aW
  $
Ǌ! O $= $q&%'7Z%.^tS0	 oY u{ó+ oQ3-3ð&{
tF!tt	*tEP"QS&~"
ǆ[~ <t<!t
<	<*UcR`	`p
!PaZQR¿s	8
ZY$ R<VP֎ލvS<û	 q[rAtX2wpJ^ ðU!"@ r-VfWa@ u؃ t
r
D@E2 r;n^ M3mQ|
u|	 t0  $<w<q<
o^}q!"|}} ؊2% oA$؋~hx* ^u XðQQoVWP 
Q8X_^YaQmQ@^P2b@ UB2|0ʁCqa
P'6#fp1>设ðW"82	Rc~|7 B-S-ðT".ՠ Y<@Vb/ZB=?. Z@lW	U>*Q? 1@516k5pMþ.øJ{fUfQ ufVK_rMfXfu gf@ N V Fu(gfFffff_MufY ,&f]Ë<u3R+fQSfVffLfTfDfLf^[fYrXt	A3PXføM贒øNp O覒00R
WfPΒSt3   fRfZ躒P7_f]p$^Y1PfW蓒 tStQ MU2XY f Pl!Xt
 t$SSt!R! pav| n8X(RfVtpl@=(2;VSQWurw#t AZrB@q$r	 D`. _Y[f^QWV @wy^_YSQV3۬
Ê^Y[S 8{ e /  & aV1fffa.6.fff;w	rf;w 0S.- "  u f%3/aBRx@u$ Ê Êذ1x0x= <r <3f
ffʝff   f-   fPSQRW >E3&G;r_ZY[Xk%XBY   1Sw t	_t`Q /fЎ  f@@PuP$@afX4Z4f4f йg&>tq r 	r
  u f_~p gf&^$f tt,$
g&"Fg&
FI*$
g&#Fg&FJ	fN#F	Pfa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`
t~g&`
g&@
p
 
u
g&u 	TA1P a3Rf\&^q\QUð4追u3 u X A   x SQuPYf$@Xu=L@[ScXnz/$6FQtu
R=
ERV>S1.1V@p  r-chpQ<V@V<WU ௠2 `T `谘a)"of%P > !"f R"6-"s >)"up2V"f2>R"fZPwNN"z΋f D 0R"d軋ofN"R .V">V" u /R+quX>Y"t:`a !E aWĝߗ_^Z  pp``cV_ Lؾ`AYȎ>$-PS0ن]"puz  3r@&[ fR  rk.$]Ý&&za /  &bM&w&S
!@BiѤK K(Wcm`w*	W&Im mn'a&D	&ߍ'%EOYmw&cfW3sAq<f, u#p ߎf3@f=SCAFŁ_U< u
 	<! F ]@W  ¼<w& 'V3ɊȈCF`s! ^pt	PRVV<v^.
t" !iBvy^ p  &]dmԽ&P Xn's.V Ou]UUA !	"! w{ g U}jj}"Z"`$2$>$+km$#U&)%*%QRr2"S"2p*pE NHX["2"Y( .6'3WV-.GF< u^_׺srD.\SR @[Z o̱D1QR𻰄 źZWR  }<ok|R8AS؀u
RRp	`G_P PXE%
cE%	X< $ZT
 
"
t`4Wt_wZwU
uQ6rEt>ސ r25C rͲ  r  VP 
\!   { Ap_$2
~a4[rVeĥi1sCr"trS ';Wr6"Qr
Er Gn)`te  
 `     tK;\	\*P')0\;#$ rIW("  k_jzP7(B O55B@XbmZQ3Rr4;3r!- ,-\BF3ɰD@D3`ȳʠDG q]E-J-,@ ,q l- r-0 -P  -b Z.&& . .	 .' . /Q U@ / / @ /
 /G 50G |0 0   @ 	=Hewlett-Packard 68DTD Ver. F.13 0o4/200 06 K l۫]  Z  l ~q oKBC
sion XX.XX 
 
  _ 	o~AP#  @  A  JP12 Intel(R) _ prnal L1 Cachea Wbi2e	
   6PC CARD-Slot 0  
 8  	 www.hp.com ABS 70/71 79 7A 7Bw 7Cp
     
C
 DIMM #12#

~R&"Rvp pم"K f @-No baty,"
1_ @$W2_T*u	 a߻ 
yj)Ӏut&  5& A)u&
u! À8W@ AU RtY vMuG	0bpoRu3uOQtru1 ta0> S:u@K8*6Rw:EFu E0 } jQtTt̀t߀wEtH71F )t%> t:& tSuEu3é  t p_E>I q u	PXuP3 t_gX랓tS%yE utt0#)	&2!q =E3߮*x3;r.Dv+W+Xuw432#*u!.ð-*1!	 2<Gr<Svƀ,G.#] C%J {u$
<.r!Lu24$`.߮2K#/*-ßrPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ?;6 %10Ü   EA_X= EBQ C 5D P@SI Q }S CS= D@ E S I1xceptu4 - Overflow!5Bounds Check6@Invalid Opcode7 Device N`iAva_ilablJ8Aou` Fault9v Reserved	1]0TSS1SegmentkPr n12At@ V
3GeneryProtecErrorq  1 =  System Ha!PI+
 t
-XPR+Z fVfR64Fup5/vz5pcP=5Yύ64{4tfÍ64j 64`fX/ސ4T ō64J`64A0Ǎ647XY_WQP64$Q4Q4p4
64626F
0a5t}5]&5x5na5WJ`5o/@b	[Q G; 1`(0_X[S	 6$6ϋ p C8BBaa`a$a Μ@0UFfF͋N
~fE F Nu3 'țn ]
 cRQP~
XÊܹ /FFYNZ{1A`QȴjY`Њ  aÇً9" 9 & Gҿ90.&8'@'dQR Z
  c Z  
G XYZð
< 
7   b r  `؋  0 9  ^  #!
 	`O{a@ ؀ `
Uп؎ ]_aQ@]3G
AF q`P C0[mq$9` $<u 3 0ؾ   fϥa3So ]Q VQ=3AUAY^` 
aËf3RQ3ɋff tfaf3fRAf;v+R'TYX0P@YP\UfWf&`1fW]f_ff_]p_8f <u ~<  u<  l<c<@%Z<	;Q<
~`QH<i?<6<
-P= uX<~`<<pXL]WfPCI 2L*u_fQfRVWfSt$"r   f;ttN紃 f[_^fZfYffPr }  u
N`no荩  `臩 s r 2fSRfP]ȝfXZf[{>}ff}\}F5	vf s"s t s t QVW&= & s fPf&EffX0V N _^Y@VWPw V`;t
X2 *W 
_ߺ ϰ#tX _^!DNp sP6уufQ fPf"sf8 P8s2fYZu< uEuPPu uZ @PPE EPP runtime BIOSVers.1  
 @1@;@X@@@A?AdAAAAAABBBBNBwU .?]?.a` ._`  r  R._`
ZpQRa P<rt2[5$ԁ !Ȁ
  -" Z`5	$ gX op[	}/	uR xuR
] SUUU.VUf	`&n ^C=  CUWpV	al *Z usà @: U PSRP q<r
 j ?Gpp0^r
t<t@").>MB iy.sMB 
Z  Z PQR3쨀uAB$ԡ 3ZYXPSU"
ǐ%w	U[1Q \	a\Y`9.uWt= (u^
fTeTذfTeT20 TTa VR-txSR گZ[  oZ[Kwu? gWȠ3,t%p0Q0
ud8C9Z^`W-u=ϔu8qBp4
ً@p 2} 0UR
-u<腔u7Gt)訞衞пtڱ
@;Z]PGbXU 
 s ]`K:KxSY {M M>rQ4Ys.\ P, 3Z[x0"R`"P3
H 茝G 脐+V QLIQK y_S
 pN EqM =.RJc'
(<PdE'FoFFFF)GGPQ&` XW<ram .E_Swt 
' t r
2[e nu0^r!<i	rr& Qs" r2.E2& r $ ŀs  r 9q	8 r 	&& rr	 ՁôSs+&' @>'  sa$sQ
u>[ WQr%p$S r rq	A9_ f" $ pQ@	Pm uXa\#t sq]@tQadt{ bpt t
@uYм`
Xr`QPPPtQXdYQP*Q0 t	`DXd$!<!tPPP  q&@tPG]0X@ػ (`<u
 @&   >!@tA AuqPN@0  , & XV߁  0`O  r
 P<Fu u_s	` 	uA
 fu	 X RtGTtu`6FtEuUrPRtKxGr t& 0R] Z&&Duh?=b h^ 
Xuh>rX&  U uW@ ϡt@Q!	@'rr
Xrr蘖迡 dP d@y  $& 8t   `{QX uSQ^ `b+NH o`*C: E8011 @@X@3چNC*fjraQks\h&D
V &Dt [zj 
B jr!0rjsuiF. uiiI$irOjsJcʊKZ ~SiirMjr
#juayiyoiZ2
 0
FFt N fF" B@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
F)tЎ r4F$
Ft+ F P   !VPXV@"ÿWPR u	ZX__PRARZXfNN N	N  A " * Gxx  x y 1 " *
x"x 0   s w_X _y\[8y y `	b é-	T EtذE
UZ ŀ
 ^	r
0 t
K	r
Àxf`qi2tW & d_&߈E3ұB&U
&]@ &}EP t ûlN
u &E@ !4	f0 $PnP!  O 7O O7    e fPff  @ fXtfUfp fSfPfQfRfVfWg]?rdif_f^fZfYfXf[f]ge333crVd4Ad^;sgu` 
3 s M tAt<VrdDg}
^` VWq^gEdTg}
}gE `tr	 	t}d8` W<yt @Dh`PfUf]3
t `$u ' i.;Gt -._
u u 	fg6$+' +k`  0 `"p	- lFpoypOIEMAG  IZ P     ~*	
 ϗ `# HDA-L  HDBNs A-E r Cu ~0USB-FLr CD Hs LS Intnl  PCI-As B C  % eO   H	P 	/` <M oR` c!g"RF/	<R Q ?RCD001EL TORITO SPECIFICATION A=9 B C ISS
T8T?T-S;Sg]hO tO13Oh6]*
R uRhOY p9   P:SQ>Ou5 XDôޫ% r!<[3ɸ  3 3Y[ ESRV;h&O<hX[[蹐Ct菫t#艓 |>[P@O<t<t[Ɲ< tP43^Z`HXիV N[`Fuۇ P	4[ir
- @IZ[QmQ =c
ulgOOO2agÀw*VR ރ| 拴  t.TZ^TTUTUUP .߄UBBX$JJ2JBPܰ k\tJ TXu` ۊ SQ V tA&q JZ  C@ĺA @u*uP= ]Xruŀ̀2	
  (8SQ2<

2ۆU.
$2rqd$<w0
u@ð  ` 0     rIR   ? A7` a b_ c 0u Ysv| 	 i 0 w0j hp`3. W p
I_ϊ ._쑲p aVW0VS;fVt[ 
t[_^ސRW3`  Qu t`GYh j/$_ZSQV./V p@6V./V^Y[X oU uP`Xd]<tЄ r
td8D^uRWu_j}js T^u 
p`|&
yt,ـ@
t&M1&G&ayc{c`ncǯLAAAPca+Íu 2 ȃtm
 Q ܈$FKuðQ 
u	ۍY;YuS؀up>u)>4  pZ  Y&fߊ$f
0f<  \RWS22f0 *YrY Xu J8sߊ[_ZYfQWRfP
t)r ^ff  u 
8ufXZ_fYPPf r3r: t+a4 v 
t38t	
uY0	g&;t4g&Ct,g&Cf4<vf^ f٠
g&:#C1	`W r7fg&p	f`r!f`Gag&O@` Nb O q,p_f[b2p n lU C  Ơ #  <<Ȱ<<2Ҁð
<%,p<<<p<o$z<øl<
 u<\<U	N2Gs s	2 D< |05<.< '<U	  {2<2 		<; tN :4{;;;
;$ 
;$潡0; B;;$2
;òZZZ
[M[[[\.Qt'} 蚆<u 2蟆h2?b h i1qsjqsxw>sP|tqRms
?2  v"  |  n`W.D.D@m~ ``P\&&D aø0 ߼ [j &&E  څ3Լ{1ȅQ)PTP !1XY`.\.T	ώǍ>N.L` `r^a.D`p^aQPƌМXXɎ6aùU fN"JQMQOQQN#z R"fv dsQV"f>N"~{uf  R V">V" t&r_VuJbзf+`JQf׸@PYrfuǳQ	$XA>!"ǿu_f  sVPX"
f6ǁ讘u1Y" < u;X"thrP>X PXaSWHDXXXX  A  G@ " y" U-Q RG    _  *[%	ଠ` Gd d",q >Ga aO 
p ~NGr rrs sq]
s"  
@0_ 6rL p	 
 '٣ ` u # $t$?aAh@ & r 3u#[._`$ ' $P!0LذhI<u	._` u<~؃ _$\   tuu	V $
4 1PS@ u7(Q<uËذUNNNO O $#c#jbTbbbKb  M P *  " *a&007 *
r@-~g!8y Ay bYc é uKU Ë]PwEU  ʋUuٰ"r t
rPf`tJRQW %  d_̺~&UY U &E! ߀t &]@ Z`fa1c-  u(<sW.c_.`O2\P'wXs}=QtXsu..&+.	p]X @ t^PP.&u @ u42..
t wWPUU**ľ0&u XYZ3QP A3.Gޠ
X4PW *.WrWȎWW_ ddde	eeeee&e(e/e1e<e>eVS30.:SduTd`K`"@[^* UF~Pd2SF۹ S.\dF[wCN[QF?thdsF2~ tﴇY@ 7FJ\ @ _ ø8'J 劰dފ`d4Ao`03 3`3$ $)f/f8fCuef|ff`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233Рefۃ>0t" P a2ۊ࠿( Ҋp ) ǊȊ&)  * ߊ* >+b#1 d>,ߎ0.- &) r.PR ut;6X6 6 a3
t,=
~p
"=
 
0I5w<t<u FÀ t<  s
Ê& 
0<uaw\wWQiu& o` u1?Y`!AoK &
Ø0Y6_ FF;t2yh.h<h%hSa\"c` \0ba3ac]aR]q-D]E m]@`[\!K\ \{8\\M+t\ I|\ZP\ ZfZ g}
3gE
 t "6QD  [gu0EosU I2mQQ  
$0d&_E
3`    Fǿ˽	*k}>]>}
uO  O P R S WpWQ    U	 Y
 W W`ץWABC  P Q WR  S WT  U V WUXYAZ[\1]^_  h` ha hb _ic id!eqf _)``)____^_8MgaWfVSQfVF! s^(2۹   F  +^D!8uZm3\f^iWVQCuKEb! `O!0"w $I^:u:\!u YrƲ-f^Y[_S  [/kmQ.pv CC@@[Љ0` !Eyu $
`&aÐ faRМ`t$t ȋ@Z1a)uxuUk #E[$;PRZطð$0<:rd uꝾPP P wH  = ur q& fV`:PgfF`XRyZÜ0t	tv
 vt[ ؎ Ѝ΋hl3  SQN*<tt	fP!XfP BY`**QE{laYQuj* ͬY<u,fCISGu%f» f  f  '.>l .lñfPS P@f.m@nO[:.mf`uh)b h  臿uh;aúB   $AÜ.mEu݅RVP
x 拔 tcPtt>@ KXSx$P|Xr$*Qu!$
BB *JJq4HX^ZY[
 |   uTf`0D fft;  Qf3Y_,65 !? ?0м  G?@"W"0Lt,rr `pt4t p掊eh2撰QR3Ɇt Pw ZYJB3"<t$OAJWBqpvBÊۄ (uﴀô Ρ S3ێۻr?4 'uĪ$PMM u r_SYSID_  p` _UU  fl f@f=  uf3p f6P3Ҏ¿x ȫ@G&Z]                                                                                                                                                                                                                                           q
M hS    -%  DX.' p Jā݁2L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.]QZr# Mu 6Pr pt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF ô7	 [qv	 ӥ/H	r?@e۔.		p脀'^F&?s  s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	ffPEEabgVfQSjf[f/fY^f& u#f&GP _Wf   4WfZfXP'F#~r .u7 u/{r?`. t8.>u t]u x 2SrߊV ʿs`,eQ	p ]Q~t$` t u/~ǉ~ %"NV 1	s^Í6R.|uL>R..aQ`>P .:UtaeQaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w)[Y_0? t>ـ?r.u|
Պ Ѐ ʿ.E;v 耰'fVfv=`$dD @؊f
@NP.eXfa ȋP	rs$
2

	fX!9
dDfUv]f^PRBU@    ZXRPXuUW:>_]s*r  ZP$< - r!P@Xup>q ݪ@<@0P  *sX切Xty_>Wc >* BQ	?Q	 QV  PRW> P@   XFrr9r^rT:rOt :DvL*Dȱ f umfm4
u
rPbl
u2 VWrd ^_^ q QP&:Ev&M!&*E9aVBoCoz<@,rFAnr;A@uQBu< r
tr&wtptu
ZB\r rR$!Xt24 uu@uu`  u2&?fPS `00v[fXPSps;Qp`D
>X`?D<P4a`t a1t!$!"q1&2PQȎ`SJr#SMwO "t }
`P2:Tt
a YXÀuOu5Q,9a"   <s& ? `P93 >R}uǀ   @dQ  }QmQVWi<ua<
uuuPx H<u>wuh2<t.$SQ\A[|u|]
 h|`jt\_^F] }
u}	 .iQpcі܀}u	a`91@uDa0؀$'QV 3۬+^YD &!hfѡff?ffJf0^1e
c[ %f F PX[fP~$=r0&w) Ewfu fu Cu~qt05SV|t` t t
^[PfQ
  <  @ f	t` v%#aif`0ffQf k   fHff#f+ִ f;wfgК3g&Sg&c
uff+ffa
f@6SRZ=A>$pP0Cf`rffXORpC{ZruAZr
`hPR2q4XZ[fWut+ @ǿ> $F̑ 1!0 u>
rrw`Ua `WB a p 0`c3rSQVffl  U@PP  p^Y[u(PUFP | ^	u<Vf
Eo @pLP	r=^ uS@]#^[靥u"

 
 ^~u.t Uj@w`V	cL
 B8`.
u&*@-uq҇p&_?Sf_QfV @ =Ut<,MPThb &Ep` `&ufރa0  \f^fYfAoSUh &]S^ ]`&!& &]DDV& fq\AL
^r0fWދDVЎ &1 f`t@ 2 Nʃ7^~0 P P&t_ 'f=%_'+a¡of;M0E   Wf.哐	Zg&G_E!#3ycrR-uTf.Af_utf{`@]StQqY fMo!fp,p<  !f0p9;#3 ,ӹ;a!@U
UEG &E"r ifaɽÑ 'rnOGw|P_@0 _` p %؎`1#;`< ^<t/Q Y<pD%PH
fu f ㊁` ߰?t@Yv.M"fߋNf.g
w -"|B"#:qddP9'DQ:	: ; 0M;Q.:r](G)u{D > )uf.op `- =*VQR$$D
@V&T| <^30Dory9
l/Y^C0 ~u0x0"VBqEvf~7f(AD(8PVPWSPWQNP
P@EDLDra
fvNtž~2KWM T;0@fP: M^_1PTN?:'{ffWfQQtT=M
Pe@UBLBLBRL3S }GG^WX!WXV1GWiG@/(WLWWBHP&	3
7uO`gdOp%Obboؾ:!Q	TQb	`#SShS3Rq	)3AUEfd#S`eV_W3n `{Dku_qnGhQhhRV'hh/hذmO`pjj|t= cYj,{A
1$pf[ jPQRG B㡀u0@p$ q
 PSQR3۹ 3Ҵ./@3 nuo nwZYp'ÏXXXX  A	  " y y y? @ PkXWV1g@ 0 PP`p"RW0ſR pfˎۍq:ГW	?rf+_׀SfW.ܘuO |f g&$fD  ȋ? 2ۨu<@tut.3˸_ f_[Q
! YQ 8  ` PRS%` +}ð ;w[o SRW*OIr 2 3_Q,ԴAs0 Y r3O:=3ɰ!RQWSP b	$~X Q쨀tY͝l !`@ sX Jt	uRX( V_0m 7	XAP)[_YZ`2<UuX
8
DYJيBǃ   brT
!uaP [ 2
XS@
u	 T ت *êT<9VWQP`>NDt!WQp?:t
Tu8v
Y_pY_XY_^ _SM_ Pp1_DMI_ ,  #9  2XPUv F t	F !Ff]X"X
W8 ! t" i &g +  pa
u
fN@  ]ϰ2ðq  S\8`&G &GpG [ !@   栊ë@@\&\p PF0 ]
..c3 и( и-  2P
C@@ XWP/<w3t u*p O $/9F& ._@Pޠ X2$31    @R۳4!f΂ ufQ8?fYgBW[w<Ȏ3]Ou r 2fPS=Au@u;Áp u39 u+ f?wufP@u BXu
_?ff0`< t`%td{At{N|S{_ k@Q  ~{{ oߜ{Kj !qO E{P %{cW{Q   A&{?bm{op	rRfW. uom 3hff=SCAFtViG tfff kWu_f(#3tfPfffXpZ_32_p9 x
` tODu (B$
 `,,a
ô% ´+faPKМJt* u$t0$< ȋKf`a
%D	$߸ %` +z$pfa rU<
%	*P' @ޡTO xOy e*r$DIsL OROR|ߧx  Ƣ*S|eޣ.a UϦWmQ.}
u.:utL u% vt>JrSR.[t R.[u ^wt	xt_M_7EfUv"v t Ar Mw Ŏ.V PXF
Xf]h@ &A ϴQj@!
t0 rt0nK`$h
	OVR}~.6y0" {.t.I.
Lj@s&  |0u [^SV#0f؁D.d.$д^[w	ã3j0rcOt` 	OtOtLtDORt
mRtaRt[Ry

{1xu	.<.}h $ B%VUu	U#pp#?G rp
\Z@^ ƹfP<r|wfD@u
 dlHSQVWwUP&Br{ eXR,OR>y ..>{@1u oPa 3B &Gݾ $ $PC@&I`(US*B> &g01&O2$`&GAX]_^`&?pa s>` `b 
 }fGfE  Aסf`G!Z 3WP޲ 1rsG2vE<u` LuRE<sofQAM}3  fYr/>RR.  EώǿN./Q8[Üߎ_PQWV.>vu5pG<tFr=_.EP .&R>P@A%50/0qَɎٍ6R^_YS0Nt5ێË0S.q&Gf.R_f&_ .} pY2ZfUfCTRSf}]hfWgfǃ^#Eg ٠`ܺA vT2ҿgf頸gƃg u	f@w1  @f@f_gf1 gfgf0	arfQ@;gg&fG7~;wf+fa f7gۀf 3ggfb	fuP#fɰfa
t@@P	3ΐ
y
ff0
gf3j  P
@r!@
A
@  gf3fS̓ Š΃QIf#b ffyZ?'wf3f30n,;w6#`4ܼbf[gf p2
ffP	c	

fAȁAXAP
P#W!f߃s À +SfVQp g46fFCYQ  Y`Jf^\ g&GCffT [PfVfWQfR
/ШY_f^RWf;rf`ȿ u0s'1 t-r(@tD<u u P faUQ	U F @ E] < t@M
<z r`Y]p4@PQRbfv2`xq ^~qRZYXɓ|	qr3`	x tt -  t	  i09`K߳r5=s  "#@O@q18P,Nfѿf3u
P t  f3g sOfF!b"XtбԳ$PPTffۋ`U^~p3&fPQXLYqZp)YaP'у{ 2pP!8 #	$pfσ<t`Lx#f$o]ApP`doğfaá@䠄t"
   ௨u$! !߀tp &k Xa{{璘ݯ *q JJbK@P+F]X `j . j Pv
)Mf.N. 莵tI4~r@5p3؊^)tuw t&Du .⭋^^; a.@t&ڃ.^2ڀ36t6^2~. @ PSFݻg'.:t	tX._[XÜfUfPPfXZ+ f]f fŝf]rPmX n  r-s(@r3H rr
 rRVvF\r:Gs5&DC H Prfڋyk苡_FF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u rcwu
	A	Ϡt&D@B êĪǪAT`VcH Urp_蟁sʁ `-su fqt
]E$藀Eab&G )
V Nh8Kr>u rG Po3F) r\ {r=H r8{QWss #

Rr
3 @÷M1 |#km###F("r#謲Qlr@rk20!p ×!r"!F( Q'&d&K}0#V&Ơf)&t N.QSWf@΀u/ r)v{!ufPs 
fXtā_[Y`<t;f3f t	f 슃u
utǳЮ@;[`?
 3 P ܡ;phf<	PR[o W校F X @F$$<r$:u s
jtA$좌 
   @  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$`
ĢF f%R$PG ;B(FGq1ø fF" PXۋN8NwN 4o2N0(`00s?/ }mlB
 r
fQ/mru$贀fY_/+U+yÑ &u b%tr^pq? VQB  BY^	G $s
3
P&u3` @
r
%uèt?àt <q6(V&T߀Еߠup 
*&u^ô  蒂  oQPXuN%&:Lr * r$ P @uP<ut.@ ;& ; E q2s2p$<@t22P !$!$qX{w [|[ĺ"~.Pù[K<P~  = sffP SQ  !RY[$p
 F@ 
۰N8tSFt f% f @f tU0    ";   t0@bqP@fX
PRV s Zn!
J
8
0
$۶g4 Nff`4eA fu4fafFDP2`a  tfFP ۈ^DPm fp]fWzf=`3#"fF$QiF,0 As{rBrf-1fv,v0h,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfր َ pp#f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	ffvAfI )Bwf*ݸfwf
fAN
Xff%	G,fA d!`
;Vt
f5AP
Q
ĳ6"P  f%" f%  @"	 "f'F0002KFR) ~!.PSQR30? bff%fZY9PQRWSӶt"X  	
^[_ZYXS[  QW Ձ߀@+ _Y[pû z
  5u
 @ @Üu8 0  ;Pa@ F4;+@H0P ߈>%F5 N0Mt(BR'9ETDHP  SIMPLOiMO?TOROLAVP3VS\~ЎH30P-s@^s˻ʆ~ >/8>/ / /ܰ/@/8{SR &-&Z[>/0蠢0} 0& t
y@~Ph+؋Ò~c0c@	0Z	
0Q`
0﷩H
0?!0w68؎&3&M<St<Mt6 6 
6^Vc2OW o*:07><0֐ >0 @0ZB0x@[D0o7DVF0NHUEM: MHJ@	O6>Q S Ujh6)hh+ 
r)>50&~X^ádUY?t@̋ r.])`^ +zor.f%0[ P UCESFsjfr 3 1f!u%f#f P}	s`t s``u q`VQaff#bokдP|OrfwⱇfVRQ<t2f3Cr6@n
+flu g> tt Br(A2p uPYfZf[f^PfR53t?t! r[2fZ u8_-t(mr!f1@bt

J?t:R!4g&? t0cQfR8t , tu
@u${2Hp)@t'@u''*tp(tU
 /!-  t> `ASu2B[ a33q 
t@  t}Xri/p/B/RZ/rGU/Z3o@ӿ$
Ê Ӱ,$t PӴ Z
fVQ! 0fF3Yf^{PS0ho~ӷ  [@I$P_2*Ӣ1@ӷ@ 

!	  滴 S4fX 	ش  [ò}fV~W` _ W
t<5t^fи+r0f^=p5QRVPû  f FKYfۋ J8u^ZYfVW[   H# @ǿ> &=$u&}Fup 1u 0t r WD@t
_f^WQ  wtуD_ Ej3ɍ6Q.Lu.:Ls&3.D}.L~s` 2`r2`!t X}Pm u K^t
`3t t
t
u! 3ұ u _ú t>R.|` .R u} P J}uL   u3puv`bW_tURmQRUK2YZ6	u>^
 .D t+ t#VL^ 
.L ]üQ3| Ys. `)	 t	&Uu" Ǎ>N |  Êön.f.|f@  3.|4N\PQW 3ۍ}Q#_,`Qp1(q  `3$ 5`ht+aP`)}
t 	
t>P_ .:UǀV tMR_Z| $p$u$$<t;} ^^Q3䆊!*Vh R| ^t
.ͨuu
cs)t!Rڻ@ ۵u3ێZ
t	'u
u
0N`pǿuP@s+XP{t 赦ڰ`z︝̀jͨt"Ĩ@t  p 
 ް  XPJXSP .+. s#. sXP̀&  `UX[ó5P϶'->@O/HAC  I@ σ}D
0j@ t%v v t ArMv .sN-f-p̡&A F'N- aύ6& 	 !
P_r ^	
F (|r
 	u^'Ât %1+W	d1*515rz0/5Mrr[o[
u< r<0s<"N@PQN \o

ް' 
$nvf<0r
s/P@Pu.
I.
MȎ.}Aj@&u |t
  ^!N%V#~FpS2 ŗr20sus6< s
	OtE""Lt*$Ot"#Ot%" 2!)A
 o؀	.EFC
r]wsms1I9  <$u2 *<#"< u<@v<%p!2 Æ ]
F!UF%` ËF4~R=rqvP8fRF'P^S^!S&EF'f&U&]rQ[P@ [sSQtP^Ë^6R	Aؠrf;	DE~(LuTMsPf}3fXr1Q}R.  .GTAfh "./p 3V#:Ttv<~'t9~0l졂EE߀&Rq<D_D@ % 5I$~~6R06u0&Mf.Rf&]f&} 
0'Qf* r}讵rxLt=rl`x5rdPtZ+cr@ O u~ (um-VƎދo^Y@tffmݵru蠡Y荵r)8r$耵rre	rj}PTPQXw rpw
u `WBt:ـ?f.E`ff׷fAUffsP-EMF F
tSuNffaVR0WP*f8f'w*f'F'*2İ*܊f
Vv~Vv 4_ٰFsQU n E]YRPXtUW:>_]s#r  1!ZRP`2B@ ހ ZXюً 0oRBn`SQRQK0% [ĳ m!{h謀 Bt Z^N軳rot
r`a r}[v">R fKf OR, 3S5<s-RO8L9" >RG<}P#<Q$@ dIRZYQRPQX h   t޲rzvru3rij`wNrWwu
p`d7 
!ʲr.Ǵn%a@tt t	tCHa% su~rt	 2PPRwZF sH<t<)t<(u;ь>A u/WUӽ`x]_3r0CyPq`_^a靠'c`&PSR 2ZPÉRFtN+P X7D	F
+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFF  f[fQ
tW 8vNC؈^~nNfnNfˈNnfN߈n"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP FfCF VvuKQfXr+tðP@P3 G& tff   Rf+IYLzuu$`Ύk2t
.vN^G fF! PXG t<"u<"tlV3޾x 4Q&?s0  s& p  &G` ` G`  в&O _&O`uRp`?f&G`Pa  AWQb b Z Wsa,ZX7RQVW:WgtNuu .!6a u/AŠ ?L	
 t,6pNoAOGA&&d&D&t&D\3p;_^V
} " uRPR
  ^   @ teeTPQ֊@RP  4
W j <
1BQRs3ɺրOD.
X `.afV`f  
u ߃	rpwDr" sR  y6	pADDaf^U`@*߃2$ԉNT@׎Ǎ~WF$
&FG &U_@
	 `CaW  .d t2_R Zߊ؀ˀ$0ZQ` cЊt
߻p    %`  wÖ!FȎغf  T 333ۺ0I uF;D u	66uu%ps6#@q.ւ4ڡ	ҥ	o
`
	iS$ [ zM2Pr$< ffܽ0d bf+0ff,.b 8 !R  臟'  . aɀ=b\gf5f.4 ffff p                                   0ؾ />&  A6a yÁ26ܺѿ0VRR
Ff3PZN$<Xuf    Sr"fV$
Ѐ
t# `߰T訸U"T萸V{q9PPX
u	fpsV0?f¯dfY Ô"f Pг߄Xf2 WfV f  gГtgf&Gff0sf<zf   L	gR#f^{f_ Xcd(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457 u v5u t
&  {x_t^t]t\7ustF5R3< v
<ar5<{s1$PɎ;|'2o `r yհѾr9_2.kq G$!u@t0<zw,  
tզ

	t
w
 b2]SJ, E ?G@2q)Pı
 t"< t[r0r	
2vPQNs	} @V	gE9WDHP  XEPRuaa@uXXZXp! _. Wp61@Ż= s]rrs
0{ _ ߸^ }Qwt蕴.蛴} ! !$諐 01Qj~Qb;˂QN 3۸ K PX'  A G y   y " ËEup
$srt`tW  d_ta(    K P3B0W`%!r 8 #g&'fA hY `Y_f!@`$<t'<t#<tN< uc T M_ {H<u 5  %l  
 aS X#XAVW3xu@ G?	u1 )X X@ٲ%WV Z1 S!؀ WX;#*X^U$	ppquoWWA u  O HH$tsu21$бqQ  WD	0SkkB@C<|ODWDpDDPoKo-u@0 *XXXX%17   6   G "6! ,@@b Amf`g$/u (z$
yô$y zyfaRVМ?yؠy$tº^f` u'= y$艿y $qy$yyfar`Půu!P躿<Xu@P譁tNa`
  Pۯ@a  fV@ ބus~~t u3N@f6 Vv~u^ uq~uE~@N`R\p Sh~tE ku~j~u~t!T~vi
Op 
]]f^eU  	      pVG$ $  GN N P P  Gh hΠ"Gt1$  G   
G   $    0    %^r 4ET]                                                                   S7 A  h  O IFYOO 2	bvPtF X .	˸ pq && "  и?f3 f  f._f.{]p >` 6a  !ŀ.wP Wf."""U"" !I a
#
{ 
 f3ۻgf+ fP s fX   }l f@f=  u0p fl >@  t@&?   Д%Tu~ u!uO~ǿ<2{f]
} N] d `5dPQ3 2+7y4rdr
` r`f  Ͼ)`S[PS3[
P=@XQRsɄ3ɺ蠾r`r3t  ffPAMS VW@& Ў؀    u
  
  t 	˻ʆ rr ɍv:F0 & O 
 30&OˁFUWn_]v
 ` _^pw 1
Ap  MB RW3
$, D Y,&= @
,&FGvu-v $-p cu#' ). .& ` 
;ucb.f3ɐ tfu/a/& 3_ZGF  u2D@ 6sN~ t
Sy[ôfQWfPfSph f0oKf8 f` f  u H  $p`Zq>yzJf
gfārMf[0#t5f 0If% ;tf ff  ffX2f~0_fY`;fSQSW>c Q_[f  D fYJ{JJ% J HBf BBV DsB r9*j4Zff0AAfȄ ?fY
ARfxpffÛ 5Z`PXfZC@`}Mf@@u`
f<?~f"Q0#2!ef%k
1|MDpB$_B3E@1'9!*ףf`fݾf" QBY ffhfaQfRWf ffӿ fRf3fftf fZfOu_fbWryMtpL1>gLcLBrQLL G B = 8 3 . ) $     = Q5&GYÀ'##ǹS.0߆ `G fG4 HGftYGfY_[d? }#00d`z`2 F>G 5 f6f{c&rfP Ff$艥 7'CPqgf& BX A@'ffWfVfouzs  3f^f.FF.:$tF.|26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRS"x* UӞ.:f tdu.V.f]gu
#p d,PfdfBd3!+ s dMd5g}d@ J V],dP <d;]ttd|d]^  ~R A{
' ' FǠ  F/3 .;v+GuBG
`F/ {@ Ë% 	pXvNuQʕ NY%_'
r0pP ABCDEFS`ۻ׆[fPS^ۋ^&t` $ueG&uFttk]逳' :@~~~~l|8 8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>~`~~<pfn { >c8ll78x
~~p Q pp		 0``~  >P$ff$
50xx00 lllbll  l 0|x0f 8l8vv ``0```0 @  }<<f0 0  || 0p0  x8`̃ <l {8`p'  x@ |QG `a
 
|x  ?ff|ff ll bhxhb `=f> @p x p
pflxlf bf  ΀ 8l_l8` xx/p$ܱ x0  Px _ƌ2 xp``x  xa"x -s0Qx|`` p 8l`0
`v!`lvf0 x  `rb    h! vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
/ u=!f SvN .\2[]`g i & 
d@?að
`
R3҄u  t@a ThAE eMA9Y.nSS|  Ae( Ði
`3Ҵqu N <tDZQY
 Ir¿8r502:6 v&Z a1qP2PCI01 ISAF#+T DD03COMPAQ 04/20?/06  
E     F10_  Nn؎h Ћ*`h+3f  Wp L!$F10fPfSfQfRfVfWUfUCES>d  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdff	 3ua 6e< tf3
@d>Se   g>;f `ff3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>*g t
	RC su!&*gfXf^PVW 3W __t
r
>d_^X \ɰޯݷاбκܭ-.DD(|1 8     60  ``#8~ "!AS9>9N  : @'Ya;  @<@?=@/ &s@$	=A	I!!
0To!AY>q

( )))**LLHcF$$
G~B ~B
yy$$$@ $
  >""ZFYdd  #<r N` hx"'QyPGR<TS!2

	" g %8 0 p>$X	

$$7D81 [I 
!e$   A~4'((DD@%`)P(&A +C!Rs[^ZbgAvijwt@CVXeɊ\܃fBNݒ肩畜HHo׎ύXIAOԃeLǗ҃phdo@\Lu폜}JT|FؖcInI`Fڏڍ߃Os\gpjځBymGłrOڕKvxmȂ튮xtԍ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdь`YilWE십ċNԐUiTivIe^qlӔC~tE֖{pKrWoYMߏ[xb]# - @  S   0 ` R ?	i D  Q q@' 'TD ?g@dC" 
 P '1!!#"& p㚔
~|u  0
Fq% _p?   !  % )  fH	! ( 02 ES   _`00m) BFLXp0t  dEg!<"F  mY.$`"08D(#d$A|   UP W F  >"6>'p-@  ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@/@@a!!: ' ( <'Bft,0<<` *0`  ?t2pC DBg ? @
Ձ00 H$@?"@ 
	`0 P $&# DK8 o & `| D~D D<@ B f<,$$0$l=   M@ 3` B?"#!!  8@ `: 	{4H 8	  6 a@)1ppGp" `$?!3pHBQ0@S` P0ZT@L@\D2"#a#(RUY@>B&Z" Nk=bN@-A |a  %rm  2c  Q " $!2a2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxxpa1 
c
=AZxpp!
g
  p!rE  >>@@`)X0$x|pTT T8cCQa- :x b0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{!ijv+ d,Ds?|e0v0 a"s 6`S!cS,t. T8$9`0p6Gy 4g @ dt>$B<' @}""" c px% `vdnIi&0oW@P?v3$fv$d
  ]@^@.*  #2Bb"6T$-`0|p(x3 OV@@` F0Vpq 0uat`m|sG쁐Xm|%o38"5U QHU' &@'a! 3?! @( =!d(!3#\O2b" '?1`		
	`21"`n{9$i$	$	`  "33ak' l#?HzM8@0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,?!## DEB`@].A^! nxK)t ?` 0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P¿<  b <$  '  |D!  D| d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!}@ @Fq6pբ66@8y9@0ya؈  `%,#?8% p$'!G@x pwc 1$&? l@ 2?$?$??b < @$<b =$! <`0b64~
*  hH"e g * ~  <@ D=a<$" AL`5;' '-恴pp^  ) 
8hRF pà2q2DRD" T@""z" ""sbn0 CF`!  ||~ ނIE`<aBzd, %}IHT! Q㡬aE@AjD0p 
 .:23V!&    B5I@  `2"R`   @;!  0`'|Cd p5D ( H H  0
DP;6Oe}  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c2`."b4'?e +"@P,  b
W?BF0L 02?$&""  0p	 x 	#`4 cp$}R S SPpP? !
(#?@@DDD@"D0!cܱ 7E u0DL|(0<}t |` O=>'4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Ryydws7  H 4?b2C"cyH@ЃQnx<0	`Z ̀7(3 (`2)v䂣&^?0JbW8l>~/&23
b21#n0  !7$ #L`,!3p$?mAq%$"h| "  1  A  }    & <"rV&#0 I  81 c QQR0S"PC 8` A a ˀ4 usn#? 8ٳBY 
 Pw`]IY   ƀ0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>ǒ)jP|D52D"DvDTDD6 # a|b蠤,  1p#\  7ajė=  4a8	  O6 P>Tڅ  ptL D@~@Bf$,892k&arg@eP 1 WpxPX	 ^x! 3"&,0@ؼJD% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`	6U0` . `09H~ ց 	 d~@*H  ~K'6cNCc48x F?~!}BC  #" te `QP060o! = 8!` "***" /"$'$&*7"$"? CJ0``]0?~$BdB  a B
BB~15,"&_D$(-jB ,!.	,HO
 =I H<H$H$_I$=@ @v 4R$ze bUS R# P|7 8y0 ;6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z  $D$= *XGGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? ? Wpw 0,0  ""bp $ & "  q?2@G%
i-_ n?F:@ e$ a  ⠼@
#<]](00]V?$P?			?R" N8S8

 ek| 0@	~! y 	 	 ! o>"W"	& ">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDṪ C
$>?ق  '$!$34, g A#A ;<8`hOu `&#f!b6@2~Z*\*jI0 Bn5	G x RRptF H0	    	  a |$# '!b[aaap <2zasR0A: <  B F>lxPXHL0F`Cug@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs"`7 `C  `rL(  fMQp~" ">a}>>b 2 "&"cb@	"00P G  A` xz   Vj_@` <1p0?3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{?I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~?B$fiBFD0@ @`@.AY`M`  Iҟ2R2RR 0Bb.	4df0.t ߟ""p bB ?~b
(LA%ɧgUE``AC}}8@Tl@l$5?b5d >qicQ"tdaxR4䣄	(	)	) ( )H	p ^c 5>] 1 aA#?~"! "2&460ba0"` @"{D1 X8@ @0 P` !bF! °?(HD>!"? |?" p?.a ee   	 `p13"fud Bi|"@Acp>@$	,	(	88(2lO"FfÅV@@`'$pzBp03
D(z

@ 
{t~<$4 7 a  p }#@B"4&0PwPP``? ) )?)  ?2"/y1cI{P?pP	|@   t   uUp cu`  `*	 `0 ..1S.1Tmp 1  [<u.1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.1` a2P 膅SP!bRV{^Zu
`R\ts 2ƃǡ G
a!O sENjpW1
wts2oa
 4<
t<
tD<tY<t軮 P  VPP t	| tL^fnat PwDXMCÀt	F¹. u 2 4.>1u W. 2 13 `.1&1 u2CQ2P Y*2Ȱ&P a RDr
.1.1PSR  && oZ[X ` OCp@p
oo.61FF2!.WtOT_PG-p
QR.61ʊƳP ZY[X  "2S2OsP2 sP
XÃ <r<0 <rp1@1  1.&@GDu'F!13!ba01.>1P20X;2$CF{APQRW ((_ZYX. 2.9 t.1BA	#+D<u<RaN<P<S<0<ޠ<{<<<`< T<@<.>1 t3ػ@ .1G.11O#0.1.1p`X@Y 0..1.10;Pp2?  X:XUFN
ȋNu	F] S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M
> tj6hjF_d&  hEfK>.RIW2o1d% = oۘa	Gg	 v	z]G@VU?#
,
#&d% p$2>d 	VQ	J!fbfff_'bNzd|dmf>d1Ujut$QV`		zd		A	
`RaUjf	?b	D@xU(
E
C
5a*HRx
2+SF W""UQ?zdېB B00^gTP>	iS4z\4!~}" 
y$A:z&&h F(2xV*{BX@|@^{";}d*	01d t<kj9FAH=djQd$g(fh  nK tAt=dtfh jnd$5wqtfhaLBQRQ
 >tSHft3 tE>2e tjh2efjh/I蚐
 >%j hdWn1t2f t=ffh}Kg t+g *$f3f
ύ~f PFPh|@Whg"7" cQh!3׉F``H[U9=#2?h|eeh |e-xod V05&	hf4ƀB1FİhYha1	uAsHFd[FdHFBh߹bFP8t@ Xwjh!:]
	`#fhgB(AYIy3Sh=dbV=dЁO^0}5%h+01!4O VSEC*hNnKh4
$ĳO	Q"D	{"^_ 2FF4g^ F&_<
uI) u&*_&8HgtFFP9 ~1FOuÀыٹ F FIuF+1 F*+FVh+;u;uàh% ;Fu	;V@áhG2@A99h% 
Ð;L*	
 WPQ Ffj h<SCk)-{ wf fph0w":!&b&djLofP
𨻀~@[j`PQaj FPG^FF+"aP¬V=ut_ V!  )#tGF|ǯ T024S|[` h & F GP	FNuFG0:?7 

yOh,HF eDaA*wFr/2S 1p QyQ>]Ibf?rʿ2%#2̣aA	Ce	$r
5oBbq	F nu@_d7?HWdAG3U &a]"S
R@93_4FUB Bܢ& !d0@ *a
`urb% +1b1bjk_RU3pW%5rzzd1ϋjA
@ 	a	U
`h~3$$djD
 {*E*
CuJ @	H	N.g
3;|1 ji3
X.jS⭡
 U@(dg	'ddRXx@t5f! @ q'j
f&dFt1T`7  # #d@t#Zy";<rP(vz=Ps Cb@\C&Wda{B47*C GѪ2		d{djT@`.;d `&@dqwqP
d 8&dǃpBv +OMaM`& &O g QA 8^W H⪸PE
b 'fd ߷d t}
aJPR`@TFHHb!!Е^PwѵFh^F  ^F&F~
r
f?&f &H` &te^`h0@ ~g^@ d_2e@  힀f# r2
/Q!|@ f`E  p  V60^aF@tp1t`hte Z2tT2uN&ff Hf 249ʀt"Pt ߃vZ 
U+%P*Hf@B<
		!A Qt:8O
teuUԲa+2@`&eW  !g
d !r΀&ddOapmn2o6tD M@9".F2d$0` d  &dw.j `j  3
vB +#r𣍍Fz0c
-`B&g(&g &g15&{ˣ +&C!&.&Ƈgd r<P\fhJ`a0:1MB>~dxJ@>Df&EfFVDAFLhaf|e	s$U"Na40O+O=rov|eА)1uDf CEf[Ff1@tyhZj$	c>ZjgFdZ	 Df$ < u W@<@/""rӸ`" س1 e#|b.(P94143 4L(vV]f2^ 3 [P
3t%r F^Nr'~#tp  u^    % F ҥ)A^  ~u +ËFVVF6Ƃ6~ r~t` t uF0pfv
~0V3}2,pIuquS׸I]]?[t

 ^^p.M~  f# F FB F~P|v^ KF NFFV~n Ht@HtcH P )nA-Ph06^F&߀? u/dvA8>Re|nhXdΐ22bcV;3dv`fdNn`
NNF - 齼$F8hFFPjRh_S{^/GFPv4FhFNnoP?dbPQdѕ?:!Z3o"`&@0Uc16`b`~2|FtFr(QW^
4~`4	b-2 _`-pFFVFQC94%~ t;׍F4FҔ0
z u WV~vN^?>S
A0@
^_C
"jY(c
l`


[t ,md(|WVvԋNshODRHAA~(|W~FIt_~@u"2F#}HFB^F&W} 
 
.APU!u<@## `fVkDiaҶ
%%		 	F*Pg	}`	
 g<d-UWVv<t~P F
&wGFq&'h*V~ʋv!^PFߊGIub: ^&^&8t #^^}۲h!#ù
 0GF N}% }p,-Ar  ~s԰ NFN+;u0g03ɋFppAFC&PfSpfF ~0gЋڿsGs^AaQFp ~
OvЂ@x|r
CVV,GV~^&FIa&|a8Q_FQ2d%p"U>BT⻐IkUbf?NQ2&A%#B2
= SpCe	$]Q
59R
"o"r@UGbɰ 
]2˓@V_v`VP
b% U6zzd1|djEA
  	mar (T53dKjD	A{@E2	C
{U@	H[
N;&U
S
	 U@g3|1\ jiQ*biXbT~Uyc	0zC	h 	"
*x@,?Z{"7*#+ !77&d_{dfđf   |ef1	 fZ  h FdNn؃2"a 4 +d=dFrB&>^ Vw@$HxSԨPFRJZZ)S
Bj3~SQ|SmZP RSӹ b >j6h@TjFd Uւe>bIc?wr#d 2[ 6M
$>d 	u^9?od,\oyG %]@"`fbf	ff؃vrfzdRPXXQA@=]A \,a$"K"
DxE$
C4
T?
!!bH_Jq#NhUazd۷B j)@BSpF "4
gPL/i)p/~0PAO	\997F`5۱ ijh!VAQWVvQދ~ &F<t<
b#rF*;b}7!y_~tF&8toFu|t<r2V0^u	A(|Ðۿ ~Pfh#   0F;rF f{?* F p F*N*ȁ vFoP0AvO
u+4g^F  FOupy	fDg &Dgv tlgq0  2 &h{22`% u"h$< 2h%h1hu8q= +ɉN3h33 Љ  auh$<u~ªh% bPu&
u]f2 % D0	u 
uyB
 )g
u/Au#a}h%FO2 4g5g6g 7g8g	9g:g;g
<g=g>g?g@gAgBgXA.MpҶ f3 f rը9*`ujvRPp- *`F  vB F¿~2|`1~PƿF  p ~ uF|epNn
 f jtV *`FRvKzF@ b*J*p
NvQϋFWV/yFFP
|Fطfٳ-ᾗh l
'F܊f ӽF֊ft@ t؉Fjvvm!t@d-~oSt` su_P0M2muFh.Mh @=Sh vF޿fP^Ff ju"m:=ǰG0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌv۹p^GFApB Z Bsư FN &p;u0&  UN2 OP NXb<t FYQK`*`OBA`ޡ:aPj?+*
- e)@pp NV$^|"`(` `<1`劆2?d$0   l`y2$j)g 
CfۆeQ@hЎ z0f ݉)"*- t*-} t94@!13t$RFar OEJIOboLM"F m0#"7g
1-(  GEBwAw 3 3|
/.' /PRqz6pUd qa"$`1gh/ب osb!b1jLFPa
1"j9)"#2#"&#AD/]PDE@WV3 WD!^&@RFGo|吐3x]6 2= R&/ FWWqy` r27<"RMW>d veb!b6   &=  C_  FtA p| 
@"+4g#-//

	
|u	( .MPĴ &&TЫUV~S~ t'{jF I N t/ u#O'jiy'qt= tA:?`>u
f&Hf"f2Hf% Hf  t&f1`ul À&l YgdXg0fhЕFfpff[fh{e`b0b1b_dUU{e>u-[h hJݹzh Z1菢p:r@juzBzh[^NA4R^ 	'"		h

 
A_{	 	 	̢	$r	B		2b$`F&? t5 (u%&|Rup )u&DPƋV@0`FFbcvfjfh 
 fh `  	    } Eq~  A u 0π&zd F B>`)tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  -P Qj   8>  &9w&EU 6`  VV׽ 6E   9~ H  ;py! 
f
0>~ KĀv&@u?PM^;  vĴ 3蔿fjth  <ܠnЊp ,`` "g pvV>B   vVP*r_F^ ɀCP% 
P h
 h  RaNF
+F{@pF!vvo 	F,`NQF@ hbj a^pCFPNQ=`*P!`VW  p 3_^=e #,`  @SᄊFa
Fg,`AF.
%
;F|!%} F@P!y]!Vv m`NP`rF^Dt&@A$0#FlAQǀu<  t (F7 PF@5
  f#ʹq؉L * yBఊub~v*VA Ɛ2xƊ*} ufU  oVn'] ᚃ> t`ur3NF\ ]NZ&8tG[ vNً! ^GF
&Ft^ G +tp
뎐V^% = @ʃ@A3t`߰ߋ@!A;wⰀ>
 u31&A *;t{r1A 
*`FD0~F
tҕn t" `fp0;
V=O`2B|@?Vu	.SEHDa!E'(E zrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 u31~^
AF9G^
uN3~(~ =u j  F;|;pUD  fUVNߋVv<%tF` u DD^ù
0NÈ u0+b1WQˋPWVFM3^tQrJ;v~ F^F&uF$=W\qQb]R~}  P+΋э8s,dvva!V0N&8 uN = tp&@*m 0At߱_mf6o !
`f_+IQ@bkqCTN`_S
ʐ kj ##v&`j&F3v~Bǉv0Q&} 0{b;~ANuǋv 0dFA[  
`FfP0V6Z cPQ  F ~ ~
~?h3ҋ P{W t4hP^v?{ePq 	ptGW5o^"p j9Fu
q_sPK0 vvc#5+PFV ّ00NvD"F9F}+F- P@!b' $q YFF`%T"[ nT\QPEP)DPAjEP:! fh p39> ~jy/0 *9>u	A
@0
A/\&76I%'@2)
߃
G;|2*& /P c`z8(F
A
j Q/j V@VRPy=AQda'P? p<n@]c E +FFVda#
0UcSpbYg 0aDPdQ虡XQ	5Q`,+F+Ѡ`M*2X R 3Rg@=PDI=ӁF3@**A;}Rvs`V6rqyg*@F;vwPST4C
sR14+

uSK#aQCgPedD&A84	PeV輡VPɖ!~&-24hQRptY~AS;}`=y#DȰdf&D&T030`~
м  q &Fި@u[] ᐡFtdF;@Ɛ]q<ЁN b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~ $	;FF	_F|	} t~0Vg~PtOC~ tG\'F
t/* F T9F}\LF ;F~AZM
~~2G+F50%&L
q DFF ^0 ) `IϠf@`	PXhf@PF^U^EAgT`X2s|Pxb<FA@ŀ[0H&v7QvFv;FՍ\Pɒ #R@~'U 3'tsF+FJFHfh iR( tTT4v .9~4aWFO^6,+F!}=pu.trpSq &OC@ +σQk._+ǀ
0|ctj[|Qu

FB.=Q j]>| LnW0!L# ' OKCA& !!ypa2#$QBC}P fZgpL@>Zg\gj qWw 
Ht8-t-9t- 	t "f 	`!QF~ tfFfZg?F  F
Pj   v
u}1Aju >PHPV`
Ϲ!&_wc¯_FtB$zP
Q|иN	VV2F
t!@D% QD:
莡Q
VQ6 B tDu遌Ǡ
!_؋!bGv C `uDPk*.e H!MbB되9>u	 rdP`Gg	R4O1miDu(+Huwu @uqt j	jfh	m	"	PV^FPqf~
 t
N
>agxQEPzU@ ]FY m DVVjvKv{xX 6G ]3?PS800a2Pr~C]wF0B)@UP1qE~
G jR[x807+$ }_p  9]t߲ #)#/E=/`J/FFP9 \ dpg
p; ;NNNoQP @C7 Ƒ򠽋= K = ;  -Pp---xАW{p'Fj  ܩk o>g`{ Pi;v1!;vFPVW>FP~FPG;~~P1% - D- *-ࠁ#- " e= Pk/'-
|5. G@6- ;jsFc?atU /tP` coFa~9Fu
VVIVF]v9vu@PN,PN  PNNRF ~9~};V 9vu< uN0빋v T` 3MP Pp & ^!VN;~
u逐xA^F;~maXS `
$~Du6g b;|qT/QN;v}O;Ǎ6VQ9~ uFAِpL怰9v|GNI00%9F| ~A^&+^& '/F'302F u!ihj@vVt ;tt D@gx3|f4W_hyl
 rze/o~I>FWV  Gc Df tdU@ @ l tEf
|tATD\[u0Y;F~ ZpӁrջN@uOp0
DK=́Np>|e u)>f tl>h tt >Fd t|dX yhb?0 Whp.u"jhbh.`ݠ
j(hgh@`fp ` J `h=dh`+^ `4 `}" g`m#.`ak%@ gBz"	j f% Jfs%^ =dc%	 +dS%
 4dC% "d3#+(`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#Hj Нpwt1rt߀DODpU*䊇>AvuA*HWvAPVt0<@p& }55J4465245r659htM@Eۣ@ jpPVCpWVh
	 !V3j hD	~DXր`HtHt#h !    C wt^ f	$ޤF HtHtHHt$" x@ $Ѻ&&G<P jh	G_+P舐X
_G>7x@n ^aGP0v&߀ ~RrjV6 fP)3P Ы>X F`~|֢"®s}vI@x	&8 tr
9GPu   >p~q9	uarf   ^f~ t  |֊FÑ!	eM?	L0#	Kac{ 	3$聣0(`(hO藼pa^p3&~/ߋtC&  v&8 u*C;^|5ckF^P9Pg`^? tvN~}"v`<1
ރ~ u0gDFG&9 uԉ~MWRr0~F Z= ?-
 - Ү<5 1 ;uJ< tCBwtZPU-
tKŽtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@F	 f0 % wt" uNj pѲF  B u
gށMN3~*^}
7ފ 8&8u	F;|,Bdn
meP $
nPڋ P\PC 
Cc!
d$  *8fudg"^u Q/	tP3`0F |n FPf@
t)fo3fn @H~pfh j hah` 4z$u @3l3 1K`F*A;Ht5= t	d@ &d鵫 ڑ.dQu鉀&
:	@
ʠ
 &
&
h8hN
h ?AA7B 
@
@ -*

@5q&
 3/F! "&d&d *gmh*g!B"  `FP~H| AKN
3a$\'"V%aC:GBHF`[^ ZSa0$ƍ&Í],3F
46 x$dhej(j 9
P8
PPfsV
bW&*`)@&` ad t&<
 <#)뀖 _x
Q$ %'@q`
! Ohej  %cbN0Tff3	諠`%  Piр`RB/
?
$*H0/^$&40/04TRTR"3`RVdsp%W
$
aH*=	- I- 9t7-
 wqrMt%
- Ktq-wMtr` MYnp= d.
6Rhv{2,2@0`  8&`0'zuR!"Ր,W20`  0PXu/1V hh/ ST  9YۂYݺYހ
Y&"0Zd 蜊a=	_[Q["
@4 |
U!@ `d`da0y@ Vfh0/h y Pc@t&
 
U@ UACCUC΁!#!
@d`d`{
Ɛ
r4(搐 + (#+-+tp*tcmKt
- 7tu] &`1& tGv 1vhNh
h P!wu
j8%AW&A
G-C@#'$'Na'a{ߐj3؁ ڰ @o&
)3bPf n
0>{+^>>G>d'>nu!>/>f'>< Ћ5Ph$pD D:E4(89HR4"" :I%9
5Bδrhh Vq2^Du+!{ 5 31;ut.~&`㑮S7AA@A@tR_!P!_!
@>2aO? 6~`L.àࡠAL&`2a~?<!Q"Q QА*|3ɻNn &ArhgOE@zQps@	X^rQUUWtD3,i
藶; YK2amrFv!
oroVv0%@tx$P!]D$$T`
P#wBf~4x0%YAǁK=rD=H=yMߚ2a;Ծ;
fhZ " [VBGb %^
tn
]
ct,W*@t>_tq f*``(@a@1)@4nAE4aŏmƏCQ M M# ғ,Tо╱$ $ ǆ* 0p %@@$R~256j2`&_ 	h$R>'
2FD
	rR6i%Tp`p
6atS6`z` AsP@A di^
MlXjF&  &$2\jxƨب#M"$1p  Ap#!bb"Cb2!Л5a@z5ac `!뤁 a@^b4a 2 [1 lfbW}1`0!@d!(* q`f4afd"Wfh  AA0
SÑf_df0
 &d>..eA@6d6 A>>%@CF$FaDNN dՀ&VRVCF^^!HvD	v u
~୷um3
u*
u!D	utu7d`upf  ,ǈjrhrH2vɋFHFPV7hP@%ݰZv
WVy0
:akHtHtAt-L8O+ !N!!LrK
'JHprTGޓ>t%'@F@%G+E^T`Heބ'TP
t~
G R`,  WVf+fF@ ؀  Fa^F辀 F FFF>F^`F~D>==   - -tR> ?-A -*t:- ߐ=+m-ᨌ  W-1t}x$Ht/Ht:H@AC 6  (  c!"!13 >^b" Q(A
Fy
t)j pePdPfsVVt9p;@@a6g @a!F	p 
*HF.M~* f  fFvfvvFPv5Fu63F`. ~%v슅a :uFG;F :k~ t
& W P ~@&!  !qq t&A׃@ ڌ?"Ht)3Ã?@ BҊbbC׀&hT qwf>:a u×uHj k
 3v0 RHf8aff >af a ^ ~ 9FhԫD R
8aHfA3؂8-9t- 	t ǃ`$
  *hfjj Ya
n 5	G1	u.#JNuh FƐ>a tu}Áfh  P	2-NR蹠>^ `6
.Mh45B0hB63ab& ^  F |b rаu
?ScA >p#u>}p\t&e~l6:aP^ hbte3_b13^
>>*u	>~ µ0!jj22t;ua3Be'kJ t'N{80:2R%4;44j@p_r
x zP@ р!F@[$
û$4M*tS?=<=5
5
pKx@a	 lABa	 	 fh+rDW-q
p^pJ$#;$ r%>/0b2e
bbdbHfPr ) d= $Nmfg1 *O2 Rb
b
^c
~
֣ }g
0h
` 
"
 yGw@A] Dt,-
t%-.t,-	 tE-
tYt- t/PC Dѣ:a:B~} y_p}}J  oUVIftfwu& r Ift]u
Pҽ0tHf@  -˾@ut呰;>}`  Pr%h3pjtXя6 ]HtHt `t' Q ^hou
^_ PWV3ɀ> N3һBrZA@ߋFPWo~r2NpDt  & Q FV^tF
&ud,
,,,L,,, v,,.買>uh hNnho h ` jh
e/"
@ts) 3҉
65iP@;@)}F
r݋F 
7h͢	
J@u
Zc 5#W<B6f
 ~ĲfDg v3ɉNv~FV
tut9v~O|~*~Pӈfb^3
GF&/F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$uMG

41t%I6%|bpfbfffy&h}  
bt߀&
S
 Pj@Tt	@t`pq` ^3

tF^&7F!u	 |03$~ F%@
ƲEP2̀nGWnrF*F+= 0=a -tX-  - 9B m= M - t!Eh-@  Or= E.6hs/ /  p- 2&b% +11b bb@ 3 ֐j5B jh
@E
 C
ڼs / /  (YP)@ wj}Q'3
^'G`hoh5؎GS.bAcbh, b7b$ a
0o&
c
]Q 
@DM
F@f 
fh0V" !B
p.pfh,-`*+() &'h%0blrd t
Nd Ǻfu
P0  O hE `F<tF$oh"B by_F -FC|ߊFoà bG+VA" b"ba!J1"PFdq`iLLۮH f`OeO UKURDB
]HUT6P]}3
Ċ%U90S7D
B
H
U
H
>U
jF \Xܭ\E_	d
ZR\a"2C `hDR
>B*eHD	
Rphjh'TbT[jd
r%l#l&5n1#b*5p@p(z6Er$YB
*-   30+ +1 VV"bR	UvB4
!d4,Bh9ChLBhBh--
|- h
- Kt Nx0`igg`ggVC] *8`pÀÐàú*BwZ =,2pxf ^ ab AB  !"  A- 2&! m{dt d@T;ĀD+-@j|)"̉]IC u@sڀ## Zp$(A@u0-z!`5z b| wfC|=Ceq!֣W?zd	fzdf 0d@t! ! d?t&aUCADPЄJt &hF苨ӎ&? t
&
~@#@

B	DA
TCB     @zdzQ~@t&fh{й#!$@W~fhBh@
z762:tfh<R:;h9;
P 1^12"A?@h>7貱@ՠ`	DCh02eWVDf$ < u:@aa@<@uBoe03:@ut1ŋǷ;>@`  JrD h>hDtt1>66(b̕ CuU ` Dt,-
t%-.t,-	 tE-
tY- Ht~a- t/^C D0(b: ~ 3 	{}P  ۠<:%@(dF  zc` = P~Ht
`q j  r jǾV@uf4;F~  0كrN?@uO2phzhgWV`VW0
r?vϑtet
1 &>H>Htet &6dk9$N/06 M΃ǀ&.PK.-@d%.f%o%c%FrhL˿h@$
 'Fs"*b(`& **bPeA u$R\7 huhZ^\9  t~@ ` ߊp tPq j`,*bzp0u.&@ӊj`&ݒ"xqOF80#0000*0000rٽ0VfvfhI
 Jru ~oh :eߋF`e:tF&<:u-FF
*0N&$   
u3麑؀C7 ~ uF	 F
 տ@L
 
 < w C
v`
kVA
jq<l^P蒡"򢰵
? 30
~ `~ tghv&~ tD O=謨=u}5 ބ`\
`
 ^3 FPPP ɹ^FF9Fr @% -
 ؋0v v sd ƨu`= w͐ $0~FP.acy ~ t 4FPba    R {F  : .E "  
Q p~dzt' 肃̂OFZ.IZ#3^ \l褟AhV.tCq u^ GCauK  K /.g"
Q
Wa1FI Nr@~u~0G W    I @FB	FV!F^`=uFv2N'22g+}@]WV6_Khh_ֶy*y vyu}tyH4H-H4HSH6PgHy712y6FIP9Az"ClIDzߡza
"zj &z<f+fF@ ={  ۣ^{V^KFP6b^> .Mv3+Q OY  l`- t$ fFf~ sA,Guh
h$`׶ܠd fQVȡbڙRPSQfXfYf3fffPfvfF fh  bU
P 1g Fvh rCQPmdK PqKwTM!TnayykE  p 4  V_6rNq0	% 6\bD60g\ 6,g|<`y)
Ԣ]aÐ3Ð   MHz` KBSIMPLO  MOTOROLA  HP  1.1   drivelock   B Computer Setup  <F1=Help> File`ystem Information  Display siSave to floppyconfigur diskette Restore fromE(defaults.
  Ign2hanges and exit EP  s! withou>aving
o Securit@Administ or passwor4Cte a/"Power-OnWGp DevGicedBeDgbD$L $s mart Card%G
supportTPM Embeddae&E
ta!'eA'et*a!c',(0sd*authentic+
credal Auto2ceTools Ba`/0Calib( (`^'lectb HDDP:lf-T2 op8s _Activ O Mem
C+he? r s ; Sll=mb 	>>uA(AAdvanceaLΠ4uagC lD7  o?f gray6field Bo	ow1bD.E.ަPres1>y keyQH`I ue F10=
, ESC=Cl @9RAccep/=YesSNso D, Ao$r=MN xAW  UsS>arrow
 o highl@ *he appropriQmenu iZKp"<ENTER> PXbegi)WK%#.followM%[&:fc-> @KSPACE = NexR3c-BAsCK@vio"8FgphTABE3~iSHIFT+&*DlF2@&10`
[J #'9 Er This60cann)bmU;d Awn e oc^@ wh0t6c. qde 0x0K1 eon dApGu@pp{6}Crequi @yy<`d~kba@%mu0C
mCovP:  z e4k/MEU) hQ1&`0jll//+2SDc leOsu06ssfulManyuZ rr  N:0
d:Pro utypspeItepp+CacVize (?L1/L2)SQ? ROM dd famiaseP8l nupi 	Videovis>bKeybooFr06PverD eY1<ZI2e3bg41qa<ownPhip<(TdG
W
O3 O	*	jafХda{5El%BSSNZC*D$`1
2
3	MIE
C

V
 

4CTV
o
D o
SoB  : 葕AD.   %4FPA2d!J#biFaWalRX0s&1&H} Addline4 AlXn.eFdWarn: 0rk Tll0p	o  zs᧦Trea /, lef ea w0abLp<pr A: 
pde` waqttҰ_)u  րrnInv ȍOAP
)!	%A gyou ͔ wa@|to  ::?  iI  po`b+-c(Quicyk`n22 (Cvre@sʅ3 (S.M.A.R?.T.) EP1fpex03im@s>@): 30¾# g¶30%v}}`t< y ho#0#uprХ:f1't4	f-Unknkp{ilWR!mSesrvReaPS)doџt7p`?a}ribp	a: `exP"9 'b<G H  Ol New Vfy nY7En>c8Off O 	 ɥA LA66#%&AKroE   p dV
Ad 1ݰU@ҭ5Ocpcaus7Pp@=AH"h` A&فOpower-. AS΁Qa?U|= loss  t(dYAhou  nlco7f aQgoH040)ev`۰?[YDocHisshR`ed?!0f]Dd;di1al JJe HP`"UTool Cr.%oF8IL4`ˣ Bk g Uмn qp)m`@jtWSN (!arv0s /UAcwcOP2"Onj* e:Z%%% F@%԰#Dn -f  TndĠfӰuCnuR?*$n)tartBQK`fra ParP1yNsza $_mediaa\Al Mm}k ,n LANsQG CD-q0F  yD!7C|U`	Q4 ab#ouu}h uR[%_Q yb0USERBMAST {hapanpR<ccUrEW"keep iRaLephysG?p1kr  :mpcr. I9RBr0A#D
, nSUZun -B5j JOO1Auto!Rc(Edw \88I3?#ON >
(R[_nR~ lFbur Ct@_!R2th`Ssj1rw  k uedmPerM8d`qaff|+bdata,@`ossibomaANnigiAE!VK IPs[pl 
r5mmaP  Wu`|l2,orepla^yr r/* @|4} [0uB Ӕ,coHA=Wy'u~m
e`1r, @MV`*ЪpPxibЩty. IfrdoTʄw8`AESCv.!
t rV !ҡtyp#
b'>'q`F10"qPrm,bs` {t+  E$` MiB\jQ  Oru: zU ay Op@XޒDCgDL!bA (leCft`/hUSB t HqbSu K Z;ipoFir oA0Fthvifp Sixa Nh ENhASwap Fn/Ctrl!s KtᓃU.S00}slegack cH `7)n0=pr@ry Vo  d NTSmC`AL -J #-MKt
BidЬEPP ECPd2size 32 _MB 64a F@p_AlwaynPPYi0ACS gWWD Radi AkBlueth`/rS;chA	 Tg"Rʠ`Pt ED h*,"..2)+p)c-P{-&3EQn8L)e 123TokR !Hp
@AkP	M3Unique IEdf$ (`eP   *tu`    SӾ MCalibaᆏ
6N stPS DL A.Zb0B[ HyO
ELk MEUk' g'MRqN/G/U[|:P1 : C g . `% i]/Cle2 zc1 d@ik-d3	 ps
H

,
* A 5>hM(o!ylSp   hnology'tFYadapDPXE RPL Ex#Popupz(  0 10  2@ 3 4 5 6@7AF12z5' 15`@ 3 "M.B ouch+pa`P5SNon BIOS DMAr nsfers <F1=Hilfe>4@P^id[in؂\OnzeigİfpeicQv  Kg%u4aobVcwie@z nLvEeinFun	Ɯ-s
kz
.ig%nepd*nt neh7/%Set@%SRheitsfunk ntDoa u
 naDlt-KuO] Gertes8/-$-ID@ @Ot 7	Usttz !ր0pѕz#  beim /st
nBg!@M r5nHsvorrq##7.~.zurck@Az90
B .Xp,!f_g{ms>Ui0'ExGAkkukeK tBs?gewhl@DD-Selbs`sôItivS9#LtIpr 3g 0: tppllTL
PZ`OS
8@ PErw :%SpraQ 1a;n!4:#U"gran Feld=srt-O&O9!86")e SePMbqT}a@0, um p_3fahBj=A, ESC=A#bb!#`WBkze!TJasN0\, Ja	=Meh8`m VeZz
zpMark"`s@{!*!'MenS% dPfeGilt!
^d<Qgabe2RmOq>ko?9 cts.	folj
Bn 
sgr:-> r LeGQ = Nch A\pd<-RBchritt-`VowA(Tabul!fs+ [Holl+gedx F2@
38@= p{gy Esc&hlrL@iPK kan~Ltg we Y!eif@fMgy16P=`?rogetrPn.Dc  01 L@`fit &B kqcQFY+t<W\selomvorB]e	r0ilXWqDeskU-KsBhmu  f 3asbzw.2Mobi`b-gptz%.`Qz  qh4Bi///"2f!
}[KAwlgrѫ ab	chlosF-Mll ProzypJrtt` wCig!60a"ꑆCa`-i-Gre (L1/L2 kkapaozit OMPum"Famik Sp; umm Grafik-Rs@Q Bz]r-Con  "
A  °a?7J	b31O 26O 3O 4dqV si H>(F ` 	o	o
o1
L
2aSekrET*@L$ƍ%'$b-!3Kc(1  Walk~AZero-T<.One EEdqA`PnO`+: bX7 sstqbislrwnKp  ZEucQN-/W0B _leQb s Atei #CP0&ILp`aok A:nfC26
lW$ge`KR/+Pglp%ɏ5 L  	/  M0$wirkQh"vQM?`>3, daᱭ
\l^iewQP ocFL.01 ( anH12 (Umfa*fdIGc$wfhrxdauP(Min.): #30ZБdS`@0% cgt59wuwm HoPuy p%ubr`"w: ؑH	ԑUnbeaaMTHC52'/rvo-L5 .
32@lhafAttr7ibu0FID Ȕ2u"LS.M.A.R.T.˒XXMs eK`kwp eus~1L Dea  JaQ`eD}/t Falgeb e
U	ңBU5xIp dminIoz Dur1@`'@`|=  mg1Ai@eFN1sgd,E.@"< ttifiz eq s{0yr{t.@s Zu1 0D0LzO 9pVenl@~.Ajb s0Q!np'PlsAviceTa s ,ܠF$0@ h`$pg)a|F	 :	 JZgtfa@npWUmɏ Fun)S7,' m3e\ޱWn HP{tectToolsP=c^ty Man#agпUoD-- c}- k QuickLockSubndFr#q\M#`"e$bi sϢnchutz  f_-?1dԨ@imd& "+a A)N+  *W"$B>#, lp$meh1A #I Nk>"o3f`ot]-Parpen}ґ:-1a$P7Wak7e-O0ANS3T:jmCD-֏@&g1M%UT:an 3A;m$"rive4*Fxpla `t=?PcNs E-A\s mY8unbrapnbar.DIpT
f,ҏ'bewBBSHsXDŒ,h  %G&*0	M, 22\v),   L2m@nc8z@ R󡀢Begriff0}dmautomPw S79@>oShl@C i  Qکk`}p#tw`Z*f
 X'U!!¸t!mU"n O P o"a;)lrY@}#OBzw@痡58g<sQ}:Sn iU.) vduQ(qS!,qs qh!Aac%Cw  Prq җ+I sf0  qurࡣn׷hE .7 Escdrv empf/qS	f d?zu! цRO| t. 󍡟@  f.РYҵF&1 2 B 7 b-B`ntra tAdant!W hj`!@Esc-&Ll̠>m kW
'p'p`\ F10`esRh:
x3fg`g sbD} m  p¡@MMuBay&m )bBtghk`-Eb(linkCs)1tUSB-b#-02؆Su`1nZip 1`U234 5`U678 9`QFn/Strg!Ptŷ dEaCГ (USAtpf-ZePcB`iebss"unabhng`  cAr Grafik-Contr־PrimSek% Video- rn~Bidirebal GrPus Lfa`iCb0tzb"d}r WW/AN-Gf0`Blue_tooth9URanbp/a EgpaA'ggr E?'*0(o)u/9E t 1"20397ToqTR C?!"s vxa`13IPQk"o>vH AkkuP  @RtA   x a  Kalibb  MakaO  Niual a   O fm   O D O,tOTrat- ?6. .O .L`b4obisp9cOO5"R 0	Egn@OOf`.[=r 1 :9. % ]abblo(2^Entl h@o3 0P
Bm* 2a
  GS-2'su uĠg`RadapaAeBPmB`z\}ExpA-!-Popup ( .) WedCauQ0dW2 (Z   Ke`~BIOS-DMA-DaƁb@߀EAComp0ropstn <F1=Hjlp> |Dvoplys!VisCnwe Gtil` !konf0[GendзfraMz@PSrU
Jgnorđndr oP(fslur  ub,t gBOtnek@+hed Administowradsko3 K aodA7 for'P·`hEd`dje-i q		+	*
J	Sm -kort	Godкdelsf 7`do`_dbyg1gGOds -&2	 Nu@00fa@ks4l2 Uc 	 Dg
s)9IkA\HF% Ba.AX p b"d`va?lgte b&HDD-selvp^"tPr <Huko QAtrol. iInRrQҽh; OGH omv	IBr/ Avancq Sprog/ Vl1?s mo2nedtPt felO C4+'/#5l5!Tryk pP7 tas<G0=tZOP`=A, ESC=Ann	uaFs!3=JaNej9 "J, AR=MGb Brug ps
NA`RP7xe  releP %meWnup(,1Wt<ENTER> /ec>A)et.tafpr'f!f7: -> e!& MELLEMRUM = NlA<-TILBAGErTAB&2$wKIFT++tF2@	:*@= Acceхh0!xhk> hsfej 8A3ku1i$0gs 2dodQ)!FF1n. Fg011BRnoVD8-p% qpla`9G!krv vek`EnJJ
iC dd!?sP/ flyMs`Èyn#/MEUqoO5 bp* uvetzbrud2JI|,nemfB J@`  PrҰc corO-typ hBigH  ztr`7Crcache (L1/L2@|HVROM-dౠ familie'i;AWdeo#f0pd@s8:@Xr-c^]D-ba s@i 9e2o`%3o&4Zƻapt-ta`oej1("Wat!)	O3OWEw @ex{%IsrP4E$ TyPyC۹%xy lydes!Bmis 0'bvD1I'j`e0jeܶ var0: 1DB! se  alt@P2[holda po Pqt`/Lb Bb-Bdduw5,pr $Pk
kEuGrBA:tTUETfDF%v`Ugyldig/
t-  nGgivuİ2,vi avh٦,? i#քK?@ $1 (Hurr P)% Omf`) sl(`{ (): 3Q0˄2j  `1~x0% frpudZ44b2@DR  	cq: KuB+B"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5pyCD@F8Ny  Be@}fwt nDeae Fra@l  !e@+ń4P@R@{	s0F C		ƈ4D 
&KE  beviвB7 9Ё!Cfdes, f.. <r#amG261 PoR.RVuAj@me+tabWata. Du bu$AM flAX:Ը vicehCa D[G @ߒ[&?Ɠr !,ci HP tectToolo9"jK Quisckpau`'LsQmP? Skrp!0rKvt%#k|qX)/sa1-$$ Hvisat 0`w@x6r,
di ubilK2;+1ol p@frard )x Qlash-@$PR@MIPrn>m#OLAN u7r  Cd-rom-p' YD4B Hop7hF:eIEu 1:w3h0z1,A@  Da$k. l jb TBRUGER-0xOVEDADGANGSKODEN,6UPU alPyg=s ni  wned opMaau,edS "#
{	QD>at l@po PWI_FQqShjlp iutomo0 0j_q@Fbyg[ao9b73pk pegrma anPFTigz!ܑ6n?do` fys dskP:2n@rbAupc(On O"0p	
v  .GhR)Gne ugW"Ņ Pm/, som!Pa Ưck@
Ryt. U pA~ sg/c1  iko qXS`.U  1bef{al kraf   ̓НFx|a 'A @"pl '. \uqÉy@
G񴁴  &cO.q#ar"J"4,Q/d i૤Hu A0.q.foq:@ENstr!5ESCq. t%@n or| 'F':ge@F10FYSMs@f
i/P D+cs	  Dk Osr=@flgm vďRRenHPskm DS-bas  Mult?iBay (K0`/$hjUSB-floppycc{wbsu SbAz;ip2FraVTredjFj e SjSyRV O3 Ni ̃ Ski mQm Fn/Ctrl qEZlPv(aisk)pege Ust!
u1PnP|0#rm-cr PrimSed Vo Out ParQa֎Tj@StrCL>ohukoP B< t6nr compu0P ʀtrm#gt _WWAN-!sioBluethМ/A (trdllo`~net0P2	pQၚUamstyC(Q*8*top+b +E;that 1Ki23KToLR![HL	e+	 	Ent6gt id-nur7@VaP1riqB  S!Ѐ@   Z 9b/| `LKalib)p nd!igO x 0 "ѷ YPO H KO OM\bo   O O#01ionOOOO$Hgs 1 @1O O
1V*i bPGu"[@|!(MEU)J= K=OOGO 1OO OOO[ TPq 1 : Oѿ@ .  %S ].gm5t2 AfFH5L)O3@	Genos	
k

, *  J/X4%G) ' (FA qt @@Ž֡ r "popupsink(sek.Hǀɀ2D5f- bAg0P p BIOS ATA DMA-rq Konfisgumas  <F1=Hjoelp>`ilxsinP0jon )sP s2{CLaӌ$k")Hepfra6#:0@dioA	:Bk1)g avslu!A( B,lBDE;sprograt St passa/@&OpD4FA|U)yrsi!vsOfunkur! tif׃% ୹b-
vn Sm 16 ׀#godkjSq0 neby`5i%itpt5auTilbakeAl#3fabPRg
i
 PE7;aN Urkty Ƽ avaclg AlaQD5h 8>vt Ak & MbT!# `]!@U3EG*
`Hpӑ!4vanpprlg 6  Dem75bM @\dtJIel\3
.5E6o%<}5TorykkC taJ&L&i  a=, ESC=Avbry`acBʯAPpJaCNei rP, T\Rer=M@bb `kYneppilr@Ot<ENTER> hv ddu ve 'Vt. BrukqdPp%l':  -> e$ MELLOMROM = NQ&86 <-TILBAKEwrigʶTAB&"HIFT++TF2@	)P= Go f#l ~WWsfeF`  SPk'0`pZmno&p@5 P M0|m kjresvYe!@0m d,;i pp 9!osbaRafly@sbc^ 0d  wAXa`1A|rvfullأ1z. kode 02Io|"Produ _t Nopablookk-mll {typ h@igv&-ga zv$buffN(L1/L2@Meng`	Q	NenuV@wo-TjrNtroUSW,kobgRiJ,oK1 qNi 23"R40,p( E
1w,9(Q0 
oa
`oA
o,
NEk#Iml`4$Eoc%Hq ok!i*ps(A"Walp9g 0s"-h1jH( Ad`ss e7"~e PnAd 4~: DsA#. z tisdlSCholp`@DTH[aQ "/he-  &d, rnP}u1p3 skl<k`nn@2A:۲O b@Ҽreg1"i%HUgylGdig#DSR`	F
	#NE"h0mtEb`?̀{]F igno\3t_te?-  HN 1 (R nsl؀XbP (): 30A3gg3r 0$s0%[Lv\st!vhF_f!_: Ka"qut``QUÓ5$SQ&eGtt To(Lesb'1Du+q vr{ib: ID301rs<pS.M.A.R.T.-f^C0CC  G#Npu  Bekreoft njAv`l	 eP㰔1qrEّjv}likt aDu!0o@C2Ѽ	aXokag3ogs.ror dmpel&! Tp}?ّ.rPa(A=pph. `bkYu  amK࠯#0vice.0u	la?eD(s aݢI 0"~H i HP ptectTools3curityo Man0`r.'-RN%lq  ēlanppa0usG L@$AOmpEr`i!gi$eu beCska u"-U+/- +ӂWE%q  '. tgl`rh,v@=$ڀPŶ. K$RmEp! rfrard- Parll+vFPhielQr/Pia LAN n0^af`04=  CD-ڡ%vbX45w Ho/:eD@ G}h0valgtP5Arj h($s6 bBRUKERHOVED-8`DK |umu̅! E
 n0_*GQFbeM `P
Pﱡ  y "!мa$ #
T,U]?	$s P8P,pp  4qLL KOM @ autom\pDyLock5eabyggj]dT3Ac   `ma1i[lg_ge. k_[h fysAad$0@ƴpqtW fo `?	exaphn@gE_P3s t`dda gpu»z. UrXrjomd Q 1@0/e XG|pnq
B  uSbVnbefaQwr  G	q.ҀAy A0k1Erғ &2;k_! R!'I7MEPsy-wflAans N@PEv
,2<pESC-|L Ѫb u"'fD'J FC10$Zbe:h& nv$  QNor iFOrse MultiBayG]| "Qdtn(veሳe)0ko.ngsbaphh9yOBUSBeA|w Zikp-U
A A0@AaaˀFn/Ctrle E|AVd(USA)>GekeenAQel!	`rjZtroA2@deoP@⥵pJTisarrPFViA7ti@0Q@mFgradi/trdl@ |t@
WWAN) OOH OHBluetooth j/-eftQ`mbQ AgssstyAg!1%%*2$ (v0&#.b/! 1 Eth;?	.-	3  !R@NT s*ooo/
;ni|A@jtifikRR4C&@B:riJ K0t@   @6ymbo KalibaK B!es- Iȁp<pˀ?Dual ,-N	 O	I	O	O	51 O	O	O	O	8ksp.bO	O	O	`nd 4oO	O	
%O	O	bv mob. a
H.\L. \O	a}o
{{O	B.[ TO: Lar. В% ]afull"C2F~i$3
iBn/Qh* f!y  (o J/DJ/éBiǋpkim sin@ hurtigE _(sekur<ѷF12-`f1.Sepute P@pRBIOS DMA- rᐍConfiguracie la Com adora <F1=Ayuda> rchivo mn%l Sma@`QґPGu isco fOlexicXP޻ Ra (s!valoqpf doba`y Ignambios y@lia AL{  g3 'Ln epidadAse
  ' Axjiciof%posi s_SITc )$ +՚@*VKskSm>Cp SoQ0e*cP#<) Sect}yincor`% E0e"@ 30/c XxP>6fbrI
a`DPVc!3nci])AutomaHerramia`C~H er  8`#P(8` ;prueb_a HDDKc ' >OGVp&Memoria2aD d*mp.al1@0JNKRMu0GbSG#
s
 AvanzX ESvVDD
W? nFampr)co0N gr<1o?)<UOprim'quitec0g2)Pbao=, E_SC=Ca06la==Acep\v=SSNK\1"Y, CoN2	=My p U@{B$dchDha6alv~  alemo apropiu=@[*<I?NTRO> z@ix:N1n.Fs{3pkTYu :Esp~o o -> = PrxcRetroces<-{0`@axTAB S	S'~@Mays+#1C(/F2!-910`rƠ"8b"uErr 0^6F  No@8 AiGSr`jo u@QRA6K. Cdp`01Bha7y n unw>э&qubRnY2"@AC1+>bѪ`r(R[co rUD)JНebook/MEU? IX1QP\ 2O8`0ple0Vxitosa4e Fak T1ytil TiPsOp7,VclGpuWXTamauZ_0h (L1/L2Oc FAAR;OM mil@cNmerD}ribvisUv@ j6r g-l@yo!!
/H#j1l2n3p4 EtiqurAsI2VeFK (ga @Woo.o3o`opoi B	Esn!*J8T 5:Z$  ProbUS%bssfactcXJ$ǔ =gll4Reo 0poX@y1'	lnedi$l@z,
(CE| oD"FF%Ad  :vH uir  eapn. Pre4#/, WcqscpY#auA:'p, Uu c l Qas ' Ӣ,hp9tegAң
S^@vClQI$`\'vaPa)00٠o(a) 8!@%c	Za?`ganޗod iAlO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcuv7tieej 2( s): 300go LB0%&~Db  EaH0 _`ipalGirumq
 : s,pu10  qIQ{`3nh7Servof 44apoya atri=b0: IDp#@exs G
X0YA`seaـKHnuevL@)Df ApagE ndq9S!@gOB".X		:@e voc"	ؐk"alpa 
0 Lstnad ;`fRn"]e#թ9 	A*# \A<Q, (02o,GA`Ơbs (R6% Ey Wci@R|LLBa hrp梅inR3 S$Bf_ olı9al ol`X#A!vu	jvip.AoQ C '{Ùv?%( ֠WapaAuydAn14n HPctTool@O)%!!&  QuickLockSuspen Blo`jԹ\rat S 6""t mej `eO@`?:0d++-y	(BI	( @!)(rALlRt0,"D,P0XৠupizQ,.`xHO;re PunP+roj	o%q>lWS9MLmedufhdem Iqdno Wak>.n LAN@H DtiRePI" AC#D-Q(mEřaPl)[Pm:\v Usio:b	u4@S0S`Rrive+2dL$ t dBUSUARIOM PRINCIPALp1 o o şgwYN7man@Y p 0|. AnТ;7 >y gu`'` lugp.  cjAp~0.1)TM @dk`\)hG 1
f b5@ָ ]@A"T@wmc;N	;I0orD=
`傔> ʧ>1RnRsuCw } , fsm1$!RulrSoc, L"oI /be}"<\su 3Ҁd/asRcuBbVt	"B! ?p~Pda$
kosapg`԰6Se r{oenf 8d@lic1a頴ref!azA. /&?k 0u `#PZ23a4=FinͯK  nTBfix 8Z`
v\i pons2> cY_, pipԐ2 ESC. ΰؑalab:P'Fd'  p,F10:̼ݲwf GAᠿ'a7T/bEspaol O R3tMultiBaNZPa DiPsQi3-p ݐ;]fb0c9o+Ļ(izt(@jech`-5 cBb a1ЇШSuwkrDZipcpmeaeTer Jo C`5t x SpOvNoL`DC>Us Fn/`Ts@ncIngls (EE.UWU.)sPŤ (lPPmpl3So}"le $B
Ғb!Ac@ Gѐeo ModZ"y!  Bidi<c Tam&#!m@Pi#	3sifu0pˊ{ BICA IR01ڀk*WW x{Bluetoot	hA
p}{PyhyoйergsGCpoPos 6B/P:(s+ior)Ethet,; NЗbooUL 1/,2/rL3/Tok0RdOOEGredP23 IpStifd Exclus sAMa`   .a*AC0g_-N0@p[0SՏo`Wr)Xh!,o	o	k	o	h	s0bpkn	o	o	eoko	 o	o	 ao	o	%MEU o	.@o	o	o	o	Ub 2o	o	o	o	rB8[01 :rg". c% ]/ip걟2 @c4-Cle0τ3 	йk",B'* q 9ODJ)o!qoh` ~1bl𑄠@zArran1pBy@gÓXDPХg2ExQ찱`  ŐF12QTPAmb@TouchPaud u1o N uTsсr D DMABIOSaPub  <F1=Ajuda>rP0Infov@͇䰩sobP7o Sf Eเ Ј?4maDӲpR$0
rt7padr0
3t  Ign`0airA	4
sPs'&_1nanL6az؀O DBr%& pς_`#ƕb!X _d#!
*
StUd"]:liz/pO
(Ib 0➀؇/R Q*Ag%ԠsbrB
autQD<n 4dcЮealhfAlo`Oa c(SFeQmas@g1=1i`CP8$!leOpT HDD A1)r  VR#Le Mem@PA<PJ  4tatu UQMu PY`G]⫨' Av8!S%,io Qa`d; 1camppJcinAzP"o?`CA9 Pds`e qnr ycк'tinuar i=' S7C=CelAce imNK!S, Q%ou=Mayimg Uti0:psC	qqp'1da` o i  aprop@y *u@Tv#<ENTER> t5mepRez[@o.Tgut9 ^r ub:  ->
PAO = PrxiK\<-QBACK&CExaQE0\6TABo$~SHIFT+qC%* F2 	*:`=kSC# 9nErr`rOA@Q@na0WoQp܃mRHE. CdigTGo 01  NPhG`,@o0 `qS)  Ss@ viKCA A	bMev
;ÔZWotebook/ C[(RWS mGsTe2_DKKXqmBm? xitonzN  Ti0HP݀3VpcS_࠻\ Tahcache (L1/L2ȦFX a` ROM FamlY  N 3sri
RevisSvde@Π_aJroQLa 
Al!D	Ob a(344`Rtiep	JIOeu6(]) { 7on)oo.Oo$alS~ƕSecunda'$ 1rcCq% vfoi"gv@!mO al  WalkN  0e gy1i	a lien!M!oc0I@Advert: 0[Aqo vae!djWAcqP/u,!i`um  gravv
uu:e)EӎA: n@Adc NS3  >B^hO🽠!QtegiEa	c]
vl0IyI= kT@ctezx0 eja $,C?C iN >?ý1 (Rp b2 (A@ng!qf3 (S.M.A.RG.T.ax`=б_(.): 30<`хѡ00@CT =4Q0%?1$bucedeA,qAhosstDCrom1
: Iss-P$Eg
Ch`Ӂƫ(*{erPmec   `6Q3sM tribߒLD`AМexa@s wQUUig:Tgrg`alTPSLs   qƀL rB+ۤifPArrfDig8cis gҐSAdP)PPЉxacmod!CsާB! fazA@ArEr`a,Πer dfor!m!r3Dn,Pja0.@eHCsHfbrcausadQerF. SZ Q[e a 㷑2k_rvio 	Iy0rqX)QT?%0Р ur@r0k
ad`pis0S,B,QuickLock!Suspenso Blo`qtB #u@aSM%` mabnbP1IY @k,$$al#.2P4sia eiSib0RPuseu sEExigLU`re*PbM0Q+ &perme@$1lp즅+maok6n LAN}eq H!CD-"$gGP$qme:SGusua: VocË@jp4ؐCa0yr2utzroDriSve) t@$UUSURIOEJ@ESTREbISC( ̑:q?Yapaz=@L. AaQ4P@<de-ЧrPisPMEEAp"@. NQv` p^֦*6Ye ,Y`+bN 6 0.bu=*Ƨa
 !Hde`D.Hi``72{s1!Ei崧 O:WAWGs1Y
oc<w<o  supʛHf`oo,ao Df Caaberi
a `xx}AoW :aq(2΂4`  ƀrqur<Ǹ {@FngݲX |af0W | 2|, p܈;) F `3Bor nalp`#a-w
Aa 8΢atEܴsubtuCd C~ ?@ *hR)ssapptA-l VJ/trWL !8Z  Lembre ՝	vqMac`Pasa8
"quAi_sye`R ESC@]Ō9Ƞq3lav'f'rF10. r`r:MrʺTP!Ac]D ugus Op1k: Mult/ibayQYNc`ɍisi reAFpBa baЧcopld(RP ditzBĢ	Rc"zipcPrimeir"rc QtRւO]v@N ؂c@aqAs Fn/CtrlIngls (E.UV`ыx"S[hp1troa؃R؇deAcund a@h`3LPadrBiQTaPhBmemOp"sem fubw>zfec10CA.#%RPa 0RlmWWAN)` oo`o)Bl^oothkAACn(a/ E omCenerga1erec-a!gRF2.11{5be/2o03su0`Ώ3Et&netg	O`p
/*3/CToken RingOOboIdf Sb 6auaqW XS%t`sSsCbGP8dbptgemNQS vlCAw|#[Duplo&	ted/	)	 E/	jONOOO'as7A mO/	kC/	cIAl0 O O/	Ojp~AMEU/	/	-/	G9Dф1	/	/	/	O6[ Etapa 1:^rreg2. 0% ]Oc3lZ 2:AcvN3:M"* 
 o9ayCCm*O"(|sDflex`߂QSc زrydapY!瘀i Popup> Exb@ ~àF12(т? dQZs Vara֧a UN u`T@s`݈s DDM]AFIOS`i qk0@{mtukP  <F1=Ohje>JrjtQt Nytt -vPbtu kP Tallenna levykkee dk@on*@oPu VCtF?Fo02Tej'nsWw Oh  mu0A Plopq6Lr  ttpt7fTpo@uaurlisu0invojan s@saMritoKyEnyk La0tyl	
 P usnume
o$-
t l+ykiu '
,(opnu kiG
/`!(et F0."t13fsB<g5*tehd 6@OG" t!j"$j;A)ma`*in@Ty/kalu`A: o@K < sKi 3vytOA9 @pDMuPQk!  a26npC:m -GDHLisiGeli Q Ik zaec  harll 110=  22gR2#j2H%Jatkainܐjot  nppd_=d, ESC=Per`F =Hyvksy=KyllEi CM, Joku!L=`TY_ fnuoli&
mip^k@a Yh$@
sicsN <ENTER> mB7t
ep+.I@Kfn C/ss seuraavU: ->Xi VLINPPIN =PZs  <-bASKELPALAU
TEdfb1!9ARKA+! hVAIHTO+`', F2@
)_= d@!;0virhvAkkua e =oi>d3a.>: Rudi 01*ka c1s} afpHrt2Pl pU eytke`"6ko>@	sipPQlak!sqкrsRW` kaCt qlaqaP^ TikkI)>skeyty+i Fn
i(pO2nL^oh0ebaGm!|jA|}1?i@d tyypp iInh :fapllaVlisQ (L1/L2ࢅU  ROM-SbmЂkoh	t?uotepe"	sar{W]`si ?stoghjab T;0{	!1:"#I2o L3o`M4mɭJ`Lta1on7(j \oa)



\	\J%:ѶkA'ra- DqACu0$#:D$P 09a%dzNb~ lpi!iEepoi WalkingO 0 -[1?Yloso@Vaihtoqe@ :uvi7 us: Tmӵg atpnhp . Jlt luop2us-  n,Picrjoncx !KA: L" X AYhkuVV3be FAG8p_Cpa@ ᣾
GMHkoa]Wi 0`n? `/#  0?ͨ,i`%(N92R`3.M.A.R.T.@Arp$[n (min): 30-s p2y0%cL dv0 IsYpysi- 4iVgR
p{fb%untqȀ'c{K)jServomoottj
Lu!5ÂvStuQ	k@Fttribti 2@ЗŽy@Sa 6eqKxe nGG9W UuEVahevu  x P>2Ȕ	! PC ޤ}A"+2@"s@a	,-ãPAJa頴n4-ockkpDad`5an 	InDP -e@7p<$Rmysba
`k1h@` Ё	eT@	dE@	ZEY/r i0Xj [!K unQnwby:p\veapahtum"b@^id FLaJ4tii l <HP PrpctTools`cuQ`Pge?r -apuД
.f(-/U i` n Qui?ckLockfa hlu 5qf,V `"@PraZā&-Q,:*seAkm #o$j$it)a{d||}yh' PP` 0#UCǄ.7>uu	SApo}r InfrPnR%È!bkS0m 4em`dHert`hiԐak0ʡV CD- -jl 
"4[w PFSjPZWAiot#@ebn De"#'(stt&)pOlla. p  /@! KYTTJN= PSSANAN,0FCN{.qa!' v`"0*@lyQkurh`V0< rib@j^"#t@br
(V2[-(pY,Qpc``mwLLA4@10^q* OQu `UoЩs@- V suqIzAr?Ii
,#tuBx	8@op R
@J bU 7pbIr
 V|}meG?. Nykyf r`+raq~sQ{6v
t`i @Su. Tqtէ0հ$ £ihQ{eip=0up@MY<eh? IPa* ?-p@F| _Rt0HtaYb=c /Aojaieam qrtat. !WQsm "ftBTV@UG.2 !` ZXu1F_f}0D epq0pǠo#\X2Css,aTESC-npsRV;nQ,અ'e'Ax> F100%Y4aa{ 
:	o .cVQ llqt0{Ƅys ubn MultiBaOpc&JW!lakoPilu (en/$oi) USB@)ZipEn/simm AbKoa elj& }Vi}Ki geit@Kak Y KymAai Fn/Ctrl"mpAȫ+PEng 0(USAUs$PPsa!Q B-Rsq@ ƖInрjBsTCPPs VPo,t\Vakios2sN`#Iguu QHDplQE ko@QW_WAN-roHLOBluWoth @/F!h` sV߀Rs s:lPmӏ,1i 0> y/2,-I, (ylos+OGCO>6EtherHo2E Yoeor3o9TokX$gOoxhA workQ c&GIliv|A AkkuT < TJrPѿإ r0jo@libr ad S\ual`- OO OI OKblb_OO  O O sO$O$`O$ vva_  OB O1` OMaa nusBkPB ODO OOMbOOOO
OI[ e`i:r
йa;da@n . % ] ODP$W2l` urpp&OE -O
3
 GoMOH*  j l 9#`Fނk`qvuɃ!Piǰ@ (se  n A @:@OF12:ڴiP%3tappi>Qkoske@߸ 'mma K  Ei mn BIOS DMA iedo Pot Configurati5ordteur  <F1=A0> Fichier Infor` mA{ff age Sauvegarder sur disq``c Ra ,r P 'une.H_DHe0als~ dfau`Ըow du'Igno%modi Tpqu S%e l'in  % regom	\ Scurit&
e ss`Nd@S"#j@`e sous te PKon.D
 pripqhP %J	a sE@IDy'As
Dr<Lockq
KSmp(C0Cr1P3r3  'he5  1b#a <intgre taR,)ߣ+5p7asm''us3;),;r?frencM =at"#Ou\ !@lonntLbceriZ slecqSn@psQP!s AIATAݒBFoV,mmoiricB DX C0ZZbaFB_V AcpLang4 ChoisPJYl3Ind)!5_mps g! 5ePMd.rpa`k2Z}:z? AppuyDfatouqpo@gepu@lw=Ser, ECHAP=A lHAccep S0/=OuiuN*#Q3V, N'imEpp_e``1D
=8aw  UpЈzi3
s f'h	eM
mo!04ecle hmenuucer@rwbri 2qhz!y <ENTREE>2nj+pW	ss	sui/fa  !/ :!-> ou BARRE ESPACE = P"Be`-$IEpreced@S<TAB`CA*'zMAcJ+ix F2 =1"w-$0!S(rr`@<P<TJ Il FA%ssibPcQ7L U cs'Jprod{endp#B$P. Coa<'401!c5Cntв@-1 emplace( L' D SaQreC' y
GJ 
s}^ccueil dP "4@\ itaxsmobia@``
W 
u` B!OOOF2BfCX+)a ru Fa0;cq0M\ Typ(0osBVwDb KTa@rcaa(L1/L2) Volu`e!gD  7ROMOamR ?Numro#p	Rev`crdoerS2ItryQclavpoLA}ud ;n+/Zp/zr3/t4n"3inv!/Qzi&5 #pGriF!L( Ute)OOoO@OOBV'edA Efo MT֍ :$/.   %Er4 !(SUPc;Walking 0ᥒ81lig'ad`auZC	od  al0ifAFtip1SC[a=e@ptr1uA ieBЪvPR`! /瘰r,  z6{ nro°c	cY0])A}jDL_tv
 tro Pa
s
TX	  _["Rvja"D`dH.On m
:YfPS 0"Ӏf   +-vaPC lp  ߚV ? Igno7ꉈ+| z EnGregeo#=1 (rap`)#>2 w(coet)u`|pimjA(z) B30堿s pAU0% nv$D9ʈ<l'hA+bF@` `:˗	AsGimnpnud'+,`v`t
$.L"u( pG3p 5A`ib!O: ID =0ࠒ0@"s S.M.A.R.TAbanG2WpW AIBY`se N!=apYeAø?/@;sa#A Mar, uinKS ;A, e,ecoac	;mme, vK*ad11POobPbatCs	eSdp4D	 pe>a1a`(`ifh s4[,P@s蒵 `Ug"  for	mQg-hq#xRѼsJ.)rmQފb	hJU@0`
1AJ.6zT"`QDP~aR avoupR!Afr Cww7A^	 	zY R`(p"}ff1Qd  k;#l2TcgN<q`rHP P`o կTool:eRyW Mar O4K8CF!/  QuickLo;ckUsusA |$cp!#ri 9 س<S&ocl'S+C)re!cB!
`Kp)!nk:,   v qi4//  / L'(a'a
S$ud!v
 KP
dra+D hn 4`ExiAudP `  4raQ8llƙۗ&flashѫbWake On LAN\ CD-'EZpalj\:A99s!Ɇj$e Drwivea-. SsD#DDEdez "deux,&(UTILISATEURPRINCIPAL)`%H	Balor@V N>z _MA`I!!&q%lsr `/qfe4Bcelu2*QDordibf4. A  pTV	~(`sdRZ-Ho `r uDfetCu |MKQ"t"	~"a"[""qoip> >""%x 0ՑH)@zANaniq4"05#'o牌#!2/r,Bcгǻ!o!  3pi\H!! !! {e@^qQW֊a"%uelR1dX :HLk" ""opa8pE* O' jW'Acbw# ,d'orig[inIlRv`OHB2C{a B	u
vqS"فapAQy9Ipt0M倮
5dSjavsH0P~7e* ߹-$Wq=aPprsP"t Ձon: to@Tp Ra1S44PpabP}t3ۥk'
Qyj, appuy
0`  ECHAP.@@@@ OTzR'o', puiCrDF;10@TapX 2 1xCxY^u}	UZ/qFr/ana
OgҝACJiMultiBay0ulƍAph0A Q!3D,xsocv'a%(ga)OOFRz) U[8֘ USBqr
jZiprP:0 Dhi @s QuatrRCin`NSixi` sSe  Hud^ NeuvCD`^Perm/r(s Fn/CtrlƓ AnglpSA) P$oॱm1`s A`stanlphnROd'fad`n elAͯtrlS' Ui#chQ&m`
Ұ*d :i@7idÂoA񯁿Bidآ 0 mSmVlb@jEK!al ,$ R o!=ril WWAN (rse0il)1grAPBlooth7sr0/?1   >)o`$0@g`Q@loc <G `cP!ZqX0b91bP-n oR;2ooypu<	6ccumodhogB Ebt# 1a%23T{okRingo oU/,IduT9-ar a[  
2     Ph% ll`4 n!Kre0/ x Ab!AF.!f*Dupk */)///wb// ///**- ///Jqgn$, `/,/ /e ls` Btexв
sqbmoP/ /7/// ,///7[qRpe 1 : Char9. % ]A.`I 2D ` GicM*n3@	Rkio.b
* T   @@/M.$oOA$Ʊ4Amor1cFe"5 RetardBTexp `) Dtжa  F12tposf[iP+Aux  PatqbAKw ucunİferts BIOSmDMA IIP zpOlr <F1=Ai:> nfog.Qema
l0|'Salva`l floppy%@At{toRiprina dnThПi@fa 0``ip">Ignor`d!ed esci EP a
l'	iI@Az eiBtupiczza sswo&e amDratogcc3R
q7ZX,vos7v@% IDs
@פ&gDri?veLock	Pr ɣ+St{ CP9 SupA=(c30 g Hg/o+:,i fabbr
4=i	/.nzi`[Qco
rui C`b5<bae9E lrOpa t2;o rigidAt"paA'VP!,a me0V W`<HKhM%iM;A>or !Ava=t ,Lu!O l$Dim"& q6sca X ssopd eviQ g1	vv!'#o*62wH8Premi qpsiasiesXpeirQVu L   k=f, ESC=Annu`,TaA Et0qeo=SiSN@1T},altro#	=A bj U}s"SchiavI? frecc'!ri1 vocpu ap70e"_`<INVIO>  \k\'e.ipYgui  un%:@ -> o SPAZIoO = xsuW{ss`0  <-poBACKCE c<TAB@C%o"MAIUSC+)XF2	>-Ћ= m "AC"IErriS0D  Qu A87nppupvse@t"Vi ' v@u4Tp|pXJ. C{z'01 N0u0F>QQ9a0}oggiao Lk`IP'0 Q>re0
4E=s"@agga%Fv0S!t`ғ  =npabook":Qzespқ :\ ZҪf.atp_
2o{briuPrf uduAA ND  Ti"+0<PSpVeloIStepp@YMis1ca(L1/L2d&dDbROMIamiglk N@o0H`("	RP[3[oi#qSroll TsjrAer ~i1OFk2m3n4ࡐ7w  PVSTe)DE(d)8
$	2
3
4D葭Fonda
t ,o:EV$ T$r%O	upyP!gTŒ\@lliASpr:bit 0t 1~Rindirip	i] @`| 'FAЎso:5X%?~ gger  `|vpAhAcre!0M/rѧ, O`1favi P}PiVYXA:'mU[A:"ma.conouAhX(_ IISɸQrita] Nsv@dpRlIQOy0ളSe3 `voPga ?AFbb iQfre?@?: Aɐ51 (Rap)62 (Complet"v2tio (): 30>0%Q5"r6a1r0䠈'hD5(|:s* Щ-@
˱ (aD୆%aerv|")LċAPLA'	߷rib i0g{ol: ID$Ban`de@z قi S.M.A.R.T	.!ޱuT0U^ _wordc(nuo!i2 	pDsc(Ui%L?bq+d`! {â"Znd?՛O.A7Tcq^B&
Am AVf! B;YpCr	t>J2fum y3CeHPe<B #u _t`!1a哰. Q]ՒbdFqo!erdPКatiwEfif+Jizso@?in  ca2ivEvPgaζOdesХP@Jm 9Yy HP tectTools O d. ZRV2+ ickLockspen`3B05EY mou`s8 M@M d?#<#,p  gra`@p'!oe - !e$C-))v!pKsm@]0x!! b	,'URar i lі@NR(@|ГV|a infraQ)p y%La_hflashBmnQsVLANp Off#o CD-" Se(P$FZPp:[ @!SRQ#3ĝ{usanD: e1*. D:AJ$@T @@bҁ['UTENTEPRINCIP?ALE  r@.ਰa m3an8fu`o. AnPV>FgP0v  a%eQF@p0f>0.l@h0AAuYPTk^s,bh	Q_q2L sabR? 7reDZ\f.APR A Qco0%9 8 P+ AB.`D
 Brea,@q  d (`<t vOH r luogo DJ T!B'     #l$ j@IV#:,!vI</ sI"I@5-"÷[tClz s"o mP0!R/DeB  /$BH @æUEa(  ݰaDA'Pa gQ#QAi  	Potat{fa+ ueY/ cdO::l}&.2rPCqu_{9㔓!. Y)uA`YE	snOP䲅@K1'56h,mP킊ёo ESCƞM9'v)dovQr 'n'pom!nF10. !n!k KWyȴ_6\%זPt qIP(i 3G  OA:D0@ $dM MiBay ba1.ggas$Z) ogC}hi USBޘ]$Su}k\bC
ZipBP6o ;Terz `OЁvN% ec AС" Fn/?Ctrl TIngl  (OUSA) Yi u`2O mpl 01asciЃR7pl Ua  0а࠰Pפ Bid0HCapa memqX5eImbs"F!/l@DQ2'c/wNPs (WWAN){oBluetoot}hCommu	ZЮ/ (J)Csm energ]hW'Ng)1 N,*2HIB-Fa-(F o)ol/spo Eth`etWJ V123e Token Ring p!OE3 IAkB|# "Cta L   Ao(  C02b// WD|Saoo [Kvi0Du0V /  o 6  / o ,o// ooda C  /  o pUY\mo93/ /-ooo oȓ///poo[ PAs 1 : 
ros .  % ]<ocompp®
#2S' 4,n6E3 @̀
ij* 
 /JqoXaX/3i'o
  FlOoppybUAI!dC@ p(sec.)# vel0F12 b 2zw@pambp@NzupTras   DMA BIOSup <F1=Hjlp>rkiv {Sy!~infotpзs~ S. pk%kPiguQ 3(stll_ frnl@Ppn ard Annua nd`` ochsQl``   np͑ SkerdPtrsl0F  K!aOB rt-OaEnss	(b -ID 
S ao
 m`
Rd-St?d frutsav 7K
 byggd 
usBi=*abrik`m+ .J
sbehrig#Gskts@rktyg 9Ko +r vP6 S`;vtiGHDD Ak_V Minnes:" @01q5Q ?@An@#B
S oVlj4rD ;cBnedtolD!v(C-j+eTry@SI fri Dg s nr? du viJPstyY=, ESC=AvbryNaFDA/ccepaF, V=Mer X JvI pil	e	/pCa PyEt
<RETUR> oqm6
YRtt .ke,lj`SeferI  : -> кMELLANSLAGSTANGENTEN = NXS G<-BACKSTEG FregeyK TABf#O`KIFT+H& F2``+?|=  'fO @%Aoi?Cfel 3t gqL @ kA t h+AO` ~Dstod uGen. Felk0197 AsЌgF{P|plat  NtPhm krv3? `pbyPgm0 fly5s t6 U-Por/2 ex䚣(|0Ytidigooi2-@kl`TA UkN,q  Prr, typ
hast^hg0Cap-	rlek (L1/L2)Yd ROM,um  familjrenummn0Ddeo, rY dttNb ~pqyrQ!]H 1.$z2#3$4rbinav0̦3 (bZ)g	1[

\
Sek# xIrq.4$$@gaxr%Ex!z=ok!pvidClmissl l.s Wal}k0s - ~P f1jH Adds li7AeޡnVar! D`@/ѹ  7<neh gx"Ccuskapay /G-tRxiƱ=k b!h$2AA:1R3 K>#Rhi{wIBB?sk_yddadag

 ! Eˎ҇8A!^Ԉ  2|? ig?D܇jG즦a- 1nabb8pf@րn`X9UWk ad k$pQd (>0): 30@ncpan 2?0%bX A4Pp/]pp01vr ka&tPo:,tq	!قOk%S(x er7vo-LzBր!i @(f%ttribut: cIDpx?grobsr.M.A.R.T.-5 GammN u7 ifin@ D> LܰQ  R4bd% pm}vlika mǄ  'InE?kan orsa@3iЈP9aHSsNyp0PO@Om=<s1A1lo. 'Na om hglmabtj@Deh ;else- @^uQuayVqΦ >fun 0`perl^7!i HP tectTools%٩R->6-Quicka"q`telge #Lp׌mPs Hgk
	gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!aot.c Kж7AompHi p@1f   Pk`anFlash-@: s!Wake On  fr\CD-0Xw QPR%qSt HuvuduJ { fK: D . Gowhsrdvd D 
e . A1 a@`r ANV>HUVUD$} ɀmaV@tt .^ P 1A "RN`ҁ< ild ̈+A
 JёRh vpyL l "C*lqJVDQ.Z +oI XqeDGga2{b2bygg7ZSY3 g 5///1dA\J8- F"Z0a`=om s-KeB
C:d@=  At;as BG@fj'F\B] ktuai`qafaanasks .dIutN^tg Ps0`AYq,vїur?sprungQb#@&MM. Vi  reko a4F	c	YrA`+,0s@t b`b . A `Kad΄37 _j &g`!b(gA|O-befosesm ih`pґVfljgns. Tr0  >ESC-rQBS֠V ƁSw㞑`u'Z'R-sedMutaGF10` cVi3a:+dshc{ nSvea ҅ܠ: N?, MiBayCr3ut opBP5vi BaG (`r` g(h!SBV G Zip-`=PW AsFjQa uttoґ NpT VxFn-/Ctrle Ǔ E lsp(USA0@bmYkd! b`n`r;msPtrorx,& hbbelorleklheo2nek0!L!BIfs@i]otrqtK (WWAN)0Bluetooth /() -v@ĔmbyeQ Aggs`haE(M-21,2Svз[,p`8'aNed Eth,& 0	3^n To!R@PN"!Unik *@?iG K  tus      Sbo Kalib@o  dp~-  eF=s alQ. O
o 

  
9
Fo  
E 
D0!m1s
Aoo
E
Hptag *o 
*( 
VC| emoo]A*5ooe 
DIOO Kood
D?[Ne _ : ;Lapr . 0% ]
kl+ar2u@j253omFjOF*  &V@1 > I*O!DgOЀU®br @4sadapП$lg rdrjQpsnabb|0 (sek. F1 ܁Bd StyrPguIOS DMAaa˰"B%en iee/  Op Teslaan Configupo`anafPvtndaardP"/  scy	Wijzig&ne Pprogramma @РSetup  z1r w܃ȂsveiBeheerswachtwooޅ
 p%X. ApOaatbOgl>$$ ID's 	gaSmbA6CP  OaB u"5P$cR%m@j+%O
GeX@gӨ gssvzie܏"Fabriek9s.ugz7@/);Vref|.s:nieuwأ8OOc  E{xt`AccuxB 4\e0P geselec Ea p`Es  zelftGa [-schijfuei Act P6vG0u` ?`I R!a/H4UBgDAcg@7n ,DP=%_
 w 9aKc!: Taala b  =r/emP 	rijsgemaak e	l=;o" /;9
8ukAZ ] {NMLg]g=S, ESC?=Annul"EDG0=!e!oJacNee fslui@Q, AQ-f =MN Hulp~pijltjkp`gebruit1Ѕd )jui`~xnukeuzk@ark^<ENTER> ind` 
cr]beZo !vol%@@`1  0aiX:  -> of SPATIEBALK =>`<-BACKC}EVoriglɸTABb	#HIFT+%%|2+K=  ykp=t#B~fouta64k p It w_ge15 F0MЌreqatijasen. AcoFZ01b a0.i1ZCu  we   Netvoe are0#FMPN diVbas`e3
 t n0 notebook-pc/AP @.PistNOQbep*igdooh2L	MЛaf.t NmpALyp6rocessBnel3Qpp OmPЂP}e (L1/L2 Zapac?i VH߯ROM @ -s2!fSP<mm E  Hebvrgav_0ideoAkp&p;b  bpM	m	raI1b2rd3be4hisgI t}.jne C(B(XЉwM@dzQ%) 
 `D#Secuib@E.aw~~@$"Ftbd%)҆2!dHU2Lp53Hac-0-*j1Tho_adresrlafwisnd pao􁎤=LTop: zPt<ts e'ge t PSBbeЉf s d1 A:og-  /ޖ"x0zbLӄe6`NoffaG1Y\f_dقڑD `ѱ

boචgAt
wO,C'We nu  Њ"
wil?oݩ(""a?Ox
Zl"+1 (b),2 (U0Y ) Аpqwrpn (min.): 30 aee&p:L;0%Qtoo `4;q{ho:5broA):]eeqx/nb!$32#kvo-IPs EI"
2`"qk:J S.M.A.R.T.-af@APP@udh "/tBlo0!  A  I-7B4kXqcr lpSX8
 Vr!a1& is bBs AYoCf#Z/k, Tm]lijk0UKQߛ zoik` dvors:ka?0QH fQeksKPugzet,r lorZ@¶ZOb$% uswb sqwYfur9hou
d'Hi`!  AQ`R`T`R&BеѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k  p?gsppL`b TWm E #M"g$rgΠ9bl   ~erX#W>,.o(h( o( S("7p'EAJb"f k otraakP)5w# sXbtK;?ݳ ]Qŉr p1׀frap=d  Parˊ Flash-malIr=demia LAN a	a7hӁ@r}- Cd-r gHNѽfH/oofdZGw *I  U15|de(FB`DL`#:@izow.HOOFD-WGEBRUIKERSbPՙn  p'anA S3C  Hgw!#N$]  fykkvcomp3)AosQ1|_0)t D "g+ЯqA.  ]0qp1bAutomPOc8>}X @r?:h^AA_<T< O!V)?!=NPSS!= !. Mo[i@aQnoS4H,P   n2S8`PȒ`VU nt@ TAe.b/ |@hui`,̺dЍ wwas top/!k wgeab.JԻ7[!nvloeC]kPm\Wsn 0Z^U4r`ra=8	WptorH/) "gect.  o
 s  v"N. Omun@
1]A&`3fe*p&agol8q. Au_ر_,ܥCDyAbhl  $cpӲep3ruk3<pESC- (A9 ±Di 2B'k'tyUbkn F10 @T*ZĒlu0S4d ry`V4  NePl G g MultiBayBjVzakd@\~base (иgks)re> USB-Մ cb+z`p-f E2 we$qVV@{aZes >ZÀ>Aa8NFn/Ctrl `Owiss/j @м.SStaµMcW3M?ijsappq1Ov5e 0qՓlBij V o- qPF`A/Aˡ0d`dition  G@vgp<uqVPilat`E?"V/p neVd$`> Radioj WWAN-aofoBluKet@h`/o$JrgieĠQ[Kq^.(	ba)fcEt̐ 1
2
3iTo}R/-OMobo!023 UPXuAatcuI<< q6us     S#aGekali@!1OAK"2
NeEualR\J OOCOGEZ OOO 4^B1^'OO&O H0~paA 
O$O"Lker-MUE-$J$OC$ P1q+OO+O  [alp 1O : Bo@r1. % ]@/& p[0d2knte~l/{	3	˄
fo@hl/)* Jt  ;>.C,$"q $#aXadap PҢ(sec.)pop-up bij snroC <aF12 )Kbb cuorsorytuyEasyPo-muisG1 DMA-}drq BIOS  Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋa\܂]tsfBNɕۑ  ݒOCOF畜ďg&f 
H
gɁ  Ho'׎ 
ςɖE	ύXɏI  `AȌԂ̮܃@ea L({epA`LCǗ҃p h/do'o "X yf@\̗L/E%ID&ID: h (uN XBSA$͍eX} 0g J 23T|OH', v".eI*"%ɀ;FX
 ؖ>If
cA>oAe̒  I(f:nA%e> pCeBIvC"F@ `F  H  D%Jc9~J; ڍc R5BM NnP$߂A2%E@U`UO tB!#^sNu% .37($b74L[BR_ h=!AEsc=C8@bsAS60=͂|
  aRAg)gjq5\= 3gp] jkڂ %iA@gp>[Ez]  e >ȉ#wA̀r_->Epy`tOo[ = ET  <-SG[Back?Space] a<%[Tab!AG#[Shift]+eF2`!,,,10^nmF/[~%  !CG[  ӂ@DBCłͫ}@BDrp o 01 yNF`+@~3a
ɂACOk ~ڑKWv@&eb r?O x1X
Mp!mQ^0fGdMEU		Ȃ2^e`	］уɰޯ   ۾  xïݸ  ށiL1w/L2"OM OM̧Fٔԍ  ޵ ޼ޮ ް ۰ׂ޽ޯ ްir ޯ#2.3N4h	 pŰch3(Â)FE-3N4@(JkvJ _!nFw XcopF?$qv sPxП6!;LsV+Walk0s?A-1B/Z hɌѢʎp^`OD4x:2B>tƁAC %C颴 ׂĎhDa/ŗp쐬AFA:݉ b#}v!h F FSPl	NXWM֎~@YqZos /9@y(c  ցB	H #ċ g Oog'`,گЯ1iNp`2i׮S3p.M.A.R.T \zsԁi?j: 30Bײ8>v0% bj~!c OK z3 eB~ f{:@	{em`cQ1kT ={ǂݨUעfIFIDP|.B a"R`R AFfV!'/i `¢k@Ρ dAJg(B(a| ͤDAJhvٓB"Ǽ /  Ǘ@{R@rRVdNJǂ̂C*p4qu`@nȂaU C	 !]ţࣂ"^
YOꍇcxei!ݡ£	龂 ÉƂ `Ƣa7df!tf
`?"dHP ProtectTooslsh}lWŒǉTBq#j,.qB4УMmN*u<"T h8' k{-E`O'O H&J8-.))Tی삟D<<D%蕴` g@4`dt!~(!ċNb8v"Q ԊO GPuA0V @QlA [_ށۓfрC!N7Wake on LANh CD-Pu3(aր $} ^ V:`%A}UK (iHb'C3ye@~( |`<ݭ'	8 >B`/ZAT?iR1"i	3	'iEl K	͎W vpR@sAMS#ˊtK@@P!K/,Ɛ!eF|e\Ӆ JqA 9ߐ  <\0ۏ؊ԓ "łbͯL |nł`k)/)%)Dp˦ Z7]t.z"*FG`nGKa(o(iLn$'m@_@] ( IO) F)u
ϊ((?(9(ágDx${:#<43ɑ`ƈM3 f=ɉe^@&A)F1j 8cB  B獑BAȑO"Ocĭ(2ef̯旌8dql@ӔC౨aU"1/g'|EE[Esc] 񉟂@~elAثm T.?DriveLock t[F10 MS  y_Ԡ7>`E:	 ESxtkGb@ȓO xXioiEcUCSB ӅAXPXp H Zip1Ԗګ 2b 3 4"567B8910r Fn/Ctrl%̐ ǲ@{`\p (USA) `Ӄ|B#foX
KAV&ds
v C\gŉ  }ZJ _ rIso@嬧 cWos%AwCY OڑͿ̧pYblNi!WAN{j%M`Bluetootg /#jְߓd `qIntel  Executi@Disable`0ԯ..1,2O,.̯.odhEthernetX& 123 gPq
AOKO3 O@$OFj) ID P7bfN P     ' ppfbpU?k ej] o \(@%*nP/h/!!!MEUv $)o |!% OOv5bv1 : [ds . P% ]ᐼO<2 !gOnv3		@)J*   5$/?s'O mjvSpeedStep technologyugh 	_PЯް Ӱ c`px(b) sF12QԁibyHߚҚ @^`E``b1[Bq @dBIOS ATA DMA].                                                                                                                                                                                                                                                           ` a b c d e f gt" .M         @  	 
      
  4       |    n    J          Ԥ       ^  / 0 @  3 4 ~ 5 6   ( )   , - ~  * + ~  Nnp
 N % @.   8NnNnXNn$Nnx+2Nn8Nn(?NnENnHLNnRNnhYNnU `@E<BoB<U> FبE0`8l v x|v||p0p7c g  c 0A   = ~ 
=$$$<   DD_D    O aƄe  i  o䔕 u  yK $n  %Ap﵏ E%  IC&O &U n   Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'@ (#j|od^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ?] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'(

C$: |  s+'()+'*&`83&ď

OO
\()| O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      g|NnA  Nne^@  .@  bNnQ@ ED @n.WNnL@@ I mp  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
Nnw9 Re idNn2bNn fNnhNn@a@P  gNn@W{Xt|dU Zt}[\}#L  ]~&  W_t`$ijtVa!
	$
U\ 	~ 
`	
U| `
`
Fa
bcDdeDfPh(>{&.`Nn@@ j   @
 j( 
( 
r Wl0 m | o : *R  	Nnb $/ 9 
 VF10 Setup Image_SETUP  P0Sq O ; 	d *vT@JäI"IP Ra|` 
6
&$U`ԩC ؄ TԫTԠ**<gU!"$Dcz: '᪴4㴴4媴4紶d骴4D9b` ޠ: (7  U)$**$+U+$,,$--$.C.9 .hໄ U0	`9 HE$Hg4jHe@ #"" $;" $" 
_8 b@JNu@OP>P 8 ;	 
      /	
Nn&Xc  b"  N  % ]   Q' 'U#(!(")R)US*T*U+V+UW,X,Y-Z-U[.3W
eU/di0i3djjU4dk5k8dl=lUdmLm\dnBnUdoEoFdpMpUG$HqIdrJrK czNnfqq$JrJs %4}]cNn@ U}`}~`~U~`~ @U},`"U 8`tu wx~zt{  U}t m 
i55(4()_TBz`qR愕T$^` 䉧0lT'^t <UUȀ
旇fH3`|GzTa.MR@ \ b v @ܾ .M@ @ X z @ @.M@ . H T j@~ ( ̀ .M @ < V v @ @.M"@ 0 P d @ @܀.M@ , F ^ x@ @.M>@ b n  @Ѐ.M6@ X j j @@ Z ~  @ 
	T @ * > R U^@ht U@ M@
@ F UZ r @U @S
@ $ D Ud @M  @ D Ud  @ĀM
C$ U2 N@fzU @} .M@ U@ b  @պ @!@ L ` ~@ ښ@'@ ( 8 P d@ @@ B X l @Ъ @,@ " & * .@2:T l@ʚ @(/@ h   @.M4@ ^   @̀j @ ,@ ^   ަ@*@ 8 F T b@v @ª @3@ d   @ &@ T z  @F9@ x 5@Ԁ0@ UD n  @M"7@ b Ր  @T @ b   5@@$@ U> H T f@U| @؀  W.M@   U" *@06U> F@LRUd n@v|U @ƀU @ A+@ & * . @@FRLJl@U @S  I@ 6 J Uf @ @!T Q@ F ^ v ՚@"T+@ j   M@#@I@ f Վ  @$T*@ b   M@%@J@ ^ U  @րM
& Q@ L Cl ~@J @25 @'2@ U* . N P@UTX\ `@UdhlDU @U @Q΀ai@M(S@ B Uh  @ڀS)@U@ T v U @ʀS* Q@ 6 V Ub |@5 @
+@k@ UF v  @M*,l@ \ Un  @΀M- P@ D UP X j@rU @Ȁ.d@ P p  @ 4/@k@ |j   
0 J*@ p   A	S1 t@ |  M *2l@  e  
3@e@ & 4 L `@~ @Ā  4U@ V j ~ @ޚ @
5|@ 6* ` l |@i@iiiA@U @S6~@ J j "@7@@ R b J @% S8c@ X | U @  S9@ T f iz@ : @ X t  @;@ H X h @ @ @$<@ j  Κ @$=@ j   >@*@ p   i5 ?@ UR   @S,@@@ h  U @ƀM A@ 4 UB T f@մ @ BT R@ t   M@C @  5  $D@@ Ռ   .ET@    S$F@   M *G@  5  $H@@ U   @Ii . @ T@hĪ @J@@ " & * .@26: >@BF` j@r @, 
i Ki  i@iH h @ހ	iL@ il  @M@ b   @N @   O@;@ |j   4P@j@   0Qj@   $R@j@   Sª@    @&T@ j R  C
U@ F i2Ur@~ "iiiDiFiV@ i& .@HZ f@l~ j@΀
W@Ī@ D `  @΀ X @ V f  @V  Y& F UZ @M Z @ D UX v @5 [@ < B P@l @ঀ\@ 4 N ^ z@j @] ժ@ < d  j@Ѐ^ @ T r  Ԛ@&_@ rJ    ` @ & B Z d@p @j a f@ : N ` r@ *@܀iiiA
bT@@ F ` t @"5ڀ c@ Uj   @eހ%dת@ F V r  ȄրFe @ ( UD l@xU @f 2 r @* @Ԁi@gT@ `   5@(h@@ ~   i @ 8 d @Һ @*j @    k@ U , >@LUt @U @S$l@ h  լ @mT@@ R   M@n@ Z Ռ  @"oT 0@ d   M@ p (@ z 5  q @ U\   @Sr@@ D d I ҐҤ պ@̀sT@ 6 D R U^@flt U|@ @iȪ@΀ )t N@ 6 @ 
IJ `h҆ @ܚ u@ \ 	rҪ@ v@@ @ V l @"w@e@    x;@   (y@   2z/@   0{@9@   8|@@   Қ @} @ JR l C@  @2S~*@ L l "~iҢDiJ @e @A @ * . @ \@n @؀ O@ P l  @j 
@@ H ^  @Ā  @ > d  @΀Ui < ^ U@ @T@(@ 6 L n U@ M@@ < UH N p@ը @T,@ V x  @i @ p  ږ i* J T@ftJ @i@5܀@ U8 P h @U @Mg@ : 
iV dAiiiPiAl@U @Ԁ @_@ "8 Z z@j @i: %V p@ @F@  > \ n@i| @ @^@ < L \ z@* @i#@`@  iU@2Fv ՘@T1@ b   M@@@ P Un  @΀5 h@ U< d  @M@ 8 F T f@iv* @i @T @ d   M@@ b U  @S/@ l  5 @@@ U`   @S
N@ f  5 @2@&@ Ux   @S`@ X t U @5 @@ UP d p  k	~i iRi@Ҷ @܀i%i@i(iI0J@rզ @ @ B ` ~@ @@@ Z z@    @ \   @(@ j   @ |   @Z@ x  Ԧ h@ h   @"@]@ \  T 	i @&	i@ ` n@iҘDi)i@Ԁii AL@ , D d ~@  @ d   @܀" z@ X r  @ڀQ @ Z z Ր@
T@ X x  ՠ@ T@@ P j  U@ M@@@ @ Uh  @Ȁ5 [@ U* X  @5؀@ UX x  @5 @ Մ   
@@ t  @ @ @ V d t@ʚ @@ X x  @@ @ T z  @ iiiAS @ F f U @S @ J r U @ҀM ,@  զ  @ T@@ F h x U@  @M @@ * UX  @ @ H Z v@j @*@ * 2 @@U@Ld @5 @@ U^   @S* @   i 
U> V z@5 "@ U   @5ր
 @ U8 J d @U @S @ |  M 
@@ l ՞  @T@ ^   M@@@ r զ  @ T@ j   M@$@@  զ  @T@ `   i@ @ 8 \  j@؀ Ȁ˪@  & . 6@>FL T@\dl @ ʚ@ @ T 
&< F@RT p @@ ZR v 	Қ M@ 8@ F Uh  @ԀM P@ Z i @@ ~  ܦ  @ r   @@ rj   G@ l   ޚ@@$@ NJ p  C @T2 " <@	bv@iDTiҾ @ a+@ F N j @ @@ J d  @Ԁޚ G@ F `  @j iU4 X j @5׀>@ UT ` v @ն  ؤD@ ` ij |@ @ ـ@ if  @ij @ <@ Z p  @@@ L r  @ؚ"@ *   @i
@@ 2 L b |@ @ڀ$@@ ^ |  @܀  g@ J p * @iiii@A@ H j  @ @g@ R r  @Ԛ ( @ vJ   A%ȀMW@ 2 UN `@zU @ЀS, @ b  U @S@ \  U @U @5 @ 1@ U> t  @Mހ@@ f ՚  @ 褀m@ N j zT@i @M f@  հ  @
48@ . b@ UR@t U@ʀ S T@ t  M \@ ^ Ռ  @Tm@ ~   S @@ J t ՞ @Tp@ f   M@@@  5  \@ Up   @ u@ iF ^ t@֖  i i R 4@i>H iPX `@fRni@U @
i@2:iHid@ )@ v  ն@̀T @ P r  ն@ڀ"Tn@ ^ |  jЀ4@  @   @    ;@ |   c@ h   @@ P r J @ЀC Su@ 2 J 2ib| D@i iDiiii(J : B@dUz @ռ @T@@ 8 ^ x }@  *]6@ UD b  @ո W*](@ < X j ҐȚ @@ D r  @ *]@ @ X d r@x @Ā *]*@ D \ v @ @@ 6 L t @ƀ@ j |  @Ҁ*]F@ |  R @ _*] @ 4 UJ ^ l@U @S	@@ > T Uj @5 @ 
 @ U0 P b l@iiiAv@ J@ 
@ > "d @ @*+]"@ F b %@ j@܀
 T@  6 N ^@Un~ @*]U,@ N f | U@ S@(@ 8 F U^ n@|U @ @*]U:@ X   }@*]2@ Ud   @}*].@ B h@j @ @ |   @*]@ ( : Z v@ j@΀"@ h   @ '@ X n  @@
@ l   @:@ p   @((@    :7@  Ț  26@ l*   @M
0@ . UF h @MI@ƀU @ *]U@  " < UH@N^v U@ *
@YJB UV j @@" @@ j   @  @ V ~  @!@@ HN@  @"@R@   #@K@    $@O@   (%@@   ,&@E@   '*@ f   @(8
~ ѐ@ѠѲ2:*@Hh iiDi}@)*]@ . > H `z @j * ?@ `   ڦ@+a@ x   @, ;@ \ j  @ƀ-@j@ V h j @Ԁ.X@ d l  j@ƀ/ H@ B n v ~@  Ě@0h@ P p  @j  1@b@ d   ֦@ 2N@ R zj  @3@;@ J   @.4 r@    5T@C@ . D X Up@ մ@Ā
6T@e@ F h  լ@ʀ7T@v@ N r  @΀iiiiA8@o@ F Z n* @"M@9 @ p U  @S:]@ p  պ @;@@  ^   @P< _@ V b z @ښ 
=@@ J f  @ @ >@@    $@Hfj @? @    .@@p@   & A@l@ P U@ S.B v@   SC@ B R Ub x@U @M Do@ R Ր  @"ET@    S&F@U@   M G@s@ t 5  H @ U^   @SI v@ v  M J@`@  5  K@ Ur   @Li 2 T t@F 
M @ 0 U@ H@R\Uf p@xU @U @؀S$N@ N Z *
h ЀI@Ҧ ڀS
O@ \   ȀP@@   j @Q 9@ B \ v j@2R@j@   Sj@   Tv@    2U @   &V @   W @ N d  @L CX @ \ En  2 @
Yi i8DiP@nx R@ʼ @\ ZT@ Z p  5@[@ UT z  @5ʀ\@ UD P j ~@U @S] @ @ ` U @ҀM ^ @ R Ut  @΀M_ @  U, ` r@զ @
`TZ@ @ P v U@ Sa@ 6 ` U @΀Sb@@ P z 5 @$c @ 5  d@@ U< R ^ p@U @΀  eT@@ 4 V l U@ M@f@@ Z Uz  @
giii	ҨA <@`~ @Jh@ X U|  @S
i@ L r  @րj @ < X l @  @ikT @ P ^ x U@ Sl@@ L j U @5 @ m@ } *.M U"@Db 5@n@ Uh   @S8o@ z  @h@܀ip@@ R d  @q@ ~   @j  r Ъ@ ( 6 H T@j| Ҧ@s@ b j  @t@ f   @2u@    $v'@ j   w@ v    x @   ڦ y	@  j  @z T@ iR Ti`@Un @ {@ & . HW.M>j4:UB J@PXUn x@ @ .Me 
 |iI (@@ r F@}@@ H U\ p@5 @~@ UJ j  @@"v؀   ?@   $Ԁ@   84"@   .@ 5   \@ 5  @@ UJ p  @e΀C *@ 8 L  i 4 @Li
(Di@bҔ@Ҥ@ j@+@ Z z  @@@ 4 L p @ @@@ AUT t @5  @ DA Z.ML d@ Z@ @{T $ D@TUp @΀ N\@~R@P| > h U@ Sa@   M 8@ V Մ  @  >@ h  _.M@j @@ > L X d@|D j @f@ : V r @Aa.MҀ iiHiA@A S5@ < P Uj @j"@@ N n z J@%@S%@ 6 R Uv @؀ T@ X h  @ƀ @ t@ : Ǝ v@j  @ ;.Mf.M@Ri@ `  ծ @"T@@ |   @i
|@ UH `@5 @ @ UV p ~ @>k.MU@؀ Sq@  , UP t@M @@ D Ub  @M@@ h Ք  @T@O@ P z  M@ U@ \ j @{@ Z   @ @ P jR  Җո @@@  . IW.M<@JRSls@O@| `Uh p@xU @ @ހJL@@ $ :TJ^ @@~@ 2 J b@j @ @ > ^ ~ @ 0t@   @@    6@   @    4 @   @ N d  @ʀ CT@@ 8 H r Ti2 @@ii
.@<B V@\aB bR@bv~ @  @@ l@ j   @ 6 X j @ @ @ < ^ x @L@ Z   @@ V   @ʀj @@ < L h @ @@ * N v @΀U@ P n  @ @ t   @ TR f z@U @؀M@@   U> b @U @S@ b  լ @ @ . > iiiAJl @ @ @ "UT x @ @"@@ n % @Ā "U 6 b v@ 榀@@ R j  @ƀj @6@l@ x   @Ҁ T@i @S@ v  5 @@ v   Ô@ H p Ҝ@ @ @ L j  @ŀӪ@ z   @ Iƀ@ . 7F UV@l M@@@ b Մ  @T@@ p   M@0ɀ@  5  @ p  @ T@ f   M@<@@  5  :@ Ux   @f @ r@( > \@|  Ԩ @̀* @5j@ @ U, > X t@ 
ҮJ@ƀ2@.-@ Uz   @"@6@р@< \ | @@@ > \  @΀Ӏ@ f   @Ԁ@ N x  @즀@@ `   @, @ p   @"׀@ CUp ~ @D 2rU  @ i.4i
J@ V ӕb z@ʢ @Ҁ ـ@ P l  @8@@    @؀
 /@ < T* n @ĀM ܀@ @ UX t @U @S@O@ d  U @M 
ހ@ N Ul  @5 @@ U2 B J p@U @S@ P x  @*]U@ . J v 5@ހ @ UD N h r@Uz @U @ހ T@ > P b Ut@ U@Ԁ S
@ 2 F iiiAZr @j @XT@ "l  @M性@ @ h  @%VC%$ B J%^@% 5@[@ U, B Z @U @M@-@ > Ul  @U @5 @_@ U  : ^@U @.3`  Ҧ @A@ B l  @ @k@ 0 X l @Ȁ&l@ h x  @j @ q@ , 2 F Z*@@d@   =F j  @,K@    )@ p  5@44@ E  S$@@   M  @  5  o@ U< J T fUl @j @  $ * 0@6<B H@NVh t@| *@܀ 
ғ  @  &D@< Ҁն @TT@ > X r U@ SU@ L p U @ԀS{@ h  5 @ @ Ut   @S& f@   M  @ ^ }   &m,@ UZ ~  @ր&m0@ P Cd x@ @2 '&m*@ 4 iTDip @$PnPNn / /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй Vs# hNfP u	fXc  h FWZY[Xg&ۅF ;9   Ã tfPfS
u	p  Xf[f}XRg&u-g&
pAgf&A"fK  Kfx25/g&ƳL9g&PESWVfW&O*f%Lg&D= $ <vD# D| u:t0'_^
QRfU
}0tEJR>tK2dtE$fu
80t0t	dpt/  f]ZYPSR uLTrL&8d5qVt tFu
:ǅU. %+~'<t< 0
*QmIHZ"P`0  ;p t; tށ t
t4d> ud:>u	d:uހuu o@ & u
( 3 uo u_X!
j0od:rq 2fSQV3Ҡ7dnn  :7dt ffKfn+-Ƒ3  49fnP'D%g$ЊFg	O1d nQOr14"Wu'vn8wO n,k n _O^Yf[PR 
 Z #R;;=b;a>Ҳ;!? <SDD"!US
F.>6A OfŰCEf`Cf2FRC|xfWAaaAfG E f~QD$
pD$ f|u6_^Y5OfQfZVffbXtf8Њt 	dWD 0 rfP%A\2YP	V0d 9dff0SF?t!hXcgvu}\>t]6f뿢w0dp0f7:f^ffKV  ^#Q ߱ +dP6f>tgT% 1d9A f!%#$hf,r"%@ {f@%90nQRV&>	>&N N B@o&L&mfDf% ffDs ^Z`!u.0f 4sp2(2{ÀD4^U^nBn@& BD5t(ހPf sf
  WXfffL8[3`'E82`D1R? IhC 0PPVVuVVZ|ZVZ) `So<1C 			;/acZhpcR>cxZ4PQ2p`C F%fQfRV;du/7 l'(n  P   6=h䍚2( Q ۠  f3۹ {f`dTt А^ Q ?ހZp8@0XFfC@u$#wk'5ys>#H
 "o
d
Lu?@1?H
Յ`,Lu?Z苆FFILu FQ$N2d$G^fAɢp|nzn P^"D	%ÉD	f:-fɃ@v@ Ss<v PfUKfЂLf Rf$f6f> f	>fBf ,ff]X t- `-̀Qԁf𔓉6O[f_py"RӃf3 Zaptރ> Kt5u A@@!v0p*
0x@@۟בRVI ;f;tff > F蟨#B$ ģq ~gfQERڀ>  fù f1C;t)gf+ C kCΌ@FӉR`@4k? e1HHPVp ^Aah3 ;u; p;-b7P7VoXf.0Xó0      A     ,X fz_uY rTB+!xg@ |y  |  Z `}	b~h>DTyЋ0f+ סxg u%f&z_h3| z{_O<f f+f,f	P 
,Ж0f%   B, zff1,f=A&  ϐ2AV_f5a 蠜=%{t 5t;@3tZ0tZp6DfqÆ$~g]#,I#,,f 	f@ t{|"s~ tD@f f),#, 3%,f>, 0 PuD  2ft.?xg@P 8rfP u$	,t11 >+@!R0+'"b"0Hǰ Q  ^tC@fP	  tX	j8rH'	"	0 
%9 uf-%Vq00 P3
Q 	P+fFt\q  '	+ 07F  f@ 
 pQDPΰ*',@69f>-,gGf	@vgOgG]^`db>^E"3	l0	5
1@#Du	%&xgf6-,f	f`',fIffg^g~Ou!
*t4hy@20		0	  FFhlJ<t
c&O0R8Du
 598؃ uC O&O%,&O!hxg&wlbL6͘q@,f (f 42a3uf,W  bf4vawSgff9+u gF9,u 9,u
gF9%,tgNyXfF',zr=БC =@DrxiGsVfS'`c(gF'	,g^ g0H!G0gFB V* /e*emd&b&g&g&G
 q 
 d Gd* Gg&GP{G
 G 3gn Fp+q	Sf`G֏^-0\PfVA cs1fmd f fIf!,&,,+,(,  , < t, f^j;vω,q t0 o f@
BqygfgG p ,gZG
	qGfu3 a ?Hf%fE@ !gG!&,, t@bkf#pFcn1_OÙB's
fPR7[fS
f3ΐ5pp$fP\QfVå R  	`@  R66ߟ !RT!GhP'  VHWWU949@@FRGKHH9\9 UWRQSPV rw6t ur6ffWR`P0 eXhNf߿Zf_P>6u69daPS puw6@666/6՞6[XFf sftf]PP P[YZ_]e È66փQ 6 1dP1d j0fd1u!6! ȃ uddfdm԰  >P6Sd ddSP (661dfUg&t=` T=f]t,>@u%ttt t	tfN tF )r@u8als
 1Qh 6ymRuF{ . wu${
}VێeS tRrt}ـ? Dpf^`fкT ff_fXs "qy#uptLe6 ` 6 uY@~Q$ae6RfWpe*&68fw*fF*2t*܊e&6fX^fY[f`3dM'N!(O6 w+"pi  Āu^go&Pkv߁6R @RdaSQVWU&2dd2d ui]_^Y[LS-120ZIP 250PSQRV:1:2:2(2PKp
Ux
I~
`5	36)@|+5
s!hE_t
rg`/;<tV< uWQ;f  g&:D= uFfG_(*X!X  JAZY[X2du 6Q4d666w660 RW1h
dmQ}E8/_Z[M-Sys   DiskOnKey 1 #aB5dЭk @  f<x fP f耡<"%|= 2r 0w"1s 6sU3IH o |&R 0f@fPuLwst6Lr)g&	ug&g&c0_aPAY rLTf<?QRRVPeF5Qome}"6'wG;`>@{t0hpĵt u= u#P-{3RAf?$HSC 
~1fXuײ?D0U @0B06B0B0B0G05F6F 	 xg&3FPRrco3W1>#>;!2>
4_ÈYhT; 4  ߰h;2 XZXSQ0+s!$?
po$˄[p  - i 貟 1t   `*  	 		
		  
		 
							
 fSWQcJc!Yf_P/ALD=f6D=6@D
$>6%
ĈD
6N0%6?tbwɅsr6rI`d
{Qr7Rp0[USBS{u[ t t
U	` 	`6T 6;}ޡ p arQr,c C0ٯ +<%* P`@`2P QrIt2QfFpYrgSfBi݀^P@iAH\
؀e܉\bhJ
pVrA
x @
`yA!?
0
"#sTr
=aWa'"zCS#vD=q*W.?473'PT2'3蜛oZ(Z
2(
_7
qO_=%t9T$RPQ$2Q	@ ?	FW@RP2{  с>{[Ru g&` T=
yXS<(f; & ySj66  r}fPQtA3 >@f+` fA^Vu6`+.
Ff.6	FO 65fJYfXfI|G<`N}9?,B3U+*/G/%QfPh`gfėfXY"N0\$J?;׸G7/Osc`MoDAp@A<e=S$l==38%pQ6ORt] mRti aRu6D$
ƈD`azƐ΋P!l r
9rY⹖ /p%tF°tT=p2:t+:u hNty(u~~(rt@OR=@tmR=taR=`	t[R=Ѕ O/Wbq6`ofa0V68dtd߶}sޠrmlg޾68Dt_D$PQ߹@NPhHbB^`SQ@O	8t`g	G	 Q0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *86T!
  	|b.>  
x   LLo      2|гSJא(L&/Lu!U%ru
>(L t* / > XP t/L+L+L>+L(Lu LPS< tC|r-L%+---L(LL*LDΓQ	`P%s`
3ۊ `K&LK3Ǿ *LpVS0d@t	Vd[^@pV1dLF"ÈK?cf4 uՀuqS1czKndb>[^pqq?fU >1d7dS>L>7d&Lt(
ߠLע1d LK_[ff]AA`Ft>0L0L r1߻Kw%0rK&1d6҈0EWL  k [h6bwdhEY!)* `1h?gӀQ	r胢p t1Kh[L"rL&8dL7dLfPSQ`ݻQLf3foY[fR1Lff3 uq0prfZ2F E *  <FuL3t	 Dt<Hut26Pt1P >Ȁ$u tPaX]L Y7L uB<Ft<Tt<et<t<t<Rw*<Ir&L
2@&t=P>L`@P4<qurYiVW HtAQ ft(PǴ:LOu 
  gXfCYqq q9~ w2LkYⷠ0R1t&L8r >t}aRw
$_^t0%KLmL Kf? t<CpR<?tSQLذ&Y[߀ u
l/qpJ@I - n Oi_8 w  `  8th
   0  Jp 	 	 	p 
		 
							
 

 > fWQf04qzQY`f D5 P6666sR (P6z09TD
$&O6
ĈD
π 1s f}g&|5 EBr`jr  a`SMM	 	n	M)S`UR		`SH\
|N6
\N+se b`NobS}͠" c͐Ă/r`y͏Ј-̈́&pW3
	#rgqWtX0Y"ѝ@ fVԴj(rjdyu6bDq=VcV0Vpfqh	Yv		xvwF
 T `; !sJ%|=td%"y:ur?rpq~!(~rg2oQVSL	;t	]PAϦ{=^A RΗ0   0   ? RrE d    n  A` P 00 3`   
& Aa %  	%
0 #
"*1
 
3`@& <a`. @@ 
 b
	 CF
? ?a	 "  d q@a	!?@ % %@%
 +3F	 
+ (E+
3$ 4̂ C8 $+(3+-E-@(C -029 4- (`(E E3  .c+! 0
  @/9F. 7'GC@<6A6D
!:7'  "J",A!E?9B@,3
O<bJ# 
:QT S<R"G 3D%M TVaXCJ UK8'(XAIc  WI Q^_`aabb|cCopyright (c) 2001 Intel Corporationf`@ f.),<t<t$<tc<tK<tSz_f&z_zg sfz_   uh   uRfADf3~^8w0=ISGuђ۝ s
g]~_!t f6_۽	ngftczRa tpt5Hxg @u  u uϰ0 # 2 P f%ᘅ3 
f>',f5Dt	u)f',(;',wuf͸Q@ffhltff"tpѣ
0Zf1sq
B  iv@#tz:AO0!<u艬g
`

:	uu\	Q	''hm/$_',Kf6-,	g~ u%S F#, s@[%;u!,?f=4R0	ff4	)ffp	Q(f>	f@f[a " 	!d Q   " =[k  PfSQRV d d d/w0Tzİ d&qp/(pVf,dŽ>0W !	u*nnnn>nu6n
p Π1	d蜼" z>0dP2kۍ$_3P:_T	[%uF &
0'u2d  A#uU&C sPStvt6	 0 0 7dd:u>+ u4d> u	 t#Aunuf,dfdnd{Fu<u2!zu? I^ZYfpg&8!vu	g& r#DtF@sPVS c[^RVcW猺^_»c!1YZ[fPfUf3P-萸j蓽{f]fX<fSfQfRf}VcsWzgn uBI tAINp`J6g8QqfIAg^f)=0wpf^fZf 
!Vf+f,f={t"f=Ё &f= ހh/f=0 3f=@+=t8t34 , 't"#
ttf}g    rfFPPTRfpF N  fXr rf>	 QfJuf}8`y TR2f2f0c{RԈ>3h32(W Q ۠ u|of3 f}f6`~" =Z<tҚ1ty]TG-<u	u6$< t<0t$ `Hxky"P5%_uAP#,RfW;',rfc% 1f f>w	fq~ffg8u#x_1n1n<n
f@bf_,,PS{@h󝻟>&.@Foفv`QYr;f.;kt3Uufkat pfff1Pf= v	 +v?:P,kf́   :kofP  6kÃ tL;f {ǰǋ;Ptk .kB<rrfu0`b hy3^-Ñ?ar?ffpQf`f"ffROMIfMAGE;uq W{t#gk KPQ (J 2Ґ|fG f_ZYXug&wag&+GSG 6 "2/t"t  V pП cu'[&wչ A3
G94} G1Gfԣ f3Ce-jikӸ00ùD;gfo-"  P1"`۳`W, ` .ma`B0
>t1ap #"#[  "ݖ PnnnnnnnMSV.tvnW^Q PW>nnSRP#u<v
n,n0шn 7#dGСr );\qсn! /S	cGPn`:?nw/n类
O	c? tWûdH
u	nWrg&Qtn>}rn%dr!"nKr
 JthE	vڰZp4tĳn轰=2o13
	u1dP$1dXp Z#,[$$_eR Z_]qR^ Ն_ `qP&abpZ&&F`d ~R{< u12_R1RgtXr),u)RG`SQr9R'$8t迴ۋY~tr$V簄O㰆HAr(<Fr^(!sqtrp@ppq9 P3| bf8 f܀g'Om o_   FFBZtNu`b PQfWfVCswUU0T*@bP  'hX,[!{u'0Gpa .;st30_YXh>`  `#Н0@^	t W E'P
p cC.7d	2P).s sg0 !WY
f5Ugg& suf3/f`p ۯtfYfWSg<t,fUgR r8tfGPQ$@? @8tbUvPvF X PS~&up u؎[XPS2~uaAf/02؂SRغ P ĲEðð1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        /                                                                                                                                                                                                                                                         @                             i ` 10   ɀ$ tJET  a`݊)1 u B KSRP t@B u$Z[SfQWP @ Xgg_fY[f`|Q
`fgfafQRfWPSf3f3ɿ f0<  P tf; Xߩ tDt [Xf_ZfYù@ fPffffX,fVfVf   E gf^]! f^	V					:		 	^		f	W		fWf	_
g&' f @f&f_fPSQWV!  tOt{#/"A$/hfP u	fXc  h TQ sY^_Y[fmX>uDufS`f%2tE p  p 9UhFgv uP   =(f3f g&G4g&tCff&fft.fA f1A (  u1 D zgh*
 I鈀1   43d7dh[6
a4J@$5#4!63P(S  %aRpp  PZPQ7	3	uJpybqysY 3YR1	7d h'ZJA/.߀&. t...g&'U +r`Q.;t1*0V SbS0QX~Q     A`8P%,Ⱥ:#%j  t
ف     t(  Xt
 %@  P t u>> J> q  tj @ `3 %tNtG_ȿ fxff3u2Eff#f  
fqY*
i
 XP@p{ZR.Aa#؁ "iu#ہИf  r!t%{%pQ# Y3#<` ZY[p?Pt
h  Fuг # `u蕑o
 P%(
} 6(^(5tq%3%Q_ "  f`f#a$~s  5 1ݸq 0QYQ: 
 qfp1Q!sp"3p$uvu
Q#qfZYPSY'4 m'TK T_'V=VQ'htttr,Bjh>twf fg&^vR Z Ѝ5  -&4=
-&#p%3&؀0@uR&tt@t
1֐}&3%@uf
p#1 ` \ nBnnn`tnJFn aS%˽0À 37!C &?!Cu3R .ZAhÑP9ΖDX=谖&L$x&99|ܕ>&CRu	`SCup*JT?
 uTJtj+t8QWP3 PXhX@.X=X@uX_YPBP*up$ q,!.$> u
P;t$@Xuð6C @B T AS5gઋg tHu.g :f@g&ffѕQfffߋgfff6<(z.&gBfsDP
hl!E9
DfRWc6U @d 

(
u0NXZO0fGSQBa  t`V軼p Up ]h
j,`萸 Zxa`7S,[C vS3ۀ> t_t,t:,<C ^[0Xt<w> 	8tPߵ踷 
 
opЀS r 
t, ̷ҷ ,,赬,讬
ڷt or"}5fP	RA,rA aS	 fXvt6#3HEBP	4Á@\׷t1-w&㋇-.PurwRa$t0
w&߫< t
:@ 0  - >@ut
-a  H x

p mI nJ @b ؃@PP I 2)
s3y@si  Y ,
1F0WXZqe`b:Wu;pu;th{P0ܠ!   Q`ww
210r &	&0
À
v >2  22ff?RVhpoGtDh^h{!kLhyl|r f^fZf`2 rbrƾ <IkTz
rhfabf`X
Rf7VfW3//8?B`fXf_f!7"" h9 m=Qf`/)
4/O
d "	 	 "	1/	(	 k&!_!!!>p!h=~gh>%wDGc	fRfN`u2rRt F<tP$rf0@ZvR/ts QVW-)m 0 _^}Tf@ { Dfأ2qfot
t/%SCТKyFqa?s;3fq-Бfpf1WWVhY?$r=ыt
 t
uu	  tt uʋ^_fWV:Eb3:ExF c6W p 2:> u6 GHt\o h/T3؋hԹB^_fZff
XK̈́
>^
2

VT>T2@OHp!
Nt.
Or򍒎P44
/ 4aoo/ / /  DO4*<RwS2.[Аø  аyfQh_fY^b;aEf3ɋPp`PXA&G     &Wf&t ffBf;Pg&Gfwlw~rtwR{tpff@h4p3Q!Y tghom&eAX0Y[0U>aPS 2hįWh`2f[sW  3   S`  Zn a Àf6w-Ahf=HIBMu-@ u_qiFf!  g.9u
g.RjFfkF "Sf= @ti1pu  ø gP}Q f a p| a!rNuFgf~f~sVf  t
fP#fof
1vfqvgfY#F$1yV f;so	f
	  fV2 !|~(~Ff )g"fo+s
0	@Nf;sfۋȢF@	rf@f qg&g&fF_fGg`^N &Vf fA=uTA$<ufIg:.!
g
@tT	fs@f <t7> u"  $>p u0AR`n`b_tz+!t谥2#̦tP `s `t艤 9>p  =du -qQ_R
X`u9 5Gr/<t+t&u
$&薣.a@t"tq2t ڷ G Q !pC褣uBu>踶`&cp刐H###$#/#:#E#P#[#f#q#|############ $P`kt~Sdiq|JPSV]brJ\^inpEQU[`duVY iEHKQTZl@NSVY]pVagntxEMSY^dyJUY^ai{DGJOQVbt@5Ш	@DHLPSYdБ ]`tR]l]p|HMT`dlR]p.`d| 
pJPTX\dt $à@ ]PP R,p:%  3` ZBQsS  QcY؀aCf 33BS3_$ 09 &$$
JÀ>ʐ/董06 
8s u`3 
t V$<
v
ط   tǀ>$ t s$
=ؐ h?Uߊ$B
d t㋷"؊ ^hq

vd	
	
s	 0:@>vu $&$ $$< t>$ u
8wþp N
A Bb tpe@f}wfu&gf C~'  @/%dPh p>ft	!f% @W]GPX<t<t<öPS$<w .&ٸ 
%  T 6   s'` a  m!	H(  [ u-%fBBBfC'fw-f 3 00&'ht  `{ff3fwp  fPf  f<) 9p<w  a fXff
 hEuðG		 d  [P	ĳP ?XuB
C|VVb	S!uc9	 w	 [;2P s	X	N	@2P2 Cˀa	n
$


Àu	<X[XQp)Ea>`Eߊa
K
2t @P@<KrKX PRn)ZS .n) BZ s  ""
ZPD좻)ߠ) Jq vJúQ R (
PBX
	SRذ4afQSW 08__[ªG    
@|f f_f*qIUfFFR`-rࢃNT>!`t"ffvfXfDk 1fpfufC0f M "  0I @ c5@ +f!`poT  C7l
 
BQqW8P?9̉  hdDi M (9 7QW
TTy x;{e_0y+z x|C"~rðch㙡(獿t  !$q4! ׃ $$kai-% 
** % // ?3/4O.$F3" V.$! 4% !-+-?-5-I-f3a.$W q. %]-% 0.&,uY Gf
  3  z {-7f`_ܐt5Qdf2u-{-f}_hTh- fas\CTNI u-@17Wf(y7f3 o׃c 2;U.@>@zU.U.2|_s 2$ {ckUV<2@2 Pظpd$Y [.ИИ>=$@^]2 	g?s ti
u%?thtu<ˍr7,0
襟/`S`@u`
 
r ;@"/ q`phCphﰼ/S rs./ps蚉r".tErBO>7u_hοQuKOh2f.fPEf.q ?Xhż?Ժ !I Xrpj. ib jK ohǱu0@}Sh=1.91JP<A$fӃW[QXЗfpfXfX*fXahpOhAiv uP   谱-uuu&gq ?p  a{S[hٗ_%PѪXheh RvP2F X PS&2&2&2[XPS22ࡢ2O2qV0pV0XջS2Sٻ{2ػE3A&E3E3aMn_4031h0πPa U 蔁X_n 0S8rddr}S<drp
d2 ht3PSt `p4Тc ߃& 0s}0O`&GM                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               閰!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( Ϻ0(     ښ      g {`g  h } Z +  ;p?    / W6h m҄w7U ԄS          P           
%X%H_&                                                                                  Ϳ  `*} ` PzJQ@  U  @U 	@
U 
@UP X@YUhi j@kUlm n@oY { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`hfPu	fXc  h  fUf&af&>` 6a  !ŀX[ &SP`@ /'a&&@r
f3f僰~gf }f3fh   W@p h &ïf`f1fffefU   % ŀ-ff0M00!0)ffXf9ffa}f 
  fi@U] 0 m q  ,f5q fPeWP Q   ͡Ap  A` efuaa  !6>eߣуp Ń{ ՃPك"` eɃ w	
e} fe&` b "jeɃffefAffgd:߇ugdfepf3 gCT "8fF3ۊd߇e3 
td	  p) i@ 
peuxްu.Q_RTC u:/
<'
%&bfgfd.S` [WP9A`XP&EX% &E_=YǨ ooooǸoc׎dАhf`ffP fSIMWuUfg0f[ Qbr6fc;w(h>,UfKfap p`p f&?SECUtC)fu?ffQpR Ph\g&XfGذV S 
u Of%6X!u(xg&_-辢$8Iazt{%˃Gt<S肢
 TqTV`&V[tVAR<T"3_tho R"L`=8%= 	 =
=uf FOFFF@ {iS!ffw	G?!""n& t
fWfLf_r@F%f$g&p ff%g&	 tg&  r!SfQcfR@! "fGtt2t~tyf   阷 fAf,P tfs@ 1^u 4
f rFf_;r>1.: t, f ur%Ar}QYQ	 f_fZfgYf[   t%> 
t`A
A!:0./2 r&8"

r_lr:SV9rP#j   t
ff;t;0
 + t D@@D*^fZY@ Lh^2$h!kv kuP   rwp	߾	L u ff!` B
fffLp 


gh
lhNR0T}
`ÜfPhymgfX
%3I# 
t3 v0)Q%pNhy]]G!V< t6<t1ށp4:u"FXj*:+;) .fY (7@ w.	AE_S 
{fUfp>t	~--


f+ f
$f]^$*###炃 -F?Xv0L? Cn@u%ft  '  
?Pk$$$$$YCYX VrGr1t:'tfYt&{Yz5A5O	y




F?Vii`i^fRg&h[r>8\`u2g&50v fZfVfRQP>zffPpafWf!>  _3˹?A؞FffZ f	߄	@],Y`i^RfVQS>f"1 O9Bt`#ahH_Q   7___[Yfi`V/#W	R 0uBЩ  ГRQ2Mr+(P 
 ` #	j m0_WVSQ  2ۊbF(+ؾ8u `;	dY[^_fPWQtPpX7	fY_fXP   Z f`JffZt$]Zp$ŪpZr쪺  .@p
.._/ NA NfaSRVfpr؀tU./tA
 NUN?Xh+tG^Z[fPpI4?h!_JÀ> t QpU`p?z~pDt ހ][D !zf pqGB 
zf@]z߿ fpkQz Ez  9zb   *zS  zDWS QyPy~PyWkyRyUsm,fy ZsNyryЎf3vC$k DFc	R:b	xJP!eDqxqxf3Ɋ 3fSȊp  ȡJݤ˄xx klx `HTS
HAwf8,R" Á@Wx& fHw!w!{w (w'(SQfH H4Q"{8Qoc	'W	v01!KJ	>c&2	 &wa IPRCZ$<X%0   fKls8P _WY_0X t x?gøPPRBZ B@$ `%>&%	 
  3  t!  { QS= pJ@u#=2h2KeOtPRW0_Sr CE@iR8fZgPR0fP f&T f9fXy@  Qee
fh/Z` v@Yv v!v0v1v2v v vaP߰ hk@@Wf]t"g&Gbg&Gbu۰ ߱&~ uf 0Oκ( 
pu"`TK23,@qp 﫺* : ,P 
 l2R۰r/Z|10,ȡ%*؁ Ë34 ٹQ0D4D+
 <@/1";00h:outf`1}0fq2%  p`=0p!P!䡮q 0rt2?@0XXw!0f`fg?ff%PBPgffP *
 ` C  aB"a'APgvΦӦ3ڧDf`P0 a  6&P&I` X Jv
``.f&r&&r!Br P1X
  Pfw0hEHX10u쨧t݁	<u Ѵ<u r$Rr m&&82Arr]rN a`z7da(SvxБQ`0p(`"" QYaiEP  r&& B Ob 
y' P"S""F"&&Va bR ~ ZQRr빸3'H2't2ZY`2ٵr|T5 t`۾TZYa~r#S-EnR-Y03apٸ q4 P㹀 f & &EZP 2 &r豂r8t32 `.&EO h?,t.tGoS1?he[&M.2tð$> 	#h J-5 ,WS Y,4gfRog2?}fZr pvw@5 &E
}, #! ]	A	2vah
D%00`P 0㸨\S%-  DZ`6(      V魆ī^`W} 3 _r- +˸ f ÀD;Հ ֻB`~B O B<`<2rruO0W2&*G_Y{S	 7&*,u&}Zu&E_k[DAP`^QFگ>  0 2<OtY	B<tmH7
77rPBBLѯ: r1 r,q h/cd8SQk?
pqlat)u$<Pt+fhKuҴhQpB`UoY[Qn @qj"yju'BAuYoo~f0P	V o^W mQfR ghp?vtD=F==rN|UtGV Qk4^t1Vh_~5f^Df`  D ; Z x     0NmA=$
du	q 42wXҏ	 tb H)ȃIذJ2ȉÙ4' vSQRfRBP' w	.;Z0"P,a  w+ )aʏ$t2+``r *0hяrEsd/(#/FJ+('*f(fYïʥRh9
}ihlf>QPH_u(DЇ/ fP  Իt-r(qQ>P-rozryq#r?ffRfVfW/>f8t  ; tof;`a߼ fopff!<2g&g
fKf Rg gre hջher `$-PVhQݟ3
A4f_f^fZfYf[ r  s@YfbXPSfR_j07W6uLt;wEf6ߥfOf8 r/fbBfg&rfi0  Z7[XfWRu
o f 酀> Àff`gp? t]ǀ t
t@f?
 :  ) _ `f` ; 6frv`gGwf3ې fPfz@jfPr:p> ff0;w!fVg&f^ufFt9f!Q.0$pft Q?g&$@y%D&t@<f=AT?ADtlf 9&Ǉ U p s  SU3它a  v~b n~1 PD 00~3wɊE r q6~ǿUEFWP*cQ XUP.>9{   ub >u }`	`	} p$ t0}t}{$~}_M01S+r[P<ంp050+PQ>C(ι c r\d`C1P@AtCC>r-t`w r uҊ1 r
-`u`?d{bQ rdItf s`A$3fSRNr&r!ww3҆r r	?@ 8fPRcg`;r!mlQyQOQoPxPQ>q	s
d r	rqUV>R5f   dgofY{uwR Z }h`Yk!C Z.P\߰ P " Y `_2p",u   P sjR

Z@u
Sذ* o rQ(`( ]PS  I 1' ߋRĮR  *r ͟XDC	I 4P>7tS t33J*bjR
t#4 c ttÈ  PQRWV+3"a^_ZT$"#Ϡ[1$G<uo$Vڹ 4^W =_ չ"  !(@칹 K	
R
q0tJ@y
gg&/ܱ1q;/-r tt;1PR(X0aJ2u RVа$rN ;rCr<,	r32Wt rr;wҀ0sڋ^ZW
   е0u
˾   
u P f! uf _2 J3322t@@ 0 	rn
$	"
uƋ߱d;sRZ3QFqF2t
2t	u
S_ø
_..з....6P.R.D舽pVPCsE n `n     `      $ ( < D T ` d h       ߬  А IaaHEA wb U "ܠ@H P X \C  HT2w @3L 4 @50@A
1.?D                      M         1?4    aXYhijklmno 	

                  Z ,89:6NNOI OhX?5SfW TTػP跮Vf#'f@~ <	& (a̠ܿ4ـߋg&&Vf0QfRVW _f Q  K!Q  A!!ȑf%߾`f3f.2fffu_^fZնf"Q ء f' `W
?f0eP3XPSVWfQs:۾mQي t
؀u ufufpv f  fY_^[XqQfWfVf  1ɐ f  ۝ЀKw@0_ROBtKu  PZPn( ;	*
	
Qq3 lRt-c"[`ʸ"ff  _Ya.fUf.6f]zP ** End SetActiveDisplays: \ R$nt5< up)㋗ĸd_;t  _u/m AZoӸg @t>0uQ2tN
͋ك4Y  n@t P< t?  QO
 \p
R 13t`Wp $ D 3ppawUB
 "PŰ	tR	g9P Fc}P(XcP$ WcHcċ؀̿ GcX?cX%cÀPSRbZRbPaba tA0bP ÀbXbȠ QRPSa[X3еa 譱B"cΐ
r j YK f`09KOu$-]r
u.2*q	,r0߽$p&` E&] @ _fofa.A4H11???TSQ/"S [fWU]^31SW_Pð ѓ  Ѱ rH r0iPtp	`WBLNftu MAC_D]f`f>fw ; tDffR fa`k_<_qfgf2gaЀuQutQ SP܀Q$~X	[ gfp Ɗ6qHt/O  3  v ؍`q$at`ZONFwa<@C߳ OO軟_ B  4 	Zu$$t$
$$Ρ"h1s`9t4>0t,PQz uXa<^8 < l <2<
 1                                                               UPRPRVFZX}0RR30ZO                               t Ѝ΋h3 Zkѕ爐; hpn Pf܂2fXf X.U hp|_Tt
   aߋPf  /԰|ӎ҉	S "pi S zJ%yVª C HكIڈ3밒Nrf f+fM%h>/$ff-E9ҿfMAlqa  f>PAMSuff>r^0
FPwS!0 P`PX1Ѹ f|	2% %fP&b0WVf1h!kv uP   rY  E6fP  h
lh-rk f fhy
^A
00.~rB A2@
E<u@
P14
`=f`tؾ(I@"a]"EQu?r&=t&}V" &GF^Y"\@ıq; 	 hy<C
g!
"s

Zr
P 
U  h@ Z(PRغ0 t@Zru<w,$<7w	,b+(9 SfW> tU`uR uIcB<t>pt9 2\r-f'r!\H gNtg&G!P _  f_qQENtZgf&gtK[\r3Ȼ s0Q$
 Opf 2YqPMG"4rMtto0 	
   SQVȾJ0 8t"8trq7^Y[A	t,&
u>0ut
$gsE@t> u.J"t$	&
(s@  P
tqp$	>!2
XnZbtZ K,a#6au5=tCf ƠP L?< tP'$ Ua>؀
	n t ItU0 PT%uTe (- t> u"u
Mk {蘒r"p1Ytcߴ ZLdSQPX,tV
r.hYG9KtB0$0c.rgű//yY=5Jt_5tP }rB36ds6u%
u "476 X6CCa$Mtzu {Wطc1tb#;sW;sQaUWu	Nu u"
u0F"
23/W^4 n ànܢ3t pta* ,4ɡ)P(tXSfW 0`
It@D_8؊f_[؀؝؉4f sg]  r#
"1Ù4/ 4üJ!; {
3{36>4Q4DKoc6a(ߦXߋ$Sә4/4@	44$,44 4ȟ꺙4$Ʌ	(#<b4LdYf.	
0gy>!߀u <zw2.
ibVf&@
"N׀C u
fA
,gf 7
SS-sSrS-[fSfl;xV4tl? uf&_m[ f[%R0Ra݌0@/t tu_SQؐ?Bff؟ s	7᾿.hh0A@fк6fޑqnsdrNBozd0s~GSnlhIr d @ htxffV"D P@@fn@tf^YP@R&Zqf^RW1_'ZRa9kۏv*M>vSà?0/ABSOLUTEWfQPg&	  tffQۿg&t#X_f^Í4# fPR SPff%|h f
 10Ⱥ4lA# uO#af3\fat(,#%9gt!!@1 Of0	0ޠfOCf f f[fYZ0B! o2B@Vl C#fW  g& u8  *t f0K	"f1_À f  <Zu?BrB /<Az@ h_Gf*r`=+G fɸ`$
^(
0
ú:pt#f`@ 3W ƇTQ _ D[1úd u"ϰqH "   \ 	fOf@ @{ !P%l@)U	ٰg&`p# % o&!#ܚR%0(+1#H QR -vf#fz%g+|8k$B+'5
~ f 3 Q'
f~墄CS	J sP'g'p
x|1?fz
s#v!=qfDWfĳ %s@S[!SX@V#t768p%ȿ fڿfA33uƗaZZ JSR3һX3t@s8gr  
'` ( h?%Z@`! 
 * 4*ZtBT0pf%1OKۊBe&$ PT؃22B(RfZPQ  ۀ 
YXPlOBu 0o`:w1#Rfu ZlOfa o	n3 PQ@(0j Ef pqS DP  &Et^"D  $D(ÁsK`A&tP% ׃4>2@"Q
g&Ŀt
_ 0HL &}u?p ?u8&= r1	&
IW$Br P
` 肐 m  m 
 m p's 0a` ar * $·OQa	 & a;# $$<@t"hXfP P	fXc  h KuKfKuף`.>%st&3r	&*SrHI:Ppm-Daô`prr X ? trʗC0}qw1#!8Q909$Ϻa0){fRQS[Yf?Zt'1;
|{ a[`0
ADȁmG>    htruf rff# frt@r<fffHff#f+ f;wfS3g&S0kc
uff+f뺀Ն ,.028~ GaD_@}2?/ZI&
Msg
}A	dc#Íd	"AୱU
igP`ȺД t@  q&ϜaQfu x  
|} Rg Q  W8tQRi eAjPffX0f f~y so   ` 
P.""PfQR)>0 33p#<}ff?f
 
|s@Pf rߋNz]d%\hPf+ѯp0䤻    bPѨrS aifP} Cth{cbᮺQa!% = u5
;= uu=  
!` ˇ!N2f#Ӈf@ 9@t Q33Q1+ rbRܺP Q   ,A048 5#|`5 A pÖAг1c'hHtdrX`3  P A܀_f4 fa!"ADRĕ'D'JXѩ@   °iQ,-./01289OH     `a-/RFAn$Wa!PFe=G{3""
PA[2t*  t`>@ l>l!GA lBla}6$?C ! G @ ATp{ Bi $0sF ~ 0n "0  BnnnJF$a %?JF P < tq P ̠̡أ.ޢ/    llB  ؿ lBB@_ l@  Ղ  @ l,п-Nz&	'߿ ߿& /$ 
@  
F_Fn  	n	n	n	n	n	n	nnn 
 ,- ta  `CdQ̀ׁւ`  3nnC q
p		 nA
` n.`4/q `QIJ[@'
03!4V>+t
 7NO+t3GNO`UNNP @RSRf`` PSR                                                                gH-  d 0!          d  p                                                                      u  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                                E   
 B440UH˯;    @ ` .UNDIL   ?OPCIR3        H  $PnP   i\ Z!AsusTek/ MSI/ 
Broadcom 440X Fast Ethernet Boot Agent v2.0.3 Copyright (C) 2000-P 3 Corporation19970 IntelAll s reserved.
 &
, PXE-2.1 (build 082)	MBAw	   
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 tw@q/2?q130QS0 [Y .> th  Ph2Tp  M  FP?SQfRWV	hJ$Af.>I t.;@  ځ>  U  r r h@ ۹H l 8tY[i
a-EC1: Base-code ROM ID structure was n 9found.;T0: ASF is enabl`3Q2 canl >.   YJC 
?	8Sfj j ,'>  t;sf=$BC$uErPj W떌ێ0 f&#  .6P Q   ~j Ph9&u
˃Z t9hlRMC_L Ner() ==  @<r
?hC%aEM0F: ExitingMH6^_fZY[, q . fТ 0 QuES p`f
@&6 +&p fRSfP& fQ73ffJtuہ 3fX[fZP9.6&ԋ DSfWfUj j  0RV콺&@.~6E. ...r
"@?ЉV%H96UYWoPf6UfKV  q p { t tА Ȑ:08P`d62 3BIOS extended memory cm error56:rg driver image6invalih88: !a7::">segmu<9:mNV+I u JO u5hwd+%F3 FCE)
mf#I,M +f^f.O sDhP:Jx5  AH90M4Mzr?vf&D?F&D@g UB! H`PeJR&D JV M&(DvՋAE@	///Wj 
&\ J
){;huBءL ` N b f3҃Whf[w fR}XfZN&  Yju P$8v uj@DH FW FR7vX]t!
u0Sf"G HF +F )F[fSVWFJ  6ˌ##FfTp`   f`_^f[^^f]f_f[fX2!8RtQfbk  pQQJt u RVVfp  OffP= t.. ﾭmށ.
s	N]&}t	q t+{f&}w us.Pn9wf&+?f&;Esp RfXRw *=  
 s@8r&f.K+QAP.=uf 1AA	f]3` 3 fP2  X$Bt_ s^ޠ+G3. 󫎯G3@0 ٫'G1C=N C_%=ACs
  0  {u	 'DBHAAHuHCtH\s   	 u&<Xt.;60 r %RAXrإA< uwG&DA 0G  &LmpG&ЪG G"QGH(RH*!H0PJ8UJ2J:.0A6K>EpLX:Jh1J`t ^K,rN*qrGup*. T
 &5
$:P1P ?  f[]ˣ'<fZ@ȸhP
`4t
4fX p+MW~ Qhf!_Rf8f N` f^   H g }5B;/fp0<ߌfuffk#H`2du fadð;n?(f0@{uqB6	Itf뿁fPIpZ
4	At'\ > љ	18fZL f_ fQ
Ɛ  
f
̀AD f9*PrȐRf ẁ _p tfZ A N R5%0
"  @tf<1fSp A f@ a fUY&O @82SKaRxPf
߀úff/fZPfXQ)Qfϋ
I =f;tfIuZ3ru$13.p.P #.Vo.@P 	P@@Շ.( SXf%$ v֋]52 mf?_SM_ts OvQj mS/A   ЀwrgrafG".tWO0sQ0 Yufh w Xf,g8 tIt#gfXfg f@g@tgePnPuW32&C&:]u
uB }
 t7܀Sj`&]
[ue3t7+SW ߀p$u> PuMu	>p ?Guf  `f> otf ӀpfWf@   t;hY`u07:  PCIcallsupport ~ 	uQO.;DK8Dtttnh>댥1pnRDevice!Pqp}qY	4 read!
configuration space3ff`j  wP Xu
С ?|U.~/Pۉ>_fR. .P 2/<tRh%uOp	!requires DDIMe`Ϡ6$ |h R6"P6% ?C `Č!0=pjfj1;`f hfQ `u0h
 Tb%x
I PMM funcnumbe` u&h6EҰ@"ocpC Gfxfrgfgffߋf_ \.=ڃ>I i I.H@0tt	 t5` `fdߣS f M_&u Mze h`M> Mi |՛%Et`>=aFr$. 1op2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @     i     (  vK  A U B  o
K 
- 4o5 N%ҜkJo!c-ڱF)gB1Z5{^R9wVs=	G,bC
f(j$O יnKv8ϤS<rW[0ǉ~_z4\y7X3}?ȆqTu;P#mHi'лL@e+
D/ؖaUp>Q:̓t6x]|2ŮY*ݓdA`.EIl"M&hE!W@mW & v  	U0 
& {P  /` 
U!p
o "# 
	&G		1"#\$$x'))))Z*<*J*t))+0//$?$Z/^1gC6DIX+802.3  tttttWS ˌt&  .6 !PXEX102r56ͭ#4?    sNV+,vO@ @fUfSfQfRfWfVfPFwO. ~
,2&22ێ46h@ WP
` fXf^f_fZfYf[f].>  u
  `  fv
Phm.6 j `ϸfUf	R	g]g}wer`C
f&.2؎VP
fUs
Sp
q
[f]
f0& tP 7u	@fbڃ>*2 tj Sf. ffף"2  &2. -  2f3یȒ. 3h f&  f&*2 []zj 9h uf. fh `  V@ g&5@"+g& ^R t,@
? SL_\[`1	ePfX&
=PVu NVf. -f ]ϝ% % Z 2.  pQFp0~ uP;ː  u^&-鐋Fa*5FsB{ C̃#%cQ'{뚣C{	q 1	gC-	])	S%	{I#_	?	5c
}+o! P<== w. *4>HR\fpzF~@ˡ>
9 tQ h@62X9^&G9p 9&Gwq  wQ	
9@6o
9C"u!&3 c hGa>6u31	D	8fj@1 d
4_uPK62#30F6^G#FG%F 6F`GF~sE>6 u>^*Fr)^Vt  Y OtfcGK TRt,q	 A
9 ( :`  0jK2Z^pa^V:1+/#!!t"G0RxȰP:a `bQ#G/t3+< ' uG0 t>G17
$1W

)
$qI
F- VF^	#	
+t*u! 	a
m
		#&@ 9 Pa P 6@F/9GwϜ!.p Ia!2G0
i"P"M9w!V0Pe-&  VF  	Fǳ` O@60:]nF)޲)TA^P0ڋ^wV@* usF~o'}0!6P*zt  2u?!!"!-> uF ^B|AeOfN%'F^F`kC   Kt2AC^v&F&~ ~|sTA/v@jK*1KHt
H|p
H~Hc FF^ft}vQr{4psFb `:bݸF"v:f&p &@
44p@
 ,<s@2<:1;FGG &G(*;G,fG GfG.q(?" G` 1ǋ^_#4PZ#*_%J$~3bOFCFlESK.pBIU]pC9
99[2YF99N9A9CQ9dVbh,F>v)_ވ@r(+ksO3t dd9iE;O<O?O_01OQ0zO_%O[`pO*>aOhOcO6AcU/%]uz-s~G蠺6*GS1`$s
  (rg1n@ճDp`* 0 &)遰ss`s^$&GU	 
`gVsxa$GUvsxcGG
G 	b
򒉫Gx{C
y}݋F 06 蟰/f!G`3>`#cbFTU O- p v<
  FFu !U#Ǡ  o B`t
;ҡϐlm k>p>t,i
 F0ŋ^	F^V@A""l.
R'!]谼L
 -"5(rxy  ^Zv_
*&o$PP {@@iu+iu$ jub sbF)F1tI&?1?&tr(g - @P3LğAT7> p 7 >@|y&<?F$!0WlF$*
,D Xu2Ð!P#SVp N@9u2cv@3@m@GbPX2gÐ`8OY׋@ȰqPj P3۸Y_F iV@CRZS1pt$ÜX	S[	[PA:Sf3یfff[F @]QN$     YRfSQVNfP$" [qf[f {@p   vpf+fX" " +$^Yf[VWv^~F
N~ tIfȃt_^	PQWf~N
jQY_YfX]Pؠ..v=# f"pSӊ2@t>҄F  O¢ @ .CF TF+K p 	"2C$2c&y(@gP D*PŐF ;Ft;N `,G jVQȋs0Y^< ^]A`WfP2ff
0úff``{fX@_]c_Ypef$  +
2C@@.PQR,`(;ssZY1ffâRPqKFw2^*/aNFA=Dw=Ds-t0ø1-Gr	- vHHt
AP  ` &0VjW@︜t	3 cVFׇ  33$("Āq$`	DAG	ub  ^@
!ntBBZu
E
vp0d!PS  @V˸NKpQ%qF 6 (Prp0RPV7^c@.}I@+qw?`9Pu  19@u9Pug``P
_纭"`P%@|f+f@=9Fu@*~u%  @b#!]ƋNE !t ??,  Mˠ~}+vu9P
uދ``q+cL@$Lc%рN DF+v&F0ޟ9F|#spMp]wp$tۗs 0tp z/t(tcYh6c.@PİX"["\G
"
"Ph _v@~ѵ 뷐=Ǉ&ktaGbR(#*,c.	0	{2C
4'!BS!G O&Q3p"`HG j t  uL0Ad|LQ ׇS=w6PQ?KoɁ *$"$ump +	Z ШR2EfFnFq|NA#;G3 w G"oV>1Rl	F9FuNbz @+FHO~P V_v P:2Vpw@"@P@i
S *@u#(KQH#؋v{t `cw !"F0G+0#(I#+)ؑ#1_0eh9 yG  C@bCNR;FBS <DF+F^BFF AP89F;FR`CB:>V^WVrU$"_FcHsr)Kb$ fs Jt"( r BS @u&1p U<I@]Qa!C0kE %ErBEA9AuҋpBPO*6R,1po 9D95vӀ"A    ~ ~8,)FyT(3A`C@36"z@N뉡Yr?M[@+0V;FsE+@X02FubG _GG\
Q 10RS]׉Fp+*b.6pBK^/*Bp?qL_f?whJ B{ f++J`,oVpkvH%HHb SHAP9kM2aFcEAVPpF G0?x.%aMuP
^9g@t @0`I#@]
u`bq1NP y.p++;u
;u"aa9p|v[~a(x t
E'x tZ,+zV,BF`1t3"/Py6#43E4|a3^9u,aKI@oD앑蕄=uGtDtDtu#}"yjefY`jppzs5^؋ܑA_FډG1ĲДaGG,R`_G'v؃'$@  @V8q ΐE`ikPPfh  fh  j@PFPvڐ
7Rc u^ j3 Pp `؃
G3
G4
G5
G6
G7
G8tjG-P7G3੦`?fGtoGo_1	GP"CS70s
`̓а`j׋_{`ƋG@&8N
 



 
$
(,048<@DHLPTX\~xrlf`ZTNHB<0QpGC3? ,-`T9Gtqк؀@m w
r}2n
u`- . aD` t\  G ( #	|&Tu¿$ o  oA` c Z  Q" H ?	tA
 B? `C C
Āt$P
3
p*Gp+r02
Q!W A F
`+ 
k t `RO!
wa*+!dfv(f
ffff 
Q1 t 	 7
Z>VtPd  t	Ր /^@ 9   wrH t1	1	蝣 	8P<4A
t2=$ t	0~- pG^F@G 91X"{U+	0%	0, ^_! RSfG K=`a-*C"II	@!-< 4dPPs`fСa 1fg
pTqjgt'Z1aApW
ҠV`!3Vffq[f/~ ao!РV5p	G
	W
WaGW18 8>@9ʁQ:0gF6`$ 056ef ! @%
) ( RPO(3{` $ %0cG
r bN
q u0*pȋЊO8OъO: +*;$WPAm2hhd
\*p|#CmA%'n0)+Qo#- /p3103pB5V@7aq9P+;r#=`cjr3ApCqsCEG!tZSI	KtcM
OusQVS1vuUWvd	Y
[wS
]_jAxBacx1e gy Z
ikQzm o{1[q0s{u@0t#P}3V`}Cpq~S!cjsᠰ1eZ	T
CVA2 !
 "#Q"$ $j0%#@&aZP'#`( gҋEG֋I K QSa@cDe g0BA   )+tTUѰӴpUt0	4		U	

pUt
pp!U#%p	'p	-	5/p	p!0mbtALu	a`axbIPN
`~3{Su4t *]H hk0!MFсP	QBtPS$P0	Fqfri+c!lLbsPS=$h @6z}Q^dqpѽ žhgb hH$dT H	@pfQG
ீN`   !
 |	HtHtHt8Awf2spd Q =f `O	F2EP pdP dsFG tأ LEIUlOH  G#FG%F^ F^VFVߋF셇F tFf%  {fp_#GR3_%_FtS$w2P`>и V%@@^wà`t
f
.zSƇ `3Gf Gh=h=UuV`< G3V_GW P4wuT'FFV FF+9Wdrw9oGbvD	5P`#rrvk6t `΀p
wW`9F
Py
~333e$R p>BbdVf0!".Bt!CÐ # DF CcWS.`ʛ+pf.AYF  u		RJAt@7Q/pFЯǯFb0b0O `>a2~? @B=~st_0P߉GGF~
u#F*/`2 ,,P}	 ,bYhFtʭ
 ر.ʱPGGVC.f " Q~  @Q艇 yfppsL
B@ PM?lutPhtxǇp Ft!d }at;k
 <
߃ `U~	0(׹3f3ffNu[,CZU6pg3;"7 xHJ!sG e#U1|4A@sM    TO r1ZƇbf!22%b`S
* *G
>
Y*
 GQE,2"aPuba$Q+0Q
ă1a?9**U(0i`lfTRtSqP[B?жv"T dk^P2
ذa  {`0 3zPSQjGPgG  L~hPS`jNM9u2P1vǉ@1A1 gGB!mV`9GA|GO H@bpfa膋``uEPO  W`jn}3]n<0IAFGz6p%0GGvwx,7${ z}- ◁Nf+f Fa
  |		WPy#1h tPfj ܃
0{!ÊFr<t<{uÈGpGjGqzk#ňGr#l3ĈGs3m^CǈGtCnSƈGuSoF.%`)agb@  P \^S2uRffR+2pjA3pG%~% uGtR%1 DdKL K~B?E?RpB?>>T v?g?a?8QaPnFS赏Qxo揨t$$bCQ%\2| MXb3 OCJCdCCCCnFϋV
fѝ t~ t^F&^F&
uA WV~0<NV^_~pFN
ȋNu	]S}f
 [ SF4yN`3q3ҫE^@ufr;Vwr;Fv+FV
+FV؃                                                                                                                   <             TPM     
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  zByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   i#fsf ff   fT   #fsf wfD   f @#fsf [#fsf 5#fsf #fsf c#fsf M$fsf 7$fsf !3$fsf I$fsf 7Y$fsf o$fsf 3	$fsf 	$fsf 
$fsf F
f   t$fsf c
n$fsf xX$fsf 
BnnfLg&nffOg&fffsf fsf f   f   ^%fsf f~fsw%fsf ef   %fsf F<|%fsf  6%fsf j%fsf %fsf %fsf x%fsf =f   t&fsf &&fsf of   t?&fsf hO&fsf _&fsf So&fsf &fsf &f   u&fsf "&fsf &fsf Y&&fsf &fsf )'&fsf L'&fsf 'f   'fsf <w"'fsf 4 f%"f   t
fp鎥f  ^'fsf {ta$f  |'fsf ;tuf  'fsf Df  'fsf    Iuf  'fsf f fsff   f   f   (fsf tff Ag&ufF(fsf &r8u:^(fsf &u$f3f   u
ffuf   tf fsf   (fsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  4)fsf $f  N)fsf isf  g)fsf rf  )fsf 6   Iu f fsf   ffuf)fsf %tf   ))fsf $8uf   uffuf fsff   ftL4*fsf $f   t$<t)<t/^*fsf $ufffff   uf fsff   ft(
*fsf 8$<t<tfffff   uf fsf   t8f   ft+fsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   t_O[O0f   +fsf $t<tff @   f +fsf "2  +-.,fsf "<  ff   f.:w .DN,fsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2gOff   f
.f   2f   f   ft/^-fsf !< t8stff   uffff fs2gOff   f
.f   2f   ft(-fsf  < t8stff   uff ff fs2gOff   f
.f   2f   ft(b.fsf  < t8stff   uffff fsf   f    ft'.fsf $ $t<s
f   <tff   ufff fsf   ft/fsf uff   uf fs2gOff   f
.f   2f   ft($v/fsf m< t8stff   uf?fff fsfffsf fsf 2gOff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%GZf   t?Z.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfkO2.<u f   t2kf   uff   uT1fsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   1fsf <|f`Agf&   f    f    f   22fsf f    f    3f   ftc2fsf Ufft}2fsf ;fft2fsf !fft2fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   @3fsf <|g&f~fsf fsfLf   f3f3ftr2f   t3fsf Qtf˰3fsf 5<	rIа3fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fuf8Z.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf fY  f Lgf&fftfY  f~fsffHfuff Lgf&f   ftf@,7fsf f Lgf&fftfY  f   tfY  fY  f   tfY  f Lgf&fpffHf   tfHf~fs7fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	m8fsf fBgf&8fsf  8fsf  Off%   f
fHf   t
.f@Cg&Off%   f
fHf   t
.fCg&fKgf&	9fsf Ff fssOff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fs侸Off%   f
fHf   tOfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}Z.fDg&(Zσ.fDg&.DfDg&f3Of   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`Vf~fsfffsf fsf f Ef   .@ fffsf fsf Rfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@=fsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
OZfHf   t[ZfHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	sZf   tZf~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
HZf.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fMC  mCfffsf fsf f 8Z.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf<Z  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   8Cfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfO  f Lgf&f   tfO  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&fZ  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   f+[  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afALf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   BMfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Nfsf ,$f  Nfsf f fs <f fsfffsf fsf  fӇ.WOfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  [fsf Ű < urf   [fsf $<  <t<t
<t xfNgf&f   uf   C\fsf $p2<uB >tHH3f  s\fsf fƳ 
f  \fsf *Ż  f  \fsf Ű < uHf   \fsf $` < te<t
<t UfNgf&f   uB >tHH3f  ]fsf ų
f  /]fsf Ļ  f  K]fsf $
f  e]fsf Rf  {]fsf ^$w<u|f   ]fsf B<|2f  ]fsf (f  ]fsf 0f  ]fsf $f  ]fsf f  ^fsf ĳ

f  -^fsf Àf  F^fsf qÀf  _^fsf Xf~fsf fs            f   ff   2fff   ff3_.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2_g          "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         [                           o~jGDkED͍#(:of`0]ٶUVo^#j	lfYF;EbRi; _ OA 9@fhP) ?ٱCbNv4gғjF^SzDM6c)@#$i`]).?mCmϰg;І\[A;n-]uM^h:9*!1F;ޑW誩O0~1_)W*yBd.vOr/ϴ
%>2=ׅYXtSc!TFm֦U`aMH1':
Z󑈷5Ԙ|ްao#1\nѓkݷOL|)<F+z  :~VU-PadX;*?.5Uc-oh@x/Rdlۑxf&\݁'KAqOrbUd	Csʩ^w<AO<q)+	dCfu%_,[S\
[+f(=]FlJ߼qS:<xM+ٟ;ݞ^^פIQ>wm|
{OYS^9E@3OZ@_БHg(R	"t3٨_1UW!ߣGhϿl4d	}N*w|<gFz+Bs.4<0
2yUsiɕchLEH2$ql[_B,>)c-6+AjS;MF,kOHUAimX?}DS}[!AnjZfe\Ҥn(.VV"O3%;H׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   	    	  !}                           eoղGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:׃FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm⽻]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbܟka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlٱwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋬ׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         G                           
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_œ%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzմTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4҉;jQ0\ǁK15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwyꤎkK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]hÔ9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC ÞUEu;iTBܐx/Dz1J8pQ?h
\Q	ʴL
mvfCG=;k׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE            D   @    L       @       H         `      |   @ Ď    Ď    T    G       	 		 		       
H@ ,@          	  	    @      
B  T     L     	 D    P   X     `  D    X      P    `                O    O    
O  

O  
O  	O A    A    
@          
  @      I         	04
B1e2  
D12  
H12  
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 	 x   @  @
	 	P	P 	P0		 	0	T
	t         @  4  	4,  <	    , <	     <	    ,<	    ,<	    ,<	    ,<	    	,<	    	 T <	    , <	    ,0<	    ,<	    ,<	    	 _. U . " /  . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                      0                    	4 @       T                          d  ` h  $X  `  '     @@             A   \   Z 	  X 	     ?                      !    8       ,      (  *  .           ,   :  8    h   d   f     !    N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N                  0              <fU@f%f  $f$
tppqtrffupppppq#ffupppppqf   fff   tfff  f  gffLggf^gfnf    f
   "⌰fFOfupppppqg- fo&ffff  @$f@$
= u$<T)fff  @$f@$
и f  D$fD$
аff% = uf"sf f7^f %  fSBfU../0./.	/`./a. /0./. B쨀u?ff d< uffd< t<t
u掰ff䎊ffff掺<uf2cf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  $f$
и f  0f  0對 f    < tg 68DTD   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 )s & f    Q7sY 戰f-  ff   f   tf ff-  rfBYf戰YgC+!f3f   戰 fHr4f f戰䈰f戰 rfFf    戰戰3nf  f   f戰fS#f[f   f   3f   f  戰g&Q#fFfCg戰{ 撰fPfSfQf   fQf3یff-  fYsfYf[fXSgu-  ;u[fPfSfQfRfWf   f3یff-  	 fBf   +f3g}-    fg-  r%fG;wg}-  f_fZfYf[fX                                ' `                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        戰䈽j戰䈽eϰff̰ff-ΰff	wff f%"f7^fA ˽GΰfSBf]Hfi,f u*ϰffΰff f
   `"	f   f3f30f  0ffuVf   f f    0f  f f   0	 f%"fff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f. f  
f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
                              	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  |C vZ[XPSR Z[XPSR  MC v
 Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
ψD fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4
 f`  fg&Ftvugf&>tgf&6f٢
ϰ &fe~f^Y[fXPSRfV tA % g&ƅ    f[  \g&  	uf^Z[XPSRfV tA % g&ƅ    f[  g&  	uf^Z[XPSR     Z[XSR  C vZ[PSRRZZ[XÃ<t  Y  >  HPRt)t<ZXÍ$    fPfSQfRV  kf3۹ f   gfdT gfdTgfdTgfdTf   /LC v    hC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $ff f	ffff]X t fff f	ff  fff_f^fZY[fXRfŋӃf3ӃZfPSQ  ,fA vY[fXf` f;.t
f. 
  
$C vf3 
 f    fgf&E   > uF f;  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f[   <  f  g&"  @v@ g&  s f  >
 u&g&.  ug&.  ug&/  uf^Z[XÃ t        Pf   a!Uus  6
  >rfg   ( r  .0V>Mff<>3fffrrfff> wf   >ff%f3fff> trf> wf   >/>m>dff   fF>=,>#>	ff  > ff'f
r$fff> trf> wѰf    } >urd>u]R	 D>u=/>u(f ]  >	r  KI	s 撰 XÜ֫	[uה׻u؂؈؝دؽfSgf[gfPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@
 > u> 5xzyt7
sfZf[fXúz.yu
sfZf[fXPR tĺZXfSfRf@
 > uB ;yM@ts(xغz,y0@usz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  v9 f;  )G ef  !ϸfaPSQVۋL	;t	   ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 
f69ϻ1s>
t fafWf   g&D= g&D= f_`r r8 a`f  gF
$&
gF
&ϻ1sw>
taf`f  gF
$&
gF
&ϻ1]s@f  g&|5  t>
tVfarfWr<f_    f`fyݴf   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f>yݹ gf&D5 gf&fff>yfXYsufa`f   &Ϲ gF
$
gF
f   1csF>
tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva  f
   `"	f3f3f   0fffP  0 f%"	- ttu! ssô ` uR Zts+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f  +   f"     f6  	  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgvf  g'gGgf_Za`afPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZd/[X                              0 @ k PS㋇⣠⋇⣢[XPSQRW0  3)  3  3
  3_ZY[XPSȎػ       !    A    a   f    4 ztR  vffft<Q  lY3gf&A fgf&A gf&A f   u   </   .  #    
[XR * 8 F ZSQW   _Y[SQW   _Y[SQW   _Y[SQW   _Y[    f  fP  fPQgf0& YfXf    gf~gfNgfVgffPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX            <t ø fSQ >tf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0fp   rg<uf   ⃸   Yf[fS>tf  r	f r>PfSfUUgf*gUfUUgf[Xgf   Y r
g8u   f[                                     Q  YPSR+;wZ[Xf> tftf`f  f3f3f3f @ gfffCgftftfaf   fuQYfVfSfQf-  f   f7rffYf[f^fQfWfVf @  f   f  gff^f_fY               fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     PUN
NNOపNzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX        戰3ظ  м{f"sff5`fD    2ø     r  @ n04/20/06DDT  @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff0  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        08/31/04BSA  ACFG      @   
         @                      @    a    p r  s    `  d    
     
    xx        I       " D b e t u v w         P @`     o  BL @ ?  
 
  
  @ @
  A 

  @ k     @ `       ACFG           BL      :  q @ 
  
  P    ACFG            q      3  q @      ACFG           q      j  q @        4  k  4   4  0ACFG           8q   9q   :q   ;q      M  x] @   k  0 0@0`00000  ACFG           @x]      J   @   
  A 
 A@ 
 A  k   ACFG           H      RH       K @      ACFG           `K          H      3  K @      ACFG           `K      'u    +   3      h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             >>>>>>    >>G9戰 䈴^.d  戰䈰p  qذp  $撰 q	u	.. 戰䈀
t2K
r 2.$@ 戰
䈸@ ؾg ,戰䈰  戰a$apf.f. f"f  "u3g=r  4t3gr   ۰ 4怎    
 JvY6 5x          (A                                                                                                     M             f fffýq                    u׾$.   $.   u戰f @KC8BBaaff fKua$aff fKuf f u                è  Ӌ  è        è  VQD   `  è  aE       Y^Ͱ   è  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%      X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aË                              @   `$ff`$
ff     $ff$
ff?fظ   f$f$
fff
 ff fIf uff32fIf u߸   $ff$
fffظ   f$f$
ff   ffTCA6C @ @      Pff    t     t  g   $ff$
Њɀ`}  f   v$ffv$
$
Êظ   v$ffv$
Њ g   $ff$
Њɀ`}  3  G     ff	  2
   0 %" %
   @"	  2%0   W$ffW$
$$ظ   W$ffW$
Њ   Y$ffY$
$ظ   Y$ffY$
ЊZ   $ff$
$̊ظ   $ff$
Њ_~   z$ffz$
${ظ   z$ffz$
Њ   W$ffW$
$ظ   W$ffW$
Њ   z$ffz$
ظ   z$ffz$
Њ3.*w
  3333333!33.SN
  _Q
     <   f ffAfff   t^
  uF   u  8~"`   u  8~  8~  8~ fFf$   t8~8eZ33fffAf fffuu.z'  >*  <|S~  <duC
  f<tf<tf<t
f< tf3  <t2fFfa  uf  uft@t
@t@t
@   t   t   t   tø   iff% ~
    ~
  ( ~
   ~
   ~
   ~
   fˋظ   iff   f$f$
ff   lff% f ~~	
  
   
~
    ȸ   lff   f$f$
ff6f` fe  ff`f ffu"f߸   $ff$
а fGf߷   $ff$
Њ   v$ffv$
$ ظ   v$ffv$
Њ    ff fIf uff32   v$ffv$
$@ظ   v$ffv$
Њ       v$ffv$
$ظ   v$ffv$
Њf     ff fIf uff32fIf uڸ   v$ffv$
$`ظ   v$ffv$
Њ   t?   v$ffv$
ظ   v$ffv$
Њ  ?   v$ffv$
$ظ   v$ffv$
Њ(      v$ffv$
$ظ   v$ffv$
Њ    U   fUf@ f  gfUffIf u    =Uuff`f fff߸   $ff$
а fG=   ff   ff3   ff       ff    f` fa  f ff`ff$  f ff   tf$ft$
ff   y$ffy$
f
ظ   y$ffy$
Њ           <                  <  f߷   $ff$
Њf ff   tf$ft$
ff                 <K            <:  f߷   $ff$
Њf3۸   tf$ft$
ff          <   f߷   $ff$
Њf f   tf$ft$
ff   y$ffy$
f"ظ   y$ffy$
Њ                       <t?<tG<tIf߸   $ff$
а fG"  
 ff`и   $ff$
Њ2ffu   fffËظ   `ff   ffǋfËظ   dff   tf$ft$
ff   ff   ff&3fb ffAf ffuRffI   $ff$
؊fA   f$f$
fffGfGfFfu  .      ȴ      2ff Ȁ2fOf   $ff$
ffGf   $ff$
ЊfufGf   $ff$
ЊffGf32Ҷ
uf
 		uf utt
ffffAfff2ff#   t$fft$
ffظ   tf$ft$
fffFf   e$ffe$
ظ   f$fff$
Њ   g$ffg$
Њ   x$ffx$
ff܊
؀f} f}f}   xf$fx$
ff   Pfff܊ff?f f tfˀ    Pff   $ff$
$f tظ   $ff$
Њf4P%f @f@f@f@D f @t9t<u0f@f@D f @tt<u	f@ɀ u   3         P   +ȁ  X`   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_va.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  >>>>>>    >>G戰 䈽^ sRpqذp䄰 q
t23
r 2.$@ @ ؾg ,  a$apzffv ff怽kf.f. f"f  
1u3g=r  4t3gr   ۰ 4怎  `  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
It                         !          !          !          !                       p                                             F                 D  @        P      F      p  p      D           p      D          p      D  8         t      E         x      D  P              D                F  L            F  >              F  ,            F  >              F  >             E  @  <          F     `  8     F      L8     D  M         L8     D           L8     D          `8     F    d8     D           h8     D          t8     D     x     t8     D     x     8     D           8     D          8     D            8     D           8     F      ? ?   8     D          8     D           8     D           8     D          8     D  %                    !      9     F        9     D          9     D           @9     F        :     E           @;     F   P  >   ;     F   @     ;     D          ;     D          H;     F        ;     D          \;     F           `;     F     `      d;     F          |;     F        x;     F        X;     F          D4P        D6P     ?   D7P        EP        EP        EP        EP        E P      r  F(P      F,P        U         &                  '                    "                    #                    $                                         `                    a                    p                    t                                                                                                     0                                        `                    a          x          p                    t                                         0                    t                                        `                    a                    p                                        0                                        `                    a                    p                                                   N          0                                        p                                         0                                         p                    r                    0                                        `                     a          b          0                              	          `                     a                    0                                                  @     D           @     E            @     E   `        <@     D           @@     E     8    P@     E  B        P@     E     
   pqpqĊpqpqĊpqfĊpqĊpqffÎf ; @$f@$
и Pf ; $f$
и @f ; $f$
аf ; $f$
а P% = Af  ~$f~$
а pqU&' 	a` 0ᰪf   W$fW$
$f   W$fW$
Њf 8 $f$
а U0 W P4ffCf   fff%f   Pffff   `fff;f   dfffYf   hfffwf   lffff   tfffEf   W$fW$
ЊýNf   xffff   ʺ$f$
Ћf   $f$
Њ02ᰪf 8 $f$
а%@ 3f 8 d$fd$
аf 8 $f$
а3ɺ P  P Pf ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ fm ػ /fff ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ 8>n 戰 f%"f   2f%0 f
   `"	  "	f  2f%0f  2f%0f3f3fP  0fX  0fA0fh  0fAfm  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fn  ff0fA0f  2ff
   0	對㨀M04/08/xx HMZ        J&        1  F!  $  $  ~%  %   %  %  X&  .'  L'    


>  ~
z
                                                                                                                                                                                                                                                                                                                                                                                                                              U (VWvv4RPI0_^]U (VW_^]ÐU (VW.% =  u . =F_^]U (VW.% =  u .   .% =  uF20  _^]U E(VWNa_^]U -(VWv \>0 u_^]PQRSTUVW pq$@t$.>2 u .2>2 t 0   _^][[ZYXU 'VWF   FF% 9Fr
  P@  _^]U k'VWG
 Pp P@q P@''% % 
 Pq P@ Pp P@q P@F Pp P@q P~@((% 
@ Pq Pu@p PF   RPp PF P:@**% % P P1@F_^]ÐU &VWF
 Pp P@'% Pq P? Pp P?q P?F Pp P?(% Pq P?66p PTF*% P P?UF_^]ÐU %VWxPm?%PxPm?xPU?%PxPU?xP=?%PxP=?9RP2 PhxP?
 PxP?  % = | xP>
 PxP>
 PxP>
 PxP>
 PF  H xP>%PxP>% PxPj>
 PxPj> PF~}xP;>%PxP;>x Ps_^]ÐU $VW,BFVFVB9V} ~ 9Fw _^]ÐU W$VW  RP  RPvvVERP#FFVFVRP_^]ÐU $VWF% P P=F% P Pz= Pb=  _^]U #VWF% P PK=F% P P:=F% P P)=_^]U #VWF  + F% P_% =  t  
 PF~Z}   _^]U =#VWF% = u F% = t1 F% P}% =  u F% PF% P    _^]ÐU "VW P P P* P Pn P P% F Pt%  NF P P,F  _^]ÐU Y"VW P P P F% % P PMF% % P P9 P P P P_^]U !VW 
 Py   RPm_^]U !VW%PM   RPA_^]U !VW( nFFn=  u    RP
    _^]U O!VWFPT _^]U 1!VWF O^RPF^N؎&w&7>RP?FV=  t  uP FF;F|' F^N؎&w&7vv
7 aRP PBtRPF^N؎&w&7f>RP>FV=  t  uP FF;F|' F^N؎&w&7vv17 wRP P%RPF^N؎&w&7=RP=FV=  t  u
 ^& RPF^N؎&w&7=RP=FV=  t  u h RP&  PRPF^N؎&w&7,=RPH=FV=  t  u h RP{&  PF RPd&h RPW& PFF9F}_^]ÐU VWRPF% P P P P P P>% =  t RP  F    P% =  u 
 F~s P% r RPJ P^&  r RP' _ RP L RP 9 3RP & # =  u= u= u= u_^]ÐU VWRRPF
% P PF% P PwFn% =  u P P% =  t iRPI  F    Pk% =  u 
 F~s P% v yRP P^FF&r RP h RP U RP B RP / # =  u= u= u= u    _^]ÐU #VWRPEF% P P* P PF% P P P P% =  t 'RP  F    P% =  u 
 F~s Ph% b 7RP  r NRP _ gRPy L RPf 9 RPS & # =  u= u= u= u_^]U VWRP	F
% P PF% P PFn% =  u	^FF&% P P P P8% =  t RP  F    P% =  u 
 F~s P
% _ RPDr RP4 h "RP! U 5RP B SRP / # =  u= u= u= u    _^]ÐU VWrRPF  a F% Pvv=  u  \ ^&% =< t ~RPa9 RPORPBF~sRP(   _^]U VW PxP^2F    P>2F~2s PxP12  _^]ÐU VW_^]ÐU VW_^]ÐU oVW{_^]ÐU WVW_^]U CVWRPeF  >  P P=  u .  PFRPw% =  u  F~sRP	   _^]ÐU VWF  ;   P  P=  t!   PFRP% =  u  F~s   _^]U aVWFF F FRPs   RP  P P=  u  w   PFRP}% =  t  V    RP  P PFRP=  u  &   PFRP,% =  t     _^]U VWFF F F0RP  P P==  u  s   PFRP% =  t  R   P PFRP6=  u  0  Pw  PFRPp% =  t     _^]U VWKRP  P P=  u  g   PFRP% =  t  F FVFV  P Pvv  PFRP% =  u     _^]U 7VWeRPYF  FF% = |@ RP3  P0 P  PFRPX% =  t  F% = t   F  FF% = |  P  Pp Pb  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% % =  t     Q   _^]ÐU VWRP  P  P  PFRP8% =  t   F  FF% = |  P  Pp PY  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% %	 =  t     Q   _^]UL VWF  F  FȌRPRPF  F   P@ P  PFRP% =  t    P  PS  P  PE  P  P7  P P)FVFVF F  & F^N؎&% = u F
 F~wF% =  u~ u/   PD P  PFRPG% =  t  9  P Pvv  PFRP% =  t  F     Pp PN  PFRP% =  t     PFƌRP  PFRP% =  t   F% %@ =  t F% % =  u  t  
 F~se~t  S FFFȌRPFRPFRPv!vFȌRPRP
F9Fs  K  _^]ÐUJ yVWF  F  FʌRPk
RPF  F    P P  PFRP% =  t  lFVFƉVUF     P^ƎFȃF&% PF~ s  PFRP>% =  t  F      RPF  Pp Pl  PFRP% =  t     PFRP  PFRP% =  t   F% %  =  t 
 F~sp~t  e F% % =  u  O FFʌRPFRPFRPvF	vFʌRPRP5
F9Fs    _^]U VWRPF  >  P PQ=  u .  PFRP% =  u  F~s   _^]U -VW4RPOF  >  P P=  u .  PFRPa% =  u  F~s   _^]UL 
VWFF F F FF  F  FʌRPTRPF  F  P PFRPu PFRP% =  t  FVFƉVyF  1  P P PFRP% =  u 
 F~s~t  1F  #  P Pvv?=  t 
 F~s~t    P NƋVRQvv
+
 FFF;Fs  FʌRPFRPFRPvvFʌRPiRP
 P P PFRP% =  t  U  P Pvvk=  u    P NƋVRQvvQ*
GF9Fs    _^]ÐU VW% =  t RP N vv% =  t RPh % % =  t RPH    _^]ÐU* !VWF RP? P P=  u FRPA F RP PFRP7 P P PFRPRP PxP$F% =  t  +% =  t VRPl RP~ PxP# PRPF  FF% = |7 RP30% =  u   RPF% = t O 6U% =  t RP,  % =  t &RP	  F֌RP% =  t IRPd  F F% = t F @uRP-% =  tO  Pz% =  t4 % =  t& % =  t gRP߃ A 
  P+vv% =  t .RP߃    _^]U
 }VWF  F  F  F  + v
vP Pvv%  FVnF~ tv
vv Pvv
  FV~  t ~ t     _^]ÐU VWF  F   PRPFRPRK  
F  F  + v
vP Pvv  FVnF~ tv
vv Pvv  FVFE F^N؎&N^يFN;u RP!ރ  F~w    _^]ÐU VWF  RPD P1F   F^N
؎&FF= sv
v% =  t RP݃ v F  = F^N؎&% N^v
َ&F% N;u FFF= s~ u v'	RP}
     _^]ÐU VWF  FF=2 | F^N؎& F^N؎& H	RP
  _^]ÐU VW F+ t@ ^&?dr4 ^&^& + t ^
&&^N؎&  _^]U츮 )VW6D 6B J	RPj	RPvF  ZƆX ǆV   V
&Ƈ VV sXRPFRPZRPvvvrF=  u 	RPFRPRT=  t  t 	RPnۃ P RP% =  t 	RP>ۃ PTR RP% =  t 	RPۃ PTR>Z=  u 	RPZRPFV=  t  t 	RPڃ P=vv RP% =  t 
RPsڃ P RP'% =  t (
RPCڃ PX% =  u8   RP RP% =  t H
RPك Pvv6`
RP:
    _^] 0!<s3P˿6 + r ׁsh3P1L!6
6
ƱH6l
n
66gP6g
P6g6g6&h
6 +۴J!6
 +3
O3X 6
6
6
6
6
P.L'ظ j
(P.L'ۚ^,  y>
uXP
 Pj
 5!

 %'!
)
&6, 

3
sx

 

&, >3&= t4
 
t3u!
,Ar
,Ar
ª 
 D!r
t
@Ky

 

 

 U3U UVW UVW.
Q
u't z 

b >
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>
 t
 P]ø Y+r
;
rQ3 V3B 22Ut
 Pt ^Ï

 <t)
&, 
3 3uGG>
ыѿ  
< t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ

6?6W6

u6
 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &
U
&, ÌF333t&>   tFu@$F	  RP 

Vϋ3_I36;
uQVW
 _^Yt^?G^
u͎^O]UVWV;t@t3_^] UWvt 3I >
u
@!_] SQ \
QP>![\
Yt[Ë r3]sP X2]s ]2 â

u">
r<"s< r<v
ט
Ê  UWVFG
@tG
  D
u VށFVD*P|]~ tZ
PNQKFFV~\t PFPN
 Pvvv)FP!tD
 ^_]U
Vu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S
Y[X+)D `;Nr/3ҋv+SQPS3DP.Y[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DPY[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU

t>]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %
炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt4u%
@t ~QWS EL
 cSV [D
tҋT+BUJT$QQttSY|V&;u3F3
 t QPPS7	3_^]UVvD
t$t ttd
3DDDD^] UVv PYށtL
G L
G ڍGTTDD  ^] UWVX
FF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvvG
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	4uVD
uFuAWt!DTTD E L
 S P[[tW3_^]UVWvt,3ۊ\
@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GP
= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*PD;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] w66666 7)7[7UVW3FFv&vF
t~ }F, <Xw$ FF.6V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuM
S
WN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
h
F
^
FFt~ u	Wd
guF u	Wb
&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]U^;
r 	>!rƇ
 U^;
r 	1>Z
 tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!r
& U2>
r~
FF
U2~FF  u @uW
uFV$
Ǵ=!su	 t % = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;
r
>! 
N
Ë]2ܡ
#3ɨuU^;
r 	s3N
l
ue>
u
N
V?!s	G
t@
VW^'
<
u&
:t<u&
G+_^t<
t
@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B&\
=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ
+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U~3uI] UWV~vߋN
t2Ì^_]UWVN'~3ˋvD3&:EwtIIы^_]   UWVv33۬< t<	tP<-t<+u<9w,0rҋˋ؃ X<-u؃ ^_]UVWN
F3҃
u~uUV

FVtpFFthvv^&G&tN&w&7;v7^&&8=u+Vvv^&w&7
u^&&W@
F3^]UF+F
F +F ]  WV@3VM@tG96s^_UWVv|96

	 4
&
=}3#
tVt
>

	 ^_]ÐUV2] UVF ]U"V < RP6
6
^&GFPFP~ u~ uFPfF-ȉFP FF*ЉFF^*^wv
Vu	~BVF*FF^&GF*PFPFPvvvR^&&W>
 tFPjt^&G 	^&G  ^]Ã> u ÐUV3
PFVu^&? u PS6
6
~
F^&?-uFGFRPvRP

^&?+t&?0|&?9F&?:ud< RPFvRP

	&?9F^&?0}&?:u*FvL

&?9F^&?0}t


 
^&
t PS6
6
	
& ^]ÐUV^&
C} &} &	~ &~&	|z&w
V~&u&_ۋ
 &_ۋ
F uF RPmDLF-
  RP+F^&u&;G|	u&| &9G|u&|3^]UWVv^ۋ
 u~~G< RPRP RPƹmȋFڙFVDFVڋǙځD SQȋF
ڙSQȋFڙSQȋFڙ

N^FǉFDPFFHFF
F>
 tFPbt	n^ FV^_]U
  FPRPFV+

RPLȋF+
ڙӉFV]ø
PU^,a<sAC
uڎ]UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VW1NxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! UF5!Ë]UFV%!3] U*!^OwG3] U,!^/OwW3] UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USW3F}GVڃ FVF
}Vڃ F
VuNF3F3OyCH؋NVFuf
fr;Vwr;Fv+FV
+FVOy؃ _[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UNWVHv
~H+#+#@+u uǌ 뾋FV^_]U^;
r 	W>
u
 tB3ɋ!r
tz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^
@t^^?u F+Ff^_^JߋN
u>V@!s	u
@t&?u Y
;s+3UVv&L^]UVWNwi
tH0N6

VW_^s+_;uX6
&t
;u>t>^0Nt

r 

39
tv
tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;
v;
v
3&EGUVA!	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MS Run-Time Library - Copyright (c) 1992, Microsoft Corp    Unknown command line parameter!
  Usage:
	TFLASH [/S outfile] [/U infile [/V]] [/?|/H]
Where:
	/S to save image into outfile
	/U to update flash using infile
	/V to verify the flash update
	/H or /? to show this help message             
%s Activating micro flash interface...
 /U Missing file name! /S Missing file name! /V /H /? Read a byte from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Read block from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write a byte to IIC... Mailbox0 locked Success writing to IIC Timed out writing to IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write block to IIC... Mailbox0 locked Success writing to IIC Timed out reading from IIC Security violation Mailbox command not supported Unknown error code in Mailbox5 Read ACK... Ack received Did not get ACK
 Trying to read ACK again... Timout... Ack NOT received Send Flash Write Enable Command... Timed out, or IIC access failed Send Frequency Command... Send Erase Time Command... Send Signature Command... Send Blank Check Command... Sending blank check command... Send Erase Command... Send Write Command... 
Writing...  [%s] %u%% Send Verify Command... 
Verifying...  [%s] %u%% Send Enter Flash Mode Command... Send Exit Flash Mode Command... Send Read Command... 
Reading...  [%s] %u%% Failed to enter flash update mode! Failed to read flash! Failed to exit flash update mode! Start Programming... SkipWriteEnable = TRUE SkipWriteEnable = FALSE Sending 0xF0 to the parallel port (pwr OFF, reset LOW) Failed to send Flash Write Enable command! Sending 0xFA to the parallel port (pwr ON, reset HIGH) 
Activating Flash Mode... Activate Flash Mode Failed to send Reset command! Failed to send Frequency command! Failed to send Erase Time command! Failed to verify Silicon Signature command! 
Erasing... (This may take a few moments) Failed to erase flash! Failed to write to flash! Tempest This is an invalid file 
Verifying...  Failed to read flash device for verify! There were %u miscompared bytes! 
 
TFlash utility, Version %u.%u
 Copyright 1999 Compaq Computer Corporation

 w+b Failed to create output file! Failed to read flash device! Failed to write to disk! r+b Failed to open input file! Failed to read input file Failed to program flash device! Failed to verify flash! 
Done!
   (                           _C_FILE_INFO=                                                         
                
	
\ \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    EEE50 P      0PX 000WP         ``````  ppxxxx        (null)           ) ) ) ) ) ) )      ; Z x     0Nm : Y w     /MlTZ  p   PST PDT 

                               '''                  F0<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
 NNB09Ho      CV   N     dos\unlink.asm     CV   N  D   
newseg.asm     CV   0N  |   searchsg.asm       CV   M  6   linkseg.asm    CV   M  4   initseg.asm     CV	fdata.asm      CV   M     fmalloc.asm    CV   M     stackava.asm       CV   K  \  	write.asm      CV   RK  ^   hmemcpy.asm    CV   J  _   	uldiv.asm      CV   RJ     lrem.asm       CV    J  2   lmul.asm       CV   I     ldiv.asm       CV   jI     dos\gettime.asm    CV   NI     dos\getdate.asm    CV   LI     dos\enable.asm     CV   JI     dos\disable.asm    CV   4I     dos\d_setvec.asm       CV   "I     dos\d_getvec.asm       CV   I  
   dos\d_commit.asm       CV   H  c   xtoa.asm       CV   RH  ^   hmemcpy.asm    CV   G     hmemcpy.asm    CV   G  k   
strstr.asm     CV   F  $   
strupr.asm     CV   F  V   clock.c     CV_cinittm.asm       CV   E     
dtoxtime.c      CV	timeset.c      CV   C    tzset.c    CV   B    dos\ftime.c     CVdays.c     CV   B     dos\outp.asm       CV   B  
   dos\inp.asm    CV   (B  X   commit.c       CV   B  $   
closeall.c      CVdos\diffhlp.asm    CV   A  +   
dos\hdiff.asm      CV   HA     getenv.c        CVcmiscdat.asm       CV   ,A     itoa.asm       CV   @  V   atox.asm       CV   @     atol.asm       CV   @  ;   strncmp.asm    CV   l@  *   strncpy.asm    CV   R@     
strlen.asm     CV   @  <   
strcpy.asm     CV   ?  T   
strcat.asm     CV   >     growseg.asm     CVfree.asm        CV
malloc.asm      CVseekfast.asm        CVncommode.asm        CVtxtmode.asm    CV   =     dos\read.asm       CV   ;    dos\open.asm       CV   v;     
dos\lseek.asm      CV   V;      
dos\close.asm      CV   ;  N   stream.c       CV   6    
output.asm     CV   4  D  fflush.c       CV   4     _sftbuf.asm    CV   2  :  _open.c    CV   2  I   _getbuf.asm    CV   L2  5   _freebuf.asm       CV   d1     _flsbuf.asm    CV   0     _filbuf.asm     CV_file.c    CV   0     _cflush.asm    CV   t0  B   printf.c       CV   .    
fwrite.asm     CV   n-  p  	fread.asm      CV   $-  J   fopen.c    CV   `,     fclose.c       CV   ^,     farstub.asm    CV   ,  U   dos\dosret.asm     CV   +  #   dos\stdalloc.asm       CV   +  `   dos\nmsghdr.asm    CV   *     dos\stdenvp.asm    CV   @)    dos\stdargv.asm    CV   )  "   
chksum.asm     CV   )     
chkstk.asm     CV    )     
crt0fp.asm     CV   (      dos\crt0msg.asm    CV   N'              dos\crt0dat.asm    CV   J&    dos\crt0.asm        CVoldnames.asm       CV      9&  
tflash.obj    
  $       	     
tflash.obj *     `   d   $      PromptError      pErrMsg   &              4   DebugMsg     pDbgMsg   .           .  ( F  	 GetDosTimeSlice     "         D  > t   alarm    s TimeoutValue     &     \  `        IoDelay      s io_cycle   
 	   l1  &         *  $    MsDelay      s TimeoutValue     *         X  K   
IntervalTimer  	?  send_eoi    "     (  ,  @  : R  Wait       delay  
  s i    *     h  l      	 EnableRtcTimer    temp     .            j 	 DisableRtcTimer       temp     .         k e 	 ActivateFlashMode 
  r i    "     4  8  ;  5 j  Sleep     wait      goal     "     l  p  C  =   Delay    " wait     "         @  :   SmcGet     index    "         D  > *  SmcPut     index       value    &     4  8  R  L n  SmcWait        mbox   
  r i    "     |    c  ]   SmcCmd     index       value    *           y $  GetSmmFlags     s iFlags   *          r  l   SetSmmFlags      s iFlags   &     (  ,  ,  &  	 LockIIC     &     T  X  ,  & B 	 	UnlockIIC   &         @  : n  	SoftDelay    s Seconds  "              Exit     s uCode    &         s m  GetParam     r argc      argv     
 p
InfileName    pOutfileName    
VerifyFlag     temp2      temp1    pStrTemp
  r i    &         ; 5@
  ReadByte      value       Address
  s i    &     L  P  ] W|  	ReadBlock     Buffer      Count    
   Address
  s i    &         < 6   	WriteByte      value       Address
  s i    &         a [  
WriteBlock    Buffer      Count    
   Address
  s i    "     `  d     x ! Ack       Status      Address
  s i    &         O  I  	 	SoftReset 
  s i    &            j 	 
TurnOffVpp  &            | 	 	TurnOnVpp   2     (	  ,	      	 TurnOffProgrammingMode  2     `	  d	      	 TurnOnProgrammingMode   2     	  	    y  " SendWriteEnableCommand    Status 
  s i    .     
  
  b  \ : " SendRESETCommand      Status 
  s i    2     \
  `
      " SendFREQUENCYCommand    #Freq       Status   2     
  
     j " SendERASETIMECommand      Status   #ETime    2     $  (     & % SendSIGNATURECommand      SignatureBuffer   buff       Status   2         E ? " SendBLANKCHKCommand       Status     BlankStatus
    i    .           " SendERASECommand      EraseStatus    Status 
    i    .     
  
  o i % SendWRITECommand      BinaryImage    ProgramFlag  &ProgressBar    WriteStatus   ImagePtr     s CurrBlockCount     Status 
  s k    s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .        $    % SendVERIFYCommand     BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status 
  s k      VerifyStatus     s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .     p  t  r  l ^ " SendENTERCommand      Status 
  s i    .         r  l  " SendEXITCommand       Status 
  s i    .          B % SendREADCommand       BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status   s PercentComplete  '	ReadParam  
  s i    s 
ProgressCount    s 
MaxBlockCount    &            y \ % 	ReadFlash     BinaryImage  *           % ProgramFlash      BinaryImage    Status     SkipWriteEnable  s 	FlashSize  
    i    (SignatureBuffer  .     0  4       + CopyBufferToDisk     pbuff      )fptr     s 	LastBlock    s 
FullBlocks   " Total    .            ! + CopyDiskToBuffer     pbuff      )fptr     s 	LastBlock    s 
FullBlocks 
  s i    ,
TempestString    " Total    *     T  X     " . VerifyFlash       Wrotebuffer    
ReadBuffer   s errors 
  r i    .         _  Y # / InitProgressBar       ProgressBar
  p i    2     <  @  f  ` n# 1 IncrementProgressBar     s CurrBlockCount    sPercentComplete  
 s
ProgressCount      ProgressBar  "           u o# 3 main     r argc      argv     )Infile   4OutfileName  Z4
InfileName   X  
VerifyFlag 
  Vs i    R)Outfile      ( 	8.00c              H&        0      H&  tflash.c          .   4   ?   F   Q   _   d   n   t                                                                           *  /  9  ?  A  C  E  R  ]  |                            -  ?  L  `  c  j  u  x                      	    $  <  T  a  k                    '  1  >  V  `  c  j  u                      $  *  5  F  W  h  n  y                          $  /  =  G  U  _                          !  .  <  B  M  Z  h  n  y                      "  1  U  X  e  o  r            	  	  H	  O	  R	  	  	  	  	  	  
  
   
  *
  9
  @
  K
  X
  i
  w
  
  
  
  
  
  
  
  
        #  )  6  <  I  O  u  |                      1  >  U  X  e  k  x  ~                      
  
  "
  ;
  H
  N
  V
  n
  
  
  
  
  
  
  
  
  
  
  
      !  .  ?  P  b  }                    	      )  /  <  B  h  k  q  x                              %  3  ;  R  `  c  j  u  |                              !  .  3  :  E  M  c                        >  _  d  j  u                   &  1  >  Y  z                      1  4  7  J  c  m  {                           $  2  S  l  v                    	        $  )  6  C  H  M  [  |                            #  D  X  y                	        *  .  2  P  g  u  x  }                            ,  M  U  c  q              	  
  +  B  P  S  X  ^  i  v  ~                  	  *  7  <  B  M  a  f  k  x                    	    $  ,  H  K  f                       <  ?  M  P  U  \  g  u                                  "  &  3  D  R  c  p  ~                              (  +  .  <  ?  D  R  _  b  g  u                                       $   '   4   9   <   F   ]   `   m   r   u   z                                    !  !  !  !  '!  1!  K!  P!  U!  X!  {!  !  !  !  !  !  !  !  !  
"  "  "  !"  &"  3"  6"  @"  H"  h"  "  "  "  "  "  "  "  "  "  #  #  #  #  E#  W#  d#  g#  n#  y#  #  #  #  #  #  #  #  #  #  $  $  $  $  7$  ]$  `$  l$  $  $  $  $  $  $   %  
%  %  %%  2%  ]%  j%  t%  %  %  %  %  %  %  %  
&  &  !&  -&  0&  =&  C&           
 !",./02<=ABCDOSTUVWadefglmnq
&'()789:;HIJKLZ^`abcdstuwxz{
 #%&)*+,-9<>?@BCFGIKLMOPRSUVXYZ\ilnoprtuxy{}~,012345?AKMWYZ[efguyz|}~

 "$%&'()+-./23689:;=?@NSUVY]^_bcfhijkmop~ 	
 "$&49:<=>?@NRSUVWXYgloqsuwx|} 	

 "%'(-/015789=?@AEFGIKNPQRTUWXY]^bdefstu	
 "#&')+-/12578;=>ADFHILNORTUXY[\_bcef
      $	   j   _Sleep    "5   __flush   4   _fflush   
   __fheap   p
   __oserr   T-   _fopen    v;   __lseek   <   __open    HA   _getenv   M   __stackavail "    _TurnOnProgrammingMode        
_TimeoutCount     _IntervalTimer    j   _DisableRtcTimer   ,   _dcnt R   _Wait    _Exit   %   _edata      -   __end (   _exit 
   __intno   @   __catox   B   __outp    H   __cxtoa    	   
___aDBexit    0   
__endstdio    RK   	__fmemcpy 
   
__amblksiz    #'   __amsg_exit   +   __NMSG_WRITE  B   
_UnlockIIC    $   _GetSmmFlags     _SetSmmFlags  l
   
__daylight       _SmcGet   
   
__lseekchk    B    __anullsize   l
   __osversion   I   __dos_commit  j
   __osver   F
   	__acfinfo 
   	__environ ,
   __sigintoff   p
   
__doserrno    &   _SendSIGNATURECommand    _Delay      %   __edata   n-   _fread    =   __read       _WriteBlock   *,   
__maperror      	   ___aDBswpflg   	   ___aDBswpchk       ___qczrinit      _ActivateFlashMode    h
   
__timezone    ,
   __nheap_desc  *   _SmcPut   x   _Ack    -   _end  ;   __sopen   B   __inp  ,   _Key  h
   __psp 5   
__flushall     J   	__aNulmul    _SendFREQUENCYCommand F   
__inittime       _SmcCmd   X
   __fac F   _clock    RH   _memcpy   ?   _strcat   @   _strcpy   C   __tzset   G   _strstr   "I   
__dos_getvect 4I   
__dos_setvect 2   
__openfile    E   
__dostotime_t    	_GetParam t    _alarm    
   ___argc   
   ___argv   
   __iob    __iob2    NI   
__dos_getdate M   __ffree   4   __ftbuf   4   __stbuf   jI   
__dos_gettime |   
_ReadBlock    \   
_ReadFlash         __EmDataSeg   
   __pnhFarHeap  *
   __sigintseg   +   	__myalloc 0N   __searchseg   1M   	__fmalloc ^,   	__farstub    	__lastiob "   _VerifyFlash  ?   
__findlast        	_rtc_regB (
   __aexit_rtn      _SendVERIFYCommand    !   _CopyDiskToBuffer k
   	__osmajor j
   	__osminor =   __cXENIXtoDOSmode    _SendERASECommand     _MsFlag   @   _atol R@   _strlen   *   	__setenvp     _PieTick  2   __getbuf  (   __FF_MSGBANNER    ~
   __citime   6   __output   )   __fptrap  J&   __astart  N   __newseg  n   _SmcWait  &    _HelpMsg     _SendEXITCommand  f
   __pspadr  d
   
__umaskval    F   __strupr  d1   __flsbuf  ,   	__dosret0 B   __fcloseall    ,   
_dummyread    B   _SendREADCommand  
   
__exitflag    C   ___tzset  `,   _fclose   V;   __close   
   __fmode   N   _remove   ,A   __itoa    n   
_SoftDelay    @
   __aseghi  B
   __aseglo  0(   __c_exit      _IoDelay      _MsDelay  0
   __lpdays      _Timeout      _PieFlag  t
   __osfile  LI   __enable  ,   
__dosretax    Q?   __incseg  
   __cflush  n
   __osmode   J   __aNlmul  RJ   __aNlrem  N   __unlink  I   __aNldiv  0   __filbuf  
   __ovlvec  
   __pgmptr  G   _memmove  (B   __commit  
   __iomode  &
   __atopsp  $-   __fsopen      	_rtc_regA |   
_TurnOnVpp    l@   _strncpy  @   _strncmp  v
   __tzname   
   __fpinit  *
   __asizds  .
   __asizeC  /
   __asizeD      __AHINCR  #   _main N'   __cinit   t0   _printf   b
   _errno       _LockIIC  )   __chkstk  @)   	__setargv j   _SendERASETIMECommand J   	__aNuldiv    
__aDBdoswp    
   	__adbgmsg 
   	__ovlflag                  _PromptError  F    _GetDosTimeSlice  >   	__growseg     	_ErrorMsg M   	__linkseg M   	__initseg 
   __child   r
   __nfile   J
   __days    (   __exit    
   __aaltstkovr  .   _fwrite   B   __ftime   K   __write   n#   _IncrementProgressBar      _ReadBuffer   L'   	__dataseg L2   	__freebuf 4    	_DebugMsg     _FileBuffer   A   
__aNahdiff    v   	__acrtmsg     
_pic2_mask        _CopyBufferToDisk"    _SendWriteEnableCommand   '   	__cintDIV T
   	__aintdiv     	_pie_flag j   _TurnOffVpp   &(   __cexit   
   _STKHQQ   (   
__ctermsub       _EnableRtcTimer   @
   	_ReadByte    _SendBLANKCHKCommand   	   ___aDBrterr      
_WriteByte       _SendWRITECommand     
_FlashMode        	__AHSHIFT )   __nullcheck   ^   _SendENTERCommand 
   	__commode     
_MINOR_VER   "    _TurnOffProgrammingMode        
_MAJOR_VER    :   _SendRESETCommand ;   __getstream      
_SoftReset    o
   	__cpumode H   
__cltoasub      ,   _BiosRtcHandler   v   
__acrtused    
   
__cfltcvt_tab +   __NMSG_TEXT   ,   __dosreturn   )   
__aNchkstk    JI   	__disable D
   	__fDosExt D   	__isindst    
_ProgramFlash #   _InitProgressBar         P         X      @  h    (  @      P      H      H        X    
   	   
                           
   
      	         	   	      
               	      `"$  kB    PcP|
  6J	
  VJt  f  j  u  KqP   f  Cx  E$
  t
  %   [jDT  kW,  k%  , `    pT   ^%p    rE  4  V_  vp     Z{  z;R   |   fL   /[/d       f  HR@
  zJB  +ը  !D=
  {#  .wd  ?R{<  }{x  ?CP  r`  ҄  aU\   !	  u"  !
  j  0h  '%  
u  `  
k  >$$  {u(   07  U<  ns>BH  DE)h  UD  O  KX  Z
  zk
=
    !    Z]ՠ  }  xo_  ǲL-\  fwl	  Z  Lc  Ϋ  <Q  
x  F3  e`  e  C   D  F  <P,
  Z

T
  J{`
  ˻|  K   |  y|  ϫ  ǲ,p  6|  uXʸ	  z"
  
ʋ(  '_  Ky  >,   6t  Z}t  `a  T0  
E0  hQ<  Q(/T  Y؛	  m*<	  	  y k@  % 
  )@  {  bH  =Cr  ۫  
"U   zD4a@    2@  	  YD
  X*1   xz#  > x     e3(	  	  0  +(  ;   aLu\  k  !`L  MՔ  (   !@  4p  &R  G  V  zj
   p  \j  f]u     ҟ0T  f  倀   vq  "  5'|  	L  mq8  Mh  u׸<   $Ը  zL8  hұu,  p  v  ~P	   ˰
  [u  H  >)H  z/XNP  yr@`  5H     j
<  1  alu   (  3֐  o
`      $`U  0  
  H|0T  k4  lj  =   0  ?(  M؛	  d
  IJ
  q
Zvl  Yh  kPH  <f(    q`  }]  		wP  ?
$  6C44|  *{`  FsҜ  xf  *g  [^D  
8
  L
  {
  |%  M  f_Ntd  }  zh  2  7˛  [
  Żt  M{L  Kz$  {  2_	   Z74  ^60  ;  vcp  0  8ݱ  	^  D
    
h  {&  g]P  !  "h  d(
  ;
{    |[  =W~  #P  T  ֋4  v|  `  8 h
  1j
:X  ]  ݻke   U-                    H  P  p  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x                                      H                                                                                                                                                             4     F     t   X     l          P  R      $  j          j            *  |
  n        $      @      B    n  `          @
    |  4    0      x  d    t  j  <  |               0  :      |  j    &      l	    L          ^  
    X  B    \  x         	  !    "    #  (  n#    #  T
  J&  8  '  P  #'  `  L'    N'    (    (    &(  D  0(    (  	  (  @
   )  $  )  T  )    )  h  @)  	  *    +  h  +  (  +    ,    ,    ,  H  *,  h  ^,    `,    $-  d   T-    n-    .    t0    0  
  0     d1  t  L2  	  2    2    4  p  4  (   4     "5  p  5  ,
   6  L  ;    V;  x   v;  ,  ;     <  P	  =    =  4  >    Q?    ?     ?  4  @  	  R@  T  l@  h  @  	  @    @    ,A     HA    A  (  B  
  (B  @  B    B     B    C  H  C  d  D    E    F    F  
  F  \  G  
  G    RH    H    H  <  I  p  "I    4I  <  JI    LI  D  NI    jI  t
  I     J  8
   J  L
  RJ    J  $  RK    K     M  \  M  T  1M  p  M  \  M  <  0N  h
  N  `
  N    N        H             B              H     
  &   (          `          h          	     	                   &
    (
    *
    ,
    @
  0  B
  P  D
  h  F
  L  T
    X
  ,  b
  
  d
  
  f
  `  h
  <	  j
  T  j
  (	  k
  $  l
  $
  n
  |  o
  P   p
    p
    r
    t
    
    
  |  
  
  
    
    
    
  
  
  t  
    
    
    
  
  
     
  0    |    
  
    
    
    
  8  
    
    *
    ,
    .
    /
    0
    J
    h
    l
  |  v
  
  ~
    
  <   
        `      x                          p            P     @     @                 
           0ݽ  Y     !q7d   Y     4`tp  Y     5`  Y      6ErrorMsg    z	  Y     `  Y     1W  Y     `a6  Y     @[  Y     _iobuf      ACK  Y     ]fQ  Y     "  Y     &üX  Y     pR{d  Y     {,  Y     fÀ  Y     `
  Y     BP=  Y     -s  Y     4ӊ5  Y     DcP  Y       8
ReadBuffer     
_fonexit_t     $ė=t  Y     5}   Y        pie_flag   ,   dcnt   UD  Y   
  FILE   @  Y     4TT  Y     uD  Y        MsFlag     ,  	dummyread  6P  Y     @K
  Y     `   Y      , 9BiosRtcHandler     V
$  Y     f  Y     &p   Y     HGH9$   Y      8
FileBuffer     ! wchar_t       rtc_regB      rtc_regA      	FlashMode  4p48  Y     
  Y     x
`  Y        PieFlag    $   Y     Df,  Y    &  7HelpMsg    s size_t      s Timeout     time_t      5	MINOR_VER    5	MAJOR_VER    Y     ,   Key     fpos_t     onexit_t      PieTick    
  Y     d	  Y     ?q˨  Y     pva_list    L  Y     D
8  Y     `ݱu  Y     Ľ}   Y     -4  Y     ~ٶl  Y     ^RX  Y     NB
  Y     !Qu  Y     	_onexit_t  ՞N(  Y        	pic2_mask   clock_t    Z2,	  Y      s TimeoutCount         p         0    X  x           
                    0ݽ    ACK   pR{$  t  `Cr%h  @Kx  `   hs  &p  HGH9,   KEY  `ݱu  ^R@     !q7D  % YX  6  aW~(0  !QuT    z   "ޤ  V
  L  Z2  _%@   kf'd   `t   1W   `a6   @[  {،    ;]1  { g   { W  k,  k$   ~ٶ    4`t   $T  4ӊ5d  DcP  $ė=  dT     4TT0  u"  tg@H  4p4X  
h  x
x  #  Df  4U  Dځ   DʀTp    d\  D
  Ľ}t  4`0   5`   ]fQD  -sް  5}   E4D  UD   uD  $  C<  e[4L   \    -P  ՞N   &ü4  BP=      fô  f4  ׸  ?q   NB`  ]w,                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  6                                                                                                                                                                                    4     F     t   X     h              R         j        j            0   *    n  H      $            B    n      d    x  @
    |  X             x          j  t   |               T   :  p    $  j     &  P         d     h      ^      T  B  0  \  4           !  D  "     #    n#     #  t                      @        &                   `     4     x     \     0                     ,          D                      OLDNAMES.LIB
CLIBCE.lib      :       T   l   t                                                $  0  <  H  T  `  h  x                              $  0  <  H  T  `  l  |                  R p   _ptrr   _cntp  _basep  
 _flagp   _file           _iobuf   
  r         
  r         p
      
         s 
      

          
      
   
        " 
      
       

      
      
       
  s     
  r    
   p  r pp 
      
     
  s    
       
  s    
  s    
       
        
          
       $
     3  
       
           
  p)
       *
  p    
    
       -
      $  s ss 
      0
  r 
  r    2
  p  P     r 
  p  !  
  p              . -               N                      &             . <              E M           - U Z     B      - b h B   
     - m r 
        - w ~ 
        -   
        -   
         -   
         -   
         -   
         -   
        -   
         -   
         -   
        -   
         -   
         -   
         -   
         -   
         - 

         - 
         - 
         - "(
         - -2
         - 7<
         - AF
         - KQ
         - V\
        - bf
        - jn        - rv        - z        -         -          -          -          -          -          -          -   
      -                  _TEXT CODE EMULATOR_TEXT CODE C_ETEXT ENDCODE EMULATOR_DATA FAR_DATA FAR_BSS FAR_BSS NULL BEGDATA _DATA DATA XIQC DATA DBDATA DATA CDATA DATA XIFB DATA XIF DATA XIFE DATA XIB DATA XI DATA XIE DATA XPB DATA XP DATA XPE DATA XCB DATA XC DATA XCE DATA XCFB DATA XCFCRT DATA XCF DATA XCFE DATA XIFCB DATA XIFU DATA XIFL DATA XIFM DATA XIFCE DATA CONST CONST HDR MSG MSG MSG PAD MSG EPAD MSG _BSS BSS XOB BSS XO BSS XOE BSS XOFB BSS XOF BSS XOFE BSS c_common BSS STACK STACK DGROUP    Y                                                                                                                                                                                                                                                                                                                                                                         tflash.c     c                #     ,        L   !     p                                      !    	       
 (        H       h      
                 $       $       #     4  $     X  %       %       %                            0       P       p                                           !       " $  !    # H       $ h      %       &       '   "    (       )       *       + <      , \      - |       .        /       0       1       2        3 <      4 P      5 d      6 |      7       8   !    9   !    :   "    ;   "    < 8      = X      > x      ?        @       A        B   !    C        D 8       E X      F h       G       H       I       J       K 	      L $	       M D	  #    N h	  %    O 	  $    P 	  $    Q 	  $    R 	      S 
      T <
      U \
  $    V 
  0    W 
  !    X 
      Y 
     %Y     'Y   D  *T0  '  )W  d  4Td     (dd     +d    -Th    .k    3m  x  NB09t              buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        