#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for nx 6115/6125 HP Notebook System BIOS (68DTT)  - Linux-Based"
BIOS_VERSION="F.0F"
FILENAME="sp32712.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<FreeDOS    @	             )0ROMPAQ461  FAT12   1ؽ | ^|  ` ؎Ѝf~$uV$F F  FreeDOS v~v v҉~ԊFf׉v։~؋^F1Fƃ vډ~܋F֋V؋~^Z r/~Z }W_&Et &= urYP^Z~FҋVk XrF^\  s=r1^Z  	t$HH~
 FV$ s  err 0^$nZ1۴^V< uVFȉVʌFƉ^ĴAUV$trTu
v^̉^δB,NȋVʊFfvшƆɊF(^ĸV$s0뢋FvFƃFV OuF^KERNEL  SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MM                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MM                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ROMPAQ461            dKD1      KERNEL  SYS  -KD1D1  80 ~  R o m p a  ?q . e x e     OMPAQ  EXE  1LD1D1  ;1[   CONFIG  SYS \LD1D1  71[ 8   GPL2    TXT 1K1    h/-\ G  AR o m p a  ?q . e x e     ROMPAQ  EXE  o44  )t4   8YDU   BIN  
o4o4   n4    8YOP   BIN  Ao4o4  Ln4    68DTT   BIN  cEB44   M4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CONFIG    nused9W䯉 .ls璯 UUPX!
!5Zj  * CONFIG   PS1 [XꐤY A]o1ؠ$.  t.&<u ÿ,. u	t= ru.&..>t$*/.mtG
bAe=6w[&G)ƆPVWUS[]_^XP@ ؀q XSXR-LF,@:,4. ,($"(,,0,4
8,< RPȎء2;4v*҉6&V0)n	XZ [	,.W.VGVPPkvp0B[kb! BH~PQRiS^ct G$:wbƗS. .TYYg
OW,5>+dRoGo	[ZYX^˩vꍱ)J.~7bG۶?CYa+,'QPRU,rlq6+_.Y&rA]ZX^wy["
7xWFH t
/=]^ *&t tF 3h
6ZFkq7}-3c~</
h'_f
 Ӂõìލ. u6 5t/GKum4	ruO0$0<0n_t)[t$
o-<QS1ln%HݻFYt0o؄?;YeP]f>}
7E&}U<et<Eu&
5V\]n-  @PRN# AUXFALPT192s_3G,kM1>A2yP#y3b)4ti~LOCK$[ O
 " bܜ nO0_}	-s'3h s=OiqjbNUL"elX Rbckpro{< "l &/8b 
65S9` DG> ALUC  PCRemove diskettinnriX:
 #ރo!U"yh&QOod[ ov nyfsEK^=<V,N8=F>՚ 6\.&4_?S.[˴Po>&;@u(
,<V\X.>su	7tP Xϰ ErrorthDJ mechanm! Insert Pressby k(to cont5u. m *LBA-Trsf1v eS6:#yl"d> 1023
?PANIC[Sysom kld ^C
ig]awoaneao9fnok@|[qkj0dtsam*iȦ1CHKDSKstrygacc
vcio8clus@Q0x :<|>+=, /"[]<>|.A}MCB +s׼wupbef4aT`afMplwen+n\ofcB> INT2F/12 {+lm@;,$vir_mcb=pv1tMZBaN\mikComm+/agIs(]o E(mlvmsuc+e$\DEV\ 
g(chnpavh yHCngmka03456789abcm%f
+#/=n#w{*3	#^K; YNxۂf%+$0a-E4smEAAEl IOOUUYAIK^KAc."/\A:|<;M;,M	

 !"#$%&'()*+,-./W:;<=>?@ABC/FGHIJKLMNOtSTKXYZ[\]^_`a_{|}~CU C
OO;o$ NN?~!""BSHg! ; Z x   j0Nm< [ y   
1OnF7eDOSZ%$evs}1.35 (Builv20) [Man~30
042:0/:36]]*?O\"ZbVQƉY^ɿf9rӉ1RPމu[痉@)Y!!1_kO(?Un]PFFX]$ve ϱ$<
i/pbsUp3n4v!e by zko}Vz<pk:6%t
F<m1 oFF

L!^xzOpZ;Nr믴 UWVRQSPKi1Pڀ%to3t/5t/Pt
/Qt/bu` UhTM֌.AV_StV"n%!
<~#  	">n M։X[T:W]ϣ:P*XÃ3 1QP.%  slfLӼmcPyWq"UK[[]˞fBf_~v
n/0&60 >r?&kE\)ً&}$.{ݎՋ"J\Z-57~|J .<16f
g<t5váFXd tv^tLN2L&R FZêSGgWiR=7a߉+DqFDi9wu
;~w3^"D2C*V&D&:~rw|
]3'
v,+[5BݠV˶SG3!$0=[M0C"mw_h_09}W:Tu
T,00K@a+mj
BErAh}Gn,䲍ޞyd3߀O3 
Dh}We%.	B[HVD37=nt2
f7{ƞ=*u~4
UJ^ZYQ߳G4ۀg47|3@t3&D+茵BWwOy K[;[g;hWr,YtV'؍PwjPۆ  وÒX^WѮ7vo	
>ƆE=1 eTWWBgÅ/?
[x]L%Hc_lM7#G0<O0Õ{	xW5\RvffL0hP_ 
U['BS7V)R 4S.lP<
UDwTyDkPE%{PW1eA
0Vg
Pc׭
iy
H6wʉo!/ma5]Off&\&\2-~^
|Hu*&_`rvfrvgt~FrvXG=J=g׉^ȍVR\ړnVߤv\oƋOtz^Nz-/gfba`GFo@Ch
5/(p
H#b}luSǱS pF}Y:
mGE(>n}Ot=m2E$	
s3nz&9+DVQW~h4c5
amYA ]	4&M.]6C*2
_e;%gq©seoo
t+YBQ5= f-"=
~ ctf:9PzPVV@̾`5[0 i2x(P	k2AVn_r,<	`mPkRgt#t
~.KR_SyuYF
fFmFBTۿ~^ڊ9;XqvYv7wRl5*b1׊N>^0Zc:~OnsIrf&~r-ulM[O
(z dDoDDk\Dk=^O_SUn|' C ǩcphQ*BGD1ME9x1[	.3 Ca0;z\XR2
5 QLZ:։4ac"`CBXKy='ыngmuBwTkR"nMGƴ{q
$ضsvI4G묩f9/5<rvj7uݘCfLPE4uhX6qwTe>D!Q]:V唁`^^|	N4 +LYs$n5Ll%7V9r
GX;9;^S&{;\?B.[t¦"uCc|	GbRn%0/r	vCt^ZwM @O4_(0:m R
tHX
,	ҶVh09[
+Nv6t|#kE9	=B`>nTر	9s,a
vwuՈ&S^(櫻mS#  {;J1F:GV)ܫ(Qv	QmT9ց s)w(
[!JT,Cu;bWZ#fQ.=+~)𜍓oe}Xm4UOr6  3y
5|RtVPz݃]ÖQq!5mPۑĶVSωX)8/z +kx^м@Q+F8:BͣD4ѷڸ
Oգ^ l,Н$9&=迓'[
NuJ;u!}
u{ݓv{ǣ]GF^
4Da)GQaqѶ?zvRh_ I
EE@m$
qmxd Ǯ]#7
o= 
 X-$Ҥ
6
 ި
tǖ-gspgV1Pk37p)\U(JGV662!d
ƺצ'J$M+(
#}j@YnzVj[r=']ld3Jym# XhORh㹼mx;\A+o]B/
sisCd{F}䶂£:ڹY.EؘcȘpUEX
T=NApB_s+~

]"xs4sPɷ6ݵrk	AlkiWAX4e
vuHk\	ZfhgHMU,85/7M;~⍠d8uڌ:PwkY!u<0<^D
^
^]v#c,@1[CXz@?+	 L-ϋ-Dob&)Vt] #ǆ cNnmnXH )Xt[6Xs
ZQnl/]AX3plj;Yeg*>!wiBfb<Fb0)(B!%1X,~M[ttY=JtT=O=3Jbmt/U!D]P$
f]2[h,F$}g)5ov/+ƅ`[^[T
Z[
`c
6w_
VkB܉ˋ]2r/Oo_ sba;X<im<ѡbǿ^<
t<!t<"tf<#t\Q<t6<<D=[s;VE]McUu}
n~[r6_rcl"B뺒5׊nǴ^'p8!]	[ w~Z[XK!rRwP?n
s!`ýO<GYTV	tZGmw
\74CqS֤od6m Ȁ2RaB/u1tu(KD t!vK'-d9t:sg <*p)*,X:<7uݕ\%$fE
e}j7b,׶OLbie
pcUmmwKu<
Gw3Ou+r%ɚGYGĶ	k~\0DkP,OVL){1i8m$9;c%VtGKST>$Jg	S.(ŉQ%(\pPik|`kv;l^摣7uEe*3->u
@^6Q=U$`<`L[JɍDjJh 	gT
;GE6|mT'2=: uu7
-1\ _3Uv"h5WkBjPehX#	eq׮-tG@_p,M*&(gX V.]avowB^R5sx'E]h
nK%BKw##|A}%	
X!grAF.\1	0Rr+nf>%ZEՁ9r`lZpy Sz | ^wuR5c[P:"&ھ'p6f%
Ak>ZF-xmPe;=_=nt3H|*>vf,Ê\=R
=wP)'Z0ymIA؃qe 
s>9v6&d6k
~9Su7.MnBc-Iu`n[zu?E\[Ц]6
ZZ"^t#u	 
tP8lڔ0R">hjؼ
7Ђt=v\1@QoS٫QG;
g="efЀr45LvR0]Z 
šA8aTѡ204 .׈,n	k]SR.081&]ʐm7?@iGWr	k_,:E3\ݎgp Y
STJũ[@F,v
VLBТ$&ŀm#@$(Ĉf YB&?<w<ZM_K$m!
pN]
!C)O9b^U|uS,8=?$L)m;4sG-ikPj/}hA(ՈNoUF^	"$ñ	f%/
_
׃x=zۈʂ8?&Prq
x\< s=	.=
=
8m^/_G@xr5+R-c>h^e֡ uNt N~G	/CA<KX#4tU4O[yX
K=

y@C-G9>9
V7#
sl\
b?6C~c1u09C9h ^_l E'Ȫ;7%6+R~9S
҄fíxMql1:^Phz {;![BJ> ? @ K M R8]#"!"!!#"_""#
|"Z#'#dBN2N`+[h=[6&CM5P 
?sà~sF5(mg[V% %m='۸

Z6+*;Ss#H[b5.Nm*SC{g}:1y
8%ǼGGWW q)P)@]>t-_xs" u֋stvr@@^JPS0w Fu
C{vPKCm99s 뀽	/r]BKEB@pw]{vN7Wl24C\OS'KsK 
; rK
66	a^2&GrU{.m_
\
>_>"lB
+[2:h9iSMg]|0n~#1k0V=
&4 CCû+UGvFp^ȻdWV6	Y7Y6aP/uQ[ՁsZ_ãJ{m-m؁Gq?RPm.ahGu[
סAǀ?
ec.IF<ۢBA
B{|c=t
\~.0 /:gKWgR`)Hε,ܤ;LFB+~;r߰*Dh5Q[.N-dmWmnvCVr&3w nirw6O
h +Gm10Kw>cɔ X~Rwu}{p}
|j}8XSSj_E$QSzŸoNJ܃
}*4R0P84%Cѡyqq2h$pHR^
eW٫69¢щ54-CJl_$A=^_`'tol$2ז,CD|^^K-G hru06кX(#<Tt7C 	c MG MEG<t1
Vw6CsbU5s,z=nCEG䎘D["/xV[]Rz^Z $[2?6
*^6, .| [x}<;-V)-V9붿+Th&+	f~tgn2s'W455֚ܥXBzJ`
x
a]?THs6lNap	FCqU
u!Wm靹p[tY,6á.[
 Tи>,Z.A~ ^
	P!VX_V%WJ{f_ K&u	F!dG )VDE1u+\v'F(3 .}~&V4C~qR; cN1@pp|ls0w^`p=`1SVe@K;{0|Yu+s3 |$6yt3A0	C.#9E'ϠFʊFK5FN"&PxŰ nT.\/|Dgv!1o8(鯺I|;~lrS
^3p !R#VhBj-tYB=mEHyo03mGǩ]Uډ+mȺ(
ZL
_ݫ
fe&/
vO4w6PQhPlzw2	Aw|)ș͊k#(wR8#W(H6Jǃ<УN[9;)n7,Z	6ĐFvH'PDVJK</t<\T<:uCG$g+uC*Z3NE%0;_%G nE
Y6dW[   HD \7s.|O	d
c@ZxԃQP=ɣ%O	t㣲E`Z}Pl(Q.
j3}28Ζ]314@;؀1G1{	nGN 50`nU&տlto׹m#3J>p[(is>ҀjV04.<87O
|]QYp	Rj^	ڮI-ʫXO0x#.*2u*P#xā{P	
xc]5p@؈ؕ	`w=.4^Ep]s`c$
t67,vMĻ5D-A =Vэ\ kW9
X[b뭗amĽz 	!?C_,W2hJ#`վh'J-}H=G4`%Mw(7*lu׵>t'0,;|ЃE<&)kYI- ^s刌ۦnelhRTN<
B_U"EJ5&m.?U4\E6жϵ d=ۤűn-ssw_ _GkQhy{|qKh	\6B%}x%\W|E~~HkHAh,:N܇ `(z}d=AE=`5[aԽa3'CNF0K
dRŠwbt;tQR Q.5ϋUѦUJfQjx*=\E6EGF(tOTR~><cC'uy@SD[L
m5aO07F3~E-h/V*iB"U
j{Dv#~ sfn$~nї1+~?Ohͅ `%j
=qж!W÷
H@v2,-?s s`^?9"66$)uP%=mm/u:t(l6lq?A#EّKW\bV8 |:i
yy 0f]}Wwü%Gȅ{Z@%
-j/481%p55A~52;#9.WM "tMaYV*Iaϛ2T$V7H& GUZ=|~a&ݸX5޾5 7>u)-xl =^(Bz\EW"v6BFsQWFV݋Zp8i?W9s*tD?CX*:bkVtN=C swlv/Җ5/+~:Bؤ>Nh݀>{	\(-Ȗ@G=B
W/_B<jq
6RF`EW^aWfmm;s!bKlK	@ukTC 
ߒ@ČVp? Pr޲JoCF}
f.uF9L%;PWuK܉~ C$6h0;MHM./1kj3͙ +,kAR
/۸(]]΀O܌~E~^{o}ݚF|bN%$c2t

Wg
V<ANBA*Q⹧O@-O
X;uDFE `F*A	 h@k{wDj  E;U-AR$v>_k1X|z1P_t6q_7*pĘ=/ƠG ZXWi=i^YCs	S=CFl*N؊:ʥƲw.aWۡCEHqi*"L*gx>^5`=Xp G>|7 5t(^3hܹ9u[=hv<LNGGRXǴ 0Cv
ݧ.9",m}	QSf,5]6cKS»H ^e_'KtHeCa<.@x3.x7L< b<Ԇe!0e8tߢ
g-	J7`jX2;鰡gƏʙK<叭2
 ZS#cC]
WV
]aЅ!hN(V8RN
6P$tpW4K
& 024=6
	u\,7:qRt7(L*ֿ\8:p8Chctbw(E^\̆vNE,U.oE
nѫ 
gKE2/G\}5%1@1[ mCGr(H}suK' Saq
+KK	.-GnU͜P(ATo@dE$~7zXk\>e027)ÈEJ W/
$ 8`:|j# e]Cx=Ѿire۹ E*u-J&/y	sg\*\*<&G]M7I(4&l	JәҲWhaM/@­8LmgKh,Hx)X`nu$P|,qUWu,\RQsdʨs|Ep);tswt`*^Wǵ[ץ\|2.T*8:[<Rr$ؓ_O*SReMW[э,
D.H
*	tGg/ÄEdGww2j%l(A_P6H%s lJ/D,
=\?
@.|!Y2=c	 ,A
LlX\ӿK,Ovt<;6^ĸC$PPOV	<P'v6()G_
zare
|7_\.4_f
~$Ob-ơ<mFcZhlYVyC .j08]Ӧj=xnmc*Wux͍.Et/uTGYWr;J6~w!XPr{JlpCQ#H>hc=\t@Ba =8rES.FHBRD- ELݹ"QM}	_ZX@	$
^B6JШ0W
8H P~&u'
-
g>5;'5L֍
Bw)&+iwbZ wBfIlB[bQU	kgL|TD !Al
UhޝF[od4D8(0L(lrF0$=
uF	Uo7wXw_J7OEuEz^xbдv6+<ve`4U
p39Jp,Gt+m9k$^7wrA-'a kT#*ɗ4I Z@-2$8:$M^vI0.n

<6#E>83phlALhH	!K<?tA:3G+xFG5`x3
3wnX'Ǎ8LϳWPeOXv=j~+DwoPSqe17)S˽L?s՛׊մp奸w"R&\dIBZP;~Q鳼':?ڀʏ!ds C8!ώYf*2\&pO&6v8Xuu[O
6<T@/F~kM%[ueԙ|VM; sNSȿ0ԡ,R?-ͅtI;NtDv?kFE4{1e@[$!ؾ H`LA8>s 'Lw% MJWlG:;&Ru^E`uJC2iG:4=D+N1;u)(l
**j;[fhe_.9Bd9I'F]VM  ,"HG"m$lrXGQ^=ѝJLIPGKr.)ӹPi|15=os1i$K<&[Ő k1
EhX"
2sM\\G{~Lg[.T
0 
߁{2qUwt
(Ї*+Wp*])&BA
dr_
Q Gtomk3n<g[gvZBƲoN>,kuy:nL51oe^|WvyU_I.VZUP߉,DEB)V`X
.E
]SpLGG^AALXW`)4U;N~	tJpTбA;$/jnD;&9h|;e79)uv.Xz9!%72I]`WR&[ҳVg[vi:? '"`0<LA%]YupVƋ|<.xfv<>,tu2q[ lvf:J^sGljG+]JcϯUx^Y&j._7$R[$QTs
UV64orP rX2U{h
ovQ[
u'9WO SU 9/PsKv6"9"$ 4a0.X1t
p.
q!%	ӣ ]'-3/d8
;	!B;
!En\w2h0	F-؜c4`Z.9[v6vn9l;lkEZa0g_(t"q$XFaWmr`m`J(,*T"kc#ܟ:-VԏW
:GtѺ>IB\XclMP5P,[@
dg?|Tl*x#K.Lc
`7[չ/ #Kf(8LB}TqE7kf5u
ǻF( pI8gN4@wET>(O&+`G0E
ݎ|[ƱGo?cUc>$W7ZI֨ng\GăٛaZ?p[FT0Fk`\:\8RRKkb8[:7	+8)7!s>)0mU_Jd^,k.PTc9]7s6Cy\ (]pj^p0.\둮X _hmӬK4,D'<LFVXJ=ZM eIZ;T6vb-;s(|28
au.A!6ߵr4&Xc` R3"۸%@Loi\:*ƗǩO6G2^$r,
/"v%RM))#GA#$rU÷j	Ͻt |K. <J/pvA	>(LJYaGIq#e4e\AUDt%[u>[D.D$z"r
x
	) >B|r0AyH輮|YE;ŞM t _SNAn/fe`;ѣ=fȝ$+l#;;s+2%p<v
)z& ;&G+~nsh>P]nfݝli4]^lۚu& wuC*4d{@a^2ȡȉ"z[
]P'^q}NlGbĄ^]/l63%Nhfdjrxe 11`[ę5#\+VkRvZF!{D|DY|zw\9-i

/LXX7lmbV-G[jGVunmc)	G"QX:17u%v)cHi(
Un8<	T঵Op"[)[Z&!6HTO2mP| rGWbB.?vj	3ࢋE&|z#)w!uB~?&T!|!	7n\BF)xw!
0nZV-͘|ZSF!,RDSQH5cMB}z IX>n6<hKsk~*6RآOρ>	
x /VLW|zğ<+dm-NXȏX
	A<1>@IvKjU/SKq@(5&o+3'm8랻QuztvC!L-(,pUT؍?Ёo,mQ^={n G FҊB~-TlEE=S1;%tKt
"ةF~[Jۣimd&P=~SnwHP̦ dm)[RQ_CЊ@=D)#iy_w0t.=|
v== @sAFj 
wJ
QNGj Mi0gVFVۮl01XV57H!#%'57۪=)
+
-h/*jn#i%f'C	FO
`KA[1/3|
pyU)L+5+mʀ;vҊ 7 /Fi73YY `aX|  }~Uj׋j\F,0P`mV,1 0	|軐Yx0{e!;Z 2I7/Sڏԩ+~	A>5`#baj#ñQHk|Pސ)!BiGW&򋇊zH#;]wK\,tz@P#Ne<mJps}+=ov9w1ZQ#(}Kμ
X%~(jf&Fa%) 1mRڃ	
X^dH:^ ""ppA)D}Q[$(o5SS^)D/
<$ONN
,W/4^RX<~{G g"-
Q¨Xv}LO
|H#mV#F"GRyxXYoŊ%Zssk9 |5b4{W$_v_\;v[@䫻&`MSgwK9t;
늠pC/*Omj.T-q,GibvFr-9v).eF5A*+mFh9EGELюU_Hms$wлOf
n g	!@ɣIYx&/UC!
+#? :m55L >򌗔k5S\
KrИpnG(^CH7w3]]!Lcó2yxy/M%kbE'Trǔ#^WF4D߷DF==~$J=KCոF0ҺE%X9kB@%d	bq'陊 A@ehA
Nz^sqpAu[pWh#
ѵ~REpIqEv6L;Pw_;} cSUkZ}	B@ǿ|F
@$tN+@i.8v34t Q2T3XĮl)x؁HVhXp^`Q#	B'55ef01 D0C2xHhh?@uXR%YqAe^%tGU[@yuVLk81G(-*> ?l^P?觲Awwg),&(:L@o:P?,A:G[B7 rFF#~!!cG.>	FiZ4ZL
xɨh_C``^b(4+"ChZnaY&@=Bg 	C-W3 3ۥfRw vLøf<;N
}7]*uw7P? s?uD4 }F.>w륈S)Q˰_G r	|T{;
DX gW 0BJAHQYP4xAՇT: &,7_9r?ΐLh)_	ELժǷn>Tܬ]$P.(IDF}}/
%R(~S1'Awt Mvt=vϥ+K!6#)|hnω 5: tpCAZm}ELnRhNKmEZ9?,ֻM]Y6tS
 	D
9k^1RI>6ڽnB!#݂	L3k{y`29GlW#"ܕC!$7 
2cwZZ۴By@>|+G+.*UMNF#
UȠ x	ك YPVd QHQEerg #e=:>
lv}3{)bpFE3ZL,0DO  !DzDR)N\a㛓


45Y]-RW_Aۡ2k 2~0Q0ȇɊ
9@Xс@?p:CCNa\T0wX%/w4E j0(z	LW+*(kjwD0O(۪̥ZCg;|@a1U@> ?:@PG@2c/46't .en&FY2¾+Ǐ E k^
v?F򍐘KR&:qЋvTCFEJt\H4,d/*W uSr,[2Л`k)}(%hL(.	%Sj		=jU藾E
NcT 	<`QO=61\]zMG/Qr,Vr
zEv6X4OU5#`,UOٲx?+Ta1,0-l.>Kr@1;̉%
8j'dZ0!1RvT̴34WHۢ!۸CBR7pnP6tW4VKP_v"`kFqclmdF䆨sF*?
h&ψDlKBJe /Cװh> {BZ)%`GzM[* ^rkk9kMkRzkŌkC^[DZo<5rve<Qsa<bt]*<PtkV%rJv<3AB8"F 6>.*1
ȕjj7`
Nt$+~
cg7lۈ&Zi_z̠ c6 Krw=$( 뙐9n_A똞&[.n*0d0v
J
kXllnlmmmbn Kk^k0#Zko4?skD
lx E΄}vV$[TUW=7٧Õ
&Jm,rvvhqUb-, EY+L
tB4s>v׺'Yt`6* -j~7wD+@-|WKtsEH`I%K6u7^u1!(L;U/w;;E-wmMu
u-v׍UutM;coM
w>l
w[/Ngݕp+ᴻw?@x|%Yߦv]\|
9J1V"?AS$pb\U#Vt MCa)=wzW_4dL`jA
;na&dG`_	UG@Mip
[oz7UVF<	pv$b EQɲ?wP|Ku .w+ے,ЋBEMw6Hkpw	qAG7lb۸L^3wlq}qqqqqqqqqr&rWr`rjrxrrrrrrrr rrrr	Ytr
sss	&s6sGsLsmsussssss-t}%tt	uP`ukuuuuuuuvQvqvzvvvvvw8wwwwewww߅xxMxx
yy"yJyy
z~z!zxz5{b{k{zn{'|.|g r_xkxxx\yysy#"! {zzz{zz {1v!@48.:0*2P
ΛcVUpy~~8rOv*V\vi^`viejvluvA
Yjx$&>7)HvgrwCD0swY^{:o&NO&SfK%躶r_ '~Z">,96ܒ4#/ el`moL5@]kDP!~(rVMC<$tgxҬ!>92wSvKt:^4?Ѫ>x9Kj??f	wipo>Ի+
0
q+>\\]`뭡XoM`o땻f.IV
G0k-l%oewuVep^p`0bZ@\O!38d[fv	jd
覱
5yPP%l2]q!=5ACk15[um2#ؕ`ۋ)\=ueF~qt!';/ww<w$uRuK2D',6a_a˛Ds}.Ѐ4_0D^[`͖P
?p7I&(8Y#-(×^aD!l]P,8j1(Wv|W
%C<^ )[o衩Zi=[]0+'vJ/t
\ZH`
ٿTea8F`9?V,p!mmU=vO潅hĲƻ7G{wA],	W[{ƓedŻK]51	-ctgg/bI 7K@(}p=]m@hdBm^Ҝ,k+=#<v,N,^W-Y|(A+p8:1tgnk)α׵pmj*
%"k!=}
t#SK=겛L
GtX} Bɨj+=M
bQAK0g~t5g4
lCnA95@ׁ~XE"oRA $w\묠Ppܐ[b|+}z?; .<mllA 
=f[lx wO$?<ۘFq ͷ> !0N $*X(K'렙&l #8S(qi$U$ bVXՅ
8eϩ}ZK
@0FPS	[OIqW@q	wrI؅ptF|{"ۺ)S9~к:)|nH.%6Fh0@, 8+'7`M(^F-c[bZZ
E2#rۋDF[(OD@骢DQ8t//	v`#`$0M*8
x!x#~AK p[X-R*%{$L%Z?T%e$%W,׃$;*Ȣ!BA(ݡdt
a	p%~9U鷿Ѭ
D 3/N[ !|+<6>u\fV5F߄
>wCx $eVw7ED}p	^Tm
|8fO~rra}tA!Z5(Eu/P#QR10a܊tu@Xr5(z
ӯ߀&Q{D:2AP^MR P|_܀=VF".,qj#
ڙ}}4~/~h~v~~~~~
+QcLy*pJu;@I[^

#\
(;N(B^Lir1}NE}.Y0uΰࢴ!KK
eF!$6 C%I!xKn3]E-s%DJ;p@සd!]} 6
V,R	r+$.뿷{Kv뱡
>F<a|<z!t, 
</\(u6DTn@@e 5?8wNn:D(:ީd'm*ӠV'KM ?
-*&m)k}ft.mmo\a(8
]FiG4JFٖԄmz
UD*HV%#~H\~k1kb>m#<;##vo
@,l|F',1_nw
	Xsx}҂SׂYCq
Gq<v@Ci(
turAghۣmvboFkNrlhjCZPU9Iksh)oȧE2GiEJ^	Y.eD	uhۅ1hd4c*fxUUD0whtS.?N1.
D'
@VH@g-
/l@() 4	_k@[
t%u7uzw
@tD\
ZWu$tUgӡ]0Pcgh-v`ww|]2,ɊT
$J[zV1E [	p9^PKb](w]Oc70k%bA|,jA5
Dx
h0ǂjGs Z6
T޿Jhjt`u	|-#`	[pXy褐6CȤjp$HD'e MxVN@[55ZAHh)}b1 ,F^Fr7P!򤏆\ sP#q+F#9KO,4 wc2Z$QՅwkyGz붅)PPaW||\tUuPl1P8:K|7mtb" Z4[̵}mFN,=V
SWfق? P MuBMмE][-0tZtp"`,	@Z5K%R.ZtCBAo7?nR7a ;P?U&Tkܟch`,%"
O)u ˳=#Mtܛ|_v'ڭM}%;s	|=BAnr%q@= OYc0;w1g&)plE "fv&6 "k{
'$Uj֭ML
eFx9/9
1lMY	^x''tOIj;tC:BHV.ۂ<53^#@$)]°W.CB&;
M,=!`a!Ca4ъHStfGMD -	"¼td0pEDkuQQ'
oNȎvV0cHBkqe+\R3u,"P!辊 Fv0HV`3A W]le0U]uY%sFwF)1gOɎډ#>ƑGoGVP,W5>bKJˣ

"|,w&{>FBǴ/Wwm
l$]
l_P(h벁wQ*4Y-}A+ls۶V8O̎Ơןox u	bj΃D@H1뗋zMOweh#`;/;!t#sG}WYAmu4uZ:uf[SÙۨ)7_Wm(R&O([RĞF*p1
X5_,#ru_,i]E^4\/#1ḆDFX3bb}C	Z=GuRzWzWS V߇(_r¸-eiR"U̈-t
>߃xV¸"Ӽ
v#
$*_Q.EP 7 W08:2 Q.{PҒ4Е6 4}%Qw`ėM4߉@نj)\cxD]bǆl4mͲp
 qRHPеxZjtĺFJV_E% (\V(dlf
/%U	kCBU,N
F)p
[܊/-:rv
(
2/Ԡؓm @iw
W]`|?.Z*a|ƻz8? 0B(um'FElm
\KT	t948lWW*V].0Pg

PjW}eo^\PyKfD(pNKqM]
 9wSİflk|a3;pή&?@ Pް;v; wP j&IS[Y6A.u65Ǡ[si;!Eq_
%Zx;
so7PHr3N /Z$ r_jãW(J}-vA(!Vz:/Z9[֙lj'xn p*.LJhZ A͟S2 ~n7Ѹu
 z	1gԩc^m˺ih9O@M_-NNA4EH
A.RSP뭭
s\UsnA +Vf4\b+vwT 
QTzrMQD*"K@XtR:
~; =-
@!z@Pu!3cI;]2'C 6
u[6euvh.:0Eié
#H2
0_.nL<,UPR>Bm^ӱ+F8a2hUF/>Hǈ"^,oumWH
5iJ}~wsV	ۡEu

S0c1-\Rٱnv@Xa
a3H:F7,d:KGu3< Gp48B~Us	Lw+ =rT;|%v.[KViJ=^`";DsYQHA=c7hᣡDTwP2Z)[UoI䚜ye>]M_Oˤm<]4zL$eNTb\lTR]KBp>R@eNnhd[@vnP"(j~腥z}裘#}7s(:}R(x}m=u"MԾZλaBޛ`fC?p%t*tV"81c}1QHd^.>hpEA	~R}õr	}As$X &4.LIIˀKb&FIEl~ Q,u
6E(ȷ1lPr~րw

@@m?׌
h1uCa`Uz L12wfQOs 4.W) !psSV [64R|
GQ]_|J|2kQz6j1:T|1vƦ9-;t:lFSj\C<{G୳Cm\+6A#fhzWg>O"} }(@?
 
bGЃ4žK}☽)6@X.=Lڷu:ڤ4!c}<PhJt"U/<.rv<?
h;<o7</	<*)ʴw:9s%?CP몃s&;BTNw̍	keA^<ZLI\)<u:G$^<v3Ԉ5aP_u*VtU葎 ,AFܣtirUnj.U+Pfǁ[@
/:$/ Qc.PU-}M+@
Q(f?q$P8Zɘ<n\.6 k#Ga[p[&,!89u4Dз.Pitp{y%mU}\l	\aFN-@{dP8zPΕ/*K\ʉ6/ A\uKT8 oOyF$!hpx#sM-L2@[OVUƒ0#,v:a_2?\ zDo
yM+&Nh9s/0ID $(A,t
Ehq٣_/5D"M	v(v
&=X9"C r~ktw:.ro!B/؎x<kT\lyxzQ6LB羋^DE3kRX\m(`F&ZXM&D2a>bVQnQdY-q.Q.NuR]tEΎHT1M;S\0Ռ>"ht-nZ L(!z>*
QM~K%wBiT{l[ki@`w`3RP$RKK@^dPnZv$Eq !Gյs'3>-չXvT=6)2\F'Su/#:L
| B\n%U]
&"
SPڍ訹`iZo)h Ah&x~C^Vt1VIx]^
Fb#UE(Y;We;U
JDw:uS9rH}H[F_-	Se[
 斟tbף(0 õB0K=a r=z / P?v
+T%G`IuC QKpIQA:r+!&FƅFPU7-OAZ#[R̷	6߱jP6TJE]K4ADg
40i::
 L 0
Eu|T-~ Q*ś4&&%jJlka&(C ҟw뵟A)U -Tޱ.D

uHtAo6
fXtK9SS	s#zDS>"B_3uF6!]5h6Hs*jwBv+lSs9p4R&2[vZ[_rΣ3%pgI ׀Olbcj&{0ٔqDtQ
O
~_8	gl( W[9Q1p Q6IPRQuh-W6ZP8,@{ӡOШQE;u< COT#"w&"֡ġ⡘}1
ء\8iZTluqvSBSLϠ^?Fň%-s1R1-
N+E$oKP@ap mAScKpE
.яst
QGc	~CSYa=
߂͈)1\s(U.~!
pEUp}Q@[:lP1^ | `-S9}%B}˱';Im( 7+AX-r"r`!}csb.
b85%,يDqX)h 6pD|o.B
Nz4]
eC  wZP{@
Vk[
sAHH؍
	p[!wlz
p@
V+q?} U7-	Z`=^]*[~SX[YWIP?ٴnrt,K`zEd>x %1Y۱WrnNr ֘Pi@{[]sb @B2?м!Eີ[tz)^ֺ9Ⱥؾ[LK=F8%	o+쾎oPztk3i3o/o_ <u!t`PQR$A:+ߧ.} ThuoQ/ЎG[ ^66m%l,ˉ/GP/][ZXYSːC/<aS[a=${>=nZ?pۗP$YGjS/7|$H	Hޏpj3<+EP)0ݍ42
"'sim
t8
{k^_؄+=@4n: ~-	PlZVQi»bktl
"7kP3&^-4hE{(!e 03)krDieYkq :q Ȃmkh {nRwk)7
HnMkS~ƏGC GFV%A ^k; &[,?` U~} &]6_	Rt8k:m,Uٲ	CUr*trjm]6] U)jm@mv-Ƈh596pyou?~m\ \s~,mɾo	 5P5- fTh)\*H`/`} f\އ 
iʾ\!x^7w jU͌ޞčr`4OݠRGG4#Ϣ~1ц> rt
/w
DѠnj/
R0o|Bn	5Kbw&.(Ik<C(
RGtOjA,X&W<(> we@6*mhO >EF902T| ]'zزEX@C{T5w(&SmIKMOA ۺc_i_S}ݸ54
)8m=NV
3	)r(͞6t5
 g|;!u/{~~s
Y~ހz
uzs_e.^t	
MRv>2s6Q[	3?l"nB"9rTNS`g-gC0DBuҜMU	R|
8,,
W#kFpa
,[BP`!m
F|
k/UFt0O= ⺖Eߨƶ2"&tp$<@( eFJ-2="f"
0@E;@!\
I1V9Gs?FYl ezJ%Xe [h#9\[8<39,*z-)@X7'h*X|B<\ [/=g߈_N	C@09tM젊XBՂY׮o
:*8
7A^aҢn8VEf$`׈<}@k=BD2t+N!PDY"׈42uUM
J3w2t.4}ZHZ!@A~VaFk钉fW렠j%%RlFcu} TLP$4B&EA\	L٣ ^ap޻KVڍQwܸ|'Լ6(PH(c8KG [AHu:i[@Q$I+A.=h7=H t6!e,@Ggpjh7Oo |U>yQA͢Oàwhn@{TOUmmFOOF|Vc Pd'<6. z ,)l뿶kB(`sw1kWD.jb	Qd*qUQ2,J"?@/d4k)(}BiQ?3,и¸Wqt&(pe(* ,TG\L[
D<h>Be('W$>ob2
ab.n;-z.~&+6rJZHO*,z[F·np
"oXx$lPVrSEu3I0']
ۇƠ7{xw%6'1
[Q`)GFs	F!GJ7[6l\7^4fc#-R2oZ͢,.1@p0퐍`h#n>ls&S)6j9GIi8>p
@|,Z?t$hA9,PJGSC9RMrx9s*>M_CVm!G T]dulj5$͖~(:H{ &MOVn(#m>Ju#蔷JJMnhzh,Yq37V3:'YsS0{E@bv++suHćRg2mHl->ߞ)JuF=<AA03Yab=nZLAD0P?.|;DҺ 
v ErE
omgWL6tURj'պHHXƹHo' #Xj	"8O|@}M1`WyGPBȤojqo@#  wʁ%t&(=t	Ѹ*%
g1#uwzrm
	
 HTB7=@>c
 d] +l*X'2ld4);9r;Dvu1 'UyynYN
@4w/#={iDx|M~
I*Dc?J6	]
Bu+7/z@>v:ue[SpɊXvtOOol''R`QC@[P@^Wik&l봾"̾\7ZYTYaj׶,
1@-u~UkS{CUNbX]B"eV'[ xa! /n؉#5ݧV6$=,MWRR[s.EW8+E-0 X	O@yFS59}A"bמZ:u^C-ghYk欢DB!G
. ݹZUCAb`d4hb(+oٖ^A=^	5Ci͜M5;0}nh:D#+-DD-aEö<A|[2Z~^E,@:%[[;Wn<0oiܐ7l#
Tv͗4;u8,(x#,X	3\`(jL%"l J.!R P$Yl';B*3n33׍=@&GvC?R<Frv.<K/
<Nt5`E\{pR5Խ-M	ߴlk=kabP~W1CN:u=K8pK C.
0|&,
ʄ$ƗVpz>^͓@pNyߠGRu=
@!|헠ՠkP %yW
!
Ǭj3	q/+j轣t)[
 sA, |k#@~α|/蘩6GR+._W[/) R?ǟ(Cĺo~7(@g0ċ%'4pu ĝU Z"UEJƎdl\	 m*^sD-%@yA3"P"dB]<G$AAΪN޶|P~XZ* $4m VlVtBN@5I|XlD"AkE=OHKJ<
'hH݋NOJu!Fwj+	5h\]*s2	ꊇHǭo
	pJ.%#'f?[g	
4~B9n%v2Dn_0´2
k96D$7Au!
&|^AFJ"QmwD	Da G)5
})g|=Q{E
Q
Tk
|T@u.BU(2@ߍTZStQ.q:X[+5$QLU8
Sn ӆcO=Ru#^e	 5ZgzJNQC ?w	>0>
!)gX;P.)k$Iuj6FGs(F_d]<+v9Yz, u	]0XTJS۬R-v[6nSRA
'&kCj¿8k	D0^H[bh-uE}+h nD/}[	{c~cv}c 9EُvLex:Dm8kBW{90A4B@~/u;UDJ
X^
&V>EyWQ!ыMo .OGz5|"moI'j m-l7Hu(=)XAP?]LjX<&V{z{,࿖Emo`
qhDsgbQa!B;;?rns:'z;E:#r￷u)Ƞx/O ~RPSPJ-µ$Dh2M$ve<}	Cg݃L1'R<gg7FX&&[foh0ݸw\ 0QsѨ_t	Ptфn+`h!jDp|+}w6H
Ih\	t͵̵PI`CT=o~	y`(aX
UFn&݇|B`IWv0fu*wPu$g+?	}'A%05b
(zo.yXbq
0,0-Od-5mʚ	A
{L HB1'V1=!7CdidSM[ ^KP@6J@~@  :,S@oSW4S}߈FVvњ%v07n("V݈c ,u#ߊn
mĈ

q[=;u47 Es&h5L%̉
뽱fPb77I
l	$s^*a
vU
.M/2nB.	`HYLG}LR4б@և$dĈ/_vZO~AKvL^d(ݎ

r/^vt
|J~xzmq"ރvQ0Id!.E'5XB8
MY oʸ!aۢ<hm;(}Ţ#."
BÂpU3ʏD$9tNAw
o'
aF:hK[i+LA }T2KC@(y
0پ!<݈aır#nRZ(ܒJP.b*#^9u*=s%,&;Dd8?wj%k)	^NA']JÀqrn8
_p":mkki-͂܄: ADv@T
O;l7j `ܢ5xph]P516 +yxt!
S(eU/I. ?]@,g3
hQh0orpZ
NaVʡc	6
P"n% OjkjW%)`hs   );+rЕmWH5JٌfKABJsG;wu\duU@c%c#FxNRLFHA0OmbA1JjQ
wjĀyOO"E}`#~/KGwtdPx_)FH\DDx~ttp mA[u!R6 jԽLJkRm@BBEmE*S6@@
->mU=+VZPC[*ZF PKIAZ  E:ǅC4qCX/4OF;FwQ*MN9shF%,GDYEKkB`Fk
/Z-.[xuspoidcXS+pq͒&̓.f͍p9Jg:ڷL%t	T](FF	 j0nF0%p|׊ٔ
˦Dm3\ Ն
1lWY1Z
?
 u<6
CC46G5,ZPw	TnvѨ݀6gE	-T-r_A~ac_~M(i

9̻`)#E&U[tJn@v{)]7t%9T.к0"b~o?
*lJAE
T>qLc*5+D+}o渁kn[|<rPl%]b@`٠!қ>֊lD(PYovmRR$ͺmE1DZ8T	4	 d=D֋T
6Md	E^%Q1! $@1TMThT	bQ6C=a5+r!CZuvrQ
77W)p&uj
ӯV D0F{H4lޕXAzhQ VC]ΡTJ O\xvL>\l+cb~enuSNm8$,=vkbHf|7F{
?&^zw	~vPKp N6/f*'>ߒVKns/F?PUtMO#_4'̛.[j1ؠHY)vr(ur_ np/vdi:|P,4@SPcıVkư@m  Yyre	 N#,vt.p^3Z:T.(G	,.	"]
*p$:' v(=+ux,/rr
,u'(pQ x߃IF#G}!	#%' EgX&@Ƈ#AU_<>Dn/@~,[!R&MXt O.0Fg 7|
){_l|v,n[ 3
m/'-=!E;h*Ut
ދd4,QuGm67 2'̲	F-D?ge
HTJ}]oTLNh
/'U(]M+p:{wxVzy4
<K	D3b2
po G$>t/FC[x@ 
vX@̆F辄m/Ļ$W{@PEZ/>vF
MknVP=W4OFf|]Fe0Q'76 WXkfR:
_O>ɷF `=`UANzddUu uK t !sMTfmdC,=J*VtSHLiTmyKYeږYh1;߲,VڶX*OqO+k#a@S@/	L[?	a@w[D)S,p\h6C7sp.g	,+t=LHalW5mDklGZc*U_`$X<VI;þ&mWhVShGDWvARƣx|^U(	
'j*Zzہ?v<m;OAi1,El6G[ڸ8'ʸ
0$
-4l;) \&@J-

lNq\LE ;W#$4nTTH^E~Deݸ4X4) w
2Ul|Z {P=[P۸@]b74ևn~o>DGPLFuwtpt /s6n/&p"-gttn@tu&
3e^7tXR1Zfyof#cu@bxP 0	;9`*;[  `/eLE($:6Ċ[JE@
}hkiAD44]KOMSv6WaEQ~S7 BlIU1Y@
߶̂OE6Wxީ0
 -mZg^.E[Au8p!<T];kQRb|"+8l 1:4hB}7,"!DL(,W=5

}T\y)-h##1ۀ}n`;ƀz>pBoBd>+S4azҋ
X4 spFG$ Q"+8
' 3 /R>C: 6'w(;F遼T\T7I2t=P(k56	n3.hk gH6ګVߞ:xRp)m4&6"-	\v zs#hRbq!`6_ko	 Lޭ7/ɘ0.@<m=UjYoY9}BiU;BXO =:5P
SG^*,%nX#BZWMc$HiĴ:Li`1mC)=h%9胈{vőU;.Zmc
Pl?Qpz/@p2I
Zb
rWG+w;
AS+1ov׫!yӠx|
w@-^y/_
na:c3|3'x
(C)pyright995-Pasq-le J. Villi 6Th Projec
A R@seved.)ikf- softwa	C!ޛ% with ABSOLUTELY NO
WARRANTY; youk&+m 1dBtݜbuD
t}>/ATonfyuT? vrmUg
GNU Genk¦ublic Ls6$ps&[by;FSCFoUaPGw;
e9`@H=2, ~(8_%)PWnl(
'A:-@JUNK@-.TMUV !"$f%&'(*/jVE63 /Co$<μ|ؼ%,%7
/V/t/	/#/)/.3/7=/kK/MS}1Ycju0~Q徼yƮƺǾ߳A>* MUgfSCPRG/;_]]R+ bBRfB ;+EUR.0Al 	!'+$$HU&&YB'W	)@oA.*,W  r/r-<DKK.ASEK3/+afW0+PLN&1¯l6V[r 7 =d=Q mB_vfX@{gWBGL	|PUAH' [DISKF~  vp 	q `	 "!O@	  t$  # w$`7]2\oAUX8YRv
%Ũ+n7pЖb*Քo%+cx - 4T*MC	F32^juppt

%s?oH=.n/YD 
IlkSP;j,*FloHy/X	-;l  H}_inve5js(@qbo t {_<''H'Ewa<b21HVd0JDY.PzE:2O
>vWIHESqEM ;WELOR	iHLTL&OXBREAKUFFERh9h<M6tD.TR(s+D:mACBLE`HfLASTDRIVE	dMkvLLl[#AmSA6`jЇIY}EVICE6Z{IN=TziTCqDPBfdh@f.sy
50IPstf-w
jv
1F8yfwac$[r58^xip 3.SYS/AUTOEXEC.BAT79s
#pLlg'#
[Y,N]?YC{0wGgYKq-#
FbO9Qnh_Kmh:3)'s:oadSs=.av[D*kw Ic7?r>h ͠v"^
0=%u=c&Q,uc{k+)I+3|E
VD-ff = DByspHi49M"[xc ]]pc[mT](+3#vd)-bk 
&
x:S/ɂp(3m:0X ClIcw%uldb5,3tVmfmrID
cu4hKa0i؇3  To:33na%"mv=kx)=
/envirom[G,u5-C'd[d."%s"QS: S/beN3 f
3	aajamk܌jA]	),svo(a:r;/??j*egk#eF#h VpDy63ludu%.|x:%4u-%| )6s32%tPZprIt93hjQPiC,}ditxtc:qD%ܫ%2dr	S%ŚR6,6ѪBvize
ApDrԴtl(ge di(?v1l1mF maG2 d2Зs7rg,pB9=0x
xv08S0]00/_k,Іml63WCaNG:sSip}FS(Yccul#fuћizO`5(ad3]U	{K-4~(Aks*x'^tN L{<es,$䧘dogg=SKvPl˹P]~FC4-?ˑd.7):tDNVeVbF:dLtE)SG!`-G-`/[d[tu@ '30x׎YdDxs,?h3nr/~IL`H-0 
ߎ ^1 .xn fo`,V$n *xR(5q! 2#O"#&G}+d&h? `<4    @ uu rAsU fsIItɉ͊F19 uA1 sAA )r؍(󤖎P1X u  u<F][Î1&-Ht@uGG&=u&9Uw r  ` )  YHH1  &  7м1P &Cp2`t   +,-.-..-0-p,,+P+  t" ~}|}Pp"{ z}!tu t+} |tl$7%P '%($('&"!&3&6@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PTg~P%&$ |Q
!0@Q
!DD @#((buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


                                                                               MZ ]  `  6   d             F  /    I  
     &  o  A  )    %  z
  T
  
      U    y          ?  .          q  i  G    5          s"  m"  !           &       &  %  $  c$  N$  $  5#  /#  !#   }
 }
 }
Z*  A*  !*  *  )  )  )   }
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
~}
z}
v}
r}
n}
j}
f}
b}
^}
Z}
V}
R}
N}
J}
F}
B}
>}
:}
6}
2}
.}
*}
&}
"}
}
}
}
}
}

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
~}
z}
v}
r}
n}
j}
f}
b}
^}
Z}
V}
R}
N}
J}
F}
B}
>}
:}
6}
2}
.}
*}
&}
"}
}
}
}
}
}
C  rC  AC  ;C  B  I  I  H  F  F  1F  +F  F  V}
&}
}
}
}
}
}
x}
N}
0}
}
}
}
}
}
}
p}
R}
4}
 S  S  S  S  S   ya  &a  a  
a  `  d  d  e    	}
2}
,}
}
    u                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      3Ðjː
  F  F~ F F^9 uvfv)}fvfvu)~h	h jMRP%Vtj
fvvPB
h	h jN~RPVtj
fvvP
 Ð3f>^  tf6^ 覌f>  tf6 蓌j b	  V  h jh jh j鐃h  h 苒j>bh 蚐~KF ^v&v& =c   -!  - tHHt-2 tHtp   T  F^v&v&8 ^v&v& t^v&v&   ~L  T  T  P  N  >T  uT  zH  J  kF^vf&0hn ?F^v&v&8 uNV  *=p t -d jHH|f6B jRPvkjzRP
jjRPjZRPꈃjJRPڈj:RPʈj	*RP躈j
RP誈j
RP蚈jRP芈j
RPzjqbT-r - @- (FF9F}-^v&&?-t^F&&?/uF ]=sjxtRPja]tjyURP凃ja>V   h	h hn  gvxvuj fh  ! hy
h@f6vfh   hy
h@f| f6vefF    .^
~ ^&0@^&@F~	vF  F| 9F|jF= t= ujRPja]]fh  j Ԉ^ ` ^ ujzMRP݆j`s>R  tG  =]t( !  9  =  A  E  I jJj1fjZ   ujzRPcjZ`
t(b       ؎f&fjxRPj`>P  t>R  t\  Z  L  >\ t>\ u& & & >\ uH>T  u	>L   >L   >\ u3T Ht	HtHt8j ]uwjJulj?jA.>\ u?T Ht
HtHtHtIjj OȐju+jRP3jT HHtH
>T  t7>N  t0f|A  h|h|j苁
> tjJRPڄ>J  t
j ^Ot  F >t >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uwG4(~ tfj fj G0F   =HtkI-
 -!- - - 
tFfA> ~ H  6 H;~  ߃> ~ H6Ĵ &@u H;~  6Ĵ &@u  FV^& &G|&Wpfj Cd   F >J  t@Kt B= M- K- '-M- 0- )fjA>J  tzj \^ÐU
^&L&NÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ð|"~
 hh|h|j襄}X >R  fFffFf+fFFfFPj ff-    fPfvFPfvFP/ff-    fFffHf#FfFƃ~ uf~uF      Á~ s  fFffFfFfFcfFf9Ftfj fvfvFPyfvFPfFfFffHf#FfFfFf9Ft3ÐfF   fFfFf+Ff-   f;FvfvWFVՐf~ uF+Ҋ*ҋN^+ډN^fFfFVf9FvRPtWFᐃ~ p  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP豄
k3ÐSfv
 ÐT  Vfh  P FP߄f|K  Fhh|h|j䁃> t3^ÐFP^{BFVh	h FPJRPhzh	h fv.RPhd zfvhd Rz ^Ð  F@Fy
|"~FFhh|h|j:}*ÐU~uh	h  Ð~ fh` j 	h	h hd ]vxvu3Ðfp    
fp   ff9psVfh   f6pfh  `f6^ Uu*u%f6vfh  f6^ ^= uv&G
 tf6v\놐f6v\?~ uh	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP	
fh   vfh`  j f6^ ~@v>  WV	~ľ" f~ th	h FPZx~qFPu3^_h	h hd [vxvtj ff-   fPf6vz
f6vjFPy
f6v|j ff-    fPf6vy
f6vjFP]y
f6vb|~ uo~|ij ff-  fPf6vy
uLf6vjFPy
f6v|F8FtF8FtF8FuF  vB܈BF~|~ uF.~uF6f 8Fug 8Fuh 8Ftf6vzYFPhf6v]Y ^_Ð~ fh  h	h hd Zvxvcfp    	prff9psTf6vfh  f6^ Y= Yv&G
 Lfh   f6pfh  `f6^ %*t"f6vXfh  `^^_Ðfh   vfh`  j f6^ }
     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hy
h@    RP~
<F> tjJj1j f6 ~jh	h(      RP6~
6 hy
h@     RP~
     ء` +^  &&W    f&        ؎f&       ؎&  ;&  FF܌VF Z   R   \   f|
S h|h|jt
> u_>@Z Rf|N  f    FޣFܣhh|h|jz> t>}uR   h!NNu~ t\   Ft
F$p*\ Ð&  VFF܌Vf|D QChh|h|jz> t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	|&|Zhh|h|jy> tjk\RPv  fh  ! hy
h@O|j3RPYF  @ +FHuF F^
&@VxR&*RhRj*YF 9F}j >~Ĉf<t<uh	h2 XÐ  = t= u%F  F~}
Fau~|3Ð Ð>Z  u#jIpRP vjJ`RPu3ø VxR&RhRjYh4XtwupÐ0  f+fFfF9F tJPj ff-    fPfh  `FPfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RP9LFVfFf  fP!L;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRPKې~  f|

 hh|h|jv> u0>} u)6~fv5K6fFf   fPK^_ÐfF    fFffFȸ	~4 fffFfFfFfFf-   f;FvfvJFVِf~qhXku2f+fFfFf~svBPƋVFVRPfJِ^_   jF "hRj
GVj[RPGUFF*;s6Pj:RP&UF*P4uVxR&
R뫐VxR&
RhRj
Uj|RPurju,jCRPYrjDRPIr>J  tVhhd jRPTÐ  F=fh  Qhh?t"jMQRPqjNARPqj{/RPqfh  ujEF 
jRPh	hH SF~  FF*;s>  u+ҊN*+= utԊF*PjRPSj F*P{u>X Xt	>X YvjKyRPh	h> _SjLcRPh	hD IS>J  /t~ h	h2  SF 8VxR&
RhRj
SF~sF F FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&RPRj F*PlujzRPh	hH hhd j_RPKRj[ORPjZERPh	hN +RÐ  :l1fh hht"jMRPojNRP{oj{RPiofh  ujEF  jRPh	hH QF~  FF*;s>  u+ҊN*+= utԊF*PjURPAQjF*P%u>X Xt	>X YvjK#RPh	h> 	QjL
RPh	hD P>J  t~ F 8VxR&
RhRj
QF~sF F FF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&RRP>PjF*P"uj0RPh	hH  hhd j RPPj[RPjZRPh	hN OÐ  F >\ ut~ th	hV h	hb FP*ih	h FPLFVu3vPfh  f6^ xL= s^&G
 tF  fvLKO>\ u~ t	h	hn h	hz FPhh	h FPLFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPUCȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP0C  F /u3tF f6^ FPu1F~rh	h h	hV JFVtvPfh  f6^ ML= s^&G
 tF  fvI~ ujRPMh	hV j!RPMF*  F u3A.tt~ th	hV FPfj"h	hb FPfj#JRPFPfh	h FP JFVtvPfh  f6^ I= s^&G
 tF  fvH~ tj$RPL0F~  F ohRj
MF  hRj MFj$;F~VxR& R܊F*PjsRP_Lf6^ FP0FF~s#~ t~ uVwR&
RtFPFPj%RPL~ u~ tjjRPKF  F f6^ FP%/~uPh	h h	hV HFVu3vPfh  f6^ I= s^&G
 tF  fv`GFÐUf6^ FP/Ð  F u3F F~s7F*Pj:RP&Kf6^ FP{=uh	h2 Kh	h h	hn GFVtvPfh   f6^ >I= s^&G
 tF  fvFVxR&
R
hRj
KF hRj sKFj N*;~VxR& RՐVxR&
RhRj
'K~ uj5RP!Jh	hn j!RP	JF*  F u3At~ th	hn FPMcj"h	hz FP8cj#RPFP#ch	h FPzFFVtvPfh   f6^ uF= s^&G
 tF  fvIE~  j$YRPEI:EF phRj
JF  hRj JFj$T;F~VxR& R܊F*PjRPHf6^ FP
;FF~s#~ t~ uVwR&
Rt~ tFPFPj%RP}H~ u~ tjjqRP]HF  F f6^ FP:u3À~uLh	h h	hn EFVtvPfh   f6^ nF= s^&G
 tF  fvCFÐUf6^ FP:ÐÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà*P Pfj   FPNQ*PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ*;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2J>J 	J  jÐJj  ~ t	h8FNuÐ  FjfvFP^
F FPNQVRh	h ^S[c~uvvh	h fvbÃ~P|FlFFPvvh	h fvbÐ  FPNQVRh	h fvbvvvh	h FPlbFPNQVRh	h fvbvvvh	h FP3bFPFPm]ÐUvދRP]
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fv]F
^v&  FF9F|^v&  ^UVfvfv\FN^v&8 t&@ ^fj <fh  vfh   !j݃RPf6B \*+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
& FF  @
&ğ &0%݃FVRP[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6&Ĵ &@t2j>vjqj+jFvv^
6&Ĵ &@ F  F j9Fu
F F  ^
6&Ĵ &@tF vv}
&ğ v&0ۃFVRPZFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^9FuFPFP%fjNj l
^& ڃRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>
 tF
^fvjكFVRPX*+ȃQ *P%jj fvvvvv9ÐUj=fvh
X
 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7؃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w׃RP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN*+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F*+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0ԃRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0уRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j *P HPfj
'
6&Ĵ &pуRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0΃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;H}HF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FHPv~ 7
FHF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFPY"ÐFP>\ u*!ÐU>\ uFP)ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh@FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh@vFt(=t#= ;t= DuÐ- Ht- t- t- tà ȢhDAht<thDAhِ != t= ut uу>Z  t fj h4N3  FL1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 LShBhR*F*PʃuFL| j hBhR jvʃ]FUtKjXʃhy
hd j hjlfj hG=thBhREtÐhy
hhy
h~&Ð&ÐU~ u hy
hjhHhy
hjh7F  F~ ujFÐF Df>   F{ j hChfh  >˃uF  F+uF~  ~1 F  F*@N*1 j hChFff   ffffN*+;|;s9 u(jSffYffffN*+ = utj F*Pyʃr>X Xt	>X Y6fj hF~.F 1 j hChF HFff   ffffN*+; |; jSF*PShSf6^ كfh   F*Pfh`  j f6^ 'ڃF*@N*1 j hChE>  u+ff   ffffN*+ = uFj F*P[Ƀ2~ fj hF
  fh  Ƀhy
hd fh  ȃt"hy
hhy
h幃t"fj hEfj hn
=uhhCht!hChtTfj hU~ u hy
hjhhy
hjhF  F~ ujFÐF Df>   F{ j hFhfh ȃuF  FuF~  ~s1 F  Fff   ffffN*+;|;sF*@N*1 ShFh0>  u)ff   ffffN*+ = utjF*PHǃq>X Xt	>X Y5fj hfF~.F 1 F 5Fff   ffffN*+;t|;snjSF*PShSf6^ փfh   F*Pfh`  j f6^ ׃F*@N*1 j hFh)jF*Pqƃh~ fj hF#  fh -ƃhy
hd fh ƃt"hy
hhy
ht"fj hEfj hn#=uhFht!hFhtjfj hÃ>J  tj htt t   1 ~ ujރFÐF Dj ԃud j hIh$tF F~s3c F*1 j hIh$FPuFA j hIh$he>\ utTtMztFj t:hFhIfj hn=thIh$tÐ  <1 ~ uj݃FÐF DF F~s-F*1 <j hJhBFPuF<A j hJhBh또>\ ut>t7j hj }fj h=thJhBtÐ  Z1 ~ uj܃FÐj҃uÐF DTd j hKh`tF F~s3Tj F*1 Zj hKh`FPuFZA j hKh`hc>\ utTtMtFjt:hFh	gfj hn=thKh`tÐUfvh  zF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NzOÐU*FPPKz*PKÐU*FPPKF*PzPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBzÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졮FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FPtFPhy
hՃ~ th	hDh	hPFP3h	h FPUFVu3vPfh0  FPLfv4FPhy
hqո U<ՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hԃh 
ufh  h j
u  fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H4hLӃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
҃hx<BPhx>Bj
҃F  hxB$PhxBohxBPhxB`F~|hxA$PhxAhT  fhx AF  F~
}YhxA$PhxAj2҃hxAPhxAhуfh  gFhу~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhJуm$PÐUj
0ыFPh fh  	jmjыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
~ЋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h=σÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2΃fh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hW̓fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̃fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth 
Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF   
& FPTtFPhy
hgȃ~ th	h\h	hhFP&h	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhy
hǸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..qcf^gef[UfS..qcf^gef[UfS..qcf^gfeff[UPfS..qcf^Fgef[XUPfS..qcf^Fgef[XUfPfS..qcf^fFgfef[fX                           UfPS^tf3ffqc  f.c.c "  u  $" u [fX 0!<s3P˿y
6 + r ׁsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666QP.eظ eP.eۚj  y>	uXP 
 Py
 5! %d!
)&6, 

3

sx

 

&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.#Q
u'"bt bbz 

b >	u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>$ t$ P]ø Y+r
;(rQ3 V3B 22Ut
 Pt ^Ï* <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &*U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV*
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v,טÊ  UWVFG
@tG
  D
u VށF:FVD*P{|]~ tZ@PNQ!FFV~\tBPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWRPFPvvRPFRPWF_]ÐU#
t]UVWvD
t^@uZuGD
F6u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
F63ۊ\uPuuGRt^tvu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށF6tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7DFȁF6؊FG
+EEEFEيF3EGǌ^_]ÐUVWv*Rt.^t	2vuVF6D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvF6t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vF6@t^*&GPy= ^]ÐUWV3F؋O
рuGuF6t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVF3~~ uD
tV@uF96&r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr<t)ǆr6FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.|Vuxyyy{|w{{{{yx
x{{ru{x{{w{{zuRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] }}}}~"~K~}~UwVW3FFv&vF
t~ }F>, <Xw$ FF.2}V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVF+FF96&r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33By
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96&s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁF6؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVRvv&RPFRPW Pvv;u)VxRR&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFV
TFPv
vVpx

& V3P,^_]ÐUV IFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3y
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	bt	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5![#%!uslkʻ 

FV]U- .8tK
I	]PPR.e؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUy
ء
F
F]XSQRy
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ$%!3]UWVRQSP.eۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y(;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;uTtT^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]              y
              4.69  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update System BIOS with new version         /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This is an older version of BIOS which is not compatible with your system configuration BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                      MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM                $ ( , 0 ( ) E  + , B  . / H  \ ] I a b VJ e f 8K h i 8L '  y
 `  y
  D10/17/2001  O                                                                           	 	 	 	 	0	p				J	|			4	R	n					,	N	n	~					 		2	F	n										.	6	X	n	v												$	4	F	X	l								D	d					$		^														

	&
	F
	Z
	n
	~
	
	
	
	
	
	(		>	Z	|	.			n			6	T	n							(
	V
	
	
	
	
		$	4	                                  E    F    B l by
      C    D    B l y
      G    H    B l y
      K    L    B l y
      M    N    B l y
      Q    R l y
      P    O n y
      I    J    R l (y
      -     1    + o Fy
      V     S n dy
      *    1    ( o |y
      T    U     W   
X   
S m y
      Z    [    Y l y
      0     1    . o y
      _    ^ m  y
      c     1    a o y
      g     1    e o 6y
      j     1    h o Ty
      q    r    s    t     u     p l ry
               e                           _C_FILE_INFO=                                                         y
               
	
\ \                                  [y
  [y
                                                                                                                                                                                                                                                                                                                                                                                                                                             *y
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          fffffff               (((((                  H                                                                                                                                        "                                                     ddd                  rny
y
y
y
y
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                                                                                                                                                                                                               p   `      POST  f   f.V .X <  
 f.d ` j ` I     '       ؖ    POSTv6 $ - M Z h J 	 |
 7- p ,
   , @c -  5 v6 6 M6     | R D~  ! /# $ /% ' X( () * ՚, 9- <. 7;/ Wc0 1 42 3 N4 5 6 7 8 }9 ; d= 0> ? A3@ " /A cB cC /D E F }G PH I ,J L >-M O 6P E-Q bR /S щT 0U ׹V *W X E.Y Z IK^ ]}[ $c\ r] _ *` a  cb f3" f"u @      f{  3f   ffY  0f h0pu   q 3  `  U QVW.D7 PX' hX@s .X=X@u
_^rYʜPPSظ hߛ [X u^<t
PW 0jf&E1_Xa
 fPfSfQfRfGenu fnteluxfine?IuofP%=  rYfa2f   uI؀/UhF
?t/fA0tf  
 RZfYf[ft
V PRWfQ
u5p ](t'5f0@
u߿ h8ufY_ZXSQW! s13
 h3_Y[R Y" t

}
@
q$a(&	%
߿> h3h
6p50 0t  
À@ @(r3.ןD!u
.+puIu/UPVoF	` u t	k@.9tމ^~u 蜿	t/ t^65^X)W~*  _f"S6!3Fs
Lt<
tw
uο 	-_^p	9)3WfV(()k6S
F f[tҋf_f^ff&`K,fa90 D AfVWUC t  f  h,#%1 LAh6 P这)Q0L5@hC*2rg&>Ut2g&FP3=EXYP/t5X\P%f3E
X f	]_f^Mf`Sfff = h=/f;r[B W,6
__S W_`E rgN
gnBr΀
G>> \fabEWfgf&Ffؠ ;PCIRu1g&{ u
;Kug&CufQg&Kf3ۋf	ffY_RU3tg;^5NE" h fT   !8]iQRWV^NV vq6'Q3NLYtMۋʫOw^_Z6QR0  t8 YfWV3f_f$ 5nLfPS.  <.+Fo+  f+ ~^)r

N^~u5蒯0jHj.ף  
 SflUVswRC	
ۀS2ۊ~f0m:`CtufЅ f.+\ftff.@# ^?
uF8Fuf_tu^ÑKVR.>+s$0s	Q.k6+.+|
?
ZJHy b2
F0+FPPx2P3N~ t4vf2f:f 1bFNNI.+ƔcjQRVWTQu'@j(.;+s0i0~ ˁ ;u
t`k3t@Ѵ `^rf(  _^ZY iWQ3.>+2 .ǅ0.ƅ2 ` P@hXU".+ .`y$t( m~t3.+ph7s sX/N/p`wFk@"~ 
N~f.4=6@.82ɠ00t,p9u4.B4f<t؋f  df$< F. 
1{Q3VF~r0F F;F  u~w
PfF@ M~fNf o pt
fNuu
ffsfF^PR4Q:
*q4vF$<u&0mVF ># ~ȃ$wp` :.ӊp<OO<uOs^`V@;+@..+;+/^Vp`&R0
81t	@
ui@9t/2ۿx@4
1^@818Rs7#37su:N PA<
t3 ;)Q6u=8Np_^Vuh fh^ G^5  `&RuS5510 ,=VW}fFb*3F*@+0*F~Պ^^>֊FՈF @3ױp.F f^Vaf^u? @ QV3{fz ufZ0^Yj!d055fN Nf~ tFt"fp29FvAFH;F`0ZܰQI A`9Fv2<fHf;F!=F׊F8F u0H[+q<fIr>>Af+ ;NsGP-p<^(tf+fؔ=`>
;d
S=fȀS~uEP&`͐i0A. N	
i+3jBj
fSVR`rAnu V 
v[u1H:MffARffPQЀ`2f&f;w
2~fPRfR(t#f3af -^ZfffNN 8ss4
tbWu+%H	afFvf ހ"^&^Zb]Wf.^~n1IP$^"8uffFՋN7_Q}V`vAFhu"ϋ~AX1`(A~n4oǇsVRfQFFu pm kv@kFh`bh$w$@y:@afrD ` w;=< u  r,.ir$<u r s0	 @pvFfYZ]VWӤ @fݻ~uRd
t"Nt?'t vnrv0 }xPSV޾ [3; t	p r^[ k [_#A['S^@8*pt@;v7!Pdtk~@Сt 1;FtFk^% Bk^ [a 3҃  V3k`
C*䊁"[;FuR,3Дt7tW-k	9	# a
@S
+FHu
4uGrvFvVoBs0;JVW΂tS5ދ[NuVp 3Wҋ°_&8 |@1-4FR>	{lH<8H`?CHP9A?+7Z &0VP~1\Ѝ02N~ tKvl09F1K.Q\$ 
fPQ3I> Ff qf
0M SQh+	 \P,Qk23QR.` tf.&!. .8+tѺ'l~
0qT $^jF  F_FѺFഏVfⲏ"]`ಏ A``q褺ј0ƀNp tFt'f1Uڀ삊P҂tmjրdbaf;>7АA/АאSАӐАъF8FП q %R0" UFS$ &T&5U(	U,Ui@ q!fv tEp0rtsӓ9FvP`Gb 3%ֽAjf.p쟊Ϳ kN03p
t
F%  .L  d>feF~ t(gwi^qСu
 v@a Jt#3t#ًËȁ wu !dx  vЫt'f# ٟff𡛐0
=srcE8.6 H                                                                                                                                                                                                                                                            o         PQRa&hF# $`Ȱ h$;rZYXSQWa$a$a_Y[2揺 TCA6  @A Q C@@ @;uYð!$p ~h(PRfW  舘 h2
fg&G`g&Od0 f_ZXJ.0hR
 h52h qPgdϻX`hТoc4whQhDB	3t*5h'\va LnhS,@ ؀  &}uu h(h
6\Wu- $@#h$!h)su h&/r#ذS%uShVS&hh fPSfQ3  h̓ـfgf&}8ˀ f`   {"fY[fXevø(fcbï` ##aP hub3tPQ% @ PQ= `t
3f3 @fYX _ 5ðd߫`@0d  UP07  }:F  Q ؿ
Et&؁ uM9NwN#uӃ~ t"F= wt%   +ȳ%=XhZc8`.0  	 5 a `hUC t*` u U'7ua9tf` ؜f ,  fVf@fغffffff% =a tfcbȝf 2pfTf D  	DPfað)W f5?s1$+fSQJfU%`a` 0f: ZF rf
0f%X_u720MYf* @K  f$.d2<w_fS߸ %쨿 uf9<r2Z/h 
2
m`6 h<as4
!5RڊĴ fh,G6f[XZ8!f٠8f`X2h$(r% s \\2	r-
t#y!"s!7DC5r[s Muo
NJefa!
't5<t1Jf JU@  
C<X Y Z $V    U  V WTQRVWK}3n<K9D9
` Rb"߃R&p`R[[_^ZT|+ >  > JA  T j M e M A@  9 Y .   n SȀA =a (
Wqw `\  +~\{!`]9àzK2 P f5!P`65f6,5  3s yp~O 6 5>x  .h}$S $<t4r [J! ыh63  e f`4 S  yq!oh=s% h۾t1h   D 3 "r<pZF2"mƾj_ǿ-r/ǿ r%@@9&5&D&ENƿ7Aa
p_hS P߿^p_y%xvV~^ 
8
3
~3
dE
OvǿC w0aǖ^&YU$=u&ǹf= =u &&&M
, fgh  0 pqr  <ABCDE xyz{|}   aSV S#
fh_fR8 r&2&48 r
&   8~"X ZfZbfX VC?f  `nff&u0V3
Ê^(.@(t.FuN.Ppq _XWfVUSW! ,fv߿ h.ӂ  ޿R&~22ك!IN܀3d	^
u
t_NA&>-_[]f^_Q!PVҿ&=;u&&p4u&^P
P< +&~&1E&DSV h2b^[þ:`[RW  Ws  f  <_@_ F10=ROM Based Setup  En?tering ; `. u  ; Qwt.߀ ;@P< Su)!`- W  );p 1A	A ; 1u;qreQp & ;tFò  Et
.>	t.Ut
(*!t h.PXhhtF12=Networkrvice BootWake On LANAttem[ptto %  ἠht8 0P< r	 AP<u Q<1IP	t/ i)tsR QP.P<$<+w( t<SOB1Ł"P<! ds@C	%4ؾ<^js ƈQE% VRyolNF 3؁?	uCFG~N0tG0h|ϒa{vshШZ^òP*+Notebook hard? drive MultiBay^"Dock!:b<#b (top)bottomy)leftf	Floppk  USBCD-!F HDis/SuperNIC*
!I123                         4@RP p 	 
@ʐ
Ao$P B [` ~@-r  pqlectvZDeb]  ͹U8 aond _mo@=the highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   &B<B(dB$P B'B;S A;Zip.F`u h d0ô0.BstԎB? A V3؊' tA<v<st1B& 2ٍ>2}4@Q#YAr	 hE P +G.B
*о}B @B+jjj(PjR-  B `BA z  ڢ  Ba R 2җ
   t03B2Ɋ lF8tFޣh $ Zbqq~p URVQ`.,.L.T^Y^Z]S,.B*[ݡQSVW/ s&QB.<.-00?00.0Y_^[YQrA u h2B = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰw`;2҂ Xʱ@
BAAr
;w2p=BJAơ}gFYô.*B<u2K  hChi hch
66d hu<u`B J qWo rf.>F%gf&G, @ f   PG0f@G, Nu
h)t~G,f",f_f fP QW2_Yf= TKSt?0 bo    ? o  J^  b؁.h%p.
W
g&Fg&Fg&F"t7g&ƷF0a 1 2H޾dG׎Ǎ~ذ:{ rsfG	 k  QRV~DTQF r&ew^ZYoGffL m(]~LрY`VU_fQWo
ِx
K&@
C' nC$C$0Grx  q## r]"0tsrg or70K:k;WQT r}Q GC""Y_r
E@t]^f[XQ!$&C"u#%$u̖!#,9ABM f.IPS [XAu,.6I0hSuf.IIDNU
 44NU`.ISfVx%rT$^3&Ýf 3(u
vu ^r q!} "пW3 hvcu ,`,hH{3&5cf_^`= vI OAI aP hF2$@<@X8OTf'pBRyJ f  uAJfP7QfJJ !,rPmit
&JP?fZfYfQ>Wht ffC@f>JFPtfB 2 oPsJáJ   Sf3fa8t4ff% fPAa0 2f0j%  c?  $?`,벡[?f fоPڋ@f< t6fJf;uËLt;-f;DuL@``f[`~qifۘ!i1 W( P1
ffd `f f $`XG3AYg&@ O W}0ff	 fff3c!JEr  БjWfӒ pW"lRFbGmf;X^fa`31Eg2ɱ ! 0 ]`% 
5PU&6a#
Ȋ
0iMFvE0jF
AkEk	AAWAEfZ#PQWҴi 
  f_Y=SQRWh2"
r__ZyPfPRf f |= t5fx$ޛ LZfX TC r9?9 r/ u t t`XR1$tut.ZSWQR H@^ f xȚŚU.@ /0  pqo$῟L͟ P.ZY_[ P  P P (  :H%0Lq   @    #  $@ @"@[鐞   `@	`   	=dp   p?v		A r ` Bo! 	a`g bBD!R
k`p QCp Ek  	f3
Z`
Zl `   lm 
T
PV1
!C
P	/e>A
  #aKC&Cz  :o :0Z{     @ {   B33۾ 6@8PAX R.:tc.D&&ɗ@ p p hɰɲp CL&> tuc ~rh^& 
f3C<thSt}  G2?}4 Q `t&G[q&'L5
F4vOs\q32ɴ*f&ȩ u0
ffK|&t&_fC0ۍɂɏkpqAMD Engineering Sample qAthlon(tm) 64 Mobix!TuriML-TSemprDy{XP? FX-m- model unknown Pro    ffVW Ӏ t尋?T  ^TtST`tH 	t=U}
t24 t'`U"!tPU"te#tU VQU.c bUf.Y^fRu f;uP
.fZ2 f0Ј`@06r_f^[` rS
 33RAusj AX_0[!
f&00+ SQVWϠJu3B_^ 	!BKCVR3
t<^f~
w/vtW.`okd4p3fft@[^IVQWfv h. ҖF&=ʋF&?p &A &CP&E&G0&Iޠ&K&M&O_Yf^y$ ؀Ȁ= r&821 tf652 
QͰ fAĻСۿfW UȎ؎f   { r`\u'P h{Ӌ" h&h1X`a huߴ_Zhaqf]@PRZQ V5 t%  sS fZ ffff>Zfh0g&; 	  u7)_f)`g&~/u!ށ /u/u/u	g&ttx3~	[rnf!7ǂ  uo	1/u/t r!;Z5±:                                                              U^e1UfU0m.ZZ?u h2CrW2rRrMZtf0f 0R|b t#;r"t A;  PJR  ZR f]L2j qV0r*6^  R Z rG	KuҀeAdB rC\A 3?Xyg&8E tPEG(V 	U	g\m r	\>Z	trԑlkӷQkpbgf&^C]#PW rt r
  GC_SRaPZt$ؤÚ$]W  _W}  sQ?p  aͰ!`P
@S P  	ð D v Sذ8 ÿ3 e R	Ǥ!
R'
[9//%QWjuptPX_Yù
 d h-Cx1s y
2  -<u4-u RR바a/R2020h<8< uZ#ȴ$? t	xJ  U[
	a8ڡVf  `P #^ hYª{h
àhs$nT/h 7Jh j®uva { r PQW 0> 3_YX
X
h%`c=~E <E$h_s	=C 3Cð   ! $!f`favPcF XʀF(V`3ؾL &>&DE>&&D >u d] j@ t}
 'Ȁ}	 > 33S^[tS[:? 2[sDy3 t^h@ӽSs
Jh#Kaàh̈D
ϰ<D L
p
E$ߠ<u D
@Q-Csd
rSi& uS]@` uL
 6 6u  u(X6є &uh
	\

u.0   mD&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	& ϴ t"& xu	߈\	PS   ? 0P'>_3& ?! W>	_[XB
wt+# P xt  t  w\DPV!$!"tKh10Q&,@ &  ^X  hSC!r!L	vTt
v`WU$/! $<vR@a@z3  v
p
u$"<uP>ȷX\PRt`J:1th)W!&ߊă쾁=0ZXr` 22ǿ&PCt5=tOu570: u	At!s96 u5 ~.o[s߃
t!V&Sq s   a
׿/YǷ3 r5s{&=  V P;u 0< ^  3f4G -@f_ ր }0 U!ߚ    -&egWʃO&MuO OqfGtM!t$Ot, t"OGr ǾJM0oOg&D/` 2%
<t29hFx21_kרt O<uLDHD =_7_D D	 d
z=X1:B]tSpprG&}	r??23P3t`hWa&ES$`	&M&]AH`.'	@[%o# r`S UՠRb ZW&= uAF:I)
h 
 m_XP
t G4" w! `؊|nFhrS#l NpL aRC (l aP uf3.f QRff`Nu @  tD  h5f#fh,6RW AS JV^#Ȑ

`PS@U#[Xr3{]rYT2
3

wh
 PeS fу["\$ p6@a&fc
<u	fpev @`֎h.o73۹ F
t):u%R3^D	& hI & 	 hB3Ga3 
3 9   Q~S'Du  @#[J rGAo> r;fQ  .<t*dJp&' t&A;+ 'r
r'+ Qqu8s& 0RkFtZPttp?k h YQ8?r@[r4f@q(u߀% = tR`Y*I@_HS3+6 
HHE&1E !,z 0rT}Th+ô>pxfaVA @`$P<Pt}RUZDAn1O  ZGpZ^QWV 0  Ph߂X@ 0V#i2(
3p'2ƀʀ?!C@m?r@Dt5,ϊu,u1 
@a

+&C3ɿ23&@]t  %
t&
0  5  Ӱ"   ( D}
u4: 7/b!	"	? A%w ^jPRWqA&A &]&U
t ˀAi] _ZXr#3һ -wf2C.U
/N<#hu&_ '߸^ @*
    8 ̀>u  'cU Y `]sWfS^~Xf3fSu 3 Q>aY3:uBE&8Uu8p]
R +B&U
ZK!ؾsvZ6fYB<)%qr ; ;e!	Q(0$
  5Ãh_Qf`8.
<t Z@mێûPV#
@F^fǐ  XaED
ByC IAn wmy|yUf`` Fwu. fafSfQf.uf fff#fYf[2VftGf   uIg@f;t&f 	F $f^`2ۈf`skkfaPP3_X.>u , . P	TACO F O 
!	& .?u 5<Fu fF_f.u  uF.uf.>u;E.u|@  tuttYputNp  D@SIVfB.|f$;VrTc%W B!:Z\ܐ	i %Qf2$fP'fffogf"'or. p u%f@cfPf.ffHpáfXf}df3ۃ!u+`s?I
s*"/S"Vf+f;wfff33RREuo4^q4'r44$.71p6ɐp08333  QW L% _F
3}5߃u'JE#ȩ t0 t 110't
Ήt} tWM_ } ,   ؉F EF^V/ SV^I uiQ` &t Y&  
 < tr&\]p &\׋U  
&iN!d 促
SR[}u	F@&a#F^[_Y#F FYBpTV'}ypVW0Пًذ' ! _^WfQSG Zfat
  [fY_` t =$PnPu2M{!t6 !s } tp( ` j &?&E?SRU Qj@6^]ZV` jo|Čq^XP
~*?F
  t# b  Qpl{F PFq d3duh<Ku`<Uu߿ùd `h4d & Xtû   h/B& h}& PhۜE'`Xÿ!$!"   °s}? /ehEr   tGt 4  hHs` tKu& &  
 ` hs@<t<uuв 
0u?1*w`P	h. 7Xh % P5 'D[%ys%aP?Xw$# )0)th`($} f.`?G  dj3 Dj@7    ; Z x     0N@`a#ehWr1fF3.% r 
\3ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہ.~r@V» 㐂ÿ< f ff @ffR@   f!NP
 ffFf3fvZfFsfBf{㰶f1 r9f3`ǿjfqP  fafPVa3v޸rF3PX

S,0<	v	,$.[W D`

Lb f s ^ fʀ
T
T0p s 	 
Sf_f q Ўfv￀U.Y, P:F q
uf^fNfV_f^pPrRp@*fVA6Fp2`hC@0Ϣ
0ff  fffffXphq p    `90W P9̈́ 6 aI)P*hsP, %ofPRh2R ĺZP $   lu9:Gu;6TsߺPB    P h1[PRf2MMSh#ZPSS$К8pq$~ q!
ʰĀuc̀!A tðv|tW
t<1w(<vYhV\{P0jEh3%_ P&
0
3q 33Ҋ%_tW۰/g.&;u;@.ont)@)h2ztu ؀a`2G@t03@ @u  o[
u9z3Q2,;y8#tN 

P%,j@rX?0AQr |X@YBSQ}2P5(a&& &0hkc h#Hu򿣶ɰ h
t[ Ȱ t
ŀv#t̰,5-PXv8v&> `tw`_P3 u $h$W
#RV2 s}.>8 uu2_2hSgu]߳uXP&
wL02 Q h2ƴu= Dt= tYԀ'
Y裱YP.8^Ze1رP #G@U ð Pf^ ]  `rr	 V&afOLPH      @6LP0;V(s
ɿu^V- ^"(P*^  2`}MqSP( 22< P*pX[údB  $@7R  ?Z`7              NtP(! % $  rxfL+  %rSr$rF!f+Df+\ r*Lr3w r@ . hJfa2  PR3? 0Z@AR `&Fd??^uhP&Xh r.>".#put 	AQR.#ߊh f3f%  fЎYURQSWF^
D= F\ ^F \^t
;v F;F
 < uWP  <022 IF t ~uޠ% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              $`ރ6.u;v` Ql0 >2h *Y2`"QwLQ0f&YCC`K (ݰ  2P3YaPSRP3@mn?[`H4$&%<GP֑  	 o t <BMtf3p赪TP2W X0 Hr
J޲RU3`fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	t   
 f@3t#ށ %t5ubfDqa $<@tS<tO`NBH$u>f=Pۊff+rCt Btq#Bt	ݱ]  f
рff60rVZ r 1Y`W3( h52tt_rހh`D trr	P}RW Z
xx ؎@  P.BB <t BB2J &ݾH   8u}!@屋`23Ұ
ShSt0`́ y aut0i at]U U[aSR  4hj
 h&ckZW[`-1~PԻ  h7-S	 h
 "B𑀵PaԀa$8uXRP<u6ZyQrtwvYu0ѹ }R0wZh)U2<Uؠ|u{ hT\q u
3Ҹ EF) ud^st" 8a ۣPf. UfQfRfUfVwf@Bh: r?sNrF 1f. ff_6f^fq7Yf.?>fGgffgf zuYKU q u, P3	fgf CPpeIfAwgaff.#f^9ujpfY'0    /tp ;+h 5LV	,  7Ne  hV+ m h" {6త5З>T jݳu	 TV3'UWtyU9#;auG;6
pw
4fYi &g 9  f%,"O [FfFB^faAhV p ^  
^gq``3a`<   o DTD_w R 0o 0 oȳh  1    l ( Pb @0 W HL P`A T W Xb, `
`! p@pؾ0x o A
|\DQWhCB3 3_  0 PQ= `tq @YX :SPBu
&ߣ p  ff& X[ fa&    i?r  ÒzAV|JVuO fQ K@hV./ۀז 軙V <tl~S tq.8ri."D.|u.:DtSI  wD:r5+s&v
uAm
c1DQRfW3cX
f@ 2f%?03a` 3	  "	f9`W pf3fPa0WfX A h ZlZv m fb  #&dD {	*ϻ ';sQSf  r5q B
 t
2 f'ƃ0
40 w
 [ffY+vf`z q_L2_& uZ=PrUf   uCf*1Iwf=`  t0  t( fzf
0"f߰h3 ;S
 "U1US$6п!Q2 f  tˀ0 g&fGfY#Mn~rC*@X'0
cffF &Ffg&{ t@sf @{f;~t	um~qNтV&î̟"aWfVfPXfXcr<w؀.gW0՞Л_ћcӑf@&ːtg&TfV83g&Pf  `&fnu=жtsaNu(g&fVff"oȀf+)^f^u2u  w & PP0Xt'v t
t]@W % r/o h>u hͶst-3&> nrqr~RzsRƑuth<$uul	r` 	 +Zÿjj b6u|S`` FF phb ru
O@ @kff  ؀>t !$!֕$< uRCps 
N<_2<ă}Ɓ	"3A'y@h[u TYP=Gt 
u2Ɋ،@3Ћt<u
E< tȵE$<u&w $tRV-L  N L Nfڰu ûН t_  P[u
j j4Y!gQU(!!2(<!Q~e$ h5u$0kt}$~A.#K,.t4&^ <r&w 3.\  5!.\e@.d b    W	x .|h5"_DuQ&~% t P藦Xӹ
 .:t
 ._
vXP%8Xr6%țf
6J3;LѲ    PJNL p      QKOMp {@Kt  Jt P(.ߊDGH oh2|h  hvQ߂ h҅ hE Б?E^  ` f  Cp m& OE 
v %&Mt&:
&;r"`p$`t1^TKub 
HM` `(q @" sr#	cdp&3a wC 	H ]r5r`2gpjh!/VvZ7aVRQShk4ThmuJ.`PZ68u,2
t&62@t2 sk ޝ[YZ^Sû Ph.X<?tFhSUujjjj PR- &{hX\ hMcY$vbwt = ;t= Dt
h)sp[w@WVS$ћ$
5[? j@n< u"*׿OطhLt`-->J=Ot1 t~Sd rh  SX  g 0 hL  5[ ?  :N2ށ?Aq% p 	
   VOFgbǋVW02_2µzt"@uG2 
u
2U _
r2E2&&ߋ&EA &e?
td&E&&E E &E<r&}	r@ VW^2й^2*à
&}vPu߶h_VRPRQ3f 
%*t,Y0@RZh$>tu	pp Є> uqQ@ɰ5~rXYj-: t4I
z*֮hC&&  t8t' u a,& nWq00r6$^$ 2Z& && ;`Z@ `dde`P`  X#U @ڰ
ڹ @ .笋PB B把8uG` A ; 5䋀/䉮)@#;BS 76VŜPX
 a@WA@ B C W   ÜFtV$𻰂%Ȱ%<;weċ X؊<wM3ɆQ#"XR߹<  YыƊȊĴ3ЇуsE pY8@C0	 FWYuF5<uz`s0Df&	2
pu8f߻h2ePӀk{ 'BԬ@. ,".  &k ~!< uf& b$
r wAu%1uhhӲ$ݡs}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁߎh9ҭfMKff
fZhZf3f3ɹ f Zf0m f+fZ ! KLu*LL3sV4C\` a^_^fZfYf[fv3h 5U`2|K 揀L0s< |&?	3ytvo;u4PP 6-t
s#AQ}KBC Kernel: xx.xxo
 `$ pK    t?  .\3۸ 2ҹ*@GaaÍ6h{$VWao=ǐz_^p[` hΫ"eh  uP$<XI"sf _@  t<   4 r	.$<u
 f3hh. 
d]XiJ	h)0=  tdbw_3s.>Nfm ;thtC	
A!U2 u@? o > `c 3Fd@ e f Fc~ce@7~e uQ@C9  hӳ`5
eP	3huBFe:Ffu1wr,
 h
 Fdt;   	:  <g htQh`!af`7UPKh3u>fB05SCA[t$w N hD&N r hPf0̾   F^P XSĻ  y ,    hb-[t(t@_t,Vj Pj,>" ' À thtZdúߋw."ڴ**=ED/.EqEd]+Ë؀F/VU2NfQa dYF :uE]Àg33t
?t
uP1t#u
tN`2t"FF0u3! :5tFFdz ulmb9p`F: uYeb +Πu"<6F1 ep0Fwff`Fup  0j(j	R"	aURϵhT2  ɺ )1 h- Z]ÓoR+Zr@!  tCgRQ QK.YsY2$
 !u$0idU|Z f`3 w 3uW fI%.&"^f  sCh.
>C ƀu8u.> 1fa
ZURtLޱUHh2k:Yn Yp to(tq ;CPZi@"ƽg  squ4@VfRf恎h~|0;^f[r]8" ۡ[Z߂bh3Vr s 諈6Sj@ 2P s rGZi5'_UqWqW`.uQ$<u:`pKr"&  t  tt tAt $uPq9S(
ː

 {`XSQ 3u,S?蘱w[rE	ˡ-Y[C& <fÿf<`00xx00`||	>>.r tr~_ (ЃrL]CX̀'tCTG =`Q<Q7=W &TʽZs6C  E ц߆ԆrB zuN! D 蓮/u 0/)0\/f#-}&A ;q5 F -7&/|0W aUfV3vCDPDQD 7@4?f^]&໠QPЂJ wPduXd@I(aߏ@ `O` ͟/////- "  @f%p괽к FACSPJ DBGP4BHP=  0944 A|!  8  APICZOnK	a	
@  	  MCFG<	P	 P    @   @ w ^
 2! RSDT(  	f`h\jhs&f  fh`pfp  gfF_gf  FPTR ff0WgFpf~ f.p^$f3.˽.Ƚf.Ľf`N0~$f+@htS
f3ffgf&_f.>f(.߽tȽ22@_~( N g&F	f P  rgfffff+f+.̽ނ
aL.>f
$$X#DPXff-qAFV3g&fFgY[@ff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt@HбQr< uBONRUfQъ̓2 tPpx@rAr} v; tg&P)XfY8]VfWfV*f& fP&]ؐ@(#f"fP)6Ȁ$ 4 
Ȱ ּ
ff	Ohucp (fq t { his>fPWuCfX3 qdZ$~c g un+
h2< ~;g&h&P_g  PSVȽɽ ˽ p,J$<u	@̽^PR 	ZSǸSSwuP=qP3h f&L fy0=EpL fX `h" 03fО&?    6u    ?OG@f3{ p Cր   U!ߛ   D>-&geE E puMPMGGofEtXAt$Ot3 t)O$fM
rQpmMe&Da|żU  r.]hF2.<gP6  ø׳ gWY!f
hg5fef h52ttӿ th3뭿  Pio_DVΎ?=^`ңf`FF  h7 }uPm h,6  $g(,0w4'8  
Ã9FtFfNDF> hDɀuh(fa`c~
Eq13ɊMhCt

h ;r#uacWF^P}hcf fN0YѸNAf.9=4u A4tcH rfQPH_rf;^uf;Nt;~f!t)  |
tF~U;_E _t߿ 2p> A MɋQȱ2۸?W
 PM^@`CZQQRWV ft
fq ^_XO0O@>wg1xGuVf gi0 tf%ffd@訧~ 4  taB| Q	Qߋf 9ΘlQV2	
g&GgP u	G_3^YS@8ߋB H. 6 f!kRWG_Z[SdG_T6:4/  vCI ELA GDA SXC TGA R VfS .o` f;.uf?[^f`r't'æ  (6r(R#6I$C$#c*# #$##ڑ#i#ib#tS+ԱE)iw@j]g r r r
Y2Ko#o#e#j#WPR R f?F ZX_O%K%M%J%J%G%<F$ s s
G1Rз
G% t	t;H 2y{ 

 2t9 3
ZS0d2tS _1_fatAo"  F
3   t'0gfy Gh)~G$L<LDCOMPAQ PC Card Smart ReaderGEMPLUS GPR400?PSCR CLB REFLEX 20241? PCMCI9}Reflex v.2$c:r$HP
  a@!g&O@ Gd`P ߳ rLfK ser>G	 .D
A O@.d.D?4f_ PQW8 .
G.g&:uG Y.5 _0iQ8t<tBF 
fW
"
@
@B g"

2%Qf_t|`S蟈h)0Cu#{ | 0u0 .u = Ў~1rp&tj  t_& rT  r&= us}6>
r/6r4.ߎ؋V@< t ^`Jv 
w x y   h-3^h/~z nD
ZehCaa
qTrPqtI	fzE
u 
!tQ&׊pC{	GYSQRV
},`؍vfD   ,PffL s-<t(<#Ȁ06~ h.L}^ZY[U32t
t
u
5# t u9<0r<9w/tM> ~7SQ Y[t>"$,0>*SQLiE;f 	tus]sf`Pػ3Ҡ&&hq#ֿfv*`%h.gf95t0Xa` 2 @u  0 thcbR egf@ Vff3u"gfY1d Ff azf? t
P!@޾S3۹: 8tCRP #hFRjt rXPhf ufXP  0 @? 0  u0     n'  ' D 
 Y/ bbk$Qrs@GY kv`-4PS_.KrVW Ԍ׎Ǎ~Qr&} uBr	: v_^d>r5r!r\E@&=u	# #Hr&E$7u
5M`s14RY
r&a)B DTtr?&e`4o5
ՈD
߉T3
54Sr#itct  t$BffL V 	] 	WQ
Rՠ3q
]
f׿ל94i+Wz Pr8u`_QY_ þL[ r&UN7>L螳`
Pw4$X` $2LnB }0<tH`8u6
uBp & DBlT
aP `3 r/) r%BB!J@ 
; 05 aù<t

B J 2@u8` ~BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri ~ racñ  tAc rF n r:i r5&D@u-&~a$vQ> Yr	{2Qid'Y߬B@Aq BrF蹐2Á^	pb3u   @ `ңPX H  	 
 
 # /F 

TB B`{ @ OF5
@@ Q
@ B
@
 @ B	 U
@@D
A

@
$@ 
 G j @@ B
LL 
@ @I *

M" =
#  B$E
@#@(H S ^$v2u)w"g&~ԑ t	"u 
RCMO
 N150X3-L07@LGPhilipsLCD
LP08-A_3

AUHBAG01V2QUANTADISPLAYQD15XL061E06K1SAMSUNGcLTAP=G@1
TMD141ECJE N41XB2
              !Ȏ061ӳr[>e  >Y w 6`3Ҁ7BPa 8u!!u
( H 8ut	3ҋʸFPW
 
_t_   @ك
_XÔ   s    SETU ˸ @؎&м  i r' W@ P& u_SV  GG0G huߚ#    Gu Fu t3  hC) 
h jBt & ^[SO
&hV" [U샿VWƿF F@    =c F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @,<qt	dR>t <tjjjj3PR- .w j5$<t.<@t$t = ;t= DP6 h)  揿  7FF~ t#^F&Lr
F FQ  ~ wt: ] f
 h`0\2%PFA~ t
F_^Q
hv;ss.&udu   hc,$?ػ hE."hk *#h>*f_01Fh[B%..  @  Y(`p3WVe1E0E.WV .^_UP)UIQS6(6*`e1E0eEE.U s@ m2a hF4$ex57;$!<$:a3qr  utw
t1w
tQCPSQW33۹ G&._/N_Y[X   sc1@ @ p^ B     6]xsqUmf* %  < ! 1C  3	?
 x  QVWAu% p u 6W  = <tKPS"eThz#U{\$"8u! [XAB.o`._^Y~RW W   [Crr3ɺ {ڑ܋_AB rN /_Z S\5OOO
p]TujvȞzQPSJA DE<@ ;<<!<3VXu RRSt
vSm[VfPfSfQssf3f3sPssXfffDDG(	Dh f?Yf[fX^y# OgO Gx!t{QRG3ۊÅ? 0x Cҋ|B`sfDf3ۋfOË\` 	
C  A	T U S V i	}				`hA	 |hI	  hi	 h}	 h	 h	 h	 a!|v.L.< t)F.63.PF.h8a[+V..^̋] pDF. P .h/nXhu ؃9R  16W  0"Xa Y Z #[  
\a av _BA]a f g'^a b ` `hcij!k qp10G pppQW>@t		 u		.	_7   ?O 4a9@Xһ -w C.%/2@0m?n8o7\3۸ U _d߸^d>QRrPS6[XhM(! lЍыh
3     u     KBC  [m( Vn   Q LGB=   0{+&!	!$12/15/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;X   03/30/05E&02/09/06 kTOaos  {-1|5?|6|.TU"x#T[T0?	T@ 
t/{3" 6xgv$ÔdPx>0@Z"2""Pf."hx xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`@pcłŃ 瀾xD¯01u4ү0dK01"xt}ി
~0"x_vvuu˰*x!Du(u)u*) + 5FGuu!csүx00P!m}Dxg``
$`$p
	_p 
x c
qx2x txDE0SxxxxiD@Н.}p~}@ w p :}d`xG}BF &0x}D
¯00xtxtyuu *}nb}uus U}|c-,"(ʱxmD0p1w  x^Dx_T_xcDxfT p# + .`FUvR
,&V0¡APJ	P1Tx"03B

x~p4T00ߴ0} !T_h _ %%u"`	T`#9 *n08`i	*_P	<G\	+u+$J4?jq~T+}'b+p (++@^Y,,G
@ H
0%1vP8",`^W00}@k+.@ /2 ("  "+;x&x+x_`t ;":}
PU  !	 ~ @}A}
xPxt"xf}Bސ}E!"* a0}=
Z#C?0 0x )xk`xl  p~ 0S+;`/TB+x+ ¯0+90 b 9gP4.L+P20B)+`xN	+ xTx !
+:XDTBK	PFp y+P>

0C \Tdp+$!$P+-` 8P` ~Ô2@YD0¯xx7x8r x008`:%$0: AT@H`	p4U$n"s@_(ZmZ0050+xDp A P 
@`Up[Hӟ@F7_"0\0\t# `P\Ax, Yxtx0x,AC0TG0xT?Tx*\-tx+b]ZBTxIY^P^B_PRQɿ*	AbGo`ao Auxc_FNF0=   >y.PZ>RgxfOpb	>;Z3h0oS@*ATx-	+_UTNx*UMx+` N `T0 
 teS`
 TURR1b 0X  U i G]X=YxZAYAZNSZMY}Z$0[Pmp^q\1\T`P\1:
[\]Pq0c1^^T U^
r]	^S2A}@ A}=@ A $.354A~_ B~a  9A~` uuҌ""7x'8
\ p07d`!7k33TT7?OC 17`'`2`=`HpQx_ 6uuuuo2 uu0 u_u5ˏʿO$ƨpN`0T`
0320pAqAAL| }({x_Ь"+,?,E+p
0 +D,,+ +,+x,+0p}!,,,++xa,,"o-.T0s@M72t
Mt&@Jpd `1gb11_tU!(0響/0mp/l`
/0d@1T ~E2APY.-Ϯ/0$" *xe"+xt`
o3x7x8NW7tl"[C[Z#Zc¹d!"xeB[]p^x,H 9  G  < .0F1/5 , =Q@!"    V q -; x U:   yP sW# $ )z  p 28 3 
{>a\dfUP	`[_
eVQ4c7j6h&b%](i'g+lX;oZ|?~|2Kd		

!$(+.2   & % . 6 = > F E N U j f 
   
- , 5 < C D M T [ ] X   # + 4 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >Wg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~@   2 Y	J @ | @ s   ww ~~ r  "G9x4D` T0` D܀)dZDx2tx1tI.([0( (xsvv (xsk[EXxu%& ' ' $2x1 	ү  ¯0 @&$@K@3%b0$	Mx3E
r eJ"xtOF`0W@ p%" (	x30&g0'<T`P%"xubfp
0$&""tY.4} 
xu$3z 
`Hpx`p$X$ yuppxqv"x0	D0$$6Ӕ@TxyD?"0p4hUxOox@ DT 0
9 clpB"pxw1xxx"xwxxxxx	"xz#xy6P{2yyxzf`Ӏpxz ( QPvkRB|@
"00#+00Hu0Q Qu0H0# 01
*#1HQd*~8F  K~0#HD w=16w/(w!a0#0
	0\0#dH"zR1¯p9@x1"p|u (TQ""3453/:NP"3554!_Q0		"0#xqo`xcT`q}-xpqv`,r"3}TOp0@0 0 
,P:aH /\ P'2zB0P`?Ӏ2 a";<n "0a T?2u$40<S0#{z}yI237=
uw= <+
`=;0=;0;@2$h'0@^ap4?
Q

Сפ$RY
0

@À{0-$`
$`$p!рAa"iV4#K0# :0!h@À-0
  R s	2<0#
2xqfKr0*2d|p0<SH{zyQ xrvJ%_`gK<P2 ( 	\4 Ϣ "^H	5345q3`	t%5544r
@ :0
h0"0<`	Z2A0<< LTWr@1 
 "
 ,90 B <, 
j	" #!`BQ
p0(? <!^ 
-NU
]DU <.
j'|	20#G+A6,`,zcf-e2pO7)0	LP85p
b3|&Ҕ0g5p	z6w	0 Qy":"08l8;rfpO:2s`#/c)P3
Cxp`qe`?0}?Dp h,1g,#a,a b}j]"4x,MNOpxD Ue4`^}W Vp0
T4d`#"4#?p~}j4xdW@3 0
3 #`3`3$`j$`6$p$$`>$`$`.3$`qT$0 DQpAh0TxvSKv`@906{%	 h`@`Dx@[30p	3]eP Cp 	`r搬? &¯3`Ҡ@
 %TV`xm  N* .xv
xD}T&0{ ^`
}nT?DtS䀑PuYT|T#@`T`R	067``$pa1e7`tg7r))D*)б@?']0+a a
Td`x0dp#  xF PTÔP
@*tuxBBzxNUN|}wxJqJp:;<tR/?=*x ү!:%$Jt=t=;2*0 *=$Px`vT"` 2'<x"3yގ:; 0* ;:@ p0 xvs6xV86}'bp p 7  %76'7  ""88Ô@ p/pP(@  /..d`
&V~$r7(ϊTP5O( 4 40405`P453``/`@$pN߅54:$I&du*);*P [x 
33oppGҽ,L1>gp1 !';0P"T~ -P2v?T#>үd`pxH 8@22P65bi3e1@dx>1/ 
m
@d+0xA%30 B1m
@
 E`n00
TD?T@5q0	 3:X@at AP}St
 u{2P2btlE@
.
@	  r1l0dpe`30qDxF10U5@2`ee bC7xnu30 0u3r2+;(t}1123#.1}p<0 $3G2  a<0 }
1pAR E>rpMt"pڱ  d-u+x0,u.`2:,]4 2UU.X5-,*	w 2732pha,
$_+O!% *R5 
Q'x`S+0	+_ -R	++`@۟g@`p7{v@}	 `@~=A0y!T``!&_`q VWy
7pDxp.LDy?N%@k53Eop'CD-.qXTQQu:93: !p	S31eB3dUA`h>y%%Ovt0QON@pHR/ N9
d.|0
`0
X6Fp0X-64F0570`Y5#O0]c6Fe`	S8@1
|!b-11%P/g;u1
p< u11PA{p4z5z5
3z,-yuv {| A- 90!& nPkT0 -	al:pd01O0!upo6o,/-{.rpFB}}0
P/.-rdctR%,@f Wu tq70YS 8S;"W4`p1PBŐ}?BT__0=_<I?`$:<p:T0Oő7]8e`pYלBxiTAx`R%dcz0  87>P$3q"WP¥A3	``uqq
r	1Q`{0[
}
9ȷrdP9$$P6"{ 2F}R&e'AChS4Iq}va  X@apR`pLxpG3p?$u]1U^#5_`@TU`#v@|T kx{}Qxzp Wxy U{xxPVxwRxv0Hxuxoxtxcxs`xrxqxxpx`x|Q{x{`WxzUxy@VxxRxw Hxvxoxup&xtPxsxrxxqxx_p"pxmv00,pTxiLү4" /4,m0{/TxiQi/_p0P S/^##~----i C2v?V",u/2ώ12B0T-/21Կ^ L-. 'q,xĐ/$7`,T{AO-.`۷pGQN.E.NJP7`0p60Y)!)y0h
PI5
Ps|?`d7]}TPn,rtar4֒N0!`a2vЕ
p1
P

Q "u- 09r"l } }tn1vg8,  yA3.020.pM=1s0D@dT0u`zP;DڰS,c,u?.B.`] 2 p0`u.Tag1C
.{%TOлQN](03p	 `` 9uWb  $ 9)NӔ@6S ? x0!  x50Qq7prrqxvWU@	Xu

	1	0
  `
7cP"q ד
G!/op_TrAL`>M)60.T`@}w}S?AP33TB{DWD  Axm6"@t C9x;VxFd`Tk`HT
xPM>@nC!3"x+_ "W\]=@0Qqڢ97F 03ctJv`
pWr +J)?) )BP_\P` qw0P `	qPa"PQ;.eB"{TQEP Є15n`<栊;<A<aYpo0:BP e0!JI$:1PJ1銰,F;KF4	D0c
^"CO`@?"JKOv30aA!Kd/p`w@0tt A2bKB)L``LKxqvJK;"xFGxGHxEIxFt@0* HT.`xHH0xI@Ft"*"Hw> 0 I="xB!C!A!B/)BF*( #NA
OA
MA
N/I
N+)D
JaKJaIaJ/iJK
I
cL{MNOd`NPJKT&` v0uM M@ 
?ONtS QPJML}n}u}}|EAMI#..C.h Ô@"#;  #xh· ;#"VxDoTpVA0p ?$0,H;5ޠD}@qTTJE}Sp*WAAA@@@@@@@@@@@f@M@E@1  A*BQJJ" tddr! tG"xdqx o "BpD)6X	SJ#q! * 	A] _>qX`S~ [X$`RAB$B#WӔ@fW1OW0	xqZÀӿ"}vW`#`5`2$pCxD#4SS [CxcWWT-xps& NYq 
xl0x GÔ@π<PTxlC<Ӕ@`Bzr
T"  PtlxhxrPc?v+xpv2P8Put04}tt  }I""YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATUB¶RBAC܁@>*F?}Emtb $zEՁ0W`Wd`)tuWRBDSD_DkDvDDDDDDEEE!E0Eo8EO BEmBo>D 0rtSpA$9 p C¿"-AE
mCPT gޗ@LɎ0M7 Q&Tߎ F 7@UxZF!R
hrap>@X P`A@8aO0D=Dd
``Dd`(`0<`PdP`d`WۏuW0>NSr֐ʍt Ϗtd	RxtxYxXx\x]txat"xbt2xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx`[#x> x=tp x@t	p0xTВ
}'xt&"Ttx!TTTD	x?D@:xTT@=TT	Tx= q
@TxDp?=DmDTxmv0}HtU V eR@eWeUeQ }T:"x0xJ"xj;/L"B S?/?@?`$tO>$-"T0`Ô
P~0~7%W{W@eVV7%VV{ z yV HW H^+Hf3Hn4Hv6H~7H8H9H:H;H<  HOVY1	 Q
 I`A 91~5GُV& 8 `;cuVuVK0V"$`($`*`u- x/arp4P
TQB  HqRb V U"WQV$```$$`(`7`F$cpH[	A^Y@
:w3
2! *}0WP6 `#'0A~``,`003`G`[$ap]Vp^X"V W dpF^`0$s !`!D}Twwq0!$ V0 W "S}$pT_PLSd`PESxjSÔ PSGH,q@P
pKPxjv@JJґJҒJғJߤJKK K;KVK^KoKwK~KKKKKKKKKLLL:LTLeLjLoLtLL  L0
`2v"x,MNO`uTTTsx}j]  xD  "%	"0T~Z
T:p; @x"} HG}}U0~"uU@	0SUTU0CU0z 0P 0@4xc]tjveaaDvQMP0mxTxmD0FxǐHxbx"x@$xx"x`}K}IF	
Q@PM0""3GxV| } ~ I4S_*N QTT &NL((sMMN'N6NANLNRN]M=MEMUM MMNfNzNNN.?AÔ`P/."T?ޣ } 00xe`"SfUS1J0pV	`Ь50T:uS0r  030)	0PU":C$p
:!/0Sp,"xdP P0A38"o~}j 0?IT3AP>2Ir1cc!0M}EA@JWC`X .YpNZ S mT0ɑP O/0#0xD TxPk !1?xxkv p T AApB11u32}'b  $31T3322@"Ox0  "}'W ]"   p}"/*O0/Ô/pC0S00O2v00  "
xp0 "7x ɰ2345&@"(t?3t 2x325R4U5B UcwxQxQDQx#␖Q  09|:x0S_enS 
CSQCQ>Q}QR	5 S SHShSoS|S:x
/0Qx
t/P
0/xu
  x
Q{P^x
! &	:0%t %T 'Qxv	}YBxu0xußP2P/0 pw%@$Y$ÞPxxua 	^1^,-u7. <T*4ү$`&0p<PC4} % Bx.-,:	'xxvӔO@vP$(xuvyußxvP!  &߀0 	r:
pxv :t`x,
 !V @	 -xx
xb "x	6:S/_@P*C"p :0:Pe@S SSSSSTWT	T_
  U{xiDܤ D@@"?xDcV`$P`?`3@zTOBX X  -oD"p{;:Ti`S/AE@E ,@@CZEun Op@ | 33TOB β@^05"<`p}T `8 .5,,F4S, 5S,`xgv  ?vS,,"+,/0.V}ĐVZx	` }xNJVZu0 u1Txh`-30(Ӕ
P!23	D3E2`NXSS0S3u2 u42U03U1Np1%1030444P-5xp7x	410	^_
5?5.Ӕ@xA 2w X:0c
`/p00Ӕ@10.	`	pWWW%W6WVWWWWWXXX(X6XX$Xr%X~&X+X,X-  Xs.:S	Xxu/@xwPFPa_-.a_P
_.-]	
x3t?e.pt e-0`p	pQp"	`ExpP@};}t*^
/!  2#t_g.Qg[v  } q} UpQ t u vAO}}	}5̐R) 1Q!q^\"/00 ,+"7_ |Zl Y
YYY"Y)Y0Y7YO	YVY]YdYkYuYYYYYZ@3ZQ4Z\  ZW\Z\ ]s  S1
tGt)%}#	
pbu&eO HDppTSWT0BS
:^ qе'@PI4p^P  h``!!M0\0t(1D8bj`rOk##Q
 x-Rp
*S`DT,T
NpB_"gD C-g`/d	`+d
`&t .Ս`]`Ӕ@"À--[.t %-ee.`.:--Ô@H[oZ[`to.`K@`/U.`"U/`##,/@cÔ@%O
	"x
xxt "-$qqT"xQ "500}r 5 "242b   _" \"`2\\\\\ZS\U\Y\Pb\|l\lv\|    j"xnq 0 "00	­Plpx#1l^3Pp T  U
0k33%$!{_0e2pL2640#0*4'r
4@srqv"Ô
@o"4A_{4$`'$`:`C`L`U$`]o`n$W`^`ޯ[P s_00f_QR"02. 0	zqv3$4A`:`b4p-Ѐ
"D"""" `"$`a`,`I$pe	#a2]!Y	0#xtWB	G&=}^%0aT~t@"Ô@Pp@@-	T4"` Ox~ d$ "rӀPԐ}tP0	t_&x0x!TT`Dƨ0
0T!D`!To1 7dxDBe"  ScvL	\
l|b
E=>C	D
WX~x`!JP ^`_c"
%ޠF`7 _0x+ +byx`nqaŏ+s+I `C00+xT :} 2p.5c DT_`a pmTT` /0	:1 aS 
0cx	+$```9`B$0axv pz q DxT"ҎxStTTH`+xS+<x, :,?`$op#+pxSwx+	x0:00!Aг
~
0`J ց".k@-Ӕ@	}-P8-$``
$dp<00yC.t}.l+ dPO`[D}nT\PG@1r@}aP-Bp}} ̏.md	C[.	.@;1~`J$`S`XqQh$epj..
aճcK.!ԩ"dpsѫi.0ӀiÀ~T: Lxn..TO>xh.881.T{P{ Foj<ӛP	ӝQ~`<Þ ղd`OÝ@ӛ@*ÝP?@Au (t}/؁o<t"Pð0@*` 0I"xip,E"ј 	/014u5Pu<$t}5}/dee_eyeeeeeef*fDfDfgfgfffg=g=g|g|ggh8h8h[h[h~h~hhhīhĬhhi,i,iqiqiiiiiνiξiijjj+j+jMjMjMjMjojo  j~P0* pC3/}u? u@ uA3{cR4jT13_66b~ 6` `cR3`u3pwuu?u@}uA{xu{{X$:?@A{&5hgR0Ր G 'h)g

J-X>*05EE` } P0C3+1!~ .`| }` @^_IN0"`"!"UH
$J*
#5'((INp:Id @(
cC 001{ 7'+'(.))X0,/,28.17.4h03Jg0o.|U{12rPAA$__TW&A1 u2dG'XA=9='XEFxBwBH˪DD(KFZFSo UHH#MPU6]P!}UqBfP"/"UPπu3//ZC4"$y`y`Д!SPkqp ? "BC~L`j@Ok$ka`P'C`$$xvB}}Y} Zz  [xsDDxvPD_Q~p0&70%"Cp
 @"µ'@COPr+ 	 	Z	U	[ 
 
\
Dxv+		 "<=>x>T?Q
3=T_@A`dPlPAk@ I IPw0?p "0=j } P' =@
఑| $ ><=>h@	v`lUdn Ep6"}`~N }0pzQ l#x@!2fNݐ}А0ÐMTTo, t
䣠"D@qT1}I>+~ s++.
~N1e2Q^H`v
l@&ހp0u,߄~qg2 
82omm"28Pnv2xg ~:0:
 1!{ :'\}pp
T?T`8"8"u2<0m0`{~@~^y 0TODմ001p_322\* u1C00] 	3`oP`; t2PD=2B32Cp0;7Z P0`&R m@P}`x@"P3"0 0T;_O"P
0._$  ;p077+e0`0>f1_V҇e1po0o.10o ~c S 0`KgMc8 	1DS%K@T1`@?:C:p*"45675E4`~154@hP
 (4g77$bTo`wM3`TM0=`` `'wp-1>TÍr C D4g h0a#0hCD/rABÔZ	)u1au0( 2u0	0}}]p2~ Qb|ӝꀣ2u2u0P*< $3@`20C@'a@u'
L`SnV1@\qD^p:p7006`ATTT%%Oj8)=XDp=3`"{`@
	0d`60p_1ZQ[Nt?`<5A?Dp*3tqT8(	 "a F+@P!/0	<2`dO"Q!K"$%'Nd%tl޾$	??ꨈ
($	*6
??(Vtx
75UR}{zyiUh7v
dh0v
08.<t p_u/'P~ q./dq5%tZt g~@_Z4rQpu/@ pT0oN`kl<2otZ	ÔPt}lA䑖o`ЯP~`x4589@ o943;3  w
((swLwwwxxWyyyzr{|}}r}~X~y~~~~	{ z y4l5P4F @w
%QgR1TzR2Aq3D#-t~5{u4`u5g 	]4T`pd`рQ:?
p0
PF$t	ݑ	uq֡LnlZ}С}O pm1hhhPK5 }
Np&|00th9x0'
b}67d6N67"PnRId2/+F@e5p4l`&IA u:):2DH| `z {D` @\o]L
xt:;;;?::;!QY!d:`;!
@&2nB0gC'_ c	[;:&d3^;яP6q00D
8 F FPEP{dLp{|t+#II<~T_B[8mpl`??\,@qҾ7dNptOLVK`UOKK;U|1Np7>	 r^HQՏo`ppNVSYSSni{/Ty'P#vZ/i T2f(RP?`iJk&bm)<o=!q>1s?PMnq iаլQ}lIDL3T-K0dn0Ö,78v3 ;pv3kU<[R~Ƌ{z'y x wA:Q PpS8XÔ8@ 33P03H94{8055(@5 c
`44 jÔ`40<q? 305=C
@$}3)Su?@A{?cR&00vw"2;e}3$`DТma c ${~ 2|p{u3 #ux;yGdE`   b&a>t8u@PJÔ|@u3aמ~ZPt;p	9@TT Np: ! );4u3
tu
q$e3`3U;1`08!ْ܇ s!ېs01 0ҠEe03C1UATqO僟1p}2`}@6"u0x̯03}QY%̐~
N0J:>f2pP.u2f	op`8
0ٞ
``Fӕ1)100AxgT`p?$31dtPw6"u}`q 
""w"`tȰt P
7U06	~MTD"LIO_N ~S mp`({пP Sx33| }d^"^~ g}@PI~Wp2btjP222  ~^2~Rp4[4T4SPS@~Qtu4<Q42&4òu3u3JpU@:Y?P~V	@t
3'~]p~ <@3Pnw~Y"00~X"/0"534u5$*``0$pB/} au@~uAW{ a4E`֮eX{c/׮S{=3//u? u@ uA3/r4"/
`  Y"p	` JXUn"?/"LZ!?  ]!QNWtPO\tw- =P`ppB-ӟ@
-က  e-`P  IAptR`
Pp-"\̐VT3p,QnQS, `"q  pn@W^qni n&i`\A`ʐU..PUc%,'`-lP_,vt@p,0A6	b"<x9p_P
 D?wT}:>@a"_@C~ d$qSÀӲ  0d"0{0"7PI8`@
D #	xI
~,֠T g8"mbNp 611
j_{Pj"`a@"x0px 	*âfiS?1O?~ 
0z {`  on`dx"7@8uVnX`,7bPNP O{ Pnp	84g^k8$Bu"I;9 <u=98~ae9p8lpe;@/9E8 `v@@~+P"~U
`rp$]{_{::Ӕ@@u:@ux#>1+	: +>x@+:wQ p=pk ;px
809P/0>e<`rp=9=?@uA9<`F P0x@@p?@?@;A99A@@	x&T 0"%oT~ O8&03@"`Ta""x!To`	TT 68O3o` H2D"E
~@Epx!7P?4r 10*Dϐ~`o`fS+ `1K >dI&A/t"u;2<@F<9@Ju;;;` F FP P9:9@} ,-x>E^`c  xTr--,Ð,P	xF G~EDaHaFT56MBEW66@55:
MI"¯pD!PBU*" 
-z
@_&!T vUFG\4^xt " Q%T0xT?T1aZ4TDx!D@p
0g1d[pa3b'331P31Qw@ނ
4`/@\4V-%%q
O0`f@g0/OTpk\		_Qi~__` B$#A"r%"	F	 >o	@2xpd'X LҀƀԀi u3ꀚڀʀ3䓣łŃ 
`	"3/$ ̈$ P ##EN``#fsB"P""):"P%0 "b``"ο.` "  )"u/33@p " 3@P"Ø"0	Ý0 ߟfr{0"(p p8@
!	P	{t	1a
bo*2	1	"wt 
""̋,a   ͨ-8%~`,5P`.9<꿤-5 "BBE"""ЃЂP  tsnt6 s.ŃŃ+ "%0)5|bp p
߂s@h`ߡ:p: :@~:v$:@n: b:V:J:e1:1: p:p܏:f:pf:f:a:#s1u 2333ł傘@03"  Y -?x6`4 73@"3@"u	3@
p<p:09b;:03
<C<"                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)  x  3H   P DSDTDSDTu  HP  SB400   MSFT[\._PR_C000  \ 12
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 72ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD13phg	gi
 0	4kg 5 phpi p
 fp
`'fg`f b~ 5f cufbc``67E
Microsoft Windows ?ME: Millennium Editions NT C8F
p\_OS_`pga.ag)`B7
bra
!ua
 n6
 s %[I` 
u	2 p
pQ S-B8A _INI 8H A
fpig
f
 pi` g hrgfata
apa`r
ahha `a u
 bbi@ ibub`\[K
(B_HIDAJ	_CRSR C)
&	`++
)  p,, }p- y 
 ,F C0710t511 2C3py4
13t#13C5 15% 6 7  8 ]r @}A"6([	B   
,[B11CD6[
^ EF	8
[A
 20@21Q 2 3 4A5426 27H28
A@[I29!A"2B'8 CD(2EQ F`
30V)31Q 2 3 4 35A36 37`<38Y 39AaUBCDQEoF0 @0440041Q 2 3 4w M`,46
F!`
p,35a}aiapa ib{ab[7e'
_ADRGQW

[u8S[
9 4A
A0:4B C

[&4C  D 0E B/N4F?C	0 ? ? ? ? ? ? ? < A'50 [#p 1KpM52H`p` p`bE3Fe@^e` ap dpyt4cCdc
{M<bjEd[5652JbbtWd
q4ruD2dcrd~^4F` dzRa0fR ޠefuff }a0Tdu`['AGNq
@d\/P4756pQA578pO
o6i59L

 !puuGvp#
P!MwM  ` H l2?y '$53
4 [ e51 q75Bpibpkdrd
?edA
d hb brb

bhUbP C  DE3j1CjS4 DS5Dcrcl5EBbNp%Fv%wr!ar r59a%bebecPe
e
bueatob
bP c fya(
`bac ˋ`6(60# [Keb59
Ў5C  5E4c-Dr61@Eaasy`Eΰr62	063
jPiy ߠAru
i63x65p\/'4Ba{aЉw563bpb1f/p6{4D`5 aP   aa F61{aF@K`r6_S3D
p 4D
W[Fq75ML67
@
[q7  @ u6`69A D6B  @`{6C q DE? 
2m  F70[eLF 71q234aj757c78c7jc7c7c7DBpm7P` ,p80Q 1}7 80 H	 P82w83U
 @85Q
!PG85P @y86 @p87 O l89u8l8l8l8l8l89j9993 `g94 L	5 @9yHv9s99}9~9A
rX 0s9C    @xbIz895Q9u9F7F`A0PC71s qUQS4(qBCt 1}A%6BA]O@A2qAA1
[) AaASAQAAAA[#\_GL_bp
`+A4`bp.[!
dv`J`A7A8{mhdpjp
3A Hr"p"a0_A9bd[@Up	rya
c}cb6[Qp3+AC#A5D3Z@AESt7AF
DAB0B1 B2 (B3B4 (8` 5@`W6x0 "7p+8"Whi 0Ӡ`y
jbvby_bw`j EJ[B9Ghqq
3סE0E `Be8
i`zHB1@ZB153u5jЀa2 hB2KAK}7Ip6i
q0L¢"	/Y-!	B128	[LM$ SB@
[BQC1BBqPCICOCOCڡOCOC5 C6C7s 8 9 !CpW BCCD#EACF
<'KPD0
i `{ 7`g8d9``CFtb  Ccwc

ccpD1	
pI6'}G`	D2pcK{jP#w`BCDt	ED1D1vD1J
2
1
4t3`a{  
 "|ccp@ t
3

PD4k	zyEap&& r}  @ADo5
lD6 q7 8p
	 a{k
D3Hjm@zD6
x7@ a>J
"a$RR4a	`0Ga2  кC6B_E!7D.8C0}
`eeLfD9)DA "!drwpA i?cL
{k"DChifq
f
j
B
 ``C'G6Z;41I3 p`1` ?`}
@`bz4aIBp4Cv4DdE@
pwcB& ct p
!c}
 p&<cADQ1K"84? Gr-ic}0CAyaca Fb[sGD$k  PQE-#k yQ?F E0 1b2 E3uSD4㩕6TO`EtM`/$$TP }8
	q
E9	a	AR#  y  Eєap!J`Ӡ v`ECpEDŠ)
L?)	a OEE	0Fq Ry`	A`v[hF HIDA_UID
`_STA D^^.#71_DISQY_SwRSEEh	
9HD` K	aOA2OQO OĄ&bO3OQOO$-cO4OQOOP2hOAOQOOD$K$iOA$B OQOOބ+?+jO+COO@O2pE2kO2DOQOOB798588i6 E99Eu2[p?F9 FA
r B
 @FC [#PAv4u[CF9<jADva"_87A&B,C048K4FEP[F,Ё C100 101
L 2 :_REG38!`a~AuFEA0FE_S/3D
p 4p g103({@4
 h|q3B V AJaT	5cCCPP106
 3yDXP }`h@{`h}~3Di@r @3A$ q\._SB_07t
p._DOS39
 a!o[^P8bb h 7@9" ?
_DCQW 
 G 5 S[ShAArR&# B&* %$
 
h`"DPs	8hfp
` {\/04316}`p `D0D   Q   P \7\/gF8TC pCD|D(sAA)E
z `^h`j	 Ahijsv10F*`& "10
^/
kl ~AE0P7u	_GPE/
	I
J F
Gb }bPGf fy B112`B113B111#`5A6

717189w`
@	A/9(pipP08
 a?	iaq>1BP.[A  @@ } P1C  G11Dp # E	F(20Q 1 2 345!2o6 728#2 H12AW Bs Cc[D2EF_30 p 1 23a4136Q789R33B3CD  Es F@+404v4243 `p1446 7 qS14AB1C1D
4Fʲ5 Q52 +53_INI >~54 p !56G[   IP7 @@O58&@9pd`#pdy44phtc %
5Avp]!Bl`\`cV:0C	@axa
db`tpQ@	
a
`
@}a
y`}`a0*5DQ azw`
d`xr`
@bauaa"pE~	53w	
F	
53@K60
q 1s 2
QU h1U6 7
3Q96!|16A
Unknown 
NiMH 
LiIon Nph+6B
61}>m  L6269~2
Q63
a
aD`n177  w6EyCPi64@UPE!}#62a{a
;62}QE60!>
 
_Qx!1!1D16C	@ϐzQ A5Q6D	 Np
J{` I	E
[)h`pM2`
csc
  dzir`a[)absdb1/2R*(cߤcC $F	`hg3
qDg
RoU0v269{`gP}@C170P 1hA:C s827 Bpqa2h 1 12E w"7axra
c 
dcbpbb]688rn	40`>1a$(`a`-q-0ˀg0$ I֠
3
I+Ep_
 0W 	ip
q:/193."31c 3c35 3Q+B
{`{``IFA6;  9RL2ccdp e_eez
cpe'cpci1%4?~ |p
s6IB8`p
`4[6p28D29C-@$5_@+aN)25Q-  T(
>o
>!2A  P2pzQ{
 @5[|%*!B(QBB3@F`*ae(aDhU4C4	,Fata
ai
bpz%ch!
C	P

"#2aa3C
@ ra 9PQW paupaHf:bcEh)CCC>FFB-6b/77188 [
@76rAq
HP   a1
Sp
SIMPLO0~SMp
MOTOROLA a`wN777
?p
޴ 
Aj(_Q03':Q{BRᱠB4u17b
Tp
a46
ubaQ05TZ 78Q 9['cTWZ3_K6pn
;nQ7A
!PR00 1_k
2 N58Ur#R@
@B
_C# 9	@ mO1G49Pqʯ_B316

,1
U{  (i28BiaAP59
 D[K`sE
7F
N C18081F8NP-81 88 4r 5p6 F888A8Bs 8Dmq8EFQ90
[  91n09293 4!95q`r 7p0v9895ZUa9~yA
95M9AQ8a` 8c
J9@;Pmk 99Of9B9CoA QмcBbaAc3gDGbPmaA
CBFc1@9Cvya
 Rd
b
  bdpdS0c
 c
 c
a9CkB998`ka}˕a
vb@_ albab`b
vbAvbt8J8BpB?8A9q !D#!d9zj
!%EjCF= 	E#'6qb ~b	˓a b[b9FQ
82450Ơ`6C1A0
&826" 46"p
q1
{C02C
`{  ia` w`9Ahp!
`!1K A2	CA%hABмA0$Æb c  od}ydpiccUS;10abcAp(KA3 p^^0
4cIUVA5L
A6

Gy3 1qA8  
Aa9B0 EAA@cAsA6 [B0AAG_C  _DDN
oCOM1!ABAC6
30Uw"    }8y bS 0AC>_STAq`1{\/R047C055C0CPPAB11
 / +_DIS h02BПcABP
ѽF_SRS Xh
aDpDrBD+AB@
_C> xC

 ` c
 
q$OA[TAE   
DF
_ON_q!
&_OFF q PR0E[C:7FajB0pj`K  `0jB;."r5EZ yB1!BeB2&H
1 Gxx/ x" *
 x' x)  +o @r^r_ _ u\00.KB2.G%.U.E2e.1Nm.QB3`/8./B4ٳl/3XB31/ns2G/{
 *00bPOB1
$BA#S0444&Q3'4'4X5_5T Uxp
X,BArє @`9B|S:BB]:EY:_:a ]:Y:BB)BC p\/`P%VA7aeT(fy`{UPr ̤_`[O>Dө$BEG  @FC0  mCC2"C3 f T
G  G00 b+bb=CC1
q AybC3BFBFC3[k%	4յ#[  "/  y s5Ew@ @ "-[B>
 
G`WG     *"6%t}a_ a !- 7e
Gp p Gor r " 8U` `0Gd d"I C9
" 0AA
W[C")ucCA0dQcZ @cB\yCaCB&O.҄    P[+ "Cb@
   
 u
@DM@+BC'ADR QCE
D
[)CACF nINI	F[[D0u1 2ܕPRW!
O@3tL ZD3t)ŋa^69
 Qaǅ2v}O@95x69Go!yD@.D
P.
!HPPq
@D.`c~	_RMV G _EJD fpB.QP DDQ ME E23PD0-"Q +1)"'*cBC0"	[F1ѩB*D9F1DF0F$q1S3Dr 4p N	[MA0DE	E,2(A
^"
5/E.&E2?q$3E3ofq
EH 






|
z
C3C0BEA0 S04$D_GTM p
L`8 ``5 @E6 pE7p"20 4`  F WMS hhFi  `p
wp8Pa:` A` bwbw0ib 7ac  rb rc u0D5,
ab1940E9bcE4:6A !{ PT07I
[s$1 F &CINY`!^
1E? ???275̃5M?9M
 ????=
93?2E^|`ۧ
_PS02 3 T0_C @TF0	
# A1OF2OF3OF4OF5GE6F7LDF `2\_PIC*h\/v ntA0EoT EEFM	
/S' Y
0**  $S.d G?C%
K
 A
	
	 
!	A		,a	9Qx8 	D
 ABSO0QGS0GA3BP 10 oG &(^VW!F0 
[F057w H j058rF1
!𹡮 `2qQ72@	F
*R  Rd
d
Primary 
10  
LIon 
Hewlett-Packard E~yTraveloka	1Z@ 0-63L6F	1 6Fh`/`%
 
b
" 
 
!X72h/A73A10F3aPF3p 73ha`1h 7́
_UIDBO
_BaIVQ@ ST79CL=\\[GPP;6`)!f PdrC
ACPI	`SRSB`6 fr `BF[9&
PLID|s
_099
@Q_8
	/15?@SXA N9j*6 A  ^F7 8uzkPk`ah`piaFa
 ?{qPzp
 a{`
^s }aޡap`k
  pap O {Q/ !7@4? 1Pܡ   F9 m bm

  V` o `2^``qhp}
yjZ0  p>a"1Ph)h`P	9}` ib pbasabcpcau`a[$JA7B
! `b  ¡:CL87DiR8E FF C200 1C	}/ p p
`
RS P  pr
` a2 P3p!ee[0wre
 
4q461EpFAILp0]pO%ESECUp`vAM6 
R^ 
5bTFxr6}U7R8]u9-3P
caAcp


B
	C
D*bEfHN2GaҒ ѳFBqt@4	G! F101c12130
e415164b!u..SIMmWQ@21gO#dbER'JT/71; :!Ɛ ``,NPASSa0!GC.OaOK rPp!0`ɿ42ap	Q 7a41HOdCI; 2MC'4akbbaуL b ubN>85EDlPph<piKA#MBMC^FA
ViS|pq `e BSCAzWDG?
<4_c,E=DAAyB{M4C~ !f )ABpWMAAwFDij=L!AtWoppi3BРh@fZI0{h
`7{%39
p$`Ax03y4809
_,*{03DK	B
  1K  1K1 K#
{#8/p//86&_96M)M $095P*"a3nK
4
QCA!hp7y2?r5h	0)T3!
1;!m  Bi7U`ߕ!5E&Go15FhJ1Е9$~ 

p
1%!&Cep
XobP@3C* !B+g?	p
_\
Gp
_2 D 
'DB)6 KO&@I0E?68AM Spm	  ;!M?_WEDsqOqMо0HaBOLAO|Nr C9sA0WQABNFOM H  `:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9qx"kXu1jHـQj(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1NW9B#?U>2Fpz7G	A>|=h4/~:zH8P9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTg_~"CBP(Ġ^|7ȑG!&((߅  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'_[@EA[El[#\_GL_yh
n@0piApjk`3044\C0F8h4`ߠ	l['['ޡ`[`F

[ C2202122 r 324E22ph2[231142 20p{zh 104h7	00 3 2F 73i	
*	383 4	PG\_TZ_ 3BC	2@


06


b755?oa
 m0[
	C
d
_P
A
23s3E
F
 40
q 1
 43s 1=546`7 8P~W 9
 178P179
q D
2"A	py
h aנ{a`i`L	B
i `h
}`
`49IaqRbc`b`{bփc }`b
pza?brc
c_Q_A`HC``phaha48i `rP	a! 1!pD
 a b>56KbߤbA@E X:`1
p`"q 499p
Sbp{tbv7A1b>A2

bt
axa

`br 2

	ܟP!

Uv112a   _#"0p _15CL`-F	Fߕh
 #dp޿	2
d^% p{rb"@)b
 t bbwb

araMpLa U/` N14p14Fa@Vpab)a"'6h 1(7h, apbpaf%6bI	{q8b  q=p+hQa2=`%  v3f45<`0h184)4p`DQC250`h~pSTZ3_
b1 ,aM0e50
4 h w`t`+`x`fi
 f
0f0f 1t<qR0cbb0Ab&8! 5bFi
p

ep
d
ip
 d&7d49efi620(1z ,D	B*qYaFa[7`1   __STAAS_ON_!QB
@t FF  [U2#U3-.+
4


[3#5INI #R_HIDA_UIam_PR0Џ51[e56MH2C7384[G_AL5 1PAsL2	AL3C
8_AC02C2xoQ1UyV2VE3p}PSVF1RtSoLMPRR00G8943}gr=0{(Qf3D?3E}p<3Fp
7p
$Y@RPQ0__TSP
dp C0`q 2CRT`=0,TMP~so[J11W
0A(?
0
,Ra.3,0[MTZ4_
9H
`ffff6`f	`
dp
d`wU`rVо;EDq25Av72s7]B C^ DE Fb60 p 1 v1C  p62`61
[ 3@(A`&6425 hA65A6 7`UyA
	p`jF@/681T63aaaJac
``rd
  b}y   0baya
a0aru5Bc!  eraye
	 evgepepucdcM
`9r8cpc  bpbgC	bdpQ{e)ecb5Be Pafg
fape`pfafgvdueA`bC` gTb 	`5Cx$b pg~14agg7agubdMu@A051P5Fp0`cע@"R5D E` u`py4 03p@K 4 " Ch H
bhQPr 4c01d\a
eD%-adOft`f	ru'adSuc2ftd gr:I`4b v#6B,7&-r@01!6A`5!/
kBBpibhb 1CpV6CDD
Uj0DE"EE"Fp6F }w6
ar0^Cabpb0+b0``babuaaP [`bua/HS07
PHtɔ4FDR`"t 6B```QOhD1

	Ћ4      y ? 0f72 5EpC1'M661[wAy273K74-
*G  0 ߁    ࠕ p	 p	zr[Kf027;R]1A4N	
GG. . GN N   G   @ PPRRlloo   A-bBDn

G{
 q^^.`3\_S0_G 3 !  4  5   M\_PTS52AOHpOi_l6ߠ`1EA F3A"\_WAaK@ 35v8Av/z&z값/}COzEz6@gyĀ:A\8
14̿B ˏ11e6O7acbcc
c7A$);BBp3
 `=Dp+OE80 h! +7xL
"+ӤJU\_GPE_L04\ABB_E06~a8{9
`%2֋
48 9 aa5
{~8B
`}wd	7 P3E`N!_'.`
P-
o	a	`
Q~6CU1F18`p9C`95``
 Z5z<0BI-8@C
~@_L10l
eA@$D a12;k1D/PL1@԰8Qe1`_91a{` {a
}a
|p1["
dlFa4ooo*macocW b6oA_E18= )8E
) N<`51!6
#(o8b8/:&:<Ts+C104O.O.l7|-
fG-p2

0A``OI{` >@p dZ5@
- `ac]sa 9`a`&*_BG_a&JMbUc7?95?0֐78CSSDT}+HP  ?HPQPpc PMSFT M5h09@	1 ̔   d   #_f_T	_fw 
_	O_7Awjp9r!B77BP]C`7Bij`e7C h21da22 0A6_0A4 A6$0 WJ32/ yj5 lfi6j9;D
0`thabb@7A}h79a b~ 6C22E 23@224B4%37q32y8_PCT,
 0_K_PPC 9@14tw
`v7A_PSR87&q1j
0YpDaa9|A32UA P   
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf         	 OSBI_BM  |p ( n s0  b C %   Ƹ   d d> F . F !  n  f f   j       (!"320$4Vw
v_T ,D a%he/@
WS "h$u/"dxvUDD g?~d0?Eg"
Xu05x`/%'cq 
@@"`b&6 sXr*&_`	@`&/7R"G qh `8`hc	8bf@ 	e
o
*` 
7/E`(X]bx qH p/ A
-`@@N`1A_hU@DEb#horHa
Ox_%	 #	/D?H_$F`#? ':%H	!)_@ 1_ (a  !+$ %
#$"B%2`CB`&
(!?*O"_bo-,!)a`*(d $*t >.F?!H@5!=7H.b(&%'HH@9Q& AaoB1sbp"(b*#-eX僠;8U!( <O`5a_( <@CF N<h`@o> 2a`3`?b+O" A")E	=Ap`>!>A_@A _/@ 5!G b!-_]@ChcCU"$
#A"-,1"EfaB@ T @ j:'!D 
oEQ`Uc[Ra>	?oed-)IxB@Z$$9"XLAXHoEc6A"BTnAltZ"CvAO [`ZG
c	(q]#[^%$P
MoBM%	8'
%
#Y!`So`e6'M"S!H a*e[bdhuB5p 2`k#kExN
PUH
2cZby,_a[$Y<A l
R/bn!H"K(bcjAQ_D@>(?AfODoE#T,@/!L@FhhDBS t:`A@FCk@A.MIA]@ ~y`^!C:AR?`"P eB!AmHNGB~OvC"JZ[qE)%S ~!U/p~AuA8m@gkbf"tB1Bc	2B!s /	o!*c:}?dArp !d(
a_	_Y$Ba6Diq fh	C(:#s a:B!
ŘDVDBAdWWrZ`A*q8 v aK"Ayr a!gaH@\0c |H,&a/z_` ?  #[ř E7#p
OazaG"Gc! "dBa!EB.baExh r P%P#`x`% 	qOWAtXӑtE!?@CZ" ͅP6," v/eȀ`#@%΂]H`ӇA"
x`bE`ڠBҢwb B  G ݇`ޠ@ `xET8#}c`ffw @ "( !`f^W.)@넅4BTR%84D     f!  f n@    ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ     K     VIDEUx  AIBM 761295520C??  2005/03/22 15:37Z T@  <
RS480M- HP TAOS 300/14 BR12225
 (C) 1988-3, ATI Technologies Inc. BK-VER008.028I.@ 0  yutaos.hp v611  M PCIE? UN  OEMt  W-  Q UY%xvp1t   C$TVSlS@    M}HDk(z  @	Rx  !MOBILITY RADEON Xpress G Ser -{2 O Q  #  !
l 0   4 Q#A9$Xa#A 1%GQ	  `  sCDAP`X 2"0A  p M[W  ` a,T D ݀+Z @
.,.dM/|UB/"l` @]D  `2 MPLL  LL0 8;M<@& 0g 
v
5? 28-o9
~* $ l   L  `  @
H < B U_@Q : BBqmA 5 8 bO p@ a<P' t	a*u  t N u $ 9
3p $  D-E} FoCF #@g1aCdP'!'zh H f`.>, u..,..	 u  .0.9P u.0Ȳ.,fa.m4.>q u.
m.&m.mмo.mf`7 S3R[)$
PtS$RR+$X-i2I n+ .fa"4t.104 臍 P # mPVn^\i<XP=Zt|.ߋ QȤ Vn^Xu蓩4 
 ,	oJ $A PBX B@Q ?u^r-atta0t{u bÍhhB!AO89 PW uW첺2 1
tG^f@ ff+f| +/ffs @ f.Wȣ,>VB <v  !  32Ĉ&! .@2ɨd^Ð	U   NhVS*814DLd
FTL>0p  `h@S@PN8t ^Xd01F9>6 F
u'_>`t1r"tr2_2>SN)N=s`2`S<ti ^q tW@Mtuu	 t; t6f;Q? Ys	-F;$u<t<t<t
<t
데뉰F f;_ [# ~ tF: ǻF.?F6r@F2Ac wtÈn<uj`tf ct  ^"N @w3X8u P P
X"8tN ;N"rҋNN"ar /s2~tRSf_Nf L  ffff&f݋	q  
sBQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ 
F X[ÊFf@F$FFt@F&F( D( tR.&0U,Z.1@%[PR.Wt2L ZX` @ Fqxq@vp=@	;5vv `tU;5tEt:]r9Urmt5f3!qAf3ۋ^$f3fa  }C s
Pe"8sn~=}:n=a	Ð Ⱐ 1'(+ S?BDbncOQ]SDwp  sgOV uhOQNgORE0c	R 
l	jcgvWX !ce
pVPa	߁cj| Ris B^ cf	
U'  g|}% Lܢa	d`2 8ן`	w6!W  ן/  =|ҟ)xfҟ 81a	*0*!
ǟ;
	
0li	}`ӟ,b	
0
H䱟 /A13аU}4oY]M`62a-b6ip #B8q?J +%":, `6jU
u%2S-.<t
 C[3Ы3Àu#ڋGWQ    u 2~ U qFF
@ F v ]jUbGS	C	8t	C$[. PRhG\ouP tY@ @L,^P@  XjU   @@xSQRVW	<QD. ..Tt
& _^ZY[XP2&G@ku
b $@
@@XfPSG<uTG<uFGt,Pt G2| uA߬G%K3u/#BJ  A+@	\G`
[f@S ?X˴.6϶
By ʢtPހ u< D2@ vp.6BHeW%  }i
iQـ.afY	 
 pfFiiF`  .$FDVpQۑnpJOi@舡f`KpNi߈F>DFNF vpFaq&W߹  _$<8UOSQfY_RSWDUP u   ~ X_[(UX T[_tF$F&p
u/C
 U⻊T:T[P ݓB Cf3a  v vK컉^h N  ؀t Oo}c `M z ZZ?a SXC3D@C4} C_<qD?C0e CBS$  	{0S<o
2aud
IS"tQSD`Mt@uN,߃u'"?@3`VF  X  ߀t@0/S0/BU[KC
t$BIC$BDQ&D+Q?D  ! s*t~l^R 0Q t
 t?R@A%?%P%@
Ā?
E 
Bt1߀t
B$AB$AqB$@ABAW( 	 c-'(+ y q	 TvpP p}c_O/PU
(P	@ s ? 0	_@ T(   ! 	M](
c    
   pbc O
 B89:;<=>M?
 +
G _B$d "ozc/fk
2 I >2 
P  
> ]@( $	

 0б0 	  
   U    
 %( (,%*26', 49$,0	
!&.3+0$8=-2 $8
? (,(gc $ 0,!$
( 0HH0(, 	H 8H
8 X > XAgX<	X0TDgT@	Tf(XHH8y88 ? 4<$
$ < @XA8@	d@Ap@ @ AO..r#suP =Ou W&P=: sX.XBTazV*FJBC$' .?}@4eI3: +t&P$vJ<~.;u*6I8Dt	\S
OX=PI
PX1체0&G	tԱ  G	P?
u&.+X&c '/VX00PWl.E#ᗋp_ZwYhu<tDu
~2\tX&IDUD 30]U 
F CE]Y[	
FXPv(XA 6S跊[x( vv !
u D]3PYW: XJ  Q S[WS݋ P	026'C[2S  &'B[ ĸ Ë#utt&FS޹ 2&C@nrut	 F[!	7	 2
n ȧ3ÐA.T[t v @%7t ̓rPEXuSصMP[	$
tWÊg% oŀt4$
@   `Ê!4
}P X3<J1u P<~$<t <t<t@؁ð@  EuP@ÿ!!"3  @
@@ b !"# 3@tb
% `ĺSIz"e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;uupuK>L tDI @.>W@3u&"0W<~W&g7t#0u3 3ݎ2PQ3f3f@  fYX2PR@4$w@ZӷR+Q  R< 4{Z 8 b3"P m303s AQR趱$WBrڹTA fRȊoZPRP艰 X@ZX8t
tPZYXnuT  w 2u  ].3
t	u0 0t Pb1[X \0u$0<0u  &o#6<uA	ut	
t0
߈ )<u+V봀1u0*u!*Qq3u< "	,܀4u< um 
f铐6u& <t	 00=@SB"
e ml`>%ȋ쿉^N"	:  *Tpe.P <Ȁ>cu>&@ 3ۊÜ$.B.Eq J@^X]i+Ht8 CH <8t<?t4 .B   K%/+Q` D Ei Y@ 3Y |RQ
 Yf.&  b&7 *# ?#  F 

 G@s 	 GޝÐ~~|ֺ| |8 8| 8  l  o<~<W7 ff 6xx~~~p`>>66f<ff<  >qf  f {; <f8ll8x~P 0pp0a$fwf$8||s|
v<<a lllll  l ~| 0` 8l8vvP P``0y @ 0`   aas88 || x" f<| <l |ƀD |  ~ C aP
a0QP 
  ~
 ff|ff f< ll  b`|``5 
r 0< p  `b% ?Ɓ|ְi|~Zl) l88#<  P
g| %| 1| -׾0ÿx|~ `   ` 60[00q(v |8 x`flxl@ lpP-| p%| '| 06p'( *2
v 0d 61 \ 8 vܤplp;5 -|ƅ88
l8|P'!f|ƃP/&&00 %:l~n ~ހ1-7 0
	'!r~`l`fl fEK>c8c>  >a<4   ,+> >`gc=  G0`2#`?#: 0|6> l<~61F  6ll6` l  "m# U# w# ##d  6 0P P 5 `ROqPJU1UQ2d770??%0aa66 R9a	
( R>     f 9x_eb]qPf```p_d~̀Mi|u?܀g8 Sl8T(r(l`"8fj~C|q^ 8`T`/Paa! b~ Y f`[ ps xdaw<<S28tflD8p&mp0t| o@1pqAQف၁P>Q#tlEcvFlpxpq5 aq3Ԇ}~҇ 1>6>`vfqB~~`>~~>ՂR2$ P {p4`|| s4S
@pC 5t%9_2`!@@AHi P!3pxF)bfwP0v~mi "{16879
 G-3 a5әAaPp |@ѓ`;@Ҝ2#a=Ғ~ BC ҥ R*Ҥљ tPa7
`p0iQ.f`d|d`` 
`ζL ӥ񦴝Rp bq
 xp S	 	
qQF#a`( L%4bLZ ~E1࠵ 4-"0a6P6rCl   a  	P$j Ƿb[6 qb 
P$=b X
CO5.  'Ma0
A "оc A Ut"{ ځY
0x"p	#@	$@%#Qb  
#p
 
%	" Ђ#DaĲ6f0Pr 
$ 	%  		C	JC dw@`1|cc0c4t	?! 	8 ld>BPP<@ WWd! 3`p3 B7< ;8>dp` ~0]Zwl^l Q6=>6n6@s&t%D+ f 5ڿZ  Ed

 Z Ӥcg Ecb
 d
d5e %5ek 
c
eq eeu%
 

9 Ը=3;1N Q1|b0i 2S$|ҏ05Yaxp``<f	P`q|  0^0v  3 јn/AX `ix^ x8#?~  +/t?W2@ _&&MSWI &FG_&E"&E#WIm_&]%&}&I2.c2
t@' dڠ)p = ~=^~=~=~ &U*&$
$

S0B$
	-	1S2;t4&wt  pu`2RԊ%@+F^t=@ eR Iݸ  t` t:t ?FP݋ !?uq&>ek ڊJiR 2  &GF %G @GÜQW+&R&D&TAα w!	ʑ  p&RW_$&TAP
 XF2 CD#Za
CD#`	 
a@[@_Z_Y`GQWP$0-󿤾p   r ts | :&?Q<#a " G 	ĸ  2
WRU` RFJyCZt 2f 	2PYs	QP&G<Y^+P 74 7@Y쨿 t' EPJJ  B2BBXJ6wOA!U{,?VBBq#5)^!]P5  (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

			   

m
   r 
*   S**Q p   ?  ??Q r  ~ g~   $$$(((---222888? ?? ?/  /? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h@   1   ҙh1 h1 P,h   1   h
1 
h
1 
hP$
ĲXðN WN^  t o>I~&G3u 	u&IúbtԀ`cNpb  P3&2J&Gq  GLq ģ`À0c B2[a a;jb{mphrmÐ
  !"#$@ABCDrstuvk(
K [!{ ;Al(L} \!ߕ|<An2N ^!~>Am@M ]}!}߶=A`P@ P!p0A aP߃A Q!q}1AbPB R!r!/Acj)dC S!s"?AdU/D T!t#4Af?F} V!v$6A@h@AH BX!CxD8ArgJsG tW}!uwv7AeVESA   0  IbK  @  ATI Technologies Inc. MS48 01.00  @ @   P   sVBE/FP e:.6p <r2.VWVSQR  f&=2u " WA_WȎ؋ʾKp" uz &u&E_UWPPPUwU Ubp M_ǃ"``݋ƐuZY[^_O ËRQSVWU?WQ30
Y_u5WV6L2^_@

.WEE
tE M]2B].l.DEEӀ~ZӰEE!@ #  
E" $ ~7pq~$@@@@ #  P"%~@ EeUeBS3ۋ3[@N
tȈE}~=
 P-E*؋EME,].

-+/E0pX1 
 f3O]_^[YZp0#RQUSˊ$ w
 V< @t| dQLPY
 b 
xŀuZdĠT2ʋD<u<t<u<uAA2PQ/3 X23` .ƻ
>	$XP{C@oDI0o[D0o2 2pDo+/tu[.' ͮ2O[]YZ)ø VP$6Iش~!t8\t,	2^ƀ t %Ӓ @^wO-  	9s3"0WV>ȯF^&Vf=>^_ÊFG< uûS.W._0W , 
._@StwCCPS($]b W[XSL+[ utzt
uPSR Z[X8
t
<RBB@Z2ÀuI tp<wjut`2.W,ap!`O24̋AaP$Xq(
u uW3&+_uADOD< uLA*؋6IS [';vȁ~PMAJS,f[Dt@S[%@عSQ蔿*2f<ff3f` Y[f;Ës @]xryf@Ч
2uGf`P詑RPfZf
ff30fX<uVS$f[fa==f "$b[f%fPO@)
XZRJZfX"[
uQR~ZY!]"uRY)Zot^3"t	$B wl wf= ]QRW&9f&f?$4 Mfgq_	uS$& n  T8<\ VRf 3tZ^fOf33sfffPfVX V cPQRfRfQY $  OZYX!
9]PfBffvWfP4<0B?&q?fIu" B&$@[A\`tW1_f.  ;t} u2X#%5$$ ,3>QSu:3ɆtA
	 [YQ
$YqD?SQVWP# 4L &_Is  =R^Y[l7QRVW蚿{	_^ZY^ڋ_  >$[ SiRa3MR+ Zt $$}!
  $t߀7SR #uZDQSСǾP&= PH`UsL>MNOQPQ`RR+SSW% FUU -PÐPMIDy"W _  kأ,>WXR ZR
 q  ZÜW2 _Ü"oQ K.,3d f.;u	W 
	rbr_2[fX3& $4
 	]ffQQ2
QQQR>WPH۲ HfXR2ZXff_fXZ* %RVp[fqf_
V
4
mX

jV
틩Rp}=fZf`f_ZsfPRl g +KK;rZ S 
S  S@ [hSSSR	QpQ  BpQYÜ2C @@'@h #    ` #  _   ߀Of֠ .D=p_=0"f`a.T._
DDA#S_}a Z0R#r1y? "U",7`(3`v	.DfXu Z
bD	Q3Ɋ5U *.d"Y1+&v
4075Q A8tPn  3	
		#  ee
fa		hPXP   SQ h~t)bK`.IC=;k
KuY@ Sn?78t
INb 0	PKXBLQ('ޠ 0{ \pjr
a RP
XQP$<63-X7rX>hs RPXQ QPXrrXsYY2YSQW _YQWPr
&0G	Ku_P !Ys"'Yr?PP?fa t2+QYI?t蹐 %QU2F F IF E:s T`~  tf~  u
 p t {]puÀ 2S 4pXY[[ױ' PQW&EN_Y&?=XuAS䰞u"W&
_
t ߀u Àu 9u?Z u	@	3u%ZEðp?PXq@_ @ <Zr,ZP1
o [Se6_;w2XX@f` cut3P%2XtqNx Wt P DwDX f )P%t:*uVP X  F X 9
u9P)P2 fl SP nX[ N rfaPt t
 	s<s4qtuR;RjS/M
u$PLu
	Qސ pq|rs0u0tSNQ{Q*R路t|ttR{ab!(b.? t.;u.;Wt3Q@^-'(+ ]c@7h?^_OPU g7 oo XGW 6O  	@sTv2ed. 
90p@]+ p3
2SQP=09q53~At'		t߀t!t	 רuC e@/SAI  A[p0B$J .gp s  J$
z2	䟰@
e`	P] 	!
U 
̀n	pg	
4Ȏr y1ԟ/
$@
JP@=^v	@=v$?
ÿZ[}S?'1v̬IJV +Q$$fP, T  ] JfXfXA @=S#1;s.:Gu@3u.pR&}$`SU7 Esf>. t7茶uJoPQr X KD(d
$P?][3۩ 0   PN = NXuZ2@t $C^ !B    ǀ Hp ŰW@ĚƢ $ ra쨟ua`w)$<t2
*#`r
p
w $0茠 
Y#"|z$ qo_$d ú$B
 <%1$f n[
($YS6 |R"$6R,tè@S%"'@#"2[!f$%@YV P/HY rb0P"XrjkuNlmp~H!KKLF,F"F:R`	4!lImwsjull'kuam
KmLbKB 1	17 8;ұ (<&" !RbuQ*?0SV "
0`B2 1/]Ă  0 r`HĂ ]`R
P]$2+'$!,R <0_#$R"$R? @N* >$ AO>*3MQW2@12^ 6Ct
{ot/
0{ ge@P.tP qtt{XRc J_JIQbki hTkjj		zD($l"9RPĀa
_G'v6uj!h>i(il.E# kj"u0- ELHIJ !]$abRW(I<#t=<2t9<3t5	 2f	PQ &SI[N
_hfPfX2$<A<t<t<@ < 7F* `&E3uu
u	fF4@  8 _._f.EfPF .GF4XwHe uSF6XH{guHfa
f%  fF8fXf;Gf	F8:mf2Q..>ыFF(PPJרX
tHSoG[p Qu	 Q
PtR3Z{Y.HFGFF
uGP0FG$`@F	FPG
G.M	

`3T
ňFF	
G	F	 
F0GF	@GF@G
F3F'F2F@FB <0!mQRF;
!t7<t3`l/@"@"
<t<tn2NAVBFF                                   S0(4 f
   KfX[Q.轡a.YuB u*@pf EGtff.#Gf.Gfo뺊ub uSH[`.O.t	q tIt䰔БٻPIt$<Ȳ2PfSfQfR\9HK<~fXf+@߹@ + ò<PfSGS1rfDGN1 f.aBðXd.|p ܰ㻬 GfZfYf;@ K Pp Z d r     	 p   RR  ߀ p 	{   P  p 0  P  ߀p { P ^p ^ ^P^'p  xP "p  P	 @KZPb   fPWQ2ɋYSQ2Y[VS@ %pX QSfX PQ3@G YX P f%f[ˋQf[ m  fà!
^_fX2QV2oq.^= v8ǰB^ YRp'
fX`(ߜ@CJQo2P$?X%"0/@.q0P%P$~% p%XB;3QfwЁY`<fpufPV.^2=fX-~|r
01u0$Paf0RYfPWVRQ+Ë&G
36 2P $@afX&2&{YZ QR
FFrPv3f1pPSq퀿ʢuȎ؎6>&D&E[Xp	2R.
n1 IS ntQ  tt"POP`tRp  Q-Yհ|.Q
Yf.9VZY[!TR`\f}0O;Tvq vpp  f@ wjvef+RvMWv? v2 v%v u	r,w{'ZY0WAE._t 
UNfwV'^jfpf.fff;rf@frx0f Np^f;?rLf@.Ff;wff+f'7sv
A
X.L
	؋N]t= r = r;.+P. VÃ"%я[pl!0q!À Nt˻$@`L߲V$T$a 8Z3ZШS$p|߲P%&O@t@ wp&W7u t@ @wn@HZX^	ZX RWI߿8x`ăt N`ǯ_ @`0Sf4[ø \Dw3H1l g +KK;r  `k 
S  S@ [hSSSR	QpQ YQ2 QFYÜ2C @p  				    y  
p2x26޲[Y."D
$.
xtcys/] IC`  D2B/dS 
 ]ݲ[&Eq _P00aOX0舰&DVB 
 &ѧ^Ͱ0ZV($^PY 7Ftf
^~f0Nn;w`0 Vި[Xu;}@fܸP@%  FF Ƞ 	rp=F L
Tv&wiFzFqM@	FȊă41n %
8
F%QbQ0PFf=$116, )@f
 
ZË~u Ur
tQ~8ؑF
RGS؁Cý[͸ Z@= !8t ,贕 : QRc3ҹd 0YSR.|Z[  RPڲUX P $  (d
$1ϼtp  $$@!
u{&4u5 * 
 u.0tӲ.,63 W߃ [ WQRVSڲ+$Kې 2 Wћٲ|[P30@Ϩ t	@ |Xھ  w?waX]rIw= 
@7_[^ZY_B?t>1lpWwA2 ③
0
#


  _ &

ۘa  ul  Vf^fPB ӻٟ@0ّ`a2f;ufY?$_P0pr3>ËË>srƀѷCBr  `rVvؾ| au| ZX^.tW z׿
ID_ByDxVS@+;uw[^~׿|\1A	n׾ } ^( 
@7 3K!fBCC胤У   QpwoPƲRXp(ֲ1רu[ Xh l   Bp   & @*@LN  QRS.ְQP ?d_-C - V>NP(ֻP Q ֻT ;P$ֻd
* 	| bBsֻߌx | @CO֊Ȑ1pqXcXX	XIXֽXP- $2_t[p[Qbut@ sMPRp_s  .˂KkPɅ//R//BF No(Op.΋FlT2WKM//@ N0l`^ Ѐ
u3ɻpՊu<i*Բ.s
tS0)XZőXZpGu4հ 2陀$
j}0	OȀ$߻ 
謟u9Nt  @V*rN8#Nt
P$

	h(t	
tݐwאܐl@ZXt3>F  鴐;4<	52QMtS: 
7͈uP  	t&$
 !N
D2L  .Q
Q`w0PXY&^8&TϏ$%T1$pȰU%$ t0pu闏T %齂u   Ukpi`Y^LW;-f3.O>f.O% uѲ$f3
tff-f!a	f
`2._O>uu@r
͎04
ݺ 	< Q< a ߋР&yA&EJ'J
W@2J.$FGG<v_HHز8] C P:\
>в8&E 1&% W	 &OO_2$0mp$@X馍u_CP t fXf P 0  f+ffI!^uޒϲF u}V$"A)P<[1۴ ! [fpfWDƀ t
a{@ѿ	*QЫ0EЃ21	}B3ۻ   0f+p&@)p=zϋ&if?PD۴AϡEQ X࿊f% P`Y|ρ
u9|t* TβP07$
rѽd~ҋƿuzgW6ϐFPTѰ0{α &MO&Ee%GuoRQS؀	襋[@@t Y;vȋZ;А PfQXDQ	-ӯ aˀ u$0@4۶@4ްu? 2ۨ} `Rwv S[] [RY^P	u* G'诘u@w
GE賆2/@

	f̰$		$eT=]L!t0}݉މPQR $ظ;MZYXً$< t W & GBQ Yu
N_ u	 ps=lQ
PZauA= Nu~>K 
<QY@rNu{
v`i\Ȅ\aH݈P`.C<t8tX'Xǈ |֌CT쌔1ʰat@r0s%06 I !
Csr>$@pw^ʁS!I艠ؐ
3uRrt({^R8M"c2'܇ jt}7u1
b{Uq2
؀
#/l@ܪQZX
Ò=̇g=P=8&MU>&U
>+'Ю333 3Cu@s@*DPS( eλɻD d$[X R#! 8tf;uaS	
 u[S
t`@ ߆!sQ 
!@ [߀
q߆ÀK3De%  p $BȸU~2( .%ߵ
fQ
fYfPfQ
 Qvspp
  ̀Q&  
f%g*!
=%YfXfSf lf[
zް
Qø u  - om ~Ȱø jѪ_bԡZ }R⸔@yJ!B⸈:1f nqǸM@0 20 A q$Pḕ}  \ rỐ3
f
  cQ pwptpY@  l@ dB {3ItRZ8uR*
Z 4RP  XZ 4$` ![{ అȃR23Ұ
)u 
Z`..W un> tgp b2P>bP22AQJ2=QRP@ 32ZYYy2ߢ XaZYYR*8}2.WZà؋m 2Ku2W S
u Bj[+с2Ê2+C**&R  ZHu_ ۰$JB J.Wr c» Q1s{ Y   PQC3BBaaPQ 6YXaYQԨuXN
+.J
uߊ8~` W$0<0tW:Jt. ` S +*21+uX  up*tX⑰ ,. P"Q0׊4"
Ê$"ð(Pр  !$%D
m݁  +

,QVW++  o  e_^"YԊǊU_ S8v2QY2P >It(P
ïRS"82 PL[[ZRРJ2ZË.ſ ŕ 03<?& t
uV E,ņ!&Jd aZ6	-[a2RqZazL0 }
+ȴ@A
t
2&LP    >&}S`YظU`J<t
A<Ut2[ð
 6wЅ% B B2+Q++w+0Z0"Ȱ+Ջ+Nu`$` t  o}"t|ڑPa8~
td\8tX|0I~D*@
8t8`t2ſ
8~
~}ݿRt*Ŵ
RQVW3ۋsЈ P/2 1t@   _^Y@ ZC\WQRV`T3G  ZYxs& 	r Ǣ	 PO譊ी  ffPߑf u/0baS[F_@fWfVfRfPbpfV +Ɗ2BAXZf^f_SRP1f3ҋ`Vfޠ Z2f04[u.N i wy拄 rXf&Iw`$=7|t;@) _v[`ovI
R:ZK`RhσɃ@A3wh鱃y
twFs
鐃PdP+>PEbFߋ+Zh[
tQ3R
#
+ )rnAU~6|m  &`F +Xu &F E&   P ߀Qa+>2u	&}uƀtGVW_^t!#ut
>|  21
Ta|0\F݂tPA drqF`u
oQˀ
С
6JX 2B$]Xc@]SO4߹ 22FfKu[3,~!#|Ayom[pBu5G.P>F eXЅ$6| 62 'tm߰U؊Pu)#ëp &N>Xz 鶀}!1{   PO 鋀Àt!&0Y@ b?`$ `&PO A8r2Êв⿋2,/Ћ!=1HJN@PRXWQP͵suXY_b{Q(IY+qGtrGn _vqGov
  _u　PUoP[,@.X`)Vي4|4F umXPRJWQQW@3_G?8v
 VQGY_Pİ@[KZ&%_G+B;v
ZPݠ òθ!&/2R_oҰie0XRWQRQWP8tXoP5$FX_YF!Z Y_Z 						d		U		ɲ		>ctqP}}}>
u&fP 3 f \f$߀p  
@<}6}SP
3 \t&ۈ   &]X@9	U0P qG@Ā`ey
L'|CkP|طAW+A%  %%&j|&Ē*(DrX&7|t
Un	-
?|̢-2"ٰ[}~g{yr{>b2PI<
vLw5`GrǪA8sZkat u2<
u:6u Ɖ:{<u0{<u
t22+at++&eP>Ҫ?pezpбkz~z.ۉu~&2p
O3Ɋ7ʰ'ﲿuF dzZzcR`R8buaDz~1T`NV(zb$
Ip(!Q̊.t.;t$.
DY^Dy#+3*2d!d"<PR3=ZXt
A>t
y~>u<s .I0" *.t #\ b@Х(tÆ =@&8y|+>&}s! 32乿 =밀w0$&e te ò 3NsQ2ĜB0:JG_ `;/^ yxQ&5&m&M CY\x
u	$aP0胢cu4dx0P !v &w5&MwN  w}4 { P^a ,AWT wtMX9 @Y.ڰP;PY0 d߀2|XR~ ZSںY~Bxs [Z SBB  s `PSfQf  Jt^$t"$2t t=fIuvt%vutfY[X$ .[c|~<t
4jvaa_v<wPSPRRR߀@n@߰	e@P=s=s=|s^=Js ZXj[X <t<tˊ~ S&[u _t@ > B Fu.| ~ uȎ2.b.yu 
*9 Խ'Ƚ+/0:
u00w5߀wpP&p u͎..,?.רQFF u+/'+/+  Sp$[x&G&g3t!<}虽
<}0
 <t
<̀
&Gpu2@| ֋P$`"3ҹ <uȰ P' Xẁ_
PuÀu
&~à@S[t (22QPF t  +YsuчPW>&}t0&<t$8tG Ȣ&E+ _X`3t_tG8Pmu&2. aѬtW$
J	 ȋ@/utѿHa& L2ܾ+/t
 t<tc F0UJ>=&]&M&U&E
Pp>X}21PSQR.Wt	00ZH<|rSH!`5[VQS&F E<
"@<
t2_Bdpp\p' t&^ E	Sqras -Pһ -q	t2但SU@,][ X[YZ u߉:ХuZq`Ip~Am^F.q<u	Cnq.:r2.׋] Ià$0<0tu` tq
2.;tq `i8~û 3no tPmU#_)ߺVqwpt# g P 2       ?     _@  R*$Z.	$SQSQuhY[f.
uY0t㸨Xu	f.> Ef0(`f.ߋŀt
uPa*R bj
PRtZpr 1.@i(-2.OA.WB-tW+A_t;rÀtW-bp 
uB.&
ċȸ 3  u,A	t0t𼀭 ]T
ݸPG]tu?M2@
uJ J Ѐ@1

@ EPw@[ZPQVWS.>Nu$.T Tǧ vdR	[?N1@U[_^YA´` 
XÜf`CPSZYst|tuS0f`'l[!fsqm	21ݧ[M	4o
f @޲"st fa'fP2ɻ.P$胧| " wT 葨fP艁 pEOPĀ
h%<P 莧"fPf"Vf3f  蟧߻BAff	P谨߭誨(fx藨b獵2ɰ $
PfXR J" .XX
 0(!
XPX裦fX!5S.= t.;u.;]t33WRuR fW.׊eD <t<<t8<t4<t0<t< u0PQR=@uuX5
X
<=u
_8@E=@ Xx ^}     Ѐ  @jPmm @{wj X--  Px<˲t<t<ղtP<uJu@դ.MtP触%.M߸菀@A
5P
X   q
&hJ@&$ AK0U|$JPb2$6s&r$Ƥ& ?o$u p 跤0*8$;=p6_R!"WJW PrW .? t.9u.9Wu.G2tp[32Z_Sh.Ί
܀qopp[QRS$<uPN2[ZYÿ
w.;Q+Wtb3PR%$ZpR% ffR' t3t+t#@t.tpt>tѽ%ff ӹ%fpf$<t$f- < tfߺ+ `fߺ
 f2) ffffZ?fYf[V0E2ȴ2E.Df3ɋ% fwfp.	 L  
P!ffpf  !Xff;t9`fX!" 裰" 
ʣ#ؼ@p Ƽm轼
贼.^'衼C蠼`脁)ytopjqDiEdF_GZ.F+.~0 h߷ tttt	tr
~ $0C9 ߰bֻ ͻofX^ ! ݵP a&   D CRZlu`u	 .F3H!  H ! P@fXf	0^ .~1 ˃

p1 P	 ntfP袟0}4q0   8a fPRQQku@PX3>3@rHpXP ~ C z	$ ,?Lΐ{F T   Xz
\ `#fjuߟ X@ntqot= t   u pA
uu
rrXT!stY]IϐUBbtE0MA<~	<%  Yt  l柲 YZ RoSfPW$~m.E_fX[Zʝ4F
 <F;  `!(`;; >  xGN `#  )$88 A	I? CJf`TQ ' %<t;ùk Z
 $Uڜ赞!E H  !,WN
Xf
   9F.f蔜P[oa0p ~D f.02tNt!3p?d4`0Tf% f
@ JStf%ЅLtM1    [9ٝ|_ZY _^RVWbV ؜3ҿe.;s&0h? >.\c?Q O^ L.L.2
0G_^BSDLߜ[û`a pPƛ1cP&CFS!D蚛 7 ś@蝜1t0uūX 4TzPS20O
RP>2JXGc bfWP+&Go ffaztf.#fAP3۹#fCRϚf 	WfVw{pf￬.
f_6ًd蠚Xif^"[H  $,48<DLPTX\`dhlptx|  ;<Q  _г  ? c$
k*6
mc8*1 dBB
  
 ! !g- @^%
I"  `< @ G  
 @ . 0e6?:!"Cc1B; H `0Cq	 
a7  &  d 61h	29 >	@ a
bav۶, -? - =	a$ "0@ %{%_/$:_?Y"_ 7^p{$! 8 Рkے	/	, 0k6	;`P^U7 	 +91s0~ [Yg qV+q) /3+#k?O,  [. z }Jk	s#		
 	1|= (Fw 1@#h  '/# J`=_7 Z S^(, h27 . %PU# PV P@-'(+.P]hq;0p.p2`
5-_OPU/ m +\Oa	U &^0T1_]02hqEвp	1qTWEPpq20  TX |1
w*
OT"|T1CTT !@" "0"-UT$TrRKw W4N H
AYTT$TN3V ?:T98Tc6? H7
 T
>T7?;TUTsX	h>uTN A[T0B[ww^  '18 4 dTTor^a5aHp^T$N_/#T$A_?6T7#H?TT#	/)NR_?TTTlqYW~XAþ  O!{A[TXtYG[  F%Q~ 7QT_k+wk&w^00	{ w! T	4Tpa Q~oNPp^P\ h^		m		2XX~Xo2KhX	  ? ) 	T+TРOTT T S @RTWTW^TTWAT aT.T2ÀwpLNT[q.Bp!c02:`pLUjN{coy6HTbpRV1WirSoTd10T?
uƩ).ϩϩϩǩ^S%]A
 Tw4?:ĩ=Ecq2Ʃ5 s{UX_Aȩ'  5z1B{TKx 1v95 `ĩĩ yϩǩƩ$! !%
 ၶT_/$©7_?©0~ĩGϩ2ĩD ＂; T ?:TOrƺ*8P0P0b-_hg[@©// 5 ^mN؏		#!  	.н    ϩTϩϩϩɩTϩϩũ+'. Nǩ@Kʩl`cũU ©Va	ɩlqCWĩ,
g^]0	ĩ6ϩ©rTaé$TVN g 2! $t. 
t*P.>tI  gW
uV3.øN 	= Nt Ȏػr2? u2ֈ2 .lˎ 7ltl l.& t._&@.?tǐ?.Et ECCRPVWfSd'P%.]1.M0LXf[_^XZÐf`9$
0
̻^$
貈.E6讈fp$
B$;$.e9
興Wǐ=
	_^.]9t"=f(	 1=%f	}&fU1	蒈HfPfQf3.MIff  f% f[fYfXP
$t
8Շ nćS$輇0=%
=2.Q.с! !uf3fÑM>f_%F%u

茇q%%!2`( 
舆)$
 Ä*2u,j,{U, ' / .  Tt PS
w1gن#pA!J蠲 I[XÐ
s%b
  #|ph$`< R赅ZP
'↨SP߆$ *X[`Rz#Z m$\% RN$ZW@6.E#_ @_VQ#SWAte a$fذ%;E.uDff% @~a1.:E0u12 d 1u"ڟf;ût
 Gŀ~ _f[fXΊY^P	E= t= t _Xsfr:f=1_f] RPSQW1jW
 L _Y2q3$ }@r	.TPC_觰 Zcd
E$谒tC<u;葄.G`R.DoZ"QRR$ $4
1=$
KZG߄u 5xqIǄ`)A; a4h4F	 ZcQRWLt.m M$om@0vM,t]_4F]	賃a߄$`&oȑJ@$Br&}4 t?E`g~0^pVG PɄ)t1I$8m_D1΃`I$7V ZIq:f!Nu-	茐J .eY (F"fF P7 1F-c+T!F&2$P6[$
 F1e/@U݂X;uB;uF) !g$
F)NT "P@u^fF4蠂~A^F8薂D9p]pF7t5 F; oqX3FB#@0UpzF'AF(C 2fc3 $^0)2Y[<uݡ袏t<uR3ۃu ۼ@$J f fb  J$
ffe``
f׊f
_f		
f	f% 
f̀ff荎CR@3EQWUD 2F E]ou蔎u褎u?	fF4Q }8R_._JPF .GF4XyЌF6XHfPuH@'@T@zfF8fXf;tPf	  ;2Q..>ыFF_Y3vQ4   @ D
ɺ""
ĺW w.Et.;
u
.;Uu3}8QRi8PwOZYo  Kt~cS2R6ې
tuAP^_R9.%F p
 F"F 2N(̀ N(PFpGF'G'N'+$fF  f`fP1N)F 
F$Е`2.O$_F&FqnHF+F%
ff~ppF-Fa
.oN3Pb$ 
Xnt
Fѩf	f	\cb2c`nx+(/F
$F1fF N& n1f1R2.F,Pf..g` `F  '@^FG	  $ 
F0u` Fb% $
! Bu0xfu	Lf ۀ G02ndq"0
/

sn/
 2f/f{	 
 n !`N2AVB02Q F  tZFtUDF:rC6DR_aBcAfgq 0D2WPdE	F2_T0K@pK6tK2R_2hE7dEaEai a2 8 < C F H K L U Z d x   ?  ( Q@AzSt$^ ٔ Ft -
F u	F=!(^~.Fgf.@hri0ރz`z^|AzQ Nn.5 f0
̢ }v#|vF	@|v|{Df^
PF5$q Գfp}ͦAf}BF6 2f!V{5~98~57~z1Sq
Xf^ˊ߃fٸ44e^~/ ޲8	6
^^@zPFy=$a, `@p)t
 ۂ󀘹x"	ZYȎؿ`D	DfDь EeЊ]}cTILDu'u蟉D*++І؊}Ё@@%??`ODd CEeCÉ_DE	*DEe}HDL0+S2]Ë؃S[ |$0fĈD\\[ȉLE
 eMBacDC3D@< _vlTB<@P$PX;}?@w`;DX+D! #1ËߋȉD)Fz:A'Ej2 D(D*V u @ǉD+|-D D0oD.E :4\1\/^ ЉT2?03 ]'Ht@P D;XD57 ƀÐ~!2@^@S @X ?^P P @ XP Q  ` Q  x@߰    Samsung LTN150P1-L02    
 Aa  H }  !   pU Vf3 ҋ|^
uyЎ؎f( udf| uZftr# =	wIu 3Bt_ q  2QĀ ]`UG1	GA1	 2&=0*۰pLE#J6I*)Pe@E;$up E;X e9= uPWA_= vU9жN3Ƀ= t$9w 9EwAǿE b ׋A@} uQ70UEDEDSQWV^_Y[| u ? =@.|& t.|&[  DYDNDMmpxMm 2]a$@VWVS 2r؋7[ltFmA&G^
p p±  .# u ;= uDu

p$ %ڹ  _^VQfSr^
 ff;u.Q_ mY^P33 tt$@ЊÀ$ʊ$ ǐ$$2ȋ'00mD	&D&ED&EI D DPDfD{fDD0D
"fD$
` 0pXü4 Q *@c@d @A &02  L 0+  A  0`e  1X ( 0XB 8xVVA P	 -`N ((' @$
4_t*q$ppq%qQ3 b0YYtbOpIq$3S 0,r0!r3
qLq
!Aq
[}pE3_w4_ :SPȻh{pbpEXp;nBb<ap#/fPVWSu0<$0.*'U,P@D0A.D1ؕ
.}4u'+` @격
 2 T._A16  s b}&3t>E.eP@3@Ӊ[_^zS ` [Àt
t	p p  MS48AnOEM? INFOl     ?u=u
 B2u`1u6uh   %d!`\?X֠w򂽇0*0*h\'`H )]0*I89 ' -m]^ QUFUI),)}ҿ's 	AK ЍD)PIzs1uW
9w0*!U 1 7gWWw $	I?|liͱnc ? E ٰOs O U{] P"R@)%<2Y-}o Y _:Ъ<l?j-O??Is{cq5i$	ih'a9 i of'a'\`q#jD0*Q=   o q#p#8@63<@A/_"0*"AA  o__7 *
a'*
P+w &1E   3k
PD{  A/ǚI1K?  &k2ATI  lQ   1CODPS+ 
u$[S 
i1i$,i
j
gi%ai0 i$nhS$j1INI??SQP2.N= NXu2˃	w,[.'
t #֠g 0.u.&ΐv щ               t     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    N^EAX N^`  p L   O^A B^  C{^B J^ECJ^`  p K{^CF^ED`F^`  p aG^DcEB !6^ESI 6^`  2 2^`  :P w:^ > >^`  R^EIR^`  V^CS
0^Drq .@,^SQw*^F(^G1Z^F 
r^DR0 vp 1 z 2 ~P3 4 {05 6 7^K^Cfp Pj PnPPQsXsp q_Qp 1##`p 
_
___		_l___ѳٳͪճݳ_^GDT ^Iq ^L ^Tp:!_rp Ps~wN^N a&wB^S J^XDF^]
A(6^b2^g$:{^lZ^" "V^:,R^  C,^D>F0^q".^u *^yD(^}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw^=v^B z^GD~^L^Q^V$^[^`^e>^p^xDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^^Tf^j^
n^X4`h4  #_###
_#M_#	_#%& U& & & &%_%%&%Fy_(b+^-^ ^'^%!_V_VVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` |   tP  .>t:o$>U U#uG6JB qs
G≠} u7 V" "$r;sc۰$ 	 PSQRp.^	c(f.^f.f  j AnAr
u, 
^ t$.^tN^ u% ;t	.^ urt.^.9V^t!`	c.		!w?vp} a P0urotib aa
uj. .>_0u+.^t
 ut-Bt.{_ ;3΅u'u2".K  d` &.ZY[XfP.^P1_af`~"r">"e"
w B$? 8 b ",  %" L faù   Ptu
t>%Ά)u	{`,Ò!h	N
	 :twUq cs脿  gfPf&@1a}1q	21 -6U`<u f.R^=fu<=upfffDf.
f.@#(R^fC  f. ./`c .3pk!>/_d /_8d A9
uf3Јp;ZYf[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:FsI>%=s@>a4s7>(r;< u<~ <A<uB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI^ u\P@@??r6aftf+fx`Bvfu	6Aff33-f.x'h^fZf . CZ^<7 &Z^KkJ PQtނSc ۄr	KtY`Q`sV2' !	 詄s
ۃ`?r_^QW<;t=ހ  ?A Ts?urwT.Ws_b>蹃tT!yu譃uP	pX
C=cur:f s20W%t r#t-6-0/o
r\afb    
   P0t-*u袄r,$t
>r.d.NWa JJaXW\lWt5@"7.R^.;I`uf.;K`t J^\ o`96XR	r n6S` p2ft<guX<t<t<guLpr
t@8.T`><pV3`i!<1?1_?(/_?pÍ7:@!4`AG `Vdc1a%ea ÑЁtI.> rÍrD輁> H$r5} uf~!u%$ "PufP 
t	 R|]MS?e [ 6[ QCP
[}ߺ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>Yr#2].^.@N>Fr=.6l_mrDP[	  {tr@  ^.QPpP f T G@  >i
 rG@  /h !0
 G W'r{W
fv`GG ~r u6ЬП.O>
 rGG s'~td r#G  |6f}bMQ}~r0fu!`A~Fue`f10^<1pkY!\/U[[P'0	Y r'%3]pp@b ^ B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}r^ؒ0	^}`~{r s
]usB}u P?XYR
 &ies_/numb~ PQc bS6{P g t"@Qz6z.^W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  vzz{wukG>!t {6oRz M27`Az108J 
G6>}zfG螑tk{[9zGz:.
~z]"z4c{"=-8E 6	7 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUА kt`@.b 6ͷPpEr^w
f[Gff.!!^ At`	PRB ^Owf`fm3
G
GcH?^]_^dW؍ 
2; @ T_oS
Hg7 sI &Q AAAr<s8f f
up^c0Soft=jnovailq..
aGwfw
`VVQ@ u
D- u+@T rp] u62iwP>&	 EXOAM!~vAV6@
 A5|t/fTfpdc[./_D.kGIu^`!4.Da9O`u.S`f)_a-_a` &	>!VWQ- Y^_.^@aPPR^ !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^An$ ù p    \ PQ1.E`..{F`ô rGGA`wr8k ~5`f}u`uup~MuvOOF9zA:A0 r,P;A5`pvt"	r=`wvr
l1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    Qut+xt`C 8utw Du߂    u  +3R0E`F`fA`!  [s02!^s] E!t?.. ȰV ঀ;t  E

`t#C vu0<ro!
 12Ui^Nx ~@v r^aA`+
us>srvrs9s.,!, ssB;Vr'swAɡ`L ]rߴr6Pr$ @$rP{X" i . 
 A`zsuzisu#P# f֐"Ћ޴ ui
@)@"<#f.# #֐v` !vf :Ц3Sp/"f2bZ{p-_.9ud@VW/`u^/_ ptR-)w.#
t0 +Y0#p"#"E..VW."Oqp 
f=8s6q0<qr@Ӎ6E$p  >#o0!.#pLr.	qCkr!
VA4s: m|0;q$$E@0 ."  %?="/_pq'oߍqo opW> %Xq_rh߀< u
Pp PtQjrpψ1@+rp6%VoGf." $P$r胿p" .s{9ojp|}6o8=oC*yo oRpHdFouat physical addre_ss  N fpC ðSms`rkPI_,tB0xBls` u2 `u6;&nn07!q~noV&U>~ o {+@MemocompsuccpfulpW/'@9	x``>ף&?|F K*Puf6'ϵm]b>`+nf@O}mD`maQ1`	#|!!`mnlt `fHt2}.'Qr8HtgIt[ntYrTK. LU>eAJx1/P6|` r`sUuI3ɍ>`/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wt(lr%lFm@^~0N^ 
\Q&dmtvv rqBBEmtT rp+9rFB"ym<Lu4Fwm"d r`adv.?*#tud0~]SWf.>r<:ufF	[nrfF>	 r[SRir$lr%} u   
fnrZ[s   >lr<*r>*!Ds<$ 0t`.R^j6VV.0 4*=B* ku  тKa.B*?ޢr`0*wH4* l02kBr&`j r..*.5
8q>*#R9 	v~g	P`;D*zFp !8*PF* sQжec`c||*|qgF!
Hh>J*~.6H*@G@J* yaDH*@F*.4`98*w
.B*PD*oN@qws2Dt@Pp1`  .};uf.;u>-߃(swh.Af,  5p مq	tPuI` 9t3..>l 
uh. lV~	dhm '''"~ "

I`P.;K`t2IK`fCQ @c3Ú;	!>Sq@K`.,6S`%3@(.,@~R^FkXPW\@J  aCPU Time Stamp display= Speed= Must set sA to enable tsrhtJjr@de=@h.vVhuʨ^&>rN _<uFv%0.f2.^0-f. g6-fQv3?sggR"
c ter =   uSec	gt
ir!6.ECx!1.1fÍ>`gtG
SrS 
<t.p&`~gt#>/r/.`< uhgt">r.`Z
u
#l&W{
*Targpis@rt . R  manually if fails 6i/}eq9P=died^V6WeiF auЗP65e6.e ^D!e PQW> Ue>U gg_YX|ft2,r05 papPnr.p Gfu.  .D;& $Ahr 2w,<r(.y됲 #rCF YXA*	_ @p>&
蝿dw@zibu	1PhWi.Àr p#rTR.D V hRQh_NdS4jXoh0x I vIKJV  @OAL"q$ecYQ*h 1h
`Pcɝ
q.LO
(g.
`0U+g``	dy'g0
  &}[Eø s[>`tFr6`>jrG          ??? fRfVfWfU֡a2@b6m222o0 's 6c3>2e͸2Qɺ2 +C԰ͺ?2Хһ2 uj.2amaк2a ݯawb.2qa
 .+ s`@Ub6p`Qe+Ȓ>p2`$9bbZ
!Ҡf!2f]f_f^fZ*02 3<dDgw,d P$<&Xu
 $	,<w .	272N.2Q`J<uFN$<t
`RÃ? t#;Ot끽YQRWSVwd^C2.;~0t
|/2 >22։EG.2.2fEfG 2E
G
.2f$ r-/te   @ -@.2 tP=? @ ?Xth5P[G_ZYrepe  ` np VW>#3 tPo5c5ycqc6 z& 2 2ѣ>2}p	, 5' #X	&M';c_^ cER}6PfPǋfEEE
EEfpHQVW0G"u-6jS@0t6S 6!TuC_^Y[VW02
 `F
  fPf$FfX o l2 EA@ ; fQfPD$ us+ؠ% si}
uFD4/ E}t#uS uN@fD'  620( iQu K
Au#*
p	rg`1g
 /u,	 ߾1q/, fXfp5 !Asps0Y+5 <蜽 7`Ռbga5rӇq_ie@ aȋ`o$s"s1fEZ0!`D1S
Æ	!fo+B>sQ@"@*#@%>dޠD@@ᾁRS`rfe  #wbV+?^	sFN+R!%Dp	D
9MRu
HaI I7`&!5 6^<;us
(رN3AaNs@OA
Na裹 Q5Q5XQ"3"+ɶ8Qs
1oD1 F$)-R&d
*fs.:a	qmncVt@;f%$Pr
蓽.@qFbb$)7+ɠwPH_+KgD5VF`^q65PKAj5FFo<^P9d)?w76sP9N; ސnV@Ai8sR176sA묂N1*B<p fgF^Ë @t@t@ܼ$#7!/Bw)|CP{u
<s
>`uF@F2	E TE̼DDˢd%=upb5AIaR-df$0	К(=(t`o	
v+Ұ=uruQ2$rStY0< 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`qC|0^ e2fedwcD'dS 
pedQeb41>"
S~0 : `ka[X449Bnp^@2G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrte{F@0r?gOCf_2`0#escsssdsfs_gsfWP? vyB6X
6TA]qAAܕ ݳ@tޙD ߌ  + *2+*4+*8+f5c|-u sMȁU|Єu@ftsPørcp d
q t ?P~a slc#fEst a1u`6`%["	
 Kѧ]&rbpBb
Fbx+si *` d` p p P" MASAYA_AeAhAkAnA uAcA sE
WV6qAg4FW^_W t 	p!	
  	M
fw_ord db q tbyte AAAAA" Q ptry  WV.t"Ü6B:s6B,6B&ps#! BpR6W6B_?.W^P2 fXPľBXP $0<9~Farb !Ò  s봰+   1$ פ s뀐e+s-!sfR8    R8 `}9@  c      re d  (    $  ' R( r, / 0 4 $7 %8 < 4? 3	 @ R/ H  P0dX ` R'?a  b R69@ c Rg> h ; i R<` l  S !m  n 	eo p Sc9rq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 YIS
8&8 ` f l (0 8  LS%  Q   VSr/  p:     ZS00'8 0n= ^#2  bS>, f  jS:Q+ oe tS#, z  us 33  ׹;99   S%<3    4   u   e 
  H:\
8 S8 Ķ ȶf (v8# _ S:rð T t  ]#81 S;9 %˰ t/ SBFͲ b8w  % T98
,
 
b


r
QL T5??   ,Fw T5  w !e &  +T;Z .  (#  2%T  )`$ f;B` } 6	  ;  Ae F Jc87r NT޲c8R  Vf(R0ZV8^s0ZcEw g k	w oU
 s w0^D8j}S jSY>c 28(2Te0@9 {T>s  (V> ;u ztn TPb    e ' V 	  `d$ T$=  re   E Tܐj	   ݱe @ WA  B eC D E "uF )%G 0H 6I <5J CK IL PEM VN ]	O dT
8 T>8( 0f8Te W  E|e y5 y  yd y$ y yt y$I y y y4 y y$ yD y y	 yT
3 
1 
2 u0 $8 T	? ȵ  e   u %   5  w UD 
 w e   Wc8 j  r< ! $e  E U9  8#E(wrW -02 7v m;&@ E JvO& S(Xɧ]Ueb gflmqvv{&뉆쏶6mF	V
¶fm

v&660S
 es "f(.5uVr|<VrB@ EdJV8 NVUsf(U 0[f8cjp t`z 7 50툶 8۾(<V8w8E   (f08t
VуȬ ؅ྲྀs'8 $ $`$0 $ 0& ˶ f%ڻ% %08  `8  f!  CC%D\DEFiGHadd push pop or adc sbb and daa sub ss x cmp s inc decaa bouParpl imuP nsbQ  out a  jo jn@ cp @ z @ be ja jjp0@ l jglg test xchg mov lea n cbw cwd call_ waitf/f sa lQ 0ss stos/ lod cP
bbb b rol@ r rc cr shil@  a@et`ente"f`tA o iave`md x;la@oop q c xzQ jlockpn}ea e hltP=c t ne div iQ clVtc i
i d@d"xzxW lf0gpsPl@`hrd bsf@ r btr0 sp  c i 
x!seP 0 P b zbb p""epprb F`et gpUr 	l	diQ }l msw l`Usssss	verR w f fchs fkabP t "fxofld1Q l2q e1piBg2nr z f2xmyl2x fptan` as r}extrac
.s0
f`/ ]psqrs01^%frndq f &+q
ucompPendisn0	clein+!fQTf /esc
env
cst   fre0Q /r(Afb
ibC

;  ?	A	 r=fi2a (~ wbinv%wa ::ob @? 6 s zs 0@F:@s s AlBA CgQIA 8@=puid rdm-rdp 4rdt`rsm u_d2 wrxO .  f  yz` {|}F}.sx33~	t.dG
{U.
EaF,(-)*d.V)PS [XFe$U<v$tU	&;$!!{w'E t$$$I4芥"轘$Q(',fU$-

}E%$0_c<5r1<" t3"${v74&)6+t06-U0E#3$6Q9uF;m>'A0Dt+=Fw&_<JF8L?Nt!@PE,S<$VuBXU&[UD]` b,cf1i*lވ
nޕ+q#*vu
UJxL%{E}G/{'0߅#dP}POOQߌIϐ$ToT<(YUWeCC'jIC<U&@'tN^{86tH`߾&@  6W f3 t3Vv^
ꖿs rP %p R R  A
     <   P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vFt  /֐ 0wQ Zw;Px\@by   j  "  # 2 	 Q
 @ q 	                                                               JDBEXEPTNDBWAITCMRDCPUREG(^6RDDBG r^SCTR ^^MEMBUoF)_ɠ CMRSP`IOPORT5`aT ISPTEXTd̮/INSTCODEI`*	SMMG^dESET7ARGЦ/0UMEwWRWRQ
/`]{RQ	A`^^WR 2Ds`/1]{WR	 	T Tp  !!EOP
                                                                < VW϶    -$  rtˌȎ؎  v$.UpfP.>Ap uWP.^Gp f3.Up.H@ I O M N@EBC ^.@ ^   ApXfX`fSRoP.Bpug u_tT.Tp$ ^t?$.^ 0rW'pEpD 4#r	
XZf[`Mp0Np PS tatCu?L7ht-u$ظP hۉߒh Lpr 	uI[XC'Pe
.>^ t
P ZXPw Xr$$
0
^^5 r?x   hst u	ruX0rPhfP f"wC 
 f.|p!VQ6'f6e  Y^PSQfR_V0*U0*,&\f&Tf	 ^fZY[XP3ێϹ  s ˜W0   # Uq	t a*u'W 4,4^ u.>. u.8 t.9  g JPqGp } y}rsng#c\XQM}F3B;	70,%C
!}S
 f`B* >(^6.>^0A6f.R^6D.V^ffX QZ^ Пfj / 
uf.R^>r^>^^)1 ^ p Z^ P3r^# v Ȫ z Ѐ~!f%#6 .,^.>>^66
0 6.ffaJ f)!f%@UPJR1f{-pTf  K 0UP
_.QpX`0^fZtV
^0T <^f%'f
  TPV!	.Qp~w

.+RR
.^.GPW^S >^^ 0 MSZ.&Z^Q< .Gpu
@_e!QJu)``EKX!a @aI	`b  .S	k!k@%"k
kf8.6V^.6I`wf#RAK`f6O`f3ffS`kArkM3$tA^`.u	DVQ
6ed dTpt	6eU j j} 4
tY=).V0#g&;B*R^'Z^=u EVW>d!bk& _^FVW +>`Pdr6`>_^HPx pfLfVfWw>p64l /t 3ҋ? f1@
ߋG` 
t O
twQ	= ? _ 68) <R 5se>puf_fq&Yp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>l@
>lǿ  u
lr3- w|_HroQO
8rK<?prDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3`w-.-_nB6/`A)_A/_"G2k-YE.p"PG>qmBHr
x6ta >|`.s`<u=0>` <u  <u}0Pvr).ka>PNÀs`~s`DQ` w?Q%B>@
 Q0s`?^P2>`BkYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i} f.;i}w- AZ r%&Q0PPY tfGɰ
>A_W r,f 2mWT)bd@ r@f؀ffFgfd# 
 '.႐S3a `t
.~݌ffVpzxpvp"  u7 $P.~$qQnfU.E`.9`.w.F .:`0kG`;5A1>5`ŋf  t265` uuuf0=/Rk@f]anQn90P:`P;`65`1.=`Q[ fDJR RQ T
T

 ZW Z\$=
fX ZsSf3[ff$P  fff'f%$pߋ'RC%  ffC*** Please restart the system manually.
 .`<t$
  
$!$W$0AD?Ok2撰撍6ŀҘ2ҘӯPu@> ݚQ1Q ػf?tuPRPǟ^ ү ntJpfpa p6Tf W^FpOpPptO@X >TYßYfPQUGPF >J~Mu
,2 6  PpOpX]0qUf ]Qσ0ϐ^@Gbؾff&pf&  G>^ fG`GQaQ6^VfWf>f!_f!Q С ffD4$fOЬV 6ҧffP ȡ r ஀hXr$Ph5 X[õ ރ3@$<sA, r.ˠUrOp ` ԣA (tD_rq XPנ"Q!fXnѣ!ES  gf /tu}
> up[P}&p / cB`&Xq!g= BxxwB 86{yx@ ߀ #                                                                                                                                 S .2ℷ[S[W>  t> _`W} v	0EAC r3ۉe_`?2St]AM][Q_ϔ &
`9P
PR䍤鮐<w. [SrġzP `1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hbar1TaP<u< <up. .:.~p .c>`2p .?>b:P	wd.e> e,@p ˀu 8rۊ fg[ø0
.a.&bp1p.mX@E2@g.*f v&.f&˸ Laap7^*c.C3`0b  ϊŴ* # PQW`
 _YXR.iߎ
 Z k@@ZÆ;BB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x߻<Cwp.qu#rp t
ArZwG Z}YS2
d0 PR7 r  dI r`.pr`@ d`QR	 .p`qQ
t
Qh)Yus33`8u" f`Ph @F F@ &} tC t;k߹0Tta30h &+4&E pظ@ P(^ X Wu-  ap;PfatQ@  YeQRW.. {w#&.!
tff.F/.A_0Yu..,f. cQ󞙚R'@lmcǏڏː{?Qvڢdߢ1>+ r.W觳  cPPJ <t<t<
)SQVWێÍ-<t<wPXrs<v\.> &_[^Yy3	0		Q z@~Y!<8t	 `<P_Vt=EIAc
<
t0FXAP QpRt @Q$0<:|u꾐FP ff Pff?XV	 Xi
Pj}^Vf3
f^  Z  f`
Qf
p  >"Orf0f3ftY "++x fa
߰
E    1C< tN< XÀ Ttu7A!Vu`U<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ _!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4_ _P&mϕOIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYf% r?}sP r
<:uft_Wf33ɋ1 r	f
؟ANp:~  uf3w0<fw,W<Fw<A 70,0Ü@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	}A
Nt<Yt
<NtNP3t8tNXPL9p*HHHì
uÊG O?À=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Y#)Y+PT P G WIN @BDF8U$<w%.JGu0
t;wP
Ȱ
 3]8QW C  1 [n6f.Ƿ)ۻ0IQjY f.>)R[ 8svp $h 'Qv t?7H485 26_r SHz ueaJ2  UuQK7|e	$ <C} EuA{m"' ;l  Xc3PQfR1[3 Bf>@Q APBCD@öހQR0mSABC DpPOP R S~ c?[ QSWP).X. uF0	P2" <r<w,@.``  .>
  <  <;u@À
s b$ b ,0 Pq͏
 Y.l<?uf. &[u
f.&)R<[ ]Orp^?pu18x f;tuG2p _1Sf鲝a u<] Pɰf   `4gB00t  t tw !Ѵrer> ZfAA Uta	$`<`ut
*B5
u0
t		 u
l. + ( @
r?.

ZE"R@r r}0MpdZrЂB B|U
|a" r"<۰ tP w  "
 B$<  wuS0p@ "8t2kTuNuF;J t>/ @ u.SutΑյ "1ֶ
 " h]v.'u ˟                              |x KJII`BC8uĀuBJu*@u
Dgٻ0/JQL @tgB/AJJ] 7솀HĴJ!R:_$ su#@G@6J B3tB  DECB@CЭZNpBD r0`1	$ D[m rPf j qbA$<+`mb+
cJ$<u	f  rZPpc\ ?B읱[ h:I:f	f20f_ 
!$0As r p  R  O ~O Ȏ؎zЍыwh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu  	6r]dt 	#
C	EG	RXYjcA 5QPP(Yk	 ;ù G V  .:u.߷n^$"@
fQұ;!Y!fQRfCPt
' "c v
"2ɵ  W t"
oTPc@؊2fl  2÷QW!#w	t]
2< _YA3f@@ S' [P   X.
tذÀuÿ@u[f
4p#w"gf8 3&Rfߺf@'%fذ  +^;w"Z" 2$Ue <u
203<   $^4|<0%= 0q<%Q f<	&ka[<
@'P<'E<(q:k<
P)!/1f= uffX<+&<+V 0(]fW9 f2` & uf_QRfVfWSft,f_ff`,r!f A;tftfNᴃ}wn [fٿf_f^ZYWс; BIAf 蔂E_;uQ
P"0 P	]  sE:R,(SfRPFO1fXfZ['_P* 4v6Wl_ހO%Q_`	Q;Kf	:@TUf s#(  sf t s	  t
 @\QVWf&?p f&p@Q).fSP&Gf&_fXf[k^<pP`ǐL _^YSQR"fPw&f+d2b@RbPbf;t
fXRa09WKAF
ffff_f#f ff#t9 c  f_$0F iPSdMw bQVfuG PÒWf  "8s2ہz`ZaDSfWoE`-y qt#uP{!r )X߀tġɐ/[USf<t;D3` t
߀}-fu
utǳPQ[`qY3NaPf X1P{$PIR   ? rCch   }3  (` e  0  	 g
 0 
=`^8@8Wf f2B$
BϊfNff
fр aVWhc)S'%pW0APz;_t[C&0&F[_^Q1WRn8Bf0(QB簁tf ?tfA0MAXfߊ$
!#ff  S22!%Kr'Buf \ vuf K8s֊sʰXQ 7RP
t0*"Y#Se0S  uf a/u OfvUPfPfXZ+ ]f@$ff]rffymp`3zn  u= sf rAsQ_ f^ w Ѝt;kP *fDcsv >pB)au_.aȢ#f;1#Nf f @ng!Xd*6VS^6 .RfJqPZRUQf fuffVfKOpr=XfuNVFY!Uu FߊFMuY ^Ys]Pg>fmRg'QSVfNVFfL~u^[YrfXftA3PXQM諼`x N Ow蓂PQMAz X{PcWU |Z1̡ A\` Am]R`XÀ- ߋ_^ZW  f}ꑬ m _                                                                                 < ' +Gi@ + `ar(D
@ (nvArHvA. sNfօj@&t FN aR3V.Zr# Mܨu 6arkpt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF ô	 q`	 ӥ/2	r@e	~	p脀'^F&?s  {s  &G&w&GP&OD
 &	G!PR.Mf.u E	f0GEEUabgVfQSjf[GfY^f& u#GWfk  .2W`XP'F#~r .>t7  /{r?`. t8  t t  2SrV ʀs`,	p ~t$` t u/~ǉ~ %"NVg 1	s^Í6-.|uLu..`>a .:UtaaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w0[Y_0? tl>ـ?0	 r.u|
Պ Ѐ ʋ.E;v j'fVf{vdD @؊fA
@NP.eXf0` ȋ¾P	rs$
2

ў	fX!9
dD0{fЩv]f^PRWB@    RPXuUW:>_]s*r  P$<r!P~@Xup>q @<@гP  osXXty>c * BQ	F?~Q	 QV  PRσ@W> P@   XFrr#r^rT:rOt :DvL*Dȱ f umfm3
u
rPbl
u2 VWrd ?_^ q QP&:Ev&;M!&*E9aVBoCo0<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt24 uu@uu`  u2&fPS `006vaPSpsqD
>X`?D<O4a`tߐ a1t!$!"q1&0&PQȎؠRJr# SMwO "t }
`P2:Tt
Q YXÀuOu5Q,9a"   <s& ? t`P93p >-}uǀ   t| VW_<uW<
uuF΁ ><@g2<t.$S[M[|uw|
pf|`it\_^FS`}
u}	 !.b܀}@a`p;uD}a #%D0QV 3۬+^YD$f郃f}ff?ffJf\c
bPZ#f F PXMfP~Đ=r0&pw)pEwf u fu }Cu~s3SV|t` t t
^[PfQ
 0 < @f	t` v:aif`ff i Б   fQHff#f+ִ f;wfg3g&Sg&c
uff+ffa1
fP4SR=Q<$ o0zP@AfppffXMRAZru}A4Zr
pf>`P2ǜo4XZ[Ay$  h                                                                   < S A  j  O IYOO LvP#F X 	Qf&"q "&"&" f"# и"f3PW" .w{#`yp o>"` 6a  !".P "f.""""*" ! ai
#
 
 Bf3gf+"С WVo.GF< u^_QR׺s`rD.\ZYSRǊA<ˊ bp o̱%˰QRR źZR  ϤZYol|R8AS؀u
RRp	 uPXE %
cE%	$ZT
 
p`#Pp VWt_wZwU
uQ6rEt> r2
tC rͲ  r  P 
2!    χ_^aA#2
u[#rVeisCr"trS ';Wr6"Qr
Erߪ? ҝr)we  
 ` 넸    tK\	\*P')0\;#$ ?rIW(? kV_!P(B O55BvBP3Rr4;3r!- ,-BF3ɰD@DBGfʠDGADEAX= EBQ C D P@SI Q S CS= UD@ E S I1xception 4 - Overflow!5Bounds _Check6@Invalid Opcode7 Device Not AvailablJ8Aou` Fault9tel Reserved	10TSS1SegmentPr n12>Atack V
3General otecEOrrorp
q  1 =  System Ha!P2
 t
-XÜPRד2Z fVfR6e)Fup})趿/vz)pcP)Yύ6)){.)tfÿ63)j 68)`fX/=)T ō6B)J~`6G)A0Ǎ6L)7XY_W{QP)$QQ)QU)pY)
6])6*F
0)诳t)]&*贯x1*naU*WJ`u*_o@b	[Q G%; I1`(0X[S	 m6*ڟ p C8BBaaa$aH@0I0FfFɷ͋N
~fE F Nu3 'ȷͼn ]
`RQP~
XÊܹ /FFYNZ1A`QȴY`Њ  aÇً ,."ԃ 9. & GL.g.&-'@'dz Zw
  c Z@ 
G XYZ
p
7 Q  [ r  `؋   9 J  GQ!
@ 	`Eqa@ `
UЋ؎ ]_a@]ߋ3G
AF `P C0[q$9ao` $<u 3 0ؾ   fa3S } a [oVQ=3AUAY^` Ϳ
aËRQ3ɋff tf
pf3fRAыf;v+R'TYX0P@YP\UfWf&`1fW	]f_ff_]p_ (88xxxxp@@`P3Xú_$  S WR e qP0$TA D   $f Z_R
xy`
ZX`$<t.<t<t6p@0f?P4 0Sھ1f }! [ 0  `@CfpfRWU΋.t<;u+lf%A fq  5ǿD  ;fʀuff#良]_f fb u0QRfPRf f= ?t5fx LZfX u H%uA|Ł 0@4W?
?
?
?
8
ȶ_

$

p
G|{
_QW   ?P%D%00#mf <u ~<  u<  l<c<@%Z<	;Q<
~`QH<i?<6<
-P= uX<~`<<pXL]WfPCI 2 au_f(VWfSt$ Hѻ"r   f;ѠtN f[_^fZfYff r k} Lu
N`oıu  辱 s r 2fSP-ȝfXZf[ü1|]ff\<"F5	f s"s t sP  QVW&=p &p s fPf&EffX [p U% _^A*Pw[`;t
X2 *W 
_ #tߓ$X sNp s@k?у`H fPfл0fm P8s2fYZf`ffWgfǃ  #Eg  ݀ܺzA@vT2 gfgƃ0 g u	f@w1  f@f@f_gf1 gffgf0	Z`fQ@;gg&fGfXf7z;wf+f@{+f7g뀋}ggfb	f ~#fgf&fa
t@@P	3:
y
ff0
gf3  P
@r@
A
@  gfo3fS̓ wff#b ffyZ?'wf3f30n,߃;w+#4ܼbf[gf߷ p2
fOfP	c	

fAAXiP
 #W!fكs À +SfVQp g46fFCYQ  Y`@._f^\ g&GCffT[@u@EuPPu!uZ:PPE EPP runtime BIOS - Version 1.1  
 
;$;.;K;;;
<2<W<<<<<<<==	=A=wU .:]:.S\!.Q\ !r !R.Q\
ZpQR`!Pt<rt2[5$ԁ !Ȁ
  -;" {`5	$ X p[	.	uR x?uR]	] SUU .Vf	`&n ^zC  CWoV	al\Z uߧ
 J Us PSR{<r
 j ?G ^Аr
t ).>@= .@= 
   PQR3uA ԡ 3ZYXHP  SIMPLOiMOTOROLAaVPyVS~ЎHyɇ߸ Ws˻  >ɷ7>ɷ. ɷ% ɷ﷣@ɷ
SR &03-&Z[>ɷ>ɷɷՊ@01
@ t0+؋Òcɷ`ɷɷɷ~ɷɷv&3P M<S:Mt6= 6 
6^߃VxOʤ *~>Ӑ ʪ @ʰ~ʿ>ʰʰ
Jz 
0XʰH@	kʰ?	ʰ6`
ʰ-
ʰ$%ʰ~%ʿ%ʂ+ 
r)>&~X^ɐ藮"
`VQSQpaۊ`!`*uWt _u
fReKfOeH20/ *9ma VR\*txSR ڊZ[  Z[K  u?Ƞȭt%PF@a@0
ud8APjZ^`)u=u8qB@e
ً@詝p 2 ߒ襝UR)u<蠮u7Gt )OHtmڱ
lZ]PGb 
 s ]`Ks:KxqSQ3ɰYpްM M>rQ4wYs\@P( 3Z[x0"?=`"P3
ݸH 6_ٸG qS QL QK 	S
@pN pM ëc'
(<PdC'DoDDDD)EEP@ &` XW<r .C_Swt 
' t r
2[e 艬u0^r!<	rr&W  Qs" r2.C2& r $[!
sw r 9q	8 r 	&& rr	ô Ss+&' @>' ~osa$ sQ
u>[ W r%p$S r rq	A9 f" O$ pQ@	Pm ZmX1#t sA@ttadt`bpt t
@uQYÜP`
 lXr`QPPPtXdYQP0 t	` QXd$!<!t޳س  q&@tPGpB`{+ (`<u
 @&   >!@tA AuqP耨@u  ,r &w XV߁  0`O  r
 P<Fu uNs	 	uA
; fu	 X RtGTtu`6?FtEuUKrPRtKxGr t& 0R] Zz"&Duha;c h 
Xuh=rX&  U au@ ϡt@Q!	 MrbKr
3NrNr蘘 d蚐 dx $& 8t ߗ  0zQX uSQ^ `b+H `*C: 8E801 P {@@X@3@*jC*YflraQms\j&D
V &Dt [zl 
B lr!0rlsukF. uk'kI$krOlsJcʊKZ SkkrMlr
#lruaykyoiZ2
 0
FFt N fF" B@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
F)tɋ r4F$
Ft+ F P   !VPXV@"1WPWR u	ZX_PRARZXfLL L	L  A " * Gxx  x y 1 " s*
x"x 0_   s w_X _y\[8y y `b é-T ËEtE
_U  er0 t
RrÀxf`qi2tW &  d_&E3ґB&U
&]@ &EP t ûlLu _&E@ !;f0 $PnP!  M 7M M    e fPff  @ fXtfUfp fSfPfQfRfVfWg]?rdf_f^fZfYfXf[f]ge333jrVd4Ad^;sgu` 
3 s M tAt<V rdDg}
^` VWq^gEdTg}ސ
}gE `tr	 	t}d8` W<ytu@DSo
`PfUf]3
?t `$u Ó' .;Gt ._
u fg6$+' +k@! A  B C SOPPBPIP7OEOg]苀M tM3Mwo ]Q
N uNBM 4   SQ>Mu5㟆ôԯ%r!<肠3ɸ  3 3Y[à%SRV&MXUߋXPЊt腯t# r>+ M<t<tYƝ< t3^Z )X_V  ' -u P	ir
- )Z۾QPo =c
u	MMM2~Àw*VR| 拴  t.PZ^PP)QPQQP .RPkBBX$JJ2J쯊BPKtJ Xu` o SQ V tA&q JZ  C@A du*uP= ]Xruŀ̀2	w
 hp(8SQ2<

2ۆQ.
$2rqd$<w0
u@ð  ` 0   @k  G#HdIPIfdfBJd́JK@{SJdMd5nH" J V1dP <d;]ttd|d]^  R 3
' ' FǠ  F/R3 .;v+GuBG
`_F/ {@@p% 	pXvNuQ
 	߀0ʕ NY%'
r0123456789ABCDEFS S׆[U uPxXdk]<t@e r
ted8D^uQPSQRWusw T^uq_ZY[X`|`h&
yt,ـt&M1&G&a{{`{ǯLAAAza+Íu 2pfȃtm
 Q ܈$FKuð`Qf
u	ۍY;YuS؀u-u)"4  AZ  Y3|ߊ$f
f`< [RWS22f0pr u 8s܊[_ZXfQWRfP
t)P0or  ff  ud8ufXZ_fYP f r03߃r: t+aߔ߿4 v 
t8t	
uY0	g&;t4g&Ct,g&Cf4!<vf  f٠}
g&:#C1	ВW޴r7fg&	f`r!f`Gag&O@` Nb O q,_f[ûb2p n l C  Ơ #  ^WȰPI2ð
:%,p5.'p$zø
 ꗊа{㗰	ܗ2՗s s	2 җ |0×輗 ۰	  z{22 	À tN :4}{vo
Z$ 
a$0F BM7$2
>ùVVVWTWWW
X.t'} :<u 2Bh`=c hڃ UO1qqsw+sdtAݠs
2 u"r  |  i .D .Dm~ `` X&&D aø0 м ` j &&E  }3Լ{1?kQPTP !1XY`.\.T	ώǍ>L.L` `va.D`vaQPƌ XXɎ6aÖTTTT~ p=@P "1ےU-QRrG      *[%	` Gd d@",q Ga a|O 
p 7Gr rrs sq]
s"{  
P~ 16r߀	 
)
 BC$PIR    riC0  wo  X(00X  0  	 
 0 
`e. W ЊB$
ǿ_ϊ`
p aVW [S;[t[ 
[_^P3  2B QӯYPQ`c_tAPXV.[ ʍ6 [.[^႐`q u # $t$?aQh@ & `r 3ur.Q\r3' $< us@LI<u	.Q\ u< ׃ pP^$\   tupu	V $
4 S0@ u7`O<u@ ذUNNNO Oط0$7#!c#j^F^T^=^  M 6A@  " *;0z *
rsB~68y Ay bnc é u`U ]EU  ʋU  ذ")r t
rPef`tJRQW %  d_̺~01&UY U &E! ߀t &]@ Z`%fa#_  u(<sW13.__.22NP'wXs}/Q)p`ru..&+.	pp0@ t^P.&u @ u42..
t wPUU*`*&u XY=3P A3.GP
XPwo *.dorWȎKoEo_B?`````aaaaaa!a#a.a0aVS3.:E`u`F[`JK`"@[^* UFP`2SF۹ S.N`F[CpN[QFN?tZ`sF2~ tY@p7 `  _ ø8掐 Qd{Q`dPAQ`0Q 3`$ $b!b*b5bDbWbnbb`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2o '2233Р|af>"  t" P a2ۊ( Ҋp ) Ǌ&)  * 뿸* >+#1 d>,0.- &) r	.oPR u謿4t;6X6 6 o43
t,=
 
"=
 
0I5w<t<u FÀ? t< p s
Ê& 
<uaw\wWQwu& }` uݖg`!AY &
.贑>Y6 FF;ސt2kd d.d7dSa\"c` \0ba3ac]aR][D]E m~]`[ޒ\!`\ޗ\M\k\+t\ I|\ZP\ Z{Z g}
3gE
 t "6DW  [gu@sU I2
$t0d&E
3`    F˽	U>]>
 SQf  VF! =s^(2۹  F  +^D!8u _#Nf^[WVQCuKEP! P!0w $I^:u:\!u <rg=봇 @Y[_S  [@f.`hЍ45@0[̺nйu  Ga . .BN N.Ē 2ʰ1ˀA[ւ   @ y  1wPPRRwooւpӀ   fV jYupt u3N@߃fHVsu^aIunuB@N\p EShgtE u
gut!Qv
Lp`N  
]]f^?QSWf@/ r)v0p!ufPs fXt_[YfSf<t;f3f  t	f h̓u
utǳfyff[`
 3=afP fXu hVpۃx 拔 tcPt>KXSx$PaXr$fQ˫u!P$
BB 1JJq4HX^ZY[d|P` 
AMDK7PN/OW!, WfQfRfVP	f^fZfYQ 3tY.>i `ܿiÊۄ@4uﴀô  S3ێۻr?4˰ t W8e 7jfR1,e_QuXpvuTf` D Offt;  Qf3Y,65 !vp˿ Kfaڀ_SYSID_  j _UU  fPS^ۋ^&t` $ueG&uFtt[fX]x( _%O!O	N"  Ӳy fl f@f=  u2p fl P3Ҏ¿x ȫXR`:Zd@@AIOBWBnjijkk~  $PMM0Tu &m                                                                                                                                                                                                                                                                                                                                   
    S    -%  ;n$$`fwy?hAC  儃D
 uj@ t%v v t ArMv .EsN-f-&A F'N- a6a  @ t	3!
tr ^	
F (|r
 	u^'Ât %{1+	d1*515诌r0/5Mrr[o[
u< r<0s<"N@`  \

u' 
$nvf<0r
sus>.u.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 r20s^s6< s
	OtE""Lt*$Ot"#Ot%>" 2!)A
 ؀	.EF2	
r]wsmsߴ1I9  <$u2 *<}#"< u<@v<%p!2 ÆUu
F!UF% &F~&=r&}vP8fRF'P^S^!S&EF'f&U&]rQ[P@ [fZsSQtP^Ë^6wKAؠrf;	DE"d~(LuTMs fPf}3fXr1>-E.  .GTώǿL K./pPK3V#:Ttt<~'t9r0JQEE&Dq<DD@ % 5vJ$~6-濹 6u0fPfS&Mf.@f&]f&} 
[!
0'Qf謒  r}0rxLt迒rl 跒rdPtZ+cr@ O u~ (um-Vދo^@tffm_ruLr Yr)8r$c?r蚑r"Va	)rj!PTPQX rpw
uߴ `fSfRWBt:ـ?f.EffffAUffsP-EMF F
tSuNff3fifV-f.WP*f8f'w*f'F'*2t*f
VvfVv 4_fZFsQU n E]YRPXtUW:>8C_]s#r  1!ZRPR92B@ ǀ ZXQRюߋ go^ZYpB`SQRX0% [F m `7{h. ďQ(&Q Z^N=rot
r`a r[v_"> fKf}a`, 3S5<s--O8L9
t" >G<P#<Q$@ dZY[PQX hv   t`rzru3rij`wNurWu
p`dع 
 Lr.Ǵt%ttt t	tCHa% su~r	 2PRwZF sH<t<)t<(u;ь>A u/WU>)`]_34r0蓎}Cyq_`_^a'c`&PSR 2Z[)ÉRFtN+P X7D	F
+ȜCIH@FEF
t

`$PXfS~ t=~^f~^߈^~7^~FF
>FFF߀f[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^o
^QEfYSQKfPv j 8rC8sfZRfXfP8Ff>CF VvuKQfXr+_tðP@P3 Gp1 tffߺ   Rf+IYÀL@Weu$`Ύk2Dt
.4芆^G fF! PXG t<"u<"tlV3޾x 4|Q&?s0  s& p  &G` ` G봀`t&O _&O`uRp`?f&G`Pa  AWQb b Z Wsa,ZX7RQVW:W qtNᒀuuw .!6a u/AŠ ?L	
? t,{6pNoAOGA&&d&D&t&D3p;_^YXVQ
w} " uRPD
  ^Uqt' r.]ύ uя r.f%_ ff UCESqsffr X  ņ1f!u%f#f   t	 ôLr`t s`}à `a0ff#ffд frpzfafVQ<t2f3Cr6
+f 0u g> ttr(r 3ǇP߻@ uY֢^j@n+:`@44t?t
  ra ʲz 8-t(@&r!f1u/t (d
Jj?葿t:R!4?g&?A0fca`fR8t , tu
@u$2(H@:)@t'@u'-*t{p(t
 /!-  t>v fASu2Bdϲda33q 
t@  kt}Q?GXri/p/B/RZ/rGU/Z3t@]$
Ê ],]$t P]ZnfVQ!} 0fF3YfcS0W]^]m]  ^8]$?]N]k2?] ]/]@ \{$
]	    SfoP4fXpG	ش  [USQWfV~W   _ W <5t^uf3 pf^_Y[?rq Q~0Qfûf FKt
` J8u һQfVW_f 5 uց>oЎDw@tpb_fb$W㔹 _T*u	 E 
yjt)Ӏut&  5& A)wu&u#]
u! p8W@ UAU} RtY pvMuG	l0bu< u3uOQtru}1 t0W> S:u@pM8*6R:EFu 5E0P} 	QtTt̀t߀EtH{71 F )t%> t:& tSuҲEU[u T3O 5 O 蕿E>I q u	P߳XuP3 tLX랓tS%y9E} uttU0#)	&2!q =E3L*x3;r.Dv+W+Xu432#*u!.ð-ܐ*1!	 2K<Gr<S쀸 4,G.#]C%J u^$
<.r!L 24$`.AK2K#/PrPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10Ü   !ݲܜط$0<:rd uꝠ݆P P H]   = ~@r q&@VV:СgfFf^0RyZÜSt	tv
 vt[` Ѝыh33 _ A /_f`0:tE腙u '$
Ā`&aô#ĴĝfaRМQtĶ$t$< ȋº `q u1pt)V6L,ĸ #&<$Щ м  GV.>pE×i@ ؋r d۰t4t p掊肬V2撰0 SRW*׿OзIr 2 |`p3_]ZRWQ,Ԡv@s Y r3O`Q3ɐ!RQWSP b	)< uX Q쨀t_Yfl !`2s?X Jt	u_RX( V_ m 7	XP)[_YZÃU2<UuX

DYJBBǃ   brT^"
!  BP ^o32
X
u	 ت *ê`VWQP Dt!WQ0:t
Tu8v
Y_PY_XY_^ _SM_ P_DMI_   #9s ޠF +XPUv FF !Ff ]X"X
W8 @SR3i &g +pa 
u
f_N@  ]ϰ2ðq t S\8&&WG pGGP    [  NW!@   W P@@\&_\p F0 ]
..c3 и( иA  P
C@@ XWP C<w3t*p O $` ! & 0._{Q@`j QX^2hQ$3n1    wR0K۳4!for YfQ\fYgǝ[ø <a3]Ou r 2QfPS=Au@u;Áp u39 u+ҁ?wufP@u UXu
_fϋf`< t``%f`{At{Nʹ|S{_ k@Q  ~{{ o{Kǜ|!qO C{P r{_{UQ   A+{op446RfW. umf3gf&
f=SCAFtV1G t"0fff Wuf(#3tfPfPfXf_P_3{2_p9  
zzzOّzo(4zz,az%´+޼b{{VWv{%t{* uzȼv|,軼w|Kf`{%{1	{x w%r` +l$b{ r<
%	*P' @TO xOy er$DIsL MT[p.øJzNfUfQ ufVK^NrMu gf@ N V Fu(gfFffffMufY2 Yf]Ë< 3R+fQSfVffLfT6DfLMf^[fYrXt	A3PXfMMøNp O蟥MfS0/UfWfPMt3   fRfwZQ_f])^Yf[PfWMc{tQ!IUPސXY fqAlP0R YXt
 t$Ct t! v n7M1X(RfV\t  \(042V{f!nLw#to   r $r	 @|f^ðU; QWVwy^_YSQV3
Ê^Y` jVޑ e a  X FfV1fffa@H.6fff;w	rf;w %AZ.- An"  umf%>3YL/aBRJ@u$ : :ذ1JPo0|J= <rqph3f@ Pl
ffʝ  off   f-   laRW >%3&G;r_sZ  <%<t   љS& t	t`Q _fpWb   d@    $@P\fYX4Z?4f4f  0h hg&>tq r 	r
  u f_cbi^f$fߺ tt,$
g&"Fg&
FI*$
g&#Fg&FJ	fo#F	poPfa
`VR	t#1
t.
t9tt]t&]&Uu2
~	tw
t11tFt`
t~gs&`
g&@
p
 
u
g#& 
T|} 2~3Rwf\&^q\QUÃ36.L0.:Ls&`U'.D '.L's` 2`r2wW }2P u K렐^t
`W3t 3t
u!=FQH3ұ@Uu s t>-.| .D u}} P J}uLv   e3puwv`bW_tURQRU`@K2YZ6	u>^
 .D P@+ t#V%L%^ 
%.L% ]Å QV | Ys.pu0	 t	&Uu"r ώǍ>L |  Êi.f.O|fF  X%.|Y%߿L\9:PQW 3ۍ_#_H?ati?
/g uRWf;rfo`Ȁvs'`1 u: t-Aw(@tD<u u  TfaUQ	U F @ E][__
<t~`Y]þp4ó1PQRbfv2 ^o~RJɓހ	sr`	x tt - o P	 ? i09`KwSr=s  "#@@r@}n 
`Nff3u
P!  f3gfF!ds"yP@ffڀ^Ɓ03&fPeQXYq)YaP'уЎ@{98 #	f<t`  u#f$!AP ~]faQR3Ɇ 
tw ZYJB"<t$
tAJBqpvBa{{߲ݯ *{qݰ JHbIs@P@]FF
]X `j . j v
@)Mf.N. 耱tI4~r@5p3?؊^)1a`uw t&Du .^^; a.@t&ڃ`ԣ.^2 uȎڀ@S6t6^2Qؿ.  @ PSFg`'.:tX._П`P?
Xu!P?<Xu @Pҁt?a`
  P/@/aP2Xr-s(@r3H r  rR VvF\r:Gs5&DC Hrfڋy苡_֡FÉF(t S^$}:u [r
F&F$%&=vHH&
D0&du rcwu
:	A	πϠa&DB êĪAT0	VcH Urp蟪sʁ `-s8u fqt
E$藀Eab&G)
V Nh8Kr>u r߀G Po3F) _r\ {r=H r8ܽQWss#

Rr
3 s@oM1 |#k#'F("r#謲Qlr@rk20!0p 7×!r"!F( Q'&dK0#V&Ơf)&t N.cD_ fX QE QRfl f@f=  uf3p fl >t@&?   Sd `4Gd{PQ3 t1G}7u4rdr
` r`T 校F X @F$$<r$:u s
jwp_ _A$ 
   @`
  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&!Ѐ E 6F (@$3'E&f$`
ĢF f%R$PG ;B(FGq1ø fF" PXۋN8NwN 4o2NEEE0(`00s?pE/ }mPEB
 r
fQ/mruE贀fY_/++U+Ñ &u{քtbrq? VQB  BYy^	G $s
3
P&u3` ?dD@
r
%uètàt <q66V&TЕup 
* &u^"Ǵ  w  xQPXuN%&:Lr * r$ P @uߴP<ut蜿C.@   ; E qs2pcC$<@t-22P !$!$qXw [[ğ"CPù[BK<PY
`S[PS3[
u ~XaSQRsɄ3ɺr8rZY[PT83t  `88f_PAMS3VW 0  ߋ u
P
  	˻ʆP7rrPɍvpF0 & O 
 30&OˁFUWn覚_]v
 ` {_q[w 1uIp 7 MB RW02
% D -ƿ&= @
&FG酰u  ru#' &kP
`RJ4aZf3&
 tf&B&f 2ffP3_Z	GF  u2D$F lsN~ t
Sn@[=Nu#PӀP& 9zu).t

q6pWVR_-&`%P<u .&P2^_tRVW33 e C r~eDfeT
@  eD   h5# ̸ Ῐ..]u "e\ {uХ ._^ZXW   hͳfِD ;t.Ef kfP U
8_
 PB>I%   N8 % @ % A a  / Ag   d z  9 P "Bp  fQWh f R?^zf8hP`PL`  f^   H  $p`| f0
Vā rMf[5f 0ff% f/ff  ffX2_jRfxffú ,5Z`PoXfZ0fSd```诗f0d@rH=
f<~f	QPRef%0

 iaDpZB_B3EO<@19:<Y`f1ft~m" QBY  +fhfaQfRWf ffӿ fRf3ff"tf fZfOu_f:Wry^tp^Ogpyc^1rQ[L G B = 8 3 . ) $    ƷM{ c4QjpD@YÀ'B2ǹ!u"!FChC _f6E_f.Q1.Pp   v߁Dt vf$ݸ #%@f ? fgf&ofXq APffa !0ω	d bfPS ػ@1f.F⿟O#&:.Ff`袪uh9c h݌ 臿uh%aúB ! $%0Ü.F :!型(.G_?q¯a==>W.}
u.:tL u% t>JrS-.[t D.[u ^t	t_M_1EfUv"v` t Ar`Mw@ .V PXF
Xf]h@ &A ϴ2j@!PpмurЪЈ\ôV
	=V.6# .t.I.
Lj@ps&  |0u{ 
^SV#؁p.d.$ʋд^[	ã3j0rcOt` 	OtOtLtDt
tt

1u	:
.<<
.}h $ BÁUu	UAqSfQR#PGrp
fL\P;Zf fP<r|wfD0ku
 vuIp_SQVWUuP؎&Br& ȎX,> ..>@u 
Pa 3PB &Gݿ&G $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]_^ &?sa {s@ `b 
 f
`NG`e fEAf-f@ 3SRWP7޲ XraȢEV(XLuRE<sfQ@M}_3 Pr/>-E.  EGϿǿL د
./17p;[M
_Z[Q.>u tG`Fr=
.EP .&D>a@UA%50&Vg
َɎٍ6-ʀCqYSRt5ËfQfS.q&GФ@f&_f&_ - Y21[fUfBwSsQSU*f]ÖT'  G y   y " ËP t
$貍rg`tW   d_aj@ q @ F0 vP  _ +& Q@ w  ߟ @ Q Q c t @ 
 G @ 9 U    & 	=iHewlett-Packard 68DTT Ver. F.0F 06/15/2006p* ]  Z  l ~@. uq oKBC
sion XX.XX  
 
  _ 	o~A`}#  } @P " ƐU10 AMD(R)  ׀    Internal L1 Cachea _bi2e	
   6PC CARD-Slot 
 16	 www.hp.com  w
 `   > 


  ! DIMM #q1(b28"պS
~6"Rpb 9"@],No baut@y'+"8
/_PSWQ  GktуPwY_|*P$$t"Ĩ@t 
 ް  XPJXXP@  t+. s#. sXPa$&  ~ &XX  = spڋQfP SQ  2SjY[$
juFf 
۠[N8tSFtk 0  Df t0  @ t"'  t `Q t	y fXSaRV s Z2
Z
H
i@
$w4 tNff`4eAPu4fafFD7 f:2`tfFP`^D _ s fwКWzf_f3#"fF$;F(F,q0f3҃rBrf-5fv,v0hfN,s- v(X(@$иPN$fFfV fNuf2N t
ffFDlf3WfpKN xfր  ЃfYf#f#fѐ
0 fHfVPf#f@f+f;FLvLfFPf)FL%	tPyf@bvAfI!)m fBwf*x@+f
`fK
Xf%	G -fA d!`
;Vt
fAP
Q
ĳ6"8  f%"   @"	 "f'WF 002.FR)i !.P fR@? ff  ffZ PQRW_ZY`ĊӶt"t+f
f[C{Pͳ 赀 SWf 2`c FY~f۸ fa 0 _[1	?4fB3/@ h 09u
 @ @ÜP8  >PQI> "K0q2r B%a Wf`f ;<uf븴10t _f@v fsWf @fZ03002Efanӿӿ3x	 fa3lt ?   @"{f2%<u 	= r= v_ A&f`@cQ8 YQXYŀv"y<v.kfGfRZCf@-8P*LnѿX
x]0]*望5P`S)}\fL @Z?/ZP(

fHu@:\bx	  VX   PJ0  > q Mͤ0}C	@f350/  tf;f%ދE&f C9 A p0U( π`'d F˂R1{ʀgfZ
עy5R 7
QdB^!fXt ?f !4SfRf`:D[[f40T!T,	 `;s% DfAu.T  SfWp3P*k @X Zf᫞CS}Ϡ$!ZA  FfobT51XݠˇfϋՓpS# 
쿆ĊËooag (,gמ(&  .(gآURfQvVkuLfQ2=fA<t1 `eQ !ϱ n 0Rr.V sfYZ]ÀTf;0Nf;{fZÐOWf!rfrf+Z|ar
!.r#|s
ua

<Q\GM	;rrmBPmXPr Pp$Ssc[OBMI>lE{/lJOAZH?[f!ufXE)t ft/+f"?#fSQ< tfA7۴D2"ǥUt?$7 3#tcˤab0
ð-@TUľWV@ fSP~WB Q Y_W
t^plfst6]V! <5u G	F^B^= tys.?
<5 = 
u>
_r Xf[2PX^2YcvWfVf` t
P E}r&< u P MȐB S f^b$Yô P?Xs0#Ĳ##a$Q$!蚲~$P)
u $/!ð) ? hU
  $
 O _$ Ov$~rs 3+p\t	`
߷S)gYðQ۰3r+3ð&QtFQ!tt	*tEPQS&"
ǆ[w <t<!t
<}P	<*`_R4

	`ZQRgs݇`-P [ZYpt 
k ) 7VP֎vS<	 [rapX2F^a ë!B< )VfW< u؃ t?Fr
D1.G 0nPK`_.Y3|
u|	 t0  $<<q<
1{ߊ^À#"  / ؊% %"؋ !4*ZPu `AbXð"MQVWP 
 5X_3^YaQ䐸Pw2b4߉ "QB2ʁCm ^
P'R4#f1ðW52	R"5 +S,ðUT,ՠ Y9@Zr:./s&U;Ü= s rsD
F`PS ){ _ ߸^ ZY[XSQwt}. ! !$?1XY[ ?u APdQ\;ˁPQN 3۸ E `SQW uf<0 _`` Ua(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457
t Pu v5u t
&  `
x_t^t]t\߀7utF5R3< v
<ar5<{s1$PɎ Xu2ôr2հѾr9_2.S ukq G$!u@t0<zw, F 
t
;
	{t
w
 b2]kSJ, E ?sG@2q)P
 t"< tor0r}	
2vPQ@s	} J	eEǑ=C HP   P.Nuaa@uXXZXp! '/ oLPXŻ uM  M N N O S  SQ  @TU	 Y
 S S@1APSC  R LRQ SR0RS ST`RU xRV |RWXYAZ[\1]^_  d` da db Qec'ed!eqf }ZZZYY&ZHZY^kKclfP@ ظt"
桰   u$! !tp &k X(    Z 0ߠ`p	!B  0lFpoypOIEMAG  IZ P      	
=  `# HDA-L*DBNs A-E r Cu ~0USB-FLr CD Hs LS Intnl .CI-%q ` 0&% ekO  k H	P 	/` <M v` c!F	  ?CD001EL TORITO SPECIFICATION Qf`g t/Ku (v$
vô$vvvfaVМvt
v$tº^Ѓqf`q u'q'Knv $hq~v$^vfas4q  tTTTT%  A    G  0G  "{ y" P3@qb KiQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPkXPu3;uCf N  }~U fJMON# f `df>  uf @  > t&r_VuѳPp  ff+fQf׸@YrfǳQ	ZfXq>uIf s@
f6ǁ0 {urr>@SWfS"f[\r 44p34 O7  K SQuP x$@ؿX锰{u^@ @h{XeA$vKXHPtu
蕨I4
<RVWf1.1V17 cPQ<VV<W0U Pa T `afP >pf 6
s >upN`1>ʐ(y-"l +*.'߀.'`&R"qu`a ֱ a@`W_^Z  @"QQWVV_ ؾ ^_YÌȎ>Spr`"vuP; W3r%[U׋  r.]''a /  o'ڃU's'9!@B  zh_ܝku`&ݣH {ݙݢii,dA'D	'?2>6@JߟT'^@ ofW@3sAQ<M,u#9:p f3gf&ff=SCAF2_U< u
 	<! F ]  <w&< t'V3ɊȈCF`  ^ t	  AװVV<v^.
t" B0uUׁ  #]URP Xs.V Ou0]A ! VZ g ee뙡"ݹb 랉㽍뗍<fRĸZ&"'% Quh .:<t.|$2ɵ"YQ"   .6:3/p$ q 3۹ 3Ҵ./@32pƀnuonRwp'T`x uuOC<2Uf]
 N]ϜfUfPPfXZ+ f]ffŝf]rPm`n  PR@ZX<0  !$    pTPQ^ۊRPQMX0 <u
p s귄3ɺ*RP.
`.afV`fa
uU	r r" s   ;0A۱af^p=쿃`@*2Z$ԉNT@׎Ǎ~WF$
&пFG &U_ڠ
	!_a PVa<^XR Zb`$0Z6G CP߻u EfPf=<01DfX  W~   wfP IW0j3fPRf  f= t5fx$ޛ L$ $<u	 68.< >!<
D<tNTG  r%"   쿨u_ roN r@@9 vPY3ɃdtAaZ01~tjguSaP3ۃt~C{ Ί96XP-*}# aa
rd
xrh
crQXۊf 1264r$< 'bf"f<R, + -ff31 0<ZGGEH \ ;SRR3F2۰S)"fV$

_t1TrWTû  -@ t@ȺR`Qt@ȰPBP _$?@SHA)
 ]X 
Zf[fX`<`WfV g&?tG_fPfMQL	g&Gj u#_f+cf<0tfD0
$g&0?fhۀ x~ f  @3 $r `n%cX
P  
LP 
P L
,	P Q   
r@Q @

,P `
	 " 
@p 
Q   P0 @v P"S ]f^pe@	e@ͦ00s	`^ d P      8  @g<glh s !d 	a@	 !  	mh@ p@ ء q* Ӟ.:f tduP.f] .@w6  `3$Uu0,&?+aÍ>.}
tp 	
t>apa.:U@ǀsV tMRrZ|p  uͯ$ft}^^z@Q | Ys3С*Vh -| ^t
 uUPcs)t!rRڻ۵u3ێێZ
t	 u
u
 H5ǿuP@s+XP{t qڰ`m4zf
! ` 8 '  ПS%` +ð ;w[0 ~~~~l|8 8| 8|8||  << p/  <fBBf< }x<fff<~?3?00pcccgZ<<Z.>>`~~<pff f { >c8ll8x
~~p Q pp		 0``<>$ff$P?ѥ ;0xx ?0 lllAll  l 0|x@0f 8l8vv ``? 0```0 @  O<<f0D 0D 0  || 0p0  x8`̃ <l 8`;p  Jx@ |pH `a
 
|x  ff|ff ll bhxhb `f> @p x p
pflxlf bf   8ll8` x|xpᴃ$ x0  Px ƌ2z xp``x  xa"x -w0`x|`` p 8l`0
pn v!`lvf0 x`b  `g  !s vf' 0|004-!)*`2
6 	p&0d 00la1B  0 v
o u5f SvN .X2[]`g i &  D
d`̎@að
 r
R3҄u 0eZa Tj?㍲AE eMA9Y.nSS`  ;Aa( 3
`P[Āu N <tDZQY
 Ir8r5r
2:6 v&Z aP f PCI01 ISA`#+T DT03COMPAQꊙ 06/15/06  ? m    F10_  m؎h Ћ0`h+3f  o L!$F10fPfSfQfRfVfWUfUCES>d  fB  fd  td  t} sStp@p @t[-P @d@`t 	f  _ t
Q @@  Afdff	 3ua 6e< tf3
@d>eT   } h> ;f `ff3A3ݩ@!t
    2ѩ 1@b@Pa@f00tf p tQEpYV ^ G`]f_f^fZfYf[fX[fVP3>:g t
y	RC su!&:gfXf^PVW 3W  `_t
r
>d_^X \ɰ۾ݷاбκܭ-.DD(|1 8     60  `_`#8~ "!AS9>9  : @'Ya;  @<@?=@ &s@$	=A	I!!
0T[!A>q

( )))**LLHcF$$
G~B ~}B
y^$$$@ $
  >""ZFYndd  #<r N` hgx"'yPGR<TS!2

	q" g %8 0 p$X	

$$D81 [I  
!e$   A4'((DD@%)P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩ĂHHo׎ߕXIAOԃeL҃phdo@\Lu͍}JT|FcInI`Fڏڍ׌߃Os\gpjځBȉymG񂪓rݏOڕKvxmxtÃ_FsxƂׂ}~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉE십ċNԐUiTivIىe^qlӔC~tEؑ{pKrWoYMߏϏ[x{b - |@  S   0 ` R 	i D  Q @' 'D ?'@$C" 
 P '1!!#"?& p
~|u  0
Fq~% p? o  !  % )  f"	! ( 02 RS   `00m) BFLXp0t   dEg!<"F Ҳ8plpY.$`"08D(#d$A|   UP W F  >"6>0x-@  ?~!BC ""!B'  /!B#b&2 //`   a &2$-aLX'>9p1@@@a!!: ' ( <'Bft,0<<` *0?`  ?<qt2pC Bg ? @ԁ0?0 H$@"@ 
	`0 P $&# DK8 o &  | D~D D<  B f<,$$0$l=   M@ 3` B?"#!!  8@߀ `: 	4H 8	  6 a@)1ppp" `$!3p HBQ0@S` P0ZT@L@\D2"##(RY@>B&Z" Nk=bN\@-A |a  %rm  2c Q " $!2a2SNa  1$Q$$aQyH ! {HHK~` x d $+Ph` @@` 0!ߘcc1 $2&f# ~`\0;@lxx0a1 
c
AZxp0!
g
  p!rE  >>@@`)X0$x|pTT T8PcCQa- : Db05 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{ijv+ dDs?||e0v0 !"s 6`S!cS,t. T8$9`0pGy 4g @ dt>$B<'_ @}""" c px% z`vdnIi&0WP?v3$fv$d
  ]@^@.*  @#2Bb"6T$-`0|p(x3 OV@@`Z F0Vpq@ 0ua4`m|sGXm|%o38"5U QHU' &@'a! 3?! @( !d(!3#\?2b" '?1`		
	`21"`n{9$i?$	$	`  >"33ak' l?HzM8< 0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!## <DEB`@].A^! nxRK)t ?` 0!g t$ U\7 ga  9 "} ?8F `8R)C)E+D:<  = ~P<  b <$  '~  |D!  D| d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!}@ @Fq6pբ66@ƀy9@0ya؈ ¿ `%,#?% p $'!G@x pǌwc 1$&? l@ 2?$?$?b < @$<b =$! <`0b64~
w*  hH"e g * ~  <@ D=a<$" AL`5' 'p-恴pp^c  ) 
8qhRF pà2q2DRD" T@""z"> ""sbn0 CF`  ||~ ނIⰟE`<aBzd, %}IHT! G㡬aE@AjD0p 
 .:23V!&    _B`5I@  `2"R`   @4!  0`'>|Cd p5D ƃ( H H  0
DP6Oe  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c2`."b4'v?e 8+"@P,  b
WBF0L 02?$&""  0p	{ x 	#`4 c$}R S SPpP t!
(#?@@DDD@"D0!sc 7E u0DL|(0<t ` O='4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Rydws7  H 4?b2C"cyH@CQnx<0	`Z ΀7( (`2)v&^?0JbW8l>/&23
b21#n0  !߄$ #L`,!3p$?Aq%$"h| "  1 o A  }    & <"rV&#0 I  81? c QQR?0S"PC 8`A a ˀ4 usn# 8 ٳBY 
 Pw]IY   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>ǒx)jP|D52D"DvDTDD?6 # a|ḅ,w  1p#\  7ajė=  4a8	 ? 6 P>Tڅ  ptL D@~@Bf$,892k&arg@eP< 1 WpxPX	 ^x! 3"&,0@JD% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"gpa&b F ł(x 9%`'6U0` |. `094H~ ַ 	 d~@*H  ~ƟK6cNCc48x F?~!BC  #" e `QP060o!  8!` "***" /"$'$&*"$"? CJ?0``]0?~$BdB  a B
BB~15,"&D$(-jyB ,!.8	,HO
 =I H<H$H$I$=5@ @v 4R$ze bUS R P|7 8y0 ;6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z~  $D$= *XGJA\! /2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H"	TTWD? ?^ pw 0,0  ""bp $ & "  q?2@G
i-_ nF :@e$ a  @
#]](00]V?$P?			?R" N8S8
s
 ek| 0@	! y 	 	 ! o>_""	& ">fCv,`D= D~ = y , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDT Cv
$g>?  '$!$34?, g A#A <8`hO `&#f!b6@2~Z*\*jI0/ Bn5	G x RRptF H0	  N  	  a |l$# '!b[aa^ap 2zasR0A: <  B F>lxPXHL0F`Cu@;0}` 200b64~
**hH$lH UIHUH~HHQHU~{HA6  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs"B`7 `C  `rL(  fMQp" ">a}>>b 2 "&"cb@	"00P G  A` xoz    Vj_@` <1p0?3?S"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(0evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)g$ -PQ@ 2!;VR!q # ~ j   "?**~*B  h b~B$fiBFD?0@ @`@.ADY`M`~  I2R2RR 0Bb.	4d0.t }""p bB o?~b
(LA%LɧgUE``AC}}8@Tl@l$5?b5d >qcQ"tmdax{R4䣄	(	)	) ( )H	p ^c 5] 1 axA#?~"! "2&4?60ba0`"` @"{$D1 X8@ @0 P` !bF! °?(HD>!"? |?" p?#.a ee   	 `p13"fd Bi|"@Acp>@$	,	(	88(?2l"FfÅV@@9`'$pzBp03
D(z
[
@ 
{t~<$4 7 a  p }#@B"4&0PPP`@   p   uUp cu`U  `U	 `0 ..x1S.v1lp t1  [<u.x1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.n1` a2?P 膅SP!bRVߋ^Zu
`R\ts 2ƃǡ G
a!O sENjkpW1
wts2as
 4<
t<
tD<tY<t P 跚 VPP t	| tLw^fat Pw;DXMCÀt	F¹. u 2 󥪪4.>}1uÿ . 2 13 `.n1&1 u2CQ2P Y*2Ȱ&P_ a~ RDr
.~1.1PSR  && Z[X ` Op@:p
oo.61FF!.WtOT_G-p
QR.6t1ʊƳP ZY[X׿  p"2oS2OsP2 sP
XÃ <r<0 <?rp1@1  ?1.&@EDu'F!13!a01.>1P20X2$CFAPQRW ((_ZYX. 2.9 t.1BA	}#+D<u<RaN<P<S<0<<<{<<`< T<@<.>z1 t3ػ@ .x1G.z11O#0.x1.z1pGx`X@Y 0..1.10;Pp2  X:XUFN
ȋNu	F?] S f
 [ SVF
u038ȋ^Vؾ`WFr;Vwr;FvN3^ d  WV>	 M	> tj6hyjF`d&  hEu\>?od% = ?@[#2J	fbfff
NdOdm1f>dj_tt$/Q_		>	dR		A	^
aUUf	D@xE
C
5gJ2Hx
!=
}SF _"R
UQdیB ''F')gdUi#+,+Uy"Uz$hx&G
Xdx2bY[dt;j91606F688L6djQd$ fh  n; tAt=dtfh jnd$/d.yqtfhcL@TA
 >tSXft3 tE>Be tjhBefjhI{蜀
>Ҡ6%j hdWp1t2>f tffhqMg tm+g *$f3f
о~f PFPhehg" ARQhC!3F``HրS=#2he蓴h VePNod V01&	hf@ƀ)BaFyshhH	xA=Vd象KVd`KCBhb7FP9@  jh!		~`#fhgbzQYI|RhMd,4
SMdT
OY0)5%h;01!3!' V=F!!*hm+hDBO	P2D	'2L^_ 2FFDg^ F&<
uI) u&*`&8XgtFFP9 1FOuÀыٹ F FIuF]p*1 F*+҉FV$h+;u;uà%h% ;Fu	;V@á$h[G2@&A99(h% 
Ð)L*	(
w WPS
`Ffj h SC5(-{ f f0$h0s!6 &b&djLfmP0~@[j`Paj FPI`F*"aPޡV=ut_ V!  )#vGF| V0u26|[b h o&Ч F GP	FNuWFG0?7 

^yOj,HƿF FaAS)  4"d=0u
&d&deyF´2 i1p a{>b
0WE2
2&d% +1d1d 
d?@#⼎Ao"jFmu&d6_d BFU92
!.r433ȉ` QR	dR`2	2&b% b1bj_RQũv3p%2p%[  jAi* 	aI
Fbnh~32d%djDZ
MC% 
@	
EH 	N

g3
1$ jijYM	d%WjS
+ +hM`h$eRP0qU//@/dj~a*&d^	BHꑲx탄t5 h@epP_Ft@#Vt#!y"s&@z+&dDWdT!>@&>d`Gw`&@!<  OA=
`& &O g M߀0<O7XOqW Xapm
b ? f@ qdd kt}J2P#2a;0m=o=b]!!@ ^PpкF$h^F  ^F&F~
r$Af?&f &}X` &e^@rhB@ gn@ d ej@ Ҁ f# r
.QQ"{@V`E  p  V6`^aF@t 'te Y(FuM&ff Xf )8ʀot !@t ߃ 
+%@@\1if	ea qt*E)!O
euUԑ+~ 20`& e  !hd!r΀&dd۝ootD @)".cFȑ{00`  &dw~.j `j  3
vB +#rS|F3BP
-`B&g'&g &g|5&ۣ +&C!&.&Ƈgd rplfhJ YYM2>dA"]0>Tf&UfFVD}AVdafe	s$2 aD ";$MrvIz`SQup1Tf c^UfFC?R@t#JCj$	p=RggۭTf$ < u @<@/""r!ø`" ,1 `bv)p94&14g(4L(va2]f3k L Up
t%r ҋF^Nr'~#tp  u^    % F Ґ)a^  ~u +ÿFVVF6Ƃ6~ r~t` t uFPލ~fv
F0V32,pIupuS׸I]]?[t

1 ^^t۸M~ f#$ F@B F~P|v^߷ KF NFFV~ ׄ3NHt@HtcH P )A-bh0V6^F&? u/,dv:A8A0ce&mhhdΐ2Bbc ;3dvi1dm`
NNFǸQ690fFF81hFFoPR1h_S^R/GFPvF1?hFmP?dbP摌?FPNQ|Bq*0V.@%`&0i<Ht	HtHt7 h@ .  &>b }n ~|  p,wb+P ~
-dF" @	` r hEQ  @QQqb6 hَ (Fqb-
4&-p.8F.}F4+ffP!KFMOb%p^F
)C!`@KL6!;FF9 9~2|FtFC~PW^
0O~ O	H#MO _ H R}VBFQC940@~ t;F4F4K
z uWV~v?N^YPYS
J@
^_C
"j(c
l`


[t ,md(|WVvԋNsODԠEHv\`\~(|W~adt_~@u"`ݐ#}HaB^F&WS} 
 
.0\o!yu@## PfPqDia2Ҷ
%%		 	_F*Pg	}`	A
g<d-UWVv<`~P F
&GFq&'d*V~ʋv!^P޿FGIub ^&^&8t #^^}R!#ù
 0GF N% }p,-Ar  ~s԰ N?FN+O;u0g03ɋF@ AFC&P0LfF ~ЁЋsG^AlF  ~
韋vЂҡLD
CVV,GV~^&FIa&|$a)6F"Q2d% 1p Q>?T@#b= 9ڜdo~*

_Z#3b%+1 1bj`RQ:#	2&b% 2_d% {1 1djA 	aھ"(K,32d%djD	2&d% E
	C
_	@H?

N
	S 
	 UU@g3ps1 jiQryYrPyfQ@zF	(x&$?

&dWdRfa1f   ef	 f  h Vdm؃`2`&2 D ;dMdFrFC6J3^0 V>HFRJZZ)SS
B3z3~Qk}  gb`q>j6hT`JjFd M<>$z?@#d,(K 19~0Eo18L

!}j`fbf	ff_؃'Zr_fdPXx5
A@MѧA \
a$;QDUxrE$
C4
?
A=JH_?m"NL2
UadVB ڊ!$SpF "4%gi%izJ'BYdɳ//-FM  ?jh!cprGWVvQ͋ދ~ &F<t<
b#rF*;?b}7!y~tF&8tFu|t<r[2V0^u	A(|Ð ~Pfh#   0F;rF f?* F p F*N*ȁ vFߊP0Gv
u+Dg^F Щ FOupG	bfTg &Tgvdtbgq0  2 &%h22`% u"$h$<P2$h%$h1&hȾu8&q= +ɉN3$h33 е  au(h$<u~(h% bФu&)
u]f2 % D	u 
uB
 ;)
u/AKu#aq(*h%FO2 eDgEgFg GgHg	IgJgKg
LgMgNgOgPgQgRgXaҸM2 f^3: f |90`ujvRP g- 0`FB¿~2|ȸ1~`ƿF  p ~ uFem
 f jtWуV 0`FRvpF@ b*J*p
NvQϋWV򐹃FFP
|Fo؊f-oh R
~%F܊f KhF֊ft@ t؉FjRvv!h 0-~St` suٶP0M2muhMhD IPh߀ FފfP~QFf KjuB:CF0F1F2F3F4F5F6F7 8F9FAFBFDFEFFw~Ʊƹ{P_؊P11T0fb;< 󍗆 'O&6@AaPj,*`
- e)@PP NmV[[G|]] ]<]劆2d$0   ơQw$6j)ѭg`߀
Cf׍eQlA$hЎwf`pՏU*+- t*-} t94 !13q$RFaR }OCIOboL&F 0#M"7g
1a1  G/E"t/ 3|
/@+oF+PRQw5pUd qa"$ 1@v$hˌب kbP(LFPAB	sj)"#M2#L"#9AD/]LDE WV3 W$䐺^&@RFG߃|p3X6 2 R& FWɏq`Ó rҍj7<"JW>d bӆebb6  &_=  t@M[_ F?t Py h
"Dg#-//

	
a@yu	N M0Ĵ &&TV@oS~ t'jpFI  t/ u#'jfy_qpt= tA:?@>u
f&Xf"f2Xf% P-Xf  t&f1`ul À&l igdhg fhVfffkf0hepb@bAbƯdͪ*Weuo[h hJ9| Zs^p:r@jwИhz ۢrBւ 		
zQ  F]PP M   A0MAZ $< wrעe bA5Ӏ>et#b߀&da
ud&d	ɀ>be u|K`?  (Pa?  q{rՔcad~
h#!$Rq=
u 4Ƿc 
kԿ4U$V TTIV TܢTqBb*`F&߀? tl(u(&|Ru!p )u&DPƯV@ p*A.tu'mu )uP&DDPDOPpqFBϔfj!
   `  	   !  -Eq3~  A4 u &d`E Z>`tfHj j T3= H/ td-
t]-! - ; - p  r= M - -  {-P Q   8Vۋ  &9w&EU 6`  VV΀ @%6Dˠ   9~ H Ő ;p! 
fܱ
>~ Kހv&@_u?Pe`^b; @1vĴ 3Vfjth  <Т{p 2`0{ "g ÈvV>B   vV*F^ [P% 
Ppÿ h
 h  RaNF
+F@0F!vvo ´	F2`NwF@ zj av0CFPNQ=`*PqK`VW  p 3_^{e >㚠2`%  @SᜊF~`
F2`A6F.
%
;F|!% F@P!]!Vgv`/NP@FDt&E@A0#F쁄Tg~u< t (F?7 PF@5
 {f8 & * Bఢ|b~v*VA Mp2Ɗ* ufU  Vn'] ᲃ> t`ur3NF` |`N`^&8tG[ vNߋً! ؉^GF
&Ft^ G +tp
뎐V^% = @ʃ@A3t`߰ߋߊ@!A~;wȀ>
 u~31&A *;t{r1A 
*_F0D0?F
tҭ t" `fop
V=uO`2P.B@>Ҁ?Vu	.USEHDaS!E'(EzrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 uۋ31~^
AwF9G
uN3~(~ ޞ0u j  F;|ᔀ;pUC \fUVNVv<%tF` u DD^ù
0N u0+1WWVX ]V^tQrJ;v~ F^F&_uF$=WR\qQb]R?}  P+΋э8sdvva!V0N&8 u{N= tp&@*®0AtdA߱ Gf6 !
`f+IQ@kqtCTNi
ʐ kj ##еw^,`j&F3v~Bv0ܪQ&ğ 0.b;~A?Nuǋv 0d_FAǐ޵
 VfP0VF cPQP F ~ ~
~h3ҋ P{W t40hPǰv~ePq 	ptGWy5ؽ"p j9Fu
0_sPK v؁#5@jFoVЙ䰎0NvD"F9F}+F- P:@!b' ɒIq YFF=`+%pU"knT\QPEPsPPPAjP:! fh  赁39> ~jy/00*9_>u	A
@0
A/\&7q6%'@2)
o
G;|2*& P c`8(Fz0
A
j Q蜗j V{NVRPy=AQda'P?$ <nCtbc E +F+FVa#
0UcShpbig 0aDPodQ虡hyQ	5Q`,+F+Ѡ`M*g2V Rg@D=D=ӁF3@**A;?}Rvs`'V6r1qyg*@F;vwP4C
sR14+

uK#aQCPYedD$A84	PeVs輡V!!rC&-24hQRptYAS;}`=y#DȰdf&D&T030`~
P  q &Fި@u[] СFtdF;ƺ@Ɛ]q<vN b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~{ $	;F3F	_F	} t~0V=g~P龐tOC tG\'F
t/* F T9F}\LF ;F~AZM
?~~2G+F50%&L
q DFF 0W  Ϡf@`	PXf@PwF^^UEAgTe l2s|Pѹxb<FA@ o0H&v7QvFvFꎐՍ\Pɒ #R@~ɫU 3'tsF+FJFH鿈fh iR( tT,T4v/ .9~4aFek6,+F!}=pu.tPoq &OC@ +σQ._+ǀ
!0|ctj[|񈺈

FDB.=Q /j]>0on_W0L# '0rRCA& !!pa^2#$QBC}PPCfjgpL@>jglgj qWw 
Ht8-t-9t- 	t "fo 	`!QF~ tfFfjgF  F
Pj   v
u}i1Aj >]PHPV`s
Ϲ&wIc¯FtB$P
QиN	VV2ٓ~F
t!@D% QD
莡Q
VQ6 B tDuЁǠ
!_ط!bG C] pD]Pk*. H!MbB`t{u	 rdPQGg	R4O1maiDu(+Huu @uqt j	jfh	m	"	PGV^FPqf~
w t

>a:}xQ[EPzUt@ ]FY m DVVj_vv{xzX 6G ]3?ĲS002Rr~uwF0BP1TqE~
G jR[807+$~ }p  9]t ##/E=/1/FFP9B \ dpg
p; ;NNNQP @C7 Ƒ򠽋= K = ;  -Pp---xАWp'Fj  ܩk >g`{ Pi;v1!;vFPVOW>FP~FPG;/~~P1% - D- ߄*-ࠁ#- " e= Pk_'-
|5. G@6- ;sFc?atU^ tP` l`0a~9Fu
VVIVF]v9vu@PN,PN  PNNRF ~9~};V 9vu< uN0빋v T` 3MP Pp & ^!VN;~
u逐xA^F;~maXS `
$~Du6g b;|qT/QN;v}O;Ǎ6Vf~ uFApL怰9v|GI0Đ0%9F_| ~A^&+^& '_F'302F`g!ihj@vVt ;tt D@gx3|f4Whyl
 rz/~I>jFWV  Gc Tf td@ @ l ڡtUf
U|tATD\[u0Y;F~ ZprջN@uOup0
DUK=Np>e u)>f tl>h tt >Vd t|{d`Whb?0 Whp.u"jhbh4` i
j(hghF`fhp` Z `hMdh`; `zD `}=2 `m#[4`a%F gB"	p f%`asz% Mdc%	 ;dS%
^ DdC% O2d3#+(O`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhНpt1r't߀DODpU*뇲>AvuA*H>WvAPVt0<@p{& }55446$5245r659hn@E@ jpPVCpWVh
	 !V3wj #	~^DԀ`HtHt#h !    C wt^ f	{$F2 HtHtHgHt$" @ $Ѻ&&G<P jh	G+P舐X}
G>7x@n _^a׉GP0v&ƀ ~RrjV6 fP)3P Ы>~X F`~|ְ"®s}vI@x	&8 trƾ
9GPu   >p~q9	uarf   ^f~ t  |֊Fþ!	eM譭	<L0#	Kac 	=3$C0(`(?hOpa^p3&~/tC&  v&8 u*C;^|ckFp^P9Pg`^? tvN~}"v`<1
޿~ u0gDFG&9 u7~WRrm0~F Z= ?-
 -ׄ Ү<5 1 ;uJ< tCBtZPU-
tKŐtHtL- t<17@t0- tOAJ_j*Q`
0 R~D@F	 0 % t"} uNj pG貁F  Bܲ u
gށMN3~*^
7ފ 8&8u	F;|,Bdn
eP $
Pڋq PPC 
Cc!
d$~  *8fudh"^u Q/	tP3`0F |n FPf@
t)f3fn @Hpf}h 륐j hah` 4$u }@3?l3 1/`F*A;HtϠ5= t	d@ &d> .dQu鉀&
:v	@
ʠ
 &
&
h2hN
h [?AA7B 
@
@ -*߀

@5q&
 3F! "&d&d :gsi:g!B"  `FP~H AKN
3a$\'Z"%aC:GBHFo`^ MZa0$ƍ&Íu,3F
46 x$dh ej(j 9
P8
PPfsVS
bW&*`)@&` ad t&<
 <)뀖 |x
Q %'@q<`
! Ohej  %VcbN0Pff3	諠`%  Pπ`RB/
?
$/*0/z$40/04SRTRM"`RVdbtDp%W
@

aH*=	- I- 9t7-k
 wqrMt%
- Ktq-Mtr`| MYnp= d.0Lbp,,2@0`  8&`s0'Rz!"Ր,20`  0PXu}/1V h_h STN  9YۂYu݂Yހ
Y&"0Zd a=	_[Q["
@4 |
U!@ `d`da0y y Vfh0/h y Pd@t&
 
@ ACCC**!#!
@d`d`
ސ޾
r(! + (#+-+tp*tcmKt
-o tu] p&3& tGђv 1vhHh
h P!wu
j8%A&A܏
-C@#'&$'Ha'a{Ðjg؁ ڰ @&
)3bPf 
0>{+>>G~>d'>n!>/>f'>< Ћ5P$pD D:E4Q89JR4"" :L%9
5Bδlhh V2^Du+! 5 31;utb&`\S7A"6@A@tR_!P!_!
@>8aO? 6`L.ࡠAL&`8a~~<!Q"Q Q֐*|3ɻm &ArhOE@Qhp@	X^rQUUtD33,i
m; YK?8amrFv!
orE`xc$Pv0%/@txADP!D$!D`
P#wBf~h$x0%YAǁ6K=lD=H=yM8a;}Ա;
fhZ/ " [BGb %^
t
]
dt,W*@t>tq *``(@a@1)@4AE:aŏ>ƏxCQ/ 7# ғ╋$ U$ j4T%0@0QID
p@
%@U(TR~2U;6
42`:aҟCB	;avuv<UPT	b
A
 05K8$   ڡ	 ĦҦ
&<D H1p  AЗc!@] 0;a0u;a}b"뱤Wab 눋:a 2 1 ;5r1p "(9@( f fdEWfh  _!zfdf:a&dN&..@SR56P6e!7U>d>8FF% 9N$NR 9@#fdfAdn@	>d0uuvu,	u#DutuuV1  ,ǈ]|rh;r#veʋF8FPVh@w Nv
WVEr 
@a^HtHtt-L>B3+ aA!!@3>
g={Vժ
줔aPe %DQ9*@E' *`edG:*bgC*
@
4i`ݠ,!f+_fF@ ؀ } FPFFPFF0D01d18D>==   - -tR   -޵ -*t:- ֿ ߐ= +-!C  -qvt}x$Ht/Ht:HC 16 ۢ (`  ! "!13} RY"  A
Fy
t)j 㰁UPTPfsV"Ptt ;c0}bq&oY!Fp *HFM~(f@ fFb^vfvvFPvА5Fu63׍F *ˀ~%v슅b :uFG;F : ~ t
&`x|@xzP ~@&pU!  p!qq t׃&AÃ@@͌?"H_t)3Ã?@ ဣ ~b|ʧ&X qV_>@a uuH_j 
&3{v0 RPXf>afBf@Daf Wa d Ą 9FhDB R
>aXf3 B8-9t- 	t/ #`
{  *XfjjG a
5	1	u.#JNu~h @Ɛ>a tux}fh  P	ֲ-NRr >d `6
Mh2bɀh˴B6W3ab& d  F |b rơAScA >p#u>p\t&el6@a[ +륃h0`te3b13
>D*u	> 0!jjm22t;-3Be'kJ t'{~80:2GR%4;44Z
`b0h jp?0@?(!Fa@[$
6
u$4f*tS?=<ʓ=5
5
C]`Kh@a	@Ba	0 fh+rD-qRpdp$ې#;$ %D/0bBebbdbXfnpPr ) d%  = $ɿP
fg1 [Q2 SRb
b
nc
֒
 }*g
h
r 
b
 GwgעA]$ Dt,-
t%-.t,-	 tE-
tYt~Q- t/C Dʣ@a:B~A/ _p}}  soU&VYftfu& ra@Yft+u
0t ]XfU@UU  -0Ⱦ@ut;>}` 퉠 Pr}%h貲rjtXя6 ]HtHt `t' Q huͨ
^_ WV3ɀ> N3BrZЈQ @FPWp~茮r{ܐ
NpDt  & ھQ FV^tF&ud,,,,,,),p+,,.>uh hmh; h , j v~
0c/"@t) 3҉655Q@;@)}F~
r݋F 
h|	
J蛾
Z 5#W<B6f
 ~ľfTg v3ɉNv~FV
tut9v~O|܉~*Pӈfb^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$7uG

}41t%I67%|bpf"bfff&XI  
"bt&
Sצ
 PRt	1t0p` ^3

tF^&F!u	 |03$N[F#@
EPfnGW^rqF*V+= 0=a -tX-  - 9B m= M - t!Eh-@  Or= E.dκ/ /  p- 2&#b% +11$b "b"b@ 3 ֐j5B jh
@uηE
 C
:DCN/ /  (YP)@ wj}Q'3
^'G`hߐ$h5؎GS.bAcb$h, "bob$ a
0ް&
c
Q 
@DMԯ
FW@f
fhR0V" !B
p,pfh*+`()&' $%h#w\b\rd t0
Pd wfu
R0  O hEI `F<tF "hι;sx by_F ۄ-FC|ߊFà&bGwVAͰ
?&b(ba!JE/PFQdq`lDL'H }f`OeO KcOSRӤB
)HT4PDĊ⪡70SBTaD

H
<UYD
UF \X(T
~_J_	QҔu
r
(q
(bUA `tR
R_(bfbhrr%jQR
 &5l01)b*U5nf6EpCpEA
 !\0,B`7C`LB`B`+-
- `
- Kt 0`a_}____\
*:Jª4,2"5^&^(bM  ab AB  z!" 8- 2&'ddzt] dw@TĀD>b )# := u@-  30A+q5snY3 빺@  r m&jq /3@u1DtmDtLrozCaeGL E@9OA#"ңSdK"sfdf&P dvapbp@Wt xx Πg&ACAJDPUt &hH`ώ&? t
&ؐ
@@S#U 

C	@U


A  @d:x@t&fh!~觴Va"]@Gyn~fhhF
5Q442<tfh:89h7F2
/q0ճv?B=>h<ڀ
@UȢ`	DBChA谢h޿2sWVTf$ < u@0a@<@uo"d s@utH	;>`  *r$ hh$p1@66.b Jru%çb Dt,-
t%-.t,-	 tE-
tY- Ht!- t/_C D0.b:  ~w
3 	}<  Aк:%@'$F Pc= Ht
@q j  r jݜ@6|@uf4;/F~  rջ|N@uOphDh.TavWV 6W
nrvƐQ߄et
Q o&FF߄et &?dm"8$PAJcM&P!G@T%V% _%T%&rhh T$ 'Fc"0b.`& *0bPeA u$2,<7 ht?h:<9  t~@ rb` zj~=  TPJ
 jP,0bzp0u.&b}Pjj`&rz"pq|Fh@0#000000000!&bkVfvfhI
 2u mh bF@c:tF&<:u-FF
*0N&$x  
u3NQ@C7 ~ uF	 F
  
 
 <  C
v`
>A
jq<L^P{B
RP"
? c0
~ ~ tghv&~ tD1O=ܩ=u5> ƄЯ
`
 ^3 FoPPP FF9Fr @% -
 ؋0v v sd ƨu = wѯZː˲˾ˋ~FP.a<cy ~ t 4Fa    R {F  : .E "  
QpÃ~dzt' j̂OFZIZ#3w^ \L E1hV.t}Cq u^ GCauK  K .g"=Q
WI Nr@~u_t W    I t@F{qqFV!F^@=?uFv2N'22g+@]WV?6aسKhhy*y fyܷcy}oyDt4H-H4HSHvgHQy72yFIP9AzC"ClIDzߡz(a
4zj &z<f+fF@ ^  ^6V^KFP6b<Mv3+Q OY  l`- t$ fFf~ sA},Guhp萷ܠdfQVȡbڙRPSQfXfYf3fffPfvGMF fh  bUݶ1g Fvh "C_QPod Pq*T!T]qʑyyyE  p 4  V6rNq		% 6lbD6@g\ 6<gˉ|<`yY
]~0Ð3Ð2 AMD  PowerNow!  Technology  MHz   KBp (  +   SIMPLO  MOTOROLA  HP  17.07A  K    Restore default system configuration mplet?ed!  a) Press <Enter> to Shutdowwn S...a <  drivelock \VB C 	u Setup  <F1=Help?> FilesInformR  Displayz5iSave?floppy[ diskette from+(s.Ign2hanges and exit EP  s! withouaving
o Securit@AdministP!or passworEC"e a8/".-OnWGpP&Devi#cedeDgDbD$L $s mart Card%G
supportEmbedde&f
taA!e'e
tr*acp",p(s$:authentic;e
credal /Auto2cH%Tools Ba| /0Calib(p @(`'lec`B{ b HDD:lf-Tp- opDs Activ O Me]m
Chep? r s: ll31mb 	>>uA@AdvancueqL`4uagaC lDt7  of grayq6fieldO Boow1b..Uany keyUpY ue F10=
, ESC=Cl  9RAcc{ep/=YesSNo D, Ajo$r=MpI W  Us|Sarrow
 o highl@ *he appropriQmeOnu iAfqKpcNTER> cbegiggK%#.follow@M%%k&:@tj->  KSPACE = NexBR3c-BAC9Klvio"FnTABE3iSHIFT+&*TsF2@&10 `
v[J #'9 Er Th{is60cann)b`mU;d An e ocP^@ #whs6c.de 0x01 e jndA@pGPu@p0{6Crequi yayE`d~jba@%mu0C
movP:0 e4k/MEU)hQ1& ilAl//+2SD`a06ssfulManuZqr  Nt0
d:Prottyp@spyeItepp+CacVize (L1/L2)S~Q ROM dd famias=eP8l nupi 	Videovi}s"KeyboorFr06verADb1<ed2e3bg4`1qa<NPhip(TAdG
W
O3O 	*	Ĩtafdai5u%BS)NK)$ 1
2
3	ME$
C

V


4T!V
o
Do
So! ྶ: D%FPA2d!J#biFaܐWalRX0sԔ&1&H} A{ddline4 AlXҁn.%F$Warn: rk T&pll0o  zstfTrea /VՀ, lef ea waba02 A: 
de\` waqt tҰ_)Vu @rnInAv ȍP
)!	Ayou̔ wa@|to  @qZ?m  io	  0o b+-~c(Quick`n22 (Cvre@sʅ3 (S.M.A.R.T.) EP1pexim@s ): 30¾# bg3>0%v} } ty ho#0#uprХ:1't4	f-Ugnknkp{ilWR!mServReaPS)doџ47`?\a}ribp	:`exP9 'b`G H  Olp New Vfy nY7Enc8OOff O  ɂA LA66#%AKr	oE   0p dV
Ad1 U@ҭ5Ocpcaus7APp@=AH"h` A&فOpow'er-.AS QVQa?Uׁ= loss T(dYAhou  nlcof 
aQgoH04)ev`ۢ?[YDocHishaR`ed?!0f]Dddi΁al JJe HP`"UTool` Cr.% oF8IL`ˣ 
Bk g UмAn qpm`
@jtWSN !Jarv0s /UcwФcQɡP2"Onj* e:Z%%% F@%԰#Dn -f  TndĠfӰunuR?*$n)tartBQK`fr9a Par1ԥyNsza $mediaa D- rw"`@zU 	1> 	 abouasu{20hQԒ uX" bbUSERMAST yqyVpanP:FPacSTkeep ia#Je7physpE =Aph!E 7{mp0ar. I7@?>Ä
,ĬPn!Q@SWun +AgGOOAutoOcEd00uHZ[6h60 ?#ONk<
 O[k{Ѻ`aD"`0ur@t\b2th Q1psow Vk e"d0χPerKFb oQaff+bdata,]ssibƀmma!L0ligid!V IsԱXl`rmm N q} QUpu zl,`mrepla0\ sp  ~p/*`By4z@Xr@P4, oHA=Wy@}'آr5|@me`1r,@@M`*pPpuibpty. I
fdoBǄw8`ESCqt. !
 V rtyp'>'o F10"q brm ,b(yt+  E$  M0iBjQ  Or0s:U ay OX`2DC$gDLb? (left t/hUSB t HQbSu K ZipoFir`ܠoPmF th`ifp Sixa Rh ENPh ASwap Fn/Cwtrls KU.S КP!slegackРQ>is`7)n0=rL@ry V0o  d NTSC`AL -J -M눱¡t@
BidpR EPP ECPd2size 32 MB 64a 128>  AUTO R  ўo@ Qlw+aypnRi2AC ViWWAN D"RadiLlBluKeth /rS=ch1A AVgq !t R!t EF (,. /2+d-)#/Е(}@/4En:)&e 12]3TokRHp
kP	M3Unique Id"af)e [  @,tu   ? S3NCalib!
6NsavP DN A.b\b0BA] HP`{O
ELpm MEUk' g'MRqsN/G/U[|:1 : Cg .  % i]/Cle2 |c1d@ik-d3	 0s
H

,
* A 5>hM(o!ylSp hnologyG4YadapRPXE RPL Ex㨢Popupz(0 10  2@ 3 4 5 6@7QF12z5' 15`@ 3 "MBouch+pa PS`@Non<F1=?Hilfe>\
iYinQ[ O>nzeig fR0peicnt  KguaobVwieвx @nLveinuQn	-s
kz
r.Aign ed*nt Pneh 7/%Set#SRheitsfunk(Zࠋntoa u
@nBlt-KuO] Gertes/-$-ID FOt7	}U!sttz !@ pQz#  beim F/st
ng!KÀr5nHsvorrq##7..z_urckz9p
B .p,!f_g{ms`>ThgEx)>`Akkuk"eK tBsgewhlDD-Selbsqs@´ItivS9p#LtIpr 3'g 0: tppllTL
PZ `OS
@ PErw :%SpraQ 1a;n!4:#U"gran Feldsrt-O&O9!8`6")e SiePMbqTa@0, um p_3fahB@i=A, ESC=Abb!#`WBkze!TJasN0\ , J<a	=Meh`m VeZ
zpMark"sxy!*!'MenS% dPfeilt!
^dQOgabe2RmO q>ko?9 c`s.	folt
Bn 
sg:@)-> 0r LeGQ = Nch A\pd<-RBchrigtt-`VowA(GTabul!fs+ Holl+gaedOx F2@
038= {gy EschlrLi@PK kan~Lt we YeiffMgЀy16P=`?rge[trЮn.Dc 01 L`fit B 	kqcQFY+<W\selommvPorB]er0ilXWqDe+skU-KsBhmu f 3asÃbzw.2MGobiޯbgtz%.`Qz qh4Bi///"2f!
}[KAlgrѫ ab	chlos@`F-M`ll Proz yprtt`wig!60a"Ca`-i-Gre (L1/L2kkapazi[tOMdPm"Famik 9Sp; ummU Grafik-R0sa@Q Bz]>r-Con "
 A  °a?7J	b31O 2O 
3O 4dqV si H>(F `	o 	o
o1
L
2aSekrET*D L$ƍD%'$b-!3Kc(1  WalkZero-T<OKne EdA`@PnO`+: bX7 stqbislwn\Kp  ZE8ucQN-/WBL _leQb s4 Atei#CP0&ILp`ak A:nfC6
lLW$ge`KR/+Pgl`p%ɏ5 L  	/  M0$wirkQh"vQM?`3, da?OFq^iew1POBQod01 (`n@H12 (UmfafdʀIGcr$Pfh2xdau(Min.): 30ZQd @0%#gAto59wyuP@wm Houyp%ub1r ⾒w: xH	Unbe!!MH5D2'rvo-L`4.
2 lShafAttrib
uEIDATuLS.M.?A.R.T.pRXXMs K kw0euys~K Deap ` Ja@A҅Q eD/t FalRgebAe
U	 GU5ƪH0dminIoxy٧ Dur?@ '@ | CO mgQi ePFҔNs'd,D. "< }tPtifizԢeq 3{xrt. s ZuaDFL:O 90benl ~.ib# sEQn`p'PlbsviceTas @,`$@  ahp 0ga|F	 :	 
Zptfa n0WUmC Fun)7, meF\Wn HPq{tect_ToolsP=c@^ty Manag<@genoPD--cQ}- ki QuickLockSubndr#q\M`"a%$biі3bnchutz  fڀ_-?1daԨ@im$& "+a A)N+  *W"пB>Г#, l0ҳmeh1 #I Nk>Ɂof ot]-Par0e.@ґ:-1a$:
mpCD-Pԏ@EڅM# Q:n@38m"rive4(rF0vpl P;b=ALs E-C?\s mpW@unbralbar.DVSIT
gd,r'bew?Es`V!2,0f0|" "! E'1.J, ҃0\',  Ij=n6zBOs @Begriff@}d"kautomMRu @Q7V7;oShl;> A qi Ii {qt?^!Xʗf
 V'կ!!1 !!mU"n O`P o"ep%)p Y!f{#Oz`u58ae<!s2z:n	S.)sa`uN(ٰA^Es  oh a c%C R0 `˃r+pIqИ  iurn3whE q. Esdr<atempf/	 d?1zuqOdz. A @ @@R7 .p`r&ѽ`2 S` Q7 b-B2 n rat0 tAdant `Whٷj<@Esc-a& Llɠ>m *kW!'p'p`\< F10 eHsh:
xfPg gCcf sqD} m`A MuBay&m AΓ)bBtg0k -ET`(links)=tUSB-b#-2؆Su 1Zip U1 2@34U5 6@789 QFn/Strg!PtbedEaCГ (USAf-ZePB`iebss¦unab/hng`  ԑInGrafik-Contr aPrimSek% Video-qϧrntBidireal GrÔPus }g  Lf`i0pDPtzb
}r WWAN-G"fPLBluet/ooth9Uaʩn/a E gpaAggrp eX'*0(o)u`80Et 1Ց2P37ToTRPd C?!"t vy`3	IPqkBoH AkkuQ  
Rta   x a  KalCibⲏ  MabAkfbO  Nt&i@ualQb   O  m   O DO, 6uO\Tra-?6 . .O ď.L4obisp9@OO5"R 	EgnaOOf`.[1r0 1 :a.  % ]aMbloQ(2/Entl h o3 ȑ
m!* 2
 G S-2'su  }`Radap!ϐaAB2Pmªz}ExpA-!-Popup (.) Wedau`Qְd2+ (Z p Ke`~Compropstn <F1=Hjlp> Atoplys!иVisp#ne Gtil@c <!!konfb[Gend0fraMz@QrU
J@gnorndr o&fslau r  u*At@gBOtFnek)hed Administoradsko KL aodA7 fo%WhEdjeG-iq		 *	*
J	S}m-kort	God0dels&f 7@do@|_adbyggPGOds -&28	 Nu@060faks Ml2 UaBBg
s)9"FHk@\HF Ba.@ġV P cb"dvalgte b&HDD-selv4\tPr HukoQA1L.inPprQ2h OGH omv	Ir/ Avancq Sprog Vl1?s @mo2nedtt felOC4+'/#5l5!Tryk pP7 tas<G0=tZO^=A, ESC=OAnnuaFsp!3=JaNej "J, A!R=MGb Brug pr
NA`RP70we~  releP %menup(,1Wt<ENTE'R> /ec>A)et. saf pPr'f!f~7: -> e!& MELLEMRUM = Nl<-TILOBAGEr!JTAB&2$KIFT++ԻF2@	:*~= Acce1h0!hk>{sf#ej 8A3ku1id0gs 2dodQ)!FF1n. Fg01BRnoVD-p% qpla`9G!krvNvek`EnJJ
i db!?zs flyMsÈn/McEUqoO5 bp* uvetzbrud 2JI,nemfB J@`  Prc c~@or-typ hBigH  ztr`7Crcache (L1/L2HVROM-d@ famOiliei;\AWdeo#f0pds:@Xr-cs]D-ba`si`9e2o`%3o&4Z&at-ta`ofej1E("Wat)	O3OWEw ex{%Ipsr4E$ TyPy%xy l=ydes!Bmis 0'bvD1I'j`Qeje var0: DB1! se  alt@P02[hold a@ poPdqt`/b Bb-ɊBdqduw5,&pr Pk
kEuGrBA:ރTETf DF%Ugyldig/
t-  <@ngivuİ,vAi av٦,?# i#K?@ $1 (Hur P)%Omf`) sl(`{ (): 30˄2j  `1x0% f3rpudZ44b2@DR 	8cq: KuB+"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5ܐpyCD@F8Ny  Be@}ft nDeae Fra@l !e@+ń 4PR@{	s0FC		ƈ 4D
&KE  beviвB7 9!Cfd~es, f.. <ramG261A PoR.`RVuAj@me+tabWata. Du bup$AM flAX:Ը viGcehCa D[@G @ߒ[&?0r !,ci HP tectToolo9"jK Quickp;au`LsQmP SkrAp!0rKvt%#k|qX)/sa1-$$ HvisatՀ `w@x6r,
di u.bilK2;p+1ol p@~frard |)x Qlash-@$PR@Cd-rom- V@:B Ho4C%:"eAauϱ6H!hv1,< D!.  
bPBRUGER-t@OVEDADGANGSKODEN,R3q0MU albug:s  n bf  ne]d op`JaPX)edS t#
{	ND Cll 2 E_C0aQ>Phjlp@futomok- d-
\Bbyg AXl_6b_/k permaf`anQigw13n<l  fys dsk6  4@rbqpc(On @O"l	v A .dCn0b
  `u!dW"eLm/, soma ckx@
tvt. U8~u p{(`ppd/cĠ ikoU`` .Q  |0сbefalkrafȓp y 'AQ젾@"pl . paYu)v
؈!  &cO. q#o"J"4,Q/p0d iDHuAP̷ 0.؁.lR`5:@ENtra!5ESC. řE# orpy 'F':ge@F10 FYMsf
i/hPD+s  ADk Osrf'lgm vdRRenaHPskm yDSp-bas MultiBay (K0 /$hjUSB-?floppyEC|cc{R}wbsqu SbAzipFr`aVTr7edj@Fj ްe SjSyvRV O Ni \@Ƀ Skimm Fn/CtrQl ElPv(a`isk)<!apegeUst픙!
uPnPaq0#ߑrm-c%r Prim Seꀶd V`o Out ParaX#  TjଏStrCL`ohuko B< t 6nr compu Q0PPǀtrm
gat _WLAN-!sioBluet hK/A (trdl;lo|net rP1UAmstya׃&(x(top1*qb*Ethqf't 1K2-3KToJRaY HL	e+	 	Ent 5gt? id-nuRai@  	S`   Z 7ѿb/ JKalibB' 7ndaigO  x 9p6 @W NMH @KO OM2[bo   O  O#0 OOOO$HAgs 1  1O O
1yVSi mo`gPa(MEU)J=K=O OGOqOO  OOO[ TPq 1 : O . `% ].gAmt2 AfFH5L)O=3@	Genos	
`k

, *  J/X4 %G)g` hB`At `r`bpopupsink(sek.!H$025f-1@bgpP`pA Konfigu!2mas   <F1=Hjelp> ilDwin0jonRs sypLa@3$k")Hefra6#:p`di!opQ	:k@'Pg avslu!QA ,lBDE;sprograpt STt Zpa+ss@ a/$OpFA0`|U'yrsei!>vsfunkqur!tif@Ԁ%@%-
vn Sm4 #>godkj0R!neby3Pi%it"ot5sTilbake@l#3fabP@P@BQ`g
i
 C7;avL`Sr_kty & ڏvalg !AlPP 65vt Ak& MbT!# [SS;G@$*
@`H!4v prlgy 6  Dem7`5bM @ZdtJIel[3
.5E6o%<}5Tr7ykkC taJqL?a &`gY10=, ESC=Avbrya bRʯAPpJaCNei rP, i\Rer=Mbb `kYneRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMROM = NQ&86  <-TILBAKEPvrig*TAB&"HIFT++F2@	)}= Go  f#l`bWsfeF`  SPk0`pZmnop? \Л@C@0|m?kj7resve@pm v ; i pp 9oba\R@flyps2 3]cv}ja 1|Фrvfullçy. kode 02	oProdu^t No0ablokk-mllztyp h igv&-PgayvDbuffM(L1/L2`Meng`	P	qeniupV wo-bTЍjrtroAUSW,kCobf2i,ѡoK1pi I23r4d,0( E 
@q8(QP  
oa
oA
o,
NEkA'#Ilrl`T$o=%q ok!i*rpxLs(a"Wal09?g 0s"-hu1jH( AdWss @e7"}e PnAd 4@~: DCA#.ys@tidlPS.hol0`?D H[ /h@e-  , d"n|uod sP&kl<Ak Ccnn@A:٘RO brrCegс"iHUgylÿD%SR`	F
	øE#hІ0mtEb@Bl?o {30]6  ignostee?  H>A 1 (Rnsl ՠXBP }(P): 30aAӣ pgr 0r0%h[V\st@vgF_<f_: Ka"Cutp` ΆUs5$SQ&es pTo(Lesb'0Rt+quribް: ID@01s<S.M.A.R.T.-f^ЯCC # G#5N@u  Bekreft njAv@l #APP1qpʢrذqj `vlikt Du  좭! YaD?rka gA3ogs?7 o sdQmpelPAf |B.
A/"r2P(<pƨ.  bpkuY  m%cQ>pvice.pu lF?'ß7 BIb@sS[H iP tectTools`3curity Man_r.%'-ҢQ&-cl@@Dlcanappa>us LBNm!ErX!gi %e u beskѬbu"-bU+/- +"W%HѴ  6'. etglາRh,vҲ<$P O5. KH$RmEp!qfrard-n Parllu!FhielQrp2   CD-@%sBV2u Ho`$.:"eC Eh ?epBh  1hh"4b`BRUKER~HOVED-T6 CI yumu 2aʵEAd n]
2EqDbeLp?ap0
 P0!Q `wb ! pa" 
S,!SQ[0=@	"C?`6`*pp  ~1lJ I/,   autom@ZpDwLock3<bygg[`	ct1qa   ^smaДilg ^ge.Ӏ
ohx_TG fys!ad p$b0ifdn!7 vm=	Q} CvqQnfn@e^( sA 1: dda G@8Ubx. UB,rhom`d O1 }/E XG)znQB uQBVPnbeCfaQurUQ  AG	}qQ.q1`Aw A/k1BEГ ?iO! D!'~I73csw-wflans0@ ߢ1
,P<r ESC-zL@c˿pQ '&D'BJ F10uY¨bce ډhTme] NorhFǅOre@b MultiBay @\sz PGn(vee)`Шko@.ngssba0hhyOBUSBAE|v Zip-U
A A`0`Fn/Ctr-lTe EU`d(USA)GekeenPel	jZtro2 dCeo@p
T`is!rrbp?s 243 Xa7ti?aPѓSIGgradi/ trdl  |t|  WWAN)OOILOJBluetooth 5/-eftqm0q Agsssty!1%Յ*2x% (v&.b/! 1 Eth;?	-P	3 !R
`NT s*oo`o/
#<ni@B>`jtifikrRC&@Ba:riJ QL
t`   6ymbo KalibK BLAes- Ip?psal `,-.	/	 )	/	/	1o/	/	I/	/	Eksp.bn/	ix/	/	Hnd3 O/	/	$/	/	VCv mob.  Pa^
-- /	A}OW
IM/	6[ TN: La.< `% ] full `2 F!~i3
i1!n/qh* Ny  M(/ *DʛCRi2犐jm  sinҀhurtigŭ (/sekur`@1F12-f1. AkS0ep_ute PpConfiguracie la Com`adora <F1=Ayuda>rchivomn%l Sma `1GuP!isco fOlexi@cXۻ Ra`&svalopQfdo`bP`a y Ignambios yli a AL{  g3 'Ln epidadAse
  ' Axjiciof%posis_SIԕc )$ +U*KskSm!=CP So1e*cP#<) Sect}yincor@% E0e"@ 30/c`VxP>6fbrI
aBЭVc!3nci])AutomaHerrami@a@C|H er  8`#P(8@ ;prueb_a HDDKc 'EOGVp&Memoria2aDd*mp.`l1@0JNKRMu0G`SG#
s
 AvanzX ESvVDD
W? nFampr)co0N gr<1o?)<UOprim'Pquitec0g2)@Pbm=, E_SC=Ca06la==Acep u=S?BNo Y, Co	=M`Y bp UyBr$dch$ha5al0}  Alem o apropiU=@?y<INTRO vtzpX:bNn.Fs{3Pku4Yu y: Esp~o o -> = PrxcRetroces<-[`0@ aXTAB S	3'A~Mays+#1C(/`F2!-910`rĀ"8b"tErr0F`o 8 !i0GS0rjo u Q2A>K. Cd`01Bhay nunW>qubRnY2 A#1+>br(RPq[coRUD)J ebook/MEU?p)X q1q0\2@Oi`0pleШVxitosa4e Faj `uTy?til TiSOp7T,ÎVclGPu7XTamaUZu_h?(?L1/L2)/cs FrAROM mil cNmer}ri"`visv @j"6rpgb-l?`y o!!
/#jI1l2n3p4 EtiquqrsдlIBVetFK (Sga Woo-o3oopoi BEsnP!**8T4:eZ$  Probs%"ȑ}sОsfactCXJ䙇 =ll?̯ Re`o !00o81	olneRdip$Cl z
E@| o|iDFAdp :vG1uir?el QevpsɁ. PreT/v, @qW#scđY#u  CA:od Uu bpk 0s&?4hw?teg
pd^vlhdI$'vaб?Bo(a)A 8%pS	 lLZa?gnݸoc  il Nl'g(D:1 (Rp)e;2 (CvF3 (S.M.A.R.T.) Clcusvtie$ej҂( @s): 30hЃg`o B&40%}Cb(FEHְipalGiAruamq
b: s,puPѤ᠉1I{`3nbh7~Servof 44apoya(atrib: ID!êexas G
XXsea``KHnuevL%@)D S ApagZEndq9S!&GOB".?G@evocm	0k6ala o
!1LTnad ; paf Ҵn\0ԉ9 A*" \K<ѥ,`1ܠa(2o,aGQp0s (0d26 EpyWci{(KK"² rvr@2in½ Sqfl_nloAecal ol਑X̘#AvU	@jvi.bo p'z#`v?'Q6Wpatd!n3n HP c_tToolO*gKn!P&  QuickLockSuspen Blo^4[rat"`S  f6"r"Pנmej eNS_@f?Rv:c+,y'H' ('prKlRt+D, Qs0I?!b`z,KRHOre PuPnc +r'ojo%1>ldW9LmedqufhyBC#D-(-EP,&DGXPj:Yde UsioрJu= P40odirive(2dL! t{USUARIORJ PRINCIPALr?эk _u d&t@VKman V p x. An;4 y gu`$ǰlugCr  `jw{.(.&4J @d+] X	jGS1
!qcb5=vZ> Qnmpc8K0	8qݗFВorP A:
;`;DkR0`u@t೘, fs`m1$겟DF RUiQrPoc,I"o	  /_%z<YpBud/aa|sRcu2bSt?6!`? 0{da$kosaևg Ѱ6Se xoч0enf 8d@licԢ@reaz. L/?k еu "`#0Z4=ԭinɯ~ qk?D2 Bu8Z`
siPApons2>絪Y_, i02 ESC. "xCPՁalab 'Fd'  0,F10A:FrwfG `'1>7T/Espaol O 3`tM?ultiBaNQPa DiPsi(d3-pa ;]ȳfbco+(iza:(@jech - cBB a`1ХSuwrkrZipcPmeqeTe]r Jo C`5tj x Sj0O@vNop& DpǠCAUs Fn/`Ts@cIngls (EE.UU+.)s0¤ (۶mplSo}"leA$01nt!Ac@ Gspeo ModZ!ʠ!  Bidyic Tam&#mpI ĭAAϙi	si@ fuq|WCYJCA. RpA*WWAN{L Bluetooth IAp
ɰ}1|1y1`hoergsȄGCpoosxB?0P&;(s+ior)пEt}h` et, Nboo V I1/,2/L3/.TokPR e OO`Pr23 IStif ExcGlus@sAM a 7`  a*Cpg`*-Np[pSՏo!Wr)Yh !,o	o	k	o	h	s0bkn	@o	o	ek Ao	o	 o	ao	o	%MEU  o	.o	o	o	o	Ubro	o	o	o	B8[p 1[ :rg2. c% ] /~$Am2 c4Ќ-Clepτ3	k",'* R 9ODJ)o!oh ~Aq!Bblޑ@zНArranq p@@gUXDĐgrEx 𱠧@`F12ϡšQTAmbTouchPad@uqo N@uBaӇƐub  <F1=Ajuda>rpInfoˇsob o Se i ?5mDBѱ?	R$Q0
rt@7`+padr0
#EIgnp@
Pair !	Ts0s'_nan`J3afOЎ!Dbr %&͢ _@#B!H_D#!6

SJtSdB?8lizb/pyO
(I@ 3`]/R 1*p?g%0Ҡbrb
aut԰P<Qn4dcEeAlbxa o@Ma QkFepOmas`"g=Q@i#08$!leOpTaRHD7D A1)r  VR#Ke Mem`@pA<0J@ 4tat1uR`Mu V^G[© Av8AS%,io`A^d; `ca{mpPJcinz "o?CAX9 Pbse q`lr wc<'tinuPgy='SC=CselAce ,imNKn!S, Q%ou=Mai`kag 'Uti@:sC	qQn'	da@ o i  aprop@v *u@Tt#<ENTER> t5me2ez[@go.Tgu n:9 ^r ub: ->
PAO = PrgxiK\<-QoBACKCEªxaQETABo$SHIFT+C%* F2 	*:@=0kSC# 9nErrrOA@Q@na@WoQPmRHE. CϢdigTGo 01  NPh?h6P,oж P+n	 ?nѸsjuiKPCA <x	lBMev
;nsf@BBY Wotebook/ƀ#[RWSmDpGSTe2Z$K+Xqm"m xitoAqnP=N  TiHp(`3rVpc3_`p`p\ TaPhcache ?(L1/L2&Xa ROM? FamlqY  Nsri|
Revisvde@_AJrorK!
!lD	`Otb @A(34@RtiReBp	JIOeuH6(u]@) { 7on)oo.Oo$alpC3~ƕSecundabp$ 1Rc#%uPfoigv !`mdOalx Walkpا  0e g1i	a liten1M!o3Ig dAdvert: `[AQ`Ðo? vAeDjWcaqAC/v,i um  ?gravv uU:d%OA: n Ad`	c@NS3 >ЯB^hOП?^ptegiEa	pd]
pvl@I= rkT ctez0<eja $ . !ioc. 1 (Rpb2 (A ng!qf3 (S.M.A.R.#T.Ax`=Е_(.): 30<Peű0@CT =4Q0%ҷ?z1$bucedeA,Ӱq1hos9tDCrom1
: Iss -0$Eg
Ch@aƫ(*pe=r0mec@ pA%Q3sxMtribrLD@!exa s wQUUcCig:TGrDg`arl*Ls   QL@ rB+ۤiPA3rrfDigqcis g ?SUgAdP)0PЉw mod!Csݧ" faz!@AREr@a,`_rdfor!mr3$n,0ja.@eH#sHfbrcausadQerF. TbZ Q[S a 㷑2k_rvio 	Iy r?)1TV?%@` urb rK
ad is3,"q,bQuickLockSuspenso BlAokTB⬑"u aS-%@ maRnb(I9  k,@##Al#.p@4sa4diRibR?o useu s. Exig5 rew*@P"MP+ p&0er#me $lfp*ǆCD-$'GPa1mQe:P`Dusu1: Voc?q0g5 0@urut@znoDriSve%w wt`QUSURIOBUGESTR
E_r?UF %PA7<`Vapaz:HA. AN4 9de-pL`isIA!=p|D. NPNv`[v'Ue 	,qVr^p*#0esb5::T|DdeH]$.&Pfa/[sBi2e'6"T>CI@U k `99O su7m ;EFeclo,k#@F7 Ca^er f
a`/u(u$zboTb9AaQ(ʠ=ս 2oqu2<a@'"RxEPkgP4U xaf`T@px`x,Ѕ ؄;E  3v%or@nal{a- t
@Ä3t?ZE ܕsubtuCdBz ?` J((0a?lI opVr AY  LemGbrevLa`sapQ8
 Bqui1Px_sPe ESCV0] A971CWlav'6f'8rF10`c"ꀃr:MBqʶsSASp=D Augus O1: Multibay"XN$c"i@rBeAoBa ba𣱴copld(R` di tzB	R~"zipcPrimeir"rc QJt҂O\ev N  c@Aaсas Fn/Ctrl┣Ingls (E.UV1΀SQ[h8p0tro<gvde@cund a`@hMo`뇜P7adraBiQ2֠TahrBme#m sOPpS	xsem0 f!uŀ1w>t ^ ?CAN#R` pkm   WLAN)  &{Bloothk
AnRΠٰe(a/ Eomenerga ere#*agBc/*1qwV2%,2o-G0supO0;Et#netg	Op
/*3/CToken RingOO boVIdAfdpP(b 3ara1T UStsScټC0bѹGP$_ptgemDNSrlCsrNWDup;lo&	ted /	)	E/	fONOOO'as7AxjO/	`kC/	cIAlЏ  OO/	Oj80{MEU/	@/	-/	G9D q	/	/	/	O6[ Et 1:rreg. % ]`Oc3l@ 2:c vN3:DM* 
 o9ayCJm*O"(sflexQScrydapra징ײi`Popup Exǰ8 ~п@F12a(B dQZs Varaak Nu`Ti qk yktukP  <F1=Ohje> Jrj`0tQt Nytt -vtu kP Tallenna levykkee Adk@on*oP`uVCt?F?Fo0Tej'nsWw Oh muPA lopQ4Lr  ttt7fTpou@aurlisuinvojan ssapM?rit?OKynytk KLat9Cl	 1usnu#me0	O  -u
t l+ykiPu@'
@,(onuki%7/'etF-"t2dsm<4%*tehdf6@Gc"tP!j#j
;A )ma)inTy/kaluA!:  o`K Z< sKi@ 3vytTO8?? Muी@Nk(!  a5n@CH:m Y-FGLisie#li`NHpk aec  harlAl0/ =p @0'P-2Q"22$JatkAinpjot  npp?\=$, ESC=PerE =Hyvksy=Kyll?rE /L, Jok)uaK=?"5^ nuoli
miP^kP`a hp$ 
si3KsMA <ENTER> m!IEsePP+.Ht?en !/s@seuOraav?` ->0Wi VLINPPIN =ЛYs  <-bASKELPALAUTEdd0!ARKA+ f4V?AIHTO+', F2@
+(_|= DWc@4!;virh@uAkkua e <oi@=da.=: Rtdig 01@*kaa1Pr`| aGrt2O4k p`g kytke?v5ko=sip@`Plak!s qo'qsV  kaqBt``olaa`O ] Sikk?BPskeytWyi Ena
i`((PNoi2GnJ]BofcaAFmzj~8|Q>i c? tyyppgIn 9eapll~VliSP (L1/L2 eT?  ROM-tR`8@l0koh	tuotepeB"isar@rzVeersi 3?s?tohjab T;{	!1I:#2o K3oL4m) JKtao.7(j [oa)



\	\J䅶1kA'ra- $pA#t$#:ED$ 8ar4%Dyz lhp!iDEepoӝi Walking 0 -[1Yloso`Vaihtoe@ :0uvi7 us?: Tm?"`? Qat0n9hp . JBkt luoœpus-  n9,irj2Qonc@K A: L"SX XhjuaV V3eF!G"08_Cpa С
Hko]aWi  An, ?2 o  pi?,i@%(ND92Q`3.M.A.R.T
.`ArP$ [` n (min):g 30s?@2x0%3LM1YV0 Ispysis-iVgR
?{eAuCnt`q`'zK)jServomogott@j
Lu4CqvAtuZ?	k Fttribti2P@bexa ePqKcxnbGG LP9W UuEVahv!u  x 	Pb>Ɣq!a" C ܤ"ab|A*h`20?r?aМ	--n { IQo@n 4p-okkCPad4ana )in O,eҵs`ՅQ5mysaH	kQh@  e#Tpڰ	D	XOr@iWj\ZJ unnWyP0[veapahtuamaa]id`9KQ~abI 4,@ti lUi?HP PrctTools@cu ger -apua.&(-NIl "Quickp1fa hB@l!5Bրq, " p Y"&-޿+)sek`cp"/$*$Ai4)ʁzd{{|yh' p@P 0`#?АRBVA77>uuŹ	aS!por Infr
nR` ѰBkqCD-к -qVl aoV"s@ bP@>3@:NyjFGAiotC<\Utn DPe#(!_Ի")КKlola.   KYTTJN9P?S~SANAN,uIaf?%la G#@&si3lyM gurQ7f Gri,Z- t]Hf$rV-`$T,p# `h
LLAA0!:ѧJ1& OM5Posa vb 	su0E<:id,""t?4 &/ikDB ENZpES 4;
k bD(
QOvq%x@hB. NykySaF5@*!l0Peys/pڗQq}to @ . Tlt ԡ$0`{)$ cihueik=? uperT:ehkh" G@Q)ac, kaPvPa0Zt 0FtaTp\< OyAaiem`kztnaw ᢆfmm"Gs?t2DT0Sw-".B:Vov] fw0eajqP oYVrc,RE/SC-nnPXF+n,@@$'$'A<Т F1a0g9aauTv:hl -?7O Oj@jaAqmi$ys: &Fn MulotiBa Op%J7lako0ir (ena/$oip) USBD p)Zip?Ensimm0@Koelj@zVi@zKg`eitK5a0kp Y gKymaiP Fn/Ctrl"m!g Enyg(USA`UsPs"a !!ݢ,RsSnjDBs Os =Volhlta[Vakio s2sN 0IfpTj &uuǱI?3QverkkoWWAN-roHLOBl]u@Xoth @/G h`-,s?VڀSs S;l {|.1@iitH:;12v.-0	. (ylosp-OGCOr8Ether@o4E Yoeo3o;To p&g Oo(CЫworkQ3&G <lKlivp# xkkuU < TaJ5Pҿ r{jolibrfu 2cdē Duala-O/  /' /+mb_O/A  /E /Kt /h$/e$/k$@wva? / 0 /0 /-aanu
sBk/ $/ //Mb//`///H[ eh:R
@ada΀n . % ] OD0V2lȰurۡ%OE-O
3
Go@gMOH*  7i Y@&`Ю"rk@FvucP`   iО` '(se  naྸ@ :t?F12:0ۤiP|%3tappikoskeP԰0\  'mma K~  Ei m Configuratip3ordteur  <F1=A> Fichier Infor ۊmaff age Sauvegarder sur disqc Ra*r ?pya'unea.I_leиalsp
fauow du'Igno%modi Tqu S$e l'in@p$@8`regom	\ SGcura%
e0ssLdS"#j@e sous te0 Ion E
priphP %'-s s IDY'!s
Dr ;LockqSmP(C0 Prp3r3R &h9e0 ? `1"#a  K<`ڂgrta,	)4@7am'p'usQƯ ?@):r?frenc-f P= `t"OuZs"lonnQLb berieZ slecSn@pQ!s@BI0A`TAڒEoV)mmoir@c"DW TC!WYbF"_V AЍc@Langb4hoisIYl3Ind)40_mps g eLd.ra#Z-:+?AppuyeAatouqpofPe`zuku=Ser, EC_HAP=A l@HAccepR0=OuiuNS #QU, N'imp_e `QD
=Јaaw'  Uzi3
7s f'heL
mo!4dcle `hmenutcerqetbri@2hzx <ENTREE> 2n3j+`v	s	sui/fa  !/ :A-> ou BARRE ESPAC_E = PBeĤ -$IEpreced STAB`CxA*'ZMAJ+ix F2=1 "/w-$!S(rr P<TJ Il FA%ssibp`c7L U cs'Jprsodpzendp#B$P. Coa<'401Ac5Cnt@-?  emplace (t L' ĜRAQre |#'Y
GI 
s|^ccueil dP# 4 A'exUsmobiq݀a0N8Hp?
u`  !2%vX|	a ruW Fa:c10MMTyp0os¢VrwDb KTa@bcaa(L1/L2?) Volu ezgD` ROMOamR NumroÁpRev cRdoerHtrcGlavopL }5dm`+ /p/:r3/\t94An2inv/zxY&4 #pritFK(Tte) OOoOOODPB%'e@mdA E/ M :$/.   %r4 !SBc;Walking 081lig'a	d ušZC	;od al0֐kifAPtiҤSCB[a=e0truQ#iep Ɛ1ruP0sf /AP,i z{ n1crop°0c 	CY]A}jDBLt_Av
 wtro  PaC
sTX	 ! _[RvpjBaQ@d8.@On m:Yf@ @f +-vPPC2 l0  <VIgnoI+Bp|y Enreg1ep/#=1_ (rap )#>2 (coet%)u걈xV0imA(pz) Bc30`s pA.U0% nv 
"D9pʈt?l'h0+BF~@ :k	aSFinnuFd'+, v@t(
$.L0 Gp4A ibx O: IDA?l`cs S.M.A.R.T. Abcan`GV0W AHxMY@se N<aYP?/ ;sa1?"Q MarŀuinS ;,deco@ac 	AUQ;mme, v3K*ad06@OobbatRs	Bd4	΋ pe=a!`q( i s$3[?ps1"t0<i f  formf-h V0#0xAsAJ$@)rPmBB	J5@
1$ASJ.05z4"p C}R av ;ou?voj!pA#frDv v]	 	@ zY1 R$|f@ffc  ;l҄bgN rHP P oTool9e2y MaJArO+8Cf!}/- QuickLockUsus΂{a`ļc!ri 9d`B<S&Nl'+,ś)re!ca 332K)m+:,  uh3// / L' b(1'Q
$u$!V
9 #K@
dra`}a+Pn3 Exi,Aud%P_  p4r1a8llp&|;flash Y CD-"'ǡEƠ*W0paAlX:5 6#e Drive). S@@"A%Bdez Bdeux"(UTILISATEURPRINCIPAL) "3E'	rR$SOj N`;z*sa1 FaA#1"hs3r  ,pmfe0bcelu&N$ordib. A@QV	 A{(oNV)Dod9 @fet qyYJ}@N",t"~"a1FXD"moAfpv; {;""et 0ё^E!)=?	>rJaniA4`#''l#2/r,ac̣Ë!k! 3PXg_!R!ݑ s! y![DZM']c$uel2H1`̰܂3U?:Ggg""q"o S~a8albE
/'f7'!2`+_W# q2d'origi-nIl2v OB0x?a eB	u(
v1SՁaPQ99ptLࠪ
4d#j?PPsaހ{$S@P"{7e*ߵ
$!W1paPprsp! ѡon: topS B2as4pabyt!(fEk'
ui, appuy
@`  ECHAP.@ @NaTzQ'o', puiCr1DF;10`TapX ÎR@wwX7^}	U/1Fr/ana
OgCJi2MultiBay10l&ph0A Q3D,xsocaŎ(ga¡)OOFy) U[8& USBIb
QƗZiepbP@: D hi@ @s Qu9aQCin NSixi Se ߑ  Hud NeuvCD`Permp/r(s Fn/Ctrl z AnglP>0SA) Pxöoppms =A`stanʛhnOd'0adn el:trl'TichLQÀuer0Ҡ&mϤ`
*d 9i 7ido1+BidԢ 01 mmP JVlpAjrF2?pal   R 
o=sil WWAN (rse 0i{l)!
gr b
LBlooth7S/?1  >o@% g@R`Wloc<G  d@ZRrhO1":1a
bP-n ho<)2ooyu=B6ccunod4ogB E%1t$ 1A&23To=k kRingo oU/Idu4:.ar`!\   2     h(E ll ? nLreТ / x Ab!G.f*Dul* /)///wb/// //*R*-///Jrgn$, /0,/ /e s`\ B'exsabmop@ 
$Ao o


 [Qpe 1 : Charp.  % ].h  2D  FicM*n3@	Rkio."
* yT @ @/MM./(OG/ Ad_Amorc ƕŬ5 RetardTexpx `) D0: F12tWposfi +A!ux  Pa'v?t@BJ|cun IzMlq <F1=Ai0>nfoPgѽemal З'Salval ?floppy%A0pttoRiprina dplTh4ifa`iܓIOgnor`d ed escis EP a
l'iIP?zbiBtupv@ic zzasswo%e aym6PratoӀ`gcc#P
_Q#*vos7v<% IDs
&gDriveLock	0Prƃ)S t Cp7 Supa;p@
0c30 gHg/o +:,i fabbr
4=i	/.nzi[Oco
ruqi C*b5<bSae"dElrOpat2;o rigid AtaA'V˂,a mePTW X@0`<HKhMi	M;A>o !Ava=t L@u!O l$Dim"& q6ca X ssob e3viQ g&	vv!'#o*62wH8Premi qsiasi tasXpeirQVu L   i=f, ESC=Annu`,TaA EtPoeo=SiSN1T},altro#	=A bj U}s"SchiavI? frecc'!ri1vocu ap`=f"_`<INVIO> p \k\'e.i^guai  un%:` -> o SPAZIoO = xsuW{ss`0  <-poBACKCE@c<8TAB@C%o"MAIUSC+)XyF2	>-= m "AC"IErriS0D  Qu A87n`pu?Ⱁe0tVSi ?v@Pu3$|8@(J. C`{}'01  N0u&>Q8A0`}oggiao L{@I0' UA=re0E=s@agga%Fv0C!c岓  =nPabook"ippaj:\KZPf.at0QA_2GoOurj&tduP! =N$  Ti*;S0Velo?8wepp YMisca(L1/L2dcDAbROM@Iamiglk N oG`0(	R[[oxi1SrollS3j2Aer`  ~Dia,k@l3n4b`7`w VTet?DFE(d) 8
	2
	3
4$QVFondaAĞʂ ,/:V$# TrcI%O`u0y!'Tۅؐ lliSpr:bit 0t 1Rindi#ri0	iq] P |'FAso:X%?gger? Г |vep(re@M3/r呧, @ favi0P=PiVYXA:dl\UZA:l?]onopu h^aOqt!rit1]`mpvd2I/y0SɸSe2Ʋ`voaPGa ?5?Eqb b i`1fre?: A_041 (Rap )52 (Complet"vҖtio (): 30=V0%5r6a1r`'h$5(|C:s*P p- 
PQ (D%erv{2)Lќ L 	A߷rib` i0g{ol: IDpĢanp de z قi S.M.A.R.T	.ݑuÅTU ~ _word vp(nuo	2 pDs`1(0CUiL$?`b
db?栦[cYnd?
O-!7Tc1^
AmVe
p ";Ya Ib	t>J$ fu0٤mx3Cee`<R aòu"^t 31a@C.Q]@WRbDFqoP !erdpatiwEff+Jizso in@ahHpvvgaΖOAdesR JAm`YyҾ HP ptectTools Ot.`YaRf+ `ickLocyk spen@3B4Y moeu s08 MM  dp?#<#,0v0  gra p0'!ore -e $S-))v!PKsm ] |ᇉ "	,'Tsar?pi?Plq NRC' |@pAUa|a infrQa1)xBLчu_hqflash"o C#D-" S %fWІp@	  XR=!C삍QcRx usanD eq'. D8GR=Q @@b~X'UTENTEPRINCIPALE  r@+oSL gman#5fu>`o. An V;FdP0 s`Л "eqC=P@c;(0.lPe!uV1MT[S, _h	p\nBI br<4 dW|c.aMP+ 	?	 q`o0E66 dG i8>@A
 ?re,@2a d'?0	:D {sEU r~F luogo  F! i gٳFsSx,&F/	" !lwXdqޗ$0l@w{skm `.ԊbB #ȑSyPR œc_( ~2D&S`Lg"p~@i BAV 	P kpta t	"K{愡P+`@u塸.1êNB:ql0zs115oqu ^8SS! !QY@ar@Xa$Esn!O`d'ŭ vg,mQo E#SCFL'Í)dovr 'm'@po2m<amF10.ȡ !n1jȗx $_[XπIP(i 3  O :ㅀ갱cL  MpiBay ba.gSga0sdY)ohChGi USBg\"	Su kHZipCP6opTerz POvN$@ec A!0 Fn/Ctrl Td Ingl~@ (USA)A咐Xi`suN 
mpl1aP
@P 27Cpl b!a0`@ŐMod8#GBidGAACapa?mem A`X15emՂsEldbQP2
ё/wpNs (WWAKN)zoLBluetoothCommu	/ (J)@Csmenerg ]phpW&\ ')1 N,2HIBt-pFa,(FPo)olp/spo EthetWJ V123e Token Ring !OE3 Ij{C0B}Cta aL   !o1(  C02b//  WD|S0aoo [Ki0DupV /  o 6  / o ,o// ooda   /  o pTI\mo9#/ //OOOO OD}///pOOmZ[ Pr 1 :`#rtos . @% ]<ocompJ#2S &@4,n6E3
 `
ij!* 53
 IWW2i,E/'ЯOO A  FloppyTBApH1d C ͥ~P(sec.) vel` F12b r8wpambP NuPup <F1=Hjlp> rkiv Sy{infEot Ps~[ SѺ pk:kPigu 0stl?l frnAr 0Pn@ard Annua nd@` ochFsl`   npQ SkerdtrslCp  K!aOB@rt-OaEnss	(" -ID
 afo
d m`
APd-Std frutQ!av 7K
 byggd 
 usBi=*abrikj+ .J
sbehrsig#Esktsrktygs K +r vl" S ;vt`gQHDD Ak_V Minnes:" 01q5a@? An 'j@A
Q  Vlj4rD`;CBne+dttl AB-@w(C-j+eTry@Qp?fri Dgp nr du viI@stW=, ESC=AOvbry KaFTAccepaF, V=OMer bX JvI pil	c	/pCa yEt~
<RETUR ]comF
uYRttj#.ie,lj`Se%erI  >: -> MELLANSLAGSTANGENTEN = NaXS<-BACKSTEG FregepyK TABf#OKIFT+H& F2`+?z=  'fO @%Aoi?Cfel 3t g1qL  kA@t h+AO` Dstod uGen. F7elk0197
 AsЊgF{ |plat@ Nt0hm krv?x `PbyఐgЀmЅ fly5s t6 5-dato;r/ ex@{YtiGdigOOI2-@kl@T ATk!NԞ,0  Prr, t{yp
hast^hg0CaP-	rlek (L1/L2)dYd ROM,0tum familjrenummnDdeo, r Y tdNb ~PqyrrQH' 1.z2")3b$4rbinv`ʦ3+ (RZ)g	1[


Sek#wIqq.$4$ gAxrq%%xz=ok!ŎvidClmisslk.s Walk0s S- q~P f1jH` Adds liP7Aet`anVar! Du@/Ъ  7neh&Ccsuskap!y /-$Йفxi Ƒ=kbg$`AA:`Q K=Qh	i{wI"B>skyddad
apg

@ ҏˁb] %ͷ?O͠igt?'jSF!- 1pnGabb@8fR n X9UWkad k$0Qd (Ф): 30mpn1>0%"X 4o/`]spp0vrjatn:Ā,}t؂Ok@%S(x ervo-L Bzh(VF%ttribut: IDPx?gr`o"s.M.A.R.T.-5 OGammNt\۠ifin` > L܀PQ R4d ƀ}vlika m@0O@  6ǦaInEkan orsa a@3ji 9AHc@Nyp@Om_=<sћA6lo. N_a om h@ߏglm!btj Deh ;elCse - ^uDAupaV!΀V >D@@fun 0erl^i HP tectTools%yI,-6-Quickp telge L0mxAs HgH$k
gb*_7- &q2@&!!!r ngo"pKpF5b#li`Xabot. K7oimpHip pJ1f  Pk`an`Flagsh-@: sCD-P0BWu O#4pSr HuvudH@y I: D, mv1hrdt dk D`~e!. С/@a^r ANVsHUVUD#|@0Ƕmart w.] p? Lp?q0il@Wfr0ˀ+"A
 IPh!Px L l 7(lHTwO.XY   *oH XqBe0bbyggP6Q1C g3///dZ6- FX䒞a som#  KE"
8(c!?  q?Dr9as@"'d gD[ ktuaI ҬafaAnqkq@.Gut!M#]tg`sp^AWp+tursprung`C`KXK. Vi?  reko a dF	B~c	WrP+,ps@```b@~. A @K`Ttasu_Bh &ӄg `!(g~AzN-befmse rm ihѓflj1fns. Tr0  p?ESC-!BS" U$Ա_'vZ'R-sedMtapGF10.CcJ2da:c$~sHy% !Sveaq !: N?, MiBay#rut ~op0Ps5GiBa&G (0r (h ASBV n Zip-<W sFj1ttto NT Vx0Fn-/CGtrlU  E ls(USaA`blpYkd 0!!!њ bpTwrmsptro2x,&gbbelѳorleYkh eo2nlkPAL@ 1R sfrEs`Ȼiotr1tK (WWAN)LBluetoothm p/() -v@ANmbeqAgg2s haB
E(-1,d2v[,ppл'Ned Eth,& 0	3n TokR1N "!Unik *`?1iG K > tus   \  ? Sbo> KalibՀ o dP~-  F=sbalQ.O
o 
 
 
9
Fo 
E 
D!m1s
Ao@o
E
Htag *o 
* 
VC| emoo]A*5o oe
DI OOKood
D?[Ne _ : La@r . 0% ]
˯klar2u j25
3omFjOF* &V@1  >I*O!DgOЀU®br |4sadap $lge!drjQpsnabb0 (sek.F1 BdS'tyraPguen!he( Ae/ `POp e@slaan Conf'igu0poanafpvtndaardQ3!/  scy	WiojzigS%ne@`programma 0ܠ0Soetup  zr w ۃ svei!Behee rswachtwoo1݅
 $X. A=p aatbOgl$$ ID's  	Sm4CP P 	Oau3P$PEcR%mj+p%O
Ge `g3 gvssvzieFabrieks.Cugz7 ,/);Vref.s:nieuawB8ONc  ExtAcc)uwB ZeN geselec Ea p`Es ~ zelftGa -schijfeai`AcAt PXvG0u?1@I R! a/ 4UBgDAUcg@7n ,DP=0%_
 w 9aKc!: Taal b  =r/em 	rijsgemaak& el=;o" `/;9
8ukAZ ]0ayNMLg]@f=S, ESC=Annul"EDG0=b!emJacNee fsl;ui@Q, AQ-f`=MNHulppijltjkp`gebrui0d )jui~Pwnukeuzk@ark^<ENTER> ind 
cr]bqeZo !vol%`@@1  0aiX:  -> of SPATIE?BALK =><-BACKCEVori9gl)TABb	|#EHIFT+%%ܺ2+Kq= ykp=tx#B~fouta64k p It wf_ge15 F0M0reqatijzasFen. AcoZ01b`ea0.i1ZCu  we   Netgvoe are0#`FMPNp diVbas`e3
 t n0 notebook-pc/P @.istNOQwbep*igdooh2L	MЛaft NmpALyp6rocwessnel3Q pp OmPЂP}e (L1/L2`Zapac?i VHaROM @ -s!fS<mmx E  Hebvrgav_0ideokp&p;b bpM	$m	ra1b2rd3e4ahiQsgI t}
.jne C(_bB(ЉwMdzQ%)
  `D#^Secuib E.aw~~$Ftb%)҆2!dHU2L53Hac-0-*1Tho_adresrlafwisnd pao=LTop: zPt<tks e'ge gt PSBbeЉf  s d1 A:og-  /ޖ"x0zbLe6`.NoffaG1 Y\f_dقڀD`ѱ

boචgAt
wOC'We nu, duъ"
wil?@oݩ""aA?Ox
Z\l"+1 (b),2 (U0Y )  Аpqwrpn (min.): 30aee&p:L0%Qtoo 4;q{ho:5broA):]eeqx/nb!$32#kvo-IPsEI"
 2"qk:J S.M.A.R.T.-af`@APP@udh "/Blo!  A I-7B4kXq crlpSX8
 Vr!a1& is bBsAYoCf#/k, zTm]lijk0UKQߛ zoik` Ndvors:e ka?0QH; fQeksKPܿugzet,r XlorZ@P¶ZOb$ usBwb sqwYfur9houd'Hi `! AQ`R`T `R&BѴ񡘾
 vuaYߐHP Pr@ctTools(*%/  p?gspp`b TWmE #M"g$rgΠ9b   ~erX#W>,@.o(h( o( S("7'EAJb"f k otraa9kP)5w sXbtK;?ݳ ](Qŉ p1׀frapd  Parˊ Flash-maylCd-r@WHNǉH/oofdXVGs`
jE  Uq13xaia DQLc7A<i!Pzow*HOOFD-BSGEBRUIKERS8_L¸1  p $an=	 SsC#  cҦwacJ#! fy0k#0hcomp s%ksMq~[p%t  Pbc(q. `Y0ppq8_{!AutomKc%5:)z2U@Ҁr<zdZ ==}88 O!V)?!2:NP Oz! !. Mo0XeMjoOtD, `  CjrS8ΠRU nt @`Pe@	M/ # hui,UPd`wwas to/!k wgea. pwWanvloeC7YkjY0TsPn `pZUt0rAra=8	R40` torH/) bget. Oo
 s @xvb뎸. OmRun
1]A&`3fe*& gol q. A ݹ_Ա_õ,ubhA dc3䥼p3ruk3AESC-  (A90Ri r45'k'tyUb;kn F10`ۀT*Z@lutb r3`V4  1NEel@@g MultiBayjVzkd@\!base (ks)re|  USB-Մ cb+zp-" Er@weH鱠V V@{.Zes >Z῀>Aa8N Fn/Ctrl `Owiss/`ߧ\SStaMcW~3MijsappbOu e 0	  n ӫ$ql Bij 
V o-QPFA/A0d`dition  GQvgp<uq䧠ntilat ?p neqWdr%  Radio	k W/WAN-CaofLooBluetRh/oJ@rgie  ŁaQ\aL`1^f/(b!)ߏcEt@ɐ 1
2d
3iTo}Ra/-OMoo !02G3 UXutcuJL 6us    ? SaGekali@!OK "rB
N1fŌ ualqS\JO OO HZOOO^B ^'OOO H~Ap!գ
O$O"LPler-MUE- $J$OC$P q+OO+O  [lp 1 ': Bboʱ9. % ]!/&p[d2knte~l/{	3	̄
foh l/)* Jt  ;>.C,$ 6ax`؄Xadap @&aPR(sec.)#pop-up bijW snoâ ᬞF12 )Kbb  cursorytuyEasyPo-muisG Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋւa\܂tsfBNɕۑ  ݒOCOF県Ăg&f 
H
gɁ  Ho׎ɞ 
E	ύXɏ_I  `AO̿Ԃܫ@ea L(eA`LCǗ҃p h/do'o "X yf@\̗L/?E%ID&ID: h (uN XBSA$͍폜eX} 0g J 23TÃ|OH	, v".eI*"%ɀ;FX
 ؖy>f
cA>oAe̒  I(Df:nA%e> pCeBIvCc"F@ `F  H D%Jc9J; ڍc R5BM NP$߂MA%E@U`UO tÃB!#sNu%.37($b74L[BR af=!AEsc=C@bsAS60=͂
ς  aRAg)gjq5\ 3gp] jkڂ %iA@ugp>[Ex]  e >ȳ#wA̘r_->Epy`tOo[ = {ET  <-SG[BackSpace] a%[Tab!AG#[Shift]+eF2!,,,10nm˔F/[%  !CG[  @DBCł}@BDrp o 01 OyN^F`+@~3a
ɂACϊOk ~ڑKv@&eb rO x1X
Mp!mQ^0fGdMEU		Ȃ2e`	ýуޯ     xݸ  ށiL1/L2"`OM OM̧Fرٔԍ  ޵ ޼ ް ۰ׂްޯ ްir ޯ#2.3N4h	 şch3(Â)F(E-3N4(JPkvJ _!ndFw Xco&pF?$qv sxП6!;LsV+WalkF0s?A-1tB/Z hѢp^`OD4x:2BtςƁACɩ %C颴 ?ĎDa/ŗpg쐬AFA:݉ b#G}v!h F F SPl	NXxWM֎~@Y qZos/9@y(c  ~ցB=	H #ċ gOo g'`,گ>Я1iNp`2iS3p.M.A.R.T \zsԁij: 30Bײ>v0% bj!c OK z3 eB~ f{:@	{em`QX1kT {ǂݨUעfIFIDP.Ba "R`R AFfV!'/i `¢k@ΡdAJg(B<(a ͤDAJhvٓB"߼ /  ߽@{R@r9RVdNJǂ̂P*p4u`@aUC	 !]ţ"^
YӍcxei!ݡ£	羂 É?` a7df!f
`?"dHP ProtectToolsܡh}lWŒǉT Bq#j,.qנB4УMmNuJ<"T h80' k{-E`O'OH&J8-.))Tی삪'D<D%蕴` g4`dt!(!ċNb8'v"Q ԊOD GPuA=0V @QlA [_CD-Pu3X(^ !} K^ S:`"AzUK^ᑀ %i E_$C0vb@{ y`9`$	5 ;?`,WAT<@fO."i	0	iBlpH	͎T spR@sѿ痣JS{#ۊqH@P!H/)Ɛ!eFybYG q> ߐ Y0ۏ؊ԓ "łb͗L kł粗`Ak)/)%)AxpȦ WZq.w"*FD`nDHa(o(f}@#$'m@\@Z ( ?IO)F) u
χ((?(9(ÞgDu$x#<43ɑ`檇ƈ|M3 f=ɉeN~^@&A)F1jj 8cB  BgBB}AӑO"O cĪ(2ef̯攌8d툐q]l@ӔCநaUC"1/g'y}EE[Esc] @ȍ~elAիmT.?DriveLock }t[F10B MS  y_ԝ7`E: ESxtkGb~@œO xXioiEcUSB Xp H Zip1Ԗ 2b 3 4"567jB8910r Fn/Ctrl~%̐ؑ ǯ@{`\p (USA)> `|*]B#fo+X
KV&Ws
v C\g͍  }]ZJ _ =rIo@⬤ cW>o%wACYe? Oڑ͏̧p,blNi!WAN=j%ML@hBluetGootg/#j|`ߓd 0qIntel  Execution Disable`1ү//1-2O-//odhEthernetMX 123 gPq
AOKO3OA$OGj) I+D P8bgO Q     ' pdfbpV?k ej^ o \(%*nP/h/!!8!MEUw $)o }ooo)@w!5bv1 : [ds . А% ]aO<2 !gOnv3		@)J*   5`$>s'pmj AMD vPowerNow! tech?nology"t(Ǟȅ 	_0dް Ӱ ëpPx(b) PF12Qԁibxf?2 T^`bAZB  d                                                                                                                                                                                                                                                           ` a b c d e f gtH M         :  	 
      
  .       v    h    x         Σ       X  / 0 n  3 4  5 6   ( ) t  , - V  * + H  m]p
 N % @.   mm@m$md+m1m8m?mEmDLmRmlYm *`@E<BB<U> FߨE0`8l v x|v||~p0p7c   c _0A }  = ~ 
=$$$<   DDD    O aƄe  i  o u  y $n%Ap E%  IC&O} p   U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1(? ) +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'7(

C$: |  s+'()+'*&83&

OO
\()|O@276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      p]g|mA  m^@ L .@  >bm@ ED @n.mLJ@@q I mp  ?qU@TrArBrCsQDsOuFTuGuHTvP Ja 7 
m9 cemhdmBbm fm1hmU@q@b , _gm@W{YXt|dU Zt}[}#L  ]~& T W_t`$itVa!
	$
l 	 
`	
 `
`
VabcDdeDfPh(>{&4`mF@ p   @
 j( 
( 
r l0 |n o : *R  	mAb b W9 DU VF10 Setup Image_SETUP  P0Sq  '; 	dPJ" *v@Jä$%"IP a|` 6
&$`ԩC U؄ TԫTUԠ*<g*!"$DczN: 'ᴳU4㴴4崵Ud紶4D8b_ : (wm
6  (U$))$**U$++$,,u$--9 u-g  U0}	`
9 
XE#8i3jGe@ #!" #;" #" 
_8 RMNQNO>O 8 @
:	 
    T  /	Hvc  b"    %    S''!(( )T)U*V*W+X+Y,Z,[-\-].3V
md-dh.h1dii2dj3j6dk;kRdlNldm@mGdnUHnOdoJKdpLpMdq5 ajWmfoq$HrHs $[cm@ {`{|`||`|`}@Р{<`}(}2} ~H`~tu wxT~Uz{  }tJ kv 
44(3)]Bx`o2您T$\\` 䇥0L'\t ;RV
釄d @9 GxTna%MP@ Z ` t @ M@ > V x @ @ M@ , F R h@| N Mʀ M6@ P p  @ @M*@ J ^  @ @M&@ @ X r @ @M8@ \ h  @ʀM0@ R d  @ꦀ
	@ T xJ  @} 
M@ U$ 8 L X@Ubn @U @_M(@ @ UT l @U @}M@ U> ^ ~ @U
@ ^ ~  @ހA@ H ` t @ @M@ : \ | @ )@ F Z Ux@ Ԁ@WM"@ 2 J U^ @5 @@ U< R f @U @M@  U  $ (@,U4N f@ծ @"T -@ b   }@M.@ UX ~  @Uƀ @S ,@ X  5 @
*@ U2 @ N \@Up| @U @S@+@ X  լ @(T6@ h   @L z @րMB@ p j  @$@:@ d   ڦ@;@ f   @!@  ( : P@d @Ԫ @ @@6@     &@8BJ P@j~ @ @Ȫ @ 9@    ( .@6R<K\@xU @؀M!F@ : UV v @ո @"T9@ 6 N f Պ@#T.@ Z   M@ $ &@ V U~  @S*%@V@ z  5 @&&V@ Up   @5'2@ C\ n @J 2Ԁ(R@   > @@DHL P@TX\Dtvz~ @* @bAi @Ѐ)b@ @ ^  @*@g@ N v  @ƀ +:@ : T h @К , T@ N t  @-@m@ 4 F h @ޚ @. [@ 0 B J b@r @/]@ H Z  @Ҧ0q@ T tj  @1@YJ@ |  A	@S2@h@ ~  S3@x@ f    4@i@ 8 V h z@ @5N@ B V j @j @6 u
@ D T OiOiOiPGiA` U@ 7b@ B "f @ 8 @ : ^ |R @% S9~@ T v U   :@y@ : AiN v@ښ @,;s@ ^ t  @ئ
<@ , < V b@lpt x@~ @=@ p  Κ @.>o@ j   ? :J@ ` r Eiո @&@ @    AT@ < T l U@ 5@B@ U> b  @5΀"C @ x   DTz@ d   SE@@ n  M 
F@@ t 5  G~@ p   HT@@ f   SI @ P p  @Aiܚ @J @ D r  @ @Ԫ @䪀 @K@   0 F r@ Mi@Ai΄Ei܀Oix L@AL @ Z |  @IiȘAi"M@ r   @N@@ h  ʚ @BO @   2Pm@   .Q@w@   "R@@   S@   T@ v   @)U@ L x CU@ 1@Ai2(V@ %P p EizOiKiDOiGi ֤@Ei AW@  4 F j@~ @(X @ j t  @̀Y @ , D `J @A 5@Z @ Ub   @5[@ UZ n  @΀ 즀\@Y@ D X | @j @]@˪@ * P x j@Ȁ ^@٪@ J l  j@ހ_ @ p   &@`@ V  Ҏ @ހ a @ " 4 P l@~ @ր b@ 6 J ^ x@ OiOiOiAU @Sc@@ @ T T"v M@d@@ 8 Z z @% @Qe@@  B d Ur @j f@ 4 R t J@Ҹ@M΀g @ 6 UF ^ h@pQtA Ai@|U @h@ n   @i@    @ j@@ V h@Ҁ @*kT@    Һ @l9@ , @ d @j m @ V v  @n@@ l   @o@@   ʚ @&p	@ j   q@    @r '@ j *  @ҙ 
s@ 2 T t @ @̪ @j  tR@  Ai. 4@UJ\| @%Ұ ҉ƀ @Oi u @ B dJ  @IҼ@i؀A v F@ < V p @ @&w@@   0x@   .y0@   6z@   @{5@  |?@    }@ > \* r @AC @~w@ AB2 t@EȀiK1DiG !@ JA& 0 i6 Z ^@pT @ҀS@=@ T  U @ڀS@^@ : L Ux @M l@ 8 UX n @5 $ e@ iL l @ @3@ , 8 F f@|j @
 h@ > N l x@~ ؚ@ @ f   @Vi( @ n @Ҁ6@ i v@ @ҀiT@r@ 0 N d U|@ 5@t@ : P f iiiiGAT @5؀  }@ , H "d@ @I@ B id % ƚ@@ 8 X h@Ti M@y@ B UT f v@դ @ U@   i6@:A> iB\p @ܦu@ d j  @n@ H t  j@ʀ S@ , N ` j@r@ R \ j x@ T@i @S@@ l  5 @@ Uh   @M@@ r ՞  @"T@ d   M@@ j ՘  @6TJ@ |   M@ @ Z Uv  @վ @Tu@ P@ d p % k~@iiH @i AҶU @ii@A(E0i@ PT@Ax @ @ 0 AH f@ʚ @@ @ `  @ƚ@ b   @,@    @ |    M@ tj    @ b   ܚ@ @ TJ |  Ii e@Ii@ X Ef@OiKґDOiGҰAiR@̀Ei@S@ " B U\ @M *@@ n U  @؀S @ 6 P Ut @ 8 X n @@ V d ~ @ޚ .@ v   @j Y@ F l  @  @ 4 d  @@@ T x  @Ҁ6@   & @ j U @5 @@ U> N n @դ T @ R r  5@@ UT z  @ҀOiOiOiGA@ @ ^ x @@@ H f  @@@ V |  @֚@ N h   @  C@ \ t j @T@  0 L h@U @5 @a@ S$   "@U:T @MԀ@ d Մ  @:@ t  A2@ڀE@@ UJ ^  @M$@@ t U  @5 @@ U. D \ @5@ x   T @ J x  5@, @ Մ   T @ p   M@
Ā@ ` Ն  @.T @ v   M@  @ R  AҐ@j @,@@ x   @ ֪@ހ @@@ & . 6 F@j @TA L @E MiC > Z @j ʋU> h@5 @@ UT x  @èAi( ƪ@    "@@   @ @[@    π@ zj   @ d   j@܀T@ CT f @Eҁ2 ҇ OiFDOiGib@ T@Ai @5Ҁ@ UF f  @5̀ @ UV ` x @ծ TL@ F Z v @p @@@ ^   @ ~@ b z*  @Ai5 @ @ UF j  @iʀAi  (T@ Ai8 > h@@ @ b  j @٪@ Z t  ֦@@@ T j Ai @@@ , H Z |@ޚ @ @ \   @@ h |  OiOiOiGi @Ȁ @ 4 J t @Қ @ B T ~ @ @ A%UH l @U Sc@ : P Uv @ĀS 䀭@ H ` U~ @S@@ * 6 UL V@^hUp t@x՞ @TI@ ^   M@@@ x   @2 Ei  N@ U` r  @M.1@ x Ն  @\Ԁa @T@@ $ 6 b Ր@T @ x   S @ \  5 @ D@ Uf   @M&@@ ~ 5  @U@ ^   T @ \   M@@@ L x Ai@j @J@ AiN Ai`@tAi~ @EiR  JAiƀЁ @S@@ > J *Z r@zEi@Oi6 Κ@@U@ R  A@؀M@@ \ U~  @S
@ L j  @A[@ n  Ҧ   @ d j  @$ ɪ@    @ t  ښ @@ \ ~  @4AC @ > V AA2in"A@EibJDiGi 4 F ANdn x@ @ @ H b  @@ D ^ p @  ]@ . @T f@ռ @W]D@ b l U~ @} ]*@ U6 D J X@U^ @ T@@ D V x U@ @]U8@ b   M@@@ @ U\ | @΀_]<@ b    @
]@ , L d |@ @@ @ \ v @ @	]"@ , iiiGAT6Rl U@ @"$
]F@ \   @ĀO] @ %B Z@j @ƀ @]@ , < R r@ @

 @ 8 R d @ @ ]@ ( 4 B J@PT^ t@ ]:@ f j  @*@ d v  @EW]0@ ` n 5 @@ @ UZ   @U @S@@ $ 0 UD h@M   @ J Ur  @؀S&@ T ~ զ @ T 9@ |   M@,@5@  5  
 +@ Ր   T@    @ @ A> T j@x @J 7@  $ , 4@<DN X@bl @ @F<@ M%28 EH
i\ p@~ @ҀQ$@ A0 \ U@ S @1@ l  5 @B@ 5h  N@b@M8 E@  M >!@P@  S " T@ ~  S# U@   S$@8@   S%@I@ f  5 @&X@ Mt  hn@hhh iAi2U @bE@OiK"'CTOiGJ@lv @ˠ @̀(@@ H l j @)]@    ަ@*b@ \ r  @Āܦ+@g@ > d  @΀,@Z@ x   @ -h@ @ f | @@".@b@ d   @&/@I@ : n  @0@i@ : f  @R1@L@ V  5 @,2 K@ 5  3T@ 2 < P@dz @ @R4{@ Z | ՞ @ 5Tl@ < `  ը@̀6  W@ OiOiOiGA,@Jf| @2 @"7@ Ul   @M 8 k@ p զ  @9Ta@ R z @5 :@i@ M, J d@U @M;f@ > UX ~ @Ā @ <T@@ 2 8 @ UD@HVz 5@܀=t@ UP   @S$>@@   M ? @ j  EҼ@ q@ \  Ԧ A@ b n ~ @ @@B+@ J j  @C:@ |   D @ x  Ԧ E @ j j  @*F@    G@ j  ʦ H z@ t   I@@ d   @ UJCi $ F Uf@~ M@K  U0 8 B@LUV` h@rU| @U @SL@ > J *MX  pEҩ@MҖ4 Ai؀M@ Z   ƚN S@ ~   @榀O@@ @ Z t @0P@   Q@  ̦ R@@ ~   0S @   "T@   U@ D Z | @ʀ CVT@@ R d  Tҁ2 @ WGi OiKi.DOiGiF@dnJz @AM Z@݀M X@@ H Uz  @ހSY@ R \ Uz @M Z @ B UV v @պ @[T@ \   @Ҁ\T@ L d  U@Ҁ M@] @ J Uf ~ @ƀ5 ^@@ UN Z ` @5_@ U8 b  @5Ȁ`@@ UP   @S8a@@   M bo@ 2 UD T h@|U @5 c@@ U@ \ x @հ dT@@ N n  @ȀOiOiOiAe@@ R p  @Ȁf@@ P v  @ހg@ l   ؀hT@ > T t U @jAi "iǪ@ J d  @Ā j@ l   @j @$@_ @k@ n   @
l @ `  Φ m@ J p* ~њ@5@"n@ p   oT@ j x  U@ @pT @ N v  M@q @ \ Վ  @rT@ p   S s $@ ^  5 @t@@ Հ   uT@ n   Sv @ r  M w #@ Z ~  @j( @x @ H l xh@ @Ājʪ@Ѐ @y @  & J `@/M| MiI@AiEiM6@jL@z @ `   @ښ {A@ P b  @j |~@ P j  &w@o}%@   .~0@   B I@ ʦ @  ަ   @   . @  j  @J@ X v C@լ 
TCi2< H \@Ei@OiҮDOi oMU    &@U8P` @՘ T@%@ J j  U@ S@@ ( 2 UH \@|@ڀ@M@ L h  @ZMj @ 1@ B V t &Q@Ҋ @պ Ԁ@@ J d \L@@lX 5@ t@ UR   @S@U@ x  5 @V@ Ud   @B`_4 @ R b@x @j @C U( @ X p@U @ h@ Ax	b@4  OiOiOiAHA Z@x @j "U2 V t @ U   @g@ %L h |@Z 
 8 J Z @ip @Ȁ &@@ D T ` ~@M j@@M:@ t<MxgM@4P ~@j @ª@ X   &@y@ > AiQj @Ҩ @5 @ Ut   @ހ T@ , : N UT@dr 5@ހ @ UJ j  @5̀ |@ U\   @S@ R | Ք @@ @ n  AԦ@ x@  j  @&@@ n   T@ @S @ H d p J @s}⪀ @J @ M@ ~@   K@ M<AiX f$Mi.@Ai|5 @ @u@ F Z t@ʀA@T@ B `  U@ S@ r  M $@  M @ x 5  " @ 5  @ v    T@ v   @ @ CX j z@A ҁ2@ Ei. OiKiPDOiUp~ @@ P@Ҟ @䦀@ H j  @t@ H ^@    @蚀@ L d  @Ě @ V   @֚@ l ~  @j @@ : H d t@ @@ > L R v@ʚ @@ V x  @䦀@ F v  @,)@ |  U@ M@  @ * U< H f@U @S@@ > \ U @ԀS@ J V f OiOiOiAr @j @ ZR@ Z "| @ն T @ J l  % I@ J  ^ U  @A@ l z  @ؚ @ " ^ x @ @I@@  Ai U@"@^ ՞@T@ l   S@j@ ^ p  Ā 
@ 6 ` t @ڀ @ z   @ҀF À@ 62 UB X@|5 @@ Up   @S( @   M @@ | 5  @ U\   @S" @   M ( @ v 5  &ʀ@ Ud   @ 
f@@ H h v @ Ք @ @΀޾ tM {@  * D `@~T Mi@EìL@AR"@ n   @!M&@ @  0 P p @ @@ P z  @Ѐ@ Z  j @  @ l   @ @ T z  @ J@ d   @ @ CUd r @D |ҁ2(VM% @ Oi"Oi>@*@@V n@AiUt @ռ @"T@ t   M@
@@ X Uj | @5 ؀?@ U& @ x @p @@%@ F b v @Ț @&ڀ@ Z h  @j ۀ@ > R n @ @܀(@  B h v@j @" S@    @ ހ@ H x  @ @ : D L Z@fr @ @Ѐ  A@ 4 F X j@ @ʀ  :@ Oi@OiOiA,@UD^| @ծ "> f  j@ڀJ@ j  %@iրA% %0 T %t@ @@ R f ~ @j @ 1@ T r  @ Ȫ@΀ @@@ d ~  @ UC2 j  M@@M@ > Uf x @5 S@ U> l  @M"@ J UX h |@U @Ԁ5 B_@ M΀ @b@  A $4@   [@ X   @QC@ l  M@y@ v T@ƀS, r@   M "@  U  @5:@ d@ P v ҄@ @ƪ @ު @
@R@  * F `@~R Mi@IȀMie @ @ h   j@Ҁ
Ī@ J p  @ "@ f  j @@ r   @&@@ ~   @m@ ^@    @`@ j  Ě @@ @ ^ v @TC @l@ 4 2R* X@pOiҼDOi5 @ @@ ( $PnPm/ /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 < P Ap
P
0
 
@uG   PHK PWX @_` Pgh 	`opwx
  >	 0 U7 8?       @R   >   ׄP(Z0 0@P`p @@1fSfgfe_f[  Q	fY!PVfЀ!fXPSQR Js# h2fP u	fX#  h CKZY[Xgf&0/  a$f t
fwP
 =~p

u
f  ?
 fvD 4 zDfÿ
+u.fPSVfWf!~Dg&D= $ <vD# D| u:tY)f_^2Ő
DaD f%f
PI f5d
 `ݐ	\
ad
RfUQ}NtFE)} fP4(  t4E;Ir4E&_fX
Yf]ZT35t6g&T fq"6xSRGfP  , t_t? Q>D B ATkf"Q3fY tdsuP/tvvAs@f7fKq tQO#Q;BBSi"$|>J-fF;f=f AtsfAffXZ6}QVfq@t/QAN_<f31pFtBC餿  A?  @5u
XuAy unfT sy_>p fX
8 nr:;ǅaTv 1S Qx<t< 0*YCBn
C,0 _d> ud:u	d:uu
uXQRVW'f1ht> 333
3
2 atfY~sB!݋ދ3_^ZY
j0@	C	zA	@
u@
u2TQV3bbP0 :_t ffKfbXg&狄h $g&t$fffb%q%/
AX_ +brg&}u'{bA b bA^T_C&f% f
 SsA^[0f=@-HD@-u<+c'4mfAM  } Kb#]ia f!d iiS!5fsbQh ^R:轰4Rf
. ' Aff
/* U<AHU(Vw4dRb@7frf{3f;`fG|
dTCp|s h=*( Q +( i7Ru_W߁f|fQݳAt@`tXf3f+p| tfP9Ltfr fmYS+dNM t+fROo/i2TtTfQtU$A&rQ|a f~f~f9Dufшf\ tt]@ 
'>; 
&"S#Kf$"yB z3s _7~ScP@%fd`;[vd
fG~_ _O5L52lf!uΰtu@~_fYEP@}>
O`i_9f,ѐҐ ws#< ?9pw f_{'7f;K#h<_gRkQ>Y&?9G$
u	?9"/Vݸk#tt t ] _7dPSS2"c+t?2 Sey>`1A :1dX͸ҺdE b `XXE@rQRBB% 	1; ;q@ѨP| BAPr%tct 5 Gsp' YІX/fbg!TرPxfa詡C|sui[1=ș dɁ#}ZZY<3"$Z  Tb o SP    9LρDDfof4p foft ( 0yvy_,e@zoc|>_$LVybwb 7:^P RfW@vs<vЪU@#fP0fof wfGfsbf]X@E'us]ZYnU1n$a.f3f;Wt! \ ~XgfqEr>fù1gf{ 
gf)Cpk{ "]k@{DAPfK
`*.	u]w7
8gfe!5>5-q#s,zV  626 ^BQPh.. f@;ou 0|%`f.` ?X  1{bѧSpA /q10*0 op%%` ppԯ󩰀A	*				 
	 
	 
	
	P`I@ fWQ[fǀAYf_fq`.9D=-9J.D$>#9%
ĈDX9/r% >-9tfab|oaZ!/Es"/$*.`9rMd}@#r;!`́|= USBSug&׀|=6 t}

 -q
`VP9`W h9Nα	 p ar@r  2`j̿z
i
r{``z.3Rീ><9t r(It@QfF zfYi=om "3f5fgf^Qw? fCrꝡ.f+PH e`DfXO#B#pI#ܡB `
/#(ksAW6.("CC)g&D=# 11W?4#-ـT2uooZΟ=Z
2(y
_7
_=%2tT==S$`E1\@ Q F4s@RP2{ . h >u_ g` T=
XS(fT= &݈ v n
un ؍tB`ȴ	a8 >8989 f+` fǱi^Vu69 99 +.4f.64CWK:0fIr!rO9 UAC.B//',=*?QfPfazXPgfufXYrmv e:pQ
^>G:/
sl`oCDBD?e@S'l=3;8t t9t
9D `/ƈDcI=t pr
rY, y%tF}t=~T= t2:t+@/:ugȯ}Q(u~a*jrtBd@=@t=t=`	t= h?ϟTB+6`oaԾ`98dtd&/	/h98DtD$j/S`8wtp 0 /[M૑@pv   	`@  %K}!+9,9&    !# )!uYP  ~ :OO~P@N;;ECEC4j5z66;; UWRQSPVrwa;t ur6ffWRfP0e Xh,fZf_ Eup9_aPSƀ pru2!9%@#9&99/aI4'(9W6*)9Z[XF f cs` t3  ^X[YZ_]e È<[?90Q pU_>`\_ j0fdX!u!=9! ȃ uddfd  >P6pۡSd d?dP 剱(=9>9_fUn}:f]P:t,>@u%ttt t	tfN TtF r@u`a;js
 1QK6uF .f$N
SfQVێeS trـ?{D`*f xofpxT ff/fXs "qy#uptLeb{` y߀uYf3ffe89-fWpe*&898fw*fF*2t*e&99^fY[1j0_8'Q 8 c$@פ[R0W  ĀuL̽Gv9eK  \VK|$YSQVWU&_ _ i]_^Y[LS-120ZIP 25?0PSQRV:1:+2:,+2PKp
˼#w
 z
5	 9#s!h)e[{rgRc<tV< uWQ={fqQ @u:uFfG_(RX!X   JAZY0_f`_u 29Q_+9%9,9&9Ǣ90 xRW/li} tE/l_Z[M-Sys   DiskOnKey 1 #a4B_ u @  f<x fP 0 R?" 2r@0w1s s~Ђ ~ !f@fPuL	sTt6Xr)g&	ug&Qpg&oC,f_߸ PAـ rLTf<Q'R(RVPeF5qome}
ǌ;p t0h0jDt{@ u u#P-30MAf?LfHPN N 
1fXuײU?D0 @06B0B0*B0)B0G05F6F 	  3FPRo3W1>#>;!2>
d?_Y<h7ԢPh`p& 4  hw*< ZPW+ 1s!$?
u$˄[0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSV      Z *8۝6ܿT!
  * 	"_.>  
 Z DDo      cSFC2D&DQr! ru
>D? t ,  > X tDDD>DDuݧրPS< tCrD!~DDDDgՓQ	`=P `
3ۊ؀`QD&.EUDw/E3PDpVS~_@t	[Q_[^fPQVDzMD@ _.fu?uqoS1I_ Dti_h޿QL[^YfQVfU>__S>5E>_&2Eat(
ߠ}Dpg&`DAD[f]0t>DD r11Dw%0r79 "_?;݈0r믻D   [h;b}PdXpЁ)E 5`=]Q	胢pt11Dh[4E$r4E&_D5Edfp ߻Df3{Y[fRDff3 ׉0
Ef@`F E *  P<Fu3E3t	 Dt<Hut2HtH >Ȁ$utPaX]0E a:-E uB<Ft<Tt<et<t<t<Rw*<Ir&3E
2@&tH>2E`H4<qurYVWp HtAQ qft(PǴ:1EOu 
  gXfCY/qq jq9~ w21EkY0ED`&/E8rnG-E>taRw>
$_^tvD3ED2xDf? t<CpR<tSQLذ&Y[ٰu
l  ef l2ggh
0iP @jS\
 ? @  Ps ` pr		
			 
	 
	 
		PP@ I@ Q foWQfPQ7Yf_@f D5 869H9sU(8{f`LD$&8
Ĉ?D PLJs fA	?g&|5 @urr`{r  a`KzLa	e	_AKV	u	`%LfPHf%p$ffDfX\8
܉ L{sP 5L5Lf`tCg&Pp ul=B`ԅr`B>8t t9t
9wD
ƈD\0fpJ ~X9fW3		#3r|`D=!W_Ԡb
D @ $4Oq޴Z(f
T= &Pr\2ցpu.?rDQfPpq?.8Of.64O gffZf,fXYf\rvp+)
 
y*/
0/
 
		D	Or 
/
"
#6ݹ H	/	s` =sJe|=td h2le t*T=:u2?@B(uqa&rg=@t=t=`	t=`,?960oǝfa!&L	ūL$ ""uLPP ` L0   0klSBd@bd    D  o` @h 00S 3`Qo  
A& sa %  	'%
0`j#
 9ةcl
q 
3`@Aw& <q`. @t@ 
 b
	 |F
?  "  d q 	A?  % %@%Q
 +3F	

 + (PE+
3$ 4̂ C8$ +(3+-E-( C -0294 - (`(E E3  .c+! 0
 @ /9F. 7'GC@<6A6D
!:7'  "J",A!E?9B@,3
O<bJ# 
 S<R"G 3D%M TVaX aA8@8'(XAIc  WI @@ f  gf    P h5_gUg?f h,6$l H hvhl fWp0t&fPfW
f$ff=`uf_fX_fa1zqtfPQ9`/.ɉ///+f0۠b@ ɱz?2Zgg`b Q PQfWfV$UUf* U hy<F  ۊ'PG3 .;Yt3f^f_YXgh ݟPRVp8u`*h
/uh|6%!? hV^ZX2

 
._2X.f`QYr;f.;[t3Uuf[#{fpf frSCgf= v	 +v: f3[f́@  f[fP ˠ 6[Ã tL;   ǰ;Ptƿ[ !.[fR AA
?Zf!)u0`b h0+*( Q +( ÑMar99p	 VfBHfffROMIfMAGEP;uq WtgLNf3KPQ߹J 23fG`ZYXuPwag&GIG ШQ2hLt"Ot!P  t}	V   Vu'f t!awp @ 
G9=4 BGp?Gf fCf,?9Њr8fBR
D;  @E1"qo, b t Vc.Vb`cep~
>t1hak  	s!$      [",;  PfSQRVQ@ D  __ Y_cwVG˰ __[q<pX fz_`A> !	u*bbbb>bi`6bp` -Πg1	a_P!R	g Ā>~_ T3  cU
uF V
Wu_ ˷煺   o鮃!uP&C PuxtVt	uT~R_d:u<y u2d> u	a (!ubufz_fdbd= I^ZYfg&8Qu	?g&PDtF@sPVS 9_Cû h2o{՗[^XSRV1_Ws^_+;»A$s11Z@XPfU!f~`((˰x1ְ6]f@kr0 #3# U 56j8 Pbbbbbbwbp{SV.&t{b-^Q P7W>bbSRȰWu<v
b,ƽb@bʀ 7q_G#B`8r )` b E:S	A}1@8b":bw/bl
/(	c t
	+brg&JAEtb}rbdr!H"bKr
? Jth)	vc_ZЪtĳbB=2o8'13
	R	u_`CI@V$ࢿ_TXp Z#,[$$_;;AR ZZeR J[ \ ~]eP&abpZ&@&F]da< u}12R1RgtXwr),u)RG`SQr9R'$8t3Y[;tr$VOHAr(<Fr(!sq轳trp@ppq.Y Y0 NSfQfW
BfUgg& suf3_Ɋf  vt fY[`RVfW~Ӧg<t,fUgR rQ8tfG@^fZPQ$@Gّ@8tἀыUvPPhF X PS&=hp ;h؎[XPS=hga@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               PQ ֎tu
YXP@ ĝ` u 
Xf`<؎ Rf쨀u Zlfa4n   @(00	lf&Ef  pDp   &Et"D  $D( s `ف&tȀɿ 4>2@"۰Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m 
 Gm p-'s 0a` aװr * $OQa	 & aSQf# $$<@t"h<fP u	fX#  h KuKfZY[Kuף`.> st&3r	&*r,)|85ovaô`prr X ? trC0}q;w1#!8Q909$賜a0){fRQS8[YfZt'1 t tu
| t(ar0
RADȁmG>  &pfp    h4tru f>觯rfff0Gf  %f  fr<fffHff#f+ִ f;wfgf&3g&Sg&c
uff+f뺀p
 >F                     Z ` $  H

ɀ$ t

T Gm
f$ u BKnERP10@B u$Z DfQWP 
a'Xgg_fFf`|Q
`fgPkfQRfWPSf3f3ɿf <  P tf; X tDt[Xf_ZfYù@ fPffffX,fVfVf   E gf^! Wf^	V		)			:		/	^		f	W	~	fWf	_
g&'] >@;f_fPSQWV! J tO y#k"">A$"h߯FcT
Q 9sY,^_Y[fX^ auDo

f#f!V2UE p   p 4PhEbSh ?Q o 8O3f 	g&G4g&tCfЎfft.fAfPA<(  u1
U Q R h+
  a  !__h9
a@$#43efP(CdqP%RfՁ Z=
ai2CЙt_ 7hsu!p?%fRh+>f;#QfW 
$eOf t GAIf	  00')' %+ѩ<pdB.&;	e1*  t'.o;	)ep 
.t5
)@.`tB.a3S;&[C vS3ۀ> tt&t:&tC pڮt<w>t8t譀: 
 ?añ 06S @ 菮t, NT &,&6&&1&p\t r[""5 fP	RAE&rA aխ	 fXTPt/3蹸趸軳P	4@ޭt1-w؟㋇c .trwRat0
Rw&P< t
:@ 0k  O&P>@ugktY&aÉ  H

pI}߷ Jp@M@P;42ؾ
s3y@si  Y 11F0aM:u;pu;th@P`P \! X5?Qjqkpww
210r 1	&a

v+ >222fRVh0j?{DtDh$h[lsh0]tr2i f^fZ?f`2 7{rbo <`t[gT\
hMffPf`PVPf3a//8qXp!7"" Ϭh륿t{Qf`/)
4/O
z "	 	 &"	/	(	&!_!!!p!h5԰ÓhLw
6F,vpf
QzBsσu`ԭ _2fÂRКt F<tv$rf9אZ/tQVW߀%@& _^Y}TfzDfQ1 fot
t/%SϠ/ygf$Q?1ח  Pp^ WSQRWVhU?r=ыt
 t
uu	 }°t uʋ?^_ZY`	į&:Eb3:EF c6W p 2:> u6 GHt\o hV/T3Ҭ؋hB^_fj
XK̈́
>
2
F
VT>T2E@uOHp
Nt.
Or,򍒎PV,a,V/ ,PC\`o/ / /  
OV,{<RwS2.8[Аkø 3 +аkd?fQh_4ufYbÑaEf3ɋP 范`qX&G     &Wf&{t ffBf;Pg&Gf>ww~rtwRtpff@'hp3QgfY tgho&AX0Y[0U>aPS 2hWh`2f[ .t7> u踹߿ $>p u0׹` Ъb_+!ҟtӞ2#辟tP rs `t蛝 Ks>Pp 2duqQ>_SxmYhP`Fu9 5̢r/<t+t&u
$&蝹.豸a@prݞt"tq2t pg&G Q !pv趜uTIu߀U>N`v&!!X 
#.LMOQTYhzBDGLQYmLOQV[`zLMNPRVcmGKOV^fk8:=BGL_rfr _:à@ PP  ȸXPR@Zbk}f 2`Rў 0flˡfmapXqpXFW@f
 f(q }_:3 2 05 &22
1Ȑ+Ü02 
8s 觜`/ 
t V$<
v
ط   tǀ>* t $
=ؐ h?w$@ u
d t㋷؊ wT^іhk%

p8d[		
s	 
BOu *&+
@ *+>+ u
8w2 JD &`6x ѰG@f`f Df HfCLfPfGpU`:8$@@@@pPPh >f;t	@p?f% @z @r<t<t<!vPS$<w㰿 .q!¯ڠƙ   t 6G	 N  DPĳ
P >	XuARB*D-m	bzphS! u] 6 [2P 2X	
@	2oP{20ˀa	$

Àu<X[X qax؀a
2t nP@<KrKpSI0௢"0I2."y JBZ s  ""
ZP3X?#?# Jq vJúBQ R (TPBX
	ذ4ߨ ZQQSW(,}_[fY߀e~;  h_ M (Pz;p&QW<u
y{ :{ wO_Y*z :v|"b~]ðh1敗тvHװ谻s$%&'
u     {`a
%$% 3a`
_%$aGapup*;s"D
?~U,#
! ԃ #
`DC&%    K% (3( " j+'U,&,q+ &3ۻ! U,% m&w&&&&}+a&` 7&D &% 0.&,w&0y>0y&&2s 2yyc[xUV<20x2 Pظ $H /vW[.uu>9u^]uu2 	?sຢ tiu%thup<r7߰, 
謭'|0iC`c@u~`
 
bn'~-q,p X땞WРo(S rCn.Y(Ӡb욳ro俁.t 賳PrIu_ IIu؁d`KOՑh2 
03!47+t
3NO+t3GNOpUN)	))N)쪺xP =R)SR)`Ŭ`y#0j
ehhS_h ?Q o P"uuu&ߚgq Op  _[f. f U ff.q n V r@5xb X?puP`y\ hp*.l*ʠhFOP2zXΑhVhhfUvP*F X PSq&*&*&*[XPSb***(x$(H&p+&p+p+J$m]T`0tZ0o0 褊Pa q_U iXͰS8rddrQS<drp
d2t*	/VpP,>0B &p pZ[                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         !$SMM MODULE -- COMPAQVERSION: 1.0        ,                    
 @ D X \ ` p x |                 !  L Th ltg/    @    $ ( , 0 U<<DI"  $(,0DHL?TX oool 
P@#H P` d A+o)Р( 0
&C'(@
!H@P@@<@  "ZB 0 `{ @   PV  $o                                            `JdJ - ` `P1  ` ` ` ` ` 	@SS 
!
}p Q1J0K @R@XF2pHBTRDUPUPAP%&*+P,89:P;<=?P@EGHPINOQPTZ[_Pbc ePfghiPjklmPnopqPrsuvPw}~ tP    @  01467 `
 	
p                            i 0py{107p77708p888	09
p999
0:p::P:X0;Yp;h;i;j0<kp<l<m*<n0=op=w=wjtF9@ V=  @U @U 0@U123 4@5U
@   ! " #@pC                                 NNO Oh<fP u	fX#  h ?誇hPqXfPfSfQfRVfWfU f Q - !Q  A!!ȑff*2fW 0@MMf3f3f.ff: ZP fuf]f_^fZfYf[ff"Q ء f( MMՊ
f:700%#|ȀAf`v;
P3XPSVWfQs: ؾي t
u ufufpv @uf  fY_^[XQVf` fpf`LQSf^f_Y@ f~g& R'hQ"$hD%C2Vf] @ mRf^f@ʈݍ2  S@ 艕 bb gО( )3*(5 p𠪂  ۚσ ϰg n h Qk  &;t/ S+ 5mL	,U  7NeS                   %X%Q                                                                                   <  +U* 0x `  `z  `TQХP3f3ۻ~f_fg!)Af" {0Pgf+ /`h?afUf&af&>"` 6a  !}"X[ "&"SP7`Ƴ /aV&"&"2p
f3f>gf ֓aƹh   W@p h &<ïyf`fff_Vf@  Uv  ~@ff>0p
r0zpffXffff0V 0 Ʀ  2!q f"eP Փ Q  &ޡp  A` e_faw
pa  6!>Be*{Dp F .HP2"` e" ݸۓ#	
e֓J fe&` b "j0e"ffefAffgd:Kugdfepf3 gCT 1 CfF3ۊd@e3 >MJ
tdJ	v  D @ 
NpeOuxPwu._RTC Q#u:/
'
%&bfgfd. Sݺ` @>[WP9߃`XP&EX% &E_YOǨ ooooǸoc4/IXo~֠;'Lf[`PHIa  6&pP&0`X v
``ѿ.0Sr&&pfaõr!Br  Pq X
䏀  Pf h)3>\ ƌXga20u쨀t	<u <u õr$Rr p&&0F2qrrߠ]rN a`zw7da(SvxБQ`es"" QYoaEcP  r&&` Ob 
yV' P"S""}F"&&a bR ~ ZQRr3'H2't2ZY`2$t"5 ttTZY{a~r#uS-ER-Y03!pٸ q4 AY f & &EZP 2 &r豂r8t32~.BO hu?,.tGS؀1?e6h%8[&M.2tJ$;0K#h ǿ5 ƿW< t -Ƌ4fRh2h[Sh ?Q o h0]<fZrj  pvw@5 pS
}, #!	A	2hF
%00`P 0S%-  Da`6(    pM aV魆ī^`W  3 _r- `+˸ nfDE/D`b;Հ B.@<B O B<`<2rru{O0W2&*G_YS	 7&*,u&}Zu&E_[ÚDAP`QFگ>  0 2ۃ¿<OtY	B<tmHٌ¡7[77rPBBLѯ: r1 r,q h/$d0SQk
pqlat)u$<Pt+fKuҴhQpB`UY[Qn @qj"yjuBAuYoofg0P	VPWo^W mQfR h0j?tD=F==rN|UtGVRѾ4^t1V?h_5f^Df`CXMf`ffSIMWuUf froff1f;w(hņaffap pp 0f&?SECUtûfuffQR hP?I7g&XfGذV 
u<f%X!u(Ag&_-y$80ܱ	PN,#Gt<S=
 NT,TV&VYtV
twTTSрhO RL0p=ʒ%= 	 =
=uf@$)/èmè@  ثïЯ!ffw	7 Z"n& t
fWf&f_r2%ef$g&׋0 fg&	R Sf`?`u ze fGtt2t~tyf@4  4!4.,005 1 twf@P8@ 1~^u0fJ rFf_;r>: t, f    ur%)rQY9	 f_fZfYf[d   t% 
t`A
A!:0.-r&%"

wTr'SWV!rP#  t
ff;tw;0
 + t_ D@@DQ^0Q@vpK[[[rww	K u ff!` B
fffLp t


gh\GhNRS
Za3 G"t_3 v'{%Khq
Gw  V16p}1ށ2:u"FPV()pD1' E-f&7@ w.	AE_S 
{fUfp>t	~0~--


f+n
B#f]^"P)""7~ׂ g oXvI? An@u@uf1r ހ%  
?h_#_#_#pMnnrp  Dq& ; Z x     0Nm@  $
Pdu	q 2pXÃ&p	 ] H,zȃIzذJz2ȉa,' wSQR܌c.ta>=a  %0/:$tB2 ;0hOh~urEd/(#/J!-*&$R++fPSf>QPH_u(Dr#w @  'p[fX-rU(Qp% -ro#sVfW0f>fX1|mp g灦@ݼ f  
 ?fހwf!и2g&g
fKffRܐ& grph|q5мVhZ,
-5hfP r  s fbXPSfRj07W6uLs;wEf6f28 r/gf@bBfUۋrp0  Z[Xm΀u
  酐>P PÀf_fP? t]ǀ t
  @  ?`c :N  @)@  [ p; n6fSrv`gGwf3ׁ `rːfz fPr:>sбz^fo;w!fVg&f_^ufFta!Qy@ߊ$@ftaQg&@90@<&ǁ=f=ATADtlf q:&S`p s  US3a  gtb _t1 {E ߨ0!t3Ɋ0Gj q'tUFWP
 XUu&.>;   ub >u `	`	{~s{tp$l0sesޒ$os?C_ARI 	


 @`YQW3( [t1fd f跸HbBC_YaZ.fUf.6f]f]aeaa** End SetActiveDisplays: \ 0	R$Tt5< ux )ڊ 8t  u
8ud a9 LQSe[00tů@uYFQ2t7P  q@@ Q# @S <uȸ
  uRQ 	
30p  D q t1
S
L_
   P ]e\R	X9 SRhPThP %p`hh؀ hXhXhpNPSRW薣kha\j``b tQthP _l@hYHQRPS [X"3t z  
\Um  Hp@P`@6
u&cr
u02,RW_Zr&&&E&]ж  faP$<???M=E>P;. fWU]WPAXð PR Z} .a;tH rXtǰ @ AWpt,` ;|WC_a] Qf!fB $~fWP L`XubrpC f_`uQ`Mt'f ITAfgf@ZP 
 2gתaYld0  `tXlW
Hpc=&M_0g.g͵ @t0;r+gCC颴 PsKGPhF0BvaArJP!uutQ Py @f pԊ6`Ȏt @.d  w >`QOa8tY*_O# Qj<.uO? R%lKd
1
f$Dt_? 8 Atu p\u3鈰u#Q?G`
u"?QhVն9u
3^uC*ulr'p _ruatg&ON  g1OCk0`uIգ>l  ಇ()S+`Nr1cP]0`PQ> c r\d`BtC>r-`w 0 r0\nҊ1 r
- u`d`Q rdItf s`QRpƁ 4iNr&r!ww3҆r r	?~aRc1@%rчQPQss
d Sr	r1V>Rдf   dgfyuwR Z }h ٓk~C Z(((d.!Q " Ypp  2  p",u  QP h)o/R

Z@uѢذ* rā`( t INQ ڿR]R  UrDC	I 4~P>qS t33J*~`R
t#4 c ttcÈ~~QRWVù+3"a^S_Z$"#`1$G<u $V{ 4^W _ 虄"  !(<tù 	
R
q0xJ
g&Ơ/ܱ1q;QM_-r;@N
r;x;q;0(XJ2`ubupcRVа$rN ;rCr<,	r32pt0rr;ws^ZW
Ph  0u
˾  uQN fQl uf2 J3322t@ ?0 	rn
$	"
uƋ߱d;sRZ3QFqF2t
2tAu	u˸
S_ø
_.}W.~.1.ы.a.6r..2YDذVPC n F$
.&   h5?L4L!'Nh/1Ofఛ@կAfXffX , ff
PfU ߫$`WhSTUu?00 akpkpӢ0c	r   D?EDF ztOK MB :b  QKȰ0 ~fu f+fMh5f}-E*0>ffR  fȰ  2f%ްf+Áf>PAMSuff>r^0wS!0pdΑϾǸ 0f|	B%4 %f`&OO`WVfqh[Sh ?Q o rY P E 6f0P < u h\hԮ-rbfXv f"Xh0]^!Aa
h30j/4t.rB @
E<uA
oP
`YEfPt0Ю G"a`1D"ЎQFr&=t&} tV" &GF^YՃ"㾘 h2Ot	 h]3
9!
"V?  hWU?_
xzISx zW( R ZRu
" Ј!6 < 3 <@2<?
 1ꀤvR                                                               UPRPRVFZX0RR3=0ZO                            x  ŵȎ0 Ѝߋh3 PSu<w%$o<w	&`˰:fPSfW> tUPuR uIP!B<t>t9u2 Xr-`ϝr!\ Ltgo&G!P _  f_[fPSQLtZgf&gqtKWr3xȻ Cs0x0s$
 O 2YPG"誇rKtt70 	
   SQVȾ9J@ 8t"8t6rK8^Y[Aet,&
uf㢱>ut
$sE 3t> uPDH"t$	&
螿s@  P
t`ہ	>!2
XVt I%QQu6tCf ƐP 1< t'$  
u0{a>
	 >߼t fGt0Ո P 'ug *r$- t> uBu
 i  (pr"1t Q`JbSQPXtV
+r0.TGsItB0tD0.3r//Y=6!It_6tP rBw3s6u%
u "786 S56cC$tzu Rطctb};sW;sQaRu	Ku u׿"
uPF"
23mR4  àآ4t 0*`N5s)P5tXSfW@0@t
Gt`D_8؊f_[Çfsg]W/  r
φU,# \    0K  	  
   _     _ KSfQRW= t&.f`Bf $$4_ZfYfW#9{Op["$ueC ff#% WuKCQ"u0 c$uCC f%uDèt+/1tz0AfnifQ^f<Zuk
?zF_rF /<E@ hhSh ?Q o fM uTfqS@,7 Ft2} -Pf
M$`cZ`_ O? U;!c$tPXX Pf3aك tv @OLPU,@}f% #x f] - f$#fA)%ffPif?bS &(ӆ tR"Z~fP`ٿٴ߻ٹ	WIqcfsܰPBwafSQRVWq
Iwv$ 
fsbf} a0
-Ȋ?2$s.t2$
_^Z3`ٿ  pHafQft'ff tArf` fYQfRfWfVfUf43f3ff!=t;180nB< Pu<>q_  td3(=}2@%?F 5?4?W	?t!ff]f^DmR(7 u3 +ãaHpcHaWAPIZ "W 5B1ZXW d h5fP P	fX#  h Gh ñѰ 0RaCZ}W  `aغ   nBnnntnJFn aÿS @À 3ێ7!C &?!Cu3ۏR .Z\ht
f;
X

Y

qJ,&;;4
q
>&跂
.pu	 Q_QWV ^Ptݦt	+t8QWP3 PhX@.X=X@uX_Y߰P4up$ q!!.$> u
PI@Xu6C @B T A3DgfOgSHu.gS:f`Ug&ff~ȋffffߋgf?ffu<(.&gfBfsDP
h!4/
1dSfRc6U t `F

(`buXO0f|TSQؠuf   f t ttNp Mp /XzRt%tg0&g!g?gof` LbRft9tg>E @ 9g5CggfRVWf),g>E %^g> !P(^d`g
ز
U.   hp~"Q2` @1Ya,/ a,4:ƃĲ!;!:a,
P+ص+
ԇ
a,a,ހa,cyQDa,5W殞gta,<	a,a,Sa,$a,Q,Q,&	 ߬a,Ƚxܯ	k_ٽFa,f.u4!u<u<yw2.R Ff&@膱@VpMb u
ff
gf 7
1SذcsDrDh[_ ` C&;xV4t? uQ_-&[ff[wD@D`p`0 ؋؎t t [60i{`" cǇa@r"f@h[ܺs	7>.h\r0fZA@fP 6fAk:qm	swdr
ah0]RyPs5G
q_h^
YIr d~ @ hgx0a"D pJfw x&t9YUP ]& 5Zqf^ Rp:_'ZQ,џa9#ݏA;"?B+:à? ,q5  f`1 prPP   .<t
.._/ NAu Nfz V)Afp[rPجP؀U.p/tA
 NUNOh1ot`^Z#֨4 e?hӣÀ> t WZ -<s!e C$h 
S
qf`faß%Pr0EsRWP $?o@R`ؿHyB8X 
_4sAxW?#+Sցրց?`
L8  %
 	 
  31 P  @u#?2h3/4th$VdE7 RfP?&T ffXh!`:)4).) ()!")") ) )aPQ  f%  f` 0	Nqݠ9$f5#6 CPt2R6_ZP 5X4Ys0hZ~3f`fD2f3f%   P00`!䡾ס
 XP!Bf`fgff%2 2fP `E  fB"a f`fPf%ff} Qt8%]624@!q'1?@tqP h2|0 t(aoG3<_|q  ٣tSh)T83u'-膂
4jcb
8?tf1)ڗfX(^#SR8"#ط$0$@MC$àgh0jDtM1"=-u6r!|0hzHZ"RQR>19b6H3E4 n @|:q-u= ac9
} t995<--t )࿾'67u50Mb8cF!uB
S84tS8T T8Y{F,Sh\ fg&hW@m  	W8~PRE8ttt
u8S>8û  h5ܟTe ph
6o
g_  @ $ &   @C ހ@	  
!     0@?12 03 45 6 7 8  x%7?)S("$4R%%5(,dd)?8N	29D+`Qz ti  {&PhRu <w  
`g{ q} Q   J-Et qu0TfxfX-f-f0w ."   ` 
a""f` ح#  "13$Ҕт7fI^bI`G5 0[f PfRSpfa0>6tm  ?= uw@.= u=  O2
gQ;䨑p3f 9tP3e(BRᡑ qÉS*Of#s?rÀ0 A`#PfshKlXp  P&:X`ï9                                                          0    U,O !aX|dQ          K   p @                                                                        x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(    @ ` d$ UNDI  L  NhPCIR$I        ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
B0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                                 E   
 UN44UH˯;    @ ` .UNDIL   ?OPCIR3        H  $PnP   i\ Z!AsusTek/ MSI/ 
Broadcom 440X Fast Ethernet Boot Agent v2.0.3 Copyright (C) 2000-P 3 Corporation19970 IntelAll s reserved.
 &
, PXE-2.1 (build 082)	MBAw	   
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 tw@q/2?q130QS0 [Y .> th  Ph2Tp  M  FP?SQfRWV	hJ$Af.>I t.;@  ځ>  U  r r h@ ۹H l 8tY[i
a-EC1: Base-code ROM ID structure was n 9found.;T0: ASF is enabl`3Q2 canl >.   YJC 
?	8Sfj j ,'>  t;sf=$BC$uErPj W떌ێ0 f&#  .6P Q   ~j Ph9&u
˃Z t9hlRMC_L Ner() ==  @<r
?hC%aEM0F: ExitingMH6^_fZY[, q . fТ 0 QuES p`f
@&6 +&p fRSfP& fQ73ffJtuہ 3fX[fZP9.6&ԋ DSfWfUj j  0RV콺&@.~6E. ...r
"@?ЉV%H96UYWoPf6UfKV  q p { t tА Ȑ:08P`d62 3BIOS extended memory cm error56:rg driver image6invalih88: !a7::">segmu<9:mNV+I u JO u5hwd+%F3 FCE)
mf#I,M +f^f.O sDhP:Jx5  AH90M4Mzr?vf&D?F&D@g UB! H`PeJR&D JV M&(DvՋAE@	///Wj 
&\ J
){;huBءL ` N b f3҃Whf[w fR}XfZN&  Yju P$8v uj@DH FW FR7vX]t!
u0Sf"G HF +F )F[fSVWFJ  6ˌ##FfTp`   f`_^f[^^f]f_f[fX2!8RtQfbk  pQQJt u RVVfp  OffP= t.. ﾭmށ.
s	N]&}t	q t+{f&}w us.Pn9wf&+?f&;Esp RfXRw *=  
 s@8r&f.K+QAP.=uf 1AA	f]3` 3 fP2  X$Bt_ s^ޠ+G3. 󫎯G3@0 ٫'G1C=N C_%=ACs
  0  {u	 'DBHAAHuHCtH\s   	 u&<Xt.;60 r %RAXrإA< uwG&DA 0G  &LmpG&ЪG G"QGH(RH*!H0PJ8UJ2J:.0A6K>EpLX:Jh1J`t ^K,rN*qrGup*. T
 &5
$:P1P ?  f[]ˣ'<fZ@ȸhP
`4t
4fX p+MW~ Qhf!_Rf8f N` f^   H g }5B;/fp0<ߌfuffk#H`2du fadð;n?(f0@{uqB6	Itf뿁fPIpZ
4	At'\ > љ	18fZL f_ fQ
Ɛ  
f
̀AD f9*PrȐRf ẁ _p tfZ A N R5%0
"  @tf<1fSp A f@ a fUY&O @82SKaRxPf
߀úff/fZPfXQ)Qfϋ
I =f;tfIuZ3ru$13.p.P #.Vo.@P 	P@@Շ.( SXf%$ v֋]52 mf?_SM_ts OvQj mS/A   ЀwrgrafG".tWO0sQ0 Yufh w Xf,g8 tIt#gfXfg f@g@tgePnPuW32&C&:]u
uB }
 t7܀Sj`&]
[ue3t7+SW ߀p$u> PuMu	>p ?Guf  `f> otf ӀpfWf@   t;hY`u07:  PCIcallsupport ~ 	uQO.;DK8Dtttnh>댥1pnRDevice!Pqp}qY	4 read!
configuration space3ff`j  wP Xu
С ?|U.~/Pۉ>_fR. .P 2/<tRh%uOp	!requires DDIMe`Ϡ6$ |h R6"P6% ?C `Č!0=pjfj1;`f hfQ `u0h
 Tb%x
I PMM funcnumbe` u&h6EҰ@"ocpC Gfxfrgfgffߋf_ \.=ڃ>I i I.H@0tt	 t5` `fdߣS f M_&u Mze h`M> Mi |՛%Et`>=aFr$. 1op2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @     i     (  vK  A U B  o
K 
- 4o5 N%ҜkJo!c-ڱF)gB1Z5{^R9wVs=	G,bC
f(j$O יnKv8ϤS<rW[0ǉ~_z4\y7X3}?ȆqTu;P#mHi'лL@e+
D/ؖaUp>Q:̓t6x]|2ŮY*ݓdA`.EIl"M&hE!W@mW & v  	U0 
& {P  /` 
U!p
o "# 
	&G		1"#\$$x'))))Z*<*J*t))+0//$?$Z/^1gC6DIX+802.3  tttttWS ˌt&  .6 !PXEX102r56ͭ#4?    sNV+,vO@ @fUfSfQfRfWfVfPFwO. ~
,2&22ێ46h@ WP
` fXf^f_fZfYf[f].>  u
  `  fv
Phm.6 j `ϸfUf	R	g]g}wer`C
f&.2؎VP
fUs
Sp
q
[f]
f0& tP 7u	@fbڃ>*2 tj Sf. ffף"2  &2. -  2f3یȒ. 3h f&  f&*2 []zj 9h uf. fh `  V@ g&5@"+g& ^R t,@
? SL_\[`1	ePfX&
=PVu NVf. -f ]ϝ% % Z 2.  pQFp0~ uP;ː  u^&-鐋Fa*5FsB{ C̃#%cQ'{뚣C{	q 1	gC-	])	S%	{I#_	?	5c
}+o! P<== w. *4>HR\fpzF~@ˡ>
9 tQ h@62X9^&G9p 9&Gwq  wQ	
9@6o
9C"u!&3 c hGa>6u31	D	8fj@1 d
4_uPK62#30F6^G#FG%F 6F`GF~sE>6 u>^*Fr)^Vt  Y OtfcGK TRt,q	 A
9 ( :`  0jK2Z^pa^V:1+/#!!t"G0RxȰP:a `bQ#G/t3+< ' uG0 t>G17
$1W

)
$qI
F- VF^	#	
+t*u! 	a
m
		#&@ 9 Pa P 6@F/9GwϜ!.p Ia!2G0
i"P"M9w!V0Pe-&  VF  	Fǳ` O@60:]nF)޲)TA^P0ڋ^wV@* usF~o'}0!6P*zt  2u?!!"!-> uF ^B|AeOfN%'F^F`kC   Kt2AC^v&F&~ ~|sTA/v@jK*1KHt
H|p
H~Hc FF^ft}vQr{4psFb `:bݸF"v:f&p &@
44p@
 ,<s@2<:1;FGG &G(*;G,fG GfG.q(?" G` 1ǋ^_#4PZ#*_%J$~3bOFCFlESK.pBIU]pC9
99[2YF99N9A9CQ9dVbh,F>v)_ވ@r(+ksO3t dd9iE;O<O?O_01OQ0zO_%O[`pO*>aOhOcO6AcU/%]uz-s~G蠺6*GS1`$s
  (rg1n@ճDp`* 0 &)遰ss`s^$&GU	 
`gVsxa$GUvsxcGG
G 	b
򒉫Gx{C
y}݋F 06 蟰/f!G`3>`#cbFTU O- p v<
  FFu !U#Ǡ  o B`t
;ҡϐlm k>p>t,i
 F0ŋ^	F^V@A""l.
R'!]谼L
 -"5(rxy  ^Zv_
*&o$PP {@@iu+iu$ jub sbF)F1tI&?1?&tr(g - @P3LğAT7> p 7 >@|y&<?F$!0WlF$*
,D Xu2Ð!P#SVp N@9u2cv@3@m@GbPX2gÐ`8OY׋@ȰqPj P3۸Y_F iV@CRZS1pt$ÜX	S[	[PA:Sf3یfff[F @]QN$     YRfSQVNfP$" [qf[f {@p   vpf+fX" " +$^Yf[VWv^~F
N~ tIfȃt_^	PQWf~N
jQY_YfX]Pؠ..v=# f"pSӊ2@t>҄F  O¢ @ .CF TF+K p 	"2C$2c&y(@gP D*PŐF ;Ft;N `,G jVQȋs0Y^< ^]A`WfP2ff
0úff``{fX@_]c_Ypef$  +
2C@@.PQR,`(;ssZY1ffâRPqKFw2^*/aNFA=Dw=Ds-t0ø1-Gr	- vHHt
AP  ` &0VjW@︜t	3 cVFׇ  33$("Āq$`	DAG	ub  ^@
!ntBBZu
E
vp0d!PS  @V˸NKpQ%qF 6 (Prp0RPV7^c@.}I@+qw?`9Pu  19@u9Pug``P
_纭"`P%@|f+f@=9Fu@*~u%  @b#!]ƋNE !t ??,  Mˠ~}+vu9P
uދ``q+cL@$Lc%рN DF+v&F0ޟ9F|#spMp]wp$tۗs 0tp z/t(tcYh6c.@PİX"["\G
"
"Ph _v@~ѵ 뷐=Ǉ&ktaGbR(#*,c.	0	{2C
4'!BS!G O&Q3p"`HG j t  uL0Ad|LQ ׇS=w6PQ?KoɁ *$"$ump +	Z ШR2EfFnFq|NA#;G3 w G"oV>1Rl	F9FuNbz @+FHO~P V_v P:2Vpw@"@P@i
S *@u#(KQH#؋v{t `cw !"F0G+0#(I#+)ؑ#1_0eh9 yG  C@bCNR;FBS <DF+F^BFF AP89F;FR`CB:>V^WVrU$"_FcHsr)Kb$ fs Jt"( r BS @u&1p U<I@]Qa!C0kE %ErBEA9AuҋpBPO*6R,1po 9D95vӀ"A    ~ ~8,)FyT(3A`C@36"z@N뉡Yr?M[@+0V;FsE+@X02FubG _GG\
Q 10RS]׉Fp+*b.6pBK^/*Bp?qL_f?whJ B{ f++J`,oVpkvH%HHb SHAP9kM2aFcEAVPpF G0?x.%aMuP
^9g@t @0`I#@]
u`bq1NP y.p++;u
;u"aa9p|v[~a(x t
E'x tZ,+zV,BF`1t3"/Py6#43E4|a3^9u,aKI@oD앑蕄=uGtDtDtu#}"yjefY`jppzs5^؋ܑA_FډG1ĲДaGG,R`_G'v؃'$@  @V8q ΐE`ikPPfh  fh  j@PFPvڐ
7Rc u^ j3 Pp `؃
G3
G4
G5
G6
G7
G8tjG-P7G3੦`?fGtoGo_1	GP"CS70s
`̓а`j׋_{`ƋG@&8N
 



 
$
(,048<@DHLPTX\~xrlf`ZTNHB<0QpGC3? ,-`T9Gtqк؀@m w
r}2n
u`- . aD` t\  G ( #	|&Tu¿$ o  oA` c Z  Q" H ?	tA
 B? `C C
Āt$P
3
p*Gp+r02
Q!W A F
`+ 
k t `RO!
wa*+!dfv(f
ffff 
Q1 t 	 7
Z>VtPd  t	Ր /^@ 9   wrH t1	1	蝣 	8P<4A
t2=$ t	0~- pG^F@G 91X"{U+	0%	0, ^_! RSfG K=`a-*C"II	@!-< 4dPPs`fСa 1fg
pTqjgt'Z1aApW
ҠV`!3Vffq[f/~ ao!РV5p	G
	W
WaGW18 8>@9ʁQ:0gF6`$ 056ef ! @%
) ( RPO(3{` $ %0cG
r bN
q u0*pȋЊO8OъO: +*;$WPAm2hhd
\*p|#CmA%'n0)+Qo#- /p3103pB5V@7aq9P+;r#=`cjr3ApCqsCEG!tZSI	KtcM
OusQVS1vuUWvd	Y
[wS
]_jAxBacx1e gy Z
ikQzm o{1[q0s{u@0t#P}3V`}Cpq~S!cjsᠰ1eZ	T
CVA2 !
 "#Q"$ $j0%#@&aZP'#`( gҋEG֋I K QSa@cDe g0BA   )+tTUѰӴpUt0	4		U	

pUt
pp!U#%p	'p	-	5/p	p!0mbtALu	a`axbIPN
`~3{Su4t *]H hk0!MFсP	QBtPS$P0	Fqfri+c!lLbsPS=$h @6z}Q^dqpѽ žhgb hH$dT H	@pfQG
ீN`   !
 |	HtHtHt8Awf2spd Q =f `O	F2EP pdP dsFG tأ LEIUlOH  G#FG%F^ F^VFVߋF셇F tFf%  {fp_#GR3_%_FtS$w2P`>и V%@@^wà`t
f
.zSƇ `3Gf Gh=h=UuV`< G3V_GW P4wuT'FFV FF+9Wdrw9oGbvD	5P`#rrvk6t `΀p
wW`9F
Py
~333e$R p>BbdVf0!".Bt!CÐ # DF CcWS.`ʛ+pf.AYF  u		RJAt@7Q/pFЯǯFb0b0O `>a2~? @B=~st_0P߉GGF~
u#F*/`2 ,,P}	 ,bYhFtʭ
 ر.ʱPGGVC.f " Q~  @Q艇 yfppsL
B@ PM?lutPhtxǇp Ft!d }at;k
 <
߃ `U~	0(׹3f3ffNu[,CZU6pg3;"7 xHJ!sG e#U1|4A@sM    TO r1ZƇbf!22%b`S
* *G
>
Y*
 GQE,2"aPuba$Q+0Q
ă1a?9**U(0i`lfTRtSqP[B?жv"T dk^P2
ذa  {`0 3zPSQjGPgG  L~hPS`jNM9u2P1vǉ@1A1 gGB!mV`9GA|GO H@bpfa膋``uEPO  W`jn}3]n<0IAFGz6p%0GGvwx,7${ z}- ◁Nf+f Fa
  |		WPy#1h tPfj ܃
0{!ÊFr<t<{uÈGpGjGqzk#ňGr#l3ĈGs3m^CǈGtCnSƈGuSoF.%`)agb@  P \^S2uRffR+2pjA3pG%~% uGtR%1 DdKL K~B?E?RpB?>>T v?g?a?8QaPnFS赏Qxo揨t$$bCQ%\2| MXb3 OCJCdCCCCnFϋV
fѝ t~ t^F&^F&
uA WV~0<NV^_~pFN
ȋNu	]S}f
 [ SF4yN`3q3ҫE^@ufr;Vwr;Fv+FV
+FV؃                                                                                                                   < !c ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               68DTT   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 [se f    Q]sY 戰f
!  ff !  f   tf ff
#  rfBYi戰Yf3gC!Df3f   戰fHr4f f戰䈰v[f戰 rfFf    戰Update BIOS$fSf=  tef[e戰3[f  f   f戰fSff[f   f   3f   f  戰g&ffFfCg戰4\]s 撰fPfSfQf   fQf3یff
!  ZfYsfYf[fXSgu
5  ;u[fPfSfQfRfWf   f3یff
#  	 :ZfBf   !f3g}
5    fg
#  r%fG;wg}
5  f_fZfYf[fX      d         
, ug`TPFC@83@      @ FAA<77777 PKxxxxxxx  ,                              	
  	
     Uf`` ~6  f3fNfNF   Nv, ff6    f6D    f6D    f6D    f6D    ~seg`r]_`fvfFf^f6\fNf6LVfvfF^f6f%   f=   uNf=   tm f6LfAfNfNF~Nv_  u	_9__ fa]PR  _ _3 _ _ZXUfPfSfQRf6d  2_
 f6Lf6\ _Ffff;rcf;v^fuf;tTf6Df   f+fNf6\ffNfNff ff6LfNf6Lf6l6-ZfYf[fX]UfPQF NrHf3F~rYfX]UfPfSfQfRh  fvfvfvT fFfFfFfXfZfYf[fX]UfPfSfQfRh fvfvfv fFfFfFfXfZfYf[fX]UfPfSfQfRfFfFfVfVfNzf^f3ffVfVf~ tf9VsfVf+Vff3ffVfVfVf3ffF0fFfHffHf3ff0fFfFf   r
sf;Fpf;Fs
fFffNfZfYf[fX]UfPfSfRfh   f~   vfFfFfPfh    fXfZfYfu3f   vfF   fVfVfF    fFfFfFfFfZf[fX]UfPfSfRfh   fFff3ffPfh    LfXfZfVfFfPfh   5fXfZfYfufV'fFf;FvfQfPfFfPfXfZfYfufVfZf[fX]UfPfQfFf;FsfFF fFffuF f~   rfFff% fFffu^~fYfX]UfPQfRF fFf		FuF fFf3ffftʈNuftF^~fZYfX]UfPfRfQfF    fF    VF -f6Df6Tf;vf;VvfVf6LftfNF,~r^ff sfFff sfFf~ u$f~   v
fF   fFfFfF    fFfFfFfF Zuf^f;vff^f 2f
   0fP  ff0X0fvfv^~0^~fFfFFF~ t <sF Z
tFFF~uFFFF<v*f~ t#fFffftf3ffF6-fvfv~u	~ufFfFvvfFfffF-v&f~   rfFffIffF653u~uCfvfv,fFfF~ tCft=fQfh   fFfPfXfZfYfu6-~ufvfv]fFfFfu6- fFf;FsfFfFf^fSf3fff 0fXftff0f 2f0fYfZfX]UVVF 3f6Df6Tf;v3
VN@fF,~r^XF:N> r*@ZBu6%s6%s	;#	F~r^]fPfQ f=" u`$8ufYfXUFqf   f   s<f   f   s)fvYfFf   f   sF   u~ tf3fv]Uf~ t7f~   s- 8W
t#P3 ^WXfF   <u
fffF   ]UfQfPF  fNrYf  fsIfrWCr5	s)frsf  fF~rfXfY]UQF  Nyr F~rY]fQVfsVGfTVfYfQfPf@  ?rfff"fXfYUfQxUF UFf6DfFfF    fF    ~ uFf U
u FU UF UFF F F F F F F F  N6L TFT8FsF~ u~T8FsFT8FsFT8FsF)T
t<uf6  F
8FsF*T
t<uf6  F
8FsFsT8FsFF~OF
VVW?^ff	V_F7
gwfnfvF
Twfn fv Nnffs2ffFL
T
uFEfff	FFf>
f3ff	Fffsfnfv~ "
f3vft@s v  ff	F
f3vft@s v  ff	F
f3vft@s v  ff	F
f3vft@s v  ff	F
f3vft@s v ff	F
f3vft@	s	 v 	ff	Fn Rfff	F Rfff	F Rfff	F Rfff	F
 Rfff	F	 yRfff	F칈fFfFvFfVRf6fY]VPSf6drH9fPfD,fs	f6lf6tfX%:RuX@6D(6\*f6l[X^UVdQFFFF	]FNFft>F N6Ls^Vv
s	F~r܀~uFFFFF~vN~s3ɀ~tFb
6\(;vf6l Ff
If6@  ^]UWfQfPFfPFfF    fF    fF    6tf6tfvfFf6D6DfvsfF0QNnf6tfv@fFf6Df6DfFffsfnfN   ffsfn  tffs |P
tfnffrfn
 ^P
uffs^PW<uffrKfnC<u?ffs$ffrffsff rfnfnffr-PfnfN   ff sfn  tfn  sDsfn tufn#tufnufnfnfN   fN   W?^fff	Vfn_F Nf6L
sf^F~rffr=_O Bufn+Cuufn ufnufn	 N
tfN   <ffsfN   < fff	V蹐fF
fF
fF
Nf6fXfY_]UPQRNnffs2ffF[RN
u^@ff	VZN
u?ff	VZYX]UWfQfPMFfF    
f

fsfnF F@  u
$FFFNNTffsv^3MFAMF9MF1MF
)MF!MFff
t:fsfff
t:fsffffs7N^LL$:FsFL$:FsFL:FsF~ufNfN^N
ffs??fNff	VfF    fNNffsfNfNfFfN`~uN6L
~uA6L
F~y3L6!D
fFkfXfY_]UfQfPKFF    tu[LEr
Ffnf6D     f6D$    @  uaF$ufvVU2ufn=fv~ t fnvsnvsnf6,f6,
fUfvF NN^JF	KFKFJF
JFJF~unff8ft8ftf6,f6,
:fsfff8ft8ftf6,f6,
:fsfff8ftf6,f6,
f3fNN~t~uff6D ff N^"J3J$:Ftf6,f6,
:FvFFJ$:Ftf6,f6,
:FvFFI:Ftf6,f6,
:FvFFI:Ftf6,f6,

I$:Ftf6,f6,
f3fNN~t~uff6D$F@  uF~Cf6$sN~ t&fvfnvsnvs)n"f6D f6\$f;v
fvfUf6,
fXfY]UfQfPfRV ZIFXfPQf bJf s	f6lf6t3F TIYfX7 IF IfffFfF    F zfF    F AN6L
s3@ r# f@ffFf;Fv
fFFFF~rf~ f6D sf@fff^ff f=    f;^ ~  ~  f6tf6tf6Df6D f^f   f;u'f6LfNfF    fF    f6l6-Cff+fffN8rfFfFf6l6-f6Df6DfFfFfPfPfXfXfFfFN@fF f^f^ff6\f6d rf6LF~~^fZfXfY]VSx?؊[^VSu?u?؊[^VS?؊[^VS?؊[^VS?؋[^VS`?؋ [^PVSQ8v̾?؊vY[^XUNVv20FF>FFFV.FF"Ft;F+f	 fȊFVnE
t8Fs]UVfPfQfRf36D6D6DFFEFF   N^E FF  F NnE2~?sFFr~@rߋV~@ui8uecEF<t<ucSEF$ tGV6T~uVF$tV*E<u6T
E<u6TF$@tf6l~@uf6  F~66TtW~ t^3t
f6  f6l6\t
3uf6l~ t$3^t
f6  f6lf6  f6fZfYfX^]UfQfRfSFfFFf6drkDDw
~vF  D
t D:FsF FFf6ds4 lD
t$ bD
t
6D*f6l 6D(f6t 
6D*6D(9FvF ~r~vF ~ t~ tFf3f[fZfY]23SfQfR fZfY[SfQfR# fZfY[fQfRf   $fffZfYfPfSfQfRffѹ ff$fffffZfYf[fX                             ' ]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    D]    戰䈽aejge戰䈽weOfefeOfefe@
fefe'fejfe
 f%"feHfe	e
ff,f
fHfff %ff1f
f;f
fGf
f f
   `"	f   f3f30f  0f{f
fn8f   f f    0f  f f   0	 f%"ffk
fAf.Def.8] f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.Jef.>]徰hf`g  
ofkg  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      h      l <                      ?    D @       a#c     Aa     
             @  p  !        @              L                        L  B        ?@   k  `   d     `   d     `    d    `   d  A     `      _        }           z        z    _      @   
 `        @ &    H #   P    !        @ ܣ   Ҡ   b  d      e   i   i   l   x K      j        P  P P  (  l        @   D A  E    G `  x    H   J   I  h       l      p gE#       
    R  e $ S      !  "  #  $  %  &  '  (   )  *  +   ,   -  . 0 /     * `   P             T    ? P  ?P    ?0   1   
   Q   U  h L g  a L x  t   p   | Q         . U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /  . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A           X           `        d                            @             @      $             N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N  <foTf%fo<fupppppq
pfpfupppppqf  f	  f   f@ fغfgffffff%   f=   tf   f@ fưfpfupppppqf gfgfV0f gfFgfV0$ pfpTfupppppqf  fff
 0  fff   ufqfupppppq"fBqfupppppq f 2f0f 2f
   0fffP  0fX  0fffh  0fAfo  vfqpfupppppqg- fqGfufq1f ! = u%% = t{= ufArftfUrff  G$fG$
а U../0./. d< ud< t<t
ufrxf掰frdf䎊frRf f%"f   2f%0 f
   `"	  "	f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3ҊPR Z
R 4Zf   f$<rf  Ժff
 f+;w
t@fغ  ff% f؀f   ttf   ff% f;rfft  +f   `ff   ff   dfff
   ff%ff    f   dfff%?ff`u  f  H$fH$
и f  D$fD$
иA 徰hfu  ofu  PR Z
R 4Zf  ffZRff  pff2Qff  tff!@pPff  xff 8 ff  |ff!  f                                                      	            !            p                                       @  0   G                             P  0   W    X  @   _    `  P   g    h  `   o    p  p   w    x                                       @@           fSfdvgf&f[fSfdvgf&f[fSfQfdvgf&	fYf[fPfSfQfdvfgf&!fYf[fXf t
fgf&   fS
u
fdvfhvflv.f[fPf   pf% f
   pS *[Vf%   f=   tQfH   <f   u<f   tpvf   fT   'ffP   f%f
   CfXfPfSfdvf  f   f%fd *f   f   f   f% ff   f  f   f4   zf%   f
. 'zf    f    kf(   bf    gfdD ff   rf   f3ff3 )f[fXP , ,XfQ gfd   t@g&Xf3f+gf&| tfgf&9Ltfgf&Dgfdǅ       fYfPfSQfWf    fgf&D= ff   ff9Duf   f   fgf&Df  @ 
>zv tf
    gf&D f   ff    Hf$   ?f   f   0f   f   0f_Yf[fXfPfSfQRVfWSf   f[f   fgf&D= fGgf&D=#yv wv(f   f   utu@yvf   f   f   f@  @f_^ZfYf[fXfPfSQfWfWf    fgf&D= ff   ff9Duf_f   f   fgf&Dff%gf&D f   ff(   
f,   f   f   f   f    f_Yf[fXfPfSQRVfWfWf   fgf&D= fGgf&D=f_8yv wvf   f   u	&ztu@yvf   f    f   f   @{f_^ZYf[fXfPfSQV6f   t/3 t*$f   u zvg&ƅD    vv^Yf[fXSS2 V&[f   2 S B&[f   f   f   d &[fPfSQf   pvfT   ffP   f   f   f@   Yf[fXfPfSQpvfT   f   efYf[fXfPfSQf   f[  @DpvfT   fYf[fXfPfSQ f   wfgf&D f (|mrN (fdvf taRr3 +% (p t(fdvf t	WYf[fXfPSQfRfW<v PfUfʻ  fP  ff0fwffwfGfwff]X tffwffwf   ffwf_fZY[fXfPfSfUfQRV'fqv	av  f    f   fgfgf&E   >av utav fv  gf{ tgfkgf{ tgfkgf{ tgfkfӹ0fP  gf{ tgfkgf{ tgfkgf{ tgfkf0^ZfYf]f[fXf t
fgf&#fSfhvflv&f[PVS vv _#[^XfPfSfH   pvf[fXPfSQRVgf&ǅ@      gf&ǅD       vv g&A    
 v wvg&R  @v@ g&G  s vwvP>yv uccdb=$fSfa  #f[g&^  %# $fSf  "f[g&_  	#"g&^  ug&_  u>{vt^ZYf[XfP3f.qvfX         f   f=Pt=Pt=pt
=t=u8f3f3f3ۻCfff  0f3f3f   2Cf.;Gt %A      jZ>        P   D  @   5{ ?< L<'`&t  j?@ 
5 ?o?  0 x7 ? ?o? 
 7   ?o ? 
7 ?  {  ?
  =?o?   7 ? ?o? 
 7   ?o ? 
7 ?  {  ?
 = ?o?   7 ? ?o?  
7   ?o ?
 7 ?  {  ? 
= ?o?   7 ? ?o?  
7   ?o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             PȎf   AXus  q  >rfg   ( r  .fV>Mff<>3fffsrfff> wf   >ff%f5fff> trf> wf   >2>m>dff   fF>=,>#>	ff  > ff'fr$fff> trf> wѰf     >urd>u]R D>u=/>u(f "'  >	r  Ko s 撰 Xщ>Ɋ
$@Qҋ#fSgef[gefPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@
 > u> 5xzytsfZf[fXúz.yusfZf[fXPR tĺZXfSfRf@
 > uB ;yM@tNs(xغz,y0@u1sz.fZf[Ru	sZ                            	 d   d           d   d   d   d                                                           
      		      

      
      

      

      	     UVQRF F F F F~^ t  F  EN6Ls8F^F F
$<u  u~t F FF~r  tR~Es'~s~w	      ~s~wd d ~s    F  CN6Ls6F^%F F
$<uF~u F FF~r~u~u΍F:FsFf3ۋf8uf~Er  F  6N6LsF^du FF@  u
  uF ~rĀ~Es3~u	   ~u  ~ud  d  {~ud eu`F  #N6LsF^ FFF~r׀~w~s    ~s    ZY^]VS suXu&NuI2Duu>5uJ+u&V!uubunuz݊u[^UVSQ i
t
 _cFF~u!~uA~u6~u0+~u~u~u~u	~u݊Y[^]UVSQ 
t 
i2FF~u!~uΎC~uώ8~u2Ў-~u~u!ю~u~uҎ~uӎ݊Y[^]         f  f!  Bf3һMf  ff  ff  fff
   ff  ff   ff  fff
   ff!   tf3һi` f   ѓZd f3һݓNf`f   =dfF/f 2f%  ff3f 2f%  f   fff 2f   tff3`f   ZfѰde`f   sdfֻ~f ` f   d f3һZf   p3Ҹf  f
   ff   f  fff	f  f
   ff   f  fff &f`  ff&   fd  fffff`  ff   fd  fff<u
fϋfff
   $f$
ĊËfϋfϋfff
   $f$
ЊËfϋSfWfRfP눋fXfZf_[$f
   f fffff$f
   f ffff                                         0         @                                  0                                          0   ?    @  @         P         `          p   ?    @                         P@ I@ Q QfWf   gf&D=     ff_Yf`f  g&D5 |v6vvsU >|vt faf`pD$&v
ĈD&vvs f  g&|5  t>|vt far`{r ra`D$&}v
ĈD&}vvs>|vtN a`&}v D$
ĈD𖻠vHs>|vt afWpr f_fWf  g&D= g&D=Uf_f`g&d  g&k  Āu g&G  vv{v vvG 	Pvzwvأfa    f`f:?f  g&D= (fgf&T=fg&D==r>r6QfPf  f>: gf&D5 gf&fff>:fXY/sufaPS&	$&	[XÀ&&        fPfSfQfRf  Pffff?f   f  Pffff  Hffff  Hffff  hff  ff  lffff  ge f   fZfYf[fXfPfSfQfRf  Pffff?f f  Pffff  H$fH$
$f  H$fH$
Њf  lffffZfYf[fXfSfUUgef*geUfUUge$ge  ge f  gef[ZV`VfPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X   `fffY  0h0pua`f    ffY  0ffбh0puaY  f
   `"	f3f3f   0f  0f  ff  ff 2ff%  fff  fff f%"	5 tt! >@s! 'ô ` uR Zts+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          TfS  ?   fg  +   f{     f  q
  f   fHt	f쨎tf<w' H$tt
f         f˻ f3ffйh0i0 ff" 3f   ff   f @  gff   ff  f @  f3gff˼   VW茠_^f 2f0Unf 2f%f
   0f  f3f3Ҵ02 0uP0X0Y0h0puf 0u00f 2f0~3Ã u 
u   RQ 
uHu
t!utuuYZV36.^                         ø  f   f$<wDE2 fl f fh f 	f f    }f 'Yf   uf   tf f   KMf f  ];f f    o)f f    f f    f  fff    tf  f  @ t f  ff ff   f$<vf ff  ff  ff   f$<v fl S-fr`8frӺf                                   Q  YPSR+;wZ[Xf> tftf`f f3f3f3f  gfffCgftftfaf   fuQYfVfSfQf
!  f   frffYf[f^fQfWfVf @  f   f  gff^f_fY0123456789ABCDEFPfSg.<$tCf[XP
XfSQRfq   Ѓ.sZYf[PSQ؊Y[XfPfSQfع fYf[fX            f  f  fPQgf0& YfXf    gf~gfNgfVgffPfSfQfW<w f.?
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           `.<ta ø fSQ >tf  r	f r&  r-w ge0fp  )rge<uf   ⸸   Yf[fS>tf  r	f rf gef   rge8u   f[PfSfUUgef*geUfUUgefUUgef*geUf[XPfSfUUgef*geUfUUgef[X     9f ? fPufhvfdv 
flvfdv fXPRV d ^ZXSW  _[SW  t_[RfQfhvflvfYZPS  f   r  f   cff=   t  f  =    
[X     PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     ffffffffffff戰3ظ  м{fҨ]ffJf    2ø       @ 3w]e06/15/06DTTd {+{.|&p-_` p"_RVFeЀ^&9G,~_! &x2 ~G f&p.fv@2w
1!1PpXq)F`ڕۢE Eu 	Թ`ߢE"PVSqP8pqPq@;kfP 2JL^@Mp6hFf 0C8vzY QP93pV3P~O22܏܏܏܏܏܄܀>E uEE˔E$" EoREEaEC@ʀ> u^ V+EPVfwE sf p+9Vowrw V)
АF 8Ft,@ Q(tٻ
$* 	v	<~ĊfAVpȋp֊n* VԊwְ	 	-t?-,u!Adapter - BCM570x NetXtreme Fami?ly B57HardwareDriverMLID  
 頡>_  @     	  
 xi 
 <      < gLh@n pO  Zi 4  
ں  a@ ڀ  ``_ubbCbpb:cg2djbc;bc(docgTcRcacbcicdccddoddddg! kdkdcU~a4 c+& Uuc  	 
 ]7b;SVsrt*ݕ+`^[ø.sa* &D&Tr++ډD&5&].saù @aøtK
t(S [;Wrw;GrWڋR [;u+u+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR._ t,`ut{  gl0vgnv7 ñ..`.Da`r0g7Gûva  7t&&TWL+0`< .:uOuk.sa`+.: uuL
Lt\
DPX~u< 0s"U_+Ұ.:tat+EZa]ˑ w `0B _OΌOWt&DB#V ^u`&l`+pE"u.`a!"``V^pbEU.QuMZY`Q Xu.taeZdQ.>Ea u u;apu Wu(goEauaD,ث+|t#6"_P_~ <rg3._._ &u&D=vV `3M .n&\`!##Atʢ.9`u.9`u.9`t@0._rF;wrtItJE ]P9_D&D tz}R@Mt2 ss.
 @_ Q&|u`dE

E
ED)7
 Y@PQ<wp_
Dxt.`;wŉ5EEEU.>_tE  m.PM
u+P._E{P E E
EPJaE.;`u`uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X._3Ã
Ëŋ?+HtCP
u&PIٿr+\2!&/GIu*g  KBPUSQRWYX_ZYo[]XA6D*Vua+tEa,T+ێÊ&S&G[ú`|w! Lr	t+u+`TLʉLuIuËDD@ V返^\uA!D<w<Xøaø>@ _øH`WVQ_0]P H`.`P Q La TQ X \ ^aY^_PS [X  FFt%&?	u
h0S&F? uA\VpV@{u 20QR 3ɺO>@ 30`A V
Ftf?~ tp @F&`QVb@RPWV~NaV^_B $~0AWVS3P}GVڃ_VF

V@N 3Fp 8pVu@f
r;Vwr;FvN3ҖOu؃? [^_]	ߋN
Ȑu	!Sf{
[$S		3uEP^	۲	ɰ	ȱ	f		+FV
+FV		Vhoi^b&$0p<9vF%@ ܁                -     -     P16X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                               .6                                                                                                                                                                                                                                                              eUPQRVW3fu@F(.;3s0k@.$~ ˁ ;u
t.$t@~ f^rf(_^ZYXWQ3.>32 .ǅ$?.ƅ$ ` P@hU. .3 Y_$
fPSfQW	3.3^hF ^ hIERNwFk@"~ h 
N~f.$=&@.$2.>m <$u4.B$f<t	of!h$< F.4 
_fY[fVF~r$F F;F F2u~w
fF@ M~UfNf!t
fN}!$pu
ffsfF^P2$p4ڀQ$
fqDF$<u&f36$F # ~$wp` $.
u0 <uO8 P^`)V.k63@..3.`/^V0&0
09t@ރ-2ۿx@2
E/^S 65O^ /25#15$uBF+:N_^13$::
t3-S9)Q9$u=8Nuw_^7fPf3Vuh  fhA] ^fSYfP%
S?  $(t uq5su0jM !0 `*-fVWfpF(3Fq(('F~^^h<֊FտF 0?ff
J,F f^V迖f^qu{? @  QV3 fz ufZ^Yft23fN Nf~ tFt"f 09FvAFH;F`0Z 	QI ׅAf9Fv9fHf;F!:F׊F8F uE[3!:fI"<`<Af+ ;NsGf.\ :^(tf+fD;<
9;f0Q~uK~ tE&2aP_F?.3NP3I3@_fd'agtj h)P; ^VWUhC t  ?f JJ@ f?Ah V5 PhXQe[ 6a hZ<rg&>Ut2g&FP3EXYP]`X_\P/(GX0Nf	][Xf`Sffff h3Y   f;r[hU WeX
_ WH_S^SJ {rPYgNAOg	;r[GElnup \faHWfgf&"f ;PCIRu1g&{ u
;Kug&CufQg&Kf3ۋf	ffY{_KU!
tg׉^uhN^Ǥ"u h fΰ1  Bu_1x])QRWV^NV v<q6Q3a~Ydʫξ
^_ZhQk tkYfWV3ff!%^f_SV
#SW0VW tW^Ty`SPWF  FψFX
XFX_V XX" XX 7V`qTڀVv NҀV tFt'fUځVRRVRtRmV_dVQb1Va2Vf>1V7 Y/ Y'YS Y#Y YъF8F h%NX'N6($)&)(,Pf@x fӁfӖXN%tt\sPSQ9FGvI" 3%   f. \Ϳs  vխN0֮ /0 
t
F%  .`` 8>v:5~ t8<<cfSVRÉFn?nA<Z^f[ffABRffЀ`2fTf;w
2Z~ǕfPRft#f3رyftpZfffNN 8ss4
t|Gu+%
u	afFf ߀ú`^^ZW0%Ff^~I^B"8uAffF6@-_QWVfvAFּ/ϋ~f3`RyAϜ$wЇ45SV ޾j3; t	 r^[ðZk@jp~W#A[S?^@㿊$*&t@;v7!tk~@t 1;FtFk^% Bk^P؊japX 3҃  V3k`ԋ
C*j;FuR3t7:t-k		# a
@S
+FHu
4uGrvFvVBs0;4VWPp΂tSދ[NuVp 3ҋ-pn_^P@ɠ**Mˣ^S(YRl2hH⠺-HP$뷋A37Z  fǩGVRfQFu   kv@kF.b~$$I$@frDfw;=< u Xr,.$<u r_ s0	 @vFfYZu@0.3FNf1Ԋ~߲d
t".ttXpvX6dv둀~ }7PRρ00;F}~f!2@p""0P2N~ tKv К0`X9l.A\$`
f~PQ3I FfP"fω
	M SQh3	 \PBf23QR.3ytf.&3x.`t.83tYPRWfQ
5p .' "  u߉ufY_ZXNW!` 1f#3
_@+f`  Pfj7@
xVfWf.
ۉ^2ۊ~$=`&	?%ftufP f.3| 1Ӡcf.{@( hYS
uF,8Fuf_@EbgR.>3s$	a.k63.3VЁ#eq 8
 v@a
#3t#ًËȁw :u!d;  v t'f#pff	pp
=prc#n;VF":` uRqr[tހ~u 8i/ t>x"`{(`Z J 9R<`:<F  .3;}2;sN0 t4v;2&;zf~FN@I.3e:2fVv4`b0)6uSJJu([tҋ\ܐf`K8OfaS/ $!V V03  1@ ^iJX@Qu~  u@V833LitQnd
tw
u7Yο߆	_^!8na? A%shহppL" "  ta#2JP ؎Xu	Axu/ u5   (ru.LÀA.ף $0G WoC                                                                                                                                                                                                                                                                                                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                /                                                                                                                                                                                                                                                                    A     TPM U(    G  N K 3 U fWfVfSˎێf3  _f=G<t<t
<t<ti  f[f^g.$`f_tIFXTPMDRV-MP-SEG16 v0.95 Copyright 2005, Infineon Technologies	QfSfR
gf. 
g.a3g.1Ƈ3 4 Ǉ,J gf   u u  fP< fXf1ZYcQ讱Ot[RS  gq	o <  3[Z0 
  
2%uP 	xcst	 0	f{
A
2

 WDF<		
g1$u	
E|C3f
f%Q`&3ɽ
$f6Kfff˰ gCA 7u3gF b`RfgD`"gC"f(g3fGf߹ \"agf4$ +Iffg` fG(  (	Z	_fGg'3gf`Ufr)tfJrr`i,Z4.;gM1"2.3N4g1  f_fY`>Zf^f}PA9!F3RQT/ʃ`ʊP a  3YZRfQSڃ <u1 u%t<u u3
߹ w 0 <	IR	컊T		 0 tϸ 93 s d _ psOJu0t  $&&A	ML'a
pn qv2fR&St2p  f  `OQ f"FB? 49 f t|gf> tup ~ tmށ  te t]ffֶ-N0.^.6A\RZf;sEA\u
 ',[5 1 
@JB$
gb +\^Ðdr
3ҷqBH ` u
5J
0bu"K ЃuBw1dUogG"GH!G[I#JHf<k>gu0hph~@ Y	uBjd<u/
uG u\  OƀtHDt$2ED$@ff+f+#Z舢qu  q^rQQBNL$K		v
u YpC0b%3 wz}ǀ 7ujPbT[4\ tL2`Qxff3ff%f  gf!a	QRdgAbetff<f;s gb
fgucgB`ZSoVo oA!o'oBmpEqfgPR%S%"R%Q%
iEgxr	S t9
 [_Ҩ% Ƈz1yn 吞RБ tk [@eP{m `rCfRS2 !@^R nook n```` s
@l  @nr
 蓦 PagdTf_3g3-3-t
1#H GCCQw	000
000 0j=ݱP>~p%a"Q,k+A-$#qrqrtP Dtt%53Q . ) t  tA@tt
 22: T,.bFg%65f fQ! !Nql݊q5qt21?  0w6a`qtnf+fH  gV ]M6kLPaG.O_!t4DY+*+s0,rF`"atfSuN3 (`H0  W. usIu3PiY mX7PS[`4 !6&  SIuއY[Xp$
pqS oq[ჿA tKC>X p3P   = pr" fR
4A1f}f+8f#b%  t	fˁf{jf%j
tpe/$z Fidk&   x < BufН         2 9        SEC3$  - SUW3{_/ G܍  S.0.r  Pf= uf&TCPA W HPD1}\_][˳ Չ"Õ `1	  @ Ā  x
  @ < t.  	t<w!3ۊ.;@Ǫ!	
 p  @ T  `Π  >  `<
wXR[ü1a b  3@  ݳaP.}Q< `ۃ@f1i ސ/0t%f=aebkS
Ru3fUf   0   P!  V0ǻF1CoލH7. 4 71p"]Í% &F   `fji@

I͢
@
_f  %g?3QR
Du" R
	%?4U	 >H
2%73p7  5	-X
hRMrsqˉX
WpER#_  "-q1  ufDf`15#GF P993 :3fPvFWfX&c <n@<U<< =@=U==(=@ >EX@>>A@?WB?ٔE@M?ÈE8ސ6N ]I  QU1T][؅ûփ
%"~%f%
w" dUM	$ULU
e#bS
 4RfuX_ZKRm u
2@X*qic1A11lP@aQak=qaQmt;<svq `,y],YP}v^Ƌٺ(Qq	u>^ٍq6Ak"	
u/&uu!x.uwbi  u@Љq~^0c@of]Z!VsSV]BfYpZkdZ`6
b1pb7pbBӂ
QR[ZYQPCû1DrQq3h}u{~>u=kvP6`tA2a f;tCC` C- yCZpiazC3ffFfCf߃rMFC 㸂 lISIfffC`X0J yNsvAP

ey֋sK0*!@OfUV"فrarXwC1VC M#%`
Ѡ%#VPV^t@5up H
}qp8XPa-VWx_^AtKS[`t^8s2N) ^2wNfǷ u  fF3+SV%%1!Pqñ9;w40ᜉW_r42`^[VQj1	Vfu!%^&@qFbQVW{qY>3^H FKZtVW{ v^                                                                                                                                         I0@ 
0Uo ]FpErT@F
3"` qqSCompressed BIOS codeCalling INT 19hReturn
 via#8hBootBCV Device 6E6    IPL	PU patch
                                                                                                                  #EgܺvT2b`5  W?WǃǃٰǃݜPqǃs吆10ƃ푇r u
@w*`Q  	@g@o_p
ȫ_a`Q;d&GX7 ;w+0 +ȃ73@&ast@3CÍ́V3P Q 3ff@r	#3Swa Зw#@ yZ1'w33n!;wP##Xܼ	2b[
fPKAbc"{a	RX APA&a    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  $ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$P       VBT             $VBT CALISTOGA      d 0   0                   BIOS_DATA_BLOCK   o  d1305Intel(r)Alviso PCI Accelerated SVGA BIOS 
Contact joe.david@hp.com
Build Number: 1235 PC Dev    07/26/2005                                               Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ i              
  4 (  8 H 0         2 D Y
 c
 m
 w
 
 
 
 
 m `   `   `    @`   D`   `   H`   L`   `                                !                                         0                      @   H `   H  b                                               =                       $    (     
 
                                                                                                                                                                   !0 R`SI-1362-A   p          @                                P                                `                                                                                                  M   <     <
 2	 Z a-  	
                                                                                          	                                                                                                                                                                                               <                        <                        <                        <                        <                        <                                 0H d @A &06      0* Q 0@0p      /xQ&@X      H?@0b2@@      ( 6     6     6    6     (              @ @ @ @ ,@ @ @ @ ,   (  s     ) S	(		
	(		
	(
'

1
(_
q

{
(



(

(=O
Y(
(
(-
7(ew
(
(

(C
U
_
(


(

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6      X   @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a N  XN  XJ XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                      U)CompuTrace V80.817' \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      w OPO WWUPX!	l;WO &f`a UVW~
3vNWXZ_^]
 !d~#^"!B @WWVX''K
u".H?t2`1_r <ar<zw$ߓ&G+tM!OoF	f%}UoV%FUrsk	rHY1 _#+mfo>c3ɊF0r	wk
`xnW^`~f	E	p	G_w<Wf  79nGKvEA\Gunc^|mRs,eު+74YD07v5|"Fk- t^- tt
_^tuJ~tu>D9/u6]yUu,}7
W t}v3^_sE+}Ff;fOs)GC*#D'^4
Fm	[/Pj>3PtlXȷ;NFPr	+snV
D/Cvs)/sam
MEPW*
^3vNrM[a j$
F¶{t
j 5M4ON<H{k{V,u<=t MF u7-]
q#ÅۺP(t~vI<k
';Φ֧h0Dj3T#httF|#8S
P,
vShD&hm?+et!NAQǶhnni+r	 s)!Ͻ
J|8@oduI |F# JٚFu
\Dll
vlyT8vnFiDLGgtV;{hR"L2fRf9nKt8av$'WF	hD;߄P`EdPK?]lt\\s=Fh
{CMv?(|etsRPز'sJd!!jhxDh&PY+|:43tf6s&GO@`)Vjn8x,wtt[V
lj$8^8#A\mUdF^LKrCusuu]ᆗ'"umDVOf2Zqv;/ ۹th.Jyͤ"	lwM 
>_lκP+' i;iL':,;v5=`k1 +G
jPx :	4VI|x-aEuF+Fv*"E-$1[/@sPm|Cjd`A먉Dl}l'VL5QTY5:hh>JrkE,|le!#cEB&\Dr0۠,D$\ 1S\^F:cӄ`R6?5u89o$t<(d?puBc[X|. {k]+$΋	Aw84WB.YGRԊwno|:hAX:BV37xT!I]BtR0<	D(PP(&FMn+"iW	(-zk58V[aBf)eZPPϾk~	9	^XR0#8D>W_fEK8}Il
) ͖ w uh&j moF r}DWkkpض U[f%޲Tltv
o"d[B)H/RPSo$W%,1@][.	 Vu=Gvamk	\XUbLL-N]$gfñf!R
`	 \ݚD2.%ǳhM;-ȉNl48w@M3QNQV[[q9(v*krۙl7V{Nw7~*
9s7W1-TO;v)
P0g0H6['FB'O,*9X[O
o wqw 	6ڀ$+ak|(lվ+07G2$^ oΆP)
yl{ur8R7g)R`6ݓ;µ9_~FgF	f5pa.+
_uE$0ݶ(4
 5dUhڦ
$c\JeV@br%H
D"T"6R;"\BM,zIo%f blUuAW<D, v>oyrbX}C&lo6P%^GlLАf:р{L7H^29BS9PujJ^'ݷ e\كh
56䆩4@3k}f'
bdn5+~u&Ǯ
F*.qٱ(/|(v,lafl4]F
-snm9Wt\Z)#D٢ ml{BHn,H`}F^-EV9A
oEm	
@'E^^>+-VO @\y;V
BGG=2NzI'\:a+Mɦ\D?'f
^u_\t F)b`"9Gted7ORu<"GH#FD^ô9ǜfHm#{$7#H;f`NWY9(U*PMMu"`,.Հ$E(Jw W/~rEBJIxjZ[/7[	lG7pU$<u@(O@t.%?/	WFN;up	8n[AEFT۞Pط`:Ā
J^k(d7gM$&	(
" 7;fJƅ6/,nkJHpoq=`ogn\t?<R/;u/}.GV$'U@!ƾF+|~+= 4r3K'] e v&ouyw|, Jxpir{@KFeI@x3};u;VCX@ddfjt-'	CC+wtT
3śa]ht3+Kz H8$tkN;9tkND7EG7-~Y-\o=c0Ku:R8*tAtD<\ݮu/e,*$V t
.6-7L;Í8V -TVٖZZX%Xa&IwO2-S3vѺn9;0"HP
.0ܝ2#wR
L,POd$ly %^o.O,̐1_|RO\߱ -Z[9 cu"߮5U#VV!q>U
GXy,[!bHBW~eJuVBX!`3m~-:=Wt@qG0-DRIG!H;޵%*vu'e+]O@FGupԗ/Q|$)iҪ8
CK:QX7{,fbl&<j0ڢfn{#MfU<	]ܭveetV;
;jGr%V${ĔD,G$/
>}W	G@
Bٲpr,
* w&j Ht 74vk=
826DO\upDH	@N#
YҋoL,
gCD(諏+,HDphk-%#ΞJ- #bbT#:9j2VE=MWC|b$-B@q ]۞xئtOw"Nds Nxq5"U2wƾlKAUoDA= w(.bM6 03L<9 ܴ齝5ennN+@1]t<=|@	LB
;
uaV?8=C:76?+1+$|$S}γ6. d+
{;~fc.
j.ް2>KCvGR76U+zpc@5섨	 ]]m1dRb
Yt9S:g
ɾIKiG6g0
R5l
 5VKf!o~O#<o@fP%ep%?0Nn ŁgWl8#IjoWUON~k
*q(>~Ҷm	4?5wE'uQK@B囙b4<ܤF6P(9	VtIV%ƠjhCڝЦa#VƄJ|!Bթc~۹GFR?(* A9*F Z囋EPR
jZIzNl~CuF~BQ	ke]Խ }F 
V
=K%Э"dN!uNI?Ff
Q("`Q,1o{̓T>({BNVz/8%RV0FFG;wD9`HD/5].JpxG4;ueHLQp?(:W&];t K)o	}Zu|]"g| u&>FtW{ѫD _LuM&8S"+Ҕ0c4ԊXЖ틃`ffw1Mf9G8r,v7' ,hRZA:	Ձ¹-}f'O@B;!xc떼پ$NQ\|a該>fNEv3Fy'^8!źī`tDD>&OGN=Qw-z1K(6$XF<>j0!$)K Z:A>$bQ#)yW"w'
9Uu>s65 rwS2rr$vz!Tx86;pL)xtd+PbJVY*GVУc?LK/aA*l.	tT)1{L R@r@И ,Rj6`~D;4G3
X`sd
 μfp40cR
;
feI-?m܇3(4n@@ %.=P@4%niaPWh A 5ͶAL2tHo{ 継OP;f#ǳt -itζ),lXwF&5z;vvK!+UFa;WKn
mjԓ=Wb6]S5PFVuiI`&v!G2k&GuF	%ٶk/ڎMQf\
jι@|$_Tun/HHl}w6E{q<x
WO'VgXNkHm9w!<y;cuf.P(Gݩ2ȁ0ݲpT7jxශB;tj
s)^fQ.ll%(2%j0VV][8l2Ȉ
`oVW-p0ɵ81sZY&_tV|i2[
Z,)sZ|j :Z\Z
oR u2Vc)6Υ Zޠo 9RuHuC2QP/Ԯ=)bӹ{UV7N8;q('ҿ;vVNQV,J
)*L( af3-M1!W,IĐ}'u!xw6>WG;0W;	DHiY$T1V✁s@? t"mo=jDG+=
t
Ejht]S7DNPn (p/L+baAk!ưfO<9TV9sD#܋ڃýێ+¿mk Th<3<R"	.fR,i yqW208zͯ!x'8sW	Yz٫a1d#ma4 B1WvfP"F(t3l4;5;%uuV۝RR1-Ŋ|걱45|P0 \9"@ò$x^;bϢrD
kP	ԉW8^E(VzSL|ηew v^	w|o亅ÒDrM"CP4)bԻVj1)`fhZV?n-9dK}wrr@wk(5(,gmsy}XGC#:<iR4,Hs0&E-K*KXXYrIWVrê	>2=$j\܇DwDpZԆ=Cʧ}N&'0L$3]&NG?5qRZxޞ5	bAuS.+<`_^Yu-.P)Nj%p{8W[!?W@)^r
AQtu0D#]|7 ei__+;ʾr;r6X\qoBs6.#ԵVDIz
S*(6 CXl BWs(x RV"$!577pwz.Tss+;(FfG^w+ƶ%!zM؛_V#i T8дU#^%}'YjkV-dc7
^~fA5Z60בm"L5@ Xtk@7GJw;cG
RֶPLNH@.H[zLJjDDt:
FR@B[Ǳ
r+,L/x\w%4B&j nG${L?,ry޶Td W"2YV(yWDF?9ZHTJlo<>Z+D3EA/P=9kD6fgIͮl@4HFCFD&Rz&,v%V]Ci=NU٪)G6t18N
]6	:p$}9&:Z?M..ʍ9!<GtĂ^s[ȡSW0l(WRVv[%'t)zYAQVϙ=6 Np5[PL *
*թHE4ޖ:
&|hS2ۃ4 ǣxHztl	{,I@rf*^Ww0V+] &kl@и5P!yܠXu
 V`np`,S
1DV/q8"b&6thQf! %F$Vz&p,+V)&PWU$zGL%/2uvW #"AD#)h?$!oa!V;U"26l	
	/]!vLcDrր,'=ca6,0]hP5J@ٸ#b	%l
`px=3з5R[2wp$bD
}xIazDg]k&;Tp,$\&KDVc/8׈8`!\ ri&@b-N_ck4 sFJ dܬ
D/ùf;FD7`nmUOxUJ 18leT.R
xtRu`;EiP
>q{R~	N٧	k4oE(Dz4t
,AIVhOr[
r&wvrN H;+pTH@jY͉CaACC:z	"=t(4(<r>2p22I_`|GGx:9|%ff5+t+Wl!rRLCOwMcBczrܾDvwbF*DTfЊct{H+6/xFgd0H$|\
	a/{?,jco`
(P	9
0y6Vl@AupiC
^X-NTsнT@
'&0~8 ؓ3l!+	&lbmVl
UۍD)QxLdQwp)wȸҥ2f|<Q?,MvY_!XT,+v^,.:?:SNp_btNf[ug5P0',x_TZ*`6e	o>OT+NBF;s>}v;s,)N-fP4CVi:"[%,dOF{)&8thY%`W"f#&p@Xu<R)ǌS8C&
%
N"05pl-=Hdd.6?AUTOCHK.EXE )rdisk( partivon
 mul	\MSDOS.SYSSystem32 $I30WinBootDir}cBOW.INI}%tK Menu/rogramsYk{}BAK^8-ެrpcnetp.exeo&&ړ&MZcTmPK@1I(ǻOǶ$ǷǴ/RichSPEL wC/ s$`]  l'e&+dW(P  d<.tt_na#`.daKݰ
.cu(D0`'mtsR`'rel7oc'%MV";B  i(G
*i4DiRbli=Z

4_2Dt7	R \??\C:/8R#5	:\] %%l, o\Regi-ry\XMachi&-ur+ntC[{olSEUervices ?Local Obj+ectNhKImagePeh TypEGo`rF {G : 9]Iathl@ d7$lVo+SVfEeE9EEdÀެ,V]YO=P. N3V"jhn7V#kPhCyPǕu	@ma C{{|+E5ۜ940Q3ud,m@f#(ZŷRt/܋@-)e  MH{k{ ;{
k2MI-A3"H
A@ۭ8ۃ}
t'on!)͹8w?m]_^[:|N葶F8ػo> t*3pG4`P+L4aR@fJbAFE1#8w*H_K##@|(dWj8)N)af;Y-YC̒WWfWI}ɗ}}b囅[9=	
VVx=
t}SNQ	W	PSPpWvM)p@f86r,	9>u9~u[dM>LS <Pj2> (GnR	GlX4;!%Q&yTY2Ij)OYY,34-+[uj0(g
j.?;+K NWCZ0+L9}V#9ۊ	0VLd v>}Cs(}f3^d	
%0((8$S[o8UF}Wo?  ''=o	O첰$qMeLav4Ӟ(n86:vWP
QJ`u6);S̠% mMR׬W/1BB"*xX X .+<dQfljhoJ|Mn>6Mc[=֨LqYB>
^`Ë"7 ᵝ9|]4 9DH|o N
eFilrwcscatRtlQuyEn
nme{Viab(}_U c9ns4CDelelRRd
F69lKKey |archr nInitUcoden
\ng%ٓs[/P?TmkkaskW.rupy\WSmOw-d_tdll. 
j9z>9,b9~<9?9"#9#0s v 6
#$-PoX]wwFT>d~ p  8'HL\%56=3T:|S<`r<&Gp'H@Y@*HfiziКvA4.@VMj~44MeBi.FTf~iiĚiC4&2DMT`v44Me Di0<R`inzD]w46MEM&84JZE7):ssE -0oLXgagIi.0U\-Lgth: %d
%ss
xsvMoIcoftwav\MsM
\W;ovwsVos\Apsp mi>pkFI~rnA۰ x\&o\.b}bQ^͝DfRm_j_ܝm{hF#tTX5/Ac{D]AvaXثkHaÃ+0*?[Add.qLH5=cln;AKOpMozioa/4.0 (cow͈; MpSIE 6;)a/OSTǀ7OwSREA#./''K((..0//</^K.b˙!!""+&/&./HLKJ@Nz9H~`n _*K$h@6}c`eZ/AHwoD)f[G@
=Ke7zAvjaH#ljlT6HujWqRֽLPbտn3 n͔ Y̠(uS_䷻+xZ;cF9'ouva+ȹQ:snpnxlmF7O9]ev uVQLжύQPL+Tg0RP(uk֙xOtj
,n	_N"(w0w۹vn/KYhׁ	`\MQ5R/:-9{,"h0[9О8 xYѫgeYEⶑVSiW9.$WVx<hb	I~8KlC`a7QQWjl8LhJPlM#(جAw@?tmWhPg:
D N2 hdD.A@@=mL|toj[S^  #'t< xNVP'hXlHp7~gl3,'j4-XQh=<t
$u$|$Sw
hP&d&no^ް
` ,0>V}WS53չH+}na}Ы]9\t0C .S
,NM+ⓞek=]\]@	`,:_kcM4V~xza%gܖB%m7\ \%Giv	aQUV
3E}6i)yHDQ{E	$*vb-(	.;ƣ1
0ň8/$ yVzE=x&dh5_2o~%@#5_8k[uuÿ35<Q~t^l4h
u	*c`Uy_n[^]Yi('3G}ĉ'l\btB4;:jD_Ey64af:}6w!,׳z9*
|2lx )4	A'z H˸c *dhd d:{c^oCle7S0olt,>%d20dvtz@V0ayoV<Fwp4$fu:0t?ldHX=7H@y"954Ou\P88,76;~6M*0:9/P?McƁXwk6^u

8zoWtt	j(hXi@6̈5AA֣"]h_&R|	Ԫ|rW0`VUZ/	Dnl|mtċcF<<@hPdP8oYY'1vD\P^ea0j,YV:bA
+EXp'\syA
lh 6NEi`m7SU\}9P=tbUy
VMowk-#;t`B@V=X(V>4c.} W@(aF;tmDu9xNƛ=)(;Ò]'$MgZtbۂS )wPSzSͷl*YJj֐^'֓Soސ9\6טJx\l][uo=,6>|Bt(؞o":7u]¸3l]"J|W}]P}+4o,
[o3ר@m\t;u"PRCVPtT\)*,ZEbn_d g t JIRmzl1W$LLbf<dlma =@s>
*@w<8 F洁tB.[w9u9'ހW?xhƭ!fT[&tku*peFlƶU]H%3E%Bm#pv[d&/FxPQfuQG-\Mm##7`@&fuhI:**PZ_<DNHH[Eޙ¯l-oE-uqb
W
r07dujdp3=4x4Vٖ45$ TAmivpiǂ4d/*((68N`vP2TS z;jjZܸPt:kP@SKLtujHa1tEL;/X;l8`.R8ĨK '<v(!
P	ɈH'VuG9G_su%A*?AAVބprU,E;E#P@@Cوpklh"rP<	pAC=;E7K'K¸ݡ'+m `~$	̀8g609	EF$\(0L,$8/Ho9u-e8T0ֈ]*mp lQlؚgXE;o޲[*~Zm5HV CSV}z~TVk\D nO9^ht3ۣި܆X$x苙&ۜ	89Cu^G4( ہvS$ǃcF %pk/MrV$RhR^\pT,cDW%p2`i&5l{ f't
Aη̤ى=2D + 	%G
7Aôm4.k|@Fo24Wv4M&޾t&c(r<?G|Fc7#^4JxZU
S#?vnQV􈑾F@YWh`$Ke|v
ahh[h}(=i;T$hH 2A>c<I88su 0IbXZh~bdђ`w9c`?pt<Ťf	.cª@@pY|hfp&da
q=d(|h0W5
fPm);Yru`P9̺1X5d\[۠!0xE(J3-u	췉t`ATqõ2pޟ3ĪDF@	K^B?xYN]iW(0s	XW	!Vw<bWzHMP94~sF,s9(Jh=L0C@3ҋ~JHN0N<v8Dr[Qw_H^DHޢf,0 HP	K
V̎xA~y
; 6)sLў+ .|$Kw+WVn4:Coq
^F2\Ɓ	б%f:$aw[Jwjp(qIVA<V׀ ۿ<"%Vj3jBDX\(W/`xG@@Ft
]NH>1
|*w~ 37+j ڳ0_A"@[G[s0:2|t
S^BY;os6|DD#G	&N;6)!Vo"CNb_!q1 L-]Q	PAҥu	܉#ɋT%+ 4Z[c
0mۉ1DuJo>DNd`!@\pp_9VD6[x0@KNHj	n0Ve};wu_  \jH$wX]zqaf{{<t{4Plf(KVtkg6Q;-3:aP=]ujXf{aq^l>D什8@X.UM߲mvk(H+ͬh;u	cZmjp!q־<QYm(;Wҝs<HKt A0^tilNpNYlS^XPw.+>ZP,b[WW#^tjFl
۽<x:0 C3s	6Q.xQBAuSFp?xWE5g&
@8]-tXN!LpAE,|c~焢p tQ'R9RQR4I@I

]ˈy> Z-v'MnpSwX}|P@ j-{K
Wt51Mtf6x#(
M7 0|[pVp^Yrp'>Fh}Zhcg;b;N	gD^8K[;Ծx720s<U{$Aǧ{XJpeuPف7n:rƴSِLTo[Èj-8@׮rwN`D6$j13(yr{(D^xbdИ;|A
X9${{hJ2Aoh.rekA@1?A
,װu4-;&OcV l
a	&'f4KW <
t<
)<<XwD
x9=1&B4V^hj8CYh::̀Ō )N)!cu4ՀJDy>,
	ɂ$n*޾ ڋn'<@j~@_>Q9%tYfϵhG'M:N7w"-'1],0{.|5 Ptc845SIf:x.ǽ\8֠FA6BWl0^m}(HC坷tSo<<ȋ+Ѓ9KUB*K*߁Ї"MJgLRa)ޝ&-%؀	`"OS#6q+A5Ȱ{(zV;KPBg<HJ[6%UW$!U}v@=tVP@GJIӃ'D>Ӌ\Ul][cZh|Dn$Vt
ՠduP0>.j=$x [
A!G 5Wu]چcB7@KYbW7fR؊3э
@CQ9 3pYd4XF@ ;| +7'oϤha4ȡ	sX$L(ՋCR(2p4T.&YRj uS`1zt5}ITm,vCM>wr
C~^N :tuKKF7Ei`?$p-2D)GV!K+=	M
 )W.kVOUj4h_>lȨKDPEJT+ԬeI[в^>uݭvBOk f?DJo
@jmAPh|(UR݀~%@z;9<>T7s9JPhuOGo}+ L6
!#pуw$Q:jpRQG>kSK9
HK<-V
u7"O 3
[{
f$ݮș;˓uG:	F:;x96M :Y`
<΃/D9XNkaZ
+QHP
Q܄	KfuV@@A)=Bt(JRt
0]0f~ιpf:,
ۿhfV2sf!uh:o
^j~qmJd;u;}q?tbr;_/k	h;5\Wv@	xsj}g[  G9n|Ѱ~<956nGپeDV<CdlE|FH	
ӍY\7x4}tIuB;27фt /*e2IUtB;}
5ZW|{~3 ]-5zK]2f+x%À
w8~w
}}-}rhTwwbYH])	D4[
mS}_4	L8}t%Gᜰ8*t<.];ڞ;2^\0!T	 , ~mm PrGې\1VO;bP}O;|Ԋ.x?dtSO<*6vUWtFܱtٹn+|N,}pÑԬF]S~BKD~I@UO̸>eAXYD8^?nE\6z@*UTb
ExZCtrlQr?ڀD+]ch	̈TokV1e/n;tu_1 `)AsUs>;+;76$upl>0m-)Enum|l
Z

uPi⿀ADPI32{wGs}Modu܇۶iuZA!ZodImohd;SviaK"dO'd`c*MRrsMvT	sVg$
Y{)3O7mapdlBiL a%;IPye[yuJr y EК-vlc֛Q؇a5
pkGL7)0Ii'I$AǄ*S'/M+kA Gj} lr8i FrLibraflCz Ȁ>w!tP-ʲe!c`lHo$]kAcl}$B)p-w0S:R1amF'M4pFbJu:-PVB<DOatט%oreft**zI^#==]ZW	6uO,9m	SƈBTkzh=k)c NEIKKERNEL{>PBz
M8V!@e/BKFTiwTrqslB0 	:.6aOl+i$=7P wpkfA|E*+uQfݝPeek/ /US1kMOCK%l E¹EyEiEE!d[ #r(!@^Rb	,647|ih`ȯŇ1:&:7@
*d`u;Q
] FhGdĢݛ̛؝
iH9 @`M-K3+(8`#  ^  Jw|113333333334334444$4(4 84D4H4P4T4\4`4s44L55566?7x7}777777778$8X8m8v888888;9C9999999::::0:?:Y:a:g:m:y:::::::::::5;;;;<B<i<<<<<<<=-=3=E=L=^=z======%>4>G>O>T>`>k>z>>>>>>>>???%?0?8?E?M?p?i??? fD0"0+0<0T00000011l1{11122)2:2B2I2O2`2k2r2x22222223333%3+313>3dS3k33333/@333334\44!4'4,4E4d4mcy44444444444ӎ5[5e5/}555555555666%6I6V6y666666$7,737]7777778)888899999 :::::::(;4;g;;<<<.=C=O=V=d==>'>S>[>{>>>>>???F'00n0006111
//282AZ2w222)22333+'O3bi)s33o8&4Fw=5u556=O6T6nw666!7h7p7u7{7777777%888]99;:Q:Ui]kex:imq:;A'00 408@0D0H0L0PX000k -P111142@2H2U2^2?3H4^4445555 6&6;6xS666677 7'7؂XDH(0P Q    $ : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          9s]   03/14/06YPO U(   2 G  N            N   U      WVS3    _3   G<t#<t
<t
<ti        	:  [^.$   _tIFXTPMDRV-MP-SEG32 v0.95 Copyright 2005, Infineon Technologies   QSR  .   .   3f.   f%  Ƈ  Ƈ  fǇ  J '     u#  f u   f u3P9   X   Z[YfQfSR3.     f t	   3   Zf[fYfQfRfS      f%    f             f3f[fZfYfQfRS          f%      .     .   u .    3     R   Q  .   t	  >   5     
  0  f t   u
  f JK   f u?   j
     `
    $u
   <
    $u
   (
  f3[fZfYÜVRSQW3f ?  f   5  ލ,  f 3f fǇ0    z  f W  f3ۊ  f@  ff ,      (  Gf \   57  4$f f+ffI߇Gf( \   5U  4$f( f+ffI߇Gf	 \   5~  4$f	 f+ffI߇Gf5  4$fG5  4$GffJrZ5  4$f5  4$5  4$G5  4$G5  4$G5  4$3
f f _Y[Z^<t.!   f3fRfQf%  ff`fʊfʰafʊff3fYfZfRQfSf%  ff+  ff<u9ff<u+ff<t<uff< uf3f 
f	 f  Cff[YfZfRfQf%  ff!`ffʰaffʰ f tf f3fYfZfRfQf3  fs*f fd f   f3   fs
fJuf f3fYfZfRfQf%  ff0ff3tf f ff3fYfZfRfQf%  ff&ff3f%  fʰ'ff%  ff3fYfZfRfQf%  ffpfʀfʰqfʊff3fYfZR.   ff3t2f2ff3ZR.   fZ VSRQf       	       fǇ0    tw> tr~ tl~ tf~ t`   ֋N^63f  f;s  uf
 4    f u  f u	2   f 
f f fǇ0    fظ   o  3fYZ[^QVSRf3ҷ  f      f      fu  f 8     fu  f   fuB&  f   f             $3   fu   f   f    @ pf	u    f   f um@   Jfu
o  :f
uJ)  f uf S  d  f uTƀtMt$8  2D$t$++ȋt$  '  f uƀt  f u      f  Z[^YVQt$L$	  f u	t$f3 Y^SRQf3F      f u7t      f u"3Ɋ    tff t  YZ[SQfR    3f  t tf;sf          fZY[fSQV3f 5    f uv  ^Yf[fSQ  Ƈ          Yf[fSQV3f 5  (  ^Yf[fSQVR    fS      f3ۈ    3f 5     f[  Z^Yf[fSQVR<    fS       f3ۈ  Ƈ  3f 5     .      f[  Z^Yf[fRfS     ff     f t     f f[fZfRfS     ff t   f t   g  f f[fZRfSf2 f  K   f u.   f nf3
f f f[Zf3f sf f f3f fRfQfrf
   fr
fJuf f3fYfZ RQ3Ҋ    t   f uOf        ;w(     f u  f t  f f YZS  s   f u+    frfrtDtt*<f :f 4f .؀f t#f t؀@f t
f	 tf
 [fSQV3f 5  ;   ^Yf[fSQV3f 5     f u5  f% tf ^Yf[RfSQf2 f {f u.   flf3
f f Yf[ZRf2 f A2f u.   fff3f Z QVR3f 5  ,  3f+HHdf u  c   f t	   f3Z^YQRS3f  .   7   f tZf tf f3[ZYf3Yf f sf3f3Bff rf3 Q."   tf  uf3   f      fr   fsfIuf3fP   m   fX."   tfYfPfSfQ."   tfC   fB   0   f '   fsfIu   ."   tffYf[fXp$
pqfSfp$
pfqf[.    tUf tJ   Y   fs
   3      9   fr
      3'     S'     [S'  #   [Ë%  t     %  t  '  $IFXTPMz       $IFXTPMFidk                                                                                                $IFXTPMBuf                                                                                                                                               fffsf fsf f
   fffff~fsf fsffffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsffffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsffffsf fsf f
   ffff~fsf fsffffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsffffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsffffsf fsf f  tf3f  fsf 9r!f   tf   f  fsf f~fsf fsfff%   ffCL  g.02f  fsf vrgf	  fsf  rRf  fsf 8r=f3  fsf gr(fH  fsf rf]  fsf f fsff@Cg&;f  fsf f  fsf f   u
tsf fsff  fsf Rf@Cg&;f  fsf zf   tt"ssŀ2ɀ@v8sf6  fsf  f@Cg&;f fsfs退@s,f~  fsf  f@Cg&;f fsfrBf  fsf pf  fsf  f   uf   t
f fsfr'@s+f  fsf f@Cg&;f fsf$fAg&$;g&$;fBf u
g&'g&'g&f fsffffsf fsf f$Agf&;@gf&$;f3f tf@f   ufAg&fffffsf fsf f   gf&gf&   f~fsfBgf&f uff~fsf fsf猸N匋 f
   "猸N匋f   ff  fsf f   uf  g&t猸N匋f  fsf 猸N匋f  fsf 猸N匋f  fsf 猸N匋f  fsf f%  fsf 猸N匋fN  fsf A	o猸N匋fw  fsf o	F猸	N匋f  fsf 	猸N匋f  fsf U猸N匋f  fsf 猸N匋f  fsf *猸N匋fD  fsf y猸N匋fm  fsf P猸N匋f3f  fsf $猸N匋f  fsf f  fsf C
f: f	"f   f  fsf f   uf  g&tfffsf fsf f   f   f`  fsf f~fsf|  fsf 
A猸N匋f4Lf  gf&f Lgf&fffƌF  g.fLg&g&'g&f  fsf (1猸N匋f	  fsf 
猸N匋f2  fsf 	猸 N匋fT  fsf _i猸!N匋f}  fsf 猸"N匋f  fsf 猸#N匋f  fsf 猸$N匋f  fsf u猸%N匋f  fsf !猸&N匋f'  fsf "猸'N匋fI  fsf G猸(N匋fk  fsf  猸)N匋f  fsf &猸0N匋f   uf  fsf "猸1N匋f  fsf !猸2N匋f  fsf &猸3N匋Ћ猸4N匋f-  fsf &猸5N匋fO  fsf 猸6N匋fq  fsf &猸7N匋f  fsf "'猸N匋 f%"f   t
fC1'1焋儺N匋f  f  fsf tv$f  f  fsf f  f+  fsf f  fH  fsf tf  f    ff   ff  fIuf  f  fsf 4f fsff   f  ff   f  fsf tff   f  fsf Gf   tff̀   f Ag&u\f"   fsf %r8u=f=   fsf %u$f3f   u
ffuf  tf fsffLg&   f  tfOg& t'f   tfOg& tfOg& f  f   fsf $f  f   fsf f  f!  fsf f  f.!  fsf f  f    ff   ff  fIu fLg&  f fsff   fuff!  fsf $t,f!  fsf g$8uf   uffuf fsfff   ftf!  fsf $$tf@ff  uf fsfff   ftIfA"  fsf #$<t,<t2fe"  fsf #uf	ff	ff  uf fsfff   ft+
f"  fsf ^#<t<tf
ff
ff  uf fsf8f   ftf
#  fsf 
#t"ff  uf  tuf fsffffsf fsf ff @  f   fy#  fsf h$t5<w&t<u ff @  ff    ff fF  f~fsfffsf fsf ff   f f$  fsf "2ff fff+ffƔF  g.f9$  fsf !<  ff `  ffg.:w%g.Ffn$  fsf !<  g.:Gv;fffcff `  f    f;thff `  ffff  "ffftfu	f   	f    f %  fsf 'f~fsf fsff3fF  ff `  f
fg.ff   2ff   f   ft6fr%  fsf  < tff8fsftff  uffff fsff3fF  ff `  f
fg.ff   2ff   ft,f	&  fsf  < t8sfwff  uff ff fsff3fF  ff `  f
fg.ff   2ff   ft,f&  fsf < t8sfwff  uffff fsff   f    ft*f&  fsf $t<s
f   <tff  ufff fsff   ftfN'  fsf uff  uf fsffffsf fsf f3fF  ff `  f
fg.ff   2ff   ft,$f'  fsf =< t8sfw$ff  uf~fsffff fsffffsf fsf f3fF  ff `  f
fg.ff3f3f3f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t3f   t@ tf2L  g.;sf3tff  T2fffff  f~fsff fsf3f   fu5f	ftfftf
fF  2ffg.<u f  t2kf  uff  uf)  fsf ,uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsffffsf fsf f   f    f   f*  fsf f    f    3f   ftf*  fsf fftf*  fsf fftf*  fsf fftf+  fsf 8uf Bgf&'gf&f   4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   f~fsf fsffffsf fsf fLf   f3f3ftx2f+  fsf At	ffff+  fsf <	rLаf,  fsf <
r1$,
	
2g&	ff  rf~fsff fsff   f},  fsf d稀uxf   f   f   tf    f   f    f   f   f  uf3f   uf   f   uf3 f   u|f   tf   f   f   tf   uVf   f   Hf   f   f  uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsffffsf fsf fLf3g&f   fu	ffff+L  fg.f	ftf	f~fsf fsffffsf fsf fffsf fsf f3fLg&'sf   f   f}.  fsf f%   f	ff Lgf&ffft
ft f Lgf&ff%ff  ff% `  f
ffff; ffgf&f L fffsf fsf f  f1/  fsf $f  fN/  fsf nf~fsfgf&fff   gf&f   gf&'jf~fsf~fsf fsffffsf fsf f Lgf&fff Lgf&fpfffL  ftfL  fthf%0  fsf {f Lgf&fffK  tffK  t+f Lgf&fpfffy0  fsf f~fsf fsff|Cg&'g&fCg&'g&f`Cg&'g&flCg&' fCg&' f0  fsf f0  fsf f1  fsf 4f fsffBgf&f   fC1  fsf < u	f   u}fc1  fsf Zf@Cg&fCg&fBg&$g&_
ófAg&G$fAg&_
óix 5f@Cg& 5fCg& 5fB$g&'g&g&gg&_ fA$g&gg&GfAg&gg&_f$Agf&@fAgf&@f$Agf&'fAgf&'fKgf&f fsffBg&'g& ff% `  f
fF  ffgf.gf.Vf Cf   gf&gf&Ggf&   gf&   ff fsff(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f fsff30t
0t}fRL  ffg.fDg&1fjL  ffffg.fDg&g.FfDg&f3fF  0t	fffffffsf fsf ffDf   g.g&ff0   fDf   g.g&ff0   f[J  f~fsff Ef   gf.f@   ffffsf fsf f[H  ffffsf fsf f   gf.f~fsf~fsf0   ff@tf Efǀ   fI  f   gf.f Dgf&f%f
  gf&f Dgf&   f fsffff8Af   gf.ffAf   gf.f fsffffBf   gf.f fsff   fAg&' fAg&' ft#fffftf  ug&Pg&ff   tfAf  uf fsff@@gf&f0Bgf&f fsffffsf fsf f Agf&gf&'fAgf&gf&'f   tf Agf&   f6  fsf 
f6  fsf f6  fsf ff%   ffftfftfffff~fsfffsf fsf ff%   fffffff ffffffAgf&'gf&	fAgf&'gf&	f   ff% `  f= @  ufCfffAgf&'gf&	fAgf&'gf&	fAgf&'gf&  t fAgf&'gf&  t f3f Lg&$<ufff% `  f= @  ufff%   ffg.:L  fAgf&'g&	fAgf&'g&	f~fsfffsf fsf f3fff fff8ffff   fff  f
fff   fff `  f @  rf   fAgf&' gf&	fAgf&' gf&	ff% `  2f=    r\tfffsf fsf fLg&%f   ؃ ttKu
fuff~fsffAgf&'?gf&	fAgf&'?gf&	fAgf&'fAgf&'fAgf&f%   f
ff `  f
f  f tfw  ftf,  ff3 f+ff3ff%  ff `  ffFL  fgf.ffAgf&'   gf&	fAgf&'   gf&	f~fsf fsff$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f fsffffsf fsf fdAgf&   fAgf&   fLf3g&f   f=  f=  fffsf fsf f fff+L  fg.f   uf   t	f   ugf.zg&'gf.:g&'ff	ftf	gf.:g&'ff~fsfffsf fsf ffff/L  fg.f	fu$f	gf.>g&ff~fsfffsf fsf if    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsffffsf fsf fff  f~fsfAff%  f   g&t3fAg&f   tf   fp=  fsf LՋf   f=  fsf V֨t	 v  v f   f=  fsf f~fsf fsf AAAAAAAAA	AAAfBgf&f%?f
 
  gf&fBgf&gf&gf&Pgf&fBf  ugf&   	gf&   f   ugf&   @	gf&   f  tf$Agf&   f   tfAgf&   f fsffBgf&@@  gf&   ff%f=  tfhAg&gfAg&gfF  ff%   fffhAgf.gf&'  gf&	fAgf&'  gf&	fgf.flAgf&'gf&	fAgf&'gf&	f fsffAg&' gf&0fAg&' g&0f$Agf&   fAgf&   fD@gf& f fsffBgf&'?gf&  fBg&@f Bgf&'gf&  ! f$Bgf&'gf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsff3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f    fŀ   uf   f   tf   fgf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f uf=   u fffsf fsf ff   ffAff~fs@f   tfffsf fsf f   t
 
 fgf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfgf&f~fsf Bgf&'gf&   f   f   tf 8  ffgf&f Bgf&'gf&   fgf&f}ifAfC  fffgf.~gf.6g&? tg&g&&fAuf   t2f   uf8tf   tfff fsf AAAAAAAAf Bf   tgf&'gf&   f3D  fsf 1f@@gf&'f0Bgf&'f8Bgf&'gf& f fsffAf   tg&f   tg&fAf   tg&f   tg&f fsff   uf   f   f Agf&'gf&	fAgf&'gf&	f fsff Bgf&   f fsff Dgf&'f fsffBgf&   fDgf&f Dgf&   f   fE  fsf Y<twf Bg&$uf Dgf&`f fsff  fE  fsf $f  fE  fsf f fsf fŀ   u<f fsffffsf fsf  fff.FffH $ttf~fsf fsf䐕 	
P`=P0E       I   &&&&&&&&""""""""333333333333333333333333DDDDDDDDDDDDDDDDDDDD        """""                                  DD D DDDDD D D DDDDD D DDD D DDDDD D D DDDDD D DDDDDDD D  DDDDDD D  D DDDDDDDD D  DDDDDD D  D DD3333 3333 3333 3333 3333DDDD DDDD DDDD DDDD DDDD    " " " " "                                                                		


 "$&(*-049		



!#&)-159?


!#%')(*,.02 !"#$%&'()+-/13579;=  	

	

 	
	



"%(+/258;>>>>>>		


"%(+/258;>>>>>>		


 "$&(*-049		



!#&)-159?                                                                                                    @                               "3D  , 0  @  P   P Q  P U  P      P    P       P    P       Pfffsf fsf f Lgf&ffff% `  f
f;|ff% `  ff% `  fff~fsf fsffffsf fsf 
f  fEM  fsf w3f   f`M  fsf $< t<tM<t! <sfNgf&f   t&f   fM  fsf 3$p2<u f   fM  fsf 
Ɗ< ufLg&'fNgf&f   uc   ff% `  f= @   f=    tf Lgf&f#f Lgf&ffufLg&'fu_f   fuN  fsf f
   fffsf fsf ff   fN  fsf Qf~fsf  fN  fsf %f  fN  fsf Yó fNgf&f   t@&f   f$O  fsf $p2<uf  fJO  fsf $
f  fgO  fsf Uf  fO  fsf aĳ

f  fO  fsf Àf  fO  fsf Àf  fO  fsf f~fsf fsfnnfLg&n,e P4 fP% f-P u<P t~ff%   f~ff#ffnf   ff   2fff   ff3Q.7t[f.;|uf.;Duf   f   f30fy   f  f\0fnf30f   f3f30f   f   2	Q	e	u           p                        ݬ<DVa&Xfeb&pTGJJo8tn0x
اk-vr׆]s~wύv"0?q&׹8E8.Γu^FT88EQT,{-h'=	0.9#M#*`>L|5
$2/#R;1&k댁V;#Bpԟca!
,w;?j͊\&l/#-aRK!lޙG0L 9lǍ'pJmԸ
A̛W02>@1/.0@#y5w۹_>#Y^4T/?Uu1~:w؋J_57HOן*WAcc#Fi5ݿBBEY8bm]Q| Ѝ|Tdr[WbejxSbHOz͙:k]ܣ~z$oHb)~ے)؉zkڢѴIdDLjĐ3Ul ϱH	LlYXܕDu 5zȝ]
㊤Or=U6w/tyvj5{^q.w䥦`aZhw$,1Yޚ| *IR1)y3\3B}$I42*eFƭ{]=GoU hT>>P<1qJ`𤛴a!f8]Ws
|
|~y4Й:)7%غs4<DǡhIs@!ACCsZd}O>A>l0[7VxJ}DDi~Y>y/UWNݽm	kWD7 #!%(5	>߄
P(XL|AKTtBb>~=t^))>=r1`Pd(sE-PۄZM6lL	Y)`)z_)V/lZ Yɥ8ֲAyc]ڇVc)杈"g9X>JPAݪ2w->HЀ5wj飏F\@UB]G䟞C1fiO=OTeUӺmgIaaђz}E}ۙ%Rǅ/9)6R !t6%eu:g8εUYLʽ *KQiBmߗK"RjT,f)=@3u	vr~!L1ȑXuѬ5֏__(`G#InZ^D17db@]Į_YH^ߔf3.0گ,1ie`e3Nx(z $Cn	p'VE=FqF6M-[JpӒ]Ϝ,4 $2S1 )RFЂ͘MF j}à;5߹cӂ=J.U>4,7f 7(J_HP<vפ͈E/qRQn8sT6CɊaO4K}
s?ྻo'Կu\:O=ԌR̀Wʿ+GEs&kSƺ0ӖѰqv
Ύxb9]p8@v6=2E<a76еyV*7=# 26kFZ">^/<33xN<o~+A@Z(3-҄@&)6ˮңڬg'YN۠,ߐ/
,!=iC؇*P5'KOWdŪ'ۺۂ-LP;6Bػ5i7ѐ4$yw~(n
Y}@>Y%c0dŵp)پ"$q=F\^jM',0K֟퟾j65e_TtrE:>hhơ!
H>.ٍx! rhuv]"_$|4&ʯ&xlY46ɷoHvq{2ٓ~)@7y"Tېe# 轅Z
j4Oj2r`&E- !Z̸0oy2ɞ{=da~;Fھ<C]ã#ww$D2a\
<r82LtĀ%\ڇր0U#+PUH2p2{=<?:=Se+
PVC&׍٢6PHY^ L_,4
S]&$7"ʻxF[ؓ y4xJQʒo{Hyԏ4/taIzG)'<
[D2ikd8Rm6t+A@_x?[bʄzJ5)'%L:i-%}8z?;IꪟM#qPk-ҳaӖ05*_Ep/ӼȽH2#h&Aiϒ <Sq '99{v] &``4
=//=M9M:$q&'>ޣtRք~	a-14D0.2!ӻaSOMeHwș !QUXY1#@:yEX:Fuf;h2
%?v&wLC'?Q, 1Nʠ2#,C,/v!#)=mU }Z]҅ՄQ7œaO5Qٕ"!A
nrZg9_
y0,`EVDRIsӇ<?]h(tce	.߲qOÜś:$5Ȅ~:mpǺ,罛Ą,}&|]%Km/=ޞx.r'j͙(mEU 4M__sx,nQrQp[3a=71ިԟ7U6* 2,nַ)lP9u_Bl<ĕ%`6+ЩPXQ*ize3eS7~[,6dB|XCQnwKx 2vS~'ZUz_Ϲ,7PlVȴjO<a5 aIYIpP{ҝi6!f|b
20iEC-q( |FX⬍@O@𙃙{2}-ɹ*x8F-_ª 3y'"u/q;

3#iÞ!5zٙ̀ֱnY~#8YIVtdQ6)4.ܡ>i|6a18^K/ D_uT
S_9mwֽ\sKxg2ֈ qIآwj7@VaLBϑ ;7`	9 d`DGX]<(;}(IEdS[q5pk>bT'lgeg%U@o(Ba}IḺ25QED2M1"WUryžVCFVQsfTU*KTК53frP(kr(x{ZA'ʳj0Ĭ׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H   &      9!                        9dcNsC?Ɗgivꪪ\3/u`@tI}"
U|5<
=u@jD 7s޵
'ch
YMdu|m!f^c;ܾRzwk|}Z
- 5
L+ٰҮ>4(84 i4wwE~	_&?YmKot5#%Ot<'UݱF̏|>\+
ͮ:Ar*,)yթlh9Z+	J.n3VqH5&,
c^Ǆ*Љ!,wAQ6QT^_UwjiqPke{sy6Ghs50oz>FN%,A|Lg'<'Nb:ZL"Xv?~~vj>Wam C)V.%L	Z_
Kq)m칝(.;]|crbƶKfjQk{_P˨ĿNl(|o=v'|/zkIW$ͦ}]P%b͔U@Se]Cj&#(h>C5OPM'j	Zr3ZtxnRfﰘ_VV]Fʐ^J Yi?KyE<$FE jW&yN2ɑ}8k3B׊̏^+nhx|P,GίaT߳M)Ki=?04hqio6}Sib
rH_xb2cY*kN<%Y{uU<k.u윺rRܔ8hZ0Qu![}(OO#|yR	
G/26I:=bL*vG6vnoSrϪQ1A9pӄj7ZXvoOCT% e|1ǶHk9[E}X<׆9L%TKx_z?6	lD878t6PK/<kxX4Ǳo>[A
O@F.8?x(m-	!F$##:J5VBߛ$9qjP<Gx}_>NEY)Guu`wH{
v}q,˶w*жR.f[R¢R_&]p9J	aa慝"4pst	
ǿp\,9xV	Kl6c
?
pKkB@|m2iCW-
Уɡ%*:g-w@N;-
vOƖQ"zjy
!FltL>8?ۊ{GWѷ~D9kDw7'N35a#I,CBir.LA¤?e/̗)ف`Y6)_be;
9z8ı;Db
L=mGH3T*K&}xq(*wNM"`D_^w;tY$JLb5p/=ioPѐU(j
$D߈cO)oHS҃k»AT_!C=֚aVK~dr.$ƿ޲i)PA$6 
Re6B4	fuSG{Tf>|=FJla0:=Ǖy(	䧰OWAgNL\ѬwgII%+]Cg2okKv]qVx1LU9.ࢅ;>-0w,kP`po7QmRog&ِa"
jBS>.*'rxq°uߘa6>DKi]mGCG9n$^49&PV%?Iҩ1?zL:^-D6+4/ORČG<?ț;Rz!#axwsq}Ц
i5?ژe1o\Rul?vƻKr֒U+#3o9bE<"M]T P!BL
$Ktfo78L_le$<58A#'N%8ZA5kO>ގj>(vvp#) U!I q fuҫgkPoHp<hHc4ۭ'
%.}JTxL۷Hսǃ5fO-V!-WȌz}Q 
Y_O!1UÙ*qj=-+S!=7:7=s"~rt^8C tbo{\\Аj9, K,B'hWVqh^pFk4 1'h&
z^\A9:2w+2e3o^Za85CEd&_VC%}:,88%!qI$-5[Cc:'ȵX&WbWe`9Be
i729%C|~ʿ%^CfΌ65O*S	mF&"JduVѿ}\RK[C2qjt&{_G4Qk߹\3k4Fֳ=)hd{7~#-x>%}E={s^Fa85;k*|h%~Vf9n/8`*KsPu+t "th%EJ;6=kׁ˷x.a*[YWC[P$L"#g~+FXjaE=	FiYBSvo#0 PTWgJeJyw@&kY嚈i&˹ἽW&TrCMex#bA8J$2(ء>ܹP\3-ue긖-k׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H   9                               &`"L1^9M|ȵ-M0%V\FWFVՄI/N#~j0
\3GVcz7PAF
͹"MWa
&i,#,γŔ(4İٖD'9m	yι7sM'pUgrDkA[JN

΂5hqYTV?z2oKqYs!Ј]vFwl|g<۲^пIS!A w`J_
s
	_KPP{V+{+~6ooXi(?>ֻ>aPU|G)XbHc!d[bcSy,\ޜ~N
_Y
(V,HgRQк'XS#@K^alf\г EW"YFh&}=tU@	5syz[s~q]To,M[
$+X)f7ꛮm$TȪ~%<?ԐBR4Fvc߬znuNax$iZDxoI:'0"֖߫S-ӭa;ya
"|4'",wK(`sRO8YZD۩|;ȱ84h$]DVJ^:F]^H.jc@> >޿K8f^ u.I(֜SM8rն{~Z/,ATOk@**El_}#	;l}(QS[!8}TeiԔv2ʄ"y,^묆-+oXÄcXAJ<H_|+f"́&DsKƵ+8l~cr+$@m#%LCh.E"s&7}8emg-ϧKv1T}QR5BaiN*W?[3F	߆1,Hb'EBޒ_s6v>i Iċ"#k/SԋOm#,\䎧ܿT0Hͩc,#rд~!Q^GhMm_[` npkm4R{`Y;/ 2NS\
Ub2y,PP"d1-y(Q
ЯJg q=`*q̼F4-|^ŵ_~ExcJ3'tfW8;("x (,Đ<rC֓Ftu0ls,LS5mWg$EكGf%f9l ڀzFM[9p06LMVP4SX>~?%Jcg~qc6XFO4U*a`ɣe /t-zc`|QMe鎝jz#̗~k\&hFq0l%F#l`;TsC lk+O[>T##G 'j/q>8[6ie>::D#.2" K6ɥ馺t6`6IQO"ɆLb]LE}}cPgҝ靼` U"ܖ6Cg#OJ
j\CidyfuB+^zp~&$`!}_+@P0oBCO3'Oh@ONpU5ه y
T)ئqmո.a8DߗF#7!m
0`/[uٓj8ehxy8j
L>GgoO.8g6Ɇ~7GG#2g^	D/W/J	OlKت(x՞s?0I+֧xa}*b>$V{=[u[_6mRn>*YZBn&Z*Oy$$d1rW|/c ,&\>W]~:xjM=я&
/Ը]U"=!9a!Cʄ1Fp.\^7\lUI#ȆN
%â)-)Cdg*cFQ׾F'E7lU\=|8|5embBA$!}!4o|4řb??R
)g`t,t.VثbkHdT`pQ_PT<q%툐H.
7SVsh:nIs?$jL- D^t6.W?d$xHGʏ\պH|lEk#[{68C~U#+7X
]v&e*%[GDmg*	QIf*W>jLNJXSbZi~`5={
.$	tRbN0z_hTw(# T<NXQ[16;6Ƒ{-tr1Bw8.rXX3HK(͉r.J
%ah5$3~Ԅo,-D#zI7[z;3sD^>$έ^si
Ad9dttQQz@0cZ|f-]>И'?|@ٓN=;Dt~y8`mSѬ7}'CޞK0po/8_ߑ]66Sbu:	Z?xqLGO&jM@cNbBjfo[Z*cs$ʻ߆g70N]Ɯ~h	.HyWٞ21<AbZĜqZC(}dq[eTsٹYqލ@nP.BU"z(Qb[ pE0GH	ѿ2Ƭ񃄗Sf	wS:}$AL.M4Ys%ȯH0[׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H       68YOP   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    焋猰怺N匋 S D[$4sDf    QsY 焋猰怺N匋f  ff  f   tf ff  rfBY 焋猰怺N匋nSC[Yf3gCf3f   焋猰怺N匋8fHrNf f焋猰怺N匋P3f焋猰怺N匋 ArfFf    焋猰怺N匋 焋猰怺N匋 39f  f   f焋猰怺N匋~ fSN<f[f   f   3f   f  焋猰怺N匋f?  u8 g&<fFfCg焋猰怺N匋 9K;s 撰PSRغúZ[XfPfSfQf   fQf3یff  1fYsfYf[fXSgu  ;u[fPfSfQfRfWf   f3یff  	 1fBf   f3g}    fg  r%fG;wg}  f_fZfYf[fX D  @    L      @       H   H       `       T  	L!	> @
$  	>         		       
H@,@      ā    Ё    (            $    (    4    8           @      
B  T     L     D    P   X     `  D    X      P    h     `               	 J             
  @      I         	  	4@	04
    	' 
 
> 
H> 
> 
N> 4    	1 	 4	$	  	  	  	  	 
H1 
F1 
1 " 
D1e  
1   
B1  
@1DD
# 	P 	          @  4 >       	4		 		0   4      @ 	
. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L          	         0    4                                          d  ` h   X  '      @        A   \   Z 	  X 	     ? \   Z 	  X       ? \   Z 	  X 	     ?                                        '     >      8   ,d      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N    T           0           N U N 0 O Q  N 7 O  N  <GfUGf%f  $f$
tppqt  u!tppq tppq tfƴfupppppqz	ffupppppqf  f  gffLggf^gfngnff   Κf?]fupppppq ؎gf
  ffu'fupppppqg-  fffff  @$f@$
= u$<T)fff  @$f@$
и f  D$fD$
аf5gf% = ufQKf ff6f %  ffU../0./.	/`./a. /0./. B쨀u?fֶf d< uffd< t<t
u掰ff䎊f+qff=_f掺<ufa;fk  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NONt;$`<`uB  0
BJ<Zu$BJ<u !N BJ<t3 `BJaBJt$t?t;$`<`uB  غ0
BJ<Zu$BJ<u !N BJ<t3 `BJaBJt$Ë怺Nt'ط$0<:r tuݰ t tf gf&   ufT  g&'g& ^@'f3
f  i t
^
ppq<&uf  $f$
tpqq$q
p&q+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  $f$
а f  $f$
и f  $f$
аf  $f$
аf  $f$
и<f  ff| ff  @$f@$
= uQf  ff ff4g&`g&&g&f  H$fH$
и f  L$fL$
а08fffUN&N䄰`O'N䄰ONtf  ff ff  ffL f N U
BJ<Zt. U
BJ<Z B0JBJU0
BJ<Z0BTJ1BJ2BJ3BJ4BJ5BJ7BJ B$JB$J&B J'B JB$JBJ(B J$BJLN33LN3N BJ<uj"BJ&BJ)BJBJ`BJaBJ0BJ)BJtB B tf  ff    f8fff ff  ^f gf&   uf  A對 f    < tg                                       	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  8. C vZ[XPSR (-Z[XPSR  	. C v
 -Z[XfPf   .>ƾu	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
˾D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4ʾ Ⱦf`  fg&Ft+vugf&>tgf&6f٢ʾ &f+~f^Y[fXPSRfV  tA   % ˾g&ƅ    f  Ѿ\g&  	uf^Z[XPSRfV  tA   % ˾g&ƅ    f  Ѿg&  	uf^Z[XPSR   *  *Z[XSR  + C vZ[PSRRZZ[XÃ<t  *  u*  *PRt)t<ZXfPfSQfRV%R+  0+f3۹ f   gfdT gfdTgfdTgfdTf   *"UC v *  0 *qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $f[fc f	cfgfff]X t fffc f	cfgf  ff[f_f^fZY[fXRfŋӃf3ӃZfPSQ  )f" A vY[fXf` f;.¾t
f.¾ )  ) $C vf3 
 f    fgf&E   > uF f  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f  Ѿ < ߾ fK  پg&"  @v@ g&  s ߾fK  پ>ʾ u&g&.  ug&.  ug&/  uf^Z[XÃ t                          /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         焋猰怺N匋儽39	焋猰怺N匋儽S갲f_=fi)簳fu'f谴ffہff f%"fft鰷ffff >밹f
fJt;$`<`uB  fb:f f
   `"	f   f3f30f  0ffcBf   f f    0f  f f   0fffP  0f  f   f    0f  f f   0	 f%"fff.f.  f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f. f  
f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
                                   "                               @  
     @  
 Uf`ircgf&=  f  gf&f  fffFffFff^fF   f  f  f^fF   faUf`f  / gf&Fp  gf&F    gf&F`  fgf&~f1  gf.>f  fffFffFff~fF   f   f  f~fF   fVf   f  fVf  0 f    gf&f^f   f6  f    
ff  0 f   gf&f^f   f(  f~fF"   fF   3f~gf ulfVfOLPHsf  . ff  ! f  ! f   f6  
ff4 0  gf&f^f   f(  f~fF"   fF    f  g&]
  t
ucgf&  f% f   uLf   fJ  f~fF   fF   g f   fV  f~fF   fF   A faú`U` B<u(``B`apB`0B`f` f"$(  ؎Њf      f%"H 3؎faUf`f   f"  ؎ff3Ҍffh f  fPg6D* gf6|*fg6l* f%" 3؎ffa          PȎf   > ttus>   8  >rfg   ( r  
Z>Qff@>7fffrfff> wf   >ff%fAfff> trf> wf   >F>,'q>hff   fJ>A0>'>
ff  > ff'fr$fff> trf> wѰf      >uug>u`RF
 D>u=좾/>u(f V  >	r  H 
s 撰t Xix֒(Ba׈ע׼BPVk؀؎أؿfSgef[gefPfR>u
.fZfXfSfR$$8u4@fZf[P$4XfPfSfRf@
 > u= 4t:sfZf[fXË.usfZf[fXPR tċZXfSfRf@
 > uA :H@ts*؃,-@us.fZf[R쨜u	u
sZ               p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`>̾ tVg&4  g&;  ĀuH g&  v̾ f  G\ \f  HȾfaPSQVۋL	;t	   ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 ;f6s>;t fafWf   g&D= g&D= f_`r r8 a`f  gF
$&ξ
gF
&ξTsw>;taf`f  gF
$&о
gF
&оs@f  g&|5  t>;tVfarfWr<f_    f`fyݴf   g&D= (fgf&T=fg&D=rL6ƾƾ G ƾr6QfPf   f>yݹ gf&D5 gf&fff>yfXYsufa`f   &ξ gF
$
gF
f   #sF>;tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva f
   `"	f3f3f   0 f%"	@ ttu!  
s3ig&+g&ô b uR Zt
s+R Z<u+R Z<u<uR  ZfSf. g;xxf[ú          Tf  ?   f
  +   f     f2    f   fHt	f쨎tf<w' H$tt
ffPf fЀfXfPf%  0ffXfPg& g&gf&{gf&CXg&Cg&CXg&Cg&Cg&#sPRZXPRZXgfgfgfgf&Gfo  f  gf{Tf3f  Ag&Kgf;gftf  rf=o  t
gf{Tg&s g&C   PJ R  o  D  o  C  o           f`ffWgfǃ  #Eggfǃ  gfǃ  ܺgfǃ  vT2gfǃ  gf  gƃ   g  u	f@w4  f@f@f_gf   gffgffaf`fQgf;gdg&fGfXf7   f;wf+f@   f+f7g  f3ggf  fffgffgf&faf@   g  tf@gf3g  gf   f` gffgf@ ffgffgf3fgf3fgf3fgf@rfaf`gf  gf  f   gf3fSgf  gf  gf  wff#ff#ffyZ?'wf3f3fn,;wfPf#f#ffXf#ffܼf3f3fbf[gf  fgf   gf  fffPgf  gf  gf  gf  gf  fgf  gf  gf  fXgf  AP
gf  gf   gfgf&ffa  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   ge f   ge   f ge f    f ge f   ge fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgQf  g'gGgf_Z1`1 fPfQfWfR3 .;t3fZf_fYfXðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPS, R Z؀ˀR úZ1,[XRPSQf  $f$
а)    Y[XZQ3쨀tY    .fV<t.f^ø f^fSQt^  r\fSfUUgef*geUfUUgefUUgef*geUf[gePfp  brge<u   Yf[fStCPfSfUUgef*geUfUUgef[Xgef   rge8u   f[fSfQfR.t_r igegeP t>ge2 ge   fgepgeufJu#$:< ugege<uf   Iu 	geP  fZfYf[gegePge  ge   fgepgeufJu$:< ugege<u 	geP  fSfQX tGgegePge@ ge   fgepgeufIu$ugege8u   fYf[P>t	f  s>tf  r	f r2< X            f  / fP  fPQgf0f  f    n YfXf    fPSfRff  ! gf&V2gf&;Ftg&~ u
u
gf&vfgf&NfZ[fXgf~gfNgfVgfUqfPfSfQfW<w#f.
tff_fYf[fX焋猰怺N匋fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fXfQfWfVf @  f   f  gff^f_fYfQfWfVf   f    f  gff^f_fY             PUN
NNOపNzXfPR3t3$UNN<Uu#NNO<u N҉ZfXfPQRU0
BJ<ZtN BJ<tW0
BJ<Zu$BJ<u !N BJ<t3 `BJaBJt$w u-1u&UNN<Uu$NNO<u Nu3҉t;B B t	 ZYfXPRt ZX                                Q  YPSR+;wZ[Xf> tftf`f  
tf  f    f3f3f3f @ gfffCgftftfaf   {fuQYfVfSfQf  f   frffYf[f^0123456789ABCDEFPfSg.<$t)Cf[XP

XfSQRf   Ѓ.ZYf[PSQ؊Y[XfPfSQfع fYf[fX                      0 ] )PS㋇$ *"[XPSQRW0  	3-   3   3_ZY[XPSȎػ        !     A    f    $          [XR $# &1 (ZSQW   \ _Y[SQW   G _Y[SQW   2 _Y[   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     2ø     焋猰怺N匋3ظ  м{ 4f
ffff0lf9         ~  @     %03/01/xxYPOH  @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff0  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        08/31/04BSA  ACFG      @   
         @                      @    a    p r  s    `  d    
     
    xx        I       " D b e t u v w         P @`     o  BL @ ?  
 
  
  @ @
  A 

  @ k     @ `       ACFG           BL      :  q @ 
  
  P    ACFG            q      3  q @      ACFG           q      j  q @        4  k  4   4  0ACFG           8q   9q   :q   ;q      M  x] @   k  0 0@0`00000  ACFG           @x]      J   @   
  A 
 A@ 
 A  k   ACFG           H      RH       K @      ACFG           `K          H      3  K @      ACFG           `K      'u    +   3      h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             >>>>>>    >>G9戰 䈴^.d  戰䈰p  qذp  $撰 q	u	.. 戰䈀
t2K
r 2.$@ 戰
䈸@ ؾg ,戰䈰  戰a$apf.f. f"f  "u3g=r  4t3gr   ۰ 4怎    
 JvY6 5x          (A                                                                                                     M             f fffýq                    u׾$.   $.   u戰f @KC8BBaaff fKua$aff fKuf f u                è  Ӌ  è        è  VQD   `  è  aE       Y^Ͱ   è  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%      X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aË                              @   `$ff`$
ff     $ff$
ff?fظ   f$f$
fff
 ff fIf uff32fIf u߸   $ff$
fffظ   f$f$
ff   ffTCA6C @ @      Pff    t     t  g   $ff$
Њɀ`}  f   v$ffv$
$
Êظ   v$ffv$
Њ g   $ff$
Њɀ`}  3  G     ff	  2
   0 %" %
   @"	  2%0   W$ffW$
$$ظ   W$ffW$
Њ   Y$ffY$
$ظ   Y$ffY$
ЊZ   $ff$
$̊ظ   $ff$
Њ_~   z$ffz$
${ظ   z$ffz$
Њ   W$ffW$
$ظ   W$ffW$
Њ   z$ffz$
ظ   z$ffz$
Њ3.*w
  3333333!33.SN
  _Q
     <   f ffAfff   t^
  uF   u  8~"`   u  8~  8~  8~ fFf$   t8~8eZ33fffAf fffuu.z'  >*  <|S~  <duC
  f<tf<tf<t
f< tf3  <t2fFfa  uf  uft@t
@t@t
@   t   t   t   tø   iff% ~
    ~
  ( ~
   ~
   ~
   ~
   fˋظ   iff   f$f$
ff   lff% f ~~	
  
   
~
    ȸ   lff   f$f$
ff6f` fe  ff`f ffu"f߸   $ff$
а fGf߷   $ff$
Њ   v$ffv$
$ ظ   v$ffv$
Њ    ff fIf uff32   v$ffv$
$@ظ   v$ffv$
Њ       v$ffv$
$ظ   v$ffv$
Њf     ff fIf uff32fIf uڸ   v$ffv$
$`ظ   v$ffv$
Њ   t?   v$ffv$
ظ   v$ffv$
Њ  ?   v$ffv$
$ظ   v$ffv$
Њ(      v$ffv$
$ظ   v$ffv$
Њ    U   fUf@ f  gfUffIf u    =Uuff`f fff߸   $ff$
а fG=   ff   ff3   ff       ff    f` fa  f ff`ff$  f ff   tf$ft$
ff   y$ffy$
f
ظ   y$ffy$
Њ           <                  <  f߷   $ff$
Њf ff   tf$ft$
ff                 <K            <:  f߷   $ff$
Њf3۸   tf$ft$
ff          <   f߷   $ff$
Њf f   tf$ft$
ff   y$ffy$
f"ظ   y$ffy$
Њ                       <t?<tG<tIf߸   $ff$
а fG"  
 ff`и   $ff$
Њ2ffu   fffËظ   `ff   ffǋfËظ   dff   tf$ft$
ff   ff   ff&3fb ffAf ffuRffI   $ff$
؊fA   f$f$
fffGfGfFfu  .      ȴ      2ff Ȁ2fOf   $ff$
ffGf   $ff$
ЊfufGf   $ff$
ЊffGf32Ҷ
uf
 		uf utt
ffffAfff2ff#   t$fft$
ffظ   tf$ft$
fffFf   e$ffe$
ظ   f$fff$
Њ   g$ffg$
Њ   x$ffx$
ff܊
؀f} f}f}   xf$fx$
ff   Pfff܊ff?f f tfˀ    Pff   $ff$
$f tظ   $ff$
Њf4P%f @f@f@f@D f @t9t<u0f@f@D f @tt<u	f@ɀ u   3         P   +ȁ  X`   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_va.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  >>>>>>    >>G戰 䈽^ sRpqذp䄰 q
t23
r 2.$@ @ ؾg ,  a$apzffv ff怽kf.f. f"f  
1u3g=r  4t3gr   ۰ 4怎  `  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
It                         !          !          !          !                       p                                             F                 D  @        P      F      p  p      D           p      D          p      D  8         t      E         x      D  P              D                F  L            F  >              F  ,            F  >              F  >             E  @  <          F     `  8     F      L8     D  M         L8     D           L8     D          `8     F    d8     D           h8     D          t8     D     x     t8     D     x     8     D           8     D          8     D            8     D           8     F      ? ?   8     D          8     D           8     D           8     D          8     D  %                    !      9     F        9     D          9     D           @9     F        :     E           @;     F   P  >   ;     F   @     ;     D          ;     D          H;     F        ;     D          \;     F           `;     F     `      d;     F          |;     F        x;     F        X;     F          D4P        D6P     ?   D7P        EP        EP        EP        EP        E P      r  F(P      F,P        U         &                  '                    "                    #                    $                                         `                    a                    p                    t                                                                                                     0                                        `                    a          x          p                    t                                         0                    t                                        `                    a                    p                                        0                                        `                    a                    p                                                   N          0                                        p                                         0                                         p                    r                    0                                        `                     a          b          0                              	          `                     a                    0                                                  @     D           @     E            @     E   `        <@     D           @@     E     8    P@     E  B        P@     E     
   pqpqĊpqpqĊpqfĊpqĊpqffÎf ; @$f@$
и Pf ; $f$
и @f ; $f$
аf ; $f$
а P% = Af  ~$f~$
а pqU&' 	a` 0ᰪf   W$fW$
$f   W$fW$
Њf 8 $f$
а U0 W P4ffCf   fff%f   Pffff   `fff;f   dfffYf   hfffwf   lffff   tfffEf   W$fW$
ЊýNf   xffff   ʺ$f$
Ћf   $f$
Њ02ᰪf 8 $f$
а%@ 3f 8 d$fd$
аf 8 $f$
а3ɺ P  P Pf ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ fm ػ /fff ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ 8>n 戰 f%"f   2f%0 f
   `"	  "	f  2f%0f  2f%0f3f3fP  0fX  0fA0fh  0fAfm  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fn  ff0fA0f  2ff
   0	對㨀M04/08/xx HMZ        J&        1  F!  $  $  ~%  %   %  %  X&  .'  L'    


>  ~
z
                                                                                                                                                                                                                                                                                                                                                                                                                              U (VWvv4RPI0_^]U (VW_^]ÐU (VW.% =  u . =F_^]U (VW.% =  u .   .% =  uF20  _^]U E(VWNa_^]U -(VWv \>0 u_^]PQRSTUVW pq$@t$.>2 u .2>2 t 0   _^][[ZYXU 'VWF   FF% 9Fr
  P@  _^]U k'VWG
 Pp P@q P@''% % 
 Pq P@ Pp P@q P@F Pp P@q P~@((% 
@ Pq Pu@p PF   RPp PF P:@**% % P P1@F_^]ÐU &VWF
 Pp P@'% Pq P? Pp P?q P?F Pp P?(% Pq P?66p PTF*% P P?UF_^]ÐU %VWxPm?%PxPm?xPU?%PxPU?xP=?%PxP=?9RP2 PhxP?
 PxP?  % = | xP>
 PxP>
 PxP>
 PxP>
 PF  H xP>%PxP>% PxPj>
 PxPj> PF~}xP;>%PxP;>x Ps_^]ÐU $VW,BFVFVB9V} ~ 9Fw _^]ÐU W$VW  RP  RPvvVERP#FFVFVRP_^]ÐU $VWF% P P=F% P Pz= Pb=  _^]U #VWF% P PK=F% P P:=F% P P)=_^]U #VWF  + F% P_% =  t  
 PF~Z}   _^]U =#VWF% = u F% = t1 F% P}% =  u F% PF% P    _^]ÐU "VW P P P* P Pn P P% F Pt%  NF P P,F  _^]ÐU Y"VW P P P F% % P PMF% % P P9 P P P P_^]U !VW 
 Py   RPm_^]U !VW%PM   RPA_^]U !VW( nFFn=  u    RP
    _^]U O!VWFPT _^]U 1!VWF O^RPF^N؎&w&7>RP?FV=  t  uP FF;F|' F^N؎&w&7vv
7 aRP PBtRPF^N؎&w&7f>RP>FV=  t  uP FF;F|' F^N؎&w&7vv17 wRP P%RPF^N؎&w&7=RP=FV=  t  u
 ^& RPF^N؎&w&7=RP=FV=  t  u h RP&  PRPF^N؎&w&7,=RPH=FV=  t  u h RP{&  PF RPd&h RPW& PFF9F}_^]ÐU VWRPF% P P P P P P>% =  t RP  F    P% =  u 
 F~s P% r RPJ P^&  r RP' _ RP L RP 9 3RP & # =  u= u= u= u_^]ÐU VWRRPF
% P PF% P PwFn% =  u P P% =  t iRPI  F    Pk% =  u 
 F~s P% v yRP P^FF&r RP h RP U RP B RP / # =  u= u= u= u    _^]ÐU #VWRPEF% P P* P PF% P P P P% =  t 'RP  F    P% =  u 
 F~s Ph% b 7RP  r NRP _ gRPy L RPf 9 RPS & # =  u= u= u= u_^]U VWRP	F
% P PF% P PFn% =  u	^FF&% P P P P8% =  t RP  F    P% =  u 
 F~s P
% _ RPDr RP4 h "RP! U 5RP B SRP / # =  u= u= u= u    _^]ÐU VWrRPF  a F% Pvv=  u  \ ^&% =< t ~RPa9 RPORPBF~sRP(   _^]U VW PxP^2F    P>2F~2s PxP12  _^]ÐU VW_^]ÐU VW_^]ÐU oVW{_^]ÐU WVW_^]U CVWRPeF  >  P P=  u .  PFRPw% =  u  F~sRP	   _^]ÐU VWF  ;   P  P=  t!   PFRP% =  u  F~s   _^]U aVWFF F FRPs   RP  P P=  u  w   PFRP}% =  t  V    RP  P PFRP=  u  &   PFRP,% =  t     _^]U VWFF F F0RP  P P==  u  s   PFRP% =  t  R   P PFRP6=  u  0  Pw  PFRPp% =  t     _^]U VWKRP  P P=  u  g   PFRP% =  t  F FVFV  P Pvv  PFRP% =  u     _^]U 7VWeRPYF  FF% = |@ RP3  P0 P  PFRPX% =  t  F% = t   F  FF% = |  P  Pp Pb  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% % =  t     Q   _^]ÐU VWRP  P  P  PFRP8% =  t   F  FF% = |  P  Pp PY  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% %	 =  t     Q   _^]UL VWF  F  FȌRPRPF  F   P@ P  PFRP% =  t    P  PS  P  PE  P  P7  P P)FVFVF F  & F^N؎&% = u F
 F~wF% =  u~ u/   PD P  PFRPG% =  t  9  P Pvv  PFRP% =  t  F     Pp PN  PFRP% =  t     PFƌRP  PFRP% =  t   F% %@ =  t F% % =  u  t  
 F~se~t  S FFFȌRPFRPFRPv!vFȌRPRP
F9Fs  K  _^]ÐUJ yVWF  F  FʌRPk
RPF  F    P P  PFRP% =  t  lFVFƉVUF     P^ƎFȃF&% PF~ s  PFRP>% =  t  F      RPF  Pp Pl  PFRP% =  t     PFRP  PFRP% =  t   F% %  =  t 
 F~sp~t  e F% % =  u  O FFʌRPFRPFRPvF	vFʌRPRP5
F9Fs    _^]U VWRPF  >  P PQ=  u .  PFRP% =  u  F~s   _^]U -VW4RPOF  >  P P=  u .  PFRPa% =  u  F~s   _^]UL 
VWFF F F FF  F  FʌRPTRPF  F  P PFRPu PFRP% =  t  FVFƉVyF  1  P P PFRP% =  u 
 F~s~t  1F  #  P Pvv?=  t 
 F~s~t    P NƋVRQvv
+
 FFF;Fs  FʌRPFRPFRPvvFʌRPiRP
 P P PFRP% =  t  U  P Pvvk=  u    P NƋVRQvvQ*
GF9Fs    _^]ÐU VW% =  t RP N vv% =  t RPh % % =  t RPH    _^]ÐU* !VWF RP? P P=  u FRPA F RP PFRP7 P P PFRPRP PxP$F% =  t  +% =  t VRPl RP~ PxP# PRPF  FF% = |7 RP30% =  u   RPF% = t O 6U% =  t RP,  % =  t &RP	  F֌RP% =  t IRPd  F F% = t F @uRP-% =  tO  Pz% =  t4 % =  t& % =  t gRP߃ A 
  P+vv% =  t .RP߃    _^]U
 }VWF  F  F  F  + v
vP Pvv%  FVnF~ tv
vv Pvv
  FV~  t ~ t     _^]ÐU VWF  F   PRPFRPRK  
F  F  + v
vP Pvv  FVnF~ tv
vv Pvv  FVFE F^N؎&N^يFN;u RP!ރ  F~w    _^]ÐU VWF  RPD P1F   F^N
؎&FF= sv
v% =  t RP݃ v F  = F^N؎&% N^v
َ&F% N;u FFF= s~ u v'	RP}
     _^]ÐU VWF  FF=2 | F^N؎& F^N؎& H	RP
  _^]ÐU VW F+ t@ ^&?dr4 ^&^& + t ^
&&^N؎&  _^]U츮 )VW6D 6B J	RPj	RPvF  ZƆX ǆV   V
&Ƈ VV sXRPFRPZRPvvvrF=  u 	RPFRPRT=  t  t 	RPnۃ P RP% =  t 	RP>ۃ PTR RP% =  t 	RPۃ PTR>Z=  u 	RPZRPFV=  t  t 	RPڃ P=vv RP% =  t 
RPsڃ P RP'% =  t (
RPCڃ PX% =  u8   RP RP% =  t H
RPك Pvv6`
RP:
    _^] 0!<s3P˿6 + r ׁsh3P1L!6
6
ƱH6l
n
66gP6g
P6g6g6&h
6 +۴J!6
 +3
O3X 6
6
6
6
6
P.L'ظ j
(P.L'ۚ^,  y>
uXP
 Pj
 5!

 %'!
)
&6, 

3
sx

 

&, >3&= t4
 
t3u!
,Ar
,Ar
ª 
 D!r
t
@Ky

 

 

 U3U UVW UVW.
Q
u't z 

b >
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>
 t
 P]ø Y+r
;
rQ3 V3B 22Ut
 Pt ^Ï

 <t)
&, 
3 3uGG>
ыѿ  
< t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ

6?6W6

u6
 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &
U
&, ÌF333t&>   tFu@$F	  RP 

Vϋ3_I36;
uQVW
 _^Yt^?G^
u͎^O]UVWV;t@t3_^] UWvt 3I >
u
@!_] SQ \
QP>![\
Yt[Ë r3]sP X2]s ]2 â

u">
r<"s< r<v
ט
Ê  UWVFG
@tG
  D
u VށFVD*P|]~ tZ
PNQKFFV~\t PFPN
 Pvvv)FP!tD
 ^_]U
Vu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S
Y[X+)D `;Nr/3ҋv+SQPS3DP.Y[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DPY[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU

t>]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %
炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt4u%
@t ~QWS EL
 cSV [D
tҋT+BUJT$QQttSY|V&;u3F3
 t QPPS7	3_^]UVvD
t$t ttd
3DDDD^] UVv PYށtL
G L
G ڍGTTDD  ^] UWVX
FF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvvG
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	4uVD
uFuAWt!DTTD E L
 S P[[tW3_^]UVWvt,3ۊ\
@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GP
= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*PD;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] w66666 7)7[7UVW3FFv&vF
t~ }F, <Xw$ FF.6V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuM
S
WN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
h
F
^
FFt~ u	Wd
guF u	Wb
&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]U^;
r 	>!rƇ
 U^;
r 	1>Z
 tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!r
& U2>
r~
FF
U2~FF  u @uW
uFV$
Ǵ=!su	 t % = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;
r
>! 
N
Ë]2ܡ
#3ɨuU^;
r 	s3N
l
ue>
u
N
V?!s	G
t@
VW^'
<
u&
:t<u&
G+_^t<
t
@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B&\
=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ
+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U~3uI] UWV~vߋN
t2Ì^_]UWVN'~3ˋvD3&:EwtIIы^_]   UWVv33۬< t<	tP<-t<+u<9w,0rҋˋ؃ X<-u؃ ^_]UVWN
F3҃
u~uUV

FVtpFFthvv^&G&tN&w&7;v7^&&8=u+Vvv^&w&7
u^&&W@
F3^]UF+F
F +F ]  WV@3VM@tG96s^_UWVv|96

	 4
&
=}3#
tVt
>

	 ^_]ÐUV2] UVF ]U"V < RP6
6
^&GFPFP~ u~ uFPfF-ȉFP FF*ЉFF^*^wv
Vu	~BVF*FF^&GF*PFPFPvvvR^&&W>
 tFPjt^&G 	^&G  ^]Ã> u ÐUV3
PFVu^&? u PS6
6
~
F^&?-uFGFRPvRP

^&?+t&?0|&?9F&?:ud< RPFvRP

	&?9F^&?0}&?:u*FvL

&?9F^&?0}t


 
^&
t PS6
6
	
& ^]ÐUV^&
C} &} &	~ &~&	|z&w
V~&u&_ۋ
 &_ۋ
F uF RPmDLF-
  RP+F^&u&;G|	u&| &9G|u&|3^]UWVv^ۋ
 u~~G< RPRP RPƹmȋFڙFVDFVڋǙځD SQȋF
ڙSQȋFڙSQȋFڙ

N^FǉFDPFFHFF
F>
 tFPbt	n^ FV^_]U
  FPRPFV+

RPLȋF+
ڙӉFV]ø
PU^,a<sAC
uڎ]UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VW1NxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! UF5!Ë]UFV%!3] U*!^OwG3] U,!^/OwW3] UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USW3F}GVڃ FVF
}Vڃ F
VuNF3F3OyCH؋NVFuf
fr;Vwr;Fv+FV
+FVOy؃ _[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UNWVHv
~H+#+#@+u uǌ 뾋FV^_]U^;
r 	W>
u
 tB3ɋ!r
tz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^
@t^^?u F+Ff^_^JߋN
u>V@!s	u
@t&?u Y
;s+3UVv&L^]UVWNwi
tH0N6

VW_^s+_;uX6
&t
;u>t>^0Nt

r 

39
tv
tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;
v;
v
3&EGUVA!	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MS Run-Time Library - Copyright (c) 1992, Microsoft Corp    Unknown command line parameter!
  Usage:
	TFLASH [/S outfile] [/U infile [/V]] [/?|/H]
Where:
	/S to save image into outfile
	/U to update flash using infile
	/V to verify the flash update
	/H or /? to show this help message             
%s Activating micro flash interface...
 /U Missing file name! /S Missing file name! /V /H /? Read a byte from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Read block from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write a byte to IIC... Mailbox0 locked Success writing to IIC Timed out writing to IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write block to IIC... Mailbox0 locked Success writing to IIC Timed out reading from IIC Security violation Mailbox command not supported Unknown error code in Mailbox5 Read ACK... Ack received Did not get ACK
 Trying to read ACK again... Timout... Ack NOT received Send Flash Write Enable Command... Timed out, or IIC access failed Send Frequency Command... Send Erase Time Command... Send Signature Command... Send Blank Check Command... Sending blank check command... Send Erase Command... Send Write Command... 
Writing...  [%s] %u%% Send Verify Command... 
Verifying...  [%s] %u%% Send Enter Flash Mode Command... Send Exit Flash Mode Command... Send Read Command... 
Reading...  [%s] %u%% Failed to enter flash update mode! Failed to read flash! Failed to exit flash update mode! Start Programming... SkipWriteEnable = TRUE SkipWriteEnable = FALSE Sending 0xF0 to the parallel port (pwr OFF, reset LOW) Failed to send Flash Write Enable command! Sending 0xFA to the parallel port (pwr ON, reset HIGH) 
Activating Flash Mode... Activate Flash Mode Failed to send Reset command! Failed to send Frequency command! Failed to send Erase Time command! Failed to verify Silicon Signature command! 
Erasing... (This may take a few moments) Failed to erase flash! Failed to write to flash! Tempest This is an invalid file 
Verifying...  Failed to read flash device for verify! There were %u miscompared bytes! 
 
TFlash utility, Version %u.%u
 Copyright 1999 Compaq Computer Corporation

 w+b Failed to create output file! Failed to read flash device! Failed to write to disk! r+b Failed to open input file! Failed to read input file Failed to program flash device! Failed to verify flash! 
Done!
   (                           _C_FILE_INFO=                                                         
                
	
\ \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    EEE50 P      0PX 000WP         ``````  ppxxxx        (null)           ) ) ) ) ) ) )      ; Z x     0Nm : Y w     /MlTZ  p   PST PDT 

                               '''                  F0<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
 NNB09Ho      CV   N     dos\unlink.asm     CV   N  D   
newseg.asm     CV   0N  |   searchsg.asm       CV   M  6   linkseg.asm    CV   M  4   initseg.asm     CV	fdata.asm      CV   M     fmalloc.asm    CV   M     stackava.asm       CV   K  \  	write.asm      CV   RK  ^   hmemcpy.asm    CV   J  _   	uldiv.asm      CV   RJ     lrem.asm       CV    J  2   lmul.asm       CV   I     ldiv.asm       CV   jI     dos\gettime.asm    CV   NI     dos\getdate.asm    CV   LI     dos\enable.asm     CV   JI     dos\disable.asm    CV   4I     dos\d_setvec.asm       CV   "I     dos\d_getvec.asm       CV   I  
   dos\d_commit.asm       CV   H  c   xtoa.asm       CV   RH  ^   hmemcpy.asm    CV   G     hmemcpy.asm    CV   G  k   
strstr.asm     CV   F  $   
strupr.asm     CV   F  V   clock.c     CV_cinittm.asm       CV   E     
dtoxtime.c      CV	timeset.c      CV   C    tzset.c    CV   B    dos\ftime.c     CVdays.c     CV   B     dos\outp.asm       CV   B  
   dos\inp.asm    CV   (B  X   commit.c       CV   B  $   
closeall.c      CVdos\diffhlp.asm    CV   A  +   
dos\hdiff.asm      CV   HA     getenv.c        CVcmiscdat.asm       CV   ,A     itoa.asm       CV   @  V   atox.asm       CV   @     atol.asm       CV   @  ;   strncmp.asm    CV   l@  *   strncpy.asm    CV   R@     
strlen.asm     CV   @  <   
strcpy.asm     CV   ?  T   
strcat.asm     CV   >     growseg.asm     CVfree.asm        CV
malloc.asm      CVseekfast.asm        CVncommode.asm        CVtxtmode.asm    CV   =     dos\read.asm       CV   ;    dos\open.asm       CV   v;     
dos\lseek.asm      CV   V;      
dos\close.asm      CV   ;  N   stream.c       CV   6    
output.asm     CV   4  D  fflush.c       CV   4     _sftbuf.asm    CV   2  :  _open.c    CV   2  I   _getbuf.asm    CV   L2  5   _freebuf.asm       CV   d1     _flsbuf.asm    CV   0     _filbuf.asm     CV_file.c    CV   0     _cflush.asm    CV   t0  B   printf.c       CV   .    
fwrite.asm     CV   n-  p  	fread.asm      CV   $-  J   fopen.c    CV   `,     fclose.c       CV   ^,     farstub.asm    CV   ,  U   dos\dosret.asm     CV   +  #   dos\stdalloc.asm       CV   +  `   dos\nmsghdr.asm    CV   *     dos\stdenvp.asm    CV   @)    dos\stdargv.asm    CV   )  "   
chksum.asm     CV   )     
chkstk.asm     CV    )     
crt0fp.asm     CV   (      dos\crt0msg.asm    CV   N'              dos\crt0dat.asm    CV   J&    dos\crt0.asm        CVoldnames.asm       CV      9&  
tflash.obj    
  $       	     
tflash.obj *     `   d   $      PromptError      pErrMsg   &              4   DebugMsg     pDbgMsg   .           .  ( F  	 GetDosTimeSlice     "         D  > t   alarm    s TimeoutValue     &     \  `        IoDelay      s io_cycle   
 	   l1  &         *  $    MsDelay      s TimeoutValue     *         X  K   
IntervalTimer  	?  send_eoi    "     (  ,  @  : R  Wait       delay  
  s i    *     h  l      	 EnableRtcTimer    temp     .            j 	 DisableRtcTimer       temp     .         k e 	 ActivateFlashMode 
  r i    "     4  8  ;  5 j  Sleep     wait      goal     "     l  p  C  =   Delay    " wait     "         @  :   SmcGet     index    "         D  > *  SmcPut     index       value    &     4  8  R  L n  SmcWait        mbox   
  r i    "     |    c  ]   SmcCmd     index       value    *           y $  GetSmmFlags     s iFlags   *          r  l   SetSmmFlags      s iFlags   &     (  ,  ,  &  	 LockIIC     &     T  X  ,  & B 	 	UnlockIIC   &         @  : n  	SoftDelay    s Seconds  "              Exit     s uCode    &         s m  GetParam     r argc      argv     
 p
InfileName    pOutfileName    
VerifyFlag     temp2      temp1    pStrTemp
  r i    &         ; 5@
  ReadByte      value       Address
  s i    &     L  P  ] W|  	ReadBlock     Buffer      Count    
   Address
  s i    &         < 6   	WriteByte      value       Address
  s i    &         a [  
WriteBlock    Buffer      Count    
   Address
  s i    "     `  d     x ! Ack       Status      Address
  s i    &         O  I  	 	SoftReset 
  s i    &            j 	 
TurnOffVpp  &            | 	 	TurnOnVpp   2     (	  ,	      	 TurnOffProgrammingMode  2     `	  d	      	 TurnOnProgrammingMode   2     	  	    y  " SendWriteEnableCommand    Status 
  s i    .     
  
  b  \ : " SendRESETCommand      Status 
  s i    2     \
  `
      " SendFREQUENCYCommand    #Freq       Status   2     
  
     j " SendERASETIMECommand      Status   #ETime    2     $  (     & % SendSIGNATURECommand      SignatureBuffer   buff       Status   2         E ? " SendBLANKCHKCommand       Status     BlankStatus
    i    .           " SendERASECommand      EraseStatus    Status 
    i    .     
  
  o i % SendWRITECommand      BinaryImage    ProgramFlag  &ProgressBar    WriteStatus   ImagePtr     s CurrBlockCount     Status 
  s k    s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .        $    % SendVERIFYCommand     BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status 
  s k      VerifyStatus     s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .     p  t  r  l ^ " SendENTERCommand      Status 
  s i    .         r  l  " SendEXITCommand       Status 
  s i    .          B % SendREADCommand       BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status   s PercentComplete  '	ReadParam  
  s i    s 
ProgressCount    s 
MaxBlockCount    &            y \ % 	ReadFlash     BinaryImage  *           % ProgramFlash      BinaryImage    Status     SkipWriteEnable  s 	FlashSize  
    i    (SignatureBuffer  .     0  4       + CopyBufferToDisk     pbuff      )fptr     s 	LastBlock    s 
FullBlocks   " Total    .            ! + CopyDiskToBuffer     pbuff      )fptr     s 	LastBlock    s 
FullBlocks 
  s i    ,
TempestString    " Total    *     T  X     " . VerifyFlash       Wrotebuffer    
ReadBuffer   s errors 
  r i    .         _  Y # / InitProgressBar       ProgressBar
  p i    2     <  @  f  ` n# 1 IncrementProgressBar     s CurrBlockCount    sPercentComplete  
 s
ProgressCount      ProgressBar  "           u o# 3 main     r argc      argv     )Infile   4OutfileName  Z4
InfileName   X  
VerifyFlag 
  Vs i    R)Outfile      ( 	8.00c              H&        0      H&  tflash.c          .   4   ?   F   Q   _   d   n   t                                                                           *  /  9  ?  A  C  E  R  ]  |                            -  ?  L  `  c  j  u  x                      	    $  <  T  a  k                    '  1  >  V  `  c  j  u                      $  *  5  F  W  h  n  y                          $  /  =  G  U  _                          !  .  <  B  M  Z  h  n  y                      "  1  U  X  e  o  r            	  	  H	  O	  R	  	  	  	  	  	  
  
   
  *
  9
  @
  K
  X
  i
  w
  
  
  
  
  
  
  
  
        #  )  6  <  I  O  u  |                      1  >  U  X  e  k  x  ~                      
  
  "
  ;
  H
  N
  V
  n
  
  
  
  
  
  
  
  
  
  
  
      !  .  ?  P  b  }                    	      )  /  <  B  h  k  q  x                              %  3  ;  R  `  c  j  u  |                              !  .  3  :  E  M  c                        >  _  d  j  u                   &  1  >  Y  z                      1  4  7  J  c  m  {                           $  2  S  l  v                    	        $  )  6  C  H  M  [  |                            #  D  X  y                	        *  .  2  P  g  u  x  }                            ,  M  U  c  q              	  
  +  B  P  S  X  ^  i  v  ~                  	  *  7  <  B  M  a  f  k  x                    	    $  ,  H  K  f                       <  ?  M  P  U  \  g  u                                  "  &  3  D  R  c  p  ~                              (  +  .  <  ?  D  R  _  b  g  u                                       $   '   4   9   <   F   ]   `   m   r   u   z                                    !  !  !  !  '!  1!  K!  P!  U!  X!  {!  !  !  !  !  !  !  !  !  
"  "  "  !"  &"  3"  6"  @"  H"  h"  "  "  "  "  "  "  "  "  "  #  #  #  #  E#  W#  d#  g#  n#  y#  #  #  #  #  #  #  #  #  #  $  $  $  $  7$  ]$  `$  l$  $  $  $  $  $  $   %  
%  %  %%  2%  ]%  j%  t%  %  %  %  %  %  %  %  
&  &  !&  -&  0&  =&  C&           
 !",./02<=ABCDOSTUVWadefglmnq
&'()789:;HIJKLZ^`abcdstuwxz{
 #%&)*+,-9<>?@BCFGIKLMOPRSUVXYZ\ilnoprtuxy{}~,012345?AKMWYZ[efguyz|}~

 "$%&'()+-./23689:;=?@NSUVY]^_bcfhijkmop~ 	
 "$&49:<=>?@NRSUVWXYgloqsuwx|} 	

 "%'(-/015789=?@AEFGIKNPQRTUWXY]^bdefstu	
 "#&')+-/12578;=>ADFHILNORTUXY[\_bcef
      $	   j   _Sleep    "5   __flush   4   _fflush   
   __fheap   p
   __oserr   T-   _fopen    v;   __lseek   <   __open    HA   _getenv   M   __stackavail "    _TurnOnProgrammingMode        
_TimeoutCount     _IntervalTimer    j   _DisableRtcTimer   ,   _dcnt R   _Wait    _Exit   %   _edata      -   __end (   _exit 
   __intno   @   __catox   B   __outp    H   __cxtoa    	   
___aDBexit    0   
__endstdio    RK   	__fmemcpy 
   
__amblksiz    #'   __amsg_exit   +   __NMSG_WRITE  B   
_UnlockIIC    $   _GetSmmFlags     _SetSmmFlags  l
   
__daylight       _SmcGet   
   
__lseekchk    B    __anullsize   l
   __osversion   I   __dos_commit  j
   __osver   F
   	__acfinfo 
   	__environ ,
   __sigintoff   p
   
__doserrno    &   _SendSIGNATURECommand    _Delay      %   __edata   n-   _fread    =   __read       _WriteBlock   *,   
__maperror      	   ___aDBswpflg   	   ___aDBswpchk       ___qczrinit      _ActivateFlashMode    h
   
__timezone    ,
   __nheap_desc  *   _SmcPut   x   _Ack    -   _end  ;   __sopen   B   __inp  ,   _Key  h
   __psp 5   
__flushall     J   	__aNulmul    _SendFREQUENCYCommand F   
__inittime       _SmcCmd   X
   __fac F   _clock    RH   _memcpy   ?   _strcat   @   _strcpy   C   __tzset   G   _strstr   "I   
__dos_getvect 4I   
__dos_setvect 2   
__openfile    E   
__dostotime_t    	_GetParam t    _alarm    
   ___argc   
   ___argv   
   __iob    __iob2    NI   
__dos_getdate M   __ffree   4   __ftbuf   4   __stbuf   jI   
__dos_gettime |   
_ReadBlock    \   
_ReadFlash         __EmDataSeg   
   __pnhFarHeap  *
   __sigintseg   +   	__myalloc 0N   __searchseg   1M   	__fmalloc ^,   	__farstub    	__lastiob "   _VerifyFlash  ?   
__findlast        	_rtc_regB (
   __aexit_rtn      _SendVERIFYCommand    !   _CopyDiskToBuffer k
   	__osmajor j
   	__osminor =   __cXENIXtoDOSmode    _SendERASECommand     _MsFlag   @   _atol R@   _strlen   *   	__setenvp     _PieTick  2   __getbuf  (   __FF_MSGBANNER    ~
   __citime   6   __output   )   __fptrap  J&   __astart  N   __newseg  n   _SmcWait  &    _HelpMsg     _SendEXITCommand  f
   __pspadr  d
   
__umaskval    F   __strupr  d1   __flsbuf  ,   	__dosret0 B   __fcloseall    ,   
_dummyread    B   _SendREADCommand  
   
__exitflag    C   ___tzset  `,   _fclose   V;   __close   
   __fmode   N   _remove   ,A   __itoa    n   
_SoftDelay    @
   __aseghi  B
   __aseglo  0(   __c_exit      _IoDelay      _MsDelay  0
   __lpdays      _Timeout      _PieFlag  t
   __osfile  LI   __enable  ,   
__dosretax    Q?   __incseg  
   __cflush  n
   __osmode   J   __aNlmul  RJ   __aNlrem  N   __unlink  I   __aNldiv  0   __filbuf  
   __ovlvec  
   __pgmptr  G   _memmove  (B   __commit  
   __iomode  &
   __atopsp  $-   __fsopen      	_rtc_regA |   
_TurnOnVpp    l@   _strncpy  @   _strncmp  v
   __tzname   
   __fpinit  *
   __asizds  .
   __asizeC  /
   __asizeD      __AHINCR  #   _main N'   __cinit   t0   _printf   b
   _errno       _LockIIC  )   __chkstk  @)   	__setargv j   _SendERASETIMECommand J   	__aNuldiv    
__aDBdoswp    
   	__adbgmsg 
   	__ovlflag                  _PromptError  F    _GetDosTimeSlice  >   	__growseg     	_ErrorMsg M   	__linkseg M   	__initseg 
   __child   r
   __nfile   J
   __days    (   __exit    
   __aaltstkovr  .   _fwrite   B   __ftime   K   __write   n#   _IncrementProgressBar      _ReadBuffer   L'   	__dataseg L2   	__freebuf 4    	_DebugMsg     _FileBuffer   A   
__aNahdiff    v   	__acrtmsg     
_pic2_mask        _CopyBufferToDisk"    _SendWriteEnableCommand   '   	__cintDIV T
   	__aintdiv     	_pie_flag j   _TurnOffVpp   &(   __cexit   
   _STKHQQ   (   
__ctermsub       _EnableRtcTimer   @
   	_ReadByte    _SendBLANKCHKCommand   	   ___aDBrterr      
_WriteByte       _SendWRITECommand     
_FlashMode        	__AHSHIFT )   __nullcheck   ^   _SendENTERCommand 
   	__commode     
_MINOR_VER   "    _TurnOffProgrammingMode        
_MAJOR_VER    :   _SendRESETCommand ;   __getstream      
_SoftReset    o
   	__cpumode H   
__cltoasub      ,   _BiosRtcHandler   v   
__acrtused    
   
__cfltcvt_tab +   __NMSG_TEXT   ,   __dosreturn   )   
__aNchkstk    JI   	__disable D
   	__fDosExt D   	__isindst    
_ProgramFlash #   _InitProgressBar         P         X      @  h    (  @      P      H      H        X    
   	   
                           
   
      	         	   	      
               	      `"$  kB    PcP|
  6J	
  VJt  f  j  u  KqP   f  Cx  E$
  t
  %   [jDT  kW,  k%  , `    pT   ^%p    rE  4  V_  vp     Z{  z;R   |   fL   /[/d       f  HR@
  zJB  +ը  !D=
  {#  .wd  ?R{<  }{x  ?CP  r`  ҄  aU\   !	  u"  !
  j  0h  '%  
u  `  
k  >$$  {u(   07  U<  ns>BH  DE)h  UD  O  KX  Z
  zk
=
    !    Z]ՠ  }  xo_  ǲL-\  fwl	  Z  Lc  Ϋ  <Q  
x  F3  e`  e  C   D  F  <P,
  Z

T
  J{`
  ˻|  K   |  y|  ϫ  ǲ,p  6|  uXʸ	  z"
  
ʋ(  '_  Ky  >,   6t  Z}t  `a  T0  
E0  hQ<  Q(/T  Y؛	  m*<	  	  y k@  % 
  )@  {  bH  =Cr  ۫  
"U   zD4a@    2@  	  YD
  X*1   xz#  > x     e3(	  	  0  +(  ;   aLu\  k  !`L  MՔ  (   !@  4p  &R  G  V  zj
   p  \j  f]u     ҟ0T  f  倀   vq  "  5'|  	L  mq8  Mh  u׸<   $Ը  zL8  hұu,  p  v  ~P	   ˰
  [u  H  >)H  z/XNP  yr@`  5H     j
<  1  alu   (  3֐  o
`      $`U  0  
  H|0T  k4  lj  =   0  ?(  M؛	  d
  IJ
  q
Zvl  Yh  kPH  <f(    q`  }]  		wP  ?
$  6C44|  *{`  FsҜ  xf  *g  [^D  
8
  L
  {
  |%  M  f_Ntd  }  zh  2  7˛  [
  Żt  M{L  Kz$  {  2_	   Z74  ^60  ;  vcp  0  8ݱ  	^  D
    
h  {&  g]P  !  "h  d(
  ;
{    |[  =W~  #P  T  ֋4  v|  `  8 h
  1j
:X  ]  ݻke   U-                    H  P  p  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x                                      H                                                                                                                                                             4     F     t   X     l          P  R      $  j          j            *  |
  n        $      @      B    n  `          @
    |  4    0      x  d    t  j  <  |               0  :      |  j    &      l	    L          ^  
    X  B    \  x         	  !    "    #  (  n#    #  T
  J&  8  '  P  #'  `  L'    N'    (    (    &(  D  0(    (  	  (  @
   )  $  )  T  )    )  h  @)  	  *    +  h  +  (  +    ,    ,    ,  H  *,  h  ^,    `,    $-  d   T-    n-    .    t0    0  
  0     d1  t  L2  	  2    2    4  p  4  (   4     "5  p  5  ,
   6  L  ;    V;  x   v;  ,  ;     <  P	  =    =  4  >    Q?    ?     ?  4  @  	  R@  T  l@  h  @  	  @    @    ,A     HA    A  (  B  
  (B  @  B    B     B    C  H  C  d  D    E    F    F  
  F  \  G  
  G    RH    H    H  <  I  p  "I    4I  <  JI    LI  D  NI    jI  t
  I     J  8
   J  L
  RJ    J  $  RK    K     M  \  M  T  1M  p  M  \  M  <  0N  h
  N  `
  N    N        H             B              H     
  &   (          `          h          	     	                   &
    (
    *
    ,
    @
  0  B
  P  D
  h  F
  L  T
    X
  ,  b
  
  d
  
  f
  `  h
  <	  j
  T  j
  (	  k
  $  l
  $
  n
  |  o
  P   p
    p
    r
    t
    
    
  |  
  
  
    
    
    
  
  
  t  
    
    
    
  
  
     
  0    |    
  
    
    
    
  8  
    
    *
    ,
    .
    /
    0
    J
    h
    l
  |  v
  
  ~
    
  <   
        `      x                          p            P     @     @                 
           0ݽ  Y     !q7d   Y     4`tp  Y     5`  Y      6ErrorMsg    z	  Y     `  Y     1W  Y     `a6  Y     @[  Y     _iobuf      ACK  Y     ]fQ  Y     "  Y     &üX  Y     pR{d  Y     {,  Y     fÀ  Y     `
  Y     BP=  Y     -s  Y     4ӊ5  Y     DcP  Y       8
ReadBuffer     
_fonexit_t     $ė=t  Y     5}   Y        pie_flag   ,   dcnt   UD  Y   
  FILE   @  Y     4TT  Y     uD  Y        MsFlag     ,  	dummyread  6P  Y     @K
  Y     `   Y      , 9BiosRtcHandler     V
$  Y     f  Y     &p   Y     HGH9$   Y      8
FileBuffer     ! wchar_t       rtc_regB      rtc_regA      	FlashMode  4p48  Y     
  Y     x
`  Y        PieFlag    $   Y     Df,  Y    &  7HelpMsg    s size_t      s Timeout     time_t      5	MINOR_VER    5	MAJOR_VER    Y     ,   Key     fpos_t     onexit_t      PieTick    
  Y     d	  Y     ?q˨  Y     pva_list    L  Y     D
8  Y     `ݱu  Y     Ľ}   Y     -4  Y     ~ٶl  Y     ^RX  Y     NB
  Y     !Qu  Y     	_onexit_t  ՞N(  Y        	pic2_mask   clock_t    Z2,	  Y      s TimeoutCount         p         0    X  x           
                    0ݽ    ACK   pR{$  t  `Cr%h  @Kx  `   hs  &p  HGH9,   KEY  `ݱu  ^R@     !q7D  % YX  6  aW~(0  !QuT    z   "ޤ  V
  L  Z2  _%@   kf'd   `t   1W   `a6   @[  {،    ;]1  { g   { W  k,  k$   ~ٶ    4`t   $T  4ӊ5d  DcP  $ė=  dT     4TT0  u"  tg@H  4p4X  
h  x
x  #  Df  4U  Dځ   DʀTp    d\  D
  Ľ}t  4`0   5`   ]fQD  -sް  5}   E4D  UD   uD  $  C<  e[4L   \    -P  ՞N   &ü4  BP=      fô  f4  ׸  ?q   NB`  ]w,                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  6                                                                                                                                                                                    4     F     t   X     h              R         j        j            0   *    n  H      $            B    n      d    x  @
    |  X             x          j  t   |               T   :  p    $  j     &  P         d     h      ^      T  B  0  \  4           !  D  "     #    n#     #  t                      @        &                   `     4     x     \     0                     ,          D                      OLDNAMES.LIB
CLIBCE.lib      :       T   l   t                                                $  0  <  H  T  `  h  x                              $  0  <  H  T  `  l  |                  R p   _ptrr   _cntp  _basep  
 _flagp   _file           _iobuf   
  r         
  r         p
      
         s 
      

          
      
   
        " 
      
       

      
      
       
  s     
  r    
   p  r pp 
      
     
  s    
       
  s    
  s    
       
        
          
       $
     3  
       
           
  p)
       *
  p    
    
       -
      $  s ss 
      0
  r 
  r    2
  p  P     r 
  p  !  
  p              . -               N                      &             . <              E M           - U Z     B      - b h B   
     - m r 
        - w ~ 
        -   
        -   
         -   
         -   
         -   
         -   
        -   
         -   
         -   
        -   
         -   
         -   
         -   
         -   
         - 

         - 
         - 
         - "(
         - -2
         - 7<
         - AF
         - KQ
         - V\
        - bf
        - jn        - rv        - z        -         -          -          -          -          -          -          -   
      -                  _TEXT CODE EMULATOR_TEXT CODE C_ETEXT ENDCODE EMULATOR_DATA FAR_DATA FAR_BSS FAR_BSS NULL BEGDATA _DATA DATA XIQC DATA DBDATA DATA CDATA DATA XIFB DATA XIF DATA XIFE DATA XIB DATA XI DATA XIE DATA XPB DATA XP DATA XPE DATA XCB DATA XC DATA XCE DATA XCFB DATA XCFCRT DATA XCF DATA XCFE DATA XIFCB DATA XIFU DATA XIFL DATA XIFM DATA XIFCE DATA CONST CONST HDR MSG MSG MSG PAD MSG EPAD MSG _BSS BSS XOB BSS XO BSS XOE BSS XOFB BSS XOF BSS XOFE BSS c_common BSS STACK STACK DGROUP    Y                                                                                                                                                                                                                                                                                                                                                                         tflash.c     c                #     ,        L   !     p                                      !    	       
 (        H       h      
                 $       $       #     4  $     X  %       %       %                            0       P       p                                           !       " $  !    # H       $ h      %       &       '   "    (       )       *       + <      , \      - |       .        /       0       1       2        3 <      4 P      5 d      6 |      7       8   !    9   !    :   "    ;   "    < 8      = X      > x      ?        @       A        B   !    C        D 8       E X      F h       G       H       I       J       K 	      L $	       M D	  #    N h	  %    O 	  $    P 	  $    Q 	  $    R 	      S 
      T <
      U \
  $    V 
  0    W 
  !    X 
      Y 
     %Y     'Y   D  *T0  '  )W  d  4Td     (dd     +d    -Th    .k    3m  x  NB09t              buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        