#!/bin/sh

if [ "`id -nu`" != "root" ]; then
        echo
        echo "ERROR: This script must be executed as the 'root' superuser."
        exit 1
fi

echo
echo "GbE2c Ethernet Blade Switch for HP c-Class Utilities Installation"
echo "                        version 1.0.0"
echo ===================================================================
echo
echo "Press N (Enter) to exit installation.  Press (Enter) to continue."

read x
if [ "$x" = "n" -o "$x" = "N" ]; then
        exit 1
fi

rpm -U --force HP_GbE2c_Blade_Switch_Utilities*.rpm
rpm -qa | grep HP_GbE2c_Blade_Switch_Utilities > /dev/null
if [ $? = 0 ]; then
        echo
        echo Installation to /usr/local/ProLiant/Interconnect_Switch/Utilities/GbE2c/version1.0.0 complete.
        echo
        exit 0
else
        echo
        echo "ERROR: The following packages were not installed succesfully:"
        echo
        echo     HP_GbE2c_Blade_Switch_Utilities*.rpm
        echo
        exit 1
fi
