#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTV)  - Linux-Based"
BIOS_VERSION="F.10"
FILENAME="sp32119.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<FreeDOS    @	             )0ROMPAQ461  FAT12   1ؽ | ^|  ` ؎Ѝf~$uV$F F  FreeDOS v~v v҉~ԊFf׉v։~؋^F1Fƃ vډ~܋F֋V؋~^Z r/~Z }W_&Et &= urYP^Z~FҋVk XrF^\  s=r1^Z  	t$HH~
 FV$ s  err 0^$nZ1۴^V< uVFȉVʌFƉ^ĴAUV$trTu
v^̉^δB,NȋVʊFfvшƆɊF(^ĸV$s0뢋FvFƃFV OuF^KERNEL  SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY]_ a c@e`gikmo q s@u`wy{} @` 	 	@	`					 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ROMPAQ461            dKD1      KERNEL  SYS  -KD1D1  80 ~  R o m p a  ?q . e x e     OMPAQ  EXE  1LD1D1  ;1[   CONFIG  SYS \LD1D1  71[ 8   GPL2    TXT 1K1    h/-\ G  AR o m p a  ?q . e x e     ROMPAQ  EXE  o4o4  {]3   8YDU   BIN  
o4o4   n4    8YOP   BIN  Ao4o4  Ln4    68DTV   BIN  Lq4q4  Ӊ04                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CONFIG    nused9W䯉 .ls璯 UUPX!
!5Zj  * CONFIG   PS1 [XꐤY A]o1ؠ$.  t.&<u ÿ,. u	t= ru.&..>t$*/.mtG
bAe=6w[&G)ƆPVWUS[]_^XP@ ؀q XSXR-LF,@:,4. ,($"(,,0,4
8,< RPȎء2;4v*҉6&V0)n	XZ [	,.W.VGVPPkvp0B[kb! BH~PQRiS^ct G$:wbƗS. .TYYg
OW,5>+dRoGo	[ZYX^˩vꍱ)J.~7bG۶?CYa+,'QPRU,rlq6+_.Y&rA]ZX^wy["
7xWFH t
/=]^ *&t tF 3h
6ZFkq7}-3c~</
h'_f
 Ӂõìލ. u6 5t/GKum4	ruO0$0<0n_t)[t$
o-<QS1ln%HݻFYt0o؄?;YeP]f>}
7E&}U<et<Eu&
5V\]n-  @PRN# AUXFALPT192s_3G,kM1>A2yP#y3b)4ti~LOCK$[ O
 " bܜ nO0_}	-s'3h s=OiqjbNUL"elX Rbckpro{< "l &/8b 
65S9` DG> ALUC  PCRemove diskettinnriX:
 #ރo!U"yh&QOod[ ov nyfsEK^=<V,N8=F>՚ 6\.&4_?S.[˴Po>&;@u(
,<V\X.>su	7tP Xϰ ErrorthDJ mechanm! Insert Pressby k(to cont5u. m *LBA-Trsf1v eS6:#yl"d> 1023
?PANIC[Sysom kld ^C
ig]awoaneao9fnok@|[qkj0dtsam*iȦ1CHKDSKstrygacc
vcio8clus@Q0x :<|>+=, /"[]<>|.A}MCB +s׼wupbef4aT`afMplwen+n\ofcB> INT2F/12 {+lm@;,$vir_mcb=pv1tMZBaN\mikComm+/agIs(]o E(mlvmsuc+e$\DEV\ 
g(chnpavh yHCngmka03456789abcm%f
+#/=n#w{*3	#^K; YNxۂf%+$0a-E4smEAAEl IOOUUYAIK^KAc."/\A:|<;M;,M	

 !"#$%&'()*+,-./W:;<=>?@ABC/FGHIJKLMNOtSTKXYZ[\]^_`a_{|}~CU C
OO;o$ NN?~!""BSHg! ; Z x   j0Nm< [ y   
1OnF7eDOSZ%$evs}1.35 (Builv20) [Man~30
042:0/:36]]*?O\"ZbVQƉY^ɿf9rӉ1RPމu[痉@)Y!!1_kO(?Un]PFFX]$ve ϱ$<
i/pbsUp3n4v!e by zko}Vz<pk:6%t
F<m1 oFF

L!^xzOpZ;Nr믴 UWVRQSPKi1Pڀ%to3t/5t/Pt
/Qt/bu` UhTM֌.AV_StV"n%!
<~#  	">n M։X[T:W]ϣ:P*XÃ3 1QP.%  slfLӼmcPyWq"UK[[]˞fBf_~v
n/0&60 >r?&kE\)ً&}$.{ݎՋ"J\Z-57~|J .<16f
g<t5váFXd tv^tLN2L&R FZêSGgWiR=7a߉+DqFDi9wu
;~w3^"D2C*V&D&:~rw|
]3'
v,+[5BݠV˶SG3!$0=[M0C"mw_h_09}W:Tu
T,00K@a+mj
BErAh}Gn,䲍ޞyd3߀O3 
Dh}We%.	B[HVD37=nt2
f7{ƞ=*u~4
UJ^ZYQ߳G4ۀg47|3@t3&D+茵BWwOy K[;[g;hWr,YtV'؍PwjPۆ  وÒX^WѮ7vo	
>ƆE=1 eTWWBgÅ/?
[x]L%Hc_lM7#G0<O0Õ{	xW5\RvffL0hP_ 
U['BS7V)R 4S.lP<
UDwTyDkPE%{PW1eA
0Vg
Pc׭
iy
H6wʉo!/ma5]Off&\&\2-~^
|Hu*&_`rvfrvgt~FrvXG=J=g׉^ȍVR\ړnVߤv\oƋOtz^Nz-/gfba`GFo@Ch
5/(p
H#b}luSǱS pF}Y:
mGE(>n}Ot=m2E$	
s3nz&9+DVQW~h4c5
amYA ]	4&M.]6C*2
_e;%gq©seoo
t+YBQ5= f-"=
~ ctf:9PzPVV@̾`5[0 i2x(P	k2AVn_r,<	`mPkRgt#t
~.KR_SyuYF
fFmFBTۿ~^ڊ9;XqvYv7wRl5*b1׊N>^0Zc:~OnsIrf&~r-ulM[O
(z dDoDDk\Dk=^O_SUn|' C ǩcphQ*BGD1ME9x1[	.3 Ca0;z\XR2
5 QLZ:։4ac"`CBXKy='ыngmuBwTkR"nMGƴ{q
$ضsvI4G묩f9/5<rvj7uݘCfLPE4uhX6qwTe>D!Q]:V唁`^^|	N4 +LYs$n5Ll%7V9r
GX;9;^S&{;\?B.[t¦"uCc|	GbRn%0/r	vCt^ZwM @O4_(0:m R
tHX
,	ҶVh09[
+Nv6t|#kE9	=B`>nTر	9s,a
vwuՈ&S^(櫻mS#  {;J1F:GV)ܫ(Qv	QmT9ց s)w(
[!JT,Cu;bWZ#fQ.=+~)𜍓oe}Xm4UOr6  3y
5|RtVPz݃]ÖQq!5mPۑĶVSωX)8/z +kx^м@Q+F8:BͣD4ѷڸ
Oգ^ l,Н$9&=迓'[
NuJ;u!}
u{ݓv{ǣ]GF^
4Da)GQaqѶ?zvRh_ I
EE@m$
qmxd Ǯ]#7
o= 
 X-$Ҥ
6
 ި
tǖ-gspgV1Pk37p)\U(JGV662!d
ƺצ'J$M+(
#}j@YnzVj[r=']ld3Jym# XhORh㹼mx;\A+o]B/
sisCd{F}䶂£:ڹY.EؘcȘpUEX
T=NApB_s+~

]"xs4sPɷ6ݵrk	AlkiWAX4e
vuHk\	ZfhgHMU,85/7M;~⍠d8uڌ:PwkY!u<0<^D
^
^]v#c,@1[CXz@?+	 L-ϋ-Dob&)Vt] #ǆ cNnmnXH )Xt[6Xs
ZQnl/]AX3plj;Yeg*>!wiBfb<Fb0)(B!%1X,~M[ttY=JtT=O=3Jbmt/U!D]P$
f]2[h,F$}g)5ov/+ƅ`[^[T
Z[
`c
6w_
VkB܉ˋ]2r/Oo_ sba;X<im<ѡbǿ^<
t<!t<"tf<#t\Q<t6<<D=[s;VE]McUu}
n~[r6_rcl"B뺒5׊nǴ^'p8!]	[ w~Z[XK!rRwP?n
s!`ýO<GYTV	tZGmw
\74CqS֤od6m Ȁ2RaB/u1tu(KD t!vK'-d9t:sg <*p)*,X:<7uݕ\%$fE
e}j7b,׶OLbie
pcUmmwKu<
Gw3Ou+r%ɚGYGĶ	k~\0DkP,OVL){1i8m$9;c%VtGKST>$Jg	S.(ŉQ%(\pPik|`kv;l^摣7uEe*3->u
@^6Q=U$`<`L[JɍDjJh 	gT
;GE6|mT'2=: uu7
-1\ _3Uv"h5WkBjPehX#	eq׮-tG@_p,M*&(gX V.]avowB^R5sx'E]h
nK%BKw##|A}%	
X!grAF.\1	0Rr+nf>%ZEՁ9r`lZpy Sz | ^wuR5c[P:"&ھ'p6f%
Ak>ZF-xmPe;=_=nt3H|*>vf,Ê\=R
=wP)'Z0ymIA؃qe 
s>9v6&d6k
~9Su7.MnBc-Iu`n[zu?E\[Ц]6
ZZ"^t#u	 
tP8lڔ0R">hjؼ
7Ђt=v\1@QoS٫QG;
g="efЀr45LvR0]Z 
šA8aTѡ204 .׈,n	k]SR.081&]ʐm7?@iGWr	k_,:E3\ݎgp Y
STJũ[@F,v
VLBТ$&ŀm#@$(Ĉf YB&?<w<ZM_K$m!
pN]
!C)O9b^U|uS,8=?$L)m;4sG-ikPj/}hA(ՈNoUF^	"$ñ	f%/
_
׃x=zۈʂ8?&Prq
x\< s=	.=
=
8m^/_G@xr5+R-c>h^e֡ uNt N~G	/CA<KX#4tU4O[yX
K=

y@C-G9>9
V7#
sl\
b?6C~c1u09C9h ^_l E'Ȫ;7%6+R~9S
҄fíxMql1:^Phz {;![BJ> ? @ K M R8]#"!"!!#"_""#
|"Z#'#dBN2N`+[h=[6&CM5P 
?sà~sF5(mg[V% %m='۸

Z6+*;Ss#H[b5.Nm*SC{g}:1y
8%ǼGGWW q)P)@]>t-_xs" u֋stvr@@^JPS0w Fu
C{vPKCm99s 뀽	/r]BKEB@pw]{vN7Wl24C\OS'KsK 
; rK
66	a^2&GrU{.m_
\
>_>"lB
+[2:h9iSMg]|0n~#1k0V=
&4 CCû+UGvFp^ȻdWV6	Y7Y6aP/uQ[ՁsZ_ãJ{m-m؁Gq?RPm.ahGu[
סAǀ?
ec.IF<ۢBA
B{|c=t
\~.0 /:gKWgR`)Hε,ܤ;LFB+~;r߰*Dh5Q[.N-dmWmnvCVr&3w nirw6O
h +Gm10Kw>cɔ X~Rwu}{p}
|j}8XSSj_E$QSzŸoNJ܃
}*4R0P84%Cѡyqq2h$pHR^
eW٫69¢щ54-CJl_$A=^_`'tol$2ז,CD|^^K-G hru06кX(#<Tt7C 	c MG MEG<t1
Vw6CsbU5s,z=nCEG䎘D["/xV[]Rz^Z $[2?6
*^6, .| [x}<;-V)-V9붿+Th&+	f~tgn2s'W455֚ܥXBzJ`
x
a]?THs6lNap	FCqU
u!Wm靹p[tY,6á.[
 Tи>,Z.A~ ^
	P!VX_V%WJ{f_ K&u	F!dG )VDE1u+\v'F(3 .}~&V4C~qR; cN1@pp|ls0w^`p=`1SVe@K;{0|Yu+s3 |$6yt3A0	C.#9E'ϠFʊFK5FN"&PxŰ nT.\/|Dgv!1o8(鯺I|;~lrS
^3p !R#VhBj-tYB=mEHyo03mGǩ]Uډ+mȺ(
ZL
_ݫ
fe&/
vO4w6PQhPlzw2	Aw|)ș͊k#(wR8#W(H6Jǃ<УN[9;)n7,Z	6ĐFvH'PDVJK</t<\T<:uCG$g+uC*Z3NE%0;_%G nE
Y6dW[   HD \7s.|O	d
c@ZxԃQP=ɣ%O	t㣲E`Z}Pl(Q.
j3}28Ζ]314@;؀1G1{	nGN 50`nU&տlto׹m#3J>p[(is>ҀjV04.<87O
|]QYp	Rj^	ڮI-ʫXO0x#.*2u*P#xā{P	
xc]5p@؈ؕ	`w=.4^Ep]s`c$
t67,vMĻ5D-A =Vэ\ kW9
X[b뭗amĽz 	!?C_,W2hJ#`վh'J-}H=G4`%Mw(7*lu׵>t'0,;|ЃE<&)kYI- ^s刌ۦnelhRTN<
B_U"EJ5&m.?U4\E6жϵ d=ۤűn-ssw_ _GkQhy{|qKh	\6B%}x%\W|E~~HkHAh,:N܇ `(z}d=AE=`5[aԽa3'CNF0K
dRŠwbt;tQR Q.5ϋUѦUJfQjx*=\E6EGF(tOTR~><cC'uy@SD[L
m5aO07F3~E-h/V*iB"U
j{Dv#~ sfn$~nї1+~?Ohͅ `%j
=qж!W÷
H@v2,-?s s`^?9"66$)uP%=mm/u:t(l6lq?A#EّKW\bV8 |:i
yy 0f]}Wwü%Gȅ{Z@%
-j/481%p55A~52;#9.WM "tMaYV*Iaϛ2T$V7H& GUZ=|~a&ݸX5޾5 7>u)-xl =^(Bz\EW"v6BFsQWFV݋Zp8i?W9s*tD?CX*:bkVtN=C swlv/Җ5/+~:Bؤ>Nh݀>{	\(-Ȗ@G=B
W/_B<jq
6RF`EW^aWfmm;s!bKlK	@ukTC 
ߒ@ČVp? Pr޲JoCF}
f.uF9L%;PWuK܉~ C$6h0;MHM./1kj3͙ +,kAR
/۸(]]΀O܌~E~^{o}ݚF|bN%$c2t

Wg
V<ANBA*Q⹧O@-O
X;uDFE `F*A	 h@k{wDj  E;U-AR$v>_k1X|z1P_t6q_7*pĘ=/ƠG ZXWi=i^YCs	S=CFl*N؊:ʥƲw.aWۡCEHqi*"L*gx>^5`=Xp G>|7 5t(^3hܹ9u[=hv<LNGGRXǴ 0Cv
ݧ.9",m}	QSf,5]6cKS»H ^e_'KtHeCa<.@x3.x7L< b<Ԇe!0e8tߢ
g-	J7`jX2;鰡gƏʙK<叭2
 ZS#cC]
WV
]aЅ!hN(V8RN
6P$tpW4K
& 024=6
	u\,7:qRt7(L*ֿ\8:p8Chctbw(E^\̆vNE,U.oE
nѫ 
gKE2/G\}5%1@1[ mCGr(H}suK' Saq
+KK	.-GnU͜P(ATo@dE$~7zXk\>e027)ÈEJ W/
$ 8`:|j# e]Cx=Ѿire۹ E*u-J&/y	sg\*\*<&G]M7I(4&l	JәҲWhaM/@­8LmgKh,Hx)X`nu$P|,qUWu,\RQsdʨs|Ep);tswt`*^Wǵ[ץ\|2.T*8:[<Rr$ؓ_O*SReMW[э,
D.H
*	tGg/ÄEdGww2j%l(A_P6H%s lJ/D,
=\?
@.|!Y2=c	 ,A
LlX\ӿK,Ovt<;6^ĸC$PPOV	<P'v6()G_
zare
|7_\.4_f
~$Ob-ơ<mFcZhlYVyC .j08]Ӧj=xnmc*Wux͍.Et/uTGYWr;J6~w!XPr{JlpCQ#H>hc=\t@Ba =8rES.FHBRD- ELݹ"QM}	_ZX@	$
^B6JШ0W
8H P~&u'
-
g>5;'5L֍
Bw)&+iwbZ wBfIlB[bQU	kgL|TD !Al
UhޝF[od4D8(0L(lrF0$=
uF	Uo7wXw_J7OEuEz^xbдv6+<ve`4U
p39Jp,Gt+m9k$^7wrA-'a kT#*ɗ4I Z@-2$8:$M^vI0.n

<6#E>83phlALhH	!K<?tA:3G+xFG5`x3
3wnX'Ǎ8LϳWPeOXv=j~+DwoPSqe17)S˽L?s՛׊մp奸w"R&\dIBZP;~Q鳼':?ڀʏ!ds C8!ώYf*2\&pO&6v8Xuu[O
6<T@/F~kM%[ueԙ|VM; sNSȿ0ԡ,R?-ͅtI;NtDv?kFE4{1e@[$!ؾ H`LA8>s 'Lw% MJWlG:;&Ru^E`uJC2iG:4=D+N1;u)(l
**j;[fhe_.9Bd9I'F]VM  ,"HG"m$lrXGQ^=ѝJLIPGKr.)ӹPi|15=os1i$K<&[Ő k1
EhX"
2sM\\G{~Lg[.T
0 
߁{2qUwt
(Ї*+Wp*])&BA
dr_
Q Gtomk3n<g[gvZBƲoN>,kuy:nL51oe^|WvyU_I.VZUP߉,DEB)V`X
.E
]SpLGG^AALXW`)4U;N~	tJpTбA;$/jnD;&9h|;e79)uv.Xz9!%72I]`WR&[ҳVg[vi:? '"`0<LA%]YupVƋ|<.xfv<>,tu2q[ lvf:J^sGljG+]JcϯUx^Y&j._7$R[$QTs
UV64orP rX2U{h
ovQ[
u'9WO SU 9/PsKv6"9"$ 4a0.X1t
p.
q!%	ӣ ]'-3/d8
;	!B;
!En\w2h0	F-؜c4`Z.9[v6vn9l;lkEZa0g_(t"q$XFaWmr`m`J(,*T"kc#ܟ:-VԏW
:GtѺ>IB\XclMP5P,[@
dg?|Tl*x#K.Lc
`7[չ/ #Kf(8LB}TqE7kf5u
ǻF( pI8gN4@wET>(O&+`G0E
ݎ|[ƱGo?cUc>$W7ZI֨ng\GăٛaZ?p[FT0Fk`\:\8RRKkb8[:7	+8)7!s>)0mU_Jd^,k.PTc9]7s6Cy\ (]pj^p0.\둮X _hmӬK4,D'<LFVXJ=ZM eIZ;T6vb-;s(|28
au.A!6ߵr4&Xc` R3"۸%@Loi\:*ƗǩO6G2^$r,
/"v%RM))#GA#$rU÷j	Ͻt |K. <J/pvA	>(LJYaGIq#e4e\AUDt%[u>[D.D$z"r
x
	) >B|r0AyH輮|YE;ŞM t _SNAn/fe`;ѣ=fȝ$+l#;;s+2%p<v
)z& ;&G+~nsh>P]nfݝli4]^lۚu& wuC*4d{@a^2ȡȉ"z[
]P'^q}NlGbĄ^]/l63%Nhfdjrxe 11`[ę5#\+VkRvZF!{D|DY|zw\9-i

/LXX7lmbV-G[jGVunmc)	G"QX:17u%v)cHi(
Un8<	T঵Op"[)[Z&!6HTO2mP| rGWbB.?vj	3ࢋE&|z#)w!uB~?&T!|!	7n\BF)xw!
0nZV-͘|ZSF!,RDSQH5cMB}z IX>n6<hKsk~*6RآOρ>	
x /VLW|zğ<+dm-NXȏX
	A<1>@IvKjU/SKq@(5&o+3'm8랻QuztvC!L-(,pUT؍?Ёo,mQ^={n G FҊB~-TlEE=S1;%tKt
"ةF~[Jۣimd&P=~SnwHP̦ dm)[RQ_CЊ@=D)#iy_w0t.=|
v== @sAFj 
wJ
QNGj Mi0gVFVۮl01XV57H!#%'57۪=)
+
-h/*jn#i%f'C	FO
`KA[1/3|
pyU)L+5+mʀ;vҊ 7 /Fi73YY `aX|  }~Uj׋j\F,0P`mV,1 0	|軐Yx0{e!;Z 2I7/Sڏԩ+~	A>5`#baj#ñQHk|Pސ)!BiGW&򋇊zH#;]wK\,tz@P#Ne<mJps}+=ov9w1ZQ#(}Kμ
X%~(jf&Fa%) 1mRڃ	
X^dH:^ ""ppA)D}Q[$(o5SS^)D/
<$ONN
,W/4^RX<~{G g"-
Q¨Xv}LO
|H#mV#F"GRyxXYoŊ%Zssk9 |5b4{W$_v_\;v[@䫻&`MSgwK9t;
늠pC/*Omj.T-q,GibvFr-9v).eF5A*+mFh9EGELюU_Hms$wлOf
n g	!@ɣIYx&/UC!
+#? :m55L >򌗔k5S\
KrИpnG(^CH7w3]]!Lcó2yxy/M%kbE'Trǔ#^WF4D߷DF==~$J=KCոF0ҺE%X9kB@%d	bq'陊 A@ehA
Nz^sqpAu[pWh#
ѵ~REpIqEv6L;Pw_;} cSUkZ}	B@ǿ|F
@$tN+@i.8v34t Q2T3XĮl)x؁HVhXp^`Q#	B'55ef01 D0C2xHhh?@uXR%YqAe^%tGU[@yuVLk81G(-*> ?l^P?觲Awwg),&(:L@o:P?,A:G[B7 rFF#~!!cG.>	FiZ4ZL
xɨh_C``^b(4+"ChZnaY&@=Bg 	C-W3 3ۥfRw vLøf<;N
}7]*uw7P? s?uD4 }F.>w륈S)Q˰_G r	|T{;
DX gW 0BJAHQYP4xAՇT: &,7_9r?ΐLh)_	ELժǷn>Tܬ]$P.(IDF}}/
%R(~S1'Awt Mvt=vϥ+K!6#)|hnω 5: tpCAZm}ELnRhNKmEZ9?,ֻM]Y6tS
 	D
9k^1RI>6ڽnB!#݂	L3k{y`29GlW#"ܕC!$7 
2cwZZ۴By@>|+G+.*UMNF#
UȠ x	ك YPVd QHQEerg #e=:>
lv}3{)bpFE3ZL,0DO  !DzDR)N\a㛓


45Y]-RW_Aۡ2k 2~0Q0ȇɊ
9@Xс@?p:CCNa\T0wX%/w4E j0(z	LW+*(kjwD0O(۪̥ZCg;|@a1U@> ?:@PG@2c/46't .en&FY2¾+Ǐ E k^
v?F򍐘KR&:qЋvTCFEJt\H4,d/*W uSr,[2Л`k)}(%hL(.	%Sj		=jU藾E
NcT 	<`QO=61\]zMG/Qr,Vr
zEv6X4OU5#`,UOٲx?+Ta1,0-l.>Kr@1;̉%
8j'dZ0!1RvT̴34WHۢ!۸CBR7pnP6tW4VKP_v"`kFqclmdF䆨sF*?
h&ψDlKBJe /Cװh> {BZ)%`GzM[* ^rkk9kMkRzkŌkC^[DZo<5rve<Qsa<bt]*<PtkV%rJv<3AB8"F 6>.*1
ȕjj7`
Nt$+~
cg7lۈ&Zi_z̠ c6 Krw=$( 뙐9n_A똞&[.n*0d0v
J
kXllnlmmmbn Kk^k0#Zko4?skD
lx E΄}vV$[TUW=7٧Õ
&Jm,rvvhqUb-, EY+L
tB4s>v׺'Yt`6* -j~7wD+@-|WKtsEH`I%K6u7^u1!(L;U/w;;E-wmMu
u-v׍UutM;coM
w>l
w[/Ngݕp+ᴻw?@x|%Yߦv]\|
9J1V"?AS$pb\U#Vt MCa)=wzW_4dL`jA
;na&dG`_	UG@Mip
[oz7UVF<	pv$b EQɲ?wP|Ku .w+ے,ЋBEMw6Hkpw	qAG7lb۸L^3wlq}qqqqqqqqqr&rWr`rjrxrrrrrrrr rrrr	Ytr
sss	&s6sGsLsmsussssss-t}%tt	uP`ukuuuuuuuvQvqvzvvvvvw8wwwwewww߅xxMxx
yy"yJyy
z~z!zxz5{b{k{zn{'|.|g r_xkxxx\yysy#"! {zzz{zz {1v!@48.:0*2P
ΛcVUpy~~8rOv*V\vi^`viejvluvA
Yjx$&>7)HvgrwCD0swY^{:o&NO&SfK%躶r_ '~Z">,96ܒ4#/ el`moL5@]kDP!~(rVMC<$tgxҬ!>92wSvKt:^4?Ѫ>x9Kj??f	wipo>Ի+
0
q+>\\]`뭡XoM`o땻f.IV
G0k-l%oewuVep^p`0bZ@\O!38d[fv	jd
覱
5yPP%l2]q!=5ACk15[um2#ؕ`ۋ)\=ueF~qt!';/ww<w$uRuK2D',6a_a˛Ds}.Ѐ4_0D^[`͖P
?p7I&(8Y#-(×^aD!l]P,8j1(Wv|W
%C<^ )[o衩Zi=[]0+'vJ/t
\ZH`
ٿTea8F`9?V,p!mmU=vO潅hĲƻ7G{wA],	W[{ƓedŻK]51	-ctgg/bI 7K@(}p=]m@hdBm^Ҝ,k+=#<v,N,^W-Y|(A+p8:1tgnk)α׵pmj*
%"k!=}
t#SK=겛L
GtX} Bɨj+=M
bQAK0g~t5g4
lCnA95@ׁ~XE"oRA $w\묠Ppܐ[b|+}z?; .<mllA 
=f[lx wO$?<ۘFq ͷ> !0N $*X(K'렙&l #8S(qi$U$ bVXՅ
8eϩ}ZK
@0FPS	[OIqW@q	wrI؅ptF|{"ۺ)S9~к:)|nH.%6Fh0@, 8+'7`M(^F-c[bZZ
E2#rۋDF[(OD@骢DQ8t//	v`#`$0M*8
x!x#~AK p[X-R*%{$L%Z?T%e$%W,׃$;*Ȣ!BA(ݡdt
a	p%~9U鷿Ѭ
D 3/N[ !|+<6>u\fV5F߄
>wCx $eVw7ED}p	^Tm
|8fO~rra}tA!Z5(Eu/P#QR10a܊tu@Xr5(z
ӯ߀&Q{D:2AP^MR P|_܀=VF".,qj#
ڙ}}4~/~h~v~~~~~
+QcLy*pJu;@I[^

#\
(;N(B^Lir1}NE}.Y0uΰࢴ!KK
eF!$6 C%I!xKn3]E-s%DJ;p@සd!]} 6
V,R	r+$.뿷{Kv뱡
>F<a|<z!t, 
</\(u6DTn@@e 5?8wNn:D(:ީd'm*ӠV'KM ?
-*&m)k}ft.mmo\a(8
]FiG4JFٖԄmz
UD*HV%#~H\~k1kb>m#<;##vo
@,l|F',1_nw
	Xsx}҂SׂYCq
Gq<v@Ci(
turAghۣmvboFkNrlhjCZPU9Iksh)oȧE2GiEJ^	Y.eD	uhۅ1hd4c*fxUUD0whtS.?N1.
D'
@VH@g-
/l@() 4	_k@[
t%u7uzw
@tD\
ZWu$tUgӡ]0Pcgh-v`ww|]2,ɊT
$J[zV1E [	p9^PKb](w]Oc70k%bA|,jA5
Dx
h0ǂjGs Z6
T޿Jhjt`u	|-#`	[pXy褐6CȤjp$HD'e MxVN@[55ZAHh)}b1 ,F^Fr7P!򤏆\ sP#q+F#9KO,4 wc2Z$QՅwkyGz붅)PPaW||\tUuPl1P8:K|7mtb" Z4[̵}mFN,=V
SWfق? P MuBMмE][-0tZtp"`,	@Z5K%R.ZtCBAo7?nR7a ;P?U&Tkܟch`,%"
O)u ˳=#Mtܛ|_v'ڭM}%;s	|=BAnr%q@= OYc0;w1g&)plE "fv&6 "k{
'$Uj֭ML
eFx9/9
1lMY	^x''tOIj;tC:BHV.ۂ<53^#@$)]°W.CB&;
M,=!`a!Ca4ъHStfGMD -	"¼td0pEDkuQQ'
oNȎvV0cHBkqe+\R3u,"P!辊 Fv0HV`3A W]le0U]uY%sFwF)1gOɎډ#>ƑGoGVP,W5>bKJˣ

"|,w&{>FBǴ/Wwm
l$]
l_P(h벁wQ*4Y-}A+ls۶V8O̎Ơןox u	bj΃D@H1뗋zMOweh#`;/;!t#sG}WYAmu4uZ:uf[SÙۨ)7_Wm(R&O([RĞF*p1
X5_,#ru_,i]E^4\/#1ḆDFX3bb}C	Z=GuRzWzWS V߇(_r¸-eiR"U̈-t
>߃xV¸"Ӽ
v#
$*_Q.EP 7 W08:2 Q.{PҒ4Е6 4}%Qw`ėM4߉@نj)\cxD]bǆl4mͲp
 qRHPеxZjtĺFJV_E% (\V(dlf
/%U	kCBU,N
F)p
[܊/-:rv
(
2/Ԡؓm @iw
W]`|?.Z*a|ƻz8? 0B(um'FElm
\KT	t948lWW*V].0Pg

PjW}eo^\PyKfD(pNKqM]
 9wSİflk|a3;pή&?@ Pް;v; wP j&IS[Y6A.u65Ǡ[si;!Eq_
%Zx;
so7PHr3N /Z$ r_jãW(J}-vA(!Vz:/Z9[֙lj'xn p*.LJhZ A͟S2 ~n7Ѹu
 z	1gԩc^m˺ih9O@M_-NNA4EH
A.RSP뭭
s\UsnA +Vf4\b+vwT 
QTzrMQD*"K@XtR:
~; =-
@!z@Pu!3cI;]2'C 6
u[6euvh.:0Eié
#H2
0_.nL<,UPR>Bm^ӱ+F8a2hUF/>Hǈ"^,oumWH
5iJ}~wsV	ۡEu

S0c1-\Rٱnv@Xa
a3H:F7,d:KGu3< Gp48B~Us	Lw+ =rT;|%v.[KViJ=^`";DsYQHA=c7hᣡDTwP2Z)[UoI䚜ye>]M_Oˤm<]4zL$eNTb\lTR]KBp>R@eNnhd[@vnP"(j~腥z}裘#}7s(:}R(x}m=u"MԾZλaBޛ`fC?p%t*tV"81c}1QHd^.>hpEA	~R}õr	}As$X &4.LIIˀKb&FIEl~ Q,u
6E(ȷ1lPr~րw

@@m?׌
h1uCa`Uz L12wfQOs 4.W) !psSV [64R|
GQ]_|J|2kQz6j1:T|1vƦ9-;t:lFSj\C<{G୳Cm\+6A#fhzWg>O"} }(@?
 
bGЃ4žK}☽)6@X.=Lڷu:ڤ4!c}<PhJt"U/<.rv<?
h;<o7</	<*)ʴw:9s%?CP몃s&;BTNw̍	keA^<ZLI\)<u:G$^<v3Ԉ5aP_u*VtU葎 ,AFܣtirUnj.U+Pfǁ[@
/:$/ Qc.PU-}M+@
Q(f?q$P8Zɘ<n\.6 k#Ga[p[&,!89u4Dз.Pitp{y%mU}\l	\aFN-@{dP8zPΕ/*K\ʉ6/ A\uKT8 oOyF$!hpx#sM-L2@[OVUƒ0#,v:a_2?\ zDo
yM+&Nh9s/0ID $(A,t
Ehq٣_/5D"M	v(v
&=X9"C r~ktw:.ro!B/؎x<kT\lyxzQ6LB羋^DE3kRX\m(`F&ZXM&D2a>bVQnQdY-q.Q.NuR]tEΎHT1M;S\0Ռ>"ht-nZ L(!z>*
QM~K%wBiT{l[ki@`w`3RP$RKK@^dPnZv$Eq !Gյs'3>-չXvT=6)2\F'Su/#:L
| B\n%U]
&"
SPڍ訹`iZo)h Ah&x~C^Vt1VIx]^
Fb#UE(Y;We;U
JDw:uS9rH}H[F_-	Se[
 斟tbף(0 õB0K=a r=z / P?v
+T%G`IuC QKpIQA:r+!&FƅFPU7-OAZ#[R̷	6߱jP6TJE]K4ADg
40i::
 L 0
Eu|T-~ Q*ś4&&%jJlka&(C ҟw뵟A)U -Tޱ.D

uHtAo6
fXtK9SS	s#zDS>"B_3uF6!]5h6Hs*jwBv+lSs9p4R&2[vZ[_rΣ3%pgI ׀Olbcj&{0ٔqDtQ
O
~_8	gl( W[9Q1p Q6IPRQuh-W6ZP8,@{ӡOШQE;u< COT#"w&"֡ġ⡘}1
ء\8iZTluqvSBSLϠ^?Fň%-s1R1-
N+E$oKP@ap mAScKpE
.яst
QGc	~CSYa=
߂͈)1\s(U.~!
pEUp}Q@[:lP1^ | `-S9}%B}˱';Im( 7+AX-r"r`!}csb.
b85%,يDqX)h 6pD|o.B
Nz4]
eC  wZP{@
Vk[
sAHH؍
	p[!wlz
p@
V+q?} U7-	Z`=^]*[~SX[YWIP?ٴnrt,K`zEd>x %1Y۱WrnNr ֘Pi@{[]sb @B2?м!Eີ[tz)^ֺ9Ⱥؾ[LK=F8%	o+쾎oPztk3i3o/o_ <u!t`PQR$A:+ߧ.} ThuoQ/ЎG[ ^66m%l,ˉ/GP/][ZXYSːC/<aS[a=${>=nZ?pۗP$YGjS/7|$H	Hޏpj3<+EP)0ݍ42
"'sim
t8
{k^_؄+=@4n: ~-	PlZVQi»bktl
"7kP3&^-4hE{(!e 03)krDieYkq :q Ȃmkh {nRwk)7
HnMkS~ƏGC GFV%A ^k; &[,?` U~} &]6_	Rt8k:m,Uٲ	CUr*trjm]6] U)jm@mv-Ƈh596pyou?~m\ \s~,mɾo	 5P5- fTh)\*H`/`} f\އ 
iʾ\!x^7w jU͌ޞčr`4OݠRGG4#Ϣ~1ц> rt
/w
DѠnj/
R0o|Bn	5Kbw&.(Ik<C(
RGtOjA,X&W<(> we@6*mhO >EF902T| ]'zزEX@C{T5w(&SmIKMOA ۺc_i_S}ݸ54
)8m=NV
3	)r(͞6t5
 g|;!u/{~~s
Y~ހz
uzs_e.^t	
MRv>2s6Q[	3?l"nB"9rTNS`g-gC0DBuҜMU	R|
8,,
W#kFpa
,[BP`!m
F|
k/UFt0O= ⺖Eߨƶ2"&tp$<@( eFJ-2="f"
0@E;@!\
I1V9Gs?FYl ezJ%Xe [h#9\[8<39,*z-)@X7'h*X|B<\ [/=g߈_N	C@09tM젊XBՂY׮o
:*8
7A^aҢn8VEf$`׈<}@k=BD2t+N!PDY"׈42uUM
J3w2t.4}ZHZ!@A~VaFk钉fW렠j%%RlFcu} TLP$4B&EA\	L٣ ^ap޻KVڍQwܸ|'Լ6(PH(c8KG [AHu:i[@Q$I+A.=h7=H t6!e,@Ggpjh7Oo |U>yQA͢Oàwhn@{TOUmmFOOF|Vc Pd'<6. z ,)l뿶kB(`sw1kWD.jb	Qd*qUQ2,J"?@/d4k)(}BiQ?3,и¸Wqt&(pe(* ,TG\L[
D<h>Be('W$>ob2
ab.n;-z.~&+6rJZHO*,z[F·np
"oXx$lPVrSEu3I0']
ۇƠ7{xw%6'1
[Q`)GFs	F!GJ7[6l\7^4fc#-R2oZ͢,.1@p0퐍`h#n>ls&S)6j9GIi8>p
@|,Z?t$hA9,PJGSC9RMrx9s*>M_CVm!G T]dulj5$͖~(:H{ &MOVn(#m>Ju#蔷JJMnhzh,Yq37V3:'YsS0{E@bv++suHćRg2mHl->ߞ)JuF=<AA03Yab=nZLAD0P?.|;DҺ 
v ErE
omgWL6tURj'պHHXƹHo' #Xj	"8O|@}M1`WyGPBȤojqo@#  wʁ%t&(=t	Ѹ*%
g1#uwzrm
	
 HTB7=@>c
 d] +l*X'2ld4);9r;Dvu1 'UyynYN
@4w/#={iDx|M~
I*Dc?J6	]
Bu+7/z@>v:ue[SpɊXvtOOol''R`QC@[P@^Wik&l봾"̾\7ZYTYaj׶,
1@-u~UkS{CUNbX]B"eV'[ xa! /n؉#5ݧV6$=,MWRR[s.EW8+E-0 X	O@yFS59}A"bמZ:u^C-ghYk欢DB!G
. ݹZUCAb`d4hb(+oٖ^A=^	5Ci͜M5;0}nh:D#+-DD-aEö<A|[2Z~^E,@:%[[;Wn<0oiܐ7l#
Tv͗4;u8,(x#,X	3\`(jL%"l J.!R P$Yl';B*3n33׍=@&GvC?R<Frv.<K/
<Nt5`E\{pR5Խ-M	ߴlk=kabP~W1CN:u=K8pK C.
0|&,
ʄ$ƗVpz>^͓@pNyߠGRu=
@!|헠ՠkP %yW
!
Ǭj3	q/+j轣t)[
 sA, |k#@~α|/蘩6GR+._W[/) R?ǟ(Cĺo~7(@g0ċ%'4pu ĝU Z"UEJƎdl\	 m*^sD-%@yA3"P"dB]<G$AAΪN޶|P~XZ* $4m VlVtBN@5I|XlD"AkE=OHKJ<
'hH݋NOJu!Fwj+	5h\]*s2	ꊇHǭo
	pJ.%#'f?[g	
4~B9n%v2Dn_0´2
k96D$7Au!
&|^AFJ"QmwD	Da G)5
})g|=Q{E
Q
Tk
|T@u.BU(2@ߍTZStQ.q:X[+5$QLU8
Sn ӆcO=Ru#^e	 5ZgzJNQC ?w	>0>
!)gX;P.)k$Iuj6FGs(F_d]<+v9Yz, u	]0XTJS۬R-v[6nSRA
'&kCj¿8k	D0^H[bh-uE}+h nD/}[	{c~cv}c 9EُvLex:Dm8kBW{90A4B@~/u;UDJ
X^
&V>EyWQ!ыMo .OGz5|"moI'j m-l7Hu(=)XAP?]LjX<&V{z{,࿖Emo`
qhDsgbQa!B;;?rns:'z;E:#r￷u)Ƞx/O ~RPSPJ-µ$Dh2M$ve<}	Cg݃L1'R<gg7FX&&[foh0ݸw\ 0QsѨ_t	Ptфn+`h!jDp|+}w6H
Ih\	t͵̵PI`CT=o~	y`(aX
UFn&݇|B`IWv0fu*wPu$g+?	}'A%05b
(zo.yXbq
0,0-Od-5mʚ	A
{L HB1'V1=!7CdidSM[ ^KP@6J@~@  :,S@oSW4S}߈FVvњ%v07n("V݈c ,u#ߊn
mĈ

q[=;u47 Es&h5L%̉
뽱fPb77I
l	$s^*a
vU
.M/2nB.	`HYLG}LR4б@և$dĈ/_vZO~AKvL^d(ݎ

r/^vt
|J~xzmq"ރvQ0Id!.E'5XB8
MY oʸ!aۢ<hm;(}Ţ#."
BÂpU3ʏD$9tNAw
o'
aF:hK[i+LA }T2KC@(y
0پ!<݈aır#nRZ(ܒJP.b*#^9u*=s%,&;Dd8?wj%k)	^NA']JÀqrn8
_p":mkki-͂܄: ADv@T
O;l7j `ܢ5xph]P516 +yxt!
S(eU/I. ?]@,g3
hQh0orpZ
NaVʡc	6
P"n% OjkjW%)`hs   );+rЕmWH5JٌfKABJsG;wu\duU@c%c#FxNRLFHA0OmbA1JjQ
wjĀyOO"E}`#~/KGwtdPx_)FH\DDx~ttp mA[u!R6 jԽLJkRm@BBEmE*S6@@
->mU=+VZPC[*ZF PKIAZ  E:ǅC4qCX/4OF;FwQ*MN9shF%,GDYEKkB`Fk
/Z-.[xuspoidcXS+pq͒&̓.f͍p9Jg:ڷL%t	T](FF	 j0nF0%p|׊ٔ
˦Dm3\ Ն
1lWY1Z
?
 u<6
CC46G5,ZPw	TnvѨ݀6gE	-T-r_A~ac_~M(i

9̻`)#E&U[tJn@v{)]7t%9T.к0"b~o?
*lJAE
T>qLc*5+D+}o渁kn[|<rPl%]b@`٠!қ>֊lD(PYovmRR$ͺmE1DZ8T	4	 d=D֋T
6Md	E^%Q1! $@1TMThT	bQ6C=a5+r!CZuvrQ
77W)p&uj
ӯV D0F{H4lޕXAzhQ VC]ΡTJ O\xvL>\l+cb~enuSNm8$,=vkbHf|7F{
?&^zw	~vPKp N6/f*'>ߒVKns/F?PUtMO#_4'̛.[j1ؠHY)vr(ur_ np/vdi:|P,4@SPcıVkư@m  Yyre	 N#,vt.p^3Z:T.(G	,.	"]
*p$:' v(=+ux,/rr
,u'(pQ x߃IF#G}!	#%' EgX&@Ƈ#AU_<>Dn/@~,[!R&MXt O.0Fg 7|
){_l|v,n[ 3
m/'-=!E;h*Ut
ދd4,QuGm67 2'̲	F-D?ge
HTJ}]oTLNh
/'U(]M+p:{wxVzy4
<K	D3b2
po G$>t/FC[x@ 
vX@̆F辄m/Ļ$W{@PEZ/>vF
MknVP=W4OFf|]Fe0Q'76 WXkfR:
_O>ɷF `=`UANzddUu uK t !sMTfmdC,=J*VtSHLiTmyKYeږYh1;߲,VڶX*OqO+k#a@S@/	L[?	a@w[D)S,p\h6C7sp.g	,+t=LHalW5mDklGZc*U_`$X<VI;þ&mWhVShGDWvARƣx|^U(	
'j*Zzہ?v<m;OAi1,El6G[ڸ8'ʸ
0$
-4l;) \&@J-

lNq\LE ;W#$4nTTH^E~Deݸ4X4) w
2Ul|Z {P=[P۸@]b74ևn~o>DGPLFuwtpt /s6n/&p"-gttn@tu&
3e^7tXR1Zfyof#cu@bxP 0	;9`*;[  `/eLE($:6Ċ[JE@
}hkiAD44]KOMSv6WaEQ~S7 BlIU1Y@
߶̂OE6Wxީ0
 -mZg^.E[Au8p!<T];kQRb|"+8l 1:4hB}7,"!DL(,W=5

}T\y)-h##1ۀ}n`;ƀz>pBoBd>+S4azҋ
X4 spFG$ Q"+8
' 3 /R>C: 6'w(;F遼T\T7I2t=P(k56	n3.hk gH6ګVߞ:xRp)m4&6"-	\v zs#hRbq!`6_ko	 Lޭ7/ɘ0.@<m=UjYoY9}BiU;BXO =:5P
SG^*,%nX#BZWMc$HiĴ:Li`1mC)=h%9胈{vőU;.Zmc
Pl?Qpz/@p2I
Zb
rWG+w;
AS+1ov׫!yӠx|
w@-^y/_
na:c3|3'x
(C)pyright995-Pasq-le J. Villi 6Th Projec
A R@seved.)ikf- softwa	C!ޛ% with ABSOLUTELY NO
WARRANTY; youk&+m 1dBtݜbuD
t}>/ATonfyuT? vrmUg
GNU Genk¦ublic Ls6$ps&[by;FSCFoUaPGw;
e9`@H=2, ~(8_%)PWnl(
'A:-@JUNK@-.TMUV !"$f%&'(*/jVE63 /Co$<μ|ؼ%,%7
/V/t/	/#/)/.3/7=/kK/MS}1Ycju0~Q徼yƮƺǾ߳A>* MUgfSCPRG/;_]]R+ bBRfB ;+EUR.0Al 	!'+$$HU&&YB'W	)@oA.*,W  r/r-<DKK.ASEK3/+afW0+PLN&1¯l6V[r 7 =d=Q mB_vfX@{gWBGL	|PUAH' [DISKF~  vp 	q `	 "!O@	  t$  # w$`7]2\oAUX8YRv
%Ũ+n7pЖb*Քo%+cx - 4T*MC	F32^juppt

%s?oH=.n/YD 
IlkSP;j,*FloHy/X	-;l  H}_inve5js(@qbo t {_<''H'Ewa<b21HVd0JDY.PzE:2O
>vWIHESqEM ;WELOR	iHLTL&OXBREAKUFFERh9h<M6tD.TR(s+D:mACBLE`HfLASTDRIVE	dMkvLLl[#AmSA6`jЇIY}EVICE6Z{IN=TziTCqDPBfdh@f.sy
50IPstf-w
jv
1F8yfwac$[r58^xip 3.SYS/AUTOEXEC.BAT79s
#pLlg'#
[Y,N]?YC{0wGgYKq-#
FbO9Qnh_Kmh:3)'s:oadSs=.av[D*kw Ic7?r>h ͠v"^
0=%u=c&Q,uc{k+)I+3|E
VD-ff = DByspHi49M"[xc ]]pc[mT](+3#vd)-bk 
&
x:S/ɂp(3m:0X ClIcw%uldb5,3tVmfmrID
cu4hKa0i؇3  To:33na%"mv=kx)=
/envirom[G,u5-C'd[d."%s"QS: S/beN3 f
3	aajamk܌jA]	),svo(a:r;/??j*egk#eF#h VpDy63ludu%.|x:%4u-%| )6s32%tPZprIt93hjQPiC,}ditxtc:qD%ܫ%2dr	S%ŚR6,6ѪBvize
ApDrԴtl(ge di(?v1l1mF maG2 d2Зs7rg,pB9=0x
xv08S0]00/_k,Іml63WCaNG:sSip}FS(Yccul#fuћizO`5(ad3]U	{K-4~(Aks*x'^tN L{<es,$䧘dogg=SKvPl˹P]~FC4-?ˑd.7):tDNVeVbF:dLtE)SG!`-G-`/[d[tu@ '30x׎YdDxs,?h3nr/~IL`H-0 
ߎ ^1 .xn fo`,V$n *xR(5q! 2#O"#&G}+d&h? `<4    @ uu rAsU fsIItɉ͊F19 uA1 sAA )r؍(󤖎P1X u  u<F][Î1&-Ht@uGG&=u&9Uw r  ` )  YHH1  &  7м1P &Cp2`t   +,-.-..-0-p,,+P+  t" ~}|}Pp"{ z}!tu t+} |tl$7%P '%($('&"!&3&6@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PTg~P%&$ |Q
!0@Q
!DD @#((buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


                                                                               MZ ]  `  .   c             F  /    I  
     &  o  A  )    %  z
  T
  
      U      y      n      n          "    	          ;  "  "  "  "  
"     }   g   '       %  %  )$  $  #  #   u
 u
 u
)  )  )  )  )  U)  8)   u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
~u
zu
vu
ru
nu
ju
fu
bu
^u
Zu
Vu
Ru
Nu
Ju
Fu
Bu
>u
:u
6u
2u
.u
*u
&u
"u
u
u
u
u
u

u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
u
~u
zu
vu
ru
nu
ju
fu
bu
^u
Zu
Vu
Ru
Nu
Ju
Fu
Bu
>u
:u
6u
2u
.u
*u
&u
"u
u
u
u
u
u
#C  C  B  B  B  H  H  }H  =F  ,F  E  E  E  Vu
&u
u
u
u
u
u
xu
Nu
0u
u
u
u
u
u
u
pu
Ru
4u
 uS  2S  !S  S  S   `  `  `  `  `  c  nd  d    	u
2u
,u
u
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          3Ðj薓ː
  F  F~ F F^9 uvfv')}fvfv)~h	h jMRP詎Vtj
fvvPƏ
h	h jN~RP|Vtj
fvvP虏
 Ð3f>^  tf6^ *f>  tf6 j b荇  V  h j胐h jxh jmh  h jah ~KF ^v&v& =c   -!  - tHHt-2 tHtp   T  F^v&v&8 ^v&v& t^v&v&   ~L  T  T  P  N  >T  uT  zH  J  kF^vf&0hn ÄF^v&v&8 uNV  *=p t -d jHH|f6B jRPjjzRP莈jjRP~jZRPnjJRP^j:RPNj	*RP>j
RP.j
RPjRPj
RPjaT-r - @- (FF9F}-^v&&?-t^F&&?/uF V]=sjxtRP與ja,]tjyURPij`a>V   h	h hn fvxvuj fh  ! hq
h@蝌f6vfh   hq
h@`f| f6vDefF    .^
~ ^&0@^&@F~	vF  F| 9F|jF= t= ujRP蜆j`.]\fh  j X^ ` ^ ujzMRPajX`s>R  t!G  \t( !  9  =  A  E  I jJj1fjއ   ujzRP煃j_
t(b       ؎f&fjxRP蝅j_>P  t>R  t\  Z  L  >\ t>\ u& & & >\ uaH>T  u	>L   >L   >\ u3T Ht	HtHt8j uwjJ9ulj?j.>\ u?T Ht
HtHtHtIjj MȐj?u+jRP跄jT HHtH
>T  t7>N  t0f|A  h|h|j
> tjJRP^>J  t
j H^vt  F >t >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uF'~ tfj fj /F   =HtkI-
 -!- - - 
tFf> ~ H  6 H;~  ߃> ~ H6Ĵ &@u H;~  6Ĵ &@u  FV^& &G|&Wpfj lCd   F >J  t1@Kt B= M- K- '-M- 0- )fjTD>J  tzj "\^ÐU
^&L&NÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ð|"~
 hh|h|j)}X >R  fFffFf+fFFfFPj ff-    fPfvFPfvFPff-    fFffHf#FfFƃ~ uf~uF      Á~ s  fFffFfFfFcfFf9Ftfj fvfvFPfvFPBfFfFffHf#FfFfFf9Ft3ÐfF   fFfFf+Ff-   f;Fvfv_WFVՐf~ uF+Ҋ*ҋN^+ډN^fFfFVf9FvRPVFᐃ~ p  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP5
k3ÐSfv
 ÐT  Vfh  P FPcf|K  Fhh|h|jh> t3^ÐFPzBFVh	h FP΁RPhTzh	h fv貁RPhd 8zfvhd y ^Ð  F@Fq
|"~FFhh|h|j辀}*ÐU~uh	h  Ð~ fh` j 	h	h hd ]vxvu3Ðfp    
fp   ff9psVfh   f6pfh  `f6^ u*u%f6vfh  f6^ +^= uv&G
 tf6v[놐f6v[?~ uh	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP荁
fh   vfh`  j f6^ @v>  WV	~ľ" f~ th	h FPw~qFPu3^_h	h hd [vxvtj ff-   fPf6vy
f6vjFPy
f6v|j ff-    fPf6vky
f6vjFPx
f6v{~ uo~|ij ff-  fPf6v)y
uLf6vjFPx
f6v{F8FtF8FtF8FuF  vB܈BF~|~ uF.~uF6f 8Fug 8Fuh 8Ftf6vXFPhVf6vX ^_Ð~ fh  h	h hd Yvxvcfp    	prff9psTf6vfh  f6^ wY= Yv&G
 Lfh   f6pfh  `f6^ 
*t"f6v Xfh  `^^_Ðfh   vfh`  j f6^ 
     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hq
h@    RP~
<F> tjJj1j f6 <~jh	h(      RP}
6 hq
h@     RP}
     ء` +^  &&W    f&        ؎f&       ؎&  ;&  FF܌VF Z   R   \   f|
S h|h|j@t
> u_>@Z Rf|N  f    FޣFܣhh|h|jz> t>}uR   hMNu~ t\   Ft
F$p*\ Ð&  VFF܌Vf|D QChh|h|jy> t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	|&|Zhh|h|j/y> tjk\RPpv  fh  ! hq
h@{j3RPXF  @ +FHuF F^
&@VxR&*RhRj*OYF 9F}j }Ĉf<t<uh	h2 3XÐ  = t= u%F  F~}
Fau~|3Ð Ð>Z  u#jIpRPujJ`RPtu3ø VxR&RhRjXh܁tuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPnfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPKFVfFf  fPK;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRPKې~  fF    fFffFȸ	~4 fffFfFfFfFf-   f;Fvfv]JFVِf~qhXku2f+fFfFf~svBPƋVFVRP>Jِ^_   jF "hRj
VjRPUFF*;s6PjRPTF*PuVxR&
R뫐VxR&
RhRj
Uj|9RPMrj7u,jCRP1rjD
RP!r>J  thhd jRPYTÐ  [@7fh  hht"jMRPqjNRPqj{RPqfh  UujEF jWRPh	hH SF~  FF*;s>  u+ҊN*+= utԊF*PjRPoSj F*Pu>X X}jKRPh	h> >SjLRPh	hD (S>J  SÐt~ h	h2 RF 8VxR&
RhRj
SF~sF F FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&RPfRj F*PujRPh	hH hhd jRP)Rj[RPjZRPh	hN 	RÐ  4+fh UhhCt"jMURPiojNERPYoj{3RPGofh  ujEF  jRPh	hH qQF~  FF*;s>  u+ҊN*+= utԊF*PjRPQjF*Pu>X X}jKRPh	h> PjLnRPh	hD P>J  Ð9t~ F 8VxR&
RhRj
QF~sF F !FF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&RP"PjF*PujRPh	hH hhd j uRPOj[eRPjZ[RPh	hN OÐ  F >\ ut~ th	hV h	hb FPih	h FPeLFVu3vPfh  f6^ \L= s^&G
 tF  fv0KO>\ u~ t	h	hn h	hz FPhh	h FPKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfP9CȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPC  F .u3tF f6^ FPY1F~rh	h h	hV JFVtvPfh  f6^ 1L= s^&G
 tF  fvI~ uj#RPMh	hV j!RP{MF*  F vu3%.t(t~ th	hV FPfj"h	hb FPfj#RPFPfh	h FPIFVtvPfh  f6^ I= s^&G
 tF  fvH~ tj$ARPL0F~  F ohRj
MF  hRj mMFj$;F~VxR& R܊F*PjRPCLf6^ FP0FF~s#~ t~ uVwR&
RtFPFPj%{RPK~ u~ tjj[RPKF  F f6^ FP	/~uPh	h h	hV yHFVu3vPfh  f6^ I= s^&G
 tF  fvDGFÐUf6^ FP/Ð  F u3F F~s7F*PjRP
Kf6^ FP_=uh	h2 Jh	h h	hn GFVtvPfh   f6^ "I= s^&G
 tF  fvFVxR&
R
hRj
iKF hRj WKFj N*;~VxR& RՐVxR&
RhRj
K~ ujRPJh	hn j!}RPIF*  F u3t~ th	hn FP1cj"h	hz FPcj#$RPFPch	h FP^FFVtvPfh   f6^ YF= s^&G
 tF  fv-E~  j$RP)I:EF phRj
IF  hRj IFj$T;F~VxR& R܊F*PjORPHf6^ FP:FF~s#~ t~ uVwR&
Rt~ tFPFPj%RPaH~ u~ tjjRPAHF  F f6^ FP:u3À~uLh	h h	hn DFVtvPfh   f6^ RF= s^&G
 tF  fvCFÐUf6^ FP9ÐÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà*P Pfj   FPNQ*PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ*;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2J>J 	J  jÐJuj  ~ t	h8FNuÐ  FjfvFP^
F FPNQVRh	h ^S?c~uvvh	h fvbÃ~P|FlFFPvvh	h fvbÐ  FPNQVRh	h fvbvvvh	h FPPbFPNQVRh	h fvbvvvh	h FPbFPFPQ]ÐUvߋRPh]
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fv]F
^v&  FF9F|^v&  ^UVfvfvc\FN^v&8 t&@ ^fj <fh  vfh   !j-ރRPf6B p\*+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
& FF  @
&ğ &0݃FVRP[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6&Ĵ &@t2j>vjqj+jFvv^
6&Ĵ &@ F  F j9Fu
F F  ^
6&Ĵ &@tF vv}
&ğ v&0,܃FVRPtZFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^9FuFPFP%fjNj l
^& ڃRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>
 tF
^fvj_ڃFVRPX*+ȃQ *P%jj fvvvvv9ÐUj=fvh
dX
 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7@كRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w0؃RP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN*+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F*+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0ԃRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0D҃RPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j *P HPfj
'
6&Ĵ &psуRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0σRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;H}HF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FHPv~ 7
FHF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP="ÐFP>\ u!ÐU>\ uFP)ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh@FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh@vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh@htth@hِ = t= ut у>Z  t fj h4N3  FL1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 LShAhR*F*PʃuFL| j hAhR jʃ]FUtKjʃhq
hd j hjlfj hG=thAhREtÐhq
hhq
h~&Ð&ÐU~ u hq
hjhHhq
hjh7F  F~ ujFÐF Df>   F{ j h6Chfh  ˃uF  FuF~  ~1 F  Fff   ffffN*+;|;sF*@N*1 Sh6Ch`>  u)ff   ffffN*+ = utj F*Pʃq>X X<fj hF~4F 1 F ;Fff   ffffN*+; |; jSF*PShSf6^ كfh   F*Pfh`  j f6^ =ڃF*@N*1 j h6Ch[>  u+ff   ffffN*+ = uFj F*PɃ2~ fj hF#  fh  Ƀhq
hd fh  uɃt"hq
hhq
h[t"fj hEfj hn#=uhCht!h6Chtjfj hU~ u hq
hjh.hq
hjhF  F~ ujFÐF Df>   F{ j hPFhfh ȃuF  FquF~  ~m1 F  Fff   ffffN*+;|;sF*@N*1 ShPFhF>  u)ff   ffffN*+ = utjF*Pǃq>X X<fj hF~4F 1 F ;Fff   ffffN*+;t|;snjSF*PShSf6^ փfh   F*Pfh`  j f6^ '׃F*@N*1 j hPFhEjF*Pƃh~  5fj hF?  fh ƃhq
hd fh ƃt"hq
hhq
hwt"fj hEfj hn?=uh"Fh9t!hPFh(tfj hÃ>J  tj h tt t   1 ~ ujރFÐF Dj ԃud j h*Ih$tF F~s3c F*1 j h*Ih$FPuFA j h*Ih$he>\ utTtMtFj t:h"Fhefj hn=th*Ih$tÐ  <1 ~ uj݃FÐF DF F~s-F*1 <j h>JhBFPuF<A j h>JhBh/또>\ ut>t7j hj<fj h=th>JhBtÐ  Z1 ~ uj	݃FÐj҃uÐF DTd j h
Kh`tF F~s3Tj F*1 Zj h
Kh`FPuFZA j h
Kh`h/c>\ utTtMtFj1t:h"Fh%fj hn=th
Kh`tÐUfvh  zF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NzOÐU*FPPKz*PKÐU*FPPKF*PzPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBzÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졮FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FPHtFPhq
hՃ~ th	hHh	hTFP3h	h FPUFVu3vPfh0  FPLfv4FPhq
hո UXՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hԃh 
ufh  h j
u  fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  HPhhӃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
҃hx<BPhx>Bj
҃F  hxB$PhxBohxBPhxB`F~|hxA$PhxAhp  fhx AF  F~
}YhxA$PhxAj23҃hxAPhxAh҃fh  gFhу~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhfуm$PÐUj
LыFPh fh  	jmj$ыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
ЋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hYσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2΃fh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hs̓fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h 6̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth &Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF   
& FPгtFPhq
hȃ~ th	h`h	hlFP&h	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhq
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..bf^gef[UfS..bf^gef[UfS..bf^gfeff[UPfS..bf^Fgef[XUPfS..bf^Fgef[XUfPfS..bf^fFgfef[fX                           UfPS^tf3ffb  f.c.c "  u  $" u [fX 0!<s3P˿q
6 + r ׁsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666͜P.dظ WeP.dۚi  y>	uXP 
 Pq
 5! %Td!
)&6, 

3

sx

 

&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.#Q
u'"bt bbz 

b >	u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>$ t$ P]ø Y+r
;(rQ3 V3B 22Ut
 Pt ^Ï* <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &*U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV*
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v,טÊ  UWVFG
@tG
  D
u VށF:FVD*P{|]~ tZ@PNQ!FFV~\tBPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN6-FD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWRPFPvvRPFRPWF_]ÐU#
t]UVWvD
t^@uZuGD
F6u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
F63ۊ\uPuuGRt^tvu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށF6tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7DFȁF6؊FG
+EEEFEيF3EGǌ^_]ÐUVWv*Rt.^t	2vuVF6D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvF6t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vF6@t^*&GPy= ^]ÐUWV3F؋O
рuGuF6t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVF3~~ uD
tV@uF96&r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr<t)ǆr6FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.{twdydydyH{ wH{H{H{H{TywwH{H{tH{wH{H{wH{H{tRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] }(}>}r}}}}~UwVW3FFv&vF
t~ }F>, <Xw$ FF.|V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVF+FF96&r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33Bq
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96&s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁF6؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVRvv&RPFRPW Pvv;u)VxRR&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFV
TFPv
vVpx

& V3P,^_]ÐUV IFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3q
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	bt	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5![t#%!u
sʻ 

FV]U컱 .8tK
I	]PPR.d؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUq
ء
F
F]XSQRq
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ$%!3]UWVRQSP.dۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y(;s+3UVv&L^]UVWNwi	tH&6		VW_^s+_;uX6	&t	;u؅t؅^&t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]          q
              4.68  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update System BIOS with new version         /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                  MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM                $ ( , 0 ( ) zE  + , B  . / ^H  \ ] I a b I e f J h i K '  q
 `  q
  D10/17/2001  O                                                                           	 	 	 	 	0	p				J	|			4	R	n					,	N	n	~					 		2	F	n										.	6	X	n	v												$	4	F	X	l								D	d						(		b														
	*
	J
	^
	r
	
	
	
	
	
	
	,		B	^		.			n			:	X	r							,
	Z
	
	
	
	
		(	8	                                  E    F    B l bq
      C    D    B l q
      G    H    B l q
      K    L    B l q
      M    N    B l q
      Q    R l q
      P    O n q
      I    J    R l (q
      -     1    + o Fq
      V     S n dq
      *    1    ( o |q
      T    U     W   
X   
S m q
      Z    [    Y l q
      0     1    . o q
      _    ^ m  q
      c     1    a o q
      g     1    e o 6q
      j     1    h o Tq
      q    r    s    t     u     p l rq
               ^e                           _C_FILE_INFO=                                                         q
               
	
\ \                                  [q
  [q
                                                                                                                                                                                                                                                                                                                                                                                                                                             *q
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          @f@f@f@f@f@f@f               (((((                  H                                                                                                                                        "                                                     SdSdSd                  mq
q
q
q
q
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ABSOLUTEByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$U)CompuTrace V80.817' \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      w OPO WWUPX!	l;WO &f`a UVW~
3vNWXZ_^]
 !d~#^"!B @WWVX''K
u".H?t2`1_r <ar<zw$ߓ&G+tM!OoF	f%}UoV%FUrsk	rHY1 _#+mfo>c3ɊF0r	wk
`xnW^`~f	E	p	G_w<Wf  79nGKvEA\Gunc^|mRs,eު+74YD07v5|"Fk- t^- tt
_^tuJ~tu>D9/u6]yUu,}7
W t}v3^_sE+}Ff;fOs)GC*#D'^4
Fm	[/Pj>3PtlXȷ;NFPr	+snV
D/Cvs)/sam
MEPW*
^3vNrM[a j$
F¶{t
j 5M4ON<H{k{V,u<=t MF u7-]
q#ÅۺP(t~vI<k
';Φ֧h0Dj3T#httF|#8S
P,
vShD&hm?+et!NAQǶhnni+r	 s)!Ͻ
J|8@oduI |F# JٚFu
\Dll
vlyT8vnFiDLGgtV;{hR"L2fRf9nKt8av$'WF	hD;߄P`EdPK?]lt\\s=Fh
{CMv?(|etsRPز'sJd!!jhxDh&PY+|:43tf6s&GO@`)Vjn8x,wtt[V
lj$8^8#A\mUdF^LKrCusuu]ᆗ'"umDVOf2Zqv;/ ۹th.Jyͤ"	lwM 
>_lκP+' i;iL':,;v5=`k1 +G
jPx :	4VI|x-aEuF+Fv*"E-$1[/@sPm|Cjd`A먉Dl}l'VL5QTY5:hh>JrkE,|le!#cEB&\Dr0۠,D$\ 1S\^F:cӄ`R6?5u89o$t<(d?puBc[X|. {k]+$΋	Aw84WB.YGRԊwno|:hAX:BV37xT!I]BtR0<	D(PP(&FMn+"iW	(-zk58V[aBf)eZPPϾk~	9	^XR0#8D>W_fEK8}Il
) ͖ w uh&j moF r}DWkkpض U[f%޲Tltv
o"d[B)H/RPSo$W%,1@][.	 Vu=Gvamk	\XUbLL-N]$gfñf!R
`	 \ݚD2.%ǳhM;-ȉNl48w@M3QNQV[[q9(v*krۙl7V{Nw7~*
9s7W1-TO;v)
P0g0H6['FB'O,*9X[O
o wqw 	6ڀ$+ak|(lվ+07G2$^ oΆP)
yl{ur8R7g)R`6ݓ;µ9_~FgF	f5pa.+
_uE$0ݶ(4
 5dUhڦ
$c\JeV@br%H
D"T"6R;"\BM,zIo%f blUuAW<D, v>oyrbX}C&lo6P%^GlLАf:р{L7H^29BS9PujJ^'ݷ e\كh
56䆩4@3k}f'
bdn5+~u&Ǯ
F*.qٱ(/|(v,lafl4]F
-snm9Wt\Z)#D٢ ml{BHn,H`}F^-EV9A
oEm	
@'E^^>+-VO @\y;V
BGG=2NzI'\:a+Mɦ\D?'f
^u_\t F)b`"9Gted7ORu<"GH#FD^ô9ǜfHm#{$7#H;f`NWY9(U*PMMu"`,.Հ$E(Jw W/~rEBJIxjZ[/7[	lG7pU$<u@(O@t.%?/	WFN;up	8n[AEFT۞Pط`:Ā
J^k(d7gM$&	(
" 7;fJƅ6/,nkJHpoq=`ogn\t?<R/;u/}.GV$'U@!ƾF+|~+= 4r3K'] e v&ouyw|, Jxpir{@KFeI@x3};u;VCX@ddfjt-'	CC+wtT
3śa]ht3+Kz H8$tkN;9tkND7EG7-~Y-\o=c0Ku:R8*tAtD<\ݮu/e,*$V t
.6-7L;Í8V -TVٖZZX%Xa&IwO2-S3vѺn9;0"HP
.0ܝ2#wR
L,POd$ly %^o.O,̐1_|RO\߱ -Z[9 cu"߮5U#VV!q>U
GXy,[!bHBW~eJuVBX!`3m~-:=Wt@qG0-DRIG!H;޵%*vu'e+]O@FGupԗ/Q|$)iҪ8
CK:QX7{,fbl&<j0ڢfn{#MfU<	]ܭveetV;
;jGr%V${ĔD,G$/
>}W	G@
Bٲpr,
* w&j Ht 74vk=
826DO\upDH	@N#
YҋoL,
gCD(諏+,HDphk-%#ΞJ- #bbT#:9j2VE=MWC|b$-B@q ]۞xئtOw"Nds Nxq5"U2wƾlKAUoDA= w(.bM6 03L<9 ܴ齝5ennN+@1]t<=|@	LB
;
uaV?8=C:76?+1+$|$S}γ6. d+
{;~fc.
j.ް2>KCvGR76U+zpc@5섨	 ]]m1dRb
Yt9S:g
ɾIKiG6g0
R5l
 5VKf!o~O#<o@fP%ep%?0Nn ŁgWl8#IjoWUON~k
*q(>~Ҷm	4?5wE'uQK@B囙b4<ܤF6P(9	VtIV%ƠjhCڝЦa#VƄJ|!Bթc~۹GFR?(* A9*F Z囋EPR
jZIzNl~CuF~BQ	ke]Խ }F 
V
=K%Э"dN!uNI?Ff
Q("`Q,1o{̓T>({BNVz/8%RV0FFG;wD9`HD/5].JpxG4;ueHLQp?(:W&];t K)o	}Zu|]"g| u&>FtW{ѫD _LuM&8S"+Ҕ0c4ԊXЖ틃`ffw1Mf9G8r,v7' ,hRZA:	Ձ¹-}f'O@B;!xc떼پ$NQ\|a該>fNEv3Fy'^8!źī`tDD>&OGN=Qw-z1K(6$XF<>j0!$)K Z:A>$bQ#)yW"w'
9Uu>s65 rwS2rr$vz!Tx86;pL)xtd+PbJVY*GVУc?LK/aA*l.	tT)1{L R@r@И ,Rj6`~D;4G3
X`sd
 μfp40cR
;
feI-?m܇3(4n@@ %.=P@4%niaPWh A 5ͶAL2tHo{ 継OP;f#ǳt -itζ),lXwF&5z;vvK!+UFa;WKn
mjԓ=Wb6]S5PFVuiI`&v!G2k&GuF	%ٶk/ڎMQf\
jι@|$_Tun/HHl}w6E{q<x
WO'VgXNkHm9w!<y;cuf.P(Gݩ2ȁ0ݲpT7jxශB;tj
s)^fQ.ll%(2%j0VV][8l2Ȉ
`oVW-p0ɵ81sZY&_tV|i2[
Z,)sZ|j :Z\Z
oR u2Vc)6Υ Zޠo 9RuHuC2QP/Ԯ=)bӹ{UV7N8;q('ҿ;vVNQV,J
)*L( af3-M1!W,IĐ}'u!xw6>WG;0W;	DHiY$T1V✁s@? t"mo=jDG+=
t
Ejht]S7DNPn (p/L+baAk!ưfO<9TV9sD#܋ڃýێ+¿mk Th<3<R"	.fR,i yqW208zͯ!x'8sW	Yz٫a1d#ma4 B1WvfP"F(t3l4;5;%uuV۝RR1-Ŋ|걱45|P0 \9"@ò$x^;bϢrD
kP	ԉW8^E(VzSL|ηew v^	w|o亅ÒDrM"CP4)bԻVj1)`fhZV?n-9dK}wrr@wk(5(,gmsy}XGC#:<iR4,Hs0&E-K*KXXYrIWVrê	>2=$j\܇DwDpZԆ=Cʧ}N&'0L$3]&NG?5qRZxޞ5	bAuS.+<`_^Yu-.P)Nj%p{8W[!?W@)^r
AQtu0D#]|7 ei__+;ʾr;r6X\qoBs6.#ԵVDIz
S*(6 CXl BWs(x RV"$!577pwz.Tss+;(FfG^w+ƶ%!zM؛_V#i T8дU#^%}'YjkV-dc7
^~fA5Z60בm"L5@ Xtk@7GJw;cG
RֶPLNH@.H[zLJjDDt:
FR@B[Ǳ
r+,L/x\w%4B&j nG${L?,ry޶Td W"2YV(yWDF?9ZHTJlo<>Z+D3EA/P=9kD6fgIͮl@4HFCFD&Rz&,v%V]Ci=NU٪)G6t18N
]6	:p$}9&:Z?M..ʍ9!<GtĂ^s[ȡSW0l(WRVv[%'t)zYAQVϙ=6 Np5[PL *
*թHE4ޖ:
&|hS2ۃ4 ǣxHztl	{,I@rf*^Ww0V+] &kl@и5P!yܠXu
 V`np`,S
1DV/q8"b&6thQf! %F$Vz&p,+V)&PWU$zGL%/2uvW #"AD#)h?$!oa!V;U"26l	
	/]!vLcDrր,'=ca6,0]hP5J@ٸ#b	%l
`px=3з5R[2wp$bD
}xIazDg]k&;Tp,$\&KDVc/8׈8`!\ ri&@b-N_ck4 sFJ dܬ
D/ùf;FD7`nmUOxUJ 18leT.R
xtRu`;EiP
>q{R~	N٧	k4oE(Dz4t
,AIVhOr[
r&wvrN H;+pTH@jY͉CaACC:z	"=t(4(<r>2p22I_`|GGx:9|%ff5+t+Wl!rRLCOwMcBczrܾDvwbF*DTfЊct{H+6/xFgd0H$|\
	a/{?,jco`
(P	9
0y6Vl@AupiC
^X-NTsнT@
'&0~8 ؓ3l!+	&lbmVl
UۍD)QxLdQwp)wȸҥ2f|<Q?,MvY_!XT,+v^,.:?:SNp_btNf[ug5P0',x_TZ*`6e	o>OT+NBF;s>}v;s,)N-fP4CVi:"[%,dOF{)&8thY%`W"f#&p@Xu<R)ǌS8C&
%
N"05pl-=Hdd.6?AUTOCHK.EXE )rdisk( partivon
 mul	\MSDOS.SYSSystem32 $I30WinBootDir}cBOW.INI}%tK Menu/rogramsYk{}BAK^8-ެrpcnetp.exeo&&ړ&MZcTmPK@1I(ǻOǶ$ǷǴ/RichSPEL wC/ s$`]  l'e&+dW(P  d<.tt_na#`.daKݰ
.cu(D0`'mtsR`'rel7oc'%MV";B  i(G
*i4DiRbli=Z

4_2Dt7	R \??\C:/8R#5	:\] %%l, o\Regi-ry\XMachi&-ur+ntC[{olSEUervices ?Local Obj+ectNhKImagePeh TypEGo`rF {G : 9]Iathl@ d7$lVo+SVfEeE9EEdÀެ,V]YO=P. N3V"jhn7V#kPhCyPǕu	@ma C{{|+E5ۜ940Q3ud,m@f#(ZŷRt/܋@-)e  MH{k{ ;{
k2MI-A3"H
A@ۭ8ۃ}
t'on!)͹8w?m]_^[:|N葶F8ػo> t*3pG4`P+L4aR@fJbAFE1#8w*H_K##@|(dWj8)N)af;Y-YC̒WWfWI}ɗ}}b囅[9=	
VVx=
t}SNQ	W	PSPpWvM)p@f86r,	9>u9~u[dM>LS <Pj2> (GnR	GlX4;!%Q&yTY2Ij)OYY,34-+[uj0(g
j.?;+K NWCZ0+L9}V#9ۊ	0VLd v>}Cs(}f3^d	
%0((8$S[o8UF}Wo?  ''=o	O첰$qMeLav4Ӟ(n86:vWP
QJ`u6);S̠% mMR׬W/1BB"*xX X .+<dQfljhoJ|Mn>6Mc[=֨LqYB>
^`Ë"7 ᵝ9|]4 9DH|o N
eFilrwcscatRtlQuyEn
nme{Viab(}_U c9ns4CDelelRRd
F69lKKey |archr nInitUcoden
\ng%ٓs[/P?TmkkaskW.rupy\WSmOw-d_tdll. 
j9z>9,b9~<9?9"#9#0s v 6
#$-PoX]wwFT>d~ p  8'HL\%56=3T:|S<`r<&Gp'H@Y@*HfiziКvA4.@VMj~44MeBi.FTf~iiĚiC4&2DMT`v44Me Di0<R`inzD]w46MEM&84JZE7):ssE -0oLXgagIi.0U\-Lgth: %d
%ss
xsvMoIcoftwav\MsM
\W;ovwsVos\Apsp mi>pkFI~rnA۰ x\&o\.b}bQ^͝DfRm_j_ܝm{hF#tTX5/Ac{D]AvaXثkHaÃ+0*?[Add.qLH5=cln;AKOpMozioa/4.0 (cow͈; MpSIE 6;)a/OSTǀ7OwSREA#./''K((..0//</^K.b˙!!""+&/&./HLKJ@Nz9H~`n _*K$h@6}c`eZ/AHwoD)f[G@
=Ke7zAvjaH#ljlT6HujWqRֽLPbտn3 n͔ Y̠(uS_䷻+xZ;cF9'ouva+ȹQ:snpnxlmF7O9]ev uVQLжύQPL+Tg0RP(uk֙xOtj
,n	_N"(w0w۹vn/KYhׁ	`\MQ5R/:-9{,"h0[9О8 xYѫgeYEⶑVSiW9.$WVx<hb	I~8KlC`a7QQWjl8LhJPlM#(جAw@?tmWhPg:
D N2 hdD.A@@=mL|toj[S^  #'t< xNVP'hXlHp7~gl3,'j4-XQh=<t
$u$|$Sw
hP&d&no^ް
` ,0>V}WS53չH+}na}Ы]9\t0C .S
,NM+ⓞek=]\]@	`,:_kcM4V~xza%gܖB%m7\ \%Giv	aQUV
3E}6i)yHDQ{E	$*vb-(	.;ƣ1
0ň8/$ yVzE=x&dh5_2o~%@#5_8k[uuÿ35<Q~t^l4h
u	*c`Uy_n[^]Yi('3G}ĉ'l\btB4;:jD_Ey64af:}6w!,׳z9*
|2lx )4	A'z H˸c *dhd d:{c^oCle7S0olt,>%d20dvtz@V0ayoV<Fwp4$fu:0t?ldHX=7H@y"954Ou\P88,76;~6M*0:9/P?McƁXwk6^u

8zoWtt	j(hXi@6̈5AA֣"]h_&R|	Ԫ|rW0`VUZ/	Dnl|mtċcF<<@hPdP8oYY'1vD\P^ea0j,YV:bA
+EXp'\syA
lh 6NEi`m7SU\}9P=tbUy
VMowk-#;t`B@V=X(V>4c.} W@(aF;tmDu9xNƛ=)(;Ò]'$MgZtbۂS )wPSzSͷl*YJj֐^'֓Soސ9\6טJx\l][uo=,6>|Bt(؞o":7u]¸3l]"J|W}]P}+4o,
[o3ר@m\t;u"PRCVPtT\)*,ZEbn_d g t JIRmzl1W$LLbf<dlma =@s>
*@w<8 F洁tB.[w9u9'ހW?xhƭ!fT[&tku*peFlƶU]H%3E%Bm#pv[d&/FxPQfuQG-\Mm##7`@&fuhI:**PZ_<DNHH[Eޙ¯l-oE-uqb
W
r07dujdp3=4x4Vٖ45$ TAmivpiǂ4d/*((68N`vP2TS z;jjZܸPt:kP@SKLtujHa1tEL;/X;l8`.R8ĨK '<v(!
P	ɈH'VuG9G_su%A*?AAVބprU,E;E#P@@Cوpklh"rP<	pAC=;E7K'K¸ݡ'+m `~$	̀8g609	EF$\(0L,$8/Ho9u-e8T0ֈ]*mp lQlؚgXE;o޲[*~Zm5HV CSV}z~TVk\D nO9^ht3ۣި܆X$x苙&ۜ	89Cu^G4( ہvS$ǃcF %pk/MrV$RhR^\pT,cDW%p2`i&5l{ f't
Aη̤ى=2D + 	%G
7Aôm4.k|@Fo24Wv4M&޾t&c(r<?G|Fc7#^4JxZU
S#?vnQV􈑾F@YWh`$Ke|v
ahh[h}(=i;T$hH 2A>c<I88su 0IbXZh~bdђ`w9c`?pt<Ťf	.cª@@pY|hfp&da
q=d(|h0W5
fPm);Yru`P9̺1X5d\[۠!0xE(J3-u	췉t`ATqõ2pޟ3ĪDF@	K^B?xYN]iW(0s	XW	!Vw<bWzHMP94~sF,s9(Jh=L0C@3ҋ~JHN0N<v8Dr[Qw_H^DHޢf,0 HP	K
V̎xA~y
; 6)sLў+ .|$Kw+WVn4:Coq
^F2\Ɓ	б%f:$aw[Jwjp(qIVA<V׀ ۿ<"%Vj3jBDX\(W/`xG@@Ft
]NH>1
|*w~ 37+j ڳ0_A"@[G[s0:2|t
S^BY;os6|DD#G	&N;6)!Vo"CNb_!q1 L-]Q	PAҥu	܉#ɋT%+ 4Z[c
0mۉ1DuJo>DNd`!@\pp_9VD6[x0@KNHj	n0Ve};wu_  \jH$wX]zqaf{{<t{4Plf(KVtkg6Q;-3:aP=]ujXf{aq^l>D什8@X.UM߲mvk(H+ͬh;u	cZmjp!q־<QYm(;Wҝs<HKt A0^tilNpNYlS^XPw.+>ZP,b[WW#^tjFl
۽<x:0 C3s	6Q.xQBAuSFp?xWE5g&
@8]-tXN!LpAE,|c~焢p tQ'R9RQR4I@I

]ˈy> Z-v'MnpSwX}|P@ j-{K
Wt51Mtf6x#(
M7 0|[pVp^Yrp'>Fh}Zhcg;b;N	gD^8K[;Ծx720s<U{$Aǧ{XJpeuPف7n:rƴSِLTo[Èj-8@׮rwN`D6$j13(yr{(D^xbdИ;|A
X9${{hJ2Aoh.rekA@1?A
,װu4-;&OcV l
a	&'f4KW <
t<
)<<XwD
x9=1&B4V^hj8CYh::̀Ō )N)!cu4ՀJDy>,
	ɂ$n*޾ ڋn'<@j~@_>Q9%tYfϵhG'M:N7w"-'1],0{.|5 Ptc845SIf:x.ǽ\8֠FA6BWl0^m}(HC坷tSo<<ȋ+Ѓ9KUB*K*߁Ї"MJgLRa)ޝ&-%؀	`"OS#6q+A5Ȱ{(zV;KPBg<HJ[6%UW$!U}v@=tVP@GJIӃ'D>Ӌ\Ul][cZh|Dn$Vt
ՠduP0>.j=$x [
A!G 5Wu]چcB7@KYbW7fR؊3э
@CQ9 3pYd4XF@ ;| +7'oϤha4ȡ	sX$L(ՋCR(2p4T.&YRj uS`1zt5}ITm,vCM>wr
C~^N :tuKKF7Ei`?$p-2D)GV!K+=	M
 )W.kVOUj4h_>lȨKDPEJT+ԬeI[в^>uݭvBOk f?DJo
@jmAPh|(UR݀~%@z;9<>T7s9JPhuOGo}+ L6
!#pуw$Q:jpRQG>kSK9
HK<-V
u7"O 3
[{
f$ݮș;˓uG:	F:;x96M :Y`
<΃/D9XNkaZ
+QHP
Q܄	KfuV@@A)=Bt(JRt
0]0f~ιpf:,
ۿhfV2sf!uh:o
^j~qmJd;u;}q?tbr;_/k	h;5\Wv@	xsj}g[  G9n|Ѱ~<956nGپeDV<CdlE|FH	
ӍY\7x4}tIuB;27фt /*e2IUtB;}
5ZW|{~3 ]-5zK]2f+x%À
w8~w
}}-}rhTwwbYH])	D4[
mS}_4	L8}t%Gᜰ8*t<.];ڞ;2^\0!T	 , ~mm PrGې\1VO;bP}O;|Ԋ.x?dtSO<*6vUWtFܱtٹn+|N,}pÑԬF]S~BKD~I@UO̸>eAXYD8^?nE\6z@*UTb
ExZCtrlQr?ڀD+]ch	̈TokV1e/n;tu_1 `)AsUs>;+;76$upl>0m-)Enum|l
Z

uPi⿀ADPI32{wGs}Modu܇۶iuZA!ZodImohd;SviaK"dO'd`c*MRrsMvT	sVg$
Y{)3O7mapdlBiL a%;IPye[yuJr y EК-vlc֛Q؇a5
pkGL7)0Ii'I$AǄ*S'/M+kA Gj} lr8i FrLibraflCz Ȁ>w!tP-ʲe!c`lHo$]kAcl}$B)p-w0S:R1amF'M4pFbJu:-PVB<DOatט%oreft**zI^#==]ZW	6uO,9m	SƈBTkzh=k)c NEIKKERNEL{>PBz
M8V!@e/BKFTiwTrqslB0 	:.6aOl+i$=7P wpkfA|E*+uQfݝPeek/ /US1kMOCK%l E¹EyEiEE!d[ #r(!@^Rb	,647|ih`ȯŇ1:&:7@
*d`u;Q
] FhGdĢݛ̛؝
iH9 @`M-K3+(8`#  ^  Jw|113333333334334444$4(4 84D4H4P4T4\4`4s44L55566?7x7}777777778$8X8m8v888888;9C9999999::::0:?:Y:a:g:m:y:::::::::::5;;;;<B<i<<<<<<<=-=3=E=L=^=z======%>4>G>O>T>`>k>z>>>>>>>>???%?0?8?E?M?p?i??? fD0"0+0<0T00000011l1{11122)2:2B2I2O2`2k2r2x22222223333%3+313>3dS3k33333/@333334\44!4'4,4E4d4mcy44444444444ӎ5[5e5/}555555555666%6I6V6y666666$7,737]7777778)888899999 :::::::(;4;g;;<<<.=C=O=V=d==>'>S>[>{>>>>>???F'00n0006111
//282AZ2w222)22333+'O3bi)s33o8&4Fw=5u556=O6T6nw666!7h7p7u7{7777777%888]99;:Q:Ui]kex:imq:;A'00 408@0D0H0L0PX000k -P111142@2H2U2^2?3H4^4445555 6&6;6xS666677 7'7؂XDH(0P Q    $ : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                       p   `      POST  f   f.V .X <  
 f.d ` j  I     '       V    POST6  ^- J ګ ]  K ޕ	 x
 , @ Z,
 Y  +   ^ y,   @6 6 v6 6 ͨ Ж ] ו x { y  ! " /# $ 2/% & A' R( ) l*	+ , - =. ;/ ^0 41 2 3 n4 95 6 7 `8 Gy9 Y/: ; Z/< = /> ? 3@ [/A G^B N^C x/D OE ѕF yG ЬH I +J ]K L ,M {N 07_ ,P Q pR .S T /U TV W ʕX -Y@Z [ 
y\ ]] I^ $K_ Ԁ` a ]b f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ hc [X <t
PW f&E1_X  fPfSfQfRfGenu fnteluxfineIuofPP%=  rYfa2f   uI؀Uhlt/f00tf  
 p0fZfYf[f
#PRWfQ
u5p 
(t' =>f0@
u߿ h=8ufY_ZXSQW< s13
 h^3_Y[ABCDEx} U"RVWfFf^fNfVЎ.< t ~.FuN._^Q	

@
		! &
%3
> h3h}p50 0t  Ãu
.+u	u/RP~VFI` u tk@.tމ^~u t/ tO^6
5
u^XfQW~
, ' _fP	$S8#:r#Lt<
tw
u!ο 	/?_^p	9+^5WfV*0#)6S
F f[tҋ3ff^ff[f`K.߀fa92 :D0CfVWUC t  f͹7h2%3 tkfAh6 P=y'Q2N7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^@Nf`Sfff@= h*3>+f;r[5@ Wp
2h_
 WX
_: r
gN1
gBr g@99 \AVWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_QU/tg^H2N@?"u h fΑRx   _둡4]hQRWV^NV v<q6Q3qI4GYGʫξI^_Z!3Q'M0 ݀pC8 YfWV3ff"1*bIfPS. .+Fߜ+  f+o^E
N~u!h^*h. 
 OGuQVsuR?
 O2ۊ~f x޲k:P`?tWuf  f.+<ftf!f.@# ?
uF8Fuwf_ts^ÑGVR.>+s$0q	.k6+.+z

ZxFHwPn2
F0+FPPv2P1N~ t4vf2f:10~`FNNI.Ϟ+ƔUfVTQhrLS 虿 rD#g0h!# @ N   gf  P?^ 05f@F]|QZ6  
fvh ~uF F 73h}3pZ_YH	h^y r rD(gf 
  #fRS ҜP&tߺZfvԹ tNhCHtDs ʆ hdn/ 3hkBFv ~&#?3
Pf~fnXf   @
>tq  tgfNg A	~t=-F  ΁ 3
[a܀3yuBF t~y2hߓFf3ҲZh]"FFf;_Fu-043  
 CQ|u@(.;+s0~  ;u
t`_t@Ѵ d^rf(  _^ZY WQ3.>+2 .ǅ.ƅ ` P@hZR.+ `$S 3.w+h?? ЛZN [pwFk@"~ 
N~f.=6@.2̠J0[tu4.Bf<tرfK5$< F.v 
1q_V@~rF F~`! Lru~Ow
`?M~f1ѹQ/ t
fNu
ffs NF;^P@45P*Q
Vq4F$<u&/F #~ ~P$w_p` .ph {<u{8^`V@g+@..+g+^éV0&0
9t@-2xk@2
E/1^s[ 65^35}#uB.X:Nкu{P:
t3S9)ˁu=8N0w_^W~SVR`rfnA*v[n!ffARffTЀ`2fywf;w
2#ofPRf@qPt#f3!fD`2XfffNL$ss4
tu+q%
u	˭A^aJfـ}f^Z6Waf V^~Kr"8uffFՋN_QcV@vb!Fm;pI3ϋ~+c:sRVRfQ_;Fxu p? kv@kF:`b:$w$@K@3frD ` w;=< u  r,.;D$<u r sh@Bv?FfYZ4VWӢ Юfnq~Ud
t"tt @Dv}P }Pk9SV03; t	 r^[p@k𿋼`ӯ#Aq[%S~x^Y~@j*pt@;v7h!tk~@st 1;FtFk^% Bk^a 3҃  V3k`[
C*䊁;oFuR*3]0t7t-k		# a
@S
+FHu
4uGrvFvVBs0;؀~HVW΂tS03ދ[^NuVp 3ҋ0_&6>1-4¼Dr<blFkHȀ=BHP뷋_A+7oZ &0V/  ~u1|\0PN~ tK{v0YFQI.Qz$ x
f~pO3g ?FfN@P@ ω
0K SQh+	 \P,Q23If.` tf.&!. .8+?tьL$QVW
fvFp"`F^^F  FψF
}fgFF V膵eb"˄^`LȬ`!uɱ ``NҰ tFt'f<`e 9Fv@f0
FfH {yQr-րi`babfC<W4RVFъF8F^  pQ0" R$ S&jT(T,UntN!!fsШtEH rtsCA9FvG 3r%if.+NͿs  `N0ƺ3 
t
F%  .p槿 c>fgF~ tf'iz e=u
 v@aQI8t%  nvu Yw  vfIft'fAff#a fp~=rSn6.6 G                                                                                                                                                                                                                                                           %y <	4@ @iQPQRa&hlc $`Ȱ hj@rZYXSQWa$a$a  h> h} >5_Y[2揺 TCwA6  @A Q C@@ @;uYð!桟$p ߴh)Ē
f`   h}!f4gf&`   fa.0h
 
=h^sfPfW@&'_fX`ck
1)0h	8/tV%b1h{O   &  p=h#s7h S2@  P&}uu hdn2"3d 
  % ;_W5W-e'$@#h<Cff
qÀtf%afhC&st h.+,Ⱥ: @p 3ȰS- @uSh3/h "` ܹ 
hi"R1` úvø ffPSf1DIV .P1
2l[@舮u^  G й ~E`3%%aP hR: W" h˳( t
x 4aPQ) @ PQ= `t
3f3p	@fYX _>ðdW`5d  UP@kuCu '!eF  %ؿ
Et&0B uM9NwN#uӃ~ t"F= wt%   +G`DXhg.0   !	  < a `hi["O0!t*!u eL>uQ@tPRfZXF+~f./~ AEf` f   `;I X1SfQfRfK  fA]%=uf?a2 ffZfYf[HSQRfWuf_ZPE+af+ + f  g&Q @ fq$<s
hE}a  (8PA	<]@$f@g#O׃YGjE sFfVwf>@
 F T'hZ ;s(Ǻ$ fޭ f^fWߧ0$
 $
ذvD+$ w'`$L )f_Ch}s`L+f1gmhԺCmf`bNr)` ks0 h=xf~r褓s Ve
WQpfa't5<t1tfo @w9(@ BÆ B<  C< $ # Q R STW U VUWX Y{Z2VW3,C@D@
` #j~pifA&[ wуtR֖@oRhh_^l))     >  A  T mh M e M A@ }9 Y .   nSA ǀʀKd (
҆? @h+h{!@i R2 P f{<6!~0l66f65H  3 |pR 65>xX.wh8ӢPS $<t4r [! Ѝ\؋h73  o f`4 S  y	6hC%h7r   D 3y "r< ttFsG12"rw 1n B1V0rX0G1 r%@i1b0&5&D&EN0`Aa
p_h7Y2ē ߿1p_uЀ1V~^ 
8
3
~3
1^n
O1l 1Fu&@ U$=u&1f= =u 8&2&	2&2Y
, fgh  0 pqr  <ABCDE xyz{|}   )`YV S#
fḠf1|19 r&]2&_2#9 r
&   09kx" 2fX[Cf  f5fx&PV3
Ê^0(.'t%.FuN.PWs!1 _XUSW! Q,fv߿ hS  ޿R&~22ك!IN܀3d	^
u
t_NA&>V0_[]f^_ PV&=;u&&4u&^P
P<q +&~& 1E&Dp#SV h@^[þ ;`[WЛ ϻ <_\ F10=ROM Based Setup  Entering`; `. u  c; LLp|t.w`; < Sup)!`- W  ;p KA	A`{; 1a;q]vrKp &`;tFò  Et
.>	t.^P(*!t hPXh8sF12=Networkrvice BootWake On LANAttemptto %  Šht8 0< r	 |A<u 7<1J	t et;sR QP.<$<0+( <MTB5B"<! ds@C	%24ؾP<^so ?D%n_ VRynQkNF P3؁P?	uCFG~N0tG;phL/ras<vrhT`Z^`òP*Notebook hard drive MultiBay"Dock!:b<#b (top)bottom)leftf	Floppk  USBCD-!F HDis/SuperNIC*
!123                         @mP Р 	 
A*P H 
f @u0-r  pqolectZDeb]  ͹U8 and _mo@=the _highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   BB(B$P C'3C;S A;Zip.F`u h
 d0ô0.3CӌtӎXC? A B[P3P؊' tA<v<st1xB& 2آ؍>2@Q#YAr	 ? P A.tB
*}vB @vB+jjj(PjߚZ  5C ~`tB8B z  :  ICa R 2
   t03xB2 lF8tFmP $ Zbqqp URVQo.,.L.T^Y_^Z]S,.vB*[ݡQSVW/ s&QSC.<.-00?00.Y_^[YQr8B u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu;w`2҂ Xʱ@
tB8B8Br
;w2ptBJơ}gFYô.*vB<ͽu2K0ߧh^>ɽ hs_h}7d hb<u`B J qW5 QWh=C	fgf&2_Yf= TKStc.>G G, @ f_  G0f G,u
hEG,f",f_fbo    ? o H  Rqph}!5`-0
g&Fg&Fg&F"t7g&F0a 1 2GG׎Ǎ~ؠ9{ rsG	 k  QRVDTQF r&e^ZYGffL߹ (]́L рYPVUfQWo
@x
K&n@
C' C$C$ Frx  q#౑#_ r]" tsrg r70K:k;WQT rQ {GC""Y_r
E@t]^f[XQ &C"u
 `"!gu!#,*ABM  f.IûPS [XAu.6If.IIDNU.ISfV#3Q#^35%Ýf@)3u
u \rkt!q!} "нW3 hQr_ _ ++Ghv3%5icf_\`= vG OAG aP hl2$@<@XfPPfXqIPR ZX@ `.>K t.n`K@`KSQRWh@r_ZP;P TC r99 r/ u @ t@XR1$tutZ 2 VV$? f3hcWFSWQR YuʀZPpq4B XZY_T*eu} TZѿ< @3ɹ2 uhXDo#1U)¼ P% = @uX%*4g&@MaXISfWi	t<f_!Qfpxf  g&?t9g YR%fk@ @a  f%?f±^#   f@%ofQ
<tf  f< !pf g!aZY@,$fVL/
/]GP@t


 
"
f^ff? wD uPfe%P}
X!
r{f[8H2q 3r 4 5R0@p <4	  P` E    )LP@`@"ɒ  	P  	|iwp   ̭( Actf &3&3@ p 
p 3f*$'BR"ust$ uf*U]Y[că>3 tuc ~rh^
&ߣ3p@C<th7Ys}#?3  G01m?}44 Q < t&=3G]f'&ft
v3f30 2ɴ*f&3 uf
ffK3&3&3fC03]TЁȂ؀3p35RfVWfC3ffCf[fKfS܃fF0r0а K I+r%2_;Zf5SQVWϾ u3n_^Ф ţ	!BKsV 
R3
t<^f~
w/v }R0f kd`dfft@`[^ɳ~VQWfv h G-F&|4F&~p & &P&&0&ޠ&&&4`^| Uf   rGt >`*:u
P0xh{gbX`a_؀ad7f]PRaQ  hdngjjj%jG PR	PYu0s
v߸  h㎻5ú   hcp
Е.s 펵( t 	2se fOU ffff>KUfh	 Tg&;  [ua)f)f@gO&t` b   ttx3srnfǂB 0Ex	~/u ~/t sa	~;XUtMؤ6?                                                              㱲TfU.FUJUWu u[rWJrR-rMJUtf0wfqP| @Wb t#r"t p ; }PJR  ZR ?f]LCqfUr*6@^  R Z0rG	0Kuo!!Vg&fFfFf^0e rC\A `3ۿYyg&8E tEG SBWiWm r`W>OUptCҍm8lql0ha0ҥcְW rt r
 GC_R밞Zt$oؤbM$]0WP  _W}  sp  a #`P
߰@S P  	ð D v S8 3 e WR	$#
gR'
//QWjuptPX_Yù
 d h#sxu迬sz
ՏP .<u.u qRR바aR22hX< uZ#ȴ$? t	xJ  U[
	a!"9Vff@ƐN`Q#^hàh=aӫh/$4/h yKh	ru_va { r PQW 0> 3_YXY"Ih^dC=>G h>U$h7Ss	w? $[Eð   ! $!f` ThlC@u'~ tf h>* hⷩ tff%f}
 ffavP_F X|x]`ؾL &>P&DE>P&D >Pu dә יj@ tP}
 -Ȁ}	 >P 33SP[tS[a@Q 2[sDy3 t^h@hYs
JhQaàhRΈD
ϰ<DuL
p
E$<u D
@13Usd
rSi&pS]@` uL
 6 6P u  u(X6 &uh
	\

u>@   ^D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	& ϴ t"& xu	߈\	PS   ? 6P'>P_3& ?! 0oP	_[XB
t+# P xt  t  w\DPV!$!"桾tKh10Q&,@ &  ~` hSC!r!L	vTt
v߲`WU$@t! $<v@a@n3  v
p
u$< t"<u P>ȷX\PRt P:p1thE\!&ߊă쾁=0ZXx` 22PEǿP&PCt5P=PtOu570: u	At!s96 u5 ~.]s߃
t!\&S@q s  `a
׿/_Ƿ3 rBs{&=  V P;Qu 0<R^  3f4GP,Rf_ [ }0 U!    R&egWʃO&Mu{O OqfGtM!t$}Ot, t"OGr ǾJM0oOg&0R/` ۰2%
<t29o21_kP*P*`OHĿtS@LDhE =_7_D D	 d
z=X1;b^tSqrG&}	r??23p4t`hea&ET$a	&M&]aI`.'`\%o# rU VՠRǠZW&= uAF <K)
h 
 m_VP
@t   U!w#w !#`0_|ov7h3 Sg.-.kMTN>tI! //(rJ]g.58v@Nu% @BTB 0hsh}aW$
"1D h=
h}^CYp@[X_Ë
`PS@E![X SϲH<vLR
 Z,<u(RffW=fĢfн,ZJ vGu

} kS1 6у[Qb$ <@saaf3Ґfi!<`c8i |	4`{ph v73۹ F
t):u%r9eD	& hgSP & 	 h#P3Ga!3 
3 ?  Pk SٺuTu " / [J rGQx> r;fQ  x.<wt*tS&' t&wA+  ̧'{
{'W+Q~@s& 0RV}Z`}tpk hг YQo@@?{~P`[r4fHq(u% = tRe0Y *pQ@_HS3P+6 
{HHȋE&AE 1, ^@r \ \h+ӽyxf1  ,VA @P$P<PtReZDA۰AuO  ZGpZ^a/\WV 0  PhX@? 13r2)
yC@)2ƀưӀ?!C@u?r@Dt㳰5. ؊u,u1 
@a

+&C323&@t  %
t&
0  5  "   ( 
u&: 7/b!	"	? A%w {^rPRWAC&A &]&U 
t ˀAi] _ZXr#3 -wv2C.u#/5$N#h΃&_ '߸^  Y       ր>u  '3W~ c[ 0_DomYf#`Zf3fcu 3? Q>MP`[#:wuBE&8Uu8p]
R +B&U
ZK!ؾDoZ6fYB)%qr hk ;/1	Q(t0=
  5Ãh7dP8.
<to0Z`ێûߋPV#
@F^fǠ  XMFD/
yC I   Hsu,uUf``؎ Fwq.p ڎfafSfQf.{qf fff#fYf[2VftGf   nqIg@f;t&fW lm	F $f^`2ۈfaf`3oopfaPP3_X.>pq+ . P	TACO Fr S 
!	& .lq搝N"s<F	nq fFf.{q  sqF.qf.>{q;E.q@  tqqttYprqtNp  D@SIVfB.f$;VrT%1W B!Z\ܐ	i %Qf2$fP'fffgf"'r. p lq%f@c .f³fHpsfXfdf3ۃ!u|+`s?I
s*"/S"Vf+f;wfff33RREwqo4^q4'r44$.71p6ɐp08333Ҹ  QW>P% _F
3}5u'JE#a0 t{ 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^I uwQ`  &t Y&  
 < tr&\]p &_\U  
&N!d P
SR[u 	F@& $F^[_b?F FY2p߀TV'?}PVWًо' }Q! _^Y[XWfQSg Zfat
  [fY_` t =$PpnPu2MtaoË6!s } tp( ` j &&E`?SRUQj@6^]Z V` jwČD^XP
~*F
  tI# b Q`lF @Fxq d3duhXKu`<Uuùd `hc4ﰭd & Xtû   hͻ% h. PhE^'`X!$!   °rs} O
ehCK   tt 4  hNc` tKu& &  
 ` h,s@<t<uuТ 
þ0u?1*`P	hݕ Xh $ P &D[%ys%aPXw$# ) )t`($} f.`G  cn3 eDon@7W À   ; Z x     0N@`^~#bh\1fF3.{% _r 
\0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kó{.~r@V_ 㐂û< fu ff @ffRfP7f!N
 ffFf3fvZfFsfBf〶fЩ1 r9pf3ɰpǿʧnfAP  fafPVa3v޸rF3X

S,0<	v	,$}.[W D`

Lb f zs  f 
T
T p s 	 
Sf_fp ЎfvPU YP, P蝻:Fp
uf^fNfV_f^pPRp*fuVA>6JF@20h}C@ Ϣ
 ff  fffffXChq p  `90 {P9 " 6 a*P*hdncP, %ofPRh\/K2R ĺZP  (Q * 4ff:aD0  f2MMShy   h=rRɀh^h䎢SZ?;?PSS~@밋pq$ q!˰_Āu!A tðvntt<1w(<vvP޲EhT3_ P&
0
3q 33ҊtW/g.&;u;ϴ@.Uont)@)whPmt{؀}a`2G@t03@ @u  a_[
u93Q2/,;8#fN 

P-j1rX?03Qr |X@Y4SQ
o2۠c'$a&& &0hoC hˍuɰ h
t[ Ȱ t
sŀv#tW̰,5-PXv8v&> 㟸`t`_P3 u $h<J4
#RV· ps} uu22h8Sgu]UuXP&
wL 2߶ Q޻ hNu= Dt= tYԀ'
Y3Y.^Zޑe[1hP #@]U  Pf^ ]  _`rr	 t(afOLPH      @6P0;V(e
u^V- ^"(P*^  2oMqSP( 22 pX[Bw  $@7R  Z`7              zKtP( % $ 0rxfL+  ك%rSr$rF!f+Df+\ r*Kr3w r@ .hkfa2 PR30 Z@AR `&?Fd??uhP&Xh$ r.>.pu 	AїQR.h f3f%  fXURQSWF^
D= F\ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF t «若~u{빠% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
50:_[YZ]`P 2&X&}0`PQ0^ kPY@vUkPk~PR]]]/?              D?`ރ6.u;v` Ql0 >h *Y`"QwLQ`f&YCC7`K (   P3YaPSRP3@mn?[`H@4$&%<?GPV 	 oپ <BMtf3EP2W X`? VFr
JRU3 fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	tŀ   
{ f@3t# %t5ubfDqa $<@tS<tO`NBH$_u>f=Pۊf@+rCtq Bt#Bt	ݱ?]P0f
af_f6` YL 6+hȽ tu6+f.ff`haryfA^ r \W3tt_ w`l`D trr	_Ѐ{RW hP1t Z
xx ؎` P.BB <t BB2J &ݾh   8u!@屐`23Ұ
ShLYSt0`́ y aut0i at]U U[aSR  4ho
 h.^cpZ[`-0Pٻ  h?=	 h"
 "B𖀺PaԀa$8uXRP<u;Z~QrtwvYu0ѹ }R0wZhEU2<U  h`2 u
3oҸ EmF)v upQstT % 9 
߹( Pf. UfQfRfUfVf@Hh}!: rsNrL3f. ff_<f^fq=Yf.>fMgffgf =WuYKU qq u, P3	fgf CpkIfAgalf.#?f9uppfY't0    /up ;:hՠ ΄t; `Q h, 6 h߳" {e  QV3@t z4;F] ;
V3"/fUi &g3  f% '"? #WFfF^fa1eV ߳p @Z  
^drq[3[<   p DTDw R `o 0 ȳh  n1   l ( ^Pb @0 W HL P`A T W Xb, `
`! p@pؾ`x o A0
|\D`QWhI3 3_p 0 PQ= `tq1 @0YX 05SPp
& p  ff& X[@a@"&    i?r  v1~~@Q  [JeO fQ9QEh} 2 .В/ ؖ T <t Вk~줃 tq.ri."D.|u.:DtSI ^ wD:r5+s&v;
uAl
?c1PQRfW}.3^S
fXÑ2a`2	  "	f 2f@0f@R %  3f3OfPaX Ah lUv  fb #&f fa dD 	hW"ϻ (;sQSf  r`
 t
2>fƃ	40q!a
 Q[ff{Y+vf[Wf+_f t%ȡH+f@`h0Qpg-m f@kf`0z q_L2_&Uȃ uZ=PrUf%~к uCf*f=`  t0  t( f{{f
1"0"}fph/%/$_!"
 \\-f g&%޻f2@t
 <t+p g1~f&f о  , Xuup Lr}fLBt<rfa&'?rGf԰QÉ_F?<qP
 Ц 
"a	Ub	~p@2~BuE1ɲcAމF &Ff{ t@sf @{f;~t	uɁ~qNїV&.L##`WfVfPXfXcr<wf.כ0ճа_Ѱcf&tog&TfVR3og&Pf0 `&fnu=жtsaNu(g&fVffA>"Ȁ.f+E)^f^uS2u  w & PP0Xt'vt
t@0r % r/o h>u hrst-3&>rwqrRPzsRܑuthX$uul	r` 	߹ +Zjjw b6uPS`` FF ph rou
@ Ѕfv ﺁ ؀>t !$!f$< uRC  
N<2<ăƁ	"3uA'y@h[u TYP=t 
u2Ɋ،в3`t<u
E< tE$<u&w $tRVL  N L Nڰu û` t  P[2u
@j jY!(!!2(<!1ʰe$ h5u$0례t$~!.#K,.t4&^ t<r&Pw 3.\  5!.\e@.dw b    W	x .|h>_DuQ&~% t P辩Xӹ
 .:t
 ._
vXP%8Xr6%ȸf}c4;La    PJNL p      QKOMp @Kt  Jt P(.DGH h2h  hvQ h҅ h~E Б?E^  ` f  Cp m& OE 
v? %&Mÿt&:
&;sr"`p$t1TKub 
HM` `(q p" s*r#	cp&3a C 	H ]r5r`2gpjh!˰vZaVRQSho4Thˍ4J"Ҋ.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Ph̕X<?tFh7YUujjjj PZ &h޴X[ hUcY$vawt = ;t= Dt
hEsp[]@WVS$`$
w[? @n< u"*׿OطhNt`-->J=Ot_1 0_ tyr rh  >S^1  0 hL PͲ5[ ?  :Nz2?Aq%  	
   >VFPgbǋVW 2_2zt"@uG2 
u
2 ߥ
 o2E2&&&EA &e?
td&E&&E E &E<r&}	r@ VW^2۠^2*
&}vPuh7dVRPRQ3{f 
%*t,AYZXRPSQY[XZh?tuS	pp Є> qQ 5rXYjW,: t4I
)֮hIRL&&  t8ot' u ag+& nHq00r6$^$ Z& && ;`Z@ `dYde`P`  XU @>
ڹ  .PB B把䇿8uG` A ; 5䋀/)@#BS 냑5VŜPX
 a@A@ B C    FtV$%Ȱ%蝊<;weċ X؊<wM3ɆQ#"XR<  YыƊȊĴ3Їу\E pY8@C$0	 FWYwuF5<uz`0Df&	2
pu7f߻hNePӀk 'B@. ,". &k !< uf& bÊ$
rۿ wAu%1uhӲߡ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<fgKff
f_h"_f3f3ɹ f _f0m f+f_ ! KPu*XآX'3ہEsV4C\` a^_^fZfYf[fv3hI 5R`2K 珀L0s< |&	3ytvou4PsP 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .p\3 2ҹ*@GaaÍ6|hVWa|1z_^pk` hΫ$h  uP$<X5&sf @  t<   4 |r	.$<u
  f3hh. 
d]XiJh1<  tdbw_0s.>߄Nfm th3tC	
A!U2 u@> l = ]c 3Fd@ e f Fc~ce; 4~e uQ@@8 hӳ|`5
P	Y3h}BFe:Ffu1r,
 h
 _Fdt:   	9  <g htQhȔ`!asf`7UPHh3u;E#f% PCAXt# N h&N r k f ̾   F^P XSĻ  y ,  o   hbS-[t(t@tW,&j  j,>" '  tht*dúߋG."W**D/.qpEq+Ë؀TF/VU2NfQa dYF :uEQ]Àg33t
t
u
1t#u
tN02t"FF0u3! :5tFFdz ulm29p`F: uYeb +Πu;6F1 epp0Fff`Fup   j(j	R	aURh$2  pɺ 1w hZ]co_RfB`fZr@!  tgRQ Q;YsY2w$
 !uK$ d%|Zf`  WWeIh.&]f  pC`h} B%
 C ƀu0u.> 1fa
ZURtLށUHhdn<:Ym PY8tn(tp ;C Zoi@"g squ4VfRfQhÊ+%0;p^f[B]8"o a[YbhVq r 6Sj@ 2P s rGZ5'/UnAW`.uQP$<u:0p r"&  t  tt tAt $puPNq9(
ː

 ⧾P`XSQ 3u,S?M[rE	ˡ-Y[C& <ff<`00xx00`֫Qɬ||	w>>.p~r tr~ (ЃmrLZCX'q@VF :]Q<Q7W &TZs6B  D ц߆ԆrAo zuN! CO _u 0/r)0/c#-&@ 8q2 E o*7&/pR`W aUfV3vCDPDQD 7p4f^]&Â୻QM"%U  wPd?uX$epI|:eXa@ `` /////- "  ~@f%p4к ߺ FACSPZ 4DBGP4BHP  0934 A!  8  APIsCZOK	a	a
@  		`
  MCFG<	$P	     @(@
 2! RSDT(  	f`hE4hNsif  fhpf o  gfFgf  FPTR ff`WgF݌pf\f.@p^$f3.K.Hf.DfPgfN0~$f;+@hC}!~3ffgf&f.>f(.ItH22@_~( N g&F	f P  rgfffff+f+.L
ۑPM.?>@f
$$#D PXff-qAFV3g&fFgY[pff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt"@H Qr>< uBOаNRUfQъ̓2 tPxprAr v; tg&_P)XfY8]МVfWfV* f& fP&ؐ4o@(#f"fP)fȀ$ 4 
Ȱ 
ff	hԓp (f t  hjfPW EfX~3 udiZ$uc g kq+
h3=a+0Q;g&Ƴh&_g  PSVHI K L4[Yt >Ku	LC3j : uDb& ߩ@ u  D` ^PRW D h= h^>_ZQ4PSWtSfP3h f&L qfsPB{ġ`#L fX@`vߴh4" 03fpep&?  @ 6Qu  R DOG,oRf3{Ӿ pG   U!   0R>R&geE E puMPMLGfEtXAtߴ$Ot3 t)O$fM~
rþQpmMe&0RaxU  r.`]h2.<j]n;   ;jøPݳ ZjWp_f=
Phk0kf$ttӿ& t֟PE'뿭 5(1P)io_ԜVΎގA^ 3f`FF  h?vw }ur_ h  U$g(,0wu4'8  }6Ã9FtFfNA9F> hS9ɀuh(fa`
Ew13ɊMh+ӯt

h*p;r#uac5WF ^=sBf fN^ѸN9ߗT4u X4tc rfߺQPH_urf;^uf;Nt;ft) p 
tF~U_Nս MfOV t;6+.<t1!QQh
,,  ^_U00 u,h..D+hXكƗ p1_fqtA"   u
3   t'0gf GhECG$L<LDCOMPAQ PC Card Smart Reader\GEMPLUS GPR400\PSCR CaLB REFLEX 20a241 PCMCIAfRefl{ex v.2$ucr$HP
  wa@!g&O@ yGd `P ߳ rLfK smr>G	 .D
A O@.d.D~4f_ PQWƹ  
G.g&:uG Y.5 _Y{XQ8t *F 
⡤fWD
"
@
@BgT"

%Qfy_V`bSh10Gu#|  euu .u = Ў~ 1rp&tj  t_& rT  r&= us0=6>
r/6r4.؋V@< t ^}Jw 
x y z   hSh{ %ZMh>Casiaz
qTrPqtI	f} b
u 
!tQ&pC	GYV׸
~ ,`ؿvfD   ,AfLs-<_t(<#@06 h̓L蚿^PRU32t
t
u
5# t u9<0r<9w/tM>ư7SQ Y[t>"$,0>?*SQLiE;f 	tuߋ]ZXf`3Ҡ&&hG֎fv*`%h Ýgf9t0Xa` 2   0 t?hbq egf@ Vff3f"gfs F ff!
!޾S3۹: 8tCRP #ܨt r1hf uf@q  00i{? 0    0     q'  ' D {
 Y/ bKbƬk`oC2@GY kFD4PS_.xVW ͌׎Ǎ~Qr&} uBr	{: v_^d>r5)r!2r\E@&=u	;#`$Hr&E$7uj5íοH4¯Yӆa
sr7&a)rI DTtr&eY`4o5j`
T3
;PeL4S1r#t itct  t$BffL V 	] 	FWQ
R~3q
]
P4i+W!z Pzr8u`_QYs_ þ!L[ r&UþWN^L螳`
Pw4$X` $2L nB0<tH`8u6
uBp & D?BlTt
߀aP 3 r/) r%BB!J@ 
; 05 aù<t

B J 2@u8ý` BŅI2۬2Pxu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&a$vQ> Yr	2Qd'YB@Aq Brm蹐M^	 fpb3׾S/ @ P`ңPA\SX 03  _YPSWQ3 VSVt
KVt2?Y_Q f`j hb  H hS7hjρ h.f% ff= @u [jg nb Sjjjj PZ g[ hUÜ[bu\q?j&]$awtQ= ;tau= <t/Eݳ9 ~h]Ztfifa     tH{!uu):p0< ug}{up@ oz`3pr! grπ DƆ    rOZ@-Z=1zp$Wp_ǀ uu' 3?a re+ tg	%   .ؿf  ѷf tpuY[|zrs3hSņ Yڻ S= Mڻe ųF  ~f i `] tI%r=> ً~ t@@t0(5@ MF t w0ɓ3N !F ~ tٳ	-e0ﰦSZAt9A`j f` Wf3Q fY~@ IxL"
 /2uJp2:!&= t: 8 r Ϯl0VQ&Uq
e<sY^D^
=f"lA	
pq
&:!& :X.ۋ IohBBϱ 
D캟7@P (3 ?  A-sC"ups	1u[	q	1D!I>Ft$a3; 2 + fB \w	(Nf@2Bt 1Qr$!$|$
7R< !'Zt%'
QVJPf^DUYwR~.&++t'H"`Xtwt.a:``s; 6saCc0_p_pkocqoToo#odooao
foabםa  SAMSUNG
 LTN154U1-L02
 I1
Color LCDO4Xu3@154P  Hitachi
TX39D99VC1FA
TMDISPLAYz#D EZ0CGPhilipsLP	W02-B1K
QUAN[TA
Q0T 
OW01-A3AK3|$5
AUOBA V8 O4W A`              ֪`Ȏ؎6Ory>  >.w  6P3Ҁ9Uqf&}	u CBK k 8u+a&E
u
- } 8u
t	3ҋʸhdn"0PW
 
t_   @ك
_X! 
  J    SETU ˸ @؎&м  x r' hW@ P& u_SV  GG0G hc    Gu Fu t3  hC) 
h	Bt & ^[SO
&hl" <[U샿VWƿF F@     _ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @	<qt	dR>t <tjjjj3PZ '.wj5g$<t.<@t$t = ;t= DP hEJ 揿  77FF~ t#^FLr
F FQ  ~ wt: ] ?f
 hh\2%PFAx~ t
F`_^Q
h;ss.&udu    hb,$?wط h-"hԀ #h'*f_01FhۛB%..  @  Y(`p3WVe1E0E.WV .^_UP)UIQS6(6*`e1E0eEE.U s@ m2a hϓ4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	?
 QVW?u% p u 4  | = <tڀ ;@C
 )(_^Yq?RWQ` Ê uUCrr3ɺ ڑ܋%ZAB rN _Z1SAWIpIyI
WROujvzKMJ; DE<@ ;<<݀!<3aRu BMEM0Nt
Mm[VfPfSfQmPnf3f3nPn<nXfffDDG(	Dh fYf[fX^@t#:IgO GoxnQRpA3ۊ9 r Cs7wB`s@zfDf3ۋfË\` 	
C  S T R U 	#	7	K	Y	`hvh  h	 h#	 h7	 hK	 hY	 avv.L.< t)F.6%3.PF.h@\[+V..^̋] zDF. P .h"Xh} ؃P4Q  16V  0"Wa X Y #Z  
[a ` ^nBA\a e f']a a _ `gchi!j qp10G pppQWĀ>tk		 u	k	.s	_7   O 4a9Rһ -w C.=慏/E2VPm?n8o7@W3۸  =_f^߸^6_>QRrPS[XfhU(ȁ`fЍ\؋h
3     s     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;d   03/30/05C11/0 05 kLitSe  {-1|4?|6|.TU"x#T[T0	ϣT@ 
t/{3" 2xev$ÔdPx>0@Zڨ"2""Pf" x xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`@pcłŃ 瀾xD¯01uү0d01"xt}ി
~0"x]vvuu˰x!Du(u)u*) + 5QEFuu!)zүx00OmO}Dxe``
$`$p

xd
xx txDESxxxxgoD@.|0_}}@ v o :}d`xG*BYE%x}DoQ¯00xtxtyuup)w}mQb}ts ,{c,½+"(yxkD00 x^Dx_T_xcDxfTPe p# * -a`U2
,^&01I	״aTx"B2x:3T0/w/D}p!T_ _%0u|!	 T`#8 ~)nh04hq	P	2;oG	"!
¯+u+$?4>j~T+}'+p (++Ô@^#,p+
 
0%?
3
[v7b",`^0/}jW.@ /P2'`" "+7x&x+Fx_`t 7"6}

P} }	!	  @A
xxt"xd}Aߔ}D"* 10}=
0Zw"800x )xi`xjw  p 0S+;0/TB+x+¯0*20b 9P4.+ 20A؏+`xNg	+ xTx !
+:DTBKPF  y+hP>

 C[Tdp+$!#OP+p-`z 8X@sP` ðÔ2@YD0¯xx7x8r x00!9`6$06 QATH`	p15TnSbp:q@&(ZZ0/")~4"0Xї0X# LXx,`Uxtx0x,@pPD0xT?T{x*X-tx+YZ>T'xYZL^[L%M '	^GkK`k Aux__DND0=U9    y݀V>/RgxdOpR^	;;TZ33Nh0kQ@*ARx-	+_SRNx*SMx+` Kw `R0 
 peQ`
 RSPP1" 0X_ Ql`e G]SXWxZAYAXNSXW}X$0Yip^qZ1ZTLZ1:
YZ[m0c1\\TQ\
r[	\S2A}@ A}= #-A~^ B~`  5A~_ uuҌ"4"7x'D
`X /7d`!7pg33TT?OPC }`07`'`2`=`HpQx] 6uuuuk uu0 uu5ˏO$ƨpN`0T`
010 @@A"| }(x]0R"+,,E+p
0 +C,,+ +,+x,+0G0x!,,,++x_,,"-.pT0ӨL72!t
!Mt&Ipd `1g11[tU!Ҍ(0/0mp/l`
w/0d@TyE2AX.-/0"­ *xc"+?xt`
o3x7 x8W7St}h"[(ZYYcbdpcZ`\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l2Kd		

!$(+.2     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >Gg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 O  ~@ 2 Y	J @ | @ s   ww ~~ r  "8x4D T ` D)YOpx2tx1tI-'%[0' 'xqvv N'xq[CWxs$% & & #2x1 	ү  ¯0 p%#@K 3$b0#	Mx3C
r beJ"xrF`V0 p@$" '	x30%0&<T`P$"xs`bfp
0#%""tX.4} 
xs$3z 
`Hp`p$W$ ysp @@Шxov"x0	D0$$6Ӕ@Txy~D"04hxmx~@ DT 0
 pc0B"pxu1xvx}"xux~xvx߀x}	"oxx#xwPyywxxf`pxx`( Qu5~B@
"00"+000u0 u0 
0 !$0<HRTЍ}
0"HD =16/(!a0"0
	00"d0 $1@x1" |u aTp""3453/:HNP"o3554!_Q0"0"xoo`xaT`}xnov+r!3}TOp0@0 0 
Q]P:0 /[P'2)BΛ P` Ӏᐤ"78$ "0a T?2u$408S0"{z}yH237C9
u&9 8+
`9709707@2$Mh'Ô@^0p4J
 

`$Y	0
	@À{0-$`
$`$p!{a"V K0":0!@À-0
  Ҥ s	 280"
2x{ofKp0*2d|p08SH{zy  xpvmJ%_`gK8P2 ( 	4 ~ "
H	5345q3`	t%5544r	@ :0	h0_"08`		2A08< Lr@1 
 !
 +90 B? 8, 
jj	" "!`BQ
p0( 8!~^ 
-NtU
]DU C8.
j'	20"G+6,,f-e2pO7)0	LP85p
b3+&05	zc&	0
S Q(":"088;pfpO:2"`"/c)P3
.7=Cxn`qe`?0}?Dp h,g,"a,a b}iG"4xMNOpxD Te4`^}V Vp0
T4d`#@"4#?p~}i4xdW@3 0
3 #O`3`3$`j$`6$p$u$`>$`$`.3$`qT$0 DQpAh0TxvSKv`@906{$ f`@`Dx@[30p	3]6P Cp 	`r搬?%¯3l`0@
 pTU`xk  Ng) .|Hxv
xD}S}%0{P^`
}mT?DtGTPtYHTI{Sm#@`T`yQ	067``$pa1e7`tg7"r)).*)б'0*a a
Td`x0dp#  xF PTÔP
@)xFttxBBzxNUN{}wxJqJp:;<t/?=)x ү!:%$>t=t=;2)0 )=o$Px`vT"` 2'<x"ү3y:; 0) ;:@ p0 xύv6xV86}'p p 7  %76'7  ""88Ô@3 p/pP'  /..d`
&~r7?(9TP5?O(I 4" Y4i04/`P453``/`@$pN54&:I&du*):P [x 
33oppG+L1>gp1  ':P"ސT~ ,P2%?T#>үd`pxH 8@622P65Mb3e1@dx>1Џ/ 
m
@d+0xA%30 Bo1
@
 {w`00
TDTq@5q0	 3:@a# AP}Rt
 u2P2bt/l@
.
@	  r1l0dpe`30DxF105@2*`e bC7xnu3߀0 0u3r2*(t1;123#.1}@80 =$32  a<0? }~
1pAR ErpM#"p  d-|u*x0s,u`2:,]4 2UU.X5-YO,*& 27p32pha,
$+Oz!% |*R5 
Q'x`S+0	+`3 /}-R	++`@@`p7v@}	 `@~A0y!T``Y_` VWy
7pDxp.wL_Dy?Nߣ%@m53Eop;OCD-}qXTQQu:93: !p	S31/B3dUA`hy%%cOvt0QON@pHR/ N9
d.0
`/X6Fp0X-64F0570`5#Oe0]c6e`	S8@1
!b߂-1ÀI%P/;u1
p<~ u11PW+C{p4z5z5
3z+,yuv {| A, 90 &p nPÑkT0g ,	alo9pd000 upo6o,/-.rpFB}}0
P/.-rdct%,f Wu tq70YS 8S;"WW4쑔p0BŐ}BT_0=_<I?`$<p:T0Oő78e`pYלBxgTAx`%draz0 } 87>0P$3kq"W¥A3	``uqq
r	1Q`{0
}
9ȷrdP9$$P6"{ 2F}&e'AChS4Iq}a X@apR`pLxpG3'p?u]1U^I#5_`@TU`#v@|T kx{}Pxzp Vxy TxxPU{xwQxv0Gxuxmxtxaxs`xrxqxxpx`x|Px{`Vxzy@UxxRxw Gxvxmxup&xtPxsxrxxqxxp"<pxkv00,pTxgLү44" .3k0.TxgڀQg/{_p0P .^ ##--^--ie C2%?",u/212B0T-_21Կ^ L-. 'q,Đ/#ʞ7,T{A?O-.`.pGʥQN.E.NgJP70p60Y()y0Mh
P5
Ps|?`d7]א}SPn,rtFar4N0 `a2%Е
p1
P

Q "u- 09r"l  },n1vg8V,  A3.02.pM=1s0D@dT0u`zP;DS,c,u.B.` 2 p0`ou.Ta?1bC
.%TOл@QN]03p	 `` 9b N $ 9)NӔ@6S ? x0!  x5Q0H UQq7prrqxvWU	Xu

		0
  `
7P"q 3
G1opTJrAL`>M)60.T`@}~w}S?AP33TBDWD  Axk6"]@tF C9xVxYFdҢX\`T`HTǯ
PMs>@Cp!3"x*"U\]@0!Qqڢ97F 03tv`
pUr *J(( (BP_P` qw0P `	qPa"NߋO.eB"TO{EN Є1n`<ٕ<A<aYpo0:BP e0!J]I$:1VPJ1,F;KF	D0c
^"CO`@"HIOv30aA!Idp`w@0tǣt A2bIA؏J``JIxovHI;"xFExGFxEGxFt@0) FT.`xFF0xG@Ft")"F> 0 G<"xB!C!A!B4/)B*( #NA
OA
MA
NT/I
N+)D
UJaKaIaJ/*iJK
I
cJKL;Md`NPT&` v0uK K@ 
MLtS Q@HKJ}m}t}}{EAMI"H..Bݓ Ô@""7  "xf· 7""TxDTpT@ۀp ?$0k+H:D}@qTTJE}Rp*U@@@@@@@q@_@Y@S@M@G@.@???  @BYQJJ" #dbr! t"xbq o "BypD)6	0R#q! * 	A] _:qV`R [V$`RAb $AUӔ@fU1OU0	xoZÀ!}aAU`#`5`2$pCxD4SS [CxaUUTܓxn& NYq 
xj0x GÔ@<PTxjB듀Ӕ@`BzYr
T"  Ptjxf0Pav+xnv2P8Put04}tt  }H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATUBRBAC勁@*F?}mE#b G$zE0U`Ud`})#uURBDDDD%DOD[DxDDDDDDDDD B{EB:KD 0rtRpA$9 pC¿"-AE
mPT gޗ@HL0M7 Qv&T E7@UxZF!R
hreap>@X P`A@8aO0D=Dd
`#p`(`0<`PdP`d`UȮێU0:NRq{t td	RxtxxXx\x]txat"xbt2xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtox x#x> x=tp x@t	p0xTВ
}>%xt{x"Ttx!TTTaD	x?D@xTpT =TT	Tx= Q
@T?xDpҰ?=DDTxkv0}Gt UdQ eV`eTeP}S:"x0xI"xh/Lg"B S?/?@>"A$tO$-"T`Ô
P~0~7%UU eTT7%TT{ z yT`H H+H3H4H#6H+7H38H>9HI:HT;HY<  H^[TG Q
 I`A 91~5GT& 8 `;cuTuTK0T"$`($`*`u-w/Arp40
T1B P.GQQb U T"VPT$```$$`(`7`F$cpH[	A^@
:w3
2  *}0W06 `#'/A~``,`003`G`[$ap]Tp^"T  dpF^0$s  `!D}ࡌTwwq/!$ Tp U "$pR`PLfQd`0EQxhQÔ PQGuG٭9q@P
qJPxhv@JJJJJJJJͧJKKKK$K+K8KLKKKKKKKKKKLLLLL!L,L_ _ Lf0
`2v"xMNO`uRRRsx`}i{G  x.  "$"0RZ
R:gp; P x"} >HG*}0"uS@	0SSST
pTS0CSz {0P 0y@4xatWhvaUQ `ӒkxTxkD0FxǏHxbx"x@$xx"x`}K}IF	
Q@PM0""3GxT| } ~ ?I4Q`*Nf QRR &NfL((sLLMMMMMN
LLMM
MMMNN'N2N=NU.?KqÔ`P/QHg"T{? } 00xe@"QfSoQЙJq0pV	@ݰ50T:}uQm0ʀ  0q0)؀	0PS":Cp$p
:!/0Qp,"xdP P0A3""~}i y0?HR3dAP>2I1d1d:~0M}E!@JC0" .PPN` QF mT0b`dɑ0N0#0xD Tx0i_!1?xxivT AAPB11u32}'  $31T3322@"O%0  "'uW "   p}"/)O\0/ÔЧ/pC0S00O~2%00 "
xp0 "ŢxȰ♎2345%@"(t?3t 2x325R4?U5B 5axQx}QDQx␖Q  096x}SG_nSG CSAPĲCPQ'QDQ4 RQRRSSS%6x
/0!x
tP/P
0/Pxu
  x
Q{Px
! %60$t $T &Qxt	}XBxs0xsßP2O0 pw%@$X4$ÞPxxs`1 	_21_,,-u7P. <Tү$`& p<OX} @p% IBYx.-,6	&xxtӔO@v $(xsvysßxtP!  P&߀0 	r6
p`xv 6x.a`r
qP 0	,xx
xR!x	06SH)o_P$3:p 06d2@Sq SxSSSSSTK	T|
  T{pwgD14 D@ @B@"xDbU$P``3@TOW@"X  ,D "z9TSph?`/AE@E +@@CEtUm O@p { 33TOB  @ /"p<1ß`p}T@`8 -5,,~ F4S,  S,`xevS, ?%S,,"+,/0-V bUx	` }2xN JUu0 u1ATxf`-30(Ӕ
P! 23	D3E2MX^SS0S3u2 u42U03U1Np1%1030444 P-5xp7x	410	^p_
55-Ӕ@xA1 w X?X60c
`/p00Ӕ@:P0-	`	`VVVVVWFWaW|WWWWWWW$X%X!&X*+X8,XE- ? XJ-`:S	XJ!xu/}@xEǝP^-.^P
.-0]	
x3Jt?e.pt e)-0`0p	3pQ|Bp"	`pEx@}}t*p
.!  2#Pt_-Qev`  qW} pQ t u vA߀O}	}50R)ԐA 0qp^" 210 ,+"``{Z`PXXXXXXXX	XXYYYYY,Y3YPYY3Y  Y \YU\s  S1
tt)Ʌ|*#	
pt% DoT2QWT0BQ
2:ԳP^`p '#DpPWdЉ]P  rgZ `!L0tGNt(tDi4rOBkQ
xﲌ)SP`DQT,T
qMC#_ "gD `E - gt .`T/Ӕ@"À--d`"` 
`-[P.t %-Ue.`.6Ô@aG[oOZI[O%u^"Xto.`:``F/U.`"U/`"",pa/[`cÔ@ OeA
"x
xt "Ӕ@
u/$ -$wU`W"xЊ0"5}67 dp77p67}6@5242'   `" \b28\=\M\+\!'\[/\iI\xJ\K\N\Z\[   lo"xl / "0/Ҷ 0opx#R1l^PP P P  U
0k33%$7`e2pL28640"05.4d	&4
4 vrov"Ô
@"4!b~4$`$`2$`B$`J`[$Wpk [P 0/V_QRc0#D	q^v34AQ4p-R0q
0!D"/""" $P[^D^L^R^X^q^^^^^  _&u2#_)u22b ! 0"t`u2F,!wu2=r(
wC]2b(60r2UDE. u8
Z/0"HQ R A0 3A߯2"0`"x%0QT~t@"Ô@Pu`@@	T =" Oxq~M = "pސ}t~p0	Q~_r!#x0x!TT`DƨpT}!D`!T1 >AoxDLQp"  :	;
/'
123B=>C	D
WX`~x`!@UP ^`_dI"
%'6xF`7@j0x+ +bxk`y}qb+s+`P`C0/+xT 6D } 20pSn DT_`m 0xTT`P80w	61 aS 
0cx	+$```9 Aaxv pz q DxT"xStTTH`g+xS+<x, 6, G`$p#xSx+	x06W0/QI

?0` "P.w@-Ӕ@	}-A-$``
$dp<0/yC.t}O.l+ dO`PcD>lT0dPG @a}@aP-Bp}} t.kdQ	C.-	.@;P1~`J$`S`X`]`h$epj.>.
Cc.!<d"dpsqai.0ӗ\0T: Lxl..T>xf.88V1.T{P{Pok7ӛP	ӝ o0}߱d`pWÝ@ӛ@*ÝP:;<u at/؁7tf"ůp0@*` 0I"xp,E" 	/01p4u5Pu<$t}5} ʣ/ fe4e^eeņe܇ef
f
f-f-fvfffff֗f֘fgggȟggghhhhhʧhhhiii3i3ixixiiiڷiڸiijjj1j1jTjTjwjwjjjjjj  j~O0* pC3/}u: u; u<3{c4kT13 6b!~1 6` kR3`u3pwuu:u;}u<{xu{{X$::;<{&5hgR0   ׶'h)g

-X>*05EE` } P0C3+1!~ .`| }` @^_N0"`T"!"H
$*
#5T'((|INp:IdG @(
cC 001{q 7'+'(.))X0,/,28.17.4h03g0to.|U1rPAA$__TW&A1 u2dG'XA=9='XEFxBwBʪH˨DD(KjFFSo UUHH#Mp6 P!}UBfP"/"UÔ@πu3//ZC4"$y``Д!wSPk[qp ? "@A~K`jnAO$lAa`P&A`#`#xt@}}X}ս Y  ZxqBBxtPBQ0%70$"Ap
 @"&@AOr+  	Y	Z 	 
[	B_xt		 ":bx>T=Q
38T_Uߔ>?`dPmP?ו> I IPw0=p@ "08k: } P' 8@
఑| $ >Dh0
`lrd Ep6"}`~M }`q@OQ m3#@!s1fݐ}ϐ0LT?Tox t
䣠"D0q[0}+ s++.
~M12Q^uH`v
~l@&Ñp0ux=&q2 
41pmn"14Pnv}f1xe 606
 0!ˉ ^6'\}pp
T?T`4"4"u2<0m0`~@~^طy 0TODԴ001p322\*> u1C00{ 	3FPP`7 t2PD{2B32Cp077 P !`&Rڀ@P}`@"P3"^0 0wT_O"P
0._$  ;q)033+)e0`0>f1_V҇e1q)0o210pe ~c  0`Jgc8 	1D%J@T1`1:C:p*"45675E4`154@hP
 (4g77$bTo`M3`TM0=`` `'p-1>Tmr C Dig h0a#CC e/rۀAB_ÔZ	)u1au0( 2u0	0}}]p2~ Qb|ӝꀣ2u2u0OP*< $3@`20C@'a@'
L`SV1@\rD^p:p7002`ATTT%%O́=vXDp=3`"{`@
	o0d`0p_1ZQ[t?`<5A?Dp*b3tqT)81*	 "a F@P҃!/0	<2`dO"!K"E$%'Nd%tlݪ$	??
($	6
?b?(tx75UR}{zyvUh7vYdh0vY04<tr ?p_u/'P~ q./dq5%tZt g~@_Z4r^Qpu{@ {pT0oN`kl<2tZ	ÔPtǿA䑖o`!;~`x45c@2/Gk4373  wR((swxx'xBxgxyTzz/z{|}d}~,~~~0$Ef	{ z y4lL	g5P4F w
Pg?RSzR13D,t?~5{u4`u5 ك	]4T`pd`рgQ?
p0
PFtt	Iբݑ	u1zLqnblpZ}} -pUgggPK
ß
>Np&F>0/4Qw&
b67d6ДN6Є7"PnR@Id.+ e5p4l`&kIa 8)8CH| `z {pD` @\]L
8t8999889!Q!d8 9!
@&2nB0gC'/ #TĤ[s98&d]픝P610/E
8 F FP2GPzdLp;|t#II<~_mpCl`??c\,@17UdNptOLVK0OKeK7Uu>Np7>	r^HQo`JappNӐVSYSSni;b/9*'P#vZ/iN T2&()?`ik&b m<ѝo=Rq>s?Mn 8iϕ}lIDT9-K098n0,78v3 7w?v%3ß"27u~}H3APa Ô|@3$`D ^b c $#~ 2#u3#ux77pdE`3P0 0at8u!@PaF_9TT NpQ @B2nP;4u3t7u!	;	Xe3`37@1`04apRg  1 Ш0?e31ۑxBAWg˂1p̑2`} P̈2"u0xt03{}x?%݄t~RNp:>f2pP#u2f	op`8
0ل
``&1A100aALxeT`&q$31dtPw2"u}`q 
"""4}tȰt ?P
3U02	~LTD"LION ~R mp`(pP Rx33pd	_I"_2~ }p@	MVp2btjP22s2  ~]2~QZ S@RPS@~Ptu4<P42&4Ru3{0SJpTXP~U	@p3'~\p~ y@3hP]p"00~Wc"/0"534u5$*``0$pB/}u:u;~u<V{c4E`eW{c/R{=3//u: u; u<3/r4"/^
`  g"p	` JWT"/"QLY!?H  \!QNVtPO[t- P`ppB-ӟ@
-  e-`P  IAptQ`
Pp-2"[VT3pPQR, `"q u psP&qi &i`\A`)T..PTc%,'`-lP,v5t@p,0A6	b"<x9pP
 D?T^:p
"B~ dڒ!SÀӲ  0d"0Ӏ"7 Io8`0@
GD bI<
~,T e8G@Np k21 M
0IPPM `"x0px 	*â6S?Nw?~ 
0QR o@n`dx"7@u&X4`,7bPPNPN Pnp	84gk8$Br"89I;5<u=98~`e9p8lpe;.9E8 `v@@~+P"~{_
`qrp$Ȑ]^::@:@Зx#*	: *q>x@+:P  =p ;0
 />e<`rp=5=?@uA5eP+F @sx@@p?@?@;A5{5A@@	x&T 0"%T~v O@8&03@"`@T`B~"x!To`	TOT 68b3o`G2D"C
@Cp'x!7 ?4r10*Dϐ~_o`eS+ ^0`1~K >dI&A/t"u;2@F<9@Ju;;;`W F FP P9:9@ɰ56x>EM  >b665À5oP	` 
F~cGuBL¯WDI^RN*2+u,U
,,/+,+o_rT NFmG	_,xt́`
T0x!T1S4T?Dx!CD@p
0g1dpa3N%33p*`3p*a@
4^pQU4cv.@'%%}q
O =`0(OTdV		T3Yb~^` Q#A""	F	 >	@2xpd X LҀƀԀin3ꀚڀʀ3䓣łŃ~ 
`	"3/$ ̈$ P ##EN```sB"P""):"P%0 "b``"ο.` "  )" /33@p " 3@P"Ø"0	Ý0  `r}`0"(p p8@
!	P	^t	1a
b*q2	1	"w<t 
""BBE"""ЃЂP  tsn^6 s)ŃŃ& "%@$5|bpp
߂s@h`߱5p5 5@~5v$5@n5 b5V5J5e01515 p5pܟ5v5pv5v5q5#s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         P  J     MESS.wj?v/Oau!U6f#7Vy,HXm
	;	M	\	v										+
;
A
F
K
T
d



@yk
^
n






	!%(08=DKQZcinz!Dh^~=]n
:N 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
602-D ette Boot Reco#rd0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the conts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7A proc has bYeSed ags n@orQCMOS13- s aAby POST 1155BoaComm P6 Assignmlic611-Prima~" Flopp obz2-S nad01W#trol`)y5G%sType+1783'` Q9)	v0C0'Ef& 1	&8	3XP7
~60-Fix"	doe"sup" Blo,Mod117'r[! Aoμ$173_{	DMEA53?5?@5Idp@ify=mmKl4O>	|xParamKr TableWBI>tRXHalpB  52PX[ap5.Invalid elPronic serial numbeV16I/O ROMX3`7KeybA630bF83047@b4cUnitdLoadalWl -\h44aMonochroym`Rl 164iSiz=_
r2rXP%WInst0letworkZrvDAct\Nso &aach16`KoOp1gsʐt^ pg Chec2  PCI BusJ_10-Exn`StoragJevi0sHPnHPFA1spV  Ol4!14Y2%3,3_2Xz## Se(OC?HECK a#@ yl3-Ti`& Da @ X    ~Power-Pass0d	XOK Do y[oullЉa to p~#~s? [Y/N]

AdJ0ia 	R[or!hip8nѓ... (ABO= 'Ctrl +t` Del'18-1@#h: $pHchangedZ2: f*mBqneщq~p0+*3/: VideoRTz-4z:Prrup fX5_i *8]6_an ^Qexpans1bPt  Turn!!Rej`Кfs})<F1>:G Abp
!bq^rmal820UZ mupP#3giDwa,6#+Bk1.(Strg+Un/tbr,I n%Tpf0ow$o$P6 utom`c4updQ,: ۘs ToX miX: KbytBVcksumk,NfauP/kulcnW1Next? ErtiExfȠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu{ 1 MaiAance!c
 Hyt6.<swi@s us0modu+4nme@$+requireAs.  To c.d.% LѣBU7MpibOOay1__2_]re搫excee@ !pӵb1| vCircuvLUnw l!n$dy.L.(. ddoee. U2S_0m"SP   2oI#c5^ InrLShut
downi  `0	-a:1Pe `;PIN: [
] \Na%left+0H1HB@6 Pu`Úo 
v^oax`ˈ`Ӏ,ZbauS UedLзcuRc7hipbeQTEpmJoldNew _ !upu0cF
!be`$Ȣr"-l du<.t!_0#AgJ N[!a
 affmHPma,t0b@mak5xxлunusPVItIong`6en! 
f=]%u0l,Jrec2I`paSAѣF2Fj.ERRORYhQq <!!gonefyBla MIpx (MSGIDX)     wN   P DSDTDSDTЄ  HP  nc8200   MSFTC000
 [L\._PR_ 1  2
 L_CST p\/_SB3P456`p
1I{7
 `8
  Up@9  AUBsrCCw GU@ QDYDYDYDPDp
UEEEz!E8qDEq9?
 QD y 

BAG  |D
BIG
W&
!C;9ߊ
d\`F2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 710ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD1phg	gi
 $12g 3 phpi p
 f"`'fg`f b 3f cufbc``~45E
Microsoft Windows ?ME: Millennium Editions NT C> 6F
`,p\_OS_`pga.ag)`B5
bra/14ua
 6
} s %[/I` 
u	P:13214416p0145_INI 6H8
fpig
f 9i` g9hrgfata
apa`r
ahha `a u
 bbi@ ibub`{\a@[K
#9_HIDAJ	_CRSR A)
&3	F1
  GEG 02
 p(D  )Et6F C020C 1pyF22pB1t#21A̑G23% 24 5 @6 r `8"4([9   
,[9\12AB4[
 CD	6O
[	 EAF30Q 1 2z 3Y34 35H36
8?@[Lk37!8"39'6 ABX3CQ D`
3E FV Z40Q 1 2 s43A07 {440a45 V467a89AQBC0W @pDE}F50  @"51 M,53m
@F!`pa43a}aiapa ib{ab[\103'
_C _ADRVl& 4 n_STA j `		5p
T16758
T
C[)58@uqr 7 D090P859o59E2@v5A& @? < A#5B [#PCKu5DD`p` p`b`t59ePZe` ap dpy0cCdc
{a@u
 bzdx555Dq{bbtd
q07pu@2dcrd[5A` dz?a
a@b{
N afuff a@Pdu7`['A
Ja
І60L
O
 G1
aEw9 `EyH d2?y '&p}ҡF 3[C 2pibpkdrd
edA
d hb @brb

bhb3  45no5Eja63 F 4K663crc65BbN6!war`j60a%bP]bR][]
]
bu]atob
bP c`^ya%
`bac c`/$67SPSK] [60
f63 @~65c)6!k68P=aaq``\68@1F~_S3p 4 f`L6 fS< W

X6AX @4[} 0&_B [&C%@ 
"@`6Dw
K6Da@{^.h(2BAEDFF@[G:H c70
`
[mD070@71 i2 ^7^75AW7AW78T79AG7Pq B} g7C D!^7!^80 p 1A\82F#83 H84 l85o

l85@8^87j88 
<[=   @9^a8A 8!f8 1D  ^pg8E 08Am90Rq91`
[ /2	 9 	4  9@UD96
7N
@o7-899 
!
W399 
09Apg~S9BgqC3D?
[! 	E9F A0|Q A2G A3[#\_GL_bp
`O{0˔[!
dv`J`A0A1{hPjp;
p
Hrp"aA2bV[ Kp	rya
c}cbaa4 (8` A5x0 A6ChiPq`y`j0O A7
h1"0: 3!,F+ Dpa!)821Wv(@wA8`\ip@rm7C"PF(bA
iB"`F49>D&$r]AE}jr2:IGDF:zB1AA
@
[+ ABA=CQ D #$AF60B0 }CПB1
A`qC`wC
@ֽ	  z{` za 0 
bw
t
	ra]bC

 11
( )U{qv"OLB2
pI6'B B3
yo
rw iH2AE`B0a{ ` 
p{z<1 wi`{a`  sbB2b mAzC14	_C`pEw
h ncS } s    AA3
ccFB5
l
B6 !7 8p
&ue {/ky
pB6e}  e A`j
7a{`!xq8@p #b}e
/e/ !	e e$}`@dAy?4{k
 	`;}qD
{  AD yЉ!-Dp?d1 q6B{d AB"}C Ce@ |B9qfBp5p 1dyc/e@
QT!"Bhif"f
j
Eb~dB	!ba'cz!Doby
PMTU6CTHPCI^Bb(p`Ab	s@bE/cnyacaAEw'F`FB0e  dBb[F0BGGGG0ڐDBD #QBE
@!BE BqC0-_PSWB`k (!``C0[(`16 CQ2 0c	C l	Vo	o	o	o	o	o	i	5URc	 o	o	o	o	o	o	D.ҙo	o	o	o	o	To	$N!7#%[M 
8#xQUAscBSC3".
[@C   /2CF
P
[5V   DK взD2 DO D4  D5D63D q@~  D8OT D92Q
U 0D=:
c	A
  B DCDDA!D4/RD(DX//.E0 & //e!e!(.G!G!@(C E3(@UN 6rE2G E2//*.3@ #'3//@A eA !A N  A GA "A  "$/#5(5//N 6`03G 6 //a0%1a0%1a0n0a0G1a0G1a0@1EtJ  HE8	E9	
#  Oy  E h`и`o`
`p`apa!@E9EC	@	V`Q	``ED` a' 4E	 4Fq С	A`v[ODPHIDA_UID
`|EC^^04`1!o_DISEDx)_SRSEEh_CRSB8Wa2r)$+b!3 r)4$;c14r)C F0M hA 5r)0}[(iQ(6r) $`k0ja07r)H4P{8kq88@r)7  4>8E[U!a62[F51F6
r 7
 <$8 [#"GPCuZ[@KF59Iv1(W BO5 -G@F	QkFC
,  FD Ԃ@LEF :_REG30QMFD`pPFB B_S3D
p 4p 5C100Rݠ({ 1
k h砱48 ` 7J]`2c9C0_K3
4A`
{	h`{`h~4A{i @
47$ q\._SB_	4ts._DOSq	6
` a![^5bb ha[a7
CPPpDCQ^V 
 G 2 7SShsrRS** %Y$
 
hAE	8hfp
` {\/003#A9'B
0y1`A0D   Q   P  Chip~8F@h{`@}`  @Fw\=\/	3F4]8 Az9|9H1N[p,B
i;C0A7hj	~ 8hijCqla.53hR95s 4 3p
6p9692s 1z F)D
^/x0kl3V+E 9B` 2aנ{04a_a`0pnL۠Z`DV	_WGPE	
PWQ
Gb bGf fv@y N10FN110N11P<# 2A3

p41 ?16`
7/cD(PDpip{p16
 a	ia`118[A  @@ p!19@41QAp #  	B!C)eDAE 12PVr21 2&2@m425P.{26Q 7  8s 9cA12BCD jEF 30Q 1  133A456R33839Ak Bs C@/3D3F40 P 10
443 4 q4q4781934AQ 
4C4 Q4F C150_INI >51 p pQ53[   I 4 }@Y55&#60p`#0p41phn %/157v!8x`\`cP:9	wh
@axa
db`t
@`[@	
a
`@}a1
y`g}`aa08Ad azw`
d`xr`
  
@bau5" B~	50w	
C	
50D
Es F
(6@P`q r P`Q3 4
1516627
Unknown 
NiMH 
LiIon N6
66>qF0s  F6@I2
1\60
ha
Dx147! l#61 s61@)PE}Fa{a
^;5F}QސE5D!
 
jQ1!E!ED168	0 qZP AtA2Q69	Np
J{`􂊁 ID6A
[)h`pM0`
csc
  dzi@r`a[)absdb1/2a*(cocC"B	@hg3
y69g
"{U)D266{`eg0&C'Dh:C s824 8aEh 1 12B w"4axra
c 
dcbpb1b]655rn	3D`a Ea$(`a->Dg5D$I4F
I+Ep
 W 	ip
Iq:!>E9."2Ec0s32 3Qu0q{0``	{җ``#IFA384ޱ  9RL2ccdp eeez
cpOecpciEt%4`?~ |+p
s6pIB5`p
`k4[62526C-C171_@+aN)022Q-  T(}
>
>7  P2pzQ{
 5[|%*!E8(%BB3`F`*ae(aUAh)1C1	54Catoa
ai
b,zch!
C	

6Faߠa`39?
@ ra 9PQ pau
paHf:baUBh69CU9>CUC2;3T0R=4U4r?55 [
Т72rAq
HP   a@3F
Sp
SIMPLO0~SMp
MOTOROLA a>`w*373
pO
` 
Aj>(_Q03':Q{BRᱠB4u14b
Աp
az43
bⵝaQ05`[TZ074 5['cTZ3-_J
6pn
J na76
VqPR!12A 
 1_2 N8:Et# A&
B7^U8#9n(O1169(_7316

,!
{ (i287i 17S
 9[CRA
ѹ7B
NĹ  UC֐7DF7CR 77? C180q 1 2 F`88!8687s 8   8AaB!8C
[  ћ8DqE9091929 Z z9091,Ua+ 5 A
o91MP96Q`қa`| 84`
50?0
 `95Ovpj9798sA ! c7ba6cϡ3g9b qaA
8fBBc198zya
 "d
b
 bdpdS c
 c
Оc
598B`9994p`kaPϕa
v2D albab`b
vbzb8N87p~`F869q !9#y!d5zj
!%A8B=pA#'2qbb	aq Wbb9R
4+7E01 ʠ;`V9C
7E6"`8p4" 1
qD
{C03A
`{  ia` w` 96hp!
`!K^a)E	C)hAI70$b cV0DacbcA@'K9F p^^C1A0cIYA1LA2

Gy 1AA4 `;A197/ PAAh@e8A2^[L%P6F_C  _DDN
COM;A7A86w
30U"    8y `OS  A8I_STANs4w8pC087g0F0
3ߓ{\/"V003i4C09B
A7D
0`m IS ϡ?3+1 Dp039PA7ҁ
QF?_SRS]B;h
a97EXqA9"F9+"A7@
_CA

 A`E Bc
v$qS!_"X"A[nAA   
rGB
_ON_SC_OFF`#PR0A%$0-BkM%$C
_V#G 0?" *
$~0b(['D2K
DAC ADC?^,0v6 xA AD1=AX
I A * 
 	B1
r
;/!AC!B1"s"Dx""u"30#2j[`B2m$i$!P%`$ $B2А:p3mA4p`>  0=B5
."a\AaS`B>BtBB#NH
1 Gxx&xx"q)x)xx)F *o r ^r_ _u\MX2XQB6Q t%QQp"q65Q1QN?3?303?<RQV3xrRn#*6Gm3 *o3dSbvB744 B84?V!4V55 X50||Q}xp
,,kлB8 rQ88!]QB9=]75]0]&2]qCqqY:9)BA p\/0s({w(gq`{fxИ Q@z[OMdd$B `d PBE`  `ɔCCv
G``Gppd P+CF
DC0`7C5BD9BDC1[6@C2U#~ ^"  y s30w@ @ "-[ӂ5ah5
 
q tPz
     *U"P4t~a a !-5
0 p Gor r " vƣ` `0_Gd d"l[IC7
" 0[ӄ0@")UC8aҘ  C8C9&aOw.
R    [+ @
   
 
~@DDC060C0ADR   CC
D
[)CCvD БINI	D[CEuFD E[@-D0r-a (3 Sa=>Pr:}d%'D0F	C0qPRW
	
[BcD1"#|@D2QʼCEC0?D0["

 CM_A`{`A>D3 p[`GGPE_L1;A`D
 z	/PP


@[N0D1
	_RMV P*_EJD ͤB.P C5Q 1 2@D 1D6;@D- @*9`(&aCS	C>1
wC0@N_S3B40AQ=JCa<Nra[A*(l
DEqO"#-DE!BC >OBOOOOOEG6C0A9VE1!NE`X<
3U#4*N_GTM p
4& ``5 @E6 78l iE9@B1 RE9{A=3$6
EGE67%E
 
Q0
xp!E8}9Y0EPE7q8 E8CWMhT
hT
hT
hT
hS
Fi P `p
w ~` a:` A` bwb
bw`
cЈib ac  rbM rc ue`5ab2cEEBbca:6A !{ P0ڿ4I
L-@##M
joomjfjockDoa4aME$C . ,F Ea/OB*t3N
_PS0R U O2_BBU9A	
O# `}A:BODCODDOF06OF1OF2Ld"\_PICuh\/weD9OT O@xD9G
pfQ5   Q
cCD G Q		 GCF
 q1a
 

	
	
q F2
!	A	
a	Ax54C3@"cB0#69ME Sa  t  G !Aa[6E@	F
R  nd
d
Primary 
10  
LIon 
Hewlett-Pack?ard Ey?Traveloka	D~v@ C.pL@6B	006Bh`/`~Я%
 
~
" 
 
\6Eh-eAAFAۨ10oF0a0vF0Rxp Fha`DhЦ7@4
__UID  0O BI0\Q  ST FCL\`[G T76>d `)`4 drcJ7s
ACPuI3	G	eR/006`D60 $zǰa# mp&q]PRq]002]83g`Ǔ`b=F[:@ F
 LIDB  QA
	/15?@SXRPN1Bj"#4 F5 
6`` `Pkwk`h`piaFa?PF5" a{`
ygs }a㫡ap`k
  {pap  7 6 4 1  &F8u "v

   w `2` zhp_}
yj    )>!1h)h`!	` ibpbasabcpcau`a[1PFFA! b  Pa@BA<^ Ci>D FE BF?C200	s 6  p
7`
2 P  r
O` aP1 2p!eqe[0wre
 
3qA1b2Cp_FAILpapD)DSECUp|AM2E1 =p^4b1Mxr5}6R7]8-3P
ca9cp
U

A
	UB
CbDfH2Gې  sFAt\ 4	G!  EF10 d1112F
3̿14154b!  :u..SIMW&1@21gT__Ζ%OA.냈bH*JT7˒Pp0=  `Q|PPASS3"QJBW1aONC04Eњ `~ 4Eap	o aq50K@RsL;5@2PCw7a0bba~O b ub`tN 755 H08h<p]iK9#MAM{BF9
l q p QЄ_WDG?
<4_c,E=DAAyB{M4C~ !f ɿ)AB WMAA FCigj=qDtbҺ1ZBrp{8pi0I0F{h
`7f046
$`p7^049x50FA
,*:т04AK	7
  N \0 10 GA6#a
i ,/9A4(o1#a>2@22CO7*
`;{9B1 08k:	2	Kq3waI9!hq_71h	)a\P8
@y;!m 74]U#P#`5BJ$&OPO-hJIC
=$@ 

p
1g*4+0Cep
obF9.E8u/ @o?	p
y_\
p
_z3O6p
oF
)--7q%C%
h-C/5/KOR0?1@5V  0m) ;)!M_WEDsXVЮ"RnA2Y1VXWr B8s9пWQABNFOMQ  `j:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'a^2]8O.m (.ܣ?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=X|gMsb31/~[A70x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC z--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[D[Dl[#\_GL_yh
DpiVpjrkF!o051\`4h1`	l['{['`[@E

[ PF2021 r 2Q23D21ph213020J41aFp{zh
  233h7	F 32 2kE 62i	
	27f313	P@\_TZ_p3AG,n

0Q
h

B~
 f[ B
d
A
7
(
3Cs D

E
AF
40
5q 142s  z445 6 7c}W a8
 174 175
}q 9
"09	py
h a{a`ӡ1Lq	A
кi0h
}`
`48IOaqRb0cb
 {bۃc `0b
pz~abrc
c^7`:0B`phahQ47i `r@	ap! a C
 a bbJP&4D  8@/
pR 048p6A3
0
	
 t 
axa

`br
b|Bbtb?'p
R
 R
a!

Qu/0!) )  6H 2E	B
?h
C($p3
1 ̏U/ofp{r64bOb3b
  bbwb

ara!MpLa^/
0F`1.1y1 14Ca_pab)a15h1 126hc7 7apbpa1@bI	{Bb 4p5hvaG`%  v>@p44<`#;uhB3#63p`DpPF`h` ]TZ3_[
b!5#9_aK
N?;h `t`P5`x`fi
 f
p{tfkf .1tq9cbb:0Lb;&8b!bbD
i
p

ep
di%=gFd*GefDI#i$*0t
hAb21v R	] ^2a"Ua[7C250   _STA9a_ONe_q_A1 FF TPi1U#2-.+U
3


[3@4INI 'c_HIDA_UID |_PR0`50[Vt55MH1CU627}3[G_AL4 1PAL2	AL3C
7_AC02Bb}Q1VEW238PSVEP|SLQ{PR{1G#8!42wRAQf(r'w3CB3Dp@3Ep
p
$Y40SQP3F_TSP
dp C^q 2CRT0,TMPs[J11P.9A(1
p/AL:
,Ra.3q*0[MTZ4_
 =H
``ojojoj`j3`oj	`
dpo
d`wY`rbZ`̂EDtu25Bv72s7 HCz1D E1F 6061  2 z2A   6362
[} 4@(A`&w6526 hAV!66A7 81`U-yA
	Ч`n 5F@/6r$64aJaߒc
`rd
  b}y   baya
a0aRy5Ccq  eraye
	 evepeDc ucdcM
N69cpc bgC	bdp1e)ec5Ce ffg
fape`pfafgvdueA`boD` gTb 	`5D$b pg5agg7agub_dMBQpѸ`60p0_`c@"25E F` u`py2 ZEPD  F " Dh H?
bhhǐr Fcda
eE%-adft`f	ru'adSuc2wftd g Lr:`4b v6Cʀ,7Q&-B1AB`0 /
kBC062pibhbް1Dp6DDE
j0E*F"FF"FC270 w6
arC01Aabpb<10+b`~`babuaaP `bua /ڐHS71`1APHtш70\DR`"tP6C``p`Q9XD!

	          y p37p[uK 6K272mHH
F73F
RGпGP   }@    Гs3	0	  z1	[C27	.1A0F
rG G$ $ GN N 
P P Gc c Ge e g gt t   }  F@ vA-_w1BB


W) `q ^^.9F\_S0_QŔ 3    4R  5   H\_PTSІ8Chk3`N?] 0%EF0F&\_WAaK@q 43s5A PuxxxA@z)9xx6׮)u:A;\ @6
8006@̏Q
O4acbcc$#6a
:c	76
1>`2Q
  6[0ZA9 !2fC0B+C4.5N6n7
 AI\_GPEJ_L0 !W3
1
 ``D{{` p{b  {`
PaK QQ4eb0a+ӓa 0 a &BYI'E1 C	[{

69CB `]CC@Do5}
0D1+c
@ [" .IO	C	0E(DO	fO	1["
d%D  3/'4'I9 HOHO3*_3o6 S/o3B69C?;SD:E?=C_L17 84_?`}8@4E00
I9B
B:>7\xvAZ1]/*AU51D1@ 3 _1J<g5FT0{6p6
FS
E1F9C2[17`y 18@Xe1 QGq89
dDp` oO9B`NB1}77Mp9Crp 84,Ba11ddA%P"Dk84"[4!\k/a}F  ؟F~3YK!F pvB`G
'.`  	`
 z!`
qA[E+	 7P'7A319A!
#0
I9_'P'909090aa`} 	bc. t q'`{a 1~ccMQ[@B q,
[ Cp
a)?5
6Cw4b{b24N
a69dAw,r|0qȑC`_`	@Ap

c?Hc
5Q2
			vcv}bB{]SSDTqHP  HPQPpcMoSFT L4D@	o1  f   2  #_3_T	_ws 
_	O Ewj
ara
a5ajFP\80Q?FijQ080  AUhH2eGI3 281_282A1$ 41 JU^ yj30~RV4Ujow83
E`tPa@-bb`h a bub 6C22Dҷ!222зu223ҷE36q31y7x84,_
b+21 y U  V!5'*[ApPDC{h`~`PCT W86q 4	_PPC 0_/PSS 37uY{7NLP7n_EJ0D2אAQπQ _      	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n     ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ       	 ATIF_BM  vp (  0  n #.C % O O  !   n r	`v      = @/ `)`   ܀   
 ( 
@
`oo@)g`	&	Ϡ!
ϞA#ecA OOOi/
gh)Oc&Poof b%a& Dʠ7@3O,p:(/#..,/%4OI0`@7=a8">~i?2C
 `*C DjAj3OO OOOOOOOOOOOOO(&
' @ Jc  Ga^`[ `\A! )``OL!YybY)A+#:P @\΂ Qa.OK ,A_ &BZO
NA
bdT  (j`
gB
@Q`u#l!_!rooG soo ?\oo
Ayoof 
d/
o,Ho/ހi fb[ "bOW  }e d  @-a F k .5 @@O`@WP@@@AUASb`i"!hA iS"$CP è aV`akY$#a/k&$("Dtt`(y Ga  /OOOOO OOOOOOOOOOOj)~O L&AB2a"(!¡bAa ay@ Alay Cbw[
afv}B_`	DaBAza!1"eFbD & 
 `
? 1C ¤!
`@ bBḤ ""JC!a!bC)# FAA !MA ".H&a(+ -4`d03-'2b\2+9 ΀ԁ!Tr	@
p@-      t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@by   m   %  D` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VWσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7hc t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPh]BfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀h"$Pwh X[õ 3@Ĵ$<sAl r.ˠU訿rO!` OA (tD_rq XPנ"Q!ؿfnѣ!ES  gf /u
> up[PȰ&  cB`&Xq!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .}2[S[W>  t> _`W} v	0EAC r3_ۉ_`?2St]AM][QM_Ϡ &
`9P
PR<w. [SZrġzP `1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hΫ\bar1TaP<u< <up. .:.p .7c>`2p .>bs:P	d.e> e,@p ˀu 8r f΀g[ø0
.a.&b΋p1p.mΎ7X@E2@g.*f΀ v&.f&˸ Laap7*c5.PC{3`Α0b  ϊ* # PQW`
 _YXR.i
 Z k@@ZÆBB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.q}u#rp t
ArZwG ߊZYS2
dؿ0 PR7 r  dI r`.pr`@ d`QR	 .ߠp`qQ
t
Qh{EYnus33`8u" f;`Ph @F F@ &} tC t;k0Tta30h &<&E pظ@ P ^ X Wu-  apPfatQ@ ϰ YeQRW.. w#&.!
tff..A_0Y}u..nf/.ӱ cߏQ޹ޙR'@lۋ۩ۼmcЛЂ{?Qvd1>+ r.觳  cPPJ <t<t<
)SQVWێ-<t<wPXrs<v\.>Թ &_^Yy3	0		ԯQ @~Y!<8t	 `<PVtu=EIAc
<
t0FXAP QpRt @Qȵ$0<:|uFP ff PffXV	 Xio
Pj}^Vf3
f^  Z  f`
Qߜf
p  >"Orf0f3ftY "++x fa

E   ۽ 1C< tN< XÀ Ttu7A!Vu`U߬<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ o_!]SVW31rKt	s<<t<p; <w
t+,<Pu	& u`< r 
A`< u4 _P&OIVN ۩0QVSQWU3t!;wOQ
G:Yu
;t} tۋ]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fw7<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*򮿋HHH
uÊG O?ÀM=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Yj#)Y+PT P G WIN @BDF8U$<w%.JGu~0
t;wP
ߤȰ
 3]8QW C  1 [n6f.)ܑ0IQjY f.>)R[ 8svp $h 'Qv t7H485 26r SHz ueaJ2?  UuQK7e	$ <C EuAm"' ;l  Xcސ3PQfR1[3; Bf>@>Q mAPBCkD@ހQہR0SABC DpPOP R S c?[ QSWP).X.܀ uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)R+<[ ]Op^?pu18x f;tu/G2p _1kSfa u<] Pɰ݃f   `ſ4gB00t  t t !״rer cZfAA Uta	$`<`ut
*B5
u0
t		 u]
l. + ( k@
ݐr.ݰ

=ZE"R@rρ r}0M~dZrB BU
ǃa" rq"<0oP w  "
 B$<  wu֐S0p@ "8دt2Tu}NuF;J t> l@ u.Su;tյ "1
 " h۸a.'yuη ˟                              |x KJغII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ] 7HĴJ!R~:$ ̀u#@G@6J B3tB  DECBc@CЭZNBD r0`1	$
 D[_m rPf j qbA$<+`mb+
cJ$<u	f k rPpc\ Ḇ[ hΓ:I:  3  P O O 	   h=r@῀ gh^>rA6~BȎ؎zЍ\؋wh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                               F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu%	  	6r]dt 2
#
C2
EG2
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$fQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_P 4Jvb6Wl_=8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch i j b c ac_` a d    <    0F00	rvY	h
`a;@;Wff . ip
蕠 EϊfQff
f aVWIB,S@*(_W赢s;_t[s)`)FO[_^aW>f` f wsup7fffGofY܂ho S1Xfߊ$
)ff  A	S22+?Qr'~!% uf 8s֊ҊʠXQ<RP
_t0_r#YPY  uf auTf|UPfPfXZ+ ]f0*ff]rffm`f#n {= srscB
Cb誾_ 1?f^ ɉ߃w @tr;x }*f@Jkw  C)ѓu6ѪȢ+f;q%N?f fBsg  uV0^Íp.RfJyZRUQf fuffVfKr=XfuNVFYZu F1LMuY ^Y]Pg>!f0sRg'QSVfNVFfL~ {^[YrfqXftA3PXQM購} N Ow蛂PRA` X{PiWU豐Ԁ_PԀ̡ A1\е 謱 m]eXÀ-pߋ_P^Z`W f} mp_p0                                                                            ' +Gi@ + `ar(D
@ (nvArHvA. sNfօj@&t FN aR3V.PZr#MZu 6MPrfpt 2rX~	 u v thr&3&E0r" r2vRs ÆUu
FUF qô	 qvE	 ӥ/H	r@e.		p'^F&?s  s  &G&w&GP&OD
 &	G!R.Mf.u E	f0鉻GEEabgVfQSjf[G!fY^f& u#GWf  \2WXP'F#~r .u7 u/{r?`. t8.>u tu x 2SrV ʀs{`,P	p P~t$` t u/~ǉ~ %"N?V 1	s^Í6R.|uLu..P`>MP .:UtaPaPWQSMن?0.}u.:Mw#.;]	w.:uwPw.;w	@w0[Y_0? t>ـ?r.u|
Պ Ѐ ʋ.E;v 耰'fVf{v@dD @؊fA
@NP.eXfa ȋ}P	rs$
2

=	fX!9
/dD0f`v]f^PRB@    RPXuUW:>_]s*r  $<P0r!P@Xup>轝q @{<@`P  osXXty>c * BQ	F?Q	 QV  PRPW> P߸@   XFrr9r^rT:rOt :DvL*D f umfm3
u
rl
u2 VWrd ^_^ q QP&:Ev&wM!&*E9TaVBoCo0<@,rFAnr;A?@uQBu< r
tr&tptu
ZB\r rR$!Xt24 uu@uu`  uﴻ2&fPS `00mvPSpsq D
>X`?D<OƋ4a`t~ a1t!$!"条q1&0&PQȎؠRJr# SMwO "t 
`P2:Tt
 YXuOkuQ,9a"   <s& ? `P93  >R}u   P  PPVWi<ua<
uuuPx H<u>wuh2<t.$SQ\A[|u|
0g|`jt\_^F]~ }
u}	 .qcQ܀}u	a`@uDa؀$'QV 3۬+^YD &!hf!ff?ffJf0^1e
c[ %f F PX@OfP~$=r0&w)ІEwfu fqu`~Cu~qt05SV|t` t t
^[PfQ
  <  @ f	t` vyPaif`0ff k   fHff#f+ f;w߀fgК3g&Sg&c
uff+f뷾fa
f@6SRK=A>$
p|P0CfQ`rffX{ORpC{ZruAZr
`hPR2ǜq4XZ[].øJzOfUfQ`ufVK^OrM{u ogf@ N V FfYfPƃu(gfFfp#@MufY2f^0]Ë< 3R+@fVffLfTfDfLNf^[fYrXt	A3PAøMNøNp ONfSQfVfR
WfPNFxt0I  RfZN _f]^Yf[PfWN xtQKUPMXY fѵ kPQ  YXt
 t$wt ! v| n7N X(RfVχt Ph (
2VSQWf*w#t   r $r	 _Y[QWV wy^_YSQVE
Ê^Y[S (xޑ e   3 ШSf`1ffa 62fff;w	rf;w %!u`w.-x"  mu yf%~3L/aBRJ$0 ذ1J0?J= <rп _<3UUӀF
ffʝ fa= f-   fPSQRW >*L3&G;r_ZY!SQ Ѓ
<Ё J ? 1 t	z@PRQ f  ڷ f@  *  f@  f⚐4Z4f4f fSRfWg&>tq r 	r
  u f_Zr  U^f$f tt,$
g&"Fg&
FI*$
g&#Fg&FJ	;fZ#F	 [PU
`VvR	t#1
t.
wt9twtt&^
F&2
~	t
t11tFt`
t~g&`
 e@
p
 
u
t0g 	TA1qiA
3Rf\&^q\lUð4G3 G X q    SQuPpYW$@pXu=@ADTXe $'W7H I4
<RVS1.1Vtf S  rHchHpQ<V V<W U   T `	a9%f5P >- 1%f b%6=%_s >9%up2Hf%f2>b%f@w^^%zGfCb%dGoGfw^%b .f%>f% uG &R"qu59`a 廊؁D~ ag@ u
P_^Z22 C  _bV_Ͼ{E c>!1 Sr@" u@t z 3r%[`fR  rkѿ.'a]ã)) a |/  "٣)@ )w)&ؐ-
@?Wb - h$_ۯݻ Ͽ;v)(Ӹ;jmjݣ)v*>
8_a )gޗ

˽*qޑޛޥޯ[fW`3sAq<uf4o,u#8op ߎf3@f=SCAF`f_U< u
 	<! F ]W  迼<w&'V3ɊȈCF` ^P	  QRVV<v^.
t0" pcBp^`oU_  )]7@U)P Xv*s.V Ou0+]dndnA 
%%! ğ g dnhh뙡"i%]'8'D'f>is'dn)(%QJr2"S"HBs*`O= F@P["2ɵ"˲Yh .6*3  = sf`Atа@WP͊2Y[$
n \0F 
tN8tS@Fstд FIz@f t0`J.a=   "@KR   #x fXB~faRV s Zn!
J
8
{A0
$f4&Nff`4eA fu4fafFD fP2pa FP ^DP s_ fd
zfP3#"fF$rF(F,]F0` f3msrBrv,v0hfN,-a(X(@$иPN$ 0uf2N t
ffFDlf3fP f0ϠN xf:  #f#ff
0 VP@f+f;FLv FLfFPf)FL%	f@|v駎AfI oo !swf*Ͳff
QfN
X7f%	GPwsfA d!`
;Vt
fAQ
y6"8   f%"*qȉ6%	 "]f'F0002FR) !.13@; $`fffVsטPQRWSӶht" 
 [_SP 躁 QW ߀@ Pzd 
  5u
 @ @k8 W  ;PAݩ1r  F4;E@H0b߱@ 9߈>%S5  0Mt(BR'9ETDB1G10@ 0q i1 o10 1P  1a V2& |@ 2 2	 2' 2  3Q Q@ 3 3 @ 3
 3G 14G x4 4   V 	 X  Hewlett-Packard 68DTV Ver. F. 01/17/20[06Z `|J]  Z  ܏l ~q oKBC
sion XX.XX
 /
  _ ܺ	o~AP# pE @  AO 0OU Intel(R)  ׀ brnal L1 Cachea Հbi2e	
   6PC CARD-Slot 0  
  	 www.hp.com ABS 70/71 79 7A 7B 7C kw
    ]> 
3
 | DIMM #1o2#R
.~"Rda]sD "K V @~-No baty,"
0>  8$W6p_TP*u	 E 
yjp)Ӏut&  5& A)u&tĸ
u! À8W|@_ AU RtY vMuG	0bRu3uOQtru1 tWa0> S:u@8*6R:EFu ZE0 } ]QtTtt߀EtH7w1 F )t%> t:& tSuERWu3T ߖ t E>I q u	PXuP3 tX랓tS%y^E utut0#)	&2!}q |=p
 p*x3;r.Dv+W+Xu432#*u!.ð-s*1!	 2<Gr<Svƀ ,G.#]C%J u$
<.r!Lu24$`.2K#/rPA)<.t<+u
0 uN<- " uJ,0r& 
P56 ;6 %10Ü  0EAX= EBQ Cj D P@SI Q S CS= D@ E S I1xceptu4 - Overflow!5Bounds Check6@Invalid Opcode7 Device N`iAvailablJ8Aou` Fault9v Reserved	10TSS1SegmentPr n12JAt0 V
3GeneryProtecErrorq  1 =  System Ha!Px'
 tߊ
-XÜPRJ'߬< tZ fVfR68Fup8趿/vz9pcP99Yύ68{8tfÿ68j 68`fX/8T ō68J~`68A0Ǎ687XY_WQP68$}Q8Q8p8
686.:F
0]9ty9]&9x9na9膯WJ`9o@Yb	[Q G;$ 1`(0X[ڡS	 6 : pUf <Ͽ ~<0Г u< l<Pc<%Z<	p;Q<
 QH<~i?< Կ6<
ԕ-P= uX< <~<p XL]WfPCI 2u_fQfRVWfSt$fѻ"r  ttN紃 f[_^fZfYff r } fu
Nu`oT| `N s r 2fSRfPxȝfXZf[ff\hFIk5	*:f s"s t s t QVW&= & s fPf&EffX 蕺 _^YPw`;t
X2 *W 
_ ϰ#tX _^ZpNp sRQkуuf   fPfJrff P8s2fYZpu< uEuPPu uZ9@PPE EPP runtim?e BIOSpE1.1 S@j@t@@A.ASAxAAAAB!B1B=BIBLBOBBwU .@]?.` .`  r  R.`
ZpQRS PP<rt2[5$ԁ !Ȁ
  -" Z`5	$ .X p[	!	uR xuR\ SUU]UV	`&n״ ^CO TCWbf	չal *Z upl q U\ PSRP A<r
 j ?G0^r
t<t@").>B .B 
՘  PQR3uAB$ԡ 3ZYXHP~SIMPLOYMOTOROLAgVPtVS ~Ht4  ;s˻ʆ + >3y>3 3 3~3@3ySR &
 3-&Z[>3﷥3螢4 4& t
@ tE+ c3a@	4X~	4O`
4F

4=4߷4y؎&3&ߊM<S:Mt6B 6C 
6^VqsOS )o*64x>84֐ :4 <4Z>4v@[@4mx@ֿB4LD4CI8 I³DF4@	Kw>M O Qd٥wdd+ 
r)>14&~X^PS&"
`V&[X0QЌÜawŜY`a)uWt=XuP
f&e&ذf&e&20r m&|&za VR(txSR ڊZ[  Z[K  u?^Ƞt%kPF@a0
ud~FPjZ^`(u=Fu8qρB@e
@蹛p 2 g袛0UR5(u<xFu7GtG)b[tmڱ
lZ]PGbXU 
 _s ]`K:KxSQ3}ɰYЫM M>rQ4Ys\ PF' 3Z[x0"$`"<P3
ݸH FٸG G>S QL !QK yS
 pN pM $c'
(<Pd@ImIIIJ4JoJJP@ &` XW<r؋1 .H_Swt 
' t pr
2[e aDu0^r!<	rrߴ& Qs" r2.H2& r $[!
s  rp 9q	8 r 	&& rr	}ô`Ss+&' Ͽ@>' o_sa$`sQ
u>[ W r%p$S r rq	A9 f" $ ӀpQ@	Pm /X1#t s}A@tJNadt`bpt t
@u`YÜP`
 ̤Xr`QPPPtMXdYQPM0 tg	`DXd$!<!tMM_M  q&@tPGpB`+ (`<u
 @&   >!@tA AuqP @   , & XV߁  0`O  r
 P<Fu us	} 	uA
 fu	 X RtGTtu`6FtEuUrPRtK?xGr t& 0R] ZK&Duh; _ h 
Xuht=rX&  U au@ ϡ*t@Q!	 r=r
rfr dP dx $& 8t   0zQX uSQ^ `b+KH `*C: E8a01 P @g@X@3@*@KC*Y grahs\e&D
V &Dt [4g 
B :gr!0rbgsufF. uffI$frOgsJʊKZ Sffrgr
fr/a3fyoiZ2
 0
FFt N fF"߀ B@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sb߉FVFF"F
F)tɋ r4F$
Ft+ F P   !VPпXV@"WPR u	ZX_PRARZX    0 " p	- lFpoypOIEMAG  IZ P      	
  `# HDA-L  HDBs A-E r Cu 0USoB-FLr CD Hs LS Intnl  PCI-As B C  % eO  ֨ H	~P 	/` <M Q` c!QF	Q mQ ?zQCD001EL ITO SPECIFICATION S@SNS7S  A " * Gxx  x y 1 " *
x~"x 0   s w_X _y\[8y y  b éALT ËEtذE
U q r0 t
rÀÀxf`i2`tW &  d_&E3tB&U
&]@ &E`o t ûSvu0&E@ !fa*578F'()+3457V
t Àu v5u{Qq `
x_t^t]t\7u1tF5t3< v
<ar5<{s1$PɎT X0w#ôr2հѾorVasu\} "?9HS3q0w$Qu@t<az<zt,o ottt
w
@E2@?ޑ6z-q(Z	\2A)Pā  Tpt"< tr r	<zw2vPQs	} 5>	Eu Q @ pJB C V4WCWqWxWfVtVg],يv ttg}
3wgE
U uVs 3    SQ>tu5P=ô 襨% 蠨r!<3ɸ  3 3Y[fPfSRVy&}zظX耍tVt#P C>Z@}<t<tƝ< t 3^Zf[fXV $u P	
ir
- ZQRQ =@c
u׉wtv2gu
#p d0PfdfBd@!s dMd5 d	 J VZ0dP <d;]ttd|d]^  R 3
' ' F  F/KX3 .;v+GuBG
`F// {@ W% 	pXvNuQ
 	0ʕ NY%_'
r012P6789ABCDEFS ۻ'Y׆[U uPа_Xd]<t3 r
tVd4d8D^uPSQRWu'Es T^u_ZY[X`|3&
yt,ـt&M1&G&aMO`BՇLAAA$a+Íu 2<ytt
 ۊQ ܈$FKuðQ
u	ۍY;YpuS؀usu)4  A  @3fߊ$f
f BRWS22f0 WrX u 8s܊[_Z?fQWRfP
t)P0Cr ff  u 8ufXZ_fYPL r3r: st+ah4 v W
tl8t	
uY0	g&;t4g&Ct,g&Cf4P$<vfހ f٠
t
g&:#tfC1	fSfP_f޴r7fg&@	f`r!f`Gag&O@` Nb O q,f^f_f[@ 2p n Wl C  Ơ # DȰ=62Pð
'%,p"po$zø
 ߰	2s s	2  |0 	  {22 	Àn tN :4jc\
G$ 
N$03 B:$$2
+U\i\|\\\#]\]]2ZiZjZmZ @} "1U-QRG      *[%~	  @` `Gd d0",q  qa a|O 
p  Gr rrs sq]
s"  
~ 16r		 
%
 QrU f^%J.M(O!ރN#ób%fQdf%f>^uf 0 b f%>f% t&r_NVuIpR<Wff+ȰIQf׸@lY_rfǳơ7;^f`NA>1%uUf` sLoh%_
f6-ǁ^u,7 uh%tmrA>h` 
3XSWGPC@` u # $t$?a!sh@ & 0r 3uo.`p3r' $< uswL0QI<u	.` u<  H$\   tu@uu	V $
4 |`yS~Ы@ u7`< <wui[SUNNNO =Oط $#sc#jbbbvb  M= Gp." **<00qsr|7AbcU]p UРt"pAwyv]JRQt%vߊ̺ Y U a !0pZ@\cX  u(<sW .:c_.82ÇP'wXshQ.u..&+.	p @ t^Pt.&u @ u42..
t wWPUU*0*ľ&u XYC3њP A3.G 
XP *.r`WȎ_e#e,e7eFeYepee`d$!<!uy"p`& t"&& x<u&  V<t @K!D8t( 2o '2233.~df>"  t"   a2ۊ( Ҋp ) ǊȊ&)  * 븊[* >+#1 d>,;0.- &) r..PR ut;6`E6 6 3
t,=

"=
 
55w<t<u FÀ< ж s
& 
@<uaw\wWQu& ` u2`!AsPΑY6 FF;t2mg"g0ggSM3I"L fINvNM@P4J0a.R5J D2JEq3YJlG"I! I'I&I6$I+I d IuG@H 2G0G 
E
 tP"6PD_  [gu 3&s߸U I2PQ  
$&&EP&E
 E   FW˭K%>]>
~SQfVF! s^(2۹  F  +^D!8uKY[f^pWVQCuKE3 Ӹ!0w $I^:u:\!u Vr÷Y[_S@BiP.pU`z45@`頍 hEo{u `$
`&afaRМtp$tpg ;sZ@qÏ1q)z $mc #]s$SP( SQN<tt	fP P B ۰Y>wp+3jrYQu; rY<u,fCISGu%f» f f f .>2j .2jg/y($jS$`vVSVc_D
RE^ZQR'ky $p>ЦfaZafPS ~ ff.k6lO[f@;.kf`7,uh	 _ h  ,uhaúB   $/Ü.kuw@!RVRx 拔 tcPtt>@ KXSx$PlXr$,Qu!$
BB ,JJq4HX^`Ϝp$ q	 ~0@ 3Ҵ./@32nuo nbp'ûtuTf`0D fft;  Qf3#Y,65 !п y>U1!^ۋ^&t` $ueG&uFtt#]'  (p&мGK `3g9p@v.Br dt4t op ?2fUfPPfXZ+ f]ffŝf]rPm͸n跐  _SYSID_  n _UU  SWQ  8σtуY_`07- HP  
 r
R3p P3tZfl f@f=  uf3p fl P3Ҏx ȫXRFZU$PMM qm
                                                                                                                                                                                                                                                                     ~ 
܏    S    -%  ;n$$`fwyhAC  儃D
 uj@ t%v v t ArMv .EsN-f-&A F'N- aύ6MP  @ t	3!
tr ^	
F (|r
 	u^'Ât %1+	d1*51}5r0/5Mrr[o[
u< r<0s<"N@`  \

u' 
$nvf<0r
ݠsus>Q.u.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 r20ss6< s
	OtE""Lt*$Ot"#Ot%" 2q!)A
 ؀	.EF2	
r]wsms1I9  <$u2 *<#"< u<@v<%p!2 ÆUu
F!UF% &F~&=r&}vP8fRF'P^S^!S&EF'f&U&]rQ[P@ [fZsSQtP^Ë^6Q_GAؠrf;	DE"z~(LuTMs fPf}3fXr1>R1R.  .GTώP ./pPӪ3V#:Ttt<~'t9r0說QEE&0Rq<DD@ % 5v自$~6R 6u0fPfS&Mf.,Rf&]f&} 
[!
0'Qf謒  蘒r}0rxLtrl rdPtZ+ٿcr@ O u~ (um-VƎދo^@tffm_ruLr Yr)8r$cr蚑r"Va	)rj!PTPQX rpw
u `fSfRWBt:ـ?f.EfffofAUff?sP-EMF F
tSuNff3fifVRf.WP*f8f'w*f'F'*2t*܊f
VvfVv 4_fZFsQU n E]YRPXtUW:>8C_]s#ro  1!ZRPR92_B@ ǀ ZXQRюً ~go^ZYpB컊`SQRX0% [F mۧ `7h. ď\Q(&Q Z^N=rot
r`a r[v">Q fKfa`, 3S5<s-RO8L9
t" >QG<P#<Q$@ d_QZY[PQX hv   t`rzru3rij`wNurWu
p`dع{ 
 Lr.Ǵt%ttt t	tCHa% su~藎r	 2PRZF sH<t<)t<(u;ь>A u/WU>)`]_34r0Cyq`_^a'c`&PSR 2ϋZ[)ÉRFtNw+P X7D	F
+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFFf[fQ
tW 8vNC؈^~nNfnNfNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP8FfCF VvuKޠQfXr+tP@P3 Gp1 tff   Rf+IYÀL@uu$`Ύk20Rt
.v^G fF! PXG t<"u<"tlV3޾x 4|Q&?ws0  s& p  &G` ` G]`t&O &O`uRp`f&GQ`Pa  AMWQb b׃  Wsa,ZX<7RQVW:W qwtNᒀuÿu .!6a u/AŠ ?L	
 t,6pNoAOGA&&d&D&t&D3p;_^YXVQ
} " uRP0R
߰  ^O   @ tͰTPQٰRP  TW j w<
1BQRs귄3ɺj@[pl.
X `9.:afV`fQ
u 	r Nr"V s  ʰy6	pAaf^U쿃`@*2$ԉNT@׎Ǎ~WF$
&пFG &U_غ@
	 `迟aP[,غ*?3% p[`>W   t2_R Zطˀ$0Z4`  贮t
߻  A P 6af  T 쨀t DXø (12X4r$<q ؎ffTR
 b c9	&d Gp0ff#f' \(f 'f.4 tff                                   0ؾ +>d&۾ ߹ 36{>a Á.6d0GARRوFf3۰Sa"fV$
Ѐ
?tf`ٰT]"T|ٿٺ4%~@ff2ȹ WfVa  gxtgGff0XfVf    f  o><	gzRf#pf^f_@AWf 
bK C8BBaaa$at@0 T fFɷ͋N
~fE F Nu3 'ȷn ]
 RQP~XÊi/FFYNZ1o!l`QȴY`Њ  aÇً4"ԃ@پA & GT .&!ߐ'@'dQRP Z
  c Z 
G XYZð
< 
7   ׁ r  `؋  0ٿ 9p^  ͑`|!
۷ 	`
d9da@ ؀ `
UЋ؎ ]_ap]3< t
AF `P{ C0[l@q$9؋}` $<u 3dE  ?fa3ESڠ} a  VQ3AAY^` 
aËf3RQ3ɋf tf
@Of3fRAQ;v+R'TYX0GYÜPUfWf&и`1fW諗]舗f_ff_]XÊ$uguô  S3ێۻr?4 v WY f&E1_QԨuX A  D   e V EV HY  HYQ    U	 Y
 HY HY@1ABC  WP WQ HYR  XS HYTPXU XV WXWXYAUZ[\1]^_  g` ga gb Shc vhd!eqf ^^^]]T^v^'^=RfaQ
! Y~D 8  ` PRS%` +ð ;w[`
n SRW*׿OзIrp2 3_Q,ԴAs Y r3O:=3!RQWSP b	$< uX鿅 QqYfl !`FsX Jt	uRX( V_ m 7	XAP)[_YZÃU2<UuX
8
DYJBB7ǃ   brT
!u5P R2
X
u	  ت *ê`VWQP Dt!WQ:t
Tu8v
Y_#Y_XY_^ _SM_ P#_DMI_ 0  #9P  2XPUv F t	F !Ff ]X"X
W8 A1@"fi &g +  pa}
u
f_N@  ]ϰ2ðq  S\8&_&G pGGP    [ !@   栊W@@\&׍\p `F0 ]
..c3 и( Ys  2`U C@@ XWP<w3t u*p O $F& V _@P 
X2$30   _S_fQR۳4!jf@ufQ8fYg`6ZfY[<@3]Ou r 2fPS=Au@u;Áp u39 u+ f?wufP@u Xu
_ffp`< t``%!{At{N|S{_ k@Q  ~{{텑 oo{KǠ !qO I{P ({@c{Q   A){j{opQfRfW.8oumf3
f=SCAFtV1G t"ffff qWu_f(#3tfPfufX`B_32 p
` tODu (m$
K`,Wa5ô%+´+!7faPKМJt* u$t0$< ȋKf`a
%D	$߸ %` +$ߛfa0r<
%	*P' @TO xOy Uer$DIvsL QQ^|x  *S|eޣ.a UϦWP.}
u.:utL u% vt>JrSR.[t 0R.[u wt	xt_M_EfUv"v t Ar Mw Ŏ.V PXF
Xf]h@ &AQj@!
t~0 rt0n%`$h
	OV{Q}.6y# {.t.I.
Lj@s&  |0u [^SV#0f؁D.d.$д^[w	ã3j0rcOt` 	OtOtLtDQt
QtQtQy

{1xu	苋.<荋.}h $ B%VUu	U0pP`R#prp
fL\Z@^ ƹfP<r|wfD Wu
 dlHSQVWUP&Br{ eXQ,Q>y ..>{硽@,u Pa 3B &Gݾ0 $ $PC&I`(US*B> &g01&O2$ 2&GAX]_^ &?pa s  `b 
 }fffWE  Af@GC`
 3 WP޲ rsvE<u` UuvLuRE<sfQAM}3  fYr/>R1R.ǠًEώǿP./Q8[Ü_QWV.>vסu5pG<tFr=ֈ.EP .&0R>MP@UA%50t覈0qَɎٍ6R 󤰕^_YS0Nt5ێËfQfS.q&Gf.,Rq_fo&_ . pY2Z[fUfCTRS"f}]hfWgfǃ^#Eg ٠`ܺA vT2ҿgf頸gƃg u	f@w1  @f@f_gf1 gfgf0	arfQ@;gg&fG7;wf+f  f7gf 3ggfb	fP#f>fa
Wt@@P	3
y
ff0
gf3  P
@Cr@
A
@  gf3fSۓ̓ @QIf#b ffyZ?'wf3f30n,;wm#`~4ܼbf[gfM p2
ffP	c	
=
fAAXAP
Pͳ#W!0fكs À +SfVQp g46f?FCYQ  Y`Jf^\ g&GCffT[PfVfWQfR
/ШY_f^RWf;rf`Ȁ u0s'1 t-r(@tD<u u  $faUQ	U F @ E] < t~@M
<z ,uw`Y]p4@PQRbfv2`xu ^~tRZYXɓ	tr3`	x tt -  t	  i09`K#r=s  "~#@@%t18P,Nff3u
PL t  f3g (vfF!b"XtԳ$PPTff`U^Ɓs3&fPeQXYqjs)YaP'уЎ{ BsP!8 #	4sf<tZx#f$
sAsP`drfaQR3Ɇo `w ZYJB"<t$
tAJBqpvBa{{߲ݯ *{qݰ J NN@Pݜ+F]X `j . j Pv
@)Mf.N. 蹵tI4~r@5p3؊^)tuw t&Du .⭿^^;fa.@t&ڃã.^236t6^2.  @ PSFg'.:t	tX._[X`_g }i &  @
id@8a PSR,غ:3%  Zr-s(@r3H rr
 rRVvF\r:Gs5&DC H Prfڋy苡_FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u rcwu
	A	πϠt&D@B êĪǪ[AT`VcH Ur~p蟁Usʁ `-s8u fqt
]E$藀Eab&G )
V Nh8Kr>u rG Po3F) r\ {r=H r8{QWss #

Rr
3 @÷M1 |#km###F("r#謲Qlr@rk20!p ×!r"!F( Q'&d&K}0#V&Ơf)&t N.QSWfu/ r)v{!ufPs FfXtā_[Y`<t;f3f t	f %u
utǳЮf[`
 3pP  phf<	4PO   校F X @F$$<r$:u s
jwp_ _A$ 
   @`  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F u(@$3'E&f$`
ĢF f%R$PG ;B(FGq1 fF" PXۋN8NwN 4o2N0(`00s/ ml{B
 r
fQmru$贀f_Y_/̡+U+Ñ &u{%tzrpq? V/QB  BY^	G $s
3
P&u3`~ @
r
%utàt <q6(V&TЕup 
*&u^  ޻  QPXuN%&:Lr{ * r$ ڕP @uP<ut.@ ;& ;/ E q2s2p$<@t22P !$!$qXw [[ĺ".Pù[K<P  Z X "`Sw[PS3	x[
uw}wXwaSQRsɄ3ɺ蟶rQKZY[03tί  XefPAMSCVW  !   u
`S  	˻ʆݺqrrPvF0&_ O@V0&_OˁFUWn_]v߹
 ` ~_[w 1 uIp : MB RW@5
$0 D V0&=A0&FGvu1h!1p cu#' %2	2&1&
w;_b߅2f3ɐ tfu3]3&`3_ZGF  u2D4F sN~ t
Si[=Nu,uG&t

q]_PW! h fzf8hE0` yf{  j H  [$pz,Kf
}9fāZrMf[5f 0Kf% ;tf ff  ffX2Bݴ_ZsW%  d T q r7*膱4ffGf
f @
Rfx ffúf 5Z`yPXfZsc``_d ҕ@pm`
f<~f!QpRef%0
  |DpiB"_B< C@1$9!)׽܃f`fft^" QBY ffhfaQfRWf`ffӿ fRf3ffPbtf fZfOu_fWryLtpK1=gzicKQrQKL G B = 8 3 . ) $    භ< _Q&GYÀ'\ǹXQ1J؎EhH: _ 6Ew8Du+2@YO[  }6!1Q 2c txqf8220f9Du̮ 2 E! "
f6fAbgfF/P f$T cfqP gf&A*%P1 f3f}fuñxb)Ɇ { nffaPd fWfVf  uz芯s  3f^f_É uð Ü`Ż<0X   YaPRZXط$0<:rPBu}P P p $5r q& s7V: $fgfF PByZÜSt	tv
 vt[Ì1# Ѝ\؋hп3 pHWV1.d^_2׺`QrD.\SRްǊA-ϊZ[ 3o̱QRR ź_ZR  1:ok\R8A u
RNRp	 PXE%
cE%	X< z$ZT
B 
(#
t`0VWt_wZwU
uQ6rEt> r2
tC rͲ  r F 
p    !v^u2
u[rVei1sCr"trS ';Wr6"Q@
ErX S!;PS)Te  
 `  6бѱtK\	\p*P')0\;#$ rIW("  k_j!P7(B O55B< t%՟0@@r4;3/r!- ,-΀Bp˳c@D gȳwGҩQw*VR@ ރ| 拴  t.Z^8P .;BBBX$JJ2JBPܰ t
tJ ҊXu` Gr V tA&q JZ  C@A u*uP= ]Xruŀ̀2	`܃
 B (8SQ2<

2ۆ.
$2rqdP<w0
u@ð  `0     j3ɍ6P.Lu.:Ls&3h.Dh.Lhs` 2`r2[@Ϡ 2Pߡ qҳ K߃Ј^t
`3 t t
t
u! ĥ3ұ u U tA>R.| .0R u} P J}uL   u3puv`bW~_tURQRU02YZ6	u>^
 .D b+ t#VNgLJg^@9g.L:g ] Q3 | Ys. u&	 t	&Uu" ώǍ>P |  ö.f.|0@ t  f.|f߿PW\PQW 3ۍP#_YX,`Pp1( ʹ p;`3軣$ģǁ&?t+aÍ>`)}
t 	
t>MP_ .:UǀV tMR_Z| $p$u$$<t} t	^^ Q3!*Vh R| ^t
.֢uu
cs)t!tRڻ0W۵u3ێZ
t	'u
u
 u搉@s+XPt #ڰ`z-&t"Ĩ@t p
 ް  XPJSPc .+. s#. sXP&   &X[@Wt	C u>
rrw`Ua `_B a p 0`c SQoVf0ff ^U@  
P  ^Y[(PUFP   f&| ^	Nu<V_f
EoU 1:RpLP	r=^=ðuS@]#^[w饐u"
 ` ^~u.R UjW@wy`UVJcL1YBS8WE
u&* ` u!0SfQfV `  &=Ut<f MPThۛ~B&Ep` `&ufޠ>& w \Yf[0SUh &]S^ ][#&u`D0DV?& AL
^rްlfWދDV &` f`t@ 2fʃbك^0 ݤP P&t_ 'f=ۃ'+ai¡;ME 
+ Wf.pPPZg&G_E!#3ycrRuf&T
f.Q,f_uɾtf`@] ZStQY f0fLfp,  !f^+13# ,3;Q>!p$U
UEG &E_"rkfaÑ {'rnOGw|P_@10W` "Ў؎`1#;nwP @2K<t/fQ~XPY<pD% M
fu fpP` QY.v.M"fNg
Tw -"|"#:OOP9DQ:	: ; X;Q.:r(G)kuP)D > )uf.
p  - =]*VQ$$D
@V&T<^30Dory9
lY^C0 ~u0Ex0"VBqEv fS l(ADg(8PVPWSPWQNP
P@EA2LDra
fNtQؾS2KWM T;0@-fP: M^_1PGTN?:RffWfQ(QtT=M
Pe@UBLgALBRL3S G`^WX!WXX1GWiG@Ӄ(WLؕWWmHP&0P	3
uO` gdOp%Obboؾ:!aQ	TQb4`#SShS3Rq	)AUEfdCf`e_W3n `{Dku_qnhQhhRVhh/hmt؍`pjj|t= Yj,{A
1$pf[ jPQRG B㡀uZ փ־o& " Qׅ URfQ`vQ ufufQ2=fA<t1 `Q !ϱ n r.V sfYZ]ÐTf;fRff;fZz`Wf!тrfdrf+pzZ|ѧr
PWr#|s
u]a

<f GM	wrrڑBaPXPQr Pp$S's[OBMI:lE{/lўJOQP mfÐoXEt fat/+f`##fSfQf3< tf!Sq2]"ZfYpѦUat?$7 3#tcQ!f0
ð-@X!{ľ!WV@ fSP~WB QKY_W
t^9Plst6]V! <5u G	F^B^= `"s.
<5 = 
u]>r/ aϊXf[2P_X^2Y!WfVfAt
P EFr& PTFB γճ ô PNNXs7 #<#A $$$P)
u $ ð) p1U
  $
Ǌ O 诋$ $r[$s) k3+ \tA	=	SYPðoQ3r+3ð&{QtF!tt	*tEP萰QS&"
ǆː[ِ <t<!t
<P	<*}!`R~#
*@	`ZQRbs`-PZYpo<t}L<u# b S)B 8VP֎ލvS<û	 ^[rpX2wF^ ðU!< R)< u؃ tr
DAq. pnKP3P|
u|	 t0  $w<<qw<
q{^0Qq "N] ؊r% _#A#؋ w,*ZP[u AUXðbMQVWP 
Q`?X_^YaQsPZP2b@= bQB2ʁC!n@^
P'4#fp1_ðWr62	RPp6 ,S,ðTb-ժ YR:@Z:.T@V"'Ub<P*= 1316k3z FW߳߶߿VS3 .: u.PKu[^*FpD2@+SF p!S.	F[C3N[QF ?tsF#~KWY@ 7討 `  _ ÿ8艎 8d1}`dkmqmA`0O 3`A$ PQ$Pk&X Su3@uCf N   (C)Copyright Compaqr uter rporation 1982-2000-All s reserved.PPt'}_<u 2h= _ h:> R[1qpsvst% s
2  憚"  |  0h.Dt.D y~`߾` 30f&"aø0 м ` j   R3Կ{1@QPTPQ!XY`.\.T	ώǍ>P.L` `aMa.D`_MaQPМPXX6a@  -  tPRuaa@uXXZXp! . wPŻ P0.= srs
0PSPi{ _ ߸^ZY[XSQwt賉.﹉ ! !$ U9 AyPPjQb;ˁPQN`A K `2Z'  A G y   y?" ËEu t
$vur+v`tW  d_u    3Xú0fW%ﺻ,B.s 8 0ff#ffg&'f  @Y Y_ fRffZX`0yPC<t#<7tNPc  5T MTHE 5  BQl  
 aS  X#!Sw3xu@   	u1@#X/ y%+WV 1P׏ SaXX{#cX^_S/RS$	ppqu_W2>A H $tu;pʰ$Gr@   5WD	02ZiZjZmZA4	  " y 3p3y @02H%~17   6  G  "6,@;b ZQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 V|s_}|789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+Vs
 GHIKMOPQRSfiiFFj1kGGpGGSmNm,,  fV@@ ބug}}t u3N@f6 Vj}u^ ue}u9}@N`R\p Sh}tE }uw}^ u}t!H}v
C uD
]]f^U!U  	!     pV  G$ $  GN P P  Gh h"Gt1$    Z   
G   й$    0    %:br 4wwET]                                                                    S A  mh  O IYOO "vPtF X .	 f&q && "  иf3 ff._f.{]p >` 6a  !ŀ.wP Wf."""U"" !I a
#
{ 
 f3ۻgf+ fP s fX   QRfl f@f=  u0p fl >@  t@&? `%Tk| u!uO߿<2f]
 N] d 5dPQ3 27y4rdr
` r`fUtf r.]Þb Drr.f% ff UCESsffvr 3q؇ u1f!u%f#f 	sLr`t s` u `Ṱܹaaff#ffд f 
rffafSfRQ2f3Cr6
+f u g> tt ͸r(2 t YfZfi[=f%݋\ffR5I 1t?t
`.or2fZ  8~-t(r!f1 @t
J?葿t:R!4{? t0c4QfRB8t , tu
@u$2(HP)@t'@u''*tp(t
 /!-  t> fAu2BfYf[ a33q 
t@  t}fPpXri/p/B/RZ/rGU/Z3tt@dx$
Ê ix,Tx$t Pcx Z
fVQ! 0fF3Yf^0xx'x  菶Pw$w_x2pwww@Qw$
ww  2 )  SfPP4fXpG	ش ][ pfV~W   _ W
t<5t^uf3r̴fAr袵p5V3P'û  f FKt
` J8u^PQfVW萵fǩ 5Pw@^qfЎV*D@t0	_f^`Շ$PnP!  v  ~  P fPf @tfUfp SP4 T0
g]?rdd0# bX0P]ge333brVd4Ad^;sgu` 
3 Ybs M tAt<V\brdDg}
^` VWd_^gEdTg}b
a}gE `tr	 	t}d8tW<ytu@DWڦa
`PfUf]3
t `Fu Ó' d.;Gt -._
 ~A	fg6$+' +k_ }魟* UӞ.:f tdu.V.f]$PIR 0y A&^i j b c q` a `r     0ղ00srƴh
`3. W Dp
E_ͻ 
p aVWS;@t[ 
&P[_ OQoRW3`A>QEDuysGYQ:h #/$_Z!SQV.  3ۍ6.^YT`Pr
Xu!Pr<Xu @P苁tra`
 Po}@safB~~~~l|8 w8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~p Q pp		 0``0{qPff$Q\50xx00 0 lllll  l 0|x0f 8l8vv ``P0```0 @  f<<f0 0  || 0p0  x_8`̃ <l 8`p  xx@ |pH `a
 
|x  ff|ff ll bhxhb `f> @p x p
pflxlf bf  ΀ 8ll8y` xxpp$ x0  Px ƌ2 xp``x o xa"x -0Qx]|`` p ΀8l`0
s v~!`lvf{0 x  `b  R  !x vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
/ u%>!f SvN .]2[]Pb䠄t"
   ਗu$! ptq&k Xa TmhAE eMA9Y.nSS  Ad( p
`3Ҵu N <tDoQYR"or8ror
2:6 voZ aP P2XPCI01 ISA#+T DV03COMPAQꊙ 01/17/06  A     F10_  n؎h Ћ_h+3f  o L!$F10fPfSfQfRfVfWUfUCES>c  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdfff	 3ua 6pe< tf3
@d>Spe  d g>d;ff `foff3A3@!t
    2 1@b@Pa@f00tf pߨ tQEpYV ^ `]f_f^fZfYf[fXfVP3>f t
	RC 7su!&ffXf^PVW 3W __t
r
>d_^X \ޯ۾اбκܭ-.DD(|1 8     60  ``#8~ _"!AS9>9;  : ]@'Ya; n @<@?=@ 8&s@$	=A	I!!
0T!Ae>q

( )))**L{LHcF$$
G~B ~B
y$$$@ $
  >""ZFYdfd  #<r N` ~hxF"'yPGR<TS!2

	" g %8 0 p$X	

$$D81 [I 
!0e$   A4'((DD@%)P(&A +C!Rs[^̃ZbgAvijwt@CVXeւ\fBNۑݒ畜ĂHHo׎ߕύXIAOԃeLǗphdo@\Lu͍폜}JT|FؖcInI`Fڏ׌Os\gpjځBȉymGłrݏOKvxmȂ튮xtԍÃ_FsʌxƂ쐬݉}֎~HS\zԕzfmQ{Vvdǂь`YilWǉENԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb]{# - |@  S   0 ` R 	i D  Q @' 'TD ?g@dC" 
 P '1!!#"?& p㚔
~|u  0
Fq~% p? o  !  % )  f"	! ( 02 RES   `00m) BFLXp0t   dEg!<"F 8 mY.$`"08D(#d$A|   UP W F  >"6>px-@  ?~!BC ""!B'  /!B#b&2 //`   a &2$-aLX'>9p1@@@a!!: ' ( <'Bft,0<<` *0?`  ?<t2pC DBg ? @
Ձ0?0 H$@"@ 
	`0 P $&# DK8 o & `| D~D D<@ B f<,$$0$l=   M@ 3` B?"#!!  8@߀ `: 	4H 8	  6 a@)1ppp" `$!3p HBQ0@S` P0ZT@L@\D2"##(RUY@>B&Z" Nk=bN\@-A |a  %rm  2c Q " $!2a2SNa  1$Q$$aQyH ! {HHK~` x d $+Ph` @@` 0!ߘcc1 $2&f# ~`\0;@lxxpa1 
c
AZxpp!
g
  p!rE  >>@@`)X0$x|pTT T8cCQa- : b05 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{ijv+ dDs?||e0v0 a"s 6`S!cS,t. T8$9`0pGy 4g @ dt>$B<'_ @}""" c px% z`vdnIi&0WP?v3$fv$d
  ]@^@.*  #2Bb"6T$-`0|p(x3 OV@@`Z F0Vpq 0uat`m|sGXm|%o38"5U QHU' &@'a! 3?! @( !d(!3#\?2b" '?1`		
	`21"`n{9$i?$	$	`  >"33ak' l?HzM8<@0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!## <DEB`@].A^! nxK)t ?` 0!g t$ U\7 ga  9 "} ?8F `8R)C)E+D:<  = ~P<  b <$  '~  |D!  D| d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!}@ @Fq6pբ66@ƀy9@0ya؈ ¿ `%,#?% p $'!G@x pǌwc 1$&? l@ 2?$?$?b < @$<b =$! <`0b64~
w*  hH"e g * ~  <@ D=a<$" AL`5' 'p-恴pp^c  ) 
8qhRF pà2q2DRD" T@""z"> ""sbn0 CF`  ||~ ނIⰟE`<aBzd, %}IHT! G㡬aE@AjD0p 
 .:23V!&    _B`5I@  `2"R`   @4!  0`'>|Cd p5D ƃ( H H  0
DP6Oe  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c2`."b4'v?e 8+"@P,  b
WBF0L 02?$&""  0p	{ x 	#`4 c$}R S SPpP t!
(#?@@DDD@"D0!sc 7E u0DL|(0<t ` O='4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Rydws7  H 4?b2C"cyH@CQnx<0	`Z ΀7( (`2)v&^?0JbW8l>/&23
b21#n0  !߄$ #L`,!3p$?Aq%$"h| "  1 o A  }    & <"rV&#0 I  81? c QQR?0S"PC 8`A a ˀ4 usn# 8 ٳBY 
 Pw]IY   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>ǒx)jP|D52D"DvDTDD?6 # a|ḅ,w  1p#\  7ajė=  4a8	 ? 6 P>Tڅ  ptL D@~@Bf$,892k&arg@eP< 1 WpxPX	 ^x! 3"&,0@JD% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"gpa&b F ł(x 9%`'6U0` |. `094H~ ַ 	 d~@*H  ~ƟK6cNCc48x F?~!BC  #" e `QP060o!  8!` "***" /"$'$&*"$"? CJ?0``]0?~$BdB  a B
BB~15,"&D$(-jyB ,!.8	,HO
 =I H<H$H$I$=5@ @v 4R$ze bUS R P|7 8y0 ;6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z~  $D$= *XGJA\! /2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H"	TTWD? ?^ pw 0,0  ""bp $ & "  q?2@G
i-_ nF :@e$ a  @
#]](00]V?$P?			?R" N8S8
s
 ek| 0@	! y 	 	 ! o>_""	& ">fCv,`D= D~ = y , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDT Cv
$g>?  '$!$34?, g A#A <8`hO `&#f!b6@2~Z*\*jI0/ Bn5	G x RRptF H0	  N  	  a |l$# '!b[aa^ap 2zasR0A: <  B F>lxPXHL0F`Cu@;0}` 200b64~
**hH$lH UIHUH~HHQHU~{HA6  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs"B`7 `C  `rL(  fMQp" ">a}>>b 2 "&"cb@	"00P G  A` xoz    Vj_@` <1p0?3?S"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(0evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)g$ -PQ@ 2!;VR!q # ~ j   "?**~*B  h b~B$fiBFD?0@ @`@.ADY`M`~  I2R2RR 0Bb.	4d0.t }""p bB o?~b
(LA%LɧgUE``AC}}8@Tl@l$5?b5d >qcQ"tmdax{R4䣄	(	)	) ( )H	p ^c 5] 1 axA#?~"! "2&4?60ba0`"` @"{$D1 X8@ @0 P` !bF! °?(HD>!"? |?" p?#.a ee   	 `p13"fd Bi|"@Acp>@$	,	(	88(?2l"FfÅV@@9`'$pzBp03
D(z
[
@ 
{t~<$4 7 a  p }#@B"4&0PPP``? ) )?)  ?2"/y1cI{P?pP	|?@   t   uUp cu`  `	 `0 ..1S.1mp 1  [<u.1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.1` a2P 膅SP!bRV^Zu
`R\ts 2ƃǡ G׿
a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F¹. u 2 󥪪4.>1u_ . 2 13 `.1&1 u2CQ2P Y*2Ȱ&P a RDr
.1.1PSR  && Z[X ` Op@p
oo.61FʑF!.WtOBT_G-p
QR.61ʊƳP ZY[X  "2价S2OsP2 sP
XÃ <r<0 <rp1@1  1.&@GDu'F!13!a01.>1P20X2$CFAPQR]W ((_ZYX. 2.9 t.1BA	#+D<u<RaNw<P<S߰<0{<<<<<`< T<@<.>1 t3ػ@ .1G.11O#0.1.1pǣ`X@Y 0..1.10;Pp2  X:XUFN
ȋNu	F] S f{
 [ SVF
u038ȿ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M
> tj6hjF_Xd&  hE莪s>VRIW82o1Xd% = ۘzb	Gg	 v	A]G@UV?#
Y,
#&Yd% $2>Yd 	VyJ!fnbfffO
NJdLdm)f>d1jut$[Q`		JdR		A	
RaUf	gb	D@UxP
E
E/C
5eHx
2+-}SF _"UQJdیB B00RRgPfRUiS4J\4I"	~T}"(2y$B
z&&Q<x6({F*!h ^R9Md*,1Zd t<jU9BZ=^9@1cjQd$w$ 1fh  nG! tBt>dt	fh jnd$߱2b
dtfhaLbMQ >tSft3 tE>e tjhefjhI>@:%j whdP1t2>jf tjffhQ1>ng t+6ng *$Qf3f
ˍ~f PFPh% ]hg" !_Qh!3F``H`3=#2hLeSh Leod V0n5&	hf OƀBCF3ThŁ
Th	xA ,dqMdBBhbFPӷ7@ sj}h!Z
	`#fWhf\4YI<5
#h
dΰnW
d
OY0| 1%hc3!{4 VDE*hnh?"O	TPWD	qr	(^_ 2FFg^ F&<
uI) u&*_&8gtFFP9 1FOuÀыٹ F FIuF*1 F*+҉FVg+;u;uàg% ;Fu	;V@ágG2@A99g% 
ÐL*	
n WP
@Ffj hSCe(~-{ f wf0g0!h &nb&ZdjLfP1Z~P[j`PqD1j FP x`O@FG*"aPHqV=ut_ V!  )#GF|濃 02N|[a h &` F OGP	?	FNuFG0?7 

xWOw,HF/ A)wF2 1p ayZ2{u>_a	UIBbf?%
U22%#R	~a	Ce	$
`
1Y+do!d

WZdqGBϚW &]bx#@92[Ftu14FZZB && !ZCd0` a
Z"`R	ob% +1nb1pbj_R3p%JJnJd1 jAQ` 	ay U
`h~Ќ3""djDR
8K EE
MC @	H	NP!,g}3Lg1 ji"){XT*_jSN
W
 U.@X_dj~a4%&ddr
x
xѽ(t1f"q_Ft@^#QuylQ)@z@qp'8{#BB*3 &d_KdjTα:@(:d@w_&@Xd 8 f&X_dAO<_& &O ng dv l 0RUW gBPL
nb fd@w ﷡d t}JBVLP>]@_@pb*!!p0^@PFg^F  ^F&F~
ry$1e?&e &f &De^p0h @ Ng.@ d_e@  njf# r2
/ցRӂ@U`E  p  V6^aF@t,t_De Z -tT-uN&ee f .9ʀt0"Pkt ߃iQ! $
U+%U@@6U
		! t:}8O
DeuUeԡ+ 2@_&dΑ pe!gd !r΀&dc''ontD@9".Fȑ0   &dw~.j !`j 	S'vB +#rFsV
-_B&g(&g &g{5& +&{C!&}.&Ƈgd r`,fhJm0:q{MB>Nd{~K@>f&f!FVDA@ThafLe	s$ca` 
r'vQ3֐)؝u1f ~fFJ@t)`j$	Djg%Z	 f$ < u @<@/""raɸ Y1 ky>b'0U94144]L(v][f!fǐ0 #0
3t%rC`F^Nr-~#tp St  u^    % FW Pډ^`  ~u +ËFVVF7Ƃ 7~ r~t` t uF݈䍆0fv
Q1V׶,Iu~quSI@^0^[t
Ӂ
 ^^ApaM~  f# FB F~P|v^ K}0F NFFV~ 0OHt@HtcH P )on- h0p$6^F&? uq/cv萶8>"e|nh(dΐ3bcVA<4޿cvfcn`
NNF`-V膑@%F!9gF꿉FPjRg_S^ /GFPv4FgFnP@edbP;!bed9!Zd_&@ 116`b`~2|FtFr(QWw^
4~4	b-2 _`-n+FV_FQC94%~ t;F4F0
z u WV~vNO^p??S
A0@
^_C
"j(c
l

[t ,md(|WV?vԋNsO4DpRHAA~(|W~FIt_~w@u"2F#}HFB^F&W} T
 
.rAU!u@## KWDiaL
%%		 	FW*Pg	}`	
g<d-UWVv}<~P F
&GFq&'$i*V~ʋv!^PFGIub: ^&^&8t #^^}۲h!#ù
 0GF N% }p,-Ar  ~s԰ NFN+;u0g03F tAFC&PfSpfF ~0gЋߥsG^AaQFp ~
vЂ@xa|0r
CVV,GV~^&F]Ia&a81Fr~Q2Xd%0X*>ҾBIebf?rHQO2&Y%#2,
= 	Ce	$rQ
Z59BZZo@FGR̪* ]"΍@_pO@`BPP
ob% HB0JAJd1LdjAB
` 	aBTr (T53djD	AK*@E2*	C
u@	HU*
N5&
S
j	 UU@g3L1 jiQA#Tbi~bUyzUzZ	Q`x:`(#0
7
{2
#26h BR5*S W&dKd2fA0f   Lef	 f  Th dn؃@2-p򱦢 !Bc
dFr	#d0:(CyI V,@z	FR#sݨpS3ºBZ3O~QxqV .Lpς@>j6h&`PjFXd Meu>uIc?Y#Xd 2PW 62$>Yd 	uW
9Z>oXd,X2G %]^@Ӓ`fnbf	ff_؃_fJdPXX2A@YѧA \da$BGC
DĪx,E$
C4
?
QpJ$H_rRNbUaJdVB j)xSpF "4Pb	gPL5ip/"~0PQOߠMd*Lp997Fpر Cjh!TBQWVvҋދ~ &F<t<
brTF*;rb}7Ay_~tF&8toFu|t<r2$VP^ƨu	A(|Ð׿ ~Pfh#   PF;rF f{?* F  F*N*ȁ vFoP0y"vO
u+g^F  FOuE	fg &gvp tlgq0  R &g{22`% u"g$< 2g%g1gu8q= +ɉN3g33 Љ  aug$<u~g% bPu&
u]f2 % D0	u 
uyB
 )g
u/Au#a}g%FOR ggg gg		g
gg
g
ggggggX!Mζ f3 f rѨ9_ujvRPjp- _F  vB F¿~2|߸1~pƿF  p ~ uFLen
 f jtWV _FRvzF@ b*J*p
NvQϋWVm1vFFP
|Fطf-ݾ7h i,
'?F܊f  ҐF֊ft@ t؉FjRvv}qh 0-~St` s}uP0M2muFhMh @=Sh߀ FފfP;~xFf Kju1{:=F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌvoƹڀ^؊GFAސBƯ Z Bsư FN@F;wu0&#{ дi '@Oj! a7aPj?+*`
- e)@00 _NVZp|\\\<\2d$0   Z vm2$j)f@ 
C@eQ@g׌Ўvf`ՑU ։w)a"*- t*-} t-94 !13q$R,Fa2|LOCOboj!LF m0#"7lg
1(  GEt9/ 3|
/@+F+PR1w6\d eqa"$ 2Z11dgب knbnb1jLFPvϔj)"#12#"#AD/]LDE WV3_ W^&@RFG|P385 2 R& F%WbA`O r7<"JW>d BFetbArb6  &=  t@M[_ Ft   
"g#-//


	
A@yu	( MpĴ &&TVP{S~ t'jPFI  t/ u#''jfyqPt= tA:? >u
e&f"e2f% @f  t&e`1`ul À&l )gd(gffhf0[fZf+fgKe0b bbƯdͪ*WKe>uq[h hJP~h Zup:zr@juBzh^[NAZ4R 	'"			

 
聏		$ 	̢	r	IB		b_F&? t5(u%&|Rup )u&DPƋV@0FF"{cӐfj0!o 
 ! ` w 	     Eq~  A u ˀ&Jd F B>c )tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  -^P Q ퟓ  8>ۋ  &9w&EU 6`  VV 6Eˠ   9~o H  1;p!/ 
f
w>~ KĀv&@u?PM`^; v_Ĵ 3fjth  <Њp _  "g pvV>ͽB   vV*rF^ ɀCP% 
Pp h
} h  RaNF
+F@0F!vvo 	F_NF@ hbj a^0CFPNQ=`'*Pđ`VW  p 3_^es #_ @SᄊF>a
FB@F.
}%
;F|!% F@P!]!Vvܑm`NP`rFDt&"@A0#FlAQ@Pu< [t (F7 PgF@5u
 f `(* yBఊub~v*VAƐ2x*} ufU  Vn֠'] ᚃ> t`ur3NFّ\ ]NZ&8tG[ vNً! ؉^GF
&Ft^ G +tp
뎐V^% = @ʃ@Ao3t`߰ߋ@!A;wⰀ>
 u31&A *;t{or1A 
*FD0F
tҕ t" `fp0;
V=O`2ΠB@?Vu	.SEjHDa!E'(E zroVu`5~ 3
l	#5d7RP3>>Q XZ~38tC8 u31~^
AF:G
uɋN3~(~ u j  F;|;pUD  fUVNVv<%tF` u DD^ù
0NÈ~ u0+b1WQPWVFX3^tQ}rJ;v~ F^F&uKF$=W\qQb]R}  P+΋э8sdvva!V0N&8 uN = tp&@* 60At߱_mf6 !
`f+I%Q@kq6CTNi
ʐ kj ##v^_j&F3v~Bv0ܪQ&ğ 0b;~ANuǋv 0dF˺A  
~`fP0V c[PQ  F> ~ ~
~h3s P{W t4gPǰvKePq 	ptGW5o"p fhPj9Fu
q_sPK0 vv؁#5+PFoV 0䰎0NvD"F9F}+F- P:@!b' ɒIqhFF=`+%ZU"+ nT\QPEP)DPAAjEP:! fh p39> ~jy/0 *9_>u	A
@0
A/\&76%'@2)
o
G;|2*& P c`8(Fz0
A
j Q蜗j V@VRP=AQdTa2P? rp<n@]c E +FWFVa2#
0UcSQpb)5jaDP߾dQ虡(`7Q	5Q`,+Fϙ+Ѡ`MO*2 R 3Rg@=PD$=ӁF3@**A;}RvsN`V6rqTyg*@F;ﶋvwP)T4C
sR14+

uK#aQCPedDp&A84	PeV輡VP~&-24hxQRptYAS;}`=y#DȰdf&D&T030`~
P  q &Fި@u[] ᐡFtdF;u@Ɛ]q<ЁN b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~ $	;FfF	_F	} t~0{Vg~|PtOC tG\'F
t/*y F T9F}\LF? ;F~AZM
~~2G+F50%&L
q DF_F 0  Ϡf@`	PXhf@PF^^EAgT`X2s|rPxb<FA@ŀ[0H{&v7QvFvFՍ\Pɒ #R@~U 3'tsF+FJFHfh iyR( tTYT4v^ .9~ݒ4a+FPO6,/+F!}=ptu.tpS9q &OC@ +σQ._+ǀC
0|ctj[|tQu

FB.=^Q j]> LnW0L# ' OCA& !!pa2#$QBC}PPCf*gpL@>*g,gj qWw 
Ht8-t-9t- 	t "fޢ 	`!QF~ tfFf*gF  F
Pj   v
u}Ӌ1Aj MPHPV`
Ϲ!&wc¯F/tB$P=
Qи>N	VV2ٓF
t\!@D% QD
莡QӼ
VQ6 B tDu遌Ǡ
!_o؋!bG C `DPk*. H!MbB되9>u	 rdP{`GgJ	R4O1miDu(+Huu @uqt j	j_fh	xm	"	PVt^FPqf~
 t
ߧ
>axQEPzUE@ ]FY m DVVjvv{xX 6G ]F3?PS002Pr~CwF@UP1qE~
JG jR[807+$ }/p  9z]tك ##/E=/`J/FFP9 \ dpg
p; ;NNNQP @~C7 Ƒ򠽋= K = ;  -Pp---xАWp'Fj  ܩk 7>g`{ Pi;v1!;vFPVW>FP~FPG;~~P1% - D- *-ࠁ#- " e= Pk'-
|5. G@_6- ;sFc?atU tP` cFa~9Fu
VVIVF]v?9vu@PNPN  PNNRF ~9~};V 9vu< uN0빋v T` 3&P Ppߎ x& !/VN;
u逐xA^F;~maXS `
$~Du6g b;|qT/QN;v}O;6VQ9~ uFApL怰9v|G'I0Đ0%9F| ׉~A^&+^& 'プF'302F u!ihj@vVt ;tt D@gx3|f4Whyl
 rz/~I>FWV  Gc f td@ @ l tvf
|tUATD\n[u0Y;F~ ZpӁrջN@uOp]0
DKU=Np>Le u)>f tl>Th tt >d t|d yhRՍb?0 Whip.u"jhbh_ݠ
j(hfh` 2`  \`h
dhn`chx`^ `} ό`m#_6a%`aBz"	2 f%\ fs%n^ 
dc%	x cS%
 dC% c3#+(`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhНp߶t1rtI߀DODpU*䊇>AvuA*HWvAPVt0<@p& }5*5446524I5r6597h0@mE@ jpPVCpWVh
	 !V3j hD	~^DXր`HtHt#h !    C wt^ f	{$F HtHtHgHt$" @ $Ѻ&&G<P jh	G+P舐X}
G>7x@n _^a׉GP0v&ƀ ~RrjV6 fP)3P Ы>~X F`~|ְ"®s}vI@x	&8 trƾ
9GPu   >p~q9	uarf   ^f~ t  |֊Fþ!	eM	<L0#	Kac 	=3$Ť0(`(?h	pa^p3&~/tC&  v&8 u*C;^|ckFp^P9Pg`^? tvN~}"v`<1
޿~ u0gDFG&9 u7~WRrm0~F Z= ?-
 -ׄ Ү<5 1 ;uJ< tCBtZPU-
tKŐtHtL- t<17@t0- tOAJ_j*Q`
0 R~D@F	 0 % t"} uNj pG貁F  Bܲ u
gށMN3~*^
7ފ 8&8u	F;|Bdn
eP $
Pڋq PPC 
Cc!
d$~  *8fudg"^u Q/	tP3`0F |n FPf@
t)f3fn @Hpf}h 륐j h}`z` 4z$u @3l3 1K`F*A;Ht5= t	d@ &d鵫 ڑ.dQu鉀&
:	@
ʠ
 &
&
hhN
h ?AA7B 
@
@ -*

@5q&
 3/F! "&d&d fif!B"  `FP~H| AKN
3a$\'"%D:GBHF`^ Zڨ č&Í,3F
^46 x$dhdj(j 9
P8
PPfsV
bW&*`)@&` ڀ d t&<
 w<)뀖䀝 x
苵Q %'@q`
豑! Orhpej  %cbN0ff3	`%  Piр`RB/
?
~$*H0/$&40/04RjTR"`RVFdsp%TW
$
aH*=	- I- 9t7-
 wqrMt%
- Ktq-MtΠr` MYnp= d.ƜҜ$2o,2@0`  8?&`0W'R!"Ր,20`  0PXu/1V hNh ST T 9YۂY݂Yހw
Y&"0Z^d a=	_[Q["
@4 {|
U!@ `d`da0y y Vfh0/h y Pc@t&
 
@ ACCC΁!#!
@d`d`
Ɛ޾
r( + (#+-+{tp*tcmKt
- tu] &3& tGђv 1vh
h?
h P!wu
j8%AW&A
-hC@#'$'
a'a{Ðj{؁ ڰ @&
ۿ(3bPf 
0>{+>>G>do'>n!>]/>f'>< >Ћ5P$pD D:>E489JR4"" :L%9
5Bδ.hh V2^Du+! 5 31;ƻut>&`S7髗A"6@A@ctR_!P!_!
@>`O? 6`L.ࡠAL 2``~S<!Q"Q Q*|3ɻn &ArhOE@QG[ps<zXrQU]UtD3,i
; Y~K`m&rFv!
oroVv0^%@tx$tP!D$Q$`
P#wBf~уx0%YAlK=.D=H=yM;}Ա;
fhZ/ " [BGb %^
t
]
ct,ǰW*@t>tq *``(@a@1)@4mAEƏmƏCQ M M# ғ,Tо╱$ $ ǆ* 0p %@@$R~2j2`&_ 	h$R>'
2FD
	rRi%Tp`p
`6&~PA~sP󜴀?A dzi
MlXF&  &¦Ц$2HZrѧ"L"#1p c Ap"!b!a2 К`@y` ` 1a@]b눋` 2o 1 lf]b=}1`0!@c{!() `f`fXd&W0  
Ffh  y h#谨{*s\Su(u$fXdf`.@&Ydt?$&6ճEYdt&.Ӏ6J% B> a>U@DFdFaEmNN Zd֗&VVCG^D^!Ivv u
~ஆ 
u3um*	u!$	uTuXd`uPfѣ  ,VrkrhIPvɋFHFPVhP?ݰ[v
WViܸёalHtHtAt-L a@3+ !O!!M3rL
'K;8pRfas7ߓSq$'T@G@%D`\E&dQ'`IeQGQ
dF
g B`,~B.+fF@ ؀  Ffa^F} F FFFF}&`FFD>==   - -tR{> A-A -*t:- {=+-ی  -1t}x$Ht/Ht:#HAC 6 Ƣ ( !"!13 _bO}" A(A
Fy
t)j pePdPfsVFt|9p;@@a6虓 @caIH	p 
*HFM~* f  fFưvfvvFPv4Fu63F`. ~%va :uFG;F :<~ t
&  zP ~@&U!  !qq t׃&AÃ@ ی?"H_t)3Ã?@  BҋbbCا&h qwⰭf_>a uØuH_j 
 3{v0 Rf aff af Wfa & F 9FhD R
 afA3ق8-9t- 	to s`
  *hfjj a
k 5	71	u.#JN
uh 6Ɛ>a tuOÁuP	2-NR詠>& `6
Mh4520hRB6{3aa& & б F |b rа/ScA >fp#u>}p\t&e~l6aP^ 
hbte3_a13^
>*u	>F µ0!jj23t;:Q3Be'kYJ t'>{80w:2R%4;44j@pr
x zP@3A!F!Z@[$
$$*tS?=<=5
5
pKx@a	 ABa	 	 f{h+rD+-qp&p$%#;$ %/0aeaadafPeq ) d= $Mmjfng1 *NB Rb
b
.c
N֣ }g
 h
0 
"
 yGw@ء Dt,-
t%-.t,-	 tE-
tYt- t/PC Dӣa:B~} y_p}}J  oU&WVfteu& r ftu
P0tfUU@U U -@utՑP;>}`  Pr%h#PpjtXя6 ]HtHt `t' Q h6ou
^_ `WV3ɀ> N3һ BrZA@FwPWo~v ߋN~pDt { & }Q FV^tF
&ud,
,,,,,, v,,.袷>uh hnh_ h P jh
"
@t 3҉
65YP@;@)}F
r݋F 
hT͢	
J追
Z豰 5#W<B6f
 ~Ĳfg v3ɉNv~FV
tut9v~O|܉~*Pӿfa^?3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3Vs~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|bpfafff&hm  
at&
S
 WPZ0*t	0t0pq` ^3

tF^&F!u	 z|03$NF%@
EP2̀n{GWnr\F*+}= 0=a -tX-  - 9B m= M - t!Eh-@  OE= E.4N\?l/ /  p- 2&a% +11a_ @ 3 ֐j5B jh
@}E
 C
@
@
/ /  (YP)@ wj}Q'3
^'ۿG`hg5厀GS.nbAXag,nbfanb$ a
0&
c
Q 
@DM
F@f 
fh0V"z !B
p.pfh,-`*+() &'h%0blrd t0
Md Ǌfu
O0  O hE! `F<tF$hl"B by_F ۄ-FC|FàaGVA
aiaa!J1PF&J"`lLˤHJ f`OeO KDwRwB
MHT6PM
#ĊU90S'BE

H
>UYӡF \*X*_	uvt
RL2C `XT
2.TBe8T
2QphhdB c[jjUR"%lUb$&5n$Ur&6Ep4(iB#&-  ߁ 30) +1T{aP*etQT
b'//y Ab,bfcfLbfbf-
^- "f
- Kt Zd0gpiee_Bee8c[\,<Lf~Ôª ;,2pd z ab A^B  !"  ?- 2& kKd^t d@TĀDl c-@h)]#̉uIC 늩@s}# Z+zK1x 
x wdx0CXÞA`jOF_BAa ң"TJdEfJdfpd]@ta a` h&C*ADPUЄD؄t &hF跨ώ&? t
׀&@O@# 
  UB	@DCU
@Jd:Qy@t&fh~{д"d@~fhha
76Ob7tfh<":;h9
P !0 r
12A?@h>
tPp	DэC"ohq80WVf$ < u2@pAa@<@u:e32@ut[;> `  Br< hh<1P66a+ ͅu5] Dt,-
t%-.t,-	 tE-
tY- HtA- t/ZC Da: ~sw3 	}p  ca֠B;2%@(^DF  c` = 0Ht
`q j  r jo`¾N@uf4
;F~ ԃrN?@uOphhg@taqWV@NW 
r?vŰqDet
Q &6BG6@GDet &.dph8$M/(a.K#N&&PG&-@d%&f% o%d%>rhh8f% 'Fs"a_& *aPeA u$JT7 h`thRT9  t~@ z` p lP\Q j`,azp0u.&z ΂j`&n"qFz0#000000"00!&"lVfvfhI
 讆JRu `nh߫ |cF d:tF&<:u-FF
*0N&$  
ue3`q`C7 ~ uF	 F
 @L
 
 <  C
v`

A
jq<d^Pԡ4
? u0
~ @~ tghv&~ tDC O==u5 蒅`\
`
 ^3 FPPPFF9Fr= R@% -
 0v v sd ƨu@= wѪ
̐<bnz̞̪̆̒̋~FP.aΠc. y ~ t 4FPba    R F  : {.E "  e
Q p~dzt'/ 6ƂOFZ&IZ#3^ \dAhVD.t}Cq u^ GCauK  K .g"OQ
WI Nr@~u_ W    I @FRB	FV!F^ =uFv2MN'22g+@]WV6衪KhNhuy*y vysy}tyH4H-H4HSށH.PgHQy72{I.FI9Az"ClIDzߡza
ʮzj &z<f+fF@ ={  ^~yFV^KFP6b> Mv3+Q OY v l`- t$ fFf~ sA,Guh袶ܠvdPfQVȡbڙRPSQfXfYf3fffPfvY`fF fh  bUݵ 1g Fv?h 贜FQP^md Pqw*T%!T]aypE  p 4  V6ErNq0	% 6,bD6 g\ 6f|<`yk
]aß3Ð@2  MHz` KBPSIMPLO  MOTOROLA  HP  1.1Cdrivelock   B Computer Setup  <F1=Help> File`ystem Information  Display siSave to floppyco?nfigur diskette Restor?e fromE(defaults.
  Ign2hanges and exit EP  s! witho}uaving
o Securit@Administ or passwor:05Cte a/"Power-OnWGp DevicedeDgbD$L $s mart Card%G
supportE?mbedde&Lf
taA!e6'etr*ac',p(s$`*aut?henticS+e
credal Auto2cH%Tools Ba /0Calib( @(`'lectb HDD:lf-T2 op8s Activ O wMem
Chep?e r s: ll
=mb 	>>uA@Advance0aL`4uaYgaC lDt7  of grayq6fie?ld Boow1b..Pres=y keyH I ue F10=
, ESC=Cl  9RAccep/=wYesSNo D, Ao$r=MN W  UsSarrow
 o highl@ *he appropriQmenu iYqKp"<ENTER> XbegAi)WK%#.?followM%Z&:fpc->  KSPACE? = NexBR3zc-BACK@vio"Fg0hTABE3iSHIFT+&*lcF2@&10`
 v[J #'9 Er This60cann)b`mU;d An eα ocP^@ whs6c.pde 0x01 	e@ondApGPu@p0{6Crequi yaydE`d~jba@%smu0C
movP:y e4k/MEU)hQ1& ilAl//+2SDcleOsu06ssfu=lManuZqOr  N0
d:Prottyp@speItwepp+CacVize (L1/L2)SQ ROM dd famiaseP8l nupi 	Videovis"Ke'ybooFr06verD$b1<ed2e	3bg4`1qa<ownPhSip<(TdG
W
O3O	*	Ĩtafdapi5u%BSNZCJ*D$ 1
22
3	ME
	C

V

d
4TV
o
DoD
So ྶ: D.   %FPA2d!J#biFaܐWalRX0sԔ&1&H} A{ddline4 AlXҁn.%F$Warn: rk T&pll0o!  zsfTrea ҁ/vր, letf ea w̓aba002 A: 
deĮ` waqt@t Ұ_)Vu @rnInv  ȍP
)!	Ayou̔ wa@|to A ?m  io	  0o`b+-c?(Quick`n2o2 (Cvre@sʅ3 (S.M.A.R.T.) EP1pexim@s ): 30¾# 1g¶30%v}} ty ho#0#uprХ:1't4	f-Un3knkp{ilyWR!mServReaPS)doџ47`?a}.ribp	:`LexP9 'b`G H  Olp New Vfy nY7Enc8Of'f O  ɥA LA66#%AKroE   p dV
Ad1ݰ U@ҭ5Ocpcaus 7p@=AH
"h` A&فOpower-.AS΁Qa?U= loss  (dYAhou  nlcof aQgoH04)ev`ۢ?[vYDocHishR`ed?!0fp]Dddi1al JJe HyP`"UTool0 Cr.%oF8IL`ˣ Bk g Uмn  qpm`@jtWSN !ar%v0s /UcwchOP2"Onj* e:Z%%% AF@%԰#Dn -f  TndpĠfӰunuR?*$n)tartBQK`fra Par1yNsza $mediaaAl Mmk ,n LANsQG CD-q0F y D!7C|U`	|Q4 abouud}h uR0[%_Q b0USERBMAST {a
panpR<ccUrEW"k_eep iRaL=ephysG?p1kr  :mpcr. I9RBr0A#
, nSUZun-Bڀ5j JOO1Auto!RcEdw\88 I3?#ON> 
(R[_nR~lFbur Ct@_!R2tQh`Ss1rw  k edmPerMd`qaff+bdata,@`ssibomaANnicgiAE!V IPs[pl r5mmaP  Wu`|l2,orepla^yr r/*@|4} [0uB Ӕ, coHA=Wy'u~me`1r, @MV`*ЪpPxibЩty. IfrdoTʄpw8`AESCvA.!
t V !Nҡtyp#b'>'q`F10"qPrm,bs {,t+  E$` MiBjQ  KOru: U ay OpXޒHDCgDL!bA~ (left`/hUSB t HqbsSu K Zipo'Fir oA0Fthifp Sixa h )ENhASwap Fn/Ctrl!s K8tᓃU.S00slegackcH $`7)n0=pr@ry Vo  d NTSC`AmL -J -MKt
BidЬEPP ECPd2size 32 MB 64a F@pAlw+aynPPi0ACS gWD Radi ViB/luet h5/rS :chA ! SgbQNt 9E& (%+D n,2())+P z+f1En7)e 12t3TokRaHp
kP	M3Unique IdAfd`&el   (tu1    S>`KCalib!6N`s4sP DK A.Xb0BY  H0w O
E=Li MEUk'@g'MRo N/G/U[:1 : C0@g . % ] /C le$2  yc1`dik-d3 	s
H

,"
* A 5>M(o!ylSp` @hnologyg<YadapAPXE RPL Exc"Po'pupz(`@0 10  2@ U3 4 5 6@q7F12zO5 15`@ 3 "MnB `oucWhpaPuSNon`BIO_S DMA nsfers <F1=Hilfei>P^id[inQ\ Onzeig fR0pweicQv  KKgu4aobVcwieа@z @nLveinun	-s
kz
.AiKgn epdt*nt Pneh78/%Set@%SRheitsfGunk nʉtoa u
@naDlt-KuO] Gertesp/-$-ID@ FOt 7	U!sttz !Ԁpѕz#  be7im /st

ng!@M r5nHsvorrq##7..zurckz9p
B .p,
f_g{ms>Ui0gExGAkku)k`eK tBsgewhl@DD-Selbs`sôItivS9#LtIp;r 3g 0: tppllTL
PZ`OS
q@ PErw :%SpraQ 1a;n!4:#U"gran Fel{dsrt-O& O9!86")Ke SePMbqTa@0, um p_3fahBj=A, ESC=GAbb!#`WBkze!TJasN0\, Ja	=Meqh`m VeZ
zpMarkė"`s@{!*!'MenS% dPfeilt!
^dxQgabe2RmOq>ko?9 cs. 	fo1lj
Bn 
sg:->= r LeGQ = Nch XA\pd<-RBchritt-`VowA(Tabul!fsn+ Holl+gedx F2@
38@= {gy EschlrL@ixPK kan~Lt we Y!eiffMgy16P=`?rgetrPnu.Dc  01 `L@`fit B kqcQFY+<W\selomvor&B]er0ilXWqDeskU-2KsBhmu  f 3asbz{w.2Mobi`യbgptz%. `Qz qh4Bi///"2f!
}[KAlgrѫ a}b	chlosڰF-Ml?l Proz+yprtt` 
wig!60a"Ca`-i-Gre (L1/L2 kkapazit OMPum"Famik Sp; umm Gra_fik-Rs@Q Bz]r-Con "
A  @°a?7J	b31O 2O 3O 4`dqV si H>(F ` 	o	o
o1
L
2aSekrET*@@L$ƍD%'$b-!3Kc(1  WalkAZero-T<One EdqQA`PnO`+: bX7 ΀stqbislwnKp  ZEucQN-/WB _leDQb s Atei#CP0&ILp`ak A:nfC6
lW$ge`KR/+Pglp%ɏf5 L  p	/  M0$wirkQh"vQM?`3, dap
l^ie0wQPocFLˤ01 ( anH12 (UmfafdIGcܲ$fhrxdauP(Min.): 30ZБd0S`@0% cgt59wuwmG HoPuy p%ubr`"w: ؑH	ԑUnbeaaMTHC52'rvo-L 5.
32@lhafAttribu0FID  2u"LS.M.A.R.T.˒XXMs K`kwp eus~1L Dea  JaQ`eD/t Faqlgeb e
U	ңBU5Ip dminIoz Dur1@`'@`|  mg1i@eFN1sgd,E.@з"< ttifiz eq s{0yrt.@s Zu1`0LzO X9p袓enl@~9.Ajb s0Q!np'Pls^AviceTa s ,ܠF$0@ h`$̦pga|F	 :	 JZtfa@npWU=m Fun)S7, m3ex\Wn HP{tectToolsP=c^ty ManagпUo-- c}- k QuickLocmkSubndHFr#q\MЀ#"e$bi sϢnchutz  f_-0?1dԨ@imd&0 "+a A)N+ *W"$B>x#, lpp$meh1A #I Nk>@"o3f`wot-ParpAen}ґ:-1ax$PӀke-O0ANS2SjmCD-Տ&g1DM$US:a!n3A:m$"Orive)Fwpla`t<>PcMs E-@\s mX|8unbrapmObar.IptT
e,ҎbewBABSGsWDĒ,g ~¿ $F`&)/	L, 2p1\v(,  @ K2l?nc7z@ QBegriff0dlau'tomOv R878@=ohl?B i Q٩j`|@p#sv_Y*f 
W'U@!!·!mU"Gn OP o"e r )lqY|#OBzv疡58f<sQ|:Sn iT.) ucuP(qS!qs% ph!ac%Cw Pr qҖ+I r0  lqurࠁn׶hE . Escdru empf/qS	 d?zu!хRO{ t.  󌡞 ( f.ПYҴF&1 2  B 7 b-B`ntra tAdant!Whj`!@Esc-&Llˠ>mQ kW'p'p`\ F1A0`esh:
x*3fg`g sbD } m  p@MMuBay&m  )bBtg
k`-EQb(links)1tUSB-b#-2؆ƢSu`1Zip 1`234 5`678 9`QFn/Strg!Pt Ŷ dEaCГ (USApf-ZePcB`iebss"unabhng`  cAIAn Grafik-ContrPrimSek% Video- rnBidirebal GrP us Lfa`ipCb0tzbB
d}r W-Gf0Bluetooth9Un/a jEgpaOAggr `e_%7(&.(o)u r-E`t 1D2P3Y5ToRRݯ C:=A q 1tv$^Q1I0NqkB|oF AkkuN(  `Pta   x a  Kalib  M`k`O  NƘiual_ !  O k   O  DO,rpOTra-?6. .O .L4obi!qp9 OO5"R!P	EgnOOf`.[zцrІ 1 :r. % ]!6ablo(2Entl ho3 Pp1
m* 2
  GS-2'su' <`Radap0aBPmbzA}ExpA-!-Popup ( .) W0edau Q0Pd2 (Z@  Ke`~BIOS-DMA-Daāb`݀EaCompPropstn <F1=Hjlp>@Dvoplys!Viscne Gtil !konfP[GendfraM z@PSrUx
J gnor0ondr oP(fslur ѿ ub,t  gB2Otnek@+hed Administoradskof K ao:dA7 for'W`hEd`je-i q		+	V*
J	Sm -kort	Godкd7elsf 7do_!dbycggGOds -&2	 Nu@00fa@kisl2 Uc 0g
s)9IkA\HF%@Ba.AX  b"d`valgte b&HDD-selvp^tPry Huko@`QAq.inRhaQҽh OGH omv	IBr/ Avancq Sprog Vel1?s mo2nedtPt felOC4+'/#5l5!Tryk pP7 tCas<G0=tZOP`=A, ES?C=AnnuaFs!3=J=aNej "Jg, AR=MGb Brug ps
NA`RP7xe  releP %menup(,1Wt<ENTER> se8c>A)et.tafpr'f!f7: -> e!& MELLEMRUM = NlA<-T?ILBAGEqrTAB&|2$wKIFT++tF2@	:*~@= Acceх h0!hk> hsfej 8A3ku1i$0gs 2dodQ)!FF1n.3 Fg01BRnoVD-p% qpla`9G!kr;v vek`EnqJJ
i db!?sP fl%yMs`Èn#/MEUqoO5 bp* uvetzbrud2JI,nemfB J@^`  Prc cor-tyip hBig8H  ztr`7Crcache (L1/L2@HVROM-dౠ f?amilie'qi;AWdeo#f0pd@s:@Xr-cs]D-ba siH 9e2o`%3o&4Zƻapt-3ta`oej1:("Wat)	O3OWEw @ex{%IsrP4E$ !TyPyC%xy lydes!8BmisW 0'bvbD1I'j`e0je v;ar0: DB! se  alt@P2[holda po Pqt`/b Bb)-Bdduw5,pr PkD
kEuGrBA:tTUETfDF%v`Ugyldcig/
t-  ngivHuİ,vi av٦,ݍ? i#K?@ $1_ (Hur P)%N Omf`) sl(`{ (>): 30˄2j  `1x0% frpud@Z44b2@DR  	cq: K@uB+"UApyCS'z$esrvWdLsribut: IDxl#ZS.M.A.R.CT.5ܐpy`CD@F8Ny  Be@}ft nΌDeae Fra@l !e@+ ń4PR@{	s0FC		 ƈ4D
&KE  beviвB7 9!Cfdes, fu.. <ramG261 PoRR.RVuAj@me+tabWata. Du bu$AM flAX:Ը vicehCa D[G @ߒ[&?r !,ci HP tectToolo9"jK~ Quickpau`LsQmP Skrp!0rKvt%#k|qX)/sa1-$>$ Hvisat  `w@fx6r,
di upbilK2;+1ol p@frard )x Qlash-@$PR@"LAN u70q  Cd-rom-G Y3CT:4B Ho6E%:eiDuQ19H 2hPy,a?@ D$. ڌ b SBRUGER-PwOVEDADGANGSKODEN,5uOU albpxg= s nh  ne]d! opLaЄX!+!edS 0!#
{	QD# Cl`n p wH_FQ>Rhjlp@hutom o/ /^`Ebyg 	[n8aW2k perma fanp Tig zA۱5n>n fys dskp92`rbfatpc(On !O"Po	v   .ggIFnd ufW"1 O}m/, somAl!pa ck@
<rxt. U# p~ rf/cQ  ikoWs0.#T  ӾQbefal kraf @˓f| 'A v@"pl . [u©x
gD  &cO.q# q"J"4,Q/8d i ĞHuA70.!.nܑ0:@ENtr!5gESC. E` orV{ 'F':g1qe@F10FY sMsf
i/P4 D+s)  Dk Osr`flgm vRRenኁHPskm DS0-bas  MultiBay (K0/$hjUSB-floppy~cc{wbsu SbAzipRFr!aVTredjFj 0oe Sj#SyRV; OS Ni ˮ Ski mqm Fn/Ctrl E lPv(uai sk)pege U1st0!
uQPnP0#rm-cr PorimSe d Vo Ou?t Para0֎Tj`StrCL>1ohukop B"< t6nr compu0P@ɀtrm
gt W -!sioBluet hK/A (trdl0lo|netrЯUmsty@ڃ&(x(top1*b`*E;thqft 1Ki23KToJRaYHL	e+	 	Ent 5gt id-nuҼ a/ri@  S@   Z 7Qb/| JKalibB'p 3ndaigO x 9p b @WNM H KO OM2[bo   O O#0ionOOOO$HAgs 1 @1O O
1VSi mobPGu"[Pa(MEU)J=K=OO GOqOO  OOO[ TPq 1 g: O . N`% ].gAmt2 AfFH5L)O3@	Genos	
k0

, *  J/X4% G)g`h B`At `r`bpopupްsink(sek.!H025f-1@UbgpP`pA BIOS ATA DMA-r Konfigumas  <F1=Hjelp>ilxin0jon@s Ps2{Laӌ#$ak"P)Hepfra6#:0 dio	:Bkq)g avslu!A B,3l BDE;sprograt St p'assa/@&OptFA |U)yrsi!>vsfunkqur!`tifՀ%୹b-
vn Sm`16@#>godkjSq0!`neby`5i%itpt5auTilbakeAl#3fabPP@R g
i
 PE7;aN Ur_kty Ƽ a܏valg A!lQD5h 8v0vt Ak` MbT !#`]a@U3EG *
`Hpӑ!4vanpr΁lg 6  Dem75bM @\3dtJIel\3 
.5E6o%<}5TrykkC taJqLL&i  a=, ESC?=Avbry`a(cBAPp{JaCNei rP, T\Rer=M@bb `kvYneppilr@Ot<ENTER> hv ddu ve 'Vt?. BrukqdPp%l':  -> e$ MELLOMROM G= NQ&86 <-TILBAsKEwrigʶTAB&"HIFT++TF2@	)P= Gof#l\ ~WsfeF`  SPk'0`pZmnop@5 8P Ma0|m kjresve!@0mb d;i pp 9!obaRafly@sbc^  0d w}a`1A|rvfull1z. kode 02Io"Pro{du _t Nopablokk-mll {typ4 h@igv&--ga zv$buffN(L1/L2@Mengp`	Q	enuV@wo-TtjrtroUSW,kobPgRi,oKr1 qi 23R40,p( E
,9(Q0  
oa
oA
o,
N#Ek#ImlD`4$Eoc%Hq ok!i*ps(A"Walp9g O0s"-h1jH( Ad`ss e7"~e 5PnAd 4~: DsA#. z tidlSChColp`@DTH[aQ "/he7-  d, rnP}u1p skl<k`nn2A:۲O b@Ҽreg1"i%HU?gyldig#DSR`	F
	#NEh0mtEb`?̀{]F igno3t_te?2-  HN 1 (RcnslXbP (>): 30A3ggr 0$s0a%[v\st͂!vhF_f!_:g Ka"qut``UÓ5$SQ&eGt To(Lesb'1Du+q vrib: ID01rs<pS.M.A?.R.T.-f^pC0CC  G#Npu  Bekreft njKAv`l eP 1qrEّjvlik3t aDu!0 oC2Ѽ	aŤokarg3ogs.prɐor dxmpel& Tp}?ّ!.rPa(dA=pph. `bku  amK#0vice.0uHla?eD(s aݢI 0"H i HP ptectTools3curity Man0`r. '-RN%l  ēlanppa|0us L@$AOmpEr`i!gi$e>u beska u"-U+/- +ӂWE%q m '. tgl` rh,v@=$ڀPŶ. K$RmEp! rfrard- Parll+vFPhielQr/Pia LAN n0^af`04  CD-ڡ%vbX4N5w Ho/:eD@ Gh0valgt5Arj h($s6 bBRUKERHOVED-8`DK |umu̅! E
 n_*GQFbeM`P
 Pﱡ y  "!мa$ #
T,U]?0	$ۆ P8P,pp 4qLL KOM @ aOutom\pDyLock5eabyggj]dT3Ac   `ma1ilg_g%e. k_[h fysAad$0ƴpqtW fo`?	 exᬿaphn@gE_3Es `dda gu»z. Urrjomd Q1@0/e XG|pn0q
B  uSb}VnbefaQwr G	 q.ҀA,y A0k1 Erғ& 2;k_!R!'I@7MEPsyp-flAans NPEv
,2pES#C-|L Ѫb u"'fD'<J F10$Z4be:h&` n$  QΗNor iFOrse Mu?ltiBayG]@| "Qdn7(vee)0ko.ngsbaphhyOBUSBeA|w Zip-U
A A0@AaaˀFn/Ctrle EAVd(USA)GekeenAQel !	`jZtroA2@deoPP@pJT;isarrPFViA7ti@QmFgradi/ trdlI@ |t@
W) OFBluetooth /-Pbft mб"Յ Agss`B	styD'1_"&2<o! (v"*b/!1 Eth`P8?	)(	3 R NsA'oo0o/
8ni> gtifikC&\=
B6riQG Ht     3y怩mbo KalCibP!K B&es- IA09pp@<Dual ,-N	O	I	 O	O	51O	O	O	O	8ksp._O	pO	O	`lnd 4 oO	O	
%O	O	_Cs mob.  ^
H.\L.\ O	!zo
{{O	B.[ TAO: La. % ]!fGullC2F a{i3
Qin/h* f!y  (o J/D
iPrpk)mA sin hurtig (sekuPrF12- f1.Sepute P pBIOS DMA-ırސConfiguracie la Com adora <F1=Ayuda>rchivom%l Sma QGuؐAisco flexi`cۖ Ra (svalo1pqfdo@bpa< y Ignambios y lia A{  g3 'Lnepida9dAse
"  ' Ajiciof<%posi)s_SITc)$  +՚ *vKskSm:>C0 Soe*cP#<)o Sectyincor % E0e" 30/c XP>6fbrI
a`DPVc!3nci])AutomaHerramia C8~H er  8`#P(8  ;prueba HDDKc 'EOGVp&Memo'ria2a d*mp.l1@JNKRMu0GbSG#
s
 Avan!zX ESvVDD
W? Fampr)co0N g!r<1o?)<UOprsim'quitec0g2)Pbao=, ESC=Ca06la=>=Acepv=SSNK1"Y, Co2	=My p U`@{B$dchDha6al~  alemo ?apropiu=@[*<INTORO> z qx:N1n.Fs@{3pkTY :Esp~o o -> = PrxcRetroces<-{0`@axTAB S	S'@M_ays+#C(/F2!-910`rƠ"b"uErr 06F  No@8 AiWGSr`jo u@QRA>6K. Cdp`01Bhay n unw>эqubRnY2@AC1+>bѪr(R[co rUD)JНebook/MEU?IX 1QP\2O`0ple0Vxitosa4e Fak T1y?til TisOp7T,VclGpuWXTamauZ_0h ?(L1/L2Oc FAAROM mil@cN7merD}rib.visUv@ Dj6r g-l@ yo!!
/#j1l2n3p4 Etiq)urAsI2VeFK (ga Woo.o3oopoi B	Esn!*J8T 5:Z$  Pr#obUS%bssfactcXJ$ǔ =ll4ReoC 0poX@1'	lnedi $l@z,
(CE| oD"F%Ad  :vH uir  eap. PreP#
/, WcFqscpY#au솀A:'p, U u c lQas ' Ӣ,h:p9tegAң
S^@vlQI$\e'vaPa)00٠o(a) 8!@%c	lZa?`gnXod ilO(g)-ф:1 (Rpz);2 (CwF3 (S.M.A.R.T.) ClcuvtiMeej 2( ~s): 3040go B0%&~Db EaH0 _`ipalGirumq
 : s,pu10 qIQ{`3nh7Servof |44apoya| atrib0: IDp#@exs G
X0YA`seäaـKHnuCevL@)D|f ApagmE ndq9S@gOB".X		@e voc"	k6"alpa 
0c Lstnad ; `fRn"]`e#թ9 A*# \A<Q, (02o, vA`Ơbs (R6% 1E  WciR|PLLB 蘑hrpi9nR3 SBIf_ olı9al ol`X#A!vu	jvip.AoQ  '{Ùv?%(֠HWapaAuydA=n14n HPϿctTool@O )%!!&  QuickLockSusp{en Blo`8^Թ\rat S 6""<t mej`eO @`?:0d++-!y	(BI	( !)(PrALl"Rt0,"D,0XԐৠ&upizQ,.`xHOreN PunxP+rojo%Bq>lWS9MLmedufh~dem Iqdno Wak.n LAN@H DtiRePI" ACD-Q(mEřal)[Pm:\ U]sio:b	u4@S0S`xRrive+02dL$ t dBUSUARIOM PRINCIPALp1 oo şgwYNman@Y p 0|. AnТ;7 y gu`'` lugp  cjAp~0.1)TM @d k`\)hG1
f b5@ָ] @A"TPwmc;N	;I0orD=
`>  ʧ>1RnRbsuCw  _, fsm1$ !Rul rSoc,L "oI /be} "<\su 3Ҥd/asRciuBbVt"B! ?p~PFda$kosapg`԰6Se {oenf 8pd@lic1a頴re!azA. /?k	 0u񡂮`#PZ23a4=inͯK nTBfixP8Z`
v\ix pons2> cY_, pipԐ2 ESC. μؑalabP'Fd'  p,F10: ̼ݲwfGA 'a7T/bEspaol O R3tMultiBaNZPna DiPsi3-p ;]dfb0co+Ļ(iz(@jech`-5 cBb a01ЇШSuw9krDZipcpmeaeTer. Jo C`5t5 x Sp5OvNo`DCUsO Fn/`Ts@ncIngls (EE.UU.)sPŤ (PPmplSo}"le$B 
Ғb!Ac@ Gѐeo ModZ"y!?  BidicO Tam&#m@PȘi#	sifu0p{ bBICA I!R01ڀk*Wx{-Blueto'oth A  zQyyQ ho0cergRs聧Cpoos3B_-F8{(s)ior)Eth@et, N0boo0 S 1/,2/L3/TokR@bOO@P23 IPtif Exclus`pᑅAJa `   !,a*%AC~dP]-N@XS#ӏoATr)3Vh!,o	o	k	o	h	s0bhn	o	o	ehao	 o	o	 ao	o	%MEU 6}o	.@o	o	o	o	Ub o	o	o	o	rB8[ 1 :rg. c% ] /i2 c4-Clē3 	0k",B'* r 9ODJ)o!Ѥoh` ~aБAbblR @zArran@pٓ@g#uXDᎰ0gEx!`F12QTAmbTouchPaud`uo N`uTsсr DQ DMADBIOScaub  <F1=Ajuda>rInfovʇsob7o Sf E@ Ј?4m0!DbвОR$!0
r t7padr0
3t  Ign`air@A	
sPs'&_A1nanL6aPOaDr%& _`#ƕb!X _d#!v
*
SPtUd!ނ]:liz/p@O
(I 0➀!ևs@/R Q*Ag%Ѡsbr
autD<n 4dcЮealhfAlo`Oa (SFeQmPasg1=i`CP8$!leROpT`HDD A1)r  VR#Le Mem@A< 4tatu UQMu Y`G]⫨' Av8S%,io Qa`d; camppJcinAz"o?`CA9 Pdse qnr ycк'tinui=' SC=CelAce imNK!S, Q%oyu=Maimg Uti0: s C	qqp'	da o i  apGrop@y *u@Tv#<ENTER;> t5meRez[@o.Tgut9 ^r utb:  ->
PAO = PrxiK\<-QBACKC	ExaQE06TABo$S_HIFT+C%* F2 	*:`=kSC8# 9nErrrOAX@Q@na0WoQp܃mRHE.? CdigTGo 01  NP#hG`,@o `̱+)  s@ viKCAc A	bMev
;ÔZWot?ebook/C[@(RWS mG"sTe2_DKKXqmBm xitonN  Ti0H݀3VpcS_\ Tahcache (L1/L2૦FX a` ROM FamlY  sN 3sri
RevisSvde@Π_aJroQLa
Al@!D	Ob a( 3M4`Rtie!p	JIOeu6$(]) { 7on)o`o.Oo$alS~ƕSecunda'A$ 1rcC% v\foi"gv@a!mO al  Walk S 0e g1i	a lien!M!oc0I@Advoert: 0[0Aqo vaCe!djWcPqP/,!i@um  gravvuu:e)EӎA: n@Adc NS3 >HB^hO!Q/tegiEa	c8]
vl0IDyI= k9T@ctez0 eja $,C? iN >?ý1 (Rpx b2 (A@ng!qf3 (S.M.A.R.T.ax`=_(.): 30<`хѡ0@CT =4Q0%?1$=bucedeA,qAhostDCrom1
w: Iss-P$Eg
Ch`Ӂƫ(*erPmec    `6Q3s<M tribߒ焁LD`AМexa@s wQUUi!g:Tgrg"`alPSLs   qL rB+ۤiPArrfDigNcis gҀSAAdP)PPЉxac'mod!CsާB! faz A@ArEr`a,Πerx dform!Hr3Dn,P#ja0.@eHCsHfbr>causadQerF.  SZ Q[ea 㷑2krvio 	Iy0rqX)QTa?%0Р ur@1r0k
ad`pis0S,B,QuickLock!Suspenso Blo `qtB #u@aSM%` mabnb1IY @k, $$al#.`2P4sa eiSib0RPuseu s<EExigU`re*PbM0Q+x &perme@$1lp즅+Wak5n LAN}e GACD-BͯG4PhDme:RFusu: Voc`iܐ`TBPxrRutz0qo DOrive!( t`DTUSURIOEI`ESTREbHs c'0̱90<?Xapaz=`K. AQ4p`;de-OispLeD1@pB`. NPv@ߐ]*VXe ,X*a N! 5 P-b<*6a AGde0_D.Hh΀7D1{s1AEi@Ǚo9V	AwFIa 0X-nb;;o  suoɻGfoo,n Cf Caaerh
a`ww|oW $:aq("͂4  Šqqu r<!{@Fmg҃W {afPW@{ 2{, ;) F `3bor na1l~a-v
a` tႻEsubtud C} ?`JhR)r1rpta-lVJOsrW L A8Z  LembreH vqMa Pasa8
 Bqui1_s0er ESC6]勡9Ǡ71Slav'f'F10.@rX"r:ǻMrTpA]d !ugus OQ: MultibayQYiNcisi@҅afpBa baѷcopl(rp@,dit$zB	Rc"zipcPriomeirBrc Qt!Ղ O]v`N ׂc`qas F?n/CtrlIngls (E.UVыxS[qh 1troxh2vdexAcund a@hMo#agoPadrBiQ2 TaPhBm'em0O "sem  fu0bw>zeYc1PCA.#RPaI PRlmW )  &Bl^oothkACnRѠܰ(a/ Eomenergaѯ ere*a!gBC/*1w62b,2oo-'0suЁ`/0Et#netg	O p
/*3/CToken RingOOboIdAfc PPb 3araT qUS%t spS3ܼCbQGP8_tgemNQSrl1Cs|WDuplo&	ted/	)	 E/	fONOOO'as7A XjO/	kC/	cIAlЏ O O/	Ojb{MEU/	/	-/	G9Dq	/	/	/	O6[ Etp 1:rreg. З% ]@Oc3l 2:cv`N3:ɀM* 
 o9ay CCm*O"(s䡟flex QSc`xrydap R쇕 i3Popup޴ Exǐ ~'F12( "ߢ dQZs Vsarava NUu`Ts`ws D2DMAFWIOS i kЙ@{mtukP  <F1=Ohje>xpJrjptQt Nytt vPbtu kP Tallenna levykkee Adk@onoPpuVtF?Fo02ej'nsW Oh muA .lopq6Lr + ttt7fTpou`aurlisu0invojan ssapMrityoKyn1y0k L%a@tyl	
 P usnume
o$E-
t lykPiu 'h&
,(onu kig
/ A(et@FP.tQ3aІsB5*tehd 7& OG"@t!B$j;A)ma*in`Tykalu0A: o K < K9i3vyt?jOa9@@pDMu Qk(! aR6nC:m-GdHLisie#li Q I0k aec  harlAlQ@1Q0=  22R2#2H%oJatk!inPjot  nWpp_=d, ESC=PerF =Hyvksy=KyllEi cM, Jok	uAL=TY_} fnuoli
mip_k`ah,$@
sics"N <ENTER>[ mB7t
epb+.!I`Kgn C/ss seuraav0U: ->Xi VLINPPIN =p[s  <-bASKELPALAUTEd0fb1!YARKA+! hԯVAIHTO+0', F2@
)_= d@!;PvirhvAkkua e =oi>da.>: Rvdi 01*ka@ c1s} apH3rt2Pl pU@eytke`"6ko`>@	siPQlaks1qrsRW` kaCt qlaa8P^ TikkI)>skeytyi Fn
i(pO2nL^oPh0ebaGmA|ja|}1?i@d tOyypp iIn :fapllVlisQ (L1/L2 U  ROM-Sbmkoh	tuotepe")sar {W]`si ?stoh3jab T;{	!1:"#2$o L3o`M4m魌J`LtaQon7(j \oa)



X\	\JEkA'ra- DqQACuP$#:D$ (P9a%dzb~' lpi!iEމepo3i Walking 0 -[1Yloso@Vaihtoe8@ :uvi7 us: Tm󵐅@atpnhp . Jlt luop2us-  n,pir1j1onc@<!K A: L"X AYhku VV3beFAG8p_Cpa ᣾
gH&koa]Wi a`n? `O  P?ͨ,iF`%(N92R`3.M.A.R.T.`Arp$ [n (min): 30-%s p2y0%cL dv0 Is,pysi- H4iVgR
{8fb%untq'c{K)jServomoottj
Lu!5ÂvtuQ	k@Ftotribti2@ЗŽy@a 6eqKxe nGG9w UueVahv2u  x P>2	! PC ޤ}A"+2@s@ya	na -ã PAJa頴n4-okkpDad`5an /)i	nDP -e@7xp$Rmysb a
`k1h@` ЁeT@	dE	ZEY/r ir0Xj [!K unQnwby:p\veapahtum"b@^i!d FLaJ4tii l <HP PrpctTools`cuQ`Pger -apuД큶.f(-/U i` n QuickLockfa hlu5qf,V "@PraZ&-Q,:*sekm #o$j$i t)a{d||}yh' PP `0#UʎC.7>uu	SApor Infr
PnR%!bkiS0m 4em`dHert`hiԐak0ʡVo CD- -jl
"4[w8 PFSjPZWAioqt#@ebn DEe#'(stt&)pOlla. p  /@! KY?TTJN= PSSANAN,0FCN{.qa!' v`"0*@lyQkur`V0< ribj^"#t @br
(V2[-(pY	,Qpc``mwLLA4@1`^q* OQ(u `UoЩs-V suqIzAr?Ii,#tuBx	8op  R
@J bU 7pbIr 
V|}m~eG. Nykyf r`+raq~sQ{6v
t`i @Su. Tqtէ0`$ £ihQ{3eip=0up@MY<eh? IP@a*?-p@@F|_Rt0HtaYb=c /Aojaiem qrtat. !WQsm "ftBTV@UG.2  !`ZXu1F_f}0D epq0pǠo#\X2Css,aTESC-npsRV;n,અ'e'A> F10`%Y4aa{ :	o .cVQ llq`t{Ƅys ubn Mult7iBaOpc&xJW!lakoPiu (enء/$oi) USB@)ZipE_nsimm AbKoa eljM }Vi}Ki eit@Kak Y KymAai Fn/Ctrl"mAȫ+PEng 0(USAUIsPPsa! QB-Rsq@ ƖnрjBsCPPs VPoȠ,t\Va'kios2sN#Iguu QHDplQE ko@QWLAN-roBlu`Voth @/HEh^`sVLP@Qs s`9llPƎ|+1`i@ɐ<9.2v+-	+ (ylosp*OGCOr5EtherPn1E Yoeo93o8TokWp#gO);o<(@workQ#% GxlHliv> AkkuR 
< TJqп rjo libr c`d W.ual^-O O OI OK"kb_OO  O ONr O$O$0O$tva_  OB O1 OMЩaanusBkO DO OOM"OOOO
OI[ e`i:r
ada n . Э% ] `ODPW2l ur00&OE-O
3
FGoMOH*  j ,9 ƠСBk 1vuCPPɐiư O (se nA@S`: F12:ٴi@P|%3tappikoskePPP\ 'mmaK~  Ei mn BIOS D{MA iedoPot Configurati5ordteur  <F1=A> Fichier Inforؠ` mAf=f age Sauvegarder sur disq` Yc Ra ,r  'une.H_DZHe0als? dfau ow du'Ig{no%modi LTqu S%~e l'in%Đregom	\ Scurit&
e ss`Nd@S"#j@ e s?ous te pPKon.@D
 priph8P %J	a sE L`IDy'As
Dr<Lockq
S%mp(C0Cr1b3r3  'heЎ5  1b#a <݂gre taR,)8+5p7am''usP3;),;rfreCncM =at"#Ou\ !@OlonnLbceriZ solecqSn@psQPs AIA"TABFoV,mmoiricBDX C 0ZZaFB_V AcpLang4 ChoisPJYl3Ind)!5_mps g! 5ePMd.r pa`k2Z}:z? AppuyDfatouqpo@ge@|u@lw=Ser, EC_HAP=A lHAccep S0=OuiuN*#Q3V, _N'impp_e``1D
=aw  UpЈzi3
s f'heM
mo!04ecle hmenuuceqr@rwbri а2qhz!y <ENTREE> 2nj+W	ss	sui/fa  !/ :!-> ou BARRE ESPACE/ = PBeb`-$IE~preced@S\<TAB`CA*<'zMAJ+ix F2=1 "w-$!S(rr`@P<TJ Il FA%ssibPcQ7L U cs'Jpro9d{endp#B^$P. Coa<'4K01!c5Cntв@-1 emplace( L' D SaQre@}C'y
GJ 
s}^ccueil dP "4@ itaxsmobia``
W$ 
u` B!OOOF2BfCX+)a ru +Fa0;cq0M\ Typ0osBVwDb KTa@rcaa(L1/L2?) Volu`e!zgD  ROMOamR Numro#p	Rev`crdoerS2ItrQcGlavpoL A}ud;n+ /Zp/zr3/t94n"3inv!/Qzxi&5 #pritF!L( Ute) OOoOOODBV'emdA Eo MT֍ :$/ꐝ.   %Er4 !SUPc;Walking 0ᥒ81lig'a	d`auZC	;od  al0kifAtipΤ1SC[a=e@ptruA #ieЪvPR! /簹r,i  z{ ncro°c	cY0]A}jDBL_v
 wtro Pa
s
TX	 ! _[RvjBa"`dH.On m:Yf@PS 0"Ӏf   +-vaPC lp  ߚV ? Igno 7ꉈ+| z~ Enregeo~#=1 (rap`})#>2 (coet)u`|pimA(z) B30堿s pAU0% nv$D9ʈl'hA+bF  `:˗	AsGinpnuFd'+,`v`t(
$.Lu( pG3p 5A`ibx!O: IDP 00@"s S.M.A.R.TAbanG2WpW AIBY^`se N!=apYeAÐ?/@;sa#A gMar uinKS;A,` eecoac	;mme, vK*ad11POo
bPbatCs	eSd4D	 3pe>a1a`0(`ih s4[,P@s蒵 `Ug"  OformQg-hq#xѼsJ.)rmQފ b	hJU0`
1AJ.6zT"`QDP~aR avoupR!AfrCww@7A^	 	zY R`(p"}ffQd  k;l2TcgNq`rHP yP`o Tool:eRy Mar O4K8CF!/  QuickLockUsusA|$cp!ri 9 س<S&ol'S+C)re!cB!
`K)!nk:,   v qi4/v/  / L'(a'a
S$ud!v
 KP
dra+D hpn 4`ExiAudPd `  4raQ8llƙۗ&flash Wake On LAN[ CD-'EYpalj[:A88s Ʌi$e Drwivea,. SsC#CCDdez "deux,%(UTILISATEURPRINCIPAL)`$G 	Br@U, N=z_L A`H!!%<q$ksr `.pfe3Bcelu2)PDordi8be4. A p SV	}(`rdQ Y,Go q uCfetCt{L@KP"/t"~"a"Z"pohp= =""%w! 0ԑG)?z@Mani q4"05#'o爌#!2/r,Bcϳƻ!n!  3pi[!! !!{e@]qPWՊ`"%uelR1W :HLj" ""opa8oE*O' i@W'Abaw# ,d'originIlRv`OB2Cza B	uD
vqS"ap AQy9Ipt0M
5djavs0~P}7e*߸@-$WqaPprsP"t ԁon: to@Tp Rסa1S44PpabP|t3ڥk'
Qxj, appuy
0`  ECHAP.@@@ OTzR'~o', puiCrDF10@TapX2  1xCxY^u}	UZ/qFrana
OgҜACJiMultiBayulƌAph0A Q!3D,xsocvv'a%(ga)OOFRz) Ux[8֗ USBqr
jZiprP:0 Dhi @s QuaQCin`NSwixi` SeΑ  Hud NeuvCD`Perm/r(s F?n/Ctrlœ= AnglpSA) Popm1`s A`stanphnROd'ad`n elAtrulS' UichQ&uer0&m`
Ұ*d :i@7idÂoA񮁾Bidע 0 mSmVlb@jEK!al ,$ R o!=ril WP (rǊse0il=)Agr{Blooth7s0/?1   ;o`!0@g`N@loc 9G ``0!WnX-jb61bP-nH o82ooypqu9	3ccujodogB E!t  1a"23TokRingooU/IduT6*ao aX4  /   @  h% ll`ъ n!Hre`0/ x Ab!`AC.!f*Dup h*/)///tb/ ////** -///Jngn$, /,/ /e s` Bte5xЯsqbmoP //7/// ,/Я//7[qRpe 1 : Char. % ]PA.  2D` GicM*n3@	Rkio.
* T  @@/M.$ oOAg$4Amor1cFe"5 ?RetardBTexp `) Dгa  F12tposf[iP+Aux  PatqbxAKw ucunferts BIOSmDM'A IP zpOlr <F1=Ai> nfogQema
l0'Salva`l floppy%@AttoRip}rina dn@Thi@fa0``ip"Ignor`d!ed ?esci EP a
'l'iI@Az eiBntupiczza sswo&e amD0ratogcc3R
q`_Q,vos7v@% IDs
@Ԥ&gDriveLock	Pr Ƀ)St CP9 SupA=c30 gHg/o+:,i fabbr
4=i	/.nzi`[؆Qco
rui C`b5<bBae9E lrFOpa t2;o rigidAtpaA'VxP!΂,a me0V W`<HKhMiM;A>or !Ava*=t ,Lu!O; l$Dim"& q6ca X ss=opd eviQc g1	vv!'#o*62wH8Premi qp_siasiesXperQVu L   k=f, ES?C=Annu P,aA Et0q]eo=SiSN@1T,altr
o#	=A bj Us"SchiavI frecc'!i1 voycpu ap70e"_`<INVIO>  \k\'e.i&pYgui  un%:@ -> o SPAZIO = xsuWss`0  <-pBACKCE c<TKAB@C%o"MAIUSC+)XF2	>-Ћ= m "AC"IErriS0D  Qu A87nppupvse@t"Vi  v@u4T|PXJ. C{'01 N0u0F>QQ9a0}oggiao Lk`IP'00 U>re0
4Es"@agga%Fv0SAc`ғ  npabook"Qzesp қ:\ ZҪf.atp_
2o{briuPrf uduAA ND  Ti"+0<PS^pVeloIStepp@YMis1ca(L1/L2d&dDbROMIamiglk N@o0H`(	RP[3[oxi#qSroll TsjrAer H~i1OFk2m3n4ࡐ7w PVSTeP)DE(d)8
	2
3
4D葭xFonda
 ,o:EV$ Tr%$OupyP!gTpŒ@lliASpr:bits 0t 1Rindirip	i]  `| 'uFAЎso:5X%? gger `|vpAhAre!0M/rѧ, O`1favi P}PbiVYXA:'mU[A:"maconou`Ah(_ IISɁQritVa] Nsv@dp RlIQOyളSe3 `voPga ?AF0bb iQfre?@?: Aɐ51 (Rap)62 (Complet"2tio }(): 30>0%Q5"rƤ6ar0䠈'hD5|:s *Щ-@
 ֤(aD୆%aerv|")LċAPLA'	rib i0gol: IaD$Ban`de@z قi S.M.A.R'.T.!ޱuTx0U _word9c(nuo!i&2 pDs c(Ui%LH?bq+d`ᗑ {â"Znd?՛O .A7Tcq^B&
Am AVf! B;YpCr	t>J&2fum y3"CePe<B #Eu _t`s!1a.Q]ՒbdFo!erqdPКatiwEff+Jizso@in  ca@2ivEvPgaζOdesХP @Jm9Yy HP tectTools Od. ZRV2+ ickLockspen`3B05EY. mou`s8 MM d?#<#,p  gra@p'!oe -!e$C-))`v!pKsm@]H0x!! b	,'URar i "lі@NR(@@|ГV|a infraQ)p y%La_h>flash 3PsLAN Of}fCo CD-B S&'DfYpp :Z2?! srqCS{usanD eQ). D9aI2?S ``bZ'UTENTEPRINCIPALE  r`- !a man#7fu o.G Anp0V =ffpPu@@$eqE ?Pe=PE. l`gPauX1OT]s,ah	q^pqRK sbr> 6redY|e.aOR 	A qboP E88@P+0 9@BCt
 Are,`q  d (ш<t uOG r~ luogo d 0I T!b'    Ck $ i`HU#:,AǖI</I" I@5-"Zs$cly@~sBn mpP!R/deB  /$bh`{ Te(  0DA'  gQ#QAi"3 	p1nt t{+@ uY/ቃdO::$l|&.2qpqu_{9!.Y)@tA`Y!EsnOp  @KQ'U6h,mp좉o GESC权M'vN)dovqrk 'n' poҮym!nF10.@ An!kkWy Ǵ_6\E@בIP(i 3  Oa:dP` DdM M0i?Bay ba1.ggas$Z)A ogCh i USB]&DSu}kbC
WZipBP6o@<;Terz 0OЁv Nl% ec AB Fn/Ctrl T$ Ingl  (USA)! Yi@#ul2O mpl 01a0Ѓ R7pl "Aa PмMo@eq Bid0H!Cap}a mem`qX5ems"F!/ldQ2'/wNPsW (W0){oBluetoot}hCommu5Z/ (j)@sm energZhT1$0N&1 N*'2HIB*Ca46*(0F`o)ol,spo Eth0etWJ V123e Token Ring OE3 Iahbyc@b3@ta I   ao(  CP/b// TDzS^oo  YHiPDupT /  o 6  / o ,o// ooba c  /  o uY\mo9S/ /-ooo oų///poo[ PAs 1 : 
ros . @% ]<ocomp
#2S' 4,n6E3`ɀ
ij* 
 /JoXaX/3i'o
   FlOoppybUAIAdc`Ƭ@(sec.)C velP`F12 b 2z@amb`NzuTras 2@ DMA BIOSup <F1=Hjlp> rkiv {Sy!~infotps~ S. pk%kpiguQ 3(stll_ frnl@pĐn ard Annu!a nd` ochsQl``   nʑ SkerdPtrsl0F  K!aOB rt-OaEnss	(b -ID 
S ao
 m`
Rd-St?d frutav 7K
@byggcd 
usBi=*abrik`m+ .J
sbehrig\#Gskts`rktyg Ko +r vP S`;vtiqHDD Ak_V Minnes:B 01 q5q ?@An@#B
S Vlj4rDP;cBnedt
tlD!v(C-j+eTry@SI fri Dg s nr du viJPsӄtyY=, ESC=AvbryNaFDAccepaF, V=Mer X JvI pil	e	/pCa PyEt
<RETUR> om6
YRtt .Zke,lj`SeerI  : -> кMELLANSLAGSTANGENTEN = NXS G<-BACKSTEG F?regey܊K TABf#O`KIFT+`H& F2`0+?|= 'fO @%Aoi?Cf{el 3t gqL @ kA t Ah+AO` D?stod uGen. Felk0197 AsЌgF{P|plat  NtPhm krv3? pbyPgm0 wfly5s t6u U-Por/2 ex䚣(|0Ytidigtooh2-@kl`TA UkN,q  Prr, typ
hast^hg0Cap-	rlek (L1/L2)Yd ROM,um  familjrenummn0Ddeo, rY dttNb ~pqyrQ!]H 1.$z2#3$4rbinav0̦3 (bZ)g	1[

\
Sek# xIrq.@4$$@gaxr%Ex!z=ok!pvidClmissl l.s Wal}k0s - ~P f1jH Adds li7AeޡnVar! D`@/ѹ  7<neh gx"Ccuskapay /G-tRxiƱ=k b!h$2AA:1R3 K>#Rhi{wIBB?sk_yddadag

 ! Eˎ҇8A!^Ԉ  2|? ig?D܇jG즦a- 1nabb8pf@րn`X9UWk ad k$pQd (>0): 30@ncpan 2?0%bX A4Pp/]pp01vr ka&tPo:,tq	!قOk%S(x er7vo-LzBր!i @(f%ttribut: cIDpx?grobsr.M.A.R.T.-5 GammN u7 ifin@ D> LܰQ  R4bd% pm}vlika mǄ  'InE?kan orsa@3iЈP9aHSsNyp0PO@Om=<s1A1lo. 'Na om hglmabtj@Deh ;else- @^uQuayVqΦ >fun 0`perl^7!i HP tectTools%٩R->6-Quicka"q`telge #Lp׌mPs Hgk
	gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!aot.c Kж7AompHi p@1f   Pk`anFlash-@: s!Wake On  fr\CD-0Xw QPR%qSt HuvuduJ { fK: D . Gowhsrdvd D 
e . A1 a@`r ANV>HUVUD$} ɀmaV@tt .^ P 1A "RN`ҁ< ild ̈+A
 JёRh vpyL l "C*lqJVDQ.Z +oI XqeDGga2{b2bygg7ZSY3 g 5///1dA\J8- F"Z0a`=om s-KeB
C:d@=  At;as BG@fj'F\B] ktuai`qafaanasks .dIutN^tg Ps0`AYq,vїur?sprungQb#@&MM. Vi  reko a4F	c	YrA`+,0s@ billb . A`Kad΄37_j &g `!b(gA|O-beڰfosesm ih`pґVfljgns. Tr0  >ESC-rQBS ֠VƁSwԑ`'Z'R-sedMtaGF10 cVi3a:+dshc{ Sveaq ҅: N?, MiBayCrut oppBP5vi BaLG (`r`Ϟ (h!SBV G Zip-=PW AsFjQa utKto NpT VxFn-/Ctrle Ǔ E lsp(USA@bmYkd`! b`n`rmsPtrorx,& hbbelorlekheo2n
ek0!L!BIfsv@iotrqtK (W0)Bluetoooth /() -v@mbeQ Aggs`haE%-21,42vд[,p`఺$aNed Eth)& 0	3n To!|RN"Unik '@<iD K  tus a     Sbo Kalib @o dp{P-  F:s alQ.O
o  

 
9 
Fo 
E "
D0!j1s
 Aoo
E
Hptag *o 
* 
V2Cy emol]A *5ooe
D IOOKood
D?[Ne _ : Laprs . 0% ]
klar2u j2453omFjOF* &V@1 >I*O! DgOߧ̀U«br@4sadap@$lg rdrjQsnabb0 (sek. F1 B=d StyrPguIOSo DMAaaX"Ben iee/ \ ЀOp Teslaan Configupo<`anafPvtŠardP"/  scy	Wiojzig&ne programma @Soetup  z1r wك sveiBeheerswachtwooۅ
 %X. A=paatbOgl$$ ID's  	gASmA6CP  	Oa u"5P$EcR%m@j+p%O
Ge`@gӨ gvssvzie"Fabrieks.PEugz7 /);Vref.s:nieuaw8OOc  Ext`Acc)uxB 4\e0P geselec Ea es ~ zelftGa-schijfei AcAt YvG0u`?`I R! a/4UBgDAUcg@7n ,DP=0%_
 w 9aKc!: Taal b  =r/emP 	rijsgemaak& el=;o" `/;9
8ukAZ ]{NMLg]g=S, ESC=Annul"EDG0=b!e!oJacNee fsl;ui@Q, AQ-f =MN Hulppijltjkp`gebrui1Ѕd )jui`xnukeuzk@ark^<ENTER> ind 
cr]bqeZo !vol%`@@`1  0aiX:  -> of SPATIE?BALK =>`<-BACKCEVori9glɸTABb	|#HIFT+%%|2+K= ykp=tx#B~fouta64k p It wf_ge15 F0MЌreqatijzasen. AcoZ01b ea0.i1ZCu  we   Netgvoe are0#`FMPN diVbas`e3
 t n0 notebook-pc/AP @.PistNOQwbep*igdooh2L	MЛaft NmpALyp6rocwessBnel3Qpp OmPЂP}e (L1/L2 Zapac?i VHROM @ -s!fSP<mmx E  Hebvrgav_0ideokp&p;b bpM	$m	ra1b2rd3e4hiQsgI t}
.jne C(bB(ЉwM@dzQ%)
  `D#^Secuib E.aw~~@$Ftbd%)҆2!dHU2L53Hac-0-*1Tho_adresrlafwisnd pao=LTop: zPt<tks e'ge gt PSBbeЉf s d1 A:og-  /ޖ"x0zbLe6`.NoffaG1 Y\f_dقڀD`ѱ

boචgAt
wOC'We nu  Њ"N
wil?oݩ""a? Ox
Zl"+1 (b),2G (U0Y ) Аpqwrpn (min.): 30aee&p:L0%Qtoo 4;q{hqo:5broAD):]eeqx/nb!p$32#kvo-IPsEI"
2ހ"qk:J S.M.A.R.Tc.-af@0APP@udh "/Blo!  A  I-7B4kXqc rlpSX8
 Vr!a1&\ is bBsAYohCf#/k, T=m]lijk0pUKQߛ zoFik` dvors:ka?0QH fQeksKPug/zet,r lorZ@¶ZOb$ uswb sqwYfur9h7oud'Hi`!  AQ`R`T`R@&BѴ񡘾 vuaYߐHP Pr@ctTools(*%/D k  p?gsp0p`b TWmE h#M"g$rgβ9b   ~e!rX#W>,P.o(h( o( S("7'EAJb"f }k otraakP)5w sXb tK;?ݳ ]Qʢŉ p1׀frapd  Par౤ˊ Flaosh-malVia LANLaa7 h 2ҁ`q- CdC-r 7HN|Hoofd8YqGv@JH  UQ4@{dfb`D1!LC9!?i0zow-HOOFD-"VGEBR?UIKERSbOp  p&3an@ SSFC  hfwACM$  fykkcompS(ansPQ0^P(t d 0Bf*qӠ. @\PpQb~A/utompNc8@=	}X `r>Zg]@@À;t; O!V)?!=NP sR! !. Mo[hPmoRTGb,p@  #m RS8pǲрUU Cnt@@SAe.p/ {`huiʐ,50d@w~ҵwas to/!k wgeaЗ.JWZA?nvloeC\kl[Ws0n@Pܭבz]UdTr!ra=`8	2WtorHh/)О Bget. /o
 s  vBn. Om2un
1]ѡA&`3fe*& gol q. AA_ױ_, cdxabҘhl  Dc煿p3ruk3!ESC- (A9 2i Rjb'k'tyUvbkn F10@`T*Z䑀lusTd r`V4  Nepl g g MultiBayjVzkd@\base; (ks)re  USB	-Մ cb+z6p- ER #we둣V V@{Zes >Z$>Aa8NFn/Ctrl `Owiss/@p`SStaMcW3MijsappOU e% 0 nĳlBi5j V o-PF@A/A렂0d`{dition  G`vgp<uqVpilatE?Bvp neVd$@Radioj Wʀ-aoeBlueth /oG`rgie@Ł qYI1[,(b!)!ߏ`Et@0 I1
2
3fTozRa/- OMom@0r23 UUrtcu!G< 4us X    Sa?Gekali@!тOK"r2
qNQc ualP \JOOO E WOOO[B['OOO H{ap !ң
O$O"Lpier-MUE-$J$OC$ Pn+OO+O  [jp? 1 : Bo. % ]A/&p[лd
2knte~l/{	3	#Ʉ
 fohl/)1* Jt  ;@>.C,$ VęçaդXadap Fpr(0sec.)Cpop-up bij sno F12 )Kbb@ cursorytuyEasyPo-muisG> DMA-}drB BIOS  Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe߀ ɿւa\w܂tsfBNɕۑ  ݒOCOF畜>Ăg&f 
H
g  Hꏟo׎ <
ɖE	ύXɏI e `AȌԻ܃@ea L(eA`LCǗW҃p h/do'o "X yf@\̗L/cE%ID&ID: h (uN XBSA$폜eX} 0g J8 23T|OH, @v".eI*"%ɀ;FX
 ؖ>'f
cA>oAe̒  II(f:nA%e> pCeBI;vC"F@ `}F  H D%Jc9J; ڍc R5BM NP$߂Ad%E@U`U:O tB!#sNu %.37($b74L[BR h=~!AEsc=Cq@bsAS60=͂
  <aRAg)gjq5\{ 3gp] jkڂQ %iA@gp>[Ez]  e= >ȉ#wA̀r_->Epy`tOo[ = ET  <-SG[BackSpace] xa%[Tab!AG#[Shift]+eF2!,,,10nmF/[%  !CG[  @DBCś}@BD?rp o 01 yNF`+@~3a
ACOk ~ڑKv@&eb~ rO x1X
Mp!mQ^0fGdMEU		?Ȃ2󋽵e`	уɰ   ۾  xï  ށiL1/L2|"OM пOM̧Fرٔԍ  ޵ ޼ޮ ް ۰ׂ{ްޯ ްir? ޯ*#2.3N4h	? pŰch3(ÂC)FE-3N4(JkvJ" _!nFw 3XcopF?1$qv 标sxП6!̼;LsV+W7alk0s?A-1B/Z hѢp^`OD4ߌx:2B}tƁACN %C颴 ׂĎDa/ŗp>쐬AFA:/݉ b>#}v!hү F FSPl	NXWM~@YqZo s/9@y(c  ցB	!H #ċ g Oog'`,گЯ1iNp`2iS3p.M.A.R.T \zsԁij: 30Bpײ>v0% bj!c OK z43 eB~ 'f{:x@	{em`Q1kTz {ǂݨUעfIFIDP. Ba"R`R AFfV!'/i `¢k@@dAJg(B(a ͈DAJhvٓB"̏߼ /  Ǘ7߽@{R@ȄrRVdNJǂ̂*p4u`@ȂaU@C	 !]ţF"^
Yꍇcxei!ݡ£	8龂 ÉƂ`Ƣa7df!f
`?"dHP ProtectToolsh}lWŒTBq#j, .qB4УMmUNu<"T҂ h8' k){-E`O'@OH&J8-.))Tی?D<yD%蕴` g4`dt!(!ċN<b8v"񊰔Q Ԋ'O GPuA0V @QlA [_aMB6
Wake on LANh CD
-uDH3ha`#}`^% WU:$|UK/@'i G %b'2EyEd}Q@!|;p&	7`="BĠ!/ Z?AT ?A !i%R0bi	 3N	i EAAJ	͎RV] uİRgsALScۊBsBJaJ/+@ae{eV[ QI@r`Я <@;R$\pۏ؊; "łb_͗L@ nł<`謎k)/)%)A D@Y]7Ssny"*FFJa(o('i.A n$'m!^\ ( IO)F)(؇ u
((?(\9(g D xdz#<43㑶&ƈp)Ms f=ɉeЀ^)f/P)F1"j 8͢cB  B'x0ȑObEOCFh2ef B&8Ȓ╾qlkC aU"1/g'B{EE[Esc]Q@<ʀȍ~elmTn?DriveLock tO[F10>A MS   y_Y7$>`EA: ESxtkGbǓO xXioi;EcUSB X p@H Zip&1ԖW 2b 3 4"U567B8910r Fn/Ctrl%̐ؑ {`\p (USA) `| B#foX
KV1&Ws
v@C\gĉ `!}ZJ`_ rIo ޣWo%ACY@Oڑ͏̧공alBNi!j%MdBluetoot$`/cj!ς0 d p
 2Intel  ExecutiDisable-H`++1)2)f++odhEtherne5tX 123 g!q
AOKO3O >H!Op Dj' ID 4bcK AM C     ~ϰӀD`f`R? kejZ  o \(%
*nP/h/!!!MEU t$) ozoooD2s!5bv1 : [dϒ . % ]O<2 !gOv3		)J	*   5`$>s'pmj&vSpeedStep@ technology
u'"( 	_Ħް Ӱ # px(b) 3F12QԁiAby) G_R !*^`bq[B  eBIOS ATA D?MA]K                                                                                                                                                                                                                                        /                  ` a b c d e f gt" M           	 
    ؓ  
         8    *                    / 0   3 4 J 5 6   ( ) $  , -   * +   np
 N % @.   0nnHn$n`+n1nx8n?nEnLnRn4YUn `@E<BB<U> FبE0`8l v x|v||p/0p7c   c 0A   = ~ 
=$$$<   DDD    O ae  i  o䔕 u  oy $n%Ap E%  IC&O p   U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( )' +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {{VROM+*'(

C$: |  s+'(?)+'*&83&

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      g|nA  n^@  .@  bGn@ ED U@n_.nL@)@ I mp  ?q@TrA*rBrCsDsO*uFTuGuHTvP Ja 7 
n9 "en(dbncnVfngne@1@ h@j@@W{Xt|dU Zrt}[}#L  ]~&  W_t`$itVa!
U	$
, 	N 
gU\
L `
T	UabcDdeDfPh(>{&_^`|`n2@ \ Un x @
 j( 
( 
r l0 m | o : *R  	nq$ $} 9 UD VF10 Setup Image_SETUP  P0Sq  ; 	dP" *v@HJ$"P a|`j 6
&$`ZԩC ؄ TUԫTԠU*<g!"$Dcz: T'ᴳ4㴴U4崵4紶Ud鴷4D9b` : (7  )$**$++$,*,$--$.C.9 .hໄ 0	`9G E$H*g4jH@ #"" $" $" 
8 b
@JNuOPP 8 	;	 
      /	
n&XP  b" u   %    P' '#(!(")Q)R*S*T+U+V,W,X-Y-Z.3W
e/di0i3djj4dk5k8dl=ldmKm[dnBndoEoFdpLpG$HqIdrJbznUpqIr$Js$,i]`||| }\|f ~Z}Ԫ}}`~~`~ `*tuK wxEҔU~z{t  }tl 
4O5L5(@4 ^`ypJfԖ]` UddR]eS;U`
ff N@9 yԡ  &MR@ \ b v @ܾ M@ @ X z @ @M@ . H T j@~ ( ̀ M8@ R r  @ @M,@ L `  @ @暀@ B Z t @ @M:@ ^ j  @M2@ T f  @@ V* z  @ 	MU@ & : N UZ@dp U@ }@
M*@ UB V n @U @MU @ @ `  ՠ@ T @ @ `  ՠ@ 
TC  . J@Ubv @ծ WM@ < ^ U~ @M @ H \ z@ ր@M$@ 4 L ` @ @%@ > T h @j @@  " & *@.6P h@ @$ -@ d   @M0@ Z   @Ȁޚ @ ,@ Z   @@1@ 4 B P ^@r @j @3@ `   Ԛ@&@ v   @OMD@ t բ@ЀT>@ j   M@7@ ^ Ռ  @T @ ^   5@@@ U: D P b@Ux @UԀ @S
@7@   U& ,@2:UB H@N`Uj r@xU @ʀU @M 
+@ " U& * <@BHJh@ @  =@ * F f x@j @!?@ > V z j@̀""@6@ r   @#@ n j  @$@M@ j   @% 0@ ` ~  @րF& T@ BL U^ p@ 1Āޚ @' @  . 0 4@8<@ D@HLDdfjnr @* @ah @؀R(:@ H f Ւ @
)TA@ V ~  ժ@΀*TW@ 6 B \ Up@ M@+Y@ V |  @
,TG@ < N p U@ M@$-@@@ 8 UJ R j@zU @S. C@ P b U @S/L@ \ | 5 @0I@   A	@1{@   
2 f@ n   3T [@ , @ ^ Up@ 5@ր 4@R@ U6 J ^ r@U @M 5@n@ @ L \ hhhhAh @ @I6@r@ J "n Ր@7T{@ B f  @% "8@@ \ ~    $I9h@ F hZ U@ S:@ T j U @ĀS; @ 8 H Ub n@x|U @5 @<@ UJ |  @S=@ r  5 @$>l@ l ~ hj @2? j@   @l@ H ` x T@h @MA @ $ U6 ` @5 Bf@ Un   @S&C@   M *D@@  5  ,E@ Ֆ   *FT@    S:G@   M *H@ r   @h I @ 8 f  @ @ @J@@ 
   @0:B R@hJ @hЁe@h hUKC8 V x @hĀLhLi@ n Ֆ  @MT@ d   M@>N@  M .O@  M *P@  M Q @  M R@@  M 
Sq@ r U  @T@ t B @ h1$U@ L l hvhhQDhh @Jh @ASV@  0 UJ \@ռ @WT @ V   դ@ʀXT@ 8 B Z v@ؚ@Y@@ T x  @Ꚁ
Z@ H p  @* AS[@@ 4 Z Un @M  \@@ , U: @ f@ն @]T@@ `   5@^@ UX   @S _@@ X l R@Ѥ @؀`T@ " 8 J Uf@ @ր aT@ $ 8 L U`@t @hhhA@ހbT@ B V j T" @Mc@@ N p  @%j @dR@ F  X z U @ƀj @e @ J h  J@A@@M$f @ L U\ t ~@h@j @gҪ@ V   ښ@0h @ *   @ѣi@ l ~@ j@@ l  R @ k@ 2 L X j@~ @l @ P r  @Ԁ(m@   ֚ @0n@ j   o@&@ d   @p w@     q@@ R |  @Fr@ 4 H@^p @ʀ @s?@     &@.6> F@NThl r@U @ڀ htR *TUd @iA  uU2 J b z@U @M
v @ d 5  (wJ@ 5  2x!@ 5  0y@>@ 5  8z@ 5  B{@ M | @ F UZ | @e B} 4*@ < L z Ѫ1 @L~h*DhL^dJ@nth@U @5@?@ UJ `  @5؀(@@ UH j | @դ T R@ L `  U@ S?@ V |  h @N@ : N t ~@ @Ԁ
@ L b | @Ī @<@ P l j @ހ  ^J@ F n h@՘ .$ @  h UҀ @@ > hL@dr @  f@ 6 P j @ hހhhhhA:@ 4 J \* r@"5@S@ UJ n z @Rh%@S@V@ H j U| @  e@ h @ F T j @ Ԛ@@ N* ` p ~@h% @ќhU@ S @c@ l  5 @P@ Ut   @M G@ V Ud t @5 @ Ul   @΀ &@ > hUR `@p5 @j@ Ur   @Sl@ L r ՞ @"T ]@ v   M@ @ h Ւ  @T q@    S \@ N r U @St@ 2 F Ub r@U @ h h Rh&>@DRd v@h$ h@hhh@.) @ d ~ U@ Sv@ R p U @΀S@ `  5 @@@ |   T@ l   S  @ d  5 @( @ Ռ   T@ N v  @؀hIq@ N hl% hbhDhhh% ( h2 ULl x@U @S @ l  ո @&T@ N v  լ@ƀT@ H r  خ  @ ^   @ڀ @ T l  @ @X@ D X z @ @ 6 F j x@~  @ : b  @̚@ J n  @0@  2   @ U( < V p@U @5@ Ul   @M@ \ U  @$@ L hhhAb @؀@ \   @!@ 6 N  @Ԁ@@ T v  @̀U  2 B UT@h~ 5@ @ Uh   5 @ U< N j v@5~&@U @S@ T  5 @@ U~   @+F ^ U @S@ v  5 @g@ U* F ^ l@U @5@ Ut   @S,@   5 @,1@ Ղ   T@@ j   M@$@@ t ՚  @T@@ x   M@*@@ r ՜  @ƨ@@ D V n@ v@ 8 T b r@z @ @ڪ @@@ T ^ jT z@Rh@S
 @ `    @ @ N p  @ڀ)@@ R  h5@ڀ@ p   T@ p   S@ j@  M   @ ^ Ֆ  @T@@ B b x @B &@@4@ , Ѫ1@@LfD hhD4hҀ@    (A Hdp x@ @ @ J t@    @ P@ D V p @&  @ 6 hU^ @M  @ T U~  @M
׀@ J \  h @) H@ J r h@h@ـ@ d   @ꦀ
@@ P v  @Ԁۀ@ L  j @h4 H \@v @j }@ N j  j@ĀހJ@ N t  @߀@ hhh:Xr @ @@ V |  @̀ (@8@ | J  @A%S @ B \ Ux  @ T@}@ n   5@
g@ U@ j  @Uƀ @S +@   U "@.HUh @Ā思@ n  Ě@  "@ \R x є@jh@ڪ@ H t  ڦ@@@ 4 HJ X ^@сnU @ƀ5 @R@ Ub   @S  @ z  5 @0A@ ՚    Te@ f   5@( ]@ Ղ   
T @ t   M@6 @  5  @@ T hb z@ @h* h< P@hZd hlt |@Th@ @}@ &T 6@NVRdр@5 @G@ x ќ @Ț  @ X z  @䦀@@ D bR  ѶS@ t  M @ l ՘  @*T@    S"@p@   5 @@@ UX p  @jB @B@ 0 1hH%b Ѥh"Dh@hM K@ (A J `@jt @ؚ  @ D ^  @ܚ @ B ^ p @  ]@ 0R B h@ՠ @ W]@ J h Ur @5 @@ U< J P ^@Ud @5Ȁ@ U4 N ` @U @}]$@ UL v  @M @ T Up  @S@ z   ƀ @]"@ 6 D d |@ ܾ@ ]@ , B X t@ @	@@ : D  hhhAUNj @@
 %< ` v @ @ 
@ %\ t@ @ ]&@ 6 F V l@ @
@ > T n @  ]@  6 F T@blr v@ @+@ \   @
 (@ h   @>]@ U@ X@5 @,$@ U   @5ހ  @ U2 N f |@U @}]@@ Uj   @S7@ F t ՜ @T@(@ h   }@]H@ x    T(@ ^   S7@ p  M 
6@ D t  @hj @@3@ @ b r @IV @ ʪ@Ҁ @@/@ & 6 N l@J Ѫ@%ր@J].*@ H d v Վ 
T@@ X ~  5@@O@ Un   @KM@` =@  M !&@  M  "@M@  M (#Q@  M ,$ 1@  M 0%@G@    *&]UR@ x   S
@^pE ђ@с1@'G@ T hd@hhDhѶ @Q(Q@ a$ > UH@Pf ՠ@̀$)T A@ x   S* a@ F b U @S +@ J b U @ƀS,V@ V v 5 @- k@ U0 J l @մ .@:@ : B T@@r 5@/h@ UR n  @վ (0T G@    M@1@N@ h ՚  @2T@p@    S(3@   @ʀ 4 w@ 4 F P \@x @
5h@ N p  @ʀ6@m@ Z   @hhhAT@؀S
7@w@ 2 J b @"Қ @48 @ x   @49u@ ~ j  @: U" J h@5 L MM;j@ > UZ  @5 <8@ UV f z @U @UҀ @S=@<@ n  5 @>@ Հ   *?T@ x   @@hP f @2Au@    B @ & <T J@nU  ӨM C@@ x   D]U8@ n   S
E @ d  5 @(F@ Պ   GT@@ n   M@*H@@  5  6I@ Ֆ   &JT@@ f   jЀK @ @ t  R@Ԁ @ML@@  U$ , 6@@UJR l@tU~ @؀M @ J
 4 DRZA @N@ L r @΀O@@ 4 P l @ @P@@ tj   0Qj@   R dj@   S@ ~   0T @   U @   Қ @
V@ >J ` ~ Bվ @ W@t j1N Z p@ќ@hQDhh M@
X@ $ A@ Z@\ f @ޚ &Y@ n   @Z @ N f  @ȀԚ [ @ 8 P f @j \@ V t ~ @ ] @ R ~  @ @^@@ L r  @j _ʪ@ 4 `  j@`ܪ@ R t  j@ԀDaj@   &bת@    j@c@ݪ@ , B R \@j j@ڀd@@ D ` ~ @ e @ d x   hhhAբ @fT@ < Z x ը@ʀ gT@ L   զ@Ѐh@ Z  @ Qi@  : Z p@h @Ԁ j@@ Z v  @Ѐk@@ F V r |@ &Mj @"l ª@ d   @m@  j  @$n JN ` hը @$o @   pT@@ . @ P ^@hv @ J@q@
@ x 5  r@ Ub   @Ss@ t  M t@@ l ՚  @.uT@@    Sv@ v  M <w@  5  *xp@ \   ȪP@i @y H@ L ,@hb t@ @d@j @ƪ @ z @ @ TI@ h@hvh hh4Q {@ \ r ѐ@j |h@ 6 T r @ i} @ P dv@Ě @~@@   *@   :@ Ʀ @F@  ֦ @@   0@.@ x   @Q0@ BT j @h1M
@ B "hT@hhpDhш +M h T=@ . @ b Uz@ S @ L r U| @5 @
;@ U* > ^ r@p @@@ J n  YM @$.@ V ~Q@U lU @ʀ @ F  \L@X ĄXհ @$TK@ f   M@& @  ՞  @(T K@ z   X_M $ 6 F@\p @ @D @K@ < T l @j @C_aM   hhhA,A U> \@rU @Ȁ "c@ Z v@   j @%2 N  ~@ @)V@ 2 B UX@z 5@@@ U, < H f@}NM U@̀ ;Af7M@@ U8 f  @5Ѐ"@ Uj   @ m@ hR fT ѐ  @M؀q@ \ U  @ƀ @ g@ . < P V@ftj @`@ L l  j@΀ ٪@ ^   ܦ@@L@ V   @) y@ r  M@@  բ  @*T@`@ t   @  m@ 0 N j ԀvIM @s *    @ȀЪ @@s@ & JM@ B$^ lѩ @^@ hJ b z@ܚ @@@ V v  @Қ@@ j   0 j@   @    .y@   @    ,@ f |  @ЀVB. @ P `@1U@ &h&DhhFTZ fJ@ntB ѩR @j @ Z@   ܦ  @ 8 N p @j @ @@ < T v @ $@ r   @ր&@@ n   @ @@ 8 T d @j @ @ < B f @  @ h  j @&@ f   @@ l ~T @ռ @T@ , 8 V Uz@ 5@ @ UL z  @5@@ F V hhhhAb @ I @ J "l U@ S@@ : \  % @@@  UN z    @$ @ j   @ހ@ N h  @j @̪h 
  0@N Ԧ@ C@ \ j  @*J@ `  Ѵ@ƀ 
T ,@ P d  M@  @ j U  @i@R@ 8 7P `@Uv @ S@ l  5 @@@ z   T@ j   M@$@ z 5   @ p   T@ x   Sˀ@ j   @@ HrP  Uf@ U@k U@ր U@FjS @ * 6 UH b@~ @ѸВ  UQ8 ^  @ M@ Ѐf  π@ `   @Ѐ@ @ j j @ր  N@ J t  @@ \   @Ӏ@ j j  @p@ T   F@Հ@ BT b p@D 1_$UM @ hh.@@i ^@dц @Κ @
@@ P   @ަ|@ j | @   ؚ @ـQ@ 8* R  @5 @ U< X t @U @S@ H l Uz @5 @ @ UP d  @U @S n@ . T Uz @M @@ \ U  @S@@ Z  5 @@ U2 L V ^@Ulx @U @Ԁ T 2@ 4 F X Uj@| U@ʀ @
@ * hhhA>Vp @  t@ "UP x @ƀM
-@ L |  %ȀA%倆@ %BR f %5 @ @@ U& > d x@U @M F@ P Uf  @U @ڀU @M@@ v Ր  @ÛD |  @@ P x  @Ԁ @@ P ~  @
 @ L \ jJ z@Ѭ @ހTm@  2 x M@X@   A @    @ `   @I@\@ t  M@N@ v  ;;0@ x   " +@    @@ " , b@D@`J ѺU @@ M s@  U   @&U.@ L@TU`| @ @UJ6 b | U@ S@ D j U @M |@ ` U  @S@~@ l  5 @ @ Ux   @S,@@   M 
@@ d Ր  @ T@N@ : X p @B ܚ@m@ .T 1N T@lјAhѸDh  m"@ ( 6 P VM$PnPn/ /      ^    
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй Us# hNfP u	fXc  h UZY[Xg&ۅF ;9   Ã tfPfS
u	p  Vf[f}XRg&u-g&
pAgf&A"f,  ,ftvg&Ƴ,9g&PESWVfW&O*f%,g&D= $ <vD# D| u:t'_^
QRfU

}0tR>tK-tE$fu
0t0t	dpp  f]ZYPSRi u-@Sr-&-sG tu0< 0
g'fA$. +"(wZ "P  u
P! 3 t
 SQV3Ҡ---  :-tzffKf- AƜ(Y)9wfP98$Њ;`	PdX,)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>8A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
,D$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	V, -ff@EFt!hXUgvuN>tO6f뿢, Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% ,SA _,# XA	u-->r&BZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@_))FbfDf% ffDg^Z# j00f 4sp*2{ÀD6^U^nBn@& B7i({Pfpsf
  @WXfffL:0[3`'E8q4ж3U? L؇PgOS?NYYYYrZ1q\~YZ ЍSpk< w 			;/eE1`eR#tZVoQ`C F%frQfRV-u/(` !	q
~>  wP   8=h0( Q   f3۹ fbdTt ` t0Q ?\8ZFfCPŧ@sw$<yk{s>
p"o
d
\KuO@S1y?"踡5`,~KuZO苆FFDKu FQ$߰P-$G^f  @s, nH^D	%ÉD	f:"-fp<v PfUJf@KfffQ$f6f> f	>fBf0+ff]X t p,̐Pԁf,_z0R0Ӄf3 Z`R҃>_ t5  A @@!`0Tӳ
@AԟGRV&H:f;tff) F#$Aq$e$ sqSf qgfÈ>  fù f{AB;tݿ)gf+ C kBwPEZW`)Mk ӒHGPV  ^ h2 ;uБ; ;b 6P6UXfۋ.0XQ0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSV      Z *8۝6ܟT  	1f  !a
  	   ! ## U .    " ݣ2 r	 _.>  B
   ,!   p      K   S)+P-&-1!Bru
>- 4\  >  t--->--u ,"_< tC2`r-Bb,-,-HQ	z`PxB`
e3ۊ؀`,&-,-g3 M-pVSP@t	V,[^@QV, "0ՈX,P,Wf uuqS1L,T,,?-[^0ufU_>,-S>->-G&- t(
ߠ,R,D,[QpQxVt>-- r14,w%0r<,&,6|0}S, E g6bdhE߁U!U)H 8`@yQ	胢|p%t14,h[3- @r-&-], a-6@RVqp7p	* #*   , &,{g&&@v@ '1&s0 ,J>,zy $	3@ % u> &
ڣ'
u$uvatue&u^\uMu:
8FPu)t]tfpF
= I_L^!X08! u	g&AFtF@s|S$,9ϧ ~SRV,W^_ߊ»,rQ@1Z,`,h,p,x,_,,5.rtvl,aP%W>=,SRC<v
2-,-`,ʀ 7,G!^(r ))4KKұNS	,$$,,,:,w/\,g
O	߄cЦd
	,Prg&17tt,7}Wr| Pdr!"d,Kr
 JtIx Ztĳ,=2oN13
}	ugPaF$н0]oX]Zf,`]`]c,_4<, r+bSQ <-f3fRγa-ff3 \0|pF E *  <Fu-3t	 Dt<Hut26t6 W2$u tPzXv- 1- uB<Ft<Tt<et<t<t<Rw*<Ir&-
2tt 6>0u#6MPqurqVCVWpքtAQ ft(P:-u 
  gXfCYqq q9~ w2-kYⷠ埠t&-8r >t}Ѡw
$_@,-X-2 ,f? t<C<tSQ0ذ&Y[Pu
lq.x  @  	`j zWP  88述 4! !;Ł @ i[\\oZ';S;BBRST4U=;{; UWRQSPV 
rw8t ur6ffWRfP0 eXhlf߿Zf_]>8 y8-aPS9 pu8@888U/88D[XF f sf翰@ׁtfۿ@P-[YZ_]e È_88 Q 8Pj0fdQu!8! !ddfd԰  >~P6Sd ddP |(88 fU t= T=f]t,>@u%ttt t	tfN tF !r@ual!s
 1Qh 6yQuFk 08wu${
SfQVێeS 0uQrt}ـ?PfD`*f f0T ff_fXs "qy#upELe8 ` 8PuYkfP$ fe8RfWpe*&88fw*fF*2t*܊e&8fXfY[f`a@l'm!(n[8  ݅ޤy BĀu!Ѹv8W߳ t8!ZWfaSQVWU&- t ui]_^Y[LS-120ZIP 250:1:2:22PKw
 z
\5	8)Ms!Org;<tV< uWQ4=f<P\g&:D=FfG_(:*X!X  JA`u 8ا-888880 RW1h/
P}0E?>4/_M-Sys   DiskOnKey 1 #aB-u @  f<x fP f0Q_>"~|= 2r 0w"1s sU3IH tR ff@fPuLst6Lu2r{	uabc\,f_o PA rLTf<?QRRVPeF5Qome}E2w߆;; t0h$t;@ u^gu#3 Af?LfH@p 
fXuײ?D0 @0B0B0JB0B0G05F6F 	 xϋ&3FPRrcok3W1>ߊ#>;!2>
1_YGhMPh`p& 4  ߰hN0< kZW+ 1s!$?
uo$˄[         ,X @xKdY rTBB!h5@  i|X  t   	bhN"ofHffBf[hPJf&Kdh\ufK{dw&f  ffBfP  Bf%ꣀ% @ BBf  z6f
Cf=A&  `  fAVf7C`Df=%t 5t;@3tZ0tZDfX$0g]~C  BIoBSf@ t|PB"sƑ tDf  f qCB<Cf߁>B u ` _oD  2ft.h@P ^#rf6u$B@s11 >٫B@!R0[B'r"b"q0 f!?1VC@f,S	  tX	"riH'	"	0 
%9 uf-%tq00 P3BP J 	PB-tK '	B 1-  rf 
 pQDP؊*C@6%f>	CgGf	gOg}{G]`0db>?,"3	0	[`6@#Du	%&hf6	C?f	f CfIng^g~5W!
*t4 ~0		0		  FFh5jJ<t
 &wK5"p+u
 "؃ CK&KC&ףKqN&3jbL6%@( Bf (f 42a3ufBW  bfvt0awSgff9Bu gF9Bu 9Bu
gF9CtgNXfFCUzr=БC=0rxiGsVfS'`c(gF'	Bg^n g"G0gFu V* /e*emd&b&g&g&G
G
 d0Gd*PGg&Gg&G
ް G 3gn FpBq	f AkG^ 0\PfV c?sf@mdf p^fIf!B&BB+B(B  B < tB  ;vȉBqv  f@ư
Bqygf{gG p ,gG
	qGfu"a ?Hf%f[E@ !gG!&BB> t@bk!f#pBf❪cn`_2Oâ'PR7з[fS
f3ΰ5f$fӃ\Q?fp#{-  !Si|y 9AtU ````a%`b	`c	0]	0^	  q
		 
	 						
 0hfWQf-`!Yf_`QD=f8D=8IMD
$>8%
ĈD
8r% >w8bASYs)M8|rI`d
Qjr7R@|= USBSug&|= t t
U	_ 	`_8 T 8ѡ p arQgr C0Yi %y P`yM`2P>8t QzrIt2QfF`AdYPrϟSf1fM^!WސA@MH\
؀eܛ\bJ
prA
x @
`	N!?
0
"osTq
aWa'" xQ# iD=q8p*W.?4o3'PfT2_' 7/oZ(Z
2(
_7
_=%t9I R$RS$2Q	@ ?R?@RP2 3* >{Qu ᠅ T=
XS<(fnT= & y#j688 r}fPQtA3`>8=8p+` pta^Vu6 8 +.Rf.6iROPpYfX`RI|{G<8 fa9?,B3U+=*/G/%?QfPfph`1@YfXY"gN0\ՐJ?;G7/O?sc?`sMoDA/BA<e=vS$l=38%rpp8Qt| Qt Qt8D$
ƈDFP!r r
9rYԹߖ /p%tFPtt=tT= t2:t+u:u hNodty(u~(rt{^@Q=@tQ=tQ=`	tQ= ?Qh/)6`oXaPSV88dtd}*Ѡr$oѾ88DtD$PQIMPhРd^[XSQ)MO	8t`g	G	Y[w - i8   `  8 h
   0p   
		 
							
 

 @ "@6/a5 o8688hǯsRoI
YR&n8e 15s fޱg&|tzEB] [1Wlml	 		MbWOAW`zX&m8rm{seÖXQoXp8S RsQXHS r`QyQQQ-QQ&p\W3
	#[rgAೝtÛYc[5ϴj~rjstxy6Dسtq=g[c[زtOtc[sfh~  0W~~	~	~Y~~F
,}}}T `͹ !sJ%Otdoo%"o:u2;qqq!(~rgpppp2opQVpWL	;t	wʐ?ʶozX=^YpZWpp"I 0   0    Ro d    n  A` r 00W 3`  
& Aa %  	%
0 #
*aq
| 
%3`@& <a`t @@ 
b
	CF(
? ?a	  " d q a	!? % %@%
 +3F	 
+  (E+
E3$ 4̂  C8$+(3+ -E-(C -0294- (`( E E3 .c+ ! 0
 @/9F. 7'GC@<6A6D
 !:7' "J", A!E?9B@,3
.O<bJ# 
 S!<R"G 3D%M  TVaXCJ UK8'(hXAIc  WI B^eef]ggMhCopyright (c) 2001 Intel Corporationf`@ f.C<t<t$<tc<tK<tSKdf&Kdh sfKd   uh   uRfADf380=ISGuђ s
g]Od~!t f6[d	gftcRa tpt5Hh @u  u u0 ߰# 92  u
P f%63 
f>CfDt	u)fC;Cwouf@ffh5jUtf3ۊf"Qt±
07fs
.B  v@#tz<21G݅!?<ug


7	u\	Qn	'h`/%_CKf6	C	g u%S FB s@[%;u!,f=4R0	ff4	)ffp	Q(f	f@f[aSfSfQfRfV*sWh15 {uBT tApNC6g88fI4g^f3f@70}@7f^fZfYf[{fP"Vf0Bf=`Bt"f=Ё &f={ P/f=0 3f=@+=t8t34 , 't"#
ttfh0 rfFP0fXURf.  fXr  s	 Qf߀ufQD8>@M ~TR2@(2Of2?f0cBZ{RO>V\3h0( Q  uf3`_fbDf6E  Z<tatG@]_ToKg<u	?	upWJ$< t<0t$ RHP?y"PWT%j_uPlAPy#,RfWPR;Crfc%1f f>=	f!Effg8u#>_444
sf@[Jf_,,PSt{㻀w&21=`QYr;f.;Ylt3UufYilA<mpfAz_ffm fPtP= v	 +v:P,P}Hlf́   :HlfLP P 6Tl1|Ã tL;fU ǰǋ;PtXl} Q.XlBYrrf@u0`b h1-Ñ$~ar~ffpWf`f"0~ffROMIfMAGE0v;uq Wt#g0 ~yKPQ (߹J 2 ofG f_ZYXug&wago&GwG0  "2/t"_t  V {  cu'[0i&[w j3
G94g&GGfԣ fCf-+ӵ00pD;gf=7%   h쀀1"`YW, `П.V.`B@~
>t1~a"pR ZoWR  oP&abpZ&&FdOR< uQS/RpBgtXr),uRG`SQr9R'$8tWYOtr$V簄O㰆HAr(QSFr(!zsqtrp@ppmq9P`N `4fq48 f܀g'p!>~@  ` FFBZss`b PQfWfVEUU &*4P U hX-ULP'G@3 .;qt3 _YXhSN" `#no0@	F`ٿ `l"'`sJ4 "`".-2'.q q#80? pgW
sfUgg& suf3ɊfXl]tVfY{AfWڳ]g<t,fUzgR r!8tfGpPQq^$@'}a@8tPUvPCtF X PSrN&0tp .t[XPSN?0taA@f!.?SRغ P BDð1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                PQ 蒩tu
YXP@ k` ؠu 
Xf`J؎ Rf切u Zlfani   @(00	zf&Ef ߸ pDp   &Et"D  $D( s o`ف&tȀ 4>2@"߃Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m ?
 m pj's 0a` ar * $mOQa	 & aSQf# $$<@t"hXfP u	fXc  h KuKofZY[ުKuף`.>qst&3r	&*r/.D,)șaô`prr X ? trKC0}qw1#!8Q909$a0){fRQSE[YfZt'1 tt' u
| t5ar0
ADmG>  &f    htruf>譽rfff0Gf  %fq@ffr<fffHff#f+ִ f;wfgf&3g&Sg&c
uff+f
 >,-./01289OG     K `a%
 3 /_;RRF 8%$a,PG3""
P![2t*:*`>@ l>0l!GA lBla6$?C ! -G @ A1 }B  $0sF ~ en "  BnnnJF$a %?JF&P '<( tq )P *̠̡++ޢ ,  @pllB  ؿ< lBB@l_ l@  Ղ  @ lпNLz&\'߿s߿y /$ 
@  
F_Fn  	n	n	n	n	n	n	nnn 
  t'&a  ,CdQ̀*)`  3nnC q
p		 nA
` n݁a44aPfWH4g&g&f_X'=                     S 2&0 Y	ɀ$ t4/T Z	Ћ% u BZ	KnqRPt@B u$ZfQWP !lXgg_f@f`|Q
`fgfQRfWPSf3f3ɿ\	f0<  P t]
f; X tDt[	[Xf_ZfY<fPffffX,wfV>fVf PJE gfw^! f^	V					:		[	r	^		f	W		fWWf	_
g&' @p:fPSQWV!  tO
##"}A$$hoԧTQ sY^_Y[fX>uD_ f`8P%a|w#%z  t
ف     tsPR΢0@ZX4@ t(  7Xt
 %@  Pé t u>
P?
 q U``@`3t%%tNtG!п ӿff3uT0ff  
fα+ mX  R.Q#؁_ ~U~	c	%@ Q#Y3#P!` ĤP]7)5ˀ 2 &%?
 PraZ ap	b
x  uTγ # r`u;
 j 
   @,b%?t
z<%pfZp'*Q $f@$f#$S%/ 5 Aq p#f1E- P
 0%3ff W0$# %3 uu
  &qfހ+ZYf1PS4~ T Th7D߰H5,hN"Df f /
9R025f-;4	-O#&30"؀P2@uRtt@t
n1guf
zkx B`jt 3S+[C vS3ۀ> t9t+t:+tC 02t<w>t8t~@蒧 >ñ  S   t, 謧 ~+++pﴧtrz"k5fP	RA+rA a-	 fXcftz3vspP	u4Ӂ@6t1-w&,.trwRat0
p
]< t
^:|@ 0 m +@>@u迦t+aÉ_  ߰HA>

p2I2J@@P2ؾ
s3y@si  Y 11F0457:4u;pu;th@P] ÿ0s]-!  ww
{210r &	߈&!
À
v >Ͱ2  	22x0Npf2ptE p  P+Gh5Ft 2Q ]b /$3P cG4!dtC Ʊqft.wfr3A ZqA   u1 U dhQ)
  '  P--h9a@$#4"b b
 babRp  ZPQu4 pyKqb 0Y0R?- h"	
D2
.&g t#. N' T
n.t&*ǃ0 0`RVh|/{tDh^th]l5hm7r2, f^fZf`s2 |=rb2 <SXlTFrhYfa_f`X
<  Pf3//n?@N X!7"" hIy#٪Qf`/)
4x/O
\ "	} 	 R"	A/	(	!e&!_!!!p!h=4hI>=^w}G	qf0&3u 2pĂRt F<tP$rf2@ 3d/tsfQVW.R 0 _^mY}Tf   Df!yfft
t%Sygf5rSQ?f  P^WWVhi[?r=ыt
 t
uu	  tt uʋ^_fQf	:Eb3:EF c6W p 2:> u6 GHt\o ?hl/T3Ҭ؋B^_fZfSj
XKބ
>
2

VT>T2"@OHp
Nt.
O|rRĖbǰqU!-2
!82-/ 2cB"Cfo/ / /  O-2m#<RwS2.*![pPø  аPIȟfQh"_4ufYpډpډq)aEf3ɋPAk`qXp&G     &Wft ffBf;Pgf}ww~rtwRtpff@Ohp3QgfY tghoꗾAAX0Y[0U>aPS 2heWh`2f[  t7> uߴ}# o$>p u0R`	'b_Cؕt+!貔ĕt軔2#谕tP Zs ܒ`t
胓 3
> p GQ	du=	7qQ_RYP` u9 5r/<t+t&u
$&萒b.va@p@t"tq2t 5g&G Q !pv@vu蟑<u>`v&Zt_{ P%%  &%%
À{>0+ 
8s   
t}V$<
v
ط  
 tǀ>% t 
$
ؐ 
h_e$0'
d t㋷&؊ _^qho

p4d	`	
s	 O
À+:tu _%&%5A %%>% u
8wQ'&'1'<'G'R']'h's'~''''''   y`pp A~ _'à@ PP ~̀R ĺZX0R,:%  3` ZQ1\  qKYIef 33 3ðG	}  8  A.Pĳ[	P Xu?¦BxD+	bSz!Z u2  [22P гX	[@2XP2ې1ˀa	$

	Àu)<X[X faa
2t lP@<KrK<PR0Pt)<2.t)/BZ s  ""
ZP3@)) Jq vJ_úQ R (( PB/X
	٠ذ4Ðם%fQSW  _[fY}΃I蛚  hB M ( wIp&QW<u
y{ {`_`,+z |_"J~EðmhVAl6祿2 0,2ۯ! ڃ %%aV,% s   % -- r A1/-,2`,%H13 g,%! ,2% ,,,,",6,h1aߒ,%Y , 0J,% Q0.&,f,΀k>͠~  lf,f,23s 2dk`kcޫjUV<2j2 Pظ R$@: e?i'[.hh>='g^]gg2 	?s`6 0wtiu%h؍u<_Ŧr7~,px
®.-Q~1w`@us`
 s
R.- eqbpI= Ipb.S r`y- T蔢r<w-́.t 謴r_Ipu_:V<?2f.fÐ6 ff.q Yh<0?>$ a:r'gk.b rkB< ohup@`^UhN/.J/ 0a=
03!49+t
3NO+t3GNOUN\/U/\/&Nc/쪺zP aT\/SRc/`Ŭ`t.oh}j|YI  %uuu&gq p  ׍?[hl_EPoXh<"h SUvP0F `u PSQu&0&0&0[XPSBw0ࡵ00+'o+)G1&G1G1\qLrԸ`Mà0
j耫0 oPa qU 蘓Xy FS8rddpr1S<dr 
d2tװ	p'2w貲1ðSÐE R^H&賡@0a                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         駮!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( .(     ښ  Ւ  ς  g `g  h }  V  ;p    / :h ΄w; ЄS          P          %X%H_&                                                                                    U `*Y} `U UPzQ@    @ 	@
 
@P X@Yhi j@klm n@o { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ =/`h/fPu	fXc  h  fUf&af&>m` 6a  !ŀX[ &SP`@ /'ao&Uߡ&@r
f3f僰gf }f3fh   󯪰@p h &?ïf`f1fffef   % ŀ-fWf0M0U0!0)ffXf9ffaf 
  fi@] 0 m q:  ,f5q fPeP Q Z  ͡ՅAp  A` efaa  !6>釿eуp  ՃnPك"` eɃ w	
e} f~e&` b "jeɃffefAffgd:ugdfepfa3 ?gCT "8fF3ۊde3 
td	 Ä p)'Ґ @ v
peuxu._RTC u:/
y'
%&bfgfd.S` [WP9A`XP&EX% &E{_YǨ o2oooǸoc׎B|Mf`ffP fSIMWuUf>g0f[ Qbr6fc;w(hsN",UfKfap p`p f&?SECUtC)fuDfQpR Phl\g&XfG' 
uWf%389 Su(vg&_-$8GAxt葁; 	Gt+S跠
 ȠTT<tT_thyh R"L@	=p3%= 	 =
=ufIJOFF@ Ȁ "/ffw	fZn& t
fWf>f_r2 |f$g&׋P fg&	rSfQfR`= fGtt2t~tyf   f!f,0 tfm@ 1^wu-f rFf;r>1*: t,߳ f {ur%ArQYQ	 f_fZfYf[O   t% 
Ot`jA
A!:0.2 r&4"

rlWr6SV9rP#j   t
ff;t;0
 + t D@@D~)^fZY@ pFh^1h]lFt 2Q b rwp		F u ff!` B
ff?fLp 


ghFmhYNRN
@fPhmfX
%3E# 
t_3 v0)Q;%pJhϏWWG!V< t6߃<t13:u"FRj*:+p`;) .fY (7@ w.	Ah_S 
fUfp>߀t	/--


f+ fy
$f]^$*### z-gkXvPKs? Cn@u%fǱn  '  
羘Pg@$$$$$YcXW@Unr]oV-]Q ]E#]^ÿfRg&gth3oTr>Oz`Q hxg&	hv
AfZfVfRQ&z E mffҠUff!>  ^S3ҹ5(FffZo! f 
Ƅ
>Q,/Y]^RfVQS&>f"
 BPO9BtЃE#уhTQ   7___N [Yf ^`V/#	
 R B@  `RQ2fr+'i 
 ` 
j m0_WVSQ  20WF+ؾ8u{ `&
`YY[^_fPWQ4t44P4X"gY_fX1E  `ffot$np$Ūnr  .b
../W NA Nfa
SRV6fpr؀tU./tA
 NUN2h)E^Z[fP34PSWR7I>P u&E q LZ_[Xðh1!_NÀ> tEPnh!Zf{Ps@P0WPB_@uX 4 4 4?3PR?BZ B{ $ `%>&3%	 
  3  t!  { >   @u#?2hqt`RW0?_r F/Go'52fSSfhS?iAf`~fffs$R8 fZI@CPR|rfP@f&T ff!`'pS'b'

R)	t2*[v.>qs aPQRp$<@t hEO$zБuZY5!B>AC
q`hd1` i c ]!W0Q1K2E ? 91/fW M@< f  }t"PGbg&Gbu0B uf   κ( 0 
.uf_@5`fP    NuNa$$
a ]C PB B;ra 50}q8Qv**@
w,0V2:* : ,R~Q2RXĺZP },ȡ%:؁ Ë34 ѪD40eD
 <.G @Z__`aH G 1'_H`h?%ԥt$h bObI_6ASl`DDDtmD (og@a H2F`r[2M΢t"s@#&΢<"Fhgf
$1!/f2% @
 0(p!P!q  f 
 0XX!!f`6fgff%@l@gffPv @R
 `C  sB "a nPHl\`# u8$쨀u0	u,hPuX(t    P  b$B       <@ D ` d h!       @  `b   %H P X \HT                    x `        14PTq    _mb(YL' #`*   0 P    Paa :) M    Z PXYhijklmno 	

 K                 K _,89:@NNO OhX0hd1@h{fP0Uut_f&c@Pq7OZ	A ·z DtfQfRVW fk Q  !Q i A!!ȑf%f3p.pff_u_^Yf"Q ء & 
f0P3XPSVWfQs:qؾP?ي Pu uf`kfpv @uf  fY_^[XQOfWfV    NDfв` 2D4'pf^f_Y 3CCbR5   PSQp#/AԔpp``U@ fq$<ss!锐@t6`Z%<@"*fuGj~F|
sK1۪0$P
f>	@
 o('$
s1Ǻ$vs fޭ3̀@Yp4'Yo%lBZGW%SQ$
$
ذv%A$wu@$- @xۃf_5p<Ve|H 4Yf` &a  6&P&`X _v
``.f&r&&r!Br  Pq X
䏀  Pf9 < X20uPt݁	<u <p+ õr$Rr j&&M92qrr]rwN a{`z7da(Sv_xБQ`01P"" QYa8UP  r&& Ob 
y' P"S""F"&&Va bR ~ ZQRr빸3'H2't2ZY`2ٵt"5 tt'TZYa~r#ֵ R-ER-Y03!pٸ o}q4  r f & &EZP 2 &r豂r8t320`.&EO h?,D.tGSQp1?h[&M.2otð$<4 	#h G15 0W< t V04fRh^42h]lF_t 2Q b hm<fZrj  pvw@5 &E
, #!	A	2ahl
4%00`P ?0۸S׿%-  D``6(  _  pM aV魆ī^`W  j_r- +˸ fDZED;Հ ֻB@<B O B<`<2rruO0W2&*G_Y{S	 7&*,u&}Zu&wEq_[DAP`QFگ>  0 2ۃ<OtY	B<tmH7٢77rPBBLѯ: r1 r,q h/Dhdo8SQk
gpqlat)?$<Pt+fGKuҴhwQpB`UY[Qn @qj"yjuBAuYoof0P	V Wo^W m gh?{tD=F==rN|UtGV Q4^t1Vph_45f^Df`]	


 @`W3  et1ffd fµ[Ƶ BCε_2.µfUf.6ʵf]f]aeaa** End SetActiveDisplays: \ $^t5<;x )ڊҵ98t  u
8ud 9@!Sk[00t@uPSQ2t= +P  y@V
 ̰  uwO.SQ TRQ 	
30p  D PS1
S
Lp!
 ߜ ҲP߉÷Y ķp
^נR	Qķ9 SRq] qP$@ qqċ؀ qXqXeqZRE^]XP6qZ
R``2b t!#qP À@pQRPS [X"3t0z  
rU[ 9`<
u&8or
u02,RW_Z tr0P?X&&E&]  7pP%b=???=>.!S LfWU]f_0A#W_@#ð _PR Zb,.<t rH r0GXtfSfhBaftu` aCpqfYf `1ْP!Q">Pߨ躿mr	  {g f_Q`MtK tf ITAfgf`qL aP1uaP ~P2gaYd 
0StX/%WH &=&M_0g.g͵ ? t0;r+gCC hP -JPȸསRMp@uu.!tQ AP@Bf3f Ѱ q6~1ՌȎ؎t  1<  w >`=Q'a8tY_Ovj< O RT' -RB
P`g
1
ffZt'DtkB ; Atu P_u3鈰u#Q?y`
u"?Qh߯9u
3zjuC*utr'p jruV8tg&OwN  Rx R#n}cu @os  a d  D3   ; Z x     0Nm1$
 od_u	q @2hXsÃ$:T HqȃIqذJq2ȉ82' Ǿ_ w	.zQqA< Ja  fAw$tҭ¥ ~;PRh!d'h/?rEd/(g#/Jow)*ɏ!YïFhY]!cf>QPH_u(Dr#1 0df@M  sL?g-r(ʱQE -roGVfWG>fpV  gwbܼ f@l f  fff! 2g&g
fKffRg&& gr=e hL/ur !1| VhTZ,
- ^XSU!P sfbqfRj07W6uLt;wEf6ofB|Ч8 r/fg&bP Bfg&rf 0  afWπu
 酀> Àff`g? t]ǀ t
trV@ f?
 :N  !A'!s[f` 0;  }6frv`gGwf3ې fPfzfr:p>ff0;w!fVg&f^u#fFPf`Q.f3$pft Qȟg&@#0 <&`=f=ATADtlf q:&Ǉ  p s  S3a &lb 0ul1 E 0k3ɻ0Gj@pkUFWP
XUu&?.>I@   ub >u `	`	Oktp$l0Yk6kݒ@kC #g&J; hpOCDCTPfܾRNfXYX *U V4	hGt.f  ga r۾ Nw8\u@	a4w@aذd^!	  YԐ&C@> zĔJܒj C HكIڄ#Ѱ
Nffff+fMhsN"Vgf-E0fDffqX `8Ò}PAMSuff>r^n~
wS$00p1Ƹ f|	B( (f`)bqPWV&&rY ~;E6~P < upx3󤯍or05f fO-c^
2222BH2E<?u@
_P
`ANfa\(P"a`j uL$D"ЎQOr&=t&}V" &GF^YՃ}"
\ؾ0 	 hyyd!
I 
N


ZN
P
	



_


N	h@7(Rغ0 t@(./S+r[ం0! fPQ>Nι c r\d`ǣN!BtCN>r-t`w 50 r u1 r
-`u`dQ rdItf s`1@3^0SRNr&r!ww3҆r r	?`fPRcapՋ;ryQPQhsܒ
d Sr	r9aV>R k dЏgfUxuwR Z S}hPYk;UC Z:74!.@\ P " Y~0 `2  p",u @QP hEO)dR

Z@upcSذ* o rQ(`( p*PS  I 1' ڿR]R  Ur&DC	I 4P>7tS t3306J*b7R
t#4 c ttÈO_hQй+3"a^_z!#1$G<u$V 4^W _ 	"  !(<t )	
R
q0J0
g&/ܱ1q;-r  s;TYR(X ՕJ2u RVа$rN ;rCr<,	r32trr;wҀ tsڋ^ZW
   е0u
˿   
uߊ  N f! uf _2 J3322t`@ 0 	rn
$	"
u߱d;sRZ3QFqF2t
2t	u˸
S_ø
_. ..o.Ԡ  nr.Y.2YDذVPCE n Ðб7 < п < 2<
 1                                                               x UPRPRVFZX0RR30Z O                              Ȏ؎ \؋h3 PSu<w+$<w	+p<u7pSfW>U uR uI0~B<t>t9u2 Wr-pr!\ۊ tg&G!P _  f_[ ːQtZgf&gtKVr3ۑȻ fs`0s$
 O   2YP;G"ratt0 	
~   SQVȾ@ 8t"8tYr 6^WY[oAt,&
uڢ>ut
$ sE `t>g u0Kþ"t$	&
s@ 
t ف	>p2
 !Ut IP`#u\4tCƠs ƐP  %m< t'$  
uV޴{a>
	 1>t AJ+0q
/u@.g *r$- t> uBu
 iq `(r"1t M4ؐbSQPXt}V
|r0.SGtB0D0p.r3//6Ht_6>tP rB3.su% о "i786 S56cC$tzu Qطcרtb;sW;saQ@Ju "A
kQPFAّ"
23Q2  àߢ2=t 謻o)`Nc+ 2A*QPa6tXSfW0~`
tD_8؊f_[>۽fŀsgo]0r4,2# fPRPS0ff%|h f
 1 f4Af# uOf3\f   t(,#%9otf!! 1 f0 t0f.fpFf`f[fYZS! q@1zCfW @ fg&_ u8  U*t fP
	裯5f f |f' ø  <Zu`?r `/<@P hdFt +2Q b f
`auƿP =fpa$
	
0
: d`tf+f@
# Ƈ|   D 1úd uO!	pOf@ @腘 "a-@U @g&`p" % K &M!"Ep0R$0'*1"܉}R},f#f%*80#B' # 
 wf 3pQ'
f~ZS	)> Pw''p
f1fϋ
s!<qfXfUĳ$s?S؁ÑSB@V#t6ۋ7p$f&ȿ ff ]t33u⿋^Zf
 jR3һX3t@s7rm  J
&`P' h%Z`! 
 [) 4)ZtAT/	?f%NJf0qBD&?$"ֱ PS؃2Y11AT`RfZ82/ 82:@Ӊ!)Kd X;zK {1߿1#82"c{D82;Ł绬C~82	8282}82!+82(2#(2P3}82 {л	.<Ff.萾;!up<zw2~ `p]Kf&@c%"kj>SvذsOIrHIo([+4;xV4t? u+_q,[ff[ PGPG`0 ׎؋vп}tA.' u6@楸`" gaò
ryffh]llbs
z{8>.h{r0fA@fP 됿6fA:qFm}dbrY
hzPsGohQIr d @ h
sxWfV"D p0tf!SYôP0RZqf^@Rp_'i!Q,@Ο5w"CƦà;0/@}EXABSOLUTEPWfQPZg&
 tffg&צtX d_f^a` غ   nBnnnnJFn aS ˽À A3ێ7!C A!Cu3ۏ;R  F.Zpqh"fP P	fXco  h `Jf!IϴͯX>T豴DCj&II/药ݳ>&5o.pu	 pu7Q`{
 y^0mtt+t8QWP3 ߜP2hX@.X=X@uX_YPtrup$ qa!.$> u
PnC@Xuð6C @B T A}SQgfg tHu.g :fg&ff]~ffχߋ 66fEPXPP<(.&gfBfsDP
h3!!
#4	fRkcz6UAr{ u0e

(E
uXO0f2Q Վf   toV軼p Up ;Y0hIk=WpRÃpt%tg&g!gg@fPt9tg>E @ t_9g5C}gAZ),g>E %g> !Pq'^d`g
^
". 5  fa^OfP "Q1` t1YQ,.028 TuD/-Шj=̜n;wbڡ/JVB%'"㞰9&tͿX
2'O`Ⱥ tp  q&au Nx  ߡ
   wQ  @tRø_ 質PPffXfff݁a밃ܱ   ` 
a""pRTi[ 33p#f<?f
 
a@{f ߋyQԃ$%\h0Pf܁# "p``  A #f_rSa)f{r׸ 8>tha$d"fPRQa!% = u5
{7= u= Pǯ`!ygfc3fqCb 9q8P3=4HP+ (!PV Q   ,A048 N`?Wl#	5 A ` 2N3h}foȺ:3 tfP1!f4  QY j<t[)fp2   73t2 t,AfP _HDiR'dC'1'
.fXq755&ְ    i' 

 ,A @W@b`\fw@A9f
f`Xf4 QafY`' p@/%' Ph p>>4oft	?  !5D .f@!BG4,<t<t<tPS$<w .O@KfPpΙp9`Oq kQVW  _^|P1 6 E                                                             L ,2Ot~) d@             p                                                                    w  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
  4      VID1U  AIBM 761295520C??  2005/04/26 14:35T 
$S' @<@	C
Vail M24P 64/128MB BR12758 270m/400e
 (C) 1988- 3, ATI Technologies Inc. BK-VER008.019M.04 07  pnVAIL12.v611  P24 PCIEDGD1UN  OEM 1.052 l 0l $:^>   aP1ǃzp
  $TVS6'  3 @$ 0R!  MOBILITY RADEON X600    Kv= S     @ @ D  H@    U	!!@ W+    xi@ P#A@@
 C%p&LZ"<"0 Q&4'0  p
@0S D HC` :,0  .@P/ i d`
 OD  P P`X "|1 2X&J 03@A= x 0
|5  5E+ f`e !UU  P &B/	m۶ %""#=MT#[
u`!q! "2
O0L  'HCQDTD//DO)QS2 21	1(Z @9`+1)dM J@  O``-
ns- H.@QAD0&  M0:LL 0a q9)VQq2q#
  5}?>   RT- Q`U
(;$@l%.  g:NE`  o P PpF   LQ` `E
H < B o-939UQ  BBpmA -5?7p  ;uuR9_0 #  ! o a  2 2   2 r2  ߧ   8__^2iQ%P`j %OQlA&_Bm*n  %2=RS2 "aqR1-

  ??a@@FA(H?,H?0u%\r$q
3 #BV(et@345a4x74
  oPðQ"R.C;b{-mQb҂g ',_lt. \)c8 `Og
aCsd h  Sd Δ  2l f`.>6 u>.6.8	  u  `1u .:.9P u.:Ȳ.6fa.w4.>q u.x.&x. xмz. xf`f1INIucd	.f	Jd2E h rE SU[)$
 t.VW	 _^FIRE GL T2*!#	P
VlUV$aUT+$X>piT
G
fab4_t.qp"4P mX ` U e f WP2X _Wֱ   @PXuC &GOfGGOOf& G OOR? ZRP@+ CCP2?FX 1FXfPISff- f
Q$ f$fPV6s^nt"qfPff
 @"߀qVU vq"fX kqX=Zu/ѨPV߾ H4 
 踧S
Kύn$6C PCX %DR ?ubr=26ft 4 t f0auAfÍX_mò CG  ,RƗ} ;L^ u:J^첺2ĸ tTe 
| F2~ Y6@$@  B%.J^ȣ%(%:%VB <v  p32Ĉ&! .@2ɨd^	aԁ NhV{@*81P@Ld
FP
H
!W@ 
 a  _ $ 
[ uZ>iE F
u6cѦ3ettavv"tv(c2>STN)N=d2Pˣ< @lb @ JgB   "t
u!#< $stu	@$<to tjf;Qs Ys
aF;$<t*<t0<
t'<t<t)<t<
@	t<t(<t<t (C>
up(k"R9 HF f;c [# ~ tF: FmfwF6eF2Q~h wtÈn<uj``$t }t  ^"N `39X8u跽 P P$X"8t+N ;N"rҋNN"	F;t
~<uF17a 0s2~@tRSf_Nfϱ7 PIǁI K&f݋Pr  sByQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ܀ 
F X[ÊFf@F$FFt@F&F(P( tR.&!@{6Z.ߟ0-[PR.L^t2M ZX` @ Fvu@z=J	;5vǿv `tU;5tEt:]r9Urmt5f3_uif3ۋ^$f3fa  C s
`8sn~=}:n=a	Ð  1'(? -V   S?BDbcOQ]MJpPOVShoOQN^gORE0c	R 
l	jcgvWX ce
pVZa	cj| [is  cf	U'  qd% L̥a	d2 z!ҟ`	r36!% ן/  =!ҟ)p 81h!
a	*0*!
ǟ
	
pui	ӟW,b	
0
OpՇ4 A13P4oY]UM`62a-b6ip #B8qٯ?J +%2":b6jU
u%2S.<t
 C[3Ы3Àu#ڋHQ   u u 2 U 1sFg
 h@h ҋv ]jUb,HSR	C	8t	C$[. PRH\ouP tY@ @L,^P@  Xj  U    8@xSQRVWf<t< tux.D.< uh`G$?
t\2Ҋ`ltʊ»m2..;w
( `) @..Tt& _^ZY[&G@p}u
b $@
@@S;[PUu H<uTG<uOG-H
,Pt G2 0AH%p	Kgu/辁BJ k	 A@	G@[S dXˮ.?6
 Bte uY2@ t.0<L'f&6_C'%  Lm
gmY{VQـ.bjY~	 
 pfFm Fzm߉Fk`  .!$FDV힀.6A |pmt ?@EofppmFLFNF zF{4W  _< ?_SQfY_S螯[BSWXP u2  )  @X_[(SXX@JX[_tF$F& 0
u9C+$
||IXP?X`t5X^C `+f3a  v 迟K^ el N6   } tpXo|c V ) x PR>^Za XCޠ6D @D7 CBS$  {P3WG
Ĳa ud
V"tQVDtPMt@uN,u'"0϶4VF  fa`  ߀t>/S/7BU[0߲Y$  >
u2B[XTiDoSbD! typUt Ut U@ߚ0 t
 t}t5J
tSubU@A %?P%@
Ā?
XÐ( 	 c-'(+  1O }0P 0c_OPU
(	@ s  1p퓰0	@ T(   Ӓ m	M](
c    c
   0bc7 O
 B89:;o<=>?
 +
G _B$d "ozcfk
I2  >ꏟ2 
P~  
> @( $	

 0@0 	   
      
 %( (,%*26', 49$,0	
!&.3+0$8=-2o $8? (8,(c @# 	,
( 0HH0 (,	H 8H 
8X	 > XgX<	X0TDgT@	Ttf(XHH888 ? 4<$
$ < @XA8@	d@Ap@ @ À?O/2.r!KsuNP =Ou &.1P=: sX.$XqBP%,&Gۢߢצ9HحE+X$' ,\FG0eI6% 0+Zt&oP$K$pM<~.;u*6P8Dt	\S
OX:PjM
X.체0&G	tԱ G	p?
u&.+X&c F./VX0`PW.E#𵶶_v]uksu
2R`
X&IFUD0UD 3]U 
F CE]Y[	
 FXPv(XU ̈SM[( 衆YvQv t
9 u8u 	uP	HD]sP[XZN- ۨutGGU]Q S[[S݋@026'C[2S  &'B[ ĸ Ë#utt&FS޹ 2&C@qUut	 F07	 2
n Ȋ3S0.P
[t v 0(7t ̓rPHXuSصyS[	$
`&[Êg% ot4$
@   t$Ê$0
}P X3<J1u P<~$<t <t<t@؁ð@  HuPÁ@ÿ")O)3  @
@@ b !"# 3@tb
%ƿ`]đSI)e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;uouK>L tDI @.>H^`3u&"0F^<~D^&g7*0u3 32PQ3f3f@  fYX2PR@4$@tZXZP+Q  R< 4Z 8 b3"ߊP 3 U3s AQR趱$W;DrDT D fRȊnZPRP ߊX@ZX8t
tPZYXenuTu  w 2u  `.3@
t	u$ Z0t Pɇ!^X_0u$0<0u  ߀&o#6<uA	ut	
t0
߈ )<u+V봀1u0*!*QS3u<u "	,܀4u< up 
ha6u& <t	 0{0=뤜@SB"
3 o o`>%ȋ^N"	 y T`h.P <>cu>.@ 3ۊÜ$.B.ߊEq J@^X]l+[t8 &KH  <8t<?t0! .B   볠K%/+Q` &L >Li Y@ 3Y |RQ
 Yf. _.  ~b . *# ?#  F 
ܐ
 G@s 	 GޝÐ~~|ֺ| |8 8|~ 8  l  <~<vW ff 6xx~~~p`>>66f<ff<  >qf  f {; <f8ll8x~p 10pp0ѝ}P$ff$78|||
<<a lll"ll  l ~|@0` 8l8Ovvp P``0 @ 0`   axa88 || x" f<| <l |Mƀ | t ~ C P
a0qP 
  ~
 ff|ff| f< ll  b`|`[` 
r P< p w `b% Ɓ|ְ|~Zl܀) l88#< p P
| %| | -W03x|O~ `   `̀ 6000q(vU |8 x`flxl@ 	lܢ-u| p%| '| 06p'( x*2
v 0d 61  8 v5plp;؀5 |2ƅ88
l8|'!5f|ƃP/&&00 %:l~n ~ހ1 -7 0
	A'!r~`l`fl fEK>c8c>  >a+<4   ,+> >`gc=  G0`2#`?#: 0|6> l<~61Fll6P` l  "# U# ݑw# ##d  6 P P 05 `ROpqPDJU1UQ2d770?B?0a a66R9 Ba	
 R>     f~ 9xeb]Pf``y`p_d~̀M֒i|?܀g8 ]Sl8T(vr(l`"8fj~C|q^ 8`T`/Paa! b~ Y f`[ ps xdaw<<S2tflD8\p&mp0t| oQiqAQفPQCmlEc%oFlpxpq5 aq3Ԇ3v 3w҇ Qx>6`vflqB~~`4{>~~>ՂR2$ P3~ {p4`||s4S
x@ cUtE9_2 `!@AHiP!3pxF)bfwP0v~mi {168 79
G-3 a5әAPp|@ѓ `;Ҝ2#a=Ғ~BC ҥ  R*ҤљނtPa47`p0iQ.f`d|d``
` Lӥ񦴝Rpbq
 xp S 		
q`QF#a`( L%4bL@Z ~EQ࠵  4-B0a
6P6rc l   a 	P $jǷb[6 q b
P$=b X
cO 5. 'Ma0
 ABоc 3A U0t"{ pځY
0x" p	#	$@%#Qb 
#p
 
% 	"Ђ#Da6f0 Prʀ
$ 	%  		C	JCdw@`1|cc0c$ 	?!	8 ld>BPP<@ WWd!_ 3`p3 B< ;8>hdp` ~0]Zwl^l Q6>6n6 @s&t"#D+ f 5ڿ Z Ed
 
Z Ӥc g52cb 
d
d 5e<5ek 
c
 eqeeu %


 9Ը=3;1N Q1b0i2S$|ҏ05Yap``<Af	`q| Y a0^0 v 3 ј/AX`ixx x8#I?~ sY6t?W2@ _ &&M4SWI &FG_&E"&E#Wl_&]%&}&I2.2_
t@' k)p = ~=^~=~=~ &U*&$
$

S0B$
Ļ	-	1R2;t4&wt  pu`2RԊ%@+F,_t=@ eR ݸ  t` t:t ?FP܋w !?u?q&ܒ?ek ڊJQ 2쇽  &GF %G @GÜQW+&oQ&D&TAα !	ʑ  p&RW_:&&TAP
 XF2 CD	&Za
CD#`	 +
a@[@_Z_Y`GQWZP$0-󤾄p   jr ts | :&?Qh%a~ " G 	ĸ  2
WRW` 1RFJuyCZt 2f 	2wPYs	QwO&G<{YO 74 7@Y t' EPJJ  B2BBXJ9wGA!U,~VBBq#5)^!]P9  (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

			   


  P r 
*   **Q p  : ?  ??Q r     $$$(((---222888? ? ?/  /? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h@   1   ҙh1 ho1 P,h   1   h
1 
h
1 
hP$
ĲXðߴM WMM^  t o>I~&G3u 	u&IbtԀ`cNpb  P3&2J&Gq  GLq ģ`À0c B2[a awjb{mphrm
  !"#$@ABCDrstuvk(
K} [!{ ;Al(L \!|<An2N ^}!~ߦ>Am@M ]!}=A`P@ P!p}0A aPA Q!q1AbPB R!r!/Acj)dC S!s"?AdU/D} T!t#4Af?F V!v$6A@h@AH BX}!CxD8ArgJsG tW!uwv7AeVESA   0  JPmS  $@ ) ATI Technologies Inc. P24  01.00  @ @   W   sVBE/FP t:.6p <r2.
^WVSQR  f&=2u " WA_WȎ؋oRp" uz &u&Eǫ_WPPPwU bp M_ǃ"``ƐuZY[^_O ËRQSVWU?WQ30
Y_u5WV6/S2^_@

.D^EE
tE M]2B].l.DEEӀ~ZEE!@ #  
E" $ ~W7pq_~$@@@@ #  P"%~@ EeUeBS3ۋ3[@N
tȈE}~=
 Pw1E*؋EMډE,].

-_+E0pX1 
 f3O]_^[YZp0#RQUSˊ$ w
 V< @t| dQLPY
 b 
FŀuZdĠT2ʋD<u<t<u<uAA2PQ/3 X23`pƻ
`	$XPC@oDI0oD0o2 2pDoY6tu`[.F. |2O[]YZ)ø eVP$6Pش!t8\t,	2^ƀ t %Ӓ @^;O-  	9s3"0WV>ȒF^&Vf=>^_ÊFG< uûZ.J^.:W 6 
._@StwCCPS(.$] #y[XS.[ utzt
uPSR Z[X8
t
<RBB@Z2ÀuI tp<wjut`2.F^s0ap!`O2̋AaPXq(
uË uW3&J/_ADOD< uLA.؋6IS [';vȁ~P@JS,f[Dt@S&[%@عSQ$.2f<ff3f` Y[f;Ës Y@-wryf@Ч
2uGf`PRPfZf
ff3-fX<uS$f[fa==f "$[f%fP?O@
XZRJZfX"[
uQR~hZY!]"uRY)Zot^3"t	$B wl wf= ]QRW&9f&f?$4 Mfgq_	uZ$& n  T8<\ VRf 3tZ^fOf33sfffPfVX V@cPQRfRfQY  $  OZYX!
9]PfBffvWf4<0B?&q?fIu" B&$@[A\`tW!_f.  ;t} u2X#%5$$ ,3>QSu:3ɆtA
 [YQ
ڿ$YqD?SQVWP# bS &_Is  =R^Y[l7QRVWy{	_^ZY^ڋ_  >$[ SHRa3MR+ Zt $$}!
  t߀7SR #uZDQSСP&= PH`USlTUW9XFWXY"ZYZZ6^% t\\ []ÐPMIDu$P^   kأ%(%:%lB^XR ZR
 q  ZW2 _Ü"oQ K.63 f.;uw u h 
	rrs2[fX)D%)7 $4S
 &`ffQQ2
QQQR@WP& 0JfXR2Z[ff_fXZ - R]fqf_
V
蹂4
X

H
틪RpfZf`f_ZvfPRl g +1KK;rZ  S 
S  S@ [hSSSR	QpQ @DQYÜ2C @`)@h #  ;  ` #  d # B f 03.Dfa.T
.d"쪡   $!'!Z/RBr2& -Y&
y"
	.Dt fXZ
+

<t%+%
D Ԡ0F`
DGQ e8t#^su*cr Y$QP0ΫXr	8u
@Pu5,XP	r%0єrtr@jrXQfuQ2 PvqtQrSP?u$XPQrKru
 uKuXuW` _  QS 

O ztGrNpr0t;Vt3r,Gt$ޠrr1PB?NKu`~ u! rdr
psr1ށ	Y`ϲ#isRP*s2Z W _YQWs`Gr	zKuq_P Q Ys%  $  >j5OO<Surj"[rbfa uٷIrE8w8r&IP2XPr+rr60)Or @a,X u3ÀKu3S QPXY [<ߢt<Ⱐ[<u < pǃ3\PQWGGNrp!_YGXuoW搠u_WP@_
t  ꜑
AÀ>it[a:uuao0Y	V u	@		uAa|ðpPXq a <Zr,ZP2P [SUpg6_;w2XXXYf`s	A@		ut6P%2X0 x  t P DwDX ut!P% Xt_ueP{ 	dX P)P%t:u@PXt0PK  #u#P P. 軠 " ~ 5
 qPtfaPt t
`	tsqѧ
ufgtu*QPQ_#L @ @
0lXu
 	8U`  7XЮ@qOrrs u$gefPfPPjQM:PfPQR̮t
t]PRi	 i.? t.;u.;Wt3@^-'(+ ]c@7h?^_OPU Y7 oo XGW 6OF  	@sTv2ed. _
90  *+P;
2'SQ
t/+u'3~At		ttuC۰]4U :g i ]a!S3  [/B$J .gp s  J$
z2	䟰@
e`	P] 	!
U 
̀^			
0ȎS[	 z1PI.
$@
JP@=^v	@=v$?
ÿZ[@5S;?1/ͫIJS nQ$`$@fP,8 T 0 ; PsfXAk @c*S3;s.:GuP4u.{R&$ SffȻf
  ~ ff N[VWQPS= Nu]߸ Ўa3f<8ATIuI 44 t4Dp4u*D.x
D.zp .3.4.>z [XY_^û..z.?t` up.G4yG ZYWVQm0lm1Y^_ 52   v=P1t=T1t=`Tt=dTt* <w 
 <wf.! p SU[Z662i;rbb. t[uAhnĿP q X i'_ua`Q```d
|$ ЩBe6][3۩@߀ 0{   PN Xu22@t $C  t7ւqW@pPv $ـ AgBٸu K)$<t2
#4r
p
w/$ 5肞 
a9|a0t$=!^$ S$H <#=\0pr" }k  ̀1$
R$w
WR
$@[5 "Rj|<CP	I￸ HER9U + @WAG~$CHw~#\$!Pѭ@Ѐ  RS%B'0C"2[$%pD Os U~oQPQX  R thimuNjukЇ^ ]]]^MEFqGGHF,F"F^RZ<{ykOh`j蛠jǓQǓ3 Pr].]2^&]a
G{HZGf
]`k7bѱ 'c %@" !R?!R7u7?S+A "P?"
 2ɲ ^1=Ă  00 +Pp+Л+z $RkQ>뀆$
3<'$P$=R@Be #$1{"q#v;$gRk$ w&O$ ;wPP&uQW2dF{2䀫9PM <  
ltQ{
B{P@sP.G
tP <?XR NQ'FE{E#hg0f hZh!	]}U	 ;A3'[7#1%L[ZyY@@(C
 ϡ p葿n02Шu~hef43g.E#[XUROCh hYA`uDA Ap7kDDEUu"ށZYNZ[a$JCRW$I<#t=<2t9<3t5	  L	pf -SI[@>_f!!PfXP!0Q
$<@<t#<t< < < <
 jF* #z&E3uku{u	fF4т 8Q_._f.EfPF .GF4XH ulF6XH迖duHff%  fF8fXf;qPf	F8;jc2>..>FF4 fZ(P
`[Q
CP@CC[  Lu	 Q^LtR3ZF Y.HF
GFF`
GP0F`G$`@F~	F G
G.M	̀

`3T
ňFF	
G	F	P
FG_F	GFG
F3F'F2F@FGB <a @QRF;#t7<t3@/##
<t<tk2NAVBA FX !                               3 S(4Xf
   fX[QdR>] ĀuBp u*@ fEGtff.#Gf.Gf뺊uvbuS0I[`.O.t	q tIt䰔!ٻPIt6$<Ȳ2YÐ@ n Ps d r     	 p   RR   p 	   P G p 0  P  p  P ^p ^ ^>P^p  P "p  P	 @?KZPb @fPWQ2ɋYSQ2Y[SQt93.OɃ.;v˰a0A1 21Y[VS@{~
SйSt/X~ QSfX PQ3@G YX fSfP f%f[݋õwlf[0i :
 fðd
^_fX2QV2{.^"Su= v8ǰB} YRfPP#fXfX0fPxm!%
@fXy&^^!K3s4z萾Q2]P$?XVk"-fQfR0	$2BP;%P1$i%_0[PX93Qf
Y;fsfPV!.^;2<fXߝfZfY&u85f`$PJqfbYf{
}(<tAϊOMPWVRQ+Ë&G
36 2}a!$@fX&2&YZ" QR
FFBu P$fZY&Н b"SQR3߹.
 I@ ÀtntQ  tt"BU@O@OO]`tRp #  Q`2Y|@t.Q
yYf.9VZYPSQVJ %,< u`X It	ߔX.XP $o
 Yյ^aRcf f.;Tvq vPbp  гf@ wjvef+бRvMv? v2 v%}vs u	r	wUNfV.Lf^pf f.fff;rf@frxf N ^f;rLfPL.Of;wff+f'>sv
oACX
	؋N]~
tt= r = rA.DP.Ã. [Fpҡr )À )tӻ$ 0T ۲V$T$a PXWPVoS$yڧ۲P%&O@tp$&W7u t@ @w``LHqZX`<q	ZX RW'ۿɃtݲ Ӿ_ @`0Sf4[ø \Dw3p4H 				      
*ǃ2ڲ[Y."D
$.
ǃtcЃs] pC &L2`8/`ᲰsP 
  ]0&E}q P00![OX0ٲ[&ߊDVB 
 &^DWp$^ Ftf
^~fԀNnЊ;w' ڨ[Xu;@fPRٸPO` B  F_F Ƞ 	r}pF D
T% FyFq{Ԗe	FȊă{41nw0%
8sF%QXQ0VPFf=$@|-,3)@f
 ߞZYfË؀~Àu 
Y$׸
tQq~dA>
R}!ʸ HZ 4 X[4 ,F 84qZ QRc3ҹd YSRb.DZ[   (d
$ʼtp  $$@!
u{&4p5 *; u.:t.6=63Ý W߃ ^[ WQRVSqPֲ+$װ 2@ Wfu5DQвXfOֲ|P@EB t	@2|X `Ȓ >`0wjor[= 
RI_[^ZY_BOtw:b0Ww2ftu% tK   W&@   ul]0
 0
0
 Vf^fPB j֟0֑@af;ufY9?$_p`rƐ'69ËË0"QCBr `jV0w`ԾV uf ZX^.tWpz,Կ
ID_BqDеpVSΊ .;uw[^ӿ|\1A	Ӿ } ^( 
 : 3!LfBCC胤У    QwײRXYҲ1S@4Ԩu[S觯Ҳ,XA	&  Q %Q$Ӌ@SY`("ӂӝIҨ
 ԓ3 Xh l   Bp   & @*@LN  QRSUP ػ
+P$耿һd
 jһ0 ҲXP%
XX@ X{CXUa[`Q(P ?>t@w t0	-ѾUP@0=ѱ]ЊB		4UBUXЯfXZX20	R_   sM  @.$1L2Ra֐>! q>ёF NK.֋F_2K{ۍaqQ n ^ 
uO в) ]$лS 
PmuYKt  NVRuN8K4Kt
@ϐ$

`k(0Wt	
t yoYϑn@ZXt3d  ܌KLt6݊2qJt+ 2  c3y@N鍌P  Jt&$
N\2䁒  1#'2n !_ @r 
Q@P;XY^8싳CI	͋%T$ȰU$ uӀɰɑpuЏT `週u  Ui jN_XBY@0IN_HG;'f3.O>f.O% Ͳ$f3
tff%P A
f@,.O>uuߊr*
齊W % %} 
0 pu0&&@
%	<s̆(1
] ^}
KLM
K?P
.C<t8tXp@'X) /`t:KΒ㒔(^p2!:t`0%$@ 1
cΉ-$@*̑|$饉ؐ 鏉"`AAp2ˀu$Wrp?2`$pIK߀uR!= Nt(ˑ(8p " 2۞	% $߯7u6$
 b	+	
؀
߶@JZXÐ( :0e˻D 9 [X@
8tuupSPݻM̃c[vaS	袈 u[S
t`@ 茈J!BaD PA [
qMðT -3ɸ.6T 2Gzq̸ mP rPʻx]SDvAI$ʡH$D?+ʻg%`ʻXt
<%fQ
,fYfPfQ
 QspfY 
  .Q PA$kt:rq 0ʻf%gQv#
%ʸ YKIȊ/ 0S@a08
{F
ø w oM gY Su K C- ;m3縵A+#\T}@渔{s済渒 fɸM渍u0
 p-am _ 渁AqxA'$T
^渕  P
 r
H渟q@(Vȳ-%
f WQ 帕?@  ۔ # ap" ù?ItRZ8uR
Z CRƲP  XZ CPyM$f1ubrL. gf.&#  &ñ Ry 尅@R23Ұ
Ϳ)u 
Z`..L^ un> tgp b2P>bP22AQJ2=QRP觋Pq 32ZYYy2 XaZYYR*8}2.D^Zà؋m 2Ku2W {S
uSj[+с2Ê2+U**&R  āZHuТB$0JB J.B^r c 㐃 ޱ  PQC3BBaaPQ YXaY eԨuX}N
+.J
u8~` F^$0<0tH^:Jt. ` S +*21+uX  up*tX⑰ p/. P"㨀t0׊4"
ވÊ$"ð(0Pѝ = !$%D
m݁ ? +

,QVW++    e_^"YԊǊ竊_ S8v2QY2P >It(P
_RS"82 PL[[ZRРJ2Z.Z Z 03<?& t
uV E,ņ!&J aZ	뺀-[a2RqZ1L0 }
+ȴ@A
t
2&LP    >&}S`YظU`J<t
A<Ut2[ð
 6% B B2+Q+++YZ0"ƯȰ+Ջ+Nuÿ`$` t  aݍ"t|kÑȆ8~Ptd\8tX|0I~D*0
8t8`t2ſ
8~
~Ȑ}ݿRt*Ŵ
RQVW3ۋs@ P/2 1t@   _^Y@ ZC\WQRV`T3G  ZYxs& 	r Ǣ	 POFP J ff*f / baS[F_@fWfVfRfPb`pfV +Ɗ2BAXZf^f_SRP10`VfZ2f04[wu.N i wy} r鿄f&Iw$餄|t;@ _v[`ovI|bR:Z\K`R!eh60@A3hz
twFs
PdP+>PEbF+Zh
tĿ鸃R
#
+ 鐃yrnAU~6|m ~ &F^ +Xu &F E&   P wQa+>2u	&}uƀtGVW_^t!#ut
>|  21
a|u\݂tPA drqF`u
oQˀ
С
6JX 2B$]Xc@]SO4߹ 2
FfKu[3q,~!#|AommpBuG镁PF eXЅ$6| 62 'tmU؊Pu)#ëp &N>Xz !1{   PO Àt!g&0@ b?`$ &PO 騀8r2Êв2,Ћ!=1HJN@PRXWQP͵sêuXY_bQ(IY+'qGtrG _vqG
ov  _u　PUoP[,@.X`)Vي`4|4F umXPRJWQQW@3_G?8v
 VQGY_Pİ@[KZ&%_G+B;v
ZPݠ òθ!&/2R_oҰie0XRWQRQWP8tXoP蕄5$FX_YFZ Y_Z 		0								ɲ		>ctqP}}>
u&fP 3 f \f$߀t  
@}}SP
3 t&  ~ &]X@9	UĴɧP _qG@Ā`ey
L'}CkP}AD^+A%  %%&|&Ę*(DrX&|t
ޑUn~|Ct-t|̢2"[}~J|yr/>b2PI<
vLw?5`GrǪA8sZt{at u2<
u:6u鿖 Ɖ{<u{<u
t22+at++&eP>Ҫ󥋙peA{pбz,{.u~&2p
O3Ɋ7ʰ'ﲿuF zzcR`R8buaz~1T`NVzb$
Ip(!Q̊.t.;t$.
DY^D;z#+3*2d!d"<PR3=ZXt
A>t
z>u<s .ު8M߫Ū!  #ŪU@ etÆ% =@&yk}+>&}s! 32 =w0$&e߀ te ò 3NsQ2ߜB0:JG `;/^ xQ&5&m&M CYx
u	$aP0cu4x0P} !vr &5&MUx[NL ~ >x}4  P^a ,AWT xtX9 @Y.ڰP;PY0 d2|XR~ ZSߋںYB [Z SBB  ws Ȋ`PSfQf  :t^$t"$2t t=fIuvޕt%utfY[X$ .<t
4vaav<wPSPRRR@n@	[e@}P=s=s=|s^=Js ZXj[X <t<tˊ߀~ S&[&v ȫt@ > B Fv.| ~ v2..u 
*9 ԽF.ȽY60:_
u00w5wpP&p u͎..ZF.lQFF kuY6F.F2F6Y  Sp$[$y&G&g3t!<}
<}0
~ô <t
<̀
&Gpu2@P ߋP$`"3ҹ <uȰ {P' X
PuÀu
&~à@S[t (22QPF t  +YsuчPW>&}t0&<t$8tG Ȣ?&E+ _X`3t_tG8Pmu&2. aѬtV$
J	 ȋ@/utHa& L2ܾY6t
F t<t F0J>=&]&M&U&E
wPp>X}21PSQR.L^t	00ZH<|xrSH!`5[VQS&F E<
"@<
t2Bdpp\p' t&^ E	qVras ߉-Pһ q	t2䆠SU@,][ X[YZ u:Хuq`IEq~Am^Fq<u	Cnq0.:r2.] IÆ$0<0tu` tq
2.;tq `i8~û 3n tPmU#)Vqnpt#  P 2       ?     @  R*$Z.$SQTSQuY[f.
uY0t5Xu	f._>T Ef0(`f.Iŀt?
uPa*R j
PRt|Zpr .@i(-2.OA.WB-tW+A_t;r˿ÀtR p D
u(B.&Ɇċȸ 3  u,A	t0t𼀭| ]
PGTtu?M2@c
uJJ Ѐ@1

@  P2@[ZPQVWS.>Nt .TTux]..	CANP Ў3f<8ATIu? 7;2QRS$<uP`F|<2[ZYY.ɰ.ɁU@諨[_^Y@Hƴ 
XÜf`PSZYstytrS f!f-¨[7[-!fq[2ݨ03p
	>`	f{  sVs  fa-fP22ɻ| ϨfPfI_8"'0 f h B_/,#2ɐ $
ȁXgϧ   	@fX7S.= t.;u.;]t3Х5W4uR hW.׊eD <t<<t8<t4<t0<t< u0P`S4=@uuX5
X
=u
諦_:@E=@ Xx ^}     Ѐ  @jPmm @{wj X--    
V 

u`P=uaS	dF$:?|$!Ho$+`yͥ  ;v$u p Dp H$ 0MWDW PW .? t.9u.9Wu.G2tpU22T_Sb.Ɋ
܀gqi:p[;D;;ûd q#Wt\3PR$ZpR[
% ffR t3t+t#@t.tpt>tg%ff O%fjzf$<t$f- < tf+ `f
 f2) ffffZfYf[V<ݰ2(¾6ȴ2f3.Df3ɋ% ffp.	 L_  
P!f{fpf  !Xff;t9`fX!6"ꥰ" 
"t@pkb ?b Ym
PG{>^')C( `.^(߰pDEFG.F*.~/ ]ط tttt	tr@%yCp g^ 0Uƣ۰IAfX^    q  + C  C @CъR?muu	 .F3_H  H@" ufXfJ	p{^`.~0`ƃ

p0xq 	yp)tfM0~4x00   8hkf fPRQQgluЀP=:3/H!pXP  ︠TC￸ 	^$ ,LՐF T P  X@r
\ `#fku 0^u8ۑ Phtq jt=  A0o p2pC
uu
lXT1mtY]IUDrnEoM<~	<%  Yt P YZRSfPW4xJ轞躀.E_fX[Z褞4ƒF
@0 g<0 _F;  (P;; >p/HN   })%88 A~	I? CJfPVQ0y{<t%g<tW\
 $W贝B"EA!H A"`-YN
 Zf
  9F-fnPka{Ơ1p^D f.2tJt3;d4 ,Tff
@ Svf% 1MtAN   [>:מ__ZY`^RVWEVh ֝3Pg.;s& j?>.\e?ËQ O^ oL.L.2
0>G_^UCSD0[@ Jۃ(c IK0u3HS#ʜ,肜 Q t@腝ae0uǯXPTGPS2 Q
~aRPb֟JXG bfW+&G5 ffa~tf.#jf߃qv}P"ɛ3۹!fC X赛f" 	WfVwf.
fꛃeowH脛XMf^p$[H  $,48<DLPTX\`dhlptx|  ;@>Q  _`//  ? c$
k*6
mc8*1 C D
  
 =! !A- @^#
l"  = @ rI  
I @ .q&y$`,>$EAs/BJ @  ?- vK I'm$ j8!ha	̈́&@R c۶(, - Y- =P0\ y5%1#~ +.C[/H8CАO @Kd"#CF( N%_ ؏'	.# wEm9 Ƣ( [GqF+ ϡ /#-+vk+ [P} z _Bmc	o	b	y`	 gP~ B+ 1@ : IR?# (O6 i  nb8(+ h"6 w-(, QPT PT PaP=U! lA?-'A.P]hq1,{.a5c
5^O1] a`0U 1&c cA$hG!A_	6eavWPp4V10  $TV N b PWVt  Sǜ[w^
 2؎@< u+~@PVf >藜^[a   :{ ;@f=$pA@f=0 #?؃  ?=	wIu'= Nvu @SC+[<wqȎ؋t @봨qĀ@*뎨1<녨tN{2q?_fY  藟_ HD  x@ PSR' $P D
XtuZPRP$"
X꒻H$螓= $oB@10|P'v @ /ra: 
tRP~rQ
t 試	\ pXZWPX2 t3ɿS;t t_pP33 t= $@$Ћʊ$ P$2Ƞ$=u$	$Q> = >  =p nTþF`赀8@`B f=r w~_Q
<<$
ăQ<:0Xü4 Q *@d @A &06L 0+  A  0`e  1X ( 0XB 8xVVA P	 -`N ((' @$
>QW]f_YuE#@a-t?  1/Б$ÀB60$Qt$PƐP=@r	譏Td
$zt0TSoC5␐58GLQĝ>\a`S$0:
* u<}$ӏr1DܐQ-U$諏D3!$#!y" @@X?j}蛎#p  G`΁Dy$@3h%z YH t
tQKnL`ݎTpt2G2;rאWF`GV_Fx+i  Z bð9 =9ðwqӍ96qq}m	fp?Z
P9bDq=p4.q
-p1 /|p+$؍ sWx  !ZP*hTo^Xsc\HHx$n
 a_?[UQmFP;s I8 V RFNP'uڃ?^
[F ߰98[2FF
V|Fً?"~?P7XӀ
QYINpY ^HF7FVЉVW153]V7@dF F^9F$v F?fH~F f8f@72Fp41~;F	Fz 0
6AFm
6FPQR2$M& 
Ⱥ$?
ZYA5fS@5V }бEkۋ 'AEEfP'ËfX
@T`c+qkj*[	U #
4E #85s { 9 踯?f>ĜcB$J&e 

BA
  u0f	QS ãIM 8%= v$B, 7@c4$q7ˊ% {188k݉4MVs @@f3 P3ҹ ȋIXA;r$	藧tX;v;tKXPQ j
LvYX  tPfCjIXAfQffffYf 	&\`   fiBpGYf^O%rN[$P # OqHk$诿t އ.>G
pi`ñ .<  -3f<8ATIu 2؃? u2蕇 {PV ׬`	8uĊ^P2.ۗM؋7t .& t._&@.?tǐ?.E7t ECCVWfSꆀP@ШW.}&.E_.]1f ..M0Xf[_^f9ȿ
Ȃ-0
̻$
E.E6Cfp$
ׇ$`)Ї$.e`s2W=	_K.]9t"=f 	0=%f	}&f1	'P	e$Ǥ	80IFl!/_1& |@t訅
=`%
Ĳ
=2.>.1#%:u

P&ó~ '  ) 

=ðu!1*#c -fp4ȸxi3(ZYf[
 .  0u  t < RȄZ0bo⡵sQ׀T% Ru$ZW0,.E#_ @_VQdWe 誅$آfذТ%;E.uDff%   !&.:E0u12   1u"蛢f;wt
 nŀ~ _`ΏY^ 	-f= _Y _ xPW1̘h 
Є&)}@(襅4(+$0w B}"ɫ#_¶ic迃TɓˣQRR$ ?$4_
21
腃Z=u @o?QWm4:.Q.рB1WAB̓ .m DaC}pm@011"M,t藄]_4<$o˃P'ƚՑQ'}o4 t&a?QI)tA6$o茂D/#Y#M i
c0S 0%$V$"22ZMu.	ӑJ ȋF"F 1wmqF-c+a[F&2$Ҕv[$
[a;Q5`1e/#4:uF) Q\;$
F)T bPP쵁fF4` 8Ayyp?F7tp6wF; qXsFB#@0 tF'ȊF(`F2f)c3 `d^(2^Y[=u3ۃ@Ʀ ynm f _fb  J$1
ffe`
ff`
fJ$߁
f	f%
ff߰fCRQWUD 2F E]ܓuuu	fǫF4P  8 _._KPn.G 4XpЗHA 6XHfPuA T f_F8fXf;pPf	PA2>g.>ًFFm_Y3
1"o"
QWpǊ.Et.;
u
.;Uuÿ3_qh7o ^ IJtcS2lp4wې
BfE_6.Ip
PR P
F"F 2N(̀ N(>`FF'G'N'+$fF f`f1N})F
F$`2.O$F&Fqlp+%
ffPnF-Fa
.o`N3P.G$ 
Xnr
Fќf	sf	cb2c`nv+ '/0
$F1PF` N& n1f102,F,f.o.g` F`F @`RG	  $ 
F0` Fb !R B`Wf	Jf  G02ndq"0

sn/
3f/f	 
 n !`N2AV{B02`Pϣ F tZ賋tU1CWF:B62CC_A@ `3̢B2WA6~sD	F2_I@I6J2J_2D7DDag a2 8 C F H K L U Z d x    ȏ ( O#zSt$^pF Ft -
F u	F=!(^~.Ff.fBg``{y{0 Nwn.5 f0{
̢ _{tǰWF	zjvPz]Ef^K
 LVp?VFq|	i
@{	f{lzF6 2f|z|9|5|y11Xf^ˊ߃fٸ4P"^?~/|8l^ ^zQePFPx=$Ќ3`,. `@p)t
o  w"v!πؿgD	DfDa Ee]}gqt^TILDu'u?D*aw++؊}@@%??Dd2C_EeCÉDE	b*DEe}HDL0+S2]Ë؃$PeĈD\\[ˊE
b	|ȉL qB1cD3D<_vu$<@ $PX;}?Iw`d;DX4D!#!Ë!ߋȉD)z
'EPj2`D(D*&vu @D+L-DD0(D.E`9؛4~\1\/?ЉT23 ]'Ht@P D;XD5 @^@S @X ^P P @ XOP 11?`Q  @ 8Q    Samsung LTN150P?1-L02  Q  
 AA  H }  ! cRl L  "0Tn0F"d`  U Vf3ɹ ҋ|^
uy؎f<udf|  uZft y# =	wIu 3qDt ֨ *2QĀ ]`UOG1	0I1I	 AJ2fIa+:PeE;$up E;X e9= uPWA_= vU9жN3Ƀ= t09w'9Ew"xt=` 0wf.E.D`A.@Aн@ } ;uA7pVEDP@SQWVt^_Y[| u ?0?@.|& t.|&DZD&PDMmyMm 2]a$@VWaVS 2 Ў3!8ATIt[ ؋7[tFA5	
&G^±
p ±  廙.2% u== uߊDu
`
ް% &  _^VQfSpyp	G
ff;u.QfolY^E4_t*8r$qPzr%qQ3 蜏0蓏Y}4 _tbqqWq!q$3ۊS 0_r0Tr3
Cq
q
[Á=qE3_f_#`Ȼqq}E
q`%npap`q#pfPVWSuf$@0;R*KP&,=ܠA*D0.D1
.}4u'+` "
 2p._A16 ްs $}&3@ E.eq@3@ [_^`Sp [À
t{
1Bq  M24Y OEM? INFO1X                                                                                                                   Z 2  1COD  P h$3h &hS@.5h[.=EggS$ih$g  ifD1INI??SQP2.N= NXu2˃	w,.'
t #[ʠg  u.&ɰ p۰                                                                                                                                8g#3o            1600x1200  @  
 Bn}ۡ!! _]_Z _\!
E  xi@ PA    CХpL <a0 A4Ч0 ]  p
@0 D HVC` g0  @P i d OD  P   P`a0X 
|1  =X&J@u 0@A4= x @  E qE+ f`e_ !UU  * &B]/	m۶ %"""M[Ϡ
u`
!  _"2
O  'H%A&T&//D)QSB B1	2Z s@H3dM Qפ@'`J
 HT@QVAD0&  M0LL 0a Q)VޔAq#
  5?5   r!- B<
(;$@l%.  q2N  `  7 P P` }  LQt` `@<
H <@C- 43P4Q ʡ BBpmA -5?7p  ;u_uR9_0 #  ! oCw PJB p B B rB 3  __^%A* %1GQA&__A E %2=BW "OL
?? a@@FAP;;(H?dH?0u(>#Z0G/Z /Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z,Z>/Z/Z/Zx/Z/Z%ZU%Z /ZP'Z $ZC/Z/Z-Za%Z/Z/Z+Z"/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z.Z/Z/Z/Z/Z/Z/Z @a/ZWV*Z? 'Z _[%Z`/Z/Z.ZpA&/Z/Z/ZP#Z  #Z$Z/Z/Z-Z ?/Z/Z%ZP;/Z%Z-/Za/Z/Z/Z/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z/Z-Z/Z/Z/Z/Z/ZUU&Z /ZO/Z/Z/Z/Z+Z0/Z,Z/Z!ZC/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z.Z% E)/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/ZV  %Z__] M=/Z/ZD#@&/Z /Z/Z/Z/Z/Z@/Z/ZOONC J/Z/Z/Z/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z+Z O/Z/Z/Z/Z/Z/Z+Z&Z $Z(/Z/Z-Z!%Z/Z/Z O/ZO/Z/Z/Z/Z/Z /Z/Z/Z/Z/Z/ZN /Z/Z/Z/Z/Z/Z/Z/Z/Z/Z !/ZVV/Z __.ZO/ZO/Z/Z L2C3sLD /Z/ZO/Z/Z/Z/Z&Z#ZO/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z /Z/Z/ZK/Z/Z/Z/Z/ZU&Z /Z F O/Z/ZO+Z /Z/Z/ZO/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z-Z/Z/Z/Z/Z/Z/Z /Z/Z/Z/ZOVV3 0/Z__*Z0/Z/Z /Z/Z/Z/Zp1sP2 M/Z/Z/Z/Z/Z/Z" 6/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z /Z/Z/Z/ZO/ZP F /Z/Z/Z/ZO/Z +ZP/Z/Z/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/ZH)/Z/Z/Z,Z/Z/Z/Z/Z/Z/Z/ZVVL __^M=/Z/ZTQ#@&/Z/Z/Z2C3 -Z/Z/Z/Z/ZIO/Z@-S
9B     ? c$
k*6
mc8*1P0
0
 ! !b^< @^#
`"  d	a; 0Y    
I >.H@&y$ـ`,>$>!EAg/BJ @  -Xb	K ZI'mB$ j8!]ha	̈́&@R ~c0W', - Y- =PX ~P y5Q%5^_#~8+.C[H8C`	O @%d"#CF( N% ؏'	`{# wE9@ Ƣ( [GF+  /# } -+vk+ [P z P%Bmc	o	b	y`	 B+ 1@ : IR# (O6 i љa8(+ yh"6 -(, !%PTၣ" PT PaPUÄ! A?-'A.P]h=1,.'a5c
51-^O1]k A+`0U 1&ccA$hыA3_	d6eaWWPp4V10SX1
w*
OS"|S1CSS !@=" "0"
TSASpA
S Ab6ASAN$/)SSsBF }`A   ZtS@\ZS<S# 	/ A&SrU@4=@
6@`]bM ZS= oڛgJ	=& GX4 a	SS`s яf:pHVSASA&/-S'/
S~  s`oM s'X+SqSm%HW.V4@yˀfLDSV~(jZz% Q6  So-+b{6']r  J5 ! S<S.- X+fc._!o# ]3V2hhh	 ``	{7#V
] )Ve` ) AySЀNSRS SVSWSW^SSRAS aC.S2Gw.P1PQ/Sp.p!cqA.1RjBb2ycox6SCnc"`QV11WiPDSSoSd10?
u). $OjQ%S# T/P$2V#sSrSZ'΀GSȄ!o	~A`3 ya9 @`sqS c).ΆK@S
o	V/dÂ!v/# bbAy9noWcPAbb	O %kbAobMuaJM   k  夏+. 񣅧,
內`6tUᩒuZllŮYSS$G<   a         VID2Uqs  4BIBMl 761295520C??D05/2 ,16:21:48  % BSg d<@	
o FGL M26-P PCI_EXPRESS DDR1 
HP HoustonAP Rel9.10.2.0/CL186840   
YOU HAVE NOT CONNECTED THE POWER CABLE TO R VIDEO@RD.PLEASE REF` 1'GETTING STARGU' FOR PROP HWARE INPLLATION.(C) 1988-20  Technologies Inc.  ATOMBIOSBK-!VER009.-0 00 0  25 	   config.h$   Y Nr4j`RSV  q 
/	  	IP	 R .".fPfQfRfSfUfVfW555#fľ.4tf\fL;u
f^ fN   SfPV> f=rf~ f- P  fD^fX[E9 e`44 'u <mm%LP߀.#	.&"fP." EfXt f.HX#f_f^f]f[fZfYfX˃F f3F 2FRӋGZÃ> u.fe @B  | Cv~@Vz@/p ȣ1pApSpPMIDN=Q  鸠  R1ff@XE"AC u0t.:&0u$<u f Z O KZuud{t* uHu3H13$:p< u(`3"`<u S,
 ^Ff<<u vVo<u@&W0s R
Ff
fF(
3~  .:
<u8
uǻ  u3N
'
  f
< 'T`
F
 
uK0#ǃe5`4(F   i K(
F *
P		>>v>p>	<ur
(f
f	<uD 
$Lh	"G	q]D	<u6 {
3$
PL
Xp  0o
"
<
	< 
u! ;pC%zN	 %t#L
 $
% Eu9 $t.*u&, 
>@v3C.즋u	^.W K<I
R"Dt:@t;rH\LLfK

KfP
<f#fD
`Fu	~1u1
Ӏ+^)0o 0^N]%/ 辢Vܡa`Nf4OS+a όİ/V nfT
ff
[fY
tf< 8u(F ҹNuP"
GCA}0$=q ?@Q=!.$
	+u. #
	v< Q-
^3f t
  tL
 t
f  0OUtea
{ 
 u
.T
%@Pɀ{ƀ @ @`̀4<±4yÀP$
X$"
؀
ߊR
Z"

Stb.w		 =Ȁ
[W<PT%23q	

	d<1uJ7a1Ȱ`f 
<Qf   ?fRFqcucSQ   f&DaY[&fʋU`k!2vV^Fk.pP:u'n	: 1@	ugRQ@@t 》Y;vȋZ;;А pv					?u+;l슳^rEr 
T
AiFG=Àt t f軯{S R[@ Q@6腣Y<u#Q#_t* $ j*馰$pE^*<ur*~w3"w<u{,uGQ [zW  h | LAxD&D'
0gJ',;< u=qm`Ȁ t0z0
Qs( n p uM$PP@Pu2It30u<)ޢeS{$Sv]P	uC5DP 7Sq[f%f
fyKW蚷
uqNf%@  u[$f^u(uX	 hSU@u/*0A
@5" 	4  [(@:(eu2Q$Ob ȞDu w(`z
 _u
'{IF o2䰨f)pu
@w wLC 4Cu&MeD&U
D+'
u33u3 u3PIu@s_@*Ju$'
۱t	˰3 $tf.9tKP"tSU0u'[.>$ u2..". 2@uKtC;w	S+ڋ+;ru;w+Ë++Ҹ  ۓUV+rEw;vMx +_r s߁ `Y3ҿ^]ÓP!XP RfPǁ$ffXZRf  2Q  ZÜޡ 躣 {Cu詃k ff0 P~vffˁ81P fXf[Zp>f QfP}rfXYRQASRC_pf[Y"6Q"_y$^5诡B軦F
0|ˀVYfXPfgo\#aa1E F   f'f R: 'w *eDXRhE z  R
бpffЊfZ;U@3VV] BF
@3]٠a@VVF@Z])Xffw	wf0.N
f`  0Q..Y1(YÊP $?en Êû$?p[}Oq,C@% 
 ~0ًqA!6Ð8 & SP3ɊȐy X[S 
t& ։%  $<[
t`ѝӍuK ԗ	?;M¿vlf%_? um1l sLEp\
3 23 &^#`+t
t
|@vt
#dy   (-R$x'U=4v{ P8p8kt&2S t,;DvDu@tQ躒
Y@	 0	t

S[QS 
u[#;35
[t_YAf%R ]EDq  At
D
d8t-rtꑞ tEu7t2  +huA
$;@
  t	Q
R
RT
U
PS
P
pU
=aVU۹1B2^} f ti  7AN F K* :
AF G/b?D )Gp J`~pvq3`@94
Ept(B
v !q̝Qf  Kt{061faɶ$<vlR y2U  M2 )p<ȃ/  AB "թfI P-Q!V!Q!AT_Y!/U!E Zu2p  p0*( (~f@ 3R@F,A,m !Ԏ /)//k!O!Oࢱ ;Q
̃ !0N $y12 R $`
tj Ŀ99A2Αobf(/ePI9tQ^97A	9V6cs((y( "q?Gu<	F  fAC% Gfup8eGuztaAF >
teTD&D'
ዏ_a	GAC A +# 
1A@GAg "C=A?#;ce`;u8rP8 c@	5O	.C	2220
0O	c"+ t!*$7" Fqo':`ހSR #Tt$
Z[PPS{
@D[ ۵dO$TC<SR=$<ukf3a O'%s P  	00&	#	p(
@{&'V拜"^ !#%x'P*(- 02=50rt"/Gp;{# :rY#uqPQ 2s?Y"0gQ$ D_V3`a$u$-#<tg:uLT[3t/ tJ
u$<#u 8<2 ,<3u( 
P& :Dt LT
^   @Q _Q AA^k
1 Q Q # 2 3 %~!L ;t	DP2L^0SQR$ȸ `ff3fff3fgZYf"[ðh	t-CŖ9@ƵVqpxf^L(| wC|
 w<d(63ɾιa:tL.FGҹDP
E.D($tE EQ  <+UWfV ^p D+<  (p:@t; Tt
TP0uDdg@ufV Tt'Ou
ЀTر b^ KVvSAc[
`iNc]fQf fPfU߃ 3GCf#`KfX7o /fYK%KfqJ3ɡͧ߀Ă {L0 $1 @PS.tLu	lpRb܊ ZQR	 @ސOR  + KK;rZXÜ2C_ @p V> vp  	!  32Ĉ&! ^@HC3BBaaĹ paPI SȖ@rt`NԈ XPQ%Ղ`C 資[uP72p̰*N^+ @|S"<" [: Ь`5@t"Sb` [迒tQ-Q蹂Y AT%f\"f\$f	^t%i  Tt2UD@		(`G? S.8fVv 9qj	z
1 ڃ !i0PD24f'F f BDpDF^' Sq5+[  
@FF[xi1 '`},  #(-UQR`f3f^f\~10
 Z^SPX[tt;s0À FfAr-FesDN;±  a2ofb\RbFPcDRff;rF2d ffa ffñfkd`f0ff_d   f	f@B 1iff;?ff+@'f)ų
fٷ^ѱ+ZYRPQ0YfX uSban݉F0!b ̀rOF3ۉ^^F^f_^-ʀ-t
  PffX`v^;w+à xwF` 3ɋF^N y Ff^A@8fF^~A[f;v`.F
F?FFp/OF
"7V>v
V@]!t
6B f7F N",  ' 7cϊ^fsҷt@nf$ȑh"@ "ff+f;Fw4P^n ^0߀vPÿw
 ?N}%Z3,Fȃ
]QRf=0u  wf=  sm$S9f18 872[SKfA*r3 N/[U1t+  H r> 
4B3tIb1@1u
B w
-AnNS6 x[1hSQ# 1QyQУrQ
[$;r "R[;rL;DHw 2Y6o91`0
>}	 2Qt92th& G? Ot u
t:dGu5h;Lu;T
+u5c
ðCc/pSp3f\+[qcf\
g[qD 3 H  r
Ot&s0
w;Tw}fz UfWfVfRfSfQ j<   _fАVf3f=  \C<  i  b+X&l\#}ۋп3% tE  t;|6 ! u&<ufAh߃f˳ @ 2 \Aw3<w
@4w	XE\   @stH382 3ҋ2
"jf@kKl@ٺPxwf   qt.3@A N ͻ2
f1t	fX۴ Xf fZf^f_]H18t
C? uf[$%6 3`Pi1 tPfY`Q2f Iq"O"C	3]``$<G@<ubbË2p
B<t;$?<$& 33'p'Í\~h33 t V$ t#4O"Ouǀ  	}@  _ 

	|  
}    p qq% 0
 X<b 8 /Kb H1 !< F Kc  EsAKH   ~L?$Ь8	 Qy "ϰQvUv޻pD޻ ޻A{޳	@QD޻0&޻PQn޻ e޻YuP K޻	@A?޻ 6޻-޻ f!?B rqf Q S񰀻ߠ!A$Xpg556J666 +0
u$F5:Pfp
 @ݿJadvsBXi	 ? $ʘ 6ʚ
[ޣ*1N  `u@.X@1
 ʝ
ۓ1CNB  PP !; "?^u).
 @ e
ޝdr5s 	'\L
+OOOO/	? >̋ @<u2s!Ê8NKu2= Nu\333t=p @U ݀Uqr

UU 
3ôP$
}VEЊ\)^d$Wi Qt   @3pVE2۹h s 	 v@ Cp^   ^4 s.
,FuY @E@ g Vp 		 PƊ5E:Ht
;r23Lf^SSff[z$
4fRRQ 8YZCBES ٻ ٳD/s117vٳ	gcٳږP[0'u# ^u 2L) @u6Aj>u)#u"V`kuQIQ>pZYu#0!It
2	u *zur $ ]oY 0Т@RQ{teP
ia29t`
vuKOeu:!ṯt*b@
t <uI7u
ahc
 u+O#
B145	r PpXCᚋ0 10QfRWSd$uouhuau\	uT ~uC< u  ŔsuB?f@ ѳۋǴδ[_Ya0[]ucu\u{Uu @1P/1rmup7uF-3RV&w  &G&G@&G3& T֎ &	2$r	v,t?SuO&Gu&g&W
 .1Dq=^Zp=	D&7&4	&_
&&\^[}=k===  = 
W،Ҏq
|@s'  Et\,@<wS2A
.=Gwk6wG`$2	G&	G+_)B
&WA G- ,~1_&G ǃG t 5 1&3D U w;v 2T; "3O&)G* 0 P+  ???????SQ! u!p @s"_e&r1-u^wY!?P2WyL20WB3:&O+2 3'_6A^Y|__# 07c
?=9$"" ?wT9r<G#2(ͥ"0RLWE	뤧DF=!H.3#G#a?ߒ2Ko&_`#2rt&!G&!O>"STgO9tqT_SPQOP-wPO"33T_?30
QRQOЎ&# tH$fJ]0JW
IVV0K%'b&UW"T\1t,0	r_PdpW&	0[	@aZ	>_,!sG@AT
ڲd/5
e" W"2Ar??4	)	`	!	! `7k  W  Pp#-
oc)7$p'QR

[#~
6	0	zLU""D
	)'D
UQR&\$2jq3D}T+\%A12DT00\@NLY`TBW/l/(.%׎\>ЉLQ3@8;Gu
&;Wu[(Z1ruWspjo (Z2OG((,(CUMYF8FfV~FFCoCK&#G#!<!1?юb<s&3OB^A#6ZBAQO0.OfO]0&Wto k eFg%k/E#EEA#McnAd\W"s	/K//k~<ZZt}[<cu3`~f;W
u0,u&GgԯDsTu@{  `]@Ng'vEt v$	po&m8D5bFXdֲ+
2< tJD&W)34T2_ A
 {&RW&&k*
G a [!$tb~&:GC(u=@{ȉw__c4(2(0$u ?8S3PD D.؉F؃? V~ʀfF  fF  F  F~ V ^~tx&EA2	2&E t3Pđ̿tA<1^`cb 60v^ 
0		F2 f  _?f  r} ^f[+uPcȊ
^^̅tݍ3-^&)qF?3 2@ Z ~ tp2f_]Р&T `,R.׀@-%4/#0/"_^Z΋ƋtH@؋tÃ SQ0"8WC@!C]PB3F"!  ABŋfZ
fPRVW2蠞<|bVjgSa2QË~ 0Ń7Z髬) SB_d_
؇fڀcqSk23_Åp 5u>f	*g/%Ϯ	`Rи 怋Vv--Z]`]˸vOøOø'Kð,ð2ðNQ Q   @22ð*AðQ J( <}:`] fPfQfRfSfUfVfW < u^ <  <@t <u^ <   <T	V <uw{NQ <P@~
T <p۠P <	u,
w<
u
~ Fc<0@f@T<u
{UC<q2<u	fV< 

	OAE
Ff_f^f]f[fZfYfXP.1pApSp XP086;uF` 5 X 01.00 VESA L  yAcc
	 
0dQU                             Q? ߃f3fQ" OGOOO ".PtL <O2  fP_QW _Y EE@ E@ EE@ fE> >fqfE(ȑdZ JQBMUEEYQY-@
?uQ%0.E E!`"#E	EE  	Н+ 
t@EPC_PJ
 " #Up? L

t`EE e EE.
EE6E E7E!E8E"E9E#E:EE2EE5E40u%fXj2
 ^OtV
utOM̸tB
߀
	+$.t$ 2"žĀu`3#33w&J&&_Q ` Pb Ib&L  Vz& 
BM@ 	

   cV 	 2g pVÁ/u'u&$<#u	<2 
<3 0
O øO Q5Ytr tt:tJU렇7&7Q0حtY t. ( TRo R<x{3ۭ1Yt$t(t,t)t&t.P[` Ρ *  0 24 뫾 ' PHݽfC, M- sf
bq	UT	#	&	)	x0	@	*حOm Ё ? 뼼Q	q  8 0N0	f80	 ?*$D
LB
p2@
M!
  u.?;|v-Km @;   'ouau
ʑu({PʊXP3 ;wXȡ&e
u#sS ^$
[ O [At]: t*S^ @[u@A=u ןW RSfP @ fX[ZÜϠFp
ߐ? uDÀt'PfAH cpffǻ "» p2Q2ZɊ~f1ϡj3 f t
t<oO-nAkڹP.gff1HBU81!80N	f&4< =@?.>AH !Ct?_D~
@~& G O5 ;Lu;T
u 'szC  &l,V:ű
t / `J% ?AƸt˫N D LPyrE %ux  `_U<`,u*	B y2 U?ܷt+ b	DL$T1ߨ t@tP|2%?tp[AaCҹ f.!L";H
ɱ  9w> ~
 ǳ R>!Q3}  i
Y,`u Ƈi3S[
tkQS!#PXYu
YpUu/2yo 8~ 
 o #ā 鉰Xu6	AwK 3i1i	$QN u
	
f 
	 u- ސ;» px  u$u@oUY/Q_/SuLu߰E0 >t `3fHrBoTPX.__ǟ`'Ü~{$c_' rDCu;&P<buPQӴt
YXXQ;u<~X체0&GԱ} QI	:ASXH
[u&.+X&c  qCrVXt/ 4 DEO44ËF / % s 6S
` 02&'C[2wSԦ &G	qË#uG졪t&F Sހ2@&C 34t	F[17@2`
ûh
} 3@Jau"$<~&<t"<t<t@؁  )uCpÁ@ÿb<bྕ  @
@@ b #@23tb
-tq`q-tq$SI`P2.be&f[,0(0-0)0*0.0?)0.8%u.]3 O;u5-߀uC> t<I @.>+3u0<~
&g73 3嫑2`8c3uW阐s  t2uP>20 v5uK<u@ ~"@ 
P uݕ1'0 '0T PD8@0@
u$0<0u  &o6A	ut	
t0
߈ )+V1u
tu!Qa9Pk3u< ހ4us<\qIQCn6u& <t	  먜0B"
ó 1J0%}0^N   (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

		t 
A
   r 
U *   S**Q p   ?  ??Q r  ~`   $$$(((---222888? ? ?/  /? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h     1 ?  h1 h61 P,h     1   h
1 
h
1 
h
//( 	 c-'(+ Q1; Q71;p9 3 P ~_OPU
(	@ A   C0	@ T( s PW  K
0( MM](G
c J1 pJ^1  
   
> @QP 0VU %@   bk  O
 B89:;<=>M?
$*
G$WBkr+_B,/1  4 		  
  ,     
|%( (,%*26', 49$,0	
!&.3+0O$8= (8,$(c $&pva'  ,
( 0HH0 (	H 8 H
8 X jT`nT<	TDQf(XHHH( H* 4
$$T < PXAX@	d2PAhPh?#{Op p+ޥ
 聏8X8tX$v&π c Ãf;uA  : F   P  耵ÓSRƠP Ȁ>cu/q@ 3ۊP.B.EQ J &G+qt0 dl<8t<?tlBIP%@.@*0Q` e `fl Y @ 3\ 	Q- 0YpX[À2о2p0F .q/  bqÜC
G,S G@~~|ֺ| |8`8| 8  l  <~<RÁ ff 6xx~~~p`>>66f<ff<  >qf  f {; <f8ll8]x1~0P[ }\0pp0$ff$8|||
<<a wlllrll  l ~| a0` 8l8vvPb P``0 @ 0`   caa88 |?| x" f<| <l |oƀ "j|  ~!0B alP
a01P 
  ~
 ff|ff f< ll  b`|`` 
Ʀr < p  `b% 'Ɓ|:ְ|~Zƹl) ll#< ᆀ P
| t%|| -0x?|~ ` )  `̀ 6000Vq(v |8 x?`flxld& lܢ-ԁ| p%| '| 06p'( *2
v 0d# 6k1  8 v4pl`p;5 |ƅ88<
l8|'!f|ƀP/&&00 %:l~n ~ހ1-7 0
	'!r~`l`fl fEK>c8c> >a+<4   ,+> >`gc=  G0`2#`?#: 0|6>΁ l<~61F  6ll6и` l  "# UF# w# rd 
 6 P P 5 `ROqPd-JUQ2d77[0??0 a66R9 ˃a	
 R>     f 9x+eb]Pf```p_d~̀Mi|pv=8 Sl8T(r(l`"8fj~C|q^ 8`T``/Paa! b~ Y@ f`[ ps xm a ʐ<<S2tflD8p&mp0t| wqҁ၁PQ'lpEcFlpxp q5aq3 Ԇч >6`vf ~~`>~~>ՂR2$ P {p4`||s4S
3t u9_2`!@AH	P!3pxF)bf8wP0v~m	ǰ {16879
G -3a5@әAPp| @ѓ`;Ҝ2#a=Ғ~BC  ҥ R0*Ҥљނ@tPa7`p0iQ.f?`d|d``
`ζL ӥ񦴝8Rp bq
 xp S	 	
qQF#a`(L %4bL~Ec࠵ 4-z0a6P6 rFl q  a 	 PS$jǷ b[6 qb
 P$=bX
 TO5.  'Ma0
Aβ оcs\A  Ug^t"{ ځY
0x"p	#	$@%#Qb 
# p
 
%	"Ђ# Da6f0Prʀ 
$ 	% 	 	C	JCdw@`1|cc0c Д~	?!	8  ld>BPP<@ WWd! 3`p3 B< ;8>dp` ~0]Zwl^}l Q6>6n6@s&`t؅D+  f 5ڿZ E d

Z Ӥ cgफ़ cb
d
 d5e全 5ek
 c
eqe e:%
 

9Ը=3;1N  Q1b0i2S$| ҏ05Yap``<f	`q|  t0^0v 3 ј/AX`ix ؗx8#?~ SY/ (ҡ 9P2M  "*TpYV!" RtWrX"/f<<fDY3-\Qmypf1hwfz$0 Iߤq m   ts | >>T_
3&&Ϭ
&UPSSUUSSSQ{RPtFW2@ _`&&M?.W@
&FG_&E"&E#W^_&]%&}&It2.82
t@' 9) = ~=^~=~=~ &U*&$
$

0B$
	-0
12;t4&wt  pu`2Ԋ%+Fà_t6@ X2 ø  t` :t0?FË7 PuBb%C ܊J 2  &GF %G @GÜQW+& &D&TAα w!	ʑ  p&
&TA2 [PD_ 	 I!_Y` GQW(6(5p 65r 5ts | :&?Q 0
G@6D	ĸ 

 2
P2	2YQ4;G4~vn"f2^Yr /4 /9EPJJ  B2B0 XJ~w|VBBǃF^ú$
Ĳ@`  t Q%Pۀp;;$<~&G3u<#t<2t<3tP	u&IRtAcNb  P3&2JGq IGLq ģ`XR23Ұ
)u 
ͿZ`N. un> tgp baLP>bP22AQJ2=QRP
u 32ZYYw2 XaZYYR*8}2.
Zà؋!+m 2Ku(W S
u
P]`[+сÊ2+**&R9  @/ZHuÊU
J@B J"bt1 P#Ԩ`X3d>I#t(q 2t! 3tQtt1pd ; Q@ !
+ .J
u8~` z@sC<0t :Jt. ` S _+!*2+uX ʻ u*tX Ë`u"t0 ]׊4"
ވÊ$"ð(cр  !$%D
m݁  +

,QVW++    e_^Q"YԊ_Ǌ_ S8v2QY2P  t (P
_RS߂7P2 PL[[ZRРJ2Z.Δ Δ 03<?& t
uV EÁ,ņ!&J aZ5	 [a2RqZ¾7L0 }
+ȴ@A
t
2&LoP zW >&}SjcظU`T<t
K<Ut2[ðo
 6]C%ŀA`A2+Q+++YZ0"Ȱ+Ջ+Nuâ` $` t  2tatBñ8~
td\8tX|0I~D*
u
8t8`t2
8~
~Ȁ}RtɊ*Ŵ
^!}NQTt
w_拄0['$jMtPi"t
wwyÀ|t#GZqKR2#Ze<RM5HU9Qpw@ @ AK+>+r,+Z 	脷"+R|T7t|S`ı@ (&Ѭám +㛋>u@F E&   P !V1GO+>2u	&}uƀtGVW_^t##ut>|  2ǋ 	1
qh|eZ`+0w!  pjr,`u
UQPЁ
6JX2D|BQ> CS O2PpoFfKu[3dT)!o(|=yTSUkujGPbsg 1KXPk$6| 62 &tiU؊PPu'U#ëNp &Np>Xr ì.1%   P I ãÀt&0@ "?   ì_&O 8r2pÊ02fQ ]fPfff  @JPS y[$<r<w<r⃿XPXfWQP< sfGufXYfo_Q,IY+R3Q	t8t༲ZI
bu　PxP[1^.X`oP.Vp`9|P9FopumĥXPRJWQP2_8v
0WaGYY_  +[KZ _G+B;v
3aݰ #òθct`epvu&fP - f `tf$t  
QsSP
/t t&   _&]X@v73Ĵ%PG`Ā ftmw eLp谭0Z
11u%  %%@Ñ1Ģ!?JbX`o>t1tTtTRn)?*"P2"PL}~a0csu@2PI<
vJgu36ʿ {ǪA?8sY CQt u`<
u:6u Ɖau@A<uއ<u
t22+qt++&eP>܋ˀ{ Їoñ.#t	O}3ɊpʰezkOF =8 uQq?0|NVS
I`u-,!Q̊.r{t.;t$.
DY⁉^#+3*2<{PRs;ZXt<tz =u<s`.M! rO # (CJVztÆ:; &D0=&}# 2 0<뵀w8 0$&e߀ te   ?02Nx2ı@aJGpbZ ËQ&5&m&M CY 8$1N0:Pu4t@N  v &5&MLq 4q4  {^os *TR  ]NV9 WPP;PY0 d2|XRZSA[ SBB  s  PQvuvX$ ۃ.>F[U<t,1m <wPSPRI@A@	ݙ tv=s=s=|s^=Js PZX][X<t<tˊ߀~ SP[àt@ 8 < @É.| ~ ÿȎp2.9. 
*@ ֽCr0ʽVz1_
uw5wx&P u͎..5!.HF
FVzCrCvCzVzVSؼ&G&g3t"<}訽A
<}	q-<t
<t̀
&Gз20' [   ߋP$0"3ҹ <u`Ȱ  3 bq|ut0 
PuÀu
&~̀r@S[t (22QF t  +YsuÁPW>&}t0&<t$@G Ȣ&E̠+!_X@3@_t G8du&2.Q{̐tN$
J	 ȋ>/uvtHk@ϊ& L2ܾVt
Czt<t? F0VJ>=&]&M&U&E
;P>X}21PSQR.t	00跷ZY[XpD|qS1zǐ5[VQS&`<
@<
t2_bZ' t&^ E	TrsP+PEu 0	~t2SU% ][ X[YZ3:0.d㶓 B
e^F?<u	A g p.:r2~@.] IPÆà$0<0tu` tq
2.;tq a8~ f CtPt!(诈t0
Pt# ? P 2  ~     ?     @t
$#K  1 (-=x'/"2f
$Aa 0ot$@6AR1%, wu#P8k=@Xv$twuP!s$f3phfû j$u*e 2, 'i- fV hû wj&iа|gj`v`0fQ}j # f 9jg+) u17Zj$<vFu t:L'tO(PPz WXZXixwu
$ Ů pwtVex^:t	Ou2Lo 		     
& *R 
-#F ` 
. &w[>-#|I_ԏ^ I 	pm  $X  H[;_
@K+j/

c{c	k 	z	[ , }-  
v3P[z
 1	F :   B+RI4	  
rU b]/Xo`b k
 
Ap 6b/ďc^`%
	 * s  	+[3
g{	6 	!	jr  &o %b{J
 )	Se
   
 * PV
	j
U fq ȿe(d v
 eGd f$du!Meu t	rtРL;u	  n! DT 4  !^`^_WÐPfRK_.ff2ffPGfOfRSWP? uDɰNS  ;A@u-f ff³f@P <Q&@D8DfX2fPX_[fZÐQu&QjTP2Xi$ K۰iY~WVSP6]fS%X3f ~q[fIf0
A@qX {   n u&_up
 uf [^_QSPǀt7P2@so&`\t6	2X[Rf׋f PX oNuU" 9$ M" ]$ (N" $ M" $ A@! $ J<<===>J>>??&@P@<>/<& z@.Am  F  I   @L0@ B B@    C @    @fD @    @F @ *   @YE @    @I  I@   "H @
@
@
@
J J@    Ѐ  K  G G@    @
@@@@^@J A UI HO߬OO@ OO`  OOOOOOOOOOOOO@L    PZf¶ÿLŪű@Ȥ  bʞ0z6zΒxдм"Bv  ӌV  ^&|D  dښ(  \f݊ qnpd zx  2UO@	4Fj,  8lnLRN@0   " F   < oP Dr%F@l@ ^~n NUǐm%
U} p` 
 
	$ @5<(
HH( K
o8 
UРH 
 
	
U p@pXЖ r%j< r8H qY 
8tXx } u
H0P VKx@o@ w
U@Px &~ d	U<Е 1  n	U+0L
F P~`  ~ 
K`P0 ($
U@ `a 0*	$K `p < @ [:
U 0 m*P
<4
K0=
 x;x 
+  0Up   Hm?	2<
D
A
VF
O	Y
U	  r~`A O	8< ` e
K	@ pq AU	<< 
@ p
K(
  v h[	@<P t
KY PK
	؋  `C B P	IM _N  `'c @d F N 
 H U  @E2  8  F     W, @5X3;P4`4	 0Y@  P ZH?@04 @ Еp߂CI  $	<(3O 	KU _t@t@ 
/P
	R0  N
$  r@FJ
! pR 0`p
 f + 	/*, , g- Whf h i g  U lo m k  Y   ~ @$40$pjU	 #
 20 3
jj
jUU
U


 @ 


 	
3456
STUVW
c d e Uf !
" 
#	$ 	ХDEF
stuv
    
$
Ԡl  p -  > 	d0S _r3(`7X  FE@L8-8X <
4$ATI5b0	@ k 	@&	 GI   l);.`W`U؋譀R 4`3L 3@}z}ރ )RRGR4@R
` R``% 
% [  70	B0S%qC`   pK
@qsC UyIQ%!?P
f ; Op\  @_TPAT XT "TT  @[\Yu `T D  
e7  OO p  44  ee 
L 

Y 



	 C@\ \ % f>
B  D0\aL%  0
0FB, R7[ $  
p_ B
B
Y $V #0
c OOQ 3bDeK4)] Q@ R {S siXpUYZ[rU`a b`cPhPi lޠ m$Aߥq IqB
e^ 0
|R#Q C$  A@BC C^I I
%I
!apR**q 2
H
Df	 ?

I= |G F&T(^0|BAhC_ J
J z "BDi %r [yuD<a  `яP)UQb B w&{+0~R!*@ Y "%""Y /`
!IY HY IY LudkY R[QΡC[N% [ P+ R<`EJ%T D K D. `%%%
D2 %
Q
%Q%

eV  9 !>@_b e Cfq 8%Q` QB" c c ZZC % s "
 Q
[	ڀN\'	
b 4Q R`R<
H `@
wwDK Xuq
%OQTzr b  3e - p
 
RR=RRR@R;RQRH[F Z=G ,
 U8B1c: c`cGN cU\ cc cjpV C_n t  US3	`
e=pbD @ I @	r r r C % aR#% RA%P%_Pp@piPg[ Lv`
C@@+ I@	,q Qr -*@* ,!*nB-[ aT=% I< 
 
`5R0=
)EO 5CO p
 5^[^/%Q2J%_ D#n,Q@!@եA7ABQ2O%$DJqUr 00]=@Q2[0)5alamQ n oepQJ%P ; lm@ n oepPmlm@ n o[l%C%`
ļ`
=p fiI0 
C4 
 kIB e$CF8$@%21%$0 z
5A[X!@|| ?Aq	%A>%A0D{ p  Dy T8 g|!2AqA2^|A
A@
A u 6#@@ qk|@ @C8sAs`0hc	
Aܱ/Ar
I/pV"

V`sJ|f Yg|[X[f-` 0?`M\BCeqp  [cH4 I. P%`
4P[5 3l%R[] 0 R

@w ΡP  gP[ x%Y& h    AA@F?
e fL% P\
 {
F ߠ j eA	%p>D~0' IyரC~ 
j 
lQ k 0pG##U
%% `pP #P
x #	e >@ I e@M p@@I
50I`~Rf	-
BPdcfdCj Dl EPwm DDR~ > 
 P\ 2 
0"b[FRB! c* c 0e f$u
 [` [
%pJa DE_PTew-`[<fVPD1 \% nPdAp$Ae bC;rзp0[)a #=pG p D[ C \P C(@ 0[X`Y0T [`l@ 8|
dp(xe paqsW@tZ`uvpvhT wG	TF	r!$rp D(a9'@[ V
lD2 = [G:r*[*[j@RF! C(Qq !0	}>\"@|! P`"P"@P%"-ƌWF `%CQ;;>TT  {@0
( 6"@0Be#
b-C
X 	[Ş(D   ?
{%p f$
 _ 	 5 r0$     H P; P\% $   ^% oq- A?A" xp [ 
	&M@0P	YSC fp&{ '" @>' 'e`b @B
P	0P	a9eY1 %% <
".T a`
`0  @`p Ӳ GE
\a?[C*%8
       p [ D =·J@yAйQ
3s>
CJ%p =e ff J/
 @ qP  P
% e wC6o
  0D   	
 >0FS\CݶpH 
v P0^ B!   = Fk߰ &
	 @	'!
PS *<qDYn I:rPfCBT Wp)P  C 3@Ǯ}wpfq'  4 V B
B  [`I  L
`Hw`ppp	 t Gp
 [;JI :)`2 P#	: 4 }[P`[ e!$!:K?K5~K0
0K`	 l `2((IhD `^w   
 
`\ `  \ߝ\00h  B0 cb cQY H i*d  @`0 I@֣  ` Dd3R#i[ i8C^ [3<! `F Ea D=DT` '
"@Fa-bCt1o:8
 qV:@T- 
 3 pJ  0_
` P6  <O  G EP OY3V 
pWaiB>*",4/@V
0cU@F) 2`Y? @ L`m cà@ ÀR
!Y C" 
Y1-~e 
ajT2C뀙Y
j
keacd[uˈ T  @ v3`@Gxi xlqjB"V _ h c}q  c	@\e SC +  %U u	R1# =aû3&
"J qAn!9c= &` c
BcYZZ=_ I5PRopeRpqp!   ;tD๭ E:4@o0q3!+ @j  f -k    M0DS '`!P I^P 
@
G
 `Q94p
U! s9 TIQ  Pd .2h
pe [p_d. 
~!
 
O& 
'вpplDQlH-Q|@m  }  @[g6od
ooj*S	HJn~`   Kڰ
` `M/ JMW(<
h݀ LqOK%D{  < +<
   SDE \! @$!ނx\% V`j lТjl Jm yI j`l02fqX AqI.0j %l;  mAq q IFpP `qCP q`` P0-- 
O%pDv -e `@iP D	JD -@p"> Dl. ϲ6
R  -k > ["r`!FPI0T @ q r p s @@@VȰ"`20-  R%<%EpQRP`66@`@}%!GD :6@ WU -e%$ '%  o01&* & `T.9 !1Il V " e $U8 = Io$Q!q%dq0zB0?1 ;W 0`Q   ,",*J@ 2 : 3,PSU(;oB:c c`c+ c7> \7 > D+ p C+ `}>`I+ 2e-% !e  ][ c" KDphкP &"P$P-#
BV21l?IS C B0Q s3@O DJe$ I `eTC $0}e%
$$1`%		R	 #@+&{!r,52e`2D,`pe {[[[ P] U  [ + a a  [y 0<2> p~H) !l|`C]0uAaك`
 Y !@-@
  '@@!@
@ l`@ݡr9rBjJ' r!% W
!	 U%U0QU1QAo _3%@"^@t[ ar 7 rR# (#  F,  QFEH I@ J K L!kMs N @ WAs B CSUDE3FGP3UQs R SSTU3VWXYZc[\C]^#_[ AU"! M6 c &3 Mkk0"`0@
 %3_`%0p=Ke 
k R\_% 0y1Dpx 
"  C N @ C1*0*0,+N%3{D1	
	
>
I 2	q "Pat0 0 
 1	
1Iq!	@!
 N3@p,@d +  ,+,Q'A @
@ 2Czp 
2 bB*'
"@M3J3 93 @{%00V"3̻ Q
 [( DЍ` e [` `[~   K     
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  PD68DTV   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 ys  f    Q?sY 戰f
   ff    f   tf ff
  rfBYi戰Yf3gC &f3f   戰 fHr4f f戰䈰%yf戰 rfFf    戰戰3{f  f   f戰fS\f[f   f   3f   f  戰g&3fFfCg戰|g}s 撰fPfSfQf   fQf3یff
   PxfYsfYf[fXSgu
  ;u[fPfSfQfRfWf   f3یff
  	 xfBf    f3g}
    fg
  r%fG;wg}
  f_fZfYf[fX  fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   (fsf ff   fT   (fsf wfD   f @(fsf [(fsf 5)fsf )fsf c1)fsf MG)fsf 7])fsf !s)fsf )fsf 7)fsf )fsf 3	)fsf 	)fsf 
)fsf F
f   t*fsf c
n&*fsf xX<*fsf 
BnnfLg&nffOg&fffsf fsf f   f   *fsf f~fs*fsf ef   *fsf F<|*fsf  6*fsf j
+fsf +fsf -+fsf x=+fsf =f   tV+fsf f+fsf of   t+fsf h+fsf +fsf S+fsf +fsf &f   u+fsf "+fsf +fsf Y&,fsf ,fsf )'(,fsf L'8,fsf 'f   N,fsf <wb,fsf 4 f%"f   t
fBAgf  ,fsf {ta$f  ,fsf ;RFf  ,fsf Df  ,fsf    Iuf  -fsf f fsff   f   f   P-fsf tff Ag&uf-fsf &r8u:-fsf &u$f3f   u
ffuf   tf fsf   -fsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  t.fsf $f  .fsf iDf  .fsf rf  .fsf 6   Iu f fsf   ffuf
/fsf %tf   ),/fsf $8uf   uffuf fsff   ftLt/fsf $f   t$<t)<t//fsf $ufffff   uf fsff   ft(
/fsf 8$<t<tfffff   uf fsf   t8f   ftF0fsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tTT0f   1fsf $t<tff @   f 51fsf "2  +O2._1fsf "<  ff   f.:w .D1fsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2Tff   f
.f   2f   f   ft/2fsf !< t8stff   uffff fs2Tff   f
.f   2f   ft(%3fsf  < t8stff   uff ff fs2Tff   f
.f   2f   ft(3fsf  < t8stff   uffff fsf   f    ft'3fsf $ $t<s
f   <tff   ufff fsf   ftT4fsf uff   uf fs2Tff   f
.f   2f   ft($4fsf m< t8stff   uf?fff fsfffsf fsf 2Tff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%_f   t_.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfT2.<u f   t2kf   uff   u6fsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   37fsf <|f`Agf&   f    f    f   r7fsf f    f    3f   ft7fsf Ufft7fsf ;fft7fsf !fft7fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   8fsf <|g&f~fsf fsfLf   f3f3ftr2f   t8fsf Qtf˰8fsf 5<	rIа9fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx_.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8_  f Lgf&fftf_  f~fsffHfuff Lgf&f   ftf@l<fsf f Lgf&fftf^  f   tf^  f^  f   tf_  f Lgf&fpffHf   tfHf~fs<fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	=fsf fBgf&=fsf  =fsf  Tff%   f
fHf   t
.f@Cg&Tff%   f
fHf   t
.fCg&fKgf&I>fsf Ff fs侳Tff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsTff%   f
fHf   t UfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}_.fDg&(_σ.fDg&.DfDg&f3Uf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`[f~fsfffsf fsf f Ef   .@ fffsf fsf Xfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_Bfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
_fHf   t_fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	_f   t_f~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H_f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fH  Hfffsf fsf f x_.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|_  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xHfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfT  f Lgf&f   tfT  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+`  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk`  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            D   @    L       @       H         `      T    G R         	 	
     X   	 	       	 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D     X      P    D    X      P    `                O    O    
Ol`

Ol`
Ol`	O A    A    
@          
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <4	     <4	     <4	    <4	    ,<4	    ,<4	    ,<4	    	,<4	    	 T <4	    , <4	    ,0<4	    ,<4	    ,<4	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                                       	4 @      T                      d  ` h   X  ?     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<4	     #<4	    P0#<4	    @#<4	    PP#<4	    	 #   !    8       ,      (  *  .         ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < fmf%f  $f$
tWppqtHfOmfupppppqimfumfupppppqf  f  gffLggf^gfnf    f
   "陼fmOfupppppqg- fm&ffnff  @$f@$
= u$<T)fHnff  @$f@$
и f  D$fD$
аfnf% = ufnsf fn^f %  fnBfU../0./.	/`./a. /0./. B쨀u?f0of d< ufKofd< t<t
u掰fsof䎊foffof掺<ufocf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fJq  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  $f$
иf  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   fcfs  J"lfs  >"對 f    < tg   f   ff   2fff   ff3s.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2s{           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE                                    	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
냈D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ftt vugf&>tgf&6f٢ꃰ &fE ~f^Y[fXPSRfV tA % g&ƅ    f;  \g&  	uf^Z[XPSRfV tA % g&ƅ    f;  g&  	uf^Z[XPSR     qZ[XSR  zC vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $f{f f	ffff]X t fff f	ff  ff{f_f^fZY[fXRfŋӃf3ӃZfPSQ  fA vY[fXf` f;.t
f.   ~$C vf3 
 f    fgf&E   > uF f  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f;   <  fk  g&"  @v@ g&  s fk  > u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     $    戰䈽AjG戰䈽W^ݰfcfmڰfyf&ܰff߰fyf f%"fǓWfѓ#ٽדܰf;fHf%f #ݰf
fܰf'f f
   `"	f   f3f30f  0f[f%f   f f    0f  f f   0	 f%"fzff.$f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.*f.cf@  
0jfK  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pf   FUus  6
  >rfg   ( r  .V>Mff<>3fffrrfff> wf   >ff%f3fff> trf> wf   >/>m>dff   fF>=,>#>	ff  > ff'fr$fff> trf> wѰf    } >urd>u]R	 D>u=/>u(f ']  >	r  KI	s 撰 X5y˗+E_{
-B^fSgf[gfPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@
 > u> 5xzytsfZf[fXúz.yuksfZf[fXPR tĺZXfSfRf@
 > uB ;yM@t&s(xغz,y0@u	sz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  vP f  	G 
f  胸腇faPSQVL	;t	  ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6js>t fafWf   g&D= g&D= f_`r r8 a`f  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`f靴f   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f>靹 gf&D5 gf&fff>fXYsufa`f  & gF
$
gF
f  sF>tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
ЊvaR  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tfj  ?   f~  +   f     f  j  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_Z&`&fPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇[XPSQRW0  3=  3/  3!_ZY[XPSȎػ    	   !    A   f   $       [XR # 1 ZSQW   l_Y[SQW   W_Y[SQW   B_Y[    f  f  fPQgf0& YfXf    gf~gfNgfVgfÿۤfPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .<t ø fSQ >tf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0fp   rg<uf   ⃸   Yf[fS>tf  r	f r>PfSfUUgf*gUfUUgf[Xgf   T r
g8u   f[                                Q  YPSR+;wZ[Xf> tftf`f  f3f3f3f @ gfffCgftftfaf   fuQYfVfSfQf
   f   f<rffYf[f^fQfWfVf @  f   f  gff^f_fY               PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{f<f[f)fD    2ø     "  @ =01/17/06DVT  @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff0  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        08/31/04BSA  ACFG      @   
         @                      @    a    p r  s    `  d    
     
    xx        I       " D b e t u v w         P @`     o  BL @ ?  
 
  
  @ @
  A 

  @ k     @ `       ACFG           BL      :  q @ 
  
  P    ACFG            q      3  q @      ACFG           q      j  q @        4  k  4   4  0ACFG           8q   9q   :q   ;q      M  x] @   k  0 0@0`00000  ACFG           @x]      J   @   
  A 
 A@ 
 A  k   ACFG           H      RH       K @      ACFG           `K          H      3  K @      ACFG           `K      'u    +   3      h                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             >>>>>>    >>G9戰 䈴^.d  戰䈰p  qذp  $撰 q	u	.. 戰䈀
t2K
r 2.$@ 戰
䈸@ ؾg ,戰䈰  戰a$apf.f. f"f  "u3g=r  4t3gr   ۰ 4怎    
 JvY6 5x          (A                                                                                                     M             f fffýq                    u׾$.   $.   u戰f @KC8BBaaff fKua$aff fKuf f u                è  Ӌ  è        è  VQD   `  è  aE       Y^Ͱ   è  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%      X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aË                              @   `$ff`$
ff     $ff$
ff?fظ   f$f$
fff
 ff fIf uff32fIf u߸   $ff$
fffظ   f$f$
ff   ffTCA6C @ @      Pff    t     t  g   $ff$
Њɀ`}  f   v$ffv$
$
Êظ   v$ffv$
Њ g   $ff$
Њɀ`}  3  G     ff	  2
   0 %" %
   @"	  2%0   W$ffW$
$$ظ   W$ffW$
Њ   Y$ffY$
$ظ   Y$ffY$
ЊZ   $ff$
$̊ظ   $ff$
Њ_~   z$ffz$
${ظ   z$ffz$
Њ   W$ffW$
$ظ   W$ffW$
Њ   z$ffz$
ظ   z$ffz$
Њ3.*w
  3333333!33.SN
  _Q
     <   f ffAfff   t^
  uF   u  8~"`   u  8~  8~  8~ fFf$   t8~8eZ33fffAf fffuu.z'  >*  <|S~  <duC
  f<tf<tf<t
f< tf3  <t2fFfa  uf  uft@t
@t@t
@   t   t   t   tø   iff% ~
    ~
  ( ~
   ~
   ~
   ~
   fˋظ   iff   f$f$
ff   lff% f ~~	
  
   
~
    ȸ   lff   f$f$
ff6f` fe  ff`f ffu"f߸   $ff$
а fGf߷   $ff$
Њ   v$ffv$
$ ظ   v$ffv$
Њ    ff fIf uff32   v$ffv$
$@ظ   v$ffv$
Њ       v$ffv$
$ظ   v$ffv$
Њf     ff fIf uff32fIf uڸ   v$ffv$
$`ظ   v$ffv$
Њ   t?   v$ffv$
ظ   v$ffv$
Њ  ?   v$ffv$
$ظ   v$ffv$
Њ(      v$ffv$
$ظ   v$ffv$
Њ    U   fUf@ f  gfUffIf u    =Uuff`f fff߸   $ff$
а fG=   ff   ff3   ff       ff    f` fa  f ff`ff$  f ff   tf$ft$
ff   y$ffy$
f
ظ   y$ffy$
Њ           <                  <  f߷   $ff$
Њf ff   tf$ft$
ff                 <K            <:  f߷   $ff$
Њf3۸   tf$ft$
ff          <   f߷   $ff$
Њf f   tf$ft$
ff   y$ffy$
f"ظ   y$ffy$
Њ                       <t?<tG<tIf߸   $ff$
а fG"  
 ff`и   $ff$
Њ2ffu   fffËظ   `ff   ffǋfËظ   dff   tf$ft$
ff   ff   ff&3fb ffAf ffuRffI   $ff$
؊fA   f$f$
fffGfGfFfu  .      ȴ      2ff Ȁ2fOf   $ff$
ffGf   $ff$
ЊfufGf   $ff$
ЊffGf32Ҷ
uf
 		uf utt
ffffAfff2ff#   t$fft$
ffظ   tf$ft$
fffFf   e$ffe$
ظ   f$fff$
Њ   g$ffg$
Њ   x$ffx$
ff܊
؀f} f}f}   xf$fx$
ff   Pfff܊ff?f f tfˀ    Pff   $ff$
$f tظ   $ff$
Њf4P%f @f@f@f@D f @t9t<u0f@f@D f @tt<u	f@ɀ u   3         P   +ȁ  X`   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_va.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  >>>>>>    >>G戰 䈽^ sRpqذp䄰 q
t23
r 2.$@ @ ؾg ,  a$apzffv ff怽kf.f. f"f  
1u3g=r  4t3gr   ۰ 4怎  `  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
It                         !          !          !          !                       p                                             F                 D  @        P      F      p  p      D           p      D          p      D  8         t      E         x      D  P              D                F  L            F  >              F  ,            F  >              F  >             E  @  <          F     `  8     F      L8     D  M         L8     D           L8     D          `8     F    d8     D           h8     D          t8     D     x     t8     D     x     8     D           8     D          8     D            8     D           8     F      ? ?   8     D          8     D           8     D           8     D          8     D  %                    !      9     F        9     D          9     D           @9     F        :     E           @;     F   P  >   ;     F   @     ;     D          ;     D          H;     F        ;     D          \;     F           `;     F     `      d;     F          |;     F        x;     F        X;     F          D4P        D6P     ?   D7P        EP        EP        EP        EP        E P      r  F(P      F,P        U         &                  '                    "                    #                    $                                         `                    a                    p                    t                                                                                                     0                                        `                    a          x          p                    t                                         0                    t                                        `                    a                    p                                        0                                        `                    a                    p                                                   N          0                                        p                                         0                                         p                    r                    0                                        `                     a          b          0                              	          `                     a                    0                                                  @     D           @     E            @     E   `        <@     D           @@     E     8    P@     E  B        P@     E     
   pqpqĊpqpqĊpqfĊpqĊpqffÎf ; @$f@$
и Pf ; $f$
и @f ; $f$
аf ; $f$
а P% = Af  ~$f~$
а pqU&' 	a` 0ᰪf   W$fW$
$f   W$fW$
Њf 8 $f$
а U0 W P4ffCf   fff%f   Pffff   `fff;f   dfffYf   hfffwf   lffff   tfffEf   W$fW$
ЊýNf   xffff   ʺ$f$
Ћf   $f$
Њ02ᰪf 8 $f$
а%@ 3f 8 d$fd$
аf 8 $f$
а3ɺ P  P Pf ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ fm ػ /fff ; Xfff%f
   ff ; Xfff P*$ Ⱥ P* P($Ⱥ P( P*$Ⱥ P*Jf   r$fr$
Њ 8>n 戰 f%"f   2f%0 f
   `"	  "	f  2f%0f  2f%0f3f3fP  0fX  0fA0fh  0fAfm  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fn  ff0fA0f  2ff
   0	對㨀M04/08/xx HMZ        J&        1  F!  $  $  ~%  %   %  %  X&  .'  L'    


>  ~
z
                                                                                                                                                                                                                                                                                                                                                                                                                              U (VWvv4RPI0_^]U (VW_^]ÐU (VW.% =  u . =F_^]U (VW.% =  u .   .% =  uF20  _^]U E(VWNa_^]U -(VWv \>0 u_^]PQRSTUVW pq$@t$.>2 u .2>2 t 0   _^][[ZYXU 'VWF   FF% 9Fr
  P@  _^]U k'VWG
 Pp P@q P@''% % 
 Pq P@ Pp P@q P@F Pp P@q P~@((% 
@ Pq Pu@p PF   RPp PF P:@**% % P P1@F_^]ÐU &VWF
 Pp P@'% Pq P? Pp P?q P?F Pp P?(% Pq P?66p PTF*% P P?UF_^]ÐU %VWxPm?%PxPm?xPU?%PxPU?xP=?%PxP=?9RP2 PhxP?
 PxP?  % = | xP>
 PxP>
 PxP>
 PxP>
 PF  H xP>%PxP>% PxPj>
 PxPj> PF~}xP;>%PxP;>x Ps_^]ÐU $VW,BFVFVB9V} ~ 9Fw _^]ÐU W$VW  RP  RPvvVERP#FFVFVRP_^]ÐU $VWF% P P=F% P Pz= Pb=  _^]U #VWF% P PK=F% P P:=F% P P)=_^]U #VWF  + F% P_% =  t  
 PF~Z}   _^]U =#VWF% = u F% = t1 F% P}% =  u F% PF% P    _^]ÐU "VW P P P* P Pn P P% F Pt%  NF P P,F  _^]ÐU Y"VW P P P F% % P PMF% % P P9 P P P P_^]U !VW 
 Py   RPm_^]U !VW%PM   RPA_^]U !VW( nFFn=  u    RP
    _^]U O!VWFPT _^]U 1!VWF O^RPF^N؎&w&7>RP?FV=  t  uP FF;F|' F^N؎&w&7vv
7 aRP PBtRPF^N؎&w&7f>RP>FV=  t  uP FF;F|' F^N؎&w&7vv17 wRP P%RPF^N؎&w&7=RP=FV=  t  u
 ^& RPF^N؎&w&7=RP=FV=  t  u h RP&  PRPF^N؎&w&7,=RPH=FV=  t  u h RP{&  PF RPd&h RPW& PFF9F}_^]ÐU VWRPF% P P P P P P>% =  t RP  F    P% =  u 
 F~s P% r RPJ P^&  r RP' _ RP L RP 9 3RP & # =  u= u= u= u_^]ÐU VWRRPF
% P PF% P PwFn% =  u P P% =  t iRPI  F    Pk% =  u 
 F~s P% v yRP P^FF&r RP h RP U RP B RP / # =  u= u= u= u    _^]ÐU #VWRPEF% P P* P PF% P P P P% =  t 'RP  F    P% =  u 
 F~s Ph% b 7RP  r NRP _ gRPy L RPf 9 RPS & # =  u= u= u= u_^]U VWRP	F
% P PF% P PFn% =  u	^FF&% P P P P8% =  t RP  F    P% =  u 
 F~s P
% _ RPDr RP4 h "RP! U 5RP B SRP / # =  u= u= u= u    _^]ÐU VWrRPF  a F% Pvv=  u  \ ^&% =< t ~RPa9 RPORPBF~sRP(   _^]U VW PxP^2F    P>2F~2s PxP12  _^]ÐU VW_^]ÐU VW_^]ÐU oVW{_^]ÐU WVW_^]U CVWRPeF  >  P P=  u .  PFRPw% =  u  F~sRP	   _^]ÐU VWF  ;   P  P=  t!   PFRP% =  u  F~s   _^]U aVWFF F FRPs   RP  P P=  u  w   PFRP}% =  t  V    RP  P PFRP=  u  &   PFRP,% =  t     _^]U VWFF F F0RP  P P==  u  s   PFRP% =  t  R   P PFRP6=  u  0  Pw  PFRPp% =  t     _^]U VWKRP  P P=  u  g   PFRP% =  t  F FVFV  P Pvv  PFRP% =  u     _^]U 7VWeRPYF  FF% = |@ RP3  P0 P  PFRPX% =  t  F% = t   F  FF% = |  P  Pp Pb  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% % =  t     Q   _^]ÐU VWRP  P  P  PFRP8% =  t   F  FF% = |  P  Pp PY  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% %	 =  t     Q   _^]UL VWF  F  FȌRPRPF  F   P@ P  PFRP% =  t    P  PS  P  PE  P  P7  P P)FVFVF F  & F^N؎&% = u F
 F~wF% =  u~ u/   PD P  PFRPG% =  t  9  P Pvv  PFRP% =  t  F     Pp PN  PFRP% =  t     PFƌRP  PFRP% =  t   F% %@ =  t F% % =  u  t  
 F~se~t  S FFFȌRPFRPFRPv!vFȌRPRP
F9Fs  K  _^]ÐUJ yVWF  F  FʌRPk
RPF  F    P P  PFRP% =  t  lFVFƉVUF     P^ƎFȃF&% PF~ s  PFRP>% =  t  F      RPF  Pp Pl  PFRP% =  t     PFRP  PFRP% =  t   F% %  =  t 
 F~sp~t  e F% % =  u  O FFʌRPFRPFRPvF	vFʌRPRP5
F9Fs    _^]U VWRPF  >  P PQ=  u .  PFRP% =  u  F~s   _^]U -VW4RPOF  >  P P=  u .  PFRPa% =  u  F~s   _^]UL 
VWFF F F FF  F  FʌRPTRPF  F  P PFRPu PFRP% =  t  FVFƉVyF  1  P P PFRP% =  u 
 F~s~t  1F  #  P Pvv?=  t 
 F~s~t    P NƋVRQvv
+
 FFF;Fs  FʌRPFRPFRPvvFʌRPiRP
 P P PFRP% =  t  U  P Pvvk=  u    P NƋVRQvvQ*
GF9Fs    _^]ÐU VW% =  t RP N vv% =  t RPh % % =  t RPH    _^]ÐU* !VWF RP? P P=  u FRPA F RP PFRP7 P P PFRPRP PxP$F% =  t  +% =  t VRPl RP~ PxP# PRPF  FF% = |7 RP30% =  u   RPF% = t O 6U% =  t RP,  % =  t &RP	  F֌RP% =  t IRPd  F F% = t F @uRP-% =  tO  Pz% =  t4 % =  t& % =  t gRP߃ A 
  P+vv% =  t .RP߃    _^]U
 }VWF  F  F  F  + v
vP Pvv%  FVnF~ tv
vv Pvv
  FV~  t ~ t     _^]ÐU VWF  F   PRPFRPRK  
F  F  + v
vP Pvv  FVnF~ tv
vv Pvv  FVFE F^N؎&N^يFN;u RP!ރ  F~w    _^]ÐU VWF  RPD P1F   F^N
؎&FF= sv
v% =  t RP݃ v F  = F^N؎&% N^v
َ&F% N;u FFF= s~ u v'	RP}
     _^]ÐU VWF  FF=2 | F^N؎& F^N؎& H	RP
  _^]ÐU VW F+ t@ ^&?dr4 ^&^& + t ^
&&^N؎&  _^]U츮 )VW6D 6B J	RPj	RPvF  ZƆX ǆV   V
&Ƈ VV sXRPFRPZRPvvvrF=  u 	RPFRPRT=  t  t 	RPnۃ P RP% =  t 	RP>ۃ PTR RP% =  t 	RPۃ PTR>Z=  u 	RPZRPFV=  t  t 	RPڃ P=vv RP% =  t 
RPsڃ P RP'% =  t (
RPCڃ PX% =  u8   RP RP% =  t H
RPك Pvv6`
RP:
    _^] 0!<s3P˿6 + r ׁsh3P1L!6
6
ƱH6l
n
66gP6g
P6g6g6&h
6 +۴J!6
 +3
O3X 6
6
6
6
6
P.L'ظ j
(P.L'ۚ^,  y>
uXP
 Pj
 5!

 %'!
)
&6, 

3
sx

 

&, >3&= t4
 
t3u!
,Ar
,Ar
ª 
 D!r
t
@Ky

 

 

 U3U UVW UVW.
Q
u't z 

b >
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>
 t
 P]ø Y+r
;
rQ3 V3B 22Ut
 Pt ^Ï

 <t)
&, 
3 3uGG>
ыѿ  
< t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ

6?6W6

u6
 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &
U
&, ÌF333t&>   tFu@$F	  RP 

Vϋ3_I36;
uQVW
 _^Yt^?G^
u͎^O]UVWV;t@t3_^] UWvt 3I >
u
@!_] SQ \
QP>![\
Yt[Ë r3]sP X2]s ]2 â

u">
r<"s< r<v
ט
Ê  UWVFG
@tG
  D
u VށFVD*P|]~ tZ
PNQKFFV~\t PFPN
 Pvvv)FP!tD
 ^_]U
Vu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S
Y[X+)D `;Nr/3ҋv+SQPS3DP.Y[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DPY[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU

t>]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %
炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt4u%
@t ~QWS EL
 cSV [D
tҋT+BUJT$QQttSY|V&;u3F3
 t QPPS7	3_^]UVvD
t$t ttd
3DDDD^] UVv PYށtL
G L
G ڍGTTDD  ^] UWVX
FF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvvG
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	4uVD
uFuAWt!DTTD E L
 S P[[tW3_^]UVWvt,3ۊ\
@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GP
= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*PD;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] w66666 7)7[7UVW3FFv&vF
t~ }F, <Xw$ FF.6V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuM
S
WN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
h
F
^
FFt~ u	Wd
guF u	Wb
&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]U^;
r 	>!rƇ
 U^;
r 	1>Z
 tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!r
& U2>
r~
FF
U2~FF  u @uW
uFV$
Ǵ=!su	 t % = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;
r
>! 
N
Ë]2ܡ
#3ɨuU^;
r 	s3N
l
ue>
u
N
V?!s	G
t@
VW^'
<
u&
:t<u&
G+_^t<
t
@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B&\
=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ
+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U~3uI] UWV~vߋN
t2Ì^_]UWVN'~3ˋvD3&:EwtIIы^_]   UWVv33۬< t<	tP<-t<+u<9w,0rҋˋ؃ X<-u؃ ^_]UVWN
F3҃
u~uUV

FVtpFFthvv^&G&tN&w&7;v7^&&8=u+Vvv^&w&7
u^&&W@
F3^]UF+F
F +F ]  WV@3VM@tG96s^_UWVv|96

	 4
&
=}3#
tVt
>

	 ^_]ÐUV2] UVF ]U"V < RP6
6
^&GFPFP~ u~ uFPfF-ȉFP FF*ЉFF^*^wv
Vu	~BVF*FF^&GF*PFPFPvvvR^&&W>
 tFPjt^&G 	^&G  ^]Ã> u ÐUV3
PFVu^&? u PS6
6
~
F^&?-uFGFRPvRP

^&?+t&?0|&?9F&?:ud< RPFvRP

	&?9F^&?0}&?:u*FvL

&?9F^&?0}t


 
^&
t PS6
6
	
& ^]ÐUV^&
C} &} &	~ &~&	|z&w
V~&u&_ۋ
 &_ۋ
F uF RPmDLF-
  RP+F^&u&;G|	u&| &9G|u&|3^]UWVv^ۋ
 u~~G< RPRP RPƹmȋFڙFVDFVڋǙځD SQȋF
ڙSQȋFڙSQȋFڙ

N^FǉFDPFFHFF
F>
 tFPbt	n^ FV^_]U
  FPRPFV+

RPLȋF+
ڙӉFV]ø
PU^,a<sAC
uڎ]UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VW1NxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! UF5!Ë]UFV%!3] U*!^OwG3] U,!^/OwW3] UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USW3F}GVڃ FVF
}Vڃ F
VuNF3F3OyCH؋NVFuf
fr;Vwr;Fv+FV
+FVOy؃ _[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UNWVHv
~H+#+#@+u uǌ 뾋FV^_]U^;
r 	W>
u
 tB3ɋ!r
tz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^
@t^^?u F+Ff^_^JߋN
u>V@!s	u
@t&?u Y
;s+3UVv&L^]UVWNwi
tH0N6

VW_^s+_;uX6
&t
;u>t>^0Nt

r 

39
tv
tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;
v;
v
3&EGUVA!	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MS Run-Time Library - Copyright (c) 1992, Microsoft Corp    Unknown command line parameter!
  Usage:
	TFLASH [/S outfile] [/U infile [/V]] [/?|/H]
Where:
	/S to save image into outfile
	/U to update flash using infile
	/V to verify the flash update
	/H or /? to show this help message             
%s Activating micro flash interface...
 /U Missing file name! /S Missing file name! /V /H /? Read a byte from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Read block from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write a byte to IIC... Mailbox0 locked Success writing to IIC Timed out writing to IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write block to IIC... Mailbox0 locked Success writing to IIC Timed out reading from IIC Security violation Mailbox command not supported Unknown error code in Mailbox5 Read ACK... Ack received Did not get ACK
 Trying to read ACK again... Timout... Ack NOT received Send Flash Write Enable Command... Timed out, or IIC access failed Send Frequency Command... Send Erase Time Command... Send Signature Command... Send Blank Check Command... Sending blank check command... Send Erase Command... Send Write Command... 
Writing...  [%s] %u%% Send Verify Command... 
Verifying...  [%s] %u%% Send Enter Flash Mode Command... Send Exit Flash Mode Command... Send Read Command... 
Reading...  [%s] %u%% Failed to enter flash update mode! Failed to read flash! Failed to exit flash update mode! Start Programming... SkipWriteEnable = TRUE SkipWriteEnable = FALSE Sending 0xF0 to the parallel port (pwr OFF, reset LOW) Failed to send Flash Write Enable command! Sending 0xFA to the parallel port (pwr ON, reset HIGH) 
Activating Flash Mode... Activate Flash Mode Failed to send Reset command! Failed to send Frequency command! Failed to send Erase Time command! Failed to verify Silicon Signature command! 
Erasing... (This may take a few moments) Failed to erase flash! Failed to write to flash! Tempest This is an invalid file 
Verifying...  Failed to read flash device for verify! There were %u miscompared bytes! 
 
TFlash utility, Version %u.%u
 Copyright 1999 Compaq Computer Corporation

 w+b Failed to create output file! Failed to read flash device! Failed to write to disk! r+b Failed to open input file! Failed to read input file Failed to program flash device! Failed to verify flash! 
Done!
   (                           _C_FILE_INFO=                                                         
                
	
\ \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    EEE50 P      0PX 000WP         ``````  ppxxxx        (null)           ) ) ) ) ) ) )      ; Z x     0Nm : Y w     /MlTZ  p   PST PDT 

                               '''                  F0<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
 NNB09Ho      CV   N     dos\unlink.asm     CV   N  D   
newseg.asm     CV   0N  |   searchsg.asm       CV   M  6   linkseg.asm    CV   M  4   initseg.asm     CV	fdata.asm      CV   M     fmalloc.asm    CV   M     stackava.asm       CV   K  \  	write.asm      CV   RK  ^   hmemcpy.asm    CV   J  _   	uldiv.asm      CV   RJ     lrem.asm       CV    J  2   lmul.asm       CV   I     ldiv.asm       CV   jI     dos\gettime.asm    CV   NI     dos\getdate.asm    CV   LI     dos\enable.asm     CV   JI     dos\disable.asm    CV   4I     dos\d_setvec.asm       CV   "I     dos\d_getvec.asm       CV   I  
   dos\d_commit.asm       CV   H  c   xtoa.asm       CV   RH  ^   hmemcpy.asm    CV   G     hmemcpy.asm    CV   G  k   
strstr.asm     CV   F  $   
strupr.asm     CV   F  V   clock.c     CV_cinittm.asm       CV   E     
dtoxtime.c      CV	timeset.c      CV   C    tzset.c    CV   B    dos\ftime.c     CVdays.c     CV   B     dos\outp.asm       CV   B  
   dos\inp.asm    CV   (B  X   commit.c       CV   B  $   
closeall.c      CVdos\diffhlp.asm    CV   A  +   
dos\hdiff.asm      CV   HA     getenv.c        CVcmiscdat.asm       CV   ,A     itoa.asm       CV   @  V   atox.asm       CV   @     atol.asm       CV   @  ;   strncmp.asm    CV   l@  *   strncpy.asm    CV   R@     
strlen.asm     CV   @  <   
strcpy.asm     CV   ?  T   
strcat.asm     CV   >     growseg.asm     CVfree.asm        CV
malloc.asm      CVseekfast.asm        CVncommode.asm        CVtxtmode.asm    CV   =     dos\read.asm       CV   ;    dos\open.asm       CV   v;     
dos\lseek.asm      CV   V;      
dos\close.asm      CV   ;  N   stream.c       CV   6    
output.asm     CV   4  D  fflush.c       CV   4     _sftbuf.asm    CV   2  :  _open.c    CV   2  I   _getbuf.asm    CV   L2  5   _freebuf.asm       CV   d1     _flsbuf.asm    CV   0     _filbuf.asm     CV_file.c    CV   0     _cflush.asm    CV   t0  B   printf.c       CV   .    
fwrite.asm     CV   n-  p  	fread.asm      CV   $-  J   fopen.c    CV   `,     fclose.c       CV   ^,     farstub.asm    CV   ,  U   dos\dosret.asm     CV   +  #   dos\stdalloc.asm       CV   +  `   dos\nmsghdr.asm    CV   *     dos\stdenvp.asm    CV   @)    dos\stdargv.asm    CV   )  "   
chksum.asm     CV   )     
chkstk.asm     CV    )     
crt0fp.asm     CV   (      dos\crt0msg.asm    CV   N'              dos\crt0dat.asm    CV   J&    dos\crt0.asm        CVoldnames.asm       CV      9&  
tflash.obj    
  $       	     
tflash.obj *     `   d   $      PromptError      pErrMsg   &              4   DebugMsg     pDbgMsg   .           .  ( F  	 GetDosTimeSlice     "         D  > t   alarm    s TimeoutValue     &     \  `        IoDelay      s io_cycle   
 	   l1  &         *  $    MsDelay      s TimeoutValue     *         X  K   
IntervalTimer  	?  send_eoi    "     (  ,  @  : R  Wait       delay  
  s i    *     h  l      	 EnableRtcTimer    temp     .            j 	 DisableRtcTimer       temp     .         k e 	 ActivateFlashMode 
  r i    "     4  8  ;  5 j  Sleep     wait      goal     "     l  p  C  =   Delay    " wait     "         @  :   SmcGet     index    "         D  > *  SmcPut     index       value    &     4  8  R  L n  SmcWait        mbox   
  r i    "     |    c  ]   SmcCmd     index       value    *           y $  GetSmmFlags     s iFlags   *          r  l   SetSmmFlags      s iFlags   &     (  ,  ,  &  	 LockIIC     &     T  X  ,  & B 	 	UnlockIIC   &         @  : n  	SoftDelay    s Seconds  "              Exit     s uCode    &         s m  GetParam     r argc      argv     
 p
InfileName    pOutfileName    
VerifyFlag     temp2      temp1    pStrTemp
  r i    &         ; 5@
  ReadByte      value       Address
  s i    &     L  P  ] W|  	ReadBlock     Buffer      Count    
   Address
  s i    &         < 6   	WriteByte      value       Address
  s i    &         a [  
WriteBlock    Buffer      Count    
   Address
  s i    "     `  d     x ! Ack       Status      Address
  s i    &         O  I  	 	SoftReset 
  s i    &            j 	 
TurnOffVpp  &            | 	 	TurnOnVpp   2     (	  ,	      	 TurnOffProgrammingMode  2     `	  d	      	 TurnOnProgrammingMode   2     	  	    y  " SendWriteEnableCommand    Status 
  s i    .     
  
  b  \ : " SendRESETCommand      Status 
  s i    2     \
  `
      " SendFREQUENCYCommand    #Freq       Status   2     
  
     j " SendERASETIMECommand      Status   #ETime    2     $  (     & % SendSIGNATURECommand      SignatureBuffer   buff       Status   2         E ? " SendBLANKCHKCommand       Status     BlankStatus
    i    .           " SendERASECommand      EraseStatus    Status 
    i    .     
  
  o i % SendWRITECommand      BinaryImage    ProgramFlag  &ProgressBar    WriteStatus   ImagePtr     s CurrBlockCount     Status 
  s k    s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .        $    % SendVERIFYCommand     BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status 
  s k      VerifyStatus     s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .     p  t  r  l ^ " SendENTERCommand      Status 
  s i    .         r  l  " SendEXITCommand       Status 
  s i    .          B % SendREADCommand       BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status   s PercentComplete  '	ReadParam  
  s i    s 
ProgressCount    s 
MaxBlockCount    &            y \ % 	ReadFlash     BinaryImage  *           % ProgramFlash      BinaryImage    Status     SkipWriteEnable  s 	FlashSize  
    i    (SignatureBuffer  .     0  4       + CopyBufferToDisk     pbuff      )fptr     s 	LastBlock    s 
FullBlocks   " Total    .            ! + CopyDiskToBuffer     pbuff      )fptr     s 	LastBlock    s 
FullBlocks 
  s i    ,
TempestString    " Total    *     T  X     " . VerifyFlash       Wrotebuffer    
ReadBuffer   s errors 
  r i    .         _  Y # / InitProgressBar       ProgressBar
  p i    2     <  @  f  ` n# 1 IncrementProgressBar     s CurrBlockCount    sPercentComplete  
 s
ProgressCount      ProgressBar  "           u o# 3 main     r argc      argv     )Infile   4OutfileName  Z4
InfileName   X  
VerifyFlag 
  Vs i    R)Outfile      ( 	8.00c              H&        0      H&  tflash.c          .   4   ?   F   Q   _   d   n   t                                                                           *  /  9  ?  A  C  E  R  ]  |                            -  ?  L  `  c  j  u  x                      	    $  <  T  a  k                    '  1  >  V  `  c  j  u                      $  *  5  F  W  h  n  y                          $  /  =  G  U  _                          !  .  <  B  M  Z  h  n  y                      "  1  U  X  e  o  r            	  	  H	  O	  R	  	  	  	  	  	  
  
   
  *
  9
  @
  K
  X
  i
  w
  
  
  
  
  
  
  
  
        #  )  6  <  I  O  u  |                      1  >  U  X  e  k  x  ~                      
  
  "
  ;
  H
  N
  V
  n
  
  
  
  
  
  
  
  
  
  
  
      !  .  ?  P  b  }                    	      )  /  <  B  h  k  q  x                              %  3  ;  R  `  c  j  u  |                              !  .  3  :  E  M  c                        >  _  d  j  u                   &  1  >  Y  z                      1  4  7  J  c  m  {                           $  2  S  l  v                    	        $  )  6  C  H  M  [  |                            #  D  X  y                	        *  .  2  P  g  u  x  }                            ,  M  U  c  q              	  
  +  B  P  S  X  ^  i  v  ~                  	  *  7  <  B  M  a  f  k  x                    	    $  ,  H  K  f                       <  ?  M  P  U  \  g  u                                  "  &  3  D  R  c  p  ~                              (  +  .  <  ?  D  R  _  b  g  u                                       $   '   4   9   <   F   ]   `   m   r   u   z                                    !  !  !  !  '!  1!  K!  P!  U!  X!  {!  !  !  !  !  !  !  !  !  
"  "  "  !"  &"  3"  6"  @"  H"  h"  "  "  "  "  "  "  "  "  "  #  #  #  #  E#  W#  d#  g#  n#  y#  #  #  #  #  #  #  #  #  #  $  $  $  $  7$  ]$  `$  l$  $  $  $  $  $  $   %  
%  %  %%  2%  ]%  j%  t%  %  %  %  %  %  %  %  
&  &  !&  -&  0&  =&  C&           
 !",./02<=ABCDOSTUVWadefglmnq
&'()789:;HIJKLZ^`abcdstuwxz{
 #%&)*+,-9<>?@BCFGIKLMOPRSUVXYZ\ilnoprtuxy{}~,012345?AKMWYZ[efguyz|}~

 "$%&'()+-./23689:;=?@NSUVY]^_bcfhijkmop~ 	
 "$&49:<=>?@NRSUVWXYgloqsuwx|} 	

 "%'(-/015789=?@AEFGIKNPQRTUWXY]^bdefstu	
 "#&')+-/12578;=>ADFHILNORTUXY[\_bcef
      $	   j   _Sleep    "5   __flush   4   _fflush   
   __fheap   p
   __oserr   T-   _fopen    v;   __lseek   <   __open    HA   _getenv   M   __stackavail "    _TurnOnProgrammingMode        
_TimeoutCount     _IntervalTimer    j   _DisableRtcTimer   ,   _dcnt R   _Wait    _Exit   %   _edata      -   __end (   _exit 
   __intno   @   __catox   B   __outp    H   __cxtoa    	   
___aDBexit    0   
__endstdio    RK   	__fmemcpy 
   
__amblksiz    #'   __amsg_exit   +   __NMSG_WRITE  B   
_UnlockIIC    $   _GetSmmFlags     _SetSmmFlags  l
   
__daylight       _SmcGet   
   
__lseekchk    B    __anullsize   l
   __osversion   I   __dos_commit  j
   __osver   F
   	__acfinfo 
   	__environ ,
   __sigintoff   p
   
__doserrno    &   _SendSIGNATURECommand    _Delay      %   __edata   n-   _fread    =   __read       _WriteBlock   *,   
__maperror      	   ___aDBswpflg   	   ___aDBswpchk       ___qczrinit      _ActivateFlashMode    h
   
__timezone    ,
   __nheap_desc  *   _SmcPut   x   _Ack    -   _end  ;   __sopen   B   __inp  ,   _Key  h
   __psp 5   
__flushall     J   	__aNulmul    _SendFREQUENCYCommand F   
__inittime       _SmcCmd   X
   __fac F   _clock    RH   _memcpy   ?   _strcat   @   _strcpy   C   __tzset   G   _strstr   "I   
__dos_getvect 4I   
__dos_setvect 2   
__openfile    E   
__dostotime_t    	_GetParam t    _alarm    
   ___argc   
   ___argv   
   __iob    __iob2    NI   
__dos_getdate M   __ffree   4   __ftbuf   4   __stbuf   jI   
__dos_gettime |   
_ReadBlock    \   
_ReadFlash         __EmDataSeg   
   __pnhFarHeap  *
   __sigintseg   +   	__myalloc 0N   __searchseg   1M   	__fmalloc ^,   	__farstub    	__lastiob "   _VerifyFlash  ?   
__findlast        	_rtc_regB (
   __aexit_rtn      _SendVERIFYCommand    !   _CopyDiskToBuffer k
   	__osmajor j
   	__osminor =   __cXENIXtoDOSmode    _SendERASECommand     _MsFlag   @   _atol R@   _strlen   *   	__setenvp     _PieTick  2   __getbuf  (   __FF_MSGBANNER    ~
   __citime   6   __output   )   __fptrap  J&   __astart  N   __newseg  n   _SmcWait  &    _HelpMsg     _SendEXITCommand  f
   __pspadr  d
   
__umaskval    F   __strupr  d1   __flsbuf  ,   	__dosret0 B   __fcloseall    ,   
_dummyread    B   _SendREADCommand  
   
__exitflag    C   ___tzset  `,   _fclose   V;   __close   
   __fmode   N   _remove   ,A   __itoa    n   
_SoftDelay    @
   __aseghi  B
   __aseglo  0(   __c_exit      _IoDelay      _MsDelay  0
   __lpdays      _Timeout      _PieFlag  t
   __osfile  LI   __enable  ,   
__dosretax    Q?   __incseg  
   __cflush  n
   __osmode   J   __aNlmul  RJ   __aNlrem  N   __unlink  I   __aNldiv  0   __filbuf  
   __ovlvec  
   __pgmptr  G   _memmove  (B   __commit  
   __iomode  &
   __atopsp  $-   __fsopen      	_rtc_regA |   
_TurnOnVpp    l@   _strncpy  @   _strncmp  v
   __tzname   
   __fpinit  *
   __asizds  .
   __asizeC  /
   __asizeD      __AHINCR  #   _main N'   __cinit   t0   _printf   b
   _errno       _LockIIC  )   __chkstk  @)   	__setargv j   _SendERASETIMECommand J   	__aNuldiv    
__aDBdoswp    
   	__adbgmsg 
   	__ovlflag                  _PromptError  F    _GetDosTimeSlice  >   	__growseg     	_ErrorMsg M   	__linkseg M   	__initseg 
   __child   r
   __nfile   J
   __days    (   __exit    
   __aaltstkovr  .   _fwrite   B   __ftime   K   __write   n#   _IncrementProgressBar      _ReadBuffer   L'   	__dataseg L2   	__freebuf 4    	_DebugMsg     _FileBuffer   A   
__aNahdiff    v   	__acrtmsg     
_pic2_mask        _CopyBufferToDisk"    _SendWriteEnableCommand   '   	__cintDIV T
   	__aintdiv     	_pie_flag j   _TurnOffVpp   &(   __cexit   
   _STKHQQ   (   
__ctermsub       _EnableRtcTimer   @
   	_ReadByte    _SendBLANKCHKCommand   	   ___aDBrterr      
_WriteByte       _SendWRITECommand     
_FlashMode        	__AHSHIFT )   __nullcheck   ^   _SendENTERCommand 
   	__commode     
_MINOR_VER   "    _TurnOffProgrammingMode        
_MAJOR_VER    :   _SendRESETCommand ;   __getstream      
_SoftReset    o
   	__cpumode H   
__cltoasub      ,   _BiosRtcHandler   v   
__acrtused    
   
__cfltcvt_tab +   __NMSG_TEXT   ,   __dosreturn   )   
__aNchkstk    JI   	__disable D
   	__fDosExt D   	__isindst    
_ProgramFlash #   _InitProgressBar         P         X      @  h    (  @      P      H      H        X    
   	   
                           
   
      	         	   	      
               	      `"$  kB    PcP|
  6J	
  VJt  f  j  u  KqP   f  Cx  E$
  t
  %   [jDT  kW,  k%  , `    pT   ^%p    rE  4  V_  vp     Z{  z;R   |   fL   /[/d       f  HR@
  zJB  +ը  !D=
  {#  .wd  ?R{<  }{x  ?CP  r`  ҄  aU\   !	  u"  !
  j  0h  '%  
u  `  
k  >$$  {u(   07  U<  ns>BH  DE)h  UD  O  KX  Z
  zk
=
    !    Z]ՠ  }  xo_  ǲL-\  fwl	  Z  Lc  Ϋ  <Q  
x  F3  e`  e  C   D  F  <P,
  Z

T
  J{`
  ˻|  K   |  y|  ϫ  ǲ,p  6|  uXʸ	  z"
  
ʋ(  '_  Ky  >,   6t  Z}t  `a  T0  
E0  hQ<  Q(/T  Y؛	  m*<	  	  y k@  % 
  )@  {  bH  =Cr  ۫  
"U   zD4a@    2@  	  YD
  X*1   xz#  > x     e3(	  	  0  +(  ;   aLu\  k  !`L  MՔ  (   !@  4p  &R  G  V  zj
   p  \j  f]u     ҟ0T  f  倀   vq  "  5'|  	L  mq8  Mh  u׸<   $Ը  zL8  hұu,  p  v  ~P	   ˰
  [u  H  >)H  z/XNP  yr@`  5H     j
<  1  alu   (  3֐  o
`      $`U  0  
  H|0T  k4  lj  =   0  ?(  M؛	  d
  IJ
  q
Zvl  Yh  kPH  <f(    q`  }]  		wP  ?
$  6C44|  *{`  FsҜ  xf  *g  [^D  
8
  L
  {
  |%  M  f_Ntd  }  zh  2  7˛  [
  Żt  M{L  Kz$  {  2_	   Z74  ^60  ;  vcp  0  8ݱ  	^  D
    
h  {&  g]P  !  "h  d(
  ;
{    |[  =W~  #P  T  ֋4  v|  `  8 h
  1j
:X  ]  ݻke   U-                    H  P  p  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x                                      H                                                                                                                                                             4     F     t   X     l          P  R      $  j          j            *  |
  n        $      @      B    n  `          @
    |  4    0      x  d    t  j  <  |               0  :      |  j    &      l	    L          ^  
    X  B    \  x         	  !    "    #  (  n#    #  T
  J&  8  '  P  #'  `  L'    N'    (    (    &(  D  0(    (  	  (  @
   )  $  )  T  )    )  h  @)  	  *    +  h  +  (  +    ,    ,    ,  H  *,  h  ^,    `,    $-  d   T-    n-    .    t0    0  
  0     d1  t  L2  	  2    2    4  p  4  (   4     "5  p  5  ,
   6  L  ;    V;  x   v;  ,  ;     <  P	  =    =  4  >    Q?    ?     ?  4  @  	  R@  T  l@  h  @  	  @    @    ,A     HA    A  (  B  
  (B  @  B    B     B    C  H  C  d  D    E    F    F  
  F  \  G  
  G    RH    H    H  <  I  p  "I    4I  <  JI    LI  D  NI    jI  t
  I     J  8
   J  L
  RJ    J  $  RK    K     M  \  M  T  1M  p  M  \  M  <  0N  h
  N  `
  N    N        H             B              H     
  &   (          `          h          	     	                   &
    (
    *
    ,
    @
  0  B
  P  D
  h  F
  L  T
    X
  ,  b
  
  d
  
  f
  `  h
  <	  j
  T  j
  (	  k
  $  l
  $
  n
  |  o
  P   p
    p
    r
    t
    
    
  |  
  
  
    
    
    
  
  
  t  
    
    
    
  
  
     
  0    |    
  
    
    
    
  8  
    
    *
    ,
    .
    /
    0
    J
    h
    l
  |  v
  
  ~
    
  <   
        `      x                          p            P     @     @                 
           0ݽ  Y     !q7d   Y     4`tp  Y     5`  Y      6ErrorMsg    z	  Y     `  Y     1W  Y     `a6  Y     @[  Y     _iobuf      ACK  Y     ]fQ  Y     "  Y     &üX  Y     pR{d  Y     {,  Y     fÀ  Y     `
  Y     BP=  Y     -s  Y     4ӊ5  Y     DcP  Y       8
ReadBuffer     
_fonexit_t     $ė=t  Y     5}   Y        pie_flag   ,   dcnt   UD  Y   
  FILE   @  Y     4TT  Y     uD  Y        MsFlag     ,  	dummyread  6P  Y     @K
  Y     `   Y      , 9BiosRtcHandler     V
$  Y     f  Y     &p   Y     HGH9$   Y      8
FileBuffer     ! wchar_t       rtc_regB      rtc_regA      	FlashMode  4p48  Y     
  Y     x
`  Y        PieFlag    $   Y     Df,  Y    &  7HelpMsg    s size_t      s Timeout     time_t      5	MINOR_VER    5	MAJOR_VER    Y     ,   Key     fpos_t     onexit_t      PieTick    
  Y     d	  Y     ?q˨  Y     pva_list    L  Y     D
8  Y     `ݱu  Y     Ľ}   Y     -4  Y     ~ٶl  Y     ^RX  Y     NB
  Y     !Qu  Y     	_onexit_t  ՞N(  Y        	pic2_mask   clock_t    Z2,	  Y      s TimeoutCount         p         0    X  x           
                    0ݽ    ACK   pR{$  t  `Cr%h  @Kx  `   hs  &p  HGH9,   KEY  `ݱu  ^R@     !q7D  % YX  6  aW~(0  !QuT    z   "ޤ  V
  L  Z2  _%@   kf'd   `t   1W   `a6   @[  {،    ;]1  { g   { W  k,  k$   ~ٶ    4`t   $T  4ӊ5d  DcP  $ė=  dT     4TT0  u"  tg@H  4p4X  
h  x
x  #  Df  4U  Dځ   DʀTp    d\  D
  Ľ}t  4`0   5`   ]fQD  -sް  5}   E4D  UD   uD  $  C<  e[4L   \    -P  ՞N   &ü4  BP=      fô  f4  ׸  ?q   NB`  ]w,                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  6                                                                                                                                                                                    4     F     t   X     h              R         j        j            0   *    n  H      $            B    n      d    x  @
    |  X             x          j  t   |               T   :  p    $  j     &  P         d     h      ^      T  B  0  \  4           !  D  "     #    n#     #  t                      @        &                   `     4     x     \     0                     ,          D                      OLDNAMES.LIB
CLIBCE.lib      :       T   l   t                                                $  0  <  H  T  `  h  x                              $  0  <  H  T  `  l  |                  R p   _ptrr   _cntp  _basep  
 _flagp   _file           _iobuf   
  r         
  r         p
      
         s 
      

          
      
   
        " 
      
       

      
      
       
  s     
  r    
   p  r pp 
      
     
  s    
       
  s    
  s    
       
        
          
       $
     3  
       
           
  p)
       *
  p    
    
       -
      $  s ss 
      0
  r 
  r    2
  p  P     r 
  p  !  
  p              . -               N                      &             . <              E M           - U Z     B      - b h B   
     - m r 
        - w ~ 
        -   
        -   
         -   
         -   
         -   
         -   
        -   
         -   
         -   
        -   
         -   
         -   
         -   
         -   
         - 

         - 
         - 
         - "(
         - -2
         - 7<
         - AF
         - KQ
         - V\
        - bf
        - jn        - rv        - z        -         -          -          -          -          -          -          -   
      -                  _TEXT CODE EMULATOR_TEXT CODE C_ETEXT ENDCODE EMULATOR_DATA FAR_DATA FAR_BSS FAR_BSS NULL BEGDATA _DATA DATA XIQC DATA DBDATA DATA CDATA DATA XIFB DATA XIF DATA XIFE DATA XIB DATA XI DATA XIE DATA XPB DATA XP DATA XPE DATA XCB DATA XC DATA XCE DATA XCFB DATA XCFCRT DATA XCF DATA XCFE DATA XIFCB DATA XIFU DATA XIFL DATA XIFM DATA XIFCE DATA CONST CONST HDR MSG MSG MSG PAD MSG EPAD MSG _BSS BSS XOB BSS XO BSS XOE BSS XOFB BSS XOF BSS XOFE BSS c_common BSS STACK STACK DGROUP    Y                                                                                                                                                                                                                                                                                                                                                                         tflash.c     c                #     ,        L   !     p                                      !    	       
 (        H       h      
                 $       $       #     4  $     X  %       %       %                            0       P       p                                           !       " $  !    # H       $ h      %       &       '   "    (       )       *       + <      , \      - |       .        /       0       1       2        3 <      4 P      5 d      6 |      7       8   !    9   !    :   "    ;   "    < 8      = X      > x      ?        @       A        B   !    C        D 8       E X      F h       G       H       I       J       K 	      L $	       M D	  #    N h	  %    O 	  $    P 	  $    Q 	  $    R 	      S 
      T <
      U \
  $    V 
  0    W 
  !    X 
      Y 
     %Y     'Y   D  *T0  '  )W  d  4Td     (dd     +d    -Th    .k    3m  x  NB09t              buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        