#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTT)  - Linux-Based"
BIOS_VERSION="F.0D"
FILENAME="sp31848.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<FreeDOS    @	             )0ROMPAQ461  FAT12   1ؽ | ^|  ` ؎Ѝf~$uV$F F  FreeDOS v~v v҉~ԊFf׉v։~؋^F1Fƃ vډ~܋F֋V؋~^Z r/~Z }W_&Et &= urYP^Z~FҋVk XrF^\  s=r1^Z  	t$HH~
 FV$ s  err 0^$nZ1۴^V< uVFȉVʌFƉ^ĴAUV$trTu
v^̉^δB,NȋVʊFfvшƆɊF(^ĸV$s0뢋FvFƃFV OuF^KERNEL  SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY                                                                                                                                  `  @`ǀɠ 
 
@
`
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!35a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY                                                                                                                                  `  @`ǀɠ 
 
@
`
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!35a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ROMPAQ               ^a3      KERNEL  SYS  -KD1D1  80 ~  AR o m p a  ?q . e x e     ROMPAQ  EXE  h,@[33  pS3 ׷  CONFIG  SYS \LD1D1  71 8   GPL2    TXT 1K1    h/- G  f s a F .  t m p     SAF    TMP  uv_3_3  vv_3      8DTU   BIN  vv_3_3  2MX34   AR e a d M  se . t x t     README  TXT  _3_3  l3[    8DTA   BIN  Ja3a3  sX34   68DTT   BIN  }33  v34                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   CONFIG    nused9W䯉 .ls璯 UUPX!
!5Zj  * CONFIG   PS1 [XꐤY A]o1ؠ$.  t.&<u ÿ,. u	t= ru.&..>t$*/.mtG
bAe=6w[&G)ƆPVWUS[]_^XP@ ؀q XSXR-LF,@:,4. ,($"(,,0,4
8,< RPȎء2;4v*҉6&V0)n	XZ [	,.W.VGVPPkvp0B[kb! BH~PQRiS^ct G$:wbƗS. .TYYg
OW,5>+dRoGo	[ZYX^˩vꍱ)J.~7bG۶?CYa+,'QPRU,rlq6+_.Y&rA]ZX^wy["
7xWFH t
/=]^ *&t tF 3h
6ZFkq7}-3c~</
h'_f
 Ӂõìލ. u6 5t/GKum4	ruO0$0<0n_t)[t$
o-<QS1ln%HݻFYt0o؄?;YeP]f>}
7E&}U<et<Eu&
5V\]n-  @PRN# AUXFALPT192s_3G,kM1>A2yP#y3b)4ti~LOCK$[ O
 " bܜ nO0_}	-s'3h s=OiqjbNUL"elX Rbckpro{< "l &/8b 
65S9` DG> ALUC  PCRemove diskettinnriX:
 #ރo!U"yh&QOod[ ov nyfsEK^=<V,N8=F>՚ 6\.&4_?S.[˴Po>&;@u(
,<V\X.>su	7tP Xϰ ErrorthDJ mechanm! Insert Pressby k(to cont5u. m *LBA-Trsf1v eS6:#yl"d> 1023
?PANIC[Sysom kld ^C
ig]awoaneao9fnok@|[qkj0dtsam*iȦ1CHKDSKstrygacc
vcio8clus@Q0x :<|>+=, /"[]<>|.A}MCB +s׼wupbef4aT`afMplwen+n\ofcB> INT2F/12 {+lm@;,$vir_mcb=pv1tMZBaN\mikComm+/agIs(]o E(mlvmsuc+e$\DEV\ 
g(chnpavh yHCngmka03456789abcm%f
+#/=n#w{*3	#^K; YNxۂf%+$0a-E4smEAAEl IOOUUYAIK^KAc."/\A:|<;M;,M	

 !"#$%&'()*+,-./W:;<=>?@ABC/FGHIJKLMNOtSTKXYZ[\]^_`a_{|}~CU C
OO;o$ NN?~!""BSHg! ; Z x   j0Nm< [ y   
1OnF7eDOSZ%$evs}1.35 (Builv20) [Man~30
042:0/:36]]*?O\"ZbVQƉY^ɿf9rӉ1RPމu[痉@)Y!!1_kO(?Un]PFFX]$ve ϱ$<
i/pbsUp3n4v!e by zko}Vz<pk:6%t
F<m1 oFF

L!^xzOpZ;Nr믴 UWVRQSPKi1Pڀ%to3t/5t/Pt
/Qt/bu` UhTM֌.AV_StV"n%!
<~#  	">n M։X[T:W]ϣ:P*XÃ3 1QP.%  slfLӼmcPyWq"UK[[]˞fBf_~v
n/0&60 >r?&kE\)ً&}$.{ݎՋ"J\Z-57~|J .<16f
g<t5váFXd tv^tLN2L&R FZêSGgWiR=7a߉+DqFDi9wu
;~w3^"D2C*V&D&:~rw|
]3'
v,+[5BݠV˶SG3!$0=[M0C"mw_h_09}W:Tu
T,00K@a+mj
BErAh}Gn,䲍ޞyd3߀O3 
Dh}We%.	B[HVD37=nt2
f7{ƞ=*u~4
UJ^ZYQ߳G4ۀg47|3@t3&D+茵BWwOy K[;[g;hWr,YtV'؍PwjPۆ  وÒX^WѮ7vo	
>ƆE=1 eTWWBgÅ/?
[x]L%Hc_lM7#G0<O0Õ{	xW5\RvffL0hP_ 
U['BS7V)R 4S.lP<
UDwTyDkPE%{PW1eA
0Vg
Pc׭
iy
H6wʉo!/ma5]Off&\&\2-~^
|Hu*&_`rvfrvgt~FrvXG=J=g׉^ȍVR\ړnVߤv\oƋOtz^Nz-/gfba`GFo@Ch
5/(p
H#b}luSǱS pF}Y:
mGE(>n}Ot=m2E$	
s3nz&9+DVQW~h4c5
amYA ]	4&M.]6C*2
_e;%gq©seoo
t+YBQ5= f-"=
~ ctf:9PzPVV@̾`5[0 i2x(P	k2AVn_r,<	`mPkRgt#t
~.KR_SyuYF
fFmFBTۿ~^ڊ9;XqvYv7wRl5*b1׊N>^0Zc:~OnsIrf&~r-ulM[O
(z dDoDDk\Dk=^O_SUn|' C ǩcphQ*BGD1ME9x1[	.3 Ca0;z\XR2
5 QLZ:։4ac"`CBXKy='ыngmuBwTkR"nMGƴ{q
$ضsvI4G묩f9/5<rvj7uݘCfLPE4uhX6qwTe>D!Q]:V唁`^^|	N4 +LYs$n5Ll%7V9r
GX;9;^S&{;\?B.[t¦"uCc|	GbRn%0/r	vCt^ZwM @O4_(0:m R
tHX
,	ҶVh09[
+Nv6t|#kE9	=B`>nTر	9s,a
vwuՈ&S^(櫻mS#  {;J1F:GV)ܫ(Qv	QmT9ց s)w(
[!JT,Cu;bWZ#fQ.=+~)𜍓oe}Xm4UOr6  3y
5|RtVPz݃]ÖQq!5mPۑĶVSωX)8/z +kx^м@Q+F8:BͣD4ѷڸ
Oգ^ l,Н$9&=迓'[
NuJ;u!}
u{ݓv{ǣ]GF^
4Da)GQaqѶ?zvRh_ I
EE@m$
qmxd Ǯ]#7
o= 
 X-$Ҥ
6
 ި
tǖ-gspgV1Pk37p)\U(JGV662!d
ƺצ'J$M+(
#}j@YnzVj[r=']ld3Jym# XhORh㹼mx;\A+o]B/
sisCd{F}䶂£:ڹY.EؘcȘpUEX
T=NApB_s+~

]"xs4sPɷ6ݵrk	AlkiWAX4e
vuHk\	ZfhgHMU,85/7M;~⍠d8uڌ:PwkY!u<0<^D
^
^]v#c,@1[CXz@?+	 L-ϋ-Dob&)Vt] #ǆ cNnmnXH )Xt[6Xs
ZQnl/]AX3plj;Yeg*>!wiBfb<Fb0)(B!%1X,~M[ttY=JtT=O=3Jbmt/U!D]P$
f]2[h,F$}g)5ov/+ƅ`[^[T
Z[
`c
6w_
VkB܉ˋ]2r/Oo_ sba;X<im<ѡbǿ^<
t<!t<"tf<#t\Q<t6<<D=[s;VE]McUu}
n~[r6_rcl"B뺒5׊nǴ^'p8!]	[ w~Z[XK!rRwP?n
s!`ýO<GYTV	tZGmw
\74CqS֤od6m Ȁ2RaB/u1tu(KD t!vK'-d9t:sg <*p)*,X:<7uݕ\%$fE
e}j7b,׶OLbie
pcUmmwKu<
Gw3Ou+r%ɚGYGĶ	k~\0DkP,OVL){1i8m$9;c%VtGKST>$Jg	S.(ŉQ%(\pPik|`kv;l^摣7uEe*3->u
@^6Q=U$`<`L[JɍDjJh 	gT
;GE6|mT'2=: uu7
-1\ _3Uv"h5WkBjPehX#	eq׮-tG@_p,M*&(gX V.]avowB^R5sx'E]h
nK%BKw##|A}%	
X!grAF.\1	0Rr+nf>%ZEՁ9r`lZpy Sz | ^wuR5c[P:"&ھ'p6f%
Ak>ZF-xmPe;=_=nt3H|*>vf,Ê\=R
=wP)'Z0ymIA؃qe 
s>9v6&d6k
~9Su7.MnBc-Iu`n[zu?E\[Ц]6
ZZ"^t#u	 
tP8lڔ0R">hjؼ
7Ђt=v\1@QoS٫QG;
g="efЀr45LvR0]Z 
šA8aTѡ204 .׈,n	k]SR.081&]ʐm7?@iGWr	k_,:E3\ݎgp Y
STJũ[@F,v
VLBТ$&ŀm#@$(Ĉf YB&?<w<ZM_K$m!
pN]
!C)O9b^U|uS,8=?$L)m;4sG-ikPj/}hA(ՈNoUF^	"$ñ	f%/
_
׃x=zۈʂ8?&Prq
x\< s=	.=
=
8m^/_G@xr5+R-c>h^e֡ uNt N~G	/CA<KX#4tU4O[yX
K=

y@C-G9>9
V7#
sl\
b?6C~c1u09C9h ^_l E'Ȫ;7%6+R~9S
҄fíxMql1:^Phz {;![BJ> ? @ K M R8]#"!"!!#"_""#
|"Z#'#dBN2N`+[h=[6&CM5P 
?sà~sF5(mg[V% %m='۸

Z6+*;Ss#H[b5.Nm*SC{g}:1y
8%ǼGGWW q)P)@]>t-_xs" u֋stvr@@^JPS0w Fu
C{vPKCm99s 뀽	/r]BKEB@pw]{vN7Wl24C\OS'KsK 
; rK
66	a^2&GrU{.m_
\
>_>"lB
+[2:h9iSMg]|0n~#1k0V=
&4 CCû+UGvFp^ȻdWV6	Y7Y6aP/uQ[ՁsZ_ãJ{m-m؁Gq?RPm.ahGu[
סAǀ?
ec.IF<ۢBA
B{|c=t
\~.0 /:gKWgR`)Hε,ܤ;LFB+~;r߰*Dh5Q[.N-dmWmnvCVr&3w nirw6O
h +Gm10Kw>cɔ X~Rwu}{p}
|j}8XSSj_E$QSzŸoNJ܃
}*4R0P84%Cѡyqq2h$pHR^
eW٫69¢щ54-CJl_$A=^_`'tol$2ז,CD|^^K-G hru06кX(#<Tt7C 	c MG MEG<t1
Vw6CsbU5s,z=nCEG䎘D["/xV[]Rz^Z $[2?6
*^6, .| [x}<;-V)-V9붿+Th&+	f~tgn2s'W455֚ܥXBzJ`
x
a]?THs6lNap	FCqU
u!Wm靹p[tY,6á.[
 Tи>,Z.A~ ^
	P!VX_V%WJ{f_ K&u	F!dG )VDE1u+\v'F(3 .}~&V4C~qR; cN1@pp|ls0w^`p=`1SVe@K;{0|Yu+s3 |$6yt3A0	C.#9E'ϠFʊFK5FN"&PxŰ nT.\/|Dgv!1o8(鯺I|;~lrS
^3p !R#VhBj-tYB=mEHyo03mGǩ]Uډ+mȺ(
ZL
_ݫ
fe&/
vO4w6PQhPlzw2	Aw|)ș͊k#(wR8#W(H6Jǃ<УN[9;)n7,Z	6ĐFvH'PDVJK</t<\T<:uCG$g+uC*Z3NE%0;_%G nE
Y6dW[   HD \7s.|O	d
c@ZxԃQP=ɣ%O	t㣲E`Z}Pl(Q.
j3}28Ζ]314@;؀1G1{	nGN 50`nU&տlto׹m#3J>p[(is>ҀjV04.<87O
|]QYp	Rj^	ڮI-ʫXO0x#.*2u*P#xā{P	
xc]5p@؈ؕ	`w=.4^Ep]s`c$
t67,vMĻ5D-A =Vэ\ kW9
X[b뭗amĽz 	!?C_,W2hJ#`վh'J-}H=G4`%Mw(7*lu׵>t'0,;|ЃE<&)kYI- ^s刌ۦnelhRTN<
B_U"EJ5&m.?U4\E6жϵ d=ۤűn-ssw_ _GkQhy{|qKh	\6B%}x%\W|E~~HkHAh,:N܇ `(z}d=AE=`5[aԽa3'CNF0K
dRŠwbt;tQR Q.5ϋUѦUJfQjx*=\E6EGF(tOTR~><cC'uy@SD[L
m5aO07F3~E-h/V*iB"U
j{Dv#~ sfn$~nї1+~?Ohͅ `%j
=qж!W÷
H@v2,-?s s`^?9"66$)uP%=mm/u:t(l6lq?A#EّKW\bV8 |:i
yy 0f]}Wwü%Gȅ{Z@%
-j/481%p55A~52;#9.WM "tMaYV*Iaϛ2T$V7H& GUZ=|~a&ݸX5޾5 7>u)-xl =^(Bz\EW"v6BFsQWFV݋Zp8i?W9s*tD?CX*:bkVtN=C swlv/Җ5/+~:Bؤ>Nh݀>{	\(-Ȗ@G=B
W/_B<jq
6RF`EW^aWfmm;s!bKlK	@ukTC 
ߒ@ČVp? Pr޲JoCF}
f.uF9L%;PWuK܉~ C$6h0;MHM./1kj3͙ +,kAR
/۸(]]΀O܌~E~^{o}ݚF|bN%$c2t

Wg
V<ANBA*Q⹧O@-O
X;uDFE `F*A	 h@k{wDj  E;U-AR$v>_k1X|z1P_t6q_7*pĘ=/ƠG ZXWi=i^YCs	S=CFl*N؊:ʥƲw.aWۡCEHqi*"L*gx>^5`=Xp G>|7 5t(^3hܹ9u[=hv<LNGGRXǴ 0Cv
ݧ.9",m}	QSf,5]6cKS»H ^e_'KtHeCa<.@x3.x7L< b<Ԇe!0e8tߢ
g-	J7`jX2;鰡gƏʙK<叭2
 ZS#cC]
WV
]aЅ!hN(V8RN
6P$tpW4K
& 024=6
	u\,7:qRt7(L*ֿ\8:p8Chctbw(E^\̆vNE,U.oE
nѫ 
gKE2/G\}5%1@1[ mCGr(H}suK' Saq
+KK	.-GnU͜P(ATo@dE$~7zXk\>e027)ÈEJ W/
$ 8`:|j# e]Cx=Ѿire۹ E*u-J&/y	sg\*\*<&G]M7I(4&l	JәҲWhaM/@­8LmgKh,Hx)X`nu$P|,qUWu,\RQsdʨs|Ep);tswt`*^Wǵ[ץ\|2.T*8:[<Rr$ؓ_O*SReMW[э,
D.H
*	tGg/ÄEdGww2j%l(A_P6H%s lJ/D,
=\?
@.|!Y2=c	 ,A
LlX\ӿK,Ovt<;6^ĸC$PPOV	<P'v6()G_
zare
|7_\.4_f
~$Ob-ơ<mFcZhlYVyC .j08]Ӧj=xnmc*Wux͍.Et/uTGYWr;J6~w!XPr{JlpCQ#H>hc=\t@Ba =8rES.FHBRD- ELݹ"QM}	_ZX@	$
^B6JШ0W
8H P~&u'
-
g>5;'5L֍
Bw)&+iwbZ wBfIlB[bQU	kgL|TD !Al
UhޝF[od4D8(0L(lrF0$=
uF	Uo7wXw_J7OEuEz^xbдv6+<ve`4U
p39Jp,Gt+m9k$^7wrA-'a kT#*ɗ4I Z@-2$8:$M^vI0.n

<6#E>83phlALhH	!K<?tA:3G+xFG5`x3
3wnX'Ǎ8LϳWPeOXv=j~+DwoPSqe17)S˽L?s՛׊մp奸w"R&\dIBZP;~Q鳼':?ڀʏ!ds C8!ώYf*2\&pO&6v8Xuu[O
6<T@/F~kM%[ueԙ|VM; sNSȿ0ԡ,R?-ͅtI;NtDv?kFE4{1e@[$!ؾ H`LA8>s 'Lw% MJWlG:;&Ru^E`uJC2iG:4=D+N1;u)(l
**j;[fhe_.9Bd9I'F]VM  ,"HG"m$lrXGQ^=ѝJLIPGKr.)ӹPi|15=os1i$K<&[Ő k1
EhX"
2sM\\G{~Lg[.T
0 
߁{2qUwt
(Ї*+Wp*])&BA
dr_
Q Gtomk3n<g[gvZBƲoN>,kuy:nL51oe^|WvyU_I.VZUP߉,DEB)V`X
.E
]SpLGG^AALXW`)4U;N~	tJpTбA;$/jnD;&9h|;e79)uv.Xz9!%72I]`WR&[ҳVg[vi:? '"`0<LA%]YupVƋ|<.xfv<>,tu2q[ lvf:J^sGljG+]JcϯUx^Y&j._7$R[$QTs
UV64orP rX2U{h
ovQ[
u'9WO SU 9/PsKv6"9"$ 4a0.X1t
p.
q!%	ӣ ]'-3/d8
;	!B;
!En\w2h0	F-؜c4`Z.9[v6vn9l;lkEZa0g_(t"q$XFaWmr`m`J(,*T"kc#ܟ:-VԏW
:GtѺ>IB\XclMP5P,[@
dg?|Tl*x#K.Lc
`7[չ/ #Kf(8LB}TqE7kf5u
ǻF( pI8gN4@wET>(O&+`G0E
ݎ|[ƱGo?cUc>$W7ZI֨ng\GăٛaZ?p[FT0Fk`\:\8RRKkb8[:7	+8)7!s>)0mU_Jd^,k.PTc9]7s6Cy\ (]pj^p0.\둮X _hmӬK4,D'<LFVXJ=ZM eIZ;T6vb-;s(|28
au.A!6ߵr4&Xc` R3"۸%@Loi\:*ƗǩO6G2^$r,
/"v%RM))#GA#$rU÷j	Ͻt |K. <J/pvA	>(LJYaGIq#e4e\AUDt%[u>[D.D$z"r
x
	) >B|r0AyH輮|YE;ŞM t _SNAn/fe`;ѣ=fȝ$+l#;;s+2%p<v
)z& ;&G+~nsh>P]nfݝli4]^lۚu& wuC*4d{@a^2ȡȉ"z[
]P'^q}NlGbĄ^]/l63%Nhfdjrxe 11`[ę5#\+VkRvZF!{D|DY|zw\9-i

/LXX7lmbV-G[jGVunmc)	G"QX:17u%v)cHi(
Un8<	T঵Op"[)[Z&!6HTO2mP| rGWbB.?vj	3ࢋE&|z#)w!uB~?&T!|!	7n\BF)xw!
0nZV-͘|ZSF!,RDSQH5cMB}z IX>n6<hKsk~*6RآOρ>	
x /VLW|zğ<+dm-NXȏX
	A<1>@IvKjU/SKq@(5&o+3'm8랻QuztvC!L-(,pUT؍?Ёo,mQ^={n G FҊB~-TlEE=S1;%tKt
"ةF~[Jۣimd&P=~SnwHP̦ dm)[RQ_CЊ@=D)#iy_w0t.=|
v== @sAFj 
wJ
QNGj Mi0gVFVۮl01XV57H!#%'57۪=)
+
-h/*jn#i%f'C	FO
`KA[1/3|
pyU)L+5+mʀ;vҊ 7 /Fi73YY `aX|  }~Uj׋j\F,0P`mV,1 0	|軐Yx0{e!;Z 2I7/Sڏԩ+~	A>5`#baj#ñQHk|Pސ)!BiGW&򋇊zH#;]wK\,tz@P#Ne<mJps}+=ov9w1ZQ#(}Kμ
X%~(jf&Fa%) 1mRڃ	
X^dH:^ ""ppA)D}Q[$(o5SS^)D/
<$ONN
,W/4^RX<~{G g"-
Q¨Xv}LO
|H#mV#F"GRyxXYoŊ%Zssk9 |5b4{W$_v_\;v[@䫻&`MSgwK9t;
늠pC/*Omj.T-q,GibvFr-9v).eF5A*+mFh9EGELюU_Hms$wлOf
n g	!@ɣIYx&/UC!
+#? :m55L >򌗔k5S\
KrИpnG(^CH7w3]]!Lcó2yxy/M%kbE'Trǔ#^WF4D߷DF==~$J=KCոF0ҺE%X9kB@%d	bq'陊 A@ehA
Nz^sqpAu[pWh#
ѵ~REpIqEv6L;Pw_;} cSUkZ}	B@ǿ|F
@$tN+@i.8v34t Q2T3XĮl)x؁HVhXp^`Q#	B'55ef01 D0C2xHhh?@uXR%YqAe^%tGU[@yuVLk81G(-*> ?l^P?觲Awwg),&(:L@o:P?,A:G[B7 rFF#~!!cG.>	FiZ4ZL
xɨh_C``^b(4+"ChZnaY&@=Bg 	C-W3 3ۥfRw vLøf<;N
}7]*uw7P? s?uD4 }F.>w륈S)Q˰_G r	|T{;
DX gW 0BJAHQYP4xAՇT: &,7_9r?ΐLh)_	ELժǷn>Tܬ]$P.(IDF}}/
%R(~S1'Awt Mvt=vϥ+K!6#)|hnω 5: tpCAZm}ELnRhNKmEZ9?,ֻM]Y6tS
 	D
9k^1RI>6ڽnB!#݂	L3k{y`29GlW#"ܕC!$7 
2cwZZ۴By@>|+G+.*UMNF#
UȠ x	ك YPVd QHQEerg #e=:>
lv}3{)bpFE3ZL,0DO  !DzDR)N\a㛓


45Y]-RW_Aۡ2k 2~0Q0ȇɊ
9@Xс@?p:CCNa\T0wX%/w4E j0(z	LW+*(kjwD0O(۪̥ZCg;|@a1U@> ?:@PG@2c/46't .en&FY2¾+Ǐ E k^
v?F򍐘KR&:qЋvTCFEJt\H4,d/*W uSr,[2Л`k)}(%hL(.	%Sj		=jU藾E
NcT 	<`QO=61\]zMG/Qr,Vr
zEv6X4OU5#`,UOٲx?+Ta1,0-l.>Kr@1;̉%
8j'dZ0!1RvT̴34WHۢ!۸CBR7pnP6tW4VKP_v"`kFqclmdF䆨sF*?
h&ψDlKBJe /Cװh> {BZ)%`GzM[* ^rkk9kMkRzkŌkC^[DZo<5rve<Qsa<bt]*<PtkV%rJv<3AB8"F 6>.*1
ȕjj7`
Nt$+~
cg7lۈ&Zi_z̠ c6 Krw=$( 뙐9n_A똞&[.n*0d0v
J
kXllnlmmmbn Kk^k0#Zko4?skD
lx E΄}vV$[TUW=7٧Õ
&Jm,rvvhqUb-, EY+L
tB4s>v׺'Yt`6* -j~7wD+@-|WKtsEH`I%K6u7^u1!(L;U/w;;E-wmMu
u-v׍UutM;coM
w>l
w[/Ngݕp+ᴻw?@x|%Yߦv]\|
9J1V"?AS$pb\U#Vt MCa)=wzW_4dL`jA
;na&dG`_	UG@Mip
[oz7UVF<	pv$b EQɲ?wP|Ku .w+ے,ЋBEMw6Hkpw	qAG7lb۸L^3wlq}qqqqqqqqqr&rWr`rjrxrrrrrrrr rrrr	Ytr
sss	&s6sGsLsmsussssss-t}%tt	uP`ukuuuuuuuvQvqvzvvvvvw8wwwwewww߅xxMxx
yy"yJyy
z~z!zxz5{b{k{zn{'|.|g r_xkxxx\yysy#"! {zzz{zz {1v!@48.:0*2P
ΛcVUpy~~8rOv*V\vi^`viejvluvA
Yjx$&>7)HvgrwCD0swY^{:o&NO&SfK%躶r_ '~Z">,96ܒ4#/ el`moL5@]kDP!~(rVMC<$tgxҬ!>92wSvKt:^4?Ѫ>x9Kj??f	wipo>Ի+
0
q+>\\]`뭡XoM`o땻f.IV
G0k-l%oewuVep^p`0bZ@\O!38d[fv	jd
覱
5yPP%l2]q!=5ACk15[um2#ؕ`ۋ)\=ueF~qt!';/ww<w$uRuK2D',6a_a˛Ds}.Ѐ4_0D^[`͖P
?p7I&(8Y#-(×^aD!l]P,8j1(Wv|W
%C<^ )[o衩Zi=[]0+'vJ/t
\ZH`
ٿTea8F`9?V,p!mmU=vO潅hĲƻ7G{wA],	W[{ƓedŻK]51	-ctgg/bI 7K@(}p=]m@hdBm^Ҝ,k+=#<v,N,^W-Y|(A+p8:1tgnk)α׵pmj*
%"k!=}
t#SK=겛L
GtX} Bɨj+=M
bQAK0g~t5g4
lCnA95@ׁ~XE"oRA $w\묠Ppܐ[b|+}z?; .<mllA 
=f[lx wO$?<ۘFq ͷ> !0N $*X(K'렙&l #8S(qi$U$ bVXՅ
8eϩ}ZK
@0FPS	[OIqW@q	wrI؅ptF|{"ۺ)S9~к:)|nH.%6Fh0@, 8+'7`M(^F-c[bZZ
E2#rۋDF[(OD@骢DQ8t//	v`#`$0M*8
x!x#~AK p[X-R*%{$L%Z?T%e$%W,׃$;*Ȣ!BA(ݡdt
a	p%~9U鷿Ѭ
D 3/N[ !|+<6>u\fV5F߄
>wCx $eVw7ED}p	^Tm
|8fO~rra}tA!Z5(Eu/P#QR10a܊tu@Xr5(z
ӯ߀&Q{D:2AP^MR P|_܀=VF".,qj#
ڙ}}4~/~h~v~~~~~
+QcLy*pJu;@I[^

#\
(;N(B^Lir1}NE}.Y0uΰࢴ!KK
eF!$6 C%I!xKn3]E-s%DJ;p@සd!]} 6
V,R	r+$.뿷{Kv뱡
>F<a|<z!t, 
</\(u6DTn@@e 5?8wNn:D(:ީd'm*ӠV'KM ?
-*&m)k}ft.mmo\a(8
]FiG4JFٖԄmz
UD*HV%#~H\~k1kb>m#<;##vo
@,l|F',1_nw
	Xsx}҂SׂYCq
Gq<v@Ci(
turAghۣmvboFkNrlhjCZPU9Iksh)oȧE2GiEJ^	Y.eD	uhۅ1hd4c*fxUUD0whtS.?N1.
D'
@VH@g-
/l@() 4	_k@[
t%u7uzw
@tD\
ZWu$tUgӡ]0Pcgh-v`ww|]2,ɊT
$J[zV1E [	p9^PKb](w]Oc70k%bA|,jA5
Dx
h0ǂjGs Z6
T޿Jhjt`u	|-#`	[pXy褐6CȤjp$HD'e MxVN@[55ZAHh)}b1 ,F^Fr7P!򤏆\ sP#q+F#9KO,4 wc2Z$QՅwkyGz붅)PPaW||\tUuPl1P8:K|7mtb" Z4[̵}mFN,=V
SWfق? P MuBMмE][-0tZtp"`,	@Z5K%R.ZtCBAo7?nR7a ;P?U&Tkܟch`,%"
O)u ˳=#Mtܛ|_v'ڭM}%;s	|=BAnr%q@= OYc0;w1g&)plE "fv&6 "k{
'$Uj֭ML
eFx9/9
1lMY	^x''tOIj;tC:BHV.ۂ<53^#@$)]°W.CB&;
M,=!`a!Ca4ъHStfGMD -	"¼td0pEDkuQQ'
oNȎvV0cHBkqe+\R3u,"P!辊 Fv0HV`3A W]le0U]uY%sFwF)1gOɎډ#>ƑGoGVP,W5>bKJˣ

"|,w&{>FBǴ/Wwm
l$]
l_P(h벁wQ*4Y-}A+ls۶V8O̎Ơןox u	bj΃D@H1뗋zMOweh#`;/;!t#sG}WYAmu4uZ:uf[SÙۨ)7_Wm(R&O([RĞF*p1
X5_,#ru_,i]E^4\/#1ḆDFX3bb}C	Z=GuRzWzWS V߇(_r¸-eiR"U̈-t
>߃xV¸"Ӽ
v#
$*_Q.EP 7 W08:2 Q.{PҒ4Е6 4}%Qw`ėM4߉@نj)\cxD]bǆl4mͲp
 qRHPеxZjtĺFJV_E% (\V(dlf
/%U	kCBU,N
F)p
[܊/-:rv
(
2/Ԡؓm @iw
W]`|?.Z*a|ƻz8? 0B(um'FElm
\KT	t948lWW*V].0Pg

PjW}eo^\PyKfD(pNKqM]
 9wSİflk|a3;pή&?@ Pް;v; wP j&IS[Y6A.u65Ǡ[si;!Eq_
%Zx;
so7PHr3N /Z$ r_jãW(J}-vA(!Vz:/Z9[֙lj'xn p*.LJhZ A͟S2 ~n7Ѹu
 z	1gԩc^m˺ih9O@M_-NNA4EH
A.RSP뭭
s\UsnA +Vf4\b+vwT 
QTzrMQD*"K@XtR:
~; =-
@!z@Pu!3cI;]2'C 6
u[6euvh.:0Eié
#H2
0_.nL<,UPR>Bm^ӱ+F8a2hUF/>Hǈ"^,oumWH
5iJ}~wsV	ۡEu

S0c1-\Rٱnv@Xa
a3H:F7,d:KGu3< Gp48B~Us	Lw+ =rT;|%v.[KViJ=^`";DsYQHA=c7hᣡDTwP2Z)[UoI䚜ye>]M_Oˤm<]4zL$eNTb\lTR]KBp>R@eNnhd[@vnP"(j~腥z}裘#}7s(:}R(x}m=u"MԾZλaBޛ`fC?p%t*tV"81c}1QHd^.>hpEA	~R}õr	}As$X &4.LIIˀKb&FIEl~ Q,u
6E(ȷ1lPr~րw

@@m?׌
h1uCa`Uz L12wfQOs 4.W) !psSV [64R|
GQ]_|J|2kQz6j1:T|1vƦ9-;t:lFSj\C<{G୳Cm\+6A#fhzWg>O"} }(@?
 
bGЃ4žK}☽)6@X.=Lڷu:ڤ4!c}<PhJt"U/<.rv<?
h;<o7</	<*)ʴw:9s%?CP몃s&;BTNw̍	keA^<ZLI\)<u:G$^<v3Ԉ5aP_u*VtU葎 ,AFܣtirUnj.U+Pfǁ[@
/:$/ Qc.PU-}M+@
Q(f?q$P8Zɘ<n\.6 k#Ga[p[&,!89u4Dз.Pitp{y%mU}\l	\aFN-@{dP8zPΕ/*K\ʉ6/ A\uKT8 oOyF$!hpx#sM-L2@[OVUƒ0#,v:a_2?\ zDo
yM+&Nh9s/0ID $(A,t
Ehq٣_/5D"M	v(v
&=X9"C r~ktw:.ro!B/؎x<kT\lyxzQ6LB羋^DE3kRX\m(`F&ZXM&D2a>bVQnQdY-q.Q.NuR]tEΎHT1M;S\0Ռ>"ht-nZ L(!z>*
QM~K%wBiT{l[ki@`w`3RP$RKK@^dPnZv$Eq !Gյs'3>-չXvT=6)2\F'Su/#:L
| B\n%U]
&"
SPڍ訹`iZo)h Ah&x~C^Vt1VIx]^
Fb#UE(Y;We;U
JDw:uS9rH}H[F_-	Se[
 斟tbף(0 õB0K=a r=z / P?v
+T%G`IuC QKpIQA:r+!&FƅFPU7-OAZ#[R̷	6߱jP6TJE]K4ADg
40i::
 L 0
Eu|T-~ Q*ś4&&%jJlka&(C ҟw뵟A)U -Tޱ.D

uHtAo6
fXtK9SS	s#zDS>"B_3uF6!]5h6Hs*jwBv+lSs9p4R&2[vZ[_rΣ3%pgI ׀Olbcj&{0ٔqDtQ
O
~_8	gl( W[9Q1p Q6IPRQuh-W6ZP8,@{ӡOШQE;u< COT#"w&"֡ġ⡘}1
ء\8iZTluqvSBSLϠ^?Fň%-s1R1-
N+E$oKP@ap mAScKpE
.яst
QGc	~CSYa=
߂͈)1\s(U.~!
pEUp}Q@[:lP1^ | `-S9}%B}˱';Im( 7+AX-r"r`!}csb.
b85%,يDqX)h 6pD|o.B
Nz4]
eC  wZP{@
Vk[
sAHH؍
	p[!wlz
p@
V+q?} U7-	Z`=^]*[~SX[YWIP?ٴnrt,K`zEd>x %1Y۱WrnNr ֘Pi@{[]sb @B2?м!Eີ[tz)^ֺ9Ⱥؾ[LK=F8%	o+쾎oPztk3i3o/o_ <u!t`PQR$A:+ߧ.} ThuoQ/ЎG[ ^66m%l,ˉ/GP/][ZXYSːC/<aS[a=${>=nZ?pۗP$YGjS/7|$H	Hޏpj3<+EP)0ݍ42
"'sim
t8
{k^_؄+=@4n: ~-	PlZVQi»bktl
"7kP3&^-4hE{(!e 03)krDieYkq :q Ȃmkh {nRwk)7
HnMkS~ƏGC GFV%A ^k; &[,?` U~} &]6_	Rt8k:m,Uٲ	CUr*trjm]6] U)jm@mv-Ƈh596pyou?~m\ \s~,mɾo	 5P5- fTh)\*H`/`} f\އ 
iʾ\!x^7w jU͌ޞčr`4OݠRGG4#Ϣ~1ц> rt
/w
DѠnj/
R0o|Bn	5Kbw&.(Ik<C(
RGtOjA,X&W<(> we@6*mhO >EF902T| ]'zزEX@C{T5w(&SmIKMOA ۺc_i_S}ݸ54
)8m=NV
3	)r(͞6t5
 g|;!u/{~~s
Y~ހz
uzs_e.^t	
MRv>2s6Q[	3?l"nB"9rTNS`g-gC0DBuҜMU	R|
8,,
W#kFpa
,[BP`!m
F|
k/UFt0O= ⺖Eߨƶ2"&tp$<@( eFJ-2="f"
0@E;@!\
I1V9Gs?FYl ezJ%Xe [h#9\[8<39,*z-)@X7'h*X|B<\ [/=g߈_N	C@09tM젊XBՂY׮o
:*8
7A^aҢn8VEf$`׈<}@k=BD2t+N!PDY"׈42uUM
J3w2t.4}ZHZ!@A~VaFk钉fW렠j%%RlFcu} TLP$4B&EA\	L٣ ^ap޻KVڍQwܸ|'Լ6(PH(c8KG [AHu:i[@Q$I+A.=h7=H t6!e,@Ggpjh7Oo |U>yQA͢Oàwhn@{TOUmmFOOF|Vc Pd'<6. z ,)l뿶kB(`sw1kWD.jb	Qd*qUQ2,J"?@/d4k)(}BiQ?3,и¸Wqt&(pe(* ,TG\L[
D<h>Be('W$>ob2
ab.n;-z.~&+6rJZHO*,z[F·np
"oXx$lPVrSEu3I0']
ۇƠ7{xw%6'1
[Q`)GFs	F!GJ7[6l\7^4fc#-R2oZ͢,.1@p0퐍`h#n>ls&S)6j9GIi8>p
@|,Z?t$hA9,PJGSC9RMrx9s*>M_CVm!G T]dulj5$͖~(:H{ &MOVn(#m>Ju#蔷JJMnhzh,Yq37V3:'YsS0{E@bv++suHćRg2mHl->ߞ)JuF=<AA03Yab=nZLAD0P?.|;DҺ 
v ErE
omgWL6tURj'պHHXƹHo' #Xj	"8O|@}M1`WyGPBȤojqo@#  wʁ%t&(=t	Ѹ*%
g1#uwzrm
	
 HTB7=@>c
 d] +l*X'2ld4);9r;Dvu1 'UyynYN
@4w/#={iDx|M~
I*Dc?J6	]
Bu+7/z@>v:ue[SpɊXvtOOol''R`QC@[P@^Wik&l봾"̾\7ZYTYaj׶,
1@-u~UkS{CUNbX]B"eV'[ xa! /n؉#5ݧV6$=,MWRR[s.EW8+E-0 X	O@yFS59}A"bמZ:u^C-ghYk欢DB!G
. ݹZUCAb`d4hb(+oٖ^A=^	5Ci͜M5;0}nh:D#+-DD-aEö<A|[2Z~^E,@:%[[;Wn<0oiܐ7l#
Tv͗4;u8,(x#,X	3\`(jL%"l J.!R P$Yl';B*3n33׍=@&GvC?R<Frv.<K/
<Nt5`E\{pR5Խ-M	ߴlk=kabP~W1CN:u=K8pK C.
0|&,
ʄ$ƗVpz>^͓@pNyߠGRu=
@!|헠ՠkP %yW
!
Ǭj3	q/+j轣t)[
 sA, |k#@~α|/蘩6GR+._W[/) R?ǟ(Cĺo~7(@g0ċ%'4pu ĝU Z"UEJƎdl\	 m*^sD-%@yA3"P"dB]<G$AAΪN޶|P~XZ* $4m VlVtBN@5I|XlD"AkE=OHKJ<
'hH݋NOJu!Fwj+	5h\]*s2	ꊇHǭo
	pJ.%#'f?[g	
4~B9n%v2Dn_0´2
k96D$7Au!
&|^AFJ"QmwD	Da G)5
})g|=Q{E
Q
Tk
|T@u.BU(2@ߍTZStQ.q:X[+5$QLU8
Sn ӆcO=Ru#^e	 5ZgzJNQC ?w	>0>
!)gX;P.)k$Iuj6FGs(F_d]<+v9Yz, u	]0XTJS۬R-v[6nSRA
'&kCj¿8k	D0^H[bh-uE}+h nD/}[	{c~cv}c 9EُvLex:Dm8kBW{90A4B@~/u;UDJ
X^
&V>EyWQ!ыMo .OGz5|"moI'j m-l7Hu(=)XAP?]LjX<&V{z{,࿖Emo`
qhDsgbQa!B;;?rns:'z;E:#r￷u)Ƞx/O ~RPSPJ-µ$Dh2M$ve<}	Cg݃L1'R<gg7FX&&[foh0ݸw\ 0QsѨ_t	Ptфn+`h!jDp|+}w6H
Ih\	t͵̵PI`CT=o~	y`(aX
UFn&݇|B`IWv0fu*wPu$g+?	}'A%05b
(zo.yXbq
0,0-Od-5mʚ	A
{L HB1'V1=!7CdidSM[ ^KP@6J@~@  :,S@oSW4S}߈FVvњ%v07n("V݈c ,u#ߊn
mĈ

q[=;u47 Es&h5L%̉
뽱fPb77I
l	$s^*a
vU
.M/2nB.	`HYLG}LR4б@և$dĈ/_vZO~AKvL^d(ݎ

r/^vt
|J~xzmq"ރvQ0Id!.E'5XB8
MY oʸ!aۢ<hm;(}Ţ#."
BÂpU3ʏD$9tNAw
o'
aF:hK[i+LA }T2KC@(y
0پ!<݈aır#nRZ(ܒJP.b*#^9u*=s%,&;Dd8?wj%k)	^NA']JÀqrn8
_p":mkki-͂܄: ADv@T
O;l7j `ܢ5xph]P516 +yxt!
S(eU/I. ?]@,g3
hQh0orpZ
NaVʡc	6
P"n% OjkjW%)`hs   );+rЕmWH5JٌfKABJsG;wu\duU@c%c#FxNRLFHA0OmbA1JjQ
wjĀyOO"E}`#~/KGwtdPx_)FH\DDx~ttp mA[u!R6 jԽLJkRm@BBEmE*S6@@
->mU=+VZPC[*ZF PKIAZ  E:ǅC4qCX/4OF;FwQ*MN9shF%,GDYEKkB`Fk
/Z-.[xuspoidcXS+pq͒&̓.f͍p9Jg:ڷL%t	T](FF	 j0nF0%p|׊ٔ
˦Dm3\ Ն
1lWY1Z
?
 u<6
CC46G5,ZPw	TnvѨ݀6gE	-T-r_A~ac_~M(i

9̻`)#E&U[tJn@v{)]7t%9T.к0"b~o?
*lJAE
T>qLc*5+D+}o渁kn[|<rPl%]b@`٠!қ>֊lD(PYovmRR$ͺmE1DZ8T	4	 d=D֋T
6Md	E^%Q1! $@1TMThT	bQ6C=a5+r!CZuvrQ
77W)p&uj
ӯV D0F{H4lޕXAzhQ VC]ΡTJ O\xvL>\l+cb~enuSNm8$,=vkbHf|7F{
?&^zw	~vPKp N6/f*'>ߒVKns/F?PUtMO#_4'̛.[j1ؠHY)vr(ur_ np/vdi:|P,4@SPcıVkư@m  Yyre	 N#,vt.p^3Z:T.(G	,.	"]
*p$:' v(=+ux,/rr
,u'(pQ x߃IF#G}!	#%' EgX&@Ƈ#AU_<>Dn/@~,[!R&MXt O.0Fg 7|
){_l|v,n[ 3
m/'-=!E;h*Ut
ދd4,QuGm67 2'̲	F-D?ge
HTJ}]oTLNh
/'U(]M+p:{wxVzy4
<K	D3b2
po G$>t/FC[x@ 
vX@̆F辄m/Ļ$W{@PEZ/>vF
MknVP=W4OFf|]Fe0Q'76 WXkfR:
_O>ɷF `=`UANzddUu uK t !sMTfmdC,=J*VtSHLiTmyKYeږYh1;߲,VڶX*OqO+k#a@S@/	L[?	a@w[D)S,p\h6C7sp.g	,+t=LHalW5mDklGZc*U_`$X<VI;þ&mWhVShGDWvARƣx|^U(	
'j*Zzہ?v<m;OAi1,El6G[ڸ8'ʸ
0$
-4l;) \&@J-

lNq\LE ;W#$4nTTH^E~Deݸ4X4) w
2Ul|Z {P=[P۸@]b74ևn~o>DGPLFuwtpt /s6n/&p"-gttn@tu&
3e^7tXR1Zfyof#cu@bxP 0	;9`*;[  `/eLE($:6Ċ[JE@
}hkiAD44]KOMSv6WaEQ~S7 BlIU1Y@
߶̂OE6Wxީ0
 -mZg^.E[Au8p!<T];kQRb|"+8l 1:4hB}7,"!DL(,W=5

}T\y)-h##1ۀ}n`;ƀz>pBoBd>+S4azҋ
X4 spFG$ Q"+8
' 3 /R>C: 6'w(;F遼T\T7I2t=P(k56	n3.hk gH6ګVߞ:xRp)m4&6"-	\v zs#hRbq!`6_ko	 Lޭ7/ɘ0.@<m=UjYoY9}BiU;BXO =:5P
SG^*,%nX#BZWMc$HiĴ:Li`1mC)=h%9胈{vőU;.Zmc
Pl?Qpz/@p2I
Zb
rWG+w;
AS+1ov׫!yӠx|
w@-^y/_
na:c3|3'x
(C)pyright995-Pasq-le J. Villi 6Th Projec
A R@seved.)ikf- softwa	C!ޛ% with ABSOLUTELY NO
WARRANTY; youk&+m 1dBtݜbuD
t}>/ATonfyuT? vrmUg
GNU Genk¦ublic Ls6$ps&[by;FSCFoUaPGw;
e9`@H=2, ~(8_%)PWnl(
'A:-@JUNK@-.TMUV !"$f%&'(*/jVE63 /Co$<μ|ؼ%,%7
/V/t/	/#/)/.3/7=/kK/MS}1Ycju0~Q徼yƮƺǾ߳A>* MUgfSCPRG/;_]]R+ bBRfB ;+EUR.0Al 	!'+$$HU&&YB'W	)@oA.*,W  r/r-<DKK.ASEK3/+afW0+PLN&1¯l6V[r 7 =d=Q mB_vfX@{gWBGL	|PUAH' [DISKF~  vp 	q `	 "!O@	  t$  # w$`7]2\oAUX8YRv
%Ũ+n7pЖb*Քo%+cx - 4T*MC	F32^juppt

%s?oH=.n/YD 
IlkSP;j,*FloHy/X	-;l  H}_inve5js(@qbo t {_<''H'Ewa<b21HVd0JDY.PzE:2O
>vWIHESqEM ;WELOR	iHLTL&OXBREAKUFFERh9h<M6tD.TR(s+D:mACBLE`HfLASTDRIVE	dMkvLLl[#AmSA6`jЇIY}EVICE6Z{IN=TziTCqDPBfdh@f.sy
50IPstf-w
jv
1F8yfwac$[r58^xip 3.SYS/AUTOEXEC.BAT79s
#pLlg'#
[Y,N]?YC{0wGgYKq-#
FbO9Qnh_Kmh:3)'s:oadSs=.av[D*kw Ic7?r>h ͠v"^
0=%u=c&Q,uc{k+)I+3|E
VD-ff = DByspHi49M"[xc ]]pc[mT](+3#vd)-bk 
&
x:S/ɂp(3m:0X ClIcw%uldb5,3tVmfmrID
cu4hKa0i؇3  To:33na%"mv=kx)=
/envirom[G,u5-C'd[d."%s"QS: S/beN3 f
3	aajamk܌jA]	),svo(a:r;/??j*egk#eF#h VpDy63ludu%.|x:%4u-%| )6s32%tPZprIt93hjQPiC,}ditxtc:qD%ܫ%2dr	S%ŚR6,6ѪBvize
ApDrԴtl(ge di(?v1l1mF maG2 d2Зs7rg,pB9=0x
xv08S0]00/_k,Іml63WCaNG:sSip}FS(Yccul#fuћizO`5(ad3]U	{K-4~(Aks*x'^tN L{<es,$䧘dogg=SKvPl˹P]~FC4-?ˑd.7):tDNVeVbF:dLtE)SG!`-G-`/[d[tu@ '30x׎YdDxs,?h3nr/~IL`H-0 
ߎ ^1 .xn fo`,V$n *xR(5q! 2#O"#&G}+d&h? `<4    @ uu rAsU fsIItɉ͊F19 uA1 sAA )r؍(󤖎P1X u  u<F][Î1&-Ht@uGG&=u&9Uw r  ` )  YHH1  &  7м1P &Cp2`t   +,-.-..-0-p,,+P+  t" ~}|}Pp"{ z}!tu t+} |tl$7%P '%($('&"!&3&6@&%ӔP&`ӔP%/3d߀@$d	p?1%u( %p&u* )**)p)N`.(('''PTg~P%&$ |Q
!0@Q
!DD @#((The source to the FreeDOS kernel used by the bootable ROMPaq diskette, CDROM or
FLASH key is contained in the directory where the ROMPaq softpaq was
installed. You can get the latest FreeDOS source code at www.freedos.org.

                                                                                                                                                                                                                                                                                            





















~
z
v
r
n
j
f
b
^
Z
V
R
N
J
F
B
>
:
6
2
.
*
&
"









 
 
 
 
 
@  @  @  >  >  >  >  P>  {C  uC  YC  mA  \A  



~
f
H
*
 




v
^
@
"

 
QN  N  M  M  M   
[  [  u[  m[  [[  t^  J_  h_    6	



  \  Ս                                                                              3Ðjrː
  F  F~ F F^:9 uvfv$}fvfv$~h7	h jIsRP腉Vtj
fvvP袊
h7	h jJFRPXVtj
fvvPu
 Ð3f>Z  tf6Z f>j  tf6j j \i  Vh jeh jZh jOh  h j\h  ~F ^v&v& =c   -!  - tHHt-3 t_ L  F^v&v&8 D^v&v& ot^v&v&   T  T  P  T  N  >T  uT  |H  J  m-d _HHt- t- t- tf6B jRP$fjRP踃jRP訃jpRP蘃j`RP舃jPRPxj	@RPhj
0RPXj RPHjRP8j/]FF9F}-^v&&?-t^F&&?/uF nX:=sjtRPڂj\~XtjuRP軂j\MYXfh  j wZ \ Z ujvXRP耂jw\t
>R  t@C  Xvt(n ! ~ 9  =  A  E  I jJj1fjj l j ujvRPj[ t(^  v j   l ؎f&fbjtRP轁j[>P  t>R  tX  V  L  >X t>X u& & & >X uD>T  u	>L  >L   >X u3T Ht	HtHt8j uwjJ9ulj?j.>X u?T Ht
HtHtHtIjj MȐj?u+jRP׀jT HHtH>T  tD>N  t=,?h,h,j2}
>8 t jYRP聀jIRPq>J  tj [Zg$  F >$ >P  t>R  tX  V  L  >X t>X u& & & >X uC$~ tfj fj ,F  s=HtjH-
 -!- - - 
tEf>  ~  H    7 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G}&Wqfj ?e     F >J  tE<L$ C= M- K- (-M- 0- )fjF6>J  tp
j 6X^ÐU	^&,&.Ð  F fj fF j   l ;Fu;Vt^& FFԡ j  l ؊F&Ð,".
Z hTh,h,j=>82  fFfbfFf+fFFPj fbf-    fPfvFP~ uf~uF    ÐfFfbfFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FFd+; w; r j ӹ l ؋F+NV&&Wt j   l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h
h| j  l RP襀
3Ðfv T  Vfh  P FPՀf,K  F4ZhTh,h,j}>8 t3^ÐFPTwBFVh7	h FP@~RPhfvh7	h fv$~RPh` vfvh` Hv ^Ð  FF
,".F4FZhTh,h,j0}-*ÐU~uh7	h  Ð~ fh  `h7	h h` Y&(&u3Ðf     
f    fbf9 sVfh   f6 fh  `f6Z Iu*u%f6&fh  f6Z Z= u&&G
 tf6&X놐f6&WA~ uh7	h 3ar j   l ء\ +Z  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h
h| j  l RP~
#fh   vfh`  j f6Z r
Bv  WV7	~ f~ th7	h FPRt~ FPu3^_h7	h$ h` W&(&tj fbf-   fPf6&v
f6&jFPu
f6&x~ uF.~uF6b 8Fuc 8Fud 8Ftf6&VkFPh@Rf6&U ^_Ð~ fh  G.h7	h$ h` V&(&
f     	 "fbf9 sTf6&fh  f6Z V= X&&G
 Kfh   f6 fh  `f6Z )t!f6&>Ufh  `b^_Ðfh   vfh`  j f6Z \Ur j   l ء\ +Z  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h
h| j  l RP${
FF>v tjJj1j f6j Z{jh7	h( p j   l RPz
6n h
h| j   l RPz
r j   l ء\ +Z  &&Wt j  l f&    v j  l ؎f&   x j  l ؎&  E&  FF܌VF V   R   X   f,
S h,h,j^q
>8 u_>/@V Rf,N  f0    FޣTFܣ6hTh,h,j%w>8 t>-uR   hJNu~ tX   Ft
F$p*X Ð&  VFF܌Vf,D 6QCZ4hTh,h,jv>8 t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	,&,ZhTh,h,jMv>8 tjgfRPs  fh  ! h
hxj=RPUF  @n +FHuF F^	&x&*hj*mVFn 9F}j zĈf<t<uh7	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>V  u#jGzRPrjHjRPr3ø x&hjUh~tuÐ  fh  u3fF    fFfbff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "hj
TjoRPSFF*;ds6PjNRPSF*Pux&
뫐x&
hj
}TjxRP!qju,jARPqjBRPp>J  t`hfh` jRP-SÐ  fh  h@hft"jIeRPpjJURP}pjwCRPkpfh  ujCF  hj
Sj
RPRF~uJ~FF*;dsPjRPbRj F*PNux&
띐t~ F bx&
hj
RF~sF F shj
RjQRPQ>J   FF*;dsfh   Pfh  j f6Z fh   F*Pfh`  j f6Z F*Pj$RPjQj F*PVu_&
\h@h` jRP)QjWRPjVRPh7	h4 	QÐ  fh h@hfgt"jIARPinjJ1RPYnjwRPGnfh  ujCF  hj
kQjRPkPF~uJ~FF*;dsPjRP>PjF*P*ux&
띐it~ F bx&
hj
PF~sF F shj
Pj-RPO>J   FF*;dsfh   Pfh  j f6Z qfh   F*Pfh`  j f6Z F*Pj$RPFOjF*P2u_&
\h@h` jRPOjWqRPjVgRPh7	h4 NÐ  F >X ut~ th7	h< h7	hH FP.hh7	h$ FPKFVu3vPfh  f6Z |K= s^&G
 tF  fvPJO>X u~ t	h7	hT h7	h` FPgh7	h$ FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6Z FPy0F~rh7	h h7	h< IFVtvPfh  f6Z QK= s^&G
 tF  fvH~ uj/RPLh7	h< jRPLF*  F xu3E-t*t~ th7	h< FPej h7	hH FPej!RPFPeh7	h$ FPIFVtvPfh  f6Z H= s^&G
 tF  fvG~ tj"MRPK/F~  F ohj
LF  hj LFj";F~x& ܊F*PjRPcKf6Z FP/FF~s#~ t~ uw&
tFPFPj#RPK~ u~ tjjgRPJF  F f6Z FP).~uPh7	h h7	h< GFVu3vPfh  f6Z  I= s^&G
 tF  fvdFFÐUf6Z FP.Ð  F u3F F~s7F*PjRP*Jf6Z FP<uh7	h2 Jh7	h h7	hT FFVtvPfh   f6Z BH= s^&G
 tF  fvEx&

hj
JF hj wJFj N*;~x& Րx&
hj
+J~ ujRP%Ih7	hT jRP
IF*  F u3t~ th7	hT FPQbj h7	h` FP<bj!0RPFP'bh7	h$ FP~EFVtvPfh   f6Z yE= s^&G
 tF  fvMD~  j"RPIH9EF phj
IF  hj 	IFj"R;F~x& ܊F*Pj[RPGf6Z FP:FF~s#~ t~ uw&
t~ tFPFPj#RPG~ u~ tjjRPaGF  F f6Z FP9u3À~uLh7	h h7	hT DFVtvPfh   f6Z rE= s^&G
 tF  fvBFÐUf6Z FP9ÐU  
2

` UvV>
Ð  >
vVF*^&F^&  >`% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU젶
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2*>* 	*  iÐ*i  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRh7	hl ^Sab~uvvh7	hv fvaÃ~P|FlFFPvvh7	h fvaÐ  FPNQVRh7	hl fvavvvh7	h FPraFPNQVRh7	hl fvavvvh7	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>  tF ^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvh W  
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F F F3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6 ^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj 9Fufh  jjG^& tDfh  yj  +FHu
^&Guʡ +F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh    9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;(}(F;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F F(Pv~ 7
F(F
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6`FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%>` tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>X uFP_!ÐFP>X u0 ÐU>X uFP+ÐFPU>X uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHF`F`  F
FFFF  F9F~FF^v&8 uvvE~ u
F`F^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"  n HPhFP
FPj hUF=
tK-
t
-.t-	 NF n HP*PPhvFt(=t#= ;t= DuÐ- Ht- t- t- tàn Ȣh<htLth<hِ 1= t= ut Ӄ>V  t fj hN3  F/ ~ ujQFÐF Df>b   FF Ffbf   ffffN*+;<|;s6F*@N*/ Shx=h*F*P̓uFx j hx=h j̓]FUtKjh̓h
h` j hlfj h\G=thx=hEtÐh
h@h
hf~&QWÐQ&WÐU~ u h
hfjhdHh
h@jhd7F  F~ ujFÐF Df>b   F4w j h>h:fh  L΃uF  Ffbf   ffffN*+;=|;s7F*@N*/ 4Sh>h:j F*P̓uF2uF~ u~ 4/ F F~sF 4/ F cFfbf   ffffN*+;t|;snjSF*PShSf6Z Tڃfh   F*Pfh`  j f6Z ڃF*@N*/ 4j h>h:j F*P	̓h~ tfj hz!F\  fh  ̃h
h` !fh  ̃t"h
h@h
hf+t";fj hE/fj h>=uuh>hdt!h>h:tfj hrU~ u h
hfjhdh
h@jhdF  F~ ujOFÐF Df>b   Fw j hAhdfh ˃uF  Ffbf   ffffN*+;=|;s7F*@N*/ ShAhjF*PR˃uFuF~ u~ / F F~sF / F cFfbf   ffffN*+;t|;snjSF*PShSf6Z ׃fh   F*Pfh`  j f6Z ؃F*@N*/ j hAh#jF*Pyʃh~ tfj hzF\  fh 5ʃh
h` fh ʃt"h
h@h
hf蛼t"fj hEfj h>=uhRAhdt!hAhtdfj hÃ>J  tj ht$ $   / ~ uj߃FÐF Dj Ճu` j hDhtF F~s3_ F*/ j hDhFPuF? j hDh|he>X utTtMttFj t:hRAhdCfj h>=thDhtÐ  / ~ ujރFÐF DF F~s-F*/ j hEhFPuF? j hEhh
또>X ut>t7j hwfj h\=thEhtÐ  / ~ uj݃FÐjӃuÐF D` j hEhtF F~s3f F*/ j hEhFPuF? j hEhh
c>X utTtMtFjt:hRAhdafj h>=thEhtÐUfvhB  \*F.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
\N*OÐU*FP\PK**PKÐU*FP\PKF*P*PwKÐ  >T u7]  FVL;Vrw;Fv	T ÐFP
uh h UT  >T u
FPh iÐUT  >T u
FPh IÐUFPh 9FPh -j>T th UFPh FPh FPh j|MÐ  >V tRFPh FPh FPh FPh j0 h l<uV  >V u&v*N"FF FF
FPvB\*Ð=tw$-t-| u)^  >^t% Ð^ -t-t t-0 t^ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U^FPgÐFPtHtÐ^	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  P h FF )fF~}j v`tFP  F~s#>P tFPh F  f+fF볐>P  F  `>P t(^&k^&?tP  FfF~|F~s>P tFPh ;f+fFҐ>P uKF~}Afh   j FV^& ^& h.P F 닐FPh j FV^&^&PÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h Rfh   FRPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uRPh Zj FF  	&f FP*ătFPh
hfփ~ th7	h`
h7	hl
FP3h7	h$ FPUFVu3vPfh0  FPLfv4FPh
h@kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhLNfh\  hj 6Lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6LhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	&f FP貶tFPh
hfaɃ~ th7	hx
h7	h
FP&h7	h$ FP	FVu3fj hvPo(
fvfh  FP	fvFPh
h@ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tûZ XËZaËXaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..]f^gef[UfS..]f^gef[UfS..]f^gfeff[UPfS..]f^Fgef[XUPfS..]f^Fgef[XUfPfS..]f^fFgfef[fX                           UfPS^tf3ff]  f.].] "  u  $" u [fX 0!<s3P˿
6 + r ׁ~sh3P1L!66ƱH6`b66gP6g
P6g6g6&\6 +۴J!6
+3	O3X 66666P.h_ظ ^3`P.h_ۚzd  y>	uXP	 P^
 5! %0_!	)&6, 		3	sx		 	&, >3&= t4
 |t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
t z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;|uQVW| _^Yt^?G^
u͎^O]UVWV	;t@t3_^] UWvt 3I >	u	@!_] SQ XQP,[XYt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt(u%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVTFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	(uVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*ot/ppPvvPvvF^&*ou^&?%t2XdVZ\T`3jfh~` uoF^*&otfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt ot)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPotou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\ou̓.uMhhtAĞrr&.hht'jĞrr&pvv
ou̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnoupVvvj u
T t nĞr& \~P|z\Pf
 P|z\P\^*&;tpVvv RT uInC-c = w.dvoxr@t@t@t$vq$v$v$v$v0txrjr$v$vo$vxr$v$vq$v$voRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^ot$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvou^] wxxNxzxxxxUwVW3FFv&vF
t~ }F, <Xw$ FF.wV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuIOWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
dF
ZFFt~ u	W`guF u	W^&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>V tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uSuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B
&X=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV43V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVvv&PFPW Pvv;u)x&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;xvJ;vvv ;s33󫖹 +v*39p	tvvvp	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3
 u
_^]U VW 3~v
tȰCvu&6r	% uN&6r	&t	HȰ"Cu׍D&r	&t	% uDȰ"Ctd&r	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋv	tv	F3] UFu		u { rFGFF3҃vvډWNu(t$>h uS#5!hj[P#%!u鍋s̍ˍʻ 	FV]U컍 .8tK
Ix	]PPR.h_؃> ux	z	w1uRUVV EE< ujF hF]ZXXˣ		UWVQS3x	z	 P	X[Y^_]ZXX˃PU
ء	F	F]XSQR
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ_$%!3]UWVRQSP.h_ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;ut^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;xv;vvv3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]              
              4.61  mm/dd/yyyy    .BAK  wb  .BIN  rb  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/Dock] [/Update] [/Backup] [/Restore] /X [/!]  where: /Dock    = operation applies to docking station         /Update  = update BIOS with new version         /Backup  = save BIOS to disk        /Restore = program BIOS with backup image         /X       = clear ESCD and CMOS/ECMOS        /F       = force docking station recovery         /C       = do not allow exit to DOS (power cycle)         /!       = do not allow exit to DOS (power off)  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Invalid command Machine is not docked Could not clear ESCD and CMOS because a password was  set or because the command is not supported Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   7	                        68xxx.BIN                $ ( , 0 & ' @  ) * @>  , - :C  X Y C ] ^ D a b E d e F %  
 \  
  D10/17/2001  O                                                                           7	 7	 7	 7	 7	7	N7	~7	7	7	 7	27	l7	7	7	7	7	$7	L7	r7	7	7	7	7	$7	<7	N7	t7	7	7	7	7	7	7	7	(7	D7	b7	n7	v7	7	7	7	7	7	7	7	,7	07	87	@7	J7	T7	`7	l7	z7	7	7	7	7	7	7	7	
7	 7	&7	N7	r7	7	7	7	7	 7	@7	z7	7	7	7	7	7	7	&	7	B	7	b	7	v	7		7		7		7		7		7		7	
7	D
7	n7	Z
7	v
7	
7	7	
7	
7	7	 7	07	R7	p7	7	7	7	7	7	7	7	D7	r7	7	7	7	7	.
7	@
7	P
7	                                  C    D    @ h 2
      A    B    @ h P
      E    F    @ h n
      I    J    @ h 
      M    N h 
      L    K j 
      G    H    N h 
      +     /    ) k 
      R     O j 
      (    /    & k .
      P    Q     S   
T   
O i L
      V    W    U h v
      .     /    , k 
      [    Z i 
      _     /    ] k 
      c     /    a k 
      f     /    d k 
      m    n    o    p     q     l h $
               :`                           _C_FILE_INFO=                                                         
               
	
\ \                                  

  

                                                                                                                                                                                                                                                                                                                                                                                                                                             
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          aaaaaaa               (((((                  H                                                                                                                                        
                                                     /_/_/_                  h




<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                            buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        		    GNU GENERAL PUBLIC LICENSE
		       Version 2, June 1991

 Copyright (C) 1989, 1991 Free Software Foundation, Inc.
                       59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.

			    Preamble

  The licenses for most software are designed to take away your
freedom to share and change it.  By contrast, the GNU General Public
License is intended to guarantee your freedom to share and change free
software--to make sure the software is free for all its users.  This
General Public License applies to most of the Free Software
Foundation's software and to any other program whose authors commit to
using it.  (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.)  You can apply it to
your programs, too.

  When we speak of free software, we are referring to freedom, not
price.  Our General Public Licenses are designed to make sure that you
have the freedom to distribute copies of free software (and charge for
this service if you wish), that you receive source code or can get it
if you want it, that you can change the software or use pieces of it
in new free programs; and that you know you can do these things.

  To protect your rights, we need to make restrictions that forbid
anyone to deny you these rights or to ask you to surrender the rights.
These restrictions translate to certain responsibilities for you if you
distribute copies of the software, or if you modify it.

  For example, if you distribute copies of such a program, whether
gratis or for a fee, you must give the recipients all the rights that
you have.  You must make sure that they, too, receive or can get the
source code.  And you must show them these terms so they know their
rights.

  We protect your rights with two steps: (1) copyright the software, and
(2) offer you this license which gives you legal permission to copy,
distribute and/or modify the software.

  Also, for each author's protection and ours, we want to make certain
that everyone understands that there is no warranty for this free
software.  If the software is modified by someone else and passed on, we
want its recipients to know that what they have is not the original, so
that any problems introduced by others will not reflect on the original
authors' reputations.

  Finally, any free program is threatened constantly by software
patents.  We wish to avoid the danger that redistributors of a free
program will individually obtain patent licenses, in effect making the
program proprietary.  To prevent this, we have made it clear that any
patent must be licensed for everyone's free use or not licensed at all.

  The precise terms and conditions for copying, distribution and
modification follow.

		    GNU GENERAL PUBLIC LICENSE
   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

  0. This License applies to any program or other work which contains
a notice placed by the copyright holder saying it may be distributed
under the terms of this General Public License.  The "Program", below,
refers to any such program or work, and a "work based on the Program"
means either the Program or any derivative work under copyright law:
that is to say, a work containing the Program or a portion of it,
either verbatim or with modifications and/or translated into another
language.  (Hereinafter, translation is included without limitation in
the term "modification".)  Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not
covered by this License; they are outside its scope.  The act of
running the Program is not restricted, and the output from the Program
is covered only if its contents constitute a work based on the
Program (independent of having been made by running the Program).
Whether that is true depends on what the Program does.

  1. You may copy and distribute verbatim copies of the Program's
source code as you receive it, in any medium, provided that you
conspicuously and appropriately publish on each copy an appropriate
copyright notice and disclaimer of warranty; keep intact all the
notices that refer to this License and to the absence of any warranty;
and give any other recipients of the Program a copy of this License
along with the Program.

You may charge a fee for the physical act of transferring a copy, and
you may at your option offer warranty protection in exchange for a fee.

  2. You may modify your copy or copies of the Program or any portion
of it, thus forming a work based on the Program, and copy and
distribute such modifications or work under the terms of Section 1
above, provided that you also meet all of these conditions:

    a) You must cause the modified files to carry prominent notices
    stating that you changed the files and the date of any change.

    b) You must cause any work that you distribute or publish, that in
    whole or in part contains or is derived from the Program or any
    part thereof, to be licensed as a whole at no charge to all third
    parties under the terms of this License.

    c) If the modified program normally reads commands interactively
    when run, you must cause it, when started running for such
    interactive use in the most ordinary way, to print or display an
    announcement including an appropriate copyright notice and a
    notice that there is no warranty (or else, saying that you provide
    a warranty) and that users may redistribute the program under
    these conditions, and telling the user how to view a copy of this
    License.  (Exception: if the Program itself is interactive but
    does not normally print such an announcement, your work based on
    the Program is not required to print an announcement.)

These requirements apply to the modified work as a whole.  If
identifiable sections of that work are not derived from the Program,
and can be reasonably considered independent and separate works in
themselves, then this License, and its terms, do not apply to those
sections when you distribute them as separate works.  But when you
distribute the same sections as part of a whole which is a work based
on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the
entire whole, and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest
your rights to work written entirely by you; rather, the intent is to
exercise the right to control the distribution of derivative or
collective works based on the Program.

In addition, mere aggregation of another work not based on the Program
with the Program (or with a work based on the Program) on a volume of
a storage or distribution medium does not bring the other work under
the scope of this License.

  3. You may copy and distribute the Program (or a work based on it,
under Section 2) in object code or executable form under the terms of
Sections 1 and 2 above provided that you also do one of the following:

    a) Accompany it with the complete corresponding machine-readable
    source code, which must be distributed under the terms of Sections
    1 and 2 above on a medium customarily used for software interchange; or,

    b) Accompany it with a written offer, valid for at least three
    years, to give any third party, for a charge no more than your
    cost of physically performing source distribution, a complete
    machine-readable copy of the corresponding source code, to be
    distributed under the terms of Sections 1 and 2 above on a medium
    customarily used for software interchange; or,

    c) Accompany it with the information you received as to the offer
    to distribute corresponding source code.  (This alternative is
    allowed only for noncommercial distribution and only if you
    received the program in object code or executable form with such
    an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for
making modifications to it.  For an executable work, complete source
code means all the source code for all modules it contains, plus any
associated interface definition files, plus the scripts used to
control compilation and installation of the executable.  However, as a
special exception, the source code distributed need not include
anything that is normally distributed (in either source or binary
form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component
itself accompanies the executable.

If distribution of executable or object code is made by offering
access to copy from a designated place, then offering equivalent
access to copy the source code from the same place counts as
distribution of the source code, even though third parties are not
compelled to copy the source along with the object code.

  4. You may not copy, modify, sublicense, or distribute the Program
except as expressly provided under this License.  Any attempt
otherwise to copy, modify, sublicense or distribute the Program is
void, and will automatically terminate your rights under this License.
However, parties who have received copies, or rights, from you under
this License will not have their licenses terminated so long as such
parties remain in full compliance.

  5. You are not required to accept this License, since you have not
signed it.  However, nothing else grants you permission to modify or
distribute the Program or its derivative works.  These actions are
prohibited by law if you do not accept this License.  Therefore, by
modifying or distributing the Program (or any work based on the
Program), you indicate your acceptance of this License to do so, and
all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

  6. Each time you redistribute the Program (or any work based on the
Program), the recipient automatically receives a license from the
original licensor to copy, distribute or modify the Program subject to
these terms and conditions.  You may not impose any further
restrictions on the recipients' exercise of the rights granted herein.
You are not responsible for enforcing compliance by third parties to
this License.

  7. If, as a consequence of a court judgment or allegation of patent
infringement or for any other reason (not limited to patent issues),
conditions are imposed on you (whether by court order, agreement or
otherwise) that contradict the conditions of this License, they do not
excuse you from the conditions of this License.  If you cannot
distribute so as to satisfy simultaneously your obligations under this
License and any other pertinent obligations, then as a consequence you
may not distribute the Program at all.  For example, if a patent
license would not permit royalty-free redistribution of the Program by
all those who receive copies directly or indirectly through you, then
the only way you could satisfy both it and this License would be to
refrain entirely from distribution of the Program.

If any portion of this section is held invalid or unenforceable under
any particular circumstance, the balance of the section is intended to
apply and the section as a whole is intended to apply in other
circumstances.

It is not the purpose of this section to induce you to infringe any
patents or other property right claims or to contest validity of any
such claims; this section has the sole purpose of protecting the
integrity of the free software distribution system, which is
implemented by public license practices.  Many people have made
generous contributions to the wide range of software distributed
through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing
to distribute software through any other system and a licensee cannot
impose that choice.

This section is intended to make thoroughly clear what is believed to
be a consequence of the rest of this License.

  8. If the distribution and/or use of the Program is restricted in
certain countries either by patents or by copyrighted interfaces, the
original copyright holder who places the Program under this License
may add an explicit geographical distribution limitation excluding
those countries, so that distribution is permitted only in or among
countries not thus excluded.  In such case, this License incorporates
the limitation as if written in the body of this License.

  9. The Free Software Foundation may publish revised and/or new versions
of the General Public License from time to time.  Such new versions will
be similar in spirit to the present version, but may differ in detail to
address new problems or concerns.

Each version is given a distinguishing version number.  If the Program
specifies a version number of this License which applies to it and "any
later version", you have the option of following the terms and conditions
either of that version or of any later version published by the Free
Software Foundation.  If the Program does not specify a version number of
this License, you may choose any version ever published by the Free Software
Foundation.

  10. If you wish to incorporate parts of the Program into other free
programs whose distribution conditions are different, write to the author
to ask for permission.  For software which is copyrighted by the Free
Software Foundation, write to the Free Software Foundation; we sometimes
make exceptions for this.  Our decision will be guided by the two goals
of preserving the free status of all derivatives of our free software and
of promoting the sharing and reuse of software generally.

			    NO WARRANTY

  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
REPAIR OR CORRECTION.

  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGES.

		     END OF TERMS AND CONDITIONS

	    How to Apply These Terms to Your New Programs

  If you develop a new program, and you want it to be of the greatest
possible use to the public, the best way to achieve this is to make it
free software which everyone can redistribute and change under these terms.

  To do so, attach the following notices to the program.  It is safest
to attach them to the start of each source file to most effectively
convey the exclusion of warranty; and each file should have at least
the "copyright" line and a pointer to where the full notice is found.

    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) <year>  <name of author>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this
when it starts in an interactive mode:

    Gnomovision version 69, Copyright (C) year name of author
    Gnomovision comes with ABSOLUTELY NO WARRANTY; for details type `show w'.
    This is free software, and you are welcome to redistribute it
    under certain conditions; type `show c' for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License.  Of course, the commands you use may
be called something other than `show w' and `show c'; they could even be
mouse-clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your
school, if any, to sign a "copyright disclaimer" for the program, if
necessary.  Here is a sample; alter the names:

  Yoyodyne, Inc., hereby disclaims all copyright interest in the program
  `Gnomovision' (which makes passes at compilers) written by James Hacker.

  <signature of Ty Coon>, 1 April 1989
  Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs.  If your program is a subroutine library, you may
consider it more useful to permit linking proprietary applications with the
library.  If this is what you want to do, use the GNU Library General
Public License instead of this License.


                                                                               MZ\  `  *   b             V  ?    I       @  U    [  C    ?  
  n
  2
  4      J    i              [  6  0            y  W  "  D  .  E"  ?"  1"  !  }!           %  %  #  s#  ^#  %#   q
 q
 q
j)  Q)  1)  )  (  (  (   q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
~q
zq
vq
rq
nq
jq
fq
bq
^q
Zq
Vq
Rq
Nq
Jq
Fq
Bq
>q
:q
6q
2q
.q
*q
&q
"q
q
q
q
q
q

q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
q
~q
zq
vq
rq
nq
jq
fq
bq
^q
Zq
Vq
Rq
Nq
Jq
Fq
Bq
>q
:q
6q
2q
.q
*q
&q
"q
q
q
q
q
q
B  B  QB  KB  B  H  	H  G  E  E  +E  %E  	E  Zq
*q
q
q
q
q
q
|q
Rq
4q
q
q
q
q
q
q
tq
Vq
8q
 R  R  R  R  wR   m`  `  	`  `  _  c  c  c    	q
6q
0q
q
u    i                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  3Ðjː
  F  F~ F F^9 uvfv(}fvfv(~h	h jNRPVtj
fvvP6
h	h jORP썃Vtj
fvvP	
 Ð3f>^  tf6^ 蚋f>  tf6 臋j va  V   h jh j菃h jݏh  h j2ah 莏~[F ^v&v& =c   -!  - tHHt-2 tHtp   T  F^v&v&8 ^v&v& t^v&v&   ~L  T  T  P  N  >T  uT  zH  J  kF^vf&0hn 3F^v&v&8 uNV  *=p t -d jHH|f6B jRPjjjRPjzRPjjRPއjZRP·jJRP辇j	:RP讇j
*RP螇jRP莇j
RP~j
RPnjRP^jUaD-r - 0- FF9F}-^v&&?-t^F&&?/uF \=sjytRP膃j`\tjzURPɆj`>V   h	h hn evxvuj fh  ! hm
hDf6vfh   hm
hDe| f6vdfF    .^
~ ^&0D^&DF~	vF  F| 9F|tF= t= ujRPj_\[fh  j 踇^ ` ^ uj{MRPj_
>R  tF  !\t( !  9  =  A  E  I jJj1fj>   uj{RPGj>_a^t(b       ؎f&fjyRPj^>P  t>R  t\  Z  L  >\ t>\ u& & & >\ uG>T  u	>L   >L   >\ u3T Ht	HtHt8j ]uwjJulj?jA.>\ u?T Ht
HtHtHtIjj OȐju+jRPjT HHtH
>T  t7>N  t0f|A  h|h|jo
> tjJRP较>J  t 
j ]Ot  F >t >P  t>R  t\  Z  L  >\ t>\ u& & & >\ u[F4'~ tfj fj G/F  =HtkI-
 -!- - - 
tFfG> ~ H  6 H;~  ߃> ~ H6Ĵ &@u H;~  6Ĵ &@u  FV^& &G|&Wpfj Bd   F >J  t?Kt B= M- K- '-M- 0- )fjA>J  t
j [^ÐU
^&L&NÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ð|"~
 hh|h|j艃}X >>  fFffFf+fFFfFPj ff-    fPfvFPfvFP/ff-    fFʋF΋VЃFƉVȃ~ uf~uF      ÐfFf9Ftbfj ff-   fPfvFPfvFPff-   fFʋF΋VЃFƉVfFf9Ft3fF     fFffFfFfFfFfFf+Ff-   f;FvfvVFVՐf~ uF+Ҋ*ҋN^+ډN^fFfFVf9FvRPNVFᐃ~ S  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hm
hD    RP苃
a3ÐSfv
 ÐT  Vfh  P FP蹃f|K  Fhh|h|j辀> t3^ÐFP8zBFVh	h FP$RPhyh	h fvRPhd yfvhd ,y ^Ð  FDFm
|"~FFhh|h|j}*ÐU~uh	h  Ð~ fh` j h	h hd d\vxvu3Ðfp    
fp   ff9psVfh   f6pfh  `f6^ Ku*u%f6vfh  f6^ ]= uv&G
 tf6vZ놐f6vZ?~ uh	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hm
hD    RP〃
fh   vfh`  j f6^ t@v  WV	~" f~ th	h FP4w~ FPu3^_h	h hd oZvxvtj ff-   fPf6vx
f6vjFPmx
f6vr{~ uF.~uF6f 8Fug 8Fuh 8Ftf6vXkFPhVf6vX ^_Ð~ fh  C.h	h hd Yvxv
fp    	prff9psTf6vfh  f6^ wY= Xv&G
 Kfh   f6pfh  `f6^ 
)t!f6v Xfh  `^_Ðfh   vfh`  j f6^ 
\U     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hm
hD    RP~
F> tjJj1j f6 <~jh	h(      RP}
6 hm
hD     RP}
     ء` +^  &&W    f&        ؎f&       ؎&  &  FF܌VF Z   R   \   f|
S h|h|j@t
> u_>@Z Rf|N  f    FޣFܣhh|h|jz> t>}uR   hMNu~ t\   Ft
F$p*\ Ð&  VFF܌Vf|D QChh|h|jy> t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	|&|Zhh|h|j/y> tjlRPpv  fh  ! hm
hD{jRPXF  @ +FHuF F^
&DZxV&*VhVj*OYF 9F}j }Ĉf<t<uh	h2 3XÐ  += t= u%F  F~}
Fu~|3Ð Ð>Z  u#jJRPujK RPtu3ø ZxV&VhVjXh܁tuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPnfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPKFVfFf  fPK;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRPKې~  fF    fFffFȸ	~4 fffFfFfFfFf-   f;Fvfv]JFVِf~qhXku2f+fFfFf~svBPƋVFVRP>Jِ^_   jF "hVj
VjORPUFF*;s6Pj.RPTF*P2uZxV&
V뫐ZxV&
VhVj
Uj}RPMrju,jDRP1rjERP!r>J  thhd jRPYTÐ  [@7fh  Ohh#t"jNERPqjO5RPqj|#RPqfh  ujFF jRPh	hH SF~  FF*;s>  u+ҊN*+= utԊF*PjRPoSj F*Pyu>X X}jLtRPh	h> >SjM^RPh	hD (S>J  SÐt~ h	h2 RF 8ZxV&
VhVj
SF~sF F FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj'RPfRj F*PpujtRPh	hH hhd jYRP)Rj\IRPj[?RPh	hN 	RÐ  4+fh hht"jNRPiojORPYoj|RPGofh  ujFF  jRPh	hH qQF~  FF*;s>  u+ҊN*+= utԊF*Pj ORPQjF*P)u>X X}jL$RPh	h> PjMRPh	hD P>J  Ð9t~ F 8ZxV&
VhVj
QF~sF F !FF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj'RRP"PjF*P,uj0RPh	hH hhd j!RPOj\RPj[RPh	hN OÐ  F >\ ut~ th	hV h	hb FPih	h FPeLFVu3vPfh  f6^ \L= s^&G
 tF  fv0KO>\ u~ t	h	hn h	hz FPhh	h FPKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfP9CȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPC  F .u3tF f6^ FPY1F~rh	h h	hV JFVtvPfh  f6^ 1L= s^&G
 tF  fvI~ ujRPMh	hV j"RP{MF*  F vu3%.t(t~ th	hV FPfj#h	hb FPfj$JRPFPfh	h FPIFVtvPfh  f6^ I= s^&G
 tF  fvH~ tj%RPL0F~  F ohVj
MF  hVj mMFj%;F~ZxV& V܊F*PjsRPCLf6^ FP0FF~s#~ t~ uZwV&
VtFPFPj&RPK~ u~ tjjRPKF  F f6^ FP	/~uPh	h h	hV yHFVu3vPfh  f6^ I= s^&G
 tF  fvDGFÐUf6^ FP/Ð  F u3F F~s7F*Pj:RP
Kf6^ FP_=uh	h2 Jh	h h	hn GFVtvPfh   f6^ "I= s^&G
 tF  fvFZxV&
V
hVj
iKF hVj WKFj N*;~ZxV& VՐZxV&
VhVj
K~ uj5RPJh	hn j"RPIF*  F u3t~ th	hn FP1cj#h	hz FPcj$RPFPch	h FP^FFVtvPfh   f6^ YF= s^&G
 tF  fv-E~  j%YRP)I:EF phVj
IF  hVj IFj%T;F~ZxV& V܊F*PjRPHf6^ FP:FF~s#~ t~ uZwV&
Vt~ tFPFPj&RPaH~ u~ tjjqRPAHF  F f6^ FP:u3À~uLh	h h	hn DFVtvPfh   f6^ RF= s^&G
 tF  fvCFÐUf6^ FP9ÐÐU  2
	 UvV>	Ð  >	vVF*^&F^&  >% 
FNÐU
U  À6	U6

Ð  F
+F@FFF!vvW	F>	NFF@;FUj fvfvà*P Pfj   FPNQ*PfvvU  ÐU% ^&*^&ÐUF
FÐ  >	FF  FPNQ*;F|	F>	 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2J>J 	J  jÐJuj  ~ t	h8FNuÐ  FjfvFP^
F FPNQVRh	h ^S?c~uvvh	h fvbÃ~P|FlFFPvvh	h fvbÐ  FPNQVRh	h fvbvvvh	h FPPbFPNQVRh	h fvbvvvh	h FPbFPFPQ]ÐUvߋRPh]
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fv]F
^v&  FF9F|^v&  ^UVfvfvc\FN^v&8 t&@ ^fj <fh  vfh   !jރRPf6B p\*+IQj f6B Ð  FPNQfj vj ivvÐ  VF   
& FF  @ 
&ğ &0%ރFVRP[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^ 
6&Ĵ &@t2j>vjqj+jFvv^ 
6&Ĵ &@ F  F j9Fu
F F  ^ 
6&Ĵ &@tF vv} 
&ğ v&0܃FVRPtZFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^9FuFPFP%fjNj l 
^& ۃRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>
 tF
^fvjڃFVRPX*+ȃQ *P%jj fvvvvv9ÐUj=fvh
dX
 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7كRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w؃RP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN*+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F*+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0ՃRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0҃RPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j *P HPfj
' 
6&Ĵ &p҃RPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0σRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;H}HF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FHPv~ 7
FHF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP="ÐFP>\ u!ÐU>\ uFP)ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPhDFP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPhDvFt(=t#= ;t= DuÐ- Ht- t- t- tà ȢhT@htFthT@hِ += t= ut у>Z  t fj h8N3  FP2 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*2 PSh.AhV*F*P˃uFP} j h.AhV j˃]FUtKjb˃hm
hd j hnlfj hG=th.AhVEtÐhm
hhm
h~&Ð&ÐU~ u hm
hjhHhm
hjh7F  F~ ujFÐF Df>   F| j hBhfh  H̃uF  FuF~  ~2 F  Fff   ffffN*+;|;sF*@N*2 ShBh`>  u)ff   ffffN*+ = utj F*P˃q>X X<fj hF~4F 2 F ;Fff   ffffN*+; |; jSF*PShSf6^ كfh   F*Pfh`  j f6^ =ڃF*@N*2 j hBh[>  u+ff   ffffN*+ = uFj F*P{ʃ2~ fj hF#  fh  7ʃhm
hd fh  ʃt"hm
hhm
h뺃t"fj hEfj hr#=uhxBht!hBhtjfj hU~ u hm
hjh.hm
hjhF  F~ ujFÐF Df>   F| j hEhfh .ɃuF  FquF~  ~m2 F  Fff   ffffN*+;|;sF*@N*2 ShEhF>  u)ff   ffffN*+ = utjF*Phȃq>X X<fj hF~4F 2 F ;Fff   ffffN*+;t|;snjSF*PShSf6^ փfh   F*Pfh`  j f6^ '׃F*@N*2 j hEhEjF*Pǃh~  5fj hF?  fh Sǃhm
hd fh ;ǃt"hm
hhm
ht"fj hEfj hr?=uhEh9t!hEh(tfj hÃ>J  tj h
 tt t   "2 ~ ujރFÐF Dj ԃue j hHh(tF F~s3d F*2 "j hHh(FPuF"B j hHh(he>\ utTtMtFj t:hEhefj hr=thHh(tÐ  @2 ~ uj݃FÐF DF F~s-F*2 @j hIhFFPuF@B j hIhFh/또>\ ut>t7j hn<fj h=thIhFtÐ  ^2 ~ uj	݃FÐj҃uÐF DXe j hzJhdtF F~s3Xk F*2 ^j hzJhdFPuF^B j hzJhdh/c>\ utTtMtFj1t:hEh%fj hr=thzJhdtÐUfvh  zF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NzOÐU*FPPKz*PKÐU*FPPKF*PzPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBzÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졮FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  "
& FPHtFPhm
hՃ~ th	hh	hFP3h	h FPUFVu3vPfh0  FPLfv4FPhm
hո UXՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hԃh 
ufh  h j
u  fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  HPhhӃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
҃hx<BPhx>Bj
҃F  hxB$PhxBohxBPhxB`F~|hxA$PhxAhp  fhx AF  F~
}YhxA$PhxAj23҃hxAPhxAh҃fh  gFhу~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhfуm$PÐUj
LыFPh fh  	jmj$ыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
ЋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hYσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2΃fh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hs̓fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h 6̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth &Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  $
& FPгtFPhm
hȃ~ th	hh	hFP&h	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhm
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..ebf^gef[UfS..ebf^gef[UfS..ebf^gfeff[UPfS..ebf^Fgef[XUPfS..ebf^Fgef[XUfPfS..ebf^fFgfef[fX                           UfPS^tf3ffeb  f.b.b "  u  $" u [fX 0!<s3P˿m
6 + r ׁsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666]P.cظ dP.cۚi  y> 
uXP
 Pm
 5! %c!
)&6, 

3
sx

 
&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.'Q
u'&ft ffz 

b > 
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 
 %!;s
OO
;sEtU P>( t( P]ø Y+r
;,rQ3 V3B 22Ut
 Pt ^Ï. <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &.U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV.
;t@t3_^] UWvt 3I > 
u
@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v0טÊ  UWVFG
@tG
  D
u VށJ>FVD*P{|]~ tZDPNQ!FFV~\tFPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN:-JD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN:-JD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWVPFPvvVPFVPWF_]ÐU'
t]UVWvD
t^@uZuGD
J:u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
J:3ۊ\uPuuGVtbtzu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށJ:tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7HFȁJ:؊FG
+EEEFEيF3EGǌ^_]ÐUVWv.Vt2bt	6zuVJ:D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvJ:t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vJ:@t^*&GPy= ^]ÐUWV3F؋O
рuGuJ:t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVJ3~~ uD
tV@uF96*r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr@t)ǆr:FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.zJtwxxxzpvzzzzxwvzzftzwzzsvzzntRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] ||||}}?}q}UwVW3FFv&vF
t~ }FB, <Xw$ FF.&|V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVJ+FF96*r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue> 
u
N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33Bm
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96*s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁJ:؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVVvv&VPFVPW Pvv;u)ZxVV&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFVTFPv
vVpx& V3P,^_]ÐUV$IFV "TRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3m
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	ft	F3] UFu

u { rFGFF3҃vvډWNu(t$> uS#5![#%!u}s`_ʻ 
FV]U! .8tK
I	]PPR.c؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUm
ء
F
F]XSQRm
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ$%!3]UWVRQSP.cۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ> 
u
 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y,;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;uHtH^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t> 
u	S
[!  	
u	> 
u	S
[! UV2] UVF ]UV] UVF]          m
              4.65  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/A] [/B] [/R] [/X] [/C | /!] [/P xx.bin] where: /D        = Dock (operation applies to docking station)         /U        = Update System BIOS with new version         /A        = All - Update System BIOS and Boot Block with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                  MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM                 $ ( , 0 ) * D  , - A  / 0 G  ] ^ vH b c JI f g ,J i j ,K (  m
 a  m
  D10/17/2001  O                                                                           	 	 	 	 	4	t			&	b				>						,	R	|					 		*	P	`								 	>	J	R	f	~										&	0	<	H	V	d	t									*	N	d							R		x								
	
	"
	0
	^
	z
	
	
	
	
	
			4	L	|	J				~				8	h						 
	
	(
	N
	|
	
	
	
	 	6	f	x		                                  F    G    C m fm
      D    E    C m m
      H    I    C m m
      L    M    C m m
      N    O    C m m
      R    S m m
      Q    P o m
      J    K    S m ,m
      .     2    , p Jm
      W     T o hm
      +    2    ) p m
      U    V     X   
Y   
T n m
      [    \    Z m m
      1     2    / p m
      `    _ n m
      d     2    b p m
      h     2    f p :m
      k     2    i p Xm
      r    s    t    u     v     q m vm
               d                           _C_FILE_INFO=                                                         m
               
	
\ \                                  _m
  _m
                                                                                                                                                                                                                                                                                                                                                                                                                                             .m
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          eeeeeee               (((((                  H                                                                                                                                        &                                                     ccc                  fmm
m
m
m
m
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                           p   `      POST  f   f.V .X <  
 f.d ` j ` I     '       g    POST&3 Ԃ * M 
  G 	 y
 )   )
 9  f) _ ) 6 2 &3 2 2  ]  y | z  ! s,# $ {,% A' pU( ؆) L* , - X9. 7/ `0 1 512 3 4 i5 6 7 8 Gz9 @; = ,> ? /@ x" ,A 7`B >`C ,D OE F zG  H ĳI )J gL )M |O p3P )Q R g,S T ,U V کW X *Y Z G^ 
z[ _\ "] _ ڗ` a _b f3" f"u @      f{  3f   ffY  0f h0pu   q 3  `  U QVW.D7 PX' hX@s .X=X@u
_^rYʜPPSظ h# [X zu<t
PW 0jf&E1_Xa
 fPfSfQfRfGenu fnteluxfineIuof܀P%=  rYfa2f   uI؀/UhF
t/fA0tf  
 ~RZfYf[ft
V PRWfQ
u5p 
(ot'5f0@
u߿ h8ufY_ZXSQW/13
 h3_Y[R Y" t

L@
xq$a(&	%s
> h3h
6p0 0t  
Ãu
.(u	u/UPVF	` u tR	k@.t^~u 8	t/} t^6
5
^Xz'W~
(?  _f S43rLt<
tw
uο 	+ǫ_^p	9'1WfV&p#)6ڐS
F f[tҋ3f_f^ff$`K*fa9. @ ?fVWU@ t o f3h,!%/ tkfAh6 Py'Q.J3
rg>Ut2gFYPQ+1X\Pf3ɕX f	]_f^Jf`Sfff@9 h3:+f;r[? Wp
2h_
 WX
_: r
gN1
go?r @99 \ARWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_MU/2tg;^H2N@?" h fΑN   둡4]`dQRWV^NV vq6'Q3qI4GYGۋʫΕIw^_Z!3Q'M0  t8 YfWV3f_f"1*^IfPS. ,.(Fo(  f( y^
#N~u_!d*d.  CffQVsqRT?
ۀO2ۊ~f~0g:P`?tWuf f.(|ftf!f.@# n<
uF8Fuf_to^ÑGVR.>(s$0m	.k6(.(v

ZFHs ^2
F0(FPPr2PqN~ t4vf2&fz10
FNNI.(Ɣ{fQRVWPQu@f(.;(s0e~ ˁ ;u
t`gt@Ѵ 8^rf(  _^ZY eWQ3.>(2 .ǅ.ƅ ` P@hXU".( .`s$p' i~p3.(lh7zs o.N /p\wFk@"~ 
N~f.=6@.2ɠ0/t,lu4.Bf<t؅f  `b$< F.v 
1wq3VF~rF F;F F2u~w
PfF@ M~fNGf k lt
fNqu
ffsfF^Pc4)FQ
*q4rF$<u&jF # ~$wp` O.p< O?<uO8q^`V@;(@{..(;(^V0&0
9t@ރ-2ۿx@2
E/^S 65ӈ^35#uBX:NЎuP:
t3S9)u={8N0_^WV\SVR`Ffn*J[!ffAҹRffP%Ѐ`?2fpKf;w
?2fPRހft#f3!fDf^XfffNL$ss4
tu+q%
u	AfFaJfୀ}f^Z6Waf F`^~K"8ueffFՋN_QtcV@hvb!F;pI=3ϋ~+c:tsRV F;F8?u p? kv@kFӋ:`pb$$@K@3frD` w;=< ur,.;D$<uπ r0	 @BvFfYZt4}cVWv Ђfq|~|URd
t"t_t @Dv>P }PkQ9SV޾ [3; t	p r?^[ uk߼ [ːW#Aq[%Sx?^Y@j*pt@;v7h!1k~@ۀst 1;FtFk^% Bk^cՊ [a 3  V3k`[
*䊁"[;FuR*3]ft7]-k		# a
@S
+FHu
4uGrvFvVBs0;~pHVW΂tS03ދ[^NuVp _3ҋ0_&Y61-xDr<}lFkHpBHP뷋A(g7oZ Q&0V_  ~1|\0PN~ tKv0YFA.Qz$ x
fpO3g~ FfN@P@ 
0K SQh(	 \P,Q23If.` tf.&!. .8(tьL$QVW
fvUF%p"`PF^^F  FψF
fgFF ^Veb".^`L`Ч!ɱ ``Nf~ tFt'f`e 9Fv@f0
FfHf;Fy^Qr@րi`bbzbfC<4RVFF8F^ pVwF0 NU$ &(,ymtN!!fsШtE rts@CA9FvPG 3r%if.(NͿ  .`N0ƺ0 
t
F%  .p t>_~ t(i'i_f^z eȞu
 v@aQI8t%_  tu Qw  vfIft'fAff#a fpЊ=rSf.6 G                                                                                                                                                                                                                                                     @        o         PQRa&hF# $`Ȱ h$;rZYXSQWa$a$a_Y[2 TCA6n  @A Q C@@ @;uYð!$p h(PRfW  舘 h2
fg&G`g&Od0 f_ZXJ.-hR
 h52h PgdϻX`hТoc4hQhDB	3t*ߣ5h'\va LnhS,@ ؀  &}uu h(h
6\Wu- $@#h$!h)su h&/r#׿ذS%uShVS&hh }fPSfQ3 ߿ h̓fgf&7ˀ f` 7  {"fY[fXeúvø(fcb` ##aPo hub3`PQ% @ PQ= `t
3f3 @fYX _ 5ðdW`@0d  UP~07  :F  Q ؿ
Et&؁ uM9NwN#u~ t"F= wt%   +ȳ%=XhZc8`.-  	 5 a `hU~C t*` u U'7ua9tf` ؜f(  fVf@fغffffff% =a tfcbf 2pfTf D _ 	DPfað)W f5?1$+fSQ.JfU%`a` 0f: ZF rf
0of%Xu7,20MYf* @K  f$./<wfS % uf9<r2Z_h 
2
m`6 h<
as4
!5RĴ fh,G6f[XqZ!f٠8f`X2h$(r% s \\2	r-
tfy!"s!7DC5r[s Muo
NJefa!
't5<t1Jfw JU@  
C<X Y ZZ $    U  V WTQRVW3K}3n<K9D9
` R~b"R&p`R[[_^ZT|+   > JA  T j M e M A@  9 Y .   n #SA ʠ=a 3(
Wqw~ `\  +\{!`]zK2 P f|2!P`6\2f61  3s p~O 61>x  .h}$S $<t4r [J! ЍыhP33  e f`4 S  yq!oh=s%o ht1h   D 3 "r<pZF2"mƾj_ǿ-r/ǿ r%@@9&5&D&ENƛ7Aa
phS P߿^~py%xvV~^ 
8
3
~3
d=E
vǿC w0aǖ^&YU$=u&ǹf= =u &&&M
, fgh  0 pqr  <ABCDE xyz{|}   aSV S#
fh_fRV5 r&2&4Ⱦc5 r
&  ^ p5~"X oZfZbfX VCf  `nfwf&0V3
_^(w.@(t.FuN.Ppq _XWfVUSW! ,fv߿w h.ӂ  ޿R&~22ك!IN3d	^
u
t_NA&>-_[]f^_Q!PVҿ&=;u&&p4u&^6P
P< +&~&1E&DSVߠ h2b^[þ`7`[R?W  Ws  f  <_@_ F10=ROM Based Setup  Entering7 `. u  7 Qwt.7@ 9 Su)!`- W  ٿ7p 1A	A7 17qreQp &7tFò  Et
.>	t.Ut
(*!t h.PXhhtF12=Networkrvice BootWake On LANAttoemptto %  ἠh羳t8 0 9 r	 A 9u 91IP	t )ltsR QP. 9$<+( $M9O>BŁ" 9! dOs@C~	%4ؾ<^js ƈQE% VRyolNF 3؁?	uCFG?~N0{tG0h|ϒavshШZ^òP*+Notebook hard drive MultiB{ay"Dock!:b<#b (top)bottom)leftf	Flopp>k  USBGCD-!F HDis/SupserNIC$*
!123                         <=o P 	> 
\ z@
0>u.P -r  pqolectZDeb]  ͹U8 and _mo@=the _highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   >>(?$8P \?'?;S A;Zip.F`u h d0ô0.?stԎ?0< A V3؊' tA<v<st1>& 2آٍ@;2<Q#YAr	 hE P +G.>
*}> @>+jjj(PjߚR-  ? ~`>> z    ?a R 2
   t03>2 F8tFޣh $ ZҀbqqp URVQ`.,.L.T^Y^Z]S,.>*[ݡQSVW/ s&Q?.<.-00?00.0Yӯ_^[YQr> u h2B = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu}Ͱw`2҂ Xʱ@
>>>r
;w2pħ>JAơ}gFYô.*><{u2K  h>Ch푗 hch
66d hu<u`B_ J qWo rf.>eC%gf&G, @ f   PG0fƿ@G,`u
h)tG,f",f_f fP QW2_Yf= TKSt0 bo    ? o  J  b؁hŤ%p.
W
g&Fg&Fg&F"t7g&F0va 1 2H޾D׎~ذ:{ rsD	 _k  QRVDTQF r&e^ZYDffL (].LрY`VUfQWo
ِx
K&@
C' C$vC$0Grx  q## r]".0tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ!$&C"u#%$u!#,9ABM f.@FwPS [XAu,.6DF0hSuf.@FIDNU
 44NU`.DFSfVx%rT$^3&Ýf 3(u
vu ^ri q!} "пW3 hQs_` ,`,Ghw3&5icf_^`= vI OAI aP hF2$@<@X8TdVf'pBRyG f  uAGfP7QfGG !,rit
&GPfZfYfQ>Wht ffC@f>GFPtfB 2 PsGáGG   Sf3fa8t4ff% fPAa0 2f0j>%  ?  v$?`,[?f f ׋@f< t6fGf;uËLt;-f;DuL@``f`qif!}i1 ( P1
ffùd `f f {$`XG3AYg&@ Oސ W0ff	 ff?f3c!JEr  оjWfӒ |p"lRFbGmfX^fa`31yE2ɱ ! 0 `% 
U5P&6a#
Ȋ
0iMFvE0jF
\AkEk	A|AWAEfZ#PQWҴi 
  f_Y=SQRWh2"
r_ZyPfPRf f |= t5fx$ LZfX TC r99 r/ u t^ tw`XR1$tut.ZSWQR H@ Uf xȚŚU.@ /0  pq$Ɯ῟͟ P.ZY_[ P  P P (  ^:H%pLq   @    #  $߀@ @"@[  鑀 `@	`   	dp  c p?		A r ` B! 	va` bBD!R
`p QీCp EƲ  ;	f
Z`
Zl `   l 
fT
P1
5!
TP	/>A
 #aKC&C  : :0Z{     @    B33߾ 6@8PAX @O.:tc.D&&@ p p ɰɲp CL&> tuc ~rh^& 
f3C<thSt}  G2?}4 Q `t&Gq&'5d
F4Os\q32ɴ*f&ȩ u0
ffK|&t&fC0ɂ]ɏٙkpqAMD Engineering Sample qAthlon(tm) 64 Mobi!TwuriML-TSemprDyXP? FX-m- model unknown Pro    ffVW Ӏ t尋?Q  ^QtSQ`tH 	t=߾Q
t2 t'R"!t wR"te#tOR VQqR.c bnRf.Y^fRu f;uP
.fZ2 Nf0Ј`@06r_f^[0 rS
 33RAusj AX0[!
f&00+ SQVWϠJu3B_^ 	o!BKCVR3
t<^f~
w/v$T.@okd4p3ffwt@[^IVQWfv h. ҖF&=ʋF&?p &A &CP&{E&G0&I&K&M&O_Yf^$ ؀Ȁ= r&821 tf652 
NͰ fAĻСۿfW UȎ؎f   { r`\u'P hӋ"w h&h1X`a hu߮_haqf]@PRZQ V5 t%  sS fUW ffff>QWfGh0g&; 	  u7)f)@g&~/u! /u/u/u	g&ttx3	[rwnf!ǂ  uo	1/u/t ro!;^W5±:                                                               ee1UfU0m.LWPW?u h2CrW2rRrMPWtf0f 0R|b t#;r"t A;  PJR  ZR f]L2j qV0r*6^  R Z rG9	KuҀeAdB rC\A 3?Xyg&8E tPEG(V? 	U	gYm r	Y>UW	trԑl:kQkpbgf&^C]#PW rt r
  GCw_SRaPZt$ؤ$]W  _W}  sQp  a!`P
߰@S P  	ð D v Sذ8 3 e R	Ǥ!
R'
[//%QWjuptPX_Y
 d h-Cx1s y
m2  -<u4-uĀ RRa/R2020h<8< uZ#ȴ$ t	J 緹 U
	a8ڡVf  M #^ hYªh
àhs$T/h Ih j®uva { q PQW 0> 3_YX
X
h%`c=~E <E$h_s	=C 3Cð   ! $!f`favP`F XʀF(V`3ؾL &>&DE>&&D >u d j@ t}
 '}	 > 33S^[tS[:? 2[sDy3 t^h@ӽSs
Jh#Kaàh̈D
ϰ<D L
p
E$<u D
@Q-Csd
rSi& uS]@` uL
 6 6u  (X6є &uh
	\

u.0   mD&}?u
 t&Eb t

&E^D
&Ef߀w>Bt6j t.&t	&  t"& xu	\	PS   ? 0P'>_3& ?! W>	_[XB
t+# P xt  t  w\DPV!$!"桾tKh10Q&,@ &  ^X  hSC!r!L	vTt
v`WU$z/! $<v_R@a@z3  v
p
u$"<uP>ȷX\PRt`J:1th)W!&ă=0ZXr` 22ǿ&PCt5=tOu570: u	At!s96 u5 .o[s
{t!V&q s   a
׃/Y3 r5s{&=  V P;u 0< ^w  3f4G -@f_ ޠ }0 U!    -&egWʃO&MuO OqfGtM!t$Ot, t"wOGr ǾJM0oOg&D/` ހ2%
<t29hFx21_kרt O<uLDHD =_7_D D	 d
z=1:B]tSpprG&}	r??23P3t`hWa&EwS$`	&M&]AH`.'	@[%# r`S UϠRb ZW&= uAF:I)
h 
o m_XP
t G4" w! `_|nF7hrSh NpL aRC h aP uf3.f0QRff`Nu @  tD ߡ h5f#fh,Y6RW AS JV#Ȑ

`PS@U#[Xr3]rYT2
3

h
 PeS fу[v"\$ p6@að&fc
<Wu	fpev @`{h.o73۹ F
t):u%R3^D	& hI & 	 hB3G_a3 
3 9   Q~S'Du  ߰@#[J rGAo> r;fQ  .<wt*dJp&' t&wA+ 𼧹'r
r'W+ Qqu8s& 0RFtZPttpk h YQ78?r@[r4f@q(u% = tR`Y*I@_HS3+6 
HHE&1SE !, 0rTTϋh+ôpxfaVA @`$P<PtRUZDA1O:  ZGpZ^QWV 0  Ph߂X@_ 0V#i2(
y3p'2ƀƠʀ?!C@m?r@Dt㳰5,ϊu,u1 
@a

+&C323&@t  %
t&
0  5  "   ( D}
u&: 7/b!	"	? A%w {^jPRWqA&A &]&U
t ˀAi] _ZXr#3 -wf2C.U
/N#hu&_ '߸^  @*
    X ̀>u  'cU Yw `]CpWfS^Xf3fSu 3 Qύ>aY3:uBE&8Uu8p]
R +B&U
ZK~!ؾCpvZ6fYB)%qr ; ;!،	Q(0$
  5Ãh_Qf`8.
<to Z@mێûPV#
@F^fǐ  XaE_D
yC IAn Htv,vUf``؎ Fwr. ڎfafSfQf.{rf fff#fYf[2VftGf   ~nrIg@f;t&f l	F $f^`2ۈf`skkfaPP3_X.>p}r , . P	TACO F ) 
!	& .lr <Fnr fFf.{r  srF.rf.>{r;E.r@  tqrttYprrtNp  D@SIVfB.f$;VrT%WL B!Z\ܐ	i %Qf{2$fP'fffgf"'r.m p lr%f@cfPf.f³fHpsfXfdf3ۃ!u|+`s?I
s*"/S"Vf+f;wfff33RREwro4^q4'r44$.71p6ɐp08333Ҹ _ QW L% _F
3}5u'JE#ȩ t0 tߋ 110't
Ήt} tWM_ } ,   ؉F EF^V/ SV^PF uiQ` &t Y&_  
 < tr&\]p &\U  
&iN!d 
SR[u	F@&a#F^[_rF FY<Bp߀TV~'}pVW0ًذ' ! _^WfQSnG Zfat
  [fY_` t =$PnPu2M!t6 !s } tp( ` j &&E?SRU Qj@6Ŀ^]ZV` jxČq^XP
~*F
O  t# b  QplF ^PFq d3duh<Ku`<Uuùd `h}4d w& Xt   h}/B& h& PhE'`X!$!"   ¿s} /߰ehEr   tGt 4  hHs`w tKu& & ? 
 u` hs@<t<u}uв 
0u?밮1*`P	h. Xh͘ % PM 'D[%-ys%aPXOw$#  )0)tZ`($} f.`G  dj3 諹Dj@7 À   ; Z x     0N@`a#ehWr1fF3.|% r 
\3ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہó|.~r@V» ␂û< f ff @ffR@   f!NP
 ffFf3fvZfFsfBfްf@1 r9f3ɰ~`ǿjfqP  fafPVa3v޸rF3PX

S,0<	v	,$~.[W D`

Lb f s  fɐȀ
T
T0p s 	 
Sf_f q Ўfov￀U.Y, P:F q
uf^fNfV_f^pPR\p@*fVA6cFp2`hC@0Ϣ
0ff  fffffXphq p    `90 P9} 6 aI)P*hsP, %ofPRh2R ĺZP _$   ul]u9:G];6TsPB   ߀ P h1[PRf2MMS7h#ZPSS$КHpq$ q!
ʰu̀!A tv|tW
t<1w(<vYhV\P޲0jEh3%_ P&
0
3q 33Ҋ%_tW/g.&;u;@.ont)@)h2ztu ؀a`2G@t03@ @u  o[
u93Q^2,;8#tN 

P%,j@rX?0A?Qr X@YBSQ;}2P5(a&& &0hkc h#Huɰ h
t[ Ȱ t
ŀv#t̫,5-PXv8v&> 㟸`t`݀_P3 u $h$W
#RV2 s}.> uu22hSgu]ųuXP&
wL2 Q h2ƴu= Dt= tYԀ'
YYP.^Ze01?رP #G>U ð Pf^ y]  `rr	 V&afOLPH      @6P0;V(s
u^V- ^"(P*^  2{`}MqSP( 22< P*pX[údB  $@7R  Z`7              NtP(ц % $  rxfL+  ك%rSr$rF!f+Df+\ r*?Lr3w r@ .ІhJfa2І PR3O 0Z@AR `&Fd??uhP&Xh r.>҆.ӆpu? 	AQR.ӆh f3f%  fЎYURQSWF^
D= F\_ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF t蘾 若~u빠% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
50:_[YZ]`P 2&ߊX&0`PQ0^ kPߴY@vUkPkPR]]]/?              $`ރ6.u;v` Ql0 >h *Y`"QwLQ0f&YCC`K (  P3YaPSRP3@mn?[`H4$&%<GP֑  	 o t <BMtf3pTP2萂W X0 Hr
JRU3`fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	tŀ   
 f@3t# %t5ubfDqa $<@tS<tO`NBH$u>f=Pۿff+rCt Btq#Bt	]  f
ff60ryVZ r 1Y`W3( h52tt_rwh`D trr	_P}RW Z
xx ؎  P.BB <t BB2J &ݾ   8u!@屋`23Ұ
ShSt0`́ y aut0i at]U U[aSR  4hj
 h&ckZ[Õ`-1PԻ  h7-S	 h
 "B𑀵PaԀa$8uXRP<u6ZyQrtwvYu0ѹ }R0ߺwZh)U?2<U|vu{ hT\q u
3oҸ EF) ud^st"o 8a Pf.0 UfQfRfUfVf@Bh: rsNrF 1f. fwf_6f^fq7Yf.>0fGgffgf uYKU q u, P3	fgf CPpeIfAgaff.#f9ujpfY'M0    /tp ;+h 5L	U,  7Ne  hV+o  h" ={6త5Зg>T Zu	 TV3UtվyU9;au;6
pޝ
4fYi &g 9  f%,"꼕 [FfFB^faߡAhV p ^  '
^gq``3a`<   o DTDw R o 0 [h  1    l ( Pb @0 W HzL P`A T W X~b, `
`! p@pؾx o A
|\DQWhCB3 3_  0 PQ= `tq @YX :SPBu
& p  ff& X[ fa&    ir  ÒzAV|JuO fQ K@hV.P/ۀז 軙V <tPl~S tq.8ri."D.|u.:DtSI  wD:r5+zs&v
uAm
c1DQRfW3cX
f@ 2f%O03a` 3	  "	f`W΁ pf3fPa0fX A h lVZv  fb #&dD 	*ϻ ';sQSf  rq B
 t
2 fƃ0
40 w
 [ffY+vf`z q_L2_& uZ=PrUf   uCf*1If=`  t0  t( fzf
0"fh3 ;S
  "U1US$6п!Q2߳ f  t˽0 g&_fGfY#n~rC*@X'0
cffF &Ffg&{ t@sf @{f;~wt	u~qNтV&^|"aWfVfPXfXcr<w.Y0՞Л_ћcӑf{@&ːϿtg&TfV83g&Pf  `&fnu=жtsaNu(g&fVffo"Ȁ[f+)^f^u2u  w & PP0Xt'v t
t@W׻ % r/o h>uy hst-3&> nrqrRzsRƑuth<$uul	r` 	 +Zjj b6u|S`` FF phb ru
@ @kff  >t !$!֕$< uRCps 
N<W2<ăƁ_	䡿"3A'yr@h[u ĿTYP=Gt 
u2Ɋ،@3Ћt<u
E< tȵE$<u&w $tuRVˣL  N L ǻNfڰu ûН t W P[u
j ?jY!gQU(!!2(<!Qe$ h5u$0t-$?~AQ.#K,.t4&^ <r&w 3.\  5!.\e@.d b    W	x .|h5"_DuQ&~% t P藦Xӹ
 .:t
 ._
vXP%8Xr6%ȸf
6J3;LѲ    PJNL p      QKOMp @Kt  Jt P(.DGH h2|h  hvQ h҅ h~E Б?E^  ` f  Cp m& OE 
v? %&Mt&:
&;sr"`p$`t1TKub 
HM` `(q @" s*r#	cp&3a C 	H ]r5r`2gpjh!V˰vZ7aVRQSwhk4ThśuJ.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Ph.X<?tFhSUujjjj PR- &h޴X\ hMcY$vbwt = ;t= Dt
h)sp[@WVS$ћ$
5[? @n< u"*׿Oطh}Lt`-->J=Ot1 tSd_ rh  SX   0 hL  5[ ?  :N2Ჷ?Aq% p 	
   VFgbǋVW02_2µzt"@uG2 
u
2 ߾
r2E2&&&EA &e?
td&E&&E E &E<r&}	r@ VW^2й^2*
&}vPuh_VRPRQ3{f 
%*t+,Y0 ѽRZh$tuO	pp }Є> qQ@ɰ5rXYj-: t4I
*֮hC&&  t8ot' u a,& nq00r6$^$ Z& && ;`Z@ `dde`P`  X#֪U @
ڹ  .PB B把䇿8uG` A ; 5䋀/)@#BS 냑76VŜPX
 a@A@ B C    FtV$%Ȱ%蝊<;weċ X؊<wM3ɆQ#"XR<  YыƊȊĴ3Їу\E pY8@C$0	 FWYwuF5<uz`0Df&	2
pu8f߻h2ePӀk 'B@. ,".  V&k !< uf& bÊ$
r wAu%1uhh~Ӳ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh9ҭfMKff
fZhZf3f3ɹ f Zf0m f+fZ ! KLu*LآL3ہsV4C\` a^_^fZfYf[fv3h 5U=`2K ۟揀L0s< |&	3ytvou4PP 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .\3۸ 2wҹ*@GaaÍ6h$^VWaoǐz_^p[` h"eh  uP$<XI"sf @  t<   4 r	.A$<u
0 f3hh.@ 
d?]XiJ	h)0=  tdbw_3s.>@Nfm thtC	
A!U2 u@? o > `c 3Fd@ e f Fc~ce@7~e uQ@C9  hӳ|`5
P	Y3huBFe:Ffu1r,
 h
 _Fdt;   	:  <g htQh`!asf`7UPKh3~u>fB05SCA[t$ N hD&N r hPf0̾   Fo^P XSĻ  _y ,    hb-[t(t@tW,Vj Pj,>" '  thtZdúߋw."**ED/.EqEd]+Ë؀F/VU2NfQa dYF :uE]Àg33t
t
uP1t#u
tN`2t"FF0u3! :5tFFdz ulmb9p`F: uYeb +Πu"<6F1 ep0Fff`Fup  0j(j	R"	aURhT2  ɺ ٶ1 h- Z]oR+Zr@!  tCg˿RQ QK.YsY2{$
 _!u$0dU|Z f`3  3uW fI%.&D"^fD  Ch.
>C u8u.>?B 1fa
ZURtLUHh~2k:Yn Yp to(tq ;CPZiv@"go  squ4@VfRf恎h|0;^f[r]D8" [Zbh3Vr s 6Sj@ 2P s? rG{Z5'_UqWqW`.CuQ$<u:ߺ`pKr"&  t  ttB> tAt $uPq9T(
ː

 `XSQ 3u,S?蘱[rE	ˡ-ͿY[C& <ff<`00xx00`{||	>>.r tr~ (ЃrL]CX̀'?tCTG =`zQ<Q7WO &TZs6C  E 7ц߆ԆrB vzuN! D $/u 0/)0/Wf#-&A ;q5 F -7&/|0W aUfV3vCDPDQD 7@4f^]&o໠QP򁭼Ђ ҰwPduXd@I(ac@ `O` /////- "  @f%pdк0 FACSPJ DBwGP4BHP  0944 A!  8  APICZOK	6a	A
@  	  MCF#G<	P	     @   @  
 2! RSDT(  "	f`h\jhs&f  fhpfp  gfFgf  FPTR ff0WgFpfPf.pp^$f3.{.xf.tfN0~$f;+ hS
f3ffgf&f.>f(.ytx2W2@_~( N g&F	f P  rgfffff+f+.|
oaM.>pf,`
$$#DPXff-qAFV3g&fFg7Y[@ff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt@HбQr< uBONRUfQъ̓2 tPpx@rAr _v; tg&P)XfY8]VfWfV*f& fkP&ؐ@(#f"fP)6$ 4 
Ȱ ּ
ff	hSucp (fq t  hisfPWuCfX3 qdZ$c߸ g un+
h2< ;g&h&P_g  PSVxy { |4G$<u	@|^PR 	ZSSqSwuP=qP3h f&L f0=EpL fX `h" 03f&?    6u_    ?OG@f3ۦ{ p C   U!   >-&geE E puMPMGGfEtXAt$Ot3 t)O$fM
?rþQpmMePa|4BclU  r.@]hF2.D<gP6  ø_ gWYۊ!f
зhg5fef h52ttӿ th3뭿  Pӱio_DVގ@^`ңf`FF  oh7 }uPm h,6  $g(,0w4'8  
Ã9FtFfNDF߿> hDɀuh(fa`c~
Eq13ɊMhCt

h ;r#uacޥWF^P|cf fN0YN~90u 0tcH rfQPH_rf;^uf;Nt;~f!t)  |
tF~U;_E _@
t߿ 2pp> A MɋQű2۸?W
 PM^@`CZQQRWV ft
fq ^_XO0O@>wg1xGuVf gi0 tf%ffd@訧~ 4  taB| Q	Qߋf 9ΘlQV2	
g&GgP u	G_3^YS@8ߋB H. 6 f!kRWG_Z[SdG_T6:4/  vCI ELA GDA SXC TGA R VfS .o` f;.uf?[^f`r't'æ  (6r(R#6I$C$#c*t# #$##ڑ#i#ib#tS+ԱE)iw@j]g r r r
Y2Ko#to#e#j#WPR R f?F ZX_O%K%M%J%J%G%<F$ s s
G1Rз
G% t	t;H 2y{ 

 2t9 3
ZS0d2tS _1_fatAo"  F
3   t'0gfy Gh)~G$L<LDCOMPAQ PC Card Smart ReaderGEMPLUS GPR400?PSCR CLB REFLEX 20241? PCMCI9}Reflex v.2$c:r$HP
  a@!g&O@ Gd`P ߳ rLfK ser>G	 .D
A O@.d.D?4f_ PQW .
G.g&:uG Y.5 _0iQ8t<tBF 
fW
"
@
@B g"

2%Qf_t|`S蟈h)0Cu#{ | 0u0 .Au = Ў~1rp&tj  t_& rT  r&= us}6>
r/6r4.Aߎ؋V@< t ^`Jv 
w x y   h-3^h/~z nD
ZehCaa
qTrPqtI	fzE
u 
!tQ&׊pC{	GYSQRV
},`؍vfD   ,PffL s-<t(<#Ȁ06~ h.L}^ZY[U32t
t
u
5# t u9<0r<9w/tM> ~7SQ Y[t>"$,0>*SQLiE;f 	tus]sf`Pػ3Ҡ&&hq#ֿfv*`%h.gf95t0Xa` 2 @u  0 thcbR egf@ Vff3u"gfYc Ff azf? t
P!@޾S3۹: 8tCRP #hFRjt rXPhf ufXP  0 @? 0  u0     n'  ' D 
 Y/ bbk$Qrs@GY kvLҖ0PS_.rVW Uь׎Ǎ~Qr&} uRBr	W: v_^d>r5yr!r\E@&=u	#$Hr&E$7u5#0RYӆy
r&a)B DTtr&e`4o5`
T3
ËӠ/ӵ4S6r#itct  t$BaffL  	]J 	WQ
RΡ3q
]
1L0i+oWz Pӿr8u`_QY_ þqL[ r&UNL螳`
Pw4$X` $2LnB 0<tH^`8u6
uBp & DBlT
߀aP `3 r/) r%BBn!J@ 
; 05 aù<t

B Jw 2o@u8` BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri ~ racñ  tAc rF n r:i r5&D@u-&a$vQ> Yr	2Qd'YB@Aq Brm蹐2Á^	pb3u   @^ `ңPX H  	 
 
 # F 
r
KB B`{ @P OF
@@ 
@ B
@
 @ ^B	 
@@UD
A
I
@
@ 
/ G  @@B
L 
@ @I 

" 
#C  B$EA
@#@(H S ^$v2u)w"g&~ޑ t	"{u 
RCMO
 N150X3-L07@LGPhilipsLCD
LP08-A3

AUHBAG01V2QUANTADISPLAYQD15XL061E06K1SAMSUNGcLTAPG@1
TMD141ECJE N41XB2
              !Ȏ06ӳr[>@e  >RY w 637BPa 8u!!u
( H 8ut	3ҋʸFPW
 
t_   @ك
_X    q    SETU ˸ @؎&м  i r' W@ P& u_SV  GG0G huߚ#    Gu Fu t3  hC) 
h jBt & ^[SO
&hV" [U샿VWƿF F@    헚` F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @,<qt	dR>t <tjjjj3PR- .w j5$<t.<@t$t = ;t= DP6 h)  揿  7FF~ t#^F&Lr
F FQ  ~ wt: ] f
 h`0\2%PFA~ t
F_^Q
h&8ss.&udu0   hc,$?ػ h*"hk #h>*f_01FhB%..  @  Y(`p3WVe1E0E.WV .^_U9P)UIQS6(6*`e1E0eEE.U s@ m2a hF4$ex57;$!<$:a3qr  utw
t1w
tQCPSQW33۹ G&._/N_Y[X   sc1@ @ p^ B     6]xsqUmf* %  < ! 1C  3	   jQVWAu% p u 6W  = <tKPS"eTh#U{\$"8u! [XAB.o`._^YRW W  Ê [Crr3ɺ ڑ܋_AB rN _Z S\5OO{O
p]^TujvzOQPSJA DE<@ ;w<<!<3Xu RRځSt
vSm[VfPfSfQssf3f3sPssXfffDDG(	Dh fYf[fX^y#j OgO Gx!tQRG3ۊÅ? 0x CΡҋ|B`sfDf3ۋfç\` 	
C  A	T U S V i	}				`hA	 |hI	  hi	 h}	 h	 h	 h	 a!|v.L.< t)F.63.PF.h8a[+V..^̋] pDF. P .?h/7Xhu ؃:R  16W  0"Xa Y Z #[  o
\a a _BA]a f g'^va b ` `hcij!k qp10G pppQWĀ>@t		 u		.ߊ	_7   O 4a9@Xһ -w C.%/T2@0m?n8o7\3۸ U _d߸^d>QRr_PS[XhM(! lЍыh
3     s     KBC  [m( Vn   Q LGB=   0{+&!	!$12/15/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;O   03/30/05E%11/13  kTaoSs  {-1|5?|6|.TU"x#T[T0	ϣT@ 
t/{3" 6xgv$ÔdPx>0@Z"2""Pf"x xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`@pcłŃ 瀾xD¯01u+ү0dB01"xt}ി
~0"x_vvuu˰!x!Du(u)u*) + 5EFuu!Zjүx00Pl}Dxg``
$`$p
_p 
x b
x2x txDE0SxxxxiD@Н.}p~}@ w p :̐}d`xGbBE&x}D
¯00xtxtyuu 	*}nb}uus U}|c-,"(xmD0p1 x^Dx_T_xcDxfTү p# + ._U["
,&;0pA1pI	 Tx" 2

xz@4T00w0}!T_ _,P %u|`"0	8T`#P9 ~*m080pi	!P	;GA	¯+u+$`@4?jA~T+}'G+p Y(++Ô@=^,+rG
 H
0%1v 8",`^ 00{}k.@ %/2'" л"+;x&x+x_`t ;":}
P  !	  @}A}
x xt"xf}BՐw}E"* 10}=
pZ#:<0 0x )xk`xl  p 0S+;0/TB+x+ ¯0+60 b 9^P4.C+ 20B+`xN	+ xT_x !
+:=DTBK PF@ y+P>

 C[Tdp+$!$P+-` 8P` ð2@VD0¯xx7x8r x008`:%o	0: QATH`	p4U	m"C@\ZRZh00b0+xGDo@P	_'pUү3HӔ@\F7"[[t# O[x,Xxtx0x,BSQG0xT?Tx*\-tx+\ZATxIY]3P^^0PPɿP*	an`nux}_FNF0=o   >yY>egxfOpa	B>;Z~3hnS@*ATx-	+_UTNx*UMx+` ֑N `T0 
seS`
 TURR1Y 0X Th G]X#YxZAYAZNSZ3Y`}Z$0[lp^q\1\T P\1PM
[\]p0c1^^TT^t
r]	^S2A}@ A}=@ A $.354A~Q B~S  9A~R uuҌВ""7x'Ʊ8
0\ p07d`!7@k33TT?O`C  17`'`2`=`HpQx_w 6uuuu`o uu0 uu5ˏO$ƨpN`0T`
03200pAA"| }(x_ߦ@"+,,E+p
0  +D,,+ +,+x,+0֐p|!,,,++xa,,"-.T0@M721t
Mt&@Jpd `1gY11Q_txU!Ҍ(0響/0mp/l`
/0d@T}E2A@.-/0|" *xe"+xt`
o3x70x8W7t`l"[C[Z#Zc2d"xepB[`]p^x,H 9  G  < .0F1/5 , =Q@!"    V q -; x U:   yP sW# $ )z  p 28 3 
{>a\dfUP	`[_
eVQ4c7j6h&b%](i'g+lX;oZ|?~|2Kd		

!$(+.2   & % . 6 = > F E N U j f 
   
- , 5 < C D M T [ ] X   # + 4 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >g d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~@   2 Y	J @ |x @ s   ww ~~ r  e"G9x4D  T0` D)dZ}D0x2tx1tI.([0( (xsvv (xs[E Xxu%& ' ' $2x1 	ү  ¿0 _&$@Kտ3%b0$	Mx3E
r eJ"xtF`0W@ p%" (	x30&^0'<T`P%"xubfp
0$&""tY.4} 
xu$3z 
`Hp`p$X$ yupxqv"x0	wD0߂$$6@TxyD"04hxox@ oDT 0
 cB"pxw1xxx"xwxxxxx	"xzm#xyP{P2yyxzf`Ӏp>xz( QPvRB@
"00#+00Hu0Q Qu0H0# 0(
*1HQd!~/=  B~0#HwD =1w6/w(!a0#0
	0S0#dH@"01¯p9x1"p|u T""3453/:NP"3554!_Q0		"0#xqo`xcT`q}$xpq柵v`,r"3}TOp0@0 0 
,P:aH /[P'2qBP``Ӏ) a";<e "0a T?2u$40<S0#{z}yI237=
un= <+
`=;0=;0;@o2$h'0Ô@^p4)
H

С$IY
0

@À{0-$`
$`$p!Ȁa"`V4#K0# :0!_@?À-0
    s	2<0#
2xqfKr0*2d|p0<SH{zyH xrvJ%_`gK<P2 _( 	S4 Ƣ· "UH	5345q3`	t%5544wߢr
@ :0
h0"0<`	Q2A0<< LKN~r@1@^ 
 "o
 ,90 B <, 
j	Ӎ" #!`BQ
p0( <!^ 
-еNU
]DU 
<.
j'	20#G+6,W,Zf-e2pO7)0	LP85p
b3s&0^5g	6n	0 p":"08c8;rfpO:2j`#/nc)P3
UvCxp`qe`?0}Dp h,(g,#a,a b}j"4x[MNOpxD Ue4_`^}W Vp0
T4d`#?"4#Jp~}j4xӿd@3 0
3 #`3`3$`e$`1$p$$`9$`$`)3$pvATY nq2c1[0TxvF^>&`!	0,0)g$Ф@Dx Z30a 3]PA6P 	@Rp?;%¯3`Ҁ` pTV`xm  N* .xv
xD}T%0{^`
}nT?Dt`PuY*T|oTq"@`T`R	067``$p``1e7`tg7r((	sb)( u'B0+a a
Td`x0dp#  xF 0TP
 *xWFt uoxBBxNN|z}wxJqJpr:;<t7/a?=*x ү!:%$t=t=;2*0 *=o$Px`vT"` 2'<x"ү3yՎ:; 0* ;:@ p0 xϏv6xV86}'Gp p 7  %76'ʏ7  ""88Ô@3 p/p0(%  /..d`
&;~r7?(oTP5?O( 4" 4040@O453``/`@$p}N54:I&du*);P [x 
33oppG,L1ހ>gp1 !'g;P"oT~ -P2[?T#>үd`pxHo 8@22P65b3e1@dox>1h/ 
m
`+ӯ0xA%30 B1
@
 <`00
TDT@5q0	 3:=@a_k AP}St
 u2P2bt_l@
p.
@	  r1l0dpe`30QDxFW105@2U`e bC7xnu30 0u3}r2+ (ߣtw1123#.1}p<0{ $32  a<0 }
1pAR ErspMk"p  d-u+x0,u`2:,]4 2UU.V5%-,*\ 2732pha,
$+ԀO!% *R5 
Q'x`S+0	+_ -R	++@@^@`p7v@}	 `@~A0y!T``!&_` VWyG
7pDxp.LDy?N%@k53Eop;OCD߯-qXTQQu:93: !p	S3_1JB3dUA`hy%%Ovt0:QON@pHR/ N9
d.0
`/X6Fp0X-64F<0570`5#O˭0]c6e`	S8@1
!b-1|I%P/L;u1
p< u1a1[P,C{p4Iz5z5
3z,-	yuv {| A- 90!& n`AT0 -	al9pd01o40!upo6o,/-.rpFB}}?0
P?/.-rdct7%,f Wu tq70YS 8S;"Wΰ4`p15BŐ}BT_0=_<I?`$:<p:T0Oܑ78e`pYלBxiT)Ax`%dcz0  87`>P$3q"W¥A3U	``uqq
r	1Q`{0
}
9ȷrdP9$$P6"{ 2F/}&e'AChS4Iqo}aw  X@apR`pLxp N3p?u]1ԒU^#5_`@TU`#v@|T kx{}Qxzp Wxy UxxPVxwRxv0Hxuxoxtxcxs`xrxqxxpx`x|Qx{`WxzUxy@VxxRxw Hxvxooxup&xtPxsxrxxqxxp"pxmv00,pTxiLү4j" /4m0/TxiQi/_,p0;P /^##----*i C2[?;",u/212B0T-21Կ^ L-_. 'q,Đ/$7E,T{AO-q.`۷pG)QNm.E.NJP7E0p0Y))y0h
P5
P$s|?`d7]}TPn,rtpa4N:0!`a32[Е
p1
P

Q "u- 09r"l  O}tn1vg8, : A3.02z.pM=1s0D@dT:0u`z^P;DS,c,u.B.` +2 p0Ⱦ`u.Ta1lC
.%TOлQN]03p	 `` 9<b n $ 9)NӔ@6S ? x?0!  x5"0Qq7prrq?xvWU	(Xu

		0
  `>
7HP"q z
G!/opT+rAL`]>M)60.T`@}w}S?AP33oTBDWD  Axmw6"It}C9xVgxFds`T`mHT
PM>@C!3"x+ "W\]@0Qqڢ97|F 03t/Lv`
pWr +J)) )BP_P`k qw0P `	qPa"PQ.egB"TQEP Є1nf`<ˠ<A<aY?po0:BP e0v!JI$Y:1PJ1,F;KFF	D0c
^"CO`@"JKOv30aA!Kdpe`w@0tt A2bKBL``LKxqvJK;"xFGxGHxEIxFt@0* HT.`xHH0xI@Ft"*"H> 0 I<"xB!C!A!B/)B*( #NA
OA
MRA
N/I
N+)UD
JaKaIaJ/iJK
I
|cLMNOd`NPJKT&`7 v0uM M@ 
ONtS QPJML}n}u}}|EAMI#..C_ @"#;  #xh· ;#"VxDҭTp𾯿VAp ?$0,H;D}@qTTJE}Sp*WA@@@@@@@@@@@}@d@K@2@*@  ABQ[JJ" kddr! t"xdq o o"BpD )6	KS#q! * 	A] _>qX`S [Xo$`RAb $BWo@Wö1OǯW0	xqZÀӒ"}vW`#`5`2$pCx<D4SS [CxcWWT$xpsƛ& NYq 
xl0x GÔ@π<PTxlC!Ӕ@_`B<zr
T"  PtlxhxrPcv+xpv2P8Put}tt  }I""YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATUBRBAC@ D*F?}EYb }$zE0W`Wd`)kuWRBD8DDDPD[DDDDDDDDEEEE4 BERB>D% 0rtSpA$9 pC¿"-AE
mPT Agޗ@$L0M7 Q&;T E7r@UxZF!R
hra2p>@X P`A@8aO0Dz=Dd
`#pw`(`0{<`PdP`d`W׏W0>NSq֐ʍt= td	RxtxPxXx\x]txat"xbt2xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtxt#x> x=tp x@t	p0xT{
}'xt&"Ttx!TTTD	x?D@:xTT@=TT}	Tx= q
@TxGDp?ڻ=DDTxmv0_}Ht V eR@eWeUeQ }T:"x0xI"xj/Ls"B S?/?@>"a$t!>$-"T0`Ô
P~0~7%WW@eVV7%VV{ z yV H< HC+HK3HS4H[6Hc7Hk8Hv9H:H;H<  HVIY1	 Q
 I`A 91~5GWV& 8 `;cuVuVK0V"$`($`*`- x/arp4P
TQB V HqRb V U"WQV$```$$`(`7`F$cpH[	A^@
:3
2! *}0P6 `#'Ӣ0A``,`003`G`[$ap]Vp^"V   dpF^	0$s !`!DTwwq0!$ V0 W "S}$pT_lPLSd`PESxjSÔ PSGHq@P
pKPxjvp@JJJJJĤJߥKKK K;KCKTK\KcKpKKKKKKKKKKLL9LJLOLTLYLdL  L0
`2v"x[MNO`uTTTsx}j  xs  "$"0TZ
OT:p; r@x"} H?Gb}U0"uU@	0SUTU0CU0z 0P 0@4xctjvaQP0mxTxmD0FxǐHxvbx"x@$xx"x`}K}IFU	
Q@PM~0""3GxV| } ~ _I͐4ߏS_o*N QTT &NL((sLMNN&N1N7NBM"M*M:M MMNKN_NjNouN.?AÔ`P/."T? } >00xe`"SfUS1vJ0pV	`Ь50T:uSۀ0́  00)	0PU":Cm$p
:!/0Sp,"xdP P0~A3g"~}j s0A>T3dAP>2IW1bb~!0M}EA@JWC`X" .YpNZ SF mT0dɑP O0#0xD TxPk_ !1?xxkv  T AApB11u32}'G  $31T3322@"O]0  "'uW "   p}"/*O0/Ô/pC0S00O2[00 !"
xp0 "x ɰ2345%@"(t?3t 2'x325R4U5B UcxQxQDQx␖Q  09:x0S_vnS 
CSPCQ#QbQQ4 RSS-SMSTSaS:x
/0Qx
t/P
0/_x
  x
Q{PCx
! &	:0%t %T 'Qxv	}YBxu0xußP2P0{ p%@$Y$ÞPxxu{a 	^1^,-u. <T!+ү$`&0p<P(+} % Bx.-,:	'xxvӔ@vP$(xuvyuxvP9!  &0 =	r:
pxv :t`x,
0 !V @	 -xx
xb "x	6:S/^P*C"p ?:0:Pe@S SSSSST<T	T
  U{xiD1ܤ D@@"xDcV`$P``3@TOBX X  -D"p{9TSi?`/AE@E ,@@CEuUn Op@ | 33TOB β@0"<à`p}T `8 .5,,~F4S,  S,`xgvS, ?[S,,"+,/0.VbĐV?x	` }xNJV?u0 u1Txh`-30(Ӕ
P!23	D3E2`NXSS0S3u2 u42U03U1Np1%1030444P-5xp7x	410	^_
55.Ӕ@xA 2w X?:0c
`/p00Ӕ@10.	`	pVVW
WW;WWWWWWWX
XX=$XW%Xc&Xl+Xz,X- ? X.:S	Xxu/}@xPFǞPa_-.a_P
.-]	
x3t?e.pt e)-0`p	pQp"	`@YxP@}}t*
/!  2#t_.Qgv   qW} pQ t u vA߀O}	}5R)L 1Q!qm^"2s0 ,腿+"_r |ZQ XXY YYYYY4	Y;YBYIYPYZYdYqYxYYZ%3Z64ZA  Z<\WZA ]s  S1
t?t)%}#	
,pbu&4 -DppTS<WT0BS_
:8^ qе'L@P4p^P  h``!!M00t(1Dbj`QrOk##Q
n xRp
*S`DT,T
`NpD_"gD E-g`/d	`+d
`&t .Ս`]`@"À--[.t %-ee.`.:--Ô@}H[Zs[`to.`K@`/U.`"U/`##,/@cÔ@e%O
	"x
xxt "-$qqT"xQ "500}r 5 "242b   _t" \"`2\w\\\}\<S\U\Y\5b\[l\Kv\i|   hpa"xn@00V"00	B162(a U "	0k33%$a_^pe2pL2640#0'4$n
4aorqv"Ô
@"4[x!4$`'$`:`C`L`U$`]`n$W\][P 00f_QR"02. 0	q^v34A!`g4p-&}
D"""""$``,`I$pe	#a2]!Y	0#x{t0B	1u&P=^"x%0T~t@"Ô@Pu@@	TP0"` OPx~? d "πА}t0	Ap hx0x!TT`DEƠ0
pT!D`!T1 3`xD>a"  ScvL	\
l|b
E=>C	D
WX~x`!GP ^`_b"
%{ F`7@0x+ +b x}qan+s+!F `C00+xT : } 2.u_ DT_`6^ i}TT`} /0	:1 aJS 
0cx	+$```9`B$paJxv pz q DxT"ҎxStTTH_ď+xS+<x, :,?`$p#+pxS0x+	x~0:00!A

0_ " .h@-ӔwPq @
aiP/-$``C$dp<00UC.P}.H, @O`XDn'TpYP#P-p}} cY C.e. 		PbB	@ w	$~`E$`M`QP`_$ep`}.0.>ӥ".Ԥ dpI0ӀÒ0p樀yq xn..TpO"xh."-.{{ oj;" 0$N"x8"A 	ӛP	Ox` ÞpϹd` NÝ@ӛ@*ÝP?@Au t/|tƖ"/014u5u<$t}5}/wd<dtdǅddee&e&eIeIeeeeeϖeefffffgggggѥgѦgghhh:h:h]h]hhhhiii'i'iDiDi[i[i~i~iiiiiiii  j~P0~%~ p0p& pC3/}u? u@ uA3{bߏ4j2T3 P66~ 6` P_R3`075u3@u?u@}uA{xu{{X$:?@A{&5hg0 v Ͷh)g

-K>,@1E` 
} P0C3+R#~ 0`| }` @^_N#`T##(
"&

5TP)*|)Np<IdG @(
c# 111{!7(+(/**81,/,h3/1/5H13G1tO/|@T12R
BA$__TWB1 u2d I'8B=9='8FGXCWCIˈEE̪L͸GGUUo`VII#M0V6P!}VbhQW/"qV`πu3/˭/\Cq/4"$y`y !SЧP n @@ "BC~L`{jPk$@kq`T}G'C`$$xvB}}Y} Zz  [xsDDxvPDQЮ 0&70%@"Cp
 p"k'@COr+ 	 	Z		[ 
 
\
DxvW		  "<=>x>T?@Q
3=TaKՎ@A`od lJPA@IIPw0?pP =jj } P' =@
ఐ| $ ><=˩>i0
kd FEp6Q"}`~N }`pkQ Glc#@@b! sې}P@ MTTn Yt
佣#Dp1Prf+s/++/
~NСW2!_$QIvPTl@& p0tmVp 
82o^mmH"28Pnu2xg:0:
 1ȇM_(:1'Qk0e}pp
T?T`8"8" u2<0n0`=~~^z@0kTODՄ001p322]* u1AD00 	3PYP0<pPQu2߆PD2B32ӷpw0<7P0e`&RP@P
}`"aR3"0upT_O"1
0;j0% 0pj077@,e0`01?2_Vbepj0oఊ1!oB10~}  c`Kg9 	1D7cA&K@T3`02`;:+"45675E4`546P}
(4`i77$To`MӐ4`TM=`` `'p->T.0r D D1 
i0$@i@Dyf0r$ BkZ	*u1au0)'2Su0p
1}}]34VxPӝp2u2u0*> ?$3@P20h' ac@'
L`1`2^qUEl;8006`BTTT%%ONڡ>xEp0>3`D
` 
p	0d`60a1\Q]NT?`<@7!?$p*#3tT9)	 #c H+@01	a=2`fO"Qc"Mc#N$'N&tn޾$	??ꨈ
o)$	*6
??u)Vtx
dd7eU"}{zyOWj7udj12u08.<t5`u/'P~ s./ds5%t#\vh~@_[tQrt0ppT0qN`۔L=2ot[	ÔPt} l q䑘o``z4589@#o#43;3  yv((svwawwwwxyzyz3{|q}}\}~B~c~~~~	{ z y4k|		5P4F @w
R$i_SU |StAY1
	3D#-t~5{Pu4`u5 	]4T`pod`@Ԁ	Qu?
p0
PHFv	ֲ	uLpm[|| ax[}} pmdkjj jPKE ß
Np&d00z@(
r67d6`N67"PnRKdB0,@e5p4l`&JT!:*:BEU2|} A`z {E` @\]L׆_vSv:;;;::';p#!#fk:;#
							@4uq0F s	Dt[;:(d`픜aPD-0c0* 
E0ЌP
jZk<ÐI
IP`S~dLpt^#aM`M8@UD_q;?mpl`*T@
`r/@A;dNpt/,V+ō/XPYP;[Z%Np7>	bUEodQp?pNWWri/'P#^/i 4֞(?Qdn&pRfq6r<JFt=Vv)>fx?TUMr iTE},KDT-`M09820	3,78k3 ;v投38ofW?<6f{z'y x 45A:pP5S8Ô8@? 33?P03H948055(@5x {c
`44kÔ`40<q 305=Cf
`@$}3)u?@A{b&00v"2;ՠ}3$`A`ypc $ S~ 2ɰSwu3A #ux_;p{vdERu3t8u@`Z4!@gu3qQjPt;p9PTT Np: V!@p)};4u3tuq$e3`3΢;11`08Dq PKqޠK01  ƀՠe03C1$1Ap胟1pS2򠯞}t`T6"u0X03}RY%}>~
NW0:>F2pPu2f	op`8
0ya
``Fӕ1)100! xgT`0?$31dtP6"u}{`q 
@"""`{tt P
7U06	~MTD"LION x9p̻P
 Du{T"}:@a"رu~ daPÀӲ  0d"0Ӏñ 78`@
D# #	"
~,Tu g8PY@p 61"a,"`"x0 п?9"9q?"px 
Wqes>>~ 0 on`dx"7@8u8X`g,7bP| @`  Pnp=	84zgk8$bu$"zI;u<98~S98lpe;g~9E8 `v@@~+P"~
`<0&x33 d ::Ӕ@@u:o@@?x#,À	 ,Y=x@-:zQ W<p m;B
8 91@]=<>?Ku@`"H P/A(p??p>?
>@+@99@@	x&Tp/"%T~ O 8&0@"`""x!To`	?TTp57#3o`12D"E
xEpx6>A4ra/T(--,r e,p,Ы,~Re,`,,|211H3>dx$-t"u;2A&8<9@Ju;;;`P9:9@m,-x>F^PZ pxT}r-- ,P,P	txG F~QFD!I!GTs56MF66 5ґ5
ycNIu"¯DP(wDV*x Y
-
@o^"T 6VFGA,^xtP# &T0xT1![4TDx!>D@np
0g1dpa2u3b33`22320@ނ
4r ]4 t|wU0/%%q
_O` h00OTi0lQ[		T`j~Q_` B$#Aѓx"r%"	F	 >o	@2xpd'@X LҀƀԀiu3ꀚڀʀ3䓣łŃ 
`	"3/$ ̈$ P ##EN``#sB"P""):"P%0 "b``"  )"u/33@p " 3@P"Ø"(p p_8

r
		
tQ
tX
	


 *72@	1	"yt 
""̋ߤ,a u  ͨ-8%`,5P`.9<-5 "BBE"""ЃЂP  ts6 s)_Ń!' w"%$5`bp p
s@h`_6p6H 6@~6v6@n6 b6VT6J6e16Y16 p5p55p555#w?sp.u .33ł3ł傘@@-"  Y -xs3 133@"3@"u	3@
6"0Û0ߒ 0
ß"                                                                                                                                                                                                                   /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)  x  H   P DSDTDSDTt  cHP  SB400   MSFT[\._PR_C000  \ 12
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 72ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD13phg	gi
 0	4kg 5 phpi p
 fp
`'fg`f b~ 5f cufbc``67E
Microsoft Windows ?ME: Millennium Editions NT C8F
p\_OS_`pga.ag)`B7
bra
!ua
 n6
 s %[I` 
u	2 p
pQ S-B8A _INI 8H A
fpig
f
 pi` g hrgfata
apa`r
ahha `a u
 bbi@ ibub`\[K
(B_HIDAJ	_CRSR C)
&	`++
)  p,, }p- y 
 ,F C0710t511 2C3py4
13t#13C5 15% 6 7  8 ]r @}A"6([	B   
,[B11CD6[
^ EF	8
[A
 20@21Q 2 3 4A5426 27H28
A@[I29!A"2B'8 CD(2EQ F`
30V)31Q 2 3 4 35A36 37`<38Y 39AaUBCDQEoF0 @0440041Q 2 3 4w M`,46
F!`
p,35a}aiapa ib{ab[7e'
_ADRGQW

[u8S[
9 4A
A0:4B C

[&4C  D 0E B/N4F?C	0 ? ? ? ? ? ? ? < A'50 [#p 1KpM52H`p` p`bE3Fe@^e` ap dpyt4cCdc
{M<bjEd[5652JbbtWd
q4ruD2dcrd~^4F` dzRa0fR ޠefuff }a0Tdu`['AGNq
@d\/P4756pQA578pO
o6i59L

 !puuGvp#
P!MwM  ` H l2?y '$53
4 [ e51 q75Bpibpkdrd
?edA
d hb brb

bhUbP C  DE3j1CjS4 DS5Dcrcl5EBbNp%Fv%wr!ar r59a%bebecPe
e
bueatob
bP c fya(
`bac ˋ`6(60# [Keb59
Ў5C  5E4c-Dr61@Eaasy`Eΰr62	063
jPiy ߠAru
i63x65p\/'4Ba{aЉw563bpb1f/p6{4D`5 aP   aa F61{aF@K`r6_S3D
p 4D
W[Fq75ML67
@
[q7  @ u6`69A D6B  @`{6C q DE? 
2m  F70[eLF 71q234aj757c78c7jc7c7c7DBpm7P` ,p80Q 1}7 80 H	 P82w83U
 @85Q
!PG85P @y86 @p87 O l89u8l8l8l8l8l89j9993 `g94 L	5 @9yHv9s99}9~9A
rX 0s9C    @xbIz895Q9u9F7F`A0PC71s qUQS4(qBCt 1}A%6BA]O@A2qAA1
[) AaASAQAAAA[#\_GL_bp
`+A4`bp.[!
dv`J`A7A8{mhdpjp
3A Hr"p"a0_A9bd[@Up	rya
c}cb6[Qp3+AC#A5D3Z@AESt7AF
DAB0B1 B2 (B3B4 (8` 5@`W6x0 "7p+8"Whi 0Ӡ`y
jbvby_bw`j EJ[B9Ghqq
3סE0E `Be8
i`zHB1@ZB153u5jЀa2 hB2KAK}7Ip6i
q0L¢"	/Y-!	B128	[LM$ SB@
[BQC1BBqPCICOCOCڡOCOC5 C6C7s 8 9 !CpW BCCD#EACF
<'KPD0
i `{ 7`g8d9``CFtb  Ccwc

ccpD1	
pI6'}G`	D2pcK{jP#w`BCDt	ED1D1vD1J
2
1
4t3`a{  
 "|ccp@ t
3

PD4k	zyEap&& r}  @ADo5
lD6 q7 8p
	 a{k
D3Hjm@zD6
x7@ a>J
"a$RR4a	`0Ga2  кC6B_E!7D.8C0}
`eeLfD9)DA "!drwpA i?cL
{k"DChifq
f
j
B
 ``C'G6Z;41I3 p`1` ?`}
@`bz4aIBp4Cv4DdE@
pwcB& ct p
!c}
 p&<cADQ1K"84? Gr-ic}0CAyaca Fb[sGD$k  PQE-#k yQ?F E0 1b2 E3uSD4㩕6TO`EtM`/$$TP }8
	q
E9	a	AR#  y  Eєap!J`Ӡ v`ECpEDŠ)
L?)	a OEE	0Fq Ry`	A`v[hF HIDA_UID
`_STA D^^.#71_DISQY_SwRSEEh	
9HD` K	aOA2OQO OĄ&bO3OQOO$-cO4OQOOP2hOAOQOOD$K$iOA$B OQOOބ+?+jO+COO@O2pE2kO2DOQOOB798588i6 E99Eu2[p?F9 FA
r B
 @FC [#PAv4u[CF9<jADva"_87A&B,C048K4FEP[F,Ё C100 101
L 2 :_REG38!`a~AuFEA0FE_S/3D
p 4p g103({@4
 h|q3B V AJaT	5cCCPP106
 3yDXP }`h@{`h}~3Di@r @3A$ q\._SB_07t
p._DOS39
 a!o[^P8bb h 7@9" ?
_DCQW 
 G 5 S[ShAArR&# B&* %$
 
h`"DPs	8hfp
` {\/04316}`p `D0D   Q   P \7\/gF8TC pCD|D(sAA)E
z `^h`j	 Ahijsv10F*`& "10
^/
kl ~AE[DP7u	_GPE
	I
J F
Gb bPGf fy B112n`B113B111#`5A6

717189`
@	A/9(pip{P08
 a	iaq>1BP.[A  @@  P1C  11Dp # E	F(20Q 1 2 345!26 728#2 H1_2A Bs mCcD2E}F30 p U1 23a4136Q789R33B3CD  Es F@+4044243 `p1446 7 qS14A*B1C1D
+4F5 Q52 +53_INI >54 p !56[   IP7 @@O5o8:@9	@axa
db`tЀJP
a
`
@}a
y``}`at@#5Aya aw`
d`xr`
@bauaa"B@k*k@b&q`jX+2C	<h\3D
!Es F
E60
q 1/62 064
1@Pa26627
Unknown 
NiMH 
LiIon Na68V
66@v>qFa4 F!66q
y2
J60
a
qDpg177B60p61C`b61@N`>1}}Fa{a
4/5F}Q>5D!
 C
XQ1!E!yED169	PQ A:2Q6A	~nGp
 D{`"y I=6B
[)h`pF2`
csc
  dzir`a[)absdb1/2b*(|ccC"C	phg3
 h6Ag
bhU)D)6]6{`g`}P6&D'EhQ,YC *27 Bj;aFh 1 12E w"4axra
c 
dcbpbmbV655r	40`fa 1a$(`ap->Dg5D$IC170
I+Ep/
 @|W ~	ip
q:R!>E93"31c 3c35 cC\!j{Ѕ`={``IFAD;  9RL2ccdp eeez
cpecpcDiE%4?w up
l64p
IB5`p
`Q64oD29C-2T@+nq~N)а25Q-  T(
!z>7
>!2A  P2vpzat
 5[u%*!B((BB3 F`*qxe(aDh4C4	,Fata
ai
bzch!
C	`

"#2aa 3C
@ ra 9PQ paupaHTf:bcEh)UCCC>UFFB-E6вb/U77188 [
P73rA
HP   aA
Sp
SIMPLO0~SMp
MOTOROLA }a`w0D474
p
 ش 
|Aj(_Q03':Q{Bb񪰪B4u17b
dp
a46
b:aQ05 [TZ 75a 6['cTZ+3_K6pn_
;nQ7`!PR0y0 1_
2 N8Ur#bP
\@8
_9# 9	 mO1G49ï_8316

,A
{  (i288i
ȁ`[Kذ c
Q7BG
ND Ck7D@F7C @p77 C180r 1 2 F`3 !8Ѳ86b888 988B8C
[k  A8DqEF@909192"9j0pu9,91Ua 50~A
q91M96Qa `Aa` !84`+
50;l 095Oe9798  oA !c7b~a6c3g9bl5aA
8BBc1{98uya
 d
b
 `bdpdSpc
 c
@c
598BХ99094`kaʕa
v? albab`b
vbub@8387pA86'9q`!9#!ad5Wzj
aA8^`T95=pA#'2qb`}b	a  bbj9R
47Ee010`0Rc9C37E6"84" ^
qD
{C02C
`{  ia` `P96hp!
`!qK1E	[C6hA7ҁ0$b c  d}ydhccR10acbcA(K9F p^^C1A0cIUA1L
 A2

Gy L1A4 pAC970  AqAAbAA2P@[BpA6G_C  _DDN
COM<A7A86
30U"    8oy aS pA8>_ST#O1{\/R_047C000 A7QD
 /@+_DIS h02BA7
F?_SRS`W;h
a971A9rBn)A7@
_C@wC

 ` c
`
Pp$OA[TAA   
DB
?_ON_P 

&_OFF 0Fq PR0A[wC:*Baj ACpj/`  +D
."5AZ@xsD!eAE&H
1 Gxx/ x" *
 x' x)  +o r^r_ @_u\00J.E.G%.Q.Pa.Ee.qNm.PAF`/8./ B0Pسl/3!BF1/nsEG/
= *00	bPOB1
BB6#S0444&F'B4 0X5_5T Uxpe
 BꐎB6жrє @9B|S:B7]:Y:_:a ]:Y:B7)չB8 p\/`P%VAE1ceT(fy`{UPrP󰩭ЩOP$9ө$BA  p&BC  BE"BF f T
G  G00 b+bbCBD
q AybBFBBBBABF[%C71C0յ#[  "  y s1Ew@ @ "N-[515
 
G`WG     *"P2%t}a a !-
3e
Gp p Gr r " 4vU` `0Gd d"ڒI C5
" 0 C6
W[pC")ucC60dQcZ @cB\yCaC7&O.҄    P[+8b@
   
 u
@DM@+BC'ADR QCA
D
[)CAC;B nINI	pCCuD*`!EPRWa
@3tL ZCF:t)ŋa U Qa2v}O8@95x69o!(@.D
C1DP.
!HPPq
@D.`c~	_RMV G _EJD pB.QP DDQ E EI23PD0-Q D+1)D'c7C0"	[CF1ѩB*DFDAQ BF$D'1S3Dr 4p sN	[A0CDA	,(AF
^
1d
/.&E2?q$3Hodq
E =







z
C3C0aA03FU0C1E0$D_GTM? p
`8 `p1 @E2 pE3p20 ă23 F WM hhFi  `p
w
4>Pa:` A` bwbw0ib ac  rb rc: u0D5
#ab1
22E5bcE0:66 !{ PT07I
[$ 1 F e&8INp^
1A??? ?27553M?9M
?? ??=
93?2A^`ۧ
_PS02 3 T0_C @TF0	
# A1OF2OF3OF4OF5GE6F7L;B `2\_PIC*;h\/v ntA0EoT EEBM	
KS' V
0** H$S.d GC%

 A 
	
	
 !	A		a	[048 	D
 ABrSO0QGST0GA3B 10 7G &(^VW!EC 
[EC57 H j058rED
!𹡮 @jEqQ6F@	F
*R  Rd
d
Primary 
10  
LIon 
Hewlett-Pack?ard Ey?Traveloka	E~Z@ D.PYL6C	16Ch`/`?%
 
b}
" 
 
!XW6Fh}F Aϳ70A10E7FaPEFp |70ha`Eh 7
_UIDBOzA
_BIVXQ@ ST7@~CL\\[GP#8{6`)fFpocrC
ACPI3	`SRS8`6fr `zBF[9v&
PLIDs
>_099
@Q֠a4
	/1?5?@SX9{N5jq+F2 A  ^F3`4uzkPk`ah`piaFa
 ?{qPzp
 a{`
^s }aޡap`k
  pap O {Q/ !3@4? 1Pܡ   F5 m bm

  V` o `2^``qhp}
yjZ0  p>a"1Ph)h`P	5}` ib pbasabcpcau`ao[)JF67F7
! `b  ¡!8LpF9ˊiA FB qC@:FD	}/ p p
`
R P  pr
` a  E FDeǠe[0wre
 
 C200pQ 61EpFAILp0]pO%ASECUYp`vAMBf7p^@S1bFwr2}U3R4]5-3P
c6cp
>

7
	8
9bAfH82Ga0P= ѳF7t@4	Gu!B!C1DEFC
Q10j124b!u..SIMW6Q@21gOA^gbER'JT/71; :!Ɛ ``,NPASSa0!G8.OaOK AI!0`42ap	Q a41HO2CI; 2MC'4akbbaуL ob ubN45ED ph<piK6k#M7M8
ViS|pq `e pQ8AzWDG?
<4_c,E=DAAyB{M4C~ !f )ABpWMAAwF9ij=!AtWoppi3Bh@fZI0C{h
`7{%39
p$`Ax03Cz4809
,*{0s3DK	B
  1K  D K#
-{#8/pѥ//4M&_96M) %I55P*aFnK
10
<6o!hp6F?^r2h	0)T3!
1_;!m  B7U`ߕ!5B&G15[ChI19
9$~ 

p
1%!&C=ep
obP@3C* 6Ėg?	p
_\
p
_3N6p
o
(%P21ADB)+9j%
+91.12%KO0N0`/;8L1R p`mQ ;!^@M_WsaT aR Mf (TQp1TqSr 85s6 WQABNFOMM  e:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`LFpq!z|| !Y~GGS t.zR4:Np1NW9B#?U>2Fpz7G	A>|=h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1F0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`lp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
{LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[C J@07[QCl[#\_GL_yh
00piV1pjkP3044\C0F8hq4`	l['['`[D

[  EF]20 r 1m2@PC?20phW20FF4C230 >aEp{zh FP2h7	`E 31 2D Z051i	
	16302	P[]Ee239_3A B CD E0q3F C240 rʟC  A4140
[ 2@(A`324 h
m44@ 45 6 `045UyA
	`rh``vFR`4`иcdaJac
p`rdP b}y  baya
a0apac   eraye
	 evepeBc ucdcMq
cpc  bpbgC	bdp apbe)ec e ffg
fape`pfafgvdueA`b޳B` gTb 	`	$b pg13agg7agub_dM9,05#1p`!p0`c`ʀbQC D`_ u`py4 j32  4 "h Bh H
bhc `rV 4cada΢
e,3E-adOft`f	ru'adSuc2ftd gr:`4bA A4[A F3FF-P0%849`3EaqD3Fa
_INIށ-AB Bpibhb0Bp0<4Brb
DC
j0CD"DD"bF5E w6
arC00Cabpb|.0+bab`babuaaP `bua/_CRS8FQ0C`v2-E`T`_STA t
`}^``6=OhD1

	4      y7 ? ?51 5E11p\/661[Ay252K\53-
*G  0  ]   p p	Pp	r[K\/AE
4=R]1A0N	
GG. . GN N   G   w@ PPRRlloo  @ A~-\/B9

G
 q^^.C17AC19F\_S0_O
 !  3 !  4  5   M\_PTSpheb2AHh
} Oh
~	 169ܠ]$f1E6 FA"\_WAK@ 3518A114( @	2ATDCk6@sTZx56 TZ1_
 2 :A08
<aF0
3O168bQ6O7acbccc77PR9004BBC1DF
 `=D +E3.8@"! +q7?7A
 ,-!+A6
 =*G\!B7C	2@


06


b755?a̵
 0[
KL9sLApFPRB
QM SM5ZN60O619P2 3G2W 4Р >5P176
5 5
1({!h 9_ 95Aik;`6
#`pB9id!C67
hi64
pi`"i0
`O8p`phahqu63i 1r	Q!  09i ` aP6{VB1
H iPIR4p?KbPTxb;55@6
|EP56QrpR	
   
p
S_bp{tbK7;<A2

bt
axa

`bp 2

	A
!

0O@_3L*A	WF0O"d~d'p{f37p`{b
 t bbwb

araMpL3a[[1^_Ng4Fb`0)a&1h 1'2 PB( !y
h6I	{8b  =p*h abw`%  vp@60<3`S0A55F&p 1AQCB`hfg3_
b 1A) M6B
~4+h w`t`(`x`f!4f
UP,f[,f 1tq,cbb,b&8!@:?2bFi p

ep_
d
 J d&3d1A5eiw(y,9	B*YarFa[B5PYC "@U
d9_ON_ {S#AL_P_OFFQ7P:DDM
POYObfCH
uAE
AO`Om
2F
2OBfOsn3C2702ۗV 04C[U"P1MHDC@GȄȆ@ˁ3}F[Ho_AL70 91 PAL2AL3C3_GAC0%""1&DB2FaXa3f\PSVCSLGP4ᇍmAG5MFB([F89pF5"5B]pC$ZCSQл!B_T/SP
dp Cyq 2CRT`^0TMP6p [G +&
0a
,"3!AJU\_GPE_L04AB
0E06aw8{&9
pk%6248}9a aa1
{{8B
`}`
BB	7 63E`NfE?.`
-
o	a	`
`S1F6C214`C`90-95``
 `p`Z5<0BI-8pC
~=_L10l
mACEc12˻1D Ep3t2o81`_91a{` {a
g}a
apa1["S
dlFa4ooomac\oc b6oA_E18 )8E
)`51!6
#(+4C104O.O.7|- Ga#-s{ ``O5aI{` >@p Pl ` 
 Wps!a a0)%BGPa&JPbUc0{5?95?`#0}6CUSSDT  HP  HPQPpc   MS7FT M5[p7@	01   L    f#__fT	_w 
_	O78wjp9r!B5b27Ua9P]A0i79 ij A~  Ah_k21da22 0A6_0'A4p$P0 J3z2 yj
I5 l60bj[9B
0P3PQbb`h77a bub i2CB4t221hb 2B4E35q30yPCT,
ς 05 y _PK_PPC 9@14twv77`RP7a 1j
0YpDaa9@S 30U7B
   
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf         	 OSBI_BM  |p ( n s0  b C %   Ƹ   d d> F . F !  n  f f   j       (!"320$4Vw
v_T ,D a%he/@
WS "h$u/"dxvUDD g?~d0?Eg"
Xu05x`/%'cq 
@@"`b&6 sXr*&_`	@`&/7R"G qh `8`hc	8bf@ 	e
o
*` 
7/E`(X]bx qH p/ A
-`@@N`1A_hU@DEb#horHa
Ox_%	 #	/D?H_$F`#? ':%H	!)_@ 1_ (a  !+$ %
#$"B%2`CB`&
(!?*O"_bo-,!)a`*(d $*t >.F?!H@5!=7H.b(&%'HH@9Q& AaoB1sbp"(b*#-eX僠;8U!( <O`5a_( <@CF N<h`@o> 2a`3`?b+O" A")E	=Ap`>!>A_@A _/@ 5!G b!-_]@ChcCU"$
#A"-,1"EfaB@ T @ j:'!D 
oEQ`Uc[Ra>	?oed-)IxB@Z$$9"XLAXHoEc6A"BTnAltZ"CvAO [`ZG
c	(q]#[^%$P
MoBM%	8'
%
#Y!`So`e6'M"S!H a*e[bdhuB5p 2`k#kExN
PUH
2cZby,_a[$Y<A l
R/bn!H"K(bcjAQ_D@>(?AfODoE#T,@/!L@FhhDBS t:`A@FCk@A.MIA]@ ~y`^!C:AR?`"P eB!AmHNGB~OvC"JZ[qE)%S ~!U/p~AuA8m@gkbf"tB1Bc	2B!s /	o!*c:}?dArp !d(
a_	_Y$Ba6Diq fh	C(:#s a:B!
ŘDVDBAdWWrZ`A*q8 v aK"Ayr a!gaH@\0c |H,&a/z_` ?  #[ř E7#p
OazaG"Gc! "dBa!EB.baExh r P%P#`x`% 	qOWAtXӑtE!?@CZ" ͅP6," v/eȀ`#@%΂]H`ӇA"
x`bE`ڠBҢwb B  G ݇`ޠ@ `xET8#}c`ffw @ "( !`f^W.)@넅4BTR%84D     f!  f n@    ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ     K     VIDEUx  AIBM 761295520C??  2005/03/22 15:37Z T@  <
RS480M- HP TAOS 300/14 BR12225
 (C) 1988-3, ATI Technologies Inc. BK-VER008.028I.@ 0  yutaos.hp v611  M PCIE? UN  OEMt  W-  Q UY%xvp1t   C$TVSlS@    M}HDk(z  @	Rx  !MOBILITY RADEON Xpress G Ser -{2 O Q  #  !
l 0   4 Q#A9$Xa#A 1%GQ	  `  sCDAP`X 2"0A  p M[W  ` a,T D ݀+Z @
.,.dM/|UB/"l` @]D  `2 MPLL  LL0 8;M<@& 0g 
v
5? 28-o9
~* $ l   L  `  @
H < B U_@Q : BBqmA 5 8 bO p@ a<P' t	a*u  t N u $ 9
3p $  D-E} FoCF #@g1aCdP'!'zh H f`.>, u..,..	 u  .0.9P u.0Ȳ.,fa.m4.>q u.
m.&m.mмo.mf`7 S3R[)$
PtS$RR+$X-i2I n+ .fa"4t.104 臍 P # mPVn^\i<XP=Zt|.ߋ QȤ Vn^Xu蓩4 
 ,	oJ $A PBX B@Q ?u^r-atta0t{u bÍhhB!AO89 PW uW첺2 1
tG^f@ ff+f| +/ffs @ f.Wȣ,>VB <v  !  32Ĉ&! .@2ɨd^Ð	U   NhVS*814DLd
FTL>0p  `h@S@PN8t ^Xd01F9>6 F
u'_>`t1r"tr2_2>SN)N=s`2`S<ti ^q tW@Mtuu	 t; t6f;Q? Ys	-F;$u<t<t<t
<t
데뉰F f;_ [# ~ tF: ǻF.?F6r@F2Ac wtÈn<uj`tf ct  ^"N @w3X8u P P
X"8tN ;N"rҋNN"ar /s2~tRSf_Nf L  ffff&f݋	q  
sBQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ 
F X[ÊFf@F$FFt@F&F( D( tR.&0U,Z.1@%[PR.Wt2L ZX` @ Fqxq@vp=@	;5vv `tU;5tEt:]r9Urmt5f3!qAf3ۋ^$f3fa  }C s
Pe"8sn~=}:n=a	Ð Ⱐ 1'(+ S?BDbncOQ]SDwp  sgOV uhOQNgORE0c	R 
l	jcgvWX !ce
pVPa	߁cj| Ris B^ cf	
U'  g|}% Lܢa	d`2 8ן`	w6!W  ן/  =|ҟ)xfҟ 81a	*0*!
ǟ;
	
0li	}`ӟ,b	
0
H䱟 /A13аU}4oY]M`62a-b6ip #B8q?J +%":, `6jU
u%2S-.<t
 C[3Ы3Àu#ڋGWQ    u 2~ U qFF
@ F v ]jUbGS	C	8t	C$[. PRhG\ouP tY@ @L,^P@  XjU   @@xSQRVW	<QD. ..Tt
& _^ZY[XP2&G@ku
b $@
@@XfPSG<uTG<uFGt,Pt G2| uA߬G%K3u/#BJ  A+@	\G`
[f@S ?X˴.6϶
By ʢtPހ u< D2@ vp.6BHeW%  }i
iQـ.afY	 
 pfFiiF`  .$FDVpQۑnpJOi@舡f`KpNi߈F>DFNF vpFaq&W߹  _$<8UOSQfY_RSWDUP u   ~ X_[(UX T[_tF$F&p
u/C
 U⻊T:T[P ݓB Cf3a  v vK컉^h N  ؀t Oo}c `M z ZZ?a SXC3D@C4} C_<qD?C0e CBS$  	{0S<o
2aud
IS"tQSD`Mt@uN,߃u'"?@3`VF  X  ߀t@0/S0/BU[KC
t$BIC$BDQ&D+Q?D  ! s*t~l^R 0Q t
 t?R@A%?%P%@
Ā?
E 
Bt1߀t
B$AB$AqB$@ABAW( 	 c-'(+ y q	 TvpP p}c_O/PU
(P	@ s ? 0	_@ T(   ! 	M](
c    
   pbc O
 B89:;<=>M?
 +
G _B$d "ozc/fk
2 I >2 
P  
> ]@( $	

 0б0 	  
   U    
 %( (,%*26', 49$,0	
!&.3+0$8=-2 $8
? (,(gc $ 0,!$
( 0HH0(, 	H 8H
8 X > XAgX<	X0TDgT@	Tf(XHH8y88 ? 4<$
$ < @XA8@	d@Ap@ @ AO..r#suP =Ou W&P=: sX.XBTazV*FJBC$' .?}@4eI3: +t&P$vJ<~.;u*6I8Dt	\S
OX=PI
PX1체0&G	tԱ  G	P?
u&.+X&c '/VX00PWl.E#ᗋp_ZwYhu<tDu
~2\tX&IDUD 30]U 
F CE]Y[	
FXPv(XA 6S跊[x( vv !
u D]3PYW: XJ  Q S[WS݋ P	026'C[2S  &'B[ ĸ Ë#utt&FS޹ 2&C@nrut	 F[!	7	 2
n ȧ3ÐA.T[t v @%7t ̓rPEXuSصMP[	$
tWÊg% oŀt4$
@   `Ê!4
}P X3<J1u P<~$<t <t<t@؁ð@  EuP@ÿ!!"3  @
@@ b !"# 3@tb
% `ĺSIz"e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;uupuK>L tDI @.>W@3u&"0W<~W&g7t#0u3 3ݎ2PQ3f3f@  fYX2PR@4$w@ZӷR+Q  R< 4{Z 8 b3"P m303s AQR趱$WBrڹTA fRȊoZPRP艰 X@ZX8t
tPZYXnuT  w 2u  ].3
t	u0 0t Pb1[X \0u$0<0u  &o#6<uA	ut	
t0
߈ )<u+V봀1u0*u!*Qq3u< "	,܀4u< um 
f铐6u& <t	 00=@SB"
e ml`>%ȋ쿉^N"	:  *Tpe.P <Ȁ>cu>&@ 3ۊÜ$.B.Eq J@^X]i+Ht8 CH <8t<?t4 .B   K%/+Q` D Ei Y@ 3Y |RQ
 Yf.&  b&7 *# ?#  F 

 G@s 	 GޝÐ~~|ֺ| |8 8| 8  l  o<~<W7 ff 6xx~~~p`>>66f<ff<  >qf  f {; <f8ll8x~P 0pp0a$fwf$8||s|
v<<a lllll  l ~| 0` 8l8vvP P``0y @ 0`   aas88 || x" f<| <l |ƀD |  ~ C aP
a0QP 
  ~
 ff|ff f< ll  b`|``5 
r 0< p  `b% ?Ɓ|ְi|~Zl) l88#<  P
g| %| 1| -׾0ÿx|~ `   ` 60[00q(v |8 x`flxl@ lpP-| p%| '| 06p'( *2
v 0d 61 \ 8 vܤplp;5 -|ƅ88
l8|P'!f|ƃP/&&00 %:l~n ~ހ1-7 0
	'!r~`l`fl fEK>c8c>  >a<4   ,+> >`gc=  G0`2#`?#: 0|6> l<~61F  6ll6` l  "m# U# w# ##d  6 0P P 5 `ROqPJU1UQ2d770??%0aa66 R9a	
( R>     f 9x_eb]qPf```p_d~̀Mi|u?܀g8 Sl8T(r(l`"8fj~C|q^ 8`T`/Paa! b~ Y f`[ ps xdaw<<S28tflD8p&mp0t| o@1pqAQف၁P>Q#tlEcvFlpxpq5 aq3Ԇ}~҇ 1>6>`vfqB~~`>~~>ՂR2$ P {p4`|| s4S
@pC 5t%9_2`!@@AHi P!3pxF)bfwP0v~mi "{16879
 G-3 a5әAaPp |@ѓ`;@Ҝ2#a=Ғ~ BC ҥ R*Ҥљ tPa7
`p0iQ.f`d|d`` 
`ζL ӥ񦴝Rp bq
 xp S	 	
qQF#a`( L%4bLZ ~E1࠵ 4-"0a6P6rCl   a  	P$j Ƿb[6 qb 
P$=b X
CO5.  'Ma0
A "оc A Ut"{ ځY
0x"p	#@	$@%#Qb  
#p
 
%	" Ђ#DaĲ6f0Pr 
$ 	%  		C	JC dw@`1|cc0c4t	?! 	8 ld>BPP<@ WWd! 3`p3 B7< ;8>dp` ~0]Zwl^l Q6=>6n6@s&t%D+ f 5ڿZ  Ed

 Z Ӥcg Ecb
 d
d5e %5ek 
c
eq eeu%
 

9 Ը=3;1N Q1|b0i 2S$|ҏ05Yaxp``<f	P`q|  0^0v  3 јn/AX `ix^ x8#?~  +/t?W2@ _&&MSWI &FG_&E"&E#WIm_&]%&}&I2.c2
t@' dڠ)p = ~=^~=~=~ &U*&$
$

S0B$
	-	1S2;t4&wt  pu`2RԊ%@+F^t=@ eR Iݸ  t` t:t ?FP݋ !?uq&>ek ڊJiR 2  &GF %G @GÜQW+&R&D&TAα w!	ʑ  p&RW_$&TAP
 XF2 CD#Za
CD#`	 
a@[@_Z_Y`GQWP$0-󿤾p   r ts | :&?Q<#a " G 	ĸ  2
WRU` RFJyCZt 2f 	2PYs	QP&G<Y^+P 74 7@Y쨿 t' EPJJ  B2BBXJ6wOA!U{,?VBBq#5)^!]P5  (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

			   

m
   r 
*   S**Q p   ?  ??Q r  ~ g~   $$$(((---222888? ?? ?/  /? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h@   1   ҙh1 h1 P,h   1   h
1 
h
1 
hP$
ĲXðN WN^  t o>I~&G3u 	u&IúbtԀ`cNpb  P3&2J&Gq  GLq ģ`À0c B2[a a;jb{mphrmÐ
  !"#$@ABCDrstuvk(
K [!{ ;Al(L} \!ߕ|<An2N ^!~>Am@M ]}!}߶=A`P@ P!p0A aP߃A Q!q}1AbPB R!r!/Acj)dC S!s"?AdU/D T!t#4Af?F} V!v$6A@h@AH BX!CxD8ArgJsG tW}!uwv7AeVESA   0  IbK  @  ATI Technologies Inc. MS48 01.00  @ @   P   sVBE/FP e:.6p <r2.VWVSQR  f&=2u " WA_WȎ؋ʾKp" uz &u&E_UWPPPUwU Ubp M_ǃ"``݋ƐuZY[^_O ËRQSVWU?WQ30
Y_u5WV6L2^_@

.WEE
tE M]2B].l.DEEӀ~ZӰEE!@ #  
E" $ ~7pq~$@@@@ #  P"%~@ EeUeBS3ۋ3[@N
tȈE}~=
 P-E*؋EME,].

-+/E0pX1 
 f3O]_^[YZp0#RQUSˊ$ w
 V< @t| dQLPY
 b 
xŀuZdĠT2ʋD<u<t<u<uAA2PQ/3 X23` .ƻ
>	$XP{C@oDI0o[D0o2 2pDo+/tu[.' ͮ2O[]YZ)ø VP$6Iش~!t8\t,	2^ƀ t %Ӓ @^wO-  	9s3"0WV>ȯF^&Vf=>^_ÊFG< uûS.W._0W , 
._@StwCCPS($]b W[XSL+[ utzt
uPSR Z[X8
t
<RBB@Z2ÀuI tp<wjut`2.W,ap!`O24̋AaP$Xq(
u uW3&+_uADOD< uLA*؋6IS [';vȁ~PMAJS,f[Dt@S[%@عSQ蔿*2f<ff3f` Y[f;Ës @]xryf@Ч
2uGf`P詑RPfZf
ff30fX<uVS$f[fa==f "$b[f%fPO@)
XZRJZfX"[
uQR~ZY!]"uRY)Zot^3"t	$B wl wf= ]QRW&9f&f?$4 Mfgq_	uS$& n  T8<\ VRf 3tZ^fOf33sfffPfVX V cPQRfRfQY $  OZYX!
9]PfBffvWfP4<0B?&q?fIu" B&$@[A\`tW1_f.  ;t} u2X#%5$$ ,3>QSu:3ɆtA
	 [YQ
$YqD?SQVWP# 4L &_Is  =R^Y[l7QRVW蚿{	_^ZY^ڋ_  >$[ SiRa3MR+ Zt $$}!
  $t߀7SR #uZDQSСǾP&= PH`UsL>MNOQPQ`RR+SSW% FUU -PÐPMIDy"W _  kأ,>WXR ZR
 q  ZÜW2 _Ü"oQ K.,3d f.;u	W 
	rbr_2[fX3& $4
 	]ffQQ2
QQQR>WPH۲ HfXR2ZXff_fXZ* %RVp[fqf_
V
4
mX

jV
틩Rp}=fZf`f_ZsfPRl g +KK;rZ S 
S  S@ [hSSSR	QpQ  BpQYÜ2C @@'@h #    ` #  _   ߀Of֠ .D=p_=0"f`a.T._
DDA#S_}a Z0R#r1y? "U",7`(3`v	.DfXu Z
bD	Q3Ɋ5U *.d"Y1+&v
4075Q A8tPn  3	
		#  ee
fa		hPXP   SQ h~t)bK`.IC=;k
KuY@ Sn?78t
INb 0	PKXBLQ('ޠ 0{ \pjr
a RP
XQP$<63-X7rX>hs RPXQ QPXrrXsYY2YSQW _YQWPr
&0G	Ku_P !Ys"'Yr?PP?fa t2+QYI?t蹐 %QU2F F IF E:s T`~  tf~  u
 p t {]puÀ 2S 4pXY[[ױ' PQW&EN_Y&?=XuAS䰞u"W&
_
t ߀u Àu 9u?Z u	@	3u%ZEðp?PXq@_ @ <Zr,ZP1
o [Se6_;w2XX@f` cut3P%2XtqNx Wt P DwDX f )P%t:*uVP X  F X 9
u9P)P2 fl SP nX[ N rfaPt t
 	s<s4qtuR;RjS/M
u$PLu
	Qސ pq|rs0u0tSNQ{Q*R路t|ttR{ab!(b.? t.;u.;Wt3Q@^-'(+ ]c@7h?^_OPU g7 oo XGW 6O  	@sTv2ed. 
90p@]+ p3
2SQP=09q53~At'		t߀t!t	 רuC e@/SAI  A[p0B$J .gp s  J$
z2	䟰@
e`	P] 	!
U 
̀n	pg	
4Ȏr y1ԟ/
$@
JP@=^v	@=v$?
ÿZ[}S?'1v̬IJV +Q$$fP, T  ] JfXfXA @=S#1;s.:Gu@3u.pR&}$`SU7 Esf>. t7茶uJoPQr X KD(d
$P?][3۩ 0   PN = NXuZ2@t $C^ !B    ǀ Hp ŰW@ĚƢ $ ra쨟ua`w)$<t2
*#`r
p
w $0茠 
Y#"|z$ qo_$d ú$B
 <%1$f n[
($YS6 |R"$6R,tè@S%"'@#"2[!f$%@YV P/HY rb0P"XrjkuNlmp~H!KKLF,F"F:R`	4!lImwsjull'kuam
KmLbKB 1	17 8;ұ (<&" !RbuQ*?0SV "
0`B2 1/]Ă  0 r`HĂ ]`R
P]$2+'$!,R <0_#$R"$R? @N* >$ AO>*3MQW2@12^ 6Ct
{ot/
0{ ge@P.tP qtt{XRc J_JIQbki hTkjj		zD($l"9RPĀa
_G'v6uj!h>i(il.E# kj"u0- ELHIJ !]$abRW(I<#t=<2t9<3t5	 2f	PQ &SI[N
_hfPfX2$<A<t<t<@ < 7F* `&E3uu
u	fF4@  8 _._f.EfPF .GF4XwHe uSF6XH{guHfa
f%  fF8fXf;Gf	F8:mf2Q..>ыFF(PPJרX
tHSoG[p Qu	 Q
PtR3Z{Y.HFGFF
uGP0FG$`@F	FPG
G.M	

`3T
ňFF	
G	F	 
F0GF	@GF@G
F3F'F2F@FB <0!mQRF;
!t7<t3`l/@"@"
<t<tn2NAVBFF                                   S0(4 f
   KfX[Q.轡a.YuB u*@pf EGtff.#Gf.Gfo뺊ub uSH[`.O.t	q tIt䰔БٻPIt$<Ȳ2PfSfQfR\9HK<~fXf+@߹@ + ò<PfSGS1rfDGN1 f.aBðXd.|p ܰ㻬 GfZfYf;@ K Pp Z d r     	 p   RR  ߀ p 	{   P  p 0  P  ߀p { P ^p ^ ^P^'p  xP "p  P	 @KZPb   fPWQ2ɋYSQ2Y[VS@ %pX QSfX PQ3@G YX P f%f[ˋQf[ m  fà!
^_fX2QV2oq.^= v8ǰB^ YRp'
fX`(ߜ@CJQo2P$?X%"0/@.q0P%P$~% p%XB;3QfwЁY`<fpufPV.^2=fX-~|r
01u0$Paf0RYfPWVRQ+Ë&G
36 2P $@afX&2&{YZ QR
FFrPv3f1pPSq퀿ʢuȎ؎6>&D&E[Xp	2R.
n1 IS ntQ  tt"POP`tRp  Q-Yհ|.Q
Yf.9VZY[!TR`\f}0O;Tvq vpp  f@ wjvef+RvMWv? v2 v%v u	r,w{'ZY0WAE._t 
UNfwV'^jfpf.fff;rf@frx0f Np^f;?rLf@.Ff;wff+f'7sv
A
X.L
	؋N]t= r = r;.+P. VÃ"%я[pl!0q!À Nt˻$@`L߲V$T$a 8Z3ZШS$p|߲P%&O@t@ wp&W7u t@ @wn@HZX^	ZX RWI߿8x`ăt N`ǯ_ @`0Sf4[ø \Dw3H1l g +KK;r  `k 
S  S@ [hSSSR	QpQ YQ2 QFYÜ2C @p  				    y  
p2x26޲[Y."D
$.
xtcys/] IC`  D2B/dS 
 ]ݲ[&Eq _P00aOX0舰&DVB 
 &ѧ^Ͱ0ZV($^PY 7Ftf
^~f0Nn;w`0 Vި[Xu;}@fܸP@%  FF Ƞ 	rp=F L
Tv&wiFzFqM@	FȊă41n %
8
F%QbQ0PFf=$116, )@f
 
ZË~u Ur
tQ~8ؑF
RGS؁Cý[͸ Z@= !8t ,贕 : QRc3ҹd 0YSR.|Z[  RPڲUX P $  (d
$1ϼtp  $$@!
u{&4u5 * 
 u.0tӲ.,63 W߃ [ WQRVSڲ+$Kې 2 Wћٲ|[P30@Ϩ t	@ |Xھ  w?waX]rIw= 
@7_[^ZY_B?t>1lpWwA2 ③
0
#


  _ &

ۘa  ul  Vf^fPB ӻٟ@0ّ`a2f;ufY?$_P0pr3>ËË>srƀѷCBr  `rVvؾ| au| ZX^.tW z׿
ID_ByDxVS@+;uw[^~׿|\1A	n׾ } ^( 
@7 3K!fBCC胤У   QpwoPƲRXp(ֲ1רu[ Xh l   Bp   & @*@LN  QRS.ְQP ?d_-C - V>NP(ֻP Q ֻT ;P$ֻd
* 	| bBsֻߌx | @CO֊Ȑ1pqXcXX	XIXֽXP- $2_t[p[Qbut@ sMPRp_s  .˂KkPɅ//R//BF No(Op.΋FlT2WKM//@ N0l`^ Ѐ
u3ɻpՊu<i*Բ.s
tS0)XZőXZpGu4հ 2陀$
j}0	OȀ$߻ 
謟u9Nt  @V*rN8#Nt
P$

	h(t	
tݐwאܐl@ZXt3>F  鴐;4<	52QMtS: 
7͈uP  	t&$
 !N
D2L  .Q
Q`w0PXY&^8&TϏ$%T1$pȰU%$ t0pu闏T %齂u   Ukpi`Y^LW;-f3.O>f.O% uѲ$f3
tff-f!a	f
`2._O>uu@r
͎04
ݺ 	< Q< a ߋР&yA&EJ'J
W@2J.$FGG<v_HHز8] C P:\
>в8&E 1&% W	 &OO_2$0mp$@X馍u_CP t fXf P 0  f+ffI!^uޒϲF u}V$"A)P<[1۴ ! [fpfWDƀ t
a{@ѿ	*QЫ0EЃ21	}B3ۻ   0f+p&@)p=zϋ&if?PD۴AϡEQ X࿊f% P`Y|ρ
u9|t* TβP07$
rѽd~ҋƿuzgW6ϐFPTѰ0{α &MO&Ee%GuoRQS؀	襋[@@t Y;vȋZ;А PfQXDQ	-ӯ aˀ u$0@4۶@4ްu? 2ۨ} `Rwv S[] [RY^P	u* G'诘u@w
GE賆2/@

	f̰$		$eT=]L!t0}݉މPQR $ظ;MZYXً$< t W & GBQ Yu
N_ u	 ps=lQ
PZauA= Nu~>K 
<QY@rNu{
v`i\Ȅ\aH݈P`.C<t8tX'Xǈ |֌CT쌔1ʰat@r0s%06 I !
Csr>$@pw^ʁS!I艠ؐ
3uRrt({^R8M"c2'܇ jt}7u1
b{Uq2
؀
#/l@ܪQZX
Ò=̇g=P=8&MU>&U
>+'Ю333 3Cu@s@*DPS( eλɻD d$[X R#! 8tf;uaS	
 u[S
t`@ ߆!sQ 
!@ [߀
q߆ÀK3De%  p $BȸU~2( .%ߵ
fQ
fYfPfQ
 Qvspp
  ̀Q&  
f%g*!
=%YfXfSf lf[
zް
Qø u  - om ~Ȱø jѪ_bԡZ }R⸔@yJ!B⸈:1f nqǸM@0 20 A q$Pḕ}  \ rỐ3
f
  cQ pwptpY@  l@ dB {3ItRZ8uR*
Z 4RP  XZ 4$` ![{ అȃR23Ұ
)u 
Z`..W un> tgp b2P>bP22AQJ2=QRP@ 32ZYYy2ߢ XaZYYR*8}2.WZà؋m 2Ku2W S
u Bj[+с2Ê2+C**&R  ZHu_ ۰$JB J.Wr c» Q1s{ Y   PQC3BBaaPQ 6YXaYQԨuXN
+.J
uߊ8~` W$0<0tW:Jt. ` S +*21+uX  up*tX⑰ ,. P"Q0׊4"
Ê$"ð(Pр  !$%D
m݁  +

,QVW++  o  e_^"YԊǊU_ S8v2QY2P >It(P
ïRS"82 PL[[ZRРJ2ZË.ſ ŕ 03<?& t
uV E,ņ!&Jd aZ6	-[a2RqZazL0 }
+ȴ@A
t
2&LP    >&}S`YظU`J<t
A<Ut2[ð
 6wЅ% B B2+Q++w+0Z0"Ȱ+Ջ+Nu`$` t  o}"t|ڑPa8~
td\8tX|0I~D*@
8t8`t2ſ
8~
~}ݿRt*Ŵ
RQVW3ۋsЈ P/2 1t@   _^Y@ ZC\WQRV`T3G  ZYxs& 	r Ǣ	 PO譊ी  ffPߑf u/0baS[F_@fWfVfRfPbpfV +Ɗ2BAXZf^f_SRP1f3ҋ`Vfޠ Z2f04[u.N i wy拄 rXf&Iw`$=7|t;@) _v[`ovI
R:ZK`RhσɃ@A3wh鱃y
twFs
鐃PdP+>PEbFߋ+Zh[
tQ3R
#
+ )rnAU~6|m  &`F +Xu &F E&   P ߀Qa+>2u	&}uƀtGVW_^t!#ut
>|  21
Ta|0\F݂tPA drqF`u
oQˀ
С
6JX 2B$]Xc@]SO4߹ 22FfKu[3,~!#|Ayom[pBu5G.P>F eXЅ$6| 62 'tm߰U؊Pu)#ëp &N>Xz 鶀}!1{   PO 鋀Àt!&0Y@ b?`$ `&PO A8r2Êв⿋2,/Ћ!=1HJN@PRXWQP͵suXY_b{Q(IY+qGtrGn _vqGov
  _u　PUoP[,@.X`)Vي4|4F umXPRJWQQW@3_G?8v
 VQGY_Pİ@[KZ&%_G+B;v
ZPݠ òθ!&/2R_oҰie0XRWQRQWP8tXoP5$FX_YF!Z Y_Z 						d		U		ɲ		>ctqP}}}>
u&fP 3 f \f$߀p  
@<}6}SP
3 \t&ۈ   &]X@9	U0P qG@Ā`ey
L'|CkP|طAW+A%  %%&j|&Ē*(DrX&7|t
Un	-
?|̢-2"ٰ[}~g{yr{>b2PI<
vLw5`GrǪA8sZkat u2<
u:6u Ɖ:{<u0{<u
t22+at++&eP>Ҫ?pezpбkz~z.ۉu~&2p
O3Ɋ7ʰ'ﲿuF dzZzcR`R8buaDz~1T`NV(zb$
Ip(!Q̊.t.;t$.
DY^Dy#+3*2d!d"<PR3=ZXt
A>t
y~>u<s .I0" *.t #\ b@Х(tÆ =@&8y|+>&}s! 32乿 =밀w0$&e te ò 3NsQ2ĜB0:JG_ `;/^ yxQ&5&m&M CY\x
u	$aP0胢cu4dx0P !v &w5&MwN  w}4 { P^a ,AWT wtMX9 @Y.ڰP;PY0 d߀2|XR~ ZSںY~Bxs [Z SBB  s `PSfQf  Jt^$t"$2t t=fIuvt%vutfY[X$ .[c|~<t
4jvaa_v<wPSPRRR߀@n@߰	e@P=s=s=|s^=Js ZXj[X <t<tˊ~ S&[u _t@ > B Fu.| ~ uȎ2.b.yu 
*9 Խ'Ƚ+/0:
u00w5߀wpP&p u͎..,?.רQFF u+/'+/+  Sp$[x&G&g3t!<}虽
<}0
 <t
<̀
&Gpu2@| ֋P$`"3ҹ <uȰ P' Xẁ_
PuÀu
&~à@S[t (22QPF t  +YsuчPW>&}t0&<t$8tG Ȣ&E+ _X`3t_tG8Pmu&2. aѬtW$
J	 ȋ@/utѿHa& L2ܾ+/t
 t<tc F0UJ>=&]&M&U&E
Pp>X}21PSQR.Wt	00ZH<|rSH!`5[VQS&F E<
"@<
t2_Bdpp\p' t&^ E	Sqras -Pһ -q	t2但SU@,][ X[YZ u߉:ХuZq`Ip~Am^F.q<u	Cnq.:r2.׋] Ià$0<0tu` tq
2.;tq `i8~û 3no tPmU#_)ߺVqwpt# g P 2       ?     _@  R*$Z.	$SQSQuhY[f.
uY0t㸨Xu	f.> Ef0(`f.ߋŀt
uPa*R bj
PRtZpr 1.@i(-2.OA.WB-tW+A_t;rÀtW-bp 
uB.&
ċȸ 3  u,A	t0t𼀭 ]T
ݸPG]tu?M2@
uJ J Ѐ@1

@ EPw@[ZPQVWS.>Nu$.T Tǧ vdR	[?N1@U[_^YA´` 
XÜf`CPSZYst|tuS0f`'l[!fsqm	21ݧ[M	4o
f @޲"st fa'fP2ɻ.P$胧| " wT 葨fP艁 pEOPĀ
h%<P 莧"fPf"Vf3f  蟧߻BAff	P谨߭誨(fx藨b獵2ɰ $
PfXR J" .XX
 0(!
XPX裦fX!5S.= t.;u.;]t33WRuR fW.׊eD <t<<t8<t4<t0<t< u0PQR=@uuX5
X
<=u
_8@E=@ Xx ^}     Ѐ  @jPmm @{wj X--  Px<˲t<t<ղtP<uJu@դ.MtP触%.M߸菀@A
5P
X   q
&hJ@&$ AK0U|$JPb2$6s&r$Ƥ& ?o$u p 跤0*8$;=p6_R!"WJW PrW .? t.9u.9Wu.G2tp[32Z_Sh.Ί
܀qopp[QRS$<uPN2[ZYÿ
w.;Q+Wtb3PR%$ZpR% ffR' t3t+t#@t.tpt>tѽ%ff ӹ%fpf$<t$f- < tfߺ+ `fߺ
 f2) ffffZ?fYf[V0E2ȴ2E.Df3ɋ% fwfp.	 L  
P!ffpf  !Xff;t9`fX!" 裰" 
ʣ#ؼ@p Ƽm轼
贼.^'衼C蠼`脁)ytopjqDiEdF_GZ.F+.~0 h߷ tttt	tr
~ $0C9 ߰bֻ ͻofX^ ! ݵP a&   D CRZlu`u	 .F3H!  H ! P@fXf	0^ .~1 ˃

p1 P	 ntfP袟0}4q0   8a fPRQQku@PX3>3@rHpXP ~ C z	$ ,?Lΐ{F T   Xz
\ `#fjuߟ X@ntqot= t   u pA
uu
rrXT!stY]IϐUBbtE0MA<~	<%  Yt  l柲 YZ RoSfPW$~m.E_fX[Zʝ4F
 <F;  `!(`;; >  xGN `#  )$88 A	I? CJf`TQ ' %<t;ùk Z
 $Uڜ赞!E H  !,WN
Xf
   9F.f蔜P[oa0p ~D f.02tNt!3p?d4`0Tf% f
@ JStf%ЅLtM1    [9ٝ|_ZY _^RVWbV ؜3ҿe.;s&0h? >.\c?Q O^ L.L.2
0G_^BSDLߜ[û`a pPƛ1cP&CFS!D蚛 7 ś@蝜1t0uūX 4TzPS20O
RP>2JXGc bfWP+&Go ffaztf.#fAP3۹#fCRϚf 	WfVw{pf￬.
f_6ًd蠚Xif^"[H  $,48<DLPTX\`dhlptx|  ;<Q  _г  ? c$
k*6
mc8*1 dBB
  
 ! !g- @^%
I"  `< @ G  
 @ . 0e6?:!"Cc1B; H `0Cq	 
a7  &  d 61h	29 >	@ a
bav۶, -? - =	a$ "0@ %{%_/$:_?Y"_ 7^p{$! 8 Рkے	/	, 0k6	;`P^U7 	 +91s0~ [Yg qV+q) /3+#k?O,  [. z }Jk	s#		
 	1|= (Fw 1@#h  '/# J`=_7 Z S^(, h27 . %PU# PV P@-'(+.P]hq;0p.p2`
5-_OPU/ m +\Oa	U &^0T1_]02hqEвp	1qTWEPpq20  TX |1
w*
OT"|T1CTT !@" "0"-UT$TrRKw W4N H
AYTT$TN3V ?:T98Tc6? H7
 T
>T7?;TUTsX	h>uTN A[T0B[ww^  '18 4 dTTor^a5aHp^T$N_/#T$A_?6T7#H?TT#	/)NR_?TTTlqYW~XAþ  O!{A[TXtYG[  F%Q~ 7QT_k+wk&w^00	{ w! T	4Tpa Q~oNPp^P\ h^		m		2XX~Xo2KhX	  ? ) 	T+TРOTT T S @RTWTW^TTWAT aT.T2ÀwpLNT[q.Bp!c02:`pLUjN{coy6HTbpRV1WirSoTd10T?
uƩ).ϩϩϩǩ^S%]A
 Tw4?:ĩ=Ecq2Ʃ5 s{UX_Aȩ'  5z1B{TKx 1v95 `ĩĩ yϩǩƩ$! !%
 ၶT_/$©7_?©0~ĩGϩ2ĩD ＂; T ?:TOrƺ*8P0P0b-_hg[@©// 5 ^mN؏		#!  	.н    ϩTϩϩϩɩTϩϩũ+'. Nǩ@Kʩl`cũU ©Va	ɩlqCWĩ,
g^]0	ĩ6ϩ©rTaé$TVN g 2! $t. 
t*P.>tI  gW
uV3.øN 	= Nt Ȏػr2? u2ֈ2 .lˎ 7ltl l.& t._&@.?tǐ?.Et ECCRPVWfSd'P%.]1.M0LXf[_^XZÐf`9$
0
̻^$
貈.E6讈fp$
B$;$.e9
興Wǐ=
	_^.]9t"=f(	 1=%f	}&fU1	蒈HfPfQf3.MIff  f% f[fYfXP
$t
8Շ nćS$輇0=%
=2.Q.с! !uf3fÑM>f_%F%u

茇q%%!2`( 
舆)$
 Ä*2u,j,{U, ' / .  Tt PS
w1gن#pA!J蠲 I[XÐ
s%b
  #|ph$`< R赅ZP
'↨SP߆$ *X[`Rz#Z m$\% RN$ZW@6.E#_ @_VQ#SWAte a$fذ%;E.uDff% @~a1.:E0u12 d 1u"ڟf;ût
 Gŀ~ _f[fXΊY^P	E= t= t _Xsfr:f=1_f] RPSQW1jW
 L _Y2q3$ }@r	.TPC_觰 Zcd
E$谒tC<u;葄.G`R.DoZ"QRR$ $4
1=$
KZG߄u 5xqIǄ`)A; a4h4F	 ZcQRWLt.m M$om@0vM,t]_4F]	賃a߄$`&oȑJ@$Br&}4 t?E`g~0^pVG PɄ)t1I$8m_D1΃`I$7V ZIq:f!Nu-	茐J .eY (F"fF P7 1F-c+T!F&2$P6[$
 F1e/@U݂X;uB;uF) !g$
F)NT "P@u^fF4蠂~A^F8薂D9p]pF7t5 F; oqX3FB#@0UpzF'AF(C 2fc3 $^0)2Y[<uݡ袏t<uR3ۃu ۼ@$J f fb  J$
ffe``
f׊f
_f		
f	f% 
f̀ff荎CR@3EQWUD 2F E]ou蔎u褎u?	fF4Q }8R_._JPF .GF4XyЌF6XHfPuH@'@T@zfF8fXf;tPf	  ;2Q..>ыFF_Y3vQ4   @ D
ɺ""
ĺW w.Et.;
u
.;Uu3}8QRi8PwOZYo  Kt~cS2R6ې
tuAP^_R9.%F p
 F"F 2N(̀ N(PFpGF'G'N'+$fF  f`fP1N)F 
F$Е`2.O$_F&FqnHF+F%
ff~ppF-Fa
.oN3Pb$ 
Xnt
Fѩf	f	\cb2c`nx+(/F
$F1fF N& n1f1R2.F,Pf..g` `F  '@^FG	  $ 
F0u` Fb% $
! Bu0xfu	Lf ۀ G02ndq"0
/

sn/
 2f/f{	 
 n !`N2AVB02Q F  tZFtUDF:rC6DR_aBcAfgq 0D2WPdE	F2_T0K@pK6tK2R_2hE7dEaEai a2 8 < C F H K L U Z d x   ?  ( Q@AzSt$^ ٔ Ft -
F u	F=!(^~.Fgf.@hri0ރz`z^|AzQ Nn.5 f0
̢ }v#|vF	@|v|{Df^
PF5$q Գfp}ͦAf}BF6 2f!V{5~98~57~z1Sq
Xf^ˊ߃fٸ44e^~/ ޲8	6
^^@zPFy=$a, `@p)t
 ۂ󀘹x"	ZYȎؿ`D	DfDь EeЊ]}cTILDu'u蟉D*++І؊}Ё@@%??`ODd CEeCÉ_DE	*DEe}HDL0+S2]Ë؃S[ |$0fĈD\\[ȉLE
 eMBacDC3D@< _vlTB<@P$PX;}?@w`;DX+D! #1ËߋȉD)Fz:A'Ej2 D(D*V u @ǉD+|-D D0oD.E :4\1\/^ ЉT2?03 ]'Ht@P D;XD57 ƀÐ~!2@^@S @X ?^P P @ XP Q  ` Q  x@߰    Samsung LTN150P1-L02    
 Aa  H }  !   pU Vf3 ҋ|^
uyЎ؎f( udf| uZftr# =	wIu 3Bt_ q  2QĀ ]`UG1	GA1	 2&=0*۰pLE#J6I*)Pe@E;$up E;X e9= uPWA_= vU9жN3Ƀ= t$9w 9EwAǿE b ׋A@} uQ70UEDEDSQWV^_Y[| u ? =@.|& t.|&[  DYDNDMmpxMm 2]a$@VWVS 2r؋7[ltFmA&G^
p p±  .# u ;= uDu

p$ %ڹ  _^VQfSr^
 ff;u.Q_ mY^P33 tt$@ЊÀ$ʊ$ ǐ$$2ȋ'00mD	&D&ED&EI D DPDfD{fDD0D
"fD$
` 0pXü4 Q *@c@d @A &02  L 0+  A  0`e  1X ( 0XB 8xVVA P	 -`N ((' @$
4_t*q$ppq%qQ3 b0YYtbOpIq$3S 0,r0!r3
qLq
!Aq
[}pE3_w4_ :SPȻh{pbpEXp;nBb<ap#/fPVWSu0<$0.*'U,P@D0A.D1ؕ
.}4u'+` @격
 2 T._A16  s b}&3t>E.eP@3@Ӊ[_^zS ` [Àt
t	p p  MS48AnOEM? INFOl     ?u=u
 B2u`1u6uh   %d!`\?X֠w򂽇0*0*h\'`H )]0*I89 ' -m]^ QUFUI),)}ҿ's 	AK ЍD)PIzs1uW
9w0*!U 1 7gWWw $	I?|liͱnc ? E ٰOs O U{] P"R@)%<2Y-}o Y _:Ъ<l?j-O??Is{cq5i$	ih'a9 i of'a'\`q#jD0*Q=   o q#p#8@63<@A/_"0*"AA  o__7 *
a'*
P+w &1E   3k
PD{  A/ǚI1K?  &k2ATI  lQ   1CODPS+ 
u$[S 
i1i$,i
j
gi%ai0 i$nhS$j1INI??SQP2.N= NXu2˃	w,[.'
t #֠g 0.u.&ΐv щ               t     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    N^EAX N^`  p L   O^A B^  C{^B J^ECJ^`  p K{^CF^ED`F^`  p aG^DcEB !6^ESI 6^`  2 2^`  :P w:^ > >^`  R^EIR^`  V^CS
0^Drq .@,^SQw*^F(^G1Z^F 
r^DR0 vp 1 z 2 ~P3 4 {05 6 7^K^Cfp Pj PnPPQsXsp q_Qp 1##`p 
_
___		_l___ѳٳͪճݳ_^GDT ^Iq ^L ^Tp:!_rp Ps~wN^N a&wB^S J^XDF^]
A(6^b2^g$:{^lZ^" "V^:,R^  C,^D>F0^q".^u *^yD(^}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw^=v^B z^GD~^L^Q^V$^[^`^e>^p^xDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^^Tf^j^
n^X4`h4  #_###
_#M_#	_#%& U& & & &%_%%&%Fy_(b+^-^ ^'^%!_V_VVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` |   tP  .>t:o$>U U#uG6JB qs
G≠} u7 V" "$r;sc۰$ 	 PSQRp.^	c(f.^f.f  j AnAr
u, 
^ t$.^tN^ u% ;t	.^ urt.^.9V^t!`	c.		!w?vp} a P0urotib aa
uj. .>_0u+.^t
 ut-Bt.{_ ;3΅u'u2".K  d` &.ZY[XfP.^P1_af`~"r">"e"
w B$? 8 b ",  %" L faù   Ptu
t>%Ά)u	{`,Ò!h	N
	 :twUq cs脿  gfPf&@1a}1q	21 -6U`<u f.R^=fu<=upfffDf.
f.@#(R^fC  f. ./`c .3pk!>/_d /_8d A9
uf3Јp;ZYf[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:FsI>%=s@>a4s7>(r;< u<~ <A<uB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI^ u\P@@??r6aftf+fx`Bvfu	6Aff33-f.x'h^fZf . CZ^<7 &Z^KkJ PQtނSc ۄr	KtY`Q`sV2' !	 詄s
ۃ`?r_^QW<;t=ހ  ?A Ts?urwT.Ws_b>蹃tT!yu譃uP	pX
C=cur:f s20W%t r#t-6-0/o
r\afb    
   P0t-*u袄r,$t
>r.d.NWa JJaXW\lWt5@"7.R^.;I`uf.;K`t J^\ o`96XR	r n6S` p2ft<guX<t<t<guLpr
t@8.T`><pV3`i!<1?1_?(/_?pÍ7:@!4`AG `Vdc1a%ea ÑЁtI.> rÍrD輁> H$r5} uf~!u%$ "PufP 
t	 R|]MS?e [ 6[ QCP
[}ߺ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>Yr#2].^.@N>Fr=.6l_mrDP[	  {tr@  ^.QPpP f T G@  >i
 rG@  /h !0
 G W'r{W
fv`GG ~r u6ЬП.O>
 rGG s'~td r#G  |6f}bMQ}~r0fu!`A~Fue`f10^<1pkY!\/U[[P'0	Y r'%3]pp@b ^ B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}r^ؒ0	^}`~{r s
]usB}u P?XYR
 &ies_/numb~ PQc bS6{P g t"@Qz6z.^W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  vzz{wukG>!t {6oRz M27`Az108J 
G6>}zfG螑tk{[9zGz:.
~z]"z4c{"=-8E 6	7 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUА kt`@.b 6ͷPpEr^w
f[Gff.!!^ At`	PRB ^Owf`fm3
G
GcH?^]_^dW؍ 
2; @ T_oS
Hg7 sI &Q AAAr<s8f f
up^c0Soft=jnovailq..
aGwfw
`VVQ@ u
D- u+@T rp] u62iwP>&	 EXOAM!~vAV6@
 A5|t/fTfpdc[./_D.kGIu^`!4.Da9O`u.S`f)_a-_a` &	>!VWQ- Y^_.^@aPPR^ !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^An$ ù p    \ PQ1.E`..{F`ô rGGA`wr8k ~5`f}u`uup~MuvOOF9zA:A0 r,P;A5`pvt"	r=`wvr
l1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    Qut+xt`C 8utw Du߂    u  +3R0E`F`fA`!  [s02!^s] E!t?.. ȰV ঀ;t  E

`t#C vu0<ro!
 12Ui^Nx ~@v r^aA`+
us>srvrs9s.,!, ssB;Vr'swAɡ`L ]rߴr6Pr$ @$rP{X" i . 
 A`zsuzisu#P# f֐"Ћ޴ ui
@)@"<#f.# #֐v` !vf :Ц3Sp/"f2bZ{p-_.9ud@VW/`u^/_ ptR-)w.#
t0 +Y0#p"#"E..VW."Oqp 
f=8s6q0<qr@Ӎ6E$p  >#o0!.#pLr.	qCkr!
VA4s: m|0;q$$E@0 ."  %?="/_pq'oߍqo opW> %Xq_rh߀< u
Pp PtQjrpψ1@+rp6%VoGf." $P$r胿p" .s{9ojp|}6o8=oC*yo oRpHdFouat physical addre_ss  N fpC ðSms`rkPI_,tB0xBls` u2 `u6;&nn07!q~noV&U>~ o {+@MemocompsuccpfulpW/'@9	x``>ף&?|F K*Puf6'ϵm]b>`+nf@O}mD`maQ1`	#|!!`mnlt `fHt2}.'Qr8HtgIt[ntYrTK. LU>eAJx1/P6|` r`sUuI3ɍ>`/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wt(lr%lFm@^~0N^ 
\Q&dmtvv rqBBEmtT rp+9rFB"ym<Lu4Fwm"d r`adv.?*#tud0~]SWf.>r<:ufF	[nrfF>	 r[SRir$lr%} u   
fnrZ[s   >lr<*r>*!Ds<$ 0t`.R^j6VV.0 4*=B* ku  тKa.B*?ޢr`0*wH4* l02kBr&`j r..*.5
8q>*#R9 	v~g	P`;D*zFp !8*PF* sQжec`c||*|qgF!
Hh>J*~.6H*@G@J* yaDH*@F*.4`98*w
.B*PD*oN@qws2Dt@Pp1`  .};uf.;u>-߃(swh.Af,  5p مq	tPuI` 9t3..>l 
uh. lV~	dhm '''"~ "

I`P.;K`t2IK`fCQ @c3Ú;	!>Sq@K`.,6S`%3@(.,@~R^FkXPW\@J  aCPU Time Stamp display= Speed= Must set sA to enable tsrhtJjr@de=@h.vVhuʨ^&>rN _<uFv%0.f2.^0-f. g6-fQv3?sggR"
c ter =   uSec	gt
ir!6.ECx!1.1fÍ>`gtG
SrS 
<t.p&`~gt#>/r/.`< uhgt">r.`Z
u
#l&W{
*Targpis@rt . R  manually if fails 6i/}eq9P=died^V6WeiF auЗP65e6.e ^D!e PQW> Ue>U gg_YX|ft2,r05 papPnr.p Gfu.  .D;& $Ahr 2w,<r(.y됲 #rCF YXA*	_ @p>&
蝿dw@zibu	1PhWi.Àr p#rTR.D V hRQh_NdS4jXoh0x I vIKJV  @OAL"q$ecYQ*h 1h
`Pcɝ
q.LO
(g.
`0U+g``	dy'g0
  &}[Eø s[>`tFr6`>jrG          ??? fRfVfWfU֡a2@b6m222o0 's 6c3>2e͸2Qɺ2 +C԰ͺ?2Хһ2 uj.2amaк2a ݯawb.2qa
 .+ s`@Ub6p`Qe+Ȓ>p2`$9bbZ
!Ҡf!2f]f_f^fZ*02 3<dDgw,d P$<&Xu
 $	,<w .	272N.2Q`J<uFN$<t
`RÃ? t#;Ot끽YQRWSVwd^C2.;~0t
|/2 >22։EG.2.2fEfG 2E
G
.2f$ r-/te   @ -@.2 tP=? @ ?Xth5P[G_ZYrepe  ` np VW>#3 tPo5c5ycqc6 z& 2 2ѣ>2}p	, 5' #X	&M';c_^ cER}6PfPǋfEEE
EEfpHQVW0G"u-6jS@0t6S 6!TuC_^Y[VW02
 `F
  fPf$FfX o l2 EA@ ; fQfPD$ us+ؠ% si}
uFD4/ E}t#uS uN@fD'  620( iQu K
Au#*
p	rg`1g
 /u,	 ߾1q/, fXfp5 !Asps0Y+5 <蜽 7`Ռbga5rӇq_ie@ aȋ`o$s"s1fEZ0!`D1S
Æ	!fo+B>sQ@"@*#@%>dޠD@@ᾁRS`rfe  #wbV+?^	sFN+R!%Dp	D
9MRu
HaI I7`&!5 6^<;us
(رN3AaNs@OA
Na裹 Q5Q5XQ"3"+ɶ8Qs
1oD1 F$)-R&d
*fs.:a	qmncVt@;f%$Pr
蓽.@qFbb$)7+ɠwPH_+KgD5VF`^q65PKAj5FFo<^P9d)?w76sP9N; ސnV@Ai8sR176sA묂N1*B<p fgF^Ë @t@t@ܼ$#7!/Bw)|CP{u
<s
>`uF@F2	E TE̼DDˢd%=upb5AIaR-df$0	К(=(t`o	
v+Ұ=uruQ2$rStY0< 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`qC|0^ e2fedwcD'dS 
pedQeb41>"
S~0 : `ka[X449Bnp^@2G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrte{F@0r?gOCf_2`0#escsssdsfs_gsfWP? vyB6X
6TA]qAAܕ ݳ@tޙD ߌ  + *2+*4+*8+f5c|-u sMȁU|Єu@ftsPørcp d
q t ?P~a slc#fEst a1u`6`%["	
 Kѧ]&rbpBb
Fbx+si *` d` p p P" MASAYA_AeAhAkAnA uAcA sE
WV6qAg4FW^_W t 	p!	
  	M
fw_ord db q tbyte AAAAA" Q ptry  WV.t"Ü6B:s6B,6B&ps#! BpR6W6B_?.W^P2 fXPľBXP $0<9~Farb !Ò  s봰+   1$ פ s뀐e+s-!sfR8    R8 `}9@  c      re d  (    $  ' R( r, / 0 4 $7 %8 < 4? 3	 @ R/ H  P0dX ` R'?a  b R69@ c Rg> h ; i R<` l  S !m  n 	eo p Sc9rq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 YIS
8&8 ` f l (0 8  LS%  Q   VSr/  p:     ZS00'8 0n= ^#2  bS>, f  jS:Q+ oe tS#, z  us 33  ׹;99   S%<3    4   u   e 
  H:\
8 S8 Ķ ȶf (v8# _ S:rð T t  ]#81 S;9 %˰ t/ SBFͲ b8w  % T98
,
 
b


r
QL T5??   ,Fw T5  w !e &  +T;Z .  (#  2%T  )`$ f;B` } 6	  ;  Ae F Jc87r NT޲c8R  Vf(R0ZV8^s0ZcEw g k	w oU
 s w0^D8j}S jSY>c 28(2Te0@9 {T>s  (V> ;u ztn TPb    e ' V 	  `d$ T$=  re   E Tܐj	   ݱe @ WA  B eC D E "uF )%G 0H 6I <5J CK IL PEM VN ]	O dT
8 T>8( 0f8Te W  E|e y5 y  yd y$ y yt y$I y y y4 y y$ yD y y	 yT
3 
1 
2 u0 $8 T	? ȵ  e   u %   5  w UD 
 w e   Wc8 j  r< ! $e  E U9  8#E(wrW -02 7v m;&@ E JvO& S(Xɧ]Ueb gflmqvv{&뉆쏶6mF	V
¶fm

v&660S
 es "f(.5uVr|<VrB@ EdJV8 NVUsf(U 0[f8cjp t`z 7 50툶 8۾(<V8w8E   (f08t
VуȬ ؅ྲྀs'8 $ $`$0 $ 0& ˶ f%ڻ% %08  `8  f!  CC%D\DEFiGHadd push pop or adc sbb and daa sub ss x cmp s inc decaa bouParpl imuP nsbQ  out a  jo jn@ cp @ z @ be ja jjp0@ l jglg test xchg mov lea n cbw cwd call_ waitf/f sa lQ 0ss stos/ lod cP
bbb b rol@ r rc cr shil@  a@et`ente"f`tA o iave`md x;la@oop q c xzQ jlockpn}ea e hltP=c t ne div iQ clVtc i
i d@d"xzxW lf0gpsPl@`hrd bsf@ r btr0 sp  c i 
x!seP 0 P b zbb p""epprb F`et gpUr 	l	diQ }l msw l`Usssss	verR w f fchs fkabP t "fxofld1Q l2q e1piBg2nr z f2xmyl2x fptan` as r}extrac
.s0
f`/ ]psqrs01^%frndq f &+q
ucompPendisn0	clein+!fQTf /esc
env
cst   fre0Q /r(Afb
ibC

;  ?	A	 r=fi2a (~ wbinv%wa ::ob @? 6 s zs 0@F:@s s AlBA CgQIA 8@=puid rdm-rdp 4rdt`rsm u_d2 wrxO .  f  yz` {|}F}.sx33~	t.dG
{U.
EaF,(-)*d.V)PS [XFe$U<v$tU	&;$!!{w'E t$$$I4芥"轘$Q(',fU$-

}E%$0_c<5r1<" t3"${v74&)6+t06-U0E#3$6Q9uF;m>'A0Dt+=Fw&_<JF8L?Nt!@PE,S<$VuBXU&[UD]` b,cf1i*lވ
nޕ+q#*vu
UJxL%{E}G/{'0߅#dP}POOQߌIϐ$ToT<(YUWeCC'jIC<U&@'tN^{86tH`߾&@  6W f3 t3Vv^
ꖿs rP %p R R  A
     <   P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vFt  /֐ 0wQ Zw;Px\@by   j  "  # 2 	 Q
 @ q 	                                                               JDBEXEPTNDBWAITCMRDCPUREG(^6RDDBG r^SCTR ^^MEMBUoF)_ɠ CMRSP`IOPORT5`aT ISPTEXTd̮/INSTCODEI`*	SMMG^dESET7ARGЦ/0UMEwWRWRQ
/`]{RQ	A`^^WR 2Ds`/1]{WR	 	T Tp  !!EOP
                                                                < VW϶    -$  rtˌȎ؎  v$.UpfP.>Ap uWP.^Gp f3.Up.H@ I O M N@EBC ^.@ ^   ApXfX`fSRoP.Bpug u_tT.Tp$ ^t?$.^ 0rW'pEpD 4#r	
XZf[`Mp0Np PS tatCu?L7ht-u$ظP hۉߒh Lpr 	uI[XC'Pe
.>^ t
P ZXPw Xr$$
0
^^5 r?x   hst u	ruX0rPhfP f"wC 
 f.|p!VQ6'f6e  Y^PSQfR_V0*U0*,&\f&Tf	 ^fZY[XP3ێϹ  s ˜W0   # Uq	t a*u'W 4,4^ u.>. u.8 t.9  g JPqGp } y}rsng#c\XQM}F3B;	70,%C
!}S
 f`B* >(^6.>^0A6f.R^6D.V^ffX QZ^ Пfj / 
uf.R^>r^>^^)1 ^ p Z^ P3r^# v Ȫ z Ѐ~!f%#6 .,^.>>^66
0 6.ffaJ f)!f%@UPJR1f{-pTf  K 0UP
_.QpX`0^fZtV
^0T <^f%'f
  TPV!	.Qp~w

.+RR
.^.GPW^S >^^ 0 MSZ.&Z^Q< .Gpu
@_e!QJu)``EKX!a @aI	`b  .S	k!k@%"k
kf8.6V^.6I`wf#RAK`f6O`f3ffS`kArkM3$tA^`.u	DVQ
6ed dTpt	6eU j j} 4
tY=).V0#g&;B*R^'Z^=u EVW>d!bk& _^FVW +>`Pdr6`>_^HPx pfLfVfWw>p64l /t 3ҋ? f1@
ߋG` 
t O
twQ	= ? _ 68) <R 5se>puf_fq&Yp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>l@
>lǿ  u
lr3- w|_HroQO
8rK<?prDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3`w-.-_nB6/`A)_A/_"G2k-YE.p"PG>qmBHr
x6ta >|`.s`<u=0>` <u  <u}0Pvr).ka>PNÀs`~s`DQ` w?Q%B>@
 Q0s`?^P2>`BkYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i} f.;i}w- AZ r%&Q0PPY tfGɰ
>A_W r,f 2mWT)bd@ r@f؀ffFgfd# 
 '.႐S3a `t
.~݌ffVpzxpvp"  u7 $P.~$qQnfU.E`.9`.w.F .:`0kG`;5A1>5`ŋf  t265` uuuf0=/Rk@f]anQn90P:`P;`65`1.=`Q[ fDJR RQ T
T

 ZW Z\$=
fX ZsSf3[ff$P  fff'f%$pߋ'RC%  ffC*** Please restart the system manually.
 .`<t$
  
$!$W$0AD?Ok2撰撍6ŀҘ2ҘӯPu@> ݚQ1Q ػf?tuPRPǟ^ ү ntJpfpa p6Tf W^FpOpPptO@X >TYßYfPQUGPF >J~Mu
,2 6  PpOpX]0qUf ]Qσ0ϐ^@Gbؾff&pf&  G>^ fG`GQaQ6^VfWf>f!_f!Q С ffD4$fOЬV 6ҧffP ȡ r ஀hXr$Ph5 X[õ ރ3@$<sA, r.ˠUrOp ` ԣA (tD_rq XPנ"Q!fXnѣ!ES  gf /tu}
> up[P}&p / cB`&Xq!g= BxxwB 86{yx@ ߀ #                                                                                                                                 S .2ℷ[S[W>  t> _`W} v	0EAC r3ۉe_`?2St]AM][Q_ϔ &
`9P
PR䍤鮐<w. [SrġzP `1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hbar1TaP<u< <up. .:.~p .c>`2p .?>b:P	wd.e> e,@p ˀu 8rۊ fg[ø0
.a.&bp1p.mX@E2@g.*f v&.f&˸ Laap7^*c.C3`0b  ϊŴ* # PQW`
 _YXR.iߎ
 Z k@@ZÆ;BB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x߻<Cwp.qu#rp t
ArZwG Z}YS2
d0 PR7 r  dI r`.pr`@ d`QR	 .p`qQ
t
Qh)Yus33`8u" f`Ph @F F@ &} tC t;k߹0Tta30h &+4&E pظ@ P(^ X Wu-  ap;PfatQ@  YeQRW.. {w#&.!
tff.F/.A_0Yu..,f. cQ󞙚R'@lmcǏڏː{?Qvڢdߢ1>+ r.W觳  cPPJ <t<t<
)SQVWێÍ-<t<wPXrs<v\.> &_[^Yy3	0		Q z@~Y!<8t	 `<P_Vt=EIAc
<
t0FXAP QpRt @Q$0<:|u꾐FP ff Pff?XV	 Xi
Pj}^Vf3
f^  Z  f`
Qf
p  >"Orf0f3ftY "++x fa
߰
E    1C< tN< XÀ Ttu7A!Vu`U<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ _!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4_ _P&mϕOIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYf% r?}sP r
<:uft_Wf33ɋ1 r	f
؟ANp:~  uf3w0<fw,W<Fw<A 70,0Ü@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	}A
Nt<Yt
<NtNP3t8tNXPL9p*HHHì
uÊG O?À=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Y#)Y+PT P G WIN @BDF8U$<w%.JGu0
t;wP
Ȱ
 3]8QW C  1 [n6f.Ƿ)ۻ0IQjY f.>)R[ 8svp $h 'Qv t?7H485 26_r SHz ueaJ2  UuQK7|e	$ <C} EuA{m"' ;l  Xc3PQfR1[3 Bf>@Q APBCD@öހQR0mSABC DpPOP R S~ c?[ QSWP).X. uF0	P2" <r<w,@.``  .>
  <  <;u@À
s b$ b ,0 Pq͏
 Y.l<?uf. &[u
f.&)R<[ ]Orp^?pu18x f;tuG2p _1Sf鲝a u<] Pɰf   `4gB00t  t tw !Ѵrer> ZfAA Uta	$`<`ut
*B5
u0
t		 u
l. + ( @
r?.

ZE"R@r r}0MpdZrЂB B|U
|a" r"<۰ tP w  "
 B$<  wuS0p@ "8t2kTuNuF;J t>/ @ u.SutΑյ "1ֶ
 " h]v.'u ˟                              |x KJII`BC8uĀuBJu*@u
Dgٻ0/JQL @tgB/AJJ] 7솀HĴJ!R:_$ su#@G@6J B3tB  DECB@CЭZNpBD r0`1	$ D[m rPf j qbA$<+`mb+
cJ$<u	f  rZPpc\ ?B읱[ h:I:f	f20f_ 
!$0As r p  R  O ~O Ȏ؎zЍыwh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu  	6r]dt 	#
C	EG	RXYjcA 5QPP(Yk	 ;ù G V  .:u.߷n^$"@
fQұ;!Y!fQRfCPt
' "c v
"2ɵ  W t"
oTPc@؊2fl  2÷QW!#w	t]
2< _YA3f@@ S' [P   X.
tذÀuÿ@u[f
4p#w"gf8 3&Rfߺf@'%fذ  +^;w"Z" 2$Ue <u
203<   $^4|<0%= 0q<%Q f<	&ka[<
@'P<'E<(q:k<
P)!/1f= uffX<+&<+V 0(]fW9 f2` & uf_QRfVfWSft,f_ff`,r!f A;tftfNᴃ}wn [fٿf_f^ZYWс; BIAf 蔂E_;uQ
P"0 P	]  sE:R,(SfRPFO1fXfZ['_P* 4v6Wl_ހO%Q_`	Q;Kf	:@TUf s#(  sf t s	  t
 @\QVWf&?p f&p@Q).fSP&Gf&_fXf[k^<pP`ǐL _^YSQR"fPw&f+d2b@RbPbf;t
fXRa09WKAF
ffff_f#f ff#t9 c  f_$0F iPSdMw bQVfuG PÒWf  "8s2ہz`ZaDSfWoE`-y qt#uP{!r )X߀tġɐ/[USf<t;D3` t
߀}-fu
utǳPQ[`qY3NaPf X1P{$PIR   ? rCch   }3  (` e  0  	 g
 0 
=`^8@8Wf f2B$
BϊfNff
fр aVWhc)S'%pW0APz;_t[C&0&F[_^Q1WRn8Bf0(QB簁tf ?tfA0MAXfߊ$
!#ff  S22!%Kr'Buf \ vuf K8s֊sʰXQ 7RP
t0*"Y#Se0S  uf a/u OfvUPfPfXZ+ ]f@$ff]rffymp`3zn  u= sf rAsQ_ f^ w Ѝt;kP *fDcsv >pB)au_.aȢ#f;1#Nf f @ng!Xd*6VS^6 .RfJqPZRUQf fuffVfKOpr=XfuNVFY!Uu FߊFMuY ^Ys]Pg>fmRg'QSVfNVFfL~u^[YrfXftA3PXQM諼`x N Ow蓂PQMAz X{PcWU |Z1̡ A\` Am]R`XÀ- ߋ_^ZW  f}ꑬ m _                                                                                 < ' +Gi@ + `ar(D
@ (nvArHvA. sNfօj@&t FN aR3V.Zr# Mܨu 6arkpt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF ô	 q`	 ӥ/2	r@e	~	p脀'^F&?s  {s  &G&w&GP&OD
 &	G!PR.Mf.u E	f0GEEUabgVfQSjf[GfY^f& u#GWfk  .2W`XP'F#~r .>t7  /{r?`. t8  t t  2SrV ʀs`,	p ~t$` t u/~ǉ~ %"NVg 1	s^Í6-.|uLu..`>a .:UtaaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w0[Y_0? tl>ـ?0	 r.u|
Պ Ѐ ʋ.E;v j'fVf{vdD @؊fA
@NP.eXf0` ȋ¾P	rs$
2

ў	fX!9
dD0{fЩv]f^PRWB@    RPXuUW:>_]s*r  P$<r!P~@Xup>q @<@гP  osXXty>c * BQ	F?~Q	 QV  PRσ@W> P@   XFrr#r^rT:rOt :DvL*Dȱ f umfm3
u
rPbl
u2 VWrd ?_^ q QP&:Ev&;M!&*E9aVBoCo0<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt24 uu@uu`  u2&fPS `006vaPSpsqD
>X`?D<O4a`tߐ a1t!$!"q1&0&PQȎؠRJr# SMwO "t }
`P2:Tt
Q YXÀuOu5Q,9a"   <s& ? t`P93p >-}uǀ   t| VW_<uW<
uuF΁ ><@g2<t.$S[M[|uw|
pf|`it\_^FS`}
u}	 !.b܀}@a`p;uD}a #%D0QV 3۬+^YD$f郃f}ff?ffJf\c
bPZ#f F PXMfP~Đ=r0&pw)pEwf u fu }Cu~s3SV|t` t t
^[PfQ
 0 < @f	t` v:aif`ff i Б   fQHff#f+ִ f;wfg3g&Sg&c
uff+ffa1
fP4SR=Q<$ o0zP@AfppffXMRAZru}A4Zr
pf>`P2ǜo4XZ[Ay$  h                                                                   < S A  j  O IYOO LvP#F X 	Qf&"q "&"&" f"# и"f3PW" .w{#`yp o>"` 6a  !".P "f.""""*" ! ai
#
 
 Bf3gf+"С WVo.GF< u^_QR׺s`rD.\ZYSRǊA<ˊ bp o̱%˰QRR źZR  ϤZYol|R8AS؀u
RRp	 uPXE %
cE%	$ZT
 
p`#Pp VWt_wZwU
uQ6rEt> r2
tC rͲ  r  P 
2!    χ_^aA#2
u[#rVeisCr"trS ';Wr6"Qr
Erߪ? ҝr)we  
 ` 넸    tK\	\*P')0\;#$ ?rIW(? kV_!P(B O55BvBP3Rr4;3r!- ,-BF3ɰD@DBGfʠDGADEAX= EBQ C D P@SI Q S CS= UD@ E S I1xception 4 - Overflow!5Bounds _Check6@Invalid Opcode7 Device Not AvailablJ8Aou` Fault9tel Reserved	10TSS1SegmentPr n12>Atack V
3General otecEOrrorp
q  1 =  System Ha!P2
 t
-XÜPRד2Z fVfR6e)Fup})趿/vz)pcP)Yύ6)){.)tfÿ63)j 68)`fX/=)T ō6B)J~`6G)A0Ǎ6L)7XY_W{QP)$QQ)QU)pY)
6])6*F
0)诳t)]&*贯x1*naU*WJ`u*_o@b	[Q G%; I1`(0X[S	 m6*ڟ p C8BBaaa$aH@0I0FfFɷ͋N
~fE F Nu3 'ȷͼn ]
`RQP~
XÊܹ /FFYNZ1A`QȴY`Њ  aÇً ,."ԃ 9. & GL.g.&-'@'dz Zw
  c Z@ 
G XYZ
p
7 Q  [ r  `؋   9 J  GQ!
@ 	`Eqa@ `
UЋ؎ ]_a@]ߋ3G
AF `P C0[q$9ao` $<u 3 0ؾ   fa3S } a [oVQ=3AUAY^` Ϳ
aËRQ3ɋff tf
pf3fRAыf;v+R'TYX0P@YP\UfWf&`1fW	]f_ff_]p_ (88xxxxp@@`P3Xú_$  S WR e qP0$TA D   $f Z_R
xy`
ZX`$<t.<t<t6p@0f?P4 0Sھ1f }! [ 0  `@CfpfRWU΋.t<;u+lf%A fq  5ǿD  ;fʀuff#良]_f fb u0QRfPRf f= ?t5fx LZfX u H%uA|Ł 0@4W?
?
?
?
8
ȶ_

$

p
G|{
_QW   ?P%D%00#mf <u ~<  u<  l<c<@%Z<	;Q<
~`QH<i?<6<
-P= uX<~`<<pXL]WfPCI 2 au_f(VWfSt$ Hѻ"r   f;ѠtN f[_^fZfYff r k} Lu
N`oıu  辱 s r 2fSP-ȝfXZf[ü1|]ff\<"F5	f s"s t sP  QVW&=p &p s fPf&EffX [p U% _^A*Pw[`;t
X2 *W 
_ #tߓ$X sNp s@k?у`H fPfл0fm P8s2fYZf`ffWgfǃ  #Eg  ݀ܺzA@vT2 gfgƃ0 g u	f@w1  f@f@f_gf1 gffgf0	Z`fQ@;gg&fGfXf7z;wf+f@{+f7g뀋}ggfb	f ~#fgf&fa
t@@P	3:
y
ff0
gf3  P
@r@
A
@  gfo3fS̓ wff#b ffyZ?'wf3f30n,߃;w+#4ܼbf[gf߷ p2
fOfP	c	

fAAXiP
 #W!fكs À +SfVQp g46fFCYQ  Y`@._f^\ g&GCffT[@u@EuPPu!uZ:PPE EPP runtime BIOS - Version 1.1  
 
;$;.;K;;;
<2<W<<<<<<<==	=A=wU .:]:.S\!.Q\ !r !R.Q\
ZpQR`!Pt<rt2[5$ԁ !Ȁ
  -;" {`5	$ X p[	.	uR x?uR]	] SUU .Vf	`&n ^zC  CWoV	al\Z uߧ
 J Us PSR{<r
 j ?G ^Аr
t ).>@= .@= 
   PQR3uA ԡ 3ZYXHP  SIMPLOiMOTOROLAaVPyVS~ЎHyɇ߸ Ws˻  >ɷ7>ɷ. ɷ% ɷ﷣@ɷ
SR &03-&Z[>ɷ>ɷɷՊ@01
@ t0+؋Òcɷ`ɷɷɷ~ɷɷv&3P M<S:Mt6= 6 
6^߃VxOʤ *~>Ӑ ʪ @ʰ~ʿ>ʰʰ
Jz 
0XʰH@	kʰ?	ʰ6`
ʰ-
ʰ$%ʰ~%ʿ%ʂ+ 
r)>&~X^ɐ藮"
`VQSQpaۊ`!`*uWt _u
fReKfOeH20/ *9ma VR\*txSR ڊZ[  Z[K  u?Ƞȭt%PF@a@0
ud8APjZ^`)u=u8qB@e
ً@詝p 2 ߒ襝UR)u<蠮u7Gt )OHtmڱ
lZ]PGb 
 s ]`Ks:KxqSQ3ɰYpްM M>rQ4wYs\@P( 3Z[x0"?=`"P3
ݸH 6_ٸG qS QL QK 	S
@pN pM ëc'
(<PdC'DoDDDD)EEP@ &` XW<r .C_Swt 
' t r
2[e 艬u0^r!<	rr&W  Qs" r2.C2& r $[!
sw r 9q	8 r 	&& rr	ô Ss+&' @>' ~osa$ sQ
u>[ W r%p$S r rq	A9 f" O$ pQ@	Pm ZmX1#t sA@ttadt`bpt t
@uQYÜP`
 lXr`QPPPtXdYQP0 t	` QXd$!<!t޳س  q&@tPGpB`{+ (`<u
 @&   >!@tA AuqP耨@u  ,r &w XV߁  0`O  r
 P<Fu uNs	 	uA
; fu	 X RtGTtu`6?FtEuUKrPRtKxGr t& 0R] Zz"&Duh8` h0 
Xuh9rX&  U au@ ϡt@Q!	 MrbKr
3NrNr蘘 d蚐 dx $& 8t ߗ  0zQX uSQ^ `b+H `*C: 8E801 P {@@X@3@*jC*YflraQms\j&D
V &Dt [zl 
B lr!0rlsukF. uk'kI$krOlsJcʊKZ SkkrMlr
#lruaykyoiZ2
 0
FFt N fF" B@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
F)tɋ r4F$
Ft+ F P   !VPXV@"1WPWR u	ZX_PRARZXfLL L	L  A " * Gxx  x y 1 " s*
x"x 0_   s w_X _y\[8y y `b é-T ËEtE
_U  er0 t
RrÀxf`qi2tW &  d_&E3ґB&U
&]@ &EP t ûlLu _&E@ !;f0 $PnP!  M 7M M    e fPff  @ fXtfUfp fSfPfQfRfVfWg]?rdf_f^fZfYfXf[f]ge333jrVd4Ad^;sgu` 
3 s M tAt<V rdDg}
^` VWq^gEdTg}ސ
}gE `tr	 	t}d8` W<ytu@DSo
`PfUf]3
?t `$u Ó' .;Gt ._
u fg6$+' +k@! A  B C SOPPBPIP7OEOg]苀M tM3Mwo ]Q
N uNBM 4   SQ>Mu5㟆ôԯ%r!<肠3ɸ  3 3Y[à%SRV&MXUߋXPЊt腯t# r>+ M<t<tYƝ< t3^Z )X_V  ' -u P	ir
- )Z۾QPo =c
u	MMM2~Àw*VR| 拴  t.PZ^PP)QPQQP .RPkBBX$JJ2J쯊BPKtJ Xu` o SQ V tA&q JZ  C@A du*uP= ]Xruŀ̀2	w
 hp(8SQ2<

2ۆQ.
$2rqd$<w0
u@ð  ` 0   @k  G#HdIPIfdfBJd́JK@{SJdMd5nH" J V1dP <d;]ttd|d]^  R 3
' ' FǠ  F/R3 .;v+GuBG
`_F/ {@@p% 	pXvNuQ
 	߀0ʕ NY%'
r0123456789ABCDEFS S׆[U uPxXdk]<t@e r
ted8D^uQPSQRWusw T^uq_ZY[X`|`h&
yt,ـt&M1&G&a{{`{ǯLAAAza+Íu 2pfȃtm
 Q ܈$FKuð`Qf
u	ۍY;YuS؀u-u)"4  AZ  Y3|ߊ$f
f`< [RWS22f0pr u 8s܊[_ZXfQWRfP
t)P0or  ff  ud8ufXZ_fYP f r03߃r: t+aߔ߿4 v 
t8t	
uY0	g&;t4g&Ct,g&Cf4!<vf  f٠}
g&:#C1	ВW޴r7fg&	f`r!f`Gag&O@` Nb O q,_f[ûb2p n l C  Ơ #  ^WȰPI2ð
:%,p5.'p$zø
 ꗊа{㗰	ܗ2՗s s	2 җ |0×輗 ۰	  z{22 	À tN :4}{vo
Z$ 
a$0F BM7$2
>ùVVVWTWWW
X.t'} :<u 2Bh:` h UO1qqsw9sdtAݠs
2 u"r  |  i .D .Dm~ `` X&&D aø0 м ` j &&E  }3Լ{~1kQPTJP !1XY`.\.T	ώǍ>L.L` `va.D`vaQPƌМ XXɎ6aTTTT zp@P "$1U-QRrοG      *:[%	` Gd d@",q Ga aO 
p 7Gr; rrs sq]
s"  
P b6r߀	 
R
 BC$PIR    rC0  w  X(00X  0  	 g
 0 
`e. W B$
_ϊ`
p aVW [S;[t[ 
[_^P3۹  2B Q_YPQ`ctAPXV.[ ʍ6 [.[^႐`q u # $t$?aQh@ & `r 3ur.Q\r3' $< u@LI<u	.Q\ u<  pP^$\   tupu	V $
4 ᒐS0@ /u7`O<u@ ذUNNNïO Oط0o$#!c#j^F^T^=^  M ְ6A@  " *;0 *
rB~68y Ay bnc  u`U ]EU{  ʋU  ")r t
rPef`tJRQW %  d_01&UY U &E! t o&]@ Z`%fa#_  u(<sW13.__.2_2NP'Xs/Q)p`ru..&+.	pp0@ t^P.&u @ u42..
t wPUU*}`*&u XY=3P A3.GP
XPwo *.?dorWȎKoEo_B?`````aaaaaa!a#a.a0aVS3.:E`u`F`JK`"@[^* UFP`2SF۹ S.N`F[CpN[QFN?tZ`sF2~ tY@p7 `  _ ø8 QdQ`dPAQ۰`0Q 3`$ $b!b*b5bDbWbnbb`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233Р|af>"  t" P a2ۊ( Ҋp ) ǊȊ&)  * 븊* >+#1 d>},0.- &) r.oPR u4t;6X6 6 o43
t,=
 
"=
 
0I5w<t<u F t< p s
Ê& 
<uaw\wWQwu& }` uݖg`!AY &
]Ø贑>Y6 FF;t2kd d.oddSa\"c` \0ba3ac]aR]膷D]E m]`[\!`\\M\\+t\ dI|\ZP\ Z{Z g}
3gE
 t "6D  ~[gu@sU I2
$t0d&E
3`    F˪	>]>
 SQf  VF! =s^(2߹  F  +^D!8u _#Nf^[WV?QCuKEP! P!0w $I^:u:\!u <rg= @Y[_S  [@f.+`hЍ45o@0[ݺй  Ga . .BN ]NĒ 2ʰ1ˀ{AǷւ   @   1PPRRoo4pӀ   _fV jYބupt u3N@fHVsu^aIunuB@N\p EShgtE u
gut!Qv
Lp`N  
]]f^QSWf@/ r)v0p!ufPs fXtā_[YfSf<t;f3f  t	f hu
utǳfyff[`
 3=afP fXu hVpۃx 拔 tcPt>KXSx$PaXr$fQWu!P$
BB 1JJq4HX^ZY[d|P` 
AMDK7P_NOW!, WfQfRfVP	߳f^fZfYQ 3tY.>i ~`iÊ@4uﴀô  S3ێۻr߁?4˰ t W8e 7jfR1,e_Q䄨uXûpvuTf` D Offt;  Qf3Yk,65 !vp˿ Kfaڀ_SYSID_  j _;UU  fPS^ۋ^&t` $ueG&uFtt[fX]x( z%O!O	N"  Ӳy fl f@f=  u2p fl P3Ҏx ȫXR`:Zd@@AIOBWBnjijkk  $PMM0Tr &m                                                                                                                                                                                                                                                                                                                                   
    S    -%  ;n$$`fwyhAC  儃D
 uj@ t%v v t ArMv .EsN-f-&A F'N- aύ6a  @ t	3!
tr ^	
F (|r
 	u^'t %1+	dj1*515_r0/5Mrr[o[
u< r<0s<"N@`  \

u' 
$nvf<0r
sus>.u.
I.
MȎ.}tj@&u |t
  ^!N%V#~sFPS2 r20ss6< s
	OtE""Lt*$Ot"#Ot}%" 2!)A
 ؀	.E?F2	
r]wsms1I9  <$u2 *<#"< u<@v{<%p!2 ÆUu
F!UǟF% &F~&=r&߀}vP8fRF'P^S^!S&EF'f&U&]rQ[P@ [fZ護sSQtP^^6wKAؠrf;	DE"d~(LuTMs fPf}3fXr1>-E.  .GTώǿL K./pPK3V#:Ttt<~'t9r0JQEE&Dq<DD@ % 5vߖJ$~6- 6u0fPfS&Mf.@f&]f&} 
[!
0'Qf謒  r}0rxLt迒rl 跒rdPtZ+cr@ O u~ (um-VƎދo^@tffm_ruLr Yr)8r$cr蚑r"Va	)rj!PTPQX rpw
u `fSfRWBt:ـ?f.EffffAUffsϱP-EMF F
tSuNff3fifV-f.WP*f8f'w*f'F'*2t*܊f
VvfV}v 4_fZFsQU n E]YRPXtUW:>8C_]s#r  1!ZRPR92B@ ǀ ZXQRюً go^ZYpBn`SQRX0% [F m `7h.> ďQ(&Q Z^N=rot
r`a r[v"> fKfa`, 3S5<s--O8L9
t" >G<}P#<Q$@ dZY[PQX hv   t`rzru3rij`wNurWu
p`dع ޠ
 Lr.Ǵt%ttt t	tCHa% s߀u~藎r	 2PRZF sH<t<)t<(u;ь>A u/WUߍ>)`]_34r0蓎Cyq`_^?a'c`&PSR 2Z[)ÉRFtN+P X7D	F
+9CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFFf[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP8F}fCF ~VvuKQfXr+tðP>@P3 Gp1 tff   Rf+¾IYÀL@Wweu$`Ύk2Dt
.4芆^G fF! PXG t<"u<"tlV3x 4|Q&?s0  s& p  &Gu` ` G`t&O &O`uR~p`f&G`TPa  AWQb bҵ  Wsa*,ZX7RQVW:W qtNᒀuu .!6a u/AŠ ?L	
 t,6pNoAOGA&&d&D&t&D3p;_^Y7XVQ
ﰟ} " uRPD
  ^Uqt' r.]ύ uя r.f%_ ff UCESqsf?fr ੇX  ņ1f!u%f#f   t	 ôLr`t s`à `a0ff#ffд f۹rpzfafVQ<t2f3Cr6
+f 0u g> ttr( 3ǇvP߃@ uY^Uj@݋+:`@44t?t
  r ʲ 88-t(@&r!f1u_t (d
Jj?t:R!4g&?AZ0fca`fR8t , tu
@u$2(H@:)@t'@u'-*tp(t
 /!-  t> fAu2Bdda33q 
t@  t}Q?Xri/p/B/RZ/rGU/Z3t@]$
Ê ],]$t P]ZnfVQ! 0fF~3YfcS0W]^]m]  ^8]$?]N]2?] ]/]@ \$
]	    SfP4fXpG	ش  [USQWfV~W  o _ W <5t^uf3 pf^_Y[rq Q0Qfûޱf FKtm
` J8u һQfVW_f 5 uց>oЎD@tpb_fb$W㔹 _T*u	 E 
yjt)Ӏut&  5& A)u&u#
u! p8W@ AU\ RtY pvMuG	0bu< u3vuOQtru1 t0> S:u@pM8*6R:EFu ?5E0P} 	QtTt̀t߀EtH71 F )t%> t:& tSuҲEU[u T3 j O E>I q u	PXuP3 t蟄LX랓tŐS%y9E utt0#)	&2!q =E3L*x3;r.Dv+W+Xuw432#*u!.ð-*1!	 2K<Gr<S 4,G߻.#]C%J u$
<.r!L> 24$`.AK2K#/PrPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10Ü   !ݲܜط$0<:rd uꝠ߆P P H   = @r q&@VV:СgfFf^0RyZÜSt	tv
 vt[`؎ ыh33  A þ/f`0:tE腙u '$
Ā`&aô#ĴĝfaRМQtĶ$t$< ȋº `q u1pt)V6L,ĸ #&<$Щ м  GV.>pE×i@ ؋r d۰t4t p掊V20 SRW*OIr 2 |`p3_ZRWQ,<v@s Y r3O;`Q3ɐ!RQWSP b	)< uX Q쨀t_Y͝l !`2sX Jt	u_RX( V_ m 7	XP)[_YZÃU2<UuX

DYJBBǃ   brT^E
!  BP ^߃32
X
u	߶ ت *ê`VWQP Dt!WQ0:t
Tu8v
Y_PY_XY_^ _SM_ P_DMI_   #9s F +XPUv FF !Ff ]X"X?
W8 @SR3i &g +pa 
u
fN@  ]ϰ撧2ðq ݴt S\8&&G pGnGP    [  N!@    P@@\&\p ~F0 ]
..c3 ( иA_  P
C@@ XWP C_<w3t*p O $` !? & 0._{Q@`j QX2hQ$3n1    R0K۳4!fr YfQ\fYgǝ[߸ <a3]Ou r 2QfPS=Au@u;Áp u39 u+ҁ?wufP@u UXu
_ff`< t``%f`{At{Nʹ|So{_ k@Q  ~{{ o{Kǜ|!qO C{P r{_{Q   ~A+{op446RfW. umf3gf&
f=SCAFtV1G t"0fff Wu_f(#3tfPfPfXf_P_32_p9  
zzOّz(4zz,az%´+޼b{VWv{%t{* guzȼv|o,軼w|Kf`{%{1	{x %r` +l$b{ r<
%	*P_' @oTO xyOy er$DIsL MT[p.øJzNfUfQ ufVK^NrMu gfm@ N V Fu(gfFffffMufY2 Yf]Ë< 3R+fQSfVffLfT6DfLMf^[fYrXt	A3PXføMM߸Np O?MfS0/UfWfPMt3   fRfZQ_f])^Yf[PfWMc{tQ!IUPXY fAlP0R YXt
 t$Ct t!- v _n7M1X(RfV\t  \(042V{f!nLw#t   r $r	 @|f^ðU; QWVwy^_YSQV3
Ê^Y` jV e a  X FfV1fffa@H.6fff;w	rf;w %AZ.- An"  ugmf%}3Y/aBRJ@u$ : :ذ1JPo0|J= <rqph3f@ Pl
ffʝ  off   f?-   laRW >%3&G;r_Z  <%<t   љS& t	t`Q fpW   d@    $@P\fYX4Z4f4f  0h hg&>tq r 	r
  u f_cbi^f$f tt,$
g&"Fg&
FI*$
g&#Fg&FJ	;fo#F	poPufa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`
t~g&`
g&@
p
 
u
Gg& 
T|`} 2~3Rf\&^Vq\QUÃ3ɍ6.L0.:Ls&`U'.D '.L's` 2`r2W 2~P u K렐^t
`W3t 3t
u!=FQH3ұ@Uu s t>-.| .D u} P J}uL?v   e3puv`bW~_tURQRU`@K2YZ6	u>^
 .D P@+ t#V%L%^ 
%.L% ]Å QV | Yso.pu0	 t	&Uu"r ώǍ>L |  Êöi.f.|fF  X%.|Y%߿L\9:PQW 3ۍ#_~Hat~i
/g uRWf;rf`Ȁvs'`1 u: t-Aw(@tD<u u  TfaUQ	U F @ E][__
<t~`Y]}p4ó1PQRbfv2 ^~Rɓ	sr`	x tt -  P	~  i09`KSr=s  "#@'@r@n 
`Nf?f3u
P!  f3gfF!ds"yP@ffڀ^03&fPQXYqԑ)YaP'уЎ@98 #	f<t` ? u#f$!߯AP ~]faQR3Ɇ 
tw ZYJB"<t$
tAJBՄqpvBa{{ݯ *qݰ JHbIs@P@]FF
]X `j . j v
@)Mf.N. 耱tI4~r@5p3؊^)1a`uw t&Du .⭋^^; a.@t&ڃ`ԣ.^2 uȎ@S6t6^2~Q.  @ PSFݻg`'.:tX._П`P?
Xu!P?<Xu @Pҁt?a`
  P/@/aP2Xr-s(@r3H r  rR VvF\r:Gs5&DC Hrfy苡_FÉF(t S^$}:u [r
F&F$%&=vHH&
D0&d̠u rcwuu
	A	πϠa&DB êĪǪo૽AT0	VcH UrpUsʁ `-s8u fqtw
E$藀uEab&G)
V Nh8Kr>u rG Po3F) r\ {r=H r8{QWss#

Rr
3 s@M1 |#k#'F("r#謲Qlr@rk20!0p o×!r"~!F( Q'&dK}0#V&Ơf)&t_ N.cD fX QE QRfl f@f=  uf3p fl >t@&? ϰ  Sd `4GdPQ3 t1G7u4rdr
` r`To 校F X @F$$<r$:u s
jîp_ _A$ 
   @`
  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&!Ѐ E 6F (@$3'E&f$`
ĢF f%R$PG- ;B(FGq1ø fF" PXۋN8NwN 4o2NEEEi0(`00spE/ mPEސB
 r
fQ_mruE贀fY_/++U+sÑ &u{tbrq? V/QB  BY^	G $s
3
P&u3`~ dD@
r
%utàt <q66V&TЕup 
* &u^"Ǵ  w  xQPXuN%&:Lr * r$ P @uP<utC.@   ; E qs2pcC$<@[t22P !$!$qXw= [[>ĺ"CP[BK<PY
`S[PS3[
u ~XaSQRsɄ3ɺr8rZY[PT83t  `88fPAMS3VW v0   u
Po
  	˻{P7rrPɍvpF0 & O 
 30&OWˁFUWn覚_]v
 {` {_q[w 1uޟIp 7 MB RW02
% D -&= @
&FG酰u  ru#' Ǧ&P
`RJ4aZf3&
 tf&B&f 2ffP3_Z	GF  u2D$F lsN~ t
Sn@[=Nu#PӀP& 9zu).t

q6pWVR-&`%P<u̃ .&P2^_tRVW33۹ e C r~eDfe׉T
@  eD   h5# ̸ Ῐ..]u "e\ uХ ._^ZXW   hͳfِD ;t.Efր fP U
8_
 PB>I%   N8 % @ % A a  _ Ag   d z s  P "Bp  fQWh f R^zf8hP`PL`  f   Hn  $p`| f0
Vā rMf[5f 0ff% f/ff  ffX2ﴇ_jRfxffú Y5Z`PލXfZ0fS|d```_f0d@rH=
f<~f	QPRef%0

 aDpB_B3E<@19:<Y`f1ftm" QBY  +fhfaQfRWf ff fRf3ֿff"tf fZfOu_f:Wry^tUp^Ogpyc^1rQ[L G B = 8 3 . ) $    ۷ƷM c4QjpD@YÀ'B2ǹ!u"!}FChC _f6E_f.wQ1.Pp   ȿvDt vf$ݸ #%@f ? fgf&fXq APffa !0ω	d bfPS ػ@1f.F?O#&:.Ff`袪uh酚` h uhՍaúB ! $%0Ü裿.F :!型(.G_q¯a==>W.}
u.:tL u% t>JrS-.[t D.[u t	t_M_1EfUv"v` t Ar`Mw@ .V PXF
Xf]h@ &A 2jG@!PpмurЪЈ\ôVĂ
	=V._6# .t.I.
Lj@ps& { |0u 
^SV#p.d.$ʋд^[	觞ã3j0rcOt` 	OtOtLtDt
tt

1u	:
.<<
.}h $ BÁUu	_UAq_SfQR#PGrp
fL?\P;Zf fP<r|wfD0u
 vuIp_SQVWUuP؎&Br& ȎXߋ,> ..>@u 
Pa 3PB &Gݾ&G $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]_^ &?sa s@ \`b 
 f`NG`e fEA[ff@ 3SRWP7޲ XraȢEV(XLuRE<sfQ@M}3 Pr/>-E.  EGώǿL _
./17p;[M
_Z[Q.>u tG`Fr=
.EP .&D>a@A%50&Vg
َɎٍ6-ʀCqYSRt5ێËfQf{S.q&GФ@f&_f&_ - Y21[fUfBSsQSU*f]ÖT'  G y   y ?" ËP t
$貍rg`tW   d_ajǏ@ q @ F0 vP  _ +& Q@ w   @ Q Q c t @ 
 G @ 9 U    & 	=iHewlett-Packard 68DTT Ver. F.0D 11/22/2005pU ]  Z  l ~]@ uq oKBC
sion XX.XX  
 
  _ 	o~A`}#  } @P " ƐU10 AMD(R)      Internal L1 Cachea bi2e	
   6PC CARD-Slot 
 16	 www.hp.com  
 `   |ӡ 

~
  ! DIMM #1(28"tS
~6)"Rpbs "@],No bat@y'+"p
/_PSWQ  Gkt7PwY_|*P$$t"@t 
 ް  XP{JXXP@  t+. s#. sXPa$&  ~ &XX  =o spڋQfP SQ  2SjY[$
juFf 
۠[N8tSFt׻ 0 z Df t0  @ t"'  t `Q t	y fXSaRV s Z2
Z
H
i@
$ow4 tNff`4eAPu4fafFoD f:2`tfFP`^D _ s fКWzf_f3y#"fF$wF(F,q0f3҃rBrf-5fv,v0hfN,- v(X(@$иPN$fFfV fNuf2N t
ffFDlf3fpKN xfWր  ЃfYf#f#fܐ
0 fHfVPf#f@f+f;FLvLfFPf)FL%	GtPf@bv駎AfI!)m fBwf*@+f
`fK
X7f%	G -sfA d!`
;Vt
fAP
Q
y6"8  f%"   @"	 "خf'F 00\2FR) !.P fR@? ff  ffZ PQRW_ZY`ĊӶt"t+f
f[CPͳ  SWf 2`c iFY~f fa ?0 _[1	?4B3/@ h }09u
 @ @ÜP8 _ >PQɩI> "K0q2 B%a Wf`f߸ ;<uf10t f.@v fWf @f赲03002Efanӿ3x	 fa3lt ?   @"f2%<u 	= r= v A&f~`@cQ8 YQXYŀv"y<v.kfGfRZCаf{@-8P*LnX
x]0]*U5P`S)\f.L @Z?/ZP(

fHu@:и\bx	  VX   PJ0  > q ?M0}C	@f350/  tf;/f%ދE&̰ C9 􀀄A p0U( π`'d^ F˂R1ʀgfZ
ע5R 7
QdB^!fXt f !4SfRfu`D[[f40T!T,1	 `;s% Df{Au.T  SfWp3P* @X Zf<᫔CSϠ$!A  FfobTϣ51XݠˇfϋpS# 
ĊËooag (,_gמ(&  .(gURfQvV֠uLfQ2=fA<t1 `eQ !ϱ n 0Rr.V sfYZ]ÀT߆f;0Nf;fZzÐOWf!rfr?f+Zar
!.r#|s
;ua

<Q\GM	wrrڑBPmXPr Pp$Ss[OBMI>E{/JOAZH?[f!ufXߴE)t ft/+f"#fSQ< tfnA۴D2"DǥUYt?$7 
3#tcˤab0
-@TUľ^WV@ fSP~WB Q Y_W
t^plfst6]V! <5u G	F^B^= tys.
<5 = 
u>
r Xf[2PXo^2YcvWfVf` t
P E}r&< u P MȐB S f^b$Yô PXs0#Ĳ##a$Q$!$P)
u $^!ð)  hU
  $
Ǌ O $ v$~~rs Z3+p\t	`
S)Yð÷Q3r+3&蠽QtFQ!tt	*tEPQS&"
ǆ[w <t<!t
<P	<*`R4

	`ZQRgs`-P ZYpt ֲ
 ) 7VP֎ލvS<û	 [rapX2F^a Wð!B< ݆)VfW< u؃ tFr
D1. 0nPK`_.Y3|
u|	 t0  $<<q<
1{^À#"  / % %" !4*ZPu `AbXð"MQVWP 
 5Xg_^YaQ䐸P2b4 "QB2ʁyCm ^
P'R4#f1ðW52	R"5 +S,ëT,ՠ Y9@Zr:./s&U;Ü= s r_sD
F`PS ){ _ ߸^ ZY[XSQwt}. ! !$1XY[ u APdQ\;ˁPQN 3۸ E `SQW uf<0 _``߻ Ua(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457
t Pu v5u t
&  `
x_t^t]t\7ustF5R3< v
<ar5<{s1$PɎ Xu2ôr2հѾr9_2.S ukq G$!wu@t0<zw, 덋 
t
;
	t
w
 b2]kS?J, E ?G@2q)Pı
 t"< t߀r0r	
2vPQ@s	} J	eE=C HP   P.Nuaa@uXXZXp! '/ oLPXŻ uM  M N N O S / SQ  @TU	 Y
 S S@1APSC  R LRQ SR0RS ST`RU xRV W|RWXYAUZ[\1]^_  d` da db Qec'ed!eqf }ZZZYY&ZHZY^kKclfP@ ظ䠄t"
桰   u$! !tp &k X(    Z 0ߠ`p	!B  0lFpoypOIEMAG  IZ P      	{
  `# HDA-L*DBs A-E r Cu 0USB-FLr CD Hs LS Intnl .CI-%q ` 0&% eO  ֨ H	~P 	/` <M ` c!F	  ?CD001EL TORITO SPECIFICATION Qf`g t/Ku (v$
v$vvvfaVМvt
v$tº^Ѓqf`q u'~q'Knv $hq~v$^vfas4q  tTTTT%  A    G  0G  " y" P3@qb KiQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPkXPu3;uCf N  }~U fJMO{N# f `dâf>  uf @  > t&sr_VuѳPp  ff+fQf׸@YrfǳQ	ZfXq>uIf s@
f׋6ǁ0 urr>@SWfS"f[\r 44p3;4 O7  K SQuP x$@X锰u^@ @h{XeA$KXHPtu
蕨I4
<RVWf1.1V17 cPQ<VV<W0U Pa T `afP >pf 6
s >upN?`1>(-" +*.'.'`&R"qu`a ֱ a@`_^Z  @"QQWVV_ ؾ ^_YȎ>ƶSpr`"uP; W3r%[U׋  r.]''a /  'ڃU's'O9!@B  zh_ܝku`&ݣH {ݙ݅ݢii~,ߺdA'D	'2>6@J?T'^@ ߿fW@3sAQ<M,u#9:p f3gf&ff=SCAF2_U< u
 	<! F ]  <w&< t'V3ɊȈCF`  ^ t	;  AװVV<v^.
tݬ" B0uU  #]URP Xs.V Ou0]A ! VZ g ee뙾"b =㽍뗍<fRĸZ&"'% Quh .:<t.|$2ɵ"YQ"  H .6:3^p$ q 3 3Ҵ./@32pƀnuonRp'T`x uuOCǿ<2Uf]
 N]fUfPPfXZ+ f]fff]rPm`n  PR@ZX<0  !$    pTPQ^RPQMX0 <u
p s귄3ɺ*RP.
`.afV`fa
uU	r r" s  > ;0A۱af^p=`@*2Z$ԉNT@׎Ǎ~WF$
&FG &U_ؠ
	!_a PVa<^XR gZb`$0Z6G CPu EfPf=<01DfX  W~   wfP IW0j3fPRf  f= t5fx$ L$ $<u	 68.< >_!<
D<tNTG  r%"   u޿_ rN r@@9 vPY3ɃdtAaZ01tjguSaP3ۃt~C Ί96XP-*# aa
rd
xrh
crQȷXf 1264r$< 'bf"f<R, + -ff31 0<GGE޲H w\ ;SRR3F2۰S)"fV$

t1TrTû  -@ t@ȺR`Qt@ȰPBP $?@SHA)
 ]X 
?Zf[fX`<`ѿWfV g&?tG_fPfMQL	g&Gj u4#_f+cf<0tfD0
$g&0?fh x f  *@3 $r `%cX
P  
LP 
P L
,	P Q   
@Q @

,P `
	 " 
@p 
Q   P0 @ P"S ]f^pe]@	e@ͦ00s	` d P ܿ     ^8  @g-<glh  !d 	a@	 འ!  	h@ p@  q* Ӟ.:f tduP.f] .@w6  `3$Uu0,&?+aÍ>.}
tp 	
t>apa.:U@ǀsV tMRr+Z|p  u_$ft}^^@Q | Ys3С*Vh -| ^t
 uUPcs)t!rRڻ۵u3ێێZ
t	 u
u
 H5uP@s+XPt qVڰ`۲4zf
! ` 8 O  ПS%` +ð ;w[0 ~~~~l|8 8| 8|8||  << p/  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z.>>`~~<pff f { >c8ll8Mx
~~p Q pp	}	 0``<>$ff$P?ѥ ;0xx ?0 lllAll  l 0|x@0f 8l8vv ``? 0```0 @  O<<f0D 0D{ 0  || 0p0  x8`̃ <l 8w`p  Jx@ |	pH `a
 
|x  ff|fcf ll bhxhb `f3> @p x p
pflxlf bf  ΀ 8ll8` xxp$ x0  Px ƌ2 xp``x  xa"1x -w0`wx|`` -p :8l`0
pn v!`lv-f0 x`b  `g  !s vf' 0|004-!)*`2
6 	p&0d 00l1B  0 v
o u5f SvN .X2[]`g i &  D
d`̎@að
 r
R3ҿu 0eZa Tj㍲AE eMA9Y.nSS`  wAa( 3
`P[u N <tDZQY
 Ir8r5r
2:6 v&Z aP ۆf PCI01 ISA`#+T DT03COMPAQꊙ 11/22/05  6 )    F10_  gm؎h Ћ0`h+3f  h L!$F10fPfSfQfRfVfWUfUCES>d  fB  fd  td  t} sStp@p @t[-P @d@`t 	f  _ t
Q @@  Afdff	 3ua 6e< tf3
@d>eT   } h> ;f `ff3A3ݩ@!t
    2ѩ 1@b@Pa@f00tf p tQEpYV ^ G`]f_f^fZfYf[fX[fVP3>:g t
y	RC su!&:gfXf^PVW 3W  `_t
r
>d_^X \ɰ۾ݸҧرκ͵ܝ-.D_D(|1 8     y60  ``8~ "!AC9>9  r: @'Yar;  @<@?=@ &c@$	-A	I!!ư
0	A		( )))**LLH#E$$E~B ~B	yP
$$$@ $	  >o""ZF!ndPd  #<r sM` q!AhgxR'y	&2

	{~  8 0 pU" V	

@T 1 4YcI Te`es"T$ p A$((DD"p'3_&$$Dc&&'$A * Rs[^̃ZbgAvijwt@CVXeɊ\܃fBNۑݒ肩ăHHoזύXIAOԂeLǎphdo@\Lu͍}JT|FؖcInI`Fڏڍ߃Os\gpjځBymG񂪓r݂OڕKvxmȂ튮xtԂÃ_FsʌxƂׂ݉}֎~HS\zԕzfmQ{V͈vdь`YilWǉE십ċNUiTivIىe^qlӔC~tE֖{pKrWoYMߏϏ[xbÅ - @I 	i D    ?K6" 
 P 0 `  1!!#"& pT0	~|u
  ?0Fa% p? ߘ  ! x  
 )  f @ 	! ( 02    `00v
dE`<"F P acpF`"08D
"@" dqm   UP W F  >"6>' u'@  p?~!BC ""!B'  /!B#b&2 #		`   ",$)a
LX#>1p1@/@@a!2 # $ 4#Bft,0G<w4&0`  7q_.pC {"t 8Á*0 H :: 
	`0 P $&# >!-8 o &   <| D~D D<  B f<,$$0$l=   E@ ?3` <?"#!!  2@ `4 	=4B 8p" ` !3p@BI?"K` HX;6-@6B ."Dk5bD@'qA |a  %rm  202 G " !,a,IDa  1$Q$7$0T ` @@` 0!cc) $2&f# `P0;@xxPa) c=ANxpP!g  V!bE  66@@`)X0$x|pTT T8PWJU- 2x 4V0 B`$c  F $484(d(lD$&1< ?! ?&!<? !!# f4cc?q|e&f0 q"c ,`G!-cG,t& H.$9`0p6ùi *Y @ rdd4$B2'  `dd^Ii&0rIP3
  rrM@^@&"  #2Bb"6T$-` F@@` 80Fpqo0 _0@
O$`[|s9zNHm|%o38"5U QHU' &@a! 3?! @ !d!3#L2b" a?1`		
	P21"`ni9$i$	$	`  ""373aZ?Hfx?0#r$ !"*22SHi)?""?"!  f 䀒'4^E4`@K$ z! 
ZxR=)`  ?` 09 "} 8F  8R)C)E+D:<  = ~P<  b <$  '  |D!  D| 4pN"N >!R??$C @ 1bp΃#1φc"r< ~ < a   <$$$= ??d)),?4+fIjA^'0p6( g!}@  q6"
00#@@g3@0gp00b8!$&? T@ 2?$?$?b < |@<ѿb =$! <`i0b64~
w*  hH"pe P" ~  <@ D=as<$" A>`m\5' '"   
8hWXR8 p2qq2DRD" +TqrC8`  ddf ;`
Pd,%}IHT>! @AVD"p 
 .:23V""&    BpՓ'I2  "2"R"   @!  0`p ! H  eDPn6?eјބ/$$~(3H2~RHH~HH ~"""6_= 6q"c  2"&	$  c2v`&"b4	!?e %"@P& $ 2
EBF0L 0j,?$&""  0p	 x ῤ	#`4 c}ހ߀ cPpP !
( H=|4zQ0i#!=0 `RuywWp7  H 41b2C"cy(@?`tx<0#r`HZ( (	&?0{< 0 ?8l>%&}23
b2w1##n0ˠɀʃ  !F$͜F$?A]%aDh|0  1  A   D"1t    7  "rH0 avu.1? c0EEga0Si"DC 8u@`⻈A a I8F3Kl 
 PeO=0 !܀0d@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>|A h`\/`o  +pq]  1a2@=  48	  6 P>T  pbL D@jBf,892k&a"hb! 3"&,0@@QHD% uI }PI<x EF""srr: 8|	(9H ;)*;*$*%+8 5 TT5Vd"kp ja`) l(d zǸ%OF`JK@d& f놣Hj Ǡ 	v ~*H  jK6cDCc,8x <?~!B>C  #" e F00{o p8u` "***" /"$'$&*"$"$ $? zC@0``Sx?~$BdB  a B
BB~11("&D$(-`B ,!!Aò
 ؀=I H<H$H$_I$=@ @l 4R$ze XUS R Pr sOAOabp! 3 ?$$$5d$Dd0z< ~   P  $D$=,NGDAT! 2@o@2D"/$y,(8p(lqD?  /"?(/(/(hOX `boC %!A"	NNQvC= ?^ pk 0*0  ""bp $ & "  q?0 
_+Y @WF8)
#U(0q0UR?$P?			?R?" N4e߰8

 ӑPcp 0@	~! y 	 	 ! g>"W"	& ">f?j,`!D~ =   < % *8= @|D< !!"!"="?;@ BF\p8@h@! A  Cb	HHHd,$|$TdT?DT ʌC  p>?   $ '$!$34, g AI $&#f!  0b6@}2~Z*\*jI_0 Bh5)`H0	    	  a `  $# '!ZS҄YYkp 2^1 zsJ0A4 6  B F>lxPXHL0F`Cmg@50` 0$lH UIHUH~HHQHU~{HA  C!a`I8 2bb)) ?()()~?H!!!aGc#j40Gu zR! s"P7%` `hb(  6 p" ">͢as>>b 2  "&"cb@ Jxn   <1d3?"a7, (! ~I	))iIx	1!c @>~""#"b>2Г>A  ? O1@  ? `2 ? ?$DX0b)+*{I#F(velb $T"[P?"#
 1pxbp#|  80 S#Q8#a}'t8<
S`' `{  > "~&%,?(l)$ }-S ~ ^ "ʇK    '2R2RR (Bb.	4d0&d ""p bB ?~b
(L`A%ɕgc.ICCa}m8@T;l@lEm"dTaxPQ4̣r	(	)	) ( )H	{ ?~"! "2&4?60ba0`#ƫR 6"iD' J8@ Z   @0 B|" b?(HD?>!"? l?" p?.a YY  x 	 `p1x@3"fd B]|q"q@Acp>p@$	,	(	88(2l"Ff 3
 D(z

@ 
k~  p }#@6"4&0PPP`?@   `   uUp cu`  `	 `0 ..&+S.$+mlp "+  [<u.&+ b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.+` a2P 膅SP!bRV^Zu
`R\ts 2ƃǡ G׿
a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F¹- u 2 󥪪4.>++u_ . 2 13 `.+&1 u2CQ2P Y*2Ȱ&P a, RDr
.,+.-+PSR  && Z[X ` Op@-p
oo.6V+FʑF!.WtOBT_G-p
QR.6"+ʊƳP ZY[X  "2价S2OsP2 sP
XÃ <r<0 <rp1@.+  0+.&@0u'2!\0+3!˫a0.6X+.>V+P20ዿX2$CFAPwQRW ((_ZYX. 2.9 t..+X+A	#+D<u<R~aN<P<S<0<<<ހ<û<`< T<@<.>(+ t3ػ@ .&+G.(+\+O#0.&+.(;+p&`X@Y 0..X+.Z+0;Pp2 O X:XUFN
ȋNu	F] S f
 [ SV?F
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M	> tj6hyjF`d&  hE\>?od% = ?@j#2J	fbfffWػ
Nddm1f>d^j_tt$Q_		>	d		A	
aUf	ZD@xUE
C
T5g2Hx
!=
SF "R
UQgdېB ''F')gdi#+,+y"z$hx&G
XWdx2bY[dt;j91606oF688L6dDjQd$ }fh  n; tAt=dtfh jnd$d.yqtfhUcL@TA
 >tSXft3 tE>Be tjhBefjhI蜀
>Ҡ6%j hdp1t2>f tffhqMog t+gS *$f3f
о~f PFPhehgn" ARQhC!3F``HS=#~2he蓴h ePNod V01&	hf@OƀBaFsh[hH	xAVdYVd`KCBhbFP9@  j>h!		`#fhgbQYI|RhMdf4
SMdT
OY0)5%gh;01!3!? V=F!!*_hgmhDO	P2D	'2L^_ 2FFDg^ F&<
uI) u&*`&8XgtFFP9 1FOuÀы F FIuFp*1 F*+҉FV$h+;u;uà%h% ;Fu	;V@á$hG2@&A99(h% 
Ð)L*|	(
 WPS
`Ffj h SC5(-{ wf f0$h0s!6 &b&djLofPa0~@[j`Paj FPI^`F*"aPV=ut_ V!  )#vGF|ǯ V026S|[b h &Ч F GP	FNuFG0:?7 

yOj,HF eFaAS)  4"d=0u
&d&deyF´2N 1p a{>b
0E2
2&d% +1d1d 
+d?@#⼎A_uo"jFmu&d6d BF92
!.r4373ȉ` QR	d`2	2&b% b1bj_R1˩3p%2p%  jARi 	aI
Fubh~32d%djD
jC%* 
@	
H
 	N

g3
1,$ jiRjYM	~d%jSB
+ +hL~`h$eRP0qUV//@/dj~a*&d	RBHx탄t5 h8@epP__Ft@#t#!y
"s&5@z+|&dDdT!>@&>d`Gw`?&@!<  OA=
`& &O wg M߀0<O7OqW Xapm
b  f@ q趿[d t}J2P2a;0m=o=b]!!@ ^PpкF$h^F  ^F&F~
r$Af?&f &X` &e^@rhB@ gn@ d eW@ Ҁ f# r
.Q"{@V`E  p  V6`^aF@t 'te Y(FuM&ff WXf )8~ʀt ۻ!@t ߃ߝ V
U+%@@1if*	a qt*E)!O
euUԑ+~ 20`& e  !hd!r΀&ddoֶotD @)".DcF{00`  &dw.j `j ΂ 3
vB +#r]S|F3BP
-`B&g'&g &g|5&ۣ +&C!&.&wgd rplfhJ YYM2>dq"]0>Tf&UfFVDAVdafe	s$U2 aD ";$MrOvz`S:Qup1Tf c^UfFC?@t#RCj$	p=ggۭTf$ < u @<@/""r!ø`" g1 `bv)p94&14g׎(4L(v5a2]f3uk L Up
t%r ҋF^Nr'~#tp  u^    % F )a^  ~u +ËFVVF6Ƃ6~ r~wt` t uFPfv
F0V32,ӽpIuqu_SI]][t

1 ^^t۸L~ f#$ F@B F~P|v^ KF NFFV~^ 3NHt@HtcH P )A-bh0V6^F&߀? u/,dv:A8[A0ce&mhhdΐ2Bbc ;3dvi1dgm`
NNFQ690fFF81hF濉FPR1h_S^R/GFPvF1hFgmP?dbP覑?FPNQBq*0Vk.@%`&V0i<Ht	HtHt7 h@ .  &>b } ~|m  p,b+P ~
-d3F" @	` r hEG  @QQqb6 gh (Fqb-
4&-p.8F.F4+ffP!KF7Ob%p^7F)C!T`@KL6!;F׊F9 9~2|FtFCPW^]
0O~ O	H>#M _ H RVBFQC940@~ t;F4.F4K
?z uWV~vN^İYPYS
J@
^_C
"j(c
lj`


[t ,md(|WVvԋCNsODԠEHv\`\~(|W~adt_~@u"`w#}HaB^F&WN} 
 
%.0\o!u@##Y PfPqDiaҶ
%%		 	F*Pg	}`	
g<d-UWVv<`~P F
&GFq;&'d*V~oʋv!^PFG>Iub ^&^&8t #^^?}R!#ù
 0GF N% }ۋp,-Ar  ~s԰ NFN<+;u0g}03ɋF@ AFC&P0LfF ~ЁЋsG^Al{F  ~
vЂJLD
CVV,GV~^&FIa&$a)6F"Q2d% 1p Q>?R@#b= 9ڜdo~*

_Z#3b%+1 1bj`R:#	2&bW% 2d% {1 1djA 	a"(K,32d%djD	2&d% E
	C
_	@H?

N
	S 
	 UV@ug3pΠ1 jiQaryYBryEf@zF	x&$

&d_dRfa1f   ef	 fZ  h Vdgm؃`2~Д&2 D ;dMdFrC6J3y0 V!>)FRZZSS
B3z3O~Qks}  Lgb`q>j6hT`JjFd M<>$?@#d,(K 190UEo18L^

!}j`fbf	ff؃'}ZrfdPXx5
A@MA \
a$;QDVxrE$U
C4
?
*JH_!Mm"NL2
Uad[B ڊ!$SpF "4%g%i銀J'BY%d//-7F  ݁?jh!cprGWVvQ͋ދ~ &F<t<
b#rF*;b}7!y~tF&8tFu|t<ro2V0^u	A(|Ð ~Pfh#   0F;rF ߀f?* F p F*N* vF}P0Gv
u+Dg^F Щ FoOup߈G	bfTg &Tgvdtbgq0{  2 &%h22`% u"$h$<P2$h%$h1&hu8&q= +ɉN3$h33 Љ  au(h$<u~(h% bФu&)
u]f2 % D	3u 
uB
 )
u/,Au#aq(*h%FO2 eDgEgFg GgHg	IgJgKg
LgMgNgOgPgQgRgXaҸL2 f{3: f |90`ujvRP g- 0`FB~2|~ȸ1~`F  p ~ uFegm
 f jtWуV 0`FRvpF@ b*J*p
N?vQWV򐹃FFP
|F؊f-ƾh I
%F܊f- hF֊ft@ t؉FߪjRvv!h 0-~St` suٶP0M2muhLhD I~Ph FފfPQFf- juɁB:CF0F1F2F3F4F5F6F7 8F9FAFBFDFEFF~ƱƹP_؊P11S0fb;<^  'O6@AaPj,*`
- ek)@PP NV[[G|]] ]<]2d$0   Qw$j)ѭg|`
C_feQlA$hЎwf`pՏU;*+- t*-} t94 !R13q$RFaR }O&COboLF 40#"7g
1-a1  GE"t/ 3|
/@+F+P-RQw5pWd qa"$ 1@v$h/ب kbP(LFPB	j)"#M12#"#9AD/]LDE WV3 W$^&@RFG|p3X6 2 R& F%Wq`O rҍj7<"JW>d bӆebb6  &=  t@M[_ Ft @O 
"Dg#-//


	
a@yu	N L0Ĵ &&TV@oS~ t'jpFI  t/ u#''jfy_qpt= tU?@>u
f&Xf"f2Xf% P-Xf  t&f1`ul À&l igdhg fhVfffkf0hepb@bAbdժ\euo[h hJ9| Zs{p:r@jИhz ^ۢrZB 		蚲
荂Q  wFPP L   vA0LAZ $< w^reW bA5Ӏ>et#b}ŀ&da
ud&d	>be u|K`  (Pa  Tq{rcadW~
Wh#!$Rq=
u 4ߐc 
k4UV T$TV TܢTqBb*`F&? tl(u(&|Ru!p )u&DPƋV@ p*A.tu'mu )uP&DDP?DPpq=FBݔ_fj!
  w `  	   !  -Eq3~  A4 u &d`E Z>`tfHj j T3= H/ td-
t]-! - ; - p  r= M - -  -P Q   8Vۋ  &9w&EU 6`  VV; @%6Dˠ   9~ H  ;p! r
f
>~ K{Āv&@u?Pe`^; @1v״ 3Vfjth  <Тp 2`0 "g ÈvV>B   vwV*F^ ɀ[P% 
Pp h
> h  RaNF
+F@0F!vvo ´	F2`ߋNFm@ zj av0CFPNQ=`*PqK`VW  p 3_^e 㚠2`%  @SᜊF`
F2`AF.
%
;Fk|!% _F@P!]!Vv轱`NP@FDt&@A0#F쁄Tg~u< t (F7 PF@5
 f  * BPb~9v*VA 7p2Ɗ* ufU  ߋVn'] ᲃ> t`ur3NF` `N`^&8tG[ vNً! ؉^GF
&Ft^ 3G  +tp
V^% = @ʃ@A3t`߰@!A;wȀ>
 u31&A *;t{r1A 
*FD0 F
tҭ t" ؾ`fp
V=O`2P.B@Ҁ?Vu	T.SEHDMa!E'(EzrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 uo31~^
AߋF9߽G
uN3~(~ {0u j  F;S|;pUC \fUVNߋVv<%tF` u DD^ù
0NÈ u0+1WKWVX ]V^tQrJ;v~ F^F&uF$=IW\qQb]R}  P+΋э8sYdvva!V0N&8 uN= tp&@*k®0AtA߱ Gf6o !
`f_+IQ@bkqtCTNiS
ʐ kj ##еzw,`j&F3v~Bvq0Q&ğ o0.b;~ANuǋv| 0dFuAz
 VfP0VF cbPQP F ~ ~
~h3ҋ9 P{W t40hPǰvePɰq 	ptGW5"p j9Fu
0_sPK vb#5@jFVّЙ0NvD"F9F}+F- P@!b' $q YFF`%pT"knT\QPEPPPPAAjP:! fh  赁39> ~jy/00*9>u	A
@0
A/\&7q6%'@2)
G;|2*&_ P c`8(F0
A
j ]Q_j VNVRP=AQda'P? <nCtbc E +FFVda#
0UcSpbig 0aDPdQ虡hQ	5Q`,+F+Ѡ`M*2Y Rg@=DI=ӁF3@**A;}Rvs`V6r1qyg*@F;vwPW4C
sR14+

uSK#aQCgPedD$A84	PeV輡V!ɖ!C&-24hQRptY~AS;}`=y#DȰdf&D&T030`~
P  q &Fި@u[] СFtdF;@Ɛ]q<ЁN b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~ $	;FF	_F|	} t~0Vg~PtOC~ tG\'F
t/* F T9F}\LF ;F~AZM
~~2G+F50%&L
q DFF ^0 ) Ϡf@`	PXf@PF^U^EAgT l2s|Pxb<FA@ o0H&v7QvFv;FՍ\Pɒ #R@~'U 3'tsF+FJFHfh iR( tTT4v .9~4aWFek^6,+F!}=pu.trPoq &OC@ +σQk._+ǀ
0|ctj[|

FB.=Q j]>|0onW0!L# '0rKCA& !!ypa2#$QBC}PPCfjgpL@>jglgj qWw 
Ht8-t-9t- 	t "f 	!QF~ tfFfjg?F  F
Pj   v
u}1Aju >PHPV`s
Ϲ&_wIc¯_FtB$zP
Q|иN	VV2F
t!@D% QD:
莡Q
VQ6 B tDuЁǠ
!_؋!bGv C puDPk*.% H!MbB`tu	 rdP蝎QGg	R4O1maiDu(+Huun @uqt j	jfh	m	"	PV^FPqf~
 t

>a}lxQEPzU@ ]FY m DVV~jvv{xX 6G ]3?鲯S0'02Rr~wF0BPR1qE~
G jR[w807+$ }Ep  9]/t ##/E=/1/FFP9 \ dpg
p; ;NNNQP @C7 Ƒ= K = ;  ǿ-Pp---xАߛWp'Fj  ܩ~k >g`{ Pi;v1!;vF?PVW>}FP~FPG;~~P1% - D- *-ࠁ#- " e= Pk'-
|5. G@6-U ;sFc?a{tU tP` `0a~9Fu
VVIVF]v9vu@PNPN  PNNRF ~9~}};V 9vu< uN0ǋv T`7 3P Pp & {!VN;
u鵀xA^F;~maXƀS `
$~Du6g b;W|qT/QN;v}O;6Vf~ uFApL9vw|GI0Đ0%9F| ~A^&+^&} 'F'302F`g!ihj@vVt ;tt D@gx3|f4Whyl
 +rz/{~I>FWV  Gc Tf tǯd@ @ lj tUf
W|tATD\[u0Y;/F~ ZpӁrN@uOp0
DUK=eNp>e u)>f tl>h tt >Vd t|d]`h>b?0ҝ Whnp.u"jhbh4` i
j(hghF`fhp`z Z `hMdh`; `D `}2 `ml#4`a%MF gB"	p f% Zfs% Mdc%	 ;dS%
 DdCz% 2d3#z+(`嚔+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#Hjh߰Нp;t1rt߀DiODpU_*䊇>AvuA*HWvAPVt0<@p& S}5544%65245r659h@E@ jpPVߋCpWVh
	 !V3j #	~D`HtHt}#h !    C wt^ ޤf	$F2 HtH?tHHt$" @/ $Ѻ&&G<P jh	G+P舐X
G>7x@n ^aGP0v&ƀ ~RrjV6 fP)3P Ы>X F`~|֢"®]s}vI@x	&8 tr
9GPu=   >p~5q9	uarf   ^f~ t  |֊FÑ!	eM譭	L0#	yKac 	3$C0(`(hOɻpa^p3&~/tC&  v&8 u*C;^|ckF^P9Psg`^? tvN~}"v`<1
ރ~ u0gDFG&9 uԉ~WiRr0~F Z= ?-
 - ހҮ<5 1 ;uJ< tCBtZPU-
tKŐtHtL- wt<17@t0- tOAJ뛐j*Q`
0 R~D@F	 0 % t" uN;j p貁F  Bܲ u
g~MN3ɻ~*^
7ފ 8&8u	F;|p,Bdn
eP $
Pڋ PPKC 
Cc!
d$  *8fudh"^u5 Q/	tP3`0F |n FPf@
t)f3f͹n @Hpfh 륐j hahO` 4$u @3l3y 1`iF*A;HtϠ5= t	d@ &d鵫 ڑ.dwQu鉀&
:	@
ʠ
 &
&
hhN
h ?AA7B 
@
@ -*

@5q&
 3F! "&d&d :go:g!B"  `FP~H AKNO
3a$\'"%ajC:GBHF`^k Za0$ƍ&Í,3F
W46 |x$dh ej(|j 9
P8
PPfsV
bW&*`)@&` ad t&<
 w<)뀖䀝 x
苵Q %'@q`
豑! O^hej  %cbN0ff3	`%  Pπ`RB/
?
~$*0/$40/04RjTR"`RV"dbtp%W*
@

aH*=	_- I- 9_t7-
 wqrMt%
- Ktq-Mtr` MYnp= d.ޖڗ,2@0`  8&`0'WR!"{Ր,20`  0PXu/1V h:h rST  9YۂY݂Yހ;
Y&"0Zd a=	_[Q["
@4 |
U!@ `d`?da0y y Vfh0/h y Pd@t&
 _
@ UAUCCCUQ΁!#!
@d`d`
Ɛ޾
r4( + (#+-+tp*tcmKt
- tu] &3& tGђv 1vhh
h P!wu
j8%A}&A
-C4@#'$'a'a{Ðj=؁ ڰ @&
)3bPf 
F0>{+>>G>d['>n!>/>f'>< Ћ5P$pD D:E489JR4"" :L%9
5Bhh V2^Du+! 5 31;utb&`S7A"6@A@tR_!P!_!
@o>8aO? 6`L7.AL&`8a~S<!Q"Q Q֐*|3ɻgm &ArhOE@QGp@	XrQUUtDu33,io
; YK8amrFv(!
or`xc$Pvz0%@txADP!DE$!D`
P#wBEf~$x0%YAǑK=D=H=yM8a;Ա;
f{hZ "i [BGb %^
t
]
dt,W*@t>teq *`v`(@a@1)@4AE:aŏƏxCyQ # ғU╋$ $ j4%0@0ID
p@
%@(TR~2;6
42`:aҟCB	;av|uv<U_PT	b
A
 05^8$ڤ   	 <PdrԠ H1p  AЗ!@]C o0;a}0u;a}b"뤁Wab :a 2 1 릀5ѐr1p "(9@( f fߣdEWfh  ơ_!zfdf:a&ߙdN&..@S56P6e!7>d>8FF% 9N$N 9@#fdfAdn@	>d0uvu,	u#DutuuV1  ,ǈ]|rhğ;r#veʋF8FPVh@w Nv
WVE 
@a^HtHtt-L>B+ aA!!@>
g=VժS줔a֨Pe %DPQ9@EQ' `edQG:bQgC
@
4i`ݠ,!f+fF@ ؀  FPFľFPFF0D01d18D>==  ߄ - -tR   -޵ -*t:- ֽ ߐ= +-!vC  -޵qt}x$Ht/Ht:HC 6 ۢ 1(`  F! "!13 R3Y"  A
Fy
t)j 㰁UPTPfsV"Ptt ;0}bq&oY!Fp *HFL~(f@ fFb^vfvvFPvА5Fu63F *~%v슅b :uFG;F : ~ t
&`x|@xP ~@&p!  p!qq t&AÃu@@?"Ht)3?@ဣ ~8b|ʀ&X qV>@a uuHj 
&3v0 RPXf>afBf@Daf a d Ą 9FhDB R
>aXf3U B8-9t- 	t #`
  *Xf?jj a
5	1	u.#JNuh @Ɛ>a tuxfh  P	-NR蕅 >d `6
Lh2b]ɀhbB6W3ab& ׊d  F |b rAu
}ScA_ >p#u>p\t&el6@a[ ]륃h0`te3b13
׀>D*u	w> 0m!jj22{t;-3Be'kJ t'{80:;2R%4;44Z
`b0h jp0@(!Fa@[$

u$4f*tTS?=<=5
5
C`Kh@a	@Ba	0 fh=+rD-qpdp$ې#;$ %D/0bBebbdbwXfpPr ) d%  = $Pmfg1 *Q2 Rb
b
nc
֒
V }g
h
r 
b
 G<wעA]$ Dt,-
t%-.t,-	 tE-
tYtQ- t/C D~ʣ@a:B~}A y_p}}  oU&VYftfwu& ra@Yft]u
0t XfҪ@ʪ  -0Ⱦ@ut;>}k`  Pr%hۖrjtXя6 ]?HtHt `tw' Qw h/mu
^_ WV3ɀ> N3һBrZЈQ @FPWp~vrܐ
NpDt  & Q FV^tF&ud,,,,L,,,p+,,.>uh hgmh; h , j v~
x0c/"@t\) 3҉655Q@;@)}F~
r݋F 
hd΢	
J{
Z 5#W<B6wf
 ~ĲfTg v3Nv~FV
tut9v~O|܉~*Pӈfb^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év 9t
G;|FCFvBF  ы3$uG

41t%I6%|bpf"bfff3&XI  
"bt&
S
 P蕶t	t0p` ^3߾

tF^&FM!u	 |03$NF#z@
EP}fnGW^rF*V+= 0=a -tX-  - 9B m= M - t!Eh-|@ ߛ Or= E.D^lO|/ /  p- 2&#b% +11$b "b"b@ 3 ֐j5B jh
@鸾uE
] C
@
@
C/ /  (YP)@ wj}Q'3
^'G`hߐ$h5؎GS.bAcb$h, "bob$ a
0ް&
c
Q 
@DMԯ
FW@f
fhR0V" !B
p,pfh*+`()&' $%h#w\b\rd t0
Pd wfu
R0  O hEI `F<tF "h|;sx by_F ۄ-FC|ߊFà&bGwVAͰ
?&b(ba!JE/PFQdq`lDL'H }f`OeO KcOSRӤB
)HT4PDĊ⪡70SBTaD

H
<UYD
UF \X(T
~_J_	QҔu
r
(q
(bUA `tR
R_(bfbhrr%jQR
 &5l01)b*U5nf6EpCpEA
 !\0,B`7C`LB`B`+-
- `
- Kt 0`a_}___CU
0JXftغBXn߻4,2"5^&^(bM  ab AB  z!" 8- 2&'ddzt] dw@TĀD>b )# := u@-  30A+q5snY3 빺@  r m&jq /3@u1DtmDt o(2<CaeGL E@9OA#"ңSdK"sfdf&P dvapbp@Wt xx Πg&ACAJDPUt &hH`ώ&? t
&ؐ
@@S#U 

C	@U


A  @d:x@t&fh!~觴Va"]@Gyn~fhhF
5Q442<tfh:89h7F2
/q0ճv?B=>h<ڀ
@UȢ`	DBChA谢hی2sWVTf$ < u@0a@<@uo"d s@utH	;>`  *r$ hh$p1@66.b Jru%çb Dt,-
t%-.t,-	 tE-
tY- Ht!- t/_C D0.b:  ~w
3 	}<  Aк:%@'$F Pc= Ht
@q j  r jݜ@6|@uf4;/F~  rջ|N@uOphh.TavWV 6W
nrvƐA퐃߄et
Q o&FF߄et &?dm"8$PAJcM&P!G@T%V% _%T%&rhh T$ 'Fc"0b.`& *0bPeA u$2,<7 hLn?h:<9  t~@ rb` zj~=  TPJ
 jP,0bzp0u.&b}Pjj`&rz"pq|Fh@0#000000000!&bkVfvfhI
 2u mh bF@c:tF&<:u-FF
*0N&$x  
u3NQ@C7 ~ uF	 F
  
 
 <  C
v`
>A
jq<L^P{B
RP"
? c0
~ ~ tghv&~ tD1O=ܩ=u5> ƄЯ
`
 ^3 FoPPP FF9Fr @% -
 ؋0v v sd ƨu = wѯŐ:`lxńŐŜŨŋ~FP.a<cy ~ t 4Fa    R {F  : .E "  
QpÃ~dzt' j̂OFZIZ#3w^ \L E1hV.t}Cq u^ GCauK  K .g"=Q
WI Nr@~u_t W    I t@F{qqFV!F^@=?uFv2N'22g+@]WV?6aسKhLhy*y fyܷcy}oyDt4H-H4HSHvgHQy72yFIP9AzC"ClIDzߡz(a
4zj &z<f+fF@ ^  ^6V^KFP6b<Lv3+Q OY  l`- t$ fFf~ sA},Guhp萷ܠdfQVȡbڙRPSQfXfYf3fffPfvGMF fh  bUݶ1g Fvh "C_QPod Pq*T!T]qʑypyE  p 4  V6rNq		% 6lbD6@g\ 6<gˉ|<`yY
]~0Ð3Ð4 AMD  PowerNow!  Technology  MHz   KB (  +   SIMPLO  MOTOROLA  HP  17.06a  K    Restore default system configuration mplet?ed!  a) Press <Enter> to Shutdowwn S...a <  drivelock \VB C 	u Setup  <F1=Help?> FilesInformR  Displayz5iSave?floppy[ diskette from+(s.Ign2hanges and exit EP  s! withouaving
o Securit@AdministP!or passwor0EC"e a8/".-OnWGpP&Devi#cedeDgDbD$L $s mart Card%G
supportEmbedde&f
taA!e'e
tr*acp",p(s$:authentic;e
credal /Auto2cH%Tools Ba| /0Calib(p @(`'lec`B{ b HDD:lf-Tp- opDs Activ O Me]m
Chep? r s: ll31mb 	>>uA@Advancue0qL`4uagaC lDt7  of grayq6fieldO Boow1b..Uany keyUpY ue F10=
, ESC=Cl  9RAcc{ep/=YesSNo D, Ajo$r=MpI W  Us|Sarrow
 o highl@ *he appropriQmeOnu iAfqKpcNTER> cbegiggK%#.follow@M%%k&:@tj->  KSPACE = NexBR3c-BAC9Klvio"FnTABE3iSHIFT+&*TsF2@&10 `
v[J #'9 Er Th{is60cann)b`mU;d An e ocP^@ #whs6c.de 0x01 e jndA@pGPu@p0{6Crequi yayE`d~jba@%mu0C
movP:0 e4k/MEU)hQ1& ilAl//+2SD`a06ssfulManuZqr  Nt0
d:Prottyp@spyeItepp+CacVize (L1/L2)S~Q ROM dd famias=eP8l nupi 	Videovi}s"KeyboorFr06verADb1<ed2e3bg4`1qa<NPhip(TAdG
W
O3O 	*	Ĩtafdai5u%BS)NK)$ 1
2
3	ME$
C

V


4T!V
o
Do
So! ྶ: D%FPA2d!J#biFaܐWalRX0sԔ&1&H} A{ddline4 AlXҁn.%F$Warn: rk T&pll0o!  zsfTrea ҁ/VՀ, letf ea w̓aba02 A: 
deĮ` waqt t Ұ_)Vu @rnInv  ȍP
)!	Ayou̔ wa@|to A @Z?m  io	  0o b+-c?(Quick`n2o2 (Cvre@sʅ3 (S.M.A.R.T.) EP1pexim@s ): 30¾# 1g3>0%v}} ty ho#0#uprХ:1't4	f-Un3knkp{ilyWR!mServReaPS)doџ47`?a}.ribp	:`LexP9 'b`G H  Olp New Vfy nY7Enc8Of'f O ɥA LA66#%AKroE   p dV
Ad1ݰ U@ҭ5Ocpcaus 7APp@=AH
"h` A&فOpower-.ASQVQa?Uׁ= loss T(dYAhou  nlcof aQgoH04)ev`ۢ?[vYDocHishaR`ed?!0fp]Dddial JJe HyP`"UTool0 Cr.%oF8IL`ˣ Bk g Uмn  qpm`@jtWSN !ar%v0s /UcwchQɡP2"Onj* e:Z%%% AF@%԰#Dn -f  TndpĠfӰunuR?*$n)tartBQK`fra Par1yNsza $mediaa D-  rw"`@zU 	1 	 abouasu{0hQԒ uX" bbUS{ERMAST @yVpCanP:FPacSTkeeWp ia#Je7physpE =ph!E 7m=p0ar. I7? >Ä
,bPn!Q@SWun +AgGOOAutEoOcEd00uHZ[6h60? #ONk<
O [k{ѺaD"`0ur@t`\2th QT1psow k e"d0PerKFb oQaff+bdat{a,]ssibmma!L0ligiXd!V IsXjl`rmmN  q} QUpu zl,`mreGpla0\ sp ~p /*`By4zX r@P4,o HA=Wy@}'rl5|@me`1r,۠@M`*pPpuibpty. IfdoBǄw8`\ESCqt.!
 V rtSyp'>'op F10"`q brm ,b(yt+  E$  M0iBjQ  Or0s:U ay OX`2DCgDLb (left :/hUSB t HQbSu K ZipoFir`ܠoPF th`ifp Ssixa Rh ENPh ASwap Fn/Ct;rls KU.S КP!slegackРQ>iIs`7)n0=r@ry V0o}  d NTSC`AL -J -M눱¡t@
BidpR EPP ECPd2size 32 MBw 64a 128  AUTO R  ўo@ QlwaypnRi2AC ViWWAN{ D"RadiLlBlueth /rSF=ch1A AVgq ! R:!t EF߇ (,. /2+d-)#/Е}@/4En:)e 123.TokR@Hp
kP	ЏM3Unique Idaf)e  - @,tus   ? S3NCalib!6Nsav
P DNA.b\b 0BA] HP`{O
@ELpm MEUk'g'MRqsN/@G/U[:>1 : Cg .  % ]4/Cle	2 |c1di k-d3	0s
H

,
* A 5>M(4o!ylSp hnologyG4YadapRPXE RPL Ex㨢Popupz(0 _10  2@ 3 U4 5 6@7QF12z5 15`@ 3 "MBouchpa PS`@Non<F1=Hilfe>\iYinQ[ Oٟnzeig fxR0peict  KguaobVwiePвx @nLveinun(	-s
kz
.Aign eDd*nwt Pneh䀂7/%Set#SRheitsfunkZࠋntoa u
@nBlt-KuO] Gertes/-$-ID FOt7	U>!sttz !  pQz#  beim /st
ng !KÀr5}nHsvorrq##7..zu/rckz9p
B .p,!Kf_g{ms>0ThgEx)`Akkuk"eK tBsgewǄhlDD-Selbss8@´ItivS9#LtIpr 3g 0: tpplAlTL
PZ`OS
@ PErw :%SprAaQ 1a;n!4:#U"gran Feldsrt-O&O9!86")e SePMbqTa@0, um p_3fahB@i=A, ESC=Abb!#`WBkzae!TJasqN0\ , Ja	=Meh`mG VeZ
zpOMark"sy!*!'MenS% dPfeilt!
^dQg'abe2RmOq>ko?9 c`s.	folt
BnA 
sg:@)-> 0r LeGQ = Nch A\pd<-RBchrit3t-`VowA(|GTabul!fts+ Holl+ge0dOx F2@
38= {gy EschlrLi@PK kan~Lt we YeiffMgy16P=`?rgetrЮn.Dc 01 L`fit B kqcQFY+<W\selomv6PorB]er0ilXWqDeskU-KsBhmau f 3asAރbzw.2Mobiޯbgtz%.`Qz qh@4Bi///"2f!
}[KAlgrѫ ab	chlos@`F-M`ll ProYz yprtit`wigH!60a"Ca`-i-Gre (L1/L2kkapazitOMdPm"Famik Sp; ummU Grafik-R0sa@Q Bz]r-Con "
A   °a?7J	b31O 2O 3O 4dqV si H>(F  `	o	 o
o1
L
2aSekr ET* "L$ƍD%'$b-!3Kc(1  WalkZero-T<One EdA`@PBnO`+: tbX7 stNqbislwnK.p  ZEucQN-/WB _&leQb s Atei#CP0&ILp`ak AM:nfC6
lW&$ge`KR/p+Pglp0%ɏ5 L  	/  M0$wirkQh"vQM?`3, da?OFq^iew1POBQod01 (`n@H12 _(UmfafdIGcr$Pfh2xdau(Min.): 30ZQd @0%#gAto59wu<P@wm Houyp%ubr ⾒w: H	<Unbe!!MH5D2'rvo-L`4.
2ࣚ lShafAttribuEIDATuLS.M.A.R.T.ʸRXXMs K kw0eus<~K Dea8 ` JaAҠQ eD/t FalRgebAe
U	 GU5ƪH0OdminIoy<٧ Dur? '@ | C 'mgQi eFҔNs'd,D. "< t>PtifizԢpeq 3{xrt. s ZuaDFL:O 90benʰl ~.ib sEQn`p'PlbsviceZTas @,`$@  h0p 0ga|F	 :	 
Zptfa n0WUmC Fun)7, meF\Wn HPq{tectToolsP=c@^ty Manag@UoP--cQ}- ki QuickoLockSubCndr#q\M"a%$biі3bnchutz  fڀ_-?1daԨ@im$& "+a A)N+ *W"пB>Г#, l0ҳݣmeh1 #I  Nk>ɁoԺf ot-Par0e.@B:-1a$
mpCD-PԏEڅM# Q:Bn@38m"rive(rF0vplP`;b=ALs E9-C?\s mpW@unbralbar.VSIT
gd,rbew?Es`V!2, 0f0|""! E'1.J, ҃0\',  Ij=n6zBOs @Begriff@d"kaOutomMRu p@Q7V7;ohl;>
 A qiIi {qt?^!Xʗf 
V' կ!!1 !!mU"n O`P o"ep%)pY! f{#Oz`u 58ae<s2z:n	S.)sa`uN(A^Es  oh a  c%C R 0` r+pIqИ  iurn3whE q. Esdratempf/	3 d?1zuq Odz. A@ @@R7 . p`r&ѽ`2 Sⲇ Q7 Lb-B n ra0 tAdant`Whٷj@Esc-a&LlD>m kW!΅'p'p`\ F10 esh:
xfPg g`Ccf sqD} mA MuBay&m AΓ)bBtg40k -ET`(links)tUGSB-b#-2؆Su 1Zip 1 2@345 6*@789 QFn/Strg!PtbedE|aCГ (USA:f-ZePB`iebss¦unabhng`  InGrafik-Contr ԾaPrimSek% Video-qϧrn~tBidireal GrPus g / Lf`i0pDPtzb
}r WWAN-G""fPLBluetoot%h9UanU/a E g{paAggrp e'*0(o)u`80Et# 12P37ToTR PdC ?!"tv y`3IPqkBoH AkCkuQ  RtaA   x a~  Kalib(  MabkfbO  N&i@ualQb   O  m   O DO,6uOTra-?6. .O .L84obis p9OO5"R 	EgnaOOf`.[1r0 1 :a.  % ]abloQ(2Entl ho3ȑ 
m* 2
 GS-2'@su  }`RadaQp!ϐaABPmªz}ExpA-!-Popup (.) =Wedau`Qtְd2 (eZ p Ke`~Compropstn <F1=Hjlp> Atoplsys!иVisp#ne Gtil@c !!konfb[Gwend0fraMz@QrU
J@gnorndr =o&fslu r , u*t@gBOtnek)hed Administoradsko K aodA7 fo%WhE"djeG-iq		 *	*
J	Sm-kort	God0delsf 7@do@_adbyggPGOds -&2	 Nu@00faks l2 IUaBg
Hs)9FHk@d\HF Ba.@ġV P cb"dvalgte b&HDD-selv\tPr HukoQA1.iInPprQ2h; OGH omv	Ir/ Avancq Sprog/ Vl1?s @mo2nedtt felO C4+'/#5l5!Tryk pP7 tas<G0=tZO^=A, ESC=Ann	uaFs!3=JaNej9 "J, A!R=MGb Brug pr
NA`RP70we  releP %meWnup(,1Wt<ENTER> /ec>A)et. safpPr'f!f7: -> e!& MELLEMRUM = Nl<-TILBAGEr!JTAB&2$KIFT++ԻF2@	:*~= Acce1h0!xhk>{sfej 8A3ku1i0gs 2dodQ)!FF1n. Fg011BRnoVD8-p% qpla`9G!krvvek`EnJJ
iC db!?s/ flyMsÈyn/MEUqoO5 bp* uvetzbrud 2JI|,nemfB J@`  Prc c@orO-typ hBigH  ztr`7Crcache (L1/L2|HVROM-d@ familiei;AWdeo#f0pds8:@Xr-cs]]D-ba`s@i`9e2o`%3o&4Z&at-ta`ofej1E("Wat!)	O3OWEw ex{%Isr4E$ TyPyٹ%xy lydes!Bmis 0'bvD1I'j`Qejeܶ var0: 1DB1! se  alt@P02[holda@ poPqt`/Lb Bb-Bdqduw5,pr $Pk
kEuGrBA:ރTETfDF%Ugyldig/
t-  @nGgivuİ2,vi avh٦,? i#քK?@ $1 (Hurr P)%Omf`) sl(`{ (): 3Q0˄2j  `1~x0% frpudZ44b2@DR 	cq: KuB+B"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5pyCD@F8Ny  Be@}fwt nDeae Fra@l  !e@+ń4P@R@{	s0F C		ƈ4D 
&KE  beviвB7 9Ё!Cfdes, f.. <r#amG261 PoR.RVuAj@me+tabWata. Du bu$AM flAX:Ը vicehCa D[G @ߒ[&?Ɠr !,ci HP tectToolo9"jK Quisckpau`'LsQmP? Skrp!0rKvt%#k|qX)/sa1-$$ Hvisat 0`w@x6r,
di ubilK2;+1ol p@frard )x Qlash-@$PR@Cd-rom-@ V@ôB Ho4C:"eAauϱ6!hv1,< YD!.  
bPBRUGER-t@OVEDADGANGSKODEN,R3q\0MU alug:,s  n bf  ned op`JaP)edS t#
{	pND ll E_C0aQPhjlp@futo!mok- d-
\BbygAXl_6b_/k perma`anQigw13n<l  fys dsk6  4@rbqpc(On O"(l	v  H.dCn0b  `Au!dW"eLm/, soma ck@
tvt. U~u p{`ppd/cĠ ikoU` .Q  0сbefalkrafȓpy 'AQƠ@"pl . paYu )v
ؑ!  &cO.q#o"J "4,Q/0d iDHuAP̷0..lR5:@ENtra!5ESC. řE# orpy U'F':ge@F10FY Msf
i/PD+s u ADk Osrflgdm vdRRena4HPskm DSp-bas MultiBay (K0 /$hjUSB-floGppyEC|cc{0R}wbsu SbAzipFr`aVTredj@Fj e SjSyRV O Ni @Ƀ Skimm F?n/Ctrl jElPv(a`isk)!apegeUst픙!
uPnPaq0#rm-c%r Pri[m Sed V`o Out Para#  TjStrCL`ohuko B< t 6nr compu Q0PPǀtrm
gat WLAkN-!sio_Bluet hK/A (trodllo|netrP1UAmstya׃&(x(t#op1*b*Ethqft 1K23KToJRaYHL	e+	 	Ent 5gt id-nuRa"i@  S`ҁ   Z 7ѿb/ JKalibB' ndaigO x 9p 6 @WNM H KO OM2[bo   O O#0 O`OOO$HAgs 1  1O O
1VSi mo`g|Pa(MEU)J= K=OOGO qOO OOO[ TPq 1 : O . `%S ].gAm5t2 AfFH5L)O3@	Genos	
k

, *  J/X4%G) g`hB`At @`r`bpopupsink(sek.!H02D5f-1@bgpP`pA Konfigu!2mas   <F1=Hjelp> ilDwin\0jons sypLa@3$k"v)Hefra6#:p`di!opQ	:k@'Pg a/vslu!A 
,lBDE;sprowgrapt ST{t Zpass@e a/$OpFA0`|U'yrsei!vsf'unkur!tif@ԃ%@%-
xvn Sm4 #godkj0RƐ!xneby3PPi%it"ot5sTilbake@l#3fabP@PBQ`g
i
 C7;avL`Srkty & val1g !AlPP 65vt Ak MbT!#[S S;G@$*
`H!4v p;rlg 6  Dem75bM ̐@ZdtJIel [3
.5E6o%<}5Trykk&C taJqL?a &`gY10=, ESC=AvbrAya bRAPpJaCNe3i rP, i\Rer=Mbb `kYneRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMR?OM = NQ&86  <-TILBAKEPvrsig*TAB&|"HIFT++F2@	)}= Go f#l`bsfe*F`  SPk0`pZmnop?  \Л@C@0|m?kjresve@pm av ; i pp 9obaR@flyps23]cv}ja 1|Фrvfucllçy. kode 02	oProdu^t No0ablokk-mlqlztyp h igv&-PgayvDbuffM(L1/{L2`Meng`	8P	qenupMV wo-bTЍ:jrtroAUuSW,kobf(2i,ѡoK91pi 23r4,0( E
@q8(QP 
oa
oA
o,
NEkA'#Ilrl`ۢT$o%q ok!i*rpLs(a"Wal09g 0s"-h1jH( Adss @e7"}e PnAd 4@~:# DCA#.s@tidlPSho%l0`?D H[ /h@e-  , "n|uod sPkld<Ak Cnn@A:ROs brregс"iHUgCylÿD%SR`	F
	øE"#hІ0mtEb@Bl?o {30]6  ignoste? ̌ HA 1 (Rnsl ՠXBP (P): 30aAӣ pgr 0r0a%h[V\st@͂vgF_f_:g Ka"utp` ΆUs5$SQ&es pTo(Lesb'0Rt+ܲqurib: ID@01s<S.M.A?.R.T.-f^pЯCC  G#5N@u  Bekreft nj#Av@l #APP 1qpʢrqj `vlikt Du  좭! YaaD?rka ygA3ogs?7 o sdQmpelPAfB |.
A/"r2P(<Ypƨ.  bpkuY  m%cQpvice.pu lF?'ß"7 BI 12"l[H iP tectTools`3curityo Man_r.%'-ҢQ&-clq@@DlanappausG LNm!Er!gi %e u beCskѬu"-bU+/- +"W%HѴ  '. etglາRh,vҲ<$P O5. K$RmEp!qfrard- Parllu!FhielQrp2   CD-@%sBV2u SHo`$.:eCd Eh ?eXpBh  1hh"4b`BRUKERHOVED-T6 CI yumu2aʵEAd n0]
2EqDbeLp?ap0
P0! Q `wb! $pa" 
S,!SQ[0=@	"C?`6`*pp   ~1lJ I/,   autom@ZpDwLock3bygg[	ct1lqa   ^maДnilg ^ge.Ӏ
oh_TGo fys!ad  p$b0ifdn!7 vm=	Q}  CvqQnfn@e^ ӂEsA 1 dda G@Ubx. UBrhom`d O1}/E XG)zn0QB uQB}VPnbefaQurUQ AG	 }qQ.q1A,w A/k1BEГ ? iO!D!'~I73csw-flans0 ߢ1
,Pr ESC-zLc˿pQ '&D'<BJ F10uY¨bceډhTme NKorhFǅOre@b MultiBayp\sz PGn(vee)Шk}o@.ngsba0hhyOBUSBAE|v_ Zip-U
A A`0`Fn/CtrlTe EU`d(USA)GekeeanPel񼐠	jZtsro2 deoݨ@p
T`is!rrbp?s43 a7ti?aѓSIGgradi/ trdl  |t  WWAN)OOILOJBluetooth /-feftqm0q Ags9ssty!1%Յ*2%O (v&.b/x! 1 Eth ;?	-	J3 !R@`NT s*ooo/
#<ni@B`jtiGfikrRC&@Ba:CriJ QLt`ӡ   6ymbo KalibK BAes- Ip?upsal `,-.	/	)	/	 /	1o/	/	I|/	/	Eksp.b n/	i/	/	Hnd3O/	/	$/	/	VCv mob. Pa^
- -/	A} OW
IM/	6[ TN: La. `% ] full `2F!~@i3
"i1n/qh* Ny  M(/ *D ʛCRi2Ԑjm  sinҀhurtigŭ (sekur`@1F1K2-se1. AkS0epute PpConfiguracie la Com`adora <F1=Ayuda>rchivom%l Sma 1GuP!isco flexi@cۖ Ra`&svalopQfdo`bP`a< y Ignambios yli a A{  g3 'Ln epida9dAse
"  ' Ajiciof<%posi)s_SIԕc)$  +U*KskSm:!=CP So1e*cP#<)o Sectyincor@% E0e" 30/c`VP>6fbrI
aBЭVc!3nci])AutomaHerrami@a@C8|H er  8`#P(8@ ;prueba HDDKc 'EOGVp&Memo'ria2ad*mp.`l1@JNKRMu0G`SG#
s
 Avan!zX ESvVDD
W? Fampr)co0N g!r<1o?)<UOprsim'Pquitec0g2)@Pbm=, ESC=Ca06la=>=Acep uw=S?BNo .Y, Co	=M`Y bp UyBr$dchf$ha5al0}  Alem o apropiU=@?y<INGTRO vtzpX:bNn.Fs@{3Pku4Y y: Esp~o o -> = PrxcRetroces<-[`0@ aXTAB S	3'AM_ays+#C(/`F2!-910`rĀ"b"tErr0F`o 8 !i0GS0rjo u Q2AK. Cd`0}1Bhay ncunW>qubR"nY2 A#1+>br(RPq[coRUD)J ebook/MEU?p)Xq 1q0\2@Oi`0pleШVxito{sa4e Faj `uTytil TiSOp7,ÎUVclGPu7XTamaUZu_h?(L1/L2)/c FrAROM mil cNmer}ri"`visv @j6rpgb-l?`yo!@!
/#j1l2n3p4? EtiquqɅrsдlIVetFK (Sga  Woo-o3oopoi BEsn@P!**8T4:uZ$  ProbDs%"ȑsОsfactCXJ8䙇 =ll? sRe`o 00o81	lneRdip$Cl z 
E@| o|i5DFAdp :vG1uir?el QepvpsɁ. PreT/v, @qWscđY#u  A:od Uubp k 0s&A?4hw?teg
d^vlhdI$'Cvaб}?Bo(a) 8%pS	 LZa?gno.c  ilNl'g(~D:1 (Rp=)e;2 (CvF3 (S.M.A.R.T.) Clcusvtie&$ej҂( @?s): 30Ѓg`o BD0	%}Cb(FEHְipaulGiArumq
دb: s,pu PѤ᠉1I{`3nbh7S_ervof 4>4apoya(atrib: ID!êeaxas G
XXsea``KHnue!vL%@)D S ApagEndq9S!&GOB".?G@evocm	0kaMla o
!LTnad ;paf  Ҵn\彣ԉL9 A*" \ K<ѥ,1ܠa(2o,aG p0s ( 0d26 EpyWci{KKJ"² rv3r@2in½' Sqf_nloAecal ol਑X̘#AvU	@jvi.o p'z#`v?'6Wpatd!n3n HP ctToolO*gKn!P&  QuickLockSuspen Blo^4[r#at"`S f6"r"Pנmej eNS_f?Rv:c+,y'H' ('p%rKlRt+FD, Qs0?!b`z,KRHO;re PuPnc +roj	o%1>ldW9퀹LmedqufhyBCD-(-E,&DGXPj:YUsioрJu@= P0odirive`(2dL! t{USUARIORJ PRINCI7PALr?эk _u d&t@VnKman V p< x. An;4} y gu`$8ǰlugC,r  `jw၈{..&4J @d+]X	jG S1
!qcb5=v Z>Q@nmpc8K	8qݗFВorPA:
@;`;kR0`u@t೘_, fs`m1$ 겟DFRUiQ rPoc,I "o	 /_%z <YpuΤd/aa|sRciu2bSt?6! `? {da$kosaևg\ Ѱ6Se xoч0enf 8d8@licԢ@reaz. /?k еu"`#0Z4=ԭinHɯ~ qk? D2Bu 8Z`
siPApons2>絪Y_, ila3 ESC. "CPՁalab 'Fd's  0,F10 :FrwfG`'1>7T/Espaol O 3`tMultiBaNQPa DiPsid3-pa ;]fbco+(Ciza(@jech - cB B a1LХSuwkrZipcPmeqeTer JoK C`5t Mx S0O@vNop DpǠCAUs Fn/`Ts@cIngls (EE.UU.)s0¤ (m6plSo}"leA$1nt!Ac@ Gspeo CModZ!ʠ!?  BidicO Tam&#mpI" ĭAAi	3si@ fuq|WCYJCA. RpA*WW#AN{L Bluetoo/th IAp
 ɰ}1|y1`hoergsȄGCpoosxB?0P&;{(s+ior)пEth` et, Nboo0 V 1/,2/L3/TokPR eOO@`P23 IStif Exclus@sAMa 7`   a*ACpg`*-Np@[pSՏo!Wr)Yh!,o	o	k	o	h	s0bkn	o	o	ekAo	 o	o	 ao	o	%MEU o	.@o	o	o	o	Ub ro	o	o	o	rB8[p 1 :rg2. c% ] /~Am2 c4-Clepτ3 	k",B'* R 9ODJ)o!oh` ~Aq!Bbl@zНArranq p@gUXDgrEx𱠧@`F12ϡšQTAmbTouchPaud@uqo N@quBaƐub  <F1=Ajuda>yrpInfo˻sob o Se i?5mDBђ?	RQ0
rt@7x`+padr0
#EIgnp@
PairP !	Ts0s '_nan`J3a fOЎ!Dbr%& ͢_@# B!H_D#!P6

StSdB?8lizb/pyO
(I @3`]/R 1*p?g%0Ҡbrb
a#ut԰P<n4dceAl(bxa o@Mca QFepOMmas`g=Q@i#08$!leOpTaRHDD Af1)r  VR#Ke Mem `@pA<0J<@ 4tatuR`Mu V^G[8© Av8AS%,io`A^xd; `campPJcinz "o?CA9 Pbse q`lr wc't'inuPg='oSC=CelAce imNK!S, Q%ou=Mai`kag Uti@:sC	qQn'	yda@ o i ? aprop@v *u@Tt#<ENTER> t5me2ez[@o.LTgu n9 ^r ub: ->
PAO = PrxiK\<-QBACMKCExaQETABo$SHIFT+C%* F2 	*:@=kƪSC# 9nErrrOA@Q@na@WoQPڃmRHE. CdigTGo 01  NPh?6P,oж P+	 ?MnѸsuiK
PCA <x	lBMsev
;nsf@BBY Wotebook/#[RWSmpGSTe2Z$K+Xqm"m xitoAqnPN  TiHp`3rVpc3_``p\ TaPhcache (L1/L2&Xa ROM FamlqY  Nsri
Revisvdae@_AJror K!
!lD	`Otb A(H34@RStiRep	JIOeu6	(u]@){ 7 on)oo.Oo$alpC3~ƕSecundAabp$ 1Rc#%uPWfoigv !`mdOal Walkp  0e g1i	a liten 1M!o3̲Ig dAdvert: [AQ`Ðo? vAeDjWcaqATC/v,i um  gravv uU:d%A: )n Ad`c@NS3 >ЯB^hOП?ptegiEa	d]
pvl@QI= kT ctez0eja $ 0. ioc. ?1 (Rpbޢ2 (A ng!qf3 (S.M.A.R.T.Ax`=Е_(.): 30 <Peű0@CT =4QC0%ҷ?1$bucedeA,Ӱ<q1hostDCrom1
: Iss-0 $Eg
Ch@aư(*per0mec pA%Q3sߡMtribrLD@!exa0 s w`QUUcig:TGrg`aHrlLs   QL rB+ iPArrfDigqħcis g ?SUgAdP)0PЉw 'mod!Csݧ" faz !@AREr@a,`_rxdformHr3$n,0#ja.@eH#sHfbr>causadQerF.  TbZ Q[Sa 㷑2krvio 	Iy r?)1TV?%@` ur rK
ad is3,"q,bQuickLockSuspenso BlokTB⬑"u aS-%@ maRnbӑ
I9  k,##Al#.p0@4sadiRibR?o useu s~. Exig5& rew*@P"MP+ p&0erme $lf*ǆCD-ʯ'GPa1mQe:P`Dusu~1: Voc?q 0g5 0@urut@znoDrive%w wt`QUSURIOB|UGESTRE_r?UF%PA7<`Vapaz:HA. AN4 9de-pL`is IA!=p|.D. NPNv[Xv'Ue ,qVr^p*#0esb5::T|DCdeH]$.&@Pfa/[sBi2e'6"T>CI@Uk `99O su7m ;EFeclo,k#@F Ca^er f
a `/u(u$zbAoTb9aQ(ʠ=ս 2oqu2<a'"RxEPkgPU
 xaf`Tpx`x,Ѕ؈;E  3%or@nal{a- t
@Ä3,t?ZE subtudBz ?`J ((0a?lIop Vr AY  LembrevLa0`saQ8
 Bqui1x_sPe ESCV0]A971Clav'6f'rF10`c",ꀃr:MBqʶsSASp=D Augus O1: MultibayXN$c"i@reAoBa ba𣱴copld(R` di tzBĢ	R~"zipcPrimeir"rc QtR҂O\v N  c@Aaсas Fn/Ctrl┣Ingls (E.UV1"SQ[hp0troԒgvde@/cund a`@hMo`뇜PadraBiQ2TahrBmem sOPpS	xwsem0 fuň1w>t  W?CAN#R` pkm   WLAN)  &Bl^oothkACnRΠٰ(a/ Eomenerga9 ere#*CagBc/*1qwV2%,2o-G0supO0Et#netg	O p
/*3/CToken RingOOboIdAfdpPb 3ara1T US%tsScټC0bѹGP8$_ptgemNQSrlCsrNWDuplo&	ted/	)	 E/	fON OOO'as7AxjO/	kC/	cIAlЏ O O/	Oj0{MEU/	/	-/	G9Dq	/	/	/	O6[w Et 1:/rreg. G% ]`Oc3l@- 2:cvN3: M* 
 o9ayCJm*O"(s>flexQScrydapra징ײi|`Popup Exǰ ~пN@F12(B dQZs Varaa NZu`Ti k yktukP  <F1=Ohje>x Jrj`0tQt Nytt vtu kP Tallenna levykkee Adk@onoP`uVt?F?Fo0ej'nsW Oh muPA .lopQ4Lr + ttt7fTpou@aurlisuinvojan ssapM?rit?OKynytk Lat9Cl	 1usnumeH0	O  -u
t lyk
iPu@'
@,(onuki%7/'etF-t2dsm4%*tehdf6Gc"tP!#j
;A )ma)inTykaluA!:  o`K Z< Ki@ 3vytO8?? #Muी@Nk! ㊢ a5n@CH:m Y-FGLisieliH`NHpk aec o harll0/ =p@0'P-2Q"22$J7atkAinpjot  npp?\=$, ESC=PerE =Hyvksy=K/yll?rE /~L, JokuaK=?"5^ nuoli
miP^kP`a h,p$ 
si3KsMA <ENTER>3 m!IEsePP+m.Ht?en !/s@seuraav?` ->0Wi VLINPPIN =ЛYs  <-bASKELPALAUTEdd0!ARKA+ f4VAIHTO+', F2@
+(_|= DWc@4!;virh@uAkkua e <o9i@=da.=: Rtdi 01@*kaa1Prh`| aGrt2O4k p`g kytoke?v5ko0=si@`\Plaks qo'qsV  karqBt``olaa`O< ] Sikk?BPskeytyi Ena
i`(PNoi2GnJ]oPfcaAFmzj~8|Q>i c tOyyppgIn 9eapll~VliSP (L1/L2 eT  ROM-tR`@l0koh	tuotepeB"isar@rzVeersi 3?stohjab T`;{	!1:#2o K3oL40m) JKtabo.7(j [oa)


`
\	\J䅶u1kA'ra- D$pA#t$#:ED$ 8a4%Dyz lhp!xiDEepoӝi Walking 0 -[1~Yloso`Vaihtoe@ :0uvi7 us: Tm?"`?m Qat0nhp . JBkt luoœpuos-  n,irj2Qonc@K A: L"SX XhjuaVV3 eF!G"8_Cpa 
4Hko]aWAi  n, ?2 Fo  p?,i@%(N92Q`3.M.A.R.T.`ArP$ [` n (min): 30s?@2x0%3LM1YV0 Ispysi s-iVgR
?{eAunt`q`'zK)jServomoott@j
Lu4CqvAtuZ?	k Fttribti2P@bexa ePqKcxnbGG LP9W UuEVahev!u  x Pb>Ɣq!a" C ܤ"ab|A*h`20?rD?aМ	-Kn { IQo@9n 4p-okkCPvad4an )in O,eҵs`ՅQ5mysa	kQh@ ! e#Tpڰ	D	X(Or@iWjZJ unnWayP0[veapahtumaa]id`9KQ~abI 4@ti lUi?HP PrctTools@cu ger -Gapua.&(-NIl> "Quick1fa h@l!5Bq,  " p Y"&-޿+)seAk`cp"/$*$i4)ʁzd{{|yh' pP 0`#?аdRBVA77>uuŹ	aS!por InfrnR` ѰBkqCD--к -qVl aoV"s@ biP@>3@:NjFGAiotC<UtWn DPe#(!_Ի")КKlla.   KYTTJN9P?SSANAN,uI4af?%la G#@&silyM gurQ7f GriZ- t]f$rV-`$T,p# `h
LLAA0!:ѧJ1& OM5Piosa vhb 	su0E<:id,"t?4 &/ikDȂB ENZpES  4;
kbD( 
QOvq%x@hB. NykySaF5*!l0Peys/ڗQq}to @ .. Tltԡ $0`{)$ c{ihueik? ڏuperTʥ:ehkh" GQ)ac, kaPv0Pa0Zt 0FtaTp\< OyAaieam`kztnaw ᢆfmm"Gs?t2DT0Sw-. B:Vo1]fw0eajqP oYVrc,RESC-nnPX+nQ,@@$'$'Ax<Т F10g9aauv:hl -?7O Oj@jaAqmqi$ys: &Fn MultiBa Op%J7lako0ilr (ena/$oip) USBD )ZipEnsimm0@Koelj&@zVi@zKg`geitKa0kp Y KymaiP Fn/Ctrl"mp!g Eng(USA`Us$Ps"a!!ŀݢ,RsS$njBQs Os VOolhlt>a[Vakio )s2sN0IfpTj u	uǱI?3Q?verkko~WWAN-ruoHLOBlu@XWoth @/$G h`-s?VڀSs S;l {|.=1@iit:;12v.-0	. ?(ylosp-OGCOr8EthCer@o4E Y oeo3o;+To p&gOo(CЫworkQ3&G lKlivp# xkkuU < TaJ5Pҿ rjoޠlibrfu  2cdē Duala-O/ /' /+mb _O/A /E  /Kt/h$ /e$/k$@wva? /0  /0 /-vaanusBk/$ /// Mb////X/H[ eh:R
@adan . % ] @OD0V2blȰur %OE-O
3
GogMOH*  7i Y&Ȑ`Ю"rk@vucP`   iО` (s	e  na@ :t?F12):0ۤiP%3tappikoskeP԰0  'mma K  Ei m Configuratip3ordteur  <F1=A> Fichier Infor maff age Sauvegarder su?r disqdc R}a*r ?pa^'une.I_leиalsp
faupow du'Igno%mod1i Tqu S$e l'in@p$@`regom	\ Scura%
e0ssLdS"#j@e s?ous te0 0Ion E
?priphP %'-s s' IDY'!s
Dr ;LockqSm:P(C0 Prpb3r3R &he0Ύ ? `1"#a  K<`ڂgrta,	)84@7am'p'usQ ?@):rfrenc-fi P= `t"OuZ=s"lonnQL=b berieZ slecSnE@pQs@BI0A`TAEoV)mmoir@c"DW TC!WYFX"_V AЍc@Langb4hoisIYl3Ind)40_mps g eLd.r a#Z-:>+?AppuyeAa7touqpofPer`zuku=Ser, ECHAP=A l@H|AccepR0=OuiuNS #QU, N/'imp_e `QD
=Јaaw  Uzi3
s Mf'heL
mox!4dcle `hmenutcer8qБ@wbri@2hzx <E?NTREE>2n3j+`v	s	sui/fa  !/ :A-> ou BARRE ESPACE = PBe 1-$IE?preced S.TAB`CA*'ZMAJ+ix F2=1"/w-$!S(rr P<TJ Ily FA%ssibpd`c7L U cs'Jprodpzendp#B$P. Coa<'401Ac5Cnt@-?  emplace (t L' ĜRAQre |#'Y
GI 
s|^ccueil dP 4 A'{exUsmobiq݀a0N8p?
u` !2%vX	a ru Fa:c10MMTyp0osVprwDb fKTa@bcaa(L1/L2) Volu egD` ROMOamR Numro8ÁpRev cR7doerHtrclavopL}5d m`+/pH/:r3/\t4An2inv/zY&4 #priFK(Tte)OO oOOOPQB%'e@dA E/ M E:$/. g  %r4 !SBc;WalkinGg 081wlig'ad ušZC	od al0֐ifAPtiS)CB[a=e0truQiep Ɛ1ruP0sf a/AP, z{ n1rop°0c 	CY]A}jDLt_Av
 tro  PaC
`sTX	  _[RvpjaQ@d8.@On) m:Yf @f +-vPPC2 l0  VIgnoI+Bp|y EnGreg1ep/#=1 (rap )#>2 w(coet)u걈x0imA(pz) B30`s pAU0% nv 
"D9pt?l'h 0+BF~@ :k	aSFinnud'+, v@t
$.L0 Gp44A ib O: IDA?l`cs S.M.A.R.T. Aban`GV0W AHMY^@se N<aYP?/ ;sa1?"Q Marŀuin S ;,deco@ac 	AUQ;mme, v3K*ad0@Oo
bbatRs	幄Bd4	 3pe=a!`0q( i s3[	?ps1"t0<i f  f'ormf-hV0#0xAsAJ$@)ArPmB݊B	 J5@
1ASJ	.05z4" C}R av ou?voj!pA#frDvv@]	 	@ zY 1 R|f@f°c  ;lҲbgN rHP yP oTool9e2y MaArO+8Cf!}/- QuickLockUsus΂{aļc!ri 9`B<S&Nl'+ś)re!ca332K)m+:,  uh3/:/ / L'b(1'HQ
$u$!V
 #K@
dra`}a+pPn3 Exi,Aud%Pd_  p4ra8llp&;flash Y GCD-"'ǡEƠp*W0palX:56# ge Drive). S@@"A%Bde{z Bdeux"(UTILISATEURPRINCIPAL) "3E'	rR$SOj N`;z *sa1 FaA#1"hsr  ,pmfe0bcelu&N$ordib. A @QV	A{( oNV)Dod90 @fetqyYJ}@N",t"~"a1FX"moAfpv; {;""Bet 0ё^E)=?	>rJaniA4`#''l#2/r,ac̣Ë!k! 3PXg_!$R!ݑ s!y![ DZM']c$uel21`܂3U?:Gg g""q"o S~a8albE
/'f7'!2`+_W# q2d'originIl2v OB0x?a eB	uD(
v1SaP Q99ptL
4dj?PPsaހ{S@	P"{7e*ߵ
$!W1paPprsp! ѡon: topS 2as4pabyt!(fEk'
ui, appuy
@`  ECHAP. @NaTz˦Q'~o', puiCr1DF10`TapXÎR @wwX7^}	U/1Frana
OgCJi2MultiBay1l&ph0A Q3D,xsocaŎ(ga)pOOFy) U[<8& USBIpb
QƗZipbYP@: D hi@t @s QuaQCin NSi;xi Se ߑ  Hud NeuvCD`Permp/r(s Fn/Ctrl ѓ AnglP0SOA) Pxöopprms A`stanhnfOd'0adn elAtrl:'TichQÀuer0Ҡ&m`
*d 9i 7ido1+BidԢ 01 mmP VlpAjrF2?pal   R 
o=sil WWAN (rse 0il)!
gr 
LBlooCth7S/?.1  >o@%ł g@R`loc<G  dZPRrhO1":1abPC-n ho<2ooyu=B6ccunodogMB E%t$ 1A&2t3TokRingooU/Idu4:.ar`!\   2     hE ll ? nLreТ / x Ab!G.f*Dul*/)///wb ///// *R*-///Jrgn $, /,/ /e s` B'exsabmo p@ 
$Aoo


 [Qpe 1 : /Charp.  % ].  2D  @FicM*n3@	Rkio.
* yT @@/ MM./(OG/ AdAmorc ƕŬ5 Retar9dTexp `) D0 ΀F12tposfi +A!ux  Pav?	t@BJcun IzMlq <F1=Ai0>nfoPgѽemal З'Salval floppy%A0pttoRiprina dplTh
ifa`iܓIgnor`d ed esci EP a
l'iIP?z@biBtup@ic zzasskwo%e am6Prato``gcc#P
_Q#*vos7v% IDs
Ԥ&gDriveLocck	0Prƺ)S t Cp7 Supa;p@0c30 gH"g/o+:,i fabbr
4=8i	/.nzi`[Oco
ruqi Cb
5<bSae"ElrOpat2;o rigi-d AtaA'V˂,a mePTW X0`P<HKhMiM;A>o !Ava=t L@u!O l$Dim0"& q6ca X ssob eviQ g	v	v!'#o*62wH8Premi qsiasi wtasXperQZVu L   i=f, ESC=Annu`,aA EtPoeo=SEiSN1T,altro#	=Ap bj Us"SchiavI frecc'!i1vocu ap`=f"_`<INVIO> @p \k\'ke.i^guai  un%:` -> o SPAZIO = xsuWss`0  <-pBACKCE@c<8TAB@C%o"MAIUSC+)XyF20	>-= m "AC"IErrxiS0D  Qu A87n`pu?e0tVSi ?v@Pu3$|@N(J. C`{'_01  N0u&>Q8A0`}oggiao L {@I0' UA=Cre0Es@Oagga%Fv0pC!c岓  nPabook"ippaj:\KZ0Pf.at0Q A_2GoOurj&tdauP! N$  Ti*;S0/Velo?8wepp YMisca(L1/L2dcDAbROM@Iamiglk N oG`0("	R[[oi1SrollS3j2Aer` ~Dia,k@l3n4b`7`w VTet?(DFE(d)H8
	2
3
4$QV<FondaAĞʂ ,/:V$ THrc%O`u0y!'Tۅؐ lliSpr:bit 90t 1Rindiri0	iq]࿀P |'F:Aso:X%?gger?  Г |vep(re@M/r呧, @ favi0P=P1iVYXA:l\YUZA:l?].onopuh@^aOt!rit1]`mpvd2"I/ySɸSe2`v1oaPGa ?5?Eqb b i`1frea?: A_041 (Rap )52 (Complet"Җtio (): 30=V0%`5r6ar`'h$5|
C:s*Pp-  
PQդ(D%erAv{2)Lќ L 	Arib` i0gol: IDpĢfanp de z قi S.M.A.R.T.݂uÅTU  _word vp(nuo	2 pDs`1(0CUiL?`Ib
db?栦[cYnd ?
O-!7Tc1^
Am Ve
p";Ya Ib	t>J$ fuD0٤mx3Cee`<R aòu^tH 31a@C.Q]@WRbDFqo8P !erdpatiwEff+Jizso in@ahpvvgaΖOpAdes R JAm`YyҾ HP ptectTools Ot.` YaRf+ `ickLock^ spen@3Bp4Y mou s08 MM dp?#<#,00  gra p'!ore -e$S- ))v!PKCsm ] | "	,'Tsar/?pi?Plq NRC' |@pAUa|a inf rQa1)xBLчu_hqflash"o CD-" S%fWІp@	 XR= !C삍QcRx usanD: eq'. D8G$R=Q @@b~X'UTENTEPRINCIP?ALE  r+oSL man#5fu`o. An V ;FdP0s`Л "e qC=P@c;0.lPe!u V1MT[S,_h	@p\nBI br<4 dW|c.@aMP+ 	? q`o0E66 dG i8>@A
: ?re,@2$a d'?0	:D {sEU rF luogo F! iggFsSx, &F/	" !lwXdqޗҒ0l@w{skm  `.ԊbB #ȑSyPRœ c_( ~2D&S`LBg"p~@i BAV 	Pېkptat 	"K{愡P+`@u塸.1êN@B:ql0z`s115oqu^ 8SS! !QYar @Xa$Esn!O`d@'ŭ vg,mQo ESCFL'Í)dovr 'Zm'@po2mamF10.ȡ !n1jȗx$_ [XπuIP(i 3  O :ㅀ갱cL  MpiBay ba.gg)a0sdY)ohChGi USBg\"	Sut kHZipCP6opTerz POvN$@ec A!0 Fn/Ctrl Txd Ingl@? (USA)AXi`suN mpl1aP
@P 27p!l b!a0@0ŐMod#GBidGAACapa?mem A`X15eImՂsEl@dbQP2
ё/wpNs (WWAN%)zoLBluetoot}hCommu	Z/ (J)@Csmenerg ]phpW& ')1 N,2HB$t-pFa,(Po)olp/sp 7EthetW% V123e Toke?n Ring !OE3 Ij{C0PB}CtaaL   !o1Ӥ  C02b//  WD|S0aoo [Ki0Du pV /  o 6  / o ,o// ooda    /  o pTI\mo9#// /OOOOO D}///OOmZ[ Pr 1 :`#rto 9. @% ]ocomp#%2S & 4,n6E3
`ˀ
ij* 53
 IWW2i,E/'ЯOO A  ?FloppyT!ApH1d C ͥP(sec.) vel` F12b rwpambP NuPup <F1=Hjlp> rkiv Sy{infot Ps~ -SѺ pkkPigu 0stll frnAr0Pn@ard Annua nyd@` ochsl`   npQ SkerdtrslCp  K!aOB@rct-OaEnss	(" -ID
 afo
 m`
APd-Std frutQ!av 7K
 byggd 
 usBi=*abrikj+ .J
sbehrig#Esktsrktyg 9K +r vِ6" S ;vt`gQHDD Ak_V Minnes:" @01q5a@? An'j@A
Q  oVlj4rD`;CBnedttl AB-w(C-j+eTry@Qp?fri Dgp nr du viIN@stW=, ESC=Av'bry KaFT_AccepaF, V=Mer bX JvI pil	c	/pCKa yEt
<RETUR ]o1mF
uYRtt#.ie,lj`Sef%erI  : -> MELLANSLAGSTANGENTEN = NXS<-BACKSTEG FregeyK TABf#OKIFT+H& F2``+?z=  'fO @%Aoi?Cfel 3t gqL  kA@t h+AO` ~Dstod uGen. Felk0197 AsЊgF{ |plat@ Nt0hm krv?x PbyఐgЀmЅ wfly5s t6 5-dator/ ex@{Ytid#igOOI2-@Kkl@T ATk!NԞ,0  Prr, ty=p
hast^hZg0CaP-	rlek (L1/L2)dYd RwOM,0tum~ familj~renummnD^deo, rY tdNb ~PqyrrQH 1.z2"3b$4rbinv`ʦ3 (RZ)g	1[
p

Sek#	wIqq.֒4$ gAxr%8%xz=ok!vidClmisslk.s Walk0s - q~P f1jH` Adds SliP7Ae`ܺanVar! Du@/Ъ  7neh&CcsuskaUp!y /-$HЙفxi Ƒ=kabg$`AA:`̃Q K=Qhi{wI"B>skyddadapg

@݄ ҏˁˎ`b] %d?O͠igt?'jSF!- 1pna#bb@8f ީn X9UWkad k$0Qd }(Ф): 30mpn1>0%"X 4o/`]p9p0vrjMatn:,}t؂Ok@%S(x eorvo-LBz h(VF%ttribut: IDPx?gr`o"s.M.A.R.T.-5 G'ammNt.ifin0 > LP@Q R4d ƀ}vlika m@O@  6ǦaInEka?n orsaa@3ji9AHc@Nyap@Om_=<sћAlo. Na om h@glm!btj Deh ;els!e - ^uA"upaV!ΠV >D@@fun 0erl^i HP tectTools%yI,}-6-Quickp telgeG L0m<As HgHk
gb*_7- &q2@&!!!r ngo"pKpF5bli`Xabot. K7om4pHip p1%f  Pk`an`Flash-@: sCD-P0BWu O#4pSr HuvudH@y I: D, mv1h׆rdt d 5D`~e!. /谨@a^r ANVsHUVUD #|@0[mart w.] p? Lcp?q0il@Wfr0ˀ+A
 IPh!Px L l 7(@lHTwO.,Y   *oH `XqBe0bbyggP6Q1 !g3///dZ6- FXaO som# KE"
8(c!? a q?Dr9as" 'd gD\[ ktuaI` ҬafaAnqkq@.Gut!M#]tg`sp^AWp+tur?sprung`C`KXK. Vi  reko adF	B~c	WrAP+,ps@t```b@~. A @K`Ttas@u_Bh &ӄg`!(g~ApzN-befmse rm ihѓflj1fns. Tr0  p?ESC-!BS" U$_'vZ'R-sedMtapGF10.CcJ2da:c$~sHy% !Svea !: N?,{ MiBay#grut ~opPs5GiBaG (0r g(h ASBV n Zip-`<W sFj1tttoґ NT Vx0Fn-/CtrlU  E ls(USA0`blpYkd !!!њ bpTr;msptro2x,&gbbelѳorlekh eo2nlkPAL 1R sfrEs`i]otr1tK (WWAN)LBluetooth p/() -v@ANmsbeqAggs haB
E(M-1,d2Sv[,p8л'Ned Eth,& 0	3^n TokR1@N"!Unik *`?1iG K  tus    . ? Sbo KalibՀo  dP~- ʴ F=sbal Q.O
o 

  
9
Fo@ 
E 
D!m1s
Aoo
E
Htag *o 
P* 
VC| emoo]A*5oo e
DIO OKood
D?[Ne _ :w La@r . 0% ]
kWlar2uj253omFjOFA* &V@1  >I*O!DgOЀU®br >4sadap $lge!drjQpsnabb|0 (sek.F1 ܁BdStyraPgJuen!he ֔Ae/ `POp e@slaan Configu0poanafpvtndaardQ3!/  scy	Wij7zigS%ne@`programma 0ܠ0Setup  zr w ۃsvei!Behee rswachtwoo1݅
 $X. Ap aatbOg|l$$ ID's 	Sm4CP P Oau3P$Pc"R%mj+8%O
Ge 0g3 gs;svzie֏Fabriesks.Cugz7 ,/);Vref.s:nieuwB8ONc  ExtAccuwB ZeN g?eselec Eia p`Es ? zelftGa -schijfeai`Act PXvG0u ?1@I R!a/ 4UBgDAc*g@7n ,DP=%_
 w 9aKc!: Taal b  =r/em 	rijsgemaak el=;o" /;09
8ukAZ@ ]0ayNMLg]@f=S, ESC=Annul"EbDG0=!emJacNee fslui@Q, AQ-f`=MNHulppijltjkp`gebrui0d )jui~Pwnukeuzk@ark^<ENTER> ind 
cr]be8Zo !vol%@@01  0aiX:  -> of SPATIEBALK =>{<-BACKCEVorigl)TABb	#>EHIFT+%%ܺ2+Kq= ykp=t#<B~fouta6r4k p It w_3ge15 F0Mv0reqatijasFen. AcoZ01b`a0.i1ZCu  we   Netv3oe are0#F0MPNp diVbas`e3
 t n0 notebook-pcI/P @.istNOQb;ep*igdooh2L	MЛa\ft NmpALyp6roce;ssnel3Q̷ pp OmPЂP}e (L1/L2`Zapac?i VH^aROM @ -es!fS<mm <E  Hebvrgav_0ideokp&p;b  bpM	m	ra1b2rd3ďe4ahis(gI t}.jne C(_B(ЉwMdzQ%) 
  `D#/SecuibE.aw~~$DFtb%)҆2!dHU2L53Hac-0-*1Tho~_adresrlafwi}snd pao=LTop: zPt<ts e'ge t3 PSBbeЉif  s d1 A:og-  /ޖ"x0zbLe6`NoffaG1Y\f_dقڑD@`ѱ

bo
gAt
wXOC'We nu duъ"N
wil?oݩ""a? Ox
Zl"+1 (b),2G (U0Y ) Аpqwrpn (min.): 30aee&p:L0%Qtoo 4;q{hqo:5broAD):]eeqx/nb!p$32#kvo-IPsEI"
2ހ"qk:J S.M.A.R.Tc.-af@0APP@udh "/Blo!  A  I-7B4kXqc rlpSX8
 Vr!a1&\ is bBsAYohCf#/k, T=m]lijk0pUKQߛ zoFik` dvors:ka?0QH fQeksKPug/zet,r lorZ@¶ZOb$ uswb sqwYfur9h7oud'Hi`!  AQ`R`T`R@&BѴ񡘾 vuaYߐHP Pr@ctTools(*%/D  p?gsp0p`b TWmE h#M"g$rgβ9b   ~e!rX#W>,P.o(h( o( S("7'EAJb"f }k otraakP)5w sXb tK;?ݳ ]Qʢŉ p1׀frapd  Par౤ˊ Flaosh-malCd-r@WHNǉHoofdXVGs`
jE  Uq13xa/ia DQLc7A<i!Pzow*HOOFD-BSGEBRUIKERS8_L1n  p $an=	 SsC  cҦwacJ#!. fy0k#0hcomp s%ks Mq~[p%t Pᓀbc(q.  `Y0ppq8_{!AutomKc%5:)z2U@Ҁr<zdZ==}88 O!V)?!2:NP O! !. Mo0XeM joOtD, `  CjrS80ΠRU nt@`Pe@	M/ # hui,UPd`wwas sto/!k wggea. pwWanvlCoeC7Ykj(Y0TsPn`pHZUt0rAra=8	R0`
 torH/) bget.  Oo
 s @vbގ. OmRun@
1]A&`3fe*p& gol 8q. Aݹ_Ա_õ,ubhA dcp3䥼p3ruk3<AESC- (A9 0DRi r4'k'tyUbkn F10`ۀT*Zlutb r3l`V4  1Nel@@g MultiBayj!Vzkd@\!base (k3s)re  USB-Մ c`b+zp-"3 Er@we钱V V@{ZKes >Z῀>Aa8N Fn/Ctrl `Owiss/`ߧSStaMcW3MijsappOXu e 0  Bn ӫ$l \Bij V o-QPFA/A0d`ditwion  G*Qvgp<uq~ntilat ?p neqWdr%  Radio	k WWAKN-CaofLooBlueth/oJ<@rgie  ŁaQ\aL1^f/(b!)`ߏcEt@& 1
2
Y3iTo}Ra /-OMoo!023 UXutơcuJ< 6us    ? SaGekal!i@!OK"r2
N1fŌ ualqS\JOO O HZOO O^B^'OOO H~Ap!գ
O$O"LPle?r-MUE-$J$ OC$Pq+OO+O  [lp 1 : IBboʱ. % ]!/&hp[d2knte~l/{	3 	̄
fohl/)* Jt  ;>.C,$" 6a`؄Xadap &АaPR(sec.)#pop-up bij snoâ ᬐF12 )Kbb  cursorytuyEasyPo-muisG R?s?[^̃ZbgA` viSETUPj <F1=w?v>t@C? VXe? ɊւA\܂@?ps0fBpNɕۑ ݒ/"??f H?g H?o?y

ɖ߄ ύXɏI  
`AȌԂeB?Q a
%4erL?
 ?_҃pXh
cd??.oCX F@\̗L/c"ID h?uN `(A"͍?"X{},g Jq

.k/T|0qf&?(  4('2"x`7	
FX	 ̞ؖ&cˁ[ :o<@9̒ I$A%ea5n"9?@>e=@IvV?>OMD;??? `FA  ?C  ?+
D
4E;  ڍ.
1RG0H@!ߛ!C2f 2
N
OOtB0r sCHuc!&/2!21 ?L[`JR>^=AEsc=v=Z?cso<c1͂c  KA _e^ 24\	gۗpUjb?Gڂ!`PAg ]8[Eo]
'\ ȉlc'AG ?&->>gyjH?o[ = [\  <-@[BackSpace] X#Q[Tab!_E g[Shift]+eA]w[F2)))_10AAfmF/[ %  >G|  |?">ł tbr?hPf 0@쌻8@|0=`g01CɂACO?ctڑKv?ihL?O x	GoAmWuB]MEUE?Ȃ;O
B
P}퐋} ђ ɰޯ? ۾  x ïݸ ?ށiL1/L2 " ROMOM̧رٔ?  ?޼ޮ ް?۰ׂްޯݸ?ް H"?ޯ?1234 ?ŰB0(ÂC)34
e?mAOJ?_o fAXghF "t;$jrn? @jako0u2!y6s$7Wal0s	1(aU PX 0
 p^ /0x?:aAlƁA> >"pׂĎ @[1/`}p쐬<%A:`?݉pv!x4}oa M 'F'NeoIRf`H֎~`SjTOC GqP  5ǁBpТQ	HCÃPi   I//'`ʏ*o 1iÃNPÐc2_iS3.M.A.R.TAR\zs?ԁi?j: 307r  ;Tx0% \\I] OKzs1>~og?f bt:`xtEm0cQe/)TP={IǂU	ߦwFFIDp<{v.?a1 @RMM}BV%ᒇQ @Ita ? P &E ͒1"0&0ǖ窓͈#-ƱpF7vʓ>̏߼Ԅd߽s?<22!QdPJPB$ѐ15fی` DQP?J%	Wc(a YYpЛiPRa@ůƂ@"@a3`a
 П
䂩 " #VHP ProtectTools\{V}lWǉBPjJ9 !^e*f&,q HR P? Űuڃ){*E$@-xeE8*&&Mی삟48g<?"蕴}P` t0啴?ċNA§4v??ApK ԊO @B mzdV?dAR_CD-0.ak`Z}^ VM: !U?iِ@ԋs 5n[rŀv
q0`K!zp16B; b)QT81eJ(2q	 i 	i`>|d!C?rN ?ЁPR?s^痣aES{Ȓۊ2 BC`!VCm%'Netq߀@73SC"@Y.	j \
e퐶Tۏ؊ԓł&B͗LQdły`讎Y'''b- L! >cTF}3Clo@'@>@bD1&-`/&G`u`xАP"+ {&ਨ?I'' }$/B&E&%%gAmw0ɑƈtFI" f9ɉe@v^S太<P߇. 5͢  >gx@uȑObOS"&T(L - Rj5#ߦx^ߨqlӔ5C P.Կa%rA[Esc]!`K0xȍ~fkh"ooDriveLockƠݤtF[F10@tyM@O   rZK5?`t|b?: {Bx"nCxa԰L?O xPXi!OG;ECUSB6 X`p'A Zip1ԖW 2b 3 4"U567B8910r Fn/Ctrl#̐ؑ `{  p (USA)??|Cb
fo X?KVQ!T	vXgP~ ZJ?_A=rIoI@	W? o TbPYdO?Qڑ`t킿̧?𵰡?]lAWNiWANjFu
MᾯL?Blueto#otq6/yjT~@ߓd ?qIntel  Execution Disable.+%-1d.2*,,,DEtherne! 123 #g 
1
  >G"&$t3?j'/ ID 4bK qL      ?A̯
c_ fU ^ 2hdZhn?`_
nabMEUdpO &&Evo  ogv1 : [d? . `% ]/-2  HFO.Ov3@	b	
h
)* v   /2x/;%o#go  AMD@oPowerNow!` technologymǕA~ A_vqӠ ް  ?# x?(ϕb) PsF12@?ԁib"rϑa^`` bᕻ#BQ                                                                                                                                                                                                                                                           <  ` a b c d e f gtH L           	 
    č  
  ܀       $        &         |    .   / 0   3 4 Z 5 6   ( ) "  , -   * +   gmp
 uN % @.   gmgm@gm$gmd+gm1gm8gm?gmEgmDLgmRgmlYgm `@E<B߹B<U> FبE0`8l v x|v||p0p7c   c 0A ߐ  = ~ 
=$$$<   DDD    O aƄe  i  o䔕 u  {y @  n%Ap E%  IC&O p  U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( )' +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {{VROM+*'(

C$: |  s+'(?)+'*&83&

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      g|gmA  gm^@  .@  bGgm@ ED U@n_.gmL@)@ I mp  ?q@TrA*rBrCsDsO*uFTuGuHTvP Ja 7 
gm9 cegmhdgmBbgm fgm1hgm@q@b , gg+m@W{Xt|dU Zt}[}#L  ]~&  W_t`$itVaV!
	$
l 	 
U`	
 `
U`
VabUcDdeDf4Ph(>{&_4`gmF@ p U  @
 jް( 
( 
r lR0 |n }o : *ݖR  	gm$ $ 9 D0 VF10 Setup Image_SE_TUP  PD	Sq  ; T	d I*v@Jä%"IP$ a|`պ 6
P&$`ԩC ؄ ٪TԫTԠ*<Rg!"$Dcz: 'ᴳ4㪴4崵d窴4D8b_ : (gm
6  ($))$**$++$,,$--9 -g  0	`
9 
E#8i3jG@ l#!" #" #" 
8K RMNQNOO '8 @
:	 
      /ʠ	Hc  Pւ* N  % ]   S''U!(( )T)UU*V*W+X+UY,Z,[-\-].3V
gmUd-dh.h1diUi2dj3j6dk;kdlNldm@mGdnHnOdoJKdpLpMdq5 ajgmfoqj$HrHs $[_cgm@ {U`{|`||U`|`}@Р{U<`}(}2} ~H`~tu wx~zr{  }Ut kv 
44(3)]BxU`o2您T$\` *䇧0L'\Ut ;VJ
敇d @9 ڠGxTpna%LP@ UZ ` t @ՠ WL@ > V Ux @ @ LU@ , F R Uh@| _N Lʀ} L6@ UP p  @U @_L*@ J U^  @U @}L&@ U@ X r @U @}L8@ U\ h  @ʀLU0@ R d  5@
	@ UT x  @ 
L@ $ 8 L X@bn @ @L(@ @ T l @ @L@ > ^ ~ @R
@ ^ ~ U @ހLA@ H U` t @լ @WL@ : \ U| @M @ F Z x@ Ԁ@L"@ 2 J ^ @ @@ < R f @j @@    $ (@,4N f@ @" -@ b   @L.@ X ~  @ƀܚ @ ,@ X   @
*@ 2 @ N \@p| @Ě @@+@ X   @(6@ h j  @UL z @ր}LB@ Up   @S$@:@ d  5 @;@ Uf   @M!@  U( : P@dU @U @ @T@6@     U&@8BJ UP@j~ U@ U@Ȁ @ T9@    ( .@6<K\@x j@؀!F@ : V v @ @"9@ 6 N f @ܦ#.@ Z j  @ $ &@ V ~  Ԛ@*%@V@ z   @&&V@ p   @Q'2@ C\ n U@ 2Ԁ(TR@   > U@@DHL UP@TX\DUtvz~ U@ Q@bAi @5Ѐ)b@ U@ ^  @M*@g@ N Uv  @ƀ5 +:@ U: T h @ՠ ,T T@ N t  M@-@m@ 4 UF h @ն @.T [@ 0 B J Ub@r 5@/]@ UH Z  @50q@ UT t  @S1@Y@ |  A	@2@h@ ~  3@x@ fJ   5 4@i@ U8 V h z@U @M5N@ B UV j @U @S6 u@ D T OiOiOiGiA` @ƚ 7b@ BT "f @M 8 @ : ^ | @%̚ 9~@ T v   К :@y@ :T AiN v@ռ @,;Ts@ ^ t  5@؀
<@ U, < V b@Ulpt x@U~ @M=@ p բ  @.>To@    S? :@ ` r Ei @&@ @  Ȧ  A@ < T l @ @B@ > b  @΀"C @ x  ̦ Dz@ d   E@@ nj   
F@@ t   G~@ p  ئ H@@ f   I @ P* p  @Ai @JT @ D r  U@ U@Ԁ U@ 5@K@ U  0 F r@ Mi$@AiEi܀Oidx @AL *@ Z |  ! bIiAi"M@ r   @N@@ h j  @BO j@   2Pmj@   .Q@wj@   "R@j@   Sj@   T@ v   ܦ@U@ L xT C@ @Ai2(V@ P p EizOiKiDOiGiĒEi܀A @W@  4 F j@~ @(X @ j t  @̀Y @ , D* ` @A @ZT @ b   @[T@ Z n  U@΀ \@Y@ D X | @ @]@@ * P x @Ȁ ^@@ J l  @ހ_ @ p   @`@ V  Ҏ @ހ a @ " 4 P l@~ @ր b@ 6 J ^ x@OiOiOiAT @Mc@@ @ QT "v5 @d@@ U8 Z z @% @Fe@@  B Ud r @ f@ 4 R t* @5@΀g @ U6 F ^ h@EptA Ai@|U @h@ n  Ě @i@ *   @ң j@@ V hJ@ @S*k@    Һj @l9@ , @ d @ m @ V v j @n@@ l   @o@@  j  @&p	@    q@    @r '@ j   @d 
s@ 2 T t @ Ī@̀ @  It@  Ai. U4@J\| @Ұ$ ƀ@Oi u @ B* d  @Iҥ@؀A v F@ < V p @̚ @&w@@   0x@   .y0@   6z@   @{5@  |?@  Ț  }@ > \ r @TAC @~w@ AB2 tJ@EȀiKDiG( !@ A& 0 i6 Z ^@pR @ҀM@=@ T U  @ڀM@^@ : UL x @5 l@ U8 X n @ն $ e@ iL l @ @3@ , 8 F f@| @
 h@ > N l x@~j @ @ f   Z@i( U@ n @Ҁ6@ i v@ J@̀iS@r@ 0 N Ud |@ @Tt@ : P f 
iiiiPGA @؀  }@ , H "d@ &@@ B id %j @@ 8 X h@Ri5 @y@ UB T f v@U @ U@   i6@:A> iB\p @u@ d   @n@ H t  @ʀ S@ , N ` @r@ R \ j x@R @i M@@@ l ՚  @T@ h   5@@@ Ur   @S"@ d  5 @@ Uj   @S6J@ |  5 @ @ UZ@ v   U@ Su@ P@ d p ƀk~@i i @i AU @Yii@A(E0i@R P@Ax M@ @ 0 AH f@j @@ @ `  j@ƀ@ b   @,@    @ |j    M@ t    @ b  j @ *@ T |  Ii @IiI@ X Ef@DOiKҐDOiGҰJAi@̀Ei@M@ " UB \ @5 *@@ Un   @M؀ @ 6 UP t @ 8 X n @@ V d ~ @j .ߪ@ v   @ Y@ F l  @  @ 4 d  @@@ T x  @Ҁ6@    @ jT  @ @T@ > N n U@ S @ R r Ֆ @T@ T z  @ҀOiOiOiGhA@ @ ^ x j@@۪@ H f  j@@Ъ@ V |  j@ր@ N h   @ꦀ  C@ \ t  @Q@  0 L Uh@ @ L@a@ $   U"@:T 5@Ԁ@ Ud   @S:@ t  A@ڀET@@ J ^  5@$@@ Ut   @ T@@ . D \ Ռ@T@ x   S @ J x դ @,T @    S @ p  5 @
Ā@ U`   @S. @ v  5 @  @ R  AҐ@ @,@@ x   @Ϊ @ހj @@Ȫ@ & . 6 F@j R@A L @E MiɪC > Z @ Uʋ> h@զ @T@ T x  @̀Ai( @    "@@   @ @[@ j   π@ z   @ d   @܀Q@ CT f @ҁ2պ " OiFDOiGib@R @Ai @ҀT@ F f  դ@̀T @ V ` x U@ SL@ F Z v @pښ @@@ ^   @⚀ ~@ b z  @ԀAi @T @ F j  @ʀAi Q (@ Ai8 > Uh@@ @ b   @@ Z t  @@@ T j Ai @@@ , H Z |@j @ @ \   ʚ@@ h | OiOiOiGi @Ț @ 4 J t @j @ B T ~ j@Ҁ T@ A%H l @U Mc@ : UP v @ĀM 䀭@ H U` ~ @M@@ * U6 L V@^Uhp t@xU @SI@ ^  5 @@@ Ux   @ʁ Ei T N@ ` r  5@.1@ Ux   @S\a @S@@ $ 6 Ub @S @ x  M  @ \ Ւ  @T D@ f   5@&@@ ~   T@U@ ^   S @ \  5 @@@ L x Ai@ @J@ AiN Ai`R@tAi~ @JEi ) AiƀЁ M@@@ > J Z r@zEi@Oi6j @@UJ@   A@5؀@@ U\ ~  @
@ Lj  @Aܦ[@ n     @ d   @$ @    @ t j  @Ѫ@ \ ~  @܀AC @ > V AA2inA@EʈiJDiGUi 4 F ANdn x@ ܚ@ @ H b  @@ D ^ p @  \@ .R @ f@U @_\D@ b Ul ~ @ \U*@ 6 D J UX@^ U@ S@@ D V Ux @ @W\8@ b  5 @@@ U@ \ | @}΀\<@ b    @
\@ , L d |@ @@ @ \ v @ @	\"@ , iiiPGA6RUl @ @"$
\F@ \   @Ā>\ @ %B Z@j @ƀ @\@ , < R r@ @

 @ 8 R d @ @ \@ ( 4 B J@PT^ t@ \:@ f   @*@ d v * @E_\0@ ` n  @T@ @ Z   U@ M@@@ $ U0 D h@5   @ UJ r  @M؀&@ T U~  @S  9@ |  5 @,@5@ Ղ   
T +@    S@   5 @ @ A> T j@x @ZJ 7@  $ , 4@<DN X@bl @ @<@ Mҕ28 EHT
i\ p@~ @ҀF$@ A0 U\ @M  @1@ l Ք  @B@ h  N4@b@8 E@ 5  >!@P@ M  " T@ ~ M # U@  M $@8@  M %@I@ f Պ  @&4X@ t  hUn@hhh iTAi2 @EOiK"Q'COiGJ@lv @ˠ @̀(@@ H l  @)]@    @*b@ \ r  @Ě+@g@ > d  @Κ,@Z@ x   @⦀ -h@ @ f | @@".@b@ d   @&/@I@ : nj  @0@i@ : f  J@ށ1@L@ V Մ  @,2 K@   3T@ 2 < P@dz @ J@4{@ Z U|  @S 5l@ < ` U @̀6 W@ OiOiOiGҨA,@Jf| @ @"7T@ l   5@ 8 k@ Up   @S9a@ R z Ք@ :4@i@ , J Ud@ 5@;f@ U> X ~ @UĀ @S <@@ 2 8 U@ D@HVz @܀=Tt@ P   M@$>@@  5  ? @ j  EҼҦ@ q@ \   A@ b n ~ @ @@B+@ J   @C:@ |   D @ x   E @ j   @*F@   ަ G@ j   H z@ tj   I@@ d   V@ JCi $ UF f@~5 @KU  0 8 B@ULV` h@Ur| @U @ML@ > J MX  pEҀ@MҖ Ai؀MT@ Z   jƀN S@ ~   ʚ@O@@ @ Z t @0P@   Q@   R@@ ~j   0S j@   "Tj@   U@ D Z | *@ CSV@@ R d Q ҁ2 -@ WGi OiKi.DOiGiF@d*nz @A5 Z@݀5 X@@ UH z  @MހY@ R U\ z @5 Z @ UB V v @U @S[@ \  U @ҀS\@ L d U @Ҁ5 @] @ UJ f ~ @ƀ ^T@@ N Z ` Ո@_T@ 8 b  զ@Ȁ`T@@ P   M@8a@@  5  bo@ U2 D T h@U| @պ cT@@ @ \ x U@ Sd@@ N n U @ȀOiOiOiA@e@@ R p  @Ȁf@@ P v  @ހg@ l R  ؀Sh@ > T Ut  @Ai "i@ J d  @Ā j@ l   @ʪ @$i@_ @k@ n   ަ@
l @ `   m@ J p ~њ@Ԁ@"nT@ p   So@ j x U @U @Sp @ N v 5 @q @ U\   @Sr@ p  M  s $@ ^ Ք  @tT@@    Su@ n  M v @ r 5  w #@ UZ ~  @( @x @ H l xh@j @Āj@Ѐj @y @  & J `@ȦL|$ Mi@AiEiɦL62@j@z @ U`   @j {A@ P b  @ |~@ P j f &w@o}%j@   .~0j@   B I@ ʀ @     @   . @    @)@ X v CU@ S
Ci2< H %\@Ei@OiҮDOi ҦLU    U&@8P` U@ S@%@ J j U @M @@ ( U2 H \@|@ڀ@M@ L h  @ZL @ 1@ B V tF &@Ҋ U@ S@@ J d 3\@@lXդ @T t@ R   M@@U@ x լ  @TV@ d   @B`_4 @ R b@x @ @UC ( @ X Up@ 5@ h@ &Axb@4  OiOiOiAHA Z@x @΀ U"2 V t U@    @g@ %L h |@j 
U 8 J Z @ip @j &@@ D T ` ~@LĪ @@L:@ t<LxgL@4P ~@ @@ X   @y@ >D Aij @Ҩ @T @ t   U@ހ S@ , : UN T@drՖ @ހ T@ J j  ը@̀T |@ \   M@@ R U|  @S@ n  A@ x@    @&@@ n  R @ M@ @ H Ud p Jj @s} @* @5 @ ~@   K@ KL<AiX fMi.fAi|Ԁ @ @u@ F Z t*@A@S@ B ` U @M @ r 5  $@ 5  @ x   " @   T@ v   S @ v  U @ @ CX j* z@A j2܀D@ . OiKiPDTOip~ @@ P@Ҟ К@@ H j  @즀t@ H ^@    j@Ū@ L d  j@Ā @ V   j@ր@ l ~  @ @@ : H d t@Қ @@ > L R v@j @@ V x  @@ F v  @,@ | T @5 @  @ U* < H f@U @M@@ > U\  @ԀM@ J V f OiOiOiҨAr @ @I Z@ Z "| U@ S @ J l  %& @ J  U^   e@Aƪ@ l z  j@؀ @ " ^ x @ &@@@  AiU @"@U^ @S@ l  M @j@ ^ p  Ā֚ 
@ 6 ` t @ڦ @ z   @Ҁ À@ 6U2 B X@|զ @T@ p   M@( @  5  @@ |   T@ \   M@" @  5  ( @ v   &T@ d   @ 
f@@ H h v @ Ք @ @΀ tL榀 {@  * D `@~R Mi@IEì2@AR"@ Un   @!L&@ @  0 P p @Ԛ @@ P z  @榀Ѐ@ Z   @  @ l   @ @ T z  @ J@ d j  @ T@ Cd r @D ҁ2(VL @ Oi"Oi>@@ V nT@Ait @ @@@ b r j @ݪ@ L \ r @ @ 5@ ^T p @ @T &@ D J X Ut@ M@ 3@ , U2 ` p@U @S5@ 8 N Ud |@հ @T @ < ^  5@@@ U> Z v @M̀ @ F Ub l @U @U @M @ . UB R b@rU @U @S
'@ 0 B OiOiOiAVj @j @@T@ "P t @5  C@ > j  %ҀA%@J%$ F %f@U @M@Z@ > UR h ~@U @S@@ H T Ud t@U @U @ԀS(@`@ X  i AZ@    @@@ 4 b p @j @$@I@ ~   Ȫ@ր H@ 0 B H Z@l 4@P@  L A>Q@  M @ n ՚  @ @ r  ̦@  Y@ f  @ \  ̚ @2@    @j:@ YJ@ V z ҈@U @Uʀ @U @M {@ " U. H `@zE Ni@IҺMi @TN@ d   ղ@Ѐ T@ H ^ z U@ S U@ N l Ո @܀TV@ Z   5@(@ U|   @S  @ t  5 @@ Ul   @5ހ@w@ CJ \ p@J 2ƀ Gi Oi,DOiF@djx @$PnPgm / /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 < P Ap
P
0
 
@uG   PHK PWX @_` Pgh 	`opwx
  >	 0 U7 8?       @R   >   ׄP(Z0 0@P`p @@1fSfgfe_f[  Q	fY!PVfЀ!fXPSQR Js# h2fP u	fX#  h CKZY[Xgf&0/  a$f t
fwP
 =~p

u
f  ?
 fvD 4 zDfÿ
+u.fPSVfWf!~Dg&D= $ <vD# D| u:tY)f_^2Ő
DaD f%f
PI f5d
 `ݐ	\
ad
RfUQ}NtFE)} fP4(  t4E;Ir4E&_fX
Yf]ZT35t6g&T fq"6xSRGfP  , t_t? Q>D B ATkf"Q3fY tdsuP/tvvAs@f7fKq tQO#Q;BBSi"$|>J-fF;f=f AtsfAffXZ6}QVfq@t/QAN_<f31pFtBC餿  A?  @5u
XuAy unfT sy_>p fX
8 nr:;ǅaTv 1S Qx<t< 0*YCBn
C,0 _d> ud:u	d:uu
uXQRVW'f1ht> 333
3
2 atfY~sB!݋ދ3_^ZY
j0@	C	zA	@
u@
u2TQV3bbP0 :_t ffKfbXg&狄h $g&t$fffb%q%/
AX_ +brg&}u'{bA b bA^T_C&f% f
 SsA^[0f=@-HD@-u<+c'4mfAM  } Kb#]ia f!d iiS!5fsbQh ^R:轰4Rf
. ' Aff
/* U<AHU(Vw4dRb@7frf{3f;`fG|
dTCp|s h=*( Q +( i7Ru_W߁f|fQݳAt@`tXf3f+p| tfP9Ltfr fmYS+dNM t+fROo/i2TtTfQtU$A&rQ|a f~f~f9Dufшf\ tt]@ 
'>; 
&"S#Kf$"yB z3s _7~ScP@%fd`;[vd
fG~_ _O5L52lf!uΰtu@~_fYEP@}>
O`i_9f,ѐҐ ws#< ?9pw f_{'7f;K#h<_gRkQ>Y&?9G$
u	?9"/Vݸk#tt t ] _7dPSS2"c+t?2 Sey>`1A :1dX͸ҺdE b `XXE@rQRBB% 	1; ;q@ѨP| BAPr%tct 5 Gsp' YІX/fbg!TرPxfa詡C|sui[1=ș dɁ#}ZZY<3"$Z  Tb o SP    9LρDDfof4p foft ( 0yvy_,e@zoc|>_$LVybwb 7:^P RfW@vs<vЪU@#fP0fof wfGfsbf]X@E'us]ZYnU1n$a.f3f;Wt! \ ~XgfqEr>fù1gf{ 
gf)Cpk{ "]k@{DAPfK
`*.	u]w7
8gfe!5>5-q#s,zV  626 ^BQPh.. f@;ou 0|%`f.` ?X  1{bѧSpA /q10*0 op%%` ppԯ󩰀A	*				 
	 
	 
	
	P`I@ fWQ[fǀAYf_fq`.9D=-9J.D$>#9%
ĈDX9/r% >-9tfab|oaZ!/Es"/$*.`9rMd}@#r;!`́|= USBSug&׀|=6 t}

 -q
`VP9`W h9Nα	 p ar@r  2`j̿z
i
r{``z.3Rീ><9t r(It@QfF zfYi=om "3f5fgf^Qw? fCrꝡ.f+PH e`DfXO#B#pI#ܡB `
/#(ksAW6.("CC)g&D=# 11W?4#-ـT2uooZΟ=Z
2(y
_7
_=%2tT==S$`E1\@ Q F4s@RP2{ . h >u_ g` T=
XS(fT= &݈ v n
un ؍tB`ȴ	a8 >8989 f+` fǱi^Vu69 99 +.4f.64CWK:0fIr!rO9 UAC.B//',=*?QfPfazXPgfufXYrmv e:pQ
^>G:/
sl`oCDBD?e@S'l=3;8t t9t
9D `/ƈDcI=t pr
rY, y%tF}t=~T= t2:t+@/:ugȯ}Q(u~a*jrtBd@=@t=t=`	t= h?ϟTB+6`oaԾ`98dtd&/	/h98DtD$j/S`8wtp 0 /[M૑@pv   	`@  %K}!+9,9&    !# )!uYP  ~ :OO~P@N;;ECEC4j5z66;; UWRQSPVrwa;t ur6ffWRfP0e Xh,fZf_ Eup9_aPSƀ pru2!9%@#9&99/aI4'(9W6*)9Z[XF f cs` t3  ^X[YZ_]e È<[?90Q pU_>`\_ j0fdX!u!=9! ȃ uddfd  >P6pۡSd d?dP 剱(=9>9_fUn}:f]P:t,>@u%ttt t	tfN TtF r@u`a;js
 1QK6uF .f$N
SfQVێeS trـ?{D`*f xofpxT ff/fXs "qy#uptLeb{` y߀uYf3ffe89-fWpe*&898fw*fF*2t*e&99^fY[1j0_8'Q 8 c$@פ[R0W  ĀuL̽Gv9eK  \VK|$YSQVWU&_ _ i]_^Y[LS-120ZIP 25?0PSQRV:1:+2:,+2PKp
˼#w
 z
5	 9#s!h)e[{rgRc<tV< uWQ={fqQ @u:uFfG_(RX!X   JAZY0_f`_u 29Q_+9%9,9&9Ǣ90 xRW/li} tE/l_Z[M-Sys   DiskOnKey 1 #a4B_ u @  f<x fP 0 R?" 2r@0w1s s~Ђ ~ !f@fPuL	sTt6Xr)g&	ug&Qpg&oC,f_߸ PAـ rLTf<Q'R(RVPeF5qome}
ǌ;p t0h0jDt{@ u u#P-30MAf?LfHPN N 
1fXuײU?D0 @06B0B0*B0)B0G05F6F 	  3FPRo3W1>#>;!2>
d?_Y<h7ԢPh`p& 4  hw*< ZPW+ 1s!$?
u$˄[0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSV      Z *8۝6ܿT!
  * 	"_.>  
 Z DDo      cSFC2D&DQr! ru
>D? t ,  > X tDDD>DDuݧրPS< tCrD!~DDDDgՓQ	`=P `
3ۊ؀`QD&.EUDw/E3PDpVS~_@t	[Q_[^fPQVDzMD@ _.fu?uqoS1I_ Dti_h޿QL[^YfQVfU>__S>5E>_&2Eat(
ߠ}Dpg&`DAD[f]0t>DD r11Dw%0r79 "_?;݈0r믻D   [h;b}PdXpЁ)E 5`=]Q	胢pt11Dh[4E$r4E&_D5Edfp ߻Df3{Y[fRDff3 ׉0
Ef@`F E *  P<Fu3E3t	 Dt<Hut2HtH >Ȁ$utPaX]0E a:-E uB<Ft<Tt<et<t<t<Rw*<Ir&3E
2@&tH>2E`H4<qurYVWp HtAQ qft(PǴ:1EOu 
  gXfCY/qq jq9~ w21EkY0ED`&/E8rnG-E>taRw>
$_^tvD3ED2xDf? t<CpR<tSQLذ&Y[ٰu
l  ef l2ggh
0iP @jS\
 ? @  Ps ` pr		
			 
	 
	 
		PP@ I@ Q foWQfPQ7Yf_@f D5 869H9sU(8{f`LD$&8
Ĉ?D PLJs fA	?g&|5 @urr`{r  a`KzLa	e	_AKV	u	`%LfPHf%p$ffDfX\8
܉ L{sP 5L5Lf`tCg&Pp ul=B`ԅr`B>8t t9t
9wD
ƈD\0fpJ ~X9fW3		#3r|`D=!W_Ԡb
D @ $4Oq޴Z(f
T= &Pr\2ցpu.?rDQfPpq?.8Of.64O gffZf,fXYf\rvp+)
 
y*/
0/
 
		D	Or 
/
"
#6ݹ H	/	s` =sJe|=td h2le t*T=:u2?@B(uqa&rg=@t=t=`	t=`,?960oǝfa!&L	ūL$ ""uLPP ` L0   0klSBd@bd    D  o` @h 00S 3`Qo  
A& sa %  	'%
0`j#
 9ةcl
q 
3`@Aw& <q`. @t@ 
 b
	 |F
?  "  d q 	A?  % %@%Q
 +3F	

 + (PE+
3$ 4̂ C8$ +(3+-E-( C -0294 - (`(E E3  .c+! 0
 @ /9F. 7'GC@<6A6D
!:7'  "J",A!E?9B@,3
O<bJ# 
 S<R"G 3D%M TVaX aA8@8'(XAIc  WI @@ f  gf    P h5_gUg?f h,6$l H hvhl fWp0t&fPfW
f$ff=`uf_fX_fa1zqtfPQ9`/.ɉ///+f0۠b@ ɱz?2Zgg`b Q PQfWfV$UUf* U hy<F  ۊ'PG3 .;Yt3f^f_YXgh ݟPRVp8u`*h
/uh|6%!? hV^ZX2

 
._2X.f`QYr;f.;[t3Uuf[#{fpf frSCgf= v	 +v: f3[f́@  f[fP ˠ 6[Ã tL;   ǰ;Ptƿ[ !.[fR AA
?Zf!)u0`b h0+*( Q +( ÑMar99p	 VfBHfffROMIfMAGEP;uq WtgLNf3KPQ߹J 23fG`ZYXuPwag&GIG ШQ2hLt"Ot!P  t}	V   Vu'f t!awp @ 
G9=4 BGp?Gf fCf,?9Њr8fBR
D;  @E1"qo, b t Vc.Vb`cep~
>t1hak  	s!$      [",;  PfSQRVQ@ D  __ Y_cwVG˰ __[q<pX fz_`A> !	u*bbbb>bi`6bp` -Πg1	a_P!R	g Ā>~_ T3  cU
uF V
Wu_ ˷煺   o鮃!uP&C PuxtVt	uT~R_d:u<y u2d> u	a (!ubufz_fdbd= I^ZYfg&8Qu	?g&PDtF@sPVS 9_Cû h2o{՗[^XSRV1_Ws^_+;»A$s11Z@XPfU!f~`((˰x1ְ6]f@kr0 #3# U 56j8 Pbbbbbbwbp{SV.&t{b-^Q P7W>bbSRȰWu<v
b,ƽb@bʀ 7q_G#B`8r )` b E:S	A}1@8b":bw/bl
/(	c t
	+brg&JAEtb}rbdr!H"bKr
? Jth)	vc_ZЪtĳbB=2o8'13
	R	u_`CI@V$ࢿ_TXp Z#,[$$_;;AR ZZeR J[ \ ~]eP&abpZ&@&F]da< u}12R1RgtXwr),u)RG`SQr9R'$8t3Y[;tr$VOHAr(<Fr(!sq轳trp@ppq.Y Y0 NSfQfW
BfUgg& suf3_Ɋf  vt fY[`RVfW~Ӧg<t,fUgR rQ8tfG@^fZPQ$@Gّ@8tἀыUvPPhF X PS&=hp ;h؎[XPS=hga@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               PQ ֎tu
YXP@ ĝ` u 
Xf`<؎ Rf쨀u Zlfa4n   @(00	lf&Ef  pDp   &Et"D  $D( s `ف&tȀɿ 4>2@"۰Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m 
 Gm p-'s 0a` aװr * $OQa	 & aSQf# $$<@t"h<fP u	fX#  h KuKfZY[Kuף`.> st&3r	&*r,)85|aô`prr X ? trC0}q;w1#!8Q909$賜a0){fRQS8[YfZt'1 t tu
| t(ar0
RADȁmG>  &pfp    h4tru f>觯rfff0Gf  %f  fr<fffHff#f+ִ f;wfgf&3g&Sg&c
uff+f뺀p
 >F                     Z ` $  H

ɀ$ t

T Gm
f$ u BKnERP10@B u$Z DfQWP 
a'Xgg_fFf`|Q
`fgPkfQRfWPSf3f3ɿf <  P tf; X tDt[Xf_ZfYù@ fPffffX,fVfVf   E gf^! Wf^	V		)			:		/	^		f	W	~	fWf	_
g&'] >@;f_fPSQWV! J tO y#k"">A$"h߯FcT
Q 9sY,^_Y[fX^ auDo

f#f!V2UE p   p 4PhEbSh ?Q o 8O3f 	g&G4g&tCfЎfft.fAfPA<(  u1
U Q R h+
  a  !__h9
a@$#43efP(CdqP%RfՁ Z=
ai2CЙt_ 7hsu!p?%fRh+>f;#QfW 
$eOf t GAIf	  00')' %+ѩ<pdB.&;	e1*  t'.o;	)ep 
.t5
)@.`tB.a3S;&[C vS3ۀ> tt&t:&tC pڮt<w>t8t譀: 
 ?Uñ 06S @ 菮t, NT &,&6&1&p\t r[""5 fP	RAE&rA aխ	 fXTPt/3譸誸軧P	4@ޭt1-w؟㋇c .trwRat0
Rw&D< t
:@ 0k  O&P>@ugktY&aÉ  H

pI}߷ Jp@M@P;42ؾ
s3y@si  Y 11F0aM:u;pu;th@P`P \!p 5??Qjqkpww
210r 1	&a
À
v+ >222fRVh0j|?{DtDh$h[lsh0]tr2i f^fZf`s2 |7{rbo <|`t[Tv\
hMffPf`PVPf3//8'Xp!7"" h를tQgf`/)
4/\O
z "	 	_ &"	1/	(	&!_!!!p!h95԰hw
6F,vpf
QzBs_u`ԭ 2fÂRКt Fo<t$rfאZtQVW%@& o_^Y}TfDfQ ft
t%SϠygOfQ?r1  Pp^ WSQRWVhU?r=ыt
 t
uu	 °t uʋ^_cZY`	į:Eb3:EF c6W p 2:> u6 GHt\o hV/T3ҬϋhB^_fj
XK̈́
{>
2
YF
VT[>T2@uOHp
Nt.
OϏr򍒎2PV,wa,V/ ,PCPo/ / /  
OV,{<RwS2.8[Аkø 3 +аkdfQh_4ufYzbÑaEf3ɋP `qX&G     &Wf&t ffBf;Pg&Gfww~rtwRtpff}@hp3QgfY tgho&AX0Y[0U>aPS 2hyWh`2f[ .t7> u $ۀ>p u0`o`Īb_+!ʞҿtӞ2#ߟtP rs `t Ksw>Pp 2 ̭du OqQ>_^SxmYhP`Su9 5̢r/<t+t&u
$&誹.辸a@prݞt"tq2t }g/&G Q !pv趜u跛TVub>[`v&!/!X 
#.LMOQTYhzBDGLQYmLOQV[`zLMNPRVcmGKOV^fk8:=BGL_rfr :u@ PP  ȸXPRן@Zbk}f 2`Rў 0flˡfmap)XqpXFW@f
 fq _:3 2 05 &22
z1Ȑ+Ü02 
8s `/ 
t V$<
v
ط   tǀ>* t $
ؐ sh?wΊ$@ u
d t㋷؊ T^іhk%

p8d		
s	 
B\u *&+
@ *+>+ u
8w2 JD &`6x ѰG@yf`f Df HfCLf}PfpU`:8$@@@Z@pPPh >ft	@p?f% @ @r<t<t<!ÃPS$<w .q!¯ƙ  ߹ t 6G	 N  DPĳ
P >	XuARB*D-	VbzphS! u] 6o [2P }2X	{
@	2oP20ˀa	$

Àu<X[X qaxa
2t nP@<KrKpSI=0௢"0I2." JBZ s  ""
ZP{3X?#?# Jq vJ/Q R (TPBX
	ذ4 ZQQSW(,}_[fYe~;  h_ M (Pz;p&QW<u
y G{ w_Y*z G|!o~jðh1敗тvHװ轻s$%&'
u     {`a
%$% 3a`
%$a?Gaìpup*;s"D
oU,#
! +ԃ #
`DC&%    K^% (3( " j+'U,&,q+ &3ۻ! U,% m&w&&&&+a&` &Df &% 0.&,&0y>0y&&2s 2yyc[xUV<20x2 Pظ $H /vW[.uu>9=u^]uu2 	?sຢ tiu%?thup<r7, 
蹟'0iC`c@u`
 
b'~eq,p XWРo(S rCn.Y(}Ӡbro俁.t PrV衚/u_ Iu؁d`KOՑh2 
03!47+t
3NO+t3GNOpUN)	))N)쪺P =R)SR)``y#0j
ehhSh ?Q o P"uuu&gq p  l[f. f U ff.q n ӧV r茿@5b οX}ǯuP`y\ hp*.lu*ʠhFOP2zXhyVhhfUvP*F X PSq&*&*&*[XPSb***(x$(H&p+&p+p+yJ$ÿmT`PZ0*0 褊Pa q_U iXͰS8rddrQS<drp
d2t7	<cpP,K0B &p pZ}D&Ap]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     - !$SMM MODULE -- COMPAQVERSION: 1.0        ,                    
 @ D X \ ` _p x |                 !  L Th ltg/ _   E@    $ ( , 0 <U<DI"  $(,0DHLTX oool 
P@#H; P` d tA+o)Р( 0
&C'J@
!H@-P@@<@  "B 0 ` @   P  $o                                            `JdJ - ` `P1  ` ` ` ` ` 	@SS 
!
}pj Q1J0K @R"@XF2pHBRUDUPUPAP%&*+P,89:P;<=?P@EGHPINOQPTZ[_Pbc ePfghiPjklmPnopqPrsuvPw}~ tP    @  01467 `
 	
p                            i 0py{107p77708p888	09
p999
0:p::P:X0;Yp;h;i;j0<kp<l<m<n0=op=w=wtF9@ =U  @U @U 0@1U23 4@5U
@   ! " # @pC                                 NNO Oh<fP u	fX#  h χhPqXfPfSfQfRVfWfU _f Q  K!Q  A!!ȑff*2fW 0@MMf3f3f.ffo: ZP fuf]f_^fZfYf[ff"Q ء f|( MM
f700%'#ȀAf`v;
P3XPSVWfQs: ؾي t
؀u ufufpv @uf  fY_^[X}QVf` fpf`LQSf^f_Y@ fg& R'hsQ"$hDx%C2Vf] @ zRf^f@ʈ2  S@ 薕 bb gО( )*(5 p  v ϰwg n h Z  ;t/ +T 5L[	,  7NeS                   %X%Q                                                                                   <  JU* 0w `ª  `*z ` QUХP3f3ۻ~ffgW!)Af" 0Pgf+ л/`h?afUf&af&>"` 6a m !ߣ"X[ "&"SP`͛Ƴ /a&U}"&?"2p
f3f>gf ֓aƹh   ժ@p h &<ïyf`fffVWf@  v  ~@ff>0p
r0zpffXffȟff0U 0 Ʀ - 2!q f"oeP ړ Q  &ޡp  A` eדfa
pa  6!>Be*Dp F .HP2"` e" ݸ#	
e֓J fe&u` b "j0e"ffefAffgd:Kugdfepf3 gCT 1 CfF3ۊd@e3 >MJ
tdJ	  > @ 
NpeOuxPu._RTC Qu:/
'
%&bfgfd. S` @>[WP9`XP&EX% &߈E_YǓ oooooc4/IXo~֠۠;'Lf`PHIa  6&pP&0`X _v
``.0Sr&&pfaõr!Br  Pq X
䏀  Pf h)3\ Xga20u쨧t݁	<u <u õr$Rr p&&=F2qrr]rN a`z]7da(SvxБQ`es"" QYaEcP  r&&Կ` Ob _
y'U P"S""F"&&a bR ~ ZQRr3'H2't2ZY`2ٵ$t"5 ttTZYa^~r#S-ER-Y03!pٸ q4 AY f & &EZP 2 &r豂r8t32y~.BO hu?,.tGS_؀1?e6h%8[&M.2tJ$;0K#h ǿ5 ƿW< t -Ƌ4fRh2h[Sh ?Q o h0]<fZrj  pvw@5} pS
, #!	}A	2=hF
%00`P 0S%-  Da`6(    pM aV魆ī^`W  3 _r- `+߸ nfDED`b;Հ B@<Bˊ O B<`<2rruO0W2&*G_YS	 7&*,u&}Zu&E_[DAP`QFگ>  0 2ۃ<OtY	B_<tmH¶7[77rPBBL: r1 r,q h/$d0SQk
pqlat)u?$<Pt+fKuҴhwQpB`UY[Qn @qj"yjuBAuYoof٨0P	VPo^W mQfR gh0j?tD=F==rN|UtGVRѾ4^t1VƏh_5f^Df`CXMf`ffSIMWuUf} frfہf1f;?w(hņa=ffap pp 0f&?SECUtûfuffQR hP?I7g&XfGcV 
u<f%X!u(Ag&_-y$80ܱ	PN,;#ɃGt<S=
~ NT,TV&VYt{V
tTTSрGhO R9L0p=ʒ%= 	 =
=uf@$)/èm먃@  ߫ïЯ!ffw	7 Z"n& t
fWf&f_r2%ef$g&0 fg&	R Sf`?`u ze fGtt2t~tyf@4 ? 4!4.,005 1 tf@P8@ 1^u0fJ rFf;r>: t, f    ur%)r}QY9	 f_fZfgYf[d   t%> 
t`A
A!y:0.Kr&%"

wTr'SWV!rP#ؐ  t
ff;t;0
 + t WD@@uD^0QT@vpK[[[rw	]K u ff!` B
fffLp 


gh\hNRS
Za3 G"t3 v'%Khq
Gw  V16p}12:u"FPV()pAD1' E-f&7@g w.	A_S 
fUfp>t	0~_--

~
f+n
B#f]^"P)""7~ g oXvI? An~@u@ٯuf1r %  
h_#_#_#pMnnrp  Dq& ; Z x     0Nm@  $
Pd_u	q 2pXÃ&p	 ] H,zȃIzذJz2ȉa,' SQR܌c.ta>{a  %0/:$tB2 0hhurEd/(#3/J!-*&R++fPSf>QPH_u(Dr# @  'p[fX~-r(Qp% ?-ro#sVfW0f>fsX1|p g灦@ݼ f  
 ?f׀wf!и2g&g
fKffRܐ& gߪrpGh|qмVGhZ,
-5hfP r  s fbXPSfRj0z7W6uLs;wEf6f28 r/f@bBߋfUrvp09  Z[Xm΀u
  >P PÀffP? t]ǀ t
  @  ?`c :  @)0@  [ p; n6frv`gGwf3 `rːf f^Pr:>sбz^f;w!fVg&f^uWfFtwa!Q@ߊ$@ftaQ?g&@90@<&=f=ATADtlf q:&ǇT`p s  SU3它a  gtb _t1 ސE 0!t3wɊ0Gj q'tǿUFWP
 XUu&.>;   u{b >u `	`	~stp$l0ses$osC_ARI 	


 @`YQW3( [t1fd f跸HbBC_YaZ.fUf.6f]f]aeaa** End SetActiveDisplays: \ 0	R$Tt5< ux ) 8t  u
8ud a9 LQSe[00t@uYFQ2t7P  q@@ Q# @S <uȸ
  uRQ 	
3{0p  ?D q tu1
S
L_
 п  P ]e\R	Xߡ9 SRhPThP %p`hhċ hXhXhpNPSRՖ詚ha\j``b tQthP ÀWl@hYHQRPS [X"3t= z  
\Um  H6p@P`@6
u&cr
u02,RW_Zr&&&E&]ж  ?faP$<???M=E>P;. ~fWU]WPAXð PR Z} .a;tH rX/t @ AWpt,` |WNC_a׸ Qfc!fB $~fWP L`XubrpC f_`uQ`Mt'f ITAfgf@ZP 
 2gaYld0  ?`tXW
Hpc=&M_0g.g͵ @t0;r+gCC PsKGPhF0BaAΝrJP!uu茷tQ Py @{f pԊ6`Ȏt @.d  w >`QOua8tY*_O# Qj<.uO R%Kd
1
f$Dt_? 8~ Atu p\奔u3鈰u#Q?G`
u"QϊhVն9u
3^uC*ulr'p _ruatg&ON  ٿ1OCk0`uVգ>l  ಇ()S+`Nr1cP]0`PQ>ι c r\d`BtC>r-`w ?0 r0\nҊ1 r
- u`d`Q rdItf s`QRp 4iNr&r!ww3҆r r	O~Rc1@%;ryQPQsܒ
d Sr	r91V>Rдf   d~gfyuwR Z }h ٓk~C Z(((d{.!Q "; Ypp  2  p",u  QP h)o/R

Z@uѢذ*~ rā=`( ] INQ oRWR  UrgDC	 4_P>qS t33ېJ*~`R
t#4 c ttcÈ?~~QRWV+3"a^_ZT$"#`1$G<u $V 4^W =_ "  !(<tù /	
%R
q0J
g&/ܱ1q;QM-r;@Nr;x;q;0(XúJ2`ubupcRVа$rN ;rCr<,	r32pt0rr;wҀsڋƿ^ZW
Ph  е0u
˾  锒uQN߂ fQlo uf2 J3322t@ 0 	rn
$	"
uƋ߱d;sRZo3QFqF2t
2tAu	u˸
S_ø
_.}U.~.1.ы.a.6r..2YDذVPC_$&G&   h5KtK!9gMh/1$O8PeP_AfXfeX`, ff
fU 4$WhSTu00@jk谡0fg	c  C	DD
F zOK XTLM b  Kǿ0`}fu f+fM
h5f-E02fflF  ZȰ  2f%f+Áf>PAMSuff>r^0 wS`!0QpξǸ 0f?|	B% %f`&3ONWVfqh[Sh ?Q o rY  E@5f0P < u oh\h-WrfCW fbWh0]^a`
h0j/tt.~rB @
E<uA
7Pk
`eEfސt0 G"a`=D"ЎQFr&=t&} tV" &GF^YՃ"Q⾘ h2O'	 h]3D
!
"sV  hW?_
xzS$x zq~̀RH!RZRu
{" P3 <} 3 <2<
 1ꀤT                                                              UPRPRVFZX0RR30ZO                              UȎ Ѝыh3 PSu<w%$<7w	&@9fPSfW> tUuR uI !B<t>t9u2oWr-r!\ Ltg&G!P _  f_[fPSQtLtZgf&gdtKWr3kȻ 6sy0s$
} O` 2WYPG"rKtt0 	
   SQVȾF=@ 8t"8t)r?>8^Y[0AXt,&
uY>ut
$sE &t> u 7H"t$	&
s@ 
tt0	>!2
XUt IQ@huz6ߌtCƠ P < t'$  
uwa>؀
	 >t YGt0z P'u g *r$- t> uBu
 x胿i  (cr"~1t DJbSQPXytV
r0.TGfItB0gD0.&r//Y=6It_6tP rB36s6u%
u "i786 S56cCtzu Rطctbp;sW;sQaRu	
Ku u"
uPF"
23`R4  àآ4t * 4s)P5tuXSfW@0@t
Gt`D_8؊f_[Ô!fsg]d  rs
<rU,# \    0K  	  
   _   ?  _ KSfQRW= t&.wf`Bf $$4_ZfYfW0F?p["$ueC ff#%_ uKCQ"u0 c$uCC f%uDèt+"1tm0AfnifQ^f<Zuk
?mFr}F /<{E@ hhSh ?Q o6 f uTwf` S@,7 Ft2 -Pfk
$`cZ`_ O? ;!c$tPXX Pf3aك tv @O?PU,@}f% }#x f - f=$#fA)%f=fPif?S &( tR6"Z~fP`ٿٴٹ	 I~cfܰPB좄a?fSQRVWq Iv$ 
fbf a0
-2$s.t2$
_^Z3`ٿ ߹ cHafQft'ff tArfپ` fYQfRfWfVfUf43f3fߋf!=t԰;180B<菭 P<>q  td3(=2@%o?F 5?4?	?t!ff]f^DmR(7 u3 +ãaHcHaWAPIZ "W 5B1ZXW d h5fP P	fX#  h h( ñ 0RaCZW  `aغ   nBnnntnJFn aS @ 3ێ7!C &?!Cu3ۏR .;Z\ht
f;
X

L

dJ&;;'
q
>&
v.pu	 Q_QWV鿿 ^Pt鿳t	+t8QWP3 PhX@.X=X@uX_YP4߰up$ q!!.$> u
PI@Xuð6_C @B T wA3DgfOgSHu.gS:f`Ug&ffȋfɉfffߋgfffu<(.&gfݫBfsDP
h!4/
1dS_fRc6U tO `F

(`bރuXO0fTSQؠuf   f t ttNp Mp /XzRÃt%tg0&g!ggf` LbRft9tg>E @ 9g5CggfRVf),g>߈E %g> !P(^d`g
ز
.*   hp~"Q2` @1Ya,/ a,4:ƃĲ!H.G 
]+ٵ+ԇ
a,a,"c^%5d殞&tha,<	a,	a,`a,$a,Q,Q,3
߬a,Ƚܼ	xlٽFa,f.uz4!u<u<yw2._ Ff&@y@IpMb u
ff
gf 7
1SذcsDrDh[_ ` C&;xV4t? uQ_-&[ff[wD@D`p`0 ؋؎t t [60\{`" cna@r"f@h[ܺs	7>.h\r0fZA@fP 6fAk:qm	swdr
ah0]RyPs5G
q_h^
YIr d~ @ hgx0a"D pJfw x&t9YUP ]&(Zqf^ Rp:_'ZQ,џa9#rݏA;?B+:à? ,q5  f`1 prPP   .<t
.._/ NAu Nfz VAfp[rPجP؀U.p/tA
 NUNOh1ot`^Z#֨4 e?hӣÀ> t WZ  <s!e C$h 
S
qf`faß%Pr0EsRWP $?o@R`ؿHyB8X 
_4sAxW?#+Sցրց?`
L+  %
 	 
  31 P  @u#?2h3/4th$VdE* RfP?&T ffXh!`-)')!) )!)") 	) )aPQ  f%  f` ?Nqݠ9$f#6 CPt2R6_ZP 5X4Ls0hZ~3f`fD2f3f%   P00`!䡾ס
 XP!Bf`fgff%2 2fP `E  fB"a f`fPf%ff} Qt8%]624@!q'1?@tqP h2|0 t(aoG3<_|q  ٣tSh)T83u-膂
4jcb
8?tf1)ڗfX(^#S"#"#ط$0$@MC$àh0jDtM1"-u6r!0>hH=Z"RQR>196H3E4 n @|:d-u= aV9
> g995<o -t )'67u0Mb8cF!uB
S84tS8T T8YF,Sh\ fg&W@m  	J8~PR88ttt
u8S18û  h5Te ph
6o
g_  z@ $ & w  @C @	  
!     0@?12 03 45 6 ?7 8  x%7?)S(/1A_%%55,
dd)LEN	?'9Q+`Qz ti  {&ךPhRu <w  
k`g{ q~} Q   =-~Et qu0TfxfX-f~-f0w .s"   ` 
a""f` #
  13S$Ҕт7fIbI`G5 0芿[f PfRFpfay06tm  ?= uw@.= u=  O2
gQ;䨑p3f 9tP3X(BRᡑ qÉS*Of#s?rÀ0 A`PfshKlX`9 8                                                              U	,O W@~6{d         K   p p                                                                        x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(    @ ` d$ UNDI  L  NhPCIR$I        ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
B0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                                 E   
 UN44UH˯;    @ ` .UNDIL   ?OPCIR3        H  $PnP   i\ Z!AsusTek/ MSI/ 
Broadcom 440X Fast Ethernet Boot Agent v2.0.3 Copyright (C) 2000-P 3 Corporation19970 IntelAll s reserved.
 &
, PXE-2.1 (build 082)	MBAw	   
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 tw@q/2?q130QS0 [Y .> th  Ph2Tp  M  FP?SQfRWV	hJ$Af.>I t.;@  ځ>  U  r r h@ ۹H l 8tY[i
a-EC1: Base-code ROM ID structure was n 9found.;T0: ASF is enabl`3Q2 canl >.   YJC 
?	8Sfj j ,'>  t;sf=$BC$uErPj W떌ێ0 f&#  .6P Q   ~j Ph9&u
˃Z t9hlRMC_L Ner() ==  @<r
?hC%aEM0F: ExitingMH6^_fZY[, q . fТ 0 QuES p`f
@&6 +&p fRSfP& fQ73ffJtuہ 3fX[fZP9.6&ԋ DSfWfUj j  0RV콺&@.~6E. ...r
"@?ЉV%H96UYWoPf6UfKV  q p { t tА Ȑ:08P`d62 3BIOS extended memory cm error56:rg driver image6invalih88: !a7::">segmu<9:mNV+I u JO u5hwd+%F3 FCE)
mf#I,M +f^f.O sDhP:Jx5  AH90M4Mzr?vf&D?F&D@g UB! H`PeJR&D JV M&(DvՋAE@	///Wj 
&\ J
){;huBءL ` N b f3҃Whf[w fR}XfZN&  Yju P$8v uj@DH FW FR7vX]t!
u0Sf"G HF +F )F[fSVWFJ  6ˌ##FfTp`   f`_^f[^^f]f_f[fX2!8RtQfbk  pQQJt u RVVfp  OffP= t.. ﾭmށ.
s	N]&}t	q t+{f&}w us.Pn9wf&+?f&;Esp RfXRw *=  
 s@8r&f.K+QAP.=uf 1AA	f]3` 3 fP2  X$Bt_ s^ޠ+G3. 󫎯G3@0 ٫'G1C=N C_%=ACs
  0  {u	 'DBHAAHuHCtH\s   	 u&<Xt.;60 r %RAXrإA< uwG&DA 0G  &LmpG&ЪG G"QGH(RH*!H0PJ8UJ2J:.0A6K>EpLX:Jh1J`t ^K,rN*qrGup*. T
 &5
$:P1P ?  f[]ˣ'<fZ@ȸhP
`4t
4fX p+MW~ Qhf!_Rf8f N` f^   H g }5B;/fp0<ߌfuffk#H`2du fadð;n?(f0@{uqB6	Itf뿁fPIpZ
4	At'\ > љ	18fZL f_ fQ
Ɛ  
f
̀AD f9*PrȐRf ẁ _p tfZ A N R5%0
"  @tf<1fSp A f@ a fUY&O @82SKaRxPf
߀úff/fZPfXQ)Qfϋ
I =f;tfIuZ3ru$13.p.P #.Vo.@P 	P@@Շ.( SXf%$ v֋]52 mf?_SM_ts OvQj mS/A   ЀwrgrafG".tWO0sQ0 Yufh w Xf,g8 tIt#gfXfg f@g@tgePnPuW32&C&:]u
uB }
 t7܀Sj`&]
[ue3t7+SW ߀p$u> PuMu	>p ?Guf  `f> otf ӀpfWf@   t;hY`u07:  PCIcallsupport ~ 	uQO.;DK8Dtttnh>댥1pnRDevice!Pqp}qY	4 read!
configuration space3ff`j  wP Xu
С ?|U.~/Pۉ>_fR. .P 2/<tRh%uOp	!requires DDIMe`Ϡ6$ |h R6"P6% ?C `Č!0=pjfj1;`f hfQ `u0h
 Tb%x
I PMM funcnumbe` u&h6EҰ@"ocpC Gfxfrgfgffߋf_ \.=ڃ>I i I.H@0tt	 t5` `fdߣS f M_&u Mze h`M> Mi |՛%Et`>=aFr$. 1op2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @     i     (  vK  A U B  o
K 
- 4o5 N%ҜkJo!c-ڱF)gB1Z5{^R9wVs=	G,bC
f(j$O יnKv8ϤS<rW[0ǉ~_z4\y7X3}?ȆqTu;P#mHi'лL@e+
D/ؖaUp>Q:̓t6x]|2ŮY*ݓdA`.EIl"M&hE!W@mW & v  	U0 
& {P  /` 
U!p
o "# 
	&G		1"#\$$x'))))Z*<*J*t))+0//$?$Z/^1gC6DIX+802.3  tttttWS ˌt&  .6 !PXEX102r56ͭ#4?    sNV+,vO@ @fUfSfQfRfWfVfPFwO. ~
,2&22ێ46h@ WP
` fXf^f_fZfYf[f].>  u
  `  fv
Phm.6 j `ϸfUf	R	g]g}wer`C
f&.2؎VP
fUs
Sp
q
[f]
f0& tP 7u	@fbڃ>*2 tj Sf. ffף"2  &2. -  2f3یȒ. 3h f&  f&*2 []zj 9h uf. fh `  V@ g&5@"+g& ^R t,@
? SL_\[`1	ePfX&
=PVu NVf. -f ]ϝ% % Z 2.  pQFp0~ uP;ː  u^&-鐋Fa*5FsB{ C̃#%cQ'{뚣C{	q 1	gC-	])	S%	{I#_	?	5c
}+o! P<== w. *4>HR\fpzF~@ˡ>
9 tQ h@62X9^&G9p 9&Gwq  wQ	
9@6o
9C"u!&3 c hGa>6u31	D	8fj@1 d
4_uPK62#30F6^G#FG%F 6F`GF~sE>6 u>^*Fr)^Vt  Y OtfcGK TRt,q	 A
9 ( :`  0jK2Z^pa^V:1+/#!!t"G0RxȰP:a `bQ#G/t3+< ' uG0 t>G17
$1W

)
$qI
F- VF^	#	
+t*u! 	a
m
		#&@ 9 Pa P 6@F/9GwϜ!.p Ia!2G0
i"P"M9w!V0Pe-&  VF  	Fǳ` O@60:]nF)޲)TA^P0ڋ^wV@* usF~o'}0!6P*zt  2u?!!"!-> uF ^B|AeOfN%'F^F`kC   Kt2AC^v&F&~ ~|sTA/v@jK*1KHt
H|p
H~Hc FF^ft}vQr{4psFb `:bݸF"v:f&p &@
44p@
 ,<s@2<:1;FGG &G(*;G,fG GfG.q(?" G` 1ǋ^_#4PZ#*_%J$~3bOFCFlESK.pBIU]pC9
99[2YF99N9A9CQ9dVbh,F>v)_ވ@r(+ksO3t dd9iE;O<O?O_01OQ0zO_%O[`pO*>aOhOcO6AcU/%]uz-s~G蠺6*GS1`$s
  (rg1n@ճDp`* 0 &)遰ss`s^$&GU	 
`gVsxa$GUvsxcGG
G 	b
򒉫Gx{C
y}݋F 06 蟰/f!G`3>`#cbFTU O- p v<
  FFu !U#Ǡ  o B`t
;ҡϐlm k>p>t,i
 F0ŋ^	F^V@A""l.
R'!]谼L
 -"5(rxy  ^Zv_
*&o$PP {@@iu+iu$ jub sbF)F1tI&?1?&tr(g - @P3LğAT7> p 7 >@|y&<?F$!0WlF$*
,D Xu2Ð!P#SVp N@9u2cv@3@m@GbPX2gÐ`8OY׋@ȰqPj P3۸Y_F iV@CRZS1pt$ÜX	S[	[PA:Sf3یfff[F @]QN$     YRfSQVNfP$" [qf[f {@p   vpf+fX" " +$^Yf[VWv^~F
N~ tIfȃt_^	PQWf~N
jQY_YfX]Pؠ..v=# f"pSӊ2@t>҄F  O¢ @ .CF TF+K p 	"2C$2c&y(@gP D*PŐF ;Ft;N `,G jVQȋs0Y^< ^]A`WfP2ff
0úff``{fX@_]c_Ypef$  +
2C@@.PQR,`(;ssZY1ffâRPqKFw2^*/aNFA=Dw=Ds-t0ø1-Gr	- vHHt
AP  ` &0VjW@︜t	3 cVFׇ  33$("Āq$`	DAG	ub  ^@
!ntBBZu
E
vp0d!PS  @V˸NKpQ%qF 6 (Prp0RPV7^c@.}I@+qw?`9Pu  19@u9Pug``P
_纭"`P%@|f+f@=9Fu@*~u%  @b#!]ƋNE !t ??,  Mˠ~}+vu9P
uދ``q+cL@$Lc%рN DF+v&F0ޟ9F|#spMp]wp$tۗs 0tp z/t(tcYh6c.@PİX"["\G
"
"Ph _v@~ѵ 뷐=Ǉ&ktaGbR(#*,c.	0	{2C
4'!BS!G O&Q3p"`HG j t  uL0Ad|LQ ׇS=w6PQ?KoɁ *$"$ump +	Z ШR2EfFnFq|NA#;G3 w G"oV>1Rl	F9FuNbz @+FHO~P V_v P:2Vpw@"@P@i
S *@u#(KQH#؋v{t `cw !"F0G+0#(I#+)ؑ#1_0eh9 yG  C@bCNR;FBS <DF+F^BFF AP89F;FR`CB:>V^WVrU$"_FcHsr)Kb$ fs Jt"( r BS @u&1p U<I@]Qa!C0kE %ErBEA9AuҋpBPO*6R,1po 9D95vӀ"A    ~ ~8,)FyT(3A`C@36"z@N뉡Yr?M[@+0V;FsE+@X02FubG _GG\
Q 10RS]׉Fp+*b.6pBK^/*Bp?qL_f?whJ B{ f++J`,oVpkvH%HHb SHAP9kM2aFcEAVPpF G0?x.%aMuP
^9g@t @0`I#@]
u`bq1NP y.p++;u
;u"aa9p|v[~a(x t
E'x tZ,+zV,BF`1t3"/Py6#43E4|a3^9u,aKI@oD앑蕄=uGtDtDtu#}"yjefY`jppzs5^؋ܑA_FډG1ĲДaGG,R`_G'v؃'$@  @V8q ΐE`ikPPfh  fh  j@PFPvڐ
7Rc u^ j3 Pp `؃
G3
G4
G5
G6
G7
G8tjG-P7G3੦`?fGtoGo_1	GP"CS70s
`̓а`j׋_{`ƋG@&8N
 



 
$
(,048<@DHLPTX\~xrlf`ZTNHB<0QpGC3? ,-`T9Gtqк؀@m w
r}2n
u`- . aD` t\  G ( #	|&Tu¿$ o  oA` c Z  Q" H ?	tA
 B? `C C
Āt$P
3
p*Gp+r02
Q!W A F
`+ 
k t `RO!
wa*+!dfv(f
ffff 
Q1 t 	 7
Z>VtPd  t	Ր /^@ 9   wrH t1	1	蝣 	8P<4A
t2=$ t	0~- pG^F@G 91X"{U+	0%	0, ^_! RSfG K=`a-*C"II	@!-< 4dPPs`fСa 1fg
pTqjgt'Z1aApW
ҠV`!3Vffq[f/~ ao!РV5p	G
	W
WaGW18 8>@9ʁQ:0gF6`$ 056ef ! @%
) ( RPO(3{` $ %0cG
r bN
q u0*pȋЊO8OъO: +*;$WPAm2hhd
\*p|#CmA%'n0)+Qo#- /p3103pB5V@7aq9P+;r#=`cjr3ApCqsCEG!tZSI	KtcM
OusQVS1vuUWvd	Y
[wS
]_jAxBacx1e gy Z
ikQzm o{1[q0s{u@0t#P}3V`}Cpq~S!cjsᠰ1eZ	T
CVA2 !
 "#Q"$ $j0%#@&aZP'#`( gҋEG֋I K QSa@cDe g0BA   )+tTUѰӴpUt0	4		U	

pUt
pp!U#%p	'p	-	5/p	p!0mbtALu	a`axbIPN
`~3{Su4t *]H hk0!MFсP	QBtPS$P0	Fqfri+c!lLbsPS=$h @6z}Q^dqpѽ žhgb hH$dT H	@pfQG
ீN`   !
 |	HtHtHt8Awf2spd Q =f `O	F2EP pdP dsFG tأ LEIUlOH  G#FG%F^ F^VFVߋF셇F tFf%  {fp_#GR3_%_FtS$w2P`>и V%@@^wà`t
f
.zSƇ `3Gf Gh=h=UuV`< G3V_GW P4wuT'FFV FF+9Wdrw9oGbvD	5P`#rrvk6t `΀p
wW`9F
Py
~333e$R p>BbdVf0!".Bt!CÐ # DF CcWS.`ʛ+pf.AYF  u		RJAt@7Q/pFЯǯFb0b0O `>a2~? @B=~st_0P߉GGF~
u#F*/`2 ,,P}	 ,bYhFtʭ
 ر.ʱPGGVC.f " Q~  @Q艇 yfppsL
B@ PM?lutPhtxǇp Ft!d }at;k
 <
߃ `U~	0(׹3f3ffNu[,CZU6pg3;"7 xHJ!sG e#U1|4A@sM    TO r1ZƇbf!22%b`S
* *G
>
Y*
 GQE,2"aPuba$Q+0Q
ă1a?9**U(0i`lfTRtSqP[B?жv"T dk^P2
ذa  {`0 3zPSQjGPgG  L~hPS`jNM9u2P1vǉ@1A1 gGB!mV`9GA|GO H@bpfa膋``uEPO  W`jn}3]n<0IAFGz6p%0GGvwx,7${ z}- ◁Nf+f Fa
  |		WPy#1h tPfj ܃
0{!ÊFr<t<{uÈGpGjGqzk#ňGr#l3ĈGs3m^CǈGtCnSƈGuSoF.%`)agb@  P \^S2uRffR+2pjA3pG%~% uGtR%1 DdKL K~B?E?RpB?>>T v?g?a?8QaPnFS赏Qxo揨t$$bCQ%\2| MXb3 OCJCdCCCCnFϋV
fѝ t~ t^F&^F&
uA WV~0<NV^_~pFN
ȋNu	]S}f
 [ SF4yN`3q3ҫE^@ufr;Vwr;Fv+FV
+FV؃                                                                                                                   < ~(ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               68DTT   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 [se f    Q]sY 戰f
!  ff !  f   tf ff
#  rfBYi戰Yf3gC!Df3f   戰fHr4f f戰䈰v[f戰 rfFf    戰Update BIOS$fSf=  tef[e戰3[f  f   f戰fSff[f   f   3f   f  戰g&ffFfCg戰4\]s 撰fPfSfQf   fQf3یff
!  ZfYsfYf[fXSgu
5  ;u[fPfSfQfRfWf   f3یff
#  	 :ZfBf   !f3g}
5    fg
#  r%fG;wg}
5  f_fZfYf[fX      d         
, ug`TPFC@83@      @ FAA<77777 PKxxxxxxx  ,                              	
  	
     Uf`` ~6  f3fNfNF   Nv, ff6    f6D    f6D    f6D    f6D    ~seg`r]_`fvfFf^f6\fNf6LVfvfF^f6f%   f=   uNf=   tm f6LfAfNfNF~Nv_  u	_9__ fa]PR  _ _3 _ _ZXUfPfSfQRf6d  2_
 f6Lf6\ _Ffff;rcf;v^fuf;tTf6Df   f+fNf6\ffNfNff ff6LfNf6Lf6l6-ZfYf[fX]UfPQF NrHf3F~rYfX]UfPfSfQfRh  fvfvfvT fFfFfFfXfZfYf[fX]UfPfSfQfRh fvfvfv fFfFfFfXfZfYf[fX]UfPfSfQfRfFfFfVfVfNzf^f3ffVfVf~ tf9VsfVf+Vff3ffVfVfVf3ffF0fFfHffHf3ff0fFfFf   r
sf;Fpf;Fs
fFffNfZfYf[fX]UfPfSfRfh   f~   vfFfFfPfh    fXfZfYfu3f   vfF   fVfVfF    fFfFfFfFfZf[fX]UfPfSfRfh   fFff3ffPfh    LfXfZfVfFfPfh   5fXfZfYfufV'fFf;FvfQfPfFfPfXfZfYfufVfZf[fX]UfPfQfFf;FsfFF fFffuF f~   rfFff% fFffu^~fYfX]UfPQfRF fFf		FuF fFf3ffftʈNuftF^~fZYfX]UfPfRfQfF    fF    VF -f6Df6Tf;vf;VvfVf6LftfNF,~r^ff sfFff sfFf~ u$f~   v
fF   fFfFfF    fFfFfFfF Zuf^f;vff^f 2f
   0fP  ff0X0fvfv^~0^~fFfFFF~ t <sF Z
tFFF~uFFFF<v*f~ t#fFffftf3ffF6-fvfv~u	~ufFfFvvfFfffF-v&f~   rfFffIffF653u~uCfvfv,fFfF~ tCft=fQfh   fFfPfXfZfYfu6-~ufvfv]fFfFfu6- fFf;FsfFfFf^fSf3fff 0fXftff0f 2f0fYfZfX]UVVF 3f6Df6Tf;v3
VN@fF,~r^XF:N> r*@ZBu6%s6%s	;#	F~r^]fPfQ f=" u`$8ufYfXUFqf   f   s<f   f   s)fvYfFf   f   sF   u~ tf3fv]Uf~ t7f~   s- 8W
t#P3 ^WXfF   <u
fffF   ]UfQfPF  fNrYf  fsIfrWCr5	s)frsf  fF~rfXfY]UQF  Nyr F~rY]fQVfsVGfTVfYfQfPf@  ?rfff"fXfYUfQxUF UFf6DfFfF    fF    ~ uFf U
u FU UF UFF F F F F F F F  N6L TFT8FsF~ u~T8FsFT8FsFT8FsF)T
t<uf6  F
8FsF*T
t<uf6  F
8FsFsT8FsFF~OF
VVW?^ff	V_F7
gwfnfvF
Twfn fv Nnffs2ffFL
T
uFEfff	FFf>
f3ff	Fffsfnfv~ "
f3vft@s v  ff	F
f3vft@s v  ff	F
f3vft@s v  ff	F
f3vft@s v  ff	F
f3vft@s v ff	F
f3vft@	s	 v 	ff	Fn Rfff	F Rfff	F Rfff	F Rfff	F
 Rfff	F	 yRfff	F칈fFfFvFfVRf6fY]VPSf6drH9fPfD,fs	f6lf6tfX%:RuX@6D(6\*f6l[X^UVdQFFFF	]FNFft>F N6Ls^Vv
s	F~r܀~uFFFFF~vN~s3ɀ~tFb
6\(;vf6l Ff
If6@  ^]UWfQfPFfPFfF    fF    fF    6tf6tfvfFf6D6DfvsfF0QNnf6tfv@fFf6Df6DfFffsfnfN   ffsfn  tffs |P
tfnffrfn
 ^P
uffs^PW<uffrKfnC<u?ffs$ffrffsff rfnfnffr-PfnfN   ff sfn  tfn  sDsfn tufn#tufnufnfnfN   fN   W?^fff	Vfn_F Nf6L
sf^F~rffr=_O Bufn+Cuufn ufnufn	 N
tfN   <ffsfN   < fff	V蹐fF
fF
fF
Nf6fXfY_]UPQRNnffs2ffF[RN
u^@ff	VZN
u?ff	VZYX]UWfQfPMFfF    
f

fsfnF F@  u
$FFFNNTffsv^3MFAMF9MF1MF
)MF!MFff
t:fsfff
t:fsffffs7N^LL$:FsFL$:FsFL:FsF~ufNfN^N
ffs??fNff	VfF    fNNffsfNfNfFfN`~uN6L
~uA6L
F~y3L6!D
fFkfXfY_]UfQfPKFF    tu[LEr
Ffnf6D     f6D$    @  uaF$ufvVU2ufn=fv~ t fnvsnvsnf6,f6,
fUfvF NN^JF	KFKFJF
JFJF~unff8ft8ftf6,f6,
:fsfff8ft8ftf6,f6,
:fsfff8ftf6,f6,
f3fNN~t~uff6D ff N^"J3J$:Ftf6,f6,
:FvFFJ$:Ftf6,f6,
:FvFFI:Ftf6,f6,
:FvFFI:Ftf6,f6,

I$:Ftf6,f6,
f3fNN~t~uff6D$F@  uF~Cf6$sN~ t&fvfnvsnvs)n"f6D f6\$f;v
fvfUf6,
fXfY]UfQfPfRV ZIFXfPQf bJf s	f6lf6t3F TIYfX7 IF IfffFfF    F zfF    F AN6L
s3@ r# f@ffFf;Fv
fFFFF~rf~ f6D sf@fff^ff f=    f;^ ~  ~  f6tf6tf6Df6D f^f   f;u'f6LfNfF    fF    f6l6-Cff+fffN8rfFfFf6l6-f6Df6DfFfFfPfPfXfXfFfFN@fF f^f^ff6\f6d rf6LF~~^fZfXfY]VSx?؊[^VSu?u?؊[^VS?؊[^VS?؊[^VS?؋[^VS`?؋ [^PVSQ8v̾?؊vY[^XUNVv20FF>FFFV.FF"Ft;F+f	 fȊFVnE
t8Fs]UVfPfQfRf36D6D6DFFEFF   N^E FF  F NnE2~?sFFr~@rߋV~@ui8uecEF<t<ucSEF$ tGV6T~uVF$tV*E<u6T
E<u6TF$@tf6l~@uf6  F~66TtW~ t^3t
f6  f6l6\t
3uf6l~ t$3^t
f6  f6lf6  f6fZfYfX^]UfQfRfSFfFFf6drkDDw
~vF  D
t D:FsF FFf6ds4 lD
t$ bD
t
6D*f6l 6D(f6t 
6D*6D(9FvF ~r~vF ~ t~ tFf3f[fZfY]23SfQfR fZfY[SfQfR# fZfY[fQfRf   $fffZfYfPfSfQfRffѹ ff$fffffZfYf[fX                             ' ]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    D]    戰䈽aejge戰䈽weOfefeOfefe@
fefe'fejfe
 f%"feHfe	e
ff,f
fHfff %ff1f
f;f
fGf
f f
   `"	f   f3f30f  0f{f
fn8f   f f    0f  f f   0	 f%"ffk
fAf.Def.8] f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.Jef.>]徰hf`g  
ofkg  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      h      l <                      ?    D @       a#c     Aa     
             @  p  !        @              L                        L  B        ?@   k  `   d     `   d     `    d    `   d  A     `      _        }           z        z    _      @   
 `        @ &    H #   P    !        @ ܣ   Ҡ   b  d      e   i   i   l   x K      j        P  P P  (  l        @   D A  E    G `  x    H   J   I  h       l      p gE#       
    R  e $ S      !  "  #  $  %  &  '  (   )  *  +   ,   -  . 0 /     * `   P             T    ? P  ?P    ?0   1   
   Q   U  h L g  a L x  t   p   | Q         . U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /  . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A           X           `        d                            @             @      $             N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N  <foTf%fo<fupppppq
pfpfupppppqf  f	  f   f@ fغfgffffff%   f=   tf   f@ fưfpfupppppqf gfgfV0f gfFgfV0$ pfpTfupppppqf  fff
 0  fff   ufqfupppppq"fBqfupppppq f 2f0f 2f
   0fffP  0fX  0fffh  0fAfo  vfqpfupppppqg- fqGfufq1f ! = u%% = t{= ufArftfUrff  G$fG$
а U../0./. d< ud< t<t
ufrxf掰frdf䎊frRf f%"f   2f%0 f
   `"	  "	f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3ҊPR Z
R 4Zf   f$<rf  Ժff
 f+;w
t@fغ  ff% f؀f   ttf   ff% f;rfft  +f   `ff   ff   dfff
   ff%ff    f   dfff%?ff`u  f  H$fH$
и f  D$fD$
иA 徰hfu  ofu  PR Z
R 4Zf  ffZRff  pff2Qff  tff!@pPff  xff 8 ff  |ff!  f                                                      	            !            p                                       @  0   G                             P  0   W    X  @   _    `  P   g    h  `   o    p  p   w    x                                       @@           fSfdvgf&f[fSfdvgf&f[fSfQfdvgf&	fYf[fPfSfQfdvfgf&!fYf[fXf t
fgf&   fS
u
fdvfhvflv.f[fPf   pf% f
   pS *[Vf%   f=   tQfH   <f   u<f   tpvf   fT   'ffP   f%f
   CfXfPfSfdvf  f   f%fd *f   f   f   f% ff   f  f   f4   zf%   f
. 'zf    f    kf(   bf    gfdD ff   rf   f3ff3 )f[fXP , ,XfQ gfd   t@g&Xf3f+gf&| tfgf&9Ltfgf&Dgfdǅ       fYfPfSQfWf    fgf&D= ff   ff9Duf   f   fgf&Df  @ 
>zv tf
    gf&D f   ff    Hf$   ?f   f   0f   f   0f_Yf[fXfPfSfQRVfWSf   f[f   fgf&D= fGgf&D=#yv wv(f   f   utu@yvf   f   f   f@  @f_^ZfYf[fXfPfSQfWfWf    fgf&D= ff   ff9Duf_f   f   fgf&Dff%gf&D f   ff(   
f,   f   f   f   f    f_Yf[fXfPfSQRVfWfWf   fgf&D= fGgf&D=f_8yv wvf   f   u	&ztu@yvf   f    f   f   @{f_^ZYf[fXfPfSQV6f   t/3 t*$f   u zvg&ƅD    vv^Yf[fXSS2 V&[f   2 S B&[f   f   f   d &[fPfSQf   pvfT   ffP   f   f   f@   Yf[fXfPfSQpvfT   f   efYf[fXfPfSQf   f[  @DpvfT   fYf[fXfPfSQ f   wfgf&D f (|mrN (fdvf taRr3 +% (p t(fdvf t	WYf[fXfPSQfRfW<v PfUfʻ  fP  ff0fwffwfGfwff]X tffwffwf   ffwf_fZY[fXfPfSfUfQRV'fqv	av  f    f   fgfgf&E   >av utav fv  gf{ tgfkgf{ tgfkgf{ tgfkfӹ0fP  gf{ tgfkgf{ tgfkgf{ tgfkf0^ZfYf]f[fXf t
fgf&#fSfhvflv&f[PVS vv _#[^XfPfSfH   pvf[fXPfSQRVgf&ǅ@      gf&ǅD       vv g&A    
 v wvg&R  @v@ g&G  s vwvP>yv uccdb=$fSfa  #f[g&^  %# $fSf  "f[g&_  	#"g&^  ug&_  u>{vt^ZYf[XfP3f.qvfX         f   f=Pt=Pt=pt
=t=u8f3f3f3ۻCfff  0f3f3f   2Cf.;Gt %A      jZ>        P   D  @   5{ ?< L<'`&t  j?@ 
5 ?o?  0 x7 ? ?o? 
 7   ?o ? 
7 ?  {  ?
  =?o?   7 ? ?o? 
 7   ?o ? 
7 ?  {  ?
 = ?o?   7 ? ?o?  
7   ?o ?
 7 ?  {  ? 
= ?o?   7 ? ?o?  
7   ?o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             PȎf   AXus  q  >rfg   ( r  .fV>Mff<>3fffsrfff> wf   >ff%f5fff> trf> wf   >2>m>dff   fF>=,>#>	ff  > ff'fr$fff> trf> wѰf     >urd>u]R D>u=/>u(f "'  >	r  Ko s 撰 Xщ>Ɋ
$@Qҋ#fSgef[gefPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@
 > u> 5xzytsfZf[fXúz.yusfZf[fXPR tĺZXfSfRf@
 > uB ;yM@tNs(xغz,y0@u1sz.fZf[Ru	sZ                            	 d   d           d   d   d   d                                                           
      		      

      
      

      

      	     UVQRF F F F F~^ t  F  EN6Ls8F^F F
$<u  u~t F FF~r  tR~Es'~s~w	      ~s~wd d ~s    F  CN6Ls6F^%F F
$<uF~u F FF~r~u~u΍F:FsFf3ۋf8uf~Er  F  6N6LsF^du FF@  u
  uF ~rĀ~Es3~u	   ~u  ~ud  d  {~ud eu`F  #N6LsF^ FFF~r׀~w~s    ~s    ZY^]VS suXu&NuI2Duu>5uJ+u&V!uubunuz݊u[^UVSQ i
t
 _cFF~u!~uA~u6~u0+~u~u~u~u	~u݊Y[^]UVSQ 
t 
i2FF~u!~uΎC~uώ8~u2Ў-~u~u!ю~u~uҎ~uӎ݊Y[^]         f  f!  Bf3һMf  ff  ff  fff
   ff  ff   ff  fff
   ff!   tf3һi` f   ѓZd f3һݓNf`f   =dfF/f 2f%  ff3f 2f%  f   fff 2f   tff3`f   ZfѰde`f   sdfֻ~f ` f   d f3һZf   p3Ҹf  f
   ff   f  fff	f  f
   ff   f  fff &f`  ff&   fd  fffff`  ff   fd  fff<u
fϋfff
   $f$
ĊËfϋfϋfff
   $f$
ЊËfϋSfWfRfP눋fXfZf_[$f
   f fffff$f
   f ffff                                         0         @                                  0                                          0   ?    @  @         P         `          p   ?    @                         P@ I@ Q QfWf   gf&D=     ff_Yf`f  g&D5 |v6vvsU >|vt faf`pD$&v
ĈD&vvs f  g&|5  t>|vt far`{r ra`D$&}v
ĈD&}vvs>|vtN a`&}v D$
ĈD𖻠vHs>|vt afWpr f_fWf  g&D= g&D=Uf_f`g&d  g&k  Āu g&G  vv{v vvG 	Pvzwvأfa    f`f:?f  g&D= (fgf&T=fg&D==r>r6QfPf  f>: gf&D5 gf&fff>:fXY/sufaPS&	$&	[XÀ&&        fPfSfQfRf  Pffff?f   f  Pffff  Hffff  Hffff  hff  ff  lffff  ge f   fZfYf[fXfPfSfQfRf  Pffff?f f  Pffff  H$fH$
$f  H$fH$
Њf  lffffZfYf[fXfSfUUgef*geUfUUge$ge  ge f  gef[ZV`VfPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X   `fffY  0h0pua`f    ffY  0ffбh0puaY  f
   `"	f3f3f   0f  0f  ff  ff 2ff%  fff  fff f%"	5 tt! >@s! 'ô ` uR Zts+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          TfS  ?   fg  +   f{     f  q
  f   fHt	f쨎tf<w' H$tt
f         f˻ f3ffйh0i0 ff" 3f   ff   f @  gff   ff  f @  f3gff˼   VW茠_^f 2f0Unf 2f%f
   0f  f3f3Ҵ02 0uP0X0Y0h0puf 0u00f 2f0~3Ã u 
u   RQ 
uHu
t!utuuYZV36.^                         ø  f   f$<wDE2 fl f fh f 	f f    }f 'Yf   uf   tf f   KMf f  ];f f    o)f f    f f    f  fff    tf  f  @ t f  ff ff   f$<vf ff  ff  ff   f$<v fl S-fr`8frӺf                                   Q  YPSR+;wZ[Xf> tftf`f f3f3f3f  gfffCgftftfaf   fuQYfVfSfQf
!  f   frffYf[f^fQfWfVf @  f   f  gff^f_fY0123456789ABCDEFPfSg.<$tCf[XP
XfSQRfq   Ѓ.sZYf[PSQ؊Y[XfPfSQfع fYf[fX            f  f  fPQgf0& YfXf    gf~gfNgfVgffPfSfQfW<w f.?
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           `.<ta ø fSQ >tf  r	f r&  r-w ge0fp  )rge<uf   ⸸   Yf[fS>tf  r	f rf gef   rge8u   f[PfSfUUgef*geUfUUgefUUgef*geUf[XPfSfUUgef*geUfUUgef[X     9f ? fPufhvfdv 
flvfdv fXPRV d ^ZXSW  _[SW  t_[RfQfhvflvfYZPS  f   r  f   cff=   t  f  =    
[X     PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     ffffffffffff戰3ظ  м{fҨ]ffJf    2ø       @ 3w]e11/22/05DTTfWU68DTA   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 ys f    Q?sY 戰f
   ff    f   tf ff
  rfBYi戰Yf3gC &f3f   戰 fHr4f f戰䈰5yf戰 rfFf    戰戰3|f  f   f戰fSlf[f   f   3f   f  戰g&CfFfCg戰|w}s 撰fPfSfQf   fQf3یff
   `xfYsfYf[fXSgu
  ;u[fPfSfQfRfWf   f3یff
  	 xfBf    f3g}
    fg
  r%fG;wg}
  f_fZfYf[fX  fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   (fsf ff   fT   (fsf wfD   f @(fsf [(fsf 5)fsf )fsf c1)fsf MG)fsf 7])fsf !s)fsf )fsf 7)fsf )fsf 3	)fsf 	)fsf 
)fsf F
f   t*fsf c
n&*fsf xX<*fsf 
BnnfLg&nffOg&fffsf fsf f   f   *fsf f~fs*fsf ef   *fsf F<|*fsf  6*fsf j
+fsf +fsf -+fsf x=+fsf =f   tV+fsf f+fsf of   t+fsf h+fsf +fsf S+fsf +fsf &f   u+fsf "+fsf +fsf Y&,fsf ,fsf )'(,fsf L'8,fsf 'f   N,fsf <wb,fsf 4 f%"f   t
fQgf  ,fsf {ta$f  ,fsf ;Vf  ,fsf Df  ,fsf    Iuf  -fsf f fsff   f   f   P-fsf tff Ag&uf-fsf &r8u:-fsf &u$f3f   u
ffuf   tf fsf   -fsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  t.fsf $f  .fsf i%Uf  .fsf rf  .fsf 6   Iu f fsf   ffuf
/fsf %tf   ),/fsf $8uf   uffuf fsff   ftLt/fsf $f   t$<t)<t//fsf $ufffff   uf fsff   ft(
/fsf 8$<t<tfffff   uf fsf   t8f   ftF0fsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tTT0f   1fsf $t<tff @   f 51fsf "2  +O2._1fsf "<  ff   f.:w .D1fsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2Tff   f
.f   2f   f   ft/2fsf !< t8stff   uffff fs2Tff   f
.f   2f   ft(%3fsf  < t8stff   uff ff fs2Tff   f
.f   2f   ft(3fsf  < t8stff   uffff fsf   f    ft'3fsf $ $t<s
f   <tff   ufff fsf   ftT4fsf uff   uf fs2Tff   f
.f   2f   ft($4fsf m< t8stff   uf?fff fsfffsf fsf 2Tff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%_f   t_.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfT2.<u f   t2kf   uff   u6fsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   37fsf <|f`Agf&   f    f    f   r7fsf f    f    3f   ft7fsf Ufft7fsf ;fft7fsf !fft7fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   8fsf <|g&f~fsf fsfLf   f3f3ftr2f   t8fsf Qtf˰8fsf 5<	rIа9fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx_.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8_  f Lgf&fftf_  f~fsffHfuff Lgf&f   ftf@l<fsf f Lgf&fftf^  f   tf^  f^  f   tf_  f Lgf&fpffHf   tfHf~fs<fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	=fsf fBgf&=fsf  =fsf  Tff%   f
fHf   t
.f@Cg&Tff%   f
fHf   t
.fCg&fKgf&I>fsf Ff fs侳Tff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsTff%   f
fHf   t UfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}_.fDg&(_σ.fDg&.DfDg&f3Uf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`[f~fsfffsf fsf f Ef   .@ fffsf fsf Xfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_Bfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
_fHf   t_fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	_f   t_f~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H_f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fH  Hfffsf fsf f x_.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|_  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xHfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfT  f Lgf&f   tfT  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+`  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk`  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            f   ff   2fff   ff3Nd.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2TdTl           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE            D   @    L       @       H         `      T    G R         	 	
     X   	 	       	 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D     X      P    D    X      P    `                O    O    
Ol`

Ol`
Ol`	O A    A    
@          
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <D	     <D	     <D	    <D	    ,<D	    ,<D	    ,<D	    	,<D	    	 T <D	    , <D	    ,0<D	    ,<D	    ,<D	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                                       	4 @      T                      d  ` h   X  ?     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<D	     #<D	    P0#<D	    @#<D	    PP#<D	    	 #   !    8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < f}f%f  $f$
tWppqtHf}fupppppq~f~fupppppqf  f  gffLggf^gfnf    f
   "ft~Ofupppppqg- f~&ff~ff  @$f@$
= u$<T)f~ff  @$f@$
и f  D$fD$
аf4f% = ufPsf fe^f %  fBfU../0./.	/`./a. /0./. B쨀u?ff d< uffd< t<t
u掰ff䎊f*ff<f掺<uf`cf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  $f$
иf  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   f`tf  O}f  對 f    < tg                                      	            !       p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR   C vZ[XPSR !Z[XPSR   C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ftt vugf&>tgf&6f٢ &fE ~f^Y[fXPSRfV  tA   % g&ƅ    fK  \g&  	uf^Z[XPSRfV  tA   % g&ƅ    fK  g&  	uf^Z[XPSR     qZ[XSR  z C vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $ff f	ffff]X t fff f	ff  fff_f^fZY[fXRfŋӃf3ӃZfPSQ  f" A vY[fXf` f;.t
f.   ~ $C vf3 
 f    fgf&E   > uF f+  gf;tgf+gfkf0f   gf;tgf+gfkffaPf  3XPSRfVg&ƅ    fK   <  f{  	g&"  @v@ g&  s f{  	> u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      4    戰䈽QjW戰䈽gfsPf}밳f:f찴f$fаff f%"fדfmffHf	f f!f+/f7f f
   `"	f   f3f30f  0fkXff   f f    0f  f f   0	 f%"fff.4f.( f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.:f..`tfP  
zf[  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pf   FUus  6
  >rfg   ( r  .V>Mff<>3fffrrfff> wf   >ff%f3fff> trf> wf   >/>m>dff   fF>=,>#>	ff  > ff'fr$fff> trf> wѰf    } >urd>u]R	 D>u=/>u(f ']  >	r  KI	s 撰 X+Eۗ;Uo/=RnfSgf[gfPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@
 > u> 5xzytsfZf[fXúz.yuksfZf[fXPR tĺZXfSfRf@
 > uB ;yM@t&s(xغz,y0@u	sz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  v)` f+  G 
f   ufaPSQVL	;t	  ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6)!js>t fafWf   g&D= g&D= f_`r r8 a`f  gF
$&
gF
&!sw>taf`f   gF
$& 
gF
& !s@f  g&|5  t>tVfarfWr<f_    f`ff   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f> gf&D5 gf&fff>fXYsufa`f  & gF
$
gF
f  !sF>tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њvab  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tfz  ?   f  +   f     f  j  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_Z6`6fPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇$ *"[XPSQRW0  3=  3/  3!_ZY[XPSȎػ    	   !    A   f   $       [XR $# &1 (ZSQW   l_Y[SQW   W_Y[SQW   B_Y[    f  fО  fPQgf0& YfXf    gf~gfNgfVgfϤfPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .
<t ø fSQ >tf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0fp   rg<uf   ⃸   Yf[fS>tf  r	f r>PfSfUUgf*gUfUUgf[Xgf   T r
g8u   f[                                Q  YPSR+;wZ[Xf> tftf`f  f3f3f3f @ gfffCgftftfaf   fuQYfVfSfQf
   f   f<rffYf[f^fQfWfVf @  f   f  gff^f_fY               PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{ff[ffD    2ø     "  @ *5M10/24/05DATΜF% PF% P    _^]ÐU "VW P P P* P Pn P P% F Pt%  NF P P,F  _^]ÐU Y"VW P P P F% % P PMF% % P P9 P P P P_^]U !VW 
 Py   RPm_^]U !VW%PM   RPA_^]U !VW( nFFn=  u    RP
    _^]U O!VWFPT _^]U 1!VWF O^RPF^N؎&w&7>RP?FV=  t  uP FF;F|' F^N؎&w&7vv
7 aRP PBtRPF^N؎&w&7f>RP>FV=  t  uP FF;F|' F^N؎&w&7vv17 wRP P%RPF^N؎&w&7=RP=FV=  t  u
 ^& RPF^N؎&w&7=RP=FV=  t  u h RP&  PRPF^N؎&w&7,=RPH=FV=  t  u h RP{&  PF RPd&h RPW& PFF9F}_^]ÐU VWRPF% P P P P P P>% =  t RP  F    P% =  u 
 F~s P% r RPJ P^&  r RP' _ RP L RP 9 3RP & # =  u= u= u= u_^]ÐU VWRRPF
% P PF% P PwFn% =  u P P% =  t iRPI  F    Pk% =  u 
 F~s P% v yRP P^FF&r RP h RP U RP B RP / # =  u= u= u= u    _^]ÐU #VWRPEF% P P* P PF% P P P P% =  t 'RP  F    P% =  u 
 F~s Ph% b 7RP  r NRP _ gRPy L RPf 9 RPS & # =  u= u= u= u_^]U VWRP	F
% P PF% P PFn% =  u	^FF&% P P P P8% =  t RP  F    P% =  u 
 F~s P
% _ RPDr RP4 h "RP! U 5RP B SRP / # =  u= u= u= u    _^]ÐU VWrRPF  a F% Pvv=  u  \ ^&% =< t ~RPa9 RPORPBF~sRP(   _^]U VW PxP^2F    P>2F~2s PxP12  _^]ÐU VW_^]ÐU VW_^]ÐU oVW{_^]ÐU WVW_^]U CVWRPeF  >  P P=  u .  PFRPw% =  u  F~sRP	   _^]ÐU VWF  ;   P  P=  t!   PFRP% =  u  F~s   _^]U aVWFF F FRPs   RP  P P=  u  w   PFRP}% =  t  V    RP  P PFRP=  u  &   PFRP,% =  t     _^]U VWFF F F0RP  P P==  u  s   PFRP% =  t  R   P PFRP6=  u  0  Pw  PFRPp% =  t     _^]U VWKRP  P P=  u  g   PFRP% =  t  F FVFV  P Pvv  PFRP% =  u     _^]U 7VWeRPYF  FF% = |@ RP3  P0 P  PFRPX% =  t  F% = t   F  FF% = |  P  Pp Pb  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% % =  t     Q   _^]ÐU VWRP  P  P  PFRP8% =  t   F  FF% = |  P  Pp PY  PFRP% =  t  i   PFRP  PFRP% =  t  7 F% % =  t F% %	 =  t     Q   _^]UL VWF  F  FȌRPRPF  F   P@ P  PFRP% =  t    P  PS  P  PE  P  P7  P P)FVFVF F  & F^N؎&% = u F
 F~wF% =  u~ u/   PD P  PFRPG% =  t  9  P Pvv  PFRP% =  t  F     Pp PN  PFRP% =  t     PFƌRP  PFRP% =  t   F% %@ =  t F% % =  u  t  
 F~se~t  S FFFȌRPFRPFRPv!vFȌRPRP
F9Fs  K  _^]ÐUJ yVWF  F  FʌRPk
RPF  F    P P  PFRP% =  t  lFVFƉVUF     P^ƎFȃF&% PF~ s  PFRP>% =  t  F      RPF  Pp Pl  PFRP% =  t     PFRP  PFRP% =  t   F% %  =  t 
 F~sp~t  e F% % =  u  O FFʌRPFRPFRPvF	vFʌRPRP5
F9Fs    _^]U VWRPF  >  P PQ=  u .  PFRP% =  u  F~s   _^]U -VW4RPOF  >  P P=  u .  PFRPa% =  u  F~s   _^]UL 
VWFF F F FF  F  FʌRPTRPF  F  P PFRPu PFRP% =  t  FVFƉVyF  1  P P PFRP% =  u 
 F~s~t  1F  #  P Pvv?=  t 
 F~s~t    P NƋVRQvv
+
 FFF;Fs  FʌRPFRPFRPvvFʌRPiRP
 P P PFRP% =  t  U  P Pvvk=  u    P NƋVRQvvQ*
GF9Fs    _^]ÐU VW% =  t RP N vv% =  t RPh % % =  t RPH    _^]ÐU* !VWF RP? P P=  u FRPA F RP PFRP7 P P PFRPRP PxP$F% =  t  +% =  t VRPl RP~ PxP# PRPF  FF% = |7 RP30% =  u   RPF% = t O 6U% =  t RP,  % =  t &RP	  F֌RP% =  t IRPd  F F% = t F @uRP-% =  tO  Pz% =  t4 % =  t& % =  t gRP߃ A 
  P+vv% =  t .RP߃    _^]U
 }VWF  F  F  F  + v
vP Pvv%  FVnF~ tv
vv Pvv
  FV~  t ~ t     _^]ÐU VWF  F   PRPFRPRK  
F  F  + v
vP Pvv  FVnF~ tv
vv Pvv  FVFE F^N؎&N^يFN;u RP!ރ  F~w    _^]ÐU VWF  RPD P1F   F^N
؎&FF= sv
v% =  t RP݃ v F  = F^N؎&% N^v
َ&F% N;u FFF= s~ u v'	RP}
     _^]ÐU VWF  FF=2 | F^N؎& F^N؎& H	RP
  _^]ÐU VW F+ t@ ^&?dr4 ^&^& + t ^
&&^N؎&  _^]U츮 )VW6D 6B J	RPj	RPvF  ZƆX ǆV   V
&Ƈ VV sXRPFRPZRPvvvrF=  u 	RPFRPRT=  t  t 	RPnۃ P RP% =  t 	RP>ۃ PTR RP% =  t 	RPۃ PTR>Z=  u 	RPZRPFV=  t  t 	RPڃ P=vv RP% =  t 
RPsڃ P RP'% =  t (
RPCڃ PX% =  u8   RP RP% =  t H
RPك Pvv6`
RP:
    _^] 0!<s3P˿6 + r ׁsh3P1L!6
6
ƱH6l
n
66gP6g
P6g6g6&h
6 +۴J!6
 +3
O3X 6
6
6
6
6
P.L'ظ j
(P.L'ۚ^,  y>
uXP
 Pj
 5!

 %'!
)
&6, 

3
sx

 

&, >3&= t4
 
t3u!
,Ar
,Ar
ª 
 D!r
t
@Ky

 

 

 U3U UVW UVW.
Q
u't z 

b >
u


M 

S  tX
Pu~ uF  X
uFL!_^]Ë
 

 %!;s
OO
;sEtU P>
 t
 P]ø Y+r
;
rQ3 V3B 22Ut
 Pt ^Ï

 <t)
&, 
3 3uGG>
ыѿ  
< t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ

6?6W6

u6
 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &
U
&, ÌF333t&>   tFu@$F	  RP 

Vϋ3_I36;
uQVW
 _^Yt^?G^
u͎^O]UVWV;t@t3_^] UWvt 3I >
u
@!_] SQ \
QP>![\
Yt[Ë r3]sP X2]s ]2 â

u">
r<"s< r<v
ט
Ê  UWVFG
@tG
  D
u VށFVD*P|]~ tZ
PNQKFFV~\t PFPN
 Pvvv)FP!tD
 ^_]U
Vu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S
Y[X+)D `;Nr/3ҋv+SQPS3DP.Y[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DPY[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU

t>]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %
炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt4u%
@t ~QWS EL
 cSV [D
tҋT+BUJT$QQttSY|V&;u3F3
 t QPPS7	3_^]UVvD
t$t ttd
3DDDD^] UVv PYށtL
G L
G ڍGTTDD  ^] UWVX
FF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvvG
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	4uVD
uFuAWt!DTTD E L
 S P[[tW3_^]UVWvt,3ۊ\
@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GP
= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*PD;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] w66666 7)7[7UVW3FFv&vF
t~ }F, <Xw$ FF.6V 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuM
S
WN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
h
F
^
FFt~ u	Wd
guF u	Wb
&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]U^;
r 	>!rƇ
 U^;
r 	1>Z
 tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!r
& U2>
r~
FF
U2~FF  u @uW
uFV$
Ǵ=!su	 t % = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;
r
>! 
N
Ë]2ܡ
#3ɨuU^;
r 	s3N
l
ue>
u
N
V?!s	G
t@
VW^'
<
u&
:t<u&
G+_^t<
t
@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B&\
=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ
+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U~3uI] UWV~vߋN
t2Ì^_]UWVN'~3ˋvD3&:EwtIIы^_]   UWVv33۬< t<	tP<-t<+u<9w,0rҋˋ؃ X<-u؃ ^_]UVWN
F3҃
u~uUV

FVtpFFthvv^&G&tN&w&7;v7^&&8=u+Vvv^&w&7
u^&&W@
F3^]UF+F
F +F ]  WV@3VM@tG96s^_UWVv|96

	 4
&
=}3#
tVt
>

	 ^_]ÐUV2] UVF ]U"V < RP6
6
^&GFPFP~ u~ uFPfF-ȉFP FF*ЉFF^*^wv
Vu	~BVF*FF^&GF*PFPFPvvvR^&&W>
 tFPjt^&G 	^&G  ^]Ã> u ÐUV3
PFVu^&? u PS6
6
~
F^&?-uFGFRPvRP

^&?+t&?0|&?9F&?:ud< RPFvRP

	&?9F^&?0}&?:u*FvL

&?9F^&?0}t


 
^&
t PS6
6
	
& ^]ÐUV^&
C} &} &	~ &~&	|z&w
V~&u&_ۋ
 &_ۋ
F uF RPmDLF-
  RP+F^&u&;G|	u&| &9G|u&|3^]UWVv^ۋ
 u~~G< RPRP RPƹmȋFڙFVDFVڋǙځD SQȋF
ڙSQȋFڙSQȋFڙ

N^FǉFDPFFHFF
F>
 tFPbt	n^ FV^_]U
  FPRPFV+

RPLȋF+
ڙӉFV]ø
PU^,a<sAC
uڎ]UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VW1NxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! UF5!Ë]UFV%!3] U*!^OwG3] U,!^/OwW3] UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USW3F}GVڃ FVF
}Vڃ F
VuNF3F3OyCH؋NVFuf
fr;Vwr;Fv+FV
+FVOy؃ _[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UNWVHv
~H+#+#@+u uǌ 뾋FV^_]U^;
r 	W>
u
 tB3ɋ!r
tz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^
@t^^?u F+Ff^_^JߋN
u>V@!s	u
@t&?u Y
;s+3UVv&L^]UVWNwi
tH0N6

VW_^s+_;uX6
&t
;u>t>^0Nt

r 

39
tv
tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;
v;
v
3&EGUVA!	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       MS Run-Time Library - Copyright (c) 1992, Microsoft Corp    Unknown command line parameter!
  Usage:
	TFLASH [/S outfile] [/U infile [/V]] [/?|/H]
Where:
	/S to save image into outfile
	/U to update flash using infile
	/V to verify the flash update
	/H or /? to show this help message             
%s Activating micro flash interface...
 /U Missing file name! /S Missing file name! /V /H /? Read a byte from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Read block from IIC... Mailbox0 locked Success reading from IIC Timed out reading from IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write a byte to IIC... Mailbox0 locked Success writing to IIC Timed out writing to IIC Security violation writing to Mailbox Mailbox command not supported Unknown error code in Mailbox5 Write block to IIC... Mailbox0 locked Success writing to IIC Timed out reading from IIC Security violation Mailbox command not supported Unknown error code in Mailbox5 Read ACK... Ack received Did not get ACK
 Trying to read ACK again... Timout... Ack NOT received Send Flash Write Enable Command... Timed out, or IIC access failed Send Frequency Command... Send Erase Time Command... Send Signature Command... Send Blank Check Command... Sending blank check command... Send Erase Command... Send Write Command... 
Writing...  [%s] %u%% Send Verify Command... 
Verifying...  [%s] %u%% Send Enter Flash Mode Command... Send Exit Flash Mode Command... Send Read Command... 
Reading...  [%s] %u%% Failed to enter flash update mode! Failed to read flash! Failed to exit flash update mode! Start Programming... SkipWriteEnable = TRUE SkipWriteEnable = FALSE Sending 0xF0 to the parallel port (pwr OFF, reset LOW) Failed to send Flash Write Enable command! Sending 0xFA to the parallel port (pwr ON, reset HIGH) 
Activating Flash Mode... Activate Flash Mode Failed to send Reset command! Failed to send Frequency command! Failed to send Erase Time command! Failed to verify Silicon Signature command! 
Erasing... (This may take a few moments) Failed to erase flash! Failed to write to flash! Tempest This is an invalid file 
Verifying...  Failed to read flash device for verify! There were %u miscompared bytes! 
 
TFlash utility, Version %u.%u
 Copyright 1999 Compaq Computer Corporation

 w+b Failed to create output file! Failed to read flash device! Failed to write to disk! r+b Failed to open input file! Failed to read input file Failed to program flash device! Failed to verify flash! 
Done!
   (                           _C_FILE_INFO=                                                         
                
	
\ \                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    EEE50 P      0PX 000WP         ``````  ppxxxx        (null)           ) ) ) ) ) ) )      ; Z x     0Nm : Y w     /MlTZ  p   PST PDT 

                               '''                  F0<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
 NNB09Ho      CV   N     dos\unlink.asm     CV   N  D   
newseg.asm     CV   0N  |   searchsg.asm       CV   M  6   linkseg.asm    CV   M  4   initseg.asm     CV	fdata.asm      CV   M     fmalloc.asm    CV   M     stackava.asm       CV   K  \  	write.asm      CV   RK  ^   hmemcpy.asm    CV   J  _   	uldiv.asm      CV   RJ     lrem.asm       CV    J  2   lmul.asm       CV   I     ldiv.asm       CV   jI     dos\gettime.asm    CV   NI     dos\getdate.asm    CV   LI     dos\enable.asm     CV   JI     dos\disable.asm    CV   4I     dos\d_setvec.asm       CV   "I     dos\d_getvec.asm       CV   I  
   dos\d_commit.asm       CV   H  c   xtoa.asm       CV   RH  ^   hmemcpy.asm    CV   G     hmemcpy.asm    CV   G  k   
strstr.asm     CV   F  $   
strupr.asm     CV   F  V   clock.c     CV_cinittm.asm       CV   E     
dtoxtime.c      CV	timeset.c      CV   C    tzset.c    CV   B    dos\ftime.c     CVdays.c     CV   B     dos\outp.asm       CV   B  
   dos\inp.asm    CV   (B  X   commit.c       CV   B  $   
closeall.c      CVdos\diffhlp.asm    CV   A  +   
dos\hdiff.asm      CV   HA     getenv.c        CVcmiscdat.asm       CV   ,A     itoa.asm       CV   @  V   atox.asm       CV   @     atol.asm       CV   @  ;   strncmp.asm    CV   l@  *   strncpy.asm    CV   R@     
strlen.asm     CV   @  <   
strcpy.asm     CV   ?  T   
strcat.asm     CV   >     growseg.asm     CVfree.asm        CV
malloc.asm      CVseekfast.asm        CVncommode.asm        CVtxtmode.asm    CV   =     dos\read.asm       CV   ;    dos\open.asm       CV   v;     
dos\lseek.asm      CV   V;      
dos\close.asm      CV   ;  N   stream.c       CV   6    
output.asm     CV   4  D  fflush.c       CV   4     _sftbuf.asm    CV   2  :  _open.c    CV   2  I   _getbuf.asm    CV   L2  5   _freebuf.asm       CV   d1     _flsbuf.asm    CV   0     _filbuf.asm     CV_file.c    CV   0     _cflush.asm    CV   t0  B   printf.c       CV   .    
fwrite.asm     CV   n-  p  	fread.asm      CV   $-  J   fopen.c    CV   `,     fclose.c       CV   ^,     farstub.asm    CV   ,  U   dos\dosret.asm     CV   +  #   dos\stdalloc.asm       CV   +  `   dos\nmsghdr.asm    CV   *     dos\stdenvp.asm    CV   @)    dos\stdargv.asm    CV   )  "   
chksum.asm     CV   )     
chkstk.asm     CV    )     
crt0fp.asm     CV   (      dos\crt0msg.asm    CV   N'              dos\crt0dat.asm    CV   J&    dos\crt0.asm        CVoldnames.asm       CV      9&  
tflash.obj    
  $       	     
tflash.obj *     `   d   $      PromptError      pErrMsg   &              4   DebugMsg     pDbgMsg   .           .  ( F  	 GetDosTimeSlice     "         D  > t   alarm    s TimeoutValue     &     \  `        IoDelay      s io_cycle   
 	   l1  &         *  $    MsDelay      s TimeoutValue     *         X  K   
IntervalTimer  	?  send_eoi    "     (  ,  @  : R  Wait       delay  
  s i    *     h  l      	 EnableRtcTimer    temp     .            j 	 DisableRtcTimer       temp     .         k e 	 ActivateFlashMode 
  r i    "     4  8  ;  5 j  Sleep     wait      goal     "     l  p  C  =   Delay    " wait     "         @  :   SmcGet     index    "         D  > *  SmcPut     index       value    &     4  8  R  L n  SmcWait        mbox   
  r i    "     |    c  ]   SmcCmd     index       value    *           y $  GetSmmFlags     s iFlags   *          r  l   SetSmmFlags      s iFlags   &     (  ,  ,  &  	 LockIIC     &     T  X  ,  & B 	 	UnlockIIC   &         @  : n  	SoftDelay    s Seconds  "              Exit     s uCode    &         s m  GetParam     r argc      argv     
 p
InfileName    pOutfileName    
VerifyFlag     temp2      temp1    pStrTemp
  r i    &         ; 5@
  ReadByte      value       Address
  s i    &     L  P  ] W|  	ReadBlock     Buffer      Count    
   Address
  s i    &         < 6   	WriteByte      value       Address
  s i    &         a [  
WriteBlock    Buffer      Count    
   Address
  s i    "     `  d     x ! Ack       Status      Address
  s i    &         O  I  	 	SoftReset 
  s i    &            j 	 
TurnOffVpp  &            | 	 	TurnOnVpp   2     (	  ,	      	 TurnOffProgrammingMode  2     `	  d	      	 TurnOnProgrammingMode   2     	  	    y  " SendWriteEnableCommand    Status 
  s i    .     
  
  b  \ : " SendRESETCommand      Status 
  s i    2     \
  `
      " SendFREQUENCYCommand    #Freq       Status   2     
  
     j " SendERASETIMECommand      Status   #ETime    2     $  (     & % SendSIGNATURECommand      SignatureBuffer   buff       Status   2         E ? " SendBLANKCHKCommand       Status     BlankStatus
    i    .           " SendERASECommand      EraseStatus    Status 
    i    .     
  
  o i % SendWRITECommand      BinaryImage    ProgramFlag  &ProgressBar    WriteStatus   ImagePtr     s CurrBlockCount     Status 
  s k    s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .        $    % SendVERIFYCommand     BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status 
  s k      VerifyStatus     s PercentComplete
  s i    s 
ProgressCount    s 
MaxBlockCount    .     p  t  r  l ^ " SendENTERCommand      Status 
  s i    .         r  l  " SendEXITCommand       Status 
  s i    .          B % SendREADCommand       BinaryImage  &ProgressBar   ImagePtr     s CurrBlockCount     Status   s PercentComplete  '	ReadParam  
  s i    s 
ProgressCount    s 
MaxBlockCount    &            y \ % 	ReadFlash     BinaryImage  *           % ProgramFlash      BinaryImage    Status     SkipWriteEnable  s 	FlashSize  
    i    (SignatureBuffer  .     0  4       + CopyBufferToDisk     pbuff      )fptr     s 	LastBlock    s 
FullBlocks   " Total    .            ! + CopyDiskToBuffer     pbuff      )fptr     s 	LastBlock    s 
FullBlocks 
  s i    ,
TempestString    " Total    *     T  X     " . VerifyFlash       Wrotebuffer    
ReadBuffer   s errors 
  r i    .         _  Y # / InitProgressBar       ProgressBar
  p i    2     <  @  f  ` n# 1 IncrementProgressBar     s CurrBlockCount    sPercentComplete  
 s
ProgressCount      ProgressBar  "           u o# 3 main     r argc      argv     )Infile   4OutfileName  Z4
InfileName   X  
VerifyFlag 
  Vs i    R)Outfile      ( 	8.00c              H&        0      H&  tflash.c          .   4   ?   F   Q   _   d   n   t                                                                           *  /  9  ?  A  C  E  R  ]  |                            -  ?  L  `  c  j  u  x                      	    $  <  T  a  k                    '  1  >  V  `  c  j  u                      $  *  5  F  W  h  n  y                          $  /  =  G  U  _                          !  .  <  B  M  Z  h  n  y                      "  1  U  X  e  o  r            	  	  H	  O	  R	  	  	  	  	  	  
  
   
  *
  9
  @
  K
  X
  i
  w
  
  
  
  
  
  
  
  
        #  )  6  <  I  O  u  |                      1  >  U  X  e  k  x  ~                      
  
  "
  ;
  H
  N
  V
  n
  
  
  
  
  
  
  
  
  
  
  
      !  .  ?  P  b  }                    	      )  /  <  B  h  k  q  x                              %  3  ;  R  `  c  j  u  |                              !  .  3  :  E  M  c                        >  _  d  j  u                   &  1  >  Y  z                      1  4  7  J  c  m  {                           $  2  S  l  v                    	        $  )  6  C  H  M  [  |                            #  D  X  y                	        *  .  2  P  g  u  x  }                            ,  M  U  c  q              	  
  +  B  P  S  X  ^  i  v  ~                  	  *  7  <  B  M  a  f  k  x                    	    $  ,  H  K  f                       <  ?  M  P  U  \  g  u                                  "  &  3  D  R  c  p  ~                              (  +  .  <  ?  D  R  _  b  g  u                                       $   '   4   9   <   F   ]   `   m   r   u   z                                    !  !  !  !  '!  1!  K!  P!  U!  X!  {!  !  !  !  !  !  !  !  !  
"  "  "  !"  &"  3"  6"  @"  H"  h"  "  "  "  "  "  "  "  "  "  #  #  #  #  E#  W#  d#  g#  n#  y#  #  #  #  #  #  #  #  #  #  $  $  $  $  7$  ]$  `$  l$  $  $  $  $  $  $   %  
%  %  %%  2%  ]%  j%  t%  %  %  %  %  %  %  %  
&  &  !&  -&  0&  =&  C&           
 !",./02<=ABCDOSTUVWadefglmnq
&'()789:;HIJKLZ^`abcdstuwxz{
 #%&)*+,-9<>?@BCFGIKLMOPRSUVXYZ\ilnoprtuxy{}~,012345?AKMWYZ[efguyz|}~

 "$%&'()+-./23689:;=?@NSUVY]^_bcfhijkmop~ 	
 "$&49:<=>?@NRSUVWXYgloqsuwx|} 	

 "%'(-/015789=?@AEFGIKNPQRTUWXY]^bdefstu	
 "#&')+-/12578;=>ADFHILNORTUXY[\_bcef
      $	   j   _Sleep    "5   __flush   4   _fflush   
   __fheap   p
   __oserr   T-   _fopen    v;   __lseek   <   __open    HA   _getenv   M   __stackavail "    _TurnOnProgrammingMode        
_TimeoutCount     _IntervalTimer    j   _DisableRtcTimer   ,   _dcnt R   _Wait    _Exit   %   _edata      -   __end (   _exit 
   __intno   @   __catox   B   __outp    H   __cxtoa    	   
___aDBexit    0   
__endstdio    RK   	__fmemcpy 
   
__amblksiz    #'   __amsg_exit   +   __NMSG_WRITE  B   
_UnlockIIC    $   _GetSmmFlags     _SetSmmFlags  l
   
__daylight       _SmcGet   
   
__lseekchk    B    __anullsize   l
   __osversion   I   __dos_commit  j
   __osver   F
   	__acfinfo 
   	__environ ,
   __sigintoff   p
   
__doserrno    &   _SendSIGNATURECommand    _Delay      %   __edata   n-   _fread    =   __read       _WriteBlock   *,   
__maperror      	   ___aDBswpflg   	   ___aDBswpchk       ___qczrinit      _ActivateFlashMode    h
   
__timezone    ,
   __nheap_desc  *   _SmcPut   x   _Ack    -   _end  ;   __sopen   B   __inp  ,   _Key  h
   __psp 5   
__flushall     J   	__aNulmul    _SendFREQUENCYCommand F   
__inittime       _SmcCmd   X
   __fac F   _clock    RH   _memcpy   ?   _strcat   @   _strcpy   C   __tzset   G   _strstr   "I   
__dos_getvect 4I   
__dos_setvect 2   
__openfile    E   
__dostotime_t    	_GetParam t    _alarm    
   ___argc   
   ___argv   
   __iob    __iob2    NI   
__dos_getdate M   __ffree   4   __ftbuf   4   __stbuf   jI   
__dos_gettime |   
_ReadBlock    \   
_ReadFlash         __EmDataSeg   
   __pnhFarHeap  *
   __sigintseg   +   	__myalloc 0N   __searchseg   1M   	__fmalloc ^,   	__farstub    	__lastiob "   _VerifyFlash  ?   
__findlast        	_rtc_regB (
   __aexit_rtn      _SendVERIFYCommand    !   _CopyDiskToBuffer k
   	__osmajor j
   	__osminor =   __cXENIXtoDOSmode    _SendERASECommand     _MsFlag   @   _atol R@   _strlen   *   	__setenvp     _PieTick  2   __getbuf  (   __FF_MSGBANNER    ~
   __citime   6   __output   )   __fptrap  J&   __astart  N   __newseg  n   _SmcWait  &    _HelpMsg     _SendEXITCommand  f
   __pspadr  d
   
__umaskval    F   __strupr  d1   __flsbuf  ,   	__dosret0 B   __fcloseall    ,   
_dummyread    B   _SendREADCommand  
   
__exitflag    C   ___tzset  `,   _fclose   V;   __close   
   __fmode   N   _remove   ,A   __itoa    n   
_SoftDelay    @
   __aseghi  B
   __aseglo  0(   __c_exit      _IoDelay      _MsDelay  0
   __lpdays      _Timeout      _PieFlag  t
   __osfile  LI   __enable  ,   
__dosretax    Q?   __incseg  
   __cflush  n
   __osmode   J   __aNlmul  RJ   __aNlrem  N   __unlink  I   __aNldiv  0   __filbuf  
   __ovlvec  
   __pgmptr  G   _memmove  (B   __commit  
   __iomode  &
   __atopsp  $-   __fsopen      	_rtc_regA |   
_TurnOnVpp    l@   _strncpy  @   _strncmp  v
   __tzname   
   __fpinit  *
   __asizds  .
   __asizeC  /
   __asizeD      __AHINCR  #   _main N'   __cinit   t0   _printf   b
   _errno       _LockIIC  )   __chkstk  @)   	__setargv j   _SendERASETIMECommand J   	__aNuldiv    
__aDBdoswp    
   	__adbgmsg 
   	__ovlflag                  _PromptError  F    _GetDosTimeSlice  >   	__growseg     	_ErrorMsg M   	__linkseg M   	__initseg 
   __child   r
   __nfile   J
   __days    (   __exit    
   __aaltstkovr  .   _fwrite   B   __ftime   K   __write   n#   _IncrementProgressBar      _ReadBuffer   L'   	__dataseg L2   	__freebuf 4    	_DebugMsg     _FileBuffer   A   
__aNahdiff    v   	__acrtmsg     
_pic2_mask        _CopyBufferToDisk"    _SendWriteEnableCommand   '   	__cintDIV T
   	__aintdiv     	_pie_flag j   _TurnOffVpp   &(   __cexit   
   _STKHQQ   (   
__ctermsub       _EnableRtcTimer   @
   	_ReadByte    _SendBLANKCHKCommand   	   ___aDBrterr      
_WriteByte       _SendWRITECommand     
_FlashMode        	__AHSHIFT )   __nullcheck   ^   _SendENTERCommand 
   	__commode     
_MINOR_VER   "    _TurnOffProgrammingMode        
_MAJOR_VER    :   _SendRESETCommand ;   __getstream      
_SoftReset    o
   	__cpumode H   
__cltoasub      ,   _BiosRtcHandler   v   
__acrtused    
   
__cfltcvt_tab +   __NMSG_TEXT   ,   __dosreturn   )   
__aNchkstk    JI   	__disable D
   	__fDosExt D   	__isindst    
_ProgramFlash #   _InitProgressBar         P         X      @  h    (  @      P      H      H        X    
   	   
                           
   
      	         	   	      
               	      `"$  kB    PcP|
  6J	
  VJt  f  j  u  KqP   f  Cx  E$
  t
  %   [jDT  kW,  k%  , `    pT   ^%p    rE  4  V_  vp     Z{  z;R   |   fL   /[/d       f  HR@
  zJB  +ը  !D=
  {#  .wd  ?R{<  }{x  ?CP  r`  ҄  aU\   !	  u"  !
  j  0h  '%  
u  `  
k  >$$  {u(   07  U<  ns>BH  DE)h  UD  O  KX  Z
  zk
=
    !    Z]ՠ  }  xo_  ǲL-\  fwl	  Z  Lc  Ϋ  <Q  
x  F3  e`  e  C   D  F  <P,
  Z

T
  J{`
  ˻|  K   |  y|  ϫ  ǲ,p  6|  uXʸ	  z"
  
ʋ(  '_  Ky  >,   6t  Z}t  `a  T0  
E0  hQ<  Q(/T  Y؛	  m*<	  	  y k@  % 
  )@  {  bH  =Cr  ۫  
"U   zD4a@    2@  	  YD
  X*1   xz#  > x     e3(	  	  0  +(  ;   aLu\  k  !`L  MՔ  (   !@  4p  &R  G  V  zj
   p  \j  f]u     ҟ0T  f  倀   vq  "  5'|  	L  mq8  Mh  u׸<   $Ը  zL8  hұu,  p  v  ~P	   ˰
  [u  H  >)H  z/XNP  yr@`  5H     j
<  1  alu   (  3֐  o
`      $`U  0  
  H|0T  k4  lj  =   0  ?(  M؛	  d
  IJ
  q
Zvl  Yh  kPH  <f(    q`  }]  		wP  ?
$  6C44|  *{`  FsҜ  xf  *g  [^D  
8
  L
  {
  |%  M  f_Ntd  }  zh  2  7˛  [
  Żt  M{L  Kz$  {  2_	   Z74  ^60  ;  vcp  0  8ݱ  	^  D
    
h  {&  g]P  !  "h  d(
  ;
{    |[  =W~  #P  T  ֋4  v|  `  8 h
  1j
:X  ]  ݻke   U-                    H  P  p  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x  x                                      H                                                                                                                                                             4     F     t   X     l          P  R      $  j          j            *  |
  n        $      @      B    n  `          @
    |  4    0      x  d    t  j  <  |               0  :      |  j    &      l	    L          ^  
    X  B    \  x         	  !    "    #  (  n#    #  T
  J&  8  '  P  #'  `  L'    N'    (    (    &(  D  0(    (  	  (  @
   )  $  )  T  )    )  h  @)  	  *    +  h  +  (  +    ,    ,    ,  H  *,  h  ^,    `,    $-  d   T-    n-    .    t0    0  
  0     d1  t  L2  	  2    2    4  p  4  (   4     "5  p  5  ,
   6  L  ;    V;  x   v;  ,  ;     <  P	  =    =  4  >    Q?    ?     ?  4  @  	  R@  T  l@  h  @  	  @    @    ,A     HA    A  (  B  
  (B  @  B    B     B    C  H  C  d  D    E    F    F  
  F  \  G  
  G    RH    H    H  <  I  p  "I    4I  <  JI    LI  D  NI    jI  t
  I     J  8
   J  L
  RJ    J  $  RK    K     M  \  M  T  1M  p  M  \  M  <  0N  h
  N  `
  N    N        H             B              H     
  &   (          `          h          	     	                   &
    (
    *
    ,
    @
  0  B
  P  D
  h  F
  L  T
    X
  ,  b
  
  d
  
  f
  `  h
  <	  j
  T  j
  (	  k
  $  l
  $
  n
  |  o
  P   p
    p
    r
    t
    
    
  |  
  
  
    
    
    
  
  
  t  
    
    
    
  
  
     
  0    |    
  
    
    
    
  8  
    
    *
    ,
    .
    /
    0
    J
    h
    l
  |  v
  
  ~
    
  <   
        `      x                          p            P     @     @                 
           0ݽ  Y     !q7d   Y     4`tp  Y     5`  Y      6ErrorMsg    z	  Y     `  Y     1W  Y     `a6  Y     @[  Y     _iobuf      ACK  Y     ]fQ  Y     "  Y     &üX  Y     pR{d  Y     {,  Y     fÀ  Y     `
  Y     BP=  Y     -s  Y     4ӊ5  Y     DcP  Y       8
ReadBuffer     
_fonexit_t     $ė=t  Y     5}   Y        pie_flag   ,   dcnt   UD  Y   
  FILE   @  Y     4TT  Y     uD  Y        MsFlag     ,  	dummyread  6P  Y     @K
  Y     `   Y      , 9BiosRtcHandler     V
$  Y     f  Y     &p   Y     HGH9$   Y      8
FileBuffer     ! wchar_t       rtc_regB      rtc_regA      	FlashMode  4p48  Y     
  Y     x
`  Y        PieFlag    $   Y     Df,  Y    &  7HelpMsg    s size_t      s Timeout     time_t      5	MINOR_VER    5	MAJOR_VER    Y     ,   Key     fpos_t     onexit_t      PieTick    
  Y     d	  Y     ?q˨  Y     pva_list    L  Y     D
8  Y     `ݱu  Y     Ľ}   Y     -4  Y     ~ٶl  Y     ^RX  Y     NB
  Y     !Qu  Y     	_onexit_t  ՞N(  Y        	pic2_mask   clock_t    Z2,	  Y      s TimeoutCount         p         0    X  x           
                    0ݽ    ACK   pR{$  t  `Cr%h  @Kx  `   hs  &p  HGH9,   KEY  `ݱu  ^R@     !q7D  % YX  6  aW~(0  !QuT    z   "ޤ  V
  L  Z2  _%@   kf'd   `t   1W   `a6   @[  {،    ;]1  { g   { W  k,  k$   ~ٶ    4`t   $T  4ӊ5d  DcP  $ė=  dT     4TT0  u"  tg@H  4p4X  
h  x
x  #  Df  4U  Dځ   DʀTp    d\  D
  Ľ}t  4`0   5`   ]fQD  -sް  5}   E4D  UD   uD  $  C<  e[4L   \    -P  ՞N   &ü4  BP=      fô  f4  ׸  ?q   NB`  ]w,                   0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  6                                                                                                                                                                                    4     F     t   X     h              R         j        j            0   *    n  H      $            B    n      d    x  @
    |  X             x          j  t   |               T   :  p    $  j     &  P         d     h      ^      T  B  0  \  4           !  D  "     #    n#     #  t                      @        &                   `     4     x     \     0                     ,          D                      OLDNAMES.LIB
CLIBCE.lib      :       T   l   t                                                $  0  <  H  T  `  h  x                              $  0  <  H  T  `  l  |                  R p   _ptrr   _cntp  _basep  
 _flagp   _file           _iobuf   
  r         
  r         p
      
         s 
      

          
      
   
        " 
      
       

      
      
       
  s     
  r    
   p  r pp 
      
     
  s    
       
  s    
  s    
       
        
          
       $
     3  
       
           
  p)
       *
  p    
    
       -
      $  s ss 
      0
  r 
  r    2
  p  P     r 
  p  !  
  p              . -               N                      &             . <              E M           - U Z     B      - b h B   
     - m r 
        - w ~ 
        -   
        -   
         -   
         -   
         -   
         -   
        -   
         -   
         -   
        -   
         -   
         -   
         -   
         -   
         - 

         - 
         - 
         - "(
         - -2
         - 7<
         - AF
         - KQ
         - V\
        - bf
        - jn        - rv        - z        -         -          -          -          -          -          -          -   
      -                  _TEXT CODE EMULATOR_TEXT CODE C_ETEXT ENDCODE EMULATOR_DATA FAR_DATA FAR_BSS FAR_BSS NULL BEGDATA _DATA DATA XIQC DATA DBDATA DATA CDATA DATA XIFB DATA XIF DATA XIFE DATA XIB DATA XI DATA XIE DATA XPB DATA XP DATA XPE DATA XCB DATA XC DATA XCE DATA XCFB DATA XCFCRT DATA XCF DATA XCFE DATA XIFCB DATA XIFU DATA XIFL DATA XIFM DATA XIFCE DATA CONST CONST HDR MSG MSG MSG PAD MSG EPAD MSG _BSS BSS XOB BSS XO BSS XOE BSS XOFB BSS XOF BSS XOFE BSS c_common BSS STACK STACK DGROUP    Y                                                                                                                                                                                                                                                                                                                                                                         tflash.c     c                #     ,        L   !     p                                      !    	       
 (        H       h      
                 $       $       #     4  $     X  %       %       %                            0       P       p                                           !       " $  !    # H       $ h      %       &       '   "    (       )       *       + <      , \      - |       .        /       0       1       2        3 <      4 P      5 d      6 |      7       8   !    9   !    :   "    ;   "    < 8      = X      > x      ?        @       A        B   !    C        D 8       E X      F h       G       H       I       J       K 	      L $	       M D	  #    N h	  %    O 	  $    P 	  $    Q 	  $    R 	      S 
      T <
      U \
  $    V 
  0    W 
  !    X 
      Y 
     %Y     'Y   D  *T0  '  )W  d  4Td     (dd     +d    -Th    .k    3m  x  NB09t              buffers = 20
files   = 15
shell   = a:\rompaq.exe /!
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        