#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTH)  - Linux-Based"
BIOS_VERSION="F.08"
FILENAME="sp31382.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  G<3<3  G<3 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  G<3=3  2   8YVU   BIN  aG<3<3   03    8DTA   BIN  WwP<3<3  Zx/3    8DTU   BIN  S<3<3  *r/3    8DTD   BIN  *tV<3<3  N/3    8DTH   BIN  MX<3<3  M/3    8DTV   BIN  &Z<3<3  k.3    8DTD   BIN  "L=3=3  N/3    8DTA   BIN  Q=3=3  Zx/3    8DTU   BIN  IR=3=3  *r/3    68DTH   BIN  {bU=3=3  M/3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZ[  `     8a             
(      C   
    \       j        m    i
      ^  8    t    	                       q    
        l  [  S  1    s"  M"  8"  !  !  !  !  ]   W   #  #   O
 O
 O
B(  )(  	(  '  '  '  '  
 
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
O
O
 O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
C  C  yC  kA  ZA  )A  #A  @  MF  GF  +F  D  D  TO
$O
O
O
O
O
O
vO
LO
.O
O
O
O
O
O
O
nO
PO
2O
 
#Q  P  P  P  P   
^  X^  G^  ?^  -^  Fa  b  :b    c	O
0O
*O
O
  .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        3ÐjDː
  F  F~ F F^z9 uvfvo'}fvfv]'~hd	h jMRPWVtj
fvvPt
hd	h jN`RP*Vtj
fvvPG
 Ð3f>^  tf6^ ؉f>  tf6 ŉj _;  Vh j7h j,h j!h  h Ïjv_h ҍ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hn F^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPhjbRPBjRRP2jBRP"j2RPj"RPj	RPj
RP⅃jRP҅jRPj
RP貅j_NFF9F}-^v&&?-t^F&&?/uF "[z=sjxtRPTjK_ZtjyURP5j,_>V   hd	h hn Pdfhfuj fh  ! hK
h>if6ffh   hK
h>,d| f6fcfF    .^
~ ^&0>^&>F~	vF  F| 9F|F= t= ujRPhj_^ZbZfh  j $^ ` ^ ujzMRP-j$^+
>R  tD  Zt( !  9  =  A  E  I jJj1fj誅   ujzRP賃j]t(b       ؎f&fjxRPij`]>P  t>R  t\  Z  L  >\ t>\ u& & & >\ u-F>T  u	>L   >L   >\ u3T Ht	HtHt8j euwjJulj?jI.>\ u?T Ht
HtHtHtIjj WȐju+jRP胂jT HHtH
Y>T  t7>N  t0flA  hlhlj~
>x tjJRP*>J  tXj \Ud  F >d >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uD:&~ tfj fj M.F  =HtkI-
 -!- - - 
tFfUw>  ~  H   6 H; ~    ߃> ~  H6 Ĵ &@u  H;~  6 Ĵ &@u   FV^& &G|&Wpfj 8Ad    F >J  t=Kd B= M- K- '-M- 0- )fjG>J  t2
j Y^ÐU
^&J&LÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ðl"n
 hhlhljmX >x2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFfFf-   f;FvfvUFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRP`UFᐃ~ b  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP蟂
	3ÐSfv
 ÐT  Vfh  P FP͂flK  Fthhlhlj>x t3^ÐFPLyBFVhd	h FP8RPhxhd	h fvRPhd xfvhd @x ^Ð  F>FK
l"nFtFhhlhlj(m*ÐU~uhd	h  Ð~ fh` j hd	h hd x[fhfu3Ðf`    
f`   ff9`sVfh   f6`fh  `f6^ u*u%f6ffh  f6^ \= uf&G
 tf6fY놐f6fY?~ uhd	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP
afh   vfh`  j f6^ $@v  WVd	~" f~ thd	h FPHv~ FPu3^_hd	h hd Yfhftj ff-   fPf6fx
f6fjFPw
f6fz~ uF.~uF6f 8Fug 8Fuh 8Ftf6fXkFPhf6fW ^_Ð~ fh  C.hd	h hd Xfhf
f`    	`bff9`sTf6ffh  f6^ X= Xf&G
 Kfh   f6`fh  `f6^ u
)t!f6f4Wfh  `^_Ðfh   vfh`  j f6^ \U     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP}
F> tjJj1j f6 P}jhd	h(      RP|
6 hK
h>     RP|
     ء` +^  &&W    f&        ؎f&       ؎&  &  FF܌VF Z   R   \   fl
S hlhljTs
>x u_>o@Z RflN  fp    FޣFܣvhhlhljy>x t>muR   hLNu~ t\   Ft
F$p*\ Ð&  VFF܌VflD vQCthhlhljx>x t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	l&lZhhlhljCx>x tjkRPu  fh  ! hK
h>zj{RPWF  @ +FHuF F^
&>TxP&*PhPj*cXF 9F}j |Ĉf<t<uhd	h2 GWÐ  += t= u%F  F~}
Fu~|3Ð Ð>Z  u#jIRPtjJRPt3ø TxP&PhPjWhtuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPJFVfFf  fPJ;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP2~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRP0Jې~  fF    fFffFȸd	~4 fffFfFfFfFf-   f;FvfvqIFVِf~qhXku2f+fFfFf~svBPƋVFVRPRIِ^_   jF "hPj
3UjRP3TFF*;s6PjRPTF*P2uTxP&
P뫐TxP&
PhPj
Tj|RPaqju,jCeRPEqjDURP5q>J  thhd j1RPmSÐ  [fh  Ohht"jMRPpjNRPpj{RPpfh  ujEF  jRPhd	hH RF~uv FF*;sPjlRPRj F*Puπ>X XujKCRPhd	h> yRjL-RPhd	hD cR>J  zt~ hd	h2 :RF 8TxP&
PhPj
SF~sF F ;FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&fRPQj F*PujDRPhd	hH hhd j)RPeQj[RPjZRPhd	hN EQÐ  3fh 'hht"jMRPnjNRPnj{RPnfh  ujEF  jwRPhd	hH PF~uv FF*;sPjDRPPjF*Pvuπ>X XujKRPhd	h> QPjLRPhd	hD ;P>J  Rt~ F 8TxP&
PhPj
PF~sF F GFF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&JRPOjF*P|uj(RPhd	hH  hhd j 
RPIOj[RPjZRPhd	hN )OÐ  F >\ ut~ thd	hV hd	hb FPrhhd	h FPKFVu3vPfh  f6^ K= s^&G
 tF  fvJO>\ u~ t	hd	hn hd	hz FPghd	h FPMKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPxB  F J.u35tF f6^ FP0F~rhd	h hd	hV *JFVtvPfh  f6^ K= s^&G
 tF  fvH~ ujRPLhd	hV j!RPLF*  F u3-txt~ thd	hV FPfj"hd	hb FPfj#BRPFPehd	h FPHIFVtvPfh  f6^ CI= s^&G
 tF  fvH~ tj$RPL90F~  F ohPj
LF  hPj LFj$;F~TxP& P܊F*PjkRPKf6^ FP0FF~s#~ t~ uTwP&
PtFPFPj%RPOK~ u~ tjjRP/KF  F f6^ FPm.~uPhd	h hd	hV GFVu3vPfh  f6^ DI= s^&G
 tF  fvFFÐUf6^ FP/Ð  F Tu3F F~s7F*Pj2RPnJf6^ FP<uhd	h2 OJhd	h hd	hn GFVtvPfh   f6^ H= s^&G
 tF  fvETxP&
P
hPj
JF hPj JFj N*;~TxP& PՐTxP&
PhPj
oJ~ uj-RPiIhd	hn j!RPQIF*  F 8u3t~ thd	hn FPbj"hd	hz FPbj#RPFPkbhd	h FPEFVtvPfh   f6^ E= s^&G
 tF  fvD~  j$QRPH:EF phPj
aIF  hPj MIFj$R;F~TxP& P܊F*PjRP#Hf6^ FPR:FF~s#~ t~ uTwP&
Pt~ tFPFPj%RPG~ u~ tjjiRPGF  F f6^ FP9u3À~uLhd	h hd	hn KDFVtvPfh   f6^ E= s^&G
 tF  fvCFÐUf6^ FPW9ÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ *;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2H>H 	H  iÐHi  ~ t	h)8FNuÐ  FjfvFP]
F FPNQVRhd	h ^Sb~uvvhd	h fv#bÃ~P|FlFFPvvhd	h fvaÐ  FPNQVRhd	h fv6bvvvhd	h FPaFPNQVRhd	h fvavvvhd	h FP}aFPFP\ÐUvRP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fvh\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j߃RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
 & FF  @
 &ğ &0߃FVRP3[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6 &Ĵ &@t2j>vjqj+jFvv^
6 &Ĵ &@ F  F j9Fu
F F  ^
6 &Ĵ &@tF vv}
 &ğ v&0݃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l
^& ܃RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjۃFVRP
X *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7ڃRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wكRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0փRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0ӃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
'
6 &Ĵ &p
ӃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0ЃRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;F}FF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FFPv~ 7
FFF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP!ÐFP>\ ut ÐU>\ uFP+ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh>FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh>vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh,?htth,?hِ }= t= ut '҃>Z  t fj h2N3  FJ1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 JSh@hP*F*P˃uFJ| j h@hP j˃]FUtKj˃hK
hd j hhlfj hG=th@hPEtÐhK
hhK
h~&Ð&ÐU~ u hK
hjhHhK
hjh7F  F~ ujFÐF Df>   F{ j h~Ahfh  ̃uF  FuF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh~Ah`j F*P̃u>X XnQfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ 2ڃfh   F*Pfh`  j f6^ uڃF*@N*1 j h~Ahj F*P5˃h~ Rfj hF: j fh  ʃhK
hd fh  ʃt"hK
hhK
h{t"fj hE
fj hl=uShPAht!h~Ahttfj hPU~ u hK
hjhhK
hjhF  F~ uj-FÐF Df>   F{ j h0DhBfh ɃuF  F+uF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh0DhjF*PRɃu>X Xnfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ ׃fh   F*Pfh`  j f6^ ׃F*@N*1 j h0DhjF*Pȃh~ Rfj hMF:  fh ?ȃhK
hd Mfh 'ȃt"hK
hhK
hɹt"gfj hE[fj hl=uhDht!h0Dht fj hÃ>J  tj htd d   1 ~ uj߃FÐF Dj <Ճud j hFh"RtF F~s3c F*1 j hFh"`FPHuFA j hFh"8he>\ utTOtM0tFj t:ohDhfj hl}=thFh"{tÐ  :1 ~ ujoރFÐF DF F~s-F*1 :j hGh@~FPFuF:A j hGh@Vh또>\ ut>Ut7j hh3fj h=thGh@tÐ  X1 ~ uj݃FÐjaӃuÐF DRd j hHh^qtF F~s3Rj F*1 Xj hHh^~FPfuFXA j hHh^Vhc>\ utTmtMNtFjt:hDhfj hl=thHh^tÐUfvhr  jF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NjOÐU*FPPKj*PKÐU*FPPKF*PjPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBjÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졞FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FP4tFPhK
hփ~ thd	h@hd	hLFP3hd	h FPUFVu3vPfh0  FPLfv4FPhK
h'ָ UՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  XhpՃh 
ufh  h j
u  7fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  Hhԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
fӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAh
  fhx AF  F~
}YhxA$PhxAj2҃hxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPh ҃m$PÐUj
ыFPh fh  	jmjыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
4ыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h
΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  
& FP輴tFPhK
hɃ~ thd	hXhd	hdFP&hd	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhK
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..`f^gef[UfS..`f^gef[UfS..`f^gfeff[UPfS..`f^Fgef[XUPfS..`f^Fgef[XUfPfS..`f^fFgfef[fX                           UfPS^tf3ff`  f.`.` "  u  $" u [fX 0!<s3P˿K
6 + r ׁľsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666
P.:bظ cP.:bۚLg  y>	uXP	 PK
 5! %b!

)&6, 

3
sx

 
&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.!Q
u' `t ``z 

b >	u 


M 

S  tX
Pu~ uF  X
uFL!_^]Ë

 
 %!;s
OO
;sEtU P>" t" P]ø Y+r
;&rQ3 V3B 22Ut
 Pt ^Ï( <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &(U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV(
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v*טÊ  UWVFG
@tG
  D
u VށD8FVD*P{|]~ tZ>PNQ!FFV~\t@PFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPPFPvvPPFPPWF_]ÐU!
t]UVWvD
t^@uZuGD
D4u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
D43ۊ\uPuuGPt\ttu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށD4tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7BFȁD4؊FG
+EEEFEيF3EGǌ^_]ÐUVWv(Pt,\t	0tuVD4D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvD4t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vD4@t^*&GPy= ^]ÐUWV3F؋O
рuGuD4t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVD3~~ uD
tV@uF96$r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr:t)ǆr4FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.6yrJuwwwxtxxxxwJu<uxxrxJuxxtxxrRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] zzz {L{T{}{{UwVW3FFv&vF
t~ }F<, <Xw$ FF.dzV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVD+FF96$r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33BK
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96$s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁD4؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVPvv&PPFPPW Pvv;u)TxPP&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFVTFPv
vVpx& V3P,^_]ÐUVIFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3K
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	`t	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5!["#%!usʻ 
FV]U_ .8tK
I	]PPR.:b؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUK
ء
F
F]XSQRK
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ1$%!3]UWVRQSP.:bۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y&;s+3UVv&L^]UVWNwi	tHԔ6		VW_^s+_;uX6	&t	;ut^Ԕt
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]            K
              4.64  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   d	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) ZC  + , @  . / F  \ ] F a b G e f jH h i jI '  K
 `  K
  D10/17/2001  O                                                                           d	 d	 d	 d	 d	0d	pd	d	d	
d	Bd	td	d	d	,d	Jd	fd	d	d	d	d	$d	Fd	fd	vd	d	d	d	d	d	d	*d	>d	fd	d	d	d	d	d	d	d	d	d	&d	.d	Pd	fd	nd	d	d	d	d	d	d	d	d	d	d	d	d	,d	>d	Pd	dd	xd	d	d	d	d	d	d	<d	\d	d	d	d	d	 	d	Z	d		d		d		d		d		d		d	
d	"
d	B
d	V
d	j
d	z
d	
d	
d	
d	
d	
d	$d	d	:d	Vd	xd	&d	d	d	fd	d	d	2d	Pd	jd	d	d	d	d	d	d	$
d	R
d	~
d	
d	
d	
d	d	 d	0d	                                  E    F    B l `K
      C    D    B l ~K
      G    H    B l K
      K    L    B l K
      M    N    B l K
      Q    R l K
      P    O n K
      I    J    R l &K
      -     1    + o DK
      V     S n bK
      *    1    ( o zK
      T    U     W   
X   
S m K
      Z    [    Y l K
      0     1    . o K
      _    ^ m K
      c     1    a o K
      g     1    e o 4K
      j     1    h o RK
      q    r    s    t     u     p l pK
               c                           _C_FILE_INFO=                                                         K
               
	
\ \                                  YK
  YK
                                                                                                                                                                                                                                                                                                                                                                                                                                             (K
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          ccccccc               (((((                  H                                                                                                                                                                                              bbb                  kK
K
K
K
K
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                ABSOLUTEU)CompuTrace V80.817' \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      w OPO WWUPX!	l;WO &f`a UVW~
3vNWXZ_^]
 !d~#^"!B @WWVX''K
u".H?t2`1_r <ar<zw$ߓ&G+tM!OoF	f%}UoV%FUrsk	rHY1 _#+mfo>c3ɊF0r	wk
`xnW^`~f	E	p	G_w<Wf  79nGKvEA\Gunc^|mRs,eު+74YD07v5|"Fk- t^- tt
_^tuJ~tu>D9/u6]yUu,}7
W t}v3^_sE+}Ff;fOs)GC*#D'^4
Fm	[/Pj>3PtlXȷ;NFPr	+snV
D/Cvs)/sam
MEPW*
^3vNrM[a j$
F¶{t
j 5M4ON<H{k{V,u<=t MF u7-]
q#ÅۺP(t~vI<k
';Φ֧h0Dj3T#httF|#8S
P,
vShD&hm?+et!NAQǶhnni+r	 s)!Ͻ
J|8@oduI |F# JٚFu
\Dll
vlyT8vnFiDLGgtV;{hR"L2fRf9nKt8av$'WF	hD;߄P`EdPK?]lt\\s=Fh
{CMv?(|etsRPز'sJd!!jhxDh&PY+|:43tf6s&GO@`)Vjn8x,wtt[V
lj$8^8#A\mUdF^LKrCusuu]ᆗ'"umDVOf2Zqv;/ ۹th.Jyͤ"	lwM 
>_lκP+' i;iL':,;v5=`k1 +G
jPx :	4VI|x-aEuF+Fv*"E-$1[/@sPm|Cjd`A먉Dl}l'VL5QTY5:hh>JrkE,|le!#cEB&\Dr0۠,D$\ 1S\^F:cӄ`R6?5u89o$t<(d?puBc[X|. {k]+$΋	Aw84WB.YGRԊwno|:hAX:BV37xT!I]BtR0<	D(PP(&FMn+"iW	(-zk58V[aBf)eZPPϾk~	9	^XR0#8D>W_fEK8}Il
) ͖ w uh&j moF r}DWkkpض U[f%޲Tltv
o"d[B)H/RPSo$W%,1@][.	 Vu=Gvamk	\XUbLL-N]$gfñf!R
`	 \ݚD2.%ǳhM;-ȉNl48w@M3QNQV[[q9(v*krۙl7V{Nw7~*
9s7W1-TO;v)
P0g0H6['FB'O,*9X[O
o wqw 	6ڀ$+ak|(lվ+07G2$^ oΆP)
yl{ur8R7g)R`6ݓ;µ9_~FgF	f5pa.+
_uE$0ݶ(4
 5dUhڦ
$c\JeV@br%H
D"T"6R;"\BM,zIo%f blUuAW<D, v>oyrbX}C&lo6P%^GlLАf:р{L7H^29BS9PujJ^'ݷ e\كh
56䆩4@3k}f'
bdn5+~u&Ǯ
F*.qٱ(/|(v,lafl4]F
-snm9Wt\Z)#D٢ ml{BHn,H`}F^-EV9A
oEm	
@'E^^>+-VO @\y;V
BGG=2NzI'\:a+Mɦ\D?'f
^u_\t F)b`"9Gted7ORu<"GH#FD^ô9ǜfHm#{$7#H;f`NWY9(U*PMMu"`,.Հ$E(Jw W/~rEBJIxjZ[/7[	lG7pU$<u@(O@t.%?/	WFN;up	8n[AEFT۞Pط`:Ā
J^k(d7gM$&	(
" 7;fJƅ6/,nkJHpoq=`ogn\t?<R/;u/}.GV$'U@!ƾF+|~+= 4r3K'] e v&ouyw|, Jxpir{@KFeI@x3};u;VCX@ddfjt-'	CC+wtT
3śa]ht3+Kz H8$tkN;9tkND7EG7-~Y-\o=c0Ku:R8*tAtD<\ݮu/e,*$V t
.6-7L;Í8V -TVٖZZX%Xa&IwO2-S3vѺn9;0"HP
.0ܝ2#wR
L,POd$ly %^o.O,̐1_|RO\߱ -Z[9 cu"߮5U#VV!q>U
GXy,[!bHBW~eJuVBX!`3m~-:=Wt@qG0-DRIG!H;޵%*vu'e+]O@FGupԗ/Q|$)iҪ8
CK:QX7{,fbl&<j0ڢfn{#MfU<	]ܭveetV;
;jGr%V${ĔD,G$/
>}W	G@
Bٲpr,
* w&j Ht 74vk=
826DO\upDH	@N#
YҋoL,
gCD(諏+,HDphk-%#ΞJ- #bbT#:9j2VE=MWC|b$-B@q ]۞xئtOw"Nds Nxq5"U2wƾlKAUoDA= w(.bM6 03L<9 ܴ齝5ennN+@1]t<=|@	LB
;
uaV?8=C:76?+1+$|$S}γ6. d+
{;~fc.
j.ް2>KCvGR76U+zpc@5섨	 ]]m1dRb
Yt9S:g
ɾIKiG6g0
R5l
 5VKf!o~O#<o@fP%ep%?0Nn ŁgWl8#IjoWUON~k
*q(>~Ҷm	4?5wE'uQK@B囙b4<ܤF6P(9	VtIV%ƠjhCڝЦa#VƄJ|!Bթc~۹GFR?(* A9*F Z囋EPR
jZIzNl~CuF~BQ	ke]Խ }F 
V
=K%Э"dN!uNI?Ff
Q("`Q,1o{̓T>({BNVz/8%RV0FFG;wD9`HD/5].JpxG4;ueHLQp?(:W&];t K)o	}Zu|]"g| u&>FtW{ѫD _LuM&8S"+Ҕ0c4ԊXЖ틃`ffw1Mf9G8r,v7' ,hRZA:	Ձ¹-}f'O@B;!xc떼پ$NQ\|a該>fNEv3Fy'^8!źī`tDD>&OGN=Qw-z1K(6$XF<>j0!$)K Z:A>$bQ#)yW"w'
9Uu>s65 rwS2rr$vz!Tx86;pL)xtd+PbJVY*GVУc?LK/aA*l.	tT)1{L R@r@И ,Rj6`~D;4G3
X`sd
 μfp40cR
;
feI-?m܇3(4n@@ %.=P@4%niaPWh A 5ͶAL2tHo{ 継OP;f#ǳt -itζ),lXwF&5z;vvK!+UFa;WKn
mjԓ=Wb6]S5PFVuiI`&v!G2k&GuF	%ٶk/ڎMQf\
jι@|$_Tun/HHl}w6E{q<x
WO'VgXNkHm9w!<y;cuf.P(Gݩ2ȁ0ݲpT7jxශB;tj
s)^fQ.ll%(2%j0VV][8l2Ȉ
`oVW-p0ɵ81sZY&_tV|i2[
Z,)sZ|j :Z\Z
oR u2Vc)6Υ Zޠo 9RuHuC2QP/Ԯ=)bӹ{UV7N8;q('ҿ;vVNQV,J
)*L( af3-M1!W,IĐ}'u!xw6>WG;0W;	DHiY$T1V✁s@? t"mo=jDG+=
t
Ejht]S7DNPn (p/L+baAk!ưfO<9TV9sD#܋ڃýێ+¿mk Th<3<R"	.fR,i yqW208zͯ!x'8sW	Yz٫a1d#ma4 B1WvfP"F(t3l4;5;%uuV۝RR1-Ŋ|걱45|P0 \9"@ò$x^;bϢrD
kP	ԉW8^E(VzSL|ηew v^	w|o亅ÒDrM"CP4)bԻVj1)`fhZV?n-9dK}wrr@wk(5(,gmsy}XGC#:<iR4,Hs0&E-K*KXXYrIWVrê	>2=$j\܇DwDpZԆ=Cʧ}N&'0L$3]&NG?5qRZxޞ5	bAuS.+<`_^Yu-.P)Nj%p{8W[!?W@)^r
AQtu0D#]|7 ei__+;ʾr;r6X\qoBs6.#ԵVDIz
S*(6 CXl BWs(x RV"$!577pwz.Tss+;(FfG^w+ƶ%!zM؛_V#i T8дU#^%}'YjkV-dc7
^~fA5Z60בm"L5@ Xtk@7GJw;cG
RֶPLNH@.H[zLJjDDt:
FR@B[Ǳ
r+,L/x\w%4B&j nG${L?,ry޶Td W"2YV(yWDF?9ZHTJlo<>Z+D3EA/P=9kD6fgIͮl@4HFCFD&Rz&,v%V]Ci=NU٪)G6t18N
]6	:p$}9&:Z?M..ʍ9!<GtĂ^s[ȡSW0l(WRVv[%'t)zYAQVϙ=6 Np5[PL *
*թHE4ޖ:
&|hS2ۃ4 ǣxHztl	{,I@rf*^Ww0V+] &kl@и5P!yܠXu
 V`np`,S
1DV/q8"b&6thQf! %F$Vz&p,+V)&PWU$zGL%/2uvW #"AD#)h?$!oa!V;U"26l	
	/]!vLcDrր,'=ca6,0]hP5J@ٸ#b	%l
`px=3з5R[2wp$bD
}xIazDg]k&;Tp,$\&KDVc/8׈8`!\ ri&@b-N_ck4 sFJ dܬ
D/ùf;FD7`nmUOxUJ 18leT.R
xtRu`;EiP
>q{R~	N٧	k4oE(Dz4t
,AIVhOr[
r&wvrN H;+pTH@jY͉CaACC:z	"=t(4(<r>2p22I_`|GGx:9|%ff5+t+Wl!rRLCOwMcBczrܾDvwbF*DTfЊct{H+6/xFgd0H$|\
	a/{?,jco`
(P	9
0y6Vl@AupiC
^X-NTsнT@
'&0~8 ؓ3l!+	&lbmVl
UۍD)QxLdQwp)wȸҥ2f|<Q?,MvY_!XT,+v^,.:?:SNp_btNf[ug5P0',x_TZ*`6e	o>OT+NBF;s>}v;s,)N-fP4CVi:"[%,dOF{)&8thY%`W"f#&p@Xu<R)ǌS8C&
%
N"05pl-=Hdd.6?AUTOCHK.EXE )rdisk( partivon
 mul	\MSDOS.SYSSystem32 $I30WinBootDir}cBOW.INI}%tK Menu/rogramsYk{}BAK^8-ެrpcnetp.exeo&&ړ&MZcTmPK@1I(ǻOǶ$ǷǴ/RichSPEL wC/ s$`]  l'e&+dW(P  d<.tt_na#`.daKݰ
.cu(D0`'mtsR`'rel7oc'%MV";B  i(G
*i4DiRbli=Z

4_2Dt7	R \??\C:/8R#5	:\] %%l, o\Regi-ry\XMachi&-ur+ntC[{olSEUervices ?Local Obj+ectNhKImagePeh TypEGo`rF {G : 9]Iathl@ d7$lVo+SVfEeE9EEdÀެ,V]YO=P. N3V"jhn7V#kPhCyPǕu	@ma C{{|+E5ۜ940Q3ud,m@f#(ZŷRt/܋@-)e  MH{k{ ;{
k2MI-A3"H
A@ۭ8ۃ}
t'on!)͹8w?m]_^[:|N葶F8ػo> t*3pG4`P+L4aR@fJbAFE1#8w*H_K##@|(dWj8)N)af;Y-YC̒WWfWI}ɗ}}b囅[9=	
VVx=
t}SNQ	W	PSPpWvM)p@f86r,	9>u9~u[dM>LS <Pj2> (GnR	GlX4;!%Q&yTY2Ij)OYY,34-+[uj0(g
j.?;+K NWCZ0+L9}V#9ۊ	0VLd v>}Cs(}f3^d	
%0((8$S[o8UF}Wo?  ''=o	O첰$qMeLav4Ӟ(n86:vWP
QJ`u6);S̠% mMR׬W/1BB"*xX X .+<dQfljhoJ|Mn>6Mc[=֨LqYB>
^`Ë"7 ᵝ9|]4 9DH|o N
eFilrwcscatRtlQuyEn
nme{Viab(}_U c9ns4CDelelRRd
F69lKKey |archr nInitUcoden
\ng%ٓs[/P?TmkkaskW.rupy\WSmOw-d_tdll. 
j9z>9,b9~<9?9"#9#0s v 6
#$-PoX]wwFT>d~ p  8'HL\%56=3T:|S<`r<&Gp'H@Y@*HfiziКvA4.@VMj~44MeBi.FTf~iiĚiC4&2DMT`v44Me Di0<R`inzD]w46MEM&84JZE7):ssE -0oLXgagIi.0U\-Lgth: %d
%ss
xsvMoIcoftwav\MsM
\W;ovwsVos\Apsp mi>pkFI~rnA۰ x\&o\.b}bQ^͝DfRm_j_ܝm{hF#tTX5/Ac{D]AvaXثkHaÃ+0*?[Add.qLH5=cln;AKOpMozioa/4.0 (cow͈; MpSIE 6;)a/OSTǀ7OwSREA#./''K((..0//</^K.b˙!!""+&/&./HLKJ@Nz9H~`n _*K$h@6}c`eZ/AHwoD)f[G@
=Ke7zAvjaH#ljlT6HujWqRֽLPbտn3 n͔ Y̠(uS_䷻+xZ;cF9'ouva+ȹQ:snpnxlmF7O9]ev uVQLжύQPL+Tg0RP(uk֙xOtj
,n	_N"(w0w۹vn/KYhׁ	`\MQ5R/:-9{,"h0[9О8 xYѫgeYEⶑVSiW9.$WVx<hb	I~8KlC`a7QQWjl8LhJPlM#(جAw@?tmWhPg:
D N2 hdD.A@@=mL|toj[S^  #'t< xNVP'hXlHp7~gl3,'j4-XQh=<t
$u$|$Sw
hP&d&no^ް
` ,0>V}WS53չH+}na}Ы]9\t0C .S
,NM+ⓞek=]\]@	`,:_kcM4V~xza%gܖB%m7\ \%Giv	aQUV
3E}6i)yHDQ{E	$*vb-(	.;ƣ1
0ň8/$ yVzE=x&dh5_2o~%@#5_8k[uuÿ35<Q~t^l4h
u	*c`Uy_n[^]Yi('3G}ĉ'l\btB4;:jD_Ey64af:}6w!,׳z9*
|2lx )4	A'z H˸c *dhd d:{c^oCle7S0olt,>%d20dvtz@V0ayoV<Fwp4$fu:0t?ldHX=7H@y"954Ou\P88,76;~6M*0:9/P?McƁXwk6^u

8zoWtt	j(hXi@6̈5AA֣"]h_&R|	Ԫ|rW0`VUZ/	Dnl|mtċcF<<@hPdP8oYY'1vD\P^ea0j,YV:bA
+EXp'\syA
lh 6NEi`m7SU\}9P=tbUy
VMowk-#;t`B@V=X(V>4c.} W@(aF;tmDu9xNƛ=)(;Ò]'$MgZtbۂS )wPSzSͷl*YJj֐^'֓Soސ9\6טJx\l][uo=,6>|Bt(؞o":7u]¸3l]"J|W}]P}+4o,
[o3ר@m\t;u"PRCVPtT\)*,ZEbn_d g t JIRmzl1W$LLbf<dlma =@s>
*@w<8 F洁tB.[w9u9'ހW?xhƭ!fT[&tku*peFlƶU]H%3E%Bm#pv[d&/FxPQfuQG-\Mm##7`@&fuhI:**PZ_<DNHH[Eޙ¯l-oE-uqb
W
r07dujdp3=4x4Vٖ45$ TAmivpiǂ4d/*((68N`vP2TS z;jjZܸPt:kP@SKLtujHa1tEL;/X;l8`.R8ĨK '<v(!
P	ɈH'VuG9G_su%A*?AAVބprU,E;E#P@@Cوpklh"rP<	pAC=;E7K'K¸ݡ'+m `~$	̀8g609	EF$\(0L,$8/Ho9u-e8T0ֈ]*mp lQlؚgXE;o޲[*~Zm5HV CSV}z~TVk\D nO9^ht3ۣި܆X$x苙&ۜ	89Cu^G4( ہvS$ǃcF %pk/MrV$RhR^\pT,cDW%p2`i&5l{ f't
Aη̤ى=2D + 	%G
7Aôm4.k|@Fo24Wv4M&޾t&c(r<?G|Fc7#^4JxZU
S#?vnQV􈑾F@YWh`$Ke|v
ahh[h}(=i;T$hH 2A>c<I88su 0IbXZh~bdђ`w9c`?pt<Ťf	.cª@@pY|hfp&da
q=d(|h0W5
fPm);Yru`P9̺1X5d\[۠!0xE(J3-u	췉t`ATqõ2pޟ3ĪDF@	K^B?xYN]iW(0s	XW	!Vw<bWzHMP94~sF,s9(Jh=L0C@3ҋ~JHN0N<v8Dr[Qw_H^DHޢf,0 HP	K
V̎xA~y
; 6)sLў+ .|$Kw+WVn4:Coq
^F2\Ɓ	б%f:$aw[Jwjp(qIVA<V׀ ۿ<"%Vj3jBDX\(W/`xG@@Ft
]NH>1
|*w~ 37+j ڳ0_A"@[G[s0:2|t
S^BY;os6|DD#G	&N;6)!Vo"CNb_!q1 L-]Q	PAҥu	܉#ɋT%+ 4Z[c
0mۉ1DuJo>DNd`!@\pp_9VD6[x0@KNHj	n0Ve};wu_  \jH$wX]zqaf{{<t{4Plf(KVtkg6Q;-3:aP=]ujXf{aq^l>D什8@X.UM߲mvk(H+ͬh;u	cZmjp!q־<QYm(;Wҝs<HKt A0^tilNpNYlS^XPw.+>ZP,b[WW#^tjFl
۽<x:0 C3s	6Q.xQBAuSFp?xWE5g&
@8]-tXN!LpAE,|c~焢p tQ'R9RQR4I@I

]ˈy> Z-v'MnpSwX}|P@ j-{K
Wt51Mtf6x#(
M7 0|[pVp^Yrp'>Fh}Zhcg;b;N	gD^8K[;Ծx720s<U{$Aǧ{XJpeuPف7n:rƴSِLTo[Èj-8@׮rwN`D6$j13(yr{(D^xbdИ;|A
X9${{hJ2Aoh.rekA@1?A
,װu4-;&OcV l
a	&'f4KW <
t<
)<<XwD
x9=1&B4V^hj8CYh::̀Ō )N)!cu4ՀJDy>,
	ɂ$n*޾ ڋn'<@j~@_>Q9%tYfϵhG'M:N7w"-'1],0{.|5 Ptc845SIf:x.ǽ\8֠FA6BWl0^m}(HC坷tSo<<ȋ+Ѓ9KUB*K*߁Ї"MJgLRa)ޝ&-%؀	`"OS#6q+A5Ȱ{(zV;KPBg<HJ[6%UW$!U}v@=tVP@GJIӃ'D>Ӌ\Ul][cZh|Dn$Vt
ՠduP0>.j=$x [
A!G 5Wu]چcB7@KYbW7fR؊3э
@CQ9 3pYd4XF@ ;| +7'oϤha4ȡ	sX$L(ՋCR(2p4T.&YRj uS`1zt5}ITm,vCM>wr
C~^N :tuKKF7Ei`?$p-2D)GV!K+=	M
 )W.kVOUj4h_>lȨKDPEJT+ԬeI[в^>uݭvBOk f?DJo
@jmAPh|(UR݀~%@z;9<>T7s9JPhuOGo}+ L6
!#pуw$Q:jpRQG>kSK9
HK<-V
u7"O 3
[{
f$ݮș;˓uG:	F:;x96M :Y`
<΃/D9XNkaZ
+QHP
Q܄	KfuV@@A)=Bt(JRt
0]0f~ιpf:,
ۿhfV2sf!uh:o
^j~qmJd;u;}q?tbr;_/k	h;5\Wv@	xsj}g[  G9n|Ѱ~<956nGپeDV<CdlE|FH	
ӍY\7x4}tIuB;27фt /*e2IUtB;}
5ZW|{~3 ]-5zK]2f+x%À
w8~w
}}-}rhTwwbYH])	D4[
mS}_4	L8}t%Gᜰ8*t<.];ڞ;2^\0!T	 , ~mm PrGې\1VO;bP}O;|Ԋ.x?dtSO<*6vUWtFܱtٹn+|N,}pÑԬF]S~BKD~I@UO̸>eAXYD8^?nE\6z@*UTb
ExZCtrlQr?ڀD+]ch	̈TokV1e/n;tu_1 `)AsUs>;+;76$upl>0m-)Enum|l
Z

uPi⿀ADPI32{wGs}Modu܇۶iuZA!ZodImohd;SviaK"dO'd`c*MRrsMvT	sVg$
Y{)3O7mapdlBiL a%;IPye[yuJr y EК-vlc֛Q؇a5
pkGL7)0Ii'I$AǄ*S'/M+kA Gj} lr8i FrLibraflCz Ȁ>w!tP-ʲe!c`lHo$]kAcl}$B)p-w0S:R1amF'M4pFbJu:-PVB<DOatט%oreft**zI^#==]ZW	6uO,9m	SƈBTkzh=k)c NEIKKERNEL{>PBz
M8V!@e/BKFTiwTrqslB0 	:.6aOl+i$=7P wpkfA|E*+uQfݝPeek/ /US1kMOCK%l E¹EyEiEE!d[ #r(!@^Rb	,647|ih`ȯŇ1:&:7@
*d`u;Q
] FhGdĢݛ̛؝
iH9 @`M-K3+(8`#  ^  Jw|113333333334334444$4(4 84D4H4P4T4\4`4s44L55566?7x7}777777778$8X8m8v888888;9C9999999::::0:?:Y:a:g:m:y:::::::::::5;;;;<B<i<<<<<<<=-=3=E=L=^=z======%>4>G>O>T>`>k>z>>>>>>>>???%?0?8?E?M?p?i??? fD0"0+0<0T00000011l1{11122)2:2B2I2O2`2k2r2x22222223333%3+313>3dS3k33333/@333334\44!4'4,4E4d4mcy44444444444ӎ5[5e5/}555555555666%6I6V6y666666$7,737]7777778)888899999 :::::::(;4;g;;<<<.=C=O=V=d==>'>S>[>{>>>>>???F'00n0006111
//282AZ2w222)22333+'O3bi)s33o8&4Fw=5u556=O6T6nw666!7h7p7u7{7777777%888]99;:Q:Ui]kex:imq:;A'00 408@0D0H0L0PX000k -P111142@2H2U2^2?3H4^4445555 6&6;6xS666677 7'7؂XDH(0P Q    $ : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                       p   `      POST  f   f.V .X <  
 f.d ` j  I     '       Δ    POST6 d , N ʪ ] ~ J Δ	 w
 +  +
  , +  ] +    6 6 66 }6   ~ ǔ x rz dy  ! " Y.# 0$ /% & ~' R( h) ܄*	+ , - <. g;/ ]0 1  42 3 >4 )5 6 ~7 P8 x9 /:  ; /< Ԫ= W0> ? 2@ /A '^B .^C 0D ~E F yG H I A+J ]K L +M zN 6O +P ҪQ R ;.S T +0U DV W X ,Y@Z `
[ }x\ ]] 9^ K_ D` a b ]c f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ h@O [X /<t
PW f&E1_X  PRWfQ
u5p 
(t'SBff  u߿ h8ufY_ZXSQW< s13
 ht3_Y[ABCDEx} UfPfSfRVWf
fFf^fNfVЎ.< t ~.FuN._^fZf[OfXQ	

_@
		! &
%3
> h43hp  O  t  Ãu
.*u	uc/bG RPVFI` u tk@.9tމ^~u t/ t^6
5
^XfQW~
 
 _fP8
VA/r#Lt<
tw
u!ο 	*ظ?_^p	9~!QfWfV*]0#)6S
F f[tҋ3ff^ff[f`~K.fa9 D7fVWUD t w f`h2%3 tkfAh6 Px'Q2C7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^ Cf`Sfff@=_ hR3>+f;r[?C Wp
,2h_
 WX
_: r
gN1
gNCr @99 \!BWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_qBU/tg^H2N@?" :h fΑR   둡4]P]QRWV^NV vq6Q3qI4GYlGʫΕI^_Z!3Q'M0 pC8 YfWV3f_f"1*IIfPS.  .*Fo*  f*d^E
N~u_!pY*O.  
 GfQQVRaQR?
yO2ۊ~fl޲k:P`?tWufx f.*<ftf!f.@# ^@
uF8Fuf_ZBfX^ÑGVR.>*s$0q	.k6*.*K

ǀZFH^PnĻ2
F0*FPPv2P1N~ t4vf2f:10~`FNNI.*$UfVTQhnrrLS  rDCg h#߾ @ N   gf  P^ 5g`UF]|QZ6  
fvhU~uF F 73hF3pZ_wYH	h^y rPD(gf 
  #fRS 𒑾N&t
[fvԹ tNhCHtDs  hU/ 3hkRBFv ~&#3
Pf~wfXf {  @
>tq  tgfNg A	~t-F  ΁ 3
[P3yhk~F t~y2h#ÿFf3ҲZhҩFFf;FuU-043 + 
 CQ|Au@(.;*s00~ ˁ ;u
t`3t@Ѵ d^rf(  _^ZY WQ3.>*2 .ǅ0.ƅ2 ` P@hX.* .`$S ~3.*hCs ЛZN [pwFk@"~ 
N~f.4=6@.82ɠJ0[t,9u4.B4f<tرf5$< F.
 
1q_V@~r0F F`! Lru~w
`M~f1Q/ t
fNu?
ffs NF^PSR 4P*Q:
Vq4F$<u&VF ># ~$wp` :O.ph {?<u{8^`V@g*@{..*g*^V0&0
9t@ރ-2ۿx@2
E/^s[ 65ӈ^35#7uBX:NкuP:
t3S9)ˁ6u={8N0_^WSVR`rfn*v[:!ffARffTЀ`2ff
wf;w
?2#ofPRf@qPt#f3!f_D`XfffNL$ss4
tu+q%
u	A^aJfـf^Z6Waf VӉ^~K"8uffFՋN_QcV@vb!F;pI:3ϋ~+c:sRVRfQ_;Fxu p? kv@kF:`b~:$$@K:@3frD ` w;=< u  r,.;D$<{u r? sh@BvFfcYZ4VWӢ Юfq~URd
t"t?tQ @޳DvP Ǉ}Pkq9SV0޾ T3; t	 r^[p@k T`#Aq[%Sx^Y@j8*pt@;v7qBtk~@st 1;FtFk^% Bk^ Ta 3҃  V3k`[
C*䊁"T;FuR*3]0t7_t-k	9	# a
@S
+FHu
4uGrvFvVBs0;~HVW΂tS03ދ[^NuVp _3ҋ0_&9>1-x4Dr<2<}lF8kHȀ=BHP9뷋A*g7oZ Q&0V_  ~u1|\΍0PN~ tKv0YFQI.Qz$ x
fpO3g~ FfN@P@ 
0K SQh*	 \P,Q23If.` tf.&!. .8*tьL$QVW
τfvF%p"`F^^F  FψF
fgFF Vkeb"^`LY`!ɱ ``NҰ tFt'fy`e 9Fv@f0
FfH yQrZրi`bԁabfC<4R^VFъF8F^ǿ  pQ0U" R$ S&T(T,ܙUtN!!fsШtE rtsCA9FvG 3r%if.*N  `N0ƺ3 
t
F%  .pO c>eF~ tf'iz e{u
 v@aQI8t%  vu Yw  vfIft'fAff#a 'fp=rSF.6  G                                                                                                                                                                                                                                                            o  PQRa&hk@ $`Ȱ hDrZYXSQWa$a$a  h4Bo h >5_Y[2揺 TCA6  @A Q C@@ @;uYð!$p h)Ē
f`  訕 hFf4ٿgf&P ސ  fa.eo1h
 
}
htsfPfW@&'_fX`k
0h	/t%1hkU\c   &  @bQ0@ ؀  >N&}uu hUb!3d 
  % XWHq-e&$@#h<ff
qÀtf%af5hCߕst h>*,Ⱥ: @p 3ȰS, @unSh3.h̄ XC P
V0	
` ܹ 
h2b2p!úvû   P0I"E" f4%  0BHT12X21-220LTN121XJ-L03 4IAXG02C41L{TDEC5V=        . . P . .
 P f`O  3.3ۃOu+Y/.q73ɊOt
w/r3_ø{ h99]   й `U;aP hc5}`8 h#>? t
  Q`? @ PQ= `t
3f3	@fYX _Tðd`Jd  UP@VkXu 'GA(F  q<
Et&؁W uM9NwN#uӃ~ t"F= wt%   +gYXh:T`.e1   !	 pQ a `( u2hpY"e08t*8u{ ebTuraQVtPRfZX\ +~f./~ A[f` f   ƐQ_n!$fSfQfRfa  fq%=uf?a2 ffZfYf[^SQRfWf_Z [hD<4g`h{!Tf  Qf3@`aOZ	 12(_2r)@{03/s0߿ hSufbr舟s  T{q
UlNlfa't5<t1(qf sb@   B<  C< $ #V Q R ST U VW	X YZf>7RVW3 -)D0*
` yAtqft߃R`mRff_^ZY#4 Q   Q tc4TC4nc4NC4oV< f`Ȏ.! 	-441UUB4+G;rU4rܰG
}ŜfaBS    >  A  T l M e M A@  9 Y .    nG SA =qbg (
  `Z  +Z{!`[0RD2 P f5π!P^65fo6\5 ?  3 p" 6P5>xI.h8cPS㙻 $<t4r [X)  Ѝˋh63  a f`4 S  y)6h3%$ohDBd  D 3y "r< tfF21?2"2iR1n 󤾔10r01 r%@10&5&D&ENJ1A@)`
ph p߿1~pt%vr/2V2~_^ 
8
3
~3
A2^{
1b s0QO2f&@ U$=u&M2f= =u X&]2&[2&Y2y
, fgh  0 pqr  <ABCDE xyz{|}   )dV S#
fp@nq8 r&2&28 r
&  ^ 8x" 2srfXfCf  vf5f]x&V3
Ê^`0(.'t%.FuN.PW)s1 _XWfVUSWSQ,fvT  ޿R6U~2V2ك!IN܀3d	^
u
t_NA&>0_[]f^_ PV&=;u&&4u&^P
P<q +&~& 1E&DpaSV h@r^[þ:ݹ`[WfPFhS@ȁ  <fX_v^F10=ROM Based Setup  Entering0;`. u  3; Kt.0;@@Su )!`- W  Y;p 1A	A0; ^11;qFruKp &0;tF  et
.>M.&Ot
(*At hCPXh?Ӳ{F12=Networkrvice BootWake On LANAttemptto %  /ht8 0<w r	 A<u <1YJ	t 9tsR QP.<$<0,( <ITBՁ"<! ds@C	%25ؾO~^Ps _E%[ VRyoOlNF N3؁N?	uCFG~N0tGhջaN<vshZ^òP*Notebook hard drive MultiBay"Dock!:b<#b (top)bottom)leftf	Floppk  USBCD-!F HDis/SuperNIC*
!123                         d@mP  	 
@A
6P T r @ծصpqlectZDeb]̹  ͹U8 and _mo@=the highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   VBlB(B$P B'?C;S A;Zip.F`up
 d0ô0.CӍ*tԎ(C? A VN3N؊' tA<v<st1HB& 2ٍ>2}d@Q#YAr	 x? P ;A.DB
*о}FB @FB+jjj(Pj'=  C `DBB z  
  Ca R 2җ
   t03HB2Ɋ lF8tFޣhN $ Zbqq~p URVQ.,.L.T^Y^Z]S,.FB*[ݡQSVW/ s&Q#C.<.-00?00.Y_^[YQrB u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰw`;2҂ Xʱ@
DBBBr
;w2p=DBJơ}gFYô.*FB<u2K0>fht푗 h4h7d hb<uɿ`B /J qWo rf.>F5߿ hSӿfgf&G, @ f   PG0f@G,`u
hEt~G,f",f_ffP QW2_Yf= TKSt0fXbo    ? o  J{  b؁hF5p.
W
g&Fg&Fg&F"t7g&F0a 1 2H޾G׎Ǎ~ؾ:{ rsG	 k  QRVDTQF r&e^ZYGffL (]Lр߃Y`VUfQWo
ِx
K&@
C' C$C$0Grx  q## r]"0tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ!$&C"u#%$u!#,wABM  f.IPS [XAu.6If.IIDNU.ISfVs#CP #^3%%Ýf@	~3u
u\r5u!q!} "@*W3 hq^ **hhv3p%5cf_ ]`= vH ߀O1H aP hk"$@<@X~7O4pJPR ?ZX@ P.>J t.J.J@aD5SQRWh@r_Z>P TC r99 r/ u t t@XR1$tutZ 2 WW$? f3hcXRISWQR Zuʀ[Ppq4B XZY_U*uu} N[ѿ< @3ɹ2 uhXDp#qX)¼ P% = @uX%*4g&@MaHIWfWi	t<f_!Qfpyf  g&?t9g`\R%fl @!a  f%?fa#   f@%ofQ
<tf  f< !pf QaadZY0a$fVL/
/]GP@t


 
"
f^ff? wD uPfe%@~
X!
kyfm7H3ۄ4r H5 0P@p <8]	12 P` E Ј^" LP@p`a L`	P  	`iw  ZDD( Actf &_3&[3@0Sf0'B!(ut uf_*]s cŃ>_3 tuc ~rh^
&h3p@C<ths}v3  G01?}4 Q < t&3Gf&
t3f30 2ɴ*f&_3 uf
ffKP4&4&4fCZ04*#+[3p45RfVWfC3ffCf[fKfS܃fF0r0а K I+r{x2_;Zf5SQVWϾ u3n_^ 	!BKsV 
R3
t<^f~
w/vQ0fkd`dfft@`[^ɳШVQWfv hU-F&4F&p & &P&&{0&۠&&}߀&4q^}PUȡf   rGt >`*:ߨu
P0xhgbX`aĊ؀adf]PRaQ  hUgjjj%jG PRϴ	Pu hJ
v~  h=s5ú  O hᓐp (ϲ t 	2se f/U ffff>+U?fh Ug&; [ua)f)Pf0g&t` b   ttx3srnfǂB 0E 	~/u΀~/t a	~;8UtM!ܤ6O                                                               TfU.&U*UWu u[rWJrR-rM*Utf0fqP| @Wb t#r"t p ; }PJR  ZR f]LCqfUr*6@^  R Z0rG	0KuҰo!!Vg&fFfF?f^@e rC\A `3ۿYyg&8E tEG SBWiWm r`W>/UptҍmN8lql0hѥcʰW rt r
 GC_RZt$ؤÚb$]0WP谠  _W}  s?p  aͰ #`P
@S P  	ð D v Sذ8 ÿ3 e R	$#Ψ
R'
Ȝ//QWjuptPX_Yù
 do h<sxusz
ՏP .<u.uĀ qRRaR522hX?< uZ#ȴ$ t	J  U
	a!|"9Vf @pN`u^h7[à{haӫhr$.4/h Kh~".uva { r PQW 0> 3_YX
h
aC=NF x=#h`4s	> kDð   ! $!f` T`hkC@u' tf` hBCa+vP^F X׈[`!ؾL &>N&DE>P&D >Ou d֙] ڙj@ tN}
 +Ȁ}	 >N ?33SP[tS[a>Q 2[sDy3 t^h@MhWs
JhOaàhPD
ϰ<DuL
p
E$<u D
@11Usd
rSi&pS]@` u߁L
 6 6N u  (X6 &uh^
	\

u>@   ^D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  t"{& xu	\	PS}   ? 4P'>N_3& ?Ͻ! 0mN	_[XB
t+# P xt  t  w\迫DPV!$!"桾tKh{10Q&,@ &o  |` hSC!r!L	vTt
v`WU$@t! $<v@a@l3  v
p
u$ "<uP>ȷX\PRt N:p1thEZ!&oă=0虿ZXv` 22}PEǿO&PCt5N=NtOu570: u	At!s96 u~5 .O\s
t!Z&)@q s  `a
׃/]3 s{&=  V P; Pu_ 0< ^  3f4GQPf_  }0 U!    P&egWʃO&MuO OqfGtM!tߴ$Ot, t"OGr ǾJM0oOg&3P/` 2%
<t29m21_kP*迷P*`OHtS@LDhE =_7_D D	 d
z=1;b^tSqrG&}	r??23p4t`h2a&ET$a	&M&]aI`~.'`\%# rT V]ϠRǠZW&=w uAF <K)
h 
 m_VP
@t   U!w#w !#`0ߊ|uovh3 g.-.MTNv>tI! //(rJg.58v@Nu% @BT߿B 0h4shaW$
"{1D h
htCYp@[X_
`PS@E![X SϲH<vLR
 Z,<u(RffSŠл,ZJ vGu

 kS1 6у[Qb$ <@aáf3	fi`֎@hUt73۹ F
t):u%B7cD	& h6N & 	 hyRN3Ga»3 
3 =ѧ  N aSu   [R rOsFErf|Q s.<t*DO<u&' t&߀A+ Ź'w
w'+՝QQz;s& _0R&yZ0ytp_ hy qYQ<?w [r(˦u% = tpYjL[S3N+6 
HHaE&SE , rPVPVϋh+#sxfV @$P<PtRZDPۑO:  ZGZ^+VWV 0  PhrX@_ 0ڼ2e&
y%2bƀb ΀?!C@ފ?r@Dt㳰51+pҊu,u1 
@a

+&C323&@t  %
t&
0  5  "   ( 4
u^: >0.b!	"	? Aw ^1mPRW?&A &]&Up
t ˀAi] _ZXr#3һ -wƎ2C.E7/N#h΃&<'߸^   Vj    x А3р>u  'S Ww [n!Vf\ Wf3fu 3 Qύ>PNWs:*uBE&8Uu8p]
R +B&U
ZK~!ؾn~Z6fYB)%qr hړp;	Q(gt06
 虜 5Ãh`蠤8.
<tZێûPV#
@F^f  XPNED
yC I  rttUf``؎ Fwp.p ڎfafSfQf.pf fff#fYf[2VftGf   pIg@f;t&fW m	F %f^`2ۈfaf`cnnfaPP3_X.>p, . P	TACO F" S 
!	& .p搘C<F	p fFf.p  pF.pf.>p<E.p@  tpttYpptNp  D@SIVfB.f$;VrT%1W B!Z\ܐ	i %Qf2$fP'fffgf"'r. p ܝp%f@c .f³fHpfXf1df3ۃ!u|+`s?I
s*"/S"Vf+f;wfff33RREpo4^q4'r44$.71p6ɐp08333Ҹ  QW> R% _F
3}5u'JE#ȩ `0 t 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^I u)lQ` &t Y&  
 < tr&\]p &\U  
&ߚlN!d N
SR[u0	F@& $F^[_RF FY<p߀TV~'}PVWًذ ' O! _^WfQSng Zpfat
  [fY_` t =$P nPu2MtaË6!s } tp( ` j &?&E?SRUQj@6^]ZV` j8w0ŌD^XP
~*F
  t# b QlF F`(r d3duhX$Ku`<Uuùd `hr4d & Xtû   h>% h PhE'`X!$!   °"s} O
ehFIB   t7t 4  hL` {tKu& &  
 P` h,ss@<t<uuR 
0u?1*7`P	h~# oXhm? $ Pk 0&pjD[%ys%aPXw$# )Р)t`($} f.`G  cp Dn@7    ; Z x     0N@`^~#bh)1fF3.{% r 
\0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہ#{.~r@V» 㐂ÿ< f ff @ffRfPf!N
 ffFf3fvZfFsfBf〶f`1 r9spf3ɰ`ǿnfAP  fafPVa3v޸rF3X

S,0<	v	,$
}.[W ߈D`

LVb f s  fɰɀ
T
TT p s 	 
Sf_fp ЎfvPUUړYP, P:Fp
uf^fNfVO_f^pP̹Rp*fΐVA6ǈF@20hFC@ Ϣ
 ff  fffffXChq p  `90w~ P9t" 6 a)P*h{UP, %ofPRh廢2R ߺZP 캿 (Q * 4ff:aD0  f2MMShm   hCɀhthZ?;PSSR@Apq$ q!(̰Āup!A stðvntt<1w(<v7&PEoh3_ ;P&
0
3q 33ҊĆtW/g.&;u;@s.ont)@)hPt^؀a`2G@t03@ @u Ý 3[
u93Q2,;8ӉN 

PU-j1rX?03Qr |X@{Y4SQo2P5'$a&& &0hnC hsu򿣶~ɰ hm
t[ Ȱ t
嘪ŀv#t̰j,5~-PXv8v&> Ϳ㟸`t`_P3 u $h<I4
#RV" йs}x uu22h8Sgu]赹uXP&
wLp2 Q޻ hNu= Dt= tYԀ'
Y蓷Y4x^ZeZȷP #\U  Pf^ ]  _`yrr	 V'afOLPH@      @6P0;V(e
ɿu^V- ^"(P*^  2oMqSP( 22 pX[úB  $@7R  Z `7              zKtP(a % $ 0rxfL+  ك%rSr$rF!f+Df+\ r*<r3w r@ .`hyjfa2` PR3W0 Z@AR `&Fd??uh3P&Xh r.>b.cpuO 	AїQR.ch f3f%_  f`YURQSWF^
D= F\ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF ɿt 若~u빠% 8t
` `uPj ;}
+V 
N JZ=uϿANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              D?`ރ6.u?;v` Ql0 >rh *Yr`"QwLQ`f&YCC`K (   rP3YaPSRP3@mn?[`H@4$&%<GPX 	 o; <BMtf3襰DGP2W X` Er
JRU3 fGenuuhfineIu_fnteluV=sL=r=vS߀tNp f   =   	tŀ   
 f@3t# %t5ubfDqa $<@tS<WtO`NBH$u>f=Pۊf@+rC{tq Bt#Bt	ݱ]P0f
aff6?pZXW_ RWO  3OtCxx ؎0P.BB <t BB2J &ݾ8   8u!@屆`23Ұ
ShSWSt0`́ y aut0i at]U U[aSR  4hf
 hSgZ[Õ`-0Pϻ  h=	 h
 "BPaԀa$8uXRP<u1ZtQrtwvYu0ѹ }R0ߺwZhEU?2<Uw  h9]ݚ u
3Ҹ EFv)v upQst&,3 s߹ ' 

 SPf. UfQfRfUfVf@@hF: rsNrDW3f. fwf_4f^fq5Yf.>ϠfEgffgf uYKU q u, P3	fgf CPpcIfAgadf.#f9uhpfY'd0    /p ;:hV 
;! ބ<# :0Q 57 %"瀊  >QV3%@t r;F ;w
V3"/fWi &g 9  f% '"OӒ #YFfF^faQaV p @\  
^bq]3]<   h DTD_w R Po 0 oȳh  1   l ( Pb @0 W HL P`A T W Xb, `
`! p@pؾPx o A0
|\D`QWhG2_3 3_p 0 PQ= `tq1 @0YX 05SPr
&ߣ p  ff& X[@ca"&    i?r  xh}@Q [J5O fQ9QMhFl ./ Жp砳迥 <t k~輥 tq.补ri."D.|u.:DtSI  wD:r5+s&v
uAl
c1aPQoRfWT3^`
fXÑ2a`2	  "	f 2f@0f@R %  3f3fSPaX Aih lUv  fb #&f fa dD 	h}W" (;sQSf  r_`
 t
2fOƃ	40qv!a
 Q[ffސY+vf[Wf+_f t%ȡH+f@`h0Qpgc- f@kf`0z q_L2_&U uZ=PrUf%в uCf*wf=`  t0  t( f{ްf
1"0"fph2%/$8_!"
 \\-f g&%ֻf2@t
 <t+p g1~f&f  o , Xup Lr}=fBt<rfa&'?rf̰Q̀É_Fo?<  
 M 
"a	Ub	'~p@R2BuE1ɲcffF &Ff}{ t@sf @{f;~wt	uɁ~qNїV&<##`WfVfPXfXcr<w.Y0ճа_Ѱcf@&ˀtg&TfVR3g&PfОfnu=жtsaNu(g&fVffA>"Ȁֱ.f+E)^f^uS2u  w & PP0Xt'vt
t@   % r/o hm>u  thrs-3&>rwqrR0zsRޑuthX$uul	r` 	߹ +Zjjw b6uPS`` FF phC rOu
@ f&  ؀>t !$!f$< uRC  _
N<2<ăƁW	"3A'yܵ@h[u TYP=t 
u2،в3`t<u
E< tȵE$<u&w $tRݚVL  N L NQu û` t  P[2u
@j OjY!(!!2(<!1ʰe$ h5u$0۠t$~.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|h4B_DuQ&~% t P讪Xӹ
 t.:t
 ._
vXP%8Xr6%ȸRfc4;La    PJNL p      QKOMp @Kt  Jt P(.DGH hh  hvQ {h҅ hE Б?E^  ` f  Cp m& OE 
v %&M߰t&:
&;r"`p$t1TKKub 
HM` `(q }p" sr#	cp&3a C n	H ]r5{r`2gpjh!BvZaVRQSh{n4Th4J"Ҋ.`B68u,2
t&62@t2 sk ޝ[YZ^Sÿ PhsX<?tFhbUujjjj P'= &h?X[ h" $vawt = ;t= Dt
hEsp[.@WVS$`́$
跻[? @n< u"*׿Oطh}Nt`-->J=Ot1 0_ tyr rhj  S^1  0 hL PͲ5[ ?  :N2?Aq% ? 	
  v VFPgbǋVW 2_2µzt"@uG2 
u
2Ť Ϥ
 o2E2&&&EA &e?
td&E&&Eܒ E &E<r&}	r@ VW^2۠^2*à
&}vPuh`VRPRQ3f 
%*tu,AYZXRPSQY[XZh?7	pp Є> qQ 5rXY`^,>: t
)֮hG&&  t8t'[ u aq+& nq00r6$^$ Z& && ;`Z@ `dde`P`  XU @>
  .PB B把8uG` A ; 5/)䊺@#BS 냑75VŜP߀X
 ~a@A@ uB C    ÜFt𻰀V$%%蝊<;weĿ X؊<wM3ɆQ#"XR<  YыƊȊĴ3Їу?E pY8@C0	 ɄFWYuF5<?uz`0Dwf&	2
pu}7f߻hNePӀk 'B@. ,".  &k !< uf& bÊ$
rۿ wAu%1uhӲߡ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<ҭf7RKff
f@hʐXf3f3ɹ f Hf0m f+fL ! K Ru*(Rآ(R6g3ہTgsV4C\` a^_^fZfYf[fv3hI 5R`2K 珀L0s< |&	3ytvou4PsP 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .`\3 2ҹ%&@GaaÍ6lhVWal1z_^pk` hΫ$h  uP$<X%sf @  t<   4 |r	.$<u
 f3hh.  
d]XiJhT<  tdbw_0s.> Nfm thtC	
A!U2 u@> l = ]c 3Fd@ e f Fc~ce; 4~e uQ@@8? h`5
P	جchJӳBFe:Ffu1r,
 h
 _Fdt:   	9  <g ht5Lhsh`!af`7UPHhu;E#f% PCAXt# N h&N r k f ̾   Fo^P XSĻ  y ,  o   hbS-[t(t@_t,&j  j,>" ' À tht*dúߋG."G**=D/.qpE4]+Ë؀TF/VU2NfQa dYF :uEQ]Àg33t
t
u
1t#u
tN02t"FF0u3! :5tFFdz ulm29p`F: uYeb +Πu;6F1 epp0Fwff`Fup   j(j	R	aURψh$2  pɺ 1 h= Z]coRfB$r@!  tg˿RQ Q;YsY2{w$
 _!u$ d%|Zf`  WWeIX.&]f  pC`hF.
 C ƀu0u.> 1fa
ZURtLށUHhU<:nYm PY8tn(tp ;C~ Zi@"g squ4VfRfQhÊo$0;p^f[B]8" a[Ybh~$q r 6jSj@ 2P sϰ rGZ5'/UnAW`.uQN$<u:0pбr"&  t  tt tAt $pu?P:q9(
ː

 ⧾N`XSwQ 3u,S?[rE	ˡ-Y[C& <ff<q`00xx00`֫Qɬ||	>>.wr tr~ (ЃrLZCX̀'q@VF :]Q<Q7W &TZs6B  D ц߆ԆrA zuN! ?C _u 0/)0/c#-&@ 8q2 E *7&/p`W aUfV3vCDPDQD 7p4f^ǋ]&ÂQM"V%  烪wPduX$epI:eXa@1 `` /////- "  @f%p$к FACSPZ 4DBGP4BHP  0938 A!  8  APICZOKm	a	Q
@  		
  MCF#G<	$P	{     @(N@
 2! RSDT(  		f`h4hYf  fhpfp  gfFgf  FPTR ff`WgFpfL`f.0p^$f3.;.8f.4f0gfN0~$wf+hCpJF~3ffgf&f.>f(.9t82W2@_~( N g&F	f P  rgfffff+f+.<
oۑ@M.>0f
$$#D PXff-qAFV3g&fFgЛY[pff=TDSwDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt"@H Qr}< uBOаNRUfQ̓2 tPxprAr /v; tg&P)XfY8]МVfWfV* f& fP&ؐ@(#f]"fP߃)fȀ$ 4 
Ȱ 
ff	hΩ⓾p (f }t  fPW UfXC Kvt Z{
$vs g հls*h1 <Eg&Ƴx%_f PSV89@;o <3Yt >Ju	߃<Bi 9 uDb& @ {u  ?D` ^PRW D hBo ht _ZQ>4PSSSguPBP3h f&L *f*`B'+p#L fX`*hw0D" 03of&?  P 6 Pu    DOG/oPf3{Ӿ p H   U!   3P>P&geE E puMPMLGfEtXAtߴ$Ot3 t)O$fM~
rþQpmMe&3Pas|U  r.P]h%2.<mjp;   jøPݳ 豵jWp_±f=
phk0kf%ttӿ' t֟PE(뿭 5)1P*io_ԜVΎގeA^ 3f`FF  hCvw }ur_ h  U$g(,0wu4'8  cÃ9FtFfNA:F> h44;[ɀuh(fa`~
Ew13ɊMh$ӯt

hRp;r#uac5WF~ ^SCf_ fN^Nf.9`3u d3tc rfQPH_urf;^uf_;Nt;ft) p 
tF~U_ս NfPV t;6+.<t1!RS)hn:,,  ^_V00 u,h$..D+hX_ pξ1_fqtA"   u
3   t'0gf GhECG$L<LDCOMPAQ PC Card Smart ReaderLGEMPLUS GPR400LPSCRq CQLB REFLEX 20Q241 PCMCIAVReflex v.2$cr$HP
  a@!g&O@~yGd `P  rLfK s_nr>G	 .D
A O@.d.D4f_ PQW?Ź  
G.g&:ouGY.5 _YXQ8t *F 
⡤fW
"
@
0BgS"

e%Qf_B`bS?h?0Gu#| ׹ euu .u = ~ 1rp&tj  t_& rT  r&= us0=6>
r/6r4.؋V@< t ^}Jw 
x y z   h=Shs{ s%ZMhasia
qTrPqtI	f} b
u 
!tQ&v >s	GYV_
~ ,`؍vfD   ,AfLs-<t(<}#@06 h	L^PRU32t
t
u
5# t u9<0r<9w/?tM>ư7SQ {Y[t>"$,0>*SQLiE;fw 	tu]ZX䄷f`3Ҡ&&hG֎fv*`%hU_gf9t0Xa` 2   0 thbHq egf@ Vff3f"gf F f{f!
!޾i3۹: 8tCRP #ܨt r1hf˩ uf@q  00i{? 0    0     q'  ' D 
 Y/ -bbƬk`oC@GY kϰ6P3PS_?.xVW ˌ׎Ǎ~Qr&} uBr	:`_^d>r5r!"r\E@&=u	_+#PHr&E$7uZ5ÝͰT3bYӆa
cr&a)rI DTtr&ϊe`4o5Z0
T3
+@ΗUX4Sr#@itct  t$?BffLo  	] 	6WQ
Rn3q
]
ö\3i+W!z Pjr8u`_QY?_ þaL[ r&U߀þGNLq`
Pw4$X` $2L nB0<{tH`8u6
uBp & DBlTt
aP 3 r/) r%BB!J@ 
; 05 a<t

B J 2@u8` BŅI2۬2؇Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&~a$vQ> Yr	{2Qid'Y߬B@Aq Br蹐L^	 ofpb3׾    @ P`ңP@\`j h\  H hS7(jkρ hÈ`% `f= @u [jg hb Sjjjj P'= g[ h"4?buq?j&v]Ԗ$awtQ= ;tau= w<t/Eݳ3{ {	hRZt`jfaÐ     tHuuu):p*< uwuup@ z`34jr! grπ DƆ    r% Z@у-Z1=p$Wp_ǀ uu' 3ɟa re+ tg	%  .{f߾  fw tpY[rs3hƮ  ڻ= ڻe ŭF  ~f c `W tI
r=> \Ӌ~ t@@t0(5(@ MF t w0Ó3N !F ~ tٳ	e0鰠SZAt9A`d f` W܋f3Q fY@ Ix G"
 /2uJp2:!&= t:`T߅  yr l0VQ&[Uq
u$sY^D^
%f"A6	
q
&:!& :X. IhBB 
Dg@P ;(3 ހ?  A-ݻsC"upmiY1u[	q	1D!IFt3$a3; 2| + f~B \	(Nf@2Bt1Qr$!$$
7R< !Z_t'
QVJPf^DUY!Ұ.&++t'H"`Xtt.a:``s;߄ 6sbd_p_pkoCcqooo#Udooao
fo蠫Dbcםasf@SfQfRp>fGenu fnteluxfineIuofPH>f%`f=rYf˹a2?I@؀Ut/f00t[fPF 
= ZfYf 
  K   
 SETU ˸ @؎&м  3 r' W@ P& u_SV  GG0G h@    Gu Fu t3  hC) 
h~Bt & ^[SO
&hk" `[U샿VWƿF F@    ^ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @-<qt	dR>t <tjjjj3P'= K.wj5$<t.<@t$t = ;t= DP  hEn 揿  7[FF~ t#^FLr
F FQ  ~ wt: ] cf
 h5@\2%PFA~ t
F_^Q
h;ss.&udu   hb,$?wط h,"hD *f_01Fh˚B%..  @  Y(`p3WVe1E0E.WV .^_UP)UIQS6(6*`e1E0eEE.U s@ m2a h4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	   kQVWAu% p u㾐  6  | = <t ;E@+9 +_^Y~RWS Ê WCrr3ɺ ޑ܋e\AB rN _ZqSYKK=K
ZQujvz%NOJ5> DE<@ ;<<!<3TuU OOpPt
Pm[VfPfSfQ0ppf3fk3CpP\p|pXfffDDG(	Dh fYf[fX^v#*KgO G߉xpQRްC3ۊ%<} t CҋwyB`s|fDf3ۋfË\` 	
C  	S T R U 3	G	[	o	}	`h	xh	  h3	 hG	 h[	 ho	 h}	 axv.L.< t)F.6I3.PF.h
C^[+V..^̋] }DF. P .h?bXhJ ؃ 7Q  16V  0"mWa X Y #Z  
[a ` ^BA\a ev f']a ;a _ `mgchi!j qp10G pppQWĀ>t		 u		.y	_7   O 4a9Tһ -w C.ő/⅒2R+m?n8o7Y3۸  _`߸^va>QRrkPS[Xh"(hЍˋwh
3     hq     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;!m   03/30/058X08 {~  kLite{J{-1|5?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdP_x>0@Z"2""Pfo"x xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`@pcłŃ 瀾xD¯01uү0d
01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5}EFuu!"2x00Pm俐}Dxe``
$`$p

xc
xx txDESxxxxgD@.s0}}@ v o :}d`xG'BVE%x}DmQ¯00xtxtyuup)Ð}mNQb}ts ,{c,+"(pxkD00q x^Dx_T_xcDxfT e p# * -1`U
,U%0'=PI_	P1Tx"p2xfp3T0//}@!T` `8$ u!`	{$T`#8 )n04`hz	"{P	;G"{!
¯+u+$4>Uj}T+}'+p (++Ô@^{,pt+
9
0%?
3
ޑv7b",`^y0/}j.@ / 2'0" `"+7x&x+Ox_`t 7"6}

P} _}	!	 ֑ @$#}}!}a 
xпxt"xd}A}D"+ !1}=
 [?"G00x )xi`xj  p@0S+; 0TB+x+¯0*A0b 9P4~.+30AՏ+`xO/	+ xTx !
|+9DTBKPF y+qP>

C\Tdp+$!#P+.` 78O0Qg ðÔ2@VD0¯xx7x8r x00A:`6$06 ABT I`	pQ6Un`;A@#ZZ0w/N\*5"XXl# 0MQ>Qx,Uxtx0x,@ QAE0xT?Tx*rY-tx+2ZZ?TxIYR[M^\MRNɿ&	_k`qkuxP`_DND0=0 U   Ԁ^ W>&g%xdp^	;;KZWLhkQ@*ARx-	+_SRNx*SMx+` L `R0) 
peQ`
 RSjPP1+ f0Y' Rufe GPX~WxZAYAXNSoX}W}X$0YPjp^qZ1ZTMZ1ڱ
YNZ[Pn0c1\\{TPR`\
r[	\S2A}@ A}= #-A~P B~R  5A~Q uuҌВ}"4"7x'D
 Y /7d`!70h33ToT?OC}`07`'`2`=`HpQx]ߎ 6uuuuPl" uu0 uu5ˏO$ƨpN`0T`
010?@`AО| }(x]ߦ["+,,E+p
0 +C,,+ +,+x,+0y!,,,++x_,,"ߨ-. T0cL7 M
!Mt&Ipd `1g!11>![tU!Ҍ(0響/0mp/l`
/0d@TzE2A .?-/0" *xc"+xtc`
o3x7;x8W7tP}0h"[ZYYcdQYZ \]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,@7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l2Kd		

!$(+.2     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >g d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   S~@ 2 Y}	J @ | @ s   ww ~w~ r  u}"8x4D`e T ` D)nYX0x2tx1tI-`'%[0' 'xqvv W'xq[CpWxs$% & & #2x1 	ү  ¯0  %#@K~3$b0#	Mx3C
r beJ"xrF`V0 pI`$" '	x30%0&<T`Pw$"xs`bfp
0#%""tX.4} 
xs$3z 
`Hpo`p$W$; ysp I pxov"x0	D0⾥$$6Ӕ@Txy~D"g0p4hxmx~@ DT> 0
 pcBm"pxu1xvx}"xux~xvxx}	"xx#xwPy氹ywxxf`Ӏ|pxx b( Qu⅍~B@
"00"+000u0 u0 
0f !$0<HRT`  }
0"HD =16/(!a0"0
	00"d0$Q1 x1" |u Tq0""3453/:tNP"o3554!_Q0"0"xoo`xaT`}xnov+r!3}TOp0@0 0 
Q]P:0 /\vP'22Bכ P`Ӏu"78- "0a T?2u$408S0"{z}yH237L9
u/9 8+
`9709707@2$Mh'Ô@^0p4J
	

`$
Y	0
	@À{0-$`
$`$p!{a"!V ǀK0":0! @À-0
  Ҥ s	 280"
2x{ofKp0*2d|p08SH{zy	 xpvmJ%_`gK8P2 ( 	4  "H	5345q3`	t%5544r	@ :0	h0_"08`	2A08< Lr@1@^ 
 !
 +90 B? 8, 
j	"Ɠ "!`BQ
p0( 8!^ 
-NU
]DU 8.
j'	20"G+6,,f-e2pO7)0	LP85p
b34&K05(	c/	0
¢S 1":"08$<8;pfpO:2+`"/c)[P3
7@FCxn`qe`?0}Dp~ h,go,"a,a b}i)"4xMNOpxD Te4`^א}V Vp0
T4d`#I"4#p~}i4xd@3 0
3 #X`3`3$`e$`1$p$y$`9$`$`)3$pv~AT Vnq2c1[0TxvF>&`!	0,0)$ٯФ@Dx Z3c0a ?3]PA:6P 	@Rp?%¯3c``w pTU`xk  O/) .sQxv
xD}S%0{0^`
}mT?DtP`PtYQTʩR{Sۀq"@`T`Q	067``$p``1e7`tgE7r(( ބ`)(u?'0*a a
Td`x0dp#  xF 0TÔP
 )xFt txBBxUNN{}wxJqJpr:;<t/a>=)x ү!:%$t=t=;2)0 )=o$Px`vT"` 2'<x"ү3y:; 0) ;:@ p0 xύv6ѸxV86}'p p 7  %76_'7  ""88Ô@3 p/p0'  /..d`
%~r7?(0TP5?O(@ 4" P4`04/@O453``/`@$pN54&:I&du*):P [x 
33oppG+L1>gp1  ':P"ސT~ ,P2?T#>үd`pxH 8@622P65Mb3e1@dx>1Џ/ 
m
`+0xA%30 B1
@
 `00
TDT@5q0	 39@a, AP}Rt
} u2P2b퟿tl@
p.
@	  r1l0dpe`30DxF105@2`e bC7xnu30 0u3r2*(t1123#.1}@80 $32  a<0 }
1pAR ErpM,"^p  d-su*x0,u`2:E,]4 2UU.X5%-?P,* 2732pha,
$+O!% *R5 }
Q'x`S+0	+`ߜ -R	++@@s@`p7v@}	 `@~A0y!T``;Y_` VWy
7pDxp.n~LDy}?N%@k53.Eop;OCD-tqXċTQQu:93: !p	S31B3dUA`hy%%Ovtu0QON@pH R/ N9
d.0
`_/X6Fp0X-64Fx0570`5#O0]c6e`	S8@1
!b-1ÀI%P/
~;u1  u1a1[Q+C{p4z5zd`
3z+',yuv {| AҐW90 & n`AT0 ,	al9pd00o0 upo6o,/-.rpFB}}?0
P?/.-rdct%,f Wu tq70YS 8S;"Wΰ4쑔p0BŐ}BT_0=_<I?`$<p:T0Oܑ78e`pYלBxgT)Ax`%daz0  87`>P$3bq"W¥A3U	``uqq
r	1Q`{0
}
9ȷrdP9$$P6"{ 2F/}&e'AChS4Iqo}aw X@apR`pLxpGN3p?u]1ԒU^#5_`@TU`#v@|T kx{}Pxzp Vxy TxxPUxwQxv0Gxuxmxtxaxs`xrxqxxpx`x|Px{`Vxzy@UxxRxw Gxvxmxup&xtPxsxrxxqxxp"ypxkv00,pTxgL4+" .3k/0.T0,Qg/`8p0P S.^ ##~----i C2?",u/2ώ12B@-21Կ^ L-. '5q,Đ/#Ӱ7,T{AO-.`۷pGQN.E.O/JP70p60Y()y0h
PI5
Ps|?`d7]}SPn,rtOar4֒N0 `a2Е
p1
P

Q "u- 09r"l  },n1vg8M,  yA3.02.pM=1s0D@dT0u`zP;DڰS,c,u?.B.`] 2 p0`u.Tag1YC
.{%TOлQN](03p	 `` 8a 9Eb $ 9)NӔ@y6S ? x0s!  x/5H0QRq7prrqxvCWU	Xu
b
		0
  `
7	P"wq 
G1opTrAL`M)60.T`@}w}S?AP33TB{DWD  Axk6"@tO C9x;VxFdҢX`Tk`HT
xPM>@nCm!3"x*UU\]@0Qqڢ97F 03tv`
pUr *J(( (BP_P` qw0P `	qPa"NO.eB"TOcEN Є1n`<<~A<~aYpo0:BP e0!JI$:1PJ1,"F;KF	D0c
^"CO`@"OHIOv30aA!Idp`w@0t=t A2bIAՏJ``JIxovHI;"xFExGFxEGxFt@0) FT.`xFF0xG@Ft")"F>~ 0 G_<"xB!C!A!B/)B*Q( #NA
OA
MA
N/I
N+)D
JaKaIRaJ/iJK
g
b^0JKoLM`N T&` @ws0uK`K@ 
MLt ~HKJa}m}t}}{EAMI"!Q..Bړ  Ô@""7 q "xf· 7""TxDpT0PT@܀p ?S$0+ZrH:R E}@TTs K0F}R*Uf@@@@@@@n@\@V@P@J@D@+@???  @BVQoJ0Ki"`,Pebrt"#xb@r o "BvDQ)a6,	R#q! b* 	]_:wVR[V$`RAb $aAUӔ@UPđO!ȯU0	xoZÀӒ!}AU`#`5?`2$pCx xD4SS [CxaUUT ?xns7A&NYq 
xjx GÔ@π<PT@xjB蓾Ӕ@`xB0{r
T" `Pt{ jxfPav+xnvy2P8ut4}tt  0H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATUBmRBAC@y*F?}AE b D${E0U`Ud`),uURBCDDD"DLDXDuDDDDDDDDD BEޢ:D rtRpA$9pC""-E
@ˆm T  g@ ߗ@L0M7 &T E7C@U9rxZFl!R
hҡap>@XP`A@8{O0D=Dd
`#p`(`0<`PdP`d`UP܎U0:NRʌt`td	RxtxxXx\x]txat"xbtxJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx x#x> x=tp x@t	p0xTВ
}@%xtx"Ttx!TTTaD	x?D@xwTpT =TT	Tx= Q
@TxDp?=DDTxkv0}Gt UdQ eV`eTeP XS:"x0xJx"xh/M/"B S?/?@>"ޡ$"tOR$-"T`Ô
P~0~7%UU eTT7%TT{ z yT`H H+H3H4H 6H(7H08H;9HF:HQ;HV<  {H[TY1	 Q
 I`A 91~5GTU& 8 `;cuTuTK0T"$`($`*`-w/Arp4
T1B @GUQQb U T"VPT$߰QIJ|Ib  $q $cIuTxt x   uT  ! 05t @  
A^{:32  *}࿣0B #'/A0`,`0$`3`G`[$ap]Tp^z"T y dpF^0$s  `!DQTwwq0/Th U "&$pR`xPM.Qd`QQxhQÔ PQGrG֭q@P
qJPx7hv@@0KGKGKGKGKTKoKKKK˩KKKKL LLVL[L`LeLjLoLtLyLLLLLLLLM'  M.0
?v"xMNO`uRRۭRsx}i)  7x  "$"0R1g
R:^ H气GܵЄ"} HGG'}0"uS@	0SSST
 TS?0CSpu 10P/ 0@4xathvajQ =pkxTxkD0SxPԏ0Uxbx"x@$xx"x`}_K}IF	
Q@ Z0""3PGxT| } ~ KJ]ǐ4Q`{*O.]RR &O.MQ((sMMNNNNNNMMMMNNNTNaNNNOO.?HNÔ`P/QHd"T? } 00x`r"QfSQmJ!w0pV	~`50ߤTp:tuQM0 0@I 0)	\Sm":Cm$p
:!/0Qp,"xd_P P0Q0"~}i 0?HGR3AP>2I1ccֱ0M}E@J`d*Ce .:0fTN@g QyT00Tւ֑ϐO0#@60xD Txi!1?xxivpԩdݐTP A<A=Bp11u32}'  $31T3322@"O0  "}'W ]"   p}"/v)P$0/Ô/pC0S0߯0PF200谯"
xp0 "ux`2345%@"(t?3t ?2x`325R4U5B axQxQDQx@Q  09Ī6xT`nT CT	QCQQRR{4 SSSSSS6x
/0!x
tP/P
0/ _x
  x
Q{Px
! %60$t $T &Qxt	}XBxs0xsßP2P0{ p%@$X$ÞPxxs{`1 	_1_,-u . <Tү$`&p<P} p% BVx.-,6	&xxtӔ@v $(xsvysxtP9!  P&0 =	r6
pxv 6xa`r
pqP 0	,xx
xR!x	06T)_P$3p 06d2T9 T@TJTTT[TgTU	UD_
  U{pwgD4 D@ @B@"?xDbU$P`?`3zTOWD#X0 ,D "z9Tph`/AE@EW +@@CEtm OJ@@  { _33TOBOT?@ 20/"p<ϟ`p}Tp`8 -5,, F4S,z  S,`xevS, ?"S,,"+,/?0-VbVx	pVŐ}2xNVu0 u1ATxf`-30(Ӕ
P!P23	D3E2Y&SS0S3u2 u42U03U1Np1%1030444 P-5xp7x	41_0	^p_
55ϴ-Ӕ@xA1 w Y 60c
`/p00Ӕ@:x>0-	`	WmW|WWWXX)XDXTXbXpXXXX$X%X&X+Y ,Y
-  Ys-`:S	Y!xu/@xwEP[-.^P
_.-0]	
x3t?e.pt e-`0p	3pQBp"	`pExp@};}t*p^
.!  2#Pt`-Qe[v` } q} UpQ t u vAO}}	}50R)A dQ!qp^~" 20 ,+"`~`{Z`PYuY|YYYYYY	YYYYYYYYZZdZ3Z  Z \WZ\s  S1
t?t)Ʌ|#	
,pt% DoTQ<WT0BQ_
2:Գ8P^`p '#LpQdЉ]P  rgZ `!L0tGNt(ҰDi4QrOBkQ
xbn)SP[`DQT
,T
qMA#_ "gD `C - gt .`T/Ӕ@"À--d`"` 
`-\.t %-Ue.`.6Ô@ϾaG\[\%^"Xto.`:``O/U.`"U/`"",p)/d`cÔ@ OeA
"x
xt "Ӕ@
u/$ -$U"xՃ@!"Ϗ5} 05t242'   `" ],22p\\\\'\/]I]J]K]N] Z]&[   fpa`lP0/V"0/VB1)6(S]a  "	0k33%$`e2pL2640"0E(4d	 4
4a0prA	ov"Ô
@"41\x!4$`$`2$`B$`J`[$Wpk0\ZՁP c`_2QR@D	qv3D4A4p-@|q
hD""""0 ^^^^^^_ _=_Z_c  _u2#_u22b }! 0"t `]u2F,!wu2=r1%
C]Qb@%6@r2UDE.u8
Z/0"HQ R 0 3A2"0p"x%0aT~t@"_Ô@Pp@@	T7"X Ox~ d "װ׿}t0	}x_!#x0x!TT`DƨpГT!D`!ToR1 QixDGaj"  :	;
/'
123B=>C	D
WX`~x`o!POP ^`_c"
%'F`7Pd0x+ +cxepsqbz;+s+M `C0/+xT 6D } 20【ch DT_`&g @rTT`P801 bVS 
0cx	+$```9 AНbVxv pz q DxT"ҎxStTTH`Џ+xS+<x,{ 6, G`$p#+pxSwx+	x060/QIJ
~
0` ց"`.q@-ӔPnq @
arP/-$``C$dp<0/UC.P}?.H, }@pP[`@`DlT aP#yp}} de C/.. 		pycB	@ w	$~`E$`M`Q`U`_$ep`..3".4 dpI!0ӀÒ/ q xl..T
"xf."-.{{ kG"0$"xi8"1 	ӛP	P@ }׸d`UÝ@ӛ@* ÝP:;<u t/TtF"/0104u5u<$t}5}ྣ/eHeeӅefff2f2fUfUffffەfffg!ggggh!h!hhhݥhݦi i i#i#iFiFiiiiiiiijjj3j3jPjPjgjgjjjjjjjjjj  k'~O0~%~ p0p& pC3/}u: u; u<3{c4;k>T3`P66!~1 6` gR3`075u3@u:u;}u<׼{xu{u{X$::;<{&5Uhg0  b Uh)gU

-K @1E` 
} P0C3+R#~ 0`| }` @^'_N#`#U#(
)"&

5P)*)߮Np<Id @(
c# 111{!7(+(/**81,/,h3/1/5*H13G1ܰM/|@T̎1PRBA$__TWB1 u2d I'8B=9='8FGXCWCI˪EEL͸GZGUo`VII#M0V6BP!}VqbhQ"/"qVÔ@πu3//\Cq/4"$y`P !SЧPpnzQ} @@ "@A~K`jPl($l}`T}&A`#0#xt@}}_X} Y  ZxqBBxtPBoQ~0%70$@"Ap
 p"µ&@AOPr+ 	 	Y	U	Z 
 
[
Bxt+		 |":0dx>T=@Q
38Ta7>?`d mVP?>IIPw0=pIP"08kv ?} P' 8@
@| $ '>Di0
ӗld Ep6Q"}6`~M }qwfQ mo#@@xb!01PgNې}P@ LTTo Yt
#Dq0P]+~t;++/
~M]С2!_Y$QIw\Tlw@&\p0uIr 2 
41pjnnT"1o4Po)v1xe60o6
 0Ȇ?~60B}e}pp
T?T`4"4" u2<0n0`=~~^z@0kTODԄ001p322]* u1AD00 	3]PP08PQ@`2PD2B32ӷp087pQc`&RP@P}`"aR3"0pT_Os"1
070% 0qv033@,pe0`C01?2_Vbeqv0oP3ఊ1!pN10~  cj`Jg : 	1DcA&Jz@T3`02`;:+"45675E4`54iP
(4`i77$cTo`MӐ4`TM=`` `'p->Tr AE D1 i)0$CBDf0s0 B~ÔZm	*u1au0)x'2u0p
ꡡ1}}]34'R`ӝp2u2u0*> $g3@P20' ac@'
Ls`1[2^raEl;=8002`BTTT%W%ON>xEp0>3`D
` 
p	0d`0a1\Q]T?`<@7!?$p*y3tTS9)	 #vc H@01	a=?2`f7O"c"Mc#N$'ZN&tnUݾ$	??
o)U$	6
??u)tx
dd7eU"}{zyXWj7vdj12v04<t!`u8/'P~ s2./dsit#\v>h~@_[tQruްppT0qN`۔L=2t[	ÿPt q䑘o[``z45Ӽ?@+/G+k43ҿ73  w((swxixxxyyzz{;|}y~~d~Jk	{ z y4l	5P4F w
QhST{lSp1
3D,t~5{u4`u5 	]4T`pd` ԁQ?
p0
PFu	r	DuzLoBmP[|| ay[}} pmiiiPK
ß쿞
Np&V$0/餙iz (
r67d6 N}6@7"P!nRPJd0,v e5p47l`&{Jqw!8*8EU| `z {E` @\]Lvv89998O89p#!#֕f8`9#
							@45q0F/ 3t[c98(d`픝!PDA-0/* 
E0
jZk<:IIP2SU~dLpt@#aM`M8@_ɫ~1mpl`TT@
`r/@;ňqdNpt/,V+0/XPՏYP7[Z>Np7>	bUodppNCWWriҞ/*'P#^/iN 4()?dn&pf1 6r<AFt=QRVv>afx?Mr 8i؁},KD|T9-`M0980,P78+3 7w投3w&"27傐}ty3 bAߔ| 3$`A`ym>c $~ 2|ࣂu3#ux77 dER t8u@`
Ô|		qAjPt7pz9qTT Np: );4u3tuq$xe3`3_71!`044a` wƀa1 PӅeP/31˕axdAU?
1pCϑ2"߃Ӄ}`υ2"u0X
03} ZBY%}.
~NW0:>F2pPu2f	op`8
0𩄑
``ӕ19100! xeT`&}$31dtP2"u}`q 
0"""ҿ4}t t P
3U02	~LTD"LION x9p"P
 DЀT":p
".a~ d ÀӲ  0d"0Ӏñ 7p8`0@
D 
~,T e8 @p 21-"P `"@"x0 5"5q"px 
qvs>q>~ 0uab on`dx"7 u8XK`g,7bP|  `  Pnp=	84zgk8$bd="89I;u<98~R98lpe; 9E8 `v j@@~+P"~{_
mȡ<0&x33 d ::Ӕ@o:@>x#,	: ,Y=x@A-:1P 0W<p5 ;PB
$0\=<>?u@`"H P/A(p??p>?
>`j+@5{5@@	x&Tp/"%T~ O7&@"`"!F"x!To`	TOTp57y3o`12D"C
xCpx6p>A4ra/T(--,r e,p,,~Qe,`,,|21G:3>d$-t"u;2A&8<9@Ju;;;`/ٔP9:@@l56x>~FM" pb?b66V5 5 	d` 
F~G5CPM¯ DAJ~pO*q+,U
,{, +,@+@_M@T` OFjG$&?_xt
 T0x"T1T4TDx!CD@PVp
0g1dpa_23%33+232@
{4k}`V4c[N(%%q
O5PZ`a00*OT@eVT		>"TYqc~P` E#Aq""	߿F	 >	@2xpzdPX LҀƀԀi@o3ڀʀ3łŃ 
`	"3/?$ ̈$ P ##EN``#sB"P""):0"P%0 "b``"  )"/33@p " 3@P"Ø"(p p8

r
		
tQ
X
	
u

 ߃*2	1	"yt 
""BBE"""ЃЂP  ts@6 s~$ŃŃ1" "%5pbp~p
s@h`1!p1 1@~1Iv1@n1 b1RV1J1ePe1111 p0p00pW000?#s                                                                                                                                                                                                                                                          /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  P  J     MESS.wj?v/Oau!U6f#7Vy,HXm
	;	M	\	v										+
;
A
F
K
T
d



@yk
^
n






	!%(08=DKQZcinz!Dh^~=]n
:N 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
602-D ette Boot Reco#rd0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the conts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7A proc has bYeSed ags n@orQCMOS13- s aAby POST 1155BoaComm P6 Assignmlic611-Prima~" Flopp obz2-S nad01W#trol`)y5G%sType+1783'` Q9)	v0C0'Ef& 1	&8	3XP7
~60-Fix"	doe"sup" Blo,Mod117'r[! Aoμ$173_{	DMEA53?5?@5Idp@ify=mmKl4O>	|xParamKr TableWBI>tRXHalpB  52PX[ap5.Invalid elPronic serial numbeV16I/O ROMX3`7KeybA630bF83047@b4cUnitdLoadalWl -\h44aMonochroym`Rl 164iSiz=_
r2rXP%WInst0letworkZrvDAct\Nso &aach16`KoOp1gsʐt^ pg Chec2  PCI BusJ_10-Exn`StoragJevi0sHPnHPFA1spV  Ol4!14Y2%3,3_2Xz## Se(OC?HECK a#@ yl3-Ti`& Da @ X    ~Power-Pass0d	XOK Do y[oullЉa to p~#~s? [Y/N]

AdJ0ia 	R[or!hip8nѓ... (ABO= 'Ctrl +t` Del'18-1@#h: $pHchangedZ2: f*mBqneщq~p0+*3/: VideoRTz-4z:Prrup fX5_i *8]6_an ^Qexpans1bPt  Turn!!Rej`Кfs})<F1>:G Abp
!bq^rmal820UZ mupP#3giDwa,6#+Bk1.(Strg+Un/tbr,I n%Tpf0ow$o$P6 utom`c4updQ,: ۘs ToX miX: KbytBVcksumk,NfauP/kulcnW1Next? ErtiExfȠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu{ 1 MaiAance!c
 Hyt6.<swi@s us0modu+4nme@$+requireAs.  To c.d.% LѣBU7MpibOOay1__2_]re搫excee@ !pӵb1| vCircuvLUnw l!n$dy.L.(. ddoee. U2S_0m"SP   2oI#c5^ InrLShut
downi  `0	-a:1Pe `;PIN: [
] \Na%left+0H1HB@6 Pu`Úo 
v^oax`ˈ`Ӏ,ZbauS UedLзcuRc7hipbeQTEpmJoldNew _ !upu0cF
!be`$Ȣr"-l du<.t!_0#AgJ N[!a
 affmHPma,t0b@mak5xxлunusPVItIong`6en! 
f=]%u0l,Jrec2I`paSAѣF2Fj.ERRORYhQq <!!gonefyBla MIpx (MSGIDX)     N   P DSDTDSDT  HP  DAU00    MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 D y 

B9G  D
AAIG
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	g߇i
  #11g 2 phpi p
 f"`'fsg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_OS_`pga.ag)`B4
bra/13oua
 6
 s %[I` 
u	273213415p0135_INI 5H7
fpig
f 9i` g9hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\a@[K
  8_HIDAJ	_CRSR 9)
&	F1
  GPG 02
 $C %DtR6E p'FCC020pyF21pB1t#209G2Y2% 23 4 5 r 7"3([8   
,[8129A3[
 BC	5
[1 DAEFV30Q 1 2W33 34H35
7@g[D36!7"38'5 9AX3BQ CUD EAFPZ40410+6 4a4`U245a678Q9A0[ @34BCDaEF Mn,51
E! `pEa41a}aoiapa ib{ab[N102'
_C _ADR
 [&   m_STAi `	3p
4ʅ5056
T
C[p)56Ptqr 5 D07075}7%o57EB2~t58&p? k A#59 [#PAK`u5B5D`p` p`bs57eYe` ap dpy0cCdc
{at
 b0zdPx5Czbbtd
qp6pu @2dcrdZ58` dza
aa`{
PN 0afuff aOdu`['A
Ja
EL?

 ЇGA
Dw `xH pd2?y '&Bp}p} 3[A B`60pibpkdrd
ed~A
d hb @brb

bhb1  2j3Cj0a61SD 2`K661crc6}3BbN0u4!wari/5Eab\b\b[]
q]
bu~A]atb
bP c]a%
`bac `/$365SRKr]Z75E
61 }63c)626P=aa3q`ܱ[66@1Eq~_S3 p 4D
eK67U< `W

QX6QX @4[ p9 [A%@ 
"@6B
 a@{^.Dh2BACDQDF@[B:H 
E
`
@[$EF70jQ 1 2r^73aW7W76 @. v77AG7Pq 9 @g7A P]7]7C]7oE F\80F#81 H`82 Ql83

Pd1384j85 
<[= o  @`687 8Af892@ f8B 8CQDp8E`
[0 F	 A90P
aT96`	 З92T93
Av94$
94596 
!
pW9X@`97  @ ~98 qx9A
[! B9CQ 9E FG0A0[#\_GL_"bp
`Ӑ{`ʔ [!
dv`J`!9D9E{hjp
p
HrE>"a 9FbqV[Jp	rya
c}cbaa A1 (8` A2}x0 A3Bhiq`y`j0OPA4
Ϡhݠ7E: p3 D+Bpa(80Vv1(@pwA5\ip@"m7ARPFbA
i9DWF1}7B&$r8C}j8_0[GG6C@:*BaA7
@
[+ лA8A9Q Ag "$AC06D C AE
A`~9`Cנ
p	а  z{` `za 0 
bw
t
	rabC
 1 1
1 )U{brv"OL&F
pI6'B0B0
y
rw iPH2AB}`Da{P ` 
p{z1 wi@{a` rbAAFb yC11	_9`pBw
h ncN }r  Q  AA3
ccF~B2
l
л3B3 B4 Bte {ky
\ B3e} 0e Aj
z4a{`цVxq5@p #b}e
e/\p !	e e$}`@dAy4{k
\ 	``;}qA
 ЈAA y!-A_p?d1p68d pA8"9 9eM@{B6q0fB`7 D adyce@
QTѢB8hif"f
_j
7@
EbdBW	!ba'c@z!Dby
VPMT6CTHPCIBb(p`oAb	s@bB/cpyacaABw'C`CDe  dBb[MF`B9ŅGGTGGD DB6 7#BB
@QBBPBQBD-__PSW12B`k (!`A/D[(0@E֡ F C0c	C1uVm	Vo	o	o	o	o	o	i	Rc	 @o	o	o	o	o	o	 t.ҙo	o	o	o	Ho	o	$N!T%[M 
5c#x(`0833bý
[@PCB /@CC
P
[5  } CD K [ECFвD`OлD1  0D2pD33D @~  ~PD5OT 9 62VQ
 0D=:
cN`7
  8 f0D9DAA!D$/D(D///D 'D//f!e!(.G!G!@($3( N #F(F//M E0@ #F  // A eA !A N A GA "A  "c0EjV/BE2g0E2//.3`03'3//a0%1a0%1a0n0a0G1a0PG1a0@1BEtJ  JHE5	E6	
#?  y  Eh`и``
=`p`apa!wE60E9	@	V`Q	o``EA` a'#B	 p$Cq з	A`v[ODPHIDA_UID
`|E9^^06F!_DISEAx)_SRSEBh_CRS5Wa70r)$+b1r) 4f;c!2r)C EDM h13 r)$ U[(iA 4r )$`k0	jQ(5r)3F{8k6r)71^>8B[!a42[F21F3
r 4
 {<5 [#"GP9u[@KF-26 v1(W 8E,C054zF/8
,Ѿ 0F9 A
LAB _S3D
p 4p PkFCؠ(FD
 h246 ` 5*XEc7CZKFF
048`
{i}`h`{`h@48w{i  @ o5$ q\._SB_C?100tB~ o._DOSq	o4
` a![^ 1}bb ha[7ɠkDCYFC
 G E S=SaF
h3@˚rRcp*r&R%\$C 

 
h06E0FD	8hfp
` {w\/002<O98
Pt1`0D  Q   P Cwhi82?`
hA@ \\8\/	F1 Y5 @E6|6HmI"7
 i 74hj	~ 5hijCqm8c.50h92s 1 0p
6Л93r8F2z! F)9
^/p0kl0^MRdN	_GPE	Ó
pOI
Gb bGf f y F10AF10BF10 #0DE_

p1F@~111`
 2/_REG(pip{015
 a	ia113[A  @@@0140ް1Q5p #  6!7)U8A9AB 11DE mF20+{21Q 2 u3s 4b252678 Up9ABQCDEA130Q 1R333345k 6s 7@,383ABe CA3EF064q4q42j 3A4045Q V
474 Q4A B_INI >4C 4!4E[   I F @C150:p 1	wh
@axa
db`t
@`|QP
a
@}a
a
;y``]}`a@[82Z< azw`
d`xr`
  
@bauaa"@3Ho*o&q`mX+204	<h3 55
q 6s 7
Q8
1A 05C
Dy15E2F
Unknown 
NiMH 
LiIon NhPU
5E z>p l 57!5Ek
1
R58
ha
1D00F7l59C X59@ #`>!}57a{a
457}Q>55!
 
_Qy!6!6D1160a	PAPP qAAQ61	Gp
 D{`R I=62
[)h`p\@I
csc
  dzipr`a[)absdb1/2*(cocC`3	phg3
Po61g
pU5)5E{`egp4d@,C *1FPV23ap1 126 w"Caxra
c 
dcbpbabV5DҒDr	38`a 9a$(`ap-q-5g5I	7
I+Ep
 zW 	Oip
q:/6r9"29cBc D cC0j{ ` {``#IF@5D;4  9RL2ccdp eeez
cpecpci6%4?w up
l5Cp
IBD`p
`Q5C|o21C-0#9T@+q~Nm)p[1DQ-  T(
!z>
>b2(P2pzat
 5[u%*!3(B+BCBH`*qxe(aU5h/Cp	547atoa
ai
b,zch!

D

6Aaߠam34?
@ ra 9PQ pauJpaHf:bcU6h64T0>7U7@ETкBFT r?00 [
6sA
HP   a3A
Sp
SIMPLO0~SMp
MOTOROLA a`wMB6B
p'
0 
Aj(_Q03':Q{Bb񪰪Br4u0Fbþcp
a4E
ba:PTZP6uC D['cTZ3_J
6pn@v
Jp na6E
APR01A 
 1_2V N8EtǠ# Q@
B`^7`#
9nO1169qůF316

,^1
{ (i276Fi$ʐS[I01
72
NԱ @A74бF 7p7@  756E q 8>9 F0!7BA7D7uEs F`80Q8a82183
[  њ845m867k8888APܶ y8B҆88UVaCA
^88MDQB2Қa`| 7B`
C>0 p8COvpi8E8FrA !cEbaDcϡ3g 80Gb paA
FA82c18=Fyya
 "d
b
 bdpdS c
 c
UНc
Co8FB`90 8Bp`kaPΕa
v2C albab`b
vbfyb7Aq7Ep`E7D9q !180#!dCWzj
a1F8W8C= 	1h#'9qbb	aq bmb928B578 ɠ`63
7	56" 76"0
q4
{C039
`{  ia` `!Dhp!
`!K95W	C)ha E0$b cU09abcA@'K96 p^^7c{IX98LD
p99

Gy 1Q91B A	8E/4 P99Bd79[N!$DF_C  _DDN
COM19E9F6
30U"    8y `NS  9FD_STA 3ϓ{\/ f002e3C098
𫠑-
`4
-`p	ISP_RMV
+ dk038dp9ῡ
qF_SRSXbh
PA07A0rq)B9E@
_C
z9

a`e bc q$OxA[iA?1   
a2
_ON_1"3_OFFPR0}A1[Lj{A2hM" C
_vG 0" *
' ~#,$[#42K,
AA3 &@A4b;^,Pr2A@tA0R90AX
zI A * 0
 	A8
r
;0/!)3R!8"s"4x""u"48#2f[429m$i$!P%`$ $9[wC: 7AABp=  UЌAC
w."-1dԀB>ApAADEJH
1 Gxx&xx"q)=x)xxPM No r^r_ _u\mTST1LDR q%QQ Q=D5Q1QN?3?303 <RQV3rRnKDGm3 *o3mbrAaE44@AF40?V4V55 X5Pxqyxp
,]AEF @r`88!]qB0=]75]q&2]qBqq8_B0)B1 p\/0syQ(|`{fx !r@{BP.T QBP5 
[+ 
B718ҁ9BBC BD ;EABDBpPp hA0j BBDBF
Ы0*C1C0&η{`h`?h [@\#_UIJ1C
K__PS0 B!059ߒ98   ["

B7p
&B9`a3 {Ә
  "@uC01C3y FH в aC0   paCҦ 1pF	 _z`
a
C3BC4 C5C6
Q `v1b&C5$ Cl[OC7$aC8` 'CA  CCCD0
G``Gpp +BBlCB
q C`hBu̗C%)C9C9%CD[%'E#{ 0"  y'qF
b@ @ " W[A4
 
@
     *"C1D0`9rra a !-@/A
0 p Gr r " $A` `0Gd d"[ID3
" 0 Dp[gD5D4@P `µDկD5 =Ow.    [-PKD62@
 9
 
mOC067D'ADR   'D8
D
[0<D8v9 INI	,mDAuEBF	C0)W
_	
[1SDp<X@DaECBPDrE?G7M7P2DE p[PdGPE_L1A`aaD
Cq0
w	0PPMG
@@D*
	 *_EJD pB.AP CQ BEQ F0E0Q 10W0E@> `"T.5`qa
C83

*S3Dr 4Pp 1_O iCN

[A

e9 (A_Dd#$#	$20#
		C ,						FC0A6 ,p,0DA#C E_GTM pg
) `2!E EF pF0p E' B1F0{QF
f0EE!FMhhh~Fip]p
w 1>Pqa:` `A` bwb
bw`
cib ac  rb rc u`A
2!abq6%
2cF2bcpoED:6 !{` zv0I([$2 FS &pLEq088Ю`0i7	
# i Z1 8OD9ODAOEDOEEOEFL`H\_PIChb\/gND6{MT MqK6E

Q`O'  Y 
Y
CJ@ #0$ 
 GC3

 
H	
Qa		 				`!	A	5!52# "cD
%6,!q|!WG!H Q J !G
. 	!A0;T66@	F
q}R  RVd
d
Primary 
A   
LIon 
Hewlett-Pack?ard Ey?Traveloka	5~@ Z4-58L࠷63	00п63h`/` %
 
e
" 
 
ݤqZ66h1F6PBA7Aˑ10m8!a`uF6"٨p 7G`5t7
 _1 
_BI Yap ST <|CL\][Gp6562AȠC)ocPrJ@6
ACPI3.	G	0R/005`D>058 $Ja#p}0L!58[&]PR0 1o=81``[T֑:hP@$
LI ["AHP_Tab4PC_Buttons b\2

F1
	/15?@SXr)N^q'2jRB V FC 
ЎDPE0kpk`qh`piaFa
 ?яCя
 a{`
 ks }a
a ak
 ZkЋE ѕD|4 pFB   ~*FFz

 E` `2^`@hp}
yjZ   >qb1h)h`@	F}` ibppbasabcpcau`a[5C20{0P 1
 ! `b  ҕ!2I<03P4 R@5 q6@7	:  p
`
R P  r
` aɊ	8 9p!ee[wre
 
AqAeA2BpFAILОqL)~ASECUpeAMA5ASp^BbTxrC}UDRE]uF-3tP
c`10cӡ@

11
	r2
3jR4f@2Oap `#qt@4	O!5160117k18"19iA
EBCED4n!  ZuA//SIMW@21wT__&O)Pb`I"+JT7 aQ=1 ``0PASS14v#A42>1aOQpO7C0P p`4Dap{	 aC4CpLRM;Fw2PQC7a0lbb a⃐P b ub`yNq5aEH@/Пph<{piJ20#L21M2t0N
qӄAMO2pq 0 `_WDG?
<4_c,E=DAAyB{M4C~ !f )AB WMAASij=DtZ´vp{6
j0D?16{h
`?{Տ44Pip,u`p504722*54
[L  \p_ 17 G!@@A
i ,9722(1n#<0 yT01EM 0E68a{a
:}@` `d`I~(a&!	0F9P*	a9nKO@R1B3:Ϡ0Cq,14A6
b7ཁ2!_!hxο9h	2)A`;
1?;!m sqV2&&@53'&R@15[4h$J@84
@$@ 

p
1-.0C=ep
ob*!H71I62 Ė s?	p
_\
p
_3O6p
o
)_3V37q33)
324R5D^5KOV?C3Z  m) ;)!pM_WEDsA\AZPвUPw\Y\P[r 2^r0`WQABNFOMT  m:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =D&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(^|7ȑG!&((  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?߃;L0Y<͟{$a|lCAGI!340{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj',03[5

[  26 \C 
 +18_INI` [j7жA[27l[#\_GL_yh
 BpiV!pjk@E!04F\C0F1haF`	l[m'['`"/8
! m9AB bCC237BphBAAJ4Bq9p{zh
 Z ADh7	k9 C 8 C240CPo	
C1BD	P[ED244_HIDA_UI  45 6 78 9|@w4A @	WB r9a"4C4B
[ D@(A4E2F h
4F@ 5M051@50UyA
	`rh``v1ߣF@`c daJac
p{rdp b}y baya
a0apac peraye
	 evep}e6c ucdcM
 
}3A52cpc  bpbgC	bdp apbe)ec e ffg
fape`pfafgvdueA`b޳6` gTb 	`	$b pg1Eagg7agub_dM 4,g05A ,p`!p0`c`bQ7 8` u`py1 C B  D "h 6h H
bhc `r Dcada
e,49-adft`f	ru>'adSuc2ftd gr:`4bA 355 F4Q -91354`Q&9aqD4Aa
LBC060pibhb+6p0<56rb
UD7
j178"88"bwF@09 w6
arS9abpb.0+bϢab`babuaaP `bua/_CRuSQAQ19`vC2-pS`ZSTA t
{`}``6=9XD!

	        y q3A` `[Kd25BmHH
 e5CF
RGGP   @ o   s3	0	^  1	o[Ci5E}Q [197F
rG G$ $ GN N 
P P Gc c Gwe e g gwt t     p
 A~-\/[	C7a


W!3p
`q ^^.C1716\_S0_O
 !  3 )   4  5   M\_PTSph%_37Hh
 Lh
}	0z1602`Zb1F 
 6A {WAK } 41,092?010A&10C@8bR 115a	b46qTZw60~ TZ1_
 2 15
a8
 005b|E

OrFacbcc:c6Eo
APRAe01 
 ߀b58ڟA6C1EC
 `BA-C1.L3n4,2"0{/J\61G,
@
|
0Q 
b [PA	3
	40H#5

6
7380\QAB=p'C D(2W EС:16D
5 +F
1({!h ?# >4Fil270
pia p
"?0A50$5`Hpa_g
D1
hl6`pi`?`
p
Ag#i p`OrB72p`phah.qz6Dikr@
Q! A#3i ` aP6VQ`lP iQ30;opKALA(!p
   t1t
axa

`b@LRA0

bts
 2
<Q


	/s
!
P'OL &4_	FU@&Yd^d+Q[p{42 -{b
 t bbwb

araMpLabb1ReT17fМ)ar&Bh 1Q'C' b#y
h`:I	{;b  @pui*h aBw`%  1;6A<`/69' DQ?5`hm3_
cb D*B
40-h `t`)`x`f3f={tff 1tqB.cbybs.b&8!9bbK	iv

ep_
d
M drf
g&5d3A7ef'i26g&R;wP/3	-`abIa[B!R6``0\
9_ON_  \RbZS&pFOf _OFF1D7M
O`ORmC\H
8
OfOt
9
O"mOz
[7A"g `0>P776[" 5W*DH7CC Ԫ8D9[H_ALA 1AsL2	AL3C
D_AC0AD""1&ЗB2Fb3f0PSV6SL,!GyE ю4MrJ9F(^qq23L I64pA6 $Z6SQQ5_TSP
dp 9T`CRTv0/TMPP7o[GP1FV80

S,"30\/$1I\_GPE!
1҅O
_L00 tc0A@ XI{` 忠{`
a QA` !0axӃa  eDa@BG1E 1 oC	{*679   C}:CBC0D%o2}CCE+c
@ ["ݺBIO	C	B	IxDO	fO	CE["k
dDP3o4F"9 HOH/0*_0o3 S/oHB$`ۓCO#DEOL_L17 !82?`}8@24<9g8
w4P31DEC@ EZC5FA*4
@C2254
-201p+8?VLeG`836
dDP`F7 =L98`pK9882unL C  `qN|"00w8ID#"V:!6E_\36a}`PQ%.9UDp(F|cu9`@b'0??5`
`
O
 `KE]%		@v4v53197Aq-[] *
KI
_!P!}D8D8Daa`r 	b Ec.`k '100{a +ccMQ[@6 
[ 7pa)?5
07I|bn1ұ&1N
a04d7 o,}qD i@87``	|a)ApۢHc
/1Q 
			gvcv}b0TJ F23Bhq60 đbUT>/SSDTqЈHP  HPQPpcЉ  MoSFT L4P8@	o1  f   2  #_3_T	_ws 
_	Oв9wj
ara
aK4aAP]B$Aijp!8B  AhFI2EdJ2Fv 28C_2>$91o JVP30[31yjY2pz҆Z3p^j9Ā
D`tQa~bb`h88a bub `(37Bt2!h 㴤E40rBy1F,/
b+`1 {y U  V090'*[!1"PDC{gh 91PCT p]91@908F	_PPC 40Sq8E7YA7NLP7C_E{J0`DD`pA   ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ  _     	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n           VIDEU[0  @ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`. aP b  cH dP e  fb gP h  i|o jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0 
b3 _DATA_BLOCK x  
`3412Intel(r)915GM/910ML` 5MS а Accelerated S
Build Number: q Deva	09/27/2004  Q01:16
DECOMPILATION OR DISASSEMBLY PROH?IBITEDCopyright (C) 0-`3 2`rp. All RAs ReservsedPa@  g  $	

 ! 	TV׾D "LFPiz(      | 02468:<@BDFHJLPRTVXZ\ 9{   (  8  [0 _ @ Ā ( e/ `ࣀ _   ӕ@DԄHLB  p_ ! !Ԓ        0܂ 17 3		 ޽ @>   H `  |  `] =  # 1" $ (
 5 V}          A !  R`SI-1362-!Up _2  @i7 <cU
 x 
	 Z (?-  	Q    e	>N Ia(  QVSC dS?4O  
`	 w7 c<  \* 
ZcTZcu$M
 23 ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*!P @ X  ' 0hPR	 `"c6 X  1X (a$n!7C	d @A &066\ <0* Q 0@0p
wxx Q@ϯ(/x?Q&@X!k @H?@0b2@@
|/d  P 
00 d  @
%,@`@	Ƃ
)(<p#%%%
 PB. $< 00C"2/<@PpQX 82

,{ +a ?L  Xo o o o o ,4 Z  UfPfVfWfVtRu.t
fF䠆   w FF\  耹*FXF <uY=?}Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^~pZffq_f^f !;F}Nn߈^f~of~`.sf~ t$:V^:nQ:ND~tPfFtF;u )  
f~v ø t2:~sPv0v^*fދfV2fX]P!Rf3ffZfXþ   
@|   @M` +sw.2 t 
؃p.	 
 
f.aИVW6 tM r/u*B
 tVff" v f..L^߲ .pff^3_^28ev t&B1t1U
PSRV<v
W_2G$fWb  < t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufRe.u5 P.f
fZ
fVPf!0% `= `Xf^2dfP r  mf D 耈f ;r;r.T" 6f"2P#ESfQ@tfY-ffXz@G=-fS fYf.; r$ )[fVlu跦8u p+^`@H b,VW7u%f-2f1/O%1f^b,t$5&-rp%ufÂ 1fQf"s UP/ffXu
RJ8Zsfn5b1J7uf-qB7c1q9J1, >1AJQ9[Q,tt22<6	<"tR7Zr.
 @) j7Zs b	4.#_tu
 `, *az@f ` }uVu0f'}0 0"P.0nroooopept<wwyzi{
||}{!' < .  @[ &a[(8)8U!a*d!e!f%g<#h?!$P!fWU.64eހs u.Hw.p p=Ou
uοFa=_ i %)6I=OuFt=Ot=_t
=OtPfIXOuF
_u pt n)]XZ-.<t.:u.T!_F`.a   .aPw2143  p;%(VFE ^(p 
Oq  @=,. f@-"-u
/-F t߰ f#00.fB,fP*# I"7 n.tJf4%90h,fF$ 6+6u 2c0Sf[ u	uN I$Vp !"%"P""""	#
# Ǿ!%A!-(u, xR-̿rkPPt(0.u\
?
^qP9 2ۄt_q  P'1\wSfr/w*]'u{+`	,s`!+
"	Trq&s
!bt&S
[t t fM,ru%B_		l?s
B0(f"Q(*fR*P$8X$@
؉b1	f`2e(qQ	ؾf#.8u@rin#uc]3ZR,pU
 )  [_+a   ufj) + ff_UQA3+M*޴Y+dZ+4+!cuw'+pzkr{`q
W+faPSQmQ	2;YtlQ
 srYTZAQDtp^Ű@t@uY*Y_"utH/r.D$tt	Æf^ZY[~Sv w/u#
 u3 /-"ba@   0@1ʊ7 
[`}.tN0˶V uf`.VPQX	.r0 k%.8tYX^r
gf&⢊f_C	f`	s	qt!рtSR0Z[633xu0KbP<='$ {?p)|$'[ ?^X!&+&U$t Whw.QYS.L2.pe
QPfY
8Xt+$YI~Ц+.W tG#t
2tPS#[;¿Xu)&t0uq

uPSϊߋYSQY[r[o/(cQRvPu8ك zALtS=[rt  p#M2,,`U 0#;˯ qF
1Gs 0
p ѰRB	&Ыx$fS :8!ux'%PQ`UL%<vYX%r2%P PO`w% #`vX%	#XTw#@#G.&6
?";a`mzQ4
81w?0YGpoò_&@?XrPu(s#}0 ѩz Wf_ V.4.tf^0^0ѱ m0/D! fs'$t#f%@ }8ue? u̲t,rE,s@t9@ ̀C~ &Zf*ɿ3fK
f^	 f0ڸQ4,ry0S̃>|c ?e%YE# t3!iakʺT%V1`QXw

SX$w
؊"3Ҩ 8
?.[ *o+++;,_,p,,,	,*R{h"u\uS"u@$#P"BtPPP!(#fSf[A!#Xa0tX"dab!$u  Q.20;YrWot  !fP$ff ff3g&fGy#f^%T2#QB #Yӯ|8@!8##p ѱ2U z 0 c r	g Uw	t .:\s^\0W*.$tBuIP⢛  ^Xu,.8 #.t/s!P~//XSB#[dĀt
 Sg+r!0ÿ
"ff" H'`k&r7
f^&E$x $ 4.{
f+أ20t2p/fPWvPJ	&!QPYP4,̠4!2P`V CΦ! T !F C9%$t`u@uUtQ!2I's#f w<fQ%yxfYvt&w_u!C;Ht Q>..Ͷ.G$ r
Q2Srs[Yr
rL rQjY߂\PPtª<v>rs	 hPfWjrZ, . u.Mpm2ft!"SQP2~Y8[r2QA÷sYf_XSWJ_H_[drFsr?
D
t+8t$P`ՊX8udѡȱ`ʰ8px3
a >i	dA0`@4C&f ¢I]Еu{1
&&Ks"*f4pp끃 tހ hut
ъ-4Pb$
u$XB	X[	3`1
>J~U^ FVv
nB]FPW s&!Gt8uXuD>L t=+pMs4
й @B8e tC:er3vD6e3UX?&2VS2.6e3RF8r *[Y22@]F]W.>>et>Àt&}&t2,(-)*.)` O4eÿ~<v<t
ц<vєÜȫP 3bN<w<?t0f`u2e*s
2&J&P &L&ģ`&&pK L`  a3 43333
33344454
sIuM@B? &<w
2RtE>
tH&38pl
и 7a3۱R u tF@r!tu!WV ^_ 
?GW _uGG zd a `Zj	 QIڃ. `(.[IXuπð/؁YP%@@t	pTF}F!Gpu Y÷sssQS&G&w&_t0B JKu[pr&OP0 &
tuȋcPQV2
$̊
FY^Y0_ s0&G
Pp&?W&w@
p߀?ZotHH,2۰>tr:osr&9p,uh_ 30p?o1 

$0_s'h
 4G__.>`;`;^9ëp 0&$F@e;	@su Ǻ ܺ@+o߹  4t<v<tP&X@F20s @&f` P1ftJf &&	7
aTugQc$_<0tqZt2- ku "Eo aE1^X qqyߊѾ7P.8u*f{0 @)z"}aq`A(  `	s63ftft\eU} t$D ut' $dc4 AǀX$1>&0 )1VWS t߃#`IF[_^ rZf fV 2~Ê߹  r:<w40r*%uf21Sf[fPDV@gs05`t*Q.LYt  u
"8ӻu^ZSQ"s	.So[ Yrߊ̀vXq̡PSf #brcŀtʀ tO<ЛrCQoYr?I`PPf;Xr-u f.;vuqw	 `r_aYf@MRVSӆit|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ0e.DYXuP!
~[` 0"`Rf
2f&ffȐX&e&} ]@.Dufѯp0 tR3Zt	pp   t ϐHK%Q Ms, f+VmwP^ 	X^[*0
 ^94S
9B^HQKtE&gE`JE aJ ^oxйLHKDA&< <  I m  @   	 -`pPPд 1-l#PSPS +׀ `3 s<s at< rj7I<S<.97H<r[._{E#[t/u..s߃l6&=	r	;v1SSߊWм|@*t
 #u[[_[ø RvvvZvxЖnQrg  0K YPVPV<v	w rL^ r WffP@X2A5?$_@lsPDl

f*2L<w 7PEXffsfB fߋ^
`p
f?3f;w<<R i.8ab.<usv@C pQ2<v+<t'<v! tƐtN"DS_polQf
QPX@. p
.&R Qs] P;sf0  w| YrVgI^w
PZfXuEu$Pu
$0VW#sB d @&|&\CrwP#
Xu Ѻ	 Z0
 u^C7
f ts    	

#
Fr=.t 35W`@`8u
X@P@_2.@S6&[X<`r<qwRZP$<pw s2S#(S[2ۀvESp%RffZ{fp 
[pmP =.c?fY.1snfARm	Ca@?0xa,0Rb#MQN[sSuNqz5u߸ `2,"y:.F+o9sau\Uص÷ zMي3
x`@!2 g80"
Xr+5}r 45uUǋz% 2BVP3Q^5 M3
N] `WP1PS ^@0[HF`ۋY.6~VWRr;~s8 ~JuZ_^N t0S[_`\w
Đ2110CVz 
  j2r@p  _2Ph@ & PX60"2P	X uA0`2RߋZ !Pç[ ؆! PX PҪ C"	ƀu̀_<$
2`aesUDtMrEWfV.4.tc.TP&} _w(&
&Ut.9
u.9UuA>fQs^r
\/ r"DfPP@XÀPˀ  V"E`fa[f.Vf&f!u
$'tPAf%`b:ahq`5j#t
^tXqtftY
0t'u-`C1ȵqZڀ \`^PreFc4ܩPdpЯ @pS P P ?J	Ӣ&/	&  u"A#P
	tAfXf^r s  r߀tХ̀_u
_ma<XQVW_^YS. 	sK;pM`0a@s  Cy B jVS3۬
t
<a|<zw$C`^#V    A 72PP2@it.:u23PV .^f.<Inteu   	  
 	 RaPa C` PB BA B;rXa~s  .oH@uSb@ uP4[.oHBar+ 6  ;`&  f}8f%f;19RC}`VPMp 3f.f
`+؀nҖfAJ\ Iu	fSff@ܰP/]sPa 3{WI pWI^YRA.WI0PRf6 0.df 
00.DPR.ff.V` I .FFMȋF 
tJHa?  ׉FACFARR A䀀V@`*
  )]!9p#~1_$<AP-<uX.>Jt  +.J< P.tfcARtsZf²Ĳeg|ۀt5r	?Hr2dR]ۀt¥ `.ȃ v(.жuc.<s.tFbf u.t-.5߀ut."pe1
fQ̀Y   @FV *Os`5P@DXe<DG$hZ0kt	jf'`p- _P4=裂DHPbCCot!N`	DM 4Qbb< PrQQbU vhдS+	3TQgQӡs

rRR
RZR   $ bPBB쿊CZQ
Q QQ0_P<fƊ_$f==fffX°"t
p tf0ZYQ Q `  	Qϱq` S{
 tPP첺P q;4P U'$@``` ЖS S2  1dQ$d[$P50aɀS
S` 
  Rf`
 P`P @8ftsrg Z UdPҩ ` ğaܟPS""
[XȲ"Cc^p!%!ff6QPAQ﵀`  PA%
  wfS%f%PŀrЌ}P tn%2'ff)f#ff#fSahfA(-S-('RA'@u_ fP('fXӋ##[u9X.=          @     @QSr|wrwKH؂n1 V ;v7 xֿZ+q+±2\\sRfZf+`faf GU`F FFP.8\uE.T;u2	u	Ff$ f"uPfVe.  ^0!

uC⦾DD?  + оA<u /f^a]|s(1F3Pprif^@=wA@_`SRWVPtCO	r<.|t4.Et"0t.\Q" YsÀtǀP^_Z`UЎ Qs"0f&;u Eu&M]p ArA	ȋ+;r1;r-fQ&
 8;nfYuaSR sZ[.6P.8u.| P.;6PrSRVWr;u6wb	M1 	_;^ZV3St Uu2
^`WV_rGf^u4t@u&u!SQRP XZY[s`^_X@0`Q  qQ{,U .8utPYf$ADDfIN30 (>Et_'WuA &Ѕ1/f^T4r$/<t<R?r~f&?E   3@zG$<<<f RVr
.|!!^`Ȏ؎ `# t8.D;..\f^t@ 

sV! 
r.PP

]aÿ`'r~yRӊP` X Zun1tQtLM4s@Ass45s
7=v<?Wf_JJ^uS6BЅЅ<}P't0BN-C.
t<2,!+t.
,G<|`$QET:< PW4 ht@YV]6ϋ6`1PVH9""bZl@#u;ndWfA6fQ6PrUwP2B#u[< mk EZXYv]_֊|PǿXt	+t8 o  d %-|Ph%pM  := f^Vr+;t"s	Eu
< u	f3@h3[pt#|=p@fpQwJSAH[8 rQZYs
R sf=RDZtr$|qC}Kr. u)"XбbtkLUsqPSQfVQ  rٰ6.&:
Qyf tFf^Ya`s%(T?sHQwf ݽ3꾝0QѓsxuK= w4 w.HKPPιaUZ;v| Q+tN z[[[[ twǾT[`P÷ p  wf~%L t@ffRZXQ`;v
t
 
 
" p0ƒ΀wWRZsNp/p  .:?u0.>`(bJ pZu.n2`Ґ0 
30;} .	fv?fQ
P pZ
@JZyyۑHp	iAZ3f
 ?Q1VWfǀvf`K1ZP	-ހrs$DV)`) ! 	
PSfVPMrA!$@uc] .@^PPPPPPPP P!P$P%PSwf3]˶a0!{Ct3`
ނ(ZAt2 2h2ۨ#?qfq 8 !)} s@PWvijRfZP[tuU  updsEjtz Rs3 @	<wPpXs uPF !Gb'_1G G
t$ 1C ]#;tt|AqjFGo R*N_@uNQIM_____``@sþ_-FF3F۴ 6.:註Q0Y 024/sR Zk>B p!K2^@7 V```aaFaaa
4`~2C<vSƋ[tq&fa/ q'@'fk^@T#t,x
<pŰgĊ~,+ ,2s2Su; xx |s Z þ/.0p Ϳ ȉNcfCp7: c0Y ;f P(fu _t7f<) i!ff f4Af% ;WF  Àu#\"dnR \gQ-00
Őh*ab_bpbae@ Wf_fVBE/fFP﫰zA
@C1r0f« f ff+À fG
f p	4
zqf# $0-p8u2uA\4 c/ctr ޾ 2SE4
/Zs
 u6@$ .(vӀ۶vu
RSpڷQ[Zb[S 3ɶ6u6F #Q5$d"i@ PQRVtHc.? pVP<	觧r`9f t4W_s)v!f&y=&} u &G
aÝ`SasSRZ q{3ҋʰgrU]deddF5
s;pw S.)d[,JP@t  5r=$ ? r@o{:Hp?7
cr" ^N2$1`8t\tCf	gtwAf@btir߰a< tA@CӴ1a[PMIDn_    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS  Cor;poion#~ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq  5  0  2   fg;iiiii7j<k	kn/daM`bf .<t.:utOFûE2&+]OuMWPESAP Ÿ@efefP@fXfQv4F@;t/aQ@wetf s tfffYfS_uV f&E-  ߃aXðQ .V@Ύ޾eJ  @e suVoO$ G֨_  u к a^@ @`^֠ ^_n_ի o p﫸pՊwfۊơ ܀rf
P rf@@f2tm?QRf`af3ZY 
LՁ
Պu9
mr;g$:Iͤr	 {@p`O%nN}ӏͰLrf
VÀ>Ivm@wdtYw@t$;wR?$;v@fc1q t@~`3xcjjcjjjjkRۃ`܀  )j.$fat*R`@	蠟ZP	XfN Hߓ ~


F wf f` ta f{I | B0a~"_ $y+Ca6ӀtE#>âw1gia% _ftԛt)vGwAºBffP S ǯBB젡T 
RVIӋ_ݺ P!=ݰvp,8 t3
9P%ҀsZ2fQfBQP
fT0fYR CIR[:Tt` uZP̃XVD u.fD
f=8w"Њf`IR VfZ	[D^ÿf0.E.e! *$P	P0
 +$pE0	f .4e{ fڐ	߀8u{$?
!32IBߨu	pVr
.
 @?$
ÑߨaV.|^쁓"2f^PP>} t"tt+t.D/@t au V^r
ޠ
2^< <#t2 <"t
+ <!t  Q`u7
0Q2ъȀ
ufPqu;pusY@>݋иO O sOYˀ u3u"*D\讬u> &p`uu t kudu^sY8s
tQG8s8s8t3 t-0vv&8swˊ
r*ˋc
qP8bu J NذrPÆ2/ۋ<q`R
tB@a1p@2$b&LN @<v0	r	e狕P鑘쿉F ^Sr{Bgtw%gvk&J`֋&FЋsBuՃdr' wP酓zu$0<0 t**F 
t*02P ؊֡	a>`w@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQWw_YuCW B~~	2@
2@PP *ڀ n@
  toʋ?XZQ2	/ ++(+t؋X:  + 
"a݁{BtG:#sNOFGuxsOG$	B y*2n10>K , !?+ 'k'ȋP&1u'D`'$4$p&z  %2C3, B"pCR S w؎
]ȑ'Jur&^=ց3Ju=>wP67)4&	55Fb1QZ6c5 XqJrv
t-r^ <G!M`sw r
&XtR٭נQqQ0QP2GtB2E tO FƮS ƯPЎȎ~ 0u.&>| t
$𻋄c-0@ȱ\/,ppRC&PD+(2 _6t
0su@a#Pb0 2&<u2ۭypWËUƋ0t
Ju]+
]Q wLwPaz x͋Y$r!v$$:ˀu　?600Ql$$s$guz
o׫3*48*0*^OFH,G}`/$ְ /Ë?*) j
y$6| 62 u>
xĪm?í&0  &0%Ê)"r>^!Mu0+,GY3,+K'B2Nğu9@ZZVWѤ ts
҃_^GMu۸ ]3@ø&C$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>fo߀  
T fR@
 F$
 r7uɊ PW.>eu>&}JPbQǪ_XwLԸoǀr#Yts-" (&"%
Ī&#Z
rɀ\sي
u7!~y@s
x`ALuͿ1x  w 
pd!! esX @
ff

W,	0	ϳ2,"yN6@	@	ʸ (⨀Pbr$$pt<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [Dorp^ʊ3?ɸa~0
uVЊdЊPSQRaPaDnXaZWY[X|*v
܀ՈF0F02<}:}C}\}}}	}}}}}~~~&~G~<s<trtt|0ù 2&<F 4w t3&ee!3<
EQ.~T  @@5 ß`P&0y OuËÀ8 0
1>ǀh  fnNËEϊĊNuÿq 2Fó π?} Q ` K#Nu	f&K͉DSRP$?.&\~RP ^ `~[[c   XʊZ[PΊXPvXP) ~~~~l|8 8| <<]<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DD8[p
~~~  Q  	 0``0A$BB$@

V` l$Q  ll  l ||f6j 8L8xz 0 0```0 @ y <<fG00'0  || 8x~ |p <| <l |ƀD |  ~H  a00!2  
x | ff|7ff    bhxhb `·~ @< p flxlf bf  ΰ|`Ư||~Z<ql)Ƃ  88l#<2 xp``x  x -/0 U x|v `` p 60x00x3v|x`lvn 8 1̀b /P7ܢ-T| p| v | q$4-4 /ll3
6|p&0d; (1B 00 # vp?&qp|8B
|!f!&88 `x`:|~~ ~΀)".a0%||`l``p9PH~ w?p

6ff+ 8<}448ll8 6{0` BU6F{ \E|1S6ll6W~` l  "# {U# wA 4T d  6 dP [ 5 NOqP_U1UQ2dt770?dK?0aa66R9j a	
Q R>     tv Q@bC8~llHO3O rg8 s 8||`rTXl( <"CBfa||"|DPh"  l~`l~ Y%r[&; p0jo
G<8p(5ly:}Xl<p&PlN~0QEP< cSld$DtUtZ3ZNTvTu W32xQ|2)
xpbn|ll[|}20ư a4!֕BP{ |`Sl8>70k B @sV &
񉅇R`g#Z8|||8鋊;ff""AR	+p+q`llҒMv	܃od  $5)/ԑ#| 1DVsr  @Pb
1upbᔳ 2ES67
  ц%25R$FPB@S9byA1 `	Q$(f  PC=' # 7%7@Pa "D"%
t@Ý
0l2`6$6~~$E47㠃#
l|8@s3OƆpb#<,00PcRr-0Lu;T 3'$D bZЦe  1d23]%@`aB=`_ ְr;b95Qp$R "ëBfӬ03*Pw~Ry Ap otmeۯk5̓Oh0xӰ`0HH0i ! ah tC[D 0fAxxAcl>j%Uڨ	%SQ#xFΤ W1hPr`xC0q C'7!1^ H(F/`1L!#<0[<\Qj0FespfS_dx0`ܶ=> lܬ>ҚdwD) ew) )ü ut  (Yǳx 7ȥWU> T 4˳ ^S̅d s͢Ͳ5Uc 	&
J TӄK$%҇`Kӧiso
̓@"bRt``0`&"bct "1آ1vetn v ||@<`p`v3 9 tt!K pܶܵ*$1R3Co0`
7| / %4 FU}' 27Whu -7tu #8] /䳔TJ}800% 7]i4&4Eb6 ‸ <Be aְ" 8Fdv D%Eu\fRU 閝\
 5cх ե0&C`e t% EWu % Em  'D~+NWB^ ]Ë
  1 
Met4 G= &tDftt0
"$d #$%e2 3401hK"r5B Vgv	! "f,`G'aw D 	8Fif. GeEt8Bm`lx@-Mo 
/on 	/Oi .Mm +Ok /Im`tܠk$5Fpctq =FTfv||6<] }RRfyѯHU<9ر p>| o` ,4@IXg v!"ť#$0v?ѤƢË5þц&) ~ð 	!S P   1 0 a.Ԝ&6| &>~ ÷
*r
t	2.ò`Ϲ  ~   ц~тє! w<
u&| ϲ 2.^FFF3ҹ `P樸` Ԩ ΨȨ X  * : aQYSظ s2t  [߸{u ic
>ctSÐ/    ^^ >I辙su
^ t 36ȢJ2 Lc&>Iu	B$P
	JX̀v`
p uH-ب <ĩ_tQ @ rw
2F.Ê.̀Nп$F $FF.q( ک _ZUoȨè<w$u 4$
p À0&&_WQ	_@Z<ow?1 A tSD[
*!&VUNq<w4#@tÂ u5Bcb?ȫFt#!)#
 `԰8 u{ 3ҴugĠtb(u]̊.-ŴQYR  
 8 t$8u
;(
=
28u2ɋZ aR23Z%t<vÊ>bSu
PRYNVQ~ċюF&<
vu^Ft&FVRU r̒,]Z:Jr92:6v/RS=b=P [
tZV t^^YuZO[
<t<t<
t<
tx@(` t
t$0<0tur ͉N`u6׆s%&2Ft0 u*ш)s&:s2& #   a     ? t"<(* II `ga!I<v}	.ǫ.﫪tI<tE2<t?<r<v7<	r
<v/<ov)W  WuCt	t`2êSPm@X[$t   ͡ъ$g`Ip
P4
ğ3RQ$2.>euZ&G&Gt R 
 &_Wt%
&;G 
 2    _ @    fPQV fVf.Da 4f^^YfX< !!ȭ14f3f^FFfPfSLqfa#fbff f Qf% ;ëu@[`PSQRQm+YZY[Q Ƞ@YbMfp/Pf.}.7/
CCRRt!Q̀YZ蓟7t&p
t&wG  x    b2
f X蚠=Q3&&Ϭ&I1f P tQ | fYÀVFF30^XtJ՞QF	 DYPRfW#0f "!fP   f3{迀   0K@P sg  ['u_ ^P
Dys-pCR*  CA	  
 f$ wq	y
`F0
!3
y1

f{[X@f_Z) QVV԰?^B*&5%&&&^0 &T@pRV0&$F@&F{誜  PX@F2ܜ q`^ZRDMZ@ h$Āu[Y27V蕛嫊Nu^D7QOC7R虛f<Z4QfV6qf^Y55`4h s4?t47t4\@̗4c464
åQqc22222222RV2B3۾2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              !!!!!! !!     #v1xx">Vz==8f=,=.=d@===H=z===y==BH=0== = ==
=v{f=Y=[=O2%>DU>.P>SQ0!2t$L-`}$Od   : ,ĪaAUc	PCP@P @ UqD"wΗX# ԙ0] 
gh2  ,h	PX^oߵƮ`. fȎ1)`.>f; lf3AHr(|$utD rq  m.6rӄPgTP r   r{Wށ{
 g !^f t-
f&9af&_ M f+W?. T&= tf&m)!_qffaðPfq EQ M y aR $fpf	u(ff(`m}p r} tܰUl pAw<f;%+"l r&;f&_HIBM
fHQf=ؗQ
 r2u&} s
PQS-[  <
QW 
 ftV`^tu{A_Y `VqeB ^
Dƣa&Eǣc\ ;v++\P{=;6as;>crڿqa .qǾ覎ñu6xPt'v %+	@Px N ð  t%u7m!Pfpۯ? @6 S衖[ 虖[ f $ADDIN30,ϺVͻ AIM3b0A  @ X@ Q Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Ef.>_ v `pݺb 0p8fX 2ZY๷2 о0sbuL.;w.;v
RWfVvTtOBf.G} u"Ұu0R j`ZR Zr
`
yf^_fZ fV$< v99fb #Vg}? s1 3LҸq_S fۭVѓ2П[S @t o3ɐRW칀t
_ZP9.$ W4Jv0_ `@n$<u<.\.r   PXfTA2f`1 #`Z`@.&<
UKs....@  "PO߳  5bOukRK6	~f.d..\= rw rL<&]fff.	\. .FG@ P	3@  .G$0<0u.afVf.t2A.Qf;P/uPd H0gZf/^[ ~Q2fuf؃ %	 ͫlqEd34UDpīĳcŝ
D	V  AY DDPU@DSDTY@ " HD|   G? 	  
@  $ 6 d_   IL  J ]B 	 @ , "	eJz ,?,Sg[ 00?	s  i,,


j6Kd@Xkl 
 
PÖ` q@Q@kQm v lC q \ l @AEq@k6
-2-3 A  ``_  3 dj 
=uz 
< FL "Z  L  "oV 
u
 ?E _S   
E 
y 
O 

SZ ߀ MnE(  02<@(@(w<2 3 = < @3`= @<`3w=0; 3 ;1 0 4 >`{; `4@>w ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9  6@?906`? 90@06 (8  7 (`8@7   `07~?7`0r `;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 0=p    
>* *w8 1 g)  @? 7@1`?*)   2 )6@2*)  `2@(v 5  3`w`)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3~ 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0=H`)`' >H )@?X(`$@#a6@-@6-6 -,5~,7@-,@ 7-@,4~-8 .+@ 8 .+ @9@.@+3`*:`. +@3: *  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ @? /`61 1)/)1  `p< < + + `0* `"ú0*  1X (& @A &06DPѐ  ]Ń mP鈱 f%Ѣf=u˷XПP R@efթu= w
`}w6fQWP3܅tf
@@@$	Xr/QYv
wfD f0W_{fؠt
!c@C"A_T2. t.w軇f7?0<1̉@ൣנrWRZ_Sr3F!f%SSpt@f
qTaf+Q2<n܆ `2f2!t&º2"@t f0fXf^q 
fш"[ @:=vL= v^"m@RfP0e
ڠd+3
0ub(  <  wrP+ Sg[0]uB1
j  ! R b r "2B !Rz r [   dteuVfvW V
fq  %"
v
=r 
~ #¿ %B
  #  #{  }& & F $Д e Vf W ظz@ о?ǻǹP0 	߰ǻP`S8t< u	[X󭿋ج@0F f fpG G1w^0 u4!+ ^_ع  `J_ ^V @uKfRPA|3 mX{/ ΁ J G!OGfZȹ	 .8t.L
ǃ	!p91 SQUT;AfWaŅf@tXa覅b¾Z$̥̉  _ͼ    ʚ#ʡOGDGoration Generic Device 12 A N@1f^t" gr	c@a	ÿ@tdaQW&]rfS+~f[r$
ط]Y@00  @  8WPXEtpD(2f Yt2Q"Y[Z jAvdlaw{wuLff@#
M[ZQV:˹,t.9Tr.9\r	^Y 8t&;Ew-&;]w'f0PYr;Crp WsQ@sVfW^W &  &E _^rC&E
t{&E&E0QW  _Y@f趇fZr
4ps,i_^ t`mItuȊȰfu}<u,."/\pE QrH&
qqEq
	.\Io膂7fX~{'_[5  ()bc./1 24 7 8 :; !  {t	M8 Y͹ *m͹ !Hf2~QR?ZYa [<Q+ +
P>SQWO60#t&#E_QVfS zt!`h"2BRbr#3CcshWj[zV  6zu	 
 fftF.vfSVй-PQ3PFffs{f  ff^}qz{~ {ffI  .`^s fPHfXϊsfQ@6Q@2{tQ^qUۄs`+e6X%P?q_`f3*r`g}fe  7br   _rO8 9 f&] R     ~ f&	Ua WIf3fƱD<	t<tQ<"tm< c<<<<tt    BfP
-B?p. 
@@t^@@"f@  ) ?  9 0 f@ tϱ3TX1  f&U&]" sSY t;Q7FYd15_ҩ2Q
ffڹ?)r'z}SS
S  } P`;C&]_X|RVJr.|QQ.S6[rPXff_Yq6fPp )SQP}XPSe| [#w[ \n #
RSL[rS =ArIr@	yr9<uu΀t"tt
rfPfػfXQQ t!` u@rt@nr
dcwπPtdx @x0u!̱t`pt `|RXD8tmrZ6fa``!scwT KgֹArQ9rIԹ-SKQr3&ttsms](a!&0']v'M'ag I!/]Qޡlr ;E]#`;`ߡrMfa%q_fotdЏѰ #^21P@U#Rpf;r)glsPR$4
ZX	@CRրZr-kH&}_uu4 e
$rӦbQxTotal time for VGA POST:   Seconds 0.000 
 initializ" < 10 Milli 
 `.&Zx.ԃ.Ը@FA.Կt.ԋ.u  6*Qjn` 1.&0
qs .aPVJP% t*.?
.8tFF.L2t<cs^X	
>
2.Aw k09
ps4pW苿oꀰ4@
;
jps.$f{#9y52
?ps2O2@nq"ʀ)2ɳPr0kptN3pp.>,uyp2 6pt$.ppbZ 0nHվpf.?f.+Բ"rp{p(sp .
&t ?詡:0fg	fPf.>1l
UsOsIs &Cv { 0@f`RupA׬1@f.=A~`JpAa
P`+ qfpf tp=wpI8a`p+qXf-wfwffI sQp% f1vYP.
hXú#c&π `	 2Ϻ "ĊRZ$`
s$.
tAP0ԋ	tA.
t*. 	23.. úUpUuu_&
#0F.Ի e* ˿@   Y ~ | тPëO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@by      %  ưʴD` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VWσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7h@ t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPhRBfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀h$Pwh\ X[õ 3@Ĵ$<sAl r.ˠU訿rO!` OA (tD_rq XPנ"Q!ؿf0ѣ!ES  gf /u
> up[PȰ&  cB`&Xq!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .}2[S[W>  t> _`W} v	0EAC r3_ۉ_`?2St]AM][QM_Ϡ &
`9P
PR<w. [SZrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hΫ\bar1TaP<u< <up. .:.p .7c>`2p .>bs:P	d.e> e,@p ˀu 8r f΀g[ø0
.a.&b΋p1p.mΎ7X@E2@g.*f΀ v&.f&˸ Laap7*c5.PC{3`Α0b  ϊ* # PQW`
 _YXR.i
 Z k@@ZÆBB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.q}u#rp t
ArZwG ߊZYS2
dؿ0 PR7 r  dI r`.pr`@ d`QR	 .ߠp`qQ
t
Qh{EYnus33`8u" f;`Ph @F F@ &} tC t;k0Tta30h &@&E pظ@ P ^ X Wu-  apPfatQ@ ϰ YeQRW.. w#&.!
tff..A_0Y}u..nf/.ӱ cߏQ޹ޙR'@lۋ۩ۼmcЛЂ{?Qvd1>+ r.觳  cPPJ <t<t<
)SQVWێ-<t<wPXrs<v\.>Թ &_^Yy3	0		ԯQ @~Y!<8t	 `<PVtu=EIAc
<
t0FXAP QpRt @Qȵ$0<:|uFP ff PffXV	 Xio
Pj}^Vf3
f^  Z  f`
Qߜf
*  >"Orf0f3ftY "++x fa

E   ۽ 1C< tN< XÀ Ttu7A!Vu`U߬<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ o_!]SVW31rKt	s<<t<p; <w
t+,<Pu	& u`< r 
A`< u4 _P&OIVN ۩0QVSQWU3t!;wOQ
G:Yu
;t} tۋ]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fw7<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*򮿋HHH
uÊG O?ÀM=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Yj#)Y+PT P G WIN @BDF8U$<w%.JGu~0
t;wP
ߤȰ
 3]8QW C  1 [n6f.)ܑ0IQjY f.>)R[ 8svp $h 'Qv t7H485 26r SHz ueaJ2?  UuQK7e	$ <C EuAm"' ;l  Xcސ3PQfR1[3; Bf>@>Q mAB CPkDހQ@ہRSABC DpPOP R S c?[ QSWP).X.܀ uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)R+<[ ]Op^?pu18x f;tu/G2p _1kSfa u<] Pɰ݃f   `ſ4gB00t  t t !״rer cZfAA Uta	$`<`ut
*B5
u0
t		 u]
l. + ( k@
ݐr.ݰ

=ZE"R@rρ r}0M~dZrB BU
ǃa" rq"<0oP w  "
 B$<  wu֐S0p@ "8دt2Tu}NuF;J t> l@ u.Su;tյ "1
 " hd^.'yuη ˟                              |x KJغII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ] 7HĴJ!R~:$ ̀u#@G@6J B3tB  DECBc@CЭZNBD r0`1	$
 D[_m rPf j qbA$<+`mb+
cJ$<u	f k rPpc\ Ḇ[ hz:I:  3  P O O 	   hBr@῀ 3ht6BȎ؎zЍˋh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                          l     F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` a b c acD Y     i 0 0^j h=``;@:Wff > hp
襠 DϊfPff
fр aVWA+S@)'WŢpr;_t[s(`(F[_^aW|f` f vrup6fffGfY܂h2 R1Xfߊ$
(ff A	S22*OPr'}!$ 
 uf 8s֊ҊʠXQ;RP
t0^r#XPX  uf 趾auSf{UPfPfXZ治+ ]f0)ff]rff^~m`e#n z= srscB
Cb_ 1f^ ɉw @t; *f@Ikw  B)ђuW6ѩȢ=+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu F1KMuY ^Y]Pg>!f0rRg'QSVfNVFfL z^[YrfqXftA3PXQM| N{ O蛂PQA蹊` XPhWGU豐^PԀͻʡ AFд j ]dXÀ-p΋_P^Z`Wᐊ f}W mp_ÿ 0                                                                           - ' +Gi@ + `ar(D
@ (nvArHvA. sNfօj@&t FN aR3V.NZr#MXu 6PNwrgpt 2rXĠ	 u v thr&3&E0r_" r}2vRs ÆUu
FUF qߴ	 lqv	 ӥ/H	r@el.		p脀'^F&?s߻  s  &G&w&GP&OD
 &	G!R.Mf.u E	f0GEEabgVfQSjf[G!fY^f& u#GWf5  2WXP'F#~r .*u7 u/{r?`. t8.>*w tu  2SrV ʀs`,N	p N~t$` t u/~ǉ~ %"NV 1	s^Í6P.|uLu..N`>PN .:UtaNaPWQSMن?0.}u.:Mw#.;]	w.:uwPw.;w	@w0[Y_0? t>ـ?r.u|
Պ Ѐ ʋ.E;v 耰'fVfv@dD @؊fA
@NP.eXf~a ȋP	rs$
2~

	fX!9
dD0f`v]f^PRB@    RPXuUW:>_]s*r  $s<P0r!P@Xup>q @<@`P  osXXty>cr -Q	F?Q	߸ QV  PRPW> P@   XFrr9r^rT:rOt :DvL*Dȱ f umfm3
u
rl
u2 VWrd ^_^ q QP&:Ev&M!&*E9aVBoCo0<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt2߁4 uu@uu`  u2&fPS |`00vMPSpsq D
>X`?D<OƋ4a`t~ a1t!$!"q1&0&PQȻؠRJr# SMwO "t 
`P2:Tt
 YXÀuOuQ,9a"   <s&? ? `P93  >P}_uǀ   O  NNVWi<ua<
uu*P H<u>*uh2<t.$SQ\A[|u|
0g׈|`jt\_^F] }
u}	< .qcQ܀}u}	a`~@uDaD$'QV 3۬+^YD &!h{f!ff?ffJf0^1e
c[ %f F PX@OfP~~$=r0&w)ІEfu fqu`~Cu~qt05SV|t` t t
^[PfQ
  <  @ f	t` vjaif`0ff} k   fHff#f+ִ f;wfgК3g&Sg&c
uff+ffa
f@6SRK=A>$pa|P0CfQ~`rffXORpC{ZruAZr
|`hPR2ǜq4XZ[ô`S>[PS3K[
uX:aSQRsɄ3ɺIrZY+3p  XfPAwMSàp>T pKѢ   u
  
  t 	˻ʆ 跏rrηvF0 & O 
 30&O՝ˁFUWn_]v
 ` _^w ߃
?Ip   MB RW1a
$>1 D 0&= @
.1&FGvuc1v s1p cu#' x2 [2&O` 
;ub2f3ɐ t /u_33&8  3Q߆_ZGF< u  u2D@ 譠sN~ t
S"x[{@&fQWS h fPg!f8h#4` yf  j H  [$p`,fKf
0̀9fāZrMf[0#t5P; 00΋f% ;tf ff  ffX2f~|_fYASS   d GT q0E r7*8I4fff
0Gf R
aRfx Bú 4Z`EXfa c``d \@u7v
f<~f Q Ref%0
 j |DpZB"_B3EOu@1m$9A'uf`fQdft~" QBY ffhfaQfRWffn fRf3ffPtf Ou_fZYWr~!Jtu JQ;lIhIrVaFQ L G B = 8 3 . ) $     }: q_QП&GYÀ'ǹðd ɸÿfWfVfpmuzss  3f^f_ÿUYt!ۋ rA.%])%`%%^& &&+'z'or.f%qf UCESs=98q 3`69  1f!u%f#fK	sLwr@Mts` u=`VQaօf#ffжz+ ΂߅r1!SfRQ<t2f3Cr6
+聅f P0u g> tt Br(t E } uY0[fk^U@oу{`.4۾3tt
裃r2f`= u8_-t(mr!f10

J?t:R!4g&? t0zc詂]fR跃8@t ,tp
 u$2(Hp`u@t'P eu-vp(tQ
w!- o t> 7fAu^B1]Բ]_3q 
t g t}Sj偃`ri/p/B/RZ/rGU/Z3tt@B$
Ê B,B$t PBHZgfVoQ! 0fP,Yf^p0aBhBwB  BB$IBXB2#B*B9wB@y 

B	 见 螁 SfPŁ4fXpG	شt [3SV~_W  Ф_ W
t<5t^uf+rﴀf^_qrp5QRV3}P'û g Kt
| J=8u^gPQfVW7  5Rpxā>!mdD{@t@_f^OOQJ ++++
,,++),,,+,A-?S-f--a ///20W .2.:*tL u% *t>JrSP.[t 3P.[u 0*t*t_M_(EfUv"v t Ar MwP *.V PXF
Xf]h@ &A paj@!
`ð r`ipnh
	OVO*.6*# *.t.I.
Lj@s&  |0u `Y^#؁D.d.$m @u>	ã3j0rc߁Ot` 	OtOtLtDOt
OtOtOܑ

1*u	豎.<.}h ;$ B%ÁUu	U@Dq`R#Prp
fL\^bZrP[ ƹfP<r|wfDPu
 ѢqSQVWUP؎&Br& ȎXO*,O>* ..?>*@]u *Pa 3PB &Gݾ&wG $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]_^&?swa s@ `b 
 *@Cf&GCE QE~A*ff@QB SRWP讌޲ v]rs^*E<u?* JLuRE<sfQAM}3  fYr/>P4P.  EGώǿ R>p=./Q8[Ü+_Z[QW \.>*u5tG<tFZ=}.EP .&3P>PN@AV%0502̋َɎٍ6Po p0_SRt5ێË`S.q&Gf./Pf&_f&_ . `Y2 )Z[f?UfPCwTRS~f]Ô11
1@ J1q 1 10 1P A2 G2b 2& @ 2 3	 3' B3 S3Q @ } 4 @ 04
 =4G @ 4 4  P  	=bHewlett-Packard 68DTH Ver. F.08 09/15a05P -g]  Z  l ~q oKBC
sion XX.XX  
 
  _ 	o~A~# w @  A у JP12 Intel(R)     rnal L1 Cachea bi2e	
 6PC CARD-Slot 0  
 8  	 www.hp.com ABS 70/71 79 7A 7B 7C  ;
     
C 
  Ќ  DIMM #12#
.a~"Rp 7"kf @~-No bat y,"
1_A$WW6 _T`~   
yjt)Ӏut&ߖ b5߀& A)u&u#
u! À8W@ePh AUs RtY }pvMguG	0bu< u3uOQtru1 ta0> S:u@8*6R:EFu 
E0 } jQtTt̀t߀EtH71 F )t%> t:& tSuEιu3  P jE>I q u	PXuP3 tX랓tS%yE ;ut0#)	&2!q =E3萪*x3;r.Dv+W+Xu432#*u!.ð-*1!	 23<Gr<Svƀ Ê,Gii{.#]viC%J u$
<.r!Lu24$`.ͩ2K#/iT0rPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10Ü   EAX= EUBQ C D P@SI Q S CSW= D@ E S }I1xceptu4 - Over_flow!5Bounds Check6@Invalid O_pcode7 Device N`iAvailablJ8Aou` _Fault9v Reserved	10TSS1SegmentPr nV12At@ V
3Gener~yProtecErrorp
q  1 =  System Ha!P#
 t
-XÜPR#< tZ fVfR6:9螯FupR9/vzn9蟿pcP9Yύ68{9tfÍ69j 6
9`fX/9T ō69J` 9A0Ǎ6!97XY_WQP669$Q&9Q*9p.9
6296:F
09t9诜]&9x:na*:_WJ`J:o@b	[Q, GI; 1`(0X[S	 m6s: p C8BBaaI\a$at@0 UFfFɷ͋N
~fE F Nu3 'ȷn ]
 cRQP~
XÊܹ /FFYNZ1A`QȴjY`Њ  aÇ鋿ً>"ԃ > & G!> .&<'@'dQR Z
  c Z  
G XYZð
< 
7 SQR  ZpS r  `؋  p _9pS  Q!
 	` ,a@  `
UЋ؎ ]_a	@]ߋ3G
AF `P C0[q$9SR` $<u 3 0ؾ   ?fa3S RZQQC@VQ=3AUAY^` 
aËf3RQ3ɋff tfaf3fRAыf;v+R'TYX0P@YP\UfWf&и`1fWg{]D{f_ff_]p_8f <u ~<  u<  l<c<@%Z<	;Q<
`QH<i?<~6<
-P= uX<`<<pXL]WfPCI 2u_fQfRVWfSt$ѻ"r   f;ttN紃 f[_^fZfYffPr }  u
N`o>  `8 s r 2fSRfPȝfXZf[zff\YF:5	vf s"s t s t QVW&= & s fPf&EffX T  _^YaJVWPwT`;t
X2 *W 
_ ϰ#t-X _^1ONp sP6\ѿufQ fPf}nf8 P8s2fYZu< uEuPPumuZODPPE EPP runtime BIOSVers.1  
 iDDDDEDEiEEEEF+F7FGFSF_FbFeFFwU .)D]D.8].6] "r tR.6]
ZpQRP<rt2[5$ԁ !Ȁ
  -{" Z`5	$ T p[		uR xuR] SUUm.VGf	`&n ^CO CWV	al *Z usà @: U PSR*Bt<r
 j ?Gpp0^r
t<t ).>F u.F 
   PQR3uAB$ԡ 3ZYX
(<PdCGpGGGH7HrHHP&` XW<rۋ= .F_Swt 
' t @Ur
2[e -u0^r!<P9	rr&Pb PfQs" r2.F2& r s  rp 9q	8 r 	&& rr	ô0TSs+&' @>'  sa$桖0TsQ
u>[ Wr%p$S r rq	 .8 f" O$ pQ@	Pm ,X,#t s-@tGPadtbpt t
@u0Y`
 ɦXr`QPPPtOXdYûQPOu0`	`Xd$!<!tOOO  q&@tPGЫX৻ (`<u
 @&   >!@tA AuqP!@Ё  , &w XV߁  0`O  r
 P<Fu us	  	uA
 u	 X RtGTtu`6FtEuUrPRtKxGr t& 0R] Z&Duh;^ h 
XuhD=rX&  U 퐼u@ ϡt@Q!	 -rr
^rrO dP dXP $& 8t ߗ   QX uSQ^ `b+MH `*C: 8E8^01PP {@@X@30=MC* irajs\g&D
V &DtH 1i 
B 7ir!@0r_isuhF. uhhI$hrO迀isJKZ Shhrir
h,a0hyoiZ2
 0
FFt N fF"߀ B@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sb߉FVFF"F
 F)tЎ r4F$
Ft+ F P   !VPXWV@"0Ha0_WPR u	ZX_PRARZX  G  0 " p	`C  PlFpoypOIEMAG  IZ P      	
  `# HDA-L  HDBs A-E r Cu 0USB-FLr CD Hs LS Intnl  0-As B C  % _eO  [ H	P 	/` <M O` c!OF	O pO ?}OCD001EL TORITO SPECIFICATION QCQQQ:Q  A " * Gxx  x y 1 " *
x"x 0K   s  w_X _y\[8y y  b éALT ËEtذE
U ʐ
 r0 t
r Àxf`!qi2W &  d_&E3B&U
&{]@ &E`o t ûQzu0&E@ !fa1<$PnP!P=FR gR ?NR  = "fPff  @ fXtfUfp fS@QfRfVfWg]?rdsff_f^fZfYXf[f]ge333rVd4Ad^;sgu~` 
3 sM tAt<VrdDg_}
^` VWa^gEdTg}

0}gE `tr	 	t}d8 W<yt0@Dڦ
`PfUf]3
t P$u Ó' sf.;Gt ._
u fg6$+' +k$PIR    A >` a b c %S @U   | i 0 %F0j h`3. W Qp
_ϊͻ _}p aVW TS;Tt[܃
 [_^!W3`  Qu t`GY[h /$_APSQV.T  3ۍ6 T.T^Y[X:  4cB C VVV
WWU
Vg]fFR tDR,3GR f0]$
U uUeCRY 3   p4SQ>DRu5Môu% r!<	Y3ɸ 
 3Y[ ?SRVie&MRjeXXY獐&t轨t# 誨>Xp:MR<t<tXƝ< tp.3^ZBXV  |X@`uo P	bXir
- `CZEXQQo =c
udGRDRFR2dà6U uP_Xd]<tpL r
tLd?8D^uA"RWu6gTgs T^u%#`|O&
yt,ـ(t&M1&G&acc`cLAAAca+Íu 2Mȃot
 Q ܈$FKu/ð QM
u	ۍY;sYuS؀u tu)4  `9'  `'pBfߊ$f
f Р)RWS22f0 YrZ u 8s܊[_Z&fQWRfP
t)Rr ff  u 8ufXZ_fYP3 r3r: t+aw4 v f
tO{8t	
uY0	g&;t4g&Ct,0Cf4Q|<vf fd
g&:# zC1	 zWy޴r7fg&܀	f`_r!f`Gag&O@` Nb O q,|_f[Ã.Ot'}}\<u 2ehh
>BkU1q9qs>w[stGos
2  憚"  |  {)l \.D@.D
;~ ``?[&&D aø0 м  `j &&E  3Կ{1QPTRP !X@`.\.T	ώǍ> R.L` `8`a.D`6`aQPƌМ0XXɎ6aùU fJ}SMwSOpS`SNU#N f0{ d9Sâf> uGf   > t&r_Vu3 Pn`f+`3Qf׸@RY_rfǳQ	ġX*>u_fP sVR
f׋6u1 < u;thrR> }RXaSW1-  
` u #h $t$?ah@ & r 3uL^.6]M^3!' $ ȠL0I<u	.6] u<x t$\   Сtu_u	V $
4 gcS }@ /u7:<u`S[SPUNNNïO Oطo$#Qc#j_+_9_"_  M Gw p" * 0ʙ0qq|p0A~b,c޿U]} ދUu" ߜߢ#]ÓJRQ%g̺qY U  ւ! @Zj`  (<sW.__.0923P'Xs`Q[]u..&+.}	p[ @ t^P@ .&u @ u42..
t wPUU** &u XY`D3!P A3.Gp
XPZ *.ZrWȿZZ_Q paaaaaaaaaaabbbbVS3 .:*au.+[aK @[^* UFPna2SF۹ S.3aF[C N[QF ?t?asF2~ tY@ ø7oM  _ ø8PM d`dtC7JA뷍`0%7 3`7$ $ cccc)c<cScoc`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233pabf>"  t" P a2( Ҋp ) ǿȊ&)  * 븊* >+#1 d>,0.- &) 'r.PR u;t;6X6 6  #3
t,=

"=
 
0I5w<t<u FÀ0<  s
Ê& 
 <uaw\wWQu& ` u5˟`!A &
Ø4Y6_ FF;t2Peee/dS   Ya\"c` \0ba3ac] daRR]D[D]E m]`[\!\\\Z\+t\ I|\lZ[ Z9Z׸ Ñ tP"6OD  [gusU I2NO  
$c&E
E   FW˽	KP>]>N
R  R 5S U U OW  OWQ    U	 Y
 OW OW@1ABCP Q OWS OWT  U V WXYAZ[\1]^_  e` ea eb 6fc_ Yfd!eqf ,
,ߎ߰aJn@Pd^PSQfVF! 's^(2۹   F  +^D!8um3\f^ WVQCuKEb! }`!0"w $I^:u:\!u ['r' pY[_ShN.pv CC@@`RZQطQ0<:rd u߆P PH .0=  r q& 1PfVpİ:`gfFpXRyZpt	tPv
 {vt[@|؎ ˋhh3 Q.F.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSSQN<tt	fPXfP B n Y _ QEķi!2YQu =sY<u,fCISGu%f» f P f `&.>i .iPS @`f.ujkO[2!:.ujf`фuhy^ h2  uheaúB   $ED.uju酰RVP
ۃx 拔 tcPtt>@ KXSx$PQ|Xr$-Qu!$
BB -JJq4HX^ZY[Ϝp$ qP/ 10 3Ҵ./@32ƀnuo n Xp('Bp'|' -  t@uTf`0D fft;  Qf3Y,6ٶ5 !տ faH WfX   QRfl f@f= Pf3p fl >ht &?  Z м  GA0pv{@/⯋r t4t p`迂2PɆt w JBA"<t$0]AJBqpvBSWQ  !ԃt7`Y_5A9XpXqXtX	  s" "y_SYSID_  n _UU  
P3Ҏ¿x ȫaZ $PMM p  %m                                                                                                                                                                                                                                                                               i   
M    S    -%  ;n$$`fwyhAC  儃D
 uj@ t%v v t ArMv .EsN-f-&A F'N- aύ6PN  @ t	3!
tr ^	
F (|r
 	u^'t %1+	dj1*515_r0/5Mrr[o[
u< r<0s<"N@`  \

u' 
$nvf<0r
sus>O.u.
I.
MȎ.}tj@&u |t
  ^!N%V#~sFPS2 r20ss6< s
	OtE""Lt*$Ot"#Ot}%" 2!)A
 ؀	.E?F2	
r]wsms1I9  <$u2 *<#"< u<@v{<%p!2 ÆUu
F!UǟF% &F~&=r&߀}vP8fRF'P^S^!S&EF'f&U&]rQ[P@ [fZ護sSQtP^^6O7Aؠrf;	DE"z~(LuTMs fPf}3fXr1>P4P.  .GTώǿ R k7./pP\73V#:Ttt<~'t9r037QEE&3Pq<DD@ % 5vߖ7$~6P 6u0fPfS&Mf./Pf&]f&} 
[!
0'Qf謒  r}0rxLt迒rl 跒rdPtZ+cr@ O u~ (um-VƎދo^@tffm_ruLr Yr)8r$cr蚑r"Va	)rj!PTPQX rpw
u `fSfRWBt:ـ?f.EffffAUffsϱP-EMF F
tSuNff3fifVPf.WP*f8f'w*f'F'*2t*܊f
VvfV}v 4_fZFsQU n E]YRPXtUW:>8C_]s#r  1!ZRPR92B@ ǀ ZXQRюً go^ZYpBn`SQRX0% [F m `7h.> ďQ(&Q Z^N=rot
r`a r[v">O fKfa`, 3S5<s-PO8L9
t" >OG<}P#<Q$@ dOZY[PQX hv   t`rzru3rij`wNurWu
p`dع ޠ
 Lr.Ǵt%ttt t	tCHa% s߀u~藎r	 2PRZF sH<t<)t<(u;ь>A u/WUߍ>)`]_34r0蓎Cyq`_^?a'c`&PSR 2Z[)ÉRFtN+P X7D	F
+9CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFFf[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP8F}fCF ~VvuKQfXr+tðP>@P3 Gp1 tff   Rf+¾IYÀL@Dweu$`Ύk23c
.*x芆^G fF! PXG t<"u<"tlV3޾x 4|Q&?s0  s& p  &G` ` G`t&O &O`uRp`f&G`Pa  AWtQb b  Wsa,ZX7RQVW:Ww qtNuu .!6a u/AŠ ?L	
 t,6pNoAOGA&&d&D&t&D3p;_^YXVQ
} " uRP3P
  ^í&t{×.øJ!fUfQ  ufVK!rM0,u gf@ N V F00σu(gfFfff0/MufYf^4]< 3R+fQSfVffLfTfDfL !f^[fYrX@A3PXAøM øNp O `EQfV1UfWfP `t3 SP3RfZ :_f]|^>PfW ``tQ uUPXY fQﻷ PA YXt
 t$z`t_ t! v n_  X(RfVat Z|  a(
2VSQWf!w#t   їr$r	 _E^ÞQWV~wy^_YV3۬
Ê^y _	ޑ e V  M IV1fffa .6]2fff;w	rf;wVf0aPS.- ?" J f%3/aBRڨ@u$ Q Qذ1ڊ0= <r <3۫`ȠӀf
ffʝ0԰iff   f-   f bW >E&3&G;r_yQ <%Pt  _ 1S& It`Q fK`+  fY  ʷ f@@0f⚠K4Z4f4f P,0RfWg&߀>tq r 	r
  u f_Bg^f$fw tt,$
g&"Fg&
FI*$
g&#Fg&F}J	f#F	Pfa
n`VR	t#1
wt.
t9wttWt&W&U2
~	t
t11tFt`
t~g&`
g&@
p
 
u
g&: 	TA1`P a3R@\&^qU\QU "
ǆ(2Na N*`uWt=u2
߰f׀3e׃ذfװe~׀20e `oNqa VRPtxSR ڊZ[  Z[K ă u?{ )NȠ֢փt% s0
udfZ^`u=[u8qB 
ً@Mp M2 M0URu<_[u7Gtf)zMsMҰڱ

GǴZ]PGbXU 
 _s ]`K:KxSQ3}ɰYM tM>rQ4Ys\ P߅ 3Z[x0"uջ{`"P3
ݸH ^LٸGiLS QL =9QK 1S
 pN qM LLc'@ 2p n lU C  Ơ # &Ԋ2ҨUð
{Ԩt,pv԰o԰hpS$ztpgRø;
 D+Ԋ$	2s s	2 Ե | ԰Ӱ Ӱ	  Ӑ{2Ӱ2 	ÀӨ tN :ӰӰӰ
$pr
$0 zBx$2
ܖ7w-C A PkX(alu@u k0 h[P``P c R jpӀ ˎۍq:МW	rf+aSfW.ܘuOaUf Z$f_D  ak?[ 2u<@tĀut.`˸_ f_[Q
! YQ 8p ` PpNS%o` +ð ;w[`Ym SRW*׿OзIr 2 3_ZRWQ,AsF Y r3O:3!RQWSP b	$< uX Q2kYl f!`p:sX J	uRX( V_ m k7	XAP)[_YZÃU2<UuX
8
DYJBBƃ   brT
!uP ؎2
X
u	 6 м *VWQP Dt!WQ:t
Tu8v
Y_#Y_XY_^ _SM_ Pq_DMI_ 
1  #9s P  2XPUv F t	F !Ff ]X"X
W8 qa~P" i &g +Xpa U@}
fN@  ]ϰ2ðq  S\8&&G  GGP    [ !@   栊ÀPP Q桍\&\p ~ 
F0 ]
Q..c3 и( oи- 2  C@@ XWP i<w3t u*p O SX9F& yPn.__@PfX2$31 o  ÛpRrr4!@fqfQ8fYgBp[ Ȏ3]Ou r 2=Au@u;Áp u39 u+ f?wufP@u BXu
_f`< t`%Ka{At{N2!|Sߠ{_ k@Q  ~{{ o{KǠ !qO G{ P ~{_{UQ   A7{3j{op446p.amf3cf=SCAFtVG t"ffff Wuf(#3tfPffwfXfar_32_p9P~
` ODP ($
з,aô%׽´+ͽýfaPKМʽJt* u$t}0$< ȋKf`%D	}$] %W` +Qg$Gfa ră<
%	*P'z @TO xOy er$DIsL :  h!                                                                  fdS@  l ? O IYOO  vPQF 0 .p	˸y`hq && f"ꊦ  ~f3 f f@s.<f.:p >` 6a  !.P f.""""" ! a
#
P" f3ۻxgf+С f`ffWgfǃയ#Eg ٠׫`뺘A vT2gf頸gۃg u	f@w1  @f@ۿf_gf1 gfgf_0	arfQ@;gg&fG7;wf+fa f7gggfb	fP#ffa
tU@@P	3
gy
ff|0
gf3  P
@rΐ@
A
@  gf3fS Š΃wff#b ffyZ?'wf3f30n,;w#`4ܼbf[gf p2
ffIP	c	
{
fA"AXAP
P#W!fكs À +SfVQp g46fFCYQ  Y`@._f^\ g&GCffTp[PfVfWQfR
/ШY_f^RWf;rf`Ȁ u0s'1 t-r(@tD<u u P $faUQ	U F @ E] < t<t
<t `Y]p4~ RPQRbfv2  ^~RZYXɓ|	r3`	x tt -  t	  i09`K߳#r5=s  "#@O@18P,Nfѿf3u
P t  f3g OfF!b"XtбԳ$PPTffۋ`U^W3&fPQXLYq3)YaP'у` P!8 #	f<t`L< u#f$!wAPtfaáPf䠄t"
桰   u$! !tp &k Xa{{ݯށ *q밻ݰ J#LLs@P}FF
]X `j . j v
)Mf.N. etI4~r@5p3؊^)tuw t&Du .⭋^^;iaϠ~@t&ڃ.^2Ȏڀ36t6^2. @ PSFg
t'.:t	tX._[XÜfUfPP XZ+ f]ffŝf]rPmX n跐  r-s(@r3H rr
 rRVvF\r:Gs5&DC H Prfڋy苡_֡FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u rcwu
	A	πt&D@B êĪǪAT~0	VcH UrpW蟁sʁ `-su fqt
E$W藀Eab&G )
V Nh8Kr>u roG Po3F) r\ {r=H r8ޠQWss#

Rr
3 s@M1 |#k###F("r#謲Qlr@rk20!0p o×!r"~!F( Q'&d&K0#V&Ơf)&t N.QSWf`ŀu/ r)v{!ufPs \fXtā_[Y`<t;f3f t	f ;u
utǳpǋ`f[`
 3 P ܡ;phf<	8PO W校F X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$`
ĢF f%R$PG ;B(FGq1ø fF" PXN8NwN 4o2N?0(`00sO/ mlpR
 r
fQmru$fY_b/++U+Ñ^ &u b%tr_q? VQB  BY^	G $s
3
P&u3` @
r
%uèt?àt <q66V&T߀Еߠup 
*&u^ô  ᆻ  QPXuN%&:Lr * r$ P @uP<ut.@ ;& ; E q2s2p$<@t22P !$!$qX{w [|[ĺ".0ù[K<P~  = sffP SQ  !衊Y[$p
 F@ 
۰N8tSFt f% f @f tU0    ";   t0@bqP@fX
PRV s Zn!
J
8
Ή0
$۶g4 Nff`4eA fu4fafFDP2`a  tfFP ۈ^DPm fp]fWzf=`3#"fF$QiF,0 As{rBrf-1fv,v0h,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfր َ pp#f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	ffvAfI )Bwf*ݸfwf
fAN
Xff%	G,fA d!`
;Vt
f5AP
Q
ĳ6"P  f%" f%  @"	 "f'F0002KFR) ~!.PSQR30? 豆ff%fZYPQRWSӶ3t"X  X
譆[_ZYXS[  QW $߀@z _Y[`pû z
  5u
 @ @Üu8 0  ;Pa@ F4;+@H0P ߈>%F5 N0Mt(BR'9ETDHP  SIMPLOiMO?TOROLAVPaVS\~ЎHb_4P-s@^s˻ʆ~ >B4%g>D4 F4 H4
J4@L4f{SR &-&Z[>N4f>P4﷟΢U4W@U0 t
y@~Ph+؋Ò~cR4`W4Y4[4﷩v]4mp4{da<؎&3&M<St<Mt6 6 
6^V`Oɦ *ʯe>  j@e|sh BU6@	-	U$`

	e+ 
r)>4&~X^ádWV1.GF< u^_J߳׺+BrD.\J0ERAZqER.Ȋ̱pMQRR źZWR  ZYolR8AS؀u
RRp	[P PXE%
cE%	X< $ZT
 
"
t`gVW_wZwU
uQ6rEt> r2
tC r}Ͳ  rJF 
p    _^a1n2
u[rVei1sCr"trS '~;Wr6"Q@
Er GS֝)/Te  
 ` Pt ҮK\	\*P')0\;#$ rIW("  kS_!P(B O55B< t%@r4;3r!- ,-yBq3ɰD@D`ó sGADw*VR@ ރ|   t.Z^8ħP .;BBBX$JJ2JBPܰ\C*tJ ;*Xu)` Gr V tA&q JZ  C@ۆA 젒*uP= ]Xruŀ̀2	w
 ) (8SQ2<

2ۆ.
$2rvqd<w0
u@ð  ` 0    j3ɍ6O.Lu.:Ls&3.D}.L~s` 2`r2]`px 2N. u K{^t
`3t t
t
u! 蟤)3ұ u U t>P.|` .3P u} P J}uL   u3puv`bW~_tURQRUK2YZ6	u>^
 .D b+ t#VL^ 
.L ϋ]Å Q3| Ys. u&	 t	&Uu" ώ> R |  Êö)l.f.|f@  3.|4߿ _R\PQW 3ۍN#_,`Op1(u p;`3薢$蟢 &?t+aP`)}
t 	
tN .W:UǀV tMR?WZ| $p$u$$<t~} t	^^ Q3䆊!*Vh P| ^t
.u&u
cs)t!趤Rڻ0W۵u3ێZ
t	'u
u
 tu搉@s+XP{t eڰ`bz︝t"Ĩ@t  p 
 ް  XPJXSPc .+. s#. sXP&   &X[fW|$t~$C u>
rrw`U~a `B Ua p 0`cߪ+ SQVf fp   {U@  
 P  p^Y[_u(PUF    f&| ^	Nu<Vf
Eo 1:RpLP	r=^ðuS@]#^[Nu"

 
 ^~u.R Uj<W@w`UVJcL1YBS8WE
u&* ` u!f_fPfSfQfV   &=Ut< MPTh^ &Ep` `&ufޠ>f&&   \f^fYf[fUh &]S^ ]}[#&uD0DV& fȡAL
^rlfWދDVa &   f`t@ 2fʃbك^;0P Pt_ 'f=%ۃ'+a¡f;ME 
+ Wf.PPZg&G_lE!#3crRuf&T
f.Q,f_utf`@] ZStQY f{0fLfp,  !f^p91# ,L;Q>!p$U
UEG &E"rkfaÑ 'rnOGw|>P_@10W` "Ў؎`1#n@ @2K<t/fQ!Y<pD%PH
fu fp` QYP4v.M"fN?g
w -"|"#:O:OP9DQ:	: ; X;Q.:r(G)uP)D > )uf.p C - =*VQ$$D
@V&T<^{30Dory9
lY^C0 ~u0Ex0"VBqEv fS l(A=Dg(8PVPWSPW@QNP
P@EA2LDra
fNtQؾS2KWpM T;0@fP: M^_1PTN?:R=ffWfQQtT=M
Pe@UBLgALBRL3S }G`^WX!WXX1GWiG@/Ӄ(WLWWmHP&0P	3
7uO`gdOp%Obboؾ:!Q	TQb4`#SShS3Rq	)3AUEfdCf`e_W3n `{Dku_qnGhQhhRV'hh/hذm>t؍`pjj|t= Yj,{jA
1$pf[ jPQRG B㡀uZ փ־& " Q URfQ`vQ ufufQ2=fA<t1 `Q !ϱ n r.V sfYZ]ÐTf;fRff;fZ`Wf!тrfSr'f+pzZѧr
PWr#|s
ua

<f GM	rrBaPXPQr Pp$SsI[OBM=I:E{/ў[JOQP ~Lf oXE)t fat/+f`##fSfQf3< tfn!L2"ZfYpѦeUat?$57 3#tcQ!d[0
ð-@wM!ľ!WV@ fSP~WB QKY_W
t^9PliPst6]V! <5u G	F^B^= ~`"s.
<5 = 
uO>峟r aϊXf[2PX^2Y!WfVfAt
P EMr& ~P֡B ճ y`Ђô PIXs #J#A`$$J$PӐ)
u $7Đ ð) e1U
  $
Ǌ O $ $r[$s) 3+ \tA		SYPðQ3r+3ð&QtF!tt	*tEPÏQS&蟏"
ǆ規[贏 <t<!t
<P	<*!`R~#

	`ZQRs`-P ZYpD 
 ڣ) c7VP֎ލvS<û	 8[roX2 F^a ð!*; ")< u؃ tr
sD@- mJ3N|
u|	 *t0  $<<q;<
z^À7" 4C ؊% ."؋ '7*ZPQZu @!UXðLQVWP 
OX_^YaQNYP2b PB2ʁCqm]
P['"4#f1uðW52~1	R65l +S,_ðT,ՠ UY9@V-Z:.0V'UR<*< 1316k3p9XpXqXtX  A  G@ @  " y" zU-Q R~RG      *[ A	 ܠ` `  Gd d ",q  qa aO 
p p  Gr rrs sq]
s " } 
 6zr 	 
*
 @} (C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457
t Àu v5u t
&  `
x_t^t]t\7ustF5R3< v
<ar5<{s1$PɎ Xu2ôr2հѾi蓇r9_2.i ukq G$!wu@t0<zw, 덋 
t
F
	t
w
 Aib2]Qi߇S?J, E ?G@2q)Pı
 t"< t߀r0r	
2vPQ%s	} Z	iE HP   PRuaa@uXXZXp! . D\PXŻ PÜ= srs
n0PSPi{ _D^ZY[XSQwt.蔈 ! !$?UY[ ?uPPjQb;ˁPQN 3۸ K `9X': B PE I" ËEu t
$}sr2t`tW  d_sa(    K P3Xú0fW%,  .s 8 0ff#ffg&'f  @] ]_ fRffZX`yt'<t#<tNPc  T M_ H<u 5  %l  ߽
 aS  \#&][0&VW3xu@ G	u1@ x\ \pz%WV j1 Sa "\X{#y\^_S/RS$	ppqu_[H>AA H $tu;pʰ$Gr@  [D	0pn<|}p͕畠llgs@021jjz     pu u",@;b Zf`g$/u (v$
vô$vvvfaVМvt
v$tº^ Kf` u'=_ `v $Zqpv$PvfaM`P
Xu!P賃<X{u@P要tNa`
  P@a  fV@@ ބuJ{n{t u3N@f6 VM{u^ uH{u{@N`R\p Sh{tE {uwzA uzt!+{vi
&  
]_]f^eW`Ԍ_ $ $  GN NRP P`Gh h"Gst1$  B   
G   {Q`   0  T=`r 4ƃ4@g 3~4 U  < SQuP $@X߀u@p@ͯXn$Qtu
?R=
ERVWf1.1V0qā că~Q<VV<WU  ѥ0T `afP > f 6c?s >upf2>f֠@J8ĳf0d%ĸOf .> u@Ĵ /R+quX>tGq`a Up [a u
I_^Z  < _V_ ؾ{|YÌȎ>s1Sr " u]u '3wr@&[U  r.&1]33 a /  "3i@ 5! $3&ؐ-
@?Wb - h_ۯݻ Ͽ;v3 0ji3}
8_ah3\
3$Qfކ_ޚޮ`fW3sAq<f,u#Ή΋p f3gf&ff=SCAF2_U< 0Q
<! F ]!y  ,<w&< t'V3ɿȈCF`  ^ t	  az@VV<v^}.
t" ؋BfU_  /]dm0U^P Xs.V Ou']UUA !  g UTgg"CR`$$hUM < .%QNrAt1S.<[$ t t@t t	5@"2"#YX .6M3Ê$uqﴀô sء S3ێۻr?4ðt W3>f&E1'_Q{X%TF{ u!uO C߿<2{f]
 N] d `5dPQ3 27y4rdr
` r`f 	p @ QR@TPQۊRPK,Џ <?u
 @s귄3ɺ茾P.Ў `.afV`f  
u	r Hr" s  > й Aaf^;`@*2Պ$ԉNT@׎Ǎ~WF$
&FG &U_f
	虝arAuP t2R ZB_$0Z3  P    { { Ab Vgغfm Tbt333aI uF;Կ ݀u	66Vu%2"#(.4		o
	ȤQQһ$ [ø ʹ2r_$<@Âyf~fR  d Nptp' \註fpf.4 f                                 0 `0f>&  󽤱=6aw Á. 6ջ0#RfPfSRRBuFf3۰S7u"fV$
Ѐ
tf `uTt"Ttt4%ffZf[fX 	QfWfV g&?tGffpbfbf!L	g&GR u#f^f_fYfB@Zn J)Kqf`0s Eeu 'f$
f`&afô#wffmffaRМufthf$t[f$< ȋºZ u1A	)/f%fG#ef$efa"*  Ӟ.:f tdu祐.f] gu
#p d1PfdfBd!+ s dMd5g}dЗ J V0d1d<d;]ttd|d]^  R 3
' ' FǠ  F/3 .;v+GuBG
`F/ {@ Ë% 	pXvNuQ
 	0ʕ NY%'
r0123456789ABCDEFSۻ׆[fPS^ۋ^&t` $ueG&uFwtt6]' DG~~~~l|8 8| 8|8||  <<    <fBBf< }x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~p Q pp		 0``0QUU$ff$PVW0xx00 0 lllXll  l 0|x0f 8l8vv ``2[0```0 @    f<<f0 0  || 0p0  x_8`̃ <l 8`p  xx@ |pH `a
 
|x  ff|ff ll bhxhb `f> @p x p
pflxlf bf  ΀ 8ll8y` xxpp$ x0  Px ƌ2 xp``x o xa"x -7w0wx]|`` p 8l`0
zv~!`lvf{0 x  `b  `~  ! vf' 0|004-!)*`2
6 	p&0d 00001B  0c v
pou;Bf SvN .<2[]`0g i &  _
ld@að
 `
R3҄u  PZa TlAE eMA9Y.nSS  Aqb( Pg
`3Ҵu N <tDZQY
 Ir¿8r502:6 v&Z aP P2`PCI01 ISA`#+T DH03COMPAQꊙ 09/15/05  D ߣ    F10_  Ln؎h Ћ `h+3f  n L!$F10fPfSfQfRfVfWUfUCES>d  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdff	 3ua 6e< tf3
@d>Se   g>;f `ff3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>*g t
	RC su!&*gfXf^PVW 3W __t
r
>d_^X \ɰޯݷاбκܭ-.DD(|1 8     60  ``#8~ "!AS9>9N  : @'Ya;  @<@?=@/ &s@$	=A	I!!
0To!AY>q

( )))**LLHcF$$
G~B ~B
yy$$$@ $
  >""ZFYdd  #<r N` hx"'QyPGR<TS!2

	" g %8 0 p>$X	

$$7D81 [I 
!e$   A~4'((DD@%`)P(&A +C!Rs[^ZbgAvijwt@CVXeɊ\܃fBNݒ肩畜HHo׎ύXIAOԃeLǗ҃phdo@\Lu폜}JT|FؖcInI`Fڏڍ߃Os\gpjځBymGłrOڕKvxmȂ튮xtԍ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdь`YilWE십ċNԐUiTivIe^qlӔC~tE֖{pKrWoYMߏ[xb]# - @  S   0 ` R ?	i D  Q q@' 'TD ?g@dC" 
 P '1!!#"& p㚔
~|u  0
Fq% _p?   !  % )  fH	! ( 02 ES   _`00m) BFLXp0t  dEg!<"F  mY.$`"08D(#d$A|   UP W F  >"6>'p-@  ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@/@@a!!: ' ( <'Bft,0<<` *0`  ?t2pC DBg ? @
Ձ00 H$@?"@ 
	`0 P $&# DK8 o & `| D~D D<@ B f<,$$0$l=   M@ 3` B?"#!!  8@ `: 	{4H 8	  6 a@)1ppGp" `$?!3pHBQ0@S` P0ZT@L@\D2"#a#(RUY@>B&Z" Nk=bN@-A |a  %rm  2c  Q " $!2a2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxxpa1 
c
=AZxpp!
g
  p!rE  >>@@`)X0$x|pTT T8cCQa- :x b0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{!ijv+ d,Ds?|e0v0 a"s 6`S!cS,t. T8$9`0p6Gy 4g @ dt>$B<' @}""" c px% `vdnIi&0oW@P?v3$fv$d
  ]@^@.*  #2Bb"6T$-`0|p(x3 OV@@` F0Vpq 0uat`m|sG쁐Xm|%o38"5U QHU' &@'a! 3?! @( =!d(!3#\O2b" '?1`		
	`21"`n{9$i$	$	`  "33ak' l#?HzM8@0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,?!## DEB`@].A^! nxK)t ?` 0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P¿<  b <$  '  |D!  D| d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!}@ @Fq6pբ66@8y9@0ya؈  `%,#?8% p$'!G@x pwc 1$&? l@ 2?$?$??b < @$<b =$! <`0b64~
*  hH"e g * ~  <@ D=a<$" AL`5;' '-恴pp^  ) 
8hRF pà2q2DRD" T@""z" ""sbn0 CF`!  ||~ ނIE`<aBzd, %}IHT! Q㡬aE@AjD0p 
 .:23V!&    B5I@  `2"R`   @;!  0`'|Cd p5D ( H H  0
DP;6Oe}  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c2`."b4'?e +"@P,  b
W?BF0L 02?$&""  0p	 x 	#`4 cp$}R S SPpP? !
(#?@@DDD@"D0!cܱ 7E u0DL|(0<}t |` O=>'4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Ryydws7  H 4?b2C"cyH@ЃQnx<0	`Z ̀7(3 (`2)v䂣&^?0JbW8l>~/&23
b21#n0  !7$ #L`,!3p$?mAq%$"h| "  1  A  }    & <"rV&#0 I  81 c QQR0S"PC 8` A a ˀ4 usn#? 8ٳBY 
 Pw`]IY   ƀ0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>ǒ)jP|D52D"DvDTDD6 # a|b蠤,  1p#\  7ajė=  4a8	  O6 P>Tڅ  ptL D@~@Bf$,892k&arg@eP 1 WpxPX	 ^x! 3"&,0@ؼJD% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`	6U0` . `09H~ ց 	 d~@*H  ~K'6cNCc48x F?~!}BC  #" te `QP060o! = 8!` "***" /"$'$&*7"$"? CJ0``]0?~$BdB  a B
BB~15,"&_D$(-jB ,!.	,HO
 =I H<H$H$_I$=@ @v 4R$ze bUS R# P|7 8y0 ;6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z  $D$= *XGGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? ? Wpw 0,0  ""bp $ & "  q?2@G%
i-_ n?F:@ e$ a  ⠼@
#<]](00]V?$P?			?R" N8S8

 ek| 0@	~! y 	 	 ! o>"W"	& ">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDṪ C
$>?ق  '$!$34, g A#A ;<8`hOu `&#f!b6@2~Z*\*jI0 Bn5	G x RRptF H0	    	  a |$# '!b[aaap <2zasR0A: <  B F>lxPXHL0F`Cug@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs"`7 `C  `rL(  fMQp~" ">a}>>b 2 "&"cb@	"00P G  A` xz   Vj_@` <1p0?3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{?I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~?B$fiBFD0@ @`@.AY`M`  Iҟ2R2RR 0Bb.	4df0.t ߟ""p bB ?~b
(LA%ɧgUE``AC}}8@Tl@l$5?b5d >qicQ"tdaxR4䣄	(	)	) ( )H	p ^c 5>] 1 aA#?~"! "2&460ba0"` @"{D1 X8@ @0 P` !bF! °?(HD>!"? |?" p?.a ee   	 `p13"fud Bi|"@Acp>@$	,	(	88(2lO"FfÅV@@`'$pzBp03
D(z

@ 
{t~<$4 7 a  p }#@B"4&0PwPP``? ) )?)  ?2"/y1cI{P?pP	|@   t   uUp cu`  `*	 `0 ..1S.1Rmp 1  [<u.1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.1` a2P 膅SP!bRV{^Zu
`R\ts 2ƃǡ G
a!O sENjpW1
wts2oa
 4<
t<
tD<tY<t軮 P  VPP t	| tL^fnat PwDXMCÀt	F¹. u 2 4.>1u W. 2 13 `.1&1 u2CQ2P Y*2Ȱ&P a RDr
.1.1PSR  && oZ[X ` OCp@p
oo.61FF2!.WtOT_PG-p
QR.61ʊƳP ZY[X  "2S2OsP2 sP
XÃ <r<0 <rp1@1  1.&@GDu'F!13!ba01.>1P20X;2$CF{APQRW ((_ZYX. 2.9 t.1BA	#+D<u<RaN<P<S<0<ޠ<{<<<`< T<@<.>1 t3ػ@ .1G.11O#0.1.1p`X@Y 0..1.10;Pp2?  X:XUFN
ȋNu	F] S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M
> tj6h=jF_d&  hE >[QIWWo1d% =_ ۘGg	 v	z]G@VUk?#
,
N	#&d% *$2>d 	V
J!fbfffNzd|dmafw>d1jut$UQ"`	n2	zd		D	A	
raUVf	A$E
ECh	
=H)RSF "4\	U~zdېFB .///gR-iZ2z24~T
!y#U"z&-%2Ux6='nB{FuM)MQ
h 7}d*]+,ad t<j9*A=<*8@EdjQd$#fh  nbF tAt=dtfh jnd$/0!qtfhqLKbq >tSHft3 tE>2e tjh2efjhI誰`8%j hd~1{t2f tOffh[ߞg t+g *$)~f3f
0~f P?FPh@0Vhg"2 ]Qh~CT3F``He:=#2h|es `h |e=od V05&~	hf4?ƀBM%Fhih	tAyHFdFdXFBhb[FP8@ hprj h!J]
	~`#fhgB(z4YI1Sh=dr,V=dO^05%h+01!4 VcES*hLnh4
$$O	Q"D	"^_ !2FF4g^ F&<
uI) u&*_&8HgtFFP9 1FOuÀٹ F FIuF*1 F*+҉FVh+;u;uàh% ;Fu	;V@áhG2@A99h%_ 
ÐL*	
 WPa
Ffj h}LSC](-{ f f0h0!| &b&djLfkPQ~@[j`P FPW`8F*"aPbAV=ut_ V!  )# GF| ud02D|[p h &
A F ϋGP	@FNuFG0?7Ʃ 

yWOx,HaF/ TQ	A{)wF?
2` 1p QyZ%Au>r	UI
bf?U2%#Ƴ~	Ce	$
1dфo2mh

dRaG
 &]"@r9qFtu14WFB5 	% !d0` a
"`ףb% +1b1bj_Ra3p%+czzd1PjEAC` 	a#
 U
`nh~ Ќ3""d[jD
{E
C @	HB	N!,gD	3|1 ji%X|T*jSr)
 U@Xdj~a4%&ddKr
x
xR{tt1`	f"q_Ft@^ #AUyB#@z[2:p'8{b0T<ɺ*3 &d_{djTrxA:@(5d@w_&@d 8 f&_d1O27Q<_& &O ng q	}av VUW HfL
b fd w dV t}JABL>@@A@b&!{!0^PWFh^F  ^F&F~
_r
f?&f &H` &te^0`h}0@ ~g^@ d2e@  fn# r٣ qA*pU`E  p  V6P^aF@t+ttue Z,tT@-uN&ff H+f .9ʀt"Pt ߃]A} QHf@tO
teuUA&2 _&e   ` g d!r&dd蕳ofit5D @.CF2|0@  &dw.j j  3
vwB %#r~WF_
(`B&g"&g &{gav5&ˣ +&C!&u)&Ƈʝgd rP\fhJgP9M"9~dC 9Df&EfFVD}!Fd߄h
Af|e	s$"A4 +a=r'v01؝u`,Df C~EfFJ#@ty)#Zj$	cޥ>jgZ	܁ Df$ < u @<@/""rĸ`" Y1 e >bD)PU94333]G(va2XSf0 >b
t%r ӋF^Nr'~#tp  u^    % FW )A^  ~u +ËFVVF6Ƃ6~ r~t` t uF݈0ߍpfv
0V׶32,pIu~quSIXX[t
Ӂ
 ^^pܸM~  f# F B F~P|v^ K}F NFFV~ NHt@HtcH P )onA-Ph0$6^F&? u/dv萶A8>Se|nhXdΐ22bcV;3dv近mdLn`
NNF -!q$F8hFFPjRh_S^|/GFPv4AvFhFLn~P?dbPa?:!Z~`d`&@0c16`b`~2|FtFr(}QW^
4~`4	b-2O _`-+FVFQC94%~ t;F4.FҔ0
z u WV~vN^?>S
A0@
^_C
"j(c
lj`


[t ,md(|WVvԋCNsODRHAA~(|W~FIt_~@u"2Fw#}HFB^F&WN} 
 
%.APU!u@##Y KVDiaҶ
%%		 	F*Pg	}`	
g<d-UWVv<~P F
&GFq;&'h*V~oʋv!^PFG>Iub: ^&^?&8t#^^}۲h!#ù
 0GF N% }p,-Ar  ~s԰ N?FN+O;u0g03ɋFpPAFC&PfSpfF ~0gЋsG^AaQFހp ~
韋vЂ@x|r
CVV,GV~^&wFIa&a81FQ2d%Upr">⻐Ikbf?N>Q2&1%#B2
= 	Ce	$Q
j59RUo"R@FGbᰪ ]2PQ_v`VP
b% 6zzd1/|djA
 j 	aSr (T53^djDA{@Er2	C
{@H[

N;&S
	 UU@g}3|1 jiQRbi~bUyUzE`	`x9@`(#0
T7
{2
#26h BR5*S W&d{df0f   |efQ	 f  h FdLn؃2"􁚢 4 +d=dFr3d0:I VJ,@szFR3#8BݨSº)BZ3~QxsVp .rs
pς@>j6h`PjFd Ze>溂Ic^?#d 2W( 62$>d 	u]
9Dod,Xʕ2G [%]@ْ`fbf	ff؃/fzdPXXՏ2A@YSA \ja$jBGI
DxU2E$
eC4
?
!}$H_qRNԈbUazdB j)~SpF "Z4Vb	gPLM;ip/#Q~0PRyL4zxB*{AV_}d*L!{r@@>Fp߱ lj}h![BXWVvqދ~ &F<t<
brF*;b}7Ay~tF&8tFu|t<r2$VP^Ưu	A(|鐠޿ ~Pfh#  ` PF;rF f?=* F  F*N*ȁ vF7P0"vV
u+e4g^F  FOu)	"fDg &Dgwnp tsgq0  R*&h2`% !h1hu8= +ɉN3h33 Љ  uh?$<u~h% bpu&u]f}2 % DP	u<uyB )g
u/au#ah#FOr e4g5g6g 7g8g	9g:g;g
<g=g>g?g@gAgBgXMӶ f便3 f  ר9 `ujvRP v-  `F  vB F~2|俸1~İF  p ~ uF|eLn
 f jtWV `FRvKF@ b*J*p
NvQWVq{FFP
|Fo؊f- oh n
~'F܊f d` F֊ft@ t؉FjRvv}Wvh 0-~St` s}u P0M2muFhMh ;Qh߀ FފfP~`Ff Kjuc:;E0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌvoƹ\؊GFAB Xsư FN&p;u0&LK 'O"a`0܁7aPjs,*`
- e)@fp۾ NV$Y!YG|"[([ [<1[劆2?d$0   !v$j)Qgp4
CfeQ A_hЎ 0f@ۉ6y*V+- t*-} t94@!13o$RFa02 {OChOboLR@IF 0#"7g
11  GEBrAr/ 3|
߃/@+F+PRqur6pd qa"$`a1dhˌب kb! b1jLFPQ}(1@j)"#2#"#
1#C/]LDE@WV3 WD!^&@RFG|吋3x6 2 R_& FWuq` $rP7<"JW>do ve!bb6   &=  t@M[_  Ft p 
Z@"4g#-//

	
@yu	( M~PĴ &?&TЦVP{S~ t'jF I l t/ u#'jfyEqt=7 tA:?@>u
f&Hf"f2Hf% Hf  t&f1`ul À&l YgdƯXg fhFfff[fh{e`b0b1bd{eU>u[h hJ퐔h Z{âp:h^@jBz育uւhR 	["		N	
Az
4!F* FMFk`  @AMb2X !Žpb$< wrעe RA~Ӏ>et"b`& Pa
u"0	Ȁ>Re uzfh  a  >qbvB@car1},c
\d!F !J=
u<cp3$upv tIŢtrtBtt@2b3+&?(u"&Rup )u&GPGP됽F^ u
 fj
 0 	   (E.~  / u p݀&zdqFF`U>~ tf Dj j P P= HtVjP M-
 -!/봐> ~ gH	;	~p		߃>	aQۋ@6RĴ &@u'3pxTyl  	&&G&Wݐlp}E"   s- ;t- t- te= M-H- {-యD@ +fjsg  ;@gp Ʒ"`p "g vV>{   ߈vVP*AF^ VP% 
P h
 h  <RaNF
+F@pF!vvo`ߴ	F"`NQȷF@`{vjy qpCFPNQ=`O*P!ؑ`VW   3?_^Qa #"`%A  S!F
Fg"`F.
%
;F|!%} F@P!y]aVv р`NcF&< t&@A0FAu
 )F~u<  tFF7 PF@50
 f㢴4@@*	`P~v*VA ;Г2Ɗ*1 ufU  }Vn']`!> tur3NFAY FNَ&8tGr vN! ؉^GF
&Ft;^ G  3+tp
뎐V^% = @@A3t`ߋ@!A;w"Ā>
 u31&A *;t{r1A 
*F0 F
t t" 0`f[p0;
V=O`2P.B@ÀO?Vu	.SEմHDa!E'(E02rVu`5 3
l|	Sd7RP3>>Q XZB~38tC8 u31~^
AF9G
u݋N3~(~ q ~ F;|;pUƄ  fUVNVv<%tF` u DD^ù
00N u0+1WCRP MX ]V^tQrJ;v~ F^F&uF$=W\qQb]R~}   P+΋э8s,dvva!VpN&8 uN&= ;t&@*A|ka01tP߱+ G0f6o !
`f_+IQ bkqCTNiS
ʐ kj ##vA`
&F3v~Bǉv0JQ&}P0z{b;~ANuǋv 0dFa{ 
FfP0V6Z cPQP F ~ ~
~h3ҋ P{W@t4hP{ǰv{ePq 	ptGW5z"p j9F
uQ_PK vv#5@jFVF20ްNvD"F9F}+F- P@!b' ɒq YFF`%R"[ nT\QPEP@DPAjEP:! fh  赁39>_ ~jy/0`*9Pu	A
@0
A/\&7K6%'@2)
G;|2*& P c`8(F0
A
jw Q}j V
V?RP=A/Qda'P? WVs<n@]Pac E +FFVda#
0UcSpbYg 0aDPdQ虡XQ	5Q`,+F+Ѡ`M*2Y Rg@=DI=ӁF3@**A;}Rvs`V6r1qyg*@F;vwPS _4C
sR14+

uSK#aQCPfdDp$A84	PeV輡VP1~&-24hQRtY~AS;}`=y#DȰdf&D&TfF3F@F~
P  q &Fި@u[] СFtdF;ƺ@Ɛ]q<vN b®PO;v}vmǑa<GF;F+F-	@pFF&Ev;v~Qm~ $	;FfF	_F	} t~0{Vg~|PtOC tG\'F
t/*y F T9F}\LF? ;F~AZM
~~2G+F50%&L
q DF_F 0  Ϡf@`	PX f@PF^^EAgT l2s|rPxb<FA@ o0H{&v7QvFvFՍ\Pɒ #R@~U 3'tsF+FJFHfh iyR( tTYT4Kv^ .9~ݒ4a+Fek6,/+F!}=ptu.tPo9q &OC@ +σQ._+ǀC
0|ctj[|t

FB.=Q j]>~oW0!L# ' KCA& !!ypa2#$QBC}PPCfZgpL@>Zg\gj qWw 
Ht8-t-9t- 	t "f 	`!QF~ tfFfZg?F  F
Pj   v
u}1Aju >PHPV`s
Ϲ&_wc¯_FtB$zP
Q|иN	VV2F
t!@D% QD:
莡Q
VQ6 B tDu遌Ǡ
!_؋!bGv C puDPk*.% H!MbB`tu	 rdP蝎QGg	R4O1maiDu(+Huun @uqt j	jfh	m	"	PV^FPqf~
 t

>alxQEPzU@ ]FY m DVV~jvvxX 6G ]3?鲯S0'02Rr~wF0BPR1qE~
G jR[w807+$ }Ep  9]/t ##/E=/`a/FFP9 \ dpg
p; ;NNNQP @C7/ Ƒ= K = ;  -Pp---xАWp'WFj  ܩk >g`{ Pi?;v1!;vFPVW>FP~F~PG;~~P1% - D- *-^#- " e= Pk'-R
|5. G@6- ;sFc?atU tP` zFa~9Fu
VVIVF]v9vu@PNPN  PNNRF ~9~};V 9vu< uN0빋v T`ߍ 3P Pp & !VN;
u逐xA^F;~m~aXS `
$~Du6?g b_;|qT/QN;v}wO;഼6Vf~ u?FApL怰9v|GI0Đ0%9F| ~A^&+^& 'F%'302F`g!ihj@vVt ;tt D@gx3|f4Whyl
 rz/~I>6FWV  Gc Df td@ @ l tE]f
|tATD\۲[u0蓾Y;F~ ZpӁrջN@uO_p0
WDK=Np>|e u)>f tl>h tt >Fd t|dwB`hfbu?0 Whp.u"jhbh$` i
j(hgh6`fh`` J `h=d_h`+ `4 `}" `m#$`a5%6 gB"	` f%^ Jfs% =dc%	 +dS%
 4dC% "d3#+(i`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#Hj Нp;t1rt߀DiODpU_*䊇>AvuA*HWvAPVt0<@p& S}5544%65245r659hD@E@ jpPVߋCpWVh
	 !V3j hD	~D$Հ`HtHt#h !  ޣ  C wt^{ f	$F~ HtHtHHt$" @ $Ѻ&&G<P jh	G+P舐X
ǯG>7x@n ^aGP0v&ƀ ~RwrjV6 fP)v3P Ы>X F`~|֢"v®s}vI@x	&8 tr
9GPu   >p~q9	uarf   ^f~ t  |ߊFÑ!	eMѭ	L0#	Kac 	3$豣0(`(h'聻paߋ^p3&~/tC&  v&߀8 u*C;^|ckF^P9Pg`^? tvN~}"߉v`<1
ރ~ u0gDFG&9 uԉ~WRr0~F Z= ?-
 - zҮ<5 1 ;uJ< tCB޻tZPU-
tKŐtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@_F	 0 % t" uNj phF  Bܲ u
gށMN3~*^
7ފ 8&8u	F;|,Bdn
e6P $
P7ڋ P.PC 
Cc!
d$  *8fudwg"^u QU/	tP3ׄ`0F |n FPf@
t)f37fn @Hpfh j ha?h` 4$u @3l3 1`F*}A;HtϠ5= t	d@ &d鵫Ǥ ڑ.dQu݉&
:	@
ʠ
 &
&
hhN
h ?AA7B 
@
@ -*
{
@5q&
 3F! "&d&d *gh*g!B"  `F?P~H >AKN
3aU$\'"%aC:GBHF`^ Za0$ƍ&Í,3F
^46 x$dhej(j 9
P8
PPfsV
bW&*`)@&` ad t&<
 <)뀖 x/
Q %'@q`
! Ohej  %c
bN0*ff3	諠`%  P5Ѐ`RB/
?
$*E0/o$30/04TR$R"`RVdDpQ%W
d
aH*=	- I- 9t7-
 wqrMt%
- Ktq-M;tr` MYnp= d.ڝ"8F,2@0`  8&`0\'R!"Ր,20`  g0PXu/1V hbhǗ STS  9YۂY݂Yހ
Y&y"0Zd a=	_[Q[_"
@4/ |`r!@ `d`da0y y Vfh0/h y Pc@t&
 
@ ACCC΁!#!
@d`d`
Ɛ޾
r4( + (#+-+{tp*tcmKt
- tu] &3& tGђv 1vhh?
h P!wu
j8%A#&A
-hC@#'$'a'a{Ðjˠ́ ڰ @&
)3bPf 
0>{+>>G>do'>n!>]/>f'>< >Ћ5P$pD D:>E489JR4"" :L%9
5BδBhh V2^Du+! 5 31;ƻut &`S7髗AA@A@ctR_!P!_!
@>(aO? 6`L.rࡠAL&`(a~O<!Q"Q QƐ*|3ɻLn &ArhOE@Qmps@	XrQUUtD3,i
; YK(agmrFv!
or0t$Pv0%@EtxDP!D$mD`
P#wBf~O$x0%YAǁK=BD=H=yM(a;Ա;
fhZ " [BGb %^
t
]
ct,W*@t>tq *``(@a@1)@+AE*aŏ9ƏCQ E #3 ғƦU $ $%0 04p@
%@@tDR~2+6V$
2`& W	4DR>'
2d	rR,iųpǀp
o,a6&P?AsPD?A di^
MlXjF&  &֧*8F\n"L"#1p  Ap"!ab!Ca2 К+a@y+ac ` 뤁a@]b*a 2 [1 lfbW}1`0!@c!() `f*afd"Wfh  VAA
Qfdf*a&dw..@Sa=6P!6e >>d>@!@FF%AN$N@dҀ&VRdVCD^^AEvv u_
~ U
u3
u*
u!D	utud`uf  ,ǈgrh2E4RvɋFHFPVhPSЁ Xv
WV0
ߡ0ahHtHtat-L.L+ AK!!IH
GGB7)Lptuճ*%4S'`C@E1GTgE%BM
Et
'@,  WVf+_fF@ ؀  Fa^F贀 F FFF}4FT`_Ft4D>==  ƿ - -tR_  =-a -*t:-߽ ߐ= +- v -Qt}x$Ht/Ht:HaC 6  1(@  F! "!13 [bS" (A
Fy
t)j 㐋ePdPfsV?t9;``{aQ6@`_!F	p 
*HFM~f  fFvfvvFPv25Fu63F`.-`~%va :uFG;F : j~ t
&@{ P ~@&!  !qq t&AÃ@ ׌?"Ht)3Ã? @ bbNcԀ&h q f>0a uuHj 
@3v0 R0Hf.af"f 4af a T t 9FhvD" R
.oaHfa3"8-9t- 	t ű`R
  *hfjj a
 5	u0u.#JNHޱuh tƐ>a tuáfh  P*	-NRS>Ta t`6
Mhaph(B63ab& T a F |b rе!mScA >p#u>}p	\t&e~l60a	pމ K뵥hbte3b1y3
>4*}u	>t ׄ0!jj22tׄ;3Be'kJ t'zH{80:2R%4;44j`pr
x zp@ǟಐAр!F@[$
$4M*tS?=<=5
5
p.Kx@a	`@Ba	 	 fh+rD-q pTp$#;$ %4/0a2e bbdbHfP۠r ) d= $Nۺfg1 UO02 Rb
%b
^c
~߬
 }g
0h
` 
B
 Gw`ߢA] Dt,-
t%-.t,-	 tE-
tYt- t/pC DУ0a:B~AI _p}}yJ  oU2VIftfu& rA Ifwtu
P0t Hf@  -pʾ@ut@;>}`  Pr%/h\apj;tXя6 ]HtHt `t' Q 軽h	u
^_ WV3ɀ> N3һBrZA@ߋFPWr~0r>RNpDt  & Q FV^tF
&ud,
,,,L,,, v,,.謶>uh hLnh h  j v
<ye/"
@t\) 3҉
6o5P@;@)}F
r݋F 
h*M͢	
JX=
Z 5#W<B6f
 ~ĲfDg v3ɉNv~FV
tut9v~O|܉~*Pӈfb^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|\bpfbfffh  
bt&
]S
 PdJnt	E:t0pDq` ^3

tF^&F!Su	 |03$NF%@
EP2}̀nGWnrF*F+= 0=a -tX-  - 9B m= M - t!Eh-|@ ߛ Or= E.ػ
$2B/ /  p- 2&b% +11b bb@ 3 ֐j5B jh
΀}E
 C
|@
@
¼/ /  (YP)@ wj}Q'3
^'ۿG`hh5厀GS.bAcb׾h, bߠb$ a
0&
cu
Q 
@DM
F@f
fh0`z !"
p.pfh,-`*+() &'h%blrd t0
Nd Ǻfu
P0  O hEݑ `F<tF$hB"B by_F ۄ-FC|FàbG%VA/biba!J1PF&J"`	lLդHR ߰HaOeO KDRB
HT6PWʄ
aī90S1B;H

H
>UF \X\*_	Հd
Ra2C `bD2lTBeBD	
2QLphh!TB Q+[j d
R"
&%l߫#lVb$55nUr&Ep$("(-  ߁ 30) +1T{bP*et[D,e//y Ab,bfcfLbfbf-
^- "f
- Kt Zd0gpiee_Bee8e2Zt¬º"<TbjÀÖì;,2pdz  a^b AB  !"  ?- 2& k{dt ud@TwĀD -@h)#̉렺IC 늩@sڀ# Z+zw艠-x Kx wmdC.A6@OF_B~Aa ң"TzdEfzdfpd@ta a֣` hS&CADPЪDԃ؄t &hFώ&? t
&@@@# 
  B	@DC
~@zd:Qy@t&fh~["ud@ճ~fhh蟮`
76荂7tfh<":;?h9n !0 \1^2JA?@h>2P Rp	DэC}rh[v0WVDf$ < u2@pAa@<@u: 2@utQ͋[;>P`  "Br< hh<Q166b  ue\ Dt,-
t%-.t,-	 tE-
tY- Hta- t/YC Dpb:  ~
3 	=}p  Րb:2%@'dF P{c= P~Ht
@q j  r j臜N@uf4Y;F~ K 0ӃrջN@uO2phh茽pWV`NW#p 
rvbɑütet
Q &6bF6`Ftet &.Ͽdg8$ͿN(.8JCM&&PG&@T%&V%Q _%T%>rhh8Q 'Fc" b`& * bPeA u$J,T7 htuhR0°T9  t~@ z` p lPp {jP, bzp~0u.&z_j`&"q;aF90#0000 0+000b a:BkVfvfhI
 rIru mh }bF c:tF&<:u-FF
*?0N&$  ^ 
u3ҀC7 ~ uF	 F
  
 }
 <  C
wv`
΄ Tjq<d^P["0
? 0
~ `~ tgh>v&~ tD菩O=:=u5 V
`
 ^3 FPPPWFF9Fr @% -
 ؋0v v sd ƨu}`= w̐*6BNZfr͋~FP.azczy ~ t m4Fa =   R F  : .E " { 
ٴQ@ o~dzt' ƂOFZ&|IZ#3^ \d1h{Vd.tCq u^ GCauK  K .g"pyW#I Nr@~u_ W    I @FjB	FV!F^ =uσFv2N'22g+@]WV6ߦKhhd:y*y fy:u}oyDt4H-H4HSH.vgHqy72{I.FIP9Az"ClIDzߡza
"ʬzj &z<f+fF@ =   ^~yFV^KFP6bֆMv3+Q OYڀ?w`- t$phfFf~ sAGuh镠dpfQVȡbRPSQfXfYf3fffPfv襨MF j!X0АuCFpvh ԛcWY!u"u蚵 ufE  p P0  V6PrQJm		% 6\bD60g\ 6,gˉ|< ub0
訣!Y~0Ð3Ð 0 MHz` KBSIMPLO  MOTOROLA  HP  17.22  K    Restore default system configuration mplet?ed!  a) Press <Enter> to Shutdowwn S...a <  drivelock \V`B C 	u Setup  <F1=Help?> FilesInformR  Displayz5iSave?floppy[ diskette from+(s.Ign2hanges and exit EP  s! withouaving
o Securit@AdministP!or passwor0>C"e a/"Power-OnWGpP&?DevicedeDgDJbD$L $s mart Card%G
s?upportTPM Embedde&E
ta!'eA'e
t*ac",(0sd:authentic;
credal /Auto2ceTools Ba|`/0Calib(p (`'lecB{ b HDDP:lf-T- opEs Activ O Me]m
Che? r s ; lls1mb 	>>uA(AAdvancuepjL4uagC lD7  of gray6fieldO Boow1bD.E.Uany keyUY ue F10=
, ESC=Cl @9RAcc{ep/=YesSNo D, Ajo$r=MI AW  Us|Sarrow
 o highl@ *he appropriQmeOnu ifKpdNTER> dbegiQg3hK%#.follow@M%ek&:`t k-> @KSPACE = NexR3c-BAC9K0mvio"F9oTABE3iSHIFT+&*ƔsF2@&10 `
[J #'9 Er Th{is60cann)bmU;d An e oc^@ #wh0t6c.Pde 0x01 e`jndA@pGu@pp{6Crequi@yȡyE`d~kba@%mu0C
movP:p e4k/MEU) hQ1&`0jll//+@SDFa06ssfulManuZ rr  Nt0
d:Pro utypspyeItepp+CacVize (L1/L2)S~Q ROM dd famias=eP8l nupi 	Videovi}sbKeyboorFr06PverADb1<ed2e3bg41qa< NPhip8(TAdG
W
O3O 	*	taf dai5u%BS)Ni$`1
2
3	ME$
C

V


4T!V
o
Do
So!  : AD %FPA2d!J#biFaPWalRX0sԔ&1&H} A{ddline4 Al Xҁn.eFdWarn: rk T&llpo!  zsڦTrea /, letf ea w0΃abLp0r A: 
deĮ` waqt`t Ұ_)u րrnInv  ȍOP
)!	%Ayou ͔ wa@|to A ?  iI  po b+-c?(Quick`n2o2 (Cvre@sʅ3 (S.M.A.R.T.) EP1pex03im@s@): 30¾# 1g3>0%v}}`t y ho#0#uprХ:1't4	f-Un3knkilyWR!mServReaPS)doџt7`?a}.ribp	: `LexP9 'bG H  Ol New Vfy nY7Enc8Of'f O  ɥA LA66#%AKroE   p dV
Ad1ݰ U@ҭ5Ocpcaus 7APp@=AH
"h` A&فOpower-.ASQVQa?Uׁ= loss  (dYAhou  nlcof aQgoH04)ev`ۢ?[vYDocHishaR`ed?!0fp]Dddial JJe HyP`"UTool0 Cr.%oF8IL`ˣ Bk g Uмn  qpm`@jtWSN !ar%v0s /UcwchQɡP2"Onj* e:Z%%% AF@%԰#Dn -f  TndpĠfӰunuR?*$n)tartBQK`fra Par1yNsza $mediaaAl Mmak ,n LANsQG CD-q0F y D!7C|U`	|Q4 abouud}h uR0[%_Q b0USERBMAST {a
panpR<ccUrEW"k_eep iRaL=ephysG?p1kr  :mpcr. I9RBr0A#
, nSUZun-Bڀ5j JOO1Auto!RcEdw\88 I3?#ON> 
(R[_nR~1Fbur Ct@_!R2tQh`Ss1rw  k edPerMd`qaff+bdata,@`ssibomaANnicgiAE!V IPs[pl r5mmaP  Wu`|l2,orepla^`r r/*@|4} [0uBΠӔ, coHA=Wy'u~me`1r, @MV`*ЪpPxibЩty. IfrdoTʄpw8`AESCvA.!
t V !Nҡtyp#b'>'q`F10"q`rm,bs {,t+  1E$` MiBjQ  KOru: U ay OpXےHDCgDL!bA~ (left`/hUSB t HqbsSu K Zipo'Fir oA0Fthifp Sixa h )ENhASwap Fn/Ctrl!s K8tᓃU.S00slegackcH $`7)n0=pr@ry Vo  d NTSC`AmL -J -MKt
BidЬEPP ECPd2size 32 MB 64a F@pAlw+aynPPi0PkACS gWW=D Radi AkBluetRh`/rS;#chA Tg"Rʠ`Pt ED Ch*,..2)+p)c-{-&3EQn8)e I123TokR! Hp
@kP	M3Unique Idf$ (`eP   *tu`    SӾ MCalCibaᆏ6N AstPS DL A.Zb0B [ HyO
ЇELk MEUk'g'MRqN/G/U[:P1 : C g 9. `% ]/MCle2 zc1 dik-d3	ps
 H

,
* A 5>M(o!ylSp   hnology'tFYadapDPXE RPL Ex|#Popupz(  0 10W  2@ 3 4 5 6@7AF12z5 15D`@ 3 "M.B~ ouchpa`P5SNon BIOS DMAr nsfers <F1=Hilfe>@P^id[in؂\O؟nzeigfxpeicQv  Kgu4aobVcwieP@z nLvEeinun(	Ɯ-s
kz
.igneDpd*nwt neh䀂7/%Set@%SRheitsfunk ntoa u
 naDlt-KuO] Gertes/-$-ID@ Ot 7	U>sttz ! 0pѕz#  beim /st
nBg !@M r5}nHsvorrq##7..zu/rck@z90
B .p,!Kf_g{ms>0Ui0'ExG੟AkkukeK tBsgewǄhl@DD-Selbs`s8ôItivS9#LtIpr 3g 0: tpplAlTL
PZ`OS
@ PErweiP%SpraQ 1a;n!4:#U"gran Feldsrt-O&O9!86")e ҀSePMbqTa>@0, um p_3gfahBj=A, ESC=Abb!#`W`Ierkze!TJasN0\, Ja	=Meqh`m VeZ
zpMarkė"`s@{!*!'MenS% dPfeilt!
^dxQgabe2RmOq>ko?9 cs.	folj
Bn 
sg:-> r LeGQ ?= Nch A\pd<-RBc?hritt-`VowA(TaGbul!fs+ Holl+gedx F2@
38@= {gy EscLhlrL@i<PK kan~Lt we Y!eiffMgy16P=`?rgetrPn.:Dc  01 L@`fitM B kqcQFY+<W\selnomvorB]er0ilXW^qDeskU-KsBhmu  f 3asbzw=.2Mobi`Zbgptz%.` Qz qh4Bi///"2f!
}[KAlgrѫ ab>	chlosF-Mll Prozyprtt` wig!60a"Ca`-i-Gre (L1/L2 kkapazit OMPum"Famik Sp; umm Graf/ik-Rs@Q Bz]r-Con "
A   a?7J	b31O m2O 3O 4d0qV si H>(F ` 	o	o
o1
L
2aSe
krET*@ L$ƍ"%'$b-!3Kc(1  WalkAZero-T\<One EdqA(`PnO`D+: bX7 stqbislwnKp  ZEucQN-/aWB _leQb s AteAi#CP0&ILp`ak A:nfdC6
lW$ge`KR/+Pglp%ɏ53 L  8	/  M0$wirkQh"vQM?`|3, daᱭ
l^iew QPocF\Lˤ01 ( anH12 (UmfUafdIGc$fhrxdauP(Min.):G 30ZБdS`@0% cgt̯59wuwm #HoPuy p%ubr`"w: ؑH	ԑUnbeaaMTHC52^'rvo-L 5.
32@lhafAttoribu0FID 2u"LS.M.A.R.T.˒XXMs K`kwp eus~1L Dea  JaQ`eD/t Fal8geb e
U	ңBU5Ip dminIoz Dur1@`'@z`|  mg1i@eFN1s
gd,E.@"< ttifiz eq s{0yrt.@s Zu@10D0LzO 9p袓enl@~.Ajb s0Q!Qnp'PlsAviceTa s ,ܠF$0@ h`$pSga|F	 :	 JZΰtfa@npWUm Fun)S7O, m3e\Wn HP{tectToolsP=c^ty MaGnagпUo-- cڑ}- k QuickLock6Subnd$Fr#q\M#"e$bi sϢnchutz  f_-?1dԨ@imd& "+a A)N+ *W"$B><#, lp8$meh1A #I Nk>"ʠo3f`ot-Parpe n}ґ:-1a$P7Waoke-O0ANS3tTjmCD-ր&g1M(%UT:an 3A;m$"rivie*Fxpla `t=?PcNs E-A\s mY8unbrapnbar.IpT
f,NҏbewBBSHsXDŒ,h  %G&*0	M, 22\v),   L2m@nc8z@ R󡀢B?egriff0dmautomPw S79@>ohl@C i  Qکk`}p#tw`Z*f 
X'U!!¸!mU"n O P o"a;)lrY}#OBzw痡58g<sQ}:Sn iU.) vduQ(qSX!qs qh!ac%Cw  Prq җ+I s0  qurFࡁn׷hE o. Escdrv empf/qS	 d?zu !цRO| t. 󍡟  f.РYҵF&1 2 B 07 b-B`ntra :tAdant! Whj`!@Esc-&Ll̠>m kW'p'p`\ F10`esh:
x3fg`g 	sbD} m  p¡@MMuBay&m )bBtgk`-E𴣑b(links)1tUSB-b#a-2؆Su`1Zip 1`234 5`678 9`QFn/Str	g!Ptŷ dEaCГ (USApf-ZePcB`iebss"unabhng`  cAr Grafik-Contr|PrimSek% VidGeo- rnBidirebal GrPus Lfa`iCb0tzb"d}r W_WAN-Gf0`Bluetooth9Uanbp/a jEgpaOAggr `E?'*0(o)ur/E t 1D20397ToqTRrB?!" svxHa`13IPQk"ovH AkkuPP  @RtA   x a  Kalibb 
 MakaO  Niuala   O fm   O  DO,tOTrat-?6.  .O .L`b4obisp9 cOO5"R0	E gnOOf`.[r 1 : . % ]labbloz(2Entl ho30P
m* 2a
 GS-2'su uĠxg`RadapΔaABPmB`zq}ExpA-!-Popup{ ( .) WedauQ0]d2 (Z Y  Ke`~BIOS-DMA7-DaƁb@߀EAComp0ropstn <F1=Hjlp> Dvoply9s!VisCވne Gtil` !konf0[Ge;ndзfraM@z@PSrU
Jgnorđndr oP(fslur  ub,t gdBOtnek@+hed Administoradsko K atodA7 fo@r'·`hEd`je-iq		+	*
J	Sm -kwort	Godкodelsf 7`do`_dbyggGOds -&2	 cNu@00fa@ksl2 U$c  Dg
$s)9IkA\2HF% Ba.HAX p b"d`valgte b&HDD-Oselvp^"tPr Hukox QAtrol.& inRrQҽh OGH omv	IBr/ Avancq Sprog Vl1?s mo2nedtPt felOC4+'/#5l5!Tryk {pP7 tas<G0=tZOP`=A, ESC=A'nnuaFs!3=JaNej "J, AR=MGb Brug ps@
NA`RP7xe?  releP %_menup(,1Wt<ENTER> /ec>A)get.tafp r'f!f7: -> e!& MELLEMRU?M = NlA<-TILB'AGErTAB&2$wKIFT++tF2@	:*@= Acceхh0!hk> hsfej 8A3ku1i$20gs 2dodQ)!xFF1n. Fg01BRnoVD-p% qplax`9G!krv 'vek`EnJJ
i dd!?sP flyMs`Èn#/MEUqoO5 bp* uvetzbrCud2JI,nemfB J@`  KPrc c?or-typ 
hBigH  ztr`7Crcache (L1/L2@HVROM-dౠ fami'lie'i;A.Wdeo#f0pd@s:@Xr-ct^D-ba si 9eI2o`%3o&4Zzƻapt-ta`oFej1("Wat)	O3 OWEw B@ex{%Is8rP4E$ TyPyC%xy lydes!Bmis 0'JbvD1IL'j`e0sje var0: DB! s|e  alt@xP2[holda po Pqt2`/b Bb-BEdduw5,pr Pk
khEuGrBA:@tTUETf DF%v`Ugyldig/
lt-  ngivuİ,vi av٦,? i#K?@ $1 (Hur P)% Omif`) sl(ؐ`{ ():G 30˄2j  `1x0% frpudZ44b2@DR  	cq: KuB+"UApyCqS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5ܐpyCD@F8Ny  Be@}ft nDeyae Fra@l !e@+ń4 PR@{	s0FC		ƈ4 D
&K|E  beviв@B7 9!Cfdes, f.. <ramG261  PoR.RVuAj@me+tabWata. _Du bu8$AM flAX:Ը vic#ehCa D[G  @ߒ[&?r !,ci HP te?ctToolo9"jK Quickpau`LsQmP Skrp!0rKvt%#k|qX)/sa1-$$ Hvisat `w@x6r,l
di ubilK2;+81ol p@?frard )x> Qlash-@$4PR@Irn>=m#LAN u7r  C?d-rom-p' YD4B SHop7hF:eIEu1:w3h0z,A@  Da$. l jb TBRUGER-0xOVEDADGANGSKODEN,6UP.U alPyg=s ni  ned opMau,edS "#
{	QDat l@po PWI_FQqShjlp iutComo0 08j_q@Fbyg[ao9b73pk perma anPTigz!ܑ6n?do` wfys dskP:2@rbAupc(On O"(0p	v  H.Gh)Gne AugW"Ņ Pm/, som!Pa ck@
Ryt. U p~ sg/c1  ikoqXS`.U  1befal kraf  ̓НFxᅄ| 'A @"pl . \u qÉy
G񴁴  &cO.q#ar"J "4,Q/d i૤HuA0.q.foq:@ENtr!5ESCq. t%@ or| U'F':ge@F10FYS Msf
i/P D+s	 u Dk Osr@flgdm vďRRen4HPskm DS-bas  MultiBay (K0`/$hjUSB-floGppycc{0wbsu SbAzip2FraVTredjƠFj e SjSyRV O3 Ni ̃ Ski mQm F?n/Ctrl qjElPv(aisk)pege Ust!
u1PnP0#rm-cr PrimSed Vo Out PGara֎T=j@StrCL>>ohukoPc B< t6nr compu0P ^trm#gt WWAN-!
sio_BluethМ/A (trodllo`~net0P2	pQၚUamstyC(Q*8*t#op+b +Ethat 1K23KToLR![HL	e+	 	Ent6gt id-nur7@VaFP1riqB  S!   Z 9b/ `LKalib) n
d!igO x  0"ѷ YPO H KO OM\bo   O O#01ion OOOO$Hgs 1  1O O
1Vi bPGu"[@!(MEU)J=K=OO GO1OO  OOO[ TPq 1 g: Oѿ@ . N % ].gmt2 AfFH5L)O3@	Genos	
k0

, *  J/X4% G)' ( FA qt @Ž֡ r "popupsink(sek.Hǀɀ25f- UbAg0P p BIOS ATA DMA-rq Konfigumas  <F1=Hjelp>`ilxinP0jon sP s2{Laӌ$ak")Hepfra6#:0@dioA	:Bk1)g avslu!A B,l BDE;sprograt St p'assa/@&Op4FA|U)yrsi!>vsfunkqur! tif׀%୹b-
vn Sm 16 ׀#>godkjSq0 neby`5i%itpt5auTilbakeAl#3fabP@Rg
i
 PE7;aN Ur_kty Ƽ a܏valg A!laQD5h 8>vvt Ak  MbT !#`]!@U3EG *
`Hpӑ!4vanppr΁lg 6  Dem75bM @\3dtJIel\3 
.5E6o%<}5TrykkC taJ&L&i  a=, ESC?=Avbry`a(cBAPp{JaCNei rP, T\Rer=M@bb `kvYneppilr@Ot<ENTER> hv ddu ve 'Vt?. BrukqdPp%l':  -> e$ MELLOMROM G= NQ&86 <-TILBAsKEwrigʶTAB&"HIFT++TF2@	)P= Gof#l\ ~WsfeF`  SPk'0`pZmnop@5 P M0|m kjresfve!@0m d;i pp 9!obaRaflEy@sbc^ 0d wAXa`1A|rvfucll1z. kode 02Io"Produ _t Nopablokk-mlql {typ h@igv&-ga zv$buffN(L1/{L2@Meng`	8Q	enuMV@wo-T:jrtroUuSW,kobg(Ri,oK91 qi 23R40,p( E
1w,9(Q0 
oa
oA
o,
NEk#Iml`ߢ4$Eoc%Hq ok!i*ps(A"Walp9g 0s"-h1jH( Ad`ss ꀆe7"~e PnAd 4~: DsA#. z tidlSCho!lp`@DTH[aQ "/he-  d, rnP}u1p skld<k`nn@2A:۲Os b@Ҽreg1"i%HUgyldig#DSR`	F
	#NEh0mt@Eb`?{]F igsno3t_te?-̙  HN 1 (R nsclXbP (): 30A3ggr 0$s0%0[v\st!vhF_f!_: 3Ka"qut``DUÓ5$SQ&eGt To(Lesb'1Du+q vrib: ID01rs<pS.M.A.R.T.-f^C80CC  G#Npu  Bekreft njA%v`l eP㰔 1qrEّjvlikt aDu!0 oC2Ѽ	aaŤoka9g3ogs.r8ɐor d<mpel& Tp}?ّ.rPa(A=pph. `bfku  amK#0vice.0u$la?eD(s aݢI 0"H i HP ptectTools3curity Man0`r.'-RN%l  ēla1nppa0us L@$AO!mpEr`i!gi$eu beska u"1-U+/- +`WE%q  '. tgl`rh,v@=$pڀPŶ. K$$RmEp! rfrard- 7Parll+vꡨFPhielQr/Pia LAN n0^af`04  CD-ڡ%vbX45w SHo/:eD@ Gh0valgAt5Arj h($s6 b~BRUKER?HOVED-8`tDK |umu ̅! E
 n_*GQFbe M`P
P ﱡ y "H!мa$ #
T,U]?	̢$ۆ P8P,pp 4qLL KOM @ autom\pDyLock5eabyggj]dT3lAc   `man1ilg_ge	. k_[ho fysAad $0ƴpqtW fo`?	ex@ᬿaphn@g@E_3s `dda gu»z. aUrrjomd Q1@0/e X G|pnq
LB  uSbVnbefaQwr G	 q.ҀAy A0k1E rғ&2;k _!R!'I7MEPsy-flAans NPEv
,2pESC-|L Ѫ(b u"'fD'J F10$Z
be:h& n؅$  QNor iFOrse MultiBayG]| "Qdn(vee)0ko>.ngsbaphhyOBUSBeA|w Zip-U
A A0@AaaˀFn/Ctrle EAVd(USA)Gekeen0AQel!	`jZtr9oA2@deoP@pJTisarrPfFViA7ti@Q@m<Fgradi/~trdl@ |t@
WWAN) OOH OHBluetooth /-eftQ`mbQn AgssNstyAg!1%%*2$ (v0&#.b/! 1 Eth;?	.-	3  !RP@NT s* ooo/
;niA@jtifikRRC&@B:riPJ K0t@ h  @6ymbo> KalibadK B!es"- Ip<pˀ?_Dual ,- N	O	I	O	O	5 1O	O	O	<O	8ksp.b O	O	O	`nd 4oO	O	
%O	O	bv mob. a
H. \L.\O	a}o 
{{O	B.[ TO: La. В% y]afull"C2F~i3
in/Qha* f!y   (o J/DJ/éiǋpkium sin@ hurtig~E (sekurѷF12-`f1.Sepute P@pRBIOS ODMA- rConfiguracie la Com adora <F1=Ayuda>~ rchivoࣺ m%l Sma@QґPGu isco? flexiacP޻ R	a (s!valoqpf doba`y Ignambioos y@li0a A{  g3 'Ln epidadAs#e
  ' Ajiciof%posi s_SITc)$ +՚@@*VKskSm>Cp SSoQ0e*cP#<) Sectyincor`% E0 e" 30/c XP>6fb	rI
a`DPV:c!3nci]~)AutomaHerramia`C~H er 8`#P(8` ;prueba HDDK!c ' >OGVp&Memoria2a d*mp.al1@JNKRMu0GbSG#
s
 AvanzX "ESvVDD
W? Fampr)co0N gr<1o?)<>UOprim'wquitec0g2)Pbao=, ESC=Ca06la==Acsepv=SSqNK1"Y, C9o2	=My
 p U@{B$6dchDha6al~  alemo apropiu=@[*<INTRO> z@ix:N1n.Fs{3pkԕTY :Esp~o o -> = PrxcRetroce
s<-{0`\@axTAB S	S'@Mays+#C(/F2!-910`rƠ"b"uErrx 06F  No@8 AiGSzr`jo u@QRA6K. Ccdp`01Bhay n unw>эqubRnY2@AC1+>bѪr(R[co rUD)JНebook/MEU?IX1QP\2O`0ple0Vxitosa4e Fak T1ytil CTisOp7,VUclGpuW>XTamauZ_0h (L1/cL2Oc FAAROM mil|@cNmerD}ribvisBUv@ j6r g-l@yo!! 
/#j1l2n3p4 EtiqurBAsI2VehFK (ga  Woo.o3oopoi QB	Esnؠ!*J8T 5:Z$?  ProbUS%bssfactcXJ$ǔ =ll4R9eo 0poX@1'	ln
edi$l@z,
(CE| oD"F%Ad  :vH ui[r  eap. Pre#/, `WcqscpdY#auA:'p, Uu c lQas ' Ӣ,hp9tegAң
S^@vlQI$\e'vaPa)00٠>o(a) 8!@%c	Za?`gnޗod ilO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcuvtieej 2( s):G 300g3o B0%&~Db EaH0ּ _`ipalGirumq
 : s,pu10 qIQ{`3nh7Servof 44apoya atrib0: ID0p#@exs G
X0Y<A`sea<KHnuevL@)Df ApagE ndq9S@gOB".X		@e voc`"	k"alp3a 
0 Lstnad ;`f Rn"]e#թ&9 A*# \A<Q, (02o,GA`Ơbs (R6% Ey WciR|LLꅠB hrpinR3 SBf_ oltı9al ol` X#A!vu	j+vip.AoQ  '{Ùv?%(֠WapaAuydAn14n HPctTool@O)%!!&  QuickLock ~Suspen Blo`jԹ\Grat S 6""t mej`eO@`? :0d++-y	(BI	( !)(JrALlRt0,"D,0XৠZupizQ,.`ؔxHOre P	unP+Orojo%q>lWS9MLmedufhdem Iqdno Wak.n LAN@H DtiRePI" ACD-Q(mEřal)[Pm:\ Usi+o:b	u4@S 0S`Rrive+2dL$ t dBUSUARIOM PRINCIPAL p1 oo şgwYNman@Y p 0|. AnТ;7 y gu`'` lugpp  cAjAp~0.1)TM @dk` \)hG1
f b5@ָ]@A "Tw
mc;N	;I0orD=
`> ʧ>1DRnRsuCw  , fsm1$ !RulrSoc,L"oI  /be}"<\su 3Ҁd/a4sRcuBMbVt"B! ?p~Pdah$kosa pg`԰6Se {oenf 8d@lic1a6re!azA3. /?k 0u񡂮`#PZ230a4=inͯK nTBfixP8Z`
v\i pons2> XcY_, pip2 ESC. ΰؑalabP'Fd' 9 p,F10:̼ݲwfGAᠿ'a7T/bEspaol O R3tMultiBaNZPa DiPsi3-p ;]fb0co+Ļ(iz(@jeCch`-5 cB b a1ЇШ&SuwkrDgZipcpmeaeTer Jo C`5t x SpOvfNo`DCUs Fn/`Ts@ncIngls (EE.UU.)sbPŤ (PPmplSo}"le$B
Ғ b!Ac@ Gѐeo ModZ"y!  Bidic Ta	m&#m@Pљi#	sifQu0p{ B,ICA IR01k*WW x{BluetOoothA@
p}{Py̱hoйergsGCp-oPos 6B/P:(s+ior)p¤Ethet, NЗboaoU 1/,2/L3/Tok0RdO8OEredPr23 IpStifd ExcGlus sAM a`  .a*C0g_-N0p[0SՏo`Wr)Xh !,o	o	k	o	h	s0bpkn	@o	o	eok o	o	 o	ao	o	%MEU  o	.o	o	o	o	Ub2o	o	o	o	B8[01[ :rg". c% ]/ip$2 @c4Ќ-Cle0τ3	йk",'* q 9ODJ)o!qoh ~1bl䑄@zArran1p@By@gÓXDPХg2Ex Q찱`  ŐF12QTPAmb@TouchPad u1o N uTsсr D DM=ABIOS֧aPub  <F1=Ajuda>rP0Info@͇䰩sobPo Sf EเЈ?4ځmaDӲ$pR0
rt7padr0
3t  Ign`0airPA	4sPs '&_1nanL6a zO DBr%& pς_`#ƕ b!X_d#!P

StUd"ԅ:liz/pΉO
(I b 0؇/R Q*Ag%ԠbrB
a#utQ<n 4dcЮeal0hAlo`Oca c(SFeQMmas@g1=1iCP8$!leOpT HDD Af1)r  VR#Le Mem @PA<PJ<  4tatu UQMuPY`G]8⫨ Av8!S%,io Qa`xd; 1camppJcinzP"o?CA9 Pds`e qnr ycк'tinuar i=' SC=Ce9lAce imNK!S7, Q%ou=Maimg Uti0:psC	qqp'1da` o i  aprop@y *u@Tv#<ENTER> t5meRez[@3o.Tgut9 ^r ub:  ->
PAO = PrxiK\<-QB7ACKCExaQE06TABo$SHIFT+C%* CF2 	*:`=kSC# 9nErrrOA@Q@na0WoQp܃mRHE. CdigTGo 0o1  NPhG`,@o `qS)  s@ vizKCA A	bMev
;ÔZWotebook/C[(RWHS mGsTe2_DKKXqmBm xitonN  Ti0H݀3VpcS_\ Tahcache (L1/CL2૦FX a` ROM FamslY  N 3sri
RevisSvde0@Π_aJroQ La
Al!D	Ob a(34`Rt)iep	JIOeu6(]){ 7o n)oo.Oo$alS~Secunda '$ 1rcC% vf+oi"gv@!mO al  Wwalk  0eʴ g1i	a [lien!M !oc0I@Advert
: 0[Aqfo vae!djWcqP/,!i`um  gravSvuu:e)EӎA: n@Adc N S3 >B^hO!QtegiEa	c]
vl0IyI(= kT@ctez0 ejCa $,C? iN >?ý1 (Rp bo2 (A@ng!qf3 (S.M.?A.R.T.ax`=_(~.): 30<`хѡ0@CT =4Q0%?1$bucedeA,qAhostDCrom1
: Iss-P$Eg
Ch`Ӂƫ(*erPmec   `˄6Q3sM tribߒLDp`AМexa@s w0QUUig:TDgrg`alPSLs   qL rB+4ۤiPArrfDigci	s gҐ0SAdP)PPЉxacmod!CsާB! fazA@ArEr`a,Πer dform!r3Din,PjaD0.@eHCsHfbrcagusadQerF. SZ  Q[ea 2krviob 	Iy0rqX )QT?%0,Р ur@r0fk
ad`pis0S,B,QuickLock!Suspenso Blo`qtBD #u@aSM%` mabnb1IY @k,$$al#.2P4Lsa eiSSib0RPuǟseu sEEgxigU`re*PbM0Q+ &perme@$1l p즅+maok6n LAN}e H!C#D-"ίgGP$qme:SGusua: VocË@jp4Ca0yrV2utzroDrive) t@$UUSURIOEJ@ESTREbI SC(̑:xq?Yapaz=@L. AaQ4P@<de-ЧrPisPMEEAp"@. NQv p^֦*6Ye ,Y`+b(N 6 0.bu=l*Ƨa !Hde`D.Hi``Ĉ72{s1!Ei 崧O:WAWGs1 Y
oc<w<o  supʛHf`oo,ao Dnf Caaberi
a`xx}oW Ȓ:aq(΂4` a ƀrqur< Ǹ{@FngݲX |af0W | 2|,@ p;) F `3Bor nalp`a-w
Aa ΢atႻEsubtud C~ ?@*hR)ssa޵ptA-lVJ/trW L !8Z  LembreH ՝vqMac`Pasa8
"qui_ʰse`R ESC]Ō9Ƞq3lav'f'rF10. rX`r:MrʺTPAc]D ugus Op1k: MultibayQYiNc`isi reAFpBa baЧcopld(RP ,dit$zB	Rc"zipcPriomeir"rc QtւO]v@N ؂c@aqAs F?n/CtrlIngls (E.UV`ыxS[qhp1troa8؃RءdeAcund a@h`3LPadrBiQTaPhBmemO"s;em fu0bw>zec10+CA.#RPa 0RlmWWAN) ` oo`o)BloothkAAn(a/ E omCenerga1erec-agRF2.11{5e/2o03su0Ώ3;Et&netg	O`p
/*3/CToken RingOO bo֤Idf PSb 6auaqW, XSt`s)SsCbGPdbptgemNS vl⑹CAw#[Dup;lo&	ted /	)	E/	jONOOO'as7AmO/	`kC/	cIAl0  OO/	Oj8p~AMEU/	@/	-/	G9Dф 1	/	/	/	O6[ Etapa 1:rregr2. 0% ]Oc3l 2:AcvN3:M* 
 o9ayCCm*O"(sDflex`QSc زrydapY!瘀i Powpup> Exb@ ~àF12(т? }dQZs Vara֧a N u`T@s`s DDMAFIOS`i k0@{mtukP  <F1=Ohje>JrjtQt Nytto vPbtu kP Tallenna levykkee dk@on@o" P20utFDFo2CejunsW Ohݧ mu lop6Lr W t
2
tдt7!,Tpou aurplisunvojoan ssa0Mrit^oKynytk LaItyl	
  ~usnumeP
o$-
t lykiu  '
,0)moМnu kiGa
/!(et  F.t3fsB5*tehd F7OG" t!"$j;A6)ma`*inTykalu"`A;  o9K := Ki3Gvyt OA9@p%EMu@Qk!` Ea26n D:m`-GHLi{sieli`Q`Ipk aec  7harll 110= 22R2#j2H%Jatkinjot  npp@e`=d, E?SC=Per`F=Hyvksy=Kyl;lEi CM?, Joku!L=`TY` fnouoli
mipR_ka`h$@
si#dsN <ENTER> mB7Kt
ep+.I@KEgn C/ss seuraavpU: ->Xi VLINPPIN =Zs  <-bASKELPALAUTEdhb1!ARKA+! hVAIHTO+', F2@
)_= d@!;virhtAkkua e =o9i >da.>: Rudi 01*ka c1sh ~ apHrt2Pl pU eytke`"6ko>@	siPQlaks q0rsRW` kaCt qlaaP^ TikkI)>skeytyi FnB
i(pO2nL^oh0ebaGm!|jA|}1?i@d tyypp iIn :fapllaVlisQ (L1/L2@U  ROM-SbmЂkoh	tuotespe"isar0{W]`si ?stohjab T;{	!1:"#2o L3o`M4m)J`Lta1on7;(j \oa)
 


\	\J䅸1kA'r#a- DqACu0
$#:D$ 09aT%dzb~ lpi!iEepoi Walking 0 -[1Yloso@Vaihtoe@ :uvi7! us: Tmӵ atpn9hp 3. J0lt luo p2us-  5n9,2Pirjonc!KA: L"X AYhkuV V3beFAGB08p_Cpa ᣾
GHkoa]Wi `Ӄn? 0`/  0҈?ͨ,i`%(N92R`30.M.A.R.T.Arp$@[n (min): 30-s p2y0%cL dv0 Ispysi- 4i	VgR
{fb%untq'c{K)jServomoottj
Lu0!5ÂvtuQ	k@Fttri
bti2@З0Žy@a 6UeqKxe nGpG9W Uu^EVahvu  &x P>2Ȕ	 ! PC  ޤ}A"+ 2@s@a	,-ãPAJa頴9n4-okkpDvad`5an H	InDP -e@7p$Rmysba
`ǉk1h@` ЁeT @	dE	ZEY/r i0Xj [!K unQnwby:p\vea?pahtum"b@^id FLaJ4tii l <HP PrpctToools`cuQ`Pger -apuД큶.f(-/U i` n QuickLockfa hlu5qf ,V "@FPraZ&-Q,:*sekm #o$j$it)a{ad||}yh'  PP`0#pUC.7>uu	SApor IWnfrPnR%!bkHS0m 4em`dHert`hiԐakx0ʡV CD- -jl
"4[w P1FSjPZWAiot#@ebn+ De#'(stt&)pOlla. p  /@! KYTTJN= PS~SANAN,0FCN{.qa!' v`"0*@lyQkur`V0< ribj^"#t@br
(V2[I-(pY,Qpc``mwLLA 4@1^q*C OQu `U	oЩs- V4 suqIzAr?Ii,#tu Bx	8op R
@J bU7pbI r
V|}meG. Nykyfr`+r0aq~sQ{6v
t`i @S.u. Tqtէ 0$ £ihQ{eip=0uap@MY<eh?  IPa*?-p@F|_bRt0HtaY(b=c /Aojaiem qrftat. !WQsm "ftBTV@U G.2 !`ZXu1F_f}0D e@pq0pǠo#\@X2Css,aT>ESC-npsRV;n,અ'e'A> F10%Y4aa{ :	o .cVQ ll qt{Ƅys ubn MultiBaOpc&JW!lakoPiu (Ɛen/$oi>) USB@)ZipEnsimm2 AbKoa oelj }Vir}Ki eit@ְKak Y KymAai Fn/Ctrl"mAȫ+PEng 0(USMAUsPPsa!QB-Rsq@ ƖnрjDBsCPPs EVPo,t>tVakio	s2sN#Igfuu QHРDpl1E ko@QWWAN-roHLOBl]uWoth @/Fh` sV߀Rs	 s:lPmӏ
,1i0> y/2,-I, ?(ylos+OGCO6EthCerHo2E Y oeo3o9'TokX$gOohA workQc&G IlivA AGkkuT < TԁJrPѿ r0jo@libr  ad Sual`-OO OI OKblb _OO O  OsO$ O$O$ vva_ OB  O1 OMvaa nusBkPBOD OOOM bOOOOX
OI[ e`i:r
йada@n . % ] @ODPW2bl` urp p&OE-O
3
GoMOH*  j l9#`Fǐނk`qvuɃP iǰ@ (s	e  nA @:@F12:ڴiP%3tappiQkoske@ߐ 'mma K  Ei mn BIOS DMA iedo Pot Configurati5ordteur  <F1=A0> Fichier Infor` mAff age Sauvegarder sur dis!q``c Ra ,r xP 'uneA.H_DHe0als dfau`ow {du'Igno%modi Tpqu S%e l'in %p regom	\ Scurit&Z
e ss`Nd@ S"#j@`e sous te PKon.D
 priphP %J	a sE@IIDy'As
{Dr<Lockq
Smp(CD0Cr1P3r3̒  'he5 Q 1b#a <݂gre taR, 9)+5p7am''us3;),;rfrencHM =at"#Ou\ !@lonnLbceriZ sle-cqSn@psQBPs AIATA$BFoV,?mmoiric BDX C0ZZaFB_V AzcpLang4? ChoisPJYl3Ind)!5_mps g! 5ePMd.rpa`k2Z}:z? AppuyDfatouqpo@gepu@lw=Ser, ECHAP=A lH>Accep S_0=OuiuN*#Q3V, N'impp_e``1D
=paw  UprЈzi3
s f'heM
mo!04ecle hme;nuucer@rwbri 2qhz!y <ENTREE>2nj+W	ss	sui0/fa  !/ :!-> ou BARRE ESPACE = EPBe`-$IEpreced@S<TAB`CA*'zMAJ+ix F2 =1"w-`$!S(rr`x@P<TJ Il FA%ssibPcQ7L U cs='Jprod{endp#B$P. kCoa<'401!)c5Cntв@-1 empla3ce( L' 0D SaQre@}@C'y
GJ 
s}^ccueil dP "4@ itaxsmobia``
W 
u` B!OOOF2BfCX+)a wru Fa0;cq0M\ TyQp0osBV8wDb KTa@rcaa(L1/L2) VGolu`e!gD o ROMOamR~ Numro#p	Rev`crdoerS2ItrQclavpoLA}ud ;n+/Zp$/zr3/t4n"3inv!/Qzi&5 #priF!L( Ute)OOoOOOBV'edA Eo MT֍ :$/.   %Er4 Q!SUPc;Walking 0ᥒ81l;ig'ad`aauZC	od g al0ifAtip1SC[a=e@ptcruA ieЪvPR! /0簹r,  mz{ nroc	cY0R]A}jDL_聡v
 tro Pa
0s
TX	  _D[Rvjaˈ"`dH.On m:YfPS 0"Ӏf   +-AvaPC lp  ߚV ? Igno7ꉈ+| z Enregeo#=1 (rap`)#>2 (coet)u`|pimA(z) B30堿s pAU0% nv$D9yl'hA+bF  `:@˗	AsGinpnud'+,`v`t
$.ELu( pG3p 5A`ib!O: IDP0ࠒ0@"s S.M.A.R.TAbanG2WpW AIBY`se N!=apYeAø?/@;sa#A Mar, uinKS ;A, e,ecoac	;mme, vK*ad11POobPbatCs	eSdp4D	 pe>a1a`(`ifh s4[,P@s蒵 `Ug"  for	mQg-hq#xRѼsJ.)rmQފb	hJU@0`
1AJ.6zT"`QDP~aR avoupR!Afr Cww7A^	 	zY R`(p"}ff1Qd  k;#l2TcgN<q`rHP P`o կTool:eRyW Mar O4K8CF!/  QuickLo;ckUsusA |$cp!#ri 9 س<S&ocl'S+C)re!cB!
`Kp)!nk:,   v qi4//  / L'(a'a
S$ud!v
 KP
dra+D hn 4`ExiAudP `  4raQ8llƙۗ&flashѫbWake On LAN\ CD-'EZpalj\:A99s!Ɇj$e Drwivea-. SsD#DDEdez "deux,&(UTILISATEURPRINCIPAL)`%H	Balor@V N>z _MA`I!!&q%lsr `/qfe4Bcelu2*QDordibf4. A  pTV	~(`sdRZ-Ho `r uDfetCu |MKQ"t"	~"a"[""qoip> >""%x 0ՑH)@zANaniq4"05#'o牌#!2/r,Bcгǻ!o!  3pi\H!! !! {e@^qQW֊a"%uelR1dX :HLk" ""opa8pE* O' jW'Acbw# ,d'orig[inIlRv`OHB2C{a B	u
vqS"فapAQy9Ipt0M倮
5dSjavsH0P~7e* ߹-$Wq=aPprsP"t Ձon: to@Tp Ra1S44PpabP}t3ۥk'
Qyj, appuy
0`  ECHAP.@@@@ OTzR'o', puiCrDF;10@TapX 2 1xCxY^u}	UZ/qFr/ana
OgҝACJiMultiBay0ulƍAph0A Q!3D,xsocv'a%(ga)OOFRz) U[8֘ USBqr
jZiprP:0 Dhi @s QsuaQCin`NSixi` S9e  Hud /NeuvCD`Perm/r(s Fn/CtrlƓ Angl|pSA) Poॱm1`s{ A`stanp6hnROd'ad`n elAtrlS' UichQ&m`
*d :i@7idoA񯁿Bidآ 0 m)mVl@1jEK!al $ޖ R o!=ril WWAN (rse0i{l)1grA`PBlooth7s0/?1   >o`$0@g`Q@Wloc <G `c@P!ZqX0b91
bP-n o;)2ooypu<	6ccumod4ogB E1t# 1a%23To=kRingo oU/IduT9-ar a[  2     h(% ll` n!Kre0/ x Ab!AF.!f*Dupk* /)///wb/// //**-///Jqgn$, /0,/ /e s` BtexвsqbmoP/ /7/// ,///7[qRpe 1 : Char. % ]A.`Ij 2D` GicM*n3@	Rkio.
1* T  @ @/M.$oOA$Ʊ4_Amor1cFe"5 RetardBTexpx `) Dж:a  F12tWposf[iP+Aux  PatqbAKw ucunİferts BIOSmDMA I$P zpOlr <F1=Ai> nfogQema
l0'Salva`l floppy%@AttoRiprina dnThhi@fa0``ip"Ignor`d!ed esci EP a
l'iI@Az eiBtupiczza^ sswo&e amDrato gcc3R
q7Z,,vos7xv@% IDs
@פ&gDriveLock	Pr ɣ+St =CP9 SupA=c30 gHg/o+:,i fabbr
4=i	/.nzi`[Qco
rui UC`b5<bae9E lrOpa t2;o roigidAtpaA'VP!΂,a me0VW`<HKhMiM;A>or \!Ava=t ,eLu!O l$Dim"& q6ca X ssopd geviQ gL1	vv!'#o*62wH8Premi qpsiasiesXperQVu L   k=f, ESC=Annu`,aA Et0qeo=SiSN@1T,altro#	=A bj Us"SchiavI frecc'!9i1 vocpu ap70e"_`<INVIO>  \k\'e.ipYgui  un%:@ -> o SPAZIO = xsuWss`0  <-pB7ACKCE qc<TAB@C%o"MAIUSC+)XFa2	>-Ћ= m "AC"IErriS0D  Qut A87nppupvse@t"Vi  v@u4T|8pXJ. C{'01 N0u 0F>QQ9a0}oggiao Lk`IP'0 Q>re0
4Es"@agga%Fv0S!t`ғ  npabook"Qzespқ :\ ZҪf.atp_
2o{briu`Prf uduAA ND  Ti"+0<PSpVeloIStespp@YMis1ca(L1/L2d&dDbRO}MIamiglk N@o0H`(	RP[3[oi#qSroll TsjrAer ~iI1OFk2m3n4ࡐ7w PVSTe)D
E(d)8
	2
3
4 D葭Fonda
 ,:o:EV$ Tr%OupyP!gTŒ@lliASpr|:bit 0t 1R?indirip	i] `| 'FAЎso:5X%? ?gger `|vpAhAr1e!0M/rѧ, O`1faAvi P}PiVLYXA:'mU[VA:"maconouAh(,_ IISɁQrita] N
sv@dpRDlIQOyളSe3 `cvoPga ?AFbІb iQfre?@?: Aɐ51 (Rap)62 (C?omplet"2tio (): 30>0%Q5"r6ar0䠈'hD5|:s*Щ -@
˱֤(aD୆%aerv|")LċAPLA'	rib i0go=l: ID$Ban`de@z قi S.M.A.R.T.!ޱuT0U _/wordc(nuo!i2 pDsc(Ui%L?Ibq+d`! {â"Znd ?՛O.A7Tącq^B&
Am  AVf!B;YpCr	t>J2fuDm y3CePe<B #u _tH`!1a哰.Q]ՒbdFo8!erdPКatiwEff+Jizso@in  ca2iHvEvPgaζOdesХP@Jm9Yy HP tectTools Od. ZRV2+ ickLocykspen`3B05EY moeu`s8 MM  d?#<#,pv  gra@p0'!oe -!e $C-))v!pKsm@]0x!! b	,'URa]r i lі@NR(@|ГȡV|a infraQ)p y%La_hflWashBmnQsVLANp Off#o CD-" Se($(FZPp:[@ !SRQ#3ĝ^{usanD e1*. D:AJ@T @@bҁ['UTENTEPRINCIPALE  r@.a man8fu`o. AnPV >FgP0v a%e QF@p0f>0.l@h0Au YPTk^s,bh	Q_q2L sb0R? 7reDZ\f.APR A	 Qco0%98 P+ AB.`D
 Bre,0@q  d (`<t vOH r luogo @DJ T!B'     #l$ j@IV#:,!vI</s I"I@5-"÷[tHClz s"o mP0!R/DeB  /$BH@ æUEa(  ݰaDA'a( gQ#QAi  	Potat{fa+ ueY/c dO::l}&.2rPq!u_{9㔓!.Y)uA`YEsnOP@K1'56h,mP킊ёo ESCƞM'v)dovQrְ 'n'pom!nF10.  !n!kK Wyȴ_6\%זt qIP(i 3 # OA:D0b@ $dM MiBay baN1.ggas$Z) ogCh>i USB]L$Su}kbC
ZipBP6ox ;Terz P`OЁvN% ec AС" Fn/Ctrl TIngl  (U'SA) Yi u`2O mpl 01asciЃR7pl Ua 0Ѐ࠰Pפ Bid0HCapa memqX5em$bs"F!/lD Q2'c/wNPs (WWAN){oBluetooth>Commu	Ю/ (J)Csm energ ]hW'g)1 N,*2HB$-Fa-( Ko)oek/spo Eth`etWJ V123e Token Ring p!OE3 IAkB|# "Cta L   Ao(  C02b// WD|Saoo [Kvi0Du0V /  o 6  / o ,o// ooda C  /  o pUY\mo93/ /-ooo oȓ///poo[ PAs 1 : 
ros .  % ]<ocompp®
#2S' 4,n6E3 @̀
ij* 
 /JqoXaX/3i'o
  FlOoppybUAI!dC@ p(sec.)# vel0F12 b 2zw@pambp@NzupTras   DMA BIOSup <F1=Hjlp>rkiv {Sy!~infotpзs~ S. pk%kPiguQ 3(stll_ frnl@Ppn ard Annua nd`` ochsQl``   np͑ SkerdPtrsl0F  K!aOB rt-OaEnss	(b -ID 
S ao
 m`
Rd-St?d frutsav 7K
 byggd 
usBi=*abrik`m+ .J
sbehrig#Gskts@rktyg 9Ko +r vP6 S`;vtiGHDD Ak_V Minnes:" @01q5Q ?@An@#B
S oVlj4rD ;cBnedtolD!v(C-j+eTry@SI fri Dg s nr? du viJPstyY=, ESC=AvbryNaFDA/ccepaF, V=Mer X JvI pil	e	/pCa PyEt
<RETUR> oqm6
YRtt .ke,lj`SeferI  : -> кMELLANSLAGSTANGENTEN = NXS G<-BACKSTEG FregeyK TABf#O`KIFT+H& F2``+?|=  'fO @%Aoi?Cfel 3t gqL @ kA t h+AO` ~Dstod uGen. Felk0197 AsЌgF{P|plat  NtPhm krv3? `pbyPgm0 fly5s t6 U-Por/2 ex䚣(|0Ytidigooi2-@kl`TA UkN,q  Prr, typ
hast^hg0Cap-	rlek (L1/L2)Yd ROM,um  familjrenummn0Ddeo, rY dttNb ~pqyrQ!]H 1.$z2#3$4rbinav0̦3 (bZ)g	1[

\
Sek# xIrq.4$$@gaxr%Ex!z=ok!pvidClmissl l.s Wal}k0s - ~P f1jH Adds li7AeޡnVar! D`@/ѹ  7<neh gx"Ccuskapay /G-tRxiƱ=k b!h$2AA:1R3 K>#Rhi{wIBB?sk_yddadag

 ! Eˎ҇8A!^Ԉ  2|? ig?D܇jG즦a- 1nabb8pf@րn`X9UWk ad k$pQd (>0): 30@ncpan 2?0%bX A4Pp/]pp01vr ka&tPo:,tq	!قOk%S(x er7vo-LzBր!i @(f%ttribut: cIDpx?grobsr.M.A.R.T.-5 GammN u7 ifin@ D> LܰQ  R4bd% pm}vlika mǄ  'InE?kan orsa@3iЈP9aHSsNyp0PO@Om=<s1A1lo. 'Na om hglmabtj@Deh ;else- @^uQuayVqΦ >fun 0`perl^7!i HP tectTools%٩R->6-Quicka"q`telge #Lp׌mPs Hgk
	gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!aot.c Kж7AompHi p@1f   Pk`anFlash-@: s!Wake On  fr\CD-0Xw QPR%qSt HuvuduJ { fK: D . Gowhsrdvd D 
e . A1 a@`r ANV>HUVUD$} ɀmaV@tt .^ P 1A "RN`ҁ< ild ̈+A
 JёRh vpyL l "C*lqJVDQ.Z +oI XqeDGga2{b2bygg7ZSY3 g 5///1dA\J8- F"Z0a`=om s-KeB
C:d@=  At;as BG@fj'F\B] ktuai`qafaanasks .dIutN^tg Ps0`AYq,vїur?sprungQb#@&MM. Vi  reko a4F	c	YrA`+,0s@t b`b . A `Kad΄37 _j &g`!b(gA|O-befosesm ih`pґVfljgns. Tr0  >ESC-rQBS֠V ƁSw㞑`u'Z'R-sedMutaGF10` cVi3a:+dshc{ nSvea ҅ܠ: N?, MiBayCr3ut opBP5vi BaG (`r` g(h!SBV G Zip-`=PW AsFjQa uttoґ NpT VxFn-/Ctrle Ǔ E lsp(USA0@bmYkd! b`n`r;msPtrorx,& hbbelorleklheo2nek0!L!BIfs@i]otrqtK (WWAN)0Bluetooth /() -v@ĔmbyeQ Aggs`haE(M-21,2Svз[,p`8'aNed Eth,& 0	3^n To!R@PN"!Unik *@?iG K  tus      Sbo Kalib@o  dp~-  eF=s alQ. O
o 

  
9
Fo  
E 
D0!m1s
Aoo
E
Hptag *o 
*( 
VC| emoo]A*5ooe 
DIOO Kood
D?[Ne _ : ;Lapr . 0% ]
kl+ar2u@j253omFjOF*  &V@1 > I*O!DgOЀU®br @4sadapП$lg rdrjQpsnabb|0 (sek. F1 ܁Bd StyrPguIOS DMAaa˰"B%en iee/  Op Teslaan Configupo`anafPvtndaardP"/  scy	Wijzig&ne Pprogramma @РSetup  z1r w܃ȂsveiBeheerswachtwooޅ
 p%X. ApOaatbOgl>$$ ID's 	gaSmbA6CP  OaB u"5P$cR%m@j+%O
GeX@gӨ gssvzie܏"Fabriek9s.ugz7@/);Vref|.s:nieuwأ8OOc  E{xt`AccuxB 4\e0P geselec Ea p`Es  zelftGa [-schijfuei Act P6vG0u` ?`I R!a/H4UBgDAcg@7n ,DP=%_
 w 9aKc!: Taala b  =r/emP 	rijsgemaak e	l=;o" /;9
8ukAZ ] {NMLg]g=S, ESC?=Annul"EDG0=!e!oJacNee fslui@Q, AQ-f =MN Hulp~pijltjkp`gebruit1Ѕd )jui`~xnukeuzk@ark^<ENTER> ind` 
cr]beZo !vol%@@`1  0aiX:  -> of SPATIEBALK =>`<-BACKC}EVoriglɸTABb	#HIFT+%%|2+K=  ykp=t#B~fouta64k p It w_ge15 F0MЌreqatijasen. AcoFZ01b a0.i1ZCu  we   Netvoe are0#FMPN diVbas`e3
 t n0 notebook-pc/AP @.PistNOQbep*igdooh2L	MЛaf.t NmpALyp6rocessBnel3Qpp OmPЂP}e (L1/L2 Zapac?i VH߯ROM @ -s2!fSP<mm E  Hebvrgav_0ideoAkp&p;b  bpM	m	raI1b2rd3be4hisgI t}.jne C(B(XЉwM@dzQ%) 
 `D#Secuib@E.aw~~@$"Ftbd%)҆2!dHU2Lp53Hac-0-*j1Tho_adresrlafwisnd pao􁎤=LTop: zPt<ts e'ge t PSBbeЉf s d1 A:og-  /ޖ"x0zbLӄe6`NoffaG1Y\f_dقڑD `ѱ

boචgAt
wO,C'We nu  Њ"
wil?oݩ(""a?Ox
Zl"+1 (b),2 (U0Y ) Аpqwrpn (min.): 30 aee&p:L;0%Qtoo `4;q{ho:5broA):]eeqx/nb!$32#kvo-IPs EI"
2`"qk:J S.M.A.R.T.-af@APP@udh "/tBlo0!  A  I-7B4kXqcr lpSX8
 Vr!a1& is bBs AYoCf#Z/k, Tm]lijk0UKQߛ zoik` dvors:ka?0QH fQeksKPugzet,r lorZ@¶ZOb$% uswb sqwYfur9hou
d'Hi`!  AQ`R`T`R&BеѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k  p?gsppL`b TWm E #M"g$rgΠ9bl   ~erX#W>,.o(h( o( S("7p'EAJb"f k otraakP)5w# sXbtK;?ݳ ]Qŉr p1׀frap=d  Parˊ Flash-malIr=demia LAN a	a7hӁ@r}- Cd-r gHNѽfH/oofdZGw *I  U15|de(FB`DL`#:@izow.HOOFD-WGEBRUIKERSbPՙn  p'anA S3C  Hgw!#N$]  fykkvcomp3)AosQ1|_0)t D "g+ЯqA.  ]0qp1bAutomPOc8>}X @r?:h^AA_<T< O!V)?!=NPSS!= !. Mo[i@aQnoS4H,P   n2S8`PȒ`VU nt@ TAe.b/ |@hui`,̺dЍ wwas top/!k wgeab.JԻ7[!nvloeC]kPm\Wsn 0Z^U4r`ra=8	WptorH/) "gect.  o
 s  v"N. Omun@
1]A&`3fe*p&agol8q. Au_ر_,ܥCDyAbhl  $cpӲep3ruk3<pESC- (A9 ±Di 2B'k'tyUbkn F10 @T*ZĒlu0S4d ry`V4  NePl G g MultiBayBjVzakd@\~base (иgks)re> USB-Մ cb+z`p-f E2 we$qVV@{aZes >ZÀ>Aa8NFn/Ctrl `Owiss/j @м.SStaµMcW3M?ijsappq1Ov5e 0qՓlBij V o- qPF`A/Aˡ0d`dition  G@vgp<uqVPilat`E?"V/p neVd$`> Radioj WWAN-aofoBluKet@h`/o$JrgieĠQ[Kq^.(	ba)fcEt̐ 1
2
3iTo}R/-OMobo!023 UPXuAatcuI<< q6us     S#aGekali@!1OAK"2
NeEualR\J OOCOGEZ OOO 4^B1^'OO&O H0~paA 
O$O"Lker-MUE-$J$OC$ P1q+OO+O  [alp 1O : Bo@r1. % ]@/& p[0d2knte~l/{	3	˄
fo@hl/)* Jt  ;>.C,$"q $#aXadap PҢ(sec.)pop-up bij snroC <aF12 )Kbb cuorsorytuyEasyPo-muisG1 DMA-}drq BIOS  Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋa\܂]tsfBNɕۑ  ݒOCOF畜ďg&f 
H
gɁ  Ho'׎ 
ςɖE	ύXɏI  `AȌԂ̮܃@ea L({epA`LCǗ҃p h/do'o "X yf@\̗L/E%ID&ID: h (uN XBSA$͍eX} 0g J 23T|OH', v".eI*"%ɀ;FX
 ؖ>If
cA>oAe̒  I(f:nA%e> pCeBIvC"F@ `F _ H D%Jc9~J; ڍc R5BM NnP$߂A2%E@U`UO tB!#^sNu% .37($b74L[BR_ h=!AEsc=C8@bsAS60=͂|
  aRAg)gjq5\= 3gp] jkڂ %iA@gp>[Ez]  e >ȉ#wA̀r_->Epy`tOo[ = ET  <-SG[Back?Space] a<%[Tab!AG#[Shift]+eF2`!,,,10^nmF/[~%  !CG[  ӂ@DBCłͫ}@BDrp o 01 yNF`+@~3a
ɂACOk ~ڑKWv@&eb r?O x1X
Mp!mQ^0fGdMEU		Ȃ2^e`	］уɰޯ   ۾  xïݸ  ށiL1w/L2"OM OM̧Fٔԍ  ޵ ޼ޮ ް ۰ׂ޽ޯ ްir ޯ#2.3N4h	 pŰch3(Â)FE-3N4@(JkvJ _!nFw XcopF?$qv sPxП6!;LsV+Walk0s?A-1B/Z hɌѢʎp^`OD4x:2B>tƁAC %C颴 ׂĎhDa/ŗp쐬AFA:݉ b#}v!h F FSPl	NXWM֎~@YqZos /9@y(c  ցB	H #ċ g Oog'`,گЯ1iNp`2i׮S3p.M.A.R.T \zsԁi?j: 30Bײ8>v0% bj~!c OK z3 eB~ f{:@	{em`cQ1kT ={ǂݨUעfIFIDP|.B a"R`R AFfV!'/i `¢k@Ρ dAJg(B(a| ͤDAJhvٓB"Ǽ /  Ǘ@{R@rRVdNJǂ̂C*p4qu`@nȂaU C	 !]ţࣂ"^
YOꍇcxei!ݡ£	龂 ÉƂ `Ƣa7df!tf
`?"dHP ProtectTooslsh}lWŒǉTBq#j,.qB4УMmN*u<"T h8' k{-E`O'O H&J8-.))Tی삟D<<D%蕴` g@4`dt!~(!ċNb8v"Q ԊO GPuA0V @QlA [_ށۓfрC!N7Wake on LANh CD-Pu3(aր $} ^ V:`%A}UK (iHb'C3ye@~( |`<ݭ'	8 >B`/ZAT?iR1"i	3	'iEl K	͎W vpR@sAMS#ˊtK@@P!K/,Ɛ!eF|e\Ӆ JqA 9ߐ  <\0ۏ؊ԓ "łbͯL |nł`k)/)%)Dp˦ Z7]t.z"*FG`nGKa(o(iLn$'m@_@] ( IO) F)u
ϊ((?(9(ágDx${:#<43ɑ`ƈM3 f=ɉe^@&A)F1j 8cB  B獑BAȑO"Ocĭ(2ef̯旌8dql@ӔC౨aU"1/g'|EE[Esc] 񉟂@~elAثm T.?DriveLock t[F10 MS  y_Ԡ7>`E:	 ESxtkGb@ȓO xXioiEcUCSB ӅAXPXp H Zip1Ԗګ 2b 3 4"567B8910r Fn/Ctrl%̐ ǲ@{`\p (USA) `Ӄ|B#foX
KAV&ds
v C\gŉ  }ZJ _ rIso@嬧 cWos%AwCY OڑͿ̧pYblNi!WAN{j%M`Bluetootg /#jְߓd `qIntel  Executi@Disable`0ԯ..1,2O,.̯.odhEthernetX& 123 gPq
AOKO3 O@$OFj) ID P7bfN P     ' ppfbpU?k ej] o \(@%*nP/h/!!8!) MEUEw o** }ooo* w5bv1 : [ds . % ]!O<2 !gOnv3		@)J*   5 %o?s'0njvSpeedStep technologyu␨ 	_Dް Ӱ px(b) 0F12QԁibyH ^E`b!q[B  eBIOS ATA DMA]k9                                                                                                                                                                                                                                                        -  ` a b c d e f gt" M  Ǝ         	 
 Ҕ     
      Κ    L    >        Р         Ш   .  / 0   3 4   5 6 j  ( )   , -   * + w  Lnp
 N % u@.   0LnLnPLn$Lnp+Ln 2Ln8Ln ?LnELn@LLnRLn`YT `@E<BB<U> FبE0`8l v x|v||p/0p7c   c 0A   = ~ 
=$$$<   DDD    O ae  i  o䔕 u  /y $n  %Ap E%w  IC&O &U    Y'N( ~ `' ^    `!)y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( )' +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {{VROM+*'(

C$: |  s+'(?)+'*&83&

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      g|LnA  Ln^@  .@  bGLn@ ED U@n_.LnL@)@ I mp  ?q@TrA*rBrCsDsO*uFTuGuHTvP Ja 7 
Ln9 SeLnXdLn2bLn fLnhLn@a@P  gL+n@W{Xt|dU Zt}[}#L  ]~&  W_t`$itVaV!
	$
\ 	~ 
U`	
| `
`
Fa
bc*DdeDfPh(>{&$`Ln6@ `   @|
 j( 
( 
}r l05 m | }o : *ݖR  	Ln`b b 9 
 VF10 Setup Image_SETUP  P0Sq  ; T	d I*v@Jä"IP$ a|`պ 6
P&$`ԩC ؄ ٪TԫTԠ*<Rg!"$Dcz: 'ᴳ4㪴4崵4窴d鴷4D9b` : (]7  )$*U*$++$,U,$--$.\C.9 .Qhໄ 0	`9 E$HTg4jH@ ȶ#"" $" $" 
8 b@JNu@OPP 8 ;	 
@      /	
Ln&XP  b"    %    UQ' '#(!(U")R)S*T*UU+V+W,X,UY-Z-[.3WU
e/di0iU3djj4dk5kU8dl=ldmLmU\dnBndoEoUFdpMpH$IqJdrKbzLnpqIr$Js$,i]cLnU@  }| ~U}`~} U@ },~ U"`8tYu wxEҪ~*z{tW  }tl 
O5L5(@4 Q^`ypJUfԖ]` dRd];UU`
f!f 3{y5ԡ  &^ M*@ 4 U: N j@zU @_M0@ R Uh  @ @WM @ , B V t@( WM @؀}M.@ UN n  @U @S @ < ` Uj t@U @ڀ_M@ 6 UP h x@U @S @ F f U @ʀS@ B d ՚ @	WM2@ V   Ā @
@ * 6 @ L@dt @j @@ 2 J b v@ ʪ@ڀ @@ \ |  @܀
@@ \ |  @܀A@
M&@ > R d x@ @ $@ Z t  @ʀM$@ 8T V d@~U @̄ }@ M@ U( < ` @U @_M@ 0 UD f @U @ @T +@ 
  , UD@l M@ /@ @ Ur  @S@&@ \ n U @5 @(@ Ud   @S@@  , U: N@^tU @ո @T 1@ \   M@ 8@ R Ul  @ P ~ j@ڀ0@ t   @(@B@ h j  @C@ j   Ț@
5@   , > T@h @ @j ?@    $@*<F N@Tn @ @Ā j@ @K*@   $ JUD`| @U @_!M"@ > U^ p @ո @"TH@ 6 N r Ֆ@Ā#TR@ j   M@$7@ f Ք  @%TZ@ b   M@&N@ X Uv  @΀'@8@ CD V h@xR 2 @(T]@ & ( , U0@48< U@@DD\^Ubfj U@Tai @M)=@ @ U^  @S*f@ N v U @ƀM + f@ : UT h @5 ,b@ UN t  @S-l@ 4 F Uh @5 @.m@ U0 B J b@Ur @M/p@ H UZ  @M0@k@ T t  @1@@ |  A	@2@5@ ~  3l@ f R  M 4 Y@ 8 UV h z@U @S5 z@ B V Uj @ @6@^@ D T iiiiA` @& 78@ B "Uf @S 8@@ : ^ | @% 9@ T v   & :@@ > iUR z@M  ;@@ L Ub x @M<@ 0 U@ Z f@pUtx |@U @S= @ t  5 @2>@@ լ   ? &@ d v i @*@f@   A@@ @ X p @j @B@w@ , > h @ "C@@ v  Κ @.D@ j   2Ej@   F@ h   @2G@@  ̦ H@ z j  @2I@ z   4@iJ@@ U, @ n @U @ KT @ 
   U@8 UB@JZp U@ 
i@iiLRi  @@^U| @ȀZ	iMiD Ul  @SN@ b  5 @ O@ 5  Pz@ 5  Q@@ 5  R@ |   4S @   0TT@    M@$U@ n  C@Ҁ Vi2J* V r@i@iiDii iUW  2 > UD@Vp U@ SX @ d | U @ʀSY@ > ^ Uh @i Z@Ū@ Z z  Ț@[@U@ 0 N n @j 
\R@  ( D@UZ @5ڀ]@ U6 R ` f@Ռ ^T@ < f  ը@ʀ_T@@ J ~  5@&` @ %~  @U @Sa @ < H U^ p@U @Sb@ 8 J U^ r@ @ԀiiiAc@@ 8 L h |@"j@Ԁ d@@ f t  @Ԁ% 
eT@ . J l U~@΀e  f
@ D P p @ 4
g@@ U\ r  @ i@   h @ \ |  @ i@@ V   @Vj< Z RҒ  @Sk @ f   @ l@N@ $ L X f@ @րmS@ d   @n@p@ \   @
o@(@ d   @p#@ l  Ț @&q@@ j   r@Q@ \   ܚ@s@(@ ^ h | @t@ * 6 > D@LTZ b@jrJz @iU @΀u @  
"$8@@U^ @5  v@`@ J	J@f҂ U@ M@w@-@ D UZ ~ @S4x@e@   <y*@   zԀ@   
{/@   |@9@   }T@@ x   5@ ~@ D Ch z@ʁ 2& (@ D V@izDiҥ@Ҵ R@Āa @S@j@  4 UF h@zհ @(T@A@ x   U@̀ S %@ ^ p U @ЀS @ < ^ U @̀i@ *@ b l  @Ī @@<@ F Z ~ @j @@@ & H f @ Q@ P p R @i S e@ ~  Y i" U, > L@`x i @܀ v@ @ X p @j @i. < iiiiAD `@v @ʀ "T v@ R t  @ʀiU%. H ^ Ut@ @  4R F iTp U@ M@@ $ U4 R n@ @i @i@
r@ N p  @@ l  j @( @ h ~  j@Ā@ < f  @D@ J , > iNj| @i @@ l   @@ b t  @ @}@ r j  @@ `   @@@ l   
@&@ P v  @榀@ L j t @j @@ < H  kV@ifi@iv ҎJ @ƀi@
ii i "J ~@ U 8 V Ux@ M@@@ R Ur  @S@ l  M  @ \ Ք  @(T@    S @ |  M  @ x U  @S@ \  *	i @Ҁ	i@ F ipDiҐi @iT@S @ < V U @ЀS$N@ h  U @ҀS@@ J n U @̀2 R h @@@ P ^ x @ ( @ p z  @j @ @ f   @ʀ @@ `  j @ ڪ@ P t  j@΀2 _@    I@@ f  U@ M@@@ < UL l @5  @ UP p  @M@ R Ux  @ЀiiiA @ > \ x @ @ J h  @Ҧ@ X ~  @؀@ P j  j @@@ ^ v  @@@  U2 N j@U @ @ T@  $@<UX @؀S@@ h  M  @ j |  ʀL @ R Uf  @S, @ |  U @ʀM  @ < UX d z@5 $@@ ~   T@ v   M@ @ d Ւ  @T@ ~   M@ @ l ՘  @6T@@ ~   M@ @ \   Ȁښ ȀL@ d   @ت @@@   $ ,@4<D ^@fn~ @ @
H@@ , HUp @ @ N 	r @@ d   @ Q̀@ i\  5@@@ Ո   T@    S@ v  M @@ v U  @SҀd@ H h C   Ģ@ڀ2@F @ N iDiҖ @΀4@Ԁ@ U& B f z@U @S" ;@ h  U @΀S @ 8 \ Uv @ A׀E@ B n  @ܦ!@ 8 N l @ 
ـ@ iUB T b@U @ i> X jT i M@@@ H Up  @ڀM$ ;@ ^ U  @S.݀@ ~  Q i S
 @ : T Uh t@ղ @T@@ T r  մ@؀"T@3@ n   @iiii4@@ UB \ v @բ WM*@ J ^ Uz @S  @ N n  A% @
 /@  U8 R j@|Ւ @T @ : X  U@ S2@ ^ t U @U @Ȁ @T@ r   M@@ r ը  @
(:@ B R iUz @̀M"@  U  @K@@ * UL f@U @S@@ z  M @@ d Ֆ  @"T O@    M@"@ v Վ  @T@ l   M@0q@  5  \@ Uv   @i 6 L j@ؤ i h i   i(08 >@FTi^ h@vU @րi
 
@{@ i  i<b ~@Ih@ j i դ@T X@ J l  ղ@ր@ T  Ҩ@Ԁ@ f   @0 ]@    A@    @ x   @@a@ J b R @C 
@
@@ i2*i:@TiiDiii i R@  < R@U\fx @}  ]@ U4 F l @]U@ 0 V j U@ }@
]&@ 8 A^ @ @]@@ ^ h z @Ԛ @ 2 @@ F T Z ~@ @]*@ D V z @ @]@ B l@     @ J f  @ڦ@ p R   @	]U@ , : Z Ur@ @
]U"@ 8 N j U@ 5@@@ : iiiAD`z J@ @S@ %2 V Ul @5 @
@"@ R%R j@zU @ր} ]@ U, < L b@U @@*@ J d v @ ,@ , < J X@bhl v@j +@ R   Ҧ@  (@ ^ ~  @^]6 UN ~@M "$@ z U  @Ԁ5  3@ UD \ r z@U @_]6@ ` Ն  @T7@ < j  5@@(@ U^   @_
]>@ n ՜  @"Ԁ6@   T@A@ f   S 6@ : j  @j @@@ X h v ֩J@S @ Ȫ@Ҁ F@
" , UD b@x 
Ҡ@$̀@J_]$@ 8 R n @Ҙj @ M@ b   Ԛ@$!+@ x   @ O"@-@   &#E@   *$@   2% C@   6&.@   :'@P@  ܦ  ([@ \   @@BD@Vhx Њ@2)@@ 6 ^ niiQDii @5*@"@ a. H R@Zp @.+]P@    ,@j@ P l j @ - `@ 8 T l @ $.@4@ `   @/f@ : T v @j 0@Jj@ D L @| К@1 6@ \ x  @Ț2m@ f   @ 3@ r j  @4 p@    2)5@C@   U@Ԁ S6y@ > P UZ f@մ @7T@F@ X z  ն@Ԁ8T{@ d   @iiiiA@9@ < T lR @" S:L@ T  Ք @ހ;TN@ b   @< , T r@ ( $=@@ H d  @ؚ >@ ` p  @ @ܪ @? @ x   @ @ l@ j   4A@    QB @ Z p@զ <C@s@   DT@l@   0 F UT@d   RE@   M F@@  5  $G <@ ~   HT@ x   SI@ \  5 @J@ r   KT@A@ j   SL @ \   @i M@@ B Z * @؀  M@N@l@   U* 4 >@FUPZ d@lU @5 O @ ( 
6N$@^ t5@؀P @ R r i@Q@@ b ~  @ԚR @ D ^  @ S@@ z   ,T@@  ަ U @  Ȧ  V @ z   ,W@    X@ 2 T r @ҀC@Y@ < j 2U @b iZi
@<FTJ h@nʊ M@4 @[@ p   @\@ H R p @ ]@ 8 L l @j @^ o@ R v  @Ȁ  _@@ Z   @Ҁ @.` @ \ t  @ؚa@ D P V ~@j b x@ X z  @c@ H   @0d@    
e@@ , > N b@v @Κ f @ : V r @j g@@ H h  
@iiiiA
hT @ L j  դ@iT@ J p  @؀jT@@ h   jԀ
k@ : P p * @i5 l@@ UF `  @ mT @ h ~  U@ @M5 @n@ Ul   @So@@ ^  M p@ H Un \ h@ji@ q B@ n   r@ j x  @j @sƪ@ " 8 J x@ 0t@@    u@ j    v@ ^   @$w@    x 3@ t   y ;@ j   z@    V@{  ,iU. <@ZU hU @ M |T@@    U&@<FP U^@@%@
i@}ú@ n  @~T\@ > d  U@ S@ X r Ռ @րwOM@H@  M $@6@  M 8 @  S"@   SN@   S*3@   M G@ ` v  @Cښ 2@ P i3@ i1Di3@ _M: N V@rx @ ƚ@ @ H j  @Қ?@ > N j z@ @2A" O@ UT v  @Ѐ ~[WM 2 N Ut@ @΄@{ @ @ > P n @f&]@~@|@ 6 Z  @$@.@     c@ R j  @ J@ X ~`MT  @T S@ & 2 J UZ@|D  @ Tj@ @ X p @AbM Ԁ iiiAA @
@ 8 NJ d @" @TB@ H b | )@% @Z@ D  X x  @Ȁi  TH@ 6 R l U@ @@֏WM2 D R Uj@v{x<KgMU @Sx@ V | ը @T@a@ t   i؀T }@ P ^  5@ @ U> L Z j@}zlM U@ @T@ f   5@r@ UT d  @M
u@ b Ռ  @T@@ H x  @*^j    =@ X   ښ@s@ XT id r@U @  JM
 @   DtWM& T .U6> F@NUVn z@Ւ @KL@h@ ޜn@iUJ, \  @Ҁ @ 0 X  @ @ L j  @̀<@@   z@  Ʀ @ p   @    @ nj    Ҫ@ 2 R p J@C@M@ @ T2h@t ҺihDi@
*@  $ * aU*D L@U^v @ƀ@ d   @@ 8 X l @j @
@ F j  j@ڀ(@ v |  @܀@ P ^  @ @
 @ 6 Z x @ª @ @ p  j @ @ `   Ě@@@ f   @"Q@ H R Ub@r U@Ѐ S@ N l U @M @ ^ Uz  @΀5 ii	A :@Zr j@ "U" F \ ~@U @@ %` t @F @@ D p @Ҵ @ @ 8 T ~ @j @Q@ F b r @ T@i @M@@ h Պ  @T@ t   Ā@ > j |@ @@)@ T   @  @ V f x @ @7T@@ : ^  ղ@Ԁ0T@'@ |   S
@@ h  5 @.@@ Վ   T @ n   S@@ d  M 
@@ X 5  @ UF j  @j |s @ J X d ʀkv @ @z@j@ @@ B* ` h n@
ҕ| ҮĀ " @ r   ! @^ 
@@ J j  @К@@ T r  @ꦀԀ@ ^   @@@ l   @@ T x  @ ׀@ p j  @CU> L Z pD L2JV  iDi @A H N@p @j @ z@ p   Ȧ@ _@ T f x @j @
J*@ < t  ո T@ B ^ r U@ M@" @ V Ud  @5 
@ U: N j @U @S  v@  > Ud r@5 @ @ U   @M @ t լ  @T @ 6 @ H UV@bn~ U@ U@̀ S#@ 0 B UT f@|U @ƀ
  J@ iiiA(@@Zx @j "U: b  @5ր@@ f  %@ҴA% %,R P %p@U @S @ N b Uz @5 @@ @ UP n | @U @Uʀ @M@@ ` Uz  @.c@  ڦ @ : b t @j @&)@ h   @@ F T d x@ @ @i@ ( nj  @>b2@ ΀ @ Վ   .To@     h@ j  @4@ l  Ā&d@ n@   7@    @
@ " >:* V@|U@ U@ S@@   U $@6BUJ V@r @
J @ 
Ҁ X  @Ȁ W@ @ f  @ښ }@ b   @ঀ @ b j  @@ n   @ @M@ z    m,@ X   @m0@ N d  @^mC U* B T@h|2@ iiңCi"@DJX r@x$PnPLn / /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй `s# hNfP u	fX@  h aZY[Xg&ۅF ;9   Ã tfPfS
u	p  bf[f}XRg&u-g&
pAgf&A"fV  Vf	=t@/g&ƳV9g&PESWVfW&O*f%Vg&D= $ <vD# D| u:t+;'_^
QRfU
}0t[R>tKutE$fu
0t0t	dp:  f]ZYPSR uIW)_rIW&u5qVt tFu
:ǅU. %+~'<t< 0
l[ZHZ"P`0  ;p t; tށ t
t4d> ud:>u	d:uހuu o@ & u
( 3 uo u_X!
j0od:rq 2fSQV3Ҡuyy  :ut ffKfy+-Ƒ3  49fnP'D%g$ЊFg	Yu xQYr14"Wu'vx8Y x, x Y^Yf[PR 
 Z #R;;=b;a>Ҳ;!? <SDD"!US
F.>6A OfŰCEf`Cf2FRC|xfWAaaAfG E f~QD$
pD$ f|u6_^Y5OfQfZVffbXtf8Њt 	dWD 0 rfP%A\2YP	Vu uff0SF?t!hXcgvu}\>t]6f뿢wup0f7:f^ffKV  ^#Q ߱ ux @>tgߊT% us]S f!%#$hf,"%@ f@%90nQRV&>	>W&N N BU@߾&V&mfDf% ffDs7 ^Z`!u^.0f 4sp2(2{É4^^nBn@& D5t(Pf sf
  WXfff8[3`6'E82`D1~R Ih 0PPVVVVZ|ZVZS `So<1 			;/acZhpcR}cxZ4Q2p(`C F%fQfRVuu/7 1M3y o P  	 6=h䍚1( Q 2(  f3߹ f`dTt ^ Q ?ހZp8׀@0XFfC@u$G#w>k5ys>H
 "o
d
.Wu)@1?HVՅ`,VuZ苆FFVu FQ$Nu$G^fAɢpxx P^"D	%ÉD	f:-f ʃ@v@ s<v PfUK?fЂLf Rf$f6f> f	>fBf ,ff]Xo t `-̀Qyԁf𔓋_`y RӃf;3 Zaptރ> t5u A*@@!v0pU
0x@@בRV"T ;f;tff * F?#B/$ q gfQERڀ>  fù f1C;t)gf[+ C kC@F]`*iKk~ e1>SRPVp ^Aah3 ;u; p;[b7P7VXf.0X  &
d & 
 R #  DH ! 
 6P ё)d % ]#t@w ,{Xd !"$hB "80)
 W.g Pph	<
 0$,L	
 E2)Pq PP  (# P4!  u	  @
p	 p 8J8  ) p@: >  *J p  % R R!	RV2
X "


 @&V(xiQ)	(w.`+)dS )(b+"P( D: ,2	*0, LU(($!Tp'#	'$	#$	Q *	&
&
"
q,

F1(AhBK4CO''A,A 
/	
#	&h$
$
A5
Ip:0(|:!TMt:BJN'y'dQ$> 1#BuU#!,)$3 +\+F'Ya:Fq=A;( G0$G
"w\D#GV9/' ANdCN)$
$Qa!q>Q !Hr>PRBSRAh9B3e$bNL'UnqM#uY@uQl!%Ai
$
$y(Jcp(dpyt@
 >\c8Kss'tsvQ:y$y!!4F;	(AD@a䈣!vlxW'QJ#&$q3$n+$3	q//  @i@v
 v $a {#
 `"9	  aZ izazT
 Ľ" 	 !=,map 	 h}w ЀO 
PRfWfg&f_Z!Rغ Pý ZPðV Q|  	`о@  :] 66 r zq!B !;P  )aab/`(9T9@@PQR5S>9|9 UWRQSPV rw6t ur6ffWRfP0 eXhafZf_P>6u6uaPS7 pu6@666U/66D[XF f sftf] P[YZ_]e È66أQ 6 uPu j0fd!u!6! ȃ uddfdm԰  >P6Sd ddSP (66ufUg&t=` T=f]t,>@u%ttt t	tfN tƀÿ)r@ualn)s
 1Qh 6*Ou߰Fkވ .!u]$*
_VێeS tOrt*ـ? D`*f ׷f0T fffXs "qy#uptLe6 ` 6 uYf3f` fe6Wpe*&68fw*fF*2t*܊e&6fX^fY[f`um'n!(o6  =["  Āu(g&pv6z]  t(]9=faSQVWU&u tu **i]_^Y[LS-120ZIP 250PSQRV:*1:2:22PKp
y<w
m z
\5	6*K<s!hEfP u	fX@  h rg;<tV< uWQ5;f g&:D= uFfG(+;**X!X  JAZY]f`uu 6Qu66666v0 RW.h

N} tE2B*/_Z[M-Sys   DiskOnKey 1 #߅aBu u @  f<x fP f<"%|= 2rޒ 0w"1s sU3IH t gf&RfQ ff@fPuLst6Lu2r)g&	ug&g&c,f_o PA	% rLT*f<?7(QRRVcF5Mome}9@**0;; t0ht3t{@ u u#P-30MAf?LfHPN N 
1fXuײU?D0 @0B0B0B0B0G05F6F 	 **&3FPqRrco?3W1>#>;!2>
?_YhMGPnh`p& 4  h1< 0SW+ 1s!$?
u$[         Ұ,X @xjY rTB@!tkn@  i|X  tց   j` 	bhoddfHff@ftnPJf&jh\ufj6.f ` ff@fP  @f%% @@@f  z6f?Af=A&  `  fAVfA`Df=%t 5t;@3tZ~0tZ}DfX$0g]A   AI ASf@ t@[|P A"sƑ tDf  f qA A<Af>@ u ` _oD  2ft.tn@P +rf6u$@@s11 >ګ@@!R0[@'r"b"q0 f!?1VC@f,S	  tX	*riH'	"	0 %9 uf-%tq00 P3  J 	P@|tpa '	uPΐXL  rf, 
 pQDtP؊*ǷA@6%f>
AgGf	gOgG]`db>?t"3	0	5
[`6@#Du	%&tnf6
A?f	f AfIng^g~5W!
*t4h ~0		0	  FFhiJ<t
 &wJ5q*pu
 'X*؃ CJ&JA&ףJqN&ibL6%@( @f (f 42a3uf@W  bf+`сawSgff9@u gF9@u 9@u
gF9AtgNXfFAUzr=БC=@rxiGsVfS'`c(gF'	@g^f g0O G0gFu V* /e*eP`d&b&g&g&G
G
 d0Gd*PGg&Gg&G
ް G 3giFp@q	f AkG^ @ZPfV c?sf@mdf p^fIf!@&@@+@(@  @ < t@  ;vȉ@qv  f@ư
Bqygf{gG p ,gG
	qGfu"a ?Hf%f[E@ !gG!&@@ tbk!f#p@fNcn `_O3B'PR7з[fS
f3ΰ5 !f$fӃ\Q?fp#{-  !Si|y P9ґtU ````a%`b	`c	0]	0^	  q
		 
	 						
 0hfWQf-`1Yf_`QD=f6D=6JKD
$>6%
ĈD
6r% >w6bASZes*K6ZrI`d
QHr7R@|= USBSug&|= t t
U	_ 	`_6T 6ӡ p arQgr C0Yj %y P`zK`2P>6t QXrIt2QfF`AdY.rϟSf1fM^!WސA@KH\
؀eܛ\bJ
pŷrA
x @
`
L!?
0
"osTq
aWa'"CS# iD=q8p*W.?4o3'`fT2_' 7/oZ(Z
2(
_7
_=%t9I R$RS$2Q	@ ?P?@RP2 3* ~h *Ou ᠅ T=
XS<(fnT= & y#j666 r}fPQtA3`>6=6p+` pta^Vu6 6 +.Pf.6hpOPpYfX`PI|{G<6 fa9?,B3U+=*/G/%?QfPfph`1@YfXY"gN0\ؐJ?;G7/O?sc?`:MoDA/BA<e=vS$l=38%rpq6Ot} Ot Ot6D$
ƈDFP!r r
9rY׹ߖ /p%tFPtt=tT= t2:t+u:u hNodty(u~(rt{^@O=@tO=tO=`	tO= ?Oh)6`oXaPSV68dtd}ӠroӾ68DtD$PQJKPhӠd^[XSQ*KO	8t`g	G	Y[L0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *8۝6T!
*  	b_.>  
   VVo       2нS[U[PV&VZ!%ru
w>V *:  > X * tVVV>VVu Vް'PSCrV4%VVVVÓQ	z`P$`
3ۊ `fV&CWjVDW3 VpVSu@t	Vu<[^@pVuV "`bVu^Pd4 u:uqS1u^Vuʀ?u[^pqq?fU >uuS>JW>uzҊ&GWut(
ߠVuZ VVVh[4ͩ@vf]AA`Ft߀>V{V r1FVw%0rN "u6Ȉ0EV h6bdhEYuY!)Z J`RȀQ	%胢pot1FVch[WIWT"rIW&uVuJWfPSQзVf3fY[fRVff3 Wf3"WrfZ2F E *  <FuHW3t	 Dt<Hut2ZtZ >Ȁ$u tPaX]EW Y7BW uB<Ft<Tt<et<t<t<Rw*<Ir&HW
2@&tZ>GW`Z4<qurYiVW@ξ HtAQ Zft(PǴ:FWOu 
  gXfCYPqq q9~ w2FWkYⷠEWDt&DW8r >t}aRw
$_^t0%VHWV Vf? t<CpR<?tSQLذ&Y[߀ u
l/qpJ@I - n Oig8 w  `  8th
   0  Jp 	 	 	 
		 
							
 

 > fWQf04aQY`f D5 p6666sR (p6zľ^D
$&o6
ĈD
π 1Ts f}g&|5 EBr`jr  a`]mm	 	n	M]`UR		`:^H\
|n6
\nse bJ^QoaJ^}0@" cc͐Ă/r`܏͏Ј-̈́&pW3
	#rgqWtX0Y"@ f#a=ʴj(rjdu6bDq='ac#a#apfqh6	 Yv		6xvF
 T `ȹ !sJ%|=t'd%"y:ur?rpq!(~rg2oQV]L	;t	PAŦ:^=Y^A ]\0   0    |RrE d    n  A` P 00 3`  
& Aa % N 	%
0 #
ک*!
 
3`@& <a` @@ 
b
	 CF
? ?a	  " d q a	!? % %@%
R +3F	 
+ (E+
"3$ 4̂  C8$+(3+- E-(C -0294- (`(E  E3 .c+!  0
 @/9F. 7'GC@<6A6D
!: 7' "J",A !E?9B@,3
O<bJ# 
 S<R"G 3D%M TVaXCJ UK8'(X4AIc  WI Rjklmm
nCopyright (c) 2001 Intel Corporationf`@ f.A<t<t$<tc<tK<tSjf&jvn sfj   uh   uRRfADf380=ISGuђ s
g]j~!t f6j	gftcRa tpt5Htn @u  u u0 ߰# 2  P f%ᘅ3 
f>AfkDt	u)fA;Awuf@ffhit=ff"Q-tѣ
0|fs
B  ңv@#tzs210!<ug


7	u\	Q	'&h/ś_AKf6
A	g~ u%S F A s@[%;u!,?f=4R0	ff4	)ffp	Q(f>	f@f[aSfSfQfRfV*sWvn15 uBT7 tApN@76g88fI4g^f3f@70n@7f^fZfYf[fP"Vf@f@f=`Bt"f=Ё &f= 0//f=0 3f=@+=t8t34 , 't"#
ttfyn0 rfFP0fXURf.  fXr  	 ܳQfufQD8@M TR2@(2Of2f0cBZ{RO>V\3hԚ1( Q s2(Qf3`_{fbDf6E  Z<gtatG@}]_ToK<u	ϨupWJ$< t<0t_$ RwHP?y"PWT%jb_uPlAP#,RfWPR;Arfc%1f f>=	f!Effg8u#>_444
f@[Jf_,,PSt{xw&]21=`Q1Yr;f.;rt3UufrA<mpf|ffm foPtP= v	 +v:P,P}rf   :rfP  6r1|Ã t}L;fՉ ǰǋ;Ptr} Q.rB肿
rrf u0`b h!2 Ñ>~a:
r~ffqp	f`f"0~ffROMIfMAGE@;uq Wt#g0 ~yKPQ (߹J 2 ofG f_ZYXug&wago&GwG0  "2/t"_t  V {  cu'[0i&[w j3
G94g&GGfԣ fCf-+ӵ00pD;gf7   h쀀1"`YW, `П.V.`B@~
>t1aë  	!  !  q  c  " ;;w  @nQRVQS ް u u蜫?g& 粰 u&quup!(fug&P!	u*yxyx>xi06xp` ;}1	ߦu	P!"Y 窯>up$3۰	%1uF &
@'uu ˷   ?鹮!uP&C ZwPuxwtVt	uTR1=ud:u< u2d> u	a (!u yufufdxd= I^Z`Xg&8!u	g&g DtF@sPVS ~u| hN3c[^XSRVvuWH^_+;»$11ZUf`(ӢLǲ&O6]Д r0 #3#[  56؆8 PxxxxxxxpSV.&tvxfW^0sQ P7W> yxSRȰWu<v
y,y@@̈x 7uG 7r )`́@%:S	ͧ1 y y":xw/x襧
/	c twdh
3	xrgo&AEtx}rxdr"xʦKr
 JthE	vcsZhtĳx{?=2oȧ13
B	uaCU$ࢿuTXp Z#,轨[$$_;tR ?Z{R JU  ?{P&ab{pZ& &Fd`R< u}12R1RgtXwr),u)RG`SQr9R'f$8t܋Yqtr$VO㰆HAr(<Fr{(!sq^trp@۴ppq90`~ f8 f܀?g' a`  @ FFBZ`b j nb PQfWfVcwUUP*`P U hX-  p' ,G~ .;}t3P_YXhŕ s  $Һ0 {	 ] 'J4 "`".u2(.} }s0 9paW
s+fUgg& suf3Ɋfe`ѯt0fYpVfWg<t,fUgRw r!8tfGp^fZPQ$@a@8tPAvUvP8F X PS±&%p #؎[XPSⱡ%a@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                f`8P%,:#%j  t4 %  ع ;uPXف      t(  "Xt
 %@  Pé t u>  uƿ   q  tB @ J3p
%tNtGf3 f ff3u@ fgf&fff#f  
f~*jB XfafPSQR.a#؁ Ӂ~~@t%s	%PQ#~Y3#P1a ff
 p'uf%fZY[fXC!
hQ 'uڳf d`uxñ
  k  `5  t ehFIfP u	fX@  h $  Gog0 dt`Kua.߀
 .. %߿Pt
&+Q_ +fp*f#"$~+ 5 q 0f t+&@%_
 ZAff ' *8+3-Pu
  +qfސ/ZYfPS-4~ -T T-hX4,"+h4f fg&##R %5  -$-{4	-8-# -30-@8@uR,tt@t
1,g ,, U,3P b/a/u@%+h$'( !!  ,-./01289 `E      x `a 3 7ſCŹRRF 9$WaaYPG3""
P][2tN]	 6aÜ`>@ l>l!GA lBla6~$?C o! G @ A  B  $0sϊF  ؎Xn "X0GBnnnJF$a %JF0wP  )< tq ̢P ̠̡  VޢW    llB  ؿ lBB@A_ l@  Ղ  @ lTпUN!z&1'߿H߿N /!% 
@  
F_Fn  	n	n	n	n	n	n	nnn 
 TU ta  @CdQ̀`  3nnGC q
p	p.nA
` nV 5Wq aPfWԁ4g&g&f_\'/>                    [T m'0 
8	ɀ$ tH
C
?T 9	p݊'
,' u B9	K SR~p@B u$Z[SfQWP qXgg_fY[ Q
`f~gfWPSf3f3ɿ;	f0<  P<
f; X tDt:	[Xf_ZfY<fPf0fX,fV>fVf PJE gߤf^! fU^	V					:		:		^		f	W		_fWf	_}
g&' f @؀:WV!  tO
ъ#1%"A$F%hT
Q 
sY
^_W>uDsķ

`+t$ X3SC+[C vS3ۀ> tt+t:+tC  [0t<w>t8tзS 
 
f  S r t, gm ?4+>++9+${
ut~or;",}5PWfP	RAM+rA a	 fX	y'tѯ$3辫踫P	4Á@ׯt1-w&㋇k+._trwRaot0
pU<< t
=:@ 0  W+р>@u耯ta+aÉ  H!q

p!@I!J!@~!؃y@Pl!e!2}J
s3y@si  Y 11F0zmf:u;pu;thP<<-! Xàww
210`r &	&
À
v >2  m22GfSpWf]2ptE p  %p ?[hx; 'Q W Cz$3  G4g&tC0f&fft.fA MA `  u1 W2 dFP h*]  '  luuh7<aR@$
#4bAl  aR@Îp  ZPQuG4 pyKqb hYR0Ru hZ	$
2
B.&g t#.g&' T
.t&*0 0rRVhvvtDh^xhr(hus*r2, f^fZf` ;2 >rb2 < U7rTrhfa~f`Y2f@`Pf3a// pfX	!7"?" hQf`/)
4/O
^ "	 	 R"	
/	(	A&!_!!!p!hBth4S$twG	Prf/f
00&˃u Э 2fà{t F<t0λ$rf@Ӑ3dtfQVW 0 ¿_^Y}Tf㐑^Df} ɣfɷt
t%SqˠǗy~gf5rSQ?U P^Yf[WSQ?RWVhpY?r=ыt
 t
uu	  tt u^_ZY`	јfQf	:Eb3:EF c6W p 2:> u6 GHt\o ?hk/T3Ҭ?؋hoeB^_f,f
XKބ
>
2

VT>T2"@OHp
Nt.
O|rŖ2Ʊp3 {3p/ 3c5CHo/ / /  WOp3`<RwS2.[@ø ? 7а"ȟfQhʐ_4ufYۉۉ;aEf3ɋPNo`pXQް&G     &Wft ffBf;Pgf}ww~rtwRtpff@Ohp3QgfY tgho뗾AX0Y[0U%>aPSph)Wh`2f[W  i   w `    f6+f=HIBM+@ u_Ff!  g.9u
g.RRFf߃kF "nSf= @t1pu  oø PFQ f a Ѐ| a!!NuFgf~fs߶Vf  t
fP#ffA1fwygffY#F$V f;s	f
	  fV2~(Fof )@ f+s
0	@Nf;sfȢF@	rf@f qg&g&fFfGg`^N &Vf fA=uTA$<ufIg:!
g
@tT	f@f ]t7> u4" $>p u01'R`b_2t +!Қtњ2#tP s `̛t誙 Z>0)p 1du=	qQT_S
X~P` u9 5hr/<t+>t&u
$&跘.a@@t"tq2t ʸ G Q !p@Řuϗcu>訷`&|t @D &	xΒ0G@f` Df{ܣ HfCLfPfO
8 fU@@U@@PPh >fwt	3@S~ f%"0 @0.G<t<t<Q=fPS$<w .$ 	$   6   %` ma  !&@	` [ +%_fWTZWW2W3Uf~%f˽+DUf1 6
AU00yR%|t  |T`Lff~3f\  fP۸f< if<w  a fXff
phEuðG
	  5  a+P
ĳ@P qXuB]DmbX
S!? ul;
 
 [D2P 
X		@2}P2
tˀ~a	
$


Àu	<X[X=Qp)a
؀ߊa
2t !P@<KrK :PR좩'Zp .' BZ s  ""
ZP0>''; Jq vJúQ PR (
PB_X
	ذ4@ZQSW 08Z_[{B蓃)
))#).)9)D)/ / j 3;CKT^|3=GQ[fq h S[z<ENWa~r8<AFJc| P)à@ PP Qظa_ ,غ:%  '3` P@P  aYrO`633Ҕ3@  
@|f Dff)!MU샿fFBFR>wN}T!t"ffvfXfD!Y fpfufT0fW M " U 0@ ЇF@ +fѰT  Hl
 q
S1H HPo3
! ك 
ca+% O   % -.g `[2r-o3,Kb2v ,R_! o3% u+++++2a,s ,c W+% 𹀀0.&,9S,1h0h
  1   F+f`$y_®pt5ef"++frрii- fa^CTNI k+p!'f(`{fȉ3p`e,  >{ &,,2
s 28s  c Y PSUV<2v2 P8 )$ [ <hք[. t>O) ;^]hnt2 c?ÿsг tiu%?thu@<詌r7,; t
wq-3`_@us`?
 
R@q- aaq[@`j! jMS.S r.=. u脈r`.t ir9 u
_phο0svr@OhR42f.fÙf.q Yhż?d ȠwrѤ. b ;  oh?Ưu@ @@h/./
03!4+t
3NO+t3GNOUN///&N/תP aT/SR/-``1 $fӃ*`[QXf@fXܞfX*fX>ah56h=p;W 'Q W 耻c (uuu&gq S p  Ys][hk_e$PX! h<(h(:qYpY	YdaoVzp[V͆ڿ#|vP1F X PS2&1&1&1[XPS
111O9H587a2[&a2a2\YZ:~Z-'0^@0 xPa tU xXW8{S8rdd8rS<dr
d2@ڡt r-	St؟誮蹰ɸpj3j1۰Ðl & ߃|Xϊ&裆q8t t+                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    K !$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( /(     W    ς  g `g  h }X  k  ;p    / :hZ 
;! 
mބ<# :S         ?  P          %X%H_&                                                                                   ϯ* `*} `ª PzRQ@   U @U 	@
U 
@UP X@YhUi j@klUm n@oV { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`hfPu	fX@  h  fUf&paf&>` 6ma  !X[ &SoP`\@ /'a&&@r
f3f僰gf }f3f{h @@p h &yïf`f1fff_ef  ս % ŀ-ff0M00!0)ffXf9ffaf 
  Wfi@] 0 m q  ,f5q f{~PeP ՁQ   ͡Ap  A` e_faa  !6>eуp Ń wPك"` peɃ T	
e} fe&` b "jeffefAffgd:ugdfepf3 gC)T "8fF3ۊde3 
td	  >p) @ 
peuxu._RTC u:/
'
%&bfgfd.S` [WP9A`XP&EX% &߈E_YǓ oooooc׎dΐXf`ffP fSIMWuUfg0f[ Qbr6ώfc;ڟw(h,UfK;fap p`p f&?SECUtC)fuffQpR Phk\g&XfGذV S 
u'@f%6X!u(xg&_-$8IaztKt#ɃGt<SZ
 kTIzTV8&VYtwV*tT
ShXO RL@p=p8%= 	 =
=ufH/FFF@ kYt3!ffw	!z"n& t
fWf>f_r2&% m$g&P fg&	}r SfQfR` ނ !fGtt2t~tyf    2 fAf,P tfr@ Q^ûu 3f rFf;r>1-: t, f ur%ArQYQ	 f_fZfYf[  ߀ t% 
't`A5
A!:0.2 r&7"

rlr9SV9rP#j   t
ff;t;0
 + t DU@@D*?^fZY@ Kh^1$hr; 'Q W rwp		]K u ff!` B
fffLp 


ghshNR0S
`fwPhumfX
%3H# 
t3 v0)Q%pMh\\Gg!V< t6<t1}3:u"FWij*:+0;) .fY (7@ wY.	A_S 
fUfp>t	--


f+ f<
$f]^$*x### -gpXvPK? Cn@u%fs  '  
sPj $$$$$YcXW|@Uqr1st:'sf0Xt&{X5A5:
x




FzcVhhPh^fRg&hnr>88\s2_g&	t fZfVfRQP 0yffPpaff!>  _3ҹ?A؝FffZ f 
Ƅ
}@],hY`i^RfVQS>f"1? O9Bt#h_Q  ? 7___[Yfi`V|/#	
UR 0BШ  RQ2Tr+XWO 
 ` 
j gm0_WVSQ  2ۊbF(+ؾ8u `&
dY[^_fPWQtPpX"0sY_fXP}ǜ֜TY*`ʡf`f&`1a&r&6&P&E` X ^+
v
`.f&r&&faõr!Br !PX
   PfΐhE(TDǰ X810u쨀t݁	<u 1<u õr$Rr Cx&@&32!rr]rN a`z7da(SvxБQ`"" QYaVP `&` Ob U
y[' P"S""F"&&	a bR ~ ZQRr3'H2't2״`{`2(t"5tDTZYa~Wr#S-ER-7Y03?Ёٸ q4 L f & &ƷEZP &r豂r8t32```.&EO h?,w.tGS؀1?u|[&M.	2tð$D 	#h 15 >1WM 04gfRgw2ɟ_}ZfZrǿ pvw@5 &E
}, #!	A	2ahk
t%00`P 0,9S%0xA  Da`6(    ` aV魆ī^`W  3 _r- }+˸ fD}@ED;Հ wB@<B O B<`<2rruO0W2&*G_	 7&*,u&}Zu&wE0_[DAP`QkFگ>0 0t<OtY	B<{tmH7ۄ77_rPBBLѯ: r1 r,q h/d!SQk
peat)u$<Pt+fWKuҴhqiB`UZqQrj @qj"~yjuBanYoof	V] o^W m h?TtD=/ί==rN|UtGV Pk4^t1Vh_5f^D  D" ; Z x     _0Nm =$
Pdu	q 42˿PXҏÿ	 i H{ȃIiJb2ȉ{3' SQRfRBP' .Z7a  7a$t2+``B *0h華h Ed/#/(*f(fYpRiOl`Sf>QP?H_u(DЇ/&fP  n[~-r(UqQP-roSf|P>Wp(>f֑1t  tf40Z@p f  fffq2g&g
`fKfRg` gr=e hջr s1|VhݟZ,
-f_fYf[pA r  sRfbXPSfRj07W6uLt;wEf6fQHf8 r/fpbBfg&rf`b0  Z[XfWKu
 f   >_ Àff` ? t]ǀ t
t@  f?
 : ) @(d! _ 0f` ; 6frv`gGwf3ې fPfcfPr:p> ff0;w!fVg&f^ufFtsf!Q. $pf_t Qg&$9<&m=f=ATADtlf q:&Ǉ  p s  S3a b u1  0ņ3ɻȰ	j qˆUFWP3J XU .>9   ub >u `	`	߅ۡ"p$l0,	$C_ARu2 + #g&J hpOC4g0ATPfR`dfXYX8U ø8	ZB. [؀0B 	   S@  Cp8 r zPJ	jB
 C HكIڄ#Ѱ
NPHffff+fMhs?af-Ef&ffq: 22sPAMSuff>r^n`t
wS0@APX>¬ fڭ|	! "f#탑fPWVf orY 25E6`xP < u} r_r2ff fψ^ZYm
._6BE<u@
PBbP
`RdfwH(f"`*j uL$<tD"ЎQer&=t tV" &GF^YՃ"Wʴs\@˭Ac߾ 	Py<
!
"



Z@P l
	Plh@ > @g"YP~̀R ĺZ"RRغ0 t@ѥk.0S+r[ 0৐PQ> c r\do`PSCtC>r-t`w0:0 r uҊ1 r
-`u`dPqQ rdItf s`v 3cSRNr&r!ww3҆r r	 ЪfPRc!0ԋrp؍ćQPQmss
d Sr	r!V>xRp d?gfZxuwRQ R  g}h̓kOiC Z5. ϰ蟽 Pp Y0 ~`2耠 p",u PQP hE\+R**Z@uhSذ* o rQ(`( @PS  I 0SQ ڿR(0R1 1Ǫ22&3DC	 4P>tFb8S t3306J*bR{
t#4 c ttaÈoxQ+3QBa^_T!#PDG<u@EV 4^W =_ "  !(<t* /	
%R
q0J
g&/ܱ1q;-r  r;s;dR(XӕJ2u RVа$rN ;rCr<,	r32`trr;w tsڋ^ZW
   е0u
˾   
u N f! [uf _2 J33o22t @ 0 	rn
$	"
uƋ߱d;sRZ3QFqF2t
2t	u˸
S_ø
_.0...Ԡ   r.Y.2YDذVPCߊ7% 0	
	
QWfV3 PK]t-s۾[]g&f[  cf^_YA.[fUf.6cf]#f]** End SetActiveDisplays: \ PwR$_nt5 Q)kd_~@-;t  _um DZvBӸg $tupZQ2tN
͋كY  fv@t[dP<7 t ~O
 \p
R 1p93t0	p $ D 3ppbbwUg
10  PM0NtPR	gN9o*kPP;<kP$0 ;k,kċ +kX#kX	kjj~jXjfЙ`jaPtQjP ÀoPjQRPSa[X3`G{a B"c
rQ j dK f`~rKOu$%lr
u.2*q	,rp$p&` E&]W@ _ffa.A4t
10rp???qSQ/"SPfWU]faW_Pzð Qc !  rH rwtp	fSfQWB+Yftu XAC_fYfq@f`f>fǷ ;0Щfo RFfa2k_<_Pfgf2glutQ SP܀Q$~X	fAWp W6XWqHȎt/O  3  v ؍`6$at`ZON@a<@C OO_ B  iiu$$t$
!$$qh1|Oŭs`9tw4>0t,@Hz uXza    Pj `   Vs D ` d h         ?   aw @  Ub  `u HX \  HT3L4 50@

@
/;                   a         14    4XYhijklmno 	
}
 p                  K ,89:4NNOP OfhX#lW  1RR #gf&f{ߐ fp?)Tf0@g&OZ	(#pvA r㲓SfsfRVW f Q  !Q  A!!ȑf%ÿf3f3f.2fffu_^fZvf"Q ء f|' Ŀ×
f0ǐ˚P3XPSVWfQs: ؾN Ru ufufpv @uf  fY_^[XQfǺff}
ffD fppf  	&D4q'f_Y"OB 3%%bR5   6 < h }< 2<
  c                                                                UPRPRVFZX0RR{30ZO                              u߸ Ѝˋh3 {3/ {3Ц!Mռ'@ 742޿2
e{3פ{3Ӕ"c5%5;,вKzѩ`{3{3){3Y{38{3k35"k3GG
x({3h{	Vqa<
sϋϢbf.ruN!u<u<|w2.0df&@#< t
 u
ff
ugf 7
SذsZarSa[pfq;xV4kt? u_[fωR_K_`0P #{t tu6,`@" 菟a"ffhr;W 'Q W s	7>.hdr0fA@fP 6fAYqs}wdr
a$ChuzPszGOuhfPuRP XZIPr@"K	@ h~0#! " t;*t1OfYPR<(g|Zqf^SQR<w_s&ZY[!q.;5
w% [b<=à0AP1ABSOLOUTEPPPEg& tff_g&tAX_f^  f`ϫ4t$4p$Ū4r .<t
../ NA NfaSRVݾGfprְ$@tU./tSA
 NUNh_T^Z谄ߨ4?h_À> ts%Jf
sM{PpWY'pPS`?0PRBZӿB3 $ `%>&%	 
  3  t!  { ! @f@u#2h2b>t0RW0_r pǻP"R8/fZR0fP&T ffXy@0 !+q+
  fh` B B B!B0B1B2B B BaP辽fWr!J  g&?t"g&Gbg&Gbu @ uf   wκ( 
uf_#` ¿[!,Z ,7j * :~ , 22RQ]Q]Z]X,a%*A Ë34 CZ g& DA4 Fd+
 <
`/1#;`1h:e:f`1} f2f3f% pQ
 0p!P!q  f
 `0XX! Kf`!ffgff%P@@@ gffP +
 `C  fA"aCu<w*$<w	+ Ef{46W> tU'uR uI )lB<t>t9u2kYr-Xr!\y |Jtg&G!P _  '<yZJtZgFtKYr36Ȼ s0 /G <u$
@/OP 2.CPIG"er0HItt躌52 `	
   SQVȾ{@ 8t"8tr3^ҀOA:t,&
u$ࢳ>ut
$sEpt> u.~M"t$	&
Ys@ ÀY
t^<ph	>!]
hlWtp0]ZQ KBouC1ntCƠ ƐP  M*p$  
u{a>@Я`
	 >t Lt_0pPpU'uUg **r$- t> uBu
 |i`] (r"1t H[JbSQPX[tV
"r0."VGoLGtB02D0.r//6Ft_6tP rBT36sRu%
 "iE;6 jU56cC$|tzu Sطc`ݨtbR;sW;sQaSu	Ju"
ouPFޑ"
23S/ ( à/t ݀uہ* /)P5t=XSfW@0`
Eth_8؊f_[6ڦk3fRsg]Pxr
Go3# ЊPS|hf1 f rmf# uOf3\f   tQ}t0z#%9tf!!@it1f wf00jf.fEf0ٰ f[fYA! ao@!jCfW z~ u8 U *t  t	2fp f;_À 
u ø  <Zu?aDrqD /<oCp@ h?jf`y`!pz+ 5fpaL$
	`cktf@
@pW%eƇTqґ  ; @ "`_úd7 u"voJ  ~3  t 	Qf@ @1 #9 ЮޙÅy]` %p &
!#5ȂaqA~!-f# %q48$VB'Q f 30Q'
f?~S	b s'g'p
f1f s!=qf\Yfĳ & SSo؁؅fVPp#t6Ԭ %f&ȿ ffTt33u^fpqSR3һX3t@s7rS؁`  h1 o
 * E4A aBT0	1`jkȂ&$RD
 AP1T؃2沱1ܐB0RfZ,.028  l+,h/7.9[_օ*v_5~jǡ/yI7
#'USטfu`QEPt  _&0Ru hx @
sP| mQm Y?t%_ P9ffXP:f cf l`P6`a   ` 
aa|!t# 33j#tٝB@S3g!g-ff<f
 
# f RVR%\hT0 gnP'*0y@k  ek  Bk@2˱Xsf28f- Jt9hV)cBJ^UQC = u5
0= i= ހ,Q7` H7!CV8[䠆  9t 3jaAq&`\) `R]"P Q   ,A0>48 N;<p\#qW`5 A AF@ch_!p{3 POf4qw~JY 1I[VfM@2 QL7t2 t,NKfP _$P!P$c4Rc'SS2'1'U+ gZtg=a&'p`,6[   2kiA~` غ   nBnnntnJFn aS À 3ێ7!C &?!Cu3ۏR .Zðohʐ_:ðP9{9XY]Dp &99;>&.pu	 `uQyӿ	
 ^pkt	Կs'+t8QWP3 PhX@.X=X@uX_EYP!q߰up$ q!Pa.$> u
PTE@Xuð6_C @B T wA3gfpg tHu.g :f g&ffS}| ffߋgf?ff6.<(.&gfBfsDP
hh!t@
xWBDBfR`6c6U z u

(@kuXO0f?qPRJf  o!ڃ tѾ`Np Mp pjXh	q\ARÃ@t%tgP&g!ggf`ҜRft9tg>E @ t9gW5CggfRVf),g>E %/g> !P(^d`g
ز
*.  ofRA"Q2` t1YPQ z׀tu
QPYXP k/` ؠu 
X``:؎PRf쨀u Zlfa nM @(00	j}Ef p! D  &Et"D  $D( sn``ف&tP΀O 4>2@"Q
g&t
~ 0HL &}u?p ?u8&= r1	&
I_$B}r P
` ¿肐 m  m wQam p's 0P] ar * $OQa	 & aO# $$<@t"hXRĔKucKK|ުKuף`.>	$st&3r	&*r
A,Baô`prr X ? trC0}q;w1#!8Q909$a0){fRQSz[YfZt'0 [ t x
| pGjar`P
RADȁmG> fH  h4ruf>踴rfy̸ ྰfRذXr<fffHff#f+ִ f;wf3`Sлc
uff+f뺀
   Q   &QQ
l>À> t(o 
8s tQt`-PQV$<
v
ط  wp= tǀ>IP_ [=$
ؐ o=h4Ċ$ u
d tP{ =X(  o@4^xn޴t

wd`
<@

#
 <Àyu I&J IJ< t>J u
8wàg`-f/9˵  hp	! M (@	9 `jW<u
乿y { I_ j+z =|'"~V ;.ht}R~ɝSj                                                               o3OT)rgBdpC           չ  p                                                                     EG  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  O0P       VBT             $VBT ALVISO         d 0 
" 0                   BIOS_DATA_BLOCK x  
  d3412Intel(r)Alviso PCI Accelerated SVGA BIOS 
Contact joe.david@hp.com
Build Number: 3412 PC Dev    06/01/2005                                               Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ 9                 (  8  [0    ( e `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                     @   H `   H                                           =                       $    (     
 
                                                                                                                                                                   !  R`SI-1362-A   p                                                                                                                                                                               I   <      
 2	 Z (-  	
                                                                                          	                                                                                                                                                         
                                     <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                            (  s ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a N  XN  XJUXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                                   :ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               68DTH   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 艉s f    Q7sY 戰f
!  ff !  f   tf ff
#  rfBYf戰YgC!!f3f   戰 fHr4f f戰䈰f戰 rfFf    戰戰3ދf  f   f戰fS?f[f   f   3f   f  戰g&fFfCg戰닰 撰fPfSfQf   fQf3یff
!  (fYsfYf[fXSgu
5  ;u[fPfSfQfRfWf   f3یff
#  	 ߇fBf   !f3g}
5    fg
#  r%fG;wg}
5  f_fZfYf[fX          fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   Ifsf ff   fT   Ifsf wfD   f @Ifsf [Ifsf 5Jfsf Jfsf c1Jfsf MGJfsf 7]Jfsf !sJfsf Jfsf 7Jfsf Jfsf 3	Jfsf 	Jfsf 
Jfsf F
f   tKfsf c
n&Kfsf xX<Kfsf 
BnnfLg&nffOg&fffsf fsf f   f   Kfsf f~fsKfsf ef   Kfsf F<|Kfsf  6Kfsf j
Lfsf Lfsf -Lfsf x=Lfsf =f   tVLfsf fLfsf of   tLfsf hLfsf Lfsf SLfsf Lfsf &f   uLfsf "Lfsf Lfsf Y&Mfsf Mfsf )'(Mfsf L'8Mfsf 'f   NMfsf <wbMfsf 4 f%"f   t
fawf  Mfsf {ta$f  Mfsf ;ff  Mfsf Df  Mfsf    Iuf  Nfsf f fsff   f   f   PNfsf tff Ag&ufNfsf &r8u:Nfsf &u$f3f   u
ffuf   tf fsf   Nfsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  tOfsf $f  Ofsf idf  Ofsf rf  Ofsf 6   Iu f fsf   ffuf
Pfsf %tf   ),Pfsf $8uf   uffuf fsff   ftLtPfsf $f   t$<t)<t/Pfsf $ufffff   uf fsff   ft(
Pfsf 8$<t<tfffff   uf fsf   t8f   ftFQfsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tuu0f   Rfsf $t<tff @   f 5Rfsf "2  +OS._Rfsf "<  ff   f.:w .DRfsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2uff   f
.f   2f   f   ft/Sfsf !< t8stff   uffff fs2uff   f
.f   2f   ft(%Tfsf  < t8stff   uff ff fs2uff   f
.f   2f   ft(Tfsf  < t8stff   uffff fsf   f    ft'Tfsf $ $t<s
f   <tff   ufff fsf   ftTUfsf uff   uf fs2uff   f
.f   2f   ft($Ufsf m< t8stff   uf?fff fsfffsf fsf 2uff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%f   t.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfu2.<u f   t2kf   uff   uWfsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   3Xfsf <|f`Agf&   f    f    f   rXfsf f    f    3f   ftXfsf UfftXfsf ;fftXfsf !fftXfsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   Yfsf <|g&f~fsf fsfLf   f3f3ftr2f   tYfsf Qtf˰Yfsf 5<	rIаZfsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8  f Lgf&fftf  f~fsffHfuff Lgf&f   ftf@l]fsf f Lgf&fftf  f   tf  f  f   tf  f Lgf&fpffHf   tfHf~fs]fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	^fsf fBgf&^fsf  ^fsf  uff%   f
fHf   t
.f@Cg&uff%   f
fHf   t
.fCg&fKgf&I_fsf Ff fs侳uff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsuff%   f
fHf   t vfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}.fDg&(σ.fDg&.DfDg&f3vf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`|f~fsfffsf fsf f Ef   .@ fffsf fsf yfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_cfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
fHf   tfHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	f   tf~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H׀f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fi  ifffsf fsf f x.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xifsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfu  f Lgf&f   tfu  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1sf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   sfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  tfsf ,$f  ufsf f fs<f fsfffsf fsf  fӇ.ufH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  fsf Ű < urf   6fsf $<  <t<t
<t xfNgf&f   uf   fsf $p2<uB >tHH3f  fsf fƳ 
f  ͂fsf *Ż  f  fsf Ű < uHf   fsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ufsf ų
f  ofsf Ļ  f  fsf $
f  fsf Rf  fsf ^$w<u|f   ׃fsf B<|2f  fsf (f  fsf 0f  #fsf $f  =fsf f  Sfsf ĳ

f  mfsf Àf  fsf qÀf  fsf Xf~fsf fs            f   ff   2fff   ff3N.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2XXXX          "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         [                           o~jGDkED͍#(:of`0]ٶUVo^#j	lfYF;EbRi; _ OA 9@fhP) ?ٱCbNv4gғjF^SzDM6c)@#$i`]).?mCmϰg;І\[A;n-]uM^h:9*!1F;ޑW誩O0~1_)W*yBd.vOr/ϴ
%>2=ׅYXtSc!TFm֦U`aMH1':
Z󑈷5Ԙ|ްao#1\nѓkݷOL|)<F+z  :~VU-PadX;*?.5Uc-oh@x/Rdlۑxf&\݁'KAqOrbUd	Csʩ^w<AO<q)+	dCfu%_,[S\
[+f(=]FlJ߼qS:<xM+ٟ;ݞ^^פIQ>wm|
{OYS^9E@3OZ@_БHg(R	"t3٨_1UW!ߣGhϿl4d	}N*w|<gFz+Bs.4<0
2yUsiɕchLEH2$ql[_B,>)c-6+AjS;MF,kOHUAimX?}DS}[!AnjZfe\Ҥn(.VV"O3%;H׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        D   @    L       @       H         `      T    G|   @ Ď    Ď    	 T    G                   0        	    	 		 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D    X      P    `                O    O    
Ol 

Ol 
Ol 	O A    A    
@          
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 	 x   @
1 1  @  @
	 	P 	P0	 	0	T
	t         @  4     	4,  <8	    , <8	     <8	    <8	    ,<8	    ,<8	    ,<8	    	,<8	    	 T <8	    , <8	    ,0<8	    ,<8	    ,<8	    	 _. U . " /  . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /  . a /   . p /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         =                    	4 @     T                      d  ` h  $X  '     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<8	     #<8	    P0#<8	    @#<8	    PP#<8	    	 #       8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O  N            0              < fmf%f  $f$
tWppqtHffupppppqήfڮfupppppqf f  gffLggf^gfnf    f
   "4f4Ufupppppqg- f],ffmff  @$f@$
= u$<T)fff  @$f@$
и f  D$fD$
аff% = ufyf f%df %  fAHfU../0./.	/`./a. /0./. B쨀u?ff d< uffd< t<t
u掰fذf䎊ffff掺<uf if*  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  $f$
иf  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   f`fn  (fz  對 f    < tg                                	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ft vugf&>tgf&6f٢ &fU ~f^Y[fXPSRfVӃ tAӰ Ӄ% g&ƅ    f  \g&  	uf^Z[XPSRfVӃ tAӰ Ӄ% g&ƅ    f  g&  	uf^Z[XPSR     Z[XSR  C vZ[PSRRZZ[XÃ<t  I  .  8PRt)t<ZXfPfSQfRV%2  f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $fKfS f	SfWfff]X t fffS f	SfWf  ffKf_f^fZY[fXRfŋӃf3ӃZfPSQ  fӋA vY[fXf` f;.t
f.   $C vf3 
 f    fgf&E   > uF f  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   < ϴ f;  ɴg&"  @v@ g&  s ϴf;  ɴ> u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         戰䈽j戰䈽'f3Vf=밳fI@fS찴f_*fiWfuf f%"ff齧sffHff ff5ff f
   `"	f   f3f30f  0f+^fUf   f f    0f  f f   0	 f%"ftff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f.`f  
f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pft   @ Uus } M
  >}rfg  ׁ ( r  .i|V>Mfft<>3ffxfxrrfxftf>t wft   >ffx%fxנ3fxftf>t trf>t wft   >/>m>dff   fF>=נ,>#ס>	ff | > ffx'fxנr$fxftf>t trf>t wѰ|ft    } >urd>u]R%	 D>u=ע~/>u(fװ >|t  ׃>	r  Kl	s 撰 XBȔȮ(DUɮɻ'fSgf[gfPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRfp@
 > u> 5xzytsfZf[fXúz.yusfZf[fXPR tĺZXfSfRfp@
 > uB ;yM@t=s(xغz,y0@u sz.fZf[Ru	sZ       p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  v  f  ٴG 
f  ѴwfaPSQVP̋L	;t	 ` ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6鴻js>t fafWf   g&D= g&D= f_`r r8 a`fP  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`fδf   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f>ι gf&D5 gf&fff>fXYsufa`f`  & gF
$
gF
f`  sF>tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva "  f
   `"	f3f3f   0fffP  0 f%"	= t*PR ZXtu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          TfJ  ?   f^  +   fr     f  J  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_Zq`qjqnqfPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP(R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                0 ] IPS㋇ӣӋӣ[XPSQRW0  3  3  3_ZY[XPSȎػ       !    A   f   $       [XR # 1 ZSQW   L_Y[SQW   7_Y[SQW   "_Y[   q f  f  fPQgf0& YfXf    gf~gfNgfVgfßջfPfSfQfW<w f._
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX            <t ø fSQ >~tf r	f  r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0fpp   rg<uf   ⃸   Yf[fS>~tf r	f  r>PfSfUUgf*gUfUUgf[Xgfp   Y r
g8u   f[                                     Q  YPSR+;wZ[Xf>p tfptf`f  f3f3f3f  gfffCgftftfafp   fpuQYfVfSfQf
!  f   fx7rfxfYf[f^fQfWfVf @  f   f  gff^f_fY               fPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfXfff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{ffkffd    2ø     B @ }?H
09/15/05DHT