#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTU)  - Linux-Based"
BIOS_VERSION="F.0D"
FILENAME="sp31374.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  G<3<3  G<3 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  G<3=3  2   8YVU   BIN  aG<3<3   03    8DTA   BIN  WwP<3<3  Zx/3    8DTU   BIN  S<3<3  *r/3    8DTD   BIN  *tV<3<3  N/3    8DTH   BIN  MX<3<3  M/3    8DTV   BIN  &Z<3<3  k.3    8DTD   BIN  "L=3=3  N/3    8DTA   BIN  Q=3=3  Zx/3    68DTU   BIN  IR=3=3  *r/3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZ[  `     8a             
(      C   
    \       j        m    i
      ^  8    t    	                       q    
        l  [  S  1    s"  M"  8"  !  !  !  !  ]   W   #  #   O
 O
 O
B(  )(  	(  '  '  '  '  
 
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
O
O
 O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
C  C  yC  kA  ZA  )A  #A  @  MF  GF  +F  D  D  TO
$O
O
O
O
O
O
vO
LO
.O
O
O
O
O
O
O
nO
PO
2O
 
#Q  P  P  P  P   
^  X^  G^  ?^  -^  Fa  b  :b    c	O
0O
*O
O
  .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        3ÐjDː
  F  F~ F F^z9 uvfvo'}fvfv]'~hd	h jMRPWVtj
fvvPt
hd	h jN`RP*Vtj
fvvPG
 Ð3f>^  tf6^ ؉f>  tf6 ŉj _;  Vh j7h j,h j!h  h Ïjv_h ҍ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hn F^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPhjbRPBjRRP2jBRP"j2RPj"RPj	RPj
RP⅃jRP҅jRPj
RP貅j_NFF9F}-^v&&?-t^F&&?/uF "[z=sjxtRPTjK_ZtjyURP5j,_>V   hd	h hn Pdfhfuj fh  ! hK
h>if6ffh   hK
h>,d| f6fcfF    .^
~ ^&0>^&>F~	vF  F| 9F|F= t= ujRPhj_^ZbZfh  j $^ ` ^ ujzMRP-j$^+
>R  tD  Zt( !  9  =  A  E  I jJj1fj誅   ujzRP賃j]t(b       ؎f&fjxRPij`]>P  t>R  t\  Z  L  >\ t>\ u& & & >\ u-F>T  u	>L   >L   >\ u3T Ht	HtHt8j euwjJulj?jI.>\ u?T Ht
HtHtHtIjj WȐju+jRP胂jT HHtH
Y>T  t7>N  t0flA  hlhlj~
>x tjJRP*>J  tXj \Ud  F >d >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uD:&~ tfj fj M.F  =HtkI-
 -!- - - 
tFfUw>  ~  H   6 H; ~    ߃> ~  H6 Ĵ &@u  H;~  6 Ĵ &@u   FV^& &G|&Wpfj 8Ad    F >J  t=Kd B= M- K- '-M- 0- )fjG>J  t2
j Y^ÐU
^&J&LÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ðl"n
 hhlhljmX >x2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFfFf-   f;FvfvUFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRP`UFᐃ~ b  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP蟂
	3ÐSfv
 ÐT  Vfh  P FP͂flK  Fthhlhlj>x t3^ÐFPLyBFVhd	h FP8RPhxhd	h fvRPhd xfvhd @x ^Ð  F>FK
l"nFtFhhlhlj(m*ÐU~uhd	h  Ð~ fh` j hd	h hd x[fhfu3Ðf`    
f`   ff9`sVfh   f6`fh  `f6^ u*u%f6ffh  f6^ \= uf&G
 tf6fY놐f6fY?~ uhd	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP
afh   vfh`  j f6^ $@v  WVd	~" f~ thd	h FPHv~ FPu3^_hd	h hd Yfhftj ff-   fPf6fx
f6fjFPw
f6fz~ uF.~uF6f 8Fug 8Fuh 8Ftf6fXkFPhf6fW ^_Ð~ fh  C.hd	h hd Xfhf
f`    	`bff9`sTf6ffh  f6^ X= Xf&G
 Kfh   f6`fh  `f6^ u
)t!f6f4Wfh  `^_Ðfh   vfh`  j f6^ \U     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP}
F> tjJj1j f6 P}jhd	h(      RP|
6 hK
h>     RP|
     ء` +^  &&W    f&        ؎f&       ؎&  &  FF܌VF Z   R   \   fl
S hlhljTs
>x u_>o@Z RflN  fp    FޣFܣvhhlhljy>x t>muR   hLNu~ t\   Ft
F$p*\ Ð&  VFF܌VflD vQCthhlhljx>x t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	l&lZhhlhljCx>x tjkRPu  fh  ! hK
h>zj{RPWF  @ +FHuF F^
&>TxP&*PhPj*cXF 9F}j |Ĉf<t<uhd	h2 GWÐ  += t= u%F  F~}
Fu~|3Ð Ð>Z  u#jIRPtjJRPt3ø TxP&PhPjWhtuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPJFVfFf  fPJ;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP2~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRP0Jې~  fF    fFffFȸd	~4 fffFfFfFfFf-   f;FvfvqIFVِf~qhXku2f+fFfFf~svBPƋVFVRPRIِ^_   jF "hPj
3UjRP3TFF*;s6PjRPTF*P2uTxP&
P뫐TxP&
PhPj
Tj|RPaqju,jCeRPEqjDURP5q>J  thhd j1RPmSÐ  [fh  Ohht"jMRPpjNRPpj{RPpfh  ujEF  jRPhd	hH RF~uv FF*;sPjlRPRj F*Puπ>X XujKCRPhd	h> yRjL-RPhd	hD cR>J  zt~ hd	h2 :RF 8TxP&
PhPj
SF~sF F ;FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&fRPQj F*PujDRPhd	hH hhd j)RPeQj[RPjZRPhd	hN EQÐ  3fh 'hht"jMRPnjNRPnj{RPnfh  ujEF  jwRPhd	hH PF~uv FF*;sPjDRPPjF*Pvuπ>X XujKRPhd	h> QPjLRPhd	hD ;P>J  Rt~ F 8TxP&
PhPj
PF~sF F GFF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&JRPOjF*P|uj(RPhd	hH  hhd j 
RPIOj[RPjZRPhd	hN )OÐ  F >\ ut~ thd	hV hd	hb FPrhhd	h FPKFVu3vPfh  f6^ K= s^&G
 tF  fvJO>\ u~ t	hd	hn hd	hz FPghd	h FPMKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPxB  F J.u35tF f6^ FP0F~rhd	h hd	hV *JFVtvPfh  f6^ K= s^&G
 tF  fvH~ ujRPLhd	hV j!RPLF*  F u3-txt~ thd	hV FPfj"hd	hb FPfj#BRPFPehd	h FPHIFVtvPfh  f6^ CI= s^&G
 tF  fvH~ tj$RPL90F~  F ohPj
LF  hPj LFj$;F~TxP& P܊F*PjkRPKf6^ FP0FF~s#~ t~ uTwP&
PtFPFPj%RPOK~ u~ tjjRP/KF  F f6^ FPm.~uPhd	h hd	hV GFVu3vPfh  f6^ DI= s^&G
 tF  fvFFÐUf6^ FP/Ð  F Tu3F F~s7F*Pj2RPnJf6^ FP<uhd	h2 OJhd	h hd	hn GFVtvPfh   f6^ H= s^&G
 tF  fvETxP&
P
hPj
JF hPj JFj N*;~TxP& PՐTxP&
PhPj
oJ~ uj-RPiIhd	hn j!RPQIF*  F 8u3t~ thd	hn FPbj"hd	hz FPbj#RPFPkbhd	h FPEFVtvPfh   f6^ E= s^&G
 tF  fvD~  j$QRPH:EF phPj
aIF  hPj MIFj$R;F~TxP& P܊F*PjRP#Hf6^ FPR:FF~s#~ t~ uTwP&
Pt~ tFPFPj%RPG~ u~ tjjiRPGF  F f6^ FP9u3À~uLhd	h hd	hn KDFVtvPfh   f6^ E= s^&G
 tF  fvCFÐUf6^ FPW9ÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ *;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2H>H 	H  iÐHi  ~ t	h)8FNuÐ  FjfvFP]
F FPNQVRhd	h ^Sb~uvvhd	h fv#bÃ~P|FlFFPvvhd	h fvaÐ  FPNQVRhd	h fv6bvvvhd	h FPaFPNQVRhd	h fvavvvhd	h FP}aFPFP\ÐUvRP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fvh\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j߃RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
 & FF  @
 &ğ &0߃FVRP3[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6 &Ĵ &@t2j>vjqj+jFvv^
6 &Ĵ &@ F  F j9Fu
F F  ^
6 &Ĵ &@tF vv}
 &ğ v&0݃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l
^& ܃RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjۃFVRP
X *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7ڃRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wكRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0փRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0ӃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
'
6 &Ĵ &p
ӃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0ЃRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;F}FF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FFPv~ 7
FFF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP!ÐFP>\ ut ÐU>\ uFP+ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh>FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh>vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh,?htth,?hِ }= t= ut '҃>Z  t fj h2N3  FJ1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 JSh@hP*F*P˃uFJ| j h@hP j˃]FUtKj˃hK
hd j hhlfj hG=th@hPEtÐhK
hhK
h~&Ð&ÐU~ u hK
hjhHhK
hjh7F  F~ ujFÐF Df>   F{ j h~Ahfh  ̃uF  FuF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh~Ah`j F*P̃u>X XnQfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ 2ڃfh   F*Pfh`  j f6^ uڃF*@N*1 j h~Ahj F*P5˃h~ Rfj hF: j fh  ʃhK
hd fh  ʃt"hK
hhK
h{t"fj hE
fj hl=uShPAht!h~Ahttfj hPU~ u hK
hjhhK
hjhF  F~ uj-FÐF Df>   F{ j h0DhBfh ɃuF  F+uF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh0DhjF*PRɃu>X Xnfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ ׃fh   F*Pfh`  j f6^ ׃F*@N*1 j h0DhjF*Pȃh~ Rfj hMF:  fh ?ȃhK
hd Mfh 'ȃt"hK
hhK
hɹt"gfj hE[fj hl=uhDht!h0Dht fj hÃ>J  tj htd d   1 ~ uj߃FÐF Dj <Ճud j hFh"RtF F~s3c F*1 j hFh"`FPHuFA j hFh"8he>\ utTOtM0tFj t:ohDhfj hl}=thFh"{tÐ  :1 ~ ujoރFÐF DF F~s-F*1 :j hGh@~FPFuF:A j hGh@Vh또>\ ut>Ut7j hh3fj h=thGh@tÐ  X1 ~ uj݃FÐjaӃuÐF DRd j hHh^qtF F~s3Rj F*1 Xj hHh^~FPfuFXA j hHh^Vhc>\ utTmtMNtFjt:hDhfj hl=thHh^tÐUfvhr  jF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NjOÐU*FPPKj*PKÐU*FPPKF*PjPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBjÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졞FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FP4tFPhK
hփ~ thd	h@hd	hLFP3hd	h FPUFVu3vPfh0  FPLfv4FPhK
h'ָ UՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  XhpՃh 
ufh  h j
u  7fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  Hhԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
fӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAh
  fhx AF  F~
}YhxA$PhxAj2҃hxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPh ҃m$PÐUj
ыFPh fh  	jmjыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
4ыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h
΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  
& FP輴tFPhK
hɃ~ thd	hXhd	hdFP&hd	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhK
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..`f^gef[UfS..`f^gef[UfS..`f^gfeff[UPfS..`f^Fgef[XUPfS..`f^Fgef[XUfPfS..`f^fFgfef[fX                           UfPS^tf3ff`  f.`.` "  u  $" u [fX 0!<s3P˿K
6 + r ׁľsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666
P.:bظ cP.:bۚLg  y>	uXP	 PK
 5! %b!

)&6, 

3
sx

 
&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.!Q
u' `t ``z 

b >	u 


M 

S  tX
Pu~ uF  X
uFL!_^]Ë

 
 %!;s
OO
;sEtU P>" t" P]ø Y+r
;&rQ3 V3B 22Ut
 Pt ^Ï( <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &(U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV(
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v*טÊ  UWVFG
@tG
  D
u VށD8FVD*P{|]~ tZ>PNQ!FFV~\t@PFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPPFPvvPPFPPWF_]ÐU!
t]UVWvD
t^@uZuGD
D4u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
D43ۊ\uPuuGPt\ttu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށD4tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7BFȁD4؊FG
+EEEFEيF3EGǌ^_]ÐUVWv(Pt,\t	0tuVD4D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvD4t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vD4@t^*&GPy= ^]ÐUWV3F؋O
рuGuD4t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVD3~~ uD
tV@uF96$r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr:t)ǆr4FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.6yrJuwwwxtxxxxwJu<uxxrxJuxxtxxrRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] zzz {L{T{}{{UwVW3FFv&vF
t~ }F<, <Xw$ FF.dzV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVD+FF96$r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33BK
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96$s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁD4؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVPvv&PPFPPW Pvv;u)TxPP&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFVTFPv
vVpx& V3P,^_]ÐUVIFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3K
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	`t	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5!["#%!usʻ 
FV]U_ .8tK
I	]PPR.:b؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUK
ء
F
F]XSQRK
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ1$%!3]UWVRQSP.:bۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y&;s+3UVv&L^]UVWNwi	tHԔ6		VW_^s+_;uX6	&t	;ut^Ԕt
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]            K
              4.64  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   d	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) ZC  + , @  . / F  \ ] F a b G e f jH h i jI '  K
 `  K
  D10/17/2001  O                                                                           d	 d	 d	 d	 d	0d	pd	d	d	
d	Bd	td	d	d	,d	Jd	fd	d	d	d	d	$d	Fd	fd	vd	d	d	d	d	d	d	*d	>d	fd	d	d	d	d	d	d	d	d	d	&d	.d	Pd	fd	nd	d	d	d	d	d	d	d	d	d	d	d	d	,d	>d	Pd	dd	xd	d	d	d	d	d	d	<d	\d	d	d	d	d	 	d	Z	d		d		d		d		d		d		d	
d	"
d	B
d	V
d	j
d	z
d	
d	
d	
d	
d	
d	$d	d	:d	Vd	xd	&d	d	d	fd	d	d	2d	Pd	jd	d	d	d	d	d	d	$
d	R
d	~
d	
d	
d	
d	d	 d	0d	                                  E    F    B l `K
      C    D    B l ~K
      G    H    B l K
      K    L    B l K
      M    N    B l K
      Q    R l K
      P    O n K
      I    J    R l &K
      -     1    + o DK
      V     S n bK
      *    1    ( o zK
      T    U     W   
X   
S m K
      Z    [    Y l K
      0     1    . o K
      _    ^ m K
      c     1    a o K
      g     1    e o 4K
      j     1    h o RK
      q    r    s    t     u     p l pK
               c                           _C_FILE_INFO=                                                         K
               
	
\ \                                  YK
  YK
                                                                                                                                                                                                                                                                                                                                                                                                                                             (K
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          ccccccc               (((((                  H                                                                                                                                                                                              bbb                  kK
K
K
K
K
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                ABSOLUTEByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$P       VBT             $VBT ALVISO         d 0 
" 0                   BIOS_DATA_BLOCK x  
  d3412- Disabled Rotation
- Program Panel#15 to workaround 14.11 issue causes LCD dim down after S3
- Enable all resolution on non-DDC                         Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ 9                 (  8  [0    ( e `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                     @   H `   H                                           =                       $    (     
 
 ` X                                                                                                                                    !  R`SI-1362-A   p                                                                                                                                                                               I   <      
 2	 Z (-  	
                                                                                          	                                                                                                                                                          
                                     <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                            (  s ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a N  XN  XJXL  XJUXL  XL  XL  XL  XL  XL  XL  XL  XL  XJXL  X,                                   U)CompuTrace V80.817' \PCIR4      )                                 f`f   4 f&7&O& gff&F 8t@f3f@ fffB  F @  f@"ێÎfH"V ffaú 3f&=$PMMu3ع &Cuf&EÃsځ sUfQfNgfQj    fY] Ujfjfvj ,P X] O fÜf`_f,rBfh   RP2Qf'WQfu3hSh f6&Kfa      w OPO WWUPX!	l;WO &f`a UVW~
3vNWXZ_^]
 !d~#^"!B @WWVX''K
u".H?t2`1_r <ar<zw$ߓ&G+tM!OoF	f%}UoV%FUrsk	rHY1 _#+mfo>c3ɊF0r	wk
`xnW^`~f	E	p	G_w<Wf  79nGKvEA\Gunc^|mRs,eު+74YD07v5|"Fk- t^- tt
_^tuJ~tu>D9/u6]yUu,}7
W t}v3^_sE+}Ff;fOs)GC*#D'^4
Fm	[/Pj>3PtlXȷ;NFPr	+snV
D/Cvs)/sam
MEPW*
^3vNrM[a j$
F¶{t
j 5M4ON<H{k{V,u<=t MF u7-]
q#ÅۺP(t~vI<k
';Φ֧h0Dj3T#httF|#8S
P,
vShD&hm?+et!NAQǶhnni+r	 s)!Ͻ
J|8@oduI |F# JٚFu
\Dll
vlyT8vnFiDLGgtV;{hR"L2fRf9nKt8av$'WF	hD;߄P`EdPK?]lt\\s=Fh
{CMv?(|etsRPز'sJd!!jhxDh&PY+|:43tf6s&GO@`)Vjn8x,wtt[V
lj$8^8#A\mUdF^LKrCusuu]ᆗ'"umDVOf2Zqv;/ ۹th.Jyͤ"	lwM 
>_lκP+' i;iL':,;v5=`k1 +G
jPx :	4VI|x-aEuF+Fv*"E-$1[/@sPm|Cjd`A먉Dl}l'VL5QTY5:hh>JrkE,|le!#cEB&\Dr0۠,D$\ 1S\^F:cӄ`R6?5u89o$t<(d?puBc[X|. {k]+$΋	Aw84WB.YGRԊwno|:hAX:BV37xT!I]BtR0<	D(PP(&FMn+"iW	(-zk58V[aBf)eZPPϾk~	9	^XR0#8D>W_fEK8}Il
) ͖ w uh&j moF r}DWkkpض U[f%޲Tltv
o"d[B)H/RPSo$W%,1@][.	 Vu=Gvamk	\XUbLL-N]$gfñf!R
`	 \ݚD2.%ǳhM;-ȉNl48w@M3QNQV[[q9(v*krۙl7V{Nw7~*
9s7W1-TO;v)
P0g0H6['FB'O,*9X[O
o wqw 	6ڀ$+ak|(lվ+07G2$^ oΆP)
yl{ur8R7g)R`6ݓ;µ9_~FgF	f5pa.+
_uE$0ݶ(4
 5dUhڦ
$c\JeV@br%H
D"T"6R;"\BM,zIo%f blUuAW<D, v>oyrbX}C&lo6P%^GlLАf:р{L7H^29BS9PujJ^'ݷ e\كh
56䆩4@3k}f'
bdn5+~u&Ǯ
F*.qٱ(/|(v,lafl4]F
-snm9Wt\Z)#D٢ ml{BHn,H`}F^-EV9A
oEm	
@'E^^>+-VO @\y;V
BGG=2NzI'\:a+Mɦ\D?'f
^u_\t F)b`"9Gted7ORu<"GH#FD^ô9ǜfHm#{$7#H;f`NWY9(U*PMMu"`,.Հ$E(Jw W/~rEBJIxjZ[/7[	lG7pU$<u@(O@t.%?/	WFN;up	8n[AEFT۞Pط`:Ā
J^k(d7gM$&	(
" 7;fJƅ6/,nkJHpoq=`ogn\t?<R/;u/}.GV$'U@!ƾF+|~+= 4r3K'] e v&ouyw|, Jxpir{@KFeI@x3};u;VCX@ddfjt-'	CC+wtT
3śa]ht3+Kz H8$tkN;9tkND7EG7-~Y-\o=c0Ku:R8*tAtD<\ݮu/e,*$V t
.6-7L;Í8V -TVٖZZX%Xa&IwO2-S3vѺn9;0"HP
.0ܝ2#wR
L,POd$ly %^o.O,̐1_|RO\߱ -Z[9 cu"߮5U#VV!q>U
GXy,[!bHBW~eJuVBX!`3m~-:=Wt@qG0-DRIG!H;޵%*vu'e+]O@FGupԗ/Q|$)iҪ8
CK:QX7{,fbl&<j0ڢfn{#MfU<	]ܭveetV;
;jGr%V${ĔD,G$/
>}W	G@
Bٲpr,
* w&j Ht 74vk=
826DO\upDH	@N#
YҋoL,
gCD(諏+,HDphk-%#ΞJ- #bbT#:9j2VE=MWC|b$-B@q ]۞xئtOw"Nds Nxq5"U2wƾlKAUoDA= w(.bM6 03L<9 ܴ齝5ennN+@1]t<=|@	LB
;
uaV?8=C:76?+1+$|$S}γ6. d+
{;~fc.
j.ް2>KCvGR76U+zpc@5섨	 ]]m1dRb
Yt9S:g
ɾIKiG6g0
R5l
 5VKf!o~O#<o@fP%ep%?0Nn ŁgWl8#IjoWUON~k
*q(>~Ҷm	4?5wE'uQK@B囙b4<ܤF6P(9	VtIV%ƠjhCڝЦa#VƄJ|!Bթc~۹GFR?(* A9*F Z囋EPR
jZIzNl~CuF~BQ	ke]Խ }F 
V
=K%Э"dN!uNI?Ff
Q("`Q,1o{̓T>({BNVz/8%RV0FFG;wD9`HD/5].JpxG4;ueHLQp?(:W&];t K)o	}Zu|]"g| u&>FtW{ѫD _LuM&8S"+Ҕ0c4ԊXЖ틃`ffw1Mf9G8r,v7' ,hRZA:	Ձ¹-}f'O@B;!xc떼پ$NQ\|a該>fNEv3Fy'^8!źī`tDD>&OGN=Qw-z1K(6$XF<>j0!$)K Z:A>$bQ#)yW"w'
9Uu>s65 rwS2rr$vz!Tx86;pL)xtd+PbJVY*GVУc?LK/aA*l.	tT)1{L R@r@И ,Rj6`~D;4G3
X`sd
 μfp40cR
;
feI-?m܇3(4n@@ %.=P@4%niaPWh A 5ͶAL2tHo{ 継OP;f#ǳt -itζ),lXwF&5z;vvK!+UFa;WKn
mjԓ=Wb6]S5PFVuiI`&v!G2k&GuF	%ٶk/ڎMQf\
jι@|$_Tun/HHl}w6E{q<x
WO'VgXNkHm9w!<y;cuf.P(Gݩ2ȁ0ݲpT7jxශB;tj
s)^fQ.ll%(2%j0VV][8l2Ȉ
`oVW-p0ɵ81sZY&_tV|i2[
Z,)sZ|j :Z\Z
oR u2Vc)6Υ Zޠo 9RuHuC2QP/Ԯ=)bӹ{UV7N8;q('ҿ;vVNQV,J
)*L( af3-M1!W,IĐ}'u!xw6>WG;0W;	DHiY$T1V✁s@? t"mo=jDG+=
t
Ejht]S7DNPn (p/L+baAk!ưfO<9TV9sD#܋ڃýێ+¿mk Th<3<R"	.fR,i yqW208zͯ!x'8sW	Yz٫a1d#ma4 B1WvfP"F(t3l4;5;%uuV۝RR1-Ŋ|걱45|P0 \9"@ò$x^;bϢrD
kP	ԉW8^E(VzSL|ηew v^	w|o亅ÒDrM"CP4)bԻVj1)`fhZV?n-9dK}wrr@wk(5(,gmsy}XGC#:<iR4,Hs0&E-K*KXXYrIWVrê	>2=$j\܇DwDpZԆ=Cʧ}N&'0L$3]&NG?5qRZxޞ5	bAuS.+<`_^Yu-.P)Nj%p{8W[!?W@)^r
AQtu0D#]|7 ei__+;ʾr;r6X\qoBs6.#ԵVDIz
S*(6 CXl BWs(x RV"$!577pwz.Tss+;(FfG^w+ƶ%!zM؛_V#i T8дU#^%}'YjkV-dc7
^~fA5Z60בm"L5@ Xtk@7GJw;cG
RֶPLNH@.H[zLJjDDt:
FR@B[Ǳ
r+,L/x\w%4B&j nG${L?,ry޶Td W"2YV(yWDF?9ZHTJlo<>Z+D3EA/P=9kD6fgIͮl@4HFCFD&Rz&,v%V]Ci=NU٪)G6t18N
]6	:p$}9&:Z?M..ʍ9!<GtĂ^s[ȡSW0l(WRVv[%'t)zYAQVϙ=6 Np5[PL *
*թHE4ޖ:
&|hS2ۃ4 ǣxHztl	{,I@rf*^Ww0V+] &kl@и5P!yܠXu
 V`np`,S
1DV/q8"b&6thQf! %F$Vz&p,+V)&PWU$zGL%/2uvW #"AD#)h?$!oa!V;U"26l	
	/]!vLcDrր,'=ca6,0]hP5J@ٸ#b	%l
`px=3з5R[2wp$bD
}xIazDg]k&;Tp,$\&KDVc/8׈8`!\ ri&@b-N_ck4 sFJ dܬ
D/ùf;FD7`nmUOxUJ 18leT.R
xtRu`;EiP
>q{R~	N٧	k4oE(Dz4t
,AIVhOr[
r&wvrN H;+pTH@jY͉CaACC:z	"=t(4(<r>2p22I_`|GGx:9|%ff5+t+Wl!rRLCOwMcBczrܾDvwbF*DTfЊct{H+6/xFgd0H$|\
	a/{?,jco`
(P	9
0y6Vl@AupiC
^X-NTsнT@
'&0~8 ؓ3l!+	&lbmVl
UۍD)QxLdQwp)wȸҥ2f|<Q?,MvY_!XT,+v^,.:?:SNp_btNf[ug5P0',x_TZ*`6e	o>OT+NBF;s>}v;s,)N-fP4CVi:"[%,dOF{)&8thY%`W"f#&p@Xu<R)ǌS8C&
%
N"05pl-=Hdd.6?AUTOCHK.EXE )rdisk( partivon
 mul	\MSDOS.SYSSystem32 $I30WinBootDir}cBOW.INI}%tK Menu/rogramsYk{}BAK^8-ެrpcnetp.exeo&&ړ&MZcTmPK@1I(ǻOǶ$ǷǴ/RichSPEL wC/ s$`]  l'e&+dW(P  d<.tt_na#`.daKݰ
.cu(D0`'mtsR`'rel7oc'%MV";B  i(G
*i4DiRbli=Z

4_2Dt7	R \??\C:/8R#5	:\] %%l, o\Regi-ry\XMachi&-ur+ntC[{olSEUervices ?Local Obj+ectNhKImagePeh TypEGo`rF {G : 9]Iathl@ d7$lVo+SVfEeE9EEdÀެ,V]YO=P. N3V"jhn7V#kPhCyPǕu	@ma C{{|+E5ۜ940Q3ud,m@f#(ZŷRt/܋@-)e  MH{k{ ;{
k2MI-A3"H
A@ۭ8ۃ}
t'on!)͹8w?m]_^[:|N葶F8ػo> t*3pG4`P+L4aR@fJbAFE1#8w*H_K##@|(dWj8)N)af;Y-YC̒WWfWI}ɗ}}b囅[9=	
VVx=
t}SNQ	W	PSPpWvM)p@f86r,	9>u9~u[dM>LS <Pj2> (GnR	GlX4;!%Q&yTY2Ij)OYY,34-+[uj0(g
j.?;+K NWCZ0+L9}V#9ۊ	0VLd v>}Cs(}f3^d	
%0((8$S[o8UF}Wo?  ''=o	O첰$qMeLav4Ӟ(n86:vWP
QJ`u6);S̠% mMR׬W/1BB"*xX X .+<dQfljhoJ|Mn>6Mc[=֨LqYB>
^`Ë"7 ᵝ9|]4 9DH|o N
eFilrwcscatRtlQuyEn
nme{Viab(}_U c9ns4CDelelRRd
F69lKKey |archr nInitUcoden
\ng%ٓs[/P?TmkkaskW.rupy\WSmOw-d_tdll. 
j9z>9,b9~<9?9"#9#0s v 6
#$-PoX]wwFT>d~ p  8'HL\%56=3T:|S<`r<&Gp'H@Y@*HfiziКvA4.@VMj~44MeBi.FTf~iiĚiC4&2DMT`v44Me Di0<R`inzD]w46MEM&84JZE7):ssE -0oLXgagIi.0U\-Lgth: %d
%ss
xsvMoIcoftwav\MsM
\W;ovwsVos\Apsp mi>pkFI~rnA۰ x\&o\.b}bQ^͝DfRm_j_ܝm{hF#tTX5/Ac{D]AvaXثkHaÃ+0*?[Add.qLH5=cln;AKOpMozioa/4.0 (cow͈; MpSIE 6;)a/OSTǀ7OwSREA#./''K((..0//</^K.b˙!!""+&/&./HLKJ@Nz9H~`n _*K$h@6}c`eZ/AHwoD)f[G@
=Ke7zAvjaH#ljlT6HujWqRֽLPbտn3 n͔ Y̠(uS_䷻+xZ;cF9'ouva+ȹQ:snpnxlmF7O9]ev uVQLжύQPL+Tg0RP(uk֙xOtj
,n	_N"(w0w۹vn/KYhׁ	`\MQ5R/:-9{,"h0[9О8 xYѫgeYEⶑVSiW9.$WVx<hb	I~8KlC`a7QQWjl8LhJPlM#(جAw@?tmWhPg:
D N2 hdD.A@@=mL|toj[S^  #'t< xNVP'hXlHp7~gl3,'j4-XQh=<t
$u$|$Sw
hP&d&no^ް
` ,0>V}WS53չH+}na}Ы]9\t0C .S
,NM+ⓞek=]\]@	`,:_kcM4V~xza%gܖB%m7\ \%Giv	aQUV
3E}6i)yHDQ{E	$*vb-(	.;ƣ1
0ň8/$ yVzE=x&dh5_2o~%@#5_8k[uuÿ35<Q~t^l4h
u	*c`Uy_n[^]Yi('3G}ĉ'l\btB4;:jD_Ey64af:}6w!,׳z9*
|2lx )4	A'z H˸c *dhd d:{c^oCle7S0olt,>%d20dvtz@V0ayoV<Fwp4$fu:0t?ldHX=7H@y"954Ou\P88,76;~6M*0:9/P?McƁXwk6^u

8zoWtt	j(hXi@6̈5AA֣"]h_&R|	Ԫ|rW0`VUZ/	Dnl|mtċcF<<@hPdP8oYY'1vD\P^ea0j,YV:bA
+EXp'\syA
lh 6NEi`m7SU\}9P=tbUy
VMowk-#;t`B@V=X(V>4c.} W@(aF;tmDu9xNƛ=)(;Ò]'$MgZtbۂS )wPSzSͷl*YJj֐^'֓Soސ9\6טJx\l][uo=,6>|Bt(؞o":7u]¸3l]"J|W}]P}+4o,
[o3ר@m\t;u"PRCVPtT\)*,ZEbn_d g t JIRmzl1W$LLbf<dlma =@s>
*@w<8 F洁tB.[w9u9'ހW?xhƭ!fT[&tku*peFlƶU]H%3E%Bm#pv[d&/FxPQfuQG-\Mm##7`@&fuhI:**PZ_<DNHH[Eޙ¯l-oE-uqb
W
r07dujdp3=4x4Vٖ45$ TAmivpiǂ4d/*((68N`vP2TS z;jjZܸPt:kP@SKLtujHa1tEL;/X;l8`.R8ĨK '<v(!
P	ɈH'VuG9G_su%A*?AAVބprU,E;E#P@@Cوpklh"rP<	pAC=;E7K'K¸ݡ'+m `~$	̀8g609	EF$\(0L,$8/Ho9u-e8T0ֈ]*mp lQlؚgXE;o޲[*~Zm5HV CSV}z~TVk\D nO9^ht3ۣި܆X$x苙&ۜ	89Cu^G4( ہvS$ǃcF %pk/MrV$RhR^\pT,cDW%p2`i&5l{ f't
Aη̤ى=2D + 	%G
7Aôm4.k|@Fo24Wv4M&޾t&c(r<?G|Fc7#^4JxZU
S#?vnQV􈑾F@YWh`$Ke|v
ahh[h}(=i;T$hH 2A>c<I88su 0IbXZh~bdђ`w9c`?pt<Ťf	.cª@@pY|hfp&da
q=d(|h0W5
fPm);Yru`P9̺1X5d\[۠!0xE(J3-u	췉t`ATqõ2pޟ3ĪDF@	K^B?xYN]iW(0s	XW	!Vw<bWzHMP94~sF,s9(Jh=L0C@3ҋ~JHN0N<v8Dr[Qw_H^DHޢf,0 HP	K
V̎xA~y
; 6)sLў+ .|$Kw+WVn4:Coq
^F2\Ɓ	б%f:$aw[Jwjp(qIVA<V׀ ۿ<"%Vj3jBDX\(W/`xG@@Ft
]NH>1
|*w~ 37+j ڳ0_A"@[G[s0:2|t
S^BY;os6|DD#G	&N;6)!Vo"CNb_!q1 L-]Q	PAҥu	܉#ɋT%+ 4Z[c
0mۉ1DuJo>DNd`!@\pp_9VD6[x0@KNHj	n0Ve};wu_  \jH$wX]zqaf{{<t{4Plf(KVtkg6Q;-3:aP=]ujXf{aq^l>D什8@X.UM߲mvk(H+ͬh;u	cZmjp!q־<QYm(;Wҝs<HKt A0^tilNpNYlS^XPw.+>ZP,b[WW#^tjFl
۽<x:0 C3s	6Q.xQBAuSFp?xWE5g&
@8]-tXN!LpAE,|c~焢p tQ'R9RQR4I@I

]ˈy> Z-v'MnpSwX}|P@ j-{K
Wt51Mtf6x#(
M7 0|[pVp^Yrp'>Fh}Zhcg;b;N	gD^8K[;Ծx720s<U{$Aǧ{XJpeuPف7n:rƴSِLTo[Èj-8@׮rwN`D6$j13(yr{(D^xbdИ;|A
X9${{hJ2Aoh.rekA@1?A
,װu4-;&OcV l
a	&'f4KW <
t<
)<<XwD
x9=1&B4V^hj8CYh::̀Ō )N)!cu4ՀJDy>,
	ɂ$n*޾ ڋn'<@j~@_>Q9%tYfϵhG'M:N7w"-'1],0{.|5 Ptc845SIf:x.ǽ\8֠FA6BWl0^m}(HC坷tSo<<ȋ+Ѓ9KUB*K*߁Ї"MJgLRa)ޝ&-%؀	`"OS#6q+A5Ȱ{(zV;KPBg<HJ[6%UW$!U}v@=tVP@GJIӃ'D>Ӌ\Ul][cZh|Dn$Vt
ՠduP0>.j=$x [
A!G 5Wu]چcB7@KYbW7fR؊3э
@CQ9 3pYd4XF@ ;| +7'oϤha4ȡ	sX$L(ՋCR(2p4T.&YRj uS`1zt5}ITm,vCM>wr
C~^N :tuKKF7Ei`?$p-2D)GV!K+=	M
 )W.kVOUj4h_>lȨKDPEJT+ԬeI[в^>uݭvBOk f?DJo
@jmAPh|(UR݀~%@z;9<>T7s9JPhuOGo}+ L6
!#pуw$Q:jpRQG>kSK9
HK<-V
u7"O 3
[{
f$ݮș;˓uG:	F:;x96M :Y`
<΃/D9XNkaZ
+QHP
Q܄	KfuV@@A)=Bt(JRt
0]0f~ιpf:,
ۿhfV2sf!uh:o
^j~qmJd;u;}q?tbr;_/k	h;5\Wv@	xsj}g[  G9n|Ѱ~<956nGپeDV<CdlE|FH	
ӍY\7x4}tIuB;27фt /*e2IUtB;}
5ZW|{~3 ]-5zK]2f+x%À
w8~w
}}-}rhTwwbYH])	D4[
mS}_4	L8}t%Gᜰ8*t<.];ڞ;2^\0!T	 , ~mm PrGې\1VO;bP}O;|Ԋ.x?dtSO<*6vUWtFܱtٹn+|N,}pÑԬF]S~BKD~I@UO̸>eAXYD8^?nE\6z@*UTb
ExZCtrlQr?ڀD+]ch	̈TokV1e/n;tu_1 `)AsUs>;+;76$upl>0m-)Enum|l
Z

uPi⿀ADPI32{wGs}Modu܇۶iuZA!ZodImohd;SviaK"dO'd`c*MRrsMvT	sVg$
Y{)3O7mapdlBiL a%;IPye[yuJr y EК-vlc֛Q؇a5
pkGL7)0Ii'I$AǄ*S'/M+kA Gj} lr8i FrLibraflCz Ȁ>w!tP-ʲe!c`lHo$]kAcl}$B)p-w0S:R1amF'M4pFbJu:-PVB<DOatט%oreft**zI^#==]ZW	6uO,9m	SƈBTkzh=k)c NEIKKERNEL{>PBz
M8V!@e/BKFTiwTrqslB0 	:.6aOl+i$=7P wpkfA|E*+uQfݝPeek/ /US1kMOCK%l E¹EyEiEE!d[ #r(!@^Rb	,647|ih`ȯŇ1:&:7@
*d`u;Q
] FhGdĢݛ̛؝
iH9 @`M-K3+(8`#  ^  Jw|113333333334334444$4(4 84D4H4P4T4\4`4s44L55566?7x7}777777778$8X8m8v888888;9C9999999::::0:?:Y:a:g:m:y:::::::::::5;;;;<B<i<<<<<<<=-=3=E=L=^=z======%>4>G>O>T>`>k>z>>>>>>>>???%?0?8?E?M?p?i??? fD0"0+0<0T00000011l1{11122)2:2B2I2O2`2k2r2x22222223333%3+313>3dS3k33333/@333334\44!4'4,4E4d4mcy44444444444ӎ5[5e5/}555555555666%6I6V6y666666$7,737]7777778)888899999 :::::::(;4;g;;<<<.=C=O=V=d==>'>S>[>{>>>>>???F'00n0006111
//282AZ2w222)22333+'O3bi)s33o8&4Fw=5u556=O6T6nw666!7h7p7u7{7777777%888]99;:Q:Ui]kex:imq:;A'00 408@0D0H0L0PX000k -P111142@2H2U2^2?3H4^4445555 6&6;6xS666677 7'7؂XDH(0P Q    $ : rA/ ;sr̬Е1 uA sAA  uð_u)=                                                       p   `      POST  f   f.V .X <  
 f.d ` j  I     '        U    POSTv5  V- J  \ } I 	 0w
 , ~ R,
 	 l + + \ q,   4 v5 5 M5 ݦ  
~  Uw y x  ! " .# p$ 7/% & }' Q( ) *	+ , ɼ- ;. 7:/ \0 x31 о2  3 ~4 I5 6 7 p8 w9 ^/:  ; _/< = /> ? 1@ `/A \B \C }/D }E F DxG H I +J y\K 7L ,M 0zN 5_ ,P Q pR .S QT /U dV W ړX -Y@Z [ w\ \] Y^ I_ ` a p\b f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ hc [X <t
PW kf&E1_X  fPfSfQfRfGenu fnteluxfineIuofPP%=  rYfa2f   uI؀ Uhjt/f00tf  
 p0fZfYf[f
#PRWfQ
u5p 
(t' =f0@
u߿ hY8ufY_ZXSQW< s13
 h3_Y[ABCDEx} U"RVWfFf^fNfVЎ.< t ~.FuN.g_^Q	

@
		! &
%3
߿> hx3ɇhp0 0t  Ãu
.+u	ug/RPVFI` u tk@.tމ^~u t/ t^6
5
^XfQW~
,  _fP	$S8#:r#Lt<
tw
u!ο 	/_^p	9+5WfV*0#)k6S
F f[tҋ3ff^ff[f`K.fa92 B0CfVWUB t  f7h2%3 tkfAh6 P=x'Q2N7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^@Nf`Sfff@= hR3>+f;r[A Wp
2h_
 WX
_: r
gN1
gnAr @9=9 \AVWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_QU/tg^H2gN@?" h fΑR  } 둡4]hQRWV^NV vq6Q3dqI4GYGʫΕI^_Z!3Q'Mw0 pC8 YfWV3ff"1*bIfPS. .+F}+  f+o^E
N~u!zh*h. 
 ?GuQVsuR?
 ۀO2ۊ~f x{k:P`?tWuf  f.+<ftf!f.@# ~>
uF8Fuf_ts^ÑGVR.>_+s$0q	.k6+.+z

ZFHwPn2
F0o+FPPv2P1N~ t4vf2f{:10~`FNNI.?+ƔUfVTQh޲rLS  rDe0h# @ N   gf  P^ 05e@F]|QZ6 	fvh~uF F 73h3pZ_YH	h^y r rD(gf	  #wfRS{ ҜL&tMYfvԹ tNhCHtDs ʆ hl/ 3h+BFv ~&#3
Pf~fXf   @
>tq  tgfNg A	~t-F  ΁ 3g
[ra3yuBF t~y2h瓨Ff3ҲZwh(FFf;Fu-043  J
 CQ|u@(.;+s0~ ˁ ;u
t`t@Ѵ d^rf(  _^ZY WQ3.>+2 ..ƅ ` P@h4.ߪ+ `$S 3.+h>~ ЛZN [pwFk@"~ 
N~f.=6@.2ɠJ0[tEu4.Bf<tرf5$< F.v 
1q_V@~rF F`! Lru~w
`~M~fɢ1Q/ t
fNu
ffs NFw^P@j4P*Q
Vq4F$<u&_F # ~P$wp` .鄁ph {<'u{8^`}V@g+@..+g+^SV0&0
9t@-2x@2
Eb/^s[ 65^35#u\BX:NкuP:
t3S9)ˁou=8N0_^WSVR`rfn*v[ܵ!ffARffTЀ`2fywf;w
2#ofPRf@qPt#f3!fD`2XfffNL$ss4
tu+q%
u	[A^aJfـf^Z6Waf V^~Kr"8uffFՋN_QcV@wvb!F;pI3ϋ~+c:sRVRfQ_;Fxu p? kv@kFل:`b:$$@K@3frD ` w;=< u  r7,.;D$<u r sh@BvFfYZ4VWӢ Юfݻq~Ud
t"t't @DvP }xPk9SV0޾PP3; t	 r^[p@kPP`_#Aq[%Sx^Y@j*pt@;v7h!tk~@st 1;FtFk^% Bk^PPa 3҃  V3k`[
C*䊁RP;FuR*3]0t7_t-k		# a
@S
+FHu
4uGrvFvVBs0;~HVW΂tS03ދ[^NuVp _3ҋ0_&96>1-x4Dr<b}lFkHȀ=BHP뷋A+g7oZ Q&0V_  ~u1|\΍0PN~ tKv0YFQI.Qz$ x
fpO3g~ FfN@P@ 
0K SQh+	 \P,Q23If.` tf.&!. .8+tьL$QVW
τfvF%p"`F^^F  FψF
fgFF Vkeb"^`LY`!ɱ ``NҰ tFt'fy`e 9Fv@f0
FfH yQrZրi`bԁabfC<4R^VFъF8F^ǿ  pQ0U" R$ S&T(T,ܙUtN!!fsШtE rtsCA9FvG 3r%if.+N  `N0ƺ3 
t
F%  .pO c>eF~ tf'iz e{u
 v@aQI8t%  vu Yw  vfIft'fAff#a 'fp=rS6.6  G                                                                                                                                                                                                                                                          % o  PQRa&hjc $`Ȱ h?rZYXSQWa$a$a  hx=o h >5_Y[2揺 TCA6  @A Q C@@ @;uYð!$p h+
f`   hf4ٿgf&` ސ  fa.o0h
 
}Y
hsfPfW@&'_fX`{i
.?.h	-t$_߼/hQx*   &  pΔ<LZ@ ؀ L&}uu hl2!3d 
  % VW~jp-5&$@#h'ff
AÀtf%1fhQst h?:*,Ⱥ: @p 3ȰS, @uSh.h s!Túv0@Pp"0..  R   P.   f4%  0"\  
h­ `b4&&aP h"; b# h) t
 aPQ) @ PQ= `t
3f3@fYX _p>ðd߫`4d  UP@kECu  =W
  TF  &ؿ
Et&؁ B uM9NwN#uӃ~ t"F= wt%   +w0DXh.?`.0   !	 ; a `h]N0"t*"u 5Lg>u!@tPRfZXF+~f.~ A`Ef` f   0;IbX1SfQfR}fJ  f`(  %=uf?a2 ffZfYf[aHSQRfW0f_Z PEhDDgh sQf`Q Qs0NN2r-
tf !s! hs_f*rPs3 >%f
?9hWfaa	'?t5<t1[f  ^]u@ Æ B<  C<U $U # Q R ST U VWX YBZ	f7RVW3pl-{*D*
` U`T_fyD 7xуtR0ZRSS_^ZYL%E r   >  A  T h M e M A@ }9 Y .   nSA ǀA05xa (
 Rq? Q+`R{!R Àtq<2 P f{4!~U64f6,40?  3 |px 6 4>xA.wh54SPS{ $<t4r [@! Ѝ̋h53 X f`4 S  y)6h#%$h9b\ 0n D 3y "ro< t`^F,2"pa,m ,+r+, r%@ -+&5&D&EN,Aa
ph 0-p,kumjt-VS-~^ 
8
3
~3
-^,
6'-A PkyvA-^&@ U$=u&-f= =u X&-&-&-y
, fgh  0 pqr  <ABCDE xyz{|}   ) \V S#
fh`fi쾦7 r&-&-7 r
&   7x".&.ƓjfXP^Cf  nfw5fx&V3
_^P0(w.'t%.FuN.PW, _XCWfVUSW! Q,fv߿w hz  q$~22!IN܀3d	^
u
t_NA&>+_[]f^_ PVR&=;u&&~4u&^P
P<q +&~& 1E&DpcSVߠ h@b^[þ9`[WfuP6hC@ȁ  <fX_&_F10=ROM Based Setup  EnteringP : `. u  :? \L0t. :МP; Su )!`- W  ):p 	1A	A : ^1:qrKp & :tF 赕t
.>	t.Ot
(*葕t h9PXhSHsF12=Networkrvice BootWake On LANAttoemptto %  qh̾t8 0P; r	 AP;u Q;1Ja	t iltsR QP.P;$<0,( t;]BEB"P;! ds@C	%25ؾ
M<^Щ1s ̈́E%b VRyoMlNF L3L?	uCFG~N0tGhջNLvsh Z^òP*Notebook hard drive MultiB{ay"DockQ%b<#b (top)bottom)leftf	Flopp>k  USBGCD-!F HDis/SupserNIC$*
!123            /            ~ 4?RP p 	 
@ʐ
@$P mB ` ~@ТpqlectZDeb]  ͹U8 and _mo@=the highl@ tp`your chob. ? Press3w1bose.Seconds until au;atic defa A start:   &A<A(dA$P A'A;S A;Zip.F`u h d0ô0.AӍߍtԎA> A VL3L' tA<v<st1A& 2آٍ=24?Q#YAr	 ? P A.A
*}}A @A+jjj(Pjk8  A߻ `A@ z  ڢ  A R 2җ
  ߀ t03A2Ɋ F8tFޣhL $_ Zbqqp URVQo.,.L.T^Y^Z]S,.A*[QSVW/ s&QA.<.-00?0?0.Y_^[YQr@ u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰw`2҂ X7@
A@@r
;w2pAJơ}gFY.*A<u2K0fh hxh7d hb<u`B J qWo rf.>E5 hӿfgf&G, @ f   PG0f@G,`u
hEtG,f",f_ffP QW2_Yf= TKSt0fXbo    ? o  J  b؁h5p.
W
g&Fg&Fg&F"t7g&F0a 1 2HdF׎Ǎ~ذ:{ rsfF	 k  QRVDTQF r&e^ZYoFffL߹ (]~LрY`VUfQWo
ِx
K&n@
C' C$C$0Grx  q##_ r]"0tsrg r70K:k;WQT rQ {GC""Y_r
E@t]^f[XQ!$&C"u
#%$gu!#,vABM  f.HûPS [XAu.6Hf.HIDNU.HSfV#蓽P #^3%%Ýf@}3u
u\ru!q!} "W3 hq] *hu3p%5cf_ ]`= vH O1H aP߰ hj"$@<@X7<P4pJPR ZX@ P.>I t.I.I@aISQRWh@r_Z>P TC r99 r/ u t t@XR1$tutZ 2 WW$ f3hcXRISWQR Zuʀ[Ppq4{B XZY_U*uu} N\у< @3ɹ2 uhXDp#qX) P% =_ @uX%*4g&@MHIWfWi	t<f_!Qfpyf  g&?t9g`\R%fl<u @!a  f%?fa#   f@%fQ
<tf  f !pf QaadZYY0a$fVL/
/]GP@t

z

 
\"
f^ff? wD Pf%@~
!
k+fmoH34r H5 0P@p <D	1K2 P` E    L཈@`@"  	P  	i wp   C( Actf &.&.@ p p 3f$'BR"ust$ uf_*cŃ>. tuc ~rh^
&.p@C<ths}.  G01?}4 Q < t&.WG}f&&/
4%/3f30 2ɴ*f&. uf
ffKPR/&J/&Z/fC-0c/g_oA-/pG/5RfVWfC3ffCf[fKfSfF0r0а K I+r󿼽-_;Zf5SQVWϾ ߀u3n_^ 	!BKsV 
R3
t<^f~
w/vưP0fkd`dfft@`[^ɳ~VQWfv hG-F&0F&p &{ &P&&0&&!&#&%0^|Uȡf   rGt >`*:u
P0xhg޲bX`aĊWadf]PRaQ  hlgjjj%jG PR	Pu [h
v߸  h3ջ5ú   h%sp
? ( t 	2se fS ffff>Sfh @Ug&; [ua)f)Pf0gO&t` b   ttx3srnfǂB 0Ex 	~/u~/t sa	~;TtM!ܤ6O                                                              TfU.SSWu u[rWJrR-rMStf0wfqP| @Wb t#r"t p ; }PJR  ZR ?f]LCqfUr*6@^  R Z0rG	0Kuo!!Vg&fFfFf^@e rC\A 03ۿYyg&8E tEG SBWiUm r`U>SptCҍm8lql0h0ҥcʰW rt r
 GC_R밞Zt$oؤbM$]0WP  _W}  sp  a #`P
߰@S P  	ð D v S8 3 e WR	$#
gR'
//QWjuptPX_Yù
 d h48sxu迬sz
ՏP .<u.u qRR바aR22hX< uZ#ȴ$? t	xJ  U[
	a!"9VfPf@@MЈ^hXàh=aӫhr$4/h Ghk".u_va { r PQW 0> 3_YXYIh`C=F =U$h_4s	> $Dð   ! $!f` ThjC@u' tf` h=* hْ; tff%f
 ffa0vP]F X8`ؾL &>L&DE &D >
Mu d] j@ tL}
 -Ȁ}	 >L ?33SP[tS[a@Q 2[sDy3 t^hOhYs
JhOQaàhLRD
ϰ<DuL
p
E$<u D
@13Usd
rSi&pS]@` u߁L
 6 6L u  (X6 &uhT^
	\

u>@   ^D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  t"{& xu	\	PS}   ? 6P'>L_3& ?! W>L	_[XB
t+# P xt  t  w\DPV!$!"tKh10&,@ &  ~` hC!r!L	vTt
vn`WU$@t! $<v@a@n3  v
p
u$< t"<u P>ȷX\PRt P:p1߀thE\!&ă=0ZXx` 22PEǿ
M&PCt5L=LtOu570: u	At!?s96 u5 .~\s
t!\&@q s  `a
׃/콿_3 cs{&=  V߹ P;Nu 0< ^]  3f4G -:Nf_  }0 U!    'N&egWʃO&MuO OqfGtM!t$Ot, t"OGr ǾJM0oOg&>Nį/` 2%
<t29o21_kP*P*`OHtS@LDhE =_7_D D	 d
z=1;b^tSqrG&}	r??23p4t`h߇2a&ET$a	&M&]aI`.'`\%# rU VϠR۶ǠZW&= uAnF <%K)
hK
 m_VP
@t   U!w#w !#`0|ovh3 f.-.MTN>tI! //(rJ
f.58v@Nu% @BTB 0hxshaW$
"1D hY
hCYp@[X_Ë
`PS@E![X SϲH<vLR
 Z,<u(RfүffĢfн,ZJ vGu

 kS1 6у[Qb$ <@aaf3fi!<`c8 |	4`֎phv73 F
t):u%r9eD	& h.SL & 	 hނL3G_a!3 
3 ?  L SٺuTu " / [J rGQx> r?;fQ  x.<t*tS&' t&A+  ̹'{
{_'+Q~@s& 0RµV}Z`}tpk hг YQ@@?{P`[r4fHq(u% = tR0Y *pQ@_HS3L+6 
HHȋE&NAE 1, @r \> \hpӽyxf1  ,V{A @P$P<PtR>eZDAAO  ZGpZ^a/\WV 0  Ph"X@ 02)
C@)2]ƀư?!C@u?r?@Dtϊ5. ؊u,u1 
@a

+&C323&@t  %
t&
0  W5  " Z  ( ~
u: 7/b!	"	? A%w ^rPRWAC&wA &]&U 
t ˀAi{] _ZXr#3һ -wv2C.U
o/N#h΃&_ '^ Y       ր>u  '3W} c[ 0_mYf#`Zf3fcu 3 Q>[L`[#:wuBE&8Uu8p]
R +B&U
ZK!ؾmZ6fYB)%qr h ;1|	Q(t0$
  5Ãh_P8.
<t0Z`ێûPV#
@F^fǠ  X[L~ED
yC! A   qssUf``؎ Fw1p.p ڎfafSfQf.+pf fff#fYf[2VftGf   pIg@f;t&f j	sF $f^`2ۂۈfaf`3mmp?faPP3_X.> p+ . P	/TACO Fr  
!	& .p5s<F	p fF_f.+p  #pF./pf.>+p;E./p|@  t!pttYp"ptNp  D@SIVfB.f$;VrT%W B!Z\	i} %Qf2$fP'fffǿgf"'r. p p%f@c .ffHp#fXf}df3ۃ!u+`s?I
s*"/S"Vf+f;wfff33RRE'po4^q4'r44$.71p6ɐp08333  QW>pJ% _F
3}5u'JE#a0 tߋ 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^H uVkQ`  &t Y&_  
 < tr&\]p &\U  
&kN!d L
SR[u 	F@& $F^[_bF FY2pTV'}yPVWटًذо' M! _^Y[XWfQSg Zf^at
  [fY_` t =$PpnPu2MߋtaË6!s } tp( ` j &&E`?SRUQj@6^]Z V` jxvČD^XP
~*F
O  t# b Q`lF ^@Fxq d3duhXKu`<Uuùd `h}c4d w& Xt   h%}:ͻ% h? PhE'`X!$!   ¿rs} O
߰ehG   tt 4  h^Jc`w tKu& & ? 
 ϵ` h,s@<t<uuТ 
0u?1*`P	h9 Xh $ P &D[%Öys%aPX'w$# ) )t`($} f.`G  c ED߾m@77 À   ; Z x     0N@`^~#bhV1fF3.]z% r 
\0ވBFu~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہcz.~r@V» 㐂û< f ˾ff @ffRfP7f!N
 ffFf?3fvZfFsfBf〶fЩ1 r?9pf3ɰpǿOmfAP  faþfPVa3v޸rF3X

S,0<	v	,$M|.[W D`
o
Lb f s  f 
TO
T p s 	 
Sf_fp ЎfvﭿPUYP,} P}:Fp
uf^fNfV_f^pPRp*fV|A6*F@20hC@ Ͼ
 ff  fffffXChq p  `90} P9󤾴~" 6 ay)P*hlc7P, %ofPRhK2R ĺZP  (Q * 4f_f:aD0  f2MMSqhm   hYCɀhh;SZ?;PSSƮ@Apq$ q~!˰Āu1!A tðvntt<1w(<vv{PkEhݶ3_ P&
0
3q 33ҊtW/g.&;?u;@.Wont)@)hPmt؀a`2G@t03@ @u?  a|[
u93Q2,;8<#fN 
~
P5-j1rX?~03Qr |X@Y4SwQo2P5'$a&& &0hYC hزu򿣶ɰ h
t[ Ȱ t
sŀv#t_̰,5-PXv8v&> `t`_P3 u $h'J4
#RV買 `s} uu22hSgu]EuXP&
wL2 Q߻ hNu= Dt= tYԀ'
Y#Y.{^Ze[1XP #|@]U  Pf^ ]  _`yrr	 V'afOLP?H       @6̃P0;V(e
u^V- ^"(P*^  2oMqSP( 22 pX[úB  $@7R  Z`7               zJtP( % $ 0rxfL+_  ك%rSr$迎rF!f+Df+\ r*̭r3w r@ .hfa2 PR30 Z@AR `&Fd??uhP&Xh$ r.>.pu觭 	AїQR.h f3f%  f`YURQSWF^
D= F\ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF t߼ W若~u빠% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]] /?             D?`ރ6.u;v` Ql0 >h *Y`"QwLQ`f&YCoC`K (   P3YaPSRP3@mn?[`H@4$&%<GPȬ 	 oپ <BMtf35ԱP2W X` Er
JRU3 fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	t   
 f@3t#ށ %t5ubfDqa $<@tS<tO`NBH$u>f=Pۊf@+rCtq Bt#Bt	]P0f
aff6pZXNW_ RWO  3OtCxx ؎pP.BB <t BB2J &ݾx   8u!@屆`23Ұ
ShUSt0`́ y aut0i at]U U[aSR  4h%e
 h?cfZ[`-0Pϻ  hP8	 h3
 "BPaԀa$8uXRP<u1ZtQrtwvYu0ѹ }R0wZhEU2<Uw  h@\2 u
3Ҹ kEF)v upQs迶tT 9 
( 3Pf. UfQfRfUfVf@>h: rsNrBW3f. fwf_2f^fq3Yf.>fCgffgf uYKU q u, P3	fgf CPpaIfAgabf.#f9ufpfY'0    /p ; 6h7j Ne7U" 9Pg~Q 5 %"es  OV3@\t pme;F ;;
V3"/fUi &g~3  f% '" #WFfF^faQ_V p @Z  
^`q[3[<   f DTDkw R po 0 ȳh w 1   l ( Pb @z0 W HL P`A T W Xb, `
^`! p@pؾpx o A0
|\D`QWhXE3 3_p 0 PQ= `tq1 @0YX |05SPp
& p  ff& X[@aa"&    ir  vf{@Q  J&OfQQMh2 ./ۀ Ζ ԟo <t k~l tq.Qri."D.|u.:DtSI  wD:r5+zs&v
uAl
c1PQRfWTc`
fXÑ2a`2	  "	f 2f@0f|@R %  3f3fPTaX Ah ZlUv m fb #&f fa dD 	h}W"ϻ (;sQSf  rї`
 t
2fƓ	40q!a
 Q[ffY+vf[Wf+_f߃ t%xH+f@`h0Qpgؐ- f@kf`0z q_L2_&U uZ=PrUf uCf*f=`  t0  t( f{f
1"0"fph2%/$_!"
 \\-f g&%Կf2@t
 <t+p g1~f&f   ,[ XupG Lr}fBt<rfa&'?rfʰQˀÉ_F?<nqP
 J 
"a	<Ub	~p@R2B'uE1BcffF &Ff{ t@sf @{f;~t	uɁ~qNїV&?>\##`WfVfPXfXcr<w؀.0ճа_Ѱcf@&ˀtg&TfVR3g&Pf0 `&fnu=жtsaNu(g&fVffA>"Ȁ.f+E)^f^uS2u  w & PsP0Xt'vt
t@0r׻ % r/o h>u  {thrs-3&>rqrRPzsRuthX$uul	r` 	 +Zjj b6uPS`` FƿF ph rou
@ Ѕ&&  ؀>t !$!f$< uRC  _
N<2<ăƁW	"3A'yܵ@h[u TYP=t 
u2،в3`t<u
E< tȵE$<u&w $tRݚVL  N L Nu û` t  P[2u
@j OjY!(!!2(<!1ʰe$ h5u$0t
$~1.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|hx=_DuQ&~% t P^Xӹ
 .:t
 ._
vXP%8Xr6%ȸRfc4;La    PJNL p      QKOMp @Kt  Jt P(.DGH h2h  hvQ {h҅ hE Б?E^  ` f  Cp m& OE 
v %&M߰t&:
&;r"`p$t1TKKub 
HM` `(q }p" sr#	cp&3a C n	H ]r5{r`2gpjh!vZaVRQSh{Y4Thأ4J.`B68u,2
t&62@t2 sk ޝ[YZ^S Ph9X<?tFohUujjjj Pk8 &h˴X[ hfcY$vawt = ;t= Dt
hEsp[.@WVS$`́$
臻[? @n< u"*׿Oطh}Nt`-->J=Ot1 0_ tyr rhj  S^1  0 hL PͲ5[ ?  :N2?Aq% ? 	
  v VFPgbǋVW 2_2µzt"@uG2 
u
2 
 o2E2&&&EA &e?
td&E&&Eܒ E &E<r&}	r@ VW^2۠^2*à
&}vPuh_VRPRQ3f 
%*tu,AYZXRPSQY[XZh?tu賩	pp Є> qQ 5rXoYj},: tV
)֮hXERL&&  t8t' u a+& nq00r6}$^$ ¦Z& && ҵ;`Z@ `dde`P`  XU @>
ڹ Ц .PB B把8uG` A݁ ; 5݋/)u@#BS _냑75VŜP愿X
 a@A@ B C    ÜFtwV$%Ȱ%蝊<;weċ X؊<wM3ɆQ#"XR<  YƊȊĴ3ЇуE .pY8@C0	 FWYuF5<uz`0Dfv&	2U
pu7f߻hNe}PӀk 'B@. ,".  6߀&k o!< uf& bÊ$
r wAu%|1uhӲ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<fJKff
fZhZZf3f3ɹ fw Zf0m f+fZ ! KpJu*xJآxJ=f3ہ[fsV4C\` a^_^fZfYf[fv3hI 5R`2K 揀L0s< |&	3gytvou4PP 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .\3۸ 2;*@Gaa6h['گVWa/-z_^pk` hΫ$h  uP$<X%sf @  t<   4 |r	.!$<u
 f3hh.  
d]XiJhB;<  tdbw_0s.> Nwfm tghtC	
A!U2 u@> l = ?]c 3Fd@ e f Fc~ce; 4~e uQ@@8 hӳ`5
P	3hBFe:Ffu1r,
 h
 Fdt~:   	9  <g htQhٔ`!af`7UPHh;u;E#f% PCAXt# N h&N r k f ̾   Fo^P XSĻ  y ,  o   hbS-[t(t@_t,&j  j,>" ' À tht*dúߋG."g**=D/.qpEq+Ë؀TF/VU2NfQa dYF :uEQ]Àg33t
t
u
1t#u
tN02t"FF0u3! :5tFFdz ulm29p`F: uYeb +Πu;6F1 epp0Fwff`Fup   j(j	R	aURϨh@2  pɺ ݴ1 hZ]}coRfB`f!r@!  tgRQ Q;YsY2製w$
 !/u$ d%|Zf`  WWeI.߀&$]f$  pC`hB%
 C ƀu0u.>" 1fa
ZURtLށUHh{l<:Ym PY8tn(tp ?;C Zi@"ݤgۇ squ4~VfRfQhÊ$0;p^f[B]$8" a[YbhVq r 6jSj@ 2P sϰ rGZ5'/UnAW`.#uQL$<u:0pr"&  t  tt" tAt $pu?P:q9(
ː

 ⧾L`XSwQ 3u,S?[rE	ˡ-Y[C& <ff<`00xx00`֫Qɬ||	>>.p~wr tr~ (ЃrLZCX̀'q@VF :]Q<Q7W &TZs6B  D ц߆ԆrA zuN! ?C _u 0/)0/c#-&@ 8q2 E *7&/p`W aUfV3vCDPDQD 7p4f^ǋ]&ÂQM"V%  烪wPduX$epI:eXa@1 `` /////- "  @f%pD@. FACSPZ 4DBGP4BHP  0944 A!  8  APICZOKm	a	a
@  		`
  MCF#G<	$P	{     @(N@
 2! RSDT(  		f`h)C{hsif  fhpfp  gfF_gf  FPTR ff`WgFpfl~f.Pp^$f3.[.Xf.Tf}PgfN0~$f+@hYC~3ffgf&_f.>f(.YtX_22@_~( N g&F	f P  rgfffff+f+.\
ۑ`M.>PfY
$$#D PX_ff-qAFV3g&fFgoY[pff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt"@H Qr< uBOаNRUfQъ̓2 twPxprAr v; tg&P)Xf?Y8]МV_fWfV* f& f׀P&خ@(#wf"fP})fȀ$ 4 
Ȱ 
ff	h⓾p (f t  h:cfPW EfX3 `vdZ$0vc߸ g ls+
hZ3=a+0Q;g&h&_g  PSVXY [ m\4Yt >Iu	\{Ci? uDb& @ u  D` ^PRW D hY= h͸ _ZQ4PSWtSfP3h f&L qfsPBġ`#L fX@`vh4" 037fpep&?  @ 6Nu    DOG:Nf3{i pG  } U!   >N>'N&geE E puMPMLGfEtXAt$Ot3 t)O$fM
?rþQpmMe&>NaxҎU  r.p]h"2.$<kBp^   #l`& BlڤWp_f
Phk0kؿf$ttӿ& tϦPE'߿ 5(ƘP)io_ԜVΎގB^ 3f`FF  h>w }ur h  $g(,0w4'8  s7Ã9FtFfNA9F> hx4:ɭuh(fa`󃿿
Ew13ɊMh$ӯt

hRp;r#uazc5WF ^SCf/ fN^Nf.9ߗ2u 2tc rfߺQPH_urf;^uf;Nt;ft) p 
tF~U_Nս MfOV t;6+.<t1!QQh;m:,_,  ^_U00 u,hX..D+hXك/ p1_fqtAﰑ"   u
3   t'0gf GhECG$L<LDCOMPAQ PC Card Smart ReaderlGEMPLUS GPR400lPSCR CqLB REFLEX 20q241 PCMCIAvReflex v.2$cr$HP
  a@Z!g&O@ y?Gd `P ߳ rLfK s5nr>G	 .D
A O@.d.D4f_ PQWĹ  
G.g&:uG Y.5 _YXQ8t *F 
⡤fW
"
@
@Bg"

2%Qf_V`bS蟥hB;0Gu#|  euu .!u = Ў~ 1rp&?tj  t_& rT  r&= us0=6>
r/6r4.!؋V@< t ^}Jw 
x y z   h9Sh:{ 湻%ZMh}Casia
qTrP~qtI	f} b
|u 
!tQ&C	GYV
~? ,`؍vfD   ߺ,AfLs-<t(<#@06 hݓL^PRU32t
t
u
5# t u9<0r<9w/tM>ư7SQ Y[t>"$,0>*SQLiE;f 	tu]ZXf`3Ҡ&&h(#֎fv*`%߂hÝgf9t0Xa` 2}   0 thb$q egf@ Vff3f"gf F ff!
!޾h3۹: 8tCRP #ܨt r1hf uf@q  00i{? 0    0     q'  ' D 
 Y/ bbƬk`oCd@GY kV̨2PS_.xVW ˌ׎Ǎ~Qr&} uBr	:`_^|d>r59r!Br\E@&=u	KW#p$Hr&E$7uz5ý̬2¯=Yӆa
ro&a)rI DTtr&e`4o5z~`
T3
K`uͥ4Sr#@itct  t$B!ffL[  	] 	VWQ
R3q
]
δ2i+W!z Pr8u`_QY_ þ1L[ r&Uwþg{N}L螳`
Pw4$X` $2L nB0<tH`8u6
uBp & DBlTt
aP 3 r/) r%BB!J@ 
; 05 aù<t

B J 2@u8` ~BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&a$߃vQ> Yr	2^Qd'YB@Aq BƷrM^	 fpb3׾S @T P`ңwP@\`j h\  H hS7諳iwk h?v`% `f= @u [jg hb Sjjjj Pk8 g[ hfÖ[buq?jJ&v]$}awtQ= ;tau= <t/Eշݳ3 {	hZt耲VjwfaÐ     tHuuu):p*<? uwuup@ z`34jr! grπ DƆ    r% Z@у-Z1p$Wp_ǀ uu' 3a re+ tg	%  .!{f$  f~ tp/Y[ߋros3hƮ ڻ ڻ= ڻe ЃF  ~f c `W tIe7r=> \Ӌ~ t@$@t0(5@ MF t w0Ó3N !F ~ tٳ	u?e40鰠SZAt9A`d f` W܋f3Q fY@ [I8. G"
 /2uJp2:!&= t:`T%J yr $l0VQ&Uq
MsY^D^
eOf"A	
fq
&:!& :X.Ջ I߰hBB 
D?7@P (3 ?;  A{-sC"7upmi1+u[	q	1D|!IFt$a3; 2 + fB \	(Nf@2Bt1Qr$!$$
7R< !ZKt'>
QVJPf^DUY!Ұ.&$++t'H"`Xtwt.A
``s; 6sb3ad_p_pkoc6mooo#dooao
foa?cםasfSAMSUNG
 LTN141XB-L02
1P43
TMDISPLAYCD@EA0V@1EM4QUANTAQ0FL0#72q3pXL205
AUO#BAG08 V.19 V3 
BOE HY 
HT1?B-120
v?-AG
CM1BCJA              Ȏ؎6S߰r[>e  >Y w 6 3Ҁ@87BA 8u!!uߋ
( H 8u :	3ʸhlPW
 
t_   @ك
_X90 
  I    SETU ˸ @؎&м  x r' hW@ P& u_SV  GG0G hc    Gu Fu t3  hC) 
hkBt & ^[SO
&hj" <[U샿VWƿF F@    $] F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @	<qt	dR>t <tjjjj3Pk8 '.wj5g$<t.<@t$t = ;t= DP hEJ 揿  77FF~ t#^FLr
F FQ  ~ wt: ] ?f
 hy;\2%PFAx~ t
F`_^Q
hv:ss.&udu   hb,$?wط h-"h #hlB/f_01FhB%..  @  Y(`p3WVe1E0E.WV .^_UP)UIQS6(6*`e1E0eEE.U s@ m2a hד4$e57;$!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N__Y[X   sc1@> @ p^ B~  (xsqUmf* %  < ! 1C  3	 +QVW?u% p u 4  | = <tڀ ;@C
 )(_^Yq?RWQ` Ê uUCrr3ɺ ڑ܋%ZAB rN _Z1SAWIpIyI
WROujvzKMJ; DE<@ ;<<݀!<3aRu BMEM0Nt
Mm[VfPfSfQmPnf3f3nPn<nXfffDDG(	Dh fYf[fX^@t#JIgO GoxnQRpA3ۊ9 r Cs7wB`s@zfDf3ۋfË\` 	
C  S T R U 	#	7	K	Y	`hvh  h	 h#	 h7	 hK	 hY	 avv.L.< t)F.6%3.PF.hQ\[+V..^̋] zDF. P .h:"Xh͎ ؃4Q  16V  0"Wa X Y #Z  
[a ` ^nBA\a e f']a a _ `gchi!j qp10G pppQWĀ>tk		 u	k	.s	_7   O 4a9Rһ -w C.=慏/E2VPm?n8o7@W3۸  =_f^߸^6_>QRrPS[Xfhf(ȁ`fЍ̋h
3     q     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	z ;[   03/30/05@!08 {~  kLite{J{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdP_x>0@ZѨ"2""Pf"Jx xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`@pcłŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5EFuu! qx00Ol俐}Dxe``
$`$p

xb
xx txDESxxxxgD@.a0}}@ v o :{}d`xGB>E%x}DmQ¯00xtxtyuup)}mNQb}ts ,{c,+"(^xkD00q x^Dx_T_xcDxfT e p# * -1`!T
,C%0=PI_	P1Tx"p2xp3T0//}@!T_C _^$ u!`	{JT`#8 )m04`hh	׀H{P	;F"{!
¯+u+$4>Uj}T+}&+p (++Ô@],pt+
9
0%?
3
ޑv7b",`]0/}j.@ / 2'0" `"+7x&x+=x_`t 7"6}

P} _}	!	 V @A
xxt"xd}A}D"* 0}=
 Z\"500x )xi`xj  p 0S+; /TB+x+¯0*/0b 9
P4.+10A+`xNL	+ xTx k!
+9DT~BKPFЯ y+_P>֡

B`[Tdp+$!#P+p-` 8=P` ðÔ2@VD0¯xx7x8r x00!9`6$06m !ATG`	p15Tm@:A@#YZ0e/t).p4"WW# LWQx,Txtx0x,?O!D0xT?Tx*RX-tx+YZ>TxY2ZsL^ZpL2Md&	]j`qjux0__DND0= * p   V/>gxdp]	:;9ZEhjQ@*ARx-	+_SRNx*SMx+` aKn `R0 
oeQ`
 RWS5PP1 03XD Qcd G8X네WxZAYAXNSXeW>`}X$R0Y0ip^qZ1ZTpL[Z1ȱ
Y'Z[0m0c1\\T=0Q\
r[	\S2A}@ A}= #-A~P B~R  5A~Q uuҌВ">4"7x'D
 X /7d`!7g33TT7?OC|`07`'`2`=`HpQx] 6uuuu0k uu0 u_u5ˏʿO$ƨpN`0T`
010@@A"| }(x]I"+,,E+p
0 `+C,,+ +,+x,+0qx!,,,++x_,,"-.T0CL72t
!Mt&Ipd `1g11![txU!Ҍ(0響/0mp/l`
/0d@TpyE2Aअ.-/0|" *xc"+xt`
o3x7x8W7tP}0h"[ZY
YcҴd1YZ \]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5, 7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l2Kd		

P!$(+.2     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >g d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   S~@ 2 Y}	J @ | @ s   ww ~w~ r  U}"8x4D`e T ` D)ntXFx2tx1tI-@'%[0' 'xqvv E'xq[CPWxs$% & & #2x1 	ү  ¯0 %#@K~3$b0#	Mx3C
r beJ"xrF`V0 p7@$" '	x30%
0&<T`Pw$"xs`bfp
0#%""tX.4} 
xs$3z 
`Hpo`p$W$; ysp 7pxov"x0	D0⾥$$6Ӕ@y~D"0p4hxmx~@ DT 0
 apcB"pxu1xvx}"xux~xvxx}	"xx#xwPyywxx?f`Ӏpxx (X Qu~B@
"00"+000u0 u0 
0 !$0<HRT`  }
0"HD =16/(!a0"0
	070"d0$zQ1¯x1"u TQ""3453/:NP"3554!_Q0"0"xoo`xaT`}ӓxnov+r!3}TOp0@0 0 
Q]P:0 /[P'2 BŨ P`vӟؐ"78 "0a T?2u$408S0"{z}yH237:9
uߒ9 8+
`9709707}@2$hӯ'Ô@]0p4

`$Y	0
	@À{0-$`
$`$p!wa"V K0":0!@À-0
 .  s	 280"
2xofKp0*2d|p08SH{zy xpvJ%_`gK8P2 ( 	y4 {u "pF	~5345q3`	t%5}544r	@ :0	h0"08`	 2oA08< Lr@1@^ 
 !
 +90 B 8, 
jڒ	" "!`BQ
p0( 8!u\ 
+LW
]DU 8.Pj'	20"G+6 &,3'=	f-e2pM9)0	LoP85p
2-y"&0y
/	z	0
£Q":"028;pfpO:5`"/c)P3
%.4Cxn`qe`?0}?Dp h,g,"a,a b}iO"4xMNOpxD Te4`^}V Vp0
T4d`#7"4#?
p~}i4xdW@3 0
3 #F`3`3$`e$`1$p$g$`9$`$`})3{$pvA?T nq2c1[0TxvF>&`!	0,0)$Ф@Dx Z30a 3\PA6P 	@Rp>%¯3Q`` pzTU`xk  NL) .a?xv
xD}S}%0{0^`
}mT?Dt>T`PtY?T@{Smq"@`T`Q	060``$p``1e7`tg7"r((6b)(ူu&0*a a
Td`x0dp#  xF 0TÔP
 )xFttxBBzxNUN{}wxJqJpr:;<t/a>=)x ү!:%$t=t=;2)0 )=$Px`vT"` 2'<x"3y:; 0) ;:@ p0 xvs6ѸxV86}&p p 7  %76'y7  ""88Ô@ p/p0'Ԁ  /..d`
%~r7(TP5O(. 4 >4N04/@O453``/`@$pN54I:I&du*):P [x 
33oppG{+L1>gp1  ':P"T~ ,P2
?T#>үd`pxH 8@2M2P65b3e1@dx7>1/ 
m
`+0xA%30 Bo1
@
 {`00DT@5q0	 39@a AP}Rt
 u2P2btl@
wp.
@	  r1zl0dpe`30DxFU105@2`e bC7xnu30 0u3r2*(t1123#.1}p<0 $32  a<0 }?
1pAR ErpM"pk  d-au*x0,u`2:,]4 2UU.X5%->,'* 2732pha,
$+O!=% *R5 
Q'x`S+0	+_ -R	++@@
@`p7v@}	 `@~A0|y!T``Y_` VWy
7pDxp.\LDy?N%@k5߃3Eop;OCDw-bqXTQQG3: !p	S30/B3dUA`hy%%cOvt0QON@pHR/ N9
d.0
`/X6Fp0X-64F0570`5#Oe0]c6e`	S8@1
!b߂-1ÀI%P.;u1
p<~ u1a1P-<+C{p4PŤz5z5
3z+,yuv {| A, 90 &p n`AT0g ,	alo9pd000 upo6o,/-.rpFB}}0
P/.-rdct%,f Wu tq70YS 8S;"WW4쑔p0BŐ}BT_0=_<I?`$<p:T0Oő78e`pYלBxgTAx`%draz0 } 87>0P$3Pq"W¥A3	``uqq
r	1Q`{0
}
9ȷrdP9$$P6"{ 2F}&e'AChS4Iq}a X@apR`pLxpG3'p?u]1U^I#5_`@TU`#v@|T kx{}Pxzp Vxy TxxPU{xwQxv0Gxuxmxtxaxs`xrxqxxpx`x|Px{`Vxzy@UxxRxw Gxvxmxup&xtPxsxrxxqxxp"<pxkv00,pTxgLү4" .3k0.TxgꀙQg,T_^p0NP .^ ##----i C2
>",u/=212B0T-21Կ^ L-.W 'q,Đ/#=6,T{AO-.`\۷pGJQN.E[.NLJP60p0Y()y0h&
P5
Ps|?`d7]k}SPn,rt=ar[4Ng0 `a2
Еf
p1
P

Q "u- w09r"l  },n1vg8_;,  A3.0Q2O.pM=1s0D@[dT0uǀ`zP;kDS,c,u.B.t` 2 p0`u.Ta1GC
.%TO]лQN]03p	 `` 8a 93b {$ 9)NӔ@6S ? x0!  x560H UQq7prrqxvWU	Xu

		0
  `
6P"q 
G1opTJrAL`>M)60.T`@}~w}S?AP33TBDWD  Axk6"]@t= C9xVxYFdҢX\`T`HTǯ
PMs>@CU!3"x*"U\]@0!Qqڢ97F 03tv`
pUr *J(( (BP_P` qw0P `	qPa"NߋO.eB"TO{EN Є1n`<z<lA<laYpo0:BP e0!J]I$:1VPJ1,F;KF	D0c
^"CO`@"HIOv30aA!Idp`w@0tǣt A2bIAJ``JIxovHI;"xFExGFxEGxFt@0) FT.`xFF0xG@Ft")"F>f 0 G<"xB!C!A!B4/)B*( #NA
OA
MA
NT/I
N+)D
UJaKaIaJ/*iJK
I
cJKL;Md`NPT&` v0uK K@ 
MLtS Q@HKJ}m}t}}{EAMI"?..B Ô@""7  "xf· 7""TxDTpT@ۀp ?~$0k+H:D}@qTTJE}Rp*U@@@@@~@h@V@D@>@8@2@,@????  @B>QJJ" dbr! t/"xbq o "BD)6	0R#q! * 	A] _:qV`R [V$`RAb $AUӔ@fU1OU0	xoZÀ!}aAU`#`5`2$pCxD4SS [CxaUUTӓxns& NYq 
xj0x GÔ@<PTxjBГӔ@`BzYr
T"  Ptjxf0Pav+xnv2P8Put04}tt  }H
!"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTׂATUBRBACp@*F?}Eb ,$zEi0U`Ud`)uURBCCCD
D4D@D]DiD|DDDDDDD BEB-:D 0rtRpA$9 pC¿"-`AE
mPT g"@L0M7 Q&T E7@UxZF!R
hrap>@X P`A@8aO0D=Dd
`#p`(`0<`PdP`d`UێU0:NR^t td	RxtxxXx\x]txat"xbt2xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx x#x> x=tp x@t	p0xTВ
}%xtx"Ttx!TTTaD	x?D}@xTpT =TT	Tx= Q
@TxDHp?=DDTxkv0}Gt UdQ eV`eTeP}S:{"x0xI"xhw/LL"Bn S?/?@>"A7$tO$-"T`Ô
P~0~7%UU eTT7%TT{ z yT`G G+G3H 4H6H7H8H#9H.:H9;H><  HCTY1	 Q$
 I`A 91~5GkT& 8 `;cuTuTK0T"$`($`*`-w/Arp40
T1mB P.GQUQb U T"VPT$```$$`(`7`F$cpH[g	A]@
:3
2  *}006 `:#'/A``,`003`G`[$ap]Tp]"T  dpF{]0$s  `!DࡌTJwwq/!$ Tp U "$pR_PLKQd`0EQxhQÔ PQGZGsq@P
qJPxhv@JdJdJdJdJqJJJJͨJJKK	KKK1KsKxK}KKKKKKKKKKLLLLD  LK0
`2v"xMNO`u{RRRsx`}iO  x6  "$"0RZ?
R:Lp; 5 x"}} HG}0"uS@	0?SSST
pTS0SCSz 0P 0@4xathvaQ `kxTxkoD0FxHxbx"x@$xx"x`}K}UIF	
Q@PM0""3GxT| } ~ qIz4|Q_*NK QRR &NKLn((sLLMMMMMMLLLLMkMqM~MNNN"N:.?0qÔ`P/QHL"T? } >00xe@"QfSQvЙJq0pV	@ݰ50T:buQۀ0{  0q0)	0PS":CmU$p
:!/0Qp,"xdP P0~A3*"~}i 0?HR3AP>2I1bb0M}PE!@JC0E .PPN` Q mT0b`ɑ0N0#0xD oTx0i!1?xxivT 
AAPB11u32}&  $31T3322@"O
0  "'yW "   p}"/)OA0/ÔЧ/pC0S00Oc2
00 "
xp0 "ŢxȰ♎2345%@"!(t?3t 2Ox325R4U5B| 5axQxQD=Qx␖Q  096xS,_@nS, CS&PCPQQ)Q4 R6RRRRS
6x
/0!x
tP/P
߅0/Px
  x
Q{Ox
! %60$t $T &Qxt	}XBxs0xsßP2O0 p%@$X4$ÞPxxs`1 	^1^,-uߨP. <Tү$`& p<OX} @p% B>x.-,6	&xxt?@v $(xsvysxtP!  P&0 	r6
p`xv 6xa`r
0qP 0	,xx
xR!x	06S-)_P$3p 06d2SV S]SgSqSxSST0	Ta
  T{pwgD4 D@ @B@"xDbU$P``3@TOW@"X  ,D "z9NTph`/ԃAE@E +@@CEVtm O@p { 3/3TOB @ /"p<1ß`p}T@`8 -5,, F4pS,  S,`xevS, ?
S,,"+,/0-VböUp"` }2xN JUu0 u1ATxf`-30(Ӕ
P! 23	D3E2MXCSS0S3u2 u42U03U1Np1%1030444 P-5xp7x	410	^_
55-Ӕ@xA1 w X?=60c
`/p00Ӕ@:P0-	`	VVVVVW+WFWaWqWWWWWW$W%X&X+X,X*- ? X/-`:S	X/!xu/}@xEǝP^-.^P
.-0]	
x3/t?e.pt e)-0`0p	3pQ|Bp"	`pEx@}}t*p
.!  2#Pt_B-Qev`  qW} pQ t u vA߀O}	}50R)LA Q!qmp]" 20 ,腿+"_`{Y`PXXXXXXXX	XXXXXYYYY5YY3Y  Y \Y۪\s  S1
tGt)Ʌ|#	
pt%e DoTQWT0BQ
2:ԳP^`p '#pPI<dЉ]P  rgZ `!L0ZtGNt(D:i4rOBkQ
xaﲌ)SP`KDQT,T
qMA#_ "gD `C - gt .`T/@"À--d`"` 
`-[5.t %-Ue.`.6Ô@aG[4Z.[4%^"Xto.`:``=/U.`"U/`"",pF/R`c_Ô@ OeA
"x
xt "@
u/$ -$U`"xЊ0"5}"ܐ0{5242'   _" \R@2 \\[['\ /\.I\4J\:K\@N\FZ\L[   fpa"xl0/V "0/ BJ16(P1a * "	0k33o%$1_@e2pL2640"0(4d	 !4
4WvaprA	ov"Ô
@"4\Qy!4$`$`2$`B$`J`[$Wpkگ[P c`_QRiD	qv3vD4UA'4p-|}q
pD"_""" ]]]]^ ^$^F^c^^  ^u2#^u22b ! 0;"t行`u2F,!wu2=r1%
C\Qb@%}6r2UUDE.u8
Z/0"עHQ R 0 3A`2"0 "x%0T~t@"Ô@P @@	TŁ7" O@1x~ d `"2ذِ}t0	>1y_!#@x0x!TT`DƏp `T{1!D`1!T1 0;ixDGj"  :	;
/'
123B=>C	D
WX`~x`!OP ^`_c"
%'F`7d0x+ +b2xgf tqa+s+M `C0/+xT 6D } 20h DT_`g rTT`P80	61 _a|`S 
0cx	+$``_`9 A`a|xv pz q DxT"ҎxStTTH_+xS+<x, 6, G`$p#+pxSx+	x060/QIp

0`% ".q@-ӔPq @
rP/-$``C$dp<0/UC.P}.H, @ Oox`@`DlT aP#@`zp}} c C.e. 		 zbB	@ w	$~`E$`M`Q`U`_$ep`. .qî".xĭ dpI0ӀÒ/ q xl..T
"xf._"-.{{ jm"90$"x8" 	ӛ?P	ж Þ`ظd`UÝ@ӛ@*P:;<u ߳t/t֔"/014u5u<$t}5}p/`dnddee*eAeXeXe{e{eđeޒeޓfff$f$fGffg$g$gGgGgghhh&h&hIhIhlhlhhhԱhԲiii6i6iYiYiviviiiiiiiiiijj  jM~O0~%~ p0p& pC3/}u: u; u<3{c4jdT3PW66~ 6` gR3`075u3@u:u;}u<{xu{{X$::;<{&5jhg0  ߶h)g

-RK>,@1E` 
} P0C3+R#~ 0`| }` @^_NR#`##(
"&

R5P)*)Np<Id @(-
c# :111{!7(+(/**81,/,h3/1/5H13G1҇O/]|@T1PR
BA$__TWB1 uU2@'8B=U9='8FUGXCWCUIˈEEL͸GGUo`VII#M0V6hP!}VbhQ"/"qVÔ@πu3//\Cq/4"$y` !SmpPpnzżQ} @@ "@A~K`jPkN$k`T}&A`#0#xt@}}X} Y  ZxqBBxtPBQ0%70$@"Ap
 p"&@AOr+ 	 	Y		Z 
 
[
B_xt		 ߒ":0dx>T=@Q
38Ta]ߋ>?`od l|P?>IIPw0=p7P"08j } P' 8@
ఐ|? $ >Di0
kd Ep6Q"}`~M }pQ l#@@b!0s1Pgې}P@ LT?Tn Yt
#Dp=0P2'+sa++/
~MСʡ2!_$:QIvTl@&ۄp0uo߂q&2 
41omDmz"14PnOu1xe~606
 0ɠ텤60'Qk}e}pp
T?T`4"4}" u2<0n0`~~c^z@0kTODԄ001p322]* u1AD00{ 	3PP08PQ@`2PD=2B32ӷp087hPc`&RP@P}`"aR3"^0pwT_O"1
070% 0p033@,pe0`01?2_Vbe~p0oP3ఊ1!ot10~ W c`JgM9 	1DcS J@T3`02`;:+"45675E4`~54iP
(4`i77$cTo`wMӐ4`TM=`` `'wp->TÈr D D41 i0$CBDf0rV BÔZ	*u
1au0)'O2u0p
1=}}]34Pӝp2u2u0*> $3@P20' ac@u'
L`n12^qEl;8002`BTTT%%Oj9>xEp0>3`D
` 
p	0d`0a18\Q]T?`<@7!?$p*3t~T9)	 #c H@01	a=2`fO"Fc"Mc#NQ$'N&tnݾߪ$	??
o)$	6
??Xu)txdd7eU"}{zy~Wj7udj12u04<tG`u/'GP~ s./dsƕit#\vh~@_[tQrppT0qN`۔L=2ot[	ÔPt}l q䑘o``z45Ӽ@Q/GQk4373  v((swwwwwx(xyyza{|}4}}~p~~~~6	{ z y4k	75P4F w
QhSDT{lSp1
73D,t~5{u4`u5 	]4T`pd`V Ԁ7Q?
p0
PFu	$r	uzLoBmP[|| 쮐ax[}}O pmiiiPK
}
Np&|V$0/餙hiz (
r}67d6 N6@7"PnRPJd0,v e5p4l`&{JAqw!u8*8EU| `z {E` @\o]Lvv8999889p#!#f8`9#
							@45q0|F 3t[c98(d`픜!PD<A-0/* 
E0
jZk<ÐIIP2SU~dLpt@#aM`M8@_ɫ1mpl`T@
`r/@;ňqd?Npt/,V+/XPՏYP\ZNp7@>	bUodppNCWWri?Ҟ/'P#^8/i 4(?dn&pf1 R6r<AFt=JQVv>afx?Mr i`},KD|T-`M09L80,P78+3 7v投3vL"27傐}ך3+P A| 3$`A`ydc $~ 2ࣁu3#ux/7@ dER t8u@`
_Ô|		qAjPt7pz9qTT Np: );4u3touq$xe3`371!`044a wƀYaÀ1 PӅePU31˕axBdAU4͂	pCϑ2"߃Ӄ}`τ2"u0X303} BY%}.3~NW0:>F2pP9u2f	op`8
0𩄑
``vӕ19100ڃxeT`&}$31dtP2"u}߾`q 
0"""4}t t  P
3U02	~LTD"LION x9pHP
 wDT":p
"Ta~? dђ^ ÀӲ  0d"0Ӏñ }7p8`0;@
D 
~Y,T e8"6p 21SHP `H@"x0 5"5q"px 
qvs>q>~ 0uab on`dx"7 u8Xq`g,7bP|  `  Pnp=	84zgk8$bd="89I;u<98~R98lpe; 9E8 `v j@@~+P"~{_
mȡ<0&x33 d ::Ӕ@o:@>x#,	: ,Y=x@A-:WP @8<p5 ;PB
$0\=<>?u@`"H P/A(p??p>?
>`j+@5{5@@	x&Tp/"%T~ O7&@"`"!F"x!To`	TOTp573o`12D"C
xCpx6p>A4ra/T(--,r e,p,,~Qe,`,,|21G:3>d$-t"u;2A&8<9@Ju;;;`/ǔP9:@@l56x>~FM pb?b66V5 5 	d` 
F~G5CPM¯ DAJpO*q+,U
,{, +,@+@_M@T` OFRF$&?^xt
 T0x"T1T4TDx!CD@gp
0g1dpa_23%33+232@
{4k`V4cmN(%%q
O5PZ`a00*OT@eVT		>"TYqc~P` E#Aq""	߿F	 >	@2xpzdPX LҀƀԀi@o3ڀʀ3łŃ 
`	"3/?$ ̈$ P ##EN``#sB"P""):0"P%0 "b``"  )"/33@p " 3@P"Ø"(p p8

r
		
tQ
X
	
u

 ߃*2	1	"yt 
""BBE"""ЃЂP  tsf6 s~$ŃŃ1" "%5pbp~p
s@h`1!p1 1@~1Iv1@n1 b1RV1J1ePe1111 p0p00pW000?#s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         P  J     MESS.wj?v/Oau!U6f#7Vy,HXm
	;	M	\	v										+
;
A
F
K
T
d



@yk
^
n






	!%(08=DKQZcinz!Dh^~=]n
:N 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
602-D ette Boot Reco#rd0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the conts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7A proc has bYeSed ags n@orQCMOS13- s aAby POST 1155BoaComm P6 Assignmlic611-Prima~" Flopp obz2-S nad01W#trol`)y5G%sType+1783'` Q9)	v0C0'Ef& 1	&8	3XP7
~60-Fix"	doe"sup" Blo,Mod117'r[! Aoμ$173_{	DMEA53?5?@5Idp@ify=mmKl4O>	|xParamKr TableWBI>tRXHalpB  52PX[ap5.Invalid elPronic serial numbeV16I/O ROMX3`7KeybA630bF83047@b4cUnitdLoadalWl -\h44aMonochroym`Rl 164iSiz=_
r2rXP%WInst0letworkZrvDAct\Nso &aach16`KoOp1gsʐt^ pg Chec2  PCI BusJ_10-Exn`StoragJevi0sHPnHPFA1spV  Ol4!14Y2%3,3_2Xz## Se(OC?HECK a#@ yl3-Ti`& Da @ X    ~Power-Pass0d	XOK Do y[oullЉa to p~#~s? [Y/N]

AdJ0ia 	R[or!hip8nѓ... (ABO= 'Ctrl +t` Del'18-1@#h: $pHchangedZ2: f*mBqneщq~p0+*3/: VideoRTz-4z:Prrup fX5_i *8]6_an ^Qexpans1bPt  Turn!!Rej`Кfs})<F1>:G Abp
!bq^rmal820UZ mupP#3giDwa,6#+Bk1.(Strg+Un/tbr,I n%Tpf0ow$o$P6 utom`c4updQ,: ۘs ToX miX: KbytBVcksumk,NfauP/kulcnW1Next? ErtiExfȠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu{ 1 MaiAance!c
 Hyt6.<swi@s us0modu+4nme@$+requireAs.  To c.d.% LѣBU7MpibOOay1__2_]re搫excee@ !pӵb1| vCircuvLUnw l!n$dy.L.(. ddoee. U2S_0m"SP   2oI#c5^ InrLShut
downi  `0	-a:1Pe `;PIN: [
] \Na%left+0H1HB@6 Pu`Úo 
v^oax`ˈ`Ӏ,ZbauS UedLзcuRc7hipbeQTEpmJoldNew _ !upu0cF
!be`$Ȣr"-l du<.t!_0#AgJ N[!a
 affmHPma,t0b@mak5xxлunusPVItIong`6en! 
f=]%u0l,Jrec2I`paSAѣF2Fj.ERRORYhQq <!!gonefyBla MIpx (MSGIDX)   D  M   P DSDTDSDTz  HP  nc6200   MSFT[O"\._PR_C000   1
 O_CST p\/_SB2P345`p
1L`
 678p o\/9O9?Aa{ua0 `a I{ 	B
 p
C
  pp
D  EFsq10C ]G@PP1V WWp11p
Uq2y2y2z2qC11 2D
 D y 

BEG  D
]qFIG_
&
0;}9
d\32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 74ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD15phg	gi
 a6g7 phpi p
 fA"'ϓfg`f b 7f cufvbc``A89E
Microsoft Windows ?ME: Millennium Editions NT Cp&AF
3p\_OS_`pga.Sag)`B9ߠ
bra!718ua
 6
 s %[I` 
u	A1h3Q0841A+85_INI AH2C
fpig
f0@i` g@hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\G[K
 :D_HIDAJ	_CRSR E)
&	@M1
  @NN 02
_ C021  +2tD2M20N4C@5py6pB1t$5?EG27% 8 9 A r C"8ۮ([0
D   
,[́D1EF8[
 3031	A
[ہ1 32@33Q 4 5 6A7 _38 39H3A
C@[L3BZ!C"3D'A kEpF_40Q 1`
42 3A4j56 47nA0B 48f49 4ABaCDEjQFPi5k@ 1052Q 3 4  @"55 M,57
@F!hpa47a}aiapa ~ib{abo[N102'
_C _ADR
 [&	8 u_STA0q `=	@9p
1AB5C
T
C[)5C |qr Bo DD0P85Do5DE2qE& @? < A#5F [#C060oK}61Dw`p` p`b`t5DePZe` a}p dpy0cCd{c
z~@u
 bdx66Fbbtd
qpu@2dcrd[5E` dza
ga@b{
N afuff a@Pdu`['A
Ja
P64L

 G
aE7w `EyH d2?y '%6p}
3 3[`60 066pibpkdrd
edA
d hb @brb

bhb7  892ja67S3 8K68crc169BbN0!A!w{ar`j64abP]	bR][]
]
bu]atb
[bP c`^a%
`bac `/$6BSPSK] [64
67 @~69c)!kc6CP=aaqp``\6C@23~_S3D
=p 4D
 f`L6 fS< W

X6EX @4[ p3F [C0{70%@ 
"@`71
K71a@{^.h2BA0FDQ3F@[B:AH c74
`
[T74@75 6 ^7^79AW7AW7C.T7DAG7Pq F g80 Up 18!^8!^84 5A\86F#87w H88 l?89

d19@8Aj8B 
<[=   @CnD 8EkFA9@  g91 9Am09q93`
[0 47	 A95P
aT96  P9	D@98
9$
99AJ9!
!
pW9!
f9C g~0AgqD3E
g[! FA0Q 1 aA3GA4[#\_GL_bp
`{ʔ[!
dv`J`Am1aA2{h ͺjp
ps
Hr ӧ`"a0A3bra[Jp	rya
c}cbaa5 (8` A6x0 wA7Bωhiۢq`y`j0OЧA8
h!4: p3"3+1a(86V1(@pwA9qip@"m8 +FGbA
i7.F5D1&Ӡ$rE2}}jr6[GG@ @:*BAB
@
[+l PAC0ADQ E @$$B0|06B1 CB2
A`qD`C[ix
	0  zo{` `za 0 
bw
t
	rabmC
 11
A )RۊU{0!rv"OL!3
pI6'BB4
y
rmw iPH2AF`!B1a{P ` 
p{z1 wi1{wa` rbB3b yC15	_D`pAFw
h nc }r    AA3
ccF@B6
7l
PB7 !8 ! tP*e {ky
r B7e} e Aj
8a{`Yц0.xq9@p #`b}e
e/rp !`ؽ	e z`e$}`@@dAy4{ks
 	``;}qE
 ЈAwE y~!-Ep?d1p6Cd pAC"D D7e@{BAq0fB D dyce@
QTѢ"Chif"f
j
B@
EbdB	!ba'c@z!Dby
PMT6*CTHPCIBb+(p`Ab	s@bF/cpyacaAFw'B0j`B0b1e  dBb[FBGGGG1@DBEU 7#BF
@BCC1-_PSW12ڡCCYC1 (!`A1[(ІC 4c	C5uVm	Vo	o	o	o	o	o	i	6 Rc	o	o	o	o	o	o	`7u-ҙo	o	o	o	o	o	$N!%[M 9cP#xB#cCC33".
[@   /@C@&P
[5   zDKց 1DD3 OлD4  0D5pD63D7 @~  PD8OT 9@92oQ
 U0D=:
c	A
 d B 0DCDDA!D?*/D(D//.E0 & //e!e!( .G!G!@(C E1N "E2G E2//.3
@ #'3//A eA !A N A  GA "A  "$sW0*n0#5(5//*N 6`03G 6//@a0%1a0%1a0n0 a0G1a0G1a0@1BES  JH E8	E9	
#  yS  EaSи``
퀀`p`apa!E90EC	@	V}`Q	``[ED` a' 4E	 4Fq С	A`]v[ODHIDA_UID
`|EC^^03
5!_DISEDx)_wSRSEEh__CRS8HXa6 r)$_+b!7r)4 ;c18r)XC F0M hA 9r) U[(iQ(A r)$$@k0ja0Br )4p{8	kq8Cr)7  4>91[!aV?8A2[F51F6
r 7
 <$8 [=#"GE Fu[V@KF59v1(W EE,C05Az͕F,Ѿ 0F{C D
LDE _S3WD
p 4p FFؠ({C1_00
 h2{4C ` UBX1cDCZKP2
@!4E`
{i}`h`{`h@4E{i  @ B$ q\._SB_3tB~ o._DOSq	A7
` a!ߠ[^4b>b ha[7 
ckDCYFF
 GZ SS
h̀˚rRp *r&R%$ 

 
h 9E	8hfp
` {\/002Sn0A
Pt1`90D _ Q =  P Chi88`'
hA@ \\8\/	F4 Y8 p]9|9Ha{-+A
 i 78hj	 9hijCqBc.5m?5h97s 6 5p
Л98Fr94s 1! F)C
^/p´0kl3V+D pA`=a{` 4aoa03 נQ	_G+PE 	
  M
Gb }bGf f@y I10EI1i0Џ0!1P<# 1 2

p`3145`
`6/_REG(pipp1A
 a	ia117[A  @@p!18p@419p # A!B)CADEF2@121&22 3m24P.25Q 6 7s 8c92AB^C DEFP30Q 1\ и133A4u5R337{3819 mAs B@/3C3EF C1k408442 i3 q4q465718349Q 
+4B4 Q4E  F_INI >50 ap  !52[   Iް3 @Y54:5	wh
@axa
db`t
@`TP
a
з@}a*
y`}`aѺ@8P6] azw`
d`xr`
  
@bau."7r*r&q`q+68	<h3
9
As B
C
a`E 060c
q Za262R3
Unknown 
NiMH 
LiIo_n N85
+62`}>qB@l 65B!62o
y1
AU5C
a
qDq137B52Dk5D@ #`>aυ}5Ba{a
^45B}Qޠ>59!
 
 cQA|!A!ADq164	0ՐցSP tAEQ65	PGp
 D{` I=66
[)h`pF4`
csc
  dzir`a[)absdb1/2*( cocC 7	hg3
r65g
2tU9)62{`eg %8P%9hq,C *23a7 aAh 1 12A ww60axra
c 
dcbpbb-V611r	3C`a Da$(`a࢔->9g90I03B
I+Ep_
 }W 	ip
$q:/A9"2Dc.Fc31 cCP05
{@``	{`G`IF@5Dx;4  9RL2ccdp eeez
c?pecpciA%4?w up
l60p
I%1`p
`Q60oљ25C-LDT@+q~N)@21Q-  T(
!z>
>6(P2pzat
 5[u%*!7(B+BCpF`*qxe(a9h)0ւ30	54Bata
ai
b0zchD!
б

6Eaap38
@ ra 9PQ pa*upaHf:bTaAh68U
8>BUB2;2QC@R=3Uc3r?44 [
6sA
HP   aP3E
Sp
SIMPLO0~SMp
MOTOROLA }a`w`wF6F
p
p 
|Aj(_Q03':Q{Bb񪰪B4u13bcp
az42
ba:5TZ@70 1['cTZ3-_J
6pn
J  naR72
VPR101A 
 1_2 N8:Et# Q
B`_4*#9nO1169_3316

{,1
{ (i283i$ʐS[cH0
76
NԱ @VA78бF 70m7@  79A! q C|"D F0#!7F88182s 3 4Q886187
[k  њ88Q98AB8C88ElP y8F҆8CUaC1900A
8CMV`91QFrҚa` 7F`
 80@>@
 p90Opi9293rA 8!cA2b1c3yg4b pa3B6c193yya
 "d
b{
 bdpdS c
 c
Нcؠ1B`94 8Fp`kaPΕa
v2C albab`b
vbyb7Eq82p`E81'9q !4#!c80zj
a53W90=P5#'7Dqbb	˓aq bۤb968Fj9B7C 6`7
796" B6"b|
A8
{C0@a`{  ia` ` 91hp!
`!Ka)9	+C)hA20$b cvU0CabcA@'K9A p^^/BcIX9CL91
!+D

Gy 1Q9F4  A92/ "9FdCrD[A;A1F_C  _DDN
oCOM1A2A36
30Uw"    }8y `NS  A3__STA  A
`Q8
 ,+_DIS h03Dd3A
F_SRSl Vh
a4PP`A4r o)rA2@
_C
wE

` `c

n @BA[fA?5   
@6
_ON_B7_OFFPR05[LgA6CeM6C
_G 0" *
W~S)![ 8 y2K
@>A7 @|A88^,o/pqA464AX
I A * 
 	 AC
r
;`/!)7!C"s"8x""u"4C#2c[Dm$i$!P%`$ $D[C:`GE0=0AF}p`  0= B0
."@-95zB>BmBшB1uGH
1 Gxx&xxg"q)x)xxJo Ko r^r_ _u\QQB1QP@n%JQQ415Q1QN?3?303<RPV3rRns1Gm3 *do3dSb pB244pB34?V4V55 X5uvxcp
,] B30pr188!]B4=]75]0]&2]q40qqX:B4)%B5 p\Y/0sau02 33w(`{fx  @z[O@=dd$5QBP` ,`?!B9  (BBv
G``Gpp 2+2CA
DB`2eBB8B8BC[5%@ID#~ ^"  y sE؀w@ @ "-[@A8
 
 tPz
     *"QFtba a !-C1C05
0 p Gr r " ` `0Gd d"l[IC}2
" 0:C[0")
UC3aҘ aC3C4y&O.    > [+ 3@
   
 
@DDC06`gC0ADR   !oC7
@[)C78 БINI	8[C9uAADC072[@QB-ag {38Ba =r:}d%BB
=PRW
	
[N07"#|u!C>\/6C0D0["

 C3C09C`{`CFGPE@+DJ0F8 p[c_L1A`D
p57
P0PP1#
@q0@C7?	_RMV P*_EJD @3B.!MP C6Q  m3 CFPD0< D p/Q+4 *qa'
CdC0Bt
7S3DBr 4p .tOa-N



H (A_DEEd311	$PM$
		B		P				G0)Ac1D 70-ЫDC"PODe#E*N_GTM p
8 `Ɋ@"F E0 E1E2 mE3p 5AE3{A  r0
D0E07%u10D
 
P1
P
p
uxpE2}ơ3C@E1Rq2E `E2C`[MhT
hT
hT
hT
hS
Fi  `p
w0  a:` PA` bwb
bw`
cib 7ac  rbP [rc u`6abA2cE5bca:66} !{ f3I 3bL-A##M
Qjoomjfjo@ckoaEaPEv[ ,F DDRB*t3yQ
_PSq ` 3 O2	KCX9Aa	
# i A:BODCODDOF0OF1OF2LPh9@\_PICжhB\/jD9{M`T Me9E

Q0jQ5   1`
C#E@ H) 

 HGC

A 
	
Qa 
		Q FpS!	A	
a	5!58# "cB%6(!!! Q 3c !tt!!G !Aap]6A@	F
!R  pd
d
Primary 
10  
LIon 
Hewlett-Packard EyTraveloka	9x?@ 8-5Cѩ67	^0067h`/`p?%
 
}
" 
 
]6AhaEAAABA{1 Q axA"p B7ha`9hP7 
_UI sO5
_BI^Q  ST  CL{\qb[G;6 `)4`8d rdA
 ˃
ACPI3	NgR/a005`K 5C $LP07AeEa&Q_PR0pP 87`rE[:tМ
pLIDS90A0Q"4
	/15?@SXr#~N5j2E EF F0 a
`ukwk`Ah`piaFa?F2 a{`
y gs }a竡ap`k
  {pap  @W !0 4 1  %F20v rv

@  `x `2W`pzhp}
yjp  '>qҘ1 h)h`Ѱ!	` ibйpbasabcpcau`a[.F3<F4! b  5{A<6i3F7 ГF8 Qy9 FA	Æ4   p
o`
2 P   r
` aB CAeqe[0wre
 
D!DU;30p_FAILp0`pD)F7SECUp {AMeA8A59^(EbKwrF}20U0r1]u2-3l1P
cp 3cOp
V
2U4
	5

U67fH2Ga` aF4t 4	G!8209120IABC9
rDEԿF4b!  u..S7IMW1@21gT1__%OQ)bH*JT7a>0=Ԑ `ԠPASS3"Q15W1aOQNp{A `p׿52ap	! 7a54K@RdsL;p2PCw7abbaO b ubrN>P15 Hh<piK3k#M4M5/F3
lsDq 3 Q5aWDG?
<4_c,E=DAAyB{M4C~ !f )ABWMAA~ F6ij=qDt1Z[rp{CpiD3{h
`?04Ah,` B`~04O21j5A
u^ P8 GLp!>
 
,~9C22mQ#<0`T0V3C
10(
`;{ωCA 
$28	QC	KqDw2X?!h^RDh	P)Z 6
1/;!m 7A[! !`a57!&AM 158-hJJ7
7;$` 

p
1(q(Cep
obC+4D5, C%-ГĖl?	p
_\
p
_3O6p
o
)--7T!a-6%
h-7/)F%KO`P0?=9aT Юm) p;)!0M_WEDsVT΀OQl4VSaVAUr 52s3WQABNFOM@O  h:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'a^2]8O.m (.ܣ?! vB `G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=X|gMsb31/~[A70x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC z--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[8p03[18l[#\_GL_yh
 1[piapj"k 055\C0F4hA5`	l['['`[@9

O[ PA[BC bDEC228>Cph+CBB02C0aAp{zh
  BEh7	ޤ D9 C231Di	
*D2C;E	P[Eq衯23536 7 89 A|0q3B @	C r2E Q3D3C
[ E@(A@3F!40 h
40@ 41 2 0~041UyA
	`rh``v!F33E`иcdaJac
pprd b}y baya
a0apac eraye
	 evepe7c ucdcM
 @cpc  bpbgC	bdp apbe)ec e ffg
fape`pfafgvdueA`b7` gTb 	`	$b pg1Fagg7agubdM 5,060 ,0p`!p0`c+`bQ8 9` u`py6 61   "h 7h H
bhc [`r 3ca9da
e,3A-ad?ft`f	r}u'adSuc2f;td gr&:`4bA nQ46 F3BFQ-EF1445`Q&AaqD3Ba
_IN}I46B6pibhb,7p0<47rb
D8
j189"99"bF@1A w6
arC01Eabpb.0+bab`babu>aaP `bua/_CRSQBnQ1E`v2-A`T`_STA t
{`}``6=9XD!

	     y q3B `[K\/24CmHH
Y4DF
RGGP   @ o   s3	0	  1	p4D[C\/003 IF}Q [19BF
rG G$ $ GN N 
P P Gc c Ge e g gt t    P A-o\/[	B6a


W!9p
`q ^^.C175A\_S0_
) !  3    4  5   M\_PTSph%_3CHh
 Lߒh
}	00_4C164`Zb1E6 AA$\_WAK1 } 47G14`
00EQ` 8@6@ppTZu51 TZ1_
 2 :zA1A
a^C
p4@35bQ2

O3acbcc:c72
1:PR1:0p: 
 abw5Cj5AA?C1DC
 `?0B +C5.6N7n8
 {,L\!P52G,
6

0Qnh

b [M
p3/54
	50EP"w6

7
Dpq90YQBC:%D EQ2W FО@?0pT171
5C260
1({!h 9! ;53ii]Gi61
зp
'4$R``Epi_Rdp	D2
hi@w
`pi`?`
p
rg#ip`OBBp63@`phah.Aw5Eihr@
!! # 4i ` a 6fG3
;M i`N1`9pK|J?Qp\R
   qqt$
axa

`b+j0A4

bts
 2

	P
!
 $/L &5_	FP #YdpGdA(1[p{48){b
 t bbwb

araqMpLa/]&]10b`OQi4B`a)a;R#Ch 11$D$ 0ży
h7I{	{a8b  a=pI'h@ ax`%  85B<'`,3Ac$DQ0?6`h{h3_
Gb Ac'pM66
0*h `t`&`x`f0f9{StfQf 1tq"+cbbS+b&8!6bbߠFiq

ep
d
pJM d&`2d/*3e0iYy({{,4	B*aYaBa[ۄM67rU
$/_ON_@B!>H^ 1R_OFF2@8
rbY\Q
	9	
	ЙR^Q	
A
nBcQ
[6BB&3 0.67G["kwDHE8CD ņ9EA[HA_ALBr 1AL2	AL3C
E_AC0 "1&B2F b38fPPSVЎSLAGamF@fBAs=(BVf3C4}pQA55p
!{p
,57$Z7SQQ6_TSP
dp C(,q  'TЏ0/TMPp6`0/[G qP 71

,"3 ̱/$QH\_GPE!
2"O
_OL00 ol`lZBPn <pOI{` ֠{`
`a &B`jP 0o3Ӆa \aJBE 1 C	{6DF !C{6C0D0$ n}AD1+c
@ O["90pIO	C	B	IDEO	eO	_1["
d[DP34_I9 HOHO3*_:oo6rS@/o3B,I6YRCSDOEK
_L17 &88?`} 8@8p-0U7`8BL5P*A
C21܀u1F`o1 
89G_D 74 1
dA` EB =?F0A`E/073Zu.qMC'`? |&%RBB MC5ID`ܾ"S:\q!4?Y6ao88GDMF`UF]
_'00"""`
`
L"`a:@K!-	x5 y6C1C੡319C! 18L_07
I
Q/) )}n_909?09aa`t 	bc.Pm Ǡ'?" v{a2sccM[ 7 ~q-
[ v`8a)?5
q88~Rp4ˁ34N
a85hdCq,u0k78`_`	~Q.ApPբHc
6Q #
			v3cv}bCV/A'	0\P\1h77Jq3BhfCw8 C01A
ȅUa-.7цSSDTqHP  HPQPpc  MS7FT L409@	71   3    #__T	_w 
_	OAwj
ara
a39a`BP]C'B@ij'C  Ah6Q33ڄwR34 27D_27E!.DD<1$ סJ536yj
7084`fj9pծV2`tYapb_b`h79a bub 6C228\ҹq}21Dйh EҹE31rCy2 80,
b+ 1 y U  V!1'*[A04PD?C{hʱ82PCT p`8281q 0	_PPC  Sa7Fԑ7Ya7NLP7Ϙ7_EJ00CCpPxAQpђ _      	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n     ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ          VIDEU[0  @ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`. aP b  cH dP e  fb gP h  i|o jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0 
b3 _DATA_BLOCK x  
`3412Intel(r)915GM/910ML` 5MS а Accelerated S
Build Number: q Deva	09/27/2004  Q01:16
DECOMPILATION OR DISASSEMBLY PROH?IBITEDCopyright (C) 0-`3 2`rp. All RAs ReservsedPa@  g  $	

 ! 	TV׾D "LFPiz(      | 02468:<@BDFHJLPRTVXZ\ 9{   (  8  [0 _ @ Ā ( e/ `ࣀ _   ӕ@DԄHLB  p_ ! !Ԓ        0܂ 17 3		 ޽ @>   H `  |  `] =  # 1" $ (
 5 V}          A !  R`SI-1362-!Up _2  @i7 <cU
 x 
	 Z (?-  	Q    e	>N Ia(  QVSC dS?4O  
`	 w7 c<  \* 
ZcTZcu$M
 23 ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*!P @ X  ' 0hPR	 `"c6 X  1X (a$n!7C	d @A &066\ <0* Q 0@0p
wxx Q@ϯ(/x?Q&@X!k @H?@0b2@@
|/d  P 
00 d  @
%,@`@	Ƃ
)(<p#%%%
 PB. $< 00C"2/<@PpQX 82

,{ +a ?L  Xo o o o o ,4 Z  UfPfVfWfVtRu.t
fF䠆   w FF\  耹*FXF <uY=?}Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^~pZffq_f^f !;F}Nn߈^f~of~`.sf~ t$:V^:nQ:ND~tPfFtF;u )  
f~v ø t2:~sPv0v^*fދfV2fX]P!Rf3ffZfXþ   
@|   @M` +sw.2 t 
؃p.	 
 
f.aИVW6 tM r/u*B
 tVff" v f..L^߲ .pff^3_^28ev t&B1t1U
PSRV<v
W_2G$fWb  < t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufRe.u5 P.f
fZ
fVPf!0% `= `Xf^2dfP r  mf D 耈f ;r;r.T" 6f"2P#ESfQ@tfY-ffXz@G=-fS fYf.; r$ )[fVlu跦8u p+^`@H b,VW7u%f-2f1/O%1f^b,t$5&-rp%ufÂ 1fQf"s UP/ffXu
RJ8Zsfn5b1J7uf-qB7c1q9J1, >1AJQ9[Q,tt22<6	<"tR7Zr.
 @) j7Zs b	4.#_tu
 `, *az@f ` }uVu0f'}0 0"P.0nroooopept<wwyzi{
||}{!' < .  @[ &a[(8)8U!a*d!e!f%g<#h?!$P!fWU.64eހs u.Hw.p p=Ou
uοFa=_ i %)6I=OuFt=Ot=_t
=OtPfIXOuF
_u pt n)]XZ-.<t.:u.T!_F`.a   .aPw2143  p;%(VFE ^(p 
Oq  @=,. f@-"-u
/-F t߰ f#00.fB,fP*# I"7 n.tJf4%90h,fF$ 6+6u 2c0Sf[ u	uN I$Vp !"%"P""""	#
# Ǿ!%A!-(u, xR-̿rkPPt(0.u\
?
^qP9 2ۄt_q  P'1\wSfr/w*]'u{+`	,s`!+
"	Trq&s
!bt&S
[t t fM,ru%B_		l?s
B0(f"Q(*fR*P$8X$@
؉b1	f`2e(qQ	ؾf#.8u@rin#uc]3ZR,pU
 )  [_+a   ufj) + ff_UQA3+M*޴Y+dZ+4+!cuw'+pzkr{`q
W+faPSQmQ	2;YtlQ
 srYTZAQDtp^Ű@t@uY*Y_"utH/r.D$tt	Æf^ZY[~Sv w/u#
 u3 /-"ba@   0@1ʊ7 
[`}.tN0˶V uf`.VPQX	.r0 k%.8tYX^r
gf&⢊f_C	f`	s	qt!рtSR0Z[633xu0KbP<='$ {?p)|$'[ ?^X!&+&U$t Whw.QYS.L2.pe
QPfY
8Xt+$YI~Ц+.W tG#t
2tPS#[;¿Xu)&t0uq

uPSϊߋYSQY[r[o/(cQRvPu8ك zALtS=[rt  p#M2,,`U 0#;˯ qF
1Gs 0
p ѰRB	&Ыx$fS :8!ux'%PQ`UL%<vYX%r2%P PO`w% #`vX%	#XTw#@#G.&6
?";a`mzQ4
81w?0YGpoò_&@?XrPu(s#}0 ѩz Wf_ V.4.tf^0^0ѱ m0/D! fs'$t#f%@ }8ue? u̲t,rE,s@t9@ ̀C~ &Zf*ɿ3fK
f^	 f0ڸQ4,ry0S̃>|c ?e%YE# t3!iakʺT%V1`QXw

SX$w
؊"3Ҩ 8
?.[ *o+++;,_,p,,,	,*R{h"u\uS"u@$#P"BtPPP!(#fSf[A!#Xa0tX"dab!$u  Q.20;YrWot  !fP$ff ff3g&fGy#f^%T2#QB #Yӯ|8@!8##p ѱ2U z 0 c r	g Uw	t .:\s^\0W*.$tBuIP⢛  ^Xu,.8 #.t/s!P~//XSB#[dĀt
 Sg+r!0ÿ
"ff" H'`k&r7
f^&E$x $ 4.{
f+أ20t2p/fPWvPJ	&!QPYP4,̠4!2P`V CΦ! T !F C9%$t`u@uUtQ!2I's#f w<fQ%yxfYvt&w_u!C;Ht Q>..Ͷ.G$ r
Q2Srs[Yr
rL rQjY߂\PPtª<v>rs	 hPfWjrZ, . u.Mpm2ft!"SQP2~Y8[r2QA÷sYf_XSWJ_H_[drFsr?
D
t+8t$P`ՊX8udѡȱ`ʰ8px3
a >i	dA0`@4C&f ¢I]Еu{1
&&Ks"*f4pp끃 tހ hut
ъ-4Pb$
u$XB	X[	3`1
>J~U^ FVv
nB]FPW s&!Gt8uXuD>L t=+pMs4
й @B8e tC:er3vD6e3UX?&2VS2.6e3RF8r *[Y22@]F]W.>>et>Àt&}&t2,(-)*.)` O4eÿ~<v<t
ц<vєÜȫP 3bN<w<?t0f`u2e*s
2&J&P &L&ģ`&&pK L`  a3 43333
33344454
sIuM@B? &<w
2RtE>
tH&38pl
и 7a3۱R u tF@r!tu!WV ^_ 
?GW _uGG zd a `Zj	 QIڃ. `(.[IXuπð/؁YP%@@t	pTF}F!Gpu Y÷sssQS&G&w&_t0B JKu[pr&OP0 &
tuȋcPQV2
$̊
FY^Y0_ s0&G
Pp&?W&w@
p߀?ZotHH,2۰>tr:osr&9p,uh_ 30p?o1 

$0_s'h
 4G__.>`;`;^9ëp 0&$F@e;	@su Ǻ ܺ@+o߹  4t<v<tP&X@F20s @&f` P1ftJf &&	7
aTugQc$_<0tqZt2- ku "Eo aE1^X qqyߊѾ7P.8u*f{0 @)z"}aq`A(  `	s63ftft\eU} t$D ut' $dc4 AǀX$1>&0 )1VWS t߃#`IF[_^ rZf fV 2~Ê߹  r:<w40r*%uf21Sf[fPDV@gs05`t*Q.LYt  u
"8ӻu^ZSQ"s	.So[ Yrߊ̀vXq̡PSf #brcŀtʀ tO<ЛrCQoYr?I`PPf;Xr-u f.;vuqw	 `r_aYf@MRVSӆit|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ0e.DYXuP!
~[` 0"`Rf
2f&ffȐX&e&} ]@.Dufѯp0 tR3Zt	pp   t ϐHK%Q Ms, f+VmwP^ 	X^[*0
 ^94S
9B^HQKtE&gE`JE aJ ^oxйLHKDA&< <  I m  @   	 -`pPPд 1-l#PSPS +׀ `3 s<s at< rj7I<S<.97H<r[._{E#[t/u..s߃l6&=	r	;v1SSߊWм|@*t
 #u[[_[ø RvvvZvxЖnQrg  0K YPVPV<v	w rL^ r WffP@X2A5?$_@lsPDl

f*2L<w 7PEXffsfB fߋ^
`p
f?3f;w<<R i.8ab.<usv@C pQ2<v+<t'<v! tƐtN"DS_polQf
QPX@. p
.&R Qs] P;sf0  w| YrVgI^w
PZfXuEu$Pu
$0VW#sB d @&|&\CrwP#
Xu Ѻ	 Z0
 u^C7
f ts    	

#
Fr=.t 35W`@`8u
X@P@_2.@S6&[X<`r<qwRZP$<pw s2S#(S[2ۀvESp%RffZ{fp 
[pmP =.c?fY.1snfARm	Ca@?0xa,0Rb#MQN[sSuNqz5u߸ `2,"y:.F+o9sau\Uص÷ zMي3
x`@!2 g80"
Xr+5}r 45uUǋz% 2BVP3Q^5 M3
N] `WP1PS ^@0[HF`ۋY.6~VWRr;~s8 ~JuZ_^N t0S[_`\w
Đ2110CVz 
  j2r@p  _2Ph@ & PX60"2P	X uA0`2RߋZ !Pç[ ؆! PX PҪ C"	ƀu̀_<$
2`aesUDtMrEWfV.4.tc.TP&} _w(&
&Ut.9
u.9UuA>fQs^r
\/ r"DfPP@XÀPˀ  V"E`fa[f.Vf&f!u
$'tPAf%`b:ahq`5j#t
^tXqtftY
0t'u-`C1ȵqZڀ \`^PreFc4ܩPdpЯ @pS P P ?J	Ӣ&/	&  u"A#P
	tAfXf^r s  r߀tХ̀_u
_ma<XQVW_^YS. 	sK;pM`0a@s  Cy B jVS3۬
t
<a|<zw$C`^#V    A 72PP2@it.:u23PV .^f.<Inteu   	  
 	 RaPa C` PB BA B;rXa~s  .oH@uSb@ uP4[.oHBar+ 6  ;`&  f}8f%f;19RC}`VPMp 3f.f
`+؀nҖfAJ\ Iu	fSff@ܰP/]sPa 3{WI pWI^YRA.WI0PRf6 0.df 
00.DPR.ff.V` I .FFMȋF 
tJHa?  ׉FACFARR A䀀V@`*
  )]!9p#~1_$<AP-<uX.>Jt  +.J< P.tfcARtsZf²Ĳeg|ۀt5r	?Hr2dR]ۀt¥ `.ȃ v(.жuc.<s.tFbf u.t-.5߀ut."pe1
fQ̀Y   @FV *Os`5P@DXe<DG$hZ0kt	jf'`p- _P4=裂DHPbCCot!N`	DM 4Qbb< PrQQbU vhдS+	3TQgQӡs

rRR
RZR   $ bPBB쿊CZQ
Q QQ0_P<fƊ_$f==fffX°"t
p tf0ZYQ Q `  	Qϱq` S{
 tPP첺P q;4P U'$@``` ЖS S2  1dQ$d[$P50aɀS
S` 
  Rf`
 P`P @8ftsrg Z UdPҩ ` ğaܟPS""
[XȲ"Cc^p!%!ff6QPAQ﵀`  PA%
  wfS%f%PŀrЌ}P tn%2'ff)f#ff#fSahfA(-S-('RA'@u_ fP('fXӋ##[u9X.=          @     @QSr|wrwKH؂n1 V ;v7 xֿZ+q+±2\\sRfZf+`faf GU`F FFP.8\uE.T;u2	u	Ff$ f"uPfVe.  ^0!

uC⦾DD?  + оA<u /f^a]|s(1F3Pprif^@=wA@_`SRWVPtCO	r<.|t4.Et"0t.\Q" YsÀtǀP^_Z`UЎ Qs"0f&;u Eu&M]p ArA	ȋ+;r1;r-fQ&
 8;nfYuaSR sZ[.6P.8u.| P.;6PrSRVWr;u6wb	M1 	_;^ZV3St Uu2
^`WV_rGf^u4t@u&u!SQRP XZY[s`^_X@0`Q  qQ{,U .8utPYf$ADDfIN30 (>Et_'WuA &Ѕ1/f^T4r$/<t<R?r~f&?E   3@zG$<<<f RVr
.|!!^`Ȏ؎ `# t8.D;..\f^t@ 

sV! 
r.PP

]aÿ`'r~yRӊP` X Zun1tQtLM4s@Ass45s
7=v<?Wf_JJ^uS6BЅЅ<}P't0BN-C.
t<2,!+t.
,G<|`$QET:< PW4 ht@YV]6ϋ6`1PVH9""bZl@#u;ndWfA6fQ6PrUwP2B#u[< mk EZXYv]_֊|PǿXt	+t8 o  d %-|Ph%pM  := f^Vr+;t"s	Eu
< u	f3@h3[pt#|=p@fpQwJSAH[8 rQZYs
R sf=RDZtr$|qC}Kr. u)"XбbtkLUsqPSQfVQ  rٰ6.&:
Qyf tFf^Ya`s%(T?sHQwf ݽ3꾝0QѓsxuK= w4 w.HKPPιaUZ;v| Q+tN z[[[[ twǾT[`P÷ p  wf~%L t@ffRZXQ`;v
t
 
 
" p0ƒ΀wWRZsNp/p  .:?u0.>`(bJ pZu.n2`Ґ0 
30;} .	fv?fQ
P pZ
@JZyyۑHp	iAZ3f
 ?Q1VWfǀvf`K1ZP	-ހrs$DV)`) ! 	
PSfVPMrA!$@uc] .@^PPPPPPPP P!P$P%PSwf3]˶a0!{Ct3`
ނ(ZAt2 2h2ۨ#?qfq 8 !)} s@PWvijRfZP[tuU  updsEjtz Rs3 @	<wPpXs uPF !Gb'_1G G
t$ 1C ]#;tt|AqjFGo R*N_@uNQIM_____``@sþ_-FF3F۴ 6.:註Q0Y 024/sR Zk>B p!K2^@7 V```aaFaaa
4`~2C<vSƋ[tq&fa/ q'@'fk^@T#t,x
<pŰgĊ~,+ ,2s2Su; xx |s Z þ/.0p Ϳ ȉNcfCp7: c0Y ;f P(fu _t7f<) i!ff f4Af% ;WF  Àu#\"dnR \gQ-00
Őh*ab_bpbae@ Wf_fVBE/fFP﫰zA
@C1r0f« f ff+À fG
f p	4
zqf# $0-p8u2uA\4 c/ctr ޾ 2SE4
/Zs
 u6@$ .(vӀ۶vu
RSpڷQ[Zb[S 3ɶ6u6F #Q5$d"i@ PQRVtHc.? pVP<	觧r`9f t4W_s)v!f&y=&} u &G
aÝ`SasSRZ q{3ҋʰgrU]deddF5
s;pw S.)d[,JP@t  5r=$ ? r@o{:Hp?7
cr" ^N2$1`8t\tCf	gtwAf@btir߰a< tA@CӴ1a[PMIDn_    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS  Cor;poion#~ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq  5  0  2   fg;iiiii7j<k	kn/daM`bf .<t.:utOFûE2&+]OuMWPESAP Ÿ@efefP@fXfQv4F@;t/aQ@wetf s tfffYfS_uV f&E-  ߃aXðQ .V@Ύ޾eJ  @e suVoO$ G֨_  u к a^@ @`^֠ ^_n_ի o p﫸pՊwfۊơ ܀rf
P rf@@f2tm?QRf`af3ZY 
LՁ
Պu9
mr;g$:Iͤr	 {@p`O%nN}ӏͰLrf
VÀ>Ivm@wdtYw@t$;wR?$;v@fc1q t@~`3xcjjcjjjjkRۃ`܀  )j.$fat*R`@	蠟ZP	XfN Hߓ ~


F wf f` ta f{I | B0a~"_ $y+Ca6ӀtE#>âw1gia% _ftԛt)vGwAºBffP S ǯBB젡T 
RVIӋ_ݺ P!=ݰvp,8 t3
9P%ҀsZ2fQfBQP
fT0fYR CIR[:Tt` uZP̃XVD u.fD
f=8w"Њf`IR VfZ	[D^ÿf0.E.e! *$P	P0
 +$pE0	f .4e{ fڐ	߀8u{$?
!32IBߨu	pVr
.
 @?$
ÑߨaV.|^쁓"2f^PP>} t"tt+t.D/@t au V^r
ޠ
2^< <#t2 <"t
+ <!t  Q`u7
0Q2ъȀ
ufPqu;pusY@>݋иO O sOYˀ u3u"*D\讬u> &p`uu t kudu^sY8s
tQG8s8s8t3 t-0vv&8swˊ
r*ˋc
qP8bu J NذrPÆ2/ۋ<q`R
tB@a1p@2$b&LN @<v0	r	e狕P鑘쿉F ^Sr{Bgtw%gvk&J`֋&FЋsBuՃdr' wP酓zu$0<0 t**F 
t*02P ؊֡	a>`w@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQWw_YuCW B~~	2@
2@PP *ڀ n@
  toʋ?XZQ2	/ ++(+t؋X:  + 
"a݁{BtG:#sNOFGuxsOG$	B y*2n10>K , !?+ 'k'ȋP&1u'D`'$4$p&z  %2C3, B"pCR S w؎
]ȑ'Jur&^=ց3Ju=>wP67)4&	55Fb1QZ6c5 XqJrv
t-r^ <G!M`sw r
&XtR٭נQqQ0QP2GtB2E tO FƮS ƯPЎȎ~ 0u.&>| t
$𻋄c-0@ȱ\/,ppRC&PD+(2 _6t
0su@a#Pb0 2&<u2ۭypWËUƋ0t
Ju]+
]Q wLwPaz x͋Y$r!v$$:ˀu　?600Ql$$s$guz
o׫3*48*0*^OFH,G}`/$ְ /Ë?*) j
y$6| 62 u>
xĪm?í&0  &0%Ê)"r>^!Mu0+,GY3,+K'B2Nğu9@ZZVWѤ ts
҃_^GMu۸ ]3@ø&C$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>fo߀  
T fR@
 F$
 r7uɊ PW.>eu>&}JPbQǪ_XwLԸoǀr#Yts-" (&"%
Ī&#Z
rɀ\sي
u7!~y@s
x`ALuͿ1x  w 
pd!! esX @
ff

W,	0	ϳ2,"yN6@	@	ʸ (⨀Pbr$$pt<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [Dorp^ʊ3?ɸa~0
uVЊdЊPSQRaPaDnXaZWY[X|*v
܀ՈF0F02<}:}C}\}}}	}}}}}~~~&~G~<s<trtt|0ù 2&<F 4w t3&ee!3<
EQ.~T  @@5 ß`P&0y OuËÀ8 0
1>ǀh  fnNËEϊĊNuÿq 2Fó π?} Q ` K#Nu	f&K͉DSRP$?.&\~RP ^ `~[[c   XʊZ[PΊXPvXP) ~~~~l|8 8| <<]<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DD8[p
~~~  Q  	 0``0A$BB$@

V` l$Q  ll  l ||f6j 8L8xz 0 0```0 @ y <<fG00'0  || 8x~ |p <| <l |ƀD |  ~H  a00!2  
x | ff|7ff    bhxhb `·~ @< p flxlf bf  ΰ|`Ư||~Z<ql)Ƃ  88l#<2 xp``x  x -/0 U x|v `` p 60x00x3v|x`lvn 8 1̀b /P7ܢ-T| p| v | q$4-4 /ll3
6|p&0d; (1B 00 # vp?&qp|8B
|!f!&88 `x`:|~~ ~΀)".a0%||`l``p9PH~ w?p

6ff+ 8<}448ll8 6{0` BU6F{ \E|1S6ll6W~` l  "# {U# wA 4T d  6 dP [ 5 NOqP_U1UQ2dt770?dK?0aa66R9j a	
Q R>     tv Q@bC8~llHO3O rg8 s 8||`rTXl( <"CBfa||"|DPh"  l~`l~ Y%r[&; p0jo
G<8p(5ly:}Xl<p&PlN~0QEP< cSld$DtUtZ3ZNTvTu W32xQ|2)
xpbn|ll[|}20ư a4!֕BP{ |`Sl8>70k B @sV &
񉅇R`g#Z8|||8鋊;ff""AR	+p+q`llҒMv	܃od  $5)/ԑ#| 1DVsr  @Pb
1upbᔳ 2ES67
  ц%25R$FPB@S9byA1 `	Q$(f  PC=' # 7%7@Pa "D"%
t@Ý
0l2`6$6~~$E47㠃#
l|8@s3OƆpb#<,00PcRr-0Lu;T 3'$D bZЦe  1d23]%@`aB=`_ ְr;b95Qp$R "ëBfӬ03*Pw~Ry Ap otmeۯk5̓Oh0xӰ`0HH0i ! ah tC[D 0fAxxAcl>j%Uڨ	%SQ#xFΤ W1hPr`xC0q C'7!1^ H(F/`1L!#<0[<\Qj0FespfS_dx0`ܶ=> lܬ>ҚdwD) ew) )ü ut  (Yǳx 7ȥWU> T 4˳ ^S̅d s͢Ͳ5Uc 	&
J TӄK$%҇`Kӧiso
̓@"bRt``0`&"bct "1آ1vetn v ||@<`p`v3 9 tt!K pܶܵ*$1R3Co0`
7| / %4 FU}' 27Whu -7tu #8] /䳔TJ}800% 7]i4&4Eb6 ‸ <Be aְ" 8Fdv D%Eu\fRU 閝\
 5cх ե0&C`e t% EWu % Em  'D~+NWB^ ]Ë
  1 
Met4 G= &tDftt0
"$d #$%e2 3401hK"r5B Vgv	! "f,`G'aw D 	8Fif. GeEt8Bm`lx@-Mo 
/on 	/Oi .Mm +Ok /Im`tܠk$5Fpctq =FTfv||6<] }RRfyѯHU<9ر p>| o` ,4@IXg v!"ť#$0v?ѤƢË5þц&) ~ð 	!S P   1 0 a.Ԝ&6| &>~ ÷
*r
t	2.ò`Ϲ  ~   ц~тє! w<
u&| ϲ 2.^FFF3ҹ `P樸` Ԩ ΨȨ X  * : aQYSظ s2t  [߸{u ic
>ctSÐ/    ^^ >I辙su
^ t 36ȢJ2 Lc&>Iu	B$P
	JX̀v`
p uH-ب <ĩ_tQ @ rw
2F.Ê.̀Nп$F $FF.q( ک _ZUoȨè<w$u 4$
p À0&&_WQ	_@Z<ow?1 A tSD[
*!&VUNq<w4#@tÂ u5Bcb?ȫFt#!)#
 `԰8 u{ 3ҴugĠtb(u]̊.-ŴQYR  
 8 t$8u
;(
=
28u2ɋZ aR23Z%t<vÊ>bSu
PRYNVQ~ċюF&<
vu^Ft&FVRU r̒,]Z:Jr92:6v/RS=b=P [
tZV t^^YuZO[
<t<t<
t<
tx@(` t
t$0<0tur ͉N`u6׆s%&2Ft0 u*ш)s&:s2& #   a     ? t"<(* II `ga!I<v}	.ǫ.﫪tI<tE2<t?<r<v7<	r
<v/<ov)W  WuCt	t`2êSPm@X[$t   ͡ъ$g`Ip
P4
ğ3RQ$2.>euZ&G&Gt R 
 &_Wt%
&;G 
 2    _ @    fPQV fVf.Da 4f^^YfX< !!ȭ14f3f^FFfPfSLqfa#fbff f Qf% ;ëu@[`PSQRQm+YZY[Q Ƞ@YbMfp/Pf.}.7/
CCRRt!Q̀YZ蓟7t&p
t&wG  x    b2
f X蚠=Q3&&Ϭ&I1f P tQ | fYÀVFF30^XtJ՞QF	 DYPRfW#0f "!fP   f3{迀   0K@P sg  ['u_ ^P
Dys-pCR*  CA	  
 f$ wq	y
`F0
!3
y1

f{[X@f_Z) QVV԰?^B*&5%&&&^0 &T@pRV0&$F@&F{誜  PX@F2ܜ q`^ZRDMZ@ h$Āu[Y27V蕛嫊Nu^D7QOC7R虛f<Z4QfV6qf^Y55`4h s4?t47t4\@̗4c464
åQqc22222222RV2B3۾2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              !!!!!! !!     #v1xx">Vz==8f=,=.=d@===H=z===y==BH=0== = ==
=v{f=Y=[=O2%>DU>.P>SQ0!2t$L-`}$Od   : ,ĪaAUc	PCP@P @ UqD"wΗX# ԙ0] 
gh2  ,h	PX^oߵƮ`. fȎ1)`.>f; lf3AHr(|$utD rq  m.6rӄPgTP r   r{Wށ{
 g !^f t-
f&9af&_ M f+W?. T&= tf&m)!_qffaðPfq EQ M y aR $fpf	u(ff(`m}p r} tܰUl pAw<f;%+"l r&;f&_HIBM
fHQf=ؗQ
 r2u&} s
PQS-[  <
QW 
 ftV`^tu{A_Y `VqeB ^
Dƣa&Eǣc\ ;v++\P{=;6as;>crڿqa .qǾ覎ñu6xPt'v %+	@Px N ð  t%u7m!Pfpۯ? @6 S衖[ 虖[ f $ADDIN30,ϺVͻ AIM3b0A  @ X@ Q Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Ef.>_ v `pݺb 0p8fX 2ZY๷2 о0sbuL.;w.;v
RWfVvTtOBf.G} u"Ұu0R j`ZR Zr
`
yf^_fZ fV$< v99fb #Vg}? s1 3LҸq_S fۭVѓ2П[S @t o3ɐRW칀t
_ZP9.$ W4Jv0_ `@n$<u<.\.r   PXfTA2f`1 #`Z`@.&<
UKs....@  "PO߳  5bOukRK6	~f.d..\= rw rL<&]fff.	\. .FG@ P	3@  .G$0<0u.afVf.t2A.Qf;P/uPd H0gZf/^[ ~Q2fuf؃ %	 ͫlqEd34UDpīĳcŝ
D	V  AY DDPU@DSDTY@ " HD|   G? 	  
@  $ 6 d_   IL  J ]B 	 @ , "	eJz ,?,Sg[ 00?	s  i,,


j6Kd@Xkl 
 
PÖ` q@Q@kQm v lC q \ l @AEq@k6
-2-3 A  ``_  3 dj 
=uz 
< FL "Z  L  "oV 
u
 ?E _S   
E 
y 
O 

SZ ߀ MnE(  02<@(@(w<2 3 = < @3`= @<`3w=0; 3 ;1 0 4 >`{; `4@>w ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9  6@?906`? 90@06 (8  7 (`8@7   `07~?7`0r `;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 0=p    
>* *w8 1 g)  @? 7@1`?*)   2 )6@2*)  `2@(v 5  3`w`)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3~ 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0=H`)`' >H )@?X(`$@#a6@-@6-6 -,5~,7@-,@ 7-@,4~-8 .+@ 8 .+ @9@.@+3`*:`. +@3: *  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ @? /`61 1)/)1  `p< < + + `0* `"ú0*  1X (& @A &06DPѐ  ]Ń mP鈱 f%Ѣf=u˷XПP R@efթu= w
`}w6fQWP3܅tf
@@@$	Xr/QYv
wfD f0W_{fؠt
!c@C"A_T2. t.w軇f7?0<1̉@ൣנrWRZ_Sr3F!f%SSpt@f
qTaf+Q2<n܆ `2f2!t&º2"@t f0fXf^q 
fш"[ @:=vL= v^"m@RfP0e
ڠd+3
0ub(  <  wrP+ Sg[0]uB1
j  ! R b r "2B !Rz r [   dteuVfvW V
fq  %"
v
=r 
~ #¿ %B
  #  #{  }& & F $Д e Vf W ظz@ о?ǻǹP0 	߰ǻP`S8t< u	[X󭿋ج@0F f fpG G1w^0 u4!+ ^_ع  `J_ ^V @uKfRPA|3 mX{/ ΁ J G!OGfZȹ	 .8t.L
ǃ	!p91 SQUT;AfWaŅf@tXa覅b¾Z$̥̉  _ͼ    ʚ#ʡOGDGoration Generic Device 12 A N@1f^t" gr	c@a	ÿ@tdaQW&]rfS+~f[r$
ط]Y@00  @  8WPXEtpD(2f Yt2Q"Y[Z jAvdlaw{wuLff@#
M[ZQV:˹,t.9Tr.9\r	^Y 8t&;Ew-&;]w'f0PYr;Crp WsQ@sVfW^W &  &E _^rC&E
t{&E&E0QW  _Y@f趇fZr
4ps,i_^ t`mItuȊȰfu}<u,."/\pE QrH&
qqEq
	.\Io膂7fX~{'_[5  ()bc./1 24 7 8 :; !  {t	M8 Y͹ *m͹ !Hf2~QR?ZYa [<Q+ +
P>SQWO60#t&#E_QVfS zt!`h"2BRbr#3CcshWj[zV  6zu	 
 fftF.vfSVй-PQ3PFffs{f  ff^}qz{~ {ffI  .`^s fPHfXϊsfQ@6Q@2{tQ^qUۄs`+e6X%P?q_`f3*r`g}fe  7br   _rO8 9 f&] R     ~ f&	Ua WIf3fƱD<	t<tQ<"tm< c<<<<tt    BfP
-B?p. 
@@t^@@"f@  ) ?  9 0 f@ tϱ3TX1  f&U&]" sSY t;Q7FYd15_ҩ2Q
ffڹ?)r'z}SS
S  } P`;C&]_X|RVJr.|QQ.S6[rPXff_Yq6fPp )SQP}XPSe| [#w[ \n #
RSL[rS =ArIr@	yr9<uu΀t"tt
rfPfػfXQQ t!` u@rt@nr
dcwπPtdx @x0u!̱t`pt `|RXD8tmrZ6fa``!scwT KgֹArQ9rIԹ-SKQr3&ttsms](a!&0']v'M'ag I!/]Qޡlr ;E]#`;`ߡrMfa%q_fotdЏѰ #^21P@U#Rpf;r)glsPR$4
ZX	@CRրZr-kH&}_uu4 e
$rӦbQxTotal time for VGA POST:   Seconds 0.000 
 initializ" < 10 Milli 
 `.&Zx.ԃ.Ը@FA.Կt.ԋ.u  6*Qjn` 1.&0
qs .aPVJP% t*.?
.8tFF.L2t<cs^X	
>
2.Aw k09
ps4pW苿oꀰ4@
;
jps.$f{#9y52
?ps2O2@nq"ʀ)2ɳPr0kptN3pp.>,uyp2 6pt$.ppbZ 0nHվpf.?f.+Բ"rp{p(sp .
&t ?詡:0fg	fPf.>1l
UsOsIs &Cv { 0@f`RupA׬1@f.=A~`JpAa
P`+ qfpf tp=wpI8a`p+qXf-wfwffI sQp% f1vYP.
hXú#c&π `	 2Ϻ "ĊRZ$`
s$.
tAP0ԋ	tA.
t*. 	23.. úUpUuu_&
#0F.Ի e* ˿@   Y ~ | тPëO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@by      %  D` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VWσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7hؚc t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPhBfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀h$Ph%X[ 3@Ĵ$<sAl r.ˠUr=O!` A (tD_rq XPנ"Q!fnѣ!ES  gf /u
> up[PȰ&  cB`&X;q!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .2[S[W>  t> _`W} v	0EAC r3ۉ_`?2St]AM][Q_Ϡ &
R`9P
PR<w. [õSrġؑzP `1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hιbar1TaP<u< <uϴp. .:.p o.c>`2p .>b:P	dn.e> e,À@p u 8r f΀g[ø0
.a.?&b΋p1p.moX@E2@g.*f΀ v&.f&˸ Laap7*kc.C3`θ0b  ϊŴ* # PQW`
 _YXR.i
 Z k@@ZBB PV}<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.qu#rp t
ArZwG ZYS2
d0 PR7 r  dI r`.pr`@ d`QR	 .p`qQ
t
QhEYus33`o8u" wf`Ph^ @F F@ &} tC t;k{0Tta30h &;&E pظ@ P ^ X Wu-  ~apPfatQ@  YeQRW..| w#&.!
tff..A_0Yu..n_f.ӱ cQ޹R'@lۋ۩mcЛ{?Qvd1>+ r.  cPPJ <t<t<
)SQVWێÍ-<t<wPXrs<v\.>Թ &_^Yy3	0		_Q @~Y!<8t	 `<PVt=EIAc
<
t0FXA{P QpRt @Qȵ$0<:|uFP ff PffXV	 Xi
Pj}^Vf3
f^ | Z  f`
Qf
p  >"Orf0f3ftY "++x fa

{E    1C< tN< XÀ {Ttu7A!Vu`U<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ _!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u}`< r 
A`< u4 _P&OIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fow<A 70,0@r
WfU-f!*fP3 fXpfAN_ u#
%f]@TQ b_<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*HHHì
u÷G O?Û=/ 3EPVWuצu0_UU UUJ VU?c!0W4#WU)%Xs'@Y#)Y+PT P G WIN @BDF8U$<w%.JGu0
t;wP
Ȱ
 3]8QW C  1 [n6f.)ۻ0IQjY f.>)R[ 8svp $h/ 'Qv t7H485 26r SH7z ueaJ2  UuQK蝹7e	$ <C EouA/m"' ;l  Xc3PQfR1[3w Bf>|@Q APBCD@ހQR0SmABC ;DpPOP ہR S co?[ QSWP).X.> uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s_ b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)WR<[ ]Op^?p.u18x f;tu_G2pޡ ܳ_1Sfa u<] Pɰ݃f   ~`4gB0{0t  t t !Ѵrer ZfAA Uta	$_`<`ut
*B5
u0
}t		 u
l. + ( @
r.ݰ

{ZE"R@r r}0MdZrЂB BU
a" r"<0P w  "
 B$<߁  wuS0p@ "8_t2TuNuF;J~ t> @ u.Suvtյ "1ֶ'
 " hk].'uη                                |x KJuII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ]5 7HĴJ!R:$ u#@G@6J B3tB  DECB@CЭZNBD r0`1	$ D[m rPfh j qbA$<+`mb+
cJ$<u	f  rPpc\ B왝[ h:I:  g  P O O 	   hY=r@῀g h6~BȎ؎zЍ̋wh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                          3     F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch i j b c aci`r  a ee  3    0ƅ00
hz
``;@:Wff > hp
襠 DfPff
fр aV'WA+S@)'}WŢpr;_t[s(`(F?[_^aWf` f vrup6ffпfGfY܂eh R1Xfߊ$
(ff A	S22*OPr'!$ 
 uf 8s֊ҊʠXQ;RP
t0k^r#XPX  uf }auSf{UPfPfXZw+ ]f0)ff]rff~m`e>#n z= srscB
Cb_ 1f^ ɉw @t; *Of@I}kw ; B)ђu6ѩz+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu F1KMuY ^Y]Pgs>!f0rRg'QSVfNVFf߸L z^[YrfqXftA3PXQM| N OPQAs` XPhWU豐^PԚʡ A1д 謱 ]dXÀ-p΋_P^Z`Wᐊ f_} mp_p0                                                                           -  8o%  >@8sUv V ufu`wQ2=fA<t1 u!ϱ n #r.V sfYZ]fTf;P¿f;fZWf=!r@nrf+Br
d`|s
ua

<1GM	k;rrmBaoP蜗XPQrr Pp$Ss[OBzMI6E{/6|JO 0p`XE)t fat/+f %#fSfQ<g t0Q#2" aʥUt?j$7 3#tcզ_0
ð-@WV@ ~WB Q Y_W
t^9ldst6]V! <5u G	F^B^= t訔s.
<5 = 
u>9r  Xf[2P
X^#WfVf桖0t
P Ecr&< u P 3B S f^cô PXs
 #
#q$$¦
~$PS)
u $owS C'ð) 1U
 ? 2$
Ǌ4D O $ $i
utpS  Y uðQ3)3zð&߱pFa
!tt	*tEPRQRS&jR"
ǆqR[RVR <t<!t
<P	<W*^Rp`@ ZQRs	 2]
 Z3) ӼVP֎ލvS<û	 [rqkX2A^a
_ ð!R7 u$VfW7 u؃ tr
9Dp<A) @i2@e^PD3L|
u|	 t0  $w<<qw<
Av^2w t" /Q>Q ؊% ȑ؋ *0Uu Xð2HQVWP 
M0X_^YaQLpUP2b 2LB2`|ʁChY
P['/#f@1 OëWB12	R1P@1 (S)WðT)ՠ Y"5@Z5. Qb	U27*7P 10016k0=D'.QfUfQ`fVaQrMfXfQ gf@ N V F `(gWf ff"f0f@MufY+A&f]< 3+fQSfVffLfTfDs1Qf^[fYr!X	AXuf PÁp 0P/R
WfP QOt3 ~ @fZPP7_f]#^YPfWP tOtQGUP2XY f@Pb YXt
 t$YOtLD`"  #v njP@X(RfVt c<p(:VSQWiw#t r@Bg$r	`C- _Y[f^ÞQWV?7wy^_YSQV3۬
Ê^Y[S Ͻ{ e ƒ   rV1fffa.6-fff;w	rf;w@0S.- "  u f%3/aBRvL@u$ cĊ [Ċذ1]L0VL= <r <3@f
f?fʝpff   f-   fPSQRW >E|3&G;r_ZY[Xf%aWX   1S t	t`Qf`T  f@@@u$@fPX4Z4f4f `g&>tq r 	r
  u f_0p gf&^$f tt,$
g&"Fg&
FI*$
g&#Fg&FJ	;f#F	Pufa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`
t~g&`
g&@
p
 
u
g& 	TA1P a{3Rf\&^q\QUUt\ rD.!]Þ!!b"" D#r###r.f% @ UCESusffr 3sy!1f!u%f# ސ	ДLr`t s` uo `ሰ܈aaff#ffд f` 
rffa`Q<t2f3Cr6
+ gB*t r(ʠ 밾Ptۃ u DYf0ft7\4I b?t
.#ruhR 8T-t(r!f1ut
JG?t:R!4j!6?c4kB8t , tu
@u$2HЁ)@t'@u'-*tp(t
 /!-  t>Rs fAu2Bqrr`33q 
t@ g t}CxkpCuri/p/B/RZ/rGU/Z3t@lE$
PqE,\E$`c pkEZbaVQ00fF3Y PSE E/E  ynD$EE2pDDD@{QD$
DD  2~ )  S Pֳ4fXжжد @s[V~W   _ W
t<5t^uԙ趄r˴ 3q0[r}QQRV30pf FoKt
p J8u^P̮߄fbz-uDEPЎ@пD@tߐ0WV/-.`GF< u^_׺sErD.\2SR|@bEZQR Ȋ7̱KE  źZRU  `
ok|R8AS؀u
RRp	P uPXE%
cE%	_X< $OZT
 
"(`VWt_wZwU
uQO6rEt>0Pr2
tC r=Ͳ  rY .W
_!Z  [{ Aa_(Ӭ2
uo[p\rVeĥi1sCr"t@^rS ';Wr6"Qr
E?r@ nȢ)te  
  e   ~ tK\	\*P')0\;#$ ?rIW("  k۹_| xPx(B O55Bm0@@r}4;3r!-q ,-pBF3ɰDA@DQRȳʠDGAAD,,O,@ ,q  - -0 6-P  -a -& .& 9. V.	 _.' . .QpQ 9/ J/ _@ t/
 /G @ 0 +0    	=Hewlett-Packard 68DTU Ver. F.0D 09/15/2005 I ]  Z  l ~q oKBC
sion XX.XX
 _
  _ 	o~A`#  @  A p U10 Intel(R) _ qrnal L1 Cachea Wbi2e	
  6PC CARD-Slot 0  
 8  	 www.hp.com ABS 70/71 79 7A 7B 7C
    p 
3
  DIMM #18oq2#
V*]
.~f+"R,p .";/V @-No bat:y,"
0_81$W1 _T*u	 E 
yjt)Ӏut&  5& A)߀u&uu#
u! À8W|@_ AU RtY pvMuG	0bu< u3uOQtru1 tWa0> S:u@踰8*6R:EFu E0P} jQtTtt߀EtH7w1 F )t%> t:&0]SuE肦uh?3  @ pE>I q u	PXuP3 t?̯X랓tS%yE u]tWt0#)	&2!q =E3L*x3;r.Dv+W+Xu43۰2#*u!.ð-*1!	 2<Gr<Svƀ Ê,Gvh.#]hC%J u$
<.r!Lu24$`.艮2wK#/h4rPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10Ü   EAX=W EBQ C D MP@SI Q S _CS= D@ E S I1xceptu4 - Overflow!5Bounds Check6@Invalid Opcode7 Device N`iAvailablJ8Aou~` Fault9v Reseorved	10TSS1SegmentPrZ n12At0 V
3GeneryProte}cErrorq  1 =  System Ha!P'
 t
-XÜPRf'`Z fVfR6~4螯Fup4/vz4蟿pcP4Yύ6B4{G4t~6L4j 6Q4`fX/V4T ō6[4J`6`4A0Ǎ6e47XY_WQP6z4$Qj4Qn4pr4
6v465F
04t5诜]&.5xJ5nan5_WJ`5o@b	[Q, GI; 1`(0X[S	 m65 p C8BBaaaa$a@0UFfFɷ͋N
~fE F Nu3_ 'ȷn ]
 cRQP~
XÊܹ /FFYNZߊ1ۊA`QȴjY`Њ  aًE9"ԃ R9 & Ge9 .&28'@'dQR Z
  c }Z 
G XYZð
< 
7   R r  `؋    9 M_~  !
 	`輭a@ ؀ `
UЋ؎ ]_aA@]3G
AF `P C0[q$9p` $<u 3 0ؾ   fa3S ^Q][VQ=3AUAY^` 
aËf3RQ3ɋff tfaf3fRAыf;v+R'TYwX0P@YP\UfWf&и`1fW#] f_ff_]p_8f <u ~<  u<  l<c<@%Z<	~;Q<
`QH<i?<6<
-P= uX<`<<pXL]WfPCI 2P藪u_fQfRVWfSt$ѻ"r   f;ttN紃 f[_^fZfYff@r }  u^
N`o  ` s r 2fSRfPafXZf[轥B#ff\F㠋5	Ġvf s"s t s t QVW&= & s fPf&EffXPP  _^Y@VWPw@P`;t
X2 *W 
_ ϰ#tXw _^1ONp sP6уufQ fPfsf8 P8s2fYZu< uEuPPu0uZ?PPE EPP runtime BIOSVers.1  
 ????a@@@@@!AFAoA{AAAAAAAwU .m?]K?.?\.=\ r 7R.=\
ZpQRP<rt2[5$ԁ !Ȁ
 o -" Z`5	$ X p[	z	uR xuORU]W SUU0U.V
f	`&n ^CN CWf	al *Z uàn @`E U PSR<r
 j ?G?pp0^r
t<t ).>A y.A 
   PQR3쨀uAB$ 3ZYXPS("û
ǐ%([1Qۊ \va\xY`uWt= (u^
fP(eI(ذfM(eF(_20- ((7(-a VRtxSR ڊZ[ } Z[K{twu? goğȠ''t%p0Q0
udB9Z^`u=<u8>qBp4
ً@lp e2\ U0URu<u7Gt)otڱ
@;Z]PGbXU 
 s ]`K:.KxSYڼ {M M>rQ4Ys\ P 3Z[x0"=&`"yP3
ݸH ٸGG +V QyLIQK S
 pN qM 誝%距c'
(<PdȍEEF/FRFFFGPQ&` XW<oram .HE_Swt 
' t r
2[e ےu0^r!<i	rr& Qs" r2.AE2& r $ ŀs  r 9q	8 r 	&& rr	| ՁôSs+&' @>'  sa$sQ
u>[ÿ WQr%p$S r~ rq	A9 f" $ pQ@	Pm Xa\#t sq]@tQadt bpt t?
@uYм`
 Xr`QPPPtQXdYQPQ0? t	`DXd$!<!tgQdQaQ  q&@tPwG0X@ؽ (`<u
 @&   w>!@tA AuqP~"@0  ,p & XV߁  0`O_  r
 P<Fu us	` 	u~A
 fu	 X RtGTtu`6FtEuUrPRtKxGr t& 0R] Z"&Duha:] h 
Xuh<rX&  U u_@ ϡt@Q!	 'rr
Xrr dP d@y  $& 8t   `{QX uSQ?^ `b+GOH `*C:q E8011 {@@X@3NC*Y$PnP!  J J J   e fPff  @ fXtfUfwp PfVfWg]?rdzef_f߀Xf[f]ge333P
rVd4Ad^;sgu` 
3 
sM tAt<V
rdDg}
^` VWd_^gEdTg}}

	}gE `tr	 	t}d80b W<yt@DU	
`PfUf]3
۟t u Ó' ze.;Gt -._
u u 	fg6$+' +k`  0 `p	C  %lFpoypOIEMAG  IZ P      	{
  `# HDA-L  wHDBs A-E r Cu 0USB-[FLr CD Hs LS Intnl  PCI-As B C  % eO   H	P 	/` <M M` ;c!MF	M {M ?MCD001EL TORITO SPECIFICATION ;ONO\OEO  A " * Gxx  x y 1 " *
x~"x 0   s w_X _y\[8y y 0{b é uT ËEtذE
U ʁ`7
ȏrD0 t
|rÐ~xf`i2ptW &  QF&E3AB&U
&]@ &Epk t ûO_2u0_&E@ !efՅY$PIR    熀A`!i j b c _`r ]N a `6   c  0b00Sdh
`3. W ep
_ϊͻ 
p aVWPPS;PPt[Q
^[_^W3`  Qu t`GYhr /$_QV.OP ۍ60P.OP^L r FB C KRRS:SAS/R=Rg]iJ tJj3Jin]b
Q uQiJ q   prSQ>Ju5|ôܬ% ׬r!<t3ɸ 
 3Y[ }SRV9i&J:iXG}跑#t荬t# z>pxJ<t<tKƝ< tpl3^ZXӬV  ~puo P	ir
- `ZQQo = c
ujhJJJ2_hÀw*VRރ| 拴  t.SZ^SS!TSTTP .TBBBX$JJ2J쯊BP舀GtJ Xu` o SQ V tA&q JZ  C@ۆA 쐀*uP= ]Xruŀ̀2	w
 =`(8SQ2<

2ۆT.
$2rqd$<w0
u@ð  G0 w   g  ЍU uPp[Xd]<t r
td8D^uq;RWu=f[fs T^u>@<`|&
yt,ـBt&M1&G&aff`fLAAAea+Íu 2Фt
 ۊQ ܈$FKuðW B
u	ۍY;Y_]uS؀uoXu)M4  R A  [R2p n l CՉ  Ơ #  Ȱ 2ð

,pp$ztø
 ߰	2s s	2  | sl{ e	 ^I{2N2 	GÀ1N :4-&
$ 
$0 B$2
ÚVVVV5WhWWW.
Mt'} 貊<u 2跊h`hړWm1qqsw+shP_jqs
2 D"  |  Vks.Dp.D;~ ``WX&&D aø0 м  xj &߉&E  3Լ{1ͧQPTP !XY`.\.T	ώǍ>pJ.L` `ba.D`baQPƌXXɎ6aU3V4V7V~Q =@` "@U-`RG   ]*[%	d` Gd d", n0PGaP O 
p ~7Gr rrs sq]
s!"  
X _ 6rLZ	 
 ܄RU fJMON" fQdâf>uf 0  > t&ϙr_VufQRfVfW`ff+fQf׸@EYrfơf_f^fZfXfYf>ǿuUf sLH
f6ǁiu,7 utmr>` 
XS@W{fSf[`
` u #P $t$?a!h@ & r 3uE_.=\F_3' $< uL
tI<u	.=\ u<~@  _$\   tusu	V $
4 A{0Sp@ u7`pP<u@UNNNO O $#c#j^2^@^)^  M @G." *<00Aq|7A@bcEUB]Wbb bUu{"{XSJRuQ%̺v1Y U  +QV Zb컟`_  u(<sW.^_.82:P'Xs}_Q\su..&+.	p\@ t^P.&u @ u42..
t wPUU**@&u XYC3aP A3.G
XDP[ *.[r`WȎ[[_ w`````````aa
aaaaVS3@.:1`u˷2`@Kp@[^* UFPu`2SF۹ S.:`F[CpN[QF?tF`sF2~ tY@ ø7 _`  _ ø8 d `d <8Ao䎰`0ݎ8 3`8$ $b
bb!b0bCbZbvb`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233phaf>"  t" P a2ۊ( p ) ǊȊ&)  * 븊-* >+#1 d>,0.- &) r..PR uxt;6X6 6 `3
t,=

"=
 
0I5w<t<u F@ t<  $s`
Ê& 
@<uaw\wWQu& $` u
6y`!A  &{
Ø5Y6 FF;t2WddddS!3a\"c`  \0ba3ac]aR] D]Ep m]x`[\!\{\\\+t\ I|\Z[ ZZ g}
3gE
 t"6
MDW  [gu0EssU I2LM  
$$c&E
 E   FU˽	>]>L
J  $K K Q R ]UUQ    U	 Y
 U UUABC  P Q UR  S UT  U V WXYAZ[\1]^_  d` da db =ec_ `ed!eqf ^ZZZYYZ)ZY~mKNc]WfVSQfVF! rs^(2۹   F  +^D_!8um3\f^iWVQCuKEb! `!0"w $I^:u:\!u rQ f^Y[_S  [
gL.pv CC@@[Љ0` !E}u $
`&aǿÐ faRМ`t$t ȋ@yZ1a)}uUkK #E[$;`6Q.@G.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPRZqط$0<:rd uꝀP P H ෗ = _r qw& fV:@gfFXRyZÜt	tpv
 vt[`؎ Ѝ̋hli3 p SQND<tt	fP!XfP BͰYĆ}(7Q!@RPъiRYQu  蜯Y<u,fCISGu%f» f  f  `3.>i .iu{PRV@ۃx 拔 tcPtt>@ KXSB$x$P~Xr$.Qu!$
BB .JJq4HX^ZY[Ϝ7p$ q   3./@32ƀnuo nߊ XGp'" |P -  tP-uﴀ ǡ S3ێr?4  $u WO lfp1O_QuXûuTf`0D Lfft;  Qf3Y,65 !smѿ HP  м  GK & ԭw0Br @t4t ߰p`zk2撰fUfP>XZ+ f]fff]rPmn SWQ  1ЃtуY_[ 
U3V4V7V	  " `y_SYSID_  m UU  "$PMM 7p #m                                                                                                                                                                                                                                                                                               -   
    S    -%  DX]' p Jā݁2݂L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.LZr# Mu 6[Lr pt 2rXĠ	 u v thr&3W&E0r" r2vRs ÆUu
FUF ôo	 qv	 /H	r@e.		p脀'^F&?s  s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	fufPEWEabgVfQSjf[fA1fY^f& u#f&GP Wf   4WfZfXP'F#~r .u7 u/{r?`. t8.>u tu x 2SrV ʀs`,L	p L~t$` t u/~ǉ~ %"NVg 1	s^Í6'N.|uL>R..L`>[L .:UtaLaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w)[Y_0? t>ـ?r.u|
Պ Ѐ ʋ.E;v 耰'fVf{v`$dD @؊f
@NP.eXfa ȋP	rs$
2

	fXy!9
dDwfUv]f^PRB@    ZXRPXuUW:>_]s*r  ZÿP$< - r!P@Xup>q @<@0P  *sXXty>Wc |* BQ	?Q	 QV  PRW> P@   XFrr9r^rT:rOt :DvL*Doȱ f umfm4
u
rPbl
u2 VWrd ^_^ q QP&:Ev&M!G&*E9aVBoCo<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt24 uu@uu`  u2~&fPS `00v?[fXPSpsq`D
>X`?D<P4a`t a1t!$!"q1&2PQȎ`SJr#SMwO "t }
`P2:Tt
a YXÀuOu5Q,9a"   <s& ? `P93 >'N}uǀ   
M  LLVWi<ua<
uuuPx H<u>w߀uh2<t.$SQ\A[|uw|
 h|`jt\_^F] }
u΃}	 .qcі܀}u	a`91@uDa0$'QV 3۬+^YD &!hfѡff?ffJf0^1e
c[ %f F PX[fP~$=wr0&w) Efйun fu Cu~qt05SV|t` t t
^[PfQ
  <~  @ f	t` vaif`0ffAf k   fHff#f+ f;w߀fgК3g&Sg&c
uff+f뷾fa
f@6SRZ=A>$
pP0Cf`rffX{ORpC{ZruAZr
`hPR2ǜq4XZ[fWt u>
rrw`Ua `찫B a p 0`cDQSQVgfѥqf@j_  U@ZPP  p^Y[u(PUFPਃ| ^	u<Vf
Eo P pLP	r=^ uS@]#^[Nu"

 
 ^~u.t Uj@w`V	cL
 ׿B8`.
u&^* +u1Ї0$_Q=SfQfV  Ł=Ut<p*MPTh뙚] &Ep` `&uf!  \f^fYfmSUh &]S^ ] $!&&DDVp& fȡ1\AL
^rfWދDVo &Ǒ/ f`ot@kKʃ[^0 P &t_ 'f=%'+a¡f;ME `  Wf.P	Zg&G_E!#3<crR-u@T@f.>f_utf`@]StQY fqK7Efp,  !fp9*# p)i;!! U
UEG &E"rrifaޑ 'rnOGw|P_@0`m %ߎ`1# Ɋ \<t/~Q IoY<pD%PH
fȿu f p` ߰?t YPv.M"fNf.g
Tw -"|"#:1bqbP9DQ:	: ; 0M;Q.:r(G)kuyD > )uf.
p  - =]*VQ$$D
@V&T<^30Dory9
lY^C0 ~u0>x0"VBqEv}fZ@*(ADn(8PsVPWSPWQN P
P@EDLDra
fNt.¾Z2KWM T;0@fP: rM^_1PTNt?:KffWfQQtT=bM
Pe@UBLnALlBRL@ GG^WX!W<XV1GWiG@(WLWWf-HP&	3

uO`gdOp%Obboؾ:!Q	TQb-`#SShS3Rq	)AUEfd#S`ez_W3na `{Dku_qnhQhhRVhh/hذmO`pjj|t= YXj,{Am
1$pf[ jPQRG B㡀u ҳPSm fqE)OA<.f`(uhbhr 
uhκB  @$Ü.ϰ
 r
R3҄u tZ@ PkXQXq@ 0l уP`଻p0bRW0ſR 认߀pfۍq:W	rf+_SfW.ܘuO f g&$fD  ۋ? 2ۨu<@tĀut.蜄˸_ f_[Q
! YQ 8  ` PRS%` +ð ;w[l SRW*׿OзIr2 ЭO3_Q,ԴAs p Y r3O:3!RQWSP b	$X QtkYl !`@.sXϴ Jt	uRX( V_pm 7	XAP)[_YZð2<UuX
8
DYJ܊B7ǃ   brT
!uP `2
XS@
u	 Y$ ت *êA$[XVWQPtDt!WQ:t
Tu8v
Y_Y_XY_^ _SM_ P1_DMI_ O,  #9E  2XPUv F t	F !FٽfP]X"X
W8 ! tl" i &g +  pa
u
fN@  ]2ðq  S\8&G~ &G 0G [ ǯ!@   栊@@\&\p F0 ]
..c3 и( и\  2P
C@@ XWP/<w3t u*p O $9῰F& ._@P X2$30    Rpf۳4!f ufQ8fYgB۝W[ z<Ȏ3]Ou r 2}An=Au@u;Áp u39 u+ f?wufP@u PqX_u
_qp`< t`%R`{At{NU|S{_V k@Q  ~{{ o{KǠ !qO XE{jP G{^{Q   A {j{opIRfW. um@3hff=SCAFtV~iG t fff kWuf(#3tfPffXZB_32_p9 x
` tODu ( $
`,
aô%޼´+ʼfaPKМѼJt* u$t0$< Kf`a
%D	$d %^` +Xn$Nfa r$<
%	*P' @TO xOy Uer$DIvsL AMM|x  *S|eޣ.a UϦWL.}
u.:ut u% vt>JrS'N.[t >N.[u ^wt	xt_M_7EfUv"v t Ar Mw Ŏ.V PXF
Xf]h@ &A ϴQj@!
ô rt0nK`$h
	OVN}~.6y0" {.t.I.
Lj@s&  |0u [^SV#0f؁D.d.$д^[w	ã3j0rcOt` 	OtOtLtDMt
MtMtMy

{1xu	.<.}h $ B%VUu	UcppR#?G rp
\Z@^ ƹfP<r|wfD@u
 dlSQVWwUP&Br{ eXN,M>y ..>{@1u oPa0 3B &Gݾ $ $PC@&I`(US*B> &g01&O2$&GAX]_^`&?pa s> `b 
 }f0GfE  AסfG!Z 3WP޲ 1rsG2vE<u` LuRE<sofQAM}3  fYr/>'N?N.  EώǿpJ./Q8[ _PQWV.>vu5pG<tFr=_}.EP .&>N>[L@A%50/0qٍَ6'N ^_YSRt5oË0S.q&Gf.:NA_fo&_ . p_Y2ZfUfwCTRSf]hfWgfǃ#Eg ٠`ܺA vT2gf頸gƃg u	f@w1  @f@f_gf1 gfgf0	arfQ@;gg&fG7~;wf+fa f7gf 3ggf}b	fP#fɰfa
t@@P	3
3y
ff0
gf3 ڄ P
@r@ȓ
A
@  gf3fSv̓ Š΃QIf#b ffyZ?'wf3f30n,;w#`4ܼbf[gfѾ p2
ffP	c	

f'AAXAP
P#W!fكs  +SfVQp g46fFCgYQ  Y`Jf^\ g&GCffT~ [PfVfWQfR_
/ШY_f^RW7f;rf`Ȁ u0s'1 t-r(@tD<u u P faUQ	U F @ E] < t@M
<z q`Y]p4~@PQRbfv2`x`q ^~EqRZYX%ɓ	*qr3`	x tt -  t	 ? i09`Kwr=s  "#@@=~p18P,Nff3u
P t  f3g rfF!b"XtԳ$4PPTff6`U^o3&.fPQXYqSo)YaP'уЎ{ oP!8 #	of<t`Lx#f|$!foAloP`dOofaQR3Ɇ `w ZYJB"<t$
tAJWBqpvBa{{ݯށ *q밻ݰ J@P+F]X `j . j }Pv
@)Mf.N. ltI4~r@5p3^)tuw t&Du .⭋^^;YIa.@t&ڃã.^2ڀ36t6^2߯.  @ PSFg'.:t	tX._[X`_g }i &  @
qd@8a PSR,غ:3%  Zr-s(@r3H rr
 rRVvF\r:Gs5&DC H Prfy苡_FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u rcwuu
	A	πϠt&D@B ĪǪ߼AT`?VcH Urp蟁sʁz `-s8u fqt
E$Eab&G )
V 蚷Nh8Kr>u rG mPo3F) r\ {r=H r8QWss #

Rr
3 @M1 |m#k###F("r#Qlr@rk20!p ×!r"!F( Q'&d&K0#V&Ơf)&t N.QSWf@΀u/ r)v{!ufPsΊfXt_[Y`<t;f3f t	f u
utǳЮf[`
 3TpP  phf<0PO   校F X @F$$<r$:u s
jwp_ _A$ 
   @`  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F u(@$3'E&f$`
ĢF f%R$PG ;B(FGq1 fF" PXۋN8NwN 4o2N0(`00s/ ml{B
 r
fQmru$贀f_Y_/̡+U+Ñ &u{%tzrpq? V/QB  BY^	= $s
3
P&u3`~ @
r
%utàt <q6(V&TЕup 
*&u^  %  QPXuN%&:Lr{ * r$ ڕP @uP<ut.@ ;& ; q2s2p$<@t22P !$!$qX{w [|[ĺ"~.Pù[K<P~  = sffP SQ  !兊Y[$p
- F H 
۰N8tSFt f% f @f tU0    ";   t0@bqP@fX
RV s Zn!
J
8
1
$g4 Nff`4eA fu4fwafFDP2`a  tfFP ۈ^DPm fp]fWzfϞ`3#"fF$QiF,0 AsrBrf-1fv,v0h,U-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfWր  pp#f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	넀ffvwAfI| )Bwf*ݸff
fA{N
Xf%	3G,WfA d!`
;Vt
fAP
Q
ĳ6"P  f%~" f%  @"	 "f'F0002F%R) !.PS0? ff%?fZY̘PQRWSӶTt"X  
[_ZYXS[؀  QW h߀@辁 _Y[K{pû z
  5u
 @ @u8 0  ;Pa@r F4;E@H0P 9߈>%F5 N0Mt(BR'9E0DHP  SIMPLOiMOTOROLAVPVS\~ЎH7/P-s@^s˻ʆ >/C>/: /1 /﷒(/@/SR &-&Z[>/>/~/@0 t
@~Ph+؋Òc/`///~/苠/؎&3&M<St<Mt6 6 
6^VO 8*ͱ>Ϫߐ ѱ ӪͰձ@ז׿٪۱* ۿTcݱT@	UK	B`
U9
0K'A+ 
r)>/&~X^ád`S[PSPr([
ۀ=XaCR -Ʉ3ɺr LaN3tί  NX臬f_PAMSò5 RVW`X A  u
  ڀ I6/rr5ɍvjF0߹  O $40&_OˁFUWnq8_]v
=P w_^\w 1
Ip  MB RWB
$, D +&= @
s,FGvu,p￸,p cu#' - -&` 
;ub.@ tfu..&[ 3_ZGF< u  u2D@ fsN~ t
SJ[ɗôpWhp{f8h ` yf  j H  [$p,f_K{9fāZrMf[Ѧ5 0 ;tf Pf`ffX2{fw_Qz  de T q  r7*B4sff
 f} 9
aRfx {úQ35Z`И<XfZcp`ud 3
f<K~p Q`Re k|DpZB"_B3EO@1m09A'ԓ t" QBY ffh@QfRWf ffӿRf3fftf fZfOu_fZYWry!Jtp JQ;gpcIrQIL ~Gm `~B  ~= v8 v3 `v.  v) }$ |m  v } @z Ѓ W_Q	f&GYÀ'Sðd SfWfVfpuzs  3f^f_fl = @p fl j3ɍ6
M.Lu.:Ls&3.D}.L~s` 2`r2`s 2L. K K߃cI^t
`3`Tt t
t
u! h෣3_ұ u)ú tT>'N.|` .>`ׅ u} P J}uL   u3puv`bW~_tURQRUK2YZ6	u>^
f.D t+ t#VL^訠v.L ]ÅQ3| Ys. u&	 t	&Uu" ώǍ>pJ |  öVk.fG.|[@  3.|4߿pJ\PQW 3ۍ_L#_,`
Mp1(1q  `3á$̡PB&?t+aP`)}
t 	
t>[L .:UǀV tMRZ| $p$u$$<t} t	^^ Q3䆊!*Vh 'N| ^t
.ޠuu
cs)t!JRڻ@ ۵u3ێZ
t	'u
u
 ouP@s+XPt ڰ`z︝5.t"Ĩ@t
   XPJXS{P .+. s#. sXP&   &X[ó5P϶'->@/HAC  I@ σD
 uj@ t%v v t ArMv .sN-f-p&A F'N- aύ6& 	3݊!
tr ^	
F (|r
 	u^'Ât %1+	d1*515r0/5Mrr[o[
u< r<0s<"N@PQN \

u' 
$nvf<0rw
sψsiu.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 wr0ss6< s
	OtE""Lt*$Ot"#Ot%" 2!)A
 	.EF2	
r]wsms1I9  <$u2 *<#"@<@/v<%p!2 Æ ]
F!UF%  ËF4~R=r&@mvP8fRF'P^S^!S&EF'f&U&]rQ[P@ [fZ護sSQtP^^6M	Aؠrf;	DE蠺~(LuTMsPf}3fXr1Q}?N.  .GOTAfhP"./pP3V#:Ttv<~'t9r0l졂EE&>Nq<DD@ % 5Iߋ~6'N06u01&Mf.:Nf&]f&ğ} 
̋0'Qf*  r}讵rxLt=rl`x5rdPtZ+cr@ H u~ (um-VƎދo^@tffmݵru蠡 Y荵r)8r$crre	rPTPQX rpw
u `RWBt:ـ?f.Eff0fAUffsEMF F
tSuNff3f@fV'N0WP*f8f'w*f'F'*2t*f
VvfVv 4aFsQU n E]YRPXtUW:>_]s#r  1!ZRPR2B@ ǀ ZXQRюً 0o^PRB`SQmRQK0% [ĳ m h謀 Bt Z^N軳rot
r`a r[v"
M fKf ϿM, 3S5<s-'NO8L9
t" >NG<P#<Q$@ dMZY[PQX h   t޲rzvru3rij`wNrWu
p`dع 
!ʲr.Ǵ%a@tt t	tCHa% su~rt	 2PRZF sH<t<)t<(u;ь>A u/WU>`x]_3r0Cypq`_^a'c`&PSR 2ϋZ[`ÉRFtNw+P X7D	F
+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFF  f[fQ
tW 8ؿvNB^~nNfnNfˈNnfNn"~*Ċ^
^mQEfYSQKfPvpj 8rC8sfZRfXfP FfCF VvuKޠQfXr+tP@P3 G& tff   Rf+IYÀLzuu$`Ύk2t
.vN^G fF! PXG t<"u<"tlV3޾x 4Q&߃?s0  s& p  &_G` ` wG`  в&O &OPbRp`f&GG_Pa  5AWQb ]b  Wsa,ZX7RQVW:WtNᒀu~u .!w6a u/A ?L	
 t,6pNoAOGA&&d&D&t&ƟD3p;k_^V
ޡ} "] uRP>N
  ^   @ e`eTPQc@RP  4
W j 䎻<
1BQRs귄3ɺ/?@[P.
X `.afV`f  
u 	rpCr"V s  ʰy6	pACaf^U쿃`@*2$ԉNT@׎Ǎ~WF$
&пFG &U_غ@
	 `1CaP[,غ*?3% p[`>W  
c t2_R Z؀$0Z~Q`  Gct
 ;  PȎ 6(ںf  T @ DXø M2Pr$<q ؎ffo	R
 b cr&d bp0ff#f' \f 'f.4 tf}f                                   0ؾ +>+۹&۾  3Ya; Á.6+0G1RRFf3۰Sa"fV$
Ѐ
tf`ꌰTՌ"T轌̌4%@ff2 WfVa  gxtgGff0Xff   [L	gyR|#f^f_ Wad ^_If3`ߊ$f
`׀f  PRWS22> r* T^u F^8s܊[_{fQWRfP
t)_r Z^f  u 	^8u?fXZ@k r
^@Q3^r: ]t+a]4 v ]`]8t	_
uY0	0;t4g&Ct,g&Cf4 $<vf٠
t
g&:#PCp߰@f``r7fwF 	far!f1ag&O@:` Nb O h3Ҏ¿x ȫp|xZ(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457 u v5u t
&  {x_t^t]t\߀7utF5R3< v
<ar5<{s1$PɎ|Xu2jrwհѾh蠆r9_2.hkq ߅G$!u@t0<zw,  
t

	뽑t
w
 Nhb2]^h,SJ, E ?G@2q)Pı
 t"< tr0r	΀
20. vPQ,s	} U	_gE9SHP  TPRuaa@uXXZXp! . WPX@ŻÜ= sr~s
0{ _߸^ SQwt軇. _! !${諐 01QjQb;˂QN 3۸ K PU'  A G y   y " ËEup
$@qrq`tW  d_qa(    K P3`0W%,.s 8 ė0fG'f X X_Ђ_@`$<t'<t#<t?N< uc T M_ Hް<u 5  %~l  
 aS X#jXAVW3xu@ G	u1ҁ W SX@ӾVQ 1 S!؀ fWX#'W^RU$	ppqu5WA? u HHB$tu 21$q  V}D	01ggkBB<|CCp2DLD;l6lq@0 *U3V4V7V%17   6  IG  "6! ,@@b Clf`g$/u (u$
uô$uuufaRVМuנu$tº^f` u'= gu $aqwu$WufaM`P낰u!P<XuP@PӁtNՂa`
  P@a  fV@ ބuQzuzt u3N@f6 VTzu^ uOzu#zs@N`R\p ShztE zuyH uyt!2zv^i
-  
]]f^eU  	      pVG$ $  GN N P P  Gwh h"Gt1$  PG   
G   =$W    0    %^r 4ET]                                                                    S A  h  0O IYOO 2	bvPtF X .	˸ f&q && "  иf3 ff._f.]p o>` 6a  !.P f.""""*" ! ai
#
 
 f3ۻgf+С fP s fX   }l f@f=  u0p fl >@  t@&?   `%Tsz u!uOǿ<2{f]
 N] d `5d{PQ3 }27y4rdr
` r`f  ϰ4pzz3ð4`z ?+  \.QuP $@X߀u@A_Xe$Htu
5߂I4
<RVWf1.1Vtf	{ c{uQ<V V<W U   P tT `HafP > f 65s >upe{f2>fZ@J{f0dzOzf .> u	{ &R"qui`a ؀ a@ u
_^Z2 s QV_=ؾ`ÌȎ>, ÿSr@" u !Q3r%[UfQfR  r.fZfY]za /  obX
!@BѤK K(K'`1`O=bii~5{
B	D	`ྦfW`3sAq< uf,u#ǉǋp f3gf&ff=SCAF2f_U< 
`<! F ]  c<w&< t'V3ɊȈCF`M  ^ t	  ?PVV<v^.
tݬ" ؋
BP~`U  ]dmU'P Xs.V Ou0+]llA fr!  g l[ff뙡"`z`uϑ3ōf!	g#lp _)t*~%Q	r2t"S"t*@O   ["2ɵ"#Yx .63-ras\貽&D
V &DtH A 
B Gr!0rosužF. u貾 /$襾rO萿sJ*ʊKZ S迾rr
r{<a@yoiZ2
 0
FFt NfF" B@ BPF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
 F)t r4F$
Ft+_ F P !VPXV@"aWPRzju	ZX>PRAtZXs* 5Ӟ.:f tdu 6.f]gu
#p dM,PfdfBd)!s dMd5g}d0, J V+dM,d<d;]ttd|d]^  R 3
' ' _FǠ  F/3 .;v+GuBG
`F/ {@ Ë?% 	pXvNuQ
 	0ʕ NY%'
r0123456789ABCDEFS`ۻ߆[SfPS^ۋ^&t` $ueG&uFtt[fX]' _?~~~~l|8 w8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~p Q pp		 0``0@$ff$
0xx00 0 lllll  l 0|x0f 8l8vv ``0```0 @  <<f0{ 0  || 0p0  x8`̃ <l 8w`p  x@ |	pH `a
 
|x  ff|fcf ll bhxhb `f3> @p x p
pflxlf bf  ΀ 8ll8` xxp$ x0  Px ƌ2 xp``x  xa"1x -70Awx|`` -p 8l`0
Pv!`lvf0 x - `b    ! vf' 0|004-!)*`2
6 	p&0d ?00001B  0 v
1ۑ u=`f SvN .W2[]Pb䠄t"ߡ
   u$! ptq&k X묿a ThAE eMA9Y.nSS<  Axa( À
`3ҴĀu N <tDQYR"觘r8r蓘r
2:6 v߄Z aA1P2XPCI01 ISA#+T DU03COMPAQꊙ 09/15/05  BC     F10_  2n؎h Ћ"`h+3f  
o L!$F10fPfSfQfRfVfWUfUCES>d  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdff	 3ua 6e< tf3
@d>Se   g>;f `ff3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>*g t
	RC su!&*gfXf^PVW 3W __t
r
>d_^X \ɰޯݷاбκܭ-.DD(|1 8     60  ``#8~ "!AS9>9N  : @'Ya;  @<@?=@/ &s@$	=A	I!!
0To!AY>q

( )))**LLHcF$$
G~B ~B
yy$$$@ $
  >""ZFYdd  #<r N` hx"'QyPGR<TS!2

	" g %8 0 p>$X	

$$7D81 [I 
!e$   A~4'((DD@%`)P(&A +C!Rs[^ZbgAvijwt@CVXeɊ\܃fBNݒ肩畜HHo׎ύXIAOԃeLǗ҃phdo@\Lu폜}JT|FؖcInI`Fڏڍ߃Os\gpjځBymGłrOڕKvxmȂ튮xtԍ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdь`YilWE십ċNԐUiTivIe^qlӔC~tE֖{pKrWoYMߏ[xb]# - @  S   0 ` R ?	i D  Q q@' 'TD ?g@dC" 
 P '1!!#"& p㚔
~|u  0
Fq% _p?   !  % )  fH	! ( 02 ES   _`00m) BFLXp0t  dEg!<"F  mY.$`"08D(#d$A|   UP W F  >"6>'p-@  ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@/@@a!!: ' ( <'Bft,0<<` *0`  ?t2pC DBg ? @
Ձ00 H$@?"@ 
	`0 P $&# DK8 o & `| D~D D<@ B f<,$$0$l=   M@ 3` B?"#!!  8@ `: 	{4H 8	  6 a@)1ppGp" `$?!3pHBQ0@S` P0ZT@L@\D2"#a#(RUY@>B&Z" Nk=bN@-A |a  %rm  2c  Q " $!2a2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxxpa1 
c
=AZxpp!
g
  p!rE  >>@@`)X0$x|pTT T8cCQa- :x b0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{!ijv+ d,Ds?|e0v0 a"s 6`S!cS,t. T8$9`0p6Gy 4g @ dt>$B<' @}""" c px% `vdnIi&0oW@P?v3$fv$d
  ]@^@.*  #2Bb"6T$-`0|p(x3 OV@@` F0Vpq 0uat`m|sG쁐Xm|%o38"5U QHU' &@'a! 3?! @( =!d(!3#\O2b" '?1`		
	`21"`n{9$i$	$	`  "33ak' l#?HzM8@0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,?!## DEB`@].A^! nxK)t ?` 0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P¿<  b <$  '  |D!  D| d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!}@ @Fq6pբ66@8y9@0ya؈  `%,#?8% p$'!G@x pwc 1$&? l@ 2?$?$??b < @$<b =$! <`0b64~
*  hH"e g * ~  <@ D=a<$" AL`5;' '-恴pp^  ) 
8hRF pà2q2DRD" T@""z" ""sbn0 CF`!  ||~ ނIE`<aBzd, %}IHT! Q㡬aE@AjD0p 
 .:23V!&    B5I@  `2"R`   @;!  0`'|Cd p5D ( H H  0
DP;6Oe}  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c2`."b4'?e +"@P,  b
W?BF0L 02?$&""  0p	 x 	#`4 cp$}R S SPpP? !
(#?@@DDD@"D0!cܱ 7E u0DL|(0<}t |` O=>'4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Ryydws7  H 4?b2C"cyH@ЃQnx<0	`Z ̀7(3 (`2)v䂣&^?0JbW8l>~/&23
b21#n0  !7$ #L`,!3p$?mAq%$"h| "  1  A  }    & <"rV&#0 I  81 c QQR0S"PC 8` A a ˀ4 usn#? 8ٳBY 
 Pw`]IY   ƀ0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>ǒ)jP|D52D"DvDTDD6 # a|b蠤,  1p#\  7ajė=  4a8	  O6 P>Tڅ  ptL D@~@Bf$,892k&arg@eP 1 WpxPX	 ^x! 3"&,0@ؼJD% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`	6U0` . `09H~ ց 	 d~@*H  ~K'6cNCc48x F?~!}BC  #" te `QP060o! = 8!` "***" /"$'$&*7"$"? CJ0``]0?~$BdB  a B
BB~15,"&_D$(-jB ,!.	,HO
 =I H<H$H$_I$=@ @v 4R$ze bUS R# P|7 8y0 ;6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z  $D$= *XGGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? ? Wpw 0,0  ""bp $ & "  q?2@G%
i-_ n?F:@ e$ a  ⠼@
#<]](00]V?$P?			?R" N8S8

 ek| 0@	~! y 	 	 ! o>"W"	& ">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDṪ C
$>?ق  '$!$34, g A#A ;<8`hOu `&#f!b6@2~Z*\*jI0 Bn5	G x RRptF H0	    	  a |$# '!b[aaap <2zasR0A: <  B F>lxPXHL0F`Cug@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs"`7 `C  `rL(  fMQp~" ">a}>>b 2 "&"cb@	"00P G  A` xz   Vj_@` <1p0?3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{?I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~?B$fiBFD0@ @`@.AY`M`  Iҟ2R2RR 0Bb.	4df0.t ߟ""p bB ?~b
(LA%ɧgUE``AC}}8@Tl@l$5?b5d >qicQ"tdaxR4䣄	(	)	) ( )H	p ^c 5>] 1 aA#?~"! "2&460ba0"` @"{D1 X8@ @0 P` !bF! °?(HD>!"? |?" p?.a ee   	 `p13"fud Bi|"@Acp>@$	,	(	88(2lO"FfÅV@@`'$pzBp03
D(z

@ 
{t~<$4 7 a  p }#@B"4&0PwPP``? ) )?)  ?2"/y1cI{P?pP	|@   t   uUp cu`  `*	 `0 ..1S.18mp 1  [<u.1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.1` a2P 膅SP!bRV{^Zu
`R\ts 2ƃǡ G
a!O sENjpW1
wts2oa
 4<
t<
tD<tY<t軮 P  VPP t	| tL^fnat PwDXMCÀt	F¹. u 2 4.>1u W. 2 13 `.1&1 u2CQ2P Y*2Ȱ&P a RDr
.1.1PSR  && oZ[X ` OCp@p
oo.61FF2!.WtOT_PG-p
QR.61ʊƳP ZY[X  "2S2OsP2 sP
XÃ <r<0 <rp1@1  1.&@GDu'F!13!ba01.>1P20X;2$CF{APQRW ((_ZYX. 2.9 t.1BA	#+D<u<RaN<P<S<0<ޠ<{<<<`< T<@<.>1 t3ػ@ .1G.11O#0.1.1p`X@Y 0..1.10;Pp2?  X:XUFN
ȋNu	F] S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M
> tj6hjF_d&  hEs>VRIW82o1d% = ۘb	Gg	 v	zA]G@VU?#
,
#&d% $2>d 	VyJ!fbfff_O
Nzd|dm)f>d1jut$QV`		zd		A	
RaUjf	gb	D@xUP
E
/QC
5Hx
Y2+-SF W"UQ?zdېB B00RgTPfRiS4z\4I"	~}"U(2y$B
z&&Q<x6({F*!h R9}d*,1d t<j9B=^9@1djQd$w$ 1fh  nG! tBt>dt	fh jnd$2b
dtfhaLbMQ >tSHft3 tE>2e tjh2efjh/I @:%j hdWP1t2f {tffhQ1>g t+g *$Qf3f
ˍ~f PFPh ]hg"f !_Qh@D~S3F``H`3=#2h|eMh |eodS V0h5&	?hf	?ƀB%=F-oh追h!	xA ,oFdkFdiBBhbFP7@ sjh!Z
	`#fOhgB(4YI65
#h=dV=d
OY0< 1%h+01!u4 VDE*h2nh49"zO	TPQ"D	q""^_ 2FF4g^ F&<
uI) u&*_&8HgtFF  1FOuÀы F FIuF*1 F*+҉FVh+;u;uàh% ;Fu	;V@áhG2@A99h% 
ÐL*|	
 WP
@Ffj hSC_(-{ f f0h0!b &b&djLfP1Zv~P[j`PqD1j FP轭`I:FG*"aPBqV=ut_ V!  )#GF|濃 02N|[a h &` F OGP	?	FNuFG0?7 

xWOw,HF/ A})wF2 1p ayZ2{u>_a	Ibf?%
2*2%#R	a	Ce	$
`
1do!d

dqGBϚ &]Rbx#@92[Ftu14FUB && !d0` a
"`R	b% +1b1bj_Rv3p%%zzd1jA` 	ay U
`h~Ќ3z""djD
8{ E
C @	HT	N!,g3|ɳ1 ji"{XT*jSN

 U.@Xd/j~a4%&ddr
x
x^(t1f"q_Fwt@#QylQ@z[p'8{
#BB*3 &d{/djTα:@(:d@w_&@d 8 f&dAO<_& &O} g _dv  0RUW HCPL
b fd@w ﷡d t}JBAVLP>]@_@b$!yy!p0^@Fh^F  ^F&F~
_rs$1f?&f &H` &te^p`h}0@ ~g^@ d2e@  f.# r
ڣ/ցR|@U`E  p  V6^aF@t,ttue Z -tT-uN&ff H+f .9ʀt0"Pt ߃ߝQ! V$
U+%U@@6
		! t:8O
tWeuUԡ+ 2@_&eڑ   ` g d !r΀&dd''ontD`@9".DF0 ֠  &dw.j `j ΂3
vB +#r]FsV
-`B&g(&g &g{5&ˣ +&C!&.&wgd r\fhJgj0:q{MB>~dK@>Df&Ef!FVD!Fdh
Af|e	s$U"A4 U+a=?rvQ3А)u1Df EfSF@tJyZj)$	>jgZ	 Df$ < u] @<@/"]"raɸ 1 ey b輩'94333L(vZ]f!2^0 0
t%rC`؋F^Nr'~#tp  u^    % F C)^   ~u +ËFVCVF6Ƃ6~ r~wt` t uFfv
0V32,ӽpIuqu_SI]][t

q ^^pM~  f# FB F~P|v^ KF NFFV~n @NHt@HtcH P )nA-Ph0$6^F&߀? u/dvA8>Re|nhXdΐ22bcV;3dv`fd2n`
NNF -$F8hFFoPjRh_S^/GFPv4F?hF2nP?dbPFa?:!Z`d`&U@0c16c`b`~2|FtFr(QW^
4~`4	b-2' _`-0w+FQVAFQC94%~ _t;F4FҔ0
_z u WV~vN^?b>S
A0@
^_C
g"j(c
l5

[t ,md(|WVvԋNsODRHAA~(|WÍ~FIt_~@u"2F#}HFB^F_&W} 
 
.APU!u@## KVDiaeҶ
%%		 	F*Pg	}`	
g<d-UWVv<~P F
&GFq&'h*V~ʷv!^PFGIub: ^&^&8t #^^}۲h!#
 0GF N% }p,-Ar  ~ߋs԰ NFN+;u0g0>3ɋFppAFC&PfSpfF ~0gЋsΠG^AaQFp ~
?vЂ@xe|r
CVV,GV~^&FIa&a8}QFQ2d%"V>rQ⻐IBUkbf?}NQ2&%#2
= 	Ce	$Q
59"oPr@FGU ]ͩ@_v(`VP
_b% 6zzd1_|djA
  	ar (zT53djD	TA{@EQ2	C
Q{@	HU[
NQ;&
SU
	 U@g3|1 jiQA#bi~byz`	`xr@`(#0
7
{2
#26h BR5*S W&d{df0f   |efQ	 f  h Fd2n؃m2" 4 +d=dFr'3d0:I V,@s&zFR3#8ݨSRBZ>3~QxsVp .1rspς@>j6h`PjFd Meu>uIc?#d 2PW 62$>d 	u]
9Dod,X2G %]^@ْ`fbf	ff_؃_fzdPXX2A@YѧA \ja$BGI
DĪx2E$
C4
?
QpJ$H_rRNbUazdVB j)~SpF "4Vb	gPL;ip/#"~0PQOߠ}d*Lp997Fpر Cjh!TBQWVvqދ~ &F<t<
brF*;b}7Ay_~tF&8toFu|t<r2$VP^ƨu	A(|Ð׿ ~Pfh#   PF;rF f{?* F  F*N*ȁ vFoP0"vO
u+4g^F  FOuE	fDg &Dgv tlgq0  R &h{22`% u"h$< 2h%h1hu8q= +ɉN3h33 Љ  auh$<u~h% bPu&
u]f2 % D0	u 
uyB
 )g
u/Au#a}h%FOR 4g5g6g 7g8g	9g:g;g
<g=g>g?g@gAgBgX!Mζ f3 f rѨ9"`ujvRPjp- "`F  vB F¿~2|߸1~pƿF  p ~ uF|e2n
 f jtWV@"`FRvzF@ b*J*p
NvQϋWVm1vFFP
|Fطf-ݾ7h i,
'?F܊f  ҐF֊ft@ t؉FjRvv}qh 0-~St` s}uP0M2muFhMh @=Sh߀ FފfP;~xFf ju"m:=F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌvƹڀ^؊GFAސB Z Bsư FN@F;u0&# д4 '@Op! a7aPjo?+*`
- e)@00 /NVZ"pn|\\\<\2d$S0    v2$j)g@ 
CfeQ@hЎvf`ՑU )a"*- t*-} [t94 J!13q$RYFa2|OCObo!LF m0#"7g
1(  GKEt?/ 3|
/@+[F+PR1w6pd qa"$ 211dhب kbb1jLFoP|j)"#c2#"#AD/]LDE WV3 W ^&@RFG|P385 2 R& KFWbA` rđ7<"JW>d mBvebA鿢b6  &=  t@M[_ FtA 0 
 "+4g#-//

	
A@yu	( MpĴ &&TVP{S~ t'{jPFI  t/ u#O'jfyqPt= tA:? >u
f&Hf"f2Hf% @Hf  t&f`1`ul À&l YgdXgfhFf0ff[fh{e`b0b1b_dUU{e>uw[h hJݹP~h Z{菢p:r@juzBzh[^NA4R^ 	'"			

 
		I 	̢	r	B		2b`F&? t5(u%&|Rup )u&DPƋV@0FF"cӐfjfh 
 fh `  	    } Eq~  A u ˀ&zd qF B>`)tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  -P Qj   8>  &9w&EU 6`  VV׽ 6oE   9~ H  ;py! 
f
>~ KĀv&@u?PM`^; vĴ 3޿fjth  <Њp $`  "g pvV>B  } vV*rF/^ ɀCP% 
Pp h
 h  RaNF
+F@0F!vvo} 	F$`NF@ hbj a^0CFPNQ=`?*Pđ`VW  p 3_^e #$` @SᄊFa
F$`A@F.
%
;F|!% F@P!]<!Vvܑm{`NPy`rFD/t&@A0#FlAQ@Pu< t (F7 PF@V5
 fp L`(* yBఊub~v*VAƐ2xƊ*} ufU  oVn'] ᚃ> t`ur3NF\ ]NZ&8tG[ vNً! ^GF
&Ft^ G +tp
뎐V^% = @ʃ@A3t`߰ߋ@!A;wⰀ>
 u31&A *;t{r1A 
*`FD0~F
tҕn t" `fp0;
V=O`2B|@?Vu	.SEHDa!E'(E zrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 u31~^
AF:G^
uN3~(~ =u j  F;|;pUD  fUVNߋVv<%tF` u DD^ù
0NÈ u0+b1WQˋPWVFX3^tQrJ;v~ F^F&uF$=W\qQb]R~}  P+΋э8s,dvva!V0N&8 uN = tp&@*m 0At߱_mf6o !
`f_+IQ@bkqCTN`_S
ʐ kj ##v`j&F3v~Bǉv0Q&} 0{b;~ANuǋv 0dFA[  
`FfP0V6Z cPQ  F ~ ~
~?h3ҋ P{W t4hP^v?{ePq 	ptGW5o^"p j9Fu
q_sPK0 vvc#5+PFV ّ00NvD"F9F}+F- P@!b' $q YFF`%T"[ nT\QPEP)DPAjEP:P! fh p39> ~jy/0 *9>u	A
@0
A/\&76%'@2)
G;|2*&_ P c`8(F
A
j ]Q_j V@VRP=AQRda'P? p<	n@]c E +_FFVa#
0UcDSpbYg 0aDPdQ虡ˠXQ	5Q`,+?F+Ѡ`?M*2 R 3Rg"@=PD=ӁF3@**A;}Rv9s`V6rQqyg*@F;vwPT4C
sR14+

uK#aQCPedD&A84	PeV輡VP!~&-24hQRptYAS;}^`=y#DȰdf&D&T030`~
Pڏ  q &Fި@u[] ᐡFtdF;@Ɛ]q<ЁN# b®PO;v}vǑa<GF;F}+F-	@pFF&Evo;v~Qm~ $	;FF	_F	} t~0Vg~PtOC tG\'F
t/* F T9F}\LF ;F~AZM
~~92G+F50%&L
q DFF 0 R `IϠf<@`	PXhf@PF^^EAg*T`X2s|Pxb<FA@ŀ[0H&v7QvFvwFՍ\P #R@~OU 3'tsF+FJFHfh iR( teTT4yv .9~w4aFO6,+F!}=pu.tpSq &OC@ +σQ._+
0|ctj[|Qu

F%B.=zQ j]> LnW0BL# ' OCA& !!pa2#$QBC}P ofZgpL@>Zg\gj qWw 
Ht8-t-9t- 	t "{f ;	`!QF~ tfFfZgF  F
Pj   v
u}O1Aj >PHPVv`
Ϲ!&wc¯FtB$P
QиN	VV2ٓF
st!@D% QDu
莡NQ
VQ6 B tD/u΁Ǡ
!_؋!bG C `DPk*. H!MbB~9>u	 rdP`G)g	R4O1miDu(+Huu @uqt j	jfh	m	"	PV^FPqf~
 t

>aΤxQEPzU@ ]FY m DVVjvv{xX 6G ]3?PSq002Pr~CwFR0B@UP1q*E~
G jR[807+$ }p  9]te #S#/E=/`J/FFP9B \ dpg
p; ;NNNQP @C7 Ƒ򠽋= K = ;  -Pp---xАWp'Fj  ܩk >g`{ Pi;v1!;vFPVOW>FP~FPG;/~~P1% - D- ߄*-ࠁ#- " e= Pk_'-
|5. G@6- ;sFc?atU^ tP` cFa~9Fu
VVIVF]v9vu@XPNPN  PNNRF ~9~};V 9vu< uN0빋v T` 3P P|p & !VN;
uڐxA^F;~mOaXS `
$~Du6g b;+|qT/QN;v}O;6VQ9~ uFApL怰9v|GI0Đ0%9F_| ~A^&+^& '_F'302F u!ihj@vVt ;tt D@gx3|f4Whyl
 rz/~I>jFWV  Gc Df td@ @ l ڡtEf
U|tATD\[u0Y;F~ ZprջN@uOup0
DUK=Np>|e u)>f tl>h tt >Fd t|{d yWhLb?0 Wh|p.u"jhbh&`ݠ
j(hgh8`fhb` J `h=dh`+ `z4 `}=" `m#[&`a%8 gB"	b f% Jfs% =dcz%	 +dS%
 4dC% "d3#+(`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhНptN1rt߀DODpU*׊>AvuA*}HWvAPVtw0<@p& T}55446I5245r659h*i@E@ jpPVCpWVh
	 !V3j hD	~DX`HtHt}#h !    C wt^ ޤf	$F HtH?tHHt$" @/ $Ѻ&&G<P jh	G+P舐X
G>7x@n ^aGP0v&ƀ ~RrjV6 fP)3P Ы>X F`~|֢"®]s}vI@x	&8 tr
9GPu=   >p~5q9	uarf   ^f~ t  |֊FÑ!	eM	L0#	yKac 	3$0(`(h	ɽpa^p3&~/tC&  v&8 u*C;^|ckF^P9Psg`^? tvN~}"v`<1
ރ~ u0gDFG&9 uԉ~WiRr0~F Z= ?-
 - ހҮ<5 1 ;uJ< tCBtZPU-
tKŐtHtL- wt<17@t0- tOAJ뛐j*Q`
0 R~D@F	 0 % t" uN;j p貁F  Bܲ u
g~MN3ɻ~*^
7ފ 8&8u	F;|p,Bdn
eP $
Pڋ PPKC 
Cc!
d$  *8fudg"^u5 QU/	tP3`0F |n FPf@
t)f3f͹n @Hpfh 륐j  [a`5` 4$u @3l3 1`F*A;HtϠ5= t	d@ &d鵫 ڑ.dQuw鉀&
:ᢻ	@
ʠ
 &
&
hhN
h ?AA7B 
@
@ -*

@5q&
 _3F! "&d&?d *gi*g!B"  `FP~H AKN
3Ta$\'"%
aC:GBHFʷ`^ Z
a0$ƍ&Í,3F
z46 x$dhej(j 9
P߇8
PPfsV̩
bW&*`)@&` 
ad t&<
} <G)뀖 x
HQ %'@q`
! Olh?ej  %+cbN0ff̠3	諠`%  Piр`RB/
?
$*H0/$&40/04RTRf"`RVdsDp%W
$
aH*=	- I- 9t7-k
 wqrMt%
- Ktq-Mtr`| MYnp= d.,,2@0`  8&`s0'Rz!"Ր,20`  0PXu}/1V hH_h STN  9YۂYu݂Yހ
Y&"0Zd a=	_[Q["
@4 |`r!@ `d`da0y@ Vfh~0/h y Pc@t߀&
 
@ ACCC΁!#!
@d`d`
Ɛ޾w
r4( + (#+-+tp*tcmKt
- tu] &3\& tGђv 1vhh
h hP!wu
j8%AW&A
-C@#'$'ɟa'a{Ðj؁ ڰ @&
)3bP}f 7
z0>{+>>G>d'>n!>/>f'><| Ћ5P$pD D:}E489JR4"" :L}%9
5Bδ(hh V2^Du+!Ͻ 5 31;wut ?&`S7WAA@A@tR_!P!~_!
@>*aO{? 6`L.rࡠAL&ȿ`*a~<!Q"Q QȐ*|32n &Arh3OE@=Qpns@	XrQUUtD3{,i
; YK*amrDFv!
oroVv0%@tx$P!.D$$`
*P#wBf~x0%YAǁK=(͠D=H=yMo*a;Ա;
fhZ K" [B+Gb %^m
tķ
]
ct,W*@t>/tq *``(@ak@1)@4AE,aŏmƏCQ M #& ғ,оX$ $ Mǆ0 0p@
U%@@$UR~2-62`& 	h$zR>'
2UFD
	rR.i%Tpǀp
o.a6&P?As?P?ZA di
MlXF&  &ʦئ,BTl~"L"#1p  1Ap"!ab!a2 ްК-a@y-a ` a@]b눋,a 2 1 lfb}1`0!@c!() `f,afd"Wfh  AA0
Qfdf,a&d..@JSa=6P!6eU >>d>@!@UFF%AN$N@dҀ&VdVCD^^AEvv u
~ nU
u3
u*
u!D	utud`u@Rf  ,ǈgrohE4RvɋFHFPVhPSЁ Xv
/WV0
ߡ2ahHtHtat-L70L+ AK3!!IH
GGv7SLptu\*%6QS'`C@E91GEVgE%M
Ev
'@܀,  WVf+fF@   Fa^F趾 F FFF6FV`Fv4D>==   - -tR  =-a -*t:-߽ ߐ= +-  -jQt}x$Ht/Ht:H@aC 6  c(@  ! "!13 [b" (A
Fy
t)j 㐋ePdPfsVt9>;``aQ6@`_!F	p 
*HFM~* f  fFvfvvFPv2ސ5Fu63F`.-~%v슅a _:uFG;ǏF : j~ t
&@ P ~@W&! U !qq t&AÃ@ ׌?"Ht)3Ã?@ bpbcԀ&h q f>2a uuHj 
@3v0 R0Hfw0af"f 6af a UV v 9Fh\D"o R
0aHfa3"8-9t- 	t Fű`R
  *Ohfjj la
 5	u0u.#JNHuh tƐ>a tu}áfh  PW	-NR>V z`6
Mh45{pPhB63ab&_ V   ?F |b ?rе!mSc}A >p#}u>p\t&el62a=pw K륃hbte3_b13^
>6*u	>v µ0!jj22t;u3Be'kJ t'|{80:2R%4;44j`pǯr
x zp@gಐA!F@[$
$f**StS?=<=5
5
pKx@a	`@Ba	 	 f{h+rD+-qpVp$%#;$ %6/0 b2ebbdbHfPr ) d= $N6fg1l OL2 Rb
b
	^c
~b k}g
0h
` 
B G<w`ߢA] Dt,-
t%-.t,-	 tE-
tYt- t/pC D~У2a:B~}AI y_p}}J  oU2VIftfwu& rA Ift]u
P0t Hf@ڪ  -pʾ@ut@;>}k`  Pr%hBapjtXя6 ]?HtHt `tw' Qw h/m	u
^_ WV3ɀ> N3һBrZA@FwPWr~0rn>RNpDt  & Q FV^tF
&ud,
,,,,,S, v,,.ස>uh h2nh蝾 {h  jh
<ye/"
@t\) 3҉
6o5P@;@)}F
r݋F 
hM͢	
JX<@u
Z 5#W<B6f
 ~ĲfDg v3ɉNv~FV
tut9v~O|܉~*Pӈfb^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|\bpfbfffճ&h  
bt&
]S
 PJnt	Ent`pDq` ^3

tF^&F!Su	 |03$NF%@
EP2}̀nGWnrF*F+= 0=a -tX-  - 9B m= M - t!Eh-|@ ߛ Or= E.
?(/ /  p- 2&b% +11b bb@ 3 ֐j5B jhߠ
΀鸾E
 C
b
@
/ /  (YP)@ wj}Q'3
^'ۿG`hh5厀GS.bAcb׾h, bߠb$ a
0&
cu
Q 
@DM
F@f
fh0`@z !"
p.pfh,-`*+() &'h%0blrd t0
Nd Ǻfu
P0  O hEe `F<tF$h("B by_F ۄ-FC|FàbGYVA/b)ba!J1PF3dq"`	lL	HR ߰HaOeOo K߮cOURUB
HT6PDaWĊ90SeUB;H

H
>U;D
WF \X
T
V_ݭ_	
RaU2C `tBlBevt
B	LphhUR+[j4
b
&%lr55n3nEp"(-   30) +1TbP**et4e// Ab,bfcfLbfbf-
^- "f
- Kt Z0gpieeBee8e@Zhv":HPf¿|ª ;,2pd  zab AB  !"  ?- 2& k{d^t d@TĀD -@h)#̉IC 늺@sڀ# Zޑ+z艠-x Kx wdC=A&OF_BAqa ң"T?zdEfzdfpd@ta Za` hO&CUADPЄRD؄t &hFώ&? t
&@@@j# 
  B	@DC
@zd:Qy@t&fh~o"d@~fhh
76荂7tfh<":;h9
P !0 \12JA?@h/>2P Rp	DэCrh[v0WVDf$ < u?2@pAa@<@u:e32@uto;> `  Br< ht?h<1P66 b u5] Dt,-
t%-.t,-	 tE-
tY- HtA- t/ZC DP b: ~ws3 	}<p  a B;2%@(DF  c` = 0Ht
`q j  r j`¾N@uf4K;F~ = ԃrջN@uOph?h~taq[WV@NWP!
rvTŰqtet
Q &6BG6@Gtet &.dph8$N(aq.K#N&&PnG&@d%&f%C o%d%>rhh81 'Fs""b `& *"bA u$JT7 hZthRðT9  t~@ z` p lPQ j`,"bzp0u.&zp΂׿j`&"qSNF0#0000"0000!&"lVfvfhI
 JRu ~`nh 躢cߋF d:tF&<:u-FF
*0N&$  
u3q`C7 ~ uF	 F
 տ@L
 
 < w C
v`
kHA
jq<d^P
RPEr0
? 0
~ @~ tgh0v&~ tD聩 O=,=u5 Ѕ`\
`
 ^3 FPPPIFF9Fr @% -
 ؋0v v sd ƨu@= wѪː*6BNZf~FPX.acly ~ t 4FPba    R F  :ޅ .E {" / 
Q2 p~dzt}' tƂOFZ&IZ#3^ \do$AhVD.tCq u^ GCauK  K .g"PzWI Nr@~u~_ W    I @FqFV!F^ =uFv2N'22g+@]WV6ߪKh
hVy*Ny vy,qu}tyH4H-H4HSH[.PgHQuy72I.FI9Az"ClIDBzߡza
"zj &z<f+fF@ ={  ^V^KFP6bP> Mv3+Q OYo  l`- t$ fFf~ sA,GuhkܠdPfQVȡbڙRPSQfXfYf3fffPfv`fF fh  bUе }1g Fvh FQP$d PqwT%"c!Tpy^pEE  p 4  V6rNq0	% 6\bD60g\ 6,gˉ|<`y=
T]a?Ð3Ð@6 o MHz` KBSIMPLO  MOTOROLA  HP  1.25!drive?lock   B Computer Setup  <F1=Help> File`ystem Information  Disp_lay siSave to floppyconfigur diskette Restore fromE(defaults.
  Ign2hanges and exit EP  s! withouaving
o Securit@Administ or passwourp5Cte a/"Power-OnWGp Device	deDgb%D$L $s mart Card%G
supportTPM Embedde&E
ta!'eA'et*ac',(0sd*authentic+
credal Auto2ceTools Ba`/>0Calib( x(`'lectb HDDP:lwf-T2 op8s Activ O Mem
Che? r sL ; ll=mbA 	>>uA(AAdvance:aL4uagC lD7  of gray6field 'Boow1bD.xE.Pres1>y key1J`I ue F10=
, ESC=Cl @9RAccep/=YesSNo D, Ao$r=MN AW  UsSarrow
 o highl@ *he appropriQmenu iZKp"<ENTER>= PXbegi)WK%#.followM%[r&:fc-> @KSPACE = GNexR3c-BACK@vio"FgphTABE3iSHIFTa+&*DlF2@&10`
[J` #'9 Er This60cann)bmU;d An e o9c^@ wh0t6c. qde 0/x01 eondApGu@pp{6Crequi@yyE`dl~kba@%mu0C
movP:  z }e4k/MEU)hQ1&`0jlPl//+2SDc leOsu06ssfulManuZ rr  N0
d:Pro utypspeItepp+CacVize (L1/L2)SQ ROM d<d famia{seP8l nupi 	VideovisbKeybooFr06PverDb1$<ed2e3bg!41qa<wownPhip
<(TdG
W
O3O	*	tafХdai5uN%BSNZC*D$`I1
2
3&	ME
C

V


4TV
o
Do
So  : AD.   %FPA2d!J#biFaӐWalRX0s&1z&H} Addline4 CAlXn.zeFdWarn: rk Tll$0po  zDs᧦T[rea /֚, lef ena w0abLppr A: 
de` waqttҰ_)u րrnInv ȍOP
)!	%A you ͔ w=a@|to  :?  i0I  po`b+-c(Quick`n22 (-Cvre@sʅ3 (S.M.A.R.T.) EP1pex03im@s@): 30 ¾# g¶30%v}}`t y ho0#0#uprХ:1't4	fy-Unknk&p{ilWR!mServRe1aPS)doџt7`?a}ribp	: `exP9 'bG H  Ol New Vfy nY7Enc8Off O$  ɥA LA0`*36#%AKroE   p dV
Ad1ݰU @ҭ5O<cpcaus7Ԁp@=AH"h` A&Opower-.AS΁Qa?U= loss  (dYAhcou  nlcof aQgoH04)ev`ۢ?[YDocHishR`e#d?!0f]Dddi1aly JJe HP`"UTool Cr.%oF8IL`ˣ Bk! g Uмn qHpm`@jtWASN !arv0	s /UcwcO֚P2"Onj* `e:Z%%% F@д%԰#Dn -f 0 TndĠfӰunuR?*z$n)tart8BQK`fra Par1yNsza $mediaaAl Mmk ,n LANsQG CD- q0F yD!7C|U`	Q4 abouu}h uR[%_Q b0US{ERBMAST @{apCanpR<ccUrEW"keeWp iRaLephysG?p1kr  :m=pcr. I9RB r0A#
,b nSUZun -B5j JOO1AutEo!RcEdw\88I3? #ON>
(R [_nR~lFbur Ct`@_!R2th`STs1rw  k edmPerMd`qaff+bdat{a,@`ssibomaANnigiXAE!V IPs[jpl r5mmaP   Wu`|l2,oreGpla^yr r /*@|4} [ 0uB Ӕ,co HA=Wy'ul~me`1r, ޠ@MV`*ЪpPxibЩty. IfrdoTʄw8`\AESCv.!
t V !ҡtSyp#b'>'qp`F10"`qPrm ,bs {t+  E$` MiBjQ  OrҐu: U ay OpXޒDCgDL!bA (left`:/hUSB t HqbSu K ZipoFir oA0Fthifp Ssixa h ENhASwap Fn/Ct;rl!s KtU.S00slegackcH `7)n0=pr@ry Vo  d oNTSC`AL -J -MK9t
BidЬEPP ECPd2size 32 MB 64a F@pAlwaynPPi0ACZS gWWD Radi AkBlueth`/rS;chHA Tg"@Rʠ`Pt ED h*,..2)+p)c-{-&3EbQn8)e 1҂23TokR!Hp
@kP	M3Uniqu/e Idf$ (`eP   *tu`    SӾ MCalibPaᆏ6N sСtPS D LA.Zb 0B[ H yO
ELk MEU k'g'MRqN/G/U[:P1 :s C g . N`% ]/Cle2 zc 1 dik-d3	ps
H

,
* A @5>M(o!ylsSp   hnology'tFYadapDPXE ?RPL Ex#➟Popupz(  0 10  U2@ 3 4 5 6@7AF1=2z5 15`@ 3 "M.B o_uchpa`P5SNon BIOS DMAr nsfers <F1=Hilfe>@P^id[in؂\Onz'eigfpeicQv  -Kgu4aob9Vcwie@z nLvE7einun	JƜ-s
kz
..ignepd*nt neh7/%Set@%SRheitsfunk %ntoa u
z naDlt-KuO] Gertes/-$-ID@ Ot 7	Usttz !ր0pѕz#  beim /st(
nBg!@M@ r5nHsvorrq##7..zurck@z90
B .p,!f_g{ms>Ui0'ExGAkkukeK tBsgewhl@DD-S/elbs`sôItivS9#LtIpr 3g d0: tppllTL
PZ`OS
@ PEryw :%SpraQ 1a;n!4:#U"gran Feldsrt-O&O9!86,")e SePMbqTa@0, usm p_3fahBj=A, ESC=Abb!#`qWBkzeX!TJasN0\, Ja	=Meh`m VeZ
zpMark"`s@{!*!'oMenS% d?Pfeilt!
^dQgab	e2RmOq>ko?9 cs.	fcolj
Bn 
sg:-{> r LeGQ = Nch A\pd<-RBchritt-`VowA(Tabul!fs+ Holl2+gedx F2@
38@= {gy E3schlrL@iPK kan<~Lt we Y!eiffMgy16P=z`?rgetrPn.Dc  01 L@`fi6t B kqcQFY+<W\selomvoMrB]er0ilxXWqDeskUe-KsBhmu  f 3asbzw.2Mobih`bgptz%.`Qz qh4Bi///"2f!
}[KAlgrѫ ab	chlos`F-Mll ProzVyprtt` wig!6R0a"Ca`-i-Gre (L1/L2 kkapazit OMPum"F7amik Sp; umm Grafik-Rs@Q Bz]r-Con "
A  °a?7J	b31O 2O 3O 4dqV si0 H>(F  `	o	o
@o1
L
2a7SekrET*@L$ƍ%'$b-!3Kc(1  WalkAZeros-T<One) EdqA`PnO`+: bX7 stqbislwnKp  ZEucQN-/WB _leQb s Atei#CP0&IyLp`ak A:nfC6
lW$g	e`KR/+Pglp%ɏ̄5 L  	/  M<0$wirkQh" vQM?`3, daᱭ
l^iewQPocpFLˤ01 ( anH12 (UWmfafdIGc$fhrxdauP(Min.): 30ZБadS`@0% 0cgt59wuwm HoPuy p4%ubr`"w: ؑH	ԑUnbeaaMTHxC52'rvo-L5.
32@lhafAttribu0FIAD 2u"LS.M.A.R.T.˒XX.Ms K`kwp #eus~1L Dea  JaQ`eD/t Falgeb e
U	ңBU5Ip dminIoz Dur1@`'@`|  m	g1i@eFN*1sgd,E.@"< ttifiz eq s{0yrt.@s Zu10D0LzO 9p袓enlr@~.Ajb s0DQ!np'PlsAviceTa s ,ܠF0$0@ h`L$pga|F	 :	9 JZtfa@npW{Um Fun)<S7, m3e\Wn HP{tectToolsP=c^ty ManagпU!o-- jc}- k QuickLockSubndFr#q\M #"e$bi sϢnch?utz  f`_-?1dԨ@imd`& "+a A)N+ *W"$B>#, lp$meh 1A #I Nk>"o3f`ot-Parpen}ґ:- 1a$P7Wake-O0ANS3TjmCD-֏&g1M%UT:an 3A;m$"rive*Fxpla`t=?XPcNs E-A\s mY8unbrapnb'ar.IpT
:f,ҏbewBBSH!sXDŒ,h  %G&*00	M, 228\v),    L2m@nc8z@ R󡀢Begriff0dmautomPw S79@>ohl@C i Qکk`}p #tw`Z*f 
X'U!!¸!mU"n OP o"a;) lrY}#OBzw痡58gB<sQ}:Sn  iU.) vduQ(`qS!qs q	h!ac%Cw Pr qҗ+0I s0  qurࡁn׷hE . Escdyrv empf/0qS	 d?zu!цRO0| t.   
 f.РYҵ F&1 2 B 7 b-Bd`ntra tAdant !Whj`x!@Esc-@&Ll̠>m TkW'p'px`\ F10`esh:
x3f
g`g& sbD} m  p¡@MMu.Bay&m @)bBtgk`-Eb(links)z1tUSB-b#-2؆Squ`1Zip 1`234 5`678 9`QFn/S'trg!Ptŷ dEaCГ (USApf-ZePcB`iebss"una_bhng`  cAr Grafik-ContrPrimSek% Video- rnBidirebal GrÔPus Lfa`iCb0tzb"d}r WWAN-Gf0`Bluetooth9Uanbp/a Egp=aAggr E?'*0(Eo)u/E t 120Y397ToqTR C? !"svxa`13IPQk"ovH AkkuP  @RtA    x a ? Kalibb  MakaOD  Niuala   O fm   O  DO,tOTrat-?6. @.O .L`b4obisp 9cOO5"R0	E gnOOf`.[r 1 :. % ]abblo(2Entl ho30P
m* 2a
 GS-2' su uĠg`Radap(aABPmB`z}ExpA-!-Popup ( .) WedauQֺ0d2 (Z   Ke`~BIOS-DMoA-DaƁb@߼EAComp0ropstn <F1=Hjlp> Dvoplsys!VisCne Gtil` !konf0[GwendзfraMz@PSrU
Jgnorđndr =oP(fslur , ub,t gBOtnek@+hed Administoradsko K aodA7 for'·`hE"d`je-iq		+	*
J	Sm -kort	Godкdelsf 7`do`_dbyggGOds -&2	 Nu@00fa@ksl2 IUc  Dg
Hs)9IkAd\HF% Ba.AX p b"d`valgte b&HDD-selvp^"tPr Huko QAtrolL. inRrQҽh OGH omv	IBr/ Avancq Sprog Vl1?s mo2nedtPt felOC4+'/#5l5!Tryk pP7 tas<G0=tZOP`=A, ESC=OAnnuaFsp!3=JaNej "J, AR=MGb Brug ps
NA`RP7xe~  releP %menup(,1Wt<ENTE'R> /ec>A)et.taf pr'f!f~7: -> e!& MELLEMRUM = NlA<-TILOBAGErTAB&2$wKIFT++tF2@	:*@= Acceхh0!hk> hsf#ej 8A3ku1id$0gs 2dodQ)!FF1n. Fg01BRnoVD-p% qpla`9G!krvN vek`EnJJ
i dd!?zsP flyMs`Èn#/McEUqoO5 bp* uvetzbrud2JI,nemfB J@`  Prc c~or-typ hBigH  ztr`7Crcache (L1/L2@HVROM-dౠ famOilie'i;\AWdeo#f0pd@s:@Xr-c^D-ba si 9e2o`%3o&4Zƻapt-ta`oej1("Wat)	O3OWEw @ex{%IpsrP4E$ TyPyC%xy l=ydes!Bmis 0'bvD1I'j`e0je var0: DB! se  alt@P2[hold a po Pdqt`/b Bb-ɊBdduw5,&pr Pk
kEuGrBA:tTUETf DF%v`Ugyldig/
t-  <ngivuİ,vAi av٦,?# i#K?@ $1 (Hur P)% Omf`) sl(`{ (): 30˄2j  `1x0% f3rpudZ44b2@DR  	8cq: KuB+"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5ܐpyCD@F8Ny  Be@}ft nDeae Fra@l !e@+ń 4PR@{	s0FC		ƈ 4D
&KE  beviвB7 9!Cfd~es, f.. <ramG261A PoR.`RVuAj@me+tabWata. Du bup$AM flAX:Ը viGcehCa D[@G @ߒ[&?0r !,ci HP tectToolo9"jK Quickp;au`LsQmP SkrAp!0rKvt%#k|qX)/sa1-$$ HvisatՀ `w@x6r,
di u.bilK2;p+1ol p@~frard |)x Qlash-@$hPR@Irnz>m#LAN u7r  Cd-rom-p@' YD4B Hop7hF:eIEu1:w3h0z,A@  YDa$. l jb TBRUGER-0xOVEDADGANGSKODEN,6U\PU alPyg=,s ni  ned opMau,edS "#
{	QDat l!@po PWI _FQqShjlp iutomo0 p0j_q@Fbyg[ao9b73pk? perma 3anPTigz!6n?do` fys dskpP:2@rbAu3pc(On OP"0p	v  .Gh)Gne ugW"Ņ Pm>/, som!6Pa ck@
Ryt. U p~ sgJ/c1  ikoqXS`.U  1befal kraf  ̓НFx| 'A @";pl . \uqÉy
G񴁴"  &cO.q#ar "J"4,Q/d i૤HuA0.q.foq:@ENtr!5E3SCq. t%p@ or| 'F':ge8@F10FY SMsf
i/P D+s	  Dk Osr@flgm vďRRenhHPskm DS-bas  MultiBay (K0`/$hjUSB-floppyc`c{wbsu SbAzip2FraVTredjFj e SjSyRV O3 Ni ̃ Ski mQm Fn/Ctrl qElPv(a:isk)Opege UGst!
u1PnP0#rm-cr Pri[mSed Vo Out Para֎Tzj@StrCL|>ohukoP B< t6nr compu0P ʀtrm#gt WWAN-!sioBluethМ/A (trdllo`~net0P2	pQၚUamstyC(Q*8*Gtop+b +Ethat I1K23KToLR![ HL	e+	 	Ent6gt id-nur7@VaP1riqB  S!Ѐ   Z 9b/ `LKalib) nd!igO x  0"ѷ YP OH K O OM\bo   O O8#01ion OOOO6$Hgs  1 1O OR
1Vi bPGu"[@!(MEU)J=K=O OGO1OO  OOO[ TPq 1 : Oѿ@ .  % ].gmt2 AfFH5L)O=3@	Genos	
`k

, *  J/X4 %G)'  (FA qt @Ž֡ r "popupsink(sek.Hǀ$25f- bAg0P p BIOS ATA DMA-rq Konfigumas  <F1=Hjelp>`ilxinP0jKon sP s2{Laӌ$k")Hepfra6#:00@dio A	:Bk1)g avslEu!A B,lBDE;sprogrant St Opassa/&@&Op4FA:|U)yrs|i!vsfunkur! tif ׃%୹b-
vn Sm 16 ׀|#godkjSq0 neby`5i%itpt5auTilbakeAl#3fabPRg
i
 PE7;aN Urkty Ƽ avalg CAlaQD5h 8>vt Ak0  MbT!#`]!@U3EG *
`Hpӑ!4vanpprlg 6  Dem75bM @f\dtJIel\ 3
.5E6o%<|}5TrykkC taJ&L&i  a=, ESC=Avbry`PacBAPpJaCNei rP, T\ReGr=M@bb `kYneppilr@Ot<ENTER> hv d/du ve 'Vt. BrukqdPp%l':  -> e$ MELLOMROM = NQ&86 <-TILBAKEwrigʶTAB&"HIFT++TF2@	)P= Gof#l ~WsfeF
`  SPk'0`pZ6mnop@51 P M0|m kjresve!@0mb d;i pp 9!obaRafly@sbc^  0d wAXa`1A|rvfull1z. kode 02Io"Pro{du _t Nopablokk-mll {typ4 h@igv&--ga zv$buffN(L1/L2@Mengp`	Q	enuV@wo-TtjrtroUSW,kobPgRi,oKr1 qi 23R40,p( E
1w,9(Q0  
oa
oA
o,
N#Ek#ImlD`4$Eoc%Hq ok!i*ps(A"Walp9g O0s"-h1jH( Ad`ss e7"~e 5PnAd 4~: DsA#. z tidlSChColp`@DTH[aQ "/he7-  d, rnP}u1p skl<k`nn@2A:۲O b@Ҽreg1"i%HU?gyldig#DSR`	F
	#NEh0mtEb`?̀{]F igno3t_te?2-  HN 1 (R nslXbP (>): 30A3ggr 0$s0a%[v\st͂!vhF_f!_:g Ka"qut``UÓ5$SQ&eGt To(Lesb'1Du+q vrib: ID01rs<pS.M.A?.R.T.-f^pC0CC  G#Npu  Bekreft njAv`l eP 㰔1qrEّj؀vligkt aDu! 0oC2Ѽ܄	aŤokag3ogs.rɐor dmpel& Tp}?B.rPa(A=pph. `bku  amK#>0vice.0ula?eD(s aݢI 0"H i HP ptectTools3curity Man0`r.'-RN%l  ēlanppa|0us L@$AOmpEr`i!gi$e>u beska u"-U+/- +ӂWE%q m '. tgl` rh,v@=$ڀPŶ. K$RmEp! rfrard- Parll+vFPhielQr/Pia LAN n0^af`04  CD-ڡ%vbX4N5w Ho/:eD@ Gh0valgt5Arj h($s6 bBRUKERHOVED-8`DK |umu̅! E
 n_*GQFbeM`P
 Pﱡ y  "!мa$ #
T,U]?0	$ۆ P8P,pp 4qLL KOM @ aOutom\pDyLock5eabyggj]dT3Ac   `ma1ilg_g%e. k_[h fysAad$0ƴpqtW fo`?	 exᬿaphn@gE_3Es `dda gu»z. Urrjomd Q1@0/e XG|pn0q
B  uSb}VnbefaQwr G	 q.ҀA,y A0k1 Erғ& 2;k_!R!'I@7MEPsyp-flAans NPEv
,2pES#C-|L Ѫb u"'fD'<J F10$Z4be:h&` n$  QΗNor iFOrse Mu?ltiBayG]@| "Qdn7(vee)0ko.ngsbaphhyOBUSBeA|w Zip-U
A A0@AaaˀFn/Ctrle EAVd(USA)GekeenAQel !	`jZtroA2@deoPP@pJT;isarrPFViA7ti@Q@mFgradi/trdl@ |t@
WWAN) OOH OHBluetooth /-feftQ`mbQ Ags9sstyAg!1%%*2$O (v0&#.b/x! 1 Eth ;?	.-	J3  !R@@NT s*ooo/
;niA@jtiGfikRRC&@B:CriJ K0t@ա   @6ymbo KalibaK B!es- Ip<p|ˀ?Dual ,-N	O	I	O	 O	51O	O	O	O	8ksp. bO	O	O	`nd 4oO	 O	
%O	O	bv? mob. a
 H.\L.\O	 a}o
{8{O	B.[ TO/: La. В% ]afull"C2F~@i3
"in/Qh* f!y  (o J/D J/éiǋpkim sin@ hurtigE (sekurѷF1#2-`f1.Sepute P@pRBIO?S DMA- rᐍConfiguracie la Com adora <F1=Ayuda> rchivo m%l Sma@QґPGu isco flexicP޻ %Ra (s!valojqpf do ba`y Ignambios y@lia A{  g3 'Lnz epidadAse
  ' Ajiciof%Oposi s_
SITc)$ + ՚@*VKskSm>CNp SoQ0e*cP#<) Sectyingcor`% E 0e" 30/c XP>6f'brI
a`DPVc!3nci])AutomaHerra+mia`C~H er 8`#P(8` ;prueba HDDKc ' >OGVp&MemoriIa2a d*mp.al1@JNKRMu0GbSG#
~s
 AvanzX ESvVDD
W? Fampvr)co0N gr<1o?)<UOprim'quitec0g2)Pbao=, ESC=Ca06la==Acepv=SšSNK1"Y, Co2	=M4y p U@{Bؒ$dchDhal6al~  alemo apOropiu=@[*<INTRO> z@ix:N.1n.Fs{3PpkTY :Esp~o o -> = PrxcRetro7ces<-{p0`@axTAB S	S'@Mays+#C(/cF2!-910`rƠ"b"uErr 06F  No@8 AiGSr`jo u@QRA6K. Cdp`0}1Bhay n cunw>эqubR"nY2@AC1+>bѪr(R[co rUD)JНebook/MEU?IX1 QP\2O`0ple0Vxito{sa4e Fak T1ytil TisOp7,UVclGpuWXTamauZ_0h (L1/L2Oc FAAROM mil@cNmerD}ribvisUv@ j6r g-l@yo!!
/#j1$l2n3p4 Etiqu
rAsI2VeFK (ga Woo.o3oopoiF B	Esn!*J8T 5:Z$  ProbUS%bs>sfactcXpJ$ǔ =ll4Reo 0poX@1'	l7nedi$l@@z,
(CE| ojD"F%Ad  :vH ouir  eap. PFre#/, WcqscpY#auAA:c Uu  c lQas ' Ӣ,hp9tegAң
pS^@vlQI$\'vaPa)00٠o(a) 8!@%c	6Za?`gnޗ,od ilO(g)-~:1 (Rp=);2 (CwF3 (S.M.A.R.T.) Clcuvtie&ej 2( ?s): 300go B0	%&~Db EaH0 _`ipaulGirumq
د : s,pu 10 qIQ{`3nh7S_ervof 4>4apoya atrib0: IDp#@eaxs G
X0YA`seaـKHnue!vL@)Df ApagE6 ndq9S@gODB".X		@e voc"	k"alpa 
0 1Lstnad ;` fRn"]e0#թ9 A*# \A<Q,` (02o,GA`Ơbs (R6% Ey WciR|(LLB ̠hrpinR3 SBf_ olı9al ol`X#A!Yvu	jvip.AqoQ  '{Ùv?%(֠WapaAuydAn14n HPc_tTool@O)%!!&  QuickLockSuspe=n Blo`jԹ\rat S 6""t mej`eO݀@`?:0d++-y	(BI	( !)((rALlRt0,"D,0XjৠupizQ,a.`xHOre' Pun<P+rojo%q>!lWS9MLWmedufh俢dem Iqdno Wak.n gLAN@H DtiRrePI" ACD-Q(mEřal)ʇ[Pm:\ Usio:b	u 4@S0S`<Rrive+2dL$ t dBUSUARIOM PRINCIPALp1 oo şgwYNman@Y p 0|. AnТ;7 y gu`'` lugp  cjAp~0Q.1)TM @d k`\)hG1
f b5@ָ]@ A"Tw(mc;`N	;I0or@D=
`> >1RnRsuCw  ,/ fsm1$ !RulrSoc,L" oI /be}"<\su 3Ҁd/asRcu4BbVt"B! ?p~Pģda$kosapg\`԰6Se {oenf 8d8@lic1a頴re!azA. /?k 0u񡂮`#PZ23a4=inͯK n`TBfix@P8Z`
v\i< pons2`> cY_, pipԐ2 ESC. ΰ^alabP'Fd'  p,F10@:̼ݲwfGAᠿ 'a7T/bEspaol O R3tMulOtiBaNZPa7 DiPsi
3-p ;]f2b0co+Ļ(iz(@jech`-5 cBb a1ЇШSuwkrDZipcpmqeaeTer Jo C`5t x SpOvNo`DɂCUs 'Fn/`Ts@ncIngls (EE.UU.)sPŤ (PPmmplSo}"le$B
Ғb!Ac@ Gѐeo ModZ"y!  Bidic 'Tam&#m@Pdi#	siFfu0p{ BICA IR001ڀk*WW x{Blu?etoothA
p}{P1yhoйergsGCpoPos 6B/P:(s+ior)¤Et}het, NЗbooU I1/,2/L3/.Tok0RdOOEredP23 IpStifd Exclus sAMa`   .a*C0g_-N0p[0SՏo`Wr)Xh!,o	o	Pk	o	h	s0bpk n	o	o	eoko	o	o	eao	o	%MEU o	.o	o	o	o	Ub2o	o	o	o	B8[01 :rgr". c% ] /ip걟2 @c4-C&le0τ3	йk",'* q 9OD J)o!qoh ~1bl䑄|@zArran1pBy@gÓ"XDPХg2ExQ찱`8  ŐF12QTPAmb@TouchPad ]u1o N uuTsсr D DMABIO9SaPub  <F1=Ajuda>rP0Info@͇䰩sobPo 
Sf EเЈ?4maD$ӲpR0
	rt7padr0
3t  Ign`0airA	4sPs'&_1nanL6azO DBr %&pς _`#ƕb!X_d#!

SJtUd"ԅ:liz/pΉO
(Ib 0 /R Q*Ag%ԠbrB
autQ<Qn 4dcЮealhAlo`Oa c(SkFeQmas@"g1=1iCP8$!leOpT HD7D A1)r  VR#Le Mem@PA<PJ  4tat1u UQMuPY`G]⫨ Av8!S%,io Qa`d; 1ca{mppJcinzP"o?CAX9 Pds`e qnr ycк'tinuar i=' SC=CelAce imNK!S, Q%oyu=Maimg Uti0:ps C	qqp'1da` o i  apGrop@y *u@Tv#<ENTER;> t5meRez[@o.Tgut9 ^r utb:  ->
PAO = PrxiK\<-QBACKC	ExaQE06TABo$S_HIFT+C%* F2 	*:`=kSC8# 9nErrrOAX@Q@na0WoQp܃mRHE.? CdigTGo 01  NP#hG`,@o `qS)  s@ viKCAc A	bMev
;ÔZWot?ebook/C[@(RWS mG"sTe2_DKKXqmBm xitonN  Ti0H݀3VpcS_\ Tahcache (L1/L2૦FX a` ROM FamlY  sN 3sri
RevisSvde@Π_aJroQLa
Al@!D	Ob a( 3M4`Rtie!p	JIOeu6$(]) { 7on)o`o.Oo$alS~ƕSecunda'A$ 1rcC% v\foi"gv@a!mO al  Walk S 0e g1i	a lien!M!oc0I@Advoert: 0[0Aqo vaCe!djWcPqP/,!i`um  gravvuu:e)EӎA: n@Adc NS3 >HB^hO!Q/tegiEa	c8]
vl0IDyI= k9T@ctez0 eja $,C? iN >?ý1 (Rpx b2 (A@ng!qf3 (S.M.A.R.T.ax`=_(.): 30<`хѡ0@CT =4Q0%?1$=bucedeA,qAhostDCrom1
w: Iss-P$Eg
Ch`Ӂƫ(*erPmec    `6Q3s<M tribߒ焁LD`AМexa@s wQUUi!g:Tgrg"`alPSLs   qL rB+ۤiPArrfDigNcis gҀSAAdP)PPЉxac'mod!CsާB! faz A@ArEr`a,Πerx dform!Hr3Dn,P#ja0.@eHCsHfbr>causadQerF.  SZ Q[ea 㷑2krvio 	Iy0rqX)QTa?%0Р ur@1r0k
ad`pis0S,B,QuickLock!Suspenso Blo `qtB #u@aSM%` mabnb1IY @k, $$al#.`2P4sa eiSib0RPuseu s<EExigU`re*PbM0Q+x &perme@$1lp즅+өmaok6no LAN}e H!CD-"ίgGP$qm摘e:SGusu~a: VocË @jp4Ca0yr2utzroDrive) t@$UUSURIOE|J@ESTREb ISC(̑:q?Yapaz=@L. AaQ4P@<de-ЧrPis PMEEAp"@.. NQv p^X֦*6Ye ,@Y`+bN 6 0.abu=*Ƨa !HCde`D.H@i``72{s1!Ei崧O:W AWGs1Y
oc<w<0o  sup`Hf`oo,aop Df Caab#eri
a`x@x}oW :aq(΂4`  ƀrqur<Ǹ{@FngݲX |af0W | 2|, p;) bF `3Bor nalp`a-w
Aa ΢atEsubtud C~ ?@* hR)ssa޵ptA-lVJ /trWL !8Z  LemGbre ՝vqMac`Pasap8
"quiP_se`R ESC]Ō9Ƞq3lav'f'rF10. r`r:BMrʺTPAc]D ugus Op1k: MultibKayQYNc`i#si reAFpBa baЧcopld(`RP di!tzB	qRc"zipcPrimeir"rc QtւTO]v@N ؂c@aqAs Fn/CtrlIngls (E.UV`ыxS[hp1troa؃RءdeAcund a@h`3LoPadrBiQTaPhBm'emO"sem fubw>zeYc10CA.#RPa 0RlmWWAN)` oo`o)BloothkAAnP(a/ E omCe/nerga1gerec-agRF2.11{5e/2o03su0Ώ3Et&netg	O`p
/*3/CToken Ring OOboIdf Sb 6abuaqW XSt`IsSsC!bGPdbpNtgemNS vlCAw#[Duplo&	ted/	)	E/	 jONOO$O'as7AmO /	kC/	cIAl0 OO/	Ojp~AMEU/	/	-/	G9Dф1	/	/	/	O6[ Etapa 1:rreg2. 0% ]Oc3l 2:Acv`N3:̀M* 
 o9ay CCm*O"(sDflex`QSc زrydap Y!瘀i 输Popup> Exb@ ~à'F12(т? dQZs Vsara֧a N Uu`T@s`ws DDMAFWIOS`i k0@{mtukP  <F1=Ohje>xJrjtQt Nytt vPbtu kP Tallenna levykkee dk@on@oPu VtF?Fo02ej'nsW Oh  mu0A .Plopq6Lr + ttpt7fTpo@uaurlisu0invojan s@saMrityoKynyk L%a0tyl	
 P usnumAe
o$-
t lyk
iu '
,(opnu kiG
/`!(et F0.t13fsBg5*tehd 6OG" t!"$jڊ;A)ma`*in@Tykalu`A: o@K < Ki 3vyt5OA9 @pFDMuPk!  a26npC:m -GDHLisieli Q Ik aec  harll  110= 22gR2#j2H%J7atkainjot  nppd_=d, ESC=Per`F =Hyvksy=KyllEi CM, Joku!L=`TY_ fnuoli
mIip^k@a h$@
sicsN <ENTER> -mB7t
ep+1.I@Kfn C/ss seurgaavU: ->Xi VLINPPIN =PZs  <-bASKELPALAUTEdfb1!9ARKA+! hV?AIHTO+', F2@
)_= d@!;0virhvAkkua e =oi>da.>: Rudig 01*ka c1s} apHrt2Pl pU eygtke`"6ko0>@	siP\QlaksqкrsRW` karCt qlaaP^ TikkI)>skeytyi 
Fn
i(pOE2nL^oh(0ebaGm!|jA|}1?i@d ty'ypp iIn :fڇapllaVlisQ (L1/L2ࢅU  ROM-SbmЂkoh	tuotepe"	sar{W]`si ?stohjab T;{L	!1:"#2o L3o`M4mɭJF`Lta1on7(j \oa) 



\	\J%ѶkA'ra- DqA(Cu0$#:D$ 09a%dzb~ lpi!iEepoi Walking 0 -[1Yloso@Vaihtoe@ :uvi7 us: Tmӵg atpnhp . J|lt luop2us-  n,Pirjonc !KA: L"X HAYhku VV3beFAG8p_Cpa@@ ᣾
GHkoa]Wi `n? `/  H0?ͨ,i`%#(N92R`3.M.A.oR.T.@Arp$[n (mi?n): 30-gs p2y0%cLx dv0 Ispysi- $4iVgR
{fb%untq'c{K)jServ?omoottj
Lu!5ÂvtuQ	k@Ftt7ribti2@ЗŽy@a T6eqKxe nGG9W UyuEVahvu  x P>2Ȕ	! PC ޤ}A"+2@s@a	,-ãPAJa頴n4-okkpDad`5an! 	InDP -e@7p$Rmysba
$`k1h@B` ЁeT@	dE	ZPEY/r i0Xj [.!K unQnwby:p\veapahtum0"b@^id FLaJ4>tii l̾ <HP PrpctTools`cuQ`Pger -apuД큶.f(-/U i` n QuickLockfa3 hlu 5qf,V "@PraZ&q-Q,:*sekm #o$j$it)˄a{d||}yh' PP`0#UC1.7>uut	SApor_ InfrPnR%!"bkS0m 4em`dHer;t`hiԐak0ʡV CD-- -jl
" 4[w PFSj<PZWAiot#@ebn De#'(ȑstt&)pOll7a. p  /@! KYTTJN= PSSANAN,0FCN{.qa!' v`"0*@3lyQkur`V0< ribj^"#t@br
($V2[-(pY,Qpc``mwLLA4@1^q* OQu% `UoЩs- V su@qIzAr?Ii,#tuBx	8op R
@J bU7 pbIr
V|}meG. Nykyfr`+raq~s Q{6v
t`i @Su. Tqt է0$l £ihQ{eip=0up@MY<eh? IPa*?-p@F|_Rt0HtaYb=c /AxojaiemØ qrtat.A !WQsm @"ftB TV@UG.2 !`ZXu 1F_f}0D epq0pǠo#\X2Css,aTESC-n`psRV;n,'e'A> F10%Y4aa{ :B	o .cVQ l lqt{ƌys ubn MultiBaOpc&JW!/lakoPiu (en/$oi) USB @)ZipEnsimm AbKoa elj }Vi}Ki eiYt@Kaks Y KymAai Fn//Ctrl"mAȫ+PEng 0(7USAUsPP	sa!QB-@Rsq@ ƖnjBsCPPs VPo,t\Vakio$s2sN#Iguu QHADplQE ko@QWWAWN-roHLOwBluWothE @/Fh`H sV&Rs s:lPm(ӏ,1i0>H y/2,-I, (ylos+OGCO6EtherHo2E Yoeo3o9TokX$g OohA workQc&G <IlivA AkkuT < TJrPѿ r0jo@libr ad  Sual`-OO  OI OKblb_OO  O Os O$O$O$ vva_ O B O1 OMaa nusBkPBOD OO OMbOOO`O
OI[ e`i:r
йada@n . % ] ODPW2l` urpp&OE-O
3
Go@MOH*  j l9#@`Fނk`FqvuɃPiǰ@ '(se  nA @:@F1S2:ڴiP%3tappiQkoske@ߐ. 'mma K  Ei mn BIOS DM=A iedo Pot Configurati5ordteur  <F1=A0> Fichier? Infor` mAff age Sauvegarder sur disq``c Ra ,r P 'une.H_DHe0als dfau`ow du'Ign=o%modi T&pqu S%?e l'in % regom	\ Scuriti&
e ss`Nd@S"#j@`e sous te 8PKon.D
 priphP %J	a sE@&IDy'As
Dr<Lockq
Smp(C0Cr1P31r3  'he5G  1b#a <gre taR,)+5p7am''us3;),;rfren!cM =at"#Ou\ !@lonnLbceriZ slecqSn@psQPs AIATABFoV,mmoir icBDX C0ZZaFB_V AcpLang4 ChoistPJYl3Ind)|!5_mps g!X 5ePMd.rpa `k2Z}:~z? AppuyDfnatouqpo@gepu@lw=Ser, ECH/AP=A lHAccep| S0=OuiuN*#Q3V, N/'impp_e``1D
=aw  UpЈzi3
s Mf'heM
mox!04ecle hmenuucer8@rwbri 2qhz!y <E?NTREE>2nj+W	ss	sui/fa  !/ :!-> ou BARRE ESPACE = PBe`1-$IE?preced@S.<TAB`CA*'zMAJ+ix F2=1"w-$!S(rr`@P<TJ Ily FA%ssibPdcQ7L U cs'Jprod{endp#B$P. Coa<'401!c5Cntв@-1 emplace( L' D SaQre @}C'y
GJ 
s}^ccueoil dP "4@ itzaxsmobia``
W 
u` B!OOOF2BfCX+)a ru Fa0;cq0M\ GTyp0osBVwDb KTa@rcaa(L1/L2) Volu`e!gD  ROMOamR Numrqo#p	Rev`cnrdoerS2ItrQcl#avpoLA} ud;n+/Zp/zr3/t4n"3inv!/Qzi&<5 #priF:!L( Ute)O OoOOOBV'ed6A Eo MT֍ :$/.   %ErF4 !SUPc;Walking 0ᥒ81lig'ad`auZC	od  al0i5fAtip1SRC[a=e@ptruA ieЪvPR! /簹r,  z{ nr1o°c	HcY0]A}jDL_v
 t;ro Pa
s
TX	  _[Rvj!a"`dH.ORn m:YfP S 0"Ӏf   +-vaPC 
lp  ߚV ? Igno7 +| z? Enregeo#=1 (rap`)#>2 (coet)u`|VpimA(z) Bc30堿s pAnU0% nv$D9ʈl'hA+bF  `:˗	AsmGinpnu#d'+,`v`t
$.Lu( pG3ip 5A`ib!<O: IDP00@"s S.M.A.R{.TAbanG2WpW AIBY`/se N!=apYeAÐ?/@;saұ#A Mar uin KS;A, eecoac	;mme, vK*ad11POobPbatCs	eS¢d4D	 pe>a1a`(`ih s4[	,P@s蒵 `Ug"  f'ormQg-hHq#xѼsJ.)ArmQފb	 hJU0`
1AJ	.6zT"`QDP~aR avoupR!AfrCww7 A^	 	zYR`(p"}ffQd  k;l2TcgNq`rHP P`o Tool:e^Ry Mar 	O4K8CF!/  QuickLockUsus A|$cp!ri 9 س<S&ol'S+C)re!cB!
`K)!nk:,   v qi4//;  / L'(a'Ha
S$ud!v
 KP
dra+D hn8 4`ExiZAudP `2  4raQ8llƙۗ&flashѫbWake On LAN\ GCD-'EpZpalj\:A99s!Ɇj$e Drivea-. SsD#DDEde{z "deux,&(UTILISATEURPRINCIPAL)`%H	Balor@V N>z_MA`I!!&q%ls3r `/qfe4Bcelu2*QDordibf4. A pTV	 ~(`sdRZ-Ho r uDfetCu|MKQ"$t"~"a"["qoip> >""%x 0ՑH)@zANaniq4"05#'o牌#!2/r,Bcгǻ!,o!  3p i\!! !!{e@^qQW֊a8"%uelR1X! :HLk" "".opa8p E*O' jW'Acbw# ,d'oroiginIlR!v`OB2C{Ia B	u
vqS"apAQy9Ipt0M倮
5Odjav!s0P~7e*߹-$WqaPprs P"t Ձ?on: to@Tp Ra1S44ZPpabP}t3ۥk'
Qyj, appuy
0`  ECHAP.@@@ OTzR'o', 'puiCrDF10@Tap X2 1xCx Y^u}	UZ/qFrana
OgҝACJiMultiBayulƍAph0A Q!3D,xnsocv'a%(ga)OOFRz) U[8֘ USBqr
.jZiprP:0 Dhi @sβ QuaQCiyn`NSixi` Se  Hud NeuvCD`Perm/r(s Fn/CtrlƓ AnglpSA) IPoॱm1`s A`stanphnROd'ad`n el^AtrlS' UGichQ&mӤ`
*d :i@7idoA񯁿Bidآ 0 mmVl@jEK!alX $ R o!=ril WWAN? (rse0il)1grAPB=looth7s0/?1  R >o`$0@g`\Q@loc <G `cP!ZqX0b951bP-n o;2ooypu8<	6ccumodogB EĐt# 1Ha%23TokRing ooUX/IduT9-ar a[  2     h% ll`h n!Kre00/ x Ab!AF0.!f*Dupk */)///wb/ ////** -///Jqgn$, /,/ /e s` BtexвsqbmoP/ /7/// ,///7[qRpe 1 : Charr. % ]A.`I 2D` GicM*
n3@	Rkio.
* T   @@/M.$oOA$Ʊ|4Amor1cFe"5 RetardBTexp `) Dжa  F12\tposf[iP+Aux  PatqbAK<w ucunİferts BIOSmDMA IP zpOlr <F1=Aui> nfo\gQema
l0'Salva`l floppy%@AttoRipr>ina dnThi@fAa0``ip"|Ignor`d!ed esci EP a
l'iI@Az eiBʷtupicz{za sswo&e amDratogcc3R
q7Z,vos7v@% IDs
@פ&gDriveLock	LPr ɣ+St CP9 SupPA=c30 g@Hg/o+:,i fabbr
4=i	/.nzi`[lQco
ruWi C`b5<b!ae9E lrOpa t2;o rigidAEtpaA'VP<!΂,a me0V W`<HKJhMiM;A>orp !Ava=t ,Lu!O l$Dim"& q6ca X ssopd eviQ 1g1	vv!'#o*62wH8Premi qpsiasiesXperQVu L   k=f, ESC=Annu`,aA Et0qe.o=SiSN@1T,altro#	=A bj Us"Schiav~I frecc'!i1 voc<pu ap70e"_`<INVIO>  \kZ\'e.ipYgui  un%:@ -> o SPAZIO = xsuWss`0  <-pBACKCEĭ c<TAB@C%o"M?AIUSC+)XF2	>-Ћ= m "AC"IErriS0D  Qu A87nppupvse@t"ViO  v@u4T|pXJ. C{'01 N0u0F>QQ9|a0}oggiao Lk`IP'0 Q>re0
z4Es"@agga%Fv0S!t`ғ { npabook"tQzesp қ:\ ZҪf.atp_
2o{briuPrf udauAA ND  Ti"+0<PSpVeloIStepp@YMis1ca(L1G/L2d&dDbROMIamig	lk N@o0H`(D	RP[3[oi<#qSroll TsjrAer ~$i1OFk2m	3n4ࡐ7@w PVSTe)(DE(d)H8
	2
3
4D葭<Fonda
 ,o:EV$ THr%OupyP!gTŒ@lliASpr:bit 90t 1Rindirip	i] `| 'F:AЎso:5X%? gger  `|vpAhAre!0M/rѧ, O`1favi P}P1iVYXA:'mYU[A:"m]aconouAðh(_ IIpSɁQrita]+ Nsv@dpRlIQOayളSe3 `voPga	 ?AFbb iQfre?@?: Aɐ51 (Rap)62 (Complet"2tio (>): 30>0%Q5"r6car0䠈'hPD5|:s* Щ-@
˱ ֤(aD୆%aerv|")LċAPLA'	nrib i0gol: ID0$Ban`de@z قi S.M.A.R.T.!ޱuT0U _wordc(nuo!i2 pDsc(Ui%L$?bq+d`! {â"Znd?՛O.A7Tcq^B&
Am AVf! B;YpCr	t>J2fum y3CePe<B #u" _t`!1a哰.Q]ՒbdFo!erdPКatiwEff+Jizso~@in  ca2i vEvPgaζOdesХP@J m9Yy HP tectTools Od. ZRV2+ ickLockspen`3B05EY mou`s8 MM d?#<#,p  gra@p'!oe  -!e$C-))0v!pKsm@]0x$!! b	,'UvRar i lі@NR(@| ГV|a infraQ)pH y%La_h_flashBmqnQsVLANp Off#o C#D-" Se($FZPp: [@!SRQ#x3ĝ{usanuD e1*. D:HAJ@T @@bҁ['UTENTEPRINCIPALE  r@.`a gman8fu>`o. AnPV>FgP0 v a%eQF@p0f>(0.l@h0AuYPTk^s,bh	Q_q2L sbR? 7reDZ\f.APR$ A Qco0@%98 P+ AB.`D
 Bre,@q  d (`<t vOH r luogo DJ T!B'    #l$ j@IV#:,!vI< /sI"I@5-"÷[ tClz 	s"o mP0!R/0DeB  /$B H@æUEa ( ݰaDA'a gQ#QAi  	Potat{ fa+ ueY/ cdO::l}&.2rPqu_{9㔓!. Y)uA`YEsnOP䲅@K1'(56h,mP킊>ёo ESCƞrM'v)dovQZr 'n'pom!nF10. !n!k KWyȴ_6\%זt qIP(i 3  OA:D0@ $dM MiBay b9a1.gga
s$Z) ogChi USB0]$Su}kbC
ZipBP6o ;TerAz `OЁevN% ec AС" Fn/Ctrl TIngl  (USA) Yid u`2O mpl 01asciЃR7#pl Ua  0а࠰Pפ Bid0HCapa memqX5embs"F!/lDQ2'c/wNPs (WWAN){oBluetoothCommu	Ю/ (J)Csm energ]hW'g)1 N,*2HB-Fa-( o)ol/sp Eth`etW V123e Token Ring p!8OE3 IAkB|@# "CtAaL   AoPք  C02b// WD|Sa oo [Kvi0Du0V /  o 6  / o ,o/ / ooda C  /  o pUY\mo93 //-oo ooȓ///oo[ P^As 1 : 
ro .  % ]xocompp®#2S'@4,n6E3  @
ij!* 
 /JqoXaX/3i'o
  FloppybUAǐI!dC@Φ p(sec.)# vel0F12b 2zw@pambp@NupTras   DMA BIOSup <F1=Hjlp>rkiv Sy!~infotpзs~ ]S pk:%kPiguQ 3(stll frnlPpn ard Annua nyd`` ochsl``   np͑ SkerdPtrsl0F  K!aOB rct-OaEnss	(b -ID
S ao
 m`
Rd-Std frutsav 7K
 byggd 
usBi=*abrik`m+ .J
sbehrsig#Gskts@rktygs Ko +r vlP S`;vtiGHDD Ak_V Minnes:" 01q5Q ?@An @#B
S Vlj4rD ;cBne'dtolD!@v(C-j+eTry@SI fri Dg s nr du viJNPstyY=, ESC=Av'bryNaFD_AccepaF, V=Mer X JvI pil	e	/pCKa PyEt
<RETUR> om6
YRtt j.ke,lj`SeerI  >: -> кMELLANSLAGSTANGENTEN = NaXS G<-BACKSTEG FregepyK TABf#O`KIFT+H& F2`+?|=  'fO @%Aoi?Cfel 3t g1qL @ kA t h+AO` Dstod uGen. F7elk0197
 AsЌgF{P|plat  NtPhm krv3? pbyPgm0 fly5s t6 U-Por/2 ex䚣(|0Ytid#igooi2-@Kkl`TA UkN,q  Prr, ty=p
hast^hZg0Cap-	rlek (L1/L2)Yd RwOM,um  ?familjr?enummn0D/deo, rYȓ ttNb ~pqyrQ!]H 1I.z2#3$4rbinv0̦3 (
bZ)g	1[


Sek# xIrq.4I$@gaxr%Ex!z=ok!pvidClmissl l.s Walk0s - T~P f1jH Adds l)i7AeޡnVar! D@/ѹ  x7neh g"Ccuskap*ay /G-t۱xiƱ=k b0!h$2AA:f1R K>#Rhi{wIBB?skyddadag

 B Eˎ҇pA!^Ԉ  d|? ig?D܇jGa- 1na#bb8pf@րީn`X9UWk ad k$pQd }(0): 30@npan 2?0%bX A4Pp/]p9p01vr kMatPo:,t	!قOk%S(x eorvo-Lz B!i @(f%ttribut: IDpx?grobsr.M.A.R.T.-5 G'ammN u7. ifin0@ D> Lܰ@Q R4bd% pm}vlika mǄ  'InE?ka?n orsa@3iЈP9aHSsNyapPO@Om=<s1A1lo. 'Na om hglmabtj@Deh ;els!e- @^uQ"uayVq >fun 0`perl^7!i HP tectTools%٩R}-6-Quicka"q`telgeG Lp׌mP<s Hgk
gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!aot. Kж7Aom4pHi p@1%f   Pk`anFlash-@: s!Wake On ܏ fr\CD-0Xw QPR%qSt HuvuduJ { fK: D . Gowhrdvd D e . A1 a@`r AN}VHUVUD$} ɀma@tt .^  P1A "RN`x ild ̀+A
 JёRh vpyL l"C*lqJVQ.Z +oI XqeDGga2b2bygg7ZSY3 g 5//b/dA\J8- F`"Za`=om s-KeB
C:d@=  At;asBeF@fpj'FB] ktuaiqaf%aanasks .dIutN^#tg Ps0` AYq,vїursprungQb#@&MM. Vi  reko  a4F	c	Yr`+,0s@ b`b . A`Kad΄37_j &g `!b(gA|O-beڰfosesm ih`pґVfljgns. Tr0  >ESC-rQBS ֠VƁSwԑ`'Z'R-sedMtaGF10 cVi3a:+dshc{ Sveaq ҅: N?, MiBayCrut oppBP5vi BaLG (`r`Ϟ (h!SBV G Zip-=PW AsFjQa utKto NpT VxFn-/Ctrle Ǔ E lsp(USA@bmYkd`! b`n`rmsPtrorx,& hbbelorlekheo2n
ek0!L!BIfsv@iotrqtK (WWAN)0Bluetooth /() -v@ĔmbeQ Agegs`ha4E(-21,M2vз[,p`㰽'aNed< Eth,& 0	z3n To!RPN"!>Unik *@ ?iG |K  tus  X    Sbo> Kalib@ o dp~-  F=s alQ.O
o 
 
 
9
Fo 
E 
D0!m1s
Ao@o
E
Hptag *o 
* 
VC| emoo]A*5o oe
DI OOKood
D?[Ne _ : Lapr . 0% ]
ͯklar2u j25
3omFjOF* &V@1  >I*O!DgOЀU®br@|4sadapП$lg rdrjQpsnabb0 (sek1. F1 pBd OStyrPguIOS DMAaa˰"Ben ie(e/  Op Teslaan Conf'igupo`anafPvt ndaardP"/  scy	Wijzig&ne Pprogramma @РSetup  z1r w܃@sveiBeheerswachtwooހ
 %X. {ApaatbOgl$$ ID's 	gaSmA6CP  Oa u"5P$cR%m@j+%O
GeX@gӨ gssvzie܏"Fabrieks.ugAz7@/);Vref.s:nieuw8OOc  Ext`AcScuxB 4\e0P geselec Ea p`Es  zelftGa [-schijfei Act 6vG0u`?`I @R!a/4UBgDAcg@7n ,D`P=%_
 w 9aKc!: Taal b  =r/emP 	rijsgemaaMk el=;o" /;9
8uk AZ ]{NMLg]g=S, ESC=Annul"EDG0=!e!oJacNee fswlui@Q, AQ-f =MN Hulppijltjkp`gebrui1Ѕd )jui`xnukesuzk@ark^<ENTER> ind 
cr]beZo !vol%@@`1  0aiX:  -> of SPATIEBALK =>`<-BACKCEVorsiglɸTABb	#HIFT+%%|2+K= ykp=t#B~fouta64k p It w_ge15 F0MЌreqatijasen. 6AcoZ01b a0.i1ZCu  we   Netvoe are0#FMPN diVbas`e3
 t n0 notebook-'pc/AP @.PistNOQbep*igdooh2L	MpЛaft NmpALyp6rocessBnel03Qpp OmPЂP}e ?(L1/L2 Z/apac?i VxHROM @ -s!fSP<mm E  Hebvrgav_0ideokp&p;b bpM	Hm	ra1b2rd3e4hãisgI t}.jne C(B(ЉwM@dzQ%)
  `D#Secui bE.aw~~@$Ftbd%)҆2!dHU2L53Hac-S0-*1Tho_adresrlafwisnd pao=LTo'p: zPt<t֑s e'ge t PSBbeЉf s d1 A:og-  /ޖ"x 0zbLe6`\NoffaG1@Y\f_d ڑD`ѱ

b)oචgAt
`wOC'We n	u  Њ"
wil?@oݩ""aA?Ox
Z\l"+1 (b),2 (U0Y )  Аpqwrpn (min.): 30aee&p:L0%Qtoo 4;q{ho:5broA):]eeqx/nb!$32#kvo-IPsEI"
 2"qk:J S.M.A.R.T.-af`@APP@udh "/Blo!  A I-7B4kXq crlpSX8
 Vr!a1& is bBsAYoCf#/k, zTm]lijk0UKQߛ zoik` dvors:ka?0QH fQeksKPu_gzet,r ,lorZ@¶(ZOb$ usw!b sqwYfur9ohoud'Hi` ! AQ`R`T`R&BѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k  p?g`spp`b TWmE #M"g$rgdΠ9b   ~CerX#W>,.o(h( o( S("7'EAJb"f k otraakP)5w sXbtK;?ݳ ]Qŉ p1׀frapd  Parˊ Flash-malIr=demia LANL aa7hӁ@r- CdC-r gHNѽ|fHoofdZqGw *I  U15@|deFB`D!L`#:@izow.HOOFD-WGEBR?UIKERSbPpՙ  p'3anA S3FC  Hgw!#N$  fykkvcomp3)AosQ10|_0)t D 졗"g+Яq.  ]0qp1bA/utomPOc8@>}X @r?:h^AA_<T< O!V)?!=NPSS! !. Mo[iaQnoS4Hb,P   n 2S8PȒ`VU Cnt@ TAe.pb/ |@hui`ː,̺dЍ w~was top/!k wgeab.JԻ7[!?nvloeC]km\Wsn 0Z^Ud4r`ra=`8	WptorHh/) "gect. o
 s  v"N. Omun
1]A&`3fe*&agolq. AAu_ر_,ܥ CDyAbhl  $cӲep3ruk3pESC- (A9± i 2jB'k'tyUvbkn F10 @T*ZĒluS4d ry`V4  NePl G g MultiBayjVzakd@\base; (иks)re USB	-Մ cb+z6`p- E2 #weqVहV@{aZes >Z$À>Aa8NFn/Ctrl `Owiss/j p@мSStaµMcW3MijsappqOv5e 0qՓlBij V o-qPF`A/Ahˡ0d`dition  GT@vgp<uq=VPilat`xE?"Vp neVd$` Radioj WWAN-aofo_Bluet@h
`/o$JrgieĠQ [KqL^.(ba)0cEt̐ 1
2
3,iTo}R/ -OMobo!023 UPXuAtcuI< q6us     S#a~Gekali@!1OK"2
NeEual R\JOOCO GEZOOO 4^B1^'O0OO H0~paAգ
O$O"Lker-MUE-$J$O C$P1q+OpO+O  [alp 1 : B⸒o@1. % ]/& p[0d2knte ~l/{	3	 
fohl/)b* Jt  ;>.C,$"q $#aXadap PҢ(sec.)pop-up bij snroC aF12i )Kbb cursorytuyEasyP}o-muis}G1 DMA-}drq BIOS  Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋւa\܂tsfBNɕۑ  ݒOCOF畜|Ăg&f 
H
gɁ  H?o׎ y
ɖE	ύXɏI  `AȌwԂ܃@5ea L(eA`L󃅣CǗ҃p h/d?o4'o "X yf@\L/E%ID&ID: h5 (uN XBSA$͍폜eX=} 0g Jp 23T|8OH, v".eI*"%x;FX
= ؖ>Of
cA>oAe  I(f:n(A%e> pCeBwIvCl"F@ `F  H D%Jc9J; ڍ=c R5BM NP$߂A%E@Ut`UO tB!x#sNu%.37($b74L[BR h=!AEsc=C@bsAS60=󂢣
 y aRAg)gjq5\ 3gp] jkڣ %iA@g.p>[Ez] z e >ȉ#wA̀r_->Epy`tOo[ = ET  <-SG[BackSpace] a%[Tab!AG#[Shift]+eF2!,,,1y0nmF/[%  !CG[O  @DBC7ł}@BDrp o 01 yNF`+@~3a
ɂACOk ~ڑ_Kv@&eb rO x 1X
Mp!mQ^0f\GdMEU		Ȃ2{e`	уɰޯ   ۾  xïݸ  ށiL1/L2"OM~ OM̧Fرٔԍ  ޵ ޼ޮ ް ۰ׂްޯ> ްi~r ޯT#2.3N4h	~ pŰch3(Ç)FE-3N4(JkvEJ _!nFw fXcopFb?$qv@ sxП6!y;LsV+oWalk0s?DA-1B/Z 'hѢ;p^`OD4x:2BtƁAC %C ׂĎDa/ŗ}p쐬AFA:_݉ |b#}v!h F FSPl	NXWM֎~@YqZo s/9@y(c  ցB	CH #ċ  gOog'`,Я1iÃNp`2_iS3p.M.A.R.T \zsԁij: 30Bײ>v0% bj!c OK iz3 eB~ Nf{:@	{em`Q1kT {ǂ UעfIFIDP.Ba"R`R0 AFfV!'/ i`¢k΀@ΡdAJg(B(a ͤDAJhvٓB"߼ /  Ǘo߽@{R@rRVdNJǂ*Ũp4u`@ȂaUC	 !]Ō"^
Y>ꍇcxei!ݡ£p	龂 Ƃ`Ƣa7df!f
`?"dHP ProtectToolsh}lWŒǉTBq#j, .qB4УMmNu<"T h8' kS{-E`O'OH&J8-.))Tی삪D<D%蕴 ` g4`dt!(!ċNyb8v"Q OO GPuA0V @QlA [{_ۓGfC!N7Wake on LANh CD-Pu3X(a $} K^ V:`%A}UK^䑀 (i Hb'C3ye@~ |`<ݭ'	8 >B`/ZAT?@iR1"i	3	iEl pK	͎W vpR@sA~MS#/ۊtK@P!K/,Ɛ!eF|>e \ӅJqA ߐ x <\0ۏ؊wԓ "łb͗L nły`k)/)%)Dp˦@ Z7]t.z"* FG`nGKa(o(0in$E'm@_@] ( IO)F)u
 ϊ((?(9(ágDx${#<43ɑ8`ƈM3 f=ɉwe^
@&A)TF1j 8cB3  B獑BAȑO"Ocĭ( 2ef̯旌8dql@ӔC౨aU"1/g'|EE[Es3c] 񉟂@ȍ~elAثm T.?DriveLock t[F10 M:S   y_Ԡ7>~狃`E': ESxtkGb@ȓO xXiǶoiEcUSB ӅA)XPXp H Zip1ԯ 2b 3 4"567B8ڢ910r Fn/Ctrl%̟ؑ ǲ@{`\p (USA) `O|B#foX
KV&ds
uv C\gs  }WZJ _ rIo@嬧 ݂cWoϕ%݊ACY Oڑ͏̧fpblNi!WANj%M`Bl?uetootg /#jְߓd `qIntel  Executi@D?isable`0$..1,2O,.3.odhEthernetX 12t3 gPq
AOKO3O@$OFj) WID P7bfN P  !   ' ?pfbpU?k ej] o  \(%*nP/h/!p!!MEU v$) o|!% OOv5bv1 : [dϒ . P% ]O<2 !gOv3		)J	*   5$/?s'O mjvSpeedStep technologyugh 	_PЯް Ӱ c`px(b) sF12Qԁi!byߚҚ @^```b1[Bq @dBIOS ATA DMA].                                                                                                                                                                                                                                                           ` a b c d e f gt" M           	 
    ғ  
         2    $                    / 0 ȶ  3 4  5 6 P  ( )   , -   * +   2np
 N % @.   02n2nP2n$2np+2n 22n82n ?2nE2n@L2nR2n`Y `@E<B߹B<U> FبE0`8l v x|v||p0p7c   c 0A ߐ  = ~ 
=$$$<   DDD    O aƄe  i  o䔕 u  y $n%Ap E%  IC&O p   U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {=VROM+*'(

C$: |O  s+'()+'*&83&

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      p]g|2nA  2n^@  .@  b2n@ ED @n.2nL@@ I mpW  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
2n9 Re2nXd2n2b2n f2n_h2n@a@P  g2n@W{Xt|dU Zt}[}#L  ]J~&  W_tU`$itVa!
	$
\ 	~ 
`	
| `
R`
Fa
bcDdeDfPh(>{&&`W2n8@ b  U @
 j( 
( 
r l0 m | o : *R  	2nq$ $} 9 UD VF10 Setup Image_SETUP  P0Sq  ; 	dP" *v@HJ"IP a|`j 6
&$`ZԩC ؄ TUԫTԠU*<g!"$Dcz: T'ᴳ4㴴U4崵4紶Ud鴷4D9b` : (7  )$**$++$,*,$--$.C.9 .hໄ 0	`9G E$H*g4jH@ #"" $" $" 
8 b
@JNu@OPP 8 	;	 
      /	
2n&Xc  b" u   %    Q' '#(!(")R)S*T*U+V+W,X,Y-Z-[.3W
e/di0i3djj4dk5k8dl=ldmLm\dnBndoEoFdpMpH$IqJdrKbz2nUpqIr$Js$,i]c2n@  }| ~}`~} @ },~ "`8tu, wxEҔU~z{t  }tl 
O5L5(@4 ^`ypJ*fԖ]W` dd];`
ff 3{yԡ  &WMR@ \ b Uv @} M@ U@ X z @U @_M@ . UH T j@~U ( ̀} M @ U< V v @U @_M"@ 0 UP d @U @܀}M@ U, F ^ x@U @ЀMU>@ b n  ղ@ЀWM6@ X j Ռ @T@ Z ~  @ 
	 @ * > R ^@ht @ @
@ F Z r @ @
@ $ D d @Ě  @ D d  @Ě
C$ 2 N@fz @ M@ @ b  @ )@!@ L ` U~@ 5ڀ@'@ U( 8 P d@U @M@ B UX l @U @S,@ " & U* .@2:UT l@5 @(/@ Uh   @_M4@ ^ U  @̀ @T ,@ ^   M@*@ 8 UF T b@vU @U @S3@ d  5 @ &@ UT z  @9@ xj @Ԁ0@ D n  ƚ@"7@ b   @ @ b  j @@$@ > H T f@| ̪@؀  M@   " *@06> F@LRd n@v| @ƀΪ @* A+@ U& * . @@FLJl@ @覀  I@ 6 J f @ @! Q@ F ^ v @"+@ j   @#@I@ f   @$*@ b   @%@J@ ^   @֚
& Q@ LT Cl ~@ @2j @'2@ * . N P@TX\ `@dhlD @ Ȣ@΀ai@(S@ B h  @ڦ)@U@ T v  @ʀ* Q@ 6 V b |@j @
+@k@ F v  Ě@*,l@ \ n  @Κ- P@ D P X j@r @J.d@ P Up  @5 4/@k@ |   
0T J@ p   A	1 t@ |   *2l@ ʀ   
3T@e@ & 4 L U`@~ U@Ā S 4U@ V j U~ @5 @
5|@ U6 ` l |@iiiiA@ @6~@ J jT "@S7@@ R b  @% 8c@ X |  @  9@ T fT iz@M : @ X Ut  @M;@ H UX h @U @U @S$<@ j  5 @$=@ Ւ   >T@@ p   ji ?@ R   @,@@@ h   @ƀ֚ A@ 4 B T f@ @ B R@ t  ʚ @C @ j   $D@@    .E@    $F@    *G@ j   $H@@    V@Ii . U@ T@hU @SJ@@ " & U* .@26U: >@BFU` j@rU @Y 
i Ki  Hi@iH hU @ހ	iL@ iUl  @SM@ b  5 @N @ 5  O@;@ |   4P@@   0QԀ@   $R@@   ST@    M@&T@ j   C&
U@ F i2r@~D iiiDiiV@ i&R .@HZ Uf@l~ ժ@΀
WT@@ D `  U@΀ SX @ V f U @  Y& F Z @ƚ Z @ D X v @j [J@ < B P@Ul @M\@ 4 UN ^ z@Վ @]T @ < d  ծ@Ѐ^T @ T r  5@&_@ r   4 ` @ U& B Z d@Up @Ѐ aT f@ : N ` Ur@ U@܀iiiA
b@@ F ` t* @j"ڀ c@ j   @ހ%dT@ F V r U Ȅրe @ ( D l@x @Vf 2 Ur @U @Ԁi@g@ `  j @(h@ު@ ~   Ii @ 8 d I@Һ @M*j @  5  k@  , >@Lt @ @$l@ h   @m@@ R   @n@ Z   @"o 0@ d   @ p (@ zj   q @ \   ئ@r@@ D d  ҐҤ @̀s@ 6 D R ^@flt |@* @iU@΀ St N@ 6 @ 
J i`hT҆ @5 u@ )\ 	rU@ Sv@@ @ V Ul @S"w@e@   S x;@   S(y@   S2z/@   S0{@9@   S8|@@   5 @} @ J l C@*  @Ԧ2~*@ L lD ~iҢDi @ @AT @ * . @ U\@n 5@؀ O@ UP l  @ 
T@@ H ^  U@Ā S @ > d U @΀i < ^ @ƪ @@(@ 6 L n @ښ @@ < H N p@ @,@ V x J @i S@ p  - i* UJ T@ft @ij@܀@ 8 P h @ @g@ : iV dAiiiiAl @ @ @_@ "U8 Z z@ @Ri: %V p@U @@  >J \ n@i| U@ M@^@ < UL \ z@U @Fi@`@  i@2Fv @1@ b  ƚ @@@ P n  @j h@ < d  @@ 8* F T f@iUv @i @ @ d  Ě @@ b   @ꦀ/@ l j  @@@ `   @
N@ f j  @2@&@ x   @`@ X t  @j @@ P d p  k~i ii@Ҷ* @܀iKi@(i0J@r @Q @ B ` U~@ M@@@ Z Uz@    S@ \  5 @(@ Մ   T@ |   S@Z@ x  M h@ h U  @S"@]@ \   	i @L	i@ ` "n@iҘDiRҸi@Ԁi ATL@ , D d U~@ S @ d  U @܀S" z@ X r U @ڀ @ Z z @
@ X x  @ @@ P j  @̚ @@@ @ h  @j [@ * X  j@؀@ X x  j@ Ϊ@    
)@@ t  U@ S@ @ V Ud t@5 @@ UX x  @M@ @ T Uz  @iiiA @ F f  @ئ @ J r  @Ҁ ,@    @ @@ F h x @  ޚ@ @@ * X  @J @ H UZ v@ @T@ * 2 @@@Ld j@ @ƪ@ ^   @* @    
> V z@j "@    j@ր
 @ 8 J d @ @ @ |   
@@ l   @@ ^   @@@ r   @ Ā@ j   @$@@    @ƀ@ `   @T @ 8 \  պ@؀ T@  & . U6@>FL UT@\dl U@ 5@ @  
&< F@T p* @@ Z v 	ҚĚ @ 8@ F h  @Ԛ P@ ZT i @S@ ~  M  @ r 5  @@ r   TG@ l   5@@$@ N p  C @2 " <@bv@iҨDiҾ *@ AS+@ F N Uj @M @@ J Ud  @Ԁ5 G@ UF `  @Ā ֪i4 X j j@׀>@ T ` v @  I؀D@ ` ij U|@ 5@ ـ@ *if  @iն @T <@ Z p  5@@@ UL r  @5؀"@ U   @Li
@@ 2 UL b |@U @ڀM$@@ ^ U|  @܀S  g@ J p U @ iiiiS@A@ H j U @M @g@ R Ur  @5 ( @ v   A%ȚW@ 2 N `@z @Ѐ, @ b   @@ \   @̪ @j @ 1@ > t  @ހ@@ f   @ Im@ N j z@i @⚀ f@    @
i8@ . b@ R@t @ʀ  T@ t   \@ ^   @m@ ~  ֦  @@ J t  @p@ f   @@@ j   \@ p   F@ u@ iF U^ t@-  i i  4@i>HT iPX `@fni@ @Z
i@%2:iHiUd@ S@ v  Ҷ@̀ @ P r  @ڀ"n@ ^ |  Ѐ4T@  @  S @   M ;@ | 5  c@ Uh   @S@ P r  @ЀC u@ 2 JP 2ib| @Ҿ iXDiiii( : B@Adz @ @@@ 8 ^ x @  ]6@ D b  @ ](@ < XR j@ِ5 @@ UD r  @լ W]@ @ X Ud r@xU @Ā} ]*@ UD \ v @U @S@ 6 L Ut @ƀS@ j | ՘ @ҀW]F@ |   @ ] @ 4 J ^ l@ @榀	@@ > T j @j @ 
 @ 0 P b l @iiiAUv@ @ 
@ >T "d @ @W]"@ F b R%@ @܀
 @  6 N ^@n~ @],@ N f | @ @(@ 8 F ^ n@| @ @]:@ X   @]2@ d   @].R@ B ih@հ @ T@ |   @]U@ ( : Z Uv@ պ@΀T"@ h   M@ '@ X Un  @S@
@ l  5 @:@ Up   @S((@   M :7@  5  26@ Ul   @
0@ . F h @I@ƪ @ ]@  " < H@N^v @T 
@JB V j @R@S" @@ j  5 @  @ UV ~  @3!@@ HN@ 5 @"@R@ 5  #@K@ 5   $@O@ 5  (%@@ 5  ,&@E@ 5  '*@ Uf   @K(8
~ @ѠѲ2U:@Hh "iiiDi@)]*@ . > H iU`z @բ *T ?@ `   M@+a@ x U  @S, ;@ \ j U @ƀS-@j@ V h Ւ @Ԁ.TX@ d l  ը@ƀ/T H@ B n v M~@  5@0h@ UP p  @վ  1T@b@ d   M@ 2N@ R z  @3T@;@ J   M@.4 r@    5@C@ . D X p@ @Ā
6@e@ F h  @ʀ7@v@ N r * @΀i@iiiAS8@o@ F Z Un @"@9 @ p   @ꦀ:]@ p   @Q;@@  ^  U @KP< _@ V Ub z @5 
=@@ UJ f  @U @S >@@   U $@Hfժ @?T @    S.@@p@   M A@l@ P Ҍ@ .B v@   C@ B R b x@ @ Do@ R   @"E@    &F@U@    G@s@ tj   H @ ^   @I v@ v   J@`@ j   K@ r   V@Li 2 UT t@ 
M @ 0 @ H@R\f p@x @ @؀$N@ N ZT 
h ЀҐ@Ҧ ڦ
O@ \ R  iȀSP@@   հ @QT 9@ B \ v Ր@2R@@   S@   TTv@    S2U @   S&V @   SW @ N d U @ CX @ \ n  2j @
Yi i8DiUP@nx @Ҽ ֪@\ Z@ Z p j @[@ T z  j@ʀ\@ D P j ~@ @] @ @ `  @Ҁ ^ @ R t  @Κ_ @  , ` r@ @
`Z@ @ P v @ܦ a@ 6 `  @΀b@@ P zj  @$c j@   d@@ < R ^ p@ @΀  e@@ 4 V l @ܚ @f@@ Z z  @giiiP	A <@U`~ @րh@ X |  @
i@ L r*  @րSj @ < X Ul @  @ik @ P ^ x @ l@@ L j  @j @ m@  *M "@Dbj @nҪ@ h   @8o@ z * @h@܀iSp@@ R d 5 @q@ U~   @̀  rT @ ( 6 H UT@j| M@s@ b Ր  @tT@ f   M@2u@  5  $v'@ Ղ   wT@ v   S x @   M y	@  մ  @z @ iR Ti`@n ֦@ {@ & . HM>j4:B J@PXn x@ @ M 
 |i (@@T r @}@@ H \ p@j @~@ J j  j@@"v؀   ?@   $@   8i"@   .j@    \j@   @@ J p  @΀CT @ 8 L  Ti 4 @i
(Di@b)Ҁ@U@ @T+@ Z z  5@@@ U4 L p @U @5@@ AT t @j  z@ DA ZML Ud@ @ @{ $ D@Tp @j N\@~@P| > h @ a@    8@ V   @  >@ h  O_M@ @T@ > L X Ud@|D Ā T@f@ : V r @A/aMҀ iiiA@A 5@ < P j @"@T@ N n z @%@%@ 6 R v *@؀ ST@ X h U @ƀ5 @ t@ M: Ǝ v@Մ  @ ;MfWM@i@ `   @"@@ |  2 @i
|@ H `@j @ @ V p ~ @>kM@؀ q@  , P t@ @@ D b  @@@ h   @@O@ P z  @ U@ \Ԁ  @T{@ Z   M@ @ P j  Җ @@@  . IM<@JRls@O@| `h p@x @ @ހJ@@ ,$ ҩ:J^ @@~@ U2 J b@ղ @ T@ > ^ ~ U@ S0t@   S@@   M 6@  M @  5  4 @ 5  @ UN d  @ C@@ 8 H r i2 @@iSi
.@<)B V@\aUB bR@bv~U @M  @@ l@ Ֆ   T@ 6 X j U@ M@ @ < U^ x @ML@ Z U  @M@ V U  @ʀ @T@ < L h U@ M@@ * UN v @΀MU@ P Un  @M @ t 5  @ T f z@ @ؚ@@   > b @ @@ b   @ )@ . > i@iiAJUl @5 @ @ "T x @ @"I@@ n % U@Ā " 6 b v*@ M@@ R Uj  @ƀ @6T@l@ x   U@Ҁ @i @@ v j  @Ӫ@ v   )À@ H p U@ M@ @ L Ն  @T@ z   U@ ƀ@ . 7F V@l @@@ b   @@@ p  ̚ @0ɀ@ j   ̪@ p  @ @ f   @<@@ j   :@ x   @ @ rT@( > \@|U  ԨU @̀U @jj@ ժ@ , > X t*@ 
ҕ@ƀd@.-@ z   T@"@6@Sр@< \ U| @S@@ > \ U @΀SӀ@ f  5 @Ԁ@ UN x  @M@@ ` U  @S, @ p  5 @"׀@ Cp ~ @D 2rU  @ i.ii
J@ V* b z@U @ҀM ـ@ P Ul  @M8@@  U  @؀M
 /@ < UT n @Ā ܀@ @ X t @ @@O@ d   @Ě 
ހ@ N l  @j @ߪ@ 2 B J p@ @@ P x  @]@ . J vj @ހ @ D N h r@z @ ֪@ހ @ > P b t@ @Ԁ 
@ 2 F  iiiAUZr @ @娀X@ "l  @性@ @* h  @%C%$ B %^@%j @[@ , B Z @ @@-@ > l  @ @j @_@   : ^@ V@.3`  M @A@ B Ul  @M @k@ 0 UX l @ȀM&l@ h Ux  @ @T q@ , 2 F UZ@@dZ@   =F Ղ  @,TK@    S@ p  j@44@   $@@     @ j   o@ < J T fl @ T@  $ * U0@6<B UH@NVh Ut@| U@܀ &
  @  i&@< Ҁ @T@ > X r @ U@ L p  @Ԁ{@ h j  @ @ t   @& f@     @ ^    
m,@ Z ~  @ր
Km0@ P Cd Ux@ @2 O
m*@ 4 DiTDipU @$PnP2n/ /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй 
Us# hNfP u	fXc  h UZY[Xg&ۅF ;9   Ã tfPfS
u	p  Vf[f}XRg&u-g&
pAgf&A"fGK  KKf105vg&ƳRK9g&PESWVfW&O*f%OKg&D= $ <vD# D| u:t/T'_^
QRfU

}0tRR>tKdmtE$fu
j0t0t	dp.  f]ZYPSRi uLHSrL&jmsG tu0< 0
Mg'fA$. +"(QwZ "P  u
P! 3 t
 SQV3Ҡimxjwj  :imtzffKfxj AƜ(Y)9wfP98$Њ;`	PKXjj)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>~+A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
cmD$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	Vbm kmff@EFt!hXUgvuN>tO6f뿢bm Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% cmSA _=m# XA	uwjwj>I&BKZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@߾)RK )FbfDf% ffDg7^Z# j^00f 4sp*2{É6^^nBn@& 7Ti({Pfpsf
  @WXfff:0[3`6'E8q4ж3~U L؇gOS?NYY:YYrZ1q\YZ ЍSpk< w !			;/eE1{`eR#tZV(oQ`Cʕ F%frQfRVmmu/(` r'(>  4
P  ~
 @+=h/( Q   f3۹ fbdTt ` 0:Q ?\^8ZFfC⁢PS@sw$yk{s>
p"o
d
\Ku@S1?"5`,KuZ'苆FFLKu FQ$Pdm$G^f  @s4j2jgOH^D	%߉D	f:O"-fp<v PfUJ?f@KfffQ$f6f> f	>fBf0+ff]X߀ t p,rPԁf_z0R0Ӄfw3 Z`R҃>/ t5  A U@@!`0ӳ
@lAԟGRV&H:f;tff) F#$A^q$e sqSf qgfÈ>  fù fAB;t)gf+ C kB;PEQM`?k ӒHGPV  ^ h2 ;uБ;~ ;b 6P6UXfm.0XR @ y  	`@  Q}o+p+ r3!B +!;PՁ  UVEWT-.55\EFGG-8. UWRQSPV@3rw+t ur6ffWRP0 eXh<fZf_;>+uƴ+kmaPS puve+i@g+j+a+U/xklb+znmc+D[XF f sf tf[ Ȑ![YZ_]e È++0_Q `+ cmPcm j0fdqtu!+! !ddfd԰  >P6Sd ddP ʱ(++ fU0t=T=f]t,>@u%ttt t	tfsN 0Et@)r@ua`ln)s
 1Qh 6yMuFk . u${
VێeS tNrt}ـ?и{D`*fdofeT ff/fXs "qy#uptLe|+ ` }+ uYpf3f$ fe|+'NfWpe*&|+8fw*fF*2t*܊e&}+fXAf`PKem)'*!(++ f?꤫"Z  Āu(!`v]+6R p(Q?faSQVWU&dm tdm ui]aLS-120ZIP 25M0 RV:1:o2:p2o2PKp
>w
 z
\5	d+?>s!hErg;<tV< uWQ/f< Q:D= uFfG(*X!X  A0`u v+Qfmo+i+p+j+a+v0 RW1h
ȿL} tEA/'_Z[M-Sys   DiskOnKey 1 #߅axBgm u @  f<x fP f0Q1"%|= 2rޒ 0w"1{s ȧsU3IH tuRfQf@fPuLst6Lu2r)g&	ug&g&oc\,f_߸ PA߉ rLTf<Q?GQkRlRQbV`cF5Qome}?70ޡ;0hkt@ u u#P-3RAf?LfHS N 
1f_Xuײ?D0 @0UzB0hB0nB0mB0cG05F6F 	 x&3FPRrco3W1>#>;!2>
g>_YhhPhN`p&P  hF/l cZXSWw` 1s!$?
u$[         Ұ,X @x^0 uY rTB5!0c@  i|X  t衭   ` 	bho4<fH f5f[0cЉf&^huf{^06.f ff5fP  5f%k@ף% @ B5f  z6f5f=As&  ` AVfaDf=%t 5t;@3tZ0tZDfځX$g];6  5I5Sf@ t|P5"sƑ tDf q5ߡ5<5ÿf>5 u? ` _D  2ft.0c@P +rfmu$5@s11 >W5@!R05'r"b""0  ?1VC@f,S	  tX	*riH'	"	0 
%9 uf-%tq00 P35P J 	P5;tpa '	5 1:  rf 
 pQDP؊*5@6Pf>5gGf	gOg}{G]`db>:d"3	0	n5
`6@#Du	%&0cf65f	f 5fIng^g׊~W!
*t4h 0A		0	  FFhiJԆ<t
 &I5q*p09u
 'X*؃ CI&I_5&IqN&ibLҠ6%@( 5f (f? 42a3uf5W  bf~t0awSgff95u gF95u 95u
gF95tgHNXfFW5zr=БC=m0rxi?GsVfS'`c(gF'	5g^ g"G0gFֱ V*	 /e*emd&b&g&g&G
0G
 dЪGd*PGg&Gg&{G
 G 3gn Fpp5t	f AkGF^ 0\PfV csf@ܲmdf p^fIf!5&55+5(5  5 < t5  ;vȉ5qv  f@
BqygfgG p ,gG
	q?Gfup"a ?Hf%ofE@ !gG!&55 t@(bk!f#pF❪cn`_fOB'*PR7з[f=S
f3̰Vf$fӃ\Q?fp#{-  !Si y 9t ````aJ`b	`c	0]	0^	  
		  
							
 0hfWQ[f`!Yf_`њD=fr+D=q+@D
$>g+%
ĈD
+"r% >q+bASes?+rI`d
Qr7R|= USBSug&|= t t
U	 	`+cTZ +Qޡ p arQr C0& %r{P`6@`2P>+t QrIt2QfF`AdYr}vSf1fM^!WA@@H\
؀]e܉\b< H
p*rQx @
`0
!?
x0
"sTsq
aWa'"CS# iD=qp*Wy.?43'3PT2' yoZi(Z
2_(
_7
__=%t9N R$:RS$2Q	@ ?VEB@RP2 3* h >{Mu x T=
XS<(fT= & y#j6~+~+ r}QtA3`>|+|+p+` pta^Vu6} }+ +.ZEf.O6VEOPpYfX`VEI|G<`+ fa9<?,B3U+*/G/%QfPfph`1@YOfXY"?N0\;J?;G7/Osc`yMoDABA<e=S$l{=38%rp-+Mt9 MtE MtQ+D$
ƈ+DFP!r r
9rY⹖ /Ρp%tFPtt=tT= t2:t+u:u hN,odty(u~(_rt{^@M=@tM=tM=`	tM= Mh1)6`oXaPSV+8dtdw}mޠrgla޾+8DtD$PQ@wHPhBޠd<^[XSQ?O	8t`g	G	Y[L0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGH?IRSVݫ      Z *8۝6TS!
  	b.>  
   UKUK o      2@SJ[PuK&|KО!i$ru
>uKӉ * | > X * t|KxKxK>xKuKu UKFϰ'PSC|rzK$+zzzOKuKQKwKΓQ	`P/$s`
3ۊ `"K&K&K L3} wKpVSbm@t	V5mߡ[^@pVcmTK "`K1m!f4 uՀuq!S1-mNKBMm68Հdm[^pqq?fUo>cmimS>L>im܊&Ldmt(
ߠRKcmZ SKK[o@vf]AA`Ft>}K{K r1K{w%0r
 "cm6x҈0EUK Аh6bKFdhEYQ!R) `* ~aӀQ	k 胢pt1Kh[L!rL&jmSK_imLfPSQзKf3fY[fR~Kff3 뇾0pfZ2F E *  <FuL3t	 Dt<Hut2Ot~O >Ȁ$u tPaX]L Y7K uB<Ft<Tt<et<t<t<Rw*<Ir&L
2@&tO>L`O4A<quriVW@ξ HtAQ Zft(PǴ:Lu 
  gXfCYPqq q9~ w2LkYϠLDtߊ& L8kr >taRw>
$_^t0%GKLK IKf? t<CpR<tSQLذ&Y[ـ u
_lqpJ>@I - n ig8   ` T 8th
   0  p 	 	 	 
		
							
 

 } fWQf04aQY`f D5 ,+6]++sR. (,+z0SD
$&++
ĈD
 1s fg&|5 EBr`jr  a`fR))	\	n	MvR`UR		`RH\
|*+
\*se bSQoaS}͠ϼ" cc͐Ă/r`y͏Ј-̈́&p_W3
	#rgqWtX0Y"@ fU迹Դj(rjdyu6bDq=UcUUpfqh		Yv		xvbF
 T `& !sJ%|=td%"y:ur?rpq~!(~rg2oQVfRL	;t	]PAϦ{=}^A QΗ0   0   ? RrE d    n  A` P 00 3`  
& Aa %  	%
0 #
"*!
 
3`@& <a`. @@ 
 b
	 CF
? ?a	 "  d q@a	!?@ % %@%
 +3F	 
+ (E+
3$ 4̂ C8 $+(3+-E-@(C -029 4- (`(E E3  .c+! 0
  @/9F. 7'GC@<6A6D
!:7'  "J",A!E?9B@,3
O<bJ# 
:QT S<R"G 3D%M TVaXCJ UK8'(XAIc  WI Q^_^`FaaAbbCopyright (c) 2001 Intel Corporationf`@ f.5<t<t$<tc<tK<tS^f&^2c sf^   uh   uRRfADf3~8w0=ISGuђ۝ s
g]^!t f6^۽	ngftczRa tpt5H0c @u  u uϰ0 ߰# 2  P f%ᘅ3 
f>5f5Dt	u)f5%;5wuf͸@ffhitff"Qtpѣ
0f1sq
B  iv@#tz2910!<ug


7	uu\	Q	'h/%_5Kfo65	g u%S F5 s@[%;u!,f=4R0	ff4	)fgfp	Q(f	f@f[aSfSfQfRfV*sW2c15 uBT tApN@76g88fI4g^f3f@70	@7f^fZfYf[fP"Vf
5f=}`Bt"f=Ё &f= 0//f{=0 3f=@+=t8t34 , 't"#
ttf5c0 rfFP0fXURf.  fXr{  	 QfpufQD8@M TR2@(2Of2f0cBZ{RO>V\3h/(W Q  uof3^fbDf6E  Z<tatG@]_ToKg<u	.upWJ$< t<0t$ RHP?y"UPWT%j_uPlAP#,RfWPR;5rfc%1f f{>a-	f!Effg8Wu#>_444
f@[Jsf_,,PSt{wO&-1=`Q
Yr;f.;ft3UufOf!mpf|ffm fPtP= v	 +v:P,P}ff́   :ffvP ̠ 6f1|Ã tL;f ǰ;Ptƿf Q.fB	r;rf@u0`b hJ0-Ñga	rffqp
C	_f`f"0~ffROMIfMAGE@;uq Wt#g0 yKPQ (J 2 ofG f_ZYXug&wag&GwG0  "2/t"t:  V   scu'[0i&w zj3
G94g&GGfԣ f}Cf-+Ӹ00pD;gfg@ h쀀1"`W, `П..`B@ԑ
>t1a   #i   UP A :Pnj>jFjNjVj^jfjMSV.>bm tvJj^>Q PSQRVW>vjujSRP#u<v
@wj,xjimujʀ 7UmG r ) 褵\!ujјP뾼S	%x
vjvjvj:ujw/:jP
 hN/L	c? tOûde
	jjrg&w0tRj觴}rZjdr!"BjuKr
? JthE	/CZp4tĳbj&=2ohsg13
	ucmP $cm} Xp Z#,_莶[$$O_^ZYe**=	Q  !   0  " ("2ѷi /f+Ld 4'=m$7g&* 	uwjwj w@MKm &Emݲ`J}"p,@vōp-s0D0Km,0$ 03۰ ɀw%1u> &
'$udmuvtueu^]\uMu:8FPu)ttfu,0= IׅLfg&8!<u	g& `=FtF@sPVS`@m蛱O([^XSRVmWOg^__Cr@ޕ14ZbUf%0ѫk$返[]0)R Z_oR Ն oP&abpZ&&FdR{< u\_R\RgtXr),u@TRG`SQr9R'$8t迠܋Ytr$V簄O㰆HAr(bgFr^(!sqtrp@pp蓶q9``æ  f18 f܀g'0z  pj FFBZss`b PQfWfVӝUU~*nЌP U 'hX+Uu'UG@J  .;qt3_YXh5  `#`Ⱥ0@^	p0 "' J@4 "`".im2'.q q㐰0 0!W
sfUgg& suf3Ɋfа ǯtfYVfWsg<t,zfUgR r!8tfG^fZPQ71$@a@8tPQqUvPKtF X PS2&8tp 6t؎[XPSR8tǎaAf!.bSRغ P BDðð1                                                                                                                                                                                                                                                                                                                                                                                                                                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              -                        i ` .0   $ tT _ a`. u B KSRP t@B u$Z[SfQWP U@ Xgg_f?Y[f`Q
`/fgfafQRfWPSf3f3ɿ f0<  P tf; X tDt [Xf_ZfYù@ fPffffX,fVfVf   E gf^! Wf^	V		)			:		/ 	^		f	W	~	fWf	_
g&' f @f&f_fPSQWV!  tOtъ#,"A$,hfP u	fXc  h T:Q sY~^_Y[fX[>uDo\O f`8P%,Ⱥ:#%z  t
ف     tgsPR0@ZX t(  
7Xt
 %@  Pé t u>.P. q tW`@ `30
t%%tNtG!ȿ f:ff3uQ1ffff#f  
fA* X 2R.Q#؁ ~~	c	%@Q#Y3#@!` ZY[XKP7)5 2 &%?
 g#&Zp	b
x   uxҳ # r`u_
 @I)
 ):)@,b%蘔t
<%gfZp'%Q @$f@$f_#$S% 5 Aq p#f1E P
 0%3ff W0$q# %3 'u u
T&qf+ZYf1PS&(4 :(T T,(h|7t7$5,ؒ$ht:f fg&9R 25  -'4	-'#&30s'؀P2@uR`'tt@t
1ۊX'guf
kTP'BA2 ` غ   nBnnn`tnJFn aS%0g 3ێ7!C &?!Cu3ۏR .ZAkhZNÑkPI趗趒X襗%ͪ蘗$來&IIvĖ>&o߭ۖ.Npu	  Eu)[
 yVut+t8QWP3 PXhX@.X=X@uX_YPBP*up$ q+!^..$> u
P ;O%@Xuð6C u@B T As4gmg tHu.g :ff3g&ffRlQlfffߋgfffT5<(.&gBfsDP
hEi!E9
rCfRc6U f u

m(
_uPMXO0fFSoQBa  t`tVwp Up `heN_t :Q j `ճ  a`7Sv)[C vS3> ttG)t:G)<?C  _[0t<w> 	8tP 
 
ñ  S r Rt,  g)q)l)ή
t rֱֲ5б 'fP	RA)rA a	 fXѲt{$3hebP	4Ӂ{@t1-w&ؿ㋇).trwRait0
p< t
:@ 0  ) >@u*t)aÉ  Hq!y

}pw!lIm!mJ`!@=!؃@P+!$!2)
s3y@s߃i  Y ,
1F0$B:u;pu;thPp{-!` 0Iww
210r &	&
À
vd >Ͱ2  ,22#в0f2ptE p  P+Gho=/3  PG4ឃtCfҫfUfqA qA P  u1 z dhQ)
  '  emimoh+Ja)f@$g#4hPB b
p׻babRPp  ZPQd4 pyKqb  Y0Ri?m h\`	
D2
2k.&[g t#.[N' T
ءt&*10 0 ?RVhk}TtDh^4h{fsh1htr2, f^fZf`2 W{rb2ƾ <PfTvg
hMfa@f`AX
Rf=VKPf3//n?fXf_f!7"" h䣪=Qf`/)
4/O
x "	 	 R"	/	(	!e&!_!!!p!hY=DÓhx$wG	}pɭf뿀fP̺AP u2fRt F<tP$rf̐͐3dts`fQVWþ4¹ 0 _^}TfpDfբft
t%S0yM5rSQ?'f0@[^WSQ?RWVh]?r=ыt
 t
uu	  tt u^_ZfWV:Eb3:EF c6W p 2:> u6 GHt\o hj/TT3Ҭ?؋h4B^_fZfwf
XK̈́
>
2

VT>T2E@OHp
Nt.
Or,Rbǰq<1`1/ 1a?`o/ / /  O1<RwS2.}[piø   а?fQhZ_4ufYpډpډ;aEf3ɋPp`Xp&G     &Wft ffBf;Pgfwlw~rtwR{tpff@hp3QgfY t?gho.AAP0Y[0U>aPS ?2he&Wh`2f[W  ɿ   `    {Y࣋6)Qf=HIBM)@ u_Ff!3 g.9u
g.RFfkǿF "Sf= @t1pu  ø PF>Q f a	 p| a!NuFgf~fsVf  t
fP#fffyg̃fY#F$AV f;s	7f
	  fV2~(Ff ) f+s
0	@Nf;sfȶF@	rf@f qg&g&fFfGg`^N &Vf 1fA@=uTA$<ufIg:!
g
@tT	fƹ@f t7> u  $ۀ>p u0;R`_詚b_2Ӟt+!萝连t菝2#諞tP ?s כ`tjh >0)p d{u	qQh_S
XP` u9 5&r/<t+t&u
$&uj.~a@_ʝt"
q2t = G Q !胛u!u߀">`&Yt@ 
@A R^kbPC4@QfAFfL6f RsO\ b' P@/%RPh >ft	 7f%~PfW~,GðX<t<t<1jPS$<w .G}#Ҩ 
i" ߹  6   #` $ a $ m5!j	[ )%frVrVrVVTf#f)$Tf0 
8!T0#kt  zS`Jff3f[  o.fPٸڻf< h}ɡe<w  `a fXff
phEurðGk
	  4_  A*Ps
ĳP LXuB8Dحb=
@S!^ uf 
 	 [
>2P 	X		@2{P2
tˀa	
$


Àu	<X[XQp)a
؀a
2t  P@<KrKX&&)&4&?&J&U&`&k&v& @RTX\`gvkpvzptw}@DJPV\n@DHLPUdxxegikmorkpuzlov|`cfiloCEJMSYlʥm^ZVSPM &à@ PP p} R,:%  3` ZQ!Ⱦ返  a0!CU0s'333 PR?'Z0 .' BZ s  ""
ZP{Ob'b' Jq vJúQ R (J
PBX
	SRذ4QfQSW JN_[ҋ6臃1I葋  h M (I7QW
y *{ n_ ]+z *j|"ц3~.ðUhƳ|y펿(1!  x\a)% Z   *
% ,J,◳ 䳐0+1*D0 *K}! 1% )))))0a+wx *\ 3u)% `0.&,i*ff
 Q 0  y *of`C4_ޠt51df )*f2h?h4h- faS\CTNI )ff(yf͡ŉ3 oc1*  >Й z &**2 s 28s  c @X PSUV<2v2 Pظ? $pY 2h?$[. t>& E^]hYt2 	?s  Atiu%thu~<蔏r7,; t
?+@cT`@u`
 
зY@2+
{q@hPh`\,S rS.p,Psor֓~.t 	Ӈr质$Mu_hAοeHq0uJOΥJh2f.fPDf.q [h? !HŰrl. 6b lJ oh?fu@ @}h-.- 
03!4+t
3NO+t3GNOUN---&N-תP aT-SR--``Aa a$fӃ*[QXf퐲fXܞfX*fX>ahk56hdNtW :Q j й (~uuu&gq S0p  o}S[hj_e$PX! h<esh([UvP/F X PS2&/&/&/[XPS2/࡭/+/ ^;^`à[P`[	ï84?8x60Z&00\AYDZ_4ZRL0jo Pa qtU X S8rdd8r1S<dr
d2itSp!ĹStT@YcǸp1KP0l & p{pW͊&wX P~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               i !$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( A-(     ښ   ۺ ς  g `g  h } փ 
  ;p  φ  /  6Uh7 Ne[w"79 Pg~S         
          %X%H _&                                                                                    `*} ` PzQT@    U@ U	@
 U
@P UX@Yhi Uj@klm n@o { U@    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`hfPu	fXc  h  fUf&af&o>` 6a  !žX[ &SP`@ /'a&&@r
f3f僰gf祸 }f3fh   @p h &yïf`f1fff_ef  ս % ŀ-ff0M00!0)ffXf9ffaf 
  Wfi@] 0 m q  ,f5q f{PeP ՁQ   ͡Ap  A` e_faa  !6>eуp Ń wPك"` eɃ w	
e} fe&` b "jeffefAffgd:ugdfepf3 gC)T "8fF3ۊde3 
td	  >p) @ 
peuxu._RTC u:/
'
%&bfgfd.S` [WP9A`XP&EX% &߈E_YǓ oooooc׎B|Mf`ffP fSIMWuUfg0f[ Qbr6ώfc;ڟw(h,UfK;fap p`p f&?SECUtC)fuDfQpR Phj\g&XofG' 
uRf%38 Su(vg&_-$8GAxt8x 	Gt+S诟
 TT<tTt`qh( R"L@	=p3%=u 	 =
=uwfEOFF@ Ȁ "/ffw	fZn& t
fWf>f_r2 ρf$g&P fg&	rSfQfR` fGtt2t~tyf  o f!f,0 t;fm@ 1^u-f rFf;r>1*: t, f {ur%ArQYQ	 f_fZfYf[   t}% 
tR`A
A!:0._2 r&4"

rlr6SV9rP#j   t
ff;t;0
 + t WD@@D)^fZY@ =pFh^1hfNt k:Q j rwp	߾	F u ff!` B
fffLp 


ghghNRN
@fPh1hL	fX
%3E# 
t3 v0)Q%pJh(/WG!V< t6<{t13_:u"FRj*:+p;) .fY (7~@ w.	A_S 
fUfp>t	--


f;+ f
$f]^$*##^# -gkoXvPK? Cn@u߀%fzn  '  
Pg$$$$$YcXW@Unr]oV-]Q ]E#]^fRgw&gthoTr>Oz`Qhxg&iv
AfZfVfRQp&z EPnffҠUff[!>  S3˹5(FffZo! f	߄	Q,/Y]^RfVQS&>f"
 BO9BtЃ#уhHTQ   7___ [Yf ^`V/#W	 R uB@ p)=3`RQ2Qr+T 
 ` "	j m0_WVSQ  2ۊ0WF+ؾ8u `:	`YY[^_fPWQt P X6	fY_fX1E  `ffYt$Yp$ŪYr  .b
../ NA N{fa
SRVRf﬿pr؀tU./?tA
 NUNh)E^Z[fP4PSWR7I>L u&E q LZ_[Xðh_NÀ> t\mWS!Zfmsx;踿P0WPB_@uX bQ U?DPRBZ B潒 $ `%>&c%	 
  3  t!  {    @u#?2h2_qt`RW0?_r @Bx2fTfh)?iAf`fffs$R8 fZlI@CPRrfP@f&T fMf!`'pS'b'

R)	t2*[v.>i"s aPQRpt hE/~zuZYp5ݐB!C
'@hd1` y y y!y0y1y2y y y/fW j@< f  t"0Gbg&Gbu" uf   wκ(/ 
.uf_ 5`QP    NuQaÊa$$
a C. PB _B;ra 5Q8YGQ33@
,0Vu:* : , +Q2RWĺZP 쾘,ȡ%π:؁ 34DD4eD
 <'G  EJ}JJLJ I 1J3Khk?%t$hlMwM4J6@,Sl`DDDtD ސ(g@a HF@r[M̢t"s@#&̢>wG ^h.إf
$1!/fѮ2%  
 0(p!P!q  f 
 0XX!!f`6fgff% l gffP  R
 `C  SB"a `n#PL\`# u8$Ou0	u,hPuX(qtp֣6E_ҥsڦf`_a  6&P&ޠ~``X $Sv
``.f&r&&r!Br aPѧX
䏀  PfХ__a}X,}10uff	<u q<u õr$Rr Zn&&a=2rr]rN a`z7da(SvxޑQ`00"" QYoagIP  r&&PGp'] Ob 
y' P"S""F"&&[Ra QbR ~ ZQRr3'H2't2 `2ٵ9!|w5 t ھ'TZYa~r#S-EnR-Y03|pٸq4 ~Ṁ f & pZ2 &r豂r8t32`.P&EO h?,啊QtGS@1?Eh[&M.R2tް$P8 	#h ,5 ߃,W +40fR2fZrQ pvw@5 &E
, #!|`e	Ag	2@ahj
D%00`P 0丨S%-  D c`6(     V魆į^`WП 3 _r- + fDZE/D;Հ B.ЙB O B<`<2rru{O0W2&*G_YS	 7&*,u&w}Z`E1j_[DA跼P`QF>  0 2ۃ<OtY	B<{tmH7;77_rPBBLѯ: r1 r,q h/cd8SQk
peat)|$<Pt+fhKuhqiB`UY[Qrj @"	ѴuBanYoof_	V o^W mQfR D=F==rN|UtG_V !m4^t1Vh_~5fƿ^Df`  DP  ; Z x     0Nm0 =$
du	q 42HXҏ	 _ HeȃISذJL2ä1' EN~WSQRfRBP' w	.
Z0"|+a  * )aʏ$t2+``¨ѻ *0hCx~rEd/(#/J+('*f(fYyïʥRhgihmlf>QP?H_u(DЇ/ fP  .Q-r(qQPo-roSfP>fVfWp(>f1t 3 tf4}0Z f2 ? fff!2g&g
fKfRg` gr=e hջ5r ,|`VhݟZ,
-f_f^fZfYf[  r  sRfbXPSfRj07W6uLt;wEf6wfQHf8 r/f`bBfg&rf`b0  Z[XfWu
 f۸ 酀> ff`g@? t]ǀ t_
t@f?
 :   ), _ 0{f` ; 6f<rv`gGwf3ې fPfcfPr:p> ff{0;w!fVg&f^ufFztf΀!Q. $pft QOg&$9R<&m=f=ATADtlf q:&Ǉ  p Us  SU3a  |b |1  0|3ɊȰ	j q|UFWP3J XU .>I^   ub w>u `	߉`	|zp$l0|{ޒ${C_AR,.S+`r=[P<ం@05~0+PQ>(ι c r\d`1PAtC>r-t`w r uҊ1 r
-`u`dt[Q rdItf s`A$P3fSRNr&r!ww3҆r r	p8 8fPRcq`arNeeQbfOQ蛄 qPQq	s
d pr	rqUV>R5f   dgfY{uwR Z }h`YkzC Z `.P\ P " Yp `2p",u   P? jR

Z@u
Sذ* o rzQ(`( ]PS  I 1' RR  rX蘙DC	 4P>tS t33ېJ*bjR
t#4 c ttcÈ  PQRWV<<+3"aO^_Z$"#Ϡ[1$G<kuo$V6 4^Wݿ _ 1"  !(H 	
R
q0xtJ@y
g&/ܱ1q;-rB rt;AgPR(X0aJ2uނ RV$rN ;rCr<,	r32Wt rr;w}Ҁ0sڋ^ZW
   е0u
˿   
u P f! uf _2 J3322t@@ 0 	rn
$	"
u߱d;sRZ3QFqF2t
2t	u˸
S_ø
_......k6 .2.ޒD@VPCsm\3 	p45
	
QWfV3 ~Zt-[|`AfyA 0  ^_Yʜ.yfUf.6f]f]** End SetActiveDisplays: \ PwR$nt5< u Q)d_p;t  _um @Ӹg $tuQ2tN
͋كP  qs@t[dP<7 t  ~GO
 \
R 13t0	p $ D 3pbbwUg
10  Pk0l0tˠR	gl9ox{iPpiPಉitiċ؀ yiXqiXWi0PS_R>POJB(i!``$bPtQiP _
@	hXhQRPSa[X3`Ga cB"c
rQ j dK f`KOu$Dhr
u.2*q	,rp$p&` E&]W@ _fa.A4t
~_90???qSQ/"SWUg]aكWXð Qc bH rtp	{SfQWBmVftu VAC_!p@ ; t%ЮPsP`k_<_Pfgf2wg1lu=tQ SP܀Q$~XݠfAWѰ W6?XWqHȎt/O  3  v _؍`$at`ZON@a<@COOw_ B   
 eu$$t$
!$$qh1ϭĭs`9t4>0t,pz uX?/aA    Pj `   Vs D ` d h           ػ B @  b  `@H`X \  HTܢ3L_4 5W0@
@
` 1.                p   Z         14    XYhijklmno 	
@}
                  K _,89:u4NNO  OfhXukWӬg&f0Qfgf&c@OZ	(Gtm0pD&Qf cqfRVW f Q  !Q  A!!ȑf%Ŀf3f3f.2fff?u_^fZtf":Q ء f' _ſė
f0pɚP3XPSVWfQs: Lي 2u ufufpv @uf  fY_o^[XQfff
ff\   f f  ECd4!'oŇf_Y"OB CBbR5   ˠ5 < li < 2<
 1 a                                                               UPRPRVFZX0RR30ZO                              ݸ Ѝߋh3 QU #Pl hpOdPfB?fXfXU 6ø0Aq  d 	r ٲD$zSzT0JuĽZC HكEIڄ#
Nf00ffЂ f+fMh?ff-E	ffófq1  f>PAMSuff>r^0܍awS0GP(`#X>ϸ f|	!4 "f#bRWVf1hfNt :Q j rY  E6fP В hgh-rk f fh1h^_fZÚ
hkLt.?rB q@
E<u@
P
`?fat0(B"a`蓅j uL$<tD"pCQ.Ar&=t&} tV" &GF^YՃ"
\ؾ$aþ 	 hyy+
!
"9

Z
P 
= ϳ h@ ( L P~̀R ĺZSRغ0 t߃@ZPS<w) $w	O) b-_7> tU@)uR uI cB<t>t9u2[r-r!\ Ltg&G!6P _  SPLtZgtKm[r3 Is`0$
O @O i 2ҰYhG?"rbJLttX	
~   SQVȾ@ 8t"8t<r5^WY[At,&
uo>ut
$sE St> u. Oþ"t$	&
s@ &
tPIۇ$	>!2
XYt xSLu3tCƠ ƐP !Ou< t'$ } 
uGa>؀
	 >t 8Nt0PW'uWg *8r$- t>o uBu
 {i  (r"1t {P]JbSQPXtV
mr0.xXGǷItB0}D0.9r,//Y=6uIt_61tP rB3vsIu%
߀u "786 W56cC$tzu 1طctb;sW;sQa+Vu	Mu u"
uPF"
23VC2 i àiڢ,20t  w* a2)P5tXSfW@0`
"Ht`D_8؊f_[	y֖֔1fЗsg]  rӔ
ҔፆØ1# fPRfQfS@\ff%|h f
 1Ⱥ4A0# uOf3\ft(,#%9t p!! t1 f=0 t0f.ߗfEf`° f[fYZ Z! 4BܚܪݨԀ =s݁CfW  u8  *t 	35faf_À <fq`<Zu& ?FryF /<E@ h^,f`ՠ`ѿ{ppP վf``%
&,ú:cktGJ'f@#nD A܇ͪ Đ /DP1_údߩ u"vL " p t 	g	Tf@ @S< ( ːÕ ـ@g&S%Є &M!# R%0(+1#A~R-f#f%+݃8` $B'
 f 3Q'
f~@|ZS	r 'α'~p
f|1 ݠ
Fs!=qfYfĳ & A%#@3BS؁@2SCV@p#t6& %f&ȿ ffP]t33u^Zfp
Q3һX3t@s7riS
`'`' h%SR 
 * 40*B0T0	f%0OJ`R3&$R P1T2沬1B RfZä1/ 1ʬЬ߻Z~!21	H0v0f1 1冀1jھcqID1˭,Ou_WҶѤ1\1]1K1(11 1eeKF1C݂	tc</	f.:!u@<zw2`}РOf&@@
BS&ذsyMrrM&([+P4!;xV4t? u+_q,[ff[ bqKNPJjKqB@w؎@tA.' u6`pr2"ffhٍfcs
2|8>.h g,fr0kfA@fP 6fAliqm	sdr
h1huzPs6GjhiIr d @ hsx0WfV"D pR{w`tf!SYP`R&Zqf^ R_'i!Q,ٟ!֏k#AGvà;0/ABSOLUTE=WfQPg&	0tffg&tXc_f^,.028 ,|-j,j鞑U̜	^㜿[Ǣfȸ .HTbC"s"Ŵ`Ⱥ `K  q&aaku Px  
~| bla ,<tR~n 0QoPPff}Xff݁o!@~ su   ` 
a!@PfQR 33p#Lff?f
 
x@f 2 vt%\hѩ>0NPfPz'p^e  E " rSyf Gthѫ&c"pQa!% = u5
?=  ru= rC 1`ی! gf;<f 9t 3=+ R"2ặP졢 UQ   ,A048 d9#5 A p!hDfP u	fXc  h b! 3 POf4 ~Y 5Ft[7f71 q7軰t2? t,/fP _DA1tR'1㨅'1'L0 !]X8i   2iPQ ܀tu
YXûPp肢bu 
X `JQRf쨀u ZlSfa@hBn P@(0╾z0Ef|븯 p D0  &Et"׉D  $D(ú{s `a&t>ˀ p@4>2@"·Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
`  m  m 
 m pZ's 0P^ ar *? $߃OQa	 & aЀ0# $$<@t"hXO=D=KuKf3Kuף`.>i"st&3r	&*QrCE[c`߮oaô`prr X ? tr/Cq0}}qw1#!8OQ909$蟑a0){fRQS[YfZt'0ƾƾ
| a60PJ
ADȁmG>u "v  htruf0Trff# fjfr<fffHff#f+ִ f;w_fс3nSPdc
uff+f?뺀!3 0,-./01289OG     M`a߿FOƿ[RFp$amPUoG3"_"
Pq[2t*@r*`>pl>0l!GA lBla6$?{Cp! G K@ A1 B  $0sF  @ln "l  BnnnJF$a %JFP < tq ̢}P ̠ث̡jޢk   @pllB  ؿ% lBB@U Wl@    @ lhТiN5&E'\bw /$а 
@  
FFn  	n	n	n	n	nj	n	nnn 
 hi ta  aCd̀`  3nnCy q
p		 nA
}` nja4k4P ' J   &JJ
<À> tMt 
8s 1t莀t r`QV$<
v
  ; t>B t ;$
ؐ ;hW4t$ u
d t㋷%؊ 1^YphYyt

d		
s	 :Ð[u B&C:@ BC< t>C u
8wС  
@|f 8ff  g.1cUfFwFRλR `k8ufkNT!Y8!fffvfXfۻDd8 shpfuf0f M "  0f f @ +f T  l
 
u A P߲                                                              1LOIG 
bd  K             p                                                                     T  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  ֟68DTU   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 ysЂ f    Q7sY 戰f
   ff    f   tf ff
  rfBYf戰YgC !f3f   戰 fHr4f f戰䈰xf戰 rfFf    戰戰3{f  f   f戰fS/f[f   f   3f   f  戰g&fFfCg戰{ 撰fPfSfQf   fQf3یff
   (xfYsfYf[fXSgu
  ;u[fPfSfQfRfWf   f3یff
  	 wfBf    f3g}
    fg
  r%fG;wg}
  f_fZfYf[fX          fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   (fsf ff   fT   (fsf wfD   f @(fsf [(fsf 5)fsf )fsf c1)fsf MG)fsf 7])fsf !s)fsf )fsf 7)fsf )fsf 3	)fsf 	)fsf 
)fsf F
f   t*fsf c
n&*fsf xX<*fsf 
BnnfLg&nffOg&fffsf fsf f   f   *fsf f~fs*fsf ef   *fsf F<|*fsf  6*fsf j
+fsf +fsf -+fsf x=+fsf =f   tV+fsf f+fsf of   t+fsf h+fsf +fsf S+fsf +fsf &f   u+fsf "+fsf +fsf Y&,fsf ,fsf )'(,fsf L'8,fsf 'f   N,fsf <wb,fsf 4 f%"f   t
fAgf  ,fsf {ta$f  ,fsf ;$Ff  ,fsf Df  ,fsf    Iuf  -fsf f fsff   f   f   P-fsf tff Ag&uf-fsf &r8u:-fsf &u$f3f   u
ffuf   tf fsf   -fsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  t.fsf $f  .fsf iRDf  .fsf rf  .fsf 6   Iu f fsf   ffuf
/fsf %tf   ),/fsf $8uf   uffuf fsff   ftLt/fsf $f   t$<t)<t//fsf $ufffff   uf fsff   ft(
/fsf 8$<t<tfffff   uf fsf   t8f   ftF0fsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tTT0f   1fsf $t<tff @   f 51fsf "2  +O2._1fsf "<  ff   f.:w .D1fsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2Tff   f
.f   2f   f   ft/2fsf !< t8stff   uffff fs2Tff   f
.f   2f   ft(%3fsf  < t8stff   uff ff fs2Tff   f
.f   2f   ft(3fsf  < t8stff   uffff fsf   f    ft'3fsf $ $t<s
f   <tff   ufff fsf   ftT4fsf uff   uf fs2Tff   f
.f   2f   ft($4fsf m< t8stff   uf?fff fsfffsf fsf 2Tff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%_f   t_.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfT2.<u f   t2kf   uff   u6fsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   37fsf <|f`Agf&   f    f    f   r7fsf f    f    3f   ft7fsf Ufft7fsf ;fft7fsf !fft7fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   8fsf <|g&f~fsf fsfLf   f3f3ftr2f   t8fsf Qtf˰8fsf 5<	rIа9fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx_.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8_  f Lgf&fftf_  f~fsffHfuff Lgf&f   ftf@l<fsf f Lgf&fftf^  f   tf^  f^  f   tf_  f Lgf&fpffHf   tfHf~fs<fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	=fsf fBgf&=fsf  =fsf  Tff%   f
fHf   t
.f@Cg&Tff%   f
fHf   t
.fCg&fKgf&I>fsf Ff fs侳Tff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsTff%   f
fHf   t UfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}_.fDg&(_σ.fDg&.DfDg&f3Uf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`[f~fsfffsf fsf f Ef   .@ fffsf fsf Xfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_Bfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
_fHf   t_fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	_f   t_f~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H_f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fH  Hfffsf fsf f x_.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|_  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xHfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfT  f Lgf&f   tfT  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+`  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk`  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            D   @    L       @       H         `      T    G|   @ Ď    Ď    	 T    G       	 		 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D    X      P    `                O    O    
Ol 

Ol 
Ol 	O A    A    
@          
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <D	    , <0     <D	    <D	    ,<D	    ,<D	    ,<D	    	,<D	    	 T <D	    , <D	    ,0<D	    ,<D	    ,<D	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                             	4 @      T                      d  ` h   X  '     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<D	     #<D	    P0#<D	    @#<D	    PP#<D	    	 #   !    8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < flf%f  $f$
tWppqtHfmfupppppq5mfAmfupppppqf  f  gffLggf^gfnf    f
   "ͼfmUfupppppqg- fm,ffmff  @$f@$
= u$<T)fnff  @$f@$
и f  D$fD$
аf[nf% = ufwnyf fndf %  fnHfU../0./.	/`./a. /0./. B쨀u?fnf d< ufofd< t<t
u掰f?of䎊fQoffcof掺<ufoifo/%  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fq  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  $f$
иf  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   fcfr  H"vlfr  <"對 f    < tg f   ff   2fff   ff3s.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2s{           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE                                    	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ftt vugf&>tgf&6f٢ &fE ~f^Y[fXPSRfVࢃ tAࢰ ࢃ% g&ƅ    f  \g&  	uf^Z[XPSRfVࢃ tAࢰ ࢃ% g&ƅ    f  g&  	uf^Z[XPSR     qZ[XSR  zC vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $fKfS f	SfWfff]X t fffS f	SfWf  ffKf_f^fZY[fXRfŋӃf3ӃZfPSQ  f⢋A vY[fXf` f;.t
f.   ~$C vf3 
 f    fgf&E   > uF f  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   < σ f;  Ƀg&"  @v@ g&  s σf;  Ƀ> u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         戰䈽j戰䈽'`ݰf3f={ڰfIfS"ܰf_fi߰fu{f f%"fYfٽܰf=fHfɓ'f Փ%ݰffܰff f
   `"	f   f3f30f  0f+fUf   f f    0f  f f   0	 f%"ft|ff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f.cf  
if  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pfd   0oUuso m =
z  >mrfzgp  p ( rz  .izlV>zMzfqfd<>z3zfqfhfhrrfhfdf>d wfd   >zzfqfh%fhu3fhfdf>d truf>d wfd   >zzq/>zzqm>zdzqff   fF>z=zqs,>z#zqs>z	zqfsf zl >z zfqfh'fhur$fhfdf>d turf>d wѰlfd    zm >zurzqd>zu]zqRz		 D>zu=zqn/>zu(zfq .lzd  z>z	rz  KP	s 撰 XՖB͗(DU֘'fSgf[gfPfR>ouz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf`@
 >o u> 5xzytsfZf[fXúz.yursfZf[fXPR tĺZXfSfRf`@
 >o uB ;yM@t-s(xغz,y0@usz.fZf[Ru	sZ       p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  v  f  كG 
f  у赇faPSQVPL	;t	 ` ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6郻js>t fafWf   g&D= g&D= f_`r r8 a`fP  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`ff   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f> gf&D5 gf&fff>fXYsufa`f`  & gF
$
gF
f`  sF>tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva"  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf:  ?   fN  +   fb     fv  J  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_Zf`ffPfQfW3 .;ˡt3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇䢣ࢋꢣ[XPSQRW0  3  3  3_ZY[XPSȎػ       !    A   f   $       [XR # 1 ZSQW   L_Y[SQW   7_Y[SQW   "_Y[    f  f  fPQgf0& YfXf    gf~gfNgfVgfÏfPfSfQfW<w f.O
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .͡<t ø fSQ >ntf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f`p   rg<uf   ⃸   Yf[fS>ntf  r	f r>PfSfUUgf*gUfUUgf[Xgf`   T r
g8u   f[                                Q  YPSR+;wZ[Xf>` tf`tf`f  f3f3f3f @ gfffCgftftfaf`   f`uQYfVfSfQf
   f   fh<rfhfYf[f^fQfWfVf @  f   f  gff^f_fY               fPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfXfff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{f^f{fKfd    2ø     B  @ $^
09/15/05DUT