#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTA)  - Linux-Based"
BIOS_VERSION="F.0C"
FILENAME="sp30957.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  lP*P*  P* 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  P*2  2   8DTT   BIN  wP*P*  2    8DTU   BIN  `,s22  2    68DTA   BIN  Wt22  2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZ[  `     8a             
(      C   
    \       j        m    i
      ^  8    t    	                       q    
        l  [  S  1    s"  M"  8"  !  !  !  !  ]   W   #  #   O
 O
 O
B(  )(  	(  '  '  '  '  
 
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
O
O
 O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
C  C  yC  kA  ZA  )A  #A  @  MF  GF  +F  D  D  TO
$O
O
O
O
O
O
vO
LO
.O
O
O
O
O
O
O
nO
PO
2O
 
#Q  P  P  P  P   
^  X^  G^  ?^  -^  Fa  b  :b    c	O
0O
*O
O
  .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        3ÐjDː
  F  F~ F F^z9 uvfvo'}fvfv]'~hd	h jMRPWVtj
fvvPt
hd	h jN`RP*Vtj
fvvPG
 Ð3f>^  tf6^ ؉f>  tf6 ŉj _;  Vh j7h j,h j!h  h Ïjv_h ҍ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hn F^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPhjbRPBjRRP2jBRP"j2RPj"RPj	RPj
RP⅃jRP҅jRPj
RP貅j_NFF9F}-^v&&?-t^F&&?/uF "[z=sjxtRPTjK_ZtjyURP5j,_>V   hd	h hn Pdfhfuj fh  ! hK
h>if6ffh   hK
h>,d| f6fcfF    .^
~ ^&0>^&>F~	vF  F| 9F|F= t= ujRPhj_^ZbZfh  j $^ ` ^ ujzMRP-j$^+
>R  tD  Zt( !  9  =  A  E  I jJj1fj誅   ujzRP賃j]t(b       ؎f&fjxRPij`]>P  t>R  t\  Z  L  >\ t>\ u& & & >\ u-F>T  u	>L   >L   >\ u3T Ht	HtHt8j euwjJulj?jI.>\ u?T Ht
HtHtHtIjj WȐju+jRP胂jT HHtH
Y>T  t7>N  t0flA  hlhlj~
>x tjJRP*>J  tXj \Ud  F >d >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uD:&~ tfj fj M.F  =HtkI-
 -!- - - 
tFfUw>  ~  H   6 H; ~    ߃> ~  H6 Ĵ &@u  H;~  6 Ĵ &@u   FV^& &G|&Wpfj 8Ad    F >J  t=Kd B= M- K- '-M- 0- )fjG>J  t2
j Y^ÐU
^&J&LÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ðl"n
 hhlhljmX >x2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFfFf-   f;FvfvUFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRP`UFᐃ~ b  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP蟂
	3ÐSfv
 ÐT  Vfh  P FP͂flK  Fthhlhlj>x t3^ÐFPLyBFVhd	h FP8RPhxhd	h fvRPhd xfvhd @x ^Ð  F>FK
l"nFtFhhlhlj(m*ÐU~uhd	h  Ð~ fh` j hd	h hd x[fhfu3Ðf`    
f`   ff9`sVfh   f6`fh  `f6^ u*u%f6ffh  f6^ \= uf&G
 tf6fY놐f6fY?~ uhd	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP
afh   vfh`  j f6^ $@v  WVd	~" f~ thd	h FPHv~ FPu3^_hd	h hd Yfhftj ff-   fPf6fx
f6fjFPw
f6fz~ uF.~uF6f 8Fug 8Fuh 8Ftf6fXkFPhf6fW ^_Ð~ fh  C.hd	h hd Xfhf
f`    	`bff9`sTf6ffh  f6^ X= Xf&G
 Kfh   f6`fh  `f6^ u
)t!f6f4Wfh  `^_Ðfh   vfh`  j f6^ \U     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP}
F> tjJj1j f6 P}jhd	h(      RP|
6 hK
h>     RP|
     ء` +^  &&W    f&        ؎f&       ؎&  &  FF܌VF Z   R   \   fl
S hlhljTs
>x u_>o@Z RflN  fp    FޣFܣvhhlhljy>x t>muR   hLNu~ t\   Ft
F$p*\ Ð&  VFF܌VflD vQCthhlhljx>x t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	l&lZhhlhljCx>x tjkRPu  fh  ! hK
h>zj{RPWF  @ +FHuF F^
&>TxP&*PhPj*cXF 9F}j |Ĉf<t<uhd	h2 GWÐ  += t= u%F  F~}
Fu~|3Ð Ð>Z  u#jIRPtjJRPt3ø TxP&PhPjWhtuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPJFVfFf  fPJ;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP2~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRP0Jې~  fF    fFffFȸd	~4 fffFfFfFfFf-   f;FvfvqIFVِf~qhXku2f+fFfFf~svBPƋVFVRPRIِ^_   jF "hPj
3UjRP3TFF*;s6PjRPTF*P2uTxP&
P뫐TxP&
PhPj
Tj|RPaqju,jCeRPEqjDURP5q>J  thhd j1RPmSÐ  [fh  Ohht"jMRPpjNRPpj{RPpfh  ujEF  jRPhd	hH RF~uv FF*;sPjlRPRj F*Puπ>X XujKCRPhd	h> yRjL-RPhd	hD cR>J  zt~ hd	h2 :RF 8TxP&
PhPj
SF~sF F ;FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&fRPQj F*PujDRPhd	hH hhd j)RPeQj[RPjZRPhd	hN EQÐ  3fh 'hht"jMRPnjNRPnj{RPnfh  ujEF  jwRPhd	hH PF~uv FF*;sPjDRPPjF*Pvuπ>X XujKRPhd	h> QPjLRPhd	hD ;P>J  Rt~ F 8TxP&
PhPj
PF~sF F GFF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&JRPOjF*P|uj(RPhd	hH  hhd j 
RPIOj[RPjZRPhd	hN )OÐ  F >\ ut~ thd	hV hd	hb FPrhhd	h FPKFVu3vPfh  f6^ K= s^&G
 tF  fvJO>\ u~ t	hd	hn hd	hz FPghd	h FPMKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPxB  F J.u35tF f6^ FP0F~rhd	h hd	hV *JFVtvPfh  f6^ K= s^&G
 tF  fvH~ ujRPLhd	hV j!RPLF*  F u3-txt~ thd	hV FPfj"hd	hb FPfj#BRPFPehd	h FPHIFVtvPfh  f6^ CI= s^&G
 tF  fvH~ tj$RPL90F~  F ohPj
LF  hPj LFj$;F~TxP& P܊F*PjkRPKf6^ FP0FF~s#~ t~ uTwP&
PtFPFPj%RPOK~ u~ tjjRP/KF  F f6^ FPm.~uPhd	h hd	hV GFVu3vPfh  f6^ DI= s^&G
 tF  fvFFÐUf6^ FP/Ð  F Tu3F F~s7F*Pj2RPnJf6^ FP<uhd	h2 OJhd	h hd	hn GFVtvPfh   f6^ H= s^&G
 tF  fvETxP&
P
hPj
JF hPj JFj N*;~TxP& PՐTxP&
PhPj
oJ~ uj-RPiIhd	hn j!RPQIF*  F 8u3t~ thd	hn FPbj"hd	hz FPbj#RPFPkbhd	h FPEFVtvPfh   f6^ E= s^&G
 tF  fvD~  j$QRPH:EF phPj
aIF  hPj MIFj$R;F~TxP& P܊F*PjRP#Hf6^ FPR:FF~s#~ t~ uTwP&
Pt~ tFPFPj%RPG~ u~ tjjiRPGF  F f6^ FP9u3À~uLhd	h hd	hn KDFVtvPfh   f6^ E= s^&G
 tF  fvCFÐUf6^ FPW9ÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ *;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2H>H 	H  iÐHi  ~ t	h)8FNuÐ  FjfvFP]
F FPNQVRhd	h ^Sb~uvvhd	h fv#bÃ~P|FlFFPvvhd	h fvaÐ  FPNQVRhd	h fv6bvvvhd	h FPaFPNQVRhd	h fvavvvhd	h FP}aFPFP\ÐUvRP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fvh\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j߃RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
 & FF  @
 &ğ &0߃FVRP3[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6 &Ĵ &@t2j>vjqj+jFvv^
6 &Ĵ &@ F  F j9Fu
F F  ^
6 &Ĵ &@tF vv}
 &ğ v&0݃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l
^& ܃RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjۃFVRP
X *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7ڃRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wكRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0փRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0ӃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
'
6 &Ĵ &p
ӃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0ЃRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;F}FF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FFPv~ 7
FFF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP!ÐFP>\ ut ÐU>\ uFP+ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh>FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh>vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh,?htth,?hِ }= t= ut '҃>Z  t fj h2N3  FJ1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 JSh@hP*F*P˃uFJ| j h@hP j˃]FUtKj˃hK
hd j hhlfj hG=th@hPEtÐhK
hhK
h~&Ð&ÐU~ u hK
hjhHhK
hjh7F  F~ ujFÐF Df>   F{ j h~Ahfh  ̃uF  FuF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh~Ah`j F*P̃u>X XnQfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ 2ڃfh   F*Pfh`  j f6^ uڃF*@N*1 j h~Ahj F*P5˃h~ Rfj hF: j fh  ʃhK
hd fh  ʃt"hK
hhK
h{t"fj hE
fj hl=uShPAht!h~Ahttfj hPU~ u hK
hjhhK
hjhF  F~ uj-FÐF Df>   F{ j h0DhBfh ɃuF  F+uF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh0DhjF*PRɃu>X Xnfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ ׃fh   F*Pfh`  j f6^ ׃F*@N*1 j h0DhjF*Pȃh~ Rfj hMF:  fh ?ȃhK
hd Mfh 'ȃt"hK
hhK
hɹt"gfj hE[fj hl=uhDht!h0Dht fj hÃ>J  tj htd d   1 ~ uj߃FÐF Dj <Ճud j hFh"RtF F~s3c F*1 j hFh"`FPHuFA j hFh"8he>\ utTOtM0tFj t:ohDhfj hl}=thFh"{tÐ  :1 ~ ujoރFÐF DF F~s-F*1 :j hGh@~FPFuF:A j hGh@Vh또>\ ut>Ut7j hh3fj h=thGh@tÐ  X1 ~ uj݃FÐjaӃuÐF DRd j hHh^qtF F~s3Rj F*1 Xj hHh^~FPfuFXA j hHh^Vhc>\ utTmtMNtFjt:hDhfj hl=thHh^tÐUfvhr  jF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NjOÐU*FPPKj*PKÐU*FPPKF*PjPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBjÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졞FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FP4tFPhK
hփ~ thd	h@hd	hLFP3hd	h FPUFVu3vPfh0  FPLfv4FPhK
h'ָ UՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  XhpՃh 
ufh  h j
u  7fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  Hhԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
fӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAh
  fhx AF  F~
}YhxA$PhxAj2҃hxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPh ҃m$PÐUj
ыFPh fh  	jmjыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
4ыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h
΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  
& FP輴tFPhK
hɃ~ thd	hXhd	hdFP&hd	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhK
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..`f^gef[UfS..`f^gef[UfS..`f^gfeff[UPfS..`f^Fgef[XUPfS..`f^Fgef[XUfPfS..`f^fFgfef[fX                           UfPS^tf3ff`  f.`.` "  u  $" u [fX 0!<s3P˿K
6 + r ׁľsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666
P.:bظ cP.:bۚLg  y>	uXP	 PK
 5! %b!

)&6, 

3
sx

 
&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.!Q
u' `t ``z 

b >	u 


M 

S  tX
Pu~ uF  X
uFL!_^]Ë

 
 %!;s
OO
;sEtU P>" t" P]ø Y+r
;&rQ3 V3B 22Ut
 Pt ^Ï( <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &(U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV(
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v*טÊ  UWVFG
@tG
  D
u VށD8FVD*P{|]~ tZ>PNQ!FFV~\t@PFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPPFPvvPPFPPWF_]ÐU!
t]UVWvD
t^@uZuGD
D4u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
D43ۊ\uPuuGPt\ttu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށD4tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7BFȁD4؊FG
+EEEFEيF3EGǌ^_]ÐUVWv(Pt,\t	0tuVD4D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvD4t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vD4@t^*&GPy= ^]ÐUWV3F؋O
рuGuD4t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVD3~~ uD
tV@uF96$r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr:t)ǆr4FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.6yrJuwwwxtxxxxwJu<uxxrxJuxxtxxrRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] zzz {L{T{}{{UwVW3FFv&vF
t~ }F<, <Xw$ FF.dzV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVD+FF96$r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33BK
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96$s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁD4؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVPvv&PPFPPW Pvv;u)TxPP&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFVTFPv
vVpx& V3P,^_]ÐUVIFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3K
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	`t	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5!["#%!usʻ 
FV]U_ .8tK
I	]PPR.:b؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUK
ء
F
F]XSQRK
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ1$%!3]UWVRQSP.:bۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y&;s+3UVv&L^]UVWNwi	tHԔ6		VW_^s+_;uX6	&t	;ut^Ԕt
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]            K
              4.64  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   d	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) ZC  + , @  . / F  \ ] F a b G e f jH h i jI '  K
 `  K
  D10/17/2001  O                                                                           d	 d	 d	 d	 d	0d	pd	d	d	
d	Bd	td	d	d	,d	Jd	fd	d	d	d	d	$d	Fd	fd	vd	d	d	d	d	d	d	*d	>d	fd	d	d	d	d	d	d	d	d	d	&d	.d	Pd	fd	nd	d	d	d	d	d	d	d	d	d	d	d	d	,d	>d	Pd	dd	xd	d	d	d	d	d	d	<d	\d	d	d	d	d	 	d	Z	d		d		d		d		d		d		d	
d	"
d	B
d	V
d	j
d	z
d	
d	
d	
d	
d	
d	$d	d	:d	Vd	xd	&d	d	d	fd	d	d	2d	Pd	jd	d	d	d	d	d	d	$
d	R
d	~
d	
d	
d	
d	d	 d	0d	                                  E    F    B l `K
      C    D    B l ~K
      G    H    B l K
      K    L    B l K
      M    N    B l K
      Q    R l K
      P    O n K
      I    J    R l &K
      -     1    + o DK
      V     S n bK
      *    1    ( o zK
      T    U     W   
X   
S m K
      Z    [    Y l K
      0     1    . o K
      _    ^ m K
      c     1    a o K
      g     1    e o 4K
      j     1    h o RK
      q    r    s    t     u     p l pK
               c                           _C_FILE_INFO=                                                         K
               
	
\ \                                  YK
  YK
                                                                                                                                                                                                                                                                                                                                                                                                                                             (K
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          ccccccc               (((((                  H                                                                                                                                                                                              bbb                  kK
K
K
K
K
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$ p   `      POST  f   f.V .X <  
 f.d ` j  I     '           POST3 } * F z Z | 7H ~	 pu
 ) 0} )
 I} ~ )  Z ) E  P3 3 3 3 m p M| w u w v  @! 0" ,# $ ,% & 1|' O( ) \*	+ L, Y- :. 8/ [0 11 `2 3 4 ٧5 06 .7  8 7v9 3,: ; 4,< = ,> V? L0@ 5,A 7[B >[C R,D ?|E qF vG pH 1I 2)J ZK w}L )M pxN @4_ )P Q pR ,S T g,U V JW jX *Y@Z u[ Z\ ] DH^ }_ ` Za f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ hcO [X /<t
PW :jf&E1_X  fPfSfQfRAfGenu fnteluxfineIuofP%=  rYfa2f   uI!؀p߰UhiBt/f00tf  
 p0fZfYf[f
  PRWfQ
u5p (t'@:^Rf0@
u߿ h8ufY_ZXSQW< os1
2
 h;_Y[ABCDEx} U~"RVWfFf^fNfVЎ.< t ~.FuN.3_^Q	
}H@
	y	! &
%s
> h3Ch"p0M 0t  Ãu
.(u	u/RPVF	` u tR	k@.)tމ^~u 8	t/ tS^6
5
^XfQW~
,  _fP	$S 9#0;r#Lt<
tw
u!ο 	/_^p	65WfV*p#)6S
F f[t3ff^ff[f`K.fa= ZApCfVWUA t  f7hAs.%3 tkfAh6 Py'Q20O7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^Nf`Sfff@= hR3>+f;r[U@ Wp
2h_
 WX
_: r
gN1
g?r g@99 \AVWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_QU/tg^H2N@?"u h fΑRx   _둡4]hQRWV^NV v<q6Q3qI4GYGʫξI^_Z!3Q'M0 ݀pC8 YfWV3ff"1
mIfPS. ,.(F(  f(0p^
#N~u!h^
s.  OGFuQVsuR?
`O2ۊ~f@x޲k:P`?tWuf@ f.(|ftf!f.@# <
uF8Fuwf_ts^ÑGVR.>(s$0q	.k6(.(z

ZxF(Pn2
F0(FPPv2PqN~ t4vf2&fz10
FNNI.(ƔfQvPu@f(.;(s0e ~ ˁ ;u
t`g#t@ڴ 8^rf(  _^ZY eWQ3.>(2 .ǅ .υ" ` Pǿ@hMU.( `s$' ip3.(lh)<z9 o.N /p\wFk@"~ 
N~f.$=6@.(g2ɠ0/tl)u4.B$f<t؅f  `b$< F. 
1wq3V@~r F F;F F2u~Ow
`?M~f1 kЖ lt
fNqu
ffsfF^PB4)FQ*
*q4rF?$<u&jFF .# ~ă$wp` *.p< O<uO8q^`V@;(@..(;O(^V0&0
}9t@-2x_@2
E/^S 65^35#'suBX:NЎuP:
t3S9)&u=8N0_^WV\SVR۶`Ffn*rJ[*!ffAyRffP%Ѐ`2fpʰKf;w
2.fPRfPt#f3!fD`XfffNL$ss4
tP7u+q%
u	AfFaJfୀf^Z6Waf F݉^~K"8ueffFߋN_QtcV@hvb!F;pI*3χ~+c:tsRVRfQF;F8u p? kv@kF:`pb$$@K*@3frD` w;=< ur,.;D$<uπk r0	 @BvFfYZt4}VWv Ђfq|~|URd
t"t_tD y@DvP }PkQ9SV ޾N3; t	 rϋ^00kNː#Aq[%S ^Y@j(*pt@;v7h!1k~@st 1;FtFk^% Bk^cՊNa 3҃  V3k`[
*䊁N;FuR*3]ft7W-k	)	# a
@S
+FHu
4uGrvFvVoBs0;~HVW΂tS03ދ[^NuVp 3Wҋ0_&61-D^r<lF_(kHpBHP)뷋A(7YoZ Ի&0V  ~1|\0PN~ tKv0YFA.Qzw$ x
fpO3g FfN@P@ 
0K SQh(	 \P,Q23If.` tfg.&!. .8(tьL$QVW
kfvUFp"`F^^F  FψF
fgFF ^V膵eb"˄^`LȬ`Ч!uɱ ``Nf~ tFt'f`e 9Fv@f0
FfHf;FyQr@րi`bbbfC}<4RVFъF8Fǋ^ pVF]0 N$ U&(s,ytN!!fsШGtE rt2s@C>A9FvGT 3r%if.(N쟊Ϳ  `N0ƺ0 
t
F%  .=p >~ t(i'i_f^z eu
 v@aQI8t%  tu Qw  vfIft'fAff#=a fpЊ=rSf.6 G                                                                                                             /                                                                                                                                               o  PQRa&hic $` h9@rZYXSQWa$a$a  h: h";B>5_Y[2揺 TCwA6  @A Q C@@ @;uYð!桟$p ߴh)Ē
f`  g hf4gf&`   faK.-h
 

hSfPfW@&'_fX`j
/h	.t%0h+P
*   &  p|@ ؀ tK&}uu h'k2!o3d 
  % 虿WWr-5&$@#h<ff
AÀtf%1fh衕st h7*,Ⱥ: @p 3S, @uSh$.h6 s!úvø f֭ й h3^`ӻ-aP hr40 h" t
 aPQ# @ PQ= `t
3f3 @fYX _7ðѿd`0.d  UP9k<u  U  T
F  ؿ
Et&؁P; uM9NwN#uӃ~ t"F= wt%   +w=Xh.S8`.-   !	  5 a `h¹UBHt*u E7uq9tPRfZX?(~f.~ A>f` f   ƀ4BQ~1SfQfRf0D  fU%=uf?a2 ffZfYf[ASQRfWf_ZP>f@`fVp) f  g&J @ fq$<s
hEZˑ  '8PA	<@$f  CHڰRGjE sFfOf>@׹
 F M'hQT ;s(Ǻ$ fޭ f^fW߀0$w
 $
ذve>)$ w'g`$L )f_AhDYpfgf`Xe =s0bb2
r-
t@{!s! hsf6r\s  Sez
8SLMkfaa	't5<t1|of @rIa@ {Æ B<  CW< U$ # Q R ST U VWX
 YZ	7VW3HkEDE
` Sih_fA_ wуtR֔2pnRgg_^.!Sr ֚   >  A  T h M e _M A@ 9 Y .   n SA aǀᣗO` (
 R? lp+m{!m À!W2 P f{L3!~p6,3f62M  3 |pҌЮ 62>xa\.wh1SPS $<t4r [! ЍYӋh 43 `s f`4 S  y6vh#%h9w   D 3y 0"ro< tyF?*2" |)k :*N)rP)?* r%@a*Z)&5&D&EN)XAa
pԯhS 0߿*p<ue0U*V~^ 
8
3
~3
*^f
'*d  pvA*y&@ U$=u&*f= =u H&+&+&*9
, fgh  0 pqr  <ABCDE xyz{|}   )[V S#
f k&6 r&U+&W+36 r
&   @6x"{ }+CfX^Cf  pf5fx&uV3
Ê^P0(.'t%.FuN.PW* _XpUSW! Q,fv߿ hw  ޿R&~22ك!oIN܀3d	^
u
t_NA&>N)_[]wf^_ PVR&=;u&&4uo&^P
P<q +&~& 1E&DpSV h@b^[þ0k8`[W0  <_\PF10=ROM Based Setup  Entering p8 `. u  s8 ,L~t.p89 Suа)!`- W  8p K!A	Ap8 1q8qrKp &p8tFò  Օt
.>~	t.P(*t hcPXh8cWF12=Networkrvice BootWake On LANAttemptto %  !ʠhRt8 09w r	 0˾A9u 91J!	t ٲytsR QP.9$<0+(_ 9-*BB"9! ds@C	%24ؾK<^s 7τD% VRynKkNF K3؁tK?	uCFG~N0tG;hջawKpvrhZ^òP*Notebook hard drive MultiBay"DoKck!:b<#b (top)b?ottom)leftf	Floppk  US9BCD-!F :HDis/SuperN#IC*
!1	23                         =P  	 
>:P X 
v m@0-r  pqlectZDeb]  ͹U8 and _mo@=the highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   ??(?$P w@'@;S A;Zip.F`u߳ hC d0ô0.C@ӌ>th@< A VK3tK؊' tA<v<st1?& 2آ؍ <2=Q#YAr	 ? P {A.?
*}? @?+jjj(Pj5  E@ `?H? z  J  Y@a R 2җ
   t03?2Ɋ F8tFޣhK $ Zbqqp URVQo.,.L.T^Y_^Z]S,.[QSVW/ s&Qc@.<.-00?0?0.Y_^[YQrH? u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰw`2҂ X7@
?H?H?r
;w2p?Jơ}gFY.*?<u2K0hi; hãh"7d hb<u`B J qWo rf.>%D5 hfgf&G, @ fo   PG0f@G,`u
hEtG,f",7f_ffP QW2_Yf= TKSt0fXbo    ? o  J  b؁h5p.
W
g&Fg&Fg&F"t7g&F0va 1 2H޾D׎~ذ:{ rsD	 _k  QRVDTQF r&e^ZYDffL (]LрY`VUfQWo
ِx
K&@
C' C$vC$0Grx  q## r]".0tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ!$&C"u#%$u!#,9ABM  f. GwPS [XAu.6Gf. GIDNU.GSfV#{P #^3%%Ýf@)3u
u ]rt!q!} "оW3 hAo[ ++hs3%5Ycf_]`= vH OAH aP hi2$@<@X7[P4  PR ZX@ P.>0H t.0H.2H@a4HSQRWh@r_Z>P TC r99 r/ u t t@XR1$tutZ 2 WW$ f3hAcXRISWQR Zuʀ[Ppq4{B XZY_U M[у< @3ɹ2 uhXdo#W)¼ P% = @uXu%)4_g&@LhH0VQfPvf  g&?t9g@YR%fi<u @^  f%?f^#   f@"f<tf Q	 f !pf 1^fAaZY^$fVL/
/ZGP@t


q 
"
f^}ff? wD Pf%2 {
!
hfi۾L <D	"H3P4r H5 0P@p K2 P`     L@`@"rQ  	P  	`}itp     & Atf &+&+@ p p 3_f$'Br"rst$ uf*?,;,=p c>+ tuc ~rh^
&+p=C<thSp},  G11?}4 Q < t&,G?,fO&H,V
gp3f30 2*f&+ uf
ffKP,&,&,kfC0,?,,p,15RfVWf D3ffCf[fKfS܃fF0r0а K I+r+_;Zf5SQVWϾ u3__^ _	!BKsV 
R3
t<^f~
w/vN0fk۽d`affwt@`[^ɳ{VQWfv hG-F&^-F&{`p &b &dP&f&h0&j&l&n&p-^y Uȡf   rGt >`*:u
P0uhg䚑`X`a؀adf]sPRaQ  h'kbejjj%jG PR	Pu h֓
v o h`6s5ú   hppВ 틵(̲ t 	2se f?R ffff>;Rfh pTg&; P]u}0a)f)Pf0g&t` b   ttx3srnfǂB 0E 	ސ~/uˀ~/t a	~;HRtM! 6?                                                            `  ѲTfU.6R:RWu u[rWJrR-rM:Rtf0fqP| @Wb t#r"t p ; }PJR  ZR f]L"V0r*6@^  R Z0rG9	0KuҰo!fVg&fFfFf^0e rC\A `3Yyg&8E tEG SBWiTm r`T>?Rptҍm8lӷql0hPҥc ˰W rt r
 GC_RZt$ؤb$]Wp  _W}  spO  a #`P
߰@S P  	ð D v Sذ8 3 e 0R	$#
R3'
//gqQWjuptPX_Yù
 d h5sxusz
eP .<u.uĀ RRuaR22hX< uZ#$ t	J  U-
	a!Vffn@ƀK`^hXàhaӫhr$4/h Kh*jruva { r PQW 0> 3_YXYBIh^C=F >U$hSs	'? $E   ! $!f` Th}iC@u' tf` hA;* hⷩ tff%f
> ffa0vP\F X>x]`ؾL &>dK&DEP&D >Ku kdhW lj@ t~tK}
 -Ȁ}	 >pK 33SP[tS[a@Q 2[sDy3 t^hhʊYs
JhOQwaàhLRD
ϰ<DuL
p
E$<u D
@13Usd
rSi&pS]@` uL
 6 6XK u  (X6R &uhT
	\

u>@   ^D&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  t"& xu	o\	PS   ? 6P'>qK_3& ?! W>rK	_[XB
t+# P xt  t  w\迫DPV!$!"桾tKh{10&,@ &o  ~` hC!r!L	vTt
v`WU$@t! $<v@a@n3  v
p
u$< t"<u P>ȷX\PRt P:p1twhE\!&ă}=0ZXx` 22PEǿK&PCt5ǄK=tKtOu570: u	At!s96 u5 .\s
t!\&@q s  `a
׃/_o3 rBs{&=  V P;Lu 0<} ^  3f4G -Lf_  }0 U!    L&egWʃO&MuO OqofGtM!t$Ot, t"OGr JM0oOg&L/` 2%
<t29o21_kP*P*`OHtS@LDhE =_7_D D	 d_
z=1;b^tSqrG&}	r??23p4t`h߇ea&ET$a	&M&]aI`.'`\%# rU VﴱϠRZW&= uAF <%K)
hK
 m_VP
Pt   U!w#w !#`0_|ov7h3 Cd.-.kMTN>tI! //(rJMd.58v@Nu% @BTB 0h:{h"aW$w
"1D h3
h}CYp@[X_Ë
`PS@E![X SϲH<vLR
 Z,<u(RffWfĢfн,ZJ vGu

} kS1 6у[Qb$ <@saaf3Ґfi!<`c8i |	4`{phv73۹ F
t):u%r9eD	& h.SK & 	? hK3Ga!3 
3 ?  tK SٺuTu ?" / [J rGQx> r;fQ  x.<t*tS&' t&A+ N ̹'{
{'+Q~@s& 0RV}Z`}tpk hг YQo@@?{~P`[r4fHq(u% = tRe0Y *pQ@_HS3tK+6 
{HHȋE&AE 1, ^@r \ \hpӽyxf1  ,VA @P$P<PtReZDA۰AuO  ZGpZ^a/\WV 0  PhX@ 0$x2)
C@)2ƀưӀ?!C@u?r@Dtg5. u,{u1 
@a

+&C32o3&@t  %
t&
0  ⫰5  t" -  ( ?
uM: 7(/b!	"	?A%w ^rPRWAC&A &]&U 
t oˀAi] _ZXr#3һ -wv2C.u#/5$N#h΃&{_ '߸^  Y       ր>u _ '3Wÿ c[ 0_4lYf#`Zf3fcu 3 Q>J`[#:(uBE&8Uu8p]
R +B&U
ZK!ؾ4lZ6fYB)%qr hʵ ;1	Q(t0=z
 ߿ 5h^xP8.
<t0Z`ûPV#
@F^fǠ  XJED/
yC /   8p
rrUf``؎ Fwqn.p ڎfafSfQf.knf fff#fYf[2VftGf   ^nIg@f;t&fW \m	F $f^`2ۈfaf`3pfaPP3_X.>`n+ . P	TACO Fr S 
!	& .O\n s<F	^n fFf.ףkn  cnF.onf.>kn;E.?on@ ߩ tant}tYpbntNpt  D@SIVfB.|f$;VrTc%W B!:Z\ܐ	i %Qf2$fP'fffogf"'or. p ;\n%f@c .fgfHpcfXfdf3ۃ!u+`s?I
s*"/S"Vf+f;wfff3һ3RRmEgno4^q4'r44$.71p6ɐp08333Ҹ  QW>% _F
3}5߃u'JE#a0 t 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^G uiQ`  &t Y&  
 < tr&\]p &\U  
&jN!d tK
SR[u 	F@& $F^[_bF FY<2p߀TV~'}PVWًذо' K! _^Y[XWfQwSg Zfat
  [fY_` t =$PpnPu2MtaË6!s } tp( ` j &&E`?SRUQj@6^]Z V`} jt}D^XP
~*F
  t# b Q`lF @׋Fxq d3duhXKu`<Uuùd {`hc4d & Xtû   hp7߻% h PhE'`X!$!   °ors}ୣ O
ehH   tt 4  hJc` tKu& & O 
 ` h,s@<t<uouТ 
}0u?1*`P	h
s Xh $ P &D[%ys%aPX	w$# )D )tk`($} f.`G  ck3 腾D߾k@7w À   ; Z x     0N@`^~#bhV1fF3.x% r 
\0ވBFu~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہãx.~r@V» 㐂û< f ˾ff @ffRfPgf!N
 ffFf?3fvZfFsfBf〶fЩ1 r?9pf3ɰpǿOkfAP  faþfPVa3v޸rF3X

S,0<	v	,$z.[W D`
o
Lb f s  f 
TO
T p s 	 
Sf_fp ЎfvﭿPUYP,} P轻:Fp
uf^fNfV_f^pPRp*fV|A6jF@20hC@ Ͼ
 ff  fffffXChq p  `90{ P9|" 6 a)P*h'kc7P, %ofPRhK2R ĺZP  (Q * 4f_f:aD0  f2MMShm   h~Cɀh;X;SZ?;PSSƭ@pq$ q~!˰Āu1!A tðvntt<1w(<vv{P:jEhݶ3_ P&
0
3q 33ҊtW/g.&;?u;@.Wont)@)hPmt؀a`2G@t03@ @u?  a|[
u93Q2,;8<#fN 
~
P-j2rX?~03Qr |X@Y4SwQo2P5'$a&& &0hYC hزu򿣶ɰ hj
t[ Ȱ t
嘪ŀv#t_̰,5-PXv8v&> `t`_P3 u $h<J4
#RV 萹s} uu22h"Sgu]uuXP&
wL2 Q߻ hNu= Dt= tYԀ'
YSY .{^Ze[1舷P #|@]U  Pf^ ]  _`rr	 V$(afOLP?Hp      @6P0;V(e
u^V- ^"(P*^  2oMqSP( 22 pX[úB  $@7R  Z`7               zDKtP( % $ 0rxfL+_  ك%rSr$迎rF!f+Df+\ r*Jr3w r@ .hgfa2 PR30 Z@AR `&Fd??uh3P&Xh8# r.>.puO 	AїQR.おh f3f%_  f`YURQSWF^
D= F\ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF ɿt 若~u빠% 8t
` `uPj ;}
+V 
N JZ=uϿANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              D?`ރ6.u?;v` Ql0 >h *Y`"QwLQ`f&YCC`K (   P3YaPSRP3@mn?[`H@4$&%<GPX 	 o; <BMtf3eGP2W X` Fr
JRU3 fGenuuhfineIu_fnteluV=sL=r=vS߀tNp f   =   	tŀ   
 f@3t# %t5ubfDqa $<@tS<WtO`NBH$u>f=Pۊf@+rC{tq Bt#Bt	ݱ]P0f
aff60ryZ r 1Yn`W3P[t?t_r︄h`D trr	P}RW Z
xx ؎ P.BB <t BB2J &ݾ   8u!@屋`23Ұ
ShSSt0`́ y aut0i at]U U[aSR  4hpk
 hSlZ[`-0PԻ  h5	 h~
 "BPaԀa$8uXRP<u6ZyQrtwvYu0ѹ }R0wZhEU2<U|  hY2 u
3Ҹ kEF)v upQs迶tT 9 
( ܣPf.P UfQfRfUfVf@Ch: rsNrG 2f. ff_7f^fq8Yf.>PfHgffgf uY*KU q. u, P3	fgf CpfIwfAgagf.#f9u5kpfY'0    /p ;k3h ZV4m UɄШQ ߰h$,ۊ  hf"  } OV3%r@t u;F ;
V3"/fUi &g3  f% '"ꃧ #WFfF^fañcV p AZ '
^Acq[3[<   k DTDWw R o 0 ȳh w 1   l ( Pb @z0 W HL P`A T W Xb, `
^`! p@pؾ x o A0
|\D`QWhE3 3_p 0 PQ= `tq1 @0YX |05SPp
& p  ff& X[@aa"&    ir  v|"}@Q  J+O fQQMh2 .wp/ۀ  ğ_ <t pk~\ tq.Ari."D.|u.:DtSI  wD:r5+s&zv
uAl
c1PQRfWT3^`
f@XÑ2a`2	  "	f 2f@0f@R %  3f3fPaX Ah lUv ڗ fpb #&f fa dD 	h}W"ϻ (;sQSf  r/`
 t޳
2f'ƃ	40q!a
 Q[ffY+vf[Wf+_f t%ȡH+f@`h0Qpgڱ- f@kf`0z q_L2_&UÃ uZ=PrUf%е uCf*f=`  t0  t( fu{f
1"0"fph2%/$_!"
 \\-f g&%~ٻf2@t
 <t+p} g1~wf&f   , Xup Lr}fɬBt<rwfa&'?rfhϰQЀÉ_F?7<ܣqP
  
"xa	Ub	~p@@R2BOuE1ɒcffF &Ff{ t@sf @{f;~t	uɁ~qNїV&Θ##`WfVfPXfXcr<w؀.w0ճа_Ѱcf@&ːtg&TfVR3g[&Pf0 `&fnu=жtsaNu(g&fVffA>o"Ȁ.f+E)^f^uS2u  w & PP0Xt'vt
t@0r % r/o hj>u hrs-3&>rqrﲁRPz?sRܑuthX$uul	r` 	 +Zjj b6uPS`` FF ph ro{u
@ Ѕ&&  ؀>t !$!f$< u~RC  
N<2<ăƁ	"w3A]'y@h[u TYP=t 
u2Ɋ{،в3`t<u
E< tȵoE$<u&w $tRnVL  N L Nwڰu ` t  Pj[2u
@j jY!(!!2(<!1ʰe$ h5u$0t$~.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|h:_DuQ&~% t P>X
 $.:t
 ._
vXP%8Xr6%ȸfS";J3;La    PJNL p      QKOMp @Kt  Jt P(.DGH h2h  hvQ {h҅ hE Б?E^  ` f  Cp m& OE 
v %&M߰t&:
&;r"`p$t1TKKub 
HM` `(q }p" sr#	cԊD&3a C 	H ]r5r`2gpjh!vZaVRQShY4Th5أ4J.`B68u,2
t&62@t2 sk [YZ^Sû Ph(sX<?tFhSUujjjj P5 &h8X[ hw$vawt = ;t= Dt
hEsp[û@WVS$`́$
7[? j@n< u"*׿OطhNt`-->J=O¿t1 0_ tyr rh  }S^1<  0 h{L PͲ5[ ?  :N2?Aq%  	
   }VFPgbǋVW 2_2µzt"@uG2 
u
2u 
 o2E2&&&EA &e?
td&E&&sE E &E<r&}	rw@ VW^2۠^2*à
&}vPuh^VRPRQ3f 
%*t,AYZXRPSQY[XZh?tu	pp ľЄ> qQ? 5rXYj,: tY
)֮hERL&&  t8t' u a+& n+q00r6$^$ RZ& &&K ;`Z@ `dde`P`  XU @>
ڹ ` .PB B把8uG` wA ; w5䋀/)@#BS 냑75VŜPX
 a@A@ B C    ÜFtV$݂%Ȱ%<;weċ X؊<wM3ɆQ#"XR<  YыƊȊ3ЇѹE pY8@CH0	 FWYuF5<uz`0Df۴&	2U
pu7f߻hNePӀk ='B@. ,".  Ƨ&k ο!< uf& bÊ$
r wAu%1uh6Ӳ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh^KfKff
f'h3?f3f3ɹ f /f0m f+f3 ! Ku*آ'3ہEsV4C\` a^_^fZfYf[fv3hI 5R=`2K ۟揀L0s< |&	3ytvou4PP 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .\3۸ 2wҹ%&@GaaÍ6h^VWa*z_^pk` h$h  uP$<X5&sf @  t<   4 |r	.$<u
 f3hh. 
d?]XiJhT<  tdbw_0s.>Nwfm tghtC	
A!U2 u@> l = ?]c 3Fd@ e f Fc~ce; 4~e uQ@@8 h`5
P	gchBFe:Ffu1r,
 h
 Fdt~:   	9  <g ht5Lh$sh`!af`7UPHh.$u;E#f% PCAXt# N h&Ng r k f ̾   F^P XSĻ  y ,  o   hbS-[t(t@t,&j  j," ' À tht*dúG."**{/.q<pEq+Ë؀TF/VU2NfQa dYF :uEQ]g33t
t
u
1t#u
tN02t?"FF0u3! :5tFFdz ulm29p`F: uYeb +Πu;?6F1 epp0Fff`Fup  ~ j(j	R	uaURXhQ2  pɺ {F1 h`6BZ]coRfB`?r@!  togRQ Q;YsY2w$
 !u$ %|Zf` / WWeI.&]f  9pC`hB%
 C ƀu0u.> 11fa
ZURtLށUHh'k<:Ym PY8tn(tp ;C Ziv@"go squ4VfRfQhÊ+%0;p^f[B]8" a[Ybh
$q r 6Sj@ 2P s rG=Z5'/UnAW`.ﳪuQtK$<u:0pPr"&  t w tt tAt $putPq9(*
ː

w ⧾tK`XSQ 3u,S?蝰[rE	ˡ-Y[C& <ff<`00xx00`֫Qɬ||	>>.p~r tr~ k(ЃrLZCX̀'q@VF :]Q<Q7W &TZs6B  D ц߆ԆrA zuN! C _u 0/)0/c#-&@o 8q2 E *7&/p`W aUfV3vCDPDQD 7p4f^]&ÂoQM"%  烪wPduX$epI:eXac@ `` /////- "  @f%pԶк FACSPJ 4DBwGP4BHP  0944 A!  8  APICZOK	6a	a
@  		`
  MCGFG<	$P	  T   @(@^
 2! RSDT(  "	f`hfj4hsif  fhpfp  gfF_gf  FPTR ff`WgFpf}.p^$f3..趀f.f} gfN0~$f+@hYCگ~3ffgf&_f.>0f(.߶t趯22@_~( N g&F	f P  rgfffff+f+.ނ
ۑL.>fY
$$#D PX_ff-qAFV3g&fFgoY[pff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt"@H Qr< uBOаNRUfQъ̓2 twPxprAr v; tg&P)Xf?Y8]МV_fWfV* f& f׀P&خ@(#wf"fP})fȀ$ 4 
Ȱ 
ff	h⓾p (f t = h(fPW EfX3 KPvdZ{$ vc g_ q+
h33=a+0Q;g&h&_g  PSV  p,Yt >6Hu	Cx : uDb& @ uޠ  D` ^PRW D h: 7h;_ZQ4PSWtǸSfP3h f&L "?f$LBu`#L fX@`'h#4" 03ofpep&?  @ 6Lu    DOGoLf3{Ӿ pG   U!   L>L&geE E puMPMLGfEtXAtߴ$Ot3 t)O$fM~
rþQpmMe&LaxTb#,U  r. ߿]hӑ.<jn^   jøPݳ jڤWp_f
Phfk0kؿf$ttӿ& tϦPE'߿ 5(ƘP)io_ԜVΎގeD^ 3f`FF  h)<w }ur hA  $g(,0w4'8  "6Ã9FtFfNA9F> h4:ɭuh(fa`󃿿
Ew13ɊMh$ӯt

hRp;r#uazc5WF ^SCf/ fN^Nf.9ߗ<1u @1tc rfߺQPH_urf;^uf;Nt;ft) p 
tF~U_Nս MfOV t;6(.<t1!QU)h:,_,  ^_U00 u,h..D+hXك/ p1_fqtAﰑ"   u
3   t'0gf GhECG$L<LDCOMPAQ PC Card Smart ReaderGEMPLUS GPR400PSCR CLB REFLEX 20241 PCMCIAReflex v.2$cr$HP
  a@Z!g&O@ y?Gd `P ߳ rLfK s%nr>G	 .D
A O@.d.D4f_ PQW8ù  
G.g&:uG Y.5 _YXQ8t *F 
⡤fW
"
@
@Bg"

2%Qf_V`bS蟥h80Gu#|  euu .u = Ў~ 1rp&?tj  t_& rT  r&= us0=6>
r/6r4.؋V@< t ^}Jw 
x y z   h`6Shs{ 湻%Zꕒh}$asia
qTrP~qtI	f} b
|u 
!tQ&g7s	GYV
~? ,`؍vfD   ߺ,AfLs-<t(<#@06 h(	L^PRU32t
t
u
5# t u9<0r<9w/tM>ư7SQ Y[t>"$,0>*SQLiE;f 	tu]ZXf`3Ҡ&&h#֎fv*`%߂hÝgf9t0Xa` 2}   0 thb$q egf@ Vff3f"gf F ff!
!޾S3۹: 8tCRP #ܨt r1hf uf@q  00i{? 0    0     q'  ' D 
 Y/ bbk`oCd@GY k`ʜ,1PS_.KxVW Ɍ׎Ǎ~Qr&} uBr	: v_^|d>r5r!ҿr\E@&=u	# #Hr&ߊE$7u
5M`s01z¯Yӆaޣ
r&a)rI DTtr&ge`4o5
ʈD
T3
/44S1r#@itct  t$BffL  	] 	WQ
Rʺ3q
]
f̜́81i+W!z Pr8u`_QY_ܢ þL[ r&UþN׀7L螳`
Pw4$X` $2L nB0<tH`8u6
uBp & DBlTt
aP 3 r/) r%BBn!J@ 
; 05 aù<t

B Jw 2o@u8` BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&a$vQ> Yr	2Qd'Y}B@?Aq Br蹐M^	 fpb3׾SK @ Pu`ңPA\SX 03  _YPSWQ3 VSVt
KVt2Y_Q f`j hb  H hS7Xij hÎf% ff= @u [jg nb Sjjjj P5 g[ h[buqW?j&]$awtQ= ;tau= <t/Eݳ9 _hZtбifaÐ    翴 tH{!uu):p0< u}{up@ z`3pr! grπ D    r% Z@׃-Zҏ1p$Wp_ǀ uu' 3a re+ tg	%  .ﱪfo  􀞰f ;tp/Y[|z~rs3hƴ Yڻ Sڻ= Mڻe փF  ~fj `] tIe7r=> ً~ t@ٴ_@t0(5@ MF t w0ɓ3N !F ~ twٳ	u?e0ﰦSZAt9A`j f` Wf3Q fY@ I8.L"
 /2uJp2:!&= t: %J r l0VQ&ǷUq
MsY^D=^
eOf"Am	
pq
6&:!& :X.ۋ IhBB 
D@P w(3 ?  A-wsC"ups	1u[	q	1D!IFtg$a3; 2 + fB \	(Nf@2Bt1Qr$!$$
7oR< !'Zt'
QVJPf^DתUYwR.o&++t'H"`Xtǌt.a:``s; 6sbc_p_pkocqooo#dooao
fotaca  AUO
 B141XG08 V.1
G09 V3 
BOE HYDISHT14X1B-120

QUANTAPLAYQDL205SAMSUNGLTNB-?L02
TM>P1EA0VOAP4@3O@M4|A.FL07213+              Ȏ؎6ϰr[>Te  >fY w 63Ҁ`37BA 08u!!u
( H 8u 5	3ҋ?h'kPW
 
t_   @ك
_X7 
  H    SETU ˸ @؎&м  x r' hW@ P& u_SV  GG0G hc    Gu Fu t3  hC) 
h*jBt & ^[SO
&h$i" <[U샿VWƿF F@    [ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @	<qt	dR>t <tjjjj3P5 '.wj5g$<t.<@t$t = ;t= DP hEJ 揿  77FF~ t#^FLr
F FQ  ~ wt: ] ?f
 h8\2%PFAx~ t
F`_^Q
h8ss.&udu   hb,$?wط h*"h} #hH*f_01Fh{B%..  @  Y(`p3WVe1E0E.WV .^_UP)UIQS6(6*`e1E0eEE.U s@ m2a h4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	 +QVW?u% p ux 4  | = <t m;@C
 )(_^YqRWQ` Ê uUCrr3ɺ ڑ܋%ZAB rN _Zb1SAWIpIyI
WROujvzKMJ; DE<@ ;<<n!<3aRu BMUEM0Nt
Mm[VfPfSfQmPnf3f3nPn<nXfffDDG(	Dh fYf[fsX^@t#ڵIgO GxnQRpA3wۊ9 r Cҋ97wB`s@zfDf3fË\` 	
C  S T R U 	#	7	K	Y	`hvh  h	 h#	 h7	 hK	 hY	 avv.L.< t)F.6%3.PF.߭h\[+V..^̋] zDF. P .h_Xh7؃4Q  16V  0"Wa X Y #Z  
m[a ` ^BA\a e f']a aN _ `gchi!j qp10G pppQWĀ>tk		 u	k	.s	_7   O 4a9Rһ -w C./E2P+m?n8o7@W3۸  _f^߸^6_>QRrkPS[Xh(ȁ`fЍYӋwh
3     p     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	t ;	U   09/10z@ 04/27/05 kLit)e{{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdPx>0@Z˨"2""Pf"x xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`ר@pcŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5FMGGuu!
kүx00PMl}Dxe``
$`$p

xb:
Oxx txDESxxxxfD@/10y}}r k ;K}d`xGBF8&x}DQ00xtxtyuup
*}iQb}ps ~aU}wc+½*").xjD00q x^Dx_T_xc{D 
T e p# ) ,}1_U
-&0=!I_	P1Tx"p2xp3T0//}@!T^ ^ǀ$ u!`	{T`#8 )m$04`hb	р{P	;G	¯"+u+$?4?iq}T+}'Ư+p (++Ô@]B#,+G
H
0%1[vP7",`]@0/}@jW.@ /1@'"  "+7x0&x+7x_`t 7"6}

P} }	!	  @A
xPxt"xd}<߅}?!" * /}AZ#/00x )xh`xiw  p 0S+;.TB+x+¯0))0b 9P4.+10Bg+`xN	+ xTx !
+:DTBKPFp y+YP>

pB [Tdp+$!$OP+-`z 9
sQ` ðÔ2@VD0¯xx7x8r x008`6%06 @T߀G`	p4UFm9A@#ZIZ_150ϙ)4E"@W@W# KWQx,pTxtx0x,Q?OC0xT?Tx*W-tx+XZ >TxYYL^ZLL&	,]Wj`q!j0Qux^_DND0= >@  U>bgxdp&b]	:<	?Zu?h@jQ@*ARx-	+_SRNx*SgMx+` Kh }`R0ʀ 
0oeQ`
 RSPP1 0X 0Q]pd GXuWxZAYAXNS[XW }X$0Yhp^qZ1ZTpLZ1±
YZ[l0c1\\T0Q\
r[	\S2A}; A}A ",A~L B~N  5A~M uuҌВ"4"7x'D
 X /7d`!7g33TT?O`C`|`07`'`2`=`HpQx]w 6uuuu0k uu0 uu5ˏO$ƨpN`0T`
0100@A"| }(Ex]ߦ@C"+,,E+p٨  +C,,+ +,+x,+0@qx!,,,++x_,,"ߨ-.T0y㧠L721wt
!Mt&Ipd `1g	1}1![tU<!Ҍ(0響/0mp/l`
/0d@TpyE2A.-/0" *xc"+xt`
o3x7v0x8W7tP}
0h"[ZYYcrdѴYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >Wg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~@ 2 Y	J @ | @ s   ww ~~ r  "8x4D` T ` D)tX@Dx2tx1tI-&%[0& &xpvv ?&xpk[CSxr#$ % % "2x1 	ү  ¯0 $"@K@3#b0"	Mx3C
r beJ"xqOF`V0 p1#" &	x30$0%<T`P#"xr`bfp
0"$""tT.4} 
xr$3z 
`Hpx`p$S$ yrp 1pxnv"x~0	D0$ 6Ӕ@Tx~y}D?"0p4h3xOlx}@ DT 0
9 pclpB"pxt1xux|"xtx}xuxx|	"xw#xv6Pxyvxwf`Ӏpxw ( Quk}B@
"-`a"x-Pt %-o0p0p tU0/0b/R0h0o../U0`OU/`!!.-[ /0/0u/ u/0/-.!P/0!d0`Ô@"120! 
0
0!

"0!U H U`pU$P	<U0
`Tb" ! R0  /ZP!1D12nѧ2!1¯Frx1"@u Tp""3453 /:N+"3554!_Q0"0!xno`xaT`a͓xmp)nvpP*r 3}TOp0@0 0 
ֱ]):Q}0`*/[HP*'2BwP`FӀ@Q7 "0a T?2u$407S0!{z}yD237
8
u8 7+
`8608606@2$h' @]Jp4?

$Y	0
	@߀{0-$`
$`$p"Ga"߀V4#oK0! :0!@À-0
   4s	!l2!
2xnfPYo0*2d|p06SU{zy f xovpW%_`gK6P2 ( 	4  E @;H	53o45q3`	t%5544r	@ :0	h0"06`	2A0-6< Lr@1k 
  
 *90 B 6, Q
j	" !!`BQ
p0( 63"E^ 
-NU
]DU 6.
Jj'	@bG+6,y ,yf-e2pO7)0	LP85p
&0Sy		ay	0
¢ ":"0<8;ofpO:!/c)[P3
(.Cxm`qe`?0}DН~ h,go,!a,a b}e"4xqMNOpxD  Pe4`^א}R Vp0
T4d`$"4#`p~}e4xd@P3 0
3 $`3`3$`e$`1$%7$`9$`$`)3K$pvAT nq2c1[0TxvF>&`!	0,w0)%m0Dx  Z30a 3\kP)6P 	@Rи?&j¯4!`p` pJTQ`xj  N*`/19xv
xD}O`&h0{^`
}iT?Dt8`PpY9T~:wOq"@-`T`M	0676$``$p``1e7`tg7r((b)(0'0)a a
Td`x0dp#  xF 0TÔP
*xFtpxBB~zxNUNw}wxJqJpȏ:;<t/?=(x ү!:%$t=t=;2!(0 (=$Px`vT"` 2'<x"3y:; 0( ;:@ p0 xvs6QxV86}'p p 7  %76(I7  ""88Ô@`p/p0 
(` /..d`
&~r7(TP5O(  4 )4 040@O453``/`@$pN~54:I&duP2);P [x 
33oppG*L2]>gp1 'g;P"oT~ +ڵ?T#>үd`pxH 8@2M2P65b3e1@d@>?"01/ 
m
`,R0xA%30 Bo1
@
 u0E00
TDTq@5q0	 3:@a AP}Nt
 u2P2btl@
G0.
@	  r1l0dpe`30!DxFW105@2U`e bC7xnu30 0u3}r2+(ߣtw1123#.1}p<0{ $32  a<0 }
1pAR ErspM"p  d.1BS)x0,u`2:,`e4 2UU.X5%.,*ۀ 2732pha,
$,SO!% *R5 
Q'x`S+0	+_+ '-R	++@@@`p7v@}	 `@~A0y!T``Y_` VWyG
7pDxp/,LDy?N%@k53Eop;OCD߯.2qXTQϠu:93: !p	S3_1B3dUA`hy%%Ovt0:QON@pHR/ N9
d.0
`0nX6Fp0X-64F<0570`5#O˭0]c6e`	S8@1
!b-1|I%P/;u1
p< u1a1[P։*C{p4Iz5z5
3z*+	yuv {| A+ 90& n`AT0 +	al:hpd01o0upo6o,/-.rpF}}?0
P?/.-rdct%,f Wu tq70YS 8S;"Wΰ4쑔p1BŐ}BT_0=_<I?`$<p:T0Oܑ78e`pYלBxfT)Ax`%daz0  87`>P$4 q"W¥A3U	``uqq
r	1Q`{0
}
9ȷrdP9$$P6"{ 2F/}&e'AChS4Iqo}aw X@apR`pLxpGN3p?u]1ԒU^#5_`@TU`#v@|T kx{}Lxzp Rxy PxxPQxwMxv0Cxuxlxtxaxs`xrxqxxpx`x|Lx{`RxzPxy@QxxRxw Cxvxloxup&xtPxsxrxxqxxp"pxjv00,pTxfL@" -4j0-TxfQf/^p0NP -^ ##----Ji C?",u/212B0T-_21Կ^ L.S. 'q,Đ/$7,T{A?O-.`.pGʥQN.E.NJP7]Ĕ0p0Y{))y0h
P5
Ps|?`d7]}OPn,rt7ar4N03`a2Е
3p1
P

Q "u- 0;9r"l  },n1vg9,  A3.02'.pM=1s0D@dT0u`zP;DS,c,u.B.` 2 p0`u.Ta2C
.%TO.лQNP]03p	 ~`` 9a :b K$ :b)NӔ@6S ? x0!  x_60Qq7prrqxvWU	Xu

		0
  `
7P"q^ +
G1opTrAL`>M)60.T`s@}w?}S?AP33TBDWD  Axj6"@t7 C9xVxF,dҢX`T`HT
PM>@C!3"x)"U\]@0Qqڢ97F 03tv`
pUr )J'' 'BpP_P` qmw0P `	qPa"NO.eB"TO=EN Є1n`=J젊=<A=<aYpo0:BP e0!J.I$:1PJ+1,F;KҠF	D0c
^"CO`@"HIOv30aA!Idp l@0tt A2bIBgJ``JIxnvHI<W"xFExGFxEGxFt@0( FT.`xFF0xG@Ft"("߭F?6 0 G=k"xUB!C!A!B/)B*( #UNA
OA
MA
N/I
N+)D
J*aKaIaJ/iJK
I
cJKLMd`NPT&` v0uK K@ 
?MLtS QPHKJ}i}p}~}wEAMI!9..Cf Ô@"TxD[T손TAnp {@($0*E;@B}@RT`HpC}N(UA\AVAJA4A(AA @@@@@@@@@@o  AhBQ HpH"4pbbrAt"xbo o "CD )p3	0Np#Rq! * 	Z\9V NXV$`RQB2b L$BaUӔ@UlOaůUP0	xnZÀӒ ϐ}?U`#`5`2$pCx@%< D4SS [CxaUUT`͓xms'KYq 
xiu GÔ@π<PT~xiCtӔ@/`Bpxr
T" Pt`ixo aa?v+xmv25rt4}npt  tn}D
 "YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTkATAAAD!@b*>!Eb $wF
0U`Ud`0)uUADDDDDDEE
E E,E?EJEYEhEpEAEނ9D potNA8`pC,D
 ȆmT  g ۗ@KL7 &T F87#T9Rx@ZElQ
ha>W`P A7{O0D=Dd
`#p`(`0<`PdP`d`U0يU09NN!ǈt@td	QRxtx xXx\x]txat"xbtr}xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx x#x> x=tp x@t	p0xTВ
} %xtx"Ttx!TTTaD	x?D@xwTpT =TT	Tx= Q
@TxDp?=DDTxjv0}Ct QdMdR eP@eL`O;K"x0xJ/"xg/L"B S?/?@>"ށ$tO>1$-"T_Ô
P~0~7%UUdTT7%TT{ z yT H H+H3H4H6H7H8H9H:H;H<  H琊TY$1	 Q
 I`A  tR1~5HT& 8 `;cuTuTK0T"$`($_`*`-w/qp4p
TmђB  C~Mb Q P"RLT$`6$`!`0`?$apA]B	:3P
2 *}_05 u#'/A
,P3`G`[]Tp]A"T @ dpF]I0$ks `!DࡋWTwwq" T U "P$pR_PLQd`DQxgQ PQG?Hbq@P
pKPoxgv@JJJJKK&KHKLKgKKKKKKKL
LLLL!L&L+L0L@LfLLLLLLL  L0
1v"xqMNO`uRRRsx`}e  /x  "%m"0RY
R;: ܵw"} HGG}0"uS@	0SSST
pTS?0CSP zu 0P/ 0@4xatgvajQ/jxTxjD0@FxƋGxbx"x@$x%"x`}KW}IF	
Q@L0""3@H,xT| } ~ J4Q_
*N`PRR &NM((sMDMJNSNbNmNxN~NMiMqMMNNNNNNNoN.?PAÔ`P/."T? } >00xe@"QfSQv0Jq0pV	@ܰ50T;2uQۀ0K  0q00)	OS":Cm$p
;`!/0Qp,"xdP @e~A3}"~}e 0?IAR3AP>2IQbFbO0M}PE!@JWCWEA .XNY Q`lT0b`ȑ0O[0#0xD oTxh!1?xxhvYT 
AAPB11u32}'  $31T3322@"O0  "(IW "   p}"/*Oۏ0/Ô0/pC0S00O200`"
xp0 "P%x@B2345&k@"(t?3t 2'xA325R4U5B axQxQDQxQ  09t6xpS^vnS CSQCCQgQQR25 SHSpSSS6x
/0!x
tP/P
0/xu
  x
Q{Px
! $60#t #T %Qxs	}TBxr0xrßP2P[0 pw%@$Td$ÞPxxr`1 	^*1^$,-u7. <Tү$`&`p<Po} p% ABp.-,6	%xxsӔ@v $(xrvyrxsP!  P&0 	r6
pxv 6xa`r
 qP 0	,xx
xR!x	06Sǀ)^P$3p 06d2S STTTTTyT	T
  U@{}pwfDA4 D@ @B@"xDbU$P``3PTOW"X  +D "z:hTphO`/AE@E *@@jCEpwUi O~@ w 33TO"B@dPR@xrp0"p<`p}T`- ,*,, F_5@S,  lS,`xevS,,"+,/0,Vb@V?xw	` }wNPIV?u0 u1SSS0S3u2 u42U03U1Np1%10304440}P-5xp7x	410a^_5?5,Ӕ@xA=- X60c
+p00Ӕ@@6@0,	`	 VVW
WW;WWWWWWWX
XX=$XW%Xc&Xl+Xz,X-  Xs,6S	XQxu/@xBs1W-.![P
.-`Yy	
x3 t?e.pt e-
``l	clQrl"	ߐ`Ax@}풿}tx&܀
-   bt^,nQev  q}U pQ t u vAO}	}15!`N)qS Q!q]E"P/s0 ,+o"_
wZHXXXYYYYY1	Y8Y?YFYMYWYaYnYuYYZ"3Z8  Z3PXZ8Xs  S1
tt)Qŵx#	e
pp& YD lTQ@ST0BQ
b:Zl0a'SP֔ ZP  cZP`!!I0~GJt(ಚD:c4rKrgQ
xa)1O`KD1P,1P
QJCS[ "gD `E -Pc80.u,,L,SÔ@ .",ҰP#t .`
T/Ӕ@""@
u/$ -$U_"x@| T"5}5$24 [2+[[[['[/[@[I[J[K[N[Z[[  [  _Q	xk`0/_" о 0/ 6u2q(Q`Aa U " 0f33%$/A_^Pe2pG20640!+4d	`d
4FPe"~anv"q"44$`$`2$`B$`J`[$Wpk0˯[1P S_0/V_QR
D	qv3ڑU4A@EG4pS
Fo
D""""չ0  0J]t]|]]]]]]]]  ^u2#^!u22b ! 0#! ZQcPwyA=r!
C\kۀb 6rW2UDE.u8QZ/0!rHQ 
R 0 3P2"0"x%0T~t@"@7@P@@	T@3" kO0!xo~ d P""0 Ɛ}t 0	i^j:0x0x!TT`Dp T{!!D`o!T51 7ZxD@&`?["  :	;
/123B=>C	D
WX`~x`!ÔP ^`_b^"
% F`7@0x+ +axqaw+s+I `C0/+xT 6 } 2.uY DT_`6X PcTT`40w	61 ` S 
0cx	+$```9@=`xv 0z q DxT"xStTTH_[+xS+<x, 6,@C`$p#xSx+	x06W0/E!

?0_ "p.-Ô@-ӔPq @
Q=PQ/-$$cp50/NC.I}O.A+ 9VP`@\D>kT ]P-Bp}} bޏC.e.s b9@ $~SSN`R$dp[. .Qs".xt dpDaQ0ӀwÒ/@ۣ.q xk..TP"-.{{ i"p#"x7"! 	ӛP	뫝0@@0 ÞŴd`PÝ@ӛ@*pÝP:;<u tkt"/01234u5Pu<$t}5}Ю/[ccdLdfd}dddd΍dΎee1e1eTeTewewef8f8fwfwffg3g3gVgVgygyggggggh'h'hlhlhhhhhɽhɾhhiii&i&iHiHiHiHijij  i~K0~ %~ p0% pC3/}u: u; u<3{bf4iT330P66
~ 6`  fwR3`0u75u3@u:u;}u<{uxu{]{X$::;o<{&5Սhg0  _2Uh)gU

-K><,@1E` 
} P0Co3+R#~ 0`| }` @^_N#`##*(
"&

5P)*)Np<I?d @(Z
c#t 111{T!7(+(U/**81U,/,h3/U1/5H13G1O/|@TE1RBA$__TWB1 Wu2d I'8BVX9$9='U8FGXCUWCIˈEEUL͸GGUo`VII#M0V6/P!}VbhQ/"qV πu3//\Cq/4"$y`p!SnPpnzŸ @@ "@A~G`jPj$j1`T}%A`"`"xs@}}T} U  VxpBBxsPBQ0$70#"Ap
 "%@AOr+ 	 	U		V 
 
W
B_xs		 ے":0dx>T=@Q
3ߒ8T>?`dkP?ו>IIPw0=p1;P8i } P' 8@
ఐ|? $ >D H0
0k5d Ep6"}`~I }oP k#@b!p1Pg0ڐ}P@ HTTn4 Yt
佣#Dp!0PAz߈5+r++/0
~IС+2!_$QIuTl@&nՑp0tTA*pyP 
41nll"14PmuB1xe@606
 0ǅ@60'Qk0e}pp
T?T`4"4" u2<}0n0`~~^z0kTODt001p32k2]* u1tAD00 	3yP(P08?PQ@`2UPD2B32ӷp087Pc`&jRP@P}`"aR{3"0PT_O"
070% o03f3@,pe0`!01?2_Vbeo0oP3ఊ1!n10~
_  c`5Fg9 	1DMcA&F=@T3`02`;:+"45675E4`546NP
(4`i77$pTo`M4`TM=`` `'p-n>Tr AE D i0$CBDüf0q BÔZ	*u1au0)'2u0p
1}}G]34Rӝp2u2{u0@*> $3]@P20贠' ac@'
L`1m`2^pڣEl;8002`BTTT%%Oe>xEp0>3i`D
` 
p	0dm`0a1\Q]T?`<@7!?$p*?3t?T9)e	 #c HW@01	a=s2`fO"c"Mc#N$'NTRtUnپU$	??Q
o)$	U6
??u)txdd7eU"}{zy#Wj7u5dj12u504]<t`u/'P#~ s./ds5%t#\vh~@_[tQrktW0ppT0qN`۔L=2t[	ÔPt  q侑o``z4ѼU@c/Gk4373  ~v.((svpvwwwCw{xAxyy{	{||}O}}~~&~G~h~	{ z y4k	5P4F w
QhST{lSp(1
3D,t?~5{u4`u5 ك	]4T`pd` Q?
p0
PFu	Ir	uzLoBmP[|| ]ax<[}} pmi,iiPKß
Np&V$0/Фiz (
r67d6 N6@7"PnRPJd0,v e5p4l`&{Jqw!8*8EU| `z {E` @\]Lvv8999889dp#!#f8`
9#
							@45q0F 3t[c9_8(d`픜!PyDA-0/* 
E0
jZk<ÐIIP2SU~dLpt@+#aM`M8@_ɫq;mpGl`T@
`r/@;ňqdNpt/ ,V+/XPՏYP7[ZNp7>	bUodp'pNCWWriҞ/'P#^/i 4(?Rdn&pfJ1h<Aj)=Q Vv>afx?Mr i},KD|T-`M03980,P78+3? 7v投3"27傐}3+P~ A| 3$`A`yc $'~ 2ࣁ'u3#uxo277 dER t8u@`
_Ô|		q@	Pt7pz9qTT Np: );4u3touq$xe3`3371!`04a wƀYaÀ1 PӅeP31˕axBdAU́1pCϑ2"߃Ӄ}`τ(2"u0X03} BY%.჆~]N0
:>F2pPu2f	opw`8
0:
``ӕ19100! ^xeT`&}$31dtP2"u}`q 
0"""4}t(t sP
3U02	~HTD"LION x9pP
 wDIT":p
"aI~? d˒^ ÀӲ  0d"0Ӏñ }7p8`0;@
D 
~Y,T we8 (@_p 21"1,"`"x0 5"5q"psx 
qUvs>qf>~ 0ab on`dx"j7 u8X`,7bP|  `  Pnp	84gk8$bd="89F;u<98~N98lpe;~ M9E8 `v j@@~+P"~
mȡ<0&Ex33 d ::Ӕ@o:@>x#,	: ,Y=x@A-:zQ R0W<p 
;PB
$ٰ0\=<>?u@`"H P/A(p??p>ÿ?
>`j+@5ސ5@@	x&Tp/"%T~ O7&@{"`"!F"x!To`	TTp57?3o`12D"C
xCp'x6p>A4ra/T(--,r e,p,,~Me,`,,|21G3>d$-t"u;2A&8<9@Ju;;;`P9:@@ɾl56x>FM
 pb?b665 5 	d` 
GG~G6CI"] DAJpO*q+,U
,, +,@+@^j&@T` OFG$&^$xt
 T0x"T1T4TDx!CD@gp
0g1dpa23%3{3+232@
4k`V4cmN(%%q
OPZ`a00*OMT@eT+		"TY!~L` #Aq""	߀F	 >	@[2xp=dPX LҀƀԀi@o3ꀚڀ3䓣łŃ 
`	"3/ߟ$ ̈$ P ##EN``#DsB"P""):0"P%g0 "b``"  )ߍu/33@p " 3@P"Ø"(p p8

r
		{
tQ
X
	


 o*2	1	"<t 
""BBE"""ЃЂP  tsn6 s$ŃŃ1" "%5|pbpp
߂s@h`1p1 1@~1v$1@n1 b1V1J1eP1111 p0p00p000#Us                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    P  J     MESS.wj?v/Oau!U6f#7Vy,HXm
	;	M	\	v										+
;
A
F
K
T
d



@yk
^
n






	!%(08=DKQZcinz!Dh^~=]n
:N 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
602-D ette Boot Reco#rd0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the conts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7A proc has bYeSed ags n@orQCMOS13- s aAby POST 1155BoaComm P6 Assignmlic611-Prima~" Flopp obz2-S nad01W#trol`)y5G%sType+1783'` Q9)	v0C0'Ef& 1	&8	3XP7
~60-Fix"	doe"sup" Blo,Mod117'r[! Aoμ$173_{	DMEA53?5?@5Idp@ify=mmKl4O>	|xParamKr TableWBI>tRXHalpB  52PX[ap5.Invalid elPronic serial numbeV16I/O ROMX3`7KeybA630bF83047@b4cUnitdLoadalWl -\h44aMonochroym`Rl 164iSiz=_
r2rXP%WInst0letworkZrvDAct\Nso &aach16`KoOp1gsʐt^ pg Chec2  PCI BusJ_10-Exn`StoragJevi0sHPnHPFA1spV  Ol4!14Y2%3,3_2Xz## Se(OC?HECK a#@ yl3-Ti`& Da @ X    ~Power-Pass0d	XOK Do y[oullЉa to p~#~s? [Y/N]

AdJ0ia 	R[or!hip8nѓ... (ABO= 'Ctrl +t` Del'18-1@#h: $pHchangedZ2: f*mBqneщq~p0+*3/: VideoRTz-4z:Prrup fX5_i *8]6_an ^Qexpans1bPt  Turn!!Rej`Кfs})<F1>:G Abp
!bq^rmal820UZ mupP#3giDwa,6#+Bk1.(Strg+Un/tbr,I n%Tpf0ow$o$P6 utom`c4updQ,: ۘs ToX miX: KbytBVcksumk,NfauP/kulcnW1Next? ErtiExfȠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu{ 1 MaiAance!c
 Hyt6.<swi@s us0modu+4nme@$+requireAs.  To c.d.% LѣBU7MpibOOay1__2_]re搫excee@ !pӵb1| vCircuvLUnw l!n$dy.L.(. ddoee. U2S_0m"SP   2oI#c5^ InrLShut
downi  `0	-a:1Pe `;PIN: [
] \Na%left+0H1HB@6 Pu`Úo 
v^oax`ˈ`Ӏ,ZbauS UedLзcuRc7hipbeQTEpmJoldNew _ !upu0cF
!be`$Ȣr"-l du<.t!_0#AgJ N[!a
 affmHPma,t0b@mak5xxлunusPVItIong`6en! 
f=]%u0l,Jrec2I`paSAѣF2Fj.ERRORYhQq <!!gonefyBla MIpx (MSGIDX)   Ճ  L   P DSDTDSDT  HP  nc6200   MSFT[O"\._PR_C000   1
 O_CST p\/_SB2P345`p
1L`
 678p o\/9O9?Aa{ua0 `a I{ 	B
 p
C
  pp
D  EFsq10C ]G@PP1V WWp11p
Uq2y2y2z2qC11 2D
 D y 

BEG  D
]qFIG_
&
0;}9
d\32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 74ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD15phg	gi
 a6g7 phpi p
 fA"'ϓfg`f b 7f cufvbc``A89E
Microsoft Windows ?ME: Millennium Editions NT Cp&AF
3p\_OS_`pga.Sag)`B9ߠ
bra!718ua
 6
 s %[I` 
u	A1h3Q0841A+85_INI AH2C
fpig
f0@i` g@hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\G[K
 :D_HIDAJ	_CRSR E)
&	@M1
  @NN 02
_ C021  +2tD2M20N4C@5py6pB1t$5?EG27% 8 9 A r C"8ۮ([0
D   
,[́D1EF8[
 3031	A
[ہ1 32@33Q 4 5 6A7 _38 39H3A
C@[G3BZ!C"3D'A kEpF_40Q 1`
42 3A4j56 47A0B 4` 9pg4AQ B C DAEF0 @C05051Q 2 3  @!54 Mn@,56
E!`hpua47a}aoiapa ib{ab[N@102E'
_C _ADR
 [&	7 Au_STAp `	
8p
9ʅA`5B
T
C[)5B{qr A D C0 85}CUo5CEr2p{5D& @? < A@#5E [#@FK|60eD`p` p`bt5C}e Ze` ap dpy40cCdc
@zt
_ bdx60(60Qbbtd
qЄpuP@2dcrdZ5D` dza
aa{
N `afuff aOdu`['A
2Ja
 63L

 0rGwm
EDw `9xH d2?y '
%6}
} 3[@r/65pibpkdrd
?edA
d hb @brb

bhUbp6  781j`a6U6S2 7K6`66crc68BbN 9!warj63ab ]b][`@]
]
buq]atb
bP c^a%
`bac `/$6AS SK]Z63
66 }6)8c)7BP=aacq`\6B@23~_S3D
p 4D
eL6CU< W

X6X @4[ 2E [P3F%@ 
|"@70
K70a@{^.h2BA7E1D7 HF@[B:H qc73
`
[S7374 5 6A7^78AW7AW7BT7CrAG7Pq E pg7F C08!^81Q !^83 `4 q85F#86 H87 l88O

d18892j8A 
<[=   @0B8C 8qf8E2@ f90[ 91qd9p92`
[0 P3	 A94P
aT95   9	D97
8$
9899!
!
pW9!
9k@0~0AgqC3D
[! 
EA9FA0Q 1 2G`A3[#\_GL_Rbp
`{ʔ`[!
dv`J`QA06A1@{hPjp
p
HrȰҧ"ǐaPA2b"a[Jp	rya
c}cbaa4 (8` 3A5x0 A6Bhiۢq`oy`j0OA7
ha!3: p3"2+0àa(85V1(@pwA8q!ip@"m7 +FbA
i7\.F4C0&$rD1}j>r5[GG@:*BAA
@
[+  ABACQ DA$AF06B0 C0B1
sA`qC`C
	  z{` `za 0 
bw
t
	rabmCR
 1@01
A )U{1@rv"OLB2
pI6'B`B3
y
rw iPH2AE`!B0a{P ` 
p{z1 wip{a` rbqB2ob yC14	_C`pEw
h nc }r    AA3
ccFB5
l
& B6 !7  tP*e _{ky
 .B6e} `se Aj
=7a{`ц0.xq8@p #b}e_
e/p !	We oe$}`@dAy~A4{k
 	``;}qD
 ЈAD y!-Dp/?d1p6Bd pAB"C Ce@&{B9q0fB D dy_ce@
QTѢ"Bhif"f
j
A@
EbdB	U!ba'c@z!Dby
PMUT6CTHPCIzBb(p`Abۡ	s@bE/cpyacaAEw'F`FB0e  dBb[F*BGGG*G0@DBSϏ 7#BE
@BEBC0-__PSW12BCYC0 (!`>C0[(`ІC ÏЅb	C4uVm	Vo	o	o	o	o	o	i	5R c	po	o	o	o	o	o	6u-ҙo	o	o	o	o	o	$N!%[M 8c#xA#cBC".
[@d   S/@C@&P
[`CE  zCK`{D0DD2{ OлD3  0D4pD53D6 @~  PD7{OT 982Q
 0D=:s
c 	9
  2A 0DBSDCA!D?/D(D///F 'F//f(!e!(.G!G!@(C Ei0N "E1G cE1//M E2@ #F  //A eA !A N A G@A "A  "$4/#4(4//.5`03'5// a0%1a0%1a0n0a0G1a0G1a0@1BEv@KH E7	E8	
#  y  EaSи``
{`p`apa!E80EB	d@	V`Q	``ECV` a'*'D	 *Eq nС	A`v[ODHIDA_UID
`|oEB^^03
4!_DISECx)_SRSEDh_CRS7Xa5r)$_+b!6r) 4 ;c17r)C EFM hA 8 r)IF U[(iQ(9 r)@k0jAr)$p{8kBr)73^>90[!a?892[F41F5
r 6
 <7 [#"GZD Eu[@K+F48v1(iW DO5 -G@FĞ	QkFB
,  FC D
LDE :_REG3吰0QMFC`pPFAO A_S3D
p 4p oFFRݠ({C100
 h砱4B W` A]%1cCC0_KP2
4D`
{	h`?{`h4D{i }@
4A$ q\._S{B_3ts._DOSq	9
` a|![^4bb ha[7 
PPpDCR^FF
 G1_ 7SShǃrR** %Y$
 
h 9E	8hfp
` {\/002r0'A
0y1`90D   Q   P  Chip~91@h{`@}`  @1w\=\/	3F3]7 bz8|8H[+A
i;C0A7hj	~ 8hijCqla.5p
4hR96s 5 4p
6p9793s 1z F)C
^/x0kl3V+D 0A` Baנ{04aߤa`03[BϠ4	__GPE	
Q
Gb bGf f@y N10EN10FN11P<# 1 2

p`3145`
`6/cD(PDpipp1A
 a	isa`117[J  s@@ p!18F@419p # A!UB)CADEPr20Q 1&2@324P.25Q 6 j7s 8c912ABC UDEFPs30Q  132 U3A45R3373819 As B@f/3C3EF C1400
442 3 q4Vq46718349Q 
4B4 Q4E_INI U4F ԑqFK5151[  Iސ2 @@Y53:4	wh
@axa
db`t
@`TP
a
 @}a`*
y`о}`a@805] !azw`
d`xr`
  
@bau .a	6
	7s 8

9#
!jB 0qD
EB|15FA-60
Unknown 
NiMH 
LiIon N35P}P}>1
  a |,Qjq0E/1(`0EP59
a
aD0m13
721A<@g5A@`	9Qυ}ha{a
/58}Q956!
 
p^Qw!7!7Da161a	ՀNP AB"2q	QaBp
P?{`~`JI863
[)h`pA4`
csc
  dzir`a[)a_bsdb1/2*(P~ccC4	hg3
~m62g
oU65F/{`g#5 $6haCX N 23a7p;a7h - 12A w"Daxra
c 
dcbpbb,Etr	3C`a 3Da$(`a-:6g!$ IX68
I+Ep
  W 	i'p
q:/79"2Dc.Fc31 c6@05
{``	={2``EF@5C84  9H2ccdp eבeez
cpecpci7%4?ns 5qp
g5IBE`p
`D5D!k!25Cm-'AG@+yN)21Q-  
qu>
>6(P2pzo
 5Wap(%*!7(B+BCF`*seT(a9h)030	54Bata
!ec
b@zch!
 

6Eaa38
@ ra 9PQ pUaupaHf:baAh68
8>BB2;2CR=3c3r?44 [m
06BrAxч
HP   a3E
Sp
SIMPLOySMp
MOTOROLA a`w釁RC~6C
p
 
Ajr (_QC03':Q{BA^ B4u13b
4p
a4a2
bBaPQ05TZ6D! E['cTZ3_J
6pn
Jp na6Fo
PRfP01A 
 M1_2 N8Et1# 
B7@_1#9BnO1169_116

,
W{ (i2=80i$ŐS[Hɀ2E
73
N 7НuF775 760   q !A FBCADڑEB7F80Q 188384_
[  њ]81868ἷ888918f8Bא8C҆k891Ua 
A
!89YMQa8CҚa` 7CW`
D\>
 k8DpOpi8F90rA ẜ`cFbaEc3|gP81b pa0A83c19P ya
 d
b
 bdpdS c
_ c
Нc
D90B`918Cp`kaʕa
v2C albab`bo
vbybv 7B17Fp`E?7E9q !81#y!AdDzj
a2088D=2#'Avqb_b	aq ސbbQ93VP
8C689`604
766" 86"0
q5
{{C0@a`{  ia` `!Ehp!
W`!K_96	C)haIF0$b cU0CacbcA@'K97 p^^`)8cIX99LE
!+A

G?y 19C A	D/ P99pqdCA[A;9EF_C  _DDN
COM1!9FA06
30U"    8y `NS  A0?_STA +
`1
5
 ,+_DIS h03Dd39
F_SRS Vh
 1A17cA1re)r9F@
_C
wE

` c

 n$LA[fA?2   
@3
_ON_a4_OFFPR0}A2[Lg{A3CeM6C
_G 0" *
W~S)![ 5 2K,
@>A4 &@|A58^,o/ApqA161AX
zI A * 0
 	 A9
r
;`/!)4R!9"s"5x""u"49#2cV[QAm$i$!P%`$ $A[C:`AB0=0ACp`  0=CD
;."@r-2AajB>AmAшAEuGH
1 Gxx&xx"q)x)xxJ Ko r^r_ _u\,QQAEQP@n%QQ40E
5Q1QN?3?303<RQV3rRnKEGm3 *o3dSb pAF044pB04?V4V55 X5uvxp
p] B0"0pr088!]B1=]7j5]0]&2]q40qqX:B1)%B2 p3\/0sau02 0723w(`O{fx  !r@z[O0dd$QBP` P!B6  BBv
G``G'pp 2+2{CB7
q 8`2eBB5B5B9[%0%A#~ ^"/  y sB؀w@ @ "m-[P2A5
 
 tPz
    _ *"-Ctba aW !-/D5
0 p Gr rf " ` `0Gd ud"l[IBF
" t0C[0 ")UC0aҘ  C0C1&O.    } [+r3@
   
נ 
@DD_C06CC0ADR   !C4
D
[)C45 БINI	5[C6u7ADC071[@Q8-<a {338a =r:}d%8B
=pPRW
	
/[N0#|!C>\/6C0CF["

 C3C09_B`{`]BFGPE $AJ}0F8 p[c_L1A`D
C0DP-7
P0PP1
@q0@C7?	_RMV P*_EJD @B.!MP C5Q 1  1CCQ D< C( p/D+ 1 *qX'
43
C0:t]
7S3Dr 4p RCtOiCPDN


#H (A_DDB31d"	1$
					h			G0)A91D 70-ЫD9"OAe#B*N_GTM p
8 `Ɋ@ C DD$ E!"F mE0p 4>AE0{A 3$D
D~0DD7%u10D
 
qP1
P
p
xpDF}E0F@DEdqF7DF{C`[MhT
UhT
hT
hT
hS
Fi  `p
w  a:` PA` bwb
bw`
cib ac f rbP rc u`5ab92cE2bca:63\} !{ <f3I 3bL-A##?M
joo
mjfjockoaBaPE$F  ,F DARBEt3|Q
_PS0B 3 O2	KBX99a	
#  A:AODBODCOEFOF0OF1Lpb\_PICжhB\/jD8M`T Me8E

0jTQ5   *1`+
C#E PH 


 HGCg

 
	
Qa 
		Q F0L!	A	
a	!}57# "cB%6(!!! Q3c !t!n!G !Aap]67@	F
!R  pd
d
Primary 
10  
LIon 
Hewlett-Packard EyTraveloka	6x@ 5-59ѩ64	^00 64h`/`p%
 

" 
 
]67hVaE7AA8An{10B!ax7"p 8haM`6hP7 ~
_UID sOA2
_BI^Q  ST  CL=\qb[G;6 `)4d rdA
|`&
ACPI]3	NgR/a005`K} 59 $&P07AeEa[&Q_PR0py186`ryE[:P
pLIDS0A0ߐQ"1
	/1?5?@SXr#{N2jB EC ED `ukwk`Ah`piaFa?C2 a{`
y gs }a竡ap`k
  {pap  E ޡD 4 1  %EF0v rv

@  `x `2W`pzhp}
yjp  '>qҘ1 h)h`Ѱ!	` ibйpbasabcpcau`a[LC1F0<F1 !  a a2J/p3iF4  F5 6<pF7	3 P p
7`

 P  Pr
O` a8 9PF7eqe[0wre
 
AqA:30p_FAILp_pMF4SECUpPzAAeA5ѐA56Б^ BbJwUrC}DURE]F-3P
cpC200cϡp
 V`B
#A36
{  QF1t
-A	12Z02P\R2 d"205	64nB  u%a%SIMWa6207&Ob;2JT7˒A1p0p `|PASSA'Q'2$aO	A```P51ap{	 aC53> ES?;FP2CC+a`şbbaB b ubeN 8C5e;01h<piKA#MBMCЦv_ Swp~q  0Q_WDG?
<4_c,E=DAAyB{M4C~ !f )ABpzWMAArF3ij3=8tep{ByBP\xI2{h
`}7049
/$` }A@q0p5s%,*!t04D\K	
  jCFC T 3 AA;0s#
3 s9B1 !#Q720ZD2A2CBEm;{~B{A  @K:	5	K6aG0?!haO^"Ah	" M_WEDs@/- x)QSB0-/T.r C9sAWQABNFOMp(  @A:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=h4/~:zH8P̴9ˡc@1b90Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
P#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[D J 03[1Dl[#\_GL_yh0050pipjRk2ޡ054\@3hq4@l['['`[E

[uE1F@10W11 r 211@D11ph11m2010P21`aFOp{zh 123h7	Fv 22 1E -62i	ԁ
	27213	P[Ež22A2B C DE F0q30 np 1 r2E0Q3231
[ 3@(!23425o h
35A6 70 `~036UyA
	`rh``v!F3833cаdp
aJac
@`rd
  b}y   baya
[aaceraye
	 evepeCc ucd_cM
`9r8cpc  bpbgC	bdp apbe)ec@e ffg
fape`pfafgvdueA`bC`# gT`	x$b pg~14agg7{agdM@A,05F , p0`c+`bQD E` u`py6 C061@ 0  "h Ch H
bhoc `r 2c`ada
e,2F-adft`f	ru'adSuc2ftd gr:`4blA 7,B F30F-E%93A`2FaqD30a
_INI-BB5pibhb 1Cp~0<3Crb
DUD
j0DE"EE"bF5F w6
arC01Eabpb.0+bϢab`babuaaP `bua 3/_CRS`40Q1E`fv2-F`T`_STA t
`}``6 9XD!

	 A    y p34 $@=[Kw\/241mHH
Y42F
RGпGP   }@    s3	0	  1	42[Cw\/244}Q [198F
rG G$ $ GN N 
P P Gc c Gwe e g gwt t    3P A-\/[	B3na


W;8p
`q ^^.C1727\_S0_S
 !  3   J 4  5   M\_PTSph%_3CHh
 Lh
}	004C161r`Zb1E3 7A$\_WAcK } 4714AP%1y# 	0EQD98@6@ppTZu46 TZ/1_
 2 :נA1A
a9
p4@35bQ2

O3acbcc:c6F
1:PR1:0p:1 
 ۠abw59j5A9C1D93
 `?0B +C4.5N6n7
 ,D\!C7G,
6

0Qnh

ob m[
pzqL849
QMA0EFB
1NC3
N4E0Y65051:P=2 32W 16DpT16E
5 5
1({!h Ϡ! ;52iiGi56
зp
'3נ$R``Epi_Rdp	D
7
hi54p
`pi``
p
r#ip`OBBp58@`phahAw53ihr@
!! # 9i ` a 6{fG3
M i`N1`9p7K|H?QpR
   qqh0A3
0
	
 t!&
ax_a

`b0
Bbt*?.oPR
 $Rg
a!
.!H  6A	B
[Cka T1
14/of[p{V48`p9{b
 bbwb

araMpLkal0l1p_x4B q )a21h 132@b4 ޖ/y
hFI	{Hb 0pu6h@ aw`%  G 50<3`s<qC4F4p !ASB`hx3_
b !Q7K
@9h `t`03`x`fA@fI{Stff 1tq7cbb7b&8baFb~bD
iP

ep
d!@V%;EDd*Esef$G#i03t
`a|׌AT	R04EarVa[kM mC@@i
$_ON_U%0R[2ra6R_OFUFb7p7D'
AQ
	E	
	@qQ	
F
PvQ
[60g `02C[Q"PDHDCQ2φE3}F[Ho_AL60 91 @AL2AL3C3_GAC0 "1&D B2Fb3f\ЕPSVCSLƔG64qzE4
FSx(,E0ԡ|@0E4Ap
{p
,4C$ZQ QQB_TSP
dp Ctcq 2CRTP^0TMP5)ް[Gb 5ځ66

f,"*30/$ F\_GPEJG_L0roE19 `BqD{{` {b  {`
a" 1 aps @sBca ` a BzOE1 C	{

6CpE   C6GC0Db}AD0+c
?@ [" Н0ѠIO	C	2B	I0(DDO	e|O	0["
dܭD  34I9 HOH.O2*_2o
5 S/o3-B6CCSDEM?
_L17 & 987?`u}8@7ۣp-078C1E45F9p:U{v9
@s1F0C2[08
86BE9b67_68 1
dAp`E8 ^G0A`PF0[67>dc@]uqMCN? O87;%AD8@81oA%D_
k87S4!&y4oa/a}Z?91  `AAPK!F p>E`G
$.`!!	`
S`
`LJ"`9aK,K	Qx90CУo31/9BLS1
I
Q/(09_0909aa`v 	bpFc}.l 'u4`@50{a02~ccM[ЦB ,
[ Cp
a)?5
7Coo3P23N
a"89hdBp,A]uCFjȀ6C``	~	ApآHc
5Q #
			gvcv}bAC,LV/A'	[D[1ho>6SSDTqHP  HPQPpc  MSFT L4x0D@	1       #__T	_w 
_	OEwj
ara
wa39a`ӵFP\70Q!Ff ij!70  AhfK33dL34 271_272A1 71d J53-6yj
7 z80YjK73
2`t Ta~@bb`h6Da bub 6C21sD212h 3E26Fq21y7 74,
b+1 y= U  V!5'*[A PDC{hđ76PCT Z76p75q 4	_PPC @SA777Y7NLP77_EJ0CG9PנӀrAa Pԁ _      	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n     ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ       	 ATIF_BM  vp (  0  n #.C % O O  !   n r	`v      = @/ `)`   ܀   
 ( 
@
`oo@)g`	&	Ϡ!
ϞA#ecA OOOi/
gh)Oc&Poof b%a& Dʠ7@3O,p:(/#..,/%4OI0`@7=a8">~i?2C
 `*C DjAj3OO OOOOOOOOOOOOO(&
' @ Jc  Ga^`[ `\A! )``OL!YybY)A+#:P @\΂ Qa.OK ,A_ &BZO
NA
bdT  (j`
gB
@Q`u#l!_!rooG soo ?\oo
Ayoof 
d/
o,Ho/ހi fb[ "bOW  }e d  @-a F k .5 @@O`@WP@@@AUASb`i"!hA iS"$CP è aV`akY$#a/k&$("Dtt`(y Ga  /OOOOO OOOOOOOOOOOj)~O L&AB2a"(!¡bAa ay@ Alay Cbw[
afv}B_`	DaBAza!1"eFbD & 
 `
? 1C ¤!
`@ bBḤ ""JC!a!bC)# FAA !MA ".H&a(+ -4`d03-'2b\2+9 ΀ԁ!Tr	@
p@-    0      VIDEU  AIBM 761295520C??$  2005/04/20 15:1b #S' @<D	C
Aspen M24P/M22P 32/64MB BR12677 225m/300e
 (C) 1988-p3, ATI Technologies Inc. BK-VER008.020M.030.012  ptASPN12.v611  P24 PCIEDGD1UN  OEM.001.049 l l K$]B   T1zX
`TVSɂ :+  7uA@( vA4R!}Q  MOBILITY RADEON X600     g     @ @ D  H@    !U	d!@ W/    W0u@#A@@
 `C&&L %<"0 &4(s0  p
@0 D ZHC`  -0  .@/ i d`
 OD  P  o P`X ["| 2"3=X&Ju 0!4@A= x| 6 E qE+ f`U_ !U  P &BC/	m۶ %""c=MT#[
u`!q!"2
O0L  'H0D퀑DTD//D"O)QSB B1	1(Z @9`+1)dM QJ0'``-
s-[ H.@QAD0& 1w M0:LL 0a q9VQq2q#
  5?q<  = T- RU
!,$@l%. 3 :N  `   P ӁP`   GLQ` `E
H < B <9D9Q  BBpmA -5?7p  ;uuR9_0 #  d o`a B   B rB 3  U TS %jA1k e%QPQm&_"nn  %=BTPE J5e	  a? Q??q@EA(H?pH?a*Xn0$p
3  w #4 (dt@225Q3x}73
  nPàPr`U.U 3mAag '0lt.Z)b+!Wxsg
QBhdh  tc Ą  bk f`.>: u>.:.<	  u  `1u .>.9P u.>.:fa.޿w4.>q u.w.&w.wмy.wf`f<1INIuIcW	.Y	?d7 ST[)$
 t.VW	 _^~FIRE GL T2:13	P
U@UU$5UaT+$XBplpT	.
fa4t.b4P mX ` * e f WP2X _W   @PXuC &GOfGGOOf& G OOR? ZRP@+ CCP2?FX 1FXfPSff-@ f
$ f$fPV:s^ntw"qfPff
p@"q'U q"fX zqX=Zu`Ō-V x4 
 6
K@$C PCX C_R ?ubr=22ft 0 t f}0auAfÍ?om $G  ,{@:^ u9^첺2ĸ tT3e 
| 1~ 6@J$@u  B@.^ȣ$$$VB <v  !  32Ĉ&! .@2ɨd^ß	ҁ NhV*81@Ld
F8
0
aW@P
 a8 ^
1[ Y>cE F
u6c .et(taw
w"tw#c2>S6N)N=d2P̳<o @gb }@ KbB   "t
u1#< $軴tu	P$<to tjf;Qs Ys
aF;$<t*<t0<
t'<t<t)<t<
@	t<t(<t<t (C>
up(k"R9 HF f;c [# ~ tF: FlfF62eF2vh wtÈn<uj`p$t }t  ^"N 39X8u P P$X"8t+N ;N"rҋNN"	F;t
~<uF1迃a 0s2~@tRSf_zNf1 `IǑIK&f݋Pr  sByQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ 
F X[ÊFf@F$FFt@F&F(P( tR.&%z:Z.0-[PR.^t2kM ZX`\ @ F7vu@z=J	;5vv `tU;5tEt:]r9Urmt5f3uif3ۋ^$f3fa  }C s
8sn~=}:n=a	Ð   1'( -   S?BDcOQ]OMɌOVУhOQNgORE0c	R 
l	jcgvWX ce
pVZa	߁cj| [i=s  cf	ЮU'  q|ô}% Lܥa	d2^ !ҟ6! # ן/  =Aҟ)1nҟ 81Ao*0*Aǟ
	
si	ӟW,b	
#
.
Oҧ2  A13E2oY]UM40a(+4ip !b6qٯ?J@)#2B84jU
u%2S.<t
 C[3Ы3Àu#ڋHQ   u u 2 U QqFe
 f`f ҋv ]jUbHS	C	8t	C$[. PRG\ouP tW@ @J,^P@  Xj  U    @x`SQRVWc`f<t< tpux.D.< uhXG$?
t\2Ҋiptʊ»-2..;w
( ( @..Tft& _^ZY[A&G@Pnu
b $@
@@qS^[НUu G<uTG<uGG%H
,Pt G2  AG%p	K`u/BJ k	 Ay@	G@[S \Xno.?6p
b} rlte u0Y2@ Uu.&Krn& i m
mYVQ."jY՛	 
 pfFm FmF`  .%$FDV .:A |~pom@蝡f`pcmFLFNF zF{4W  p_<>@SQfY_S[SWXP u2  )  @X_[(@vX{XmX[_BtF$F&P
u9C+$
"|lXsbXXX 赚C `+f3a  v K^ ml N    tW7}c 0V ) Gy PFRB^Z,a X6{D@C7 CBS$  {PVWGo
Ĳa ud
V"tQWD˙ЭMt@uN,߃u'"1VF  faa_  t>/S/P/BU[0QY$ Ā >
u2B[X.TaDTZD@! 5tpUt Ut U@暴0 t
 ڽtt-J
tSuU@zA %?P%@
Ā?
XÐ( 	 c-'(+  	 t|P c_O/PU
(P	@  ? 0	_@ T(   3A 	MRŃ](
c    
   bc O
2 B89:;<=>M?
 +
G _B$d "ozc/fk
2 I >2 
P  
> ]@( $	

 0P0 	  
   u    
 %( (,%*26', 49$,0	
!&.3+0$8=-2 $8
? (,(gc @$A ,!
( 0HH0(, 	H 8H
8 X > XAgX<	X0TDgT@	Tf(XHH8y88 ? 4<$
$ < @XA8@	d@Ap@ @ ?O.2.r!suP =Ou W&pp2P=: sX.卵$XqB%
&C&/^ŧP_ª*o$' CFcGeI$ G+6t&P$D$
N<~.;u*6|P8Dt	\S
OX:PM
X.체0&G	t PG	p?܍
u&.+X&c -eVX0`PW.E#Ή_Gw^udlu
޴k2`aX&I?UD0UD 3̓]U 
F CE?]Y[	
 FXNPv(XK  S[( vvuQ
u 脩uID]P[U XN- pѶVu^tH HU;]Q S[\S026'C[2S  &'B[  Ë#utt&FS 2&C@3rut	 F[!	7	 2
n Ȋ3S.8
[t `v {'7t ̓rPHXuSص߶S[P	$
[Êg% oŀt4$
@   t$Ê`$
}P X3<J1u P<~$<t <t<t@؁ð@  @HuPÁ@()3  @
@@ b !"# 3@tb
%o`ÑSI߀a)e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;u:puK>L tDI @.> ^ C3u&"0]<~]&g7[*0u3 3ߎ2PQֿ3f3f@  fYX2PR?4$@tZXP*VQ  R<  4Z 8 b3"ŷP m33s AQR赱$WjDrIDTOD fRȊYoZPRPN XE@ZX8t
tPZYXnuT  w 2u _-3߲
t	u$ a0t P']wX^0u0$0<0u  &o#6<uA	ut	
t0
߈~ )<u+V봀1u0*!*QS3u< "	,܀4u< uqp 
hh6u& <t	 00=뤜@SB"
: on`>%^N"	  Tg.P <Ȁ>cu>-@ 3ۊÜ$.B.Eq J@^X]`l+Ht8 JH  <8t<?t  .B 追  볠K%/+Q` K Ki Y@ 3Y |RQ
 lYf.-  b߹- *# ?(#  F 

 G@s 	 Gޝ~~|ֺ| |88| o8  l  <~<0npW ff 6xx~~~p`>>66f<ff<  >Wqf  f {; <f8llw8x~` 0pp0p$ff$18|||
<<a lllBll  l ~|0` 8l8vv P``0 @ 0`   qaa88 || x" f<| <l |ƀ @|  ~ C P
a0P 
 y ~
 ff|ff f< ll  b`|``k 
r < p  n`b% Ɓ|ְ|~Zl); l88#<  P
ΐ| %|b | -׾0Sx|~ I`   `̀ 6000q(v |8 x`flx1l2@ l ɡܢ-| p%| '| 06p'( *2
v 0d 61  8 v4plp;5[ |ƅ88
l8|'!f|ƃP/&&00 %:l~n ~ހ1-7  0
	'!r~`l`fl fEK>c8c>  >a<E4   ,+> >`gc1=  G0`2#`?#: 0|6> l<~61F  6ll6p` l  "# U# wH# ##d  6 aP P 5 `ROqPdJU1UQ2dt770?bK?0aa66R9b a	
Q R>   ~  f 9xeb]Pf```<p_d~̀Mi|?܀g8 .Sl8T(r(l`"8fj~C|q^ 8`T`/Paa! b~ Y f`[ ps xdaw<<pS2tflD8p&.mp0t| oQiqAQف၁|PQCmlEc%oFlpxpq5 aq3Ԇ3v3w҇ Qx>}6`vfqB~~`4{>~~>ՂR2$ PV3~ {p4`|| s4S
@<c UtE9_2`!@AH@iP!3pxF)bfwP0v	~mi D{1687 9
G-3 a5әAP p|@ѓ`;Ҝ2#a=Ғ~ BC ҥ R*ҤљނtPa7`p0iQ.f`d|d`A`
`ζL ӥ񦴝Rpb@q
 x
p S 		
qQ0F#a`( L%4bLZ  ~EQ࠵  4-B0a6P6rc l  a  	P $jǷb[6 qb 
P$=b X
cO5.  'Ma0
 ABоc 3A Ut"{ 8Y
0x"p	#	$@%#Qb  
#p
 
% 	"Ђ#Da6f?0P rʀ
$ 	%  		C	J@Cdw@`1|cc0c 5 	?!	8 ld>BPP<@ WWd!_ 3`p3 B< ;8>hdp` ~0]Zwl^l Q6>6n6 @s&t"#D+ f 5ڿ Z Ed
 
Z Ӥc g52cb 
d
d 5e<5ek 
c
 eqeeu %


 9Ը=3;1N Q1b0i2S$|ҏ05Yap``<Af	`q| Y a0^0 v 3 ј/AX`ixx x8#I?~ s6t?W2@ _7&&MSWI &FG_&E"&E#Wm_&]%&}&I2.2_
t@' k)p = ~=^~=~=~ &U*&$
$

cS0B$
Ļ	-	1FS2;t4&wt  pu`2xRԊ%@+F4_t=@ eR ݸ  t` t:t ?FP܋w !?u?q&ܒek ڊJ/R 2쇽  &GF %G @GÜQW+&Q&D&TAα !	ʑ  p&RW_j&&TAP
 XF2 CD9&Za
CD#`	 +
a@[@_Z_Y`GQWP$0-󤾄p   jr ts | :&?Q%a~ " G 	ĸ  2
WRW` aRFJuyCZt 2f 	2wPYs	QO&G<{YO 74 7@Y t' EPJJ  B2BBXJwA!U{,?VBBq#6)^!]P9  (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

			   

m
   r 
*   S**Q p   ?  ??Q r  ~~   $$$(((---222888? ?? ?/  /? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h@   1   ҙh1 h1 P,h   1   h
1 
h
1 
hP$
ĲXð\N WQN^  t o>I~&G3u 	u&IúbtԀ`cNpb  P3&2J&Gq  GLq ģ`À0c B2[a a;jb{mphrmÐ
  !"#$@ABCDrstuvk(
K [!{ ;Al(L} \!ߕ|<An2N ^!~>Am@M ]}!}߶=A`P@ P!p0A aP߃A Q!q}1AbPB R!r!/Acj)dC S!s"?AdU/D T!t#4Af?F} V!v$6A@h@AH BX!CxD8ArgJsG tW}!uwv7AeVESA   0  PmR  @  ATI Technologies Inc. P24  01.00  @ @   W   sVBE/FP t:.6rp p<r2.]WVSQR  f&=2u " WA_WȎ؋ʾRp" uz &u&E_UWPPPUwU Ubp M_ǃ"``݋ƐuZY[^_O ËRQSVWU?WQ30
Y_u5WV6R2^_@

.]EE
tE M]2B].l.DEEӀ~ZӰEE!@ #  
E" $ ~7pq~$@@@@ #  P"%~@ EeUeBS3ۋ3[@N
tȈE}~=
 P1E*؋EME,].

-+/E0pX1 
 f3O]_^[YZp0#RQUSˊ$ w
 V< @t| dQLPY
 b 
NŀuZdĠT2ʋD<u<t<u<uAA2PQ03 X23` ƻ
`	$XPf{C@oDI0o[D0o2 2pDo6tu[.- ̈́2O[]YZ)ø mVP$6|Pش~!t8\t,	2^ƀ t &Ӓ @^wO-  	9s3"0WV>¶F^&Vf=>^_ÊFG< uûZ.^._>W : 
._@StwCCPS(.$] #y[XSL/[ vt{t
uPSR Z[X8
t
<RBB@Z2ÀuI tp<wjut`2.]0ap!`O2
̋AaPXq(
u uW3&/_uADOD<ΰSuLA.6IS [';vȁ~PAJS,f[Dt@S&[%@عSQ.2f<ff3f` Y[f;Ës @Mxryf}@Ч
2uGf`PoRPfZf
ff3-fX<uʼS$f[fa==f "$[f%fP@@ذ
XZ}RJZfX"[
uQR~pZY!]"uRY)Zt۷^3"t	$B wl wfߋ= ]QRW&9f&f$4 }fgq_	uZ$& n  T8<\ VRf 3tZ^fO_f33sfffPfVX} V@cPQRfRfQY  $  ZSYX!
9PfBfkfv7Wf<0Bϴ&qfIu" =B&$@[A\`tW!_f.  ~;t u2X#%5$$ ,3>QSu:3ɆtA
 [YQ
⿰$YqD?SQVWP# S &IWs  R^Y[l7QRVW聿{	_^ZY^ڋ_  $[ SPRa3MR+ Zt $$!
  t7SR #uZDQSСyP&= PH`UYS$TUVWVlXFYYZZ]% ,\\ PÐPMID5$^  ׸ k$$$l]XR ZR
 q  ZÜW2 _Ü"oQ K.:3 f.;uw u h 
	rrs_2[fX)D%)7 $?4
 &`ffQQ2
QQQR@WP& 0JfXR2Z[ff_fXZ - 見R]fqf_
V
4
ۊX

HY
틩RpfZf}`f_ZvfPRl g +1KK;rZ  S 
S  S@ [hSSSR	QpQ? @DQYÜ2C @`)@h} #    ` #  d # B f 03.Dfa.T
.d"[   U$!'!]Z/RHr& -Y&
y"
	.Dt fX_Z
+

<t%+%
D Ԡ0F`
DGQ e8t#su*cr Y$QP0ΫXr	8u
@Pu5,XP	r%0єrtr@jrXQfuQ2 PvqtQrSP?u$XPQrKru
 uKuXuW_` _  QS 

O ztGrNpr0t;Vt3r,Gt$ޠr_r1PBNKu`~ u! rdr
psr1	Y`ϲ#isRP*s2Z W _YQWs`¿Gr	zKuq_P Q Ys% _ $  m虠dOO<SurjQ[rbfa uٷIrE8w8rUIP2XPr+;rr6"~0)r @a,X u3ÀKu3S QPXY [<t<Ⱐ[<u < p3苤PQWGGN衤p!_YvXuku_WPD@_O
t  ꜑
AÀita:u-a0Y	V u	@		u`|ðpPXOq a <Zr,ZP2P [S]pg6_;w2XXXYf`	 e|		ut6P%2X0 y  t P DgxDX ut!P% Xt_ueP{ dX P)P%t:u@PXt0PK  #u#P P. 軠 " ~ 5~ rPufaPt t
`	t߀trѧ
u+g1htuQBQ]RL @ @

0Xu
 	c诀p   b Ю@r5sst ugfffPPQ&NPPQRԮt8
t^Q
i&!i.? t.;u.;Wt3@^-'(+ ]c@7h?^_OPU 7 oo XGwW 67O  	@BsTv2ed. 
90  *+P;
2/S_Q
t/+u'3At		ttuC۰]4U $g i ]a!S3  [y/B$J .gp s  J$
2	{䟰@
e^`	P 	!
U 
̀			
T	 1P.
$@
JP@=^v	@=v$?
úZ[@5Sb1/իIJS nQ$`$@fP,8 T 0  PsfXAk @c*S3;s.:GuP4u.{R&$ SffȻf
   ff N[VWQPS= Nuw`r@Ўؑ3f<8ATIuI 4ك4 t4D8u*D.`
D.bp .7.8.>~5 [XY_^`PVm<u2@a8uĊ^Xû..~.?t` up.G8J ZYWVQm0omY^_? 82   F=P1t=T1t=`Tt=dTt* <w 
 <wf.
! p ?SU^]692ireb. t[RuAk>_o"q X l'0uPaaw!_``&akd
L$ ЬBh6][3۩ 0   PN  Xu22@t $C s} t:тqTWO@pPF $ A7Bܸu )$<t_2
#r
p
w2\$ 8=R 
a<|10tw$=!.$ #$y n?#=_ puPv ̀$
'$w
,R
$[.~
R?|>E`߅ 2HR?U  YIS$J軇'1$! `m@  RS%pE'E"2[0$% G`u Qz#d USD PQXЊ R tpijmuj%l^ ]X]"^^EFqGHIF,F"F`R/<`{yakpij5kwQw3 P]ސ]p^w]
G@HGf
A``kd e %@f !R!Rq7?@S A  "
 2ɲ <Ē  /  `Ѐ@ $R@$0$
;'$ݯ $1=Rt@g h#W$}V"q#K$jR@$y!'pO$ Az P'ý3xQW2dF209 MЭ<  
mtQ`
BPvP..
tP XRN'FEE1#igf}i菲h @`	Xu	>A6{[#%Tp3\'[@겻(yC·
ѡ 0Hq 22Өu~:fWg7`3g.E#030-*'hhaAuDA 4B@7DοDEUu"cZYZj[$"ÓRW$I<#t=<2t9<3t5	 B$	e,S_[~_f PfXٱ !0ѝ
$<<t#<t< {<  < <
  <k"F* y&E3usuu	fF4Q 8т_._f.EfPF .GF4XH~ u lF6XHheuHff%  f_F8fXf;@qPf	F8jd2..>tڋF߉F4 fmZ(oP0[}
CSYC[  Lu	 QLtR3ZF Y.HF
GFF
GP0FG$`@F	ۈFG0
G.M	̀

`3T
ňFF	`
G	F	P
FGF	GFG
F3F'F2F?@FB <!a?QRߊF;#t_7<t3/##
<t<tFl2NAVB{BF X!                                7 S (40f
   {fX[Q<R>] ĀuB u*@fEGtff.#Gf.Gf뺊жubuS0I[`.O.t	q tIt迡ٻPIt$<Ȳ2YWq?DP _@ n Ps d r     	 p   RR   p 	   P G p 0  P  p  P^p ^ ^PO^p  P "$p  P	 @KZPb 0fPWQ2ɋYSQ2Y[SQt93.OɃ.;vcib1 ZS1Y[VSw|f
S St/X~ QSfX PQ3@G YX fSfP f%f[ދõwlf[j 
 ff
^_fX2QV2{.^`Su= v8ǰB} YRfPP%fXfX`fP:m&
pfXyr'! ^Q
3sy}Q2P$?XVk"b.fQfR譑	O$BP;%P~1$i%0[PXR;3Qf
pYp<fPufPV!.^2 >fX|fZfY߰&Au߰@:5f$PJqfbYf
(<t=AOMPWVRQ+Ë&G
ߠ36 2a!$@fX&2&{YZ" QR
FFB7 P$Γf@ZY&0 b"SQR޹.
 I ÀtntQ  tt" PPPQ]@`tRp  Q`2Y|@t.Q
yYf.9VZYSQVN %0<`uY It	oY.XP d$o
 Yյ^ R ef f.;Tvq vcp  0f@ wjvef+бRvMv? v2 v%v u	r,w-qZY W1̋E._U UNfVf^ސsf㠵f.fff;rf@frx`f N^f;rLfPÏ.Qf;wff?+f'!@sv
AC
X.L
	؋N]f
tt= r = rA.DP.wÃҠY[0H!r +!À ʧta׻$nPV@s۲V$߲T$a P WӕW S$WtZXypsq5P%&O@t@ $&W7u t@B @`0ڐmHZX0	ZX RWڿ̓tϴܲ _a @`0Sf4[ø \Dw37H 				  u  0  
+烊23ڲ[Y."D
$.
tcs] pC@ K2o`;?/`UpvP 
 ]ٲ[&Eq P0x0]OX0腰&D;VB 
 &^1G!ZS$o^ Ftf
^~f؀Nnp;w@( uڨ[Xu;@f?P ?   FF Ƞ 	rpFD
T轕&F |Fql_	FȊĿ471n0%
8>
F%Z}Q0PFf=$a-,0)@f
 fZYfË؀~À߁u S׸
tQ~wfA>
ÿRGס͸ HZ3 [04^ , زq 
QRc3d 0YSR.\Z[   (d
$ͼ0tp  $$@!"
u{&45 *0; u.>tӲ.::f3Ý W߃ G7[ WQRVSp2ֲ+$Х 2@ WfuUdqXfղ|P@E=  t	@2|X ʒ ϳsjor[w= 
RI_[^ZY_B?t:b0WwoQ2ftu%? t`K.!   &ֱ   ul0
 0
0
 Vf^fPB 
`PۺՑ`ËaRf;ufY$g/_p`rƐ9ËËߎ<пqâ qzCBr iV0w Ծn u~ ZX^.t]WpzӿID_BpDap?VS .;u[^|ӿ1A	lӾ } ^( 
 : 3KfBCC}胤}У   @  Q`wҲRX=Y}Ҳ1S@Өu[SGҲ,XA	&  Q; ߋ%Q|$Ջ@Y`("5Ղ73sѨ
 8֓3 Xh l   Bp   & @*@LN  QRSjѲUP@ڻ
P$ һd
 
{ 0 sҲXP%
XX XXUaC[`QP ?t@w tPﳊ	UoP@0=~ѱP׸0f	UBXЯfXZXx20	R_d  N s  .<IdJjy !  F "N饍HL.֋F2KyQ  f ^ M
uOϲ) $л 
蔛P8uKt  NVuN8Kt
7$

ů`k('t	{
޶ y魌ߧ鬌n@ZXt3q  鄌KLt܊2
Ϗ 
  {3@N5QP  twβ&$
N{2䁒J_ 1#̯p#!̯ @nr 
ËQ߄P@XY^8铋H	u%T$ȰU$ uӀ0ɑLpuЏ=>T _(u  U N_ B@0近I`&;'f3.O>f.O% $Ͳ$f3
tff%@ %f@,._O>uu r̡
e0 %]%U0V
D1
 貘pVu0&&)*
ͅ	<t(1
0
KKP%.C<t8tXp@'Xщ GxRc@p2!:t`0%$@ 1
cv$@*bwˑ$M褠ؐ 7˲"`AAp2ˀu$+rp?2_$pIuR!= Nt(5(8 " 2	爳%霈 c$O鋈7u=q
by	T+	L
؀
,QZX}( 0e0˻D -[X@
8ttɿuoSP <X[vaS	K u[S
t`@ 5J.BgQD @A [
qqMðS 3ɸ.:T .2G̸ mP @iʻxTUA$@ʡ$?4?+bʻ%PXX˰%ߵfQ
fYfPfQ
} Q Pp|p
  蹀QٰA[$mtqq ɻ ̤f%g #
Q%ɸ YKuȊ/  SP@@0
{%
f[ø V NM F縍8 2u * "- m縁A
JȽq\_ }@渔{c済渒 jfȸM渍u0
 p-Qwm o_ g渁_AqWA'$ø=߸  /
 r
'q(bǳ
{fQ 帕@   #帟 QpB\ ù?ItRZ8uR
ZCRBƲP 6 XZC@y,$f!UprL. gf.&# &ñ By䰅R23Ұ
Ϳ)u 
Z`..^ un> tgp b2P>bP22AQJ2=QRPP@q 32ZYYy2 XaZYYR*8}2.]Zà؋ m 2Ku2W {S
uSj[+с2Ê2+U**&R  āZHuB$ JB J.]r c 〃 ޡ  PQC3BBaaPQ YXaYeԨuX}N
+.J
u8~` ]$0<0t ^:Jt. ` S +*21+uX  up*tX⑰ p/. P"㨀t0׊4"
ވÊ$"ð( @ѝ = !$%D
m݁ ? +

,QVW++    e_^"YԊǊ竊_ S8v2QY2P >It(P
_RS"82 PL[[ZRРJ2Z.q q 03<?& t
uV E,ņ!&J aZ	뺀-[a2RqZ1L0 }
+ȴ@A
t
2&LP    >&}S`YظU`J<t
A<Ut2[ð
 6% B B2+Q+++YZ0"ƯȰ+Ջ+Nuÿ`$` t  Qݍ"t|kÑpq8~@td\8tX|0I~D* 
8t8`t2ſ
8~
 ~Ȁ}ݿRt*Ŵ
RQVW3ۋs P/2 1t@   _^Y@ ZC\WQRV`T3G  ZYxs& 	r Ǣ	 PO@  ff̊f / baS[F_@fWfVfRfPbPpfV +Ɗ2BAXZf^f_SRP1 `VfZ2f04[wu.N i wy} rhf&Iwp$MG|t;@9 _v[`-ovI%bR:ZK`R!eh߃ك@A3why
twFs
頃PdP+>PEbFߋ+Zhk
ta3R
#
+ 9rnAU~6|m &F +Xu &F E&   P ߀Qa+>2u	&}uƀtGVW_^t!#ut
>|  21
da|u\wVtPAs drqF`u
oQ
С
6JX 2B$]XXc@]SO4 2
FfKu[3,~!#|A鬟ompeBuEG>PF eXЅ$6| 62 'tmU؊Pu)#ëp &N>Xz ƀ!1{   PO 雀Àt!&0@ b?`$ p&PO Q8r2в2,Ћr!=1HJN@PRXWQP͵sêuXY_bQ(IY+qGtrG _vqGov
  _u　PUP[,@.X`)V`4|4F umXPRJWQQW@3_G8v
 VQGY_Pİ@[KZ&%_G+BO;v
ZPݠ θ!&/2R_Ҷie0XRWQRQWP8tXP75$FX_YFZ Y_Z̰ Ï										ɲ		>ctqP}}>
u&fP 3 f \f$߀t  
@L}F}SP
3 t&   &]X@9	UĴjP qG@ĀG`ey
L'|CkP|A]+A%  %%&z|&Ē*(DrX&G|t
Un'	-|̢-2"ٰ[}~3{yr{>b2PI<
vLw5`GrA8OsZ{at u2<
u:6u J{<u@{<u
t22+at++&eP>Ҫpeyzpб{zz.u~&2p
O37ʰ'ﲿuF tzjzcR`R8buaOTz~1T`NV8zb$O
Ip(!Q̊.ªt.;t$.
DY^Dy#+3*2d!d"<PR3=ZXt
~A>t
y>u<s .-Od}! ֫ #ܪ+` l |߬ԬtÆƣ =@&Hy
}+>&}s! 32 =밀w0$&e߀ te ò 3NsߋQ2ĜB0:JG `;/^ xQ&5&m&M CYlx
u~	$aP0轢cu4+x0P !v &5&MwN  w}4 ~ P^a ,AWT wtX9 @Y.ڰP;PY0 d2|XR~ ZSںYB讀 [Z SBB  s Ȋ`PSfQf  t^$t"$2t t=fIuvt%utfY[X$ .(Ȯ*<t
4zvaaov<wPSPRRRп@n@	e@}P=s=s=|s^=Js ZXj[X <t<tˊ~ S&[u t@ > B Fu.| ~ uȎ2..u 
*9 -Ƚ60:
u00w5wpP&p u͎..F.QFF u6-1566Sp$[x&G&g3t!<}
<}0
ô <t
<̀
&Gpu߆2@ ֋P$`"3ҹ <u{Ȱ P' X̀
PuÀu
&~a@S[t (22QPF t  +YsuчPW>&}t0&<t$8tG Ȣ&E+ _X`3t_tuG8Pmu&2}. aѬtV$
J	 Ǌȋ@/utHవa& L26t
5`t<t F0J>=&]&M&U&E
ȝPp>X}21PSQR.^t	00߷ZH<|!rSH!5[VQS&F E<
"@<
t2Bdpp\p' t&^ E	cqras -Pһ =q	t2䆠SU@,][ X[YZ u:Хujq`Ip~Am^F>q<u	Cn.qG.:r2.] IÆà$0<0tu` tq
2.;tq `i8~û{ 3n tPmU#)Vqpt# ? P 2  ~     ?     :@  R轩*$Z.$SQkSQuzY[f.
uY0tXu	f.>k Ef0(`f.(ŀt
uPa*Rv j
PRt|Zpr .@i(-2.OA.WB-tW+A_t;rÀtR p D
uɨB.&Ɇċȸ 3  u},A	t0't𼀭 ]莲
PGktu?M2@|
uJJ Ѐ@1

@? 衩Pө@[ZPQVWS.>Nt .TTux.ݻ	@NP Ў3f<8ATIu? 7;2QRS$<uP`F|<2[ZYY.ɰ.@L[_^Y@Hvƴ 
XÜf`PSZYsstytrS !f-c[PtF!fsq2~1ԧ[
	+Gy	f  ޲r  fa-fP22ɻ| 螨fPfꧻ٧߻|"ȧk|0 f h@BWШը?踨赨貾ħ2ɐ $
ȁXp 3! `	fX7S.= t.;u.;]t3Х5W4uRЩhW.eD <t<<t8<t4<t0<t< u0P`S4=@uuX5
X
=u
L_:@E=@ Xx ^W}     Ѐ  @jPmm @{wj X--    
V 

u`豿P=ua	dFX$謥ۤ?|$!Ho<$+`n謤  ;$u p _Dp $ 0=DWDW PW .? t.9u.9Wu.G2tpU22T_Sb.Ɋ
܀gqi:p[;D;;û q#Wt\3PR迣$ZpR% FfGb  ff0fR t3t+t#@t.tpt>t-%ffȐ%flaf$<t$f- < tf+ f
 0f2) ffffZfYf[Vp>߰2fȴ2f3.Df3ɋ% fwfp.	 L  
P!Offpf  !Xff;t9`hfX!"X苤" 
Lmjy#:@p1b ?( m

Q^'C㵕 `^(@qDEFG.F*.~/ @_䊿ط tttt	tr`[V@%Q~H?Cs6 -$ 0oNAfX^    q  + pE { C @C~aRlu0u	 .F3H莠 _ H@"  wufXf	 }Y^J.~0ǃ

p0q  	?p)tfP04 0 }  8!mfﰿpfPRQQkuPş߸3?跐Hp{XP  0VC︯ 	$x,jL]1	` TN"
p X>
\/ ` #f/ku _u8 itqkt= }0 (p ppC
uu
~nXTntY]IUDpEPqM<~	<%  Ytr j YZRSfPWy1qEB.E_fX[Z,4)F
@ g<0 _F;  (;; >p/HN 40  })%88 A~	I? CJfPVQz<t%<t0WG\
 $W<9B"EA!H* A"`-YN
 Zf
  9F-fP 8Ơ1p ` f.2t3/ 4@}ff
@ S xf% 1MtANN   [:_t:_ZY`^BRVW,Vh ^3ҿPg.;s& j?>.\e?ËQ O^~ [L.L.2
0G_^UC@SD0[û@ J(A I֑Ӝ0u薵3HS#R
 ~Q t5@
0uzXHT.PPS2o Q
RPJXG bfW+&G轚 ffH}tf.#fPQ3۹!fCX=f" 	WfVwQfH.
fr5wzКX՚f^p$[H  $,48<DLPTX\`dhlptx|  ;@>Q  _`//  ? c$
k*6
mc8*1 C D
  
 ! !- @^#
l"  = @ rI  
I @ .&y$l`,>$!EAs/BJ @  -vK I'm$ j8!]ha	̈́&@4R ӿc۶(, - Y- =!ߝP0\ y5%#~ H+.C|[H8C O\ @d"#CF( N% ؏'	.# woE9 Ƣ( [GqF+  /#~!-+vk+ [P z ABmrc	o	b	y`	 g~ B+ 1@ : IR# (O6 i  nb8(+ h"6 -(, PTA PT PaPUa! A?-'A{.P]hq1,.a5c
5^O1] a`0U  1&ccA$hG!_	6eaWګPp4V1߾0  $TV0N  @PW?Vt  SK[^
@2؎Z@< u+~=@PVf ^y[a   : ;?f=0%?f=0 #?؃  ?=	wIu'= Nvu D@SC0ы+[<wqȎ؋t@@봨q(Ā:@L0^뎨1pt{2qw?_fY w  _@HD @x@ PSR諒 $P@Ț
XtuZRP$z"
Xn̓$" $Ɠ1pEҊP6'  /ra: 
tRPrQ
~0t X	 pXZЈWPX2 t3ɿ;t@t_P33 t=@$@Њ$0Ћʿ$ P$2Ƞ$g=wu$	$>  K= = =  #蕠wv<}h` Z@PfW=r Pp1PQ
<<$
ăQ<<Xü4 Q *@3d @A &06SL 0+  A  0`e  1X ( 0XB 8xVVA P	 -`N ((' @$
>QW](_YuEa-:蚠t腐 `1/T$ÀB躑0$Q]t$JP=@r	1Td
艐$.tp؏QSqǏ5fm5GАQ!>aCa׎n$)0:Y
o* u<$WL`$/o蕟ȏYPA
$
@6m@P?R#p  ΁D$@3%  t
tQKݏmL`aTtF2;rWF`FV_x Kٵ` Z bðn9 =g9ð^WwGq@96q7q0] 	p?

9b8p8
K 1 /|p+?$\0 MWx  !ZP讍hT襍o /蕍Xsc\yHHxp融$򌻐 _[UQmF;s IP8 V RFNP'uڃ?^
[F 7[2FF
V|FًϤ"~?P7XӀ
QYINpY ^HF7FVЉVW1^5=3]VG7@dF F^9F$v FfH~贿F f8f6j2Fp4n16:F	Fz 0
6AF q
FPQR$M 
Ⱥ$?
oZYA5fS@5VV оEUm '1A+EEfP'GЀfX
@TU`c+ E*ߊ	`#
4`#8蹊' / 9 ?f>ĜcB$J&e 
_
BA
  0f	QS ãIM 8%= vޠЧ$Bާ, 7@\'${q7O% n 8a4MVs @@f3 P3ҹ ȋIXA;rw$	YugX;v;tAKMXPQ ,@

L8YX  tPf^C1jIXAfQffffYf 	&\`   fBpG͈[f^O[;rN=[P #J O,qH$t. b.>.
px lv
d3.ñ .<  .3f<8ATIu 2؃? u2
 PVD׬P	8uĊ^!g@N6.ۗM؋7tJ󤻂.& t._&@.?tǐ?w.E8t ECCйVWfS _pP0胨W.}&.E_.]1.M0:PXf[_^`f09
-0
̻n$
.E6fp$
T$@O?$.es03蜆W =p	_U.]9t"=f"	=%f	}&f1	&3SG ֆ<fXr
pff[fYpe$` 8 胇  0= %
Ĳ0=2..ta%lu

ó~' 
Ȅ) *u){++i#@kP.f 4fȸxi3(ZYf[
 .  0u  t 
۪ @}Ӳ |P҄Ỽ
訅% 
  M裄7!< R΃ZxB%a蠗駃ځS1k4% R{$ZW 3.E#_ @_VmQlW ˕pe 谄$f}ؐ%;E.uDfÿf%   -.:E0u12   1u"ߡf;ût
 ŀ~ _gΊY^P	E= t= _a6f=  _Y RW1oW
n P;-$p6 }Vb[c_G!ͩcQϔmP9RQRR$ $п4
Б4q~
łZQA?Yu 0"߯BA$q6z2K}2'ԂqWF
t.m  1GQm@0M,t׃W_41>ׂ_$-ă#Z|ƚBSّ#}o4 t?!A 0Y0ЁBtʁC'taD\$ہ_T-H㞁08׎2*"1xLu\+	@@Ivp+R͋F"AF ѿ1rF-c+F&2$r[$
uo`1e/!]Wv9u PF) `u$
F)ȀTׁP0fF4 Ġ 8̳P~pF7t03  F; qX譀FB#@0π0xF'͊F(F2fc3  ^0)2֜Y[9u迤VtgE3ۃ˦ `~0g f fb  J$
ffe`q
fﰯf
fJ$
f	f%
f̀ffACRQWUD 2F E]4uHuXu	fF4pF8~q_._GPƀ.Gp4]XH p6XHfP;uQ fF8fXf;Pf	  f2Pk.>tڋFF_Y30
ɡ""
WG.Et.;
u
.;Uu3ې7`6ptA  wIt`cS2蓽p5ې
@@Z_7.Ip
P P
F"F 2N(̀ N(>оFF'G'N'+$fF0 Qf`f1N})F 
F$``2.O$F&Fqpj+%
ffP`lF-Fa
.oN3P.G$ 
Xnpp
Fѡf	sf	cb2c``npt+ '/
$F1F N& n1f102,F,Bf.o.g` F`F P@RG	  $ 
F0` Fb!R B`Wf	`Kf  G02ndq"0

sn/
 2f/f_	 
 n !`N2AVB02۞`P F0p tZtU1CF:B64C_A@΁B2WATsD	F2_I@J6J2~2&D7DDaph a2 8 < C F H K L U Z d x     ( x100PySt$^豖 Ft -
F u	F=!(^~.Ff.fh xPz1︠~ Nn.5 f0
̢ pzPuo	J0{v {E_f^
~yVZ`lVFq}P	C
|6Ff`|&F6  2fѽy|9|5|y1yXf^ˊ߃fٸ4s^~/}8;虵^^~ePFPx=߸$h3`,[ `@p)t
o菟  'w"ӇaP0ؿD	DfD1 Ee]}gqt^TILDu'u?D*aw++؊}@@%?? Dd2C_EeCÉDE	b*DEe}HDL0+S2]Ë؃$ eĈD\\[ˊE
b	q|2?ȉL rqB1cD3D<v|$}<@ $PX;}Pw`d;DX;D!z#!Ë!ЋȉD)
'EPj2D(D*&vu @D+L-D D0D.E94S\1\/?ЉT2?03 ]`(Ht'@P D;XD5 ƀ@^@S @X ?^P P @ XP ~  !x@ې    Samsung LTN150P1-L02  1  
 A  H } ? !bRl L  "0Tn0F?"d`  @U Vf3ɹ ҋS{^
uyЎ؎f<udf|p uZft# =	wIu 3Ct{ (֨ ~^2QĀ ]a`UG1	HH	 I2Hq*)PeE;$up E;X e9=? uPWAA_= vU9pN3Ƀ= t$9w 9EwAE b ׿A@@} uQ7@UEDEDSQWV^_Y[| u ? =@.|& t.|&Ǉ ZVYDNDMm xMm 2b]a$@VWQVS 2 Ў3 8ATIt[ ؋7[tFA5	
&G^±
p ±  廙."$ u;= uDu
{
$ %ڹ  _^VQfSp	
Pff;u.QPn=Y^4_t*`vq$pq%qQ3  0Ysԃ}4 _tbqGqp!Aq$3ۊS 0r0؎r3
ǎDq
9q
[ÁpcoE3_f_#Ȼ`p@ZpPEPp`%n:b4ap#'fPVWSu@$0迍֍?*ϲP,0A*D0!.D1
.}4u'+`  Ԓ
? 2h$._A1T6  ݰs 訍B}&3E.e0@3@[_^Spl [À
tR>p  M24X OEM INFO!W                                                                                                        x 2   1COD@ P h$/h߻ "hS@.9h[.AAgg~$ih$g! hfDP1INI??SQP2.N= NXu2˃	w,.'
t o#g  u.&P @                                                                                                                                    - 8"-             1600x1200  @  
 B ہ}P !N! _]W}_  _\!
E  W0u A    CLm <0 A}40   p
@0 D HC` 0 Y @! i d OD  P   P`la0X 
|1 X&J@ 0@A4= x@ Ϳ  qE+ f`e !UU  W &B/	m۶ %"""M[
uY`
$@ "2
O  w'H%A&T&//D)ӈQSB B1	2Z @Hα3dM ۤ@`J
 HT@QAD0& p)w M06LL 0a $Q)VAq#
  5?:  = ?- @
!,$@l% 3P q2N  `   P P`   LQ` `A
H <G< 4DP4*Q  BBpmA -5?7p  ;uuR9_0 # $ oC NB  = B rB     URS %aBq e%GQ&_AAB  H%=B 3 Ue	  a?Q??q@EA(H?wH?a`6YYY YYYYYYYY YYYYYYY0
@YYYYYYYYPY YYYYY@`YYY2 2YYYYYYYYYY+YY Y.YYYYYYYYYYY2 =2U22Us2U2YYYYY eQYY!3Y3YYYYYYYY Y0YYYYYY YYYYYYYY YY/YYYYYU% YY1Y YCYYYdYYYY"Y/YYYYYYY//YYYYYYYYYYxYYY  d/ /%3 /Y YYcQ&YYYYYYYYYYYY/YY YYYYYYYY YYYYYYYY YYY,Y&  /YY/YY /YYYYYYY YYYYYY/YYYYYYYYYY,UBBUqX%YTBR YAYY/YYY  3Y3YY//YYY./YY YYYYYYYY YYYYYYYY YYY/Y//Y Y//Y/YYY YYYYYYYY YYY/YYY/ YYYYY////]1TYY Y/YY/YY/`YYY/Y8YT1
S*     ? c$
k*6
mc8*1O/
 
 =! !R]< @^#
_" zb	Q:  X    
I =.G@&y$g`,>$!EAe/BJ @  -Xb	KXI'mA$ j8!wha	̈́&@R =c V', - Y- =@W P y5P%~8^#~107+.C_[H8C`	"O @d"#CF|( N% ؏'	W# wE9@ Ƣ( [G;F+  /#  -+vk+ [P z P%Bmc	o	b	y`	pB+ 1@ : IR# (O6 i a8(+ h"6 -(, !%PT" PT wPaPU! A?-'A.P]h=1,.a5c
l51-^O1] A+`0U 1&ccA$@hA3_	6eaW]Pp4V10SX1
w*
OS"|S1CSt !@" "0"
TSASpѱٯA
S Ab6ASA;$/)SSsBF `A   ZtS@\ZSS# 	/ A&S̫rb	U@4=@
@`]bM| ZS= ڛgJ	=& GXO4 a	SS΃` яf:`HVSASA&/-S'/
S;~  sC`oM s'X+SqSmb"H_.V4@yˀfLDSV܂%jZ  z% Q6 |So-(b{6']r  J5' !S<S.- +fc._!o# ]3Vھ.hhh	`	``	{7#V
] )Ve` ) AySxNSRS SVSWSWSSSAS azC.S2w.P1PQ/Sp.p!cq.1$Rjb2ycox6S*Cnc`QV11WiPDSSoSd10?
u). $LOjQ%SN# /P$%V##sSSZ'G\SȄ!o	n~9A` ya3 @`qS c).K@S o	V/dÂ!v/# b˜bAynoWcPAbb	^O kbAobMuaJM  k   㤇夏+. 񣅧,0`6tUᩒ uZllŮYS|S$<                            @      /    t     ROME                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 G  RAT  ^SATI jp P  R I  o_wAIBs W v D }PO  q Bs W QD `APIB_p Wr D OB`q Wr D CDMaAMD ?cAME 
ep F hf S bq M  C !g0K hAU  jjAR  |TADR{ p SR  CR PB  XABLs P VABC XABE XABD p TS 6nATC p RS nAH  oA?s DBG,pAWIN[pAOP *pAGCR-iASDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)_!   NEAX N`  p L   Oݞ B  CB JEC6J`  p KCFED6`F`  p a7GDcEB !6ESI ;6`  2 2`  :P : > >`  REIR`  VCS
0Dq .@,SQ*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 05 ^6 7^Cfp PjD PnPPQssp qp 1##p 

e		VѳٳUͳճݳŞGDT ɞIq 垽L Tp:K!rp PswNNE a&BS JX~DF]E
A(w6b2g$:lZE" E"VE:,R ] C,D>F0qE".u *yD(}E"O	!2 1S= P+P C D SI Q BP= DS1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCr=FvB zGD~LFQV$[}`eF>wpxDaAv`1
R1Q U2 3 4A567p!Limit= , Base=1Ra"d^ݲTfj
nX4`4  #j###
##	#%٪& & & & V&%%%&%F(b+ŞG-ɞ ĽG'G%!VV{DT= 6=} 6= TR=Z}     0   ? ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tabl
ntry 
Tracepoint
 III	IIIJ
*J?JEXEC WRITE`PORp  ACCEExqCdA BY\ORDRD @rq MONLY 0  NOTRACE 4q  Disd RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUIS`	EN|  LOC  SERI1~  CONSO

RERs 3= 5 CP1CT0A ALSLI"335c    2lȎ؎.VL` |L   tP  .>t:o$>UA UA#uG6JAB qs
G}}L u7 V" "$r;sc۰$ 	 PSQRp.	c(f._f.fL  Uj AnArL
u, 
 t$.tN u% ;t	.^L /urt..9Vt!`	cL.툱		!wvp a{L P0urotib aa
uj. .>_0u+.^Lt
 ut-Bt._L ;3΅u'߀u2_". ڠ d` &.RZY[XfP.^P1_aLf`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%Ά)u	`,LÒ!h	NJ	 :twUq c褅s脆=  fPf&@1KOa}1q	21 -6U<u f.R=fu<=upOfffDf.
?f.@#ް(RfC  f. ./c .3ӫ!>/d /8d A9
uf3Јp;ZY{f[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:BFsI>%C=s@>aC4s7>L(r;< uD< E<AF<uFB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??rL6Qaftf+fxvLfu	6QAff33-f.xQ'h^fZf .Rf.Z<7 &ZKJ PQtނSc ۄr	KtY`Q`sV2' !	 s
ۃ`迆r_^QW<;t= @?A Ts?覆urwT.Ws_b>tT!yu譃uP	pX
C=cur:f s20W%t _r#t-6-0/
[r\afbL    
   P0t-*u袄r,$t
>Kr.dL.|NWaL hJJaXW\LlWt5@"7.R.;Iuf.;Kt J^\ o`96XLR	r n6S p2ft<guX<t<t<u
t@8.T>9<pV3!<1?1?(/?pÍ:B@T!4`ATG `CdFjc1a%eEa ÑЁtI.>T rÍrD> H$r5} uf!u%/$ "PufP 
t	 Ru]MS?e [ 6E[ޣ EQCFP
[}ߺ ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>YKr#2K]..@N>FKr=.6lK_mrDP[	  {tr@  .QPpPG f T G@  >iJ rG@  /h !0J G W'r{W
fv`GG ~r u6ЬП.O>J rGG s'~td r#G  |6fV}bMQ}~r0fu!`A~Fue`f10<1pkY!\/U/[P'0	Y r'%3]pp@b  B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}rؒ0	^}`~{r s
]usB}u PG?XYR
 &ies_/numb~ PQc bS6Y{P gY t"@QYz6Yz.W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  Zvzz{wukG>!Kt {6oZRz M7`uZAz108J 
G6>}ZzfGtk{[9zGz:.
~z]"z4{"=-8E 6	 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUАͯG t`G@.b[ 6GPpErw
f[Gff.!! At`	PRB Of`fm3
G
GcH]_^<dW؍ 
2 G@ T_oS
Hg7 sI &Q AAAr<s8f f
up0Soft=jnovailvq..
aGww
`VVQ@ u
D- u+@T rp] u62]iwP>&I E>XA5!~vAV6@H
 A5|t/fTWfpdc[./D.GI;u^`j!4.Da9Ou.S)a-ٟa[` &G!VWQ- Y^_.@aPPR !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^LAn$ ù p    \ PQ1.E..{Fô rGGAwr8 ~5f}u`uup~LMuvOOF9zA:A0 r,P;A5pvt"	r=wvr
1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
  ` Qut+xt`CL 8utw Du߂  ` u  +3R0EFf`A!  [s02a^s] E!t?..`ȰV`ঀ;t` E

`t#C vu0<ro!
 12Ui^Nx ~@v`r^aA+
us>srvrs9s.,!, ssB;Vr'swAɡ`L`]rߴr6Pr$`@$rP{X" i . 
 A`zsuzisucPc f֐bЋ޴ ui
@)@b<cf.c c֐v` !vf :Ц3Sp/bf2bZ{p-.9ud@VW/u^/ ptR-)w.c
t0 +Y0cpbc"E..VW.bOqp 
f=8s6q0<qr@Ӎ6Edp  >co0!.cpLr.	qCkr!
VA4s: |qPdE@0 .b  e?="/pq'oߍqo opW> eXq_rh߀< u
Pp PtQjrpψ1@+rp6eVoGf.b dPdr胿p" .s{9ojp|}6o8=oC*yo oRpHd Fouat physical address  N fpC ðSmsr%kP_,tB0}xBs u2 u6;fnn07!q~LnoVfU~Ll o +@Memocompswuccpful*pW@9	x`>ףf?|F K*Puf6gϵm]b>+nf@O}mDmaQ1	#|!!mnlt fHt2}.gQr8HtIt[ntYrTK. LU>eAJx1/P6| r^uUuI3ɍ>/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wthlr%lFm@^~L0N 
\Q&dmtvv rqBBEmtT rp+9rFBbym<Lu4Fm"d r'f.adv.*ctud0]SWf.>Br<:ufF	[nrfF>B	 r[SRir$lr%} u]   
fnrZ[s   >lr<jr>j!Ds<$ 0t`.R6VV.=0 4j==Bj ku  тKaL.Bj{?r`0jwH4j l02kBWr&`j r..j.
8q>j#R9 	v~	PGDjzFp !8jPFj sQжec`c||||qgF!
Hh>Jj~.?6Hj@G@Jj yaDHj@Fj.4`98jw
.BjPDjN@Lqw2}DLt@Pp1`  .;uf.;u>-(swLh.LAf`0lv  5p q	tPvuI`L 9Lt3.L.>Ll 
uh. lV	dh{m '`''"~ "

IP.;_Kt2IKfQ @c3Ú	!>Sq@K.l6S䐥%3@(./l@~_RFXP[W\@J  aCPU Time Stamp display= Speed= Must_ set sA to enab/le tsrhtJjr@de=@h.vLVhuʨ&>KrN <uFv%0nf2.0m g6mfQvL3sggR"
c ter =   uSec	gt
ir!L6nECx!1n1fÍ>﷠gtG
SrS 
<t.p&~gt#>K/r/.< uhgt">Kr.Z
u
#&W
*Targfpis@rt . R  manually if| fails 6io}eq9P=ˤied^V6AWeiF auЗP6A5e6A.e ^D!e PQW> Ue>UA gg_YX|f{t2,r0k papPnr.L Gfu.L  .D;& $Ahr 2w,<r(.L됲 #rLCF XA*	\`_ @p>&L
dw@zibu	1PhWi.LÀLr LpL#rTRL.LDuL V hRQh_NdS4jvXoh0x I LvIKJV  @LOALq$ecYQ*h 1h
`PL'c
q.L?
-(g.
`0Ug`h`	dy'g0
  &}[Eø s[>tFr6>rG         ??? fRfVfWfUrpr 6rro0 's 6cs?>re@rQɺr +CͺrХr r uj.r۾amaкra ݯawb.rqao
 .+ s`@Ub6p`Qe+>pr`$ҵ
!Ҡf!rf]f_f^fZ*r 3<dDgw,d P$<&Xu
 $	,<w .	r7rN.rQ`<uF؎$<t
`Ã? t#;Ot끽YQRWSVwd^Cr.;0t
|/r >rr։EG.r.rfEfG rE
G
.rf$ r-//t   @ -@.r tP=? @ ?XthuP[G_ZYrepe  ` np VW>#s{ tPoucucqcӍ6 & r rѣ>r}p	,课 5' #	&M';c_^ cER}vPfPǋfEEE
EEfpHQVW0G"?u-6j@0t6 6!uC_^Y[VW0rχ
 `F
Æ  fPf$FfX{  lr Eف@ ; fQfPD$ us+ؠ% si}
uFDM4/ E}t#uS߀ uNfD' W 620( iQnu K
u#*
p	rg`1g
 u,	 1>q/, gfXfp5 !sps0Y+5 < 7`Ռ6bga5rq_~ie@ aȋ}`$s"s1fE[Z0!`D1S
Æ	}!f+B>sQ@"À*#%>dD@@RS`rfe  #bV+^	sFN+R!%Dp	D
MRui
HaI I7`&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$Pr
.qFbb$)Z7+ɠwPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ tt$#7!/Bw)|CP{u
s
>1`uF@F2	Ee TEDDd%=upb5AIaR-df$0?	К(=(t`o	
v+Ұ=uruQ2$nrStY0<t 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`,qC|0^ erfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@rG= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0rgOCf_2`0#escsssdsfsgsfWPʠ vB6X
TAqAA ݳ\@t5D ߌ  + *2+*4+*8+f5c|- sMUЄu@føtsPørcp d
q tn ?P~a slc#fEst a1`6`%["	
 Kѧ]&rbpBb
Fbx+Wsi ` d` p p P" MSY_ehkn uAcA sE
WV6qg4FW^_W_ t 	pU!	
  	M
fword db q tbyte " Q pt  WV.t"Ü6:s6,6&ps#߃! pR6W6_.W^P2 fXPBXP $0<9~Fab !Ò  s봰+ ޳  1$_  s1e+s-!sfx    wx `y@  c      e d  (    $  ' ( , / .0 4 $w7 %8 9< 4? 3	 @ ݒ_ H  P0dX ` 'a  b 6y@ c wg~ h { i |` l s  !m  wn 	eo p cyrq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 IS
8&>8 ` f ٽ (0 8  wL%  Q   Vr/[  pz   ?  Z00'8 0n} ^#2  b~, f  jzQ+ =oe t#,w z  u 33  {9y   %|3  s  4 w  uw  w e 
w  Hz\
8 x Ķ mf (v8#  ܓzrܰ T t Ż #81 {.9 %˰ t_ BFͲ b8  % 98	
,
 
b 


r
QL 5?;   ,F 5   !e &  +{Z .  (#  K2  )`Z$ f{B` } 6	 w ;  Aew F Jc87r N{޲c8R  Vf(0Z8^s0ZcE g k	 oU
 s. w0^D8j jY~c 28(2͔e0@9 {~s  (~ ;u tn Pb    e 'w  	  `d$ $}  e   E j	   e @w A  wB eC wD E "uwF )%G 0wH 6I <5wJ CK IwL PEM VwN ]	O dT
8 ~o8( 0f8Te   |e y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 
w1 
2 u0 $8 w	 ȵ w e w  uw % w  5w   D 
  e   c8 j  Ur| ! $e  E 9  8w#E(r -v02 7v ;&@ E JvO& S(Xɧ]emb gflqvv{&뉆m6F6	V
o¶f

v&m60Sv
 e "f(.5ur|<{rB@ EdJ8 wNUsf(U 0[f8cݻjp yt`z 7 50 8}(<88E   (f08t
wуȬ б؅{sO8 $ $`$0 $ 0& m˶ f%w% %0'8  `}8  f!  %\Ćiadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl wimuP nsbQ  out a  j/o jn@ cp @ z @ be ja3 jjp0@ l jglg test xchg mov lea n cbw cwd call waitf^f sa lQ 0ss sto_s lod cP
*bbb b rol@ r rc cr shl@  a@etx`ente"uf`tA o iave`md wxla@oop q c xzQ jlockpnea e hltzPc t ne div iQ cltc i
i d@d"xzx lf0gpsPl@`hrd bsf@ r bt0 sp  c i x!seP 0 P b zbb Dp"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxްfld1Q l2q e1piBg2nr z f2xmyl2x _fptan` as rextrac.s0
f`/ psqrs01%frndq f &+q
ucompPendis0	cleinB+fQTf /esc
en5v
cst   fre0Q /r(AfbibC

;  ?	A	 r=fi2a ( wbinv&%wa ::ob @? 6 s zs 0@ F:@s s A!lBA CgQIA 8@=puid wrdm-rdp 4rdt`rsm ud2 wrx~O .  f  yz` {|F}.s}x33	t.dG
U.{
EwwaF,(-)*d.V)PS{ w[XFe{$U<v$tU	&w$!^!w'E t${$$I4ߪ芥"{$Q(',fU$-

E%$0c<5r1<" t3"$v74&)6+{t06-U0E#3$6Q9{uF;m>'A0Dt+=F&_<JF8L?N{t!@PE,S<$VuBXU&[UD]` b,cf{1i*l
nޕ+q#*v{u
UJxL%{E}G/'0#dPPOOQI}ϐ$TߔT<(}YUW퟈eCC'IC~<U&@'tN^86tH`&@  6 f3 t3Vv^
 P K R R   A
     < 9  P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vF  / 0wQ w;Px\<@by      %  D` q	                                                                JDBEXEPTNŠDBWAITCMLRDCPUREG(6RDDBG rSCTR ^MEMBUF)۟ɠ CMRSPIOPORT5aT ISPTEXTˤ̮oINSTCODEI*	SMMGŞdESETARGЦo0UMEwWRWuRQ
/]RQ	A^WR 2Dws/1]WR	 	T T  !!?EOP
                                                                < VWσ m   -$  rtˌȎ؎  v$.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bgug u_tT.T$ t?$. 0r'UpEpD 4#r	
XZf[`M0Np PS tatCu?L7hؚc t-u$ظP hh LPr 	uI[XˠC'Pe
.> t
P ZXPw Xr$$
0
5 r?x   hP 	ruX0rPhBfP f"wCp'
 f.|!VQ6'6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  s ˜0   # 쪡q	t a*u' 4,4 u.>. u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.>0A6f.R6D.?VffX QZ fϼ / 
uf.R>r>^)1  p Z P3rW# v  z Ѐ~!f%#6 .,.>>66
|0 6.ffaJ {f)!f%@UPJR1f-pTf  K 0UP
.QX`0?fZt
0T <f%'fC
  TPV!	.Q~

.
..[GPWS ^ 0 rMSZ.&ZQ< .Gu
@_!QJu)``KX!a @aI	`b  .S	!@%"
f8.6V.6If#RAKf6Of3ffSkAr輦3$tA^`.u	DkQ
6˥d dTt	6ݥU  } 4
tY).V0#g&;B*R'Z=u EVW>ˤ!b& _^FVW +>Pdr6߻>_^HPx pfLfVfWw>64 /t 3ҋ f1@
G` 
t O
twQ	= ? 萯 68) <~R 5se>uf_f RfYp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>@
>ǿ  u
lr3- w|_HroQO
8rK<?rDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3w-.-nB6/A)A/"G2-YE.p"PG>qmBHr
x6ta >|.s<u=0> <u  <u}0Pvr).ka>PNÀs~sDQ w?Q%B>@
 Q0s?^P2>BYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i f.;iw- AZ r%&Q0PPY tfgG
>A_ rU,f ͅ2mWT)zbd@ r@f؀ffFgf±d# 
 .ɘ႐S3a `t
.݌ffwVzxv"  u $P.$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@?f]anQn90P:fP;651.=Q[ fDJR RQ T
T

 Z UZ\$
f{X Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ffC*** Please restart the system manually.
 .<t$
  
$!$$0AD?O2撰ߒ6Ҙ2ҘӯPu@>{ Q1Q ػf?tuPRP ү nt_Jfp˂a 6T WFOPtwO@X g>TYYfPQUGPF >JMu
,2 6  POX]0qUf w]Qσ0|Ş@Gbؾff&f_&  G> fG`GaQ6VfWf>Ҧ!f!Q С fCfD4$fOЬV 6ҦfP ȡ  ஀h$Pwhų X[õ 3@Ĵ$<sAl r.ˠU訿rO!` OA (tD_rq XPנ"Q!ؿf0ѣ!ES  gf /u
> up[PȰ&  cB`&Xq!g= BxxwB 86{y͠͹@ ߀ #                                                                                                                                S .}2[S[W>  t> _`W} v	0EAC r3_ۉ_`?2St]AM][QM_Ϡ &
`9P
PR<w. [SZrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hΫ\bar1TaP<u< <up. .:.p .7c>`2p .>bs:P	d.e> e,@p ˀu 8r f΀g[ø0
.a.&b΋p1p.mΎ7X@E2@g.*f΀ v&.f&˸ Laap7*c5.PC{3`Α0b  ϊ* # PQW`
 _YXR.i
 Z k@@ZÆBB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x<Cwp.q}u#rp t
ArZwG ߊZYS2
dؿ0 PR7 r  dI r`.pr`@ d`QR	 .ߠp`qQ
t
Qh{EYnus33`8u" f;`Ph @F F@ &} tC t;k0Tta30h &@9&E pظ@ P ^ X Wu-  apPfatQ@ ϰ YeQRW.. w#&.!
tff..A_0Y}u..nf/.ӱ cߏQ޹ޙR'@lۋ۩ۼmcЛЂ{?Qvd1>+ r.觳  cPPJ <t<t<
)SQVWێ-<t<wPXrs<v\.>Թ &_^Yy3	0		ԯQ @~Y!<8t	 `<PVtu=EIAc
<
t0FXAP QpRt @Qȵ$0<:|uFP ff PffXV	 Xio
Pj}^Vf3
f^  Z  f`
Qߜf
*  >"Orf0f3ftY "++x fa

E   ۽ 1C< tN< XÀ Ttu7A!Vu`U߬<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ o_!]SVW31rKt	s<<t<p; <w
t+,<Pu	& u`< r 
A`< u4 _P&OIVN ۩0QVSQWU3t!;wOQ
G:Yu
;t} tۋ]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3w0<fw,W<Fw7<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	A
Nt<Yt
<NtNP3t8tNXPL9p*򮿋HHH
uÊG O?ÀM=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Yj#)Y+PT P G WIN @BDF8U$<w%.JGu~0
t;wP
ߤȰ
 3]8QW C  1 [n6f.)ܑ0IQjY f.>)R[ 8svp $h 'Qv t7H485 26r SHz ueaJ2?  UuQK7e	$ <C EuAm"' ;l  Xcސ3PQfR1[3; Bf>@>Q mAB CPkDހQ@ہRSABC DpPOP R S c?[ QSWP).X.܀ uF0	P2" <r<w,@.``  .>ܹ
  <  <;u@À
s b$ b ,0 Pq͏ܸ
 Y.l<?uf. &[u
f.&)R+<[ ]Op^?pu18x f;tu/G2p _1kSfa u<] Pɰ݃f   `ſ4gB00t  t t !״rer cZfAA Uta	$`<`ut
*B5
u0
t		 u]
l. + ( k@
ݐr.ݰ

=ZE"R@rρ r}0M~dZrB BU
ǃa" rq"<0oP w  "
 B$<  wu֐S0p@ "8دt2Tu}NuF;J t> l@ u.Su;tյ "1
 " hۺZ.'yuη ˟                              |x KJغII`BC8uĀuBJu*@u
Dg0/JQL @tgB/AJJ] 7HĴJ!R~:$ ̀u#@G@6J B3tB  DECBc@CЭZNBD r0`1	$
 D[_m rPf j qbA$<+`mb+
cJ$<u	f k rPpc\ Ḇ[ hГ:I:  3  P O O 	   h:r@῀ gh;rA6~BȎ؎zЍYӋwh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                               F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu%	  	6r]dt 2
#
C2
EG2
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$fQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_P 4Jvb6Wl_=8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch i j b c ac_` a d    <    0F00	rvY	h
`a;@;Wff . ip
蕠 EϊfQff
f aVWIB,S@*(_W赢s;_t[s)`)FO[_^aW>f` f wsup7fffGofY܂ho S1Xfߊ$
)ff  A	S22+?Qr'~!% uf 8s֊ҊʠXQ<RP
_t0_r#YPY  uf auTf|UPfPfXZ+ ]f0*ff]rffm`f#n {= srscB
Cb誾_ 1?f^ ɉ߃w @tr;x }*f@Jkw  C)ѓu6ѪȢ+f;q%N?f fBsg  uV0^Íp.RfJyZRUQf fuffVfKr=XfuNVFYZu F1LMuY ^Y]Pg>!f0sRg'QSVfNVFfL~ {^[YrfqXftA3PXQM購} N Ow蛂PRA` X{PiWU豐Ԁ_PԀ̡ A1\е 謱 m]eXÀ-pߋ_P^Z`W f} mp_p0                                                                             .QfYfUfQ ffefVeXrMfXf}e gf@ N V Fx_qf(gfffffffff MufY2f^@{]Ë<f3f+fQSfVfyLfT@DffiXf^rfXf	wA؁fXff]afDXf=p *e6aQR
^X5Wt3 b1RfZJXP_f] ^PfW#XVtQ uUPXY SfiP YXt
 t$VtO tPk Pkv nWpX(t ̂(12VSQWf1lw#t r{ $r	 _Y[f^mQWVwy^_YV3
Ê^@S e =   fV1!fa6+ff;w	rf?;wfS.- "   f%0~3L/arRS@u$ ͊ ͊1S0S= <r  <3ߜf@ f
ffʝ0聤fpМ0 fW >E裡3&G;r_` <%<t   S5 t	t`Q f  f@ u$@fYX4Z4f4f ` g&>tq r 	r
  u f_Zgf&^@$pf tt,$
g&"Fg&
Fp*$
g&#Fg&F	;f#F	Pufa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`
t~g&`
g&@
p
 
u
g& 	TA1P a{3Rf\&^q\QUUt\ rD._]w; Ky!r.f%  UCES~sf?fq 3ׇ  u1f!u%f#P &	sLr` s` u `a舒ff#ff1Ŋ 4rffapdSfRQ<t2f3Cr6
+3f `rB*t r(p b u DYYzf7
f4p 1t?t
Ur2hB$R'8-t(r!f1ut
J?葿t:R!4e<?I0c[ki8t , tu
@u$2HЁ)@t'@u'-*tp(Wt
!- o t>Rs 7fAu2Bqrr3q 
t@  t}CxkCuri/p/B/RZ/?rGU/Z3tqf@L$
 d L,L$ߛ`c pL Z|VQ! 0fF3Y PS0}LLL  󶎢n ^L$eLtL2?LFLUL@x  

'L6	 Y P GS w4fXpG	ش @s[UV~W   _ W
t<5t^ɿuԙݍr Mf0[rɍ~p5QRV3P'0 FoKt
P J8u}^ZY}fVW跍fbz-uKLE}PЎD@t0	 zAVLVLJ -1@FX^)  w -  ?   a2!)m""m"n#WtK.}
u.:&tL u% 't>JrS[t L.[u (t	)t_M_EfUv"v t Ar M ?.V PXF
ph@ &A ϴ}aj@!
`ð nr`i/\V
	=VL..6*# ,..I.
Lj@s&  |0u `Y^SV#؁D.d.$m^[(	觞ã3j0rcOt` 	OtOtLtDVLt
tLthLtbL*

,1)u	c.<e.}h $ BÁUu	_U@DqPR#G rp
\ϴmZA fP<r|wfD u
  qxpWUuP&Br& ȎXL8,VL>*6 ..>,<@B:Pa 3PB &Gݿ&G $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]_&?sߴa s=@ `b 
 .GCE  ~A2ff@ @SRWP`޲ ra薵'Ef=hLuRE<sofQ@M}3  fYr/>LL.  EGώ ϙ./17[Ü_Z[ .>'u4tGpFX=.EP .&L>J@A%50;f @َɎٍ6L P{^SRt5ێË@S.q&Gf.Lf&_f&_ - Y2Z[fUf0BSsQSFGf]в`S([PS35[
ۀЗРӗX$a`RsɄ3ɺGr`Bx4F3W@  "FfPAMSSrVW2h ag    u
  
  t@˻ʆ sFrr ɍv誟00w& O 
 30&OˁrFUWn
._]v
P` u]_^w 1
Ip b MB @P
$) D N)&= @
)&|Gvu	*v *p cu#' +}+&*&
;uWb}+f3fu?,&N% 3*_ZGF< u  u?2DC@@sN~ t
Ss[=Nu0tput

qDPƆf|P hP f8h`  f < Hn  $pp| fzl f
׀艐ā rMf[50 f%ޒ ;tffp ffXP _fYRfx ú 5Zr`PXf`c``d` Qq
f<~fQRef%0

 aDpB_B3NEOA1m 9!*qrvfpft" QBY fΠh|Wfrbӿ  3fff  Ou_fWyryAtp@12g@c@gBrQ@L B = 8 3 . ) $     1_QQ&GYÀ'vǹðd :*?*)@ )q a* g*0 ߗ*P  *a N+& t@ + +	 + @ +Q 3,Q , , @ ,
 ,G -G Z- v-   0u 	=1Hewlett-Packard 68DTA Ver. F.0C 07/22/2005p5[ ]  Z  l ~q oKBC
sion XX.XX  
 
  _ 	o~A# P` @  AQ U10 Intel(R)   8   rnal L1 Cachea Հbi2e	
 6PC CARD-Slot L
 `M	 www.hp.com  w
 `   
> 

@
   DIMM #18(128"\]
a~"Rpb Ne"{@],No bat: y'+"
/_ k$W. _T*u	 0r
yjt)߀ut& 5& A)u&u#
u! À8W@` AU> RtY pwvMuG	0bu< u3uOQtru1 ta0> S:u@m8*6R:EFu :E0 } jQtTt̀t߀EtH71 F )t%> t:& tSuE7u3  t E>I q u	PXuP3 t蟁X랓tŐS%y>E ut0#)	&2!qP=E0*x3;r.Dv+}W+Xu432#*u!.Û-*1!	 2褱<Gr<Sv Ê,G߻.#]C%J u$
<.r!Lu24$`.>2K#/rPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10   EAX= EBQ C D P@SI Q S CS= D@ E S I1xcept1t4 - Overflow!5Bounds Check6@Invalid Opcode7 Device N hAvailablJ8Aou` Fault9Pu Reserved	10TSS1SegmentPr n12AtЏ V
3Gener`xProtecErrorq  1 =  System Ha!P'

-XÜPRj'< tZ fVfR61_Fup1/vz1[`cP2Yύ61{1t ÿ61jA61` /ސ1T ō61J61APǍ617XY_WQP61$Q1Q1p1
6163F
0?2t[2]&y2x2nap2WJ2o/@b [Q G ; 1`(0_X[S	 63ϋ p C8BBaaca$at@0 DFfFɷN
~fE F Nu3 'ȷn ]
 cRQP~
Xܹ /FFYNZ1·A`QȴjY`Њ  aÇً`ܾ6"ԃ`6 & G6 .&}5'@'dQRp Z
  c Z 
XYZð
< 
7 SQR  ZY[S r  `؋  p 9 b _  Q!
 	`w
xa@ ؀ `
UЋ []`a	@]3G
AF `P{ C0[@q$9SRZ[` $<u 3 0ؾ   fa3S 7`Q VQ=3AUAY^` 
aËf3RQ3ɋff tfaf3fRAыf;v+R'TYwX0P@YP\UfWf&и`1fW؂]赂f_ff_]p_8f <u ~<  u<  l<c<@%Z<	~;Q<
`QH<i?<6<
-P= uX<`<<pXL]WfPCI 2jLu_fQfRVWfSt$ѻ"r   f;ttN紃 f[_^fZfYffr }  u^
N`o诬  `詬 s r 2fSRfP{fXZf[轥\=ff\F5	vf s"s t s t QVW&= & s fPf&EffXN   _^YaJVWPwN`;t
X2 *W 
_ ϰ#t^Xw _^!DNp sP6уufQ fPf>*f8 P8s2fYZf`ffWgfǃ#Egz ٠@ܺA^ vT2gfgƃg u	f@w1  f@f@ۿf_gf1 gffgf0	}a	fQ@;gg&fGfXf7E;wf+f@F+f7gHggfb	f0I#fgf&fa
tU@@P	3
gLy
ff|0
gf3  P
@rΐ@
A
@  gf3fS wff#b ffyZ?'wf3f30n,;w+#4ܼbf[gf p2
ffIP	c	
{
fA"AXAP
 #W!fكs À +SfVQp g46f?FCYQ  Y`@.f^\ g&GCffT,[(u< uEuPPu
uZ@PPE EPP runtime BIOSްVers.1  
 "@9@C@`@@@"AGAlAAAAA BBBBBVBwU .?]?.Y.Y r R.Y
ZpQRPt<rt2[5$ԁ !
  -" ZQ`$ _X p[	T	u"	 xuR/] USUU
.V	`&/n ^CFS CWU	al\Z ?u@ ߆ Us PSR{<r
 j ?GАr
t<t ).>UB a?y.UB W
R  R PQR3쨀uAB$ԡ 3ZYXPS]&"w
ǐ%d&[1QȠaܐY`uuW_t= (u 
f&e&ذf&e&违20%%%a VR
txSR ڊZ[  Z[Kώ@u?OȠ%%t%_p0p0
ud@C9Z^`u=ǔu}8qBp4
ً@p 2> 0URIu<}u7Gt)蠞虞tڱ
@;Z]PGbXU 
 s ]`K:\KxS0YyM M>r}Q4Ys\ PZ 3Z[x0"$߻yP3
ݸH 脝ٸGG |+V QyLIQK WS
 pN =qM 5#Bc'
(<PdF/FwFFFF1GGP&` XW<or .E_Swt 
' t @r
2[e fu0^r!<i	rr&P PQs" r2.E2& r $s  r  9q	8 r 	&& rr	ô0Ss+&' @>'  sa$esQ
u>[ W r%p$S r rq	A9 f" ?$ pQ@	Pm mXa\#t sq]@tQadߨtbpt t
@u0Yp`
 
Xr`QPPPt3QXdYQP"Q0 tg	` QXd$!<!tPP_P  q&@tPGpB`+ (`<u
 @&   >!@tA AuqPF @  ,8 & XV߁  0`O  r
 P<Fu us	} 	uA
 fu	 X RtGTtu`6FtEuUrPRtK?xGr t& 0R] Z| &Duh8[ h 
Xuh:rX&  U au@ ϡ*t@Q!	 r]r
.rr dP d@y $& 8t   `{QX uSQ^ `b+NH `*C: E8011ߗ @@X@3@*~NC*Y{   0 " p	C  lFpoypOIEMAG  IZ P   0 	{
  `# HDA-L  wHDBs A-E r Cu 0USB-[FLr CD Hs LS Intnl  PCI-As B C  % eO   H	P 	/` <M L` ;c!)LF6	CL L ?LCD001EL TORITO SPECIFICATION )NMMM " * Gxx  x y 1 " *
x"x 0/   s w_X _y\[8y y P\b é uT ËEtذE
U ʡ`t
rL0 t
rðÀxf`!i2tW &  d_&E3aB&U
&]@ &EL t û/N:u0&E@ !m0  $PIR    A i j b c p!` 'a "       0'00Er<)h
`3. W  p
w_ϊͻ 
p aVWNS;tpOt[
D[_^W3`  Qu@ t`GY˿h /$_QV.N  3ۍ6N.N^Q@ FB C PQQQQPPg]\k tg}
3@kgE
UP udPk 3    SQ>ߴu5)ôL% Gr!<3ɸ 
 3Y[fPfSRVj&jX$'Ptt# ꭸ>ɠ<t Ɲ< t 03^Zf[fX^;V   }su P	toir
- ZWQ>~Q [={c
@i2igu
#p d)PfdfBd@!+ s dMd}5 d	 J VR)dP <d;]ttd|d]^  R 3
' ' FǠ  F/R3 .;v+GuBG
`F/ {@`S% 	pXvNuQ
 	0 NY%'
r0123456789ABCDEFS ۻS׆[U uP[Xd]<t3 r
tVd4d8D^u!a;RWu'Es T?^uA>0<`|3&
yt,ߋـ Bt&M1&G&a}g߽g@rgLAAATga+Íu 2<ytȃt
 Q ܈$FKuðWQ
u	ۍYѿ;Y_uS߀u pu)_4  RA  @[fߊ$f
0f BRWS22f0P(r :u ,8s܊[_Z?fQWRfP
t)P0r @ff  uP8ufXZ_fYPL r 3r: 迿t+a4 v 
th8t	
uY0	g&;t4g&Ct,g&Cf4Ж$<vff٠
t
g&:#tfC1	fSfWfVf޴r7fg&F 	f`r!f`Gag&O@` Nb O f^f_f[B2p n l C  Ơ #  70Ȱ)"2ð
%,p p$ztø
 а	2s s	2  |0 	  r{2w2 	pÀZN:4VOH
3$ 
:$0 zB&$2
îVVV	WIW|WWW.Kt'} 螊<u 2裊hhJ;rWm1qwqs|ws`PxVqs
2  憚"  |  i .D@.ߊD
 l~ ``oX&&D aø0 м @j &߉&E  މ3Լ{1̉ͧQPTP !1XY`.\.T	ώǍ>.L` `vba.D`tbaQPƌМPXXɎ6
` u ߴ#@ $t$?ah@ & sr 3ua.Ya3' $< u L;I<u	.Y u<0 2$\   tu_u	V $?
4 !d S`@ u7` $<uS[SUNNNO밪 Oط$#c#j[[[x[  M G `P" *`002qB|gppAb(coU] _ ڋU`{D"@{GۢFJRuQD%Fڊ̺vY U 1o ! ۭ@ZPعU fJMON# fP dâf>uf   > t&r9_Vuu R@hWfof+`uQf׸@ Y_rfǳQ	7pg^fzl>uIfs@
f6ǁ0 u rr
> /S Wqr!@n]  u(<sWA.]_.2P0=XsQ] \u..&߶+.	p]@ t^Pt.&u @ u42..
t wjPUU* *Ġ&u XY 3P A3.G
{XP?] *.϶,]rWȎ]
]_ _-_U_____________VS3.:^u.o^K@[^* UFP_2SF S.^F[CN[QF?t^sF2~ tׇY@07 `  _ ø8v bd[`d9]A?`08y9 3`k9$ $ì```````a`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233p
`f>"  tA" P a2( Ҋp ) ǿȊ&)  * 븊* >+#1 d>,0.- &) gr..PR ut;60n6 6 3
t,=
0
"=
 
^5w<t<u FÀ t< 0 Ps
& 
<uaw\wWQu& ` uh7`!Av &
Ø?Y6 FF;t2bbbbS  2`ntvr"u  6rwFwvys`yaRsDsErxUpq!q{yqq q+q IqEpq p p g}
3gE
 t"6KD  [gu0ERusU I~2tKK  
$4Py&E
E   Fj	t>]>
SQfoVF! 臯s^(2۹  PF  +^D!8u _#Nf^WVQCuKET! ذӸ!0w $I^:u:\!u rft Y[_SdtK.`h045@p qEu 0$
h`&taRHP^>faRМFt@9$t, ;ZC1)Jк  #й$PPRZaط $0<:rd uqP P H] в = ~Pr q& fV:gfFpXRyZt	t`v
 {vлt[z؎ YӋhjf3 QSWf   / r)vq!ufPs fXtāۿ_[Sf<t;f3f Հ t	f Ӄp
utǳf{f0`
 /3襱aC; a$g$/}$(I$$'"$3"V""
"!^ZR@"'B"@"&}$ $p ۬faZ@fPS۸ {@ f.g{h?O[b:.gf`uhc uh2aúB   $Ü.gu VP
ۃx  tcPtt>@ KXSx$P1xXr$0Qu!$
BB Q0JJq4HX^`Ϝp$ q0-  3Ҵ )./@32ƀnuo n;bp'B0|0  F/u﴿ô # S3ۻr?4{ t WQ Ajf0j1{Q_QuXû uTf`0D Zfft;  Qf3Y,6m5 !{п VPX <ðɆt  w ZYJB<t"<t$AJWBqpvB`fUfP@RXZw+ f]Afŝf]rPm n跐 `B1g ki &  茄
d@1aËTTTT	  " y y$_SYSID_  k _UU  
 r
R3҄  ;tZ                                                                                                                                                                                                                                                                                                                              ~ 
    S    -%  DwX' p Jā݁w2L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.dKZr# Mu 6Jr pt 2rXĠ	 u v thr&3_&E0r" _r2vRs Uu
FUF ô	 q`	 ӥ/2	r@e	~	p脀'^F&?s  s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	ffPE]EabgVfQSjf[fA1fY^f& u#f&GP Wf⺁   4?WfZfXP'F#~r .>'t7 ( /{r?`. t8 & t t ) 2SrV ʀs`,lK	p dK~t$` t u/~ǉ~ %"NVg 1	s^Í6L.|uL>R..hK`>J .:UtalKaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w)[Y_0? tl>ـ?r.u|
Պ Ѐ ʋ.E;v j'fVf{v`$dD @؊f
@NP.eXfa ȋP	rs$
2

	fXy!9
dDwfUv]f^PRB@    ZXRPXuUW:>_]s*r  ZÿP$< - r!P@Xup>q @<@0P  *sXXty>Wc |* BQ	?Q	 QV  PRW> P@   XFrr#r^rT:rOt :DvL*Doȱ f umfm4
u
rPbl
u2 VWrd H_^ q QP&:Ev&M!G&*E9aVBoCo<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt24 uu@uu`  u2~&fPS `00v?[fXPSpsBKp`D
>X`?D<PƋ4a`t a1t!$!"条q1&2PQȎ`SJr#SMwO "t 
`P2:Tt
a YXuOkuQ,9a"   <s& ? `P93 >L}uǀ   Kt| KtKVW_<uW<
uu&Fw) ><@g2<t.$S[M[|u|
`g|`it\_^FS`}w
u}	 >!.pKb|܀}@a`pɏO1uD}a1 #%D0QV 3۬+^YD$f郃fA~ff?ffJf\
c
bPZ#f F PX{pZfP~Đ=r0&p{w)Efpwu fau}Cu~s3SV|t` t t
^[PfQ
 0 < A@ f	t` v
aif`0fff_ jb   fHff#f+ִ f;wfgp3g&Sg&c
uff+ffa
f4SRZ=<o$oPPAf1 qffXpNRBZru>A+Zr
 gP2ǜ p4XZ[fW7t9 u>
rrw`Ua `_B a p 0`c~Q?SQVfqqfh  U@PPP  p^Y[u(PUFP| ^	u<VWf
Eo T pLP	r=^ ?uS@]#^[wu"

 
 ^~u.t Uj@w`V	cL
 B8`.
u&* +uW·0$_Q=SfQfV ā=Ut<p*MPTh{[ &Ep` `&uf_ރ  A\f^fYfkSUh &]S^ s] $!&w&DpDV& fȡ\AL
^rfWދDVЎ &Ǒ/ f~`t@ jKʃ^~0 P P&t_ 'f=_'+a¡of;ME    Wf.	Zg&G_E!#3ycrR-uTf.֒>f_utf{`@]StQqY fqKo臫fp,  !fp9l# ,i;!U
UEG &E"rrifaޑ 'rnOGw|P_@ 0``m %ߎ`1#踁 \p<t/ Q 虁Y<pD%PH
fuސ f _` ߰?tYv.M"fNf.֒g
Sw -"|"#:1bqbP9DQ:	: ; 0M;Q.:r(G)uyD > )uf.7p ڒt- =*VQ$$D
~@V&T`<^30Dory9
lY^C0 ~u0x0ߋ"VBqEv!fD@*(A{DX(Τ8PVPWSPWQNP
P@EDLtDra
fNtrD2KWpM T;0@fP: M^_1PTN?:=ffWfQQtT=M
Pe@UBLXALBRL3S }GG^WX!WXX1GWiG@/(WLWWHP&	3
7uO`gdOp%Obboؾ:!Q	TQbo`#SSQhS3Rq	)3AUEfd#S`e_W3n `{Dku_qnGhQhhRV'hh/hذmO`pjj|t= 
cYj,{A
1$pf[ jPQRG B㡀u㰜SQ߰N Wt	fP fXfP B TYw{ѐQfRfP .x u 21ZfYQ ;Ѱ Y<u,fCISGu%f»  f  ᕆ.>w .wfl f@f= Q3p fl @@   D  rP P SмS@sS U	 Y
 S S SABC  RP ARQ SR  eRS ST  iRU mRV qRWXYAZ[\1]^_  <c` Gca xcb cc dd!eqf uߗH߰kLUbZQ
! 0?8   PRS%` +ð ;w[ SRW*׿OзIr 2 03_0Q,Դ=Asб Y r3O{:3PqRQWSP b	$ X Q쨀tYl !`@ sX J 0	uRX( V_m k7	XAP)[_YZ 2<UuXw
8
DYJa݊Bǃ   brTw
!uP 2
XS@
u	0@L ت *ê4[XVWQP vDt!WQ߶:t 
Tu8v
Y_Y_XY_^ _SM_ P_DMI_ )  #9  2XPUv F t	F !Ff]X"X
W8 A tPI"i &g +  pa!
u
fN@  ]ϰ2ðq  S\8 &G &G`G [ !@   栊ë@@\&\p F0 ]
..c3 и( и-  YP
C@@ XWP/<w3t u*p O $`XAF& ._I@P OX26$3<1    Rm ۳4!܅`" ufQ8fYgsaf[`{<3]Ou dq 2fPS=Au@u;Áp u39 u+ f?wufP@u BXu
_ffо`< t``%^{At{NH&|S{[_ k@Q  ~{{ o{KVǠ !qO E{P G{]{Q   A {{opRfW.ސ{m3g0ff=SCAFtV1G tfff Wuf(#3tfPf8 Z_3}2 p  
` tODu (o$
M`,Ya7ô%-´+#9faPKМ۱ Jt* u$t0$< ȋKf`a
%D	ӹ$賹 %` +觹$蝹fa rC<
%	*P' @TO xOy er$DIsL@mߢi&  ;o URfQ1vp3뼑/upZfQ@=fA<@1 uQ !ϱ n qr0W.V sfYZ]fTf;f;ыfZAK*f!rfS{rf+!$r
ó/fr#|s
ua

<f[TGxM	rr` P_,XPr P p$Ss[OBMIP?E*{/JOP\tf0B@XE)t fat/+f %#fSfQf3< tf!BtG21ɦsʦUat?j$7 3#tcpQ!sð-@߱1ĽWV  fSP~WB QY_W
t^9lwst6]V!<5u G	F^B^{= 8s;.<5` 
Lw>r Xf[2PX^1]YWfVߊft
P Emr& P mBD ô P(NpvgNXs #+r##a$Q$!r$P߰S)
u $0D C'û)1U
 ; ;$
Ǌ;; O 诡;$ ;$utpS  `Yð Q3)3zð&wpF!tt	* EP[QTS&7"
ǆ>[L# <t<!t
<P	<*ЙRp`@ ZQRo2s	 2
k Z3) 2VP֎vS<	 0[rqkX2`^a
 ë!R7 $VfW7 uذtOr
Dp< @e^@ 3tK|
u|	 >t0   <q<
Av^À"  ؊% 9؋ ߅99*ZP1Ou `,Xð2HQoVWP 
K0X_^YaQtKpUP2bF0 2LB2|pUʁChY
P'/#f@1-/ðWB12	Rc@1 (S)ðT)ՠ Y"5@Z5.pspb	U27Pk-鏞 `
/=@RWf;\f`ۊ50{s'7f t-r(8tD@ TAQuW  faUQ	UPHF @ E]epm<G<tS^hw`Y]@[42PQRbf22 9h ^~WhRZYKXhQhrgfӋ_`	x kt -  t	  i090fK߳r5=s  "#@O@"t yWg 
 Nff3u
P@QZ Ѓg1)t?ZifF!b"AXtԳ$Plgfffڠ ^f3&fPQXYqfԑ)YaP'уЎ tf8pk	ff Pu#flu?fwAEfPt(ffaá@䠄t"
桰   u$! !tp &k Xa{{ݯށ *q밻ݰ Js@PFF
]X `j . j v
)Mf.N. tI4~r@5p3؊^)tuwt&Du .⭋^^;YIa.@t&ڃ.^2Ȏڀ36t6^2. @ PSFg
t'.:t	tX._[X`P踹
Xu!P <Xuph@Pt袹a`
  P?3@3aP2Xr-s(@r`H rr
 rR0VvF\r:Gs5&DC Hrfڋy苡_FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u r}cwu
	A	πϠ{&DêĪǪAT0	VcH Urp_蟁sʁ `-Qu fq
E$Eab&G )
V 蚷Nh8Kr>u rG mPo3wF)r\ {r=H r8QWss#

Rr
3 @M1 |m#k##F("r#Qlr@rk20!0p ×!r"!F( Q'&d&K0#V&Ơf)&t N.rfPS^ۋ^&t` $ueG&uFtt0b]' 蝄 м  .>G$a1Kr dt
t4tw ״p掊є'%2撰PO WF X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$`
ĢF f%R$P[G ;B(FGq1ø fF" PXN8NwN 4o2N0(`00s?/ }mlpR
 r
 mr  $_/++U+yÑ &u btbrq? V/QB  BY^G $s
3
P&u3`~ @
rp%u@,?àt <q(6V&T߀Еߠup 
*&u^ô  p  MQPXuN%&:Lr * r$ P @
<ut.@ ]  ; q2s2p$<@t22P !$!${qXw [[ĺ".Pù[K<P  = sffP螿 SQ  !0Y[$p
wxFf 
۰N8tSFt f% f @  tU0    "{   t = t	@fX
`RV s vZ!
J
8
]0
$g4 Nff`4eA fu4fafFD fP2f tfFP ۈ^DPm fu
fWzfϞ`3#"fF$QiF,0 AsrBrf-1fv,v0h,U-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfWր  p#f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	넀ffvwAfI| )@HvHwf*ݸff
fA{N
Xf%	3G-WfA d!`
;Vt
fAP
Q
ĳ6"P  f%~" f%  @"	 "f'F0002F%R) !.PSQR30? @ffJDfZYPQRWSӶ Jt"X  ~
<[_ZYXS[؀  QW ~߀@	 _Y[{~pû z
  5u
 @ @u8 V0  ;P1r F4;E@H0P 9߈>%F5 N0Mt(BR'9ETDHP  SIMPLOiMOTOROLAVPgѿVS\~ЎH*g߾,P-s@^s˻ʆʭ >,k>,~ , ,艰,@,wkSR &
 3-&Z[>,V,M,B 0? t
@~Ph+؋Òc,﷕@	,	,j>, , ,j؎&3&M<St<Mt6 6 
6^VeO5- oo*-IP-@-7p-. 
 -%
"-j"->$-i>&-iQ+-J@+0&X(-`k--/-1-3-F-iF-F-+ 
r)>-&~X^ádWV*.GF< u^_J׺+rD.\J0ERǊAZqER.o̱٪pMQRR źZR  ϤZYolpR8AS؀u
RRp	[P PX E%
cE%	X< $ZT
 0
"~
t`gVW_wZwU
uQ6rEt> r2
tC rͲ  r  
!    _^a1n2
u[rVei1sCr"tr?S '?;Wr6"WQ@
Er S#֝)/Te  
 `߂ Pt ҮK\	\*P')0\;#$ rIW("  k_!vP(Bs O55B< t%@r4;3r!- ,-Bq3ɰDì@D`ó sGADw*VR@ ރ| 拴  t.Z^8ħP .;BBBX$JJ2JB}Pܰ\tJ 礊Xu` Gr V tA&q JZ  C@mA 젒*uP= ]Xruŀ̀2	쀻
 c (8SQ2<

2ۆ.
$2grqd<ww0
u@  ` w0    j3ɍ6K.Lu.:Ls&3.D}.L~s` 2`r2`p 2ǄPt u KO^t
`3t t
t
u! 	3ұ u Iú t>L.|` .L u} P J}uL   u3puv`bW_otURQRUK2YZ6	u>^
 .D b+ t#VL^ 
.L ]yÅQ3| Ys. u&	 t	&Uu" ώǍ> |  Êö澓i.f.|f@  3.|4߿\PQW 3ۍK#_,`Kp1(|n p;`3 $	 &?t+aP`)}
t 	
t>J .:UǀV tMR+Z| $p$u$$<t} t	^^ Q3䆊!*Vh L| ^t
.uu
cs)t!JRڻ0W۵u3ێێZ
t	'u
u
 >mu搉@s+XPt ڰ`lz︝rkt"Ĩ@t  p 
 ް  XPJXSPc .+. s#. sXP/&   &X[5P'->@/HtAC  I@ ߬σD
 uj@ t%v v t ArMv .sN-_f-p̡&A F'N- ?aύ6& @	3!
Pwr ^	
F (|r
 	u^'Ât %1+W	d1*515rz0/5Mrr[o[
u< r<0s<"N@PQN \o

u' 
$nvf<0r
sus>VPu.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 r20Sss6< s
	OtE""Lt*$Ot"#Ot%>" 2!)A
 ؀	.EǉFC
r]wsms1I9  <$u2 *<#"< u<@v<%ހp!2 Æ ]
F!UF% &F4~R=or&@mv8fRF'P^S^!S&EF'f&U&]rQ[P@ [`fZ護sSQt^^6L	Aؠrf;	DE蠺⻀~(LuTMs~0]fPf}3fXr1uL.  .GTAf f "./0`3V#:Tt`<~'t9r0lQzEE߀&Lq<D_D@ % 5I@~~6L 6u0fPfS&Mf.Lf&]f&} 
[!
A0'Qf*  r}讵rxL =rl`x5rdPtZ+cr@ O u~ (um-VƎދo^@tffmݵru蠡 Y荵r)8r$crre	rj蟵PTPQX rpw
u `fSfRWBt:ـ?f.Efff׷fAUffsP-EMF F
tSuNff3f   fVL0WP*f8f'w*f'F'*2t*f
VvfVv 4_fZFsQU n E]YRPXtUW:>_]sw#   rRPR跶pPӊB@ ǀ ZXюً 0oppBc`PX0% [ĳ m h謀 Bt Z^N軳rot
r`a r[v">L fKf VL, 3S5<s-LO8L9
t" >LG<P#<Q$@ dPLPQ0X h   t޲rzvru3rij`wNrWu
p`dع 
!ʲr.wǴ%a@tt t	tCHq% su~rt	 2PRF sH<t<)t<(u;ь>A u/WU>ӽ`xߴ]_3r0Cy}`_^a'c $PSR 2Z[`ÉRFtN+;P X7D	F
s+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFF  f[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP FfCF VvuK-QfXr+tðP@P3 Gp1 tff   Rf+IYÀL@uu$`{k2t
.'G^G fF! PXPE t<"u<"tlV3޾x 4Q&?s0  s& p  &G` ` G`  в&O &O`uRp`f&G`Pa j AWQb b V Wsa,ZX7RQVW:WّtNᒀuu .!6a u/AŠ ?L	
ǀ t,6pNoAOGA&&d&D&t&?D3p;_^V
} " uRPL
߰  ^   @ RbbTPQ蚒@RP  4
W j w<
1BQRs귄3ɺ@[P.
X `.afV`f  
u 	r}p:r" +s  y6	pA:af^U`@*2$ԉNT@׎Ǎ~WF$
&FG &U_@
	 `
:aP[,غ*3% p[`>W  ` t2_R Z؀ˀ$0Z'`  `t
o   P 6(ںf  T @ DXø a2r$<q ؎ff߻	R
 b cr&d %`p0ff#f' \$f 'f.4 tff                                    0ؾ +>+&۾  36a Á.6+0GARRXFf3۰SMa"fV$
Ѐ
tOf`'TW"T	4%@_ff2 WfVa  gxtgGff0Xfwf    f  [w<	gzR<f#pf^f_@AWf [@\KTTTT  A  G@ @  " y" U-Q R"G
     *[%	  ` `Gd dp",q  qa aO 
p pGr rrs sq]
s P"  
_ 6r7 		 
R.
  P3Ҏ¿x ȫp|赈Z(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457 u v5u t
&  {x_t^t]t\߀7utF5R3< v
<ar5<{s1$PɎ|Xu2jrwհѾr9_2.Skq ߅G$!u@t0<zw,  
t

	뽑t
w
 b2]kSJ, E ?G@2q)Pı
 t"< tr0r	
2vPQs	} S	gEsSHP  TPRuaa@uXXZXp! . TPX@Ż= s]r~s
0{ _ ߸^ SQwt.
! !$諐 01QjQb;˂QN 3۸ K PT'aJ >> F @K" Eup
$orp`tWǿ  d_pa(    K P3`σ0W%w,.s 8 ė0fg&'f FV= >V_f@`$<t'<t#<tN< uc g T~ M_ Hh<u 5  %l  
 aS ]U#UAVW3xu@o G	u1ҁ U ]U@ӾV 1 S!؀ TX#U^RU$	ppquTTA? u HHB$tu 21$q  T}D	0dKeBHC6gvgWD_DpDDxjsj)q@0 *{     ܐI w  "5n3@@b ZQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPkXÀu3uCpN@*  f  fV@ ބuxyt u3N@f6 Vxu^ uxux\@N`R\p Sh-ytE yuxxuxt!xv^i
p 
]]f^ϥ/ p $ $  GNaP PGh h"Gt1$  Ҟ   
G       0  ^r 4VET]                                                                    poS A  h ? O IYOO 2	bvPtF X .	˸ f&q && "  иf3 ffi._f.]p >` 6a Ͷ !ŀ.P f."""""J ! a
#
 
 f3ۻgf+С fP s fX   QRfl f@f=  u0p fl >@  t@&?   `%Tx u!uOǿ<2{f]
 N] d `5d{PQ3 }27y4rdr
` r`f<	Dϰ4pԷx3ð4x ?+  \.QuP $@Xu@AXe$Htu
j,I4
<RVWf1.1Vtfay cyuQ<V~ V<W U   P tT `HaofP > f 6+s >upyf2>kf@J8yf0d%yOyf .> u@y &R"quj`a  a@ u
_^Z2 s Q{V_=ؾ`Ì>* Sr@" uր !8R3r%[UfQfR  r.fZfY]a /  @ wi&$)zJ )bA hI祉`
ר0: mw0%ҩۗ"d
D)(2<FP@ 
gfW`3sAq< uf,u#ǉǋp f3gf&ff=SCAF2f_U< 
`<!ۅ ]  c<w&< t'V3ɊȈCF`M  ^ t	  SQRVV<v^.
tݬ" ؋
B^Z`U  ]贉U'P Xs.V Ou0+]'k'kA fr! ## g 'kdnd뙡"Y$`u(?d'kc R%%Q	r2t"S"6s*@O   ["2ɵ"Y .63-ras\貽&D
V &DtH A 
B Gr!0rosuF. u貾趾$襾rO运sJ*KZ Sr蓿r
r<a@yoiZ2
 0
FFt NfF"߀ B@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sb߉FVFF"F
 F)tЎ r4F$
Ft+ WF P  !VPXV@"aWPR u	ZX>PRAtZX}q* 5Ӟ.:f tdu 6.f]$PMM wn }$PnP!  {   P efPff  @ fXtfUfp fSfPAafVfWg]?rddf_f^afXf[f]ge333ZrVd4Ad^;sgu` 
3 rZs M tAt<VuZrdDg}
^` VWd_^gEdTg}Z
}goE `tr	 	t}d8tW<ytu@DY
`PfUf]3
t u Ó' d.;Gt ._
u fg6$+' +k~~~~l|8 8|n 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll78x
~~p Q pp		 0`{`0q,ff$
0xx00 0 lllll  l 0|x0f 8l8vv ``0```0 @  <<f0 0  || 0p0  x8`̃ <l {8`p'  x@ |pH `a
 
|x  ?ff|ff ll bhxhb `=f> @p x p
pflxlf bf  ΀ 8l_l8` xx/p$ܱ x0  Px _ƌ2 xp``x  xa"x -7s0Qx|`` p 8l`0
O v!`lvf0 x  `rb    h!T vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
Qڑ u:`f SvN .X2[]SWQ  <t7`kY_V ; PSR,غ:3%  Z[X߭a ThAE eMA9Y.nSSK  A`( À
`3ҴqĀu N <tDlQYR"nlr8rZlr
2:6 vKlZ aA1f@|PCI01 ISA#+T DA03COMPAQꊙ 07/22/05  ?     F10_  m؎h Ћ`h+3f  n L!$F10fPfSfQfRfVfWUfUCES>c  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdff	 3ua 6e< tf3
@d>Se    g> ;f `ff3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>g t
	RC &gfXf^PVW 3W __t
r
>d_^X \ɰޯ۾ݷاб?m,c-DD(|1 8     I50  ``6~ "k!A8>8  B9 @'Yar:  @;@?i<@ &3?$	?	I!!
0T!A>q

( )))**LLH#Eo$$E~B ~B
y$$$@ $
  >""ZFYdld  #<r sM` hx"'y(PQ<R!2

	" g %8 0 pV	

$$D81 dZI 
!e$F   A4'?((DD@%)0P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInI`Fڏڍ׌߃Os\gpjځBȉymGł񂪓rݏOڕKvxmȂ튮xtԍÃ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉE십ċNԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb]㋏ - @  S   0 ` R 	i D  Q @8' 'TD ?g@dC" 
߈ P '1!!#"& p
~|u  0
Fq% p?   !  %W )  f	! ( 0^2 ʉES   /`00m) BFLXp0t  dEg!<"F ұp mgY.$`"08D(#d$A|   UP W F  >"6>p-@  ?~!BC ""!B'  /!B#b&2 //` ?   &2$-aLX'>9p1@@@a!!: ' (ـ <'Bft,0Ì<<` *0`  ?t2pC DBg ? @Ӂ00 H$@"@ 
	`0 P $&# DK8_ o & `| D~D D<@ B f<,$$0$l=   M@ ?3` B?"#!!  8@ `: 	4H 8	  6 a@)1ppp" `$!3pHBQ0`@S` P0ZT@L@\D2"##(RUY@>B&Z" Nk=bN@-A |a  %rm?  2c Q " $!2a2SNa  1$Q$$aQyH ! {HHK` xď d $+Ph` @@` 0!cc1 $2&f# `\0;@lxxpa1 
c
AZxpp!
g
T  p!rE  >>@@`)X0$x|pTT T8cCQa- : b0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{ijv+ dDs?|e0v0 a"s 6`S[!cS,t. T8$9`0pGy 4g? @ dt~>$B<' @}""" }c px%_ `vdnIi&07WP? v3$fv$d
  ]@^@.*  #2Bb"6T$-`0|p(x3 OV_@@` F0Vpq 0zuat`m|?sGXm|%o38"5U QHU' &@'a! 3?! @( !d(!3#\2b" '?1`		
	`21"`n{9$i$	$	`  "33ak' l?HzM8@0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!## DEB`@].A^! nxK)t ?` 0q!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P<ߐ  b <ې$  '  |D!  D| d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g~!}@ @Fq6pբ66@ƀy9@0ya؈  `a%,#?% p$'!G@x pwc 1$&? l@ 2?$?$?b < @$<b =$! <`0b64~
*  hH"e g * ~  <@ D=a<C$" AL`5' '-恴pnp^  ) 
?8hRF pà2q2DRD" T@""z" "g"sbn0 CF`  ||~ ނIWE`<aBzd, %}IHT! (㡬aE@AjD0p 
 .:23V!&    B5I@  `2"R`   @!  0ƀ`'|Cd p}5D (P H H  0
DP6Oeྠ  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c2q`."b4'?e +"@P,  b
WBF0L 02?$&""  0p	 x 	#`4 c8$}R S SPpP !
(#?@@DDD@"D0!c 7E u0DL|(0<>t ` >O='4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Ry<dwsw7  H 4?b2C"csyH@Qhnx<0	`Z ̀7( (`2)vr&^?0JbW8}l>/&23
b21#n0  !$ #L`,!3p$?Aq%$"h| "  1  A  } {   & <"rV&#0 I  w81 c QQR0GS"PC 8`_A a ˀ4 usn# 8ٳBY 
 Pw`]IY   ƀ0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>ǒ)jP|D52D"DvDTDD6 # a|b蠤,  1p#\  7ajė=  4a8	  O6 P>Tڅ  ptL D@~@Bf$,892k&arg@eP 1 WpxPX	 ^x! 3"&,0@ؼJD% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`	6U0` . `09H~ ց 	 d~@*H  ~K'6cNCc48x F?~!}BC  #" te `QP060o! = 8!` "***" /"$'$&*7"$"? CJ0``]0?~$BdB  a B
BB~15,"&_D$(-jB ,!.	,HO
 =I H<H$H$_I$=@ @v 4R$ze bUS R# P|7 8y0 ;6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z  $D$= *XGGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? ? Wpw 0,0  ""bp $ & "  q?2@G%
i-_ n?F:@ e$ a  ⠼@
#<]](00]V?$P?			?R" N8S8

 ek| 0@	~! y 	 	 ! o>"W"	& ">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDṪ C
$>?ق  '$!$34, g A#A ;<8`hOu `&#f!b6@2~Z*\*jI0 Bn5	G x RRptF H0	    	  a |$# '!b[aaap <2zasR0A: <  B F>lxPXHL0F`Cug@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs"`7 `C  `rL(  fMQp~" ">a}>>b 2 "&"cb@	"00P G  A` xz #  Vj_@` <1p0?3?S"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(0evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)g$ -PQ@ 2!;VR!q # ~ j   "?**~*B  h b~B$fiBFD?0@ @`@.ADY`M`~  I2R2RR 0Bb.	4d0.t }""p bB o?~b
(LA%LɧgUE``AC}}8@Tl@l$5?b5d >qcQ"tmdax{R4䣄	(	)	) ( )H	p ^c 5] 1 axA#?~"! "2&4?60ba0"` "{D1 X8|@ @0 P` !bF! ~°?(HD>!"? |?" p?.a ee   	 `p13_"fd Bi|"@Acp>@$	,	(	88(2l"FfV@@`'$pzBp03
D(zo

@ 
{t~<$4 7 a  p ߬}#@B"4&0PPP``? ) )?)  ?2"/y1ocI{P?pP	|@   t   uUp cuѪ`  `	 `0 ..1S.1mp 1  [<u.1 b`uV8r
8s8t>8t: t3-v(8r*<rw.1` a2~P 膅
SP!bRV躿^Zu
`R\ts 2ƃ G
a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P o VPP t	| tL^fat PvwDXMCÀt	F¹. u 2 󥪪4.>1u . 2 13 `.1&1 u2CQ2P Y*2Ȱ&P a RDr
.1.1PSR  && Z[X ` ?Op@tp
oo.61+FF!.WtOT_G-p
QR.61ʊƳP ZY[X  "2S2OsP2 sP
XÃ <r<0 <rp1@1  1.&@G0u'2!13-!a01.>1P20ዿX2$CFAPwQRW ((_ZYX. 2.9 t.1BA	#+D<u<RaN߰<P}<S<0<<<<<`< T{<@<.>1 t3@ .1G.11O#0.1.1p`X@Y 0..1.10;Pp2  X:XUFN
Nu	F] S f
 [ SVF
u038ȋ^V}`WFr;Vwr;FvN3Җ^ d  WV>	 Mj
> tj6h1jF_xd&  hEu>uIWo1xd% = ۘ?g	@v	}#VZ	$s
y|
=JAfbfff_bNjdldm@fw>dQjut$Q1j`	j	jd	)	vA	
WLRaUf	+b	D@Īx
E
E#C
5ɢHx
R'BSF "wU~QjdېFB b,1-,J
g*i*s0j|0
b~V}"Q4y$Uz&&"Ux6(2{R3md**i1h V
	,GQ
zdt;j9?U&?"@z|=qc4jQd$g$0h  nC  tAt=dtfh jnd$1!q_tfhLbI~q >tS8ft3 tE>"e tjh"efjhIư	> :%j hd+1t2f tffhQwg t+Mg *$Ef3f
Ǎ~f PFPh@Uhg"N ![Qh!3F``H譁8=#2hleh- leYod V0.5&	hfbƀ)BF&ththȱ	tdAH6dkV6dtFBhb7FP	7@ ݄ojh!f\
	 hfhfB(4YIy/Sh-dV-dЁO^05%h01!;4O VEo*hmKh$
$D@O	QD	,^_ 2FF$g^ F&_<
uI) u&*_&88gtFFP9 ~1FOuÀыٹ F FIuF)1 F*+FVh+;u;uàh% ;Fu	;V@áhG2@A99h% 
Ð;L*	
 WP}
@Ffj hhSC'-y wf f0h0 &b&zdjLfP ~@[j`Pq
1j F{Ps`?F`P¤"V=ut_ V (#GF| u02b|Za h &( F GP		FNuFG0?6S 
yO+HF_ #dr! (wFr]vq2 1p j1yC
>Ҿ'I*bf?
3@6#B_r	v	$Ƭ2&yd% 1Wyd oȋZU

9gaFppuq-&xd53q?3ȉJ+#z/zdxazb`r	@	2&b% +1b1bj_Rv3p%2jd%  j[d1jAT 	a}NF2`h~ 3djD
<k E

C @B	H 	Na(g3l1 jiRB&jSR

 U2@Xdj~%&ddKr
x
x#)t5f^ @  c
f&dFt1d@t#uyhrP%zb>)&S1{*ƣ 0_kdjTʡ2B(1Bd
w_&w@p9 +@Oqq=_& &O g {s 8ۣQW Q8g1L
b {fPsid t}!JH2S I>(@@b !Ћ^PˑFh^F  ^F&F~
r$1e?&e &8f &de^ЖPh @ ngN@ d"e@  vf# rg
a/Ѳ|@pV`E  p  V6^aF@t+tde Z,tT@-uN&ee _8f .9ʀt"Pt 탐݁ 
+%@@6
		! t:8O
deuUԲ+2@_& eW  !gd !r΀&dc赳w[ootD@9".QF~qY0`   ߀&dw.j `j ;3
vB +w#rsFV
-_B&g(&g &g|5& +&^C!&.&Ƈgd ry@LfhJ`j0:MB>ndxK@>4f&5fFVDA6d `th f!le	s$WU$ 
!-rvؓА)u14f 5fOF)@tcyZj$	#>jgSZ	Sށ 4f$ <w u @<@/u""r=`" 1 ey`bNp94aL(kva2]fj0 
t%rԋF^Nr'~#tp  u^    % F+ p )^  ~u +ËFVVF6Ƃ6~ r~t` t uF݈0fv
0V׶32,pIu~quSI]][t
Ӂ
 ^^p޸L~  f# FB F~P|v^ K}F NFFV~ NHt@HtcH P )onA-@h0p6^F&? u/dv萶A8>Be|mhHdΐ2"bcV;3cv`fcm`
NNF`v膑$F8hF꿉FPjRh_S^/GFPv4FhFmP?dbP;ad9!Z`d`&@0c16`b`~2|FtFr(QWw^
4~`4	b-2 _`-pn+FV_FQC94%~ t;F4F0
z u WV~vNO^?>S
A0@
^_C
"j(c
l

[t ,md(|WV?vԋNsO4D .HAA~(|W~FIt_~w@u"2F#}HFB^F&W} T
 
.rAPU!u@## KVDiaL
%%		 	FW*Pg	}`	
g<d-UWVv}<~P F
&GFq&'h*V~ʋv!^PFGIub: ^&^&8t #^^}۲h!#ù
 0GF N% }p,-Ar  ~s԰ NFN+;u0g03FppAFC&PfSpfF ~0gЋߥsG^AaQFp ~
vЂ@x|r
CVV,GV~^&F]Ia&a8Q8F~Q2xd%x"*>R⻪I"k*bf?N33#1!
= r	v	$
a2`% 592_
oP_#_j`R#	2&b% XRo!2jd% Rjd1ldjAROp 	aR/! (!Q023djD"kE
*	C
*@Hp*

Ns#ST
	 U4	@g
3l1ܠ jiQT,py~rWyEpzAp!xx$Q2
7
{2
R1
*C Gh R0
	W&dWkdRfa1f   lefṿ	 f   th _6dmo؃`2`K $ d-dF?rC!6Hc3へ0㯾 Vd@4JzFRPa1SBS0XB33~Q0u@S fߑO> j6hLjFxd SLe6>bIc?@#xd,(T〯 ¢$jy+"9ʲoT3EXA	}j`fbf	ff؃#/fjdPXaA@`VѧA \Ra$i@bDxUE$
C4
?
g[2
H"_ NUajdB %q'S|pF "4łgPL2ip+~0PvqpL	\YA	x6s64F"ѱ }@=jh!_]b݀NWVv1ˋދ~ &F<t<w
b3rtF*;b}7a~y~tF&8tFu|t<r21DVp^u	A(|NÐ ~Pfh#  >0pF;rF f?* F  F*N*ȁ vFܾP0@Bv0L
u+$g^F  FoOu߈E	f4g &4gvzdthgq0{@  &h22`% u"h$<2h%h1hu8q= +ɉN3h33 Љ  auh$<u~h% bPu&
u]f2 % D0	3u 
uB
 )
u/,Au#aah%FOr $g%g&g 'g(g	)g*g+g
,g-g.g/g0g1g2gXALǶ f^3 f ʨ9`ujvRPjm- `FB¿~2|ظ1~ĀƿF  p ~ uFlem
 f jtWQV `FRvQwF@ b*J*p
NvQϋWV1nFFP
|Fطf- ׾7h "m
'F܊f @M鉏 F֊ft@ t؉FjRvvQzh 0-~St` suP0M2mu됿hLh Ќh FފfPqrFof juIu:=F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌvƹڀ^؊RQPƆ҂0[\@p4 'PO1aPjo?+*`
- e)@@hО% /NVZpn |\\p\<\2d$S0   -z0vQ$j)Qf|Pr 
C@eQ@huvfp@e҉)"*- t*-} t9K4!1)3q$RFa2|OC*OboLF m40#"7g
1[(0  ~GEtӭt/ 3|
/@+FV+PR1wz6pd qa"$2u%`zdhˌب kbb1jLFPj)"#2#"#AD/]LDE WV3 W^&@RFG[|P38k6W 2b R&/ FWb71y` r
7<"JW>d fe!bb6 ` &=  t@M[_ Ft 0 
P筺"$g#-P//

	
A@yu	( LpĴ &&TVP{S~ t'jPFI . t/ ?u#'jfyq0Ut= tA:? >u
e&8f"e28f% P-8f  t&e 1`ul À&l IgdHgfh6f0{fzfKfhkePb b!bdUUkeQu_[h hJP~h Zcp:zr@juBzh^[NAZ4R 	'"			

 
-		$ 	̢	r	IB		"b`F&? t5(u%&|Rup )u&DPƋV@0FF"cxfjfh 
 fh `  	 {    Dq~  A u р&jd E B>`)tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  -P Q   8>ۋ  &9w&EU 6`  VV 6?Dˠ   9~ߡ H b ;p^! 
f
>~v KĀv&@u?PM{`^; vĴ 3fojthL <Њp `  "g pvV>B   vwV*rF^ ɀCP% 
Pp h
> h  RaNF
+F@pF!vvo 	F`ߋNFm@ hbj a^0CFPNQ=`*Pđ`VW  p 3_^e9 #` @SᄊF~`
F`A6@F.
%
;F|!% F@P!]!Vgvܑm`/NP`rFDt&E@A0#FlAQ@Pu< ͷt (F7 PF@5
 f `(*	 yBఊub~v*VsAƐӐ2xƊ*} ufU  Vĭn'] ᚃ> t`ur3NߎFّ\? ]NZ&8tG[ vN! ؉^GF
&Ft;^ G 3+tp
뎐V^% = @@A3t`ߋ@!A;wⰀ>
 u31&A *;t{r1A 
*FD0F
tҕ t" `f[p0;
V=O`2P.B@O?Vu	.SEմHDa!E'(E zrVu`5 3
l|	#5d7RP3>>Q XZ~38tC8 u31~^
AF:G
uɋN3~(~ ug j ? F;|;pUD  fUVNVv<%tF` u DD^ù
0NÈ ux0+b1WQPyWVFX3^tQrJ;v~ F^F&uᗋF$=W\qQb]R}  P+э8sdvva!V0N&8 uN = tp&ƹ@*m 0At2߱_mf6 !
`f+KIQ@kqlCTN`_
ʐ kj }##v`j&F3v~Bv0Q&ğ o0b;~ANuǋv| 0dFuA  
`6fP0^V& c{PQ  F} ~ ~
~h3ҋ P{W t4hPǰvke'Pq 	ptGW5o"p 렆j_9Fu
q_sPK0 vv#5+PF7V 00pKvD"F9F}+F- P@!b' ɒqhFF`%z*"K nT\QPEP)DPA jEP:! fh p39> ~jy/0 *9>/u	A
@0
A/\&_76%'@2)
Ʒ
G;|2*& P苴 c`8(^F
A
j Qj V@VRP=^AQda*'P? p9<n@]c E +F+FVa#
0UcShpbIg 0aDPodQ虡HyQ	5Q`,+F+Ѡ`M*'2 RV 3Rg@D=PD=ӁF3@**A;?}Rvs`'V6ra=qyg*@F;vwPT4C
sR14+

uK#aQCPYedD&A84	PeVs輡VP!r~&-24hQRptYAS;}`=y#DȰdf&D&T030`~
м  q &Fި@u[] ᐡFtdF;ƺ@Ɛ]q<vN b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~{ $	;F3F	_F	} t~0V=g~P龐tOC tG\'F
t/* F T9F}\LF ;F~AZM
?~~2G+F50%&L
q DFF 0W  `IϠf@`	PXhf@PwF^^UEAgTe`X2s|Pѹxb<FA@ŀ[0H&v7QvFvFꎐՍ\Pɒ #R@~ɫU 3'tsF+FJFH鿈fh iR( tT,T4v/ .9~4aFO6,+F!}=pu.tpSq &OC@ +σQ._+ǀ
!0|ctj[|Qu

FDB.=Q /j]> Ln_W0L# ' ORCA& !!pa^2#$QBC}P fJgpL@>JgLgj qWw 
Ht8-t-9t- 	t "fo 	`!QF~ tfFfJgF  F
Pj   v
u}i1Aj >PHPV`
Ϲ!&wc¯FtB$P
QиN	VV2ٓ~F
t!@D% QD
莡Q
VQ6 B tDu遌Ǡ
!_ط!bG C] `D]Pk*. H!MbB되9>u	 rdP=`Gg	%R4O1miDu(+Huu @uqt j	j/fh	m<	"	PV^FPqf~
 t

>axQEPzU@ ]FY m DVVjvvұ{xX s6G ]3?#PS0N02XPr~CwWF0@UJP1qE~
%G jR[807+$ }p  9]tl ##J/E=/`J/F_FP9 \ dpg
p; ;NNNQP[ @C7 򠽋= K = ;  -Pp-߄--xАW^p'Fj  k >g`{ Pi;v1!;vFPVW>FP~FPG;~~P1% - D- *{-ࠁ#- " e= Pk'K-
|5. G@6- ;sFc?atU tP` cFa~9Fu
VVIVF]v9vu@PNPN  PNNRF ~9~};V 9vu< u}N0빋v T|` 3P Ppo & !VN;
u_逐xA^F;~maiXS `
$~Du6g| b;|qT/QN;v}O;6VQ9~ uFApL怰9v|GI0Đ0%9F| ~A^&+^& 'FK'302F u!ihj@vVt ;tt D@gx3|f4Whyl
 _rz/~[I>mFWV  Gc 4f td@ U@ l t5f
|t*ATD\[u0}Y;F~ ZpӁrջN@uOp0
DK*=Np>le u)>f tl>th tt >6d t|d8 yhPb?0 Whp.u"jhbh`ݠ
j(hfh0` Z` : `h-dh` `$ `} `m#`a裚%0 fB"	Z^ f% :fs% -dc%	 dS%
 $dC% d3#+(4`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhНpwt1rt߀DODpU*䊇>AvuA*HWvAPVt0<@p& }55J4465245r659h.M@Eۣ@ jpPVCpWVh
	 !V3j hD	~DXր`HtHt#h !    C wt^ f	$ޤF HtHtHHt$" x@ $Ѻ&&G<P jh	G_+P舐X
_G>7x@n ^aGP0v&߀ ~RrjV6 fP)3P Ы>X F`~|֢"®s}vI@x	&8 tr
9GPu   >p~q9	uarf   ^f~ t  |֊FÑ!	eM?	L0#	Kac{ 	3$賥0(`(hOwpa^p3&~/ߋtC&  v&8 u*C;^|5ckF^P9Pg`^? tvN~}"v`<1
ރ~ u0gDFG&9 uԉ~MWRr0~F Z= ?-
 - Ү<5 1 ;uJ< tCBwtZPU-
tKŽtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@F	 f0 % wt" uNj pѲF  B u
gށMN3~*^}
7ފ 8&8u	F;|`,Bdn
meP $
nPڋ P\PC 
Cc!
d$  *8fudg"^u Q/	tP3`0F |n FPf@
t)fo3fn @H~pfh j hah` 4z$u @3l3 1K`F*A;Ht5= t	d@ &d鵫 ڑ.dQu鉀&
:	@
ʠ
 &
&
hhN
h ?AA7B 
@
@ -*

@5q&
 3/F! "&d&ԟd gjg!B"  `FP~H| AKN
3a$\'"V%aC:GBHF`[^ ZSa0$ƍ&Í],3F
46 x$dh ej(j 9
P8
PPfsVbW&*`)@&` ad t&<
} <G)뀖 x
HQ %'@q`
! Oph?ej  %+cbN0ff̠3	諠`%  Piр`RB/
?
$*H0/$&40/04RTRf"`RVdsDp%W
$
aH*=	- I- 9t7-k
 wqrMt%
- Ktq-Mtr`| MYnp= d.ě"0,2@0`  8&`s0'Rz!"Ր,20`  0PXu}/1V hL_h STN  9YۂYu݂Yހ
Y&"0Zd a=	_[Q["
@4 |
U!@ 𐡾`d`da0y@ Vfh0/h y Pc@t&
 
@ ACCC**!#!
@d`d`
ސ޾
r4(! + (#+-+tp*tcmKt
-o tu] p&3& tGђv 1vhh
h P!wu
j8%AW&A܏
-C@#'&$'a'a{Ðjg؁ ڰ @&
)3bPf 
0>{+>>G~>d'>n!>/>f'>< Ћ5P$pD D:E4Q89JR4"" :L%9
5Bδ,hh V2^Du+! 5 31;utX&`\S7AA@A@tR_!P!_!
@>"aO? 6`L.ࡠAL&`"a~~<!Q"Q Q*|3ɻm &ArhOE@Qhp@	X^rQUUtD33,i
m; YK?"amrFv!
orMoVv0%/@tx$P!D$$`
P#wBf~hx0%YAǁ6K=,D=H=yM"a;}Ա;
fhZ/ " [BGb %^
t
]
ct,W*@t>tq *``(@a@1)@4AE$aŏm>ƏxCQ/ M7# ғ,$ $ T0@0Qp@
%@U$R~2U%62`$aҟlB	%avuv&UP74	b
A
 ꫘058$}   	 NbvʥإG H1p  AЗ1!@] ]0%a0u%a}b"XWab 눋$a 2߁ 1 5r1p "(9@( f fxdEWfh  _е
fxdf$a&ydN&._.@S56P6e!7>d>8FFj% 9N$Ny 9@#fdfAzdu
nvu-dum$uuu	V@V ,ǈ"]|roh֤2;voʋF8FPVh@PwMv
/WVO 
1!*a ^HtHtt-L7(!B+ @3!!b?>
<ĶԪP3d %.S 9@E4'`eNTG:l΢tg@C
J
nbs( ,f+fF@ ؀  F䎰F}0FΰFFI.NnD>== p ƿ -  -tRp   -ݵ -*t:-`ս {=+-B `-j@Pt}qx$Ht/Ht:HC 6 Pۢ c( !"!13 Rgc" 'ހA
Fy
t)j UPTPfsV,ttp? ;Ґ|a&yBY!Fp *HFL~* f fFvfvvFPvސ5Fpu63F *~%v슅a _:uFG;ǏF :a~ t
&x |xP ~@W&p! U p!qq t&AÃ@̌?"Ht)3Ã?@A ~pr}b|ɀ&X qȐV>*a ucuHj 
&3v0 R8fw(aff.af a UN n 9Fh븨Dעo R
(a8fᠫ3`8-9t- 	t FY`r
  *OXfjj a
#5	1	u.#JN1uh Ɛ>a tu!fh  PZ	-NVR>N `6
Lh45^PhjB6a3aa& ׊N  F |b rPpu
}ScA_ >p#u>p\t&el6*a ] 륃h`te3a10G
>.*u	>n 0!jj2r3t^;73Be'k?JP t'${80:2R%4;~44Z`b
h j@p~@@FA!F@[$
k$24pQ*tS?=<=5
5
`Kh@a	@Ba	 fh+rD-qpNp$Qې$#;$ %./Pa"eaada8f`oPeq ) d%  = $ͿN
fg1 [OҠ2 SRb
b
Nc
nrՒ
 }Zg
 h
P 0

 Gwϊ֢A] Dt,-
t%-.t,-	 tE-
tYt- t/PC Dɣ*a:B~B/ _p}}  soU&V9fteu& r9ft+u
q0t`]8fU@UU  -Ǿ@ut;>}`  Pr־%h	pjtXя6 ]HtHst `t' wQ houͨ
^_  WV3ɀ> N3Br]Zґ@FPWnr~Pr
NpDt  ^& Q _FV^tF&?ud,,,,,,,p+,,.>uh hmhߪE h 6 j?h~
Bޣ"?@t) 365?P@;@)}F~
rwF 
hl΢	
J=
Z 5#W<B6f
 ~Ĳf4g v3ɉNv~FV
tut9v~O|܉~*Pӈf b^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|\bpfbfff}&XS  
bt&
]S
 P@Jt	ŕt`p` ^3

tF^&F!u	 |03$NoF%@
{EP2}pnGW^rF*6+= 0=a -tX-  - 9B m= M - t!Eh-|@ ߛ Or= E.LftW/ /  p- 2&
b% +11b bb@ 3 ֐j5B jh
@鸾E
] C
@
@
/ /  (YP)@ wj}Q'3
^'G`hoh5؎GS.bAc bh, b7b$ a
0o&
c
]Q 
@DM
F@f 
fh0V" !B
p.pfh,-`*+() &'h%f0b\rd t
Nװd Ǫfu
P0  O hE{ `F<tF $oh"B} by_F -FC|ߊFoàbGVAװ
bba!J1&PFۯ&J`lLH f`OeO KD]R]B
3HT6P3
	^Ċ90S
BE

ZH
>U㮣YF \X_	R[\t
R22C `>JT
Be5T
phVhhT[j&U%l$"6U5n42pA_b*5pz4T@p(PF
ErYD
B/R*-  ߁ 30+ +1VbR	UvTR!d4,Bh9ChLBhBh--
|- h
- Kt Nx0`igg`g@]VC]ֿ DTdt&w> =,2pxf ^ ab AB  !"  A- 2& mkdt d@T;ĀD+-@j|)"̉]IC u@sڀ## Zp$(A@u0-j'z b| wfC|=Ceq!֣W?jd	fjdf0dpp@t! !xx d?t&aUCADPJt &hFaӎ&? t
&
~@#@
j
C	   
DTCB|@jdzQ~@t&fh[й#!$@-n~fhBh 
76 2:tfh<R:;h9P1^12"vA?@h>@v`	DC}dhBgWV4f$ < u*@aa@<@u2e03*@ut Ƿ;>@`  :r4 h"h4Jt1>66b̕ uU ` Dt,-
t%-.t,-	 tE-
tY- Ht~a- t/^C Dpţb: ~ 3 	{}P  ۠V<*%@(d c` = PHt
`q j  r jǾF@uf4;F~  0كrջN@uO2ph^hٽWV`FWk0
~rvOϑdet
1ÿ &.H.}Hdet &&dk9$N & Mǀs&PK@d%f%o%c%6rh0h0Qo 'Fs"b`& *䣿bPeA u$wBL7 h^shJ4L9  t~@ r` zp dP j`,bzp0u.&rzjz`&7"q޶F0#0000\00010H0VfvfhI?
 谇Jru oh eF`e:tF&߀<:u-FF
*0N&$   
u23؀C7 ~ uF	 F
 @L
 
 <  nC
v`
A
jq<\^P[h"Ƞ
? 	W~ `~ tghv&~ tDש O=肿=u5O 蔆`\
`
 ^3 FPPP 
FF9Fr= T% -
 0v v sd ƨu`= wtʐˋ~FP.abc¬y~ ~ t 4FPbaz    R~ F  : .E "  
Q p~dz߃t' 8ƂOFZIZ#3^ \\zAhV.tCq u^ GCauK  K .g"PzWa1FI Nr@~u0G_ W    I @F柁qFV!F^`=uFlv2N'j22g+S@]WV65Khh謷y*yS vyu}\tyH4H-H4HSH&VPgHy712I&cFIP9Az"ClIDzPza
"zj &z<f+fF@ @z  ^\yFV^KFP6ߦb> Lv3+Q OY  l`- t$ fFf~ sA,Guhh6ܠd fQVbڙRPSQfXfYf3fff0
fvMF fh  bU&ݶ 1g Fv?h HF_QPzp_d Pq!w2T{"!T]DaڑyyE  p 4  V6ErNq0	% 6LbD6 g\ 6g|<`y
誣]aß3Ð8  MHz` KB`SIMPLO  MOTOROLA  HP  1.23Adrivelock   B Computer Setup  <F1=Help> File`ystem Information  Display siSave to floppyco?nfigur diskette Restor?e fromE(defaults.
  Ign2hanges and exit EP  s! witho}uaving
o Securit@Administ or passwor:5Cte a/"Power-OnWGp DevicedeDgbD$L $s mart Card%G
supportTPM Embedde&E
tad!'eA'et*Cac',(0sd*authentic+
credal Auto2ceTo?ols Ba`/0Calib( (`'lectb HDDP:lf-T2 op8s Activ zO Mem
WChe? r s ; ll=mb  	>>uA(AAdvanceaL4uagC lD7  of gray6field Boow1bD.E.Pres1>y keyQH`I ue F10=
, ESC=Cl @9RAcc{ep/=YesSNo D, Ajo$r=MN AW  Us|Sarrow
 o highl@ *he appropriQmeOnu iZKp"<ENTER> PXbegi)WK%#.followM%[&:fc-> @KSPACE = NexR3c-BACK@viop"FgphTABE3iSHIFT+0&*DlF2@&10`
[J #'9 Er This60cann)bmU;d An e oc^@ wh0t6c. qde 0x01 eondApGu@ploHcCrequi@yy<`d~kba@%mu0C
movP:  z e4k/MEU )hQ1&`0jll//+2SDc leOs}u06ssfulManuZ rr  N0
d:Pr9o utypspeItepp+CacVize (L1/L2)SQ ROM ydd famiaseP8l nu|pi 	VideovisbKeybooFr06PverDeYI1<Z2e3Bbg41qa<ownPhip<(TdG
W
O3O	*	0jafХdai5El%BSNZC*D$`1
2
3L	ME
C

V


4TV
o
Do
So  B: AD.   %FPA2d1!J#biFaӰ7WalRX0s&1&H} Addline4 AlXn.eFdWarn: rk TlIl0po  zs᧦Trea /4, lef ea w0abLppr A: 
de` +waqttҰ_ )u ր9rnInv OP
)!	:%A you ͔ {wa@|to  :?  aiI  po`b+-c(Quick`n22 [(Cvre@s3 (S.M.A.R.T.) 1EP1pex03im@s@): 3A0¾# g¶30%v}}`t y hao#0#upr4:1't4	f-UnknLkp{ilWR!mServRceaPS)doџt7`?a}ribp	: `exP9 'bG H  Oyl New =Vfy nY7Enc8Off IO ɥA L0a66#%AKroE   p dV
Ad1ݰU @ҭ5O<cpcaus7Ԁp@=AH"h` A&Opower-.AS΁Qa?U= loss  (dYAhcou  nlcof aQgoH04)ev`ۢ?[YDocHishR`e#d?!0f]Dddi1aly JJe HP`"UTool Cr.%oF8IL`ˣ Bk! g Uмn qHpm`@jtWASN !arv0	s /UcwcO֚P2"Onj* `e:Z%%% F@д%԰#Dn -f 0 TndĠfӰunuR?*z$n)tart8BQK`fra Par1yNsza $mediaaAl Mmk ,n L?AN CD-Ґ  2yڤ B@|U	3
 aGbou!u5}hR ubZa$ b"USERMAST {@{rp@anQP<ccAU@Vq!keep iaKeph#ys0GP?pPjh 9mpbr. IC9A҇@
,RnR UbYunP AP-i`IOxOAutoQQcE@d v\8(82?#O N+>
Q[m |Ql!F,aur`Bt^2thR0sqw` k AedplPerpQMdpaff@a+bdata,ޠ_ssib@oma8MmigiD!V IsqZЈlrmmO @1p W0u{l, orepla]@y3r >r/*  Ӡ{4p|Zt~,ÓoHA= Wy 'bt} me`1r,@Mh`*0pwib0ty. IfdoմɄw8`ESC1v.!
ԃ V 2typ¥'>'RqQAQF10"@q"rm@,bӧp`zt+  E$ M@iBjQ  Ort:U ay OЋX DCgDLb (left/hUSBf t 1HэbSu K wZipoFir ޢ`oࡐFth ifp Sixa h ENhASwap Fn/Ctrls KԕAU.Sܐslegac@kѨ``7)n0=2Іr@pry Vo  d NTSC`AL -JF -Mqat 
Bid0E?PP ECPd2Asize 32 MB 64a F@pAlwaypnPPi0AC ~gWWAN D RadikBlueth/rS;chH1A ATg@q !`P!t EF h*, ..2)+)c-{-&3Ebn8)e 1҂23TokRHp
kP	M3Uniqu/e Idaf (e   *tu    S3 MCalibPaᆏ6NsСtPS D LA.Zb 0B[ H PyO
ELk MEU k'g'MRqN/G/U[:P1 :s C g . N`% ]/Cle2 zc 1 dik-d3	ps
H

,
* A @5>M(o!ylsSp   hnology'tFYadapDPXE ?RPL Ex#➟Popupz(  0 10  U2@ 3 4 5 6@7AF1=2z5 15`@ 3 "M.B o_uchpa`P5SNon BIOS DMAr nsfers <F1=Hilfe>@P^id[in؂\Onz'eigfpeicQv  -Kgu4aob9Vcwie@z nLvE7einun	JƜ-s
kz
..ignepd*nt neh7/%Set@%SRheitsfunk %ntoa u
z naDlt-KuO] Gertes/-$-ID@ Ot 7	Usttz !ր0pѕz#  beim /st(
nBg!@M@ r5nHsvorrq##7..zurck@z90
B .p,!f_g{ms>Ui0'ExGAkkukeK tBsgewhl@DD-S/elbs`sôItivS9#LtIpr 3g d0: tppllTL
PZ`OS
@ PEryw :%SpraQ 1a;n!4:#U"gran Feldsrt-O&O9!86,")e SePMbqTa@0, usm p_3fahBj=A, ESC=Abb!#`qWBkzeX!TJasN0\, Ja	=Meh`m VeZ
zpMark"`s@{!*!'oMenS% d?Pfeilt!
^dQgab	e2RmOq>ko?9 cs.	fcolj
Bn 
sg:-{> r LeGQ = Nch A\pd<-RBchritt-`VowA(Tabul!fs+ Holl2+gedx F2@
38@= {gy E3schlrL@iPK kan<~Lt we Y!eiffMgy16P=z`?rgetrPn.Dc  01 L@`fi6t B kqcQFY+<W\selomvoMrB]er0ilxXWqDeskUe-KsBhmu  f 3asbzw.2Mobih`bgptz%.`Qz qh4Bi///"2f!
}[KAlgrѫ ab	chlos`F-Mll ProzVyprtt` wig!6R0a"Ca`-i-Gre (L1/L2 kkapazit OMPum"F7amik Sp; umm Grafik-Rs@Q Bz]r-Con "
A  °a?7J	b31O 2O 3O 4dqV si0 H>(F  `	o	o
@o1
L
2a7SekrET*@L$ƍ%'$b-!3Kc(1  WalkAZeros-T<One) EdqA`PnO`+: bX7 stqbislwnKp  ZEucQN-/WB _leQb s Atei#CP0&IyLp`ak A:nfC6
lW$g	e`KR/+Pglp%ɏ̄5 L  	/  M<0$wirkQh" vQM?`3, daᱭ
l^iewQPocpFLˤ01 ( anH12 (UWmfafdIGc$fhrxdauP(Min.): 30ZБadS`@0% 0cgt59wuwm HoPuy p4%ubr`"w: ؑH	ԑUnbeaaMTHxC52'rvo-L5.
32@lhafAttribu0FIAD 2u"LS.M.A.R.T.˒XX.Ms K`kwp #eus~1L Dea  JaQ`eD/t Falgeb e
U	ңBU5Ip dminIoz Dur1@`'@`|  m	g1i@eFN*1sgd,E.@"< ttifiz eq s{0yrt.@s Zu10D0LzO 9p袓enlr@~.Ajb s0DQ!np'PlsAviceTa s ,ܠF0$0@ h`L$pga|F	 :	9 JZtfa@npW{Um Fun)<S7, m3e\Wn HP{tectToolsP=c^ty ManagпU!o-- jc}- k QuickLockSubndFr#q\M #"e$bi sϢnch?utz  f`_-?1dԨ@imd`& "+a A)N+ *W"$B>#, lp$meh1A #I Ne n>"o3f`ot-Parpen}ґ:-1a$P
mCD-ԏƘDM#@Q:!n@C38mĎ"Orive(F0vpl!Q ;b=ځLs E-C?\s m pW|بunbralObar.ēItT
gd,rbew?BEs`Va2,0f p|b"Ea E`'1.J, ҃p0\',  0@2QIj=n6QzւO @BegriffЪd"kau'tomMRu @Q87V7;ohl;> A iIi {@qt?^!Xʗf 
VA'@!!b!amU"Gn O`P o"ep e)pYaf{#Oz`uA58ae<s2z:߁n	S.)sa`uN(}Es%  oh a@c%C Rp `˂r+IqИ  lurn3whE q. Esdratempf/	 d?1zuqOQdz.  A@ @@(R7 .p`r&ѽ2  ⲇ Q7 b-B n rap tAdant`Whٷj @QEsc-a&Llɠ>mQ kW!'p'p`\ F1A0 esh:
x*fPg gCcf sqD } mA@MMuBay&m  AΓ)bBtg0
k -ET`(links)tUSB-b#-2؆ƢSu 1Zip 1 2@345 6@7ʀ89 QFn/Strg!Pt bedEaCГ (USAf-ZePcB`iebss¦unabhng`  InGrafik-Contr aPrimSek% Video-qϧrntBidireal GrPus Lfa`ipCЯtzbB
d}r WWAN-GfӁLBluetooth9UnTb/a Egpa!Agg	r` ?',*0(o@)Bu/Ep@t 1P2ȏ397ToqTRc C?!"svx`a`13IPkbovH AkkuP  @Rt   x a  Kalibb  Mak aO  N連:iuala   O  fm   O DO,t O.Trat-?6 . .O .L`b4obi sp9 cOO5"R 0	EgnPOOf`.[rO 1 :. ΀% ]abblo(2Entl ho30PȀ
m* 2a
 GS -2'su uĠg`RaGdapaABPmB`z}ExpA-!-Popup ( .) WedauQ0d2 (Z   Ke`~BIOS-DMA-Dab@߀EAComp0ropstn <F1=Hjlp> Dvoplys!VisCne Gtil` <!konf0[GendзfraMz@PSrU
Jgnorđndr oP(fslaur  ub,At gBOtFnek@+hed Administoradsko KL aodA7 for'·`hEd`je-iq		+	*
J	S}m -kort	Godкdels&f 7`do`|_dbyggGOds -&28	 Nu@060fa@ksMl2 Uc  DBg
s)9"IkA\HF% Ba.AX p b"d`valgte b&HDD-selv4p^tPr Huko QAtgrol. inRҐrQҽh OGH omv	IBr/~ Avancq Sprog Vˑl1?s mo2nedtPt/ felOC4+'/#5l5!Tryk pP7 tas<G0=tZOP`=A, ESC=AnnuaFs!3={JaNej "΂J, AR=MGb Brug ps
NA`RP7xe  releP %menup(,1Wt<E?NTER> /qec>A)et.tafpr'f!f7: -> e!& MELLEMRUM = cNlA<-TILBAGErTAB&2$wKIFT+0+tF2@	:*@= Acce хh0!hk>{sfej 8A3!ku1i$0gs 2dodQ)!FF1ng. Fg01BRnoVD-p% qpla`9G!kwrv vek`EnJJ
i dРd!?sP fKlyMs`Èn#/MEUqoO5{ bp* uve=tzbrud2JI,nemfB J@`  Prc cor-typ hBigpH  ztr`7Crcache (L1/L2@HVROM-datoౠ familie'i;AWdeo#f0pd@s8:@Xr-c^]D-ba s@i 9e2o`%3o&4Zƻapt-ta`oej1("Wat!)	O3OWEw @ex{%IsrP4E$ TyPyC۹%xy lydes!Bmis 0'bvD1I'j`e0jeܶ var0: 1DB! se  alt@P2[holda po Pqt`/Lb Bb-Bdduw5,pr $Pk
kEuGrBA:tTUETfDF%v`Ugyldig/
t-  nGgivuİ2,vi avh٦,? i#քK?@ $1 (Hurr P)% Omf`) sl(`{ (): 3Q0˄2j  `1~x0% frpudZ44b2@DR  	cq: KuB+B"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5pyCD@F8Ny  Be@}fwt nDeae Fra@l  !e@+ń4P@R@{	s0F C		ƈ4D 
&KE  beviвB7 9Ё!Cfdes, f.. <r#amG261 PoR.RVuAj@me+tabWata. Du bu$AM flAX:Ը vicehCa D[G @ߒ[&?Ɠr !,ci HP tectToolo9"jK Quisckpau`'LsQmP? Skrp!0rKvt%#k|qX)/sa1-$$ Hvisat 0`w@x6r,
di ubilK2;+1ol p@frard )x Qlash-@$PR@Cd-rom-@ V@ôB Ho4C:"eAauϱ6!hv1,< YD!.  
bPBRUGER-t@OVEDADGANGSKODEN,R3q\0MU alug:,s  n bf  ned op`JaP)edS t#
{	pND ll E_C0aQPhjlp@futo!mok- d-
\BbygAXl_6b_/k perma`anQigw13n<l  fys dsk6  4@rbqpc(On O"(l	v  H.dCn0b  `Au!dW"eLm/, soma ck@
tvt. U~u p{`ppd/cĠ ikoU` .Q  0сbefalkrafȓpy 'AQƠ@"p=l . n  )v
ؑ!  &cO.q#o"J "4,Q/0d iDHuAP̷0..lR5:@ENtra!5ESC. řE# orpy U'F':ge@F10FY Msf
i/PD+s u ADk Osrflgdm vdRRena4HPskm DSp-bas MultiBay (K0 /$hjUSB-floGppyEC|cc{0R}wbsu SbAzipFr`aVTredj@Fj e SjSyRV O Ni @Ƀ Skimm F?n/Ctrl jElPv(a`isk)!apegeUst픙!
uPnPaq0#rm-c%r Pri[m Sed V`o Out Para#  TjStrCL`ohuko B< t 6nr compu Q0PPǀtrm
gat WWAkN-!sioLBlueth/A (trdlp;lo`~netP 2	݁UCmsty!C(Q*8*top+qb+Eth1h't 1K2-3KToLR![ HL	e+	 	Ent6gt? id-nu4`aP1riqB  S    Z 9b/ `LKalib) nsnd!igO  x ;0R8ѷ  YPOH KO OM\b o  O O#0ion OOOO$Hgs  1 1O O
1Vi mobPGu"[@>!(MEU)J= K=OOGO 1OO OOO[ TPq 1 : Oѿ@ .  % ].gmt2 AfFH5L)O3@	Genos	
k

, *   J/X4%G) ' (F`A qt  @Ž֡ r "popupsink(sek.@Hǀɀ25f- bAg0P p BIOS ATA_ DMA-rq Konfigumas  <F1=Hjelp>`ilxinP0jon sP s2{L!aӌ$k")Hepfra 6#:0ж@dioA	:Bk1)g _avslu!A B,lBDE;sprograt St passda/@&Op4FA|U)yrsi!vsf'unkur! tif׃%b-
xvn Sm 16 ׀#godkjSq0x neby`5Pi%itpt5auTilbakeAl#3fabPRg
i
 PE7;aN Urkty Ƽ aval1g AlaQİD5h 8>vt Ak  MbT!#`] !@U3EG*
`Hpӑ!4vanpprlgy 6  Dem7`5bM @\dtJIel\3
.5E6o%<}5Tr7ykkC taJ&QL&i  a=, ESC=Avbry`acBeAPpJaCNei rP, x k\Rer=M@bb `kYneppilr@Ot<ENTER> hv ddu ve 'Vt. BrukqdPp%l':  -> e$ MELLOMROM = NhQ&86 <-TILBAKEwrigʶTAB&"HIFTa++TF2@	x)P= Gof#l ~WsfeF`  SPk`'0`pZmnop@5 P M0|m kjresve,!@0m d;i pp 9!obaRafly@sbc^ 0d wAXa`1A|zrvfull1z. kode 02Io"Produ _t Nopablok7k-mllN {typ h@igv&-0ga zv$buff~N(L1/L2@Meng`	Q	enuV@woI-TjrtroUSW,kobgRi%,oK1 q'i 23R40,p( E
1w,9( Q0 
oa
o0A
o,
NEkB#Iml`4$Eoc%Hq ok!i*ps(A"Walp9g 0s"-h1jH( A]d`ss e7]"~e PnsAd 4~: DsA#. z tid9lSCholp`@DDTH[aQ "{/he-  dÓ, rnP}u1p skl<k`nn@2Aa:۲O b@Ҽreg1"i%HUgyld#ig#DSR`@	F
	#NEh0mtEb`?̀{|]F igno3t._te?-  HN 1 (yR nslXbP (): 30A3ggr 0$s0%[v\&st!vhFx_f!_: Ka"qut``U(Ó5$SQ&eGt :To(Lesb'1Du+q vrib: ID01rs<pS.M.A.R.T.-f^C0CCG  G#Npu  Bekreft njAv`l eP㰔1qrEّjv>likt aDu!0oC 2Ѽ	aŤ,okag3ogs.rɐor dmpel& Tp}?ّ.BrPa(A=pph. `bku,  amK#0vice.0ula?eD(s  aݢI 0"H i HP ptectTools3curity Man0`r.'-RN%l8  ēlanp撩pa0us #L@$AOmpEr`i!gi$eu bes!ka u"-U+/- +ӂWE%lq  '. tgl`rh,v@=$ڀPŶ. K$RmEp! rfrard- ParFll+vFP]hielQrzp2   CD- %FtV2uu H)o $.:Be5C`Ehpvalgtuh h`h"4@b࿿BRUKERHOVED-T6 C:J Rzumu0B@EQ
 an0^*REDbe! 1LPP
0P  w@"!2 $Va" #
6S,AS[P= 	"ن 6*pp   tJ@IOM @ automPZpD!xLock	4dbygg[)c16a  @^maPq߷ilg ^ge0.S k_[h 7fysAad $0GnrW  m#>	}v !n:gne1^VsQs ѻdda g ~u%y. Uh omd @O1}0/e XG)0{nq
` uQbVnbefau 31G	A}q.1A=x A0k1E5  fiP _!R!'Y~I7MTאs x-QVflans NPBv
,x2˰ESC-zL Ϣ`sb'fD'J F10$ZCb#e:hf$ nd  Nor iFGO%re  MultiBayPG]z "Q'n(vef!e)pPko.ngsbahhsyOBUSBA|w Zip-U
A A0AaFn/oCtrle EAVd(USA)|GekeenAela	jZtroA2deo@!j"pTisrrF3ViA7tiࣀ`0mFgradi/?trdl |t
WWAN) OOHLOJBluetooth /-eftmP7 Ag ss'styg!1% %*2$ (	v0&#.b/! 1 Ethߐ;?@	.-	3	  !R!(NT s*PooPo/
;niA@jtifikhRRC&@B:riJ( K0t  4 @6ymbo Kalib2K Baes- Ip<pɀ?D/ual ,-N	 O	I	O	O	51 O	O	O	O	8ksp.bO	O	O	ond 4oO	O	
%O	O	bv mob. a
H.\ L.\O	a}o
 {{O	B.[ TO: La. В% ]<afull"C2F~iH3
in/Qh*0 Oy  (o J/DJ/éiǋpkim: sin@ ~hurtigE (sekurxѷF12-`Df1.Sepute P@pRBIOS D'MA- rᐍConfiguracie la Com adora <F1=Ayuda> ?rchivo m%l Sma@QґPGu isco flexicP޻ Ra (s!^valoqp
f doba`y Ignambio7s y@lia A{  g3 @'Ln epidadAse
  ' Ajiciof%posIi s_SITc)$ +՚ @*VKskSm>Cp S)oQ0e*cP#x<) Sectyincor`% E0e" 30/c XP>6fbrI
a`DPVc!3nci])?AutomaHerramia`C~H er 8`#P(8` ;prueba HDDKc ' >OGVp&M?emoria2a d*mp.al`1@JNKRMu0GbSG#
s
 AvanzX ESvVDD
W? Fampr)co0N gr<1o?)<UOprim'q;uitec0g2)Pbao=, ESC=Ca06la==Acepv=SSNK1"Y, Co2	=My p U@{B$dchDha6al~  alemo apropiu=@[*<INTRO> z@ix:N1n.Fs{3pkTY :Esp~o o -> ?= PrxcRetroces<-{0`@a.xTAB S	S'@Mays+b#C(/F2!-910`rp"b"uErr 06F  No@8 @AiGS=r`jo u@QRA6K. Cdp`01Bhoay n unw>LэqubRnYD2@AC1+>bѪr(R[co rUD)JНebook/MEU ?IX1QP\@2pO`0ple~0Vxitosa4e Fak T1ytil TisOp7,Vc*lGpuWXTamauZ_0h (L1/L12Oc FAA_ROM Fnl@cNmerD}rqibvisU!v@ j6r g-l@yo!!
/#j1l2n3p4 EOtiqurA!sI2Ve4FK (ga Woo.o3oopoi B(	Esn!*J8T 5:Z$  ProbUS%bssfactcXJ$ǔ 2ll4Reo 0poX@1'	lnedi$l@z,
(HCE| oD"F%Ad  :vH uir-  eap. Preh#/, 0WcqscpY2#auA:'p, Uu c l@Qas ' Ӣ,Фhp9tegAң
S^@vlQI$\'vaPPa)00٠o(a) 8!@%`c	Za?`gnޗod ilO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcunvtieej 2( s): 300go B0%&~Db  EaH0 _^`ipalGirumq
 :
 s,pu10@ qIQ{`3nh7Servof 44apoya atr{ib0: IDp#@exs G
X0YA`seaـKHnuevL@)Df ApkagE ndq9CS@gOB".Xt		@e voc"	k"alpa 
0 Lstnad ;`fR n"]e#թ9 A*# \A<Q, (02o,vA`bs (R6% Ey WciR|LLB hrpinR3 SIBf_ ol:9al ol`X#A!vu	jvip.AoQ  '{Ùv?@%(֠WapaAuydAn14n HPctTool@O)%!!&  QuickLockSuspen Blo`jԹ\rat S 6""t mej`eO@`?:0d++-y	(BI	( !)(rALlRt0,"D,0Xৠ&upizQ,.`xHvOre Pu°nP+rojo%q>lWS9rMLmedufh zBaCD-q(E喁(&XPk:	Z@Us0io:OpuT=sPP  !rrive(Rl! t@ab|USUARIOJ PRINCIPAL0Q@l o@圠dtVK7man`V p Py. An[4 >y gu$@lug.П  `j7a{P..'tJ @d]"YIeG Ӂ1
c@bU= Z`>&BQ@3"mc8K)81FPor/A:
₴; ;QrkR ϐu@u } , fsm1$2ARirP
oc, #I"oi /#_z"<Y q0u SϠd/a|sRcubb Tt	BB! ? |pda !$
kosgѰ6Se rxo1enf 8d2`licQ!"refAaza. O&?k Pu  `#PZRS4=TFin!~k  k0T1B¸fiup8Z!`
s|i@pons2> Y_, iѰR ESC.  ձalab:p'Fd'  ,F10!":ҽxf GaG7T/Espaol O@rStMultiBaNPa DiPsQi໤3-p ې;]ӟfbP"c9o+(izt(@jech-5 cBb a1ЇSuwkrdZipcpmeaeTer Jo C`5t#0 x SOv NoLD C>us Fn/`T@ncIngls (EE.UWU.)sp¤ (lppmpl3So}"le$b
er10n!t!Ac@ Gΰeo Mod0z"y!  Bidiƃ Ta	m&CmpI!ϙi#	si0߰fQu0{ B,߳ICARPQ<k*WWANy{L Bluetooth IA
p}{Pbyho#ergslgCpoPos 6B/p:(s+ior)Eth  et, NЗbooU 1/,2/L3\/Tok0Rd OOP23 IpStif Exclus sA Ma6`  .a*C0g`*-N0p[PSo`Wr)Xh!,o	o	k	(o	h	s0bpkn	o	o	e oko	o	 o	ao	o	%MEU o	.o	o	o	o	Ub2o	 o	o	o	B8[0ڷ1 :rg". c% ]/`~HpAm2 @c4-Cl	e0τ3	й k",'* q 9ODJ)o!qoh ~1bl䑄@zArran1pBy@gÓXDPХg2ExQ찱`  F12QTPAmb@Tou_chPad u1Wo N uTsсr D D{MABIOSNaPub  <F1=Aj/uda>rP0oInfo@͇䰩wsobPo Sf EเЈ?4maDӲIpR0
rt7<padr0
3t  Ign`0airA	4sPs '&_.1nanL6azO(DBr% &pς_`# ƕb!X_d#!

StUd"ԅ:liz/pΉO
(Ib 0؇/R Q*A8g%ԠbrB
GautQ<nT 4dcЮeaalhAlo`Oa c(SFeQmas@g1=1 iCP8$f!leOpT HDD A1)r  VR#Le Mem@PA<x  4tatu UQMuPY`Gp]⫨ Av82!S%,io Qa`d; 1camppJcinzP"o?CA9 Pds`e )qnr ycк'tinuar iy=' SC=CselAce ,imNKn!S, Q%ou=Maimg 'Uti0: sC	qqp'1da` o i  aprop@y *u@Tv#<ENTER> t5meRez[@go.Tgut:9 ^r ub:  ->
PAO = PrgxiK\<-QoBACKCExaQE06TABo$SHIFT+C%* F2 	*:`=0kSC# 9nErrrOA@Q@na0WoQpmRHE. CϢdigTGo 01  NPhG`,@o `qS)3  s@ viKCA A	bMev
;ÔZWotebook/C[(RWS mGsTe2_DKKXqmBm xitonN  Ti0H݀3VpcS_\ Tahcache (L1/L2૦FX a` ROM FamlY  N 3sri
RevisSvdae@Π_aJro QLa
Al!D	Ob a(H34`RStiep	JIOeu6	(]){ 7 on)oo.Oo$alS~ƕSecundAa'$ 1rcC% vWfoi"gv@!mO al  Walk  0e g1i	a lien !M!oc0I@Advert: 0[Aq̠o vae!djWcqTP/,!i@um  gravvuu:e)EӎA: )n@Adc NS3 >B^hO!QtegiEa	c]
vl0IyQI= kT@ctez0 eja $,C?0 iN >?ý?1 (Rp bޢ2 (A@ng!qf3 (S.M.A.R.T.ax`=_(.): 30 <`хѡ0@CT =4QC0%?1$bucedeA,<qAhostDCrom1
: Iss-P $Eg
Ch`Ӂư(*erPmec   `6Q3sM tribߒLD`AМexa0@s w`QUUig:Tgrg`aHlPSLs   qL rBh+ۤiPArrfDigcis gҐ`SAdP)PPЉxacmo	d!CsާB<! fazA@ArEr`a!,Πer dform!r3Dn,Pja0.@eHCsHfbrcausadQer0F. SZ  Q[ea 㷑2krvio 	Iy0r@qX)QT?%X0Р ur@r0k
ad`pis 0S,B,QuickLock!Suspen?so Blo`qtB #u@aSM%` mabnb1IY @k,$$al#.2P4sa eiSib0RPu>seu sEExigU`re*PbM0Q+ &perme@$1ہlp즅+!C#D-"˯gGP$qme:PDusua: VocÈ@gp4@a0vrV2utzooDrive& t@$RUSURIOBG@ESTRE_F SC%ɑ7xq<Vapaz:@I. AaN4P@9de-ФrMisPJEB>p"}@. NNv p[֣'6Ve ,V`(_K` 0+bu:*6Ƥa !Ede]D.Hf``7D/{s1!Bi@屧O7T>WDIA V
l`9w9o  sumǛEf`lo,al Af Caa_erf
a`uuzoT $:aq(˂4`  Àoqu r<ǵx@FkgڲU yaf0T y 2y, p;) F `3Bor na1l|p`a-t
A^ ˢtႻEsubtud C{ ?@*hR)ppa۵ptA-lVJ/qrW L !8Z  LembreH ՚vqMac`Pasa8
"qui_ʰse`R ESC]ŉ9Šq3lav'f'rF10. rX`r:MrʷTAc]D ugus Op1k: MultibayQYiNc`isi reAFpBa baФcopld(RP ,dit$zB	Rc"zipcPriomeir"rc QtӂO]v@N Ղc@aqAs F?n/CtrlIngls (E.UV`ыxS[qhp1troaxhvdexAcund a@hMo#aGoPadrBiQTaPhBm'emO"sem fubw>zeYc10CA.#RPa 0RlmWWAN)` ooLo)BloothkAAnP(a/ E omCeonerga ΀erec-agRF2.11{5e/12o03su0˰3Et&netg	O`p
/*3/CToken Ring OObo`Id
f Sb 6auaqW XSt`sSsݼCBbGPdbptgemNS vlCAwr| R"[Duplo&	ted/	)	 E/	jONOOO'as7A mO/	kC/	cIAl0 O O/	Ojp~AMEU/	/	-/	G9Dф1	/	/	/	O6[ Etapa 1:^rreg2. 0% ]Oc3lZ 2:AcvN3:M"* 
 o9ayCJm*O"(|sDflex`߂QSc زrydapY!瘀i Popup> Exb@ ~àF12(т? dQZs Vara֧a UN u`T@s`݈s DDM]AFIOS`i qk0@{mtukP  <F1=Ohje>JrjtQt Nytt -vPbtu kP Tallenna levykkee dk@on*@oPu VCtF?Fo02Tej'nsWw Oh  mu0A Plopq6Lr  ttpt7fTpo@uaurlisu0invojan s@saMritoKyEnyk La0tylȮ 
 !Ausnume
o@%F-Ut WlykPiPu`'
@-)o0n-uki
W0 (etF.DAt3afsxB'6e+tehd7OG"tԐ"$jJ<A`*ma +in Ty_kalu`Aa;$ `o K = Ki`4vytp@O:@1pEMu@Qk! a6n0ˀD;m.xDHILisieliQIk aec  harllQ10p> H3N3'SB3#*3H%Jatk!inPjot  _nppea`=d, ESC=Per G=Hyvksy~=KyllEi N, J'okuL= UYa` fnuolMi
mip_k bh$@
sidsN <ENTEoR> mB7t
ep..I Lgn C/ss s?euraavU:a ->PYi VLINP?PIN =[s  <-bASKELPALAUTEdfb1<!ARKA+!htVAIHTO+', F20@
)_A= we@!;virh`wAkku7a e =oi>gda.>: R>vdi 01*kac1pt~ apHrt2PTm p<Ueytke`"6ko>@	siPQlakBsqssRW` kaCtqlaaP^ TikkI)>skeytWyi Fn
i((pO2nL^Boh0ebaGm|j}~1?i@db? tyypp iIn :fapll!VlisQ (L1/L2UA?  ROM-Sb8mkoha	tuotepe"ɠsar{W]`si ?stohjab T`;{	!1:"#2o L3o`M40mJ`Lta1AbIon7(j \oa)


`
\	\Ju䑷kA'ra- DDqACu$#:D$ 9a%dzb~ lpi!xiEepoi Walking 0 -[1~Yloso@Vaihtoe@ :uvi7 us: Tm'6atpnhp . Jlt luop2us7-  n,irjonc!KA: L@"X AYhkuVV3be FAG8p_Cpa ᣾
Hkoa]Wi` `zn? Բ`F  H?ͨ,i`%(N92R`3.M.A.R.T. Arp$[n (min): 390-s p2y0%cL dv0 Ispysi - 4iVgR
ᄇ{fb%untq'c{K)jServomoottj
Lu!5ÂvtuQ	k@FttribPti2@ЗŽy@a 6eqK
xe nGG9 UuVahvu x P>2Ȕ	! PC ޤa}A"+2@Ds@a	,-ã PAJa頴n4-okkpDad`5an I	nDP -e@7xp$Rmysb a
`k1h@` ЁeT@	dE	ZEY/r ir0Xj [!K unQnwby:p\veapahtum"b@^i!d FLaJ4tii l <HP PrpctTools`cuQ`Pger -apuД큶.f(-/U i` n QuickLockfa hlu5qf,V "@PraZ&-Q,:*sekm #o$j$i t)a{d||}yh' PP `0#UʎC.7>uu	SApor Infr
PnR%!bk·CD- -agl Wbt`PBOj0WWAiot=bUon DИe"$(qpTT#)PKlla. P    KYTTJN:a PSSANAN,0&#Kx.ma$r@>'silyqNhcur@S9h  ri_g[t _r
%VX-$%PV,1pCp@@jwLLA1=[Q' ONU @Ros`* $V suQFZ>hR;)f,#tu? x	5ogmʂ O
 G  BU7mBF r
Sxez`jED. NykyscR`+RAn𨐆{s1x6s
t@@ PU. TntȠ}$ྣih1xeip=upcerVd<eh?  IPa*?-m@&yް\b2tHtaqV(^=c |AojaiemmRf}tAq. 71pm "Fdt"TV@U G.2!`ZXrrF_Fzc$ e@lnPĀo#\@X#SS,aT>pESC-nbPsR6;n,eⳅ'e'!> F10`Y4aax :	o .cVQ ll0QޠtmidƔys ubbn MultiBaOpc&J7lako0iu (en/$o}i) USBd@)ZipEnsimam ABKoA elj }Vi䀙}Ki eit@Kapk 9Y Kym!aiо Fn/Ctrl"mA+ΠEng(USAUsP0s#a!1B-RsQ S`n$q`jBs#PPs V0olhttVa'kiops2sN#IguuQH`Dpl% verkko "
WWAN-roHLOBl]uWoth @/Fh`  sVp܀Rs	 s:lӏ
,1i`0> y/2,-I, ?(ylos+OGCO6EthCerHo2E Y oeo3o9+To $gOohA workQc&G IlivA AGkkuT < TJr ӿ rP{jo libreu ad  Sual`-OO  OI OKblb_OO  O Os O$O$O$ vva_ O 1 O1 OMaa nusBkPBOD OO OMbOOO`O
OI[ e`i:r
йada@n . % ] ODPW2l` urpp&OE-O
3
Go@MOH*  j l9#@`Fނk`FqvuɃP iǰ@ '(se  nA @:@F1S2:ڴiP%3tappiQkoskeӐ. 'mma K  Ei mn BIOS DM=A iedo Pot Configurati5ordteur  <F1=A0> Fichier? Infor` mAff age Sauvegarder sur disq``c R a ,r P 'une.H_DHe0als dfau`ow du'Ign=o%modi T&pqu S%?e l'in % regom	\ Scuriti&
e ss`Nd@S"#j@`e sous te 8PKon.D
 priphP %J	a sE@&IDy'As
Dr<Lockq
Smp(C0Cr1P31r3  'he5G  1b#a <gre taR,)+5p7am''us3;),;rfren!cM =at"#Ou\ !@lonnLbceriZ slecqSn@psQPs AIATABFoV,mmoir icBDX C0ZZaFB_V AcpLang4 ChoistPJYl3Ind)|!5_mps g!X 5ePMd.rpa `k2Z}:~z? AppuyDfnatouqpo@gepu@lw=Ser, ECH/AP=A lHAccep| S0=OuiuN*#Q3V, N/'impp_e``1D
=aw  UpЈzi3
s Mf'heM
mox!04ecle hmenuucer8@rwbri 2qhz!y <E?NTREE>2nj+W	ss	sui/fa  !/ :!-> ou BARRE ESPACE = PBe`1-$IE?preced@S.<TAB`CA*'zMAJ+ix F2=1"w-$!S(rr`@P<TJ Ily FA%ssibPdcQ7L U cs'Jprod{endp#B$P. Coa<'401!c5Cntв@-1 emplace( L' D SaQre @}C'y
GJ 
s}^ccueoil dP "4@ itzaxsmobia``
W 
u` B!OOOF2BfCX+)a ru Fa0;cq0M\ GTyp0osBVwDb KTa@rcaa(L1/L2) Volu`e!gD  ROMOamR Numrqo#p	Rev`cnrdoerS2ItrQcl#avpoLA} ud;n+/Zp/zr3/t4n"3inv!/Qzi&<5 #priF:!L( Ute)O OoOOOBV'ed6A Eo MT֍ :$/.   %ErF4 !SUPc;Walking 0ᥒ81lig'ad`auZC	od  al0i5fAtip1SRC[a=e@ptruA ieЪvPR! /簹r,  z{ nr1o°c	HcY0]A}jDL_v
 t;ro Pa
s
TX	  _[Rvj!a"`dH.ORn m:YfP S 0"Ӏf   +-vaPC 
lp  ߚV ? Igno7 +| z? Enregeo#=1 (rap`)#>2 (coet)u`|VpimA(z) Bc30堿s pAnU0% nv$D9ʈl'hA+bF  `:˗	AsmGinpnu#d'+,`v`t
$.Lu( pG3ip 5A`ib!<O: IDP00@"s S.M.A.R{.TAbanG2WpW AIBY`/se N!=apYeAÐ?/@;saұ#A Mar uin KS;A, eecoac	;mme, vK*ad11POobPbatCs	eS¢d4D	 pe>a1a`(`ih s4[	,P@s蒵 `Ug"  f'ormQg-hHq#xѼsJ.)ArmQފb	 hJU0`
1AJ	.6zT"`QDP~aR avoupR!AfrCww7 A^	 	zYR`(p"}ffQd  k;l2TcgNq`rHP P`o Tool:e^Ry Mar 	O4K8CF!/  QuickLockUsus A|$cp!ri 9 س<S&ol'S+C)re!cB!
`K)!nk:,   v qi4//;  / L'(a'Ha
S$ud!v
 KP
dra+D hn8 4`ExiZAudP `2  4raQ8llƙۗ&flashYd C#D-'gEf8WЫpala*Y:6PR63ge Drive!*. S3A@bAeBdez deux"(UTILISATEURPRIN?CIPAL) "cE@ǋ	r SXċOj N;zJ @ ұ@Fx#1"Qisr  ,mfe0celu&NSDordqi@"c. A 0@QV	{( p@$OV)Do Co0 5AfetrpyJ~N",t"~"raSX"Qnof0; ;""Bt QE)=ah:>Janiq45#'/p#!2/r,c`sĻ!Pl!  30ӿ)Y!$!} !!{ e [1NJ^%puel1@2݂sU :Hh" ""opDa8lEO'fW'ҜB`k_w# ,d'origi-nIlv`O$2CxaB	uȦ
vqSpa@0AQy9	0t0M@
5dj)aBvPsa{$S@P{e*r-$ށW1aprs@4AAon: toP@Tr0Ba44p`abzt3إk'
vj, appuy
` ?ECHAP.  @@ OTzR'o', pui@CrDF10 TapXC 1xCxY^u}	U/1Frana
OgVACJiMu?ltiBayѪulAphA !3D,xsouca%(ga)OOFRz) Ux[8 USBF1r
jZiprP: Dhi@s QuaQCin`NSwixi SeΑ  Hud NeuvCD`Perm/r(s F?n/Ctrl@S= AnglpSA) Pcopqm1`s A stan0`hnROd'ad`neltrul' Uich&uer&mR`
Ұ*d :i@7idÂoAABid@b 0 mSmVlb@jEK!al ,ó R o!=ril WWAN (rseil)AgrĀ
LBlPooth73r/?1   >)o`$ g`Q loc <G `c!ZqX0b91AbP-n oR;2ooypu<	6ccumodh`ogB EPb$t# 1a%23T{okRingo oU/,IduT9-ar a[  
2     Ph ll`4 n!Kre0/ x Ab!AF.!f*Dupk */)///wb// ///*pe* -///Jqgn$, /,/ /e s` BtexвsqbmoP/ /7/// ,///7[qRpe 1 : Charr. % ]A.  2D` GicM*
n3@	Rkio.
* T   @@/M.$oOA$Ʊ|4Amor1cFe"5 RetardBTexp `) Dжa  F12\tposf[iP+Aux  PatqbAK<w ucunİferts BIOSmDMA IP zpOlr <F1=Aui> nfo\gQema
l0'Salva`l floppy%@AttoRipr>ina dnThi@fAa0``ip"|Ignor`d!ed esci EP a
l'iI@Az eiBʷtupicz{za sswo&e amDratogcc3R
q7Z,vos7v@% IDs
@פ&gDriveLock	LPr ɣ+St CP9 SupPA=c30 g@Hg/o+:,i fabbr
4=i	/.nzi`[lQco
ruWi C`b5<b!ae9E lrOpa t2;o rigidAEtpaA'VP<!΂,a me0V W`<HKJhMiM;A>orp !Ava=t Lu!O l$Dim"& q6ca X ssopd eviQ 1g	vv!'#o*62wH8Premi qpsiasiesXperQVu L   k=f, ESC=Annu`,aA Et0qe.o=SiSN1T,altro#	=A bj Us"Schiav~I frecc'!i1 voc<pu ap70e"_`<INVIO>  \kZ\'e.ipYgui  un%:@ -> o SPAZIO = xsuWss`0  <-pBACKCEĭ c<TAB@C%o"M?AIUSC+)XF2	>-Ћ= m "AC"IErriS0D  Qu A87nppupvse@t"ViO  v@u4T|PXJ. C{'01 N0u0F>QQ9|a0}oggiao Lk`IP'0 U>re0
z4Es"@agga%Fv0S!t`ғ { npabook"tQzesp қ:\ ZҪf.atp_
2o{briuPrf udauAA ND  Ti"+0<PSpVeloIStepp@YMis1ca(L1G/L2d&dDbROMIamig	lk N@o0H`(D	RP[3[oi<#qSroll TsjrAer ~$i1OFk2m	3n4ࡐ7@w PVSTe)(DE(d)H8
	2
3
4D葭<Fonda
 ,o:EV$ THr%OupyP!gTŒ@lliASpr:bit 90t 1Rindirip	i] `| 'F:AЎso:5X%? gger  `|vpAhAre!0M/rѧ, O`1favi P}P1iVYXA:'mYU[A:"m]aconouAðh(_ IIpSɁQrita]+ Nsv@dpRlIQOayളSe3 `voPga	 ?AFbb iQfre?@?: Aɐ51 (Rap)62 (Complet"2tio (>): 30>0%Q5"r6car0䠈'hPD5|:s* Щ-@
˱ ֤(aD୆%aerv|")LċAPLA'	nrib i0gol: ID0$Ban`de@z قi S.M.A.R.T.!ޱuT0U _wordc(nuo!i2 pDsc(Ui%L$?bq+d`! {â"Znd?՛O.A7Tcq^B&
Am AVf! B;YpCr	t>J2fum y3CePe<B #u" _t`!1a哰.Q]ՒbdFo!erdPКatiwEff+Jizso~@in  ca2i vEvPgaζOdesХP@J m9Yy HP tectTools Od. ZRV2+ ickLockspen`3B05EY mou`s8 MM d?#<#,p  gra@p'!oe  -!e$C-))0v!pKsm@]0x$!! b	,'UvRar i lі@NR(@| ГV|a infraQ)pH y%La_hflasho GCD- eS@2&WЗPp`	:(Y=!AҍўDeyusan@De'. DU8G=0R bRY"'UTENTE@PRINCIPALE  r+`"ρa PmanA5fu|`o. AnV@!<dЊ Qt@P!"A eC!>c2<P!t.`leu0WMT[s,
`h	\@poI sb<4reWc.MaPHi? `o `6d6dqGi@>h@A
 @re,q  	d (1z:t tOCF r luogo ĴG T!¿'    i$  hSGT#:,eG </I"I@5-"L@7Y$r@lx|slmЄ!`R/ċ|cB  /$ ²ȒC0SŔ@c (0 0@DA's`  !gPQ#pQAi qv 	lptat@{+`u Y/AdO::!al0{s&.2pqu_{9c!."Y)@sA`Y$EsnO`d@K@ȱ0P' 6h,m|Qo ESCFM'ŝ)dovr0 'n'`po2m!nF10.ɡnQ !k0Wyƴ_6\@WРIP(i 3  O :Ć dM MiBay sba 1.gga s$Z) og Ch`i USaBA]SurkbC
ZipBP6o ;Terz  OЁv`N%ec AAP Fn/Ctrl Tx`Ingl? (USA) Yiu2O mpl  A01aЃ` R7p!l AaP00ư0!Mo@e<cW Bid0HqaCapa memPqaX&5em s"F!/lbQ2'/wNPs (WWAN){oLBluetoothCommiu	/ (J)Cs m energ]phW8'g)1 N,*%2HB-Fat-(o)ol/sp Ethe)tW V123e Token Ring!pOE3 IAkB| sCtQaL   AoQ  C02b // WD|S aoo [Kvi0DuV  / o  6 /  o ,o // ooda C   / o pUY\mo93 //-oo ooȓ///oo[ PAs 1 : 
rδo .  % ]ocomp(p®#2S'4,n6E3  @
ijB* 
  /JqoXaX/3i'o
  ?FloppybU!AǐI!d C@Φ p(sec.)# vel0F12b 2zw@pambp@NupTras0  DMA BIOSup <F1=Hjlp>rkiv Sy!~infEotpзs~ S pkt%kPiguQ 3(stll frnlPpn ard Annua nd`` ochFsl``   np͑ SkerdPtrsl0F  K!aOB rt-OaEnss	(b -ID
S ao
d m`
Rd-Std fr,uts࿇av 7K
 byggd 
usBi=*abrik`m+ .J
sbehrig#Gskts@rktyg Ko +r v؀P S`;vtiGHDD Ak_V ?Minnes:"  01q5Q ?@An@#B
S Vlj4rD ;cBnOedtolD!v(C-j+eTry@SI fri Dg s nr du viJPstyY=, ESC=AOvbryNaFDAccepaF, V=OMer X JvI pil	e	/pCa PyEt
<RETUR> om6
YRtt .ke,lj`SeerI } : -> кMELLANSLAGSTANGENTEN = NXS G<-BACKSTEG FregeyK TABƦf#O`KIFT+H& F2`+?|= 'fO @%Aoiܦ?Cfel 3t cgqL @ kA t h+AO` Dstod uGen. oFelk0197 AsЌgF{P|plat  NtPhm krv3?܀ pbyPgm0 fly5s t6 U-Po;r/2 ex䚣(|0YtiGdigooi2-@kl`TA UkʱN,q  Prr, t{yp
hast^hg0Cap-	rlek (L1/L2)Yd ROM,um ~ familj~renummn0D^deo, r᱐Y ttNb ~pqyrQ!]H 1.z2#3$4rbinv0̦3 (bZ)g	1[
p

Sek#	 xIrq.ܒ4$@gaxr%8Ex!z=ok!pvidClmissl l.s Walk0s - ~P f1jHހ Adds Sli7Ae޺nVar! D@/ѹ  7neh g"CcuskaUpay /G-tH۱xiƱ=k ab!h$2AA:1R K>#Rhi{wIBB?skyddadag

 ߄ Eˎ҇A!^Ԉ  ȅ|? ig?D܇jGa- 1nGabb8pf@Rn`X9UWk ad k$pQd (0): 30@npan 2?0%bX A4Pp/]spp01vr katPo:,t	!قOk%S(x ervo-L zB!i @(f%ttribut: IDpx?grobsr.M.A.R.T.-5 OGammN u\7 ifin`@ D> L܀Q R4bd% pm}vlika m0Ǆ  'InE?kan orsa @3iЈ P9aHSsNypPO@Om=<s1A61lo. 'N_a om hߏglmabtj@Deh ;elCse- @^uQDuayVq΀Φ >fun 0`perl^7!i HP tectTools%٩R-6-Quicka"q`telge Lp׌mxPs Hg$k
gppb*_- &q2@&!џ!!r ngo"pKF5b#li`X!aot. Kж7AoimpHi p@J1f   Pk`anFlagsh-@: s!CD-pBWu O#TpSr HuvudH`y`I: D,`m3vahrdud 5D~e!. /C怆a^r ANVsHUVUD #$|`p[mart w.] A? L1Ёq`ild frPA+A
 I1PhPx@L l Qף(@lHTwO.!Y  *oH XBe0bbyggP6Q1 g3///dZ6- FX;omc e`B
8HcA?=  ?dr:asBQGdʜD[`ktuPaiq,3afanqkr`.GutAMC]tgrs^W!p,t1ursprung`LxK. Vi  reko`RF	0b~c	Wr`+,s`b`~. A`KT ̄3_bh  &g!(g AzO-befnse> rm ihм񓶈fljQfns . Tr = >ESC-QB Sr26V"&wC`'Z'R-sedMtaGF10`cVi3a:+ddQ~shye aSve a 2 Q: N?, M iwBayCrut`ۆA~opBP5vi cBa PG (pr (h@SB G Zip-=PW`AsQFj1Aѱ\Q utto NЛT VxpFn-/Ctrle ' E`lsЭ(USAbmYkd@!aas b`nrms'trorxK,  hbbelorlekhpemo2ne@kLpIfEsioBtrqtK (WWAN)LBluetooth p/(6) -v@{ANmbe^1 Aggs`FhaE(-21,2v0[,p'Ned ECthඡ,& 0	3n To!RqN"!Unik *1D?qiG K `tus      SBbo Kalibo d@p~-  F=s alQ.O 
o 

 
 9
Fo 
E 
D0!m1s 
Aoo
Et
Htag  *o 
* ʯ
VC| emo o]A*5ooe
 DIOOKood
D?[Ne _ : Lapr . 0% ]
klar
2uj253om FjOF* &V@1 >I *O!DgO8U®br@4sadapП$lg~ rdrjQ>psnabb0 (sek. F1 Bd StyrPguIOS DMAaaa˰"Ben ieer/  Op Teslaan Configupo`anaf Pvt~ndaardP"/  scy	Wijzig&ne Pprogramma @РSetupv  z1r w ܃rsveiBeheerswachtwo oޅ
 %X. ApaatbOgl$$ ID's 	gaSmA6CP  Oa uP"5P$cR%m@j+%O
GeX@gfӨ gssvzie܏"Fabrieks.ugz7@/):;Vref.s:nieuw8OOc  Ext`AccuxB 4\e0P gese'lec Ea p`Es  zelftGa [-schijfei Act 6vG0u`? I R!a/4RUBgDAcg@7n ,DP=%_
 w 9aKc~!: Taal b  =r/emP 	rijsgeomaak el=;o" /;9
8ukAZ ]{NMLg]g=S, ESC=AOnnul"EDG,0=!e!oJacNee fslui@Q,c AQ-f =MN Hulppijltjkp`?gebrui1Ѕd )jui`xnukeuzk@ark^<ENTE?R> ind 
cr]beZo !vol%@@`1  0aiX:  -> of SPATIEBALKc =>`<-oBACKCEVoriglɸTABb	#HIFT+%%|20+K= ykp=t#B~fGouta64k pn It w_ge15 F0MЌreqatijasen. AcoZ0Q1b a0.i1ZCu  we   Netvoe are0#FMPN diVbas`e3
 t n0 notebo?ok-pc/AP) @.PistNpOQbep*Gigdooh2L	MЛaft NmpALyp~6rocessBnel3Qp9p OmPЂP}e (L1/Ly2 Zapac?i VHROM @ -s!fSP<mm E  Hebvrgav|_0ideokp&p;b bpM@	m	ra1b2rd3e4hisgI t}.jne  C(B(ЉwM@dzQ%)
  `D#SecuibE.aw~~@$Ftbd%)҆2! dHU2L53Hac-0-*1Tho_ad/resrlafwisn/d pao==LTop: zPٱt<ts ev'ge t PS&BbeЉf s d1 A:|og-  / "x0zbLe6`NoffaG1Y\f_dقڑD`H

boචgAt
wOC'KWe nu  Њ"
wil?oݩ"
"a?Ox
Zl"+1 (zb),2 (U0Y ) Аpqwrpn (min?.): 30aee&p:L0%Qtoo 4;q{ho:5GbroA):]eeqx/nb !$32#k'vo-IPsE I"
2"qk:J S.M.A?.R.T.-af@APP@udh "/Blo!  A I-7B4k XqcrlpSX8
 Vr!a1& is% bBsAYoCf#/k, Tm]lijk0UKQߛg zoikt` dvor s:ka?0QH fQeksKPugzet,br lorAZ@¶ZOb$ 	uswb sqwYyfur9houd'Hi`! AQ `R`T`R&BѴ4񡘾 vuaY|ߐHP Pr@ctTools(*@%/ k  p?gspp`b TWmE #M"g&$rgΠ9b   ~erX#W>,.o(h( o( S("7'EAJb"f k otraakP)5w sXbtK;?ݠ ]Qŉ p\1׀frapd  Parˊ Flash-malCd-!r@WHNǉHoofdXVG8s`
jE  Uq13xaia DBQLc7A<i!Pzow*HOOFD-BSGEBRUIKERS8_L1  pf $an=	 SsC  cҦwacJ#! fy0k#0hcomp s%ksMq~0[p%t  Pbc(q. `Y0ppq8_{!A/utomKc%5@:)z2U@Ҁr<zdZ==}88 O!V)?!2:NP O! !. Mo0XeMjoOtDb, `  Cj rS8ΠRU nt@`Pe@	M8/ # hui,HUPd`w?was to/!wk wgea. pwWa?nvloeC7YkjY0TsPn`pZUdt0rAra=8	R0` torH/) bget. Oo
 s @vb뎸. O
mRun
1]A&`3fe*& gol q. Aݹ_Ա_õ,@ubh A dc3䥼p3ruk3AESC- (A90@Ri r4'k'tyUbkn F10`ۀT*Z lutb r3`V4  1Nel@@g MultiBayjVzkd@\!base; (ks)re  USB	-Մ cb+z6p-" Er@#we鱠V V@{Zes >Z$῀>Aa8N Fn/Ctrl `Owiss/`pSStaMcW3MijsappOu e% 0  n ӫ$l Bi5j V o-QPF@A/A0d`{dition  Gvgp<uqVilat0E?b疩p neVd$`Radioj W/WAN-aofLooBluetR@h/o $JArgie P[K`^.(b)ߏcEtȐ 1
2d
3iTo}R/-OMobo !02G3 UPXuAt60!cuI< q6us     ScaGekaCli@!1OK"2
NeEualR\JOO COGEZO@OO 4^B1^'OOO 	H0~pAգ
@O$O"Lker-MUE-$ J$OC$P1q+OO+O  [alp 1 : Bo@1. % ]/& p[0d2knt e~l/{	3	˄
fohl/)* Jt  ;>.C,$D"q $#a<Xadap PҢ(sec.)pop-up bij +snroC aOF12 )Kbb cursorytuyEasyPo-muisG1 DM3A-}drq BIOS  Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋւa\܂tsfBNɕۑ  ݒOCOF県Ăg&f 
H
gɁ  Ho׎ɞ 
E	ύXɏ_I  `AO̿Ԃܫ@ea L(eA`LCǗ҃p h/do'o "X yf@\̗L/?E%ID&ID: h (uN XBSA$͍폜eX} 0g J 23TÃ|OH	, v".eI*"%ɀ;FX
 ؖy>f
cA>oAe̒  I(Df:nA%e> pCeBIvCc"F@ `F  H D%Jc9J; ڍc R5BM NP$߂MA%E@U`UO tÃB!#sNu%.37($b74L[BR h=!AEsc=C@bsAS60=͂
ς  aRAg)gjq5\ 3gp] jkڂ %iA@ugp>[Ez]  e >ȳ#wA̘r_->Epy`tOo[ = {ET  <-SG[BackSpace] a%[Tab!AG#[Shift]+eF2!,,,10nm˔F/[%  !CG[  @DBCł}@BDrp o 01 OyN^F`+@~3a
ɂACϊOk ~ڑKv@&eb rO x1X
Mp!mQ^0fGdMEU		Ȃ2e`	ýуޯ     xݸ  ށiL1/L2"OM OM̧Fرٔԍ  ޵ ޼ ް ۰ׂްޯ ްir ޯ#2.3N4h	 pŰϼch3(?Â)FE-3N4(J(kvJ _!nF2w XcopF?$qv sxП6!;L{sV+Walk#0s?A-1B/:Z hѢٓp^`OD4x:2BtƁAC %C颴 ׂĎDa/ŗp쳐AFA:݉ b#}#v!h F} FS Pl	NXW<M֎~@Yq Zos/9@y`(c  ֿB	H #ċ gOog '`,گЯ1iNp`2iS3p.M.A.R.T \zsԁij: 30Bײ>v0% bj!c OOK z3 eBs~ f{:@	{ewm`Q1kT {ǂݨUfIFIDP.Ba"R`R AFfV!'/i` ¢k@ΡdAJg(B(a ͤDxAJhvB"߼ /  Ǘ߽@{R@rRVdNJǂ̂(*p4u΁`@Ȃ
aUC	d !]ţ"^
Y釠cxei!ݡ£	 ÉƂ`Ƣa7df!f
`?"dHP ProtectToolsh}lW?ŒǉTBq #j,.qB4PУMmNu<%"T h8' k{-E`O'OHD&J8-.))Tی삪D<D%蕴` g4`dt!(!ϋNb8v"Q ԊO GPuA0V @QlA [_CD
-Pu3(^ !} ^% S:`"AzUK/ %iE _$C0vb@{Q y`9`p$	5 ;?`,W?AT< fO."i	0N	iBlH	͎T] spR@sѿJS#ۊqH@P!H/)Ɛ!eFy bYGq> ߐ Y0ۏ؊ԓ "ł|b͗L 峂kł` k)/)%)Ap< WZq.w"*FD`nDHa(o(f}S@#$'m@\@Z ( IO)F) u
χ(p(?(9(ÞgDu$x#<43ɑ`È|M3 }f=ɉe~^@&@A)F1j5 8cB  BgB㑱B}AȑiO"O cĪ(2ef̯攌8dql@ӔCநaU"1/g'y>EE[Esc] 󉟂@ȍ~ elAիmT.?DriveLock t>[F10 MS  y_ԝ7w`E~: EBSxtkGb@ſO xX~ioiEcUSBP Xp H Zip1_Ԗ 2b 3 U4"567B8910r Fn/Ctrl%?̐ؑ ǯ@{`\p (USA) `|*B#fo+X
KV&Ws
v C\g  }ZJ _ rIo@⬤ {cW˟o%ACY Oڑ͏ͧparlNi!WANj%ML@gBluetoot$g/#jςְ`d 0
qIntel  Execution Disabl!e`0ѯ..1,2O,..odhEthernetX 123 gPq
AOKO3O@$OFj) ID P7bfN P     ' p.cfb pU?ke j] o \(%(*nP/h/!!!MEUv$ )o|ooo)@v!5bv1 : [?d . Џ% ]aO<k2 !gOv3		)$J*   5`$>s'pmj&vSpeedStep  tech?nologyB
uP bh P
_PЯް  c`
x?(b) sF12QibyߚҚ @^```b(1[Bq @dBIOS ATA DMA] v
                                                                                                                                                                                                                                                       <  ` a b c d e f gt" L           	 
    ֒  
         6    (    .             @   / 0 $  3 4 b 5 6   ( )   , - b  * + b  mp
 N % @.   (mmHm$mh+m1m8m?mEm8LmRmXWYm `@E<BB<U> Fب﨨E0`?8l v x|kv||p0p7|c   c 0A   = ~ 
=$$$<   DDD    O aƄe  i  o u ߣ y @  n%Ap E%!IC&O v&U `   Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( )O +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'(M

C$: ?|  s+'()+'* &83&#

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      g|mA  /m^@  .@  bm@ ED @nܾ.mL@R@ \I mp  ?q@TrUArBrCsDsTOuFTuGuHTvP Ja 7 
m9 Be idm"bmcmvfmhm@Q@@  gWm@W{Xt|dU Zt}[}#L + ]~&  WU_t`$itVa!
	$
L 	n 
`	|
l `
t`
6abcDdeDfhPh(>{&`m0@ Z   @
 j( 
( 
r l0 |n o : *R  	mёb $ 9 D՛ VF10 Setup Image_SETUP  PD	Sq  ; 	Г *v
@Jä"IIP a|` 6
&$`jԩC ؄ UTԫTԠU*<g!"$Dcz:S 'ᴳ4U㴴4崵dU鴶4D8b_ : (m]
6  ($)U)$**$+U+$,,$-\C-9 -Qgຄ 0	`9 
E#8Ui3jG@ Ƕ#!" #" #" 
8 RIMt@NOO 8 @
:	 
@      /	&Wc  b" :   %u    Q'U '#(!(")UR)S*T*U+UV+W,X,Y-Z-[.3V
Wmd/dh0hU3dii4dj5jU8dk=kdlLlU\dmBmdnEnUFdoMoG$HpIdqJqK bjmfpq$IrZIs %$\{U |||`|}Uz`}`}`}}U ~|`~~~ (uu, wxU~z{  }t l 
55(4)^By`pB*惨T$]W` 䈧0\']t <
文e3`{GyTaWLR@ \ b Uv @} L@ U@ X z @U @_L@ . UH T j@~U ( ̀} L @ U< V v @U @_L"@ 0 UP d @U @܀}L@ U, F ^ x@U @ЀLU>@ b n  ղ@ЀWL6@ X j Ռ @T@ Z ~  @ 
	 @ * > R ^@ht @ @
@ F Z r @ @
@ $ D d @Ě  @ D d  @Ě
C$ 2 N@fz @ L@ @ b  @ )@!@ L ` U~@ 5ڀ@'@ U( 8 P d@U @M@ B UX l @U @S,@ " & U* .@2:UT l@5 @(/@ Uh   @_L4@ ^ U  @̀ @T ,@ ^   M@*@ 8 UF T b@vU @U @S@@ Z z դ @ WLJ@ p  5 @.@ n @ʀ@ d j  @4@ X   @*A@    @ ?@ 4 > J \@r @΀ @@3@     &@,4< B@HZd l@r @Ī @j @    $ 6J@<BJb@U~ @5ހ  F@ U@ \ | @U @S
!@9@ < T Ul @S
" .@ `  5 @#%@ U\   @S$P@ X  ծ @,%T@W@ v   5@ &@T@ B Cb t@* @2U ' R@   $ D F@JNR V@Z^bDz| @ @Āai@蚀(@b@ 8 ^ | @J).@ l U  @M*`@ L UX r @5  +S@ U< l  @M ,4@ R Ud  @Ā5 -C@ UF N ` h@U @M܀.i@ F Uf x @5 */s@ r    0T p@ f   A	1Z@ r    2@r@ ʀ    3T@C@  * B UV@t U@ S4 X@ L ` Ut @5 @ 5 k@ U, V b r@iiiiA~@ @6@ @ `T "@M 7 @ X |  @%8@f@ N r  @  9 b@ J \T ip@5 @:@s@ Uj   @5ڀ,;@ UN ^ x @U @U @S<@ `  5 @=@@ Ո   
>Tl@ f   ji ?@@ H |  @"@@@ ^ vJ   i 5@A@ U$ 6 ` @ը BT  @ n   M@&C@  5  *D@ Ր   ,ET@@    S*F@@   M :G @  5  *H @ Ur   @ji I@*@ 8 f  @ @ @J@Z@ 
   @0:B R@h* @
iIi@i ViK8 V Ut @Z	iLi< Ud  @ހSM@ Z  5 @N@@ 5  O @ 5  P@@ 5   Q@ t   ,R @   (ST@    M@T@ f  C@ʀښ Ui2B* N j@i@iiDii iL V@ 6 U< N h@zU @SW@@ \ t U @S X@@ 6 V U` x@i Y ê@ R r  @Z@@ ( F f @j [ R@    <@URx @5Ҁ\@ U. J X ^@U @S] @ ^ ~ ՠ @^T _@ B v  5@_ @ %v  @U @S`@ 4 @ UV h@U @ހS
a@ 0 B UV j@~ @̀iiiAڀb@ D ` t @"j @cƪ@ ^ l  @̀% dT@ & B d Uv@ƀ e @ H h  @4 f@@ UT j z @ i @0g @ t j  @h@@    V@i4 R Ҋ Κ@.j@@ *   @e k@ ( B N `@t ܦ@l @ F h  @ʀm @ z j  @&n@3@    @.o@T@    p 9@ z   @q@ r  j @ rҩ* > T@f @Ъ @ s h@    $@,4<R D@ibh U~@ %@ڀ
Yt  UJ Z@v @	Qu@ D \ Ut@ 5@va@ U@ v  @S:w@   Dx@  y@@   z	@   {Ԁ*@   |T 8@ X l  լ@}C* < N ^@2@Z~ Di<Di^@pv @TA @Ā @T@S@ < \ r ՠ@TG@ D Z | U@ M@  @ ^ Ur  @5   -@ h   ij $<@ L `  @ К@@@ @ ^ t @ @覀
@ B b ~ @Ѐ @ X T i@S
@@ t  Ri@ S E@ " : P i^v @ @H@ 2 H b |@J @i iiiiB@@ 8 F \ n@R "ҀS@ \  % @i%M@
J@ 6 UZ | @ @i 2 X@f| @Ī @@e@ ` r R @i @RҮi@̀M@ R U~  @S.y@   5 @@ U@ h v @U @S(@@ ~  U @ i " 4T@iHV f@Պ T @ h   M@ m@ B Uh  @S@@ l  5 @u@ U^   @S@@ v  5 @@ Uh   @M u@ ( U< X h@U @e iiii@4: H@Zl$i
iI@i i@$@ |J   5  @ U^ |  @5؀@@ Ud   @S@ n  M  @ f Ֆ  @*Tw@    S" @   M @@ b Ux  @ڀ@ 	iH@Xx	i @i iii
i6@iHR i\Av @ J@@ v Ֆ  @T@ P Z x U@ S@ X r  @  @ `   @@@ > Z ~ @΀@ ( < J n@ @@ F ` p @j @ V d  j@ր4@ ^ t  ئ@ @ Z j  @U0 < R f@U @5@ UH t  @5ր@@ U`   @M @ b v iiiA @䦀@ : V  @Ȁ@ P ` x @؀$@@ \ ~  @F@  > U\ l@~5 @@2@ U@ j  @Ƅ  @T@P@ R f x U@ S* 5@6@@ ~   T@ l   @ D pR @Ҽ @M@Y@ l 5   @ U2 D T p@i @j @
 ^@ p   @(@  j  @( ߪ@ ~ @ ܀ 
 @ f   @ D@ p   @@[@ t  ޚ @& @ n   @Q A @ R Uj@ S
@ 4 P U^ n@v~U @U @U @S@ P Z f 
v@Ҥ@覀ɀ@ Z J  @	@Sʀ@ R t Ֆ @܀ T@9@ @ \ x i@i  @ j    @ d  J A΀@  5  &@ Մ   T@@ F h  @C рG@ , < R 2f r @i@i1Di @ U4 > F N@An @ @@ ^ p  @$Ԁ@ F j | @ @ D \T @M @ T Uz  @ƀM׀@ H p  @i @ @ N p T i i B@ 6 d  @@ R v  @ր(ۀ@ r j  @$܀@ iZ n@ @j @
@ L t  j@̀ހ#@ P t  @ @ L  iiii`~ @j ?@ D h | @ @ N x j @
C%U < T h@U @ʀ5 
@@ UF |  @5Ѐ@ UN f  @ր T@ & . 8 U@@DHT Un@ S@ ^  5 @ @X@ p   ҺRi4@ D n  Ц@ @ L Z* n ~@bhU@ 5@
@ Uf   @S$뀨@ ~  5 @4@O@ ՞   $T@ j   M@ J@ X Ն  @T@@ x   S  @ f  5 @N@ X if ~@ @ i. i@ T@i^h ip*x @i@ޚ @@ *T 
:R Z@Rh ҄5 2@@   @즀 @ Z p  @ր@ ` ~J  @S@@   M @@ x 5  
 +@ Ud   @S.@   M [@ L Up  @΀C@ B
 R j 2i @Ȁޘ@ii
(T@i H Z@Qba @U @S@ F X U~ @S P@ B h | @  W\@ D X t @ @\,@ D `  @ @"\4@ \ t  @ @\$@ F ` x @ ښ@ @ R h  @⾀\2@ \   @(\b@    |@
\@ U( < P f@Uz @5؀@ UD Z p @U @_	\@ 4 UL l ~@iiiA @
@ < ZT "@M @ " > b ~@%T@ȀM  @ >  R j@z @Ѐ 
\@ , H j @ @ \.@ D T b z@ @ @\UV@ t   }@ \N@ U   @S"@ J ^ J҄ @S @ p   @.@ 0 D@`x @j @5@ R |  @\B@ X   ֦@ @7@ V z  @\&@ Z   @@ pj   $/@     7@ V  R @i _
\@ 0 UR t @SI @U @܀ @T@>@ & 2 8 UH@`~ @
ҼH@ J,\@@ T* n  @5  @ UT ~  @M @ h Ք  @ R@N ~  S!@   S"K@   S
#'@   S$ K@   S% +@   M &@G@ x   '!
T@gt h@hhQhi2$@2%Rz iiiDii@( @ ( 2T aJ@dnUv @M )@6@ l    *\U*@ b l  5@Ԁ+R@ UF T p @հ ,T@ R |  5@(- ?@ UV p  @5ڀ. l@ X ` h T  @}/\:@ UZ x  @ր 0T F@    M@1@d@ d Վ  @2Tq@ v   S3@J@ x   4@8@ . B Z l@v @Ѐ5@I@ R t  @Ҁ6 8@ \  
 @̀iiiPAS7@R@ D X p @"̚ @ 8t@ p   @$9@v@ ~ j  @:@cT@  H p պ @PL@;@B@ L Ud  @Ā5 <@ UP |  @U @  =T@ 2 P  5@؀> @ t   ?T @    @$@@'@ iv @A @     B@@ < LR b ip U@@Ӫ M@C @ z 5  D@/@ p   ET [@ f   M@*F@@  5  G@@ Up   @S,H@@   M 8I@@  5  (J@@ h   Қ
KC@ B v  @T @SL@@  & U. 8@BLUT n@vU @ڀM@ 
@e6 F\T @ND@ Z ~j @ʀ Ol@ J f  @ P@ F r  @ Q @   R@@ j   6S j@   *T@j@   U@    V;@ < Z pJ @C M@W@ R T2@ iDiX@ .* < P V@Ur \˘ղ @YT @ X n  5@
Z@ U: X  @ռ [T@ 4 T j U@ M@\c@ ^ U  @ƀM] p@ B Un  @ @^T @ D \ ~ U@ S_ @ 8 > Uf @M `@ b U  @Sa @ v  M b@@    @cT@q@ & 6 J U^@t U@ Sd@ > Z Uv @M e@@ P Up  @iiiAԚf@ R n  @ښg@@ X ~  @ئh@@ P vR  M i @ 8 UX l@ iĀj@ . H p @ k@ P f x @ @̀*L @l @ z j  @m @ |   n @ V  рR @ @So}@ V  5 @4p@ U` r  @Ҩ @Āj @
q@@ `   @r@@ z j  @*s@>@    t@    u@@ v   v@ dj   w@@ h   x@:@ P t R @J5@y@ Ud (hz @U @_hLj U@Ѐ 5@z @  B X P$ 
i iIi@i i { @ \ |J  @5 @$| @ U^ |  @5؀} 2@ L f  vv7LԀ~W@ 5  *@ 5  >@@ Mƀ  @  M @@  M 0@6@  վ  @ @ \ z C@ i2D P d@i@iiQDi 4L @ A2 8 D@J\t @ @J@ J r  @ L@ : P@ Z p  @ T@E@ 6 T t Ր@ZkL@@@ D j ~ >@LU@Ҁ S$@ \ r ͌ \ քWL @Sn@ j z 5 @@3@ Ul   @Sq@ n   @@W_LH ^ j@| @̀ @
 :@ <D R j@j @ @ 0 H AaL`̀ iiHirA @U @Mo@ @ "\ @j @eJ@ < V %x@  @U  8 H@fx Ҟ @@ T d r @f `Հ@T@ * 6 ;LfL@ H@b~ @@ h   @
@ HR l i@j@b@ L z  j@@ZJ@ * : LUZh |@U @SS@ V x U @րS
 @ ^  5 @@ U\   @M @ t e  @ z   @(@@  *  @iS
@ , H U\ z@ Խ IL s   @j @@ ( 8 H R@JL@ I@n@iҘҮ Ҧ@ T xR  Ҧ5 @&+@ UV t  @5Ҁm@ UL r  @S@   S @Q@ l  M @  5  4 @ 5  @ U   @M@@ L )j C@ ż @2 @ 4 V `i҂Dii @R @ABR5@ @ U0 R l @5
@C@ Ub   @̀ T@@ B \ t U@ S@@ X  բ @T@@ 2 T  ո@ʀT @ > D T Ub@ 5@܀ @@ U: X h @U @S @ T | բ @T@@ Z j  5@@ Ux   @j 8@ 2 L b v@ ֚@@ B Z r @@ < X t @iiiiA  TD@ . J h @" @ @ @ ^ r @L%@ 8 UX n  5ք j@ F Z @ @$ @ L ^ n @ĀP@ * F PJ Z@^ib Uf@n M@@ b Ռ  @T @    @i @ H V f @j &@    &@ @ . ҕ@@Rf7~@ @ŀ@ h j  @A@ t   @@ h  Ț @$Ȁ@ vj   
ɀ3@ n   @2 @  ¦   @ r   @*i: J >rWL\@vU @΀Ԫ @ w@   " *@<@j2L X@dv @ʀA @Β .Qf @ 
 LU,@ $ L@| Ut @ԀMG@ X Uv  @܀S@ T z ՞ @T@>@ b   5@$@ Un   @SԀ@ d  5 @^@ Z  C@D 2BiU a@$2 ifDiҕ@@A R@i @S
@@ " D U^ @M ؀@ p U  @M @ B Uh t @e Ap"ڀA@ X x  @Ȁ   @ . V  @j @,@@ t   j@Ԁ݀@ < R j z@ ܦ@@ > `  @@`@ H f j @ހN@ ` |  @ ̪@؀ @  ( 6 N@dv @j @K@ 0 B X j@~iiiAT 5@ @ T  "@̚ i@ ^ x  @%t@ A%\R z %%@ @ @ T d z@ @"@ L ` v @j @
 ۪@ ( . 4 :@@HN r@ F@0@  M 
7@ n Uz  @ހM(t@ J Uh  @ҀS @g@ ^  U @  "@   4 : N@b*4@  N   @@ h   @)M@ x  B@ @ t   ,.@     m@     @ DJ R \A t @  @ & , 2 8@>DJ P@V^p |@ @ʀ 
$@@ & . QDi@M @ ( UF ` z@ @T@ T x  ռ@܀T@_@ p   M@"@@@ | 5   @ UZ   @S@@ f  5 @@ U\ r  @̀C$ 8 P b@vR2@  l"@ , iLDih @$PnPm/ /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй 
Us# hNfP u	fXc  h UZY[Xg&ۅF ;9   Ã tfPfS
u	p  Vf[f}XRg&u-g&
pAgf&A"fGK  KKf105vg&ƳRK9g&PESWVfW&O*f%OKg&D= $ <vD# D| u:t/T'_^
QRfU

}0tRR>tKdmtE$fu
j0t0t	dp.  f]ZYPSRi uLHSrL&jmsG tu0< 0
Mg'fA$. +"(QwZ "P  u
P! 3 t
 SQV3Ҡimxjwj  :imtzffKfxj AƜ(Y)9wfP98$Њ;`	PKXjj)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>~+A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
cmD$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	Vbm kmff@EFt!hXUgvuN>tO6f뿢bm Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% cmSA _=m# XA	uwjwj>I&BKZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@߾)RK )FbfDf% ffDg7^Z# j^00f 4sp*2{É6^^nBn@& 7Ti({Pfpsf
  @WXfff:0[3`6'E8q4ж3~U L؇gOS?NYY:YYrZ1q\YZ ЍSpk< w !			;/eE1{`eR#tZV(oQ`Cʕ F%frQfRVmmu/(` r'(>  4
P  ~
 @+=ha+( MQ   f3۹ fbdTt ` 0:Q ?\^8ZFfC⁢PS@sw$yk{s>
p"o
d
\Ku@S1?"5`,KuZ'苆FFLKu FQ$Pdm$G^f  @s4j2jgOH^D	%߉D	f:O"-fp<v PfUJ?f@KfffQ$f6f> f	>fBf0+ff]X߀ t p,rPԁf_z0R0Ӄfw3 Z`R҃>/ t5  A U@@!`0ӳ
@lAԟGRV&H:f;tff) F#$A^q$e sqSf qgfÈ>  fù fAB;t)gf+ C kB;PEQM`?k ӒHGPV  ^ h2 ;uБ;~ ;b 6P6UXfm.0XR @ y  	`@  Q}o+p+ r3!B +!;PՁ  UVEWT-.55\EFGG-8. UWRQSPV@3rw+t ur6ffWRP0 eXh<fZf_;>+uƴ+kmaPS puve+i@g+j+a+U/xklb+znmc+D[XF f sf tf[ Ȑ![YZ_]e È++0_Q `+ cmPcm j0fdqtu!+! !ddfd԰  >P6Sd ddP ʱ(++ fU0t=T=f]t,>@u%ttt t	tfsN 0Et@)r@ua`ln)s
 1Qh 6*tLuFk . u$,
VێeS tLrt.ـ?и{D`*fdofeT ff/fXs "qy#uptLe|+ ` }+ uYpf3f$ fe|+LfWpe*&|+8fw*fF*2t*܊e&}+fXAf`PKem)'*!(++ f?꤫"Z  Āu(!`v]+6R p(Q?faSQVWU&dm tdm &6i]aLS-120ZIP 25M0 RV:1:o2:p2o2PKp
>w
 z
\5	d+?>s!hErg;<tV< uWQ/f< Q:D= uFfG(*>X!X  A0`u v+Qfmo+i+p+j+a+v0 RW1h
ȿtK} tEA8/'_Z[M-Sys   DiskOnKey 1 #߅axBgm u @  f<x fP f0Q1"%|= 2rޒ 0w"1{s ȧsU3IH tuRfQf@fPuLst6Lu2r)g&	ug&g&oc\,f_߸ PA߉ rLT2f<Q?GQkRlRQbV`cF5Qome}?:(į;0h:jt@ u u#P-3RAwf?LfHS N 
~1fXuײ?D0U @0zB0hB0nB0mB0cG05F6F 	 )<g&3FPRrco3W1>#>;!2>
g>_ÈYh|PhN`p&P  h*l ZXSWހ` 1s!$?
u$˄[          Ұ,X @x^0 uY rTB5_!0c@  i|X  t V  ` 	b?ho4<_fH f5fo0cЉf&^h/uf^06.f ff5fP  5f%@ף% @ B5f  z6f5f=A&  ` AVf˺aDf=%t 5t;@3tZ0tZ鑠DfkX$g];6  5Iۼ5Sf@ t|P5"s~ tD~f q55<5f>5 u x` _D  2ft.0c@P +rfu$Q5@s11 _>5@!R05'r"b"0  <1VC@f,S	  tX	艧*rH'	"	0 
%9 uf-%tq0ұ0 P35*P  	P5;tpa '	5 :  rf 
 BpQDP؊*5@6Pf>5gGf	gOg{G]`db>:芓"3	0	5
`6@#Du	%&0cf65f	f 5fIng^_g~WӋ!
*t4h 0		0	}  FFhzJԆ<t
 &6H5q*p09u
 'X*؃ C0H&2H5&4HqN&xbLK6%@( 5f (f 42a3uf5W  bof~t0awSgff95u gF95u 95u
gF957tgHNXfF_5zr=БC=0rxiGsVfS'`c(gF'	5g^ g"G0g[F V*' /e*emd&b&g&g&G
0G
 dЪGd*PGg&Gg&G
 G 3g[n Fpp5Ot	f AkG^ 0\PfV cssf@mdf p^fIf!5&55+5(5  5 < t5  ;vȉ5qv o f@
BqygfgG p ,gZG
	qGfu"a ?Hf%fE@ !gG!&55 t@bk!f#pFwcnɚ`_OB'PRx7з[fS
f30Vf$fӃ\Qfp<#{-  !Si y s9t ```*`a`b	`c		0]	0^	  
		 
							
 0hfoWQf`!Yf_`њD=fr+D=q+@D
$>g+%
ĈD
+"r%詿 >q+bcASes?+rI`d
Qr7R|= USBSug&|=w t t
U	 	`+cTZ +QΡ p arQ?r C0& z%rP`6@`2P>+?t QrIt2Q9fF`AdYrٜSf1fM^!WA@@H\
w؀e܉\b< H
p*rvA
x @
`0
!?
0
"sTq
=aWa'"CS# iD=qp*W.?43'PT2' oZ(Z
}2(
y_7
|_=%t99 R$RS$2Q	@ ?VEB@RP2 3* h >,bLu ᠅ T=
yXS<(fT= & y#j6~+~+ r}fPQtA3`>|+|+p+` pta^Vu6} }+ +.ZEf.6VEOPpYfX`VEI|G<`+ fa9?,B3U+*/G/%QfPfph`1@YfXY"N0\J?;G7/Osc`MoDABA<e=S$l=38%rp-+VLt9 tLtE hLtQ+D$
ƈDFP!r r
9rY⹖ /p%tFܳPtt=tT= t2:t+u:u hNodty(u~(rt{^@VL=@ttL=thL=`	tbL= VLh)6`oXaPSV+8dtd}wmޠrgހoa޾+8DtD$P}Q@HPhBޠd<^[XSQ?O	8t`g	G	Y[L0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *8۝6?T!
  	b.>  
   UKUKo      2@SJ[PuK&|KО!i$ru
>;uK * | > X * t|KxKxK>xKuKu} UKFϰ'PSCrzK$zzzOKuKQKwKgΓQ	`=P/$`
3ۊ `"K&K&K L3 wKpVSbm@t	V5m[^@pVcmTK "`K1m!f4 uՀuq!ߧS1-mNKBMm68Հdm[^pqq?fUo>cmimS>L>im&Ldmt(
߿RKcmZ SKK[@vf]AA`Ft>}K{K r1Kw%0r
 "cm6x҈0EUK hm6bKdhEYTQ!R) `* aӀQ	k pt1Kh[L!rL&jmSKimLfPSQзKf3fY[fR~Kfлf3 0NpfZ2F E *  <FuL3t	 Dt<Hut2Ot~O >Ȁ$u tPaX]L Y7K uB<Ft<Tt<et<t<t<Rw*<Ir&L
2@&tO>L`O4<4quri+VW@ξ H_tAQ Zft(PǴ:Lu 
  gXfoCYPv q9~ w2LkLDt& L8r ڱ>taRw
$_^t0%GKLK IKf? t<CpR<tSQLذ&Y[ـ u
lqpJ@I - n ig8  ; `  8thx
 p  }0  %p 	 	 	 q
		
	 						p
 

  fWQf04aQY`f D5 ,+6]++sR (,+z0SD
$&++
ĈD
 1s fg&|5 EBr`jr  a_`fR))	\		MvR`UR		`RH\
|*+
܉\*se bSxQoaS͠ϟ" cc͐Ăr`*͏͈-̈́&p}_W3
	#rgqW?t0?Y"@ fUԯj(~rjd*u6Dأq=UUآUpfqh		Yv		xfvbF
 T `&ӹ !sJ%|=td%"y:ur?rpq!(~rg찯2oQVfRL	;t	PAϦϞ=}^A Q0   0    RrE d    n  A` P 00 3`*  
& Aa %  	%
0 #
ک*!
+ 
3`@q& <a`̋ @ @  
b
	@CF
? ?a	 " d  qa	!? % %@%(
 +3F	
 + (E+(
3$ 4̂ C8$+ (3+-E-(C -0294-  (`(E E3 . c+! 0
 @/9F. 7'GC@< 6A6D
!:7'  "J",A!E?9B@p,3
O<bJ# 
QT S<R"G 3D%M TVaXACJ UK8@'(XAIc  WI Q^_^`FaaAbbCopyright (c) 2001 Intel Corporationf`@ f.5<t<t$<tc<tK<tS^f&^2c sf^?   uh   uRRfADf380=ISGuђ s
g]^o!t f6^	ngftcRa tpt5H0c @u  u u0 ߰#> 2  P f%ᘅ3 
f>5fDt	u)f5%;5wuf@f?fhztff"Qtpυѣ
0of1s\
B  v@#tyz210~!<ugb


7	u\	Q	'h/%_5Kf65	g u%S F5 s@[%;u!,'f=4R0	ff4	)ffp	Q(f	f'@f[aSfSfQfRfV*sW2c15 uBT tApN@76g88fI4g^f3f@70	@7f^fZfYf[fP"Vf~
5f=`Bt"f=Ё &f= 0//f=0ށ 3f=@+=t8_t34 , 't"#
ttf5c0 rfFP0fXURf.  fXr  	 QfpufQD8}@M TR2p@(2Of2f0&cBZ{RO>V\3h/a+( MQ  uf3^fbDf6E  =Z<tatG@]_ToKg<u	.upWJ$< t<0t$ RHP?ky"PWT%j_uPlAP#,RfWPR;5r/fc%1f f>a-	f!Effg8uU#>_444
f@[Jf_,,PSt{w&+1=`Q
Yr;f.;ft3Uuff!mpf|ffm~ fPtP= v	 +v:P,P}ff́   :ffP ̠ 6f1|Ã tL;f ǰǋPtf Q.fB	r;}rf@u0`b h{+-Ña	rffqp
C	f`f"0~ffROMIfMA{GE@;uq Wt#g0 yKPQ (J 2 ofG f_ZYXug&wag&GwG0  "2/t"t Ρ V   Ĝcu'[0i&w j3
G94g&GGf{ԣ fCf-+kӸ00pD;gf@ h쀀1"`W, `П`..+`B@ԑ
?>t1a }  #Z   P A :Pnj>jFjNjVj^jfjMSV.>bm tvJj^>Q PSQRVW>vjujSRP#u<v
@wj,xjimujʀ 7UmwG r ) ?褵!עujјP込S	%x
vjvjvj:ujw/:jP
 hN/L	c tOde
	jjrg&0tRj觴}rZj莴_dr!"BjuKr
 JthE	/CZp4tĳbj&=2ohs13
	u_cmP $cm} Xp Z#,׶[$$_^SZYe**	Q  !   0 / " "2ѷʉi /f+Ld 4'=m$7g&* 	uwjwj w@MKm &Eomݲ`J"p,@vō}p-s0D0Km,0$ 03۰ ɀ]%1u> &
'$udmuvtueu^\uMu:8FPu)ttfu,0= ILfg&8!<u	g&g `=FtF@sPVS`@m蛱O([^XSRVmWg^__C@ޕܑ14ZbUf%0ѫk$蔴/[]0)R ZoWR  oP&abpZ&&FdR< u\ؗR\RgtXr),wu@TRG`SQr9R'$8tYtr$V簄O㰆HAr(bgFr(W!sqtrp@ppq9``æ  f18 f܀g'0z  p FFBZss`b PQfWfVӝUU~*ЌP U hIX+U'UG@J  .;qt3_YXh>5  `#`ȷ0@	׀p0 "' J@4 "`".im2'.q q㐰0 0!W
sfUgg& suf3_Ɋfа ǯtfY}VfWsg<t,fUzgR r!8tfG^fZPQ1$@a@8tPQqUvPKtF Xʿ PS2&8tp 6t؎[XPSR8tqaAf!.bSRغ P BDð1                                                                                                                                                                                                                                                                                                                                                                                                                                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              - ,-./01289       Z `a     3 sRRFa` $a,PG3""
P![2t*:aÜ`>@ l>0l!GA lBla6$?C ! G @ A  B  $0sF  ؎v n "v   BnnnJF$a %JF P  <  tq ̢ P  ̡t u     llB  ؿ/  lBB@_  l@    @ lr Т_s N?&O 'f l  /$а 
@  
FF/n  	Un	n	n	n	n	n	nnn 
 r s п t  a  aACd̀`  3nnCy q
p		 nA
}` nta4u4aPfW@ f4g&g&wf_X' =                    S %0FL$ tXST MS7% u BMK aSRP t@B u$Z[SfQWP #Xgg_fY[f`Q
`fgfafQRfWPSf3f3ɿOf0<  P tPf; X tDtN[Xf_ZfY<fPffffX,fV>fVf PJE gf^! f^	V	R				:	^	N	^	n	f	W		fWf	_
g&' f @f&:ÿfPSQWV!  tOъ##"A$#hfP u	fXc  h TQ lsY^_Y[fX>uD`臿t跡`X X3S'[C vS3ۀ> tVt't:'tC  [0Ot<w>t8t,>+訬
 
. a r t3C,赬軬 '.'쾊'
t rn3肒s}<5fP@ &'r! 

A.	 fX`{gt

"3jgd
A
{ 0t1-b㋇'._fr
Rot0
s< t
t:@ `  ' > u蹫t' aÉ  HJ 

pP IF  J9 @ ؃?@P 2L
s3y@si  Y 11F0JKMo蟪:Ju;pu;th;prPs{`us 0!  PWu0+K׀`{:u~r:@&u=[  OuA 7 &	&Q[m%0ww
2:rp	R
À
v ><  _]22 f`8P%AȰ#%z  t
ف     t1sPR 0@ZXW t(  
Xt
 %@  Pé t u>0M 9  t`@ r3pt%%tNtGcȿ fp|ff3uԖ[fff#f  
f!]+ mX sà^R.Q#؁_ ~U~	c	%@Q# Y3#0Ћ!` ZsY[0
x uiʳ # `uP
 p=
> Pj%蟀t
z%fZenQ ص!f~p f#A$! 5 qq fAr 
 `!Zqf@f0` SP!3P#5u
=1"qf'ZYfoPS4IST Th|uus}R^1Ar5   f-74O-K#3p؀*@uRttQ@t
w1
uf
cd@} fSifI!2HtEPG Fp  P+GhoNt :Q ]j /d3 @G4g&tC@r1ft.fƛ3A QAy Т  u1  dhQ)
  '  emimh+af@$g#4h"A& b
 babRp  ZPQu#4 pyKqVb pYR0Rim hH":	
2
.&g t#.9g@X' T
.t&*0 0RVh:j_BԷtDh̹hf5h1h7r2, f^fZf`2 =rb2 <ГfgTg
hMfa~f`uX
@`Pf3۰//8PcX!7"" h{ܪ=Qf`/)
4/O
\ "	 	 R"	s/	(	!e&!_!!!p!h:tÓhI;v"GA	qf~xf0&u 2Rt F<tP$rfe@03d^tsfQVW 0 _^Y}Tf  Df1fyft
{tP%SyQy隐gf75rSQ?
f  %P@[^ЛWWVhU?4r=ыt
 u	  tt uʋ?^_r7fQf:Eb3:EF c6W p 2:> u6 GH\o h$yi/T3Ҭ؋hB^_fZfj
XK̈́
{>
2
Y
VT[>T2@OHp
Nt.
OϏrb   ,$,/ ,aYaQo/ / /  O,<RwS2.A[ø  ߍа

ȟfQh3_fYwщ ;aEf3ɋP*p`0X݋&G     &Wfހt ffBf;ۇPgfww~rtwRtpff}@hDp3QgfY tghpo#a$%AP0Y[0U>aPS 2h>yWh`$2f[ t=> uJ *ۀ>p u0ihv}_"˖tv;跖t踕3裖tPds5 t&
 0PX蘨> tp 	du
)[P
[` Ǻu9 5r/<t+t&Pu
$&}.-aq貕t"Qtq2t`g&G Q !t苓u)ʷu>ʶw&}t z &  0 &  
$À>ް 
8s   
t V$<
v
  `
 t>  t K
$
ؐ _
h|?aŸ$(
d t$؊ ^рhY%

5d			
s	 迶	,Amu  &    >  u
8wpR 4
A "N`ff@Af   f>f BqC?0Q'  @/%dBPh p>ft	p'f%pң  }@!GÀX<t<t<kPS$<w .#߸ 
*"  T 6 PR0a#Z 1.a# BZ s  ""
ZP .좵## Jq vJúQ R (% PBǅX
	`ذ4Z![QSW 0_[ $$$$$$$$$$% "  }8s _%à@ PP  ~̀R ĺ,p:3%  !13*  o/ƥf 33 3:~  h M (`v: PQW<u
yޡ ){p^_ 8+z )k|"~	ðh~jA譻s@1  @ZtpEu%hӟ/4u C/qr>!r> u߰,[
>PQ& @r@us
 
Rxy& o$۠P`v̠XâGա  	!  , 	% O
'9'p  +&,D( + K( 	ϵ	! ,% ''(((+avy(0 f(  3:)(% p0.&, J(v>脐wJ(J(2諽p,s 2vvcvUV<2u2 Pظ $
 t[.ss>%`se^]osks2 	?s()S rc`.)[S蒛raC.t 腴rDGou_p;ᗀ؀ˀAO2f.f`7xf.q ?^hż?4 1;@rCd. <b d= ohǰu @P4 hf*.b*=@>h:j/uhdLPduuu&gq Pp  1g[PyXh$eh6LUvP^+F Xʿ PS&K+&I+&G+[XPSK+I+G+@#/#h! + ++$q7zɳ~D'ktS8rdd`r200<dr
d2wc蚫`ޜ pаySt?\05ak0p,7Sq`WT 2HYo?&`8`z`K                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                                                                                                                                                                                                                                                               鿩!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ?( )(     ښ    ς  g `g  h } k   ;p    /\ k3h wmU4 
S          P        (  %X%H_&                                                                                     `*} ` Pz*Q@ U   @U 	@U
 
@UP X@UYhi j@Uklm n@eo { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`hfPu	fXc  h  fUf&af&>` 6a Ͷ !ŀX[ &SP`@ /'aߝ&&@r
f3fgf }f3fh   _@p h &ïީf`f1fffeWf   % ŀ-ff0M00!0)ffXf9ffaf 
  fUi@] 0 m uq  ,f5q f^PeP Q   ͪAp  A` e׃fama  !6>eуp Ń ՃPك"` ew w	
e} fe&:` b "jeɃffefAffgd:ugdfepf3 ~gCTʰ "8fF3ۊde3 
tdg	  p)O @ 
pezu{xu.G_RT=C u:/
'
%&bfgfd.S` [WP9A`XP&EX% &E_YǨ dooooǸoce  f`Fffut$up$Ūur  .<t
../ NA NfafPSwRV5fpr؀tU./tSA
 NUN}2h?54^^Z[fXn34 PSWR/Qa>tK u&E q 7eZ_[Xðhc_gÀ> tQ/_
fQs]GPSfQW貿_fY[X 33 3?3øPR0B1Z 0B13 $ `%>&2%	 
  3  t!  {} 9 z &@u#92h2_xrt0RW0_Zw LM	5'fSSR1Uh?Af o   f0Lfs$R8 f}ZI%CPRrfPmTmf!`'yS'b'
b
R)	t2*[w.>*"s aPQRp쨀t hE/t
uZYp5' B!C
O<@h1` N H B!<06102* $ /fW 0oOQg&?t"g&Gbg&Gbu۰ Qq& ufAwκ(/ 
.uf_ 5`mP    NumaÊa$$
a C. PB _B;ra 50͘Q8&S/88@
,0Vu:* : ,
 ~Q2RWĺZP },ȡ%:؁ Ë34 g&D4eD
 <.G   VUVVYXJ oI 1UWh:j<?%Dt$hAfYOYV6@Sl`eDDDtDۀ (g[@a HF@r[M t"s@#& >tS ^h.f
$1!/f2f3f% g0(p!P!q  f@
10XX!!pafgff%lffP]  R
 `C  fA"a `nGPL\Ϩt`# u8$Ou0	u,hTPuX(qt
*DSjyљ֙6ݚ"Gf`Aa  6&P{&~`X v
``.pr&&r!Br  Pq X
䏀  Pf' __}X}10uff	<u <u õr$Rr z&&X2qrr]rN a`z7da(Svx^Q` ؾ"" QYa?UP  r&&p'] Ob 
y' P"S""F"&&Va bR ~ ZQRr빸3'H2't2 `2ٵ?)w5߀ ttTZYa~r#S-EnR-Y03|!pٸ{q4  f &o Z2 &r豂r8t320`.PO h?,啊tGoS@1?eh%[&M.2t $:Dp#h ?*5 )W< t N)4fRh$2hfNt :Q j h1h<fZrj  pv~w@߰5 
, #!`e`	A	2@ahi
$%00`P 0𸹨S%-  ߃D c`6(   ڐ pM V魆ī^`WП 3 _r- Q+˸ fDZEDr;Հ BЙB O B<`<2rruO0W2&*G_YS	 }7&*,u&}Z`wE1j_[DAP`QFگ> P 2ۃ<OtY	B<tmHm777rPBBLѯ: r1 r,q? h/Dd8SQk
peat)|$<Pt+fKuҴhqiB`UY[Qrj @"	ѴuOBanYo|of	V o^W mQfR	 D=F==rN|UtGV Qk4^t1Vh㍬_45f^Df`      $B       <@ D ` d h` _     ܢw @  `Ub  ܠH P X \HT                       `        14       eb(L'0#` P  @ _   Pa !( '     PXYhijklmno 	

 ?                  K _,89:5?NNO OhX__'PfS{fWebf(sfgf&c@pOZ	(нf_f[fX`Drf[XpbVW f Q  !Q  A!!ȑf%C`f3f.ff^u_^fZfYf"Q ء f' Cգ
f0P3XPSVWfQs:atKي t
u uffpv @uf  fY_^[XQfWfVff
 5ff  pf  f`   <fd0t<$4'pf^fC_YA <bR5   ;f^fPSQR|# 3%n0%B@ fq$<s! !PB@6G%<"**f GjF|
sKf0$P
f>~	@
 op/'B?<$
sǺ$  fޭ`85Xp4'o%:ZYc-9%@8SQ$
 $
vu$wXyu@$- @x+f_=  Ds ; Z x  p 0Nm[$
Pdu	q @2wXÃ&	 %_ H裀ȃIذJ芀2ȉ{,' 'ff w	.h <.a  a-$tҽµ 00hQYhrEϰd/(#/Jo'1*/"YïghmAGf>QPH_u(Dr#1 Oftp!2 '46-r(*Qp% -ro|nUWp(>f  t ` tf} frw@W   _`ff!`2g&g
fKffRg&& gre hջur}e*`fVh(Z,
- xф r k s?fbSfRj07W6uLt;wEf6ff8 r/fRebfBfPerf. 0  Z`fWu
 a 酀>_ PÀff`!u? t]ǀ t
WtAe@zYf?
: :  }(! _ f` ; 6frv`gGwf3Pz fˠyfzfPr: > ff@;w!fVg&f^ufFtfafQ~C3$pftQg&90908&pof=ATADtlf q:&Ǉ qp s  S3*a  z[b z1 w龁 0还z3Ɋ y{j qzUFWP
 XUu&.>:   ub >u `	`	ytp$ll0yyPޑ$yC#	


 @`W3  dt1fMd vYP`A BC_.ܱfUf.6f]Wf]aeaa** End SetActiveDisplays: \ !$Tt5< ux )ڊ 8t  u
8ud a9ܠSe[00t@uSQ2t7:P  _x@@߰ p#tS Q<uȸ
  uϱ`Q 	?
30p ~ D q t1
S
L_
   Pݳ	 ޳]e`ߠR	X޳9 SRRoPkoP %p`jo[oċ ZoXRoX8opNPSR10+#	oa\nPab tAnP ÀnXn۠ nQRPS [X"3t zv  
\U  Hp@`6
u&jpr
u02,RW_Zr&&&E&]ж  faP$<???M=E>@. SQWU]hWPAXð PR Z} .a;tH rXt A`ft,` w`C_wS" Qr f $~ >Pָ`Xp!rpC f_`uQ`Mt'f ITAfgf혱P 2gaYld 
0`tXW
Hpc=&M_0g.g͵ 궃? t0;r+g/CC PsGPhih0BaArJ`P!uu& tQ Py Pf pԊ6`t @.d  w >{`QOa8tY*_O# Qj<.uO R%K&0f
1
fpDtzl?Ͽ 8 Atu p\u3鈰u#Q?G`
u"Qh$9u
3kuC*u?sr'p !lru#itg&ON  r  ٹ1OCk0`u֣>l  !{纪@,fSIMWuUf~ عfPr޹fAf1f;w(hzvrGap 1ð~?SECUQCuBfgӐ1R 2(`XfGPu(1_-p$8tT q Gt+Soh
 oTT<tTo]A:zohݿ
 
ʻ@  G5 -ffLw	ßPl& t
W&f_r2e Y$g& g&	2ғWVWfGt0bt2t~tyf m   f'@,( @ @ u~^u  rFf;r> : t, f    ur%P~)rQY9	 q8V  %@Ot`jA
A!:0.2 r&q
"

rTr ~V!rP#j   t
ff;t;0
 + t DU@@D^@ ?hO,9hfNt :Q j r}wp		  u ff!` B
fffGLp 


gwhghNRF
a3`"t3 v'%h
9GܽѺfQV1
P6<t12:u"FI1()
LD1' FE-fY`7@? w.	A_S 
fUfp>@	 --


f+>
B#f]^R)""w"  ,gbX7vI? An@uY`$f!Q %  
`È_#_#_#ZYcUTp>vfrg@)m*S+r Ԃ0`PPQ>d uι c r\d`dYCtCd>r-R`w  r0Ҋ1 r
-u`d P rdItf so`QRpyn0ЪNr&Kr! [ww3҆r r	?PPRc0ߡprԿ 
 Z蛄PQq	s
d Sr	r!V>RP   dtgg3{uwR Z +}hk-C ZXUR. PPQ " Y  2  p,u QP hE\3R

Z@u@Sذ* o rı` ္ IQ RR ê rPPDC	I 4~P>S t33@J*0`R
t#4 c ttpÈXQRWVŹ+3"a^_Z#"#31$G<u
t$V 4^wW _ O"  !(e
Ź R	
R
q0P#H	
gg&/ܱ1q;-r;r;x;q;PR(X 蕐J2oZq 0[RVа$rN ;rCr<,	r32;trr;wҀ tsڋ^ZW
   е0u
ШBu P f [uf(2 J33o22t@@ 0 	rn
$	"
upmƋ߱d;sRZ3QFqF2t
2t	u˸
S_ø
_{..P.Q.Q.Q.6r.Y.2YDذVPC`D]f #g&   hp<LtfPfb` CuGfX2XU øD	d dpx0x)pv<	<@ Q{}>C? zBJ1D2FJC 
كEIڄ#t
N ~fqq f+fMɿf-Ef/fófqC  f>PAMSuff>r^0ܭwS0p(P`#X>ȸ f|	! Mf#SIIWV`0rY  E`/fP < u 󤏢orfcQ fQh1h^`b
h:jLt.ԜrB  ؾ@
E@u@
/Pk
`mGfސt0!0 I"a`Ej uL$<tD"ЎQHr&=t&} tV" &GF^YՃ"
\aþ0 	 hy+!9
' 
9


Z9
P9
	

 



	h@gMLொ~̀RȯRغ0 t@ZгB 4 < jf <2<
 1_                                                              HUPRPRVFZX˾0RR30ZO                              5ȎP ЍYӋh}3 u<
w'>pp'b w	'ñ03fPS> t=u7 u1 *<t&t!uoVr0`r	B [fXQfWyLtZgf&gtKfVr3g&G spw0ar$
 !O 2_f_YPLtg&G?"r KtEtQ@ 	
 ?  VȾ 8t"8tr;2^SQw^Y[t,&
uۢ>ut
$6sE t>g uM"t$	&
sD
tFڠ	>2
X*T@$t% I
Q`4uf0otC P p< t &$  
` uYߴ&ۑ> ؀
	 >t LtW00P'u@g *r$@, Bt׀>1u
 dA ) (r"/t 襽JJ]SQPXtV
r@.pSGjItB0T0}.7r//Y`6It_6etP 	rB3_,s6u%
u "i7H6 RE6Atzu Qطcبtb;sW;sa^Qu	Iu u"
urڑ"
238Q,.  àڢ.dt b* .s)P16tXSfW0`
GtpD_8؊f_[&ֳ֖fsg]  r
î,# fPRfQfSff%|h f
 1 f4Af# uOf3\f `(,#%9t[f!!1 f{0 t0f.f@Ff`f[fYZ0Z! R`ܸȿ ?[ݑݟCfW @ fg&W u8  *ՠt fqlt	5wf mf_À f] p<Zu?FrF /<E@ h^Nt :Q j f
`qs 'fpa$
w
0
ú:ckt/f@
@# Sz @{ D 1d u"AuCO "    t 	Of@ @1 !b1@U	ـ@g&Nf@  % o&!#&pR%0(+1#Q~Ru-f#f %3+ރ8` $B
' $ 
 f 3 Q'
f~/
ސZS	v*
 N'١'p
f1?f ޠ
s#!=qfYWfĳ & A%#@3RSo؁@!^ySCVq#t6D8 %f&ȿ ffP]t33u^ Zfp
0jR3һX3t@߃s7rS
`'`' h%Z@g! o
 * I40*ZT$BT0	f%0OJoÖD&$Xb P1T؃2g沱1B'pRfZwa`1غ   nBnnntnJFn aS [ À 3ێ7!C &?!Cu3ۏR .Zh3fP 	fXc  h f:{{ƲXj]]H&::;色>&.pu	| muQ %FP
 ^tPFtǬ+t8QWP3 PhX@.X=X@uX_YPD߰up$ q!.$> u
P|H@Xuð6_C @B T ASQgfsg tHfu.g :f`tg&ff(1(`2ffߋgfff<<(.~&gfwBfs~DP
hCf!!
#4	fRWc6U t3 

n(
uXOe0fMIQHBf   ti@GVp Up he,zaRÃHt%tg&g!gg@f`MRft9tg>E @9g5CggfVf),g>߈E %g> !Pq'^d`g
ز
".*   #b^Of᠞ "Q1落` 1YaA,.028 <$ 7@`' &F 
֐e| 8ƻ6
.K`Ⱥ  -  q&aiu Nx  
?| j0 ;tARm cmPffX ffпc-pః0fa  Z!` 
a1!prR 33#|fp<?f
 
v@f b}%\h{a# =(p@  u R#rSza⩋f HCsth'cRѱQa!% = u5
== uu=  7a`x!gwfx㮰f#b 98P3	<HA!+ 񳂰rbߺPѠ UQ   ,A048 N@?W$9#5 A C0` 2hD_foֳp3 P߀/f4f!➸Y zAt[f7p2 Q7t2? t,/fP _$!$i!Re'ç'1', лZiq   iPQ tu
}qYXPPv` u 
X`;؎Rf쨀u Zl?fap.%nش @@(00	kEf pǡ D  &Et"D  $D(w s`ف&t}ʀ 4>2@"oQ
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
` ݂ m  m qm p's 0 _ ar * $·OQa	 & a1# $$<@t"hXO=4KuK0󨀯Ku`.>*"st&3r	&*1r>m胣{xaô`prr X ? trKCr0}qw1#!8Q909$蹪a0){fRQS>[YfZt'0݀ t 
|  .ar0QP
ADȁmG}>Pv Pf  hruf>覾rf  jfj`r<fffHff#f+ִ f;wfa3oS ec
uff+f뺀
  ú,/ ,(.w9!Z| Y	lK E,V,
	+$~,"c2D,)>Ȳ)t iʺ, ,
,b,,&,,,=diƗޠ	}D;f.ߝ +!u<u<vw2.А;f&@ Sذs9r9p'[fSfam;xV4tpw? uП_&[ff[8ø 8p'`^W!h...6ߴ赛l" !]2R'fhfLs"Q#8@+.7h g\r0A@fP@@.C'6fAlqm	sdr
=hC1hMy<s6Gjhi=IJydPD@ hsxW`"D H.ȧt_fY0Vر0&wλQYf^ jR5O_'ClRQ,)h嚟ӏw;q4B+ràq"ðG5	  蜰k ݊P5ĳ7PP6Xu/BBpDm/6b5S!R u5; |5?*/2P x5X	S5@62[`P2
tˀ~a	5$

6Àu!5<X[X Ñߊ Qa5a
52~  /Y@<KrKKX
03!4+t
3NO+t3GNO`UNN쪺P RzSR`3`PS                                                           0   
,OG $d            p                                                                      G  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  J68DTA   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 iys谂 f    Q?sY 戰f
   ff    f   tf ff
  rfBYi戰Yf3gC &f3f   戰 fHr4f f戰䈰xf戰 rfFf    戰戰3{f  f   f戰fSf[f   f   3f   f  戰g&fFfCg戰{}s 撰fPfSfQf   fQf3یff
    xfYsfYf[fXSgu
  ;u[fPfSfQfRfWf   f3یff
  	 wfBf    f3g}
    fg
  r%fG;wg}
  f_fZfYf[fX  fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   (fsf ff   fT   (fsf wfD   f @(fsf [(fsf 5)fsf )fsf c1)fsf MG)fsf 7])fsf !s)fsf )fsf 7)fsf )fsf 3	)fsf 	)fsf 
)fsf F
f   t*fsf c
n&*fsf xX<*fsf 
BnnfLg&nffOg&fffsf fsf f   f   *fsf f~fs*fsf ef   *fsf F<|*fsf  6*fsf j
+fsf +fsf -+fsf x=+fsf =f   tV+fsf f+fsf of   t+fsf h+fsf +fsf S+fsf +fsf &f   u+fsf "+fsf +fsf Y&,fsf ,fsf )'(,fsf L'8,fsf 'f   N,fsf <wb,fsf 4 f%"f   t
f>Agf  ,fsf {ta$f  ,fsf ;Ff  ,fsf Df  ,fsf    Iuf  -fsf f fsff   f   f   P-fsf tff Ag&uf-fsf &r8u:-fsf &u$f3f   u
ffuf   tf fsf   -fsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  t.fsf $f  .fsf i2Df  .fsf rf  .fsf 6   Iu f fsf   ffuf
/fsf %tf   ),/fsf $8uf   uffuf fsff   ftLt/fsf $f   t$<t)<t//fsf $ufffff   uf fsff   ft(
/fsf 8$<t<tfffff   uf fsf   t8f   ftF0fsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tTT0f   1fsf $t<tff @   f 51fsf "2  +O2._1fsf "<  ff   f.:w .D1fsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2Tff   f
.f   2f   f   ft/2fsf !< t8stff   uffff fs2Tff   f
.f   2f   ft(%3fsf  < t8stff   uff ff fs2Tff   f
.f   2f   ft(3fsf  < t8stff   uffff fsf   f    ft'3fsf $ $t<s
f   <tff   ufff fsf   ftT4fsf uff   uf fs2Tff   f
.f   2f   ft($4fsf m< t8stff   uf?fff fsfffsf fsf 2Tff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%_f   t_.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfT2.<u f   t2kf   uff   u6fsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   37fsf <|f`Agf&   f    f    f   r7fsf f    f    3f   ft7fsf Ufft7fsf ;fft7fsf !fft7fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   8fsf <|g&f~fsf fsfLf   f3f3ftr2f   t8fsf Qtf˰8fsf 5<	rIа9fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx_.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8_  f Lgf&fftf_  f~fsffHfuff Lgf&f   ftf@l<fsf f Lgf&fftf^  f   tf^  f^  f   tf_  f Lgf&fpffHf   tfHf~fs<fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	=fsf fBgf&=fsf  =fsf  Tff%   f
fHf   t
.f@Cg&Tff%   f
fHf   t
.fCg&fKgf&I>fsf Ff fs侳Tff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsTff%   f
fHf   t UfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}_.fDg&(_σ.fDg&.DfDg&f3Uf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`[f~fsfffsf fsf f Ef   .@ fffsf fsf Xfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_Bfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
_fHf   t_fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	_f   t_f~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H_f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fH  Hfffsf fsf f x_.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|_  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xHfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfT  f Lgf&f   tfT  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+`  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk`  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            D   @    L       @       H         `      T    G R         	 	
     X   	 	       	 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D     X      P    D    X      P    `                O    O    
Ol`

Ol`
Ol`	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <D	     <D	     <D	    <D	    ,<D	    ,<D	    ,<D	    	,<D	    	 T <D	    , <D	    ,0<D	    ,<D	    ,<D	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                                       	4 @      T                      d  ` h   X  ?     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<D	     #<D	    P0#<D	    @#<D	    PP#<D	    	 #   !    8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < fmf%f  $f$
t)ppqtfKmfupppppqemDfqm{fupppppqf  f  gffLggf^gfnf    f
   "靼fm!fupppppqg- fmffnff  @$f@$
= u$<& fDnff  @$f@$
и f  D$fD$
аfnaf% = ufnEf fn0f % ugfnfU../0./.fnf d< ufofd< t<t
u掰fAof䎊fSoffeof掺<ufocf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fq  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   fcfr  H"lfr  <"對 f    < tg f   ff   2fff   ff3~s.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2s{           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE                                    	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ftt vugf&>tgf&6f٢ &fE ~f^Y[fXPSRfV tA % g&ƅ    f  \g&  	uf^Z[XPSRfV tA % g&ƅ    f  g&  	uf^Z[XPSR     qZ[XSR  zC vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $f+f3 f	3f7fff]X t fff3 f	3f7f  ff+f_f^fZY[fXRfŋӃf3ӃZfPSQ  f¢A vY[fXf` f;.t
f.   ~$C vf3 
 f    fgf&E   > uF f˃  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   <  f  g&"  @v@ g&  s f  > u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Ԋ    戰䈽j戰䈽|ݰffڰf)f3Dܰf?fI߰fUf_5 f%"fwufoٽܰfYfHfCf Aݰf+f˓ܰfדf f
   `"	f   f3f30f  0ffuf   f f    0f  f f   0	 f%"fTff.Ԓf.Ȋ f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.ڒf.Ίcf  
'jf  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      PfD   FOUusO M 6
Z  >MrfZgP  P ( rZ  .PZLV>ZMZfQfD<>Z3ZfQfHfHrrfHfDf>D wfD   >ZZfQfH%fHU3fHfDf>D trUf>D wfD   >ZZQ/>ZZQm>ZdZQff   fF>Z=ZQS,>Z#ZQS>Z	ZQfSf ZL >Z ZfQfH'fHUr$fHfDf>D tUrf>D wѰLfD    ZM} >ZurZQd>Zu]ZQRZ	 D>Zu=ZQN/>Zu(ZfQ 'LZ]  Z>Z	rZ  KI	s 撰 Xü˖){ۗ+<ϘݘfSgf[gfPfR>Ouz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@@
 >O u> 5xzytsfZf[fXúz.yuksfZf[fXPR tĺZXfSfRf@@
 >O uB ;yM@t&s(xغz,y0@u	sz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  vɃ  f˃  G 
f  ՇfaPSQV0L	;t	 @ ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6Ƀjs>t fafWf   g&D= g&D= f_`r r8 a`f0  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`ff   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f> gf&D5 gf&fff>fXYsufa`f@  & gF
$
gF
f@  sF>tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f.  +   fB     fV  j  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_ZF֥`F֥fPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇Ģʢ¢[XPSQRW0  3=  3/  3!_ZY[XPSȎػ    	   !    A   f   $       [XR Ģ# Ƣ1 ȢZSQW   l_Y[SQW   W_Y[SQW   B_Y[    f  fp  fPQgf0& YfXf    gf~gfNgfVgfofPfSfQfW<w f./
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .<t ø fSQ >Ntf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f@p   rg<uf   ⃸   Yf[fS>Ntf  r	f r>PfSfUUgf*gUfUUgf[Xgf@   T r
g8u   f[                                Q  YPSR+;wZ[Xf>@ tf@tf`f  f3f3f3f @ gfffCgftftfaf@   f@uQYfVfSfQf
   f   fH<rfHfYf[f^fQfWfVf @  f   f  gff^f_fY               PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{fZf[fGfD    2ø     "  @ c07/22/05DATk