#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68BAR)  - Linux-Based"
BIOS_VERSION="F.16"
FILENAME="sp30820.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  wA*A*  A* 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  A*2  2   IMEM   EXE  A*2  KV' D  8DTA   BIN  	A*A*  #E2   8BDD   BIN  |m22  ]2    68BAR   BIN  z22  2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZ[  `     8a             
(      C   
    \       j        m    i
      ^  8    t    	                       q    
        l  [  S  1    s"  M"  8"  !  !  !  !  ]   W   #  #   O
 O
 O
B(  )(  	(  '  '  '  '  
 
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
O
O
 O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
C  C  yC  kA  ZA  )A  #A  @  MF  GF  +F  D  D  TO
$O
O
O
O
O
O
vO
LO
.O
O
O
O
O
O
O
nO
PO
2O
 
#Q  P  P  P  P   
^  X^  G^  ?^  -^  Fa  b  :b    c	O
0O
*O
O
  .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        3ÐjDː
  F  F~ F F^z9 uvfvo'}fvfv]'~hd	h jMRPWVtj
fvvPt
hd	h jN`RP*Vtj
fvvPG
 Ð3f>^  tf6^ ؉f>  tf6 ŉj _;  Vh j7h j,h j!h  h Ïjv_h ҍ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hn F^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPhjbRPBjRRP2jBRP"j2RPj"RPj	RPj
RP⅃jRP҅jRPj
RP貅j_NFF9F}-^v&&?-t^F&&?/uF "[z=sjxtRPTjK_ZtjyURP5j,_>V   hd	h hn Pdfhfuj fh  ! hK
h>if6ffh   hK
h>,d| f6fcfF    .^
~ ^&0>^&>F~	vF  F| 9F|F= t= ujRPhj_^ZbZfh  j $^ ` ^ ujzMRP-j$^+
>R  tD  Zt( !  9  =  A  E  I jJj1fj誅   ujzRP賃j]t(b       ؎f&fjxRPij`]>P  t>R  t\  Z  L  >\ t>\ u& & & >\ u-F>T  u	>L   >L   >\ u3T Ht	HtHt8j euwjJulj?jI.>\ u?T Ht
HtHtHtIjj WȐju+jRP胂jT HHtH
Y>T  t7>N  t0flA  hlhlj~
>x tjJRP*>J  tXj \Ud  F >d >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uD:&~ tfj fj M.F  =HtkI-
 -!- - - 
tFfUw>  ~  H   6 H; ~    ߃> ~  H6 Ĵ &@u  H;~  6 Ĵ &@u   FV^& &G|&Wpfj 8Ad    F >J  t=Kd B= M- K- '-M- 0- )fjG>J  t2
j Y^ÐU
^&J&LÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ðl"n
 hhlhljmX >x2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFfFf-   f;FvfvUFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRP`UFᐃ~ b  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP蟂
	3ÐSfv
 ÐT  Vfh  P FP͂flK  Fthhlhlj>x t3^ÐFPLyBFVhd	h FP8RPhxhd	h fvRPhd xfvhd @x ^Ð  F>FK
l"nFtFhhlhlj(m*ÐU~uhd	h  Ð~ fh` j hd	h hd x[fhfu3Ðf`    
f`   ff9`sVfh   f6`fh  `f6^ u*u%f6ffh  f6^ \= uf&G
 tf6fY놐f6fY?~ uhd	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP
afh   vfh`  j f6^ $@v  WVd	~" f~ thd	h FPHv~ FPu3^_hd	h hd Yfhftj ff-   fPf6fx
f6fjFPw
f6fz~ uF.~uF6f 8Fug 8Fuh 8Ftf6fXkFPhf6fW ^_Ð~ fh  C.hd	h hd Xfhf
f`    	`bff9`sTf6ffh  f6^ X= Xf&G
 Kfh   f6`fh  `f6^ u
)t!f6f4Wfh  `^_Ðfh   vfh`  j f6^ \U     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP}
F> tjJj1j f6 P}jhd	h(      RP|
6 hK
h>     RP|
     ء` +^  &&W    f&        ؎f&       ؎&  &  FF܌VF Z   R   \   fl
S hlhljTs
>x u_>o@Z RflN  fp    FޣFܣvhhlhljy>x t>muR   hLNu~ t\   Ft
F$p*\ Ð&  VFF܌VflD vQCthhlhljx>x t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	l&lZhhlhljCx>x tjkRPu  fh  ! hK
h>zj{RPWF  @ +FHuF F^
&>TxP&*PhPj*cXF 9F}j |Ĉf<t<uhd	h2 GWÐ  += t= u%F  F~}
Fu~|3Ð Ð>Z  u#jIRPtjJRPt3ø TxP&PhPjWhtuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPJFVfFf  fPJ;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP2~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRP0Jې~  fF    fFffFȸd	~4 fffFfFfFfFf-   f;FvfvqIFVِf~qhXku2f+fFfFf~svBPƋVFVRPRIِ^_   jF "hPj
3UjRP3TFF*;s6PjRPTF*P2uTxP&
P뫐TxP&
PhPj
Tj|RPaqju,jCeRPEqjDURP5q>J  thhd j1RPmSÐ  [fh  Ohht"jMRPpjNRPpj{RPpfh  ujEF  jRPhd	hH RF~uv FF*;sPjlRPRj F*Puπ>X XujKCRPhd	h> yRjL-RPhd	hD cR>J  zt~ hd	h2 :RF 8TxP&
PhPj
SF~sF F ;FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&fRPQj F*PujDRPhd	hH hhd j)RPeQj[RPjZRPhd	hN EQÐ  3fh 'hht"jMRPnjNRPnj{RPnfh  ujEF  jwRPhd	hH PF~uv FF*;sPjDRPPjF*Pvuπ>X XujKRPhd	h> QPjLRPhd	hD ;P>J  Rt~ F 8TxP&
PhPj
PF~sF F GFF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&JRPOjF*P|uj(RPhd	hH  hhd j 
RPIOj[RPjZRPhd	hN )OÐ  F >\ ut~ thd	hV hd	hb FPrhhd	h FPKFVu3vPfh  f6^ K= s^&G
 tF  fvJO>\ u~ t	hd	hn hd	hz FPghd	h FPMKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPxB  F J.u35tF f6^ FP0F~rhd	h hd	hV *JFVtvPfh  f6^ K= s^&G
 tF  fvH~ ujRPLhd	hV j!RPLF*  F u3-txt~ thd	hV FPfj"hd	hb FPfj#BRPFPehd	h FPHIFVtvPfh  f6^ CI= s^&G
 tF  fvH~ tj$RPL90F~  F ohPj
LF  hPj LFj$;F~TxP& P܊F*PjkRPKf6^ FP0FF~s#~ t~ uTwP&
PtFPFPj%RPOK~ u~ tjjRP/KF  F f6^ FPm.~uPhd	h hd	hV GFVu3vPfh  f6^ DI= s^&G
 tF  fvFFÐUf6^ FP/Ð  F Tu3F F~s7F*Pj2RPnJf6^ FP<uhd	h2 OJhd	h hd	hn GFVtvPfh   f6^ H= s^&G
 tF  fvETxP&
P
hPj
JF hPj JFj N*;~TxP& PՐTxP&
PhPj
oJ~ uj-RPiIhd	hn j!RPQIF*  F 8u3t~ thd	hn FPbj"hd	hz FPbj#RPFPkbhd	h FPEFVtvPfh   f6^ E= s^&G
 tF  fvD~  j$QRPH:EF phPj
aIF  hPj MIFj$R;F~TxP& P܊F*PjRP#Hf6^ FPR:FF~s#~ t~ uTwP&
Pt~ tFPFPj%RPG~ u~ tjjiRPGF  F f6^ FP9u3À~uLhd	h hd	hn KDFVtvPfh   f6^ E= s^&G
 tF  fvCFÐUf6^ FPW9ÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ *;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2H>H 	H  iÐHi  ~ t	h)8FNuÐ  FjfvFP]
F FPNQVRhd	h ^Sb~uvvhd	h fv#bÃ~P|FlFFPvvhd	h fvaÐ  FPNQVRhd	h fv6bvvvhd	h FPaFPNQVRhd	h fvavvvhd	h FP}aFPFP\ÐUvRP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fvh\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j߃RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
 & FF  @
 &ğ &0߃FVRP3[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6 &Ĵ &@t2j>vjqj+jFvv^
6 &Ĵ &@ F  F j9Fu
F F  ^
6 &Ĵ &@tF vv}
 &ğ v&0݃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l
^& ܃RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjۃFVRP
X *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7ڃRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wكRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0փRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0ӃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
'
6 &Ĵ &p
ӃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0ЃRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;F}FF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FFPv~ 7
FFF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP!ÐFP>\ ut ÐU>\ uFP+ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh>FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh>vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh,?htth,?hِ }= t= ut '҃>Z  t fj h2N3  FJ1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 JSh@hP*F*P˃uFJ| j h@hP j˃]FUtKj˃hK
hd j hhlfj hG=th@hPEtÐhK
hhK
h~&Ð&ÐU~ u hK
hjhHhK
hjh7F  F~ ujFÐF Df>   F{ j h~Ahfh  ̃uF  FuF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh~Ah`j F*P̃u>X XnQfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ 2ڃfh   F*Pfh`  j f6^ uڃF*@N*1 j h~Ahj F*P5˃h~ Rfj hF: j fh  ʃhK
hd fh  ʃt"hK
hhK
h{t"fj hE
fj hl=uShPAht!h~Ahttfj hPU~ u hK
hjhhK
hjhF  F~ uj-FÐF Df>   F{ j h0DhBfh ɃuF  F+uF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh0DhjF*PRɃu>X Xnfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ ׃fh   F*Pfh`  j f6^ ׃F*@N*1 j h0DhjF*Pȃh~ Rfj hMF:  fh ?ȃhK
hd Mfh 'ȃt"hK
hhK
hɹt"gfj hE[fj hl=uhDht!h0Dht fj hÃ>J  tj htd d   1 ~ uj߃FÐF Dj <Ճud j hFh"RtF F~s3c F*1 j hFh"`FPHuFA j hFh"8he>\ utTOtM0tFj t:ohDhfj hl}=thFh"{tÐ  :1 ~ ujoރFÐF DF F~s-F*1 :j hGh@~FPFuF:A j hGh@Vh또>\ ut>Ut7j hh3fj h=thGh@tÐ  X1 ~ uj݃FÐjaӃuÐF DRd j hHh^qtF F~s3Rj F*1 Xj hHh^~FPfuFXA j hHh^Vhc>\ utTmtMNtFjt:hDhfj hl=thHh^tÐUfvhr  jF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NjOÐU*FPPKj*PKÐU*FPPKF*PjPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBjÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졞FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FP4tFPhK
hփ~ thd	h@hd	hLFP3hd	h FPUFVu3vPfh0  FPLfv4FPhK
h'ָ UՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  XhpՃh 
ufh  h j
u  7fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  Hhԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
fӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAh
  fhx AF  F~
}YhxA$PhxAj2҃hxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPh ҃m$PÐUj
ыFPh fh  	jmjыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
4ыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h
΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  
& FP輴tFPhK
hɃ~ thd	hXhd	hdFP&hd	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhK
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..`f^gef[UfS..`f^gef[UfS..`f^gfeff[UPfS..`f^Fgef[XUPfS..`f^Fgef[XUfPfS..`f^fFgfef[fX                           UfPS^tf3ff`  f.`.` "  u  $" u [fX 0!<s3P˿K
6 + r ׁľsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666
P.:bظ cP.:bۚLg  y>	uXP	 PK
 5! %b!

)&6, 

3
sx

 
&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.!Q
u' `t ``z 

b >	u 


M 

S  tX
Pu~ uF  X
uFL!_^]Ë

 
 %!;s
OO
;sEtU P>" t" P]ø Y+r
;&rQ3 V3B 22Ut
 Pt ^Ï( <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &(U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV(
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v*טÊ  UWVFG
@tG
  D
u VށD8FVD*P{|]~ tZ>PNQ!FFV~\t@PFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPPFPvvPPFPPWF_]ÐU!
t]UVWvD
t^@uZuGD
D4u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
D43ۊ\uPuuGPt\ttu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށD4tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7BFȁD4؊FG
+EEEFEيF3EGǌ^_]ÐUVWv(Pt,\t	0tuVD4D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvD4t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vD4@t^*&GPy= ^]ÐUWV3F؋O
рuGuD4t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVD3~~ uD
tV@uF96$r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr:t)ǆr4FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.6yrJuwwwxtxxxxwJu<uxxrxJuxxtxxrRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] zzz {L{T{}{{UwVW3FFv&vF
t~ }F<, <Xw$ FF.dzV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVD+FF96$r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33BK
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96$s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁD4؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVPvv&PPFPPW Pvv;u)TxPP&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFVTFPv
vVpx& V3P,^_]ÐUVIFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3K
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	`t	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5!["#%!usʻ 
FV]U_ .8tK
I	]PPR.:b؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUK
ء
F
F]XSQRK
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ1$%!3]UWVRQSP.:bۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y&;s+3UVv&L^]UVWNwi	tHԔ6		VW_^s+_;uX6	&t	;ut^Ԕt
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]            K
              4.64  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   d	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) ZC  + , @  . / F  \ ] F a b G e f jH h i jI '  K
 `  K
  D10/17/2001  O                                                                           d	 d	 d	 d	 d	0d	pd	d	d	
d	Bd	td	d	d	,d	Jd	fd	d	d	d	d	$d	Fd	fd	vd	d	d	d	d	d	d	*d	>d	fd	d	d	d	d	d	d	d	d	d	&d	.d	Pd	fd	nd	d	d	d	d	d	d	d	d	d	d	d	d	,d	>d	Pd	dd	xd	d	d	d	d	d	d	<d	\d	d	d	d	d	 	d	Z	d		d		d		d		d		d		d	
d	"
d	B
d	V
d	j
d	z
d	
d	
d	
d	
d	
d	$d	d	:d	Vd	xd	&d	d	d	fd	d	d	2d	Pd	jd	d	d	d	d	d	d	$
d	R
d	~
d	
d	
d	
d	d	 d	0d	                                  E    F    B l `K
      C    D    B l ~K
      G    H    B l K
      K    L    B l K
      M    N    B l K
      Q    R l K
      P    O n K
      I    J    R l &K
      -     1    + o DK
      V     S n bK
      *    1    ( o zK
      T    U     W   
X   
S m K
      Z    [    Y l K
      0     1    . o K
      _    ^ m K
      c     1    a o K
      g     1    e o 4K
      j     1    h o RK
      q    r    s    t     u     p l pK
               c                           _C_FILE_INFO=                                                         K
               
	
\ \                                  YK
  YK
                                                                                                                                                                                                                                                                                                                                                                                                                                             (K
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          ccccccc               (((((                  H                                                                                                                                                                                              bbb                  kK
K
K
K
K
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                  P  D     ,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$2Ruc/C 203-Memory Address Error 
Non-System disk orceQ
replace and striky key when ready
}
602-Dette Boot RecordH3  5EE Run Configuration Utility1720-SMART HaDrive detects imminent failure (Fping Attr: ??)

Please back up the co{nt s of"!hd1run
HDD Self Test in F10#tup 1800-TempeAlert  7`{A `!proc ~has beSed !ap$s n@or($C7MOS&3-*)s aJ'2)()[(by POST o1155Bo?Comm P *Assignm!lic&611-Prima Flopp.01n22-SndA33_1s201tGrol&495Type417A8si:`=9Y6=>0=0=A0=A>9 1=FF>3h6x:2@>60-Fix )Bdoe)sup* wBlo ModJ%1YK1/LJM722@71 P~?Q11s73OKKODMAM3/NXM5Wa )Id ify`!mAm0\\Z^%_4] ` %8Ma_c^WParam`r TableBIp+Hal( c 59ap1i>Upd @ b0q!:j... Invalid elronic serial _numbeb19I/O ROM%39Kn$;3 s:304sUnit4Load_all -%hDk4`MonochromP&l 164ESiz<OsIxB$W"&Instxpketwork#rv:RdAct"No spachqk16P6Op*1spt$ h Che 2  PCI Bush|%;10-Ex0in0qStorag@<evi >HxF1[ z2h:lCU1U	21z2ߌ3܋3	22 9qrѕ/>IOCHECK a yl@|3-{Tiz& Da  O X 6   Powe{r-PPassd9XrOK Do youllz@a0to p1!"s? [Y/N]ҝRuV͛AdipaЈگRP$or1hiqnQo (ABOp= 'C_trl +`&tDel'|8-11@C: Tp!(changed2: 6mpne'A3СЈ3_: Videon-4z:rrup0-(f`5iȐM6_ an)P`$expansAbp   TurnR"ej@(fsݽ<F1>:G AbaU1b1^b-rmal2PUp mu`$U3giq"wa:,ѫ+Bk(Strg+Un/tbr,CI!5ѪpnT@!f:ow1;o@uWtom c2umed: ;s To  mci: KbytR+cksum$o,N@fauPou0OlxpkWA)Next? Ehti2%Exx1Sssa A7cce= cݠ F10 OF2 CߕSS Ibߔ  auinuempu0i %! Mai!ance HCoTt<.swix- uspkTmodu7[mefdrequire1s.  D @o cڄ.% LaM#B@l'Mib?ay12re0Oexcee@pܵq)QM )E1!+|p"CircuaL>vUnO )w0lndS(."j.@U%,E4H"#P$.S03 2)p cocؐ&,VInr1ŇShutmdown  &y@Q`!`e0c݈PIN:+ [
]Nrq!left ՀЊހ)@i.u ʕOysp)opU0" bp'%PӔpkeqdppcuchipq)bemn%p`͞O%&*!ld/*New-s~@^m+O,ҿ+6*bAeTb &r	R d1	7tܱt	A ' m_3, aff`p`;ma,𡰽bPmak< 7un3usiItAongP_en %86*0	 5eu^lJBw7re lAc ǐСaZFS~F2a}.`ERRORyYhp~goneyTla MѳIEx (MSGIDX) R  t   _      8     
   .h   n f  ffff0 ISvݓV Q'  A    m        > N    T \}  gG W e M AY 9|@. 0X  EnSa0~ G ( @ ظ   f3  ?f
 4 P f pπp6 f6   } /  6 >x  .hd5v PS $<t4r g[X  DisplayCompaqLogo `
u1PXGjXrBXr<@X. u)(.< t.߈hP.ca Oo !"$#`6PhxrAV(< 
u^V3!&  ^(P*^ ''2 aSP( 22< tFX[úB +$PQR  ZY/02?3_4 56789;?<_=eAGraphics f`Vrt<.-  D.&.ރ6.u  #l O .PAtELrsCalling GetIntelBitmapAddr r8C vJr-x+D+\  r@ .h8pfa0A PR1.3PZiX@OOA.PQ`&Fa`.>OuhPP)XhNr.>CNSÿfPfQR	PaintBG A.fh f3f% aZfYfXeH URQSWF^
D= F\ ^^F_\މ^t
;v F;F
 < uW`b < ȭ22 IF t蘾eee~e빀c% d8t
`  euPj Ѓ;}
+V 
N JZ=@euAN`5-_[YZ]`PY&X&@SPQa^ kPZY0-UkPkP]]].uvw xz?{_|}~߀`Q0]h *Y]PeQwLQDf&YCC7PpKpabݻ  ]a3YaPnð@SjP3pX?[ADRY$&%<GP WP	 ff t@  [+P2`Q24}`Qf3XW? l[WSfRU3S`F.fGenuuhfineIu_f}HuVf=sL=r=vPtK f  =   	tŀuvrr f@@3t5uZfDY $<@tK<tGFH$u6f5ۊff#Ct Bt	]fZf[
ff ȱ Ѝҋwh
f`?   , zFqh9h&:H'h5N  <D 10ދ38t" QW_YFð N;r+A+&FGN uɆF@"0r߶F1zPؿ3:D6zb?"h^@߿ELу9Q n6ꅸ %00U= r&#+=ù=rÿW> _<us&301&/
, fgh  0 pqr  <ABCDE xyz{|}  ; f!QfR쾛R â&B r
&  ε0RΫְέ`YuSQV3
Ê^Y[.<  .FuoN.WT _XUWfVUSW! fv߿ h ޿RV~2,ك!IN 3t^
u
t_ ؋N_[]f^_SV hl^[þ  0OSRZF10=ROM Based Setu-p/# EHrHePrt 0A  O` F u  ! )aÂtM 3u!D` ! Gp sjQP$4Zz@W& 3tD/T2=Networkrvice BootWake On LANAttYeHto" 5D>2W0 7hOtPM0 r	" F0u8 71baE ID2f\right01F6 T	42nQ0P y0sc <V3W[<^hi3%as w術 $s2QWVRSu4y3X[0NF G[3؁7[?	uCFG?~N@t`Gf`h+r1G[vפh3f)Z^?_Y[
.0$<tNotebook hard driveHMultiBayJDockHbCb>(top)bottom)^left@Opcal DeDUSB Flospp"CD-1ᄯ%#H!#Super'NIC%j1+1+,2-,3o+2345 68?9_:;<=> ?A?B_CDEFGHJ?K4mRpLppL	pL
pLpLpL
$NBN`N~Nlesct!ͿRS͹U@ aond mo_the hp lq your cho!.  PressCWose.Seconds until au a`! defa` start:   &<(d$\';]!#ZipCK`t= Dr= k\d߳ hr S0ô0.&t   e 2G[37[؊' tA<v<st1& 2d2Aj4QeYAr c@ s.
*. .pn+jjj(Pj* #f տ npz ߹ p   02gb
   t0d32Ɋ <F8tF3G[ $7 ZPqpq{q !URVQ.,.L.T^Y^Z]ySz.*[z݁{QSVW/ s&Q.<.-00?00.رY_^[YQ q`u hP}r `t0at+= Ht.=Ht)= Pt4=Pt/=
t=d
=
tu; `2bXʱpd {nr
;wo2ҀqnOJAygFYô.*<U2HYPW0hN fhĒ hr hqÒ_fP!> 1;BFJ! h؃f@ 6jf.fffȵ3>vO2Micro Sm[CBus Reader$ PW .g&:u&Gf_g&gݿ Oa߾$_  ?  \   B`hqPPg&F \g&F  u
hZbg&F&XPg&Fa  r?a@ &   @ r) a{"  e޾d׎~ع    v}aQRV`DT r&%^ZYkfPfL	
"bxLу  rр^ " jGǩa$&Y@( t  rP N(Q?'CYPQ2'Ar ug&9N(t Pwmr`r[ ;w}(;r
ָ	ttǸ`¹  r݋BݓCPQGysrPRf1 Z1.>ohx\rfPS@ͻǀuh3r<t	B [fX.> t.fQfRWf  2f?\ff@_fZfYQfgf&=TDSSu ԋ ff3gf_uf.>f^f_YPQRW5r?_ZPVW TGI$tu!t쪃u &_^^ H$ f3ɵ`g6A, I vv I;vaSWQRHuʀPpq4{bXZY_V@A<A@3ɹ2 u#¼ P% = @uXu"]V@%aVRP x@    s@P`PP d `hUT X?g `q	 @@P        ޽*QP A0`   1nޖ,9SP0w@4 8 (@*  .P@b	 ,P :8c	h @d  f   !`
Q
Q
 1


!qC 6 @. Uw /. p0. r08V
. `EabOhp NAN  ONN a
N`*p
aG0O$a(raCO 3a@ON 4a
Nbm heu!L/!"d߿` hfQt o&QMO@&fYf8t*쪃%%C&@&#&>Q tRc ~rE^(&Zf3C h^ΐ}h  G 1, < t&qG *B**3+'&+--.ݱa/#f352**f&Q uf
ffKf&&&fCZ/0A8'6?7*P8+8#83@9#8 9d5hδ`v@!? !?&&=SQ"d3r`&&&@A@ǚABY[$)fPffRfVWf 3ffCf[fKfSF0r!e0*а K I+rM"d_0؀f@SQVW:龠 u3߱_^3t3p!ef M r;.7u'P ߻" hh=yXPh7xPRAU UEfW Qt% s	 f& fff>&fhF3tg   ; pu7)f;) f ~/u!^/{u^/u^/u	g& ?tx3XOrn;fQZǂɀZ@]baZP-~/u^/t `c	 ;&Q`Gf&K ɯklmo/pOqor stuvx/yOzo{ |}~/Oo χ/Oo ϐ/Oo ϙ/Oo Ϣ/OoPAVf`f.&&u hP#İ5rWrRrM&tfwf| pXV t#Br"p?#   / ' iy> ?f]i  LfUr*6X  R Z rGq Kuf]M aE rCF+ @.3dcg&8E t fEGH #RjKX(m r(>& t4EQVhY3Z cPׇf&HiKW{ r^ r
  GC_>>?t$AɊ?$wWw  _Wl  sq?_  ?Q q0߰@B ? ð 3 S Sp' "Q ЀPП ̀ʰcAQy/AԊ?QWEԨuptPGX_Yù
 d hRxs@f
P <uAbܭuĀ PR? ? < uZ0ފA߁D t	A׹ eߝ<|<t<t2<tH0Q[\"L
LE#L^$#LfU
T2+"D
D#DDff#Df0f`Sn 9l 1l Z 1 0T  ik U 1 PM k	 U
 ek U v
 j i  2 k Ui z   So  *i  2x T o i uM O N  < m! Y" n# ( YT$ %q % V& 1j \i* d _ U; '2' ) 4z+ \, Z- / 0 1  2 ,N3  n= > !n? u@ nS ƣA tp "n5 g2m n26 Xn7 gT9 p: 4 kC 1D -VE kF ziG yNH 1I0J pP. 
K kL uTM sN mO bYP mnQ ×R hV siW lXPYPZ 1[ hb c Ve ig 1\1" f"0 @ ؠ   !P  f   3P/0?P/ L.DѴPX% hX@ .X=X@u
_^rYPԊظ"٢ِ
9PWJ;f&E1_Xhhah˼G,[h+$ h+E"v&" H !  PQq0> 3_YX[hcSF 2hSe:# _hЃ>J>7[ &=tGG ,I$h}s&s	;J P   ! $!f` T] {*hPa uOpQffajDvPQ3F XF8`3 AJL &>'[&DE{&&D >W[u d5+Y667 5/Y667j@  ?B)}
Ȁ}	=>3[)33S[tS[aא)2@[sMA3 tthCSc&s
Jh{a4hDaD
ϰ< D+DuL
p
E$<uHD
@sd
{#Jr& uJfp:` uL
 6 6[u@i9_  MX)6N &uhpsD	\
bMGu~* pM D&}?u J t&Eb t KH&E^DH&Efw>Ut6Uj t.& \t	&?  tYX&Yxu	~I\	PSqX PX ?X؍>4[_3& ?^W>5[	_[XUt+tX# Z xtY  t aw\D@FPV!$!"桾tXh߶159q&?  ^XFFhFr!L	vTt
v*c`WFV]<'Q_m$<v߰ @Su<j_a3  v
p
u$@"<u@P>ȷX\PRt#:1thG4!Qķ wv=H߿ZX0`22W[& 8t5G[=7[tOuF0: u	=t!sF J u5 *js
t=!$&eӄӄa{׃/{$3`0hsˇ)  V߹ @Nn\u @Ns0^] 3f`WG@_\f_%)[)}@!U!  ) \&egWʃO&Mu{O OfG2tM1t$}O1t,t"OG%r Ǿp:MБoOg&\/ @۰gPv
}P2ch(akGl_kרt*QHttbM@LD8] =_7ϢD D	 d_
z
QkbHtS0rG&}	r??23ut`hׇa&EV$I	&M&]c`ҧ.'Q%f rY.twSϠUڀ깿 ShF 
~|hss܃]R$Q$ZW&= uAPxh)
hhF
 m_P
t  U!w#w !#` ְ#JFh ;.-.M!jNPtI rJ;.58vuu@@qB 0.aW$
1.D U
5Y0 @[X_
`PS@[X Sϲ+1.H50oLR
`.Z,<u(fPfRf?fPf,ZJ vGdu
p̀χ͊ PkS1. ɋу[Ƀaw$ Н@cSQWf3Ҡfr<f
<u	fpqv@_`{`֎f{hh73 F
t):u%W[D	& h//G[ & 	 hO~(ؾG[3aF$3 
3 )P 7[ cS ߺ80`= .u 30tF & [9 r6Qv- r* &' t&f1 +] #'0x
vx'+ %QQws 0RµzZzt hC D YQ?~JQ[rIf=Mu(P!L% = }t 0Y!:밮[r_ S37[+6 
`W{HH9E&TE	QW,	^Tr0hZÁxf!V @쨀u$P<Pt}RuxZDnwyOR²Z
Z^0WV 0  PUX@ 0(޵
1r5F W2=ƀB>@P?C@E?r@D(g(@Pu,{u@
@a 

+&C32o3&t##(
t&
0  ⫰F%%B&5  tUb###-)%( %T?
u'% &B&: >&('b*%B&? (Uw ^qPRW&wUAh2&]g2&UL
t ˀA)4{]x6_ZXB3һ -w62C.Uo/UN ?hΓx9_ U^v=8`{?A?B_Cߠg>u  '~|  DmqfSpf3fgu 3? Q>Z@P3:uBE&8Uu80J]
R +B&U
ZKGؾD ILZ!f`YB 'W+qr hڃ;YwgBJ,gt$URpSBJ虜"Ãh}xcH+
<tZێûPpVO@^f0  XZ%\D
 _dcDbbHIIUf`e؎ FwQF. ڎfafSfQf.KFfhfff#fYf[gVftGf    h>FIgf;t&fWj k<kmSl	kFPIf^i`2bۈfaf`~~faPq3_X.>@FG .slkTACOuF]uS Qlu&vvu	&v .O<F ju%vBxF5vz>F fFf.ףKF`CFF.OFf.>KF FE.?OFߩ t@tAFt}etY@tBFtNpt kЀm@SItVfB.|qfx;VrTc%ǆjk:ꈜ̉ܠsi PjQfRlfifffgHojr.  <Fβnf@~.ffH~CfXfdgf3фuls?Is*kxVf+f;wfff33nRҖU[GFj^l'RllSà$.pkQPm`l333Ҹ  QW>pp`_F
3}5upJE#ȁ0 t~0 Ao `t
t} tWM_ }   F EF^V  SV^Q0&tY&_  
`< tr&\]&\U@
&mNd 7[
S؂[u`	F& 4F^[_RF x SKhf}!0VWϋذЧ' [[r_^Y[XWfQSgց h fbt
!p[fY_` t =$PpnPu2MؑtaË6s } tp( ` j X&&EoSRUQj@6Ŀ^]Z`1V` dۘL@	ȱ	^X~p*F
O  t#n	p	Pe	F ^	F	` d3duhZ$Ku`<UuùhCd {`h}4d&qtû   h2& h29Phלװїذ`؝X!$!S   °SsdNПS 
ehK2   tE_t 4 h:` {tKur& &  
 p`0hsP<t<uuвSժu?1*7`Pyh37Xh % P5 8'0$ܵ[és# P?Xz؁#ԡ]tUP`ZX} ``G  pcG 3 証D1pÀ   ; Z x     0NPd`^~Vbhj1fF3.PE_ r 
0ވBFuр~2wFdcG-00
<2wd8F w(8F wI N@oF ;t
 u@mF^KہãP.~r@V»/  aPû< fPypfﻀf @ffRfPBf!N8
 ffFf3fv1
ZfFsfBPfhf c1 r9@o`f3ɐ`Fǿ:fќ $#faÒ
fPV3v޸ͿrF3@]X

S,0<	v	,$R.[W D#

[L+f+,,f c
T
ST .#/	#/}
#/f_C%f fvk  P2:FP
uf^fNf?V_f^'51PgR10
f:5P5V2V3F 2h25` ib'
àff  fffffX`=4Ό 26f>f>f f{rgfg`p0S 9 pU%C a5P*hxVP,DSVW0DfQh}YÆZ2۰uUqVth7Su 5/D_^[øD`PRh+H>?? (O*O4O:O@OD~O0QW f2Q{ v  LP hCNh}ZXoOPRQQPSgSS0` ػ7 ?  \A#cpq$[ Oq\ p3qð \&qȡ] \Ā?u̀]\>_t!%` ^VtUHbu[U`\%Iû 3ɰ\<KuPr;uEhͲCN_0Es-~U$dqY - t+==vPjP ZtP_a XkPہ?UuC33Ɋoђu uA PV$ D3 Pf^ Xe[Mdg&& &0Jt hu򿣶30f h~
t[V Ȱ t
Uŀv#t_̰{7||yH5bPXa}v[B8v&> 㿟 hΣڨ`t`_P3 Vu $h`E
#uV 誸 辷s0X uz.X0X t2h`!胬uPvuK 
wAX2 Q  hPڴu= Dt= tY	FjYX^!U hnPf=s,ޙui0<  1hU `\ve L 6jh tu6jf.ff0=ha rXPR r URW3 hثÜtt_Z"SQ Pۃrr	!xxfY`羐Z2.BB <t BB2JʃݾZ  8u}Q@A`23Ұ
SheÜt0`́ y autаi at]U [aSR  4F@`1-F1a hC	 hQ
? "B0PaԀa$8uXRPf2XZQrtwvYu0ѹ }R wWZPb6 U2<}UU@[Ju[§uJuçtC<f`!g~#[~d@ e hd u
3Ҹ jwʡ%vʸv a
 sCw)V uݳPف>D̳ A 
谁0@t0hN$hi#e 0KBO

$i0   YY&i &&g & & & & p t0p ǻ@AFێû0 ۾] 
 qL0d1&>r 4u=fSsf S  18f[P̣     f À< =^@"=^j	r>@s߀   ` ` 
  "# 
 Uuo A t&r .s t v; t: ""f63f@ O  f>  <  vPS f) '@  wf fQf.Sc @!aA`uf@@ &|J}~{frAS # XP
8t"*eP.xzy{ 0G5ۈ.z n21_ {>@@sP{ @
A
.ߡ u	t sR		.Oц#5
2&  #Ih Phqh 9 ހ t>arIh _$ f%"a j j htXX1fXSSh@îJhq[" tE2s 1|1x {0!y t Gum1}  /!  tE.  0! 
!&' 0!  ! t!E@q66ct1@at aPlkS09pv%꽑` D ^0 s0O(t1!R2B314[SW&L 26 >u
 @uBu
>@uj >Pu>L rp9L wf@rHs0FU!]Ls.L `&O  ;WQSL O 33ۃ >@޲[Y_h zЗ@u$7BSd@J3`<u-!f[U :9tu
9 2w@"R:t:uL 2
Jp2_[WSPR`?ZXL`q<Ҋ>6? &/23 G&CO2  &{EfP PdQO r&u&54S4OOX&PS GFQS6nRC
8@X$OO&2uG&2%& !=Xţ בw@[_<pB 啰ޙ@u 0^+ `^=`0^_t2!SRUfVЌňL f&7f u&Z&?Zu `d G&!f &@utL *f&6  80=t L "g2f^]`VWf @  !XfAi3f0 OOf  1cm̀r_^0iWV p`
^`9ێ318 `@ ^ DTDo   r]|s 0 ȳ诂 h`@vw rl  Q xa (  xW @`@ xL Hz`@ xA P`@ x6T ƿW X2wV`4``@ xvؾ]qjAas|\?D PiASA 
A ւ Sp5Gq[ gA
uh XoVhDd!!,4v,i#!,PPQWhI3 3_Y  0jPQ= `tq  @fYX |"@SP
&  ff& X[@@h  @i pr  tң `{ h`fR}f ,J%OFf!Q   hX.]BV7 . <t. l~ tq.ri."D.|u.:DtSISwD:Sr5+zSs&Sv
uqPQm
cn)A<͌-PQRau!&U$`Ȱ hDcSQW@a$a  hSՁ hq3ֻOg>E_o2揺 TCwA6 @QC@p4@;uYð!桟$ߴhb|Êf`߻p3%f` 3ֿ4Иu7faÚ@o.phO,pF`u
dt¸_iߙh[#ڱ0mEzf`f`  f%=fwh3a8z0FA~@w>7[:*&}t#Mth׀tb {uu Fo3!d 
  % 訕VWU豰- "h`yX@ 
#&8su&-/ úv/h#0w ՗ 
% 0k4%  0 й`}՗O`F%aáР(PD@3XðOc t
d@7 
T܏"ðd`PdZt`' `a@LQLBZP{& <`s$3	 +3o,`f `&XY\U} ]W เ  FؿhE}06&؁〲 uM9NwNiuӃ~ t"F= wt% @+7X@@h"Q2ʃ%r [
" U\] 
]`h#1@   !	 @p a `w `,Dts&4 v'~% t>
u E*䎨q'l AaEt5 t2 d*u t tf2f;
 &0EGenuu#fineIuntelu EЍ` 33Ҋt/.;t?AE@q
.r hCfff.rfP f . ?f.6r5x "hEP6ÀLf_faWpf@)`j  !,@s+P&$*+[,Pf  }j q`! p1x
12
12222,5|1f`*`j ӿƀ6/PfQ0fZfY*S=p  0=u?2MC?[ñ ఼p-wqq;5(%0 (&G+F'f`hq#+9r600&!2r3s1=L~AM3s )#<TKfaJOtLKLf   %4MUU
4Q苤۾X0YÌ  Y C"%Z'% C< B<D\[D]D]@]$ \^^	 fߎf3uf @  Daa7 a*Ӏa`ay araaPᦰQ/H 63@ @ur` uyiQ3g@.g;oin<#kkk	l @s sfu؀<hPtM	uv<TwPjFrX?fr  PX@ASQ 32PEw|ݦC, 6jf.fffȗ&ЫfWh:+3
f)X  `"	  _"	(>@>% >m3fPTA XAh$Zl@v mf#fPfQUT	޺ϻ ;sQSfAr/P="`C2fƃ 0fXffQ
 q[ffpY+vAq_L2_&ƃ uZ=PrUطf% euCf*bAf=  t0a t( fu㠫pf
0"P`h,fd ԰S#t_Z $u8ut1

36x @ h|WyF F hjVyP]RXt u hn#	
>&ళ3؋
}
>t. hpc@uKh}? ; u!.9F% < tpt
u8ùtfR 䈰0)52u  w & PPXt'vt
t@   hC
D% r/o h~yP>u  @ hys?D-&>! rrﲁRzspZthZyuul	r~`	 `+Zjj 6u S`` FF phy ru
V@ V&  3>t !$!$< uC` _
N<̣2<ģW	$ܣ"3`A7y1Ұh[@u TYP=`Rt 
u`(2Ɋߌ؎ Ȏ؊t<ou
Pȵڋ3E$<u&w $tF-b/EL  N L ߮N u û  t  PԵ[Eu
j jӻGgI(!!2(<!`V Psſu$0t$/~tA.#K .t4&^
<r&.wPd3.\  U.\`c.d b P p W	x .|D_DuQ&~?% PP虜X
 .:t
 ._
vXP%8Xr6%ȸCEa    PJNL p      QKOMp @޻t  t P(.DG H hs3 hvChҵ h AE^  f  %Pp m oւ 
v %&.|t&ư
&sr"P$Q.:Dt1^KuR
`E(#@}" sR"	EXQ&`31'C `H ƶrUr`2h!y_ٰ*v+aVRQSh7uThOSJ.Ѐ68u,2
t&6 @t2ך s 9[YZ^SûP|X<?tFh^c9Ejjjj P* &hc»\ h?c´$f9b:t = ;t= Dt
hG~y[ WVS`q
Z][ ы@u"q>*׿OطhSt`A-B>J=Ot1 0澠ҮQz rh
RzFpGsB^a90׿!ls:^ Q% St-$p<puN +7 4 u1G hy RR0÷Th8êt<÷UEVuheS/SR?    3Yaaav\UK8afy  u@"t@"3P&ߊ&W]Xfu33ff&3 ukFȋy0L r5[Qe?  :NQe2  ?AQe%a 	
1hhhrhOFpǋVW 2_2Fut"l2
u
2 
 @2Eu2&&&Er&e?
td&Epr&&ErtrEu&E<r&}	rsssVW^2l^2*s
&?}vwP￠h}PRQ3l[7|
%|_t~Y3RPSQY[XZh}$mud
g@vľ > EQ c5TX/Ye}-7: tOVT¨
G*6hI;&&  t8Vt' u G,6 m6}$@$ r& && E= p`dde`P`  XC[U @>
ڹ  .Ź BdB把8uGЛwAЛ;Лw5Л/Л)Л#CBЛ󙰞ўG66P濄X ї@ApBpCpꐣУÜVtwvvȰv蝊`<;weċSX؊H<wM3ɆQ#"XR< rYƊȊĴ3Їуڕ. <8l@Ihu@tJ	]2fPwk 2Yf&. "  &k !< hPmйu$f&PBÊ$
ۿ u%qϲuhӲߡ$档b&@Pf  f#f#f#f#f#f#f#蒀G[fPfSfQfRVWbh{<;f&YLxff
fhʉf3f3ɹ f0ΪQ_ f+f ! Kpu*xآx$t3ہtsV4C\`8O a^4_^fZfYf[}f3hNZ;
   `3hD;W[tKG[7[?>1tu*S\gB twt	\t뀌uG⻹ D
  mu|_ u
>t	 
Da{`Y2> 揀 s< |&	3yt`_lu s {&/-&t
cddKBC Kernel: xx.xx
 ` ؾh(,   t? p.`3 2ҹJ%aVWQ= p_^IC[` h>3$h\ uP$<X!p%rsf @  t< 4 Lr	.Q$<u
Pߚp Bf3hh/.P 
P_p/tdw t
higT Dh;=  t^bwY-s.>P{Hf=K t&ܰeV u@? o w> c fFdMeMf Fc~ck7~e uQC9  hCP|p:
YCP6@	hgPBFe:{Ff`Rr, hDs oFd<;;  A	 	:  <g hƿt%hPhsaf`WpmKhZQ u>fB PpGSCA[t$w Nm hsN r,m@f.   F^ß۰P XS  y ,#`	   hs[t(t@t,ֱ ,r# w' aht
úߋw."**/.xu+Ë-D/(U2NfQ0dYF :uE1]1bt
t
u
t#u
tN Pt"FFa<5u3! :5tFFdz ulm P8F: uY7@8e߹b +7u6Fi1;9e9~ :Ff@8f&>`up  jjj(j	R* 	5aU?RnhP!@2   p !D h"Z]RZr@a&  t0CRQ QYsY2$w
QHG !u$5Zf` ߀ PusI.&TbfT  Pgh#  sC ƀuPu.>R %RSfaO'URt9~Mn p ׀`o 6tq +oNi=ݤ^gZ R[u4 VfRfaphL?ʋoI$(% ^f[r@TG"  Hhx#@
߂QhĆr s o%6`RRlpT2P sg rhWUZZOEq4Y`.SuQ$<u:p$r"&  {tBs tRBs tAYt αQP uGvozv?doo p Aoݢľ7[#SQ 3qu,Sqq[rEs	˱QY[CAY <ff<1`00xx00`6a||>>N.}rtXi]@u[8*rAG ;^<Q7 &2h&CC  E 7

rB 5b{uN
 DeI 00acA 60 F (4hH aUfV3vCDPDQD 77"?f^]P"F#໰TK$%$JV$%2PduXDFPaKߏ@ MM 'Ooτ  "..v f%p꩛0p~6ȋFACSO4DBGP4HP HP088C  !CPQR  8  APICZ?["m!1c
 ǂ 		?
 ໃPƼaǩ	{ Ϫt pp(NupPUӼ
 2Ͼ RSDT(  #f`htOhBOpf  fRp$f~  gfFgf  FPTR ff#ggF{f.^$f3.˛.țf.ěhe#tgFmվ$ݝaN~$wf+hF#WpqDb43ffgf&f.>ěfbf(.ɛtȟ2*  ~( N g&F	f  rg#fffff+f+.̛۵w`Л.>fq$$!$P Xff-QV3g&fFgЛpcY[@F!ff=TDSwDt+St#PtSBStf=CIPAtf=PGBDt? PFQr}$< u IrRUfQ̓2 tS@>HrDr v};Aptg&P.XJfY8]PcufWfVԻ`pf&f.@]~@f fPq)+Ȁ$ 4 
Ȱ ^@-@ff	hΪm$ pf }t	
h)fPW %	fX
 ?p
F kg ӹ.  Ұsg&ƻsh5``@(pc_ů5ӤV	ɛ˛ J{r @̛f  f%=  w@Db^uRW D hثB  hNͬB _ZzPSW
tSP$%ezfP3h f&L fp{p L fXPY`"ɿhU!O" 037f0P%&?  D 6n\u  )s`) 0OG\fa%3['i P(,(}1-U1-  P( \>\&geE E *uM*M0GfEB-tXA-t$OA-t324t)O$fMo+?rþ200mMe&\a߻  ΰø c 1\DFW #f
^0h6^Xttտ ϞEƿ@vE EsAA_Fh+! ێË̌ҎӼߋRQYZҋhDPYӠf`FF  ohO ]>upۿ hUTA wK$wK(wKU,wK0wK4wK8wK Iqc9FtFfN1KF> hɀ5QS5Q(fa`CֿhEp13ɊMh
(#t

h6'B ;r_iuaGWFH ^@cf} ` fN`qф\ N%]N{f.9uu `ut_h rfQPH_%erf;^uf;Nt7\]fAtd t
tF~Y_%ɐufV{ \t> )j.<t1!UuEhn6,,`ll^_0zgk0l0 u,h/ki..D+hZC	umVWSRQh, )jf.߭faȎKZ[_8f}S!_fq̿tA"pw  u
}3Ax  t'gf@yGhGC	G$<lDCOMPAQ PC Card Smart}ReaderGEMPLUS GPR400PSCR b}}~LB REFLEX 20241 PCMCIAReflex  v.2Tc!}r$HP|  az@g&O Gd q`؊ ȳ rLfK sr>qG	 .Daz
qPO@.d.D?4fƱ_ PQWا 0p
G.g&:uG`Y.5_YXÁ8t j~ F`vfWrz@gH
݁#zƟG f_G` S7hC Yu#{  pu .Qu = Ў~1rp&tj`t_& rT  r&= us j6>
r/6r4.Q؋V< t ^Jv 
w x y 05  hhC z PZ%bhCaG1TrPqtI	&| 
%
qtQ&0!s@%GY~V
w&} ^,ƹ ؍vf fD  ,A fLs-<t(<#0{&~ hL^gRU32t
t
u
 t u9<0r<9w/tM> AļSQ 8Y[@t>"$,0>*SQE;߅f tu]ZXGf`<3&!hYS֎fvph~s=gf9t |a2ϳ  г th#=B $a0yEgf Vff3Оo"gf@AǗF f@cЀf!
[Ò ޾Nw3۹: 8tCP #t:rAh\> @u | D  00z e? 0    0  _   'r ' ߜ 
 9/[ "b6vk0z3v`9 k11vЮVuPS_.GVW ׎~Qr&} uBr	:p_^$2r59r!BrE@&=u	@_KH΃pHr&E$uz5ýЯ㯣uG@ӆΎ`냯ra DTtr&eÀouz
TǓ
K`uSAi1r# t itct  t$2P!ffL p]Va 3]
ְu@+Waz `늰r8u_QY_Qþ1L[ r&U0rþgeN

>1L螣P
2
P$X` $2LlnB}<tzHP8u6
uBp& DBl0t
{a 3 r/) r%BsBpJ`s
; p5 aù<t
BJ{ @u{`p B%I2۬2`!$u+B $l&2]8u\u rq@m riP;~ ra0ñ tAc rF n r:i r5&D@u-&P*+$vF,Q-> Yr	2/QR" ηY1-B2Aq3`4Br 4<42vf`j ސFS hOSJ7Bg8#+O3[\π h% `f= pxu [jh rc Sjjjj P* ǹ\ h?[cu\@A?j?&&^@pA$&bgEtq= ;tbu= <t:ݳ e8 1ׯPEyJZtMk[fa; Ͼq俚Et@u):P+EЃ< u@0uQ@ 耳s@O`E3@r$ jrπ DƆ    re8ZaX  -ZA"[AN$WPU U_ǀ uu'"X 3g ryYe. e}Yxep  .QfT  0^>PPfw t0@e8Y[lqjۂgs3h&PWIۻ Cۻ> =ۻ F  ~f0r  tIe8r=? ȡ~ tT@tpJӃ@ MF t w`@rN alF ~ t};	e8erth0pSJ8tY9ϡf` Wf3Q fY^@ FP 7r ~,ruJN:%&= t: s߅e8 rdTi@@VQ&[UA
e8sY^A
^
e8f"ئU
@Q?:%@R(^a Ih?Jҍ SpJL
 w(^ ŋ S ptߑH-@ݻssu`+YSau[$	эaNQt3$e
^@2|{ f~|\hOfԻ(^R]tИ!U@B}q}C~$7R< Z/tHÍa7vQV\f^DUYa.&TۏKt'ËH& St~t.1sA0`s ;SEU>@Ed@CDE#6FeFGH
H2GAST؝a     i     VQ    P`@`;t
YY ^NV^$TBL$PCI    P  $CLM"    4$fptqfPfSfQfRf3f f3fg.}	/ 	@ 2 	fƀnuo 	nZfYf[fXpWUu	  	3`r]aq 
#)C
ERXYgc> 2Q`ް(Yùm `ù DaV  .:u.n!^$5f_Q8aY!fQRfCPt
' "`
Pv
"O2ɵ PZ t"
ǆmWPfP  ؊2fl 2QW pw	t2$_Yôq3f@
%S~` [Pp 0X.
tÀu@u[Pf
4 	g*f8 *a,Rff~%fؐ..+.;w
Z
$Ue <u
`V`<12a2@`|<z@=q<@]Q4f<	@}4[<
@4P<u@4E<@=p:<
A47/f= uffX<@7<@7]]fW f_2spPuf_QRfVfWSft,fff ^r!fp;tftfN77  +[ff_f^ZY^>с 	 r?prf r ;u*A
`A0BBC= @	ҠH sQ;tp_r"R{L fR fZW z,X
[2JʲKL .ZLHM	NKOROPffqM# PMLNKSc RLOfMUPK_S+OLiZXV>YPsZ(SP[SfT'RXMf s#(` sf t` s	a t
 `QVWf&? f&bﴉ3.fSP&Gf&_fXf[ ` }`p _^YSQR@>fPw&fd P g f;t
fXRv39W
ffff_fBfEff#t߰k f_TCM!p߀MQ fu`# P"f UI8s2ہs
Z*SfW`@)6-y`t#uP{aHXt}xPC[PSf<t; /30e ts
Hfu
utǳ%[`3}aPZfvl`_X1e'$PIR    $t` a b c $ b a >r i  f}0 c j !fphGhktt`   0 `%;`0MWff `p
dz_nfnf
f`?aVWޠH#gSikWĒ ;_t[lPmF[_^qWp!f` f(u cfffGfY2haϘ뙋yPC
XPS fS[s$fR
wf_fX$s[ؒfӠRq1%D Ð[|ѠBS22E}r'} Ipuf 8p8s?Ҋ
XQ iRP
t0r?zr#bEvpE  uf úM % UPfPCT".0.[fXZsoKf4._  tp [bM`_SM]fa_f]rff}r%mz 	|&ngt@..%ıO,fEѷ.&8&2%ѷ@"ѷD.%Ш!,= sMrsb
üg2誱߸_ 	f^ i
w t%;+:>*f0mk 	uwARAv *)u_6	R+	f;N`f f{ 	Bg❊>?r>?f?> fPDWB< t}+
 t
3β轮 	r& 
A1~ذx 	Pc` ;


!vVz~^Îf.RfJ)HZRUQf fuffVfK=XfuNVFYQku F{MuY ^Y]9g><afPRg'QSVfNVFfL^[YrfXftA/3PX|Mc"NWOKPhUWV spP   _]`ph/WU鳱q3話蟱!蕶鋡 ]]~BpXRVr 	^Vc~3   	 /Oo /Oo  /Oo	
 /Oo/Oo7nueRP7rU r#vP%V ufu oQ2=fA<t1 uQ !ϑ$n  "r.V sfYZ]fTf;p!0.f;fZp!υ #qWf{!qyrl0蝓rf+ #)r
*,&SK0*b@*|s
;u&
<+`.G/0+bwr/r4!*Bqy*+P&*X8,Pqyr P#`(*Sy[+0*B<<=$;.E/41qy671[ pypXE@!t fJt/+a$J#fSfJʰlay!2,DHvIQEJUJY!KQt?DK7K
3LtCKlLQMjNð-ΒW@Uľ!WVJJ e~WB Q Y_W
t^@"lst6]V! <5u G	F^\B^= t,'sL.
<5#\ 
u萏!#&rb2bLXf[2P'_X^3WfVfq t
P Evr&< u ff Fp& Sc f^ޣô PJXs HIPORoSL؁MNPjJ
u $_s[tNð) !tQutSY uqw`awu
Fz$
ءz BzO _$0{}$"|}4|w0x SvX>
yP #zw)? y zxQ3YQ
t`
<#JXo$`V3Wð&+p)2WWrFQu!tt	*tEPҰQS&"
ǆ[ҳ <t<!t
<y<*)R`ЃZQR+8s	Wx ZV)x   XVPލvS<û	 M6[r!X2L^_ð,rXU&"!rXux"lVfWY u؃ t'r
9Di )`.^s 3t7[|{
u |	⠿  $<<<!ߊ^W"PTc؊% 8ȁƥ؋1Aڦ`Hu0`ƆXrXQVWP`[[qX_^VWQ7[@M21P8 kðdS  ![tvN«P?Rw]XӒ1!tWw M艠[ #~5@ X2䠆`ʁyC<L
P'vf01]-5ðWvQ&\&\Q }1CV    !W7[.}Р.:tLޠu%t>JrS\.[t¡\.[u =t``_M_M4EfUv"v t Ar Mw &PXF
Xf]h@ &A ϴ)j@͊A
հjn\\ôVB@=Vh\.6.t.I.
Lj@s& |wu  #^SV!ъD.d.$ʋд^[Qʡ觞֓j ڋrcOt	OtOtLtD&\t
D\t8\t2\A@
Au	
.<
.}h  bJÁUu	UiSfQRG rfL\ >ZfY[6p7+@WfP<r|wf u
pufXSU uP؎&Br& ȎXh\&\>@.?>ٷu Pa 3B &Gݾ&wG $p$PC&Ip(US*B>F &g0&G1&O2S$ 2&GPAX]0[&?``a s spp
 'f&GfEa~afRfp,p 3SRWP޲ 膷ra-EuijLuRE<sfQpM}3 fYr/>\\.  EGǿp ?4./ϱ)[Ü"_Z[QY.>up`G<tFr=
.E
.&\>Z


%
5
h
Ɏ6\ A}dYSRt5ێËHS.&Gf.\f&_f&_ 0VY2Z[fUfS@Wf]ð4C@4)ʊؠS0!uP}$@ur@@|z_XU$@ 8tu
#߂9$
,RVWf1.1VM,XV cNV\Q <V\V <W\U  @$   @aT `a!f)>)!fp*!6!ߘs`] >!upDV!fb*>!f** .!JUf  L /!dUOUf!01.!>! uU uR,uY!DpzE_^Z4AbQ585BV_ ߎؾT| >TiS`i`PuuF`!ˀ:ߙ3r
b[Uf]tf r	6.$]}قهU p rt?9?&&qBBsC&gsCh&~?sC	DqBDDGPBvG:rEh&r|w& *EISQD&߹ZޗdF&OfW sAa:<Qzf~,@nu#p~qRf3gf&ff=SCAFR!_U< 
 	<o! i ]W^ A<w&0r'V3ɊȈCF`W+1rX;^0t	ǐr`_QRVV<v^.AX
t0rY
 !B^ZpPbAt?&],5砇UI&P X&smOu]xxޑc!!@ؤSmnSdUexQQuu
R@Afp@!m@@#Yeϡ#[e}j#pFv#$"vv&r%ۓcQr2"S"*~@oͻ ǻ׻["2ɵ"=Yxq = sf`ffP  2耄Y[$
Ƞs߄	 Fp= ІN8tSsF f% /@00@r tU0/y py"/L(z =zzYxx fXrfaRV s v@wZArrs`t_$u4ѱ N|ff`4eA fu4fafWFD f{2f | tf}Fѯ ^Dօ z s f1&
fWzp 3#rfF$z;F(xF,0f3{rBzrf-1zfv,v0hfN,-A(Xt($иPpN$fFfV fNu2N t
ffFDlf3fu፿Qf `N xfPPfYf#f#ffð0 fHfVPf#f@f+f;FLv LfFPf)FL҅Yf׃@$Pv;QfI0px  0 fRPwf*fPpff
fፋN XfG/R\sfAD!;Vt
kfA@$!ĳސr  f%`" ]f%`럐  @"	 "&+FP0FЭ  pP}P [3s` 菀YGev f^XPQRWSӶ̽t1u	CMᲐ`V
貀[_ZY 泷 ѹQWᲝ ߀/@P;ZeZ% 
 ߀ u
 @@@Ü8  0Pu5{0("ЭÅx&%@-~--- /_.. /
t~%.?.. _f᣶,fP3aȃP,  P] USPsX[( :#<crh, .l,]muESx ܵ
߸y ε55Sz L{  ~  [r[
΁` ?'$$
Ȱ5T
ȷPMǸH\rJP)'KXp';r)AKȋȿ,Pr, AJ0fءڋf˻f$0߃t	sSP	PQXP rXpD< 耴 u`$uz`u 
>pbr?h rx#tu	 @qZP<X@<g먀t@P (f˽S ˸'/I[a/Sg/t/////00.0=0V0YbSRWP< 2 b/P  .p  u`   
p p kp pp | м =p  G  3|y rt&roMjrey r` [rVj rQ rL rGᐎ  
t r8 r3 .r)= r$o[ r1 p3I r
 rlTZs_qT	P<t<
u`5,u
`XX""X	u>߲tQt-<v<u <r<
w ӷt	Pw
PzP	
t	 	`| {c$W2@8_T*u	 E 
yj"f)Ӏut&  5& )u& RHu! ×8'  !eX \0 RtY1#vMuG	# QRu3v2#uO1#tu1# t&c'q0> #3##:u@V/8*6R:EFu ?螒E } !tTt̀t߀EtHp)7q)p)F t%> t:& tSu;ETu93 ##3## t`- E>IpA7u	PXu3 tj.gX5'tS%Sp&y袑E# u"#t3##0&)5CRq`=W7@-Px3;r.Dv+WXuw4&32S%*"?u!.ð-&q%	&2B<Gr<Svƀ9 ,G߻w.&]˽wS%JEbD u&
<.r*Lu2C(p'-2KsKRw(BrC'<.t<+u
0 uθN<- Q" uJ,0r& 
6 ;6 %##  ۣPSPHo"
pOSQ2@aVpWBѴ`蒐uBt

2pZq`}YtSR@ ڊZ[]R]Z[T1 uH0[[؊Ȁt, s\
u]ra^ZXݏuWQY=.u2YfN_eGذf0ZKeZDe0[Zf+ g&5B\ oVa\r\x]X]^K 0_?pW٫ȰeĴft%؂`P`axad6c^ du=/Ru8QY`YP`
ً@聫ptz2q>tj u\URAru<u7Gto/_)@t*#tڱ`涀`P`Z]GbXU@r{s]U] ]`K:vA|Kx|]sl}Q3>@~YQY0eM ~M>rQ@~4Ysl  a^}߅ 3ɆkZ[xe;{ fIl`rC}%ݸH ٸG rsl%aL K sr pN 1M C]#]~色[@2'軌\HP ̕SIMPLOɕMOTOROLAǕUs4~ЎHӟr" 󤿈
 &Vs77Y  VP'VӃS  eK3s˻ʆ U>3 >蚥>   v mSRQ&
 3-&Z[>L ﷟CҩW8 0@ _t
@ {t+؋â~# >ааа߷٤1؎&3&M<St<Mt6~9{68
6l7^V֢O
`b_<*U?аA6аѧU-аa$аа?P>m! -ݐ r߭p#񯫐Z k@mв~&߳+
2>&~X^fVfWfSfQfR@efZf?Yf[f_f`ΧRa?f;tϞ%f`0`  s]fpt-r(9zw<ux `  TfaUQ΃U F `E]< t<@<tp{PY] x4 4PQRfv u
ˀ`$tuрO20(C2z ^~!ܜz2ZKYX$rP@zrgff5 af`o t  5	~ *ۻF0 x߳S3B@fv ry Nff3u
=tPϰع  f3g?|fFP@|΃ gfffp^@y3fPQAya3YA@уf{Px8@ٿxf<tP  u#f@!ܿxxtxfa0fWgf  #EgzܺvT2pgƃ gu	f@w1 w @ @f_gfgffgf a0fQ;gg&fGfXf7	f;wf+f@!+f7gf3grfffgf&faD	t@30!
`h ffWgf3Q@rΐs
  gfߥ3fSn͓wff#ffyZ?'wf3f3n,;w#Aܼ bf[gfѾ$"ffPA$GT'f+u!'b)X'!AP
*@كPa À +SfVQ g46f?FCYQ00Yf^t0\0 g&0GCa2ffT	[! EuPPu uZCPPE EPP runtime BIOS - Version 1.1  
 CDD<DDDD#EHErEEEEEEEEE2FwU .C]cC.dS .c V r@ R.c
Z @QRV A <rt2[A$ԁ !2`
  -(DD"qF ZYSBED$ 腝JۆI[ñBCuBD xuOIbLLW SMNLU.MsNVV{fQeMM	R_&n ^NROS RPWB,fQOWBUl _Z
JW[[\U @ @SRB^^1C<rM
 oj ?G@L ΀C
tP@).>1F FZ.1FcF
KcdKPd݃3쨀uAoB$aF3PÅG8 		2ø@ Pi &g +  pa  @
fN@k l]ϰ2y'uj1mdhM@_S\8&&G0p&G&GPq Pq [ !rrr栊 m s`s\&\u~ F0 ]`h..F3 ( иi  2{ C@ yXWPi<w3t	*zO $ z! & PX _ǣ@P ~ͣX~ף$~    ] Riۓz4ơz{pfgufQfYg󝱂 |[ <Ȏ3]Ou 2"0fPS=Au@u;Áp u39 u+ f?wufP@uiXu
_ff}Ѷ%l{AH{N{S_,{qqG{{q*F{yVqq}I{©i%{{qqqq"&{{
(<PdIIAJnJJJJWK@x&@xW<riǁ  .I_Swt 
' t r
px[e u0^r!<p7	rr&C|qxs"r2.I2& rpxn[s  r}ѣ 	8̿ r&& rr	qxôQSs+&' Ͽ@>'  _s;{&IsQ
u>[ W r%z$C rp rQ	T8  |" $ qxQ@Pm U2X~t s@PtA{dP` Ppt t
@u1YÜP`
 1Xr`QPtkXdYQPZAP t	`B}Dd$!<!t*'$pq@tPGX@3ɍ6W[.LP.:Ls&3ۿ7.D/.L0s` Rpr2ju`Q2~7G7u Kw렓݈^T3tкt
u! 蒞3ұ u@ K= t>\.| .\ǀcu}ճՄ  ֢ J}uLՈ Q u3pQـuv@bW_tURQRnՊU̋YZ6	u>^
迒 .D+t#VRĀL߅^qdt.Lu{ Uċ]%nQ3 | Ys. u&	 t	&Uu" ώǍ>p |  Êö.f.|fg@ t .|߿p\#ǛPQW 3ۍG[_pg/ݸ   y\C]Tm)tir 4mpe[)pgqNq$Q >?RPp3XZP <u
XPSQRs귄3ɺ)ZY[.O
X `.OafV`fg
u 	rhr"s`!|a 	 haf^b` *2`$ԉNT@׮~W `F$
&FG&U_/%@ Hhaø ˑ	SR,غ*3% @LW  '[n2_qm+
`  Z?t
pP"ķ eV6Qf ߺ`T ft0^ag [V2*r_$< a XZQSRW*׿OзI0 2 {@O3_@LQԴs{ Yp3O 3ɰRQWSP "$6X QOď 2%%3l2'%$`'bsX J%S& 	u2'X(2' V_ m w$}P-[_YZ`AU2<UuXU&'DYJ`BBǓ2Ð2 3(Cbrd&ߎ]*!u"P`&*Î`5_؎-B.X26`
u	 & ت *ê/VW` Dt!WQ<:t
Tu8v
Y_@Y_XY_^i  Xtj~ uqu3pqt$t<u;73qs.	rt;#U[ra(UJ?߀ХtO2UtG-UBDt9t5F  F  FHH
  @Ppqu<IqrˌN.TV
Xqu
eqr.2^.ߊln0MLN0Idq+J?[XOcqV3f	'O	O"O<$OI(VV	upuLprx<t0<u.;TtqTt=?<tTTZ5VQ5VHXV<C`be3T3[RO߇ZuP4VuIZ9I
< t(2Z43IeO . ? IKPLP3N_HaO	PH XP'@Q'tOTVyaQQO"b/Q2RIbLcLdO=p`p迗H q pH'Kpj@aA t PSnH'[Xu	Hp&A 
t_ÊF j@ N
F&? b ? $8t0 mr#}&\
~tpP8sQ u
B@YÊE *F&d_ؠFttGtÀmnt Cl
&>  $> L
x譗 fF Q|؊恋p|`}Ê~
~o~oD cE >A  t	5Y
ulnug}n}πnpFFm$t#@u* nuB tЉGnjFjW[Ui P`3$  &?t+aÍ>@΀}
t"P	
t>Z .:UtP`>na&V tVR_oZ|0@ՠ@u-!$<t"U厀}@u_^^@QP3_䆊a*Lks2t*rlRڻ~k.uێZ
t*"uuq @Tw
ph uaќ*
pZsuqgPs4XPt)ޱ&kOڪМ*R@zѝ
[uqp!uX?  ©1pL1y2Ϭ߮lFpoypOIEMAG  IZ P  Q   	
?
 [  HDA-L  H;DBCA-Ec2CPUSB-FLCDHsLS Intnl  PCI- BùC  % eOj)_!y	P 	/<M [;c1[C\	\ [` @ [Ĕ ?[CD001EL TORITO SPECIFICATION"gu
#@d@P@fd(f2d&3Aɋ+ s dMd5g}d0̸ Vmd<d;]tdd]^P~vЎFP^~r1 7~vFUn ]~չ
 X? `b3
' 'տ Fյ F/]3:.;v+GuBG
 F/ {  Ë% 	XNۋQ
 aـ0%NY%'B0123456789ABCDEFS@ۻr^׆[____  A " * Gxx x y 1 "Ϡ *
xx 0~ @	 Gh y\8y y `b é u{TpEpذE
U` t
 r t
r xf`ti2tW &  d_&E3ҀtB&U
&]@&E  t_xuP&E!fa*578F'()+07@j Àu v5u t
&  `
x_t^t]t\7u!	tF"	a5	3< v
<ar5<{s1$gA	Pߎw`Xu	 r`_հѾw
r9_2.Nw ukG$u@t
<zw, `tզ#		0t
w
pwb2]wSRJ, EG21)Pı?
 ~`pД trV
r
	  `vPQ-7s	} ]	OcEYX A@  B C b}ccccbbg]JɊ t
3{$.p$gE
<b6 uKb?@)0̗q)  *0SQ>u5Môue% `rA,<3ɸ P 3Y[fPfSRVȈ&ȸXmY+tt#
S2>sr@TUn\Ɲ[ 3^Zf[fXÿқV:0̰+/1uۇ .0 `r8.- qZ77 94r.A:u ǉ𣔿"=  
` u #[ $p$?apih@ & pr? 3uX.cY3iô'n< uA3?L
tI<u	.c u<, t$\  Gtuu@V $
4 DS,@ Й@7@PE<LTߊ[S0UNNN_ON-NOgOPSRސHt it$`EZDPR
tM4ZXóQE2۴蜿
|A$3@9DV#v:WU uPXdd~]<t3 r
tVd4d8D^uKARWuttswB^b\T^uK_ZD`|3&
yt,ـt&MI1&G&aKM`@ŇqaaLAAA"a+u 2<ytȃt
hȱih܈$FKuðWQ0au	ۍY;Y_kulCmS؀u u)w4 0pQ.w  [t6p!{0Mr2{hB@3 hsyts@1rVrCs[suss4t,s
2y"  |  !Dp.D
@= ``@:g&&D aø0 м ` j X&&E0~ z3Լ{oh  sr?zQP{|{|XY}`.\.Tp{ώǍ>p.Lـ`"a.D` aQPƌPXX6a>/Ooé6'-i1i5isiVWiiw_^ø ø Á u<s/+UUuPEF<蔀8Eu~  s\}5: h!Gsp@qhv hKsq9`hҗ= v O hҗA ہ$@<@SfQfVfWfRf  aE躕@qgPoEf  YEg&QPfࣘfZf_f^fp"R2p n_ l  ƀ #  _XȰQJ2ҨHð
;pi,6/($zҿtø
a뀊а	`2րs s	2  QV Ā轀0	{R2𥂀 tN :;0~wp
[$P
b$G zRNR8$R?2jFjYjjj k9kka/Sf3[ffÊ$Rf
fX$xb6a/Ѻfsff߻ӦR3%ǆffS6fPRWS22fq fFrF ?u ?8s܊[_ZQWRfP
t)@+Ar ?ff  u [?8ufXZ_fY}áH?4 v 7?
tP?0t>?WQ35?rPY_ !m2mZmmmmmmmmmmmmmVS3`h.:lu.lK =[^* F.m2Ѓ?SF . S.lF[C3N[QF ?t"lsF2~ tﴇYP԰ 7,~` r_ø8
dd`tW!`evt `ht$ $SWQ =@tу KY_0N ]'onnnnnp]r *!ӧMnxAAtPpoAFtX$#PG}醾Qdvd}

qA
t$e 3	rUXG|AsA}s	XAs(R4	 D	 E	ZQR`PQRW2u6 saa$8uP& fW'XZp"P=L4SQ r<YuA<u
`E36uuu@W~uk~u=fr_sШu@F~u5VOaVh1fPS LogoTrapInt10h ۜq@ff.4pqORestore.4pfIEnterTextMode `txuohXs st@Yxuh.	saúB  ۴
$Ü.4pqqqqS  A  G ?" y 0xA1<c8y a'R é uD ËE{PE t
!r t
r/f`t+W   d_ &U&]&E faðrcrqrZr>   "@ *` G y_!t"cMTU?F3{ 
M#aSt3W$ ԣ0 &E75
*g}
P:gE
 t`Y"6W[D. .0.[gu9sU I/7[c[!1}П
$&E
aE666F_.3<-31/>>A0]>GP0.  D  Yb b e  eQ>Q>  U	 Y
 e e@Q>AQ>BQ>C  \P \Q eR  \S eT]U ]V_ ]WBXQ>UYQ>ZQ>[Q>\Q>]Q>^Q>_  r` sa 4sb sc sd?e?f Gli~^-qIr9zf`ܡ0tOnHu (4$
Kw,Lcô%N+faVWМNt*OؠQXupL$tM߻$<Sȋf`%GpL$x߸ %rV+lO$bWfVSQfVF! MCs^(2۹  <2F  +^D!8u3Cf^0oWXV?QCuKX! ؠZ!P[`2wY$I^:u:\!uDY Br(Ca\f^Y[_SqJv7[.
tذÀu@u[p܌"KEFK'$Lb4M&ngLN B X_8sPRP ?Qpg2S&$qT SZ"UU)U+Fpg$h  0j$Q.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPRZ@Sط$0<:rd u[XÆ÷ќH A=@ Bϡ& ûVo:gfFXRyZÜSt	tv
vt[Ȏ؎ ЍҋhxSfUfP0XPR0ZXZRP4 ' XZf!]Qfŝf]rPmAnһR%Ꮊ, .Ó8Ó %ߣ@D3}ffVPބut u3N@f6 Vu^Puu N\p Sh,z
tEfupu|t!F
ݯ@u
]]f^ϒffff  	     $ ` G$ $  GN N  GP P  Gh h  Gt t   G   
G   G@@ 0Ъ@ P A$y à f`0D 41ffty  Qf31YP,6ծ r1!l1 C11V߮C4R(1P`fRfW.~`2umf3gf&f=SCAFtVG t"ffff Wuf(ꓺtfPf{fXf_`^!	>?ҿ>?QR>  Zfs t SRrrpZZ[ÜPSpe[X| 05м  .>! G	NҸ@؋r `(t4t pp掊$2撰f!uOf=sGA t;!
!t#f!f!f@>f!E"r߸ "r> SW ^ۋ^&t$u%G&uFwtt	]( \DPQd pޅdA1Q3@tdgНoTJrdr
`Կr`3Ɇt 
tw Jt"<t$@dAJ_BQB/V66<|77tu878nvv55zz~~z	P" A$py~COMPAQ߰
 @
R3҄d 0Z$P{MMWF /Oo /Oo7[<)'ihPp?  #p؀<P7h *1Ձ*1DT`r(D
@ Jv@ArHvA.=sNfj@&t FN aR3V}'[Zr#@Mju 6Zr 0t 2rXP u v thr&3&E0r" r$2vs`.ÆUu
FUF \൴	!	ӕ_	r@e"!E	~ap脀^F&?s $_s&% &G&w&G %OD
 &	G'.Mf.u)E	ff&)E%*E+b+++VfQS\f[+fP'Y^f& u#}Wf0qA1`/WaP'F~r pt7pʀ4/r?P t8p tB4 tp62wrVAʿs/[	08!9'[~t$@:t@:u/~ǉ~ %3NV`<3se;^<Í6\.|uLR..+[`>Z .:Utap?/[aPWQS?ن? t0.}u.:Mw#.;]	w.:uwPCw.;w	Dw\[Y_PZ>ـ?Br.u|
ՊGc)Ѐ ʋ.Ev p$fVfvඏdDMHFo؊QH
@NP@K.eqXAPTHBs}g2H
-JfXMIKdDMQ`P vPR>B Yj Y Y Y~RPXuUW:>_]s*r qBP$<- r!PZ@Xu@[>轏[ \@{<@PY 2sXXt^y>OUd_ \ b* 2bq[1[   PR~>? P!f XFrrPr^rT:rOt :DvL*DlPmfm@:
u
r@l
u2 VWrd _^ rQPk&:Ev&Ml&*E9m"nono@:0o,rFonr;^@uxfyu< r
 apr&tpu
fZf\r`r`pR^Xt2K u @uu uﴻ2\S ذA[ 4[3D
>X`HDƋBa`t>;P	 C@@p$Q+r++YsapX!$!"条^ePZPQȎ@:Jr#@:Mwq>lt A@2:Tt
 ݀uOufYQ   <s&? ?PA3 >\}uЙ W[ 
 G[7[VWf<u^<
uu M;E<49<t5$S1B'[|u |
7|uP5u5 t\_^FS}
uӝ}	q.3)[@ )򡴢>܀} "a`0uDacBtQV 3۬`+^?YD0!)~sGc+fA1?ff?bffJofT!N
O2pXpf F PXPZfP~t$=r0&Йw)ޠ0Ef@uM1f @:Cu~ESVj|ttt
P^[PfQ
  < 5@ f	t
` xa f`fff.f/@.$Pmf  Hff#f+ִ f;wfg23g&Sg&c
uff+f߃@-X撝fafSR3=$XfPWXffX{ r2ǜ ]XZ[RUWXb[Go_]rQt	̷re` ]<W[t+ 1ǿ> `$FA1A0 uR
rrpU`a 0٪ðSQVf/@fk`e@ k 
 ` ր݀`^Y[u(PF P 2| ^	u<Vf+
or `8pɪptkr\^ uSP]B^[; u"V4`^~uMttj`V	~L
B8+.
{u&@#u@_SfQfV 3&=Ut\茷Q+f   f߿  `Ng&Q*%E  &ufq2`&  -\f^fYf[ѻUh &]S^ ][P*&D-DAV& fQ+\AL
^貟WfWދ@VЎ  & f  t@В믃^0w  &t_ 'f=g'+Qaf;vM +E

 Wa_f.`2Zg&G_		E3grB2u0TRf.`f_ɾtf`@]pStQY20fծf ,  !fo`ʺƙ \;`;/	!2U
EG &E/"
(EYfaA'nOG
w|r}
P_@0q`؎`!oi& '1/<t+.Q J&Y<%
fu*f' &` tj0YлF "fߋߖf.`g
g0d"1B1d1P'D6PݰA

r('u DP>uf.ߣ`:dІ4-<BVQx5$?6X7$8
 T^{3sry)9lY^=~hm"1vAfΰf(M9s"PVWp?HD	L	B8A
ftBΓWeP0fp f^TAtIߪf@DfWfQ D`	
R`S G^SWDǃ	@g(P5Y9)9 `NW3
` =EDؾ:%a\@DOc裩hCP`)qhDY`_W3nٰlg0]k_QdhQ	#
h0xcY&`dYu= _Y5L)9`
Wvaf[PQRRؽ qڀu@P@ ظ䠄t"
}  u!~`!t} &k Xp@ ׸ٜt;6 u6 6 -3
t,=
u
"=

u5w<t<u F}` t<qS $s
Ê& 
 [<uaw\wWQ
-u& -` AI,`',aԲᎿY6 FF';Іwt@2vPF X ꏙ dtPpq
tDӊ3qَ	
t	u%~g ,2OP-ɬ м  $PIR    >+<` a b c >b a4 i  f0 c j鱡phGhkt4m`   0 `3. W $p
_ϊͻ 
`aVWS;tЮt[ 
D[w_^|W3` 'Q t@oGY'h0_a~P0.  3ۍ6. XMt u酿 SQRV ݎۃx 拔 tcPtt>KXSB$x$PXr$}Faua!P$
BB HFJJQ4HX^ZY[94 2XPUv F t	F !Ff@]XbX
RPкʺ
迺@tXZ<*t'C*;3t
N&A  u ltgR't$<st\)ui)<t<ta')膺FPFQ QXFDӴ!0ntĀuC2F <or0"<tt<t M)3)f)[)uPɉGv <t]@<'wV(u(~Q!$<ws?A<w؀<'s*qa߃f ^YNuE 8u| w&|u tf tBt tP~i tEa^ t=Y t. wg͑(0-'u'r1( ^(G FvP X'`/ P0[FF P`utzC
䁴 '~@2fF` 
`u$,3ۊ^ÐPɎptMN'B?L$@0**a*
@ȊJ @t2123ȐU f!J3ٸM-ٜOo&ٝ3N3!p    dâ!r?f!"!>! u_32_  4_SM_ P4_DMI_ J  #f` tEu '$
_Ā &ô#ĴwĝfaRМtrĶ$tep	ȋºZf` u1A)g9/ĸ #	1$fa%	*P'@ޑTO OYe*$	!L U,]tf r.]è!$R豜r.f% fUCESsfE3E u&fuf#ٿf  0ss`R.RQ2f3Cr6~+f u g> ttr(uYfZ֐4^  !7"f@b)## c$$?%[&fR5"X)#t?t
Чr2cf
X.*)// Z0! V.8~$/-t(oϙr!`Tq#u/tl*3&V.J 5"2?t:24g&? n,607cq77bQfRQ8t ,?t
?u$2pH;@t @u `}tBt CB
zfCq  t>?nAFfAFuPGBFY[SHfI
t@  t}fځbQ2GbIXriff#LfR f rGfZ3tt@F$`PF,F$t qQF ЮZ8HfVQ! r#fF= Y`PPFPWFfF  f rU1F$P8FGFk2VG&WF"RF(F@V(&WE{$PE	R 	\ ސ\ SfoP_*fX@	 [bSQWfV~W  ڰo_SW<5t^ fg荗r pf^_Y[ryp0À3FûfFKt
pSۋM!g8ouR|fVWߗf H # 1ǿ> &=$u&}Ful1ul0tfxD_f^`WV߿.gGF ^_RsrD.\P~!^RqhъZ[p oqQQRȰ>?vvv?iOvwYOx+wzwzS؀u
?԰i#|_#|[yZPz?X wwP||{}Pw( w>'?|؁zP} qWt_wZwU
uQ~rEt> r2
tC rr r԰a q0!Կ  r_Rq2
uC9Gr>z{ww0Mrt97rG Cs~/r*=rP
@r 82Wwo 
  !p  t3\5\wbw\$ar:WQ~?  `t󳠹[_s0@OrGvGQ`f << ~<< u<< l<<c<<%Z<	<?Q<
<YH<~<?<<6<
<-P= uX<<<~</<p<|]WfPCI 0,u_!?VWfSt$fѻprc f;tN紃)"Pdf[_^QSְff@ 1r gu쀳
N`$u; s7@sPR辿Z	ȝXtܻмZ濋ռػfмwPfXZ踿fjfuٻyмFZU[ٻVм#ZnF:`h1мfPA= s"cs B sH  QVW&= & s۴`pK&EAfX  _^|Pw  ;t
X2 *W 
_ߺ з#t*X 㤃N sRQ胾уuf jfPff8s2fˑYZP3@@Ba{{璘ݯA*qAAJs@PP`FF
]X鈿 `j j v
@ )Mf.N. JtI ~rqp3؊^)tuw t&Dup.^^t<a.@t&ڃã.^2Ȏڀ36t6^2~. @ PSF@g
t'.:t	màX._ S ^Pqp ^\ÁUUPغ   /f  E2aur-s(@ RH rr
 R+VvF\r:Gs5&DC H PrfڋyQ_AFÉF(t S^$:u [r
F&F$%&=vHH&
D&d̠u rcwu
 !πϠP&DB êĪǪ[` TVc HUr~ap1Us!
 -s-u fq}@
 E PF&G )
V N8tr>u rG o!F) r\ A{r=H r8rWsUTsP&#@Rr
!@oM
a|`[k$F("r#謂Qlr@rk2<t or~F( &d&KV& %f)&t N.QSWj@c/ r)v,pufPs fXtā)_[S<t;3fBjt	fسu
ut_f`iS`
 3p.afPԊ܁ɊfXf<P    X& @F$$<r$:u s
jút좌 
   @738  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (P<$<'E<&f$`
ĢF f%$`BG B<(0ø fF" PXۋN8NwN o2N---!`GsH?-ßGH}mIn-`
 r
sHаmr77u&-d_"&&%'Á3bR&u r05/t36eCE VQB A9O9 BYy^а 4s
3
3u3`Y?,dS@Q%uètàt  !'&V&T tu^
*P&u^ô  	  QPXuN%&:Lr * r$C`J \@uа<upZt+Q.Ϡ@ -h; E 7Op+$<@tgA9Qj9" !$!$wQj`BoU{0+0Vùg
+K<P[bз#*E.øJbfUQEufVKGrKfXfugfPwNPwVPwFYf҃u&gfFff+MuY2f^Yf]Ë: 3R)QSfVffLfT@DfLf^[Yrx׿Xt	A,PXøMøNO+QfVfRfUfWfP0t3   fRfZ֠f_f]й{[PfW0tQ uUP@XYQR   mP`YXPt
 t$0tZ`|tTXRfVFtf`F*TVSQWf氶w#t r0{ Ԑr	0{? _Y[f^9CQWVKǑ}^_Y!QЍW2! u[ك!N@F R Vv 6^N  (q VI>T󤀚R q^1{_fV3۬
ߊ^S (e -r $pSfV1ًfa[.63fff`;w	rf;waf`q2PS. " Eu Цf%94?^oAR_0e$''ذ1000= <r <3ۿfȐf
ffʝf   f-   cDfP W>)'k3&G?;r_pSQ <m ߹ `ASUl Q	t[c )exfsC3    )4e f     Ϳ  PSVз-//߻׻^/пǻ.u/&&^QQ pfQ(s[@ ŀ @ (fYrܺ0PRff ZbVW  #w`_ПX` @'aFХoA$"AtPSt[X<t#<tQ< uaӾ PKp<u    %ӿ$f Pȱ_aҴUWV  Јp $p
t6s.ļP;uujU!ݶ#SFơKutAދ" ы #иЀ a^_]2S{Bi#͠3oxup0 	u  |YѴWV$Q!""? S@X'悹t$@poQquQRW ߺH$tu_ZY$ aq C8BBaaH"a$at@0  3FfFɷN
~fiF N@(3 'țn ]
 RQP~ǯXp0IFFYNZ3	A	%QȴY`Њ
  aÇً "ԃ  & G$ .&'@'QRp ZCM
} Z> @a XYZð
V
Q R  0S r = ufh   XXߋ7[	؍6   v ? q0
p 	`%&a#3 `@p
gUЋ؎]EaVC3з
A½P@a`P  )g`#s![!}"Pۊ$9SRZ[` `$<uP 3 0   fa)+3+
,S !7} 0(`0VQl3#AY^` a
aÐ3RQ3f tf
f3fRA0f;v+Rр
TYX0GY@ÜPpf@Ph]gf_ff__]XP%`<u
 @&   >Q<@tA<Auq=!=P'e  ,1@& X=Vq=>  0`O  r
q== P<Fu u_os	Dp=u!=CG
u	 X rEtGTtu}E6FtEJ@HuUlrPRtKxGJBM^& 0R] Z5$u$Duh@3 hO
XuhOXs&0` @'u@ q=UKtHH`J=mrkr
nr"or d P迕 d`@a$& 8t@X  QX uSX^ _`@YEH `*3Z: 8WXZY[Xa @@Y@Z8dYjF NR9 Zðx%@bV
uW@<wZ؊'ðbG%Ë t@u Ê0
t jh Ci3PihpRS? $'Q
߈& Z 4tQ*uG&pBbt't!&C 0ttŴ < /j >N w!u r
?u am@^< u'' t	3r騐u@ x
(&ysiz
u`ˠv )뱳2x!{<xB~{DtkŻІ}H~E@Kt?t
T<`@s /Vi ttD?R 5[I+.0ϫu買$'@t@t@<t~ 8't
' [lucs'8tK0Ju<tB<t>Hu3"$
03"q u) ?"   
 3"$"P3Ҏ¿x ȫX8Ɋ  M  G G`" * y 0^> *
pY?8y Ay bԛc ƛ RË苻]ЫpEU `ʋUc#"菛rD෰|rð˜f`JRQW %  d_̺ &UYU &E! to&]ZФФf۸!0!t"Ĩ@p  p
 = XPJXSP +. s#. sXP &   &X[ó5P϶.4EG6OaPpσD
Ej@0 t%v v t ArpJMv .sN-f-&A F'N- @'ύ6Z B3hr 	
F (|r
9	u^'Ât %^d	A*0vrP/Trr[v
u< r<0~"N@P \o!u'P$nvPf<0r
s^s>&\.u.
I.
MȎ.}u tj@&u |t
` ^!N%V#~Fp2/r2s ss6< s
	OtE""Lt*$Ot"#Ot%" 2䒸)1ˀ o׌ .EF2Tѱr?]wsHms1}I9 <$u2d*<#"<w u<v<%2 ÆUu
F!UF%  ËF~&=r&}v8fRF'P^S^!S&EF'f&?U&]J[ [ߊf0esʣӀt^Ë^6V\9ܐ\rfm	DE赺 ~(LuTMsafPfڋ}3fXr1>\\.  .GTϿǿp0r\./ c\jV#:TNt<~'t9}ra0:\EE߀&\D_D`%`5	\~ PԹ u0fPfS&Mf.\f&]f&}[1'Q  r}蟵rxt.rl &rdtZ+r@ u~ (um-VƎދo?^ tFffmεrНLU Y~r)8r$cqr	r rj萵U`q K0{~(rw
u fSfRWBt:ـ?f.EffffUffs ̊MF F
tSuNfa515V\f.W*f8f'w*f'F'*2t*܊f
VvfVv_fZ1FsQU n E]YRPXtUW:>褶_]sUr  ZPR̶2BŠ Ǡ Zp`R@юߋ Po^ZYBp!SQR1` cɵ m  གྷP% 'P%tP% Z^NzP% t͆膳r{_| rv=%>b\= \\1S>V\K1ˊ, c5<s-\O8LPpd" >h\G<#<$2  \ZY[#PX ɳ ?k &蝲rz5ru Ĳri8N貲rWxu
k2ع *:色r.Ǵt%ttt t	sC3% szԱr3	 2P#Rw_Z3F sH<)t<(u;>A u/WU>)Խ )]_?qr@бʞe3`0-B^'a#4# l 2ȱnPRFtNw+P*XqН	F
+НF
t
`M
M*XfS~ t=~^f~^^~^~FF
qFFF  f[ RfQ
tW 8ؿvN^~nNfnNWfˈNnfNnW~*Ċ^
^mUfY`VSQfPv j 8rC8sfZRfXfP $FfFQVvuްHfXr+t`33 tf0]f   `f+YÀL=yu$@Ύa2\t
.hEǩ^ fF! PX# t<"u<"tV3޾x 4| jQ&?ws>  os&  p &Gp qGp  @&O &O0R`f&GQ@@tt1tMWu׃ 1t0tW`K@tX<0A"QVW̿:W }tNu~u .w6 u/ P?01	
}{ ,{61oa}OGA&&d&D&t&DG_^YXV=w} "uB{{\
 {!^ _:Y<`SS[PS3oS[
ʬRiRX Sa] $W_bc2vǳПûc3#s3ɺurA3[3tP3@A5fPAMSU $VW  Ў؀ ߅ %  u
  
u01˻ʆ ݞro;vm F0:& O:
 30&Oa˱5FUPyn̓_]vy
@ p__^3ɤ{CSâ3fW1pf3w h؃n MB RW ! D u :&FGvuDv Tp cp<u#' M& 1&%
{;0>u߭f3  ЁX=uQ& 3߆_Z"GF< uִ u2D#0 sN~ t
SП[ñ =NuBpR
u0P ffppXhI J 
qΜ҆Q1-w5"Tr/-u4 $
ǊPr	؊YAYfQW1ph f0?f8hP  `  fSdĐHUŷ plw f
0艀ê rMf[15f{ 0Pf%;tf ff w &PZKfXp1P_0gRfxpffúθAZ@Po΍XfZ]`CĠ`d f0@u
f<`~f1BQ02ef%
 j|`p_ZB3_r3ԧ苁tQؐ69Qf\`f ft~0" QB`Y ffhfa1]fuӿ e3ff0tf OudQ!؎h{
@3 6ذw8Du2f3Y`] 6T3q`pAw Ac[t۵ ݜh ̿a0f.ffpjͿ! f6gfFfP f$g {ېPqgPwfXA }́Ɇ %pffaPWrytpPѬg cKrQaL G B = 8 3 . ) $       _Q?&GY`fg Si &  
dfa(C)Copyright Compaquterrporation 1982-2000-All s reserved.@m/w*VR@ ރ|   t.Z^!VP P .1BBBX$JJ  J¿B#P0ܰ t
tJ Xua03@V tA&q JZ  C@`4u* uP= ]Xruŀ̀2	30# F (8SQ2<

2ۆ.
$v2pก !3<ww0#
u  `     Q
! YQ#8  #$#PRS%@&+}@&;w[JR:ڜuaa@uXXZXp!濡 /PXǻ  Ü= sr_s+
3,,_{ _߸^ 3AQwt.蹾0! /0蛇諰2!_}Nq.j.b;a/PQN 3۸ K 򰃒f'  A G#y 8P8 y " ËEu
$ցrۂ`tW   d_? a_@/AOBoCCffff18 p9@ @  "`:FD=-18 F#G H ?   *P9	G%18	p9``" 8d df"F18 > #Ga afF Fp ~0Gr r"Ls sL
OrEcN P" = M
 "p9 +O6nbS  #	K"
tX\ fX0#Oci0,}`d$!<!uy
ء\`&"&& x<u&  V<tr^@K^D]8t( 2 ]']x233.f׃>""   a0b2ۊ( Ҋe) ǊȊ&) "f* 븊*g>+CfgPhf>},3gPh.- gi) 3rAji..jijPgR;=DK   F  @0Q Q"FPk萑Xpnf`g =/Պu (}$
}ô$}}}0RVМ`u}t
Pt|}$t^Z-f` u'=wPtIt)} $#u9}$}faR/`P
Xu!P<Xu @P輑}t0a`
  P!@paL  SQ q t$Nx<t.1u
<v<s<3vm 3^mְfV1SPo1X[u 2f^#u 1Y<u,fCISGu%f»P߻ ` f @ .>2 .2Ê$uGuô \ S3ۻr?4{3' u>$SMMu>X ѺdPu
@uXDr 4ras\2&D
V &DtH  
B r!`rsuEF.`2P6$D%rO_sJڙK Û$?rr
jrʞPyϞZ @FFtN fF" ppB@F(	r22ۀ~ tp]{  t3ҸK3  ;wp;sbFVFF"F
 F)t@r4F$
Ft+ F p  !VPX_VP"` _aW% u{@ZX_f'Atp'p$q,氻.3۹ 3Ҵ./@32 3nuo0nC/pÊVVXT➂!<UUWVRQSP36x @ fFfsEYc ,Xu 
<t<t$< uj"<w<vr,2b? [&\@ N [[YZ^_]软u9<u` @aaYs^rP`ƝtNð
2
t
08ujÀ>AA	t%j
u'q &L H0Wjs~ƨu	VuQ2^ ˋ
kNj~bي~\ك@كu B litGKو&A J
®y2@aea'u$<s'ذ
i2f 	.c u-QطM
~Őq`t
т^hdhtP u pN> ubG0t$p<pupukhH'ߊFO 8tWG.""迏 u33 	t<uSկ[u8st,H@>50\> pd X߷pPۂB st2 	=3u
Kug&> 8%T鰫+43~u_ P5Sַ5X_SYSID_  1Y _UU! fl f@f="uf3p fl 7$PnWP!H0TPTYX5fPff `FfXtfUf	fSfPSfW0*tg]`rfw q?rdsf_#fXf[f]ge3pbtrVd4Ad^;sgu0
_30yts M ptAt<V|tr0dDg_}
^PVW!>^gEdTg}t
}gE Ptr00t}d8tPW<ytu@Drs0fU@f]3
t縅 Q;u Ó' s.;Gt
._
up
fg6$+' +k@ +q 1 P a ~&  '  ' # 4@(E@ (' @(@( # *8 *M	 VK L   
  
 -t " ,/    	=XHewlett-Packard 68BAR Ver. F.16 06/23/2005N-=. /4
5 05L5/ 1 /3 68051!0sion XX.XX@X
 
 0</9=j57#o5 @`S pXU10 In?tel(R)=D7 PZ0NQ!Crnal L1 CacheF  nGG2H	
   PC CARD-Slot 0  owww.compaqM  
	;en|US|iso8859-1`T
 0<AZ!AmJ  2NYN-4DIMM #q1CCPp
oSAT2_U{V 4RIF 	@G2SST49F008`
2 ?2@\`[~6 &N~4
 "A^@GN  A~1
@8 Bp1rimarqy9>C8~dNMultiBaOfog482  c   n2  kn 7r !KENqDp`3"A1	

 skt	a^dd4x"Nrp=5N_o batHy8"/yOz>7+\QPÃՐ`*UH.:f t!PIuP.V.f] (<sW ._.  2P$<wXs2Q2...&+.	 2 @ t^T.&u @ u42..߶
tw5Ő*
t*İ&u XYP3 QP0 A3.G
XY0&23 *.2b WȎ1%1_}| soϞ/_~~~l|8v0G8|r8|8as|çP<<@n  <fBBf< }x<fff<~?3?00pcccgZ<<Z >>P~~<Ыff f { >c8ll8x`~~® m@n 0``~ M  ff$2B%0xx00 0 lll2llPl 0|x M0f 8l8vܿv ``20```0  y<<f!c0p䵑 0  || 0p0` x̯8`̣<l 8`N Ppx<|p`aRp Q|x0 ff|ff@೐lЫl bhxhb3{`2f>  ``x pflxlf bf ƿ ΐ8ll8`<xƁ_xpcʸ3x0 `փ̀@ͱ`x ƌ2x``x 7 xx'02x|``1EpAƧ8l`ˑvQ`lvf0 Qxp``QRځ  a28A   bvfҷ ?0|004A8!0ᶀԀP0d 000001qP v!2 uUf SvN .k2[]
fPQR|x>@  t&? ZYfXNNT\}NWNeMAY9Y.XnSSB.(B0P2X`3Ҵ u@IN@I<tDOQYRB>r8r*r
2:6 vZ aQfRPCI01 ISp] A BR03COMPAQꊙ 005   
  p     ˸ @؎&м  ; r' W@ P& u_SV  GG0G hv  8 Gu 6u t3  hc) 
h+rt & ^[SO
&hre
h[U샿VW ƿF F   `i@3 FD2ED2E
2E2E 2 @D(2E($
f&EvPZXuf!tE/e.a	 ƅ @.<t	db>t <tjjjj3P* S.wj5Jp$<t.<@t$t = ;t= D hGcv ߱  7cFF~ t#^FLr
F Fa(U(~ t:]''kf
 hRr*F)'2(~ t
)F_^{Qd!
hRs .&4/udup   hr$?wط2hlRhVC4ChF
 qrf   f  f   gf&Q6..  1  Y`WVe1E0&E.&WV .^_UwUna<Qc< 	`@.e1E0eE'E.U s Cm2a h
$e Du
g$Q
a3QCr  utw
t1w
tAPSQW33۹ G&./JNK__Y[X MMMc1@~M@  OMpM dB FO YMMxsQURMMd* &  <!TXM?C  3Y[~MQVWh5:u% p uK1__)  | = <ta;P09A9_^Y!JRW`  Ê e
Crr3ɺ Qe܋
AB rN _ZMSqe Y
ujizjU zj%1 DE<@1p;<<݀1p<3u """ka#t
#m[VfPfSfQ f3f3PXfffDDG(	Dh fYf[fX^u 0gO GoxQR@<3ۊED 	 C!~sG4Bi3u fDf3ۋfË\y
S{  	T U S V ;	O	c	w		`h	Ph	  h;	 hO	 hc	 hw	 h	 av.L.< t)F.6Q3.PF.h*+[+V.`.^̋] dF. P!.hrXhgC QR  16W  0"XYZ#[  
\a_nbA]fgb'^b` Џhijk qp10GpppQWĀ> t		 u		.	_c   O idJһ -ww~C.=e
/e
U@m_noG`L3۸ E =_F߸^FiQRrPS8[Xf%h?CqQDЍҋh
     V       ?_ 	?
_
 ?_ ?_  !"$?%_&'( )*+-?._/01 2346?7_89: ;<=??@_ABC DEFH?I_JKL MNOQ?R_STU VWXZ?[_\]^ _`ac?d_efg hijl?m_nop qrsu?v_wxy z{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_ ߱?_ ߺ?_ ?_ɟ ?_ҟ ?_۟ ?_ ?_ ?_ ?_  ?_	 
?_ ?_  ?!_"#$ %&')?*_+,- ./02?3_456 789;?<_=>? @ABD?E_FGH IJKM?N_OPQ RSTV?W_XYZ [\]_?`_abc defh?i_jkl mnoq?r_stu vwxz?{_|}~ ߀?_ ߉?_ ߒ?_ ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ş ?_Ο ?_ן ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_  !"#%?&_'() *+,.?/_012 3457?8_9:; <=>@?A_BCD EFGI?J_KLM NOPR?S_TUV WXY[?\_]^_ `abd?e_fgh ijkm?n_opq rstv?w_xyz {|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ?_ʟ ?_ӟ ?_ܟ ?_ ?_ ?_-*p! -   i    Q4 %	 D0%&T8 06W (0800U8808@0U8H08P08X8
h 59i  2o =i/!D##&/&O'b  )&  y*  ,  .  0  2 PSQRй Ys hPv ZZY[Xg&ǅF@ۀ988 Ã tfPfS
u	0000<0rXf[f}X:g&8u-g&
@gf&fB!??BfP+g&>B9g&@T=SWVfW=&2>X>*>f BSCtfGg&D= $"F<vwD"FCG D| u:tHg菂ACDB'B_^c=QRfUۼ ?} 5tR>0tKBCt!?E$fu
PpNANtN0OqOt	dI"  }f]ZYp=PSRi 9uAC.XrAC&PCTG tuVb0< `M'f5 ?*bX.bX2Z`8P A; u
@:R[3 t
\=SQV3ҠOCICHC  :OCtzffKfIC?As8_Y8ta9fF*0I8$ЊBb*PX1JBr=u2^Yf[PR 
 ZSR;2<9ޢ<9zhS2h7rZSixi8jħ

l:A.>oou	f 5faXEf`?frqs=psq|r^fWDqaXPFfGuE fqD$
BDutv f|uqr_^Ye=fQf5pf7pfbutf  t
gfdD0q`~ |rfgE{{A|} R=P{VB QCffq FFt
hZS7gvu ?>t!?6fӢB qBf0KNf^fQ8SV  ^lQ  A;\LA;t% BA1 0*B7>	uHCHCY1MV
:s  XBTq$t=f˻,|"q@0f%|@Uɗ0d=QRV&<0	<0&L"L"""01wxvBfDf% ffD?7@^Z =^gs0f X43ݠ|2KÉqd,\"\l"l"111&12wş"K(X:Pf 5пsf
p aXfff6{_`E8$1h &7Xkini8jZS0hkZS`8S [<O&A: oZhhR&0<[Z8AJAaApFfƲ:QfRVEu/:PN 	 o 6`58`9`ʣ:Uo0f3 ssdTpv!?!{@F0FfC/;P;˿_i'z#G cj#/v;&7Ơ_ cъNuթ5e{ay脆vؠ@Nu TѓBC$U^fpSa=}001?11SAAP0G^lD	%ÉD	f@ƧoAfpC<v PfUPf{Pfff!	$f41f<1 f	<1f@1fff]Xo t P9/1f!1r _@8p=R@qӃf;3Z1C X;>0 t! X `<*
 X0<CL`Lf;0tf0f`0 8z";$KicjXf uogf ?EM{> fù fgf;t?)gf+C k@̻hix`d/ 1_y *Ra=K9KPV`^0`; ^=X0;0u0;R	bf. X50. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ?_:*86T M54	# !
  5# #U4444!	 p 4$44q!p  "!"!3  .>$ %

O'o()BB)+,-./1r12  S@ hB&Bc;!Iru
w>Bj @O7>r6> S!7tBBB>BBu 9BlpWCl!7r8B_J@990*ZBBBB賔7a64 ?I`6l3ۊ؀`ZB&;CaA^B;<CZ3Ǳ@PB7VS@t	T0"B [^KVB"AFBFFFUuDhS¾0BBۭL	u5&SCuSCDA߀kJ:Bt_b0P[gS> @OCS>CC>OC]&?Cpt(
ߠB2B0B[O0PrlVt>BB r1AVw%VVrAϊ&B#ST40XSWB8<ƀ8k [HD4EtEhG3E9FB GAPGG<pYI`\A*[0AC?GrAC&PC]BCCNN0RV1J2e|))_rhC u 8B $12B迌g&F@v@p{HsPkBk8B$l[w> po$3@ p%u0q'huQuvtrueQu^w\quMq&#su:+8rPu)FvtFvtFv@5 ,= IZ^QXp8!u	g&|t|@sSAX[P@CAWC^U]»A`r' PNBAAABBעBV.ott0A/0W> @BSRaH<v
hHC,bICBʀ 7RBƻGmr )R艵@F1FRcAG]oFBBB:BwPA5
a t
d1`x `1JBrgo&htBrC
BrAr
 JtVŖxintco=LQ2ag>a6՚WuEP g$PSXPSZaH,T UB_{%AA K} "u3Q Bf3fÇ" Bfлf3Q^ C㫉PF E *   <Fu@C3t	Dt<Hut2KtKn $`u tP%X!=C !7:C uB<Ft<Tt<et<t<t<Rw*<Ir&@C
2QtK>? RKA?QuYVWЭ5tAQ ft(PǴ:>Cuҵ0 gXfCYG609N g2â>Ck>Bŷ=C0Bt&<C൯8r ҵ>@t!7w{0$_B@CB2 Bf?pt<C:<tSQ@Aذ oY[pu
?l!21ֽUqVWWW*XCopyright (c) 2001 Intel Corporationf_M  Q;]uhFz@3 yMfޱ2f°v t;ff[0t*ܩpt tt@
   0L+&_%f_Mqްhj胒)u" sfsMfȸ &f%mܘSf?qMf }00YgfW`;ugFsM aqfgfNf!f벑FkMffgMM
ffg_r0p?gWfgG@SktleS[@ޡ!tY uIfgV8~N^fn f00! u&ȷ0f[QSfWfVUf&ff{3J_ffGf;qG<uAGf=_PR_u	f=CPU0;u>pڭ ځ0SuAf=NPSSufOffbk0v/8f!0{0	fF
f;sv}SfFrff3u "
f$@g&@@
	fM6FH.JG	"0)/f Qe1yQ
잡G
f`أ
!fItgJO_	S
!~j
_D̱f/E.!BQ.f_.^
utd&ubnmmf0(+؋{*@7f+ֱ.N20F	h"":f^f_f;kMwe!cuA1J8t3gF`2g^ΐ%??pQ0z 	 @ceM" RR!upVte kMJh΂I FJ u`jf3pft5f6_MRڡuRR  Z;`Cd  f&_MEuPh3<u	P!%RG$<`<0u_$ +HQ`<t<t'<t<<t$<t,[fMJB>= JO1) f=ISGuPf0sg]M  p;aRt f6MP>fe	0;@[j
Xf _t6sIC0:NB*"UUg IaAU <&}!&>pC#fw+O"<	u<+P2fN'`PeۊfGP@^.>gdɮ$1s&& _ `.@\veZujI_)`@ ld<(rl$m	p<I1)`rdeK,1puX1m }_eWe X@\|gf'dP0Fa/􆃢eef{0kiu`K HM9NHtA SDA2?Z hc+`3UqZY,P,  ]}n
  Nn212)

A
 wed &d   K.@Je,U#D" `mۗ"ПȚ-Y0Є -> } %1 6ћ!  ꂓ§ 0	ua(1q0ě-4%(a0/4㔗 !j§o _,LQ}t
 2r[%Sp!1qU1Ĵ&D!ĵDaζqRӨhBS4өQ1Q$$?%EWCDmHì6C'!1/)!ĆU3PmF63'tq1d.ɡʁvA1ᔘ:#)9+a+D1ѯqAրY&
@J&RDHsёq`%#t@!" ,SXJp&Q$hB "8ì.D<C0qS
A㰞' (#
 4!	l䓶@
@J] P	}  P  8Jkؤ8Bo) `@ q(Өځ*
У%@a 	jXbQq3
$Pcs3D0b1&xiq	bÚ֖Y( [(R"A:`,Ѷp LU!'q'$D!D  qq&q&?_($q$"DD q	(*У(!4롹w.')*1'$4 1# /Y$1QՑa	aq;(jq($"\D!3aVq'O o!"&qqa$($"$q$$aa$ q("( qՁ!DqD|"'/ %!$ա$!ߥ,$U'6d,(!t@a+B1b8' <=%?2?r$$a?B\w=av  F HFPSQW  hihqi_Y[XPR P4K ZXðLp@  pG i zVN YfNgPKYttMQvRW УxR`УxSУyRУyS [yT [gP V8Y RZeS TZ)U\)VZ8W\8X]:Z _ NfWQf!P gf&D=F?Yf_c dD=f.cog&D=.boe.D
$.>Xo.%
.D
or.% .>botcbcԹd2eggVhhsdo]rL!md
hJr93ikk|= USBSu g&|=rti j`ooouoгm gwarFr  x8t(Omhio0{w{j`8ezcsgSh0i`kiqot P}hIr? It5QfP}cO.F1G e{or
vcCfݻ!RfЁ^qf@teH.\
؀g.\hK{`vr|~  }`q}h~"phuϛs$vjϒsw{}W3ek rCk g&D=Vx lWy /Dk3Hu㒦oSoZ$(Z}(yQD7$|!N=%dĝy
OD$$#$F`e.jϢS@RP2  ėh >2\u g&``T=
X,(fʴk&`_Gė:.6oo.oo . fPQ f.>mvmo f{+f!R^VuP6nno +.j?f.6jek[pfAl YfXIqrQo JfaúWߨSBϬ譕*QfPf!Rgfk
fXYrλl aS׸GJ/js⻡j`GODأc`l=3 o&\t*D\t68\tBoD$
ƈD5ƹdAl r
rђҹK i%t-Ơft=fT= t:tt h[PIǑjae~ށ(uVỿrLeB@&\=@tD\=t8\=`	t2\=`&\h3c+I6EfaPSVo8dtdw mepy_P}YϾo8DtD$ aew@ :p4^JSQdO	8t`g	G	Y[CN@"GmG	`G@ xab`oCaoUGF!F !O'`bAGw|(}}}{qqgxgxjkl5mqr1UWRQSPV rwtj `ur(ffWRfhMI !J fZf_ uƥ@QCaPSƵpug@VoZ@Xo[o_Ro/ ib\] Sokb_^ Tod[XF f scO t  ^X[YZ_]c Èqoto P BsB h fdabu
!ro!ddfdpodp>p6t
d@ddSܐQ
ro!soBfU}	f]q,>@u%ttt t	tfN tF Gru@>^:s
@136D\uoF ėD
 SfQVUt"×th\ـ?fPfDpf'f 'T3(fffXs@AyuptLuY'f3f0	 f.mo\fW).*&mo8fw*fF*2t*܊.&nofX^fY[̠OCDCo rԠf["p^f4"5ĀuDrp^vNox lhxlԠjSQVWU&BC tBC ]_^PLS-120ZIP 250PHRVsq`a``44A?5|58Uoos
hGrgfb<tV< uWQsf]c `:kuFfGW(UEEFXX  U
ZYf`BCu goA3EC`oZoao[o BRqo79RW9F:A׊'7[} tE.e_Z[M-Sys   DiskOnKey SSK9iBLFC uy @  f<x fP px _=uE"F΂r 2rp0s0w6|=1s 1s	p ?ec促 f@fPuLsu[t6p r)g&aWug&Eg&ޕ~В ؐ&' rLTf<VL\M]bMSMPUNF:A׆~Oe}Pܿe0:p: th;t@  u amu aRpK3ހ'Af?-f`2'-!q
q]fXuײU?K  LkBLGL_M^bMTM9F: 	 `W;PR)j3WP>ߊ#>;P>
_lnh銒fm;n 4  hJ 5~~Z A:u+`^s!$?
uo$D[p 6@	 - iBd8兀t 0	v`S 0	d8t|vh!mf!	d֎dЎ0	x0@Jxp@y@y@y cg 8e ))88: : >0	fWQf!ژqY ! D5 o6No}osRP	?otAzD
$&o
ĈD
𦱤s f!g&|5@er`r a`xvveM;y %߃@`yH\
Цo
܉\cse `°y> c#Pߒr`4װh!	&Qp"W3*#~sr	aD=1W?tPֲ9?Y0q|ô('蛿rkȲH2\u6o=oo 6PrEQfP^!	.u|f.6q|\gffff.PfXYer"gZYK!9*_?UͳoXYˤϴ0Ѯ¹D/osF`g¹? s6Ytd hPsCg:u`(uI!r?&\=@tD\=t8\=`	t2\=Mp&&\OHQfahQV0L	;t	E ?$pرy&` ;QhxO	8tg	G	s;-0 0  r    @  Q  6 00 3 
*Qq:u!0 3*@rr J3@ <B1  "@P s30d @U	  U u q3SP U? ? 	BCA FA1q?F$f Js3 H;AU q qU37!̆&3)5( 	q(31  q.Q*_}10  UQ3
 41p- s	
 3S< .P:U;) s2(U'#\&6#<4%-8s( C< ((G3@@uG0G  7B8;U&U&1N @O0p`QYr<f.;0t4Uuf.0y# Rf  P]f0 3rgfP=  v	  +v> f3f́ QXw   #!Z'!Z6+Ãw tQV@ ϪZbZZ [{ǐYǋ;`Xt./_ Q[./fRfW9@f_fZ?*r_U?ffQUT+QAcfffROMIfߺMAGE ;{ufWtg f3TPQ`a߹J 2ҀfGZYXuɃУG|0G  Cl Rh2h|t"tAo~o t	hV  WSQh|tuY[
Y[hW  s 霃mBku'f t!vw X @ RfG9 G}GfԓxfxfӸ fU3; !4@||W0{
UȎccAcUVP`Achx>t m PU  g8@ B; Ѱ fPfSfWU`cu	fP
sKcg йhGCg#Āu`&ztPfhfT@  gfӯp% _fa[QAqifVf3 m XUfĈ]gPg<ufG!@gt!>tfOuIu0f.BgO t% ^jfYAcr p  fW
fUUx_f*UǜـϜ❋p suf3ɊjtfYPQP@{Y 0t  XQfR dr
fl fZY@aOr uQT4Pbt,fU'b r'8tfG⻻j$@hZЬ@8tpQ[G` lfQm8  N hbhqb0dc_  gp ֲ`}hB  RW0  ֳ3Mɕoaj`rK0Oºÿ.OCP2Xf36 f۹30f\0f%yƥ # ǂ2_f;Tu@f">>?.%ό%Ќ%ьP.&̊? `̴ Dʹ2α#< u؊Ð?񿰔#̨  ruU#̃`r/Ȱ#胶֊$8tFPSr$u簄n㰆g`rL_rۯG@@9a%8rބ  aQIUvPPF X P.=.;AXP.=.;X/ Oo/ Oo/ Oo / Oo	
/ Oo/ Oo /! O"o#$%&')/* O+o,-./02/3 O4o56789;/< O=o>?@ABD/E OFoGHIJKM/N OOoPQRSTV/W OXoYZ[\]_/` Oaobcdefh/i Ojoklmnoq/r Osotuvwxz/{ O|o}~π/ Ooω/ Ooϒ/ Ooϛ/ OoϤ/ Ooϭ/ Oo϶/ OoϿ/ OoŏƯ/ OoΏϯ/ Oo׏د/ Oo/ Oo/ Oo/Oo ?_
 ?_
 ?_ ?_ !"#% ?&_'()*+,. ?/_0123457 ?8_9:;<=>@ ?A_BCDEFGI ?J_KLMNOPR ?S_TUVWXY[ ?\_]^_`abd ?e_fghijkm ?n_opqrstv ?w_xyz{|} ?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_! ?"_#$%&'(* ?+_,-./013 ?4_56789:< ?=_>?@ABCE ?F_GHIJKLN ?O_PQRSTUW ?X_YZ[\]^` ?a_bcdefgi ?j_klmnopr ?s_tuvwxy{ ?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$& ?'_()*+,-/ ?0_1234568 ?9_:;<=>?A ?B_CDEFGHJ ?K_LMNOPQS ?T_UVWXYZ\ ?]_^_`abce ?f_ghijkln ?o_pqrstuw ?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs ?t_uvwxyz| ?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  ?_	
 ?
_ ?_ ?_ !"#$%' ?(_)*+,-.0 ?1_2345679 ?:_;<=>?@B ?C_DEFGHIK ?L_MNOPQRT ?U_VWXYZ[] ?^__`abcdf ?g_hijklmo ?p_qrstuvx ?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_ !# ?$_%&'()*, ?-_./01235 ?6_789:;<> ??_@ABCDEG ?H_IJKLMNP ?Q_RSTUVWY ?Z_[\]^_`b ?c_defghik ?l_mnopqrt ?u_vwxyz{} ?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_x?_ SQVW33 &&_^Y[Ü` غ   nBnnnt nJFn aS [ 3ێ7!C &?!Cu3ۏf&>CPQCu
>W^ _2E	R .'ZSfQhv f< S .  [a@ = À> u:ðqIq`&o&O&7aPQRf&f=DtZYXð@JIACIȰB<IڲrAýS2P&W g&u&87u&8Wu	&*guA   YP2r(ں 2 t'sX
yW# #!u
 !w"W`\0Cu%5&t	 r _Qr2#$!ds%QYP XSQ I аOGLG;vhJ &t u2K 4P 蟀ʈXRC77e88&h薈>89&:38h{Fv.  .3Ɏ٣gi
FP/./u	`?upPQfVfW hq @gf& Af_f^YXQWV
 ߤ^_YUCD}D+t1QWPPXhX@.X=X@uX_0YoPaGDP!Xf. $>`7u
PF@XuSWh , s hc+>&M&E&MM_[{`L>1&$PnPt3Pt"3&M`P1NE<taðTCA#AK97LKAUKhPUUU/ULK:UOZo[\]^aAK
<RwS2.d[*Eø BE :EаDDȧfY&@f3ɋd&G Qg    f&Pgt`iffBf;hg&Gf}iwhjwURgtNgtGFkf0mhFQgfY tgOhpg eAYB
fP@faeUf&ffgfdTOI vCNFOR J 3fSgdfCf[ u|<aw{    (f@t6f!f! f3xDgE 
tfEF!t{ f!	xC< uxC u-y0 rPmgdC gZL>0"gdK& tf]fYf[rtJRPuu@hh4S_ ?1h0rXu.{ ]prVfv]fAd} ،-vMqe2ERs.#A:ăh[B[fZt0 /B~vu@؇h'r0fRh:Zr/OoɕPPSPd`>[JS +'hrh=2f[qӒ{Ɨ0LKCDDLpWLK&?d#Q{LKۓLKΨII#ɒ8=]LK~Ӫ	
T


 LK&LKl6LKXLK*LK<Kf3<KaDڃŢ%$&8)rELKpf.0πH!u<u<yw_
`gO?f& 2.e.RseRsS@
ذs>r>}d|RstS0vpv&;xV4t0?!u@_A[f{f[0B3@3`;1]tu6ع"Pg]a Vsff3fds
"28̋>.h|fdfdfʉB ΣfӢX:Q͞sw9dBe: 23`9/hF sr drՐdhw/HpeW@ efAtېt_fY`0R_Z
_yp;92"àsfsg]  r
p tu
 /up}@0f`ῦq Rf쨀u ZlSfP
 n{?<0`p(00@EfSS߸ 01D	` &Et`w"D@gE2$D(@As `(3	&tȀ H>r@"߃
'&t
 *L &}u??u8@& r1ɶP&
I$` *` m`m 1DmQp˹'a`  r* $`"oO a`0   $$<@thZM?KuKfz#{$Kus%`.>=sKt&3r	NRr8r,sNKroaD(`)rr X ?a*t)rKk-)/=/1P $a
3fRQS轗[YfZOt'Stɾs
| tZa"0[ X*0e
Q9*: m:>     t|hڿM袅ro ?er`fQqhBB  ff迄r9fffHff#f+ִ qnfgf3gSgc
uBff+f`l.A@(uR ƚ&\22#F,-./01289AHIi? ,?014589JMNOPRR`a 3 0UTU$a,Prro	vT#UGU3ZW[2t*: 0`hB>@ l> l]GA loBlh)]a ]6]$?C0^! G!a@`aA a`aB  @`$0sFed ]ȎBu]  _B`SB  BnnnJF$i%JF/iFjg T mu]_< to̢@pm̺`n̦naoo p@ޢAs  `llB Cuؿ ^lBB@u+ l xU x x x x l>Т?Vftztuv߿2v8$}_@а 
@ |uFFn}wwn xn`xnxnxnj yn`ynznn{0wu]>? ptqt`u@PsE2Av`wnn_!`	 n0 n@WAa0R%> tV1"$఑1& B~萠1
y1$
`{r1d1$Bd1
 Zp` <w'>, u1B$<w	җcBfp	fPS>+ t2 [u, u& Bs<t螣tu胠`)! [`P#tUgitF~g&G Isu0A <u$
ӓ_ A!O	 2f_Y!P#tg&G"谟rBAx#tt3u0I	
᪊З8t"8tS?r~%9	t,&
u茟>ut
$sE Pt> u.r͠}t$	&
ĞsP P
t 𥰽Ý	>2@//@֡ #P, 
+աuotCư м  Τ<n s0$ p`@ %>н`؀
	p>ttUp1 (P u $0 tk>%P"u
 j 菱; "0נts X #V1iQ赠t = ߣpe!!t_(tP rB菝B\s0ou%
`7uA"q}Q"tz0u -طc&tb; sW;"sQ-u	?$u6u"
 袞"
2ؖ-\  ài苟t 蒝v ũQ o*PtXSfWt
t_8؊f_[,.02@8᤻?=!!!RKFZE :7\!Ņm6tCRFSFυ[u$5YٰŨF(#!!x"+` t&tpRu" s  ߡ
桢 ZSQWc,?LA89:  t9R -eѧPffߣfXfffp= $p, QhA<YA0 Tp HA` 
V`fQR  ff
  hUm]@{3U#PK   g0;4T`Qs<SP  2  _F	"	6		&ZfT QRB#U P@ N*tq	'fPRQ% = u0= uJ= ^= u
pc7a@ZY0`  M  5a3f!2a9!t 3A U(\.aPUQ0 @DHOfpV!!U!!,!0!48!S~f#@=W%d  1tr/м*a3SᙊB[C vS3КtWBt:WBtPC + [1t<w>t8 0 aâA"
 
)ñ/мa `9wt3#,/5Q2{B.BxBqp '=p* r#Q20<@.fPP2,&B3ᙔBr0 #
Q2	 fXlt
$脙m' P2עd0$ 7t1,-x-7𗋇B8.frG3R5rt0B37𒍣~%н
%:CƠC ᙞB'>0u3t6BᙨB0aÉGGH3&

}H%&@I&@J&H%؃IJ%ȠK%2ؕG`Cs3y@sÀOPY^O1OOFO-U%V%X% :U%u;Su;StxSP~%DC=~%мAW 1W/ OKY:r:ȈPY&Bۡu͡м 	&\&f&x&&Yww
2F&rYo_&

v e>m!2zd2xe!1gSRfYt2{tE jjj.JhxJS ?mhm2 4 t}Rn ft<Qn Y3 A fn A ruq a	qa
utauih8?m   ؠDCOCh-omayE?zS{@yFO|S{yG_~2nZf!a	  h⍃Ѱ"p
"pORy0ޠ0Π0Zs	7 t& d
%B d^7PRyO0OC h4퀱;$:'14	rw f``&t.&_mf!.t<u$:mCv1,v1wړd	t*Rd
dr#t-d	0U埋bՠ|bá8H,iI-_ -RvYK,rH#-- 'CQ3y)CP@-9-8G4Rrٿ UC'CFr_  S+.MPXc**r**wh<O ؎иfP yc*P+j1WE
0;pЯ33 @f ..++   ^0 }    Y.@0B𷯁yRq0a"񏁸DrqhF&t.fAQff  fRfZYr<fݹ@@r( ‵r r r 01C NĂq˵ԯ,, sԁb֡\Qdas-t"3.;'tB	y)՜rA!
bu!`͡`2QaÜRllJ$JlJlBBJZRW(O/ӿ6=Q_ZR ְ䄀Z6KQVW  _^Y&0&+t	3Ϭ!ϐ20魃aø+ ְsqqpҸ#hxVS  6yD2[^ྊQ :D~ +Y@*dwDCXDPSVk [rd r]rPPXXP<shXR蠶+[<u :<
%r芶r#ߢMP聶^0&ĴroK<>O:ó///`isO}/rdBcc/Qd 7j״r(
PrzDArp1@r$!0+0N00VY\r . 0^f i VWQ>PЯgK Y_^ޡ30.:s@O$ .h.tTvfRVh;t0hh4mh[݆ry ff5 ^fZf`  	n `9tuՀ t2uyƾ
 <PRW/ @F'mrh:mOfaf`0T fRfVfW i3O
PC`
fXf_f
!/@"~" of`w?S% &ǝ&i&?_a .!3 _t12虔C.>1EI߲]v,p !t=>Ye3 *>p6u 61bpw1444.R6_cӉt5Q6迉tɈR6-諉t: hs!=!<t;葇 A4P&m&X貓>&f@]du]Oa<?0S@u@]fhBV C`Xu6/<t+t\@$&蔆h.wpSfW ;t"A	tY2;t;g&G !M!f_ 袆u装PI@ZJ>0&߳t_PQQ  f`8P%},Ⱥ:#%0  t
ف w Ð YMX t
  uP  t  u>J5uPQYXJ5 =Y߃3`THf3ȿ fpf3u濸  hfff#f  
fh#^D0tt7PY hl pͱ`aPa\; (aX* UTQdXSQQRy.Sd#؁UUdVuS]]OffPtY[%0 V tTpT3
  #ddk d!kqgZY eS
`duhV m`nTn`
0qe%uqrI$t AXfSfQf_RWV&"8(#v$re6W p 2:> u6 '{Ht4zo ߊh뒄|3Ҭߋh⒄B^_fZfYf[uv-}>z20~s~~{>42EЅp|,-F.x?or.9 1ް
..ǚ0>6  > u:jS PހA: etY\需A}(u>P?t[s uuouka "s  ut@6=
u48qA9qA: [ȍYd۫Rrs\{`S>B:XB::>C:诟/u(0ћA@ѣ:01o PB@:!:^ quᨒ¦vjPu𧐨hثh^hNŭqŭ_f33ɭFff
\f !ffu?2frupmt $Rfǝ Z'pmtQ0ؿ .c {Wx0!٩ rҹ5V6ӺQy<eWhlrvr6hD,tQW _Yu0iXt
tXu_oGx	 0G Qplĳ
P X<"m(m0ƴ
6 SƸuȗp [ɐ2P0l
Xp
0s
PQ.P2
ˀS$
ؑRÀupĪ
;X褫[X fĠe  贫ݰr
ّ_2m(<KrK`S
 @ LPu a ff@3f   f}pf!_gfr!Y`u2' f@ھMqPh f&>~ftPqݰ0Kf%]1g0M'PfWf@qG4p!X<t<t<!}p<>PS$<w
.n]>MfP A=~QSfhBSfz0qf[ j>@ &>>_
wp+ A~P: 
8s{ ~>z ȰpV$<
v
ط  = tǀ>>@j ($
hs$5
-d tx z^oh7sv

A-d@
# ACu >&> >>>> u
8wL"f.PAл Ph@fAfw@p
A  A 3aє 
rA 茒A Ca0 A?upt
h@.0 N7 \} ;W	YYS;\r.Atq.AtqBZs@""
ZP̿úeAeA;@J1vJúPX$0SrPB_X@ SR໋ذ4pZAQSW s_[  ""V1I!!>>!XC# 	
#%E3E&JDsG>"JDzG>#T#)@Ke)BBBBBBJ@K݀G>}3*퀕G8+3*g)B-߀0h.&5,_ 035 A juW	    i0333122 _fY `11f.KC2~02h 5S#C31]405o2N5\f.`6Y3u10o߀@+  
:;	DCCDDDTDD  #>%>;>ZDT>' EUUEK@UAA@]TQTLBD\PUUBU UUT DDA    T T AF{U|G\DHU a&tHu`
hOrvu0}/r*0JVK>,@,
DJQÀJ@u#O
 @O bQN ZcM`NOPxMiXÙEUEs2.jEKrҐâ1puqzf&_M_P Evu>uhPLyhTLy@ĂthJ\hXm^  
03!4+t
3NO+t3GNO`UN#FsF#F#dN)FJ쪋K0face$dؤdcAee)?F)F莒eimf`fa "m@Ĳu"qt N4Esmpsu%z]٦^bk13mEr~m& 0=u
jEsYg Rq@P&34MX RyGBQ0pyGyG2_ 2mOދUV<22 Pظ$[.ѿ>^]	2 	{]?U Fp҉FԀ߳hc+b31P`&&& qFFF Hy/Sk rߟH t{r<w&ы`q=wr){u#  hϐhv2]$>u
 >5ڦ]nꁺߒVK#:WPp 1貎 1XI@0 s)w0pvPIF X P.I.I.IXP.I.I.IX!J&!J!J xK>8S8rdd} rS<dr
d2ut
xw_ ptt0I^PWPsPh냯`\chdJ pK@2pSt ̶RY R cWXW/P} kRtдõà.?_ ߼?_ ?_˟ ?_ԟ ?_ݟ ?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$%& '()+?,_-./ 0124?5_678 9:;=?>_?@A BCDF?G_HIJ KLMO?P_QRS TUVX?Y_Z[\ ]^_a?b_cde fghj?k_lmn opqs?t_uvw xyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ǟ ?_П ?_ٟ ?_ ?_ ?_ ?_  ?_ 	
?
_ ?_ ?_ !" #$%'?(_)*+ ,-.0?1_234 5679?:_;<= >?@B?C_DEF GHIK?L_MNO PQRT?U_VWX YZ[]?^__`a bcdf?g_hij klmo?p_qrs tuvx?y_z{| }~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ß ?_̟ ?_՟ ?_ޟ ?_ ?_ ?_ ? _ ?	_
 
?_ ?_  !#?$_%&' ()*,?-_./0 1235?6_789 :;<>??_@AB CDEG?H_IJK LMNP?Q_RST UVWY?Z_[\] ^_`b?c_def ghik?l_mno pqrt?u_vwx yz{}?~_ ߃?_ ߌ?_ ߕ?_ ߞ?_ ߧ?_ ߰?_ ߹?_ ?_ȟ ?_џ ?_ڟ ?_ ?_ ?_?_!$SMM MODULE -- COMPAQVERSION: 1.0 t/ƀ> uSEuuu&g !W sD[ðD8$ htv r
8 	t .C
yd<v A
R; ,"3,YKy)Em6\ĀυbK¼)E3F#k  	{{<  2PKd; 7@7d/ VQ6yDY^PV{;ty^Xf`ffh)	t$hp$r> .<t
../W!N!!NfafPSRV A1fpr  >>?؀tU.$p!`%/tA&%
 &N'N>hڼ	^Z[fX8Bg7BBrPz?4XPSWRhc+	 >7[ u&E *Ou&} ua.Ca.he	tb.,Z_[X`v-[h	$&]r
 %[hC3^%3 %^5laðÀ>7 uC?Ǩ t$<w:9h%	R>t"1:t1:t`1: u 
ZSfQRUW3:&:;;d <S_ZfY[7 tsosȖjgPP=W6_@XCW?F? DJ??9?ø  PRBZ0DQFB G3Å0u$H` um    2>  %Jt0 	 	aL
  3  ti  MV ".  f@@u.2h,	)P Qt
RR=0@TU&SS$@PH@F.0N!(7NNOIO""GiXHRY.$,!HW$[XOYcZZ!HfP3f&T? ff"2,YSv-#1P	 .x.tI1_a.S.>=sR2 hP	v r?vf r,wrgr rtB=u
pa.Hu1[,k te6I,@ ۋ^SF ^ShV޲	[^n   }07PQRp쨀thGCft
/ZY)E؎ffj} p d 舳f3 Uff,_.v8vv7x"U Q\hx	fr  ff.4 uffffO~?_ ߇?_ ߐ?_ ߙ?_K`20ؾ r-*   Ȏ؍6{ć ar6ۢ {`1Q
 }#` fh}9f`PX8  G O @O  COt% r  PBp"I#AO(A*A:A4A3Qvv
6 !U)}f@F0qw{ , .
Z)`p 聰!{0u1o2i c ]oY  y˸q%в G`P @   Nu-aÿa$1x$
a1xﰶCPBÿxCҿB;ra7
	
 葓WX"U/3ۓ	\u  |`vŲ#Ã CZ#U1}fayC 8P8*h >! u	t&O %Ls;t D2䰃C%?h,%0Ë߃3@?é t/Y hl鿲	a  4@D6sL
 <50J <aE$<r' @grgUkyI	$o
w fQ T hRb.
h2f   ޿B  hN$H hݫ	fYoPUb Gf`hjS ?h"oVUhD	D
  t{| uu| up Qf]FFdAF 
F쨈uq2 ځP[<u UF ů]#ꀑY`qIu]^Ar`~ pm)!a[ ah"Qy  uɀ f   2f3f% `{
 0f  tfI A {fp 0p!P! f۠
 0XX!"f` `fgff%   gffPW `m  o aPNX  DA ; Z x     0NmQ
5	,<Pw2 +1DfWfV20	 f6f6f;f^f 2fSQfRWf3ہ> w;Pp>r謹 2G%GGfпfQlf _fZYf[SQRVWP謊Ȭ33c %	\*//hRmZ>U 2.{
)@7 22#+= v p_^Z@$
WոcP븪0	贸_ !! +t$t"u#"c$!EZt>*[$,Q&+G&E=ށ&>"to:!s&qÊ&&r! * (r|*`'r
&2'QE *a*ðGwnw販rp-FϷs *-p*˷D躷$&J 6:?ГJ2؀w3SVa.4 1t^Xs42^QXzÃ&'&D&(8,w&d dtKs	2syDï!> pD Atٸ n$;!q=8;007D4 ðd. @QP0x
0P0sv01\1YPƀu	t2- XA0;tCyC ? 赶&Q>ͪ1J"B"RQ>JOCð3+
  ANMյ&`BO	 HOHȃI蝵ذJ2ȉ  uqTwpTg
T@u]<tuQ0uIOP0WVܐiW@tWtX0WZP
r= tS tD3ۊ:t
u
> u'| jߵؑ^iwư(
$ [f^B$tO	af`Âҕy0`f e w}	GС&_:fSgWA03ߊ *È謌%;%= O hγp$t
_k߳php. 2jhCfh˃rwdphqw hB*h4lh+[l7s0s'MufZrh:Muu1vf>QPH_u(lr#  f&fe}nP}bqbci{-+rU(|}1}`e`ArO~PfRfV rк s]fC@
Rh fAtUހ uJqt ;qw<f6sfк6 r-fgbgB
grffK!`Z6`fW ˰1u
   f> 3ێ f  ? t\ǀ t
t@ f f? 9T  sfҕpqf[ƎA ǇH; 06fPкSrm SgGw`g fgfVfкЯr7g0>0ff;w
 gf^/u
fFкͼQQf$ftgf&Qg&fY ,P\0 x  $<@`dh <L <@DPp  DLTX\p @, ,    ,0@h
,<H!cc <`hlpP@< p
  $(<!	 ? ,@DHTo Ϻ/Oo /Oo ʯ/Oo ӯ/Ooܯx?z&<PXYhijklmno0	

 B ?_?_i" # $	` a_>0 b@_pr@ h0h%9%菦e`)KðNNOOhZmû  贚ɚ誛0 0跚@ 6<f.fff貚|葚   ;  9耚[`{l?P횡Sf sVW f ؁

!!!
!q
!!f%@Ϟpf.2fff7u_	f":f 
@

@f0?	fftfYЖfa0/OcfhP3XPSVWfQs:!4ؾ7[ي t
؀u ufߺ>fpv Uf  fY_^[XÁO!e!RP.  XZ!!BP ^a"%p_^X;=!#WSQqasHB!    hڼvu!Y[_`$**v	UCRffypeeˊ`2<w.
nbbuFx Et@$_0@5蝧$`M12OQg A?A?K	&C00裡@ `4 t/ tW wptu!:tj$
 s tQ>3t;~  s`E]=<n]B9 A:%!?t;"; !=

w@	5/ O``9uk\ߔCD[>D;>t,Eu-  ^$_qKKu{bQ3[P`8 Ea7v9 g >pHuT> Hu%  "RJuLL@JtEsH"1H@&:NOܥRH1P厀P	QH QXSEM
g@_SEu%^p
u!*'
0tB 4CA
5PS550m1< =03Z$Z0w$[vv\$ =X[7t9<r ?$x@@:` ?abX5S<:q>
u :uF0e㋇>Ft'4`utuR~IG@]G`5c7Kuh
 iiD[<7Itu8C$a
297
Bn]z7wmnF8e!C^:;u
^P;YP\P;O ?uώ=P\ xv3<u1!\@
`ArCC;r5j
Ġ[y sS< 7678<8C}usa{ȡbsTwd\u&&5R$ZT78pp3Z5zeBX[+ST4Q4`$pb31H@e7~{q 2Ρ2Ρ[BE u)P _&7G԰B/	B0[Àu!  W= PVpu /
C01H1HLFǳFB> t+&i&_}
C06 r)}P}?}$S<;w?<w2Ѡ)<w< t`<wP>r[3u3W
o$ Ku.qlu ,ɫ"9Hbլvݭnf`f.-.-."..6 .B0v
i.f.r.3far!3r PX0
eu`Pf hGC 3 jXb0u쨀t
<u <u õRr$r .0..ߦ`2䱺rcr"r~=1{g`XA1m>~` ;"" QY;3]t]agȩ r&.w0OP#yU ' r F.o&Я"R0`ZQRrHt2ZY`"ٵ[t"5Ӏ0Pǀ8TZYa~r#eEY`ձٸ 30 f3& &EZp2 Q&&,r豂#r8t2`.&EOg hC  :SC hC [&M.2t$+#h z 5W h÷RhR 2h4S ?zqhph[\fZrh  vw@35 &E
},#		2a0hR %00` 0% σP  Da`6(  o N` aV魆ī^pW  3 _r-˸ fDfDՀ tB.pB`O`B{ː
r@rPVqW2&*G_YS }0&*u&}Zu_&E_ `81?q rj re2ۃ<O`m	B<tP`܎@`Qr;яrg r 3hSs0SQ
pt$<PtKu sBPY[Qb @׸@uu/2YoA`<V o^pWrm QfRtth;rt0/O젝r:|Ut3_V ^tVhL?rf_^D f $%'?(_)*+ ,-.0?1_234 5679?:_;<= >?@B?C_DEF GHIK?L_MNOPQ` $`<`u*0 ].} _1BTq ^Th `a2S u B]J. _@WCX^aXn `OpSRW@B $ZfQWP hµ3 Xgg?_f@ Tx]f!^gpU`2aafQRfWPSf3f3ɿbf0e 0dP tdfdd c`d1d?f"e[Seef; X tdDtWa[Xf_ZfYù@ fPffffX,fV3ɎkwfVf   gf^!nWf^RcVc dOddeec fgvh:i2jaj^kk[felW mJmOfWf n_z}ng&'p{f @ |f_fPSQWV_  a`~Ԥ~tTDyPSB"ASC$~Q 譂DCY#~Y臂^_oY[fX}>u5$~PeUA^VvI?ӅcQW_ )D f+![; FJa_Xf`f2af ?
 f   ́ ^g& tq ug&rِّr!ِaّ`3adfߝfa$	


 @`}3 at|  d fh0Ӆ.** End SetActiveDisplays: \ }R$Kt5< x )ڊ8t u
8u`fQZqPQS[00t@uYX2tW¹@P  迡@ 0 <uȸ
 ?u@0Q 	
3~a0Dg PqSqL@
  XqPߌk lЬe	Xl9 SRzP荅P$Ь}ċ؀ |XqtXZk\PZ@S&RMĺE@+ZR'" tѸPPÀ@¹X섃QRPS [X"3t=R0Ô`
"\u hЬ@`óV
u,r2,RWA_Zr "&& &E"&]`[P  7'0cP@R???R}bSfWU]|p{SSW_ð PRcZ .t rH r@t]*}f)}ftd` }apfYf @f&f܂z>+r	}  C f_ Q`Vt' tf  f ITAfgfؾP 
 2gaYd 
Й?`tXOeWݿH &=&M_0g.g͵ f? t0;r+gCC !vRPFȸ;Ruuo\t Ѧ0 f0"6A&`Ȏ؎-t  (w >ཨQVtkOT#<ϳ O? -jԋfa~ />pt)P	tp Yu3PuQE<
uQ&hc+u
3(uCu!)rpu?.)r3N А*yf kA|Ц 3%H%߀Q͹๽ Yaం9 PQ> uι rred`YrstCGr-t`w 0 rпҊA r
6u`d qPrdItf s`Qpc3f0aNr&r!ww3҆r r	!_PR...r. .. ..Zq~^{Y jb![`"Sr	rs"5r#P dtgf'u'v>? N?fFeT6<԰2԰A Q ="A 2  `, 蠵Q) hG>>?@uPSV-x 1޾> f<$F10tuP"X4} `-Y^qſذ* _rA`O 19װp1QQUȰW>Đ*p;Ð*Տp;ǐ*p;;?qnQ<a3;>Q;><a3P>t
<?!2ASa@ t33`|P@25?
tC * tt È󂒟QRWVĹ+3> ? ^_ZQ(HCI3IG<u
t J{JV}^WM_MxNNNH1*a3<tĹ IJQLJ!' ?L
g"2ϚA(P/rR0PWb 
 A!uD!JQQV tU..F \/F߰.^ 蕐2@u!   !^RVа7rN `NrC2r<7r32'tиrr;wbҀ@sڋƿ^ZW
0  е0u
˾  uN߂ f1o uif`2j J3322itдj `kernQn
$	"
u ^Ƌ߱d;sRZo3QmFnF2 @2t!u	u˸
S_ø
_..W...Q.6rC y#!r7>%Py 	3||-	UCESu
 wտf0ÿfRVf0 hrfn`ff^fZUf ^va@5} pDv،~ 0QP1vfXˀhu t ` rW O tC@ t> tߩ t.tS
 S@  [r~!fn 0Й_@q#ؾ   t
ff;t7]`
 'Cu!Vh2h4S_ ?hr|fȸ ߾	 ub!b
fffLp`C7h'mWh:^f3ҹ  & thY2fG[f`4'5u@ u 
Nfa#ff f"  @]frffa˰hB3 ff>uA =gP_Oxf   rzf둪;w~?S/ECUt$Ã5K a %Ubcffaw	f"3,.& Wf f_r2Ʋep$g&$fg&	RW2"1dg&fGt
t`9Q, f    ur%~ rQ fY	7f !$"`xu!t`2` r  < t6P1g&_:u"FJaf۾5f  t80ȁ w/ƀh_sSfUpf0$t	 _--dȾQ
f+`f1f]^o zgXv? u n ^^ ufǁ $ ?~ǀg?r 
dp"a0	rQ< u
 <x <_2<0
 h G?_ ?_ ?_  ?_	
 
?_ ?_ !?"_#$%&'PRPRVFZXRR3=)Z'?, _-./0124?5 _6789:;=?> _?@ABCDF?G_HIJȎ؎0UЍߋh3L@K3MfPRPS0ff%|h f
 Ⱥ4aNpuOt\f  t(`O,#%9=`qQ`ot1 `NȐ=pR tR.fu  Vf[fYZfX1ׁWW1e{֑PX'W1SW   $e u  Z Z	Rf_[p]JKd  <Zu5Pc?FhrXh/[<P_hg@Pco hDUlfas r "s@c䷁ pt	诇f_e0Oe-]ú:t?t^f^úA $t"t
D% t
H"t2ߊ0tCúd uO@tO`\sf Z^ @s+f` p%z &U{PSQktC tԀ&.1tu'Կu!vkv1tt t
!uu
uS% [1tt!qy!u	uYasRuW
Ckl
~Zps13 XÁu>$еxuBy`)
yxB|qxB|sR+sA:s
!x!tt	t}
Z`sRPSQ*0nXZJMCN.1R.غغ.ޱغ@ۺ8AWPfSR.́؁ .p,fpPN?fZfss
gOЋ % 0R`o8SN#0OҔ RSo؁Љ`s3WV#t7  hًfȿ ffq33u^Є3һX3t@spaQ @N`hkRЋ
 Mn𣐕% o`W T y`f   s`_thث$_Ћl%}~@xa
T2沬@NqfZ[r'CC_i_ jCbKB=)wߙ Ӎ:33	H?8ޅFW_L`C 	CH4qB>Ѵ[PXڹڴ (7h<OKPKи`Ԡ( ڹ	ې0(#hx3(rc۹	۹cPy(n%
'o&g`} { `o`]ܠ0`Ҡ3g3 @fӹ..gkmEga`W@CàVe`{Y):&3hF& @T gPSSO AO[XfRo#_uA xϿ%PS+ϝ Z Qf  Sf&Yfd% ⛹ yP~%uy e%r} ]%ru U%rm M%rer]Ow%uJrľ0@QĹ  #r'%r$r4$$蝥L M hR$u؝`,luPjaQd BB0YÜR䰀nBnBB2JJnB$nnZRV!(@/6v^ZáQVW R_^Y`%kG2䬊FlGaà桠
!  $s-WdW3.;'ti#~rA>d&0&+t3?ЊA20ua&Kø}P4$ûHs;OP3;t<u:!*!#1誣.`  ǯơV89A:A7^ÁPtX#ðqj?q$@sPQJ`a@7[ aöؾ6AA=0  hNC1EfPfܝpܠVcEfXfX=ø
m~jؠVРV.&{2_f>PAMSf>po>,Pf&Ef&E 	 Qm/D^q" fRgf+M h}#  @A3ɡM>( hB#bqԩq"9# c` ,}#^<$%a_&+f
BoPh4LbrYƿ E6fP < u h'Lbh:-2r f,mb4f2-h[-2Ypsh;Rt..b.6r@ ʠ@0E<u 11/f0;4y4X547`@`iLfAft; ?N"a`AB]"cKBQMr&=t&} tV" &GF^CYՃ";\ @TaþY  hlRҨu0. Pu&t7JKK C`!NþX  hTMGOOhPbO(QUhOR(Q(T O&M& eP~̀>?psQOO 1KKQOObsQOj\R t@R퀭>	u(	rtd黰(1`u!>asb 	1`ud8	1`uu=  Ű` >~ta蠝Qoka	 5d}$Cc$?< u*R	   -W<u
%7uggw4_Tr7sq7rvFrx#shUk؜k0裘&XÀqVg W 2	hmFqy`t|{9s|z`t|`B~y[}7 z[7ðsLb#AbUhڼRy{Emۚ" 0 øoE"$(,04>JXj~ .uPP@R8 u
 ATXuYé  ܲ0^,^*3Ф1	`ѿ QQaØP ё~Q333sQ#aQ33 pQfX"a $t3ߜ? _ߥ? _߮? _߷? _? _Ɵǿ? _ϟп?x_؟  @K@
pݿq$d ܟ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_( )*+,-/?0_1 234568?9_: ;<=>?A?B_C DEFGHJ?K_LM   p   
5xMQRT?U_V WXYZ[]?^__ `abcdf?g_h ijklmo?p_q rstuvx?y_z {|}~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ ßĿ?_ ̟Ϳ?_ ՟ֿ?_ ޟ߿?_ ?_ ?_   &  }    PS#  - t	.H    [Xu
.'
uu  `fSfQfWfVt, uS l  Jf[t݋3ff^f_fYf[f` a ffa   SQW؋2__Y[ò					%
ðc	
Pp[^B
`r		a2`SUf`fNr	
	fa fSfظp	fӝs(3Ҡ` ؋60 zea4
`e eue۪e	e8aP (33Ƀ t	APuxe&>R(eaB
f7  ta  ?u _r    !S`	
hzW_+[% &E&_"
!x$fRQS	2[YfZfQRWP
u0B1^5d !, 8uf3W+0|A1X_ZfY6 s1r `ABCDEx} ~@fPRVWf	 fFf^fNfViЎ.< t ~.FuN._^fZf[fX@	1r
@
 "@
VfPhPf0  f.e ..enfX^=Fn>?'@v
 Akv1 .;nt t+0t .PG AKftv}	Hnf  4 t j u3  3GEA3GSHt<  [SN> [[ÿ t$v~ Oio !PSQ3۹)Y[Xf
	.`As.QI..Df.|VfVfWQS3Xt| uRY\t[Y`^ f`03a~;B tS
tw*
t& o	PO볆o##`G z tfeff7~
^轶 `a[]
 UPSfVW2{ Gt {f \ t]fAh6nP[AQJ rg>Ut2gFYPAXs\Pf3Xsȿf	P^[X]SfWfP`Kf f;r[r}WitlmAюo]_pmn WAp$_p&5 rsgNZ	g/Prs <@\ZSW7gfFfgf;PCIRu-g{ u	gf;K\gCufQgK1`	ffYfX_UND^A^Ns" Pp  Gp  fn
y@ pGRj@<7PiNV vyN"Q3ABY;3A+X_^Z0Q 0  t8Y=QhB
Qf?a?p}?pfY@~p
6u`fWSQ[a^fWV߃3!Z !P11/Pi0] fP.t "  ؎fPWPb`f%: t 2rhVF
uNF3p	F 8ȋ^V`uf
Fr;Vwr;FvN3Җ^ƀj rh?r3Eȡf7+FV
+FV؃ "𦡣"  m '80y
+G
vm> u怲A*eF81	j jFPFPN' @Gj FPB8V
q	q	~ uazpm  c_{ߘ	BhBб  WVߋF= % k:؋>@@@Ftlf&@8FtF% { +ұt1Ht	HtHHt&-9Vu~r"f~  r~r	FwsVFsF^_
  dNf*΀ ȉVfF ѻ
Ɂ3Ft	( I _F81ӫ`!1!0ӺPU؀՘f0Ӌа< ְ~k%hq~$wP!ӋV`fF~ 7	V@V^ze(FFݘN*;~^u@ޙ
)ȰRPWVa߮uFfHuf@FVc;tL+=t"ޙFVF֐ΐ}VfnJāW
a3S;Vwr;FwS)FVFVFًFV
 @e!	>fG`G3VQF |Πj*΀#@@fN+TRP^#p9Fs$FVp`0iDf0פ*QQ^@Rv@ъa0Z~ t	\Ë!An0r:W~ptA#f+f t_ӡAP  tc`;vf9GrLC+sC AGvfGf+`Bfvv? AF@s0 {~!F f;OFv8`SVӕ 
f;Dv3י`΋VWV3vF k AsPS@5FcFRPDujP0뀼ze uvdNFFA,ƉV=(ut'*$<u؋ƺ`DRPA,뼀~ [uRk+e+ұ8! ^*䊇*a 	7>uS;7F96xew٨PS¡	u~+9D
r
w9|vd'vvDҋ^0vB
@ *H+;WrwQ
3*O;w ߳ܕd~15NFaΠF3cEm8$<uՓ32!FߋV3SVe21Fv8H w t2Nf% ]8Fl~Gf@f6VA< A@PFVR846'(T
d89Dv0 5Ԅ8JV@Bw DC@FFs52/?0S1a246A c tӊF!t0$"DPNs546PN!4Ҫ6qA78rTT#:a:0f; `JlfYO<h=!3>>APP3PhZr3 j
Z^  3ZPV+k:ߊF%- ұ݀PƐ@@x^_``&`a(aFt!F5 P%az1 ъ%t
 gB1T1Tr -FvB	F t'5  f^0p"tA^%5~$sqr% g		^+F`̸(3oP#WVS*! 
 A^E\;u;UQ>)u	pf+^uVӓut F0^(p=bp _CN݉Q`A3n F(/k:@2fut @u% 0; |V@3D D:B | 0  0ꢲe	 6b^|ΠF0Fm1VM0źF$<w`"@5k:@@G  **uGW *␀= gqGr"t
< RE	E	 b2s" E*= t0&jP#Eupf$ + 2E~z 飘yq> ւ%>WVQ~@ ~ ߍD@5M?
f+o@0׉VZ➿@hN밼$@fp^ akN:ى@Ɖs"`lP@K&0(@ѡ<Wu%DFB ȇ*@PPo氩9v^~wko:> &@ $~= @sڿ0 ŊTҘ
E8%Vk :@ 0p
k:9@tC90B^_A3~6 "@tu$ NtF3!ǁ%^t7B1uϊ5$~!b:  ~߿96't`}b%@O0';t|>'pt@ՋZ2%S!}~fы^9Fp 	Fza
avvo^42M  ˢjp F򢧑ft@r
PvD26E
2t
9Q!;WZw;R-fڠ]Wp`
 *1h 9j $٥٬5ڠVQzْuQUЋ^bt.>&u`l u~W^DFDP1 `\]#A Py°WDP164-랪^\uq!?FgG  P
K`o~:vR! v :}tyhQDbP5mbE9v7yGDPgJwtobPǣP0HzRVF@?f*1k2Aw8h3گ 5tay}6
 t;|a6 PpvPFPaĠ^eDPpc
t2gUU  UUv6\ } uAEht"aP}+*FN*+@tRZQ>xet-T}	?kxe!@v鉅+e(exeVPSVu@83>;r;8| ^[Xpfam`Z&k``!muN#. pgPb$@*'Ft>v9v7v3p~&p} @ `PqCA% Ak^u3҃ r PA3wk*䊁u luRv3;Ft7;t- t#i S+`,u
uGrvFr`2By cIplЀSRNN `0mFtv`Rmp{Ny`zy3ҋ|3fs5Qzawh1pj"$`y^ @8@ӿ` W$pP?'0Q1ǈ%@}, .fJFBBBB`#` ܈F-F҈FvԿFKL QLo QuS32<V Mpw#Md PbP*$@V tPtR``BzPSv 8Vsy+ ;Viw;F`LE9VF1V =PCC$DDV/EVF$QGډVPCIޡDV?KVF?M9VF0<8Fnqƺ  ۋ^^"  V  V& |2\ƺ( }5X, xBtfN F  fBtF0ZsZZ1[YqJs܀σ8F v]r9YR^+8@fҍ8@]V鋕F+o@`ڋF֋Vob Y0 Bt,f{%  FRʯ
`a'3b,  e> kQiP`m#X7R  N4 C     U NAIBML 761295520C??r   2005/06/10 14:16A "BDR(7PNC
RUBY1.0 M10P/GL 64/128MB 212m/203m/344e
 (C) 1988-3, ATI Technologies Inc. BK-
VER008.01@02 
3  pa3.479 v611  P`AGP DGD1UpOEM VR 
@55 h h ?#\)  A Ae  yFD0$TVSP50t  r   {
EPCIRC}A  
MOBILITY RADEON 9600    uAi@ @ D  H  
t|!@@  R` @A!!@0 3Q0`t OD@   P`eX |1! Yr%&%hA#q @'= xBP&Ϳp *h*h*a*+b* fb*`*b*Ub*!b*I  b*P(1&b*/b*m۶z0%#1""sMt[
u ` 8{At
 P!"7q a 1!"b*OU  L  'Hp q Tq //D)1)(c%2 21	AZ @AdM`>A Q>
>s Hd@!5AAD< p 4`/? Aw M0LL 0aEP&01 
0'A1Ha:
 (50   &-AE 
3$@l%7 0 ?!N  PO  POPpO`PP LPQP0
 (H < B -07U207STBrOBO SmA -  p   "uu- 7_0 #  ! op   2 2  {PZ21[Z2    A\ Q%BA@]]]!QB;_B*Aaaa&Ra1ck]^^]`   )a*2b*b*&*c(H?,H?acm$

3` #)pP@@4W@ߌ
  pP  rd@pE\7Q3AB%`t)8 u g   uruuwg
`D d6whw s!yt  r {zf`.>6 u..6.8	 u~ .:.9`u.:Ȳ.6fa.v4.>au.v.&!v.vм#x.vf`f1INIub0s.u2E h rE ST[)$
 t.VW _^FoIRE T2ZLc0⃆PU$UUT+$X)5oATH	fa4t.Q24P mX ` sefoWP2X _W PXuC &GOfGGOOf& G`OOR? Z"О+ 3@ßP2?FXR1FXfPSff L f
y$ f$f Vs^mqns*X=Zu7Vr^4 
 薨m3
K脎j$߰*CPCXD~R ?uar=2et ԭt}e0įueÍ1[mÂ& $B(B,BG>@}] up~]첺2 tPf@ f| 
1~ 5>#@ 1B@@.]ȣ###VҺ <v  ` 32Ŀ&! .@2ؽd^Ð	ANhV0*814 Ld
F& uqpF
 ۨay8$ 
.ă>!۾E F
u61c艧dtt[axw"twb2>S(N)N=:d2<u V0aϻ    Ϭ }t
u]<ϒϋ tu	<to tjf;Qs YaF;$<t*<t0<
t'<t<t)<t<
	t<t(<t<t (83
mh(c"I/ ?F f;  [# ~ tF: F0fF2Ag wtÈn<uj`0t }t ≿^"N @39X8u P $X"8t+N ;N"rҋNN"F;t
~<uF1a`0s2~tRSf_Nfy 栤&f݋r  syQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ 
F X[ÊFf@F$FFt@F&F(0( tR.&! 6Z.[PR.]t2M ZXÿ`t2@ Fwv@y=	;5vv} tU;5t Et:]r9Urmt5f3kvf3ۋ^$f3gf1C߃s
}8sn~=}:n=a	  1'(t 	

 S?B	D&|cOQ]07
	 quOV['oOQN-Ru0jjbcgvWX 91ce
pV0WQ߁cj| !Wh=s 9pF_ cf	SjUb'  S|"1#2b"Q}%# La"h'd"r2#w 7
 |ן/?  =+1ҟ)D-,Qҟ/ 81+ҟ*D-0*+*ǟw
@-	
+rӟ,B-
*&Ү2,3
m7
 /A13 Гs|}oY]Mahip>  q=?J ?A_v|
u<2ū jEEUEEEEEv 30HÀu#ڋHjIIIH` Hu	 2ô~LU WF
 ҋ[ ]ÿKHbu0Oj@PPU@PP@PPz@PP$  H\uTt@ @
,^P@PW Xj  U    @x0SQRVWhf<t< tux.D.< uhdG$?
t\2Ҋ`tʊ»22..;w
]( 6 @..Tt`& _^ZY[!&G@Bu
5ee`e$@
`eyeSZPUφ G<uTG<u1GHA_,Pt G2#gjuAjG%eKru/BJm3pg poe!mcwmPjGe[aS FrwsXːst.6v
vxtSwuG2@ u.,QxtW	|a||#|~n
 xnAYPVQـ.(kYF	 
 pfFn FnF  .!$FDV.g60j?>npf l!f/ 2nF:QFNF yFy"W  @_ 豛Q6Y_S^[SW!XP u2 ) KX_[(@W{X@W[_tF$F&n
u9C+$
``jWWZW&1 蝲찉f3q v K^0o mkNAᑝ`ԐtDj} H x y)^Z!+XCPDu@f0mu  w V^o
]u`
"V"tMvV@JpIt<uN(߃u#A7 V faQMw t>SpDLBU[pEY$ ĀPt
u2B[XS\D|SUD  A")tq=Ut!'Ut &Ui0t
 ctҐ-J
t=SuT@A %?P%@
Ā?
X( 	 c-'(+ < 1 dBBp"/OoP0@@c_OPU*(/OoTǩ@w "  ˰"0/Oi!@W T( / kD9n `M>](
kc0c 

 ߄  @@bc O
"B89:;<=>?Zӄ+AՊGcG_Bo߇d0`"ozcfKk*2 f@q>E2 ?ZP0 {
> @B׌( F	

`PD" 	j7eB#ՁW?Z %( (,%*26', 49$,0	
!&.3+0$8=-2 $8?#%!ŀqTc0
"
I`ZbHlZ(0bW</	O
o @qɲ
/OHoPۀgW¿RgWʿfC(oۇ% ?k'X@%?_z@pեAg@Ae@KQO{/Bw.r13tup3=Ou{c&v1.vwP=: sX.#XBò$%yMՠime<6֩9f*汋#g: EoFEB#; ;4u&P$@l$VqM<~.;u*6O<t8Dt	\S
OX:PL
uX.체0&G	t TG	?_
u&.+X&c 
-eFHX CQ?`?PW.E#"0_w^uu
g2aX&IgUDp[UD 3P]U `e
F CE?]Y[	1E`FXP_w(Xv 覉>S'[( {3w+wu k9$9Hu m8u`O}H'LYt999999_D]P[U XM-  販utjG rGU蔭]Q S[[S݋HQ026'C[2S  &'`[ ĸ #2Eutbt&FS޹ 2f&Cfarvt	 ߤF_7	 2b`n Ȋ3S0!y.&[t 0v 0E7t orPGXuSصR[R	$
[Êgq% oŀt4$
@t#u t$O
}P X3<JQeu u<~$<t <t<t@؁ð@dzzaz`1uxzÁ@ÿ'$(3  @
@@ b !"# 3@xtb
%pv`axSIm}(e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;uPlpuK>L tDI @.>
]0E3ud"]<~]&g7r)0u3 3Ь2PQ33 YX2PR94$@tZXÐ$ѐ"R< 3Zp8 3傔o ё3S31ޱQR$WCrCTC f3fRoZ쐐ZX8tЙZYX4ouT׀ w2u ?83$
t	u$ O0t P蘈DX0D0u
u$0<0u &o6<uAr	Qդt	
t 
߈~)<u+v봀1u 0q[3u< q㑄܀4u< uQ?0GV6u& <t	 ްw뤜bB"
( DEx%^N2  Se0PhB򳰌P ?Ȁ>cuA,@ 3Ü'.B.EѽJbXB]R+xt8 Iy<8t<?tA .B   Ѿy%/+0QĿJ  Ki YpŹ 3Y yQ
 YcѼ.,BɭBɍ,7 *3?0&̜q Gp	 GѾޝ;~~|ֺ| |8@8|48 lP <~<0} ff@Ӏә6xx~~~p`>>66f<ff<  >1f f {; <f8ll8]x;u~# }0pp0;;$ff$8|||A;<< wlll;lll ~|0` 8l8vvR 0``0  `  դ;88 !|?| xp fp<| <l A|oP 碐|~A s !0@qݱA Aހ~p ff|ff٠f< l l  b`|``qޚP"  #<p ؿ `bPq|rְ4A|A~Z#SlP0`l88  <  | P||4p ;0;x|~ ` qP0 P `60[00qv | P82px`flxl# l!;P| | | 06ጲ
vP	 0d 01$ \1
0 v;l@``0 -|#   88# 	l8|PAAf|# A p l~n ~pr$R#2cB~ l`fl f@>c8c>  >a<` rQ
`
 > >`gc=p"#0`P ``  0|6>%l<~1  6ll6;&l  "m'U(w(t))6*0**%**U,4,݁**;)U/A/0A1*7R,70?;?%0C311T3A31A04A5!0C666 402T,32;23T,8!20.A1(=2 =>>E=  fx_̠bqڀ`@~|u ܰ8  l8Al"8fb~| 8` `G~ PH H )xAHPӀ38tߔ<8 'p0.|Ng@A1Ё> Cl#ѵElҤTҳҗA=E=Aԅ= C=PCZC0J`BA>6>vf~!~ۥD>~~>ߢ2b?cCd{DN`||K 4AzbF])Fc@s_C EEOVfN@UPW"S*p @Aex16Lbf0v~4
j0p x"HVs8C)q 'wjwImKe K2eAea 2j pڠ FK@xveK~7 w㊋w}Hme2E v \
 #+ff`d|d`` 芕ΖK "1U A0x(ђXPxwp77Y  @fxc`VA u`e$yKj1IkB!A@dABveG6	C 1K ֲd@!F cв f)S "UdN !
 dg2 k	CTwF 
 G{zF B 
!
A
isC Pgu\!@bVx0x`@	@	PuP 
`@

	 YEaĲH@6fd 
	7 		҃)՟K (t!ci`c]r^cc0ct݆	H 	6AU!6ОT! 3`"3O B7< ; >UPx`jf ~ Q 0l6=>6n6 K!&&X w&u'qD (((
E/ e)&T,F,f:
+, 
f
-vr.i. u+/iE0=e j\&T,C4U,3 u%4U,4C5& 7:
6R,+7 &U0
&U2j 
&#--&=	= vX=
>>y,U\`@@f|"Adtb00 U0Uc|FBUi 5rإxDD^``<f12PgEE| @7t00d֟ G@{dRFBBynfXRJ KJwK1g~XL^*x8SZ(4+~Oop5t?W2@ _&&MSWI &FG_&E"&E#Wzm_&]%&}&I2.2
t@T'VPT)TT = ~=^~=~=~ &U*&$
$

S0B$
PT-PT1S2;t4&wt______Z2RԊ%T+FWt=feBe ݸ  t`@gt:t@h?F`e܋ Qgg?huq&Pii>Rg	fk`kkakjڊ]JR 2n p &GFq%G rnqGÜQW+&9R&D&TAtwt	tt p&RWt_%&TAP
 XF2 CwD%Zy
xztz# z	 
qzw` xz_Z_Y`stGQW$Q$0R󿤾 ҁt3|3с~:A&?Q$y`c 0wGz	ĸ wx 2zWRUFzySZ~z2fPq	2PQY#QAPq&GR2bY^H\P\4]SY쨿 t'tEPJJa B2BBXJ?w㓱wUi$訴/~}VBB`w3q^ʃz7$]ހ:+ (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0433258:=<:98899:741	
	


	

			0



 "Pu
*P **?Я??"0p 1   $$$(((---222888? ? ?/ /? ? (a?'?/?7??17?/?'/--?1-?6-?:-??:??-6?-1(a>   1  p/(ǯa61pʨ/       (Яa
1
Ө/

(ٯaٟOsP$
ĲXNN_  Qq>I~&G3uP	u&IútԀZcNb  P3&2J&GaTGLAģ`0c Bòa :2{mobmÂ
  !"#$@ABCDrstuvk(
K1[1{1 ;1l(Lߔ\|<n2N^~>m@M} ] ߵ} = `P@qPqpq0q aPAAQ}AqA߆1AbPB	R	r	!/	cj)dCSs}"?dU/DTt#4f?FVv$6@h@AHQBXQCxQD8QrgJsG}!tW!uw!vw7!eVESA    OҭQ  ATI Technologies Inc. P10  01.00  @ @   V  p7 ?OVBE/FP խ.6x#v<r2.\WVSQR  f&=!2u " W_WȎ؋ʾQ]T@R@R" uzs &uT&E_W*T +@+m+T +@+X+T + @+C_ǃ"*T +T uZY[^_O ËRQSVWU?WQ30&Y_u6WV6Q2 ^_W
.]EE
tE M]2].l.DEEӀ~ZӰEE!0;#0; 
E"0;$ ~7@;;<~$: ;@;p>#p> <"%~: EeUe WBtS23[ AN
tȈE}~=
 P &2E*؋EME,].

"+/E01XQC0h
 f3O]_^[YZP2%RQUSˊ$2w
 K< @t| dQLEY
 b 
-ŀuZdP9T2ʋD<u<t<u<uA62PQ23@3 3X23 M XPCoDI`Dk2zBD 5tu,\.
-}X n2O[]YZ1ø WVP$6ߐOش!Kt8\t 1	2^ƀ t 3"^@^OP2 0_!\\	{9#]3\" MWV>pF^&Vf=>^_`FG< uûY.].:Wd60e
._t߈wCCsPS($]i ^[XS0[ tt
uPSR Z[X8
t
<iRjBB@Z2ÀuPpmtp<wjut`2.]1a0P`O2ˋaPXo(
uË uW3_&!pppu0_s!2OP2< uL5/؋AIS [@R;vȁ~uAJS,f[Dt@S[%@عSQO/2f3`_ff3f~Y[f;s %Az}rI~fiu2uGf`P@@RPfZf {ff3.fX<użS$f[fa=s=f0g$i[f%fP@zz؀XZ}RAZfX2v
uQR~ZZY!2 luRY0Zt۷!23nt	!lz wl wfߋ=]QRW!l9q f&P~f$Ԕ}`Дf0_uYu& n  T8<\ VRfPjtZ^fO_fƢklfffPfVX} VЭPQRfRfQY Э $  ZSYXӠ
!l f@fkfva%7WfЭ!l0BArϴ&@fIur=B&@[Ӡ\t1W!_f.ஏ1~;t3u2@X@,uQSuz3ɆtA
ڿ 2[YQ
̿$Y!2@s?SQVW0&'# .R( &IWCCB^Y[!20P7QRVWkB	_^ZY0_ڋ_  c ѽ#2 :2_@MR2 Zt $Q
 tSR SuZDQS0&ĘyH 2&= vmR8STUVVvWPXXYY\6[[%ÐPMID)#]!  ׸ d###d]XR ZR !
 ! ZW`8 _Üdт  .63d f.;u	W 
	rd2[fXY3%& $4
Ҡ״Q~ffQQ2
QQQR`WPH HfXR2Zff_fXZPJ djb {ff&Lۊhj/틩pR=fZf>f_Zpa~fPRl g +Q4KK;rZh S 
S  S@ [ hSSSR	Q Q @5QYÜ2C @@h   ` cBid HB	fPp3.Df.T
.d"ĭR! 4Z^BRHc&	`{`R	.Dt fX_Z
RM4
/a<tpU
D   W
D*
'Q e8tQsfu*cr YQPTXr	8u
}TP u5,XP	 r%ސTr trTjr XQfu#2 Pv~ ta%SP?u$߻XP&rKru
 uKuXWq_ _++QoS   O ztGTrN  r0t;Vt3Tr,Gt$ސTr r1P% B,NKu@}u!Tr dr
 sr$,}Y i#`s RP* s2Z3W _YQWs@& 5Gr	zKuq_6P 
Q Ys% C=~= D>= ߥ;OO<Su:rj|[rbfفBuٷIrE8w8r耥IP2X0/r+VDf ErrVDM r 鬀AXЎu3@Ptu3S Q8XY@[<t<0[<uwL<M0Mǃ3PQWGGNǤ_Y蜤XuĤ"PͬPqmu08ZWPj}_
t `nplJkÀ@A>jt`:u`0UT	fV u	k	/	u_wðpq[K<Zr,ZP2@Ko [S]@6_;w2XXXYf`	u鷰vt6P%2X` ;{ C 8t P DyDX ut!Pw%a XtP+ueP dX P)P%at:u@PXt0P^ f #u#P	hPA ưf 5 诉 @ j
d40
uu[XfaPmv	tts!
2nghtuQQRL p PnapPnDX1ou
{	O^rt Y\Џrqsst uh~f gEg`qxx=RNQ9}QtQRڮat\	tQ	h1|h.? t.;u.;Wt3@^-'(+ ]c@h^_OPU g7r O XGW  O!   #T&ۤ.  	Ў@{<+ T
2$SQ
t/p+ '3t		tt?uC6 `U */h j ]aS3 ![/B$J .gW3`J$
2Q	佟
z	Bw 	

̀{
Ȏq P  /`$@
J`@=^v	@=v1$?
úZ[tS+|@{۫IJS Q$P$0fP߻,(1T  0|᭟cfXa[qS<S㑻;s.:Gu`~u.6R&$ZVWQPSN= NubtЎ3f<8ATIuI 4ك4 t4D@u*D.ND.P...>z07 [XY_^ PVk<u2P`8uĊ^Xû..z.?t uP.G@{ ZYWVQXlPWVl0Y^_ÿ   SOUop6 2iuhb. t[uAcoPsX@d'uYbbMhaa/b:d
̿$ P'kl5][3۩0   v̀P RXu22@t% $CUt0HAW@ P$aAA
쨟uԽ)$<t2
*sզ

7P$Ұ
q@m|0t$}#$ a$
@ aۄu!g$
l$w

T$[4 ѩpr|Ѱ-߃*@̀x ﲩRUD2Ը萙R?$>sAwIm~$ ! W@t3RSR%@'@"2[8$%`+ꐪs D	5B`uPwQX0v0Rtjmkmuklx^q^u^?_` gFFq	I3I+JF,F"FR<yQol";@j߻kkrQ,s3聐p^x^k_^aq
HqIoHZѩJ:n1[2 (~Qn1R!R!?ZV@"
[Za2ɲ KB ` gB`x`s
 WRaYBr
{M찐$
!R>'Ļ$0v$aR*B#$P
S`R7$=($ q,`$(ZBQW2"d@F{2u9ͻ0v<b ސ"
oJ g
"P_qSP.H	tP 0X[6a``NaqGGFQo"0Vw h3j_xiir	0vo^k	/s	u<#4\e#!hkP]D\A(0"
` 0v_u'q݀n!aub\g7h7hiA> guDb*klC+EFFxUu"[[}[\N|$RW&I<#t=<2t9<3t5	 谽	@0
SM[l_fPfgX͐`.
$<`<t#<t<P  <` <` <
` mbF* s&E3uu u	FfF4  ?8a?Y._f.ߋEfP> .GF4XHp u@ىF6XHfq7f%  fF8fX"B΂Bf; `Af	F8;me2[..>ًFF4 <f[(Pb<E`SD[`  Mu	 Q@MtR3ZF 0@LHF<@AGFF
G@MNFpG$``OF@	F G
G.M	̀
?
PRRS
ňFF	 
G	wF	N
FGF@y NGF`G
F3F'F2F@FB !A-? ?<a?<@!QRF;8t7<t3/99
<t<tn2NAVB9CpwFPXR?`b/cOdoe fghik/lOmon opqrt/uOvow xyz{}/~O S(4f
   ,fX[oQ"E( ĀuB u*@f@Gtff.#Gf.Gf뺊@uu}S@@~
[@.O.t	1tIt䰔ٻPIt$<ЋȲ2YW@뾎@_@@ n P3d     	 P P2R  { 	    PД@Д Д  { ^P^P^P^c aљO "Л ЛpЛ	 @KZP  fPWQ2ɋYSQ2xY[SQt93.OɃ.;vP߃˰@2u2Y[VST-U`5Ut)*X~ PQSfX PQ3@G YX fSff%f[~AЋõgf[B  ֋0H
^_fX2QV2y.^= v8B} YRfPP@fXfXfP!
-@fXp"q2觺ZQo2RP$?@X&k""fQfRQ	O$5BP;%P1$ i%@[X3Qfw
?YfLfPV.^2䐅fX0fZfY⺰&u5f @$PJbfYfӽW
2$(<tŊ/MPWVRQ+Ë&G
m 36 2>!$@AfX&2&YZQ bQR
FFP$έfpGZYQ6P(SQR.
q< IP9 Àtnttt"``.묐ğ0tR ݤ QPYyv|@t.QQ
yYf.9VZY0SQV| K< ]u It	1ऌ.Xzߊp&$o
}pYյt^Q CRf± f.;Tvv@ 7fٱ0wjvef+бXRvM`0HϽv?pv2v%a{va`	r,w-֟ZY*W@@._` UNfVf^fCf.fff;rf@f߃rxCfw.?Q^f;rLf.acf;wff+f'v
ACPX.LoN]Tt)t= r = r;.DP.ÃPA[P6!r 躨t6$ Ep[{@]ܲV$T$P05HY=X_S$0y`k'ܲP%&O@t$&W7u t@ߺp@ P H6ZXP۠0ZX 6RWۿǁMtݲ Efǯ_1 @`0f6fs @0_E-r¸ff
VB  j!!! f=  s{f#fP_36ۤ"  5 6](%f6 6;Ewf6!ؾсڲQڃP3`6Z7L`»5ft7f|0|?@  uۃRSf4P?`[@"?ø \Dw3 HjPl А+KK;r.S 
S  S@ [.hSSSR	Q@4Q YQ2 QYÜ2C @ 9 				  :  T;
U9꾹2oٲ[Y."D
$.
tcs] @C J2o@C?/O@aA E}`ff: ]ز[&EF_P@@`?1OX@E&DV@`?pD&a^ͰH1֌$^p&PL1Ftf
^~Uf0\Nn;w ٨[Xu; Pfp#ظP@p R0_FF T	Q(ʖRR
TޖR蟕RF`,Fq(胖RvR	FȊă,U4NX\nN%T8"RF%YQU0[PFf=$>D,ciN@f
 ZYf
Ë؀~Àuqfָ
tQ$m<g K$
R߸ HZ. 4=4, kll{4kQRc3ҹd @.R>h.1Z[   (d
$@tp  $$@!
u{&4~ѥ *Х) u.:tӲ.6n3 W߃ ~5n[ WQRVS0nղ+$  2@ Wf?uTpXf+ղ|}P}3}Ϩ t	~ |X  ҃wԔn҃aSP]҃I=
@S7_[^ZY_B(蛨`*:|Ww荷2 f`tu% tAAjŁ]E{y ⏠U W c A  uZ_Q Ї Vf^fPo 	$z2$[_@
Ơo"z9ËËߎ腾躻@`1σSǞr VPNӾC uS ZX^P.t}֜WPWӿt_tӱVSϾ@y;u[^bҿi1Ҿ} ^( 
- >3qDIRܳ@C_4г&/ `RԿծӊӀQ`?Ѳ >BXq7Ѳ%1p4 Өu/S_Ѳ,X   QȠ@М%1ϋ@YЂ:77h.
 ksY3Ӿ Xh l   Bp   & @*@LN  QRSвUPջ
P$Lp5f0 @ѲXP%
西X`X%XU!~P
[pQP ?t@ t tp71}}P@@б@$BX^fXaQX2R__cׅ׻p 7s<  /.ɍiq`ɑ&F <NL._Fݜь2Kqʌ&6ՎsNPPK^ ݔ`╌
u3ɻD8ЊȵNnu&eqUu
а >?$ C"!Oβ)ˀ$лà
茚 tuQKt  ~Vϋ!N8ȋ,Kt
)A$

m(p闋wt	
 v邋|運P͑@Z`3ɷዣ^0Cۊ2nJt72U?2   ^ty&$P᯷
N2qh}Y}  
QྰPհXY^8x"yZ0%T$rȰU$ ~p2`<11puv/"`w#T 
qu  UNr所w։ۉH0;f3.O>f.O%!&̲$$
tfff
 f.O>u"ul0Yr
J
u= Nu
ۯu 2
*^
+
`1 誝u@݈2
`2	<OZۈB
wJɈ
ʈzJ鼈01, t0%$0	 }
s	Qu} $ "`nu;ʑ}iTu %$o j9u/ʲ"`(p2u$(p!j 1P&t)$p뇀u3tJ%(  2C'@.u p$>@.wu7 %( j
%-%'a@.
bR 緀
C'5@5ZX@P( 4ʻD p&3ʿ[XÀ(8tBu=P5Se[
tqhsI݊FGGð=%  Dvk#ɸUq\2:1 I P P;ɻx;D'$}!D&$|%ߵfQ
fYfPfQ
}!IQ#I;Ik IG߀
  IZ IQ`w@ *f%gxL
%*|k qY 
e!_ SYPJ70KeR
pIS
0Tø O0P pPM  ? uC@X{Y-YmY۸VV!D*ȽqCQ_aΦ]}Y帔YyPYaΎ师A^X ~~AMfM>ȸMYc帍U/OPXYbN0`GYa?PZ _ ׿/ZY'AV[)$ø帕>g ]ph޲^丟A^俻(fBmfe#^O:ȱfs1g 丕萀h@Yn g0kVi xkpp2lm 3ItR2Z8uR9
Zp:RŲP puXZ <`$йfL. gf.R"#ayKp@AT !t 
㰅fR23Ұ
)u}
Z`..] un> tgPb2P>bP22AQJ2a~=QRP͊ 32C~ZYYy2 XaZYYR*8}2.]Zà؋m 2Ku2W SQj[+с2Ê2+0**&R  ġZHu0B$ JÜB J.]c/{ 1  PQC3BBaaPQ 
YXaY`:ԨuX@#N+@.Jp8~`P]$0<0tP
]:Jt. 0S +0*2+uX Уu*tX⑰ u. 0"㨀t0׊4"
ވÊԦ"ð(°Ѡѝ#B= Q$՟4mb݁ ? +!q,QVW++    _^YԊǊ竊ᰫ0p_ 8v2QY2P >ItP
_RS2 PL[[ZRРJ2Z.蛋 03<?& t
uV EQņѺ&JpaZPFp[Ѻ2R1`Z0/Lͺqȴċ
t
2&L@0  >&}S`PYظUJ<t
A<Ut2[ð
0Ί6w0% 怎2+Q++YZ `+Ջ+Nu`@$` t {t|ϊ8~0
td\8tX΀|I~D*}0
8t8t2
8~
~ }taɊ*Ŵ
RQVW3ۋsG бॐ t 0a _^Y@ ZQR01`$aG  ZYËxs& 	r U2	 P`:PffpFlf4P0"RS[FfWfVfRfPbP6pfp +Ɗ2B1RZf^f_OSRP`f`Z2f[nqȣNpwy拄僒&I03wp"$ʃă|t;@@_v[`@ovI颃1RZ邃[肓R1x\V`߿3@>:twFC#QP+>p   ~b+ZU hQtނB  +|鶂~|"`0&F鄂 +쒷u &F E&  P ѱ+>2u	&}uƀtGVW_^t!ut
>| `͟2|u\ӁRt  r`u
`Q6JX 2BRPTðQ
@SO 2
FfKu[s3Ѧd~"A|A?7o!uG黀PQFgQX$6| 62tmU؊Pu)#ë 1&NP>Xz ҿCq11{3  ׃PPf2O 30À?t!&06u4b2?2$ &W1O77 8r2ÊЈ2PЋ  1J,PRXWQPsêuXYo_:QI@Y+MQt?B_v3Bov
 ( _uP%P[cp.5XpË VP!.ۀ|F`6umXPRJWQQWp@_G8v
AGY_p[KZK&%_G+B;v
AzBM  òθ+/  _m@GXHIRWQRQWP8tXP#$?X_YFQZ Y_Z@PZPBR/STUVX?XKXY$ZɢZ[>cta
}}>
u&fg3 f f$߀P| `i
`||SP
# 4t&l 0m&]=X@9PeĴ mGpmĀt
 &'4|	P*|]aJ% Ί%%~Q{QcM'wP߄[X&{J{t
&{	-{ϐ̢uP2"#}~p{)zu UD{>b2PI<
vL5=Ҋ`ǪA8sZӉQ`z't u2<
u:6u Ɖ`z<uz<u
t22+ˁt++&eP>`"g0 +gzހyҞoRz.%~2O}Є3Ɋ^ʰ'uF yyFF8buy~ԘF  NVyb$
I,S(!Q̊.*9t.;t$.
DY^ay#+3*2d!d"<PReZXt
aet
5ybeu<s.l۪S!5MQ#'KtÆd0m0&x|+0m&}#1 32  qw0$&e߀ te òNsQp2ߜBzJGz/^ xQ&5&m&M CYw
ub$i0[ccu4<wl vw2 &5&݈зMe{w0qrѿdw}a4 ހл  ^뽒1 ,lT +wtlS9 l.P;PYǱd2|XR~ ZSں@pNBHC [Z SBB  Ȋ`PSfQf t^$t"$2t t=fIuͽvUαt%ut!fY[X$ .~?<t
uMvu<wPSPR@#n@	e`-0^=s=s=|s^=Js ;ZXj[XF#<t<tˊ~S&[ߌLu#Wt>BF5u.| ~ *uȎ@2..u 
*9 Խ
-XȽ5p
uPw5wfP&Đ u͎..EF.ŕFF t5
-
1
5S0[kx&G&g3t!p<}<}ô0<t
< 
&G#2.ðGPp  Q֋P$#"3ҹ <up' XMP fP
PPuu
&~~Ì>@S/[t (22QF t  +YCuá{PW>&}t0&<t$8tG&E  @_Xà3t_ït@G8Мu&20 ^@gt$
J=	ȋs;Peu`tH )&  L2ܾ5t

`t<t FX p ]bJ>=&]&M&U&E
@PЏ\ Xa}2PSQR.]t	0Z<|q?SH F(5[VQS&F E<
@<
t2 BWd \@' t&^ E!	prs0-Ph p}	t2䆠oSUp][1&X[YZ u:up`kp~Q^Fp?<u	CPr+p.:r2P.]PfÆà$0<0tu/t-
2.;tw11ǰ8~û  et2m#Q /V4@5t /C7 7B8@7 8 9  ? 9     8 :9?==RW*$Z.M$SQ⳱SQ0Y[f.
uY庨Xu	f.> @f00@f.QAŀt
u@R0%6
0txZՋ .(@2.OA.WBtW+A_t;r߀t`FN M@
uc?.&NɆċ 3  u,F;t@ty `y(2N
0P8tu?M2@_
uJJTЀ@a\

@ SPzPK@[ZPQVWS.>JNt .JT2YTux蘧.p޺QC@
P Ў3f<8ATIu? 7"2QRS$<u x<2[ZY_Y.Kɰ.NEn@ħ[_^Y,Ŵ@ 
XÜf`PSZYsLtytrSE)Ef9ۧ[3W)ffgb[ffLg
h	gg\	f{  hgr0 fa @fP2ɻ| fPf OgdngSgingBpqf h .qѧJGrqrq2/},s>2P ${
rXꦀpfvpovڦ`n~v[fXAS.= t.;u.;]t3ՐEW6uR5 W:.eD|<t<<t8<t4<t0<t< u0P+6=@uuX5
X
 =u
_qG@E=@`Xx ^} ` ` @@jPmm@{wj X--    zX~u`+P=u/nӁEҥf(y?|$Eo$bq$J U蓥$u ۤDqe$bjW0OW PdW .? t.9u.9Wu.G2t@A2w2`B_S4.OɊ
?܀/`_P[1^H^_ûOtyWt@A3PR]ߣ$@ZRL%f fRY t3t+t#@t.tpt>t %ffȐ%f<~f$<t$f- < tf+ f
 pf2) ffffZfYf[Vn ΰ2ȴ2f3.Df3ɋ% ff].%L 
!P!"ff{fҦ  AXff;t9` ;fX!Ͽ"+ " ?
{@bз?1 m ࿰ ^'¿C㯊Фл西.^(p蚿萿ѻD芿E腿FG{.F*.~/ d߷ Ҁtttt	tR3.)~$ C9	P  @  o㢰!fX^    q  + 0 { C @C~QCRlu u	 .F3HE0_ H`1b \
fXf0	Q X^P.~0

00ɑ԰ o	p1tfPƟ0衔?4蕡 pR{  8"of`EfPRQ!kuP|߸W 3?L 1H`u XP 20( 	 $
 ,LCFTQpO XT\T`T#fju `u8 tqt= Y E`{ p6
uu
XTtY]I?U@E  M<~	<% Yt  YZ`ERSfPW{L׀.E_fX[Z!㝸4vF
豓<褓!F; pp9(9;; >0˘ ~O = o  )pٌ88 AI? CfpQ<t%<t|k
$Ь󜿸ΞbEH近rN
`f
  F-f譜oP舑ưp{ f.tg؈XؠqIff
@ Sf% t!v ww x p [ؐጿ_ZY^BCRVWEVp 3ҿ.;s&`?.\ ?ËQ O^ L.VL.d20}dG_^0ISD[û@) J'(qb֛ I1 qhu Fp+SSqI蟛 q<ߜ t"ʛ@袜B0u{XЙSGPS2e
zRP>SJX2W)cP)"*fW+&Gt ff1tf.#fEPf3۹PW#fCEXԚf 	+WfVw
!-f￞..
f	Ee;B004{S1i襚Xnf^@[H  $,48<DLPTX\`dhlptx|  ;Q  _  ? c$
k*6
mc8*1 0
  
 =!B!o
D@^#
q"   @   
I @ .1&yE0BF>G1EEq_IRGJ @ PK?-@qٿK ILm0$ j8!NhQHͤE&`L_FpGRGpQ1Ec۶R, - Y- =HEPL y5G%1#~HLiGZ;[L>]3[OOSuP[/H8]@Q&R?FSPd`HKѤE#RcJFfNNE_ ؏h	=# wEm9aT1 kE [h0F+ ϡ /cm-EvkV W[P}`Wz _Bm3kkly@m @q B+ 1_@ : IR?# pQD_{)|E(+ h2H}wQ(,~1PT~cPT PadP=UglE-'}.~]ha~,{.~Q
!^OaP] `Uu adsp gqE%!A_rRqv0WpPPԐVQߠ  $TV N xPWVP!  S[w^
-؎"@< u+~@PVf >ӕ轛^[ a   N{ ?f=va?f= `#b?؃  y?=	wIu;[?pT?=@ru!͹ ?S U`Ћ=[<wqȎtFĀXj|봨ᣎĀ@ %녨t{2+?_fY )虻Ð  _P*zH x@ PSRV $PV
XtuZ'RP$%"
XU$諒߻J0$螒OP$2*ᑲ'쀯} /: 
tRP߭rtиt M	苑 쀰XZ2WPX2 t3ɿ;t 5t_8P33 t3=`"$@Њ$Ћʊ$o$2Ȑ=u#	= p< s= pepFpIp*pppưf=vp<hp
Z<P<$
ă[> з`4<衠Xü4 Q *@d @A &06L 0  A  0`  1X (ӈ 0?XB 8xV=!{V P	 -`1N (( @6@_a2@`QW]_Yu?E۴'葟t  )ː$À}1Ჿ}$ATt$ >	ʎTd
 $%;t`XO!#C>ݏ3Ga%>1躏p$W頏f@)Rᐏ* ux$Ύm׏a%(aP$覎51?앎Tp.ptRύp& B*O#sA*٠ *$ Zs%vet
t᲎ᲂ؍2tKF2;r( dWF )FV_%R B ZhP@P 9 	9ð{ 8a78 8tёQ		5Q		軺	?bP	
8Q	PqQ	
KP
@|?$ӌ )RnČW  a%ZP%hT ˍo@Xs\H"Hx$i#\_?[URF|;s I7 RFNP'uڃ?^
[F ߰72FF
VPFً?B 
P?PS7XӀ
AYINY ^HF!7AFVЉVWa" "s#]6F  F^a*9F$v%FfPF,f8{f6(" FPw .a"s6"F	FE-}P-%Q.F  +&R070c(FPQR0$ $ 6
$?
ZYfS`U a]f 蚉uffh%;]9]Q ;$
؀S;j5<;<%&;;< &; u<<
47C<85C   z`fĜcB$J&eqI J
/
IrIJ
zI JqI] JL	qIM L JK D%= v0G$U*3P7_PS% TVP PQ@f3 P>3ҹ ȋIXA;rP0	ҥ$RX;ÿv;tY`YƥXPQ 0ƥ`Y
YX  tV^S9PSfpF}`VVIX^fQfffofYXfX]P]_  fBT^f^RfP膡;r:ofXZeˆ@Pff $t  @øN = Nt+踇譇$d袇$ȱlm.<  093f<8ATIu 2؃? u2" PV=	8uĊ^Ъ2P.o7pMp؋7t` 󤻜.& t._&@.?t0y?.EtzECCn@VfSx`P T踦.]1f}..M0X>|Xf[^ xf{9wQ
RO0
̻k$
迅.E6轅fp$
Q$P H$.e92N蕅W z={	_X.]9t"=f 	`=%f	_}&fW@e$P8a0o詅a{B胆@BP=%
ĲІ=2.[.k`lufaM>f_~%v%}u

輄kl12 
踃)
0
胄" 6pmKu!艃j{uPj< RbZ0r鐁~[;s{.%R$ZWx.E#_@_VQ18`tX #$͠f؀	Š%`PF%f=-  t*f=2"蝠f;tQ;
 `pŀ~ aHΊY^0f=  _ x@p$P }b4_~q`yuPP橂1>c荂QRR$$4
a
oZupL}ӌ 1Wۂ.m Οɂm@PM,tc_a$vq뚂"̂$s7近J's푱~}4 t&TPQ t9$o菁& |lwAfw Vq!L8f  \nEIF"!F  f׋F-+~@xF&2$P[n=X5R 1e/@6:o9upI`F) X$
F)諀q북
FRT iP꼀fF4瀼8݀acpF7tF;؀Xz_FB@0蜀0qF'!F(芀F2Sf 
C3Bk^_`2Y[1u@3ۃ  q !WWI f fpIJ$a	
ff`
fﰯf`	
fNJ$
f	f1R
f̀ff藎CRm{˄q~nh>΃hH5B 0}6*_7OҶeHԛ~~ՐfA~~EM~oOj٥fX~ڍ~{4\~MfϢWUD 2F E]"uJu Zu	FfF4 8Y._Pp .G &4X "H˴PyqP6XHpfT fF8fXf;f	 x2[qq..>ًFF}$ьu}#_3v4   @D@L
~17""
ı7W yz.Et.;
u
.;Uu3_55pm7Q)GtS2~t	;
E_.$@
PQb 
PQF"FQ2N(̀oN(PQFQf'^'N'PQ+p\$fF N ALf`fN) FP
F$p"2.O$F&F!%HF+-% 
ff%F-FB&
$'.oN3P.G$ 
Xn%C&F~f	f	a%S))2C*w*n%U+ '/P5T$,&(c+$F1fF N %& nO1f1F,Q&"f..g"36`F!7@L6@7F"86U8G	+Q;$`,^;
F0P* - Fb-'
Q'>!0>P*/f=6nf@&AG/$2n6A!6
6 9sBn/
 07Df/f{3	= n'`N2AVB F.  Py tZwtUF:56r_	
t_P{ԀԦp	2W$H	_F2_B:622u7!
q5P a2 8 < C F H K L U Z d x     ( PwSQt$^`]qXhFt,
F u	F=2^~.Ff.f0|pwqfKy^fe>~]Nn.)Hf0
`y ǀF	\ x]@^5cf^
Ah6cg5cFe$b`ѭ6cP6c%1cA ^ 2c{F6 ^uCj2fCxU9Z5ywh@1cXf^߃ٸ4!5c^oB_~/So8w^^ r f^sPF=$s,#v[@ u)t
՞(xuW谅ZYѫȎؿQD	DfD! EeЊ]}q  )ILDu'uD~q++І؊}Ё@@%??3DdC_Ee@ÉDE	rp~DEe|}}HDL~+S2]Ë؃І$&ĈD\\[ˊE
*pa@2?ȉL Ћrq,D{3D{< vRd{}~<@$P|X;&׉D!|#qЋȉ[D)F}
х'E/2pD(D*|F@D+/I-DD}0ȈD.Efث4C\1\//ЉT23 ]p}HOt@P hD;XD5߸ Ɛ@^@@X ^Р@ XPЧQ  x@0Ь  Samsung LTN150P?1-L02    
 A  H }  ! Rl L  "0Tn0F"d`"/0U Vf3ɹ ҋy^
uyЎ؎fpudf|~p uZft6c# =	wIu 3!{tFXߨἎ֨ 2񻪁Ŀ ]Y`UG {a{	? !{B|PeE;$  E;X e9= vU94~3Ƀ= t(9w$= u9EwAEE 1ӋAᾰ@ʀǀ} u7{EDEDSQWV^_Y[| u {?@.|& t.|&/ù`{˖|DDMm_Mm2]a$@VW!VS 2 3P8ATIt[ ؋7[tFAE0&G^±
 ±  .Һ u = uDu

 aڹ  _^VwQfS@cPؿ2
Mff;uf[.Y^ûEp
oyp%oQ3 %0Y}4 _t_1do1p$3ۊS  0p0݌3
όp
p
[MoE3_n4_ ο5@'EȻ*o$o>Eonpo#nfPVWSu$!0ǋދ*p,ɋ\\%ص.}4u
'+Z ,
 ?2{
._1g6 &s 軋"}&30@E.e`,:@3[_^ S r [À
t;I5]o  M10 OEM INFO/O o	

/O o/O o/ O! o"#$%&(/)O* o+,-./1/2O3 o45678:/;O< o=>?@AC/DOE oFGHIJL/MON oOPQRSU/VOW"2   1COD  P h$Nh߻YAhS@.'h[.gZgz$AziQZh$h0[if߉DU@\P1INI??SQP2O.N= NXu2˃	w,i.'
t #P`gb|`Ou.&KɰPm ?f_ghi jkln?o_pqr stuw?x_yz{ |}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ?_˟ ?_ԟ ?_ݟ ?_ ?_ ?_8XWV$J4W_ ?	_

1600x1200 @  
 BrX H } fe! d'rX=H   O=: yE
R` XA   !!X0 3Q0`X OD  P P`XX n  |a! e[ XV%hAB#a@(= x@|Ϳ`*** *+* f*`+*U*!*I  *PX1&*/*m۶z1%S1""cM$[
u ` 8A$
  R7(!Xa!"*OU  L  'H`aTa//DO)a))%2 21	Z @9dM>X@  OQ?
>n$ Hd%@Q5mqAD< `4`??A 0#w M`;?LL 0E&Q&
11 	
1(X1I:
P(5@E   '-XF  
3$@l% 0 1#N  O 7 P PPOP}P LPtQQ@E
P(H <0-`72`7S1TBOBPPSmA -5PCp  0"uu- _0 #  ! o`  2 2  Z2a[Z2 |\q\ %A#A#]]L]1#Q <_ A# baa&!b_1%d]j^]?`  !* a*bb*b*&*d(H?
H?aDrmLO`?!"#$&?'V((*?+_,-.P0/}011 2C_34567ae88:?; _<=>?@AC?D_E~F1_HIJKLMNOPR/SOToUVWX@aY[?\_]^_  "`b/cOdoefg hikղln!_pqrstu (?x_yz{./0 13_78 ?_ߏ ?_OGߘ L?_ߡ?_OY   ?_o` ߰?_𿸯klNoϾ/O?vŭ
/Eˈ˛/Oo)/O oڏۯ/Ooߚ!S ?_)_ ?_/8 ?_/	O
o
 ?_Ooƿ _  _$%&'() +?,_-./012 4?5_6Oo9:; =?>_?@ABD Fߪ_HIJKLM  ?P_QoTUVXռZ\/]O^ o_`ce/f ?ijkln/o" ?#rstuw/xOy oz{|}~/O o78/O oϏC/O ?GϘ/O o/S/OY?_ ab?_KgwwGhߺ p/q ?_ɟʿ̀?_o3 /Oo؏ٯ@/o !# ?_ꨝ3 ?/?9  !s8EF%G  ? c$
k*6
mc8*?1s
.
 !K!rL@^#
^"  	A  p  
I .	@&yNlKO>P!QEN?R2PJ @ 0T-XNKRm`$ j8Wh1Q̈́N&@U?OPPR֑PPZWNc	[, - Y- =	 ߝNPU P y5%@0^#K~QoUIP@0d_UfdW[UY[H8fcZ[O\0m@QфN#[CSFoWNN q	0# wE9A]@s~N [qpF+  /Cv ]-Nvk^_[P@`z PWBmt܏tuy v   B+ 1rh@ : IR# PZL?	AN(+ hQZ(,cPTgCÈPT PAmPUpaapM-'{.]h!Q,.ЇZÍ
ec^OA0] g``UU  AmSPapQȒ1
c_œR2fŖQWPګP0ങV1#HX`1
w*
O0I"}|I1CZJ. !@"E"0"LNA`Npb
 P cb6vQcPAD	3TTsbF `Hh  @PtCVNQWW 	?pl|ZrbUU 4q 
@P]bQc0W]=b ڛWh	u& GX4 ɐ` a` /@P:H\`cADq/IgA&ϸ@jq:BmĮg~ o@P`o԰Hv@QWXO+ssqsmbH.q4 P cLQvsbj長q z% Q6 yo-bb{6՚qr`J?5 !|y<@}S- ,n_ocv3@}bhhՁ˟0"`{7c
z )ueR ) đ`XPC˲'߰VLWtÊW0/Ђ߁M.Ѝ2w.!Q/p.p܏ Zq. acjg!b"AmoapPvsӕnYcЙVA!WIЙSoHT@'HH?
u0IvI)._JKLM dbNOn"PjQQcrP%@ *A3TTRsW9W'XYGZ$r!"P~#]]^ y^_Q|w` a @9qTc /@Pg
@jjgKOkYSl3mm<bp`TvWs~u# %vy"znz_Wc|AB}? {bA"M
uJٟ'( *+/㋧ϊ+. 񑥎,SՏp56$UA5E6b8ap:֕589S'$<  1  L!    fSfQfVfWf   ff2ff߃ʓff3 7thf;|uf;Du7fs30f\0fyffÀ32 ;Tuff_f^fYf[	!)o
 /Oob &	  4(` obGb૔ yuJL2ŭޮȧnNLdSlQKlE8?H[~U
dc1(S >||5.)a{hTuz[3:Y%7zv8n̰5MǢ}=KK[lO- CEVW R 蝔QtmܝIځu乧&s=ڍ .h~%rc9-8ua.<WreωQ>^AW|e@K"kK-	a"Ǜ>_̷2T҅1`ak&>;&.z{4415-V׭ l8bQcк+7&V'*yi	AI5ގ~	rQfDI-e)}v1/v@cm=/.;(mٱ>
J4OKN`.'f3ސqM%>-Zs>gp¼/^b_b
<*`r-j6OYS  [(*SJE(<SsVuU$r#X2~4.v&s-I3 iv1/1%ڜeB_-SK=@|3h%Wb>t\"u|6.L{W/&ݚ[&eab#A= rTq	>Rs.ܧ(6b|^#
5
oV:sp%\R<n,AGK 6n2u@7QmIc/sϴDM d=>͇
΁Z;b&U57>eʈg (z"a 8W׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eS
-Gc#('S)\S:s~deߛ&{޳]uTLemdF|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthEPbcIFt1vT"|} Pa>c(^)|'6CrT[Jy-Awg(^&1>G?D&W,ҷEVrfz*UqF;%d%Ev4\ω7,7C3KS4.HɸaD)c%O?+Ǌj&j(@GNpQрOXNqKa
Ԍ02S<{{D&/	5e	mduNto@mbMɡ{WN_ƭd\?*]n"P1 ywvj: TY,(.TjLy}Rs bL43E
䎫j,ƭ<Ǵ2+vAt|3o;n6}70+=辸iG,N@g!CVO(:5o ]]`c:=cވ{>Oۨyh)U?ZH-9@FAnr'Д/K!t_3/Zg?5bmR!`
9YG&$iV3P#Dֺe2HRk]>
xQgH]<C6<<g7zwɽ)$@$^ :Dǉ/' ZOVAliB-Zfa+y\*Af;
 }hw$;43B"qdV)]VH11s.4]F TJ/{- ~V&xm }
oל%adE}sg39Vmr`d;Ze]$y+U6~%y-	+|AX6RT[Mf+L*ޘRnhBYZ[\^ /_O`oabcdeg /hOiojklmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ/Oo͚P  "Ptm4Ϝgf~94R8Dsx^A`96b@kpgs9S\})(d<f*̛(m:FW:9DT!zcUDh
^3,\
8f	߈|	*Jn̄2CC~pF[>%/\tVyGۯ*7$ AkoxLŕ[Z\J	|Э0a!QQׅa_FH8qa]Oۂu秈]|xڵd|$SN(Et+3׫[]bKY/n<;ѧ҄Wkz㫷
Yvdo%9fmTL	nIxƼ29MEi!jJ-r%vx~
mwǖ)fL"^g{[AUOP(IcKۆ^Va_;2ŷSh)`cm'dN5~ù+8a!"LF{M#,뷿Bh.6DR
{h;M/cTDގ7գLloŤة2χn]*ѡ8CL/g1+f3#i%co Bvl7_BEt.Zx~i$/ftW
P/64hFC	%! G Q2;( аrY2/nxs^)4흥 94JIn8-z9N/fj۽_pz}[;bï"8?9;U	NZK;#7-omٯ /Oo /Oo /Oo /Oo  /Oo	 /O
o/Oo		P!}geoGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:׃FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋏYZ[\^ /_O`oabcdeg /hOiojklmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ@/Oo͚қPGϜg
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4҉;jQ0\K15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwyꤎkK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]hÔ9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC UEu;iTBܐx/Dz1J8pQ?h
\Q	L
mvfCG=;kٯ/ Oo/ Oo/ Oo/ Oo / Oo	/ O
o/Oo@ P&lge<sQTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuupW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3IYZ[\^ /_O`oabcdeg /hOiojklmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ /Ooɚc     t     G  T  ^TI{ jP  RI  oIB W v D } O  1BW 1D  PIBmWbDaoOB QWDCDM!MD ?#ME 
%F h&S bQM{ QC !'K (U  j*R  |DR 
SR 
CR 
B  BLP BC BE BD pTS 6.TC PRS .H  /?sDBG,0WIN[0OP *0GCR-)SDLG` > ^ Error
  ?_  0B2  Press Enter to continue  (CTRL-Z!abort) ? _!NEAX N" "L   OA` B  C{B$JEC"JP% %#K{C$FED"F' P'#GD$EB"@$!#6ESI 6) 2&)2݀* :(P w:P
 >)+>P, REI+R0- VCS0#0Dr..)0#,S.w*F.(G.ZF#a!rDR0 v@11 z@12 ~@13 @14 {@15 @16 @170^KCa1f 5P2j 52n 503a!"X#`7#b$3%Q% 9#&c'`p:8(@8!#
)
***	`;+	+l@<+,"---c.ͪ.C/ݳ/#00ŀGDT ɀICLCT
!5pE23~W4NN a!wBSGJXGF]
a!6bG2gG:{lGZ0KIV:a!R  G,4M>M0qG.uO*yO(}ILIa!"= (SCSDSSIT!UBP= D]ST= F VG VCS:IUSS:@,SFLAVVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=GvB$[zG$[~LIQ$[V$[[$[`]eb!p$[x$``QP1UR1b2b3b4b5b6b7VCLimit= , Base=!1Dte^$[f$[j$[nb5Vach51jdvG%HHVI
JMJ	@KIٖOU6PPvQMMVNryKIŀGɀtuOQ!Vegh^f_la!C= 0D= D= TR=kl!{{P}/}  ~  0>  | ߄?_ ߍo}~π** Divide e Invalid opcodeNMI (previous instruction)Break on SMIDebug hotkey ssedSdrg invoked via callPOST tab}lntry Tracepoint
 							

*
?
EXEC WRITE`RP  _ACCEQ/A! A BY2ORD
Dpª𛥭MONLY î NO?TRACE `{0# Disd _RealMOnlyEn"B#NO  INT3sP`"OT TEMP  OFFONeISABL ENR LOC#  SERI#f CONSOpRE20cc ս CP@
@sCT!Ҧ A]LLIõyo\oǏȯ0`Ȏ؎.V0| 5 tU0̓͆P>t:o$>U.#uG6J557 ѿqs
G{7} uVRό4"$r;s3|7۰$ 2 PSQRp.c(f._f.f@٭Ujٱnٵr
u, t$.t@N u% ;t	.^ /uϞPӵPCrt..9Vt!pc.툑!wv   a{ 0ֳurotib aa
uj. .>_P0u+.^t
u3t-t._ ;C 3u'߀u2_".  s0d&Q.ZY[XfP.^_afP`r"{>t"e"
w B$? 8 b ",  %" L faù   Ptu
D>=4 u	0rhN
	 :tw%3t3sT4= fPf0Ka}p	bҍ6U<uf.R=fu<=upfffDf.0
?f.rސRfCf.a./c .3Ӎ!>/d  /Ϲd  Ϡuf366p;ZY{f[PSVW< t"<\u
<nuF=3<~u s2*3_^@PS>:FsI>%=s@>a4s7>(r;< u<<<u2B
VM5'2^@  CyclesAf(uSec= ) ???fQfRVϨ u\@ًaڋۋr611ftf+fxvfu	61ff331f.x082^fZf .{݁Z<@ &Z֍J PQt0ϋc 2r	12tYQ 
#2'|##	 y2s
11t菟4r_^%W<;t=@"  ?@ $3s?v4u1rw$0.Ws_"1tT!I4u}1uP	
C=34u2r:f{ s2U1t 2r#D06
rQ0b ] 3 
4 5  1t-*3ur2r,D0$0t
>r.d. a г3Q@X\@	Pt5.R.;Iuf.;KtU\P06XR	r n6S p
ft<guX<t<t<ͳuL@	04t	.TS 34@"@1s1`/@?0֗Í:oG FFsG1G%5HUsGGa5HH Ñ/tI.> rI/rD/0 H0r5} ufǿu%$NNufP
ܠG RPpMSe [R6[SSQSSzG[b׋ߺ*a*/0s+"@%u/|-/--.(fpװ *\fW7O-@	ffGGt
S_9 [Vw2#-^f;t]-wߗ-G
-
PYfVEf3Ѐ?t-#.fGfsGbs,c fSXMemory, I/O andbqRs must use hardwarexf (0-3 ->Yr#-8]..N>Fr-=.뢙 l6`llmrD	{v m k-t.r__j@ k rk.՛k l@". f $- Gt >i
 r߈G 5  /! , u
0v G}pw WQr{W\
f\GG ,r u6@	P.O>
 rGGvs',tjd r#_Gzt |6f*3QM,r0fu!0P<upт0yQPY)U*c*i0_V	b- r' %3 `0P0͙R G+r2}tn  0SrS͓Gi]r
+r:1rlGQr+r$sm1r\+r 훱R .+P,rqss
6-u!+u PXYiP²
 fries_numb0 PQS ҈36(@	џτQ t"(6(.'))%BP#     0ype= Length= Bas rByt Trac YVW*   F(()u1?G`l!t )6o"(d@_u`  0({uJ 
Gw>  }'fGnat;)[	(GO(:
N(]0&)(P%=8E}	  Ѹ'(BhalPdy active. Do you wahto repl ihY/N)? "RVWU@	 t*@	.b 6[ w  rwfbGff.!!Y}t 	P}bOff3
G
G!3{q΢]_^S`pW؍ 2pFr{_rWS*
qg7 sp &Q q߈Ys<s8f Lf
u b1a`fSofthnoސvaila.
nrG w`w
tBtq u
*D u+*@_T r@	]; u629%P>&	XQU#_v`1V6@
 5|t/fTf TCC[./D.PGIuQG^` 4.D9Ou.Sq3)A -!{a`0  &	>VWQ Y^_.?@a`2 R_ *C={	f9Ou w.s ss݀PXa! ۶Cʄ
`".&^Q@L$ ù  o   P06.E..F 5 rGpGG0A$r8Ȱ|5f}{o##/O# = ~M#CP$39:0 r,pG;5@$tޒ	r0=G$r
13W$ts
 u	rcf=  w[3T}%rR  LwJ#tCi%r>psw8#t.T%r)psw#
؀#r#t_6%rQ_L Bu0, Devi, Fun@on= 
 tx0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** Errorading from PCI
 !  !#t+%tC #t6% #  pC  uR? +3ۂ!E!FfpCA!LT[s2!.!]Et.. pTp vt`[ p
#C vq#`4<ra
 a3~3U^Nx ~@v  ^xaAr
u!! @ !°!1 !B;Vr蓅!aWQU -  6 ! $s+ `,$/e XL.:I/.l0
 A0hsu0hU9!u0<# ;# fС"D4u
4@L) ;"#f.##@46`3`85vf`306 E_"f0z"CB-.99ud>p/u/ xt- =6)8w.#
t0 +)+# 3"qR36#..VW."@sp36f=qs^W7?s6E$k  >#󪔲2`[7(.# .PACr!2A&DD67@JJ/ |0n3$6p3$
4! 30q:."  9%9:"j/'ÿ] VW> %_rh< u
pV}@V @WtQ: EψqX@ +r6%&Gf."p$p$rS" .Rs9:}lBC^@
c65EIO"uPFoufat physical address  NPfxbԐ! ð#srk SOS2;tf8x&ps u2pu6;&>p3~rV&}%j~l6 }eh;.MemoްcompQsu;cccfulԀ_'0v7hx@4&p3|r m*!iip quf6']p7?f@g@p3z'j#w|wvwtfHtrh}@.y'lQrp5tgT4t[|tYrTQ
 `35Bg8xfqS vg{|l r^}U~I3ɍ>tA<'tZ"uج@(8t$ s&At!_TrptChecksum= k r[}3~Fsfghw> (wj[p3~=Np5l4tvv rqQ!Rt]T rp+`\rF2w"I<Lu4Fd r|84v.*#t5@]SWfl>r<:ufF	+rfF>	 r[SRir$r%} u`
frZ[p?.Ϣd3<*p3>*!Ds<$煩  3 .RՀƓVQ.04*lB* uV pKJ.B*?ro0*wH4* P2zr& E@ r..*k.8>*_#9 v~	!vD*9Fpp3!8*`4F* sQ`SASШ>:@6<U<q SFHpހR>J*=.6H* 3Ѩ0GJ* k@\DoH*?F*`.498*w
.B*D*NiIܒ̋D>0t %@  .;puf.;u>-(sMQ.l.f`,@4u ~ǀ g tPR»uIJ9t3..>ֿE.pV4m=!'"ï0 S 7 I.;Kt2%IKf`p;R3;	=>S@ԡK.,6S 3׉򥀱.,ޣ<`@\RFX@W@\۠ aCPU Time Stamp display= Speed= Must set s to ena_ble tPsP1BtJPr	d`}=@h.v&u&>rN@<uF`4v .{2.~ ,-n.6-YP$v3CӋBcbter =   uSec t
r!qh6o.xp.Í>'rtGSrS `<t.&Nt#>/r/.< u8t">r.r
u
#&
* T7argis@rt. Rs manually ifQfails6i/WMQI ˆ9^V6'~F A`!u`e@66 ^PQW> %>U s_YXLt,[r`@10Ur.J b׿ u`.& $rL2w,<r(.0Ur ߵ*s	 b@ 0@&
mkw
 u	1pW	.M"M}#rp.ݭPpMfQ__NPSٜp?ɝ`5P`FAaz· kAa"51
 1
 ?W.h
@i&(a
M̳zE"10sv$:% u0% M	gø6C	>phr6>niSn;;K;I;;**+o-?._/ 012346?7_8 9:;<=??@_A BCDEFH?I_J KLMNOQ?R_S TUVWXZ?[_\ ]^_`ac?d_e fghijl?m_n opqrsu?v_w xyz{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨЀ2g22Ѭ}[pW>2!2 t>6p_W} v	 EAC r3ۉ_P_rS t]AMw][P_)P٭
ЭPX
2t^𭢱2ѭ<w.2ؓ2 [SZrı`P  ( 1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?j_`!?`	3f<u.3<xZ.3<Q<
23< E<
u.2<.:7<u 4 0<s+.2<" &8<1<rÁTapu<<up08<.:X "3>0.?>2<:A$w4<.5b>؊5<t ˀu 8or6<7<[ø.1<.&2<@.=<X`E݊7<.*6< v&.6<#& Laz*3<S
.#!ԃS$3݊0<aR2< # ϊŴ* # 译K`
 a	AR.9<
 Z;<ZÆwBB5PV~^QR 3du t񰰱l`$<6t<*tPu.A<

y"A<
x<Cwp.A "B<<ڛt
ArZwG ZYA2
 d0 R7 r  dI r`.@<@r` d`Z	 .@<`a Qpt
QhGv Yuu#s3s`8umPf`8<!O W !Fq@ &} tC	t;k0ta3	h &t&E
 ظ@	 P ^ X @Wu-  ~pfaq`tQ"OA _ Yf`RW.OA.1Aw#.U! 	tff.PAƽ.TAʡ_PfXOAu.UAU.TA讽_f.PA+KdKK|JJJ9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH"r.A$$$AP <t<t<
SQVWێA<t<wPXrs<vA.A>A &_^Y$$$AQ Y8t	( PVtu@I0
<
t X2Qt .Qȵ$0<:|up06ff6PffXV/pϭo
p0^Vf38
9f^ << f`3Qߜf
p  >COCrf0f3ftYP0C++x@2 fa%

 CCR3 ۽CPE1< tN< XÀFu'Vu@߬<0r/<Zw<As<9wA;t^<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3! o!.SVW31rKt	s<<t<p; <w
t+&<Ru	& u@R< r KA< u4 _KPP0PECPEOI CN ۩ C1SQWU3t!;wOQ
G:Yu
;t} tۋG]_,rf s ZYf% r}s`^ r
<:uft_]Wf33ɋ1 r	f
ANLS:R ufP0wHa^<fwK,W<Fw7<Ae7JI,0@]WfU:af>fP3 fX`bfAN0\ u3d
df] Aef^a<'u"PS<'t	Ab3dk"eNt<Yt
<NtNP3t8tNX':*򮿋HH,
uÊGvO 7ÀM=GCp2PVWuu w_U "$$Jy$?y$4y$)y$y$jy$yAqA`T P G WIN HHHHHU$<w%.HGu~xt;wxߤȰ
r3Y]Kxff   `HB8uĀuBJu*@u
 ktgB$J E@tgB/AJ
 S70Zfb0z$ (u#QgpJ BJQB 1䅨@a SR1bNZ r. $0P@0m rPrfЊ  bH t$<+xbH+
JE$<u	f pgcHB칝1`heBu"J Cх J g` t t  ARڳrȀ $@$zчЋaU$`<`u`u uR
 Z- ' 2
JJr.JПAZ10@ρ r@OMTB B |ԧTR0ᱰw r"5u<۰PqԮ];u1p<t) u0JХ J"8t	2 Эh|Ýp J#?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ ?_  ?_	 

?_ ?_ !?"_#$ %&'(*?+_,- ./013?4_56 789:<?=_>? @ABCE?F_GH IJKLN?O_PQ RSTUW?X_YZ [\]^`?a_bc defgi?j_kl mnopr?s_tu vwxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ ǿ?_ п?_ ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CD EFGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_꒕ -RQ	 o 

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs?t_uvwxyvz
Compaq BIOScope
  - Skipping POST breakpoint
szB pz+~pzM~pz7~pzX~rzNǘ  2\}  @ ~$@b@@ԄԄ @12Q ᅡbR /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯDBEXEPTN˰DBWAITCMRDCPUREG(6RDDBGPrSCTRP^MEMBUF) CMRSPIOPORT5AISPTEXTˆ/INSTCODEI*SMM!GŀdESETARG˦/ UMEsWR+WR,Q#/1RQ#AWR) Ds/˿WR)Ԋ @T T  ! !EOP
 / Oo/ Oo/ Oo / Oo	/
 Oo
/ Oo/Oo !˫#m#ϳ$4%  "#$  rpˌȎ؎  F߯.UfP.>A uWP.)G f3.U.H`,I`,O`,M`,N`,E`,B`,C`,.. ,..AXfX *fSRkP.Bug01)u_`*+tT.T$03t?$.040脨r'`*UE*`*Dp204r	)`1X
Zf[`001M01N09PS tatCu?`*L*7hOv t-u$ظP hv;hs=)Lp:r S6uE[X`*Cp2'Pa5
.-> t
)0A VXPs Xr$$
0
/=
q>)1 roE`C_x 2G G hP~; Hs=CruX HrTh;fP f"wqJC>
 f.|`0VQ6'?1A60R Y^PSQfR_V`*U*(&\f&Tf	 ^fZY[XðS3ێϹ  Vp@s H ˜W0 SXX#YUXYX	Y @B32uT6W`*B,`* u.>B.P_u.8_t.9_R@g JP艁GG }ay}rangac\aXQaM}FaB;a	70a,%a
!}aaa
 f`(* >(6.> ,6f.R6D.VffXmAmZ Пf ?buf.R>r>^)1Q1QqZۀ 3Pqr#svPsȪszPss~Ps!f%#6 .,.>>66@lsv6. vffaJ fpO!f%$uc0R1f{-&f 0 &yP
_.QXPmqfZ$zVs`*Bsf%'f
 y+`*^	.Q~w

z.|t}u..G`,s >s^ tbDB8S+.&Z5JxU .Gu
`*e?~u)`*EKp2!)`*B	) .c!h"T~
fWz.6V.6Iwf@mR|Kf }6Of3ffS'ArMotA6 fuD>Q
6ˇd 01Tt	6݇U  } 4tY=o.V0vg&;pRsZ^pu VVW>ˆ蓭b& _^VVWr>r6> _^V'ɯ s0fSfVfW)>64rt 3ҋ f|ݠG 
t O
?tw= ?  68)< 	s0B>uf_fVfY83נA :r<+u<-uPR+ZVR-aQȵ$0<:|uYX@Ju @ l>@> U@vu@V
lrS- w|Hro1PO
8rK}?rDer)ߋW.9u$% r$QqSVWލwP <r:D9Gu-D
9G
0u"ZLqt.Ws
F_^VRVր? t u
?3^VaWU3и<r<
t
<
t	:tuEF]_rs r r
ê<fw<ar,W<Fw<A7ÿ<9w<00 L0QѠf33w-.-6/mё)9/'"p2Yc0.0Ӳ>ޢm
OֺxӋ6t>|.s<u= Q> <u 鿅 <u0hro).> PmPmDQBҠ w?>dۨ؀ `*s!?^03B>B蛓FڤSQTpg&CX裤W )}q鷨J L6Mr, 馜fNfOf_Ag&?2fffXPt á#?TBPme2f.;ew-  r%Q1ਐ tfGɷJ>8 r,vf2BrmAVXTT)@ r ,fffFgf#K .䱃@{S2T~3?aM`t
`,ߠ ,ffV&vPmx@Qv"  u߸ $t.$撱 Q fU.E.9߂..F.:wGP;A5ŋf , tR5 uuufPm=R#f]Ѩ9@Po:w;5.=[ ! f4R RQ 
	`_Z Z\$S
Ｐf  X Z0Sf3[ffÊ$  ffff 1%0$`%߻Ӧ R&%   $ff8*** Please restart the system manually.
 xL.<t$
@..
$!/t/_$0!/t/?DH2撍6mR3PI8>Ko wQѠ ػ7f?{tuCkP O ntJfq<4T WFOPAtOPX >~ XTY*\~YfPQU T9GPF >J~us
, 6=A> > POXpV]Uf ]ayyŀ8Gbؾff&f&J!KG>̀ fG`GQa ATIIPJ6LMfWf>҈!_f!QQQQff4ss4ttf~}VP6ҧfasPVAVrAVؠ0h"3PhXX[ÕXڥ/<\$<sYr.r@O C]CAp?6t_r@Xπ`?`UAIJfQBEn}S  gf +u}
' u d[P}p&r/ c@CXra Jg=)xxPe14l 8lmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo  /Oo	 /
Oo
 /Oo /Oo !"$ /%O&o'()*+- /.O/o012346 /7O8o9:;<=? /@OAoBCDEFH /IOJoKLMNOQ /ROSoTUVWXZ /[O\o]^_`ac /dOeofghijl /mOnoopqrsu /vOwoxyz{|~ /Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&') /*O+o,-./02 /3O4o56789; /<O=o>?@ABD /EOFoGHIJKM /NOOoPQRSTV /WOXoYZ[\]_ /`Oaobcdefh /iOjoklmnoq /rOsotuvwxz /{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo /Oo  ?_ 
?_
?_??? fRfVfWfU..f.6. + f. 's 6э>us.a +C..+.> uj.^q:
qf.f=   sIqOq r.q
 .+"s q6 ptP#+#`$+pĐ Pf. "f.f]f_f^fZPSQ 3<dr<gw,d P$<&Xu
 $	,<w .	.p)N.Y[XQ<uF$<t
.? t#;OtYQRWSVw*t^w.;t
|u. >
эf3EG..fEfGpЈE
G
.f$ r-/t8  99- 9.Ѐ tZ8=9? :@;P:?XthP[G_ZYrepe  `>n>VW>S; t6Ss?1@CsQ?r$?s6A-`B+ 15GCЃ} ;, 5C7D s# qB`C	ArvBr_^ rE<PfPǋfEEHE
EEfXSQVW3?u-6qCt6#L6QLuC_^Y[VWf6Ї
 @HF`CÆQfQfPf$FfXsRSÒ3 Eg	7WTkUfQIffD$70W?uUcT+9% si}
uFoDdW+pWZE_}t8YuS uN~T-fD7  !]6\0u]07 ^ ui!]Yus]{_ KT߀u#8
fɁYrgV1gV d/u8	1cc߾17,R0JfXf 2TQ߀Ys0cYsVctfY+5 /j7 _"kk[gkq8Or߲Wm_lieoaȋTq8s"ns\fEVVcwD1SfönmQokETf+r8sx0W7T*WTߥ:dν fD@@'4'f irfe  Y2pV~Q^ t@lsF蓟N+r]Y
~]ym3w@lD tsM| /u
!9z897<a\!5|6^<uhs
`\ f!7s1kq8sk8!~Nnj	xj95bP:5i3wj+fTaB{s
qrD1pJg-kd
*fc.`vX~Q!}B'?t@R{f%{s@l"⋰Oj嘭@lq8wAsW-q+@lw~oscT8p\5?VF`^k5`K95FF<^jdR{w!mnlAWjPХ8VYpsVr4s7Ar\BnХ蚐f!E~F^Ë tttk%:5n7sdu1n`o¬p qrsTT%=upWqh-Vf$&?	!(=(tLQ	
v+`=urn2$n0yrSFtQhٻ0<t`1 (ұrn@k@l+1| 7u Øn3|}3k,Cm|`o1iVq$fedwOcDjSFjd8kn45>2cT0SG iAy!|sdgw@?G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsicdi0phrTeFbgOCf_2J0#escsssdsfsgsfWP DVaX
<P ݰ: tͫA:ArAⳔ`D覔A♔ A4  + *2+*4+*8+f5k-JYsMɟȁpuJføtsPørc@d
t?oslc#fE~{tЎ1 `J!%߰[B
۽@lK!߰]rBW!p2P!Fb_x+si dpp1B  }߃߉ߏߘߛߞ_ ucQ s0cE
WV6g4Fg^_rg tUY	P!!s
P! !M
fwo/rd d" q" " tbyte %*/r ptr c #WV.3t"h6@:hs6J,6K&Ys#[O0VBOO_f^f >eS fXPXP
$0<9~F[!J!JhD
 s봰+ !J$ CqYsp8e+s߰-шsf    Pr Pr  ޳ ;  r_   . `rx   $pr ' ]3( ,T/ 0 4T7 ^8 <!T? 	!x @ 
 H $P$X$x ` Wa 'b  f@r c &@r h ( i +}0 l 0!1(m 5,n 9,o ?,p Dwג+q G.wr K.s N.wt R.u U.wv Y.w ].wx `.y c.wz g.{ j.w| n.} q.w~ u. y.8&8ǀ:0:;66;: 6;=(:06;?8:  |}U.  B  ! PC: C  Q)8vے+ !F  r !   H ' ݪK H ݴ.# PCٵPCנN  Urw O AT O O O H H H H n! PCxLM?8 q)pXXXnX  X([8[  ROp]I E  ^8PC.ȿ /1( ]ːaI #rcb+{ 'E^ ,KW 1A^ :УX:SYfZfZfc[f\f\ 7eݒ+ ;Uk ?C^& D. Kn Qn Vn  [w ^p IIN  bDrrIr4pVp`quu WfE^ kE^w qE^ vE^w zC^8Ab`py~yvz vz(+z0vz8sz $E^ E^ E^ E^ E^ y`$z|8fܓ b}8(bՄ03FzM  ׶ 3`,?	 0Nщ ^1   A^1w 'č	 %e@+ T1Rҋ uҋ  ֥ ڹ*1 ݕ ᕔ 啔@w 2A 8UwB ?UC EUwD LUE RUwF YUG `UwH fUI lUwJ sUK yUwL UM UwN UO T8 o8(V0V8T@P鵍 e  Ee.@r1`/䧂0䧃0䧄$p1䧅 2䧆2I3䧈04䧉4䧊5䧋@6䧌$6䧍7䧎P8䧹 93 e1 e2 e0 d8 9ҡ {  w 	 w  w  $w * /w 5 :w @ F    Or!$  e K O8SXw ]ƻ0b g mkp u z (&g!`ᗶ䜶塶覶髶m빶쿶ƶͶҶض޶0(m
ܛm&.5߻:?ۻGLmRX^eGrklRFpsutz q8 ~݅(60684nuРq0(Tg 50vf83g(lRF8ۻ8u% (m08$fcuu8 D8$0 0V   
0{ 00{V8 dҰ8 f {s  txMUadd push pop or adc sbb and daa sub
s x
 cmps inc decb}aa bou
arpl imupnsb out q jo j%n0c@z@be ja j @jp@`l jglg test xchg mov lea ncbw cwd call waitbff KsaPl@s!s stos lKodcqbbbRb rolr rc~ cr shla@etp@enteft!o iavemd xlaoop@!#s#xza j@lwockpne%_e hlt ct ne div i'clP
tUc (i i (d dbx1zx lUf@g@sl0)hrd bsf+r btp,s\p,a,c i,x,sep!.`.p..zR./.e-@.pR.1 eQt 12b0gr*Ul*di14l14_msw l -s!4Usq4s4s5s -wver6w ffchs fab08tfx`"fld119l289e19pi9g29n~";z f2xmp9yl2x fptkan<a<re1<xtrac8sB1f>=S<pp9sqr8s0frnd!f@@|7Aucomp7en:dis:c[le<inf1 9B )fP@1esc19env19cƑ7stFGaGfreB8BB0ArG"G 5fbEiEb>>1EP@@CG12E>MfiBIaO"LaM'AL wbinv+wa@oQ`RARSzSRSR RUQRlQ DVTg!X8@puid rdmP,rdp&rdtFrsm ud2 wr!Zx1 .\ f\ y}\z`&^w{&^|&^}\&^%^.s\x\3%^3%^\}t_.\G&^%^%^{.g%^5a&^&^a&^&^,}(%^-)*\.V`)P}S\ \%p[&^X&^}a4s%^$%^<%^v%^ý\t%^5s&cxΤ\|\5syw&y'5a{t%^$%^I~{a5a5sQz&^5a|\fe{$\
{
迵z%\׋c~}<r%^<m t%^"y$v7%^&芵z){%^+t0%^-e{05s35s6wQe{9uf{;me{>5sAjDt+%^F&__JdL{%^Nt!%^P5sS<e{Vu%^Xe{[%^]` z2scHf5sie{lne{q{}vu
%^xL{d}W{޵e{w#\P&^߉O\e&ϐ\ۺ\WuuY&^\ur5s'nڗt杪~唱#tN%^8etH%^&~  6 f3 t3Vv^
j
a
SQW.8
F  1 [Fn6F?f.a
>0QHY.&f.>R[  t8svJ $GG _Y[PQ.>t7xFYX8eF N!SDr [5߰Hz QMY5 FJ2@ M)FKEQ̘R$ <t<t<uE* mfSùE' ; XEfPQfRf3 3JFfZYfXSt[_A B C D mP Q R ۂS ABCDóPO݀߁R߂S߃c?[ SpWP.@ơ.X.@ʽ u<u	L <r<w,@. <  .>
  <  <;u.À
s.p <0r$<9w ,0 P.p`ꏿ
 Y.l<?uf.[u
f.&^aR<[`Ow?uu1R8f;t'uG⠰ o._p	   hثv ? hNȆg
Ȏ`Ѝҋh{ i
  ௎ R0 0o  ys  +E     DSDTco  SHP nc8000 @  MSFT@[0\._PR_CPU0  _CST {PSB_C ݤ@12C

 A y 

  
A2A


\@32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Q4ph`p
 gpid#d
 {`
apRa bsbgcpcgz`
`vdgDQ5phg	gi
 A6gA7phpiQp
 fp
`'fsg`f b7f cuf!bc``A8A9E
Microsoft Windows ME: Millennium Editions NT C@AF
p\_OS_`pQga.agԩ#`9 
bra
oua#
 6#
 )%[Q$I`*
E"2 pK
pA8_INI QAH@B
fpig
f
 pipP0g0hprgfata
apa`"%ahha `a u1
 bobiib3ub`J\[K
@C_HIDAJ	_CRSD)
&	p 2

 8@ @ Q98
~!8
 C010;mp;1t12!<w;p;3;p;4pyv<5
0)14t=4>D5< ,16pBA7A8Bp;9 rQBa[p;A   
,[Dp;B 0p;C a;8 bDD?7[
GE׀bDF?9@[J6I2m0`;21,22'AJ30J4'25L6E00L7jL8L9#2Aa;5>2BNCNDzNENF A6`;30@31P133P4P5 S@"PrP7P8P9  @63A 6!C3BCB94D3C0)3B
[$UDPEPF@4P4Q42M,43
P!`
p2Aa}aiapaY Yib{abZ[W46
_ADR
 [W5^ U aD46g
QV#460)470p/4747E"6W8& @cd}AG49 [#WAK#4B(`p`Qgp`b,47ee` ap U dpyt?cCdcQg
{a
09b0d4CQgp,b_btd
lDluBhP42dcrd48` dza
aP1m@(`ofufif a(du7`['f
.AfWEL

 
2
B GtA  Uvv
!uiRv!94
 	x u5
x "u?y 'cCWD}g['4A B@50pibpkdrd
edi~sd hb rb rb

bhb1@2j@3Cj0)51D2 @5 =51crc'5}3bNu4fw"kar$/4Eab@2b2B42sq3bu~14atb
b`c4aBh`bac`5p
 j55rBA7 ;4E
P51#51>P0h52Y12Z"aa'`ᇀ_S3D
4D
[6_ pW

[HN7_R`58
`?
[I	fs5ACF5!W5qW5W60`R 1 @} Ї62 H#63    ,64!P65@A6p67 '689 E6Ak 0C6N6CDEFaD70

I#700)71H72 
<[=ޑ  @3>Ѡ74 AL7627 } K78 9>7AB`
[+tBC@7D9]7EDF  #808m181'W823Ф1p/84SPA85S,8687ФQV!B`8U8s8Q88CGQD[#\_GL_(bp
`{ap`0_!
dv`J`!8A8B{hp0jp
ap
HѲbӵ09Wӵ|04a0|1,8Cbq[}д"ya
c}cbaa6`E
/  hdvdwd
`y
`ayih61c{ca !F (80@@90}xp 91hi09P!`y`jaB,925``wh
0)c93!0h650ayjabypcе66c d{}d66M#94EigR4
bMbC{bpwc
eqfeyrep 
 dd)idkh
 y
cèe0)6Π@92c!ahY`}zbuc/ 0P0UжaO`ij}Q`{JQ5
^)6F5#E&#Cq
 i
 Ap96Y0ipph6ARG1܁^#EG$8FpC'%;Pbj
[IFd9@
j999A%BP9DQE CG9F
sa`!A`Cܠ
P	09z{` ka0 
bw
t
	rab@ CRZ@1@B00{bARv"@A0
pI6'Bp/WA1
r2iPǻHе9C`Ea{@p ` 
p{z鞁 wi? 9A'{a` @bA0b !|C2	?A`pCw
h ͠k }І1@C 1
ccF0CA3
7l
EA4,A56p
e {ky
0zеA?4  }2sejj
1	=5{`1|
x1	6Pp #04b}e_
e/$p !04	
We 
04
oe}`p2@dAy~4{k
	d`}AB
 9BΤ yqBpo?d`P(u9d 0h99A3Ae-@=A7 PFb1dyce@
qq,A9hif"f
_j
1	8P
Eb2dBW	!b'p,	D PMU6Cd!HbIz Bb(D$p 
Abۡ	#@bC\0zyacqC ϫcD )B)`j)DE da[bR_AA_aqWAB_R`AC

[>AUA1AE-_PSWQYYYAD1E x120E[( YF^`B041^
-B2./1P?2_3453_:7I?8_9:;<=CЇB0^_17A`DF3I_
3I@QI7BI8^wHpB9	q6A	
#  Oy OB`ih``jր `BCO BDI	PP	Ap
`	`ХBEdS`	TrBF	=0C0C0!Wγݡ	!W`֤`[OЇC5c^_UID
`_STA RD^^.љ!o_DIS1BEH[I[_SRSBFhI[ҏRY]X$6YaZ[A[c Yc/^c_!X ?Y	bb[Bdkik?f@kgqXGYcj[ClsysOnsoXPKYhr[D /t{{_v{w1X$ Yiz[E?| o~XY	j߂[FO@ћXMYk[60_"[C9U[78 12[WACB
RC< WD [#"ЁW5ɟ6uZ[VCABEIv8Ǡ5L0W45[D0WCHНDWa7D1
,7PD10D2 3
LE3Ѩ4 :_REG38ڠD2` S~D0Qѫ0WDGS3Dk
`45P5((D6
k h32S`1T%P7±3PVKP8
@34 {	h{`h@(@34pix.a1$Ӷ \._SB_P9t
!._DOS0
`sa[^PAb"ha[DC.0
_DC_D G37fSSWhCc۽ҽҽEtDd&ʾtEʾbhAFBpD6	s5 Fp
/{\/Ӹ4q85
	DFQF D  7  pKAp쒓hip79 hp  ^\\/fC9zD ;tEEGPG57,C0E0
 95hjޡ
Q6hi` 8El`CpE15pEh"80"7EFEppD7PT E2
^/Ш5E0pklG3 85`Q  a[& E@E aaC AA[O5	6+v86`5_ON_= 86_3_OFF }?" _PR0WE6W57[Gǉ	_GP_E
	
 Z0
Gb bGf fy E8QE9EA B1C

ЫED@EE`
u#Ӫpii0A
ШEBa7EF}[B1 @@	pF0o  WF1 T 2A34AU5A6A78A9 A FB{ FC @{FDE  F10  12345z67  u8S9SA@ )Bp  Dq
-10F10a1a2a3a4a5Za617819P11A_INI 
\11B
>аK@pCaDaE
aFr2w0
1
]21234Ip25B6
Unknown 
NiMH 
LiIon N7`>-{ `E8 EAЫF7`E8P
TDV`ED7(v9k@pHؠ!(}ha{a
!}Z1i1!`1(F(F<%aV128	`WVBpB,aq%73"9	+0p
a	{`"I'A
[)h`pa4`
csc
  dziTr`a[)a61bsdb1/"2P23@5cocHB	 Rhg. *29g
1E`{`egйCDhH%Ap搻FBQ`/`N<Eh `>adFF> w`

axra
2 
dcbpb>nA<0B`aCCa0`azBI17Eg-1E% [IF
8+u9p
 I<9	ip
:F/;=9X=C1caC2>0<R@`	P ۾
{`z X{``UEp84>P  9T2c cpP e_eWeXxcpe'cpciXEFFE+231 (_Q03TMTd]4/^a;dp
ap
ay_aQ05TZ_`]2e3['e^eTZ3_0`Lq`O6 D.
ag134
agPR_CPU0sjg1_
fg2 ld7df*gk%]8o
Mh
nh  </`.$i
i6sjj7
 <G#]9s `i
u]A i8*xBhy9xEfy ~_Q10 3-tM|qJqryswtQvv1wtE
{p,hy7izhy6i?ar@̕$/a]`a`;V}a'310SaC [cP
Q3A
Nn`13C[Ov'3B! nD  nE0 A40244243 L
В44V146784@14A!1=4`14DҔ4FQ50@
[ %1552A5`154V5525PG5QmqUяʠ8я54A159a7R-`)B/ `B0PBp a
 y5a!J:A5B~-㟡bcgBb9cN§tAҨ8c3'Dbb0ҨFcQ<5BVya
s?
 d
b
 8bdpds`@c
 c
8cq8 .5BO 5Ca7@2`kaa
a
vaQc aׂlbb@b
vbQcbQ-4p4B;pb1Dt 45bA¸89b04AbD#!aT7zjbC¸F!E=DsAr2r bb	aq-#,bbG5E.57F30c3Eڡ01 `EFѳE(3DAE(40Ƣ1r6C160
{C0`{ 23 iaw`1`59h0
`0<A  161	pҲZA 1TaR9`a c`-Gabc`-$~K'62 p^^3cIi64Lb
65

G?y  i1673qD5A@X`-6Q67TRB6`7[E`69e _DDN
COM16B6
30" @68y S `6Bڒ.6AΡP(P +_DIS 5}22 ,6Ar rF_SRSً0h
AC@2уCb`q-6A@
!!0D

 ׀BD` tdRqظ[00D   
aE|_ON_qFpq
_OFF1`j0aD[WH:0E`40F_ADR0_FDI" 
O


pq%pq


e


70cpC
GG"O@ *
4 
`P^0" 710.T	-7A77717q778>!9B	 K7AppBJ#r١`Ri7C09(74)G6>2C180#2A *#@"20*-8d CS!Br'!"X#"[3^ y`?q*53D!ARMVb@7Ѧ c-0E3gc0µg0gVME~A]81
`ʪ1`!1!2p^
6F` tB82`81[L$3MףCC
_VG 0" *
n89k8@KI
Bb#?^ࠚ1pDA8 *?];sP?L!"
#OX%'!(84myQ?*Y+84[C 85 L6pP`[ 17

86 \<237г47!588%H
1 Gxx;xx"92ax9xx5b:7@d&b:a ecfodfa fckhk8`O %V548AN @Apa<wO8GeO *I}F%89K!Lc~ L`KNoWp4_OP`Q`px 019Ǽp1"% P STM1Bmr*,&q`!YB)~8C p\/~q44C057 Ձ(ԁ`'{q  N7C[#\_GL_{~2
a['$hGPE LDb}ab'
Q}`[% LFRS H"  yPs`+@ @ "|[5tU4 
`8`G    *{"C19s4ba a -@1U4
Gp p Gr r@" &2Uh` ` Gd d "aI[I95
" y94
95a94BC95&sqO.	  [+@6Rw ;  B [N@7S$	98
?
[b@}9A[q @BC[D4
G B  `]]9B
a9BO`- [#p
MUq! q['F	069   ޒ	9F
[Q*A0 IN-IcA0A!mtA2A2$ЀA5# C0A S3D
@S	40ґB5@NC097/[O/@5e@Ώ61+s7JE
_GTMc pa1.`2@8PBA9PA09"+A>bAA{݀Sp	9
A8BPLAC`ABsZAxACq0 4MhthhhݠFi  0-
w@@} a:`谇` bwb
bw`cib ac rbSPrcu`3%ޑab7EcAoEbcaؠ:FF-w!{H0qD9I
sؒj=jFj‰y0_[5,`Fk B A6Q Bap,
_'PS0b23o0ಂK0c̠
02loڏۯ݀`NgN#
 AI
E3
В4M
 _/$
D,_ B2X`N B9 0`[Pi!\.C n	
O# p$2%C3O&C4'C5(C6*C7O+Cq8,0OnT O`B3G
V0QV0V0`Y
S0204QGCYu0$
 6(6A'6-614P85&5$4)p//0P0=6G°$51+p//:S0@QAS0G
56QA+6 1BEC8C7C8P6
69C)2E@	Fo
0LLrd
d
Primary 
10!O 
LIon 
Hewlett-Packard ELMTravelNPKD@UKCV sL`2B	Ew2Bh`/`O%
 _Q
]
 
2EYh.вA!YFqY̛1^aB4aYZFha`C^Dh0AC13
_UID ó?bZ9
_BI1YhSTbhCL\q[Gr~38e6³Q)q/bg hg&iidЮ
ACPIS3i>  Rm3c7o`lŏ21 prw396[:d86
*_LIDrl_85 $
	/15?@SXNEja50dB60
0700҂kPk`!h`piaFˠ?pB0w  a{`
`3S }aS1a_p`k
PaP Q8VP BB0_ BKB5P`?jB_9#h

a V`#Ҍ2 `Ҍ^2`#xƕp}
yjZ    >1B1h)h`9}`ribPpbasabcpcau`a}pBArw@ i`zC03E
Ca42bb`a
b
K
.B\j0C.DE0EifBFKC0C1	l@p
`
 ar
`' a 2@`@C3C1eq1pae[$wre
 
q4A4U1EpFAILP#Xuq3UCEuSH 039a
& 
pC0@^5	b 0bP
`hUĨA66OadbpJ/7qp0!q `aPASS@$BD4OjC6 aPp2 `@37ap	ށ3 a39Í;d2耊aPbSbap? b ub$xk WDGL
xRU4<SMrJ/NAA T-MP2T덶AB ;9Kp$[?AC+|Nr2J)lBC 4_c,E=DAD!f )AE CWQAA*#@Ĩ{9 &r RpBBp
K\0B
FfghiGWSAB
p BBipi2sO0C
COMPAQ|PC CP SNtReader|GEMPLUS|GPR400|PSCR|R| %WQ@XtR!2
aoBWSBCDi0IPoa?7300!$a(` 1w033Pa_45$F
~
WMAD_Eij 0=Z30ENFOM  @:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=h4/~:zH8P̴9ˡc@1b90Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
P#C
0pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB  G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
FH\I@Q`PC ?;L <͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9qÐ
Lyr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$h0" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[`C8 Jѭ[#pl[#\_GL_/yh
 6݀pjbk ! A\9hA l['q['p0x09

[Ӂ"v0ABoC C1D6pCphL1wuC~Qx9xBy/`xAx{h
aAp{zhh@#}h{	`x8~~7 y[A.1DE־u`xoFE0$1Q2$3!`E4 ]`5 rC  vE6`E5
[ Ç7@(AE89 βvEwEAqB@`EAUy!
	`rh``vFECєE7QcPdݢJaߒc
``r=d b}y@bayТa0/apacQ  eraye
	 evepe~E0c ucЏdcM
`DCcpc bpbgC	bdp  apbe)ec`e ffg
fape`pfafgvdueA`bE0G` g`QaRđb pgэ8aggwagdM:`Ex04Ayp0p `cW`pb1V"2`ayp5jРPCPB DfhcE0h H
bh@a0c `rDcad\!"
eC1-adOft`f¢uᄟaduc2ftd`g `tbuP7ПF pE40qыP9эDEauE40
_INIFBpp50pibhbC1F0pF0rb
jT1Dj@}F1X2C22RbwF3 w
arC00Dabpb!>baᵿ`babuaa򻂧  `bua +_wCRS0D`sr1F3``_STA t
`}``\/E
	p   yЀF%a1{F4́CrF51
.GGހ   @  e R Ɛy F5[D5F7́63F
bG0 G$ $ GN N P P Gh h Gt tӐ Ҥ pG@PƠ Cy r^^.C0E62\_S0_P٥3b4bԀ5bp H\_PTSphe21Ch
 \/*0EqC

>h
ސ28
 q찎%AFB4L \_WAK8sAA0EAq qFoC00u'PeD9y)TZpF8~TZ1_
6]2 t0A
1b39g
pO7bγ
DacbccKc4	9B1
 00AB}B2 ¼4rE
 {N\9G,<

qn
J
bOoq	bƫ`AFB
CD
E
F200`!2NA203w045"!6o3233
oA07
ѕϠC{
/1CLDiK!8
r p
?p
C>E`2Di?!rR}H	09
h p
~`pi`?9`
~'yr'=i!&`o+RB0A``phaOhPiP Ѩ00Bi ` a6ކ7
 i0,pKDF8392p33p"/
  	70u32t
axa

`bP08D
X
bt*9:
o=; 
>;
,@XO
#
P?+'~C.I0C	Op
d	d`?BYd3p{V2@ ~b{b
 t bbwb

ara<MpLa?V1No9p?Qr)aM/3h MM/4॒/@V` $U"V6y
ӟbM{P0h  a`?<`/%0R\ \G0D`h63_
RYb 33,39@]
08h `t`<`x`LfQ3f
p{tfJ}fa 1bbtb<cbb<= Lb&xbAJ`3cb+dbI	iGep
d
kdH;d>;efGBipLvKw	X^Q1	rJ1aR0a[6]E 2ä"
_ON_%8wFUF%9 SvFv
wD{%y
Rv10v
w~%y
S}1v
wD%y
~[3}2"& _PR0vW["}3݅FWd10꣇5݅h1[{H_AL21 AL2ܳPAL35__AC0RwAU 1FC2FĀ3FPSVFSLPR_CPU0G.16P165
Q1`(rJ8Ƞqp]p
p
Q$EpD_TSP
d C1TC2ACRT9TMPxau[Gq}7Ca18ڗ",ݠ*֢3p٠Q?TNF\_GPEI M
_L00 HI0{P[7{` ٠,{`
I;c??r/;
@34sB\56dC sDI_L p35``G35. '@{V0
r	45C0CF '5EϴI"[0Qo/aIꗶQbB0 @aϵa=Сb MR6i_g[K7 {63?`}` @3zǃp6X_Ŕ8r.KCp@ p?TbG	)Dt8Nݠ:}85  f2 w$19	@,PE
{7is6iSSDT%COMPAQCPQGysr   MSFTA?}A~	
ٲ@ay  S fBwd;_PD?C{h0Ё1CPCT y
q`w1B A	_PPC ,  SSu Np0Sp!O 〟o O?	
O/ o/oO /O !"O#/&% o('**/+O,o-// /214A5  p  
    	 _BMp "v }(   @    #)?_! ̮ _ 	

?_2ܾPV̾ $q&"@κ`31$
@π/H@l"!  "A$o%&a'1**?+Y,2`%*./r,`P%,23,Qp'O.o78$22@S;:;? O>o?@g:"DCBC EeHA22GGF H=06O@My:M9IQ)Ρ)4AIEsG06)$ܢ$ U^HPIAQV$W)T
WQKFG dX ?[XO"3Kv`X2R^"@I$Q%%U5PGabPIXV`6q$RFhX?i2VjfXRT$ mmVPn$qRXlqkT_ stuvx?y_z{h|}~RVXercWP\0 ZVtPI\~N`dZqvPIZ~LbpZZx0 X3
zRV~Jd҂ G1d$qZ!rEHh ċhV|ċl|R!qHj!`	!qi pE $ Qx$lppogj!2lfYrgCg)2 UCCԊAC`0 ,^20 4`0A`A@YZPIV J$3>ࣔX #(0ঔV󠱂%2TR2͊a6 !R0 A`6@֬AagGP2.0aCNPI`6R" jq0PR rLPI2״02a@ִ2421J%44@͇H0 @@ߠ7ܨ@r@ΧFPI8224w8AA܄ѼGDPI:36(Ї@ϊ<V4͇BPI>ԊA ɷ`ɲ*Q`R@)@	8C@0  Ї`B2JUB(&3%G>PI%D0(RIj D*3K ԗLչ,Zj HĈqViF%
̀PKg<PIÛ!
0,1P`*ٱV*ᰛF ݣ!U)᠖ZV':PIR&0 ߂aKe(j@y䱀j@QB[@ߑi@rVi$
ԒC8PI (]FQQQ 5jA !/"uMo``~(۱ Rq?O A"2l% (o
+  -0 O3oO6/9" > @L4<AD OGUO,NJ]=R!/M?A kĨ#S7 [S)\!O=
\$.@ !`B`:`} zd/W`\Z	 1Qj[0Qi]`[_Qot#pbQons߄tPuau!ځtA${am@pqB|Rvqga$&Q`"Oqg[rz݇ ЙjsqV=2t!Fԅe;qkRVqnqT:a]R _qkP]V !Z{QEPNSaLeB	LVEJQ (%:Hݻ,@ x."C@Hx%&D)RBR[!F<!b@˯T8 %TV*G q!XٲQFZ@;0л\@6.л^Up,л*(Br`a&P
dтۀhf ~!hD߀yv
l2xbbr>@pA} edwvSN/:S1F~]P  HIhQo4# QҕHʱf|p@ذS8ЬJq6@1س cz0QݳcLE#x3j1֓ܣUraA2q`bKAŀ`ȠQ4@At"дƠ afprR?_쀿?_|        @	 _BM "| ( n s    b#        d d> F ."    f  f  `/zj
/Oo
#(4UfeC0$g
S, ޑX_2; 2$_"w wOo2c~5xR@2}ch_UZ?p?d2&i% *Y !"Y"S?2R"_jWz"%"k? c& %k`&(_Os "i%* "
*U?) !j"_@"R,*-[++`&Z.{`&/_d0)Jb&? &2J2B1O2U0`&sdbQ14`& K2$e6"4468{0q/
"#4 4Q2_8oh9W	y8o Q2;2J-) &S?{9Rq/$1CJq/AD &;B)?C9E`&EH+2A; &:B2C3&eGu &>Hq/Uo$FB2b/A!"TKQ& &;H%D4@1SNJ(`K"%yot2=HK )B<QjN{(SUb/B12@1]H{ ?)Y`1=)KKI4"2/A@"A%TE[")FEBFQbIp$y ?$:IO]@"QF$@11^p0$E"9E`^$<(](X(T(qI&5S9J7dJX!5A#=Lf((HqI+W@RB.=U)mHq-]ks0SWS@1m8Kq/Zgo.d0 ar8DnWoRKOfd0Bo sodWQB"$0${xd9sziEt"+ 1a{D1&ra2&}(s<sz[O&)pJ&dh|8b91ak'}BbB~0(p6$xSqc=8C;FTqn2+B&|Z]$%Uzp<H`9K?g"59Ws<Y@|U+⁗QF_*w{O["s0I!D]]6-3JqQO _F~SpZ⏛]N-dhCє]s9"1wX]qI&)-FI1SnVo`'Y%`b=]d-Q&63cSS&$R]2)_$7)O)(3<1O$k`E-7HN(RAĬ2Üb/4 D22Q&_(I"631=oqI8SAD79(83_9$_SeWB2q|VOq/XBQ1t3C);"
q9""5Q21,Q&QoDq1$+`&m A-H:UtXk"-DEqJHS@"B9a?BrĞ(H")OBSAT 1EI'B_KY HS& 8o-2@")c|%>@"W &j &4@"-aQB8zq!s@ RzT1U !\RBxOhPB V`@%*ۺE"%!AoӍUHOPc i$:U_#	I VG"0% B{tb "E)"0B"O@PcB7" &3 7Π SE`7Q oӾzEƁE :"`$ !p"@6.RF@E4R@QmE8gw Ph%/Oo@	 /f B

 
 f5
n
     Q   `	 _BM " ( _ }    .#3  \   G? uf  ! ~^ 	
H 
 0
 "02 
2}#=-# 
-W " " 0

!
K
ݠ P

 @P  
  iD0
0
 `0
A#BT$]P0!
0
Oa&% I%4&'%T&#&%(s)*A#N&*:+0
./ :(-!!//
+A$4D.2345'789	 0p"AB0#_<=>x+2,:tCA02AC 6,?'"A#@('	@_G5C(?/"+6O"c$E)\BOOO?p"p"@!2D* .2S (#S@T AS!S#S!SA$N7 , 2IaTz Wt-Xp%O4YTTXp%NZTJ6.\O@1YV!2AqW ?_`_^\PaZ"abc^2fd.a%@^p!Nfd*+[!!Nfd(+jRA7fd&h N
ZPDSfd$"gqlUNlA1Pg#OpMc"
#Oe"pB$OZEc#fd O(PgB$k4s't0sAOAuK'wwh&ue'xOv@p"qnz'z ,
k@V{NNpl)'z}J. pM@O|}}#.a~pn')k)AO .sZ.d."0
pD'Dtc")pn!.@6`WP,@1|]\TsJ f&AOFOT*OO!zJG -r)ra}!WP@0!c, 'Os(.#俘6"aJrAONr2t'@02!A.ARR"#."r-e@c$AOR Iw#c,A$!OPk(a$@pE,>қa$AO-9p",  v"qRYe,( AOAVeA}r g#A)!!ca"pn ,z1)Ғ9)rx KJA{}p6A1 rÁ#p0Ų !|B Tr{ ,KA$x$'ko m"al @TuH!|.S0$kNqMrSss
rpBPi ATWrne"  #02OrlBg$"Sp$,hS!SNDRTf"p! *rnUa0m67٭4+AJ8tBRdUX^XU ^U1!       	 _BM " ( k }    P  #???   |E L  ʼ  jD 3  ! x	jr
x
F
 
 ߲
> 
̲
E


ސT0aRUݰPr 
 6MCutR
E̐REѱT!RUtP
ur SM@%0#W,p0U>P BPI%ݐ:A( )ϐ(&%1(#/--
 <
ABa
R59-4A-,
r )|6+:8
6Rp8 "<0-<R86x=i> -
#4DC5/A2,c=A-pJ>s<BTDpCa+A9A8/>- $DQa!8!aAr2 D2B
M$DE>

 )AC<%O AC:pO$"P8$O&N6
 )(DBR PS*D>4S,D?2S./D_0S$0VO.ST0NpWT42DN,S44@V*S8D(SZEZ"S:D1&S<D/$g\P"S> Y]TE@@V S0_P BSS`D@Vzb`ACUTNWU4PC4pb30C3Qb`C
CO*pbPbO
TdabAfAfE \
GDAdrbBSpePi%te_}?4/$pb/PbakPk
h/#dcb0C?0CNPemnAj4jajkimhP#d!k`gmBcgneonpCgN
`Utq!oN0Ci3
4recneeeUT)Pd#ddoBrgPiqeB4xwi{bp43aBtzTrfRlg!Q
SNanN
2fu/Pe_rgh+? 
a!gAe@dj)anup{]r4BPCq"$!f"Cq!CEPiACW3Cu10Q4h$Z M4pk4QBjRUR_
 JLP qFpU?яBJP	 MSH hqGUS34\ . ($U_k (
fwxGw@?HqАyJԏL(яJyPM
vfw:mT opO4pOPwoy0oTyaњ.xPG,PSП
ph*П( tzП6Px$tqyPocКSaxoW1  Sҟ
갟ogPiЭopx
oA#SПvp𚁯ihpgfRh2Яy\pvrpyfMnҶ!v u_ПroAP0rھPbrFf]ПPv
ihПa ]JgPПoȘ2ѽК P\aAxrp`Кoi[21p@ZaGiѶP9wPPfҟay6YyУfvRvWipAhpfpfPvVph2ԗd@oXКҟZUPagPԡaT1o$pRpO@*TՖRROi1QCOѭPPOMi@J%NvNJhPͯDeBxH
АgވwL/
Ӕ   * y     ]؎e Ћv\e+3f  q L!$F10fPfSfQfRfVfWfUCES>`  fB  f~a|`   tf|`  t M dU@d _@t0f@d@tQ@	ð	@  t
@@s f~afxc A3u 6Fb< tf3
 a>SFbPA  a[ d>aPP;xc  xocf33"
	A
t
   Q@@ Q@ftf2Qߨ t߸u30A_f^fZfYf[fXfV 3B>/d t
	U&dfXf^PVW 3W B\_t
r
>a_^!P  f&T f. 1ff&T !(.ft)@,Ot..<xu<\ޯ۾اбκDD(|1280346/7O80  `0~:"!A>v< < <'Y >; @@?|>RAq;'?$@:	I!!:}0t=!A;;><<dC(H)))**LLH$$~BK~B@y>H$$$0M$C  >""ZFF:d;NP#<6P` ::F>hx'P2N'ypL<<"P:2
/
	?"WFgJ> ?8 0 p	

=c=V$$DXJ!^sGIb_UB`>^<DRE b@FcA4<((DD>:^G@=?cA@f:E;
)HURs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInIڍ׌߉s\gpjځBȉymGł񂪓rݏOڕKvOxmȂ튮xrWԍtÃ_xƂ׎݉}֎~HS\zԕzfmQ{ǔsFV͈vdǂь`YilǉE십ċNԐUiTivIىe^qlӔC~t`E֖ؑ{pKWoYgȏϏ[cxb M   >  0 ` @ 	iyє D @Ǘg$T ?XTV
 P G1!!#"& pT~|U  ?ДQp? ߘ  x e ) EfCv h0 @ਵX   `00?BFLXp0@;ae0t<p@I`]ޓ$`08 Te ӗԥ!|ă   UP W ƿ >"6>?=C?~!B""!B'  /!B#b&2 ×`   `ALXâ>Ap1@@@᪑q  Bft,?0<Hg ǰ0` x^\pü|%C p)QȳGGf t0 صĚ56 
	0 P $&# q8 o U| D~D D<U B f<,$$0$l= s `π3`?"#!! @ `C 	 8	  6 a п1pp0~!3pĤ``@\D2"##8@З۵ Ǯ!A| %rm  2  ޠ 1$Q$${ayH !{HHK?x d $`aa @@0!cc $2&f# `0;xxQ RC{xpQP`qE6@@`)X0$x|pTT T8p] ӷ	
9d0  $
p$4t84(d(lD &1< ?! ?&!<? !!# f4cBDjpXg?P|%>0 ^l !C,$9`0pm%B p @ $B' p}""" ! pp =d e ѶIi&0С@疰&$
(?V@?^@r  ^#2Bb"6T$-`0|Дpp_x3@@` 0pA> 0Ľ@3dC|s@m|%o38"5U QHU' &a! 3?! { !!3#!2b!B<?1`		
	@21"`n9$i$	$	P?a?bb"33aԮ(F?3ɠ8u L0#оtE!"*22Hi)""?"!PGFG'  <p$P$%)*$ $ 'I,!## t`@"3aMR<xb\ۤ߆ ? Qǆ0c $ \7 ga  9 "} 8F `D8R)C)E+D:<  = ~~<  bWo<$0X'V?  |DYXD|'/[>??$c]]1ߣbpC#1' < ~ < 1a  <$$$= ??d)),?4+fI@Aa'߾0Ǣp6( g}g@!q6@B?3U4ԗp 1@0vgm  S< V<bo_=$Ap<P0b64~
*rhHraacesV ~  <0 {D=q<$2v6p5''sRQ2DRDy""z"z""s!0 `1 K0~6@K tp q02P <b62d,%}IH}T@_ 
8hI8 QQep@1kp 
 .:23V{& ~  riic` y z2"RP{!  @0`` ~`AٲU֗U|4p u	t(ʠHP0ҎaD%6^SeϠ೘@$$1 FD @@1#f~(3H2~RHH~HH `π~ !""6_ h6q"c  2"&	$  c2(@"bG/$?e ŏ2B@D0
kBF0L `D~?$&""  0p	 x ߤ	#`4 c&8}qп SPpP 
a(0$?`@@DDDD0τ!cѰI7= up&+DL|(0<12pt 1=  4;A0i_#!@0 ` >?!#3"$$9!?`:!#! ! ?bE?yw@hQ7 H 4b2C"cyR S@y@Mޚ &QBx<P6@( (#BACt ?Nr|8l>)Q&bD3
P<b2W1#nSRa߄$C'$?Av%h|p  1   u  1f    p"r&#0  g1 c >9D

 @B  S !t!xCɛEP0S/dD8 )CFB2/E0<
 P|cb?Da,=%$>s["d[0@po|Dp2D"DvDTDD6 # aJr(!w @A`Ks  lq1=m48q&A	  6 P>tE PL DwBf$,8?92k&a d,%E 1BLpxPX	G sA3"&,00PбxoDexp<x {{|8|	(9H ;)*;*$*%+8 OTT5VdbAҠpB##@8 | pl0@P2P`0%+CP \Kd ~*H/?K6cq++
8x&?~!B2 #"33 0a0o5@8xQ "***" /"$'$&*"$"I?u%c0`@m?~$BdBP=a=B
B?B~1J "&D$(-@v?,!p0i
 7(8Po"W=I H<H$H$I$= @>@"@">#"D"l>("8""8>(l6cj e@0aI4R$zeUS R PEJF**py0 ;6P 0Og;!<Rᚡd0! 3 ?$$$$5d$Dd< ~ Tvp p $D$=<LQ׭aY_2<oLu`/$y,(8(lqD?  /"?(/(/(hOX  a;d			`A}5~" ?g0P8_0h @""bp $ & "  p?5 
pt
F 0*dvv@Yp@0юg#T(00r?$^?			?R" N:8H 0@	1y?y 	 	yz>""	V{0p">f6a➜@D= D~ ?= U0< %`V8= @|D< !!"?!"="`j?;@BF\pw8@h@A Cb {HHHd,$|$$$TdTDTÈD}>?00'$!$34, g A AQ8`"(; `&`|#f!`b62~Z*\*?jI&x@@pt/  5x RRp1 H0	  y' 	 ye6C$'!4E;ı!6Ap6pñ<r"z!sK0qf`  B F>lxPXHL0F`C)gq0h0`q0r00b64~
p**hH$lH UIHUH~HHQHU~{HAPC!@ppX8 2 :b)) ?()()~?H!!!aGl>#540P* zRs'"RP7P#D P`:( p" o">3>>""&"cb@	"00P Ƿ1w` xA"a<"d[A
y[ <J|3?"a|I#(Ѿ~I	))iIx	1!c@>~""#"b>2a>1ِAA+ ? ?   ? ?$DX0b)+*{I#F(!Q4kq"?"#
 1pxQ#|  80 S#Q8#+AQ8<
S0I  > "~&%,?(l)$?0F-@IQ2!;VR!q #!  m PCfxP(
qr "**~*B@8b~B$fq BFD0@ @`@ R"q`p ?2R2RR0cBb.4d a> H""p H b`B  ?~ 
(L5g+;&;gX%
c}m8@Tl l$5?b5d_g>`nqc`By6"x[@Se4`N[ 	(	)	) ( )H	ߖpc 5З 1 a[2acx?~""2&460ba13&4sFк~4@' b'8Pga0q$&bBO6  |<  #<oC;<s `xP)Qx 	 `p1y3"fud; |@Acp>@$	,	(	88(2l"Ff[11[T o'$"r3
D(z


~g<$4 7 a  p }#`"4&0PPs`@   \?t uUcuѰ	P-..1S.1\1  [<u.1 "`uVʊ8r
8s8t>8t: t3-v(8r*<rw.~1` aA!2(P )() *q(0)))RV^Z(uA!`R\ts 2ƃǡ0G
aA!O s6.EN_j/W/1(wts2)0) 42<
t<
tD<tY<t )PH  V)PU t	| tL^f:t Pg:D<XM : Àt	2¹/ u 2 42.>1u .U CB 1CC `.~1&+ u2CQ2P Y*2&PF aC@DRDr
.1.1PSRF && Z[X.p/ O02C0JC EKL.61FNFQN02O.0KPW/tOP_MTRR*`KQR.61ʊƳP ZY[XX  PE~bY2YZOsP2\sP
X]<r<?<rÀ.1  1.&JNCu'AA	13B`PRW Y1`c.>1P2cX2Gcc$CFWPQRWMF@@_ZYX. 2.9@`t.1dQcAD`<u<~q < n<< n< n< n< n< nû< n<< n< n.>ߊ1 t_3ػ@ .1G.11OWt u.1.;1u0 `t v0..1.1IEt;PI O X$t1C{ |Xd  WV>}	;">tj6 h]at!j^F\a؃&  hE0jF$aЪo$a% = 肒>uzIWb 4z?@#U$%|BJf^fffBNaaB^%% QQcAf>aj_4$7B`
ߝjBK|-sa?BAHBaD	cE*BCHŝꝂHTĊ│ST2"ěRUځ@ۇ/R[誝RgdRi>Qa u0% = u(ap0  &at9j9&Jw*`jQ~_a$臩_fh  nB tAt=fhjna$ě{Ȁ_tfheLBV>tS ct3tE>jhafjhIP>^%j h]^Q!t2>|c tq|cfhСSЂd t+тdo\a tU!hbhbESЈՈDڲ֪Qf3f
~fޜPFPhhdxfQhp~ 3F߽0H =#bhb=h boބ߾S VX&?hc?ƀ%-F8ore}reAࢿu!ɑy`[}`j㞖21h!_FPAsjrh!Рchc	I&%#7h`b`yP2%hAe V%~*h]hE)jA*Dԑr^_   Vd^F FPL <tPvVFF~rp F FIu0F& -^
`F*+҉FV e+;u;uà e% ;Fu
;VuÐ eQ	2_áa99~e% ϰ*	k
aWV~FF&8u
_ǌ@8t
rƋ*
F`mDNuA 
 Wg̫~0F $fj h薾'Py*{ f*fp e""!&^߃&&ajLfPN'  t[j0Pр8'j FP(u
`)T*F -
!WVPB 0V=ut_ V@#`0GF| 450!62:65|2233 h &5T5 F GP4<35FNuFG=>G?i@8=O@
A=OBCs&J@F @(C1V,FBC2NЇ 1 JBpCJvJ>BTCJvJoB7CJvJIB3MJvJbVB	OJ vJ?BSJ@RvJ#ÆSJvJ$BS2&_%a% J9ÊSF@u,3FzK&L&a 
BASUQ\R&a&a\M&J`BS
2&^% +1^1 o_jR'<u@G3Qb_b1c3dbKb1c2AJba1jEb1cUh@hEAbhiOhhabH1c`[`\Qh0h~cK\L\ajDb^#f	2&YhEbBarhCbtWhhHbtYrhNbvMhjhgbgt3Ρj1iji2GtKhh%azDOjSbtjr@hUbBaUrh\bCJpr]YQq[B
Ar|~|}3+Vo\a&\aa jT2-kAU qV\awH\&@zP ( <AۣJW ,dj'
^@of +5at}JB(BMS dof _N$$<`^F e^F  ^F&F~
r_C(J\& &gb?&b & c &bb^2Ne bdB^a} bh킀|cS r2gQ#ѱP=`[`xr^aF@tFtbYFuM&bb  c .t81 ʀt]!`t1ћ0`, c.ћёU $DU+"%1Ѝ c@ҧ
1t! u!@tOjuU`B2L\&a}NaFbPadRaaS!r΀&~a`腴[q6[tD@.#HarMY0Ƞb߀&awK.pojg_W΂O3vB S#rsVF3H@Q
bT\ĊB&dU&d &d[5&޳+&!&렻5&Ƈ;dt r(4chJtZ]Mra(0c`c&cQFVVa`}XareZa߲c\ab	s$^a`abjada`S?rv@Qu`c cdcSFsE@J)zW#
IգWJc#
c$ < ua@<@øtr1/p A@Q!_S2fahaD(v5౺rcq`$%r"*F^N'~#t u^  q % p =ñdTPVA2F  j$jR1A c[=   m>v3+Q OY$`evBh [kR%˶o9Fth dh c> /Ij  ?hh~PC5PF!2^=  ~uP+Ҿ!FV!  vƂp~ r~t t uF)ް)fv
ҒV_2,Iu!uSI@ ?[t
p== ^PBvA20~ f{ ߤF"B F~P|v^ KPF ^NrFFVw~@. H p  p FFV>e.>e] 0vFW?~Mj
Ce#
^F&? u`vo?!aR'|)m(`͒R* V)!ߨ`v)`] Ni(N)F -^cov膁.鼰F!
eFFPj.
e.0^/GFPv4.F
eF]/0P !3aB3P;a3aO40*Z`j\&@F 6@
Fr~2|FtF}Q=W^
~P	
O _ pAA@F\QC)??~@~ t;BADFD'?z uF 5GWV~PN^PBC^_NC"j(CDlD1
N@'0I[QO4E ,>?(|WVvԋNBBM4D E2Q0R~(|WÍ~=SX
C t_~@u"X}H B^F_&@[W[} \U 3V.EWR!u@3I DddeKvSMCPd5EabcF*Ud}d
fgh$mGi<An4EUWVv<~sF
&GFsPt&MTKV~ʷv!t^PtFGp]Iur> s^&^&8t V^^}2
X
 0GFp|N0X } R-Ar~ ~0sԀNFN#xU;u𐀗u0z3ɋF 
 AFC&s`ffF ~Ћڿs`?s^!A6Fo ~}1)ТPu
CVߋṼGV~^ x&FI!u&3W%  WF!2$a% 1 Uo= >2БIb|ڔ ?XT@#;ڔU$2&%a% 9$&*&"^+1 1 _j_R3h`"
2&_^% hK"2aa1aj"b@)A"B)a"""0(zZ0z3Q\\ajD"	2&8E"8C"r઀)H"A8N"gP)S"G@8U"'8["3{+1pnpjgQQbiરF]a_t j^"b&\aa #vf3!f   bfѹ	 c@XreV`ހ#؃2~ ;&.``Fr	ֿ ؤ پ Vه@ճmzFգRҀc8RzSzz˃ˍ~a"09`"2d""s> W> Dj6 h cj^a؃_ jF$aJ杪""ofn">V"I^="?@$~"#$a, f jby j$?%^b9&9bf^fff,^b`
(zw9bK}!bfaY/1A )Oײa $öD 	E tC TOH Ċ,.N
a,	UPۇJ1S
""[V,"g,"i,i!h#sFiLH; j!h!>WVvQދ~ &F<t<b@rQF*;_}7I!_~t!a!F&8toF#|T#<r2q>rV^u	A(|(Ð )uW ~ЌPfh#  N @F;rF#f{?*.Fݠ#  F*N*ȁ vFh,P - -bEbv
u+/d^F  !w FOup&
r>f(d8&(d(d8?&>2d 8U939)94::5:0+t<: v5557t &ef'20@% =pu e$<C@2? e% pu&B<@%@"CR e1eBouFA= @ l\9Q#A+N3 e3PF3IЉIQF Bu*DG:ӄH"E~bKu$&P@?u|G;pf2N% wWp	u"K&BuUGQ<I2CM:C0B
u6N@+u*<#c=APa0Fe&FO}Raddd dd	ddd
 d!d"d
#d$d%d&d3OBR-Ff$a n \aGJ\`p&&g1_f~ t3f&$aFt~wu}_Obsp+PbtQb{tPb tu%a tbcauBd	caaeueHffh6`hr  vXa>m>  f#l lf mˉFP9v\ujqRP- v\F  vB F~2|z1~rF_  r`uFbǿF]
 t=cRtjoSoV 4v\FRv a߉F@ qb*J*nNqQuvVFFq|F؊fٹ
 -j|yΉz {b{stF܊fnj~}}{ F֊fנnt@ t؉FjzQ_vv2b}0ͅ~S1bsuF_PЈMmuFhm>h(  4o j{߅FފfPFfa}p}o{3:a> Ps0F1F2F3F4F5F6F7r8F9FAFBFCFDFEFF~Ƌvƹ|ڠ؊GFދNB $s`FNG&;u@& b3p> v\JIP1㐁Pj2*䐄
-Hi- NV--Gp|b,,ܲ-<!.2~a$0JZJA&$Aj)1c!
SeQ ev8f ϋ _e% y01- t*-} t9Ġ0ḔÛĠQ3(ĠRa0қ0 O\⠩kᶡ\LBjQF$@%"3ia@GEB2Q" 3|
/FmPRQ25Ԩ~aʙš$$2T%p&a eh 2^V^1PjLFPQsj)ӪssbL_Ġ]%`)WV3 W-^&@RFG߃|倣3,Ҁ "b3a>ӃR& FWB2ɣҒӁÓ rB2~"bW>a bbA_A_6 6 &=  :0^Ŀ_ #F?t @h5P2dޅ}߯K
}
a) ru	2 m>`+6 Ĵ &&T`+aV`S~ t'j 4F I  t/ u#'jqőt= ta7>u
b& c"_b2 c`1   t&b`ul &l TX&a2tIc=o1WUe=ej PBWP_)d= 1]atVr2tCa0]$a30+1a910% AzPW=da<dc0YeXc@Xccbc3ceb^^[^@aQU͡AU1Wbq	c	> u[h hBhpRCp2pbzprp^psBt^pgpZpMp@C>贐lU
 Y)I`^n\F&߀? t5?(u%&|Ru$)u&DPoV@oFF?3R`(afjfh 
\ \ 	\ \  jdL~    u 3&a 3M0^>R` ctfj j 0`3= H/=
td-
t]-! - ; - @2 o= M - 0 -  -H Nj13S4 4 5@  &9w&E!#U 6*  VVͽ"P +61L<#;  9;~ H ?A?;+>+y;= 
7f7w>0,~`8A`?p8v&@u? 7`n^D; ,PC ,<1,4EvĴ EІ-3'wk 
 ?ݍnQ~PMo|\Y
 ,d sѴvV>
r  OvV*ӉF^ RpN% 
P h
Sh  yS!ONPaPF
+F@ޠF@!vvoP	FO|\NnF@j @v#VFPNQ= X*PWP[ќVW   3_^L PMsѠ|\% RpaqQRъF?
F|\qp֛PFQn[}\;F|aXXPMF@PW]peVv^ XN ރiF&t&@jjk&apssu9F[@\`FP?FP`@WG ̿tpF"eFC PF[V[AP
QfB`UCִހÎ5dPW"w M*	`!B`~vykVsɁjӐ2RF{{Ɗ* u|U  PhVĭnU] փ> t@0ur3NFQ# ό #N`&&8tG&7vNً؉^GF
&Ft^3G`2tp#
V^% = @ʃ@A3t  @aAaRwôр> uô3ı&!*;tur*`0NВdRdt`F
tBt"`7f'v
VZOfjBӀӀ?Vu	TlS՚h$M!!X y(#rVCui`llQ3k>(aay&dDiRP3>>!XZ4P߸]@t_N@@vT@ !	qvn0x\PWz>OAuI`pV3+ȀV; ~
 ~Ix\~T֮~T`MBuBu~ ~\}#r}DƳ}.P>x'\ }* f`}wx\r}ѱ~&zӷaӷ~1.z`*R  ⷱQ񴐺`zм bz\}z\9Fu9Ft4]6z\6x\ˑ~\~x\z@4dO 0'~\0\\r-» 1ûzs  @Mr? ·v +~ tsQQB`VA1P־ pcF;{uPzE@̿ ;vu_39> ~@{ ͎p\`l*HF\&7}FV@e;F|~߃
G;|gv`| >#;  T>˅J`˘>dFf&GW}B&Gpu`юF&M*+ȉN&Eb|&}39tOjV,F&:t~P}
AFFf@uٰ8u pc} DcԐV 9*?;}ۃ`~2u̐3&8MtËF 0ߋNu\xtك *G;0^|,Dt3696tVo}o9> 90
7 3
7^&?9 ~mҚ7&7&8A^F AFtIPu'9Nu"^*&ϊ PW ۋТ"|f0AGpbv
<C`uc   iF+F-   `FQݺr3/r0M7((  bv^ FPY |31F:Fr `rr rrpq0R1RkFPG+ɉFN+ف H&wwfFf  GBVQ
 &f]~38tC8 u&3ɡ~^
AF mG
u]N3~(~޶`#uR F;|Q`VrRP߸f@WVNVʁiv<%tF0u DDF
?0N$`F
吉B`[%
Q[@,VF[VVputQЂj;v~ r^F&_uF|WZ֡fZ"}  P+э8s$xvZfPN&8 uN&= tr1@ԗ.$fh  Z}Kfh A-	,,} -f6 ء!IQ,b/-CPcsN`f,,, [j M/vpWVr\j` 3 ~Bv #j5&ğI0/f!&;~"0Nu `;jF5@. I3 cP{Z,V?-,c?E? n ~ 8pH~h3ҋB [WQ?o89It4ePP1vB@"@b'PځF?fFGW_D9Enn 렄@FF_9Fu
PKn`VIEPK vv.Q1̿M9}׉V@/p`4܁FZnRPF}+F-K P`49Q1`4B$>R?L?:u  
FL;COJ@b?3@R?3?W\AXFpUEP!ZDsAX"|$j,B>0Q?fh?  q_)j0Ш2p_Pe299u	fj'!Z`45tO/OQ?`4$ ZV!Zә5 PT^ #{2R ZFUoPo4bjsPx_H!Z7jtm4bdRPH0J QtmoKfz`4fWVf!ZN)o4q_ Fڋ`E+FF2FPdbSw
m)q_Swm
P6Rs=d Lp_DPaQ-q_<|{Q|Qw5RR+F+јpw2{mYtz`~/ozO@P"FU|B@EB}Go!H~Sw ]M*{A`RvwNmV`LTVwЈEągGP@F;yvzPqZmRs[UąE!QSP /3n/noz]TwP!VqNT&j"~4h!tY!;} ]z@!RwD17PDT3aFF~
`~&Fި@u[]Ft!<F; A] 4 &@tTE;v};v7Q*GF;FB+F-	 F~F&Ev;v~ <~ Ġ7;FFCRKQw} t~0Vg~PStO9CG\0
t/* #ނF\9F}\ ;F~Xͥ~~ k+Fb`Ӧ~%&L
DFF@@m p Sy@	PT@PF].@REڑUi
X1RK«|px\Fxxxe`yƭ&v`4avFvePRR~ \st
+FbFHfh `1 tDT/ݼ6w0˱9~ DaWF2 3p^+FUg1Ùť@ zpA&O +σQ.Љ+@`UT@]`4Qtj[teBъFĉ#"U^Qj]h< 0!vQP]HKm/mQy߲Q"j`7f>d
0!>>d@dj $Ww 
Ht8-t-9t- 	t "fRK 걝1a	 qF~ t
f>dF"  F
Pj q!% v
 
`P-j ҦPHPV?
wL<9&w"/PTKtp zq/ U~> 	VVpQF
twF
% qP0%D$V&6  t Dsu@$3A$^ǠA_؋G@W 蓣D@O@W*sHm^ 49>{u-	 PWaPG)R	kQ
`4u(+Huu
@ut.j	j_fh
%Q
xPt bP1f~
 t
4w
ZQ
^v pE`U!qxwyк1	F DVV~ vv@ªB s6 ) ]Sʛ2	 c'(1	`4F0	~@/1	kF2 3+dUE1	ť
Gк$1	8 ]2,d q	}_BǠ*pK:td)	PB*S	p+E ?FFPIFG 
~@; ;NNNQP0uc/ a ֠#pA w= K = ;7 -Ʀ-o--@PW
1!WF `]0 >d@ 0аRy;v1Y;vFPVW`:F >~F G;~~򐨋R - D- *-@#- @"SBe= Pk'-6B5SB.DGSB@6W- D;DFSB?BtU`BtP0P͋F~9Fu
VVIVF>9vu@0JEN< 0NNbF ~9~ ;p<V 9vuTJ,< uN 빋v0@ML 3&6 `PBRKLߎ @Rx<MR aU/VN;ύ Lu退<@MxaU^F;~mTJa@RKX XSZM4T~Du6dKrM;|Kt>.!?N;v}O;@OA6Vޱg~ u FA!pа9v|G'  ?9F| ׉~>`^&+^& b?プF"@!5@6Fbv`h\.BVt ;tt D0D3nf4WhgP
r>7)Pllp7Gm0nvn0+WV r+c c tV@2s@s^ssfvsc0knsUsFssNsnpl`ul}1;F~xo1mrջN@uOz]po6x5#yUy'zuzv{60N{p>b u)>c t^>re tf0>` tn]a: hҖl%б.hou2)jh!_h\0
j(hch\EЈ\B"Ј\Bh`h\E^Ћ]sEЋ]cEЋg]SAc\EcyEcizE"cYE`IE]9E`)E`C2loбtmp^_,= Ht.- t'PtF-4tcFHt- t4H/Q#Hjh`ߨt1-tI߰ĝOd`UĠ*䊇d1-upᢥ*HWv
 dPV謀t kp7&c +As*susȄuvIЄuR؄uws7hr`U fj j@WPV)WVV3j h6	d^.D.@HtHt#Qh !2   >t^ X	{
F.HtHtHgHt$q"ų  t   'p &&G< jhz	G_+PrP

_G>j@PX ^PGP v&߀ P~Rrjl6 PfP3"0> F~|`b b} v@j	&8 tb|9GPu`r  ><9uf   ^f~ t  |֊F1	K-?	`@	1D	aR` o	}|B^P3&~/tS&  v&8 u0*C;^k|ӳq1F8T dQ212g0\^@? tvN~`c"vp(׃~ uMdDFG&9 uԉ~'55r~F=/5 X=8 9-
 -"P -P+Lr:: ;uP< tIf齠`AtsP9t[QV-
tL=0J-jC- 	tI- - P- tNHI_j*o@f1g~D@F	pr00Pt" }uNj ``G ` u
a#=h1N3~* ^
ފ&8u	F;|`q 	 Pl
` ]#q`P7
4r
~a$~A  *M8fuadߌ^uPa/tP3(]pf0F |FPZ 
t-n f3f dfTh >륐j hhH]Py	 3܊H]F!p*>!Ht= t	~a@ &~a齛0UaQur
6r	r	r
 &
&
hVh@
h W
p3R 
@
@ Dt2	@%$&	F&a&aD,pdI`dq"  !
(]FPPB@
?Q0
H4lbh4JڷbVF(]^PSH$h$=d&Q,3F
qH4}#(
-|ó$)$haj8|.ej x+
P*
PpfsV,bW(] H]1h2~a t&.
 .
E-Ȑ.j
Am!`77e"̷8#`7}$?%_&'(R
c)@Am*ԣA7hFbjg 躰/,Ua-T-^@m.0/1I23X3Xp4B zP5$]%  PzR2
K 5
`M$*M$Np!N*OO$N#NOТMf$NNO%]Dr OD$N`iNUUT#M"$NNQU4H_*=	PF- 9t7-
= Mt%
- Kt-Mt`^@Yn= d.(4TpP`M,2PO0bb8&$]01c'!brbbՐ$ddrb!brbՐ^U,2U0h=h@u/aNh/ F,h 3%˲ͺr
x& j r=,hOa_
@4!hrh |Y|
s!5t5$]~a&]aa  ϰVfh~Hh }ڐ|`@t߀&
 
@y ayy#zzayy#zzayy#zzayyгAzzayy Az
@~a$]a&]
@ƀw
rtj,搠Y ^#P-+t\tcmKt
- tu]!h`bU\bhtGr hlh
h hИ`k7r
ZvUM6N
90ijlɨ jCÐjyAA`̠s@z&
ق303P}fPx ؐ7
zrZ{+[AG[d\n]f^<|@5P$Z Z:}Z4!hfUl"gU}h
m$hh fBDu+a 5 C;wu4?&%]rWhrh@hG@tR ܁ގ>]P_?6c
/.\4 e&&]]04
SvQb&b& c&Љ|3ɻ] &Arah[9qGLrpPXrQuhitDur3,Vo
1w<v]UQg6N(!USMEdĠPzE@O#dĐ#巐UdİB&MTe!1ːđ|Xقԡ
fh^!x BҪxBҭBwB
t@
2z
|`t,}`*@t>t́ PzPzв@ඡM6NrOW0 MݠP/& QMݐ#PMmXTPEMLݰ PM+ YU@PM
UbފPMXbiTMDbK(իD	b+]P&ppA>czPwD`+ڀ
-u2OP PYtZyj[]|x\h?]T^V^6_/@2`
`6` .<hv԰ ݴq21 ੊df1g"`h2 i]  &]1  tB@VRWu{2tt `m] 2 1	#QJ&]C@4dR1P0!`h1Cn$0vf]f$aRwWfh{  wzQx10f$af]&%a  +@#(Az(U040@&8# ڑ@@z&a`G&`4`U@H4HS% = $ Bu_
h`spUu-tu$uuu	P0KP ǈvrhpbN25vËF2FPVh:u  v
WV#
1H5]HtHtўt-LfM+a(A!a(fBR(R
R(g6Nn`%96QU6*,L,6y-Z,*,^C8W-T Y,,65-,A&:41-,U5T: M;,܀w,A<f+fFP:P:P:F=F^^F4<FFF;F;F;D>==  [  -`d -tR   -[ -*t:-`d ߐ=Ї+m-A _ 0_W-]a^0_t}a^xDA&Ht'/Ht:H`(qs(6AHd((AH )cAHgR*AH`h+1H3 >9L*M`%FyBAt)j ŊOPNPfsVt;PwT^Y x
 9OF V*HFm>~4 fw fFT<vfvvFPvf`%Fpu63F-K˃~%vT^ :uF[.A\G;F 0$~ t
& or{pۃ`sra~`O&jA`zA```jazaaa t&A`A`Ãaa@'"Ht)3c( R(AChBgRgbNӗ&R@`caew:@\P>] u#u%j _a3voRx c]ffҿ]f ]Brr֤r^r4 t9Fh4""v_
] c3U?@-9t- 	t P\"nlu
 0RRaaQdfjj qp EuPN?u.5q1{n!uDuh  Ɛ>^ tufh  @n諹}	f~.-,73
t>] tz0R~m>h>Sw h`"Tu3^b^& ]^F |cwBmr0EuŊScv >pm"u>}4P\t&1-~%6]赵 Ɇ q 땥# te3d^yӋ>pm}"u	>Ѝׄ Q/jڢBt";ȅ傀B5u`kJ`t'x{~0:"nGPNs|Rm;m4TpZ\pb1d j?ppd? `d!`A`$xi6u$Tut3kRm<ʳm5à51C]Zab@߰k a fhqBk_-Q`W]͐cw1 8Ű_` ^^a`^b^^Pd^ cPbq)  \a`ѿ=|
ced!)R[蠯á>hbeP#)RBbƺR㢷}eeN`#b墷CGO Dt,-
t%-.t,-	 tE-
tYCta- t/`C D@ߐ]:BA~ / 0'qn Q}P4  so{\sV!ctbuc̀&ܐ`!ct+u
!Ԑ`]1 cU3@U3U  Ap@ut-p;>}  ݃Rr}֮h2{ vtXP6q'HtHt'pn'*Qb*{ Q#CuͨS^_TpWV3ɀ> N3 !Br]QQ@FPWax~V%YXNRDt׹ %&P`a&9FV^tF&'uꂎoǏȘ _P> uh h]hPNhAjhx
f @t>BO3҉6 5 ,@;`}Fx
r݋Fn hbRNIBsWRdAEP<~U6qwf
X~r߫f(dP:v3ɉNv~FV
tut9v~O|܉~* =ff^^30R
GF&_F	
u^*ۍFߊF%FnrvBĉFVy	NJ*;33V~"PVP9tG;|	FCċFBF ы3$u0RGo4t%6%L  rrS@ :$fr^fffH+K,ZO͠{$,%!$&&'r^ t&
Ԩ
$%% }P3&&d'
+P,,&:'0>^3
p
tF^&F1u	240)$PoFP,@,EP&}̠{nGݏ`rs#*A_=C0=B	-tX-`D - 90D@Vy= Mv -CDt!|-@>D3D c= Y.<pĊĚ?čŸOCoDnDr^Kr^PL+1)1t^$- 2&s^% E2F  ԁG 3AFŐj  jh

麾KA #BB&Ś0ō:NOP~$aqG uj{Q*3
@:@
4'G8 e-؎X$^Q:8cf^ elV`Wr^^$@a
P` S&
b
 \K
@?S7Z} U@6Um'll
'la@b`l}Wa@bca
@b cfhlllhwa^rή
>cu
?l  O hElF<tFP5hâ&s#PWF V]$^
TFC|ߊFe `Y dG6VF$:Fv
kVvu(0$
F&yN
U{Av^% 6&c
v^Ox^Q%|@}=}5~$P,(|0)@}}f}$E,%i| -@}m% P,?|"}(,%ʤ|"}!}k%)P,3&U"}o(	,P,U"}E(U1P,h_%tP,n	ƨR%E
Ŧєx|%'RҔ~%D%椪3&
fF%6AtF%t$є>W,";̈́;L<߱,<-
G">
- Kt K@<@^ <}rA0MB,<dt˔ˮ{,2{FvFx^ן 䡫 ֡ z0 뺡@ }- 2&wH뫝ga ( ^dw@TĀD}-  3 ~O+-Q8)u) )@jshl&ДpDL wm\M0̥PAXbΪ{"?1aI3fafv \av1*zz@!Wt! 1*#@\at& Ғ3˪˪1]Ҫҳ*3˲˲͒Uڳt& 
@aŁ@t&fhtdu肴aںt3@7aURxfhfh4P
*^d)"Rؠ0tfh/f-.h,1d aܮaa Rp$d%R4f23h1NP
UaRUxRxR7d6nRx\Rh.ĿKt`bt
 &@bt &[iɣǀ&`@s	@ut0&;->  b8$rhth s	|^t\& *|^Pe u$0 :3 j hvh8X5  t~@ p`` xh|9  RP  j 6|^zu.&`~[hj`4&pxr 0&!&z; F2Aw	 ǡ Dt,-
t%-.t,-	 tE-
tY- Htq?- t/@C DL`:>X~tr
}<p4  &|KRqVfvfhI
  0ku ph 0&؋F&?:tF&<:uFF
*0N&$pw/
u0mqXF ~ uF	 F
  
}
1<  svLQjqJ^Pw2&Kp&`-p
~~ tgh记v~ tDW=Ф=u5w ~"00 ^3 FgPP`7`ü 0 uF9Fr=w "0:@6-
 ؋v v sd ƨu}= wABҐ(4@LXӋ~vP"Cѿz`+~ t"Fa.q.  R"`+ F/ :/ ./ {"/ // 
/$a
~dz't}w x}Q$@ǇPD3^@Jw Vހ.tC;uw^A<GC;uK  KY/.5nI Nrޠ<~u r W B CB I rzh;FV>F^=?uFvNBE'vPwÐWVc$ < uؒ@aI@<@ur1P hHhݹ"t1
6j~ !;
 PN[3Ouu4!-q6Ui!	94	~^E
} 	9 "r
Y"ZNaRǆ8*9F cp9 F*Htw
Pnl0 nm j菐 @uf4Ϫ@;F~cdoPtrջN@uOehhn<mWV3 ccWg0O
GPr{     : kMHzkKBk SIMPLO  MOTOROLA  HP  1.0Dkdrivelockko Computer Setup  <F1=Help> File  System Information  Display ssrirSave to floppyDuconfigur2su diskette Restore fromuxvHy'xxdefaults|tv  IgnBzhanges and exit E sq withou~avingTv̀ց Securit0vAdminist wor password Ppve a҈Po?wer-Onw'pR`wDevi#ce $'d<erD}'$t2D1oLĀovsmart CardpUsupportEmbedde暕ta|'exe
tuacx tpx s4`wauthentic3wßcred1al /Auto!scTools Ba|xCalib  lectz@b HDDplf-Tx opAss ActivJ ˪OvSausDustAdvanceLЀuag1r© lBoobຳ$vPre}sy keyuv ue F10=, ESC=
Cl 2 Accepߺ=Y;esNo W, Aor1=M y ҿEq  Usuarrow1Po highlP he appropri~qmenu ir1p<ENTER> ubegiv!q.follow!õv n:k -> PSPACE = Nex@q=-!BACKe͠vio`6okT{ABfiel~oSHIFT+ zo@ͣV` C Epÿr Thiscannbvըd An e o9c  whr .٠vde 0/x01 Peynǔ0t`poC1requiaras dlo!bamupmovku`}e k/MEUIٰp1ܱ slqܿ2+٥ImcpplesussfulaManuQr  NtdProPtyp0rgspyehtepprCacize (L1/L2)mem ROM R0sRsfamiafsel nu0VideoKeyboqrPer ver"DId1234frafownhipC	(d gO
3Pdrvd9aBSN	%$ 123MECV_ _ _2 4%TV')zD_){(-{ozS1{2tuFuW7arn : b@L`ll0} o` б0s ofb6xTreqa au/|@x,68lein w@ab!rwt<u"o A: 5>pU@ @ waQt0}tA>w? s$?7@rCInv;x5AP<;!Ce}AygyoupMwapto  x:t~:v?-  i_q0QI  R0QŪ Q R1 (QuickR2 -(apre s@oX3 (S.M.A.R.T.) Egsti s@exCwim0): 309a @g.o0%3WФ`t vy hoW3W?upha:1't[撩f-]cUnkn0
@ilcW<FfServ1gReag3Bdo  aۄ g!ribp: ͡&exq6 GZn b!.Sr  sOlЗNewx=Vfy ns ">En#>Off O0鰿  56 PpBWro0e 0 s30 tx%tᣫu~|pcauspLPH!>h   aᖜ9  .r(L7!P loss 9^YMhour1ါnl"cof aAgo@I]ux`iѷev0b/9DoCNish"7ed?SvȀf0;a$ddi0jPP"G#Pr.Wx8hWQsBk wpM nѱa@Rm0`;tS^PO7vsz@`TG\POnrJ ~3SӉL Ft mf ɇTndM3unuv!B8natartlGfraPara̰ԷSD0xSloqmDw`lnet`sM MiPlFn+F2 :pnt CD-tU@ٿFBԪa@~q aGbouNF=h? uⱂk1ϰ b`:USERMASTO:GIp0anz&cxb8ux!keep iaӇeph#ys0p0!hhJb mpnr. IBNOg,:ʀnun  ? O1~ГxqQAutoQc_ȓE`d` @ix_̔ ΫKO bs(ыZ!G&,ғUurt9ܰC:thB8sw Y k Bervd@PerpV \aff@GQM[a,s7sibmaigi` IbsA zlr0mmCP  u0l:Arepla`@  P 48p?@:4,z/hJ )ГgBpImer,7h  lP^pibmty. IfBNdoBN7 Q^ESC.at* MR|typOx'F'a8p7:F102a9 bPrmEC| `x%  .E ).) Or :C#M #*ayw+XD@mb, (leCftX-/Ph/USB51cC2HE1Su 3Z;ipFirW o sFpthvmif@7Six7Nh EA1P7N?yh_8Num 2 @Fҿ Swa}pp/Ctrls K#)U.SГ⼠_P9md`
cw1legacӃl@Qbis$	anP`r0[ry6CVo  NTSCAmLrD-JD-M!qLt <BidpEPP ECPC Qsize 32 MB 64J  om lway ni\ACë AgB^k0gt Op DR?3/.`a)Q.`X+EqPRuU 1UW2WW3.RTokRmlW X[XX[lZu0oo_2`3QUnique IdfȴG ne`f  @Gtuohij Sô/f(CalCib_kfNAsl1mn@yP D|/ql/sn puqObxl{vp}yrRB tfOoxrH lϊ~pOOL`/ MEUlop/OORA1OlOp/O[gp1 : CPpg 9.(% ](MC0le24c!d٦e=ƥ3@Sd Xfǥ*@o Ao}u-	y?s :P@?l  Sp` 0'hnolGogyWw+1L@FreQFA5cadap";*FPXE RPL Ex!*Popup0PA( T0 10  234*567!"F125 15030ǂx>BP6ouchpaP>SOpNonp<F1=HiOlfe>` ipinP!̰nOzeigP!Pf30 &peicY [ K1guarVwie0+(Y$pBn\vnEGein"unϔO6G-pkzўԎ1cـ`ed%!nt Pneh0߷pSetSheitsfunkzp[n`t ް8=n1lt-Ke- Gertes6op-ID 0hBtAUAstgtz`0?r h`aez`  beim p:@oAg:1GhP9U n svorrr/ o؁zurck &z%Bް?f
g	s00^'Ex0hAkku)kEKUt0?!sgewhl DD-SelbssRtivޡO3:!hZpϳ180ErwSSpraUa3rt-Oc '"(i{ne'lieb7 Ta0, :@fah=Au, ESC=A#bb
(W)(kzeO޿)(JaS-N =-, J&=Meh8{- Vez2&z:Mark sMen# dP&PfeGilt'@-!d%<7`gabe7'm`kc!Pt  .\3fol0b1n A4eށ&r;:pf-> Fr Le 7 = NchBa$A<-#BRchritt-b1CVo1'CfTabulFDCs Feld HobClelF+IFge50JfO= _N"REscFl@bi 
 kanuFt weeei&aq&Jr1ge[trn.YcP 0`APSUpݶPfit  	kqYF
7oX&W
sel@ommv orb
erlDe+sk-smu^6asQrbzw.9MGobi`cRYg tzEW.a`π@
T߲X/YOZb[2qddmalgr ab jchlos հ-AllztyprtP0w ]ig]qE aarwqC-`-Gre (L1/L2pÅzkapazit`OM-Rs}F7ami0 SF`umm  GrafikW}`3}|>r-Con` !u1~cdB'h7~U1 2? 3 4Qasi 	B髍(R(F0	`{Ԉ AOth"aSek rU@bU:v Ўst 'bisFnd'E4@#qd-/Wb0UleD4bEd& Eeis00֠nL@`Wk A:nfnקl7geK&oBnMp	g`@'*qϣ  ?W
OM&wirkQb9GT܉?S ]2&, da1&|tie`#9O<` 1 (xn0ِ2 (UmfaatdGw )fhbddau (Min.): 30!dAt .&R0%P߃ylswupmG Ho`n jpubrK*n: VdWEUnbeV@dn(StGrvo-L `UtFSVbpnhafqJAttribuIDpF[n	uvpS.M.A.R.T.Q%* . As N#euPs|a/ DeatP9 Ja!A/p5t FaligebL2e5aw5[<fd'minP;oa DurafB?  cW m3gQbq3is@* s'd,a @0hs !tѝ.Ѕs Z1oƹj
Q@4en alP.`b# sfnelr&s~viceaas y,E3&& a jpt ah9=DFga j :(s(? Um\ FunxC<', mBevb;!n HPtectToolscP"ty? Manag05ko@ajW AGca-!QuickLock
SMuPndvr  |r Mbi`l 1U; bioQЃchutz  f^f8fimԙ	q ' A!5n  P`
\rAu, lqs]fDVmeh U=PI* @+~\|Et  Infpywot-\8Par@e.8pDraht@tN0 e[ "=k"+miCD- }ŕ@7<PUy+t'MKr6:ln'㎓Fm<TBrive`Fp@LбӥZ $B
 ~s rG-3
Es m0zиJunbr}a bar. |I4E,bew
s@u\,pҐo rR3 g@oP/fFMiL, rfE4ej,  П`OQ BB!n0Q)
GzBPBegriffи_d>rautomp=EI J/+oh)l)' did ' דzfj^`0d XLR/mTRsU:mUn OXVe0XQ	ij@&n[tz
@ꡍMJ1GsJnP)1.]P$ u8_[,Es @hAaSlhfI r  	иbD˥s bIf5IP  f  [urpn7HQ .7 Esdr"empfPi3fa d[qzuA 
EPQ"T. Q/@`@' .0pR6
`b Wǉ15I-Bn4
ra
%PtQKantX 'I7dHasdEsc->/HDw&I Ȳ+W'&I'I@^) F10PğH:Efg ;g`ثc' sD@`EPVА0wMuBay@X_6Ŧ@	k-E&P%(links)ğǸzQtUSB-N<̃A-VJSqu!CZipΫ 1P2P3P4P5P6P7P8P9PNum-s-Pt`"/~n/StrgAtP"!@E|`E (USA:4fPO-Ze }}Tradi8.In@Grafik-Contr	1PrimSek!Video-@:r[;n Bidireal GrД?5Ds g  Lfi ">bVieb Aggr@2@I Epgparf4Ձcapie1ve=VʷȦ(Eo)uP?E`t 1/p&2p&Y3ToqR" o? ?oRaP1p I.k2, Akku?   /Aa
? Kalib2kGMkֿDN"4Ɗ
iualğ!OA  ?%/$)/K  /-"#,?1&(/0 5/+(o.H(?8 ^9o2(;^96 Dr-
-/CGo=FKAC Lp4obiQo@9N Ou9oI/ROSu96RQ̯VW/ZO[U!]^6[zr 1 :@r!.f% ]6eabplonXh2PfEntlf e)kfgliXh3 1k`PkqfOns-p*xai  x3N(J_Vc%
a
Proz o#r-p uƀ- Legacy-f`&0r	adapBootm㠯zaExp-a-Popup (`.) WdCau`dpW2 (Z Z[Be K eCompPropstn` <F1=Hjlp>  FoplsysqVis`sne Gti` qkonf଀ۖGe;ndframq@=z Jr85T:  Ignor`n뱔 =oyfslu
¢,& uRwtp`סt&newk0~hed Administo0ܑskof KD a:ԫA foH燫xE@d0%*e-i lcᵙ0pf*lڰ]Sm-kGoddelMsf dp@ndbyg1g@粏ds2 RR)( 6fayks
Ml% UPePBg8ɾEǨsIkɸ%աBAaq xѰ zd@valgbsѱ§RHDD-selvv#t`r ԫdrR_ Avanct Sprog VlAs Ok[o̳~Tryk p@ tastR`t@=!, ESC=AnnulRFa$=JaNej Ҩ,3 AQe=MV Brug pBᖰ@0~e  rele|0menup,qtT<ENTOER> De+ѽet.@1f@PeЇD5 x: -> e MELLEMRUM = N؀)Ah<-$TILBAGE Forrq
LTAB&felt SKIFT+ L= Acce 8L aT8>sfejlF k `s Dod
Ά!n. F
012Qnoԁ `pla`RAkrv wvek`Ög
i d	Әs` fly sPhn<0/MEUR% b uvezptbrudOo
2:	tvФ0mf0Jb8RducPqcÃtypG$h igaH$`trcache (L1/L2<p'huko@ ROM-famOilieW i0*CVo
fR sr-c_ontroD-ba@zs,/d 0Fh,22?3I344
,fa0zt-tapfej9L(at)284O<3=078@/8@Ў0Jަdvar: 1Db1e s  altЖpE@holdѽPx 顤o  ٱ/L b-'d1|d嵚,r B1kQbeskh!r A:@@
NBf šNMUgyldigIlrבtI  _Sngiv&u,pKvi0
&<?_ is(k?ۥ]
-b T0h(Hur&)f0Omf)Zsl ` ( ):G 30`ղ Q 1uC0% frVfudQ"f28Px)nho:x$m0^ՄbHrUQ 
rS8M
Duerv"-qLsurib?ut: ID TC/S.M.?A.R.T.xy.S~ FyNyzft; n\Deauo Fra~l  ED!HR`" 0Ks`D# OeīD悆DƂ!pʯE  bevi\p^1sv RdՂes, f. . ramr a¯.5ǂE5zvc]mestabGata. Du bu tSflpʑI0#Z|$ viceh PDBIp]RK?utSr ~Fi HP #tectTool ًj[̭ Quickppau*Lsv.AbmɾSkrp맍rmv,tCN,Ab$saqb/>O HvisaKAa3m@`AJ̐*r,diRB u@bil@K©ja!W
l pЬfrardCiP!d;lnetqpПKnappoC?d-rom-`gȠ̣uJBW SHoƸ:eQOuƀ%Nh4[J,!r YDu.  bЅBRUGER-@bOVEDADGANGSKODEN,2%N\  aldg1, bs nPua  opaa\TŵQed pKC[فC l'{y PboⱤ@\D_hpbZutom` pbyga!"ok? permap"3an@`ig~+qnRߚ l fysdsk ǰYrbfpcn o@ 
  
؇InD u"}mG, somi,LLa /c˓ptt. Us'SEE p\pcL	 rio\IK#  )Dabefal kraf&N}FEr W!U]@;pl.  Jau]9	FnAo" 3. . b?2BNu#
d i~$ux
Hu]ARa.vQAe8@tryQ@gESCP@An. He`f %KM orV  ''`gLqeP) !0F10v X4c#)P-Р
A4sD`sIC:u  alD,k Oñsr flgpk yD0-basJ MultiBay (0%hO@dAhj!BUSB-?floppyJɂaDc3`D?RDsqu?aDzipFrZTr7edjXFj0HJ`e SjWSyv Oh NiRLCMNum -nipmm Fn/Ctrl0q}=Edl(ua`isk)@x|@egeen@:U{st픹:FuPnP!XQ}p3rm-ce{r PrimSe@dXVo Out ParaX{3ǵN T0jStrcohuko d BqlwPAd t``p'nr compuP}Q\0trmGӸqmstydatic!3Гcu= dBT`sB@(AGtoppSeAbzFBeEthQt I1+gi2ojj3+gToA(R\jHnk Hn[mLjsksPmEntDgt id-nu2Wg  |жA=oyzSѳ/|O}o~JLbxP=Kalib1?ςn
digo(V ԈN!`:AB xόo͋2Ab- O΋ 3up_ۓ?܋H!$gsK?@ϳ/o͋VAi moĐ\@a(MEU) ZϽo§ O$D?pL ?^̌V̏c[ T`b 1 :3 O0 .P=% ]0=n@nemtU2Af&ָu۟3Geno50s\ * y
 !叜OҗPro?cessorCw@2EB6_  Legacy-freeN[OPP+Vt u=HurOpopupPsinkr(sek.qS86$p62U-TPJ 3b(  PTpiAI KonfigubmasB  <F1=Hjelp>SilTin jonPYs+ sr"LagSwEk
IHepfravjo0a OdiO 8SjkQ$ dg avslEu	AVb,-l	/[sprogra@]OD+t $paȑPeaPeOpD=A:pOlUyrs5+p6 sOfunk
u0VtifS#  w)$
".-%
'F"n SmO!8 [L
u+godkjqbXT +Vneby@a	,{
i1trtz3!Tilbakel#fab SPA8K,-7 -,aV*rkty f0ct valg,!AlVp

%G`vt7 AkRCUBDQ@ܑD3Avz0SeSprA@lg `pK7E$LLuE4#T7rykd t
Q
4P =K, ESC=AvbrypAUTUeA`p0JoWJaYNei U, x
er=MUB \kQnepil\9trS<ENTER> hv0du v Qt. BrukqPq_aԗE:  -> e 8r MELLOMROM = N76E9 P<-dgTILBAKE`hrigh*T;ABfhfel!5{HIFT+Smkn<#= Gox]lUj sfUeaF0v .k`ԁ%nop@I c M 0m kjoresqyveaDVm0|d*wBJdPP|pJ1bap.a{flyPs2 0+ dg%s`~
:w{a]vPfullvq. akode 02Yu #a2v@{dupt No3blokk-m0ll1Pàtyp4`uhig f--Pgapv1Ôbuff(L1/L2Meng @P99QzeOdeo-p
T: 3r`trog%uS,kob9(bb7I,1 o;912i 2i3o4Gdi!,xe EP 
8\l(TȰ X/AL3Ek!AdpD: Dys0sl~Ar tidlPk5hol0_y Hda /h%e-  , dT0IuS s &Aklk'cnnPA:"vw b08rCeg1J"ִiuxUgyl`S 0fKSE3Ih n!PftP7fl?o\b3 qy ignoe_te? , HFT7(R )Pscl (P): 30នDpy3g܆p0%LƆstAfv0|fՅVa:`0Cut!6GCU.(P1vCSe'v
oL`#v,Tx|yribޠ: ID`h01W.s{ S.M.A.R.TC.-ၔ#V.G  GĕN <krefZKAv ZPS @fbU)aIa{ ikt /Dua{CTrAI,bwaE4ka g{ogs[!E`r dU[
Q|mpelH]6 B [ :Q..z7!o89rұQڱ \YpAט=.  bkuB7  }m0@fU)sg}Jvice.w,u O0HldT?D4y* !F_rw i HP tectToolscurity Man0r.5-ObElq=ilan!̋|pausG L`m@3}/S08 gie[ beCsk!Aׅ-QD- ^˥[2<|  . egleaxac",ұ e"^ ŀ. KmAJp01frard-,Para 8ll,븁Trdln k KnapUp"t>0S `- CD-0hA>%38  Ho }:rceg CIPpT SC _h&sgbb@BRUKERr!HOVED-0AI umu!9)с @C*350d>bqbeQIy 0` 9h`?Af cF Rb%"E&f0aF*& #==,aaC)c9  0#pp xA <K`89_? autom@0Q=Da5Lock;"xA=byggAG
Y(AB  @maъilgPge.qC ;[/DKEF fys!Qad {Ă4IVDKAY L0 )`%uO?P:&gnPQ6xсsQ h]adpda 'V`V%. UBbyom^d0'F IXtGu`Qс0an_J]` u)_Vnbefa! 3"
 wS`o{vB,@~
 A?Vk1qQ.rB%"swup Oa0Ojbk#e9
uBtspqdtUflans@EBe"f,bc0EGSC-JR ߔ@1`%'Vy'RQR F10%hC)Cbe:z6 3Ր'4  Norp:F4pOre0 MultiBaAy7IC*vOn7(ve"e)ko`}ngsba'8hy?RUSBtî3:Ѯ Zip-A A NuSm !W1t^BQ sFn/Ctrl$e CEq_0Q(USA) oekeenPXa7AeAl0-0jp^tro
deo ڀ2p:.Tv6isArrr  ҡw 
tip )C|@m AgsssPCsty1͞a%ticaQ\!  ve=0QEȦ (vpbǡȀC Eth`w1h2h3πoR  ͻҿϻҟё0sq ӯؐѓnip\tiGfik21B1ri/ 3 /N砾yFmbuKalibH1;Bes?=Iqp!l SA80p-> oo o`ksp.AO>OMndٟ

zO/O mob. >
\
 \\
_3
Q  
]"
[ T: LaH.j*% ]<m)fullvҢc)2)E)	.Y*M+Hj/,+3)qliA_6)3n0_5A_,*09Q,  9=&">Proslgnu2X D:$g~UжTknd@AeEit@`ImѼ sin}0kh (sekupr@ћF12-kIQK.PˁS`epute PиpConfiguraci0te la CompOadora <F1=Ayuda> rchivokmPl Sfma[gSPdTGuEb!tisco flexiuWczPqW %RnaP`2s!xW[KY/\K]valojxpfdo ]Pafa@iV Ign R Yambios ypli Of1Q+^I gX3f X<fif~gzePidadQPPUsedR WP"YnAonicioop]sn1Q Oposi;tsv
wIdcPVhtpQ UzdnpTֆ{s(q-[vSmFCNE SoeWc` b\Yt Sec0ntyinyc@ Rda E bbZew"{xs[ `c5pQ+^0{f'br9aOzcanci2+9Automa 	Herra+mipaCPer{S(`tdpaPaprueba HDD Sc] aQ⒚0p`FpTq`&Avanz Redi@m5Uԥ)so)8wߨ/ bOprimЏqui5tcecpQain0WK=H, ESC=Ca l4n>_=AcepH=SN0tq"g, Co=M	 R U`0р_chThaalH  lempo ?apropi`PlН1<INTORO> t`z]؏r|n.s@PPaut y:+EspPo o -> = Prx2+mRetrocesa<-kPa!Gir8TKABSfp0t~2Mays+COˠ LDGi8pӲFiErrPPgWo aw ` EEVS@NrIjo u ZSPQW. CdؠJR01ha7y n:un!Z&!ubnpbQAcAeb!?G220co( iBCebook/MEU omI7d9UqaP@Pb?_q2̠8IPpleQxitosaae Fa"!U`V5atil Ti@0{о#pVPc*ylGruTTama5memorp@}h ?(L1/L2MiҎvisQRO;M PmilpaVf1NA4riHaVv|0tV@
%TrnlRRVoFbg1z2	z3z4 Etiq)u0!{rspfҾey(ðaM'	Q?3o ZVE#s@Ea(WA XFEX#AdG0D :ưDxq=uir  1qeaf3_7. Pre]s_z$W/[, in 0D0s_sc 12Cua yA:7|_{&4QUU0 CPV@Q0!l_4G0s&`tegQ3q8/s&,A4PaGvl[|&I.@Z/;/o`c b}o(a) p (eaQBbd?eDE ielpf,fIlk hoLMP1 (RpPn)Q2 (CR3 (S.M.A.R.T.) Clcuctie1j^(@r s): 30P@оg`o .&0%QbQqdpU{pa ipalQi*ruamaR]^B: 5pu DVQ0aFal )gc8/aServofd 3P4apoyaa4fatr{ib : IDC exAO&js T\.orp Z~ nuev  }tqDp ApagqEVSw't5Io8evoc`Mq#zal3a orx LDp#adl$0]e Pa%ce	t~ AzRb   )񸛩,A!`V o,qa!i 5ῂrs/$FpnEaiBPoCD оAzp)Ar0vRfi9nR Sb{If5%l[a( olP =sUR1v .v.qqoߑ   tPFư?`fpFRa.a)dnAln HPctToolP}~EQuickLockXSuspen Blopp Idrat!	lSto@%9@mej pI_`Ozu࿄y	 @rl/t),P)V`p -u@iz1.=ts@l;re Pu'n roj	olThC?RedalmCBoq!CI2CD-2ĭ?EU/X|1zPU^:oUs%iko:b|puĎ9|A6medi!+rive`񦢵` tpUUSUARIO2 PRINCIPAL  E0h΀ 9bman p@D ِ*. A y gud@0lugIJE  p|jb. d #ΫR}Sb!b1 )b5A `0Bڇ"0.=2Xma@g`^orpAo_9  -'XRzRP9 )b uO-  9_, fsPm@]o!)@Eaz}/C,U 3M/@"Ϊ 
Ptu@lHC<иacscu=4b@tRi 0(pB 1ap2OdaWk os7<=Aorig!e oenfe
t`b ,lic4E40ireazA5_. _k 0i5u  At9 C0qnDTt1inQY{ E#0x"
Rofip`=@!\iPqFponsb#P4#F,y, ii^d~ ESC. b#G/6 f\1alab9''  Њ0F1034RGQ*:<~F^{Ӂrf a\@~Q' {R;TR\ZEspaol O"#MultiBa1PTUhE=Ab{co(izrRE:/F(echSBD BzRcLD` r`qLSurMkbLdhZipcLƐmeaaTe]r0
o C0ts PxRSpti`OvpNopDpp1l #o NucmPhǩ Cw>s Fn/z?Tè?Ingls (EE.UU.)qM u@!{lᨱm`AplA3SoA"IleubLY@Ser.n!th!QQ́ScQbÒ0eo Mo `Zb  BidiН3 Ta9m?Qmemxc i#`ysi fuPa 'bN#"CAx0#erg!osQ7\ Tp BI@FA(sQOior)qrpsEth`et,; NbooP+otLrw 1/xLy2OzrLy3o|rTok R$/zO|ρo~Eu1_v2v3 I@@tifUExclusЫ AFA@o?ŎVqVˎC4 <o-N 
p\ /NoH⍉HhޚOk(/ossbA͎???e HA/̟ 5aOϮ௧//kMEU VG?ڒϿOooϾU`VrJ_ ?r[1 1 :rg.@#% ]P?/Ҡ`H ?$2pcҠ|5Cl	e@$3Ҁ+ 2,|g* <f !_ԚšGha NQQ ProͲ&sQUblqV`o@U"dL _cy yLrran'qVpy`@d@"4Dg1PQguEx! GQ[8 6	F12E\5]A ^AmbTouchPad@#]u`o N$u@U*@aƀpڣ  <F1=Aj/uda>mrpGToInfo 9]so  o SihLia`c/mQCA8$lRrP t67 opadr0 x!
#h Ign@l` airPc8ss 
f
d-SnaQnPa :&v@@,@!D;r XR,_` " c!$!@*j<%@-PSatd1O^aWl?izacPd0e(O('I` iV`,`<,i1Reto /
8c3UjabpW`v)auti *n );@ek`197X)Vipa `JaFepMmFaspXbgH`i`"S?@lefOp!e T0lD=2`HD7D Ar /BMC? Statu <?Mu0l 08AA Av1k	SuA#i=B*(2oLD/NPaess0ke qPX4tinu@X`=KySC=C -eleaVAce=WbVimCWNaW, QToyuAHU=Mai` Uiiz@s U1G1>4d o i apGropgp>uP#T<ENTER;> 4me2jpNo.]gu4 fr ute: -> \~PWPAO =gxi<-1ioBACKiCEia.vh&TAuBio mpomSHIFT+nCoGmma=ЌX*SCpWEr`>Zp/@na*o0Vv)P?. Cdig\00>o 0Nx#hGx T0Io`q_{  ~sԐmir>xCAc AHxlR?evCynsfm"47otebook/Ɠ4Xw> :1>p=q>e?z_{u|2F+w>@&M2m xit"+=N  Ti0q(`AV +c=Pp	@`| Taмhb7he (LO1/L2Pƕaa{mG ROMvisFaml0Ap }sriRAv;de=VerdUroAUAn}q>qaoouG |դƤ34O4ZtiQe`pcZ)`e%/(U) 5@|O 𱙀H"դsecundaRTAdvert::  x摡0f 0`Ue!dm~AcGh=/,0Msi um  gravvH 8u<:v	<PA: n fCoiUp
N&3ǳ0 :BOG Htegia0MvCl@ө9IȔG TtezBsejapL?/
aۆ i_
cpN ~_EC1 (Rp@1AҀ@nv3@.M?.A.R.TAex0 H@j(p.): 30@ 7UC``C.C0%QbAucedr_U<q+hostr3rAv: IossatN@^EFalr!h@AJKJr0mecPML0IXpdJsr)
Jtribp=5 Di|vxexaapNfts .tPmigFov"#rЅH'
r4Dl	*@KL
  Z Z(@Ji3rrRigXgacisLgT @#Aiacmod
sNfpy fazqy82\50a,ac=6HrXa$form!%:d1JM,F2jaC^.dݣds8f"6`usaA`erM!1.И0 cA (@is³0rvio%Iv~rQ?)%AU?X5D"~ urr!,&ad`MAis ЅBS
Qu6QDPQuickLockЅ Suspenso #<Q!"@u0`8S] 5Dpf !! maq@^IYM p.a!"JM.+, 0T1h_sa@cBiib]XuseuExigL58xrewOqP`yNO) ermeO!cluRe2yю1otd!3SBCD-HUGRPTA4a=me:	usu: Voc`@ӄI5qr2ue oDriv)e9gH It	tUSURIOU  MESTRE/I_St` 3A0@/3+apaz.  . AVe02de-x0t~20΃is05+!0Vp. N@!v`PDIfe \,ly/ay(ሐƅ Ib:+_gaA Th\.8]@@@^aL+`sQaa:igoH",9B=IA ,-#JLgyilsug[DmEn#o,! 2ppLq Ca/er@(8a oIviwOyAo{z5BW`ar2΂g   
!}B+quRaw b2%ЁZ 3g ĒJ Xaf K0q,`ʈdjba ptB5ornala*e"`-0QJ #q8CݢNvatf`SsubtuCd ld1? J&2+ ApQ-l`$ vlCRa5۬7)Ta  Lembre q$e 	vpa#0 ^sa	quAias`5yeP,; ESC4@1]8PGClav 'a'Et2#F10.pԒAB)r:'M[
Ø!Aҍ
$% !Ougus O`I$B: Mult/ibay{Nq&RgBa ba+8copl4(`+0o׌di0N%tDSpdB 
2`qR`RzipCPrimeirrcCQmtQ=TO vNp5 
c@ A Հ@n9|GpWqc;s Fn/CtrlOIngls_ (E.U V\i@si1^D1qS2ݡhtro;vde\^a=cundaƘMoCQPadrA9Bi1R5OTaihmemO18]S fu-p5]1ecw CA Yere-agrnergpe8Xr\b "nsu`@? )Et'net1ْ23Token RingO
S?
Id
"f"`N8 BaQa!O!KSts0LSL
CNbQpqP$΀\4 gem .SpUl{CQrDuplo ted?'](" $*(&$o @1"#3&W$a&A ?)9:?5$0<3;8@AlC 2C4>E80MEUDKL G$OJDA LMOUP/QWOJ&[ Etj 1:^VrregRa.c_0% ]/^#.lZ 6`2:!c^]bR__ndaE`3:a7c^hS__Mj"a* nXZa !n_$ 2-[(HQL[~v Nmer"flex	чc `TqHB dapbRCPopup^ Exb  0F1	2`(P܏ d(s Var\qo&a Nu0$?Tietok`tukЉ <F1=Ohje><@Jrj tt Nyt jTallenlevykkee`adkV@onpoʎP uP֎t?Boa(nSsg Oh mu 0lopaL tRttFϘ$pou P=QurvPisunvojan s saMτri Kynѷy 4]k Latrlɢ tu2/usnuxt_Đ-t lyk0iu@ƨЯo[nuki'ǉet utsRǉtehd @։_w३tpRjAmainǲ#TykaluAkǠ2o PKԄiqa0 K9i PvytprO1Ќt&1ȲNALishieliPk2ǉOǉ*Jatkaimnll`otPٿ npp у=, ESC=Per@=Hyvksy?=KyllEi , OJoku!U=A谔ۡ vnuolicmi kd@0hǐsisQ <ENTER> mte.ŉn ss seuraavv:!b -> i VLINPPIN = T|Ts  <-rASKELPAL7AUTREdP2x4	ARKA[ 5VAIHTO+''T<V= d'_pxXEvirhpAkkua esoiRuda.'%: Rdi 301@kaP@art̂$ pytkeerkkoPtaasi@1?lakBsP%`;Wsrkann laaikk̙@skeyotyi eni@ ɏ 2np2
o!qEmjQhiQ. tyyppDPnúallVlimu %i (L1/L2M@  ROM-P@pѯotep9er	sarУ2 si 3s?tohja2! TK	?#Уkoh b1:$<$2'3/)a4*	taā	oc&$.(joa)W'-(2S*3+-N#-JE1kra-:o s: Tmӟaatnh >S. J t luoRupus-  Վn,@ir1j;onsA<	A: LCSESDDh@u EFCEB@C  paqABB_@MgH&?ko
i0!`=n?@{PQ 2R  U?71 (N1C[2@\3`.M.A.R.T.Arvi;$ (min): 390ʵs k#0%#&`4[oPgIsڳyśiaˊdehVB[3Uhu`~C hKB*lServomootytP*lLukuUL	tuZ̈́h}k0;ttrib tiRkpPh #rk ay ]re`Ke n .x!p> Uua%Vahv! py P<̔si{g|} ;$1A2Vy@0~Ba	 z҂-S yA<䁶nRokk`Cadan! /Ϣn<`e0fu| ğ<fmys   k h ﴻP 1Ҷ"e?7&0:pTQ@<>Ri BjP?O un'ny0b @veapahtum@B<@id0e\&Ta1aBW\nxԗ@tii xP<iHP P`ectToolsưcu`ge?r -apu0"
.-QlQuicUk y!nhPl0Q%aIrQ`O0raAYQ-ωʌseAkI /JiT@A?d>> >yh k2  s 絥i1Ǆ.:@uu1@Spo}r InfrnR<E0LangkTto%ҝinikppCD- -qlԤIa=D=tWpP~j0wAiotsbB`n D oeí(q#') -.з KYTTJNIaI PSSANAN,ضC"`.laIpi@siltcurqu  r0z
PA
AtV-P,A1>psQupAJV{gLLA<g< !Oq%C p  2( su!LZ(bIߵɌ,ty  FܠX_A fށ߁ 
 M+%" Ю. Nyky `GHG_ EsQ:FMt,1. TtdjGp<9/
Rsiheialku0DDXehf @كp`A@@Ju@b2Bt #ta(@ /A
aiem`fףtG. }F!珁mЊV
d|tRp Rpx"ђ/ζd4} e@rP@dkko@!ڄ??<SD,>ESC-n2d#?[3n,@Ճ҂''c4 F104@Ճ8d-aa U,:9 P7 ?0!(}bmi~&ysςKn MultiBaPx)EwqAlakoiE ( 1en!\/HDIo]USB2L L2LIGALZipMEnsimm@5 Kyo eljՓVi@Kꀀeit 7 RKak氖 YTRKym쑕Qum2@p܀Vai Fn/Ctrl4mpa(-CEng0p](USAp^UsPS s0inla 9x.BLs\QpdSnqjКOsi_!sz`V@olhYt \VakiIoSsA1`N t q_e@uupSVr4a0ǀm V`#s  op5l6|Ei`5 optical device d =pMn YJ (ylosL?rWsp#tomEEther
.J5x 1Xooyz2{?| Y3}JToЅ bgz߀o}o<Jwork1 voωB@xLJliv>V Akku!C
TAJf`ſԖ삒joPlib
r\u _ߖ?do	\1ual0F-? /ˠtb/O! ǜˠ .J/O/ǜ`/O/ˠSvao ǿooǜo`očE,aa.nusQkP#I$ Oͯ ?_}KO߀oOoR[ We0:b6a@+ .0C% ] COdᩘe20lpP.>ur'e3@*f᧘ ^ numerPIn0'  SpeedStep  technologynL+gacy Free u!C9 _"-kkpcqvu+CcYPVys'iF<`l  (se\AnAt@R@::@9F12: 8DiLPtapp}i19koskeAp 6<`tpmma0YK  Ei mAn Configuratiord4teur  <F1=A`R> Fichierforv m	AffPage Sauv	rder sur disq%upje&c R'ar 8`9  'unp5 A.x#!/$T %ePlalPs' dfau0Y%Vg* {duIgnoe)modi@$02qu9pS  e l'in<@
C"apa .Oregg./o45A0<1 Scu`-e'ssdxQ73 r)7O;e<*;1Y?e sous@PP:< =_@on.^: pripqh`EP <a sDRJERIDy-<'H;s=DqU<7KLDSm'CD`r@P^`r1*he~E8 Q !@1aO BPsTGTD ygre tab- YE1GX/FX)'amp7 N'usaPQ3'/SP:(rfrenc_Ha>`FL *0tEOu HYlonnsTb`eribYij sle
cn i`qQhBus`-"%p-pAl @)QqmnEYj#!1rFlPY uA`c	angE? Chois0!lvm1d Pr vL%px'xGyzZE Appuyܴ$touspo!u=S6uer, ECH/AP=AlAӁM2Accep|P9O0=OuiNcQ#9, N/'imp0e 0 Ԁ= r	  U z)s flheGam`%rRa0cle t-@u!cer$ bri@
`e/@z <ENTREE>C2+1#pDD)suai`PnF=  #p :A-> ou BARRE ESPACE = P_e-ᚄ0IEPpreced0RATABChamypMAJ+ _e7ݤ0!Ӄߦ@rrP$=i Il an1ssibꖫca%j Ua3s'anprod 9>endP01. Cox'01 u)c&ln 1 empla3ce@0L'p!04"lQanre0C@pvlƴsFeccueil d ѵ$itxSmobiQ0a@pP9>uOo¦2i3ra wru FacMP TyQp2CpesRV8CDbγTacas(L1/L2) VolBCmoiVer"TROMPmBANumroZql)Rev0wdґаr*1clav? Io@exD 0Ay.k0kHp/k3/<t4aybinvᶀBprism (te) _?_@yQB6le!dQBue0C!0CR̂oe){truҡ) vi NuN\& `Pb@YgZ6 /1p_#", `10ez n,roY`Ac E3 1Aa
$D"Lxv !tro@x'`ycvTĞ  v )#Ia'T%I 

:f>)*Ep-vC0 BVlp   ,?$?.3i8?63e?#!"p T~an1 (rap}))2 (coet)@u@Y⾐:0dim(>)ư30'``s ].0% v:F")r") y!El'h")X ð*Y1$:ˬ+(b9p4cXPnu6d'
6vm8L5 supSK
6AƐibQ97: H=$b @AVpt?s S.M.A.R.TAban .cD AXMN N	aiE Vfءn\?F1saqoSoz/AA1 Mar 0iiFn<YE Pa!"M!&eXM0R70cQ/HMּmme, avGKEJOad,Q%ppobligatr#N%#p¹dIQ;V pePa1Ya H~ s+@, sr_ű^  formeAa mRqs4.<rs0WEB|!^8\@p\qacs&. 5zXIPnsis avou0W:MA.s	rgStl\ j kѠz!"ZpRfĠ  [=lҶbtga,aɁҠ	HP P
Tool Ce^`y Ma!rOD_F46_Q me ckLocks! 	ɔ؁eri "3KS|auarej`
 QY%BeJV,   m(^ocd  _e L' msuv9 M0draTn2 , g0~Exih ~rZu dP> jra8 	gll$^	 RsHsq?fil Bo- x\ CD-E6JOpalJOV:Qt@rti( Eqe Driveу. S3mmmmrdez deux,(UTILISATEURQPRINCIPAL)pcng(gآr0c*Cgښ N|z_n@	Q P:t15q Rsr @" &fe<0celuҖ`o|ordinD\. AQG AGStm@Ç W-fetWP+M0~H`AarfwFojV! Oa_ a+n)u15x(
ʚaniq Z TZV1P7r,Ac{0~?T銐ŒmT <VȂ 9;%@"a:bf(IuelMp	#p"P ê ?Ropap" рҁע\' 1d'originIlv`Rg	ra$$RuXvѮ*a@ʉitPtи"YPdjblv`
s(S.PYe  POT}F.(&
ڠaRprPnt0~j!w`?1don: tPpC}*>a0rp&abt=UaF, appuy`	0a: ECHAP.
@ WPzP'F', pui0cr	F;100~Tap` 3x`ˇE9$ʌi1/Fr/ana O򎤆C3iRgMultiBay!e D-?,U-soc25a(ga)/02) U` USBƠacb7h.z7Ziepb7PG D0i!s;Qu9a;CinP;Sixi@g Sep~a> Hup>Neuv;D0>;Myo num! Permrs Fn/CtrCÅ G*Angl*SA) PSphSPco m!-0s A0xstan|hnd'p7пadp܀{eltrul#'@ich& erx&m{>p#ddMiidÂoAq!BidpzqJ! mCmWNQz N%V1dlVjS	al3dy GC{  d!
(V3~F-bloc-n|s c!
Q3 =`7pF^ aY24(y؉4ccuO_d`hja'bBF[ EbLtpNaf 1aNgh2ifh3jT{okRinghmjml _n5s?p5srIduIptVyea0*4z{pV /}O~@oyUO|lъ?υnGre`PзτAb`Py [cDu a-3bߑ? _ߒ?Zx φOo/OJpGgn߉?{_߱e 2cXxt0e5x sWmoP ? \5ooOÏȯA[|pe 1 : Char+.S *% ]P)NC׊'2D@LωC~3R`I؈v*it  =^ǫɟ8NumroroceP
	AwT.AO.bOlibLegacy AmorGcSsLbOe Retard1exp0E) DE!Fs12Q.posJf;Gi`ɡ7!Gux
BaUtP|WGcun IHzJlrC <F1=Ai> wnfoHemalP40d7Salval ?floppye  !$ P
CttoRipr
in @0\$1n
ipxfa -j<`	
tIgnorp%dqw0ed esci E !l'iz@ +
irVtupMicP%zzasskwoaeam ratoAN Kc`2&o'Uccɀq(vosW3 >2 IDs0h#`X)O%PrfS0Bt CP SupoAp\ Gi)()(LgQ pV-/-/			i fabbrw*8Ii
nziV`*7&*RcoP0ruAVi CVb
byau>U?Vl-0Op61=[to rigi-d0OAtUaB4gCd0@w@AOa lo"mFA Ava*t0OLquQ 5A8KAvvi0O2oLAZ"&GNx"Premi qsiaUtasperuP  =fK, ESC=AnnuHCU2T;VaUAPt@e.?V=SiYNJQV:A,XSalt T=A\r[V U}sbchiavp? frecc@aTGeviC: v<`u ap3A 0S<INVIO> cT@`a'CNe.^i& guAwSiUTe  un%f:0 -> o SPAZIO = suPss0D  <-0jBACK`jCEj`c1:8TABjCakooMAIUSC+0ohn8= YoPVAtVtErrc>  QutBHnpusex"0i  v@`0un ewp>. C0a'4}01 Nu Ha!PSB*llogg;iaao L;~E@p_  :ainyFsaaggadv z0@   n3book0jq"espa+taT,~`>3acatp@a;|?}_~z2V0{x>riuP 0
 /duA{ N  TirVeloЗ>SteppJMisaca(L1/L2pmeAGR`+ROM Famigl@ᡱegǚG`oPr+TrollpTFger p
݇cII1ϧH2H3ϮH4
E_ƚjbeƚl
s(T)_qhOi2?Z3?Z4 ?SOonda? F4A@Mso:%~=gger `x T@bgun	 qTcreQ /r1C, inaTfavx  sc<ir 8A:dwUTA:RzuHaqonoPu!0c8F Is3P!tVQ N v:d@j ˉFʌIRQy	SeAàvo'aa 5?
1`0B6" iRl0cre?;0Bo TB1_ (RapE)s:CletRRptip=o ()O: 30 c@7o .v0%@0Jdars0h@styw:5s 0g` 4K!T`EQ[@5 g- {v  /@Lazsp37p Drib@= i gol`Y:`#j0w2an:Sde` Hi S.M.A.R.T. bu.3hv `_hnuoAlr
isH1lDJDJSCJc'ambbdC!Aӈ5p{rUt%NQcQbavAmd "iz Bt HN3pmfu`:ԅm' s'ezz!c" A78.&cF/5wAcoa2erdЦ@6=@Effi)so~Gin  ca )"> NCv1ipaUy,l-des`N $Yep PQ'HP tectToolsVOPRF8 )PyickLocykppspenpBCE00/moeusv( M% PKp8$%,"Gv  0/gra0#*?@e _ ! *"O'c( G10jpsm0q˱̉ wL,!/darМi  li&0
R1PƱʂa@ЃZinfeeZ3p^TRwl0 PulsҒ^>Ao CD-`SٶŒ<x
p [:'ea#!ȓTִup_DeA. !D1"B- 8 1pbv2'UTENTE0PRINCIPALE  rB@mha 0man<fYuPo.vogVq7n0  g ˱S e39p`q(Rtp֔.PlPǂu`Ka-sn,hu!4iяsabC/hpMre+ln.q4ngG Vj'o0ԥRkSdQ!LKQJQi| Nrea,/q dpj2`{Wsk#O5vrvluogo  PxDxB7z z0t{2gP"TG/#d,ؖWl oɀ@o|wL $4'l00+	srmp$ 3{0%GVj  " x`74@\/-P R0coqP0/  sg61vi& ׯ%'_@tq7 Pua7 Ftrψ!lIW4Cquj{c7.r> q	Xs'&	sqn?q0ѩ%"0VVj,+mJCo ESCĦ79'dov;ƭrp 'Vj'0po+m!lF10.رmq  ePIiG  Op-(!Z:t]Ez M;iBay baD'ggia@e`s) 77#Ihi USB't]Sumk]ZipP`oF:`TerzF*O@vNΠecfo C 'Num(#ZA;TC Fn/Ctrl TC@
Ing^e (USAI)ic#upJ6R mpl0qaw> z*"pl2!arAZV@7/BMo s\ Bid!#![Cap}a  mem s``1
 3em+BMsbl1T(_s3ma'energA 2eviTdaj=N o,BaM( w"o)<sP
 E{thet NJ
 18283e Token Ring ``3 IҰ4 R5?BZ _%&'$PeV)
*Cbx().D`,Pڟ,-/3` f0zDuY 6+/,6?;/0 /:?35GC79 BHo<=/GL@-5_#o/M_E?O_PUI`ST?M_NQa r ÷?]_^R\aV.W`/fZN
mo1O_/iOjmk cOmonmkhqr 3/_uw/xp/zO{Mxt[ P 1 :0yro .#% ]pςacomppR#20SPN30r ɍ**5yC" ᒿJ=>diyOs/~mu0ڢԠ0A֭  FloppyBK legacy A`QXadp 1Ra(sec.) vePc0F12%ӟamb ʫN`u  up <F1=Hjlp>`rkiv Sy1/infotP"0s S  pkkiCguPQ"stll frnϵl0h䢶n`ar_}d Annua n	 ochslu@A2 anpAê Sker`dаtrsl0   Ka82rt-6Enssvǉ(˒-IDzA@@0tQd-Std gfr ut!aav 'ֻ?~byggd ,@usi܉|>Yabrik;וXJsbehsktsSrktyg KRyr v 
p$ Svt 
pbHDD Akp6씱У@Y;ljprk{|θze>Tryp0friu g@ n0quѶ st=, ESC?=AvbryFtA paq,", V=Mer pv  pil$,ڀa yAt5<RETUR> omtt
. eQl5j eer  [: -> @X
MELLANSLAGSTANGENTEN = N	f<-
BACKSTEGFregÆe	ITABfl (KIFT+#f0?= F?v!fel Det g1`1 k Xt h`  stod u	
en. Fwelkp$01  _finnsg ꒵p"plat0`tʔm krv%1 @0pm flys t  U-dator/ ex ԝ,O*p"tidig#$%Y21kl0T * k}Nd,1X  P5, ty=p*:hastH:ZgCa-4rlek (L1?/L2) M&S> ROMP Ҳ~"@familj9~enummnpdeo,@t@d$bpyrW,HBpW 1.$FG2_H'3I'4ZKrArG'9inav`pH (b)'I1F7I?SJT\sL<VSek 5PVar! D`e(3Q  3<}nehмx")rskap "/W-ԹaRi2kbqt`0A:&ó 3 K53!hicIr2bc7askyddad %agD__@_B_ f!pq!  udn?0igﾄ?v2w6Tz1na#bbpR{ fn3pRU4kPad kY<d }(`): 30Hz p!P0%8{ l@ 3sU4ppvirP(Fa@tZ%:@Z )GOkp2dSb| Cervo-Lr Α20
B!VVipttrib?ut: ID`&<% d grr,.M.A.R.T.-e GammAGN-7 ifiunZ ֖Y LT x"E 0JD-vAlika mp	 S՚)'  2f"InŖ?ʵkan orsa!rtzi./r``ǳA[yp
 ٿ0	Om 0rs alo`. g@ba om hglqm
tj{ehxelse0	<resu1iuz мf0zP(0funD)p-erl3\i HP @:tectToolsvy>Quick1Ӳ telge #L.Em Hgx܋ݨ	g
pbrhg-éј@:٫ӯr ngo2@ƚbli`xRҡa@bt.c K *omJpi9 f@Pt6g,pXTrdt<8 napp -CD- A0>cВ RkSh Huvuғc : D\ph_Ohrdjd. #N
[ ANVHUVUDQ(hedl -`mast w. Ba<ѩ "q" ((^ild fr`f!/%D {1^hvv   l 4A(ѩrw.߿ౝ  oQP(!b=byggZ) g0od@]a*- O똤p(omSh  ".bx!  Ęas r!6Щq\rDktu9aI`"ҍQ(E!fa'nѡk2.ut!ctg8sa[oѩ@фur?sprunge -h. Vi  rekopG5v4qҍ rA`f -a(vs':.b. A_ s3Q\!]dZ,"ǧO 60ӥgp<!g`!(\q5-be0fpsem ih𐑰`Ffljqns .0 = ESC-D ҍr^Ɩ.r^Ʒé֖&Üqp3'&'sedt!5aF105pC<
1a:ݴEs 1BPSO~Q rн~:MM0iBay]MV0LG (@rrRIhǱ}SBjAMI@M Zip-#0̡1Fj1WdttoQNPTRNum r1XVxrFn-/Ctrl5@7 EE0fls(USA0}G`kdAMa1 b~r;ms0stro,o0bbel0i0Forlekeo`-ne Flka$c_p!  w2Agg yspШmhaZ(AXH-b,dpticapevic1r=frutkfveP# vP-dexp KNed<hj EthJ%em 1lm 2op3oqn ToRqo[t_q[t?sNC/ujz?w)||?yUnik _@At~pKѺiE/ptus İφS Sb|Kalib1 @ݟԋbSAߑTF_Dualqd/G/ /E&dߕ VϞ?ϙE/DqwsߠQ߬^Htag8@Eo_VJ Ż!moZ~ Ͽ//Y L_Ǜ_ʔP̈́x[ eu : Lar 9.ՐE% ]pE
^0klar2gu{[3gom:/6* &F31 {= oA%`Mbre  Legacy Free"T^TB36Z|a1sadapZlOdrjFsnabb~T (sek.M>F1|$^GYBd:Styr1lPPYpZgJQeTn@Wѐe`-9e @R ~OpMegslaan Configuo  Vanafm;\v 41Fp
ardA]`o scWij7zigneL programma 7d ~Setup
 zQRr w d
2ospvei#]BeheePrswachtwo!WBU	T AppP\atbxg| ID's&~ !SmC1 O;up
c"mg$ZjQT8$Ge 7b0a0A3 g+;sv zie]+*rFabriesksZugz~%	'(V'ref	snieuw2]C5Ec C ExtpPAccu# Te,@COelec0,a=4ges / zOelft&aD-schijfe1iPZAcE/@`OAfB=a D
-&>= wPgp+apcQValVe?hgesLLNuk pB0`1f
g=SK, ESC=Annu \ ~SD qST0= =eTSJa^CXNee bXfai0, A5!`=MPnTHulpGpijltjQRPgebruix@d=juiPnukeuz 'ark	<ENTER> indQ4_ZL
be8Pa Gvol,0_^@RL  
:  -> of SPATIEBALK =Geg3{<-!iBACK`iCE jVorigjټTABltevelPńHIFT+nlo+=  	?Wm`XrU=!foutG`Ik@9t w3#ge$ŁJ FwP@reQ#tijsen. zcoF,011x apRi-su we	  Netvoeqqre `CI= = d"5bas'PREy#~t np notebook-pc/? Z@iastB.'wC{`qbe`bigdz{|2wF0Hъ2.xt Nm0}Jyp]roces=saSnelGWppQ Omp e (L1/L2pGucapacZiwROM-Revisap3numm&aą  He/gavRGvideoAkpw7`eb0#Ptro9|@ "pGR>mI1I2/I3I4IisI0t7"~j3e l1ʪ߼@p(/Gedz)Ť o/ﴄ3?SecuPip[?L yo'p: UtDByt a9s engew ` P1~QbeBr@BǾ Pb d1" A:|fg-  /  a`0_s
ge6yqoffvGRƁ~Ed
b
ᙲIHaÐ~o0gѿtpRª9We yu@DPa!_qZwilt ?aب	aZ?n(-ZoDBTq1 (z)32 (U^B)P0B10rA (.): 30a	'&.0%AetooB0HL Dho3bro1_:GDxќ1e1㊠nbաewcwc`vo=-	leeswGD ýyR5}B0_k:p jp}6e S.M.A.R.T.-vaf1_. @ud8!R9 t8'aBlob0aCa A0Z C G~y`Rz7kQvn`QD,sls x V!y2\`dis ab RဠOtýRځko, Tymoijk`vR[.Ln zostpbdg1vvorP`5(a&7 Q f24,bS  \gxـCerlo|AZ y}z!4 	ub8apyf65houd HP8 -!@ PU5}/&Svu9H:cHP PrctToolsEOMOPv $4 g`C:4Z9 Tam_f6"'hlX}+g`rgdpb&R  Cer,h,QA?oaOh / cRvb&Qf+ k`t Pk Gw sQ_b  ‣9J:R剐pPfrarood#O PaAr!7Oư1DIdloo`etw KnƯR Cd-r g97˸UNGHoofdrG^i  U `#d˂Hia TBPL i&!i0xܑH zow`4HOOFD-GEBRUIKERSѬW\  pf?an!&IK SJa  RwcG3]~ fy`k?Нcomp`fFaaaz_s xaaybKt c\ VߒOnBhMQX.p[ F ap[(!Autom@/c]F`Ar(enr RBJA/BCHJ ocv\/eK菁s8h i. Mo $Q>P!=tIbp,   % o%4rP?utnt p'7pG8w#xhuiHU\d wwasn{p^pSpogea; ?. 4w1nvloesg! /kP8Ia`>sPn\GJKUrQrak   toBc	p B gesjt. o*@S`枼>. Omun⠳q fE/! golp/. A\q]#,L$Hr(h`qT^2 rukxa0ESC-М `p0ϲ(!ᶈ^ r%B'^'tytBkSF10ԑp T`jr=,Y cq	ѐR%^Ylq  1Ne0lַ1gq MultiBaygl!VI\!vld }+base (k3s)سrep2Pڟ USB-Wcc`RUcKdPp-"R3 EB7we0ԁ?V1(0?Vf!?ZKesZ!ANp!!Status Num 39Fn/Ctrl< rwiss7GԀ -da!VMSijsappĐP4O&+'e  pO>n1 ?l0!"YgBijgVko-Q䠐P@fd0ditionp S GOAXvg0uq]JpntilatpŵJp1SdPP`1r< urgie#pRE(bo!te)b'T3Et?@S 123ToђR+ rDS
'2G3 U@°kt 7]a+cuӜcc /O SJa\GekaliPqKbB/-NQRual1<:!/-O# `;:O(o$C*'RDB7{"`/+%1_. H!pD1j3:6R?383 L er-MUE-9:>p2CO@5  R܀/C:OEoACGD  [p 1 : BBaopjk.YN% ]ӯLMNPtooO2+PntMuLRN,O_T+QO3,PSMfLY@[CN,O_\y]vQ*aHQ  a,(%6cdBl Modz  leg'acySa adap`JQ(wsec.)pop-upRsnB <AF12 mn)%bb  cu_rsorbu EasyPo0_-muissGA Rs[^̃ZbgA wviSETUPj <F1=wv> t@C vVXeyɊAz\܂] vt wsvfByNɕۑ  ݒ{|}O|f}畜ďg~af yHxga~  Ho'׎v7ya~ςɖ߅BύXɏI  BAȌԂ̮܃ve}ẢH{a~eǏp!ύ wL#ㆊǗ҃pyvho㆓d/`}o`yX i6@\̗L/ByIDyID: h`yuN O5BA͍X}vg JA˛xv{vT|_x'l ެI" w+F ؖvI&cvyo we̒  I!nAe} yeyIvyOoM𡝂Ɇ yơvX{; ڍ# v|p{p߂Młu 7n;V&BzL[B_ p=AEsc=8@vϱsO0=͂vӂզ  AAv2Уx vA\ ΎgpAjvڣн`ygϹ.p[Eqk]uzȉځA vtޓ->Syyvo[ =   <-S[BackSpace]0ጥ[TabAa yB!aS?hift]+% qA桊mF[e  !G?[  v͢łpzrƎ 01 '!`v񯑕`ɂACOڑ~a{KvbO xH m@ SMEUBȂ#2R󋵅 {ýCzޯ    ޔxݸ  ށiL1/L20xr EOM rW 
̧ضرٔԍ  ޵ ޼ ް ۰ׂްޯ
 ްt ? ޯ P*c234? 
Ű((ÂC)Vg-34Xfy㣸QJ@v_%#x:sƁAǂ B`{ׂĎt~/a}p&쐬֢A: _݉`ǂ|}})Ϥς 0 H,FG/2,&C4"& -֎~@!)R8 9O:9}X,O//cC  B뀀9CHC~ī  BǏ v|GϽ辑J1iÃN`y0x2_iSO3w.M.A.R.T0x \zsԁij: 308BR q^#0% S OK zѼ=鳼~ vW'f v:ʾxRIeZm QGZ-]Tzv{]ǂ^@ZBsHFIDvQ.ae@X .sh镐V!Coi) R "0 ! $ v͢@Hތ̈́pTqNkxp*8rvC4߼x߽ܠ9!&d-z`Z60K~xs`{Ȃ--@K{ Q)ţd')z}Yꍇ5*ړ i#Xapq YƂ VBW)s ?CdHP ProtectTools#x}l`WŒǉA%3Z' Gk1¨_DOTáu Ta#h¨<Hɡ΃){tEpo|@! &GjomzWی?pyIi蕴 )H { ٔ"Q`ؐċN<zvb犃A٣ԊOqo4ulȯܰl  CD-
ri0 予^P' }"^ k:DU!񑀍i |bC6LbPI@ qKϵ }[W" qӍTdv{8 Pĉip,1N͎V} ^R#sڃ^ASCۊdʒA'Ƶ`OLb$ 2{FS1qjp 5Ì0e ۏ؊ԓ ł|gۂ͗LBϨ}ł󗹠/ )@K &<d0딗jnzbȶ H^"ǐnzx^S ի  IɏӦ/Oz _zۤw܏ݩhgňð3Ϣɑ8 iHbƈɐ%	 fɉwe^,
Db߂qTv䂆J`ߢc3  '%ȑO7bOC'ts{ %rV,Tl7XQqlӔCx!҂"/±[Es3c]0>dȍ~X/(ޒ`DriveLock t"[F10+@,n!u}:0 f2 3%( 1Od?#|?~QU	$}@V`O: k?xkab O xXBiRDEEFUSB2IL2IXpJ Zip61Ԗګ 2M3M4M5M6M7M8M9ƒM10M@Num2Ä Fn/Ctrl+̐ؑ  {@p (USA)`󡐔| )qBCGfo )X2IKVcJvCn#g 1b}mZJ_[rJIo0 jW`ou\ @QXCYg\xO!ڑ͏̧w{ gȓdXoptical device dq2FEFghXAEthernetiXEl 1lm2nm3_p {gN i1l.s2Ot.s3$vElqrNnypOpyrEjas ID 0Wb>> C Oog π~āϐ?Pψ5 f Ph/ 5_ʍE ߔ5ߌ ~,H_5,
ʍnpxh/ߨ5MEU EF4/%ϲ OH__߶@XQabv1 : [dϒ .>% ]=22pŸoOăv3pģ	˃Ȋ	*  !O Chj[^RT ipxoIIntel c SpeedStep0> tech?nologykk	 xIWt@Xt^"z _Y094@ް Ӱ #@]!0x(b) P4F12⎞ԁi!bh?VRW >^)`PbaTQaB) *_ ?_ ?_  ?_ 	
?
_ ?_ ?_ !" #$%'?(_)*+ ,-.0?1_234 5679?:_;<= >?@B?C_DEF GHIK?L_MNO PQRT?U_VWX YZ[]?^__`a bcdf?g_hij klmo?p_qrs tuvx?y_z{| }~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ß ?_̟ ?_՟ ?_ޟ ` a b c d e f g, m>  2    "   |  	 
 >   X  
  r              $                  - .   / 0  1 2   ( )   * + w  0] Np% up, p ]]"]r#])]0]b6]<C]RI]O]U]0P0<BB<>"ب0`8lƀv x|ܵv||p_0p">  " 0  _ = ~ =$$$<   DDD OaƄe  i  o䔕 u _ y nzA0 E  IO vU   YN ~ `' ^    y z ~{ [ ] } \ @ ~ 2 V|1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>( ) +#'?
({[)|+}][{]}'@ (#^()\|+y~ z# {{ |[ }| ~ \ ^ @ ] } &12"3'4(5-67	_8
90)aA0$qQ'mM(%) +*,wW2,?3;.4:/5!U@ z {
V-+*'(as'$~
|  (9)*+'()+'* ,-!//01F24./6?7
\1()|2:/5<o78'5 -=
^~+]}@`)  ';+(:*[{s\_}\|    ]KKKX]LK(KPMPMK\]PNKKOKLhL֐L(]FPMPMPNOzPNR	S
  ;U?@ABCD!	: 3 ]! aM`]^]\^c]
e]3[P\>]\d]!_ STUVWX2<
 Z[dQ 8 Z	T[4\[]*[)b\r]\  S^_`abcXd0 Ve\]mmmm/]]PnPnAd e( Ab( 
kVophqiqjq 6 :l Z0l4t4t 4t4t 5 	]Ve4t4tPxHxVeF10 Setup Imageq{_SETUP  4t`	o 7 z6u4t4tp~~4t4tp~̺~4t$2<Ptx6uPtJ
s(
`Veo#esR: s 4Ъs|0Ve*TWs0zU!"$4!6 0xъժڔܪxTby2< 6  [Ve  4t4t4t4t4t4t4t4t4t4t6t5 DQ6u2<pCtU`	05 P'EV2	ua@Yߔ" "Jҫ?Z4 LШTbTb>TbTbTb 4 Шx
4ͳ@OoϹ-вUШVeTb3< 2< |2<" 
Z 4  vԔC  4  U@ABCDEFGHIJ/s
 fVe!Tb"Tb#Tb&TbTb'Tb(Tb+Tb0TbsTb<TbKTbrTbwTb5Tb:Tb;Tb1slaɼODвIToPx0Ve4"
W`
Wi 9 J'l4m4nRвz>\T\U^d\2fP\U\\~\h\UP^ffff\oTeq*TrTsTtTBT
TzT{T}TuTvTwT~TPxH m>Xbh|m> PFP^PPPPPPPm>$4NZp2m>">XxP4PXPbPlP|PPPPPPPm>0@^jpސ .Rpm>
nF2 j Ux    U    } 	m>U:VhUM
`4UH\tm>6	V	v			֚			Vv
m>*H^m>4XhƐސm>BRhm>8^p~Ȑ" X(PPPPP6ZdpP lP P P P P P ZP P c" "U8"D"P"^"Uj"|"""M" `%J%Ut%%%%S'\''e''E& )p)))ঐ)
+b+++++,,,,К,,.P.nP.P.P.P.ڪP.P.P.P.`0>0\0h0t00000000000֪0000	55$5>5R5n5v555555555Ϊ5555j555";0>;T;p;;;;Қ;; >8>P>h>>>Ȑ>> m>UL@t@@@M@!`PBpPB՘PBPBPB"T#ClCCCMC#PEhPEUPEPEPEPES $`)G6GVGvGGG*GGGGS %PJPJ,PJUJPJTPJXPJ\PJU|PJ~PJPJPJUPJPJPJPJULTLLLUPJPJPJPJEPJPJPJS& R"R@RUXR~RRȐRMR'TjTUTTTTS(`V:VLVUlVxVVV5ȐVސV)`YUDY\YYYMY*ZjZUrZZZZ5ZZ+ ]U0]B]R]p]U]]]]S, _:_d_Ur_x___S- aTaaaa(.m>`c[cc / PdlPdPd&Pd0`efeRUeeee5Аee1`)hU"h.hDhThUvhhhh5hh2 kUDk^ktkkUkkkk\	'\ASk3 rrrrrАrrQ4PtSbPtPtհPtPtPt5Pv<PvAvhPv*PvPvPvPvMPv6#yVyUtyyyyMy7{R{Ur{{{{{{{8T}}}}U"}@}^}}}ؑ}9vPhjPPP : jZ;g6PURPzPPPMP.<`퐅֐"U=g"P.PJPUbP|PPPղPPP>TnV~5Ґ(?<P|PPP@T &ꐍSAЎЎЎMЎ$B5 C`P5PP DnPULPPPPS E`ГHГnГ/zГГГГГF8HVhlptx|̐jސG*Л@ЛHЛRЛ
8I`ЛA9Л9ЛJ:ЛЛЛ0ЛHСA=UtССССSIj5␣J#5K@5LvՀ8MPPP,NԠPPPOT cPPPPSP TrʐmQ"NzI}JȐ萭KLOLkMRoNO<PINPQTP\PUnPzPPPUPPPPSSPXPtPUPPPPST,PDPjPUzPPPPP U`):ZnڐVпLпXпlппjпппW "8^r¸КX`)0>DjĒĺY#PdPǆPǮjPPPZ`hɐɺ&[`N|ʖʪJʺ֐AhM\>UZl΂ΘUM]8Lftсmnp'AѨj^`PHPjP؊PبTPPPPؓ_ @RtTۂڢڰRځS`PDPbPUPޖPިP޸PjAPPaFVnxJ~USbP~զԐ*cT cPPPPPd UfxM
e`PfPꕐPPP!P"PPfT
8DUVj펐5ҐgvPU^PPPPMPhpՖiT`̐M$j#5
k`PUpPPPPSl 1hհmR/ 04FUhU̐ؐU3n`Pn`P$PBP`PfP|PPPJPPP
8PA9Q9 oo:JPHPXP0nPPPA=PPp4Nh~q &P
P
P
rQPPPs PPPtP
P
P
u`PPPv`PPPPPwVPrTҸ
xPIUVPbPPPPKPOkMϳOyQE*4RU^btUĐ֐SzVXUԐސS{  > P U|   ̐ M |`"<"U\"r"""M"} $H$P$p$$$$$$$~'@'T'x'''j''' P* P*BP*`P*zP*P*P*P* ,J,p,T,Ȫ,,,S"`.....T 0&0:0R0h0Ev000000 P42P4JP4`P4zP4P4P4P4P4P4c&'q&AP78P7XP7zP7*P7P7P7P7A٫4>N>d>z>>>Z>>c@A:ALAEZAvJAABAAMA D*DU:DXDtDDDƐDԐD꒐FF~FFITIvIIII JrJJʚJJ PLLPLnPLPLPLjPLPLPL NBNlNNNN PP$PP2PPDPPV*PPrPPPPPPAUPPPPPPPPS`TtTT5ʐTT`VUjV|VVVMV(WzWզWWW&T PYhPYPYPYMPY`ZtZ5ZZ`\UX\~\\\M\ ]T]Ur]|]]]ծ]]]ԠP`DP`PP`kP`nP`OkP`J~P`P`P`UP`P`P`P`EfA&fŞ.fHfPfxf_fjffflRlplljlАll`njnnʐnn&`appppPqjPqPqPq`rvrrڐr
`snss֚ssPuXPuvPuPuPuLPu	 w0wNw`wwwwwOko"P}4RP}>P}HP}hP}tQ}P}P}P}ΚP}P} %h"`ЄJЄrЄЄЄЄЄ  ІDІnRІІІІMІZUM`PUfպ
TXvUM"1xբ T ΐBd5  PUNPPPPДXДdДzДДДjДДД
 :NpސЙbЙЙjЙЙЙ `
v78:'ց" PhУLУnУУУУFУ Х.ХULХ\ХnХХ՘ХХХT䐨ZնTȐ䐨 T`ЪBЪVЪhЪUЪЪЪЪS-ЪЪЪ5ЪЪ&4Un̐S 4`Rx5,Ր$ P4PDPU`PpPPPUPPPPS t5,`aUS,`M PjPՖPPP$T4оtоооMо EPxPղPPP*Tr PDPVPnPÒPPP 6DT\dlt|łŊŒŚŢW>^Jht
g%ʤhʅΐA֐U#@^Јղ
T"PtҘմª#oHtԬަ
`tՠؐ
nj֠bؚ0ސل٢ٺܐIǠPTPtPUP۠P۰PPQPPPۓȠWNޅzbO{k|}~4ɠPUP6PZPnPUPPPPS``\vUM PUjoP8PdPPPԚPP$``PFPdPPPPPAPTH^ALϐFUtАM  (bUS``P^PP5PPoT恕FZnU5ӠU8`|͸T #P`PPP5PP( #@Ϝ';PUd5U`A נ	<	P	j	T
					`d| `>6NxԐ⚐G (,0<Vv*Q۠rP|PPPT``XjJLڐM ҐVՂޔ`BVfT|USߠDrՠ0TਐS
 v  M ``"J"Uv"""P#S`<#d##5## P%ՄP%P%P%T`&r&&ʐ&M&`<(d(r(((Z((*JA.*B*L*V*^*f*n,*|**ɸ**А**)o000<0
gL0d0l0hzT0Ζ000M0P56P5UbP5P5P5P5MP5
`P7RP7UvP7P7P7P7P7Ao$ 9j999`%:t:::<l<<К<<*ߐ=j==="`>f>>>ƚ>>@B@V@j@@
@@ʐ@xA5@@ SD"zNDOkE~Eܑ~IEEEEEoL<L\LpLLLȚLL`PN`PNnPNPNPNjPNPNPN ҪPRPfPPTPPސPPS`SRSnSUSSSSMS``PU:PUUVPUdPUjPUxPUUPUPUPUPUMPUPX>PXUPPXtPXPXPXUPXPXPXPXS[f[[5[[ q\U:\Z\t\\\`P^dP^vTP^KP^P^P^P^P^P^ Tgaa4aLaUZavaaaaaaT dFd`dxdUdddddU'UALd kZkkkkʐkސkkL#l4nDn`ntnnnTojnnniPq,PqLPq|PqPqPq  jN"s:sPsjs|sssssjNu2uBuPu^uhunuru|uuuujN,xXxxxxjN8PzdPzPzPzPzPzjNT|<|T||Ւ|||(Ts~~~~IĐ~ڐ~~}~jN0UH^ftUԐ_"jNLr՚T`~V~А&	jNUJPzPPPMP*
`|ЈЈЈЈjNU@n_2jNRPP5PP
 VpîҐđWjN6PFPTPSHF^PrP~PUPPPPUPPPP5PP`ГUГ*ГBГ`ГvГГГ
̞JГГГГjГГ u0HrꐙސjN.Tzjʐ`jPvPPPJ PОО̦ОsППЦП }РРئР yССܦСТТТ$ yУУУУ`~\tPgvBBBBBRv sШJШZШOEkG㬪ШШШШШ&.Dd~PVP|PPPг@гjггггг`~е@еhе|ееее
jN4зTзvjззз xP(PJPhPPPPPPP
!HpԚ"u@Fzަ#пFпrпппп$$`zfڦ%`ªZ&U"6J`UtČĞĪն'T`~Bdǆըʐ(THlɐڐɁf`gi'A )xPTPЎPФPҚPP*XҎҲ&+`sbU|ӤT3,` LULtր֘մ-T`~Bh؄US. |$U,04BUfۄ_/jN<p50 PՄP߸PP 1uXn|j2 j3*T`p㾪^4uVj&5 }PPPP*6`|ꆐ괐⦐7x뮚
8`sb9zڦ: ;`vU< 6XUp֐S=`.$,@JT\fpz>NZ
1hJ3ŗ*3M?PhP՞PPP@WjN  < Z Ux    M AM B`zp5"CzP5PPD`P5PP E`zPzPPP,FTz5ڐGP
NP
lP
P
jP
P
P
H`TB4@V%hOkϬ̐I |PUP6PbЯBPU\PzPPPMPJPJPUfPPPPMPKPBPUfP|PPPPPPLTxBbxՠMTuPZpUSN  ( : UL h      OT"P"\"b"Պ"""PT$:$d$$ը$$$QTu&x&&&SR`|(((5((
S |)U()8)L)`)Uv))))ռ)̐))TT`~,D,`,|,U,,,,SU`/V/v///T'ρ///S V5z55ՠ555WjN>7T7A6777֐7F7 X 9949T9j9z9֌99999Y`z=T=p=====Z?@?P?l?v?~???`I?j???[ vB^BBB榐B\D|DjDDD]`J|HEZF|EբEАEE^T }HHHH_`~PI:PIJTPIXPIfPIPIUPIPIPIPIIPI``zPMhMMȐMM a`N~NN̦NbPdPjPPP&c`QQQQd`R|RRܦRe TfTTT,f PUjPUPUPUg`~*VLV|VVUVƐVVS
hPYPDPYUVPYjPYxPY~PYZ`]PPYPYPYPYPYPYPYPYPYPYi ^<^^I^d^
r^A^ŗ^JP_^^KEjdJdUrdddd5ސddk7fUXfrfff3q`mf<lhMh
msiiMؐinzjjMj2okkS p vPlPlPlSqPmPmPm5PmPm$rn\nnn0jnnn s`qjq@q*qqqq1qOktoPv<Pvm>FPvZPvbPvhPvtPvzPvPvPvPvPvPvu`MP|ZP|zP|P|P|P|P|
vP~>P~ZP~jP~P~P~P~P~P~P~wTPDPfPPդPPPx^Vm>
P"PU>PҐdPPS}FPPPUPPуy`MRXqFz ܐ@rj֐{Ӫn~ܦ|VZ:[m>4z} ЎU&Ў<ЎPЎfЎUtЎЎЎЎնЎTЎ~T P6PNPdPUPPPPPf] cP013'ρA{TPRPnPPUPPPP{*FZvjꔝ"RП:П;PПrПППQПP$P4P@jP^PzPPPPPP8m>am>PP ^`MШbШШjШШШEJ^ሐА, HPPPJPPPP2QP^U4HN^UlؐM"PdPUPPPPMP*`[P|PըPPP(TRжxжжжMж`UPjPiPPnййййй"PlPJPPPP5PP"}Fhm>R_HFm>`n}vmm>|UPU 4 m@GEPē u6AaR$a`ÅAcvô̚&R`~ʜʺښ`MVt̚
`U~ʹꦐ( _ΔҦ |ϲ& oђ zҰ N>TtRӒĐӵԐnxSm>6PBP֕\PnP֐PօsPOtkvwܪPPPPUHX
U$<PUrތ޴֐S "XUMTUb|5 PUJPxPPPMP BURtM$U4B^nUS8FULpM"PUrM r5PRPdPxPPPPP֚PP SPP6PZPxPPPPPP UZ^ϕP'4A6ZUpM^PtZPUDTXPPPP;PP& PPLPhPPPPPܦPcZvJȐ̐АԐܐT gP|PPPMP& g

5

"R~`~hʚ4 ojzJL*UNxĐM `ll՞ʐ.T gSRP~PP5PP. _Ր$T HvS, PPPMP א Z   ż j    P#HP#TP#оfP#tP#|P#P#P#P#P#P#P#P#nwP#jP#P#P#`VP(4P(PP(nP(vRP(|P(
`P(P(IP(aP(P(AcP(cXnom>,.T.T`....M. `l0`0U~0000Sc2\22զ2А22TP4jP4P4P4MP4 U5R5Uv5555S 7l77577
 9b99999:
Q`9><@ <se?\u>ۚw<NR wR<<<<SYDD>DUXDDDԐDMD UFjFU~FFFFMF
à^H<HUbHnHHHeHH`UPKRPKrPKPKPKPKPKPKPK
ŠMPMMMMMȚMM
ƠP<PXPrPPPPPPP URRR`RRRRRTVTxTTTTT`VVVVVVjVVVপPY$PY8PYBPYPPYXPYjPYxPYPYPYPYPYܚPYPY ](]<]N]`]r*]]]]N@'NAE]M]̠ d\dUzdddd+ͣE8fXfAFxffFf4fAGf ĐiU\ipiiiծiԐii T |k>kRkhkU|kkkkMkPn&PnU>PnDPnJPnPPnUVPn\PndPnjPnՎPnPnPn є |qLqqqq&`ʐssssss`4PuTPufPuPuPuPuPuԠPwzPw*PwPwPwPwiPwPw
 4Pz(Pz:PzNPzTPzhPz|PzPz֠B||ڐ|"UףCh}}}S ؠB~~~M~٠ dC  UЁЁЁЁCC`zj ܠ ЄlЄЄЄ HR^n|ZޣU&:JPV\bntzjА쐈ߠYJ0<
*H%`fnǕCT@\xՔ T@`~5 RЗUZЗЗЗЗS PfPP5PP`4КUrККККS$(P~PPPPP 9Tt_Zn$РU*РBРZР|Р"؆_>zڦ@РРРРC$PnP]Oo'     l      [Y VZ   QpLGB=   0{+&!	!$05/29/03 Copyright 2002 by COMPAQmputerrporation. 䐿
!`t`
T
 'p~}P >""'D Tut


t
tt

"
#
=t
@t0`#~ )0{TaD>0$`D@t#(t}bD	T
'T?DDD T;%t5 !t
t
{t
Duү"!"#$$"#!P%d%%Ô
@$$p#"2` нp$ЂЃ%&u u '2Txu. 俓B/+>$4 `Op"  { "{"
"?  ".)z|e}~ }𣮂)D` ) Cp`t   +,-.
..- $-@2,,+ $+p8  )" ~}|}J4"{ z}b79tu9T=tA:;}{ |e<t!=8<>$1%A'%($('&_"A&B&CA&%ӔP&`ӔP%/3d@C$d	p?qCb7%u( %0B&u*qI)**)p)N`._((' $'p8Y@2qCD;a;?%&$4CA!D @((sGYOdr͢QehRۢDPPACS9"TqrTt~ 33"U]pPLIDU=A#T.CYT#"բD!*[bƢTT"uPu4"%$:4@2tʎ"0"
pKp"0"_d   45t~(t
5"+c+/ÞP.%c@ Sp`c͹cm0^{ +u.qI-_.. 8-N`Ia,f 
c,;g#hBcie,`Cdd`"_7tu
8c" s/tOuovwxyz|/}}	2x-{| ;_   01/0A02/~ 04 kRu3qHewlett-Packard	any.@0Q0"x#Tq*T0	T@t/{3"x0x`v$dPx>0#1~"};TT?"2"2
!x x)} @;uu u	`P2P2@)aT$3TD ȃ@VF @c~`T?0	TP2`T%`ר@P2dŃ瀾x!T.xT?T/TDx!TDxD@x``p
00/dp*tP M0 T%%0TO~P.!OT"r()B)J()(@BbhR PMoMxtPTa"C#x7$0./R// $.Ô.P	107xTxD࡯')RSM~;0`ӧx 0p"xD¯./uvү5./"xt}
~q3}xXvvu_u0P0Dࡸuu!B
Lڠ!ү0V~m 𑛐xvE``
$`$p
?sషxЊe
'xx txDE SxxxxaD@5} n}upgp`p{A}d`3 &xNI>L,x%tx}Dq a Pa0xtxtyuu V0}^qOא}eCsA]}lqO-,/ƴxeD0 ZѠD 1^x_RcD%xfTP`P'p# * .cd[3l-0iI񛧴Ɓr	@ T`ɉ"10x a	>00Pǻ0}pŎѽ3)" b P¯^u` w$T`#BRn045p\NQʄХد)u)$O4F^Kࠞ)}.*)Y(Ô@a*"x)(`#ڔx0%ovՒ"x)(*a00}++,`- "x_}408}7!=" }9P5*/x%~x=0T4d~` 	D#Q"00x`)xc`xd @p0K0S(;~TB(x0¯0*09P4.(0H(`xU(	( xTx ! (ATKCPF0< y(P>
0Tdp(D !+OP( @z5?n WO"6p@Ô2@YD0¯xx78Rx00`6+060
 Tߠ|`	p1[mnה  `a7!6"ڀ нᛴx,Kxtxx,!p0x]*-tp+»Z`AY$^ҚR ~xT0T?d?pp
0aT`ad`
u)?T d`pUpD"TӔ @
"T?Mp;T?`d`}*}W)pK0$"G@p`
1#u# %@~'~W)33TT?O)` 7  . )/7 e""G`rux_?N堕DD33333PE:ЂЃ2
2x_p` 	B_?a"ٸ5L 3*A3Mx-2+_NMNx*NMx+<QM0x"b=!==9qeL`
MN12A3K3K0=`C_D`C`CP`C4N-522+"F	2:RxZ2YA3SNSSQ4<@R`SH5t2:T  3^A3UIUQ}:@T1JUJKVҰLcA3WIWTW3PRE@V1JWNS2A}3 A}9 !.A}  uuҌВ"HVc_W47jW0Vx'
q[0d`W!0&--\P@'`2`=`HpQxX"`1\6uuuuҸbuu0buubYO$rWƨpN`0T`
0370Ѝ  q"[| }(xX"(`E(p
kAn(  ()(x)(0(p)))((xZ))"*+д[?T0 7/at
at&Ppd `g.堪2@t%x6XjҌ(px#k響,-mp,l`
,-xd@nvt j/Dtpʅ+*,-"uPu4e"[ Wx^!`yWxtwlOx7px8§7t1"Pcd"xe!px,"". -BtF)DG qs=w1v8zrAp#$W@n23{;"xy> !u
Cֻ9./0H*5,7_SU4cU~TVV~OPK|QZYQP}d%]	`
e(j[&b'gi\af6h+l:@<>L|RX>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L R Z  a  " ! * 2 1 : A I J Q Y     )   3TP g d   pqkli/ur}z'tw l k i h Ju s r p  l t z q { y m Zc v       
  	 x   ~  _  Y }J | # qww ~~   @".Gux401rWڱD x2t 1tI%W0% %xjvv %xjkZ> HRxl"# $ $ !23x1 	ү  ¯0 3#!PK03"0!PMx3>
2rWZ"xkOF`g7rp"" %	x30#0$<T`д9"xl `fp
0!#atI.4}xl$3z 
PHp`$Ht ylDˀxhv"xx0	Dc0Uy$Ӕ@TxxywqD"0 4xfxwU` еDT0
ϠqP" xnxoxv"xnxwxoxyxv "oxqxp˛rP
rWypxqf`0SVxq` g5rW1wB".0&u)P/})S@&*@&"*@\`~"x* \t %*un o-~-PtU-,-b,{R-h-o8++ѓ,U-`RiU,`  +u%*$U,00u,,u,0,*+P,0 Pd0`Ô@"0  	0
0 		"0 H`$<T"   R1 apy1ÔP2f0/ _\%110r0//}1Ӕ@t -A2]nO2zq.¯	 .x. xho`x\T`)Tgxgdx`yR"33"x4!,r3TOp0 0@0 
0 ]]#000+1d'`8`2`,`&:` ;`5`M`A`P+3{ z y5"CPNH0 =5`<}DPA5d`5d`
w`
`
	`5

5a"3!54Y4#P "l"8̓6 "63qْ9S6|09}= ~ } | 6" ONMLPM:_|b_^]}\T:=T0f: 9+`:80:808u6$`4D   6"6789x80ΐ6789t:_#I$%UI$%I$%6d'p/ $%0q+.+c$06$):$	%Uz-;E/
/f-U1E//R-2E/U/>-3E//U*-BE//-E//-:I #8@ $ t8 78v0	0+
  +u7x:370 t082;
V;8?;C:
K>>;+:
<_u8#:EAF
:T<u8= 2;m:|7pu8J2;u7Q0Nu7!I:{< u8| + 	6_u71:yuF{GaG:J<u8yu7 G`G;8@
8b,88p!77
0
6%os8@-0
05$`$`o$p0N(P0N) PPϒ88 O&N$ʀNqRR-SKT6'"9:9  :"9xhVxi9d|p%09R:N{z?y&sYsWvV0/0X_`)09#XVY|Z]9
Pi\1΃Z - 
[^ &-JbZ
 bVV;_; Z;S\Y3dEb:;<<:;<`R<t%<<5;; <<VVrPi90r0+09&_yY9V9 [ Zb\Y 3oYr@tm   
 
 ,0 
 93o?p\qlmQc:Wo`V0VSV0u0-g09(k\
m n4atdvEbCr95~ˀ_z|]V90 ?W`*
t9 Z9+uqm e9p2ad%Z9V0 \oj9CWYylӒcӒ0Ucߒ=YWifp[\H×s;q ipcc×"ė`c6xgpJp `F0 `)k" ) ) 6 6u"xg z}Zr "1x{5MNOp#D Ee1``}GX#0
T1d`*"1#2`pQ{z}yZ1zxz?d 0#
0 *`0`-0$`+$`W$`6$`$`& [$pYTY ԀQFQ>Q0Txv)Q!R̀Dx000a R 0a_P-PE`# c	PF,¯:z`ү"Q TPF`xe  U(05xv
xD}D_,0{ ^`
}^T?D=_e	Ӫs	ln`@ TPB34#3$``$p"t1e4`tg4⺑g1Y§ᨀ`&0.%0*Td`x0dp&   xF TTÔP
xG@0_xFtPemѽw xB_CWBsmѽw xN_ONlmw xJ_KJ В"789t/F"!:(x ү7%$&t:t:8230(0 (xv@3x`vT"` 9x"ү878 0( 87 p0 xv33xV53}.* @4  %4`.40""55Ô@@	p@/@؈ssd`
-~~/MTO/]S@mS}XS6Я12s0``/`@$pN$21:Y &DY X U ҿ)AP [x@03oppG,8>p1 ?'AP@ {"PT@~ o-93U ?TP;d`pxH @2

4E
E
@dq;"-.Oam@`2-x00 <. 	@
pޑ0
T DT00q	 0A q}Ct
}u//퟿tl@P-0 r.ldpe`0-ADxwFG0"U@#@"" #"xu00&0u0/1}S tp../0$..}@0 $0/#-Z)1- })*
#.2.˰/@"^/4 4*x0)a:E)4b+,@4g)1::!	77	89ph;a)
2OA?@B55 
x(0	(c 1C*;((@@@?v@{	E`ސ~4P0 ϐ&T``A_`8Ю<@:p5S D?& % 50"
op;S s224.QTF  50: 22Mp	S08"B0T M>%%O@S2vЏ-!	N-H?<W=2+A:9Q-|`R`N6Ǒ6`Xp0R06+cP\O0*-`Y-C-c-FeP`	-0P.o[|TR%\de-N. ! EP6$/u.
/ku.!s.ހW9W,J:::
O,-5oo P2- 90&PPгq	wTн -	q	 Ȁ@ɀQt2080uQpo	)Oa*+pF}}}0
a,/+y*t%)&$	1H&SHS;"g+`NAp8
BŐ} BT|1&0=?J'>H`$ < OT0?Ooyw45e+pY}BxaTJ %"
č#\p0 >@54Sm?Tw:y5rBB{{	 U@e1r1QH`{o0f}
AE977RdE؛ PG6$$P3s%Bf}KV嵐{籐HQE\ё}z  X@FpRFpLxpGtp?2K12K#2K2K
TU`6 |TBx{}A{xzGxyExxFxwBxv<xuxfxtx\xsxr}xqxxp{xpx|PAx{PGxzPExyPFxxxwP<xvxfxuxtPxsP}xrxxqxxp"6y0xev0p`Txam;BB" /:e0/Txa0#arbpNm /^S****1Xs	 ~93GF")u,?.`-T*/.tf00) 0'H0|4+ 's	X	)x IP,+>%)tQQO*+ǗpG8ґT+̭+U(@>%t-p=0|/y0h&P5-/ǉ\?u }k}Dl)htёi[4rNHg00|93HfpP
gޑ "u*`w09"bu P})tqm0|?_l) b	 M+0QPRPO+pM&u0D@[TۓtǀHppp;kDےS)T)u+B+tE 20o&Hu+Tqm8pB+2Y%TO]3 7`	  B``֐@"d"$@@Ӕ@6   x0PQ  x_<_ I`	q7"xv7׫o0I @rt`>(PB"C^ : Q:opTQL%QM30.vT`spt@'}?}S?P Y33TB DD xe3"ﮠtpxV?xFl t@tTwQvµ
x QMnRJ*"P#[a0u0COaAAGE7X>3tf+`
PP *J'' '+fz` 1:P`	a'z!j"IߋJ>
UTiNJ{
EI-@YMn:C٠CwCYpo0:-zuU10[U10b:q1H,2;1i`4-D0-dr0["-UOa@"CD/S(az!D_dp }<VPt=tqR?! oRDHEP=`EDxhvCDB"xF@xGAxEBxFt@0( AT.`xAA0xBмFt"("DAEF0FBC"xB*ACCCACB?DYEB*FGLGN*ACOCMCN_IYEUNKK9LGJACKCICJNYEJKK9LG:EF?;GHd`NJDT&`W sA0uFplF@[
HGt3}\q0hCFEB}^}e}s}lEAMI AB++I`Ô@"OxD Tv{OGĀ@cF~$0,Z@cAr#}@Tsp#}C0?PGGGGG~GhGVGDG>G8G2G,GFFFF  GI>go##i" 0` ]kqAt"#x]OmbnnPnkq"I^pDArmr@`ABVs,qnPC@]kkqnqbxq p=wQC#Q$`R!H|$HPӔ@zPqOAP0	xhZÀӒ}|ABrP`#`5?`2$pChkpxAlDurc ۄzx\PPT@?gxg#mqpz7qp@Yq
xdp GÔ@π<`T`xdJpӔ@d`xbrsTs t{ dxi vu\v+xgv2@`#t "4}t tP)}=r 	+"ÔP@ӔPq $$P`	ӛYCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATamrb@cJey{f}~!L9]$q/L10P`Pd`uPrgKK$K0K;KeKqKKKKKKKKKLjL2"=DŰ~0?԰C`qv@pl"lM#кԶ ǰװ@7kG~kװ aְT߶L7s.g9 xbwl!lh a~`g@P~1{OD=td
`#`(`<` dP`d`PȐPB0=vCqPP}ttdrvxtxxXx\t lxat"xbtRNxJxFxBxtx(tb}P#Dxxtxtxxtxx#x> x=tQӿx@t 0xTВu"x3ttfxx!TToTaD	zxT Tx=Tx"  TK=Dp"Dsxev0}<t F{B{G{E{A}DA"x0xP"xbS&" S?`/@?@>"ޱ=$t>A&$-"TÔ
P~0~7%PPOO"7%OO{ z yOaN N+N3N4N6O7O
8O9O#:O.;O3<  O8bOY$QaIaAa9Pa1~5N`O&8;uOuOK`O@`($`*`-|/apu4
TbB`<awBFEGAO$`$`!`0`?$apAa :w32"}*r0  w)0!",3`G`[P]Opa_"OdpFb$  `qDawT 0 OP[CP"L}$pMbPS%Ld`ǀLxbLÔ PLNON	@P
q		Pxbvb
@QOQOQOQOQ\QwQQQQQ۪QQQRRR^RcRhRmRrRwR|RRRRRRRRRS  S%0
v"x{5MNO`uM@\MMx`}ZxzY "+"0M
MA}$pf"} N}U a"uNP0SNNTN0CN2P!d0P! 0P!@$ 3xw\bvAUAAAAA`<xTxeD0xb (x;x `n`}K}If$	A
Ap "3`N}xO| } ~ Pe4-.LbU'MM U'SH((sSSTTTTTTSSSSTETKTXTTTTUp	F0`Ô`P	LOA"T?s8} 3
0xt"LNLaJ0;;V	bp50;TpAuL<;>>1?`P@0b P :9`Nm"p	Jr7$p9AA0Lp."xzd_PDA"{oz}yZp8z"p	OMc ir79!HeIIeQ0M}d`USI`SI!!`L ^``OLpT0 ˄̲ҊAlU0#b0xD @Tqx c!S?TxxcvҀqմTS@BYbDAZbZ@<xDX.u0/}.*0.T ^00//PE@"U]^.Ga"ڣ`^} ^",0Vd-_,Ô,dpCSV6@a93-"
q3xpo0 "3uoxg`@ۂՎ./01,@RDt?/t .x} Zx?DT?/.1R0U1B; v\xpԲ x !Dб!xDR"q p :q@s6xpYobYs2YWt"3WWWXcvYoYYYY6x
,-kx
tu,P
-,_x
szzx
yjxl{Vx
y #qu6{0"t "T $Qxm	}I{BxlxlßP2V0{ y% $I{$ÞPxxl{Iu'!t I{bb)*u`+yTүs$`&p<V}e  qUI>x+*)t6{$xxmӔO@vl hxlvylßxmP!  l߀0 	6
xTUxv 6dx`r<
0ޡ{ᔀP`xPlxx
x{xx	06Y)bP$~^|0 f}060:Z ZZ(Z2Z9ZEZZ	["
  [g'LDcĀ3D@c"xgD@BO@$P``G3@ p0TO2P02P  -Dm0"".@!TA"~&`/걥@ U,P@eT^Opsplb33TO1p0RPò R6
0`p}T˄`- .*))~Pr;S)зS)x`vS)ж)"(),0.\\ߌx	`}FN t\u- u./0SS0S0u/ u1/U-n.Np.%.-3-111PEPS2xp]x	1.-kA^_p  6  .sĢ6 +22􀐿M.?@x  _=6-ýP ʀ--_Ӕ@p0.`@]7]F]Z]]^
^-^H^c^s^^^^^^$^%_&_+_,_*-  _/.`3_/xu,ӐF./x0."ӣ ցat0ձx*+!yP
+*{
Gx٢`at?e+pt Se*l	lڂm`
pxvEvmxӅ`䠘xp`:0հؐ};}#zt¶N0ӐHrOtb.`Wv@A}o}UAtAuA]vApL}3A 3'0&(@abPeкP)ۅ( bct`g0
________	_____````?``3`  {``UCCCCA
tt)"/{RC	JC
C@҅-T@CPLxaT0{BL9)0"|
"L:L @L'N MWPOxI!p`2Zx[`!a0G{t(OD#4	2 x{Pas`iD:
0« D AM*"pq`Dp:2}x#201bD"00(1$`$`$Ap`aH"_ߣ	%$%ђc=ze1p;A&d	`
`DDxh1jzg"
"xpaTp opa@a"΀ `P "$``#`$`%$p#F0 c
=#"x%txm.d~%m"&I}t~0	
!}h""X@rxqTTr
* `+l!D`T!T\Ñ.P<*
`+"  =>C	D

~x`!ÔP2^`_f"
% osF`7i0x(5(eJxi6d(37(@S(a3`C00+xT 6r} 2p. D:T_`*  ATT900	ҩ6+@5Q>qd`xSp60cx`7($```9`B$d_xv (zBq DxT2?ҎxStTT4DHc9(xS(<x)`76)$``$p#(P8xSxB(B	x606008=A>0ch2A<"*+*Ô@*ӔPM@
aM{P o*$H$cp!00-C+(}+ÖQVH+*f?PMC++ MSMteM`uCT[@N@oPO~B`J`N`R$dpT++AC"+W4`Xdp0!q`X0ӀÒ0ט+Q[+Q"*+k"`=0D"xB0*"
]	1}i`$3mp`0<0õ}ୱ@b,/0fggPgVg_ghgqgqggggggݕgݖggh!hhhßhàhhiiiߥiߦjjj#j#jEjEjgjgjjjjjjkkk+k+k1k1kSkSkukukkkkkk  k~'1rkkC/ onT3/C/00u5$ł 0` R/p ou/o}/tutst,}At"qłfuE6vvsu6v)xu6v{u6v}o P GRPp"qqL"qɅqӝӔ Tqoŀ~ At`| }@@^_Tqou6vſ
u6v߉#t~Ӕ  Psi\Ôd@n| `z {p@\]L`S~-.YAt)x~ÕP{.u_.-w6v)u6vu6v忝u6vߟu6vt@# _x֎-PBМQau!o{dz Jw6vubu6v_uR6v߲u6v`,$/0u6vՄq/q{5q/9p0!М6vAsÔ@u/,w/!y`A`H S 3P b\P`uP;<~#`j0ol$m3'`T}с$<`!!xmPI
J
ހKxjB==xmP=7U440#70"'~"<|ɀ'"$<vBO+@ŀ
UJ
K
Lqʂ=xm ǟ4Ɂ"8o9:`38T Aqq
d@Y08l,}}Ep& 8| $ >89:PԤ0'`圡d±Z"8}כ~%}qo݂AޡmՂ_'ɀ#21}'}p``$TTopקt
zb

(H?sN((&@~%2iݰ@v1$lg@#9pp t.q 
41pnnbn"14Po=Ku\Ҡq }p
T?T`4"4}"bu0<.r.`~r~s^rTp^+qTO..O/p3p* &0z`ѿ
nb.ߠ1 PC18o 1oP@hrB1qqp08y3@׸`&br@p`@t1"x`0Tw`2T_2O
P.e72ܳoqnoƏ`;e.`.b v7	re.@qn.o/qp/ppR/0} } ~"7Mݐ	DCps@T3```5"2p2`r 2`.p~"rKu.</u.$q }r}]s`|3wӝꠅ/0zu. Z/*u܅qr'SSu0q pap.ρPTTT%%n!pԑ $`r0
`r	w.d(.`/ӟ@0S}	nx B. b0Yx70w0,@.0& /Op`/`^rېPQ/p`^O"!Sk 6,>6%t@ऴ4 6ŉ6Ūp4v =}6p`SŲ@6XBXB>6etx4>6E6uq4t}5}{z?y>@ufbM04iM M$5vkPUMf>`-tc|0~@_
QAt"5"¯05Q;5p`
ݼ!t 	ÔP0/Eүίqد`ȡ>n`p|r|\`à234m5Á}M}4171|v((svw wAw\wwx/yyGyhyzFzz{6{{{|
|.|O|pSJ{/	m>cnWc !\}Gn1lkulpu2`u3 { z y2*ras2T`pd`dnpk*ry{s03GWcɔe3pe2`({IS0o03p@1326kŪ03x
lyfcٍE|Qu`  @FMdP;|q$K00~13E2pUzS7[H0$46k405x{sǄU6kk{xrs6U6R9r`z {TЗ@\]Lpb)6777666k;6p7t
ϗ:^=A!dLp=k*r7u?B!դk)Ʋp_pNk_ɫ{A=oVPkWB( :?~J"k*r6kk)Ϻ1k<߼1k=1k>1k?Ã5D*GMk /!5DA^vDlIM09,0^<T~6k|F@ 7v'k1"0k}1o+q τl2au{1 (#1$`=`l~c$@# u1*!uxo0X7`xd dEB|tu0|`.Ô(`Y02TT Np\ q 2` @M*aÔ`@qo@q fu1tpu07 4(17a/Dz}` O?uX` /A^L`n*}3/eEj2n Ht1+6PUgX?`/p!X0)}D02"<(_L0̯.3!_ހI%[` k~ X}~090p0.O//.QP* 0"#%A$3/ptP}a" 2s _}p_;
_"4Ct`#o$j23D2x 0 ``Ð}P 2_x0 @2xD)	V"LION 1`TDx"qÀ"0tpΓr"8bP3px"/`qq8  18!ӀÒ88
"bB!2S#"x& 3%T~TO &&"x!To`	p+p3@xD T"	߿F	1*>	@*2*x*pz+S+d"*X-*LҀƀԀi3ꀚڀʀ3-䓣łŃ1
-`1 *"113*̈$ P37##EN``#s-"P""4䫓"9:P:"  )"/33@ >" }S=3@0"Ø>"(Ap_8;
- :	P:	{:t;):eC	%P:
F"*70E;CP^C	!D	_"EIFBG"""BBE"`O3=P@=P"""ЃЂ䧓`ETTtsqTVs`1ŃŃ4W"%p85@bTp`Ep
~`Es@Uh`B*pT*p\*p\~+p\vA,p\n,p\b-p\VE.p\J/eʠ/1/11cpr2p3c66p7Ħ7~A8#%s j km/nOoopqrs tv/wOxoyz{| }/Ooυ /Ooώ /Ooϗ /OoϠ /Ooϩ /Ooϲ /Ooϻ /Oo¯ /Ooʏ˯ /Ooӏԯ /Oo܏ݯ /Oo /Oo /Oo /Oo  /Oo	
 
/Oo /Oo !/"O#o$%&' (*/+O,o-./0 13/4O5o6789 :</=O>o?@AB CE/FOGoHIJK LN/OOPoQRST UW/XOYoZ[\] ^`/aObocdef gi/jOkolmno pr/sOtouvwx y{/|O}o~ρ /Ooϊ /Ooϓ /OoϜ /Ooϥ /OoϮ /OoϷ /Oo /OoƏǯ /OoϏЯ /Oo؏ٯ /Oo /Oo /Oo /Oo  /Oo 	/O
o /Oo /Oo !"# $&/'O(o)*+, -//0O1o2345 68/9O:o;<=> ?A/BOCoDEFG HJ/KOLoMNOP QS/TOUoVWXY Z\/]O^o_`ab ce/fOgohijk ln/oOpoqrst uw/xOyoz{|} ~/Ooφ /OoϏ /OoϘ /Ooϡ /OoϪ /Ooϳ /Ooϼ /Ooï /Ooˏ̯ /Ooԏկ /Ooݏޯ /Oo /Oo /Oo /O o /O	o

 /Oo /Oo  "/#O$o%&'( )+/,O-o./01 24/5O6o789: ;=/>O?o@ABC DF/GOHoIJKL MO/POQoRSTU VX/YOZo[\]^ _a/bOcodefg hj/kOlomnop qs/tOuovwxy z|/}O~oς /Ooϋ /Ooϔ /Ooϝ /OoϦ /Ooϯ /Ooϸ /Oo /OoǏȯ /OoЏѯ /Ooُگ /Oo /Oo /Oo /Oo  /Oo	 
/
Oo /Oo /O o!"#$ %'/(O)o*+,- .0/1O2o3456 79/:O;o<=>? @B/CODoEFGH IK/LOMoNOPQ RT/UOVoWXYZ []/^O_o`abc df/gOhoijkl mo/pOqorstu vx/yOzo{|}~ /Ooχ /Ooϐ /Ooϙ /OoϢ /Ooϫ /Ooϴ /OoϽ /OoÏį /Oȍͯ /OoՏ֯ /Ooޏ߯ /Oo /Oo /Oo / Oo /	O
o
 /Oo /Oo  !#/$O%o&'() *,/-O.o/012 35/6O7o89:; <>/?O@oABCD EG/HOIoJKLM NP/QORoSTUV WY/ZO[o\]^_ `b/cOdoefgh ik/lOmonopq rt/uOvowxyz {}/~Ooσ /Ooό /Ooϕ /OoϞ /Ooϧ /Ooϰ /OoϹ /Oo /Ooȏɯ /Ooяү /Ooڏۯ /Oo /Oo /Oo /Oo  /Oo	
 
/Oo /Oo / O!o"#$% &(/)O*o+,-. /1/2O3o4567 8:/;O<o=>?@ AC/DOEoFGHI JL/MONoOPQR SU/VOWoXYZ[ \^/_O`oabcd eg/hOiojklm np/qOrostuv wy/zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo  /Oo 	/
Oo
 /Oo /Oo ! "$/%O&o'()* +-/.O/o0123 46/7O8o9:;< =?/@OAoBCDE FH/IOJoKLMN OQ/ROSoTUVW XZ/[O\o]^_` ac/dOeofghi jl/mOnoopqr su/vOwoxyz{ |~/Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /F     
     U$   4 G  N U  fWfVfSێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.15 Copyright 2003, Infineon TechnologiesQfSfRgf.g.3g.

Ƈ}~ǇvJ gf   uq u QfP< fXfZYQP

{At2[RS l eg{q "  诟3[Za@
  
a 
5
; a[g.Qt|P@f
 DF<d~ug{$u	N"##:o3ff@~1QfW
Pf6ffffg0f3ɹ 
Q +r&u3gb&Rfgݎf(g3fGf_ \-"& gf4$ +Iffgސ0fG(. J&>/(0 1	.1g/	2fGg&q/g_f6f6s47f76_Jrr&v:7Z$8x8g6{47S6<|.=}.=~'=0  f_fYڠZ@!3RQ`[DaDD3YZRfQSDڃ <u-Hu!HuH u3
߹  4 pgx@FDMDwTEPE 4 t L3 s d 0SPPJuOD0Et  ED&NbAE'CWUDpDEqDFh
Tt2@]Cf[1^PQP fa nd) f t|gf> tub~ {tm1c te1c t]ff 8N 8^ 86
f;s"u
 '^QΒh1 
@K [W)Da(g Bq^ 
_3ҷar& ~A *u
r& ur& ЃuBwog,1-[0g#sf8魾uqq@ L	uqWwS/uF"0~ouS p2zIƀtB 8t$2 8D$e{ff+f+Ȥ{92z3{pu~` SY^@QQ{ 8wL$ 8	25
|0 Y Bl_3 zǐo 7muj ),,Q tLW)ff3fsf%ffK8s{`fClQR*gً1-*
tffpUf;sg^,g,WZB%V)&6Gr *fss2tQtÓ1 vfV*ʻ *쓫ʚ<ڛ ־Ƈ,d +GĚRP_EQ! [@FPQ `~!fRS2 Q@\ nZ"AA 0BÀP;P s
E 0 Cr
 xRO_f3g#~|ǃrtfwQWf9ˉAP bA 1^S*pQ$"PrPrt Dtt%53A. )0 tн t1@t`5t
I o:ɚ̙&!'g%aa fQVPmQ\0l0"AA|!26Ps؀P"rc2ېl ɹ@b&'"ff+f}HlhUOBB`%Q%`
Go!tO"BY&Ѭ1OsѬ1Or
q"tfu`3yȀUq a 7pTPsIu3PBHa8 XHPS! 6#a P [Xp$
pqSq[ 
 tKCX 裝P0#"3`   = 肦r2#fr
fff#@k%  t	f!bf#fk%tbx 9$yz 4Fidk  4Buf0b!b/Oo<NUX(l              @ ` d$ UNDI  N MdPCIR$    I PCIRE      X b   $    $PnP       o          
Broadcom NetXtreme Ethernet Boot Agent v6.2.11 
Copyright (C) 2000-2003 Broadcom Corporation 
Copyright (C) 1997-2000 Intel Corporation 
All rights reserved.
 Broadcom UNDI PXE-2.1 (build 082) v6.2.11 
Remote Program Loader v6.2.11 MBA v6.2.11  Slot 0000 Broadcom Corporation Press Ctrl-S to Enter Configuration Menu ...
                            
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 t`h+  dMd            h+ VP@ ء .;uXuX.6>| .6^SQW  @ _Y[QSH .> t".>u.uXH S2.{r*= eu 4= fu  *= gu0  .9u
 @ ؊>l :>l tIu[Y[Y.> t.>u0 .>u  ø UWSR..>f&=$PnPu#&uFPj`hf&u
˃ u0   S3=_Su}M_u22]r< t[Cu[V[}#|OfSf]S_fSf[2= t#It2E= u= tGG= uG؀}|E$t0  Z[_].>u-fh  fPh hOh"ph%th mh fh_SQfRWV.>f.> t.@   ځ>  Utt r rf.>  h1
PH ?X%
PXE-EC1: Base-code ROM ID structure was not found.   r댊  t	|Sfj j H< tk>  t;sf=$BC$uErPj Wj < t뛌ێf.> t.@   f&=$BC$ h  .6.6.6.6.6j Ph#&u
˃Z t'hDRHPH +X
BC_Loader() ==   r tho%PXE-M0F: Exiting Broadcom PXE ROM.
 P6 X^_fZY[.>ufXff., f.. ff.0 f.>tf.ff.ff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZff., @ 6& ԋffPfSfWfUj j fj fj RV@ & .6E.6E.6E.6E.6E
f., ff.>t(Vf.ffЉVf.ff6Uf.. ff6UW0f6UfVf6UfVZ k	 t	 t	 t
 WPO
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>. uX.> u
h
If.f.fӎF.3.f.F.3 .> u5h
i
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sDh,P?
PXE-E20: BIOS extended memory copy error.  AH ==  .f.f^f. rvf&D    fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(DvF&DF&D&DPj Vj &(D	.6E.6E.6E.6E.6E
Wj v&\Z
 .> f3fp  
Wh v&\6 u96} t2  ءL ` N b 6E6E6]
6U6uf6]fSf6]fRfPfp  f	fXfZ  YWjuv&\Z  t$  8Wjvv&\Z  t  uj@ H F F  RWjv&\Z  tvXt
 u tfS^G HF +F )F[fSVWF   6Sfff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 .>u%fp  %f tfP  ءL ` N b .> u0	= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]k3e3_3..fP. tfX. tf3ffFfUfSQfRW^  G33.. G3.0 . ua^_f..^G3.>0  u	^ af.^f.f^G.3 .. 1f.^%^f_f. s
^  .>0  u	^ f.^f.f^f_f. s	^  ^G  f&<!PXEt.;60 r^ &DXrPj Vj 6< u^wG&D&D&D  &L
f., &D&&D ff&D"fG&D(ff&D*fG&D0&D8ff&D2f&D:.&DX&DPj Vj &(D^G  f&<PXENt.;60 r^ V&D,rPj Vj {< u^wG&D&D*., &D&TG&D G&D$&DPj Vj =&(D	  ^? t _fZYf[]f   fZfP.>t.> tfX2fX.>t
.> tfRfPfWfSfQhf   .f8h  f  ` 9fh  !ff   fh  fHh  f    fh   f..>t7.> t/fp  f   uf ff#f H ffp  . uC f   ff
f t!fff uffff.	Itff   .>u f   tf   fff ff   f.ff   f.ff    t.0ff   f.ff  0 f.ff   f.ff  @ f.fffp  ffffp  fYf[f_fXfZfRSfPfp  pf   t/f   t'fXfffff	ffffX[fZfPfRf h  &ff    f h  ".> t#fh  fff   fh  fZfXfPfRf h  fff h  .> tfh  ff   fh  fZfXS rR[fPffp  fZf fp  }f p  f  nf   f p  Mf   t_ [fRSfV sfHf fp  &f p  f  f   7f p   f   tV fp   f[fZfPfRfQf p  f    f'  f p   f   ufd   fIuf3fYfZfXfPfRf p  f     fZfXfRf  `ff8h  x f   f8h  W f   @tf<h  F fZfPf<h  G f  `BfXff8h  3 f   Sf8h   f   @tf'  9fSxf[fSxff[fS|f[fS|ff[óhf   f.f.> .>  V  fp  f   tf   t fR t#fffff	ffff fp  If   uf  f p  /f   Of p  f   tfp  ff&fZfItP^f`f&fIufPfRShf     fP fPf @  f   f3fP  .>t.> tfh  f  .>uhf   U tf  @ J @ ۊl :l tfX2 fX+ [fZfXÜfRf3.ff
   úfffZÜfRfPf3.ff
   úffXffZSQ@ ۋȊl 8tY[fRfQffh  ffh  f;tfIufYfZr.>  uPH X3. .P #. . .P 	Pfj j .( SXf%  fZfYf[fX t]fBroadcom NetXtreme Ethernet Boot Agent v6.2.11
Copyright (C) 2000-2003 Broadcom Corporation
All rights reserved.  MBA Configuration Menu  
       <Esc>    <Ctrl-F6>       <Left/Right>      <Up/Down>       <F4>
        Quit    Blink LEDs     Change Value      Change Field     Save This option is not selectable                                                                                                                                                    Boot Protocol  Preboot Execution Environment (PXE)   Remote Program Load (RPL)             Bootstrap Protocol (BOOTP)           >Select Boot Protocol     dj  Boot Strap Type  Auto Detect   BBS           Int 18h       Int 19h      Select Boot Strap Type x      Hide Setup Prompt  Disable   Enable   $Configure whether Setup Prompt is displayed during ROM initialization     .2  Setup Key Stroke  Ctrl-S   Ctrl-B  Configure key strokes to invoke this configuration menu x      Banner Message Timeout  1 Second     2 Seconds    3 Seconds    4 Seconds    5 Seconds    6 Seconds    7 Seconds    8 Seconds    9 Seconds    10 Seconds   11 Seconds   12 Seconds   13 Seconds   14 Seconds   None        *7DQ^kxSelect Timeout Value      Link Speed  AutoNeg         10Mbps Half     10Mbps Full     100Mbps Half    100Mbps Full    1000Mbps Full  "2BRb"rConfigure Link Speed       Pre-boot Wake On LAN  Disable   Enable   Configure Pre-Boot Wake On LAN       fRWf3ҊC fRf3ff   tf5 f fZfOuIu_fZfRQWf.fRf.    ft   # XfZf._YfZWfRfSfP>uf   tTX>T u
fUPf]TfU`f]dfff   t
 ff<ff0ffuW f t E,=
u ff%   f.  t ff%  0 fff%   ff uf   fHff%   fff%    f
E2=u
fXf[fZ_WSQfPfRXf @  f   fp  f%ffffffp  >T ufEPfE`ff%>
 tfffffffffBfffffff
f>Wu
> t ffffȀ>T ufEPf   
fE`f   f:X fYfff   fZfXY[_Uq 3KtRMtpPtHt.ct>  U =Uq} Us }Uqh 륃} t=} u7} uEEHEE 낃} t} uE@;Ev3E& b.2UUquUCRVUmUPUXUuUum
>n ]^ZQP>=;>uXYWQU>R=m uUZƋ=;>u]Y_PRR ZZXQR	 ZR { ZR m ZR [ ZYQR 2f ZYQR 2O ZYQR 2xZYQR 2_ZYSQ  Y[P< tFXô
PSQU  U>V]Y[XUP3>F 
tEAX]PQS >R &S P[YXø PS U>V[XRU  
U>VP ]Z(*q3ɺO f`P  .  : P ͊>V"UPU1.XU bP ͊>VL7RZRZ0N>S[P3fafPfSfQ ۻ  f?_SM_ts OvQj Sj < tAQj Sj < tЀwrgrafGf tWO  Q f Yuf=   wPfXf,g8 tIt#gfXfg8 tf@fg@tgef&=$PnPuW32&C&:]u
uBf&}
 t7j &uSj`&]
[uj &uSje&]
[3tfYf[fXfPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j S< uf>  tf fPfQfRfWf     t;h&rf_fZfYfX
PXE-E07:  PCI BIOS calls not supported. .  	 uM.;D u. 	 u4 toh,'
PXE-E01: Unsupported PCI Devices! h`'ڊP]
PXE-E04: Error reading PCI configuration space. f3ffDEFGHS]m
T^Bus =   Device =   Func =  QW '_YfRfPfSsf  Gff  f_   D	 Mf   f  /	 8{rf  ff[fXfZSfPh'.Ph'.Ph'.PfX[f3S.z .0..0..0..0..>t.B@ ۋ .[j  wPЃ Xu
U |U....>.VfTSAFu u
...>t'h h h.> uhfSfQfR. . .2 <t@h)PH X
PXE-E06: Option ROM requires DDIM support. f    .  f    f.f  fRjfjf. ffPj h2*fQ˃ffu0hR*fZf    x
Invalid PMM function number. f u&h*fZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.f.> tf."ك0t=t	 t  ` b   fd f.d f    .$ Pj h  j .(% . tf.>   r. K         UU *
 V4 *
 33 x ZZ j*
  Z*
 3 .                                   `  p ,  (                  
   
    < @7! <  &      
   '< $   4       <$ $ $!8                '' <  h`hb B4hb @cP$ <p"x$ <" c4 @cQ  !  <" B0 $ C     <pBD  
 P <pB P4Db8DcDd <x" <# <t$    ' <  U<Uc4<     C $U<Uc4     CP $ <  G ! '	 !(  hchbC     $* @      'PDc <xB +C  @ < <PDb + @ <DDcDDb$C @    HDb B00 B$ B, @ @<  
$%  8\d0\b B0@!       PDb <tc  
B0PDbB0+C @         '!(  <$!0  !8         
        '             < 0B4 < 0c4 <74 <"@ $ <" <   ` c$+ @P  `     !H   <B <  C$+D  <# @!@   <  <B <c  $@ !C !H  %  D )@ )% <B <chd@ !C  D E F G J  K        '( $    k   <B @          <" <B @ks< <pc
 
 B4 <pc b $ <1& 2&- hp 2 @  2P       2 @           " @    a  $
 @P   " B$ "
 B, @     <pB  @hs
       >       B" @    b B0 @ $B  C     B @          B B0 @ks< <pcM 
 B4 <pc b <Ɛ <$!(  !8      (Ps 
    ( $      0 '     hbh 
 hb  B8  B0' < B4< c4 b<bc $b\c ]c <  < h b <  <  < $   <$ C 0 B, @ $ <" <$    b8 B, c,%C  @ $ <" <p   $0 B0 C $ <" b$$C  B4 b  <"ks< hb B4hb\b B4\bDb <c B$ <"\$d <B   <$   <ƌ <$  !(      '' !  !   -     h\qhbd &+C 	 @     @hphb  B0 @         `\b B0@           '    B0@          $ <|#    B0 @     <|     B0 @     <|  <|B@         '  PDc <xB 
 -     PDc <B +C @ <DDcDDb$C  @     <-     DDb$P @    HDbB0    ' <B @    Lb	 @ $ b$$$C  b Le9 
Ld      <c $ b     b B0 @     <pB  @ $hbL 
         ' <$$       lXb b    PDb <cB0+C v @    \b \b  4\b \d'  @$ <B B$ < 
" <B B$ <"\b \d 4 \b  $  b$ B0   <B @ 
 !C  $!   ! @  0 @ & D $ " 0 @T @4@ 0 @T $ 0 @T c4 0 @T c4 0 @T c4 0 @T c4 0 @T  c4 0 @T@ c4  0 @T c4 @0 @T c4b0 @T 4 0 @ 0 B 4 " 0 @     B  4 " # & B
 "  "   "  <B    %b    $ , $  B $  $      ( '            ' <c$    b < B$  b]b4 ]d'$(E   @<%(E    22
 T<b8<c!(@  <  <<bA 4 $  $    $    b!  !(   B4   b    '     <B'0 !  4 !  (  $8 !  < , $     T b B0 @    b B0 @ $b 
 $ <B B0 @<c4 b8< 4$C  b $bdb B0 
+ qD` <B B$ B,
 @     b $c B0 B,# $ <$b q8<p <Ɛ R6 <s&  g! `  !(   2 2 <0B4%b b8<$$C  b b 42 $ B4 bd  e! ` $!0 8< 4r  
 s @P!  b B0* @! ` <B   B$ <"g
 $  !0 <B B(
 @8< b$$C  b b B4 b 
!   B4 $d  br!  b B0 @    d  
 $ & N*@    u <1&!    g $  !0 2 @    b B05 @!  hb B4hb\b $!   B4\b  g $  !0 <  
!        <<0B4%b <1&  " B( @!  8< B4( $d  bp 2 @        $ <$  g $!0  !   $ $d  qb B0 @ &*@ $b <$ $  g 3  !0 ! < 8 4 0 , ( $      @ ' <B' $P L H D @ <   C8       
 B0b B0	 @     b$ <%C d   b 
!   <B B0 @     b<c4$C  b $bb B0 
+ d   $ 
 $  '!   <<$ s64B4$  q 16( $%5D`d   bh`    '!@  C: c,&S B,%b  `    hb B0+@      R &b B0 @     & .@T 16  ' $ B $$  <$C 
 C $(  <$C  @ $hb B4hb\b B4\b $b $ B!  d  d $q "2@ &.@ $ 
 "2q "2 B8 B,! @  "2 @ 0 b!    <%C  b 0 @ $ $b $b! P L H D @ < 8  X ' Db b <%C   b b<c4$C   bb B0 @!  Hb $   !` ! ( $  `B$@ c$  B4 c4   !p   	 @'     
   b B0 @!  Hb $   b0 @ $    b     å
  
   B$ ¥B0 B, @ $
 ¡   ¥  @ B0 @ $ 
 ¡  
  ¡  
        Õ ¥ b,N@!x    <!" " @       B0 @ $   ¥ < čc4$C  ­  $ 0$C 
   ­ $   
   a 
  ¥ $a 
  ¥   Í  ¥$$b   íD` b $ <%C  b $  ¥  Õ#C qB,@T $ $a 
  ¥a 
 $
<J5  ȍ $$$@   B0%@ Í$8 @  @c0%8 $H   B0%H" $$0&  B0%0  $$( @  B0%(  $$     B0%   $$  B0 %b    ȭ ǭ ɭ ƭ ŭ ĭ í Õ$J   ­Dc b <%C  b $a 
  ¥
 Ñ $ b!  @ $a 
  ¥ @ B4 ­ Db b <%C  b $  ¥  $
 C$  Õ$D $d  C $	 $a 
  ¥
  C!  @!L 
 $ č<$  @< ̍<c4
<J5	<)5<5<4<4
<5<4
 $  ¥  ˕$`B  c0 %`$P  B0@  Í%PB$HI ĕ    %H#$@( 0% %@$8  B0  Í%8 $0  č  B  c0 %0 $h %  0 $ %h$(E   B8 B0 %(  $$  B  @B0%    $ ̭ ʭ ˥ ɭ ȭ ǭ$ ƭ ͭ  ŭ$   ĭ   B0%b  c4a 
  í
 Ñ $ b     , @ $  Õ#C qB,< @!  B0
 @ < $C 
 @ $  B0. @T<    B0* @T< $a 
  ¥ < ¥ bc4 $$C  b $a 
  ¥
 Ñ $ b      @ $a 
  ¥  Õ#C qB, @!
 $a 
  ¥  $ <%C  @<%C a 
 ­<5!  '    d_wfv_vr11.1  0.rDwfrevi        atafrrEl        ebifknLr    rdwfinIv            a_whgotu        ` x   8 @ @ d   h   \  |                                                            DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:  Download failed

 
Searching for RPL Server ...  Abort

 BCM570X Found

 RPL SERVER NODE ADDR: 

Transferring data from RPL server ...   Done

  Transfering Control to program @  :   /-\|               tttttWS ˌt&  ˍ$        !PXEX8             {                       M      d      d                              PXENV+,$                        M@ d@                 fUfSfQfRfWfVfPF= twO. ~
&ێӼ h@ WPJ
&  fXf^f_fZfYf[f].>  u
~
&` . h@ fv
Phv.6 j ˃
fUffSfQfRfWfVfP. g]g} twer`f&؎м fUh@ WS
f]f&g}& tu   fXf^f_fZfYf[f]fg}&` ڃ> tj USf. ff f3ff   f. 3h f&f. ff& []  Ã>tj j ff9h uf. fh     Ý   V@ g&5   +g&5   ^Ã> t&j f. ff f3ff   f. S3h f&f. ff&[&   Ã>t&j fPj ff9h uf. fh fX&    ÝfX&   Ü=PVu NVf. Uf ]ϝ.6 .6 . . SR[.9 u r   Z[UVSvf&ff&GfD[^]f`. > t;su .$%t а r   fa.>  t-. .>$t!  r ӄt"Qf.>  u8Pwh3Ɏظ&. &G. [i Y3YÜSQ3ێËȋf.>  tFwhff&9tY[ f. f&H f.     3PQRv ! ˃ӈ  "X tZYXPQRv ! ˃"  
X tZYXS. &ێӼ ON t+73!XuVV66N^VbON3tڋxZ&[S. &ێӼ V=OFN3t	ڋ5Z&[   f~ u f~ u^& ꐋF fvyFafvCfvfv֐fv̐fv{fv븐fv뮐fv7뤐fvu뚐fv5됐fv놐fv{fvqfvgfv]fvSfvIfv?fvE5fv+fv!fv= tw#=
 w@. 
= tw#- dHiHnHsHxF += tw- vH{- Ht- ϐF^&~@  >G t  hD2VZ^&GF&GF&GF&GF&GF&GF&G
FD<D?KG  >G u  G 3 3   >G u  FFhD2rYFF   D
uЍDru^&GK^&GT>oFu^@B&G \?^&G >Fu^&G	B^&G
P^&G	 ^&G
 G 3   >G u  FDF  %F@P P YFF^&9Gw&G^>^Z3 >G t>GtD%>F*G 3   FDf+fF^&GtN&GtN&GtNF&F@P P lXFF^&9Gw&G^>^FV"^G 3   VFD^uRptu?LB
FVFtL.
;Fu;Vt L
u^; ^ E?F^Î 	F ^ u	PPX	F   Y=F~'}*^f0fP <	^N&^ f	Ftŋ^ u
fjX	~'u^fPF>\^f&OfN^G F^F  ^&  &t.f&OfNF  F~}-^v& ^F&F  ^F&F~|F  ^v^F&F~|^*&GHtH|pH~I	^& FF^f&OfNftfvvQ&UV^&F&FF  ^&FF&9Gv:fvf&p&@
Vv^&@
Fv&@
F뻐^G  ^fG    ^FG0G2  ^FG4G6  ^fG<    ^fG"fG8F, G*^fG
   ^FNF=3^ DG 3   >G u  FDF  %F@P P *UFF^&9Gw&G^>^F3   V>G u ^ F  F^v& ވ"FF~|3^   >G u  fF    ^&GtN&GtN&GtNDFV3   V>G u ^ >GuDVu^&G  >F*^&G^&G^&G ^&G
 ^&G,  F  ^*F^v&@^"F^v&@F~|աD^&G.
E^&G03^ UfE^f&GfE^f&G
fE^f&GfE^f&G3 3 3   >G u  DhFNRvh3 U^&G^&G ^&G^^&G$&G	^&G&G
^&G&G3   FD^&G^^&G^^&G^^&G^^&G^^&G	^^&G
F^&G^^&G
^^&G3 UfF fP6  QfgF^f&G^3&G&G   FDF  >Gt^^&G F ^uLptu9L&FVFtL;Fu;Vt Lu	^뚐F F^&GHt- r-  ^^&G  qp>8FVF^0u
fF   fF  _uF#F#V^fG$fFfPh8^&G  ^_'^>  t
3&G  k8F  ^>  t^& ^   ^Pd
^&G ^PFأ G^&G^G^&G^GF^^&v*&G
*&oF^&G A&u+&u$&u*&G*&oF^&G ^&G F  F^&GF^&G
^&?u^&G&t
^&G^&G F- t- t^&G ^&G}^&Gs^PE
u!^&G ^PF^1F^F   %5F~}^_t^Q^_'Q^&G  F6   
UG^&G3   FD<<8^9Gu9Wt øFV^0u
fF   fF  _uF#F#Vu3ÐfFf#Fft!^0ufh   fj ^fG$fPhB5^ _'Ë9Gu2Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^RPx10:0ÐURPx 0fv0 URP u @u
fj @fv|S4+4URP u @u
fj @fv|!4fv4   Sf+fFF^; GW ҉FV^fw^w^fwFV  ^^fh  FV  ^FfjFV  ^1vFV  ^CGG؉FG ^G^fG^fG^fG^f^FG_^7HOW #GG  fF^&-Ff~ t^fwlXCF  S2F2FV^扇^FFVQ+
u f~
tf~tf~Mt
f~mu
^Ƈ< ^Ƈ<,<2FV=(u u^+^戇<F<2FV^FFVċ^∇h1^,1FV^扇^F^怿ptqtǇ0Ǉ0 Ǉ2  1F^Ffj |1^fG   ^fwh1h% ^fj @^TFV=Tv,eK$F^XFVF%0 +- t- t&F ^抧F% +- t- t<VFFF@t^Ƈ.Ft^Ƈ/Ft^Ƈ=F΋^Ƈ= ^t>FVFt?F%? ؉FVFF  % ЋF	F	VfF    ^Ƈ,^pFVF^$-F^$p
F ^Ƈ, p {t^Ƈ /^Ƈ^怿quL/FVNfRvL//FVN^怿uNBfNFfv/^怿/ub fF    
 k.fFf~8 s^P=u܁u֋^ #^抧0t #^-fj Dhfh  ` 8h^fǇ   ^ +ҊԊ*ҋ^扇^ xFF  % ЋF^		^抧0ukǇ5  ^Ǉ7  ^Ǉ9  ^Ƈ; ^拇$-@ `uta- t\-  tW- tR-0 ~ tEfFf^F*5Ǉ5 ^Ǉ7 ^Ǉ9 ^Ƈ;f>b    s Ƈ* ^抧pt	fǇ `^抧ptu;(uƇ+=Ƈ*뼐Ƈ+^怿* u&~ t ~ tF+~ t~ uƇ+f+fF^抧0u!=u 0u
fF  ` fF  @ fvt ^怿.t~t	/ 4  *  Ƈ4^ "^抧t uOh  h ^ h*^ ^ mF
P^ FP^ h^ ^怿< th 	 )t^怿< uj 	 h ^3wFĊ֋^*^FFVF^*䈇^FFVĊ^*^F^抇^抇^抇^抇^抇^抇^fǇ    ^fG   ^f+f^戇^戇^扇^扇^Ǉ ^ǇdK f^ǇhK j^Ǉl n^Ǉp r^扇zx^扇~|^扇^扇^Ǉtv^怿u>@*FVf^抧 ufNf @  uN0fFf^拇HHtfǇ   ^Ǉ fǇ   ^Ǉ  Ǉ ^Ǉ ^Ƈ^s&uF^怿 u(uƇƇ^fGfG"^怿* tfǇ    ^Ƈ3Ð  SP #^& #^Î 	 #^è 	 #^ 	 #^ 	 #^G    (^GW^G  ^f+fG^쀿;uGGA|   $FG^'^GW^싇7FFG~^'^쉇  ^Ǉ   ^fǇ  @  ^Ƈ^f+ fFfFfF^f9 v(kD<GFf+fG^G^Î FC#ǐfv fF    fFfF^f9Gv)kD\I؉FG
 ^fG   ^&F"%u(^Ǉ PP| ^ u^ƇÐ  SVF  fwhh(^/ t ^}^ t^/% @fF   fv h^fǇ    ^fǇ    fj | gfj @]^*u	ǇT ǇT ǇV  ^fT /^0t.fF    fFf~Psfj FV ^?ݐ^_f+f^_G
  ^_G  ^_G  ^_G  ^_G  ^pufF   vG u!0u
F  F?v'F 񐊧 u
fF @vfF@v^tpuNfvl /^  u#up FVN Rvp fF4 $fv hfj@Dfj Dfj`Dfj4Dfj
8D^0t5fD^fDfh    ,Dfh    0Dxfj \nfj  \dfj DZ^;t"fj P$F^fwT$8^7hj X$"fh `  \$fjH$fjh$^fGffP,fj^*^fǇ     ^fǇ     fj Yfj Yfj ^ fj ^^f ^9j ^9HǇ  ^;u
fGz    fj;fǇ     fj ^ ^f wfj ^j^5j ^Wfj lXfj tXfj |X^fG    ^*䊇*튏****%FF  vP8fh  <fh &  dfj yfh   lfh  _fj Ufh Hfj>^fd</^fh< ^fl<^fp<^fx<^f|<^f <^f$<^ft(<fj 8<^fw<<fj 0<^fw4<fh   @<zfh   D<m^f0 <^^;t
fj 0Jfj  @fj 46^fT  ^* uU$fF  khf ufN	 khfv?^fT ^;u#+FNPvh( :!fj dfF  fv LfF  ^u uf @  uNfv Hifj (_fj 8Ufj Kfj A^; ufj ,-fj $#fj fj fj ^fǇ\   ^t\^f\\^fǇX   ^tX^fXhfjP^ptuUF F  fv|^
^b^ t2^ 0 F  fF    +uF fFf~ds
 ,^9Gu9Wuf~d fF    fFfFV^f9Gvc ^v_9 u69Pu1fFff`  ff^^w^9@u9PtfF^f9GtF ~ tF~ ^Ð^ t; 3^  SfjX/^GW$FNRvh^3Ð  Sfj X^GW$FRPhz^_thFNRvh^3Ƈ  Sfj X^GW$FNRvh 3  PSVt7؋GFF F؃
H^F(^e- F؃SFF  ^fGx^f9G
v^F^fD3^ÐfG
^f)Gx^GpFFGFfF    ^w*^f@^fG^w*^f@^f^w*^@F  FF^VGW
^拇9HNA#FFF+ҋ^9W r9G
 ^O^FGpWrFGFV ҉FVF+;Fu;V ^f7^FV8^fwFV  ^^fwFV  ^^fwFV  ^^拇9HNV #FF  FFufF @  FfFFMRPFYP^怿ptquj vFY+,^6F^qF~ 3^Ð(  RPSVFVfXZfFFtfFtfFtffF tNffFtN`ff~ t ^ÐFXZfvhF^ҋVf+fFfFfFfFFX^ҁ@ F؉VڊF$F$`Fހff   Nfffvށ 	B	RFF^9>F  vfrFp+F~}^Ҁpufj3^Ð
  SVs^f+fX^^\PPhfj \fF    fFf~'  sh[uf+fFfFf~'  s\9uF  I^ ^PF^6>Fu^P^ ^FuF~skF|F F붋^^ ^>^_G
FF+ҋ^9Gu9Wt<;u`w@F^&[^7HNA#F3^Ð  S/ t A	^^/%  s	^
 3Ð4  SV;u_G
FF  ^ʋGzW|G~F_GFF  ^GWFVfFf9F9^ʀ; t_FV ҉F̉V΍FЉFF  F~s1FFV΋^^v PԋF^F^GF t^ʃ& ^ʰE  ^G^- GG  ^f^fG^f^G  ^ʃPF^ʀ;u-7HNV #FF  _G
FF  5HNV #FF  _Gѐ^ʀ;u
fFfGzF^VGWfvXp^Ð  SRFV^* t
fF   0tfF  fFf#Fftz^^3  F   tf tfu; ttt
NFÐt	NFtNF  RPSF  tIFt)FtFtF 7Ft1F *Ft#FtFtFtF F^XFt^ tt
^X^fXh^\Ft^ tt
^\^f\\3ÐUSt
^Ǉ 3Ë^Ǉ 3Ð  SF * tÐu/0t# ^ FFu	^ ^h ^ j^ h^ j^ h^ h^ h2^ h^ h2^ h ^ rh 
^ e^苇t- t	-  ?hu
 Bhh^ 5hh^ (hh^ h ^	 3
h^  ,FV=(u# u^F^芇<2FFFꈇ<F  ^耿< u6j 	 ^fv,fǇ    !hh hh^ vh 	 ~^苇SVF! hF FA \F  F PF !FDF@ F F 3F@F F !u- = w.|55 5,585D5V5^f t!v3v^ v^	 ~u	h 3^ G^ =FF  j^ ^tpu+ujj  qfF   ^芧0u 0t
0tF F  c'F~ }^ FFtF ^f u F= uF ~ t~ u^Ǉ FF9F~F  똋^Ǉ ^ GF^fTVfFfNF% F N^fǇ ~uNfjP ^芧pu+tfNfǇ ~uSNM^芧pu+tfNfǇ ʚ;~ʐ= w.7P766777P7P7F^VTVfv 8fh  +݋^芧0ufh   fj
݋^胿uF^  F^FV/3Ð  P
@NF  FPvLfF    fFf~'  sL܉FVF  uF  f~'  rfF    F  P
 NNFPQLDfF    fFf~'  sL܉VF  u   RPxSܸhۉF@RPhF  hۉFF@t SF~|Ð  RPSfj @۸ .fhTveK^P۰FV^tIpt=fj pwfF    
 fFf~a  s pBۉFVFtfh  h7۸( ^f^fwh^=u$ 0ufF  ` 	fF  @ fvtfj @ڋ^ 0u_h 3afF    fFf~ds^3Āuh^ 0^< th j 	 h ^3fv^u
f@fF    fFf~8 s^PN=ut	
 
fv^^ڋ^ ptpuDfjPٸ PىFRP Pٸ V
fjp  ٸ C
fj  P3Ð  PV8hىVF  fcF$FV΂RP8hF  
 LF~d}8h\ىFVF @t݃~du3^Ð<h;ىFV*ȋъĊ֊n*ɋ؋VԊ^  RPS*j P\
F*j P`
F  
Fu.F~{~ uFtfF   fF P  FfF @ fF T  FF*+ҋ^{t  F  fj FVF {؃F~ @r^&wf&w
FV&G ^ ^&wf&wFV&G ^ ^&wf&wFV&G ^ FFfjFV ^f&7FV F  :fjFV fh   FV^f&7FV ׸ {
F~sFV ^&9u&9WufjFV vfj FVj{3   RPfF    fFfFf9Fw^Ff7FVFV(   = uuF PF TF  fF    
 o
fFf~'  s,fjFV fh   FV֋FVtf~'  u 3  PSVfFF  7F~}+F% FF  fFffFFFtfv FF9F}^v 1F1VF  뭋FV^Ð
  SfFd   fFfNft^ ,uF  PSF  ptuh 3m< L	3F
 FF3FFN~ 
~ th ^3( 	F  F ^ 0P^ h@^3^	 wFh ^	 h ^ h^ h ^ F   F
P^ h ^ ^h^ p^ F   ffF^^9 uF^9  F  F j^ h@^ h@^ F~~ F
P^ j^ F  ^^ ^ F~|h^ ^FF !F~p^ F^ F^FF ?F  F~}TF
P^ j^ F  j ^ F~|h^ ^uFh^ j ^ h ^ j ^ h ^ ^ P^ tv^	 gv^3[F=uD =uE =uF =u =uG =u =uH =u =uSty=uTtn=u]tc=u^tX=umtM=u
tB=ut7=ut,=ut!=ut=ut=u
MuÐ2Ð  hщFfRvhѸhщFf% = UPS  ^G  ^FG^G  Ë9Gu2Ð  PSV@+wV9Wu2^ËF7@^F^G^Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^  SVGF9u3^Ð@+wW^Ov^@^Ð  S F_GFF  ^fGtfFfFf9Ft[^6X؉F  ^PF^G
^F9I#+҉FV^fG
^fGx^_GFF  뜐F^VGtWvÐUfvb 8  Sst2"=t(rF^Fs^Ft^stfh   h
Ð  SƇ^f+f^Ǉ   ^G G
^Ǉd f^Ǉh j^Ǉl n^Ǉp r^vt^Ƈ^^8,t-
 +%< FF  V>F F  PF F F F ڐF ҐfF    uH= w.pF F,F4F<FDFLFF^V3Ð  SF  FF+ҋ^9W$rLw9G"vE&OFiF ^p G^fG    i^ p  ^GW^&F뤉VFF+ҋ^9 rOw9 vGÎ FiF ^p8G ^fG&    i^ p8l ^G"W$^Î Ff3  S
^&O^Pu  FFFFF+F   Ã ÐUPÐ  PF;FtN~ Ð@ &l &n   h̉FfFRPhfj hfF@B fF    fFfFf9Fv퐸hRPf@B fYf3ff> Ð  f6> RPfXfYffFfF    fFfFf9FvBfh  4RPfXfYf3fffÐ3Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^          2ff
   fP UfP fºffff]UWfP fºffFf_] Ð3Ð2C@@UPQRN;ssZYX]1ff       Vff  
@ &6 +&6 3^     X	S[	[P6  SfZ fFF| f^ fFfb fFFfd fFfh fFFfj fFn FVFP^ȲAt 3  VF  ^f+f&G^&G DGh4GG fG    fG  FD^t	 ^ ^*䊇船>F* ^:tF ^t"hF ^B^*䊇荹 hgF  ^vވM @^MwF~r؋^ X^Pq th.F ~tf.G^f&G>2G xM#G^&G^&G^&G
y^&Gs^&GF^ h@ 3 th`À>G u+0u$GPj
 .GRPfXfYffff

tYG*HtHHt7K>G}u<GPj
 .!GRPfXfYffff]
>GwVuG>GH3Ð  FDF F^^Pc	
u!^P	F^X	^G@WBÐ3Ð  PVF  ^^v& ^M^v&@F~|֋F 
^&G^   FD^Î /	Fuv^ u	PPX[F  ^f0fP <Cǋ^^ Fu F~'|ŋ^ u
fjXǁ~'u^fPFÐ  PSFDG  ^fG    fF^fG0fF^fG4^fG<    ^fG"fG8F, G*^fG
   ^F3  VFu^Ð؋G FPS ^G^G^S GQ	^G E	^G@ B	^GW  0	^GW	@ 	^G!W#	^G%
@  	^G'W) ^G+@
 ^G-W/F  ^M^v@1F~|@ ^G7W9^ G;( ^G<W>$ ^G@WBF  ^4G^v@DF~|础DN^GLGB^GN 6^GPF  ^v@R F~|BS^GXFZ PhhI^d 3^Ð  VRFu^Ð؋G FPS ^)GG^G^S G^G ^G@ ^GWGG^GW  w^GW	@ e^G!W#J^G%
@ G^G'W) ,^G+@
 )^G-W/F  ^M^v@1F~|@ ^G7W9^ G;( ^G<W>$ ^G@WBF  ^4G^v@DF~|础D^GLG^GN }^GPF  ^v@R F~|BSY^GXFZ Phh^d =3^  VFD^PF؋GF^^&} F^G- F^?aYQGF^GFF+F=CG*$Ht	HH~~:^GW	=@^GW
t=WtueNu	2G 2G  GF  CF~}-f^v@"*N t݀Nא^v@"F^F#GF~}>2G tF F  먐^G<)GhphxF   ~^#GF~|hqfj
 .!GRPfXfYffff ~ u^GW
^G tGWnF*G,G^G@t)GWRF؊N.G0GfG^G- Ff*GfР*G% RPF  PFF+*G,GG  ^G)h
 t thj
0G
h]
.G
G
^Ë^&F^^ÐA  SFD^P
u+^PF^&^G^_^G3  RVFF  eF^&9G,~_&x2 ~Gf&p.fv&@2
v^&@2Fv&@2)FF~ D3^ D 
u	DÐD  PVFu^ FDG FPfF fP^&GF  ^v^@F~|^&GFf&GfFF  8vf&p&@v^&@FFF^&9F^VG@WB^F3^ 9Gu2Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^À>wD uwDvDtD   Ð3ÐUPFtDuvDpDrDvD ÐtDÐ  t À>vD uFV+pDrDFVfpDf9FsfFf+pDf  fFfFfpDtD+9Vwr9FwF)tDfFfpD3ÐvD 댐  PV-F8Ft,F~ t$* 	 	^ÐUPĊfÐUPV*ȋъĊ֊n*ɋ؋VԊ^	t	-t-,u 3Ð            Adapter - BCM570x NetXtreme Family B57           HardwareDriverMLID        
            `X  X                      	  
                             
                                                                                                                                            `a                    p                                                                          `ں  ZZZZXXX                [[0[[`\*[w\Z|\\/\`[[0[[\\!\"\)\$\Z\K]E]/]Q]]]```+]+][U>Z4 \+& Uu[u 	XZ
 ]˺Z SVsrt*ݕ+Y^[ø.3Z* &D&Tr+ t+ډD&5&].3Zù  ZøtK
t(S [;Wrw;GrWڋR [;u+u+DDڋDuP XÎه\.Et.  ǃPG*_G,_.O7Huù R.X tXu跩 +gl  gn  7 ñ..Y.ZYr`7Gû6Z 7t&&TW&L+.Xu< .:3ZuOu让.3ZY+.:3ZuuL
Lt\
DPX3~u< s"UX+Ұ.:4Zt+EZnZ]˻6Z  Y  &LOΌOWtَډ7G+&&DøV ^uY&,YXE"u.Yt!YYV^tEU*+QuMZYcQ Xu.4ZeZ`]Q".>Z u.>Z u;Y.>5Z uWu(g.Z.5ZD,ث+|t#+.X..X<rg3.X.X &u&D=vV pY3ɈM .X&&\&T##At.X.9Yu.9Yu.9YtÿpY.XrF;wr&\tItJpYE ].XD&D tz}.X@Mt.X s..X.X@_pYQ&|upY+&dE
&DE&DED)7.X Y@pYE<w.X
Dxt.X;wŉ5EEEU.>XtE  m.XM
u+P.XEP&DEP&DEP&D
EP
ZE.;YuYuJ&D&D&D&D3&L,\.&W&l &T*&LMt
+;r&l*X.X3Ã
Ëŋ+Ht.X
u&Dٽ.X.X+\2&L,&/Iu&l*\`  KBPUSQRWV^_ZY[]X+&D*.5Z+tZ,T+ێÊ&S+ێÊ&&G[úY|w! Lr	t+u+YTLʉLuIuËDDDV^\|uAྼYD<w<XøZøYøXøYWVQX  Y.Y.Y.Z.Z.Z.Z.ZY^_PS [X UFFt%&?	u
h&F^&? u UPFUPFÐu32PSQR 3ɺO3ZY[X   fFV
fFFtf~ t^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_ UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UP$0F<9vFFÐ  U<ps                 d$ $PnP       o              
Copyright (C) 1997-2000  Intel Corporation
 Intel CorporationIntel Base-Code, PXE-2.1 (build 082j) $    I $BC$+   @:^   
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 thP~SwQpRibWZT1
-AX- -BX- -CX- -DX- -DS- -ES-:-DI- -SS-:-SP-
 ÜPh)tX
Waiting...               
  t^@:^ 
h h@ UfPfSfQfRfVv&  &\f?UNDIt?h_& o
PXE-EC4: UNDI ROM ID structure was not found. Gs<hk& '
PXE-EC5: UNDI ROM ID structure is invalid. Pj Sj < uf. fGf;sff. ff. ffGffGff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZNffW.; s. @ 6& ԋfPfSfWfUj j fj fj RfRVQ@ & v &D6E&D6E&D6E&D6E&D
6E
fFffЉVf. ffЉVf. ff6UfGff6UWhTw
˃f6UfVf6UfV
Z cv & tl tc" tZK tQ tHh]Rjh*
PXE-E09: Unexpected UNDI loader error.  Status ==  P
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>  u=h$v & 
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sLh\Pv &  r
PXE-E20: BIOS extended memory copy error.  AH ==  . f.f^f. *rv&D &L. &;D&s&D&fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(Dv
F&DF&D&DPj Vj &(D	v &D6E&D6E&D6E&D6E&D
6E
Wj v&\Z
  Wjuv&\Z Wjvv&\Z  t  uj@ H FF  RWjv&\Z  t{Xt&t
 u tfS^
G HF+F)F[fSVWF  6	fff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 v&< f^fZfYf[fX  t ]˜= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]r.>  u	  . 	Pfj j .(   fZfYf[h
1P<Xt/
Press <Esc> to abort ROM initialization... fPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j V< uf>  tf . fSfQfR. . .2 <t8hq
PXE-E06: Option ROM requires DDIM support. f    ff    .  f    ff  fRjfjf. ffPj hfQ˃ffu0h;fZf    {
Invalid PMM function number. f u)hqfZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.. Pj h j .( . . tf.>   r
.                  blksize tsize                                         U ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j    |      
CLIENT MAC ADDR:  
  PXENV+     GUID:   
DHCP. PXEClient:Arch:00000:UNDI:000000  PXEClient CLIENT IP:    MASK:   
DHCP IP:    PROXY IP:     DHCP IP:  
GATEWAY IP: MD  BD  UD  
Auto-select:
      
BOOT SERVER IP:    (  )   
Auto-select:
                                                                                                -->  MTFTP 
PXE-T :   TFTP Aborted  ProxyDHCP service did not reply to request on port 4011.  Client could not locate a secure server Missing MTFTP server IP address BIS bad entry structure checksum  BIS get signature information failed  BIS free memory failed  BIS get boot object authorization check flag failed BIS shutdown failed BIS initialization failed BIS image/credential validation failed  BIS integrity check failed  Network boot canceled by keystroke  ARP timeout TFTP open timeout TFTP Error - File Not found TFTP Error - Access Violation Error received from TFTP server TFTP unknown opcode TFTP read timeout TFTP cannot open connection TFTP cannot read from connection  No DHCP or proxyDHCP offers were received.  proxyDHCP offers were received.  No DHCP offers were received.  No boot filename received Invalid UNDI API function number  MTFTP cannot initialize NIC for multicast Error while initializing the NIC  Error while initializing the PHY  Error while reading the configuration Data  Error while reading the initialization data Invalid MAC address Invalid EEPROM checksum Error while setting interrupt TFTP too many packages  TFTP packet size is invalid Media test failure, check cable NBP is too big to fit in free base memory Bad or missing discovery server list  Bad or missing multicast discovery address  Bad or missing PXE menu and/or prompt information Could not locate boot server  Invalid state returned from UNDI  PXE-  Invalid message code.
   /-\|            
SM/DMI BIOS functions needed.
 _UUID_  
									       
      
 f~ u ːf~ u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- r- v뾐:: 1LP3 뫋F fv?FF^&)~!~ofv'ҐfvȐfv뾐fv-Fu
hx9 i[F 롐fvFth I[fv[fvmofvАfvƐfvA뼐fv벐fv=fv?	3=1 tw5-  = }.f             $=q )w-2 tHt-= 7-s HHH!3  F  
9  >9 t  JLfFf99f2hP99@t{<IutyIu^h
JuShRF   }R^
RF9*9Fr䡸93MuIun>huYu
"Ft1J9NMqIH~ t~tEVjOhRF FP)Fu9Fu9R 9뮐U>9 t>P3 u>: t  II9Lt9 9 9^&9   V3Y-  +ҊԊ*҉FVFP+$FVu3^Ã>3 t3+ҊԊ*ң(3*3(h2fj vPfj  E/t	f(3    7f(3*3f9FsEy WN뜐T3 fvfvh2fj h96:6:6636H3 |3O8tְE뽐>2u}(3*3% (3ҀĀ FVf(3fFGT3 fFf+(3fPfvh2fj fj fj fj FV37ufvfvf6(3 |K
u	E" 9Uhx9bWFFV^f& |  PVr$=NVu^F^f&G(fFXfv^^  ^&G- r- v  &iGNF^& u*&G^& u=& u6F&GF^&G#&r&G^f&OfQfv&GU3   >9 u  >: t  >P3 t  G|F9f&G    f9  fP2 ~Uf9H fP2 mUf9@ fP2 \Uf9P fP2 KU9S*&GP9&(G9&G0FF  FF9&9G6 fNfNfQhhHT7Uuh:T^*&O;~S*\P
u3^&G^&G^&G^&G^&G^&G^&G$&G
  &G^S*&G
P^&(G	fF^f&G9(It  3!V;.33   ^&  t&  }?  >9 u  >: t  >P3 t  Eu֋FV RPF RPF
 RPF RP^3& 2),u: >: u  3*E3:   >9 u  >: u  >P3 t  fF fP^f&OfQ|1F^&G  F-tHHu9  5  F^&G3   ^& >9 u  >: t  >P3 t  Cu^f& GP P P P& & & & & & 33^&^&Fuf(3f& 3 f&Ǉ     F   >9 u  >: t  >P3 t  ?Cu֋FV RPF RPF
 RPfj E S3ҳn*F2CF^&~ uf(3^f& ^f&Ǉ     F=3 =2 }
c F -6 tHHtKU>9 u  >: t  >P3 t  Bu47f^f&GP33 >9 u  >: t  >P3 u  B3P3   >9 u  >: t  >P3 u  FN~ tIFV RPF RPF RPF
 RP^f&OfQ&G9Ft^&G3 F^&Gv  F>9 u  >: t  >P3 u  ^&
 uQ&G
^f&OfQGPGP&G&W26uF3 F  fF   fF   f+fFfFfFfFfF$mIfjFPvGRPfj*F $KI~ t
E! FËFFtE# fFf Ð  fF   ffF$ IfjFP	GRPfj*F $H~ tE! 2FÐFFtE$ 萸 Ð  fF   ffF$HfjFPFRPfj*F $xH~ tE! EÐFFtE% f~ t 3  RPfF   ffFfFfF$ HfjFP)FRPfj*F $G~ tE! REÐFFtE& 萸 Ð  fF   ffF$GfjFPERPfj
*F $G~ tE! DÐFFtE' fvFP|E L  F+;Vr
w;FvFFF3fvh3HE^KFV "  RPfF    ffFfFfFfFfFfFfFfFfFfFﾭfF    $FfjFPDRPfj*F޸ $F~ tE! D f~ uf~ t  3 WV2   It2^_2&sE( C^_ÐS*&G7H
u⸀22f   ftrHuVHu0HuHu 2^_  RPKHu0fvfvfvFVFHtF  ~u  3   SRPVf~ tDt@u2^ F+v
rD7D0^N&FN+FFNu^ 
  SRPWVF`4^ht32 Kt3R3u39v3h3h
 Kf2fx3 L|3^f&cSc>
  t^&G^_ FHtHHt- tI- tJ-
 tE~3  ^& 5F^& FFHt1HHq- t- c-
 \|3  ^f&f3뷐^& F~u!^& 2F^& F^f&^f& ~ ^& 7FvF^& F^& F^& F^& F^& F^& F^& F^& 
F^& F^& F^& F^& F^& +F^& 6F^& <F^& CF^& F^& F^& F^& F^& F^& F^& F^& F*F^^&^& 9F^& F^& F-  -  -
 t^& ^& Fu{>  t4  h"(CcG			th&Cf6	Ch. Cf>	 t.^& aF^& F^&  FfFfPf6	 AI~u(^& 6F^& F^f&^f& a^& ]F^& FGFJ^& ^& ^F^& F^& F9&_&G	^*& FF9&_&G^& FF^& <F^&  FfFfPh6  HfF fPǺ
  /fF fPF
  fF fPF
   ~ ^& +F^F& ^& GF>  t'^& F^F& ^F& F^&-^& F^F& f% !I^& ^&>2uM^& F^3& ^& FF  !^33H^& &PF39F|^& F^&^& ^_ .@f2fj fj  3Qf    f2f88ht3fj h: C$,h:ht3GUPV3^*& BFfFV^f&G<^&Ǉ  ofFV^f&G@fFV^f&GD̐fFV^f&GH븐fFV^f&GL뤐fFV^f&GP^&Ǉ  ^&Ǉ   fFV^f&GT֐fFV^f&GXfFV^f&G\뮐fFV^f&G`뚐fFV^f&Gh^&Ǉ  ^&Ǉ  ^&_h&u 3^& cfFV^f&Gd= )= wA.JNl=
 k- &H5HD- t-; ^- t^*&@ 9vO^   PV3^*& =4 CtHtzHHtN-
  -  FfF^f&GfF^f&G^&_f&G^f&GpdÌ^&G&W^&_f&G^f&Gx;Ì^&&W^&f&G^f&GtÌ^&G&WfF^f&G$^&_$&	r"^f&G$ fPhX	 DuF F  F*^&  Ì^&G&W
^Sf&G fP&_*&G~Ì^&G&WjfF^f&G,h^f&G, fP&_,*&G@C^&_,&_*^&G|&_~-5 {H- 	- t- t:^*&@ 9v^f& tf&$ u&  u
& & ^ U^&?t3 f2f&9Guf& cScuf&  t؍GPh
9*Cuø    WV3F Dvvv^&7Vj
 & RPfXfYffff88 9 7:fj FPfj fj j 3Pe+thBtix  RPhVBix  RPix RPT
ix &n tF ^&ix&p tF F Fix=zP^&7~ u~ t	^_ 3^_ UFVl RPFp RP 332ht3fj h: C$' Ȏ  ǆr Dfj
 & RPfXfYffff77 8 8fj rPfj fj j 3P**thtȍtPhBf~ t^&uf~  tfF^f&9GlufFf&9Gpuh&$h@fFffFf2  3 UhfFp fP
 3
21ht3fj fFp fP$x& Ȏ  fj
 & RPfXfYffff66 7 7ǆr  hrPfj fj j 3P)t̋r- Dt-guhttPh)f~ tf~ ufF^f&9Gpuh)h?  3 Ȍ  PV3F}Pirx  RPirx  RPtʍtPh)
>2u~ u ^ÍtPirx  RPy
FPFP 3`0$0ht3fj FP C$%3^  RPVF  ivx &t u-FF9F"ivx &n u3FFF>2u
ivx&v uF ivx &p tivx&r ivx &p uF  FF9F}.ivx&n tivx&t tۃ>2u
ivx&v u9F=F Pivx &p "ivxf&h F  FF9F}
ivx&n t9F-ivx &p F  FF9F}ivx&n tivx&r u9F ivx &r ivx&j&hyivx&t {ivx &p XF  FF9F}5ivx&n tivx&r tivxf&h tivx&t uF9FH= .> zHivx &l t=h&$iFxP<ivx f&Xfivxf&`f2	 9f    f2fiFxPiFx  RP_ivx f&\&^fFHHHHHtHtiiFx P 3ivx f& t&ivxf& fPivx&Ę&G*3Fh92 ;F  h92 ;FF9F ivx &n tivx&r uiFx P Y3ivx &&t&ivxf& fPivx&Ę&G*3iFx   RP 3ivx f& t&ivxf& fPivx&Ę&G*2F F9F~  h)h&$: iFx P 2ivx &&t&ivxf& fPivx&Ę&G*K2iFx   RP 32ivx &&divxf& fPivx&Ę&G*1;~ t3h)iFx  RP9ivx &\&^ ^Ð3^Ð  RPFFF  .;3f~tf~ u
F C D~ r~ rF  hFP^^ V~ Cu~3*=*ht3fj FPF$2F   SRPWVFF  fj
 & RPfXfYffff*/3=0 0F  fj FPfj fj j 3P!kF- Dt-g\hOiFx  RPh8iFx  RPiFx RPivx &ĘT&uF Fivx &ĘT&9G F9ivx &ĘT&O#N; ~ taivx &R&P ivx&ĘP&G&WI9FVF  F39FsF^93u93u39Ft[~ tHF  FF9Fs-^vi~x ؎Ff& &P f&;\uȋF9Ft
FiFx=zs	-`F^_ V6hb0h1hn0h21f> t&ff9thx0h0h0hh0h0f>9 t@3f9 t1ƹ +uhc0 R09P0 @0Frh?0^Ð
  WVF9*f|
f2f2f: Dh:2[6f    ffFdF 5 9F~F !uxF ukF u^9F~
F uLF u?  F~}/^ۋ  FPFPtЋF g~ ~ u
FQ ^_ËF9FuFR ^_ÐFS 3F9v~!ix &n uix&p tFU 9vu1~ t+3F9v~!ix &n tix&p uFU 9vt1ix f&Xfixf&`f2ixf&\fFF^_F3^_ÐUfv2 4^f& u 3^& fvfF fPa^f& t&_&GtfvfF, fP@ 8^f& t!&_&GtfvfFl fP (^f&| u^&l tÌl ^&G|&W~^f&G^f&Gl^f&p u^f&G^f&Gp^f&x u^f&G^f&Gx^f& u 3&  Ȍ  >2u4f~ t-tPh-~ uEz k*3 fF^f&tPh)f&)f2fuFFtfFf2f~ t^&G&WE{ 륐399f~ t
^&Gu43:f~ t^&G\43:FFu	63  ^&u&G	*&G+4*63FFuH3  ^&u&G	*&G3*H3f~ u39,3^&G3,3^&G39f~ t^&u
&G333  FV   RP>2u 3F     > w$fvFV;fvVF^Ftʃ~  >2tOh)f6 1f  fP ) f& tf& fP&ğ&G*z)F h-f6 1 f&\fF     > w&fvF3fj F33
tF T3   PVf+fFFfF^ğ
&Fu^ >2uNF  F	9FsA^ğ
&^ğ	&9uً^ğ	*&GF^f	 fF~ u$^&GR&GPt&_P&GtEw T'qF ^f&P t&_P&GtF  ~ tz^&_Tf&GfFm/h)FP
*^&_P&Gt(fvfv^ğ
F&Ft(^ fvfj ^ğ
3&F F ^f&P t&_P&GtF  ~ thfF.h4)^&_P&Gt(fvfv^ğ
F&/Ft&^ fvfj ^ğ
3&	Fu^F  FF9FsIb.h(FFVRP(^vf&0fj ^ğ
3&Ft^ 3^ USRPf`~^NvVFn
fa
 Ȋ WVF  ^&  hPh&$Ph)h^V6  u^V6  u	3^_ ~ ud t^f&P t&_P&GtfX u	   
  ^f&P  &_P&Guy^f&T u
v ^_ &_Tf&t^&_Tf& t^&_Tf&   v^&_T& wr^&_P&Gt@^f&X t&&_X&s$^&_P&Gt^f&X uw ^_  
 ^f&X thF  =^&GX&WZF 				^&_Xv&@* F^&_X*&G;Fw^&_X&G;F~^f&\ tf&` u
t ^_ &_`& t^&_\&r3R
FN^&G\&W^F R


R
ğ
& tR
ğ
*&G FR
^&_\*&G;Fw^&_`&8g h%3
*&G;v
&@%FFrh%3Fs
f9 ufvF@?Ht'&+h%h&)%s[f9 tNEx ^_ f9 t3+ǹ +uh;% *%9Po% %Frh%h
%*F  ~Is)^&_`v& $F^&_`*&GH;Fw^&_`&uh$ ǆ  ^&_`*&Gfǆl @ Ɔh$2	&2&%hn$%tO%= Btw3-t-,u^& Iǆ  t#)F  F  - [t- 
t- 
tאĞ&8t&
uu@)h#ǆ  
*&G;v&@#Frh# +G%
h #ǆ  ^ğ
*&G;v"^ğ
& @#FrȋF9vFh*#FR
9FrF
2$*+R
FvЎf   f^ğ
*&GhXfhp  j VV33Q^f
 fPfh  p VV3 )vPF+- Pfh  p VV3 F#=.t = t -t-t^& )~ tNh fh  j V33f
 fPfh   V3 vPF+- Pfh   V3UF+R
=KF{~ =F  kF+R
='R
HFS-	t-
- = K-w- 9t-
t- - Mt- t- t
  SRPV>63 u63$ >T3 u9 >T3آ9>
 tFu&>T3^P ^f&f2f~ u	24
^&&W99t3   F  ^v& ވv3^Fv&8 u^fǇv3octeF^Ǉv3t FF9~ EuEf~ t>^&? ~4Fv3Ph $&h %@FFv3P^&FF9~ t?f(3    Fv3Ph  %h  %@F^Ƈv30F^Ƈv3 FF9>T3 u
'@'F9N3  J3  63L3>T3 u
z'@v'>T3 t	t(>9 t!ht3h9h2F9t8 >
 tFu.bL3 z>T3  fj fj fj fj j 3P ff92uvff9u:9u1>T3  F&&;w&&; f9f9u&:9tfj fj fj fj j 3Pu|J>T3 t>9 u963L3J363L3J3J3= uE2 2 >T3 >J3~ EF EN3 &- toHHt	HZ>
 t(~ u"hdFhlhh>u; \>u< O>u	= ^ 6 ^ ~ t4ft3   hx3hp
 !$ht3h9h2N3 	> ^ >T3 uE%+Ht
N3  >T3 tff9u9u9ԡ%- F99F~L~~E? k? ^ >T3 t>2 uF9F92  :?h2 >#>T3 u3^ ~ uf~ _^&? SF   f~ tY^&? ~OFPh *u<h )"@FFPZ=~ Et9느9Ff=E  v~ t`FPh  uMh  !@FFPY(3*3ft3   hx3hp
 y"ht3h9h2N3 NFP!@F- 9F}FPi!@F- 9Fft3   ht3h9h2N3 -^    v9t3 v39 >|Y$#^&- v9tf~ tfvl#PQv9!>9 tht3h9h2N39w  v9 J3  >43 t	43L3L3$ L3| >T3 tQfj fj fj fj j 3P%
tfff92u[ff9u9 f9f9u::9/hhfj fj j 3P	t92u9 3t\i>43 u>9 u L3J3J3= uE5 i ht3h9h2N39f뻁> >9 t!+H>T3 t-ff9u"9u>9 u>9N3      Ð
  P3FFFF 1^*䊇N t~ uFFFFF:9FvȋF+F+2@Ffj
 fRPfXfYffffF~ tF9FwF  ^)FXF9Fv	F+FFfj
F RPfXfYffff;Fs"fj
F RPfXfYffffF~#vF#F  SRP9 T3 f+f(3Pj
 fRPfXfYffff63fj
 fRPfXfYffffH3f~ tR^f&? tHf&f9M}b  T32  F
:9 F :?h2 8T3 FF E43  f9f"   fFfFfFfvfvfvFPF32NFt3-6 t&- |p- ~>T3 tNF ET3 봐F FPfj F}$>T3 u9  >43 t43  9v43  9"T3*>T3 199F~F92  :?h2 ?~  ^*䊇N  f9fPFHj PfXfYfffȋFڙډN^:9FwFV;r
w;v:  f9fPFHj PfXfYffFfFfvF@+؋FVt   N^299F}tfFf(3~ ~F~ uFH::92tJFV43?fFf(3f(3f9FKfvF@+؋FVBnf9fF>9 t
99F/>T3 t:92T3 2  E
3 UVVv^$&=  t)ArZw <Ar<Zw FC:t^^ ^3^   VfF    & *N-0 FF^v&8 t&80r&89v3^ F^   WVf+fFF0& *-0 N^ӉFVF^v&8 t&80r&89v3^_ FV^_   VF  F'F=F~F
u~ tF0^v& FFNV
 FF~ u^v&  F@^ h28hV32,V3X3EY3 Z3@03\3`3a3b3  r3  Ð  RPVl3Fn3 Ip3r3  ff9^f&f99p399F9p399  fv9F2r3ffd3^f&fh3p3 Z3b3  0303\3^3  X3
 b3V3^f&? tf&?u	W3 &?r"&?wh83&&W  ^ f~ t
^f&? uhfvfj FVFFV
22##^&&w#2#62;u5;u122##^&&w#2#62;u;uf&    ^f&? ufvSh83%FNW3 Z3F99F$fFfF^f&? "f&?9- FfF- F^3  F fZ3b3  X3
 o
b3hV3fvh83V 	FF- FFFOF ^3F Z3b3  X3
 
b3hV3fvh83 V	FFFFF+F;FwF^3F+F Z3b3  X3
 b3hV3fvh83V+V hV3fvh83 V'	F^   Pf+fFFFFFf>6 tKa;8rBw;6v:>9 t'F
?+ڃ6 689  
f6    hu~t	F~dr3 >uff9ú> uh뼐>uF  
 ;Fu$<uf9f9t
f>  u>uM% Ht H`f9f9Sf+f69Ff>  8N
?+ڃ$>f~ t*ffF^&G&t&9&9WF%  F~tu9Fu9Ftf~ ~ FffF~  ff9ff9999999~ u-F9  t =th1- 9]
;F'f~ t7F^&? t(&9t#F9Fff9FWf~ tf^f&f~ t	^&- F~ u~  - F~ uF9FnfvhnFF;FfFFfPhF
FFF9FO9F9  t<=t7fv9F[	;F? f~ tF9FvFfvhFf~ t^f&? ufFf&f~ t^&? uF&F   RPF  6^&&Wk^9u9ukFPfvF= F~s
k^ uhh? kFPfvFkFPfvFk^Ƈ Uh92 99 h9h
9*h9fF
 fP9*S3&R39999 99 ff9^f&Gf9h9fj G
P ` 
  F  :^&&Wk^9u"9ufvkFP9*3 F~sk^ uh92 99h9h
9*ff9^f&f9S3&R39999 99 F  F	 h9fj fj  FFt$fFF= uΰE 2Fz  h
=tĀ>
u>
 uf
^f&9ufvh
9*fvfv9* F>T3  h2E @0303@   f9fff  f9f 0303 
 hfj h:3Mh:99uh.:  th:h.:!tEb m  6893Ð  FPj9&_t Ð3  FPj9&_t Ð  fF    FPj9&_u6~Ku+~Tu%~ uEa : Ð~Bu~Pu
 3Ð~tްEVԐ  FPj9&_t ÐȈ  fǆz   ǆ~  xPj9&_t ÐȈ  fǆz   ǆ~ FPfv FPfv xPj9&_t    SQ @@@@;؋sY[FPj9&_t 2  FPj9&_u0Fآ9F֣R3Fԣ9Fң9fvFP9*3     fv  `  RPFFV؋F6F FFF~ uF  F FFFfFfFċFFFF^&F&uFfF    F FFFFFPj9&_t    RPFVFPj9&_ufvFP %
3          .&NXf* PWQRU>   @  h> j>9&] us>@ ul>L |i>L |b>L w[>* L &D F +ȋѽ  ( B +V6H ^;s#  u>@ u
3ԡ( ]ZY_3 ~W>   @  h> j>9&]_f`.&N>9tJ.   0  h. j9&_ u0  t9а r   fa.>*N t&.(N! 9r & ӄt"Qf.>(N u8Pwh3Ɏظ O&.(N&G.*N[i Y3YÜSQ3ێËȋf.>(N tFwhf Of&9tY[9f.(Nf&I f.(N    3PQRv ! ˃ӈ&   .,N"X tZYXPQRv ! ˃.",N  
X tZYXUV3 Ӌ^]UV
 3P Yv  t2؃ Ӌ^]UVW  _^]Q  2sYÀ>[
 u[
Z
X
   Ð3ÐUPFX
uZ
5T
V
Z
 ÐX
Ð  t À>Z
 uFV+T
V
FVfT
f9FsfFf+T
f  fFfFfT
X
+9Vwr9FwF)X
fFfT
3ÐZ
 댐  RP>
 tZFh FFhlF* %F^9N u^P mhFNuhUÐ  PV>
 t7$
F 8Ft)F ~ t$ $* ^ÐU+ҋFF    PRt$TEVh ?	-t-,t  PWVf~  ~  FN ^~&&Q#2#222##;u;u3Fsf9 u^&&Q99^~&&Q;9u;9uo^_   V^f&f#2fF^f&f#2f;Ftif~ u99^ 3FsL2499u99t4^&&W99u99uFs99^ 24^ UfSfQfR?f3^f^ff;sf;wf;rf;vf;s@fZfYf[] SQrY[ PS [XUFFt%&?	u
h*&F^&? u UPF  ^F&*: .^F&*' .^F&* .q^*&    P
 +tF
 +0>U^&p^&Gf^&G\^&GR 
^&GC^&G9 ^&G*^&G  ^&G^&G	 ^&G
^&G^&G^&G
^&G^&G u32SQRu	s22ZY[SQRu	s22ZY[SQPRs2ZXPRZXY[  PF 
^F& FFNuF   2*&GÉF&? u2*&G F^&? uF^&? uFF+2u @tHH  \
  ^
\
t\
f&Gf`
&Gf
&Gd
-\
  ^
\
tk\
f&Gf`
&Gf
d
 @h
  d
td
d
37d
+2  2f
9h
u f>`
 uh4 áh
h
uf`
fj
+j
l
f6j
2+2 d
)3뫐URtt Ã>  u3u2&8Fu  V+ɉNFu3^^f&
 t&ws&G
&W&O
NF3^&GFF^&9wvfvhV u^&9GtS&G
uċFV^Ð  YVthn
V	 RP n
Ð t3Ð2&rhn
Ì UfVfWfSfQfRˋffV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F320fZfYf[f_f^] fSfQfVfWOfCORPfEDOMf    f    r'fCORPufEDOMuf=23AIt
f=46AIu   ff_f^fYf[h^_  F  f~ tF^F&? uF   fFV
fFFtf~ t^F&^F&
uFV   PfFV
fFFt*f~ t#~ ~Nt^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_   PWVF  ~vNtFxF F^_   PWVF  ~vNF&%G<ar<zw, arzw :wr F  FF^_ US^FGFGWwGg
oF GFGWFGOG2Cuԉ[3] [[2ҹ G;tWwGg
oogwww_ϒ  PFFV^*&'*&Oû@ &l &n f%  fPf  f#f#f#f#f#f#f#fXS@ & & [ÌUWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] UP$0F<9vFFÐSW ۋSR3.:uJGuZRƀt%@u20 tt
 t2r< u	ZXCu33_[ö΀Z^_SM_h^v_DMI_΀0}^a$PnP΀@^M_SYSID_  P3 f~ tf~ u'  f~ tܸ NtF&? tF^&^&+t   :  rX%  tK:  t
%  !&  $  s9r%  c6  r%  Z5  r5  rH6  9  L:   撰68BAR   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $ k  r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  L  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ X  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 2  X  f=$ J  f$ f$ f    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 7  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t:  $ =$ u	=$  w$ $       f$ $    7     f=$    f$ $ f     f=$    f$ $ wf$ u  9  bf=$ uXf$ $ $ Cf=$ u9f$ $  -  $ f$         f$ f=$ 	r	f$   N    s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz.ZXfPfRfx < fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytEsZ[Xfz.fyu&sZ[XSR=$ tO$ @
 fyf@t	s/fxfz,fyB@u	sfz.Z[                                   P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPUNNNO$ONNO$ O'NNO$O#NONX     lFpoypvp @  쨀tYRfZ @  쨀t	c7     fmRfZ     55 uf
-  
f
-        Q$  sYa  ޿`     t  r@Y8Y1  |  fCfz     3   r    F   r   rR   fPfSfRf*fff,fff*ff3f uUN0NONfOufZf[fXúvpf  ftRffZf=tPSQ   P  XsHuY[Xfu ff;uPSQRWf  	ufz  3f} f ff ff frf%fGff;wf} _ZY[X        =      5  =  (  QS$    P $ O r$$
t   $ uf f  [$  @$ <   br$
tf f  $  Sf  P[rKSUU*UUUUU*U[P$ p  r
<uf f  SQR      <`u
     wr   $ tZY[$  fPSUU*UUU[fX$    pr
8uf f            PSQRf8fff`f  N$ffN$
fffظ  Nf$fN$
ff        =$  u ZY[XPRSf8fff f  N$ffN$
fff  Nf$fN$
ff[ZXfP >>?<u>>?<t>>?tĀ fXð>>?      2ff fff戰䈽!@   戰O     戰   戰䈻  @      @      u׾C%   C%   u戰f @KC8BBaaff fKua$aff fKuf f u           Ԃ  Ӌ؂  Ԃ      PԂ  Ԃ  VQN   `  Ԃ  aQ  J   W  ܂  Ԃ  Y^ð   Ԃ  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP	 %"XP 
   `"	XË                                                    `   $ff$
$0ظ   $ff$
Њ   $ff$
$3ظ   $ff$
ЊvaÐ            f  f  f  f f f f TDDf f  D/f f  Ef f  Ef     fHt쨎t<w.$f ffH$tt
                                         F          <     D                 D                 D                 D          x0     D     ?     0     D                D                 D                 D                D                F          P     D  `              F      X     F          \     D                D                D  1              D                E  <             D                D               E  @             E                D           @     F             D                D          T     F               D               E                E                E                 F             D          @     D         F   9    E8        E0      `  .   U       .   "       /           .   #       /           .   $       /          .          /   	       .   `       /           .   a       /   >       .   0       /          .          >          ?                  E       <qfUMf%f  $f$
tPppqtAfNUff   $f $
и f  $f$
аf  X$fX$
и f  \$f\$
аfUff.~ f"   f%" 3f  f  gf. ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 pV	 f
   `"f  f3f30	f  f%
  u% t
 غf  fVfV|ff  fغf  f﹖ WfW@ff  f  gff   `ffffgf   p$fp$
Ћfgff   xffffgf   $f$
Ћfgf   $f$
Њfgf   $f$
Њf   $f$
Њfgf   ƺ$f$
Ћfgf   ĺ$f$
Ћfgf   $f$
Ћfgf   $f$
Њff|  fff
   fgNf   ~$f~$
Њgf   |$f|$
Њf   }$f}$
ЊgNf   $f$
Њf|  fff%ff   $f$
$@f_Yf   fzYff   =u;f3ffff%  0ff?  0fF  0ff  0=u f%  2f%0f  2f%0fY]ff  @$f@$
= u$<]2f7Zff  @$f@$
и f  D$fD$
аf  $f$
аf  $f$
и <fZf% = ufZf fZnf % ugf [TfU../0./.f([,f d< ufC[fd< t<t
u掰fk[f䎊f}[ff[f掺<uf[f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  fffl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0f    UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
~] t
^+;wUN&NNO'NN ONf  X$fX$
и f  \$f\$
а08$     3ذf f  fff   t! tf  tf f3f  f<vn2ɵ|^rVtT<tq^t`^t	ـݵ^u<t^g<Hu	ـ݀rfffffffs sf;uff
怼$_f   u3 F_u#;sݰ怼n_};tMfa   ufa   ufa  f   f_g.:vfG_q< tg.:vPfa   ufa   ufa  f   f	_6< tg.:vfG
` g.:v fGff   gf.f
f;w
fffb   ufa   ufa  `` g.:v0f   tff   g.:Gvfg.:GvdfG` g.:vfg.:GvBfG`kg.:vfg.:Gv!`L$< t<w=C  B  Ba  a  Kuas6 .va<tH$tt
䠢
t@fغ  ff% f؀f   ttf   ff% f;r       uu uuuu      `p`p2PP<xxF&<<-ZZ400$HH*~2nf|  fff
   fغf|  fff ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 b	 f
   `"f  f3f30	f  f%
  u% t
 غf  fbf)  fݺf  ff  fff$ ff$ fffݼRcfs_cy2sG怿scuŁ$<r
ffŰ怼cj怼cr~	f  ffs2fs+f`  fnf  f~fn2ff32  tkfsdf  f	f`  fff*	f  ffƊf+Ëff`  fffﰥ怊f   @tŀr&`f   $f$
2f3f怼d}f   @us	f   @ffsJfsC~f  ff`  fffÊffغf`  fff^efj(  def  fغf  ff  ef   tec怼e>f|  fff%fغf|  fff("f|  fff
    fغf|  ffff  f%غf  ff  fغf  ff  fغf  ff  fغf  ff  ff """ff  f""f  f"f  fJ	f  f3f  0 f%"	f3f`  ffff3f3gff  ff  ff    ff  f  f  f f  fغf  ff  f
 غf  ff  fغf  f	 f
   `"f  f3f30	f|  ffff    f|  fff~.u;t~.\`f   $f$
Њs.\nf   $f$
Њŀcwf   $f$
Њ݋侨~.uC;t.\pf   $f$
$
Êغf   $f$
Њ
i"%t8t9fص,i %t8t% صLif~f  f<vnf  fغf  f￤if   if;!  ifG!  ifq!  if!  if"  if"  if^$  if%  if>%  f  fغf  ff   $jUf  .f  f怿Jjf_   ff   f|  fffff|  ffff|  ffffff|  fffgff|  fffff f|  fffff   rff   gffgfff|  fffff@f|  fffgff|  fffff0f|  ffffff%   fgf.l  f   ffsff   gfff|  fffff f|  fffff   rff   gffgfff|  fffff`f|  fffgfgfgfgfgfgfgfgff|  fffff0f|  ffffff%   fgf.l  gfff|  fffffpf|  fffgf XV X     ff|  ffnf%fغf|  fffff3nnfp  fff%   tf   fnn tf   fnf`  f<  f3ff f@  ffLs  fȎgff   u	f   f~ffftf`  ff%   ffغf`  ff%   ff;uf`  fffff8 f%   ffff f@  ffLs  fȎgff   u	f   f~ffftf`  fff%  f*2ffغf`  ff%   ff;lf  f
 غf  ff  ff  fȺf  f	f  f3f  0 f%"	f`  f<  f3ff fLs  ff    tfL{  f   f    fHf3Ҽof   fHf3Ҽof   fHf3Ҽof    uf   fHozf   u
f   kf~fffSf`  ff%   ffغf`  ff%   ff;f`  fffff8f%   ffff fLs  ff    tfL{  f   f    fHf3Ҽp f   fHf3Ҽp f   fHf3Ҽpx f    uf   fHq] f   u
f   kf~fffSf`  fff%  f*2ffغf`  ff%   ff;	f|  fff5   fغf|  ffff   t]f    f2   qr ws < ur ws 3r ws 㹸f  q|f  f u	 f
   `"f  f3f   0	~f|  fffr ws 3ff?   fL{  sf3f    f fL|  s)gf&?  ffff uf   xfsfL}  s>f uf   fgf&;ukfffgf&? uWfffmHf~  s!f@   gfgf&;u+fffugf&;ufff(fH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @                                                          @                                                          @                                                          @                                                  @                                                          @                                                          @                                                          @                                                                                                                                           WW                                                UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU   
 
 
    
 
 
                                   ' ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ~戰䈽ֽհf'-f1=Ұf=fGZ԰fSf]Ͱfifs=2ff ffԽ<հff fˇf ׇհfqf԰f[fְfHf f"f @ f.f.~ f"  ؎ f%" 3؎ P_ -pqt]  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I                                                  s6 .d<tH$tt
䠢f  ffff  @ f  ffff  ff   ff  fffff  ffff  ffff   g(
g(33s
uuf,  g
g3f  f   ug.
f@   u f   uʀ f   ug.
Qfŀ   u f   u f   u
g.
Qg.
Qf.  g g8f3s0s
؋Bts
t	ffff  g. f3fȴ2 uf  f  g. 
f0  g(
g(#f1  g(
g(#f2  g(
g(3f3  g(
g(f4  g(
g(f5  g(
g(fX  g(
g(f\  f%
 'Ⱥf\  ff3ff%   ffff%   ffff%   ff tf    uf   3	f   ff   f
f3.߉f3.fff3f   t.ǉffʺfx  fff% fȺfx  ffff3f   u	f   f    u	f 0@f 0@~ wfwff|  fff%?fȺf|  ffff3ɱ u
 u2f@   tfŀ   tf   tf   t2f  g.f3ɱ u
 u2ff%   f
f  g.
f   g.
f  f% غf  f uK uK.f  f$
Ⱥf  f
Ձ 
f   tf3 u t=f
   f3.ffȺf  fff%fȺf  fff               06/23/05BRA    @ c07/07/05DATm