#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68BDD)  - Linux-Based"
BIOS_VERSION="F.14"
FILENAME="sp30819.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  O` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  wA*A*  A* 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  A*2  2   IMEM   EXE  A*2  KV' D  8DTA   BIN  	A*A*  #E2   68BDD   BIN  |m22  ]2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZ[  `     8a             
(      C   
    \       j        m    i
      ^  8    t    	                       q    
        l  [  S  1    s"  M"  8"  !  !  !  !  ]   W   #  #   O
 O
 O
B(  )(  	(  '  '  '  '  
 
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
O
O
 O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
O
|O
xO
tO
pO
lO
hO
dO
`O
\O
XO
TO
PO
LO
HO
DO
@O
<O
8O
4O
0O
,O
(O
$O
 O
O
O
O
O
O
C  C  yC  kA  ZA  )A  #A  @  MF  GF  +F  D  D  TO
$O
O
O
O
O
O
vO
LO
.O
O
O
O
O
O
O
nO
PO
2O
 
#Q  P  P  P  P   
^  X^  G^  ?^  -^  Fa  b  :b    c	O
0O
*O
O
  .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        3ÐjDː
  F  F~ F F^z9 uvfvo'}fvfv]'~hd	h jMRPWVtj
fvvPt
hd	h jN`RP*Vtj
fvvPG
 Ð3f>^  tf6^ ؉f>  tf6 ŉj _;  Vh j7h j,h j!h  h Ïjv_h ҍ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hn F^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPhjbRPBjRRP2jBRP"j2RPj"RPj	RPj
RP⅃jRP҅jRPj
RP貅j_NFF9F}-^v&&?-t^F&&?/uF "[z=sjxtRPTjK_ZtjyURP5j,_>V   hd	h hn Pdfhfuj fh  ! hK
h>if6ffh   hK
h>,d| f6fcfF    .^
~ ^&0>^&>F~	vF  F| 9F|F= t= ujRPhj_^ZbZfh  j $^ ` ^ ujzMRP-j$^+
>R  tD  Zt( !  9  =  A  E  I jJj1fj誅   ujzRP賃j]t(b       ؎f&fjxRPij`]>P  t>R  t\  Z  L  >\ t>\ u& & & >\ u-F>T  u	>L   >L   >\ u3T Ht	HtHt8j euwjJulj?jI.>\ u?T Ht
HtHtHtIjj WȐju+jRP胂jT HHtH
Y>T  t7>N  t0flA  hlhlj~
>x tjJRP*>J  tXj \Ud  F >d >P  t>R  t\  Z  L  >\ t>\ u& & & >\ uD:&~ tfj fj M.F  =HtkI-
 -!- - - 
tFfUw>  ~  H   6 H; ~    ߃> ~  H6 Ĵ &@u  H;~  6 Ĵ &@u   FV^& &G|&Wpfj 8Ad    F >J  t=Kd B= M- K- '-M- 0- )fjG>J  t2
j Y^ÐU
^&J&LÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&Ðl"n
 hhlhljmX >x2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFfFf-   f;FvfvUFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRP`UFᐃ~ b  F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP蟂
	3ÐSfv
 ÐT  Vfh  P FP͂flK  Fthhlhlj>x t3^ÐFPLyBFVhd	h FP8RPhxhd	h fvRPhd xfvhd @x ^Ð  F>FK
l"nFtFhhlhlj(m*ÐU~uhd	h  Ð~ fh` j hd	h hd x[fhfu3Ðf`    
f`   ff9`sVfh   f6`fh  `f6^ u*u%f6ffh  f6^ \= uf&G
 tf6fY놐f6fY?~ uhd	h 1a     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP
afh   vfh`  j f6^ $@v  WVd	~" f~ thd	h FPHv~ FPu3^_hd	h hd Yfhftj ff-   fPf6fx
f6fjFPw
f6fz~ uF.~uF6f 8Fug 8Fuh 8Ftf6fXkFPhf6fW ^_Ð~ fh  C.hd	h hd Xfhf
f`    	`bff9`sTf6ffh  f6^ X= Xf&G
 Kfh   f6`fh  `f6^ u
)t!f6f4Wfh  `^_Ðfh   vfh`  j f6^ \U     ء` +^  &&W    ؋F&  &G    ؎f&       ؎& 6 hK
h>    RP}
F> tjJj1j f6 P}jhd	h(      RP|
6 hK
h>     RP|
     ء` +^  &&W    f&        ؎f&       ؎&  &  FF܌VF Z   R   \   fl
S hlhljTs
>x u_>o@Z RflN  fp    FޣFܣvhhlhljy>x t>muR   hLNu~ t\   Ft
F$p*\ Ð&  VFF܌VflD vQCthhlhljx>x t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	l&lZhhlhljCx>x tjkRPu  fh  ! hK
h>zj{RPWF  @ +FHuF F^
&>TxP&*PhPj*cXF 9F}j |Ĉf<t<uhd	h2 GWÐ  += t= u%F  F~}
Fu~|3Ð Ð>Z  u#jIRPtjJRPt3ø TxP&PhPjWhtuÐ0  f+fFfF9F tJPj ff-    fPfh  `FPfFffFF+Ҋ*FVFVfh  u3ÐfF    D  `RPJFVfFf  fPJ;Fu;Vt>F  uf~ufFfff;FvfFVf9Fw9Vrw9FvҐ ÐB  WVf+fFfFPj ff-    fPfvFP2~ uf~u
F   ^_fFffFF+Ҋ*FVFVfFfFfFfFVf9FvfjFVRP0Jې~  fF    fFffFȸd	~4 fffFfFfFfFf-   f;FvfvqIFVِf~qhXku2f+fFfFf~svBPƋVFVRPRIِ^_   jF "hPj
3UjRP3TFF*;s6PjRPTF*P2uTxP&
P뫐TxP&
PhPj
Tj|RPaqju,jCeRPEqjDURP5q>J  thhd j1RPmSÐ  [fh  Ohht"jMRPpjNRPpj{RPpfh  ujEF  jRPhd	hH RF~uv FF*;sPjlRPRj F*Puπ>X XujKCRPhd	h> yRjL-RPhd	hD cR>J  zt~ hd	h2 :RF 8TxP&
PhPj
SF~sF F ;FF*;sfh   Pfh  j f6^ fh   F*Pfh`  j f6^ F*Pj&fRPQj F*PujDRPhd	hH hhd j)RPeQj[RPjZRPhd	hN EQÐ  3fh 'hht"jMRPnjNRPnj{RPnfh  ujEF  jwRPhd	hH PF~uv FF*;sPjDRPPjF*Pvuπ>X XujKRPhd	h> QPjLRPhd	hD ;P>J  Rt~ F 8TxP&
PhPj
PF~sF F GFF*;sfh   Pfh  j f6^ mfh   F*Pfh`  j f6^ F*Pj&JRPOjF*P|uj(RPhd	hH  hhd j 
RPIOj[RPjZRPhd	hN )OÐ  F >\ ut~ thd	hV hd	hb FPrhhd	h FPKFVu3vPfh  f6^ K= s^&G
 tF  fvJO>\ u~ t	hd	hn hd	hz FPghd	h FPMKFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfPxB  F J.u35tF f6^ FP0F~rhd	h hd	hV *JFVtvPfh  f6^ K= s^&G
 tF  fvH~ ujRPLhd	hV j!RPLF*  F u3-txt~ thd	hV FPfj"hd	hb FPfj#BRPFPehd	h FPHIFVtvPfh  f6^ CI= s^&G
 tF  fvH~ tj$RPL90F~  F ohPj
LF  hPj LFj$;F~TxP& P܊F*PjkRPKf6^ FP0FF~s#~ t~ uTwP&
PtFPFPj%RPOK~ u~ tjjRP/KF  F f6^ FPm.~uPhd	h hd	hV GFVu3vPfh  f6^ DI= s^&G
 tF  fvFFÐUf6^ FP/Ð  F Tu3F F~s7F*Pj2RPnJf6^ FP<uhd	h2 OJhd	h hd	hn GFVtvPfh   f6^ H= s^&G
 tF  fvETxP&
P
hPj
JF hPj JFj N*;~TxP& PՐTxP&
PhPj
oJ~ uj-RPiIhd	hn j!RPQIF*  F 8u3t~ thd	hn FPbj"hd	hz FPbj#RPFPkbhd	h FPEFVtvPfh   f6^ E= s^&G
 tF  fvD~  j$QRPH:EF phPj
aIF  hPj MIFj$R;F~TxP& P܊F*PjRP#Hf6^ FPR:FF~s#~ t~ uTwP&
Pt~ tFPFPj%RPG~ u~ tjjiRPGF  F f6^ FP9u3À~uLhd	h hd	hn KDFVtvPfh   f6^ E= s^&G
 tF  fvCFÐUf6^ FPW9ÐU  2 UvV>Ð  >vVF*^&F^&  >% 
FNÐU
U  À6U6Ð  F
+F@FFF!vvW	F>NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU% ^&*^&ÐUF
FÐ  >FF  FPNQ *;F|	F> F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2H>H 	H  iÐHi  ~ t	h)8FNuÐ  FjfvFP]
F FPNQVRhd	h ^Sb~uvvhd	h fv#bÃ~P|FlFFPvvhd	h fvaÐ  FPNQVRhd	h fv6bvvvhd	h FPaFPNQVRhd	h fvavvvhd	h FP}aFPFP\ÐUvRP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv\fvh\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j߃RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  
 & FF  @
 &ğ &0߃FVRP3[FF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^
6 &Ĵ &@t2j>vjqj+jFvv^
6 &Ĵ &@ F  F j9Fu
F F  ^
6 &Ĵ &@tF vv}
 &ğ v&0݃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l
^& ܃RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjۃFVRP
X *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7ڃRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wكRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0փRPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0ӃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
'
6 &Ĵ &p
ӃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0ЃRPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;F}FF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FFPv~ 7
FFF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>\ uFP!ÐFP>\ ut ÐU>\ uFP+ÐFPU>\ uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh>FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh>vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh,?htth,?hِ }= t= ut '҃>Z  t fj h2N3  FJ1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 JSh@hP*F*P˃uFJ| j h@hP j˃]FUtKj˃hK
hd j hhlfj hG=th@hPEtÐhK
hhK
h~&Ð&ÐU~ u hK
hjhHhK
hjh7F  F~ ujFÐF Df>   F{ j h~Ahfh  ̃uF  FuF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh~Ah`j F*P̃u>X XnQfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ 2ڃfh   F*Pfh`  j f6^ uڃF*@N*1 j h~Ahj F*P5˃h~ Rfj hF: j fh  ʃhK
hd fh  ʃt"hK
hhK
h{t"fj hE
fj hl=uShPAht!h~Ahttfj hPU~ u hK
hjhhK
hjhF  F~ uj-FÐF Df>   F{ j h0DhBfh ɃuF  F+uF~  ~;1 F  Fff   ffffN*+;|;sF*@N*1 Sh0DhjF*PRɃu>X Xnfj hNF~fF 1 F mFff   ffffN*+;t|;snjSF*PShSf6^ ׃fh   F*Pfh`  j f6^ ׃F*@N*1 j h0DhjF*Pȃh~ Rfj hMF:  fh ?ȃhK
hd Mfh 'ȃt"hK
hhK
hɹt"gfj hE[fj hl=uhDht!h0Dht fj hÃ>J  tj htd d   1 ~ uj߃FÐF Dj <Ճud j hFh"RtF F~s3c F*1 j hFh"`FPHuFA j hFh"8he>\ utTOtM0tFj t:ohDhfj hl}=thFh"{tÐ  :1 ~ ujoރFÐF DF F~s-F*1 :j hGh@~FPFuF:A j hGh@Vh또>\ ut>Ut7j hh3fj h=thGh@tÐ  X1 ~ uj݃FÐjaӃuÐF DRd j hHh^qtF F~s3Rj F*1 Xj hHh^~FPfuFXA j hHh^Vhc>\ utTmtMNtFjt:hDhfj hl=thHh^tÐUfvhr  jF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
NjOÐU*FPPKj*PKÐU*FPPKF*PjPwKÐ  > u7]  FVL;Vrw;Fv	 ÐFP
uh h U  > u
FPh iÐU  > u
FPh IÐUFPh 9FPh -j> th UFPh FPh FPh j|MÐ  > tRFPh FPh FPh FPh j0 h l<u  > u&v*N"FF FF
FPvBjÐ=tw$-t-| u)  >t% Ð -t-t t-0 t Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U졞FPgÐFPtHtÐ	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð   h FF )fF~}j v`tF  F~s#> tFPh F  f+fF볐>  F  `> t(^&k^&?t  FfF~|F~s> tFPh ;f+fFҐ> uKF~}Afh   j FV^& ^& h. F 닐FPh j FV^&^&Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h fh   FPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uPh Zj FF  
& FP4tFPhK
hփ~ thd	h@hd	hLFP3hd	h FPUFVu3vPfh0  FPLfv4FPhK
h'ָ UՊFPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  XhpՃh 
ufh  h j
u  7fh@ hhRPhFPfh  =fh\  hhfh\  hj 6h{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6hfhL8 hh%CFfhL8 hF$PhCfh   Tfh  Hhԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
fӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAh
  fhx AF  F~
}YhxA$PhxAj2҃hxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPh ҃m$PÐUj
ыFPh fh  	jmjыh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
4ыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >hσÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h
΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3 ~u @F Fހ~
sth Ƀ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  
& FP輴tFPhK
hɃ~ thd	hXhd	hdFP&hd	h FP	FVu3fj hvPo(
fvfh  FP	fvFPhK
hȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû ËaËaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..`f^gef[UfS..`f^gef[UfS..`f^gfeff[UPfS..`f^Fgef[XUPfS..`f^Fgef[XUfPfS..`f^fFgfef[fX                           UfPS^tf3ff`  f.`.` "  u  $" u [fX 0!<s3P˿K
6 + r ׁľsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6+3	O3X 66666
P.:bظ cP.:bۚLg  y>	uXP	 PK
 5! %b!

)&6, 

3
sx

 
&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky

 

 

 U3U UVW UVW.!Q
u' `t ``z 

b >	u 


M 

S  tX
Pu~ uF  X
uFL!_^]Ë

 
 %!;s
OO
;sEtU P>" t" P]ø Y+r
;&rQ3 V3B 22Ut
 Pt ^Ï( <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>
GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &(U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV(
;t@t3_^] UWvt 3I >	u	@!_] SQ QP,[Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<v*טÊ  UWVFG
@tG
  D
u VށD8FVD*P{|]~ tZ>PNQ!FFV~\t@PFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN4-DD
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPPFPvvPPFPPWF_]ÐU!
t]UVWvD
t^@uZuGD
D4u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
D43ۊ\uPuuGPt\ttu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށD4tL
G L
G ڍGTTDD  ^] UWVFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7BFȁD4؊FG
+EEEFEيF3EGǌ^_]ÐUVWv(Pt,\t	0tuVD4D
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvD4t,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'vD4@t^*&GPy= ^]ÐUWV3F؋O
рuGuD4t7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWVD3~~ uD
tV@uF96$r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆr:t)ǆr4FFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.6yrJuwwwxtxxxxwJu<uxxrxJuxxtxxrRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] zzz {L{T{}{{UwVW3FFv&vF
t~ }F<, <Xw$ FF.dzV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UVD+FF96$r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33BK
&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV3V@tG96$s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁD4؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVPvv&PPFPPW Pvv;u)TxPP&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWVBFVTFPv
vVpx& V3P,^_]ÐUVIFVTRPFPv
vP^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3K
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	`t	F3] UFu


u { rFGFF3҃vvډWNu(t$> uS#5!["#%!usʻ 
FV]U_ .8tK
I	]PPR.:b؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PUK
ء
F
F]XSQRK
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ1$%!3]UWVRQSP.:bۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y&;s+3UVv&L^]UVWNwi	tHԔ6		VW_^s+_;uX6	&t	;ut^Ԕt
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]            K
              4.64  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 ABSOLUTE  
%s
  %s
 
%s
  %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation This operation is not permitted on systems configured with Computrace PC Tracking software  BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   d	                            68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) ZC  + , @  . / F  \ ] F a b G e f jH h i jI '  K
 `  K
  D10/17/2001  O                                                                           d	 d	 d	 d	 d	0d	pd	d	d	
d	Bd	td	d	d	,d	Jd	fd	d	d	d	d	$d	Fd	fd	vd	d	d	d	d	d	d	*d	>d	fd	d	d	d	d	d	d	d	d	d	&d	.d	Pd	fd	nd	d	d	d	d	d	d	d	d	d	d	d	d	,d	>d	Pd	dd	xd	d	d	d	d	d	d	<d	\d	d	d	d	d	 	d	Z	d		d		d		d		d		d		d	
d	"
d	B
d	V
d	j
d	z
d	
d	
d	
d	
d	
d	$d	d	:d	Vd	xd	&d	d	d	fd	d	d	2d	Pd	jd	d	d	d	d	d	d	$
d	R
d	~
d	
d	
d	
d	d	 d	0d	                                  E    F    B l `K
      C    D    B l ~K
      G    H    B l K
      K    L    B l K
      M    N    B l K
      Q    R l K
      P    O n K
      I    J    R l &K
      -     1    + o DK
      V     S n bK
      *    1    ( o zK
      T    U     W   
X   
S m K
      Z    [    Y l K
      0     1    . o K
      _    ^ m K
      c     1    a o K
      g     1    e o 4K
      j     1    h o RK
      q    r    s    t     u     p l pK
               c                           _C_FILE_INFO=                                                         K
               
	
\ \                                  YK
  YK
                                                                                                                                                                                                                                                                                                                                                                                                                                             (K
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          ccccccc               (((((                  H                                                                                                                                                                                              bbb                  kK
K
K
K
K
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                  P  D     ,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$2Ruc/C 203-Memory Address Error 
Non-System disk orceQ
replace and striky key when ready
}
602-Dette Boot RecordH3  5EE Run Configuration Utility1720-SMART HaDrive detects imminent failure (Fping Attr: ??)

Please back up the co{nt s of"!hd1run
HDD Self Test in F10#tup 1800-TempeAlert  7`{A `!proc ~has beSed !ap$s n@or($C7MOS&3-*)s aJ'2)()[(by POST o1155Bo?Comm P *Assignm!lic&611-Prima Flopp.01n22-SndA33_1s201tGrol&495Type417A8si:`=9Y6=>0=0=A0=A>9 1=FF>3h6x:2@>60-Fix )Bdoe)sup* wBlo ModJ%1YK1/LJM722@71 P~?Q11s73OKKODMAM3/NXM5Wa )Id ify`!mAm0\\Z^%_4] ` %8Ma_c^WParam`r TableBIp+Hal( c 59ap1i>Upd @ b0q!:j... Invalid elronic serial _numbeb19I/O ROM%39Kn$;3 s:304sUnit4Load_all -%hDk4`MonochromP&l 164ESiz<OsIxB$W"&Instxpketwork#rv:RdAct"No spachqk16P6Op*1spt$ h Che 2  PCI Bush|%;10-Ex0in0qStorag@<evi >HxF1[ z2h:lCU1U	21z2ߌ3܋3	22 9qrѕ/>IOCHECK a yl@|3-{Tiz& Da  O X 6   Powe{r-PPassd9XrOK Do youllz@a0to p1!"s? [Y/N]ҝRuV͛AdipaЈگRP$or1hiqnQo (ABOp= 'C_trl +`&tDel'|8-11@C: Tp!(changed2: 6mpne'A3СЈ3_: Videon-4z:rrup0-(f`5iȐM6_ an)P`$expansAbp   TurnR"ej@(fsݽ<F1>:G AbaU1b1^b-rmal2PUp mu`$U3giq"wa:,ѫ+Bk(Strg+Un/tbr,CI!5ѪpnT@!f:ow1;o@uWtom c2umed: ;s To  mci: KbytR+cksum$o,N@fauPou0OlxpkWA)Next? Ehti2%Exx1Sssa A7cce= cݠ F10 OF2 CߕSS Ibߔ  auinuempu0i %! Mai!ance HCoTt<.swix- uspkTmodu7[mefdrequire1s.  D @o cڄ.% LaM#B@l'Mib?ay12re0Oexcee@pܵq)QM )E1!+|p"CircuaL>vUnO )w0lndS(."j.@U%,E4H"#P$.S03 2)p cocؐ&,VInr1ŇShutmdown  &y@Q`!`e0c݈PIN:+ [
]Nrq!left ՀЊހ)@i.u ʕOysp)opU0" bp'%PӔpkeqdppcuchipq)bemn%p`͞O%&*!ld/*New-s~@^m+O,ҿ+6*bAeTb &r	R d1	7tܱt	A ' m_3, aff`p`;ma,𡰽bPmak< 7un3usiItAongP_en %86*0	 5eu^lJBw7re lAc ǐСaZFS~F2a}.`ERRORyYhp~goneyTla MѳIEx (MSGIDX) R  t   _      8     
   .h   n f  ffff0 ISvݓV Q'  A  p          > |    T {  gG W e M AY 9|@. 0Y  EnSa0~ G ( @ ظ   f3  ?f
 4 P f pπp6 f6   } /  6 >x  .hv PS $<t4r g[X  DisplayCompaqLogo `
u1WGXrB7Xr<W. u)(.< t.߈hP.cpa Oo !"$#`6Ph4vrAV(< 
u^V3!&  ^(P*^ ''2 aSP( 22< tFX[úB +$PQR  ZY/02?3_4 56789;?<_=eAGraphics f`qt<.-  D.&.ރ6.u  #l O .PAtELrsCalling GetIntelBitmapAddr r8C vJr-x+D+\  r@ .hrnfa0A PR1.3PZiX@OOA.PQ`&Fa`.>OuhPP)XhNr.>CNSÿfPfQR	PaintBG A.fh f3f% aZfYfXeH URQSWF^
D= F\ ^^F_\މ^t
;v F;F
 < uW`b < ȭ22 IF t蘾eee~e빀c% d8t
`  euPj Ѓ;}
+V 
N JZ=@euAN`5-_[YZ]`PY&X&@SPQa^ kPZY0-UkPkP]]].uvw xz?{_|}~߀`Q0]h *Y]PeQwLQDf&YCC7PpKpabݻ  ]a3YaPnð@SjP3pX?[ADRY$&%<GP WP	 ff t@  [+P2`Q24}`Qf3XW? l[WSfRU3S`F.fGenuuhfineIu_f}HuVf=sL=r=vPtK f  =   	tŀuvrr f@@3t5uZfDY $<@tK<tGFH$u6f5ۊff#Ct Bt	]fZf[
ff ȱ Ѝҋwh
f`?   , zFqhM:hH'h8駲Nؾ  <D 10Ëދ38t" QW_YF N;r+A+&FGN uɆF@"0rF1}󤒶ؿ6:D6}b"h]@߿E9  󻤌6텸i (00U= r&&+=ù=rW> _<us&604&2
, fgh  0 pqr  <ABCDE xyz{|}   f!QfRߛR â&B r
&  ε0ZRήΰ`YuSQV3
Ê^Y[.<  .FuN.WW _XUWfVUSW! fv߿ h, ޿RV~2,ك!IN 3t^
u
t_ ؋N_[]f^_SV h²^[þ w 0OSRZF10=ROM Based Setup/# EHrHePrt 0A  O` F u  ! )waÂtM 3u!D` ! Gp sGjP$4Z@W& 3tD/T2=Networkrvice BootWake On LANAgtteHto" 5D>2W0 htPM0 r	" F0u8 1baE ID2f\right01F6 T	2nQ0P y0sc <V3V<^hi3%as Q $s^2oQWVRSu4y3V0NF V3؁V?	uCFG~N@t`Gf`ha4r1v^hi3f)Z^_Y[
.0$<tNotebook hard? driveHMultiBay^JDockHbCb(top)bottomy)left@Flopp  USB!"CD-1%#H>!#Super'GNIC%j1+1+,2-,3o+23 4568?9_:;< =>?A?B_CDEFGHJ?K4RpLppL	mpL
pLpLpL
$NBN`VN~NolectDeͿRS͹U@ and mothe hp lq your cho. ? PressCWose.Seconds until au atic defa` start:   &<(d$\';]!#ZipCK`t= Dr= k\d hpr S0ÿ0.&t   e 2V3V؊' tA<v<st1& 2d2Aj4QeYA?r c@ s.
*. .pn+jjj(Pj #f  npz  p o  02gb
   t0d32Ɋ <F8tF3V $ ZPqpqq !URVQ.,.L.T^Y^Z]ySz.*[z݁{QSVW/ s&Q.<.-00?00.رY_^[YQ q`u hPr `t0at+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu; `2bXʱpd {nr
;wo2ҀqnOJAygFYô.*<U2HYPW0hN fhĒ hr hqÒ_fP!> 1;BFJ! h؃f@ 6Djf.fffȵ3>vO2Micro Sm[CBus Reader$ PW .g&:u&Gf_g&gݿ Oa߾$_  ?  \   B`h-PPg&F \g&F  u
hZbg&F&XPg&Fa  r?a@ &   @ r) a{"  e޾d׎~ع    v}aQRV`DT r&%^ZYkfPfL	
"bxLу  rр^ " jGǩa$&Y@( t  rP N(Q?'CYPQ2'Ar ug&9N(t Pwmr`r[ ;w}(;r
ָ	ttǸ`¹  r݋BݓCPQGysrPRf1 Z1.>oh4v\rfPS@ͻǀuh3r<t	B [fX.> t.fQfRWf  2f?\ff@_fZfYQfgf&=TDSSu ԋ ff3gf_uf.>f^f_YPQRW5r?_ZPVW TGI$tu!t쪃u &_^^ H$ f3ɵ`g6LA, I vv I;vaSWQRHuʀPpq4{bXZY_V@A<A@3ɹ2 u#¼ P% = @uXu"]V@%aVRP x@    s@P`PP d `hUT X?g `q	 @@P        ޽?QP A0`   1nޖ,9SP0@4@8(@*  .P@b	_ ,P :8c	h @dP f   !@

^
 

ա!qC 6 @. Ua /.s p. ra0
. )`Rabh NN w O!N R0N`a
IGaO $a(CaO+ a3@a`ON 4
Na]m heu!G!"dο` hfQt &TPR@&fYf8tW*%%C&Ւ@&#&>T tRc ~rE^(&]f3C h]}k~0G 1, < t&tG *B**3+O&+--.a/#f352**f&T uf
ffKf&&&!fCZ/0A8*6?7*P8.8&86@9#8 9#hy`v@!? !?&&=SQ"d3r`&&&@A@ǚABY[$)fPffRfVWf 3ffCf[fKfSF0r!e0*а K I+rP"d_0؀f@SQVW:龠 u3߱_^3t3p!ef @M r;.7u'P uͿ" hhXPh7xPRAU UEfW Qt% s	 f& fff>&fhmD3tg p ; pu7)f;)Pf ~/u!^/{u^/u^/u	g& ?tx3XOrn;fQZǂɀZ@]bZP-~/u^/t `c	 ;&Q`Gf&K ɯklmo/pOqor stuvx/yOzo{ |}~/Oo χ/Oo ϐ/Oo ϙ/Oo Ϣ/OoPAVf`f.&&u hP#İ5rWrRrM&tfwfA| pXV t#Br"p?#   / ' iy> ?f]i  LfUr*6X  R Z rGq Kuf]M aE rCF+ @.3dcg&8E t fEGH #RjKX(m r(>& t4EQVhY3Z cPׇf&HiKW{ r^ r
  GC_>>?t$AɊ?$wWw  _Wl  sq?_  ?Q q0߰@B ? ð 3 S Sp' "Q ЀPП ̀ʰcAQy/AԊ?QWEԨuptPGX_Yù
 d hcRxs@f
P <uAbܭuĀ PR? ? < uZ0ފA߁D t	A׹ eߝ<|<t<t2<tH0Q[\"L
LE#L^$#LfU
T2+"D
D#DDff#Df0f`Sn k 1l 
 1 S  U Kik U 1 M Sk	 U
 k 0v
 {j i  2 0k i *   So p*i = w T oo 0i 5M O N ` @< lm! @Y" m# ( T$ %q % V& 1j i* d _ U; '2' ) y+ @\, NZ- i/ T0 1 Ї2 M3 m= P> m? %@ -nS vA ftp m5 g2m n26 m7 'T9 *iG 9NH  : 4 jC 1D UE ZkF 1I0J 0P. 
K akL 5TM #N ]mO "YP nQ sR V #iW JlXPY MZ 1[ hb c GVe nig 1\1" f"0 @ ؠ   H  f   3P/0P/ L.DѴPX% hX@ .X=X@u
_^rYPԊظ٢Δِ
9PWJ;f&E1_XhWghoh4ht%5 h+"?vv" H !  PQq0> 3_YXLhۤcSF 2h# _h>J>V &=tGDG Hi$h}s&s	I KO   ! $!f` T] *hh uOpQffajDvPQ3F? XF8`3 AJؾL &>vV&DE>&&D >V_u d5zY667 5~Y6ѷ9j@  ?B)}
}	=>V)33S[tS׫[@oא)2@[sMA3 ttohdCSc&s
Jha4hhD
Ͽ< D+DuL
p
E$<uHD
@sd
{#Jr& uJfp:` uL
 6 6jVuY9  MX)6dN &u{h3sD	\
bM}Gu* pM D&}?u J t&Eb t KH&E^DH&Efw>Ut6Uj t.& \t	&  tYX{&Yxu	I\	PSqX} PX ?X؍>V_3& ?^W>V	_[XUt+tX# Z xtY  t aw\D@FPV!$!"tXh15Q9q&  ^XFFhEFr!L	vTt
v߲*c`WFV]<'Q_m$<v @Su{<j_a3  v
p
u$@"<u@P>ȷX\PRt#:1thG4!Qă wv=HoZX0`22ǿV& 8t5ǖV=ǆVtOuF0: u	=t!?sF J u5 *is
t!$&ӄӄa{׃/콿$3`0hEs?ˇ)  V @NWu @N}0^ 3f`WG@_Wf_%)ְ)}@!U!ߚ  ) W&egWʃO&MuO OfG2tM1t$O1t,t"OG%r Ǿp:MБoOg&W/ @gPv
P2ch(akGl_kרtQ<uLD8] =_7D D	 d
zMQQkbHtS0rG&}	r??23ut`ha&EV$I	&M&]c`~.'	Q%f rY.t]SϠ6U ShF 
~|hͅss܃]RR$ Q$ZW&= uA6Pxh)
h
o m_P
t  U!w#w !#` #JhS5 ;._-.M!jNP;tI rJ;.58vuu@@qB 0.aW$
ɷ1.D U
5Y0 @[X_Ë
`PS@5[X Sϲ1.H50oLR?
`.Z,<u(fPfRffPf,ZJ vGdu
wp̀χ_ PkS1. ɋу[vɃaw$7 Н@c~SQWf3Ҡfr
<u	fpqv@_`{`֎f{h,h73۹ F
t):u%VD	& hp/V & 	 h%/s5V3aF$3 
3 )` V cS : .u 30t'& [9 r6Qv- r*0&' t&f1+ #'0x
vx'+ %QQw1s 0RkzZzt0t h&^ D 0aYQ?~Jk[r=Mu(PL% = t!_@Y1S3V+6 
`WHH9E&TEQW,zTr0}phÁ>xf1V @u$P<PtRuxZDpw]yOrZ	
>pZ^0WV 0  PEX@ Px(
Qr5'W2=ƀB>@P?!C@E?r@D((@Pu,u`

@

+&C3ɿ23&]t0(
t&
0  f!"b"5  Ӱ(&!(@!T
uG! "b": >B"H#&"b"? $w ^PRW!&uA߈.&].&UL
t ˀAI0]2_ZXb3һ -w62C./yN ?hΓx~ 6_ u߸^904`{߀<?=_>?g>u  '|}  Cfcf3fgu 3 Q>U@Ps:ύuBE&8Uu8PF]
R +B&U
ZKDؾC@EIZAfYB #w'qr h7Yg|bF!(t ֥NĐObFÃh}xcরh'
<tZێûPp K`^f0  XUEXD
 @[c?@^^GIIUf`e؎ FwF.  ڎfafSfQf.Ffdfff#fYf[cVftGf    dEIgf;t&ff jggSh	gsFPEf^e`2rۈfaf`P}V} ?faPm3_X.> F0C .ohg/TACOqFYq Qhq&rrq	&r .E fjq%rW.ntF5rvE fFf.F`||FF.Ff.>F BE.F t@pFtatY@pFtNp g|i@SIpVfB.qft;VrT%ǂfgꄜ̅ܠoi PfQfRhfefffgDkfr. |v Ejf@z.ffHz|FzfXf>df3рuhs?Is*g|tVf+f;wffߋf3w3R|ҒU|Ff^Jh'RhhSÜ$.pgQPiɠ`h333Ҹ  QW> Xp|_F
3}5up|JE#ȩ t0 t0ߋ A `t
Ήt} tWM_ }~   ؉F EF^V } SV^pQP&tY&  
`< tr&\]&\U@
&mNd V
S؂[u 	F& 4F^[_2F F^<db~}10VWًذУ' V䱵r_^Y[XWfQwSgց d f^^t
!p[fY_` t =$PnPu2MߋءtaË6s } tp( ` j Y&& |_SRUQj@6^]Z-V` `XL`^X~p*F
 ' t#jp|yPaF F\ d3duhZKu`<Uuùh3d `h|4ﰭd&Θqtû   hno& h3o9PhӜ{ї԰`ԝX!$!O Pp °Os`|O 
ehZI   tt 4 hS6` tKur& &  
 ڐڰ`0h*s <t<uuOѪu?z1*`PywhXh׻ _% P 4S'$[és# PXz#СZtUP`X} 
]`G  l#m 3 輈D1pÀ   ; Z x     0NP``^~Vbhi1fF3.]PU r 
0ވBFuр~2wFd#m-00
<2wd8F w(
8F wI N@kF ;t
 u@mF^KہcP.~r@V»  aPû< fPypff @ffRfPf!N4
 ffFf3fv1	ZfFswfBPfdf]1 r9\@k`f3ɐB?ǿ:fј  faÒfPV3vrF3`YX

S,0<	v	,$MR.[W D

L'f'((f]
T?
T *#+	#+
#+fw_C!f Ўfv,  P. :FP
u|f^fNfV_Sf^#5-PcR-0	f1P1V.V/͹F1 .h.1`eb#
ff  fffffX]k94ʌ .6f>f>f fngfg`p0S 9 󤿾0U%? a5P*h4v3RP,@SVW0@fQh
yYÆV2u5Qq~Vth7Ɠ 5/@?_^[ø@]PRhq4D>?? U(K*K4K:K@KDK0탻M f.Qw r  @P hCJh ZXoKLRMM?PSSO0` ػ7   YA]p?q$W KqX p3qð X&q"ɡY XĀuYX[t!%\ ZVtUD^uU`X%Eû 3ɰX<KuPn;qEohiCJ_0As-U$dqU - t+==vPfP ZtPa XgPہ?UuC33oђu u= PdV$ @3 Pf^ XeWIdc&& &0Ft hԃu򿣶{30b h
t[V Ȱ t
Uŀv#t̰jw7xxuD5~^PXayv[}B~8v&> 㟸 hΣ֨`tw`_P3 Vu $hA
#qV!  s0xX uz.yX0yX t2Wh`!ìuP趸uK 
wApX2 Q  hPu= Dt= tY	誷YxX^!U h讵Pf=s,ue0<  1hU `Xva L 6Pjf.ff09ha rTPR r QRW3} hثtt_Z"SQ Dorr	!xxfY`@Z..BB <t BB2JƃݾHZ༐  8uQ@A`23Ұ
Shdt0`́ y autЫпi at]U [aS?R  4VT@`1-V1{a hC	 h|
 "B02PaԀa$8uXRPb2XZ@QrtwvYu0ѹ }R _wZP^6 U2<UQ@WJuW佧uJu󓾧tC8f`gW`@۽ e hݖٸ u
3Ҹ wš%vŸvŰ ]
 sC)V uƳPف>Dǳ A 
谁0@t0޷ghN$h# u0KBO

h0   UU&i &&g & & & & p t0p w@ABێ0 ۾P] 
 qH0`1&>r 4u=fSof O ] 1ߙ8f[Pǣ     f@8 9Po^@"9b^j	r>@sڀ  W ` 潙` 
  "# 
 Uuo A t&r .s t kv; tu ܣ"f23f@O  f> ? <  vPO f) '@  wf fyQf.Sǻ @!aA`uft@ W&|}~fsrAO #o XP
8t"*eP׈.xy{ [0G u5 ׈. n21_ߡ >@<s㡡Pw @
A.ڡ u	t R.O#52ޠ&  ﰰ#Eh Ph=qh 5 ـ t>arEh [$ f%"ca j j hpXX1bTO׋ShFh|" tE2?s 1W|1x{0y t? um1b}/  tE. 0W 
!"0  ^ t!E@m66cta@at a[PhS09pv%` D + sz+(tR,!R-B.,/[SW&L 2 >u
o @qB
u
>@u~f >Pu>L rp4L wf?@rHo0BU!]Hs.L 0&O  6WQSL O 33? 9@	R[Y_h Г@u$2ߋBSd@F3?`<u-!f[U :4tu
9 -w@	"R5t5uL 2}Ep-_[WSPR`ZXiL`m7͊96: &*23 G&CJ2  &EfK KdLJ r&u&5N4JJyX&KN GFLN6nM>
3@X$OO&2uG&2%& !8Xţ ב@	[_7p۵/B ٙ@qo 0Y+ `Y=`0YZt2!SRUfVňL f&7f u&Z&?Zu `_ G&!a &@qtL *f&6  808t L "b2f^] VWf @o  !XfAd3f0 OOf  h1chr_^0dWV ۳p`
^!`|4֎318 `; Y DTDo   mn]|n 0  h`;qw m?l  Q sa (  sW @`; sL H`; sA P`; s6T W X2r`/``; sqؾn]qeAan|\D 9Pi<S } }}} Sp}Gq[@g<
uh XVhdK!!'4v'i#!'PPQWh"G3 3?_Y  0ePQ= `tl  @fYX "@	SP
&ߣ  ff&g X[@h  @d pr  Òr {`v hu.fRf '[JŚOFfQ   h,X.v]V2 ~b <t. l~_ tq.Dri."D.|u.:D_tSISwD:Sr5+Ss&Sv
uqPQm
ci)Aӏ<PQRau!&U$`Ȱ hcSQW@a$a  hSЁ 7hq3ѻ']>֬_j2揺 TCA6 @QQPC@}0@;uYð!?$PPߎhsf`p3f`o 3ѿw舭Гu7faÚ@i.Cp7h'pF`y
x;tYch#.*g?tf`f`8  f%=awh3a8β0A@r>V:*&}t#Mthctb uu F3d Ѻ
  % 迩VWU-Ƨ a"h@ #E*8su&(*{ 
úv Ւ uʻ巸 0f4%  0b_ й`xՒ?`a0gPDP;o3Xð#? t
5d@ 
O܊"ðd`djr`a=ɶ z`a@GQGBZPv& <`s$3	 +ѿ3A,`a `&XYWU XW @ ΤFPؿgE01&؁@ uM9NwN@huӃ~ t"F= wt% @+wڰX@D@×hcԼŃ%rw [Ƨ
PV" kXM\E]wz ]U`UhzF    !	 @Cp a `7 `'ts滿4 v t>0u *䎨v6	绳 adt5 t2 t tf2f
 !0@Genuu#fineIuжnteluf @Ј` 33Ҋŧt/7.6;t=%UA@@f.q hff`f.qf f .?f.6qxX0
QhÑ*P1ÀGf_faWkf#`Tj  f,ƀ% $%2&&f xTj `g p֬,xm+|,f,|,|,|,|,ʌ/|l+f$`e ӿ6*PfQ#0fZfYq$SB8E  =u?2H>q9[ñ 0p'Vwqp5p巻0 軀A@gf`@h-59r6002r3s1FG3s ҉#= 17Efa1EItLxE~Ff   /4.HO4K5PSPS	 fߎf3Puf @  DeU7 tU*ӀpU`Uy tURUU|PXÌ  Z C"%['% C< B<V]\^^U^$\__	@T؏焛 3@ @urT uipE3b@.b;UodnZ?#fff	g [ŧ}UOauߊ׀17#hP=tM9pq"7rPjFrX?pZr { PUX@ASQ 32Pur"xڡb=, 6Hjf.fff fWh}33
f0$X q `"	  "	8@@9>2% @9h3fPA XJAh$жl@v 
f#7fPfQU؁T	}ϻ ;sQSfre 8"C2fƃ 0fXff
 q[ffpY+vAеq_L2_&e uZ=PrUf#% YuCfy*;f=  t0a t( f`pf
!0"`h94UaZd P#s_FoZ $nKphpt1

36x @ hT"uF F hXQ"uP7MXt5 p hn
ﰳEo3ߋ
P
>t. hp#@uKh?; u
.96 0Fo% < tt
u8tYR 䏈#fa2u  w & PPQXt'vt
t@  pԻP% r/o h"uP>u   h"us?-&>! rrRzwspZ	thZuuul	r`	 `+Zjj b}6uS`` FF ph"u r{u
V@ V  >t !$!$< uC` 
N<̣_2<ģ}	$ܣ"3`A7y1Ͱh[@u TYP=`EMt w5M
u"2Ɋ،؎} Ȏ؊t<u
5MPȵՋE$<u&w $tݚFb/EL  N L N  ؠu û  t W P[Eu
j ?jGgI(!!2(<o!`b}V Psu$0t̀$߀~t.#K .t4&^P<r&.w0X3.\  U.\E.d b P p W	x .|?_DuQ&~% PPXӹ
 T.:t
 ._
vnXP%8Xr6%ȸQ E	CEa    PJNL p      QKOMp {@
t  t P(.DG H h#K~3 hvChҵ h~ AE^  f  %Pp m oт 
v %&.|t&
&r"P$Q.:D{t1KuR
`E(px" sR	.EXQ&`31"C `H rUr`2h!"uٰ%v&aVRQSh7_uThԽSJb}.ˀ68u,2
t&6@t2_ s 04ޝ[YZ^SûwcX<?tF_h]3Ejjjj P &hCC\ hc$f4b5t = ;t= Dt
hGu[] }WVS`q
w[ ̵;u"q9*׿OطhMt`<-=>J=Ot_1 0ᾠL#v rhAApBNs^as0ҿ!ls:^ Q% St-$p<puIW 7 4 u1G h"u˷ MM0o÷Ohåt<÷PEQuheS*S}R? 8z   3YaaavWUF8aft  u@"t@"3P&&WXXfu33ff&3 ufF?ȋ5zt0ްL m5[Q`?  :NQ`2  ?AQ`%a? 	
1ccvcrcFpǋVW 2_2vpwt"g2
u
2E O
 @2up2&&&Em&e?
td&Epm&&EromEp&E<r&}	rnnnVW^2g^2*n
&}vr~P꠶h}
PRQ3g7w
%wtyY3RPSQY[XZh=|$huOd
g@v}} > Q ^0X_Ye-7: tOT
G*6h"G6&&  t8Vot' u G,6 }6$@$ "& && E8 p`dde`P`  XCVU @9
ڹ 0 . BdB把8uGЖAЖ;Ж5Ж/䉮Ж)Ж#C;BЖ󔰙љG66PX ђ@ApBpCp֐ОVtv}v}Ȱv}蝊`<;weċSX؊H<wM3ɆQ#"XR< rYыƊȊĴ3Їу\ 78g$@Ihu@tJw	2f}PFk 2|Tf&. "  V&k !o< hPhдu$f&PBÊ$
F ~u%qϭuhz㏡$档b鰳&@Pf  f#f#f#f#f#f#f#{GVfPfSfQfRVWbh<6fX&TLx}%ff
fh
.ŉf3f3ɹ f0ɪQZ f+f ! K Xu*Xآ$r3rsV4C\`y a^/_^fZfYf[f{3h[6
   `3h6VtKVV?91tu*SWg= twt	?Wt뀇uG⻹ D
  hu|Z u
9t	 QDa`T2| 揀 s< |&?	3yt`Zg;u ռ v&*-&t
cd_KBC Kernel: xx.xx
 ` ؾlhv'   t? p.``3۸ 2;J軈%aVWQ{ɢ k_^DCV` hA?3$h uP$<X!p%rsf @  t< 4 Lr	.$<u
K  Bf3hh/.  
Pp3Jdw t
P#gT Dh5=  t^bwY-s.> Hްf=:F t&`V u@? o > c aFdHeHf Fc~ck7~e uQ C9  h#5
eK	6
@hKBFe:Ff`Mr,  hs Fds;  A 	:  <g ht%h"5h>6asf`WphKh&~ u>fB0 BSCA[t$ Nh hFSNg r'm@{f)   F^ß	
P XSĻ  y ,`   hS[t(t@t,֬ },5r ' ah*t
úw}."x**{5/.%<ᄽ+Ë(/#U2NfQ+dYF :uE1{]1]t
t
u
t#u
otNPt"FFa70u3! :5tFFdz_ ulmP3F: uY2@3eob +2u6F1464e4 5Ff@3f&9`up  jjj(j	R 	EaURnhO!;2   k ŗ!? hD	Z]RZr@a!  t0CRQ QYsY2$
QCB !u$}i55Zf` w PusIg.&bf  s
Pbh,#  sC ƀuPu.>  MNfaJ'URt9~wMn p [o 1tq +N  oi8YgU kRVu4 ?VfRfaphfI$#% ^f[r@G" } Hh4v#@Qh	r s %6[RMlpO2P s rcWPZU@q4T`.u}Q$<u:|phr"&  tBn tBn tAT{to αLP uqjzq:S_jj k |AjآVްSQ 3lu,Sl赣[rEn	˱LͿY[CAT <ff<1`00xx00`6a{||}>>N.}rtXX@ u[8*rAG ;^<Q7 {& 2hSCC  E 7rB 5b{uN D`I
0
0
acA 60 F (4iC aUfV 3vCDPDQD 77?f^]PF໰OK JV -PduXDAP\Fߏ@ HH 'O{o|}~A  "..& f%pY0 ~6ËFACSO4DBGP4HP HP0890  !CPQR  y8 PICZ?n["!1
  		
 Pa©	 ʂt pp(upPUӷ
 2Ϲ RSDT(  #f`htJhW.Jpf  fRkԜf  gfFgf  FPT?R ffggFސfP.p^$f3.{.xf.the#tgFmо`gfN~$f;+hmD#R-D]43ffgf&f.>tfܐ]f(.ytx2*  ݉~( ݋N g&F	f  rg#fffff+f+.|ֵ[.?>pfq܋$$!$P Xff-QV3g&fFgp^Y[@A!ff=TDSDt+St#PtSBStf=CIPAtf=PGBDt: PAQr>$< u DrRUfQъ̓2 tS@9CrDr v};ޠAptg&P.XJf?Y8]P^u_fWfVϻ`kf&fۀ.@خ@wf fP}q)&Ȁ$ 4 
Ȱ @-@ff	h΃h$ pf th$fPW %fX~ 5ӄpF g߫fι.  Ұsg&wsh
ϒPpҫ(p^_Ū5ΤV	xy{ |^{r {@|f  ߢf%=  wDb^pRW D hB 7hNB_ZuPSWtǸSP%`ufP3h f&L ɍfˍPkpL fXPT`΍hZJ" 03f00 &?  ? 6Wu_  $`$ 0OGWfa 3ۦ[" P#'#1(U1(  P# W>W&geE E %uM%M0GfEB(tXA(t$OA(t32/t)O$fMo&rþ-0+mMe&Wa~
ΰ  ο Gø ^ \DAW ܊f
0h1^Xttտ Eƿ@qE >E<<w_Fha4 ێË̌ҎӼRQYZҋhi?PTӛf`FF  hvJ ]9up_ hT< wFU$wF(wF,wF0wFu4wF8wF DqcÃ9FtFfN1FF> h[ɀ5LN5L(fa`~CѿgEp13ɊMh0#t

h/B;r@huaBWF~C ^0cf [ fN`фW I%XNvf.9uu [ut_h rfQPH_%`rf;^uf;Nt7WXofAt_ o
tF~WY_%ɐpfV Wt> $rj.<t1!PuEhOm1,,`gg^_0ubf0g0 u,hlfd..D+h}ZCuh^VWSRQc, $@jf.faȅFZ[_ؠ8fS!_fqtA"pr  u
3As  t'gfy@tGhGC~G$<lDCOMPAQ PC Card SmartxReaderLGEMPLUS GPR400L?PSCR bxxyQzLB REFLEX 20Qz241 PCMCIAzVReflex } v.2T~c:!xr$HPw~  au@g&O Gd q`؅ ȳ rLfK sr>qG	 .WDau
qPO@.d.D4fƱ_ PQW 0k
G.g&:uG`Y.5_YXÁ8t e Fg`fWr@ဧgH
*#uG f_B` S7?hC Tu#{ ׹ pu .u = ~1rp&tj`t_& rT  r&= us e6>
r/6r4.؋V< t ^Jv 
w x y 05  hDhӚz PZ%]h">ӚaB1zTrPqtI	&| 
%
qtQ&es;%GYV׸
w&} ^,ƴ ߍvf fD  ߺ,A fLs-<t(<# 0&~ hL^bRU32t
t
u
 t u9<0r<9w/tM> ASQ 8Y[@t>"$,0>?*SQE;f tuߋ]ZXBf`73&!hnTG֎fvph,s8gf9t wa2ʳ  ˳ t?h>B$a0Egf Vff3Ѐj"gfy@AF f0cˀf!
Ò޾u3۹: 8tCP # t5rnAh? @u w ?  00u `? 0    0     'r ' ۜ 
 9/ "%b6qk0u3q`9 k11qEuPS_.kBVW ŭ׎Ǎ~Qr&} u­Br	ǭ:=p_^$2_r5r!rE@&=u	@H΃ Hr&E$u*5mIuB@ӆΎ`3ra DTtr&ϊeÀou*D
TǓ
_%MSAi1r# t itct  t$2PѭfT-L p]a>  3]
ÆQu@+Waz `:r8u_QY_QþL[ r&U;0mþ0{N}W1L螣	P2

P$X` $2LgnB

<t޵uHP8u6
uBp& DBl0
t
va
 3 r/) r%BBpJ`
; p5 aù<t
BJ @u`~pB%I2۬2`$u+Bl&2]8u\u rq@m riP6~ ra0ñ tAc rF n r:i r5&D@u-&P%&$߃vF'Q(> Yr	2^QR ڷY,(B-Aq.`/BƷr /y/2qf`j پASzSE2Bg3#{O[\g h% `f= psu [jh rc Sjjjj P Ǵ\ h[?cu;<?j:&&^;p<$&bg@tq= ;tbu= w<t:ݳ {e3 1ת0@yEZtEN[fa]Ⱦ ʾq翚Et@u):P&E˃< u@0uL@ n@J`E3@r$ jrπ DƆ    re3ZaS  -ZA"VAI$WPP0J_ǀ uu'"S 3g rTe. `Txe   .f  0Y>PPf ;t0@e3Y[lqj~bs3hCVPRIۻ Cۻ> =ۻ 彃F  ~f0m  tIe3r=? Ȝ~ t@tpE΃@ MF t wk`@=sN agF ~ t};	e3emoh0pSJ3tY4ʡf` Wf3Q fYY@ Fـ 2m y,muJI:%&= t: n߅e3 r_i@@VQ&[UA
e3sY^A^
e3f"Ӧ~U|
@Q|?:%@M(Ya Ihe@E҈ SpE󐂐 w(Y ņ N poߑH-@}ݻsnu`&YSa{u[$	шaILt3$`
Y|@2|{ f~w\hJfԶ(YRXtГ1J@BxqxCy$7R< Z/tHÈa7vQVWf^DUYa.&ۏKzt'ÆH& NtЀ~t.1nA0`n 61TU9;@df@>?@#VeABC
CGST؝a           VQ    P`@`;t
YY ^NV^$TBL$PCI    P  $CLM"    4$fptqfPfSfQfRf3f f3fg.}	/ 	@ 2 	fƀnuo 	nZfYf[fXpWUu	  	3`r]aq 
#C
ERXYgc> 2Q`ް(Yùm `ù DaV  .:u.n!^$%f_Q8aY!fQRfCPt
' "`
Pv
"O2ɵ PZ t"
ǆmWPfP  ؊2fl 2QW pw	t2$_Yôq3f@
%S~` [Pp 0X.
tÀu@u[Pf
4 	g*f8 *a,Rff~%fؐ..+.;w
Z
$Ue <u
`V`<12a2@`|<z@=q<@]Q4f<	@}4[<
@4P<u@4E<@=p:<
A47/f= uffX<@7<@7]]fW f_2cpPuf_QRfVfWSft,fff ^r!fp;tftfN77  +[ff_f^ZY^>с 	 r?prf r ;u*A
`A0BBC= @	ҠH sQ;tp_r"R{< fR fZG z,X
[2JʲKL .ZLHM	NKOROPffqM# PMLNKSS RLOfMUPKOSOLYZXV>YPsZSP[SfTRXMf s#(` sf t` s	a t
 `QVWf&? f&bﴉ3.fSP&Gf&_fXf[ ` ~( p _^YSQR@>fPw&fd P g f;t
fXRv39W
ffff_fBfEff#tϰk f_TCM!p߀MQfu`# P"f UI8s2ہs
Z*SfW`@)6-y`t#uP{aHXt}xPC[PSf<t; /30e ts
Hfu
utǳ%[`3}aPZfvl`_X1e'$PIR    $t` a b c $ b a >r i  f}0 c j !fphG'`t6s   0 kq`%;`0MWff `p
t_ްnfnf
f`aOVWH#gSikW ;_t[lPmF[_^qWp!f` f8u cfffGfY2h2aܘPC
oXPS fS[s$fR
wf_fX$[ؒfӟRq1%D Ð[џBS22EޠHr'} Yuf H8s֊Ҋ
XQ iRP
t0kr?r#bEE  uf }úM< % UPfPCT".0.[fXZoKf4.  tp [bM`_ݩSM]fa_f]rffr%mz 	&ng@..%İ,)fEѶ.&8&2%Ѷ@"ѶD.%Ч!,=ndrs:b
û2誱_ 	f^ |i
w t5;;J*f`dk 	wARAv *)u6	R+	f;N`?f f{ 	Bg✊>?r>?f> fPDWB< t+
 t
3Ͳ 	r& 
A1股ذx 	Pc`> K


fr~V^~f.RfJ)HZRUQf fuffVfK=XfuNVFYQku F{MuY ^Y]gs><afPRg'QSVfNVFf߸L^[YrfXftA/3PX߸Mc"NWOKP>hUWV spP  ଱֡ _]`phWU2賱q話蟱!蕶 ]]BpXRVr 	^Vc3   	/Oo /Oo  /Oo 	

/Oo /Oog+?GiP   `r(D
@  nvArHvA. sNfօj@&t FN aR3V.vVZr#M8gu 6Ur`'t 2rXĀ# u +v thr&3&EC-0-.r"- .rT/2-vR(s ÆUu
FUF Qô蛴	,-%.-Q8	 /3/%.:_	r蟥@e-R.Q8E	 6p脰.^F&?s  Asd d &G&w&G0G&OD
 &	GCѬ.Mf.uFE	feG FEUFEAGGGAGVfQS\fk[AGdGfY^f&o u# fG f_Wf!MqMspdRKWѭ܀C (FA,~r .>ίt7pPϰP/r?# t8pP trP tpPаR2wrVSʀs= )~V	`TQUvV~t$pVtpVu/~ǉ~ %PNVXPsW^X6W.|uLu..zV`>U .:Uta[~VaPWQS??!0.}u.:Mw#.;]	w.:uw_w.;w	@`wx[Y_# t>ـ?_r.u|
ՊdEЀ ʿ.E+v 藠@fVfv=ЬdDAi e~b؊fd
@NPpg.eXfmȋ¾d_s$
2d
ў]ffXAiygdDipPiU쿉v]f^>BU0u0u0u0uЧRPXuUW:>_]s*r  qϾ`$<- r!Pv@Xupw>!x y@<@Pv osXXtzy>U{ |y0~* b~ޡwF1!x +  PRЧ+> P@ Q  XFrrPr^rT:rOt :DvL*Do# umfm0W
u
rl
u2 VWrd _^ QP&:Ev&MG&*Ei;Roo0W`,rFыnr;v@uЂBu< r
tsr&t$u
Zf\r rR4zXt2g uu@uu u2xS ذq*sTVcD
>Xû` eDƋBa`t>;P	 C@@_蠤$<Q+r++Ysat!$!"vPQȻ0WJr#0WMwZЈt #q*@\2:Tt
 YXÀuOuu+ P <s&? ? a3 >W}u  @V 
 VVV f<u^<
uu͍0M1E<Q9<t5$Sa^'[|u w|
T|QuQ t\_^FS}
u}	|".V@\Y"侑π}0Ra`AϿ`uD-a rQV 3۬6+^YD`QEcGfqMff?KffJf qQj
kOtf F PXfP~@=r0& w) MEwfPuaջf!u0WCu~aSVj|ttt
^[PfQ
 # < Q@ f	t
` v2Xa f`@ff`6f  Pp+V$P5&_f  @Hff#f+ִ f;wfg@G3g&Sg&c
uff+fpX撝fafpSRh=A$ ufP uffX  r2PyXZ[RUW uw
o_]rQt	r|PAy<XUt1s r.2]J' A   C!r.f%AfUCES2sff37{ 0[&fuf#f   0ssfVfSfRQ<t2f3Cr6+$f Pu g> tt r(2pڇ^ u׽Y O[f^7Wf@I-<  v fRa1t?t
r@,f%ZZ3		z
Av8~5	-t(@r!fut@uxJ
vJ$?t:R4g&? twLPcpQfRZ8t ,t
u$2ҐH@t @u t tU 
֑  t>"a fMa up3!b fYf[Y##
t0݂  t}PE0P#Xriff#&fRPϊprGaZ3tt@+W$
Ê*0W,W$ty ++*W7Z#hQ!} fF _YtS*V+VV  o*V$+VV20PF1VB,VV@01F1{V$+VV  6	]6 A1Sph#fX0[Uش  [tSQWfV~W  ߰ _.W<5t^uf1rf^_Y[r}OQRV3@û Ћ mFKt
 # (AA8u-^ZYfQՀH P# 1ߎǿ> $uFu1u0tЎЋmD@t`_f^p4<U`@J"UJPKM?NNSQuPP$@@XuP@ؑP誽XUQRv$R}WPS8Q `9$Q
,RVWp!1.1VtfN0z cߎP0[Q <V0[V <W`U ?c!@T `a$f\>׾\$f]%6$	s >$upP%fr]>%f]K]a%JOf 00b%dOOۿOf%"cd.%>% u+P>R_uT%{A

_^Z
ahhpچY[QW;V_r_  ?Ы>W -Srr. uڻˀau	]̿3r
P`P:f,tbК	0TE']ÿﷁU pTj sO)O)8ہuvvZO) ڃv!ܿO)7ܧvX؃v<Bۥwwwz	u/z+ܜjt~ܒ!O)+5hr|F߫w޲ *O)p۞
Fwb!,O)rPwzfW0PsAqm< uf,Eߎf3ff=SCAF`f_U< 
 	<!? F ]:qC <w&'V3ɊȈCFp^>	   0?RVV<v^.Q
t BĹCQ:K)],5Uz)pfX *s.V Ou]4v4v{$$EsINmce4vLLs!tL/Ms%hp&i&¼k&t'O'Ջ,4)J(Qr2Pt"S"O*ǰRn 
r᜸薸覸["2ɵ"ųYp*w**1+8+?+Z*.ÁbKfUQ `YfVKKrKfXfugl]NVFYf ˃u&gfFff}qMuYч Jf]Ë: 3R)QSfVffLfTp`DfL!Kf^[YrXt	ApKPXføMJ?øN@ dJ@D`UfWpCKt@P RfZ2_f]-VPfWK@袽tQ uUP@XYfN@0DR覰YXt
 t$jtAa AR|ѼPtJ0XXRfVtf^V*V:=w#t Wr` $´sr	`t 0?`/@j[`,} ?c:Q W=2.u[ك!N[ F R Vv6^N  (r-jVIAlˢ h^҇IZYV3۬
Ê^፻ !Ae  ѓ%1~1fa@c.66fffʰ;w	rf;wS& S.PE" u PEf%~3L׮؎ؿّݝRK@{u$1ذ1K`,0K= <r <3 H Hf
ffʝ0B  f-   NѝufjPWj>/d3&G;r_a1Q ~ 
<1*   S  t	t[c )exfsC3 Pe)4e f       PSV -JJ/.龯.QJ.a..J܃耳 舳^Q1QPkfB 9A,U6@SEDBPf J = sf`_f8 P0(2{Y[$
(|	 HFp 
)N8tSF *f%  c@f t0 c "H c[0rCx 9QfaRV s Zñ
z$4NWff`4eA f@=4fafFD'2DqpFP ^DF s fAY
zf03y#fF$"wF(bF, 0p fp@RrBrQ fv,v0hfNW,-Q(UX($иP@N\F@ uf2N @BfFDlf31$9N xf`!u#`!@ `B#f#fS'N0fHfVPf#f@f+f;FLvFLf?FPf)FLB fPWvwfI|p&;@c'wf*j f
af9Np&XfU(G ,+fA2!03';Vt
fAPW+ĳ {  f%W"݉% 0 	 "ؖFʀ870)~9F%r&ܐ 713` wьGev HfQRWSӶt1u	PAQ> w
w[_ÿSAEQWQ> [w߀@?w ЍlzF>FwэX 
  Pu
 }@I@Ü8  Pݩ9P@+ 00ݡ8ʀM8%:556X6676QQQQ66A7f~Q/m5fP3SPo5  P] USPE?X[[0m#<crh5 .#5]足uESx %
߸y 55D%DSz L{  ~  [ߌr
!ZʬJr'$$
Ȱ5C`
ȷPM!Z\r0ZP)?X!Zp;r@#crc?ȋȻ_o5"RdFr,5 #cHe?ӾffL@Uf\ff赀`j jt	}ŀs@KSP	`XP rX[l< ɫ`0_$u`u
|n軫m!mh rWrxltu	 mP[Q<Xsu><vt@x_ VufS2˸_'n>Pz[Pz8{8888q88888888
9}SRWP<  @207d  .   ku`   
 [ kd | ŀ  = Ӏ G ƀ3 3|y rt&roMjrey r` [rVj rQ rL rG  =t r8 r3 .r)= r$ r I r
 rl0φZs_Z[k u0	P<t<
u5@ 
JXX!v0Zk umXU	u!k>!ZJt,kt-<v<u !k<r<
P
!ut 	CowV
P@/
@5P!k?
t	5`P| ĨӓCHP |SIMPLOyMO?TOROLAwk}s4~ЎH}r" 
 &Ys7@@Sⱦ׾	ɃVP|ѿVS}/Ʀ`s˻ʆ};1 >>﷍
>`SR&
 3-&Z[>~`迂` t
t+؋Rӵ`y~`p`¦g`ߦ^`צ߷U؎A&3&M<St<Mt6):A`{6;
6^VR{O
_9*a_>`U􁲩```1R Am`ǵѶd2Y`" ӵ '`Z@`л`k	``m`ֽ3+Ր
>&~X^fVfWfPfR@`fZP%[WR
uf;tuf`>u s]1flt-诰r(> <uw o`KfaUQpكU F E] 
<t ~w Y]P/4@rfv u
ˀuр>2dAq! ^7~ڰDԫx" rgf?f5 ݵ Po {t P  5	` ߷*Fe{0Pݐb@Dq" _A ppNff3u
t	ڲPpِ-Pg]OfF ۢXTQc3Pgffڐ, ^ځ 5fPQxL9Y=у
 ^8Pf<t~  u#f)뿚/tfaRPQ`{ yXZ觅p'讅3x
N&A pu2ltgR't$<stǄuԄ<t<ta'LBF?PF\ XF;q13tĀuC2F <r10
tw"t`PPḄPфƄGv <t]<'wVu~Б$<s?<wؐV<'s*a߃f ^YNuE 8u| w&|u tf2% tB2%t tP2%i tEa2%^ t={Ϩb' t.1@g-Vu7]9"ry蜃 ɃG F 2vPX'{0/ P.mF PXCutwz
=iA4鼐4A@2f 1  
u$,3ۊ^Ð >tMNp@:B6$"**
BJ @t21%1231ZHE8  L L1ø@  i &g +  pa 
fN@pDD]ϰ2upCEAxxS\8&&GH&G&G J  J [ !pKpKpK栯桰EKL\&\MF0 ]A..D3 и( иB  2 vpCC@ȰQX_WPB`#3t u*`SO $uCS! & aX _f4@PVl4XVS4$CWYW    ]RBCS4QS5Tff j`<fQfYga[u[ <Ȏ3]Ou А`20fPS=Au@p;Áp u39 u+ f?wufP@updBXu
_?ffpV F%9l{A-F{N{Ss5{$@g!h!h7E{{!h i#D{@gj`j!h!h@g"G{4@lؚ({W{!m!m!m!mS){{(@g
(<PdWGGGGH?KHHHdPw&PWW<rrBǁ  .G_Sw> 
' t r
! Q[e Svu0^r!<u	rr&y!QPts" r2.G2& sr Q0[Ats  r|P}1w8 rx&& rr	!QôQSs+&' Ͽ@>' _s1P@T}YAtsQ
u>[1w W r%x$ r y r	ق ǰT}@~" $ @u!QQPm 3X~3}t s@ zt5dp` Rpt t
@uP{YÜP`
 2Xr`Q`PtXdYQP`Ϙp t	`1V1d$!<!t蟘蜘虘 `!u@tPGX
3ɍ6V.LP ].:Ls&3ۿc.D[.L\s`  ro2!O}2眿ǖ0ǆu K;C^ʣp3tt
u! 1/Ls3ұ 1uuѺ t>W. ' .W u}u@>Ю J@}uL{@  u3}puvbWű_tURQUPޢYZ6	u>^
 ._D @:+Bt#VL^ 
.L{ ]ՠnQ3_ |Ys. u&	 t	&Uu" ώ X |  Êö.f.|f@` .|߿ Xo\6ZPQW 3ۍV3_YXSRW*׿OзIu 2 荕 3_ZP~RWQsv Ytz 3Ouʋ/PԐqRQWSP ɜ$X Q֔kYԝl֦Ӱ@rBhsX J3P
	u葔X( V_ m W`VPy[_YZU2<UuX5-DYJBBspUgrDw!uP@Փ@؎ۭ"XS
u	 h ت *ê舳hp 6VW Dt!WQ:t
Tu8v
Y_ Y_XY_^ÇdB  XtjB-wu3pqt$t<u;73ws.wt;PmwpaPE?߀~tO PtGPBt9t5F  F_  F
  Pvu<IvrˌN.TV
pjvu
wvr.2^.lnLN2vv٭? uXuvV? ?	'O	O"O<$OIQV	uuuLvrx0<u.;Ttq&btP`ZQHFQ<e33[R߇ZuPu9
< t(	4E .00%3[p?
b	PH X'  'tOTVA p WO"/ ILcLOOuru> *u1]u`ZPu`<u
 @&   Ew@tH`AuP*(@u U  u@,& ]XbV߱  0`OͿ  r
b P<F uDs	 buS"u	 X}  tGT0u!u6FtE%P#uU ArPRtKxG%R(t& 0R] Z Duh@3 h*
Xuh*X&  U au/@ &0 Brs@r
DCrCr d P dXP  <$& 8tP3  2QX uS3^ `b`$ ێ~`*C5: 23563pP @P4@X@Yj@A t PS'[Xu	 c &A 
t}
ÊF )?@ N
F&? 
ĺࠋ2? $30Br#}&\
~tE ]8sɍQ pu蹍B@YÊE *F&d_ؠFIIGIÐBCtB
k&>  $> V+M\Ś0a fF aQ؊恋QpRÊ~
~q~`	q`4 >A  tU	Y
ulug艰S$SπkzStVnSh XFFB$t}#*LS Fqu BtGAq?V@  ²^!^"x^p<^!`i_q^a^
dlFpoypOIEMAG  IZ P  Afd   	

 [ biHDA-L  HDB3j'A-ESj"kCk@jUSB-FLlCDlHcmLS Intnl  PCI-0UnBnC  % _eOp_pipypypxp	upP 	/u<M o;Wvc!vgHW3vuUv	bW W` @ !Wy ?.WCD001EL TORITO SPECIFICATIONb|}$PnP!0^&X GX .X  ^}fPfffXtfUffSfPfQfRfVfW 騆tg]`rfw q?rdrf_f^fZfYfXf[f]ge333srVd4Ad^;sgu0
30&s M ptAt<V)r0dDg}
^PᎋVWd_^gEdTg}䋽
}gE Ptr00t}d8tPW<yt!H@Drx0fU@f]3
t Q Eu Ó' r.;Gt._Ppfg6$+' +kÃV.Qk  `3$ &?t+aÍ>}
t" 	
t>U .:Utpl-־V tVRn+Z|У@u-$<t"0򅤀}PUQu^^ QZ3䆊qo bks2t*kRڢ~@.uPێZ
tQ"uuq  
 ]\uIla
bP	sWuPaؚPPs4XPt)Q&xjVﰎpPOq
[u!uXÑ#1drP0fd(frd&砉񋠋+ dMd5p*Vpd`<d;]td|d]^UP~vЎFp^w,]rѩ ~vFUn ]~@˹
 X 3
' '؀˿ Fǀ˵F/\3.;v+GuBGF/ǰ{ % 	?πXN5ыQ
 ߀0ʵNY2%'0123456789ABCDEFSۻ]׆[K_^_^  A " * Gxx @x y 1 " *
>hxx 0/ S >! 	DK8y y `b é uT EE
U`
 rn  t
rÐpxf`#i2tW &  q&E3ҀtB&U
&]&E`) tPûQ_\uP@h&׉EpP!fa*578F'()+7P@ À v5u#1. `
x_t^t]t\7;utF5".3< v
<ar5<{s1$<"tPɎ_[XP"1.ôr@հѾvr9_2.u%k(G$!u!@t <zw,  taڳ	Tt
w
 ub2]u?wS 6 
J, E@	o0%2)PA
 _ p t߀rP r 	
2vPQ7s	} 	E/p: hp0UB C bbbcca
bg]Ҋ&X t$XQ3'X]!
a ua_#XQ SQ>$Xu5Môu% r!<3ɸ  3Y[ЃSRVш&-XXm,q]@!`t跜t#'>-XpntƝ< t}3^ZXyVꦑR@! p'uo $&8`r#- Z!-- .4r$/uщ'X$X&X2g~IR    $}` a b c ^b a } i  9f80 8c 7j 8phG8^`t:g <  <0: 8kq:`3. W Gp
2H_ϊ͐
`AaVWcS; dt[ 
 [_^PQRW3?`  Q^Gu t AGY- h0F<FG_Z PSQV.c 6`c.c^Y[X"U uPPXd|]<t r
t!d8D^uJRWurrsR2PT^uP@J M`|&
yt,ـHt&M1&G&˰`·AUULAAAa+Íu 2ȃt
\ȁ]q\$FKuWQ Uu	ۍY;Y__u`aS؀uu)/4  dPG#w  [t6 O|<upf2T|hB@3 hֳgǂDts@.U1qffggugs8Wtq"s
2l1"  |  D.D
2 ``/8g&&D aø0 м Ej Y&&E r {3Լ{oh  gqf?f{QPnooQwqpXY}`.\.T@oώǍ> X.LPz`a.D`aQPƌЁXX@6aV4_~/jhnhrhhVWJ@hNhw˝ E ø  u<s/+UUu< 0F<.Fu~ s\}pð: hFgpPGh-v? hKg`evS`h= v O haP$@<@pJfQfVfWfRf  $F}PG?2Ff Fg&)f[fZ?f_f^f 2p n l ÕꐖЖP #  LE>72Ҩtð
(@],`# $ztø
1а	02s s	2  |  m	p{"2o tN :1{ kpd]
H$ 
O$潡4 ";"%$",oiiii
j=jvjj$Sf3[ff$Rf
=f?X$+$ޡfCffߋvR%  ff+fPRWS22f`e )GrG i@u [@8s܊[_ZQWRfP
t)Ar w@ff  u @8ufXZ_fYq@4 ӵv ?
t?@ t@WQ3?r ?Y_ ^lollllllllllllmmVS30\.:lu.l CK2[^*  F.\l2SF KoS.!lF[wC>N[QFC?t-lsF2~ tﴇY Ȱ 7`	\=B_ø8A	d͜d0Wuo`5Ͽ9u `+u$ $SWQ a>tуPY_[ ŃPadnmmmnׅ@Qr *Ƨm;ݒuP@c߾	uX$# G
 dvd>qt$e3'rUXttXt("4DEZQRaxPTR4fPS LogoTrapInt10h `eff.nnUoO%RestoreO.nnfCEnterTextMode `:zuhzXg Chzuh.	gaúB  ߹ u$Ü.nnpoooS  A  G ?" y 0pP2d8y a*R é uD ËEoذE t
!rP t
r2f`t+W   d_ A&U&]P&E fapp߫pp>a   "@ *  G y`cPTBFo
Mn(#g7V 3W7$  CPP &@P
"-d t0M"6VD!_ `~[gu1$LsU IVV
$sP&E
TE@@@F˪@$4D>]>&X  X 5Y a a d / d!!P9U	 Y
 d d@!A!B!C  [P 1\Q dR"\S dT  Y\U ]\?V a\W%@ WdY!Z![!\!]!^!_  2q` =qa nqb qc qd#e#f Gli}]goIVpvf`PС tOZMu (w$
lw/H,xQ0Vwô%LwQ2+BwXw8wfa0BМ2?wt* 32@5u0"w$t}p1w$<Q7ȋPf`A %L0v$v %`:+vp3v$vWfVSQf汲VF! (s^(2۹  < F  +^D!8uo3f^ cW@<VQCuKe<! K@>O!>w=$I^:u:\!u< 蚷r@ {fL_SpetӆV.OذÀu@u[PRZ@Sط$0<:rd u M~KH @c=LЬMQM& V:@gfFpXRyZÜSt	tv
Rvt[ÌȎ؎ ЍҋhQuUQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSfUfPMXPR0ZXZcRP4  XZf1f]affŝf]rPm~LnR%e, .j8jc%@ jD3fqeff
fa  	 %  }n  o G$ $  GN N  GP P  Gh ~puGt tRr   G   
G   Gy@upq.o  vv  w y @  f`0D4ffty  Qf34Y ,zĶz Qz4x4 41yz{w"}N|k4 402qt  Juۅ Vx 拔 tcPt{t>@KXSAx$PXr$iu!P$
BB iJJ4HX^ϼfSfR_.uQmf3gf&`f=SCAFtVG t"ffff Wuf(tfPff=Xf_pm쯊>@S?Ҕ>?QR> ρ @@>ϳhC t   rr_@>Z[PSpjh[{X@pĝqk@SPPِ 3Ҵ./@32ƀnuo㶠nXpçùU@%JMOjN꣦%f    dyâ%0Mrf%P%>% uz м  .>%hdG.BCB}؋r 0t4t p0p B2f$uOf=osG t;4%
%t#f$ff!f%r߸ +r>p ˴S Wš^ۋ^&t$uG&uFtt] ( z½PoQd @9f1wYIQ30t6f}'u#~Prr
`r`Pү䠄t"ߡ
Ѡ  u!`!t &k X`g |i &  L
)d0ˋǝa/K<|rXs,ߖww}}ma	 o"  
  
R3҄H @~0Z$PMMp'F  /Ooُگ /Oo /Oo /Oo/OoV</Nhgԃ  Cpos#@n
3f##_evxOgqӠD
 uj@ t%v v t ArMv .=sN-f-&A F'N- aύ6_U @B @
0r 	
F (|r
9	u뿋^'Òt}E%d	Q*@r`/Trr[v
u< r<0s<"N@` \1u'`$nv`f<0rw
sus>uW. I.
I.
MS.}u tj@&u |t
p! ^!N%V#!~?F @2r20F%ss 6< s
	OtE""L5$Ot"#Ot%2( 2)A *$.EF2d$!r]wsms1I9 <$u2t1*<#1"< u1<v<%ސ120@ ÆUu
F!UF% !@F~&=r&}v8fRF'P^S^!S&EF'?U&]#"J[";[fZos&^^6W9ܠ8]6=rfm	DEG~(LuTMs~zfPf-}3fXr1>WW.E.GTώǿ X ./40.3V#:Ttt<~'t9r0CEE&W!
DDpJ%pJ5蛖렎~076W Fu0K&Mf.W]f&}yCA6'6Q譒  虒r}1rxrl 踒rdtZ+r@ u~ (um-VƎދo^YBVtVWfWfm`ruLr Yr)8r$cr监rT*rj"Z_pR
 @r@w
u ԋW_Bt:ـ?f.EffffcUcfs8  MƿF F
_tSuNff3fVٿWf.W e*f8f'w*f'F'*2t*܊f
VvfVv9dFsQU n E]YRPXtUW:>76_]sUr  BpPR^2BŰsǰsZXPWюߋ `
o!rȏBt A^ sG m1{   #`x 蹏}_tF`xf Z^Nz2`x t r{| rv= %>W= !W1S>W KA, s,5<s-WO8L`G
t" >WߊG<1#w<1$V0oWp[wPoX E{ k y /rzǎruSVri8`NDrWu
 sp%ع }r.Ǵt%ttt t	tSF% s߀ufrŎ	 2PvoR_F sH<t<)t<(u;>A u/WU>Z 迻]_rb|`@-`^?aoptPSR 2Z`PRFtN+P}XȁfZ	F
+9#VWYZF
t
p
}PXfS~ t=~^f~^^~l^~FF
fFFF f[fQ
tW 8vNc؈^~nNfnNfˈNnfNn~*Ċ^
^ffYpSQafPv j 8rC sfZRfXQRFflFaVvffXr+ʯtpc dώ3m tf@f   pcf+mYÀLM2u$tΎqL2Wt
.΍<Y^r fF! PXv t<"u<"tPV3޾x 4|0Q&?s s& 0 &G0G
݀  P&O &OPaRpcf&GcPcPA9Wtcc Aǭ@W#fpPmX@ vQVWH:Ww 7tN7uu .I67 u/ ?@	
  t,6ЄoqOGA&&d&D&t&DL_^YXV!
MJH}"uR΀W
 r1^1 uWuW# 8Ԏ؎Ў6H[PWV.}
u.:͍{tLu%`΍t>JrSh.[t W.[u ^Bύt	3Ѝt_M_0EfU"bYb	Mwм 
.V PXF
Xf]h@ ϡ60. nB@8 7\$V"=VWC-6эcӍ.ktL1!_s("|r!0.^SVqD.d.$д^["jRrcR) P()(+DuWt
WtWtWsё
ӑЍu	H.߉<Jh 4P+ÁUu	UV6RcG r0fL\ϴм0Zqf{sfPp3|wfwDu
[uQfvVWURuP7&BrðXWRuW>э0.?>Ӎ0  u ፜Bray30Bݾ&G $÷$PC &I(US *B>F &g0 G1&O2$ 2&G~AX]+[a>`
 Ս(ȟٍfPsG @$WPE޲ raY΍Q@3~qRE<sfQq0BMtB@Яr/CDD(E F1qF[Üԡ_QWV.>΍uGG<tFbH=eH.1I*_>U*!+U!+%!+5 +)suKَvL^_YSR(t5۰=Sb& iO_pO&_@ @PY2[fUfweCSf]$W _T*u	  
yjt9)Ӏu29t& 5& 19)u&19u#;<
!=19u! `8;|=a<_ @>HABBB:RtYE:vMΠ@uG	@Fu<PFu3EuOEt29uE tGI1J!=0> QFEF:u@8*6R:EF<uqB $E@0=} ?_@tTtt߀EtH; L7w!L LF )t%> t:& tSuEj(uT3TEQ>FEEߖ tP qB脽E>I <Yu	PX<uP3 tXsXJtHB 9PIy(EE uEtQE`F0H)sX;Bq =ݼE3 :x3;r.Dv+W:Xu4nH32H*au!.7ð-H>!H	3I2d?<Gr<S0\ 7,Gu{.H]uHJgg uI
<.rPML@2;pK BU2K#nBv4ފrfI<.t<+u
0 uθN<-s" uJ,0r& 
@6 ;6 EFÜ   fVU@ ބuP t u3N@fQvV u^`vu  {zN\`z ShK̷PztE~G8uQ ݫ Luz] t!'}
Ru  
]]f^׍ 1V ut;66 {趺3,=

"=

PUu5w<t<u F`qS $s
Êp<
~[<uaw\wWQu& ĺ` uAI`'?aᎿYvFF';`vt{v2xvPX  dtPp䄻qD3 qp	AU
t	u%  0yg ,PjOtT м  P!;s\&D
V &DtH d 
B jr!0rsuF. u﷠a$rO迳sJMꪟK rr

r_cyZ PFFtpNF"@B]BPF(	UroBB2ۀ~ 6`{@J3ҸK3б ;wu;sbFVFF" F)t`
r4F$
Ft+ F @0mVJV "`aWPWR uKZX_PRAȠtZX9P 2XPUv F t	!Ff ]XbX
WVɢ.GF< u^_PSQR׺sr@\ZY[PRǊϋي`(Pƺ Ȋt0QR>?ˆ{?ZYd0p/̰S؀u
A7ܰ	ѯ[PPb?Xˀb0бС0X( a>?	ЂaςԁPҁװPVWt_wZwU
uQrEt>P r2
tC rRݍ r    !  `'_^A2
u0.C;r>bϱˬq̀@$Ort9rP#/r*r0
 rߪ朻? CcޢP  
 P P  t3\\Be̊\Պ$cr:W1Ӂת T󯳠;_1 @O͝RG38t`3w JB<t$AJB䄑B_32_    _SM_ P_DMI_ J  #f`UtE# u ߴ'WJ5J &AJߴ#J+JJfaRМJtJ$t}I$<	ȋºZf` u1A)ߴI$III #IγI$Ifa%	*P'@[TO OY^ee$	!L @ .q 1 ТP  a & 0ͣ  ' & 7pH@ Ȥ' p   &0;0P	 YK L   
 #
 0t w" 2 0 	=Hewlett-Packard 68BDD Ver. F.14 06/23/200m5PJF"
 _$:%  ?%|% ! _#0&8051Q sion XX.XX  
 /
 `,_)-%'# E" @  A   U10 Intel(R)-4'PE  7 Q3rnal L1 Cache6 7	828	
   PC CARD-Slot 0   www.compaq>  
	 t G"en|US|iso8859-1  
 `, A2Q1m@: 0"q  
2C>DIMM #133(
C1D2EF B77 	p7SST49F008A  @
 ? @Kp ~0r ~p
0R1Op7r  P1~!
@8 2P"?rimaryO)//s(~Tr MultiBaVWd( 7 c0< ^kk^ G"r !KENDPR1!	

 c_e	N;dddh"?c`m%No bat:@8y7("_ij\/'LQ
ffWgfǃp #Egs^p sp ܺsp vT2sp gfp ogƃq gwu	f@w1  f@f@f_gfs gffgf_sa
fQz;gg&fGfXf7 f;wf+f@1~+f7gxf3ggfwff{fgf&faTxt@z3:@w1~|0x{ff0zgf3a{@CrΠ|z@{  gf3fSۓͣp wff#"ffyZ?'wf3f3 n,;wfPf#Q}Ďܼbf[gfѾ!2ffPQғWdf'1rX1AP
z{Pf㉋كsÀ +SfVQg46fFCYQ̰Y0sf^\ g& GCqffT ܏[`GGUf <u迂 ~<Ц u<Ц l<Цc<Ц%Z<	Ц?Q<
ЦYH<~Ц?<Ц6<
Ц-P= uX<Ц<~Ц/<pЦ|]WfPCI 2;u_fQf fSt$fѻRrP~ptN)" f[_^fZfYְffC1r߿ 腐u쀳
N`$u p s r^2pP.RZF[XܻмؾZ#ꄽػfR贾PfXZWffuٻ@Zξ[ٻē@`ZUF:f"n@;fPfwz s"2s t s t  QVW&= & s &EɎfXc L _^YPwpc ;t
X2 *W 
_ з#tԿ芶X N sRQуuf^fPffff8s2f^YZP3@0Ba{{璘ݯA*qAAJxs@P FF
]X鈿 `j j v
@ )Mf.N. JtI F ~rp3؊^)tuw t&Du.⭋^^t6a.@t&ڃã.^2Ȏ36t6^2. @ PSF@g0'.:t	tX._[PSp \ÁUUPغ     ?f  ܠE2aur-s(@tH r詿r
 @RVvF\r:Gs5&DC H PrfڋyQ_@AFÉF(t S^$:u [r
F&F$%&=vHH&
D&d̠u r}cwu
 !πϠt&DB êĪ` TVc@ HUrap蟪1s!
 -su fqt
 E PF^&G )
V N8tr>u r߀G o!F) _r\ A{r=H r8rܽWsTs#@Rr
!@÷M
a|`km@PF("r#謂Qlr@rk2<t or~F( &d&KV& %f)&t N.QSWf^u/ r)v t!ufPs fXt)_[S<t;3f}^t	f^u
utǳPf[`
 3p.nPԊ܁fXf<P   树 X& @F$$<r$:u s
jútߌ 
B @738  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&L E _6F (P<$<'E<&f$`
ĢF f%$o`BG ˢB<(0ø fF" PXۋN8NwN o2N---!`GsH-ßGHmIn-`
 r
sHаmr77u&-贀-_"&&%'Á3bR&u 05/t36rCE VQB A9O9 BY^а 4s
3
3u3`Y,QS%uètàt  !'&V&T tu^
*&u^ô  T>  K@QPXuN%&:Lr * r$C`J \@uа<upZt+Q.@ -n; E 77p+$<@t-gA9Qj9" !$!$wQj`BoU0+0Vùg
+K<Pô`SS}[PS3`}[
Ц|P|XO}Q1 W_p22fǳûw3иsɄ3ɺ~r!0iyd3t 1|302}\>fPAMS! VW  Ўp  u
?  .  e`y˻ʆ ro ɍvm F0& O00&O15FUWn辤_]v
 @_^ڐ$yy\ۊÑSf!W걊fw h؃0n@ MB RW Y!!" D x蒁&FGvuG )Wp cu#' P 4&(
;!f3ɀ tfuT!& 3_ZâGF< uV u2D~ sN~ t
SPK(["s\0ð =NuB t=/u03 ffXhgK aL 
q׻Q-w5":r/߰-o`u4 $
Ǌ@hwХ r	؊Y}W@Sph f`if8h[`` ߹ f 誐Hի pl f
( Q rMf[5f 0[f%";tfff  fX2fv}_0hRfxpfPٺaYZP
XfZ`1+ê `d '@Z&
f]<~!¹Q@Ȳefw%
 5|dppB_,sS#Ѿ஻9ў%Y3`wfft`i" QBY ffhfaQfRWf ff fRf3ff`itf fZfOu_fZYÿWry!tpЁQgz ec˂FrQaL G B = 8 3 . ) $    `怚 !0_Q&GPQw   @ Tw+tϋ#3r 4 PQ苸Yq7tq$: >?RP`$XZP <
XByŋ1p|.
X `Ev.FvafV`f  
u 	r mr"stq`	 maf^~`0*߃2p$BԉNT@׎Ǎ~W0pF$o
`&U{_f	  maø SR,غ*3% Z[W  t2_p 0ot
2Ґw PQRV X6\f0Vߺp_T@g@^Zٸ hݴ2r?$<0 y}W PyaP3 ú0PRUffZVW㋿Ԑ#:_^` @aῷ$"AtPS t 0[X<t#<tQЛf - PK<u    %~$ _aUWV    $
t6s.ļA;u uj /SFKՃtA8  #и ;R^_]rSC# ꠌp 3xuPu!   SVQRV1Q 40	t S.X0Rp5b # uzX1v{qH$tu1vG($)$*q a}auЛEuPPu&uZùPPE EPP runtime BIOS - Version 1.1  
 óýPwĜ5^jzņŒŕŘŀwU .\]:.I&.;;L&c;&R._PBZ9QR&;Pj<rt2[:$ԁ !Ȁ
  ->>"Q@ .<:$ DmC[Ñ<%<u: xuCBFF SGeHF.GSHV<qFKEGG	L&n ^HHHߩ LJW<"FKIaQ"Ol _Z u
TJT:`UVU99SR<T$<<rF
 j ?G0	r
t  =).> @sn.\]@
d]]dOR3uAB$A@3jF NR9 Z@bV
u$<wR.T9}'ðbqË tt	 Êf
t jh; Ci3PihPR# $ d@t
&FX腍tQ{uG&pàBbt't!&C 0tt߀t ۻ /Z>N w!u r
?u am^< u'' t	3ru霐@x (&ysuiz0`ˠv )뱳2x _{<xB~{DtkІ}pW~E@Kt?t
T} <`@s /Vߴi ttD?R 5H I+.u買$ d@t@t@<t~@Xt8't
' [lucs d8tKTu<tB<t>u3$
Đ3q u)  f鰺   T-
 -3$ʰP3Ҏ¿x ȫX8Ɋ  M  G GA " * y 0> *
{/8y Ay bc q'U Ë]uEU `ʋUc t
Х̚r聛 t
rÐPJRQW %  d_̺ &UYU &E! ߀t&]ZФФ P߰HpA "Ĩ@
 
 ް  XPJXSP t+. s#. sXP&   &X[fW)t+ 1> =$&}F}10aR
rrpU`a 0പ[n` fff @5@ ɩ`1( eF   f&| ^	u<Vf
eoB W upDkper\^ uS ]B^[u"&^~uMttjƖ`V	~L
B8+.߀
u& `u*f_fPfSfQfV 3&=Ut\Zwm` f  gf&Ng&AO`E  &ufރf&&  p\f^fYf[fUh &]S^ ][cPupD0DV& f!AL
^ufWދ@V& fۍt@ 2Pʃك^~  p&t_ 'f=_'+!1of;̉M ڧEQ
 W1`f.pZg&G_laE3מڦruf&T
f.ѱf_ɓtf`]@StQGY f 	f,|P  !fwf ,wo0䦃;al!pU
EG P"rP.)fa'nOGw|BP_@`W`0~؎`w`[fp<t+fQ [Yf%
fuf` l[` ߐt_m Y lܗ"ff9g
7!BR
!
ձP'D؀Ār](uD >puf.!ۀVQRH$($
 pT^3srylY^݀܇`~8"vv ff(CPsV׃Wa d@qL
ft^$ؾrW߸5,t f@ 6^́߃TrD%f fWfQ0ES
`̐"l0# G՟^Wq:ރp@Ӄ(P5.	0*p33
`פؾ:%8q 3p8 <)Ah5⍾`B_W3nٰHͤCEG_!Ú@hQVh `35S`r!)P~= Y{(<
6a3=f[`_z" AuAaֵ'ZTZ׷Z+URf}Q v ufuչfQ2=fA<t1 Q !!`n r.V sfYZ]0Tf; ]fRff;fZ^ ]^0dWf!rfMrf+ʰ^Ze菤r
fg b΢er#f|s
0b
<Igf`gjGkxl}gjrHkr_peBgf'gPgXgP?r PP_c}fSy[/gRejw=xIyϜvIjE*ko?m*rsQ0dFfP0qXE~ t ft/+f Å#fSff3ۿ< tfFQ2ۑgZfEYW}pƅUaY1t?Ԇ7P
3tӆ1&1Sð-"@߱ۃĽaWVa fSP~WB QKY_W
t^]lIst6]V! <5u G	F^1B^=  	ds1.
<5p{@ 
uyI^crK͊Xf[2P耿dX^mYqWfVft
P EQr&  PgSQ b ͳ r Pa-NlNXso WD ߍt&rD+P۞a
u ${p̞ð)Pp]tSgYPu
1F$
Ǌ1HX ҵO %$$ u5 S`>໳ <) 2Q3BYQ
t
t
p{ ü3bð& e)qF!tt	*tEP@Q9S&"
ǆ#[10 <t<!t
<0_<*QeR ``ZQRsu	P Z)2 ð  sVP֎ލvS<û	 [rq]X2 ^ë,p&Ѣp!p2P u t輾r
DP  e0@Ð3EtV|
u|	~r  $<<<q]^p"śԛ% л tV؋Px軈jZPau𞆽XðQVWPV`X_^0°Јp2P BۊؠBdS  p][t۰NRPR/Xc\tO[߰^0ω200dʁC!x@
P'ւfи1Ɩ۰WCOMPAQf` tEu '
$

&q
ô 
 

faVRМ
t0
tی
<ȋºZ^f`)_%0epE
[
;
  5K
$+
fa(C)Copyright Compaquterrporation 1982-2000-All s reserved.p{0]/w*VR@ ރ| t.Z^!VP `d.1BBBX$JJ2JBSQP0ܰ t
tJ Xua0ϊY[@V tA&q JZ  C@u* uP= ]Xruŀ̀2	w F (8S^<

2ۆ.
$v2p <w0`߀  ` 0    UQ
! 0078  0±$#PRS%@&+@&;w[ZX%`ݜuaa@uXXZXp! / PX Ü= srs+
3,,PS{ _ ߸^ ZY[XwtΖ.Ԗ㾐0! /0蛙`  . u.j.b;a/PQN 3۸ K @Ze'  A G#y 8P8 y " ËEu$rȁ`Wǿ  pd_]a?@ACeff
f18 p9@ @  G"`:FD-18 F"G H    *P9	G%N18	p9``" 8d d L"zF18  #Ga a LF Fp p  Gr r"Ls sL
OrEcN PI"{  M
 "~p9 +O6bS  #	TK"
tXtX Fci0,}`d$!<!uy
ء\`& t"&& x<u&  V<tr^@}K^D]8t( 27]']233.f>"."   a0b2ۊ࠿( ҊȰe) ǊȊ&) "f* ߊ*g>+bCfgPhf>,3gߎPh.- gi) rAji..jijPg?Rx=;DK   F  0Q Q"FPkXng/z(J(S$4@RV`u
Pt$ ˱^P.f` u'PPt $۷ufaR/`P
Xu!P<X{u @P}t0a`
  P!@pak  SQ q $N袑<t.1u
<v<s<3v  3PN舑/藑XçV"SPoЉX[Ӏut!^QuA[Y<u,fISGu%f» f f f ".>2 .2Ê$uGuﴀ@\ S3ێۻr?43' u f>$SMMu>X P dPu
j0Xgr 4S Yz # $t$?a-h@ &1r 3{J.|Jg3a/0 @ޟ u-sL`I<u	. u< ѩa|\ `ttuu |$
4q/~@ uЙ7<p` ذUNN]N-O!mOاPSRvС_t$uZ~5Ryt0M4p'2۴
|m-`uss5#v{QR'u6 aԀa$8uP& [mhXwZp7P=04'Q <ЯYu u
3Xuuu@ukufq|#Шu@F_u5qK|gSTUUOwCAA*PUWVRQSP36x @ fFf?sEYc_ Vu`v
<t<t$< uV"<w<vr,2b? [&\@ N [[YZ^_]RTu9<u` taaSTr+ `ƝtNð
2
t
@8ubgÀ>A`cA	tvg
u'3F &L Hgsƿu	VuQ2^ ˋ
kg~bي~O\كu B ftGKو&A J
WSy2aeaU'u$<s'ذ
f2f 	.c u-Q߷M
~Őq`gt
тed ftP u pN> uTG t$p<pup]eT'FO 8tWG."T u33 	t<uSjT[u8st,H@>|0\> pd XϷ׹ PۂB st2 	=3u
Kue&> D%T[+4~u׷ ךPַp/H_SYSID_  1{Y _UU! fl f@f="uf3p fl PS}"
ǆ脉2KM|u.s

K0D2;	6EQaRdtSR@ ڊZ[`Z[TNu uH
鈊
∋؊t, s0Pir!W
Z0uWns=s2	fe|ذf	eysv
B
f`p[jMS V}xQf
KgtQ?ۊ Rt%dx~pd^pu=u8z	
ً@#2| $uP$SUR!u<Tu7߃Gt szQ)#5 $.tʠ`3Z]Gp5XU!+sQ =] }K:%+Kx,Q,Q3ɐ-YysM -M>r}Q-4Ys.`e
$-ҿ 3Z[ tx p=p75,u6ݸH ٸG 5u6:L @;K 5V4 :N Ӂ=M p>s6)
7辅
@2'贅S C8BBaaat@0 GUĀfFɷ͋N
~E F Nu3 I'JȷInJJ ]
 HRQP~XÊܹ IFFYNZ3PAP%NQȴY`ЊƷQp aÇ鋿ً t"ԃ0Ҿ & GӡU.&a'@'WQR0 ZCV
 p} }Z  X@Oa XYZð
Q Ðy|S r = ufh   XX؋7[	R6 ^    Q@P^
pS  	d`sae `
gUЋ؎c]Ea^VC30
AF a_`P )Y`jsh[hi蠹PN\$Y9SR^Z[` $<u 3 0ؾ   fapr3r
sS !cc} w`wVQl3jAY^` 
aËpR0fPtf
 f3fRAыf;v+RpTYX0GY@_ÜPUfWf@XиMfWf<]C<f_ff_]XÀՐ`*UF.:f{MGuM.V.f] (<sW ._.  2PpXs2Q;.u..&+.	 x; @ t^T.&u @ u42..
tw5Ő*
t*İ&u XYP3WQP0 A3.G
XY_s :3 *.:bWȎ:%:_| ?Ooϟߤ~~~~l|8 8|r78|8a|çP<< p  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>P~~<Ыff f { >c8ll8x~~® @ 0``0 $ff$  0xx00 0 lllllPl 0|x0f 8l8vv ``0```0  @|<<f!0p䵑{ 0  || 0p0` x8`̣<l 8w` Ppx|	p`aRp Q|x0 ff|fcf@೐lЫl bhxhb3`2f3>  ``x pflxlf bf  ΐ8ll8`xƁxpcʀ3x0 `̀@`x ƌ2x``x  x1xw0wx|``-1p:A8l`ˑvQ`lvf0 Qx  `QRځ  a AG  ͐bvfҷ 0|004A!0ᶀԀP0d 00001qP v! uHf SvN .j2[]`'
fPQR|rx>@  t&? ZYfXî||T{|W|eMAY9Y.YnSS  w(B03P2X`3Ґp Āu NP<tD}ݴ tQ_YRB}r8r}r
2:6 v޿}Zp0ga[Qf3PCI01 ISAD BD03COMPAQ 06/23?/05   
  p     ˸ @؎&м  ; r' W@ P& u_SV  GG0G hv  8 Gu 6u t3  hc) 
h+rt & ^[SO
&hyre
h[U샿VW ƿF F   `i@3 FD2ED2E
2E2E 2 @D(2E($
f&EvPZXuf!tE/e.a	 ƅ @.<t	db>t <tjjjj3P S.wj5Jp$<t.<@t$t = ;t= D hGcv ߱  7cFF~ t#^FLr
F Fa(U(~ t:]''kf
 hr*F)'2(~ t
)F_^{Qd!
hRs .&4/udu    hr$?wط2hJlRhGVC4nChmD
 -rf   f  f   gf&Q6..  1  Y`WVe1E0&E.&WV .^_U'Una<Qc< 	`@.e1E0eE'E.U s Cm2a h
$e Du
g$Q
a3QCr  utw
t1w
tAPSQW33۹ G&./JNK__Y[X MMMc1@~M@  OMpM dB FO YMMxsQURMMd* &  <!TXM?C  3Y[~MQVWht5:u% p uK1__)  | = <ta;P09A9_^Y!JRW`  Ê e
Crr3ɺ Qe܋
AB rN _ZMSqe Y
ujizjU zj%1 DE<@1p;<<݀1p<3u """ka#t
#m[VfPfSfQ f3f3PXfffDDG(	Dh fYf[fX^u] 0gO GoxQR@<3ۊED 	 C!~sG4Bi3u fDf3ۋfË\y
S{  	T U S V ;	O	c	w		`h	Ph	  h;	 hO	 hc	 hw	 h	 av.L.< t)F.6Q3.PF.h+[+V.`.^̋] dF. P!.h+Xhr QR  16W  0"XYZ#[  
\a_nbA]fgb'^b` Џhijk qp10GpppQWĀ> t		 u		.	_c   O idJһ -ww~C.=e
/e
U@m_noG`L3۸ E =_F߸^FiQRrPS8[Xf%hqQDЍҋh
            ?_ 	?
_
 ?_ ?_  !"$?%_&'( )*+-?._/01 2346?7_89: ;<=??@_ABC DEFH?I_JKL MNOQ?R_STU VWXZ?[_\]^ _`ac?d_efg hijl?m_nop qrsu?v_wxy z{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_ ߱?_ ߺ?_ ?_ɟ ?_ҟ ?_۟ ?_ ?_ ?_ ?_  ?_	 
?_ ?_  ?!_"#$ %&')?*_+,- ./02?3_456 789;?<_=>? @ABD?E_FGH IJKM?N_OPQ RSTV?W_XYZ [\]_?`_abc defh?i_jkl mnoq?r_stu vwxz?{_|}~ ߀?_ ߉?_ ߒ?_ ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ş ?_Ο ?_ן ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_  !"#%?&_'() *+,.?/_012 3457?8_9:; <=>@?A_BCD EFGI?J_KLM NOPR?S_TUV WXY[?\_]^_ `abd?e_fgh ijkm?n_opq rstv?w_xyz {|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ?_ʟ ?_ӟ ?_ܟ ?_ ?_ ?_-*p! -   i    Q4 %	 D0%&T8 06W (0800U8808@0U8H08P08X8
h 59i  2o =i/!D##&/&O'b  )&  y*  ,  .  0  2 PSQRй Ys hPv ZZY[Xg&ǅF@ۀ988 Ã tfPfS
u	0000<0rXf[f}X:g&8u-g&
@gf&fB!??BfP+g&>B9g&@T=SWVfW=&2>X>*>f BSCtfGg&D= $"F<vwD"FCG D| u:tHg菂ACDB'B_^c=QRfUۼ ?} 5tR>0tKBCt!?E$fu
PpNANtN0OqOt	dI"  }f]ZYp=PSRi 9uAC.XrAC&PCTG tuVb0< `M'f5 ?*bX.bX2Z`8P A; u
@:R[3 t
\=SQV3ҠOCICHC  :OCtzffKfIC?As8_Y8ta9fF*0I8$ЊBb*PX1JBr=u2^Yf[PR 
 ZSR;2<9ޢ<9zhS2h7rZSixi8jħ

l:A.>oou	f 5faXEf`?frqs=psq|r^fWDqaXPFfGuE fqD$
BDutv f|uqr_^Ye=fQf5pf7pfbutf  t
gfdD0q`~ |rfgE{{A|} R=P{VB QCffq FFt
hZS7gvu ?>t!?6fӢB qBf0KNf^fQ8SV  ^lQ  A;\LA;t% BA1 0*B7>	uHCHCY1MV
:s  XBTq$t=f˻,|"q@0f%|@Uɗ0d=QRV&<0	<0&L"L"""01wxvBfDf% ffD?7@^Z =^gs0f X43ݠ|2KÉqd,\"\l"l"111&12wş"K(X:Pf 5пsf
p aXfff6{_`E8$1h &7Xkini8jZS0hkZS`8S [<O&A: oZhhR&0<[Z8AJAaApFfƲ:QfRVEu/:PN 	 o 6`58`9`ʣ:Uo0f3 ssdTpv!?!{@F0FfC/;P;˿_i'z#G cj#/v;&7Ơ_ cъNuթ5e{ay脆vؠ@Nu TѓBC$U^fpSa=}001?11SAAP0G^lD	%ÉD	f@ƧoAfpC<v PfUPf{Pfff!	$f41f<1 f	<1f@1fff]Xo t P9/1f!1r _@8p=R@qӃf;3Z1C X;>0 t! X `<*
 X0<CL`Lf;0tf0f`0 8z";$KicjXf uogf ?EM{> fù fgf;t?)gf+C k@̻hix`d/ 1_y *Ra=K9KPV`^0`; ^=X0;0u0;R	bf. X50. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ?_:*86T M54	# !
  5# #U4444!	 p 4$44q!p  "!"!3  .>$ %

O'o()BB)+,-./1r12  S@ hB&Bc;!Iru
w>Bj @O7>r6> S!7tBBB>BBu 9BlpWCl!7r8B_J@990*ZBBBB賔7a64 ?I`6l3ۊ؀`ZB&;CaA^B;<CZ3Ǳ@PB7VS@t	T0"B [^KVB"AFBFFFUuDhS¾0BBۭL	u5&SCuSCDA߀kJ:Bt_b0P[gS> @OCS>CC>OC]&?Cpt(
ߠB2B0B[O0PrlVt>BB r1AVw%VVrAϊ&B#ST40XSWB8<ƀ8k [HD4EtEhG3E9FB GAPGG<pYI`\A*[0AC?GrAC&PC]BCCNN0RV1J2e|))_rhC u 8B $12B迌g&F@v@p{HsPkBk8B$l[w> po$3@ p%u0q'huQuvtrueQu^w\quMq&#su:+8rPu)FvtFvtFv@5 ,= IZ^QXp8!u	g&|t|@sSAX[P@CAWC^U]»A`r' PNBAAABBעBV.ott0A/0W> @BSRaH<v
hHC,bICBʀ 7RBƻGmr )R艵@F1FRcAG]oFBBB:BwPA5
a t
d1`x `1JBrgo&htBrC
BrAr
 JtVŖxintco=LQ2ag>a6՚WuEP g$PSXPSZaH,T UB_{%AA K} "u3Q Bf3fÇ" Bfлf3Q^ C㫉PF E *   <Fu@C3t	Dt<Hut2KtKn $`u tP%X!=C !7:C uB<Ft<Tt<et<t<t<Rw*<Ir&@C
2QtK>? RKA?QuYVWЭ5tAQ ft(PǴ:>Cuҵ0 gXfCYG609N g2â>Ck>Bŷ=C0Bt&<C൯8r ҵ>@t!7w{0$_B@CB2 Bf?pt<C:<tSQ@Aذ oY[pu
?l!21ֽUqVWWW*XCopyright (c) 2001 Intel Corporationf_M  Q;]uhy@3 yMfޱ2f°v t;ff[0t*ܩpt tt@
   0L+&_%f_Mqްhj胒)u" sfsMfȸ &f%mܘSf?qMf }00YgfW`;ugFsM aqfgfNf!f벑FkMffgMM
ffg_r0p?gWfgG@SktleS[@ޡ!tY uIfgV8~N^fn f00! u&ȷ0f[QSfWfVUf&ff{3J_ffGf;qG<uAGf=_PR_u	f=CPU0;u>pڭ ځ0SuAf=NPSSufOffbk0v/8f!0{0	fF
f;sv}SfFrff3u "
f$@g&@@
	fM6FH.JG	"0)/f Qe1yQ
잡G
f`أ
!fItgJO_	S
!~j
_D̱f/E.!BQ.f_.^
utd&ubnmmf0(+؋{*@7f+ֱ.N20F	hÞ"":f^f_f;kMwe!cuA1J8t3gF`2g^ΐ%??pQ0z 	 @ceM" RR!upVte kMJh΂K FL u`jf3pft5f6_MRڡuRR  Z;`Cd  f&_MEuPh3<u	P!%RG$<`<0u_$ +HQ`<t<t'<t<<t$<t,[fMJB>= JO1) f=ISGuPf0sg]M  p;aRt f6MP>fe	0;@[j
Xf _t6sIC0:NB*"UUg IaAU <&}!&>pC#fw+O"<	u<+P2fN'`PeۊfGP@^.>gdɮ$1s&& _ `.@\veZujI_)`@ ld<(rl$m	p<I1)`rdeK,1puX1m }_eWe X@\|gf'dP0Fa/􆃢eef{0kiu`K HM9NHtA SDA2?Z h4`6UqZY,P,  ]}n
  Nn212)

A
 wed &d   K.@Je,U#D" `mۗ"ПȚ-Y0Є -> } %1 6ћ!  ꂓ§ 0	ua(1q0ě-4%(a0/4㔗 !j§o _,LQ}t
 2r[%Sp!1qU1Ĵ&D!ĵDaζqRӨhBS4өQ1Q$$?%EWCDmHì6C'!1/)!ĆU3PmF63'tq1d.ɡʁvA1ᔘ:#)9+a+D1ѯqAրY&
@J&RDHsёq`%#t@!" ,SXJp&Q$hB "8ì.D<C0qS
A㰞' (#
 4!	l䓶@
@J] P	}  P  8Jkؤ8Bo) `@ q(Өځ*
У%@a 	jXbQq3
$Pcs3D0b1&xiq	bÚ֖Y( [(R"Ѽ:`,Ѷp LU!'q'$D!D  qq&q&?_($q$"DD q	(*У(!4롹w.')*1'$4 1# /Y$1QՑa	aq;(jq($"\D!3aVq'O o!"&qqa$($"$q$$aa$ q("( qՁ!DqD|"'/ %!$ա$!ߥ,$U'6d,(!t@a+B1b8' <=%?2?r$$a?B\w=av  F HFPSQW  hihqi_Y[XPR P4K ZXðLp@  pG i zVN YfNgPKYttMQvRW УxR`УxSУyRУyS [yT [gP V8Y RZeS TZ)U\)VZ8W\8X]:Z _ NfWQf!P gf&D=F?Yf_c dD=f.cog&D=.boe.D
$.>Xo.%
.D
or.% .>botcbcԹd2eggVhhsdo]rL!md
hJr93ikk|= USBSu g&|=rti j`ooouoгm gwarFr  x8t(Omhio0{w{j`8ezcsgSh0i`kiqot P}hIr? It5QfP}cO.F1G e{or
vcCfݻ!RfЁ^qf@teH.\
؀g.\hK{`vr|~  }`q}h~"phuϛs$vjϒsw{}W3ek rCk g&D=Vx lWy /Dk3Hu㒦oSoZ$(Z}(yQD7$|!N=%dĝy
OD$$#$F`e.jϢS@RP2  ėh >ӍWu g&``T=
X,(fʴk&`_Gė:.6oo.oo . fPQ f.>mvmo f{+f!R^VuP6nno +.j?f.6jek[pfAl YfXIqrQo JfaúWߨSBϬ譕*QfPf!Rgfk
fXYrλl aS׸GJ/js⻡j`GODأc`l=3 ouWt*דWt6ׇWtBoD$
ƈD5ƹdAl r
rђҹK i%t-Ơft=fT= t:tt h[PIǑjae~ށ(uVỿrLeB@uW=@tW=tW=`	tW=`uWh34I6EfaPSVo8dtdw mepy_P}YϾo8DtD$ aew@ :p4^JSQdO	8t`g	G	Y[CN@"GmG	`G@ xab`oCaoUGF!F !O'`bAGw|(}}}{qqgxgxjkl5mqr1UWRQSPV rwtj `ur(ffWRfhIK !L fZf_ uƥ@QCaPSƵpug@VoZ@Xo[o_Ro/ ib\] Sokb_^ Tod[XF f scO t  ^X[YZ_]c Èqoto P BsB h fdabu
!ro!ddfdpodp>p6t
d@ddSܐQ
ro!soBfU}	f]q,>@u%ttt t	tfN tF Gru@>^:s
@136эWuoF ėD
 SfQVUt"×tWՍـ?fPfDpf'f 'T3(fffXs@AyuptLuY'f3f0	 f.moWfW).*&mo8fw*fF*2t*܊.&nofX^fY[̠OCDCo rԠf["p^f4"5ĀuDrp^vNox lhxlԠjSQVWU&BC tBC ݍ]_^PLS-120ZIP 250PHRVsq`a``44A?5|58Uoos
hGrgfb<tV< uWQsf]c `:kuFfGW(UEEFXX  U
ZYf`BCu goA3EC`oZoao[o BRqo79RW9F:'V} tE.ߍe_Z[M-Sys   DiskOnKey SSK9iBLFC uy @  f<x fP px _=uE"F΂r 2rp0s0w6|=1s 1s	p ?ec促 f@fPuLsu[t6p r)g&aWug&Eg&ޕ~В ؐ&' rLTٍf<VL\M]bMSMPUNF:~Oe}P῍ύe0:p: th;t@  u amu aRpK3ހ'Af?-f`2'-!q
q]fXuײU?K  LkBLGL_M^bMTM9F: 	 Ѝ㍱`W;PR)j3WP>ߊ#>;P>
_lnhdfm;n 4  hL 5~~Z A:u+`^s!$?
uo$D[p 6@	 - iBd8兀t 0	v`S 0	d8t|vh!mf!	d֎dЎ0	x0@Jxp@y@y@y cg 8e ))88: : >0	fWQf!ژqY ! D5 o6No}osRP	?otAzD
$&o
ĈD
𦱤s f!g&|5@er`r a`xvveM;y %߃@`yH\
Цo
܉\cse `°y> c#Pߒr`4װh!	&Qp"W3*#~sr	aD=1W?tPֲ9?Y0q|ô('蛿rkȲHWu6o=oo 6PrEQfP^!	.u|f.6q|\gffff.PfXYer"gZYK!9*_?UͳoXYˤϴ0Ѯ¹D/osF`g¹? s6Ytd hPsCg:u`(uI!r?uW=@tW=tW=`	tW=Mp&uWOHQfahQV0L	;t	E ?$pرy&` ;QhxO	8tg	G	s;-0 0  r    @  Q  6 00 3 
*Qq:u!0 3*@rr J3@ <B1  "@P s30d @U	  U u q3SP U? ? 	BCA FA1q?F$f Js3 H;AU q qU37!̆&3)5( 	q(31  q.Q*_}10  UQ3
 41p- s	
 3S< .P:U;) s2(U'#\&6#<4%-8s( C< ((G3@@uG0G  7B8;U&U&1N @O0p`QYr<f.;0t4Uuf.0y# Rf  P]f0 3rgfP=  v	  +v> f3f́ QXw   #!Z'!Z6+Ãw tQV@ ϪZbZZ [{ǐYǋ;`Xt./_ Q[./fRfW9@f_fZ?*r_U?ffQUT+QAcfffROMIfߺMAGE ;{ufWtg f3TPQ`a߹J 2ҀfGZYXuɃУG|0G  Cl Rh2h|t"tAo~o t	hV  WSQh|tuY[
Y[hW  s 霃mBku'f t!vw X @ RfG9 G}GfԓxfxfӸ fU3; $4@||W0{
UȎccAcUVP`Achx>t m PU  g8@ B; Ѱ fPfSfWU`cu	fP
sKcg йhGCg#Āu`&ztPfhfT@  gfӯp% _fa[QAqifVf3 m XUfĈ]gPg<ufG!@gt!>tfOuIu0f.BgO t% ^jfYAcr p  fW
fUUx_f*UǜـϜ❋p suf3ɊjtfYPQP@{Y 0t  XQfR dr
fl fZY@aOr uQT4Pbt,fU'b r'8tfG⻻j$@hZЬ@8tpQ[G` lfQm8  N hbhqb0dc_  gp ֲ`}hW.  RW0  ֳ3Mɕoaj`rK0Oºÿ.OCP2Xf36 f۹30f\0f%yƥ # ǂ2_f;Tu@f">>?.%ό%Ќ%ьP.&̊? `̴ Dʹ2α#< u؊Ð?񿰔#̨  ruU#̃`r/Ȱ#胶֊$8tFPSr$u簄n㰆g`rL_rۯG@@9a%8rބ  aQIUvPPF X P.=.;AXP.=.;X/ Oo/ Oo/ Oo / Oo	
/ Oo/ Oo /! O"o#$%&')/* O+o,-./02/3 O4o56789;/< O=o>?@ABD/E OFoGHIJKM/N OOoPQRSTV/W OXoYZ[\]_/` Oaobcdefh/i Ojoklmnoq/r Osotuvwxz/{ O|o}~π/ Ooω/ Ooϒ/ Ooϛ/ OoϤ/ Ooϭ/ Oo϶/ OoϿ/ OoŏƯ/ OoΏϯ/ Oo׏د/ Oo/ Oo/ Oo/Oo ?_
 ?_
 ?_ ?_ !"#% ?&_'()*+,. ?/_0123457 ?8_9:;<=>@ ?A_BCDEFGI ?J_KLMNOPR ?S_TUVWXY[ ?\_]^_`abd ?e_fghijkm ?n_opqrstv ?w_xyz{|} ?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_! ?"_#$%&'(* ?+_,-./013 ?4_56789:< ?=_>?@ABCE ?F_GHIJKLN ?O_PQRSTUW ?X_YZ[\]^` ?a_bcdefgi ?j_klmnopr ?s_tuvwxy{ ?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$& ?'_()*+,-/ ?0_1234568 ?9_:;<=>?A ?B_CDEFGHJ ?K_LMNOPQS ?T_UVWXYZ\ ?]_^_`abce ?f_ghijkln ?o_pqrstuw ?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs ?t_uvwxyz| ?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  ?_	
 ?
_ ?_ ?_ !"#$%' ?(_)*+,-.0 ?1_2345679 ?:_;<=>?@B ?C_DEFGHIK ?L_MNOPQRT ?U_VWXYZ[] ?^__`abcdf ?g_hijklmo ?p_qrstuvx ?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_ !# ?$_%&'()*, ?-_./01235 ?6_789:;<> ??_@ABCDEG ?H_IJKLMNP ?Q_RSTUVWY ?Z_[\]^_`b ?c_defghik ?l_mnopqrt ?u_vwxyz{} ?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_x?_ SQVW33 &&_^Y[Ü` غ   nBnnnt nJFn aS [ 3ێ7!C &?!Cu3ۏf&>CPQCu
>W^ _2E	R .'ZSfQh
.v f< S .  [a@ = À> u:ðqKq`&o&O&7aPQRf&f=DtZYXð@IKABKȰB;KڲrAýS2P&W g&u&87u&8Wu	&*guA   YP2r(ں 2 t'sX
yW# #!u
 !w"W`\0Cu%5&t	 r _Qr2#$!ds%QYP XSQ I аOILI;vhJ &t u2K 軕4P蟀ɈXNC77P48&h蕈>89&:
8h{t.  .3Ɏ٣gi
HP/./u	`?upPQfVfW h- @gf& Af_f^YXQWV
 ^_YUCwD}D+t1QWPPXhX@.X=X@uX_0YPaGDP!Xf. $>`7u
PH@XuSWh , s h4>&M&E&MM_[`L>1&$PnPt3Pt"3&M`P1NE<taTCA#o7餿UhPUUU.U%UOZo[\]^a
<RwS2.d[ø G 
GаFFȧfY&@f3ɋd&G Qg    f&Pgt`iffBf;hg&GfiwlhjwURgtNg{tGFkf0mhmDQgfY tghtpg eAB
fP@faeUf&ffgfdTOI vCNFOR J 3fSgdfCf[ u|<aw{    ^'f@t6f!f쿹! f3xDgE 
tfEF!t{ f߃!	xC< uxC u-y0 rPmgdC gׇZuL>]0"gdK& tf]fYfI[rtJRPuu@hh4S ?1h0rXu. ]~prVfv]fAd} ،[vMqdeERs.#tANăh[B[fZt0g /B~Wvu⎵@؇h'r0fRh:Zr/OoɕPPSPd`>ߢ[JS %h}#rh>2f[mϒݒߔf.EDCpW߯&?"Qଯ镨KK}"x7?8Yo ~	
T


 w	&*X3X4zzaDn%%7qGgplzf.πH!u<u<yw_
`Of& 2.e.Rs8eRsS@
ذs@r@}d|RstS0vpv&;xV4t0?!u@_A[f{f[0B5@5`;1]tu6ع"PgHa Vsff3fds
"28̋>.h|fdfdfʉB ΣfӢX:Q͞sw9dBe: 23`9/hF sr drՐdhw/HpeW@ efAtېt_fY`0R_Z臥_6	y[;;2"à"fsg]  re
,-./01289AHIi|,014589?_ `a 3 ?0Da`$a,PXr 	Gna	[2t*:aÜ`h=M>@ l> lGA lBlhO3a6$?C! G@ A0at B  $0sϊF~0\  e0\  BnnnJF$%?JF e< t!!̢!9  F !S!!Z} Jޢ[a%   llB &ؿ QlBB&E lU))))) l?XТY@&%&'5ľg(Lb(?R.fа 
@ .&FF/n@/2b)Un)n *n@*n*n*n +nh,nn;- 6(XY !t 9a9&0&"6C'$68$@999@=<1%(#7 )nne1^ 6	 n23 nZ 	[QAaPQR%> tV8"$PC8&~@Du@Dl8
^8$ȡ
 FW8PCI8$CI8aB
 ZYXèu<w'>, u0D2J$<w	rIbDf zItS>+ t2 [u, u&D<ttur	!ߞ [QPS~P*tUgtFޝg&G 詝su0R <u$
Ӿ3T R!O   2_`tYP}PAQ{*tgo?"rR`tPAQ]*tPߠtbRu3TatX1	
\pI8t"8؀賜r'\]t,&
u윢>ut
$csE 賟t>y `aaOu.`aK"dt$b	&
$sP P
tsMcO	>`M2
X菛I9tR *53M۰+пu
GtCPh0jpO M1<`!M$ c b8OPbcߴ^S]>po ^؀
	t>ts!tsr0PMuM $N ot>%Ieu
qjQi Qw; "N:tuMכVyi!zQtq qHQ(t_QtP vrB=CURQS：sSu%
u"2T(V5W3Mg腝tz0u 4طctb[; sW;"sQq4u	$+u0u׿"Q
u"
2ǳL4輛	  à	t Ml ?	*anaPbtfXSfWit
&t@X_8ߊf_vQ /k
HP@ ؠu j `ߦ&RfHZl¿fa3R/AnÏڿ  (ߋ0 Ef ǞV  DV &Et"Dq¥$D(ЛAs `ã&tȀɿ >@"۰q
&t
r L &}u? ?u8&= r1F&
I$br 0`  mmo m`
 !12'C0 0* | pO۰aӀ a^f2 $$<@thZ"0KuKf
Ku`.>?sKt&3PNRr9Fiiliiٽa`rr X ? :塹trkdȠǽ=(q쐗$a0fRQSۍ[YfZot'c; t]`t`u
| txa X*
ӕĤ mw>u  ƚ?&\2..,.02@8VϟC+!!F!lFJHYG>p +N!ş*tEN۠FO~Hύυ[ß6DٛŨH$#zN!7!S,!` t 
&_tBRu"  t  
 Z`}wSQW,BL\aY8an9an:  Q!t9WR eqYPfffX fffp, Qh"0f<{YhЅ{ 鰃qڢ ` 
qQ MfQR  f
  h4,3#PK   0Q4BT`yKYQ    3 z3 ZfaWQRCf5 迹,t8qSfPRQ2% = uT?= u5 E= PL^= u
xDZYzЅ`c   aY3f'!P9'!t W3'aY aB˺ ( * . @PWQ@ D H f U,048WSAQLf׃#R00Wad  t+s/ *a3SKD[C vS33MtVDt:VDt=Cp!t<w>t8h Lɰ bI:h
 
)@& a ӡt3I,GM(zD.DDTU  rI")L<fP(#)KDr' I
(	 fX9t
I蜒kP|yv(ע&$anp-t1#-xQ#".IDT..fr)RQ+t0) .D$@s
$:9h9 KDȀ>&uKt8KDLaÉ=0>H(

}?(CI(CJ(?(؃ @ A(A(2=
s3y@s }@FFY^@FEEF@FE$$$1:$u; Ju;v@JtIP$:zɢ`}$ M  N؋!BklKQPz:蠛r:ȈO&<!qwm8zapҴuS  "	&%%%%UOPww
2%rPU0m
À
vn`:p[>` $2D[2[w#ÁSRfQOq2E  a{aa.JhxJS ?dh d2 4 wotRe g!ft<Qe WY3A fA iuh '@hg "l"lh8?c H 迊 DCOCh[ocapEpJq@pFrqpGtdZf   hRѠrx xrxzR0轻}0}0Z  &  VB ^PRpO}0OC Gh4=w;b~Ճo'~ՃOx yf`.&&tٛ&cpЌЍt<k߱l谶Cm袁m` ~At*gҐcxTiyst-4_0I5%:%+ f`8P%}Ⱥ:#%8  t
ف  ` Xzc t(  uS-Xt
   Pߋé ؃30 tOSHf30 ӿfaf3uMff#f  
f5Djt7PY h رP_  XaRQX0Ra#؁㰞ҝўuSp@=P[%8pQ# Y3#`a
  
  2iR F
`Pu
uoз b%` amз!a?
!!%@m @I$t谿XÀf\`@#$3 5 @qiQ
 yq_QRfQBر3MVu
AfAxVS  6yD_2[^P{Q :D~{ +Y d̱ބdwDQPSVRukзrdr]rPPdXJXP<sǪX1T+[<u @:<%зYrr#z@M9^з#r賭зQݼۛ>@F:?.m.s.`_s	.r@[YY%󇀡V4ɵr(S
\rzeD蠵r'{r`Pí.../VQO0Sr ..^!] i VWQ>  ؾgK Y_^0a3.:sE$ .hR.tbâfRVh;Rt0hRh4ch[=r ff5 ^fZf`ζ  _Ud /tuՀ t25} <H/@'-rh:-fa@f`aXRfVfW9 PXf_f"߾" af`E7` S@3`& ?_aà> u( tc.ݻ&(u!>t\cs &u舐Quu? `Q _&&ǡ"8393:37Q/\TRYcM>Q04 MdL兀u$C3$?< u&B PQW<u
%7ug_gwNyT+72,v+xN1w,"#p$%=Q%bMvX0+bWp=bQ0
! W 2"0'*y+ޠ6{N,6z+N|N7b3%}p=%ð3_h r)5&" 0 J  .@et"@2蒓߀.> AuрMo,is t=>OW4 *>Eu EbpkQC-C'rE_Y^tw5W4HJtQrE-6@@'~sALy~
KP% ~CP&&X?諒>&\)P@T"du@T)ÁKNsOnOGQ`,33 /<t+}t&`u
$&~.SfWKt"N
tW}0A<tcg&G A\!f_ *~u+}pX}<uYC><Ҋ&@tˋp`` fQfRWV
a8odO
reS6W p 2:> u6 GhHt4go hyr$i3Ҭ؋hrB^_fZfȪbd}S>h2Pkkkh>Tl2"l3mrmjfoNemor.H @po
..`{|SAMSUNG
LTN141XB-L02
1P43
7
Color LCDIDTeCMO6 88888І_׆ .8àzPXPS08`W ~̀>_?Xð gPSR2B3ðZ 	`Ŀ pא  33ubW fϚ_fAmbP33 |fX0$3À>6 @$u:R qb 1 ٍX[u0uC@[s uuo@ukٰ>6s Q$u]!t @ Z={O
u4/S%T[a&<X''ORrΫs/a& @$: u:>:#/"1# A4
*+a; u;;Ҟ; uQ)j± ?_߸?_6Q;|r]>;X os;L c83ҀP7B0KM 8u!u
{ 08uqt	Q3ҋPW
 
t	_ كw
_hثchNq͔f33ɭFff
?f	ffu2fÒbQRt$BfǝZGnpӔtӓѫAQVWt .# ~jG  _^Y^!rV&MAݰ<PSQWhkcr6h4,tQW _Yu t
tu_Y]Gx	N 1``lĳ
P X0]PSr 洭
6]S^u`O Еa2P }l
X`
 s
2[`.P2
!$$
؁#u`
;X[X f߁
؀ ݤb
ف
߀2P F!P(<KrK:P苩
 @? 8Pa0f@3f   f0f>gf2
/' fǍ@\aPh f&>ft@abPZf%!g  \@PfWf@aG0
X<t<t<AjNsPS$<w
.m@rb }1?qnSf h{W.Cf af[@ &@@
wљ+$upI 
8s ޵u Nz >`V$<
v
ط  P tǀ>@  $
زh3m$D
-d t㋷u8~ n^!wh7Ɠc

 1-d0
 QAu @&@qr @@>@ u
8w3"f.@aqл	PhBfC pfBC
C ^!>P r? 荂#?">_B?!Cku"Pt
hB. ! î| '''{' +('W)'Y,+'S+(.C>R0.Ca0/BZ1c202""
ZP㺴dCdC02J!6f3J/q77H38q71 2C22PB:X1043SRۋذ4u`֝fQSД _[>@""A0KAA@@ArEC 	
]#EG2GFLFrI@!LFyI@%#oѵ%#HUIDDDDDAL݀ߤI@2J7I(KǵJWIDMЀ0.&5, .>5S泡	 0-3@a!RpR Qf.Ea~j RN T"EjQ]T UoRyNUf.PVcYSeQ@?@+ vY[	FEEFFFS_FF  ^$^:^YFD^' EUUE`Ua``]TQTLbD\PUUbU UUT dda    T T AzfUlgqdrhU  &tHuP
hRuP/r* jFk>,0ް,
#qFjA&pj?@uo?u
 뀣0oRqn kSmPnϱoل pPdpmUXGuGs2.iG/r}|Q~   &_M`h;sk>uhPS נ?q{hp{hT\{!t{hJ|hX]~  
03!4u+t
3NO+t3GNO`UN"HcH"H"N(HJ쪺K" at 1Ѕ(HO(H莂  Pa`b0"u"!t~$L4Cs`(ju%#}I25R3~Cr&  P?u
gCsE~S~qP&349~XqxIAPpxIxI2_ 2
O{UV<22 P t$p s[.p>8^]2 	.?U F`Fpph4R3?w`&&& aFFF J.Sk rJ`yro<wP )uryEu#  hδt߳hhs{2}$>
 >:R}qϲ 0)ZSI$8._1r1r PZp ,UG0P 7suP`vPKF X P.K.Kؿ.KȱXP.K.K.KX L& L L$፞
K軏>8S8rddrS<drp
d2eŀpt
w pt ip^ppְhys"hShzs6pM0pStIBѥåPp|prsN _֟׿? _ߟ? _? _? _ ? _	?
 _
? _? _ !"$?% _&'()*+-?. _/012346?7 _89:;<=??@ _ABCDEFH?I _JKLMNOQ?R _STUVWXZ?[ _\]^_`ac?d _efghijl?m _nopqrsu?v _wxyz{|~? _߄? _ߍ? _ߖ? _ߟ? _ߨ? _߱? _ߺ? _? _ɟʿ? _ҟӿ? _۟ܿ? _? _? _? _ ? _	
? _? _ ?! _"#$%&')?* _+,-./02?3 _456789;?< _=>?@ABD?E _FGHIJKM?N _OPQRSTV?W _XYZ[\]_?` _abcdefh?i _jklmnoq?r _stuvwxz?{ _|}~߀? _߉? _ߒ? _ߛ? _ߤ? _߭? _߶? _߿? _şƿ? _ΟϿ? _ןؿ? _? _? _? _? _
? _
? _? _ !"#%?& _'()*+,.?/ _0123457?8 _9:;<=>@?A _BCDEFGI?J _KLMNOPR?S _TUVWXY[?\ _]^_`abd?e _fghijkm?n _opqrstv?w _xyz{|}? _߅? _ߎ? _ߗ? _ߠ? _ߩ? _߲? _߻? _¿? _ʟ˿? _ӟԿ? _ܟݿ? _? _? _!$SMM MODULE -- COMPAQVERSION: 1.0 t蔢Ȁ> uSEuuu&g߸ !瀯 s@[ðD7$ htvߙ r
8 	t .E
y`<v A
N; b4|MM(p>*[īύυVM¼)74H#zg  	{{<  2PKd; 7@7d/ VQ6yDY^PV{;ty^Xf`ffhO	t$h=p$Ūr> .<t
../!N!!NfafPSwRV A1fpr  >>?؀tU.$p!`%/?tA&%
 &N'Nr>h ^Z[fX#Bf"B}BrPe?4XPSWRh4	 >V u&E *Ou&} ua.Ca.he	tb.,Z_[X`v-[hy	$&]r
 %[hC3^%3 %^5kaðÀ>7 uC>ɨ t$<w:9h:-	R>t"1:t1:t`1: u 
ZSfQRUW3:&:;;d <S_ZfY[7 tssjgPP=W6_@XCB?1? D5??$?ø  PRBZ0DQFB G3Å0u$H` um    >  %Jt0 	 	aL
  3  ti  MV ".  f@@u.2h-)P Qt
RR=0폃@TUSS@PH@F.0N!(7_NNOIO"`"GiXHRY.$!HW$[XOYcZZ!HfP3f&T ff"2,Sv-#1	 .x.tI1_a.S.>?sR2 hP	v  r?ߠvf r,wrgr rtB=u
p買a.H1[,k te6I,@ ۋ^SF ^ShS	[^n   }07PQRp쨀thGCft
{/ZY)E؎ffj}ߚ p d f3 Uff,﫺.v8vv?7x"U Q\h4v	fr  ff.4 uffffO ~?_ ߇?_ ߐ?_@ߙ?_K`2?0ؾ r-*   Ȏ؍6ć \ar6ۢذ {`1}Q
 }#` fh|9f`PX8  G i @O  COt% r  PB"I#AO(A*A:A4A3Qvv
0U)f@F0qw,.
Z)`p臲 聲!{0u1o2i c ]o߰Y _yq%в G`*P 0   NuHaÊa$1x$
{a1xCҾPBҾx3¿B;ra໻7

 WX"U/3	肬ug  `vŲ#3Z#U1}fayC 8P8*h >% u
t&O %Ls;t D2䰃C%?X,%8Ë߃3 ?é t/Y h²	!v  u@qD6sL
 <50J ?aE$<r' @grgYk}I	$owfQ T hRb.
h2f   ޿B  hNH hݫ	fYoPUe Gf`hjS ?Ah@"oVUh	D
  t{| uu| up Qf]FF$AF 
F쨈uq2فP[<u UF ů]QY`qIu]^Ar`> 0m)p@!jV ahcy  uwɀ f  2f3f% `{
 0f  tfIA {f0 0 p!P!a f۠
 0XX!"f` `fgff%`  gffP+ A`- pr oaPNX  DA ; Z x     ?0NmQ
8`	/<Pw2 .1DfWfV`2
f؋6f6f;f^f 2fSQfRWf3ہ> w;`ݻPp>n读 2G%GGfflf _fZYf[SQRVWP謊Ȭ𬿊33@f %	_*//h`RmZ`AU 2.w,@`7 22#+= v ؓp_^Z@$
W`غ#P@ɺuÐ轐跺_ó !! +t$tR"u#!#$!E^t>*^$,TA&+J~A&E@A&>p"t:p!sp&qÊ&&rs$)'rq* 'rà&&@E)!*ðGz׏ݫr0-Fҹs)-0*ιðD轹$&J ~26;̓F2؀w3SVa.00t^X34.^UXL-zÃ&'&Dp&P(@8A,w&d dtKs	2syDo!> _D Atٸ B$`;O葠!1=';00X7D4 ðd.  Q0{
0n0v0`B1YpPƀu	t2-#X0>tCyC ø ӉR&>~IR""R>eJ>Cð3{+귀
  N~Lط& B~RO	 豍COH買ȃI蠷ذJ虷2ȉ  wuqS0Tg
T@u]<tuQ0uIPVUiW}`@tWߨtXVY
r= tS tD3ۊ:t
u
> u'㉇}|<Q^=p(
A$ [fQ^$tBO	qaf`~Εǖ`fd w	Ca&=fgZ06Ê)È%;%@=*O hγp$t
^kphp.ѻ p2jh(-fhrdfpݧ(qh}*h4,䯜h[,䝐rr'
ufZrh:
utuf>QPH_u(lr#  f&fd|}a1bS){-+Wr(F|A}| e Ar~PfRfV r s]fPC 
Rh ftUzІ@ uJmt ;mw<f6of6 r-f֡gbgB
grf/fq Zp fWʰ҆1u
 Q  f> 3ێf`P ? t\ǀ t
tQ@ f f? r9  3f01^f[ H; 6?fOrmgGƋw g fgfVfr7g>ff=P;wp@
 gf^u
fFB@pQf$Сftgf&g&fY ,P\0 x  $<@`dh <L Щ<@DPpߐ @ DLTX\0 @, ,  ,0@SS <`hlp@< p
 
 $(<!  ,@DHT_ ߺ?_ ?_ ʿ?_ ӿ?_xz<PXYhijklmno	

  /Oo /Oo" # $	` a>0pbprph0=%q?%ǨbðNNO OhZsmû  윀❻0 ڠ@ 6f.fffDɜ   輜   c蓜褄w ߈,aSfrVW f -!1!!ȑf%QP0f.2fff`7u_QCf"q
q
fg	Q

` f0f޲fQtofY0f10汅fP3XPSVWfQs:3Vي t
؀u uf>fpv pUf  fY_^[XÁPO"!SRP.  XZ!=!{P ^虪a"訪J^X;@=! WSQasHB2!  !! h v!Y[_ C'R'=FХ
̧ڨ-f0ed 2<w.
an"buFx Nt@$^`-I5Շ$ M.BOg ??K	ψ&,Q-ߨ `0 t/tW wptu6tj$
 s tQ>10tr7~  s`E]:<nBA6 庱6%;tr7"; ! :

P=	2C, CO`5_u@@ۻ߰[>0A;>t,1Bu-  Q^$^1KK蚨/[P`4 1BAa35 g {>DuT>Du%  o#FuIbIFtzsrD7"1qD&eKRK`DDLL	D蜔XA3J
g@TP1Bu^^0
u!* 
Q-ާtB ?R>
2PS55QSQ-6. 9p9^V'$@W)W$.X$p9X[b4t9687r;$< 7`];]^$U2S 907q>
u :wuCa>0Ct'\utu}!FrqCCǦp>_b4uAe
eqePAk[Ä87FtE5Q@$^
2퉁3Nrz>jzs3WwmkFE5!Q@^ 708u
`[7YX7O;5r=Xpt3 92r1!译P=
=n?;r2sf
Xy |S8 a4d344<E5Q@}r]{_ssqd \1r&&a5$@W8̀lPm`"k@Wmw>$U[S
AQq00Ј^0ơDa@zz.p/[}A u)p&u004pg?C,	,[À@r! S= [Rp C,
,DD:`I@C@Ch?>pt+&f&
,6 r) y펔S<;w?<w2}P)`<w< tН<w>r[r/2r!P3S
1$pGuhu+ګ )gl̬=s5Zf`f.*.B*.ޒ*.6 .,xv
Af.f.r.r/faõr!3r PX䠊
䏀eu`Pf h}G aڱXҲ0u쯨t
a<u <u õRr$r0 փ.*.`2!rcrr~$z`=g$мX#迒бޡm>#`  ;"" QYo;]]ap0ũ r&.uOPyW ~D' r Fb.&w1vRQڠLмZQRrHbt2ZY`ٵ[ot"zÀ 5`TZYa^Q~r#EbY#!ٸ 3 f3& &EZ2 Q&&,r#r8t2`.u&EO hv07ȯSh[&M.w12t{@$,@#h } 5W h3Rhb&2h4S_ ?hh[fZrh  `vaw35 &E
,Q#QQ	Q	2Qahyb&%00` 0 _% `̃  Da`6(   @Kб aV魆ī^W  3 _r-}`Q˸ fD{f`D``Հ tBBeOǊ o
rr`RqW2&*G_YýS 蛠&*`u&}Zu&KEQ_fY4Qگq rj re2ۃ<Oi	B<tPbَذQr;; Prg r 3hN߉SQ
paPtQ$<PtKu aBY[QҲ @GP=uu2aY0>8YV Wo^WmpQfRtt7h;b&t0蠝r:|Ut3V `^tVh?b& f^D`f0"!	

! @`fPSQW3  艊tf0d f$h%(_Y[fX.$1'(** End SetActiveDisplays: \ $R$Nt5<x )ڊ,  8t+u8ud QZYYQS+[00t@u-YX@
2t+Wﶇ<P  @ YP  !.<uȸ
y05mu)Q 	
3%{0P9P9?D -VsYYL
  X!P峑 p4e Y=	Xߡ93SRP`%PZp4ċ XAXߎZ:RS@؎@ CusBBZYgRP@AA tq@PGÀBՎqABqFQRV [X"3tJ-)J 9P9
:\u YSO hp4@Xf`JV
u Zr2,RW>_Zptrp "Љ&& &E"&]  'sP4"!???%!mZ$.;S fW?U]f_ B;W_@;ð PR3^ZP; .&t rH r4t_*fPfSf8$ft]7`.%fYf' $' f&fcPdReC!FfWfࠎr	 pC f_Q`Vt' tf@f ITAfgfeؾP 
 2gaY΀d 
0'tXj5kWeH &=&M_0g.g ? t0;r+gCCp l)-Pnȸ6-@uu_tmv `;q.@;f f@y"y6p؎-t pP (w >ਡ|qQ Ÿ{ty}ho~OQ ~< O *~ap\"1{v/߀>@TtyK	t[P 29Yu3PuQ<
uQ&h+u
3uCu藀rpu褀3rvNwjѨfZd9ݹBJWpOZ2
Qd$] g pdYϘ/O oϡ/O oϪ/O oϳ/O oϼ/Ooï ` Đ$`<`u*0 .} {1q ǟh ~ŉ u BJ. @SCʉn OCpʰ|PW@B$PCaP h3pXgg_d[ Q(fаg  YfQ\PSf3f3ɿf0e փP tfAd 1P?1[S3ء; X tDtp좌[Xf_ù@ fPffffX,fV3XދfVfp  E gf^!Wf^Vaؾc _wھ&:ܠp^8ޭ[fWQg7_2g&'\P%@f_dQWVҤ } O1TtToъ"hl}QpP}]r}Ye}Yg[}^&$>Pu5$9^*}&}&`QW |D @y|;BFJҐgf`f2Qf 
 |f b{|L|ӿg&p% t!q ug&'p%""pP5| p%8|ffaJ%QݹA Y1x92fPQ> uι red`ϣYf#tCGr-t`w 0 rpGP5Ҋ r
6pu`dP . rdItf s` 3ft@Nr&r!ww3r r	g-@PR.P..迲r. .. .b{.Z!`Ѱw{YA j [!Sr	?rf!5""P@ dtgf0%u&v>? _fFP;eTGM2 Cw@|4?Q "觰4?2  àD, @=Q) hG>>?@uq(SV-茉 1޾> f<$F10tuP"߿X4 D-m^Mذ* W raCD B;7b1!xQU ȰW>@) :@)Տ :@) :;?Avn;2:<:<;2P>t
;?0!-S? t33 O| U0t= AB @) ttrÈZVnn+3> ? 쏪^p[GG3HG<u
tHCIV{hp^WL_PLc虄LMPMG(2<tzĹ HYIOKDI% e>`K
g}0& /_\r V*
^%CH!_QV tU..FZ/F{.^p( @2uv\RV7rN^NrC2r<@6r32p&t  rr;w@aҀ tsڋ^ZW
   е0u
˾  vu  f u֒hf@A2Pi J332[2@htiPi jPdrnm
$	"
ſu\Ƌ߱d;sRZ3lFAmF2P?2tao	u˸
S_ø
_....az.!{.6r"6=Q$PCx|0 ggUCESu
 wffRVf (grf fff^fZUf Krx3|  Xx،Ў~ OPExfXˀfu t ` rW@O tCߩ@ t> t t.AtS
 S@  [r~!?fn   _SQ!~#   t
0;t7
 '󉾎
P%q0`!~hh4S ?j1h0rȸЍؾ	f uP?!p
fffLph'h:4c~q!pҹ  &!hn/#G[p 33u@-puq@ 
d#ffgдQ[,erfʻ hW.#Ӄ >uA =_aOPQcfQP   refA;w}p?S/ECUtԜ3a 6L@Mff
@w	f1Ҩ3ܰޱ& W@ f_r2vc $g&$f?g&	@Ҩtcg&fGt
WtPa9, f    ur%~ rQ@fYo	fa  "f@ϸ(%q!$P rpDV`@ < t6`O1 `:u"F0D1ҋBŢ t8Ɓ w/\04#S`fUfƒ$t	 /--
f+ff]^xP: ŽgXv? uan_\]_ uf1 $~03r/3М
 !F6	r< u
 <@Qu <]2<
 h  oF/Oo /Oo /O o /O	o
 
/Oo /Oo  "/#O$o%&PRPRVFZXRR30(Z˟&*, /-O.o/01235 /6O7o89:;<> /?O@oABCDEG/H'Ȏ؎SЍҋhJ'KfPR S0ff%|h f
w PȺ4M uOotB\f  t(N,#%9=!Pp @t1 M@ Q tQA.u_fupTf[fYZfX1VBPf| WBVSW   8g u sY  sYU	4Rf_{[ \J  <Z_u50 b?Zjrlyj0P/< ^|i0@ b hDmUfp` rBsa}1  Bt	ĭf0^cM5d,-00\ú:ttKSf]'úA $t"t
D% t
H"t2Dvúd u0N`_f[uf|XQ] @+peRT0n%`y &qTpzPSQjtC tԀ&.ru'u!`purjtrt t
su
1tS% [rt!!xs	u rRDۨu<>j1k
`}Z r3 X1tO>퀴1ws~Px
x1w"~z!1wz0rR+sA:s݊PQ
v!tt	tc
ZrRPRP*lXZûHLL.~P.غaغ.aغ@aغ8aUPfSR.1@؁ ÎI. ,f@  MfZf#rf0NBЋ%' Pn@8M#M ~S؁怈rWV2#t7  h2؋fȿ ff!33u?^e3һX3t@߃s a L}`5`hjp
 lĠ@%m~@W T bBf  ? b_3$hث2?$_Pʀ@k%|;x~
q؃21AL!fZ"]&EE&0_ 1MEVMA?)bߙ ۠3ޱßύ:s:4H*#ޟHWj_7VE mŰEŲ:5!A@jFPXڹڴ (h}21J JиP
) 10(#h4v4(rN۹xڹN@P(q%'m&@f}  nP0ePp3@f3 @f@..RVpYivP`Pe@a³qUz{	ŰR߾2O&3hmD2&o R PfPSS eF[XfRmF̓u (%PS͝Z Qf Qf&Yfc% _⛹ qĎ p%uy z%r} r%ru j%rm b%rer]d%uJ"羾At #r'%r%rI$$貥L M h$u؝`,nu i_aQCd BBYÜR㰀nBnBB2JJnB$nnZRV!ƿ(/P6p0v^ZáQVW Q_^Y`%mG@2+nGaà
!  $s-3f3.;'ot`ؠ#ٝrARf흿+t3Њ0%a&Køۻ I$û}HVs;OVPV3;t<uO!?!#1迣.  `ZQQ8`9:7`]1Otm#ðqlq$p~ PH`ǿLȆV aäؾ3.6Q@p80  hN1	fPfw PU~b1EfXf`Xk=d?tøbl`iPUPU.&fJf>PAMSf>0q0Pd>Of&pEf&E 	 ql/BU0]oחfQPff+pM h
.
  ab3QzM hWĂ!Yqr ! X-"1]<#F$@p`%A*rfPbqh4`rYſ E6fP < u 0h'`h:0r fs+3f+h[0Y rb7h;t.,a]4r@Ƞ.E<u/10_fp/hb:0)345?`
Kfdt; `L"aÿ`J@]"JAQRLr&=t&} tV" &GF^RBY"g:\ :aþY  hѨu0. 2Ou&oI5J5JAѓ`MþX  hʎLvN@vNObvNOhvNXQOR vNK&cP~̀>'? rNuNУ"I5J1NuNr:N[Rpq t@Hb_ 3lvMM|]٢sF%#p  &Eη4(c m95l?] TEb
_  .P"KtC[格CՅa?P큃	{e[if2k@gPEP ; k It  al 	l@0ElA:0Ŋ!lA]swrqt.(QffRwE 6r<$$.r(!rrr	rC ]2oǧ' siaQ]ϸ֡ F]!
w#K@桞Fd-Rl@lJJlJlBB ⾁W(O/a6`=_ZR 0{0Z6>c 8%	ч	rQaøsPNcqNc9@3!3+?_ ߢ?_ ߫?_ ߴ?_ ߽?_ß ?_̟ ?_՟ث ۨa) ݿ(`!#dܟ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_ ! "#$&?'_()* +,-/?0_123 4568?9_:;< =>?A?B_CDE FGHJ?K_LM  p   
5Ux MQRT?U_VWX YZ[]?^__`a bcdf?g_hij klmo?p_qrs tuvx?y_z{| }~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ß ?_̟ ?_՟ ?_ޟ ?_ ?_ ?_   &  }    PS#  - t	.H    [Xu
.'
uu  `fSfQfWfVt, uS l  Jf[t݋3ff^f_fYf[f` a ffa   SQW؋2__Y[ò					%
ðc	
Pp[^B
`r		a2`SUf`fNr	
	fa fSfظp	fӝs(3Ҡ` ؋60 zea4
`e eue۪e	e8aP (33Ƀ t	APuxe&>R(eaB
f7  ta  ?u _r    !S`	
hzW_+[% &E&_"
!x$fRQS	2[YfZfQRWP
u0B1^5d !, 8uf3W+0|A1X_ZfY6 s1r `ABCDEx} ~@fPRVWf	 fFf^fNfViЎ.< t ~.FuN._^fZf[fX@	1r
@
 "@
VfPhPf0  f.e ..enfX^=Fn>?'@v
 Akv1 .;nt t+0t .PG AKftv}	Hnf  4 t j u3  3GEA3GSHt<  [SN> [[ÿ t$v~ Oio !PSQ3۹)Y[Xf
	.`As.QI..Df.|VfVfWQS3Xt| uRY\t[Y`^ f`03a~;B tS
tw*
t& o	PO볆o##`G z tfeff7~
^轶 `a[]
 UPSfVW2{ Gt {f \ t]fAh6nP[AQJ rg>Ut2gFYPAXs\Pf3Xsȿf	P^[X]SfWfP`Kf f;r[r}WitlmAюo]_pmn WAp$_p&5 rsgNZ	g/Prs <@\ZSW7gfFfgf;PCIRu-g{ u	gf;K\gCufQgK1`	ffYfX_UND^A^Ns" Pp  Gp  fn
y@ pGRj@<7PiNV vyN"Q3ABY;3A+X_^Z0Q 0  t8Y=QhB
Qf?a?p}?pfY@~p
6u`fWSQ[a^fWV߃3!Z !P11/Pi0] fP.t "  ؎fPWPb`f%: t 2rhVF
uNF3p	F 8ȋ^V`uf
Fr;Vwr;FvN3Җ^ƀj rh?r3Eȡf7+FV
+FV؃ "𦡣"  m '80y
+G
vm> u怲A*eF81	j jFPFPN' @Gj FPB8V
q	q	~ uazpm  c_{ߘ	BhBб  WVߋF= % k:؋>@@@Ftlf&@8FtF% { +ұt1Ht	HtHHt&-9Vu~r"f~  r~r	FwsVFsF^_
  dNf*΀ ȉVfF ѻ
Ɂ3Ft	( I _F81ӫ`!1!0ӺPU؀՘f0Ӌа< ְ~k%hq~$wP!ӋV`fF~ 7	V@V^ze(FFݘN*;~^u@ޙ
)ȰRPWVa߮uFfHuf@FVc;tL+=t"ޙFVF֐ΐ}VfnJāW
a3S;Vwr;FwS)FVFVFًFV
 @e!	>fG`G3VQF |Πj*΀#@@fN+TRP^#p9Fs$FVp`0iDf0פ*QQ^@Rv@ъa0Z~ t	\Ë!An0r:W~ptA#f+f t_ӡAP  tc`;vf9GrLC+sC AGvfGf+`Bfvv? AF@s0 {~!F f;OFv8`SVӕ 
f;Dv3י`΋VWV3vF k AsPS@5FcFRPDujP0뀼ze uvdNFFA,ƉV=(ut'*$<u؋ƺ`DRPA,뼀~ [uRk+e+ұ8! ^*䊇*a 	7>uS;7F96xew٨PS¡	u~+9D
r
w9|vd'vvDҋ^0vB
@ *H+;WrwQ
3*O;w ߳ܕd~15NFaΠF3cEm8$<uՓ32!FߋV3SVe21Fv8H w t2Nf% ]8Fl~Gf@f6VA< A@PFVR846'(T
d89Dv0 5Ԅ8JV@Bw DC@FFs52/?0S1a246A c tӊF!t0$"DPNs546PN!4Ҫ6qA78rTT#:a:0f; `JlfYO<h=!3>>APP3PhZr3 j
Z^  3ZPV+k:ߊF%- ұ݀PƐ@@x^_``&`a(aFt!F5 P%az1 ъ%t
 gB1T1Tr -FvB	F t'5  f^0p"tA^%5~$sqr% g		^+F`̸(3oP#WVS*! 
 A^E\;u;UQ>)u	pf+^uVӓut F0^(p=bp _CN݉Q`A3n F(/k:@2fut @u% 0; |V@3D D:B | 0  0ꢲe	 6b^|ΠF0Fm1VM0źF$<w`"@5k:@@G  **uGW *␀= gqGr"t
< RE	E	 b2s" E*= t0&jP#Eupf$ + 2E~z 飘yq> ւ%>WVQ~@ ~ ߍD@5M?
f+o@0׉VZ➿@hN밼$@fp^ akN:ى@Ɖs"`lP@K&0(@ѡ<Wu%DFB ȇ*@PPo氩9v^~wko:> &@ $~= @sڿ0 ŊTҘ
E8%Vk :@ 0p
k:9@tC90B^_A3~6 "@tu$ NtF3!ǁ%^t7B1uϊ5$~!b:  ~߿96't`}b%@O0';t|>'pt@ՋZ2%S!}~fы^9Fp 	Fza
avvo^42M  ˢjp F򢧑ft@r
PvD26E
2t
9Q!;WZw;R-fڠ]Wp`
 *1h 9j $٥٬5ڠVQzْuQUЋ^bt.>&u`l u~W^DFDP1 `\]#A Py°WDP164-랪^\uq!?FgG  P
K`o~:vR! v :}tyhQDbP5mbE9v7yGDPgJwtobPǣP0HzRVF@?f*1k2Aw8h3گ 5tay}6
 t;|a6 PpvPFPaĠ^eDPpc
t2gUU  UUv6\ } uAEht"aP}+*FN*+@tRZQ>xet-T}	?kxe!@v鉅+e(exeVPSVu@83>;r;8| ^[Xpfam`Z&k``!muN#. pgPb$@*'Ft>v9v7v3p~&p} @ `PqCA% Ak^u3҃ r PA3wk*䊁u luRv3;Ft7;t- t#i S+`,u
uGrvFr`2By cIplЀSRNN `0mFtv`Rmp{Ny`zy3ҋ|3fs5Qzawh1pj"$`y^ @8@ӿ` W$pP?'0Q1ǈ%@}, .fJFBBBB`#` ܈F-F҈FvԿFKL QLo QuS32<V Mpw#Md PbP*$@V tPtR``BzPSv 8Vsy+ ;Viw;F`LE9VF1V =PCC$DDV/EVF$QGډVPCIޡDV?KVF?M9VF0<8Fnqƺ  ۋ^^"  V  V& |2\ƺ( }5X, xBtfN F  fBtF0ZsZZ1[YqJs܀σ8F v]r9YR^+8@fҍ8@]V鋕F+o@`ڋF֋Vob Y0 Bt,f{%  FRʯ
`a'3b,  e> kQiP`m#X7R  4 R     U NAIBML 761295520C??C"r   2005/06/10 15:58AL "BDR(7<C
DIAMOND1.0 M10P 32/64MB BR13481 m/250e
 (C) 1988-3, ATI Technologies Inc. BK-
VER008.01p02 
8  opaDMP3.v611  P`AGP DGD1UN  OEM VR 
p22 h h q#.]-  q  APC:yPz/0$TVS߆Q0  ' A  RCPCIRA  
MOBILITY RADEON 9600    m&\ k  !A@ @ D  H0 0
x$   Na  A!!0 3Q0`^ OD @P`X PR|q! rXVf%hA A0q @!(= xr&p ]*** *+* fw*` +*݈*!*I  *Ph1&*w/*m۶ 1%c1""sM[
u ` 8A=ߴ
 !b7( q!aOU  L  'Hp q Tq //D)q))%2 21	Z @ dM>A@  U' ? 
> H@a5ﶁAD< p 4`??A w M0LL 0E&Q11 
%1!(A1I_11ڡ:
`(50   r-A!F 
%$@l%7   ?N  Q 7 PQP0Q R}aR LARtpSR0
`(H < B -p72p7*qUUB2QBQTmA -5`Cp  @"uu-߀ 7_0 # $ op   2 2  \2\B\2    >^ %RA*@___QB!<_B_AcEucuc&c1e+_`_a  1*Dc*c*d*&*e(H?2HH?aQo$

3@b #B@kA@A@4A@
  P  2f8Exm3B%lt)@kv;  v:5wg
`Dk dxhy s!"v{v{r  V}t  f`.>8 u..8.:	 u .<.9 u.<Ȳ.8fa.Qv4.>!u.Uv.&Wv.SvмYx.Svf`f`l1INIub. ST[)$
 t.VW _^*FIRE GL [T2xcCPU$/U}T+$X-aoATpR	fab4tW.`4P mX ` ef"WP2X _W&  PXuC &GOfGGOOf& G OOR? Zu p+ ӟcP2?FX1FXfP9SffM f
{$ f$fV3s^mns~X=ZuG販c@=V	)4 
 ¨Q
K谎$RC P DXADR ?u+br=2et tte0įuQfÍ;Bm&   (B,B>`@] u0>]2ĸ tP䍜f@ f| <1~ O5@p#@@ ѹBศ๪.>]ȣ#$ $Vr <v  !  32Ĉ&! .@2xd^Ð	AaNhVJ*814(Ld
F0(1!5sF
 a{$ 
Q.#Ń>ME F
u6]c赧dtta/x#x"txb2>SFN)N=fd{2`Sͳ Vapϻ b p Ϭ  t
u]a<ϒ ϋ Ht1u	 <to tjf;Qs Y#aF;$<t*<t0<
t'<t<t)<t<
`	t<t(<t<t (83
mh(c"I/ ?F f; [# ~ tF: FfǻF6~F2Ag wtÈn<uj`нt }t ^"N 39X8u aP  $X"8t+N ;N"rҋNN"F;t
~<uF1.a 0s2~tRSf_Nfϡ{ @a &f݋r  syQW; 3_YSPUQn  F CuY]f<u,f nNFFF܀ 
F X[ÊFf@F$FFt@F&F(Ч( tR.&#8Z.``[PR.@]t2M ZX`@ F?wvؖ@:y=0	;5vv p tU;5tBEt:]r9Urmt5f3vf3ۋ^$f3f!}CPs
@8sn~=}:n=a	  1'(u  	
 S?Bb
D"'b
cOQ]SE5
Y  gOV`Y'OQ֤NY"RR0
5 ,jcgvWX |ce
p$Vcj= | ݄hs" F cf	
U'  #$cu#ߥ%$G Lbcu#1 (d9#`t{2$ W"ҟ1(r$dS Pן/?  =y.ҟ)/A×.ҟ1 81y.1 -*/0*y.q+ǟ
N/	
py.`t_ӟ,/
&C-@55"
?oW   A13ҵ SuR"oYW]M  a"ip@ H!"q`@?J`H!"@BUD`axQ
u<2ū jH`HUH`HH`HHv 3߫ЫJÀu#ڋHqLqLqLBK  `Ku	 2ô!OUw aF@
@@ [ ]UHbuqRjRSURSRSRS$
H\uWt0@ @`,^P@Y Xj  U    @xP \SQRVWf<t< t ux.D.< uhdG$?
t\2 0tʊ»d2..;w*`( @9 @..Ttd& _^ZY[&G@`Fu
Uhhh$@
hhSwZU G<uTG<u1GHab,Pt G2Cj nuamG%hKru/苂7BJp!sjS s1rApcppmGh[S FvwvXː.6
bytSzu@G2@  v.(4D
^.;
E08Cn
 {nEYVQـ.ZkYJ	 
 pfFn FnF@ .#$FDV .8졈Pj Bnj@{pAf 3@6nF:qFNF :yF%z"Wo  _赛QVY_Sb[BSW%XP u2 ) N~X_[(~WiXW[_"tF$F&0n
u9C+$
 jW`߲W ^W*1@vҙЌf3ɑ v K^Pm mNaMᱠV0԰߀tpGn} pK {˿ y -^ZAXCPDu@fPp  w@Vb
]u`
&V"tMzV@NIt<uN(u#a?@V faO ""߀t>0SvLBU[w߲Y$ pw
u2B[XS\DSUD  aU)tqAUtA+Ut *U~ m0 t
 wt Ұ-J
tASuT@A %?P%@
Ā?
XÐ( 	 c-'(+ B? O D#Oo§PPBc_OPUJŁ(/Ooȏɯ@ʗĀ@S  1PS0/Oo҉A@ T;(  Ga<! mM"A](
cP 
   Bbc7@O
"#B(89:;o<=>?zÄ+aGŃ_B2ޏdPࠀ"ozcfkJI2/@`ڑ>eꏟ2 _zP~P 
> @4E( f	

FP2 	 WDCءw_z %( (,%*26', 49$,0	
!&.3+0$8=-2o $8?CE  A܀8tcP#P\	2܂z(P܂ģw ?\Oo
`ܑ -/Oo	pޠgwrgwtf (2ȏާE ?*x?(_
`A@9A@`NQO/bz.43tu6=Oufo&5.yzP=: sX.#XѯBү6$ө%ܟrlo6*#=REFeD=$> >D8u&P$`l$ZuM<~.;u*6O<t8Dt	\S
OX:PL
uX.체0&G	tԱ  WG	0?c
u&.+X&c <-fKX FqBBPW.E#16_w^賿uиu
{2aX&IgUD^UD 3p]U h
F CE]Y[	QHFXPcw(Xv 誉>S+[( 7w/wu n9$=Hu m8
uRHGOmt999999_D]#P[U XM-  ڶu辩tnG vGU]Q S[ [S݋ L U026'C[2S  &'d[ ĸ Ë#RHutet&FS޹ 2i&Cidrvt	 Fb7	 2edn Ȋ3SPA|.0[t Pv PH7t@r̓rPHXuSصR[0U	$
Л[Êgu% ot4$
@ xCx t$ÊR
}P X3<Jqhu x<~$<t <t<t@؁ð@} ~}4u{}Á@ÿ)(V(3  @
@@ b !"# 3@{tb
%ƿ`]輁х{SIp(e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;upopuK>L tDI @.><]PH3ug":]<~8]&g7)0u3 32PQ33 YX2PR94$@t_ZXð$񓫨ӔBДR< 3Z8 3増 3߲SӔ3QӔ⚀єQR$WCrCTC f3fRȊoZ찓ПZX8t ZYX8ouTu w2u B83$
t	u$ O0t PwGXPG0зu
u$0<0u &o6<umA	qt	
t 
߈)<u+뿴1u P^_3u< ꑩ㱇܀4u< uqBPKV6u& <t	 z0eB"
С( G I|%ȋ쿉^NR = shPSlBЏP ?Ȁ>cuA-@ 3ۊ'.B.EJ0eXB]0U+{t8 %J|0<8t<?t a .B  躻 밠|%/ +PQ ȿ%K  =Ki Y뇐ȹ 3Y y2Q
 Yc.,bb̍, *S?PFϜrŰ G{	 GޝåA~~|ֺ| |8` 8|T8 lp <~<Pf ff`֠֙6xx~~~p`>>66f<ff<  >!Qf! f {; <f8ll8xA~ '} 0pp0AA$ff$n8|||aA<< lllAll0l ~|0` 8l8vvr >P``0  /`  3A88 A|| x"ߐ@f<| <l a|p |~a 0 A0a a~ ff|fff< l l  b`|``pƦB @ '<p  `bp'Ƒ|:a|a~ZC2sƹlpPl88 @< @| ,p|1|A0Ax|~ ` pPp!}6000ݫv@|p8Rx`flxl ' lAA2!	| |p	 | 06	
vp 0d PQ' QP [vܤA8@`׀݀P 4|eC5488C"l8|aja4f4|C@ a@Ɛ@l~n ~ DrCR"b
~ l`fl f`>c8c>  >Wa<44Ԓq0
܀
 ټ > >`gc=%C 0`p` 0|6>!(l<~Q! ? 6ll6A)l  "*U#+w+,,6---E--u/T/-"-A,;%u2@a24a4-7r/70?A?0c644t6a64a37a8A3c96673R t/65A57t/;A531a4$@R @$AAe@  f 
x+bݠΰ``~س| 8  l8a2l%8fƂ~ | 8`@``121J$~ @pK@ L@&,x aKp֠S?8 *p01|Q5QӁ'Ӄl0Cpԅ0lՀWշa֥@ e@1aץ@c@ $p؃#]ރ"PME>6vgf ~A~>?~~>`RւBf܃ h{dQ`||NTaޚef`$,ffb6 RZiQYSZBs-s`1DdxQVObf0v~T
 n@Ps@|2Kvv8FItGmz ipN4hN# Rh"Dh@Rm @f!N"|hN"~Wz {2րhp hRe!y_&.jf`d|d``몘
ζN1B# ǜ0Qu1a PHx2px旉p WWy@ `f`va c ' }N4inb$` "܄ĉaPhg6 @QN` Af @$,	VB	 ugƢQ	ĺA
  "Rn 2tzf@g~ 0fݴ  Aal1pӺ4_A`̂Y2{0xC))Ӊpxp*C ** 
)]e$K` Vf߄* )W)) INHwAl ` f1`1u~acc0c! ~!)K)V a2u$V0t! 3`%3R B< ;F@>up|`i ~ :T@Pl06>6n6@OA)F[00)~4*~D4+ ++*e2,Ft/ f/iZ
-	K/
j<
 0u41l1~K2 le3&]8| Ft/c7u/6~E7u/ 7'c8F:Z9 r/K!:'Fu3
 Fu5(
F& MMF%@)@[@-A@A/u0_2CC!iBDwb0PuPDuf|fFul2  UŔGGa``<fQ5HHʵ| `:~0"0JD~UfE!b|
/XrMOM{4N4xO-Kx8s]H70K~"R~O5t?W2@ _&&MTWI &FG_&E"&E#W~m_&]%&}&I2.2
t@ZW'YpW)W0W = ~=^~=~=~ &U*&$
$

S0B$
pW-pW1S2;t4&wtWbcbcbc]2RԊ%W+F0Zt=0iebh ݸ  t``jt:t`k?Fh׿܋ qjk?kuq&pllrj
'fkn1nnmڊ0`JR 2q@s &GFt%G uqtGÜQW+&=R&D&TAww	ww p&RWw_%&TAP
 XF2 CzD%Z|
{#}}#^ }	 
} {`@{}_Z_Yσ`v#wGQW(Q$0U󤾄0V0 tS|S:a&?Q$|f PzG }	ĸ z{ 2}WRЋȪ"FysZ}2fpt	2PqYCQEPt&GUwRw2wYh`P_40`VY t'wEPJJ B2BBXJ4wzUm$ԗ/VBBz3u^ʣ};$]:/ (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0433258:=<:98899:741	
	
Ш1

	

			P


 Bp#
*Np **u???!BPL Q   $$$(((---222888? ? ?/ /? ? ,Hϸ?'?/?7??Q7?/?'ȼO--?1-?6-?:-??:?-6?-1,HA   Q  O,HʁQO       ;H
Q?
O

,H܁ܿRLP$
XðN0N_ğ  qt>I~&G3up	u&Iút^cNb  P3&2J&oGWߋGLaģ`À0c? Bґ ZRmmÂ
  !"#$@ABCDrstuvk(
KQ[}Q{Q ;Ql(L!\!|!<!n2ߣN ^ ~} > m@M]}=`P@Pp0 aPAa	Qa	qa	1a	bPB}1R1r1!/1cj)dCSs"?dU/DT}t#4f?FVv$6@h@AHqBXqCx}qD8qrgJȿsGAtWAuwAv7AeVESA    HOL_R  "'ATI Technologies Inc. P10  01.00  @ @   V  : RVBE/FP L.6'<r2.\WVSQR  f&=$2u " W_WȎؿʾQІW`U`U" uzw &uW&E__W-WU .`.m.WU .`.X.W . `.C_ǃ"-W .W@uZY[^_O ËRQSVWU?WQ3P)Y_u6WV6-R2 ^_0Z
.8]EE
tE M]2].l.DEEӀ~ZӰE_E!P>#P> 
E"P>$ ~7`>>!?~$= >`>A#A  @"%߀~= EeUe@ZBtS23[@DN
tȈE}~=
 P )2E*؋EMډE,].

"+E04XqFPk
 f3O]_^[YZp5(RQUSˊ$6w
 K< @t| dQLEY
 b 
-ŀuZdp<T2ʋD<u<t<u<uA92PQ23`6 6X23 P XPC DmID2}bD@O5tu0\.<-[@n2O[]YZ5ø WVP$6OشANt8\t 4	2^ƀ t 3Ba@^Op5q PbA__	9C`3_" PWV>~F^&Vf=>^_ÊFG< uûY.>].<Wh8Ph
._twCCvPS($]i ^[XS0[ tt
uPSR Z[X8
t
߲<lrmBB@Z2ÀuPptp<wjut`2.:]1aPS`O2ˋaPXr(
uË uW3&Assy0_ wA5Op5< uL8赿/؋EIS [`U;vȁ~xAJS,f[Dt@S[%@SQS/2f3ۀbff3fY[f;Ës )A}riflx2uGf`P@`RPfZf@~ff3.fX<u軼S$f[fa= w=fPj$i[f%fPo@}~ؠȿXZREZϋfX25#y
uQR~ZZYA5@ouRY0ZtA5{3qt	Ao"} wl wf{=Д]QRWAo97 f&pf$of4_uYx& n  T8<\  VwRfpmtZ^fOfˋn#offfPfVX" OV $ѓPQRfRfQY  $ $  ZYXѓ
Ao@fz`ffv)Wf $Ao0ЖBa&`fIub'&`[\tQW!$_f.ߗ Q;tSΛu2 `X3ő`,yQS߀u0}3ɆtA߰
ڿ@5[YQ
$YA5`v?SQVWP)*# `R+ &Iccb^Y[A5PS7QRVWkE	_^ZYPbڋ_  f1 C5@:Rb`MR2 Zt $q
  tőSR suZDQS0P)(ǘK@5&= 0yRjSTU-W:VWXYMYY*]%h[[#O(ÐPMID[#D] $   gأ#$ $g6]XR ZRw A
 A ZÜW; _Üh @.83d f.;u	W 
߀	rh2[fXy3E& $4
zڴqffQQ2
QQQRWPH 0KfXR2Z0ff_fCXZp@"@ff/FslȈ䛊?jO1UR =fZff_ZÐ恁fPRl g +q7KK;rZk S 
S  S@ [@hSSSR	Q@Q `8QYÜ2C @@h  w `  b d #b)i fp3.Df .T
.d"rUA T'ZbR	F	{
r	.Dt fXZ
rM
TO<tu
D @@uw
DJGQ e8tqsu*cr Y~0QPWXr	8u
WP u5,XP	 "r%Wr "tr{Wjr "XQfu&2 Pv#t(SP?u$XP)rKru
 uKuXйW_ _3..QS  " "O ztGWrN " "r0t;Vt3Wr,Gt$Wr "r1p( "B/NKuй`u!Wr "dr
~ "sr'/Y@lo#s "RP*#s2Z6W _YQWs`)@8ťGr	zKuq_9P Q Ys% T@@MT@@ p0>gOO<Su=rjT[rbf١EuٷIrE8w8rXIP2XP2r+vG>@HrrvG% "r 謠DXu3`Ptu3S Q0;XY`[<ߢt<4Ⱐ[<uP<PPPǃ3艤PQWGGN蟤_YtXu5BSSpжuP;ZWPB_
t qoMnÀ`DBjt4`:uN`o0XX	Y u	n	3	u`wðpPXq^ðN<Zr,ZP2`N [S֠]`6_;w2XXXYf`		0uyt6P%2X dߖ O{@F 8t P DyDX ut!P%d Xtp.ueP dX P )P%dt:u@PXt0P^ i #u#P	kPA i 5  @ n
g8P
uu[XfaPpy	t_t2sA
RqghtuQQR_L s pqespqHXQru
~	bux \`0rsst@uhf?gIgt{ |ARNQ=QwQRڮdt	tQ߻;hQh.? t.;u.;Wt3!@^-'(+ ]c@ǂh߃^_OP{U5 W֒ ?o XGW  OA  σ@CT&F5Ď. W@)< `~<+ W
2$!SQ
t/+ '3߀t		ttuC9 cU *3h j ]aS3 A[/B$J .gSJ$
య42q	0﫰
50	zb 0W	
5
̿Ý0
Ȏq P@$/$@
J@=^v	@=vQ$?
úZ[wS+|`~۫IJS Q$p$0fP,(QT  P{cfX[S<S;s.:Guu.9R&$ZVWQPSN= NubwxЎ3f<8ATIuI 4ك4 t4D`#u*D.XD.Z.".#.>|P; [XY_^ PV
l<u2pc8uĊ^Xû..|.?tup.G# `~ ZYWVQlpZཌl,Y^_ÿ   SOUrs6 2iu lb. t[uAfoPsX`g'uYbbIhaa/b=d
ȿ$ p*ko5][3۩0   vрP! rXu22@t! $C Y0rtPLaW@ pa$aa쨟u1
 ع)$<t2
*آ
P
p$
`p|p0t$$ ޢ_$aߗqଠP ހ}0xc$
h$w
$
P$[4 R|1)&|x ҬRUD شa발bR1?$:awLiq~$q $@Z@w薓RSN%`'`"2[4$% 'A갭 ߤBQߢ!c0xPwQXPy赐R tj}kmukl{^^u^?_`@jFF	I3I+JF,F"FҨR<"yqrl%>PjkluQ/v3 ^{^n_^t
HtI7H"[F 16 $Upz	jR!R?S! "
 ؕ2ɲ Ē @j{vrR]$UIГ$
:쿲'$Py;$R&b #$P_
ĳ~R$4=(0$ ,1$(ӬQW2&d`F20x9Py< %
oMq@j
P?PP.R	tP X?RcNtGGFqr NjzhCjiiu	Py^Mn	2v	0x<&4\Pp&hnP]D\A(N
 d Py0xa*qnAdublgGh7hiA@juD-0nlC1/EFF{Uu"[[y[\Nx$ӬRW&I<#t=<2t9<3t5	 ߵ{ 	
SM[p_ѬfAPfX d.
$< d<t#<t<# < d < d <
 d ߋmeF* &E3uu u	FfF40 B8BY._f.EfP@B .GF4XH u܉F6XHf:f%  fF8fXEEf;`Df	F8Kme2..>7ڋFF4`?f_[(P !ea?E dSD[ d  Mu	 Q DMtR3ZF :C#PHF @DGFF
GP R{FG$`RF D	F@G 
G.M	̀

UVtV
ſFF	@
G	F	 R
F0GF DQGFG
F3F'F2F@FB DBB<B1@ QRF;%<t7<t3/ =@=
<t<tn2NAVB9CzFXBOdoef ghik/lOmono pqrt/uOvowx yz{}/~Ooh S(4f
   (fX[QH!, ĀuB  u*@@fDGtff.#Gf.Gf뺊mРuRuSC~
[.O.t	tItﰔqPIt$<0Ȳ2Y WB_@ n }Pd B `  	 ް R   p	 p p  00 0   ^{^^^Ûp`p<p1 "0I`0М0	 @KZPB  fPWQ2ɋYSQ2xY[SQt9/3.OɃ.;vpD2զ2Y[VS^-U5UtE*X~ QSfX PQ3@G YX fSf f%f[Ӌõgf[ F @ڋÐK
^_fX2QV23z.^= v8B} YRfPPfXfX`fPⶁ
ŠfXд<a  ѴoaᒷCֺ萾AQ2]P$?Xk"pPfQfR荱	O$8BP;%P᾿1$`i%[pX3Qf
BYfPPfPVa.w^2fXpþĝfZfYB&1u5f`C$PJafù Yf
(<tɊɭPWVRQ+&G
i`36 2Q!$@fX&2&YZ QR
FFbP$CfZYP:rSQR߹.
? I< Àtnt11tt"v02ǟtR` QYyv|@tp.Q
yYf.9VZY"SQV UwPO<``up It	-.Xvߊ"$o
Ypյx^ FRf± f.;T;vqvD :fg@wQjvef+бRvMK?v?Av2$v%vS%	r,w-ٟ{ZY0.WC D._ UNfV f^f@Gf.fff;rf@frx@Gf.Bٱ?^f;rLf/.0f;wff?+f'v
ACX.L9Q؋N]^tEt= r = r;.DP.wÃҰDB	[@:rp À wtQ:$Hw}^pwYܲV$T$QP8XY0AX0cS[$yg#ܲP%&O@t$&W7u t@a@n`"`HQZX" ZX P:RWۿPtݲHЊǯ_@ @`0Qf6fs BƠ薐 _E-0" PƸff0"
"#>#0""# j$P%9 f=  s{f'f_36&S$ 5 6](f6@$6;Ewf6P%ؾڲQڃp39Z71PPƻ5ft0:f||B  qۃSf4B\[%@Cø \Dw3`Hjðl +@KK;r02@S 
S  S@ [02hSSSR	Q7Q YQ2 Q@YÜ2C @`< 				  >  ޴>
U92kٲ[Y."D
$.
tcs] Cp %K2oF?/CDHհ0 > ]ز[&߈EaIP D@DBOX D~0I&DVDgBG&^Lو$^Ю&O1Ftf
^~opXf_Nn@;wP ٨[Xu;}`SfаظP٠а UbFF pW	T+=UU0
TUwUF00F+UrU	F?Ȋă/uX4J[q_n R%WX8}UF%z\X0v^PFf=￸$ؤ,fQ@f
 ZYf Ë؀~Àui΅ָ
tQ$<j۰`O$
R߲A HZ02 }A8A8,ooA8Po
QRc3ҹd  2R:(l.gZ[   (d
$tp  $$@!R
u{&41 *0) u.<tӲ.8n3Ý W߃ z1j[ ßWQRVS1Аjղ+$` 2@ WfuEдXf'ղ|P 3ဨ t	   |X` 2w2a]2I=P
@7_[^ZY_B(-:1 Ww2`ftu% t EfԞ%Yd{p B `Ó ա @ uZı 0p Vf^fPBo 	 v ƒAA?$W_  oz9ËË趿]à_"ϭr   VJӾy u ZX^.t6W+ӿ	ԣ_RԤ0VSߊ |;uq[^¥ҿsaҾ@}^(w 
1  3"LңV/胔@3 500QBw`X:pѲq7Ҩu3S葯Ѳ,Xq`  0Q  0%qҋ@GY PԂԝC3Ⱦ
 033 Xh l   Bp   & @*@LN  QRSUPػ
P$H8f0 ѲXP%
XX?!XUͰ[psQP ?t@ t@`t: -оQP@б]ѠP s!BX%ЯfXX2@R_څ1ps:s8  +.,G3E$>\F N(L.֋F2Ϳ2K ƌq\l߄K^ A呌
u3ɻ@p4ȵpNju"@amQpu	а R:p;$`?~Oβ)0$л 
舚tuaK_t  q 鿈VˋN8ċ<Kt
%$

_m@(铋wt	
ɀ0z~ܿx}@Z3݋ZCpۊ2~Jt7q2q?q0a`  ^tuͲ&$Po
PNa2ka qAYa   2 
Q}PXYP^8tuH DV%T$ vȰU$ 5t?-u0z/zT 	u @ UNw҉׉IЉ;f3.O>f.O%"߲$ (
tff f `f._O>uuh\rq
Fuq= Nu
_u .&'b
 ;Pu
5	<V1־p ׈
JňBƈߊJ鸈1(`t@0%$ 
"u`$`% jp uw mPp u`($m5p u/ʲ"+p2ˀu$+,pmp )pC-$pQ߀u3tFa(+  2ۣ*1u l$>1u7=q(,m
7 1*]1 ^qbNp o
ߣ*1}7ZXàS( P0D )/[XÀ@,8tBu=8S a[
tksE݊,FGG=%  D0zkU\2:1 I P L?ɻx1H#$yɁG"$xt%ߵfQ
fYfPfQ
肾LQ蕃Lȝ MkL@K
   MZrLQz p&f%gtP
%&ɸ|k qY`eȊ/ S ]MÐNQi3V
wL0W
ĐWø PSS SM   uF[p\-\mp\m!ZZG&F诮Ѧp`p\帔p\\ю师a~0\ ~P?f1Q:ȸMp\cUO[p\PfcG0]?] _ /0^p\'A!Z2_%${ø帕j akb丟a(Pj>ǶsihaaR6f@w~j 丕ek@p\@r @kin!Zl Jotpoap 3ItRZ8uR5
Z=RŲP x?XZ`?$0f! L. f.lPV#|л䠌Wq t bbR23Ұ
)uB
Z`..@] un> tgb2P>bP22AQJ2=QRP  32䣁ZYYy2 X aZYYR*8}2.8]ZàPm 2Ku2oW SQj[+2Ê2+ꐏ**&R  ZHuB$`JÜB J.6]ceH   `PQC3BBaaPQ YXaY=ԨuXÿ&NQ+.J8~ذ:]$0<0t<]:Jt. ÐS _r+}*2+ auX 0u*tX⑰ Py. 𕐤"㨀t0׊4"
Ê4"ð( пD $5m°݁  +ѥ,QVW++    U_^aYԊǊAдtb_ 8v2QY2P >ItP
RSߒ  PL[[ZRJ2ZË.b 03<?& t
uV Eñņ1?&JYZИ[1w2RąZL -ѝȴ aǋ
t
2&L ! >&}S`YU~ J<t
pA<Ut2[ð
6%ŀ2+Q++YZ+Ջ+Nu`$` t @ut|q Ҋ8~
td\8tX΀|I~D*
8t8 t2
8~
~v}tɊ*Ŵ
RQVW3ۋos@K 0_ QtP  _^Y@ Z^QR4`$G  ZYËxs_ 	r 2B	 PO脊=pffIhfƔL/ӲS[F fWfVfRfPb9fО`+Ɗ2BVZf^f_SRPǺ@fZ2f@[wpNБwy} o&I6w%$ƃ|t;@_v[`ovI鞃袭R"Z~ R@XR3Ѡ:twF P+>Ā"+Zh䂱toV	#+2㲂r~|@4ߋ&  F适  +u &F E&  qP 1+>2u	&}uƀtGVW_^t!3ut
>| 2pQ݁|u\ρwta? `rq`u
oQ@q6JX 2BƱ#GS
Ow 2@
pFf0"Ku["31~|AyX@[Ё u龀G鷀Pr>FX$6| 62 tm߰UP؊P0u)#ë`4&N>Xz ?}41{6  P5O 3Àt!&0Y:75? 6$ &@5O:&; 8r2Ê0⿋2/ЋR$aJp 0PXWQP͵suXY_>{Q I@DY+It";nF_v/Fov
 $ _u　PoP[О.XƋ`"Vي1|pF9umdXPRJWQQWC_G?8v
0EG Y_Ќ0[KZO&%_G+B;v
pEP` còθA/#!_oҠ1K@XL%MRWQRQWP8tXoPӃp&$CX_YFZ Y_Z@D]EoUVX/YOZd[;[@OG\U\]^c^>ct }
}>
u&fj3 f 3f$߀ l
||SP
߃ 0t&ۈ@p p&]X9h @ QqGpĀPԕ
`0*'0|sP&|طa@8]Ma% 0Ҋ%%T{URQz@T^
X&{t
!*۾c{s-{y T2"0'}~l{}yp`Q~>b2PI<
vL5@֊ǪA8sZzs*t u2<
u:6u Ɖz<uz<u
t22+tM++&eP>?ː.czy~2NzB.ۉ~v2 O03Ɋaʰ'uF yyIPJ8buy~4AJ``NVyb$
IB0(!Q̊.`ot.;t$.
DYb^]y#+3*2d!d"<PR3iZXt
ht
1y~hu<s0.ڪFkttpp)FO]tÆ`p&x|+p&}僬 32 `t밀w00$&e߀ te ò?PpNsQб2ĜBP~JGPP~/^ xQ&5&m&M CYw
u³$!m0WPücu4 8w@p vwտ &5&0MŻwwtn10p`w}4 0 `^뒑 ,1pT 'wot1p9 c1p.@P;PY0˱d2|XR~ ZSwsJB D? [Z SBB  #ȊPSfQf t^$t"a$2t t=fIuRvѱt%wu?tfY[X$ .խu׮<t
 u!QPzu<wPSPRb@1'n@	e0ѐa@=s=s=|s^=Js >ZXj[XI'<t<t~ppS&[Hu'tp>pBpF1u.| ~ &uȎʠ2..u 
*9 Խ<-[O5б
up銰w5wv@jİ& u͎..PEI.0FF tO5<-<o1<5OPS[gx&G&g3t!<}!<}Pô<t
<̀
&G߆20K T `T֋P$'"3ҹ <u{@P' X Q`i 
P"uÀu
&~LB@S3[t (22QpF t  +YuPW>&}t0&<t$8tGpȢ&Eހ!_X 3ta_tu0G80u&2} a1b̠jtp$
J	%Ǌȋ>hPu	@tHవa`,& L2O5t
<t<t F`J!s>=&]&M&U&E
ȝP0@bX	}2!PSQR.@]t	B0߷Za<|qSHQ J ,5[VQS&F E<
B@<
t2Bd `\' t&^ E	prs-PBl p	t2 SU][)X[YZ u: up`ygp~P^Fp<u	C.p.:r2.]@jÆà$0<0tu 3tq0
2.;t48~û{ C 3it@6m# `2V8Ҡ8t`2: P;;: < P=  ? Q=    ;=Q=@ARS*$Z.$SQߴSQp0Y[f.
uY0庨Xu	f.>  fCf.ƱDt
uPDqR(2ݪ 
ɐtxZp؋ .(2.OA.WBP tW+A_t;rÀtIN`P@
u_bB.@Ɇċȸ 3  u,Jtt@|$Q
4tu?Mp2@_
uJ}pJQXЀ@_

@ 0W}PG@[ZPQVWS.>Nt .T\Tuxo.н޺RUk@pP 3f<8ATIu? 7p%2QRS$<u `x<2[ZY> cY.ɰɿ.!Ij@[_^Yp,Ŵ 
XÜf`PSZYsOtytrS!I%{ IfP=ק[3W)ifk0fiZPjHPk
l	kPk\	f߹  lPkr fa`CfP2ɻ| fPfRk`r>kOPm!rk>0ttf h *tͧ_FCruut@^+(v:2 $
quXs zr z֦q zWfXQES.= t.;u.;]t3pHW6uRk  W:.epD <t<<t8<t4<t0<t< u0P@/6=@uuX5
X
 =u
¥_J@E=@Xx ^}Uw Р @jPmm @{wj X-- /   R~Xpu'P=u_!j3HΥPj$u|$!I$ f u$F pX菥$u  p ua$ ffo輤pWRW PW .? t.9u.9Wu.G2tD2ܻ2E_S!8.Ɋ
ܟ!3b[ÑaHa'cû ȧԗpA}WtD3PRY$ZnpRH%rf`fRY t3t+t#@t.tpt\t %ff%fP@~f$<t$f- < tf+ pf
 f2) ffffZfYf[V r`Ѱ2ȴ2f3.Df3ɋ% fPf@.PL_ P
P!"f{f f2  QXff;t9`;fX!Ͽ"+"`
S
ⴽ@b0? m``׿^'¿C00西.^(о蚿蕿萿܋1D芿E腿FG{.F*.~/ pgط Հtttt	t3.)$ ߿C	`  b ߷R⾁fX^    q  + ͐ = KC @αFRluu	 .F3HA /H_fXWf	[E^.~0@

0ـ	аtfP¿0ָ4葡`U = 8聂arfP HfPRQku@PxS3HܑHgxXPo.︐$ 	$	,"L@GFT߱R Xϴ\`#fju u8 Ptqt= }\ E~ p6P
uu
~BXTAtY]IUBE M<~	<%@ Ytq Y}ZHRSfPWL.E_fX[Zߝ4bF
 <}F; A=(P=;; >`֯ A`r  )܌88 )I? C
fЮQP;<t%'<tO@׿ǵP
 $0_ʞE!H ҰN
f
  pF-f詜Ppw	 f.{tc^܈T uEff
@ Sf% ~tv w ;x  [ܐ|	A_ZY^FRVW>EVа p3ಃ.;s& ?.\?ËQ O^ o L.bL.2J0&>G_^5ސLSD0[	% JۃP+("| fқ I#"dIа'3S""E蛛 "8 t&ƛ@螜aE0u{X0SGPPS2h
~!~RPVJX,,-AfW+&Gp ffÑtf.#&f߃!I}PPj3۹Z#fC IXКfb! 	!/WfVw0f.p1
f!I73408{4e衚Xjf^[H  $,48<DLPTX\`dhlptx|  ;PQ  _  ? c$
k*6
mc8*?1 d
  
 !F!armG@^#
"  0 @ B  
I @ .ޑ&yIϯEJ>KEIܿLJJ @ N-K_ IPm$ j8QhKEI&OIJRKT"IcXV, - Y- =pK"IPPP y5 K%^#~&LOJP^^O`ē^sRRfVS[H8#aР@UȆUI:WgK%I#VMFXj RN"I ؏7l	A# wE9W`n~"I [7lF+  /p-"Ivk{Y`Z[PZz /Bmno"pwyp ~ B+ 1b@ : IR# ToG~rH(+ hK#;U(,4PTcÃCPT PgPUjcacH-'!.p]hA,=.PUC
剁^O^] a`UՉ gӋЉcjыHaHf_ E҈EёWЅP4V   $TV N Ob{PWV@$  S[^
P-B؎?< u+~?PVf 3蹛^[`  N g?f=PzPV?Wf=P P#6?؃  M?=	wIu;/?(?=@ru!0ι ?S`UӋ=[<wqȎ؋t|PP봨AĀP@P(녨t{2>_fY`,  ?_-d Px@ PSRR $PR
XtuZ!0+RP$!"
XQ$角F$ߚK'P쑲- ݑ' 0 >/Q: 
tRPrt0t 	臑 XZ5WPX2 t3ɿ#;t8t_;P33 t=%$@Њ$0Ћʊ$!ŊĴ!$2<u	ᤌ= < G= }90W00<}s}f<RذJ蹰<q
.<$<$
ă1 `Ӏv<1uXü4 Q *@cd @A &06cL 0  A  0`Eנ  1X (E 0XB g8xVAVA PE	 -`N ((7 @D6@a2@UQW]_YuE۴0+A葟t `, AǐQ$ÿR-Ay$Tt$@$0>!	ƎTd
$%t[K&o:ُp/7C(>l!$m윏a,ֲ䌏 3* uAt$ʎil1dӏ($L$袎_茞;S*4p2Rmи *-贍# B-`-q$a%rbar t
tAݎpA~pԍp 6tGF2;r,!!WF`%FV_!R B0 Z!8`8ðA
Ͳ
	A
Ӷ8P
A
蹦"
	A
	 
?
@

y8mA
f
].A

V
1|p$ό`,jWa  (ZP!hToXss\HHxڌ$eX_[U᮲FP;s I7  RFNP'uڃ?^
[F b7@2FF
VFً ?P'7XӀ
á"YoIN  Y  ^HF6"FVЉVW%6$&&]V6 F  F^-9F$vp(Ffp簰F@0f8f "i6@,#F.1%GE+&F	Fp0}0"(%1Fs `.!*色3K+FPQR,$` 9
Ⱥ$?
ZYafSU ]fp pqff@d>]2=] M>$
ا>@98W?@ !>kW?@`>`E]@
4F~@8E  P zfĜcB$J&eL`M

 ML!N
 M^`ML`MWpP	L#Q P`MsK D%= vG$2U*@3°:׌ڰV%? pWVT T@f3 P>3ҹ ȋIXA;r3	ҥUX;v;tq\\2ƥXPQ ɥ\
2YX  tYZuaV5VfI}YZIXaafQffffY[f0\v`@ab  f_WTbf^RfP{?r1>fXےZhǆDdi 'j` $t 薆! @øN = Nt+
詇$pg螇$pq.<  <3f<8ATIu 2؃? u2 {PV࿾s׬	8uĊ^02໮.PsۗsMBt؋7t .& t._&@.?tǐ|?.Et!~ECCߠV[fStP`(踦.]1f ..M0T@XOf[^ |fp~9
ȲR0
̻g$
軅.E6蹅fqp$
M$`D$.e9~Q葅Wǀ}=p~	_X.]9t"=f"	=%f	}&Wfa}c蛠e$p8ސᄣ襅 QF>=p%
Ĳ0=2..71oou0fM>f%r%u

m!opo2Q
)
,
?2܄ 2pmu!腃3nxm
  N  0u  t < RNZ {Qnb'Qq׀	%bR$ZW |.E#_F@_VQ;tX $f%I%f=-  t*f=2A"荠f;ût>
 `ŀ~ KΊY^pQ!f=  _	 Ў$}ق R} 3_FLqiku耰镂*SByBQRR$ $4

[ZuА8?m 2Wǰt.m 辟ᄵ} m@aM,t葃u_D$opڂø$s~@	译a}4 t&@큱dt%${6t`hCpkX-R쁰BʁL0<f``\舐1IF"F a`iz׋F-+jDdF&2$P[n AD19>1/Q,9&[9uLF) D$
F)藀
F逻T UP 0fF4Ӏ 08ɀlfpF7t pF;5݀1Xf_FB@0舀tF'F(vF2Sf30W^_20Y[u3ۃ` 0uGL f f" LJ$
ff`Q
fﰯf
fRJ$1
f	f\
f̀ff"臎CRmpj;Z1To419.}9K7ֶ4c؇~ؒK~A|f~~۸~[ݑ1fX~[y~Yg1H~aMmЙw俢WUD 2F E]u:u Ju	FfǫF4  	8Q	_Y._Po .G)4X`%H|1u"6{XHЩf0X fF8fX:rf; Pf	 x2仩t..>7ڋFF}$u@|#_3vQ	4   @DO
ɑ:""
;W|g}.Et.;
u
.;Uu3_84pQ;5pGtSS2~t	P
RE_.PT!  P
TF"F2N(̀@!N}(TFz 'g!'N'T+_$fFQ Of`fPa!N)`!Fః
F$0'2.O$F&FA&%HF+0%`
f_fP *?F-F*q
+.oN3P.G$ 
Xn *q"*Faf	f	)-B.2ޣ.@/nU *+"P+Q/80*%-  ub 0$F1fF諿 N)&? n1f1XRy  PF,p*0'f..g0';Fx<O;@c<F=;F5=G	P01@$0{@
F0.`1 F1,
+B4B.p3fpB;fqEm*EGp3(2n;%;
; >SGn/
`4;If/fs8	B np+`N2AVBp  F.  | tZՈtU1
F:D6t_
#b~Aـ̙A
2WH~2
	F2_U:	6T	22 u(7Q: a2 8@C F H K L U Z d x     ( xa	ੰwSt$^cEQ]PFtP1
F u	F=7^~.Fgf. Twi/yhfQi"bNwn..Mf0{
dp_x`WF	apxbhfK^
kh@ҭhFgՑhhPwhd c hF6 cY#o2fVA'x9H5]wm$hXf^ˊ߃0ٸ4h^s"d~/t8wc^ w f^ wPF =$w,{`@ z)t
m}pua\蘅ZY1ȎؿD	DfD EeЊ]}$@.ILDu'uDڃ++І؊}Ё@@%??8DdCEeEÉDE	RڃDEeԁ}HDL+S2]Ë؃w㰋$  +ĈD\\[ˊE
/P2ȉL q0D3D< vRD҃<@`$PwX;&D!#Q	ËЋȉD)&뱊'Ep32~кD(D*&>@D+)-D`D0D.E`k؋4#\1\/ЉT23 ]PHt'@P ЍHD;XD5 p@^@ӫ@X ?^ЬЀ@ XP  Px@߰P  Samsung LTN150P1-L02   
 AQ	  H }  !@Rl L  "0Tn0F"d`U Vf3ɹ ҋy^
uyЎ؎fЕudf| uZft;# =	wIu 3t|pߨ~a֨ p¿2qĀ ]Y`UG1 a	 v Pep
E;$E;X e9= vU93Ƀ= t(9w$= u9EwAEoE ӋA@~ ̀} u7 pEDEDSQWV^_Y[| 7 {?Й.|& t.|&ù`vDDMmpdMmq2]a$@VWVS 2 3н8ATItF[ ؋7[tFA֐&G^±
±  .R u = uDu

 ڹ  _^VwQfS
ݿ
Rff;uf[.Y^ûp0uo Sp%oQ3 0Yc}4 _t_o0>oo$3ۊS  0ƌp0Q뻌3
譌ao
ao
[a'ocE3_e4_ÀӿQ+EȻo n}p En0nnyo#˂fPVWSupЋ$p%0輋*B?,觋D0q .D15.}4u
'+Z 01
 g2Tt._1@6 +s 蔋}&3|`EE.e0?3Pp[_^S w [ 
tq$22oÐrM10 OEM INFO 	/O
o /Oo /Oo !" #$&/'O(o)*+ ,-//0O1o234 568/9O:o;<= >?A/BOCoDEF GHJ/KOLoMNO PQS/TOUoVWXYZ\/]2  1COD  P h$"h_hS@.g[.Vgo.g~$!i1`h$gahfD) b1INI??SQP2.N= NXu2˃	w,.'
t #pfghЁpfu.&:0жr l?m_nopqrs u?v_wxyz{| ~?_߄ ?_ߍ ?_ߖ ?_ߟ ?_ߨ ?_߱ ?_ߺ ?_ ?_ɟʿ ?_ҟӿ ?_۟ܿ ?_ ?_ ?_?8^]$4]_ ?	_

1600x1200 @  
 BR^ H }kv`k! 'R^={H   O=: <E
 Na p^A_   !!0 3Q0`a^ OD w P P`a^X   |a! k XVV%hAa^0a@(= xr&`]*** *+* fw*`+*݈*!*I  *PX1&*w/*m۶1%S1""cM$[
u ` 8A]$
  R7($p^a!"*OU  L  'H`aTa//D)a))%2 21	Z @dM>a^@  U'?
>$ Hd%@Q5qAD< `4`??A 0$w M`;LL 0E&Q&
11 
1(a^1IO11:
P(5}@E   '-a^F  
%$@l%   1$N   Q o PQP QRQR L1R`SR@E
P(H <0[-`72`7aUUB"QBQTmA -5PCp  0"uu- _0 # $ o`  2 2   \2\2\2 ^] %Ta(a(u_u_u_1$Q <_ *a(cecec&Rcba1e_`u_a   !*4c*c*rd*&*e(H?%H?a\
Ao!?!" #$&?'_(s)@*p/+O,o-.UP0`/012C_3P4567de88 :?;_<=>?@A C?D_EFGHI? L?M_NOPQRSU?V_WXYZ d[\]^_a  "obcde%f fghj?k_lmno!qrt?u_v w(yz{}./ 3߃78 ߌ?_ ߕ? ߞ?_ ߧoZ?_>t  ?_ a߳Oeof?_߼p/ǂL"Ooʏ˯͈{F_/OoՏ, /Ooݏޯ /Oo /Oo/Oo ,?_  ?_	 

oo? _O? _ "?# _$%()+?, _-./0124?5 _678o:;=?> _?@ABCDF?G _HJKMO?P _QRSo\UVX?Y _Z[\]{` b/cOdoefhi k/lopqr t/u&'xyz{ }/~Ooσ /Oό /Ooϕ IOoϞ /Oϧ /Oo+_@߲?gp_ /mOn?_ ÿ/vOw?_ ˟̿?_ ԟտ??_ ݟ޿?_ /L?_ ?_^  !
OQQ  ? c$
k*6
mc8*1O

 !V!rlW@^#
"   	A     
I .@&yYUZ>[[EY\ZJ @ ^-X"YK]m`#$ j8awh[Y&_YZR[d`b="Ycgf, - Y- = "YP`Z y5%~:^#~&\)_Z:n_pnsbffc_[H8#qpn"@eۆeY:gw[Y#f]F|Xz bN"Y ؏7|	0# wE9g@`~"Y [7|F+  /À @h-"Yvk{i`j[Pjz P bBm~"y    B+ 1r@ : IR?# doW𿎉AX(+ h[#we(,4anPTcqÓCPT PwP=UzclacX-'!.p]h[A,{.PeC
an^O] q`Uՙ wӛЙ czћH1fanA_EҘEѡvWЕP4V RX`$1
w*
OS"|2T1CT !@"ũ"0"MWXAXpAˈl
ڀZmb6mu[AĬTo^ _sF `rw  Zt`aY[ b@b 	verU4j(|
Z]bma"h= ڛr	& G?X4 aBk9k` ѯZ:HkbnA+Ĭ@įɱ.qAOm<tŰƺwD~ Z`oT[˩XϹ}q`~m~H.7|54ZˀmLΑT@`~⬌j7|,z% Q6|PBo-⬿b{67|rཌྷ J5' !Pb<Ӭ- &y5_ܑo@3ھhh(֟,` {7݂
 )e ] ) kؐxЖÑ姒0悓VbWCW"A2zcX.P2w.0崁[/p.eq.an$ 0juqbwouzS*3ncPV'WPSo"qRPS?
uSS).TUW7X XLxZjQmW[%N  /%^"_#]#saBb'c dG\dȄ !/nZ~g"h9h yOi`jцjk 3 oqm  C[q9
tuKu dS4ww "x3
z
 Ԁbb~@# B˜no`jWA# ^& ⊲AMuJR2?3?5_6 -c'eOo+. q%,ә0U?VAUR@ Ţ0UA\CzDV$_C}D`<>%<  1  L!    fSfQfVfWf   ff2ff߃ʓff3 7thf;|uf;Du7fs30f\0fyffÀ32 ;Tuff_f^fYf[	!)o
 /Oob &	  4(` obGb૔ yuJL2ŭޮȧnNLdSlQKlE8?H[~U
dc1(S >||5.)a{hTuz[3:Y%7zv8n̰5MǢ}=KK[lO- CEVW R 蝔QtmܝIځu乧&s=ڍ .h~%rc9-8ua.<WreωQ>^AW|e@K"kK-	a"Ǜ>_̷2T҅1`ak&>;&.z{4415-V׭ l8bQcк+7&V'*yi	AI5ގ~	rQfDI-e)}v1/v@cm=/.;(mٱ>
J4OKN`.'f3ސqM%>-Zs>gp¼/^b_b
<*`r-j6OYS  [(*SJE(<SsVuU$r#X2~4.v&s-I3 iv1/1%ڜeB_-SK=@|3h%Wb>t\"u|6.L{W/&ݚ[&eab#A= rTq	>Rs.ܧ(6b|^#
5
oV:sp%\R<n,AGK 6n2u@7QmIc/sϴDM d=>͇
΁Z;b&U57>eʈg (z"a 8W׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eS
-Gc#('S)\S:s~deߛ&{޳]uTLemdF|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthEPbcIFt1vT"|} Pa>c(^)|'6CrT[Jy-Awg(^&1>G?D&W,ҷEVrfz*UqF;%d%Ev4\ω7,7C3KS4.HɸaD)c%O?+Ǌj&j(@GNpQрOXNqKa
Ԍ02S<{{D&/	5e	mduNto@mbMɡ{WN_ƭd\?*]n"P1 ywvj: TY,(.TjLy}Rs bL43E
䎫j,ƭ<Ǵ2+vAt|3o;n6}70+=辸iG,N@g!CVO(:5o ]]`c:=cވ{>Oۨyh)U?ZH-9@FAnr'Д/K!t_3/Zg?5bmR!`
9YG&$iV3P#Dֺe2HRk]>
xQgH]<C6<<g7zwɽ)$@$^ :Dǉ/' ZOVAliB-Zfa+y\*Af;
 }hw$;43B"qdV)]VH11s.4]F TJ/{- ~V&xm }
oל%adE}sg39Vmr`d;Ze]$y+U6~%y-	+|AX6RT[Mf+L*ޘRnhBYZ[\^ /_O`oabcdeg /hOiojklmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ/Oo͚P  "Ptm4Ϝgf~94R8Dsx^A`96b@kpgs9S\})(d<f*̛(m:FW:9DT!zcUDh
^3,\
8f	߈|	*Jn̄2CC~pF[>%/\tVyGۯ*7$ AkoxLŕ[Z\J	|Э0a!QQׅa_FH8qa]Oۂu秈]|xڵd|$SN(Et+3׫[]bKY/n<;ѧ҄Wkz㫷
Yvdo%9fmTL	nIxƼ29MEi!jJ-r%vx~
mwǖ)fL"^g{[AUOP(IcKۆ^Va_;2ŷSh)`cm'dN5~ù+8a!"LF{M#,뷿Bh.6DR
{h;M/cTDގ7գLloŤة2χn]*ѡ8CL/g1+f3#i%co Bvl7_BEt.Zx~i$/ftW
P/64hFC	%! G Q2;( аrY2/nxs^)4흥 94JIn8-z9N/fj۽_pz}[;bï"8?9;U	NZK;#7-omٯ /Oo /Oo /Oo /Oo  /Oo	 /O
o/Oo		P!}geoGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:׃FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋏYZ[\^ /_O`oabcdeg /hOiojklmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ@/Oo͚қPGϜg
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4҉;jQ0\K15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwyꤎkK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]hÔ9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC UEu;iTBܐx/Dz1J8pQ?h
\Q	L
mvfCG=;kٯ/ Oo/ Oo/ Oo/ Oo / Oo	/ O
o/Oo@ P&lge<sQTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuupW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3IYZ[\^ /_O`oabcdeg /hOiojklmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ /Ooɚc     t     G  T  ^TI{ jP  RI  oIB W v D } O  1BW 1D  PIBmWbDaoOB QWDCDM!MD ?#ME 
%F h&S bQM{ QC !'K (U  j*R  |DR 
SR 
CR 
B  BLP BC BE BD pTS 6.TC PRS .H  /?sDBG,0WIN[0OP *0GCR-)SDLG` > ^ Error
  ?_  0B2  Press Enter to continue  (CTRL-Z!abort) ? _!NEAX N" "L   OA` B  C{B$JEC"JP% %#K{C$FED"F' P'#GD$EB"@$!#6ESI 6) 2&)2݀* :(P w:P
 >)+>P, REI+R0- VCS0#0Dr..)0#,S.w*F.(G.ZF#a!rDR0 v@11 z@12 ~@13 @14 {@15 @16 @170^KCa1f 5P2j 52n 503a!"X#`7#b$3%Q% 9#&c'`p:8(@8!#
)
***	`;+	+l@<+,"---c.ͪ.C/ݳ/#00ŀGDT ɀICLCT
!5pE23~W4NN a!wBSGJXGF]
a!6bG2gG:{lGZ0KIV:a!R  G,4M>M0qG.uO*yO(}ILIa!"= (SCSDSSIT!UBP= D]ST= F VG VCS:IUSS:@,SFLAVVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=GvB$[zG$[~LIQ$[V$[[$[`]eb!p$[x$``QP1UR1b2b3b4b5b6b7VCLimit= , Base=!1Dte^$[f$[j$[nb5Vach51jdvG%HHVI
JMJ	@KIٖOU6PPvQMMVNryKIŀGɀtuOQ!Vegh^f_la!C= 0D= D= TR=kl!{{P}/}  ~  0>  | ߄?_ ߍo}~π** Divide e Invalid opcodeNMI (previous instruction)Break on SMIDebug hotkey ssedSdrg invoked via callPOST tab}lntry Tracepoint
 							

*
?
EXEC WRITE`RP  _ACCEQ/A! A BY2ORD
Dpª𛥭MONLY î NO?TRACE `{0# Disd _RealMOnlyEn"B#NO  INT3sP`"OT TEMP  OFFONeISABL ENR LOC#  SERI#f CONSOpRE20cc ս CP@
@sCT!Ҧ A]LLIõyo\oǏȯ0`Ȏ؎.V0| 5 tU0̓͆P>t:o$>U.#uG6J557 ѿqs
G{7} uVRό4"$r;s3|7۰$ 2 PSQRp.c(f._f.f@٭Ujٱnٵr
u, t$.t@N u% ;t	.^ /uϞPӵPCrt..9Vt!pc.툑!wv   a{ 0ֳurotib aa
uj. .>_P0u+.^t
u3t-t._ ;C 3u'߀u2_".  s0d&Q.ZY[XfP.^_afP`r"{>t"e"
w B$? 8 b ",  %" L faù   Ptu
D>=4 u	0rhN
	 :tw%3t3sT4= fPf0Ka}p	bҍ6U<uf.R=fu<=upfffDf.0
?f.rސRfCf.a./c .3Ӎ!>/d  /Ϲd  Ϡuf366p;ZY{f[PSVW< t"<\u
<nuF=3<~u s2*3_^@PS>:FsI>%=s@>a4s7>(r;< u<<<u2B
VM5'2^@  CyclesAf(uSec= ) ???fQfRVϨ u\@ًaڋۋr611ftf+fxvfu	61ff331f.x082^fZf .{݁Z<@ &Z֍J PQt0ϋc 2r	12tYQ 
#2'|##	 y2s
11t菟4r_^%W<;t=@"  ?@ $3s?v4u1rw$0.Ws_"1tT!I4u}1uP	
C=34u2r:f{ s2U1t 2r#D06
rQ0b ] 3 
4 5  1t-*3ur2r,D0$0t
>r.d. a г3Q@X\@	Pt5.R.;Iuf.;KtU\P06XR	r n6S p
ft<guX<t<t<ͳuL@	04t	.TS 34@"@1s1`/@?0֗Í:oG FFsG1G%5HUsGGa5HH Ñ/tI.> rI/rD/0 H0r5} ufǿu%$NNufP
ܠG RPpMSe [R6[SSQSSzG[b׋ߺ*a*/0s+"@%u/|-/--.(fpװ *\fW7O-@	ffGGt
S_9 [Vw2#-^f;t]-wߗ-G
-
PYfVEf3Ѐ?t-#.fGfsGbs,c fSXMemory, I/O andbqRs must use hardwarexf (0-3 ->Yr#-8]..N>Fr-=.뢙 l6`llmrD	{v m k-t.r__j@ k rk.՛k l@". f $- Gt >i
 r߈G 5  /! , u
0v G}pw WQr{W\
f\GG ,r u6@	P.O>
 rGGvs',tjd r#_Gzt |6f*3QM,r0fu!0P<upт0yQPY)U*c*i0_V	b- r' %3 `0P0͙R G+r2}tn  0SrS͓Gi]r
+r:1rlGQr+r$sm1r\+r 훱R .+P,rqss
6-u!+u PXYiP²
 fries_numb0 PQS ҈36(@	џτQ t"(6(.'))%BP#     0ype= Length= Bas rByt Trac YVW*   F(()u1?G`l!t )6o"(d@_u`  0({uJ 
Gw>  }'fGnat;)[	(GO(:
N(]0&)(P%=8E}	  Ѹ'(BhalPdy active. Do you wahto repl ihY/N)? "RVWU@	 t*@	.b 6[ w  rwfbGff.!!Y}t 	P}bOff3
G
G!3{q΢]_^S`pW؍ 2pFr{_rWS*
qg7 sp &Q q߈Ys<s8f Lf
u b1a`fSofthnoސvaila.
nrG w`w
tBtq u
*D u+*@_T r@	]; u629%P>&	XQU#_v`1V6@
 5|t/fTf TCC[./D.PGIuQG^` 4.D9Ou.Sq3)A -!{a`0  &	>VWQ Y^_.?@a`2 R_ *C={	f9Ou w.s ss݀PXa! ۶Cʄ
`".&^Q@L$ ù  o   P06.E..F 5 rGpGG0A$r8Ȱ|5f}{o##/O# = ~M#CP$39:0 r,pG;5@$tޒ	r0=G$r
13W$ts
 u	rcf=  w[3T}%rR  LwJ#tCi%r>psw8#t.T%r)psw#
؀#r#t_6%rQ_L Bu0, Devi, Fun@on= 
 tx0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** Errorading from PCI
 !  !#t+%tC #t6% #  pC  uR? +3ۂ!E!FfpCA!LT[s2!.!]Et.. pTp vt`[ p
#C vq#`4<ra
 a3~3U^Nx ~@v  ^xaAr
u!! @ !°!1 !B;Vr蓅!aWQU -  6 ! $s+ `,$/e XL.:I/.l0
 A0hsu0hU9!u0<# ;# fС"D4u
4@L) ;"#f.##@46`3`85vf`306 E_"f0z"CB-.99ud>p/u/ xt- =6)8w.#
t0 +)+# 3"qR36#..VW."@sp36f=qs^W7?s6E$k  >#󪔲2`[7(.# .PACr!2A&DD67@JJ/ |0n3$6p3$
4! 30q:."  9%9:"j/'ÿ] VW> %_rh< u
pV}@V @WtQ: EψqX@ +r6%&Gf."p$p$rS" .Rs9:}lBC^@
c65EIO"uPFoufat physical address  NPfxbԐ! ð#srk SOS2;tf8x&ps u2pu6;&>p3~rV&}%j~l6 }eh;.MemoްcompQsu;cccfulԀ_'0v7hx@4&p3|r m*!iip quf6']p7?f@g@p3z'j#w|wvwtfHtrh}@.y'lQrp5tgT4t[|tYrTQ
 `35Bg8xfqS vg{|l r^}U~I3ɍ>tA<'tZ"uج@(8t$ s&At!_TrptChecksum= k r[}3~Fsfghw> (wj[p3~=Np5l4tvv rqQ!Rt]T rp+`\rF2w"I<Lu4Fd r|84v.*#t5@]SWfl>r<:ufF	+rfF>	 r[SRir$r%} u`
frZ[p?.Ϣd3<*p3>*!Ds<$煩  3 .RՀƓVQ.04*lB* uV pKJ.B*?ro0*wH4* P2zr& E@ r..*k.8>*_#9 v~	!vD*9Fpp3!8*`4F* sQ`SASШ>:@6<U<q SFHpހR>J*=.6H* 3Ѩ0GJ* k@\DoH*?F*`.498*w
.B*D*NiIܒ̋D>0t %@  .;puf.;u>-(sMQ.l.f`,@4u ~ǀ g tPR»uIJ9t3..>ֿE.pV4m=!'"ï0 S 7 I.;Kt2%IKf`p;R3;	=>S@ԡK.,6S 3׉򥀱.,ޣ<`@\RFX@W@\۠ aCPU Time Stamp display= Speed= Must set s to ena_ble tPsP1BtJPr	d`}=@h.v&u&>rN@<uF`4v .{2.~ ,-n.6-YP$v3CӋBcbter =   uSec t
r!qh6o.xp.Í>'rtGSrS `<t.&Nt#>/r/.< u8t">r.r
u
#&
* T7argis@rt. Rs manually ifQfails6i/WMQI ˆ9^V6'~F A`!u`e@66 ^PQW> %>U s_YXLt,[r`@10Ur.J b׿ u`.& $rL2w,<r(.0Ur ߵ*s	 b@ 0@&
mkw
 u	1pW	.M"M}#rp.ݭPpMfQ__NPSٜp?ɝ`5P`FAaz· kAa"51
 1
 ?W.h
@i&(a
M̳zE"10sv$:% u0% M	gø6C	>phr6>niSn;;K;I;;**+o-?._/ 012346?7_8 9:;<=??@_A BCDEFH?I_J KLMNOQ?R_S TUVWXZ?[_\ ]^_`ac?d_e fghijl?m_n opqrsu?v_w xyz{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨЀ2g22Ѭ}[pW>2!2 t>6p_W} v	 EAC r3ۉ_P_rS t]AMw][P_)P٭
ЭPX
2t^𭢱2ѭ<w.2ؓ2 [SZrı`P  ( 1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?j_`!?`	3f<u.3<xZ.3<Q<
23< E<
u.2<.:7<u 4 0<s+.2<" &8<1<rÁTapu<<up08<.:X "3>0.?>2<:A$w4<.5b>؊5<t ˀu 8or6<7<[ø.1<.&2<@.=<X`E݊7<.*6< v&.6<#& Laz*3<S
.#!ԃS$3݊0<aR2< # ϊŴ* # 译K`
 a	AR.9<
 Z;<ZÆwBB5PV~^QR 3du t񰰱l`$<6t<*tPu.A<

y"A<
x<Cwp.A "B<<ڛt
ArZwG ZYA2
 d0 R7 r  dI r`.@<@r` d`Z	 .@<`a Qpt
QhGv Yuu#s3s`8umPf`8<!O W !Fq@ &} tC	t;k0ta3	h &t&E
 ظ@	 P ^ X @Wu-  ~pfaq`tQ"OA _ Yf`RW.OA.1Aw#.U! 	tff.PAƽ.TAʡ_PfXOAu.UAU.TA讽_f.PA+KdKK|JJJ9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH"r.A$$$AP <t<t<
SQVWێA<t<wPXrs<vA.A>A &_^Y$$$AQ Y8t	( PVtu@I0
<
t X2Qt .Qȵ$0<:|up06ff6PffXV/pϭo
p0^Vf38
9f^ << f`3Qߜf
p  >COCrf0f3ftYP0C++x@2 fa%

 CCR3 ۽CPE1< tN< XÀFu'Vu@߬<0r/<Zw<As<9wA;t^<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3! o!.SVW31rKt	s<<t<p; <w
t+&<Ru	& u@R< r KA< u4 _KPP0PECPEOI CN ۩ C1SQWU3t!;wOQ
G:Yu
;t} tۋG]_,rf s ZYf% r}s`^ r
<:uft_]Wf33ɋ1 r	f
ANLS:R ufP0wHa^<fwK,W<Fw7<Ae7JI,0@]WfU:af>fP3 fX`bfAN0\ u3d
df] Aef^a<'u"PS<'t	Ab3dk"eNt<Yt
<NtNP3t8tNX':*򮿋HH,
uÊGvO 7ÀM=GCp2PVWuu w_U "$$Jy$?y$4y$)y$y$jy$yAqA`T P G WIN HHHHHU$<w%.HGu~xt;wxߤȰ
r3Y]Kxff   `HB8uĀuBJu*@u
 ktgB$J E@tgB/AJ
 S70Zfb0z$ (u#QgpJ BJQB 1䅨@a SR1bNZ r. $0P@0m rPrfЊ  bH t$<+xbH+
JE$<u	f pgcHB칝1`h&Bu"J Cх J g` t t  ARڳrȀ $@$zчЋaU$`<`u`u uR
 Z- ' 2
JJr.JПAZ10@ρ r@OMTB B |ԧTR0ᱰw r"5u<۰PqԮ];u1p<t) u0JХ J"8t	2 ЭhÝp J#?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ ?_  ?_	 

?_ ?_ !?"_#$ %&'(*?+_,- ./013?4_56 789:<?=_>? @ABCE?F_GH IJKLN?O_PQ RSTUW?X_YZ [\]^`?a_bc defgi?j_kl mnopr?s_tu vwxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ ǿ?_ п?_ ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CD EFGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_꒕ -RQ	 o 

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs?t_uvwxyvz
Compaq BIOScope
  - Skipping POST breakpoint
szB pz+~pzM~pz7~pzX~rz|  2{  B ~$@b@@ԄԄ @12Q ᅡbR /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯDBEXEPTN˰DBWAITCMRDCPUREG(6RDDBGPrSCTRP^MEMBUF) CMRSPIOPORT5AISPTEXTˆ/INSTCODEI*SMM!GŀdESETARG˦/ UMEsWR+WR,Q#/1RQ#AWR) Ds/˿WR)Ԋ @T T  ! !EOP
 / Oo/ Oo/ Oo / Oo	/
 Oo
/ Oo/Oo !˫#m#ϳ$4%  "#$  rpˌȎ؎  F߯.UfP.>A uWP.)G f3.U.H`,I`,O`,M`,N`,E`,B`,C`,.. ,..AXfX *fSRkP.Bug01)u_`*+tT.T$03t?$.040脨r'`*UE*`*Dp204r	)`1X
Zf[`001M01N09PS tatCu?`*L*7h὚v t-u$ظP hv;hs=)Lp:r S6uE[X`*Cp2'Pa5
.-> t
)0A VXPs Xr$$
0
/=
q>)1 roE`C_x 2G G hP~; Hs=CruX HrThh;fP f"wqJC>
 f.|`0VQ6'?1A60R Y^PSQfR_V`*U*(&\f&Tf	 ^fZY[XðS3ێϹ  Vp@s H ˜W0 SXX#YUXYX	Y @B32uT6W`*B,`* u.>B.P_u.8_t.9_R@g JP艁GG }ay}rangac\aXQaM}FaB;a	70a,%a
!}aaa
 f`(* >(6.> ,6f.R6D.VffXmAmZ Пf ?buf.R>r>^)1Q1QqZۀ 3Pqr#svPsȪszPss~Ps!f%#6 .,.>>66@lsv6. vffaJ fpO!f%$uc0R1f{-&f 0 &yP
_.QXPmqfZ$zVs`*Bsf%'f
 y+`*^	.Q~w

z.|t}u..G`,s >s^ tbDB8S+.&Z5JxU .Gu
`*e?~u)`*EKp2!)`*B	) .c!h"T~
fWz.6V.6Iwf@mR|Kf }6Of3ffS'ArMotA6 fuD>Q
6ˇd 01Tt	6݇U  } 4tY=o.V0vg&;pRsZ^pu VVW>ˆ蓭b& _^VVWr>r6> _^V'ɯ s0fSfVfW)>64rt 3ҋ f|ݠG 
t O
?tw= ?  68)< 	s0B>uf_fVfY83נA :r<+u<-uPR+ZVR-aQȵ$0<:|uYX@Ju @ l>@> U@vu@V
lrS- w|Hro1PO
8rK}?rDer)ߋW.9u$% r$QqSVWލwP <r:D9Gu-D
9G
0u"ZLqt.Ws
F_^VRVր? t u
?3^VaWU3и<r<
t
<
t	:tuEF]_rs r r
ê<fw<ar,W<Fw<A7ÿ<9w<00 L0QѠf33w-.-6/mё)9/'"p2Yc0.0Ӳ>ޢm
OֺxӋ6t>|.s<u= Q> <u 鿅 <u0hro).> PmPmDQBҠ w?>dۨ؀ `*s!?^03B>B蛓FڤSQTpg&CX裤W )}q鷨J L6Mr, 馜fNfOf_Ag&?2fffXPt á#?TBPme2f.;ew-  r%Q1ਐ tfGɷJ>8 r,vf2BrmAVXTT)@ r ,fffFgf#K .䱃@{S2T~3?aM`t
`.ߠ ,ffV&vPmx@Qv"  u߸ $t.$撱 Q fU.E.9߂..F.:wGP;A5ŋf , tR5 uuufPm=R#f]Ѩ9@Po:w;5.=[ ! f4R RQ 
	`_Z Z\$S
Ｐf  X Z0Sf3[ffÊ$  ffff 1%0$`%߻Ӧ R&%   $ff8*** Please restart the system manually.
 xL.<t$
@..
$!/t/_$0!/t/?DH2撍6mR3PI8>Ko wQѠ ػ7f?{tuCkP O ntJfq<4T WFOPAtOPX >~ XTY*\~YfPQU T9GPF >J~us
, 6=A> > POXpV]Uf ]ayyŀ8Gbؾff&f&J!KG>̀ fG`GQa ATIIPJ6LMfWf>҈!_f!QQQQff4ss4ttf~}VP6ҧfasPVAVrAVؠ0h."3PhXX[ÕXڥ/<\$<sYr.r@O C]CAp?6t_r@Xπ`?`UAIJfQBEn}S  gf +u}
' u d[P}p&r/ c@CXra Jg=)xxPe14l 8lmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo  /Oo	 /
Oo
 /Oo /Oo !"$ /%O&o'()*+- /.O/o012346 /7O8o9:;<=? /@OAoBCDEFH /IOJoKLMNOQ /ROSoTUVWXZ /[O\o]^_`ac /dOeofghijl /mOnoopqrsu /vOwoxyz{|~ /Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&') /*O+o,-./02 /3O4o56789; /<O=o>?@ABD /EOFoGHIJKM /NOOoPQRSTV /WOXoYZ[\]_ /`Oaobcdefh /iOjoklmnoq /rOsotuvwxz /{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo /Oo  ?_ 
?_
?_??? fRfVfWfU..f.6. + f. 's 6э>us.a +C..+.> uj.^q:
qf.f=   sIqOq r.q
 .+"s q6 ptP#+#`$+pĐ Pf. "f.f]f_f^fZPSQ 3<dr<gw,d P$<&Xu
 $	,<w .	.p)N.Y[XQ<uF$<t
.? t#;OtYQRWSVw*t^w.;t
|u. >
эf3EG..fEfGpЈE
G
.f$ r-/t8  99- 9.Ѐ tZ8=9? :@;P:?XthP[G_ZYrepe  `>n>VW>S; t6Ss?1@CsQ?r$?s6A-`B+ 15GCЃ} ;, 5C7D s# qB`C	ArvBr_^ rE<PfPǋfEEHE
EEfXSQVW3?u-6qCt6#L6QLuC_^Y[VWf6Ї
 @HF`CÆQfQfPf$FfXsRSÒ3 Eg	7WTkUfQIffD$70W?uUcT+9% si}
uFoDdW+pWZE_}t8YuS uN~T-fD7  !]6\0u]07 ^ ui!]Yus]{_ KT߀u#8
fɁYrgV1gV d/u8	1cc߾17,R0JfXf 2TQ߀Ys0cYsVctfY+5 /j7 _"kk[gkq8Or߲Wm_lieoaȋTq8s"ns\fEVVcwD1SfönmQokETf+r8sx0W7T*WTߥ:dν fD@@'4'f irfe  Y2pV~Q^ t@lsF蓟N+r]Y
~]ym3w@lD tsM| /u
!9z897<a\!5|6^<uhs
`\ f!7s1kq8sk8!~Nnj	xj95bP:5i3wj+fTaB{s
qrD1pJg-kd
*fc.`vX~Q!}B'?t@R{f%{s@l"⋰Oj嘭@lq8wAsW-q+@lw~oscT8p\5?VF`^k5`K95FF<^jdR{w!mnlAWjPХ8VYpsVr4s7Ar\BnХ蚐f!E~F^Ë tttk%:5n7sdu1n`o¬p qrsTT%=upWqh-Vf$&?	!(=(tLQ	
v+`=urn2$n0yrSFtQhٻ0<t`1 (ұrn@k@l+1| 7u Øn3|}3k,Cm|`o1iVq$fedwOcDjSFjd8kn45>2cT0SG iAy!|sdgw@?G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsicdi0phrTeFbgOCf_2J0#escsssdsfsgsfWP DVaX
<P ݰ: tͫA:ArAⳔ`D覔A♔ A4  + *2+*4+*8+f5k-JYsMɟȁpuJføtsPørc@d
t?oslc#fE~{tЎ1 `J!%߰[B
۽@lK!߰]rBW!p2P!Fb_x+si dpp1B  }߃߉ߏߘߛߞ_ ucQ s0cE
WV6g4Fg^_rg tUY	P!!s
P! !M
fwo/rd d" q" " tbyte %*/r ptr c #WV.3t"h6@:hs6J,6K&Ys#[O0VBOO_f^f >eS fXPXP
$0<9~F[!J!JhD
 s봰+ !J$ CqYsp8e+s߰-шsf    Pr Pr  ޳ ;  r_   . `rx   $pr ' ]3( ,T/ 0 4T7 ^8 <!T? 	!x @ 
 H $P$X$x ` Wa 'b  f@r c &@r h ( i +}0 l 0!1(m 5,n 9,o ?,p Dwג+q G.wr K.s N.wt R.u U.wv Y.w ].wx `.y c.wz g.{ j.w| n.} q.w~ u. y.8&8ǀ:0:;66;: 6;=(:06;?8:  |}U.  B  ! PC: C  Q)8vے+ !F  r !   H ' ݪK H ݴ.# PCٵPCנN  Urw O AT O O O H H H H n! PCxLM?8 q)pXXXnX  X([8[  ROp]I E  ^8PC.ȿ /1( ]ːaI #rcb+{ 'E^ ,KW 1A^ :УX:SYfZfZfc[f\f\ 7eݒ+ ;Uk ?C^& D. Kn Qn Vn  [w ^p IIN  bDrrIr4pVp`quu WfE^ kE^w qE^ vE^w zC^8Ab`py~yvz vz(+z0vz8sz $E^ E^ E^ E^ E^ y`$z|8fܓ b}8(bՄ03FzM  ׶ 3`,?	 0Nщ ^1   A^1w 'č	 %e@+ T1Rҋ uҋ  ֥ ڹ*1 ݕ ᕔ 啔@w 2A 8UwB ?UC EUwD LUE RUwF YUG `UwH fUI lUwJ sUK yUwL UM UwN UO T8 o8(V0V8T@P鵍 e  Ee.@r1`/䧂0䧃0䧄$p1䧅 2䧆2I3䧈04䧉4䧊5䧋@6䧌$6䧍7䧎P8䧹 93 e1 e2 e0 d8 9ҡ {  w 	 w  w  $w * /w 5 :w @ F    Or!$  e K O8SXw ]ƻ0b g mkp u z (&g!`ᗶ䜶塶覶髶m빶쿶ƶͶҶض޶0(m
ܛm&.5߻:?ۻGLmRX^eGrklRFpsutz q8 ~݅(60684nuРq0(Tg 50vf83g(lRF8ۻ8u% (m08$fcuu8 D8$0 0V   
0{ 00{V8 dҰ8 f {s  txMUadd push pop or adc sbb and daa sub
s x
 cmps inc decb}aa bou
arpl imupnsb out q jo j%n0c@z@be ja j @jp@`l jglg test xchg mov lea ncbw cwd call waitbff KsaPl@s!s stos lKodcqbbbRb rolr rc~ cr shla@etp@enteft!o iavemd xlaoop@!#s#xza j@lwockpne%_e hlt ct ne div i'clP
tUc (i i (d dbx1zx lUf@g@sl0)hrd bsf+r btp,s\p,a,c i,x,sep!.`.p..zR./.e-@.pR.1 eQt 12b0gr*Ul*di14l14_msw l -s!4Usq4s4s5s -wver6w ffchs fab08tfx`"fld119l289e19pi9g29n~";z f2xmp9yl2x fptkan<a<re1<xtrac8sB1f>=S<pp9sqr8s0frnd!f@@|7Aucomp7en:dis:c[le<inf1 9B )fP@1esc19env19cƑ7stFGaGfreB8BB0ArG"G 5fbEiEb>>1EP@@CG12E>MfiBIaO"LaM'AL wbinv+wa@oQ`RARSzSRSR RUQRlQ DVTg!X8@puid rdmP,rdp&rdtFrsm ud2 wr!Zx1 .\ f\ y}\z`&^w{&^|&^}\&^%^.s\x\3%^3%^\}t_.\G&^%^%^{.g%^5a&^&^a&^&^,}(%^-)*\.V`)P}S\ \%p[&^X&^}a4s%^$%^<%^v%^ý\t%^5s&cxΤ\|\5syw&y'5a{t%^$%^I~{a5a5sQz&^5a|\fe{$\
{
迵z%\׋c~}<r%^<m t%^"y$v7%^&芵z){%^+t0%^-e{05s35s6wQe{9uf{;me{>5sAjDt+%^F&__JdL{%^Nt!%^P5sS<e{Vu%^Xe{[%^]` z2scHf5sie{lne{q{}vu
%^xL{d}W{޵e{w#\P&^߉O\e&ϐ\ۺ\WuuY&^\ur5s'nڗt杪~唱#tN%^8etH%^&~  6 f3 t3Vv^
j
a
SQW.8
F  1 [Fn6F?f.a
>0QHY.&f.>R[  t8svJ $GG _Y[PQ.>t7xFYX8eF N!SDr [5߰Hz QMY5 FJ2@ M)FKEQ̘R$ <t<t<uE* mfSùE' ; XEfPQfRf3 3JFfZYfXSt[_A B C D mP Q R ۂS ABCDóPO݀߁R߂S߃c?[ SpWP.@ơ.X.@ʽ u<u	L <r<w,@. <  .>
  <  <;u.À
s.p <0r$<9w ,0 P.p`ꏿ
 Y.l<?uf.[u
f.&^aR<[`Ow?uu1R8f;t'uG⠰ o._p	   hثv ? hNȆg
Ȏ`Ѝҋh{ i
  ௎ R0 0o  r  D     DSDTm  HP nc6000 @  MSFT@[0\._PR_CPU0  _CST {PSB_C ݤ@12C

 A y 

  
A2A


\@32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Q4ph`p
 gpid#d
 {`
apRa bsbgcpcgz`
`vdgDQ5phg	gi
 A6gA7phpiQp
 fp
`'fsg`f b7f cuf!bc``A8A9E
Microsoft Windows ME: Millennium Editions NT C@AF
p\_OS_`pQga.agԩ#`9 
bra
oua#
 6#
 )%[Q$I`*
E"2 pK
pA8_INI QAH@B
fpig
f
 pipP0g0hprgfata
apa`"%ahha `a u1
 bobiib3ub`4\[K
@C_HIDAJ	_CRSD)
&	p 2

 8@ @ Q98
~!8
 C010;mp;1t12!<w;p;3;p;4pyv<5
0)14t=4>D5< ,16pBA7A8Bp;9 rQBa[p;A   
,[Dp;B 0p;C a;8 bDD?7[
GE׀bDF?9@[J6I2m0`;21,22'AJ30J4'25L6E00L7jL8L9#2Aa;5>2BNCNDzNENF A6`;30@31P133P4P5 S@"PrP7P8P9  @63A 6!C3BCB94D3C0)3B
[$UDPEPF@4P4Q42M,43
P!`
p2Aa}aiapaY Yib{abZ[W46
_ADR
 [W5^ U aD46g
QV#460)470p/4747E"6W8& @cd}AG49 [#WAK#4B(`p`Qgp`b,47ee` ap U dpyt?cCdcQg
{a
09b0d4CQgp,b_btd
lDluBhP42dcrd48` dza
aP1m@(`ofufif a(du7`['f
.AfWEL

 
2
B GtA  Uvv
!uiRv!94
 	x u5
x "u?y 'cCWD}g['4A B@50pibpkdrd
edi~sd hb rb rb

bhb1@2j@3Cj0)51D2 @5 =51crc'5}3bNu4fw"kar$/4Eab@2b2B42sq3bu~14atb
b`c4aBh`bac`5p
 j55rBA7 ;4E
P51#51>P0h52Y12Z"aa'`ᇀ_S3D
4D
[6_ pW

[HN7_R`58
`?
[I	fs5ACF5!W5qW5W60`R 1 @} Ї62 H#63    ,64!P65@A6p67 '689 E6Ak 0C6N6CDEFaD70

I#700)71H72 
<[=ޑ  @3>Ѡ74 AL7627 } K78 9>7AB`
[+tBC@7D9]7EDF  #808m181'W823Ф1p/84SPA85S,8687ФQV!B`8U8s8Q88CGQD[#\_GL_(bp
`{ap`0_!
dv`J`!8A8B{hp0jp
ap
HѲbӵ09Wӵ|04a0|1,8Cbq[}д"ya
c}cbaa6`E
/  hdvdwd
`y
`ayih61c{ca !F (80@@90}xp 91hi09P!`y`jaB,925``wh
0)c93!0h650ayjabypcе66c d{}d66M#94EigR4
bMbC{bpwc
eqfeyrep 
 dd)idkh
 y
cèe0)6Π@92c!ahY`}zbuc/ 0P0UжaO`ij}Q`{JQ5
^)6F5#E&#Cq
 i
 Ap96Y0ipph6ARG1܁^#EG$8FpC'%;Pbj
[IFd9@
j999A%BP9DQE CG9F
sa`!A`Cܠ
P	09z{` ka0 
bw
t
	rab@ CRZ@1@B00{bARv"@A0
pI6'Bp/WA1
r2iPǻHе9C`Ea{@p ` 
p{z鞁 wi? 9A'{a` @bA0b !|C2	?A`pCw
h ͠k }І1@C 1
ccF0CA3
7l
EA4,A56p
e {ky
0zеA?4  }2sejj
1	=5{`1|
x1	6Pp #04b}e_
e/$p !04	
We 
04
oe}`p2@dAy~4{k
	d`}AB
 9BΤ yqBpo?d`P(u9d 0h99A3Ae-@=A7 PFb1dyce@
qq,A9hif"f
_j
1	8P
Eb2dBW	!b'p,	D PMU6Cd!HbIz Bb(D$p 
Abۡ	#@bC\0zyacqC ϫcD )B)`j)DE da[bR_AA_aqWAB_R`AC

[>AUA1AE-_PSWQYYYAD1E x120E[( YF^`B041^
-B2./1P?2_3453_:7I?8_9:;<=CЇB0^_17A`DF3I_
3I@QI7BI8^wHpB9	q6A	
#  Oy OB`ih``jր `BCO BDI	PP	Ap
`	`ХBEdS`	TrBF	=0C0C0!Wγݡ	!W`֤`[OЇC5c^_UID
`_STA RD^^.љ!o_DIS1BEH[I[_SRSBFhI[ҏRY]X$6YaZ[A[c Yc/^c_!X ?Y	bb[Bdkik?f@kgqXGYcj[ClsysOnsoXPKYhr[D /t{{_v{w1X$ Yiz[E?| o~XY	j߂[FO@ћXMYk[60_"[C9U[78 12[WACB
RC< WD [#"ЁW5ɟ6uZ[VCABEIv8Ǡ5L0W45[D0WCHНDWa7D1
,7PD10D2 3
LE3Ѩ4 :_REG38ڠD2` S~D0Qѫ0WDGS3Dk
`45P5((D6
k h32S`1T%P7±3PVKP8
@34 {	h{`h@(@34pix.a1$Ӷ \._SB_P9t
!._DOS0
`sa[^PAb"ha[DC.0
_DC_D G37fSSWhCc۽ҽҽEtDd&ʾtEʾbhAFBpD6	s5 Fp
/{\/Ӹ4q85
	DFQF D  7  pKAp쒓hip79 hp  ^\\/fC9zD ;tEEGPG57,C0E0
 95hjޡ
Q6hi` 8El`CpE15pEh"80"7EFEppD7PT E2
^/Ш5E0pklG3 85`Q  a[& E@E aaC AA[O5	6+v86`5_ON_= 86_3_OFF }?" _PR0WE6W57[Gǉ	_GP_E
	
 Z0
Gb bGf fy E8QE9EA B1C

ЫED@EE`
u#Ӫpii0A
ШEBa7EF}[B1 @@	pF0o  WF1 T 2A34AU5A6A78A9 A FB{ FC @{FDE  F10  12345z67  u8S9SA@ )Bp  Dq
-10F10a1a2a3a4a5Za617819P11A_INI 
\11B
>аK@pCaDaE
aFr2w0
1
]21234Ip25B6
Unknown 
NiMH 
LiIon N7`>-{ `E8 EAЫF7`E8P
TDV`ED7(v9k@pHؠ!(}ha{a
!}Z1i1!`1(F(F<%aV128	`WVBpB,aq%73"9	+0p
a	{`"I'A
[)h`pa4`
csc
  dziTr`a[)a61bsdb1/"2P23@5cocHB	 Rhg. *29g
1E`{`egйCDhH%Ap搻FBQ`/`N<Eh `>adFF> w`

axra
2 
dcbpb>nA<0B`aCCa0`azBI17Eg-1E% [IF
8+u9p
 I<9	ip
:F/;=9X=C1caC2#E0<R@`	P ۾
{`z X{``UEp84>P  9T2c cpP e_eWeXxcpe'cpciXEFFE+231 (_Q03TMTd]4/^a;dp
ap
ay_aQ05TZ_`]2e3['e^eTZ3_0`Lq`O6 D.
ag134
agPR_CPU0sjg1_
fg2 ld7df*gk%]8o
Mh
nh  </`.$i
i6sjj7
 <G#]9s `i
u]A i8*xBhy9xEfy ~_Q10 3-tM|qJqryswtQvv1wtE
{p,hy7izhy6i?ar@̕$/a]`a`;V}a'310SaC [cP
Q3A
Nn`13C[Ov'3B! nD  nE0 A40244243 L
В44V146784@14A!1=4`14DҔ4FQ50@
[ %1552A5`154V5525PG5QmqUяʠ8я54A159a7R-`)B/ `B0PBp a
 y5a!J:A5B~-㟡bcgBb9cN§tAҨ8c3'Dbb0ҨFcQ<5BVya
s?
 d
b
 8bdpds`@c
 c
8cq8 .5BO 5Ca7@2`kaa
a
vaQc aׂlbb@b
vbQcbQ-4p4B;pb1Dt 45bA¸89b04AbD#!aT7zjbC¸F!E=DsAr2r bb	aq-#,bbG5E.57F30c3Eڡ01 `EFѳE(3DAE(40Ƣ1r6C160
{C0`{ 23 iaw`1`59h0
`0<A  161	pҲZA 1TaR9`a c`-Gabc`-$~K'62 p^^3cIi64Lb
65

G?y  i1673qD5A@X`-6Q67TRB6`7[E`69e _DDN
COM16B6
30" @68y S `6Bڒ.6AΡP(P +_DIS 5}22 ,6Ar rF_SRSً0h
AC@2уCb`q-6A@
!!0D

 ׀BD` tdRqظ[00D   
aE|_ON_qFpq
_OFF1`j0aD[WH:0E`40F_ADR0_FDI" 
O


pq%pq


e


70cpC
GG"O@ *
4 
`P^0" 710.T	-7A77717q778>!9B	 K7AppBJ#r١`Ri7C09(74)G6>2C180#2A *#@"20*-8d CS!Br'!"X#"[3^ y`?q*53D!ARMVb@7Ѧ c-0E3gc0µg0gVME~A]81
`ʪ1`!1!2p^
6F` tB82`81[L$3MףCC
_VG 0" *
n89k8@KI
Bb#?^ࠚ1pDA8 *?];sP?L!"
#OX%'!(84myQ?*Y+84[C 85 L6pP`[ 17

86 \<237г47!588%H
1 Gxx;xx"92ax9xx5b:7@d&b:a ecfodfa fckhk8`O %V548AN @Apa<wO8GeO *I}F%89K!Lc~ L`KNoWp4_OP`Q`px 019Ǽp1"% P STM1Bmr*,&q`!YB)~8C p\/~q44C057 Ձ(ԁ`'{q  N7C[#\_GL_{~2
a['$hGPE LDb}ab'
Q}`[% LFRS H"  yPs`+@ @ "|[5tU4 
`8`G    *{"C19s4ba a -@1U4
Gp p Gr r@" &2Uh` ` Gd d "aI[I95
" y94
95a94BC95&sqO.\8  [+@6Rw   B [ׂN@7S$	98

[b@9>A[q @BC[D4
G B  `]9B
a9B`- [#p
Uq! q[]'F	06y9   	o9F
[Q*A0 INIcA0A!6tA2A2ЀA5# C0A S3D
@S40ґB5C8C097[B@5e@61+sE?_GTM pa1&`@70BsA80A9p"+q۰AbA9{q܀Sp	8
A AQF 4MhThhSܠFi  0-
w@p a:`㰇` bw_b
bw`cib ac rbS0rcue`3qabCߒcABbcaؠ:&aW!{H0qD9I
sس[5F@F &DK@ @FOoُ `NGxS߽AI
E3
ВM
 -TtF`NBT,״,
_PS	0b2
3
Pp)9 0`[i!\.C n	
O# p2?C3C4C5C6?C7C8C1BOnT O`B0G
_*0+`Y
`GCg
 F I(!q(!@%!a"A1p)54!' G5a+:&++ +1%%a,/A-" @-!@-"0C !.2E@	F
65d
d
Primary 
10Q8 
LIon 
Hewlett-Packard E56Travel/8K9!5D?@
?!5C? sL`2B	Ew2Bh`/`%
 :
F
 
1 2SEhBAQBFB̛1HaA[B1JBCFha`sGDh0AC13
_UIDP óoKCޠBIaB0@QSTQܐYCL]\[G~3hN6³)q_KPIQ"QVRRMЮ
ACPI<3R>P
RVC7`)V21 p`396[:M86
_*_LIDU,I85 
	/15?@SXPN ABjJ2`hMB3`htB4`h@r `kk`h`piaFˠ?PB  a{`
l }aGmlanaop`kpap l5l^p l4@q B,B2p)~B6
h

a k`q
\vbv `Bwvbv`
wvp}
yjP v  >r1h)?h`1t{6`}ibbasabcpcau`apB7rwpw i`zC03Em
@-a142b`a
b

%8BESBA}E0BBi!BC D JEC	uUp
3 `y@sr
`' a Fp*C01tEeae[@wre0
 KC1C11EpFAIL
1uUCES@lH 039a1&sC"sDp^02bP0Pz퐑 ?3fOCd  bp2J$/7|C`~Q   `pPASMSp5A7 OSC30q0p `~p37ap	o a139{hpv;2sà7abb  a{ b ub%NN	WDGL
xRU4<SMrJ/NAA T-MP2T덶AB ;9Kp$[?AC+|Nr2J)lBC 4_c,E=DAD!f )AE0CWQAAà*
p{A9Pq&u5֢ ZB8~x
KBE`B
FfghiGWSAB 
` B8ipi7O`C
COMPAQ|PC C9 S7t2Reader|GEMPLUS|GPR400|PSCR|## O%WQptܑQ2
XBWSBCІ"pi`q "a?g30`sQa(`P1n a033a
I45F
 
WMAD1Bij! `' `ENFOM   p:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9qx"kXu1jHـQj(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1NW9B#?U>2Fpz7G	A>|=h4/~:zH8P9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
`pt4sd
u(GqG!`?
dPBBTg_~"CBP(Ġ^|7ȑG!&((߅ @ GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB PG/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
/H\I@Q`PC ?;L0<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9qÐ
L@yr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$h`" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[C5 wJ[#1Yl[#\_GL_yh
P6@ưpj꒦kP803A\ 9hA0l['Z['1Y`a06

[ӁR_078Y9 C1D3Z9phLa`^9ga6a8b/a7a{h
7p{zhhpSfd	a5h8h4  c[A]D41DB^aClDTlElFSmE0QE1 ;n2 r6A  1_E3E2
[Pp4@(APE5p6 _EA`E7s8p E7UyQt
	`rh``v!F E9~E4cd!ǢJaߒc
p`r=d@ b}yx{pbay a0/apalcax  eraye
	 evepe{Dc uc ydcM
nAv9cpcw bpbgC	bdp0 apb?e)ecple ffg
fape`pfafgvdueA`bÀD` gĀl`al<Ѓzb pg4w5aggagdMnBa04A@b` npP`c`xb{ERF`y5  ZCB #D lhDh H?
bhpx<`c `r0}0dQR
eÀEn@-adft`funadzӓuc2wftdgpLJ`|b^7 C ZEE1`ZuCn9wA!BТ na^E}1`
_INIqCBY50pibhb Dp@hEDrb
UEtjqEFÀFFbFC1F0 wn
arC00DabpbQwzba2`babuaɢa"Po `b ua0+_CRS10D`&a~F0``_STA t"
`}њ``\/uj1
	 o  y jFU1F1jCF21
.G{G 0 @0   y F2[DZ5F4j@L63F
bG` G$ $ GN N P P Gh h Gt t¼ B nG@ Nΰ  sy ^^.C0E@62\_S0_͔A3"4R"5 H\_PTSpho21Ch
 \/Z0EC

h
28
 wUjACB1L \_WAK\)AA@0EAZ%8ѠF_bp0@^ԱҠ'}oD9yl̠)TZjF5TZ1_
f2 ܠz˓P]0A
a>39
ps7b
Dacb_ccc4z99AE
 `nǰ0ABB234N\!6G,<

0n6

bAYA@!7kF8
!!A
!B
!CkF!Fq200°12Rnn3233
A4
C3{
_?1CDiwK5
:@[0vp
osp
Os>`bٯtio
}"H	6
h p
~`3pi`9`
~?Wr<#	=i?
rV`B7 `pha'hࢀi08i w` a 67
 i`/pKDF532v33pRn
  9 1^32t
axa

`bK08D
X
bt*#/$
&% 
/(%
)X
'#
PoW~-CI9	Op
d	̰do+Ydڱ Ap{o2F  {b
 t bbwb

ara%MpLaoцҠ1?7џ9o: )a60h 661p?0T>zR?Fy
 bOM{	h0 a`<`0\E02E0A`hf3_[
BbP3T"@!G
!h `t`%`x` 6ff?
p{tf4!guf?J aKKytK%cbbC&05b&Kq3Mb[MbI	i0ep
dk
Td1%d(%efBi@5Hv١%Hw9܁Gw	3aaa[qBPbR 
_OkN_5`FF60Ɍ_C_
q)atdUb
_D_
)agUb
ʃ_E_
)atkUb
~[;3 GFRV3 _PR0_["C210
opCpo6pDp2
opE[H^_ALTpFx91bp!qAL2#yAL3#y2_'AC0`A!{1v{9|2v{P{q3v{{PSVv{pSLPR_CPU0GF13aM
PFE3I(3E7棃8p Gp
np
$ڄBAA_TSP
dPC11rTC2qtCRT"mTMPpA0P`[G q4s{315
R,"
+**3@tߎoNF\_GPE  3 M
_L00 13`dD7{`  ,{`
yߘ% Loo[_%_
p3"4裤B50f"C飤DI_L1135`0ЭF3W5.0p{0
[945CW0CF0ONeE 3RD o_aIǟ@b@1Fpajam b7ڂ!SP"׼  QK 7 {63?`}` @/3ذbϮ 8\[6K C."pj0NoϰG	R D$є@8NзǠ:85  Ɩ28 16	p,9E
3{7iۣ6iSSDTuCOMPAQCPQGysr   MSF;TA?ȓ q7@
߲pjy   ⱍ8k屍!}_PDC{h` PCT y
`187	_PPC ,APSSN`SQO ̀D o?_ _0_ ?	?
_ ?__ q  p  
    	 _BMp "v }(   @    #)?_! ̮ _ 	

?_2ܾPV̾ $q&"@κ`31$
@π/H@l"!  "A$o%&a'1**?+Y,2`%*./r,`P%,23,Qp'O.o78$22@S;:;? O>o?@g:"DCBC EeHA22GGF H=06O@My:M9IQ)Ρ)4AIEsG06)$ܢ$ U^HPIAQV$W)T
WQKFG dX ?[XO"3Kv`X2R^"@I$Q%%U5PGabPIXV`6q$RFhX?i2VjfXRT$ mmVPn$qRXlqkT_ stuvx?y_z{h|}~RVXercWP\0 ZVtPI\~N`dZqvPIZ~LbpZZx0 X3
zRV~Jd҂ G1d$qZ!rEHh ċhV|ċl|R!qHj!`	!qi pE $ Qx$lppogj!2lfYrgCg)2 UCCԊAC`0 ,^20 4`0A`A@YZPIV J$3>ࣔX #(0ঔV󠱂%2TR2͊a6 !R0 A`6@֬AagGP2.0aCNPI`6R" jq0PR rLPI2״02a@ִ2421J%44@͇H0 @@ߠ7ܨ@r@ΧFPI8224w8AA܄ѼGDPI:36(Ї@ϊ<V4͇BPI>ԊA ɷ`ɲ*Q`R@)@	8C@0  Ї`B2JUB(&3%G>PI%D0(RIj D*3K ԗLչ,Zj HĈqViF%
̀PKg<PIÛ!
0,1P`*ٱV*ᰛF ݣ!U)᠖ZV':PIR&0 ߂aKe(j@y䱀j@QB[@ߑi@rVi$
ԒC8PI (]FQQQ 5jA !/"uMo``~(۱ Rq?O A"2l% (o
+  -0 O3oO6/9" > @L4<AD OGUO,NJ]=R!/M?A kĨ#S7 [S)\!O=
\$.@ !`B`:`} zd/W`\Z	 1Qj[0Qi]`[_Qot#pbQons߄tPuau!ځtA${am@pqB|Rvqga$&Q`"Oqg[rz݇ ЙjsqV=2t!Fԅe;qkRVqnqT:a]R _qkP]V !Z{QEPNSaLeB	LVEJQ (%:Hݻ,@ x."C@Hx%&D)RBR[!F<!b@˯T8 %TV*G q!XٲQFZ@;0л\@6.л^Up,л*(Br`a&P
dтۀhf ~!hD߀yv
l2xbbr>@pA} edwvSN/:S1F~]P  HIhQo4# QҕHʱf|p@ذS8ЬJq6@1س cz0QݳcLE#x3j1֓ܣUraA2q`bKAŀ`ȠQ4@At"дƠ afprR?_쀿?_|        @	 _BM "| ( n s    b#        d d> F ."    f  f  `/zj
/Oo
#(4UfeC0$g
S, ޑX_2; 2$_"w wOo2c~5xR@2}ch_UZ?p?d2&i% *Y !"Y"S?2R"_jWz"%"k? c& %k`&(_Os "i%* "
*U?) !j"_@"R,*-[++`&Z.{`&/_d0)Jb&? &2J2B1O2U0`&sdbQ14`& K2$e6"4468{0q/
"#4 4Q2_8oh9W	y8o Q2;2J-) &S?{9Rq/$1CJq/AD &;B)?C9E`&EH+2A; &:B2C3&eGu &>Hq/Uo$FB2b/A!"TKQ& &;H%D4@1SNJ(`K"%yot2=HK )B<QjN{(SUb/B12@1]H{ ?)Y`1=)KKI4"2/A@"A%TE[")FEBFQbIp$y ?$:IO]@"QF$@11^p0$E"9E`^$<(](X(T(qI&5S9J7dJX!5A#=Lf((HqI+W@RB.=U)mHq-]ks0SWS@1m8Kq/Zgo.d0 ar8DnWoRKOfd0Bo sodWQB"$0${xd9sziEt"+ 1a{D1&ra2&}(s<sz[O&)pJ&dh|8b91ak'}BbB~0(p6$xSqc=8C;FTqn2+B&|Z]$%Uzp<H`9K?g"59Ws<Y@|U+⁗QF_*w{O["s0I!D]]6-3JqQO _F~SpZ⏛]N-dhCє]s9"1wX]qI&)-FI1SnVo`'Y%`b=]d-Q&63cSS&$R]2)_$7)O)(3<1O$k`E-7HN(RAĬ2Üb/4 D22Q&_(I"631=oqI8SAD79(83_9$_SeWB2q|VOq/XBQ1t3C);"
q9""5Q21,Q&QoDq1$+`&m A-H:UtXk"-DEqJHS@"B9a?BrĞ(H")OBSAT 1EI'B_KY HS& 8o-2@")c|%>@"W &j &4@"-aQB8zq!s@ RzT1U !\RBxOhPB V`@%*ۺE"%!AoӍUHOPc i$:U_#	I VG"0% B{tb "E)"0B"O@PcB7" &3 7Π SE`7Q oӾzEƁE :"`$ !p"@6.RF@E4R@QmE8gw Ph%/Oo@	 /f B

 
 f5
n
     Q   `	 _BM " ( _ }    .#3  \   G? uf  ! ~^ 	
H 
 0
 "02 
2}#=-# 
-W " " 0

!
K
ݠ P

 @P  
  iD0
0
 `0
A#BT$]P0!
0
Oa&% I%4&'%T&#&%(s)*A#N&*:+0
./ :(-!!//
+A$4D.2345'789	 0p"AB0#_<=>x+2,:tCA02AC 6,?'"A#@('	@_G5C(?/"+6O"c$E)\BOOO?p"p"@!2D* .2S (#S@T AS!S#S!SA$N7 , 2IaTz Wt-Xp%O4YTTXp%NZTJ6.\O@1YV!2AqW ?_`_^\PaZ"abc^2fd.a%@^p!Nfd*+[!!Nfd(+jRA7fd&h N
ZPDSfd$"gqlUNlA1Pg#OpMc"
#Oe"pB$OZEc#fd O(PgB$k4s't0sAOAuK'wwh&ue'xOv@p"qnz'z ,
k@V{NNpl)'z}J. pM@O|}}#.a~pn')k)AO .sZ.d."0
pD'Dtc")pn!.@6`WP,@1|]\TsJ f&AOFOT*OO!zJG -r)ra}!WP@0!c, 'Os(.#俘6"aJrAONr2t'@02!A.ARR"#."r-e@c$AOR Iw#c,A$!OPk(a$@pE,>қa$AO-9p",  v"qRYe,( AOAVeA}r g#A)!!ca"pn ,z1)Ғ9)rx KJA{}p6A1 rÁ#p0Ų !|B Tr{ ,KA$x$'ko m"al @TuH!|.S0$kNqMrSss
rpBPi ATWrne"  #02OrlBg$"Sp$,hS!SNDRTf"p! *rnUa0m67٭4+AJ8tBRdUX^XU ^U1!       	 _BM " ( k }    P  #???   |E L  ʼ  jD 3  ! x	jr
x
F
 
 ߲
> 
̲
E


ސT0aRUݰPr 
 6MCutR
E̐REѱT!RUtP
ur SM@%0#W,p0U>P BPI%ݐ:A( )ϐ(&%1(#/--
 <
ABa
R59-4A-,
r )|6+:8
6Rp8 "<0-<R86x=i> -
#4DC5/A2,c=A-pJ>s<BTDpCa+A9A8/>- $DQa!8!aAr2 D2B
M$DE>

 )AC<%O AC:pO$"P8$O&N6
 )(DBR PS*D>4S,D?2S./D_0S$0VO.ST0NpWT42DN,S44@V*S8D(SZEZ"S:D1&S<D/$g\P"S> Y]TE@@V S0_P BSS`D@Vzb`ACUTNWU4PC4pb30C3Qb`C
CO*pbPbO
TdabAfAfE \
GDAdrbBSpePi%te_}?4/$pb/PbakPk
h/#dcb0C?0CNPemnAj4jajkimhP#d!k`gmBcgneonpCgN
`Utq!oN0Ci3
4recneeeUT)Pd#ddoBrgPiqeB4xwi{bp43aBtzTrfRlg!Q
SNanN
2fu/Pe_rgh+? 
a!gAe@dj)anup{]r4BPCq"$!f"Cq!CEPiACW3Cu10Q4h$Z M4pk4QBjRUR_
 JLP qFpU?яBJP	 MSH hqGUS34\ . ($U_k (
fwxGw@?HqАyJԏL(яJyPM
vfw:mT opO4pOPwoy0oTyaњ.xPG,PSП
ph*П( tzП6Px$tqyPocКSaxoW1  Sҟ
갟ogPiЭopx
oA#SПvp𚁯ihpgfRh2Яy\pvrpyfMnҶ!v u_ПroAP0rھPbrFf]ПPv
ihПa ]JgPПoȘ2ѽК P\aAxrp`Кoi[21p@ZaGiѶP9wPPfҟay6YyУfvRvWipAhpfpfPvVph2ԗd@oXКҟZUPagPԡaT1o$pRpO@*TՖRROi1QCOѭPPOMi@J%NvNJhPͯDeBxH
АgވwL/
Ӕ   * T     ]؎e Ћv\e+3f  eq L!$F10fPfSfQfRfVfWfUCES>`  fB  f~a|`   tf|`  t M dU@d _@t0f@d@tQ@	ð	@  t
@@s f~afxc A3u 6Fb< tf3
 a>SFbPA  a[ d>aPP;xc  xocf33"
	A
t
   Q@@ Q@ftf2Qߨ t߸u30A_f^fZfYf[fXfV 3B>/d t
	U&dfXf^PVW 3W B\_t
r
>a_^!P  f&T f. 1ff&T !(.ft)@,Ot..<xu<\ޯ۾اбκDD(|1280346/7O80  `0~:"!A>v< < <'Y >; @@?|>RAq;'?$@:	I!!:}0t=!A;;><<dC(H)))**LLH$$~BK~B@y>H$$$0M$C  >""ZFF:d;NP#<6P` ::F>hx'P2N'ypL<<"P:2
/
	?"WFgJ> ?8 0 p	

=c=V$$DXJ!^sGIb_UB`>^<DRE b@FcA4<((DD>:^G@=?cA@f:E;
)HURs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInIڍ׌߉s\gpjځBȉymGł񂪓rݏOڕKvOxmȂ튮xrWԍtÃ_xƂ׎݉}֎~HS\zԕzfmQ{ǔsFV͈vdǂь`YilǉE십ċNԐUiTivIىe^qlӔC~t`E֖ؑ{pKWoYgȏϏ[cxb M   >  0 ` @ 	iyє D @Ǘg$T ?XTV
 P G1!!#"& pT~|U  ?ДQp? ߘ  x e ) EfCv h0 @ਵX   `00?BFLXp0@;ae0t<p@I`]ޓ$`08 Te ӗԥ!|ă   UP W ƿ >"6>?=C?~!B""!B'  /!B#b&2 ×`   `ALXâ>Ap1@@@᪑q  Bft,?0<Hg ǰ0` x^\pü|%C p)QȳGGf t0 صĚ56 
	0 P $&# q8 o U| D~D D<U B f<,$$0$l= s `π3`?"#!! @ `C 	 8	  6 a п1pp0~!3pĤ``@\D2"##8@З۵ Ǯ!A| %rm  2  ޠ 1$Q$${ayH !{HHK?x d $`aa @@0!cc $2&f# `0;xxQ RC{xpQP`qE6@@`)X0$x|pTT T8p] ӷ	
9d0  $
p$4t84(d(lD &1< ?! ?&!<? !!# f4cBDjpXg?P|%>0 ^l !C,$9`0pm%B p @ $B' p}""" ! pp =d e ѶIi&0С@疰&$
(?V@?^@r  ^#2Bb"6T$-`0|Дpp_x3@@` 0pA> 0Ľ@3dC|s@m|%o38"5U QHU' &a! 3?! { !!3#!2b!B<?1`		
	@21"`n9$i$	$	P?a?bb"33aԮ(F?3ɠ8u L0#оtE!"*22Hi)""?"!PGFG'  <p$P$%)*$ $ 'I,!## t`@"3aMR<xb\ۤ߆ ? Qǆ0c $ \7 ga  9 "} 8F `D8R)C)E+D:<  = ~~<  bWo<$0X'V?  |DYXD|'/[>??$c]]1ߣbpC#1' < ~ < 1a  <$$$= ??d)),?4+fI@Aa'߾0Ǣp6( g}g@!q6@B?3U4ԗp 1@0vgm  S< V<bo_=$Ap<P0b64~
*rhHraacesV ~  <0 {D=q<$2v6p5''sRQ2DRDy""z"z""s!0 `1 K0~6@K tp q02P <b62d,%}IH}T@_ 
8hI8 QQep@1kp 
 .:23V{& ~  riic` y z2"RP{!  @0`` ~`AٲU֗U|4p u	t(ʠHP0ҎaD%6^SeϠ೘@$$1 FD @@1#f~(3H2~RHH~HH `π~ !""6_ h6q"c  2"&	$  c2(@"bG/$?e ŏ2B@D0
kBF0L `D~?$&""  0p	 x ߤ	#`4 c&8}qп SPpP 
a(0$?`@@DDDD0τ!cѰI7= up&+DL|(0<12pt 1=  4;A0i_#!@0 ` >?!#3"$$9!?`:!#! ! ?bE?yw@hQ7 H 4b2C"cyR S@y@Mޚ &QBx<P6@( (#BACt ?Nr|8l>)Q&bD3
P<b2W1#nSRa߄$C'$?Av%h|p  1   u  1f    p"r&#0  g1 c >9D

 @B  S !t!xCɛEP0S/dD8 )CFB2/E0<
 P|cb?Da,=%$>s["d[0@po|Dp2D"DvDTDD6 # aJr(!w @A`Ks  lq1=m48q&A	  6 P>tE PL DwBf$,8?92k&a d,%E 1BLpxPX	G sA3"&,00PбxoDexp<x {{|8|	(9H ;)*;*$*%+8 OTT5VdbAҠpB##@8 | pl0@P2P`0%+CP \Kd ~*H/?K6cq++
8x&?~!B2 #"33 0a0o5@8xQ "***" /"$'$&*"$"I?u%c0`@m?~$BdBP=a=B
B?B~1J "&D$(-@v?,!p0i
 7(8Po"W=I H<H$H$I$= @>@"@">#"D"l>("8""8>(l6cj e@0aI4R$zeUS R PEJF**py0 ;6P 0Og;!<Rᚡd0! 3 ?$$$$5d$Dd< ~ Tvp p $D$=<LQ׭aY_2<oLu`/$y,(8(lqD?  /"?(/(/(hOX  a;d			`A}5~" ?g0P8_0h @""bp $ & "  p?5 
pt
F 0*dvv@Yp@0юg#T(00r?$^?			?R" N:8H 0@	1y?y 	 	yz>""	V{0p">f6a➜@D= D~ ?= U0< %`V8= @|D< !!"?!"="`j?;@BF\pw8@h@A Cb {HHHd,$|$$$TdTDTÈD}>?00'$!$34, g A AQ8`"(; `&`|#f!`b62~Z*\*?jI&x@@pt/  5x RRp1 H0	  y' 	 ye6C$'!4E;ı!6Ap6pñ<r"z!sK0qf`  B F>lxPXHL0F`C)gq0h0`q0r00b64~
p**hH$lH UIHUH~HHQHU~{HAPC!@ppX8 2 :b)) ?()()~?H!!!aGl>#540P* zRs'"RP7P#D P`:( p" o">3>>""&"cb@	"00P Ƿ1w` xA"a<"d[A
y[ <J|3?"a|I#(Ѿ~I	))iIx	1!c@>~""#"b>2a>1ِAA+ ? ?   ? ?$DX0b)+*{I#F(!Q4kq"?"#
 1pxQ#|  80 S#Q8#+AQ8<
S0I  > "~&%,?(l)$?0F-@IQ2!;VR!q #!  m PCfxP(
qr "**~*B@8b~B$fq BFD0@ @`@ R"q`p ?2R2RR0cBb.4d a> H""p H b`B  ?~ 
(L5g+;&;gX%
c}m8@Tl l$5?b5d_g>`nqc`By6"x[@Se4`N[ 	(	)	) ( )H	ߖpc 5З 1 a[2acx?~""2&460ba13&4sFк~4@' b'8Pga0q$&bBO6  |<  #<oC;<s `xP)Qx 	 `p1y3"fud; |@Acp>@$	,	(	88(2l"Ff[11[T o'$"r3
D(z


~g<$4 7 a  p }#`"4&0PPs`@   \?t uUcuѰ	P-..1S.1\1  [<u.1 "`uVʊ8r
8s8t>8t: t3-v(8r*<rw.~1` aA!2(P )() *q(0)))RV^Z(uA!`R\ts 2ƃǡ0G
aA!O s6.EN_j/W/1(wts2)0) 42<
t<
tD<tY<t )PH  V)PU t	| tL^f:t Pg:D<XM : Àt	2¹/ u 2 42.>1u .U CB 1CC `.~1&+ u2CQ2P Y*2&PF aC@DRDr
.1.1PSRF && Z[X.p/ O02C0JC EKL.61FNFQN02O.0KPW/tOP_MTRR*`KQR.61ʊƳP ZY[XX  PE~bY2YZOsP2\sP
X]<r<?<rÀ.1  1.&JNCu'AA	13B`PRW Y1`c.>1P2cX2Gcc$CFWPQRWMF@@_ZYX. 2.9@`t.1dQcAD`<u<~q < n<< n< n< n< n< nû< n<< n< n.>ߊ1 t_3ػ@ .1G.11OWt u.1.;1u0 `t v0..1.1IEt;PI O X$t1C{ |Xd  WV>}	;">tj6 h]at!j^F\a؃&  hE0jF$a̪o$a% = 肎>qzISb 0z?@#U$%|BJf^fffBNaa~B^%% QQ_Af>aj_4$3B`
ߝjBK|-sa?BAHBaD	_E*>CHŝꝂHTĊ│ST2"ěRUځ@ۇ/R[誝Rg`Ri:Qa u0% = u(ap0  &at9j9&Jw*`jQ~_a$臩_fh  nB tAt=fhjna$ěwȀ_tfhaLBR>tS ct3tE>jhafjhIP>^%j h]^Q!t2>|c tq|cfhНSЂd t+тdk\a tU!hbhbASЈՈDڲ֪Qf3f
~fޜPFPhhdtfQhp~ 3F߽0H =#bhb9h boބ߾S VT&?hc?ƀ%)F8ore}reAࢿu!őy`W}`j㚖21h!_FPAsjrh!Рchc	I"%#7h`b`yP2%hAa V%~*h]hE%f=*Dԑr^_   Vd^F FPL <tPvVFF~rp F FIu0F&,^
`F*+҉FV e+;u;uà e% ;Fu
;VuÐ eQ	2_áa99~e% ϰ*	k
aWV~FF&8u
_ǌ@8t
rƋ*
F`mDNuA 
 Wģ~0F $fj h蒾'PI*{ f*fp e"!&^߃&&ajLfPJ'  t[j0Pр4'j FP(u
`)$*F -
!WVPB 0V=ut_ V@#`0GF| 450!62:65|2233 h &5P5 F GP4</5FNuFG=>G?i@8=O@
A=OBCs&J@F <(C1&,FBC2NЇ 1 JBlCJvJ>BPCJvJoB3CJvJIB3MJvJbVB	OJ vJ?BSJ@RvJ#ÆSJvJ$BS2&_%a% J9ÊSF@u,3FzK&L&a 
B=SUQ\R&a&a\M&J`BS
2&^% +1^1 o_jR'<u@G3Qb_b1c3dbKb1c2AJba1jEb1cUh@hEAbdiOhhabD1c`[`\Qh0h~cK\L\ajDb^#f	2&YhEbBarhCbtWhhHbtYrhNbvMhjhgbct3Ρj1iji2CtKhh|zDOjSbUtr@hUbBarh\Rbpr]YQqj[Bķr|~|3+Vo\a$a &\aa jT2-fU qV\aH\&@Wޑ( <񂣂JW ,dj'
^@of +9aАt5}JBBMS dرof _?"$w$`^P运F e^F  ^F&F~
r_9p(J\& &gb?&b & c &b"^2NebdB@^a}bh@@|c r2gQ#ѱP=`[`xr^aF@tFtbäYФFuM&bb  c .Фt8Aʀt]! t`, c.pёU $ԢҤU+%BU@A@
Ab! u!@{tO*UPu̡`B@2@L\&N!FbP!dR!a!r΀&~ao`艴q6[ktD@."#H!rM0Ƞ"&[aw.0ojgB_BWBOAvB #rsVF3H@Q
"T\ÊB&d&d &dޑ[5&s+&{s!&s}&Ƈd4 r(4chOJt]M2a(0c c&cQFVV!`X!reZ!c\!b	_s$^!U`!ϰb!ưd!`r'vQu c cd~xcFJsEz@ճ):)#
zրգIgcϚ#
c$ < u!W@<@[xø4r1/p س͒@Q|!_^2Yf!h!(vq2cqV`$%>rZ"*F^N'~#tP u^  1 % p =pɵqdT VA2F  _jRͪk1 c[=   j>v3+QOY70PevBh Q٠R6v/Og9Fth> dh  	j  hh3~ 5F!2^=  ~u+!FV!  vƂ0~ r~ttuF))fv
V,ӽPIuuSI  [t
Ӂ0@= ^vA2~ f aF"B F~P|pv^ KF N2FFV~@@._H 0 q 0 FFV}S>e.P>e] vFW3~
j
SCe"
^F&? ur`vP?6a'|)-(/`*V)ި`v迠)`]N)(NA)FU-^cvA.pF
eFFoPjB.
e./^И/GFPv4A.F
?eF]O/`0P 3a3P!3a4/*Z j\&@pF 6 
F2~2|FtFʲ=Ww^
~	 _p pA@PFBtQC>? ~ t;ADFҴD>z uF FWV~NO^BA@C^_C"j(DlD
BN 'Hs[OD ,>Դ?(|WVvԋNA_BMCDPvQ@~(|?W~R
bCt_~@u"W}HB^F&u [WM[} ~\*GU UB.EP9RP!u@H PPDZcˡdK6S&LCOdDabcF*)d}d
OfogȄhli<nDUWVv<~sF
&GFAst&MKV~ʋvs^tFG0]Iu2>r^&^&8t V^^}Xù
 0GF0|NW }Q-A2~ ~}s@NFNywU;uPWu0dz3ɋFAFC&As ffF ~Ћs; ?^6F ~}bИu
gCVVGV~^w&wFIt&VQ%~ qF2$aO% 1q[r֑oђ= r֑>ђ򽐑֑IӖr֑b|r J֑?XӖc@֑U#;r֑$ђ2&_%a% 9&c&ғ߁^P+11 _j_R3(`⥟C
2&^% (K2!a1ajbCs@ABC`ja"☪0誁Zy3\c\ajDR	2&PEƪӳCC⥦ѳ2H⥆ѳaNgӷSGӳC@U'ӳC[ѳ3a+100jgQR"ЬiRȱÁp]at j^⥢"Ю&\aa vf3f   bfQѹ	 cZ XBreVB`@#؃2:&.BϦ``FOr	տȨֳפؾ+ Vwه@BsMm:FBcR)B#8::B:|Cˍ~˘!"B "c$""Pz3>V> Cj6 h#j^a؃ jF$a
CUoC&n>CUVICU=?C@U$#$a,hAo U]jbQXC Uj$%{"9&"f^ffЯf^"`d
79"K׊{!"faA ra $RörD 	rE tJrC _OrH `Ċ.rN
ѩ!	rU
ۇ
S
"jT[UgIii(.3Fq`H;j!h!@B>`WVvAQދ~ &F<t<
b?rDQF*;_}7	!~t !!F&8tFu#|#<ro21>rVЂ^u	A(|`(Ð(uV ~Pfh#  N F;rF`#߀f?*A.F`# F*N* vF}(,P,G-"E"v
u+d^F  w FOu0&3
2>Qf(d@8&(d&>2dు8839)dU849p:59t<:uRQ54 6t &e{D&2P?% 0u" e$<!@2 e% e1e0uF@= ? l\8pQC@+ɉN3 e3`Co3FЉFaC 1Au*e$<?D9Ee% bHu$&p?u|D:pf2K% W0	AHAuUDq;IRBJ 01A
u6K?u*<#<'@M!@Ce&FOaddd dd	ddd
 d!d"d
#d$d%d&idR3O~a-Ff$a n \a[DJ\ 0&&g\f~ t3f&$aFt~u}\O_0+P_tQ_tP_ tu%a tq_`^uBa	c^^bubHcfh}6 huuXjj> f#i if jʉF9v\ujqĿRP- v\F  vB F~2|z1~rF  o]uFbF]
 qcRqjoSlPV3v\FRv!߉F@ nb*J*kNqQsrsVFFn|F؊f|-pj|&vw xݑp~qF܊fkj~zzx ѠF֊fנkt@ t؉FjzQ_vv4}0͂~S1_suF_PЅMmuFhj>h( 3oj{߂FފfPFfazpzox:= Pp0F1F2F3F4F5F6F7o8F9FAFBFCFDFEFF~Ƌvƹy؊GFދNB P$As`FNG&;u@& "3=e sYv呞Ґ␁Pj2л*
-Eik-@I NV,(њ0ѷ|",,첟-<-劆2~a$0JJA&q$mAj)c!@
SeQ e7pf _%% w01- t*-} t-9ĝ0ØĝQ3r(ĝR,aҘLOYkjYLQF$j@%"3Za@~GE2AQ" 3|
/}F+PR2&ԨW~a¡$$2Q%0&a eh 2^S^1PjLFPHj9)ӧssb&_ĝ]% )WV3 W,&^&@RFG| ,3,π ""3=ЃR& FW2ЁI r2A"bW>a߸ "b__6 6 &=  90[_ #Ft  5ӴP2dB}ܯK
}
!) ou	2 j> +6 Ĵ &&T +aV]S~ t'j3F,I  t/ u#'jq@t= tap7>u
b& c"b2 c c  t&b`ul &l <X&a2tI<o1WRe<ej PBWP_)d<"]atV2@2tCWa0Z$aH3+1a1%  AzPT=da<doc0VeUc@Uccbc3ceb^^^@aQͪA*1TWbqc> u[h hBhpRCp2zpbpr^ppsZB
tpgpZpMp@c=l
 Y)$`^n\F&? t5>(u%&|Ru!)u&DPƋV@lFF>3R`(afjfhw 
Y Yw 	Y Y  jdL~    u p3&a 3M0[>R` ctfj j 0`3= H/=
td-
t]-! - ; - @/ o= M - - -  {-E N.0S1 1 5@ۋ  &9w&E! U 6'  VV"P (61L9#8  98~ H <ŐA<;(;(8: 
4f4t>0)~`5>`<p5v&@_u? 4`k^bA; )P@ )91)4BvĴ BІ*3J$wk 
 
nQಿPJƷ|\V
 )d sδvV>
{r  L߈vV*ЉF^ OpK% 
P h
Ph  <P!LNMaMF
+F@F@!vvoPߴ	FL|\NF@jy @s#SFPNQ= UO*PTPXΜVW   3_^I PJsΠ|\% Op^NOΊF
F|\qpӴMFNnXY;F|aUUPJF@PT]pbVvoA U/N fF#t&E@ggh#apppu9WFX@Y`FPFP`@TG ̴tmF"bF?C PFXXAP
N[fB]RCۀ5aPT"t J*@`!B]~vvhVɁg2RFxx* uyU  PeVnR] Ӄ> t@0ur3NFQ    N`#&8tG#4vNً^GF
&Ft^G`2tp#
뎐V^% = @ʃ@A3t  ߋ@aAaOwñ΀> uñ3ޱ&!*;tur*``0KЏdRat~~`F
tBnt"`4f$v
VWOcgB|Ѐ?Vu	ᄪiS՗h$!!U v( rVCuf`ilQ3h>(aav&dDfRP3>>!XZ4M]@t/N@@s*@ !	qs0~x\PTz׃>~OAuI`pS3+ȀS; ~
 ~Ix\~T֫~T݃`MBuzBu~ ~\{}#r}Dư}.P>x\ }' c`}wx\rѮ~&zӴaӴ~1K.z`*R ⴀQ񱐷`zܣй bz\}z\9Fu9Ft4Z6z\6x\ˑ~o\~x\z@4aO 0$~\0\\·r- 1ûVzs  @Jr ·s (~ t9QQB]VAz1MӾ p`F;uPwE@ߘ ;vu_39> ~@ ʎp\`i*HF\&7zFS@b;F|~
G;|ǋv`y >#8  T>ȅJ`Ș>dFf&GW?&Gpu`ΎF&M*+ȉN&Eb|&}3w9tO{gV,F&:t~P}
AFF@3uְ8u m|c} DcV 9*;}փm`~2u̐3&8MtËF 0܋Nu׍\utߋك *G;0^?|,Dt3696tVoz9> 90
7 3
4^&9 ~mҗ4&4&5A^FAFtIPu'9Nu"^*&燿 PT mТ"|0AGpbv
@`ucȿ   iF+F-   `FQںo30J7(( bs^ σFPV |w31FFr`o rormq0Oz1OkFPD+ɉFN+ف H&wwfFf  G?Vب	 &cZ~38tC8 u&3ɡ~^
AF jG
uZN3~({~` uR F;|Q`SrRMf@TVNVǁfv<%tF0u DDF
0N$`?F
吆B]^X"
QX^@)VFXSVprtQЂg;v~ o^F&u/FyWW֡cW}  P+΋э8s$xvWcPN&8 uN&= t1@Ԕ+$fh  ZHfh A*	L))z*f6 l!IQ),*CMcpN`c))) Xj M,vpWVr\tj` 3 ~Bv  j2&ğF0,f!#;~0Nu `8gFU2@+ I0 cPZ)V<)c<E<zk ~ 5pE~h3ҋ? XWQ<o56Ft4ePP.vB="=bPځC<cCGW_A9Bkk @CC9/Fu
PHk`SFBPH v?v.Q.J6zԉVV@,m`1CnWnRMF}+F- %P`19Q.`1$;R<I<7  
FIg8@O=b<3=R<3<T\AUFpREP!WDpAU">!j)B;0Q<fh  q\j0ͨ/p\Pb269u	fj!W`12tKO,OQ<`1 WS!WЙ2_ PT[ #~x/R WFlPl4_jsPx\H!Wjtj1baR?PH- %QtjlHc`1=cWVf!W&'l1q\X F׋`E+FF~/FP_2St
j&q\Styj
P6Rp=d Ip\DPaQÖq\<y{QyQt5RO+F+pt2xjtw`{,ow@'P~"CUyB=IEBzDl!E{St} ZM*=A`Rvtj'V`IVt*ЅEĂgGP@F;v<wPqWImRpXUĂE!|QSP ,3~n,nlwZTP;!VnQ'~&g"{4h!닢|tY!;}{ Z@RtD14PDT3aFF~
`{|&Fި@u[]Ft!9Fk; A]s &@tQE;v}v4Q'GF;F}B+F-	 F~F&Evo;v~ 9~ ĝ;FFCRH~Qt} t~0Vg~PPtOCG\0?
t/*  FY9F}\ ;F~U͢~~ h+F\b|`ӣ%&L
DFF@J@j m Pv@	PQ@PFvZ.@OEUڑRf
1,RH¨|pxYWFuub`vƪ&v`1avFv	bPRO~_ st
+Fb|FHfh ]y1 tDYT,^6t09~ݒ Da+F/ 0m/+FRg1Ţ@ wrmA&O +σQk.͉+`R Q@Z`1Qtj[bBΊFD#"RQj]h< 0vQPZ~Hm,mQ߯Q"g`4f>d
0>>d@dj !Ww 
Ht8-t-9t- 	t "fRH 1^	 qF~ t
f>dF"  F
Pj q!" v
 
]ZP*j ңPHPV<~
;I96&w",PQǥtp wnW/ R~ 	VVmQF
tF
% qP0"D!V#6  tDu9@!3A![ǠA_؋G@ 蓣D@L@+*sHj^ 19>u=*	 PTaPGRkQ`1u(+Huu
@ut+j	j/fh%Q<P
 b
P1f~
 t
1
ZQ[s pE`U!nxwvз1F DVV vv@? 6 ) ]SǛ2 `(1`1F0{@,1F/ 0+RdRE1Ţ
Gз$18 ]2)d q}/?Ǡ'zmK7t߄&P?')m(E ?FFPIGFG 
@; ;NNNQP-uc a֠ p> t= K = ;4 ----@PW
1F `Z0 >d@ 0ЭOy?;v1V;vFPVW`7F ;~F~ G;~~אO - D- *-^@#- @"S?e= Pk'-R3?5S?.AGS?@6- A;AFS???tU`?tPސ-PʋF~9Fu
VVIVF9vu@0GBN9 0NNbF ~9~ ;p9V 9vuTG,< u}N 빋v0|@JI 33 `MBOHIo @O鬀9JO aRVN;̍ Iu_退9@JxaR^F;~mTGai@OHX USWJ4Q~Du6d|HrJ;|Ht;+!<N;v}O;@LA6Vޱd~ u FA!pЭ9v|G|  <9F| ~;]^&+^& b<FK"=!2@3Fbs`h\.BVt ;tt D0 D3nf4WhgP
_r;7&Piip[7Gj0kvkm0(WV o(c c tV@2pU@p^ppfpc0hnp*pFppNppi`ui}}1;F~uo1jrջN@uOwpl6u5#vv'wuwvx60Kxp|>b u)>c t^>re tf0>` tn]af hՖi%Ю+hi0 mu2&jh!_h\0
j(hch\EЅ\B"Ѕ\Bh`_h\EЈ]sEЈ]cEЈ]SAc\EcyzEciE"cYE`IE]֡9E`)E`C2iliЮtjm^_)= Ht.- t'PtF-4tcCHt- t4E/Q#Hjh`t1*tߤĚOd`U}ĝ*䊇a]1*up*HWv
 aPV謀t hwp4&cO (ApprpȄrsФrR؄rtphr`U fj j@TPV)WVV3j ?h6	d+D+@HtHt#Qh !2 {  ;t^ X	
F+HtHtHH3t$q"Ű t   $p &&G< jhz	G+PrP
ǯG>j@PX ^PGPv&ƀ P~Rwrji6 PfPv3"0>ؾ Fп~|`b  bvӿ}v}@j	&8 tb |9GPu`o  >Ԁ99u f   ^f~ t  ӿ|ߊF1	K]	`@	1D	aɿR` 7	ѭҁB^P3&~/ߋtS&  v&8 u0*C;^|5ӳn.F|Q 롢dQ/1/0Y^@? tvN~``"vp(׃~ uJdDFG&9 uԉ~M'22o~F=/5 X=5 9-
߄ -"P -P(Lr77 ;uP< tIf`>tsP6t[QV-
tL{=0J-gC- 	tI- - P- tNEI/j*o@c.d~D@F	po00Mt" uNj `] ] u
^#=e.N3~* ^
ފ&8u	F;|` n  	 Pi
` Z `P7
1o
~a$A *J8fuad܌^]uPa/tP3(]pc0F |FPZ 
t-n f3f нaf}T h ;륐j h}hH]Pv 3yيH]iF!p*!Ht= t	~a@ &~aW齛0RawQuow
6o	o	o
 &
&
h&h@?
h Wp3R 
@
@ Dt2{	@%$&	׎F&a&aD)pdy`wdn"  !(]FPPB@
S?Q0H4lUbh4JbVFo(]^PPH!Eh!:d&uQ,3F
qE4> (
-ð$&$haj8+bj x+
P*
PpfsOV)b}W(] H].h/~a t&.
 w.
E-됝+j
Aj`4ĥ4e̷5 `4}!?"_#$%R
豯&@>m'A4hFbj 躰/)Ua*T*^@j+-/.I/0X0Xp1? wP2$]%  PɰR2
K 2
~`J$*JѪ$KpK*LL$K KNLПJf$KmKL%]r"LD$K`fKUR#*J"$KKQR4H/*=	PF- 9t7-
= Mt%
- Kt-Mt`|[@Yn= d.$@Vd `J,2PL0__8&$]s01`'!_r__$aar_z!_r_ՐR,2R0ee@
u/aKh C,eS 0%˲o
x& g r=,eOa
@4!ere |V|
s!2q5$]~a&]aax  ̰VfhE?h }ڐ|`@t&
 
@vU avv#wwUavv#wwUavv#wwEavvаAwwavv Aw
@~a$]a&]
@ƀ
;rtg,搝V [#P-+tYtcmKt
- t
u]!e`_R_etGo h<h
h Е4`h7o
ZsRJ6K
90fg< gCÐjyAA`̠p@w&
300PfPu ؐ
սrW{+XAGXdoYn]Zf[<>@5P$W W:>W4!ecRi"dRe
j$`hh fBDu+a 5 C;ƻu4&%]o髗ere@e@#tR ܁o>]P\?6`
.\4 b&&]]01
sQ_&_& `&І|3ɻ] &Ara?h[ӣ6qLrpPXrQeftDr3,S
1w<s]LRNg6K!RPJEdME@L#pd 崐RQdB&JQe!l1ˍ`ĎX}ԡ
fh!u/ BuտBϭBtB
tn@
2w
|`t,}`~*@t>_tf PwPwiЯ@ࡔ۠J6KrOT0 EJڠM/ NJڐ UPJmڬQPJLڰ PJ+ V۫@PJ
bۊPJUUbi዇JDbK(ܫD	b+]P&p?pAczPwD`(
*u2⩠PVtWyjX]|xYh?ZT[Vz[6\/@2]
]6]ί8FTz q21 a1cd"`e2 f]  &?]  qB@RjW u{2tt }`m] 2 1#QJ&]C@aR1P0!	`e1@$0sf]f$aRtWfh{  6tzQu10f$af]&%aw  @#(Aw(U040@&W8# @@w&a`D&U`4`U@H4HS% = $ Bu
h`ppUu-tu$uuu	P0HP ǈvrh@bN22vËF2FPVh:u  v
WV 
1E2]HtHtћt-LJ+a%A!a%BR%R
R%g6Kn`"6B3QR3)L)E3y*)*)^C5W* V))35*)A#74.*)U2T7 J8֐)܀t,A9f+_fFP7P7}P7F:F^^F49FFF}8F8_FԐ8D>==  X ƿ -`a -tR   -X -*t:-`a ߐ=Є+-A \ 0\-jZa[0\t}a[xD>#Ht$/Ht:H`%qs%6AEa%c(AE &AEdR'AE`e(1ޠE3 6L'J`"FyB>t)j OPNPfsVt>;PtT^V >u
 6LF S*HFj>~4 ft fFT9vfvvFPv{f`"Fmu63F*K˃~%v슅T^ :uFX.AYG;?F 0!~ t
w& lrpد`pr^~^`L&jA]zA]U]]j^z^a^ t&A]A]ɯÃ^^@$"Ht)3c%R%ACeBdRdbӔ&R@]`abt:@YP>] u#u"j \^}3vlRu c]ffϿ]f ]BooԤo^o4 q9Fߘh~1""s\
] c3ꢳ?=-9t- 	to PY"klr
 0OR^^Qafjj qm~ ErPKgu.2q.n!uDrh  Ɛ>^ tufhw  @kz	f{.|-40
t}}~>_] t0O{j>h>Pn h0"Qr3^b^& ]^F |ctBjr0u{ŇScs >pj"u>4P\t&1*"6]赵 Ƀ q #| }te3/d^ӈ≯>pj"u	>ЊZ Q,jB{t";Ȃ;}B5r`~kJ`t'x{0:"kPKsyRj;j4TpZǯ\pb1d jppag `a!]A`$xiu$fTr|St3hRj<j5Ý51CZ^b@߰h a f{hqBh-Q`]Jʐct1 8rŭ_` ^^a`^b^^Pd^ cPbq)  \a`=|cead!&R蠬ká>hbeP#&賔RBbƷRࢴ}eeN#b̢CGL Dt,-
t%-.t,-	 tE-
tY@ta- t/`C D@]:B>~ 0$qk N}yP4  ox\s
V!ct߲bucʀ&ܐ]!cwtu
!Ԑ]1 c̪3@3  ѼAp@ut-p;>} ډ ڃOr֮/hd2{ s;tXM6q$HtHtܠ$pk''Q_'軽x N޵#CuS^_QpWV3ɀ> N3һ BrQQ@ߋFPWau~S"VXNODt z%&P]}a#6FV^tF&uoďůS _P> uh h]hPK{hAjhx
fx @t\;BL3҉6 o5 )@;`}Fx
r݋F h2ͿRKIBsWRdAEP<R6nf
U~of(dP7v3ɉNv~FV
tut9v~O|܉~* :ff^^30O
GF&F	
u^*F؊F%FnrvBĉFVy	NJ';33V~"PSP9tG;|	FCċFBF 
ы3$7u0OGo}4t%67%L rrP@ 7$	fr^fffE(K)Z˩͠x!,"!$##$r^ t&
ר
!%" }P3#U#d$
(P))#:$0;^3
p
tF^&ߊF.u	/40&$PFP)@)EP#̠xnG`rqs 	*A	\=@0=?	-tX-`A - 90A=Vv= Ms -@At!|א-@;ǡA}3A c= Y.@Zjx]ňO@oAAr^Hr^PI+1&1t^!- 2&s^% B2C  ԁD 3ACŐj  jh

Hͷ> #??? ]
KLM!aqD uj{Q'3
@7@
1'G5o e؎U!^Q75cf^ elS`Tr^7^$@^
P] Po&
_
 ]Y
@	?P7W Rk@6R'ii
'i^@_`i}^z@_`^
@_ `fhiiih^{^rή
>cu
?i  O hE蘈F<tFP2ohvâ#s PF VZ$[
QFC|ߊFeV	`V dG6׋VF$:Fv
ȶhsu(0$
F&vN
U{Av^" 㽦6#c
v^x^Q""y@z=z5{E$P)y0&@zz)fz!,"iy *@zj" UP)?y"z(U,"y"z!^zĊ")P)3#"zo(	,P)"zE(1P)h"tP)n	FR"E5
ёxy"'ґ{*"DV"3#
fF%"6AtFU"t$ё;,"88L9,9-
D";
- Kt ^=9= 9}r>0J?|ʜʶ4DTd~˔˪xO,2xCvCx^^ 䡨 ֡ ȡ0 뺡@ z- 2&w^E띐ga ( d@T;ĀDz-  3 {+-N8)) )@뢟jhl#Б{pDIo w\J ̥{ A(2Χ"q1?aI3fafv \a1'zz@!t! 1'#Ƃ@\a?t& U3ȪȪ1U]ҳU3Ȳȩʒڳt& 
@a@t&fhtau肴^׺3@7^URxfhch4P
*a)"Rՠ0tfh/c-.h,71aV ^ٮa^ Rp$^a%Rހ4c23h1wP
٪U^RxRЪxR7a6WnRx\RhĿxHt`bt
 &}@bt ߀&fƣĀ&`@s@ut轲0#o;>  b5$rhDh~ s|^t\& *|^Pe u$0 :3 j hvh8X5  t~@ p`` xh|9  RP  j 6|^zu.&`Xhj`4&pnx0#|!&z; 'F2 Aׅw Ǟ Dt,-
t%-.t,-	 tE-
tY- Htq<- t/=C DI`:w>U~tr}p4  #|HRnVfvfhI?
  -hu ph 0#؋F&?:tF&<:uFF
*0N&$pt
uL0jnUF ~ uF	 F
  

1<  svx -jqJ^P2#CHp#` -p
~~ tgh~v~ tDW=Ф=u5w  @0 ^3 FPP`4`  - rF9Frw ~F@3-
 ؋v v sd ƨu= wA?Ґ(Ӌ~sPCѼz~`(~ tFaz+q+  R~`( F, :, ., ", , 
,$^
~dz$_tw }Q!@PD3^@J Vy.tC8u^A9GC8uK  KV.2kI Nr{9~u r W ? C? I rh8FV;F^=uFlsNBB'sPwÐWVc$ < uՒ@aF@<@uir1P hhw茹"t1g6g~ !8 MK[3Luu4!-q6Uiꁣ!94~^E 9] "r	"V"WK^R5*6F cp9 F*Ht
Pnl0 nm j菐 @uf4Ϫ@_;F~`alPtrջN@uObhlhnjWV3 ``Wd0L
G~Prx     : hMHzhKBh SIMPLO  MOTOROLA  HP  1.0Dhdrivelockhl Computer Setup  <F1=Help> File  System Information  Display ssoioSave to floppyDrconfigur2pr diskette Restore fromrusHv'uudefaultsyqs  IgnBwhanges and exit E~ sn withou>{aving}Ts}~ Securit0sAdminist tor password9 Pmse a҅Power-Onw'pR`tDevice $'d<eoDz'$q2D1lLlvsmart CardmUsupportE?mbeddeLtay'e6uetracu qpu s4`taut?hentic3tÜcred1al Auto!pcTools BauCalib| ~ lect@b HDDmlf-Tu opAps Act+iv ˧OvSupDusqAdvancueL}uag1ov¦ lBoob$vPres~y keyrs ue F10=, ES7C=Cl 2 |Accep߷=YesNo \~, Ao-r1=M v ҼEn  Usrarrow1Po highlP he appropriqmenu io1~p<ENTER> rbegis!q.~ǿfollow!s n:h -> PSPACE = Nex~@n-!BACKeʠvio`6lhTABfiellSHIFT+zl@ʣV C Epr This^cannbs~եd An e oc  who .֠sde 0x01 PevnĔ0q`plC1requiaoap dl!bam9upmovhr`e k/MEUIְm1ٱ pBlqٿ2+ִIcpmles}ussfulaManuQr  NdPr9oPtyp0ogspehtepprCacize (L1/L2)jem R/OM R0sRpfamiafsel nu0VideoKe'yboqrPmver"DId1234frafownhipC(d g O
3Pdosd9aBSN	%$ 123MECV___24"TV$&zD_&{%*{ozS.{/trFrW7arn : b@L`ll0z o` ͱ0s ofb6uTreqa ar/y@u,65lein w@ab!otq<r"l A: 2;pU= = waQt0ztA;t< p$<4@r@Inv8u2AP98!@ezAvgyoupJwapto  u7t{:s?-}  i_}q~0NI  O0Nŧ Q R1 (QuickR2 -(amre s@lU3 (S.M.A.R.T.) Egsti p@exCtim0): 306a @g.l0%3TС]t sy hoT3T<uph^:1'tX撦f-Z`Unkn0@il`W<CcServ1dRead3?do  ~a؄ d!ribm: ʡ&exq3 GWk b!.So  sOlДNewx=Vfy np ";En#;Off O0氼  53 Pp?}Wro0e 0 ݜp30 qu%qޣr{ypcauspIýPE!;h   aޖý6  .o(I4!M loss 6[YJhouo1ހnl"cof aAgo@FZuu`fѴev0b/6DoCKish"4ed?Ssŀf08a$ddi0jMP"D#Pr.Wu8hTQsBk wpJ nѮa@Rm0`8tS^PO4vsw@`QDYPOnrJ {3PӆL Ft jf ƇTndJ3unus!B8natartiDfraPara̰ԴSD0uSloqjAt`lnet`pM JiPiFn+F2 :pkt CD-tU=ټCBԧa@{ڿq aGbouKC:h< u⮂h1ϭ b`7USERMASTL7DIp0anw&cub5uu!keep iaӄeph#ys0p0!ehGb mpkr. IBKLg,7ǀn|un  < L1{АxqQAutoQc_œE`d] @fx_ɔ ˫KO bp(шZ!G&,ҐRurt9ٰ@7th?5sw V k ?ersd@PerpV Yaff@DQJ[a,s7sibmaigi` I_sA wlr0mm@P  |u0l7Arepla`@  P 45p<@74,w/hG )Аg	BpFmer,4h  iP[pibjty. IfBKdo?K7Q[ESC.at* JRytypLu'F'a5p47F102a9bMrmBCy `x"  +E &.& Or :@#M #'ayw(XD@jb) (leCftU*,Ph,USB2.cC/HB.Su 0Z;ipFirT o pFpthvjif@4Six4Nh EA.P4N<yh\5Num 2 @CҼ Swa}pp/Ctrls K#&U.SА⹠\P6jd`
ct.legacЃi@N_is$anP`r0Xry3@Vo  NTSCAmLrA-JA-M!}qIt 9BidpEPP ECP@ Qsize 32 MB 64G  oj lway niYACè AgB[h0gt Op DR<3߯,+`^)N+`U(EqPOuR 1RT2TT3.OTokRjlT XXUXXlWu0lo\2]3NUnique IdfȴD ke`c  @Dtuoefg Sñ/c%CalCib_hcNAsi1jk@vP Dy,ni/pk mrnLbuixsmzvoOB }qcO|oxoH }iχ{mO~LL`, MEUiom/OLRA.OiOm/L[dp1 : CPpg 9.%% ]%MC0le21c!d٣e=Ƣ3@Sd XfǢ*@l Aozr-	y<s 7P=?l  Sp` 0$hnolGogyWw(.L=FreNC>5`adap"8'CPXE RPL Ex'Popup0M>( Q0 10  234*567!F12ʿ5 15030Ău;BP3ouchpaP;SLpNonp<F1=HiOlfe>` iminPɰnOzeigPPf00 #peicV [ K1guarVwie0((V!p?n\vnEDein"un̔O6D-mkzΞю1cր`ed"!nt Pneh0ܷpߕSetSheitsfunkzpXn`t ۰5=n1lt-Ke- Gertes6om-ID 0e?tAU>stgtz`0<r h`abz`  beim m7=o>g71DCtu`
P6Unsvorrr/oՁzurck #z"B۰ݠ<fgs00['Ex0eAkkukEKUt0<!sgewhl DD-S/elbssOtivۡO37!eZp̳
1
0Erw<SSpraU8a3rt-Lc '%ine$lieb Ta0, 87@fah=Au, ESC=Abb
%W8&%kzeL,&%JaS*N :Ή*, J#=Meh{* Ve2#z7Mark sMen# dP#Pfeilt$@*!d"4`gabe4$m`kcАP  .\0fo1l֐-b.n A1eہ#8:pc->= Cr Le4 = Nch?Xa$><-#?Rchritt-b.@Vo1$@cTabulCD@s Feld Hob@llC+FCge2GcL= p_K"OEscC&l@_i 
 kanuFtg webei@&aq#Gr1ogetrn.V-cP 0]APSRؠpPfit & kqVF
4toU#W
sel@omv orb
e	rlDesk-smu[3asQobzw.6Mobi``RV-g tzET.a  `@
Tܲ	U/VOWbX2qadj^lgr ab gchlos ҰZ-AllzWtyprtP0w ZigZqBR ^artqC-`-Gre ?(L1/L2pwkapazit^`OM-RszFami- SC`umm  ?GrafikWz`0z
;r-Con]!r1{`aBɠ$7{R1 m2? 3 40Qa|	si B(O(F0`x ԅAOh"aSe
k rR@~bRs Ћst bisCna$E4=#qa-/Wb0Rle1bBd#
 Beip00kL@`Tk A:&nfkפl7geK#oBkMpg`@$`*qϠ  ?0W
OM#wirkQ_6G$T?S Z2#>, da1#|qie` #6O<^` 1 (un02 (UmfUaaqdGt &fhbadau (Min.):G 30!dnAt .&O0%P`vipwupm Ho`k gipĜubrH'k: SdTEUnbeS@ak(StGrvo-L`RtFSSpbpkhafqGAttribuIDpCXkuvp~S.M.A.R.T.Q%' . As NeuPsya DeatpP6 Ja!@A,m5t FalfgebL2b5 ^w2X9cdminP8ox^ Dura@cB?  cT mgQ_q0is@s'd, a 0hs њ.Ђs Z1lƶj
Q@1Ven ^lP.`b scnblr#s{viceaas v,B0&# ^ gpq h6:DCg)a j :%s%? UmY FunC9', mBevb8!n HPtect_ToolscPty Manag02ho@|agWADca-QuickLock6SuPndsoI ~ yr M_fi1R8bilQ̓chutz  f[c05cimԖ0q$ A !2n  P]
~YrxAr, lnpsZcDSmeh U:PI' @({YBq  Infpvot-\5Par@e.5pDr'aht@q~N0ne ":k"(mfCD- zŒ=@79Uv(t$MHr6:in$㋓CmT?rive]Fp@IЮӢ W ~$B
 ~{s D-3
Bs m0wеGunbra bar. yI1B,Nbew
s@rY,pϐl r O0d@lP,cFJiI, rcB1eg,  М]LQ Bn0N&
DzBPB?egriffе\drautom p:EF G,(ohl&$ ai a$ԓzfg[]0 aUIO/jQRsRmRn OUSe0UN fg&kXqz硊JG1D!sGnP)..ZP! u5\XEs @haSihcF r еbDȥ sbIc5FP  Xurpn7HN ޑ. Esdr<empfPf3a dXqzuA
EPQT. Q /`@' .0pR6}`b W`ǆ15F-B2n4ra
"tPtQHant U'F7dEa<paEsc-;,Et&F ȯ+W'&F'F@[& F10PĜE:Bfg 8gبc$ 	sD@`BPS ͐0tMuBayU\6¦@
k-E#P	"(links)ĸQtUSB-N9Ƀ>-VGƲSu@Zip 1P2P3P4P5P6P7P8P9PNu[m-s-Pt` ,n/Str	gAtP@E`B (USAƀ1fPL-Ze zTradi5݁+In@Grafik-Contr.PrimSek!Video-@
7r[8n~Bidireal GrБ<5As g / Lfi  ";bSieb Aggr@/@F Ezpgparf4,capfe	1ve=VǷ(o)!uP?E`Gt 1/p#2dp#3ToqRo? <o R`aP1p I+k2) Akku?  
/>a
 KalibP2hGMkּN"1Ƈ
iualO A~?"/!&/ K/* )?.# %/-2/(%o+ H%?5^6o/%8^63 Do-
*/@D@o:CH>CLp1obiQo=6 KLu6oF/OOPu63RQɯST /WOXR!Z[ 3[r 1 :@!.c% ]babmlokXe2PcEntlc b)hcdifXe31h`PhncOkp-m*uaf u0N%G_S`%
^|
Proz or-p uÀ- Legacy-f`߃&<0radap>BootmࠬzaExp-a-Popup (`.) Wdau`ߡ]dp2 (Zm ZBe K e
CompPropstn` <F1=Hjlp>  F~oplysqVis`sne G&ti` qkonfੀۓGendfra mq=z Gr85T:  Iognor`ߑn ovfslu
& uRtt p`מt&newk0{hed Administo0ّsko KD aԨA foH䇨xE"@d0%*e-ilcᲙ0pf*ڭ]Sm-kGodd7elsf dp@ndbygg@篏ds 2RR)% favks4l% UPb	Pʤg8ɻEĨ	sIkƸ%Baq uΰ d@valgbsαRHDD-selvs t`r ѫd
r
R_ Avanct Sprog VlAs Ok[oŃ̰~Tryk p@ tGastR`t@􁚐=!, ESC=AnnulRFa$={JaNej ҥ, AQb=MV Brug p~Bᓰ@0{e  rele0menup,qtT<E?NTER> Dqe+Ѻet.@1f@PbЄD5 x: -> e MELLEMRUM = cN)Ae<-$TILBAGE  rqITAB&feltSKOIFT+fI= Acce 8I aT8>sfejlF k ]s Dodˆ!n. F012	Qnoс `pla`RA	krv tvek`Ógi dӕs] fly sPen<0
/MEUR% b uvezptbrud}O	o
2:tvС0mf0Gb8RducPqcÀtypG!h igaH!`trﳺcache (L1/L2<p$huko@ ROM-famOilieW i0*CVofR sr-c_ontroD-ba@ws),d 0Fe)/2?0
I31
4
)fa0wt-tapfej6I(at)/51O93:045@,5@Ћ0Gަdvar: 1Db1b s  altГpB@holdѺPu 桡o  ֱ/L b-'d1ydⵗ,r B1kQbeskh!r A:@@KBf ¡KJ}UgyldigFlrԑtF  _Pngiv&u,pHvi0&<?_ is(k?ۢZ
-_ T0e(Hur#)c0Omf)Wsl ` ( ):G 30`Ҳ Q 1rC0% frScudQc25Pu)khl:u$j0[҄bEoUQ oS8JDrerv"*nLsrrib?ut: ID TC,S.M.?A.R.T.uy.S{ CyNyz|ft; n\}Deauo Fra{l  EA!HO`" 0K}s`A# O~eĨDゃD!pǯE  beviYp[1pv Odes, f. . ramr a¬.5ĂB5zvcZmeptabData. Du bu tPflpǑF0 Z|$ viceh PDBFpZRH?utSr {Ci HP  tectToolوj[̪ Quickppau'Lsv+A_mɻSkrp뤍rjv)tCK,A_$saqb/>O HvisaHAa3m@`A
G̐'r,diR? u@bil@K¦ja!Tl pЩfrardCiM!d;lnetnp͟KnappoC?d-rom-`gŠɣrGBW SHoø:eQLuÀ%Kh4XG,!r YDr.  bЂBRUGER-@_OVEDADGANGSKODEN,2%K\  alag1, _s nPra  opaaYQŲQed pHC[ցC l${v P_o߱@YD_hp_Wutom` p佺byga
!"lk? permap3an@`ig{(qnRܚ l fysdsk İVrbfpcn o@ 
  
ՇInA u}mG, somf,IIa /cȓmtt. Up$SEB pYp	cI rioYFH#  )Aabefal kraf#KzFBo W!RZ@;pl.  GauZ9CkAl" 
3.+ b?2BK	u d i{$ux
HuZAOa.vNAe8@tryN@gESCP=Ak. Ee`f%HJ orV  ''`gIqeP& -F10v X1c#&P-͠A4sD`sIC7u  aiD)k Oîsr flgpk yD0됍-basG MultiBay (0"eO=d>hj!?USB-?floppyGƂaAc3`A<RAsqu<aAzipFrWTr7edjUFj0EG`e SjTSyv Oe NiRICJNum -kipmm Fn/Ctrl-qz:Eal(ua`isk)@u|@egeen@:Uxst픶:CuPnP!UQzp0rm-cexr PrimSe@dUVo Out ParaXx3ĵK T0jStrcohuko a BqltP>d t`]p$nr compuPzQY0trmDӵqmstyaatic!0Аcr= dBQ`s?=(>GtoppPb>bwF?bEthNt I1+df2ogg3+dToA%R\gHkh Hk[jLgphpPjEntAgt id-nu2Wd ~ yгA:ovwSѰ/yOzo{J|IbuP:Kalib1}?n
digo(S ԅK!`7>? xωo͈2>b- OΈ 3rp_ې?܈H!!gsK?@ϰ/o͈V>i moY=a(MEU) ZϺo O$A?pL ?^ɌVɏc[ T`_ 1 :3 O0 .P:% ]0:n@nemtU2Af&Ӹu؟3Geno50s\ * y !⏙OϗPro?cessorCt@/BB6\  Legacy-freeKXLPM(St r:HurLpopupPsinkr(sek.qP53$p32U-QPG 0b% PQp@S Konfigubmas?  <F1=Hjelp>PilTinjonRPVs( srLagPtBakIHepfravjo^ LdiO5SjkQ! ag avsluA
Vb,*l 

/
[sprogra@ZlLD(t !padPbaPbOp:A7pLlUyrs5(p6sf'unk
u0StifP# t)!
"+-"x
$Fn SmL!8XI
u(godkjq_UTx(Sneby@P^	)x
i.trtz0!Tilbakel#fab PP>5H)*4 *)aV'rkty f0`t vaclg)!AlS`p

%D]vt4 AkR@R?AQ=@ّD0>v0PeSprA=lg `pH7B!IIuB4 Tryka t

1P =H, ESC=AvbrypARQRA]p0GoTJaVNgei R
, 
<er=MRjB YkNneGpilY6trP<ENTER> hv0 du vil  Nt. BrukqPn\^їB:  -> e 5r MELLOMROM = N43E6 P<-ddTILBAK9E`erige*wTABfefel!>5xHIFT+Sjhxk#= Gox]iRg sfe^F0s +k``с"nop@F ` M0m kjresqvveaAm0yd*tBGPPypG1ba\paxflyPs20( dd"s`{
:t{aZ~=vPfullsq. akode 02Yr  a2s@dupt No0blokk-m0ll1Ptyip`uhigZf-Pgapv1ޔbuff(L1/L2MenAg@P69Qwe deo-p
Tt 0r`trod%S,kobP6b|b4I,1o;r1/i 23o4Ddi2!,ue EP	 
8\i(QŰ X/ALfEk!AdpA: Dvs0slAr tidlPh2hol0\vHaa /h"e-  , Q0FuP sL Aklk$ƃnnP A:0"sw b05reg1G"ֱi<uxUgyl`S 0f(KSE3Fh kPctP4fl?oYb3qv ignob_tee? , HCYT4(R)Psl (>P): 30ᛓAfpvgنm0%ƃstAcv 0yf҅Va:`0ut6DCUP+P1sCSe's٠oL`#s)Tuyvrib: ID`e01Wޢ+sx S.M.A.R.T.-ށ#S.  GNx }krefZAv WP S@cbU&aIax ikt /Duax CQrAF)_taaB4ka9gxogsX8B`r dUX<
QympelEZ6
 X 7Q+.z4!o56rҮQױ² YpAԘ:.  bfkuB4  zm0@cU&sdzGvice.t)u$O 0ElaQ?A4v' !C\rt i HP tectToolscurity Man0r.5-LbBl:flan!ypaus L`}m@0z,S08	֝gieX besk!}Aԅ-QD- [ȰX29y  . egleaua`,Ү b"[8 }. KmAGp-.frard-)P7ara 5ll)~Trdln k Knapp"t>-S `* CD-0eA;%0p Ho z
:r`ed @FpQP@ \h`#sdbb@BRUKERrHOVED-0:AF umu!6 &~@@'32-1d;bqbeQF v0] 6e`<Ac  cCRb""B#f0aF'# #::,a^@&c}s  0 pp x> <H`56~\ autom@z0NDa2Lock8A:byggAD
Y%>?  @maчil-gPge.q@ ;X/AKBC fy
s!Nad x1F VDHAV I 0&]%uL?M:&dnPQ
}6u~sQ hZadmda 'S`S%. UBbvom[d0$C FUqGr`N~0n\JZ` u&\Vnbef!a~! 3" 
tP`oxXv?@{
 A?Sk1nQ+r?%"stu pLa0Ogbh#b 9
r?tspqatRflans@B?e"f,b`0ƏESC-GR ߑ1`"'S'RNR F10%@)Cbe:z3 0Ս'4  Norp7iFpOre0 MultiBay7FC'vOnn(vee)`ko`zngsb9a$8hy?RUSBtë0|7ѫ Zip-A A Num !T1t^BQ pFn/Ctr-l$e CEq\0N(USA) lekeenPUa4Aԃel0*0jp[trodCeo ׀2p:+T3isArr@rϡt tip &C@m AgssP@sty<1a"ticaQY!  ve=0NE<ȣ (vpbġŀ@ Et!h`w1hI2h3̀oRʻϿ̻ϟΑ-sq ЯՐҘΓnipYtifik2.B1ri/ 0C /N䠻yCmbuKali!bE1;Bes?=In밾Cpl PA50p- >oo턩 o<`ksp.AO >O Jnd֟
zO
/O	 mob. > \\\_3
Q ]β[ T: LaE.j'% y]m&fullsҟc&2&E&	+Y'M(j,)(3&qiiA\6&0n-_2A\)a*6Q)  6=#;Prosdnu2U DH:d~UгQhnd@>bit@]Im:ѹ sinz0hh (sekupr@јF1#2-hFQH.PȁS`epute PеpConfiguraci0qe la CompLadora <F1=Ayuda> rchivohmMl 
ScmaXdPPaQGuB_!qisco flex	irTczMnTK RkaM`/s!uTXKV/YKZvaloupfdo@ZM^ca@iS Ign O Vambios ypli Lc1N+[F 	gU3c U<cfc~deMidadQMPRseaO WM"VkAlkicioom]pk1N posi;qsstIdcMShq pNUwakpQփbxs(n-|[sSmCCB SoeTc` _\Yq Sec0ktyinc@ Oda E bbWet"xusX ]c2pN+[0xOfbr9aLЀwc^nci2+9Automa 	HerrWamipaCMerxS( `qapaP^prueba HDD PcZ aNߒ0p]CpQq]&Avanz Obdi@j5 RԢ)p}o)8tߥ/ _OprsimЌqui2tecpNa~in0TH=H, ES/C=Ca l4k|_=AcepE.=SN0qq."d, Co=M O U0}\chfThaalE  lempo apropi`PiК1<INTRO> t`zpZ،ryn.sMP^uq y:(EspMo o -> = Prx2+jRetrocesa<)-kMa!Dio8TABScp0q2Mays+COȠ IDGf8pӯFfErrPށdWo @at ] BBVS@K=rFjo u WSMQW. CdGR01hoay n7unL!W!ubnpĀNAc>eb!<D220c!o% iB@ebook/MEUojI7a6Rq^PMb?_q2p̝IPpleN~xitosaae Fa"!R`S5atil TAi@0xл#mVPUcvlGouQTama5memorp@zh (L1/L2JiҋvisNRwOM PmilpaS1N>4riaSvy0qV4@%QrklaORS o߅Fb Hg1z2z3z4 Etiqu0!xrspcһev(íaJ
@'Q?3o  ZSE sBa(T> UFEUAdD0A :ðAq:uir-  1ne^f3|\. PreZs\$T/X, in A0s\sc 1Cu^ vA:7|\{#4NUU- @ PSN0!~Al\4G-s#`tegQ3n8,s#)A1P^vlX|#I+W/8,o]` _o(a) p%eaQ?_a?bAB iBblpc,cFlh eoIJP1 (RpPk)N2 (CO3 (S.M.A.R.T.) ClcuNctie1j[(@o s): 30M@лg`o .0%Nb NqapUxp^^ ipalNi'rumaOZ[B:
 2pu ASQ08^Fal &d`8,^Servofa 0P1apoyaa4catrib : IaDġC exALgs QY.lop Z{ nuevzqnDp ApagqEVSw$t2F~l5evocMn wala oou LDm adi!0ZePa"ce`	q{ Az|R_  &񵛦,`A!]S o,qai 2ἂrs/FpkEai@B
o@Aa лAwp&Ar0sRcinR S$bxf2"lXa% olP:HpR1v +v.qoߎ   qPCƭ?`f
HpCa+a&d=nAin HP?ctToolPz~EQuickLockUSuspen BlopFdra%t!lSqo@"6@mejpF\`Lw
r༐y	 %rl,t&B,&V]p*-u@iz1.:tp@ire Pu$n r'ojolTeC<RedalmCBoq@rI2CD-2<EU,U|.wPU[:lUs"io:b꠰ypuċ6y>6medi!(rive񣢲` tmRUSUARIO2 PRINCIPAL  B 0e 6_}nman~ p@A ֐'. A >y gua@0lugFGB.  pyj_. d#˫Rz S_!_1~ &b5> `0?ׇ"ˇ+:2Uma @g`[orpAl_6 *'URzRP6 & uO- } 9, fsPm@Z&݀Bazz/C, U3M/"˪ 
Pqu@iC9еa`scu:1b@t	Rf 0%mBc am2LdaT4k os4x:>orig!e oenfe
t`}_ )lic1B160freazA2_3. _k 0f2u A~q6 ~C-0qkDTq1inQV{ B#0u
Rlfip`:@\iPqCponsb P1X#Cy, fi[a ESC. b G,6cY1alab6'' 9 Ї-F1001~RDQ':<{F[x
~r|f aY@{Q'xR8TRYWEspaol O"#Mult'iBa1PTUeE=>bxc9o(izrOtB/C(echP? BwRcID o`qISuրJkbIdeZipcImeaaTer0o C0ts PxOSWpti`Ovp3NopDpp1l #o NumPeǦ C|ts Fn/w<Tå<Ingls (EE.UU.)qJ r@!xᥱm`>plfA}SoA"Fler0bIV|@Per+~Cnte!NQɁPcN_Ï0eo Mo `Z_  BidiК3 Tsam<Qmem"x` i#]v3si fuPa $bK#CA0 erg!osQ7Y Qp BF@F>(=sQLior)noppEth]etw, NbooP(oqot 1/uLv2OwLv3oyoTok R!/w|Oy~o{$Er1_v2vw3 I@=tifU?ExclusШACA@l?ŋ SqSˋC1 9o-N pY /NoE⊉Eh	ޗOPk/ospb> ͋???eEA/̜ 5aOϫ//kMEU VD?ڏϼOooϻU`SrG@_?r[.n1 :rg9.@#% ]P</ϐ] <$2pc@|5Cle@$3π(@2,|g* 9f !_ԗ¡Dha N9QNProʲ#0sQRblqSа`l@R"aL \cy Lrran$qS py]@aD=4Dd.PNguEx! DNXp3F12EpY5ZA [AmbTouchPad@ u]o N!u8@R'@aƀm  <F1=A_juda>jrpDQInfo 6Zso  o SeIia]`,mQ@A5$iRrP t67  opadr0 x!#e Ign@l]airP`5ss 
f
d-PnaNnPa :#v@@)@D8r UR)_` "	`$@'j<"@*PS^td1L[aTl?izacPa0b%O%$I] fS])]9)i.Reto ,5c3UgabpT`v&autf 'n &8 @eh`194X&Sima `GaFepMmCaspUbgE]i`S<@lecOpe T0iD:2]HD7D Ar /?M@? Statu 9<Mu0i 08>> Av1h	Su> i:?'(/oIA/KM^ess0he qPU1tinu@U`=HvSC=C *elbaSAce=TbSimCTNaT, QQoyuAER=Mai` Ufiz@s R1D1;1d o i apGropdp;uP#Q<ENTER;> 1me2jpKo.Zgu1 fr utb: -> Y~PTPAO =gxi<-1foBACKfCEfa+se&TAuBfo mpojSHIFT+kClGjja=ЉU
*SCmT
Er`;Wp,=na'o- Vs&P<. Cdig\-0;o 0}Nu#hGu Q0Fo`q\x  {sԐjir;uCAc AHulR<evCvnsfj"14otebook/Ó1Xt; 71;p:q;e?w_xuy2C+t;@#J2m xit"(=N  Ti0n(]A}V (c:Pp	@`| Taйhb	4he (LO1/L2Pƒa^{mD ROMvisFaml0>p zsriRAv;de:VerdRroARAn}q;qaoouD yաơ34O4WtiQe`pcZ)]e%/(R) 5=yO 𱖀EաsecundaRTAdvert7:  u採-c 0]Re!dj{AcDe:/,0Jsi um  gravvE 5u9:s	9MA: n fCoiRp
N#3ĳ0 7BOG Etegia0JvCl@Щ9IŔG TtezBsejapL	?/
a؆ i_
cpN ~
_B@1 (Rp@1AҀ=nv3@.M?.A.R.TAex0 E@g(p.): 30@ 4U@]`C.C0%QbA
ucedr\R<q(hostr0rAs: IlssatK@[EFalr!h@>GKJ
r-mecPJL0FUpaGsr&
Gtribp:2 DfysuexaapKct s .tPjigFov" rЂH'r4Al*@HL
  W W(@~Gi3rrRigUg^cisIgQ @ Ai|a`modsK	cpv fazqv82Y5-a,a`:6ErU^$form!"7a.JJ,F/jaC	[.~dڣas8f"3`usaA`erJ1.Е- `A %@fs-rvio"Iv{rQ?&"AR?X5A"{ urr!)#ad`J>is Ђ?SNu3QAMQuickLockЂ Suspenso #9Q"@u0`5S]5Apc!} man@|[IYJ p.^JJ.() -Q1e\sa@c?iibZUuseuExig55urewLnPo`vKL& er#meL!`lrɌRe2vы1ota!0P?CD-RGOPhT>a:me:usu}: Voc`@`F5qr2ub oDriSve6gE FttUSURIOU  MESTRE,I\S t]3>0@,<3(apaz+ . AVb0/de-u0t{20is05(!-Sqp. N@vPDFfe Y,iv,av%
 Fb7+\dσa QhY.8Z@@[aI+]sQ^a7igoE")9?:IA )- GIdvfisug[AjEk#o,!2mpIn Ca,er@%8aoIsitOvo{w5?W]ado˂d   !zB(quR^}@wb
2"~W 0g 4G Uaf H 0n,`dgb^ pqB5;ornala'Ee`-0QG  pqCڢKsatc`Ssubtud id.? οJ&2( >Q	-l `!vi@R^54&Q^  ?Lembre q!evma#-چ [saqui^s`2eP)8 ESC4.Z5PpGClav'^'Bt2#F10.pђ>B&r:'MX
ÕBAύ
$" !Lugus O`F!?: Mul_tibayxNn&OdBa bya(5copl4((-oԌdiJ0KtDPpaB 
2]R]RzipCPrimeirVrcCQjtQ:O vNp2 
c@ A  @k6|DpTq`8s Fn/CtrlLIngls (E.U V4Yi@si1[1nS2ڡh8
tro8< vdeݼYa:cunda૘MoCNP7adrA6Bi1R2LTafhme#mO.pZP fu*`p2|Z.ec CA Vere*agrn'ergpe8XrYnsu=)/nհ&Etnet1Hַ23Token Ring	O P?
+Idf`K5\ BaQa!,O!Sts0I)SICKbQmįP$ˀY4gem.SpRlʱxCQrDuwploted?$ ]%!'%#! o. 0#W!	a#A?&67?2!9385=Al @/@1;B5p-MEUAHID!LGD AIJORM/NTOG#[ Etg {1:SrregR^9.c\0% ]/[j#+l 6]2:!c[Z_R\\na^E]3:a7`[eS\\Mg^* kXW^  !k_!/*[%ENIXs Nmer"fl'exфc `ēQHBdaApbꡕRCPopup^ Exb  ֐0'F12`}(P d%s Vsarql&a Nu0!Tietok	`tukІ <F1=Ohje>@Jrj tt Nyt jTallenle?vykkee`aZdk@onpoʋeP uP֋t?o^(unSsg Ohħ mu 0lop^L t
RttFϕl$pou P=QurvPisunvojan s sa>Mri_ KynѴy t4k Latlɟ tu2usnuut_-t lyk0iuƥЬmonuki'aǆet $utsRǆtehd@ֆ_wtpRjA6main	ǯ#TykaluFAkĠ/o RPKiqa0 Ki PvytȰpO1Љt&1ŲNALi{shieliPk2ǆOǆ*Jatkainll`otP npp р=, E?SC=Per@տ=Hyvksy?=Kyl;lEi ?, Joku!Uס=Aΰء vnouolicmi ݒk@0hĐsisQ <ENTER> mKte.ņn 偾ss seuraav:!_ -> i VLINPPIN = QTs  <-rASKELPALAUTREdP24	ARKA[ 5VAIHTO+''T<S= d'_pXEvirhpAkkua eoiOuda.'%: Rdi 01@ka@P@a3rt$ pytkeerk;koPtaasi@1? lak sP"`8Wysrkann laa𳀾ikkə@skeytyi enai@ ƏE2np2
o(!qmjQhiQ+ ty'yppPn÷allVlimu "i (_L1/L2M@  ROM-P@pѬoteper	sarР2 si3stohja2 TK? pРkoh _&1:<!2$	3/&4'	#ta	oc#$+v(joa)W$ *%/S'0(*N V*JE1kra-7o s:_ TmӜalatnh ;S. J t luoOupҿuos-  Ջn,@irj8ons>A: L@SBSAAh@uBC@ B?=@,  panAB?_=4JgH<ko i0!`:n? @{MN 2O  R?x41 (ND.CX2@	Y3`.M.A.R.T=.Arvi8$ (min): 30ǵs h0%##`4X9oPIs׳ysiaȊa$beV
BX3Reu`{@eK?*iServomoottP*iLuckuUtuZʄek08ttrib tiRhpPe rk 	av Zoe`Ke n .u!p; Uua%Vahev! pv P9ɔsixgyz ݖ8$1A2Sv@0L{?a w-S  vA9nOokk`@adan /ϟ	n9]e0cuy xĜ9fmys   kD h 촸P 1ҳe<4& 07pTN9;Ri ?jP<L uEn$ny0_ =veapahtum@B9=id0b\&Qa.aBT\kԔ@	tii P9fHP P`ectTo7olscu`ger -apQu0.}-ӠQlQuick ynhPl0Q% aFrQO0#raAVQ-φʉsekF /JiT@A<d;; ;yh k 2 s 粥f81Ʉ.7@uu1@Spor In+frnRB0Lan1ghTto"ҚinikpmCD-- -nlѤF a:D:qTpP{j<0wAiotsb?]n D leê(8n ) -.ﯸд KYTTJN|IaF PS?SANAN,նXC"].iaIpf@silturqr  r0wP>tVԒ-P,A1;psNuAGVxgLLA9gѾ9 Oq%@ p  2( su@!IZbF߲ɉ,ty韼 F٠U_ fہ܁ J+% "Ы. Nyky]DE`D\ EsQ7FMt)\1. Tt dgDp99/
OsiheialkuDAXehf@p`@@Gu@2?t  Cta@ /A	
aiem0]~נtD. zF猁mЇVdyt RpҧRpu "я,˶a4z erP@ahho!ׄ<<9SA,ܐESC-n2a#<[0n,(@Հ''c1< F101@|Հ5d*aa R):9 
P7 <!(z_m1i{#yŝHn MultiBaP)BwnAlakoiB (F .en!Y/EDFoZUSB2I pI2IIDAIZipJ?Ensimm@2 ̰Ko eljVi@K}eit 4 OK5ak YQOgKymNum2=p|Vai Fn/Ctrl1ma(*@Eng0pZ(USAp[UsPP s0}inla6u+BIsYQpaSndqjЗLsi\!s]V@olhVt YVOakioPsA.]Nt1 q\b@uupSSr1aĀj V`s  lp2l6|Bi`2 optical device d=mJk YG (ylosI?oWpp#qoj>BEther
.G5u 1Xlovw2x?y 3zGTo
Ђ _gw}~ozo|Gwork1vlφB@LGlivS AkkQu!@TAJc``¿ԓjoPolibrYu _ߓ<doঔ1ual0C-?/@˝qb /O!Ǚ ˝.G/ O/Ǚ/O/˝PvaoĿo oǙooEސ)aa+nusQk P F$ Oʯ?_}H OoOoݬR[ Te0:db3a@( .0@% ] @OdHީe20	lpP+;ur$@e3 "*fާ [
 numerPIn0$  SpeedStep  tech?nologykI(gacy Free r!@6 \"*hkp`qvuȀ(@`PSys$iC`i (s	eYnAq@O
@7:@6F12: 5D
iIPtappi16koske> 39`qpmma0VK  Ei m>n Configuratiord1teur  <F1=A`O> Fichierfor mA{ffPage Sauvrder sur d/isqupge#Yc R$ar `6	 'u	nm5.x /!TZ"ePialPs$? dfau0V"Vg' duIg{noe&modi@L$0/qu6pS	~ e l'in9@
Caa+Lregd+,o12A-<. Scu `*e$ssd uQ43r&4O8e9*8.Ve sous@MP79 :_=on.[7 priph`BP9a sAOJBOIDy*9'E8s:DnR94HIAS%m$C`r=P[b`r.'he{E5  =.aL BMsQDQA vgre tab*YB.DU/C8U&$amp4 K'us^MN3$/PP7%rfreCnc\^>]FI '0tBOu EVOlonnsQb`eribVfg solecn f`nQers`*""p*pAi@&Qnjk!EVg#!.oCiPV A`cangB Chois-lsj.d MrsI%mu'uDvwZB Appuy!touFppou=S6rer, ECHAP=Al>~M2AccepP6O0=OKuiN`Q#6, N'imp-Qe -}= r  U zܒ&}s fiheDa~m`"rR^-cle *@ucer!bri@
`b,@}z <ENTREE> C~2(.#mAD&sui`PkF~:  }#m :A-> ou BARRE ESPAC_E = P\e-ᗄ0IEPpreced0OATABChampMAJ+_e4ݡ!Ӏߣ@rrP!f Ily ak1ssibdca"g Ua3s'akprod 6;endP0.. Cou'0M1 uc}&in 	1 emplace@0L'p!4iQakre-@psiƱsCbccueil d  ȲѲ!itxPmobiQ-a@p$P6;uOo2f3oa ru +FacMP Typ2@pbsRV@DbTacap(L1/L2) VolB@wmoiVer"QROMPmBANumroWqi)gRev0tdϑͰ~r'.cGlav? Fo@buD0Av.h@0hp/h3/r<q4avbinvpBpripm(te) _?ߟ_@vB6iedQre-@!R0CRɂle&xtruϡ& si KrKY&`Pb~@V}gW6 /0.p\ ", `.0bmz n)roV
]c B3 .RAa$DLuv ! tro @u'`vcvT   v& a$T"In 

:fh;&'Em-v@0 BSlp  H)??+0i5?30e? 쐈m Tak1 (rap)&2 w(coet)@u@V⻐7
0aimj (;)30$ܡ]`~s .0%e v7"&r"& v!Bl'h"&U'V.$:˩(b6m1cUPnu3d'
3vm5L5 }suphSH
3Aib,Q64: E=$_ @ASmt<s S.M.A.R.TAban .cA AJK eNaiB V|fաn?C1saqlSl,AA. WMar 0fiCn9YBPa!J!#eXJ0O40cQ/EJֹmme, vDKBJLad)Q"ppo?bligatr#K%#m¶dFN;S peMa1V^H{ sL(@, s r\Ǒ	±[?  formb
.>a mqs4.9rp0TEBy![8YpYq$a`s#. 2zUFPksis a-vou0T0:JA+srdS tiY}g hz!HWpRf
}  [:lҳbtga)aƁϠHP P
Tool @e]y Ma!rOD\C@46\N mb ckLocks ! ƔՁbri 3HS`|^rь^reg `
QV"?p~bJS,   j%[o`a  _b L'jpus J0draTk/ ) d0{Exi {oWudP; gra dll$ RsEsqfil Bo* \ GCD-ѸE6pJLpalJLS:Qq@rqi% Bqe Driveр. S3jjjjode{z deux,(UTILISATEURQPRINCIPAL)pckg%dբr0`'Cdڗ Nyz _k@QP7q12q Osr @ #fe0celuғ`lordinDY. A QGADP@qj@} T0-fetTM|+J0{`>arftFogV OaB\  a(n)u12x%
ʗaniq WTWSp1Pr,>c{0{?QmQ	 <Sł9;%@a:bc(FuelJ	p#pP çq ?Rop
ap"΀ϠԢY' 1d'originIl	v`RdIoa!RuU"vѫ
'a@ǉiqPtеVxPdj
biv`
s%S+	PVe MOQ}F+%&aOp
rPnt0{|g!~w`<1aon: t@PpCz';a-hoހp#abt:UaF, appuy`	0^7 ECHAP. WPzM'F', pui0`rF100{Tap`	3u` ȇE9!ʉi1,FranaBO򋆚C0iRdMultigBay!~e D *?)U*soc22a.(ga),-/) U` USBƝacb4\h+z4Zipb4PD D0is8Qua8CinP8Sixi@d Sep{a; Hyup;Neuv8D0;8Mo num! Permrs F_n/CtrCÂ= G'Angl'SA) PPphHPPco m!*0s A0ustanyhnd'p4мadpـxel^|trl#'@gich eru"#mx;p ddJ=iidoAq!BidpwnG< mmTKTQw KV1alSbjSal0,dv GCx a!(S0F*bloc-nys c0!Q =`}4pC[aV21(vՉ1ccuO\d]g^'_B&FX EItpK^Fc 1aKde2ffe3gTokRingejgji 
_k5p?m5poIduFptSybAa0'wxpS /zO{o|}vUOyl?~ς
nDrePдρAb
Mv X`Dua* 0bߎ?_ߏ ?ZuσOo/OJpDgn߆?{_߮e /cUu[t0ex sTmoP ?Y2oo OůA[ype 1 :_ Char(.S '% ]&N@5'2D@I@̉C~3́R`Fկv*it  = ^oɨƟ~8Numro	OroceP
AwT+AL+bLlibLegacy _AmorDcSpIbLe Retard.exp0B) D8BF12Q+WposGf;Di`Ƭ4!Dux?aRtMWDcu'n IEzGlr@ <F1=Ai> tnfoEemalP10a7Salval floppye !P@ttoRip
r
in@0Y$1n ipufa@ *j<`
t>Ignorp"dqt0ed esci E !l'	iz(
irStupJicP"zzasswoaeam ratoAK Hc2#o'Rccq%XvosW3 ;2 IDs 0e X&L"PrcS0?t{ CP Sup!o>pY Gi& %&%IgQ pS*,*,	i fabbrt'Ii	nziS'4#'RcoP-ruASi CSbbvau;U<Sl*-Op31:Xto rigid0LAtRa?4 g@d-@w=ALa lo"mC> Ava
t0LLnuQ5>H>vvi0L/oI>Z#GKxPremi qsiaRt;as peruP  =fH, ESC=AnnuECR/Q;SaRAPt@e?S=SiVNGQSA,XPa3lt Q=AYrXܕS Usbchiavp frescc=aQeviC7 v`u #ap0> 0P<INVIO> @cQ@]a'CKke.[i guAtPiUQb  un%c:0 -> o SPAZIO = suPss0A  <-0gBACK`gCEg`c178TABgCaholMAIUSC+lhk8= VlPSAqSNqErrc;O  Qu?En7puseu>"-i  v=`-un etp휂;. C0^'^4z01 Nu Ea!PP?'lloggiaao L;{Bp\ 	 7aikvC=s^aggaav w-@  =n0book0gqz"espa( taQ,{;0	a`atpa8y?z_{z|2V-{u;riuP -
 ,du A N  TioVeloДStesppGMisaca(L1/L2pmeADR](ROM Famigl=ឱe@dǗG]oPyr(QrollpQCderp
݄`F1ϤE2$E3ϫE4 
B\Ɨj_eƗls(Q) _qhOi2?Z	3?Z4?Sondaԡ<F4A@Jso:%:gger `uQ@_duk0 qQreQ /r1@, iqnaQfavu\  sc9irM 8A:t UVTA:RwEaqonoPu!-c},8F Is0 hPtQ N v7d@gȉFǌ"IRQySeAv1o'aa 5	?
1`B3" iRl0`re?80?o T?1 (RapB)sCletRRmtip:o (): 30t c@o .v0%@G씔d#ar~s-h
@Pstyt:2s  0d`4H!Q `BQX5 d- xv /@	Laws34p Arib@: i gol`V: g0}tf2an7Pde` Ei S.M.A.R.T. Jbu.3hv ]\hnuoAi0r
isE1i AGAGSCxGcamb_d@↊!>Ӆ2pxr Ut%KN1cQb^vAma "i w t HK40pmfu`7Ԃqm$ sezz!` A45.&cC,2wA`o8^/erdУ8@3:@Eff i&soDin  ca)"; KrCv1ipaUv)l*des]K !Yb PQ$HP tectToolsVLMOC8 &PvickLockmmspenpBCE\00,mouss% M"PHpߕ5!b","D  0,gra׊ '?=e _!'O$c% D.0gpsm0qȱ wI,!,d arЙi  li#0R .Pñǂ9a@̓Winfb@eW0p[Rwl0 Pulsҏ[Ao C#D-]Sֶ 9up X: $ba !œQHӴup\De>. D.B* 5 .pbv2'UTENTE0PRINCIPALE  r?@jدea 0man9fuPo%.sodVq4 k0 d  ȱP e06p`~qRqpӔ."P}lPıu`Ha*pk,hr4fьsb@/emFJre(lk. q1ndD Vg$o0ѥOhPd QIHQGQiy Kre,/&n dpg/`xTpk#L5srsluogo  MuDuB7w w-tx/gP"QD/#a, ՖTlo} @l|wI$1'Вl0-(som p! 0x%DVg  "x`41@Y ,*MR 0clq0,  pg31si &׬ "$\@tq 4 Pua4Fto υlF0T1qug{c4.r;n	Up'#sqn |<@q0Ѧ%0SVg,(mG@o ESC4'dov;rp 'ZVg'0po(m!iF10.
 jn b| 
	uIi  Op*đ%!W:tZEw M8iBay baA$gga@b`s) 74#I}h i USB
'tZSuj
k\ZZipP`oC7`TerzCO@v2Nˠ
ecc{o @ Num%#WA8Q@ Fn/Ctrl T@@Ing[e (USA)
idc upGR mCpl0qat; w'"pl/!a8
@4,?Mo  s>Y Bidi`#<!XCapa  mem p`1
 0&em(BJsbҡl.T%\s0m|^$energA  /eviQdag= o$)BaJ( to)<	sP
 Ethet N
 
18283e Token Ring`]3 Iҭ1R2< ?W_"#$!MeS&'Cb u%&+D`) Pן)*/0 f-wDuV3(/) 3?8,-/7<02 G	@46?Eo9: /DI=-2_ o/J_B ?L_MRFPQ?J_KQ a oô?Z_[O Y^S.T]/cWK
mo. O\/fOgmh`Ojokmh eno3/\rt/um/wOxMuq[ P 1 :0vro .#% ]pacomp(pR#20SPN3 0rɊ*B*5vC  G:;aivO| p/{m}u0עѠ-A֪  FloppyBHlegacy A`QUadp1Ra(sec.) vePc0F12%Ӝamb ʨN`u  up <F1=Hjlp>`rkiv Sy.infotP0s ]S pk:kiguPQ~stll frnϲl0ݡᢳn`ar_d Annua n ochs+lu@A anpA Sker`dЭtrsl0   Ka2rct-Enssvĉ(Ȓ-IDzAϴ@0tQd-Std frưutaav 'ӻ?byggd ˄@us¢iى>Yabrik;ԕX>Jsbeh.sktsS rktyg KRvr v 
p! 
Svt 
p~bHDD Akp 6键Р@Vljprk{|˸:ze>Tryp^0fri g@ n0u ѳst=, ESC=AvbryFtA pa*", V=Mer pv  pil`$׀a yAt5<RETUR> omLtt
. eQlj eer  [: -> @UMELLANSLAGSTANGENTE?N = N	c<-
BACKSTEGFregeITABfl %KIFT+#f?= F?v!fel Det g`. 9k Ut h` stod uen. Felkp!01 finnsg璲ppglat0`tm krv ".}@0pm fl]ys t  U-dator/ exԚ)O'p"tidig !"2.klR0T  kzNd,1U  P5, typ*7hastH7gCa-1rlek (L1/L2) M#S; ROMPү"=familj6enummnpdeo, =t=$bpyrT)H?pT' 1.CD2_E$)3F$4ZHr>rD'6inv`pE+ (b)'F1C7F?PGQsI<SSekr 2PӅVar! De%3Q  0znehй"&rskap "/W-Զai/kbqt]-A:#ð K23h	i`Ir/_`4^skyddad "agD\\@\\ c!q # uk?0#igﻄ?s2t6Tw1nabbpOx Ifn0pOU1}kPad kV9d (`): 330HwpM0%5xld@ 0sU1ppNvrP%Fa@tZ":@W8)Okp2aS_Cervo-Lrˑ/0BVVfpttribut: ID`#" d grr).M.A.R.T.-e OGammAGN*\7 ifirnZ` ֓V LT̀u"E 0JD*vAlika mp S0՗&$  2fInœ?ǵkan orsa otzi+ ,o]ĳAXyp ֿ0Om 0 os6alo`. g@__a om hglm
tjehuelse0нres)u1	iuw  йf0wP%0 funA&p*erl3Yi HP @7tectToolsvyQuick1в telge L+Bm HgHxًݥgpbreg-æѕ@7٨Ӭr ngo2@ƗGbli`uRϡa@_t. K 'Sompi6 "f@Pq6d)pUTrd䠐t5 nap9p *CD- >0;`ג RhS>e HuvuҐ8` : DYxme\hrdgd. #Kp
X ANVHUVUDƽQ%`ebd *`map+t w. ? a9Ѧ "q %%[ild fr `c!,"ߑ {1[hs   l̀1A%Ѧow.ܿݱ  oQP(짐!bbyg1gZ) g0oďd@Za*- Om%omSe "+bx!  ĕasr6ЦnrAktu6aIҊQ%B!Kfa$nўk42.ut!cGtg5sa XoоѦ@сursprungb *h. Vi  reko pD2s4nҊ r`c *a%Ҁss$+b. A_s0QY!ZdW)"ǤO 30Ӣg p9!g`!%q5-be0fpsem ih]Ffljqns .0  ESC-AҊr[Ɠ. r[ƴæ֓#Ùqm3u'&'
sedut!2aF102`pC9
.a:Bs.?MSL{ rк{:zJM0iBayZJV0ID (d@rrOFhĆzSBgAJF@J Zip-#0ɡ1Fj|1T|a.ttoNNM=TONum r.XVxoFn-/Ctrl2@7 BE0cls(USAzD`kdAJa1 b{rms0ptro,l0bbel0f0Corglekeo`*ne Flka!|c\!  t2Agg spХmChaWAUE-b,dpticapevic1r=cruthfpsbP# vP-aexp HNedeg EtahG%bj 1ij 2lm3onn ToRql[q_n[q?pNC/rgw?t)y?vUnik \At{pHѷiB/ptus įσS SbKalib1@ڟԈb@SAߎTF\Dualqa/ G//E &aߒVϛ?ϖE/Dqts ߝQߩt^Htag 8Eo_VG Ÿ!mo W{ϼ/ /YI_ě_ƀǔʄx[ er : La΀r .ҐB% ]pB
0klar
2gu{[3gom :/׌6* &C31 { =oA"8`Jbrb  Legacy Free"Q[QB03W^1sad3apWlLdrjCsnabbQ (seck.J;F1y$[GVBd7Styr1iMPTVpWgQeQn@Tэe`*6e L@O {OpJedslaan Configuo  Vanaf j8Yv41Cp
ardAZ`,o  scWijzigneI prog?ramma 4a {Setup zQOr wd2ospvei ZBeheeMrsw?achtwo!T ?UQ AppPYatbxg ID's#{,SmC.& O	8up}cmg!WjQQ !Ge 4_a0>3 g(sv zieZ('rFabrieksWugz{"	$%V$refsnieuw2ZC2Ec @ ExtpMAccu# Tex)@@elec0)a:1des ~, zelft#aA-schijfe1iPWAc B/=O>f?:a D
*#;: wPgp(apcQSalSb<hdesIIKukp?0`1c	
g=SH, ESC=AGnnu Y {PD ,qPQ0= :eQPJaCUNee bUf^i0	, A2!`=MPkQHulpDpijltjQOPgeObruiu@d:juiPnukeuz $ark<ENTER> indN4\ZI
bePa Dvolߐ)_[@OI  
:  -> of SPATIEBALK =Gbg0<-!fBACK`fCE gVoriggٹTABitbvelPŁHIFT+kil+= 	<Tj`UoR:!foutD]Fk@6t w3 ge$G FtP@reQ tij}sen. 6wco)011u apOi*pu we  Netvoeqnre ]@I: : d2bas$POEv#{t np notebook-'pc/< W@ia}st?.~'t@x`nbe`_igdwxy2tC0Epч/ut Nm0zGypZrocessaSnealDWppQ Omp e (L1/L2pGucapacWitROM-Revisxap0numm	x#a  He,΢gavRDvideokpt4`rbb0 Ptro6 | pDO>mF1F2/F3įF4Fis(I0t4"{j3ei1ʧ߹@m(,Gbdz) šo/ ﱄ3</SecuPipX<=L vop: RtDBvt a6su egew ] P1{Nbe?rh@?ǻ P_ d1 A:cg-  /a]0\s
ge6vqoffsGOÁ{Ed
b
@Fa{o
0gѼtpOXߧ6We vu@AP^!Ҡ\qZwilt?a	(ըaW?
Hn(-ZoA?Tq1 ()32 #(U[?)P-?10}rA (~.): 30a$&.0%AbtooB00EI Aho3	bro1\:GAuљe1㇠nbҡbtc줽tc`vo-	leestGAúv	R2z?0\k:p gpz3e S.M.A.R.T.-safd1\. =ud8|R68$aBlo_a@a A0WC G{v`Rw4kQs n`QA)pgls x  V!v2]ais abR }L	
túRkl, vTvmoijk`spRX+I zo	stbag.svorP]2%a&4LQ f/1,bP  Ygր@erloyZ vzz!J1 	ub5a pf32houdHP5* @PR20z,&Pvu6E|:`HP PrctTools@ELJOMs $1 gC:1W6 T^m\f3"$eiX}(g&`rg~p b#O  er)h,QA<o^Oh / cOs\b#Qf k`t M9kw sQ\b	}6(G7RpPfrarood#L Par!4Lz.DFdloo`wetw Kn>O Cd-r d67ȸRNGHoofdG[i  U#dȂEia QPL i#i0uE zow~`1HOOFD-	GEBRUIKERSѩWY7  p<an!#IHc SG^  RwcD3Z{ fy`k<Кxcomp@`cCa^aw\sua^vbHt  Ŀ`YSܒ
Ok BeJQU.pX C apX(ž!Autom@,cZC]>r%enrR?J	>/?C EG o`vY/bH@~s5e f. Mo !Q;P|:tFp,   "o"4oҿP<uqnt p$4pDt#uhuAiU\d wwasnpxp[pPplgea8 <. 4w1?nvloesg /k5Fa`;sPn\GJHUdrQrahЈ   toB`	p
 Bgesgt. o'@S`>. O
mun❳q fE/! Ӈgol/. AىYqZ#,@L$Er%h` qT[2 ruka0	ESC-Й`p 0@%![ r"B'['tytqBkPF10pT`jo: ,VcnΐO`%[Yn  1Ne0lӷ.gn MultiBaygiVIY!vid z(base (ks)ճrep/P USB-TccRRcKaP	p-"O EB4we0с<V1%0<V\c!<ZesZANp!Status Num 3κ6Fn/Ctrl owiss4Gр *aa!SMSijs'appM1O&($e  pL;n1 <l0"VdBijdVho- QᐽM@cd0ditionp  GLAUvg0uqZGpntilatpŲ$	Gp1PdPM`1o rrgie#RE(;bote)b$TEt<@P I123ToяR( rDP
'923 U@±ht 4]a(cuМc /O SGa\GekaliPqK bB,*NQOual1<: /*O `;:O%o!C'$ODB 7{,("._+ H!pA1g3:3R?053L er-MUE-9:;/CO=2  R/@:OBo>C܏DA  [p 1 : BBaopgh.YK% ]pЯIJPtooL2+MntJuIO K,L_Q+NL3,MS JfIVXCK,L_YyZbvN*^EN  ^,%"3ca?i Modz ?legacySa adap`GQ(tsec.)|pop-upRsnB AF12i jk)"bb  cursorbu EasyPo0-muispGA Rs[^̃ZbgA tviSETUPj <F1=wv> t@C sVXevɊւAw\܂ st tssfBvNɕۑ  ݒxyzOyfz畜|}}Ăg{a}f vHuga{  H?o׎s7yva{ɖ߅}BύXɏI  B}AȌwԂ̠}܃s5ezĂHa{eǌ!ϊ tL#ナǗ҃pvshoビd?/4`zo`vX i6@\L/B}vIDvID: h5`vuN O5BA}͍폜X=}sg JA˘pxs{sT|8_xl ީI"x t+F= ؖsO&csvo te  I!}n(Aez vevwIvvOlo𡚂Ɇ}2 vsX~x; ڍ# sypxnp߂}u7n;V&BzL[B m=AEsc=@s̱s͓O0=͂ЂҦ  AA s2ͣu sA\ ˎgpAjsڂк`vug̹p[Eqh]u}ȳׁA̘ st->Svyso[ = {  <-S[BackSpace]0ብ[GTabAa vB!aShift]+% nA㡇/mF[e꿎  !G[  s͢ł}pwrϒƋ 0?1 !`yv`ɂ?ACOڑaxKvbO xHD m@ SMEUBȂ#2R^ x］Cwɰޯ   ۾ ߔxïݸ  ށiL1w/L20urv BOM rW 
̧ضٔԍ  ޵ ޼ޮ ް ۰ׂ޽
ޯ ްt  ޯQ Mc234 Űߣ((Â)Vg
-34Xfv(ࣵQJ@s_% ߌx:sƁA B}邎`xׂĎt{/ap#쳐֟A: ݉`z}#)̡ -} H)FG //)#C1"#< *֎~@ !&R56O79z`X)O,/cC  B}6HC{ī ?ǌ  s|DϺ軑G1iN`v0u2iSL3t.M.A.R.T0u \zsԁij: 30BO9 q[#0% P~ OK zѹ鳹9~ sTf s:ʻאOIeW;m QGW*֫ZTs{Z[@WB󎸔sE?FID>vN.ab@U .se
钐V!@of)  O"0 !  ! s͢@Eی|̈́mTnNhp'8ov}C1Ǽ݄ܠ
6ɒ!#d*z`PZ60H{x`x*-=Kx Q&ţa'&wYS5ד i Xan YƂ VBT&s ὂ?CdHP ProtectTools x}l`W?Œǉ>" 3Z'Gh1¥_DLÞu Ta h¥<HMɡ˃{qEpoy! #Gjlmw|}Tی삪ɻmIf &E x ֔Q`؍ċNwv9bA֣?ԊOql1uiȯܰi  C#D-
ri- ䷈[P$ }^ h:DU!i y_C6I_PF@( qH̵ }[" nЍTavxģ Pi	p,1Nķ͎z [R s׃^ߩ痣ASCۊeaǒ A'õ`OI_$2xFS1qjp ߜ20e綂 ۏ؊ԓ łg؂͗L+B̨zł,˾&@H #a0!둗g}nwbŶ E^"Ǎnwu[ ҫ  IɏЦ,O w_wؤwٸکegk@3̢ɑ fE_ƈɍ" fɉe^S)A_nvႃJ`ܢc  '"ȑO44_O@ $tpx% oV,Ti4X|QqlӔCu!ςP" ,߾ ®[Esc]0;yaȍ~ŽU,㽂%ޏ`DriveLock t[F10(@)n!rz0 f/ 0%%1Od< |<QRS	$}@S`~: kB<xk^b O xX~?iOABECUSBP2FI2FXpG Zip61_Ԗ 2J3JU4J5J6J7J58J9J10J=Num/Á Fn/Ctrl(̟ؑ  {@p (USA)`O| &qBCDfo &X2FKV`GuvC#gs 1_}jWZJ_XrGIo0 gW`oY @;QUCYgYuO!ڑ͏킷̧tx gȓdUoptical device dq/CB̏CdeX>EthernetfX&Ei 1ij2kj3_m gN f1i.p2$Oq.p3sBlqr݁NkvOmvoB{jap ID 0Tb;~;  Oog }~ϐ?Pυ\2 f  Pe/5_ ʊBߑ5 ߉{,H_P5,ʊnpuh /ߥ5MEUEC4 /%ϯOE __߳@UQ^bv1 : [d .;% ]:2׮2poOv
3pģ	ȃHŊ*  ! O CejXRT ipuoFIntel c SpeedStep0; technologIykh xFTtP@Ut["w _V064=ް  #=Z!0x?(b) P1F12ߎibe?SRT ;^&`Pb(aQQ^B& ' _? _? _ ? _	?
 _
? _? _ !"$?% _&'()*+-?. _/012346?7 _89:;<=??@ _ABCDEFH?I _JKLMNOQ?R _STUVWXZ?[ _\]^_`ac?d _efghijl?m _nopqrsu?v _wxyz{|~? _߄? _ߍ? _ߖ? _ߟ? _ߨ? _߱? _ߺ? _? _ɟʿ? _ҟӿ?ـ_۟ܿ ` a b c d e f g, j>         L  	 
    (  
  B      j    \             ¬       j  - .   / 0 h 1 2 \  ( )   * + v  0] Np% p, p ]]"]r#])]0]b6]<C]RI]O_]U]U0P0<BB<>"ب0`8lv x|v||p0p"  "0   = ~ =$$$<   DDD OaƄe  i  o䔕 u  y nA0﵏{ E  IO U   YN ~ `' ^    y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>( ) +#
'?
({[)|+}][{]}'/@ (#ߍ^()\|+y~ z# {{ |[ }| ~ \ ^ @ ] σ} &12"3'4(5-67	_8
90)aA0$qQ'mM(%) +*,wW2,?3;.4:/5!U@ z {
V-+*'o(as$$
| i %9&'+'()+'*)*!,,-//1+,3?4
\.?()|/7/29o45
'5 -=
^~+]}@`)  ';+(:*[{s\_}\|    趮]HH>HX]IH(HPJPJH\]PKHHLHIhI־I(]FPJRPJPKLzPKO	P
  ; T?@ABCD!: 3 ]w aJ`]^]Y^c]
e]3XPY>Z~Yd]!_ STUV*WX29 Z[dQ 8 W	TX4YXZ*XbYrZY  P^_`abcXa0 Vb\]jjjj]]Pk|PkAa e( A_( 
[klm]hninjn_ 6 :i W0i4q4q 4q4q 5 	]Vb4q4qPuHuVbF10 Setup Imageqx_SETUP  4q`l 7 w6r4q4qp{{4q4qp{̺{4q|29Pq$u6rPltGp(
`Vbo#pR: Vs 4Up|0VbUTTp0w!"$84!6 0uUڔUxT_y29 6  XVb  U4q4q4q4qU4q4q4q4q4q4q6q5 Q6r29mCq`	>05 P'E2	r^@ߔ" "GҨ?Z4S LХT_T_>T_T_T_ '4 Хu
4㰀ͰOo϶-ЯХVbT_v39 29 |29" 
Z 4  vC  4  @TABCUDEFGUHIJ/pS
 cVb!T_"T_U#T_&T_T_'T_U(T_+T_0T_sT_U<T_KT_rT_wT_U5T_:T_;T_1plɹODЯIlPu0Vb4"T`Tf 9S J'l4m4nЯw>YTY[dY2c֪PYYY~YhYP[cc*ccYoQeUqQrQsQtQ
QzQ{Q}2QuQ wQU~QPu_H j>XbUh|j>U PFP^PPUPPPP}Pj>$U4NZpU2j>U">XxUMP4PUXPbPlP|PUPPPPPPj>U0@^jUpސS .RUpM
nU2jxj>	j>:Vhܚ
`4H\tT}j>6UVv5EVv
j>U*H^U_j>
4
UX
h


U

Ɛ
ސ
}
j>BURhU_j>8^Up~UUȐM" XUS(PPP5PPU6ZdpUSPlPPUPPPPPPc 8DP^j| `"J"t""""$\$ʐ$$$E#T &p&&&M&
(b(U((((S,)))5)).P+UnP+P+P+P+UP+P+P+P+S`->-\-Uh-t---U----U----U----S22$2U>2R2n2v2U2222U2222U2222222R"8->8T8Up88885Ґ88 ;U8;P;h;;դ;Ȑ;; j>L=t==ʚ==!`P?pP?P?P?P?" @l@@@@#PBhPBPBPBPBPB $`&D6DVTDvDDDUDDDD %PGPG,PGJPGTPGXPG\PG|PG~PGPGPGPGPGPGPGITIIIPGPGPG܊PGPGPGPG& O"O@OXO~OOȚOO'QjQQQQQ(`S:SLSlSxSSjSȐSސS)`VDV\VVVV*WjWrWWWjWWW+ Z0ZBZRZpZZZZZ, \:\d\r\x\\즐\- ^T^^^^(.jS>``X``S / PalPaPaMPa0`bfbObbbjbАbb1`&e"e.eDeTeveeejeee2 hDh^hthhhhh hY'	YAPMh3 oroUooАoo4PqPbPqPqPqPqPqI5Ps<PsAshPsUPsPsPsPsPs6 vVvtvvvvv7xRxrxxxƪxxxx8zzzz"z@z^z*zzؑz9sP}hP}P}P} :T ~j~~~ސ~~;g6PRPzPPPP.<`ꐂ*֐=gP.PJPbP|PPPPPP>kV~jҐ(?9P|PPP@ #ꦐAЋЋЋЋ$Bj C`jPPP DkPLPPPP E`АHАnTА,zААА5ААFU8HVhUlptxU|U̐֐ސGTИ@ИHИRИ
5`ИA6И6И7ИИ4И-ИHОA:tООООIjj␠J jK=jLs8MPPP,NPPPO `PPPPP TrJʐjSQ"NQzFzȐ萪H򘐪OIkJRoKL<PNPNTP\PnPzPPPPPPPSPXPtPPPPPT)PDPjPzPPPPP U`&U:Zn5ڐVмULмXмlммժмммWT "8U^r5X`&U0>DjUSY PdPĆPծPPPZT`hƐƺM[`NR|ǖǕǺ֐Ae\>Zl˂˘ˮ]8*Lft΁@jkm'	Aը^T`PHPjPՊPթPPP&P_ @URtT؂עץׁ`PDPbPۄPۖPۨP۸PAPPaTFVnޕxހބ{ތޖ޲֦bP~ᦐԐ*c `PPP2PPd 媅fx媚
e`Pf*PPPPPPPf
8DVjꎐjҐgsP^PPPPPhpi`̚$j j
k`PpPPPPl .hm, -4Fh̐ؐઐn`PPJP$PBP`PUfP|PPPPPndPA6Q6 oo7PHPXP-nJPPPA:PMPp
4UNh~5q #P5PPrNP5PPs P	5P	P	tP
5P
P
u`P5PPv`PUPPPPSwS
P
r

ϸ



xPFVPbPPPPHPOkJ1ϰLyN*4R^btĐ֐zSXԐސ{ >P|̚|`<\r} !HT!P!p!!U!!!!M!~$@$UT$x$$$$$$T P' P'BP'`P'UzP'P'P'P'S )J)p))Ū)))"`+++++ -&-:-RR-h-Ev--U----S P12P1JP1U`P1zP1P1P1P1P1P1c#'n#AUP48P4XP4zP4UP4P4P4P4VA4;N;Ud;z;;;Ґ;;c=J>:>L>EZ>v>>?>֚>> A*A:AXAtA*AAƐAԐA%CC{CMCFTFUvFFFFS GrGG5GG PIULPInPIPIPIպPIPIPIT KBKlKK5KK PMI$PM2PMDPMUVPMrPMPMPMAPMPMPMPM`QtQjQʐQQ`SjS|SSʚSS(TzTTTT& PVhPVPVPVPV`WtjWWW`YXY~YYʚYY ZTZrZ|ZZZZZZP]DP]PP]hP]nP]OhP]~P]P]P]P]P]P],P]EcAI&cś.cHcIPcxc\cմcccTiRipiiհiАiiT`kjkkʐkMk&`^mm5mmPnՆPnPnPnT`ovooڐoS
`pnpp5ppPrUXPrvPrPrPrPr	 t0RtNt`tt%tttO&ko"Pz4Pz>PzHPzhRPztQzPzPzPz5PzPz "UhM"`ЁJЁUrЁЁЁЁMЁ  ЃDЃnЃЃЃʚЃЃZ֚`Pf
Xv".x  ːBdj  PNPPPFPБ~XБUdБzББББББ
T :NpUސSЖbЖЖծЖЖЖ `v4P57'Ӂ5" UPhMРLРUnРРРРР Т.ТLТ\ТnТТТТТᐥZTȐ䐥 `ЧBЧVЧhЧЧЧЧЧ*ЧЧjЧЧЧ&1n̐& 4`xj,೪I P4PDP`PpPPPPPPP tj,`^,` PjPPPP$1лtлллл BPxPPPP*оrоооо PUDPVPnPP5PP U6DT\Udlt|UUMT>Ǖ^ht
dJǚǤeRΐA֐ǫ#@^͈Ͳ
PtϘϴU#lHtѬM
`t5ؐ
nӠTb՚M0ېքUֺܐ֓ǠPTPtP؆PؠPذPƢPPP&PȠTNۅwbOxkyz{UiɠPP6PZPnPPPPP`]\v Pj2lPU8PdPPP5PP$`]PUFPdPPPPPAPΠH^RA̐FtК  %b榐`]P^PjPPPlげFZnjӠ8`|  P`PPjPPP(  ϙ'8Pdj`2A נU<PjTUM`	d	U|				S `;6NUxԐ5DU (,U0<VvUQ۠oP|PPP`]XjIښ ϐV)`BVf|ߠDr0ॐꦐ
v`]JvP `9 d j    P"P"P"P"`#r##ʚ##`9%dT%r%%%%%'A.'B'LR'V'^'f')n)'|''U''А''Sl-0-<-*
dL-d-l-ez-˖----P26P2bP2P2P2ƚP2P2
`P4RP4vP4P4P42P4P4Al$ 6Ո666T`"7t777S9l99599*ܐ:Ր:::"T`;f;;;5;;|=UB=V=j====ʐ=ujA== PDAwNAOkހB${Bܑ{FTBBBBMBlI<IU\IpIII5II`PKU`PKnPKPKPKPKPKPKT ϐMRMfMMMMސMM`PRPnPPPP֚PP`]PR:PRVPRdPRjPRxPRPRPRPRКPRPR|PU>PUPPUtPUPUPUPUPUPUPUXfXjXXX nY:YZYtYJYY`P[dP[vP[HP[P[P[P[P[P[ d^^4^L^Z^v^^^^^^ aFa`axaaaaaaR'4RAIa hUZhhhhhސhhIU#i4kDk`kUtkkkTlkkkTfPn,PnLPn|PnPnPn  gNU"p:pPpjpU|pppp}pgNrU2rBrPr^rUhrnrrr|rՒrrrWgN,uXuuuugNU8PwdPwPwPwPwPwgNy<yTyyyyy(p{{{{Đ{ڐ{{{gN0~H~^~f~t~~~Ԑ~~"gNLr`{V~ꐂА&	gNJPzPP֚PP*
`yЅЅЅЅgN@n2gNRPjPPP
 *VpđgN6PFPTPHF[PrP~PPPPPPPPjPPP`~АА*АBА`*АvААА
ɕАААААА Tr0HrՖސWgN.Tzբʐ`PvPPPJL P~ЛЛMЛpММMМ zННMН vООMОППMП$ vРР5РР`{U\tPdv?U????s& pХJХZХOBkބDUХХХХIХ&U.Dd~5PUVP|PPPSа@аjаUааааS`{в@вhвU|вввв_
gN4дTдvддд TuP(PJPhPUPPPP5PP
!UHp5"rU@FzM#мFмUrммммS$$`wfMڐ%`пппп&"6J`t'`{BdĆĨʐ(HlƐ*ƴڐƁcdf'A )TuPTP͎PͤP5PP*UXώϲM+`pbЪ|ФTf,`~ ILtӀӘӴ-`{BhՄհ. y$,04Bf؄/gN<pjۨ0 P܄PܸPP )1rXn݅yժ2 ߌ3TT`pRU^M4rVՔ&5T zPPPPS*6`y熐紐M7x5
8`pUbS9z먐Mڐ: 5;`Uv< 6Xp蘿֐=`+$R,@JUT\fpUzU)>NZ
.h0ŔT0?~PhPPPP@gN <Zx@ xʚA    B`wpj"CwjPPPD`jPPP E`wPzPPP,FwjڐG~RPNPlPPհPPPH`?4	@	VJ	h			DOkϩ̐	5		I yPP6PbЬBP\PzPPPPJPJPfPPPښPPKPBPfP|PPPPPPLuBbxMrPZpN(:LhOP\bP!:!d!!!!!Qr#x##ܦ#R`y%%j%%%
S y&(&8&L&`&v&&&&&̐&&T`{)D)`)|)))))U`,V,v
,,,ɨ'́,,, V2z22222/WgN>4T4A3U444֐44 X664*6T6j6z6U6666M6Y`w:T:Up::::M:Z<@<UP<l<v<~<5<<`F<ՠ<<<[T s?^???M?\A|AնAAA]`yHBZCyBBАBB^ zEEE&E_`{PF:PF}JPF}XPFfPFPFPFPFPF2PFFPF``wPJUhJJȐJJS a`K~KKMKbMdM՘MMM&cT`NNNNSd`O|OOMOe QfQ5QQ,f PRՀPRPRPRgT`{SLS|SS︐SƐS䦐S
hPVPDPVVPVjPVxPV~JPVW`ZPPVUPVPVPVPVUPVPVPVPVMPVi [<[^[d[
r$[A[Ŕ[P\[䖐[EjaJaraaajaސaak4cXcrccfcq`jc<lee
mpffؐfnwggg2ohh p sPiPiΦPiqPjPjjPjPjPj$r*k\kkk-kkk sD`njn	=nUnnnnbnOk
toꍪPs<PsjK>FPsZPsbPsUhPstPszPsPsUPsPsPsPsSu`JPyZPyzPyUPyPyPyPyS
vP{>P{ZP{UjP{P{P{P{P{P{P{wP~DP~fP~P~P~P~P~xVj>
P"P>PҐdPP}CPPPPPрy4`JRXnSCMz ِ@r֐{Tn~M|SZ:[j>i␉w} تЋ&Ћ<ЋPЋfЋtЋЋЋЋЋTЋ~ P6PNPdPPPP2PPf] `P-.0'́AxPRPnPPPPPVPx*FUZvʐꔚМ:М8PМr*МММQМSP$P4P@P^PzPTPPPPP8j>aj>PMP ^US`JХbХХռХХХJBJ^ވUАS, EPPPPPPdPQP[4HN^lؚ"~PdPPPP֚PP*`XP|PPPP(Oгxгггг`RPjPPPTkжжжжMж"PlPPPPjPPPFhj>RHFj>`nvmj>|PĪ i j@GB&P r6A^IR^`RA`v5̐&OU`~ǜǺ5`JUVtɚS
`R~ʴM( \˔M |5& l5 UzϰS K>TХtВjԐkxj>	6PB*P\PnPӐPӅpPOqk
stUPPPPӫHX
$<Prی۴֦ Xނި޴Tb|j PJPxPPPP BRtؚ$4B^n8FLpĚPrrjJPRPdPxPUPPPP5PP PPUP6PZPxPUPPPPMP RZU
[ϒ'1A6Zp̚[PTtP DT XP P RP P 8P P S& MPLPhPUPPPPMP`ZUvȐ̐ЪԐܐ dP	|P	P	КP	P	& d
j


RR~US`{h5ʐ4 l%jzGU*NxĚ `ilʐ. dOP~PjPPP. \$ Ev, PPPP ԐZJŹАT P HP TP лUfP tP |P P UP P P P 5P P ntP P P P T`SP%4P%PP%nP%vP%|P%
]P%P%P%^P%ҤP%A`P%~cUnoj>,+T+`+++ܚ++ `i-`-~----`/\///А//~P1jP1P1P1P1 R2R2v2222 4l4j444
 J6b6666673Q`6;9@9pN9Okrh;t9NR Jt99~9M9VAAU>AXAAA5ԐAA RCUjC~CCC5CC
à[EU<EbEnEEEEE~`RPHRPHrPHPHPHPHPHPHPH
ŠJPJJJJjJJJ
Ơ˪M<MXMrMMMMMMM RORO`OOOOOQVQxQQQQQ`SSSSSܪSSSSPV$PV8PVBPVPPVXPVjPVxPVPVPVPVjPVPYPY Z(Z<ZNZ`ZrZZZ ZK'KAB5ZZ̠aU\azaaaaͣB8cXcACxccCҐc֐cADcT f\fpffUffԐffS  yh>hRhUhh|hhh5hhPkU&Pk>PkDPkJPkUPPkVPk\PkdPkUjPkPkPkPkS  ynLnnj~nn&`Ǫpppp蚐pp`1PrTPrfPrPrPrPrPrԠPtzPtPtPtPtڤPtPtPt
 1Pw(Pw:PwNPwTPwhPw|Pw¦Pw֠?yyVy"ף@hzzMz ؠ?{{5{{٠}d}}}@}  R~~b~~@@`z ܠЁlЁЁ֦Ё ER^n|jޣU&:JUPV\bntzĐА쐅)ߠV0<
'H`fnTĄR@S@\UxS ~@`~ TOДZДДДMД PfPՒPPPT`1ЗrЗЗЗMЗ$%P~PUPPPPS 6Tt\jkU$Н*НBНZН|НՆ_;zצ=НННН@$PnP]Oo'     l      [Z V[   QqLGB=   0{+&!	!$05/29/03 Copyright 2002 by COMPAQmputerrporation. 䐿
!`t`
T
 'p~}P >""'D Tut


t݈
tt

"
#
=t
@t0`#~ *0{TaD>0-t`D@t#(tbD	T
'T?DDD Tw%t5n !t
t
t
Duү"!"#$$"#!P%d%%Ô
@$$p#"2` {$ЂЃ%&u u '2 Txu. B/!+>$4 `Op" !{ #{#
"  ".)z|f}~ }𣮂)D` ) Cp`t   +,-.
..-$-P2_,,+$+8 )t" ~}|}K}4"{ z}r79tun9d=tA;<} |u<t1=8L>$2%A'%($('&":A&B&CA&%ӔP&`ӔP%/3d@C?$d	p?Cr7%u( %@B&u*I)**)p)N`.(('$'8P2CT;b;%&$4CA!D @((sHZPePβQxRܲD P PACS:"TqTt~ 332U']p`LIDU=A#T.SYT#߭"ֲD!+[?cǲTT"uPu4"%$;4P2tʎ"0"
pKp"0"_d   45t(t
5"+c+/ÞP.%c@ Sp`c߀͹cm@^{ +u.I-`..08-N`I b,f {
c,Kg}3hBsie,`Cdd`"`7t
8c" s?t_uvwxyz|?}}	2x-{| ;_   01/0A02/ 04 kDi_amond3qHewlett-Packar1mpany.P0a0"x#T*T0	T@t/{3"x0x`v$ÔdPx>0#1~"};TT?"2"2zx wx)} P;uu u	``2`2@)aT$3TD ȃ@VF @c~`T?0	T`2`T%`@`2dłŃ瀾x!T.xT?T/TDx!TDxD@x``p
00/dp*tP M0 T%%0TO~Ps.!O?T"¯r_()B)J()(@=BbjR PMqM}xtPTa"C#x7$0./R//$.Ôп.P	107xTxDV')R~SM~0`ӧx 0p"xD¯./uvү5./"xt0
}
~q3}xXvvuu˲0P0Dࡸuu!B
L}ܠ!ү0Vm ~xvE``
$`$p
?షxЊe
'xx txDE SxxxxaD@5 n}upgp`p{A}d`3 &xNI@L,x%tx}D7 a Pa0xtxtyuu V0␻}^O}eCsQ]}lO-½,/ƴxeD0 ѠD 1^x_RcD%xfTP`P'p# * .}cf[3n-0i;IƑr	@0P}TϾ`ɉ"10gx a	00P0}epŎѽ3)"? b P¯^u|` w$T`#BRn045\NQʄХد)u)$4F^Kࠞ)}.,)(Ô@a*"x/)(`#䔽x0%xvՒ"x)(*a00}_+,`-  "x_}408w}71=" }9`5*1x%~x=0T4d~` 	D#Q"00x`)xc`xd @p@K0S(;TB(x0¯0*09P4.(0H(`xU*	( xTx k! (AT~KCPF@< y(P>֑
0Tdp(D !+P( @5?p WQ"6p@Ô2@YD0xx78Rx00`6+06m0
 Tߠ|`	p1[on٠  `a76ѝ нᛴ{x,Kxt;xx,!p0x*-tp+Z`KAY^ҚR xT0T?d?p_p
0aT`ad`
u)?T d`pUpD"TӔ @
"T?Mp;T?`d`}*}W)pKz0$"@p`
T1## %@=~'~W)33TT?O)` 7  . )/_7 ""G`rux_?N堕DF33ʰ333PE<ЂЃ2
2x_p`_ 	Baa$3ٸ5L 3*A3Mx-2+_NMNx*NMx+<QM0Kx"b=!==9qeL`
MN12A3K3K0=`C_F`C`CP`C4N/~522-"F	2:RxZ2YA3SNSmSQ4>@R`S5t2:T  3^A3UIUQ}@T1JUJKV 3cA3WIWTW3PRE@V1JWNS2A}3 A}9 !.A}  uuҌВ">HV_W47vjW0Vx'
q[0d`!0&-5-\P@'`2`=`HpQxX"`1\6uuuuҸbuu0buubYˏO$rWƨpN`0T`
0370Ѝ  q"[| }(xX"(`E(p
kAnk(  ()(x)(0(p)))((xZ))"*+д[T0 7/at
at&Ppd `g.堪2@t%x<6XjҌ(px#k響,-mp,l`
,-xd@vt j/Dtpʅ+*,-"uPu4e" Wx^!`yWxtwOx7vpx87t
1"ucd"xe!px,"". -BtF)DG qs=w1v8zrAp#$W@n23{;"xy> !u
Cֻ9./0H*5,7_SU4cU~TVV~OPK|QZYQP}d%]	`
e(j[&b'gi\af6h+l:@<>L|RX>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L R Z  a  " ! * 2 1 : A I J Q Y     )   3TP g d   pqkli/ur}z'tw l k i h Ju s r p  l t z q { y m Zc v       
  	 x   ~    Y Jw | # qww ~~   @"Gux4"01WڱD x2t 1tI%W0% %xjvv %xjZ> HRxl"# $ $ !23x1 	ү  ¿0 _3#!PK0ؿ3"0!PMx3>
2rWZ"xkF`g7rp"" %	x30#0$<T`д""xl `fp
0!#atI.4}xl$3z 
PHp`$HtN ylDˀxhv"xx0	Dc0Uy$Ӕ@TxxywqD"0 4xfxwU` еDT0
ϠaqP" xnxoxv"xnxwxoxyxv "xqxprP
rWypxq?f`Ӏ0SVxqX` grW1wB".0&u)P/)S@&*@&"*@\`~"x* \t %*u o-~-PtU-,-b,R-h-o8++ѓ,U-`RiU,`  +u%*$U,00u,,u,0,*+P,0 Pd0`Ô@"0  	0
0 		"0 H`$<T"   Rj1 apy1ÔP2~f0/ _\%110r0//}1Ӕ@t -A2nO2q.¯	 .x. xho`x\T`)Tgxgdx`yR"33"x4!,r3TOp0 0@0 
0 ]#000+1d'`8`2`,`&:` ;`5`M`A`P+3{ z y5"CPNH0 =5`<}DPA5d`5dw`
`
`
	`5

5a"3!54Y4#P "l"8̓6 "63qْ9S6|09}= ~ } | 6$ ONMLPO:_|b_^]\T:=T0f: 9+`:80:808u6$`47D   6"67?89x80䓵6789t:#UI$%I$%I$%6d'p/ $%0q++cҔ$06$):Z$	%z-;E/U
/f-1E//UR-2E//>-U3E//*-BE/U/-E//-:I #=8@ $ t8 78v0	0+
  +u7 08370 t08k2;
;8?;E:
<u8F6:T<>=%:
K>>;
:<u_8# 2;m:|7pu8J2;u7Q0Nu7!I:{< u8| + 	6u71:yF{j"GG:J<u8yu7 "GG;8Ӕ@
8b.ߏ88p!77
0
6%u8@-0
05$`$`$pPN(PPN)"PPg88 P&N$NeRR-SKT6'"9:9  :"9xh Wxi9d|p%09R:N{zy&u0YWv W0/PX_`)09#XVYZ>]9
P\1~Z - 
[^ &LZ
 !b W;`;@Z;s\YSdeb:;<<:;<`S<t%<<5;; <<"VVrPi90r0+09&n`yY9 Wr9 [ \Y SoYr@m   
 
 ,0 
 93?o_p|qlmZqc:Wo`V0VsV0u0-039(k\
mnTaue(vebcr95~뀱_{/|]0V90 ?2W`*
*t9@Z9Kumњ҉@	e9p6RaeEZ9"V0 \j9C3W򢆶YyJёl҃0*=Y0WGifp[\㗤s0;q iTёԖB䗀c6xgpJp `F0 `)k" ) ) 6 6"ܣxg z}Zt "1x{7MNOp#D Ee1_``}GX#0
T1d`*?"1#R~ pq{z}yZ1zxzӟd@0#
0 *`0`-0$`+$`W$`6$`$`&@[$pYT ԀQFq>q0Txv)qo!rDx͎000灭 r 0aaP؀-Pe`# 	p"F,:|`{"q TpF`xe  U05xv
xDߐ}D,0{ ^`
}^T?D=䫓_e)s)l'ۀ@ TpB,о34#3$``$p"t1e4`_tg4$Q[Հ&0.'0*Td`x0dp&@  xF TTÔP
xGQ0xFtpe xBCB"s7 xNON"l {xJKJ В"_78 2/F"!:(x ү7%$Ft:t:8230(0 (xv`3x`vT"` 9x"ү878 0(@87 p0 xφvS3xV53}., `4  %4`.4P""55Ô@`p`/``"آ# #d`
-~~/OTO/_s`oss 6120``/`@$pND21I:4y &$y x u )AP [x`03oppG{,8>p1 'AP` "pT`~ -95u ?Tp;үd`pxH  @R
M
 e
 e
 @dq;"-.o m``2-x00 <.@	@
0
t D~TP\0	 0A }Ct
1u/0/tl;@p-P r.zldpe`0-~aDxFGW0"@2#`"" 2#"xu00 '0u0/1s t../0D..}`0 $0/C-z *Q- })+?
.2r//`"/4  4*x0)\:)4
+,3`4iO)1<:A	7 8p
8:ph";a)
2Oza?0@|b55 
x(0	(c"QC}*";((0@@`?v@{	F`~4p0 ϰ&T``a_`$Ю<`:p5s _D?F ߣ%@50B
op;s R24qTf  U0: R2Mp	S08/$B0t M0%%cO`SR$Џ-A	N-H_<w=R+a:YQ-RN6ɱ6Xp0r0V+P]o0+-`0-ce-c-P`	3-PQ.[tRE\e߂-O.@! EP6&/u.
/~ku.As.W	YW,:::
,-Uoo p2- 90&ppp	Tg -		@Ȁo@ˀqtR080uqpo
)oa*+pF}}}0
0,/+*t%)F$ 
QH&SHS;":+Nap8Bߐ}@BTQ&0W=_JG>H`"< OT0O!y45+pY'bxaT) EB
C\0 `54`"Sm_tw:{U!rѓ'b{#{U	 `ѐ慖QQqH`{0}
a9WW!rde Pg6$$P3%b/}vՐ{ѐ#hQe\o}z 1w X`FpRGpLxpGNtp?RL1RՒL#RLRL
TU`6 |TBx{}Axz0Gxy0Exx0Fxw0Bxv0<xuxfxtx\xs0xr0}xqxxpxx|pAx{pGxzpExypFxxxwp<xvxfoxuxtpxsp}xrxxqxxp"#6Pxev0Txamү;Db" /:!e0/TxaP#aޒb;m /^s*****Q1X	 ~95gF")wu,_.00-T*/.~f00)@P (0HP|4+S @ѱ	1X
)@Ip,+=>')QqO*+\pGXJt+[+U*`>'-p=P|/y0hP5M/$\?uή@}}Dm)htmѱi4N۝0H0 P|950H(pPy
ӱ "u*ߑ09"u p}/)tmP|~?n) ӝӂ	 MG+0pr=p+pM&u0Do@TtHp;DےS)U)u+B+E@2Po&Hu+T~m8rb+RY%TwOS 70	  b`[`@BfB$`@Wϔ@6ᤰ   x0pq  x<a@I	77 Bxv
07PIs `rt`>*Pb"D{"ZŽ@q:opT L%qM30.vT`t`'}}S?p@Y33TB@D D xe3"tѐxV_xF @t`t]Twqv
  M.rJ!!3"x_*"PC[=Pu0OAaGF7X03ct+`
0Pp *J'?' 'Bh\A:{` Q:'P`	'{Aj"IJ;^
U{TNJ EI"-`1Y5Mn:Cढ;CwC1Ypo0:2-{uu1P[u10!$Њ:01銠H,&2;2044-D0-ڲP["-UO@?"CDOs(a{!Dd/p@}<Vpt=tr?A orDHEp=`EDxhvCDBF@xGAxEBxFt@0( AT.`xAA0xBFt"("DAEݎF0GBUCBaCCCADiB_DyEBJF8GT0LHNaCOCMDNIyENkKYLHJaCKCIDJTNyEJkKYLH;EF_;wGH`NJDT&` X@A0uFlF@[
HGÃtS}]PhCFEC}^}e}s}lEAMI aB++I`Ô@"OxD Tw{ЦOGƀ`cFÿ$0,2`cAz#}@T#}CP?PGGGGGGjGXGFG@G:G4G.GFFFF  G{I@1g $K $" P` ]kat"x]omnnpnkq"I
`Darm(r```aBvsr1n)C`]klq1nqxq1 =QC#Q$`mRH|$HPӔ@zPOaPн0	xhZÀӒ}|aB#rP`#`5`2$pCkalD#u#r zx\PPT`gxgCmrpz@Y
xd GÔ@π<TxdJӔ@`7sTsн t dxi vv\v+xgv2``#t "4}t Ŗtp)㐿}=t И	+"ÔP@ӔP@$?$P`YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATbb`cJ!e2{g}~L;"_$/LQ0P`Pd`uPgKK&K2K=KgKsKKKKKKKKKL kL4B=$D%~P?C`nv`plB"l$m $%A @W$kg~k ;TּLW.r0g" #xbwAlh" a2~g`P~0QOఀDz=d
`#w`(`{<`@dP`d`PȰPb0=vCp }t=td¡vxtxxXx\t mxat"xbtrNxJxFxBxtx(tb}p#Dxxtxtxxtoxx#x> x=tQ~x@t@0xTВ"xgtцx1ӡx!TTTD	xT@Tx=Tx"  Tk=D"Dxev0_}<t F{B{G{E{A}DA"x0xP"xbSs("2@S?/`?@>"=$t>a&$-"TÔ
P~0~7%PPOOB7%OO{ z yOaN N+N3N4N6O7O8O9O%:O0;O5<  O:bOIY!Q0IߒA9p1~5NbWO&8;uOuOKO``($`*`-|/p4
TbB <UwBFEGAO$`$`!`0`?$apAa@:32B*0 @#S0AB,3`G`[p]Opa"OdpFb ^$`DཱྀwTҧQ@0 GOp[cP"L}$pMbPS'Ld`ǀLxbLÔ PLNQNs!	@P
	

Pxbv
@QQQQQQQQQ^QyQQQQթQݪQQQR
RR`ReRjRoRtRyR~RRRRRRRRRS   S'01
v"x{7MNO`u{M`\MM{x}Z/xz[ј@"+"0M
MA0搓h0"} N}U6 "uNp0SNNTN0CNRp!!d0^p! 0p!@D Sx\bvUaaaaaa<xTxeD0xb@(xx n`}K}I$	a
a@"3aNxO| } ~ Pg4-/&LcU)MM U)SJ((sSSTTTTTTSSSSTGTMTZTTTU U	F2Ô`P	LOC"T?8} S
0xtД"LNL0Jю0;V	b50;TϐAuL<;>?rQ?p@0b3@P ;9N"	J7$p!9Aa0Lp."xzdPDC"{z}yZ8yzB	OM@7"9AHeu7IIeq?0M}!dTsIsIA!L@^|OL#T0 ˤҊ0!A0lU0#b0xD  ATx@c!T_TxxcvƠԊTT`BYDaZbZ`<xdX.u0/}.,0.ÿT ^00//pE@"U]"^.jga"`"^} ^",0V"d-,Ô ,dpCSV8`a95-"
r3xp0 "3xh`ۢՎ./01,@rDt?/t .x@Zx?DT?/.1R0U1B \xܐ x@!D!x#Dr"q p@:q@6x澐YbYt2YWvB3WWWXevYqYYYY6x
ߎ,-1kx
tu,P
-},0x
z{x
yxl{Vx
my #u6|0"t "T $QxmI{BxlxlßP2V0{ y%@$IԖ{$ÞPxxl{Iu'At I|bd)*u耧+ytүt$`&p<V}eԊ@ quI@x+*)t6	|$xxmӔO@vl hxlvylßxmPA  l1Ƃ߀0 	6
xTUxv 6x1`r\
0|Pxplxx
x{xx	06Y)bP$~~|P f}06P:ҙZ Z Z*Z4Z;ZGZZ	[$
  [i'1LDca̤SD@c"xgD`BO`$P``G3`@ʐPTORPPRP  -DmP"".@ATABӣ~F`/3ѥ%@ U,p@%1e1t^0Os01l33TOQҮ0ұPrp r06"y`p}T˄`- .*))pr;S)zS)x`vS))"(),0.\"\x	`}FN@t\u- u./0SS0S0u/ u1/U-n.Np.%.-3-111pEPS2xp]x	1.-a^_p $ 6  .Ģ6 +22􀰿m .Ӕ@x1ͺ0@ _??6-p ʠ--Ӕ@00.`Ҡ`]9]H]\]]^^/^J^e^u^^^^^^$^%_
&_+_,_,-  _1.䀙S_1!xu,4ӰF./xP?0ӳ.#4ӣ ց9t0P|*+AyP
/+*{4ُ
x؀t?e+pt e*l	mڢm`
pxvEvmx2Ӆ`x:Pؐ}v}Cztⶼ0/hOtb.گ`v`ao}atauavaL>}3af@Ԁ'P'ZH`ab pep)("ct`hP
________	_____````A``3`  ` ` cccca
tt)B/{rUc	c
c`-
1җT`cPLxT0BL:)P"
BL:M@`L'N MWOxARZx`!0Gеt(ODC4Q2	Rx{p⁵t[` jD:
1
@D aM*"^qD:o2}#210"00(1$`$`$Ap`aJ"_	%$'cze'1p;a(d	`
DDxh1jzg"
"xqTp@opa}` a" `p "$``#`$`%$p#F0 c
=#"x%txy1m.d~%m"2'I}t0	
A逰j""X`rxyqTTr=
* ̀+l!{D`T!T\ñ.p*
+"  =>C	D

~x`!P2^`_f"
%@o~sF`7 j0x(5(eLxj6d(S7(`S*3`C00+xT 6r}_ 2p. D:_T_` @BTU:0?0	6+`5q>dxS60cx7($```9`B$dxv (zBq DxTR?ҎxStTTTDHc;(xS(<x)76)$``$p#(p8xSxB(}B	x60600:=a>0cj2a<"*+*Ô@*ӔPMw@
MP@o*$1HѤ$cp!00-C+(}+ՀÖ!Q VJ+*fApMC++ MsMteqMucT@N@opO~0B`J`N`R$dpT+0+ac"+WTXdp0AX0ӀÒ0 +ڱq[+R"*+l"s=PD"xBP*"
]	1}i`$3mp`P<߱Põ} ~`b,/PfggRgXgagjgsgsggggggߕgߖhhh#hhhşhŠhhiiiijjj%j%jGjGjijijjjjjjkkk-k-k3k3kUkUkwkwkkkkkk  k~'QrkkC/ onT3/C/00u5$ 0` R/q ou/}o}/2ttt,}atBqfuVv(vsvVvyuVv͟{uVv}o P TPpBqqLBq|qӝ Tڑo~ at`| }`@^_ἑoJuVvuVvCtӂքӔo  pi|nÔd@n| `z {@\]L`s9-/.Yatx5op.˒~.+-wVvuVvuVvߝuVvuVvt@#@x؎#-pb~uJ!_{dz wVv?u٭cuRVvuVvuVv`,$/0Vvnq/q5qo/9p0U!~Vv?asÔ@πu/,/ΰ!y`AH S 3P b\pup;<~#`jPl$ m5!'`T}$<`!!WxmpI
աJ
KxjB==xmP=U550#70"' "<ɠ'"$<_v.OɨK`Š
J
K
Lʢ=xm@ǟ5"89:38T C
d@Y08l;}e֐& 8  | $ >89:pԦdP (A/dZ"8}~%}ܲ0qqނaޣmע ` (ɠ#2 N (}馀$TToȐקt


(~HsP((`!`~%2ұ#4ݰ@0v3D܌ϔ@#Yܐp@t	0 ދ 
41ppndn"14P&!o?u|  }p
T?T`4"4"cu0<..`~r~9^rTKqTO$&../'p3q*@Pz-nc.1@PC18@1ӺP@rB1$qqp083Z,A`&rm@` `䔽1"x`0T`2T_2Oz p.7Rٳqp1o;e.`.3?@ؖW	e.`qp.o/{/ W/0}  א~"Wް	!D7@T3`50"2ސ2` t@2.BrMu./Su.$!}r?}]`|/Swӝ/[Pzu. Z0/ܥq"'sƝs6u0Nq a.PTTT%%AFp0 $r0}
r	.d(._/ӟ@Ps	!nx b. bPYx}700,`.0& /p$/^00۰Pq/^!07O"!sȿ 6^6Et`466y4v=}6Մ s岰6xBd%xB^6tx4^6e6q4t}5}{zyc^`u$M04M@fM$UPUMg^`-$5tP~@_
qat"5"¿05Q5`
!t@	ϔPP//Eү0ίد!n`|r|\`2345Áf}M}4171х|v((svw"wCw^wwx1yyIyjyzHzz{8{{{||0|Q|rsK{	m@"!cpwc !]z}p1lklpu2`u3 { z y2Jrbs2T`pd`dppkJrs03Gwce3pe2`(Is003@Q3/2Vk^P3y
yXce|QӀ  @Fd1P;|$k400~Q3E2pU{s7{HO0$Vk4P59ysu9Vkkxs6u6R9"`z {T@\]Lp)67776Y6Vk<67
ϖ.:_>a!dLpi>kJr7(?b!k/IppNk?A=ʴvPkx/	 B(@:?BkJrVkkQRk<Qk=JQk>Qk?.ãUDgMk O !UDa^3DIm09L0_\TҎ~VkF` 7gvGkE510_"0$k}1o+ n!2u1@(#1$`=`l 
~$`#1 u1J!uxPX7ބ; dEb tuPNÔ(P2!TT Np\  02 @MJځÔ@qq` fu1;tpuPҋ7@<TH1Ƣ7 b/dz}` Ou2X䪰 /a~L`n +}3/ERn" H<tQURUXb/pAX08)}D02"(LPί.3A_ܠIV%[` m X}ɞ|4P90p=0.o0ӕ//.p*1 P$#%a$3/tP" 2 }_
 `"43t#o$jR3D2x 0 `Ð}p@2x0@@2xD7)	v"LION  1`TDx"À" 0sp޳"8bP3px"/q8 @1X!ӀÒo88"bb!Rs#"x& 3%T~TہO@&&"x!To`	+3~`xD@T"	F	Q*>	`*23*x*p!+s+d B*X-*LҀƀi3ꀚڀʀ3-䓣Ń1?
-1@*"#1143*$ PS7##EN``#s-"P"]B4"90:p:"  )"/33@ >" s=3@P">"(Ap80;
- :߇	p:	:t!;)ς:eC	%p:
G"*PE!;2Cp^C	AD	"EIGBG"""BBE"`;O3=p@ >P"""Ѓ?ЂETTtsߨT틶Vs1ŃŃ4W"%85`TpEp
Es`Uh`!*pt*\+\~+\va,\n$,\b-\Ve.\UJ&/e/101/1cp3p3d{V6p&77a8#'s jl/mOnoop qrsu/vOwoxy z{|~/Oo τ/Oo ύ/Oo ϖ/Oo ϟ/Oo Ϩ/Oo ϱ/Oo Ϻ/Oo /Ooɏ /Ooҏ /Ooۏ /Oo /Oo /Oo /Oo  /Oo	 
/Oo /Oo  /!O"o#$ %&')/*O+o,- ./02/3O4o56 789;/<O=o>? @ABD/EOFoGH IJKM/NOOoPQ RSTV/WOXoYZ [\]_/`Oaobc defh/iOjokl mnoq/rOsotu vwxz/{O|o}~ π/Oo ω/Oo ϒ/Oo ϛ/Oo Ϥ/Oo ϭ/Oo ϶/Oo Ͽ/Ooŏ /OoΏ /Oo׏ /Oo /Oo /Oo /Oo ?_ 
?_
 ?_ ?_  !"#%?&_'( )*+,.?/_01 23457?8_9: ;<=>@?A_BC DEFGI?J_KL MNOPR?S_TU VWXY[?\_]^ _`abd?e_fg hijkm?n_op qrstv?w_xy z{|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ ?_  ?_	 

?_ ?_ !?"_#$ %&'(*?+_,- ./013?4_56 789:<?=_>? @ABCE?F_GH IJKLN?O_PQ RSTUW?X_YZ [\]^`?a_bc defgi?j_kl mnopr?s_tu vwxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ ǿ?_ п?_ ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CD EFGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_  ?_ 	
?
_ ?_ ?_ ! "#$%'?(_)* +,-.0?1_23 45679?:_;< =>?@B?C_DE FGHIK?L_MN OPQRT?U_VW XYZ[]?^__` abcdf?g_hi jklmo?p_qr stuvx?y_z{ |}~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ Ŀ?_ Ϳ?_ ֿ?_ ߿?_ ?_ ?_ ? _ ?	_
 
?_ ?_  !#?$_%& '()*,?-_./ 01235?6_78 9:;<>??_@A BCDEG?H_IJ KLMNP?Q_RS TUVWY?Z_[\ ]^_`b?c_de fghik?l_mn opqrt?u_vw xyz{}?~_ ߃?_ ߌ?_ ߕ?_ ߞ?_ ߧ?_ ߰?_ ߹?_ ?_ ɿ?_ ҿ?_ ۿ?_ ?_ ?_ ?_s     
     U$   4 G  N U  fWfVfSێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.15 Copyright 2003, Infineon TechnologiesQfSfRgf.g.3g.

Ƈ}~ǇvJ gf   uq u QfP< fXfZYQP

{At2[RS l eg{q "  诟3[Za@
  
a 
5
; a[g.Qt|P@f
 DF<d~ug{$u	N"##:o3ff@~1QfW
Pf6ffffg0f3ɹ 
Q +r&u3gb&Rfgݎf(g3fGf_ \-"& gf4$ +Iffgސ0fG(. J&>/(0 1	.1g/	2fGg&q/g_f6f6s47f76_Jrr&v:7Z$8x8g6{47S6<|.=}.=~'=0  f_fYڠZ@!3RQ`[DaDD3YZRfQSDڃ <u-Hu!HuH u3
߹  4 pgx@FDMDwTEPE 4 t L3 s d 0SPPJuOD0Et  ED&NbAE'CWUDpDEqDFh
Tt2@]Cf[1^PQP fa nd) f t|gf> tub~ {tm1c te1c t]ff 8N 8^ 86
f;s"u
 '^QΒh1 
@K [W)Da(g Bq^ 
_3ҷar& ~A *u
r& ur& ЃuBwog,1-[0g#sf8魾uqq@ L	uqWwS/uF"0~ouS p2zIƀtB 8t$2 8D$e{ff+f+Ȥ{92z3{pu~` SY^@QQ{ 8wL$ 8	25
|0 Y Bl_3 zǐo 7muj ),,Q tLW)ff3fsf%ffK8s{`fClQR*gً1-*
tffpUf;sg^,g,WZB%V)&6Gr *fss2tQtÓ1 vfV*ʻ *쓫ʚ<ڛ ־Ƈ,d +GĚRP_EQ! [@FPQ `~!fRS2 Q@\ nZ"AA 0BÀP;P s
E 0 Cr
 xRO_f3g#~|ǃrtfwQWf9ˉAP bA 1^S*pQ$"PrPrt Dtt%53A. )0 tн t1@t`5t
I o:ɚ̙&!'g%aa fQVPmQ\0l0"AA|!26Ps؀P"rc2ېl ɹ@b&'"ff+f}HlhUOBB`%Q%`
Go!tO"BY&Ѭ1OsѬ1Or
q"tfu`3yȀUq a 7pTPsIu3PBHa8 XHPS! 6#a P [Xp$
pqSq[ 
 tKCX 裝P0#"3`   = 肦r2#fr
fff#@k%  t	f!bf#fk%tbx 9$yz 4Fidk  4Buf0b!b/OozRJUX(l              @ ` d$ UNDI  N MdPCIR$    I PCIRE      X b   $    $PnP       o          
Broadcom NetXtreme Ethernet Boot Agent v6.2.11 
Copyright (C) 2000-2003 Broadcom Corporation 
Copyright (C) 1997-2000 Intel Corporation 
All rights reserved.
 Broadcom UNDI PXE-2.1 (build 082) v6.2.11 
Remote Program Loader v6.2.11 MBA v6.2.11  Slot 0000 Broadcom Corporation Press Ctrl-S to Enter Configuration Menu ...
                            
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 t`h+  dMd            h+ VP@ ء .;uXuX.6>| .6^SQW  @ _Y[QSH .> t".>u.uXH S2.{r*= eu 4= fu  *= gu0  .9u
 @ ؊>l :>l tIu[Y[Y.> t.>u0 .>u  ø UWSR..>f&=$PnPu#&uFPj`hf&u
˃ u0   S3=_Su}M_u22]r< t[Cu[V[}#|OfSf]S_fSf[2= t#It2E= u= tGG= uG؀}|E$t0  Z[_].>u-fh  fPh hOh"ph%th mh fh_SQfRWV.>f.> t.@   ځ>  Utt r rf.>  h1
PH ?X%
PXE-EC1: Base-code ROM ID structure was not found.   r댊  t	|Sfj j H< tk>  t;sf=$BC$uErPj Wj < t뛌ێf.> t.@   f&=$BC$ h  .6.6.6.6.6j Ph#&u
˃Z t'hDRHPH +X
BC_Loader() ==   r tho%PXE-M0F: Exiting Broadcom PXE ROM.
 P6 X^_fZY[.>ufXff., f.. ff.0 f.>tf.ff.ff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZff., @ 6& ԋffPfSfWfUj j fj fj RV@ & .6E.6E.6E.6E.6E
f., ff.>t(Vf.ffЉVf.ff6Uf.. ff6UW0f6UfVf6UfVZ k	 t	 t	 t
 WPO
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>. uX.> u
h
If.f.fӎF.3.f.F.3 .> u5h
i
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sDh,P?
PXE-E20: BIOS extended memory copy error.  AH ==  .f.f^f. rvf&D    fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(DvF&DF&D&DPj Vj &(D	.6E.6E.6E.6E.6E
Wj v&\Z
 .> f3fp  
Wh v&\6 u96} t2  ءL ` N b 6E6E6]
6U6uf6]fSf6]fRfPfp  f	fXfZ  YWjuv&\Z  t$  8Wjvv&\Z  t  uj@ H F F  RWjv&\Z  tvXt
 u tfS^G HF +F )F[fSVWF   6Sfff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 .>u%fp  %f tfP  ءL ` N b .> u0	= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]k3e3_3..fP. tfX. tf3ffFfUfSQfRW^  G33.. G3.0 . ua^_f..^G3.>0  u	^ af.^f.f^G.3 .. 1f.^%^f_f. s
^  .>0  u	^ f.^f.f^f_f. s	^  ^G  f&<!PXEt.;60 r^ &DXrPj Vj 6< u^wG&D&D&D  &L
f., &D&&D ff&D"fG&D(ff&D*fG&D0&D8ff&D2f&D:.&DX&DPj Vj &(D^G  f&<PXENt.;60 r^ V&D,rPj Vj {< u^wG&D&D*., &D&TG&D G&D$&DPj Vj =&(D	  ^? t _fZYf[]f   fZfP.>t.> tfX2fX.>t
.> tfRfPfWfSfQhf   .f8h  f  ` 9fh  !ff   fh  fHh  f    fh   f..>t7.> t/fp  f   uf ff#f H ffp  . uC f   ff
f t!fff uffff.	Itff   .>u f   tf   fff ff   f.ff   f.ff    t.0ff   f.ff  0 f.ff   f.ff  @ f.fffp  ffffp  fYf[f_fXfZfRSfPfp  pf   t/f   t'fXfffff	ffffX[fZfPfRf h  &ff    f h  ".> t#fh  fff   fh  fZfXfPfRf h  fff h  .> tfh  ff   fh  fZfXS rR[fPffp  fZf fp  }f p  f  nf   f p  Mf   t_ [fRSfV sfHf fp  &f p  f  f   7f p   f   tV fp   f[fZfPfRfQf p  f    f'  f p   f   ufd   fIuf3fYfZfXfPfRf p  f     fZfXfRf  `ff8h  x f   f8h  W f   @tf<h  F fZfPf<h  G f  `BfXff8h  3 f   Sf8h   f   @tf'  9fSxf[fSxff[fS|f[fS|ff[óhf   f.f.> .>  V  fp  f   tf   t fR t#fffff	ffff fp  If   uf  f p  /f   Of p  f   tfp  ff&fZfItP^f`f&fIufPfRShf     fP fPf @  f   f3fP  .>t.> tfh  f  .>uhf   U tf  @ J @ ۊl :l tfX2 fX+ [fZfXÜfRf3.ff
   úfffZÜfRfPf3.ff
   úffXffZSQ@ ۋȊl 8tY[fRfQffh  ffh  f;tfIufYfZr.>  uPH X3. .P #. . .P 	Pfj j .( SXf%  fZfYf[fX t]fBroadcom NetXtreme Ethernet Boot Agent v6.2.11
Copyright (C) 2000-2003 Broadcom Corporation
All rights reserved.  MBA Configuration Menu  
       <Esc>    <Ctrl-F6>       <Left/Right>      <Up/Down>       <F4>
        Quit    Blink LEDs     Change Value      Change Field     Save This option is not selectable                                                                                                                                                    Boot Protocol  Preboot Execution Environment (PXE)   Remote Program Load (RPL)             Bootstrap Protocol (BOOTP)           >Select Boot Protocol     dj  Boot Strap Type  Auto Detect   BBS           Int 18h       Int 19h      Select Boot Strap Type x      Hide Setup Prompt  Disable   Enable   $Configure whether Setup Prompt is displayed during ROM initialization     .2  Setup Key Stroke  Ctrl-S   Ctrl-B  Configure key strokes to invoke this configuration menu x      Banner Message Timeout  1 Second     2 Seconds    3 Seconds    4 Seconds    5 Seconds    6 Seconds    7 Seconds    8 Seconds    9 Seconds    10 Seconds   11 Seconds   12 Seconds   13 Seconds   14 Seconds   None        *7DQ^kxSelect Timeout Value      Link Speed  AutoNeg         10Mbps Half     10Mbps Full     100Mbps Half    100Mbps Full    1000Mbps Full  "2BRb"rConfigure Link Speed       Pre-boot Wake On LAN  Disable   Enable   Configure Pre-Boot Wake On LAN       fRWf3ҊC fRf3ff   tf5 f fZfOuIu_fZfRQWf.fRf.    ft   # XfZf._YfZWfRfSfP>uf   tTX>T u
fUPf]TfU`f]dfff   t
 ff<ff0ffuW f t E,=
u ff%   f.  t ff%  0 fff%   ff uf   fHff%   fff%    f
E2=u
fXf[fZ_WSQfPfRXf @  f   fp  f%ffffffp  >T ufEPfE`ff%>
 tfffffffffBfffffff
f>Wu
> t ffffȀ>T ufEPf   
fE`f   f:X fYfff   fZfXY[_Uq 3KtRMtpPtHt.ct>  U =Uq} Us }Uqh 륃} t=} u7} uEEHEE 낃} t} uE@;Ev3E& b.2UUquUCRVUmUPUXUuUum
>n ]^ZQP>=;>uXYWQU>R=m uUZƋ=;>u]Y_PRR ZZXQR	 ZR { ZR m ZR [ ZYQR 2f ZYQR 2O ZYQR 2xZYQR 2_ZYSQ  Y[P< tFXô
PSQU  U>V]Y[XUP3>F 
tEAX]PQS >R &S P[YXø PS U>V[XRU  
U>VP ]Z(*q3ɺO f`P  .  : P ͊>V"UPU1.XU bP ͊>VL7RZRZ0N>S[P3fafPfSfQ ۻ  f?_SM_ts OvQj Sj < tAQj Sj < tЀwrgrafGf tWO  Q f Yuf=   wPfXf,g8 tIt#gfXfg8 tf@fg@tgef&=$PnPuW32&C&:]u
uBf&}
 t7j &uSj`&]
[uj &uSje&]
[3tfYf[fXfPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j S< uf>  tf fPfQfRfWf     t;h&rf_fZfYfX
PXE-E07:  PCI BIOS calls not supported. .  	 uM.;D u. 	 u4 toh,'
PXE-E01: Unsupported PCI Devices! h`'ڊP]
PXE-E04: Error reading PCI configuration space. f3ffDEFGHS]m
T^Bus =   Device =   Func =  QW '_YfRfPfSsf  Gff  f_   D	 Mf   f  /	 8{rf  ff[fXfZSfPh'.Ph'.Ph'.PfX[f3S.z .0..0..0..0..>t.B@ ۋ .[j  wPЃ Xu
U |U....>.VfTSAFu u
...>t'h h h.> uhfSfQfR. . .2 <t@h)PH X
PXE-E06: Option ROM requires DDIM support. f    .  f    f.f  fRjfjf. ffPj h2*fQ˃ffu0hR*fZf    x
Invalid PMM function number. f u&h*fZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.f.> tf."ك0t=t	 t  ` b   fd f.d f    .$ Pj h  j .(% . tf.>   r. K         UU *
 V4 *
 33 x ZZ j*
  Z*
 3 .                                   `  p ,  (                  
   
    < @7! <  &      
   '< $   4       <$ $ $!8                '' <  h`hb B4hb @cP$ <p"x$ <" c4 @cQ  !  <" B0 $ C     <pBD  
 P <pB P4Db8DcDd <x" <# <t$    ' <  U<Uc4<     C $U<Uc4     CP $ <  G ! '	 !(  hchbC     $* @      'PDc <xB +C  @ < <PDb + @ <DDcDDb$C @    HDb B00 B$ B, @ @<  
$%  8\d0\b B0@!       PDb <tc  
B0PDbB0+C @         '!(  <$!0  !8         
        '             < 0B4 < 0c4 <74 <"@ $ <" <   ` c$+ @P  `     !H   <B <  C$+D  <# @!@   <  <B <c  $@ !C !H  %  D )@ )% <B <chd@ !C  D E F G J  K        '( $    k   <B @          <" <B @ks< <pc
 
 B4 <pc b $ <1& 2&- hp 2 @  2P       2 @           " @    a  $
 @P   " B$ "
 B, @     <pB  @hs
       >       B" @    b B0 @ $B  C     B @          B B0 @ks< <pcM 
 B4 <pc b <Ɛ <$!(  !8      (Ps 
    ( $      0 '     hbh 
 hb  B8  B0' < B4< c4 b<bc $b\c ]c <  < h b <  <  < $   <$ C 0 B, @ $ <" <$    b8 B, c,%C  @ $ <" <p   $0 B0 C $ <" b$$C  B4 b  <"ks< hb B4hb\b B4\bDb <c B$ <"\$d <B   <$   <ƌ <$  !(      '' !  !   -     h\qhbd &+C 	 @     @hphb  B0 @         `\b B0@           '    B0@          $ <|#    B0 @     <|     B0 @     <|  <|B@         '  PDc <xB 
 -     PDc <B +C @ <DDcDDb$C  @     <-     DDb$P @    HDbB0    ' <B @    Lb	 @ $ b$$$C  b Le9 
Ld      <c $ b     b B0 @     <pB  @ $hbL 
         ' <$$       lXb b    PDb <cB0+C v @    \b \b  4\b \d'  @$ <B B$ < 
" <B B$ <"\b \d 4 \b  $  b$ B0   <B @ 
 !C  $!   ! @  0 @ & D $ " 0 @T @4@ 0 @T $ 0 @T c4 0 @T c4 0 @T c4 0 @T c4 0 @T  c4 0 @T@ c4  0 @T c4 @0 @T c4b0 @T 4 0 @ 0 B 4 " 0 @     B  4 " # & B
 "  "   "  <B    %b    $ , $  B $  $      ( '            ' <c$    b < B$  b]b4 ]d'$(E   @<%(E    22
 T<b8<c!(@  <  <<bA 4 $  $    $    b!  !(   B4   b    '     <B'0 !  4 !  (  $8 !  < , $     T b B0 @    b B0 @ $b 
 $ <B B0 @<c4 b8< 4$C  b $bdb B0 
+ qD` <B B$ B,
 @     b $c B0 B,# $ <$b q8<p <Ɛ R6 <s&  g! `  !(   2 2 <0B4%b b8<$$C  b b 42 $ B4 bd  e! ` $!0 8< 4r  
 s @P!  b B0* @! ` <B   B$ <"g
 $  !0 <B B(
 @8< b$$C  b b B4 b 
!   B4 $d  br!  b B0 @    d  
 $ & N*@    u <1&!    g $  !0 2 @    b B05 @!  hb B4hb\b $!   B4\b  g $  !0 <  
!        <<0B4%b <1&  " B( @!  8< B4( $d  bp 2 @        $ <$  g $!0  !   $ $d  qb B0 @ &*@ $b <$ $  g 3  !0 ! < 8 4 0 , ( $      @ ' <B' $P L H D @ <   C8       
 B0b B0	 @     b$ <%C d   b 
!   <B B0 @     b<c4$C  b $bb B0 
+ d   $ 
 $  '!   <<$ s64B4$  q 16( $%5D`d   bh`    '!@  C: c,&S B,%b  `    hb B0+@      R &b B0 @     & .@T 16  ' $ B $$  <$C 
 C $(  <$C  @ $hb B4hb\b B4\b $b $ B!  d  d $q "2@ &.@ $ 
 "2q "2 B8 B,! @  "2 @ 0 b!    <%C  b 0 @ $ $b $b! P L H D @ < 8  X ' Db b <%C   b b<c4$C   bb B0 @!  Hb $   !` ! ( $  `B$@ c$  B4 c4   !p   	 @'     
   b B0 @!  Hb $   b0 @ $    b     å
  
   B$ ¥B0 B, @ $
 ¡   ¥  @ B0 @ $ 
 ¡  
  ¡  
        Õ ¥ b,N@!x    <!" " @       B0 @ $   ¥ < čc4$C  ­  $ 0$C 
   ­ $   
   a 
  ¥ $a 
  ¥   Í  ¥$$b   íD` b $ <%C  b $  ¥  Õ#C qB,@T $ $a 
  ¥a 
 $
<J5  ȍ $$$@   B0%@ Í$8 @  @c0%8 $H   B0%H" $$0&  B0%0  $$( @  B0%(  $$     B0%   $$  B0 %b    ȭ ǭ ɭ ƭ ŭ ĭ í Õ$J   ­Dc b <%C  b $a 
  ¥
 Ñ $ b!  @ $a 
  ¥ @ B4 ­ Db b <%C  b $  ¥  $
 C$  Õ$D $d  C $	 $a 
  ¥
  C!  @!L 
 $ č<$  @< ̍<c4
<J5	<)5<5<4<4
<5<4
 $  ¥  ˕$`B  c0 %`$P  B0@  Í%PB$HI ĕ    %H#$@( 0% %@$8  B0  Í%8 $0  č  B  c0 %0 $h %  0 $ %h$(E   B8 B0 %(  $$  B  @B0%    $ ̭ ʭ ˥ ɭ ȭ ǭ$ ƭ ͭ  ŭ$   ĭ   B0%b  c4a 
  í
 Ñ $ b     , @ $  Õ#C qB,< @!  B0
 @ < $C 
 @ $  B0. @T<    B0* @T< $a 
  ¥ < ¥ bc4 $$C  b $a 
  ¥
 Ñ $ b      @ $a 
  ¥  Õ#C qB, @!
 $a 
  ¥  $ <%C  @<%C a 
 ­<5!  '    d_wfv_vr11.1  0.rDwfrevi        atafrrEl        ebifknLr    rdwfinIv            a_whgotu        ` x   8 @ @ d   h   \  |                                                            DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:  Download failed

 
Searching for RPL Server ...  Abort

 BCM570X Found

 RPL SERVER NODE ADDR: 

Transferring data from RPL server ...   Done

  Transfering Control to program @  :   /-\|               tttttWS ˌt&  ˍ$        !PXEX8             {                       M      d      d                              PXENV+,$                        M@ d@                 fUfSfQfRfWfVfPF= twO. ~
&ێӼ h@ WPJ
&  fXf^f_fZfYf[f].>  u
~
&` . h@ fv
Phv.6 j ˃
fUffSfQfRfWfVfP. g]g} twer`f&؎м fUh@ WS
f]f&g}& tu   fXf^f_fZfYf[f]fg}&` ڃ> tj USf. ff f3ff   f. 3h f&f. ff& []  Ã>tj j ff9h uf. fh     Ý   V@ g&5   +g&5   ^Ã> t&j f. ff f3ff   f. S3h f&f. ff&[&   Ã>t&j fPj ff9h uf. fh fX&    ÝfX&   Ü=PVu NVf. Uf ]ϝ.6 .6 . . SR[.9 u r   Z[UVSvf&ff&GfD[^]f`. > t;su .$%t а r   fa.>  t-. .>$t!  r ӄt"Qf.>  u8Pwh3Ɏظ&. &G. [i Y3YÜSQ3ێËȋf.>  tFwhff&9tY[ f. f&H f.     3PQRv ! ˃ӈ  "X tZYXPQRv ! ˃"  
X tZYXS. &ێӼ ON t+73!XuVV66N^VbON3tڋxZ&[S. &ێӼ V=OFN3t	ڋ5Z&[   f~ u f~ u^& ꐋF fvyFafvCfvfv֐fv̐fv{fv븐fv뮐fv7뤐fvu뚐fv5됐fv놐fv{fvqfvgfv]fvSfvIfv?fvE5fv+fv!fv= tw#=
 w@. 
= tw#- dHiHnHsHxF += tw- vH{- Ht- ϐF^&~@  >G t  hD2VZ^&GF&GF&GF&GF&GF&GF&G
FD<D?KG  >G u  G 3 3   >G u  FFhD2rYFF   D
uЍDru^&GK^&GT>oFu^@B&G \?^&G >Fu^&G	B^&G
P^&G	 ^&G
 G 3   >G u  FDF  %F@P P YFF^&9Gw&G^>^Z3 >G t>GtD%>F*G 3   FDf+fF^&GtN&GtN&GtNF&F@P P lXFF^&9Gw&G^>^FV"^G 3   VFD^uRptu?LB
FVFtL.
;Fu;Vt L
u^; ^ E?F^Î 	F ^ u	PPX	F   Y=F~'}*^f0fP <	^N&^ f	Ftŋ^ u
fjX	~'u^fPF>\^f&OfN^G F^F  ^&  &t.f&OfNF  F~}-^v& ^F&F  ^F&F~|F  ^v^F&F~|^*&GHtH|pH~I	^& FF^f&OfNftfvvQ&UV^&F&FF  ^&FF&9Gv:fvf&p&@
Vv^&@
Fv&@
F뻐^G  ^fG    ^FG0G2  ^FG4G6  ^fG<    ^fG"fG8F, G*^fG
   ^FNF=3^ DG 3   >G u  FDF  %F@P P *UFF^&9Gw&G^>^F3   V>G u ^ F  F^v& ވ"FF~|3^   >G u  fF    ^&GtN&GtN&GtNDFV3   V>G u ^ >GuDVu^&G  >F*^&G^&G^&G ^&G
 ^&G,  F  ^*F^v&@^"F^v&@F~|աD^&G.
E^&G03^ UfE^f&GfE^f&G
fE^f&GfE^f&G3 3 3   >G u  DhFNRvh3 U^&G^&G ^&G^^&G$&G	^&G&G
^&G&G3   FD^&G^^&G^^&G^^&G^^&G^^&G	^^&G
F^&G^^&G
^^&G3 UfF fP6  QfgF^f&G^3&G&G   FDF  >Gt^^&G F ^uLptu9L&FVFtL;Fu;Vt Lu	^뚐F F^&GHt- r-  ^^&G  qp>8FVF^0u
fF   fF  _uF#F#V^fG$fFfPh8^&G  ^_'^>  t
3&G  k8F  ^>  t^& ^   ^Pd
^&G ^PFأ G^&G^G^&G^GF^^&v*&G
*&oF^&G A&u+&u$&u*&G*&oF^&G ^&G F  F^&GF^&G
^&?u^&G&t
^&G^&G F- t- t^&G ^&G}^&Gs^PE
u!^&G ^PF^1F^F   %5F~}^_t^Q^_'Q^&G  F6   
UG^&G3   FD<<8^9Gu9Wt øFV^0u
fF   fF  _uF#F#Vu3ÐfFf#Fft!^0ufh   fj ^fG$fPhB5^ _'Ë9Gu2Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^RPx10:0ÐURPx 0fv0 URP u @u
fj @fv|S4+4URP u @u
fj @fv|!4fv4   Sf+fFF^; GW ҉FV^fw^w^fwFV  ^^fh  FV  ^FfjFV  ^1vFV  ^CGG؉FG ^G^fG^fG^fG^f^FG_^7HOW #GG  fF^&-Ff~ t^fwlXCF  S2F2FV^扇^FFVQ+
u f~
tf~tf~Mt
f~mu
^Ƈ< ^Ƈ<,<2FV=(u u^+^戇<F<2FV^FFVċ^∇h1^,1FV^扇^F^怿ptqtǇ0Ǉ0 Ǉ2  1F^Ffj |1^fG   ^fwh1h% ^fj @^TFV=Tv,eK$F^XFVF%0 +- t- t&F ^抧F% +- t- t<VFFF@t^Ƈ.Ft^Ƈ/Ft^Ƈ=F΋^Ƈ= ^t>FVFt?F%? ؉FVFF  % ЋF	F	VfF    ^Ƈ,^pFVF^$-F^$p
F ^Ƈ, p {t^Ƈ /^Ƈ^怿quL/FVNfRvL//FVN^怿uNBfNFfv/^怿/ub fF    
 k.fFf~8 s^P=u܁u֋^ #^抧0t #^-fj Dhfh  ` 8h^fǇ   ^ +ҊԊ*ҋ^扇^ xFF  % ЋF^		^抧0ukǇ5  ^Ǉ7  ^Ǉ9  ^Ƈ; ^拇$-@ `uta- t\-  tW- tR-0 ~ tEfFf^F*5Ǉ5 ^Ǉ7 ^Ǉ9 ^Ƈ;f>b    s Ƈ* ^抧pt	fǇ `^抧ptu;(uƇ+=Ƈ*뼐Ƈ+^怿* u&~ t ~ tF+~ t~ uƇ+f+fF^抧0u!=u 0u
fF  ` fF  @ fvt ^怿.t~t	/ 4  *  Ƈ4^ "^抧t uOh  h ^ h*^ ^ mF
P^ FP^ h^ ^怿< th 	 )t^怿< uj 	 h ^3wFĊ֋^*^FFVF^*䈇^FFVĊ^*^F^抇^抇^抇^抇^抇^抇^fǇ    ^fG   ^f+f^戇^戇^扇^扇^Ǉ ^ǇdK f^ǇhK j^Ǉl n^Ǉp r^扇zx^扇~|^扇^扇^Ǉtv^怿u>@*FVf^抧 ufNf @  uN0fFf^拇HHtfǇ   ^Ǉ fǇ   ^Ǉ  Ǉ ^Ǉ ^Ƈ^s&uF^怿 u(uƇƇ^fGfG"^怿* tfǇ    ^Ƈ3Ð  SP #^& #^Î 	 #^è 	 #^ 	 #^ 	 #^G    (^GW^G  ^f+fG^쀿;uGGA|   $FG^'^GW^싇7FFG~^'^쉇  ^Ǉ   ^fǇ  @  ^Ƈ^f+ fFfFfF^f9 v(kD<GFf+fG^G^Î FC#ǐfv fF    fFfF^f9Gv)kD\I؉FG
 ^fG   ^&F"%u(^Ǉ PP| ^ u^ƇÐ  SVF  fwhh(^/ t ^}^ t^/% @fF   fv h^fǇ    ^fǇ    fj | gfj @]^*u	ǇT ǇT ǇV  ^fT /^0t.fF    fFf~Psfj FV ^?ݐ^_f+f^_G
  ^_G  ^_G  ^_G  ^_G  ^pufF   vG u!0u
F  F?v'F 񐊧 u
fF @vfF@v^tpuNfvl /^  u#up FVN Rvp fF4 $fv hfj@Dfj Dfj`Dfj4Dfj
8D^0t5fD^fDfh    ,Dfh    0Dxfj \nfj  \dfj DZ^;t"fj P$F^fwT$8^7hj X$"fh `  \$fjH$fjh$^fGffP,fj^*^fǇ     ^fǇ     fj Yfj Yfj ^ fj ^^f ^9j ^9HǇ  ^;u
fGz    fj;fǇ     fj ^ ^f wfj ^j^5j ^Wfj lXfj tXfj |X^fG    ^*䊇*튏****%FF  vP8fh  <fh &  dfj yfh   lfh  _fj Ufh Hfj>^fd</^fh< ^fl<^fp<^fx<^f|<^f <^f$<^ft(<fj 8<^fw<<fj 0<^fw4<fh   @<zfh   D<m^f0 <^^;t
fj 0Jfj  @fj 46^fT  ^* uU$fF  khf ufN	 khfv?^fT ^;u#+FNPvh( :!fj dfF  fv LfF  ^u uf @  uNfv Hifj (_fj 8Ufj Kfj A^; ufj ,-fj $#fj fj fj ^fǇ\   ^t\^f\\^fǇX   ^tX^fXhfjP^ptuUF F  fv|^
^b^ t2^ 0 F  fF    +uF fFf~ds
 ,^9Gu9Wuf~d fF    fFfFV^f9Gvc ^v_9 u69Pu1fFff`  ff^^w^9@u9PtfF^f9GtF ~ tF~ ^Ð^ t; 3^  SfjX/^GW$FNRvh^3Ð  Sfj X^GW$FRPhz^_thFNRvh^3Ƈ  Sfj X^GW$FNRvh 3  PSVt7؋GFF F؃
H^F(^e- F؃SFF  ^fGx^f9G
v^F^fD3^ÐfG
^f)Gx^GpFFGFfF    ^w*^f@^fG^w*^f@^f^w*^@F  FF^VGW
^拇9HNA#FFF+ҋ^9W r9G
 ^O^FGpWrFGFV ҉FVF+;Fu;V ^f7^FV8^fwFV  ^^fwFV  ^^fwFV  ^^拇9HNV #FF  FFufF @  FfFFMRPFYP^怿ptquj vFY+,^6F^qF~ 3^Ð(  RPSVFVfXZfFFtfFtfFtffF tNffFtN`ff~ t ^ÐFXZfvhF^ҋVf+fFfFfFfFFX^ҁ@ F؉VڊF$F$`Fހff   Nfffvށ 	B	RFF^9>F  vfrFp+F~}^Ҁpufj3^Ð
  SVs^f+fX^^\PPhfj \fF    fFf~'  sh[uf+fFfFf~'  s\9uF  I^ ^PF^6>Fu^P^ ^FuF~skF|F F붋^^ ^>^_G
FF+ҋ^9Gu9Wt<;u`w@F^&[^7HNA#F3^Ð  S/ t A	^^/%  s	^
 3Ð4  SV;u_G
FF  ^ʋGzW|G~F_GFF  ^GWFVfFf9F9^ʀ; t_FV ҉F̉V΍FЉFF  F~s1FFV΋^^v PԋF^F^GF t^ʃ& ^ʰE  ^G^- GG  ^f^fG^f^G  ^ʃPF^ʀ;u-7HNV #FF  _G
FF  5HNV #FF  _Gѐ^ʀ;u
fFfGzF^VGWfvXp^Ð  SRFV^* t
fF   0tfF  fFf#Fftz^^3  F   tf tfu; ttt
NFÐt	NFtNF  RPSF  tIFt)FtFtF 7Ft1F *Ft#FtFtFtF F^XFt^ tt
^X^fXh^\Ft^ tt
^\^f\\3ÐUSt
^Ǉ 3Ë^Ǉ 3Ð  SF * tÐu/0t# ^ FFu	^ ^h ^ j^ h^ j^ h^ h^ h2^ h^ h2^ h ^ rh 
^ e^苇t- t	-  ?hu
 Bhh^ 5hh^ (hh^ h ^	 3
h^  ,FV=(u# u^F^芇<2FFFꈇ<F  ^耿< u6j 	 ^fv,fǇ    !hh hh^ vh 	 ~^苇SVF! hF FA \F  F PF !FDF@ F F 3F@F F !u- = w.|55 5,585D5V5^f t!v3v^ v^	 ~u	h 3^ G^ =FF  j^ ^tpu+ujj  qfF   ^芧0u 0t
0tF F  c'F~ }^ FFtF ^f u F= uF ~ t~ u^Ǉ FF9F~F  똋^Ǉ ^ GF^fTVfFfNF% F N^fǇ ~uNfjP ^芧pu+tfNfǇ ~uSNM^芧pu+tfNfǇ ʚ;~ʐ= w.7P766777P7P7F^VTVfv 8fh  +݋^芧0ufh   fj
݋^胿uF^  F^FV/3Ð  P
@NF  FPvLfF    fFf~'  sL܉FVF  uF  f~'  rfF    F  P
 NNFPQLDfF    fFf~'  sL܉VF  u   RPxSܸhۉF@RPhF  hۉFF@t SF~|Ð  RPSfj @۸ .fhTveK^P۰FV^tIpt=fj pwfF    
 fFf~a  s pBۉFVFtfh  h7۸( ^f^fwh^=u$ 0ufF  ` 	fF  @ fvtfj @ڋ^ 0u_h 3afF    fFf~ds^3Āuh^ 0^< th j 	 h ^3fv^u
f@fF    fFf~8 s^PN=ut	
 
fv^^ڋ^ ptpuDfjPٸ PىFRP Pٸ V
fjp  ٸ C
fj  P3Ð  PV8hىVF  fcF$FV΂RP8hF  
 LF~d}8h\ىFVF @t݃~du3^Ð<h;ىFV*ȋъĊ֊n*ɋ؋VԊ^  RPS*j P\
F*j P`
F  
Fu.F~{~ uFtfF   fF P  FfF @ fF T  FF*+ҋ^{t  F  fj FVF {؃F~ @r^&wf&w
FV&G ^ ^&wf&wFV&G ^ ^&wf&wFV&G ^ FFfjFV ^f&7FV F  :fjFV fh   FV^f&7FV ׸ {
F~sFV ^&9u&9WufjFV vfj FVj{3   RPfF    fFfFf9Fw^Ff7FVFV(   = uuF PF TF  fF    
 o
fFf~'  s,fjFV fh   FV֋FVtf~'  u 3  PSVfFF  7F~}+F% FF  fFffFFFtfv FF9F}^v 1F1VF  뭋FV^Ð
  SfFd   fFfNft^ ,uF  PSF  ptuh 3m< L	3F
 FF3FFN~ 
~ th ^3( 	F  F ^ 0P^ h@^3^	 wFh ^	 h ^ h^ h ^ F   F
P^ h ^ ^h^ p^ F   ffF^^9 uF^9  F  F j^ h@^ h@^ F~~ F
P^ j^ F  ^^ ^ F~|h^ ^FF !F~p^ F^ F^FF ?F  F~}TF
P^ j^ F  j ^ F~|h^ ^uFh^ j ^ h ^ j ^ h ^ ^ P^ tv^	 gv^3[F=uD =uE =uF =u =uG =u =uH =u =uSty=uTtn=u]tc=u^tX=umtM=u
tB=ut7=ut,=ut!=ut=ut=u
MuÐ2Ð  hщFfRvhѸhщFf% = UPS  ^G  ^FG^G  Ë9Gu2Ð  PSV@+wV9Wu2^ËF7@^F^G^Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^  SVGF9u3^Ð@+wW^Ov^@^Ð  S F_GFF  ^fGtfFfFf9Ft[^6X؉F  ^PF^G
^F9I#+҉FV^fG
^fGx^_GFF  뜐F^VGtWvÐUfvb 8  Sst2"=t(rF^Fs^Ft^stfh   h
Ð  SƇ^f+f^Ǉ   ^G G
^Ǉd f^Ǉh j^Ǉl n^Ǉp r^vt^Ƈ^^8,t-
 +%< FF  V>F F  PF F F F ڐF ҐfF    uH= w.pF F,F4F<FDFLFF^V3Ð  SF  FF+ҋ^9W$rLw9G"vE&OFiF ^p G^fG    i^ p  ^GW^&F뤉VFF+ҋ^9 rOw9 vGÎ FiF ^p8G ^fG&    i^ p8l ^G"W$^Î Ff3  S
^&O^Pu  FFFFF+F   Ã ÐUPÐ  PF;FtN~ Ð@ &l &n   h̉FfFRPhfj hfF@B fF    fFfFf9Fv퐸hRPf@B fYf3ff> Ð  f6> RPfXfYffFfF    fFfFf9FvBfh  4RPfXfYf3fffÐ3Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^          2ff
   fP UfP fºffff]UWfP fºffFf_] Ð3Ð2C@@UPQRN;ssZYX]1ff       Vff  
@ &6 +&6 3^     X	S[	[P6  SfZ fFF| f^ fFfb fFFfd fFfh fFFfj fFn FVFP^ȲAt 3  VF  ^f+f&G^&G DGh4GG fG    fG  FD^t	 ^ ^*䊇船>F* ^:tF ^t"hF ^B^*䊇荹 hgF  ^vވM @^MwF~r؋^ X^Pq th.F ~tf.G^f&G>2G xM#G^&G^&G^&G
y^&Gs^&GF^ h@ 3 th`À>G u+0u$GPj
 .GRPfXfYffff

tYG*HtHHt7K>G}u<GPj
 .!GRPfXfYffff]
>GwVuG>GH3Ð  FDF F^^Pc	
u!^P	F^X	^G@WBÐ3Ð  PVF  ^^v& ^M^v&@F~|֋F 
^&G^   FD^Î /	Fuv^ u	PPX[F  ^f0fP <Cǋ^^ Fu F~'|ŋ^ u
fjXǁ~'u^fPFÐ  PSFDG  ^fG    fF^fG0fF^fG4^fG<    ^fG"fG8F, G*^fG
   ^F3  VFu^Ð؋G FPS ^G^G^S GQ	^G E	^G@ B	^GW  0	^GW	@ 	^G!W#	^G%
@  	^G'W) ^G+@
 ^G-W/F  ^M^v@1F~|@ ^G7W9^ G;( ^G<W>$ ^G@WBF  ^4G^v@DF~|础DN^GLGB^GN 6^GPF  ^v@R F~|BS^GXFZ PhhI^d 3^Ð  VRFu^Ð؋G FPS ^)GG^G^S G^G ^G@ ^GWGG^GW  w^GW	@ e^G!W#J^G%
@ G^G'W) ,^G+@
 )^G-W/F  ^M^v@1F~|@ ^G7W9^ G;( ^G<W>$ ^G@WBF  ^4G^v@DF~|础D^GLG^GN }^GPF  ^v@R F~|BSY^GXFZ Phh^d =3^  VFD^PF؋GF^^&} F^G- F^?aYQGF^GFF+F=CG*$Ht	HH~~:^GW	=@^GW
t=WtueNu	2G 2G  GF  CF~}-f^v@"*N t݀Nא^v@"F^F#GF~}>2G tF F  먐^G<)GhphxF   ~^#GF~|hqfj
 .!GRPfXfYffff ~ u^GW
^G tGWnF*G,G^G@t)GWRF؊N.G0GfG^G- Ff*GfР*G% RPF  PFF+*G,GG  ^G)h
 t thj
0G
h]
.G
G
^Ë^&F^^ÐA  SFD^P
u+^PF^&^G^_^G3  RVFF  eF^&9G,~_&x2 ~Gf&p.fv&@2
v^&@2Fv&@2)FF~ D3^ D 
u	DÐD  PVFu^ FDG FPfF fP^&GF  ^v^@F~|^&GFf&GfFF  8vf&p&@v^&@FFF^&9F^VG@WB^F3^ 9Gu2Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^À>wD uwDvDtD   Ð3ÐUPFtDuvDpDrDvD ÐtDÐ  t À>vD uFV+pDrDFVfpDf9FsfFf+pDf  fFfFfpDtD+9Vwr9FwF)tDfFfpD3ÐvD 댐  PV-F8Ft,F~ t$* 	 	^ÐUPĊfÐUPV*ȋъĊ֊n*ɋ؋VԊ^	t	-t-,u 3Ð            Adapter - BCM570x NetXtreme Family B57           HardwareDriverMLID        
            `X  X                      	  
                             
                                                                                                                                            `a                    p                                                                          `ں  ZZZZXXX                [[0[[`\*[w\Z|\\/\`[[0[[\\!\"\)\$\Z\K]E]/]Q]]]```+]+][U>Z4 \+& Uu[u 	XZ
 ]˺Z SVsrt*ݕ+Y^[ø.3Z* &D&Tr+ t+ډD&5&].3Zù  ZøtK
t(S [;Wrw;GrWڋR [;u+u+DDڋDuP XÎه\.Et.  ǃPG*_G,_.O7Huù R.X tXu跩 +gl  gn  7 ñ..Y.ZYr`7Gû6Z 7t&&TW&L+.Xu< .:3ZuOu让.3ZY+.:3ZuuL
Lt\
DPX3~u< s"UX+Ұ.:4Zt+EZnZ]˻6Z  Y  &LOΌOWtَډ7G+&&DøV ^uY&,YXE"u.Yt!YYV^tEU*+QuMZYcQ Xu.4ZeZ`]Q".>Z u.>Z u;Y.>5Z uWu(g.Z.5ZD,ث+|t#+.X..X<rg3.X.X &u&D=vV pY3ɈM .X&&\&T##At.X.9Yu.9Yu.9YtÿpY.XrF;wr&\tItJpYE ].XD&D tz}.X@Mt.X s..X.X@_pYQ&|upY+&dE
&DE&DED)7.X Y@pYE<w.X
Dxt.X;wŉ5EEEU.>XtE  m.XM
u+P.XEP&DEP&DEP&D
EP
ZE.;YuYuJ&D&D&D&D3&L,\.&W&l &T*&LMt
+;r&l*X.X3Ã
Ëŋ+Ht.X
u&Dٽ.X.X+\2&L,&/Iu&l*\`  KBPUSQRWV^_ZY[]X+&D*.5Z+tZ,T+ێÊ&S+ێÊ&&G[úY|w! Lr	t+u+YTLʉLuIuËDDDV^\|uAྼYD<w<XøZøYøXøYWVQX  Y.Y.Y.Z.Z.Z.Z.ZY^_PS [X UFFt%&?	u
h&F^&? u UPFUPFÐu32PSQR 3ɺO3ZY[X   fFV
fFFtf~ t^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_ UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UP$0F<9vFFÐ  U<ps                 d$ $PnP       o              
Copyright (C) 1997-2000  Intel Corporation
 Intel CorporationIntel Base-Code, PXE-2.1 (build 082j) $    I $BC$+   @:^   
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 thP~SwQpRibWZT1
-AX- -BX- -CX- -DX- -DS- -ES-:-DI- -SS-:-SP-
 ÜPh)tX
Waiting...               
  t^@:^ 
h h@ UfPfSfQfRfVv&  &\f?UNDIt?h_& o
PXE-EC4: UNDI ROM ID structure was not found. Gs<hk& '
PXE-EC5: UNDI ROM ID structure is invalid. Pj Sj < uf. fGf;sff. ff. ffGffGff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZNffW.; s. @ 6& ԋfPfSfWfUj j fj fj RfRVQ@ & v &D6E&D6E&D6E&D6E&D
6E
fFffЉVf. ffЉVf. ff6UfGff6UWhTw
˃f6UfVf6UfV
Z cv & tl tc" tZK tQ tHh]Rjh*
PXE-E09: Unexpected UNDI loader error.  Status ==  P
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>  u=h$v & 
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sLh\Pv &  r
PXE-E20: BIOS extended memory copy error.  AH ==  . f.f^f. *rv&D &L. &;D&s&D&fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(Dv
F&DF&D&DPj Vj &(D	v &D6E&D6E&D6E&D6E&D
6E
Wj v&\Z
  Wjuv&\Z Wjvv&\Z  t  uj@ H FF  RWjv&\Z  t{Xt&t
 u tfS^
G HF+F)F[fSVWF  6	fff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 v&< f^fZfYf[fX  t ]˜= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]r.>  u	  . 	Pfj j .(   fZfYf[h
1P<Xt/
Press <Esc> to abort ROM initialization... fPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j V< uf>  tf . fSfQfR. . .2 <t8hq
PXE-E06: Option ROM requires DDIM support. f    ff    .  f    ff  fRjfjf. ffPj hfQ˃ffu0h;fZf    {
Invalid PMM function number. f u)hqfZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.. Pj h j .( . . tf.>   r
.                  blksize tsize                                         U ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j    |      
CLIENT MAC ADDR:  
  PXENV+     GUID:   
DHCP. PXEClient:Arch:00000:UNDI:000000  PXEClient CLIENT IP:    MASK:   
DHCP IP:    PROXY IP:     DHCP IP:  
GATEWAY IP: MD  BD  UD  
Auto-select:
      
BOOT SERVER IP:    (  )   
Auto-select:
                                                                                                -->  MTFTP 
PXE-T :   TFTP Aborted  ProxyDHCP service did not reply to request on port 4011.  Client could not locate a secure server Missing MTFTP server IP address BIS bad entry structure checksum  BIS get signature information failed  BIS free memory failed  BIS get boot object authorization check flag failed BIS shutdown failed BIS initialization failed BIS image/credential validation failed  BIS integrity check failed  Network boot canceled by keystroke  ARP timeout TFTP open timeout TFTP Error - File Not found TFTP Error - Access Violation Error received from TFTP server TFTP unknown opcode TFTP read timeout TFTP cannot open connection TFTP cannot read from connection  No DHCP or proxyDHCP offers were received.  proxyDHCP offers were received.  No DHCP offers were received.  No boot filename received Invalid UNDI API function number  MTFTP cannot initialize NIC for multicast Error while initializing the NIC  Error while initializing the PHY  Error while reading the configuration Data  Error while reading the initialization data Invalid MAC address Invalid EEPROM checksum Error while setting interrupt TFTP too many packages  TFTP packet size is invalid Media test failure, check cable NBP is too big to fit in free base memory Bad or missing discovery server list  Bad or missing multicast discovery address  Bad or missing PXE menu and/or prompt information Could not locate boot server  Invalid state returned from UNDI  PXE-  Invalid message code.
   /-\|            
SM/DMI BIOS functions needed.
 _UUID_  
									       
      
 f~ u ːf~ u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- r- v뾐:: 1LP3 뫋F fv?FF^&)~!~ofv'ҐfvȐfv뾐fv-Fu
hx9 i[F 롐fvFth I[fv[fvmofvАfvƐfvA뼐fv벐fv=fv?	3=1 tw5-  = }.f             $=q )w-2 tHt-= 7-s HHH!3  F  
9  >9 t  JLfFf99f2hP99@t{<IutyIu^h
JuShRF   }R^
RF9*9Fr䡸93MuIun>huYu
"Ft1J9NMqIH~ t~tEVjOhRF FP)Fu9Fu9R 9뮐U>9 t>P3 u>: t  II9Lt9 9 9^&9   V3Y-  +ҊԊ*҉FVFP+$FVu3^Ã>3 t3+ҊԊ*ң(3*3(h2fj vPfj  E/t	f(3    7f(3*3f9FsEy WN뜐T3 fvfvh2fj h96:6:6636H3 |3O8tְE뽐>2u}(3*3% (3ҀĀ FVf(3fFGT3 fFf+(3fPfvh2fj fj fj fj FV37ufvfvf6(3 |K
u	E" 9Uhx9bWFFV^f& |  PVr$=NVu^F^f&G(fFXfv^^  ^&G- r- v  &iGNF^& u*&G^& u=& u6F&GF^&G#&r&G^f&OfQfv&GU3   >9 u  >: t  >P3 t  G|F9f&G    f9  fP2 ~Uf9H fP2 mUf9@ fP2 \Uf9P fP2 KU9S*&GP9&(G9&G0FF  FF9&9G6 fNfNfQhhHT7Uuh:T^*&O;~S*\P
u3^&G^&G^&G^&G^&G^&G^&G$&G
  &G^S*&G
P^&(G	fF^f&G9(It  3!V;.33   ^&  t&  }?  >9 u  >: t  >P3 t  Eu֋FV RPF RPF
 RPF RP^3& 2),u: >: u  3*E3:   >9 u  >: u  >P3 t  fF fP^f&OfQ|1F^&G  F-tHHu9  5  F^&G3   ^& >9 u  >: t  >P3 t  Cu^f& GP P P P& & & & & & 33^&^&Fuf(3f& 3 f&Ǉ     F   >9 u  >: t  >P3 t  ?Cu֋FV RPF RPF
 RPfj E S3ҳn*F2CF^&~ uf(3^f& ^f&Ǉ     F=3 =2 }
c F -6 tHHtKU>9 u  >: t  >P3 t  Bu47f^f&GP33 >9 u  >: t  >P3 u  B3P3   >9 u  >: t  >P3 u  FN~ tIFV RPF RPF RPF
 RP^f&OfQ&G9Ft^&G3 F^&Gv  F>9 u  >: t  >P3 u  ^&
 uQ&G
^f&OfQGPGP&G&W26uF3 F  fF   fF   f+fFfFfFfFfF$mIfjFPvGRPfj*F $KI~ t
E! FËFFtE# fFf Ð  fF   ffF$ IfjFP	GRPfj*F $H~ tE! 2FÐFFtE$ 萸 Ð  fF   ffF$HfjFPFRPfj*F $xH~ tE! EÐFFtE% f~ t 3  RPfF   ffFfFfF$ HfjFP)FRPfj*F $G~ tE! REÐFFtE& 萸 Ð  fF   ffF$GfjFPERPfj
*F $G~ tE! DÐFFtE' fvFP|E L  F+;Vr
w;FvFFF3fvh3HE^KFV "  RPfF    ffFfFfFfFfFfFfFfFfFfFﾭfF    $FfjFPDRPfj*F޸ $F~ tE! D f~ uf~ t  3 WV2   It2^_2&sE( C^_ÐS*&G7H
u⸀22f   ftrHuVHu0HuHu 2^_  RPKHu0fvfvfvFVFHtF  ~u  3   SRPVf~ tDt@u2^ F+v
rD7D0^N&FN+FFNu^ 
  SRPWVF`4^ht32 Kt3R3u39v3h3h
 Kf2fx3 L|3^f&cSc>
  t^&G^_ FHtHHt- tI- tJ-
 tE~3  ^& 5F^& FFHt1HHq- t- c-
 \|3  ^f&f3뷐^& F~u!^& 2F^& F^f&^f& ~ ^& 7FvF^& F^& F^& F^& F^& F^& F^& F^& 
F^& F^& F^& F^& F^& +F^& 6F^& <F^& CF^& F^& F^& F^& F^& F^& F^& F^& F*F^^&^& 9F^& F^& F-  -  -
 t^& ^& Fu{>  t4  h"(CcG			th&Cf6	Ch. Cf>	 t.^& aF^& F^&  FfFfPf6	 AI~u(^& 6F^& F^f&^f& a^& ]F^& FGFJ^& ^& ^F^& F^& F9&_&G	^*& FF9&_&G^& FF^& <F^&  FfFfPh6  HfF fPǺ
  /fF fPF
  fF fPF
   ~ ^& +F^F& ^& GF>  t'^& F^F& ^F& F^&-^& F^F& f% !I^& ^&>2uM^& F^3& ^& FF  !^33H^& &PF39F|^& F^&^& ^_ .@f2fj fj  3Qf    f2f88ht3fj h: C$,h:ht3GUPV3^*& BFfFV^f&G<^&Ǉ  ofFV^f&G@fFV^f&GD̐fFV^f&GH븐fFV^f&GL뤐fFV^f&GP^&Ǉ  ^&Ǉ   fFV^f&GT֐fFV^f&GXfFV^f&G\뮐fFV^f&G`뚐fFV^f&Gh^&Ǉ  ^&Ǉ  ^&_h&u 3^& cfFV^f&Gd= )= wA.JNl=
 k- &H5HD- t-; ^- t^*&@ 9vO^   PV3^*& =4 CtHtzHHtN-
  -  FfF^f&GfF^f&G^&_f&G^f&GpdÌ^&G&W^&_f&G^f&Gx;Ì^&&W^&f&G^f&GtÌ^&G&WfF^f&G$^&_$&	r"^f&G$ fPhX	 DuF F  F*^&  Ì^&G&W
^Sf&G fP&_*&G~Ì^&G&WjfF^f&G,h^f&G, fP&_,*&G@C^&_,&_*^&G|&_~-5 {H- 	- t- t:^*&@ 9v^f& tf&$ u&  u
& & ^ U^&?t3 f2f&9Guf& cScuf&  t؍GPh
9*Cuø    WV3F Dvvv^&7Vj
 & RPfXfYffff88 9 7:fj FPfj fj j 3Pe+thBtix  RPhVBix  RPix RPT
ix &n tF ^&ix&p tF F Fix=zP^&7~ u~ t	^_ 3^_ UFVl RPFp RP 332ht3fj h: C$' Ȏ  ǆr Dfj
 & RPfXfYffff77 8 8fj rPfj fj j 3P**thtȍtPhBf~ t^&uf~  tfF^f&9GlufFf&9Gpuh&$h@fFffFf2  3 UhfFp fP
 3
21ht3fj fFp fP$x& Ȏ  fj
 & RPfXfYffff66 7 7ǆr  hrPfj fj j 3P)t̋r- Dt-guhttPh)f~ tf~ ufF^f&9Gpuh)h?  3 Ȍ  PV3F}Pirx  RPirx  RPtʍtPh)
>2u~ u ^ÍtPirx  RPy
FPFP 3`0$0ht3fj FP C$%3^  RPVF  ivx &t u-FF9F"ivx &n u3FFF>2u
ivx&v uF ivx &p tivx&r ivx &p uF  FF9F}.ivx&n tivx&t tۃ>2u
ivx&v u9F=F Pivx &p "ivxf&h F  FF9F}
ivx&n t9F-ivx &p F  FF9F}ivx&n tivx&r u9F ivx &r ivx&j&hyivx&t {ivx &p XF  FF9F}5ivx&n tivx&r tivxf&h tivx&t uF9FH= .> zHivx &l t=h&$iFxP<ivx f&Xfivxf&`f2	 9f    f2fiFxPiFx  RP_ivx f&\&^fFHHHHHtHtiiFx P 3ivx f& t&ivxf& fPivx&Ę&G*3Fh92 ;F  h92 ;FF9F ivx &n tivx&r uiFx P Y3ivx &&t&ivxf& fPivx&Ę&G*3iFx   RP 3ivx f& t&ivxf& fPivx&Ę&G*2F F9F~  h)h&$: iFx P 2ivx &&t&ivxf& fPivx&Ę&G*K2iFx   RP 32ivx &&divxf& fPivx&Ę&G*1;~ t3h)iFx  RP9ivx &\&^ ^Ð3^Ð  RPFFF  .;3f~tf~ u
F C D~ r~ rF  hFP^^ V~ Cu~3*=*ht3fj FPF$2F   SRPWVFF  fj
 & RPfXfYffff*/3=0 0F  fj FPfj fj j 3P!kF- Dt-g\hOiFx  RPh8iFx  RPiFx RPivx &ĘT&uF Fivx &ĘT&9G F9ivx &ĘT&O#N; ~ taivx &R&P ivx&ĘP&G&WI9FVF  F39FsF^93u93u39Ft[~ tHF  FF9Fs-^vi~x ؎Ff& &P f&;\uȋF9Ft
FiFx=zs	-`F^_ V6hb0h1hn0h21f> t&ff9thx0h0h0hh0h0f>9 t@3f9 t1ƹ +uhc0 R09P0 @0Frh?0^Ð
  WVF9*f|
f2f2f: Dh:2[6f    ffFdF 5 9F~F !uxF ukF u^9F~
F uLF u?  F~}/^ۋ  FPFPtЋF g~ ~ u
FQ ^_ËF9FuFR ^_ÐFS 3F9v~!ix &n uix&p tFU 9vu1~ t+3F9v~!ix &n tix&p uFU 9vt1ix f&Xfixf&`f2ixf&\fFF^_F3^_ÐUfv2 4^f& u 3^& fvfF fPa^f& t&_&GtfvfF, fP@ 8^f& t!&_&GtfvfFl fP (^f&| u^&l tÌl ^&G|&W~^f&G^f&Gl^f&p u^f&G^f&Gp^f&x u^f&G^f&Gx^f& u 3&  Ȍ  >2u4f~ t-tPh-~ uEz k*3 fF^f&tPh)f&)f2fuFFtfFf2f~ t^&G&WE{ 륐399f~ t
^&Gu43:f~ t^&G\43:FFu	63  ^&u&G	*&G+4*63FFuH3  ^&u&G	*&G3*H3f~ u39,3^&G3,3^&G39f~ t^&u
&G333  FV   RP>2u 3F     > w$fvFV;fvVF^Ftʃ~  >2tOh)f6 1f  fP ) f& tf& fP&ğ&G*z)F h-f6 1 f&\fF     > w&fvF3fj F33
tF T3   PVf+fFFfF^ğ
&Fu^ >2uNF  F	9FsA^ğ
&^ğ	&9uً^ğ	*&GF^f	 fF~ u$^&GR&GPt&_P&GtEw T'qF ^f&P t&_P&GtF  ~ tz^&_Tf&GfFm/h)FP
*^&_P&Gt(fvfv^ğ
F&Ft(^ fvfj ^ğ
3&F F ^f&P t&_P&GtF  ~ thfF.h4)^&_P&Gt(fvfv^ğ
F&/Ft&^ fvfj ^ğ
3&	Fu^F  FF9FsIb.h(FFVRP(^vf&0fj ^ğ
3&Ft^ 3^ USRPf`~^NvVFn
fa
 Ȋ WVF  ^&  hPh&$Ph)h^V6  u^V6  u	3^_ ~ ud t^f&P t&_P&GtfX u	   
  ^f&P  &_P&Guy^f&T u
v ^_ &_Tf&t^&_Tf& t^&_Tf&   v^&_T& wr^&_P&Gt@^f&X t&&_X&s$^&_P&Gt^f&X uw ^_  
 ^f&X thF  =^&GX&WZF 				^&_Xv&@* F^&_X*&G;Fw^&_X&G;F~^f&\ tf&` u
t ^_ &_`& t^&_\&r3R
FN^&G\&W^F R


R
ğ
& tR
ğ
*&G FR
^&_\*&G;Fw^&_`&8g h%3
*&G;v
&@%FFrh%3Fs
f9 ufvF@?Ht'&+h%h&)%s[f9 tNEx ^_ f9 t3+ǹ +uh;% *%9Po% %Frh%h
%*F  ~Is)^&_`v& $F^&_`*&GH;Fw^&_`&uh$ ǆ  ^&_`*&Gfǆl @ Ɔh$2	&2&%hn$%tO%= Btw3-t-,u^& Iǆ  t#)F  F  - [t- 
t- 
tאĞ&8t&
uu@)h#ǆ  
*&G;v&@#Frh# +G%
h #ǆ  ^ğ
*&G;v"^ğ
& @#FrȋF9vFh*#FR
9FrF
2$*+R
FvЎf   f^ğ
*&GhXfhp  j VV33Q^f
 fPfh  p VV3 )vPF+- Pfh  p VV3 F#=.t = t -t-t^& )~ tNh fh  j V33f
 fPfh   V3 vPF+- Pfh   V3UF+R
=KF{~ =F  kF+R
='R
HFS-	t-
- = K-w- 9t-
t- - Mt- t- t
  SRPV>63 u63$ >T3 u9 >T3آ9>
 tFu&>T3^P ^f&f2f~ u	24
^&&W99t3   F  ^v& ވv3^Fv&8 u^fǇv3octeF^Ǉv3t FF9~ EuEf~ t>^&? ~4Fv3Ph $&h %@FFv3P^&FF9~ t?f(3    Fv3Ph  %h  %@F^Ƈv30F^Ƈv3 FF9>T3 u
'@'F9N3  J3  63L3>T3 u
z'@v'>T3 t	t(>9 t!ht3h9h2F9t8 >
 tFu.bL3 z>T3  fj fj fj fj j 3P ff92uvff9u:9u1>T3  F&&;w&&; f9f9u&:9tfj fj fj fj j 3Pu|J>T3 t>9 u963L3J363L3J3J3= uE2 2 >T3 >J3~ EF EN3 &- toHHt	HZ>
 t(~ u"hdFhlhh>u; \>u< O>u	= ^ 6 ^ ~ t4ft3   hx3hp
 !$ht3h9h2N3 	> ^ >T3 uE%+Ht
N3  >T3 tff9u9u9ԡ%- F99F~L~~E? k? ^ >T3 t>2 uF9F92  :?h2 >#>T3 u3^ ~ uf~ _^&? SF   f~ tY^&? ~OFPh *u<h )"@FFPZ=~ Et9느9Ff=E  v~ t`FPh  uMh  !@FFPY(3*3ft3   hx3hp
 y"ht3h9h2N3 NFP!@F- 9F}FPi!@F- 9Fft3   ht3h9h2N3 -^    v9t3 v39 >|Y$#^&- v9tf~ tfvl#PQv9!>9 tht3h9h2N39w  v9 J3  >43 t	43L3L3$ L3| >T3 tQfj fj fj fj j 3P%
tfff92u[ff9u9 f9f9u::9/hhfj fj j 3P	t92u9 3t\i>43 u>9 u L3J3J3= uE5 i ht3h9h2N39f뻁> >9 t!+H>T3 t-ff9u"9u>9 u>9N3      Ð
  P3FFFF 1^*䊇N t~ uFFFFF:9FvȋF+F+2@Ffj
 fRPfXfYffffF~ tF9FwF  ^)FXF9Fv	F+FFfj
F RPfXfYffff;Fs"fj
F RPfXfYffffF~#vF#F  SRP9 T3 f+f(3Pj
 fRPfXfYffff63fj
 fRPfXfYffffH3f~ tR^f&? tHf&f9M}b  T32  F
:9 F :?h2 8T3 FF E43  f9f"   fFfFfFfvfvfvFPF32NFt3-6 t&- |p- ~>T3 tNF ET3 봐F FPfj F}$>T3 u9  >43 t43  9v43  9"T3*>T3 199F~F92  :?h2 ?~  ^*䊇N  f9fPFHj PfXfYfffȋFڙډN^:9FwFV;r
w;v:  f9fPFHj PfXfYffFfFfvF@+؋FVt   N^299F}tfFf(3~ ~F~ uFH::92tJFV43?fFf(3f(3f9FKfvF@+؋FVBnf9fF>9 t
99F/>T3 t:92T3 2  E
3 UVVv^$&=  t)ArZw <Ar<Zw FC:t^^ ^3^   VfF    & *N-0 FF^v&8 t&80r&89v3^ F^   WVf+fFF0& *-0 N^ӉFVF^v&8 t&80r&89v3^_ FV^_   VF  F'F=F~F
u~ tF0^v& FFNV
 FF~ u^v&  F@^ h28hV32,V3X3EY3 Z3@03\3`3a3b3  r3  Ð  RPVl3Fn3 Ip3r3  ff9^f&f99p399F9p399  fv9F2r3ffd3^f&fh3p3 Z3b3  0303\3^3  X3
 b3V3^f&? tf&?u	W3 &?r"&?wh83&&W  ^ f~ t
^f&? uhfvfj FVFFV
22##^&&w#2#62;u5;u122##^&&w#2#62;u;uf&    ^f&? ufvSh83%FNW3 Z3F99F$fFfF^f&? "f&?9- FfF- F^3  F fZ3b3  X3
 o
b3hV3fvh83V 	FF- FFFOF ^3F Z3b3  X3
 
b3hV3fvh83 V	FFFFF+F;FwF^3F+F Z3b3  X3
 b3hV3fvh83V+V hV3fvh83 V'	F^   Pf+fFFFFFf>6 tKa;8rBw;6v:>9 t'F
?+ڃ6 689  
f6    hu~t	F~dr3 >uff9ú> uh뼐>uF  
 ;Fu$<uf9f9t
f>  u>uM% Ht H`f9f9Sf+f69Ff>  8N
?+ڃ$>f~ t*ffF^&G&t&9&9WF%  F~tu9Fu9Ftf~ ~ FffF~  ff9ff9999999~ u-F9  t =th1- 9]
;F'f~ t7F^&? t(&9t#F9Fff9FWf~ tf^f&f~ t	^&- F~ u~  - F~ uF9FnfvhnFF;FfFFfPhF
FFF9FO9F9  t<=t7fv9F[	;F? f~ tF9FvFfvhFf~ t^f&? ufFf&f~ t^&? uF&F   RPF  6^&&Wk^9u9ukFPfvF= F~s
k^ uhh? kFPfvFkFPfvFk^Ƈ Uh92 99 h9h
9*h9fF
 fP9*S3&R39999 99 ff9^f&Gf9h9fj G
P ` 
  F  :^&&Wk^9u"9ufvkFP9*3 F~sk^ uh92 99h9h
9*ff9^f&f9S3&R39999 99 F  F	 h9fj fj  FFt$fFF= uΰE 2Fz  h
=tĀ>
u>
 uf
^f&9ufvh
9*fvfv9* F>T3  h2E @0303@   f9fff  f9f 0303 
 hfj h:3Mh:99uh.:  th:h.:!tEb m  6893Ð  FPj9&_t Ð3  FPj9&_t Ð  fF    FPj9&_u6~Ku+~Tu%~ uEa : Ð~Bu~Pu
 3Ð~tްEVԐ  FPj9&_t ÐȈ  fǆz   ǆ~  xPj9&_t ÐȈ  fǆz   ǆ~ FPfv FPfv xPj9&_t    SQ @@@@;؋sY[FPj9&_t 2  FPj9&_u0Fآ9F֣R3Fԣ9Fң9fvFP9*3     fv  `  RPFFV؋F6F FFF~ uF  F FFFfFfFċFFFF^&F&uFfF    F FFFFFPj9&_t    RPFVFPj9&_ufvFP %
3          .&NXf* PWQRU>   @  h> j>9&] us>@ ul>L |i>L |b>L w[>* L &D F +ȋѽ  ( B +V6H ^;s#  u>@ u
3ԡ( ]ZY_3 ~W>   @  h> j>9&]_f`.&N>9tJ.   0  h. j9&_ u0  t9а r   fa.>*N t&.(N! 9r & ӄt"Qf.>(N u8Pwh3Ɏظ O&.(N&G.*N[i Y3YÜSQ3ێËȋf.>(N tFwhf Of&9tY[9f.(Nf&I f.(N    3PQRv ! ˃ӈ&   .,N"X tZYXPQRv ! ˃.",N  
X tZYXUV3 Ӌ^]UV
 3P Yv  t2؃ Ӌ^]UVW  _^]Q  2sYÀ>[
 u[
Z
X
   Ð3ÐUPFX
uZ
5T
V
Z
 ÐX
Ð  t À>Z
 uFV+T
V
FVfT
f9FsfFf+T
f  fFfFfT
X
+9Vwr9FwF)X
fFfT
3ÐZ
 댐  RP>
 tZFh FFhlF* %F^9N u^P mhFNuhUÐ  PV>
 t7$
F 8Ft)F ~ t$ $* ^ÐU+ҋFF    PRt$TEVh ?	-t-,t  PWVf~  ~  FN ^~&&Q#2#222##;u;u3Fsf9 u^&&Q99^~&&Q;9u;9uo^_   V^f&f#2fF^f&f#2f;Ftif~ u99^ 3FsL2499u99t4^&&W99u99uFs99^ 24^ UfSfQfR?f3^f^ff;sf;wf;rf;vf;s@fZfYf[] SQrY[ PS [XUFFt%&?	u
h*&F^&? u UPF  ^F&*: .^F&*' .^F&* .q^*&    P
 +tF
 +0>U^&p^&Gf^&G\^&GR 
^&GC^&G9 ^&G*^&G  ^&G^&G	 ^&G
^&G^&G^&G
^&G^&G u32SQRu	s22ZY[SQRu	s22ZY[SQPRs2ZXPRZXY[  PF 
^F& FFNuF   2*&GÉF&? u2*&G F^&? uF^&? uFF+2u @tHH  \
  ^
\
t\
f&Gf`
&Gf
&Gd
-\
  ^
\
tk\
f&Gf`
&Gf
d
 @h
  d
td
d
37d
+2  2f
9h
u f>`
 uh4 áh
h
uf`
fj
+j
l
f6j
2+2 d
)3뫐URtt Ã>  u3u2&8Fu  V+ɉNFu3^^f&
 t&ws&G
&W&O
NF3^&GFF^&9wvfvhV u^&9GtS&G
uċFV^Ð  YVthn
V	 RP n
Ð t3Ð2&rhn
Ì UfVfWfSfQfRˋffV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F320fZfYf[f_f^] fSfQfVfWOfCORPfEDOMf    f    r'fCORPufEDOMuf=23AIt
f=46AIu   ff_f^fYf[h^_  F  f~ tF^F&? uF   fFV
fFFtf~ t^F&^F&
uFV   PfFV
fFFt*f~ t#~ ~Nt^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_   PWVF  ~vNtFxF F^_   PWVF  ~vNF&%G<ar<zw, arzw :wr F  FF^_ US^FGFGWwGg
oF GFGWFGOG2Cuԉ[3] [[2ҹ G;tWwGg
oogwww_ϒ  PFFV^*&'*&Oû@ &l &n f%  fPf  f#f#f#f#f#f#f#fXS@ & & [ÌUWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] UP$0F<9vFFÐSW ۋSR3.:uJGuZRƀt%@u20 tt
 t2r< u	ZXCu33_[ö΀Z^_SM_h^v_DMI_΀0}^a$PnP΀@^M_SYSID_  P3 f~ tf~ u'  f~ tܸ NtF&? tF^&^&+t   :  rX%  tK:  t
%  !&  $  s9r%  c6  r%  Z5  r5  rH6  9  L:   撰68BDD   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $ k  r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  L  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ X  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 2  X  f=$ J  f$ f$ f    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 7  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t:  $ =$ u	=$  w$ $       f$ $    7     f=$    f$ $ f     f=$    f$ $ wf$ u  9  bf=$ uXf$ $ $ Cf=$ u9f$ $  -  $ f$         f$ f=$ 	r	f$   N    s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz.ZXfPfRfx < fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytEsZ[Xfz.fyu&sZ[XSR=$ tO$ @
 fyf@t	s/fxfz,fyB@u	sfz.Z[                                   P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPUNNNO$ONNO$ O'NNO$O#NONX     lFpoypvp @  쨀tYRfZ @  쨀t	c7     fmRfZ     55 uf
-  
f
-        Q$  sYa  ޿`     t  r@Y8Y1  |  fCfz     3   r    F   r   rR   fPfSfRf*fff,fff*ff3f uUN0NONfOufZf[fXúvpf  ftRffZf=tPSQ   P  XsHuY[Xfu ff;uPSQRWf  	ufz  3f} f ff ff frf%fGff;wf} _ZY[X        =      5  =  (  QS$    P $ O r$$
t   $ uf f  [$  @$ <   br$
tf f  $  Sf  P[rKSUU*UUUUU*U[P$ p  r
<uf f  SQR      <`u
     wr   $ tZY[$  fPSUU*UUU[fX$    pr
8uf f            PSQRf8fff`f  N$ffN$
fffظ  Nf$fN$
ff        =$  u ZY[XPRSf8fff f  N$ffN$
fff  Nf$fN$
ff[ZXfP >>?<u>>?<t>>?tĀ fXð>>?      2ff fff戰䈽!@   戰O     戰   戰䈻  @      @      u׾C%   C%   u戰f @KC8BBaaff fKua$aff fKuf f u           Ԃ  Ӌ؂  Ԃ      PԂ  Ԃ  VQN   `  Ԃ  aQ  J   W  ܂  Ԃ  Y^ð   Ԃ  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP	 %"XP 
   `"	XË                                                    `   $ff$
$0ظ   $ff$
Њ   $ff$
$3ظ   $ff$
ЊvaÐ            f  f  f  f f f f TDDf f  D/f f  Ef f  Ef     fHt쨎t<w.$f ffH$tt
                                         F          <     D                 D                 D                 D          x0     D     ?     0     D                D                 D                 D                D                F          P     D  `              F      X     F          \     D                D                D  1              D                E  <             D                D               E  @             E                D           @     F             D                D          T     F               D               E                E                E                 F             D          @     D         F   9    E8        E0      `  .   U       .   "       /           .   #       /           .   $       /          .          /   	       .   `       /           .   a       /   >       .   0       /          .          >          ?                  E       <qfUMf%f  $f$
tPppqtAfNUff   $f $
и f  $f$
аf  X$fX$
и f  \$f\$
аfUff.~ f"   f%" 3f  f  gf. ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 pV	 f
   `"f  f3f30	f  f%
  u% t
 غf  fVfV|ff  fغf  f﹖ WfW@ff  f  gff   `ffffgf   p$fp$
Ћfgff   xffffgf   $f$
Ћfgf   $f$
Њfgf   $f$
Њf   $f$
Њfgf   ƺ$f$
Ћfgf   ĺ$f$
Ћfgf   $f$
Ћfgf   $f$
Њff|  fff
   fgNf   ~$f~$
Њgf   |$f|$
Њf   }$f}$
ЊgNf   $f$
Њf|  fff%ff   $f$
$@f_Yf   fzYff   =u;f3ffff%  0ff?  0fF  0ff  0=u f%  2f%0f  2f%0fY]ff  @$f@$
= u$<]2f7Zff  @$f@$
и f  D$fD$
аf  $f$
аf  $f$
и <fZf% = ufZf fZnf % ugf [TfU../0./.f([,f d< ufC[fd< t<t
u掰fk[f䎊f}[ff[f掺<uf[f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  fffl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0f    UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
~] t
^+;wUN&NNO'NN ONf  X$fX$
и f  \$f\$
а08$     3ذf f  fff   t! tf  tf f3f  f<vn2ɵ|^rVtT<tq^t`^t	ـݵ^u<t^g<Hu	ـ݀rfffffffs sf;uff
怼$_f   u3 F_u#;sݰ怼n_};tMfa   ufa   ufa  f   f_g.:vfG_q< tg.:vPfa   ufa   ufa  f   f	_6< tg.:vfG
` g.:v fGff   gf.f
f;w
fffb   ufa   ufa  `` g.:v0f   tff   g.:Gvfg.:GvdfG` g.:vfg.:GvBfG`kg.:vfg.:Gv!`L$< t<w=C  B  Ba  a  Kuas6 .va<tH$tt
䠢
t@fغ  ff% f؀f   ttf   ff% f;r       uu uuuu      `p`p2PP<xxF&<<-ZZ400$HH*~2nf|  fff
   fغf|  fff ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 b	 f
   `"f  f3f30	f  f%
  u% t
 غf  fbf)  fݺf  ff  fff$ ff$ fffݼRcfs_cy2sG怿scuŁ$<r
ffŰ怼cj怼cr~	f  ffs2fs+f`  fnf  f~fn2ff32  tkfsdf  f	f`  fff*	f  ffƊf+Ëff`  fffﰥ怊f   @tŀr&`f   $f$
2f3f怼d}f   @us	f   @ffsJfsC~f  ff`  fffÊffغf`  fff^efj(  def  fغf  ff  ef   tec怼e>f|  fff%fغf|  fff("f|  fff
    fغf|  ffff  f%غf  ff  fغf  ff  fغf  ff  fغf  ff  ff """ff  f""f  f"f  fJ	f  f3f  0 f%"	f3f`  ffff3f3gff  ff  ff    ff  f  f  f f  fغf  ff  f
 غf  ff  fغf  f	 f
   `"f  f3f30	f|  ffff    f|  fff~.u;t~.\`f   $f$
Њs.\nf   $f$
Њŀcwf   $f$
Њ݋侨~.uC;t.\pf   $f$
$
Êغf   $f$
Њ
i"%t8t9fص,i %t8t% صLif~f  f<vnf  fغf  f￤if   if;!  ifG!  ifq!  if!  if"  if"  if^$  if%  if>%  f  fغf  ff   $jUf  .f  f怿Jjf_   ff   f|  fffff|  ffff|  ffffff|  fffgff|  fffff f|  fffff   rff   gffgfff|  fffff@f|  fffgff|  fffff0f|  ffffff%   fgf.l  f   ffsff   gfff|  fffff f|  fffff   rff   gffgfff|  fffff`f|  fffgfgfgfgfgfgfgfgff|  fffff0f|  ffffff%   fgf.l  gfff|  fffffpf|  fffgf XV X     ff|  ffnf%fغf|  fffff3nnfp  fff%   tf   fnn tf   fnf`  f<  f3ff f@  ffLs  fȎgff   u	f   f~ffftf`  ff%   ffغf`  ff%   ff;uf`  fffff8 f%   ffff f@  ffLs  fȎgff   u	f   f~ffftf`  fff%  f*2ffغf`  ff%   ff;lf  f
 غf  ff  ff  fȺf  f	f  f3f  0 f%"	f`  f<  f3ff fLs  ff    tfL{  f   f    fHf3Ҽof   fHf3Ҽof   fHf3Ҽof    uf   fHozf   u
f   kf~fffSf`  ff%   ffغf`  ff%   ff;f`  fffff8f%   ffff fLs  ff    tfL{  f   f    fHf3Ҽp f   fHf3Ҽp f   fHf3Ҽpx f    uf   fHq] f   u
f   kf~fffSf`  fff%  f*2ffغf`  ff%   ff;	f|  fff5   fغf|  ffff   t]f    f2   qr ws < ur ws 3r ws 㹸f  q|f  f u	 f
   `"f  f3f   0	~f|  fffr ws 3ff?   fL{  sf3f    f fL|  s)gf&?  ffff uf   xfsfL}  s>f uf   fgf&;ukfffgf&? uWfffmHf~  s!f@   gfgf&;u+fffugf&;ufff(fH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @                                                          @                                                          @                                                          @                                                  @                                                          @                                                          @                                                          @                                                                                                                                           WW                                                UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU   
 
 
    
 
 
                                   ' ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ~戰䈽ֽհf'-f1=Ұf=fGZ԰fSf]Ͱfifs=2ff ffԽ<հff fˇf ׇհfqf԰f[fְfHf f"f @ f.f.~ f"  ؎ f%" 3؎ P_ -pqt]  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I                                                  s6 .d<tH$tt
䠢f  ffff  @ f  ffff  ff   ff  fffff  ffff  ffff   g(
g(33s
uuf,  g
g3f  f   ug.
f@   u f   uʀ f   ug.
Qfŀ   u f   u f   u
g.
Qg.
Qf.  g g8f3s0s
؋Bts
t	ffff  g. f3fȴ2 uf  f  g. 
f0  g(
g(#f1  g(
g(#f2  g(
g(3f3  g(
g(f4  g(
g(f5  g(
g(fX  g(
g(f\  f%
 'Ⱥf\  ff3ff%   ffff%   ffff%   ff tf    uf   3	f   ff   f
f3.߉f3.fff3f   t.ǉffʺfx  fff% fȺfx  ffff3f   u	f   f    u	f 0@f 0@~ wfwff|  fff%?fȺf|  ffff3ɱ u
 u2f@   tfŀ   tf   tf   t2f  g.f3ɱ u
 u2ff%   f
f  g.
f   g.
f  f% غf  f uK uK.f  f$
Ⱥf  f
Ձ 
f   tf3 u t=f
   f3.ffȺf  fff%fȺf  fff               06/23/05BDD    @ c07/07/05DATm