#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTA)  - Linux-Based"
BIOS_VERSION="F.09"
FILENAME="sp30719.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  tz22  z2 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  z22  yp2 Y  8DTD   BIN  0z22  22    8BAR   BIN  KG22  U2    8BDD   BIN  H22  cW2    8DTT   BIN  b022  2    8DTH   BIN  pk22  WW2    68DTA   BIN  6t22  nK2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZYY  @  
   _             
(      C   
  `  C            P  
          v  -  Q  t  c  Z                y  S  =        {"  u"                     ,
 ,
 ,
&  &  &  |&  Y&  )&  &   
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
B  A  A  ?  ?  ?  ?  j?  D  D  sD  B  vB  ,,
,
,
,
,
,
l,
N,
$,
,
,
,
,
,
,
d,
F,
(,
 
kO  (O  O  O  N   
\  \  \  \  u\  _  d`  `    G	,
,
,
,
  v                                                            3Ðj茏ː
  F  F~ F F^Z9 uvfv%}fvfv%~hH	h jKRP蟊Vtj
fvvP輋
hH	h jL`RPrVtj
fvvP菋
 Ð3f>\  tf6\  f>  tf6 
j ]胃  Vh jh jth jih  h j]h ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hl ǀF^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPfjbRP芄jRRPzjBRPjj2RPZj"RPJj	RP:j
RP*jRPjRP
j
RPj]NFF9F}-^v&&?-t^F&&?/uF jYZ=sjvtRP蜃j]@YtjwURP}jt]>V   hH	h hl bFHFuj fh  ! h(
h4豈f6Ffh   h(
h4tbz f6FXafF    .^	| ^&04^&4F~	vF  Fz 9F|F= t= ujRP谂j\BYXfh  j l\ ^ \ ujxMRPujl\i
>R  t5C  Xt( !  9  =  A  E  I jJj1fj   ujxRPj[t(`       ؎f&fjvRP豁j[>P  t>R  tZ  X  L  >Z t>Z u& & & >Z uuD>T  u	>L   >L   >Z u3T Ht	HtHt8j uwjJ-ulj?j.>Z u?T Ht
HtHtHtIjj AȐj3u+jRPˀjT HHtH
>T  t7>N  t0fLA  hLhLj#}
>X tjJRPr>J  tj \ZhD  F >D >P  t>R  tZ  X  L  >Z t>Z u& & & >Z uC$~ tfj fj ,F  t=HtkI-
 -!- - - 
tFf>  ~  H    6 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G|&Wpfj ?d     F >J  tE<KD B= M- K- '-M- 0- )fjF6>J  tp
j 6X^ÐU	^&H&JÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&ÐL"N
z hthLhLj=>X2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP襀
3Ðfv T  Vfh  P FPՀfLK  FTzhthLhLj}>X t3^ÐFPTwBFVhH	h FP@~RPhvhH	h fv$~RPhb vfvhb Hv ^Ð  F4F(
L"NFTFzhthLhLj0}M*ÐU~uhH	h  Ð~ fh  `hH	h hb YFHFu3Ðf@    
f@   ff9@sVfh   f6@fh  `f6\ Iu*u%f6Ffh  f6\ Z= uF&G
 tf6FX놐f6FWA~ uhH	h 3a     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP~
#fh   vfh`  j f6\ r
Bv  WVH	~" f~ thH	h FPRt~ FPu3^_hH	h hb WFHFtj ff-   fPf6Fv
f6FjFPu
f6Fx~ uF.~uF6d 8Fue 8Fuf 8Ftf6FVkFPh`Rf6FU ^_Ð~ fh  G.hH	h hb VFHF
f@    	@Bff9@sTf6Ffh  f6\ V= XF&G
 Kfh   f6@fh  `f6\ )t!f6F>Ufh  `b^_Ðfh   vfh`  j f6\ \U     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP${
FF> tjJj1j f6 Z{jhH	h(      RPz
6 h(
h4     RPz
     ء^ +\  &&W    f&        ؎f&       ؎&  E&  FF܌VF X   R   Z   fL
S hLhLj^q
>X u_>O@X RfLN  fP    FޣtFܣVhthLhLj%w>X t>MuR   hJNu~ tZ   Ft
F$p*Z Ð&  VFF܌VfLD VQCzThthLhLjv>X t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	L&LZhthLhLjMv>X tjifRPs  fh  ! h(
h4xj=RPUF  @ +FHuF F^	&4,x(&*(h(j*mVF 9F}j zĈf<t<uhH	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>X  u#jIzRPrjJjRPr3ø ,x(&(h(jUh~tuÐ  fh  u3fF    fFfff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "h(j
TjoRPSFF*;s6PjNRPSF*Pu,x(&
(뫐,x(&
(h(j
}TjzRP!qju,jCRPqjDRPp>J  t`hhb jRP-SÐ  fh  h`hqt"jKeRPpjLURP}pjyCRPkpfh  ujEF  h(j
SjRPRF~uJ~FF*;sPjRPbRj F*PNu,x(&
(띐t~ F b,x(&
(h(j
RF~sF F sh(j
RjQRPQ>J   FF*;sfh   Pfh  j f6\ fh   F*Pfh`  j f6\ F*Pj&RPjQj F*PVu,_(&
(\h`hb jRP)QjYRPjXRPhH	h4 	QÐ  fh h`hMt"jKARPinjL1RPYnjyRPGnfh  ujEF  h(j
kQjRPkPF~uJ~FF*;sPjRP>PjF*P*u,x(&
(띐it~ F b,x(&
(h(j
PF~sF F sh(j
Pj-RPO>J   FF*;sfh   Pfh  j f6\ qfh   F*Pfh`  j f6\ F*Pj&RPFOjF*P2u,_(&
(\h`hb j RPOjYqRPjXgRPhH	h4 NÐ  F >Z ut~ thH	h< hH	hH FP.hhH	h FPKFVu3vPfh  f6\ |K= s^&G
 tF  fvPJO>Z u~ t	hH	hT hH	h` FPghH	h FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6\ FPy0F~rhH	h hH	h< IFVtvPfh  f6\ QK= s^&G
 tF  fvH~ uj/RPLhH	h< j!RPLF*  F xu3E-t*t~ thH	h< FPej"hH	hH FPej#RPFPehH	h FPIFVtvPfh  f6\ H= s^&G
 tF  fvG~ tj$MRPK/F~  F oh(j
LF  h(j LFj$;F~,x(& (܊F*PjRPcKf6\ FP/FF~s#~ t~ u,w(&
(tFPFPj%RPK~ u~ tjjgRPJF  F f6\ FP).~uPhH	h hH	h< GFVu3vPfh  f6\  I= s^&G
 tF  fvdFFÐUf6\ FP.Ð  F u3F F~s7F*PjRP*Jf6\ FP<uhH	h2 JhH	h hH	hT FFVtvPfh   f6\ BH= s^&G
 tF  fvE,x(&
(
h(j
JF h(j wJFj N*;~,x(& (Ր,x(&
(h(j
+J~ ujRP%IhH	hT j!RP
IF*  F u3t~ thH	hT FPQbj"hH	h` FP<bj#0RPFP'bhH	h FP~EFVtvPfh   f6\ yE= s^&G
 tF  fvMD~  j$RPIH9EF ph(j
IF  h(j 	IFj$R;F~,x(& (܊F*Pj[RPGf6\ FP:FF~s#~ t~ u,w(&
(t~ tFPFPj%RPG~ u~ tjjRPaGF  F f6\ FP9u3À~uLhH	h hH	hT DFVtvPfh   f6\ rE= s^&G
 tF  fvBFÐUf6\ FP9ÐU  
2

 UvV>
Ð  >
vVF*^&F^&  >% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2F>F 	F  iÐFi  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRhH	hl ^Sab~uvvhH	hv fvaÃ~P|FlFFPvvhH	h fvaÐ  FPNQVRhH	hl fvavvvhH	h FPraFPNQVRhH	hl fvavvvhH	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;D}DF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FDPv~ 7
FDF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>Z uFP_!ÐFP>Z u0 ÐU>Z uFP+ÐFPU>Z uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh4FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh4vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh=htLth=hِ 1= t= ut Ӄ>X  t fj h
N3  F"1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 "Sh>h(*F*P̓uF"z j h>h( j̓]FUtKjh̓h(
hb j h@lfj hG=th>h(EtÐh(
h`h(
h~&u{Ðu&{ÐU~ u h(
hjhHh(
h`jh7F  F~ ujFÐF Df>   FXy j h
@h^fh  L΃uF  Fff   ffffN*+;=|;s7F*@N*1 XSh
@h^j F*P̓uF2uF~ u~ X1 F F~sF X1 F cFff   ffffN*+;t|;snjSF*PShSf6\ Tڃfh   F*Pfh`  j f6\ ڃF*@N*1 Xj h
@h^j F*P	̓h~ tfj h!F\  fh  ̃h(
hb !fh  ̃t"h(
h`h(
ht";fj hE/fj hb=uuh?ht!h
@h^tfj hrU~ u h(
hjhh(
h`jhF  F~ ujOFÐF Df>   Fy j hBhdfh ˃uF  Fff   ffffN*+;=|;s7F*@N*1 ShBhjF*PR˃uFuF~ u~ 1 F F~sF 1 F cFff   ffffN*+;t|;snjSF*PShSf6\ ׃fh   F*Pfh`  j f6\ ؃F*@N*1 j hBh#jF*Pyʃh~ tfj hF\  fh 5ʃh(
hb fh ʃt"h(
h`h(
h聻t"fj hEfj hb=uhlBht!hBhtdfj hÃ>J  tj htD D   1 ~ uj߃FÐF Dj Ճub j h EhtF F~s3a F*1 j h EhFPuFA j h Eh|he>Z utTtMttFj t:hlBhCfj hb=th EhtÐ  1 ~ ujރFÐF DF F~s-F*1 j h4FhFPuFA j h4Fhh
또>Z ut>t7j h@wfj h=th4FhtÐ  01 ~ uj݃FÐjӃuÐF D*b j h Gh6tF F~s3*h F*1 0j h Gh6FPuF0A j h Gh6h
c>Z utTtMtFjt:hlBhafj hb=th Gh6tÐUfvhf  |JF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
|NJOÐU*FP|PKJ*PKÐU*FP|PKF*PJPwKÐ  >x u7]  FVL;Vrw;Fv	x ÐFP
uh h Ux  >x u
FPh iÐUx  >x u
FPh IÐUFPh 9FPh -j>x th UFPh FPh FPh j|MÐ  >z tRFPh FPh FPh FPh j0 h l<uz  >z u&v*N"FF FF
FPvB|JÐ=tw$-t-| u)~  >~t% Ð~ -t-t t-0 t~ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U~FPgÐFPtHtÐ~	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  p h FF )fF~}j v`tFp  F~s#>p tFPh F  f+fF볐>p  F  `>p t(^&k^&?tp  FfF~|F~s>p tFPh ;f+fFҐ>p uKF~}Afh   j FV^& ^& h.p F 닐FPh j FV^&^&pÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h rfh   FrPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~urPh Zj FF  	& FP*ătFPh(
hփ~ thH	h
hH	h
FP3hH	h FPUFVu3vPfh0  FPLfv4FPh(
h`kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhlnfh\  hj 6lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6lhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	& FP貶tFPh(
haɃ~ thH	h
hH	h
FP&hH	h FP	FVu3fj hvPo(
fvfh  FP	fvFPh(
h`ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû~ |Ë~aË|aUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..^f^gef[UfS..^f^gef[UfS..^f^gfeff[UPfS..^f^Fgef[XUPfS..^f^Fgef[XUfPfS..^f^fFgfef[fX                           UfPS^tf3ff^  f.
_._ "  u  $" u [fX 0!<s3P˿(
6 + r ׁĞsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6
+3	O3X 66666נP.`ظ MaP.`ۚe  y>	uXP	 P(
 5! %J`!	)&6, 		3	sx		 	&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
8t 88z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï  <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  & U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV 
;t@t3_^] UWvt 3I >	u	@!_] SQ |QP,[|Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UW(PFPvv(PF(PWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuG(t4tLu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVxFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWv (t4t	LuVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.~wpsZuZuZu>wr>w>w>w>wJuss>w>wp>ws>w>wr>w>wpRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] yy4yhyyyyyUwVW3FFv&vF
t~ }F, <Xw$ FF.xV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uumsWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
~FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>z tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uwuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B(
&|=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WVX3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWV(vv&(PF(PW Pvv;u),x((&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3(
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	8t	F3] UFu		u { rFGFF3҃vvډWNu(t$> uS#5![j#%!us厌ʻ 	FV]U컧 .8tK
Iໜ	]PPR.`؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PU(
ء	F	F]XSQR(
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغy$%!3]UWVRQSP.`ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;u΁t΁^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    (
              4.63  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   H	                          68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) A  + , Z?  . / TD  Z [ D _ ` E c d F f g G '  (
 ^  (
  D10/17/2001  O                                                                           H	 H	 H	 H	 H	H	VH	H	H	H	(H	ZH	H	H	H	0H	LH	jH	H	H	H	
H	,H	LH	\H	rH	H	H	H	H	H	H	$H	LH	hH	rH	zH	H	H	H	H	H	H	H	H	6H	LH	TH	|H	H	H	H	H	H	H	H	H	H	H	H	H	$H	6H	JH	^H	tH	H	H	H	H	H	"H	BH	fH	H	H	H		H	*	H	:	H	L	H	T	H	b	H		H		H		H		H		H	
H	"
H	F
H	L
H	f
H	~
H	
H	H	
H	
H	H	H	 H	JH	LH	jH	H	H	H	H	H	&H	2H	8H	ZH	H	H	H	
H	
H	2
H	h
H	
H	
H	
H	                                  E    F    B j V(
      C    D    B j t(
      G    H    B j (
      K    L    B j (
      O    P j (
      N    M l (
      I    J    P j (
      -     1    + m (
      T     Q l :(
      *    1    ( m R(
      R    S     U   
V   
Q k p(
      X    Y    W j (
      0     1    . m (
      ]    \ k (
      a     1    _ m (
      e     1    c m (
      h     1    f m *(
      o    p    q    r     s     n j H(
               Ta                           _C_FILE_INFO=                                                         (
               
	
\ \                                  1(
  1(
                                                                                                                                                                                                                                                                                                                                                                                                                                              (
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          6b6b6b6b6b6b6b               (((((                  H                                                                                                                                        
                                                     I`I`I`                  i(
(
(
(
(
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                        ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$ p   `      POST  f   f.V .X <  
 f.d ` j  I     '            POST3 } * F  
Z ({ H 	 t
 ) P| )
 i| } ) ۑ  Z ) e Ƶ 03 3 f3 3   m{  t w v  `! P" ,# Ѐ$ ,% & Q{' O( ) |*	+ l, y- 9. 8/ 7Z0 11 2 Ћ3 .4 5 P6 N7  8 Wu9 3,: Ч; 4,< = ,> v? ,0@ 5,A gZB nZC R,D _{E F uG H QI 2)J YK |L )M wN  4_ )P Q pR ,S T g,U V jW X *Y@Z u[ Z\ 	] $H^ |_ ` Ya" f" @      f{  3 q 3    U QVW.D7 PX' hX@s .X=X@u
_^rYߜPPSظ hc [X <t
PW 7jf&E1_X  fPfSfQfRAfGenu fnteluxfineIuofP%=  rYfa2f   uI! UhiBt/fk00tf  
 p0fZfYf[f
  PRWfQ
u5p (t'@=Rf0@
u߿ h8ufY_ZXSQW< s۱1
2
 h>_Y[ABCDEx} U"RVWfFf^fNfVЎ.< t ~.FuN._^LQ	
H_@
		! &
%s
> h3h4Pp0 0t  Ãu
.(u	u/RPVF	` u tR	k@.)tމ^~u 8	_t/ t^T6
5
^XfQW~
~,  _fPb	$S 9#0;r#Lt<
tw
u!ο 	/_^p	65WfVu*p#)6S
F f[tҋ3ff^ff[f`K.fa= :ApCfVWU@ t  f7hSs.%3 tkfAߋh6 ߋPy'Q20O7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^Nf`Sfff@=_ hR3>+f;r[5@ Wp
2h_
 WX
_: r
gN1
gw?r @99 \AVWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_QU/tg^H2N@?]" h fΑR   4]hQRWV^NV vq6Q3qI4GYGʫΕI^_Z!3Q'M0 pC8 YfWV3ff"1
mIfPS. ,.(F(  f(0p^
#N~u!h
s.  GFuQVsuR?
ۀO2ۊ~f@xk:P`?tWuf@ f.(|ftf!f.@# <
uF8Fuf_ts^ÑGVR.>(s$0q	.k6(.(z

ZF(Pnw2
F0(FPPv2PqN~ t4vf2&fz10辽
FNNI.(HfQvPu@f(.;(s0e ~ ˁ ;u
t`g#t@Ѵ 8^rf(  _^ZY eWQ3.>(2 .ǅ .ƅ" ` P@hQU.(w `s$' ip3.(lh;?z o.N /p\wFk@"~ 
N~f.?$=6@.(2ɠf0/tl)u4.B$f<t؅fG  `b$< F. 
1wq3V@~r F F;F F2u~w
`M3~f1 kЖ lt
fN}qu
ffsfF^PB4)FQ*
*q4rF$<u&jFF .# ~ă$w/p` *.p< O<uIO8q^`V@;(@..(;(^V0&0
9t@-2x@2
E/^S 65^35#>'uBX:NЎu=P:
t3S9)&u=8N0;_^WV\SVR`Ffn *J[*!ffAyRfߋfP%߀`2fpʰKf;w
2|.fPRfPt#f3~!fD`XfffNL$ss4
tP7}u+q%
u	~AfFaJfୀf^Z6Waf F݉^~K"8ueffFՋN_MQtcV@hvbm!F;pI{*3ϋ~+c:tsRVRfQF;F8u p? kv@kF:`pb$$@K*@3frD` w;=< ur,.;D$<uπ r0	 @BvFfYZt4}VWv Ђfq|~|URd
t"tO_t ǔ@DvP }PkQ9SV ޾ R3; t	 r^00k@tRːW#Aq[%S ?^Y@j(*pt@;v7h!1k~@ۀst 1;FtFk^% Bk^cՊ Ra 3  V3k`[
*䊁"R;FuR*3]ft7]-k	)	# a
@S
+FHu
4uGrvFvVBs0;~HVW΂tS03ދ[^NuVp _3ҋ0_&Y61-xDr<}lF(kHpBHP)뷋A(g7oZ Q&0V_  ~1|\0PN~ tKv0YFA.Qz$ x
fpO3g~ FfN@P@ 
0K SQh(	 \P,Q23If.` tf.&!. .8(tьL$QVW
fvUF%p"`F^^F  FψF
fgFF ^Veb".^`L`Ч!ɱ ``Nf~ tFt'f`e 9Fv@f0
FfHf;Fy^Qr@րi`bbzbfC<4RVFF8F^ pVwF0 NU$ &(,ymtN!!fsШtE rts@CA9FvPG 3r%if.(NͿ  .`N0ƺ0 
t
F%  .p t>fg_~ t(i'i_f^z eȞu
 v@aQI8t%_  tu Qw  vfIft'fAff#a fpЊ=rSf.6 G                                                                                                             /                                                                                                                                        @       o  PQRa&hic $`Ȱ߲ hrZYXSQWa$a$a  h= h4>B>5_Y[2揺 TCA6  @A Q C@@ @;uYð!$p ~h)Ē
f`   hf4gf&`   fa+.q-h[
 

߀hSfPfW@&'_fX`i
k/h	.t$/h{St*   &  p>\ʌ@ ؀ qK&}uu h$k2!3d 
  % VWzR-5&$@#h<ff
AÀtf%1fhsu h:*,Ⱥ: @p 3ȰS, @uSh!.h3 s!dúvø f й hS]O`-aP hr40= h" t
 aPQ# @ PQ= `t
3f3 @fYX _7d`0.d  U߃P9  TF  ؿ
Et&؁P9 uM9NwN#uӃ~ t"F= wt%   +w;Xh.S6`.q-   !	  3 a `hƹUBFt*u C5uq7tPRfZX=(~f.~ A<f` f   ƀ2@O~1SfQfRf0B  fS%=uf?a2 ffZfYf[?SQRfWf_ZP<f@`fVp) f  g&H @ fq$<s
hEXˑ  %8PA	<@$f  CFڰPGjE sFfMf>@׹
 F K'hHR ;s(Ǻ$ fޭ f^fW߀0$w
 $
ذve<)$b w'`$L v)f_AhDFpAeGff`Xc =s0``2Jr-
t@^!s! Aqfvr蜒s  Qex
QLKifaa	't5<t1mf @p1Ia@ {Æ B<  C< U$ # Q R ST U VWX YZ	7VW3~HkEDE
` SgffﻵA] wуtR.֒plRee3_^.!r ֘   > o A  ~T ?h M e M A@ 9 }Y .   n SA aYǀᡗO!` (
fQ jp+k{!k À!W2 P f,3!n63f62M  3s pҊЬ 62>x~a\.h4SPS $<t4r [! ЍYӋoh 43 `s f`4 S  y6vh#%h9w   D 3y "r< tyFQ-2"!|-k L-`,rb,Q-ސ r%@s-l,&5&D&ENo-jAa
phQ 0߿-p|te0-V~^ 
8
3
~3
-^x
-v  pA.y&@ U$=u& v.f= =u H&.&.&.9
, fgh  0 pqr  <ABCDE xyz{|}   )[V S#
f k6 r&g.&i.6 ro
&    6x" .CfX^Cf߸  pf5fx&V3
Ê^P0(.'t%.FuN.PP+- _XpUSW! Q,fv߿ h  R&~22!IN܀3d	^
u
t_NA&>`,_[]f^_ PVR&=;u&&~4u&^P
P<q +&~& 1E&DpSVߠ h@b^[_þ8`[W0?  <_\PF10=ROM Based Setup  En?tering P8 `. u  S8 lK~t.߀P89 Suа)!`- W  y8p 1A	AP8 1Qu8qfrJp &P8tFò  t
.>	tλ..P(*t h*cP?Xh(;cWF12=Networkrvice BootWake On LANAttemptto %  !ʠht8 09 r	 0A9uo 91I!	t ˽tvsR QP.9$<0+( 9mBUB"9! ds@C	%24ؾK<^s Dܡ% VRynKkNF K3؁qK?	uCFG~gN0tGhջaKpv=rhZ^P*Notebook hard drive MultiBay"/Dock!:b<#}b (top)bottom)<leftf	Floppk  USBCD-!F HDis|/SuperNIC*
!1$23                         =oP  	 
@>8P 
V t @-r { pqlectZ;Deb]  ͹U8 and _mo@=the highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   v??(?$P ?'#@;S A;Zip.F`u hC d0ô0.#@ӌ!tӎH@< A VK3qK؊' tA<v<st1h?& 2آ؍;2ￄ=Q#YAr	 > P @.d?
*}f? @f?+jjj(Pj8  %@ `d?(? z  *  9@a R 2җ
   t03h?2Ɋ F8tFޣhK $ Zbqqp URVQo.,.L.T^Y^Z]S,.f?*[ݡQSVW/ s&QC@.<.-00?00.Y__^[YQr(? u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰw`2΂ Xʱ@
d?(?(?r
;wo2pOd?Jơ}gFYô.*f?<u2K0h> h~h47d hb<u`B J qWo rf.>D5 hfgf&G, @ f   PG0f@G,`u
{hEtG,f",f_ffP QW2_Yf= TKSt0fXbo    ? o  J  b\h5p.|
W
g&Fg&Fg&F"t7g&oF0a 1 2H޾D׎Ǎ~ذ:{ rsD	 k  QRVDTQF r&e^ZYDffL (]^LрY`VUfQWo
ؐx
K&@
C'm C$C$0Grx  q## r]"0tsrg or70K:k;WQT r}Q GC""Y_r
E@t]^f[XQ!$&C"u#%$u̖!#,9ABM  f.FPS [XAu.6Ff.FIDNU.FSfV#O #^3%%Ýf@)3u
u ]rt!q!} "оW3 han [ ++hsh3%5ycf_]}`= vH wOAH aP hi2$@<@X7O4  PR ZX@ P.>H t.H.H@aHSQRWh@r_Z>P TC r99 r/ 쨿u {t t@XR1$tutZ 2 WW$ f3hScXRISWQR Zu[Ppq4B XZY_U M[ѿ< @3ɹ2 uhXdo#W)¼ P% = @uXu%)4g&@LhH0VQfPvf  g&?t9g@YR%fi<u @^  f%?f^#   f{@"f<tf Q	 f !pfa 1^AaZY^V$fVL/
/ZGP@t


 
"
f^ff? wD Pf+% {
!
hfi۾L <D	"oH3P4r H5 0P@p 2 P`     )L@`@"rQ  	P  	`}itp    [ & Atf & /&.@ p p 3fU$'Br"rst$ uf*kQM/Op c> / tuc ~rh^
&	/p=C<thQp}/  G11?}(4 Q < t&1/GUQf&Zh
y3f30 2ɴ*f& / uf
ffKP/&/&/fC0/RQā̀/p/15RfVWf D3ffCf[fKfS܃fF0r0а K I+rߋ/._;Zf5SQVWϾ u3螯_^ 	!BKsV 
R3
t<^f~
w/vN0fkd`afft@`[^ɳ{VQWfv hG-F&p0F&rp &t &vP&x&z0&{|&~&&0^y Uȡf  rX)Tu'P h$k" hhgޢaX`aWatif
]PRqQ  t%  sS fQ ffff>Qfh pJg&; PSu70W)f)PfY~/u! /u/u/u	g&t(tx3	[rwnf!ǂ0ـ  ;`o	1/uP~/t r!	 u;Q5-                                                               10Uf`f.|QQ?u hNrW2rRrMQtf0f 0R| Wb t#Cr"t p ; (PJR  ZR Ff]L@V0r*6^  R ZrG	Ku ezdB rC\A 3?Xy8E tyEG 	UgSm r	S>Q	tlkӷQkpbƥc࿐W rt r
  GC_SRA0Zt$ؤ$]WPݰ  _W}  spO  a!`P
߰@S P  	ð D v Sذ8 3 e R	Ǥ!
R3'
//g&QQWjuptPX_Yù
 d hۑ8Cx1s y
2P -C<u4-uĀ qRRuaR12e< u3Z#ȴ$ t	J o U
	a!"Df@`Kw^hXhaßhr$T/hr 'Jh'juva { r PQW 0> 3_YXI9h^c=F >E$hSs	? Dð   ! $!f` T| hi"@u' t` hS>* h" tff%f
 ffa0vP1[F X\`ؾL &>aK&DEP&D >Ku de ij@ tqK}
 -Ȁ}	 >mK 33SPd[tS[@? 2[sDy3 t^h#ʊYs
Jh{O#QaàhLǈD
ϰ<DuL
p
E$<u D
@Q3Csd
rSi&pS]@` uL
 6 6UK u  (X6O &u{hT
	\

u.0   ND&}?u
 t&E_b t

&E^D
&Efww>Bt6j t.&t	&  t"& xu	\	PS   =? 6P'>nK_3& ?! W>oK	_[XB
t+# P xt  t  w\DPV!$!"桾tKh10&,@ &  ^X  hC!r!L	vTt
v`WU$/! $<v@a`n3  v
p
u$"<uP>ȷX\PRt P:1߀thE]!&ă=0ZXx` 22PEǿK&PCt5ǁK=qKtOu570: u	At!?s96 u5 .\s
t!\&q s   a
׃/콿_3 bs{&=  V߹ P;Lu 0< ^]  3f4G -Lf_  }0 U!    L&egWʃO&MuO OqfGtM!t$Ot, t"OGr ǾJM0oOg&Lį/` 2%
<t29o21_kרt O<uLDHD =_7_D D	 d
z=X1:B]tSpprG&}	r??23P3t`h߇a&ES$`	&M&]AH`.'	@[%o# r`S UՠRb0ZW&= uAF:%I)
hJ
 m_XP
}pt   U!w#w !#`ފ|nnhS0 cc.-.׊MSN=tI! //(rJmc.58v@Mu% @BSB 0h=¥h4aW!$
"1D h3
hCYp@[X_Ë
`PS@e![X SϲH<vLR
 Z,<u(Rfүffġf,ZJ vGu

 jS1 6у[Qa$ ;@aÁf3fh!<`b8 {	4`֎ސ0hu73 F
t):u%9dD	& h.SK & 	 h3ނK3G_a!3 
3 @  qK SٹuTu " / [J rGQw> r?;fQ  w.<t*tR&' t&A+  ˹'z
z_'+Q}!@s& 0RµV|Z`|tpk hв YQ@@?zP^[r4fHq(u% = tR0Y *Q
@_HS3qK+6 
HHǋE&NAE 1, @r \> \hpӼxxf1  ,V{A @p$P<PtR>eZDAAO  ZGpZ^a/\WV 0  PhX@ 0!2)
C@)2]ƀư?!C@u?r?@Dtϊ5. ׊u,u1 
@a

+&C323&@t  %
t&
0  W5  " Z  ( ~
u: 7/b!	"	? A%w ^sPRWAC&wA &]&U 
t ˀAi{] _ZXr#3һ -wv2C.u#o/5$N#h΃&_ '^ Y     Հ>u  '3W~ c[ 0_TkmYf#`Zf3fcu 3? Q>J`[C::!uBE&8Uu8p]
R +B&U
ZK!ؾTkZ6fYB)%qr hkʊ ;/1	Q(t0=
  5Ãh^~p8.
<to0Z`ێûߋPV#
@F^fǠ  XJE_D
yC I Xo-q<qUf``؎ Fwm. ڎfafSfQf.mf fff#fYf[2VftGf   ~~mIg@f;t&f |	F $f^`2ۂۈfaf`3pfaPP3_X.>m+ . P	TACO Fr  
!	& .ǟ|m ws<F	~m fFf.m  mF.mf.>m;E.m@꾲  tmttYpmtNp  D@SIVfB.f$;VrT%W tB!Z\ܐ	i %Qf2$fP'fffgf"ޱ'r. vp |m%f@c .ffHpfXf>df3ۃ!u+`s?I
s*"/S"Vf+f;wffߋf3w3RREmo4^Jq4'r44$.71p6ɐp08333Ҹ  QW>% _F
3}5u'JE#a0߃ t 1M10 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^F uߐiQ`  &t Y&  
 < tr&\]p &\U  
&jN!d qK
SۋR[u 	F@& $F^[_bF FxY2p߀TV'}PVWϋذо' K! _^Y[XWfQSg vZfat
  [fY_` t =$PpnPu2MtaË6!s } tp( ` j &&E`?SRUQj@6^]Z V` jsČD^XP
~*F
 ' t# b Q`ylF @ǯFxq d3duhXKu`<Uuùd `hc4d &; Xtû   h:ͻ& h oPhE{'`X!$!   °rs}ୣ O
ehH   tt 4  hJc` tKu& &  
 ` h,s@<t<uuТ 
0u?z1*`P	h# Xh; % P 'D[%Öys%aPX'w$# ) )t`($} f.`G  cpk3 EDk@77 À   ; Z x     0N@`^~#bhV1fF3.w% r 
\0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہw.~r@V» ␂û< f ff @ffRfP'f!N
 ffFf3fvZfFswfBf〶fЩ1 r9\pf3ɰp?ǿkfAP  fafPVa3vrF3X

S,0<	v	,$y.[W D`

Lb f s  f 
T?
T p s 	 
Sfw_fp ЎfvPUYP, P}:Fp
uf^fNfV_Sf^pPRp*fVA6*F1@20hC@ Ϣ
 ff  fffffXChq p  `90{ P9󤿾|" 6 a)P*h$kcP, %ofPRh廒K2R ĺZP  (Q * 4ff:aD0  f2MMShm   hCɀh>XSZ?;PSsS覮@apq$ q!̰Āu!A tܠðvntt<1w(o<vvP7jEh3_ P&
0
3q 33ҊtW/g.&;u;@.\onut)@)hPmt׀a`2G@t03@ @u  a[
u93Q2,;8#fN 

P-j1rX?03Qr |X@Yް4SQo2ہP5'a&& &0hYC h}زu򿣶ɰ hj
t[ Ȱ t
嘪ŀv#t̰5,5-PX_v8v&> ߀㟸`t`{_P3 u? $h<J
#RV袸 Ps} uu22hSgu]5uXP&
wL2 }Q޻ hNu= Dt= tYԀ'
YY.^Ze[1HP #@]U  Pf^ ]  `rr	 V$(afOLPHp      @6,P0;V(e
u^V- ^"(P*^  2oMqSP( 22 pX[úB  $@7R  Z`7              |zDKtP( % $ 0rxfL+  ك%rSr$rF!f+Df+\ r*Jr3w r@ . ߁hgfa2  PR30 Z@AR `&Fd??uh*P&Xh( r.>.pu 	AїQR.h f3f%  f`YURQSWF^
D= F\ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF t _若~u빠% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
5ﴀ0:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              $?`ރ6.u;v` Ql0 >h *Y`"QwLQ`f&YCC`Kq (   P3_YaPSRP3@mn??[`H@4$&%<GP 	 oپM <BMtf3%ĲP2W X` Fry
JRU3 fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	tŀ   
 f@3{t# %t5ubfDqa $<@tS<tO`NBH$u>f=Pۊf@+rCtq Bt#Bt	ݱ]P0f
aff60rZ r 1Y`W3P[tt_rހh`D trr	P}RW Z
xx ؎ P.BB <t BB2J &ݾ(   8u!@屋`23Ұ
ShSSt0`́ y aut0i at]U U[aSR  4hk
 hSlZ[Õ`-1PԻ  h8	 h
 "B𑀵PaԀa$8uXRP<u6ZyQrtwvYu0ѹ }R0ߺwZhEU?2<U|  hY2q u
3Ҹ EFv)v upQstT 9 
7( ܣPf.p UfQfRfUfVf@Ch: rsNrG 2f. ff_7f^fq8Yf.>pfHgffgf_ uUYKU q\ u, P3	fgf CpfIfAgagf.#f9kukpfY'40    /tp ];}6h h7 萩Q h!,  h߳"   OV3%@tj u;{F ;
V3"/fUi &g3  f% '"O #WFfF^fañcV p @Z  
^Acq[3[<   k DTD_w R  o 0 oȳh  1   l ( Pb @0 W HL P`A T W Xb, `
`! p@pؾ x o A0
|\D`QWhE3 3_p 0 PQ= `tq1 @0YX 05SPp
&ߣ p  ff& X[@aa"&    i?r  v|"}@Q  [J傸O fQ9QMh2 ./ Ӗ 脠 <t 퐎l~ tq.ri."D.|u.:DtSI ^ wD:r5+s&v;
uAm
?c1PQRfWT}3^`
f@XÑ2a`2	  "	f 2f@0f@R %  3f3OfPaX Ah lUv  fb #&f fa dD 	h}W"ϻ (;sQSf  r`
 t
2>fƃ	40q!a
 Q[ff{Y+vf[Wf+_f t%ȡH+f@`h0Qpg-m f@kf`0z q_L2_&UÃ uZ=PrUf%~е uCf*f=`  t0  t( f{{f
1"0"}fph2%/$_!"
 \\-f g&%ٻf2@t
 <t+p g1~f&f о  , Xuup Lr}fLBt<rfa&'?rGfϰQÉ_F?<qP
 Ц 
"a	Ub	~p@@R2~BuE1ɒcf_fF &Ff޾{ t@sf @{f;~t	un~qNїV&##`WfVfPXfXcr<w؀.,0ճа_Ѱcf@&ːtg&~TfVR3g&Pf0 `&fnu=tsaNu(g&fVf{fA>"Ȁ.f+E)^f^uS2u  w & PP0Xt'vt
t]@0r % r/o hj>u hͶrst-3&>rqr~RPzsRܑuthX$uul	r` 	 +Zjj b6uPS`` FF ph rou
@ Ѕ&f  >t !$!f$< uRC  
N<W2<ăƁ_	䡿"3A'yr@h[u ĿTYP=t 
u2Ɋ،в3`t<u
E< tȵE$<u&w $tuRVˣL  N L ǻNڰu û` t W P[2u
@j ?jY!(!!2(<!1ʰe$ h5u$0t$ϝ~.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|h=_DuQ&~% t PXӹ
 D.:t
 ._
vXP%8Xr6%țf4>J3;La    PJNL p      QKOMp {@Kt  Jt P(.ߊDGH oh2h  hvQ߂ h҅ hE Б?E^  ` f  Cp m& OE 
v %&Mt&:
&;r"`p$t1^TKub 
HM` `(q p" sr#	cdp&3a wC 	H ]r5r`2gpjh!/vZaVRQShY4Thkأ4J.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Ph:sX<?tFhQUujjjj P8 &h{(;X\ hw$vbwt = ;t= Dt
hEsp[w@WVS$`́$
5[? @n< u"*׿OطhNt`-->J=Ot1 0_ tyr Wrh  S^x1  0 hL PͲ5[ ?  :N2?Aq%  	
   VFPgbǋVW 2_2µzt"@uG2 
u
2 
 o2E2&&ߋ&EA &e?
td&E&&E E &E<r&}	r@ VW^2۠^2*à
&}vPu߶h^VRPRQ3f 
%*t,AYZXRPSQY[XZh?tuO	pp }Є> qQ 5~rXYj-: t
z*֮hERL&&  t8t' u a,& nWq00r6$^$ rZ& && ;`Z@ `dde`P`  X3U @>
ڹ  .笋PB B把8uG` A ; 5䋀/䉮)@#;BS 76VŜPX
 a@WA@ B C W   ÜFtV$𻰂%Ȱ%<;weċ X؊<wM3ɆQ#"XR߹<  YыƊȊĴ3ЇуsE pY8@C0	 FWYuF5<uz`s0Df&	2
pu8f߻hNePӀk{ 'BԬ@. ,".  榀&k ~!< uf& b$
r wAu%1uh3Ӳ$ݡs}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh^KfKff
f'h*?f3f3ɹ f /f0m f+f3 ! Ku*آ'3ہEsV4C\` a^_^fZfYf[}fv3hI 5R{`2K> 揀L0s< |&	3ytvou4PPs 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .0\3۸ 2ҹ%&@GaaÍ6<hVWa<-z_^pk` hΫ$h  uP$<X5&sf @  t<   4 |r	.ѩ$<u
k f3hh.Щ 
d]XiJh=  tdbw_0s.>ЩNfm thtC	
A!U2 u@? l > ]c 3Fd@ e f Fc~ce@4~e uQ@@9 h*|`5
P	YychBFe:Ffu1r,
 h
 _Fdt;   	:  <g ht5Lh6h`!af`7UPHh@'u;E#f% PCAXt# N h&N r k f ̾   Fo^P XSĻ  y ,  o   hbS-[t(t@_t,&j  j,>" ' À tht*dúߋG."**=D/.qpEq+Ë؀TF/VU2NfQa dYF :uEQ]Àg33t
t
u
1t#u
tN02t"FF0u3! :5tFFdz ulm29p`F: uYeb +Πu;6F1 epp0Fwff`Fup   j(j	R	aURXhcc2  pɺ f1 hr9BZ]coRfB`pr@!  tg˿RQ Q;YsY2{w$
 _!u$ d%|Zf`  WWeIȪ.&ԩ]fԩ  pC`hB%
 C ƀu0u.>ҩ 1fa
ZURtLށUHh$k<:Yn PYp to(tq ;C Zi@"gހ squ4VfRfsQhÊ+%0;p^f[B]ԩ8" a[Ybh$r s 6Sj@ 2P s? rG{Z5'/UnAW`.өuQqK$<u:ߺ0pNr"&  t  ttҩ> tAt $puPq9T(
ː

 ⧾qK`XSQ 3u,S?蛰[rE	ˡ-ͿY[C& <ff<`00xx00`֫Qɬ{||	>>.r tr~ (ЃrLZCX̀'q@VG :]zQ<Q7WO &TZs6C  E 7ц߆ԆrB vzuN! D $_u 0/)0/Wc#-&A 8q2 F *7f&/p`W aU쿃fV3vCDPDQƇD 7p4f^]&Â߰QMZ"%  烪wPduX$epI:eXa@ `` /////- "  @f%wpк FACSPJ DBGP4BHP  0944 A!  8 ? APICZOK	ma	
@  		`
  MCFG<	P	     :@(@
 2!~ RSDT(  	f`hcj4hwsif  fhpfp  gfFgf  FPTR ff`Wg߈Fpf. p^$f3..f.fgfN0~$f+@hCڦ~3ffgf&f.>Pf(.	t22@_~( N g&F	f P  rgfffff+f+.{
ۑM.> f
$$X#D PXff-qAFV3g&fFgY[pff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt"@H Qr< uBOаNRUfQъ̓2 tPxprAr} v; tg&P)XfY8]МVfWfV* f& fP&]ؐ@(#f"fP)fȀ$ 4 
Ȱ 
ff	Oh⓾p (fq t { hvf~fPW EfX3 wdZ$v~c g qr+&
h*3=a+0Q;?g&h&_g  PSV	  4Yt >Hu	Ce? uDb& @ u  ǟD` ^PRW D h=o h>_ZQPSWtSfP3h f&L 4!f6!PB!`#Lw fX@`9!h&4" 03fpep&?  @ 6Lu    DOGLf3M{ pG   U!   L>L&geE E puMPMLGfEtXAt$Ot3 t)O$fM
rþQpmMe&LaxtCLU  r. ]h~2.ԩ<kGo^   køPݳ kWp_vf
Ph#6k0kf$ttӿ& tPE'뭿 5(P)io_ԜVΎ?EE^ 3f`FF  h;?w }u}r hSU  $g(,0w4'8  46Ã9FtF?fNA9F> h4:ɀu g(fa`
Ew13ɊMh$ӯt

hRp;r#uac5WF ^SCf fN^Nf.91u  1tc rfQPH_urf;^uf;Nt;ft) p 
tF~U_ս MfOV t;6(.<t1!QU)h:,,5  ^_U00 u,h..D+hXك p1_fqtA"   u
3   t}'0gf GhECG$L<LDCOMPAQ PC Card Smart ReaderGEMPLUS GPR400PSCR C!LB REFLEX 20!241 PCMCIA&Reflex v.2$cr$HP
  ߮a@!g&O@ yG3d `P ߳ rLfK snr>G	_ .D
A O@.d.D4f_ PQWX¹  
G.g&:uG Y.5 _YXQ8t *F 
⡤fW
"
@
@Bg"
*
3%Qf_V`bSh;0Gu#{  e~uu .ѩu = Ў~ 1rp&tj  t_& rT  r&= us0=6>
r/6r4.ѩV@< t ^}Jv 
w x y   hr9Sh(sz %ZMh6aGsia
qTrPqtI	f| b
u 
!tQ&y:s{	GYV
} ,`؍vfD   ,AfLs-<t(<#@0{6~ h:	L^PRU32t
t
u
5# t u9<0r<9w/tM>ư7SQ Y[t>"$,0>*SQLiE;f 	tu]ZXf`3Ҡ&&h#G֎fv*`%hÝgf9t0Xa` 2   0 tGhbq egf@ Vff3}f"gf. F f0ȱރf!
[!޾S3۹: 8tCRP #ܨtο r1h]f uf@q  00i{? 0    0     q'  ' }D 
 Yo/ bbIk`os@GY kɼ1PS_.kxVW ȌǍ~Qr&} uBr	: v_^d>r5r!r\E@&=u	~# #Hr&E$7u*5mʀʯ1¯Yӆa
3r&a)rI DTtr&e`4o5*ɈD
T3
%4S1r#@itct  t$BffLm  	] 	VQ
R>Q3q
]
Æˡ˼1i+W!z P:r8u`_QY_ þL[ r&UwþNWL螸`
Pw4$X` $2߶L nB0<tH`8u6
uBp & DBlTt
֐aP 3 r/) r%BϰB!J@ 
; 05 aù<t

B J 2@u8` BI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D?@u-&a$vQ> Yr	2Qd'YB@Aq Bor蹐B^	 f7pb3}S @ P`.ңPA\SX 03  _YPSWQ3 SVt
KVt2Yy_Q f`j hb  H`S7jk hÎf% ff= @u [jh nc Sjjjj P8 g\ hÃ[cuq?j&Rv^$bwtQ= ;tbu= <t/E9 hZtбjfaÐ  ?   tH{!uu):p0< u}{up@ z`3pr! grπ DƆ    r% Z ׃-Z1p$Wp_ǀ uu' 3a re+ tg	%  .ѩ=f,f tp/Y[|zrs3h*ƴ Y Sڻ> Mڻe ųF  ~f i `] tIe7r=? ً~ t@Կ@t0(5@ MF t w0ɓ3N !F ~ tٳ	u?e0ﰦSZAt9A`j f` Wf3Q fY@ IxL"
 /2uJp2:!&= t: ~%J r ԩl0VQ&oUq
MsY^{D^
eO>f"A	
plq
&:!& :X.ۋ IhBB 
D腎@P (3 x?  gA-sC"ufps	1u[	q	1D!IFt$a3; 2 + fB \	(Nf@2B?t1Q r$!$$
7R< !'~Zt'
QVJPf^DUYwR.߀&ԩ++t'H"`XttC.a:``s; 6s?bsd_p_pkod6moooU#eooao
fo4bcםa  AUO
 B141XG08 V.1
G09 V3 
BOE HYDISHT14X1B-120

QUANTAPLAYQDL205SAMSUNGLTNB-L02
TM|P1EA0VOAP4@3O@M4A.FL07213+              Ȏ6r[>te  >Y w 63Ҁ`37BߋA 08u!!u
( ?H 8u 5	3ҋʸh$klPW
 
_t_   @ك
_X7 
  H    SETU ˸ @؎&м  x r' hW@ P& u_SV  GG0G hc    Gu Fu t3  hC) 
h'jBt & ^[SO
&h!i" <[U샿VWƿF F@    ԑ [ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @	<qt	dR>t <tjjjj3P8 '.wj5g$<t.<@t$t = ;t= DP hEJ 揿  77FF~ t#^FLr
F FQ  ~ wt: ] ?f
 h;\2%PFAx~ t
F`_^Q
h8ss.&udu   hb,$?wط h*"h| #hE*f_01FhB%..  @  Y(`p3WVe1E0E.WV .^_UƮP)UIQS6(6*`e1E0eEE.U s@ m2a h4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	 +QVW?u% p ux 4  | = <t m;@C
 )(_^YqRWQ` Ê uUCrr3ɺ ڑ܋%ZAB rN _Zb1SAWIpIyI
WROujvzKMJ; DE<@ ;<<n!<3aRu BMUEM0Nt
Mm[VfPfSfQmPnf3f3nPn<nXfffDDG(	Dh fYf[fsX^@t#IgO GxnQRpA3wۊ9 r Cҋ97wB`s@zfDf3fË\` 	
C  T U S V 	#	7	K	Y	`hvh  h	 h#	 h7	 hK	 hY	 avv.L.< t)F.6%3.PF.߭h\[+V..^̋] zDF. P .h(_Xh:؃4R  16W  0"Xa Y Z #[  
m\a a _BA]a f g'^a bN ` `hcij!k qp10G pppQWĀ>tk		 u	k	.s	_7   O 4a9Rһ -w C./E2P+m?n8o7@W3۸  _f^߸^6_>QRrkPS[Xh(ȁ`fЍYӋwh
3     p     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	t ;	U   09/10z@ 04/27/05 kLit)e{{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdPx>0@Z˨"2""Pf"x xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`ר@pcŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5FMGGuu!
kүx00PMl}Dxe``
$`$p

xb:
Oxx txDESxxxxfD@/10y}}r k ;K}d`xGBF8&x}DQ00xtxtyuup
*}iQb}ps ~aU}wc+½*").xjD00q x^Dx_T_xc{D 
T e p# ) ,}1_U
-&0=!I_	P1Tx"p2xp3T0//}@!T^ ^ǀ$ u!`	{T`#8 )m$04`hb	р{P	;G	¯"+u+$?4?iq}T+}'Ư+p (++Ô@]B#,+G
H
0%1[vP7",`]@0/}@jW.@ /1@'"  "+7x0&x+7x_`t 7"6}

P} }	!	  @A
xPxt"xd}<߅}?!" * /}AZ#/00x )xh`xiw  p 0S+;.TB+x+¯0))0b 9P4.+10Bg+`xN	+ xTx !
+:DTBKPFp y+YP>

pB [Tdp+$!$OP+-`z 9
sQ` ðÔ2@VD0¯xx7x8r x008`6%06 @T߀G`	p4UFm9A@#ZIZ_150ϙ)4E"@W@W# KWQx,pTxtx0x,Q?OC0xT?Tx*W-tx+XZ >TxYYL^ZLL&	,]Wj`q!j0Qux^_DND0= >@  U>bgxdp&b]	:<	?Zu?h@jQ@*ARx-	+_SRNx*SgMx+` Kh }`R0ʀ 
0oeQ`
 RSPP1 0X 0Q]pd GXuWxZAYAXNS[XW }X$0Yhp^qZ1ZTpLZ1±
YZ[l0c1\\T0Q\
r[	\S2A}; A}A ",A~L B~N  5A~M uuҌВ"4"7x'D
 X /7d`!7g33TT?O`C`|`07`'`2`=`HpQx]w 6uuuu0k uu0 uu5ˏO$ƨpN`0T`
0100@A"| }(Ex]ߦ@C"+,,E+p٨  +C,,+ +,+x,+0@qx!,,,++x_,,"ߨ-.T0y㧠L721wt
!Mt&Ipd `1g	1}1![tU<!Ҍ(0響/0mp/l`
/0d@TpyE2A.-/0" *xc"+xt`
o3x7v0x8W7tP}
0h"[ZYYcrdѴYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >Wg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~@ 2 Y	J @ | @ s   ww ~~ r  "8x4D` T ` D)tX@Dx2tx1tI-&%[0& &xpvv ?&xpk[CSxr#$ % % "2x1 	ү  ¯0 $"@K@3#b0"	Mx3C
r beJ"xqOF`V0 p1#" &	x30$0%<T`P#"xr`bfp
0"$""tT.4} 
xr$3z 
`Hpx`p$S$ yrp 1pxnv"x~0	D0$ 6Ӕ@Tx~y}D?"0p4h3xOlx}@ DT 0
9 pclpB"pxt1xux|"xtx}xuxx|	"xw#xv6Pxyvxwf`Ӏpxw ( Quk}B@
"-`a"x-Pt %-o0p0p tU0/0b/R0h0o../U0`OU/`!!.-[ /0/0u/ u/0/-.!P/0!d0`Ô@"120! 
0
0!

"0!U H U`pU$P	<U0
`Tb" ! R0  /ZP!1D12nѧ2!1¯Frx1"@u Tp""3453 /:N+"3554!_Q0"0!xno`xaT`a͓xmp)nvpP*r 3}TOp0@0 0 
ֱ]):Q}0`*/[HP*'2BwP`FӀ@Q7 "0a T?2u$407S0!{z}yD237
8
u8 7+
`8608606@2$h' @]Jp4?

$Y	0
	@߀{0-$`
$`$p"Ga"߀V4#oK0! :0!@À-0
   4s	!l2!
2xnfPYo0*2d|p06SU{zy f xovpW%_`gK6P2 ( 	4  E @;H	53o45q3`	t%5544r	@ :0	h0"06`	2A0-6< Lr@1k 
  
 *90 B 6, Q
j	" !!`BQ
p0( 63"E^ 
-NU
]DU 6.
Jj'	@bG+6,y ,yf-e2pO7)0	LP85p
&0Sy		ay	0
¢ ":"0<8;ofpO:!/c)[P3
(.Cxm`qe`?0}DН~ h,go,!a,a b}e"4xqMNOpxD  Pe4`^א}R Vp0
T4d`$"4#`p~}e4xd@P3 0
3 $`3`3$`e$`1$%7$`9$`$`)3K$pvAT nq2c1[0TxvF>&`!	0,w0)%m0Dx  Z30a 3\kP)6P 	@Rи?&j¯4!`p` pJTQ`xj  N*`/19xv
xD}O`&h0{^`
}iT?Dt8`PpY9T~:wOq"@-`T`M	0676$``$p``1e7`tg7r((b)(0'0)a a
Td`x0dp#  xF 0TÔP
*xFtpxBB~zxNUNw}wxJqJpȏ:;<t/?=(x ү!:%$t=t=;2!(0 (=$Px`vT"` 2'<x"3y:; 0( ;:@ p0 xvs6QxV86}'p p 7  %76(I7  ""88Ô@`p/p0 
(` /..d`
&~r7(TP5O(  4 )4 040@O453``/`@$pN~54:I&duP2);P [x 
33oppG*L2]>gp1 'g;P"oT~ +ڵ?T#>үd`pxH 8@2M2P65b3e1@d@>?"01/ 
m
`,R0xA%30 Bo1
@
 u0E00
TDTq@5q0	 3:@a AP}Nt
 u2P2btl@
G0.
@	  r1l0dpe`30!DxFW105@2U`e bC7xnu30 0u3}r2+(ߣtw1123#.1}p<0{ $32  a<0 }
1pAR ErspM"p  d.1BS)x0,u`2:,`e4 2UU.X5%.,*ۀ 2732pha,
$,SO!% *R5 
Q'x`S+0	+_+ '-R	++@@@`p7v@}	 `@~A0y!T``Y_` VWyG
7pDxp/,LDy?N%@k53Eop;OCD߯.2qXTQϠu:93: !p	S3_1B3dUA`hy%%Ovt0:QON@pHR/ N9
d.0
`0nX6Fp0X-64F<0570`5#O˭0]c6e`	S8@1
!b-1|I%P/;u1
p< u1a1[P։*C{p4Iz5z5
3z*+	yuv {| A+ 90& n`AT0 +	al:hpd01o0upo6o,/-.rpF}}?0
P?/.-rdct%,f Wu tq70YS 8S;"Wΰ4쑔p1BŐ}BT_0=_<I?`$<p:T0Oܑ78e`pYלBxfT)Ax`%daz0  87`>P$4 q"W¥A3U	``uqq
r	1Q`{0
}
9ȷrdP9$$P6"{ 2F/}&e'AChS4Iqo}aw X@apR`pLxpGN3p?u]1ԒU^#5_`@TU`#v@|T kx{}Lxzp Rxy PxxPQxwMxv0Cxuxlxtxaxs`xrxqxxpx`x|Lx{`RxzPxy@QxxRxw Cxvxloxup&xtPxsxrxxqxxp"pxjv00,pTxfL@" -4j0-TxfQf/^p0NP -^ ##----Ji C?",u/212B0T-_21Կ^ L.S. 'q,Đ/$7,T{A?O-.`.pGʥQN.E.NJP7]Ĕ0p0Y{))y0h
P5
Ps|?`d7]}OPn,rt7ar4N03`a2Е
3p1
P

Q "u- 0;9r"l  },n1vg9,  A3.02'.pM=1s0D@dT0u`zP;DS,c,u.B.` 2 p0`u.Ta2C
.%TO.лQNP]03p	 ~`` 9a :b K$ :b)NӔ@6S ? x0!  x_60Qq7prrqxvWU	Xu

		0
  `
7P"q^ +
G1opTrAL`>M)60.T`s@}w?}S?AP33TBDWD  Axj6"@t7 C9xVxF,dҢX`T`HT
PM>@C!3"x)"U\]@0Qqڢ97F 03tv`
pUr )J'' 'BpP_P` qmw0P `	qPa"NO.eB"TO=EN Є1n`=J젊=<A=<aYpo0:BP e0!J.I$:1PJ+1,F;KҠF	D0c
^"CO`@"HIOv30aA!Idp l@0tt A2bIBgJ``JIxnvHI<W"xFExGFxEGxFt@0( FT.`xFF0xG@Ft"("߭F?6 0 G=k"xUB!C!A!B/)B*( #UNA
OA
MA
N/I
N+)D
J*aKaIaJ/iJK
I
cJKLMd`NPT&` v0uK K@ 
?MLtS QPHKJ}i}p}~}wEAMI!9..Cf Ô@"TxD[T손TAnp {@($0*E;@B}@RT`HpC}N(UA\AVAJA4A(AA @@@@@@@@@@o  AhBQ HpH"4pbbrAt"xbo o "CD )p3	0Np#Rq! * 	Z\9V NXV$`RQB2b L$BaUӔ@UlOaůUP0	xnZÀӒ ϐ}?U`#`5`2$pCx@%< D4SS [CxaUUT`͓xms'KYq 
xiu GÔ@π<PT~xiCtӔ@/`Bpxr
T" Pt`ixo aa?v+xmv25rt4}npt  tn}D
 "YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTkATAAAD!@b*>!Eb $wF
0U`Ud`0)uUADDDDDDEE
E E,E?EJEYEhEpEAEނ9D potNA8`pC,D
 ȆmT  g ۗ@KL7 &T F87#T9Rx@ZElQ
ha>W`P A7{O0D=Dd
`#p`(`0<`PdP`d`U0يU09NN!ǈt@td	QRxtx xXx\x]txat"xbtr}xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx x#x> x=tp x@t	p0xTВ
} %xtx"Ttx!TTTaD	x?D@xwTpT =TT	Tx= Q
@TxDp?=DDTxjv0}Ct QdMdR eP@eL`O;K"x0xJ/"xg/L"B S?/?@>"ށ$tO>1$-"T_Ô
P~0~7%UUdTT7%TT{ z yT H H+H3H4H6H7H8H9H:H;H<  H琊TY$1	 Q
 I`A  tR1~5HT& 8 `;cuTuTK0T"$`($_`*`-w/qp4p
TmђB  C~Mb Q P"RLT$`6$`!`0`?$apA]B	:3P
2 *}_05 u#'/A
,P3`G`[]Tp]A"T @ dpF]I0$ks `!DࡋWTwwq" T U "P$pR_PLQd`DQxgQ PQG?Hbq@P
pKPoxgv@JJJJKK&KHKLKgKKKKKKKL
LLLL!L&L+L0L@LfLLLLLLL  L0
1v"xqMNO`uRRRsx`}e  /x  "%m"0RY
R;: ܵw"} HGG}0"uS@	0SSST
pTS?0CSP zu 0P/ 0@4xatgvajQ/jxTxjD0@FxƋGxbx"x@$x%"x`}KW}IF	
Q@L0""3@H,xT| } ~ J4Q_
*N`PRR &NM((sMDMJNSNbNmNxN~NMiMqMMNNNNNNNoN.?PAÔ`P/."T? } >00xe@"QfSQv0Jq0pV	@ܰ50T;2uQۀ0K  0q00)	OS":Cm$p
;`!/0Qp,"xdP @e~A3}"~}e 0?IAR3AP>2IQbFbO0M}PE!@JWCWEA .XNY Q`lT0b`ȑ0O[0#0xD oTxh!1?xxhvYT 
AAPB11u32}'  $31T3322@"O0  "(IW "   p}"/*Oۏ0/Ô0/pC0S00O200`"
xp0 "P%x@B2345&k@"(t?3t 2'xA325R4U5B axQxQDQxQ  09t6xpS^vnS CSQCCQgQQR25 SHSpSSS6x
/0!x
tP/P
0/xu
  x
Q{Px
! $60#t #T %Qxs	}TBxr0xrßP2P[0 pw%@$Td$ÞPxxr`1 	^*1^$,-u7. <Tү$`&`p<Po} p% ABp.-,6	%xxsӔ@v $(xrvyrxsP!  P&0 	r6
pxv 6xa`r
 qP 0	,xx
xR!x	06Sǀ)^P$3p 06d2S STTTTTyT	T
  U@{}pwfDA4 D@ @B@"xDbU$P``3PTOW"X  +D "z:hTphO`/AE@E *@@jCEpwUi O~@ w 33TO"B@dPR@xrp0"p<`p}T`- ,*,, F_5@S,  lS,`xevS,,"+,/0,Vb@V?xw	` }wNPIV?u0 u1SSS0S3u2 u42U03U1Np1%10304440}P-5xp7x	410a^_5?5,Ӕ@xA=- X60c
+p00Ӕ@@6@0,	`	 VVW
WW;WWWWWWWX
XX=$XW%Xc&Xl+Xz,X-  Xs,6S	XQxu/@xBs1W-.![P
.-`Yy	
x3 t?e.pt e-
``l	clQrl"	ߐ`Ax@}풿}tx&܀
-   bt^,nQev  q}U pQ t u vAO}	}15!`N)qS Q!q]E"P/s0 ,+o"_
wZHXXXYYYYY1	Y8Y?YFYMYWYaYnYuYYZ"3Z8  Z3PXZ8Xs  S1
tt)Qŵx#	e
pp& YD lTQ@ST0BQ
b:Zl0a'SP֔ ZP  cZP`!!I0~GJt(ಚD:c4rKrgQ
xa)1O`KD1P,1P
QJCS[ "gD `E -Pc80.u,,L,SÔ@ .",ҰP#t .`
T/Ӕ@""@
u/$ -$U_"x@| T"5}5$24 [2+[[[['[/[@[I[J[K[N[Z[[  [  _Q	xk`0/_" о 0/ 6u2q(Q`Aa U " 0f33%$/A_^Pe2pG20640!+4d	`d
4FPe"~anv"q"44$`$`2$`B$`J`[$Wpk0˯[1P S_0/V_QR
D	qv3ڑU4A@EG4pS
Fo
D""""չ0  0J]t]|]]]]]]]]  ^u2#^!u22b ! 0#! ZQcPwyA=r!
C\kۀb 6rW2UDE.u8QZ/0!rHQ 
R 0 3P2"0"x%0T~t@"@7@P@@	T@3" kO0!xo~ d P""0 Ɛ}t 0	i^j:0x0x!TT`Dp T{!!D`o!T51 7ZxD@&`?["  :	;
/123B=>C	D
WX`~x`!ÔP ^`_b^"
% F`7@0x+ +axqaw+s+I `C0/+xT 6 } 2.uY DT_`6X PcTT`40w	61 ` S 
0cx	+$```9@=`xv 0z q DxT"xStTTH_[+xS+<x, 6,@C`$p#xSx+	x06W0/E!

?0_ "p.-Ô@-ӔPq @
Q=PQ/-$$cp50/NC.I}O.A+ 9VP`@\D>kT ]P-Bp}} bޏC.e.s b9@ $~SSN`R$dp[. .Qs".xt dpDaQ0ӀwÒ/@ۣ.q xk..TP"-.{{ i"p#"x7"! 	ӛP	뫝0@@0 ÞŴd`PÝ@ӛ@*pÝP:;<u tkt"/01234u5Pu<$t}5}Ю/[ccdLdfd}dddd΍dΎee1e1eTeTewewef8f8fwfwffg3g3gVgVgygyggggggh'h'hlhlhhhhhɽhɾhhiii&i&iHiHiHiHijij  i~K0~ %~ p0% pC3/}u: u; u<3{bf4iT330P66
~ 6`  fwR3`0u75u3@u:u;}u<{uxu{]{X$::;o<{&5Սhg0  _2Uh)gU

-K><,@1E` 
} P0Co3+R#~ 0`| }` @^_N#`##*(
"&

5P)*)Np<I?d @(Z
c#t 111{T!7(+(U/**81U,/,h3/U1/5H13G1O/|@TE1RBA$__TWB1 Wu2d I'8BVX9$9='U8FGXCUWCIˈEEUL͸GGUo`VII#M0V6/P!}VbhQ/"qV πu3//\Cq/4"$y`p!SnPpnzŸ @@ "@A~G`jPj$j1`T}%A`"`"xs@}}T} U  VxpBBxsPBQ0$70#"Ap
 "%@AOr+ 	 	U		V 
 
W
B_xs		 ے":0dx>T=@Q
3ߒ8T>?`dkP?ו>IIPw0=p1;P8i } P' 8@
ఐ|? $ >D H0
0k5d Ep6"}`~I }oP k#@b!p1Pg0ڐ}P@ HTTn4 Yt
佣#Dp!0PAz߈5+r++/0
~IС+2!_$QIuTl@&nՑp0tTA*pyP 
41nll"14PmuB1xe@606
 0ǅ@60'Qk0e}pp
T?T`4"4" u2<}0n0`~~^z0kTODt001p32k2]* u1tAD00 	3yP(P08?PQ@`2UPD2B32ӷp087Pc`&jRP@P}`"aR{3"0PT_O"
070% o03f3@,pe0`!01?2_Vbeo0oP3ఊ1!n10~
_  c`5Fg9 	1DMcA&F=@T3`02`;:+"45675E4`546NP
(4`i77$pTo`M4`TM=`` `'p-n>Tr AE D i0$CBDüf0q BÔZ	*u1au0)'2u0p
1}}G]34Rӝp2u2{u0@*> $3]@P20贠' ac@'
L`1m`2^pڣEl;8002`BTTT%%Oe>xEp0>3i`D
` 
p	0dm`0a1\Q]T?`<@7!?$p*?3t?T9)e	 #c HW@01	a=s2`fO"c"Mc#N$'NTRtUnپU$	??Q
o)$	U6
??u)txdd7eU"}{zy#Wj7u5dj12u504]<t`u/'P#~ s./ds5%t#\vh~@_[tQrktW0ppT0qN`۔L=2t[	ÔPt  q侑o``z4ѼU@c/Gk4373  ~v.((svpvwwwCw{xAxyy{	{||}O}}~~&~G~h~	{ z y4k	5P4F w
QhST{lSp(1
3D,t?~5{u4`u5 ك	]4T`pd` Q?
p0
PFu	Ir	uzLoBmP[|| ]ax<[}} pmi,iiPKß
Np&V$0/Фiz (
r67d6 N6@7"PnRPJd0,v e5p4l`&{Jqw!8*8EU| `z {E` @\]Lvv8999889dp#!#f8`
9#
							@45q0F 3t[c9_8(d`픜!PyDA-0/* 
E0
jZk<ÐIIP2SU~dLpt@+#aM`M8@_ɫq;mpGl`T@
`r/@;ňqdNpt/ ,V+/XPՏYP7[ZNp7>	bUodp'pNCWWriҞ/'P#^/i 4(?Rdn&pfJ1h<Aj)=Q Vv>afx?Mr i},KD|T-`M03980,P78+3? 7v投3"27傐}3+P~ A| 3$`A`yc $'~ 2ࣁ'u3#uxo277 dER t8u@`
_Ô|		q@	Pt7pz9qTT Np: );4u3touq$xe3`3371!`04a wƀYaÀ1 PӅeP31˕axBdAU́1pCϑ2"߃Ӄ}`τ(2"u0X03} BY%.჆~]N0
:>F2pPu2f	opw`8
0:
``ӕ19100! ^xeT`&}$31dtP2"u}`q 
0"""4}t(t sP
3U02	~HTD"LION x9pP
 wDIT":p
"aI~? d˒^ ÀӲ  0d"0Ӏñ }7p8`0;@
D 
~Y,T we8 (@_p 21"1,"`"x0 5"5q"psx 
qUvs>qf>~ 0ab on`dx"j7 u8X`,7bP|  `  Pnp	84gk8$bd="89F;u<98~N98lpe;~ M9E8 `v j@@~+P"~
mȡ<0&Ex33 d ::Ӕ@o:@>x#,	: ,Y=x@A-:zQ R0W<p 
;PB
$ٰ0\=<>?u@`"H P/A(p??p>ÿ?
>`j+@5ސ5@@	x&Tp/"%T~ O7&@{"`"!F"x!To`	TTp57?3o`12D"C
xCp'x6p>A4ra/T(--,r e,p,,~Me,`,,|21G3>d$-t"u;2A&8<9@Ju;;;`P9:@@ɾl56x>FM
 pb?b665 5 	d` 
GG~G6CI"] DAJpO*q+,U
,, +,@+@^j&@T` OFG$&^$xt
 T0x"T1T4TDx!CD@gp
0g1dpa23%3{3+232@
4k`V4cmN(%%q
OPZ`a00*OMT@eT+		"TY!~L` #Aq""	߀F	 >	@[2xp=dPX LҀƀԀi@o3ꀚڀ3䓣łŃ 
`	"3/ߟ$ ̈$ P ##EN``#DsB"P""):0"P%g0 "b``"  )ߍu/33@p " 3@P"Ø"(p p8

r
		{
tQ
X
	


 o*2	1	"<t 
""BBE"""ЃЂP  tsn6 s$ŃŃ1" "%5|pbpp
߂s@h`1p1 1@~1v$1@n1 b1V1J1eP1111 p0p00p000#Us                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)  ,  oL   P DSDTDSDTb  !HP  nc6200   MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 & y 

B9G  D
wAAI}G
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	gi
  #11kg 2 ph{pi p
 f"`'fg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_O_S_`pga.ag)`B4
bra/13ua
 6
 s %[I` 
u	913213415p0135_INI ށ5H7
fpig
Kf 9i` g9hrgfata
apa`r
ahha `a u
 bbi@ ibub`\a@[K
  8_HIDAJ	_CRSR 9?)
&	F1S
  GPG Ԁ02
 j$C %Dt6E p'FCC020pyF2i1pB1t#209G22% 23 4 5 r 7"3ۮ([8   
,[́8129A3[
 BC	5
[U1 DAEF30Q 1 2W3w3 34H35
7@[G36!7ְ"38'5 9ZAX3BQ C`
3D EAFPZ450Q 1 42AW06 4`Z 4@`45Q 6 7 8A9A0W @BqCDE  @Fw M@,51
E۠!P`pua42a}aiapa ib{ab[N@10}2E'
_C _ADR
 G[&   n_STAi `	3p
T45`56
T
C[)56tqr 5 D070 857Uo57Er2@t58& @? < A@#59 [#PAKu5BeD`p` p`bt57e Ze` ap dpy40cCdc
{at
 kb`zdx5C!{bbtGd
q6puP@2dcrdZ58` dza
aa{
N `afuff aOdu`['A
2Ja
EL

  BGkq;
nEDw `xH d2?y' '&}} 3[A B60pibpkdrd
edA
d hb @brb

bhb1  23Cj`a61SD 2K661crc63BbWN04!warj5Eab ]b][@]
]
buq]atb
bP c^a%
`bac 1`/$65S SsK]Z5E
361 }63c)626P=aacq`\66@1E~_S3<0p 4D
eL67U< W

X6X @4[} p_9 [A%@ 
"@6Bw
K6Ba@{^.h(2BACDDF@[B:H 
E
`
[k6EFе70Q 51 2^73aAW7AW76T77AG7Pq 9 >pg7A @!^7C!^7E F q80F#81 H82 l83

d13842j85 
<[=   @`687 8qf892@ f8B 8CQDp8E`
[0 F	 A90P
aT9`	  92T93m
qv94$
k94596 
!
pW9X@97 g0~98gqx9A
[! BA9CQ 9E FG`A0[#\_GL_Rbp
?`{P[!
dv`oJ`Q9D9E{h jp
p
H\rА"aP9FbˡqV[Jp	rya
c}cbaa0A1 (8` 3A2x0 wA3Bωhiq`y`j0OA4
h<1Ы7E: p3 D+Ba(g80V1(@pwA5!i5p@"m7APFbA
iz9DF17B&$r8C}j80[GG6C@:*BA7
@
g[+  A8ফA9Q AA$AyC06D C0AE
A`9`C]
	   zo{` `za 0 
bw
t
	rabC
 101
a )T{@rv"OL&F
pI6'B`B0
y
rw iPH2AB`Da{P ` 
p{z1 wip{wa` rbqAFb yC11	_9`p~Bw
h nwc }r    AA3
ccFB2
l
 B3 B)4 pBt e {ky
 B32e} `e Aj
4a{`ц xzq5@p #b}e
e/p !z	e e$}`@dAyA4{k
 	``z;}qA
 ЈAA y!-Ap?dr1p68d pA8"9 9oe@{B6q0fB`7 D dyce@
QTѢB8hif"f
j
r7@
EbdB	!ba'c@z!Dby
PMT6CTHTPCIBb(px`Ab	s[@bB/cp7yacaABw'UC`CDe  dBob[FB9ŅGGGGD@DzB6 7|#BB
@ցBBBQBD-_PSW12ڡB`k (x!`AD[(0@iE֡ F C0
c	C1uVm	Vo	o	o	o	o	o	i	 Rc	po	o	o	o	o	o	 t.ҙo	@o	o	o	o	o	$N!zT%[MP 5c@#x`0833bý
[@PCB /@CC
P
[5   CD K ECFвD`OлD1 m 0D2pD33D @~  PD5{OT 9 62Q
 0D=:s
c`7
  28 0D9SDAA!D$/D(D///D 'D//f(!e!(.G !G!@($3(T N #F(F/,/M E0@ #F   //A eA !A N A GA "A T "c0EV/BE2g0E2//.3`03'3// a0%1a0%1a0n0a0G1a0G1a0@1BErtJ  JHE5	E6	
#  y ɋ Eh`и``
퀀`p`apa!E60E9	@	V}`Q	``[EA` a'#B	 p$Cq С	A`]v[ODPHIDA_UID
`|E9^^06F!_DISEAx)_wSRSEBh__CRS5Wa70 r)$$+b1r )4f;	c!2r)C EDM h13r)  U[(iA 4r)H$`k0jQ(5r)3F$p{8k6r)71>8B[!a42[vF21F3
r 4
 <5 {[#"G`P9u[@KF26v1(W 8UO5 -G@F	QkF9
,r  FA @LBC :_REG3吰0QMFA`pPF8O 8_S3D
p 4p oFDRݠ}( FE
 h46 `U 5] !Fc7C0_KC100
48`
{	h`?{`h48{i }@
45$ q\._S{B_1ts._DOSq	4
` a|![^2bb ha[7CPPpDCR^FWD
 G F 7SShsrRS** %Y$
 
h7EFE	8hfp
` {w\/002#AO98
0y1`0D  7 Q   P  Cohip~8C@h{`>@}`  @C\=\/f	F1]5 I6|6H1N`'8
i;C0A4hj	 5hijCqa.50hR92s 1 0pm
p938F2 F)A
^/Ǵ0kl3vV+B 98` 2a{04aa`0`fBϠZDV	_GPE	
PWQ
Gb bGf f@y N10CnN10DN10P<#8F "10

p 112 3`
p 4/cD(PDpipp15
 a	isa`115[J  s@@ p!16F@417p # 8!9)AAB 11PsEF&2@p 122P.23Q 4 j5s 6c71289A UPBCDQE 130Q 1 2 3R335367k  8s 9@/3A!3CDe 0EA40Q i1 q4q44556347Q 
+494 Q4C_INI U4DO qDq~14F[  IC150 @@Y51:p 2	wh
@axa
db`t
@`TP
a
 @}a`*
;y`0`}`a@[8 3]< !azw`
d`xr`
  
@bau .54
q 5s 6
Q7
19 0B
CB|15D2E
Unknown 
NiMH 
LiIon Np5P}P}>1
  a |Qjq0C/1(`0=CP57
a
ZaD0m117FAV58@`	9Qυ}ha{a
/56ˠ}Q954!
 
Pp^Qw!5!5Da15F	ՀNP A9"C160	QaBp
P?{`~`JI861
[)h`pP[0F`
csc
  dzir`a[)absdb1/2J*(PccC	2m	hg3
m?60g
oU45D{`g
3M@4haC lN 21Q25pCa0- 128 w"Baxra
c 
_dcbpb'b,Cr	3A`a Ba$(`aࡔ-:4g!$ IX66
I+Ep
  W 	ip
Iq:/59."2BcDcڄF c6@0 f{``	{2``EFAA84  9H2ccdp e_eez
cpe'cpci5%4?s 5qp}
g5Bp
IBC`p
7`D5B!k!23C-'8vG@+yN)0W1FQ-  
qu>
>4(P2pzo
 5Wap%*!5"(B+BC@F`*se(a7hU/EE	549ata
!e
b@Kzch!

 

6Caa`i36
@ ra 9PQ paupaBHf:ba8h660U>992;0CUR=1c1Ur?22o [
069rAч
H{P   a3C
Sp
SIMPLOySMp
MOTOROLA aO`wRA~6A
p
 
Ajr (_Q03':Q{BA B4u11b}
4p
a4Y`bBaPQ0TZ6uB! C['cTZ3_J
6pn
àJ1a6Do
PRfP01A 
 M1_2 N8Et1#A
BE^F#9BnO116A9_E316

,
W{ (i2=8Ei$ŐS[HC170E
71
N 73F773 740  q !8 F 9AjABCB7Ds ^@17F88182
[ u њ8184886871889א8A҆871Ua@
A
!87M8a8ArҚa` 7A`
B>
 Z8BpOpi;8D8ErA ằ`cDbaCc3gFbQ paA
EA81c18P ya
 d
b
 bdpdS c
 c
Нc
B8EB`8F8Ap`kaʕa
v2C albab`b
vbyb 7917Dp`E7C9q !F#!AdBzj
a0E8W8B=C190#'8qbb	aq bbVQ91Q
A467`6f2
746" 66"7
q3
{C039
`{  iaw` `!{Chp!
`!K94	C)haDt0$b cU;0AabcA@'K95 p^^6cIX97LC
98

Ggy 19A A	B/ P99pqd798[A;9}CF_C  _DDN
COM1!9D9E6
30U"    较8y `NS  9E_STA +9
w`1
3
 ,+_DIS {h03839
F_SRS V6h
aFcFr?e)r9D@
_C
w9

 ` c

n$LA[fA0   
1
_ON_a2_OFFPR0Ao0[LgA1CeM6C
_G 0" *
W~S)![ u3 2K
@>A2 @|A3D8^,o/Apq9F6A]X
I A * 
 	 A7
r
;`/! A2s 7"S3x""u"30#2c[+4`$8m$i$!P%`$ $8[Ce:(90=0AAp`  0= AB
;."@r-0AajB>AmAшACuGH
1 Gxx&xx"q)x)xxJ Ko r^r_ _u\,QQACQP@nE%QQQ=C5Q1QN?3?303<RQV3rRn*CGm3 *do3dSb pAD44pAE4?V4V55 X5uvxcp
,] AE0pr88!]AF=]75]0]&2]qBq1uqY:F)~%B0 p\/0sfau02 703w(`{fx  !r@z[Odd$QBP` !B4  BBv
G``Gppd 2+2CB5
q 6`2eBB3B3B7[5%8#~ ^"  y s9؀w@ @ "-[ӂ5ah
 
q tPz
     *U"@At~ba a !-B5
0 p Gor r " v` `0_Gd d"l[IBD
" 0A[Մ!B")UBEaҘ  BEBF&Ow.     [_+C1C3@
   
 
@DDC06C0ADR   !C2
D
[)C2C3 БI{NIcC3[KC4u5AD C[@Q6-a {336a =cr:}d%'C6F	C0C #PRW
	
7[C7"#|@C8\/CBPD["

 C C09_7`{`7>C9 p[`GGPE_L1A`D
C0Dz	/PPq
]@[NC1
	_RMV P*_EJD B.aLP CQ BEQ F@C1CIC;@C- T@*F	D`( &2S	>1
<
 7S	3p 4`*O0CFN


C,(A_DbQc/AD$	02#
		C@T					~	G6C0A6+D7!ND`["09#A*N_GTM? p
7 `B PDIC DA!E .lDFpEQ B1F{A@@(0$C
DB!7et10B
 
Q0
P
p
x:p!DE}(gF0EDD)qED
{CZMhT
UhT
hT
hT
hS
Fi P `p
wC1E0a:` A` bwb
bw`
cЋib ac  rbP r-c u`2Cab {2cEE1bca:6A !{ xP01I 3.bL-@#~#M
joomjfjockoaAaPE$F ; ,F !09RB0Et3<Q
_PSP  3 O2bB8X97	
# `A:8OD9ODAOEDOEEOEFLpb\_PICh\/iD6MޠT Me6E

piTQ5    *1+
C#E PH 


 HGCg

 
	
Qa 
		Q EF!	A	
la	5!52#q "cB%i6,!!!! Q3c  !t!!G  !Aap]65@	F/
aR  pd
d
Primary 
10  
LIon 
Hewlett-Packard EyTraveloka	4xO@ 3-5P~L 62	0062h`/`%
 

" 
 
]6k5hEAA6A109!a
xE6bp o6ha`4h6 
_UID  O0
_BI^Q  ST  `CL\qb[GqP;6D_ `)C  ocrdJ6
ACPuI3	G	gR/a005`D`57 $Z̐ƠAðy Nmp&Q_PRA01=81g`˓`B=E[:&
 LID8  #0
	/15?@SX%aN^#1j"#A VEB 
Cy0@ `0kpyk`ђh`piaFaڀ?0EB a{`
hs }aap`k
  p=ap  @( C 4 Ò1  G&EEw x

]   y `2` |hp}
yj  e  )>b1`h)h`a!	` ib`pbasabcpcau`a[L`}FP>F0! a a1J/ 2iF3 F4 5 F6C	p5  p
`

S P  r
` a7 8F6ee[0wre
/ 
9q02BpFAILpapMF3SECUYp{AAA4aVA5`^SAbLwrB}UCRD]E-3P
cFcp
W`B
#A35
  QF0t
-A	C20w020112 ^R2Ȑ_"2@g
54B  Ju%a%SIMWa6206&O  b;2JT7`A10q  `rPGASSA'$1$aOACta`~4Cap	o a14E> ES?; 2CC+abSb`a`B b ub@gN} 75h;01h<piK9#MAMB.F
v_x @q @ QBvWDG?
<4_c,E=DAAyB{M4C~ !f )AB |WMAA~|F2ij=8ItBM"[ep{6P\zI1{h
`7&044
a$`p5r047k5PF7
,*u048K	
  jFB T 3 AA;C##g
s971* #Q725D2A2CByk;{~68A @K: 	4	K52~qN!hߞ8h	" M_WEDs/-x)1BA0-/T.r B8s9WQABNwFOMp(  @A:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPC!2@O;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9c@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'aށ^2]8O.m (.?! vB PG/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H00*)'XFw6bL	=֐X|gMsb31/~[A70憁x9->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9Wq
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[C J 01[1Cl[#\_GL_yh004B[pipjRk˽D04F\@1uhqF@l['{['`[D

[jD1EF10 r 1112`PC10ph10FF20`aEp{zh 22h7	`E 21 1D 051i	
	162	P[ED2292A B C:D E0q2F C23W0 rf90Q3130
w[ 2@(!23324 h
34@ 35z 60 `035UyA
	`rh``v!mF3732cаdp
aJac
@`rd
  b}y   baya
a0apaceraye
	 evepeBc ucdcM
8r7cpc  bpbgC	bdp apbe)ec@e ffg
fape`pfafgvdueA`bBG` gT`	$b pg13agg7agdM:9,05A , p0`cW`bQC D` u`pyR1 C IB D "h Bh H
bhc `r Dc`arda
e,2E-adft`f	ru'adSuc2wftd gLr:`4bA 7+A F2EFF-9%839`2EaqD2Fa
_INI-ABC060pibhb0Bp0<3Brb
DC
j0CD"DD"bF5E w6
arC019?abpb.0+bab`babuaaP `bua 3/_CRS8FQ19`fv2-E`T`_STA t
`}``6 9XD!

	 A    y q3F A=[Kw\/240mHH
Y41F
RGпGP   }@    s3	0	  1	41[Cw\/243}Q [196F
rG G$ $ GN N 
P P Gc c Gwe e g gwt t    3P A-\/[	B1na


W!3p
`q ^^.C1705\_S0_S
 !  3   J 4  5   M\_PTSph%_37Hh
 Lh
}	0pz15F`Zb1E2 6A$\_WAK } 4212AP%1z# 2b6@6@ppTZu45~ TZ1_
 2 :A15
a8
p4@35b|Q0

O1acbcc:c6Do
1:PR1:e0p:1 
 ߀abw57j5A6C1D8
 `?0BA-C1.`L3n4
 =,D\!C6G,
6
ߚ
0Qnh

|kb [
pqL748
QM0UMA
.1NB
NC3ci40YOF50:z 1 22pW 116BpT16C
54
1({!h !;0iiGi55
зp
'>1נ$R``Epi_Rdp	D
6
hi5J`pi``
p
9r#ip`OBBp57@`phawhAw52ihr@
!! #8i ` a 6&NE
M i`N1`9pK
|H?QpR
   qqh0A0
0
	
 t!&
axa

`b0
Bbt*?.o PR
 R
Ya!
.!H 59	B;
[Ckap T1
̯4/ofp{V43`p9{b
 bbwb

araMpLall1p_x49 q )a20#h 131@b4 /y
hFI	{Hb{  4Fp6h@ a`%  G 4F<`s<qC4E4p !A`SA`hx3_
cb !Q7K
@9h `t`03`x`fA@fI{tff 1tq7cbyb7b&8baFbbߠD
iP

ep
d@V%;EDd*Eef$G#i01t
`a|׌AT	R04DarVa[MlB@@i
$_ON_U%0R[2ra|P_OFFb6p7C
9Q
	D	
	@qQ	
uE
PvQ
{[5Fg `025B["C26DHCC1φD2E[H^_ALF 91QAL2 AL32_GAC0 "1&D B2Fb3f\ЕPSVBSLƔG63qzEESx(,E ȁG8}p1E49p
{p
,4B$ZBSQQA?_TSP
dp rT`CRTP^0TMP5)ް[Gb4ځ65

f,"*30/$ C\_GPEJ_L00qoE19 `tD{{` {b  {`
a 1Fb2c@sca ` a BzOE1 C	{

67p9 w  CCBC0DRo}<ACE+c
@ [" А/IO	C	B	I0(DO	fO	~CE["
dܭD07  34I9 HOH./0*_0o
3 S/o3-B67CSDEM?
_L17 !982?`u}8@2ڣp-1C7@ 9C1E5`>F`1FtpԐU{f4
@s1EFC207
848b66_Q67 1
dDp`E7 ^G98`PF|[66uMC> 82k$A6C1D7p7KanA%D81Fa4!VF/a}>C  `q9K!F p>9`G
A$.  	`
S`
Kz!`9aE+		P893197!|
#0
I
xQ'8D8D8Daa`u 	b@Ec.k '4:0?5 {a 1ccMQ[PA q,
[ B?p
a)?5{
6B?Ңn1 ΁21_N
a684d7`o,~NqD`iP6B`/`	|	ApעHGc
5Q"
			vcv}bBUSSDTq`HP  HPQPpc`  MS7FT L4HC@	71   3    #__T	_w 
_	O0Dwj
arao
aJ4aUEP]FQEij1F  AhH2eGI2 270_27170$ 41 JO3U3 yjX2uX3Uj9 	2]
D`tPabb`hQ6Ca bub 6C21Cr1211phb 2rE25q20y673,
˂b+1 y U  V!4'*[A`LpPDC{ha75 PCT W75@74q 3	_POPC aSS727Y{7gNLPr7o7_EJ0C8# p oA1  Q _      	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n     ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ       	 ATIF_BM  vp (  0  n #.C % O O  !   n r	`v      = @/ `)`   ܀   
 ( 
@
`oo@)g`	&	Ϡ!
ϞA#ecA OOOi/
gh)Oc&Poof b%a& Dʠ7@3O,p:(/#..,/%4OI0`@7=a8">~i?2C
 `*C DjAj3OO OOOOOOOOOOOOO(&
' @ Jc  Ga^`[ `\A! )``OL!YybY)A+#:P @\΂ Qa.OK ,A_ &BZO
NA
bdT  (j`
gB
@Q`u#l!_!rooG soo ?\oo
Ayoof 
d/
o,Ho/ހi fb[ "bOW  }e d  @-a F k .5 @@O`@WP@@@AUASb`i"!hA iS"$CP è aV`akY$#a/k&$("Dtt`(y Ga  /OOOOO OOOOOOOOOOOj)~O L&AB2a"(!¡bAa ay@ Alay Cbw[
afv}B_`	DaBAza!1"eFbD & 
 `
? 1C ¤!
`@ bBḤ ""JC!a!bC)# FAA !MA ".H&a(+ -4`d03-'2b\2+9 ΀ԁ!Tr	@
p@-    0      VIDEU  AIBM 761295520C??$  2005/04/20 15:1b #S' @<D	C
Aspen M24P/M22P 32/64MB BR12677 225m/300e
 (C) 1988-p3, ATI Technologies Inc. BK-VER008.020M.030.012  ptASPN12.v611  P24 PCIEDGD1UN  OEM.001.049 l l K$]B   T1zX
`TVSɂ :+  7uA@( vA4R!}Q  MOBILITY RADEON X600     g     @ @ D  H@    !U	d!@ W/    W0u@#A@@
 `C&&L %<"0 &4(s0  p
@0 D ZHC`  -0  .@/ i d`
 OD  P  o P`X ["| 2"3=X&Ju 0!4@A= x| 6 E qE+ f`U_ !U  P &BC/	m۶ %""c=MT#[
u`!q!"2
O0L  'H0D퀑DTD//D"O)QSB B1	1(Z @9`+1)dM QJ0'``-
s-[ H.@QAD0& 1w M0:LL 0a q9VQq2q#
  5?q<  = T- RU
!,$@l%. 3 :N  `   P ӁP`   GLQ` `E
H < B <9D9Q  BBpmA -5?7p  ;uuR9_0 #  d o`a B   B rB 3  U TS %jA1k e%QPQm&_"nn  %=BTPE J5e	  a? Q??q@EA(H?pH?a*Xn0$p
3  w #4 (dt@225Q3x}73
  nPàPr`U.U 3mAag '0lt.Z)b+!Wxsg
QBhdh  tc Ą  bk f`.>: u>.:.<	  u  `1u .>.9P u.>.:fa.޿w4.>q u.w.&w.wмy.wf`f<1INIuIcW	.Y	?d7 ST[)$
 t.VW	 _^~FIRE GL T2:13	P
U@UU$5UaT+$XBplpT	.
fa4t.b4P mX ` * e f WP2X _W   @PXuC &GOfGGOOf& G OOR? ZRP@+ CCP2?FX 1FXfPSff-@ f
$ f$fPV:s^ntw"qfPff
p@"q'U q"fX zqX=Zu`Ō-V x4 
 6
K@$C PCX C_R ?ubr=22ft 0 t f}0auAfÍ?om $G  ,{@:^ u9^첺2ĸ tT3e 
| 1~ 6@J$@u  B@.^ȣ$$$VB <v  !  32Ĉ&! .@2ɨd^ß	ҁ NhV*81@Ld
F8
0
aW@P
 a8 ^
1[ Y>cE F
u6c .et(taw
w"tw#c2>S6N)N=d2P̳<o @gb }@ KbB   "t
u1#< $軴tu	P$<to tjf;Qs Ys
aF;$<t*<t0<
t'<t<t)<t<
@	t<t(<t<t (C>
up(k"R9 HF f;c [# ~ tF: FlfF62eF2vh wtÈn<uj`p$t }t  ^"N 39X8u P P$X"8t+N ;N"rҋNN"	F;t
~<uF1迃a 0s2~@tRSf_zNf1 `IǑIK&f݋Pr  sByQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ 
F X[ÊFf@F$FFt@F&F(P( tR.&%z:Z.0-[PR.^t2kM ZX`\ @ F7vu@z=J	;5vv `tU;5tEt:]r9Urmt5f3uif3ۋ^$f3fa  }C s
8sn~=}:n=a	Ð   1'( -   S?BDcOQ]OMɌOVУhOQNgORE0c	R 
l	jcgvWX ce
pVZa	߁cj| [i=s  cf	ЮU'  q|ô}% Lܥa	d2^ !ҟ6! # ן/  =Aҟ)1nҟ 81Ao*0*Aǟ
	
si	ӟW,b	
#
.
Oҧ2  A13E2oY]UM40a(+4ip !b6qٯ?J@)#2B84jU
u%2S.<t
 C[3Ы3Àu#ڋHQ   u u 2 U QqFe
 f`f ҋv ]jUbHS	C	8t	C$[. PRG\ouP tW@ @J,^P@  Xj  U    @x`SQRVWc`f<t< tpux.D.< uhXG$?
t\2Ҋiptʊ»-2..;w
( ( @..Tft& _^ZY[A&G@Pnu
b $@
@@qS^[НUu G<uTG<uGG%H
,Pt G2  AG%p	K`u/BJ k	 Ay@	G@[S \Xno.?6p
b} rlte u0Y2@ Uu.&Krn& i m
mYVQ."jY՛	 
 pfFm FmF`  .%$FDV .:A |~pom@蝡f`pcmFLFNF zF{4W  p_<>@SQfY_S[SWXP u2  )  @X_[(@vX{XmX[_BtF$F&P
u9C+$
"|lXsbXXX 赚C `+f3a  v K^ ml N    tW7}c 0V ) Gy PFRB^Z,a X6{D@C7 CBS$  {PVWGo
Ĳa ud
V"tQWD˙ЭMt@uN,߃u'"1VF  faa_  t>/S/P/BU[0QY$ Ā >
u2B[X.TaDTZD@! 5tpUt Ut U@暴0 t
 ڽtt-J
tSuU@zA %?P%@
Ā?
XÐ( 	 c-'(+  	 t|P c_O/PU
(P	@  ? 0	_@ T(   3A 	MRŃ](
c    
   bc O
2 B89:;<=>M?
 +
G _B$d "ozc/fk
2 I >2 
P  
> ]@( $	

 0P0 	  
   u    
 %( (,%*26', 49$,0	
!&.3+0$8=-2 $8
? (,(gc @$A ,!
( 0HH0(, 	H 8H
8 X > XAgX<	X0TDgT@	Tf(XHH8y88 ? 4<$
$ < @XA8@	d@Ap@ @ ?O.2.r!suP =Ou W&pp2P=: sX.卵$XqB%
&C&/^ŧP_ª*o$' CFcGeI$ G+6t&P$D$
N<~.;u*6|P8Dt	\S
OX:PM
X.체0&G	t PG	p?܍
u&.+X&c -eVX0`PW.E#Ή_Gw^udlu
޴k2`aX&I?UD0UD 3̓]U 
F CE?]Y[	
 FXNPv(XK  S[( vvuQ
u 脩uID]P[U XN- pѶVu^tH HU;]Q S[\S026'C[2S  &'B[  Ë#utt&FS 2&C@3rut	 F[!	7	 2
n Ȋ3S.8
[t `v {'7t ̓rPHXuSص߶S[P	$
[Êg% oŀt4$
@   t$Ê`$
}P X3<J1u P<~$<t <t<t@؁ð@  @HuPÁ@()3  @
@@ b !"# 3@tb
%o`ÑSI߀a)e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;u:puK>L tDI @.> ^ C3u&"0]<~]&g7[*0u3 3ߎ2PQֿ3f3f@  fYX2PR?4$@tZXP*VQ  R<  4Z 8 b3"ŷP m33s AQR赱$WjDrIDTOD fRȊYoZPRPN XE@ZX8t
tPZYXnuT  w 2u _-3߲
t	u$ a0t P']wX^0u0$0<0u  &o#6<uA	ut	
t0
߈~ )<u+V봀1u0*!*QS3u< "	,܀4u< uqp 
hh6u& <t	 00=뤜@SB"
: on`>%^N"	  Tg.P <Ȁ>cu>-@ 3ۊÜ$.B.Eq J@^X]`l+Ht8 JH  <8t<?t  .B 追  볠K%/+Q` K Ki Y@ 3Y |RQ
 lYf.-  b߹- *# ?(#  F 

 G@s 	 Gޝ~~|ֺ| |88| o8  l  <~<0npW ff 6xx~~~p`>>66f<ff<  >Wqf  f {; <f8llw8x~` 0pp0p$ff$18|||
<<a lllBll  l ~|0` 8l8vv P``0 @ 0`   qaa88 || x" f<| <l |ƀ @|  ~ C P
a0P 
 y ~
 ff|ff f< ll  b`|``k 
r < p  n`b% Ɓ|ְ|~Zl); l88#<  P
ΐ| %|b | -׾0Sx|~ I`   `̀ 6000q(v |8 x`flx1l2@ l ɡܢ-| p%| '| 06p'( *2
v 0d 61  8 v4plp;5[ |ƅ88
l8|'!f|ƃP/&&00 %:l~n ~ހ1-7  0
	'!r~`l`fl fEK>c8c>  >a<E4   ,+> >`gc1=  G0`2#`?#: 0|6> l<~61F  6ll6p` l  "# U# wH# ##d  6 aP P 5 `ROqPdJU1UQ2dt770?bK?0aa66R9b a	
Q R>   ~  f 9xeb]Pf```<p_d~̀Mi|?܀g8 .Sl8T(r(l`"8fj~C|q^ 8`T`/Paa! b~ Y f`[ ps xdaw<<pS2tflD8p&.mp0t| oQiqAQف၁|PQCmlEc%oFlpxpq5 aq3Ԇ3v3w҇ Qx>}6`vfqB~~`4{>~~>ՂR2$ PV3~ {p4`|| s4S
@<c UtE9_2`!@AH@iP!3pxF)bfwP0v	~mi D{1687 9
G-3 a5әAP p|@ѓ`;Ҝ2#a=Ғ~ BC ҥ R*ҤљނtPa7`p0iQ.f`d|d`A`
`ζL ӥ񦴝Rpb@q
 x
p S 		
qQ0F#a`( L%4bLZ  ~EQ࠵  4-B0a6P6rc l  a  	P $jǷb[6 qb 
P$=b X
cO5.  'Ma0
 ABоc 3A Ut"{ 8Y
0x"p	#	$@%#Qb  
#p
 
% 	"Ђ#Da6f?0P rʀ
$ 	%  		C	J@Cdw@`1|cc0c 5 	?!	8 ld>BPP<@ WWd!_ 3`p3 B< ;8>hdp` ~0]Zwl^l Q6>6n6 @s&t"#D+ f 5ڿ Z Ed
 
Z Ӥc g52cb 
d
d 5e<5ek 
c
 eqeeu %


 9Ը=3;1N Q1b0i2S$|ҏ05Yap``<Af	`q| Y a0^0 v 3 ј/AX`ixx x8#I?~ s6t?W2@ _7&&MSWI &FG_&E"&E#Wm_&]%&}&I2.2_
t@' k)p = ~=^~=~=~ &U*&$
$

cS0B$
Ļ	-	1FS2;t4&wt  pu`2xRԊ%@+F4_t=@ eR ݸ  t` t:t ?FP܋w !?u?q&ܒek ڊJ/R 2쇽  &GF %G @GÜQW+&Q&D&TAα !	ʑ  p&RW_j&&TAP
 XF2 CD9&Za
CD#`	 +
a@[@_Z_Y`GQWP$0-󤾄p   jr ts | :&?Q%a~ " G 	ĸ  2
WRW` aRFJuyCZt 2f 	2wPYs	QO&G<{YO 74 7@Y t' EPJJ  B2BBXJwA!U{,?VBBq#6)^!]P9  (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

			   

m
   r 
*   S**Q p   ?  ??Q r  ~~   $$$(((---222888? ?? ?/  /? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h@   1   ҙh1 h1 P,h   1   h
1 
h
1 
hP$
ĲXð\N WQN^  t o>I~&G3u 	u&IúbtԀ`cNpb  P3&2J&Gq  GLq ģ`À0c B2[a a;jb{mphrmÐ
  !"#$@ABCDrstuvk(
K [!{ ;Al(L} \!ߕ|<An2N ^!~>Am@M ]}!}߶=A`P@ P!p0A aP߃A Q!q}1AbPB R!r!/Acj)dC S!s"?AdU/D T!t#4Af?F} V!v$6A@h@AH BX!CxD8ArgJsG tW}!uwv7AeVESA   0  PmR  @  ATI Technologies Inc. P24  01.00  @ @   W   sVBE/FP t:.6rp p<r2.]WVSQR  f&=2u " WA_WȎ؋ʾRp" uz &u&E_UWPPPUwU Ubp M_ǃ"``݋ƐuZY[^_O ËRQSVWU?WQ30
Y_u5WV6R2^_@

.]EE
tE M]2B].l.DEEӀ~ZӰEE!@ #  
E" $ ~7pq~$@@@@ #  P"%~@ EeUeBS3ۋ3[@N
tȈE}~=
 P1E*؋EME,].

-+/E0pX1 
 f3O]_^[YZp0#RQUSˊ$ w
 V< @t| dQLPY
 b 
NŀuZdĠT2ʋD<u<t<u<uAA2PQ03 X23` ƻ
`	$XPf{C@oDI0o[D0o2 2pDo6tu[.- ̈́2O[]YZ)ø mVP$6|Pش~!t8\t,	2^ƀ t &Ӓ @^wO-  	9s3"0WV>¶F^&Vf=>^_ÊFG< uûZ.^._>W : 
._@StwCCPS(.$] #y[XSL/[ vt{t
uPSR Z[X8
t
<RBB@Z2ÀuI tp<wjut`2.]0ap!`O2
̋AaPXq(
u uW3&/_uADOD<ΰSuLA.6IS [';vȁ~PAJS,f[Dt@S&[%@عSQ.2f<ff3f` Y[f;Ës @Mxryf}@Ч
2uGf`PoRPfZf
ff3-fX<uʼS$f[fa==f "$[f%fP@@ذ
XZ}RJZfX"[
uQR~pZY!]"uRY)Zt۷^3"t	$B wl wfߋ= ]QRW&9f&f$4 }fgq_	uZ$& n  T8<\ VRf 3tZ^fO_f33sfffPfVX} V@cPQRfRfQY  $  ZSYX!
9PfBfkfv7Wf<0Bϴ&qfIu" =B&$@[A\`tW!_f.  ~;t u2X#%5$$ ,3>QSu:3ɆtA
 [YQ
⿰$YqD?SQVWP# S &IWs  R^Y[l7QRVW聿{	_^ZY^ڋ_  $[ SPRa3MR+ Zt $$!
  t7SR #uZDQSСyP&= PH`UYS$TUVWVlXFYYZZ]% ,\\ PÐPMID5$^  ׸ k$$$l]XR ZR
 q  ZÜW2 _Ü"oQ K.:3 f.;uw u h 
	rrs_2[fX)D%)7 $?4
 &`ffQQ2
QQQR@WP& 0JfXR2Z[ff_fXZ - 見R]fqf_
V
4
ۊX

HY
틩RpfZf}`f_ZvfPRl g +1KK;rZ  S 
S  S@ [hSSSR	QpQ? @DQYÜ2C @`)@h} #    ` #  d # B f 03.Dfa.T
.d"[   U$!'!]Z/RHr& -Y&
y"
	.Dt fX_Z
+

<t%+%
D Ԡ0F`
DGQ e8t#su*cr Y$QP0ΫXr	8u
@Pu5,XP	r%0єrtr@jrXQfuQ2 PvqtQrSP?u$XPQrKru
 uKuXuW_` _  QS 

O ztGrNpr0t;Vt3r,Gt$ޠr_r1PBNKu`~ u! rdr
psr1	Y`ϲ#isRP*s2Z W _YQWs`¿Gr	zKuq_P Q Ys% _ $  m虠dOO<SurjQ[rbfa uٷIrE8w8rUIP2XPr+;rr6"~0)r @a,X u3ÀKu3S QPXY [<t<Ⱐ[<u < p3苤PQWGGN衤p!_YvXuku_WPD@_O
t  ꜑
AÀita:u-a0Y	V u	@		u`|ðpPXOq a <Zr,ZP2P [S]pg6_;w2XXXYf`	 e|		ut6P%2X0 y  t P DgxDX ut!P% Xt_ueP{ dX P)P%t:u@PXt0PK  #u#P P. 軠 " ~ 5~ rPufaPt t
`	t߀trѧ
u+g1htuQBQ]RL @ @

0Xu
 	c诀p   b Ю@r5sst ugfffPPQ&NPPQRԮt8
t^Q
i&!i.? t.;u.;Wt3@^-'(+ ]c@7h?^_OPU 7 oo XGwW 67O  	@BsTv2ed. 
90  *+P;
2/S_Q
t/+u'3At		ttuC۰]4U $g i ]a!S3  [y/B$J .gp s  J$
2	{䟰@
e^`	P 	!
U 
̀			
T	 1P.
$@
JP@=^v	@=v$?
úZ[@5Sb1/իIJS nQ$`$@fP,8 T 0  PsfXAk @c*S3;s.:GuP4u.{R&$ SffȻf
   ff N[VWQPS= Nuw`r@Ўؑ3f<8ATIuI 4ك4 t4D8u*D.`
D.bp .7.8.>~5 [XY_^`PVm<u2@a8uĊ^Xû..~.?t` up.G8J ZYWVQm0omY^_? 82   F=P1t=T1t=`Tt=dTt* <w 
 <wf.
! p ?SU^]692ireb. t[RuAk>_o"q X l'0uPaaw!_``&akd
L$ ЬBh6][3۩ 0   PN  Xu22@t $C s} t:тqTWO@pPF $ A7Bܸu )$<t_2
#r
p
w2\$ 8=R 
a<|10tw$=!.$ #$y n?#=_ puPv ̀$
'$w
,R
$[.~
R?|>E`߅ 2HR?U  YIS$J軇'1$! `m@  RS%pE'E"2[0$% G`u Qz#d USD PQXЊ R tpijmuj%l^ ]X]"^^EFqGHIF,F"F`R/<`{yakpij5kwQw3 P]ސ]p^w]
G@HGf
A``kd e %@f !R!Rq7?@S A  "
 2ɲ <Ē  /  `Ѐ@ $R@$0$
;'$ݯ $1=Rt@g h#W$}V"q#K$jR@$y!'pO$ Az P'ý3xQW2dF209 MЭ<  
mtQ`
BPvP..
tP XRN'FEE1#igf}i菲h @`	Xu	>A6{[#%Tp3\'[@겻(yC·
ѡ 0Hq 22Өu~:fWg7`3g.E#030-*'hhaAuDA 4B@7DοDEUu"cZYZj[$"ÓRW$I<#t=<2t9<3t5	 B$	e,S_[~_f PfXٱ !0ѝ
$<<t#<t< {<  < <
  <k"F* y&E3usuu	fF4Q 8т_._f.EfPF .GF4XH~ u lF6XHheuHff%  f_F8fXf;@qPf	F8jd2..>tڋF߉F4 fmZ(oP0[}
CSYC[  Lu	 QLtR3ZF Y.HF
GFF
GP0FG$`@F	ۈFG0
G.M	̀

`3T
ňFF	`
G	F	P
FGF	GFG
F3F'F2F?@FB <!a?QRߊF;#t_7<t3/##
<t<tFl2NAVB{BF X!                                7 S (40f
   {fX[Q<R>] ĀuB u*@fEGtff.#Gf.Gf뺊жubuS0I[`.O.t	q tIt迡ٻPIt$<Ȳ2YWq?DP _@ n Ps d r     	 p   RR   p 	   P G p 0  P  p  P^p ^ ^PO^p  P "$p  P	 @KZPb 0fPWQ2ɋYSQ2Y[SQt93.OɃ.;vcib1 ZS1Y[VSw|f
S St/X~ QSfX PQ3@G YX fSfP f%f[ދõwlf[j 
 ff
^_fX2QV2{.^`Su= v8ǰB} YRfPP%fXfX`fP:m&
pfXyr'! ^Q
3sy}Q2P$?XVk"b.fQfR譑	O$BP;%P~1$i%0[PXR;3Qf
pYp<fPufPV!.^2 >fX|fZfY߰&Au߰@:5f$PJqfbYf
(<t=AOMPWVRQ+Ë&G
ߠ36 2a!$@fX&2&{YZ" QR
FFB7 P$Γf@ZY&0 b"SQR޹.
 I ÀtntQ  tt" PPPQ]@`tRp  Q`2Y|@t.Q
yYf.9VZYSQVN %0<`uY It	oY.XP d$o
 Yյ^ R ef f.;Tvq vcp  0f@ wjvef+бRvMv? v2 v%v u	r,w-qZY W1̋E._U UNfVf^ސsf㠵f.fff;rf@frx`f N^f;rLfPÏ.Qf;wff?+f'!@sv
AC
X.L
	؋N]f
tt= r = rA.DP.wÃҠY[0H!r +!À ʧta׻$nPV@s۲V$߲T$a P WӕW S$WtZXypsq5P%&O@t@ $&W7u t@B @`0ڐmHZX0	ZX RWڿ̓tϴܲ _a @`0Sf4[ø \Dw37H 				  u  0  
+烊23ڲ[Y."D
$.
tcs] pC@ K2o`;?/`UpvP 
 ]ٲ[&Eq P0x0]OX0腰&D;VB 
 &^1G!ZS$o^ Ftf
^~f؀Nnp;w@( uڨ[Xu;@f?P ?   FF Ƞ 	rpFD
T轕&F |Fql_	FȊĿ471n0%
8>
F%Z}Q0PFf=$a-,0)@f
 fZYfË؀~À߁u S׸
tQ~wfA>
ÿRGס͸ HZ3 [04^ , زq 
QRc3d 0YSR.\Z[   (d
$ͼ0tp  $$@!"
u{&45 *0; u.>tӲ.::f3Ý W߃ G7[ WQRVSp2ֲ+$Х 2@ WfuUdqXfղ|P@E=  t	@2|X ʒ ϳsjor[w= 
RI_[^ZY_B?t:b0WwoQ2ftu%? t`K.!   &ֱ   ul0
 0
0
 Vf^fPB 
`PۺՑ`ËaRf;ufY$g/_p`rƐ9ËËߎ<пqâ qzCBr iV0w Ծn u~ ZX^.t]WpzӿID_BpDap?VS .;u[^|ӿ1A	lӾ } ^( 
 : 3KfBCC}胤}У   @  Q`wҲRX=Y}Ҳ1S@Өu[SGҲ,XA	&  Q; ߋ%Q|$Ջ@Y`("5Ղ73sѨ
 8֓3 Xh l   Bp   & @*@LN  QRSjѲUP@ڻ
P$ һd
 
{ 0 sҲXP%
XX XXUaC[`QP ?t@w tPﳊ	UoP@0=~ѱP׸0f	UBXЯfXZXx20	R_d  N s  .<IdJjy !  F "N饍HL.֋F2KyQ  f ^ M
uOϲ) $л 
蔛P8uKt  NVuN8Kt
7$

ů`k('t	{
޶ y魌ߧ鬌n@ZXt3q  鄌KLt܊2
Ϗ 
  {3@N5QP  twβ&$
N{2䁒J_ 1#̯p#!̯ @nr 
ËQ߄P@XY^8铋H	u%T$ȰU$ uӀ0ɑLpuЏ=>T _(u  U N_ B@0近I`&;'f3.O>f.O% $Ͳ$f3
tff%@ %f@,._O>uu r̡
e0 %]%U0V
D1
 貘pVu0&&)*
ͅ	<t(1
0
KKP%.C<t8tXp@'Xщ GxRc@p2!:t`0%$@ 1
cv$@*bwˑ$M褠ؐ 7˲"`AAp2ˀu$+rp?2_$pIuR!= Nt(5(8 " 2	爳%霈 c$O鋈7u=q
by	T+	L
؀
,QZX}( 0e0˻D -[X@
8ttɿuoSP <X[vaS	K u[S
t`@ 5J.BgQD @A [
qqMðS 3ɸ.:T .2G̸ mP @iʻxTUA$@ʡ$?4?+bʻ%PXX˰%ߵfQ
fYfPfQ
} Q Pp|p
  蹀QٰA[$mtqq ɻ ̤f%g #
Q%ɸ YKuȊ/  SP@@0
{%
f[ø V NM F縍8 2u * "- m縁A
JȽq\_ }@渔{c済渒 jfȸM渍u0
 p-Qwm o_ g渁_AqWA'$ø=߸  /
 r
'q(bǳ
{fQ 帕@   #帟 QpB\ ù?ItRZ8uR
ZCRBƲP 6 XZC@y,$f!UprL. gf.&# &ñ By䰅R23Ұ
Ϳ)u 
Z`..^ un> tgp b2P>bP22AQJ2=QRPP@q 32ZYYy2 XaZYYR*8}2.]Zà؋ m 2Ku2W {S
uSj[+с2Ê2+U**&R  āZHuB$ JB J.]r c 〃 ޡ  PQC3BBaaPQ YXaYeԨuX}N
+.J
u8~` ]$0<0t ^:Jt. ` S +*21+uX  up*tX⑰ p/. P"㨀t0׊4"
ވÊ$"ð( @ѝ = !$%D
m݁ ? +

,QVW++    e_^"YԊǊ竊_ S8v2QY2P >It(P
_RS"82 PL[[ZRРJ2Z.q q 03<?& t
uV E,ņ!&J aZ	뺀-[a2RqZ1L0 }
+ȴ@A
t
2&LP    >&}S`YظU`J<t
A<Ut2[ð
 6% B B2+Q+++YZ0"ƯȰ+Ջ+Nuÿ`$` t  Qݍ"t|kÑpq8~@td\8tX|0I~D* 
8t8`t2ſ
8~
 ~Ȁ}ݿRt*Ŵ
RQVW3ۋs P/2 1t@   _^Y@ ZC\WQRV`T3G  ZYxs& 	r Ǣ	 PO@  ff̊f / baS[F_@fWfVfRfPbPpfV +Ɗ2BAXZf^f_SRP1 `VfZ2f04[wu.N i wy} rhf&Iwp$MG|t;@9 _v[`-ovI%bR:ZK`R!eh߃ك@A3why
twFs
頃PdP+>PEbFߋ+Zhk
ta3R
#
+ 9rnAU~6|m &F +Xu &F E&   P ߀Qa+>2u	&}uƀtGVW_^t!#ut
>|  21
da|u\wVtPAs drqF`u
oQ
С
6JX 2B$]XXc@]SO4 2
FfKu[3,~!#|A鬟ompeBuEG>PF eXЅ$6| 62 'tmU؊Pu)#ëp &N>Xz ƀ!1{   PO 雀Àt!&0@ b?`$ p&PO Q8r2в2,Ћr!=1HJN@PRXWQP͵sêuXY_bQ(IY+qGtrG _vqGov
  _u　PUP[,@.X`)V`4|4F umXPRJWQQW@3_G8v
 VQGY_Pİ@[KZ&%_G+BO;v
ZPݠ θ!&/2R_Ҷie0XRWQRQWP8tXP75$FX_YFZ Y_Z̰ Ï										ɲ		>ctqP}}>
u&fP 3 f \f$߀t  
@L}F}SP
3 t&   &]X@9	UĴjP qG@ĀG`ey
L'|CkP|A]+A%  %%&z|&Ē*(DrX&G|t
Un'	-|̢-2"ٰ[}~3{yr{>b2PI<
vLw5`GrA8OsZ{at u2<
u:6u J{<u@{<u
t22+at++&eP>Ҫpeyzpб{zz.u~&2p
O37ʰ'ﲿuF tzjzcR`R8buaOTz~1T`NV8zb$O
Ip(!Q̊.ªt.;t$.
DY^Dy#+3*2d!d"<PR3=ZXt
~A>t
y>u<s .-Od}! ֫ #ܪ+` l |߬ԬtÆƣ =@&Hy
}+>&}s! 32 =밀w0$&e߀ te ò 3NsߋQ2ĜB0:JG `;/^ xQ&5&m&M CYlx
u~	$aP0轢cu4+x0P !v &5&MwN  w}4 ~ P^a ,AWT wtX9 @Y.ڰP;PY0 d2|XR~ ZSںYB讀 [Z SBB  s Ȋ`PSfQf  t^$t"$2t t=fIuvt%utfY[X$ .(Ȯ*<t
4zvaaov<wPSPRRRп@n@	e@}P=s=s=|s^=Js ZXj[X <t<tˊ~ S&[u t@ > B Fu.| ~ uȎ2..u 
*9 -Ƚ60:
u00w5wpP&p u͎..F.QFF u6-1566Sp$[x&G&g3t!<}
<}0
ô <t
<̀
&Gpu߆2@ ֋P$`"3ҹ <u{Ȱ P' X̀
PuÀu
&~a@S[t (22QPF t  +YsuчPW>&}t0&<t$8tG Ȣ&E+ _X`3t_tuG8Pmu&2}. aѬtV$
J	 Ǌȋ@/utHవa& L26t
5`t<t F0J>=&]&M&U&E
ȝPp>X}21PSQR.^t	00߷ZH<|!rSH!5[VQS&F E<
"@<
t2Bdpp\p' t&^ E	cqras -Pһ =q	t2䆠SU@,][ X[YZ u:Хujq`Ip~Am^F>q<u	Cn.qG.:r2.] IÆà$0<0tu` tq
2.;tq `i8~û{ 3n tPmU#)Vqpt# ? P 2  ~     ?     :@  R轩*$Z.$SQkSQuzY[f.
uY0tXu	f.>k Ef0(`f.(ŀt
uPa*Rv j
PRt|Zpr .@i(-2.OA.WB-tW+A_t;rÀtR p D
uɨB.&Ɇċȸ 3  u},A	t0't𼀭 ]莲
PGktu?M2@|
uJJ Ѐ@1

@? 衩Pө@[ZPQVWS.>Nt .TTux.ݻ	@NP Ў3f<8ATIu? 7;2QRS$<uP`F|<2[ZYY.ɰ.@L[_^Y@Hvƴ 
XÜf`PSZYsstytrS !f-c[PtF!fsq2~1ԧ[
	+Gy	f  ޲r  fa-fP22ɻ| 螨fPfꧻ٧߻|"ȧk|0 f h@BWШը?踨赨貾ħ2ɐ $
ȁXp 3! `	fX7S.= t.;u.;]t3Х5W4uRЩhW.eD <t<<t8<t4<t0<t< u0P`S4=@uuX5
X
=u
L_:@E=@ Xx ^W}     Ѐ  @jPmm @{wj X--    
V 

u`豿P=ua	dFX$謥ۤ?|$!Ho<$+`n謤  ;$u p _Dp $ 0=DWDW PW .? t.9u.9Wu.G2tpU22T_Sb.Ɋ
܀gqi:p[;D;;û q#Wt\3PR迣$ZpR% FfGb  ff0fR t3t+t#@t.tpt>t-%ffȐ%flaf$<t$f- < tf+ f
 0f2) ffffZfYf[Vp>߰2fȴ2f3.Df3ɋ% fwfp.	 L  
P!Offpf  !Xff;t9`hfX!"X苤" 
Lmjy#:@p1b ?( m

Q^'C㵕 `^(@qDEFG.F*.~/ @_䊿ط tttt	tr`[V@%Q~H?Cs6 -$ 0oNAfX^    q  + pE { C @C~aRlu0u	 .F3H莠 _ H@"  wufXf	 }Y^J.~0ǃ

p0q  	?p)tfP04 0 }  8!mfﰿpfPRQQkuPş߸3?跐Hp{XP  0VC︯ 	$x,jL]1	` TN"
p X>
\/ ` #f/ku _u8 itqkt= }0 (p ppC
uu
~nXTntY]IUDpEPqM<~	<%  Ytr j YZRSfPWy1qEB.E_fX[Z,4)F
@ g<0 _F;  (;; >p/HN 40  })%88 A~	I? CJfPVQz<t%<t0WG\
 $W<9B"EA!H* A"`-YN
 Zf
  9F-fP 8Ơ1p ` f.2t3/ 4@}ff
@ S xf% 1MtANN   [:_t:_ZY`^BRVW,Vh ^3ҿPg.;s& j?>.\e?ËQ O^~ [L.L.2
0G_^UC@SD0[û@ J(A I֑Ӝ0u薵3HS#R
 ~Q t5@
0uzXHT.PPS2o Q
RPJXG bfW+&G轚 ffH}tf.#fPQ3۹!fCX=f" 	WfVwQfH.
fr5wzКX՚f^p$[H  $,48<DLPTX\`dhlptx|  ;@>Q  _`//  ? c$
k*6
mc8*1 C D
  
 ! !- @^#
l"  = @ rI  
I @ .&y$l`,>$!EAs/BJ @  -vK I'm$ j8!]ha	̈́&@4R ӿc۶(, - Y- =!ߝP0\ y5%#~ H+.C|[H8C O\ @d"#CF( N% ؏'	.# woE9 Ƣ( [GqF+  /#~!-+vk+ [P z ABmrc	o	b	y`	 g~ B+ 1@ : IR# (O6 i  nb8(+ h"6 -(, PTA PT PaPUa! A?-'A{.P]hq1,.a5c
5^O1] a`0U  1&ccA$hG!_	6eaWګPp4V1߾0  $TV0N  @PW?Vt  SK[^
@2؎Z@< u+~=@PVf ^y[a   : ;?f=0%?f=0 #?؃  ?=	wIu'= Nvu D@SC0ы+[<wqȎ؋t@@봨q(Ā:@L0^뎨1pt{2qw?_fY w  _@HD @x@ PSR諒 $P@Ț
XtuZRP$z"
Xn̓$" $Ɠ1pEҊP6'  /ra: 
tRPrQ
~0t X	 pXZЈWPX2 t3ɿ;t@t_P33 t=@$@Њ$0Ћʿ$ P$2Ƞ$g=wu$	$>  K= = =  #蕠wv<}h` Z@PfW=r Pp1PQ
<<$
ăQ<<Xü4 Q *@3d @A &06SL 0+  A  0`e  1X ( 0XB 8xVVA P	 -`N ((' @$
>QW](_YuEa-:蚠t腐 `1/T$ÀB躑0$Q]t$JP=@r	1Td
艐$.tp؏QSqǏ5fm5GАQ!>aCa׎n$)0:Y
o* u<$WL`$/o蕟ȏYPA
$
@6m@P?R#p  ΁D$@3%  t
tQKݏmL`aTtF2;rWF`FV_x Kٵ` Z bðn9 =g9ð^WwGq@96q7q0] 	p?

9b8p8
K 1 /|p+?$\0 MWx  !ZP讍hT襍o /蕍Xsc\yHHxp融$򌻐 _[UQmF;s IP8 V RFNP'uڃ?^
[F 7[2FF
V|FًϤ"~?P7XӀ
QYINpY ^HF7FVЉVW1^5=3]VG7@dF F^9F$v FfH~贿F f8f6j2Fp4n16:F	Fz 0
6AF q
FPQR$M 
Ⱥ$?
oZYA5fS@5VV оEUm '1A+EEfP'GЀfX
@TU`c+ E*ߊ	`#
4`#8蹊' / 9 ?f>ĜcB$J&e 
_
BA
  0f	QS ãIM 8%= vޠЧ$Bާ, 7@\'${q7O% n 8a4MVs @@f3 P3ҹ ȋIXA;rw$	YugX;v;tAKMXPQ ,@

L8YX  tPf^C1jIXAfQffffYf 	&\`   fBpG͈[f^O[;rN=[P #J O,qH$t. b.>.
px lv
d3.ñ .<  .3f<8ATIu 2؃? u2
 PVD׬P	8uĊ^!g@N6.ۗM؋7tJ󤻂.& t._&@.?tǐ?w.E8t ECCйVWfS _pP0胨W.}&.E_.]1.M0:PXf[_^`f09
-0
̻n$
.E6fp$
T$@O?$.es03蜆W =p	_U.]9t"=f"	=%f	}&f1	&3SG ֆ<fXr
pff[fYpe$` 8 胇  0= %
Ĳ0=2..ta%lu

ó~' 
Ȅ) *u){++i#@kP.f 4fȸxi3(ZYf[
 .  0u  t 
۪ @}Ӳ |P҄Ỽ
訅% 
  M裄7!< R΃ZxB%a蠗駃ځS1k4% R{$ZW 3.E#_ @_VmQlW ˕pe 谄$f}ؐ%;E.uDfÿf%   -.:E0u12   1u"ߡf;ût
 ŀ~ _gΊY^P	E= t= _a6f=  _Y RW1oW
n P;-$p6 }Vb[c_G!ͩcQϔmP9RQRR$ $п4
Б4q~
łZQA?Yu 0"߯BA$q6z2K}2'ԂqWF
t.m  1GQm@0M,t׃W_41>ׂ_$-ă#Z|ƚBSّ#}o4 t?!A 0Y0ЁBtʁC'taD\$ہ_T-H㞁08׎2*"1xLu\+	@@Ivp+R͋F"AF ѿ1rF-c+F&2$r[$
uo`1e/!]Wv9u PF) `u$
F)ȀTׁP0fF4 Ġ 8̳P~pF7t03  F; qX譀FB#@0π0xF'͊F(F2fc3  ^0)2֜Y[9u迤VtgE3ۃ˦ `~0g f fb  J$
ffe`q
fﰯf
fJ$
f	f%
f̀ffACRQWUD 2F E]4uHuXu	fF4pF8~q_._GPƀ.Gp4]XH p6XHfP;uQ fF8fXf;Pf	  f2Pk.>tڋFF_Y30
ɡ""
WG.Et.;
u
.;Uu3ې7`6ptA  wIt`cS2蓽p5ې
@@Z_7.Ip
P P
F"F 2N(̀ N(>оFF'G'N'+$fF0 Qf`f1N})F 
F$``2.O$F&Fqpj+%
ffP`lF-Fa
.oN3P.G$ 
Xnpp
Fѡf	sf	cb2c``npt+ '/
$F1F N& n1f102,F,Bf.o.g` F`F P@RG	  $ 
F0` Fb!R B`Wf	`Kf  G02ndq"0

sn/
 2f/f_	 
 n !`N2AVB02۞`P F0p tZtU1CF:B64C_A@΁B2WATsD	F2_I@J6J2~2&D7DDaph a2 8 < C F H K L U Z d x     ( x100PySt$^豖 Ft -
F u	F=!(^~.Ff.fh xPz1︠~ Nn.5 f0
̢ pzPuo	J0{v {E_f^
~yVZ`lVFq}P	C
|6Ff`|&F6  2fѽy|9|5|y1yXf^ˊ߃fٸ4s^~/}8;虵^^~ePFPx=߸$h3`,[ `@p)t
o菟  'w"ӇaP0ؿD	DfD1 Ee]}gqt^TILDu'u?D*aw++؊}@@%?? Dd2C_EeCÉDE	b*DEe}HDL0+S2]Ë؃$ eĈD\\[ˊE
b	q|2?ȉL rqB1cD3D<v|$}<@ $PX;}Pw`d;DX;D!z#!Ë!ЋȉD)
'EPj2D(D*&vu @D+L-D D0D.E94S\1\/?ЉT2?03 ]`(Ht'@P D;XD5 ƀ@^@S @X ?^P P @ XP ~  !x@ې    Samsung LTN150P1-L02  1  
 A  H } ? !bRl L  "0Tn0F?"d`  @U Vf3ɹ ҋS{^
uyЎ؎f<udf|p uZft# =	wIu 3Ct{ (֨ ~^2QĀ ]a`UG1	HH	 I2Hq*)PeE;$up E;X e9=? uPWAA_= vU9pN3Ƀ= t$9w 9EwAE b ׿A@@} uQ7@UEDEDSQWV^_Y[| u ? =@.|& t.|&Ǉ ZVYDNDMm xMm 2b]a$@VWQVS 2 Ў3 8ATIt[ ؋7[tFA5	
&G^±
p ±  廙."$ u;= uDu
{
$ %ڹ  _^VQfSp	
Pff;u.QPn=Y^4_t*`vq$pq%qQ3  0Ysԃ}4 _tbqGqp!Aq$3ۊS 0r0؎r3
ǎDq
9q
[ÁpcoE3_f_#Ȼ`p@ZpPEPp`%n:b4ap#'fPVWSu@$0迍֍?*ϲP,0A*D0!.D1
.}4u'+`  Ԓ
? 2h$._A1T6  ݰs 訍B}&3E.e0@3@[_^Spl [À
tR>p  M24X OEM INFO!W                                                                                                        x 2   1COD@ P h$/h߻ "hS@.9h[.AAgg~$ih$g! hfDP1INI??SQP2.N= NXu2˃	w,.'
t o#g  u.&P @                                                                                                                                    - 8"-             1600x1200  @  
 B ہ}P !N! _]W}_  _\!
E  W0u A    CLm <0 A}40   p
@0 D HC` 0 Y @! i d OD  P   P`la0X 
|1 X&J@ 0@A4= x@ Ϳ  qE+ f`e !UU  W &B/	m۶ %"""M[
uY`
$@ "2
O  w'H%A&T&//D)ӈQSB B1	2Z @Hα3dM ۤ@`J
 HT@QAD0& p)w M06LL 0a $Q)VAq#
  5?:  = ?- @
!,$@l% 3P q2N  `   P P`   LQ` `A
H <G< 4DP4*Q  BBpmA -5?7p  ;uuR9_0 # $ oC NB  = B rB     URS %aBq e%GQ&_AAB  H%=B 3 Ue	  a?Q??q@EA(H?wH?a`6YYY YYYYYYYY YYYYYYY0
@YYYYYYYYPY YYYYY@`YYY2 2YYYYYYYYYY+YY Y.YYYYYYYYYYY2 =2U22Us2U2YYYYY eQYY!3Y3YYYYYYYY Y0YYYYYY YYYYYYYY YY/YYYYYU% YY1Y YCYYYdYYYY"Y/YYYYYYY//YYYYYYYYYYxYYY  d/ /%3 /Y YYcQ&YYYYYYYYYYYY/YY YYYYYYYY YYYYYYYY YYY,Y&  /YY/YY /YYYYYYY YYYYYY/YYYYYYYYYY,UBBUqX%YTBR YAYY/YYY  3Y3YY//YYY./YY YYYYYYYY YYYYYYYY YYY/Y//Y Y//Y/YYY YYYYYYYY YYY/YYY/ YYYYY////]1TYY Y/YY/YY/`YYY/Y8YT1
S*     ? c$
k*6
mc8*1O/
 
 =! !R]< @^#
_" zb	Q:  X    
I =.G@&y$g`,>$!EAe/BJ @  -Xb	KXI'mA$ j8!wha	̈́&@R =c V', - Y- =@W P y5P%~8^#~107+.C_[H8C`	"O @d"#CF|( N% ؏'	W# wE9@ Ƣ( [G;F+  /#  -+vk+ [P z P%Bmc	o	b	y`	pB+ 1@ : IR# (O6 i a8(+ h"6 -(, !%PT" PT wPaPU! A?-'A.P]h=1,.a5c
l51-^O1] A+`0U 1&ccA$@hA3_	6eaW]Pp4V10SX1
w*
OS"|S1CSt !@" "0"
TSASpѱٯA
S Ab6ASA;$/)SSsBF `A   ZtS@\ZSS# 	/ A&S̫rb	U@4=@
@`]bM| ZS= ڛgJ	=& GXO4 a	SS΃` яf:`HVSASA&/-S'/
S;~  sC`oM s'X+SqSmb"H_.V4@yˀfLDSV܂%jZ  z% Q6 |So-(b{6']r  J5' !S<S.- +fc._!o# ]3Vھ.hhh	`	``	{7#V
] )Ve` ) AySxNSRS SVSWSWSSSAS azC.S2w.P1PQ/Sp.p!cq.1$Rjb2ycox6S*Cnc`QV11WiPDSSoSd10?
u). $LOjQ%SN# /P$%V##sSSZ'G\SȄ!o	n~9A` ya3 @`qS c).K@S o	V/dÂ!v/# b˜bAynoWcPAbb	^O kbAobMuaJM  k   㤇夏+. 񣅧,0`6tUᩒ uZllŮYS|S$<                            @      /    t     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    N^EAX N^`  p L   O^A B^  C{^B J^ECJ^`  p K{^CF^ED`F^`  p aG^DcEB !6^ESI 6^`  2 2^`  :P w:^ > >^`  R^EIR^`  V^CS
0^Drq .@,^SQw*^F(^G1Z^F 
r^DR0 vp 1 z 2 ~P3 4 {05 6 7^K^Cfp Pj PnPPQsXsp q_Qp 1##`p 
_
___		_l___ѳٳͪճݳ_^GDT ^Iq ^L ^Tp:!_rp Ps~wN^N a&wB^S J^XDF^]
A(6^b2^g$:{^lZ^" "V^:,R^  C,^D>F0^q".^u *^yD(^}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw^=v^B z^GD~^L^Q^V$^[^`^e>^p^xDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^^Tf^j^
n^X4`h4  #_###
_#M_#	_#%& U& & & &%_%%&%Fy_(b+^-^ ^'^%!_V_VVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` |   tP  .>t:o$>U U#uG6JB qs
G≠} u7 V" "$r;sc۰$ 	 PSQRp.^	c(f.^f.f  j AnAr
u, 
^ t$.^tN^ u% ;t	.^ urt.^.9V^t!`	c.		!w?vp} a P0urotib aa
uj. .>_0u+.^t
 ut-Bt.{_ ;3΅u'u2".K  d` &.ZY[XfP.^P1_af`~"r">"e"
w B$? 8 b ",  %" L faù   Ptu
t>%Ά)u	{`,Ò!h	N
	 :twUq cs脿  gfPf&@1a}1q	21 -6U`<u f.R^=fu<=upfffDf.
f.@#(R^fC  f. ./`c .3pk!>/_d /_8d A9
uf3Јp;ZYf[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:FsI>%=s@>a4s7>(r;< u<~ <A<uB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI^ u\P@@??r6aftf+fx`Bvfu	6Aff33-f.x'h^fZf . CZ^<7 &Z^KkJ PQtނSc ۄr	KtY`Q`sV2' !	 詄s
ۃ`?r_^QW<;t=ހ  ?A Ts?urwT.Ws_b>蹃tT!yu譃uP	pX
C=cur:f s20W%t r#t-6-0/o
r\afb    
   P0t-*u袄r,$t
>r.d.NWa JJaXW\lWt5@"7.R^.;I`uf.;K`t J^\ o`96XR	r n6S` p2ft<guX<t<t<guLpr
t@8.T`><pV3`i!<1?1_?(/_?pÍ7:@!4`AG `Vdc1a%ea ÑЁtI.> rÍrD輁> H$r5} uf~!u%$ "PufP 
t	 R|]MS?e [ 6[ QCP
[}ߺ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>Yr#2].^.@N>Fr=.6l_mrDP[	  {tr@  ^.QPpP f T G@  >i
 rG@  /h !0
 G W'r{W
fv`GG ~r u6ЬП.O>
 rGG s'~td r#G  |6f}bMQ}~r0fu!`A~Fue`f10^<1pkY!\/U[[P'0	Y r'%3]pp@b ^ B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}r^ؒ0	^}`~{r s
]usB}u P?XYR
 &ies_/numb~ PQc bS6{P g t"@Qz6z.^W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  vzz{wukG>!t {6oRz M27`Az108J 
G6>}zfG螑tk{[9zGz:.
~z]"z4c{"=-8E 6	7 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUА kt`@.b 6ͷPpEr^w
f[Gff.!!^ At`	PRB ^Owf`fm3
G
GcH?^]_^dW؍ 
2; @ T_oS
Hg7 sI &Q AAAr<s8f f
up^c0Soft=jnovailq..
aGwfw
`VVQ@ u
D- u+@T rp] u62iwP>&	 EXOAM!~vAV6@
 A5|t/fTfpdc[./_D.kGIu^`!4.Da9O`u.S`f)_a-_a` &	>!VWQ- Y^_.^@aPPR^ !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^An$ ù p    \ PQ1.E`..{F`ô rGGA`wr8k ~5`f}u`uup~MuvOOF9zA:A0 r,P;A5`pvt"	r=`wvr
l1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    Qut+xt`C 8utw Du߂    u  +3R0E`F`fA`!  [s02!^s] E!t?.. ȰV ঀ;t  E

`t#C vu0<ro!
 12Ui^Nx ~@v r^aA`+
us>srvrs9s.,!, ssB;Vr'swAɡ`L ]rߴr6Pr$ @$rP{X" i . 
 A`zsuzisu#P# f֐"Ћ޴ ui
@)@"<#f.# #֐v` !vf :Ц3Sp/"f2bZ{p-_.9ud@VW/`u^/_ ptR-)w.#
t0 +Y0#p"#"E..VW."Oqp 
f=8s6q0<qr@Ӎ6E$p  >#o0!.#pLr.	qCkr!
VA4s: m|0;q$$E@0 ."  %?="/_pq'oߍqo opW> %Xq_rh߀< u
Pp PtQjrpψ1@+rp6%VoGf." $P$r胿p" .s{9ojp|}6o8=oC*yo oRpHdFouat physical addre_ss  N fpC ðSms`rkPI_,tB0xBls` u2 `u6;&nn07!q~noV&U>~ o {+@MemocompsuccpfulpW/'@9	x``>ף&?|F K*Puf6'ϵm]b>`+nf@O}mD`maQ1`	#|!!`mnlt `fHt2}.'Qr8HtgIt[ntYrTK. LU>eAJx1/P6|` r`sUuI3ɍ>`/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wt(lr%lFm@^~0N^ 
\Q&dmtvv rqBBEmtT rp+9rFB"ym<Lu4Fwm"d r`adv.?*#tud0~]SWf.>r<:ufF	[nrfF>	 r[SRir$lr%} u   
fnrZ[s   >lr<*r>*!Ds<$ 0t`.R^j6VV.0 4*=B* ku  тKa.B*?ޢr`0*wH4* l02kBr&`j r..*.5
8q>*#R9 	v~g	P`;D*zFp !8*PF* sQжec`c||*|qgF!
Hh>J*~.6H*@G@J* yaDH*@F*.4`98*w
.B*PD*oN@qws2Dt@Pp1`  .};uf.;u>-߃(swh.Af,  5p مq	tPuI` 9t3..>l 
uh. lV~	dhm '''"~ "

I`P.;K`t2IK`fCQ @c3Ú;	!>Sq@K`.,6S`%3@(.,@~R^FkXPW\@J  aCPU Time Stamp display= Speed= Must set sA to enable tsrhtJjr@de=@h.vVhuʨ^&>rN _<uFv%0.f2.^0-f. g6-fQv3?sggR"
c ter =   uSec	gt
ir!6.ECx!1.1fÍ>`gtG
SrS 
<t.p&`~gt#>/r/.`< uhgt">r.`Z
u
#l&W{
*Targpis@rt . R  manually if fails 6i/}eq9P=died^V6WeiF auЗP65e6.e ^D!e PQW> Ue>U gg_YX|ft2,r05 papPnr.p Gfu.  .D;& $Ahr 2w,<r(.y됲 #rCF YXA*	_ @p>&
蝿dw@zibu	1PhWi.Àr p#rTR.D V hRQh_NdS4jXoh0x I vIKJV  @OAL"q$ecYQ*h 1h
`Pcɝ
q.LO
(g.
`0U+g``	dy'g0
  &}[Eø s[>`tFr6`>jrG          ??? fRfVfWfU֡a2@b6m222o0 's 6c3>2e͸2Qɺ2 +C԰ͺ?2Хһ2 uj.2amaк2a ݯawb.2qa
 .+ s`@Ub6p`Qe+Ȓ>p2`$9bbZ
!Ҡf!2f]f_f^fZ*02 3<dDgw,d P$<&Xu
 $	,<w .	272N.2Q`J<uFN$<t
`RÃ? t#;Ot끽YQRWSVwd^C2.;~0t
|/2 >22։EG.2.2fEfG 2E
G
.2f$ r-/te   @ -@.2 tP=? @ ?Xth5P[G_ZYrepe  ` np VW>#3 tPo5c5ycqc6 z& 2 2ѣ>2}p	, 5' #X	&M';c_^ cER}6PfPǋfEEE
EEfpHQVW0G"u-6jS@0t6S 6!TuC_^Y[VW02
 `F
  fPf$FfX o l2 EA@ ; fQfPD$ us+ؠ% si}
uFD4/ E}t#uS uN@fD'  620( iQu K
Au#*
p	rg`1g
 /u,	 ߾1q/, fXfp5 !Asps0Y+5 <蜽 7`Ռbga5rӇq_ie@ aȋ`o$s"s1fEZ0!`D1S
Æ	!fo+B>sQ@"@*#@%>dޠD@@ᾁRS`rfe  #wbV+?^	sFN+R!%Dp	D
9MRu
HaI I7`&!5 6^<;us
(رN3AaNs@OA
Na裹 Q5Q5XQ"3"+ɶ8Qs
1oD1 F$)-R&d
*fs.:a	qmncVt@;f%$Pr
蓽.@qFbb$)7+ɠwPH_+KgD5VF`^q65PKAj5FFo<^P9d)?w76sP9N; ސnV@Ai8sR176sA묂N1*B<p fgF^Ë @t@t@ܼ$#7!/Bw)|CP{u
<s
>`uF@F2	E TE̼DDˢd%=upb5AIaR-df$0	К(=(t`o	
v+Ұ=uruQ2$rStY0< 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`qC|0^ e2fedwcD'dS 
pedQeb41>"
S~0 : `ka[X449Bnp^@2G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrte{F@0r?gOCf_2`0#escsssdsfs_gsfWP? vyB6X
6TA]qAAܕ ݳ@tޙD ߌ  + *2+*4+*8+f5c|-u sMȁU|Єu@ftsPørcp d
q t ?P~a slc#fEst a1u`6`%["	
 Kѧ]&rbpBb
Fbx+si *` d` p p P" MASAYA_AeAhAkAnA uAcA sE
WV6qAg4FW^_W t 	p!	
  	M
fw_ord db q tbyte AAAAA" Q ptry  WV.t"Ü6B:s6B,6B&ps#! BpR6W6B_?.W^P2 fXPľBXP $0<9~Farb !Ò  s봰+   1$ פ s뀐e+s-!sfR8    R8 `}9@  c      re d  (    $  ' R( r, / 0 4 $7 %8 < 4? 3	 @ R/ H  P0dX ` R'?a  b R69@ c Rg> h ; i R<` l  S !m  n 	eo p Sc9rq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 YIS
8&8 ` f l (0 8  LS%  Q   VSr/  p:     ZS00'8 0n= ^#2  bS>, f  jS:Q+ oe tS#, z  us 33  ׹;99   S%<3    4   u   e 
  H:\
8 S8 Ķ ȶf (v8# _ S:rð T t  ]#81 S;9 %˰ t/ SBFͲ b8w  % T98
,
 
b


r
QL T5??   ,Fw T5  w !e &  +T;Z .  (#  2%T  )`$ f;B` } 6	  ;  Ae F Jc87r NT޲c8R  Vf(R0ZV8^s0ZcEw g k	w oU
 s w0^D8j}S jSY>c 28(2Te0@9 {T>s  (V> ;u ztn TPb    e ' V 	  `d$ T$=  re   E Tܐj	   ݱe @ WA  B eC D E "uF )%G 0H 6I <5J CK IL PEM VN ]	O dT
8 T>8( 0f8Te W  E|e y5 y  yd y$ y yt y$I y y y4 y y$ yD y y	 yT
3 
1 
2 u0 $8 T	? ȵ  e   u %   5  w UD 
 w e   Wc8 j  r< ! $e  E U9  8#E(wrW -02 7v m;&@ E JvO& S(Xɧ]Ueb gflmqvv{&뉆쏶6mF	V
¶fm

v&660S
 es "f(.5uVr|<VrB@ EdJV8 NVUsf(U 0[f8cjp t`z 7 50툶 8۾(<V8w8E   (f08t
VуȬ ؅ྲྀs'8 $ $`$0 $ 0& ˶ f%ڻ% %08  `8  f!  CC%D\DEFiGHadd push pop or adc sbb and daa sub ss x cmp s inc decaa bouParpl imuP nsbQ  out a  jo jn@ cp @ z @ be ja jjp0@ l jglg test xchg mov lea n cbw cwd call_ waitf/f sa lQ 0ss stos/ lod cP
bbb b rol@ r rc cr shil@  a@et`ente"f`tA o iave`md x;la@oop q c xzQ jlockpn}ea e hltP=c t ne div iQ clVtc i
i d@d"xzxW lf0gpsPl@`hrd bsf@ r btr0 sp  c i 
x!seP 0 P b zbb p""epprb F`et gpUr 	l	diQ }l msw l`Usssss	verR w f fchs fkabP t "fxofld1Q l2q e1piBg2nr z f2xmyl2x fptan` as r}extrac
.s0
f`/ ]psqrs01^%frndq f &+q
ucompPendisn0	clein+!fQTf /esc
env
cst   fre0Q /r(Afb
ibC

;  ?	A	 r=fi2a (~ wbinv%wa ::ob @? 6 s zs 0@F:@s s AlBA CgQIA 8@=puid rdm-rdp 4rdt`rsm u_d2 wrxO .  f  yz` {|}F}.sx33~	t.dG
{U.
EaF,(-)*d.V)PS [XFe$U<v$tU	&;$!!{w'E t$$$I4芥"轘$Q(',fU$-

}E%$0_c<5r1<" t3"${v74&)6+t06-U0E#3$6Q9uF;m>'A0Dt+=Fw&_<JF8L?Nt!@PE,S<$VuBXU&[UD]` b,cf1i*lވ
nޕ+q#*vu
UJxL%{E}G/{'0߅#dP}POOQߌIϐ$ToT<(YUWeCC'jIC<U&@'tN^{86tH`߾&@  6W f3 t3Vv^
ꖿs rP %p R R  A
     <   P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vFt  /֐ 0wQ Zw;Px\@by        lD` q	                                                                JDBEXEPTNŠDBWAITCMRDCPUREG(^6RDwDBG r^SwCTR ^^MEMBUF)_ɠ CMRSP`IO?PORT5`aT ISPTEXTd̮/INSTCODEI`*	SMMG^dESETARGЦ/0UMEޣwWRWRQ
/`]{RQ	A`^WR 2Ds`/1]{WRy	 	T Tp  !!EOP
                                                                < VWσ    -$  rtˌȎ  v$.UpfP.>Ap uWP.^Gp f3.UpW.H@ I O UM N@EB}C ^.@ W^   ApXfX`fSRoP.Bp3ug u_tT.Tp$ ^t?$.^ 0r'pEpD 4#r	
XZfy[`Mp0Np PS tatCu?L7hc t-u$ظP hh Lpr 	uI[Xˠ}C'Pe
.>^ t
P ZXPw Xr$$
0
^^5 _r?_x   hP~ Γ	ruX0rPhBfP f"wC 
 f.|p!VQ6'f6e  Y^PSQfR_V0*U0*,&\f&Tf	 ^fZY[XP3ێϹ  s ˜W0   # Uq	t a*u'W 4,4^ u.>. u.8 t.9  g JPqGp } y}rsng#c\XQM}F3B;	70,%C
!}S
 f`B* >(^6.>^0A6f.R^6D.V^ffX QZ^ Пfj / 
uf.R^>r^>^^)1 ^ p Z^ P3r^# v Ȫ z Ѐ~!f%#6 .,^.>>^66
0 6.ffaJ f)!f%@UPJR1f{-pTf  K 0UP
_.QpX`0^fZtV
^0T <^f%'f
  TPV!	.Qp~w

.+RR
.^.GPW^S >^^ 0 MSZ.&Z^Q< .Gpu
@_e!QJu)``EKX!a @aI	`b  .S	k!k@%"k
kf8.6V^.6I`wf#RAK`f6O`f3ffS`kArkM3$tA^`.u	DVQ
6ed dTpt	6eU j j} 4
tY=).V0#g&;B*R^'Z^=u EVW>d!bk& _^FVW +>`Pdr6`>_^HPx pfLfVfWw>p64l /t 3ҋ? f1@
ߋG` 
t O
twQ	= ? _ 68) <R 5se>puf_fq&Yp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>l@
>lǿ  u
lr3- w|_HroQO
8rK<?prDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3`w-.-_nB6/`A)_A/_"G2k-YE.p"PG>qmBHr
x6ta >|`.s`<u=0>` <u  <u}0Pvr).ka>PNÀs`~s`DQ` w?Q%B>@
 Q0s`?^P2>`BkYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i} f.;i}w- AZ r%&Q0PPY tfGɰ
>A_W r,f 2mWT)bd@ r@f؀ffFgfd# 
 '.႐S3a `t
.~݌ffVpzxpvp"  u7 $P.~$qQnfU.E`.9`.w.F .:`0kG`;5A1>5`ŋf  t265` uuuf0=/Rk@f]anQn90P:`P;`65`1.=`Q[ fDJR RQ T
T

 ZW Z\$=
fX ZsSf3[ff$P  fff'f%$pߋ'RC%  ffC*** Please restart the system manually.
 .`<t$
  
$!$W$0AD?Ok2撰撍6ŀҘ2ҘӯPu@> ݚQ1Q ػf?tuPRPǟ^ ү ntJpfpa p6Tf W^FpOpPptO@X >TYßYfPQUGPF >J~Mu
,2 6  PpOpX]0qUf ]Qσ0ϐ^@Gbؾff&pf&  G>^ fG`GQaQ6^VfWf>f!_f!Q С ffD4$fOЬV 6ҧffP ȡ r ஀hr$Ph X[õ ރ3@$<sAl r.ˠUrOp ` ԣA (tD_rq XPנ"Q!f0ѣ!ES  gf /tu}
> up[P}& / cB`&Xq!g= BxxwB 86{yx@ ߀ #                                                                                                                                 S .2ℷ[S[W>  t> _`W} v	0EAC r3ۉe_`?2St]AM][Q_ϔ &
`9P
PR鮐<w. [SrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hbar1TaP<u< <up. .:.~p .c>`2p .?>b:P	wd.e> e,@p ˀu 8rۊ fg[ø0
.a.&bp1p.mX@E2@g.*f v&.f&˸ Laap7^*c.C3`0b  ϊŴ* # PQW`
 _YXR.iߎ
 Z k@@ZÆ;BB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x߻<Cwp.qu#rp t
ArZwG Z}YS2
d0 PR7 r  dI r`.pr`@ d`QR	 .p`qQ
t
QhEYus33`8u" f`Ph @F F@ &} tC t;k߹0Tta30h &R<&E pظ@ P ^ X Wu-  ap;PfatQ@  YeQRW.. {w#&.!
tff./.A_0Yu..nf. cQ󞙚R'@lmcǏڏː{?Qvڢdߢ1>+ r.W觳  cPPJ <t<t<
)SQVWێÍ-<t<wPXrs<v\.> &_[^Yy3	0		Q z@~Y!<8t	 `<P_Vt=EIAc
<
t0FXAP QpRt @Q$0<:|u꾐FP ff Pff?XV	 Xi
Pj}^Vf3
f^  Z  f`
Qf
*  >"Orf0f3ftY "++x fa
߰
E    1C< tN< XÀ Ttu7A!Vu`U<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ _!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4_ _P&mϕOIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYf% r?}sP r
<:uft_Wf33ɋ1 r	f
؟ANp:~  uf3w0<fw,W<Fw<A 70,0Ü@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	}A
Nt<Yt
<NtNP3t8tNXPL9p*HHHì
uÊG O?À=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Y#)Y+PT P G WIN @BDF8U$<w%.JGu0
t;wP
Ȱ
 3]8QW C  1 [n6f.Ƿ)ۻ0IQjY f.>)R[ 8svp $h 'Qv t?7H485 26_r SHz ueaJ2  UuQK7|e	$ <C} EuA{m"' ;l  Xc3PQfR1[3 Bf>@Q AB CPDöހQ@RmSABC DpPOP R S~ c?[ QSWP).X. uF0	P2" <r<w,@.``  .>
  <  <;u@À
s b$ b ,0 Pq͏
 Y.l<?uf. &[u
f.&)R<[ ]Orp^?pu18x f;tuG2p _1Sf鲝a u<] Pɰf   `4gB00t  t tw !Ѵrer> ZfAA Uta	$`<`ut
*B5
u0
t		 u
l. + ( @
r?.

ZE"R@r r}0MpdZrЂB B|U
|a" r"<۰ tP w  "
 B$<  wuS0p@ "8t2kTuNuF;J t>/ @ u.SutΑյ "1ֶ
 " hZv.'u ˟                              |x KJII`BC8uĀuBJu*@u
Dgٻ0/JQL @tgB/AJJ] 7솀HĴJ!R:_$ su#@G@6J B3tB  DECB@CЭZNpBD r0`1	$ D[m rPf j qbA$<+`mb+
cJ$<u	f  rZPpc\ ?B읱[ hԓ:I:s r p 
 R  O O 	  ߝ h=r@῀ h>rA6BȎ؎zYӋhݤ3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu%	  	6r]dt 2
#
C2
EG2
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$fQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_P 4Jvb6Wl_=8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch i j b c ac_` a d    <    0F00	rvY	h
`a;@;Wff . ip
蕠 EϊfQff
f aVWIB,S@*(_W赢s;_t[s)`)FO[_^aW>f` f wsup7fffGofY܂ho S1Xfߊ$
)ff  A	S22+?Qr'~!% uf 8s֊ҊʠXQ<RP
_t0_r#YPY  uf auTf|UPfPfXZ+ ]f0*ff]rffm`f#n {= srscB
Cb誾_ 1?f^ ɉ߃w @tr;x }*f@Jkw  C)ѓu6ѪȢ+f;q%N?f fBsg  uV0^Íp.RfJyZRUQf fuffVfKr=XfuNVFYZu F1LMuY ^Y]Pg>!f0sRg'QSVfNVFfL~ {^[YrfqXftA3PXQM購} N Ow蛂PRA` X{PiWU豐Ԁ_PԀ̡ A1\е 謱 m]eXÀ-pߋ_P^Z`W f} mp_p0                                                                             8o%  @8sUv V ufu`vQ2=fA<t1 u!ϱ n #r.V sfYZ]fTf{;Pf;fZWf!r@mrf+Br
c`|s
wua

<1GM	jrrBanP蜗XPQqr Pp$SOs[OBMIE{/{J8O 0p`XE)t fat/+f %#fSfQ< t1FQ2" aҥUt?$7 3#t`c֦i0
ð-@_ȯWV@ ~WB Q Y_W
t^9lnst6]V! <5u G	F^B^= ts.
<5 = 
u>9r  Xf[2P
X^#WfVf桕0t
P E3r&< u P B S f^cô PXs #̊#$$¥}$PRt
u $ސQ C'ð) 1U
 ? 2$
Ǌ4D O $ $
utzpS  Y uðQ3)3zð&pFa
!tt	*tEPPQPS&P"
P[PP <t<!t
<P	<*^Rp`@ ZQRs	 2
 Z3) ӻVP֎ލvS<û	 [rqkX2A^a
 ð!R7 $VfW7 u؃ t迦r
sDp<A) @i2@e^PD3qK|
u|	 P!t0  $<<q<
Av^ÀlO" iOxO ؊% ȑ؋ *0Uu Xð2HQVWP 
K0X_^YaQqKpUP2b 2LB2`|ʁChY
P['/#f@1POðWB12~	RkN@1l (S)_ðT)ՠ Y"5@Z5. Qb	U27
ÿ.PfUfQn`fVaOrMfXfQ gf@ Nm V F`(gUf ff"f0}f@MufY(A#f]Ë{< 3+fQSfVffLfTfDf1oOf^[fYr!X	AXuf JOÁCp 0<O,R
WfPdO;Nt3  fRfZPOP_f] ^YPfW)O tMtQDUP/XY f@P_ YXt
 t$MtI  v nN@X(RfVt `9(7VSQWfw#t їr@?d$r	`@* _Y[f^/QWV<wy^_YSQV3۬
Ê^Y[S {{ e    rV1fffa.6.fff;w	rf;w@0S.- "  u f%31/aBRJ@u$ Ċ Ċذ1J0J= <r <3@Ȁf
ffʝpff   f-   fPSQRW >E謘3&G;r_ZY[Xc%aTU  S A t	_t0Q`/f0  f@@u$@f U4Z4f4f p0pg&>tq r 	r
  u f_ ~@ gf&^P$f tt,$
g&"Fg&
FPI*$
g&#Fg&FJ	fN#F	Pfa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`
t~g&`
g&@
p
 
u
g&u 	TA1P a3Rf`\&^q\QU1SLSLJ ?"C"R"X"j"p";  ""#?"(#####aD$;"%&%&WqK.}@.:8!tL u% 9!t>JrS[t L.[u :!t0;!t_M_EfUv"v t Ar MG Q!PXߋF
 Yh@ &A ϴjw@!
t0ʹ \r\V
	=VL@!.6<!# >!.`<.I.
Lj@s&  |0u p^SV#؁D.d.$ʋд^[:	ã3j0rcOt` 	OtOtLtDSLt
qLteLt_Ls<

>1;!u	Q.<S.}h $ BUu	UǪp fR~#G rp
\ZU 7fP<r|wfa u
 rup^i qWUuP؎&Br& ȎXLߋJ!,SL><!H ..>>!N@0OL!Pa 3PB &Gݾ&G $ $PC &I`(US`*B>F &g0&G1&O2$ 2&G~AX][&?0wa s@ `b 
 @!@nEGfE  ~AD!ff@ 3SRWPN޲ ݱra9!Ec+eLuRE<sfQ@M}3  />LL.  EGώ ﯕ./17P[Üݕ_Z[Ў.>9!u4`G uFr=讕.EP .&L>J@A%50)c~ @َɎٍ6߫L 1SRt5ێË`S.q&Gf.Lf&_f&_ - Y2 (Z[fUвBSsQS1Df]à`S[PS3#[
'XaRsɄ3Cr`BC3t  ҊCfPAMuS쀎VWИ л P u
_ 
p  t 	˻ʆ ^Crr ɍv蘜F0 &o O 
R0&Oˁ`FUWnQ)_]?v
P` ]_{^` 1
Iyp b MB  $, D `,&= @
,&FGv u-v +-p cu#' /. .&` 
;uibo.f3ɐНpu /Q/&`(*GF< u  u2D@ sN~So[=Nu^u裾t

qAϴf˰ h fPf8h  `  f < Hn  $p0η| fl f
Zā [5f 0% ;tf ff  f`q_fYR?fx R̀p5Zr`PXfñd``d f@un
f<?~fqPSef%E0

 `DpB_:B3E=A19!nd`fft" QBY ffhfaWfbӿ0f3f  tf Ou_Wyr}yAtp@12g@c@R?rQA=L B = 8 3 . ) $     10_Q?&GYÀ'^dǹðd jL-Q-,@ -q s- y-0 -P  -a `.& @ . .	 . @ .Q E/Q / / @ /
 /G %0G l0 0   0u 	=1Hewlett-Packard 68DTA Ver. F.09 06/0 2005 ]  Z  l ~]q oKBC
sion XX.XX
 
  _ 	o~A`# P` @  A U10 Intel(R)  @rnal L1 Cachea bi2e	
   6PC CARD-Slot L
 `M	 www.hp.com  ;
 `   
 


  DIMM #1('28"\
a~K"Rpb Ne酃"{@],N_o bat y'+"
/s_&$W1 _T*u	 0r
yjt)Ӏut& 5& A)߀u&uu#
u! À8W|@`_ AU RtY pvMuG	0bu< u3uOQtru1 tWa0> S:u@[8*6R:EFu %E0 }\QtTt̀t߀EtH7ݚ1 F )t%> t:& tSuE%u?3  wt E>I q u	PXuP3 toX,tS%y)E wutT0#)	&2!qP=E0*x3;r.Dv+W+Xu432#*u!.ð-ܐ*1!	 2<Gr<Svƀ Ê,G.#/]C%J u$
<.r!Lu24$`.,2K#/?rPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10Ü   EAX= EBQ Cj D P@SI Q S CS= D@ E S I1xcept1t4 - Overflow!5Bounds Check6@Invalid Opcode7 Device N hAvailablJ8Aou` Fault9Pu Reserved	10TSS1SegmentPr n12JAtЏ V
3Gener`xProtecErrorq  1 =  System Ha!P$

-XÜPR\$<w tZ fVfR64Fup4诇/vzo5`cP-5Yύ64{4t Í64j~A64` {/4T ō64J64APǿ647XY_WQP64$Q4Q4p4
646"6F
0Q5_tm5]&5_x5nap5WJ5o@b, [Q KG ; 1`(0~X[mS	 66? p C8BBaa`a$at@0 DFfFɷ͋N
~fE F Nu3 'ȷn ]
 cRQP~
XÊܹ /FFYNZ1A`QȴjY`Њ  aÇ鋿ً`ܾ9"ԃ`㾯9 & G9 .&8'@'dQRp Z
  c Z 
XYZð
< 
7 SQR  ZY[S r  `؋  p 9 ^~   Q!
 	`tta@ ؀ `
UЋ؎ o]`a	]3G
AF `P CY0[ߊ@q$9SRZ[` $<u 3 0   fa3S ]Q VQ=3AUAY^` 
aËf3RQ3ɋff tfaf3fRAыf;v+R'TYߋX0P@YP\UfWf&и`1fW]f_ff_]p_8f <u迂 ~<  u<  l<c<@%Z<	;Q<
`QH<~i?<6<
-P= uX<`<~<pXL]WfPCI 2\:u_fQfRVWfSt$ѻ"r   f;ttN紃 f[_^fZfYffr_ }  {u
N`ݬo蝩  `藩 s r 2fSRfPmȝfXZf[N/ff\FZ5	vf s"s t s t QVW&= & s fPf&EffX R ^ _^YaJVWPwR`;t
X2 *W 
_ ϰ#tX _^!DNp sP6уufQ fPf)'f8 P8s2fYZf`ffWgfǃ#Eg ٠@ܺzA vT2gfgƃg u	f@w1  f@f@f_gf1 gffgf0	a	fQ@;gg&fGfXf7E;wf+f@F+f7gHggfb	f0I#fgf?&fa
Wt@@P	3
Ly
ff0
gf3  P
@Cr@
A
@  gf3fSۓ̓ wff#b ffyZ?'wf3f30n,o;w+#4ܼbf[gfo p2
f'fP	c	
퉄
fAAXAP3
 #W!fكs À +SfVQp g46fFCYQ  Y`@.f^\ g&ހGCffT,[(PS]&"
d&[X0QP]a@^Y`xuWt=u_
f&e&f&e&20%%%軟a VR
txSR ڊZ[  Z[K0xu?{phRȠ%%t% S0
ud=CZ^`u=ʔu}8qB 
ً@p 2> 0URLu<u7Gt)裞蜞tڱ

Z]PGbXU 
 s ]`K:\KxSYyP|M M>r}Q4Ys\ P] 3Z[x0"$߻yP3
ݸH 臝ٸG S QL bQK ZS
 pN @qM 8#Ec'
(<PdE,FtFFFF.G{GP&` XW<rBǱn .E_Swt 
' t r
2[e iu0^r!<u	rr& _  Qs" r2.E2& r $pƀs  r  9q	8 r 	&& rr	PցôSs+&' @>'  sa$sQ
u>[ Wr%p$S r rq	A9 f" ?$ pQ@	Pm pX u#t s@tQadtpbpt t?
@uఽY `
@Xr`QPPPt6QXdYQP%Q0 t	` QXd$!<!tPPP  q&@tPG]Xٻ` (`<u
 @&   >!@tA AuqPF @  ,8 & XV߁  0`O  r
 P<Fu u_s	 	uA
 fu	 X RtGTtu`6FtEuUrPRtKxGr t& 0R] Z| &Duh8 [ hЃ 
Xuhd:rX&  U @uW@ ϡt@Q!	 r0 r
Crr蓖 ﰭd0P迕 dx P$& 8t   0zQX uSQ^ `b+NH `*C: E8g01Y  @Ϩ@X@3ہNC*Y𰴠 Q 0 " p	@C  0lFpoypOIEMAG  IZ P    	
  `# HDA-L  HDBs A-E r Cu 0USoB-FLr CD Hs LS Intonl  -As B C  % eO   H	P 	/` <M L` ;c!&LF3	@L K ?LCD001EL TORITO SPECIFICATION &NMMM " * Gxx  x y 1 " *
x"x 0/   s w_X _y\[8y y P\b é uT ËEtذE
U ʡt
rS0 t
rðÀxf`!i2tW & d_&߈E3@tB&U
&]@ &EL t û,N_Au0_&E@ !tu` @ @,B C 1OOO P'PO#Og]m tg}
3lgE
N uNl 3    SQ>u5Pô % r!<3ɸ  3 3Y[SRVSl&TlXwt觯t#術 蔯>k@<t<tƝ< t }3^Zf[fX_V? 5}u P	oir
- ZQP =@ac
uk2ykgu
#p d,P fdfBd@!+ s dMd5 d	 J Vd,dP <d;]ttd|d]^  R 3
' ' _FǠ  F/P3 .;v+GuBG
`F/ {@8% O	pXvNuQ
 	0ʕ NY%'
r0123456789ABCDEFS ۻQ׿[&T$PIR   ? A@Ui j b c V` a @Wl       05\#003zrq	_h
`3. W`:p
9_ῒ/
p aVW RS;tRt[1҃
D[{_^@RW3`  Q|up t`GYh Z/$_ZSQV.R A6 R.R^Y[X.U uP`\Xd]<t3 r
tVd4d?8D^u쑹RWu'Es T^u籼 
p`|3&
yt,ـ@
t&M1&G&ayg{gngLAAAPga+Íu 2<ytȃt
 Q ܈$FKuðWQ
u	Y;Y_uS؀uppu)4e  [  `[&f߿$f
f Р]RWS22f0!r Hu :8s܊[_ZZfQWRfP
t)0Kr Nff  u 8ufXZ_fYPg rp3r: t+a4 v 
t38t	
uY0	g&;t4g&Ct,g&Cf4C<vwf f٠
t
g&:#tfC1	fSfWfVf޴r7fg&F 	f`r!f`Gag&O@` Nb O f^f_f[ò2p n_ l C  Ơ # P)Ȱ"2!ð
%,p p$ztø
 а	2s s	2  |0{ 	 Հk{2p2 	iÀSN:4OHA
,$ 
3$0 zB	$2
òVVV
WMWWWX.Kt'} 蚊<u 2蟊hݰsh*;bWm1qsqsxw{csPPRqs
2  憚"r  |  {i`W.D.D
~ ``ЊX&&D aø0 м [j &&E  ډ3Կ{1ȟQPTP !1XY`.\.T	ώǍ>.ߋL` `rba.D`pbaQPƌМPXXɎ6ay
`q u #  $t$?aQdh@ & r 3ua.Ya3d' $< u@hL;I<u	.Y u< 2$\   tu}_u	V $
4 !d`kS@@_ u7` $<uݳS[S UNNN_O Oط0tߴ$#rc#jU fJ,M&ON#óf0 dâf>uf   > t&r_VuS0`RRWЏff+ `Qf׸@jYrfǳQ	R^fdaW>uIf s@m
f׋6ǁ0 utrrD>_ S0W]!X7]\\\  Mߣ G@0_" *00e0q|p|@AbcU]@Ӱ U"BzãJRQ%̺쀧Y U N Z v]  u(<sW.]_.0"2P0=wXs}ĴQ] \u..&+.	p]@ t^Pt.&u @ u42..
t wPUU* *Ġ&u XY`-3P A3.G
XP;] *.(]rWȎ]	]_Q  _1_Y_____________VS3.:^u.^K@[^* UF~P_2SF۹ S.^F[wC N[QF ?t^sF2~ tY@7 _`  _ ø8o ^dW`d9VAo;`04u9 3`g9$ $ð``````aa`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233p`f>"  tA" P a2ۊ( p ) ǊȊ&)  * 븊-* >+#1 d>,0.- &)O r.PR u,t;60n6 6 3
t,=

"=
 
0I5w<t<u FÀ t< 0 Ps
& 
<uaw\wWQu& ` ud7`!Av &
Ø;Y6 FF;t2 cbbbS  2 Ya\"c`  \0ba3ac] daR]D]E]xpj`[\!\{y\\ \+t\ I|\Z[ ZZ g}
3gE
 t"6KD  [gu0ENusU I~2qKK  
$4c&E
E   Fj	t>]>
SQfpVF! zs^(2۹  PF  +^D!8u _#Nf^WVQCuKET! ذӸ!0w $I^:u:\!u rYp Y[_SdqK.`h045@p |Eu 0$
h`&taRHP^>faRМFt@9$t, ;0Z1Q)Fк  #й$SQNB<tt	fP P B n YP?&5Xp+eq"YQu `Y<u,fCISGu%f» f f f .>e .eQSWf@/ r)vq!ufPs ~tā_[ЮSf<t;f3fԀ t	f փ 
ut߳f {fq `
 3躱afPӗ f0#g#/}#(P$#.C"$$:C"YVS"#4"
5"!^ZR!'!!)}$ $pڳfaZ"!fPS `{@f.gxhO[
;.gf`uhc uhaúB   $.g>u0,RVP
ۃx 拔 tcPtt>@ KXSx$PwXr$0Qu!$
BB T0JJq4HX^`Ͽp$ q9  3Ҵ )./@32ƀnuo nbp'B<| 0=p   I/uﴀ  S3ێr?4t WQ >jfi1~Q_QuXûuTf`0D offt;  Qf3Y_,65 !? kW <ðɆt w ZYJBR"<t$pAJBqupvBfUfPP@BXZ+ f]Afŝf]rPmn跐  _SYSID_  k _UU  `1g ki &  d
fd@0aÏTƿTTT	  " py fl f@f=  uOp fl =                                                                                                                                                                                                                                                                                                                             <   
    S    -%  DX' p J݁2L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.aKZr# Mu 6Jr pt 2rX~	 u v thr&3&E0r" r2vRs ÆUu
FUF ô蛇	 -q`	 ӥ/2	r蟥@e		p脀'^F&?s  s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	ffPEEUabgVfQSjf[fA1fY^f& u#f&GP Wf   4WfZsfXP'F#~r .>9!t7 : /{r?`. t8 8! t t ; 2SrV ʀs`,iK	p aK~wt$` t u/~߉~ %"NV v1	s^Í6L.|uL>R..eK`>J .:UtaiKaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w)[Y_0? tl>ـ?r.u|
Պ  ʋ.E;v j'fVfv`$dǋD @؊f
@NP.eXfa ȋ¾P	rs$
2

ў	fX!9
dwDfUv]f^PRB@    ZXRPXuUW:>_]s*r  ZP$< - r!P@Xup>轝q @{<@0P  *sXXty>Wc * BQ	?Q	 QV  PRW> P߸@   XFrr#r^rT:rOt :DvL*D f umfm4
u
rPbl
u2 VWrd ?_^ q QP&:Ev&wM!&*E9TaVBoCo<@,rFAnr;A?@uQBu< r
tr&tptu
ZB\r rR$!Xt24 uu@uu`  uﴻ2&fPS `00v[fXPSps?Kp`D
>X`?D<PƋ4a`t a1t!$!ߡ"q1&2PQȎ`SJr#SMwO "t 
`P2:Tt
a YXÀuOuQ,f9a"   <s& ? `P93 >L}uǀ   Kt| KqKVW_<uW<
uu{8!F; ><@g2<t.$S[M[|u|
`g|`it\_^FS~`}
u}	 !.mKb܀}@a`pO1uD}a1 #%D0QV 3۬+^YD$f郃fA~ff?ffJf\c
bPZ#f F PXpZfP~Đ=r0&pw)Ewfpu fau}Cu~s3SV|t` t t
^[PfQ
 0 < @f	t` vaif`ffQfw i Б   fQHff#f+ִ f;wfg3g&Sg&c
uff+ffa1
fP4SR%Z=Q<o$ o P@AfppffXMRAZru>A4Zr
pf`P2ǜo4XZ[fW=t? u>
rrw`Ua `_B a p 0`cQSQVf᣻ՙfPh  ѥU@PPU  p^Y[+u(PUFP| ^	u<Vf
Eo ` QpLP	r=^ uS@]#^[u"T

 
 ^~u.t Uj@w`V	cL
 B8`.
u&* +uA·0$_<SfQfV Á=Ut<p*MPTh [ &Ep` `&ufރ1   \f^fYfkSUh &]S^ ] $!&&DDV& fȡA\AL
^r fWދDVЎ &0 f`t@i0Kʃ踯^0 ݤP P&t_ 'f=@4'+a¡f;M E p  Wf.͒`	Zg&G_ǃE!#3crYR-uPTPf.͒Q,f_utf`@]StQY fqK袮fpy,  !f vp9f# ,;1!U
UEG &E"rifa{Ñ 'rnOGw{|P_@0Ъ`Pm~ %؎`1#w0踊 \<t/Q 虊Y<pD%PH
f{u f _` ް?tY`v.M"fNf.͒gO
w -"|"#:OOPN9DQ:	: ; 0M;Q.:r(G)uyD > )uf.ߣ͒p ђ0- =*VQ$$D
@V&T<^30Dory9
l_Y^C0n ~u0x0"VBۣqEvf;@*(ADO9(8PVPWSPWQNP
P@EDLDra
fNt;2KWM T;0@-fP: M^_1PGTN?:ffWfQ(QtT=M
Pe@UBLOALBRL3S GG^WX!WXX1GWiG@0(WLؕWWìHP&	3
uO` gdOp%Obboؾ:!aQ	TQb`#SSlhS3Rq	)AUEfd#S`e_W3n `{Dks_qnhQhhRVhh/hxmO`pʐjљj|t= (Yj,{A
1$vpf[ jPQRG B㡟u PRQSط0$0<:rd uP P H . = r q& sVV迾: gfFtXRyZSt	tv
 vt[q ЍYӋh3 
 r
R3҄u  tZß@   D  N N SЍSsS U	 Y
 S wSSABC  ePP PQ SR  PS ST  PU PV PUWXYAZU[\1]^_  @c` Kca |cb cc 	dd!eqf uߗHkLYbH\Q
! YQ 8  ` PRS%` +ð ;w[ SRW*׿OзIr 2 3_Q,ԴAs9` Y r3O:3qRQWSP b	P+߁찂X Qt5Yl !`@ sX Jt	uRX( V_`m_ 7	XAP)[_YZà2<UuX
8
DYJ݊oBǃ  | brT
!3uP oP2
XS@
u	 ^ ت *êFpBVWQPvDt!WQ:t
Tu8v
Y_ԠY_XY_^ _SM_ P_DMI_ ,  #95  2XPUv F t	F !Ff@]X"X?
W8 Ѹ t"i &g +  pa
u
fN@  ]ϰ?2ðq  S\8&G &G G [ O!@   UQ@@\&׍\p F0 ]
..c3 и( и-  2P
C@@ XWP/<w3t u*p O $_9F& ._F@P LX23$391    mpR۳4!fβ ufQ8fYgBZfY[{<c3]Ou r 2fPS=Au@u;Áp u39 u+ f?wufP@u BXu
_ff``< t``%^{At{NZ)|S{_V k@Q  ~{{ o{KǠ !qO E{P A{]{Q   ABf{op9¢RfW. uwm03gff=SCAFtV1G tfff Wu_f(#3tfPf5fXZ2_32 p  
` tODu (s$
Q`,]a;ô%1´+'=faPKМ$Jt* u$t}0$< ȋKf`a
%D	׹$ %` +諹$衹fa rU<
%	*P' @[TO xOy^ ere$DIsL U]tf r.]ߡlݢ N|	r.f%f UCESsfq 3yTh pi1f!u%f#f  [sLr`p s` u `aW	ff#fl *;֊0l	rf p/Q<t2f3Cr6
+	f  u g> ttr(>2 t QY-^ftRE=4? 1t?t
$gr``fZ 8-t(r!1uP
J?葿t:R!4g&? t0c* QfR88t , tu
@u$o2(Hw)@t'W@u'-*߀tp(t
 !-  t> f= u2B[ 3q 
t@  t}[QvfXri/p/B/RZ/rGU/Z3tt@$
ðzð,$t  |nZ
fVQ! 0fF3?Yf^0IP_÷ ٳy*$?1@2fâ!÷@{G$
	 (  SfPF4fXం	ش  [fV~wW _ W
t<5t^ufr ീf^PrѕQRV3P'û  P FKt
` J8u^ZQfVWf 5  ÁfЎmuuD@_f^@uEuPPuWuZPPE EPP runtime BIOS - Version 1.1  
 ٧٨#Mréϩҩթ
wUd Pd]@Jw.Y	.Y r ^R.Y 
ZpQRӱPt<rt2[5$ԁ !Ȁp
 -w"  S`5	$ ~ pd 		uR &xuR|] SUUW.V1f	`&n ^COi CW	al? _Z0m
 JW sUpC1 SRB<3
 j ?G 
ty ).> . 
   3R3ɀuAB;$ԡ 3ZP1 ^4 yWb
/sNP^RWf;rf``' uus'1f qr({D<u`} up p fasUQpU@DF @ E] < t<t
  UqY{]Ѓ43O0bLv2~0q ^~qR0ɒRMprgf`	x }vt@- _ Zt5	[ ai0n9B]K^=s^ W "#@ cS@]sQ}Np 
 N3uk
PBxv`0af3g NrPo xtԳ$PPgfffmڠ ^o3&\fPQXYqo)YaP'уa`` koP!8a	]of<S`  u#fh!6o\`cA<oPofa@䠄t"
桰   Wu$! !?p &k Xa{{ݯ *qݱݰ J
s@P+FF
]X `j . pDv
)Mf.N. tI4~H@5p3؊^)tuw t&Du .⭋^^;SIa.@t&ڃã.^2Ȏڀ36t6^2. @ PSFg
t'.:t	tX.g_0``P赹
Xu!P<Xu @P蝁ta`
 PP?3@C3aP2Xr-s(@rH rr
 PRVvF\r:Gs5&DC Hrfڋy苡_֡FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u rcwu
	A	π&DB êĪǪAT~0	VcH UrpW蟁sʁu `-su fqt
E$՗Eab&G )
V oNh8Kr>u rG Po3F) r\ {r=H r8QWWss#

Rr
3 s@M1 |o#k F("r#謲Qlr@r?k20!0p0×!r"!F( Q'&d&K0#V&Ơf)&t N.rfPS^ۋ^&t` $ueG&uFtt0b](  м  pgG!a1Kr dt
t4t p掊Δ'%2撰PO W校F X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$߀`p¢F f%R$P[G ;B(FGq1ø fF" PXN8NwN 4o2N0(`00s?/ }mlpR
 r
fQ/mr{$+fY/+U+Ñ &u btb|@q? V/QB  BY^	G $s
3
P&u3`~ 0r
%u@,?àt <q6(V&T߀Еߠup 
* &u^  肂  _QPXu_N%&:L O* r$ P @uP<ut.@   ; E q2s2p$<@t22P !$!$qX{w [|[ĺ"~.Pù[K<P~  = sffP SQ  !BY[$p
Ff 
۰N8tSFt f% f @  t0    "   tz  t	@fX
`RV s Z!
J
8
o0
ҿ$g4 Nff`4eA fu4fafFD fP2f tfFP ǈ^DPm fu
fWzf=3#"fF$QiF,0 As{rBrf-1fv,v0h,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3fׁ1	f  N xfWր  pp#f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	넀ffvwAfI| )@HvHwf*ݸff
fA{N
Xf%	3G-WfA d!`
;Vt
fAP
Q
ĳ6"P  f%~" f%  @"	 "f'F0002F%R) !.PSQR30? RffJDfZY)PQRWSӶt"X  
N[_ZYXSc[  QW Ł@ __Y[pû z
  }5u
 @ @Üu[8 0  ;Pɩ1 F4;@H0P ߈>%F5 N0Mst(BR'9ETDHP  SIMPLOiMOTOROLAVPjVS\~ЎH<j 0P-ێs@^s˻ʆǭ >/n>/譐 / /~/@/nSR &
 3-&Z[>/﷥h/_/+T 0 t
@<~Ph+؋Òc/"@	/	/﷧`
/
/m>0m؎&3&M<St<Mt6 6{ 
6^VhOG l߬**0Z[0
,0R
k.0IP00@207p4m0.m40>60
80=0	l 8k:0 ?0A0@C0E0Z`XlX
X+ 
r)>%0&~X^ádWV-.GF< u^_J׺+rD.\J0ERǊUAZqER.Ȋ̱pMQRR ZR  ?ZYolôRu8AS؀u
RRp	[P PXE%
cE%	X< z$ZT
 
"
t`gVW_wZwU
uQ6rEt> r2
tC rͲ  r  ɻ
!    _^a1n2
u[#rVei1sCr"trS ';Wr6\"Q@
Er S֝)ܠ/Te  
 ` Pt ҮK;\	\*P')0\;#$ rIW("  k_!ڀP(͝B O55B< t%@r4;3r!- ,-Bq3D試@D`ó sGADw*VR@ ރ|   t.Z^8ħP .;BBBX$JJ2JBPܰ\tJ 䤊XuS` Gr V tA&q JZ  C@A 젒*݄uP= ]Xruŀ2	
 ` (8SQ2<

2ۆ.
$2rqd<w0
u@ð  ` 0    j3ɍ6K.Lu.:Ls&3.D}.L~s?` 2`r2`t 2߶ǁP߶q u K=^t
`3t t
t
u! 3ұ u I t>L.|` .L _u}߄ P ߴJ}uL   u3puwv`bW_tURQRUK2YZ6	u>^
 .D b+ t#VL^ 
.L ]ÅQ3| Ys. u&	 t	&Uu"r ώǍ> |  Êöi.f.|f@  3.|4߿\PQW 3K#_,`Kp1(q p;`3$߆ &?t+aP`)}
t 	
t>J .:UǀV tMRZ| $p$u$$<t} t	^^ Q3䆊!*Vh L| ^t
.uu
cs)t!JR0W۵u3ێێZ
t	'u
u
 Pp?u搉@s+XPt Vڰ`[z︝oht"Ĩ@t  p 
   XPJXS{Pc .+. s#. sXP,&   &X[ó5P϶'->@/HAC  I@ σD
 uj@ t%v v t ArMv .sN-f-p&A F'N- a@ԁ& @	3!
Pwr ^	
F (|r
 	u^'Ât %1+W	d1*515rz0/5Mrr[o[
u< r<0s<"N@PQN \o

u' 
$nvf<0r
sus>SPu.
I.
MȎ.}tj@&u |t
  ^!N%V#~FPS2 r20Sss6< s
	OtE""Lt*$Ot"#Ot%>" 2!)A
 ؀	.EǉFC
r]wsms1I9  <$u2 *<#"< u<@v<%ހp!2 Æ ]
F!UF% &F4~R=or&@mv8fRF'P^S^!S&EF'f&U&]rQ[P@ [`fZ護sSQt^^6L	Aؠrf;	DE蠺⻀~(LuTMs~0]fPf}3fXr1Q}L.  .GTAf f "./0`3V#:Tt`<~'t9r0l졂EE߀&Lq<D_D@ % 5I@~~6L 6u0fPfS&Mf.Lf&]f&} 
[!
A0'Qf*  r}讵rxL=rl`x5rdPtZ+cr@ H u~ (um-VƎދo^@tffmݵru蠡 Y荵r)8r$crre	rj蟵PTPQX rpw
u `fSfRWBt:ـ?f.Efff׷fAUffsP-EMF F
tSuNff3f   fVL0WP*f8f'w*f'F'*2t*f
VvfVv 4_fZFsQU n E]YRPXtUW:>_]sw#   rRPR跶pPӊB@ ǀ ZXюً 0oppBc`PQK0% [ĳ m h謀 Bt Z^N軳rot
r`a r[v">L fKf SL, 3S5<s-LO8L9
t" >LG<P#<Q$@ dMLPQ0X h   t޲rzvru3rij`wNrWu
p`dع 
!ʲr.wǴ%a@tt t	tCHq% su~rt	 2PRF sH<t<)t<(u;ь>A u/WU>ӽ`xߴ]_3r0Cy}`_^a'c $PSR 2Z[`ÉRFtN+;P X7D	F
s+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFF  f[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP FfCF VvuK-QfXr+tðP@P3 Gp1 tff   Rf+IYÀL@uu$`{k2t
.9!K^G fF! PXPE t<"u<"tlV3޾x 4Q&?s0  s& p  &G` ` G`  в&O &O`uRp`f&G`Pa j AWQb b V Wsa,ZX7RQVW:WّtNᒀuu .!6a u/AŠ ?L	
ǀ t,6pNoAOGA&&d&D&t&?D3p;_^V
} " uRPL
߰  ^   @ deeTPQ藒@RP  4
W j w<
1BQRs귄3ɺc@[P.
X `.afV`f  
u 	rpCr" s  y6	pA}Caf^U`@*2$ԉNT@׎Ǎ~WF$
&FG &U_u@
	 `CaP[,غ*3% p[`>W  
d t2_R Zo؀ˀ$0Z'`  ct
   PȎ 6(ںf  uT @ DXø a2r$<q ؎ff	R
 b cr&d 7cp0ff#f' \!f 'f.4 tff                                   0ؾ +>+۹&۾ ߹ 36{a Á.6+0GARRUFf3۰SJa"fV$
Ѐ
?tf`$T]"T4%~@ff2ȹ WfVa  gxtgGff0Xfwf    f  ow<	gzRf#pf^f_@AWf ^R_KTTTT  A  G@ @  O" y" U-Q R"G
   _  *[%	  ` `Gd dp",q w qa aO 
p pGr rrs sq]
s P"  
~ 6r 		 
R.
  P3Ҏ¿x ȫp|貈Z(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457 u v5u t
&  {x_t^t]t\7utF5R3< v
<ar5<{s1$PɎ|X{u2jrwհr9_2._Skq G$!wu@t0<zw, 뭋 
t

	t
w
 b2]kS?J, E ?G@2q)Pı
 t"< t߀r0r	
2vPQs	} 0V	gESHP  TPRuaa@uXXZXp! /pWPX@Ż= s]r~s
0{ _ ߸^ SQwt.
! !$諐 01QjQb;˂QN 3۸ K PT'aJ >> F @K" Eup
$orp`tWǿ  d_pa(    K P3`σ0W%w,.s 8 ė0fg&'f XY= PY_f@`$<t'<t#<tN< uc g T~ M_ Hh<u 5  %l  
 aS oX#XAVW3xu@o G	u1ҁ X oX@ӾV 1 S!؀ WX#X^RU$	ppquWWA? u HHB$tu 21$q  W}D	0dOeBEC3gsgTD\DpDDujpj-q@0 *{     ܐI w  "5n3@@b ZQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPkÀu3uCpN@*  f  fV@ ބuxyt u3N@f6 Vxu^ uxu?x@׿N`R\p Sh1ytE yuxxuxt!xvi
p 
]]f^ϥꦍ p $ $  GNaP PGh; h"Gt1$  Ҟ   
G    *   0  ^r 4VET]                                                                    pS A  h  O I#YOO 2	bvPtF X .	˸ f&q && "  иf3 ffi._f.]p >` 6a  !ŀ.P f.""""" ! a
#
 
 f3ۻgf+С fP s fX   QRfl f@f=  u0p fl >@  t@&?   `%Tx u!uOǿ<2{f]
 N] d `5d^PQ3 _27y4rdr
` r`f<	Dϰ4pԴx3ð4x ?+  \.QuP $@X߀u@A_Xe$Htu
蛵߂I4
<RVWf1.1Vtfay cyuQ<V V<W U   P tT `HafP > f 6s >upyf2>fZ@J5yf0d"yOyf .> u=y &R"qui`a ؀ a@ u
_^Z2 s QV_=ؾ`ÌȎ>+- ÿSr@" u !5R3r%[UfQfR  r.fZfY]za /  ob{)6,
!@BѤK K(K'`1`OB(b)f f~5߄dD	V,`fW 3sA< uf,u#ǉp f3gf&ff=SCAF2f_U< `
 <! F ]a  i<w&< t'V3ɊȈCF`S  ^ t	  QSQRVV<v^.
t" B^Z U_r t ]U!P Xs.V Ou*]$k$kA fr! &ğ& g $k#drd뙡"k'z uϑ+pd#$ku d(~%Q	r2t"S"9s*N   ["2ɵ"#Y( .633ras\踽&D0
V &DtH G 
B Mr!0rusu˾F. u踾輾$rO薿sJ0ʊKZ Sžr虿r
rBaFyoiZ2
 0
FFt ߋNfF" B]@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
 F)tЎ r4F$
Ft+ F P !VPX߃V@"aWPWR u	ZX>PRAtZX q* 5Ӟ.:f tdu`6.f]$PMM m }$PnP!   O  P efPff  @ fXtfUfp fSfPAafVfWg]?rddf_f^afXf[f]ge333ZrVd4Ad^;sgu` 
Ӊp3 vZs M tAt<VyZrdDg}
^` VWd_^gEdTg}Z
}gEm `tr	 	t}d8tW<ytu@D7Y
`PfUf]3
t u ' d.;Gt ._
u fg6$+' +k~~~~l|8 8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pf@w { >c8ll8x
~~p Q pp		 0``0{q,ff$
0xx00 0 lllll  l 0|x0f 8l8vv ``0```0 @  <<f0 0  || 0p0  x8`̃ <l 8`;p  x@ |pH `a
 
|x  ff|ff ll bhxhb `f> @p x p
pflxlf bf   8ll8` x|xpᴃ$ x0  Px ƌ2z xp``x  xa"x -70Qx|`` p 8l`0
O v!`lvf0 x  `b  G  !T vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
Qڑ u=`f SvN .X2[]SWQ  *?tуkYQ_ 
 PSR,غ:3%  Z[Xa ThAE eMA9Y.nSSK  A!`( 
`3ҴqĀu N <tD蹘QYR"r8r蔘r
2:6 v޿腘Z af|PCI01 ISA#+T DA03COMPAQꊙ 06/1 5  < ɞ    F10_  m؎h Ћ㿂_h+3f  Km L!$F10fPfSfQfRfVfWUfUCES>bc  fB  fBdVc   tVc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  AfBdfe	 3ua 6 e< tf3
@Od>S e  pd Pg>pd;e `oef3A3@!t
    2 1@b@Pa@f00tf pߨ tQEpYV ^ `]f_f^fZfYf[fXfVP3>f t
	RC &ffXf^PVW 3W P__t
r
>Jd_^X \ɰޯ۾ݷاбκm,c-DD(|1 8     I50  ``6~ "!A8>8  B9 .@'Yar: 7 @;@?i<@_ &3?$	?o	I!!
0T!A>q

( )))**LLH#E$$E~B ~B
y$$$@ $
  >""sZFYdd  #<r 
sM` ?hx"'yPQ<R!2

	" g %8 0 p}V	

$o$D81 dZI 
!e$   A4'((DD@%)P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInI`Fڏڍ׌߃Os\gpjځBȉymGłrݏOڕKvxmȂ튮xtԍÃ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉEċNԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb - @t { S   0 ` R 	i D  =Q @' 'D ?'@$C" 
 P '1!!#"& pc
~|{u m 0
Fq% pkt?   !  % )  f	! ( 02 S   `K00m) BFLXp0t  dEg!<"F 0lYpY.$`"08D(#ds$A|   UP W F  >"6>0-@  {?~!BC ""!B'  /!B#bo&2 //`    &2$-aLX'>9p1@@E@a!!: ' ( <'Bft,0<𰅇<` *0`  ?qt2pC ?Bxg ? @Ӂ00 H$@"@ 
	`0 P $&# DK8 o &  | D~D D<  B f<,$$0$l==   M@ π3` B?"#?!!  8@ `~: 	4H 8	  6 a@)1ppp" `$!3pHBQ0@S` P0ZT@L@\D2?"##(R,Y@>B&Z" Nk=bN@-A |a  %rm  2c Q " $!2a2SNa  1$Q$$aQyH ! {HHK` x dc $+Ph` @@` 0!cc1 $2&f# `\;0;@lxx0a1 
c
AZxp0!
g
  Up!rE  @>>@@`)X0$x|pTT T8 PcCQa- : D^b0 B`c$c  N $484(d(lD*&1< ?! ?&!<? !!# _f4c{ijv+ dDs?|e0v0 !"s 6`S!-cS,t. T8$9`0pGy 4g @ dt>$B<' @}""" c px% `\vdnIi&0WP?v3$fv$d
  ]@^@.*  @#2Bb"6T$-`0|p(x3 OV@@` F0Vupq@ 0u=a4`m|sGXm|%o38"5U QHU' &@'a! 3o?! @( !d(!3#\2b" '?1`		
	`21"`n{9$i$	$	`  "33ak' l?HzM8 0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!Ϧ## DEB`@].A^z! nxRK)t ?` 0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P<  b <$  '  |D!  D|p d%4 >!d??$C @ 1bp΃#18 < ~ < a   <$$$= ??d)),?4+fIᖁAp'0p6( g!?}@ @Fq6 pբ66@ƀy9N@0ya؈  `0%,#?% p$'!G@x pwc 1$&? l@ 2?$?$?bO < @$<}b =$! <`0b64~
*  hH"e g * ~  <@ D=a<$" AL`5' '-恴p7p^  ) 
8hRF pà2qq2DRD" T@""z" ""sbn0 `CF`  ||~ ނI+E`<aBzd, %}IH}T! 㔡aE@AjD0p 
 .:23V!&    B5I@v  `2"R`   @N!  0`'|Cd p>5D ( (H H  0
DP6NOeߘ  /$$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c28`."b4`'?e +"@P,  b
WBF0L 02?$&""  0p	 x 	?#`4 c$}R S SPpP O!
(#?@@DDD@"D?0!c 7E u0DL|(0<qt ` O='4КQ0i#!zM0 `  ?!#3"$$!?!#! ! ?~Rydwsλ7  H 4?b2C"c9yH@Qn4x<0	`Z ̀7( (`2)v&9^?0JbW8l>/&23
~b21G#n0  !$ #L`,!3p$?Aq%$"h| "  1  A  }    & <"rV&#0 I  81 c QQR0S"PC 8`/A a ˀ4 usn# 8ٳBY 
 Pw]IY   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,=%$>Àǒ)jP|D52D"DvDTDD6 # 3a|bz,  1Gp#\  7ajė=  k4a8	  6 P>Tڅ  ptL D@~@Bf$,8?92k&arg@eP 1 WpxPX	G ^x! 3"&,0@JoD% 6}PU<x @P8|	(9H ;)*;*$*%+8 ?T?T5VdB"pa&b F ł(x; 9~%z`6U0` . `G09H~s ց 	{ d~@*H  ~K6cNCc4{8x F?~!BC  #" e `QP060oo!  8!` "***" /"$'$&*"$
"? CJ0``]0?~$BdB  a B
BB~15,"&D$(-jB ,!.	,HO
c =I H<H$H$I$W=@ @v 4R$ze bUS R P|7 8y0 ;)6@bPgA[aq! 3 ?$$$5d$Dd< ~   ݀Z  $D$= *XGJA\! B2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#.H	TTWD? ? pw 0,0  ""bp $ & "  q?|2@G
i-_ nF:@e$ a  8@
#]](00]V?$P?			?R" N8S;8

 ek| 0@	! y 	 	 ! o>""	& ">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDTa C
w$>?  '$!$34, g A#A N<8`hO `&#f!b6@2~Z*\*jI0 bBn5	G x ?RRptF H0	    	  a |$# '!b[aaap5 2zasR0A: <  B F>lxPXHL0F`Cu@;0` 2Ǡ00b64~
**hH$lH UIHUH~HHQHUo~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@>#t40G zRs'"`7 `CD  `rL(  fMQp" ">a}>>b 2 "&"cb@	"00P G  A` xz   Vj_@` <<1p0?3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"b>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR_!q #  j   "**~*B  h b~B$fiBFD0@ @C`@.AY`M`  I2R2RR 0_Bb.	4d0.t ""p bB ?~b
(LA%ɧg󄣏UE``AC}}8@Tl@l$5?b5dk >qcQ"tdaxR4䣄	(	)	) ( )H	ߖp ^c 5] 1 aA#?~"! "2&460ba0"`F @"{D1 X8@ =@0 P` !bF! °?(HD>!"? |?;" p?.a ee   	 `p13"fdŝ Bi|"@Acp>@$	,	(	88(2l"FfÅV@@`'$pzBp03
D(z

@ 
{t~<$4 7 a  p }#@B"4&0PPP`@   p   uUp cuW` U `	 `0 ..d1S.b1lp `1  [<u.d1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.Z1` a2P S膅SP!bRV^Zu
`R\ts 2ƃǡ G
a!O sENjpW1
wts27a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F. u 2 4.>i1u . 2 13 `.Z1&1 u2CQ2P Y*2Ȱ&P aj RDr
.j1.k1PSR  && Z[X ` Op@kp
oo._61FF!.W_tOT_G-p
QR.6`1ƳP ZwY[X  \"2S2OsP2 sP
XÃ <r<0 <rp1@l1  n1.&@E0u'2!n13o!a01.>1P20X2$CFAPQRW ((_ZYX. 2.9 t.l1BA	#+D<u<RaN<P<S{<0<<<<w<`< T߰<@<.>f1 t3ػ@ .d1G.f11OO#0.d1.wf1pd`X@Y 0..?1.10;Pp2  X:޻XUFN
ȋNu	F]s S f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 MH
> tj6hjFT_c&  _hE>RIWz2o1c% = WۘWb	?g	@v	9B#Zr
$s
|
AJAfafffϢNcOcmf>JdQjut$WQ1}`	\		cR		2rA	
aZUf	a D@xrE
C
5J"Hx
R'[}SF _"3BUQcیB b,1-,gPq0is0|0~}"y$z&&fx6(E
{^R3c**%ct;j9<<= b>\;@bcjQB_d$G"_fh  nA tAt=Cdtfh jnCd$_/!~qtfhkLBG\q >tSet3 tE>p6jhdfjhI轤>" 8%j h"x1t2>e t=efh1}Uf t+f *$#f3f
ō~f PFPh|@Vh*g"7, YQh!3׉F``H[_9=#2hdh d7xod V05&	h&f4ƀB%Fİg[cg	tA}HccRFBhbFP6@ bPj>h!D_
	`#8fhafBX4YI1ShcflVcO^05%h01!4 V]EM*hҗmh
$O	QUD	^_ 2FFf^ F&<
uI) u&*V_&8ftFFP9 1FOuыٹ F FIuwF)1 F*+҉FVrg+;u;uàsg% ;Fu	;V@árogG2@UtA99vg% 
wwL*	v
 WP[
 Ffj hFSCW'-y f f0rg0 Z&a&cjLfPv~@[j`PQaj FPQ`2F`P"V=ut_ V (#GF| `02:@|Zl h & F GP	FNuFG0?7S 
yOt+HF_ dPQ	 w(wFR;v
2 1p j1y!A>UI
Ubf?R*3@6#"®r	v	$bĊ2&c% 1c ori*Z

91
Fppuq-&c53q?3ȉJr	
/c耜ab`R	 	2&a% +1a1 bj_Rûv3p%2c%  [c1jA{T 	a[NF2`h~ 3ddKjD
 E
*
C
 @	H 	Na(g|3;1 Kji]	&jS0
 U@Xdj~%&ddKr
x
x}tt5f/ @ a c
f&dFt1d@t#y:FA
rP%TzB)& dZR1{b9* p	/cjTɱ"@&!@dwX_&@`7 pU>O2a;Z_& &O g p 8[FdW 1L
a ?=fqLd +t}JQFp<&z>> bx  p^PqFrg^F  ^F&F~
r@1le?&be &` ߃&d^g@ f@ "od@ Be @ e# reG
A/ԁҒ|@PT`E  p  Vߋ6в^aF@t)td Z*tT +uN&lebe e r,9ʀtwp"Pt ߃a d
+%@@4
		! t:E)1O
duUԑ+`2@\_&pd^  e`!PgbOd !r&Bdbc=Wofmt5D@9".1F{Q0  &Cdw.j `j  3
vwB +#rS~WFгT
-d_B&*g(&Jg &*{gaz5&+ +&,C!&-.&Ƈ*gd r ͼehJg0:ZMB>cKxK@>e&eaFVDfAchja&fld	s$npa rڰtc;rOvsА):u1e eF@tCyRZj$	J>jg3Z	3܁ e$ < u W@<@/""rø`" س1 ew@bP94v14axv48fS(va2M]8fa0 q
3t%rF^Nr'~#tp  u^    % F PEڠ)^`  ~u +ËFVރVF66~ r~t` t uFލfv
0V32,pIuquSI]][t
z
 ^^apaܸL~  f# FB F~P|v^ KF NFFV~ NHt@HtcH P )nMA-g0$6^F&? u/|cvA8>d|mh߸cΐ2acV;3ncv`fncwm`
NwNF -ev톑$F8gFFPjRg_S^/GFPv4FgFm~P?cbPa?:!Z`dz_&ǯ@0c16`b`~2|FtFr(QW^]
4~`4	b->2 _`-Pʹ+FVFQC94%~ t;F4FҔ0
z u WV~vN^?>S
A0@
;^_C
"j(c
l`


[t ,md(|WVvԋNsOD
RHAA~(|W~FIt_~@u"2F#}HFB^F&:W} 
 
.AҜPU!u@##g KVDi-aҶ
%%		 	F*Pg	}`	
g<d-UWVv<ߋ~P F
&GFq&'h*V~ʋv!^PFGIub: ^&^&8t #^^}h!#ù
 0GF N% o}p,-Ar  ~s NFN+;u0g03ɋFppAF_C&PfSp@ ~0gЋsG^AaQ{Fp ~
vЂ@x|r
CVV,GV~^&FIa&a8QFbQ2c%cZE>B⻐UIkbf?N33#1!
= _r	v	u$
a2PP592

oPV_#_j`R#	2&a% XRo!2c% Rc1cjAROp 	aR/!T (!Q023dޒdjD"۰EӮ
	C
@Hp

Ns#ST
	 U4	@g
31 jiMQ,pyu~rUypzp!xx$2
7
u{2
R1
*C G&d_cBfQ!f   df߹	 &fZ h g fcm؃P2P  ccFrB3ὠ48S#ᢸ^  Vᅊi@kzFRJP6)SCzB#
3~Q s ݑ2> j6hJjFc QleV>>bIc%?^@?#c,(R !
$+9oR3Ex}j`faf	ff؃C	fcRPXBA@=`TA \a$_ADxE$
C4
T?
ag{H_ 2
N5BUac[B %
SpF "4)gաPLʲip+2~0P44h2FRͱ 08jh!YҰLWVvًދ~ &F<t<w
bSrF*;b}7ށ~y~tF&8tFu|t<r2QdV^u	A(|NÐᭂ! ~ Pfh#  |PF;rF f?* F p F*N*ȁ vFܾP0+bv`J
u+f^F 0 FOuЧE	"ff &fvctffq0`  &sg22`% u"rg$<2rg%rg1tg}u8tq= +ɉN3r{g33 kЉ  auvg$<u~vg% bPu&w
u]f2 % D0	u 
uB
w )
u/Au#aځvxg%FO fff ff	fff
ffffffߢfXaLö f3/ f B Ǩ9_ujvĿRPjk- _FB~2|Ը1~ĠF  p ~ uF{dm
 {&f jtWV@_FRvuF@ b*J*p
NvQWVqoFFP
|F؊f- Ӿh شm
'F܊f hҁ F֊ft@ t؉FjRvv}Wuh 0-~St` s}u P0M2muhLh ` h F޿fPAnFf jup:=F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFFw~ƹp^؊rqpƦtP{|`/ 'pMOQ!aPj?+ *`
- e)@0h C NVZZGnP|\\ٮ\<\2Bd$S0   -Ptq$j)af|@r 
C8@eQ@rguvf`P)1"*- t*-} t9K4Ю!1)3q$RFa+2 OEhOboL@F m40#"7g
1[(`  ~GEtt/ 3|
/@+FV+PR1w6pBd 2qa"$߲1 vrg_ب kaa1jLFPћ(1@sj)"#2#L"#AD/]LDE WV3 W^&@RFG߃|P386 2₈ R& FWbuq`Ó rP7<"JW>Jd dabb6  &_=  t@M[_ F?t  h
*"f#-//

	
A u	( LpĴ &&TVP{S~ t'jPFI l t/ u#'jfyEq0Ut= tA:? >u
le&e"be2e% e  t&le01w`u  Ð fNdkfege0eee~gdaaaHdժ\dqu[h hJP~h Zzp:r@juB^zh[WNA4R 	'"			

 
G		 	̢	r	B		a|_F&? t5(u%&|Rup )u&DPƋV@pFF"@cӐfjfh 
 fh `  	 {    Dq~  A u ˀ&c E B>`)tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  -P Q   8>ۋ  &9w&EU 6`  VV 6?Dˠ   9~ߡ H b ;p^! 
f
>~v KĀv&@u?PM{`^; vĴ 3Hfjth ? <Њp Ʒ_  "g pvV>{B   ߈vV*rF^ ɀCP% 
Pp h
 h  <RaNF
+F@0F!vvo ߴ	F_NF@ hbjy a^0CFPNQ=`O*Pđ`VW  p 3_^e #_ @SᄊF
FlBqF.
%
;F|!% /F@P!]!Vvܑm^`NP`rFDt&@A0#FlAQ@Pu< ot (F7 PF@5
 f= `(* yBఊu>b~v*VAƦ2xƊ*} ufU  V[n']> t`ur3NFّ\ ]NZ&8tG[ vNً! ؉^GF
&Ftw^ G f+tp
뎐V^% = @ʃ@A3t`߰ߋ@!A;?w>
 uο31&A *;t{r1A 
*/FD0F
tҕ t" `fp0;
V=O:`2P.B@?Vu	.SEHDa!E'(E zrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 u31~^
AF:G
uɋN3~({~ u j ~ F;|;pUD  fUVNVv<%tF` u DD^ù
0N u0+b1WQPWVFX3^tQrJ;v~ F^F&u/F$=W\qQb]R}  P+΋э8?sdvva!V0N&8 uN = tp&s@* 0Atd߱_m򀛓 !
`f+I%Q@kq6CTNi
ʐ kj ##v^~_j&F3v~Bv0ܪQ&ğ 0b;~ANuǋv 0dF˺A  
~`eP0V cPQ  F> ~ ~
~h3s P{W t4~gPǰvdPq 	ptGW5o"p j9/Fu
q_sPK0 v?v#5+PFV 00yNvD"F9F}+F- P@!Nb' ɒRq YFF`%J" nT\QPEP~)DPAEEP:! fh p39>_ ~jy/0 *9>u	A
@0
A/\&/76%'@2)
G;|2*& PE c`8(F0
A
j Qj V@V?RP=A/Qda'P? p<n@]c E +FFVa#
L0UcS4pbf 0aDPNdQ虡Q<	5Q`,+F+Ѡ`M*2 R +3Rg@"=PD=	ӁF3@**A;}Rvs`V6ra=qyg*@F;{vwPTJ4C
sR14+
}
uK#aQCP,edD&A84	PeV9VP!~9&-24hQRptYAS;}`=y#Ddf&Do&T030`~
м  q &Fި@u[] ᐡF{tdF;@]Ɛ]q<ЁN; b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~ $	;FF	_F	} t~0Vg~PtOC tG\'F
t/* ޲F T9F}\LF ;F~AZM
~~2G+sF50%&L
q DFF 0+  Ϡf@`	PXhf@PF^^EAgT`X2s|Px\b<FA@ŀ[0H&^v7QvFvwFG\Pɒ #R@~U 3'tsF+FJFH_fh i^R( tTT4v .9~4aFʱeO6,+F!}=pu.]tpSq &OC@ +σQ._+ǀ
0|c?tj[|Qu
]
FB.=Q j]> LnW/0L# 'd O)CA& !!pa2/#$QBC}PPCffpL@>ffj qWw 
Ht8-t-9t- 	t "f 	`!QF~ tfFffF  F
Pj ~  v
u}1Aj >PnHPV`
wϹ!&wc¯FKtB$PƏ
QиN	VV2ٓ?F
t!@DW% QD
莡Q
VQ6 B tDu遌
!_؋!bG C `DPk*. H!MbB되9>u	 rH `Gg	R4O1miDu(+Huu @uqt j	jfh	m	"	PGV^FPqf~
w t

>a:xQ[EPzUt@ ]FY m DVVj_vv{xzX 6Gn ]3?PS0	02Pr~CwFJ0B@UPͩ1qE~
G jR[;807+$ }p  9]t #M#/E=/`J/FFP9 \ dpg
p; ;NNNQP @C7 Ƒ= K = ;  ǿ-Pp---xАߛWp'Fj  ܩ~k >g`{ Pi;v1!;vF?PVW>}FP~FPG;~~P1% - D- *-ࠁ#- " e= Pk'-
|5. G@6-U ;sFc?a{tU tP`y cFa~9Fu
VVIVF]v9vcu@PNPN  PNNRF ~9~};V 9vu< uN0돹v T`o 3P Pp & !VN;򐅍
uk逐xA^F;~m?aXS `
$~Du6g b;|qT/QN;v};O;6VQ9~ uFApL9vw|GI0Đ0%9F| ~A^&+^&} 'F'302F u!ihj@vVt ;tt D@gx3|f4Whyl
 +rz/{~I>FWV  Gc e tǯd@ @ lj te
W|tATD\[u0Y;/F~ ZpӁrN@uOp0
DUK=eNp>d u)>&f tl>g tt >c t|dv] yhb?0ҝ Whp.u"jhbh_
j(hafh_8 _ eh_hch_ ` `} `ml#_a%M afB"	 8f% es% cc%	`aSz%
 cC%= c3#+=(`+Ͱ(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhoНpt1rt߀DODpU*䊇>AvuA*HWvAPVt0<@p& }554465245rt659hhӾ@E@ jpPVCpWV_h
	 !V3j hD	~DXր`HtHt#h !x    C wt^ý f	$F HtHtHHt$" ^@ $Ѻ&&G<P jh	G+P舐X
GW>7x@n u^aGP0v&ƀ ~RrjV6 fP)3P Ы>X F`~|֢"®s}vI@x	&8 tr
9GP{u   >pj~q9	uarf   ^f~ t  |֊FÑ!	eM	L0#	Ka@c ރ	3$50(`(h蓵pa^p3&~/tC&  v&o8 u*C;^|ck
F^P9Pg`^? tvN~}"v`<1
ރ~ u0gDFG&9 uԉ~WRr0~F Z= ?-
 - Ү<5 1 ;uJ< tCBݚtZPU-
tKŐtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@ǯF	 0 % t" uwNj p貁F  Bܲ u
gށMN3w~*^
7ފ 8&8u	F;|,Bdn~
eP $
Pڋ PPC 
Cc!
Bd$  *8fuOdPg"^ku Q/	tP3*`0F |n FPf@
t)f3fn @Hpߎfh 륐j `vJ` 4$u }@3?l3 1/J`F*A;HtϠ5= t	Bd@ &Bd> .CdQu鉀&
:v	@
ʠ
 &
&
h,hN
h [?AA7B 
@
@ -*߀

@5q&
 3F! "&Cd&Dd fykf!B"  *`FP~H AKN
3AJ$\'"%jD:GBHF*`^J Zj č&Í,3F
z46 x$dhpdj(j 9
P߇8
PPfsV̩
bW&**`)@&J` j Bd t&<
 <)뀖 x/
Q %'@q`
! Oh ej  %c
bN0*ff3	諠&`%  Piр`RB/
?
$*EH0//$&40/v04RTR"'`RVdspQ%W
$
aH*=	- I- 9t7-
 wqrMt%
- Ktq-M;tr` MYnp= d.
*F\j&,2@0`  8&&`0\'R!"Ր,20`  g0PXu/1V hhǗ STS  9YۂY݂Yހ
Y&y"0Zd a=	_[Q[_"
@4 |
U!@ &`Bd(`Dda0y@ Vfh~0/h y PVc@t߀&
 
@ ACCC΁!#!
@Bd&`Dd(`
Ɛ޾w
r4( + (#+-+tp*tcmKt
- tu] &3\& tGђv 1vhBh
h hP!wu
j8%AW&A
-C@#'$'Bɝa'a{Ðj؁ ڰ @&
)3bP}f 7
z0>{+>>G>d'>n!>/>f'><| Ћ5P$pD D:}E489JR4"" :L}%9
GBδfhh V2^Du+!Ͻ 5 31;wutX?&'`S7WAA@A@tR_!P!~_!
@>`O{? 6`L.ࡠAL&(``~<!Q("Q( Q(*|3m &Arh3OE@=QZp@	XrQUUtD33{,i
; YK`mrDFv!
oroVv0%@tx$P!.D$$`
*P#wB(f~x0%YAǁK=f͞D=H=yM;Ա;
fhZ " [BGb %^
t
]
Vct,WW*@t*teq *`v`(@a@1)m@4AEƏmƏxCQ M# ғ,*$V $ Sǆ0@0Ep@
%U@$RU~22``ҟlB	`0vuvUP74	b
A
 05K8$   ڡ	 ̤ 6> H1p  AЗc! Ս00u`}b"XWab 눋` 2߁ 1 5r1p "(9@( f fcEWfh  _е
fcf`&cN&._.@S56P6e!7>d>8FFj% 9N$N@ fdfAcu
nvu-dum$uuu	V@V ,ǈ"]|roh2;voʋF8FPVh@PwMv
/WVO 
1!` ^HtHtt-L7+ @3!!b?>
<ĶԪ4P3d %TS 9@EEaS'`eEG:lE6Dg@C
J
s( ,f+fF@ ؀  FFa^F6 FFD>== p  -  -tRp   -ݵ -*t:-`ս ߐ=+-ځB `-@Pt}qx$Ht/Ht:#HC 6 PƢ (; C!"!13 Rc" 'A
Fy
t)j UPTPfsV,tt~p ;|Va&yBY!Fp *HFL~* f fFV0vfvvFPvڐ5Fpu63F *˃~%v슅Va :uFG;F :a~ t
&x |WxP ~@&p!  p!qq t&A׃@̌?"Ht)3Ã?@A ~r}b|ɀ&XT qȐV>` ucuHj k
&3v0 Re`ff`f `j  a6 9FhDע R
`e3`8-9t- 	t Y`r
=  *Xfjj a
#5	1	?u.#JN{1uh Ɛ>a tuľ!fh  Pk	Y-NR>` t`6
Lh45PhB6a3ada& `` F |b rFPpScA ׀>p#u>6p\t&el6`y  W륃h`te3fa13
>*u	>] 0!jkj2r3t;73Be'kJP t'${~80:2GR%4;44Z
`bh j@p?@?@A!F@[$
5$4pQ*tS?=<ʓ=5
5
]`Kh@a	@Ba	 fh+rD-qbp`$Qې$#;$ %/P`adbada}" fae`Pbr ) d%  = $Lef1 M"6B2 )Rb
b
c
aޖrՒ
 }g-
g
 

 Gwg֢A] Dt,-
t%-.t,-	 tE-
tYt~- t/PC Dɣ`:B~B _p}}  9oU&Vetleug& rߩetu
q0t`ڮe@  -Ǿ@ut;>_}`  {Pr%_hذ	vpjtXя60cHtHt `t' Q {hىou
^_  WV3ɀ> N3һBrZґ@FPWr~Pr
NpDto  & Q FV^tF&ud,`,,,,,,p+,,.>uh hmhoE h 6 jh~
B"@t) 3҉65?P@;@)}F~
r݋F 
h΢	
J襾
Z 5#W<B6f
 ~}Ĳff@v3ɉNv~FV
tut9v~O|܉~*Pӈfha^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3?V~&v ؋9t
G;|FCċFvBF  3o$uG

41t%I6o%|.bpftafff̠}&XS  
tat&
S
 P@t	bt`p` ^3

tF^&F!Su	 |03$NF#@
EP2pnGW^rF*զ+= 0=a -tX-  - 9gB m= M k- t!Eh-@  Or= E.T?/ /  p- 2&ua% +11va tata@ 3 ֐j5B jho
@E
 C
*4>/ /  (݀YP)@ wj}Q'3Ƕ
^'G`hrg5؎GS.aAcharg, taa$ ay
0&
c
Q 
@RDM
F_@f 
fhK0V" !B
p,pfhw*+`()&' $%h#f0b\rd t
L d ޠfu
N0  O hE蹔 `F<tF "h"B} by_F ۄ-FC|ߊFàxaG{VA
װ
xaza4a!J/PFۯ&J`lLH f`OeOW KDU]R]B
U3HT4P3
	Ċ⪡70S
BE

H
<UʣYWF \X_	[\jt
R2z2UA `>T
2BeT2phhhB jR"&%l$b$65n4BpA{a*5pz4B
PF
ErYD
R/Qy !^,BbCbLBbBb-
^- b
- Kt Zd0`cPeaa_Ba@W8CWlʾؾ,<L\v߿6,2B7`x`za  ab AB  z!"  ;- 2&yfczt] dw@TĀDA-  3 BO+- d	uic] )#@댉 

 ~
 [mp%js/x 5t wdt@Ch=ApzOF_BAqa ΣP?cfcfxpdpp@tA Axx@d?t&UCADPJt &hDߩˎ&? t
&ؐ
~@@ª#@

C	
 
  TBB	DA0t@czqv@t&fh{
#!$@ǀn~fh2hu0
54cbB8tfh:B89h7D !P 2r
z/10 v?=>_h<Pp	BA"hB_LPWVe$ < u"@aa@<@u*e03"@uto1ۋ;>@`  2r, hh,v1p66a uU^ Dt,-
t%-.t,-	 tE-
tY- Hta- t/\C D0a: ~3 	}y   LӠ<"%@(dF  zc`  = P~Ht
`q j  r j胞>@uf4!;F~  0уrջN@uO2phhTrWV`>W 
vrv*tǑúЪ
Q &&VH&@:ԀH &di8$LLcOs&PF@d%f% o%d%.rhh(z% 'Fs"a_& *䣂aPeA u$:D7 hrhBD9  t~@ zj` rp \Ppq j`,azp0u.&j}rj`&z"q)F@0#00000000!&bmVfvfhI
 n`Nru oh 萣dF@e:tF&<:u-FF
*0N&$x   
u3tЀC7 ~ uF	 _F
 @L
 }
 <  C
wv`
ʇXjq<T^P["H
? 0
~ ~ tghAv&~ tDW O==u5 R
`
 ^3 FPPP FF9Fr @% -
 ؋0v v sd ƨu}`= wю.ɐ`Ɇɒɞɪɶɋ~FP.azcB y ~ t m4FPba =   R F  : .E " { 
ٴQs~dzt' q2ƂOFZIZ#3^ \TAhVބ.tCq uw^ GCauK  K .g"c~W#I Nr@~u_| W    I |@FfB	FV!F^@=uFv2N'22g+@]WV6赫Khrh,y*Ny vyqu}tyH4H-H4HSH[PgHuy712yFI9Az"ClIDBzߡza
"zj &z<f+f{F@ z  ^yFV^KFP6b> Lv3+Q OY  l`- t$ fFf~ sA,Guh׷ܠdPfQVȡbڙRPSQfXfYf3fffPfvmfF fh  bU覶1g Fvh ȝFQPmdK PqwT9!TaґypE  p 4  V6rNHq0	% 6aD6f\ 6f|<`y
*]aÐ3Ð@  MHz` KBSIMPLO  MOTOROLA  HP  1.21drivelock   B Computer Setup  <F1=Help> File`ystem Information  Display siSave to floppyconfigur diskette Restore fromE(defaults.
  Ign2hanges and exit EP  s! withouaving
o Securit@Administ or pa_sswor4Cte a/"Power-OnWGp DevicedeDPgbD$L $s mar?t Card%G
supportEmbedde&f
taA!e'etr*ac',p(s$`*authenticS+e
credal Auto2cH%Tools Ba />0Calib( x@(`'lectb HDD:lwf-T2 op8s Activ O Mem
Chep? r sL: ll=mbA 	>>uA@Advance:`L`4uagaC lDt7  of grayq6field 'Boow1b.x.Pres=y keyI I ue F10=
, ESC=Cl  9RAccep/=YesSNo D, Ao$r=MN W  UsSarrow
 o highl@ *he appropriQmenu iYqKp"<ENTER>= Xbegi)WK%#.followM%Zr&:fpc->  KSPACE = GNexBR3c-BACK@vio"Fg0hTABE3iSHIFTa+&*lF2@&10`
v[J` #'9 Er This60cann)b`mU;d An e o9cP^@ whs6c.pde 0kx0`yT0!e ndApGPu@p0{6Crequi yayE`dl~jba@%mu0C
movP:y }e4k/MEU)hQ1& ilPAl//+2SDcleOsu06ssfulManuZqr  N0
d:Prottyp@speItepp+CacVize (L1/L2)SQ ROM d<d famia{seP8l nupi 	Videovis"KeybooFr06verDb1$<ed2e3bg!4`1qa<wownPhip
<(TdG
W
O3O	*	Ĩtafdai5uN%BSNZC*D$ I1
2
3&	ME
C

V


4TV
o
Do
So ྶ: D.   %FPA2d!J#biFaWalRX0s&1z&H} Addline4 CAlXn.z%F$Warn: rk Tpll$0o  zDsfT[rea /v֚, lef ena waba002 A: 
de` waqt@tҰ_)Vu @rnInv ȍP
)!	Ayou̔ w=a@|to  ?m  i0oa	  0o`b+-c(Quick`n22 (-Cvre@sʅ3 (S.M.A.R.T.) EP1pexim@s ): 30 ¾# g¶30%v}} ty ho0#0#uprХ:1't4	fy-Unknk&p{ilWR!mServRe1aPS)doџ47`?a}ribp	:`exP9 'b`G H  Olp New Vfy nY7Enc8Off O$  ɥA La66#%AKroE    p dV
Ad1ݰU @ҭ5Ocpcaus7@p@=AH"h` A&ف~Opower-.AS΁Qa?U= loss  (dYAhou  nlcof aQgoH04)ev`ۢ?[YDocHishR`ed?!0f]Dddi1al <JJe HP`"UTool Cr.%oF8IL`ˣ Bk g Uмn qpm`@jtWSN !arv0s /UcwcOMP2"Onj* e:0Z%%% F@%h԰#Dn -f  TndĠfӰunuR?*$=n)tartBQK`fra PCar1yNsz}a $mediaa D-  rw"`@zU 	1 	 ab#ouasu{0hQԒ uX" ybbUSERMAST yhVpanP:FPacSTkeep ia#Je7physpE =ph!E 7mp0ar. I7?>ÄD
,Pn!Q@SWun +AgGOOAutoOc(Ed00u HZ[6h60?#ON k<
O[k{ jaD"`0ur@t\2th Q1psjow k ue"djPerK8Fb oQaff|+bdata,]ossibmma!L0ligid!VK IsXl
rmmN q} QUpu zl,`mrepla0\wsp ~p/*` By4zXr|P4,oHA=Wy@}'r5|@m
e`1r,@M`*pPpuibpty. IfdoBǄw8`ESCqt.!
 rV rtyp
'>'o F10"qbrm,b`(yt+  AE$  MiB\jQ  Or0s:zU ay O@X`2DCgDLb (leCft /hUSB t HQbSu K Z;ipoFir`ܠoPF thv`ifp Sixa NRh ENPh ASwap Fn/Ctrls KU.S КP!}slegack0РQ>is`7)n0=r@ry V0o  d oNTSC`AL -J -M눱¡9t@
BidpR EPP ECPd2size 32 MB 64a F@pAlwayʰnPPi0PAC gWWAN =D RadiLkBluetRh /rS;#chqAS Tg@a`PatP E Ch*,`..2)+)c-{-&3En8)e I123TokPR Hp
 kP	M3Unique Idf (e   *tu     Ss MCalCibaᆏ6NAstPS DQL A.Zb0B [ HyO
ЇELk MEUk'g'MRqN/G/U[:P1 : C g 9. `% ]/MCle2 zc1 dik-d3	ps
 H

,
* A 5>M(o!ylSp   hnology'tFYadapDPXE RPL Ex|#Popupz(  0 10W  2@ 3 4 5 6@7AF12z5 15D`@ 3 "M.B~ ouchpa`P5SNon <F1=Hilfe>\iYin[`OPnz'eig0`fppeict  -K!guaob9Vwiex@nLvŘ7einun	JF-s
kz
..ign@e0d A*nt neh7/%Set#SRheitsfunk%n toa u
znBlt-KuO] Gertes/-$-ID O t7	Uasttz !  ȰQz#  beim /st(
ng!K@r 5nHsvorrq##7..zurckz9
B .p,
f_g{ms>Th̰Ex)`Akkukr_eK t0BsgewhlDD-S/elbss@´ItivS9#LtIpr 3g d0: tppllTL
PZ`OS
@ PEryw :%SpraQ 1a;n!4:#U"gran FeldsArt-O&O9!86,")e SePMbqTa@0, usm p_3fahB@i=A, ESC=Abb!#`qWBkzeX!TJasN0\ , Ja	=Meh`m VeZ
zpMark"sy!*!'oMenS% d?Pfeilt!
^dQgab	e2RmOq>ko?9 c`s.	fcolj
Bn 
sg:@)-{> 0r LeGQ = Nch A\pd<-RBchritt-`VowA(GTabul!fs+ Holl2+gedOx F2@
38= {gy E3schlrLi@PK kan<~Lt we YeiffMgy16P=z`?rgetrЮn.Dc 01 L`fi6t B kqcQFY+<W\selomvPoMrB]er0ilxXWqDeskUe-KsBhmu f 3asÃbzw.2Mobihޯbgtz%.`Qz qh4Bi///"2f!
}[KAlgrѫ ab	chlos`@`F-M`ll Proz Vyprtt`wig!6R0a"Ca`-i-Gre (L1/L2kkapazitOMdPm"F7amik Sp; ummU Grafik-R0sa@Q Bz]r-Con "
A  °a?7J	b31O 2O 3O 4dqV si0 H>(F  `	o	o
@o1
L
2a7SekrET* L$ƍD%'$b-!3Kc(1  WalkZeros-T<One) EdA`@PnO`+: bX7 stqbislwnKp  ZEucQN-/WB _leQb s Atei#CP0&IyLp`ak A:nfC6
lW$g	e`KR/+Pglp%ɏ̄5 L  	/  M<0$wirkQh" vQM?`3, daᱭ
l^ie0wQPocpFLˤ01 ( anH12 (UWmfafdIGc$fhrxdauP(Min.): 30ZБadS`@0% 0cgt59wuwm HoPuy p4%ubr`"w: ؑH	ԑUnbeaaMTHxC52'rvo-L5.
32@lhafAttribu0FIAD 2u"LS.M.A.R.T.˒XX.Ms K`kwp #eus~1L Dea  JaQ`eD/t Falgeb e
U	ңBU5Ip dminIoz Dur1@`'@`|  m	g1i@eFN*1sgd,E.@"< ttifiz eq s{0yrt.@s Zu1`0LzO 9p袓enlr@~.Ajb s0DQ!np'PlsAviceTa s ,ܠF0$0@ h`L$pga|F	 :	9 JZtfa@npW{Um Fun)<S7, m3e\Wn HP{tectToolsP=c^ty ManagпU!o-- jc}- k QuickLockSubndFr#q\M #"e$bi sϢnch?utz  f`_-?1dԨ@imd`& "+a A)N+ *W"$B>#, lp$meh 1A #I Nk>"o3f`ot-Parpen}ґ:-1a$P
mCD-ԏƘڅM#@Q:n@C38mĎ"rive(F0vpl!Q ;b=XځLs E-C?\s m pWبunbralb'ar.ēIT
:gd,rbew?E!s`Va2,0fp |b"Ea E'01.J, ҃08\',  02 QIj=n6QzւO @Begriff耤Ъd"kautomMRu @Q7V7;ohl;> A iIi { qt?^!Xʗf 
VA'!!b!amU"n# O`P o"epe )pYaf{#Oz`uA58ae<s2z:n@	S.)sa`uN(}Es  oh a@c%C Rp `˂r+`IqИ  6urn3wzhE q. Esdratempf`/	 d?1zuqO`Qdz.  A@ @@R7 .p`@r&ѽ2 ⲇ Q7 b-B n rap tAdant`Whٷj @QEsc-a&Llɠ>m kW!'p'p`\ F10  esh:
xfPg gCLcf sqD} mA@MM]uBay&m A΀)bBtg0k -ET`(?links)tUSB-b#-2؆Su 1ZipV 1 2@3U45 6@789 QFn/OStrg!PtbedEaCГ O(USAfG-ZePcB`iebss¦unabhng`  PInGrafik-Contr aPrwimSek%~ Video-qϧrntBidireal GrPu_s Lfa`i8CЯtzbB
d}r WWAN-EGfӁLBluetooKth9Unb/a Egpa!Aggr` ?'*0(o@)!u/Ep@Gt 1P2d397ToqTRcC ?!"sv@x`a`13IPkbovH AkkuP  @Rt   x a  KalibPb  MakaO  N連iuala   O  fm   O DO,t OTrat-?6.  .O .qL`b4obis p9cOO5"R 0	EgnOOf`.[r '1 :. g% ]abblo(2Entl ho30P@
m* 2a
 GSm6'su uĠg`RadapaABPmB`z}ExpA-!-Popup ( .){ WedauQ0d2 (ʁZ   Kze`~Compropstn  <F1=Hjlp>Atoplys!PVisx𵣼ne G'til !!konf b[Gend0fra MQzP@QrU
J@gn{orpndr{ o&fslu Xr  u*t`@gBOtne k)hed Admini{storad!7sko K0 aodA7 fo%WhEEdjeG-i3q		 *`	*
J	Sm`-kort	God0delsf	 7do_adbyggPGOds -&2	 Nu@00fMaks l2 Ua`pg
s)9FHk@\HFBa .@ġV  cb"dvalgte b&HD?D-selv\tPr HukoQA.ACinPQ2h; OGH omv	Ir/ Avancq Sprog/ Vl1?s @mo2nedtt felO C4+'/#5l5!Tryk pP7 tas<G0=tZO^=A, ESC=Ann	uaFs!3=JaNej9 "J, A!R=MGb Brug pr
NA`RP70we  releP %meWnup(,1Wt<ENTER> bqec>A)et. safpPr'f!f7: -> e!& MELLEMRUM = Nl<-TILBAGEr!JTAB&2$KIFT++ԻF2@	:*~= Acce1h0!xhk>{sfej 8A3ku1i0gs 2dodQ)!FF1n. Fg011BRnoVD8-p% qpla`9G!krvvek`EnJJ
iC db!?s/ flyMsÈyn/MEUqoO5 bp* uvetzbrud 2JI|,nemfB J@`  Prc c@orO-typ hBigH  ztr`7Crcache (L1/L2|HVROM-d@ familiei;AWdeo#f0pds8:@Xr-cs]]D-ba`s@i`9e2o`%3o&4Z&at-ta`ofej1E("Wat!)	O3OWEw ex{%Isr4E$ TyPyٹ%xy lydes!Bmis 0'bvD1I'j`Qejeܶ var0: 1DB1! se  alt@P02[holda@ poPqt`/Lb Bb-Bdqduw5,pr $Pk
kEuGrBA:ރTETfDF%Ugyldig/
t-  @nGgivuİ2,vi avh٦,? i#քK?@ $1 (Hurr P)%Omf`) sl(`{ (): 3Q0˄2j  `1~x0% frpudZ44b2@DR 	cq: KuB+B"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5pyCD@F8Ny  Be@}fwt nDeae Fra@l  !e@+ń4P@R@{	s0F C		ƈ4D 
&KE  beviвB7 9Ё!Cfdes, f.. <r#amG261 PoRR.RVuAj@me+tabWata. Du bu$AM flAX:Ը vicehCa D[G @ߒ[&?Ɠr !,ci HP tectToolo9"jK Quisckpau`'LsQmP? Skrp!0rKvt%#k|qX)/sa1-$$ Hvisat 0`w@x6r,
di upbilK2;+1ol p@frard )x Qlash-@$PR@Cd-rom-@ V@ôB Ho4C:"eAauϱ6!hv1,< YD!.  
bPBRUGER-t@OVEDADGANGSKODEN,R3q\0MU alug:,s  n bf  ned op`JaP)edS t#
{	pND ll E_C0aQPhjlp@futo!mok- d-
\BbygAXl_6b_/k perma`anQigw13n<l  fys dsk6  4@rbqpc(On O"(l	v  H.dCn0b  `Au!dW"eLm/, soma ck@
tvt. U~u p{`ppd/cĠ ri}oU` .Q  0сbefalkrafȓpy 'AQƠ@"pl . paYu )v
ؑ!  &cO.q#o"J "4,Q/0d iDHuAP̷0..lR5:@ENtra!5ESC. řE# orpy U'F':ge@F10FYtpsf
i/PD+s  ADk Osrflgm vdRRenhaHPskm DSp-bas MultiBay (K0 /$hjUSB-floppyEC|c`c{R}wbsu SbAzipFr`aVTredj@Fj e SjSyRV O Ni @Ƀ Skimm Fn/Ctrl ElPv(a:`isk)!aOpegeUGst픙!
uPnPaq0#rm-c%r Prim Sed V`o Out Para#  TjStrCL`ohu3ko B< t 6nr? compu Q0PPǀtrm
gat WWAN-!sioLBlueEth/A (trdlvplo`~net@P2	݁UC>msty!8C(Q*8*top+b+EthN1ht 1K2Z3KToLR![ HL	e+	 	Ent6gt id-nuh`aP1riqB$  S    Z 9b/ `LKalib) ܯsnd!ig O x ;0R8ѷ  YPOH  KO OM\bo  O O#0ionOOOO$Hgs 1 1O O
1Vi/ mobPGu"[@|!(MEU)J= K=OOGO 1OO OOO[ TPq 1 : Oѿ@ .  %S ].gm5t2 AfFH5L)O3@	Genos	
k

, *  J/X4%G) ' (FA qt @@Ž֡ r "popupsink(sek.Hǀɀ2D5f- bAg0P p Konfigumas  <F1=Hjelp>ilDwin\0jon`s psy0La 3C$k"pv)Hefra6#:0 dio0	:k 'g a/vslu!A 
,SlBDE;sprowgra0t S{t pass e a/$OpFA |U'yrs%i!vsf'unkur!tif փ%@-
xvn Sm4`#godkj0RƐ!xneby3PPi%it"ot5sTilbake@l#3fabpP PBQ g
i
 C7;avL`Srkty & val1g !AlPP 65h 8Pvt Ak MbT!#[ S3EG $*
`H!4vanprlgy 6  Dem7`5bM @ZdtJIel[3
.5E6o%<}5Tr7ykkC taJqLQL&pg _=, ESC=Avbrya bBeAPpJaCNei rP, xi\Rer=Mbb `kYneRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMROM = NhQ&86  <-TILBAKEPvrig*TAB&"HIFTa++F2@	x)}= Go f#l`bsfeF`  SPk`0`pZmnop@5 PS M0|m kjresve,!@m d;@i pp 9!obaRaflysbc^ 0dS w}a`1A|zrv full1z. kode 02Io"Produ _t Nopablok7k-mll N {typ h@igv&-ga zvAӄbuff~N(L1/L2Meng`	Q	enu V@woI-ЏTjrtroUSW,kobgRi%,oK51 q'i 22340,p( E
,9( Q`
oa
o0A
o,
NEkgB#Iml۔$Eo%Hq ok!i*ps("Walp9g 0s"-h1jH( A]dss e7]"~e PRnsAd 4~: DsA#.s@Qtid9lSCholp`@DDH[aQ "{/he-  dÓ, rnP}u1p sakl<k`nn02Aa:%ڲO b@Ҽreg1i%HUgyld#ig#DSR`@	F
	#NEh0mtEb`?̀{|]F igno3t._te?-  HN 1 (yR @nslXbP (): 30A3ggr 0$s0%[v\&st!vhFx_f!_: Ka"qut``U(Ó5$SQ&eGt :To(Lesb'1Du+q vrib: ID01rs<pS.M.A.R.T.-f^C0CCG  G#Npu  Bekreft njAv`l eP㰔1qrEّjv>likt aDu!0oC 2Ѽ	aŤ,okag3ogs.rɐor dmpel& Tp}?ّ.BrPa(A=pph. `bku,  amK#0vice.0ula?eD(s  aݢI 0"H i HP ptectTools3curity Man0`r.'-RN%l8  ēlanp撩pa0us #L@$AOmpEr`i!gi$eu bes!ka u"-U+/- +ӂWE%lq  '. tgl`rh,v@=$ڀPŶ. K$RmEp! rfrard- ParFll+vFP]hielQrzp2   CD- %FtV2uu H)o $.:Be5C`Ehpvalgtuh h`h"4@b࿿BRUKERHOVED-T6 C:J Rzumu0B@EQ
 an0^*REDbe! 1LPP
0P  w@"!2 $Va" #
6S,AS[P= 	"ن 6*pp   tJ@IOM @ automPZpD!xLock	4dbygg[)c16a  @^maPq߷ilg ^ge0.S k_[h 7fysAad $0GnrW  m#>	}v !n:gne1^VsQs ѻdda g ~u%y. Uh omd @O1}0/e XG)0{nq
` uQbVnbefau 31G	A}q.1A=x A0k1E5  fiP _!R!'Y~I7MTאs x-QVflans NPBv
,x2˰ESC-zL Ϣ`sb'fD'J F10$ZCb#e:hf$ nd  Nor iFGO%re  MultiBayPG]z "Q'n(vef!e)pPko.ngsbahhsyOBUSBA|w Zip-U
A A0AaFn/oCtrle EAVd(USA)|GekeenAela	jZtroA2deo@!j"pTisrr`2F3ViA7tiࣀ`0mFgradi/@?trdl |t
WWAN) OOHLOJBluetooth /-eftmP7 Ag ss'styg!1% %*2$ (	v0&#.b/! 1 Ethߐ;?@	.-	3	  !R!(NT s*PooPo/
;niA@jtifikhRRC&@B:riJ( K0t  4 @6ymbo Kalib2K Baes- Ip<pɀ?D/ual ,-N	 O	I	O	O	51 O	O	O	O	8ksp.bO	O	O	ond 4oO	O	
%O	O	bv mob. a
H.\ L.\O	a}o
 {{O	B.[ TO: La. В% ]<afull"C2F~iH3
in/Qh*0 Oy  (o J/DJ/éiǋpkim: sin@ ~hurtigE (sekurxѷF12-`Df1.Sepute P@pRConfiguraciPe la Com`adora <F1=Ayuda>~`rchivo@`m%l SAmaGu`0isco? flexi acqܻ RP	a`&svalopfdobPay Ignambioos yli 0a A{  g3 'LnepidadA0s#e
g  ' Ajpiciof%pposis_SIc)$ +5@*KskSm!=C SSoϐe*c P#<) Sectyincor% E@0 e" 30/c`VP>6fb	rI
aBV:c!3nci@]~)AutomaHerrami aC2}H`er 8`#P(8 ;prueba HDDK!c 'EOGVЇ&Memoria2ad*mp.l1@JNKRMu0G`SG#
s
 AvanzX`"ESvVDD
W? Fampr)co0N grp<1o?)<>UOprim'wquitec0g2) Pbm=, ESC=Ca06la==Acsep u=SSqNK1"Y, C9o2	=M y
 p UyB$6dchDha6@alP}  alem o apropiu=@[*<INTRO> z qx:N1n.Fs{3pkԕTY :@Esp~o o -> = PrxcRetroce
s<-{0\@aؼTAB S	S'aMays+#C(/F2!-910`rXŠ"b"uErrx06F  No@8 AiWGSzPrjo u@QRA6K. CcdК`01Bhay nunw>эqubRnY2@AC1+>b1 r(Rp[co`rUD)JН@ebook/MEU?IXQP\2O`0ple0Vxitosa4e Fak T1ytil CTisOp7,VUclGpuW>XTamauZ_0h (L1/cL2Oc FAAROM mil|@cNmerD}ribvisBUv@ j6r g-l@yo!! 
/#j1l2n3p4 EtiqurBAsI2VehFK (ga` Woo.o3oopoi QB	Esnؠ!*J8T 5:Z$?  ProbU%bssfactcXJ$ǔ =ll4R9eo 0poX@1'	ln
edi$l@z,
(CE|`oD"F%Ad :vH ui[r  eap. PreP#/, `WcqscpdYcuA:'p, Uu c lQas ' Ӣ,hp9tegAң
S^@vlQI$\'vaPa)00٠>o(a) 8!@%c	Za?`gnޗod ilO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcuvtieej 2( s):G 300g3o B0%&~Db EaH0ּ _`ipalGirumq
 : s,pu10 qIQ{`3nh7Servof 44apoya atrib0: ID0p#@exs G
X0Y<A`sea<KHnuevL@)Df ApagE ndq9S@gOB".X		@e voc`"	k"alp3a 
0 Lstnad ;`f Rn"]e#թ&9 A*# \A<Q, (02o,vA`Ơbs (R6% E  WciR|LLꅠB hrpinR3 SBf_ oltı9al ol` X#A!vu	j+vip.AoQ  '{Ùv?%(֠WapaAuydAn14n HPctTool@O)%!!&  QuickLockSuspen Blo`^Թ\r#at S 6""t mej`eO@`?:0d++-y	(BI	( !)(%rALlRt0,"BD,0X&-upizQ,.`xHOre PunP+r'ojo%q>lWS9MLmedufh zBaC#D-q(E喁P&XPk:	Zv@Us0io:
OpuT=sPP  !rrive(Rl! tpb|USUARIOJ PRINCIPAL0Q @lo@圠dtVnKman`V p< Py. An[4} y gu$8@lug\П  `j7a{P..'tJ @d]"YIe@GӁ1
c@bU= Z`>&BQ3"mc8K)81FPor/A:
; ;QrkR ϐu@u  , fsm1$2A RirP
oc,#I"oi  /#_z"<Y q0!u SϠd/a|MsRcubb TtBB! ? 0|pda !$kosgѰ6Se xo1enf 8d2`licQ!"reAaza. LO?k Pu  `#PZRS4=Tin!~k  k0T1B¸fiup8Z!`
s|i@pons2> Y_, iѰR? ESC.  ձalaubp'Fd'  ,F10!":ҽxfGaG7T/Espaol O@rStMultiBatNPa DiPsi໤3-p  ;]ӟfbP"sco+(iz(@jech-5 cBb a1ЇSuwkrdZipcpmeaewTer Jo C`5t#0 x SOv NoD C|us Fn/`T@ncIngls (EE.UU.)sp¤ (ppmplfSo}"le0$b
er10Cnt!Ac@ Gΰeo Mod0z"y!  Bidiƃ Tam&CmpI!2i#	si0߰ɣfu0{ BX߳ICARPxQ׀k*WWANy{L Bluetooth IA
p}{Pyho<#ergs؈gCpoPosb 6B/p:(s+ior)Eth  et, NЗbooU& 1/,2/L3/Tok0R dOOP23 IpStif Exclus sAMa6`   .a*C0g`*-N0p[PSՏo`Wr)Xh!,o	o	Pk	o	h	s0bpk n	o	o	eoko	o	 o	ao	o	%MEU o	.o	o	o	o	Ub2o	@o	o	o	B8[0n1 :rg"9. c% ]/`~pAm2 @c@4-Cle0τ3	й@k",'* q 9ODJ)o!qoh ~1bl䑄@z>Arran1pBy@gÓXDPХg2ExQ찱` < ŐF12 QTPAmb@TouchPad ]u1o N u׀aPub  <F1=A_juda>rP0Info@ˇsobPo Sd Ei?5maDђpR0
rt@7xpadr0
3r  Ign`0aCirA	4sPs'&_\1nanJ4azOPDBr% &p͂_ `#Ɠb!X_d#@!

SͥtSd"҅8liz/p̉O
(Ib 0և/R Q*p?g%ҠbrB
autQ<n 4dcЬealha@o`Ma c(QF5eOmas@g1=1 iCP8$!leOpT HDD A1)r  VR#Le Mem@PA<  4tatu S`MuPW^G[⩨ Avd8!S%,io Qa^d; 1cam=ppJcinzP"o?CA9 Pbs`eS qlr wcи'tinu0g=' SC=Ce9lAce imNK!S7, Q%ou=Maikg Uti0: sC	qqn'	da` o i  aprop@w *u@Tt#<ENTER> t5meRez[@3o.Tgu@n9 ^r ub:  ->
PAO = PrxiK\<-QB7ACKCExaQE06TABo$SHIFT+C%* CF2 	*:`=kSC# 9nErrrOA@Q@na0WoQpڃmRHE. CdigTGo 0o1  NPhG`,@o `+)  s@ vizKCA A	̬bMev
;nsf`ZWot?ebook/C[@(RWS mG"sTe2_DKKXqmBm xitonN  Ti0Hۀ3VpcS_\ Tahcache (L1/L2੦FX a` ROM FamlY  sN 3sri
RevisSvde@̠_aJroQLa
Al@!D	Ob a( 3M4`Rtie!p	JIOeu6$(]) { 7on)o`o.Oo$alS~ƕSecunda'A$ 1rcC% v\foi"gv@a!mO al  Walk S 0e g1i	a lien!M!oc0I@Advoert: 0[0Aqo vaCe!djWcPqP/,!i@um  gravvuu:e)EӎA: n@Adc NS3 >HB^hO!Q/tegiEa	c8]
vl0IDyI= k9T@ctez0eja $,C? iN >?ý1 (Rpx b2 (A@ng!qf3 (S.M.A.R.T.ax`=_(.): 30<`хѡ0@CT =4Q0%?1$=bucedeA,qAhostDCrom1
w: Iss-P$Eg
Ch`Ӂƫ(*erPmec    `6Q3s<M tribߒ焁LD`AМexa@s wQUUi!g:Tgrg"`alPSLs   qL rB+ۤiPArrfDigNcis gҀSAAdP)PPЉxac'mod!CsާB! faz A@ArEr@a,Πerx dform!Hr3Dn,P#ja0.@eHCsHfbr>causadQerF.  TbZ Q[ea 㷑2krvio 	Iy0rqX)QTa?%0Р ur@1r0k
ad`pis0S,B,QuickLock!Suspenso Blo 0ktB #u@aSM%` mabnb1IY @k, $$al#.`2P4sa eiSib0RPuseu s<EExigU`re*PbM0Q+x &perme@$1lp즅+!CD-"˯gGDP$qmse:PDusua?: VocÈ@ gp4@a0v[r2utzo}oDrive& t@$RU?SURIOBG>@ESTRE_ FSC%7q<Vapaqz:@I. AapN4P@9de-0ФrMisPJEB>p"}@. NNv p[֣'6Ve ,V`(P_K` 0+bu:*Ƥa !Ede]D.Hf``7/{s1!Bi屧O7T>WDIAV
l`9w90o  sum`Ef`lo,alp Af Caa_#erf
a`u@uzoT :aq(˂40  Àoqur<ǵx@FkgڲU yaf0T y 2y, p;) bF `3Bor nal|p`a-t
A^ ˢtEs{ubtud C{ ?@*h R)ppa۵ptA-lVJ/q rWL !8Z  Lemb#re ՚vqMaac`Pasa88
"qui(_se`R ESC]ŉ9Šq3Wlav'f'xrF10. `r`r:!MrʷTAc]䚺D ugus Op1k: MultibayQYNc`isi reAFpzBa baФ^copld(RP ditzB	Rc"zipcPrimeir"rUc Qtӂ*O]v@N Ճc@aqAs Fn/CtrlIngls_ (E.UV@`ыxS[hp1troahvdeAcuned a@hMo#aGPadrBiQTaPhBmemOp"sem fubw>zfec10CA.#%RPa 0RlmWWAN)` ooLo)Bl^oothkAACn(a/ E omCenerga9 erec-CagRF2.11{Ė5e/2o03su0ˏ3Et&netg	O `p
/*3/CToken RingOOboI5df Sb 6auaqW XKSt`sSs
CbGqPdbptgemNS vlCAwr R"[Duplo&	ted/	 )	E/	jON@OOO'as7AmO/	k0C/	cIAl0  OO/	Ojp~AMEU/	 /	-/	G9Dф1 	/	/	/	O6[ Etapa {1:rreg29. 0% ]Ojc3l 2:AcvN3:M* 
 o9ayCJm*O"(sDflex	`QSc زrydapY!i Pop;up> Exbp@ ~àF12(т? d>QZs Vara֧a N u`Ti k yktukP  <F1=Ohje>Jrj۰tQt Nytt[ v0`tu kP Tallenna levykkee dk@oUn oPu VtF?Fo0ej'nsW Oh  mutA 0lopQ4YLr  ttPt7fTpo uau=rlisuinvojan s saMritoKynqypk. Latyl	
 P usnume
o$f-
t Wlykpiu '
,(oPn-u kiG
/6 Sua(et`Fp.Ttq3Ѧs5*tehd@&7FG"R`t"b$j;A)ma*in`CTykaluA: o` K = Ki@3vyt?PO9`@EMu  Ok"  a"r6n D;m 
.GHLis=ieli O@I0k aec  harll`1q0= 22R2$2%Jatkinjot~  nppP]=d, ESC=PerF =Hyvksy=KyllEi M, JokuaL=TY_ fnu7oli
mip2_kah$@
sidsBN <ENTER> m7t%
ep+.AIK%gn C/ss seuraav0U: ->Xi VLINPPIN =p$[s  <-bASKELPAoLAUTEdPfb1!YARKA+!@hԭVAIHTO+', F2@
)_}=  d@!;PvirhvAkkua e =oi>da.>: R0vdi 01*ka@c1s ~4 apHrt2Pl pV`eytke`"6ko>@	siPQlaksQqsYsRW` kaCt@qlaaP^ TikkI)>ske_ytyi Fn
i(pO2nL^oRhpebaGEma|j|~1?i@d tyyppD@iIn :fap{llVlisQ (L1/L2 U  ROM-Sbmkoh	tuotep9e"Isar {W]`si ?s?tohjab T;{	!1I:"#2o L3o`M4m	J`Ltaqɯon7(j \oa)



\	\JekA'ra- DqACup$#:D$ p9ar%dzb~ lpi0!iEepoSi Walking 0 -[1Yloso Vaihtoe@ :Нuvi7 us?: Tmا`atpnhp . JltO luop2us-  n,ҐirjQonc@!K A: L"X AY	hkuVV 3beFAG"8p_Cpa  h
Hkoa]Wi a`nA?+ ?2`o  pi?ͨ,i`%(ND92R`3.M.A.R.T
.`Arp$ [ n (min): 30-Es p2y0%cL dv0 Ispysi- 4iVgR
{fb%uCntq'c{K)jServomogottj
Lu!5ÂvtuQ	k@Fttribti2ЗŽy@a 6e*qKxe nGG89 Uu/Vahvu @x P>2Ȕ	! PC }A"+2s@a	,-ãPAJ頴n4-okkpD;ad`5an OI$nDP -e@7p$Rmysba
`kD1h@` HЁeT @	dE	ZEY/ i0Xj [!K uEnQnwby:p\veapahtum"b@^id FLaJ4tii l <HP PrpctTo7ols`cuQ`Pger -apQuД큶.f(-/U i` n QuickLocqkfa hlu5qf ,V "@P#raZ&-Q,:*sekm #o$j$it)a{d0||}yh'  PP`0#U8C.7>uu	SApor In+frPnR@%!bkܑCD- -aglWpbt`PBOj0WWAiot=bUon DИe$(qpTT#)|PKlla. P    KYTTJN:a PSSANAN,0&#K,x.ma$r@'silyqNhur@S9h 
 ri_g[t _r
VX-%PV,1pC@@jwLLA1=[Q'᫆ ONU @Ros`* $Vh suQFZ>R;)f,#tu?x	5ogm O
 G BU7m BFr
Sxez`jED. NykyscR`+`RAn𨐆{s1x6s
t@@\ PU. Tnt Ƞ}$6ih1xeip=ݏuperVd<eh? IPa*?-m@&yް\2tHtaqV^=c |AxojaiemmR}tAq.A 71pm @"Fdt" TV@UG.2!`ZXrr F_Fzc$ elnPĀo#\X#SS,aTpESC-n`bPsR6;n,e'e'!> F10`Y4aax :B	o .cVQ llQޠtmidys ubbn MultiB
aOpc&J7^lako0iu6 (en/$oi) USBd@)ZipEnsimm ABKyoA elj }Vi}Ki eit@Kapk Y Kym!aiо Fn_/Ctrl"mA8+Engo(USAUsP0s#a!1@B-RsQ S`nq`jBs#PPs V0o'lht\Vakiops2sN#Ig3uuQH`Dpl1% verkko "
WWAWN-roHLOwBluWothE @/Fh`H  sVp&Rs s:l(ӏ,1i`0>H y/2,-I, (ylos+OGCO6EtherHo2E Yoeo3o9To $g OohA workQc&G <IlivA AkkuT < TJr ӿ rPjo lib
reu ad S\ual`- OO OI OKblb_OO  O O sO$O$`O$ vva_  O1 O1` OMaa nusBkPB ODO OOMbOOOO
OI[ e`i:r
йa;da@n . % ] ODP$W2l` urpp&OE -O
3
 GoMOH*  j l 9#`Fނk`qvuɃ!Piǰ@ (se  n A @:@OF12:ڴiP%3tappi>QkoskeӐ 'mma K  Ei mn Configurati3ordteur  <F1=A> Fichier? Infor m Aff age Sauvegarder sur disqc Ra*r 'une.H_DHeals dfauow du'Ign=o%modi T&quQ S$?e l'inp$@Preg om	\ Scuritia%
e ssLdS"#j@e sous teP 8Ion. D
 priphP %J	a sE& IDy'As
Dr`<Lockq
Smp(C0 Br131r3  'heP5G  1b#a <gre taR,)+5p7am''us3;),;rfren!cM =``t"#Ou@[ !@lonnLb`beriZ slecqSn@psQs AIATA BFoV,mmoir `hcBDX C0ZZaFB_V A0c`oLang4 ChoistPJYl3Ind)|!5_mps g!X 5ePMd.rpa `k2Z}:~z? AppuyDfnatouqpo@gezu@l v=Ser, ECH/AP=AlHAccep| S0=OuiuN*#Q3V, N/'impp_e``D
=0aw  UPzi3
s Mf'heM
mox!04ecle hmenuucer8@r0wbri2qh@z!y <E?NTREE>2nj+W	ss	sui@/fa  !/ :-> ou BARRE ESPACE = PBe`1-$IE?preced@S.TAB`CA*'MAJ+ix F2=1p"w-$!S( rr`@P<TJ Ily FA%ssibdcQ7L U cs'Jprod{endp#B$P. Coa<'401c5CntP@-1 emplace(L' D SaQre @}C'y
GJ 
s}^ccueoil dн "4 itzaxsmobia``
W 
u` B!OOOF2BfCX+)a ru Fa0;cq0M\ GTyp0osBVpwDb KTa@rcaa(L1/L2) Volu`e!gD  ROMOamR Numrqo#p	Rev`cndo erS2ItrQcl#avpoLA} ud@;n+/Zp/zr3/t4n"3inv!/Qzi&<5 #priF:!L( Ute)O OoOOOBV'ed6A Eo MT֍ :$/.   %ErF4 !SUPc;Walking 0ᥒ81lig'ad`auZC	od  al0i5fAtip1SRC[a=e@ptruA ieЪvPR! /簹r,  z{ nr1o°c	HcY0]A}jDL_v
 t;ro Pa
s
TX	  _[Rvj!a"`dH.ORn m:YfP S 0"Ӏf   +-vaPC 
lp  ߚV ? Igno7 +| z? Enregeo#=1 (rap`)#>2 (coet)u`|VpimA(z) Bc30堿s pAnU0% nv$D9ʈl'hA+bF  `:˗	AsmGinpnu#d'+,`v`t
$.Lu( pG3ip 5A`ib!<O: IDP00@"s S.M.A.R{.TAbanG2WpW AIBY`/se N!=apYeAÐ?/@;saұ#A Mar uin KS;A, eecoac	;mme, vK*ad11POobPbatCs	eS¢d4D	 pe>a1a`(`ih s4[	,p@s蒵 `Ug"  f'ormQg-hHq#xѼsJ.)ArmQފb	 hJU0`
1AJ	.6zT"`QDP~aR avoupR!AfrCww7 A^	 	zYR`(p"}ffQd  k;l2TcgNq`rHP P`o Tool:e^Ry Mar 	O4K8CF!/  QuickLockUsus A|$cp!ri 9 س<S&ol'S+C)re!cB!
`K)!nk:,   v qi4//;  / L'(a'Ha
S$ud!v
 KP
dra+D hn8 4`ExiZAudP `2  4raQ8llƙۗ&flashYd CcD-'gEcepWЫpala*Y:6PR63ge Drive!*. S3A@bAeBde{z deux"(UTILISATEURPRINCIPAL) "cEǋ	r SċOj N;z J@ ұ@Fᣐ#1"Qisr  ,mfe0celu&NSDordi@"c. A 0@QV	{( p$OV)Do `Co 5Afetr pyJ~N",t"	~"raSX""Qnof0; ;""t QE)=ah:>Janiq45#'/৆#!2/r,c`sĻ!Pl!  30ӿ)YH!!} !! {e [1NJ^%puel1d@݂͐sU :Hh" ""opDa8lE O'fW'ҜB`k_w# ,d'orig[inIlv`OH2CxaB	uȦ
vqSpցa0AQy9	0t0M@
5dSjaBvPsaH{S@P{e* r-$ށW1=aprs@4AAon: toP@Tr0a44p`abzt3إk'
vj, appuy
` ECHAP.@ @@ OTzR'o', pui@CrDF;10 TapX C1xCxY^u}	U/1Fr/ana
OgVACJiMultiBayѪ0ulAphA !3D,xsoca%(ga¡)OOFRz) U[8 USBF1r
jZieprP: Dhi@s Qu9aQCin`NSixi Se  Hud NeuvCD`Perm/r(s Fn/Ctrl@zS Anglp>SA) Pcopqm1`s =A stan0`˛hnROd'ad`neltrl' UichLuer&mRФ`
*d :i@7idoAABid@b 0 mmVlă@jEK!alX ó R o!=ril WWAN? (rseil)Agr
LB=lPooth73/?1  R >o`$ g`\Q loc <G `c!ZqX0b951AbP-n o;2ooypu8<	6ccumod`ogB EP$t# 1Ha%23TokRing ooUX/IduT9-ar a[  2     h ll`h n!Kre00/ x Ab!AF0.!f*Dupk */)///wb/ ////** -///Jqgn$, /,/ /e s` BtexвsqbmoP/ /7/// ,///7[qRpe 1 : Charr. % ]A.  2D` GicM*
n3@	Rkio.
* T   @@/M.$oOA$Ʊ|4Amor1cFe"5 RetardBTexp `) Dжa  F12\tposf[iP+Aux  PatqbAKw ucun I$@z!Nl1 <F1=Ai0>`nfo0gema	l p'Salval floppy%APttoRipr0ina dmThhifap`i Ignor`daed esci EP a
l'iI?z`ciBPtup iczza^ sswo!%e am C0rato  gPccsP
_Q,C*vos7xv% IDs
դ&gDriveLock	Pr`ǃ)S t =C7 Sup;  c30 gHQg/ o+:,i fabbrP
4=i	/.nzi[Oco
rui UCb5<bae"E`lrOpa@t2;o roigidAtaA'Vâ,a mepTW`<HKhMiM;A>o \!Ava=t eLu!O l$Dim"& q6ca X sso geviQ gL	vv!'#o*62wH8Premi qsiasicsXperQVu L  @i=f, ESC=Annu`,aA Etpoeo=SiSN1T,altro#	=A bj Us"SchiavI frecc'!9i1`vocu ap70e"_`<INVIO>  \k\'e.ipYgui  un%: -> o SPAZIO = xsuWss`0  <-pB7ACKCE`qc<ؽTAB@C%o"MAIUSC+)XFa2	>-= m "AC"IErriS0D  Qut A87npupvse@t"Vi  v@u4T|8XJ. C{'01 Npu 0F>9a0}oggiao Lk`IP'0  U>re0
4Es"@agga%FvpSAcғ  npabook"R=QzespajT :\ Zf.atp1_
2o{briu`Prf uduA ND  Ti"+0<PSpVeloIStespp@YMis1ca(L1/L2 d&dDbRO}MIamiglk N@o0H`(	RP[3[oi#qSroll TsjrAer ~iI1OFk2m3n4ࡐ7w PVSTe)D
E(d)8
	2
3
4 摭Fonda
 ,:o:EV$ Tr%OupyP!gTŒ@lliASpr|B:bit 0t 1R?indirip	i] `|@'FAЎso:5X%? ?gger `|vpAhAr1e!0M/rѧ, `1faAvi P}PiVLYXA:'mU[VA:"maconouAh(,_ IISɁQrita] N
sv@dpRDlIQOyളSe3 `cvoPga ?AFbІb iQfre?@?: Aɐ51 (Rap)62 (C?omplet"2tio (): 30>0%Q5"r6ar0䠈'hD5|:s*Щ -@
˱֤(aD୆%aerv|")LċAPLA'	rib i0go=l: ID$Ban`de@z قi S.M.A.R.T.!ޱuT0U _/wordc(nuo!i2 pDsc(Ui%L?Ibq+d` {â"Znd ?՛O.A7Tącq^B&
Am  AVf!B;YECr	t>J2fuDm y3CePe<B #u _tH0s!1a哰.Q]ՒbdFo8@!erdPКatiwEff+Jizso@in  ca2iHvEvPgaζOdesХ@Jm9Yy HP tectTools Od.ZRV2+ ickLocykspen`3B05EY moeu`s8 MM  d?#<#,pv  gra@p0'!oe -!e $C-))v!pKsm@]0x!! b	,'URa]r i lі@NR(@|ГȡV|a infraQ)p y%La_hflasho CD- eS准2&PWЗPp`	:(Y =!AҍўDeyusan@D:e'. DU8G$=0R bRY"'UTENTE@PRINCIP?ALE  r+`"ρa Pm3anA5fu`o. AnV@!<dЊQt @P!"A eC!>c2<!t.`leAu0WMT[s,
`h	\@poI sab<4reWc.MaPi? `o`6d6dqGi>h@A
 @rea,q  d (1z:t tOCF r luogo ĴG T!¿'     i$  hSGT#:,eG</ I"I@5-"L7Y$r@lx|slmЄ!R/ċ|cB  /$²Ȓ Sz0SŔ@c( 0 0DA'Ps`  gPQ#pQAiqv  	lptat{+`uY/A dO::!al0{s&.2pCqu_{9c!." Y)@sA`YE	snO`d@K@ȱ0' 6h,mQo ESCFM9'ŝ)dovr0 'n'`po2m!nF10.ɡnQ!k0 Wyƴ_6\WPРIP(i 3G  O :Ćİ d5m MiBay ba 1.gga s$Z) og C}h`i USBAܘ]Suk\bC
ZipBP6o ;Terz  OЁv`N%ec AAP Fn/?Ctrl T`Ingl (OUSA) Yi沃u2O mp!l  A01aЃ`` R7pl AaP0ư0!Mo@ecW Bid0HaCapa memPqaX5eIm s"F!/lb@Q2'/wNPs (WWAN%){oLBluetoot}hCommu	Z/ (J)Cs m energ]phW'Ng)1 N,*2HIB-Fat-(Fo)ol/spo EthetWJ V123e Token Ring !OE3 IAkB| sCtQa L   AoQ(  C02b// WD|Saoo [Kvi0DuV /  o 6  / o ,o// ooda C  /  o pUY\mo93/ /-ooo oȓ///poo[ PAs 1 : 
ros .  % ]<ocompp®
#2S' 4,n6E3 @̀
ij* 
 /JqoXaX/3i'o
  FlOoppybUAI!dC@ p(sec.)# vel0F12 b 2zw@pambp@Nupup <F1=Hjlp> rkiv Sya|infoth s~ S pk%kigu഑@1( stll /frnlưn@ard Ann}uAa nd` ochsl   n ˑ~ Sker dP2trsslpD  K!aOB@rt-OaEn ssp	(b -ID
S a&o
@m`
Pd-Std fruqtQ!av 7K
`byggd 
 usBi=*abrikk+ .J
sbehrig#.DEsktsrktyg Km +r vڐ" 
S`;vtgF~HDD Ak_V Minnes:b 01q5@?@An'@#B
Q  V[lj4rDp;cBnedtolD!v(C-j+eTryxQI fri Dg@q nr du viJPst0x X=, ESC=AvbryNaFDAccepaF, V=Mer X JvI pil`	c	/pCa yEt
<RETUR> om6
\YRtt .ie,lj`SeerI  : -> MELLANSLAGSTANGENTE?N = NXS@<-BACKSTEG FregeynK TABf#|OKIFT+0H& F2`+?z= 'fO @%Aoi?Cfe=l 3t gqL` kA@t h+AO` Dstod uGen. FelkF0197 AsgF{P|plat  NtPhm krv 3?A @pbyؐgm0 fly5s t6 -dator/r ex$(|0Ytidigooi2-@kl`TA UkN4,  Pr Pr, typ
hast^hg0Ca-	rlek (L1/L2)Yd RO{M,tum  ?familjr?enummn0D/deo,`r!Yȓ ttNb ~pqyrQ!]H 1I.z2#3$4rbinvp ˦3 (
bZ)g	1[


Sek# xIrq. 4I$@gaxr#%Ex!z=ok!ŰvidClmissl l.s Walk0s - T~P f1jH Add0s l)i7Ae nVar! D@/ѹ  x7neh g"Ccuskap*ay /G-t!ڱxiƱ=k b0!h$2AA:f1R K>#Rhi{wIBB?skyddadag

  B Eˎ҇pA!^Ԉ  d|? ig?D܇jGa- 1na#bb8f@րީn`X9UWk`ad k$pQd }(0): 30@npan 2?0%bX A4Pp/]p9p01vr kMatPo:,t	!قOk%S(x eorvo-Lz B!i @(f%ttribut: IDpx?grobsr.M.A.R.T.-5 G'ammN u7. ifin0@ D> Lܰ@Q R4d% pm}vlika mǄ  'InE?ka?n orsa@3iЈP9aHSsNyapPO@Om=<s1A1lo. 'Na om hglmabtj@Deh ;els!e- @^uQ"uayVq >fun 0`perl^7!i HP tectTools%٩R}-6-Quicka"q`telgeG Lp׌mP<s Hgk
gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!aot. Kж7Aom4pHi p@1%f   Pk`anFlash-@: s!CD-pBWu O#TpSr HuvudH`y`I: D,`m3vahrdud D~e!. /C怆a^r AN}VsHUVUD#$|`pmart w.]  A? L1q`ild frPA+A
 I1PhPx@L l Qף(l HTwO.
!Y  *oH XBe0bbycggP6Q1 g3///dZ6- FX;o	mc eB
08HcA?=  ?dr:asBQGdʜD[`ktuPaiq3ۖafanqkhr`.GutAMC]tgrs ^W!p,t1ursprung`LxK. Vi  reko`RF	b~c	Wr`+D,s`b`~. A`KT ̄3_bh  &g!(g AzO-kbefnse rm ih޶fljQfns . Tr  >ESC-QBS r26V"&PwC`'Z'R-WsedMtaGF10`cVi3Fa:+ddQ~shye aSve a 2 Q: N?, M iB;ayCrut`A~opBP5vi B1a PG (pyr (h@SB G Zip-=PW`AsQFj1AѱQ. utto NЛT VxpFn?-/Ctrle j' E`lsЭ(USAbmYkd@!aa b`nrmstrorxK,  hbbelorlekhpeo62ne@k@LpIfڒEsioBtrqtK (WWAN)LBluetoooth p/() -v@A=Nmbe1/ Aggs`haE(-21i,2v0
[,p'Ned Et!hඡ,& 0	3n To!RqN"!Unik *1D?qiG K `tus      SBbo Kalibo dp~-  F=s alQ.O
 o 

 
9 
Fo 
ED 
D0!m1s 
Aoo
E:
Htag  *o 
* 
eVC| emoo ]A*5ooe
 DIOOKoo@d
D?[N}e _ : Lapr . 0% ]x
klar2uj2h53omFjOF* &V@1 >I* O!DgOЀU®br@࠲4sadsap@$lg ?rdrjQpsnabb0 (sek. F1 B{d StyrRPguen!he 0aer/ `POp e@slaan ConfiguPpoanaf pvt~ndaardQ3!/  scy	WijzigS%ne@Āprogramma @ܠ0Setupv  zr w  ۃrsvei !Behee rswachtwo o1݅
 $X. Ap aatbOgl$$ ID's 	Sm4CP p OauP3P$PcR%mj+%O
Ge0gf3 gssvzie2ۏ"Fabrieks.Cugz7/):;Vref.s:nieuwB8ONc  ExtAccuwB ZeN gese'lec Ea p`Es  zelftGa -schijfeai`Act PXvG0u?1 @I R!a/ 4RUBgDAcg@7n ,DP=%_
 w 9aKc~!: Taal b  =r/em 	rijsgeomaak el=;o" /;9
8ukAZ ]0ayNMLg]@f=S, ESC=AOnnul"EDG,0=!emJacNee fslui@Q,c AQ-f`=MNHulppijltjkp`?gebrui0d )jui~Pwnukeuzk@ark^<ENTE?R> ind 
cr]beZo !vol%@@1  0aiX:  -> of SPATIEBALKc =><-oBACKCEVorigl)TABb	#EHIFT+%%ܺ20+Kq= ykp=t#B~fGouta64k pn It w_ge15 F0M0reqatijasFen. AcoZ0Q1b`a0.i1ZCu  we   Netvoe are0#FMPNp diVbas`e`*
 t n0 notebo?ok-pc/P) @.istNpOQbep*Gigdooh2L	MЛaft NmpALyp~6rocessnel3Q p9p OmPЂP}e (L1/Ly2`Zapac?i VHaROM @ -s!fS<mm E  Hebvrgav|_0ideokp&p;b bpM@	m	ra1b2rd3e4ahisgI t}.jne  C(_B(ЉwMdzQ%)
  `D#SecuibE.aw~~$Ftb%)҆2! dHU2L53Hac-0-*1Tho_ad/resrlafwisn/d pao==LTop: zPٱt<ts ev'ge t PS&BbeЉf  s d1 A:|og-  / "x0zbLe6`NoffaG1Y\f_dقڑD`H

boචgAt
wOC'We nu duъ"
wi	l?oݩ""a?Ox
Zl"+1 (b),2 (U0Y ) Аpqwrpn (min.): 30aee&p:L0%Qtoo 40;q{ho:5broA):]eeqx/nb!$32#Nkvo-IPsE I"
20"qk:J S.M.A.R.T.-af@APP@udh "/:Blo!  A I -7B4kXqcrlpSX8
 Vr!a1& iKs bBs AYoCf#/k, Tm]lijk0UKQΛ zoik` dvor s:ka?0QH fQeksKPugzet,r lorZ@¶ZOb$ uswb sqwYfur9houd'Hi`!  AQ`R`T`R&BhѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k  p?gspp`&b TWm E #M"Mg$rgΠ9b 6  ~erX#W>,.o(
h( o( S("7'EAJb"f k otraakP)5w sXbtK;?@ݳ ]Qŉ ڹp1׀frapd  Parˊ Flash-malCdC-r@WHN|ǉHoofdXVqGs`
jE  Uq13xaia DQLc7A<i!Pzow*HOOFD-BSGEBRUIKERS8_L1  p $an=	 SsC  cҦwacJ#! fy0k#0hcomp s%ksMq~`[p%t  Pbc(q. `Y0ppq8_{!_AutomKc%5:)z2U@Ҁr <zdZ==}88! O!V)?!2:NP O! !. Mo0Xe1_joOtD, `   CjrS8ΠRU nt@`Pe@p	M/ # huiǐ,UPd`w~was to/!k wgea. pwW~anvloeC7YkjY0TsPn`pZUt0rAra=8	R0` torH/) bget. Oo
 s @vb뎸. OmRun
1]A&`3fe*& gol q. Aݹ_Ա_õ,ubh A dc3䥼p3ruk3AESC- (A90Ri r4'k'tyUbkn F1!0`ۀT* Zlutłb r3`V4 - 1Nel@@g Mult/iBayjVzkd@\!baswe (ks)re  USB-Մ cb+zlp-" ErF@we鱠Vr V@{Zes >IZ῀>Aa8N Fn/Ctrl< `Owiss/`ߧSStaMcW3MijsappOu Ke 0  nӈ ӫ$l Bkij V o-QPFA/A0d`ditionN  Gvgp<uqVilat0E?b疩p neVd$Radioj _WWAN-aofLooBluet@h/o $JArgieP[K^.(b)ߏc3EtȐ 1
2
3iTo}R/-OMo@bo!023 UPXuAt060!cuI< q6us     ScaGekali@!1OK "2
NeEualR\JO OCOGEZOOO 4^B 1^'OOO H0~pAգ
O$O"Lker-MUE- $J$OC$P 1q+OO+O  [alp 1 ': Bo@19. % ]/& p[0d2knte~l/{	3	˄
foh l/)* Jt  ;>.C,$"q $#axXadap @PҢ(sec.)pop-up bijW snroC aF12 )Kbb cursorytuyEasyPo-muisG1 Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋւa\܂tsfBNɕۑ  ݒOCOF県Ăg&f 
H
gɁ  Ho׎ɞ 
E	ύXɏ_I  `AO̿Ԃܫ@ea L(eA`LCǗ҃p h/do'o "X yf@\̗L/?E%ID&ID: h (uN XBSA$͍폜eX} 0g J 23TÃ|OH	, v".eI*"%ɀ;FX
 ؖy>f
cA>oAe̒  I(Df:nA%e> pCeBIvCc"F@ `F  H D%Jc9J; ڍc R5BM NP$߂MA%E@U`UO tÃB!#sNu%.37($b74L[BR af=!AEsc=C@bsAS60=͂
ς  aRAg)gjq5\ 3gp] jkڂ %iA@ugp>[Ex]  e >ȳ#wA̘r_->Epy`tOo[ = {ET  <-SG[BackSpace] a%[Tab!AG#[Shift]+eF2!,,,10nm˔F/[%  !CG[  @DBCł}@BDrp o 01 OyN^F`+@~3a
ɂACϊOk ~ڑKv@&eb rO x1X
Mp!mQ^0fGdMEU		Ȃ2e`	ýуޯ     xݸ  ށiL1/L2"`OM OM̧Fرٔԍ  ޵ ޼ ް ۰ׂްޯ ްir ޯ#2.3N4h	 pŰϼch3(?Â)FE-3N4(J(kvJ _!nF2w XcopF?$qv sxП6!;LsU+WalkF0s?A-1tB/Z hѢp^`OD4x:2BtςƁACɩ %C颴 ?ĎDa/ŗpg쐬AFA:݉ b#G}v!h F F SPl	NXxWM֎~@Y qZos/9@y(c  ~ցB=	H #ċ gOo g'`,گ>Я1iNp`2iS3p.M.A.R.T \zsԁij: 30Bײ>v0% bj!c OK z3 eB~ f{:@	{em`QX1kT {ǂݨUעfIFIDP.Ba "R`R AFfV!'/i `¢k@ΡdAJg(B<(a ͤDAJhvٓB"߼ /  ߽@{R@r9RVdNJǂ̂P*p4u`@aUC	 !]ţ"^
YӍcxei!ݡ£	羂 É?` a7df!f
`?"dHP ProtectToolsܡh}lWŒǉT Bq#j,.qנB4УMmNuJ<"T h80' k{-E`O'OH&J8-.))Tی삪'D<D%蕴` g4`dt!(!ċNb8'v"Q ԊOD GPuA=0V @QlA [_CD-Pu3X(^ !} K^ S:`"AzUK^ᑀ %i E_$C0vb@{ y`9`$	5 ;?`,WAT<@fO."i	0	iBlpH	͎T spR@sѿ痣JS{#ۊqH@P!H/)Ɛ!eFybYG q> ߐ Y0ۏ؊ԓ "łb͗L kł粗`Ak)/)%)AxpȦ WZq.w"*FD`nDHa(o(f}@#$'m@\@Z ( ?IO)F) u
χ((?(9(ÞgDu$x#<43ɑ`檇ƈ|M3 f=ɉeN~^@&A)F1jj 8cB  BgBB}AӑO"O cĪ(2ef̯攌8d툐q]l@ӔCநaUC"1/g'y}EE[Esc] @ȍ~elAիmT.?DriveLock }t[F10B MS  y_ԝ7`E: ESxtkGb~@œO xXioiEcUSB Xp H Zip1Ԗ 2b 3 4"567jB8910r Fn/Ctrl~%̐ؑ ǯ@{`\p (USA)> `|*]B#fo+X
KV&Ws
v C\g͍  }]ZJ _ =rIo@⬤ cW>o%wACY Oڑ͏ɛ̧pa峀lNi!WANj%'ML@gBluetootHg/#jְ`ߓd 0
qIntel  Execution DisabCle`0ѯ..12,2O,..odhEthernetX I1237 gPq
 AOKO3O@$OF{j) ID P7bfN P     ' p\cf bpU?ke j] o \(P%*nP/h /!!!MEUv$ )o| ooo)@v!5bv1 : [d . Џ% ]aO<׮2 !gOv
3		)HJ*    5`$>s'pmj&vSpeedStep  technologyBP
u 	_АPް  px?(b) pF12Qiby_R !^`b(aZB @d                                                                                                                                                                                                                                                           ` a b c d e f gt" L      ڏ   4  	 
      
  (       p    b    h         ȡ    z   R  / 0 ^  3 4  5 6   ( ) H  , -   * +   һmp
 N % @.    mm(m$m0+m1m88m>m@EmKmHR_mXm U`@E<BB<U> FبE0`8l v x|v||p0p7c   c 0A   = ~ 
=$$$<   DDD    O aƄe  i  o䔕 u  y ֡$n%Ap E%!IC&O   U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'(

C$~: |  sډ+'()+'* &8F3&

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      ^g|mA  _m^@  &.@  bm@ EUD @n}.mL@@ I mp  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
m9 dmca@ emgm@@ | *@bmW{Xt|dU Zrt}[}#L  ]~&  W_t`$itVa!
U	$
 	 
`	
 &fmU`
abUcDdeDf4Ph(>{&__m@    `m@  
 {j( 
( 
r Kl0 |n o : u*R  	mb $ 9 0
 VF10 Setup Image_SETUP  PD	Sq  ;S 	d% *vE@J"IP Ta|` C6
&$`ԩC ت TԫTԪ*J<g!"$Dcz: 'ᴳ4㴴4崵d紶4D8b_ : (һm
6  ($))$**$++$,,$--9 -g  0	>`
9 
E#8i3jG@ #!" #" #" 
/8 RMUNMNOO 8 @
: 	 
      /	&Wvc  b"    %    O''!(( )P)Q*R*S+T+U,V,W-X-Y.3V
kd-dh.h1dii2dj3j6dk;kdlJlZdm@mCdnDnKdoEFdpGpHdqIq5ajmoqHrZ$Is$i\6{UB |y{ }U|d`}rX}UL ~ `}}x ~U`~n~~tYu wxEѪ~*z{W  }t􏄠k~ 
O5L5(@4Q]`xo:Ufԕ\` dRT\;UU`
fe @9 ԠxԠ  &LR@ \ b v @ L@ @ X z @ @L@ . H T j@~ ( ̀ L8@ R r  @ @L,@ L `  @ @@ B Z t @ @L:@ ^ j  @̀L2@ T f  @@ V z R @ _	L@ & U: N Z@dUp @ @
WL*@ B V Un @U @_L @ @ U`  @M  @ @ U`  @M 
C  U. J@bvU @} L@ U< ^ ~ @ն @ H \ z@ @L$@ 4 L ` @֚ @%@ > T h @ @@  " & *@.6P h@j @$ -@ d   @L0@ Z   @Ȫ @ ,@ Z   @@1@ 4 B P ^@r~ @ @@+@ Z   @ @#@ P j  @VN | ժ@؀WLD@ r  5 @&@:@ Uf   @S
;@ h  ը @T!@  * < UR@f U@ U@ S 3@   U "@(:UD L@RlU @U @U @S  ,@   " JB^z @ښ @ 6@ < \ n @ @! N@ 4 L p @"@U@ h   @# 5@ d   @$R@ `   @%@2@ V t  @&.@ BUB T f@v 1Ī @ '@>@ $ & * .@26: >@BDZ\`dh~* @@h ʚ@ (@S@ D p  @覀)A@ \ r  @ * Q@ : N p @j + F@ Z   @,@o@ , N f @Ě -f@  ( 0 H@Xv @J.q@ @ Uj x ~@M/h@ Z Ր  @.0y@  A	 @:1@d@   ,2 r@  T @ԀM 
3@z@ < UN ` l@Ւ @ 4T]@ ( < P Uh@ @ހ5j@ : OhOhOhGhAFh~ @F 6 @ "L Un @S7@ D b  % 8y@ : \ r   I9x@ $ Ah8 U`@ M@:@@ H U^ r @M;@@ & U@ L V@ZU^b h@rՐ @<T@@ Z   M@=j@  5  >@ J \ Ehj @?^@ ~   @ @ > V j @̪ @(A@ p   @Bt@ b   @&C@    $D @  ƚ  (E@ j   &F@j@   G @ P   @(H@ Z R  Ah5 @ I@@ U\ r  @U @U @UҀ @MJp@  U0 \ x@IMh AhEh@Eh A K@ < ^ vR @Ih@րAhL @ T |  @"M@ r   $N@@  ܦ O@  ̦ P@  Ȧ Q@@    8R@   ,S @ z   @IT@@ Z B U@ LAh1
U@ 2 R Eh\OhKh(DOhGh @Eh A @V @ L `  @
W@@ L V p @j XȪ@ & B j ~T@Ф @S YS@ D n U @M Z@ P Ut  @@ [ @ : ^  @ܚ @\@@ 2 Z  @J]@ N Up  @ҀM$^ @ z դ  @$_H@ f p@U @؀ `T@ 2 N ` Uv@ @ހaT@ , @ Z h@zOhOhOhШAj @b Ģ@ 6 "X@z @c@ < \ zT % @d $ F T@tR Ц5 @e@@ UV h z  @Ϛ @f@ ( @ JJ R@VAhZ @h ަ@g@ P x  @2h@    @ i8 J j@| j@ bJ   МU @ր5 k@ UF l  @5Ԁl @ UX x  @M(m @ z 5   n @ Uj   @So@ h  5 @(p @ U   @S q@ h  % @M@r<@ 6 UV n ~@U @U @ҀU @Ahs@@ , > ^ v@~$В ШЩA @t(@ @ b R @к@ր 
u@ : T n @ @$v @   .w'@   ,x C@   4y @   >izv@  { 6@    |7@ < Z pJ @@< 5@}R@ TBh@2f r@ƀOhDOh~@ Х$ . Ah4LX \@n @Ѐ @ R ~  @؀@@ 8 J v @ƚ @ 6 V l @j "T@ AhJ j @A @@K@ * 6 D d@zj@ Ԁ   "@ < L j v@| ֚@ l@ d   @VCh& > l @ԀH #@ AhX x@U @΀Eh
@R@ 2 P f ~@j @ *@ < R h AhOhOhOhШA j@ڀ ]J@ . J "f@U @@ F AhhT % 5@ <@ U< \ l@Eh @1@ F X j z@@  I Z@ $ Eh:@I>B jFU`t @ƀM@ n Ր  @TJ@ R ~  վ@Ԁ
Tx@ 6 X j Ւ@TN@ \ f t U@ @Ah @ e@ v j  @(f@ t   ֚@(@ ~j     Ī@ X r  Ț@s@ xj   
@ v   ؚ@ @ j   @ @ @ b v J @jAh Oh Eh@Ȫ @ %Gh " I:B@\ ҁ e@ < T r@ @ e@ L l  @Ҁ @ n   @ f   @*~@    "@     @ z   @k@ R n R @Ih@Kh* N@rDЀ@OhЪDOhGhAh@4Eh@@ U$ < \ v@բ T@ \   @ԀT @ P j  ը@Ҁ@@ R r j@٪@ P p ~ @ .@ b   @ @ @ `   @ښ@ " P  @К @ P p  @ؚ@ |j   J@ l  @U @S@ N \ Ul @M A@ P Up  @ڀS  @ L r U @܀OhOhOhGhA@ > ^ | @ @ B j  @ʀ $@@ x   @@@ ` p    @@ P ~  @䦀 2@ @ R n@j @ j@ " * &@8D\ x@ (@@    " @    6 N r@j ê@ z   j@΀Ī@ . J V l@ @ p  Ԧ @@ h t  @(@    @ p j  @@@ ^   @(Ā@ p j  @@G*@ N |  պ TL@ V   U@ʀ 5@ ǀ@ U   &@U.6P X@U`p @ʀ F@ @  :b @  @ @T d 5@ @ UV z  @ր$ChN z  @ |@ z  ަ @@ t   
΀@ h   @6@@    @x@ :R Z Bz@ @Ё15 @@ "@ OhlDOhЈ R@A @5 @ UL l  @5ʀ @ UT ~  @Ā 
T@\@ H n  @ @ @ ^  @Ԁ
 U@ > `  @ʀ
UCh & 4 UV@n e@Ah@2R@ < Ah` f@Ր T @ B j  լ@ЀT@ T   M@ @@ P E~  Ah @T@ : F V Ur@ M@@@ D Ub  @΀M @ f   OhOhOhP@؀M߀y@ H U^ t @5 @ UL l ~ @5Ҁ  @ d A%r @  
@@ < N d z@ O@ X r  @䀾@ F T ` v@ @ @@i@ `   @j@ z   @@ EhL* b@ M@* ;@  U  @؀3^ @ U: D R d@Ւ T@@ ~   S뀎@ X  5 @"[@ U~   @S @ Z  5 @ @ h   T@@ Z   M@ @ b   Ahؚ@ J@ P z Ah@AhR AhEhʀ 2@A@j @ U 8 P n@xД @@ަ @4@ V j  @ChU0 F \ @մ T@ T x  պ@؀"J v  ܦ@@ n    @@ d   @$ x@    @@ l   @I@ J Bh U|@ Ё1Ah @"E8 OhjDOhЂ@AhӢR @ @T@@ J ^ ~ U@ S @ \ z U @ЀM @@ T p    \@ 4 \ t @ @\*@ R d  @Ī @؀\,@ < T v @ @\
@ . P d @ @ b   @\@ X   @S\ @ : F UX@l U@ _\@ 2 UP t @ն @W\@ 4 L Ud |@ OhOhOhA @	
@ 8 R lR @" M@
@@ F UR n @%\(@ 8 T n  @ʀ \0@ @ \ x @j @
@ ^ t  @ ֪@ @
\&@ ^   @("@ ~ j  @*@ b z  մ @
T @ l   M@ @+@ < UR ` t@U @ԀM3@ X U  @_"\N@ r Ո  @T@ \   }@\6@ UV   @_\B@ n 5  @5@ Ւ   T(@ v   M@ > U$ : H@`U @SI@ @5 @ U  ( 2@U<Vb h@Ux @Ҁ  7@  ,TA\@p @̀  F@ `   @ @ p  Ě @@+@ M@  @2 @   6!@K@   :" '@   Bi#J@  $ F@    (%A@   f &@@ 
 JT fgΈTЁ1Tb @к OhDOh' W@ 8J H X AbU| @5 
(@Z@ Ub   @S) *@ z  ՠ @*Te@ ^ l  ՠ@Ȁ+T@e@ X j  5@ր,E@ Uf n  @5Ȁ-@c@ UD p x @S @M.h@ R Ur  @5 / 8@ Uf   @S0i@ T | 5 @
1g@ UL   @S02@@   i 3c@ 0 F Z r@ j@ƀ4@P@ H j  j@̀5@v@ P t  
@ЀOhOhOhЇA6Tq@ H \ p @"@7 j@ r   @8@@ r   @ 9|@ FT  `   @LR@: h@ X d U| @ĀM ;@d@ L Uh  @ @<T@    U&@Jh 5@ = @ Ռ   0>T P@    ?@ R Ў@ 0@ N@   A}@ D T d z@   Bu@    C@ j   $D @ ~   Ee@ x  Ԧ F@ \ j  @G6@ r   H@@ j   I@@ \ J  @AhS Jq@ B Z U @؀@K@   * 4 >@FPZ d@l @j LR@ ( Mh6@iIN@Eh^ t4A@؀M @ R r Ah@N @ b ~  @ԚO @ D ^  @ P@ z   ,Q@@  ަ R@  Ȧ  S@@ z   ,T@    U@@ 2 T r @ҀB@V@ < j Ё1U @b OhWOh@<FTR h@n U\@є M@X@ T Uj  @SY @ 6 T U| @M Z@ 0 UP f ~@  մ  @[T@ Z   լ@\T@ > j  U@ M@]@@ @ UX z @5 ^@ U4 : b @ն _T@ ^   5@`@ r   aT@@ |   M@b@ " U2 F Z@pU @5 c @ U: V r @լ dT@ L l  @OhOhOhШA@e@ N j  @ր
f @ T z  @Ԁ$)g@ r  ո@ʀ
hT@@ 4 T h@ Ahi @ * D l @ @j @ b t  @ @&Lj @k@ v   @l@ x   m@ R* | @5 @n@ UR   @S0o@ \ n U~ @U @ހSp@ \  5 @q@ Uv   @S&r@   M s@@  5  t@ r    uT@@ `   Sv@ d  M 
wb@ L p  @*h@xT @ ` gv U@ @LT @̀ @yT0@  > T @p|Њ$ AhEh@Ehi Ah*z*@ x   Ҁ  {T@ Z x  մ@Ԁ|T@ H b  $vLЀ}Ԁ@   &~Ԁ,@   :4@   @ 5   @ 5  ,5@ U @ Ԁ  SG@ X v B@֦ Ch1@ LJ `@Ж@DOhKhDOhGh} L
  $ *@<Tf @ 
?@ R r  @  ޚ  
@.@ 0 : P d@R@M@5@ T p  @Y@ @T @ J ^ |L @ @ R l [ @jL @"9@ Z  Ě @ @    @"C@ n   @$_L(U> J \ Ul@ U@ƀ @C 2 J b z@ @1t@ Zae z OhOhOhARTA d@U @؀ o@ "< ` @ܚ @`@ 6 %X t   U( F X h@Ah~ j@ր@Y@ D R b nj@`j@
@'f@ : @ ^;3f(B ^@ @@ f j  @@R@ L Ahx @ж @,@    @
@b@ , : H \@br @Ȁ @ X x  @ڀ Z@ j j  @@ b   Κ@*@@@ ~Ҁ  A@"T@@    S @ `   @ހ M@@ < UZ v ҂_IL @}rL Ā   ̪@Ԁ  @@  ( 2 xJ-@ %LMhN AhjIx@ЎвM @ X l Ah@ @@ 6 T r @j @ R   @6 @   @`@    4@    @ j   2@2@    ؚ@@@ JT Bj |@E Ah1 @@ Eh@ OhbDOhЂ @TBR 谀U @S @ Z | զ @(T @ Z p  U@Ā S@@ : ^ Uv @M  @ h U  @M@ ~ U  @St@  ( UL Z@vբ @ T @ . P ^ Ud@ S@@ B h U @̀S @ X  5 @@ ^    @@ < N Z x@j @@ͪ@ 8 P n j@ʀ ê@ : \ h x @OhOhOhAU@ M@@ L l "@Ț  @ 8* \ ~ @% @@@ \  p   @U  F ~ U@ S  @ $ 4 Up @5 @@   $ Ah(@,4R p@j ( ̪@ ~   @@ p   րT@ , H r Ն@"T@    @ä @ , 6D T@j @@ ` j  @
@ n   @.@v@    a@ nj     @ d   @:ɀ@  ƚ  8ʀ{@ v*   @ @@ qLU" < Z@zU  ӦU @ʀU @ j@T @ * < V Ur@ *Ь@Āހ@AQ,T @ x   i@@ u@  : Z z @ަ @@ < Z  @̀@ d j  @ ٪@ L v  @Ҁ*@ ^   @*@@ n j  @ T@ Bn | @1D Ё1
U`% @ Oh,OhH@@ x@Ah~J M @@ H U~  @րS@@ b t U @M -@ 0 J  @oj @?@ P l  @ @0@ d r  @К@  ۀ@ H \ x @ @o@ & L r @ @@ T   @
@ R   @@`@ * D N V@dp| @ @j )@ , > P b@t @ @@ OhOhOhPA6@NUh @ $"H p  @䦀@X@ D tR  %FA% @@ %: ^ %~j @ @ 6 \ p @ @=@ H ^ | @ @Ҁت @ @ n j  @
+U< t  @S途@ H p U @̀M  n@ H v  @T@ D T b Ur@ U@؀ SI@    &@  A .@  ئ  v@ b j  @ >T@ v  @@ @ 5 @@@ UL   @S,p@    @ TX@ 4 Z @Ў @Ā ֪@܀ j@@֪@   ( 4 P@j (@Nh @
T@ b |  ծ@̀T@ D j  U@ S f@ `  ՠ @Tg@ l   M@ g@ x զ  @,T@    S
@ d  5 @ @u@ U: X p @B @&p@ . 1UN T@l"EhOhиDOhʇ 
 @ $PnPm/ /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй 
Us# hNfP u	fXc  h UZY[Xg&ۅF ;9   Ã tfPfS
u	p  Vf[f}XRg&u-g&
pAgf&A"fGK  KKf105vg&ƳRK9g&PESWVfW&O*f%OKg&D= $ <vD# D| u:t/T'_^
QRfU

}0tRR>tKdmtE$fu
j0t0t	dp.  f]ZYPSRi uLHSrL&jmsG tu0< 0
Mg'fA$. +"(QwZ "P  u
P! 3 t
 SQV3Ҡimxjwj  :imtzffKfxj AƜ(Y)9wfP98$Њ;`	PKXjj)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>~+A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
cmD$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	Vbm kmff@EFt!hXUgvuN>tO6f뿢bm Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% cmSA _=m# XA	uwjwj>I&BKZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@߾)RK )FbfDf% ffDg7^Z# j^00f 4sp*2{É6^^nBn@& 7Ti({Pfpsf
  @WXfff:0[3`6'E8q4ж3~U L؇gOS?NYY:YYrZ1q\YZ ЍSpk< w !			;/eE1{`eR#tZV(oQ`Cʕ F%frQfRVmmu/(` r'(>  4
P  ~
 @+=ha+( MQ   f3۹ fbdTt ` 0:Q ?\^8ZFfC⁢PS@sw$yk{s>
p"o
d
\Ku@S1?"5`,KuZ'苆FFLKu FQ$Pdm$G^f  @s4j2jgOH^D	%߉D	f:O"-fp<v PfUJ?f@KfffQ$f6f> f	>fBf0+ff]X߀ t p,rPԁf_z0R0Ӄfw3 Z`R҃>/ t5  A U@@!`0ӳ
@lAԟGRV&H:f;tff) F#$A^q$e sqSf qgfÈ>  fù fAB;t)gf+ C kB;PEQM`?k ӒHGPV  ^ h2 ;uБ;~ ;b 6P6UXfm.0XR @ y  	`@  Q}o+p+ r3!B +!;PՁ  UVEWT-.55\EFGG-8. UWRQSPV@3rw+t ur6ffWRP0 eXh<fZf_;>+uƴ+kmaPS puve+i@g+j+a+U/xklb+znmc+D[XF f sf tf[ Ȑ![YZ_]e È++0_Q `+ cmPcm j0fdqtu!+! !ddfd԰  >P6Sd ddP ʱ(++ fU0t=T=f]t,>@u%ttt t	tfsN 0Et@)r@ua`ln)s
 1Qh 6<!qLuFk . u$>!
VێeS tLrt@!ـ?и{D`*fdofeT ff/fXs "qy#uptLe|+ ` }+ uYpf3f$ fe|+LfWpe*&|+8fw*fF*2t*܊e&}+fXAf`PKem)'*!(++ f?꤫"Z  Āu(!`v]+6R p(Q?faSQVWU&dm tdm 8!H!i]aLS-120ZIP 25M0 RV:1:o2:p2o2PKp
>w
 z
\5	d+?>s!hErg;<tV< uWQ/f< Q:D= uFfG(*P!X!X  A0`u v+Qfmo+i+p+j+a+v0 RW1h
ȿqK} tEAJ!/'_Z[M-Sys   DiskOnKey 1 #߅axBgm u @  f<x fP f0Q1"%|= 2rޒ 0w"1{s ȧsU3IH tuRfQf@fPuLst6Lu2r)g&	ug&g&oc\,f_߸ PA߉ rLTD!f<Q?GQkRlRQbV`cF5Qome}?L!:!į;0h7jt@ u u#P-3RAwf?LfHS N 
~1fXuײ?D0U @0zB0hB0nB0mB0cG05F6F 	 ;!Ng!&3FPRrco3W1>#>;!2>
g>_ÈYh|PhN`p&P  h*l ZXSWހ` 1s!$?
u$˄[          Ұ,X @x^0 uY rTB5_!0c@  i|X  t V  ` 	b?hwo4<_fH f5fo0cЉf&^h/uf^06.f ff5fP  5f%@ף% @ B5f  z6f5f=A&  ` AVf˺aDf=%t 5t;@3tZ0tZ鑠DfkX$g];6  5Iۼ5Sf@ t|P5"s~ tD~f q55<5f>5 u x` _D  2ft.0c@P +rfu$Q5@s11 _>5@!R05'r"b"0  <1VC@f,S	  tX	艧*rH'	"	0 
%9 uf-%tq0ұ0 P35*P  	P5;tpa '	5 :  rf 
 BpQDP؊*5@6Pf>5gGf	gOg{G]`db>:芓"3	0	5
`6@#Du	%&0cf65f	f 5fIng^_g~WӋ!
*t4h 0		0	}  FFheJԆ<t
 &H5q*p09u
 'X*؃ CH&H5&HqN&ebLK6%@( 5f (f 42a3uf5W  bof~t0awSgff95u gF95u 95u
gF957tgHNXfF_5zr=БC=0rxiGsVfS'`c(gF'	5g^ g"G0g[F V*' /e*emd&b&g&g&G
0G
 dЪGd*PGg&Gg&G
 G 3g[n Fpp5Ot	f AkG^ 0\PfV cssf@mdf p^fIf!5&55+5(5  5 < t5  ;vȉ5qv o f@
BqygfgG p ,gZG
	qGfu"a ?Hf%fE@ !gG!&55 t@bk!f#pFwcnɚ`_OB'PRx7з[fS
f30Vf$fӃ\Qfp<#{-  !Si y s9t ```*`a`b	`c		0]	0^	  
		 
							
 0hfoWQf`!Yf_`њD=fr+D=q+@D
$>g+%
ĈD
+"r%詿 >q+bcASes?+rI`d
Qr7R|= USBSug&|=w t t
U	 	`+cTZ +QΡ p arQ?r C0& z%rP`6@`2P>+?t QrIt2Q9fF`AdYrٜSf1fM^!WA@@H\
w؀e܉\b< H
p*rvA
x @
`0
!?
0
"sTq
=aWa'"CS# iD=qp*W.?43'PT2' oZ(Z
}2(
y_7
|_=%t99 R$RS$2Q	@ ?VEB@RP2 3* h >>!_Lu ᠅ T=
yXS<(fT= & y#j6~+~+ r}QtA3`>|+|+p+` pta^Vu6} }+ +.ZE?f.6VEOPpYfX`VEI|G<`+ fa9?,B3U+*/G/%QfPfph`1<@YfXY"N0\J?;G7/Osc`MoDABA<e=S$l=38%rp-+SLt9~ qLtE eLtQ+D$
ƈDFP!r r
9rY⹖ ;/p%tFPtt=tT= t2:t+u:u hNodty(u~~(rt{^@SL=@tqL=teL=`	t_L= SLh)6`oXaPSV+8dtd߶}mޠrgla޾+8Dt_D$PQ@HPhBޠd<^[XSQ?O	8t`g	G	Y[L0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSVݫ      Z *8۝6TO!
  	b.>  
   UKUKo      2@SJ[PuK&|KО!i$ru
>uKN * | > X * t|KxKxK>xKuKu UKFϰ'PSCrzK藯$zzzOKuKQKwKYΓQ	`P/$`
3 `"K&K&K L3 wKpVSbm@t	V5m[^@pVcmTK "`K1m!f4 uՀuq!S1-mNKBMm68Հdmg[^pqq?fUo>cmimS>L>im܊&Ldmt(
ߠRKcmZ SKK[@vf]AA`Ft>}K{K r1Kw%y0r
 "cm6x҈0EUKB h6bKdhEYQ!UR) `* aӀyQ	k 胢|pt1Kh[L!rL&jmSKimLfPSQзKf3fY[fR~Kff3 0pfZ2F E *  <FuL3t	 Dt<Hut2Ot~O >߀$u tPaX]L Y7K uB<Ft<Tt<et<t<t<Rw*<Ir&L
2@&tO߀>L`O4<quriVW@ξ HtAQ Zft(PǴ:Lu 
  gXfCYPv q9~ w2LkLDt& L8r >taRw
$_^t0%GKLK IKf? t<CpR<tSQLذ&Y[ـ u
lqpJ@I - n ig8   N`  85th
 \  _0  p I	 	 	p 
		
			 				
 

  fWQf04aQ;Y`f D5 ,+6]++sR (,+z0SD
$&++
ĈD
 1s fg&|5 EBr`jr  a`WfR))	\		MvR`UR		`RH?\
|*+
܉\*se7 bSQoaS͠ϼէ" cc͐Ăr`<͏͈-̈́}&p__W3
	#׿rgqWt0Y"@ fUԴj(rjd<,u6Dq=6UUUpfqh		1Yv		xvYbF
, T `&ӹ !sJ%|=?tdy%"y:ur?rpq!(~rg2oQVfRL	;t	PA蜵Ϧ=g}^A Qq0   0    RrE d    n  A` P 00 3`
  
& Aa % : 	%
!0 #
ک*!
 J
3`@& <a` "@@ 
b
	CPF
? ?a 	 " d  qa	!? $% %@%
J +3F	
+  (E+
3$ 4  C8$+(3 +-E-(C -0294- (`( E E3 .c+ ! 0
 @/9F.  7'GC@<6A6 D
!:7' "J" ,A!E?9B@,3\
O<bJ# 
QT SC<R"G 3D@%M TVaXCJ UK8'(XAIc  WI Q^_^`FaaAbbCopyright (c) 2001 Intel Corporationf`@ f.5<t<t$<tc<tK<߅tS^f&^2c sf^   uh   uRRfADf3w80=ISGuђ s
g]^!t f6^	ngftcRa tpt5H0c @{u  u u0 ߰# 2  P f%lᘅ3 
f>_5fDt	u)f5%;5wuf@ffhetffi"Qtpѣ
0f1s
B  fv@#tz21裺0!<ug
X

7	u\	Q	7'h/%_5Kf65	g u%S F5 s@[%;u!,f	=4R0	ffx4	)ffp	Q(f	f@f[aSfSfQfRfV*sW2c15 uBT tApN@76g8~8fI4g^f3f@70	@7f^fZfYf[fP"Vf
ߞ5f=`Bt"f=Ё &f= 0//f=0 3f=@+=t8t34 , 't"#
tt?f5c0 rfF?P0{fXURf.  fXr  	 QfpoufQD8@M T?R2@(2Of2f0IcBZ{RO>V\3h/a+( MQ  uf3^fbDf6~E  Z<tatG@]_ToKg<u	.upWJ$< t<0t$ RHP?yZ"PWT%j_uPlAP#,RfWPR;5rf˹c%1f f>a-	f!Effg8u#>_444
f9@[Jf_,,PSt{w&.1=`Q
Yr;f.;ft3Uuff!mpf|ffm fPtP= v	 +v?:P,P}ff́   :fofP ̠ 6f1|Ã tL;f {ǰǋ;Ptf Q.fB	r;rf@u0`b h+^-Ñ?a	r?ffqp
C	f`f"0~ffROMIfMAGE@;uq Wt#g}0 yKPQ (J 2 ofG f_ZYXug&wag&GwG0l  "2/t"t  V =  cu'[0i&w j3
G94g&GGfޣ fCf-+Ӹ00pD;gf@ h쀀1"1`W,+ `Пؒ..`B@ԑ
>t1a   # V  P A :Pnj>jFjNjVj^jfjMSV.>bm tvJj^>Q PSQRVW>vjujSRP#u<v
@wj,xjimujʀ 7UmG r ) 褵!ujјP込S	%x
vjvjvj:?ujw/:jP
 ghN/L	c t3Ode
	jjrg&0tRj觿}rZj莴dWr!"BjuKr
 JthE	/CZp4tĳbj&=q2ohs13
	ucmP $cm} Xp Z#,莶[$$_^ZYe**	Q  s!   0  " "2ѷi2 /f+Ld 4'=m$7g&;* 	uwjwj w@MKm &Emݲ`J"p,g@vōp-_s0D0oKm,=0$ 03۰ {ɀ%1Wu> &
'$udmuvtueu^\uMu:8FPu)tt~fu,0= ILfg&8!<u	g& `=FtF@sPVS`@m蛱O([^XSRVmWg^$__C@ޕ14ZbUf%0ѫk$蔴[]0)R ZoRU  oP&abpZ&&FdR< u\R\RgtXr),u@TRG`SQr9R'$8t܋Ytr$V簄OHAr(bgFr(!sq{trpm@ppoq9``æ  f18 f܀g'0z  p FFBZss`b PQfWfVӝUU~*ЌvP U hX+RU'UG@J  .;qt3_YXhw5  `#`Ⱥ0@	up0 A"' J@4 "`".im2'?.q q㐰0 0!W
sfUgg& suf3Ɋfа ǯmtfYVfWsg<t,fUgR r!8tfG^fZPQ1$@a@8tPQqUvPKtF X PS2&8tp 6t؎[XPS~R8taAf!.bSRغ Po BDðð1                                                                                                                                                                                                                                                                                                                                                                                                                                                   /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               - ,-./01289       Z `a     3 sRRFa` $a,P~G3""
P![2t*:aÜ`>@ l>0l!GA lBla6$?C ! G @ A  B  $0sF  ؎v n _"v   BnnnJF$a %JF P  <  tq ̢ P  ̠̡t ޢu     llB  ؿ/  lBB@_  l@    @ lr Тs WN?&O 'f l  /$а 
@  
FFnK  	n	Un	n	n	n	5n	nnn 
 r s  t  ca  ACd̀E`  |3nnC q
^p		 nA
` nta4u4aPfW@ f4g&g&f_X'=                     S ӿ%0FLɀ$ tXST MtS7% u BMK aSRP t@B u$Z[SfQWP #Xgg_fY[f`Q
`fgfafQRfWPSf3f3ɿOf0<  P tPf; X tDtN[Xf_ZfY<fPffffX,fV>fVf PJE gf^! f^	V					:		N	^		[f	W		fWf	_
g&' f @f&:fPSQWV!  tOъ##"A$#hfP u	fXc  h TQ lsY^_Y[fmX>uD`臭t跡`X X3S'[C vS3ۀ> tVt't:'t{C  [0Ot<w>t8t,>+訬
 
?.ñ a r t3C,軬 '.'쾊'
ìt r3[肒s<5fP@ &'r! 

A.	 fX`{gt

"3jgd
A
^ 0t1-b㋇'.fr
Rt0
s< t
t:@ `  ' > u蹫t' a  HJ 

pP IF } J9 @ ؃@P 2L
s3y@s߃i  Y 11F0JKMo蟪:Ju;pu;thprPs`us 0!  PWu0+K`{:u~r:Ȉ@&u[  OuA 7 &	&Q[m%0ww
2:rp	R
À
v ><  ]22 f`8P%AȰ#%z  t
ف     t1sPR 0@ZXW t(  
Xt
 %@  Pé t u>~0M 9  t`@ r3}pt%%tNtGcȿ fp|ff3{uԖ[fff#f  
f!]J X sà^R.Q#؁ W~~	c	%@Q# Y3#0Ћ!` ZY[0
x uiʳ # `uPo
 p=
 Pj%蟀t
z%fZenQ ص!fp f_#A$! 5 qq fA 
 `!qf@f0` qSP!3P#5u
=y1"qf'ZYfoPS4IS迩T T?hݏuu_sR^1Ar5   fﰿ-74O-gK#3p؀*@uRttQ@t
1
uf
dX@} fSfI!2HtEPG Fp  P+GhoN_t :Q j /d3 @G4g&tC@ȱr1ft.ff3A QA Т  u1 z dhQ)
  '  emimoh+a)f@$g#4h"A&} b
 babRp  ZPQu4 pyKqb pYR0Ri?m h":	
D2
.&g t#.g@XN' T
n.t&*ǃ0 0RVh7j|_BԷtDhhf5h1h7r2, f^fZf`s2 |=rb2 <ГfTg
hMfa_f`uX
<@`Pf3//?NPcX!7"" hoyܪQf`/)
4x/O
\ "	} 	 R"	g/	(	!e&!_!!!p!h=thd>v4GS	qfxߺf0&u 2Rt F<tvP$rf@03dtsfQVW 0 _^Y}Tf { Df1mffބt
t^P%SQ^ygfM5rSQ?
f  P@[^ЛW|WVhU?4r=ыt
 ou	  tt uʋ^_rfQMf:Eb3:EF c6W p 2:> u6 GH\o h!i/T3؋hB^_fZfj
XK̈́
>^
2

VT>T2@OHp!
Nt.
Orb~   ,$o,/ ,YaQo/ / /  O,<RwS2.A[ø  а

fQh*_fY݉щ ;aEf3ɋPo*p`0X&G     &Wft ffBf;Pgfwlw~rtwR{tpff@hDp3QgfY t?gho\#a$%AP0Y[0U>aPS 2hoWh`$2f[ t=> uJ *>p u0ihv_"˖tv;试跖t3裖tvPds t&
耔 0PX蘨>ſ tp 	d{u
[P
[` Ǻu9 5衙r/<t+t&Pu
$&}.-aq貕t"Qtq2t`g&G Q !t苓u茒)ʷuѶ>ʶw&}t z &  0 &  
$À>ʰ 
8s   
t V$<
v
ط  `
 tǀ>  t K
$
=ؐ _
h?aŸߊ$(
d t㋷$؊ w^рhY%

5d			
s	 	,Amu  &    >  u
8wpR 4
A "N`ff@Af   fOf BC?\0Q'  @/%dBPh p>ft	p'7f%ң \ @!GÀX<t<t<kPS$<w .# 
*"  T 6 PR0a#Z 1.a#y BZ s  ""
ZP .## Jq vJúBQ R ( PBX
	`ذ4ߨĝZ![QSW 0_[ $$$$$$$$$$% "  }8s %à@ PP  ~̀R ?ĺ,p:3%  !13*  o/ƥf 33 3:~?  h M (`v: PQW<u
湿y )w{p^_ 8+z )k?|"~	ð蟥h~|jA譻@1  @ZtpEu%h/4u Cqr>!r> u,[
PQ& @r@us
 
Rx~y& o-$۠P`v̠XâGա  	!  , 	% 
'9'p  +&,D( + K( 	oϵ	! ,% ''((o(+av(0ޢ f(  :)(% p0.&, J(v>脐wJ(J(2p,s 2vvcvUV<2u2 Pظ $
 yt[.ss>{%`se^]osks2 	?s()S rc`.)[?S蒛raC.t rDGou_p;ᗀ؀cˀAO2f.?f`7xf.q ^hż?4 1;@rCd. <b d= ohu @P4 hf*.b*=9@>h7j/uhdLPduuu&gq Pp  1[YPyXh!eh3LUvP^+F X PS&K+&I+&G+[XPSK+I?+G+#И/#h! + ++$q7zɳD'ktS8rdd`r200<dr
d2wc蚫`ޜ pаyStO\05ak0pߩ,SMq`WT 2HYo&`8`z`K                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @      /                                                                                                                                                                                                                                                                鿩!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( )(     ښ      g {`g  h } Z +  ;tp?    / W}6h mw7U ĄS          P           
%X%H_&                                                                                  Ϳ  `*} ` PzJQ@  U  @U 	@
U 
@UP X@YUhi j@kUlm n@oY { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`hfPu	fXc  h  fUf&af&>` 6a  !ŀX[ &SP`@ /'a&&@r
f3f僰~gf }f3fh   W@p h &ïf`f1fffefU   % ŀ-ff0M00!0)ffXf9ffa}f 
  fi@U] 0 m q  ,f5q fPeWP Q   ͡Ap  A` efuaa  !6>eߣуp Ń{ ՃPك"` eɃ w	
e} fe&` b "jeɃffefAffgd:߇ugdfepf3 gCT "8fF3ۊd߇e3 
td	  p) i@ 
peuxްu.Q_RTC u:/
<'
%&bfgfd.S` [WP9A`XP&EX% &E_=YǨ ooooǸoce  f`Fffut$up$Ūur쪺  .<t
../ NA NfafPSRVݾ5fprtU./tA
 NUN}2h?54^^Z[fXn34> PSWR/Qa>qK u&E q 7eZ_[XðhZ_gÀ> tQ/_
fQs]GPSfQW_fY[X 33 3?3øPR0B1Z 0B1淒3 $ `%>&2%	 
  3  t!  { _9 z &@u#92h2_xr}t0RW0?_Zw LM7	5'fSSR>1Uh?Af    f0Lfs$R}8 fZI%CPR|rfPۡTmf!`'yS'b'

R)	t2*[w.>*"s aPQRp쨀t hE/t
uZYp5' B!C
@h1` N H B!<06102* $ /fW 0O[Qg&?t"g&Gbg&Gbu Qq& ufAκ(/ 
.uf_ 5`mP    NumaÊa$$
a C PB B;ra 50ͿQ8&S/88@
,n0V:]* : ,
 Q2RW_ZP ,ȡ%:؁ Ëw34 gw&D4eD
 <.G   VUVVYXJ I 1U?Wh7j?%Dt$h>fYOYVd6@Sl`DDDtD (g@a HF@r[M t"s@#& >ǿtS ^h.f
$1!/f2f3f% g0(p!P!q  f@
10XX!!pafgff%lfofP  R
 `C  fnA"a `nPL\3t`# u8$Ou0	u,hTPuX(qt
*DSjyљ֙6ݚ"Gf`Aa  6&P&ޠ~`X v
``.pr&&r!Br  Pq X
䏀  Pf	 __}cX}10uff	<u <u r$Rr z&&X2qrr]rN a`z7da(SvxБQ` "" QYa?UP  r&&p'] Ob 
yj' P"S""F"&&a UbR ~ ZQRr3'H2't2 `2ٵ)w5 ttTZYa~r#S-ER-Y03!pٸq4  f & Z2 &r豂r8t320`.PO h?,啊tG[S@1?eh%[&M.2t $:Dp#h Q-5 ,W< t `,4fRh$2hfNt :Q j h1h<fZrj  pvw@5 
}, #!`e`	;A	2@;ahi
$%00`P 0S%-  D c`6(  ƿ  pM Vī^`WП 3 _r- Q+˸ fDZED;Հ ֻBЙB O B<`<2rruO0W2&*G_Y{S	 7&*,u&}Z`E]1j_[DAP`QFگ> P 2ۃ<OtY	B<{tmH777_rPBBLѯ: r1 r,q h/Dd8SQk
peat)|$<Pt+fKuhqiB`UY[Qrj @"	ѴuBanYoof_	V o^W mQfR D=F==rN|UtG_V Qk4^t1Vh_45fƿ^Df`      $B       _<@ D ` d h`  נ    ܢ ]@  `b U ܠH P X \HT?                      `        14       b(YL'0#` P  @  W  Pa !u( '     PXYhijklmno 	

                  K _,89:5?NNO OhX__'PfSfWebf~(sfgf&c@pOZ	(нf_f[fX`Drf[XpbVW fk Q  !Q i A!!ȑf%C`f3f.ff^u_^fZfYf"Q ء f|' C
f0P3XPSVWfQs:aqKي t
u ufߺfpv @uf  fY_^[XQfWfVff
 5ff  pf  f`   o<fd0t<$4}'pf^f_YA <bR5   ;f^>fPSQR#_ 3%n0%B@ fq$<s!锵 !PB@6G%<"**f GjF|o
sKf0$P
f>	@
 op/'B?<$
sǺ$  fޭ`5Xp4'o%:fZYc-9%@8SQ$w
 $
ذvu鹿k$wXu@$- @x+f_=  Ds ; Z x  p 0Nm[$
Pdu	q @2wXÃ&	 %_ H裀ȃI葀ذJ芀2ȉú,' ~'ff w	.h <.a  a-$tҽµѻ 00hsHYhrEsd/(#/FJo'*/"Yï9ghmAGf>QPH_u(Dr#1 >Ofp!2ݖ '?46-r(ʱQp% -ronUWp(>f  t ` tof߼ frw@W   _`ff!`2g&g
fKffRg&& gr=e hջujr}e+-`f>VhݟZ,

- xф r k sfbSfRj07W6uLt;wEf6ff8 r/fRebfBfPerf K0  Z`fWu
 a 酀> PÀf_f`!u? t]ǀ t
tAe@zYf?
 :N  !}(! _ {f` ; 6f<rv`gGwf3Pz fˠyffPr: > ff{@;w!fVg&f^ufFtfafQC3$pf_t󰥥Qg&0΃908&㿲pof=ATADtlf q:&Ǉ qp s  S3a  zbց z1 w 0z3Ɋ yj qzUFWP
 XUu&.߀>:   ub >u `	`	yt=p$l0yyP$yC#	


 @`W3  dt1fMd YݸP`A BC_.fUf.6f]fU]aeaa** End SetActiveDisplays: \ !$Tt5< ux )ڊ챸 8t  u
8ud a9Se[00t@uSQ2t7~:P  _x@@ p#t}S Q<u
  u`Q 	
30p  D q t1
S
L_
 ߜ  Pߌݳ	 ޳]e`ߠR	X޳9 SRwRoPkoP %p`jo[oċ؀̿ ZoXRoX8opNPSR10+#	oa\nPab tAnP ÀnXn۠ nQRPS [X"3t英 z  
\U  Hp@`6
u&jpr
u02,RW_Zr&&&E&]ж  ?faP$<???M=E>@. }SQWU]hWPAXð PR Z} .a;tH rX/t A`ft,` `C_S]" Qr f $~ >Pָ`Xp!rpC f_`uQ`Mt'f ITAfgfP 2gwaYld 
0`tXlW
Hpc=&M_0g.g͵ 궃? t0;r+gCC Ps>GPhi0BaArJ`P!uu& tQ; Py Pf pԊ6?`Ȏt @.d  w >`^QOa8wtY*_O# Q;j<.uO R%K0f	
1
fpDtzl? 8 Atu p\u3>u#Q?G`
u"Qh!9u
3kuC*u?sr'p !lru#itg&O{N  r  1OCk0`uy֣>l  !{ĺ@,fSIMWuUf عfPr޹fAf1f;ڟw(hwvrap 1ð?SECUQCuBfӐ1Rǹ 2(`X?fGPu(1_-p$8tߧT q Gt+Soh
 oTT<tT{oA:zohݿ
 
_ʻ@  G5 -ffLw	Pl& t
W&f_r2e Y$g& ဟg&	2WVWfGt0bt2t~tyf m  = f'>@,x( @ @ u_^u  rFf;r> : t, f    ur%P~)rQY9	 q8V  %@t`A
A!:0.2 r&q
"

rTr ~V!rP#j   t
ff;tw;0
 + t_ D@@D^@ =?hO,9hfNt k:Q j rwp	߾	  u ff!` B
fffLp 


ghghNRF1
a3`"~t3 v'%hN9GѺfwQV1
P6<t12:u"FI1()LD1' E-fY`7@g w.	A_S 
fUfp>@	 _--

~
f+>
B#f]^R)""w"  ,gbXvI? An>@u`$f!Q %  
s`_#_#_#ZYcUTp>vfrg@)m*S+r< Ԃ0`PPQ>d uι c r\d`dYCtCd>r-R`w  r0Ҋ1 r
-u`d/ P rdItf s`QRpy0ЪNr&Kr! [ww3r r	gPPRc0{pr 
 Z{PQq	s
d Sr	rs!V>RP   dtg3{uwR Z +}hk-C ZXUR. PPQ " Y  2  p,u QP hE3R밍

Z@u@Sذ* o rı=` ္] IQ oRWR  rPP3DC	 4ïP>S t33@J*0`Rމ
t#4 c ttpÈXQRWVŹ+3"~a^_Z#"#31$G<u
t$V 4^W _ 	"  !(e
Ź_ 	
R
q0P#H	
g&/ܱ1q;-r;r;x;q;PR(Xó J2Zq 0[RVа$rN ;rCr<,	r32;trr;w tsڋ^ZW
   е0u
˾ШBu P f~ uf(2 J3322t@@ 0~ 	rn
$	"
upmƋ߱d;sRZ3QFqF2t
2t	u˸
S_ø
_..P.Q.Q.Q.67r.Y.2YDذVPC`D]f #g&   hpLtfPfb` ^CuGfX2XU øD	d dpxx)pv<	< Q{}>C? "zBJDF2FC 
كIڈ#
N ~fqq f+fMܿf-Ef/ffqC  f>PAMSuff>r^0wS0p(Pø`#X> fɣ|	! f#SIIWV`0rY  E`/fP < u s󤏢orfcQ fQh1h^`b
h7jt.ԜrB  ؾ@
E@u@
Pe
`mGft۸0!0 I"a`Ej uL$<tD"QHr&=t&} tV" &GF^YՃ"
\aþ0 ?	 hy+ϳ!
9 



Z
P
	





	h@gMLொ~̀RȯRغ0 t@ZгB 4 <  <2<?
 1ꀤ_                                                               HUPRPRVFZX0RR3=0ZO                            x  5ȌȎP ЍYߋh}3 u<
w'>pp'ub w	'ñ03fPS> t=u7 u1 *<t&t!uVr0`r	B [fXQfWyLtZgf&gtKfVr3g&GȻ spw0ar$
} !O 2f_YPLtg&G"r KtEtQ@ 	
   VȾ 8t"8tr;2^WSQw^Y[t,&
uۢ>ut
$6sE ?t> uM"t$	&
sD
tFڠ	>2
X*T@$t% I
Q`4uf0tC P p< tf &$  
` uYߴ&ۑ> ؀
	 >t Lt00P'u@g *r$@, Bt>1u
 胿dA ) (r"/t JJ]SQPXtV
r@.pSGjItB0T0.7r,//Y`6It_6etP 	rB3_,s6u%
u O"7H6 sRE6Atzu Qطcبtb;sW;sa^Qu	Iu u"
uߊrڑ"߿
238Q,.  à.dt b* .)P16tXSfW0`
GtpD_8؊f_[&֖ǹfsg]  r
î,# fPRfQfSff%|h f
 1 fȺ4Aطf# uOf3\f `(,#%9tf!!1 f0 t0f.f@Ff`f[fYZ0Z! R` [ݑCfW @ fg& u8  *tݩ fqlt	5f mf_À f] p<Zu?FrF /<E@ h^Nt +:Q j f
`qs =fpa$
w
0
:ckt/f@
@# Ƈz @{ D 1údߩ u"AuCO "    t 	Of@ @ !b1@U	@g&Nf@  % &!#&p`sR%D0(+1#Q~Ru-f#f %+iރ8` l$B' $ 
 f 3 Q'
f~
ސZS	*
 N'α'~p
f1f ޠ
s!=qfYfĳ &_ A%#@|3RS؁@˅!^SCVq#t6D8 %f&ȿ fڿfP]t33u^ Zfp
0jR3һX3t@s7rS
`'`' h%Zx@g! 
 *K 40*ZT$BT0	f%0OJolÖD&$b P1T؃?2沱1B'pRfZa`1غ   nBnnntnJFn aS ˻[ À 37!C &?!Cu3R .Zh*fP 	fXc  h f:{{ƲXj]]H&::;>&g.pu	 muQ %FP
 ^tPFtǬ+t8QWP3 PhX@.X=X@uX_Y߰PDup$ q!桐.$> u
P|H@Xu6C @B T ASQgfsg tHfu.g :f`tg&ffw(1(`2ffߋgffGf<<(.&gfBfsDP
h3!!
#4	fRc6U t q

(
uX-O0fMIQHBf   ti@GV軼p Up he,zaRߋÃHt%tg&g!g?g@of`MRft9tg>E @9g5CggfVWf),g>E %^g> !Pq'^d`g
ز
U".   #bOf "Q1` 1?YaA,.028 <$ 7@`' &F 
e| 8ƻ6
.K`ۺ  -  q&Ϝaiu Nx  
| j0 ;tAR~m cmPff}X ff݁пocpః0fa  Z!` ?
a1!prR 33#|fp<?f
 
v@f b}%\h{a# =(p<@  u  R#rS׋a⩋f HCthC'cRѱQa!% = u5
== uu=  a`!gf㮰f#b 9~8P3	<HA!+ 񳂰rbߺPѠ Q   ,A048 N@?W/$9#5 A C0`Ȝ 2hD_foֳp3w Pf4f!➸Y zAt[fp2 Q7t2 ty,fP _$!$i!RDe'ç'1f' лIZq   iPQ Ềtu
qYXPPv` ؠu 
X`;؎Rf쨀u Zlf)ap.n @@(00	kEf_ pǡ D  &Et"D  $D( s`ۊف&tʀ 4>2@"Q
g&Ŀt
_ 0HL &}u?p ?u8&= r1	&
IW$Br P
` 肐 m  m qm p's t0 _ aװr * $OQa	 &? a1# $$<@t"hXO=4KuK0Kuף`.>*"st&3r	&*1r>m胣{xaô`prr X ? tr_Cr0}qw1#!8Q909$?蹪a0){fRQS>[YfZt'0 t~ 
|  .ar0P
RADȁmG>Pv Pf  hruf>覾rf  jf j`r<fffHff#f+ִ f;wfa3oS ec
uff+f
  ú,/ ,(.w9~!Z| Y	lK E,V_,
	+$~,"c2D,)>Ȳ)t iʺ, ,
,b,,&,,,=diƗޠ	}D;f. +!u<u<vw2.А;f}&@ Sذs9r9p'[fSfam;xV4tpw? uП_&[ff[8ø 8p'`^!h...6l" !]2R'fhfLs"Q#8@+.h g\r0A@fP@.C'H6fAlqVm	sdrq
=h1hMy<s6Gjhi=IJydPD@ hSsxW`"D H.;ȧt_fY0V0&λQYf^ jR5_'ClRQ,)Zhsӏwq4B+ràq"G5	  蜰k ݊P5ĳ7PP6Xu/BBpD/ح6b5S!R^ u5 |5?*/2P x5X	S}5@62[`P2
tˀa	5$

6Àu!5<X[X þߊ Qa5؀ߊa
5߀2̀  /Y@<KrKKX
03!4+t
3NO+t3GNO`UNN?쪺P ^RSRo``FPS                                                               
,O( $d K             p                                                                     G  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  x68DTA   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 iys谂 f    Q?sY 戰f
   ff    f   tf ff
  rfBYi戰Yf3gC &f3f   戰 fHr4f f戰䈰xf戰 rfFf    戰戰3{f  f   f戰fSf[f   f   3f   f  戰g&fFfCg戰{}s 撰fPfSfQf   fQf3یff
    xfYsfYf[fXSgu
  ;u[fPfSfQfRfWf   f3یff
  	 wfBf    f3g}
    fg
  r%fG;wg}
  f_fZfYf[fX  fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   (fsf ff   fT   (fsf wfD   f @(fsf [(fsf 5)fsf )fsf c1)fsf MG)fsf 7])fsf !s)fsf )fsf 7)fsf )fsf 3	)fsf 	)fsf 
)fsf F
f   t*fsf c
n&*fsf xX<*fsf 
BnnfLg&nffOg&fffsf fsf f   f   *fsf f~fs*fsf ef   *fsf F<|*fsf  6*fsf j
+fsf +fsf -+fsf x=+fsf =f   tV+fsf f+fsf of   t+fsf h+fsf +fsf S+fsf +fsf &f   u+fsf "+fsf +fsf Y&,fsf ,fsf )'(,fsf L'8,fsf 'f   N,fsf <wb,fsf 4 f%"f   t
f>Agf  ,fsf {ta$f  ,fsf ;Ff  ,fsf Df  ,fsf    Iuf  -fsf f fsff   f   f   P-fsf tff Ag&uf-fsf &r8u:-fsf &u$f3f   u
ffuf   tf fsf   -fsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  t.fsf $f  .fsf i2Df  .fsf rf  .fsf 6   Iu f fsf   ffuf
/fsf %tf   ),/fsf $8uf   uffuf fsff   ftLt/fsf $f   t$<t)<t//fsf $ufffff   uf fsff   ft(
/fsf 8$<t<tfffff   uf fsf   t8f   ftF0fsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tTT0f   1fsf $t<tff @   f 51fsf "2  +O2._1fsf "<  ff   f.:w .D1fsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2Tff   f
.f   2f   f   ft/2fsf !< t8stff   uffff fs2Tff   f
.f   2f   ft(%3fsf  < t8stff   uff ff fs2Tff   f
.f   2f   ft(3fsf  < t8stff   uffff fsf   f    ft'3fsf $ $t<s
f   <tff   ufff fsf   ftT4fsf uff   uf fs2Tff   f
.f   2f   ft($4fsf m< t8stff   uf?fff fsfffsf fsf 2Tff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%_f   t_.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfT2.<u f   t2kf   uff   u6fsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   37fsf <|f`Agf&   f    f    f   r7fsf f    f    3f   ft7fsf Ufft7fsf ;fft7fsf !fft7fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   8fsf <|g&f~fsf fsfLf   f3f3ftr2f   t8fsf Qtf˰8fsf 5<	rIа9fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx_.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8_  f Lgf&fftf_  f~fsffHfuff Lgf&f   ftf@l<fsf f Lgf&fftf^  f   tf^  f^  f   tf_  f Lgf&fpffHf   tfHf~fs<fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	=fsf fBgf&=fsf  =fsf  Tff%   f
fHf   t
.f@Cg&Tff%   f
fHf   t
.fCg&fKgf&I>fsf Ff fs侳Tff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsTff%   f
fHf   t UfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}_.fDg&(_σ.fDg&.DfDg&f3Uf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`[f~fsfffsf fsf f Ef   .@ fffsf fsf Xfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_Bfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
_fHf   t_fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	_f   t_f~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H_f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fH  Hfffsf fsf f x_.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|_  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xHfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfT  f Lgf&f   tfT  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+`  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk`  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            D   @    L       @       H         `      T    G R         	 	
     X   	 	       	 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D     X      P    D    X      P    `                O    O    
Ol`

Ol`
Ol`	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <D	     <D	     <D	    <D	    ,<D	    ,<D	    ,<D	    	,<D	    	 T <D	    , <D	    ,0<D	    ,<D	    ,<D	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                                       	4 @      T                      d  ` h   X  ?     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<D	     #<D	    P0#<D	    @#<D	    PP#<D	    	 #   !    8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < fmf%f  $f$
t)ppqtfKmfupppppqemDfqm{fupppppqf  f  gffLggf^gfnf    f
   "靼fm!fupppppqg- fmffnff  @$f@$
= u$<& fDnff  @$f@$
и f  D$fD$
аfnaf% = ufnEf fn0f % ugfnfU../0./.fnf d< ufofd< t<t
u掰fAof䎊fSoffeof掺<ufocf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fq  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   fcfr  H"lfr  <"對 f    < tg f   ff   2fff   ff3~s.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2s{           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE                                    	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ftt vugf&>tgf&6f٢ &fE ~f^Y[fXPSRfV tA % g&ƅ    f  \g&  	uf^Z[XPSRfV tA % g&ƅ    f  g&  	uf^Z[XPSR     qZ[XSR  zC vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $f+f3 f	3f7fff]X t fff3 f	3f7f  ff+f_f^fZY[fXRfŋӃf3ӃZfPSQ  f¢A vY[fXf` f;.t
f.   ~$C vf3 
 f    fgf&E   > uF f˃  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   <  f  g&"  @v@ g&  s f  > u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Ԋ    戰䈽j戰䈽|ݰffڰf)f3Dܰf?fI߰fUf_5 f%"fwufoٽܰfYfHfCf Aݰf+f˓ܰfדf f
   `"	f   f3f30f  0ffuf   f f    0f  f f   0	 f%"fTff.Ԓf.Ȋ f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.ڒf.Ίcf  
'jf  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      PfD   FOUusO M 6
Z  >MrfZgP  P ( rZ  .PZLV>ZMZfQfD<>Z3ZfQfHfHrrfHfDf>D wfD   >ZZfQfH%fHU3fHfDf>D trUf>D wfD   >ZZQ/>ZZQm>ZdZQff   fF>Z=ZQS,>Z#ZQS>Z	ZQfSf ZL >Z ZfQfH'fHUr$fHfDf>D tUrf>D wѰLfD    ZM} >ZurZQd>Zu]ZQRZ	 D>Zu=ZQN/>Zu(ZfQ 'LZ]  Z>Z	rZ  KI	s 撰 Xü˖){ۗ+<ϘݘfSgf[gfPfR>Ouz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@@
 >O u> 5xzytsfZf[fXúz.yuksfZf[fXPR tĺZXfSfRf@@
 >O uB ;yM@t&s(xغz,y0@u	sz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  vɃ  f˃  G 
f  ՇfaPSQV0L	;t	 @ ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6Ƀjs>t fafWf   g&D= g&D= f_`r r8 a`f0  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`ff   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f> gf&D5 gf&fff>fXYsufa`f@  & gF
$
gF
f@  sF>tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f.  +   fB     fV  j  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_ZF֥`F֥fPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇Ģʢ¢[XPSQRW0  3=  3/  3!_ZY[XPSȎػ    	   !    A   f   $       [XR Ģ# Ƣ1 ȢZSQW   l_Y[SQW   W_Y[SQW   B_Y[    f  fp  fPQgf0& YfXf    gf~gfNgfVgfofPfSfQfW<w f./
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .<t ø fSQ >Ntf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f@p   rg<uf   ⃸   Yf[fS>Ntf  r	f r>PfSfUUgf*gUfUUgf[Xgf@   T r
g8u   f[                                Q  YPSR+;wZ[Xf>@ tf@tf`f  f3f3f3f @ gfffCgftftfaf@   f@uQYfVfSfQf
   f   fH<rfHfYf[f^fQfWfVf @  f   f  gff^f_fY               PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{fZf[fGfD    2ø     "  @ c06/06/05DATn