#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTH)  - Linux-Based"
BIOS_VERSION="F.06"
FILENAME="sp30664.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  tz22  z2 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  z22  yp2 Y  8DTD   BIN  0z22  22    8BAR   BIN  KG22  U2    8BDD   BIN  H22  cW2    8DTT   BIN  b022  2    68DTH   BIN  pk22  WW2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZYY  @  
   _             
(      C   
  `  C            P  
          v  -  Q  t  c  Z                y  S  =        {"  u"                     ,
 ,
 ,
&  &  &  |&  Y&  )&  &   
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
B  A  A  ?  ?  ?  ?  j?  D  D  sD  B  vB  ,,
,
,
,
,
,
l,
N,
$,
,
,
,
,
,
,
d,
F,
(,
 
kO  (O  O  O  N   
\  \  \  \  u\  _  d`  `    G	,
,
,
,
  v                                                            3Ðj茏ː
  F  F~ F F^Z9 uvfv%}fvfv%~hH	h jKRP蟊Vtj
fvvP輋
hH	h jL`RPrVtj
fvvP菋
 Ð3f>\  tf6\  f>  tf6 
j ]胃  Vh jh jth jih  h j]h ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hl ǀF^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPfjbRP芄jRRPzjBRPjj2RPZj"RPJj	RP:j
RP*jRPjRP
j
RPj]NFF9F}-^v&&?-t^F&&?/uF jYZ=sjvtRP蜃j]@YtjwURP}jt]>V   hH	h hl bFHFuj fh  ! h(
h4豈f6Ffh   h(
h4tbz f6FXafF    .^	| ^&04^&4F~	vF  Fz 9F|F= t= ujRP谂j\BYXfh  j l\ ^ \ ujxMRPujl\i
>R  t5C  Xt( !  9  =  A  E  I jJj1fj   ujxRPj[t(`       ؎f&fjvRP豁j[>P  t>R  tZ  X  L  >Z t>Z u& & & >Z uuD>T  u	>L   >L   >Z u3T Ht	HtHt8j uwjJ-ulj?j.>Z u?T Ht
HtHtHtIjj AȐj3u+jRPˀjT HHtH
>T  t7>N  t0fLA  hLhLj#}
>X tjJRPr>J  tj \ZhD  F >D >P  t>R  tZ  X  L  >Z t>Z u& & & >Z uC$~ tfj fj ,F  t=HtkI-
 -!- - - 
tFf>  ~  H    6 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G|&Wpfj ?d     F >J  tE<KD B= M- K- '-M- 0- )fjF6>J  tp
j 6X^ÐU	^&H&JÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&ÐL"N
z hthLhLj=>X2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP襀
3Ðfv T  Vfh  P FPՀfLK  FTzhthLhLj}>X t3^ÐFPTwBFVhH	h FP@~RPhvhH	h fv$~RPhb vfvhb Hv ^Ð  F4F(
L"NFTFzhthLhLj0}M*ÐU~uhH	h  Ð~ fh  `hH	h hb YFHFu3Ðf@    
f@   ff9@sVfh   f6@fh  `f6\ Iu*u%f6Ffh  f6\ Z= uF&G
 tf6FX놐f6FWA~ uhH	h 3a     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP~
#fh   vfh`  j f6\ r
Bv  WVH	~" f~ thH	h FPRt~ FPu3^_hH	h hb WFHFtj ff-   fPf6Fv
f6FjFPu
f6Fx~ uF.~uF6d 8Fue 8Fuf 8Ftf6FVkFPh`Rf6FU ^_Ð~ fh  G.hH	h hb VFHF
f@    	@Bff9@sTf6Ffh  f6\ V= XF&G
 Kfh   f6@fh  `f6\ )t!f6F>Ufh  `b^_Ðfh   vfh`  j f6\ \U     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP${
FF> tjJj1j f6 Z{jhH	h(      RPz
6 h(
h4     RPz
     ء^ +\  &&W    f&        ؎f&       ؎&  E&  FF܌VF X   R   Z   fL
S hLhLj^q
>X u_>O@X RfLN  fP    FޣtFܣVhthLhLj%w>X t>MuR   hJNu~ tZ   Ft
F$p*Z Ð&  VFF܌VfLD VQCzThthLhLjv>X t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	L&LZhthLhLjMv>X tjifRPs  fh  ! h(
h4xj=RPUF  @ +FHuF F^	&4,x(&*(h(j*mVF 9F}j zĈf<t<uhH	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>X  u#jIzRPrjJjRPr3ø ,x(&(h(jUh~tuÐ  fh  u3fF    fFfff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "h(j
TjoRPSFF*;s6PjNRPSF*Pu,x(&
(뫐,x(&
(h(j
}TjzRP!qju,jCRPqjDRPp>J  t`hhb jRP-SÐ  fh  h`hqt"jKeRPpjLURP}pjyCRPkpfh  ujEF  h(j
SjRPRF~uJ~FF*;sPjRPbRj F*PNu,x(&
(띐t~ F b,x(&
(h(j
RF~sF F sh(j
RjQRPQ>J   FF*;sfh   Pfh  j f6\ fh   F*Pfh`  j f6\ F*Pj&RPjQj F*PVu,_(&
(\h`hb jRP)QjYRPjXRPhH	h4 	QÐ  fh h`hMt"jKARPinjL1RPYnjyRPGnfh  ujEF  h(j
kQjRPkPF~uJ~FF*;sPjRP>PjF*P*u,x(&
(띐it~ F b,x(&
(h(j
PF~sF F sh(j
Pj-RPO>J   FF*;sfh   Pfh  j f6\ qfh   F*Pfh`  j f6\ F*Pj&RPFOjF*P2u,_(&
(\h`hb j RPOjYqRPjXgRPhH	h4 NÐ  F >Z ut~ thH	h< hH	hH FP.hhH	h FPKFVu3vPfh  f6\ |K= s^&G
 tF  fvPJO>Z u~ t	hH	hT hH	h` FPghH	h FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6\ FPy0F~rhH	h hH	h< IFVtvPfh  f6\ QK= s^&G
 tF  fvH~ uj/RPLhH	h< j!RPLF*  F xu3E-t*t~ thH	h< FPej"hH	hH FPej#RPFPehH	h FPIFVtvPfh  f6\ H= s^&G
 tF  fvG~ tj$MRPK/F~  F oh(j
LF  h(j LFj$;F~,x(& (܊F*PjRPcKf6\ FP/FF~s#~ t~ u,w(&
(tFPFPj%RPK~ u~ tjjgRPJF  F f6\ FP).~uPhH	h hH	h< GFVu3vPfh  f6\  I= s^&G
 tF  fvdFFÐUf6\ FP.Ð  F u3F F~s7F*PjRP*Jf6\ FP<uhH	h2 JhH	h hH	hT FFVtvPfh   f6\ BH= s^&G
 tF  fvE,x(&
(
h(j
JF h(j wJFj N*;~,x(& (Ր,x(&
(h(j
+J~ ujRP%IhH	hT j!RP
IF*  F u3t~ thH	hT FPQbj"hH	h` FP<bj#0RPFP'bhH	h FP~EFVtvPfh   f6\ yE= s^&G
 tF  fvMD~  j$RPIH9EF ph(j
IF  h(j 	IFj$R;F~,x(& (܊F*Pj[RPGf6\ FP:FF~s#~ t~ u,w(&
(t~ tFPFPj%RPG~ u~ tjjRPaGF  F f6\ FP9u3À~uLhH	h hH	hT DFVtvPfh   f6\ rE= s^&G
 tF  fvBFÐUf6\ FP9ÐU  
2

 UvV>
Ð  >
vVF*^&F^&  >% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2F>F 	F  iÐFi  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRhH	hl ^Sab~uvvhH	hv fvaÃ~P|FlFFPvvhH	h fvaÐ  FPNQVRhH	hl fvavvvhH	h FPraFPNQVRhH	hl fvavvvhH	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;D}DF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FDPv~ 7
FDF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>Z uFP_!ÐFP>Z u0 ÐU>Z uFP+ÐFPU>Z uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh4FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh4vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh=htLth=hِ 1= t= ut Ӄ>X  t fj h
N3  F"1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 "Sh>h(*F*P̓uF"z j h>h( j̓]FUtKjh̓h(
hb j h@lfj hG=th>h(EtÐh(
h`h(
h~&u{Ðu&{ÐU~ u h(
hjhHh(
h`jh7F  F~ ujFÐF Df>   FXy j h
@h^fh  L΃uF  Fff   ffffN*+;=|;s7F*@N*1 XSh
@h^j F*P̓uF2uF~ u~ X1 F F~sF X1 F cFff   ffffN*+;t|;snjSF*PShSf6\ Tڃfh   F*Pfh`  j f6\ ڃF*@N*1 Xj h
@h^j F*P	̓h~ tfj h!F\  fh  ̃h(
hb !fh  ̃t"h(
h`h(
ht";fj hE/fj hb=uuh?ht!h
@h^tfj hrU~ u h(
hjhh(
h`jhF  F~ ujOFÐF Df>   Fy j hBhdfh ˃uF  Fff   ffffN*+;=|;s7F*@N*1 ShBhjF*PR˃uFuF~ u~ 1 F F~sF 1 F cFff   ffffN*+;t|;snjSF*PShSf6\ ׃fh   F*Pfh`  j f6\ ؃F*@N*1 j hBh#jF*Pyʃh~ tfj hF\  fh 5ʃh(
hb fh ʃt"h(
h`h(
h聻t"fj hEfj hb=uhlBht!hBhtdfj hÃ>J  tj htD D   1 ~ uj߃FÐF Dj Ճub j h EhtF F~s3a F*1 j h EhFPuFA j h Eh|he>Z utTtMttFj t:hlBhCfj hb=th EhtÐ  1 ~ ujރFÐF DF F~s-F*1 j h4FhFPuFA j h4Fhh
또>Z ut>t7j h@wfj h=th4FhtÐ  01 ~ uj݃FÐjӃuÐF D*b j h Gh6tF F~s3*h F*1 0j h Gh6FPuF0A j h Gh6h
c>Z utTtMtFjt:hlBhafj hb=th Gh6tÐUfvhf  |JF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
|NJOÐU*FP|PKJ*PKÐU*FP|PKF*PJPwKÐ  >x u7]  FVL;Vrw;Fv	x ÐFP
uh h Ux  >x u
FPh iÐUx  >x u
FPh IÐUFPh 9FPh -j>x th UFPh FPh FPh j|MÐ  >z tRFPh FPh FPh FPh j0 h l<uz  >z u&v*N"FF FF
FPvB|JÐ=tw$-t-| u)~  >~t% Ð~ -t-t t-0 t~ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U~FPgÐFPtHtÐ~	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  p h FF )fF~}j v`tFp  F~s#>p tFPh F  f+fF볐>p  F  `>p t(^&k^&?tp  FfF~|F~s>p tFPh ;f+fFҐ>p uKF~}Afh   j FV^& ^& h.p F 닐FPh j FV^&^&pÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h rfh   FrPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~urPh Zj FF  	& FP*ătFPh(
hփ~ thH	h
hH	h
FP3hH	h FPUFVu3vPfh0  FPLfv4FPh(
h`kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhlnfh\  hj 6lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6lhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	& FP貶tFPh(
haɃ~ thH	h
hH	h
FP&hH	h FP	FVu3fj hvPo(
fvfh  FP	fvFPh(
h`ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû~ |Ë~aË|aUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..^f^gef[UfS..^f^gef[UfS..^f^gfeff[UPfS..^f^Fgef[XUPfS..^f^Fgef[XUfPfS..^f^fFgfef[fX                           UfPS^tf3ff^  f.
_._ "  u  $" u [fX 0!<s3P˿(
6 + r ׁĞsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6
+3	O3X 66666נP.`ظ MaP.`ۚe  y>	uXP	 P(
 5! %J`!	)&6, 		3	sx		 	&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
8t 88z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï  <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  & U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV 
;t@t3_^] UWvt 3I >	u	@!_] SQ |QP,[|Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UW(PFPvv(PF(PWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuG(t4tLu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVxFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWv (t4t	LuVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.~wpsZuZuZu>wr>w>w>w>wJuss>w>wp>ws>w>wr>w>wpRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] yy4yhyyyyyUwVW3FFv&vF
t~ }F, <Xw$ FF.xV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uumsWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
~FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>z tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uwuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B(
&|=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WVX3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWV(vv&(PF(PW Pvv;u),x((&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3(
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	8t	F3] UFu		u { rFGFF3҃vvډWNu(t$> uS#5![j#%!us厌ʻ 	FV]U컧 .8tK
Iໜ	]PPR.`؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PU(
ء	F	F]XSQR(
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغy$%!3]UWVRQSP.`ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;u΁t΁^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    (
              4.63  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   H	                          68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) A  + , Z?  . / TD  Z [ D _ ` E c d F f g G '  (
 ^  (
  D10/17/2001  O                                                                           H	 H	 H	 H	 H	H	VH	H	H	H	(H	ZH	H	H	H	0H	LH	jH	H	H	H	
H	,H	LH	\H	rH	H	H	H	H	H	H	$H	LH	hH	rH	zH	H	H	H	H	H	H	H	H	6H	LH	TH	|H	H	H	H	H	H	H	H	H	H	H	H	H	$H	6H	JH	^H	tH	H	H	H	H	H	"H	BH	fH	H	H	H		H	*	H	:	H	L	H	T	H	b	H		H		H		H		H		H	
H	"
H	F
H	L
H	f
H	~
H	
H	H	
H	
H	H	H	 H	JH	LH	jH	H	H	H	H	H	&H	2H	8H	ZH	H	H	H	
H	
H	2
H	h
H	
H	
H	
H	                                  E    F    B j V(
      C    D    B j t(
      G    H    B j (
      K    L    B j (
      O    P j (
      N    M l (
      I    J    P j (
      -     1    + m (
      T     Q l :(
      *    1    ( m R(
      R    S     U   
V   
Q k p(
      X    Y    W j (
      0     1    . m (
      ]    \ k (
      a     1    _ m (
      e     1    c m (
      h     1    f m *(
      o    p    q    r     s     n j H(
               Ta                           _C_FILE_INFO=                                                         (
               
	
\ \                                  1(
  1(
                                                                                                                                                                                                                                                                                                                                                                                                                                              (
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          6b6b6b6b6b6b6b               (((((                  H                                                                                                                                        
                                                     I`I`I`                  i(
(
(
(
(
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                         p   `      POST  f   f.V .X <  
 f.d ` j  I     '       ;    POST3 | ) F  -Z z 7H 	 @t
 #)  | (
 | |} U( [ @Z  )  F @3 3 v3 3 
  {  et v u  ! " +# $ -% >& {' O( ) ,*	+ , - :. 8/ WZ0 511  2 03 4 y5 Р6 Φ7 8 u9 8-: P; 9-< $= -> ? /@ :-A ZB ZC V-D {E F TuG H ѮI (J 	ZK G|L *)M @wN 04_ 1)P "Q @R {+S aT k-U V W 
X ;*Y@Z t[ $Z\ ] DH^ |_ A`  Za f3" f" @ ؠ   ؎  f{  3 q 3    U QVW.D7 PX' hX@s .X=X@u
_^rYʜPPSظ h@O [X /<t
PW Ikf&E1_X  PRWfQ
u5p (t'@5Rff  u߿ h8ufY_ZXSQW< s۱1
2
 hV3_Y[ABCDEx} UfPfSfRVWf
fFf^fNfV.< t ~.FuN._^fZ?f[fXQ	
}H@
	y	! &
%s
> h3Chup ?   t  Ãu
.(u	u/ SPVF	` u tR	k@.ytމ^~u 8	kt/ t^6
5
^XfQW~
 
' _fP	$S .#00r#Lt<
tw
u!ο 	1+ظ_^p	+!QfWfVu*p#)6S
F f[tҋ3ff^ff[f`K.fa2 	Bp8fVWUA t  f`h2%3 tkfϿAh6 Px'Q20D7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^Cf`Sfff@= hR3>+f;r[;@ Wp
,2h_
 WX
_: r
gN1
g@r @99 \!BWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_qBU/tg^H2N@?" :h fΑR   둡4]]QRWV^NV vq6Q3qI4GYlGʫΕI^_Z!3Q'M0 pC8 YfWV3f_f"1
bIfPS.` ,.:(F,o(  f$(0e^
#N~u_!pY
h.`   GFjQVRaQR?(
`zO2ۊ~f@m޲k:P`?tWuf@y f.((|ftf!f.@# =
uF8Fuf_ZBfX^ÑGVR.>(s$0q	.k6(.(K

ǀZF(wPnĻ2
F0,(FPPv2PqN~ t4vf2&fz10
FNNI..($fQvPu@f(.;8(s0ep~ ˁ ;u
t`gst@Ѵ 8^rf(  _^ZY eWQ3.>8(2 .ǅp.ƅr ` P@h0V.:( `s$' ip3.8(lh|z o.N /p\wFk@"~ 
N~f.t=6@.?x2ɠ0/tlyu4.Btf<t؅fɣ  `b$< F. C
1wq3V@~rpF F;F F2u~w
`M~f1 kЖ lt
fNqu
ffsfF^P4)F
Qz
*q4rF$<u&jF ~# ~$wp` z?.p< O<uO8q^`V@;8(@..8}(;8(^V0&0
9t@{-2x@Z2
E/^SL 65^35#wuBX:NЎuP:
t3S9)vu=8N0_^WV\SVR`Ff~n*J[z!ffAyRffP%Ѐ`2ff
ZKf;w
2|.fPRfPt#f3~!fD`XfffNL$ss4
tu+q%
u	AfFaJfୀ}f^Z6Waf F^~K"8ueffFՋN_QtcV@hvb!F;pI=z3ϋ~+c:tsRVRfQF;F8u p? kv@kF:`pb~:$$@Kz@3frD` w;=< u  r,.;D$<{uπ r-0	 @BvFfY1Zt4}VWv vЂfq|~|URd
t"t_t( @DvP }Pkq9SV@޾3; t	 r^0Pk˽#Aq[%S ^Y@jx*pt@;v7ϋh!1k~@st 1;FtFk^% Bk^cՊa 3҃  V3k`[
ߋ*;FuR*3]ft7-kJ	y	# a
@~S
+FHu
4uGrvFvVBs0;~HVW}΂tS03ދ[^NuVp 3ҋ0_&61-Dr<lFxkHpBHPyA?(7oZ &0V  ~r1|\0PN~ tKv0wY_FA.Qz$ x
fpO3g FfN@P@ 
0K SQh$(	 \P,Q23If.` tf.&!. .8:(tьL$QVW
fv-UFp"`F^Ͽ^߄F  FψF
fgFF ^⿊Vevb"^`L`Ч!ɱ ``Nf~ tFt'f`e 9Fv@f0
FfHf;FyQrZ@րi`b԰bbfC<4R^VFъF8F^ pVF0 N$ &j(,yntN!!fsШtEH rts@CA9FvG 3r%if.$(NͿs  `N0ƺ0 
t
F%  .,p槿 >~ t:(i'i_f^z eu
 v@aQI8t%  :tu Qu  vfIft'fAff#a 'fpЊ=rSf.6  G                                                                                                                                                                                                                                                            o  PQRa&h#j@ $`Ȱ h
>rZYXSQWa$a$a  ho hu >5_Y[2揺 TCA6  @A Q C@@ @;uYð!$p h)Ē
f`  Ȕ hf4ٿgf&P ސ  fa.o.h
 
hVsfPfW@=&'_fX`j
q/h	.t%0h<c   &  @Q0@ ؀  >	L&}uu h<lb!3d 
  % WWHQY-e&$@#h<ff
qÀtf%af5hCsu h;*,Ⱥ: @}p 3ȰS, @uSh33.hE PC_ P
V0	
` ܹ ?
hb2p!úvû  G P0I"E" f4%  0BHT12X21-220LTN121XJ-L03 4IAXG02C41LTDEC5V=        + + P + ,
 P f`O  3,3ۃOu+,,q73ɊOt
,r3_ø{ h99\   й `U;aPo hc5ǎ`8 h~#> t
  Q`? @ PQ= `t
3f3	@fYX _Td`Jd  U߃P@V A&F  q:ؿ
Et&؁U uM9NwN#uӃ~ t"F= wt%   +gWXh2R`..   !	 pO a `( u2hV"c06t*6u e`{RuraQTtPRfZXZ@(~f.~ AYf` f  O ƐO]l!"fSfQfRf~_  f+%=uf?a2 fÿfZfYf[\SQRfWf_Z YhB{*dff߿  c31@^OZ	 Á/x\}or)f Y0Zs0߿ h5Srf譑rӟs pQyq
QRKHjfa't5<t1xnf phÿ(@ BÆ B<  C< $ Z# Q R ST U VW	X YZf 5RVW3XP -+)D)
` ggfዱFB уtRvlROfCf_^ZY$1 kQ ߠ  Q tc4TC4nc4NC4U< f`Ȏ/1/!  hS/11TTB2+G;rBU1rܰ_G1߀
Efa   > 7 A  T П M e M A@  9 Y .  R  n SA ǬA?` (
U  `Z+Z{!`[0RF2 P f<3!P^63f62A  3s p" 62>x~K.h5cPS㙻 $<t4r [X)`   ЍƋh43  c f`4 S  y6h3%hUDf  D 3y "r< thF22"2kƾl ǿ-r/ǿ r%@@9&5&D&ENÿ7A)`
ph˓z p߿^ps%vVtV~^W 
8
3
~3
^E
vǿC u0Qh&@ U$=u&f= =u X&&&I
, fgh  0 pqr  <ABCDE xyz{|}   {)PgV S#
fr@ps6 r&5&7#6 r
&   06x"[ ]stfXiCf  xfw5fx&V3
_^`0(w.'t%.FuN.P) _XW?fVUSWTQ,fvߘT  ޿RU~2 W2ك!IN܀3d	^
u
t_NA&>-_[]f^_ PV&=;u&&4u&m^P
P<q +&~& 1E&DpcbSV h@r^[þ 8`[WfPFhS@ȁ  <fX_v_F10=ROM Based Setup  Enteringp{8`. u  s8? J`t.p8@9 Su )!`- W  8p 1A	Ap8 ^1q8qrׅJp &p8tF  t
.>	t.6Nt
(*at hGCPXhE<Ӵ7|F12=Networkrvice BootWake On LANAttemptto %  Ạh؂t8 09 r	 |A9u 791iI	t eIt;sR QP.9$<0,( 9HB"9! ds@C	%25ؾ)L<^ s EQ
 VRyo*LlNF L3؁	L?	uCFG~gN0tGhջaL<v=shPZ^P*Notebook hard drive MultiBay"/DockQ%b<#}b (top)bottom)<leftf	Floppk  USBCD-!F HDis|/SuperNIC*
!1$23                         =oP  	 
>:P X 
v @0ٵpqlectZDeb]  ͹U8 and _mo@=the highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   ??(?$P w@'`@;S A;Zip.F`u߳ h d0ô0.C@Ӎ th@< A VL3	L؊' tA<v<st1?& 2آٍ <2=Q#YAr	 > P K@.?
*}? @?+jjj(Pj9  E@`?H? z  J  Y@a R 2җ
  ߀ t03?2Ɋ F8tFޣhL $_ Zbqqp URVQ.,.L.T^Y^Z]S,.?*[QSVW/ s&Qc@.<.-00?0?0.Y_^[YQrH? u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰw`2҂ X7@
?H?H?r
;w2p?Jơ}gFY.*?<u2K0fhVi hshu7d hb<u`B J qWo rf.>%D5 h5	fgf&G, @ fo   PG0f@G,`u
hEtG,f",7f_ffP QW2_Yf= TKSt0fXbo    ? o  J  %؁h5p.
W
g&Fg&Fg&F"t7g&F0va 1 2H޾D׎~ذ:{ rsD	 _k  QRVDTQF r&e^ZYDffL (]LрY`VUfQWo
ِx
K&@
C' C$vC$0Grx  q## r]".0tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ!$&C"u#%$u!#,wABM  f. GwPS [XAu.6Gf. GIDNU.GSfV#{SO #^3%%Ýf@	~3u
u\ru!q!} "@*W3 hn [ **hr3p%5)cf_ ]`= vH O1H aP߰ h#j"$@<@X7N4pJPR ZX@ P.>0H t.0H.2H@a4HSQRWh@r_Z>P TC r99 r/ u t t@XR1$tutZ 2 WW$ f3hcXRISWQR Zuʀ[Ppq4{B XZY_U M%Zу< @3ɹ2 uhXdo#W)¼ P% = @uXu%)4_g&@LhH0VQfPvf  g&?t9g@YR%fi<u @^  f%?f^#   f@"f<tf Q	 f !pf 1^fAaZY^$fVL/
/ZGP@t


q 
"
f^}ff? wD Pf%2 {
!
hfi4H3m4r H5 0P@p <8	.12 P` E qЅ "R= LP@p`a L`	P  	`}i~t  DA& Atf &&@0PWfP'B"(rt ufo*ɠ/@  c> tuc ~rh^
&ȹp=C<thp}  G11?}4 Q < t&Gf~&(&6
G4P3f30 2ɴ*f&ȩ uf
ffKP}&u&fCm0ɂɏWlpr15RfVWf D3ffCf[fKfS܃fF0r0а K I+r_;Zf5SQVWϾ u3_^ 	!BKsV 
R3
t<^f~
w/v}N0fkd`afft@`[^ɳХVQWfv h-F&>ʋF&@p &B &DP&F&H0&Jޠ&L&N&P^zPUf  rX)Tu'P ߳h<l" hhgaX`a؀atif]PRqQ ² t%  sS fQ ffff>Qfh Kg&; Qu}70W)f)PfY~/{u! /u/u/u	g&t(tx3	[rnf!ǂ0ِ  ;`o	1/uP~/t r!	 u;Q5-                                                               10Uf`f.QQ?u߻ hNrW2rRrMQtf0f 0R| Wb t#Cr"t p ; (PJR  ZR f]L@V0r*6^  R Z?rG	Ku ezdB rC\A 3?Xy8E tyEG 	UgSm r	S>Q~	t脋lk޴Qkpbƥc࿐W rt r
  GCw_SRA0Zt$ؤ$]WPݰ  _W}  sp  a!`P
߰@S P  	ð D v Sذ8 3 e R	Ǥ!
R'
//&QQWjuptPX_Yù
 d h9Cx1s y
2P <-C<u4-uĀ ~qRR]aR12e< uZ#ȴ$ t	J  U
	a!"(D vp@ƀK ^hlXB*haßhr$T/h! ܴ7Jh9kB.uva { r PQW 0> 3_YX
h_c=>F h=#heSs	w> [Dð   ! $!f?` T a߰h#j8@ou' t hCavP1[F X(Z`!ؾL &>K&DE &D >)Lu d݄ Lj@ t	L}{
 +Ȁ}	 >L 33SPb[tS[>? 2[sDy3 t^h#ʊWs
JhO#OaàhL"PD
ϰ<DuL
p
E$<u D
@Q1Csd
rSi&pS]@` u߁L
 ߃6 6K u  (X6 &uhT^
	\

u.0   ND&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  t"{& xu	\	PS}   ? 4P'>L_3& ?! W>L	_[XB
t+# P xt  t  w\DPV!$!"tKh10&,@ &  ^X  hC!r!L	vTt
vn`WU$/! $<v@a`l3  v
p
u$"<uP8ȷX\PRt N:1thE[!&oă=0虿ZXv` 22}PEǿ)L&PCt5L=	LtOu570: u	At!s96 u~5 .L\s
t!Z&)q s   a
׃/]3 a"s{&=  V P;'Mu_ 0<, ^  3f4G -VMf_{  }0 U!    CM&egWʃO&MuO OqfGtM!t$Ot, t"߹OG}r ǾJM0oOg&ZM/z` 2%
<t?29m21_kרt O<uLDHD =_7_D D	 d
z=1:B]tSpprG&}	r??23P3t`h2a&ES$`	&M&]AH`~.'	@[%# r`S U]ϠRb0ZW&=w uAF:%I)
hJ
o m_XP
pt   U!w#w !#`܊|nhS0 cc.-.MSN=tI! //(rJmc.58v@Mu% @BSB 0hshuaW!$
"1D hb
hVCYp@[X_Ë
ß`PS@e![X SϯH<vLR
 Z,<u(Rff5ş,ZJ vGu

 jS1 6у[Qa$ ;@aáf3Ұ	fh`֎`w hs73۹ F
t):u%b7bD	& h.L & 	 hRL3Gaº3 
3 =Ѧ  	L aSu   [R rOrFEqfQ r.<t*DN<u&' t&wA+ ħ'v
v'W+QQy;s& 0R&xZ0xtp_x` qYQ<?v [r(˥u% = tpYjLYS3	L+6 
HHaE&SE , rpVpVϋhp#rxfV @$P<PtRZDPۑO:  ZGZ^+WWV 0  PhrX@_ 03ټ2e&
y%2bƀb ̀?!C@݊?r@Dt㳰51+pъu,u1 
@a

+&C323&@t  %
t&
0  5  "   ( 4
u^: >0.b!	"	? A%w ^QmPRW?&A &]&Up
t ˀAi] _ZXr#3һ -wƍ2C.u#7/5$N#h΃&<'߸^   Vj    x 3Ѐ>u  'S Ww [j!Vf\ Wf3fu 3 Qύ>wKW: uBE&8Uu8p]
R +B&U
ZK~!ؾj~Z6fYB)%qr U; ;2	Q(0=
  5Ãhe_bx8.
<tZێûPV#
@F^f  XwK~ED
yCA I  oppUf`` FwAm. fafSfQf.;mf fff#fYf[2VftGf   .mIg@f;t&f ,	F ǀ%f^`2۲ۈfaf`cfaPP3_X.>0m, . P_TACO F">  
!	& .,m ԓs<F	.m fFf.;m  3mF.?mf.>;m<E.?m@  t1m߃ttYp2mtONp  D@SIVfB.f$;Vr?T%W B!Z\ܐ	i %Qf2$fP'fffgf"'r. p ,m%sf@c .ffHp3fXf1df3ۃ!u+`so?I
s*"/S"Vf+f;wfffþ33RۿRE7mVo4^q4'r44z$.7<1p6ɐp08333Ҹ  QW>`M% _F
3}5u'JE#ȩ t0 t{ 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^G ujwQ` &t Y&  
 < tr&\]p &_\U  
&kN!d 	L
SR[u0	F@& $F^[_R?F FYp߀TV'?}PVWً ' -}L! _^~WfQSg㷁 Zpf{at
  [fY_` t =$P nPu2MtaË6!s } tp( ` j R&&E?SRUQj@6^]ZV` js0Ō^XP
~*F
  t# b QlF F`(r d3duhX$Ku`<Uu߹d `h4d & Xtû   h;B& h PhE'`X!$!   °"s}ୣП O
ehE   t7t 4  hhK` tކKu& &  
 jP` h,s@<t<u}uR 
0u?밮1*`P	h<# Xh+< % P 0'pD[Z%ys%aP怟Xw$#@ )Р)t`($} f.`G  㼰l3 Dl@7    ; Z x     0N@`^~#bhݞ1fF3.mw% r 
\0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہsw.~r@V» 㐂ÿ< f ff @ffRfPf!N
 ffFf3fvZfFsfBf〶f1 r9spf3ɰ`ǿlfAP  fafPVa3v޸rF3X

S,0<	v	,$]y.[W ߈D`

LVb f s  f`Ȁ
T
TT p s 	 
Sf_fp ЎfvPUړYP, P:Fp
uf^fNfVO_f^pP̹Rp*fΐVA6ǈF@20hC@ Ϣ
 ff  fffffXChq p  `90z P9{" 6 a)P*h{<lP, %ofPRh廒K2R ߺZP 캿 (Q * 4ff:aD0  f2MMShm  ߞ hrRwhVhSZ?;PSSB@밋pq$ q!Ͱ/up!A tðvntt<1w}(<v7s&PIkEO3_ P&
0
3q 33ҊĆotW/g.&;u;@.ont)@)hPnmt؀a`2G@t03@ @u  3[
u93Q2,;8ӉN 

PU-j1rX?03Qr |X@Y4SQo2P5'a&& &0hmC hزu򿣶~ɰ h
t[ Ȱ t
嘪ŀv#t̰j,5~-PXv8v&> Ϳ㟸`t`_P3 u $h<J
#RV s} uu22hSgu]襺uXP&
wL2 Q޻ hNu= Dt= tYԀ'
Y胸Y0.^ZeZ踸P #\U  Pf^ ]  _`yrr	 V'afOLPH@Á      @6܀P0;V(e
u^V- ^"(P*^  ȿ2oMqSP( 22 pX[úB  $@7R  Z`7              z$KtP( % $ 0rxfL+  ك%rSr$rF!f+Df+\ r*,ϯr3w r@ .hifa2 PR3_0 Z@AR `&Fd??uhGP&XhE r.>.pu? 	AїQR.@h f3f%_  f`YURQSWF^
D= F\ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF ɿt 若~u빠% 8t
` `uPj ;}
+V 
N JZ=uϿANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              $?`ރ6.u?;v` Ql0 >h *Y`"QwLQ`f&YCC`K (   P3YaPSRP3@mn?[`H@4$&%<GPX 	 o; <BMtf3蕱4GP2W X` Er
JRU3 fGenuuhfineIu_fnteluV=sL=r=vS߀tNp f   =   	tŀ   
 f@3t# %t5ubfDqa $<@tS<WtO`NBH$u>f=Pۊf@+rC{tq Bt#Bt	ݱ]P0f
aff6?pZXW_ RWO  3OtCxx ؎P.BB <t BB2J &ݾ   8u!@屆`23Ұ
ShTSt0`́ y aut0i at]U U[aSR  4hf
 hSgZ[Õ`-1Pϻ  h9	 h
 "BPaԀa$8uXRP<u1ZtQrtwvYu0ѹ }R0ߺwZhEU?2<Uw  heZ2q u
3Ҹ EFv)v upQst&,3 ~to ' 
 #Pf. UfQfRfUfVf@@h: rsNrDW3f. ff_4f^fq5Yf.>fEgffgf_ uUYKU q\ u, P3	fgf CPpcIfAgadf.#f9kuhpfY'0    /tp ];7h ߄8 ʄ Q ﰰ5 %,"eТ  QV3@t re;F] ;
V3"/fWi &g 9  f% '"# #YFfF^faQaV p @\~
^brq]3]<   h DTDw R o 0 ȳh  n1   l ( ^Pb @0 W HL P`A T W Xb, `
`! p@pؾx o A0
|\D`QWhC3 3_p 0 PQ= `tq1 @0YX 05SPr
& p  ff& X[@ca"&    ir  xh}@Q oJ5O fQQMh2 ./ۀ Ж 详 <t l~謦 tq.葦ri."D.|u.:DtSIz  wD:r5+^s&v
uAm
c1aPQRfWT3^`o
fXÑ2a`2	  "	f 2f?@0f@R %  3?f3fPaX Ah lVUv  fb #n&f fa dD 	h}zW"ϻ (;sQSf  r`
 t
2fƃd	40q!a
 Q[ffY+˽vf[Wf+_f7 t%ȡ^H+f@`h00Qpg- f@kf`0z q_L2_&U uZ=PrUf%в uCfy*f=`  t0  t( f{f
1"0"fph2%/$_!"
 \\-f g&ߋ%ֻf2@t
 <t+p g1~f&f   , Xup Lr}3fBt<rfa&'?rf-Q̀É_xF?<  
  
"xa	Ub	~p@@R2BOuE1ɲcffF &Ff{ t@sf @{f;~t	uɁ~qNїV&n##`WfVfPXfXcr<w؀.0ճа_Ѱcf@&ˀtog&TfVR3og&Pf `&fnu=жtsaNu(g&fVffA>"Ȁ.f+E)^f^uS2u  w & PP0Xt'vt
t@   % r/o h>u  thrs-3&>rqrﲁR0z?sRޑuthX$uul	r` 	 +Zjj b6uPS`` FF ph rO{u
@ &f  ؀>t !$!f$< u~RC  
N<2<ăƁ	"w3A]'y@h[u TYP=t 
u2Ɋ{،в3`t<u
E< tȵoE$<u&w $tRnVL  N L NQwڰu ` t  Pj[2u
@j jY!(!!2(<!1ʰe$ h5u$0+t=$O~a.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|h_DuQ&~% t P螫X
 ě.:t
 ._
vXP%8Xr6%ȸf)uc4;La    PJNL p      QKOMp @Kt  Jt P(.DGH h2h  hvQ h҅ hE Б?E^  ` f  Cp m& OE 
v %&Mt&:
߲&;r"`p$t1TKub 
HM` `(q p" sr#J	cp&v3a C 	H ]r5r=`2gpjh!vZaVRQShm4Thأ4J.`B68u,2
t&62@t2 sk ޝ[YZ^Sû PhW3UX<?tFhUujjjj P9 &hE<X\ hcY$vbwt = ;t= Dt
hE~sp[@WVS$`́$
][? @n< u"*׿Oطh񚾓Nt`-->J=Ot1W 0_ tyr rh  S^1 g 0 hL P5[ ?  :N2?Aq%  	
   VOFPgbǋVW 2_2µzt"@uG2 
u
2 
 o2E2&&&EA &e?
tdƿ&E&&E E &E<r&}	r@ VW^2۠^2*à
&}vPuhe_VRPRQ3f 
%*tº,AYZXRPSQY[XZh?tu	pp Є> qQ 5rXY`^->: t4I
*֮hCRL&&  t8t'[ u aq,& nq00r6$^$ Z& && ;`Z@ `dde`P`  XU @>
   .PB B把8uG` A ; 5/)䊺@#BS 냑76VŜP߀X
 ~a@A@ uB C    ÜFt𻰀V$%%蝊<;weĿ X؊<wM3ɆQ#"XR<  YыƊȊĴ3Їу?E pY8@C0	 ɄFWYuF5<?uz`0Dwf&	2
pu}8f߻hNePӀk 'B@. ,".  f&k !< uf& bÊ$
rۿ wAu%1uhEӲߡ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<fwMKff
f@Zh8XZf3f3ɹ f HZf0m f+fLZ ! K`Mu*hMآhMd3ہdsV4C\` a^_^fZfYf[fv3h6T 5R`2K 珀L0s< |&	3ytvou4PsP 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .\3 2ҹ*@GaaÍ6hVWa߼oǐz_^pk` hΫ$h  uP$<X%sf @  t<   4 r	.Q$<u
@ f3hh.P 
d]XiJhT=  tdbw_0s.>PNfm thtC	
A!U2 u@? l > ]c 3Fd@ e f Fc~ce@4~e uQ@@9 hG`5/
P	3khcBFe:Ffu1r,
 h
 Fdt;   	:  <g htQhSh`!afy`7UPHh,u;E#f% PCAXt# N h&N r k f ̾   F^P XSĻ  y ,  o   hbS-[t(t@tW,&j  j,>" '  tht*dúߋG."**D/.qpE4]+Ë؀TF/VU2NfQa dYF :uEQ]Àg33t
t
u
1t#u
tN02t"FF0u3! :5tFFdz ulm29p`F: uYeb +Πu;6F1 epp0Fff`Fup   j(j	R	aURhc2  pɺ 1 h:BZ]þcoRfB`}r@!  tgRQ Q;YsY2w$
 !u$ d%|Zf`  WWeIh.&T]fT?  pC`hB%
 C u0u.>?R 1fa
ZURtLUHh<l<:Yn PYp to(tq ;C~ Zi@"g squ4VfRfQhÊo$0;p^f[B]T8" a[Ybh<$r s 6jSj@ 2P sϰ rGZ5'/UnAW`.SuQ	L$<u:0pαr"&  t  ttR tAt $pu?P:q9(
ː

 ⧾	L`XSwQ 3u,S?[rE	ˡ-Y[C& <ff<q`00xx00`֫Qɬ||	>>.wr tr~ (ЃrLZCX̀'q@VG :]Q<Q7W &TZps6C  E ц߆ԆrB zuN! ?D _u 0/)0/c#-&A 8q2 F *7&/p`W aUfV3vCDPDQD 7pf^ǋ]&ÂQM"V%  烪wPduX$epI:eXa@1 `` /////- "  @f%ptк@ FACSPZ DBGP4BHP  0938 A!  8  APICZOKm	a	Q
@  		
  MCF#G<	P	{     @(N@
 2! RSDT(  	f`huk4hsif  fh pfp  gfFgf  FPTR ff`WgFpf f.p^$f3..f.f ݷN0~$wf+hCpJ ~3ffgf&f7.>еf(.t2W2@_~( N g&F	f P  rgfffff+f+.
oۑM.>f
$$#D PXff-qAFV3g&fFgЛY[pff=TDSwDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt"@H Qr}< uBOаNRUfQ̓2 tPxprAr /v; tg&P)XfY8]МVfWfV* f& fP&ؐ@(#f]"fP߃)fȀ$ 4 
Ȱ 
ff	hΩ⓾p (fq }t  hhfPW EfX3 wdZ$pwc g t+
h83=a+0Q;g&gh&_g  PSV  4Yt >6Hu	Ch : uDb& @ u  D` ^PRW D hV_ZQPShu7tSЌ©fP3h f&L  f 0C-!@$Lw fX ` hk&" 03fpP&?    6'Mu  ,  EOGVMf3M{ pH   U!   ZM>CM&geE E puMPMpMGfEtXAt$Ot3 t)O$fM
rþQpmMe&ZMaZӽܽU  r.]h~2.T<Mkp_   rkøP޳ kWp`f
phl0lf%ttӿ' tPE(뭿 5)P*io_ԝVΎ?E^ 3f`FF  h|x }u}s hU  $g(,0w4'8  u7Ã9FtF?fNA:F> hS:ɀuh(fa`
Ex13ɊMh$Ӱt

hRp;r#uac5WF ^5sCf fN_Nf.9u0u y0tc rfQPH_urf;^uf;Nt;f-t) pF
tF~U_վ NfPV t;6L(.<t1!RRh\3:,,5  ^_V00 u,hy..D+hXڃ p1_fqtA"   u
3   t}'0gf G0CG$L<LD^COMPAQ PC Card Smart ReaderGEMPLUS GPR400PSCR CLB REFLEX 20241 PCMCIAReflex v.2$cr$HP
  a@k!g&O@ zGd `P ߳ rLfK seor>G	 .WD
A O@.d.D4f_ PQW  
G.g&:uG Y.5 _YXQ8t *Fg 
⡥'fW
"
@
@Bg"

̓%Qf_V`bSh<0Gu#{ 良 euu .Qu = Ў~ 1rp&tj  t_& rT  r&= us0=6>
r/6r4.Q؋V@< t ^mJv 
w x y 濸  h:ShEsz %ZMhSasia
qTrPqtI	f| R
u 
!tQ&0;s^	GYV
} ,`؍vfD   ,AfLs-<t(<#@06~ hW	L^PRU32t
t
u
5# t u9<0r<9w/tM>ư7SQ Y[t>"$,0>*SQLiE;f 	tu]ZXnf`3Ҡ&&h#֎fwv*`%h㝿gf9t0Xa` 2   0 thbq egf@ Vff3f"gf F f0QɃf!
!޾f3۹: 8tCRP #t r1hf˩ uf@q  00i{? 0    0     q'  ' D 
 Y/ -bbk`oC@GY kLe0PS_?.pVW UȌ׎Ǎ~Qr&} uRBr	W:`_^d>r5yr!r\E@&=ߐu	#$Hr&ߊE$7u5#i0z¯Yӆaޣ
r&a)rI DTtr&ge`4o5`
T3
ËʠʵKm4S6r#@itct  t$BaffL  	] 	RWQ
RΡ3q
]
1Lq0i+W!z Pr8u`_QY_ qL[ r&UþNL螸`
Pw4$X` $2߶L nB0<t[sH`8u6
uBp & DBlTt
aP 3 r/) r%BB!J@ 
; 05 aù<t

B Jw 2@ut6` ~BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&a$߃vQ> Yr	2^Qd'YB@Aq BƷrL^	 fpb3׾    @ P`ңP@\`j h\  H hS7{kl hÈ`% `f= @u [jh hc Sjjjj P9 g\ h[cuqW?j&^$bwtQ= ;tbu= <t/Eݳ3 {_hZtPkfaÐ    翴 tHuuu):p*< uwuup@ z`3$jr! grπ D    r% {Z -Z=1zp$Wp_ǀ uu' 3?a re+ tg	%@  .Q{gfT,􀘰f ;tp؅Y[~rs3hG ڻ ڻ> ڻe ЃF  ~f c `W tI
r=? LӋ~ t@T@t0(5@ MF t w0Ó3N !F ~ tٳ	e40鰠SZAt9A`d f` W܋f3Q fY@ [Ix G"
 /2uJp2:!&= t: .  ir} Tl0VQ&Uq
u$sY^D^
%gf"A	
q
&:!& :X.Ջ IhB{B 
DU@P (3 ?  A-sC"upmYݬ1u[	q	1D!IFt$a3; ?2 >+ fB \	(Nf@2Bt1Qr$!$$
7R< !wZ/t'
QVJPf^DUY!p.&T۩++t'H"`Xt~t.a:``s; 6scce_p_pkodqooo#Keooao0vdo萫$cdםasf@SfQfRp>fGenu fnteluxfineIuoyfPH>f%`f=rYfa2?I@؀ Ut/f00tfPF 
 ZfYf 
  J   
 SETU ˸ @؎&м  3 r' W@ P& u_SV  GG0G h@    Gu Fu t3  hC) 
h9kBt & ^[SO
&h3j" `[U샿VWƿF F@    T [ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @-<qt	dR>t <tjjjj3P9 K.wj5$<t.<@t$t = ;t= DP  hEn 揿  7[FF~ t#^FLr
F FQ  ~ wt: ] cf
 h<\2%PFA~ t
F_^Q
h8ss.&udu@   hb,$?wط h;*"h| A#hW*f_01FhB%..  @  Y(`p3WVe1E0E.WV .^_UFP)UIQS6(6*`e1E0eEE.U s@ m2a h#4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	   kQVWAu% p u㾐  6  | = <t ;E@+9 +_^Y~RWS Ê WCrr3ɺ ޑ܋e\AB rN _ZqSYKK=K
ZQujvz%NOJ5> DE<@ ;<<!<3TuU OOpPt
Pm[VfPfSfQ0ppf3fk3CpP\p|pXfffDDG(	Dh fYf[fX^v#zKgO G߉xpQRްC3ۊ%<} t CҋwyB`s|fDf3ۋfË\` 	
C  	T U S V 3	G	[	o	}	`h	xh	  h3	 hG	 h[	 ho	 h}	 axv.L.< t)F.6I3.PF.hC^[+V..^̋] }DF. P .φhE3bXhc؃ 7R  16W  0"Xa Y Z #[  
\a a _nBA]a f g'^a b ` `hcij!k qp10G pppQWĀ>t		 u		.y	_7   O 4a9Tһ ߃-w C.ő/⅒2Rm?n8o7Y3۸  _`ϊ߸^va>QRrPS[Xh;%ÌhЍƋwh
3     p     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;g   09/10~z8V12/00 4 kLite{J{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdP_x>0@Zݨ"2""Pf"zx xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`@pcłŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5FeG_uu!,}x00Q:l俐}Dxe``
$`$p

xc0
Exx txDESxxxxfD@/C0y}}r k ;]}d`xGC FP&x}DmQ¯00xtxtyuup*}iQb}ps ~aU{}wc+*")@xjD00q x^Dx_T_xcD 
T e p# ) ,1`|Vz
-%&0!PI	P1Tx"p2x~p3T0/ߴ/}@!T_ _$ u!`	T`#8 )n04`ht	P	;G	"+u+$4?iq}T+}'د+p (++@^8,+G
H
0%1vP7",`^60/}@j+.@ /1@'"  "+7x0&x+Ix_`t 7"6}

P} }e	!	  @$#}!}a 
xpxt"xd}<ߗ}?A"@+ 0}A[x#A00x )xh`xiw  p@0S+;/TB+x+¯0);0b 9P4.+20B+`xOӀ	+ xTx !
+:DTBKPF y+kP>

C \Tdp+$!$OP+0.`z 9sR ðÔ2@VD0¯xx7x8r x009`6%06 ATߠH`	p5V3n ;A@#[6[L1G0ϫ*05E"`X`X# LXQx,Uxtx0x,q@PD0xT?Tx*Y-tx+YZ@?TxYZ3M^[0MM&	,^wk`qAkPqux__DND0W>   R  V>Ђgxd?pF^	;<[bQh`kQt@*ARx-	+_SRNx*SMxY+` !Lz `R0 
PpeQ`
 RSPPf1% 0Y fPRoe vGX]WxZAYAXNSXW }GX$0Yip^qZ1Z{TMZ1Ա
YZ[m0c1\\TPR\
r[	\S2A}; A}A ",A~L B~N  5A~M uuҌВ"ǌ4"7x'D
 Y /7d`!70h33TT?OƀC}`07`'`2`=`HpQx] 6uu?uuPl uu0 uu5ˏO$ƨpN`0T`
010cP@ A"| }(;x]`U"+,?,E+p
0  +C,,+ +,+x,?+0`y!,,,++x_,,"-.T0ޠL72Qt
!Mt&Ipd `1g11![tU!Ҍ(0響/0mp/l`
/0dc@TzE2AӠ.-/0"o *xc"+xt`
o3x7Px8W7tP}B0h"[ZYYcdYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >wg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~@ 2 Y	J @ | @ s   ww ~~ r  "8x4D`2 T ` D)YRDx2txg1tI- &%[0& &xpvv Q&xp[Sxr#$ % % "2x1 	ү  ¯0 $"@K~`3#b0"	Mx3C
r beJ"xqF`V0 pC #" &	x30$0%<T`Pw#"xr`bfp
0"$""tT.4} 
xr$3z 
`Hpo`p$S$; yrp C pxnv"x~0	D0⾥$ 6Ӕ@Tx~y}D"g0p4h)xlx}@ DT> 0
 pcBm"pxt1xux|"xtx}xuxx|	"xw#xvPx氹yvxwf`Ӏ|pxw b( Qu⅍}B@
"{-`"x-pt %-o00p2tU0/0b/{R0h0o../U0`OU/`!!.-[/0/0u/ u/0/-.3P/0!d0Ô@"120! 
0
0!

"?0!PǫH `p$P	<0
`Tb" ! ߿R0 u P!y1D12nѧ2!1¯Fx1"`u T""3453 /:N+"3554!_Q0"0!xno`xaT`~aߓxmp)nvpP*r 3}TOp0@0 0 
]):Q0`*/\>P*'2BѨ P` XӀgQ7' "0a T?2u$407S0!{z}yD2378
u8 7+
`8608ߒ606@27$h' Ô@^@p4)


$Y	0
	@À{0-$`
$`$p"Ya"V4#K0! :0!@?À-0
   s	!~2!
2xnfPYo0*2d|p06SU{zy x xovpW%_`gK6P2 ( 	4  W @;H	5345q3`	t%5544r	@ :0	h0_"06`	2A06< L	r@1k 
  
 *90 B? 6, 
jj	" !!`BQ
p0( 6"W^ 
-NtU
]DU C6.
j'	@bG+6 ,,=f-e2pO7)0	LoP85p
b3y.&05"	c)^	0
S +":"088;oGfpO:2%v!/c)P3
1:@Cxm`qe`?0}DН h,g,-!a,a b}e"4xgMNOpxD  Pe4`^}R Vp0
T4d`$"4#ώVp~}e4xd@P3 0
3 $(`3`3$`e$`1$%I$`9$`$`)3]$pvAT nqz2c1[0TxvF>&`!	0,0)Π%0Dx  Z30a 3]aP)6P 	@Rи?&|43`Ҽp` p\TQ`xj  O*`/CKxv
xDߐ}O`&z0{^`
}iT?DtSJ`PpYKT~LwOq"@`T`M	0676$``$p``1e7`/tg7r((b)(0'0)a a
Td`x0dp#  xF 0TÔP
*_xFt pxBUB~xNNw}wxJqJpȏ:;<t/?=(x ү~!:%$t=t=;2!(0 (=$Px`vT"` 2'<x7"ү3y:; 0( ;:@ p0 xv6QxV86}'p p 7  %76([7  ""88Ô@`p/p0 
(` /..d`
&~r7) TP5O) 4  40040@O453``/`@$pN574:I&du~P2);Pȿ [x 
33oppG*L2o>gp1 ';P"T~ _+?T#>d`pxH 8@224P65b3e1@d@>"0C1/ 
m
`,d0xA%30 B1
@
 _0E00
TDT@5q0	 3:@a& AP}Nt
 u2P2btl@N
Y0.
@	  r1l0dpe`30!DxF10U5@2`ee bC7xnu30 0u3r2+(t}1123#.1}p<0 $3G2  a<0 }
1pAR E>rpM&"pڱ  d.CBS)x0,u.`2:,`e4 2UU.X5%. ,*	 2732pha,
$_,eO!% *R5 
Q'x`S+0	+`! -R	++@@۟@`p7{v@}	 `@~=A0y!T``Y_`q VWy
7pDxp/EDy?N%@k53Eop;OCD.D.qXTQϠu:93: !p	S31B3dUA`h>y%%Ovt0QON@pHR/ N9
d.|0
`0X6Fp0X-64F0570`Y5#O0]c6Fe`	S8@1
|!b-1ÀI%P/;u1
p< u1a1ްQÉ*JC{p4z5z5
3zO*+yuv {| A+ 90& n`AwT0 +	al:zƁpd010upo6o,/-.rpF}}0
P/.y-rdct%,f Wu tq70YS 8S;"uW4쑔p1BŐ}BT_0=_<I|?`$<p:T0Oő78e`pYלBxOfTAx`%)daz0  87>P$C42q"W¥A3	``uqq
r	1Q`{0
}
9ȈrdP9$$?P6"{x 2F}&)e'AChSx4Iq}ڻa X@apR`pLxwpG3p?גu]1U^#5_t`@TU`#v@|T kx{}Lxzp Rxy PxxPQxwMxv0Cxuxlxtxaxs`xrxqxxpx`x|Lx{`RxzPxy@QxxRxw Cxvxlxup&{xtPxsxrxxqxxp/"pxjv00,pTWxfL@" -4}j0-TxfQf/_p0wP -^ ##---U-i C?",u/212Bp-21Կ^p L.e'q,xĐ/$7,T{AO-.`۷pGQN.E.OJP7֮0p0Y))y0h
PI5
Ps|?`d7]}OPn,rtIar4֒N0`a2Е
p1
P

Q "u- 09r"l  },n1vg9,  yA3.02.pM=1s0D@dT0u`zP;DڰS,c,u?.B.`] 2 |p0`u.Tag2)C
.{%TOлQN](03p	 `` 9a :b ]$ :t)NӔ@y6S ? x0s!  x/60QRq7prrqxvCWU	Xu
b
		0
  `
7P"wq !
G1opTrAL`>M)60.T`@}w}S?AP33TBDWD ~ Axj6"@tI C9xwVxFdҢX`T`HT
PM>@D!3"xҿ)"U\]z@0Qqڢ97F 03tv`
pUr )J'' 'BP_P` q6w0P `	qPa"NOw.eB"TOEN Є1kn`=\v=NA=NaYpo0:BP eo0!JI$:1PJ1,F;KFi	D0c
d^"CO`@"HIOv30aA!I_dp @0ttq A2bIBJ``JIxnvHI<i"xFExGFxEGxFt@0( FT.`xFF0xG@Ft"("F?N 0 G=}"xB*!C!A!B/)B*( #N*A
OA
MA
N/I
UN+)D
JaKaIaJ/iJ*K
g
b^0JKowLM`N T&` @ws0uK`K@ 
MLt HKJa}i}p}~}wEAMI!!K..C~ Ô@"TxDoTpTAp @@$0*F;ޠB}@qRTHC}Np(UAtAnAbALA@A*AAA @@@@@@@@  AC QHH" p&bbr! tG"xbox o "C pD)p4X	NpJ#q! * 	A[ ]9qV`N~ YV$`RBJb d$ByUӔ@U1OůU0	xnZÀӒ? }a?U`#`5`2$pCxD4SS [CxaUUT~ߓxmso& LYq 
xi0v G@π}<PT~xiC}Ӕ@`Bx,r
T"  Ptixo aav+xmvy25 st w4}t  to}D
 "YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFT_ATAA[AD,!@b*>}EĶb $QxF%!0U`Ud`0)&uUADDDDDDEE%E8EDEWEbEqEEEAE9D DotNA8pCb,D
m!@T g͈@ܗ@KdL7 &T GFP7Tx@ZEQ
[ha>WP A7O^0D=Dd
`#p`n(`0<`PdP`d`UȐيU09NN{ Թ.0Ȉttd	QRxtxxXx\x]txat"xbt}xJxFxBxtx(tbxx%t &x)xxxxxxxtxtxxtx x#x> x=tp x@t	p0xTВ
}%xtx"Ttx!TTTaD	x?D@xTpT =TT	Tx= Q
@Tx#Dp?m=DDTxjv0}Ct QdMdR eP@eLO;]"x0xK"xgw/M"Bn S?/?@>"䷓$btO>$-"T_Ô
P~0~7%UUdTT7%TT{ z yT H H+H3H4H6H7H8H9H:H;H<  H=TY1	 IQ
 I`A  tR1~5H'T& 8 `;cuTuTK0T"$`($`*`-w/qpu4
TђB C~Mb Q P"RLT$m߰QIA|JGb ]N V$1^p$c}JuTxt _x   uT U ! 0tW @} 
A^8:32 *}_0B u#'/A0`,`0$`3`G`[$ap]Tp^7"T 6 dpF^?0$ks `!DWTwwq/0 Th P U "&$pR_PMQd`QQxgQÔ PQHHzq@P
qJPx7gv@@0KKKKKLL5L9LTLoLwLLLLLLLMM	MMMMM-MSMmM~MMMMM  M0
?v"xgMNO`uRRۭRsx}e  x  "%"0R1g
R;I. HPЄ"} HG}01"uS@	0SSST
TS0CSp庠 0P 0@4xwatgvUa5Q =@jxTxjD0S{xӋ0Uxbx"x@$xx"x`}K}IF	
Q@ Z0""3HDxT| } ~ K4Q` *OҰ]RR &OҐM((sN1N7O@OOOZOeOkOvNVN^NnN NOOOOOO.?!PÔ`P/QI"T? } >00x`r"QfSQavJ0pV	 50T;DuQۀ0]P 0@I0)؀	\S":D$p
;r!/0Qp,"xdP P0A3s"~}e y0?IYR3dAP>2J1c<cE~Q0M}EHq@J`dCa
 .0fTN@g QyT00TȰ"֑0PH 0#@60xD oTAxh!1?xxhvAԩ0T 
AA=B 11u32}'  $31T3322@"P0  "([W "   p}"/v*Pȏ}0/Ô/pC0S00P2000谯"
axpo0 "uox`2345&}@"(t?3t 2x`325R4U5B axQxQDQGx@Q  09Ī6xT_nTݳ CTR0CRTRRS5 T5T]T}TT6x
ߎ/0!x
tP/P
0}/ x
  x
Q{Qwx
m! $60#t #T %Qxs	}TBxr0xrßP2QH0 p%@$T$ÞPxxr`1 	_ 1_,-u . <T}$`&p<Q\}/ p% 7C x.-,6	%xxsӔ@v $(xrvyrxsP!  P&0 	r6
pxv 6xa`r
pqP 0	,xx
xR!x	06T)_zP$3p 06d2T TTTTUUfU	U
  V-{}pwfD4 D@ @B@"xDbU$P``3TOWD#X0 +D "vz:zTph`/AE@^E *@@CEpi* O@~@  }w 33TOBOT?@ 200"p<ϛ`p}Tp`- ,*,, F5RS,  ~S,`xevS,,"+,/0,WO~@W,x	_W,}wN`W,u0 u1SSS0S3u2 u42U03U1Np1%10304440}P-5xp7x	41_0a^_55ϴ,Ӕ@xA=-Ps Y60c
+p00Ӕ@@60,	`	@WWWXX(XuXXXXXXXYY*$YD%YP&YY+Yg,Yt-  Yy,ܐ6S	YyQxu/@xB![-.![P
_.-`Y	
x3 yt?e.pt e-``l	clQrl"	`Axp@};}t&^
-   bt_,Qe[v } q} UpQ t u ]vA*	}5!`N3)q Q!q^;"P/`0 ,+"`w[5YYYYYYZZ	Z%Z,Z3Z:ZDZNZ[ZbZZ[3[%  [ PX[%Xs  S1
tt)ŵxU#	
pp&Ŧ D lTeQ@ST0BQ
/b:Zl0'S&QÔ ZP i cZP`!!Ik0~GJt(ಯDc4rKrgQ
xj)1O`D,1P
QJAS[ "gD `C -Pc80.u,,^,SÔ@ .",ҰP#t .`
T/Ӕ@""@
u/$ -$U"x@|Ӑ T"50/}5"24 \B`2y\\\\~'\/\@\I\J\K\N\Z\[  \  `	xk0/_"; ` S0/ 6ueq(Qa  " 0f33%$%я`e2pG2&640!+E4d	`e
_4Xe"anv"|"44$`$`2$`B$`J`[$Wpk\P Q0/V_Q\R
D	qv34A@;G4p@T
<q
0D""""r  ^j^r^x^~^^^^^^  _u2#__u22b ! G0!ZQcPyA=r!
C]ab 6Pr2UDE. u8QZ/0!HQ R 0 32"0"x%0qT~t@"7@P@@-	T3" Ox~ d "0Ő}t0	j_`A;x0x!TT`D_pT!D`q!T"0 p1[xD@&?A\"  :	;
/123B=>C	D
WX`~x`!ÔP ^`_cT"
%ސPF`70x+ +bx{qqa+s+H `C0/+xT 6} 2@.Z DTk_`X c@_TT`40	61 aאS 
0cx	+$```9@=axv 0z q DxT"ҎxSt߀TTH`Q+xS+<x, 6,@C`$p#+pxSx+	x0_60/E

0` " .-Ô@-Pq @
QPQ/-$܁A$cp`NC.I}O.A+ 9VP`@\D>kT ]P-Bp}} cԏC.e.sc/@ $~SSN`R$dp[..".x dpD0ӀwÒ/ۣ.Aq xk..TpP"-.{{ j" #"x7" 	ӛP	뫝0@ ÞPȴd`PÝ@ӛ@* ÝP:;<u t/dtv"/01234u5Pu<$t}5}`/[ddeBe\eseeeečeĎf
f'f'fJfJfmfmfg.g.gmgmggh)h)hLhLhohohhhhhhخiiibibiiiiiiiiiijjj>j>j>j>j`j`  j~K0~ %~ p0% pC3/}u: u; u<3{c\4jT330P66
~ 6`  fwR3`0u75u3@u:u;}u<{uxu{]{X$::;o<{&5Սhg0  _(Uh)gU

-K><,@1E` 
} P0Co3+R#~ 0`| }` @^_N#`##*(
"&

5P)*)Np<I?d @(Z
c#t 111{T!7(+U/*
81U,/'h3/U1W5H13O/| ;1RRBPA$__TWB_1 u2d I'U8B=9'!U'8FGUXC&IˈEU(L͸G*Uo`VI-#M0V6P!}V׸bhQ/"qVðπu3_//\Cq/4"$y`p!SPpnzQ @@ "@A~G`jPk$k1`T}%A`"`"xs@}}T} U  VxpBBxsPBQ0$70#"Ap
 "%@AOr+ 	 	U		V* 
 
W
Bxs		 ے":0dx>oT=@Q
38T>?`dlP?_>IIPw0=_pC;P8j } P' 8@
ఐ| $ >dD H	0
0ld FEp6"}`~I }p>P l#@b!p1Pg0ڐ}P@ HTTo*t
#Dq0P7{p++s++/0
~IС2!_$QIvTlo@&>p0uJ7 qoP 
41omm"14P}nv8_1xe@606
 0ǆ@60'A0e}pp
T?T`4"4" u2<00`~~^z0kTODt001p322]* u1AD00= 	3PP08_5PQ@`2KPD2B32ӷp087YPc`&RPm@P}`x"aR3"0PT;_O"
W070% p03\3@,p?e0`01?2D_VRep0oP3࠺1!o10~
  c`Fg : 	1DcA&F@T3`02`;:+"45675E4`546DP
(4`i77$pTo`MӐ4`TM=`` `'p->Tr AE Di i0$CBDf0r B_ÔZ	*u1au0)'2u0p
z1}}]34Rp2u2u0@㶧*> $3@P2E0' ac@'
L`1`V2^qУEl;8002`BTTT%%_O[>xEp0>3`D
` 
p	0d`0a1\Q]T?`<@7!?$p*3tTS9)	 #vc H@01	a=?2`f7O"c"Mc#N$'ZNTRtnUپ$	??
o)U$	6
??u)tx
dd7eU"}{zyWj7v+dj12v+04<t`u8/'P~ s2./ds5%t#\v>h~@_[tQruM0ppT0qN`۔L=2t[	ÿPt  q䑘o[`<`z45Ӽ?K@/Gk43ҿ73  w$((swfwwxx9xqy7yzz{|}}}~E~~~=^	{ z y4k	5P4F w
QhST{lSp1
3D,t~5{u4`u5 	]4T`pd` @Pu?
p0
PHFu	r	uzLoBmP[|| ay2[}} pmdiiiPKß
Np&V$0/餙iz (
r67d6 N6@7"PnRPJd0,v e5p4l`&{JqTw!8*8EUs|} `z {E` @\]L旆vv899988'9p#!#fk8`9#
							@45q0F st[c98(d`픜!PDA-0/! 
E0
jZk<:IIP2SU~dLpt@#aM`M8@_ɫ~q;mpl`TT@
`r/@;ňqdNpt/,V+0/XPՏYP7[Z>Np7>	bUodppNCWWriҞ/*'P#^/iN 4()?dn&pf1h<Aj=Q RVv>afx?Mr 8i؁},KD|T9-`M098r0,P78+3 7w3"2傐}3+P~ A| 3$`A`yہc $?~ 2߂u3#ux(77 dER t8u@`
Ô|		q@(jPt7pz9qTT Np: );4u3tu
q$xe3`3)71!`04|4a0 wƀaÀ1 PӅeP3C1˕axdAU͂y1pCϑ2"߃Ӄ}`υ2"u0X|03} BY%.|~N+0
:>F2pPu2f	op`8N
0𩄑
``vӕ19100! TxeT`&}$31dtP2"u}`q 
0"""4ߐ}t t iP
3U02	~HTD"LION x9pP
 D?T{":p
"a?~ dݒ ׀Ӳ  0d"0oӀñ 7p8`0@
D x
~,֠T e8 @p 21"1,"`"x0 5"5q"px \
qvs>q\>~ 0ab on`dx"7 u8X`,7bP|  `  Pnp	G84gk8$bd="89I;u<98~N98lpe; C9E8 `v j@@~+P"~«
mȡ<0&;x33 d ::@o:@>x#,	: ,Y=x@A-:Q H^0W<p ;PB
$ٰ0\=<>/?u@`"H P/A(p??p>?
>`j+@55@@	x&Tp/"%oT~ O7&@"`"!F"x!To`	TTp57O3o`12D"C
xCpx6p>A4ra/T?(--,r e,p,,~Me,`,,|21G3>d$-t"u;y2A&8<9@Ju;;;`P9:@@l56x>FM pb?bo665 е5 	d` 
G_~yG6C?"¯ WDAJpO*q+u,U
,, +,@+@_`@T` OGG$&_xgt
 T0x"T1T4TDx!|CD@PVp
0g1dpa23%33^+232w@
4k/`V4c[N(%%q
OPZf`a00*OT@eTʔ		"TYqc~L` #Aq""	F	 >߃	@2VxpOdPX LҀԀi@o3ꀚڀʀ3䓣Ń ?
`	"3/$ $ P ##EN``#:sB"P""):0"P%0 "b``"  )"u/33@p " 3@P"Ø"(p p8

r
		{
tQ
X
	


 o*2	1	"<t 
""BBE"""ЃЂP  tsn6 s$ŃŃ1" "%5|pbpp
߂s@h`1p1 1@~1v$1@n1 b1V1J1eP1111 p0p00p000#Ks                                                                                                                                                                                                                                                                   /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)  a  L   P DSDTDSDT  HP  DAU00    MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 & y 

B9G  D
wAAI}G
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	gi
  #11kg 2 ph{pi p
 f"`'fg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_O_S_`pga.ag)`B4
bra/13ua
 6
 s %[I`
 
u	273213415p0135_INI ށ5H7
fpig
Kf 9i` g9hrgfata
apa`r
ahha `a u
 bbi@ ibub`\a@[K
  8_HIDAJ	_CRSR 9?)
&	F1S
  GPG Ԁ02
 j$C %Dt6E p'FCC020pyF2i1pB1t#209G22% 23 4 5 r 7"3ۮ([8   
,[́8129A3[
 BC	5
[U1 DAEF30Q 1 2W3w3 34H35
7@[G36!7ְ"38'5 9ZAX3BQ C`
3D EAFPZ450Q 1 42AW06 4`Z 4@`45Q 6 7 8A9A0W @BqCDE  @Fw M@,51
E۠!P`pua42a}aiapa ib{ab[B@10}2E'
_C _ADR
 G[&   n_STAi `	3p
T45`56
T
C[)56tqr 5 D070 857Uo57Er2@t58& @? < A@#59 [#PAKu5BeD`p` p`bt57e Ze` ap dpy40cCdc
{at
 kb`zdx5C!{bbtGd
q6puP@2dcrdZ58` dza
aa{
N `afuff aOdu`['A
2Ja
EL

  BGkq;
nEDw `xH d2?y' '&}} 3[A B60pibpkdrd
edA
d hb @brb

bhb1  23Cj`a61SD 2K661crc63BbWN04!warj5Eab ]b][@]
]
buq]atb
bP c^a%
`bac 1`/$65S SsK]Z5E
361 }63c)626P=aacq`\66@1E~_S3<0p 4D
eL67U< W

X6X @4[} p_9 [A%@ 
"@6Bw
K6Ba@{^.h(2BACDDF@[B:H 
E
`
[k6EFе70Q 51 2^73aAW7AW76T77AG7Pq 9 >pg7A @!^7C!^7E F q80F#81 H82 l83

d13842j85 
<[=   @`687 8qf892@ f8B 8CQDp8E`
[0 F	 A90P
aT9`	  92T93m
qv94$
k94596 
!
pW9X@97 g0~98gqx9A
[! BA9CQ 9E FG`A0[#\_GL_Rbp
?`{P[!
dv`oJ`Q9D9E{h jp
p
H\rА"aP9FbˡqV[Jp	rya
c}cbaa0A1 (8` 3A2x0 wA3Bωhiq`y`j0OA4
h<1Ы7E: p3 D+Ba(g80V1(@pwA5!i5p@"m7APFbA
iz9DF17B&$r8C}j80[GG6C@:*BA7
@
g[+  A8ফA9Q AA$AyC06D C0AE
A`9`C]
	   zo{` `za 0 
bw
t
	rabC
 101
a )T{@rv"OL&F
pI6'B`B0
y
rw iPH2AB`Da{P ` 
p{z1 wip{wa` rbqAFb yC11	_9`p~Bw
h nwc }r    AA3
ccFB2
l
 B3 B)4 pBt e {ky
 B32e} `e Aj
4a{`ц xzq5@p #b}e
e/p !z	e e$}`@dAyA4{k
 	``z;}qA
 ЈAA y!-Ap?dr1p68d pA8"9 9oe@{B6q0fB`7 D dyce@
QTѢB8hif"f
j
r7@
EbdB	!ba'c@z!Dby
PMT6CTHTPCIBb(px`Ab	s[@bB/cp7yacaABw'UC`CDe  dBob[FB9ŅGGGGD DzB6 7|#BB
@ցBBBQBD-_PSW12ڡB`k (x!`AD[(0@iE֡ F C0
c	C1uVm	Vo	o	o	o	o	o	i	 Rc	po	o	o	o	o	o	 t.ҙo	@o	o	o	o	o	$N!zT%[MP 5c@#x`0833bý
[@PCB /@CC
P
[5   CD K ECFвD`OлD1 m 0D2pD33D @~  PD5{OT 9 62Q
 0D=:s
c`7
  28 0D9SDAA!D$/D(D///D 'D//f(!e!(.G !G!@($3(T N #F(F/,/M E0@ #F   //A eA !A N A GA "A T "c0EV/BE2g0E2//.3`03'3// a0%1a0%1a0n0a0G1a0G1a0@1BErtJ  JHE5	E6	
#  y ɋ Eh`и``
퀀`p`apa!E60E9	@	V}`Q	``[EA` a'#B	 p$Cq С	A`]v[ODPHIDA_UID
`|E9^^06F!_DISEAx)_wSRSEBh__CRS5Wa70 r)$$+b1r )4f;	c!2r)C EDM h13r)  U[(iA 4r)H$`k0jQ(5r)3F$p{8k6r)71>8B[!a42[vF21F3
r 4
 <5 {[#"G`P9u[@KF26v1(W 8?E,C054zF8
,Ѿ 0F9 A
LAB _S3D
p 4p PkFCؠ(FD
 h246 ` 5XEc7CZKFF
048`
{i}`h`{`h@48{i  @ 5$ q\._SB_C100tB~ o._DOSq	4
` a![^ 1bb ha[a7ɠkDCYFC
 G E SSaF
h 3À˚rRcp*r&Rr%$C 
q
 
h06E0FD	8hfp
` ߓ{\/00=2<98
Pti1`0D  Q   P Chi82`
hDA@ \\87\/	F1 Y5 @E6|6HI"7
 i 74hj	 5hijCq8c.50h92s 1 0p
Л93r8F2! F)9
^/p´0klk0^BRdN	_GPE	Ó
pOI
Gb bGf f y F10AF10BF10 #0D~E

p1F@111`
 2/_REG(pip015
 a	isa113[J  s@@@0140F15p #  6!U7)8A9AB 11DE F20+21Q 2 3s 4b252678W p9AUBQCDEA130Q 1R3n33345 6s 7@,383AB CA3UEF064q4q42 3A404Y5Q 
474 Q4A_INI ~U4B qBq14D[  I E @F:C150	wh
@axa
db`t
@`@QP
a
 @}a
a
y`\g}`a!@81AZ Aazw`
d`xr`
  
@bauaa^F52
q 3s G4
Q &6+57 9
Abt15B2C
Unknown 
NiMH 
LiIon N dPpupuY>0
  a@tgq0Aw/1(`0AQM5G5
a
D+0F7DAyPS56@`	ذ9qǅ}ha{{a
/54y}Q952!
 
0[QQt!3!3D15]PU7p A7"E	`bBp
fP?{`{@I	F
[)h`pXD
csc
  dzir`a[)absdb1/2J*(ccCC160	hg3
}qEg
BlU25B/{`g  1`2hC N 1FQ23v0a3h - 126 w"9axra
c 
dcbpb:b,Ar	38`fa 9a$(`a-q-2g2t$@IX64
I+Ep
 vW 	i'p
q:/39"29cBhcD c600 f{P`p{``EFA;  9H2ccdp e_eez
cpe'cpci3%4?s 5qp
g5IBA`p
`D5202o1C-+6G@+yN)0W1mDQ-  
qu_>
>2(P2pzo
 @5Wap%*!3(QB+BCBH`*se(a5h/C	547ata
!e
b@zch!

D

6Aaa`i34
@ ra 9PQW paupaHf:bc6h640>77@E BFpr?00 [
~67rAч
HP   a`3A
Sp
SIMwPLOySMp
MOTOROLA a`wpV8~68
p
 
Ajr(_Q03':Q{ByA B94u0Fb _p
a4aE
bBa:TZ69 A['cTZ3_J
6pn@v
JazD
ab6B
PRA001A 
 1_2V N8EtǠ#
BC^D#
9nO1169_C316

,^
{ (i28Ci$ŐS[E}EE
6F
N C17V71F7g71 720  q Ǿ!6 F78A9AB7Bs A7D77F80
[  њ882884855!887א[88҆85Ua+9A
!85M8a88Қa`| 78`
9>0 89pOvpi8B8CrA ằ cBbaAcϡ3gDb paA
CBFc18P ya
 d
b
 bdpdS c
 c
Нc
98CkB`8ѷ88p`ka}ʕa
v2C_ albab`b
vbyb 7717Bp~`E7A9q !D#y!Ad9zj
!%ECW89E=!E#'6qbb/	aq obbQ8FQ
U8245`6C190
726" 46"5
q1
{C039
`{  ia` `8Ahp!
`!zK92	1$AB0$b cU09abcA@'K93 p^^04cIX9w5LA
96

Gy 198 A	9/ P99hd796^[N!AF_C  _DDN
COM1!9B9C6
30U"    8oy `NS  9CD_STA 3{\/ f002e3C_098
𫠐-9
`1
-`p	ISP_RMV
+ dk038p9ῡ
qF_SRSXbh
aD7DBBh)B9B@
_C
>z9

a `e bcq$OxA[i9E   
CF
_ON_1"0_OFFPR0E[Lj9FhM" C
_vG 0?" *
' ~ #,$[#`;2KY
AA0 L@A1b;^,4Pr2A@t9DQ9܀AX
I A *` 
 	A5
r
;0/!KA0s 5"S1x"	"u"30#2f[46m$i$!P%`$ $A6[C: 7A8p&=  UЌA9
.#"XEdB>ApAAAEJH
1 Gxx&xx"q)x)xxPM No @r^r_ _ u\mTST0LKAAR q%QQQ@FqA5Q1QN?3?303<RQV3rRn*AG<m3 *o3dSbrAB44@AC4?VC4V55 X5Pxqyxp
X,]AC @r88!]FqAD=]75]q-&2]qBqoqY:D)AE p\/0syQ(`{fx !r@{AP.T C1BQBP 2 ;03B2$Bp ha0j ABBB21B4!@*5&{`h`h  ِB6\#_UI1B751_PS0F`B3@3 
  "%@BmC𙢆g1B8y 
4鐫 a`pBy8!Ť  paC pF	 z`
a
^ћB8BSRB9 BAӔBBQ `vp2dAB9G[O!
q$!BD` 0#BFB  CC$C2
G``Gpp p+eC0
q 1`5WCv%EYB}E!C2[%P3u# ="  y#q4Pw@ @ o"O[A1E
 
 P
     **"5t2ÿa a !-,A
0 p Gor r " 7` `0Gd d"n[IC8
" 0b[[PMCAQEC9уҺ  ;C9CAP9qO.r    @[+ B@
   
 
@fOC067C5ADR   'CD
D
[)CDE гI#NI	pfCsYAgD00PRW
	
[BDӑ@`D2!JCB>PD["

X}7 Jk7P2Dp[]GPE_L1A`aaD
C0Dz	PPJ#
@qp D*
	 *_EoJD 0B.ZP CQ BEQ FKD5Q 6SD$ > `""  qa
CD3
pM
*S3p 4BOC52N

[A

E (A_D d#$E#	$B#
		C ,						FC0!B`
, 2A#C E_GTM p3
) `3 `E4 0E5p E' B Y{Q\s4
EE40|FpMhhhFi  `p
w}6Pqa:`  A` bwb
bw`
c`ib ac  rb rc ue`A
2!abq6%
2cՔE7b=cpoE2:6. !{ z60I([uE2 F &uE	088`[0iѭ7A	
#  Z1 8ODm9ODAOEDOEEOEFL`H\_PICh"\/gND6M@T MqK6E
G
`O' e  
e@p
CJ !#0$ 
 GC

  
	
Q	a	 					!	A	 b052#? ".cD
%6,!\q|!G!H  J !7G .	!A0E@T63@	F
q}R  RVd
d
Primary 
A   
LIon 
Hewlett-Packard EyTraveloka	2S@ 1-5[L60	^00Q60h`/` %
 
e
" 
 
qZ63hg@4Aˑ1=0EBaauRdB4G`I2Qt6
S _^5E 
_BI Yap ST 4CL\][Gr676.AȠ)CocrJ6
ACPI3	G	0R/005`D055 $ Ja# [&]PR0   ^81``[Tw֑:t@$
LID{8p["AHP_Tab4PC_B?uttons6
	/1?5?@SX"pX{Nќ7j̳F0  F1 
 23u0kpk`qh`piaFa
 ?ЏF1я
 a{`
 ks }a
ajak
 kЋ3 24 pF,F0  *F4z

[ ` `2`@hp}
yj e  >qb1h)h`@	4` ibppbasabcpcau`a`5>BF6! Pa a7J/8d`9 FA BFC	39  p
`

 P  r?
` a0D ECee[wre
 
FQF@2B?pFAIL qM9SECUpdAA21A1Rp^C200bwr1}2R3]4-3`;FClP
cp 5c3pbB
#A3B
  QF6t
-A	
6718U9D%A	B4B  u|%a%SIMWa6720C&O7в b;2JT7`̡C0q  ``#PASSA'1=7$agOAC`y`4Cap	! a14E> ES?;	2CC+}ap^bb`a ՃB b ubkN )D5;P*1h<piKF#vL10L11/F5
cwP@q 0 1{q _WDG?
<4_c,E=DAAyB{M4C~ !f )AB`WMAA`F8ij=8tMnp{6
P\p~D!-{h
`7?{44[b,`p50w0Y4Qx21Pj54
b?  Q 8 AA@p!	
3/u97. #5:0 Z//Ma 368a_{a
p} ` W`Pqp'ta"	4[90*	aAnKOFB C,.14AW6
7a2Q!h6h	M_WEDs!3!1p{b, E@q3q02a12r 1p5r F`WQABNFOM+  D:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa t0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7G!&((  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	b`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70憁x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP_}E=<vAk@M,=9WqÐ
LްWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jL2
jԘt<
@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj',03[ 3

[  4 \C1B7
 +18_INI@L [ 5 Jސ00[15l[#\_GL_yh04BpipjkP 0F?\C0F1ho	l['['{`"6
!h0 P7a89 bA0C2259gph9U8849q7p{zh 2Bh7	7 A 6 ZEAo(	
AFB	P[E]D232_33 4 56 7@w38 ]9 r9q"3A39
[ B@(3C2D h
3DAEz F `@3EUyA
	`rh``vAmF 40a3BQcdp@ȢJac
`rd  b}y   @baya
a0apaceraye
	 evepe4c ucdcM
p1A40cpc  bpbgC	bdp apbe)ecpe ffg
fape`pfafgvdueA`b4` gT`	$b pg1Cagg7agubdMP
2,05#q0 p0`c`bQ5 6` u`py1 CB  D "h 4h H
bhc `r Dcada
e,37-adft`f	ru>'adSuc2ftd gr:`4bA m7 $3 F38FQ&-91142`Q&7aqD38p
LBC060pibhb)4p~0<44rb
DU5
j156"66"bF-7 w6
arS9abpb.0+bab`bab{uaaP `bu}a@/_CRSQ8Q19`v2-7`T`ZSTA t
`}``6@9XD!

	        y q38 ([Kd2{49mHH
 e4AF
RGGP   @  [  s3	0	  1	[[Ci4C}Q [194F
rG G$ $ GN N 
P P Gc c Ge e g gt t     3p
 A-\/[	BCna


W!3p
`q ^^.C16E3\_S0_S
 !  3   J 4  5   M\_?PTSph%_`9Hh
 Lh
}	0pz1-5e`Zbw1E8 BA {WAK } 492,092?010A&10C@bR 1#15a	46qTZw4E TZ1_
 2 15
a( 005bE

OrFacbcc:c6B
APRA0;1 
} b55ڟA6 1
 `BA-CNC2N3n4,2"0 {/J\FFG,
@
?|
0Q 
b [lPp50/51
 20HPw3
4
1E53689=A BQ2W !CС@B9pW16A
p;1({!h ?# >4Eil25E
pia p
"?1F$`Hpa_gܠ
DF
hl5Cp
`pi``
p
A#i p`lOrB60p`pha]hщ5Bikr@
Q! A#1i ` aP6VQEw
P iQx30;pKACLA!p
   t1t
axa

`b@LRA0

bt
 2
<QO


	/s
!
P'OL 2	FʰU@&d^dZ+Qp{4b{b
 t bbwb

araMpLabb1ReT1xfМ)awr&9h 1Q'A' xb#y
h`:I	{;b  ֱ@pi*h aB`%  1;58<`/6xr AAQ33`hm3_
b D*B
40-h `t`)`x`f3f={Stff 1tqB.cbbs.b&8!9bbߠK	iv

ep
d
M drf
g&5d3A7ef'i26gá&R;wP/1	-`abIa[B6 R64``
9_ON_  \R|bZS&pFOfU_WOFFVFD5M
O`ORmCH
:6
OfOt
u7
O"mOz
[68h"g `0P764[Q"hWDH5CQA Ԇ6B}7[H_AL8 1AL2	AL3C
B_A#C0A""1&"B2Fb3f0PSV0SgL!GyC юMrJ7Fi(^q03L1pI5p/$Z4SQ10Q3_TSP
dp T`CRTv0TMPP6[GDV6EL

,"30\/$1I\_GPE!
F҅O
_L00 tBc A@ XI{` {`
^a Qe` 0axӃa  ea@BG1E 1 C	{*679   C:CBC0Dc}CCE+c
@ ["ݺ I)O	C	B	IxDO	fO	CE["
dDP3o4F"9 HOH/0A*_:oo
3S/oB67CO#DEOL_L17 !82?`}8@24<98
w94P3'1D1@ `EZC55F*w4
@C21Z 1Fp0A 8?VL7eG`716
dDP`EC L98`pK9870wuL C ɾ `qN"00w8ID"V:!6F_\6a}`PQ%.EUDp(Fcu9`3@b'0??5`?
`
O
 `KE%		@233197Aq-[] *_
I
_!P!}D8D8Daa`tr 	b Ec.`k '1050t{a +cߤcMQ[@.4 
g[ /5pga)?5
0O5|bn1&1N
a02d7 o,}qD i@75``	|a)ApۢHc
/1Q 
8			vcvc}b0TJ F12Bh60 b \T>/SSDT{qЈHP  HPQPpcЉ  MSFT L4PO6@	1 3      #__T	_w 
_	O[7wj
ara
aVK4a]8P]9$8ijp!79  AhFI2EdJ2F 27A_27B!+A$91 JmVP3031KyjY2pzZ3p^j9m
D`tQabb`h76a bub P)252+1Ah BⴤE2Er9yF1xD,/
b+`1 {y U  V
Q{E'*[q~F"PDC{h 7FPCT q]F@7Eq D	_PPC 0Sq7C7YA7NLP7}1_EJ0`D2`pA à   ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ  _     	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n           VIDEU[0  @ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`. aP b  cH dP e  fb gP h  i|o jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0 
b3 _DATA_BLOCK x  
`3412Intel(r)915GM/910ML` 5MS а Accelerated S
Build Number: q Deva	09/27/2004  Q01:16
DECOMPILATION OR DISASSEMBLY PROH?IBITEDCopyright (C) 0-`3 2`rp. All RAs ReservsedPa@  g  $	

 ! 	TV׾D "LFPiz(      | 02468:<@BDFHJLPRTVXZ\ 9{   (  8  [0 _ @ Ā ( e/ `ࣀ _   ӕ@DԄHLB  p_ ! !Ԓ        0܂ 17 3		 ޽ @>   H `  |  `] =  # 1" $ (
 5 V}          A !  R`SI-1362-!Up _2  @i7 <cU
 x 
	 Z (?-  	Q    e	>N Ia(  QVSC dS?4O  
`	 w7 c<  \* 
ZcTZcu$M
 23 ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*!P @ X  ' 0hPR	 `"c6 X  1X (a$n!7C	d @A &066\ <0* Q 0@0p
wxx Q@ϯ(/x?Q&@X!k @H?@0b2@@
|/d  P 
00 d  @
%,@`@	Ƃ
)(<p#%%%
 PB. $< 00C"2/<@PpQX 82

,{ +a ?L  Xo o o o o ,4 Z  UfPfVfWfVtRu.t
fF䠆   w FF\  耹*FXF <uY=?}Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^~pZffq_f^f !;F}Nn߈^f~of~`.sf~ t$:V^:nQ:ND~tPfFtF;u )  
f~v ø t2:~sPv0v^*fދfV2fX]P!Rf3ffZfXþ   
@|   @M` +sw.2 t 
؃p.	 
 
f.aИVW6 tM r/u*B
 tVff" v f..L^߲ .pff^3_^28ev t&B1t1U
PSRV<v
W_2G$fWb  < t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufRe.u5 P.f
fZ
fVPf!0% `= `Xf^2dfP r  mf D 耈f ;r;r.T" 6f"2P#ESfQ@tfY-ffXz@G=-fS fYf.; r$ )[fVlu跦8u p+^`@H b,VW7u%f-2f1/O%1f^b,t$5&-rp%ufÂ 1fQf"s UP/ffXu
RJ8Zsfn5b1J7uf-qB7c1q9J1, >1AJQ9[Q,tt22<6	<"tR7Zr.
 @) j7Zs b	4.#_tu
 `, *az@f ` }uVu0f'}0 0"P.0nroooopept<wwyzi{
||}{!' < .  @[ &a[(8)8U!a*d!e!f%g<#h?!$P!fWU.64eހs u.Hw.p p=Ou
uοFa=_ i %)6I=OuFt=Ot=_t
=OtPfIXOuF
_u pt n)]XZ-.<t.:u.T!_F`.a   .aPw2143  p;%(VFE ^(p 
Oq  @=,. f@-"-u
/-F t߰ f#00.fB,fP*# I"7 n.tJf4%90h,fF$ 6+6u 2c0Sf[ u	uN I$Vp !"%"P""""	#
# Ǿ!%A!-(u, xR-̿rkPPt(0.u\
?
^qP9 2ۄt_q  P'1\wSfr/w*]'u{+`	,s`!+
"	Trq&s
!bt&S
[t t fM,ru%B_		l?s
B0(f"Q(*fR*P$8X$@
؉b1	f`2e(qQ	ؾf#.8u@rin#uc]3ZR,pU
 )  [_+a   ufj) + ff_UQA3+M*޴Y+dZ+4+!cuw'+pzkr{`q
W+faPSQmQ	2;YtlQ
 srYTZAQDtp^Ű@t@uY*Y_"utH/r.D$tt	Æf^ZY[~Sv w/u#
 u3 /-"ba@   0@1ʊ7 
[`}.tN0˶V uf`.VPQX	.r0 k%.8tYX^r
gf&⢊f_C	f`	s	qt!рtSR0Z[633xu0KbP<='$ {?p)|$'[ ?^X!&+&U$t Whw.QYS.L2.pe
QPfY
8Xt+$YI~Ц+.W tG#t
2tPS#[;¿Xu)&t0uq

uPSϊߋYSQY[r[o/(cQRvPu8ك zALtS=[rt  p#M2,,`U 0#;˯ qF
1Gs 0
p ѰRB	&Ыx$fS :8!ux'%PQ`UL%<vYX%r2%P PO`w% #`vX%	#XTw#@#G.&6
?";a`mzQ4
81w?0YGpoò_&@?XrPu(s#}0 ѩz Wf_ V.4.tf^0^0ѱ m0/D! fs'$t#f%@ }8ue? u̲t,rE,s@t9@ ̀C~ &Zf*ɿ3fK
f^	 f0ڸQ4,ry0S̃>|c ?e%YE# t3!iakʺT%V1`QXw

SX$w
؊"3Ҩ 8
?.[ *o+++;,_,p,,,	,*R{h"u\uS"u@$#P"BtPPP!(#fSf[A!#Xa0tX"dab!$u  Q.20;YrWot  !fP$ff ff3g&fGy#f^%T2#QB #Yӯ|8@!8##p ѱ2U z 0 c r	g Uw	t .:\s^\0W*.$tBuIP⢛  ^Xu,.8 #.t/s!P~//XSB#[dĀt
 Sg+r!0ÿ
"ff" H'`k&r7
f^&E$x $ 4.{
f+أ20t2p/fPWvPJ	&!QPYP4,̠4!2P`V CΦ! T !F C9%$t`u@uUtQ!2I's#f w<fQ%yxfYvt&w_u!C;Ht Q>..Ͷ.G$ r
Q2Srs[Yr
rL rQjY߂\PPtª<v>rs	 hPfWjrZ, . u.Mpm2ft!"SQP2~Y8[r2QA÷sYf_XSWJ_H_[drFsr?
D
t+8t$P`ՊX8udѡȱ`ʰ8px3
a >i	dA0`@4C&f ¢I]Еu{1
&&Ks"*f4pp끃 tހ hut
ъ-4Pb$
u$XB	X[	3`1
>J~U^ FVv
nB]FPW s&!Gt8uXuD>L t=+pMs4
й @B8e tC:er3vD6e3UX?&2VS2.6e3RF8r *[Y22@]F]W.>>et>Àt&}&t2,(-)*.)` O4eÿ~<v<t
ц<vєÜȫP 3bN<w<?t0f`u2e*s
2&J&P &L&ģ`&&pK L`  a3 43333
33344454
sIuM@B? &<w
2RtE>
tH&38pl
и 7a3۱R u tF@r!tu!WV ^_ 
?GW _uGG zd a `Zj	 QIڃ. `(.[IXuπð/؁YP%@@t	pTF}F!Gpu Y÷sssQS&G&w&_t0B JKu[pr&OP0 &
tuȋcPQV2
$̊
FY^Y0_ s0&G
Pp&?W&w@
p߀?ZotHH,2۰>tr:osr&9p,uh_ 30p?o1 

$0_s'h
 4G__.>`;`;^9ëp 0&$F@e;	@su Ǻ ܺ@+o߹  4t<v<tP&X@F20s @&f` P1ftJf &&	7
aTugQc$_<0tqZt2- ku "Eo aE1^X qqyߊѾ7P.8u*f{0 @)z"}aq`A(  `	s63ftft\eU} t$D ut' $dc4 AǀX$1>&0 )1VWS t߃#`IF[_^ rZf fV 2~Ê߹  r:<w40r*%uf21Sf[fPDV@gs05`t*Q.LYt  u
"8ӻu^ZSQ"s	.So[ Yrߊ̀vXq̡PSf #brcŀtʀ tO<ЛrCQoYr?I`PPf;Xr-u f.;vuqw	 `r_aYf@MRVSӆit|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ0e.DYXuP!
~[` 0"`Rf
2f&ffȐX&e&} ]@.Dufѯp0 tR3Zt	pp   t ϐHK%Q Ms, f+VmwP^ 	X^[*0
 ^94S
9B^HQKtE&gE`JE aJ ^oxйLHKDA&< <  I m  @   	 -`pPPд 1-l#PSPS +׀ `3 s<s at< rj7I<S<.97H<r[._{E#[t/u..s߃l6&=	r	;v1SSߊWм|@*t
 #u[[_[ø RvvvZvxЖnQrg  0K YPVPV<v	w rL^ r WffP@X2A5?$_@lsPDl

f*2L<w 7PEXffsfB fߋ^
`p
f?3f;w<<R i.8ab.<usv@C pQ2<v+<t'<v! tƐtN"DS_polQf
QPX@. p
.&R Qs] P;sf0  w| YrVgI^w
PZfXuEu$Pu
$0VW#sB d @&|&\CrwP#
Xu Ѻ	 Z0
 u^C7
f ts    	

#
Fr=.t 35W`@`8u
X@P@_2.@S6&[X<`r<qwRZP$<pw s2S#(S[2ۀvESp%RffZ{fp 
[pmP =.c?fY.1snfARm	Ca@?0xa,0Rb#MQN[sSuNqz5u߸ `2,"y:.F+o9sau\Uص÷ zMي3
x`@!2 g80"
Xr+5}r 45uUǋz% 2BVP3Q^5 M3
N] `WP1PS ^@0[HF`ۋY.6~VWRr;~s8 ~JuZ_^N t0S[_`\w
Đ2110CVz 
  j2r@p  _2Ph@ & PX60"2P	X uA0`2RߋZ !Pç[ ؆! PX PҪ C"	ƀu̀_<$
2`aesUDtMrEWfV.4.tc.TP&} _w(&
&Ut.9
u.9UuA>fQs^r
\/ r"DfPP@XÀPˀ  V"E`fa[f.Vf&f!u
$'tPAf%`b:ahq`5j#t
^tXqtftY
0t'u-`C1ȵqZڀ \`^PreFc4ܩPdpЯ @pS P P ?J	Ӣ&/	&  u"A#P
	tAfXf^r s  r߀tХ̀_u
_ma<XQVW_^YS. 	sK;pM`0a@s  Cy B jVS3۬
t
<a|<zw$C`^#V    A 72PP2@it.:u23PV .^f.<Inteu   	  
 	 RaPa C` PB BA B;rXa~s  .oH@uSb@ uP4[.oHBar+ 6  ;`&  f}8f%f;19RC}`VPMp 3f.f
`+؀nҖfAJ\ Iu	fSff@ܰP/]sPa 3{WI pWI^YRA.WI0PRf6 0.df 
00.DPR.ff.V` I .FFMȋF 
tJHa?  ׉FACFARR A䀀V@`*
  )]!9p#~1_$<AP-<uX.>Jt  +.J< P.tfcARtsZf²Ĳeg|ۀt5r	?Hr2dR]ۀt¥ `.ȃ v(.жuc.<s.tFbf u.t-.5߀ut."pe1
fQ̀Y   @FV *Os`5P@DXe<DG$hZ0kt	jf'`p- _P4=裂DHPbCCot!N`	DM 4Qbb< PrQQbU vhдS+	3TQgQӡs

rRR
RZR   $ bPBB쿊CZQ
Q QQ0_P<fƊ_$f==fffX°"t
p tf0ZYQ Q `  	Qϱq` S{
 tPP첺P q;4P U'$@``` ЖS S2  1dQ$d[$P50aɀS
S` 
  Rf`
 P`P @8ftsrg Z UdPҩ ` ğaܟPS""
[XȲ"Cc^p!%!ff6QPAQ﵀`  PA%
  wfS%f%PŀrЌ}P tn%2'ff)f#ff#fSahfA(-S-('RA'@u_ fP('fXӋ##[u9X.=          @     @QSr|wrwKH؂n1 V ;v7 xֿZ+q+±2\\sRfZf+`faf GU`F FFP.8\uE.T;u2	u	Ff$ f"uPfVe.  ^0!

uC⦾DD?  + оA<u /f^a]|s(1F3Pprif^@=wA@_`SRWVPtCO	r<.|t4.Et"0t.\Q" YsÀtǀP^_Z`UЎ Qs"0f&;u Eu&M]p ArA	ȋ+;r1;r-fQ&
 8;nfYuaSR sZ[.6P.8u.| P.;6PrSRVWr;u6wb	M1 	_;^ZV3St Uu2
^`WV_rGf^u4t@u&u!SQRP XZY[s`^_X@0`Q  qQ{,U .8utPYf$ADDfIN30 (>Et_'WuA &Ѕ1/f^T4r$/<t<R?r~f&?E   3@zG$<<<f RVr
.|!!^`Ȏ؎ `# t8.D;..\f^t@ 

sV! 
r.PP

]aÿ`'r~yRӊP` X Zun1tQtLM4s@Ass45s
7=v<?Wf_JJ^uS6BЅЅ<}P't0BN-C.
t<2,!+t.
,G<|`$QET:< PW4 ht@YV]6ϋ6`1PVH9""bZl@#u;ndWfA6fQ6PrUwP2B#u[< mk EZXYv]_֊|PǿXt	+t8 o  d %-|Ph%pM  := f^Vr+;t"s	Eu
< u	f3@h3[pt#|=p@fpQwJSAH[8 rQZYs
R sf=RDZtr$|qC}Kr. u)"XбbtkLUsqPSQfVQ  rٰ6.&:
Qyf tFf^Ya`s%(T?sHQwf ݽ3꾝0QѓsxuK= w4 w.HKPPιaUZ;v| Q+tN z[[[[ twǾT[`P÷ p  wf~%L t@ffRZXQ`;v
t
 
 
" p0ƒ΀wWRZsNp/p  .:?u0.>`(bJ pZu.n2`Ґ0 
30;} .	fv?fQ
P pZ
@JZyyۑHp	iAZ3f
 ?Q1VWfǀvf`K1ZP	-ހrs$DV)`) ! 	
PSfVPMrA!$@uc] .@^PPPPPPPP P!P$P%PSwf3]˶a0!{Ct3`
ނ(ZAt2 2h2ۨ#?qfq 8 !)} s@PWvijRfZP[tuU  updsEjtz Rs3 @	<wPpXs uPF !Gb'_1G G
t$ 1C ]#;tt|AqjFGo R*N_@uNQIM_____``@sþ_-FF3F۴ 6.:註Q0Y 024/sR Zk>B p!K2^@7 V```aaFaaa
4`~2C<vSƋ[tq&fa/ q'@'fk^@T#t,x
<pŰgĊ~,+ ,2s2Su; xx |s Z þ/.0p Ϳ ȉNcfCp7: c0Y ;f P(fu _t7f<) i!ff f4Af% ;WF  Àu#\"dnR \gQ-00
Őh*ab_bpbae@ Wf_fVBE/fFP﫰zA
@C1r0f« f ff+À fG
f p	4
zqf# $0-p8u2uA\4 c/ctr ޾ 2SE4
/Zs
 u6@$ .(vӀ۶vu
RSpڷQ[Zb[S 3ɶ6u6F #Q5$d"i@ PQRVtHc.? pVP<	觧r`9f t4W_s)v!f&y=&} u &G
aÝ`SasSRZ q{3ҋʰgrU]deddF5
s;pw S.)d[,JP@t  5r=$ ? r@o{:Hp?7
cr" ^N2$1`8t\tCf	gtwAf@btir߰a< tA@CӴ1a[PMIDn_    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS  Cor;poion#~ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq  5  0  2   fg;iiiii7j<k	kn/daM`bf .<t.:utOFûE2&+]OuMWPESAP Ÿ@efefP@fXfQv4F@;t/aQ@wetf s tfffYfS_uV f&E-  ߃aXðQ .V@Ύ޾eJ  @e suVoO$ G֨_  u к a^@ @`^֠ ^_n_ի o p﫸pՊwfۊơ ܀rf
P rf@@f2tm?QRf`af3ZY 
LՁ
Պu9
mr;g$:Iͤr	 {@p`O%nN}ӏͰLrf
VÀ>Ivm@wdtYw@t$;wR?$;v@fc1q t@~`3xcjjcjjjjkRۃ`܀  )j.$fat*R`@	蠟ZP	XfN Hߓ ~


F wf f` ta f{I | B0a~"_ $y+Ca6ӀtE#>âw1gia% _ftԛt)vGwAºBffP S ǯBB젡T 
RVIӋ_ݺ P!=ݰvp,8 t3
9P%ҀsZ2fQfBQP
fT0fYR CIR[:Tt` uZP̃XVD u.fD
f=8w"Њf`IR VfZ	[D^ÿf0.E.e! *$P	P0
 +$pE0	f .4e{ fڐ	߀8u{$?
!32IBߨu	pVr
.
 @?$
ÑߨaV.|^쁓"2f^PP>} t"tt+t.D/@t au V^r
ޠ
2^< <#t2 <"t
+ <!t  Q`u7
0Q2ъȀ
ufPqu;pusY@>݋иO O sOYˀ u3u"*D\讬u> &p`uu t kudu^sY8s
tQG8s8s8t3 t-0vv&8swˊ
r*ˋc
qP8bu J NذrPÆ2/ۋ<q`R
tB@a1p@2$b&LN @<v0	r	e狕P鑘쿉F ^Sr{Bgtw%gvk&J`֋&FЋsBuՃdr' wP酓zu$0<0 t**F 
t*02P ؊֡	a>`w@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQWw_YuCW B~~	2@
2@PP *ڀ n@
  toʋ?XZQ2	/ ++(+t؋X:  + 
"a݁{BtG:#sNOFGuxsOG$	B y*2n10>K , !?+ 'k'ȋP&1u'D`'$4$p&z  %2C3, B"pCR S w؎
]ȑ'Jur&^=ց3Ju=>wP67)4&	55Fb1QZ6c5 XqJrv
t-r^ <G!M`sw r
&XtR٭נQqQ0QP2GtB2E tO FƮS ƯPЎȎ~ 0u.&>| t
$𻋄c-0@ȱ\/,ppRC&PD+(2 _6t
0su@a#Pb0 2&<u2ۭypWËUƋ0t
Ju]+
]Q wLwPaz x͋Y$r!v$$:ˀu　?600Ql$$s$guz
o׫3*48*0*^OFH,G}`/$ְ /Ë?*) j
y$6| 62 u>
xĪm?í&0  &0%Ê)"r>^!Mu0+,GY3,+K'B2Nğu9@ZZVWѤ ts
҃_^GMu۸ ]3@ø&C$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>fo߀  
T fR@
 F$
 r7uɊ PW.>eu>&}JPbQǪ_XwLԸoǀr#Yts-" (&"%
Ī&#Z
rɀ\sي
u7!~y@s
x`ALuͿ1x  w 
pd!! esX @
ff

W,	0	ϳ2,"yN6@	@	ʸ (⨀Pbr$$pt<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [Dorp^ʊ3?ɸa~0
uVЊdЊPSQRaPaDnXaZWY[X|*v
܀ՈF0F02<}:}C}\}}}	}}}}}~~~&~G~<s<trtt|0ù 2&<F 4w t3&ee!3<
EQ.~T  @@5 ß`P&0y OuËÀ8 0
1>ǀh  fnNËEϊĊNuÿq 2Fó π?} Q ` K#Nu	f&K͉DSRP$?.&\~RP ^ `~[[c   XʊZ[PΊXPvXP) ~~~~l|8 8| <<]<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DD8[p
~~~  Q  	 0``0A$BB$@

V` l$Q  ll  l ||f6j 8L8xz 0 0```0 @ y <<fG00'0  || 8x~ |p <| <l |ƀD |  ~H  a00!2  
x | ff|7ff    bhxhb `·~ @< p flxlf bf  ΰ|`Ư||~Z<ql)Ƃ  88l#<2 xp``x  x -/0 U x|v `` p 60x00x3v|x`lvn 8 1̀b /P7ܢ-T| p| v | q$4-4 /ll3
6|p&0d; (1B 00 # vp?&qp|8B
|!f!&88 `x`:|~~ ~΀)".a0%||`l``p9PH~ w?p

6ff+ 8<}448ll8 6{0` BU6F{ \E|1S6ll6W~` l  "# {U# wA 4T d  6 dP [ 5 NOqP_U1UQ2dt770?dK?0aa66R9j a	
Q R>     tv Q@bC8~llHO3O rg8 s 8||`rTXl( <"CBfa||"|DPh"  l~`l~ Y%r[&; p0jo
G<8p(5ly:}Xl<p&PlN~0QEP< cSld$DtUtZ3ZNTvTu W32xQ|2)
xpbn|ll[|}20ư a4!֕BP{ |`Sl8>70k B @sV &
񉅇R`g#Z8|||8鋊;ff""AR	+p+q`llҒMv	܃od  $5)/ԑ#| 1DVsr  @Pb
1upbᔳ 2ES67
  ц%25R$FPB@S9byA1 `	Q$(f  PC=' # 7%7@Pa "D"%
t@Ý
0l2`6$6~~$E47㠃#
l|8@s3OƆpb#<,00PcRr-0Lu;T 3'$D bZЦe  1d23]%@`aB=`_ ְr;b95Qp$R "ëBfӬ03*Pw~Ry Ap otmeۯk5̓Oh0xӰ`0HH0i ! ah tC[D 0fAxxAcl>j%Uڨ	%SQ#xFΤ W1hPr`xC0q C'7!1^ H(F/`1L!#<0[<\Qj0FespfS_dx0`ܶ=> lܬ>ҚdwD) ew) )ü ut  (Yǳx 7ȥWU> T 4˳ ^S̅d s͢Ͳ5Uc 	&
J TӄK$%҇`Kӧiso
̓@"bRt``0`&"bct "1آ1vetn v ||@<`p`v3 9 tt!K pܶܵ*$1R3Co0`
7| / %4 FU}' 27Whu -7tu #8] /䳔TJ}800% 7]i4&4Eb6 ‸ <Be aְ" 8Fdv D%Eu\fRU 閝\
 5cх ե0&C`e t% EWu % Em  'D~+NWB^ ]Ë
  1 
Met4 G= &tDftt0
"$d #$%e2 3401hK"r5B Vgv	! "f,`G'aw D 	8Fif. GeEt8Bm`lx@-Mo 
/on 	/Oi .Mm +Ok /Im`tܠk$5Fpctq =FTfv||6<] }RRfyѯHU<9ر p>| o` ,4@IXg v!"ť#$0v?ѤƢË5þц&) ~ð 	!S P   1 0 a.Ԝ&6| &>~ ÷
*r
t	2.ò`Ϲ  ~   ц~тє! w<
u&| ϲ 2.^FFF3ҹ `P樸` Ԩ ΨȨ X  * : aQYSظ s2t  [߸{u ic
>ctSÐ/    ^^ >I辙su
^ t 36ȢJ2 Lc&>Iu	B$P
	JX̀v`
p uH-ب <ĩ_tQ @ rw
2F.Ê.̀Nп$F $FF.q( ک _ZUoȨè<w$u 4$
p À0&&_WQ	_@Z<ow?1 A tSD[
*!&VUNq<w4#@tÂ u5Bcb?ȫFt#!)#
 `԰8 u{ 3ҴugĠtb(u]̊.-ŴQYR  
 8 t$8u
;(
=
28u2ɋZ aR23Z%t<vÊ>bSu
PRYNVQ~ċюF&<
vu^Ft&FVRU r̒,]Z:Jr92:6v/RS=b=P [
tZV t^^YuZO[
<t<t<
t<
tx@(` t
t$0<0tur ͉N`u6׆s%&2Ft0 u*ш)s&:s2& #   a     ? t"<(* II `ga!I<v}	.ǫ.﫪tI<tE2<t?<r<v7<	r
<v/<ov)W  WuCt	t`2êSPm@X[$t   ͡ъ$g`Ip
P4
ğ3RQ$2.>euZ&G&Gt R 
 &_Wt%
&;G 
 2    _ @    fPQV fVf.Da 4f^^YfX< !!ȭ14f3f^FFfPfSLqfa#fbff f Qf% ;ëu@[`PSQRQm+YZY[Q Ƞ@YbMfp/Pf.}.7/
CCRRt!Q̀YZ蓟7t&p
t&wG  x    b2
f X蚠=Q3&&Ϭ&I1f P tQ | fYÀVFF30^XtJ՞QF	 DYPRfW#0f "!fP   f3{迀   0K@P sg  ['u_ ^P
Dys-pCR*  CA	  
 f$ wq	y
`F0
!3
y1

f{[X@f_Z) QVV԰?^B*&5%&&&^0 &T@pRV0&$F@&F{誜  PX@F2ܜ q`^ZRDMZ@ h$Āu[Y27V蕛嫊Nu^D7QOC7R虛f<Z4QfV6qf^Y55`4h s4?t47t4\@̗4c464
åQqc22222222RV2B3۾2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              !!!!!! !!     #v1xx">Vz==8f=,=.=d@===H=z===y==BH=0== = ==
=v{f=Y=[=O2%>DU>.P>SQ0!2t$L-`}$Od   : ,ĪaAUc	PCP@P @ UqD"wΗX# ԙ0] 
gh2  ,h	PX^oߵƮ`. fȎ1)`.>f; lf3AHr(|$utD rq  m.6rӄPgTP r   r{Wށ{
 g !^f t-
f&9af&_ M f+W?. T&= tf&m)!_qffaðPfq EQ M y aR $fpf	u(ff(`m}p r} tܰUl pAw<f;%+"l r&;f&_HIBM
fHQf=ؗQ
 r2u&} s
PQS-[  <
QW 
 ftV`^tu{A_Y `VqeB ^
Dƣa&Eǣc\ ;v++\P{=;6as;>crڿqa .qǾ覎ñu6xPt'v %+	@Px N ð  t%u7m!Pfpۯ? @6 S衖[ 虖[ f $ADDIN30,ϺVͻ AIM3b0A  @ X@ Q Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Ef.>_ v `pݺb 0p8fX 2ZY๷2 о0sbuL.;w.;v
RWfVvTtOBf.G} u"Ұu0R j`ZR Zr
`
yf^_fZ fV$< v99fb #Vg}? s1 3LҸq_S fۭVѓ2П[S @t o3ɐRW칀t
_ZP9.$ W4Jv0_ `@n$<u<.\.r   PXfTA2f`1 #`Z`@.&<
UKs....@  "PO߳  5bOukRK6	~f.d..\= rw rL<&]fff.	\. .FG@ P	3@  .G$0<0u.afVf.t2A.Qf;P/uPd H0gZf/^[ ~Q2fuf؃ %	 ͫlqEd34UDpīĳcŝ
D	V  AY DDPU@DSDTY@ " HD|   G? 	  
@  $ 6 d_   IL  J ]B 	 @ , "	eJz ,?,Sg[ 00?	s  i,,


j6Kd@Xkl 
 
PÖ` q@Q@kQm v lC q \ l @AEq@k6
-2-3 A  ``_  3 dj 
=uz 
< FL "Z  L  "oV 
u
 ?E _S   
E 
y 
O 

SZ ߀ MnE(  02<@(@(w<2 3 = < @3`= @<`3w=0; 3 ;1 0 4 >`{; `4@>w ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9  6@?906`? 90@06 (8  7 (`8@7   `07~?7`0r `;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 0=p    
>* *w8 1 g)  @? 7@1`?*)   2 )6@2*)  `2@(v 5  3`w`)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3~ 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0=H`)`' >H )@?X(`$@#a6@-@6-6 -,5~,7@-,@ 7-@,4~-8 .+@ 8 .+ @9@.@+3`*:`. +@3: *  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ @? /`61 1)/)1  `p< < + + `0* `"ú0*  1X (& @A &06DPѐ  ]Ń mP鈱 f%Ѣf=u˷XПP R@efթu= w
`}w6fQWP3܅tf
@@@$	Xr/QYv
wfD f0W_{fؠt
!c@C"A_T2. t.w軇f7?0<1̉@ൣנrWRZ_Sr3F!f%SSpt@f
qTaf+Q2<n܆ `2f2!t&º2"@t f0fXf^q 
fш"[ @:=vL= v^"m@RfP0e
ڠd+3
0ub(  <  wrP+ Sg[0]uB1
j  ! R b r "2B !Rz r [   dteuVfvW V
fq  %"
v
=r 
~ #¿ %B
  #  #{  }& & F $Д e Vf W ظz@ о?ǻǹP0 	߰ǻP`S8t< u	[X󭿋ج@0F f fpG G1w^0 u4!+ ^_ع  `J_ ^V @uKfRPA|3 mX{/ ΁ J G!OGfZȹ	 .8t.L
ǃ	!p91 SQUT;AfWaŅf@tXa覅b¾Z$̥̉  _ͼ    ʚ#ʡOGDGoration Generic Device 12 A N@1f^t" gr	c@a	ÿ@tdaQW&]rfS+~f[r$
ط]Y@00  @  8WPXEtpD(2f Yt2Q"Y[Z jAvdlaw{wuLff@#
M[ZQV:˹,t.9Tr.9\r	^Y 8t&;Ew-&;]w'f0PYr;Crp WsQ@sVfW^W &  &E _^rC&E
t{&E&E0QW  _Y@f趇fZr
4ps,i_^ t`mItuȊȰfu}<u,."/\pE QrH&
qqEq
	.\Io膂7fX~{'_[5  ()bc./1 24 7 8 :; !  {t	M8 Y͹ *m͹ !Hf2~QR?ZYa [<Q+ +
P>SQWO60#t&#E_QVfS zt!`h"2BRbr#3CcshWj[zV  6zu	 
 fftF.vfSVй-PQ3PFffs{f  ff^}qz{~ {ffI  .`^s fPHfXϊsfQ@6Q@2{tQ^qUۄs`+e6X%P?q_`f3*r`g}fe  7br   _rO8 9 f&] R     ~ f&	Ua WIf3fƱD<	t<tQ<"tm< c<<<<tt    BfP
-B?p. 
@@t^@@"f@  ) ?  9 0 f@ tϱ3TX1  f&U&]" sSY t;Q7FYd15_ҩ2Q
ffڹ?)r'z}SS
S  } P`;C&]_X|RVJr.|QQ.S6[rPXff_Yq6fPp )SQP}XPSe| [#w[ \n #
RSL[rS =ArIr@	yr9<uu΀t"tt
rfPfػfXQQ t!` u@rt@nr
dcwπPtdx @x0u!̱t`pt `|RXD8tmrZ6fa``!scwT KgֹArQ9rIԹ-SKQr3&ttsms](a!&0']v'M'ag I!/]Qޡlr ;E]#`;`ߡrMfa%q_fotdЏѰ #^21P@U#Rpf;r)glsPR$4
ZX	@CRրZr-kH&}_uu4 e
$rӦbQxTotal time for VGA POST:   Seconds 0.000 
 initializ" < 10 Milli 
 `.&Zx.ԃ.Ը@FA.Կt.ԋ.u  6*Qjn` 1.&0
qs .aPVJP% t*.?
.8tFF.L2t<cs^X	
>
2.Aw k09
ps4pW苿oꀰ4@
;
jps.$f{#9y52
?ps2O2@nq"ʀ)2ɳPr0kptN3pp.>,uyp2 6pt$.ppbZ 0nHվpf.?f.+Բ"rp{p(sp .
&t ?詡:0fg	fPf.>1l
UsOsIs &Cv { 0@f`RupA׬1@f.=A~`JpAa
P`+ qfpf tp=wpI8a`p+qXf-wfwffI sQp% f1vYP.
hXú#c&π `	 2Ϻ "ĊRZ$`
s$.
tAP0ԋ	tA.
t*. 	23.. úUpUuu_&
#0F.Ի e* ˿@   Y ~ | тPëO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       t     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    N^EAX N^`  p L   O^A B^  C{^B J^ECJ^`  p K{^CF^ED`F^`  p aG^DcEB !6^ESI 6^`  2 2^`  :P w:^ > >^`  R^EIR^`  V^CS
0^Drq .@,^SQw*^F(^G1Z^F 
r^DR0 vp 1 z 2 ~P3 4 {05 6 7^K^Cfp Pj PnPPQsXsp q_Qp 1##`p 
_
___		_l___ѳٳͪճݳ_^GDT ^Iq ^L ^Tp:!_rp Ps~wN^N a&wB^S J^XDF^]
A(6^b2^g$:{^lZ^" "V^:,R^  C,^D>F0^q".^u *^yD(^}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw^=v^B z^GD~^L^Q^V$^[^`^e>^p^xDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^^Tf^j^
n^X4`h4  #_###
_#M_#	_#%& U& & & &%_%%&%Fy_(b+^-^ ^'^%!_V_VVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` |   tP  .>t:o$>U U#uG6JB qs
G≠} u7 V" "$r;sc۰$ 	 PSQRp.^	c(f.^f.f  j AnAr
u, 
^ t$.^tN^ u% ;t	.^ urt.^.9V^t!`	c.		!w?vp} a P0urotib aa
uj. .>_0u+.^t
 ut-Bt.{_ ;3΅u'u2".K  d` &.ZY[XfP.^P1_af`~"r">"e"
w B$? 8 b ",  %" L faù   Ptu
t>%Ά)u	{`,Ò!h	N
	 :twUq cs脿  gfPf&@1a}1q	21 -6U`<u f.R^=fu<=upfffDf.
f.@#(R^fC  f. ./`c .3pk!>/_d /_8d A9
uf3Јp;ZYf[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:FsI>%=s@>a4s7>(r;< u<~ <A<uB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI^ u\P@@??r6aftf+fx`Bvfu	6Aff33-f.x'h^fZf . CZ^<7 &Z^KkJ PQtނSc ۄr	KtY`Q`sV2' !	 詄s
ۃ`?r_^QW<;t=ހ  ?A Ts?urwT.Ws_b>蹃tT!yu譃uP	pX
C=cur:f s20W%t r#t-6-0/o
r\afb    
   P0t-*u袄r,$t
>r.d.NWa JJaXW\lWt5@"7.R^.;I`uf.;K`t J^\ o`96XR	r n6S` p2ft<guX<t<t<guLpr
t@8.T`><pV3`i!<1?1_?(/_?pÍ7:@!4`AG `Vdc1a%ea ÑЁtI.> rÍrD輁> H$r5} uf~!u%$ "PufP 
t	 R|]MS?e [ 6[ QCP
[}ߺ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>Yr#2].^.@N>Fr=.6l_mrDP[	  {tr@  ^.QPpP f T G@  >i
 rG@  /h !0
 G W'r{W
fv`GG ~r u6ЬП.O>
 rGG s'~td r#G  |6f}bMQ}~r0fu!`A~Fue`f10^<1pkY!\/U[[P'0	Y r'%3]pp@b ^ B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}r^ؒ0	^}`~{r s
]usB}u P?XYR
 &ies_/numb~ PQc bS6{P g t"@Qz6z.^W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  vzz{wukG>!t {6oRz M27`Az108J 
G6>}zfG螑tk{[9zGz:.
~z]"z4c{"=-8E 6	7 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUА kt`@.b 6ͷPpEr^w
f[Gff.!!^ At`	PRB ^Owf`fm3
G
GcH?^]_^dW؍ 
2; @ T_oS
Hg7 sI &Q AAAr<s8f f
up^c0Soft=jnovailq..
aGwfw
`VVQ@ u
D- u+@T rp] u62iwP>&	 EXOAM!~vAV6@
 A5|t/fTfpdc[./_D.kGIu^`!4.Da9O`u.S`f)_a-_a` &	>!VWQ- Y^_.^@aPPR^ !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^An$ ù p    \ PQ1.E`..{F`ô rGGA`wr8k ~5`f}u`uup~MuvOOF9zA:A0 r,P;A5`pvt"	r=`wvr
l1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    Qut+xt`C 8utw Du߂    u  +3R0E`F`fA`!  [s02!^s] E!t?.. ȰV ঀ;t  E

`t#C vu0<ro!
 12Ui^Nx ~@v r^aA`+
us>srvrs9s.,!, ssB;Vr'swAɡ`L ]rߴr6Pr$ @$rP{X" i . 
 A`zsuzisu#P# f֐"Ћ޴ ui
@)@"<#f.# #֐v` !vf :Ц3Sp/"f2bZ{p-_.9ud@VW/`u^/_ ptR-)w.#
t0 +Y0#p"#"E..VW."Oqp 
f=8s6q0<qr@Ӎ6E$p  >#o0!.#pLr.	qCkr!
VA4s: m|0;q$$E@0 ."  %?="/_pq'oߍqo opW> %Xq_rh߀< u
Pp PtQjrpψ1@+rp6%VoGf." $P$r胿p" .s{9ojp|}6o8=oC*yo oRpHdFouat physical addre_ss  N fpC ðSms`rkPI_,tB0xBls` u2 `u6;&nn07!q~noV&U>~ o {+@MemocompsuccpfulpW/'@9	x``>ף&?|F K*Puf6'ϵm]b>`+nf@O}mD`maQ1`	#|!!`mnlt `fHt2}.'Qr8HtgIt[ntYrTK. LU>eAJx1/P6|` r`sUuI3ɍ>`/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wt(lr%lFm@^~0N^ 
\Q&dmtvv rqBBEmtT rp+9rFB"ym<Lu4Fwm"d r`adv.?*#tud0~]SWf.>r<:ufF	[nrfF>	 r[SRir$lr%} u   
fnrZ[s   >lr<*r>*!Ds<$ 0t`.R^j6VV.0 4*=B* ku  тKa.B*?ޢr`0*wH4* l02kBr&`j r..*.5
8q>*#R9 	v~g	P`;D*zFp !8*PF* sQжec`c||*|qgF!
Hh>J*~.6H*@G@J* yaDH*@F*.4`98*w
.B*PD*oN@qws2Dt@Pp1`  .};uf.;u>-߃(swh.Af,  5p مq	tPuI` 9t3..>l 
uh. lV~	dhm '''"~ "

I`P.;K`t2IK`fCQ @c3Ú;	!>Sq@K`.,6S`%3@(.,@~R^FkXPW\@J  aCPU Time Stamp display= Speed= Must set sA to enable tsrhtJjr@de=@h.vVhuʨ^&>rN _<uFv%0.f2.^0-f. g6-fQv3?sggR"
c ter =   uSec	gt
ir!6.ECx!1.1fÍ>`gtG
SrS 
<t.p&`~gt#>/r/.`< uhgt">r.`Z
u
#l&W{
*Targpis@rt . R  manually if fails 6i/}eq9P=died^V6WeiF auЗP65e6.e ^D!e PQW> Ue>U gg_YX|ft2,r05 papPnr.p Gfu.  .D;& $Ahr 2w,<r(.y됲 #rCF YXA*	_ @p>&
蝿dw@zibu	1PhWi.Àr p#rTR.D V hRQh_NdS4jXoh0x I vIKJV  @OAL"q$ecYQ*h 1h
`Pcɝ
q.LO
(g.
`0U+g``	dy'g0
  &}[Eø s[>`tFr6`>jrG          ??? fRfVfWfU֡a2@b6m222o0 's 6c3>2e͸2Qɺ2 +C԰ͺ?2Хһ2 uj.2amaк2a ݯawb.2qa
 .+ s`@Ub6p`Qe+Ȓ>p2`$9bbZ
!Ҡf!2f]f_f^fZ*02 3<dDgw,d P$<&Xu
 $	,<w .	272N.2Q`J<uFN$<t
`RÃ? t#;Ot끽YQRWSVwd^C2.;~0t
|/2 >22։EG.2.2fEfG 2E
G
.2f$ r-/te   @ -@.2 tP=? @ ?Xth5P[G_ZYrepe  ` np VW>#3 tPo5c5ycqc6 z& 2 2ѣ>2}p	, 5' #X	&M';c_^ cER}6PfPǋfEEE
EEfpHQVW0G"u-6jS@0t6S 6!TuC_^Y[VW02
 `F
  fPf$FfX o l2 EA@ ; fQfPD$ us+ؠ% si}
uFD4/ E}t#uS uN@fD'  620( iQu K
Au#*
p	rg`1g
 /u,	 ߾1q/, fXfp5 !Asps0Y+5 <蜽 7`Ռbga5rӇq_ie@ aȋ`o$s"s1fEZ0!`D1S
Æ	!fo+B>sQ@"@*#@%>dޠD@@ᾁRS`rfe  #wbV+?^	sFN+R!%Dp	D
9MRu
HaI I7`&!5 6^<;us
(رN3AaNs@OA
Na裹 Q5Q5XQ"3"+ɶ8Qs
1oD1 F$)-R&d
*fs.:a	qmncVt@;f%$Pr
蓽.@qFbb$)7+ɠwPH_+KgD5VF`^q65PKAj5FFo<^P9d)?w76sP9N; ސnV@Ai8sR176sA묂N1*B<p fgF^Ë @t@t@ܼ$#7!/Bw)|CP{u
<s
>`uF@F2	E TE̼DDˢd%=upb5AIaR-df$0	К(=(t`o	
v+Ұ=uruQ2$rStY0< 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`qC|0^ e2fedwcD'dS 
pedQeb41>"
S~0 : `ka[X449Bnp^@2G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrte{F@0r?gOCf_2`0#escsssdsfs_gsfWP? vyB6X
6TA]qAAܕ ݳ@tޙD ߌ  + *2+*4+*8+f5c|-u sMȁU|Єu@ftsPørcp d
q t ?P~a slc#fEst a1u`6`%["	
 Kѧ]&rbpBb
Fbx+si *` d` p p P" MASAYA_AeAhAkAnA uAcA sE
WV6qAg4FW^_W t 	p!	
  	M
fw_ord db q tbyte AAAAA" Q ptry  WV.t"Ü6B:s6B,6B&ps#! BpR6W6B_?.W^P2 fXPľBXP $0<9~Farb !Ò  s봰+   1$ פ s뀐e+s-!sfR8    R8 `}9@  c      re d  (    $  ' R( r, / 0 4 $7 %8 < 4? 3	 @ R/ H  P0dX ` R'?a  b R69@ c Rg> h ; i R<` l  S !m  n 	eo p Sc9rq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 YIS
8&8 ` f l (0 8  LS%  Q   VSr/  p:     ZS00'8 0n= ^#2  bS>, f  jS:Q+ oe tS#, z  us 33  ׹;99   S%<3    4   u   e 
  H:\
8 S8 Ķ ȶf (v8# _ S:rð T t  ]#81 S;9 %˰ t/ SBFͲ b8w  % T98
,
 
b


r
QL T5??   ,Fw T5  w !e &  +T;Z .  (#  2%T  )`$ f;B` } 6	  ;  Ae F Jc87r NT޲c8R  Vf(R0ZV8^s0ZcEw g k	w oU
 s w0^D8j}S jSY>c 28(2Te0@9 {T>s  (V> ;u ztn TPb    e ' V 	  `d$ T$=  re   E Tܐj	   ݱe @ WA  B eC D E "uF )%G 0H 6I <5J CK IL PEM VN ]	O dT
8 T>8( 0f8Te W  E|e y5 y  yd y$ y yt y$I y y y4 y y$ yD y y	 yT
3 
1 
2 u0 $8 T	? ȵ  e   u %   5  w UD 
 w e   Wc8 j  r< ! $e  E U9  8#E(wrW -02 7v m;&@ E JvO& S(Xɧ]Ueb gflmqvv{&뉆쏶6mF	V
¶fm

v&660S
 es "f(.5uVr|<VrB@ EdJV8 NVUsf(U 0[f8cjp t`z 7 50툶 8۾(<V8w8E   (f08t
VуȬ ؅ྲྀs'8 $ $`$0 $ 0& ˶ f%ڻ% %08  `8  f!  CC%D\DEFiGHadd push pop or adc sbb and daa sub ss x cmp s inc decaa bouParpl imuP nsbQ  out a  jo jn@ cp @ z @ be ja jjp0@ l jglg test xchg mov lea n cbw cwd call_ waitf/f sa lQ 0ss stos/ lod cP
bbb b rol@ r rc cr shil@  a@et`ente"f`tA o iave`md x;la@oop q c xzQ jlockpn}ea e hltP=c t ne div iQ clVtc i
i d@d"xzxW lf0gpsPl@`hrd bsf@ r btr0 sp  c i 
x!seP 0 P b zbb p""epprb F`et gpUr 	l	diQ }l msw l`Usssss	verR w f fchs fkabP t "fxofld1Q l2q e1piBg2nr z f2xmyl2x fptan` as r}extrac
.s0
f`/ ]psqrs01^%frndq f &+q
ucompPendisn0	clein+!fQTf /esc
env
cst   fre0Q /r(Afb
ibC

;  ?	A	 r=fi2a (~ wbinv%wa ::ob @? 6 s zs 0@F:@s s AlBA CgQIA 8@=puid rdm-rdp 4rdt`rsm u_d2 wrxO .  f  yz` {|}F}.sx33~	t.dG
{U.
EaF,(-)*d.V)PS [XFe$U<v$tU	&;$!!{w'E t$$$I4芥"轘$Q(',fU$-

}E%$0_c<5r1<" t3"${v74&)6+t06-U0E#3$6Q9uF;m>'A0Dt+=Fw&_<JF8L?Nt!@PE,S<$VuBXU&[UD]` b,cf1i*lވ
nޕ+q#*vu
UJxL%{E}G/{'0߅#dP}POOQߌIϐ$ToT<(YUWeCC'jIC<U&@'tN^{86tH`߾&@  6W f3 t3Vv^
ꖿs rP %p R R  A
     <   P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vFt  /֐ 0wQ Zw;Px\@by        lʴD` q	                                                                JDBEXEPTNŠDBWAITCMRDCPUREG(^6RDwDBG r^SwCTR ^^MEMBUF)_ɠ CMRSP`IO?PORT5`aT ISPTEXTd̮/INSTCODEI`*	SMMG^dESETARGЦ/0UMEޣwWRWRQ
/`]{RQ	A`^WR 2Ds`/1]{WRy	 	T Tp  !!EOP
                                                                < VWσ    -$  rtˌȎ  v$.UpfP.>Ap uWP.^Gp f3.UpW.H@ I O UM N@EB}C ^.@ W^   ApXfX`fSRoP.Bp3ug u_tT.Tp$ ^t?$.^ 0r'pEpD 4#r	
XZfy[`Mp0Np PS tatCu?L7h@ t-u$ظP hh Lpr 	uI[Xˠ}C'Pe
.>^ t
P ZXPw Xr$$
0
^^5 _r?_x   hP~ Γ	ruX0rPhBfP f"wC 
 f.|p!VQ6'f6e  Y^PSQfR_V0*U0*,&\f&Tf	 ^fZY[XP3ێϹ  s ˜W0   # Uq	t a*u'W 4,4^ u.>. u.8 t.9  g JPqGp } y}rsng#c\XQM}F3B;	70,%C
!}S
 f`B* >(^6.>^0A6f.R^6D.V^ffX QZ^ Пfj / 
uf.R^>r^>^^)1 ^ p Z^ P3r^# v Ȫ z Ѐ~!f%#6 .,^.>>^66
0 6.ffaJ f)!f%@UPJR1f{-pTf  K 0UP
_.QpX`0^fZtV
^0T <^f%'f
  TPV!	.Qp~w

.+RR
.^.GPW^S >^^ 0 MSZ.&Z^Q< .Gpu
@_e!QJu)``EKX!a @aI	`b  .S	k!k@%"k
kf8.6V^.6I`wf#RAK`f6O`f3ffS`kArkM3$tA^`.u	DVQ
6ed dTpt	6eU j j} 4
tY=).V0#g&;B*R^'Z^=u EVW>d!bk& _^FVW +>`Pdr6`>_^HPx pfLfVfWw>p64l /t 3ҋ? f1@
ߋG` 
t O
twQ	= ? _ 68) <R 5se>puf_fq&Yp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>l@
>lǿ  u
lr3- w|_HroQO
8rK<?prDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3`w-.-_nB6/`A)_A/_"G2k-YE.p"PG>qmBHr
x6ta >|`.s`<u=0>` <u  <u}0Pvr).ka>PNÀs`~s`DQ` w?Q%B>@
 Q0s`?^P2>`BkYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i} f.;i}w- AZ r%&Q0PPY tfGɰ
>A_W r,f 2mWT)bd@ r@f؀ffFgfd# 
 '.႐S3a `t
.~݌ffVpzxpvp"  u7 $P.~$qQnfU.E`.9`.w.F .:`0kG`;5A1>5`ŋf  t265` uuuf0=/Rk@f]anQn90P:`P;`65`1.=`Q[ fDJR RQ T
T

 ZW Z\$=
fX ZsSf3[ff$P  fff'f%$pߋ'RC%  ffC*** Please restart the system manually.
 .`<t$
  
$!$W$0AD?Ok2撰撍6ŀҘ2ҘӯPu@> ݚQ1Q ػf?tuPRPǟ^ ү ntJpfpa p6Tf W^FpOpPptO@X >TYßYfPQUGPF >J~Mu
,2 6  PpOpX]0qUf ]Qσ0ϐ^@Gbؾff&pf&  G>^ fG`GQaQ6^VfWf>f!_f!Q С ffD4$fOЬV 6ҧffP ȡ r ஀h$Phʳ X[õ ރ3@$<sAl r.ˠUrOp ` ԣA (tD_rq XPנ"Q!f0ѣ!ES  gf /tu}
> up[P}& / cB`&Xq!g= BxxwB 86{yx@ ߀ #                                                                                                                                 S .2ℷ[S[W>  t> _`W} v	0EAC r3ۉe_`?2St]AM][Q_ϔ &
`9P
PR鮐<w. [SrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hbar1TaP<u< <up. .:.~p .c>`2p .?>b:P	wd.e> e,@p ˀu 8rۊ fg[ø0
.a.&bp1p.mX@E2@g.*f v&.f&˸ Laap7^*c.C3`0b  ϊŴ* # PQW`
 _YXR.iߎ
 Z k@@ZÆ;BB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x߻<Cwp.qu#rp t
ArZwG Z}YS2
d0 PR7 r  dI r`.pr`@ d`QR	 .p`qQ
t
QhEYus33`8u" f`Ph @F F@ &} tC t;k߹0Tta30h &&E pظ@ P ^ X Wu-  ap;PfatQ@  YeQRW.. {w#&.!
tff./.A_0Yu..nf. cQ󞙚R'@lmcǏڏː{?Qvڢdߢ1>+ r.W觳  cPPJ <t<t<
)SQVWێÍ-<t<wPXrs<v\.> &_[^Yy3	0		Q z@~Y!<8t	 `<P_Vt=EIAc
<
t0FXAP QpRt @Q$0<:|u꾐FP ff Pff?XV	 Xi
Pj}^Vf3
f^  Z  f`
Qf
*  >"Orf0f3ftY "++x fa
߰
E    1C< tN< XÀ Ttu7A!Vu`U<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ _!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4_ _P&mϕOIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYf% r?}sP r
<:uft_Wf33ɋ1 r	f
؟ANp:~  uf3w0<fw,W<Fw<A 70,0Ü@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	}A
Nt<Yt
<NtNP3t8tNXPL9p*HHHì
uÊG O?À=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Y#)Y+PT P G WIN @BDF8U$<w%.JGu0
t;wP
Ȱ
 3]8QW C  1 [n6f.Ƿ)ۻ0IQjY f.>)R[ 8svp $h 'Qv t?7H485 26_r SHz ueaJ2  UuQK7|e	$ <C} EuA{m"' ;l  Xc3PQfR1[3 Bf>@Q AB CPDöހQ@RmSABC DpPOP R S~ c?[ QSWP).X. uF0	P2" <r<w,@.``  .>
  <  <;u@À
s b$ b ,0 Pq͏
 Y.l<?uf. &[u
f.&)R<[ ]Orp^?pu18x f;tuG2p _1Sf鲝a u<] Pɰf   `4gB00t  t tw !Ѵrer> ZfAA Uta	$`<`ut
*B5
u0
t		 u
l. + ( @
r?.

ZE"R@r r}0MpdZrЂB B|U
|a" r"<۰ tP w  "
 B$<  wuS0p@ "8t2kTuNuF;J t>/ @ u.SutΑյ "1ֶ
 " h[v.'u ˟                              |x KJII`BC8uĀuBJu*@u
Dgٻ0/JQL @tgB/AJJ] 7솀HĴJ!R:_$ su#@G@6J B3tB  DECB@CЭZNpBD r0`1	$ D[m rPf j qbA$<+`mb+
cJ$<u	f  rZPpc\ ?B읱[ h:I:s r p 
 R  O O 	  ߝ hr@῀ hVrA6BȎ؎zƋhݤ3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` a b c acD Y     i 0 0^j h=``;@:Wff > hp
襠 DϊfPff
fр aVWA+S@)'WŢpr;_t[s(`(F[_^aW|f` f vrup6fffGfY܂h2 R1Xfߊ$
(ff A	S22*OPr'}!$ 
 uf 8s֊ҊʠXQ;RP
t0^r#XPX  uf 趾auSf{UPfPfXZ治+ ]f0)ff]rff^~m`e#n z= srscB
Cb_ 1f^ ɉw @t; *f@Ikw  B)ђuW6ѩȢ=+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu F1KMuY ^Y]Pg>!f0rRg'QSVfNVFfL z^[YrfqXftA3PXQM| N{ O蛂PQA蹊` XPhWGU豐^PԀͻʡ AFд j ]dXÀ-p΋_P^Z`Wᐊ f}W mp_ÿ 0                                                                           -  8o%  >@8sUv V ufu`wQ2=fA<t1 u!ϱ n #r.V sfYZ]fTf;P¿f;fZWf=!r@n{
rf+Rcr
d`|s
ua

<1GM	k;rrmBaoP蜗XPQrr Pp$Ss[OBzMI6E{/6|JO 0p`XE)t fat/+f %#fSfQ<g t0jQ#2" ʥUt?j$7 3#tcp֦0
ð-@_ɯWV@ ~WB Q Y_W
t^9l	st6]V! <5u G	F^B^= ts.
<5 = 
ut	>9rF  Xf[2P
X^#WfVf桖0t
P EAr&< u P ݐB S f^cô PXs #S#1$!$)$PR)
u $ސR C'ð) 1U
 ? 2$
Ǌ4D O$ $
utpS  Y uð迹Q3)3zð&pFa
!tt	*tEPQQQS&Q"
ǆQ[QQ <t<!t
<P	<*^Rp`@ ZQR¿s	 2
 Z3) ӼVPލvS<û	 [rqkX2A^a
蚯 ð!R7 $VfW7 u؃ t迦r
Dp<A) @i2@e^PD3	L|
u|	  t0  $<<q;<
Av^À~. t" {PP ؊% _ȑ؋ *0Uu {Xð2HQVWP 
-L0X_^YaQ	LpUP2b} 2LB2`|ChY
P'/#f@1Q;WðWB12?	R}O@1 (S)߯ðT)ՠ Y"5@Z5?. Qb	U27UStf r.]/fd[[ 1ir.f% A UCES{sff q 3:K 11f!u%f# k	-Lr`t s` u `ZPKaЏff#ffд f |rf?fap-Q<t2f3Cr6{
+{t g> tt <r(ʰWPW`Etf uYf@,V
@ˍ6^4踎t]?t
 xGrk o8Y-t(gr!f1 t
J
?t:R!4g&?#zc裌@x豍8t , tu
@u$2H)@t]'@u'-}*tp(t
z /!-  t>n fAu2B@[ a33q 
t@  t}AfQߋXri/p/B/RZ/rGU/Z3t!X@z'K$
 V`{,K,K$z P&KZrQQVQ@0fF3Yf^PSJJJ  [XJ$JJk2JJJ@wJ$
~JJ   蘋 SfP迋4fXOش ( w[SQpW  _`¤ %r o^_Y[rQRV3Ҁ fFoKt
 J{8u 1C^ }Ppw`wߊf 5 ЧJEЎ`D@txx@l?LLQJ !!!!""!!/"""!"G#Y#l#ӗ#a %%%%%&&W	L.}}.: t u%  t>JrSCM.[t ZM.o[u  t t_M_EfUv"v@ Ar MwP  aPXF
Xf]h@ &A ϴaj@!
<`nr\N V
	=V!M .6 #  .t.I.
Lj@s&  |0u ^SV#؁D.d.$m^[	觞ã3j0rcOt` 	OtOtLtDLt
	MtLtL

1 u	.<識.}h $ BÁUu	UpXR#G rp
fL\mZfY[ fP<r|wf u
  xf@AUuP؎&Br& ȎX!M ,L>  ..?> @芲u  Pa 3PB &Gݾ&wG $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX][&?a s@ s`b 
  @Cf&GCE  A߿ ffr@AB @SRWP޲ 7ra޲ ECdeLuRE<sfQ@M}3  fYr/>CM[M.  EGώǿ`M I./17[7_Z[QWZ.> u4G<tFX=.EP .&ZM>wK@A%50cؕ @َɎٍ6CM׹ YSRt5oË]S.q&Gf.VMf&_f&_ - Y2Z[fUf0BSsQSEf]ð4C`4vC \  <`SQuP Ȼ$@Xu@@ŻXe$׻Htu
I4
<RVW`1.1VtfAhD c߱DXQ<V@YV<WYU ?僔 T `a&fP > &f &6&as >&up{D&f2>&f@&JDf &dDOCf& .&>& uD&R"qu:4`a V@ \a@`
J_^Z = @Q/V_ ؾ@**K> Sr" [u13r a 툤%)],+,+za /  ,+b.,+1,+
!J@BѤK K(K'`1,+`O-byhPh5+[}d,+[D	,+1J,¯`[fW 3sA<f,u#荑莑p f3gf&ff=?SCAFpf_U<d
 	<! F ] jW 3<w&< t'V3ɊȈCF`  ^	{  0`nRVV<v^.
wt"N ؋ڷB^r t (+]dmUW+P X+s부Oup0]<l<l[A &&[! R,[V, g <ld6e뙡"[&z [((0(e[)#<l+-'*~%QMrAt1S.5,[$ t t=q5@"2"\Yø .6F,3Ð7`S躏[PS3Ǐ[
b0eXasɄ3ɺ菬?rcPP?3!Π  0Xr?fPAMSp V=W @  A,
  
p,  t 	˻ʆ ?rr ɍv<ǐ0& O 
 30&OˁFUWn_]?v
v` K_^(w ߃17Ip p MB RWQQ9$ D -&= @
&}Gv!;v p cu#' ǖ ٿ&` 
;1s7>a]f3ɐtfwsB&- 3P_ZGF< u  u2D@ )sN~ t
Sj[@&fPfS h fżf8h00_`  f  Hn  $p | fzl f
׀艐ā rMf[25f 0pf% ;tf ff  ffX`PXPK_fYRfx of0 5Z`PXfZfSd``d   @pci
f<~f	QPRef%0

}|DpB%_B3Eh@u1Px9QhY`f1ft " Q@fY fff`fazWf fӿ fRf3fftf {Ou_fZYWr~ktu?kl`?hk?$;rV;Q L B = 8 3 . ) $      0_Q&GYÀ'ðd Ê$W3_Tp*u	 E0
yoj)Ӏut& 5& A)u&p}
u! ×8W@Ӏ AU\ RtY pvMuG	0bPRu3vuOQtru1 ta0> S:u@>8*6R:EFu ?E0 } jQtTt̀t߀EtH71 FðMt%> t:&pvSu=Eu3é  t  _E>I q u	 οXuP3 tRXYtS%y迤E uth0#)	&2!q@U=YE@ҭ*x3;r.Dv+W+Xuw432#*u!.ð-*1!	 2u<Gr<Svƀ ,Gg.#]gC%J {u$
<.r!Lu24$`.߭2K#/9g/1rPA)<.t<+p0 uθN<-P" uJ,0r& 
P56 ;6 %10Ü   EAX=W EBQ C D MP@SI Q S _CS= D@ E S I1xception 4 - Overflow!5Bounds Check6@Invalid Opcode7 Device Not AvailablJ8Aou` Fault9tel Reserved	10TSS1SegomentPr n12Atack V
3General otecErrorq  1 =  System Ha!P?$
찤
-XÜPR$Z fVfR65Fup6/v}z,6PzcPJ6YϿ65{5tÍ65j1~65vX/5Tō65Jp65A@Ǎ657XY_WQP65$Q5Q5p5
656?7F
0n6t6诜]&6x6na6_WJ`7o@b	[Q, GI; 1`(0X[S	 m61/7 p C8BBaa_a$at@0 0TFfFɷN
~fE F Nu3 'ȷn ]
 RQP~
Xܹ /FFYNZ1·A`QȴjY`Њ  aÇًվ:"ԃР: & G: .&9'@'dQR Z
  c Z 
XYZð
< 
7   ±S r  `؋  p 9] _  Q!
 	`ssa@  `
UЋ؎ ]P ]ߋ3G
AF `P C0[6`q$`SRZ[` $<u 3 0ؾ   ?fa3S Y\Q VQ=3AUAY^` 
aËf3RQ3ɋf tf`3fRAѐ;v+R'TYX0P@YP\UfWf&и`1fW~]~f_ff_]p_uEuPPuuZ=PPE EPP runtime BIOS kVerso.1  
 =
>>4>>>>?@?j?????????*@wU .=]=.dZ.bZ r R.bZ
qQRPp<rt2[5$ԁ !Ȁ
  -"˴ S`5	$ Z [p[	V	uR xuR1] SUU.jV	`_&n ^CF CW	al _Z uÐu 0z_ U PSR<r
 j ?G`= 
t<t ).>)@ {.)@ 
~  ~ PQR3쨀uAB$ԡ 3ZYXPS还)"
ǐ%)[1Q2-a໊ /Y`M,uWt=u2
fS)eL)ذfP)eI)_200 +):)a VR+txSR گZ[  oZ[KiDu? {Ƞ((t%p0 s0
udA9Z^`k+u=u8qBp4
ً@#p 2 0UR!+u<詖u7Gt)̠Štڱ
@;Z]PGbXU 
~ s ]?`K:KxS|XYހM M>rQ4Ys\ P2* 3Z[x0"@'`"<P3
ݸH 谟ٸG G訟S QyLIQK S
 pN iqM a&nc'
(<PdCDKDxDDDEaEPA&` XW<r​ǁ  .C_Swt 
' t@	r
2[e 蒔u0^r!<i	rr&   W 08Qs" r2.C2& r $s  3r 9q	8 r 	&& rr	QSs+&' @>'  sa$esQ
u>[ WAr%p$S r rq	A9 f" ?$ pQ@	Pm 虪Xa\#t sq]@tSadߨtbpt t
@uY`
 6Xr`QPPPt_SXdYQPNS֡0	`DXd$!<!tSSS  q&@tPG XÃ36)L.LW.:Ls&3Xu.DPu.LQu?s` 0`r䴠2[P 2P	 u KЈ^Wt
 3t `t
u!P"3 u0C`ct>CM.| .ZM} tu}} P J袎}uLߒ   u3p߀uvjbW_tURQvRU02YZ6	u>^
 .D t+ t#VsLs^訑~s.Ls q܅0Q3` |Ys. u&	 t	&Uu"r ώǍ>`M |  Êö澢j.f.|f  @ t  s.|s߿`Mo\rrPQW 3ۍL#_p@ѻT`<u
 @&   >!@tA AuqP @u  , & ]XV߁  0`OͿ  r
 P<Fu us	` uA
  Bu	 X RtGT.u`6FtEuUrPRtK?xGr t& 0R] Z  SDuh8 [ h 
Xuh:rX&  U u/@ ϡ 8aM 8 rr
r r dЦ dP  $& 8t ߗ  pQX uSQ^ `rW=NH `*C: 8E8
01A @=@XP_PVMSVY C + ," p	- lFpoypOIEMAG  IZ P      	
  `# HDA-L  HDBs A-E r Cu 0USB-FLr CD Hs LS Intnl  _PCI-As B C  % eO m  H	P 	/` <M L` c!LF	L L ?LCD001EL TORITO SPECIFICATION $PnP!M M M  T fPffMfXtfUfp fSfPfQfRfVfWg]?rddf_f^fZfYfXf[f]ge333rVd4Ad^;sgu` 
3 s M tAt<VrdDg}
^` VWd_^gEdTg}
%}goE `tr	 	t}d8 W<yt`@Do
`P fUf]3
t  tP~u Ó' d.;Gt P._
u fg6$+' +k@HPVP?P  A " * Gxx  x y 1 "Ϡ *
x"x 0~  	 s w_X _y\[8y y @Db é u6T ËEtذE
Uk ʑ 
r0 t
ràCÀxf`i2tW &  &&E3ҀtB&U
&]@ &Epj t ûPuN&E@ !fa  ` JB C QYRhRRRQQg]jM tM03M]tj`5])
!Q-Л0QGjM, P89   09SQ>Mu5@lu耭% {r!<d3ɸ  3Y[CSRVi&MiX7m[t1t#+ >
0?M<t<t;Ɲ< t033^Z@GX]V摻@Eu P	ir
-  H_ZQQ = c
uiMM[M2i`)Lp  `3"$+ħ &?t+aÍ>`ŀ}
t 	
t>wK .:UIǀ֬V tMR+Z| pu$$<t} t	_^^Qʴ3䆊!*Vh CM| ^t
=u߄u
cs)t!	Ru3ێێZ
t	u
u
0uP@s+XP`> Vڰ`[3zXUU uPBXd]<tk r
tld8D^uPSQRWudds T^ߝu1_ZY[X`|n&
yt,ـt&M1&G&aff`fLAAAqD+Íu 2lȃt
 Q $FKuÿWC
u	ۍY;Y_uS؀u U2u)'4  B  A3ߊ$f
pf 0DRWS22f0 K\r\ u 蜔8sߊ[_Z AfQWRfP
t)r 谔ff  u _8ufXZ_fYP`N rc #Q3Zr: /t+a$4 v 
t(8t	
uY0	g&;t4g&Ct,g&Cf4<vf٠ 
g&:#pC1	PW޴r7fg&F 	f`_r!f`Gag&O@` Nb O q,`_f[hKt'} +<u 20hhJ;U1qqs	wstbs
AQrP.D@|.D
pV~ ```ZMX&&D aø0 м ` j R&&E  k3Լ{1YOQPTP !XY`.\.T	q>`M.L` `ca.D`caQPƌМXXɎ6anUUUU! @з "QU-q0RG      *[%	w  `` `Gd d0",  qa aO 
p p  Gr rrs sq]
s"  
_ 6rL		 
 Qr `q u # $t$?a\h@ & r 3u a.bZ!a3\' >s u`LI<u	.bZ u<В t$\   tu _u	V $
4 qf cS[ @ t7`P:<wuR[SUNNNO =Oطl$#sjc#jU f&JrMlOoeUNJ#C &fd.â&f>& ?uf   &>& t&?r_Vu`_@""ހf+0_Qf׸@YrfǺA$XV>&uIf  s@&
f6~P0 u&trr> SWA\ @X	^]]]  M PG00." *;0ʙ0Aq|6 A~PbcUֿUR]} rr r֋Uu"O֢]cJRQ%ߊ̺ BY U  R!ZrԖpԊ^  (<sW .h^_.0"2õPXs]Q]u..&+.	p]@ t^PP.&u @ u42..` _wPUU*P*Ч&u XY`-3P A3.{G@
XԙPi\ *.V\rWȎ=\7\_ _`+`_`b`k`n`u`x```````VS3Х.:_u._K`@[^* UFP_2_SFS._F[C`N[QF ?t_sF2~ tY@ ø7 _`  _ ø8 茏d腏`dt8ꝾAi`0b8 3`8$ $Âaaaaaaaa`d$!<!uy!!`& t"&& x<u&  Vw<t @K!D8t( 2 '2233p`f>"  tq" ߃P a2ۊ( Ҋp ) ǊȊ&)  * 븊跊* >+#1 d>,w0.- &>) r..PR uwt;60n6 6 _3
t,=
Ŀ
"=
 
0I5w<t<u FÀ t< ` s
Ê& 
<uaw\wWQu& ` u6蝟`!A &
ØitY6 FF;t2 g}
3gE
 t0"6)L}D  [gu@6kus߸U I2	L5L  
$t U&E
E   F_˽	>>]>
M  N uN >Q jQ wTTQ    U	 Y
 T TвTABCP Q TR  S TT  U V WXYAZ[\1]^_  #c` .ca _cb cc_ cd!eqf Y,Z
Z,YYYYaYlEOn]0SQfVF! Ďs^(2۹  pF  +^D!8u ^CMf^WVQCuKES! }Э!0"w $I^:u:\!u 6r裎PY[_Se	L.gP44@r 1{Eu P$
v`&a` VplLfaRМкTt`G$ts: z ȋPZЃc1q)~ #$Q.P8.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPRZẜÀ$0<:rd uꝀ߆P P H P = 0r q& fV{ؠ:gfFXRyZÜ tw	tv
 vPt[p؎ ЍƋhg3 뀀 SQN<tt	fP!XfP BP԰Y0ˆkQѾ@Rߴh=QѝYQu Y<u,fCISGu%f» fﻲ  f `3.>h .Ưhs1gr1/|v1($p1_0$UkK0V#0pT0
G0T/^ZR/Q'¢//{ $pfaZ0fPS P@f.}ijO[b:.}if`uh [ h  iuhaB   $$Ü.}iϜp$ q %  3Ҵ./@32ƀnuo nrGp'R| -  t$ 7.uﴀô ġ S3ێۻr?4 0u WxP Pkf|1lP_QuXûuTf`0D fft;  Qf3Y,65 ! 蚽\%_м  P2莮G@ hx^ыr  Pt4t p퉰`.l2撰fUfPJXZ+ f]ffŝf]rPmp߸n跐 nUUUU  A	  " Rye_SYSID_  l _UU  fl f@f=  uf3p fl P3Ҏ¿x ȫ@SZ]                                                                                                                                                                                                                                                                                                                
E    S    -%  DX' pˁ Jā݁2L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.KZr# M,u 6wKr pt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF ô	 q`	 ӥ/2	r@e		p脀'^F&?s  s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	ffPEEabgVfQSjf[fA1fY^f& u#f&GP Wf   4WfZfXP'F#~r .>_ t7  /{r?~`. t8   t t  2SrV ʀs{`,L	p K~t$` t u/~ǉ~ %"N?V 1	s^Í6CM.|uL>R..K`>wK .:UtaLaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;ww	@w)[Y_0? tl>ـ?r.u|
Պ Ѐ ʋ.E;v j'fVfv`$dD @f
@NP.eXf~a ȋP	rs$
2~

	fX!9
dDfUv]f^PR_B@    ZXRPXuUW:>_]s*r  ZP$< - r!P~@Xup>q @<@0P  *sXXty>Wc * BQ	?~Q	 QV  PRσW> P@   XFrr#r^rT:rOt :DvL*Dȱ f umfm4
u
rPbl
u2 VWrd ?_^ q QP&:Ev&;M!&*E9aVBoCo<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt24 uu@uu`  u2&fPS `00v[fXP)Spsq`D
>X`?D<PƋ4a`tߋ a1t!$!"wq1&~2PQȎ`SwJr#SMwO "t 
`P2:Tt
a YXÀuOuQ,9a"   <s& ? `P93 >CM}uǀ   )Lt| L	LVW_<uW<
uu F ><@g2<t.$S[M[|u|
`g|`it\_^FS`}
u}	 !.Lb܀}@a`>pO1~uD}?a1 #%D0QV 3۬+^YD$f郃fA~ff?ffJf6\c
bPZ#f F PXpZfP~Đ=r0&pw)Efݩpu fau}Cuo~s3SV|t` t t
^[PfQ
ߙ 0 < @f	t` v+aif`ffQf i Б   fQHff#f+ִ f;wfg3g&Sg&c
uff+fofa1
fP4SR%Z=Q<$ o P@AfppffXMRAZruA4Zr
pf`P2ǜo4XZ[fWOtQ u>
rrw`Ua `WB a p 0`cRSQVf᣻ՙ}fPh  Ui@PP  p^Y[u(PUFP| ^	u<Vf+
Eo ` QpLP	r=^ uS@]#^[;u"

 
 ^~u.t Uj@w`V	cL
 B8`.
{u&* +uA·0$_<SfQfV Á=Ut<p*MPTh [ &Ep` `&ufރ1   \f^fYfkSUh &]S^ ] $!&&DDV& fȡA\AL
^yr fWދDVЎ &0 f~`t@i0Kʃz^~0 P P&t_ 'f=@_'+a¡of;M E p  Wf.`	Zg&G_E!#3ycrR-uPTPf.͒Q,f_utf{`@]StQqY fqKodfp,  !f p9I# ,i;1!U
UEG &E"rrifaޑ 'rnOGw|P_@0Ъ`Pm %ߎ`1#0a \<t/Q aY<pD%PH
fuސ f ma` ߰?tY`v.M"fNf.͒g
Sw -"|"#:OOP9DQ:	: ; 0M;Q.:r(G)uyD > )uf.7p ђ0t- =*VQ$$D
~@V&T<^30Dory9
lY^C0 ~u0]x0ߋ"VBqEvf;@*(A{DO(Τ8PVPWSPWQNP
P@EDLtDra
fNt;2KWpM T;0@fP: M^_1PTN?:j=ffWfQQtT=M
Pe@UBLOALBRL3S }GG^WX!WXV1GWiG@/(WLWWHP&	3
7uO`gdOp%Obboؾ:!Q	TQbL`#SS.hS3Rq	)3AUEfdCf`e_W3n `{Dku_qnGhQhhRV'hh/hذmO`pjj|t= cYj,{A
1$pf[ jPQRG B㡀u u SQRV@ۃx 拔 tcPtt>@ KXSB$x$PXr$Qu!$
BB hJJq4HX^ZY[QR3Ɇ 
tw ZYJBa"<t$
tAJ_BqpvB@ PkXՆAZa@ 0 P`vЮp RRWR4Rpfˎۍq:@^W	rf+_ٰSfW.uO [f g&$fD  ʋ? 2ۨu<@tĀutϳ.z[˸_ f_[Q
! YQ 8  ` PRS%` +ð ;w[k SRW*׿OзIr 2 3_Q,{AsN` Y r3O:3!RQWSP b	$߁찂X.Q쨀tY͝l !`p0sX Jt	u}RX( V_`m 7	XAP)?[_YZà2<UuX
8
DYJ݊Bƃ   brT;
!uP P2
XS@
u	 躐  *ê袐[XVWQPvDt!WQ:t
Tu8v
Y_߃ԠY_XY_^ _SM_ P_DMI_   #95  2XPUv F t	F ȿ!Ff@]X"X
ras\b&D
V &DtH  
B r!0rs9@!uF.bf$UrO@sJʊKZ STo`8Cr
r=`yoiZ2
 0
FFt N fF" &'BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sb߉FVFF"F
 F)ta r4F$
Ft+ F P   !VPXV@"aëWN uޠ	ZX_PA>`PBq2p n l C  Ơ # ˊ]ˊVˊO2Cð
@`H,p;˰4˰-p$zۄ(ø 
 	ʊаʰ	2ʊs s	2  | ʰʰ ʰ	  ʐ{2ʻ2 	Àʨ tN :4ހʰ|uʰ
`$ 
g$0L BS=$2
DÐ+^_32_   xf` tODu (E !#`,/a
ô%´+ﺝfaPKМ۱Jt* uٺ$t0̺$< ȋKf`a
%D	$艺 %` +}$sfa r蠐<
t%	*P' @-TO xOy er$DIsL>:  h                                                                  RDS@    0O IYOO LUvPQF X .p	˸ q && f"ꊦ  и~ߋf3 ff@i.<f.:p >` 6ma  !.P f.""""" ! a
#
Ƚ 
 f3ۻxgf+С f`ffWgfǃ#Eg ٠`ܺzA vT2gf頸gƃg u	f@w1 f@f@ۿf_gf1 gffgf0	}arfQ@;gg&fGfXf7~;wf+fa f_7gggfb	ff#fɰsfa
t@@P	3
y
f?f0
_gf3  P
?@r@
A
@  gf3fS̓ Š΃wff#b ffyZ?'wf3f30n,;wfPf#4ܼbf[gf p2
ffIP	c	
{
fA"AXAP
 #W!fكs À +SfVQp g46f?FCYQ  Y`@.f^\ g&GCffTp[PfVfWfSfQfR
/fZfYf[f_f^R
uWf;Pf`Ȁ 0s'1 t-r(@tD<u u  faUQ	U F @ E] < t<t
<t cHw`Y]p4 RPQRbfv2 >H ^~#HRZYXɒ	OHr3`	x t`-  t	  iO9`Kr׼=sPȴ~ + "#@D@\G18P,Nff3u[
PL @PQ!!  f3g \IfF!b"Xt$PPTff`U^ƁF3&QfPeQXYqF)YaP'у@_ yFP!8 #	kFf<t`L< u#f$!DFAJF`-FfaPظ䠄tԿ"
   u$! !tp &k Xa{{{ݯ *qݰ Jcs@P}FF
]X `j . j v
)Mf.N. tI4~r@5p3^)tuw t&Du .⭋^^;aϠ~@t&ڃã.^2Ȏڀ36t6^2߯.  @ PSFg
t'.:t	tX._[X`PǺ
Xu!P輺<Xu @Pt豺a`
  P?3@C3aP2Xr-s(@r3H rr
 rR VvF\r:Gs5&DC Hrfڋ_y苡_FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u rcwuu
	A	πϠt&D@B ĪǪ߼zAT0	?VcH Urp蟁sʁ `-su fqt
E$藀Eab&G )
V Nh8Kr>u rG Po3F) Wr\ {r=oH r8QWss#

Rr
3 s@oM1 |#k##'F("r#謲Qlr@rk20!0p 7×!r"!F( Q'&d&K0#V&f)&t N.QSWf`ŀu/ r)v{!ufPs@s8fXtā_[YP<t;f3f t	f 8u
utǳpǋ`f[`
 37 P  phf<	8PR[ W校F X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$`
ĢF f%R$PG ;B(FGq1ø fF" PXۋN8NwN 4o2N蟧0(`00s觌/ mlpR
 r
fQmru$贀fY_/1++U+Ñ /&u b%trq? VQB  BY^	G $s
3
P&u3` 菀@
r
%uètàt <q66V&TЕup 
*&u^ô  蟃  |QPXuN%&:Lr O* r$ P @uP<ut.@ ;& ; E q2s2p$<@[t22P !$!$qXw= [[>ĺ".P[K<P  = sffP SQ  !3Y[$p
3 F H 
۰N8tSFt f% f @f t0    "   t0@qP@fX
PRV s oZ!
J
8
20
$g4 Nff`4eA fu4fwafFDP2`a  tfFP ۈ^DPm fp]fWzfϞ`3#"fF$QiF,0 AsrBrf-1fv,v0h,U-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfWր  p #f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	넀ffvwAfI| )Bwf*ݸff
fA{N
Xf%	3G,WfA d!`
;Vt
fAP
Q
ĳ6"P  f%~" f%  @"	 "f'F0002F%R) !.PSQR30? /ff%fZYjPQRWSӶt"X  :/
/[_ZYXSc[  QW /@\/ ߰_Y[.B/p z
  5u
 @ @Üuo8 0  ;)Pa@ F4;W@H0P ߈>%F5 N0Mt(BR'9EwTDHP  SIMPLOiMOTOROLAVPzoVS\~HoɇmP-s@^s˻ʆ߮ >ɷt>s>ɷ ﷒ ɷݰɷsSR &-&Z[>ɷPɷ誢ɯ蟐0 t
@~Ph+؋cɷm~ɷd@	ɷ[	ɷR`
﷫I
ɷ@s؎&3P M<St<Mt6 6 
6^V>nOʤ *r>   ʰ@ʰyrʿ>ʰXʰOVʰD 0°Z@	
ʰ		kʰ `
ʰq>ʰ &ʰq&Yʿ&ʳ+ 
r)>&~X^ádWVo.GF< u^_}J׺+)rD.\J0ERǊAZqER.Ȋ̱pMQRR ź_ZR  gZYol긏R8ASu
wRRp	[P uPXE%
cE%	_X< $OZT
 
"?
t`gVW_wZwU
uQ6rEt> r2
tC rͲ  ro  
p    _^a1n2
u[rVei1sCr"trS ';Wr6"Q@
Er S֝)/$$e  
 ` Pt ҮK\	\*P')0\;#$ rIW("  k?_!Pn(B O55B< t%?@r4;3_r!- ,-Bqw3ɰD@D`ó sGADw*VR@ | 拴  t.Z^8ħP .;BBBX$JJ2J쯊BP\tJ Xu` Gr V tA&q JZ  C@A 젒*uP= ]Xruŀ̀2	{
 r (8SQ2<

2ۆ.
$2lrqd<w0
u@߀ð  ` 0    jǏ@ q @ F0 vP  b .& T@ z 	  @ Q Q d u @ 
 G @ : V    	  Hewlett-Packard 68DTH Ver. F.06 06/08/2005` I ]}} l ~ q oKBC
sion XX.XX  
 
  _ 	o~A#  @_  APJP12 Intel(R)  !rnal L1 Cachea bi2e	
   6PC CARD-Slot 0  
 8>	 www.hp.com;
 p   0 

0
1 D?IMM #1N82LH"!3)
A-~*"R2+r ,"-@m,No bat y7+"
/_7&SWQ v tуY_ P聟zt"Ĩ@t  p 
 ް  XPJXSPc t+. s#. sXP>&   &X[ó5P϶'->@?/HAC ݛ I@ D
 uj@ t%v v t ArMv .sN-׃f-p̡&A F'N- aύ6wK  @	3!
Pwr ^	
F (|r
 	u^'Ât %^1+	d1*515r0/5Mrr[o[
u< r<0s<"N@`  \

u' 
$nvf<0r
sus>L.u.
I.
Mȿ.}tj@&u |t
  ^!N%V#~FPS2 r2<0ss6< s
	OtE""Lt*$Ot"#Ot%" 2!)A
 o؀	.EFC
r]wsms1I9  <$u2 *<#"< u<@v<%ݴp!2 ÆUu
F!UF% &F4~&=r&}v8fRF'P^S^!S&EF'f&U&]yrQ[P@ [`fZsSQt^Ë^6M_	Aؠrf;	DE⻀~(LuTMs fPf}3fXr1>CM[M.  .GTώ`M "./0`3V#:Tt`<~'t9r0lQEE&ZMq<DD@ % 5߹I@~6CM06u0fPfS&Mf.VMf&]f&} 
M[!
A0'Qf*  r}诮rxL=rl 5rdPtZ+cr@ H u~ (um-VƎދo?^@tffmݵruLr Y荵r)8r$crre	rj蟵PTPQX rpw
u `fSfRWBt:ـ?f.Efff׷fAUffsP-EMF F
tSuNff3ffVCMf.WP*f8f'w*f'F'*2p*܊f
VvfVv 4_fZFsQU n E]YRPXtUW:>_]s#   rRPR跶pPӊB@ ǀ ZXюًw goppB슱`PQK0% [ĳ m `7h謀 Bt Z^N軳rot
r`a r[v_">M fKf}!S, 3S5<s-CMO8L9
t" >!MG<P#<Q$3@ dLPQ0X h ߇  t޲rzvru3rij`wNrWu
p`doع 
!ʲr.Ǵt%ttt t	tCHq% su~rt	 2PRF sH<t<)t<(u;ь>A u/WU>ӽ`xߴ]_3r07CyP_`_^a'c $PSR 2Z[)ÉRFtN+P X7D	F
+ȜCIH@FEF
t

`$PXfS~ t=~^f~^߈^~7^~FF
>FFFк߀f[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^o
^QEfYSQKfPv j 8rC8sfZRfXfP Ff>CF VvuK-QfXr+_tðP@P3 Gp1 tff Rf+IYLzuu$`Ύk2ZMt
. J^G fF! PXPE t<"u<"tlV3޾x 4|Q&?s0  s& p  &G` ` G` в&O &O`uRp`f&G`Pa  AWQb b  WUsa,ZyX7RQVW~:W}tNᒀuu .!6a u/AŠ ?L	
ǀ t,6pNoAOGA&&d&D&t&?D3_^YXV
} " uRPZM
  ^   @ TPQﯓٰRP  4
W j <
1BQRs3ɺ{@[pl.
X `.afV`f
u 	r [r" s ) y6	pAaf^U`@*2$ԉNT@׎Ǎ~WF$
&FG &U_@
	 `aW  _ t2_R Zo؀ˀ$0Z;`  Њt
    { {o Ab EpȎغf  T `333ۺI u؟F;D ݀u	p66u߀u%2#p &ւ,ڡ	ҥ	Ɛo
`
	끎hS$ ![ 2r$< f~f	R  0d p0ff#f' \藐f@1f.4 tff                                   0ߎؾ +>۹&  =6a Á.6ͻ0#RRRËFf3۰Sk"fV$
Ѐ
tfP`Tw}"Tet4%ffrP`WfV@f  {gtgPGffpb f'xf o  L	g R#f^f_@AWn !US  A  G " y 0  u8y atR é utD ËEtذEŰ
!trCu0 t
{trðuf`t+W   d_̺ &U&]@ &EtfaP 3(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457 u v5u t
&  {x_t^t]t\7utF5R3< v
<ar5<{s1$PɎ|X{u2`r yհ+g,r9_2._fkq G$!wu@t0<zw, 뭋 
t

	t
w
 fb2]f߄S?J, E ?G@2q)Pı
 t"< t߀r0r	
2vPQ觀s	} MW	ihEHHP  IPRuaa@uXXZXp! / YP总X@ŻÜ= swrqts
0{ _ ߸^ c~Qwt.
 ! !$諐 g>1QjQb;˂QN 3 K PnU'aB G y C ?@C">u=$}p=gq<R<T< R<:pa(    K P3@0W%ﺻ,.s 8 fg&'fA  _f@`$<t'<t#<tN< ucM T~ M_ H<u 5  %l  
 aS #AVW3xu@ G	u1ҁ Z Y@ٲ%WVQ 1 S!؀ X#'[^U$	ppqu*Af ßȵH"$tu!20$qQ  ߃D	0ef@Ahi+B3Bp{BBkkp@0 *nUUߦUU%y  o y  IG "z! ,@`b Z.fRfW. ?mf3Ѕff=SCAFtV1Gffff Wuf(#3tfPf}fX@ _ fX   QRfl f@f=  uf3p fl >@  t@&?   P  fV``ބuyyt u3N@f6 Vyu^ uyuy@N`R\p ShztE _zuiyy߀uu?yt!yvi
p 
]]f^e  	 ?   @ _ paG$ $  GN N P P  Gh; h"Gt1$  G   
G   $Ф        %_r 4O1fqHo ~<`>0<pC l<c<~@%Z<	;Q<
`QH<i?<6<
-P= uX<`< <pXL]WfPCI 2ku_PRVWfSt$fѻ"r f;ttN f[_^+Yff0 r } fu
N`o\u `V s rд2fPkȝfX`j5j}\j}Fj5	njff s"s~~  t ϴ`f&= & s cp&Ef JX`} pfPPw`;t
X2 *W 
{ _ϰ#tX _^0zÃNp sRQiуuftTffŜff P8s2b YZø8 "tW2Qi &g +  pa{ 
u
7	@7`I]ϰ2ðq _ 0S\8&&G &G&GP    [ !@  0@p@p\&\p F0 ]
 ..3 ( и^  2P
C@@ XWPZ<w3t u*p O 信$ v! & @w_{@P {{X2{$31    SfQRb۳4!ff>ufQתfYg	A[ø <Ȏ`Ou q =h}`=Au@u;@ u39 u+ f?wuf_P@u sXu
_ (fy@u5-%_{A{N.|S{_'_{@Q  {[{] {V(!q C{³P w*{n^{Q   A0+{h{p%Tu!uO ǿ<2ee]
 . d `5dPQ3 27y40Trdr
` r`f w$PIR  A&` a b c  D i    i 0 0^j h`3. Wp
_ϊͻ 
p aVWUSSR`S Z[R{D-[_^0RW3ґ`  Q]uL`GY[h ;/$ڠp.  6p.߈X".øJzfUfQ ufVKyrM u gf@ N V FfYfcu(gfFfpfhMufY2f^0]Ë< 3R+fQSfVffLfT bDfLyyf^[fYriXt	A3PXcøMTyøNMp OFy~QfVUfWfPny?xt3  `fRfZZyP_f]^YpPfW3yfwtQۃaLUPXY f  o P YXt
 t$wt t! v nxX(RfVt Z (2Vfaq0Pw#t r $r	~ ԧf^à; owy 3@%
ÊرS  e    `fV1~~fa.6fff;w	rf;w %CS.- q"  up~f%3]/aRt@u$9@ذ1tr0t= <rk3ۿf@ zo
fʝ `rf.f-  ʝPoQ<RWpT>E3&G;r_ܰ> <%<t   3° t	tQ f   f@ @Zuf@f⚠I4Z4f4f  ,P@g&>tq r 	r
  u f_^$f tt,$
g&"Fg&
FPI*$
g&#Fg&FﾰJ	f#SF	Pfa
`VR	t#1
t.
t9ttt&&2
~	t
t11tFt`~
t~g&`n
g&@
qp
 
u
g& 
TA1p ,a3R`\&^q\QU@ҵ r* U4.:f tTuH.V.f]gu
#p dߡƉPfdfBdgp!PsPdMd5gĿ}d J V1dP <d;]ttd|d]^  R h
' ' FǠ  F/3 .;v+GuBG
`F/ {@ % 	pXvNuQ
r0ʕ NY%_'
r0123456789ABCDEFSۻ׆`^ۋ^&t` $ueG&uFtt]逳(? GA~~~~l|8 w8| 8|8||  << `  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8lol8x
~~:p Q pp		 0``0qff$@0xx00 0 lllll  l 0|x0f 8l8vv ``0```0 @  `s<<f0 0  || 0p0  x_8`̃ <l 8`p  xx@ |pH `a
 
|x  ff|ff ll bhxhb `f> @p x p
pflxlf``bf  ΀ 8ll8y` xxpp$ x0  Px ƌ2 xp``x o xa"x -70Ax]|`` p 8l`0
v~!`lvf{0 x  `b  ұ  ! vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
1ޑ u`f SvN .2[]`vg i &  _
skd@Oa߰
 `
R3҄u  tZa TAE eMA9Y.RnSSд  A`( Ði
`3Ҵqu N ЙDZQY
 Ir8r502:6 v&Z a$PMM Gm PCI01 ISAP#+T DH03COMPAQ 06/08?/05  <     F10_  m؎g ЋH_g+3f  gm L!$F10fPfSfQfRfVfWUfUCES>"c  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdfe	 3ua 6d< tf3
@d>Sd  0 g>0;e `ef3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>Jf t
	RC &JffXf^PVW 3W __t
r
>
d_^X \ɰޯ۾ݷاб?m,c-DD(|1 8     I50  ``6~ "k!A8>8  B9 @'Yar:  @;@?i<@ &3?$	?	I!!
0T!A>q

( )))**LLH#Eo$$E~B ~B
y$$$@ $
  >""ZFYdld  #<r sM` hx"'y(PQ<R!2

	" g %8 0 pV	

$$D81 dZI 
!e$F   A4'?((DD@%)0P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInI`Fڏڍ׌߃Os\gpjځBȉymGł񂪓rݏOڕKvxmȂ튮xtԍÃ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉE십ċNԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb - @t  ސS   0 ` R 	iy D  Q @' 'D ?'@$C" 
 P '1!!#"& pc
~|u m ?0
Fq% pt? ߘ  ! x % )  Ef	! ( 02 S   `00m) BFLXp0@t  0dEg!<"F p0lpY.$`"08 D(#ds$A|   UP W F  >"6>?0-@  ޣ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@@@a!!: ' ( <'Bft,?0<<` *0`  x?qt2pC Bg ? @~00 H$@"@ 
	`0 P $&# DK8 o &  | D~D D<  B f<,$$0$l=   M@ 3` B?"#!O!  8@ `: 	4H 8	  6 a@)1p?pp" `$!3pHBQ0@S` P0ZT@L@\D2"##(RY@>B&Z" Nk=bN@-A |a  %rm  2c Q " $!2xa2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxx0a1 
c
AZxAp0!
g
  p!rE  @>>@@`)X0$x|pTT? T8PcCQa- : Db0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{ijv+ dDs?|e0v0a !"s 6`S!cS,t. T8$9`0opGy 4g @ dt>$B<' @}""" c px% `\vdnIi&0WP?v3$fv$d
  ]@^@.*  @#2Bb"6T$-`0|p(x3 OV@@k` F0Vpq]@ 0ua4`m|sGXm|%o38"5U QHU' &@'a! 3?! @( !d(!3#\2b" '?1`		
	`21"`n{9$i$	$	`  "33a0k' l?HzM8 0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!## DEB`@].A^! ^nxRK)t ?` ?0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P< { b <$  '  |D!  D|? d%4 >!d??$C @ 1bp#1{8 < ~ < a   <$$$= ??d)),??4+fIAp'0p6( g!}@ @Fq?6pբǀ66@ƀy9@0ya؈  >`%,#?% p$'!G@x pwc 1$&? l@ 2?$?$?b S< @$<b _=$! <`0b64~
*  hH"e g * ~  <@ {D=a<$" AL`5' '-恴pp^  ) 
8hRF qpà2q2DRD" T@""z" ""s,bn0 CF`  ||~ ނIE`<?aBzd, %}IHT! 㡬aeE@AjD0p 
 .:23V!& ~   B5I@  `2"R`   @!  0`'|Cd p5D ( H ʐH  0
DP6Oe  /$?$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c?2`."b4'?e +"@P,  b
WBF0L 02?$&""  0p	 x 	#`4 c$}R S SPpP !
a(#?@@DDD@"D0τ!c 7=E u0DL|(0<t ` O='4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Rydws7  H 4?b2C"cyH@QnMx<0	`Z8 ̀7( (`C2)v&^N?0JbW8l>/&23
b21#n0  ~!#$ #L`,!3p$?Aq%$"h| "  1  A q }    &o <"rV&#0 I  81 c QQR0S"PC 8`A a ˀ4 usn# 8ٳBY 
 Pw]IYf   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,?=%$>ǒ)jP|D52D"DvDTDD6 # a|b,ހ  1рp#\  7ajė=  4a8	  6 P>tTڅ  ptL D@~@Bf$,892Ok&arg@eP 1 WpxPX	 ^x! 3"&,0@J[D% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`6U0` . `09H~ ܁ց 	 d~@_*H  ~K6cNCc48x F?~!BC  G#" e `QP060o!  8!` "***" /"$'$&*"$"? CJ0``]0?~$BdB  a B
BB~15,"&D$(-jB ,!.	,HO
 =I H<H$H$I$=Շ@ @v 4R$ze bU?S R P|7 8y0 ;6@
bPgA[aq! 3 ?$$$5d$Dd<? ~   ݀Z  $D$y= *XGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? {? pw 0,0  ""bp $ & "9  q?2@G_
i-_ nF:@e$  a  @
#]](00]V?$P?			?R" N8S8

 ek| 0@	! y g	 	 ! ~o>""	& u">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDT C
$>?  '$!$34, g A#A <8S`hO `&#f!~b6@2~Z*\*jI0 Bn5	G x RRptF H0	 ;   	  a |$# '!!b[aa{ap 2zasR0A: <  B F>lxPXHL0Fw`Cu@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs	"`7 `C  `rL(  fMQp" "7>a}>>b 2 "&"cb@	"00P oG  A` xz   Vj_<@` <1p0?O3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"gb>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8_<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~B$fiBFD0@ @`@.AY`M`  I2R2RR 0Bb.	o4d0.t ""p bBƿ ?}~b
(LA0%ɧgUE``AC}}8@Tl@l$5?b5d >qcQ"tdaxR4䣄	(	)	) ( )H	p ^c 5] 1 aA#?~"! "2&460baÀ0"` @"{D1 X8|@ @0 P` !bF! ~°?(HD>!"? |?" p?.a ee   	 `p13_"fd Bi|"@Acp>@$	,	(	88(2l"FfV@@`'$pzBp03
D(zo

@ 
{t~<$4 7 a  p ߬}#@B"4&0PPP`@   p   uUp cuU`  U`	 e`0 ..d1S.b1lp `1  [<u.d1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.Z1` a2P SP!bRV^Zu
`R\ts 2ƃǡ G
}a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F¹. u 2 󥪪4.>i1u . 2 13 `.Z1&1 u2CQ2P Y*2Ȱ&P} aj RDr
.j1.k1PSR  && Z[X ` Op@kp
oo.6W1FF!.WtOT_G-p
QR.6`1ʊP ZY[]X  \"2S2OsP2 sP
XÃ <r<0 <rp1@l1  n1.&@E0u'2!n13[!a01.>ߔ1P20X2$CFAPQRW ((_ZYX. 2.9 t.l_1BA	#+D<uo<RaN<P<S<0<{<<<<`< T<@<.>f1 t3ػ@ .d1G.f11O#0.d1.f1pd`X@Y 0..1.ό10;Pp2  X:XUFN
ȋNu	F] S܁ f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M4
> tj6hjF_c&  hEW|ua>uDRIW&2o1c% = ۘb	?g	@[v	A#2$s
|
JAfaffпf{NcӜcmU	fw>
dQjut$UQ1)`	
	c	,	A	
W财aUUf	E
ErCh	
=Hb	H%SF o"41*UcیB *+6+Rg"-Ui//~T
!ky#UJ
z&-%)Ux6='{FM) ;ct;j9;~;0VQjs=9!"cjQd$ !fh  nb@v tAt=dtfh jnd$d.CC
dtfh-L  >tShet3 tE>R5jhRdfjhIf>c t%j hc:1t2>e tefhf t+Mf *$f3f
0č~f PFPh|@Uhf"7 WQhc!3׉F``H[!0==#2hd賴[h d*yod V0α1&	he`ƧBaFg-%gh	xA?fcѬfcFBhoaFP8@ $ jh!0b
	`#eh!fBH ?YI蜼6Sh]cY.4
S]ctO^0I5%hK01!1
0!O VE*hm+hTB)O	PBD	GB^_ !2FFTf^ F&_<
uI) u&*_&8hftFFP9 ~1FOuÀыٹ F FIuF)1 F*+FV2g+;u;uà3g% ;Fu	;V@á2gG2@4A996g% 
Ð;7L*	6
 WP
Ffj h| SC'-{ f f02g0 &a&cjLfPas~n@[j`Paj FP`dF*"aPbV=ut_ wV!  )#@GF|  02 |[, h ߎ&0 F GP	FNuFG0?N7 

[yOr4,HaF YaA(wF
2` 1p QyU>raWIbf?T3@6#n~r	v	$2&c% 1/c фoZU

9raFpu-&c53q?3ȉъ	cab`Λ	2&a% +1a1aj_R3p%[2c%  c1pjAR; 	a9
F2`h~@3޷cjD
 E

C( @	H 	Na(g<	31, jiX 
T(jS2
 U@(cj~a'&c_cRXxt1
:	0dr$p_Ft@c t#ayJ*@zbƣrP)_c{Ş#&ccjT"trA (qAc@w _&@n8 ?OB7<"_& &O g 1	!r Rd!W qhfK
a wfr[d t}AJAAH=?A?a  ^PǱF2g^F  ^F&F~
r
,e?&"e &}h` &d^𕇀gP@ f~@ cRde  e# rʇF 1*pU`E  p  V6^aF@tp)td Z*tT*uN&,e"e Whe 2,9~ʀtw"Pt m߃ he@tO
d+uUA&`{2 $_&0d&  (!g*d!r&d"c葴wofit5D@.QFwq0`   &dw.j j  3
vwB %#rSzWFp_
(,_B&f"&
g &{fav5& +&C!&u)&Ƈfd r@|ehJgP9ZM"9cAKx@K 9de&eeFVD.Afc02ae4d	s$6B8aT :Kڰ<]c6rOvғ0:u`,de eeF@tcyRZj$	J#>jgSZ	S؁ de$ < u W@<@/""r@ س1 e|`a(94>14!f@4G(va2Xeڐ0 
gt%r΋F^Nr'~#tp  u^    % ` PҐ)^`  ~u +ÿFVVF6Ƃ6~ r~t` q~uFڍ~0fv
0V32,pIuquSIXX[t

^ ^^paظL~  f#} FB F~P|v^ KF{ NFFߌV~ 퉠NHt@HtcH} P )npg0pꬁ6^F&? u <cvA8>sd|mhxcΐQ$RacV;a%.cvm.cm`
NNF`ev!q齼$Fq*?gFFPjR?g_S{^|/GFPv4AvF?gFmoPQ1caPaѵ?:!Z`dB_&U@0c16`b`~2|FtFr(QW^
4~`4	b-2' _`-Pw+FVFQC94%~ _t;F4FҔ0
_z u WV~vN^?b>S
A0@
^_C
g"j(c
l`
5

[t ,md(|WVvԋNsOD +HAA~(|WÍ~FIt_~@u"2F#}HFB^F_&W} 
 
.APU!u@## KVDiaeҶ
%%		 	F*Pg	}`	
g<d-UWVv<~P F
&GFq&'h*V~ʷv!^PFGIub: ^&^&8t@#^^}۲h!#ù
 0GF N}% }p,-Ar  ~s԰ NFN+;u0g03ɋFpPAFC&PfSp  ~0gsG^AaQFp ~
SvЂ@x|r
CVV,GV~^&FI.a&a82jFQ2_c%0>r⻐IBkb
f?N3a3#1!
= r	v	$"
a2 % 59W
o`PV_̯#?j`2#	2&a% 82o!2c% 2c1cjA2Op 	a2/! (!Q023zޓcjDE
	C@H
p

Ns#ST
	 U4	@g
3;1 7jiQ,pyXr~yz{	@	{	[(x;(' &ccf`f   df	 e 0 g .fcm؃m2@B T Kc]cFr'c`6↸ Vi@a1RFRc4JCS0(B3~QtR kߑߺˣހ>j6hhLjFcU QPeu:>u"bIc	?@#c,S WƢ$+"9_oT3E\A	}j`faf	ff׃'fcPXA@ VYA \a$jCDxUE$
C4
?
_H"_ 2
NBUacB %q'S|pF "4ɂgPL2ip+~0PzryL^2	zB
xB&{J
q;;n9Fֺ .Bjh/!Xa۰SWVvЋ~ &F<t<
brTF*;a}7Ay~tF&8tFu|t<r߭2$VP^Ʀu	A(|;Ðտ ~Pfh#  PF;rF f?* F  F*N*ȁ vFPF0"v`Q
u+eTf^F  FOu)	fdf &dfwc7tmfq0  R*&3g@ޠ2`% 2g14gu84֑= +ɉN32{g33 Љ  u6g$<u~6g% bpu&7u]f2 % DP	u<uB )
u/au#ha68g#FOr dTfUfVf WfXf	YfZf[f
\f]f^f_f`fafbf XaLʶ f3 f  Ψ9H_ujvRPp- H_FB~2|۸1~F  p ~ uFdͷm
 e jgtWV@H_FR_vKzF@ b*J*p
NvQWV詑qFFP
|F؊f- ھh Ih
'F܊f- h F֊ft@ t؉FߪjRvvlh 0-~St` su P0M2muhLh ~@h FފfPwsFf- juM!v:;F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌvƹڰ\؊GFAOƦư {|{`i 'pOQ0AaPjs, *`
- e)@@@ _NV$Y^p|"[([> [<1[2d$0   Zyq$j)!fP4
CeeQ A2g׌Ў u fЙ`EŕՉw6*qV+- t*-} t-94!13o$RFa2 LOEObojLЁF 0#"7g
11  GEBr{/ 3|
/@+FV+PRquH6pd qa"$2@d%໪c2gˌب ka`a1jLFPA j)"#2#"#'
1#C/]LDE@WV3 WD\^&@RFG|吋3x96 2 R_& FW1` ,r<"JW>
do Rݖdaa6  &=  t@M[_  Ft  
Z"Tf#-//

	
@yu	( L~Ĵ &?&TЦVP{S~ t'jF I  t/ u#'jfyq`t=7 tA:?@>u
,e&he""e2he% 0he  t&,ep1`ul À&l yfdƯxf egfeee{e>gdaPaQaddU>u[h hJ퐔h Z{âp:h^@jBz育uւhR 	["		N	
Az
4!F* FLFk`  @AL62X 19Mpb$< w6rעd" rAӀ>dt"a`߀&ca
uc"&c	ʀ>rd uzfh  a  {PSB@cardW,c
\W!F$ !J=
u< cp3'upvI tŢtrtBtt`Ra3+&?(u"&Rup )u&GPGPF^~ u
 fj
 0 	  } (D.~  / u p݀&cEF`U>~ tf Dj j P P= HtVjP M-
 -!/> ~? H	;	~p		߃>	aQۋ@6ưRĴ &@?u3pTyl  	&&G&W`lp[D"   s- ;t- t- te= M-H- ߄-యD@ +fjsg  ;@gp J_p "f vV>   vVP*A_F^ VP% 
P h
 h  RaNF
+F{@pF!vvo`	FJ_NQF@`{vj qCFPNQ=`*P!`VW  ް 3_^ya >#J_%A  S!F>
FJF.
}%
;F|!% F@P!]aVv р`NcF&< t&@A0FAu
 )F~u<  tFF7 PF@V50
 f#p4@L@*`P~v*VA ;Г2Ɗ*1 ufU  V[n']`!> tur3NFAY FN&8tGr vNً! ^GF
&Ft^ G  +tp
뎐V^% = @ʃ@A3t`߰ߋ@!A;w"Ā>
 u31&A *;t{r1A 
*`F0~ F
tn t" 0`fp
V=O`2P.B|@À?Vu	.SEHDa!E'(E02rVu`5 3
l	Sd7RP3>>Q XZB~38tC8 u31~^
AF9G^
uN3~(~ q  F;S|;pUƄ  fUVNVv<%tF` u DD^
00NÈ ؏u0+1WRP MX ]V^tQоrJ;v~ F^F&uF%$=W\qQb]R}   P+΋8sgdvva!VpN&8 uN&߀= t&Y@*A|a01tPL+ G0 !
`f+IQ ĂkqCTNi
ʐ kj ##vAD_
&F3v~Bv0JQ&ğP0zb;~ANuǋv 0dFWa ޵
feP0VV cPQP F ~ ~
~h3ҋ9 P{W@t4>gPǰvdPɰq 	ptGW5"p j9FuQ_PK vv#5@jFV20NvD"F9F}+F_- P@!b'' ɒq YFF`g%"{J nT\QPEP@?DPAEHEP:! fh  赁39> ~jy/r0`*9PKu	A
@0
A/\&76%'@2)
G;|2*& P c`8(WF0
A
j Qjr V
VRP=^AQda'P? WV< n@]Pac E +_FFVa#
0UcDSpbyf 0aDPdQ虡ˠxQ	5Q`,+?F+Ѡ`?M*2 Rg"@=D=ӁF3@**A;}Rv9s`V6r1Qqyg*@F;vwP _4C
sR14+

uK#aQNCPfdD$A84	PeV輡VBɖ1~&-24hQRtYAS;}^`=y#DȰdf&D&TfF3F@F~
P  q &Fި@u[] ᐡFtdF;u@Ɛ]q<ЁN b®PO;v}vmǑa<GF;F+F-	@pFF&Ev;v~Qm~ $	;FF	_F|	} t~0Vg~PtOC~ tG\'F
t/* F T9F}\LF ;F~AZM
~~2G+F50%&L
q DFF ^0 ) Ϡf@`	PX f@PF^U^EAgT l2s|Pxb<FA@ o0H&v7QvFv;FՍ\Pɒ #R@~'U 3'tsF+FJFHfh iR( tTT4Kv .9~4aWFek^6,+F!}=pu.trPoq &OC@ +σQk._+ǀ
0|ctj[|

FB.=Q j]>oW0BL# ' CA& !!pa2#$QBC}PPCfzffQj@>zf|fj qWw 
Ht8-t-9t- 	t "f 	`!QF~ tfFfzf?F  F
Pj   v
u}1Aju >PHPV`s
Ϲ&_wc¯_FtB$zP
Q|иN	VV2F
t!@D% QD:
莡Q
VQ6 B tDu遌Ǡ
!_؋!bGv C puDPk*.% H!MbB`tu	 ]r QGg	R4O1maiDu(+Huu @uqt j	jfh	m	"	PGV^FPqf~
w t

>a:xQ[EPzUt@ ]FY m DVVj_vvxzX 6G ]3?ĲS002Rr~uwF0BP1TqE~
G jR[807+$~ }p  9]t ##/E=/`a/FFP9 \Gdpg
~p; ;NNNQP @C7 Ƒ򠽋= K = ;  ߄-Pp---xАWp'FUj  ܩk >f`{ Pi;v1!;vFPVW>FP~FPG_;~~P1% - D- *-ࠁ#- " e= Pk'-
T|5. G@6- ;sFc?atU tP` zFa~9Fu
VVIVF]v9vu@PNPN  PNNRF ~9~}};V 9vu< uN0ǋv T`7 3P Pp & {!VN;
u鵀xA^F;~maXƀS `
$~Du6f b;W|qT/QN;v}O;6Vf~ uFApL9vw|GI0Đ0%9F| ~'A^&+^&} 'F'302F`g!ihj@vVt ;tt D@gx3|f4Whyl
 +rz/{~I>FWV  Gc de tǯd@ @ lj tee
W|tATD\[u0Y;/F~ ZpӁrN@uOp0
DUK=eNp>d u)>e tl>g tt >fc t|c]`hڌb?0ҽ Wh
r.u"jhahL_ i
j(h!fh^_eh_z j _h]ch_K _T _}B _ml#L_a%M^ !fB"	 e% jes% ]cc%	 KcS%
 TcCz% Bc3#z+(`嚔+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#Hjhpt1rtߤDODpU}*䊇>]AvuA*HWvAPVt0<w@p&O }55446524ޤ5r659h@E@ jpPVCpWVh
	 !V3j ?hD	~D$Հ`HtHt#h !  {  C wt^ f	$F~ HtHtHH3t$" @ $Ѻ&&G<P j 4	G+P舐X
ǯG>7x@n ^aGP0v&ƀ ~RwrjV6 fP)v3P Ы>X F`~|֢"v®s}vI@x	&8 tr
9GPu   >p~q9	uarf   ^f~ t  |ߊFÑ!	eM襮	L0#	Ka c 	3$0(`(h'paߋ^p3&~/tC&  v&߀8 u*C;^|ckF^P9PP`^? tvN~}"߉v`<1
ރ~ u0fDFG&9 uԉ~WRr0~F Z= ?-
 - zҮ<5 1 ;uJ< tCB޻tZPU-
tKŐtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@_F	 0 % t" uNj phF  Bܲ u
gށMN3~*^
7ފ 8&8u	F;|`,Bdn
e6P $
P7ڋ P.PC 
Cc!
d$  *8fudwg"^u Q/	tP3ׄ_0F |n FPf@
t)f37fn @Hpfh j h0`?h` 4$u @3l3 1`F*}A;HtϠ5= t	d@ &d鵫Ǥ ڑ.dQu݉&
:	@
ʠ
 &
&
h|hN
h ?AA7B 
@
@ -*
{
@5q&
 3F! "&d&d Jf)jJf!B"  _F?P~H >AKN
3a`#\'"%0$:GBHF_^`^Z0 č&Í,3F
z46 x$d0"dj(j 9
P8
PPfsV
bW&*_)@&` 0 d t&<
 w<)뀖䀝 x
苵Q %'@q`
豑! Ohdj  %cbN0ff3	_%  P5Ѐ`RB/
?
~$*0/$30/0;4R$R"_DRVdDp%TW
d
aH*=	- I- 9t7-
 wqrMt%
- Ktq-MtΠr` MYnp= d.NZzvo,2@0`  8?&_0W'R!"Ր,20`  0PXu/1V h֛h ST T 9YۂY݂Yހw
Y&"0Z^d a=	_[Q["
@4 {|
U!@ _d_da0y@ Vfh0/h y Pc@t&
 
@ ACCC΁!#!
@d_d_
Ɛ޾
r4( + (#+-+{tp*tcmKt
- tu] &3& tGђv 1vhh?
h P!wu
j8%A#&A
-hC@#'$'a'a{Ðjˠ́ ڰ @&
)3bPf 
0>{+>>G>do'>n!>]/>f'>< >Ћ5P$pD D:>E489JR4"" :L%9
5Bδhh V2^Du+! 5 31;ƻutX&_S7髗AA@A@ctR_!P!_!
@>P`O? 6`L.ࡠAL&_P`~O<!Q"Q Q*|3ɻm &ArhOE@Qpۀ@	XrQ됀UUtDօ33,i
; YKP`gmrFv!
or0t$Pv0%@EtxDP!D$mD`
P#wBf~O$x0%YAǁK=D=H=yMP`;Ա;
fhZ " [BGb %^
tн
]
ct,W*@t>tq *``(@a@1)@4AER`ŏ9ƏxCQ #f ғƦX $ E$%0@04p@
U%@tDUR~2S6V$
2`R`ҟ8B	S`v|uvTU_PT	b
A
 05^8$ڤ   	 إ FTbp H1p  AЗ!@]C o0S`}0uS`}b"뤁Wab R` 2 1 릀5ѐr1p "(9@( f fߣcEWfh  ơ_!zfcfR`&ߩcN&..@S56P6e!7>d>8FF% 9N$N@fdfAcu
nvu-du$uuu	V@V ,ǈ"]|rh`2;䐃voʋF8FPVh@PwMv
WVOr 
1!X` ^HtHtt-LV!B3+ @!!b?3>
<{¶Ԫ
13d %\4S 9*@ET'*`e|tG:*lg@C*
J
s( ,f+_fF@ ؀ } F估F0FFF\|D>== p  -  -tRp   -ݵ -*t:-`ս ߐ=+k-B `W-@Pݻt}qx$Ht/Ht:HC 6 Pۢ ( c!"!13 >Rc" 'ހA
Fy
t)j UPTPfsV,ttp ;Ґ|a&oyBY!Fp *HFL~f fFa^vfvvFPvڐ5Fpu63F *~%v슅a :uFG;F :a~ t
&x^ |xP ~@&p!  p!qq t&A_Ã@̌?"Ht/)3Ã?@A ~r}b|ɀS&X qpV>X` ucuHj 
&3v0 RheV`ff\`f ` |  9F_hBDע R
V`[he3`8-9t- 	t7 Y`r
{  *XfjjG a
#5	1	u.#JN1u~h Ɛ>` tu}!fh  P	ֲ-NRr>| `6
LhahB6a3`*a& | & F |b rơPpScA >p#u>p\t&el6X`豼  +륃h`te3,a13
>\*u	> 0!jj2>3tׄ;73Be'kJP t'{~80:2GR%4;44Z
`bh j@p?@?@(!F@[$
e6u$4pQ*tS?=<ʓ=5
5
]`Kh@a	@Ba	 fh+rD-q(Rp|p$Qې#;$ %\/P&aRd(a*ac,ahen`P"r ) c%  = $οK
ef1 [L2 SRb
b
~c
rՒ
 }Zg
Pg
 0

 Gwϊ֢A] Dt,-
t%-.t,-	 tE-
tYt- t/PC DɣX`:B~B/ _ }  soU&Viet,eu& riet+u
q0t`]heU@UU  -Ǿ@ut ;>}` 퉠 Pr}%h(	pjtXя60cHtHt `t' Q hepou
^_  WV3ɀ> N3һBrZґ@FPWr~薮Pr{
NpDt  & ھQ FV^tF&ud,,,,,,),p+,,.T>uh hmhE h 6 j v~
B"@t) 3҉65?Q@;@)}F~
r݋F 
h|	
J襾
Z 5#W<B6f
 ~ľfdf v3ɉNv~FV
tut9v~O|܉~*Pӈf.a^3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$7uG

}41t%I67%|bpf:afffI&XS  
:at&
Sצ
 PRt	cs0p` ^3

tF^&F!Su	 |03$NF#@
h^EP2pnGW^rF*f+= 0=a -tX-  - 9B m= M - t!E?h-@  Or= E.ֹ/ /  p- 2&;a% +11<a :a:a@ 3 ֐j5B jh
@ηE
 C
Hz𹄺C/ /  (YP)@ wj}Q'3
^'G`hߐ2g5؎GS.aAc.a2g, :aoa$ a
0ް&
c
Q 
@DMԯ
FW@f
fhR0V" !B
p,pfh*+`()&' $%h#wfb\rc t
Kc weu
M0  O hE `F<tF "h"B}x by_F ۄ-FC|ߊFà>aGͮVAװ
?>a@aa!JE/PFdq`lDL}H f`OeO UKS]UR)D
B
3HT4PTz	ĊU70SdBE

H
<UUF \X~E_Q
	[(t
ZR2@2A `
TBeeǨphhӪj$&%l4"65nfD2pFEpET
BOQ
 !\,B`C`LB`fB`-
@- `
- Kt <_Pc_|`d$___ܿ"JZjz4,2"5^>^@a  ab AB  z!" 8- 2&?dcldzt] dw@TĀDa?-  3 @O+- b	uic] )#@댉  
#j+v qp wb{Tz{ނď@ʣ"Lcfcf>cpp@ta axxz` `&CADRPt &hDǎ&? t
&ؐ
`@T# 
U
C	@U


A C	 @砚c:Qq@t&fhv+xU@{{n~fhzh]0
5}o4R5tfh:}89h7Rz/с0vrv?=>_h<^@L`	BA:2hhWVde$ < u@a@<@u"d s@uotA[;>`  *r$ hh$-Qp1@66Fa u`%///)Fa/R3 (-HA͐:PP%u@u'$F Pc= 0Ht
>q j r j賝6|@uf4;F~ w ʃbrջ|N@uOphhlBWV 6WOp 
nrvƐߔdt
Q o&"F Fߔdt &?ce7$KAJM&PAD@T%V%} _%T%&rhh ޽$ 'Fc"HaF_& *HaPeA u$2,<7 hs?h:<9  t~@ rb` zj~=  TP԰0 jP,Hazp0u.&bPjjz`&r7z"pq޶|荐
F0#0000H00"0!,a:kVfvfhI
 .2u @mh߫ bFb:tF&<:u-FF
*0N&$  
ue3ػQ@C7 ~ uF	 F
  
 
 < w C
v`
芆Pjq<L^߉P
RP
? 0
~ `~ tgh}j1v&~ tD`E=f=u5 
`
 ^3 FPPP FF9Fr ҅qF% -
 ؋0v v sd ƨu = wѧʐLr~ʖʢʮʋ~FcP.ac y ~ t 4Fa    R F  {: .E "  
Qlp~dzt' eƂOFZIZ#3^ \L*1hV$.tCq u^ GCauK  K .g"ǹŁWI Nr@~u_t W    I߸ t@FqqFV!F^=uσFv2N'22g+7@]WV6ώڳKh^h萸:y*y fyfu}oyDt4H-H4HSHFgHHH7I2{yFIP9Az"CLzDzߡza
"ʬzj &z<f+fF@ ^  ^V^KFP6a蒈Lv3+Q OYڀ?;`- t$phfFf~ sAGuh׸镠d fQVȡaڙRPSQfXfYf3fffPfvѩMFo j!0АuCFpvh  cY!u"uƶ ufE  p P0  V6PrQJm		% 6|aD6Pf\ 6Lf|< ub)^
Ԥ!Y0?Ð3Ð8 o MHz` KB SIMPLO  MOTOROLA  HP  1.19A  K    Restore default system configuration mpleted!  a) Press <Enter> to Shutdown S...a <  drivelock V`B C 	u Setup  <F1=Help> FilesInformR  Display5iSavefloppy[ diskett{e from@+(s.Ign2hanges and exit EP  s! withouaving
o Securit@AdministP!or passwour>C"e a/"Power-OnWGpP&Device	deDgDb%D$L $s mart Card%G
supportEmbedde&f
taA!el'etr*acp"Ȱ,p(s$:authentic;xe
credal Auto2cH%Tools Ba /0Calib( @(`'lec`B b H{DD:lf-Tp- opDs AcWtiv O Mem
Chep? r s: ll31mb 	>>uA@AdvancejL`4uagaC lDt7  of grayq6field Boow1b..Uany keyUpY ue F10=
, ESC=
Cl  9RAccep/=Y;esSNo DW, Ao$r=MpI W  UsSarrow
 o highl@ *he appropri~Qmenu iAfqKpcNTER>= cbegiggK%#.followM%%kr&: tj->  KSPACE = GNexBR3c-BACKlviqo"FnTABE3iSHIFT+0&*TsF2@&10`
v[J #'9 Er This60cann)b`mU;d An e oc U@ whs6c.de 0x01 e jn dApGPu@p0{6Crequi@ yayE`d~6jba@%mu0C
movP:0 e>4k/MEU)@hQ1& ilAl(//+2SD`a06ssfulManuZqr  N0
d:Psrottyp@speItepp+CacVize (L1/L2)SQ ROM dd famiaseP8l nupi 	Videovis"KeybooFr06verDb1<ed2e3bg4`1qap<Phip
(TdG
W
O3O	*	Ĩtafdai5uN%BSNK)$ I1
2
3&	ME
C

V


4TV
o
Do
So ྶ: D%4FPA2d!J#biFaӐWalRX0s&1&H} Addline4 AlXn.%F$Warn: 0rk Tpll0	o  zsfTrea /VՀ, lef ea waba0<2 A: 
pde` waqt tҰ_)Vu  @rnInv ȍAP
)!	Agyou̔ wa@|to  @:Z?m  ioa	  0o b+-c(Quicyk`n22 (Cvre@sʅ3 (S.M.A.R?.T.) EP1fpexim@s> ): 30¾# g3>0%v}} t<y ho#0#uprХ:f1't4	f-UnknkilWR!mSesrvReaPS)doџ47p`?a}ribp	a:`exP"9 'b`<G H  Olp New Vfy nY7En>c8Off O 	 ɥA LA66#%&AKroE   p dV
Ad 1ݰU@ҭ5Ocpcaus7APPp@=AH"h` A&فOpower-. ASQVQa?U|= loss  t(dYAhou  nlco7f aQgoH040)ev`۰?[YDocHisshaR`ed?!0f]Dd;dial JJe HP`"UTool Cr.%oF8IL4`ˣ Bk g Uмn qp)m`@jtWSN (!arv0s /UAcwcQɡP2"Onj* e:Z%%% F@%԰#Dn -f  TndĠfӰuCnuR?*$n)tartBQK`fra ParP1yNsza $_mediaa D- rw@"`@zU 	1 	 abouasu{0hQԒ u`X" bbUSERMAST yVpanP:FPacSTkeep iaz#Je7physpE =ph!E 7mp0ar. I7?>Ä
,Pn!Q@SWun+ AgGOO/AutoOc
Ed00uHZ[6 h60?#ONk< 
O[k{ѺaD"`0ur@t\2th Q1psowZ k e"d0PerKFb oQaff+bdata,]ssibmma!L0ligid!V IRsXlrmmN q}( QUpu zl,>`mrepla0\ sp ~p/*`By 4zXr@P4,oHA=Wy`@}'r5|@me`1r,@M`*pPpuibpty.7 IfdoBw8`ESCqt.!
 V rtyp'>'o F10"q brm,bX(yt+  E$6  M0iBjQ  Or0s:U ay OX`ِ2DCgDLb (left /hUS!B t HQbSu K ZipNoFir`ܠoᏴPF th`ifp Sixa RhS ENPh ASwap Fn/Ctrls qKU.S @КP!slegackРLQ>is`7)n0=2r@ry V0o  d NTSC`AL -JF -M눱¡t@
BidpR E?PP ECPd2size 32 MB 64a F@pAlwaynPPi0PAC ~gWLAN D RadiViBluet h /rS :chA	  Sg2ƀ衲Nt E$ (%+"n,2()P)+PP z+f1E1n7L)e 123TokR Hp
AkP	M3Unique IEdf`&0e0޶   (tu@    S`KCalib!
6N sPP DK A.Xb0BY HwO
ELi MEUk' g'MRoN/G/U[|:1 : C0@g . % i] /C le2  yc1`d@ik-d3	 s
H

,
* A 5>hM(o!ylSp` @hnologygYadapAPXE RPL Exc"Popupz(`@0 10  2@ 3 4 5 6@7F12z5' 15`@ 3 "MnB `ouch+paPuSNon`<F1=?Hilfe> p
iYin[O>nzeigpfҠPpeicnt  KaguaobVwiePxnLveinuQn	-hkz
r.ignepd`*nt neh P7/%Set#SRheitsfunk(:n`toa u
nBlt-KuO] Gertes/--ID FO`t7	}Usttz !@@ 0Qz#  beim F3st
ng!KAr`5nHsvorrq##7..z_urck z9
B .p,
Pf_g{ms`>ThEx)>`Akkukr_eK tpBsgewhlDD-Selbsqs@´ItivS9p#LtIpr 3'g 0: tppllTL
PZ `OS
@ PErw :%SpraQ 1a;n!4:#U"gran Feldsrt-O&O9!8`6")e SiePMbqTa@0, um p_3fahB@i=A, ESC=Abb!#`WBkze!TJasN0\ , J<a	=Meh`m VeZ
zpMark"sxy!*!'MenS% dPfeilt!
^dQOgabe2RmO q>ko?9 c`s.	folj
Bn 
sg:@)-> 0r LeGQ = Nch A\pd<-RBchrigtt-`VowA(GTabul!fs+ Holl+gaedOx F2@
038= {gy EschlrLi@PK kan~Lt we YeiffMgЀy16P=`?rge[trЮn.Dc 01 L`fit B 	kqcQFY+<W\selommvPorB]er0ilXWqDe+skU-KsBhmu f 3asÃbzw.2MGobiޯbgtz%.`Qz qh4Bi///"2f!
}[KAlgrѫ ab	chlos@`F-M`ll Proz yprtt`wig!60a"Ca`-i-Gre (L1/L2kkapazi[tOMdPm"Famik 9Sp; ummU Grafik-R0sa@Q "f]>r-Con "
 A  °a?7J	b31O 2O 
3O 4dqV si H>(F `	o 	o
o1
L
2aSekrET*D L$ƍD%'$b-!3Kc(1  WalkZero-T<OKne EdA`@PnO`+: bX7 stqbislwn\Kp  ZE8ucQN-/WBL _leQb s4 Atei#CP0&ILp`ak A:nfC6
lLW$ge`KR/+Pgl`p%ɏ5 L  	/  M0$wirkQh"vQM?`3, daᱭ
l^ie0wQPocFLˤ01 ( anH12 (UmfafdIGc$fhrxdauP(Min.): 30ZБdS`@捃0% cgt59wyuwm HoPuy p%ub1r`"w: ؑxH	ԑUnbeaaMTHC52'rvo-L5.
32@lhafAttrib
u0FID 2u"LS.M.?A.R.T.p˒XXMs K`kwp euys~1L Deap  Ja@Q`eD/t Falgebe
U	 ңBU5Ip dminIoxz Dur1@@`'@`| O mg1i@ePFN1sgd,E.@"< }ttifiz eq s{0yrt.@s Zu1`0LzO 9p袓enl@~.Ajb# s0Q!np'PlsAviceTa s ,ܠF$0@ ah`$pga|F	 :	 JZtfa@npWUm Fun)S7, m3e\Wn HP{tect_ToolsP=c^ty ManagпUo-Q- c}- k QuickLockSubndFr#q\M#"e$bi snchutz  f_-?1dԨ@imd& "+a# A)N+ *W"$B>#, lp$meh1A #I! Nk>"lo3f`ot-.Parpen}ґ:-1a$P
mCD-ԏƘ څM#@
Q:n@C38ymĎ"rive(F0vpl!Q ;b=ځLs E-C?\s m pWبunb{ralbar.ĢIT
gd,rbew?Es`Va2,0fp|b" Ea E'1.J, ҃0\',  02QIjB=n6QzO @BegriffЪd>"kautomMRu @Q7V7;oh)l;> A i Ii {qt?^!Xʗf
V A'!!b!:amU"n O`P o"epe)pY@af{#Oz`u@A58ae<s2z:n	S.)sa`uN(},Es  oh Aa@c%C R p` ˂r+IqfИ  urn3whE q.7 Esdratempf/	f d?1zu qOQdz. A@@ @@R7 .p`r&ѽ2 ⲇ Q7 b-B n rap tAdant`W hٷj @QEsc-a&Llɠ>m kW
!'p'p`\ F10 esRh:
xfPg gCcf sqD} mA@MMuBay&m AΓ)bBtgh0k -ET`(linkCs)tUSB-b#-02؆Su 1nZip 1 U2@345 U6@789 QFn/Strg!PtbedEaCГ (USAtf-ZePcB`iebss¦unabhng`  InGrafik-Contr| aPrimSek% VidGeo-qϧrntBidireal GrPus Lfa`iCЯtzbB
d}r W_LAN-GfBluetooth9U!nT/a Eg0paAAgg	r _%,7(&.(o`)Bu -E`t 1p2ȏ3Y5ToRRa C:=A q1tv^Q1I0NkoF AkkuN  `Pt   x a  Kalib  M`k `O  NƘ:iual_  ! O  k   O DO,r O.Tra-?6 . .O .L4obi !qp9 OO5"R! P	EgnPOOf`.[цrІO 1 : . Π% ]!ablo(2Entl ho3Ppƀ1
m* 2
 GS -2'su' `RaGdap0aBPmbzA}ExpA-!-Popup ( .) W0edau Q0Pd2 (Z@  Ke`~Compropstn@ <F1=Hjlp>Atoplys!pVisúne GN0til !Akonf@b[GendPfraMqzp@QrU
J`gnorndr o&fslu r 1 u*t `gBOtne k)hed AdministoradnAsko KP aodA7 fo% ˇhEdjeG-iSq		 *	*
J	Sm-k	God0delsf 7do_dbyggPGOds -&2	 Nu@00faks l2 IUag
Hs)9FHk@d\HF Ba.@ġV  cb"d^valg b&HDD-selv\tPry Huko`QA.ainPhQ2h OGH omv	Ir/ Avancq Sprog Vel1?s @mo2nedtt felOC4+'/#5l5!Tryk pP7 tCas<G0=tZO^=A, ES?C=AnnuaFs!3=J=aNej "Jg, A!R=MGb Brug pr
NA`RP70we  releP %menup(,1Wt<ENTER> bqe8c>A)et. safpPr'f!f7: -> e!& MELLEMRUM = Nl<-T?ILBAGEqr!JTAB&|2$KIFT++ԻF2@	:*~~= Acce1 h0!hk>{sfej 8A3ku1i0gs 2dodQ)!FF1n.3 Fg01BRnoVD-p% qpla`9G!kr;vvek`EnqJJ
i db!?s fl%yMsÈn/MEUqoO5 bp* uvetzbrud 2JI,nemfB J@^`  Prc c@or-tyip hBig8H  ztr`7Crcache (L1/L2HVROM-d@ f?amilieqi;AWdeo#f0pds:@Xr-cs]D-ba`siH`9e2o`%3o&4Z&at-3ta`ofej1:E("Wat)	O3OWEw ex{%Isr4E$ !TyPy%xy lydes!8BmisW 0'bvbD1I'j`Qe0je v;ar0: DB1! se  alt@P02[holda@ poPqt`/b Bb)-Bdqduw5,pr PkD
kEuGrBA:ރTETfDF%Ugyldcig/
t-  @ngivHuİ,vi av٦,ݍ? i#K?@ $1_ (Hur P)%NOmf`) sl(`{ (>): 30˄2j  `1x0% frpud@Z44b2@DR 	cq: K@uB+"UApyCS'z$esrvWdLsribut: IDxl#ZS.M.A.R.CT.5ܐpy`CD@F8Ny  Be@}ft nΌDeae Fra@l !e@+ ń4PR@{	s0FC		 ƈ4D
&KE  beviвB7 9!Cfdes, fu.. <ramG261 PoRR.RVuAj@me+tabWata. Du bu$AM flAX:Ը vicehCa D[G @ߒ[&?r !,ci HP tectToolo9"jK~ Quickpau`LsQmP Skrp!0rKvt%#k|qX)/sa1-$>$ Hvisat  `w@fx6r,
di upbilK2;+1ol p@frard )x Qlash-@$PR@Cd-rom- V@ôB Ho4C:"eAau ϱ6!hv11,< D!k.  
bPBRUGER-t@OVEDADGANGSKODEN,R3q0MU alug:s  n bf  wned op`JaaP)edS t#
{	ND ll E_C0aQPhjlp<@futomok- d-
\BbygAXl_6b_/k perma`anQigw13n<lx  fys dsk6  4@7rbqpc(On O"l	v  .dC)n0b  `u!dW"eLm/, scoma ck@
tvt. U~u p{`ppd/ctĠ ikoU` .Q  0сbefa=lkrafȀpy 'AQƠ@"pl . paYu)v
 ؑ!  &cO.q#o"J"4,Q/0d aiDHuAP̷0.؁.lR5:@ENt9ra!5ESC. řE# orpy 'F':ge@F10FYMsf
i/PD+s  ADk Osrflgm vdRRenaHPskm DSp-bas MultiBay (K0 /$hjUSB-floppyEC|cc{R}wbsu SbAzipFr`aVTredj@Fjx e SjSyRV O Nqi @Ƀ Skimm Fn/CGtrl ElPv(a`isk)!apegetUst픙t!
uPnPa|q0#rm-c%r Prim Sed V`o Out Paraa#  T=jStrCL`>ohukoc B< t 6nr compu Q0PP^trm
gat WLAN-!sioBluet hK/A (trdllo|netrP1U|Amstyap׃&(x(top1*b*Ethqft 1K23KToJR aYHL	pe+	 	Ent 5gt id-nuPRai@$  S`   Z 7ѿb/ JKalibB' ܯndaig O x 9p6  @WNMH  KO OM2[bo   O O#0 OOOlO$HAgs  1 1O O
1VSi mo`gPa(MEU)J= K=OOGOqO O OpOO[ TPq? 1 : Os . `% ].gAmt2 AfFH5L)O3@	Genos	
k

, !*  J /X4%G) g`hB`At `r`bpopupsink>(sek.!H025f-1@bgpP`pA Konfigu!2mas   <F1=Hjelp> ilDwin0jKons sypLa@3$k")Hefra6#:0p`di!o pQ	:k@'Pg avslEu!A ,lBDE;sprogranpt STt Zpass@ aL/$OpFA0t`|U'yrsei!vsfunkĒur!tif@ԃ%@%-
vn Sm4 #godkj 0RƐ!neby3Pi*%it"ot5sTilbake:@l#3fabP @PBQ`g
i
! C7;avL~`Srkty &= valg !AlPP 65vvt Ak MbT !#[SS;G@ $*
`H!4qv prlg 6  Dem75bM @ZdtJIel[3
 .5E6o%<}5TrykkC tDaJqLL&pg _=, ESC=Avbrya bBAPpJ=aCNei rP, T\Rer=QMbb `kY;neRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMROM = NQ&86  <-TILBAK9EPvrig*TAB&"HIFT++F2@	)}= Go f#l`bsfeF`  SPk0`pZmnMop@5 PS M0|m kjresve!@m dX;@i pp 9!obaRafly"sbc^ 0d@S w}a`1A|rv full1z. k?ode 02Io"Produ _t Nopablokk-mll8  {typ Mh@igv&-ga zvAӄbuffN(L1/L=2Meng`	Q	enu V&@wo-ЏTjrtroUS:W,kobgRi,oK51 qi 223D40,p( E
,9(Q`
oa
oA
o,
NEkg#Iml۔$Eo%Hq ok!i*ps("Walp9g 0sS"-h1jH(w Adss ue7"~e PRnAd 4~: DsA#.s@QtidlSCholp`@DH[aQ "/he- M d, rnP}u1pf sakl<2k`nn0Ն2A:%ڲO 9b@Ҽreg1i%HUgyldig#DS R`	F
	#NEEh0mtE b`?̀{]F igno3t_te?-  HN 1 (R @nslXbP (): 30A3gggr 0$s0%[v\st!vhF_f!_: Ka"qut``樢UÓ5$SQ&eGt To(Les b'1Du+q vrib: IDf01rs<pS.M.A.R.T.-f^C0CC  G#Npu  Bekreft njAv`l ePcᰔ1 qrEّjvlikt aDu!0o뀁C2Ѽ	aŤokag3ogs.rɐor dmpel&B Tp}?ّ.rPa(A=pYph. `bku  amK#0vice.0ula?eD(s aݢI 0"H i HP ptectTools3curity Man0`r.'-RN%l  ēlanppa0us L@$AOmpEr`i!gi$eu beska u"-U+/- +ӂWE%q  '.
 tgl`rh,v@=$8PŶ. K$RmEp! rfrard- Parll+vuFPhielQrp2   CD- %FtV2uu Ho $.:Be5C`Ehpvalgtuh hh"4@bBRUKER~HOVED-T6蠯 CJ Rzumu 0B@EQ
 n0^*REDbe!1LPP
0 P w@"!2 Va" #
6S,AS[P= 	"ن 6*pp  tJ@IOM @ automPZpD!xLock	4dbygg[)c1a  @^maPqilg ^ge0.S k_[h fysAad  $0GnrW m#>	}v!n:gne1^VsQs ѻdda g ~u%y. Uh omd@O1}0/e @XG)0{nq
` uQbV>nbefau 31G	A} q.1A=x A0k1E 5Г f iP_!R!'Y~I7 MTאs x-QVflans NPBv
,2˰ESC-zL PϢ`sb'fD'J F10$ZCb#e:hf$ nd  NKor iFGO%re  MultiBayPG]z "Q'n(ve!e)pPk}o.ngsbahhyOBUSBA|w_ Zip-U
A A0AaFn/Ctrle EAVd(USA)GekeeanAela	jZtsroA2deoި@!"pTisrr`2FViA7tiࣀ0ymFgradi/@trdl |t
WLAN) OFBluetooth 5/-PbftQ`mbQӅ Agss`B	styQ'1_"&2xo! (v"*b/!1 EthP8?	)P	3 R
@NsA'oo`o/
8ni>> gtifikOC&\=B6riQG H
t@    3ymbo KalibPaK BL!es- IA09p@<Dual ,-N	O	 I	O	O	51O	O	O	O	8ksp._O	O	O	`lnd  4oO	O	
%O	O	_Cs mob. ^
H.\L. \O	!zo
{{O	B.[ yTAO: La9. % ]!fullC2 Fa{i3
Qi!n/h* Oy  (o J/D
irpk)mA sin hurtig (/sekuPrF12- f1.Sep_ute P pConfiguracie la Com`adora <F1=Ayuda> rchivo  mn%l Sma``pGu isco fOlexicX1pٻ Ra`&sAvalopf@dobPay Ignambios y`li a AL{  g3 'Ln@epidadAse
'  ' Axj0iciof%0posi@s_SIc )$ +5`*KskSm!=C SoqPe*cP#<) Sect}yincor% E 0e"@ 30/c`VxP>6fbrI
aBVc!3nci@])AutomaHerrami aC2}H`er  8P(8 ;prueb_a HDDKc 'EOGVЇ&Memoria2aDd*mp.l1@0JNKRMu0G`SG#
s
 AvanzX`ESvVDD
W? nFampr)co0N gr0<1o?)<UOprim'quitec0g2) Pbm=, E_SC=Ca06la==Acep\ u=SSNK\1"Y, CoN2	=M y p UyB$dchDha6@alvP}  alem o apropiu=@[*<I?NTRO> z qx:N1n.Fs{3pkTYu :@Esp~o o -> = PrxcRetroces<-{0@aؼTAB S	S'a~Mays+#1C(/F2!-910`rXŠ"8b"uErr0^6F  No@8 AiWGSPrjo u@QRA6K. CdК`01Bha7y nunw>э&qubRnY2"@AC1+>b1 `r(Rp[co`rUD)JН@ebook/MEU? IXQP\ 2O8`0ple0Vxitosa4e Fak T1ytil TiPsOp7,VclGpuWXTamauZ_0h (L1/L2Oc FAAR;OM mil@cNmerD}ribvisUv@ j6r g-l@yo!!
/H#j1l2n3p4 EtiqurAsI2VeFK (ga`@Woo.o3o`opoi B	Esn!*J8T 5:Z$  ProbU%bssfactcXJ$ǔ =gll4Reo 0poX@y1'	lnedi$l@z,
(CE|`oD"FF%Ad :vH uir  eapn. PreP4#/, WcqscpYcuA:'p, Uu c l Qas ' Ӣ,hp9tegAң
S^@vClQI$`\e'vaPa)00٠o(a) 8!@%c	Za?`ganޗod iAlO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcuv7tieej 2( s): 300go LB0%&~Db  EaH0 _`ipalGirumq
 : s,pu10  qIQ{`3nh7Servof 44apoya atri=b0: IDp#@exs G
X0YA`seaـKHnuevL@)Df ApagE ndq9S!@gOB".X		:@e voc"	ؐk"alpa 
0 Lstnad ;`fRn"]e#թ9 	A*# \A<Q, (02o,vA`Ơbs (R6% E  Wci@R|LLBa hrp梅inR3 S$Bf_ olı9al ol`X#A!vu	jvip.AoQ C '{Ùv?%( ֠WapaAuydAn14n HPctTool@O)%!!&  QuickLockSuspen Blo`^Թ\rat S 6""t mej `eO@`?:0d++-y	(BI	( @!)(rALlRt0,"D,P0X&upizQ,.`xHO;re PunP+roj	o%q>lWS9MLmedufh zBaCD-q(E喁&XPk:	Z@U]s0io:OpuT=sPP  !rrive`(Rl! tpb|USUARIOJ PRINCIPAL0Q@lo@圠dtVKman`V p PyO. An[4 y gu$@lugП  `j7a{DP..'tJ @d]"YIeGӁ1
c@bU=Z `>&BQ3"mc8K)81FPor/A:
;A ;QrkR ϐu@u  , fsm 1$2ARi@rP
oc, #I"oi /#_@z"<Y q0u HSϠd/a|sRcubb TtBB! ? |pda !$kosrgѰ6Se x9o1enf 8d2`lic`Q!"reA3aza. O?k Pu  `#PZRS4=T#in!~k k0T1B¸fiup8Z!`
s|i@pons2> Y_, iѰR ESC.  xձalabp'Fd'  ,F10!"A:ҽxfG aG7T/Espaol O@rStM?ultiBaNPa DiPsi(໤3-p ;]ӟfbP"co+(iz:(@jech-5 cBb a`1ЇSuwrkrdZipcpmeaeTe]r Jo C`5t#j0 x SjOv No&D Cus Fn/`T@ncIngls (EE.UU+.)sp¤ (p۶pmplSo}"le$b
er10nt!Ac@ G|ΰeo Mod0z"y!  Bidiƃ Tam&CmpI!i#	si0߰fu(0{ BICARPQ׀k*WLANy{-Bluetooth IA1 zQyyQ hoPerg`RsCpoos3B_-F8(=s)ior)Ethetw, N0boo S 1/,2/L3/TokR@bOO P2w3 IPtif Exclus`pᑅAJa@4`  !,a*EC ~d`*-NX S#ӏoATr)3Vh!,o	@o	k	o	h	s0bhn	o	o	ehao	 o	o	a o	o	%MEU 6}o	. o	o	o	o	Ub o	o	o	o	B8[ 1 :rg. c% ]@ /{Am2 c4-MClē3	 0k",'!* r 9@ODJ)o!Ѥoh ~0aБAbblR⑄ @zArran@pٓe#DuXDᎰ0gEx!p`F12pQTAmbTouchPad`uo N`u8baưub  <F1=Ajuda>rInfoȇsobo -Sd E@i?5m!D$bβМR!0
	r t@7padr0
3r  Ign`air@A	sPs'&_A1nanJ4aPOaDr %&ާ _`#Ɠb!X_d#!

SJPtSd!܂υ8liz/p@ʉO
(I 0! s@/R Q*?g%Ϡbr
aut<Qn 4dcЬEealha@o`Ma (QkFeOmPas"g1=iCP8$!leRߠOpT`HD7D A1)r  VR#Le Mem@A< 4tat1u S`MuW^G[⩨ Av8S%,io Qa^d; ca{mppJcinz"o?CAp9`esse qlr wc<и'tinugy=' SC=CselaAce ,imNKn!S, Q%ou=Maikg 'Uti0: sC	qqn'	da o i  aprop@w *u@Tt#<ENTER> t5meRez[@go.Tgu@n:9 ^r ub:  ->
PAO = PrgxiK\<-QoBACKCExaQE06TABo$SHIFT+C%* F2 	*:`=0kSC# 9nErrrOA@Q@na0WoQpmRHE. CϢdigTGo 01  NPhG`,@o `+)3  s@ viKCA A	bMev
;nsf`ZWotebook/ƀC[(RWS mDGsTe2_DKKXqmBm xiton=N  Ti0H(3VpcS_p\ Tahcache ?(L1/L2੦FX a` ROM? FamlY  N 3sri|
RevisSvde@̠_aJroQLa
Al!D	Ob @a(34`RtieBp	JIOeuH6(]) { 7on)oo.Oo$alS~ƕSecunda'$ 1rcC% vfoi"gv@!mO alx  Walkا  0e g1i	a lien!M!oc0I@Advert: `0[Aqo vae!djWcqP/,!i@um  ?gravvuu:e)EӎOA: n@Ad	c NS3 >B^hO^!QtegiEa	pc]
vl0IyI= rkT@ctez0<eja $,C? !iN >?ý1 (Rp b2 (A@ng!qf3 (S.M.A.R.#T.ax`=_(.): 30<`хѡ0@CT =4Q0%?z1$bucedeA,qAhos9tDCrom1
: Iss -P$Eg
Ch`Ӂƫ(*e=rPmec @  `6Q3sxM tribLD`AМexa@s wQUUCig:TgrDg`al*PSLs   qL@ rB+ۤiPA3rrfDigcis g ҐSAdP)PPЉxaNcmod!CsB! fazA@ArEr@a,Πer dform!r3Dn,FPja0.@eHCsHfb}rcausadQerF. TbZ Q[ea 㷑2kr/vio 	Iy0rqX)QT?%0Р urb@r0k
ad`pis0S,B,QuickLock!Suspenso BlAo0ktB #u@aSM%` mabnb1(IY @k,@$$al#.2P4sa4 eiSib0RPuseu ysEExigU&`re*PbM0Q+ &perme@$1lp즅+!CD-"˯gGP$qm摕e:PDusu~a: VocÈ @gp4@a0vr2utzooDrive& t@$RUSURIOB|G@ESTRE_ FSC%ɑ7q<Vapaz:@I. AaN4P@9de-`ФrMisPJEB>p"}@. NNv p[֣,'6Ve ,V`(_K` 0+bu:*Ƥa !Ed!e]D.Hf ``7/{s1!Bi屧O7T>WDIAV
l`9`w9o  sumǛEf`lo,al Af CaFa_erf
a`uuzo T :aq(40  Àoqur<ǵx@FkgڲU
 yaf0T y 2y, p;) F `3Bor nal|p`a-t
A^ tEsubtud C{ ?@* hR)ppa۵ptA-lVJ /qrWL !8Z  LemGbre ՚vqMac`Pasap8
"quiP_se`R ESC]ŉ9Šq3lav'f'rF10. r`r:BMrʷTAc]D ugus Op1k: MultibKayQYNc`i#si reAFpBa baФcopld(`RP di!tzB	qRc"zipcPrimeir"rc QtӂTO]v@N Ղc@aqAs Fn/CtrlIngls (E.UV`ыxS[hp1troahvdeAcund a@hMox#aGPadrcBiQTaP=hBmemO"sem fubw>zec10CAJ.#RPa 0Rlm>WLAN)` &Bl0ookthkAn2(ڐ(a/ Eomen7erga  gere*agBC/*1w62,2oo-'0suЁ/0Et#netg	O p
/*3/CToken Ring OOboId!fBDPPb 3araT qUSt sPSڼCbQGP_t'gemNSr*l1CsrNWDuplo&	ted/	)	E/	 fONOO$O'as7AXjO /	kC/	cIAlЏ OO/	Ojb{MEU/	/	-/	G9Dq	/	/	/	O6[ Etp 1:rreg. З% ]@Oc3l 2:cvN3: M* 2
 o9ayCJm*O"(sfl'ex QSc8`xrydapR쇕 i3Popup޴ Exǐ ~F1	2( "ߢ dQZs Var\ava Nu`Ti k yktukP  <F1=Ohje>PaJrj`PtQt Nytto v0`tu kP Tallenna levykkee !dkV@onoPPuVtF?Fo0ej'nsW Oh mupA loepQ4Lr  ttt7fTpou@aurlisuinvojan ssaPM?rito/Kynyk La t$yl	
 P ?usnumep
o$-
t_ lykiu '
,(oPnu kiG0
/!(et   eP.4tQ3Asb5*tehd 7&oG"@t!B$j;A6)ma*in@#Tykalu"A: oK < KioQ<t?0Oa9@@DMuNk! a"R6npC:m-GdHLis=ieli O Ik aec  harll1@1Q0= 22R2#2h%Jatkin0jot~  npp]=d, ESC=PerF=Hyvksy=KyllEi cM, JokuAL=TY_ fnu7oli
mip_k`ah$@
sics"N <ENTER> mB@t%
ep+.!I`Kgn C/ss seuraavU: ->Xi VLINPPIN =P[s  <-bASKELPAoLAUTEd0fb1!9ARKA+! hVAIHTO+', F2@
)_}=  d@!;0virhvAkkua e =oi>da.>: Rvdi 01*ka c1s}4 apHrt2Pl pU@eytke`"6ko>@	siPQlaks1qиrYsRW` kaCt qlaaP^ TikkI)>ske_ytyi Fn
i(pO2nL^o2hPecaGEmA|ja|}1?i@d tyyppD iIn :!ap{llVlisQ (L1/L2U  ROM-Sbmkoh	tuotep9e")sar {W]`si ?s?tohjab T;{	!1I:"#2o L3o`M4m魠J`LtaQon7(j \oa)



\	\JEkA'ra- DqACuP$#:D$ P9ar%dzb~ lpi!iEepo3i Walking 0 -[1Yloso`Vaihtoe@ :uvi7 us?: Tm󵐅؇@atpnhp . JltO luop2us-  n,pirj1onc !K A: L"X AY	hkuVV 3beFAG8p_Cpa h
gHkoa]Wi a`nA? `O  Pi?ͨ,i`%(ND92R`3.M.A.R.T
.@Arp$ [n (min): 30-%s p2y0%cL dv0 Ispysi- 4iVgR
{fb%uCntq'c{K)jServomogottj
Lu!5ÂvtuQ	k@Fttribti2`ЗŽy@a 6e*qKxe nGG89w Uue/Vahvu  x P>2Ȕ	! PC }A"+2`s@a	,-ãPAJ頴n4-okkpD;ad`5an /)$inDP -e@7p$Rmysba
`kD 1h@` HЁeT @	dE	ZEY/ i0Xj [!K uEnQnwby:p\veapahtum"b@^id FLaJ4tii l <HP PrpctTo7ols`cuQ`Pger -apQuД큶.f(-/U i` n QuickLocqkfa hlu5qf ,V "@P#raZ&-Q,:*sekm #o$j$it)a{d0||}yh'  PP`0#U8C.7>uu	SApor In+frPnR@%!bkܑCD- -aglWpbt`PBOj0WWAiot=bUon DИe$(qpTT#)|PKlla. P    KYTTJN:a PSSANAN,0&#K,x.ma$r@'silyqNhur@S9h 
 ri_g[t _r
%VX-%PV,1pC@@jwLLA1=[Q'᫆ ONU @Ros`* $Vh suQFZ>R;)f,#tu?x	5ogm O
 G BU7m BFr
Sxez`jED. NykyscR`+`RAn𨐆{s1x6s
t@@\ PU. Tnt Ƞ}$6ih1xeip=ݏuperVd<eh? IPa*?-m@&yް\2tHtaqV^=c |AxojaiemmR}tAq.A 71pm @"Fdt" TV@UG.2!`ZXrr F_Fzc$ elnPĀo#\X#SS,aTpESC-n`bPsR6;n,e'e'!> F10`Y4aax :B	o .cVQ llQޠtmidys ubbn MultiB
aOpc&J7^lako0iu6 (en/$oi) USBd@)ZipEnsimm ABKyoA elj }Vi}Ki eit@Kapk Y Kym!aiо Fn_/Ctrl"mA8+Engo(USAUsP0s#a!1@B-RsQ S`nq`jBs#PPs V0o'lht\Vakiops2sN#Ig3uuQH`Dpl1% verkko "
WLAN-ro'Bl]u`Voth @/HEh^sV0@Qs	 s`9lƎ
|+1`i <9.2v+-	+ ?(ylosp*OG`COr5EthCerPn1E Y oeo3o8+To p#gOo(@workQ#%G lHqlivs AGkkuR < TJq pҿ r{jolibr@du c`d  Wual^-OO  OI OK"kb_OO  O ONr O$O$O$tva_ O 1 O1 OMЩaanusBkOD OO OM"OOO`O
OI[ e`i:r
ada n . Э% ] `ODPW2l ur00&OE-O
3
FGo@MOH*  j ,9@ ƠаBk F1vuCPPɐiư  '(se nA@S`: F1S2:ٴi@P%3tappikoskePPP. 'mmaK  Ei mn Configurati3ordPteur  <F1=Ap> Fichier Infor m Aff age Sauvegarder sur dis!qc R@a*r x'uneA.H_DHeals dfauow {du'Igno%modi Tpqu S$e l'in`p$@p@reg om	\ Scurita%Z
e ssLd S"#j@e sous te Ion.D
 priphP %J	a sEIIDy'As
{Dr`<Lockq
Smp(CD0 Br13r3̒  'heP5 Q ,b#a <ۂgre taR, 9)+5p7am''us3;),;rfrencHM =``t"#Ou@[ !@lonnLb`beriZ sle-cqSn@psQBs AIATA$ BFoV,?mmoir`hc BDX C0ZZaFB_V Az0c`oLang4? ChoisPJ Ul3Ind)!5_mps g! 5ePMd.rpa`k2Z}:z? AppuyDfatouqpo@ge~u@l v=Ser, ECHAP=AlH>Accep S_0=OuiuN*#Q3V, N'impp_e``D
=p0aw  UrPzi3
s f'heM
mo!04ecle hme;nuucer@r0wbri2qh@z!y <ENTREE>2nj+W	ss	sui0@/fa  !/ :-> ou BARRE ESPACE = EPBe`-$IEpreced@STAB`CA*'MAJ+ix F2 =1p"w-`$!S( rr`x@P<TJ Il FA%ssibcQ7L U cs='Jprod{endp#B$P. kCoa<'401)c5CntP@-1 empla3ce(L' 0D SaQre@}@C'y
GJ 
s}^ccueil dн "4 itaxsmobia``
W 
u` B!OOOF2BfCX+)a wru Fa0;cq0M\ TyQp0osBV8pwDb KTa@rcaa(L1/L2) VGolu`e!gD o ROMOamR~ Numro#p	Rev`cdo erS2ItrQclavpoLA}ud @;n+/Zp$/zr3/t4n"3inv!/Qzi&5 #priF!L( Ute)OOoOOOBV'edA Eo MT֍ :$/.   %Er4 Q!SUPc;Walking 0ᥒ81l;ig'ad`aauZC	od g al0ifAtip1SC[a=e@ptcruA ieЪvPR! /0簹r,  mz{ nroc	cY0R]A}jDL_聡v
 tro Pa
0s
TX	  _D[Rvjaˈ"`dH.On m:YfPS 0"Ӏf   +-AvaPC lp  ߚV ? Igno7ꉈ+| z Enregeo#=1 (rap`)#>2 (coet)u`|pimA(z) B30堿s pAU0% nv$D9yl'hA+bF  `:@˗	AsGinpnud'+,`v`t
$.ELu( pG3p 5A`ib!O: IDP0ࠒ0@"s S.M.A.R.TAbanG2WpW AIBY`se N!=apYeAø?/@;sa#A Mar, uinKS ;A, e,ecoac	;mme, vK*ad11POobPbatCs	eSdp4D	 pe>a1a`(`ifh s4[,p@s蒵 `Ug"  for	mQg-hq#xRѼsJ.)rmQފb	hJU@0`
1AJ.6zT"`QDP~aR avoupR!Afr Cww7A^	 	zY R`(p"}ff1Qd  k;#l2TcgN<q`rHP P`o կTool:eRyW Mar O4K8CF!/  QuickLo;ckUsusA |$cp!#ri 9 س<S&ocl'S+C)re!cB!
`Kp)!nk:,   v qi4//  / L'(a'a
S$ud!v
 KP
dra+D hn 4`ExiAudP `  4raQ8llƙۗ&flashYd CD-'gEfWЫpala*Y:6PR63ge Dri;ve!*. S3A@xbAeBdez deux"(UTILISATEURPRINCIPAL) "cEǋ	r SċOj N;zJ@  ұ@Fᣐ#1"Qisr  ,mfye0celu&xNSDordi@"c. A0@Q V	{( p$OV)Do Co 5AfetrpyJ~ N",t"~"rAaSX"Qnof0; ;""t QE)=ahx:>Janiq4 5#'/#!2/r,c``sĻ!Pl!  30ӿ)Y!!}	 !!{e [1NJ^%puel1@݂͐sU :Hh"q ""opDa8lEO'fW'ҜB`k_w# ,d'originIlv`O2CxIaB	uȦ"
vqSpa0AQy9	0t0M@x
5dja
BvPsa{S@	P{e*r-$ށW1aprs@4AAon: toP@Tr0a44p`abzt3إk'
vj, appuy
` ECHAP. H@@ OTzR'o?', pui@CqrDF10 TapXC 1xCxY^u}	U/1Frana
OgVACJiMultiBayѪulAphA !3Dp,xsoc]a%(ga)O8OFRz) U[8 USBF1r
jZiprP,: Dhi@:s QuaQCin`NSixi Se  Hud NeuvCD`Perm/r(s Fn/OCtrl@S AnglpSA') Pcopqm1`s A sgtan0`hnRO3d'ad`n{eltrl' Uichuer&mR`
*d :i@7idopAABid@b 0 mmVl@jEK!al ó R o!=ril WLAN (rǊseil=)Agr{BlPooth73/?1   ;o`! g`N loc 9G ``!WnX-jb61AbP-nH o82ooypqu9	3ccujod`ogB EP!t  1a"23TokRingooU/IduT6*ao aX4  /   @  h ll`ъ n!Hre`0/ x Ab!`AC.!f*Dup h*/)///tb/ ////** -///Jngn$, /,/ /e s` Bte5xЯsqbmoP //7/// ,/Я//7[qRpe 1 : Char. % ]PA.  2D` GicM*n3@	Rkio.
* T  @@/M.$ oOAg$4Amor1cFe"5 ?RetardBTexp `) Dгa  F12tposf[iP+Aux  PatqbAKw ucun II@z!Nl1 <F1=Ai:0>`nfo0g.ema	l p|'Salval floppy%APt{toRiprPina dmThПifa p`i >Ignor`daed esci EP a
l'	iI?z`ciBPtup iczza sswo!%e am C0rato gPccsP
_QXC*vos7v% IDs
Ҥ&gDri?veLock	ܦPr`ǃ)S t{ C7 Sup;(  c30 g HQg/ o+:,i fabbrP
4=i	/.nzi[Oco
rui Cb5<bae9E`lrOpa@t2;o rigidAt"aA'Va,a mepT W`<HKhM%iM;A>o !Ava=t Lu!O l$Dim"& q6sca X sso eviQ g	vv!'#o*62wH8Premi qsiasicsXpeirQVu L  @i=f, ESC=Annu ,TaA Etpoeo=SiSN1T},altro#	=A bj U}s"SchiavI? frecc'!ri1`vocu ap70e"_`<INVIO>  \k\'e.ipYgui  un%: -> o SPAZIoO = xsuW{ss`0  <-poBACKCE`c<ؽTAB@C%o"MAIUSC+)XF2	>-= m "AC"IErriS0D  Qu A87npupvse@t"Vi ' v@u4Tp|XJ. C{z'01 Npu0F>9a0 Doggiao Lk`IP'0  Q>re0
4E=s"@agga%FvpSAcғ  =npabook"zRQzespaj T:\ Zf.atp1_
2o{briuPrf uduA ND  Ti"+0<PSpVeloIStepp@YMis1ca(L1/L2 d&dDbROMIamiglk N@o0H`("	RP[3[oi#qSroll TsjrAer ~i1OFk2m3n4ࡐ7w  PVSTe)DE(d)8
$	2
3
4摭Fonda
t ,o:EV$ T$r%O	upyP!gTŒ\@lliASprB:bit 0t 1И~Rindirip	i] @`|@'FAЎso:5X%?~ gger  `|vpAhAcre!0M/rѧ, `1favi PP`iVYXA:'mU[A:"ma.conouAhX(_ IISɸQrita] Nsv@dpRlIQOy0ളSe3 `voPga ?AFbb iQfre?@?: Aɐ51 (Rap)62 (Complet"v2tio (): 30>0%Q5"r6a1r0䠈'hD5(|:s* Щ-@
˱ (aD୆%aerv|")LċAPLA'	߷rib i0g{ol: ID$Ban`de@z قi S.M.A.R.T	.!ޱuT0U^ _wordc(nuo!i2 	pDsc(Ui%L?bq+d`ᗑ {â"Znd?՛O.A7Tcq^B&
Am AVf! B;YECr	t>J2fum y3CeHPe<B #u _t0s!1a哰. Q]ՒbdFqo!erdPКatiwEfif+Jizso@?in  ca2ivEvPgaζOdesХ@Jm 9Yy HP tectTools O d.ZRV2+ ickLockspen`3B05EY mou`s8 M@M d?#<#,p  gra`@p'!oe - !e$C-))v!pKsm@]0x!! b	,'URar i lі@NR(@|ГV|a infraQ)p y%La_hflasho C#D- eS准2&WЗPp`	: (Y=!AҍўxDeyusan@uDe'. DU8HG=0R bRY"'UTENTE@PRINCIPALE  r+``"ρa PgmanA5fu`>o. AnV@!<dЊ Qt@P!"A eC!>c2<!(t.`leu0WMT[s,
`h	\@poI sb<4reWc.MaP$i? `o`6d6dqGi>h@A
 @re,q  d (1z:t tOCF r luogo ĴG T!¿'    i$  hSGT#:,eG< /I"I@5-"L7Y $r@lx|	slmЄ!R/0ċ|cB  /$² ȒSz0SŔ@c (0 0DA's`  gPQ#pQAiq v 	lptat{ +`uY/ AdO::!al0{s&.2pqu_{9c!. "Y)@sA`YEsnO`d@K@ȱ0'( 6h,m>Qo ESCFrM'ŝ)dovZr0 'n'`po2m!nF10.ɡnQ!k 0Wyƴ_6\WРIP(i 3  O :Ć d5m MiBay b9a 1.gga 
s$Z) og Ch`i USB0A]Su޹kbC
ZipBP6o ;TerAz  OЁev`N%ec AAP Fn/Ctrl T`Ingl (USA) Yidu2O mCpl  A01aЃ` R7pl AaP00!Mo@ecW Bid0HaCapa memPqaX5em s"F!/lbQ2'/wNPs (WLAN){oBluetoothCOommu5/ (j)@s@m> energZphT1$0&1 )N*'2HB*Ca6*(0o)ol,sp EtMh0etW VI123e Token RingOE3 Iahby@@tqaI   aoq$  CP/b// TDzS^oo  Y0HiPDuT  / o  6 /  o ,o// o0oba c   / o uY\mo 9S//- ooooų ///oo[ PAs 1 u: 
ro . @% ]ocGomp#2S'4,n6E3`
ij* 
 /JoXaX/3i'o
   Flopp	ybUAİIAdc`Ƭ@(sec.=)C velP`F12b 2z@ambP`Nu up <F1=Hjlp>@rkiv Sya|infot 0s~ S pk%kigu @1( stll frnl1ôn@ard Annuaa nd` ochsl  anȑ SOker0 dP~RtrslpDN  K!aOB@rt-OaEn ss	(b -ID
S ao
`tPd-Std f3rutQ !av 7K
?byggd 
 usBi=>*abrikP+ .J
sbehq #DEsktsrktygs Km +r vl S`;vtܱ0HDD Ak_V Minnes: $01q5`?@An '@#B
Q  VljrD;cBne+dttlD!@v(C-j+eTryQI fri Dg@q nr du viJNPst0x X=, ESC=Av'bryNaFD_AccepaF, V=Mer X JvI pil	c	/pCKa yEt
<RETUR> om6
YRtt j.ie,lj`SeerI  >: -> MELLANSLAGSTANGENTEN = Na1S@<-BACKSTEG FregepyK TABf#OKIFT+H& F2`+?z=  'fO @%Aoi?Cfel 3t g1qL` kA@t h+AO` Dstod uGen. F7elk0197
 AsgF{P|plat  NtPhm krv3?A @pbygm0 fly5s t6 -datwor/r ex$(|0Ytidigooi2,-@kl`TA UkN4,  Pr Pr, typ
hasth^hg0Ca-	rlek (?L1/L2)Yd ROM,tum  familjrenummyn0Ddeo,`Ar!Y ttNb ~pqyrQ!]HN 1.z2R#3$4rbinvp ˦V3 (bZ)g	1[


Se%k# xIrqH.4$@gaxr#%Ex!z=ok!ŰvidClmissl l.s Walk0s - ~P f1zjH Add0Os li7Ae nVar! D@/ѹ  7neh g"CcusWkapay /G!-t!ڱxiƱ=k b!h$2AA1:1R K>#Rhi{wIBB?skyddadag

   E˂ˎ҇A!^Ԉ # |? #ig?D܇jGa- 1nabb8If@րn`X9UW}k`ad k$pQd (0): 330@npan 2?0%bX A4Pp/]pp01vir katPo:,t	!قGOk%S(|x ervo-LzB!i @(f%ttrib?ut: IDpx?grobsr.M.A.R.T.->5 GammqN u7 ifin@ D> LܰQ R4d% pm}v~lika mǄ  0'InE?kan orsa@3i ЈP9aHSsNypPO@COm=<s1A1lo. |'Na om =hglmnabtj@Deh ;else- @^uQuayVqΦ >fun 0`ʎperl^7!i HP tec?tTools%R-6-Quicka"q`tel?ge Lp׌mPs Hgk
gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!a<ot. Kж7AompHi )p@1f   Pk`anFlash-@: s!CD-pBW@u O#TpSr? HuvudH`y`I: D,`m<3vahrdud D~e!. /C怆a^r ANVsHUVUD#$|`lpmart w.] A? L1Ёq`ild frPAD+A
 I1Ph8Px@L l  Qף(lHTwOQ.!Y  *oH XBe0bbyggP6Q1C g3///dZ6- FXL;omc eB
8HcA?= a ?dr:asB QGdʜD[.`ktuPaiq3afanDqkr`.GsutAMC]tgrs^W!p,t1ursprung`LxK. Vi  reko`RF	b~c	Wr `+,s`:b`~. A `KT̄3_bh  &g!(g A\zO-befnse rm ih񓶈fljQfns . Tr  >ESC- QBSr26V"ـ&wC`'Z'R-sedMt:aGF10`0cVi3a:+ddBQ~shye a7Sve a 2 Q: N?, M iBayCrut`A~opBP5vi Ba PG (pr (3h@SB |G Zip-=0PW@AsQFj1ApQ utto NЛT VxpFn-/CtrQle ' E`{lsЭ(USAbmYkd@!aa b`nrmstrorxK,x  hbbel|orlekhpeo2ne@kLpҢIfEsio.BtrqtK (WLAN)Bluetooth p/() -v@ANmbe1 Aggs`haE%-21,42v0[,p$Ned Ethೡ)& 0	3n To!|RqN"Unik '1D<qiD K `tus a     SBbo Kalib o dp{P  F:s alQ.O
o  

 
9 
Fo 
E "
D0!j1s
 Aoo
E
Htag *o 
* 
V2Cy e!mol]A *5ooe
D IOOKood
D?[Ne _ : Laprs . 0% ]
klar2u j2453omFjOF* &V@1 >I*O! DgOߧ̀U«br@4sadapМ$lg rdrjQsnabb0 (sek. F1 B=d StyrPguenD!he 0ae/ `P}Op e@slaan C?onfiguPpyoanafpvt ardQ3!/  scy	WijzigS%ne@" programma @٠0Setup  zr w ؃@svei !Behee rswachtwoo1ڀ
 $X. {Ap aatbOgl$$ ID's 	Sm4CP p Oau3P$PcR%mj+%O
Ge0g3 gssvzie2؏"Fabrieks.pugAz7/);Vref.s:nieuwB8ONc ަ ExtAcScuwB ZeN geselec Ea  es  zelftGa -schijfeai`Act PXvG0u?1@I @R!a/ 4UBgDAcg@7n ,D`P=%_
 w 9aKc!: alaal =r/em 	rijsgemaak& el;o" `/;9
8ukAZ ]0ayMLg]@f=S, ESC=Annul"EDG0=b!emJacNee fsl;ui@Q, AQ-f`=MNHulppijltjkp`gebrui0d )jui~Pwnukeuzk@ark^<ENTER> ind 
cr]bqeZo !vol%`@@1  0aiX:  -> of SPATIE?BALK =><-BACKCEVori9gl)TABb	|#EHIFT+%%ܺ2+Kq= ykp=tx#B~fouta64k p It wf_ge15 F0M0reqatijzasFen. AcoZ01b`ea0.i1ZCu  we   Netgvoe are0#`FMPNp diVbas`e3
 t n0 notebook-pc/P @.istNOQwbep*igdooh2L	MЛaft NmpALyp6rocwessnel3Q pp OmPЂP}e (L1/L2`Zapac?i Vm{aROM @ -s!fS<mmx E  Hebvrgav_0ideokp&p;b bpM	$m	ra1b2rd3e4ahiQsgI t}
.jne C(_bB(ЉwMdzQ%)
  `D#^Secuib E.aw~~$Ftb%)҆2!dHU2L53Hac-0-*1Tho_adresrlafwisnd pao=LTop: zPt<tks e'ge gt PSBbeЉf  s d1 A:og-  /ޖ"x0zbLe6`.NoffaG1 Y\f_dقڀD`ѱ

boචgAt
wOC'We nu, duъ"
wil?@oݩ""aA?Ox
Z\l"+1 (b),2 (U0Y )  Аpqwrpn (min.): 30aee&p:L0%Qtoo 4;q{ho:5broA):]eeqx/nb!$32#kvo-IPsEI"
 2"qk:J S.M.A.R.T.-af`@APP@udh "/Blo!  A I-7B4kXq crlpSX8
 Vr!a1& is bBsAYoCf#/k, zTm]lijk0UKQߛ zoik` dvors:ka?0QH fQeksKPu_gzet,r ,lorZ@¶(ZOb$ usw!b sqwYfur9ohoud'Hi` ! AQ`R`T`R&BѴ񡘾 vuaYߐHP Pr@ctTools(*%/ k  p?g`spp`b TWmE #M"g$rgdΠ9b   ~CerX#W>,.o(h( o( S("7'EAJb"f k otraakP)5w sXbtK;?ݳ ]Qŉ p1׀frapd  Parˊ Flash-mal<Cd-r@WħHNǉHoofdXVGs`
jE  Uq13xa^ia DQLc7A<i!Pzow*HOOFD-BSGEBRUIKERS8_L1  p $an=	 SsC  cҦwacJ#!\ fy0k#0hcomp s%ksMq~[p%t P bc(qA. `Y0ppq8_{!AutomKc%5:)z2U@Ҁr<zdZ==}88 O!V)?!2:NP O!= !. Mo0Xe@MjoOtD, `  CjrS8`ΠRU nt@ `Pe@	M/ # hui,UPd`wwas to/!k wgea. pwWanvloeC7YkPjY0TsPn`pZUt0rAra=8	R00 torH/) bget. Oo
 s @vb뎸. OmRun
1]A&`3fe*& golp q. A_Ա_õ,ubhA dc3䥼p3rukx3AESC- ( A90Ri r4'k'tyUbkn F10`T*Z lutb r3`V4  1Nel@@g MultiBayBjVzkd@\~!base (gks)re > USB-Մ cb+zp-f" Er@we$鱠V V@{Zes >Z῀>Aa8N Fn/Ctrl `Owiss/`ߧ.SStaMcW3M?ijsappOu e 0  n ӫ$l Bij V o-QPFA/Ah0d`dition  GTvgp<uq=Vilat0xE?b疩p neVd$Radioj WLAN-aoeBluKeth/oG`rgie@1¡qYIQ[,(	bA)܏f`Et`0 1
2
3fTozR/-OMom@023 UUratcu!G<< 4us     SaGekali@!тOAK"2
NQc ualP\J OOO EW OOO[B['OO&O H{apA 
O$O"Lpier-MUE-$J$OC$ Pn+OO+O  [jp 1O : Bor. % ]A@/&p[лd2knte~l/{	3	#Ʉ
fo@hl/)* Jt  ;>.C,$ VęçaդXadap Fpr(0sec.)Cpop-up bij sno <F12 )Kbb@ cuorsorytuyEasyPo-muisG Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe Ɋւa\܂tsfBNɕ  ݒOCOFϕĂGg&f 
H
gɁ  Hoד 
ɖE	XɿI  `AO̏ԂW܃@ea ÂL(=eA8`LCǗ҃pj h/dCo'o "X yf@\̗L/lE%ID&ID:_ h (uN XBSA$͍ݜeX} 0g J 23T|OH, v".eI*"%ɀ;FX
 󖾠>f
cA>oAe̒?  I(f:nA%e> rpCeBIvCǇ"F@ `F  /H D%Jc9J; ڍc R5BM NP$ߛA%EL@U`UO tB!#sNu%.37($b74L[BRׂ af=!A/Esc=C@bsAS6?0=͂
  aRAg)xgjq5\ 3Ogp] jk?ڂ %iA@gp>[Ex]  egȉ#wA1̀r_->Epy`tOo[ = ET  <-SG[BackSpace] a%[Tab!AG#[Shift]+0eF2!,,,10nmF/[%  !CG[  t@DBCł}@BDr熂p o 01 yNF`+@~3a
ɂACOk ~Kvժ@&eb rO x1X
Mp!mQ^0fGdMEU		Ȃ2e׳`	{уɰޯ   ۾ ̽ xïݸ  ށiL1/L2"`OM OMFرԍ  ޵ ޼ޮ  ׂްޯ 㰽ir G#2.3N4h	 pşch3(Â)F(E-3N4(JPkvJ _!ndFw Xco&pF?$qv sxП6!;LsV+WalkF0s?A-1tB/Z hѢp^`OD4x:2BtςƁACɩ %C颴 ?ĎDa/ŗpg쐬AFA:݉ b#G}v!h F F SPl	NXxWM֎~@Y qZos/9@y(c  ~ցB=	H #ċ gOo g'`,گ>Я1iNp`2iS3p.M.A.R.T \zsԁij: 30Bײ>v0% bj!c OK z3 eB~ f{:@	{em`QX1kT {ǂݨUעfIFIDP.Ba "R`R AFfV!'/i `¢k@ΡdAJg(B<(a ͤDAJhvٓB"߼ /  ߽@{R@r9RVdNJǂ̂P*p4u`@aUC	 !]ţ"^
YӍcxei!ݡ£	羂 É?` a7df!f
`?"dHP ProtectToolsܡh}lWŒǉT Bq#j,.qנB4УMmNuJ<"T h80' k{-E`O'OH&J8-.))Tی삪'D<D%蕴` g4`dt!(!ċNb8'v"Q ԊOD GPuA=0V @QlA [_CD-Pu3X(^ !} K^ S:`"AzUK^ᑀ %i E_$C0vb@{ y`9`$	5 ;?`,WAT<@fO."i	0	iBlpH	͎T spR@sѿ痣JS{#ۊqH@P!H/)Ɛ!eFybYG q> ߐ Y0ۏ؊ԓ "łb͗L kł粗`Ak)/)%)AxpȦ WZq.w"*FD`nDHa(o(f}@#$'m@\@Z ( ?IO)F) u
χ((?(9(ÞgDu$x#<43ɑ`檇ƈ|M3 f=ɉeN~^@&A)F1jj 8cB  BgBB}AӑO"O cĪ(2ef̯攌8d툐q]l@ӔCநaUC"1/g'y}EE[Esc] @ȍ~elAիmT.?DriveLock }t[F10B MS  y_ԝ7`E: ESxtkGb~@œO xXioiEcUSB Xp H Zip1Ԗ 2b 3 4"567jB8910r Fn/Ctrl~%̐ؑ ǯ@{`\p (USA)> `|*]B#fo+X
KV&Ws
v C\g͍  }]ZJ _ =rIo@⬤ cW>o%wACY Oڑ͏ɛ̧pa峀lNi!LANj%MdBluetoot/cj!`ߓd p
2Intel  Execution D?isable- $++1)2)+3+odhEthernetX 12t3 g!q
AOKO3O >H!O Dj' WID 4bcK AM  !   g ?ϰ` f R?k ejZ o  \(%*nP/h/!p!!MEU t$) ozoooD2s!5bv1 : [d . % ]xO<
2 !gOv3	Ā	)J*   5`$>s'pmj&vSpeedStep@ technology
u'"( 	_Ħ Ӱ # px(bs) 3F12Qԁiby a ^ `PbZB1  @d                                                                                                                                                                                                                                                           ` a b c d e f gt" L  :    *     	 
 F   `  
  x   B                D         ʦ     / 0   3 4  5 6   ( ) 4  , -   * +   mp
 N % @.   mWm $ + U1 8>E uK RXmU `@E<BoB<U> FبE0`8l v x|v||p0p7c g  c 0A   = ~ 
=$$$<   DD_D  Q O aƄe  i  o䔕 u  y[ $n%ApO E%0IC&{O p   U `   Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:?5-_V<>1( ) +)#/!'?
ߨ({[)|+}][{]}_'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'߇(

C$: |  s+'()+'*&803&b

OO
\()| O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      g|mA  m^2@  .@  bmƨ@ ED @n.+mL@ŀ@ I mp  U?q@TrArBrECsDsOuFTueGuHTvP Ja 7 
m9 sdm?xcmRa em?gmU@@p < _fm@W{YXt|dU Zt}[}#L  ]~& T W_t`$itVa!
	$
| 	 
`	
 `
`
fabcDdeDfPh(>{&L_@!@    @
 j( 
( 
r l0 |n o : *R  	mő$ $ 9 D՛ VF10 Setup Image_S?ETUP  !D	Sq  ; D	dP" I*v@Jäb"P$ a|`պ 6
P&$`ԩC ؄ ٪TԫTԠ*<Rg!"$Dcz: 'ᴳ4㪴4崵d窴4D8b_ : (m
6  ($))$**$++$,,$--9 -g  0	`
9 
E#8i3jG@ l#!" #" #" 
8K RMNLNOO '8 @
:	 
      /	&WP  b" u   %    N''!(( )O)P*Q*R+S+T,U,V-W-X.3V
md-dh.h1dii2dj3j6dk;kdlIlYdm@mCdnDnJdoEFdpGpHdq5 ajͫmfoq$HrHs6 $[b{U̠{`{|`|U$|`|`}}U{L`}8}B}U. ~X`~tu wx~ʔz{  }H kv 
444(3)]Bx`o2您T$\` U䇧0L'\t ;*
敇d @9 ڠGxTnL*@ 4 : N j@z @L0@ R h  @ @L @ , B V t@( L @Ԁ@@ J j  @ @L$@ 8 \ f p@ @ր L@ 2 L d t@ @L6@ B b  @ƀ
 
@ > `  @
	L.@ R  T  @
LU&@ 2 < H U`@p պ@ҀT@@ . F ^ Ur@ U@ր S@@ X x U @؀S
@@ X x  @؀A}@L"@ U: N ` t@U @M @ V Up  @ƀM@!@ 4 R `@z @Ȅ @@ 8 \  @  L@ , @ b ~@Ī @j @@+@  ( @ h@ @,@@ n j  @@&@ X j | @ @(@ ` j  @ @@  ( 6 J@Vbp |@ @-@ \ j  @6@ B n  @&LUT@    M@8@ t բ  @T/@ p   M@ @ l U  @5  "@ U* > \ z@U @U @U؀ @5  ;@ U $ * D@UXt| @U @U @U؀ @J @@ V j z @ @!S@ B Z r @ؚ @"P@ P ~  @$# U@ z j  @ $X@ v   @%R@ r j  @&Y@ F h  J@AB@S'@=@ 2 D V A1v @J @ U@ -D(   $:* @@JZ h`lr @  )Td@ T   5@*W@ UD h | @U @S
+h@ B r U @S,]@ t   @
-T@P@ H X  U@ 5@.P@ U2 B ` @U @S&/ w@ : t ծ @0Tj@    1@t@ A	  @ 2j@   3 e@ \T  @U @S
4>@ ( > UN p@ @5Tw@ > X n U@ @hhhhA6 @ : T h @ʀ "7T@@ J ~  5@܀ 8 @ < %n @j 9 |R@ H  t @ h:<@ b   @; @ . ^ ~ @ @< @    $@.Lj @J=@ t 5  >@ Uv   @?@ hB ^@  @@ n  j @A @ @ X r @ @B @ L t  @C@ r   
Dy@ x   E@Q@ j   F@ x   G@ ~   H@ x j  @I@R@ d hp @U @SJ@@ B R U` r@vzU~ @U @U @ƀM K@ < IF 
hT hth@h j L @ 	hH@thj @Mp@ n   @N@ ~   >O@@   2P@   "Q @   R@n@   S @ j   T ª@ \   2@ABU @ @ P | hA1U @bh@hh$VhJ
hD@Vh\@dv @ @Ꚁ@ &W@@ ` |  @ꚀX @ L r  @j YT@ B b v@՞ ZT@@ T ` t U@ S[ @ N X ^ l @؀\@ P j z @К @ ]@ X   @즀^@ ^ p  @_@@ j  ² @`  2 B@^v @ @a@ @ V j |@ @ހb @ hhhPA&@HUb| @E "c @ d   @ڀUd%6 N b Ur@ @5 e@ 0 D `@ @&f @ ( U8 N@U @ހ @h g @ F |  @h@@ h  Ц  i@ 0 T Ѐ@֚@j@ F z  @ Ik@ , : UH@Zft U@ M@
l@ N Ur  @րMm@@ j Ֆ  @nT@%@ r   So@ J z 5 @p=@ `    qT@@ B j  5@r@+@ %J l v@U @ԀMs @ * U8 D L@RUZb h@pUx @Rh @ʀM t@@ & 
0F@NT l @5u@ J	<@Xt U@ M@
v@ 6 UL p @S&w@   S.x @   S8y@0@   S6z @   >{ @  |T@:@ j @  վ  @}@7@ ABZ l ~
@B1~@:@ H hlDhЎRЦ@h @ڀޚ 5@ @ R r @ @ P Z p @ @ G@ H t  @    @I@ ^ ~J  @hM 9@ D Ub v @U @M^@ V Ut  @@ U΀   @S @ X x Ք @T M@ H n  h  )@   hi@@@ $ 8 P fT@ht @մ @ Td@ 0 H ^ Ux@ %@h7@ hhhhA@8N\ r@ 4@"
 s@ UL r  @Ȁh %T W@ 6 L p U@  ^@ h, H@n| @Ȁ @{@ F v  @h@T hȀ S&w@ h  5 @R@ Uv   @S h@ @ V U~ @5 @@ Ul   @5@@ & 8 J h^l| @К(@ ~   @q@ X ~  @ @ Z   @@@ t j  @($@     @ Z ~ j @@V@ 0 > R n@~ @ j h" hh2@JP ^J@ph
Фм@d *@ ^ p  բ  T@ @ ^ | U@ S  @ l  5 @  @ Ո   T@ x   S@y@ p  M @ l 5   @ UD Z  @
h*J :@Z	hx% hhbhDhh* 4 h>^j r@j @ @ ^   ֚@ @ @ h ~ @j  @J@ d | @5@@ UP v  @5̀@@ UF ^  @ހ T@ 6 J l U@ S@ 8 \ Uj p@M @N@ T U|  @S@ < ` ՠ @"T @ z   @ . H b @ @@@ ^ ~  @ހ@ N t j @@ > hhhATTr լ@ʀT@ N v  ո@րT@ @ r  5@ @ UF h  @վ T@ 4 F Z Up@ S@@ Z t U  S@ . @ U\ h@pxU҂@e Ɓ" ˪@ v   @4@  Z  8 P Є @@@ h   @@`@ 8 P b |@j @ ު@ d   @" @  j  @ת@ v   @.@    @ ^   @<Ā@    @@ ` x  @Lƀ@ 2 UP t @Ҁ5 @@ U6 > F N@UV^d l@Ut| @U @M@@ . *
h>T ^@Щl Ј Κ@$@;@ dT 	Ј M@ʀ@ V Uz  @ހ?@ hrj  @̀@ l   @ `  ʚ @.@@ j   "π@    @@@ < ^R ~ AB @A1S H@ * P "dhhDhh @Ҁ T@  8 \ Up@ M@ ?@ ^ Ux  @Ā5  @ UR l  @eA@@ 8 d  j@ Ҁ  "@@ D b  j@ƀ @T@ h8 J X@Uz @h4 NR ` h5 @ @ U> f  @5Ѐ@ UT x  @M$ۀ@ t E  hM  @ 0 UJ ^ j@zU @S@ J h U @΀S@@ d   @hhhPހS @ R l U @M  @ T Up  @̀M  @ d  A%@  R@  U. H `@rU @S @ N | U @̀S@@ T j Ux @U @ @WLB@ h  5 @F@ Uh   @ @^@ 8 HT hp @5{@ U~   @6@MT @ H ^ h Uv@ S@@ p  5 @*v@ |   T]@ t   M@@@ T ~  @T}@ \   M@*@ ~ 5  @ Ub   @jh  *@ H t  h)h @h h @z@ hU$ . <@\Ut @*
и @Й  @ D z  @Lf@ J Uv  @ڀM#@ f U  @8 d j @.@    @    ?@ v    #@ Z z  @>@ ABUV j @@A1hʀ& hБXDhp@h@J@ѐ @ȪU @ԀS@@ 8 L Ul ~@M @ J Uh  @5 @ B ^ p Ж  \ @ H ` | @Ȁ @\>@ P x  @ @\(@ @ b | @ @\<@ P n  @ր(\N@ x   @
\D@ ~  z @\U& 2 D X@Ul @Ā W\@ < ` Uv @5 @@@ U8 P h @hhhhA @	\$*@ > X v "U @S 
@ > Z %~ @%@ \U@ $ @ Z Un @ն W\,@ H d U @ @
\UJ@ ` p ~ U@ U@Ҁ M@@ r Ր  @T"@ j   5@$"@ f z Рj @$ @    @+@ ( > L `@| @  '@ n   @\:@ ^ t j @6@ r   @"\B@ v    \.@ Z   @@ /@   (@ b r  @ \U&@ 4 L n Ր@RJT@@̀ @ T6@   ( UB@NTd U|@ @
؀L h5 JH@\vR @h S 8@ \  լ @ T M@ p   -@BN݀ 5  
  *@ 5  !F@   "\V@   # 5@   $Ԁ@    %T :@ X   @&A&T@@"2D ThA1,@:Z ВhмhDh@' J@   0 `:@UT^f |@՜ (T -@ \   M@)#@ \ Ux  @_*\6@ D U` x @M+ @ B Ul  @S,f@ F ` U @ʀS- H@ H P MX }՞ @܀.W\*@ J h U @ƀM /m@ r բ  @0T@N@ T ~  5@$1F@ 5  2 r@ h   j 3 f@ 2 J \ f@r j@ 4@A@ d   @5 v@ L p  @ hhhA5Ѐ
6@ U4 H ` x@" @7 _@ `  j @8`@ n   Z@9 8 U` ~@ $@0:T+@ < T p U@ M@$; @ l U|  @ȀU @ @"<T@    M@,=n@  M > @ t Վ  @?@'@ f |@@ @ j   A@u@ , < R `@rp њ@ 6Bp@    *C@  ̚  (D@L@ j   E@ |   F b@ `   @G@|@ |j   (H k@    I f@ X  T  SJ @ f   @j @K@   ( 2@<D^ f@p~ j@ Lh@&6hL@j @MhU> d  @M
Nu@ B U^ | @5 O@ f   "P@   QT@    S8R@   S"S @   ST@    @U@^@ R p AB@ QV n@A1@ L %b@Ў@hЮDhj @W~5 0 4@UVt @5ʀX@ U`   @5ހ$Y@ U` v  @Ā ZT@ < \ r ՚@[T@ J T j U@ S\@ T ^ Uf x@5 @ ]@ UH d ~ @U @S
^r@ ^  Ր @_T@ J n  5@Ԁ`@ ~   $aT@    U@ʀ Sb @ ( 2 U@ Z@jU @Sc|@ T t U @ԀSd @ N b hhhAx @ e@ N ~  @ր"f@@ d |  @Qg@ ` r U@ M h@@ F V hh@ @i @ L l  @Ā
j@@ , H R Z@fpLt@|j @kĪ@ h   @ l @    A@g$m@ hh ~@j 0n@Ԫ@    o@ & 4 L Z@hz @p @ \   @q@@ xj    r @ d   @(s @    t@ xj   u@ x   v@
@ z   @w@ v4 h ՠ @x^@L 0 UD R@X`SiflUt |@U @Z @ Py$@ 
2hL hIZrh 5@z@ L ` t@ @{ @ N n  @|vLJ   } @   (~ @   <@ Ħ 
 @  ئ @4@    @ N t  @ҀLAB@ < EP  A1 @h
,DhDfLpR@~ @U A )@ B b  @̀=@ 4 X h @ @ހV< \ Un @ B@ `ZWL4 L h@U @L  , < X@j ̪@A\ :T@ & P t@՜ T @ j   M@.@ l ՜  @4@ r _  @ @ 4 @ L d@tD @Āܚ ]@ > Z r @|AaL@b fhhhA A ހ =@ 8 R hJ ~@" 5@ X@ UV b | @%  T ^@ : ^ r@U @Ҁi@@{@ P l  @ f@p@ v ^ l@j<@If  S k@ H p Ֆ @
T@ d   i@hhU0 H j@xզ @(T@ X f t U@ U@ր M@ @ f U  @Sf@ T d Ռ @
Tq@ b   M@v@ H Ux  @*C^  Ԧ @ X   @I@ X d Ur@ @Ai RJL
@   Rs@ b .6> F@NVn z@ @4yK@ L
hI@hV, \ ~ @hК @ @ P b  @j @ X v  Φ@@    * @   
@ ~j   (@j@   @J@ |   @@@ @ VJ v @AB @TA18 D ^@Њ@hЬ(Dh@*@ , @ b |@j  @ r   j@܀@@ D R l @ @ @ h j  @@ 2 B d j@Ȁ @ B N T d@r j@Ѐc@ J h x @ @& @ d   @@ j z j @(@    4@5@ U( B \ r@U @M @ : UR j @5 @ UL h  @hhhШA @ > Z xJ @" M@@ P Un  @Ȁ% 7@ H h ~  j&R@ V hj @Ȁ 
T@ J \ n U~@ S@ : V ` j@nhr v@~ @@ r   @* @   2 @ +@ UX f v @5
 @ Ul   @S@@ . > P b@v6 @ @ N x j @( @    @ x  ئ ƀ@ b j  @@Ԫ@ ~    Ȁ@   Ҧ @  j  @
@ J Z rWLl U@Ҁ 5@@@ U  $ *@U2:@iB@U\ht @U @)
h̀n@ ( h>v@ @h@Ȁ|@@ !L^ U~ @S @ B ` U~ @ƀS@@ d  ղ @&T=@ p   M@@@ X U  @SҀ@ t  5 @ӀX@ r AB @D hA1UkL @h hhPDh}l@VVL@ @Ȣƪ @܀?@ P l  @8 P@    @؀
@@ < T nJ @Ā S@h@ @ X Ut @ @T @ d   U@ S
@ N l U @M 5@ 2 UB J p@դ @T@ P x  M@@7@ . UJ v @ހS@ D N Uh r@zU @U @ހM @ > UP b t@U @Ԁ5 
|@ 2 F hhhШAZr @ F@a@ "l Ք @Tc@ @ h  i@%C%$ B %^@T% @S 6@ , B UZ @ @@ T @ > l  U@ U@ SX@   U: ^@ @.`j   @ B l  j@ @y@ 0 X l j@Ȁ& v@ h x  @ @@ * p  @@@ Ѐ T @    S0@   M @@ l jA @4@ n  AJ e@ p 5  @ Մ    T @  $ U<@X~ в @   i@    @&8D L@Xt* @
Е @hh. Z t @j @F@ b x  j@̀@R@ X x  @ހ T@ d   @@@ p  ʚ @$@ |j   @@ \   ښ@@ P* h  @ABU @@@ A1F LJ d@А@hаDh @@s@ ?$PnPm/ /           
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй _s# hNfP u	fX@  h f`ZY[Xg&ۅF ;9   Ã tfPfS
u	p  af[f}XRg&u-g&
pAgf&A"fU  UfA<?vg&ƳU9g&PESWVfW&O*f%Ug&D= $ <vD# D| u:tc:'_^
QRfU

}0tgZR>tKttE$fu
u@t0t	dp=9  f]ZYPSRi uV^rV&usG tu0< 0
zZg'fA$. +"(YwZ "P  u
P! 3 t
 SQV3Ҡuww  :utzffKfw AƜ(Y)9wfP98$Њ;`	P\YXw)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>5A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
tD$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	Vt uff@EFt!hXUgvuN>tO6f뿢t Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% tSA _t# XA	uww>jV&BNSZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@߾)U )FbfDf% ffDg7^Z# j^00f 4sp*2{É6^^nBn@& 7Хi({Pfpsf
  @WXfff:0[3`6'E8q4ж3~U L؇gOS?NYY:YYrZ1q\YZ ЍSpk< w !			;/eE1{`eR#tZV(oQ`Cʕ F%frQfRVuu/(` 1>3>  P 
  5=h䍚+( Q   f3۹ f=bdTt ` 0Q ?x\8ZFfCPO@sw$yyk{s>
p"o
d
\Vu@S1?"5`,QVuZ苆FFVu FQ$Pt$G^f  @swwg?H^D	%ÉD	f:?"-fp<v PfUJf@KfffQ$f6f> f	>fBf0+ff]X t p,̐PԁfY_z0R0Ӄf3 Z`R҃> t5  TA @@!`0ӳ
@AԟGRV&S:f;tff) F#y$Aq$eI sqSf qogfE{>  fù fAB;t~)gf+ C kBPER\4`bJk ӒRRPV  ^ h2 ;uБ; ;b 6P6UXf.0X  &
d & 
 R #  DH ! 
 6o ёd J%p#t@ ,X^d !"}$hB "80)
 . Pg	<
 0$,yL	
 2)Pq P`  (# P4!  	  @
p	 >p 8J8  ) p@: >  * p  %w R R!	R2
X "

 &(xiQ)	(.`+)d )(b+"( D: ,Ȼ2	*z0, LU(($!pU'#	'$	#$	 T*	&
&
"1
q,

F1(AhBFK4CO''A,A
/	
#	&hE$
$
A5
Ip:0(|:!TMt:BJS'y'dQ$> 1#uU#!,)$3+\ +F'Ya:Fq=DA;( G0$G"w\D#GV9/'ANd@CN)$
$Qa!q>Q!Hr>PRBSRAh93e$bNL'UnqM#uYuQl!%Ai
$
$ y(Jcp(dpy+t@
 >\c8Kss'tsv Q:y$y!`!4F;	(D@a䈣!vlxW'QJ#&@$q3$n+$3	8q//  @i@v
 v $a #
 `"9	 w aZ izzzzT
 " /	 !=mKap{ 	 hw Ѐ Sz
zPRfWfg&f_Z1R P Z`ððÁ հQ|  	`@  r\ 55 r q!^B !;P  a`aag_`88@@OQRmRv88 UWRQSPV rw5t ur6ffWRfP0 eXhfZf_P>5u06uaPS@ pu55` 555/~55D[XF f sftf P[YZ_]e È55Q 5 ߠtPt j0fd!u!5! ȃ uddfdԶ  >P6Sd dd)P (55tfUg&t=` T=f]t,>@u%ttt t	tfN tƀߚ)r@ualn)s
 1Qh 6 	MuoFk . u$ 
VێeS t!Mrt ـ? D`*f f0T fffXs "qy#uptLe5 ` 5 uYf3f` fe5CMfWpe*&58fw*fF*2t*܊e&5fX^fY[f`t'!(5 <"  Āu(g&pv5\  t(R\<faSQVWU&t tt   i]_^Y[LS-120ZIP 250PSQRVT:1:2:22PKp
x
~
\5	5bJF<s!hEfP u	fX@  h rg`/;<tV< uWQm:f g&:D= uFfG(s* X!X  gHAZY]f`tu 5Qt555w550 RW1h

	L} tEA /_Z[M-Sys   DiskOnKey 1 #aB u u @  f<x fP f_<"~%|= 2r 0w"1s sU3IH t_ gf&RfQ ff@fPuLst6Lu2r)g&	ug&g&ۍc,f_7 PA	% rLT f<?T7(QRRVTcF5Qo~me}??  0;; t0hIkt3t@ u gu#P-30MAf?LfHPN N 
1fXuײ?jD0 @0B0uA0B0B0G05F6F 	   &3FPqRrco?3W1>#>;!2>
>_Yh|GPnh`p& 4  h*<o +̑SW+ 1s!$?
u$
˄[          Ұ,X @xCiY rTB@!׬m@  i|X  t衭   ` 	bhoddfHff@fomPJf&Cih\ufCi6.f ` ff
@ofP  "@f%-% @@@f  z6fF@f=A&  `  f~AVfJaDf=%t 5t;@3tZ~0tZ}DfX$0g]ʣ8@I8@S~f@ ot@[|P8@"sƑ tDf  f q>@ߡ8@<:@f>@ u ` _D  2ft.?m@P +rfu$@@s11 >@@!R0@'Vr"b"0ܰ f!1VC@f,S	  tX|	*rHZ'	"	0 %9 ufm-%tq+00 P3"  ҂ 	P@|tpa ~'	PX  r?f 
 pQDP؊*<@@6Nf>B@gGf	gOgG]`db>tO"3	0	5
`6@#Du	%&mf6B@f	f <@fIng^g~MW!
*t4h 0		0	 = FFhhJ<t
 &6H5q*pu
 'X*؃ C0H&2H:@&4HqN&h.bL6%@( .@f (f& 42a3uf4@W  bf)+`сawSgff9@u gF9&@u 9.@u
gF9:@tgN<XfF<@zr=БC=@rxiGsVfS'`c(gF'	&@g^. [g"G0ogF V* /e*eP`d&b&g&g&G
ǿG
 d0Gd*PGg&Gg&G
 G 3gon Fp=p5t	f mAkG^ 0\PfV csf0md=f p^fIf!0@&(@&@+(@(*@. 0 2@ < t*@  ;vȉ,@qv  f@
BqygfgG p j,gG
	qGf4u"a ?Hf%fE@( !gG!&2@*@ Gtbk!qf#p,Fcn4 `_OBS'PR7з[fS
f35 !f$fӃ\Qfp#{-  !Siy P,9t] ``U``a`b	`c	0]	0^	  
		 
					 		
 0hfWQf`1Yf_`QD=f5pD=5JD
$>5%
ĈD
6r% >5bAS|NsbJ 6CrI`d
=Q1r7R@|= USBSug&|= t t
U	 	`6Tޒ (6՝ӡ p arQr C0 % P`J`2P>5t QArIt2QfF`AdYrSf1fM^!WA@2KH\
ػe܉\byJ
prA
{x @
`BK!?
0
"{sTpq
aWa'"CS# iD=qp*W.?4f3'`T2'u oZҔ(Z
2(
<_7
_=%t9 R$tRS$2Q	~@ ?O@RP2 3* h > Lu ᠅ T=
XS<(fT= & y#j655 r}fPQtA3`>55pO+` pta^Vu6 5 +.Of.6OOPpYfX`OI|G<5 fa9?,AB3U+*/G/%QfPfph`1x@YfXY"N0\ؐJy?;G7/Osc`:MoDABA<e=S$l=38%rp5Lt 	Mt Lt5D$_
ƈDFዠP!r r
9rY׹ w/p%tFPtt=tT= t2:t+u:u ghNoty(u~(rt{^@L=@t	M=tL=`	tL= Lht)6`oXaPSV 68dtd}ӠrlӾ(68DtD$PؾQJPhӠd^[XSQbJO	8t`g	G	Y[L0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSV      Z *8۝6ܟT!
 ʂ 	b.>  
   UUo      2@ST[PU&U"!$ru
>U *  > X * tUUU>UUuǾ Uİ'PSCrU_$UUUU{ēQ	`Pr$`
3ۊ `U&{VU|V3 UpVSt@t	Vt%[^@pVtU "`UtPd4 uIˀuqES1tUtʀt[^pqq?fU >tuS>V>uzҊ&Vtt(
ߠ_UtZ UUQ[}4@vf]AA`Ft>U{U r1߻~Uw%0r "t6ǈ0EU h66bdhEYuY!) `Q	pXt1~ULh[fV!rV&uUuVzfPSQзVf3fY[ffRUff]3 :0/ZVfZ2F E *  <FuV3t	 Dt<Hut2YtY >Ȁ$u tPaX]}V Y7zV uB<Ft<Tt<et<t<t<Rw*<Ir&V
2@&tZ>V`	Z4<quriVW@ξ HtAQ Zft(PǴ:~Vu 
  gXfCYPqq q9~ w2~VkYⷠ}VDt&|V^8r ۀ>taRw
$_^t0%UV6V Uf? t<CpR<tSQLذ&Y[ـ u
lqpJ@I - n ig8   `  8th
   0  p $	 	 	8 
		
			 				
 

  fWQf04aQY`f D5 5656pswR (5zľ^D
$&5
ĈD
 1=s fg&W|5 EBr`jr  a`\	 		M\`UR		`r]H?\
|5
܉\se7 b]Qoa]0@˧" cc͐Ăr`͏͈-̈́}&p۳_W3
	#׿rgqWt0Y"@ f[`=ʴj(rjd,u6Dq=6_`[`[`pfqgh	 cY`v		xvFX
 T `ȹ !sJ%|=td%"y:ur?rpq!(~rg؀2oQV\L	;t	&PA Ŧr]Ş=^A R\0   0    RrE d    n  A` P 00 3`*  
& Aa %  	%
0 #
ک*!
+ 
3`@q& <a`̋ @ @  
b
	@CF
? ?a	 " d  qa	!? % %@%(
 +3F	
 + (E+(
3$ 4̂ C8$+ (3+-E-(C -0294-  (`(E E3 . c+! 0
 @/9F. 7'GC@< 6A6D
!:7'  "J",A!E?9B@p,3
O<bJ# 
1R S<R"G 3D%M TVaXACJ UK8@'(XAIc  WI 1\(jjkUllEmCopyright (c) 2001 Intel Corporationf`@ f.>@<t<t$<tc<tK<tSCif&Cim sfCi?   uh   uRRfADf380=ISGuђ s
g]Gio!t f6Si	lgftcRa tpt5Hm @u  u u0 ߰#> 2  P f%ᘅ3 
f><@fDt	u)f<@;<@wuf@f?fhhtff"Qtυѣ
0ofs\
B  v@#tyz210~!<ugb


7	u\	Q	'hC/ś_<@Kf6B@	g u%S F8@ s@[%;u!,'f=4R0	ff4	)ffp	Q(f	f'@f[aSfSfQfRfV*sWm15 uBT tApN@76g88fI4g^f3f@70n@7f^fZfYf[fP"Vf~
@f=`Bt"f=Ё &f= 0//f=0ށ 3f=@+=t8_t34 , 't"#
ttfm0 rfFP0fXURf.  fXr  	 QfPufQD8}@M TR2p@(2Of2f0&cBZ{RO>V\3hɚ+( վQ  uf3^fbDf6E  =Z<tatG@]_ToK<u	ŨupWJ$< t<0t$ RHP?ky"PWT%j_uPlAP#,RfWPR;<@r/fc%1f f>ޱ=	f!Effg8uU#>_444
f@[Jf_,,PSt{w&G1=`Q
Yr;f.;Qqt3UufQqmpf|ffm~ fPtP= v	 +v:P,P}@qf́   :@qfDP H 6Lq1|Ã tL;f ǰǋPtPq Q.PqB(
rrf u0`b h,-Ñ)a	rffqp2	_f`f"0~ffROMIfMAGE@;uq Wt#g0 yKPQ (J 2 ofG f_ZYXug&wag&GwG0  "2/t"t:  V   scu'[0i&w zj3
G94g&GGfԣ f}Cf-+Ӹ00pD;gf&   hi쀀1"̘`W, 
`П..`B@ԑ
>t1_a  =	!  !  q  c  " ;;  @nQRVQ ް t t腫tg&ٝ  t&q^pM!(ftg&P3!	u*wwww>w06wsp 茠1	tVP!"h~ Ъ>tp=0$3۰ {%1u> &
'ut?uvueu^F\uMu:dw8FPu)wttfu0= IL^ZXg&8!Pu	g& DtF@sPVS t迩 hN-[^XSRVtW苩^_n5»p1XZbUfI0|菧!H踬ש1]0 * #r-#  /r02 Pwwwwwww{SV.R!tvw詨^mQ Pa1W>wwSRRu<v
w,wuƈwʀ 7tG`Ł@2r )`<Ɓwp4VS	,ޠ2ww:ww/w觻
/	c tȻdȓ
	wXrgo&?tw?}rw&dr!"w
Kr
? JthE	]ۦZ0ctĳw辦=2o(g13
	utPA P$tXp Z#,_&[$$_;ԓR Z}zR~  zP&ab=pZ&&FdR< u12R1RgtXr),u)RG`SQr9R'$8t]܋YѬtr$V簄O㰆HA{r<Fr(!sqtkrp@p{pq9` Pfa8 f܀g'`~_   FFBZ}c~`b j nb PQfWfVâUUn*pwU hX-v  Д' ,Gx .;|t3۰_YXh|%   $nPͺ0 	` 'J04 "`".u2(.| |ӕ0?  gW
sfUgg& suf3Ɋflp̯tfYVfW~cg<t,fUgR r!8tfG^fZPQ!$@a@8trPUvPF X PS"&p ؎[XPSB3a@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                f`8P%,Ⱥ:#%j  t4 %   ;uPX      t(  HXt
 %@  Pé t u>  u   q  tV @ "3p
%tNtGf3ȿ ӿf ff3u@ fgf&fff#f  
f΀w*jB XfafPSQR.a#؁ WӁ~~@t%s	%PQ#Y3#P1a ff
 p uf%fZY[fXC!
he y uof d`u
QnZPk ``!5  t ehEfP u	fX@  h $  Gog0 dt`Kuap(
 ((@"%t
f0h%Q mP,f+f#A#$, 5 q 0f t| (&
 Z-ff`(`+P,3P.uu
?  1-qf0ZYfQPS'4 'T T'hP4}Q R	 p1AR#5  -7'4-K'#*3p'؀5@uR'ttQ@t
1ۊ
')0* )`tx/ a3S$$[C vS3ۀ> tt#t:#tC  [0t<w>t8{t#> u
 
ñ a r `t3C, $.$$կ
&
 r3!ֳ<,*'fP@ &w.$rK 
}
A@fXްʳt
m'3ZWwT
A
 t1-b㋇L$.frz
R[t0
4< t
5:@ `  8$?> u׳tB$ aÉ  H$<

p$0I$}P1J$@q$؃@P_$X$2s3y@s߃i  Y 11F00gp<:u;pu;th=P4;0>4!0!   u0+|K`k:`Dnr:Ȉ@&uK  ?u1 7 &	&.G%0ww
2:rp	F
À
vۡ >̀< z22C{ ATRfWf`t2tEw p  P+Ghhw Q 5^ /}3@} g&G4g&tCf~ft.fA `A pa  u1  dhQ)
  '   ؠtuohP6ai@$ u"4"f_mZhfW b
f_babR
p  ZPQu#4 pyKqVb 
YtR0Ru hH"|	
2
¥.&Yg t#.Y9g' T
.t&*0 0RVhIk?dtDh^DhUq5hr7r2, f^fZf`2 =rb2 <`[VPqT>rhQfa_f`aX
RfVKPf3۰//vѾff0Xf_f!7"߾" h}Qf`/)
4/O
\ׂ "	 	W R"	u/	(	!e&!_!!|!hh5$VwuG	qfºf0& u ?2ʒRt Fo<tP$rf@3dR}tRsfQVWﻹ 0 _^Y}vTf  Dfرfft
t%SKygf5rSQ?
f/  P@[^W0WVhV?Dr=ыt
 `uu	  t@ uʋ^_fQf	:Eb3:EF c6W p 2:> u6 GHt\o ?h3j//T3Ҭ؋h1B^_fZfcj
zXK̈́
>
/2
#
VTk>T2@OHp
Nt.
OrYRbǰ0:I-^T-I/ -ao/ / /  OI-<RwS2.{[ø  аfQh8_ZfY_≐/q)aEf3ɋPw`0X1&G     &W?ft ffBf;Pgfww~rtwRtpff>@hDjp3QgfY tgh!o\mAAP0Y[0U>aPS 2hWh`$u2f[*     ` w   W࣋6&Qf=HIBM&@ u_Ff!1 g.9u
g.RFf0F"Sf= @t1pu  ø PF>Q f a	 pu| a!NuFgf~fVf  t
fP#fffyg̃fY#F$AV f;s	7f
	  fV2~(Ff ) f+s
0	@Nf;sfȶF@	rf@f qg&g&fFfGg`^N &Vf fA=uTA$<ufIg:!
g
@tT	fƹ@f 蓟t=> uv *ۀ>p u0hv^!}_"3Etߍ;1t3tP s Itڜ 芜PX蟚>*p 	,du
bP
` u9 5舠r/<t+^t&Pu
$&כJ.YaP,t"\tq2!t` "G Q !u胛u>&¿t  M 0 &
À>ڰ舝 
8s l  
t V$<
v
ط  ' tǀ>} t $
=ؐ &h?Uߊ$(
d tP{ X!  ^hm܏

]wd`
@

#
P)rÐ- u }&~X }~>~ u
8w} z4

A 0ukbZ L@Rif]fLp\pNf ajf\@y' @/%jPh  >ft	  (7f%ː~`PfW~aDGX<t<t<-PS$<wR .R 
S   6   r` a  m!	@  [ &%fmmmmkfBf&kfu+ %k0{t  j`bff3fr  fPvf<`)ɱ|<w   a fXff
`}
E
G	 I  ?Pĳ6
P XuiBD[bS!m uli B [ED2P >X	@2~P2@Cˀa		$

u
<X[X )a؀a
2t P@<KrKNPRf Z` .Ϡf  BZ s  ""
ZPԽpD`S좳   Jq vJúQ R (J
PBX
	SRذ4ZQSW 7L_[4!!!!!!"!/ / i 3;CKT^|3=GQ[f h S[z<ENWa~r8<AFJc| 
"à@ PP q*ظa_Ypp,غ:%  3` U@ˋCN  eQѺSW3P633ª30  
@|f rff"ZUfFn2FR>'NT!t"ffvfXfD X ѼfpfufT_0f M U"  M00 F@ +fqPFT  Hl
 
S1Hh JPH-H-cH-Ρ   ЇҞ$% o!m 	
% &GR ΐF,%H-Z'M, a'vv! V$`$t$j$~$m,'w^ |' 3
$%  [0.>`(Jy  hU M (JXQWк
ٹٴy ٴ{ӻ_}+z ڴ|!N~IðLhᰀ薰w$ tpSu%th/u~Cr>a> u,@
	%@u3
 s
HD% "߃ b~=a`Po
'aF`
 O0 y+  К &of`D_R t5fBJ&&f- fa}CTNI fۻG f(ofR3  0`'>+P`'`'2_s 2{cۼUV<22 P`X ]$z poG'[.@@>="pA^]{2 	V?s>(S rs.((-r.tЉ葅r7u_hV0>Ou5h472f.f7f.q ?_hż?d; ;  r. b = ohǪu@ h|).x)`/
03!40+t
3NO+t3GNO UN)))N)쪺zP aT)SR)``𢨢$fӃ@[2QXffXfX*fXahIkhuo Q 5 [ (<uuu&gq q  lK[h#j_e$P0:X! h35^hE(LL	MPA6D0eN/J7qJSvP+F X PSÑ&+&+&+[XPS
+ࡺ++O9H587L,Np&L,L,$!M_~$NPNS8rdd rS<dr
?d2t۰7i֣x pԟLpj{St蘩P0ԸpC-{X菫P p & { r&^Q7f tw+ P                                                                                                                                                                                                                                                                                                @      /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                !$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( ((     ښ U   ς  g `g ; h }  Za  ;tp    / 7h ߅ U8 
S          P        (  %X%H_&                                                                                     `*} ` Pz*Q@ U   @U 	@U
 
@UP X@UYhi j@Uklm n@eo { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`hfPu	fX@  h  fUf&paf&>۲` 6a  !X[ &SP`\@ /'aߝ&&@r
f3fgf }f3fh   _@p h &ïީf`f1fffeWf   % ŀ-ff0M00!0)ffXf9ffaf 
  fUi@] 0 m uq  ,f5q f~^PeP Q   ͪAp  A` e׃fama  !6>eуp Ń ՃPك"` pew T	
e} fe&:` b "jeɃffefAffgd:ugdfepf3 ~gCTʰ "8fF3ۊde3 
tdg	  p)O @ 
pezu{xu.G_RT=C u:/
'
%&bfgfd.S` [WP9A`XP&EX% &E_YǨ dooooǸoc e֏%?}SΔf`PHkIa  6&P&`WX 23v
``.0Sr&&faõr!Br  Pq X
䏀  Pf hE3\ǰ Xga20u쨀t݁	<u <u õr$Rr x|&&U2qrr]rN a`z7da(Svx^Q`es"" QYa\P  r&&0߃` Ob 
y' P"S""F"&o&2a 1bR ~ ZQRr3'H2't2ZY`2ٵ/t"5߀ tt(TZYa~r#S-EnR-Y03!pٸ q4 AY f & &EZP 2 &rr8t32估~.0B?O h?,.1tGS/؀1?Eh[&M.22t{J$dF0K#h ǿ5 ƿW< t -Ƌ4fRh^2hUq Q 5ޠ hr<fZrj  pvw@5 pS
, #!	A	2h#j
%00`P ?0S׿%-  Da`6(    pM aV魆ī^`W  3 _r- `+˸ nfDED`b;Հ B@<Be O B<`<2rruO0W2&*G_YS	 7&*,u&}Zu&E__[DAP`QFگ>  0 2ۃ<OtY	B/<tmH¡7[77_rPBBLѯ: r1 r,q h/$d0SQk
pqlat)u$<Pt+fKuҴhQpB`UY[Qn @qj"yjuOBAuYoof0P	VPo^W mQfR h3Ik?tD=F==rN|UtGVR4^t1Vh_5f^Df`  Da   ; Z x     0Nm1=$
Pdu	q 42Xҏ	 dm H=ȃI+ذJ$2ȉT-' %.7SQRfRBP' w	.Z0"9a  8 )a*$t2+`` *0hVtÓh rEd/(#3/J+(b\*f(fYïʥRh>}ihQlfPSf>QP?H_u(DЇ/ fP  [fX-r(qQP-roSfP>fVfWp(>f1t P tf0Z f@ f  f 5fff!52g&g
fKffRg` gwre h՟6r  VhݨZ,
-f_f^fZfYf[ r  sRfbXPSfRj07W6uLt;wEf6fQHf8 r/f־g&bP Bfg&rfN`b0oZ[XfWKu
 f   酀> Àff`g@? t]ǀ t
t@  f?t
 :  
@(Y! _ 0f` `; 6frv`gGwf3 f[PfcfPr:p> ff0;w!fVg&f^ufF=tf!Q. $pft Qg'&$9R<&m<f=ATADtlf q:&Ǉ  p s  S3a  o͍b ō1݋ D 0臍3ɊFj qUFWP3J XU .>J   ub >u `	`	v=p$l0{ˌ$ՌC_AR?J0(lvfSIMWuUf, ^f@ENrdfOfAf;w(hӅ/FI"Q;[ap qQ08?SECU7fuBflS@:AR@P_WɠSXfGؐu(AE_-蛊$81B0]=c q Gt+S_
 pTNT<tT/@t>!hP޿
u^ 
lPlf@ | ͡ff
 w	ßJl& t
fWk&f_r2jf$g&  Eg'&	2tWVip^fGtt2t~tyf  { f`w|'pA,u(0v xz^ @ u^uBO`x_ rFf;r>`L: t, f    ur%)r}QY9	 ]sh   t%ht`A
A!:0.2 r&q
"

Tr@ZSV!rP#j   t
ff;t;0
 + t UD@@D
@Ò@00/ϧrwp		P? u ?ff!` B
ffяfLp 


grϧS@~
!Х3Ұ"t3 v %`h
UGܡ밣V1
< t601}2:u"FIhqr()PD01' E-fY&7@ wY.	A_S 
fUfp>t	--


f+Рf<
B#f]^P)x""  ,gbXv0? An@u`$fB %  
9@_#`_#_#Mfvfrg,g% #g&; hpoAP \ܓ>afXtX2U yø8	qѸwpcQB 	 b aTp~- C  zPJ	B
WC T
كIڄD#R
N~ffff+fMf-Efffq PAMSuff>r^ [HwSz@P` X>V fn|	! ~f#bAP`iWV6rY ⫁E6P < u蟪22rf mfh6^`Y`
hIkLtAt.cdorB!ؾ@
EXu@
Pe
`_af߾(pc"{a``j uL$<tD"ЎQbr&=t&} tV" &GF^YՃ"
\~ؾT 	 hy4V
!
"sr



Zr
P 
9h hy@ >Wl>  ag"X9P~̀R ĺZ"R0>SR0 t@Z[XV(*S+r[ ం0PQ> uι c r\d`Y0PSCtC>r-t`w0:0 r uҊ1 r
-`u`d Y	P rdItf s`sQR cSRoNr&pr!ww3҆r r	ZPuRcr}p}U]
UIZ{PQq	s
d Sr	rs!V>RPнp d?tgP{uwRQ R  }h`^kC Z .}Pa P " Y0 `2  p",u PQP hsE+DR**Z@uhSذ* o rQ(`(  PS  I 0SQ R(0R1 *122ßXDC	I 4~P>b8S t33>06J*b0.R
t#4 c ttPoxQ}+3QBa^_!#3DG<u
tEV 4^wW _ O"  !(@ R	
R
q0P#H	
gg&/ܱ1q;/-r s;dR(X 蕐J2` RVа$rN ;rCr<,	r32;t  rr;wҀ ts^ZW
   0u
˾   
u N f! uf _2 J332[2t @ 0 	rn
$	"
ſu Ƌ߱d;sRZ3QFqF2t
2t	u˸
S_
_.0.{..Ԡ s  r.Y.2YDذVPCwe.% 	ر
	
fPoWfV3  Zt-s[]pfǣ  f^_Y[ t.fUf.6f]f]** End SetActiveDisplays: \ PwR$nt5 Q)㋗߸d_@-;t  _um DZvB7Ӹg $tupZQ2tN
͋كYp[  u@t[dP< t ~ǊO
 p
R 1p93t0	p $~ D ppbbUg
10  P_ᶰ0tРR	gs9oSiPP;eiP$0 diUiċ؀ TiXLi?X2i𖯋+*%iЙhPahaPtQhP ÀhXhՠ h~QRPSa[X3o`Ga B"cu
vrQ j ܯdK f`KOu$Njr
u.2*q	,rp$p&` E?&]W@ _ffa.A4t
10rp?3??qSQ/"SPfWU]yfaW_ð Qc !  rH rtp	fSfQWBUftu UAC_fYfq@f`f>f ;0Юf RFfa2k_<_Pfgf2gЀlutQ SPߊ܀Q$?~X	?fAWpѰ W6XWqHȎt/O  3  v ؍`$at`ZON@a<@C OO_ B  6i*gu$$t$
!$$qh1Oŭs/`9t4>0t,7z uXa~    Pj `   Vs D ` d h            a @  b  ` H΀X \  HTq3L4 ]50@
@
/;                  a         14    4XYhijklmno 	
}
 p                 K ,89:4NNOP ;OfhX#lW  NLO #gf&fߐ fPf0@g&OZ	(pvA r㲓Pf]sfRVW f Q  !Q  A!!f%Qf3f3f.2fffu_^fZvf"Q ء f' WQ
?f0ǐ˚P3XPSVWfQs: ؾ	Lي Ru ufufpv @uf  fY_^[XQfǺff
ffؽ   f fo  < D4q'sf_Y"OB bR5 ?   4 <} g < 2<
 ꀤ c                                                               UPRPRVFZX0RR30ZO                              u߸ Ƌh3  f` t[)t$5)p$ŪH)r쪺  .<t
../ NA Nfa@SwRV fprtU./tA
 NUNhϚ4^Z4 hh_À> t}%Bf#s`fQWY_fjY]?LàPRBZB䒿3 $ `%>&k%	 
  3  t!  { ! @fu#2h24ҡtRW0_r \迈ÐR8fZR0fPq&T ffX@ w!+q+
 fh` oE iE cE!]E0WE1QE2KE EE?EaP ° 37!⼹&?t"g&Gbg&Gbu ߠ u   % ;
u#` `!!,7j * :~ , 22R8ĺZP X,a%π*A 34 T `g& DA4 d+
 <`/1#;`1h2ڏv`tҿ1> f  %  
 0p!P!q  fp
 `0XX! Kf`aff%P@ŐgffP +
 `C ? fA"a<w'> u##$<w	#f<u6V> t= (u7 u1)R*<t&Tt!uc^r Pr	B. : XNtZgtK*^r3g&GȻ s0-GQ$
觮-G!AO  2zAPMt"G"3rMttX	
   VȾK 8t"8tr&5^WSQ!^Y[t,&
u>ut
$jsE ?t> u.Q"t$	&
+sD W
tt0]f=	> `\
q\@$`tX0/KJWI`n_uQ3;tC P  @L< t &$  
`} uS>^ 
	 >t Pt00P0T'uTg *r$@, 萿t>1u
 I胿dA  (r"~/Ut pZJ]SQPX(tV
r@.4[GIKtB0T0.r/x/q6Jt_6tP ?yrB豰S3薓`s`Qu%
;u "DK6͹ |ZE6A$Itzu Yطc-tb;sW;sQaXu	Nu u"
?u"
23XZ1 ] à]Ӣ1t/ *L1)P16t
XSfW0`
ItpD_8؊f_[lωD-fsg]  r&
φH-# fQsfS|hQeϔ1 fplطf# uOf3\f?   t|sx#%9tf!! ht1fuf0 t0if.f@Ff0mf[fY! (6Վ՞֜Ȁ 1guCfoW Ey u8  *Qt R t	=5f0 f_À 
n ø  <Zu@?^HrnH@ /<~G0@ hwi Q 5 f `aP IfpaL$
	 `юckt(*f@
@W劐PƇT!ё Đ`;    _údP7 u"Au_P ~  tA 	3Vf@ @
 L#bG,E9o`p %0 &!#ӀBd!1lQ~-f#@%31փ8ְ$B' f03Q'
f~S	 ܐ'١'p
f1?fs#!=qfYWfĳ & ìS؛ׅ!^pfVp#t6T %f& ffP]t33u^ PfpqSR3һX3t@{s7rSQA` h` 
 [* 4Ƒ !R4'T0	bpÖ*&s$b
 P1T؃2沱1B0`RfZ,.028p  ?l+,mܹܧiޫq)n&6Z:`f*Q5|)@nݿvW._⏗K;L݂ܪܛ`ȱʀEPt  !̃&׬Ru hx  
| umQm YCt P9fߣfXP:f cߣf l P̓`~a  r ` 
aa|!tsٿٻz 33j#_IB@S3g!g-ff<f
 
# f RVoT%\hT`Yn,0@k  ek Bk @2˱Xsf28f- PthVLdBJ^UQ = u5
kH= i= ,Q7` H\7!CV8[  9t >3`EA`\ `R]"PV Q   ,A048 N18@p\#qW`5 A  Fs@#ht_!p{3 Pf4qIY UN[VfϦ@2 QL7t2 t,Nf%P _$P!Pc4Rc'SS'1'U gZ~a&'`,6   2ki1~` غ   nBnnntnJFn aS [ À 3ێ7!C &?!Cu3ۏR .Zðoh8:ðPJMXmq/Ip &JJO>&V#.pu	| `uQyȿ
 ^pktȿt;+t8QWP3 PhX@.X=X@uX_EYP!qup$ q!! .$> u
PxJ@Xuð6C @B T A3gfpg߃ tHu.g :f g&ffS}| ffߋgffOf6.<(.&gfBfsDP
h3g!t@
WBDBfR`6c6U z uq

(@kރuX-O0f?qPfƟ  o!ڃo tѾ`Nwp Mp pjXhAp\ARÃ@t%tgP&g!ggyf`ҜRft9tg>E @ t9g5CggfRVf),g>߈E %g> !P(^d`g
ز
.Њ  ofRA"Q軦2` t1YsT-/ T-o:<!(ʗ}踠 oK ,j,.$ T-^cUDT-ɦU,w#ST-ZT-)T-T-:%T-D-D-۹@g?ټXAv	fXf.p耋0!u<u<ww2.߇0-Hf&@p S؀^ذsErEbP'[ fp1t;x_V4t`u? u_(&[f{f[0CðC0k`0 `؎a( u6貧`"; ^am2f԰CohUq:s
8>.hMr0A@fP 됿6fA:q>r}dbrQ
qhzPsGthIf uR ZI0r M+r	ap@ hS} WN#!"ttt&st0M_fYñVAY:(-!Yf^ˠ7_)p!Q.
ϟ5̏wts?B-~ràq$PQ 8؀tu
AYXPY5u 
X `K9 Rf쨀u Zlfan K @(0B{ Ef߸ pDp   &Et"D  $D(a&s `ّH&tȀɧ 4>2@"Q
g&t
 0HL &}u?p ?u8&?= r1	&
I$B>r P
` ߰肐 m  m ;m pj's 0a` r * $mOQa	 & a1@  $$<@t"hXoKuK a3Kuף`.>st&3r	&*r
A1G$@`prr X ? ztrC0}qw1#!8Q909$Ha0){fRQS͡[YfZOt'1$s$s#s
| `aV@U0
ADȁmG> w Rv  hIruf`vrfPz  %f  ؠ_r<fffHff#f+ִ f;wf &3g&Sg&c
uff+fɀqcz p  ,-./01289oG     K `a9!- 3 ˿׿RRF@89$a,PoG3"_"
P![2t*:@ 	 苽aÜ`>ul>l!GA lBla}6$?Cx! G @ A2 B  $0sF  0n 诀"  BnnnJF$a %JF0:P ;<ƿ< tq ̢=P >̠̡??ޢ @   qllB  ؿP lBB@ l@ U   @ lТN`&p}' /!%а 
@  ~
FFn  	n	n	n	n	n	n	nnn 
  t;:a  @@CFd̀>=`  3nnC q
p	p.nA
` nݕ5q5aPfWCI4g&g&f_X'/>                     [T 8߻0Gwɀ$ tgbT x򐌺F7 u BxK1RۋP@B u$ZfQWP QXgg̐``Q
`fgаfQRfWPSf3f3zf0<  P t{f; X tDty[Xf_ZfY<fPffffX,>с PJE gf^! @	VJ					y:		y	^		f	W		ہ	_
g&'׃p@0:fPSQWV! # tOѼ#5"A$5h/$TQsY^_Y[fX>uD6 ,                                                               sH-O  RdÐ              p                                                                        x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  HP       VBT             $VBT ALVISO         d 0 
" 0                   BIOS_DATA_BLOCK x  
  d3412Intel(r)Alviso PCI Accelerated SVGA BIOS 
Contact joe.david@hp.com
Build Number: 3412 PC Dev    06/01/2005                                               Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ 9                 (  8  [0    ( e `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                     @   H `   H                                           =                       $    (     
 
                                                                                                                                                                   !  R`SI-1362-A   p                                                                                                                                                                               I   <      
 2	 Z (-  	
                                                                                          	                                                                                                                                                         
                                     <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                            (  s ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a N  XN  XJUXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                                   :ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               68DTH   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 9s萒 f    Q7sY 戰f
!  ff !  f   tf ff
#  rfBYf戰YgC!!f3f   戰 fHr4f f戰䈰計f戰 rfFf    戰戰3莋f  f   f戰fSf[f   f   3f   f  戰g&fFfCg戰蛋 撰fPfSfQf   fQf3یff
!  ؇fYsfYf[fXSgu
5  ;u[fPfSfQfRfWf   f3یff
#  	 菇fBf   !f3g}
5    fg
#  r%fG;wg}
5  f_fZfYf[fX          fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   Ifsf ff   fT   Ifsf wfD   f @Ifsf [Ifsf 5Jfsf Jfsf c1Jfsf MGJfsf 7]Jfsf !sJfsf Jfsf 7Jfsf Jfsf 3	Jfsf 	Jfsf 
Jfsf F
f   tKfsf c
n&Kfsf xX<Kfsf 
BnnfLg&nffOg&fffsf fsf f   f   Kfsf f~fsKfsf ef   Kfsf F<|Kfsf  6Kfsf j
Lfsf Lfsf -Lfsf x=Lfsf =f   tVLfsf fLfsf of   tLfsf hLfsf Lfsf SLfsf Lfsf &f   uLfsf "Lfsf Lfsf Y&Mfsf Mfsf )'(Mfsf L'8Mfsf 'f   NMfsf <wbMfsf 4 f%"f   t
fa^wf  Mfsf {ta$f  Mfsf ;jff  Mfsf Df  Mfsf    Iuf  Nfsf f fsff   f   f   PNfsf tff Ag&ufNfsf &r8u:Nfsf &u$f3f   u
ffuf   tf fsf   Nfsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  tOfsf $f  Ofsf idf  Ofsf rf  Ofsf 6   Iu f fsf   ffuf
Pfsf %tf   ),Pfsf $8uf   uffuf fsff   ftLtPfsf $f   t$<t)<t/Pfsf $ufffff   uf fsff   ft(
Pfsf 8$<t<tfffff   uf fsf   t8f   ftFQfsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tuu0f   Rfsf $t<tff @   f 5Rfsf "2  +OS._Rfsf "<  ff   f.:w .DRfsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2uff   f
.f   2f   f   ft/Sfsf !< t8stff   uffff fs2uff   f
.f   2f   ft(%Tfsf  < t8stff   uff ff fs2uff   f
.f   2f   ft(Tfsf  < t8stff   uffff fsf   f    ft'Tfsf $ $t<s
f   <tff   ufff fsf   ftTUfsf uff   uf fs2uff   f
.f   2f   ft($Ufsf m< t8stff   uf?fff fsfffsf fsf 2uff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%f   t.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfu2.<u f   t2kf   uff   uWfsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   3Xfsf <|f`Agf&   f    f    f   rXfsf f    f    3f   ftXfsf UfftXfsf ;fftXfsf !fftXfsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   Yfsf <|g&f~fsf fsfLf   f3f3ftr2f   tYfsf Qtf˰Yfsf 5<	rIаZfsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8  f Lgf&fftf  f~fsffHfuff Lgf&f   ftf@l]fsf f Lgf&fftf  f   tf  f  f   tf  f Lgf&fpffHf   tfHf~fs]fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	^fsf fBgf&^fsf  ^fsf  uff%   f
fHf   t
.f@Cg&uff%   f
fHf   t
.fCg&fKgf&I_fsf Ff fs侳uff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsuff%   f
fHf   t vfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}.fDg&(σ.fDg&.DfDg&f3vf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`|f~fsfffsf fsf f Ef   .@ fffsf fsf yfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_cfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
fHf   tfHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	f   tf~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H׀f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fi  ifffsf fsf f x.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xifsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfu  f Lgf&f   tfu  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1sf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   sfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  tfsf ,$f  ufsf f fs<f fsfffsf fsf  fӇ.ufH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  fsf Ű < urf   6fsf $<  <t<t
<t xfNgf&f   uf   fsf $p2<uB >tHH3f  fsf fƳ 
f  ͂fsf *Ż  f  fsf Ű < uHf   fsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ufsf ų
f  ofsf Ļ  f  fsf $
f  fsf Rf  fsf ^$w<u|f   ׃fsf B<|2f  fsf (f  fsf 0f  #fsf $f  =fsf f  Sfsf ĳ

f  mfsf Àf  fsf qÀf  fsf Xf~fsf fs            f   ff   2fff   ff3N.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2XXXX          "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         [                           o~jGDkED͍#(:of`0]ٶUVo^#j	lfYF;EbRi; _ OA 9@fhP) ?ٱCbNv4gғjF^SzDM6c)@#$i`]).?mCmϰg;І\[A;n-]uM^h:9*!1F;ޑW誩O0~1_)W*yBd.vOr/ϴ
%>2=ׅYXtSc!TFm֦U`aMH1':
Z󑈷5Ԙ|ްao#1\nѓkݷOL|)<F+z  :~VU-PadX;*?.5Uc-oh@x/Rdlۑxf&\݁'KAqOrbUd	Csʩ^w<AO<q)+	dCfu%_,[S\
[+f(=]FlJ߼qS:<xM+ٟ;ݞ^^פIQ>wm|
{OYS^9E@3OZ@_БHg(R	"t3٨_1UW!ߣGhϿl4d	}N*w|<gFz+Bs.4<0
2yUsiɕchLEH2$ql[_B,>)c-6+AjS;MF,kOHUAimX?}DS}[!AnjZfe\Ҥn(.VV"O3%;H׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        D   @    L       @       H         `      T    G|   @ Ď    Ď    	 T    G                   0        	    	 		 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D    X      P    `                O    O    
Ol 

Ol 
Ol 	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 	 x   @
1 1  @  @
	 	P 	P0	 	0	T
	t         @  4     	4,  <8	    , <8	     <8	    <8	    ,<8	    ,<8	    ,<8	    	,<8	    	 T <8	    , <8	    ,0<8	    ,<8	    ,<8	    	 _. U . " /  . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /  . a /   . p /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         =                    	4 @     T                      d  ` h  $X  '     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<8	     #<8	    P0#<8	    @#<8	    PP#<8	    	 #       8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O  N            0              < fdf%f  $f$
t)ppqtffupppppqŮJfѮfupppppqf f  gffLggf^gfnf    f
   "=f+'fupppppqg- fTffdff  @$f@$
= u$<& fff  @$f@$
и f  D$fD$
аfgf% = ufKf f6f % ugf6fU../0./.f^f d< ufyfd< t<t
u掰ff䎊fffŰf掺<ufif}  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f~  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   f`f  f'  對 f    < tg                                   	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>fu	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
kD fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4j hf`  fg&Ft vugf&>tgf&6f٢j &fU ~f^Y[fXPSRfVӃ tAӰ Ӄ% kg&ƅ    f  q\g&  	uf^Z[XPSRfVӃ tAӰ Ӄ% kg&ƅ    f  qg&  	uf^Z[XPSR     Z[XSR  C vZ[PSRRZZ[XÃ<t  I  .  8PRt)t<ZXfPfSQfRV%2  f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $ff f	ffff]X t fff f	ff  fff_f^fZY[fXRfŋӃf3ӃZfPSQ  fӋA vY[fXf` f;.bt
f.ba   $C vf3 
 f    fgf&E   >a uFa f  gf;tgf+gfkf0fp  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f  q <  f  yg&"  @v@ g&  s f  y>j u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       ' p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        戰䈽j8戰䈽fof[밳fYf찴fCff%-f/ f%"fGfQWfcfmHfyf ffNff f
   `"	f   f3f30f  0fwf饄f   f f    0f  f f   0	 f%"f$.ff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f.`f  
f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pf$   @ /Uus/ - M
:  >-rf:g0  0ׁ ( r:  .:,V>:M:f1f$<>:3:f1f(f(rrf(f$f>$ wf$   >::f1f(%f(נ53f(f$f>$ tr5f>$ wf$   >::1/>::1m>:d:1ff   fF>:=:1נ3,>:#:1ס3>:	:1f3f :, >: :f1f('f(נ5r$f(f$f>$ t5rf>$ wѰ,f$    :- >:ur:1d>:u]:1R:%	 D>:u=:1ע./>:u(:f1װ >,:t  :׃>:	r:  Kl	s 撰 XÅǔǮD^}ȤȾ^kqɆɘɦɻfSgf[gfPfR>/uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf @
 >/ u> 5xzytsfZf[fXúz.yusfZf[fXPR tĺZXfSfRf @
 >/ uB ;yM@t=s(xغz,y0@u sz.fZf[Ru	sZ       p     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`>l tVg&4  g&;  ĀuH g&  vl f  G 
fp  hxfaPSQV ̋L	;t	  ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 mf6js>mt fafWf   g&D= g&D= f_`r r8 a`f   gF
$&n
gF
&nsw>mtaf`f  gF
$&p
gF
&ps@f  g&|5  t>mtVfarfWr<f_    f`fiδf   g&D= (fgf&T=fg&D=rL6ff G fr6QfPf   f>iι gf&D5 gf&fff>ifXYsufa`f  &n gF
$
gF
f  sF>mtma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva   f
   `"	f3f3f   0fffP  0 f%"	= t*PR ZXtu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f  +   f"     f6  J  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_Z!ֱ`!ֱj!ֱn!ֱfPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP(R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                0 ] IPS㋇ӣӋӣ[XPSQRW0  3  3  3_ZY[XPSȎػ       !    A   f   $       [XR # 1 ZSQW   L_Y[SQW   7_Y[SQW   "_Y[   q f  f@  fPQgf0& YfXf    gf~gfNgfVgfOkfPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX            <t ø fSQ >.tf r	f  r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f p   rg<uf   ⃸   Yf[fS>.tf r	f  r>PfSfUUgf*gUfUUgf[Xgf    Y r
g8u   f[                                     Q  YPSR+;wZ[Xf>  tf tf`f  f3f3f3f  gfffCgftftfaf    f uQYfVfSfQf
!  f   f(7rf(fYf[f^fQfWfVf @  f   f  gff^f_fY               fPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfXfff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{fR fkfefd    2ø     B @ \p$06/08/05DHTd