#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68BCU ROM)  - Linux-Based"
BIOS_VERSION="F.0D"
FILENAME="sp30434.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  tz22  z2 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  z22  yp2 Y  8DTD   BIN  0z22  22    8BAR   BIN  KG22  U2    8BDD   BIN  H22  cW2    8BAR   BIN  O22  U2    8DTD   BIN  qP22  JY2    8DTH   BIN  fQ22  K2    68BCU   BIN  wS22  UP2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZYY  @  
   _             
(      C   
  `  C            P  
          v  -  Q  t  c  Z                y  S  =        {"  u"                     ,
 ,
 ,
&  &  &  |&  Y&  )&  &   
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
B  A  A  ?  ?  ?  ?  j?  D  D  sD  B  vB  ,,
,
,
,
,
,
l,
N,
$,
,
,
,
,
,
,
d,
F,
(,
 
kO  (O  O  O  N   
\  \  \  \  u\  _  d`  `    G	,
,
,
,
  v                                                            3Ðj茏ː
  F  F~ F F^Z9 uvfv%}fvfv%~hH	h jKRP蟊Vtj
fvvP輋
hH	h jL`RPrVtj
fvvP菋
 Ð3f>\  tf6\  f>  tf6 
j ]胃  Vh jh jth jih  h j]h ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hl ǀF^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPfjbRP芄jRRPzjBRPjj2RPZj"RPJj	RP:j
RP*jRPjRP
j
RPj]NFF9F}-^v&&?-t^F&&?/uF jYZ=sjvtRP蜃j]@YtjwURP}jt]>V   hH	h hl bFHFuj fh  ! h(
h4豈f6Ffh   h(
h4tbz f6FXafF    .^	| ^&04^&4F~	vF  Fz 9F|F= t= ujRP谂j\BYXfh  j l\ ^ \ ujxMRPujl\i
>R  t5C  Xt( !  9  =  A  E  I jJj1fj   ujxRPj[t(`       ؎f&fjvRP豁j[>P  t>R  tZ  X  L  >Z t>Z u& & & >Z uuD>T  u	>L   >L   >Z u3T Ht	HtHt8j uwjJ-ulj?j.>Z u?T Ht
HtHtHtIjj AȐj3u+jRPˀjT HHtH
>T  t7>N  t0fLA  hLhLj#}
>X tjJRPr>J  tj \ZhD  F >D >P  t>R  tZ  X  L  >Z t>Z u& & & >Z uC$~ tfj fj ,F  t=HtkI-
 -!- - - 
tFf>  ~  H    6 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G|&Wpfj ?d     F >J  tE<KD B= M- K- '-M- 0- )fjF6>J  tp
j 6X^ÐU	^&H&JÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&ÐL"N
z hthLhLj=>X2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP襀
3Ðfv T  Vfh  P FPՀfLK  FTzhthLhLj}>X t3^ÐFPTwBFVhH	h FP@~RPhvhH	h fv$~RPhb vfvhb Hv ^Ð  F4F(
L"NFTFzhthLhLj0}M*ÐU~uhH	h  Ð~ fh  `hH	h hb YFHFu3Ðf@    
f@   ff9@sVfh   f6@fh  `f6\ Iu*u%f6Ffh  f6\ Z= uF&G
 tf6FX놐f6FWA~ uhH	h 3a     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP~
#fh   vfh`  j f6\ r
Bv  WVH	~" f~ thH	h FPRt~ FPu3^_hH	h hb WFHFtj ff-   fPf6Fv
f6FjFPu
f6Fx~ uF.~uF6d 8Fue 8Fuf 8Ftf6FVkFPh`Rf6FU ^_Ð~ fh  G.hH	h hb VFHF
f@    	@Bff9@sTf6Ffh  f6\ V= XF&G
 Kfh   f6@fh  `f6\ )t!f6F>Ufh  `b^_Ðfh   vfh`  j f6\ \U     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP${
FF> tjJj1j f6 Z{jhH	h(      RPz
6 h(
h4     RPz
     ء^ +\  &&W    f&        ؎f&       ؎&  E&  FF܌VF X   R   Z   fL
S hLhLj^q
>X u_>O@X RfLN  fP    FޣtFܣVhthLhLj%w>X t>MuR   hJNu~ tZ   Ft
F$p*Z Ð&  VFF܌VfLD VQCzThthLhLjv>X t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	L&LZhthLhLjMv>X tjifRPs  fh  ! h(
h4xj=RPUF  @ +FHuF F^	&4,x(&*(h(j*mVF 9F}j zĈf<t<uhH	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>X  u#jIzRPrjJjRPr3ø ,x(&(h(jUh~tuÐ  fh  u3fF    fFfff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "h(j
TjoRPSFF*;s6PjNRPSF*Pu,x(&
(뫐,x(&
(h(j
}TjzRP!qju,jCRPqjDRPp>J  t`hhb jRP-SÐ  fh  h`hqt"jKeRPpjLURP}pjyCRPkpfh  ujEF  h(j
SjRPRF~uJ~FF*;sPjRPbRj F*PNu,x(&
(띐t~ F b,x(&
(h(j
RF~sF F sh(j
RjQRPQ>J   FF*;sfh   Pfh  j f6\ fh   F*Pfh`  j f6\ F*Pj&RPjQj F*PVu,_(&
(\h`hb jRP)QjYRPjXRPhH	h4 	QÐ  fh h`hMt"jKARPinjL1RPYnjyRPGnfh  ujEF  h(j
kQjRPkPF~uJ~FF*;sPjRP>PjF*P*u,x(&
(띐it~ F b,x(&
(h(j
PF~sF F sh(j
Pj-RPO>J   FF*;sfh   Pfh  j f6\ qfh   F*Pfh`  j f6\ F*Pj&RPFOjF*P2u,_(&
(\h`hb j RPOjYqRPjXgRPhH	h4 NÐ  F >Z ut~ thH	h< hH	hH FP.hhH	h FPKFVu3vPfh  f6\ |K= s^&G
 tF  fvPJO>Z u~ t	hH	hT hH	h` FPghH	h FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6\ FPy0F~rhH	h hH	h< IFVtvPfh  f6\ QK= s^&G
 tF  fvH~ uj/RPLhH	h< j!RPLF*  F xu3E-t*t~ thH	h< FPej"hH	hH FPej#RPFPehH	h FPIFVtvPfh  f6\ H= s^&G
 tF  fvG~ tj$MRPK/F~  F oh(j
LF  h(j LFj$;F~,x(& (܊F*PjRPcKf6\ FP/FF~s#~ t~ u,w(&
(tFPFPj%RPK~ u~ tjjgRPJF  F f6\ FP).~uPhH	h hH	h< GFVu3vPfh  f6\  I= s^&G
 tF  fvdFFÐUf6\ FP.Ð  F u3F F~s7F*PjRP*Jf6\ FP<uhH	h2 JhH	h hH	hT FFVtvPfh   f6\ BH= s^&G
 tF  fvE,x(&
(
h(j
JF h(j wJFj N*;~,x(& (Ր,x(&
(h(j
+J~ ujRP%IhH	hT j!RP
IF*  F u3t~ thH	hT FPQbj"hH	h` FP<bj#0RPFP'bhH	h FP~EFVtvPfh   f6\ yE= s^&G
 tF  fvMD~  j$RPIH9EF ph(j
IF  h(j 	IFj$R;F~,x(& (܊F*Pj[RPGf6\ FP:FF~s#~ t~ u,w(&
(t~ tFPFPj%RPG~ u~ tjjRPaGF  F f6\ FP9u3À~uLhH	h hH	hT DFVtvPfh   f6\ rE= s^&G
 tF  fvBFÐUf6\ FP9ÐU  
2

 UvV>
Ð  >
vVF*^&F^&  >% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2F>F 	F  iÐFi  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRhH	hl ^Sab~uvvhH	hv fvaÃ~P|FlFFPvvhH	h fvaÐ  FPNQVRhH	hl fvavvvhH	h FPraFPNQVRhH	hl fvavvvhH	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;D}DF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FDPv~ 7
FDF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>Z uFP_!ÐFP>Z u0 ÐU>Z uFP+ÐFPU>Z uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh4FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh4vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh=htLth=hِ 1= t= ut Ӄ>X  t fj h
N3  F"1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 "Sh>h(*F*P̓uF"z j h>h( j̓]FUtKjh̓h(
hb j h@lfj hG=th>h(EtÐh(
h`h(
h~&u{Ðu&{ÐU~ u h(
hjhHh(
h`jh7F  F~ ujFÐF Df>   FXy j h
@h^fh  L΃uF  Fff   ffffN*+;=|;s7F*@N*1 XSh
@h^j F*P̓uF2uF~ u~ X1 F F~sF X1 F cFff   ffffN*+;t|;snjSF*PShSf6\ Tڃfh   F*Pfh`  j f6\ ڃF*@N*1 Xj h
@h^j F*P	̓h~ tfj h!F\  fh  ̃h(
hb !fh  ̃t"h(
h`h(
ht";fj hE/fj hb=uuh?ht!h
@h^tfj hrU~ u h(
hjhh(
h`jhF  F~ ujOFÐF Df>   Fy j hBhdfh ˃uF  Fff   ffffN*+;=|;s7F*@N*1 ShBhjF*PR˃uFuF~ u~ 1 F F~sF 1 F cFff   ffffN*+;t|;snjSF*PShSf6\ ׃fh   F*Pfh`  j f6\ ؃F*@N*1 j hBh#jF*Pyʃh~ tfj hF\  fh 5ʃh(
hb fh ʃt"h(
h`h(
h聻t"fj hEfj hb=uhlBht!hBhtdfj hÃ>J  tj htD D   1 ~ uj߃FÐF Dj Ճub j h EhtF F~s3a F*1 j h EhFPuFA j h Eh|he>Z utTtMttFj t:hlBhCfj hb=th EhtÐ  1 ~ ujރFÐF DF F~s-F*1 j h4FhFPuFA j h4Fhh
또>Z ut>t7j h@wfj h=th4FhtÐ  01 ~ uj݃FÐjӃuÐF D*b j h Gh6tF F~s3*h F*1 0j h Gh6FPuF0A j h Gh6h
c>Z utTtMtFjt:hlBhafj hb=th Gh6tÐUfvhf  |JF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
|NJOÐU*FP|PKJ*PKÐU*FP|PKF*PJPwKÐ  >x u7]  FVL;Vrw;Fv	x ÐFP
uh h Ux  >x u
FPh iÐUx  >x u
FPh IÐUFPh 9FPh -j>x th UFPh FPh FPh j|MÐ  >z tRFPh FPh FPh FPh j0 h l<uz  >z u&v*N"FF FF
FPvB|JÐ=tw$-t-| u)~  >~t% Ð~ -t-t t-0 t~ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U~FPgÐFPtHtÐ~	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  p h FF )fF~}j v`tFp  F~s#>p tFPh F  f+fF볐>p  F  `>p t(^&k^&?tp  FfF~|F~s>p tFPh ;f+fFҐ>p uKF~}Afh   j FV^& ^& h.p F 닐FPh j FV^&^&pÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h rfh   FrPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~urPh Zj FF  	& FP*ătFPh(
hփ~ thH	h
hH	h
FP3hH	h FPUFVu3vPfh0  FPLfv4FPh(
h`kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhlnfh\  hj 6lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6lhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	& FP貶tFPh(
haɃ~ thH	h
hH	h
FP&hH	h FP	FVu3fj hvPo(
fvfh  FP	fvFPh(
h`ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû~ |Ë~aË|aUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..^f^gef[UfS..^f^gef[UfS..^f^gfeff[UPfS..^f^Fgef[XUPfS..^f^Fgef[XUfPfS..^f^fFgfef[fX                           UfPS^tf3ff^  f.
_._ "  u  $" u [fX 0!<s3P˿(
6 + r ׁĞsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6
+3	O3X 66666נP.`ظ MaP.`ۚe  y>	uXP	 P(
 5! %J`!	)&6, 		3	sx		 	&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
8t 88z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï  <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  & U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV 
;t@t3_^] UWvt 3I >	u	@!_] SQ |QP,[|Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UW(PFPvv(PF(PWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuG(t4tLu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVxFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWv (t4t	LuVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.~wpsZuZuZu>wr>w>w>w>wJuss>w>wp>ws>w>wr>w>wpRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] yy4yhyyyyyUwVW3FFv&vF
t~ }F, <Xw$ FF.xV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uumsWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
~FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>z tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uwuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B(
&|=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WVX3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWV(vv&(PF(PW Pvv;u),x((&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3(
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	8t	F3] UFu		u { rFGFF3҃vvډWNu(t$> uS#5![j#%!us厌ʻ 	FV]U컧 .8tK
Iໜ	]PPR.`؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PU(
ء	F	F]XSQR(
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغy$%!3]UWVRQSP.`ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;u΁t΁^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    (
              4.63  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   H	                          68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) A  + , Z?  . / TD  Z [ D _ ` E c d F f g G '  (
 ^  (
  D10/17/2001  O                                                                           H	 H	 H	 H	 H	H	VH	H	H	H	(H	ZH	H	H	H	0H	LH	jH	H	H	H	
H	,H	LH	\H	rH	H	H	H	H	H	H	$H	LH	hH	rH	zH	H	H	H	H	H	H	H	H	6H	LH	TH	|H	H	H	H	H	H	H	H	H	H	H	H	H	$H	6H	JH	^H	tH	H	H	H	H	H	"H	BH	fH	H	H	H		H	*	H	:	H	L	H	T	H	b	H		H		H		H		H		H	
H	"
H	F
H	L
H	f
H	~
H	
H	H	
H	
H	H	H	 H	JH	LH	jH	H	H	H	H	H	&H	2H	8H	ZH	H	H	H	
H	
H	2
H	h
H	
H	
H	
H	                                  E    F    B j V(
      C    D    B j t(
      G    H    B j (
      K    L    B j (
      O    P j (
      N    M l (
      I    J    P j (
      -     1    + m (
      T     Q l :(
      *    1    ( m R(
      R    S     U   
V   
Q k p(
      X    Y    W j (
      0     1    . m (
      ]    \ k (
      a     1    _ m (
      e     1    c m (
      h     1    f m *(
      o    p    q    r     s     n j H(
               Ta                           _C_FILE_INFO=                                                         (
               
	
\ \                                  1(
  1(
                                                                                                                                                                                                                                                                                                                                                                                                                                              (
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          6b6b6b6b6b6b6b               (((((                  H                                                                                                                                        
                                                     I`I`I`                  i(
(
(
(
(
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                            	      ]Pg%\5G[m;pL|.Ba7Scx	F	X	g										
6
F
L
Q
V
_
o


	Kv)
i
y






),03;CHOX^coy9]e&Hj 203-Memory Address Error 
Non-System disk ore
replace and striky key when ready
}
602-D ette Boot RecordH5 !Run Configuration Utility1720-SMART Ha0Drive detects imminent failure (Fing Attr: ??)

Please back up the co{nts ofh1drun
HDD Self Test in F10`"tup 1800-Tempe!Alert  7{A proc~@has be eda"s n0orq'#C7MOSA%3-1)d(s a%'&1(&by POST o1155uBo1?Comm P(6Assignm!lic0%611-Prima Flopp@-?/R0n02-S nd12/001 tGrol %85sType17A88q ;94O<f=03<0;W@0;f@H=C8 1;DH=348@>G=60-Fix'@doe(sup( wBloPModrI%1I1JK7g1>6K0 AO=PL01s73IMDMAL3L?W$L5V'IdifymAmQ[X\]4[ Q_#K`?^av]8VParamr Table1BI)dHalp' c 538P!apgE=Updb.49h... Invalid el ronic serial _numbe108I/O ROMW%308Kl93r8304r@UnitLoad_all -hi4Monochrom$k 164Sizu;qrHx"0V$Inst`wi etwork`"rvp9bActe!No rachi164Op*stq# Pg@ CheP2  PCI BusAg|A910-ExgnoStorag:eviD= HvF1x`1`gP9lS1T0xk2_{3\3o02 08:rpqQs.E=IOCHECK acwlz3-{Tipy& Dap O X B  Powe{r-Pass@dXOKDo you!llzato pp  s? [Y/N]?RҞsVMAdpiaP/R"orhipn01 n (ABO= 'C_trl +$tDel'pz8-11A: X&changedu2: m oqne!&1PpP3߯: Video	m-4z:rrup+f@_u5 i8͹6ߺan3(@_#expansb  TurnҠcej &f]qr<F1>:G AbSb^+rmal2Upo mu"տ 3gi wa0,Q+B0kA(Strg+Un/tbr,I ϪnaTf@9owo$uWtomculed: [:s To~ mie~: Kbyt@) cksum #bn,NfauЪ`nuMl0wiW'Next? EAAgti#Exv0Ӯs7saEA7cce=   F1`0 OF2 CTS`k I .pugy # Mai Oances EntQ;F.5w9ipw, usimodut~Yme@erequi{reQ0s.  `oD٤. rLK1"Bj>GMib?_ay126re| Mexcee 'K'Ś1) >CircuU=uUn$N'wPlJn$dӇ%'.,i.Sc,eT !"P.0S1t	C11(ppc1@%#9	,vInr÷ypD	Shut2l/down` P~ %0Ѳڡe K۷PIN: [5]Nxoq left0
ERROR
wY`ha߰A}7goney 5la"MQIndex (MSGIDX)   t   _      8     
   .h   n f  fffft$ ISvݓV Q'  A     ~        > k    T j  gG W e M AY 9|@. 0iH  EnSa0~ G ( @ ظ   f3  ?f
 4 P f pπp6 f6   } /  6 >x  .hp%v PS $<t4r w[X ȱ ЍRhf`? ^   	)F 9h)h*'h"fa ؾ  D 30"0r< tF1s""!ؿ,: @ WhGL#@߿EOFVz!!^ ?'!#!ff&+U= r&+=,=r,W>&_<uc.&+
&)&'
, fgh  0 pqr  <ABCDE xyz{|}   *fs+PfSfQfR*R ,}&7B r
& 7 7D0B77fZfYf[fXvSQV3
Ê^Y[&. t".FuN.PW#!M _XUWfVUSW! &fv߿ h @޿RFA~2p@=,ك!IN@3d;^
u
t_@N_[]f^_SV h^[þ   RZF10=ROM Based Setup OKEnteringJ. `.> tj   _KaRMPM 2NtM+ 3P@1  p OBQ	Q`NON2OKú !t
0N~`Pt.Th'PXh/(F12=NetworkJrvice BootWake On LANAttemp-tLto"Z 5Y\D]`3Phft6Q迍 r	QaM8
!tU AOJ4SE_ bbb6 a WR)ddbbvbV3<^hWr$hs MfuQVuNs	2Ps?SQWVRVtVuy3 NF 3؁Æ?	uCFG?~NootpGf`h9qq"!v&hAssfaZ^_Y[kkNotebook hard driveH]wMultiBayJ]DockLbJCzbz(top){|bottom)}|left|@}wFloppz  USBρCD-QJHxDis\!Supe9ryNICυj11ϋ23 oߕ? _ߞ? _ߧ?4	Rpmpp	p
ppp

$B`~Jlectv[DeYͿ߳͹U@| aond [moxthe highlt[your choY.  PresscL[ose.Seconds until au atic defa`z start:   &<(d$';!ZipxC`t= Dr= k`d h S0ô0."!&t2
_ 1
I 23؊' tA<v<st1& 22
2Aʍ4	QYAr ö 
B.
*}РV `T+jjj(Pj% # ߻ 
z  Џ  AO  72g¸
   t02
32Ɋ  F8tF3 $ ZuqАq MURVQ0h.,.L.T^Y^Z]S.*[݁QSVW/ s&Q.<.-00?00.AAOY_^[Ys?}QBo
 qu hP⾲ t0t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu}@o`2bXʱd ۸

r
;w2Ҁ`TJAA1ogFYô.*<W2W0? h. hf h
/ hN?i9,9 &i@ 64gf.fff63cP i<iif1B JCPQGysrPR#1 ZX .>ohrSHfPS@  uǀuh3<tkB `:.> t.Ñ6Wf`+2f?@df_f_:
Qf @gf&=TDSSu  ff3gf_uf.>f^f_YPGQRW5Hr_Z@<PIVW TGI$tu!t쿪u ܺ&_^I6W e$ f3_f@<`6<(A,-  f$?#/#%aSWQR uePpq4,XZY_!1( hq&'у<.@3ɹ2 uh}Z#-¼ P% = @uXu)-@haR4       P`  d `7P7h7UT !X?  5	4   @@         ;  ? A0  1=:,90{ 64  68 ?( 6*< .> 6bB `9,> :A8cBh@d@ f<95 !@FFF FF!GqG~GC 6 @4I. UaJ /J. pKG.+ rKaJ0KJNF. `KRJaKQbLKNhOG~6 NJN>O!LN S0GNp9SaS
SGaSLOp< S$*SaS(SCaSLWO aS3S@aS:`GOTN 4SFNaR`]heu<GD;Bt FQt &>&:@  _<@_fYf8_t*^~^UzC_|@_sl\&>> tRc ~rE^(&Gf3C hGLg&}U  G_ 1e < t&S^r c~Bcc3d&$dffgah@vv\f3n2c*f&> uf
ffKf&&&fCh0Aqo~?pPqqq @r#q r\h`ր@!x !x&&vSQn3r*`&&&@z zr{Y[$bfPf fRfVWf93ffCf[fKfSF0rw!0cа K I+rEn_0f@SQVW: u3_^03t3!Ŝf} @XM r;g7u'P u" hh
Xh7PRA U~fW Qt% s	 fU fff>Qfh7j3-fpG g&; 9u}7)f)@f g&~/u!/u/u/u	g& x
ttx3OrwnfQǂ 񈀓@қEPf~/u/t ߀}	;^QGf &?ϥ/O oϮ/O oϷ/O o/O oƏǯ/O oϏЯ/O o؏ٯ/OoPAfUf.LPu hPS05rWrRrMPtffű@| pV t#Br"px#   / ' y> ?f]  fUr*6Б  R Z ?rGq9?Kuf] 
a~ rCF+ @g3cg&8E t@]fEGx #R~m r>U t04~Qh 9PPf&xW{ r^ r
  GC_>>?t$Aߊ?$wW밠w  _Wl  sq_  Q q0 ߰@B ?  3 S Sp' " 	P	j 퀳cAQ/A
?QWE
uptPGX_Yù
 d h%S&xs@
P <<uAbuĀ ~PR? ?50 < uZ0AD t	A50 60e\0#gf$fÀ<t <t,<t8 o\ffP〃$
"D
D$
#DDff#Df&f&
뿌T !t#a#!+P%
D%`&D&2'''뾒Sn h 2%l  }% @H EJ ;fk I b% pA Gh	 I
 h q
 og xf % $h e *  ,o pQ*i ̈́ js H -m  f A C B ` @< 7k! pM" {k# ( iH$ q M% |N&P-j e* d _ ; %' ) lu+  Y, .W- / 0 N1 `2 AB3 k= > k? @ 
lS vA pp k5 %m %6 k7 wH9 fG BH : c4 gC Y%D =JE NhF %IPJ D. K UhL HM N NjO TMP lQ R V fW 8iXP<Y AZ t%[ ebc Je ^fg P%\j" f"$ @ ؠ     f   3"t$" .D
PX% hX@ .X=X@u
_^r%YPL]
ظO!
N9OIPW;f&E1_Xh{UҡhcTsThUf%UT h+[vXv[ HYZW X PQqR0> 3_YXeqhc[^VZ2hBX# _hЃw> &=tGDO P)%h}s_s	Q'W   ! $!f` T 'ew@uf *GhLҡ uOphh
/fa}vP&F XXfp	 ff3uf `  ppGX}Pf`! afv߿ hҡpt<Pt<pu2fa`3 zؾL &>v&DE{&&D0u>u dxzvYy6z x~Yy6zj@ tBb}{
Ȁ}	Ҁ>b33S[tS[
@b2[sM3 tthCߊcs
ߴJhcawhҡD
ϰ< +DuL
p
E$ߠ<uЋD
@sd
{#r& ufp}` uL
 J6 6ju9  Xb6d &uh`^s	\
b_uc~ p D&}?u  t&Eb t Ћ&E^DЋ&Ef߀w>t6j t.&  t	&  t&xu	o\	PSq P ?ЛR؍>_3& ?W>	_[Xt+t#  xt  t w\迸D@PV!$!"桾tXh{1x6zqG&  g^Xŉhr㉿r!L	pvTt
v*`Wŉ^V'Q豰$<v @u<a	3  v
p
u$@!"<u@!P>ȷX\PRt\:!1twhG4!ă }쑹=ZX0
`22}Rǿ& {t5ǖ=ǆtOuŉ0: u	t!sŉ  u5r还ps
t!]&)ǰa׃/]3`Phsb  V @u @0^ 3f`G@f_%ޱbb}@ͬ!U!  b ٛ&egWʃO&MuO OfG2tM1t$O1t,t"wOʋG%r Ǿp}MoOg&/ @ɴ誋P
"2haG_kרt<uLD8 =_7D D	 d
zMQQbtSR0rG&}	r??23ืt`ha&E$	&M&]`.'	p%f rgtﴱS߀Ϡ6Uڀ ShF 
~|h}ЃQs܃]R]Q]ZW&= uA6Pë)
hë
 m_P
}t  U!w#w !#` #hS5 0.-.M!NPtI rJ0.58vuo@L@B 0gh{q.haW$
1gD {hN
hYkh@[X_Ë
`PS@5[X SϲW1gHʥ0LR
`gZ,<u(fPfRfffP
kfZfX,Z AvGu
pχW PS1g у[a$
 @vSQWf3< uf
<u	fpv#@_``֎f?tr73۹ F
t):u%RD	& hȖ & 	 ϰh})sx3+a]3 
3 b`. 󪽍 Sgt : Oiu jtVZ& [9 r6Q- r*0$&' t&f!l8+ \'q8q80
vAr_'+ ^QQ}1s4 0RZt8t hH)  8A5YQ7 ?][r=u(B% = t=@0YWV@[rp3+S6 
`HH1zE&EIQ,I[Зr50p-PuS[ u Mh-xfD^%1Fq8 @쨀ou$PuRuZDq8P=۰uObRRZOPP=ZORWV 0  PhӂX@ @WaW-o
AXrxz`W/2ƀB@?\C@h?r@D]a㳰a/@u,uYPP
@qb

+&C323&Yt _eeX
t&
0  VggRh5  Xreeekg(0g0
u7gh^Rh: >h8ip>rlhRh? jXw ^PRW!.&eWAxt&]wt&U
t ˀA9v]x_ZXRV3һ -w62C.X7/XN  Zhӂ{_ eW߸^ z`"/Oo">u _ '. + (&8.fc(.f3fu 3 Q>@s:yuBE&8Uu8@]
R +B&U
ZKؾ&80Z1ZfYB\igmqr}XRntfUrʔހRdÃ?h}rXm
<tZ.ێPpsVPX^f0  X5D
]0t`/"ޤ8<
>>Uf`؎ Fwq:.  ڎfafSfQf.k:ffff#fYf[VftGf    ^:Igf;t&fЬ \6S	FPݐwf^ë`2r'ۈfaf`+`f *faPᠳ3_X.>`}:  .еTACOF) Q&ϸѷ	& .\: Ӭ%BSF5^: fFf.k:`c:F.o:f.>k:E.o:ũ t@a:ttY@b:tNpǺ @SIVfB.qƾp?f;VrT%1ʝܠi PQfRffffg찊r.m  \:f@.ffH¡cՉfXfq8df33us?Is*Vf+f;wfff}33R·Ug:߬^'RS$.xpQPɠ`333Ҹ  QW>Dp_F
3}5upJE#ȩ t0 t0 A `t
Ήt} tWM_ }   ؉F EF^V  SV^P4Q@a&tY&  
`< tr&\]&\U@
&mNd 
S؂[u<	F&ߊ 4F^[_Y3%F F.Ъ}1-0VW}.ًذp?' Or_^Y[XWfQSg p1f{t
!p[fY_` t =$PKnPu2Mء'taË6Is } tp( ` j iPI&E)oSRUVQj@6^]ZpsV7` ``II^X~p*F
  tI#IpIPIF IFI袻 d3duhZ:Ku`<Uuùd `:hj&4ﰭd&&Xqtû   h'ro& h3o9PhC%{` X!$!   °sk+ѕ 
eh;r   t0t 4 a)hZH|`w' tKu'& & ? 
 e]u "`hkrsP<t<u}V/u0(u?밮1R*`Ph
%5Xh(C-50 % P6 z'@Wt[Z2s#7_ P柀X73#@e-e/ t?<n<P>` } / `?G  в# 3 'D1۹pHÀ   ; Z x     0NP`^~(bh+Xr1fF3.D( rׁ 
0ވBFuр~2wFd#-00
<2wd8F w(R8F wIT N@F ;t
 u@mF^KہD.W~r@V»  aPXû< fPXy[p[f[f @ffRfP"f!Nz
 ffFf3fv1NZfFsfBPf{f 1 r9@`f3`pǿ:f edfaÒKfPV`3v޸rF3PX

S,0<	v	,$F.[W Dd

Llflm^mf `
T
T o#p	#p
#pf_Cff  Ўfv@S H Ps_:FP
uf^fNfV_f^h5rPrRr0NfvPvVsVtF Hshsv`aЫbh
àff  fffffX_~4 s6f>f>f $ f!%gfg`pG0H 9 󤾀I% a<P*hr#P,SVW}0fQhÿYÆ2u%q(th~ </_^[PRhI>?? _(*U4:@D0 fsQ   P hfChr>ZXoRPSS3@0` ػ 7    A #pq$s q p3qð &q Āu̀t(% (t(ףu(`% 3ɰ<Ku{P;EhAfC_0sG-($dq - t+==vP P ZtP¯a XP 
ہ?UuC33Ɋoђ	u uN P)<$ 3@%`# Pf^ Xe d&& &߃0t h,򿣶30 h
t[( Ȱ t
(ŀv#t̰7轰5أPXav[B8v&> ߸ h`t`_P3 (u $h0ĆDF
#ѶVIss衺sn0L uf2h̑SZ!YuP腺uK 
wAL2 Q ߻ hPu= Dt= tY	ͷ|Y.ƿL^!r@FhPfAF]s,Lu0<  QhU;Le `vDFAF `01GrB	r<.M )(.M.Me.M;a `6,NPrAV(< 
u^V h P ^(P*^` ȿ2z4A SP( 22X[úB $PQR  ZY /Oo/Oo8ft`M00~ xriptrakfL+ كpݻr$kwr/f+D`f+\ r@ .Mh@fa`M PR)3PR
`&Fa`ˀ uh|t=Xh/T6 r.>M.Mpu
|QR.M|h f3f%  f{XURQSWF^
D=@L F\ ^0F\މ^t
;v F;F
 < uW <Vȭ22 IF t_%PՋ%~%뽹% #8t
` @uPj Ѓ;}
+V 
N JZ=`uAN35_[YZ]`P &X&`PQ^ kPYUkPk`?]]]/ 013?4_56789:<?=uFރ6.u;v?0 >Rh *YRpQwLQVptf&YCCp*KCC݀  R 3Yap(SRP!?[pt$&%<GPw  	  s ct@  <BMtf3`~..&u?<t=`IN O`<~PȯP20QMX|r
:MwRU3Mt.M!VfGenu fineIVnteluxC}=sn=r'=vp%f2ft P tK  fK  pB =  p[	tŀuvrMr f^@3ta5uZfDY $<@tK<tG`KF`H$u6fac5 ^ۊf Ff{#`Cta Bt	]ܠ{{f
!off.` , 6@gf.ff0~h
/a0A
SQRW3i hN.Tt;_Z"SQn=xxhe鳋Y`Ѵ؟ W .BB <t BB2Jt&(W s  8uQt@`23Ұ
ShYSsmt0`́ y autyi at]U y[aSR_  4
VZ[`1}-1V0  h%	 hal
 "B0ȜPaԀa$8uXRPQZ0QrtwvYu0ѹ }R wZPhG U2<Uߋ@Ju~䋧uJutWfgff屜@ q hȢy u
3ҫ w%vv آ
 sC)֢ uuPsف>tD A谁0@t07mɷ hcmܝPl$ghXʢo ]0KBOУ

e0  0>` PH&i &&g & & & & p0>tp ߮@սVWێû0 ۾@Z 
 _^1&>r ?4u=fSҴ`K  fÐ8f[P     f     @[ű@"`R[j	r>@sЩ   `z ` 
  "# 
 Uuo A t&r .s t ׈v; tմּ80>d" e@3аfؿfXfO  f>  <  vfmf) ' Mwf fyQf.Sǻ @!aA`?fAt@ &|}л~ÿfr S# XP
8пt"*e t׈.xлy{ [0Gu5׈.л n21_ >  Os  @
Aׁ.pK u	=t R.O#52&  hqh ݋P̸ hqh Wޱ Ш t>arh  ׳ f%Џ"S^ j j h^ XXX¥1uEO rЦSh#uh
}[¥{" tE2s 1|1x{0y t um1}{/  tE. 꽅0 
0   t!ZE@ }66ct1@ tat axS09pv%zմ` D  s(tӴ!RQк[SW&L 2Y3ۀ>u
| 0>Bu
>@upK>Pu>L rpL wf@rH0SVWU ]_^[s.L W&O  WQSL O Л33ۃ pKt[Y_uW@u$BSd3` Q-!f[U :tu
9 wpK"RtuL 2p_[WSPR`ZXL PЛ6	 &23 G&C2 鿖 &Ef d r&uO&54X& G<F 6n

@X$OO&2uG&2%Ŀ& !Xţ אpK[_Ql@B PAhȱ 0(+ `(= u0()t2nSRUfVЌſL f&7f u&Z&_?Zu `. G&!0 &0>tL *B6  80t L "12f^]~0VWf ~@s  !XfA33f0߯ OOf?  1sc7r_^n3WV p0L
^Ρn`ॎ31s8 `
iPh DTDo   <^Z|= 0 ȳ h`
@w <l  Q Ba (  BW @`
^ BL H`
 BA P`
 B6T W ׀X2A```
 B@ؾ^Zq4Aa=|\D Pi{S וᣋ LL SdpLGOq[ng
u`$XVh-&C!!4viS#! TPQWh9 3 3_YnV 04PQ_= `t;  @fYX "X@SPrW
& \ ff& X[x@ah  @3 pr  Òr|QlPE `E h` nfRf JhrOFcf1lQ   hbX.Ƕf3  <t. fi~ tq.ri."D.|u.:D_tSIjSjwD:jSjr5+jSjs&jSjv
juqjPjQhj
c8	qo<qq~-tPQRau!&$`Ȱ hyc~ZSQW@a$a  hq htOzg{>|E{_92揺 TCA6 @QC@p4@;uYð!$h|àf`p3%|f`\ 3垿]0Tu5faÚ3.nhpp{F`
xtI艽h+#+
*1;/Pf`  fg  ^6a褩_.FvA@A>:*&}t#MthYtb uu Fc3!zd 垺
  % 1~gVcWUc-w w"h0rV(@ #U96sr& ۤUf h򊥅F{ 6Dgf.fffh
/rV@Cofv7hce?fFfP0Om$aq3d Pqg1/fX0@Ɇ t𦪃faúv0؎0a a>
 O054%  0rU й`Ga`a޾5|]u,ъT' i!z(PDO`
߯0XpP`W 3 .l3d>"Z Xp,ðd`PdFvݶt` I`a@QBZa& <`s$3	 +0!,`0 `&XY&B เ|s aFd`ؿ`VE&؁| uM9NwNVuӃ~ t"F= wt% @a+ȼ'Ã@~@hrˡ%r [wg
0" K8հ\K ]W@]5o`5h#wq@   !	 @hn a ða,ct5 t2D߰aU t tfА2f
 ΰ0㐁Genuu#fineIuntelu W`{3Ҋwt/.;t3H5?aêъXP ÀfdfafW:f1VHg~f^` GHg k pP|[@|`p'w2 D h<f``4 ƒTePfPfQb0fZfYSRŐ  %=u`?2
/[ñ `F0 (f`x7r60zo1r2s1	T
z2s i#ܨfaq7
tLx	f   2n2<  C"%'  B< [A<( 3@ @urf uipA3@.e;on?#	~ wLV>P5u|[%؀ޡChPrVtM9'(˒)ÿP3jFcrX?dr  P5X@AXSQ? 32Pu)"/>pf`68;,g edRfWh3dd
f:X  `"	  "	@P% P3fSP::X#<Aq:ih<l:v; g=>@f@
<;=fBfB<><dD{	:6ϻ Y;sQSfAr@0;@>2fƃȠ@tI0fXffA
 <[ffIY+vFq_L2_& uZ=PrUߋf%   uCf*Pf=Q t0Q t(_ fuPDf
0"P`h:u-d p԰B#*_F&Z $nK'h't1Z

36x @ hRF F hCRPwXt5 __'a hn
ﰳwE&3ߋ

>et. h3@uKhg`Ԇ;.9cGܤgێF&% < t<ut
u8Xtoq䈰 et2u  w & PPXt'v
t
t@ h#% r/k hsRPr>u` hͶRs?u-]&>! rxr~{|RzsppZuthZ,uuh	r`	 `'Zjj 6u`S`` FƿF ph߂ ru=
Vy@ yVz  sӀ>t !$!$< u{C` 
N<̣2<ģƾ	$"3`Aʈ7vu1ņ|d[@@TYP=`lt 
uP2Ɋ،؎ e؊ht<u
ȵsӊE$<u&w $ěF"L  N L N  ؠu û  t  P؈[Evu
|j jɈgIl(!!2(<!`^6 Pcsyu$i0G|tY|$k|~}|.#KY .t4&^ t<r&.w 3.\  .\Ev.d b  0 W	x .|_@DuQ&~% P\PMXӹ
 z.:t
Q ._
v%XP%8Xr6%ȸƸ{Ev    PJNL p      QKOMp @{t  t P(.DG H_ hCܝ? hvsyY{huɞ huɿ AE^  f  Pp m o 
v %&.|t&ư
&桗r"sѹ$.:Dt1րKu
؈ Ev(Ap/"W s	EvX&P 3C  H mrr`2wth!dڰvߐEaVRQSh~guTh,J^.@68u,2
t&6@@t2 s `ޝ[YZ^Sû.(cvX<?tFhGLEvjjjj P% &h/(\ hcv$&bt = ;t= Dt
hG,[û5WVSp̀H1
B[ jQu"1*׿Oطh@Ct`>J=O¿t1 0К,?#- rhP0X}Asv^7Rq0]!l]^s:^ aQ%_ S^bt-$p<pu ʈ7v^ c4 u1G hR 0Z÷h#*<÷	E
u×he5R^? sq  ^߻ 3'_aaav?8af+  u@"t@"3P&&WXfu33ff&3 uFȋUq+0h|L $5[Q?  :NQ2  ?AQ%V 	
1rF H@0ǋVW 2_2v't"h 2t
u
2Ձ ߁
 @2u'2&&&E&&e?
td&Ep&&&Er(&E)&E<r&}	r'''VW^2 ^2*'
&}v+0h}PRQ3 70
t%0t21UY3qRPSQY[XZh}k$!u
g@lv6 > EYQ TYXYp_Ŕ-7v:g tO:Tv<
*6vh9&&  t8}V`t' s+u y,6vrBy{6$ $ `& &/& pFE`dՀdAe`P`  XqU @p
ڹ  .y BdMB8uwGOAOw;O5Ow/O)O#CMBOMRRWy66vPXL K@ApWBpWCpW֐WW~XÜV`tv6wv6Ȱv6蝊`<;weċS]X؊H<wM3ɆQ#"XR< r_YыƊĴ3уڕb8" l@[dcWIlhu@tJc۴c	c2Uc&6f}Pk 2J
{f&. F"E  濆&k !< hP!mu$f&PoBp$
ò 7u%qtfuhs$ݡ"&A@Pf  f#f#f#f#f#?f#f#4GfPfSfQfRVW"hf'D&
Lx6Uff
fh~f3f3ɹ f0Q f+f ! KDu*Dآ$a3ہasV4C\`ѕ a^p_^fZfYf[f43hJ
  !A`A3h┿tKÆ?q1tu*Sg t߀wt	t@АuG⻹ D
  !u| u
qt	 Da`
2A 揀 B`s< |&	3yt` u@uu  ;-&At
cmC4KBC Kernel: xx.Gxx
 /|`pn ~ؾh^0 t? p.`<3 2ҹJ%qTaÍ6r'!
>wzVWQء{ $_^t h=3hí u
$<ur r	.0 f3hh/. %
phftߦdw t
Ah+ CgTADh=  t^bwY-s.>Hpfї<:A t&f u@? o > \c Fdef Fc~ckp7~e uQ C9  hp_
֥FPhBFe:Ff`r,  hƃ Fd;  Q 	:  <g hto%qh=hXíaf`Wkp!Kh u>fB SCA[t$ ! h
ĭN rp@4f`   Fo^ïİ%P XSĻ  _y ,p   hZí[t(t@tW,e 6,uÂ ' îqh9
Aúߋw6.")**u/.uvv+Ë u/U2NfQdYF :uE14]!1t
t
u
t#u
tN `t?"FF! u3! :5tFFdz ulm `F: uYPeb + u?6F1erFfPf6`@up  jjj(j	R% 	UaURLhj#12   $pՒ1 wh`&RZ]|RZr@q  t0DCRQ QYsY2製A$
a !/u$6u5wZpf`GwtB`u#IJ *s! u.>⊴ ۳%fa0`7Rt9k  m l0tn ti gP sE" 8Hhr3P/}#rh
:o p %q 2B Z!ͱ
.uQx$<u:5p舝r"&  tB t}B t
4t ΁P u"z"ި p 5xSQ 3u,S՜[rE	ˁY[C
 <ff<J`00xx00`6|az|||.>>=Qr$.ސR2tR2pH~ Pr8g'G <a7= {&Ļ2hRí־C  E 6orB kEuN ?D M0)0</sA <0Fn7̳08 aUfV»3vCDPDQD H7;Ff^]`G#ٰ`ڼE
'
PduXTfc@ q 'O,o-./0t]A  "..& ~bf%pbY@ ||FACS@eeOi4|DBGP4gCOMPAQCPQ0058 !hxkRlg  8[ aPICZ?k[l"hhV!h| | r		|
 3hfPqnarl|	 |Ѓ|tw pwpw(uwpmPrg
 2[i RSDT}(n  lf`hthB4vf  fRԗf l  gfFgf | ЂFPTR ffggFfP~.p^$f3.{.xf.the#tgFm`gfN~$f+1h7qs
43ffgf&f.>tfff(.ytޠx2u  ~( N g&F	    rg#fffff+f+.| u4fݍ.>pfqwb$$1$P Xff-QñVV3g&fFgf^fY[P!ff=TDSDt+St#PtSBStf=CIPAtf=PGBDtZ`Qr>$< urU0bVRUfQъ̓2 tSPrDr vv;Aptg&P.XJf?Y8]ZeV_fWfV`f&fۀ.@خАl@wf fP}q)Ȁ$ 4 
Ȱ X@-X@ff	hΓ$ pf tഺƵhfPW %fX~ ԄpF gfxf. psg&\Ñh50`w@(_Z5~VVxy 	y{ |Ѝtr{|f  f1u@ǟDbi ^Z!RW D hN."7 h_Z&1PSWtǸS`&fP3h f&L sfuPp L fX
`͊xشh4" 03f1&?   6u_  ` 0OGfa3ۦ[Ҿ P@ӭ1U1  Pӈ >ٛ&geE E uMM0GfEBtXAt$OAt32t)O$fMorþ0mMe&a~enа   ;ø  aTW f
1h^ttտ ϥƿ@"ɿ Ɋܰ_h9~[XێË̌ӼRQhYZҏhA
Lf`FF  h04 ]u~p h
/cU w$w(w,w0w4w8w ȋÃ9FtF?fNȔ?F> [ɀ55(fa`~C`VEp13ɊMhZt

h"s;rVuaVWF~ ^ f_ fN`ф %N'f.9uqu yqt_( rfQPH_rf;^uf_;Nt7fArt  
tF~_YU_Zɐ!f0V8% t> fg?.<t1! Ȼh],,k ^_Ǹ&E00 u,h1cF..D+hZCyVWSR, 0gf.faȅZ[_6V!_fqwtA"p"  u
3A#  t'gfy@$GhGC~G$<lDPn PC Card Smart(ReaderLGEMPLUS GPR400LPSCRq b(()Q*LB REFLEX 20Q*241 PCMCIA*VReflex - v.2T.c!(r$/HP'.  a%@g&O 5Gd uKq5`5 ȳ rLfK s]\r>q5G	 .Da%
q5P:O@.d.D4fƱ7_ PQW 0`
G.g&:uG`8Y.5?_YX^8t ?F`8;①fWr59=@gH99U
99999#%G f_eL` S[ u#x ׹ pIIu6 .u  ~rp&tj`Ot_& rT  r&= us6>
qQr/r4.ኌ؋VpQ< t ^OJs 
t u v   h`&h/5(Cw@SW6Z%
h=Xa1INqQ6rPQtI	Xy |
XpQ
QtQo&0̀'s¥XGYw[ V
WXz +FdN؍vf fDrf +A fLs-<t(<]#0{X{ h(aL^032t
t
u
hXtrt
<0r<9w*tM> ʇaSQ `Y[,0>E*SQpia;| 1ltmu$f`3pQ& thYa֎fv𻿊Ths_gf9t 'a[2@x  x thZ=Hbew@gxgf~Vff3 "(т!Rf yf!
c޾%f3۹: 8tC~rkP #trAh.s|f  u ' _  00% ? 0    0     ' ' $ 
 ى/ bFk$0%!$ Gى k"ъ!Z_.EPBVW ׎Ǎ~Qr&} uBr	:&_^|[Ҕr5#Ör!̿rAE@&=u	ըW#Hr&E$hu5G_ZmH@IӆΎޣ 
r{ayr[PDTtr&ge oD
T3
ժKS	ѡr# t itct t$җްkffL ]`WB`31]
`{  @I+Wz  r8uAT_QY_ܢþqL[ r&UþN׀41ѥLCҷ
P$X` $2LpnBa耻<t%HPA8u6
uB& DBlмdt
`&a@ 3 r/) r%BBnJ ư
`; 5 aù<t
6BȰÊJw o@uH` ɊBI2۬2 ʑǞ'u+BIɄl&2]ȑ8uSË\m ri@e raPv rYvñ@ tAq> f r2?a r-&ґԿ$vQa> Yr	2QʀvWY`֬B0ڰAۀBor@ܠ!     %     VQ    P`@`;t
YY ^NV^$TBL$PCI    P  $CLM"    4$fptqfPfSfQfRf3f f3fg.}	/ 	@ 2 	fƀnuo 	nZfYf[fXpWUu	  	3`r]aq 
#C
ERXYgc> 2Q`ް(Yùm `ù DaV  .:u.n!^$%f_Q8aY!fQRfCPt
' "`
Pv
"O2ɵ PZ t"
ǆmWPfP  ؊2fl 2QW pw	t
2$_Yôq3f@
%S~` [Pp 0X.
tÀu@u[Pf
4 	g*f8 *a,Rff~%fؐ..+.;w
Z
$Ue <u
`V`<12a2@`|<z@=q<@]Q4f<	@}4[<
@4P<u@4E<@=p:<
A47/f= uffX<@7<@7]]fW f_2cpPuf_QRfVfWSft,fff ^r!fp;tftfN77  +[ff_f^ZY^>с 	 r?prf r ;u*A
`A0BBC= @	ҠH sQ;tp_r"R{< fR fZG z,X
[2JʲKL .ZLHM	NKOROPffqM# PMLNKSS RLOfMUPKOSOLYZXV>YPsZSP[SfTRXMf s#(` sf t` s	a t
 `QVWf&? f&bﴉ3.fSP&Gf&_fXf[ ` ~( p _^YSQR@>fPw&fd P g f;t
fXRv39W
ffff_fBfEff#tϰk f_TCM!p߀MQfu`# P"f UI8s2ہs
Z*SfW`@)6-y`t#uP{aHXt}xPC[PSf<t; /30e ts
Hfu
utǳ%[`3}aPZfvl`_X1e'$PIR    $t` a b c ~`b a >r i  f}0 c j !f`hktphG6'`  0 `%;`0MWff `_p
t_nfnf
f`aV'WH#gSik}WԒ ;_t[lPmF?[_^qWp!f` f8u cfffGofY2haܘPC
XPS fS[~s$fR$ f_fX$[ؒfӟRq1%D Ð[џBS22EޠHr'} Yuf H8s֊Ҋ
XQ iRP
t0kr?r#bEE  uf }úM % UPfPBTZ+]fa_f]rffr%m?&nѨ@..%f [,SfE.80@%D.%Ч!,=dr!stR
"誱_ 	f^ i
w tv;|苒*f`dk 	w1BcAv *)u6	B+	gf;N`f f{| 	Bg✯>?b>?fUf3Ա]qUfŽ`&С證` 
q\N˘qJN~ov"xof@Tq3pvbM*Rff> fPDWB< tG+Pf _te3ʱ
rI $PPP%tt0f薱vwV1Dةq|us%ɬష^ r?	gBc`Pr&U 
0  +؋ذ!LP Pc` 5
'|Vt^Ô0f.RfJZRUQf fuffVfKr=XfuNVFYQku F{MuY ^Y]gs><afPRg'QSVfNVFf߸Lx^[YrfXftA/3PX1MMNAO5P>hUWVa spP  ֡ Qa_]`phWU*2vq! ]BpXRV 	^Vmc  	o	 /
Oo
 /Oo/OQ%`Sp
[PS3}
[
u

Xl
a .hW_`p&
 *	u
 tw"hsɄ3ɺrñapi%ތ3t q(=30K)贌fPAMS 1hVW  ЎH }  $u
  P~0,  t`%ʆ \rr vo F0 & O1
 30&O՝a0˱071FUWnb8_]v
 @2`G_^`p$%%Ћcap+Wp_7fppw h؃-n; MB RW -! D n 1&FGv.u=v Mp cP$u#' EF? )&B
;uBf3 Cfu>B~& 3?_ B?GF< uG u2D %|p*ð I$-w4"r.-@Ku4 $
 -ְKr؊B*fQifSpqyf8hq  fP @fHnQ PQpygl ff@rMf[$5f 0pZ%U;tf@Eϰf  fTnfX2P*_@{@xp _ú![	Z[1Z[XжP`d fw@u+
f<P~@SQ0rQe
 |@$bp2`BsP_z`3aajcdy92w`ff۹" QB@Y`ffhfaRWf`3fftf лOuӰYð'@$}W9ry-_tpP.?g /cK/rQa0L G Pⷣ= 8 3 . P·$    ۷ᷕ G _Q&GYhz =o sj]fP SQ2gY[$
Ƞ	fFf 
tN8tSFOt@PV @0{ tU0 `"y  t t	Áx]aRVY sZ v0Z1{{|P}_$~4-tN`4eAu4fa2tFD 2 a tfߋFP G^DƎ s u
fWzf䠜  #q{fF$F(F,d 0!҄rBrf-!fv,v0hfN,s-10nv(՘Xd($иPN$fFfV fNu`2N t
ffFDlDU fbj N xf:@P#f#ffà0fHfVPf#f@f+¿f;FLvLfFPf)FL0IfvAfQI PV bB@wf*sͱfS faNXfեG̠BcМfAv4!;Vt
fAШĳj М f%pd"+М@dS@"	 "+F@d@0F `l'3@ v tGCv}~f!SӶ=t1?u	cY -
[`"XãS@9#QWa` ߀@f _Y[hý ĿL  
 ׀;
 }@0@Ü [8   0Pp2ai~%SE 0u˹h%qUG.]3Wz\| rf%VpҺUCESN  uIfquf#sfVQ<t2f3r6S+ f!u g> tXt r `YaĿ u!yYqf^w.%zAؚfpv`OڅQ1-۬PnDHP!tt
Q!r2fp_Tm! ֶ8~-<t(r!f٠ _/ tڈU`-  蜌N $9NlSf#`lA(  tu
@(u$uDt@tot tjP1Xr`RO#`GfZ3 @$
pM˰,$t pM˴yZifVQ! fP1@@Yf^&  yѽo$v2UPBWf˷@618G1S |cfXԂ	ش _ [#+pfVW~W2_ W
t<5t^Pf~Crf^r{/QRVpû rm|
a?K}Y V O8u`B!y^p$W" _T*u	 E 
yjt&)?ӀuB0$&  5& A)u]&Au#
1Au! À8q U%X }  RtY#vMuG	l$u<`$u3#uO#tBu}# t'#(10W> a$#$:u@-8*6R:EFu  $E@} tTt̀t߀EtH0*71*0*F )t%> t:& tSun$Eru-3S#a$#p /A .  1$E>I08u	PXuP3 t#,X,6(t& 0`'y#E# wu#t#]#t0&)6u qT=#E0+x3;r.Dv+WXu4&32&*?u!.ð-&s1&	C'2FB<Gr<oSv@: ,Gf.&/]f&JE"E u'
<.r`+Lu2)0 *2K3L f?@rD'<.t<+u
0 uθN<-Q" uJ,0r& 
6 ;6 #$Ü    C8BBaa輼a$at@0XFfF͋N
~fE F N3 ['G\ȷr[np\[ ]
 CZRQP~XÊܹ@HFFYNZ2ޑbb$@`Qȴ09Y`Њpc  aÇ鋿ً@t&"ԃpm& & Gag&Ď.&}%'@'hQRpm Zh
 @f| Z@t jj a` XYZð
U _
P `R|°S{r{ = ufh   XX؋7[	 ؍6 @p w P Q bp
0eP÷ 	u`D0Da@ ؀ `
hUЋ؎`u]FaQpWD3< t
AF !q`P{ y*|#z[zP{`m$j9SRБpZ[` $<u 3 0ؾ   faÃ3QS 7t1u..VQm3q|AY`` 
a3RQ3ɋfဨa
ԖRAыf;v+R@fTYX0GY qÜPUfWp jи_fW#] f_ff_]XHP ~SIMPLOMOTOROLAs4Í~ЎHr"s u
 &Cs7ллܙњ)VP{b`VS53øs˻ʆ`lu3 >:>1Х(Х﷒ХХ
SR!&3-&Z[>>~ذŦ a
@ t+r覰~苰肰ysa&3&M<St<Mt6k)a{6}
6Y^Vr4O02s*פځ߯>րު̀1ĀjQ뱨 aR}B3诬í@SUKQBU9q0m'ĳS+ôɰѵ@P>&~X^f <@ ~<@ u<~@ l<@c<@%Z<	@?Q<
@YH<@?<@6<
@-P~qX<@<@/<p@|]WfPCI -謅u_aVWfSt$ ѻRr f;ttN紃P2"f[_^q6ff`ro 腠p{u
Nۻ- 	 sֳ r 2P3},RJ,Z,ȝXKZ0',Zr,8f60,PfXZD,f fu930+Z,[9a+R+Z+F3+fPf + s"`s t sp  ﴇQVW&= & s &EfXQ F# _^YQpVWPwQ`;t
X2 *W 
_ 0#t"X _`[ÃN s+ѿuf fPf} 葯f@p8s2fYZWV. GF< u^_PQR׺orD.\ q	R{Qn{0ȊQn!q lȰ>? 
@
 
?诮p	@g蓯
 @ga
S؀u
7	 [PZ P~
?Xb
 
b1!
X( 
>O?a
8RP
`bt_wZwU
uQrEt> r2
tC r r  !Q  紇2
uCGr>
1t
@
 1rt"rG y /Fr*!r#
$۬r`e%? 蘯%"诬]5U` 
  넑--  t3\!\b
/
\e$E?r:W  2T03_@OGORP5/Ê
$@@?XZJwt'Qw3(N&A #:u2ltg't$<stjvuwv<t<ta'vFPF^B WXF;<q<3tĀuC2F <orq<0"<tt<t@[vAv>PAtv0;ivumGv <t]A<'wVuuu~ uP$<s?A<w؀<'s*Ca߃f ^YNuE 8u| w&|u@# tf~rO tBrOt tPrOi tEarO^ t=")Q t.q< gPAu<-tu jLr ??u PAluG F 2vPYX'u߰0J/ PX[FF Pp(ut zZ
u^E^2f`[E  
Fu$,A3ۊ^Ðv<{MNtBL$PP*@*
BȊJ @t2qO123q<!q78 j hbxi &g +Ppa= З
u
0@Ϳ1]Ͽ2:um!pTkqS\8&&G s&G&G@t @t [ !uuuU ovPv\&׍\ xЗF0 ]Pk..63 и( Pl  0 C@{XWPlߠM3t u*}O $ }! & @: _蘳@P~@螳X򀯅$    SfQR|ۃ}4Ƒ}u~fufQݩfYg󹝡@[ø <Ȏ3]Ou? ffPS=Au@u;Áp u39 u+ f?wufP@ulXuw
_ f[fX%[{A8{N{S_{Ȁaa7{{aY6{V$`aa9{؀{{aaaa{{̀
(<Pd9(:p::::*;; 0{&0{ W<orlq .9_S߀wh 
' t r_
a[e \u0^r!<u	rr& _3Ps" r2.92& r5 s   q8 @rТ&& rr	a{ôSs+&' @>' sqv~@sQ>[q W r%Т$3 r` rȁ	 ~" $ a{Q0Pm S/X ust sA@@t葦1d:` !@pt t?
@u!PYÜP`
 .Xr_`QP<Xd
P+1: Ot	`2qq4d$!<!t_`a@tPGXfVfqP1f[f_f0RpnGf;t !0Ef`Ȁt s uf t?rau
 A)faUQƃU ]PE] < tF
}0G@ߥ{pY]}G@nPQRfvA
ˀtu J2 a{ ^o~F{R/ZYXsb0+{rgf5%f`Xu :P`
  Q	 F 0\{ w(޼c@fasƐb`诛z   Nff3u
!t2P1ƹ  f3g.}fFpȂXdaC gfff0^zSȑٗfPQIy!SYSRW*O߷I  2 {53_wRWQԴs5 Yt`3Ou3RQWSP $PX Q;FYl@luusX J3	uX( V_ m WPy[_YZÃU2<UuX5蝡DYJBBs
p

 twrDap	ΰ!uP|@E@
؎"XS
u	 п  *ê?p)VWP Dt!WQ:t
Tu8v
Y_߃5Y_XY_^Çl  XtjrLhu3pqt$t<u;73hs.ht;ߡB$i:aBY?߀tOBtGBBt9t5F  F  
  P9hu<IuhrˌN.TV
3!hu
.hr.2^.ln%LN ]-h?̇X',hVi@i	'O	O"O<$OICV	`guLgrxF0<u.;Ttqb,tG`,,Zz.Q.HC@}0Ge3,3[R'[ZuP.u19
(24E' .#|0$0i3Fki6b4	PH X(' )'tOTVA)p)O"j:/)*I9LcL<Og)gR HfEPAgj  $PnP!  6D WD >D0kjAe?fPff  @ fXtfUfC P P Ntg]`rfw l @qF?rd	aQȡ܋fX]ge333rVd4Ad^;sgu0L
 0JLs M pFtAt<V0KdDg}
^PPOVWd_^gEdTg} LQ
&M}gE PNtr0K0Lt}d8h W<ytu@DrS
0KRQfU@Rf]3
?t QTku Ó' 	a.;GtG._PpGfg6$+' +k`䄖`<u
 @&   >A`w@tA`AuaaaPk@u  ,]!d& XaVaab  0`O  r
aaa P<Fu@ uXݷs	sh aua3ku	 X bitGTtui6FtEn0luUSrPRtKxGn2qt& 0R] Z`Duh& h&s
XuhsX&  U au_@ aaotplPnpafrr
rr d P dXP $& 8t0|  p{QuS|^ `@miM8`*#~: {|~|Yp{ߗ @0}@XPYÃ.~Pߴ  `31$:Uu0Ё&?t+a>.}
t"`	
t> .:Utǰ_b`v	 V tVR~d+ZA| u-$<t"00E} u^^0Q |@ظY3Ѐ u KL$ks2t*`R_@ .u 3ێۿZ
t "uuq 0
 uܐ_'ѕ֡
uLP2sp_uњ!uqPs4XPt)&S`V0`1
[ub6!uwXÑL#1LdrLP0Lfd(frLd&LL+ MdMd5PLpGVfd <d;]td|d]^sP~vЎF0^r ~vFUn ]~ 
 X? 3
' '@ F@PF/[K3.;v+GuBG
PF/p{P Ë% 	@XVNQ
 0uNY%'@0123456789ABCDEFSۻ7L׆[÷McMqMZM  A " * Gxx  x y 1 "Ϡ *
(xbx 0~EǼ 	 ŗ_ Ϭ8y y `b é u{TEРذE
U`[
 rr t
rP0xf`li2tW &  qQ&E3ҀtB&U
&]7&E@rûM`u &E0!fa*578F'()+7
t À^ v5uA`lw `
x_t^t]t\7uA`tFr5w3< v
<ar5<{s1$sPɎ<N X0kwôr@7Ѿfr9_2.%fnk~qG$nwun@t<zw, 뭋t!s	둀t
w
_fb2]ofS ?J, E /n\2)P
 CN0 trr	P7QvPQhIs	} 	EP `@ A  B C PBQQQQQkPyPg]̊6D t4DQP37D@M]!Y
P uP3DL轲 pLSQ>4Du5M)ôu蠮% 蛮r<N3ɸ  3Y[DSRVaˈ&=DbXNmNNwK ʚtKt#E8>]NO=D@00nFNwƝ3p]3^ZIXÿ
VQ$NL j0uۇ 

N`r
- ZM51 m`4y
uʉ7D4D߀6Dr~V??IR    $AqA` a b c p! b a e?O i   f0 c j hkt!phGaA
`"  $0! "`3. W ۀp
8_ϊP
`(aVWQS߀;\pRt[ 
 P[_^}RwW3&` Qdu t (GY[h0-B-ޔ._ZQSQV.Q 6Q.Q^Y[XU uPXd]<tJ r
t!Kd8D^u1RWuaas927T^u7@1 4`|L&
yt,ـ/t&M1&G&a-/`"ȇA<<LAAAa+Íu 2Vȃt
CDqC܈$FKuðWQY <u	ۍY;Y_F׮uGHS؀uPu)4  KP.
  [ht6ߍ<upM2hvv3uh3uW/uts@q1qMjMNNyss At1	s
?2S"  |  DР.D
 ``U&&D aø0 м ,j iH&&E Y 3Լ{h  sqMͧQPUVVQ^qWXY}`.\.T@VώǍ>D.LPa`a.D`aQPƌPXX 6aefgVVVWVW1ưVVwdŝ , Ãu<s/h+UUu< cX<NXu~ ps}0p: hA;smpP.hv h?Bu`LfrYCq`h'r= v O h/(raP~P/$@<@p{fQfVfWfRf   WP.bWfWg&`Lbf@fZf_f^fP2p n l |}}@} #  賓Ȱ螓2Ҩtð
菓@D,P芓胓|g$ztఀføO
!X?а8	12*s s	2 ' | 
	`p{2Ѓð֒ tN :@Ғ`ЃĒ
诒$
$^ $WWX9XyXXX/YEZYYY  M= pGp" *UP0	0ѕQ恖r<p^0A`btcfU]p b׋{Uo"/k#JRQD%܊̺ (AYSU  !ZPP+pSf3[ff$Rf
$f?X$вfؓffߋƫRS%  ЩfffPRWS22f`L 苄r" Ӏu 8s܊[_ZQWRfP
t)r (ff  u 8ufXZ_fYҿ4 #v 
t&PtWQ3҃rzҀY_ #\4\\\\\\\\\\\\\\\VS30C.:[u.[ *Kp[^* UF.!\2SF 
VS.[F[C%N[QF*?tB[sF2~ tׇYpİl7B$_ø8 
B:d3ɜd 蒅}A`t `f$ $SWQ Q`tw7Y_[/ 427)^ӆ]]?]]]@8r鿮 *AçO]v?P@JDX$#G dvdAq$e 3ArUmXg"wAX{ۄ(rۿ4cA DZA EQAZQRa_P;A,L0u6 aa$8uP& L×XR1= u40xQ Ã<Yua<u
 u3uuu@VL規ukuf⅃Шu@Fu5T/oKQ____S e "S ֚ # DPaR~UD2EV"!Dס|z+$ ݤu  `t``k`>   "@ * G yocT~UFC]V@
M#hס޶3W$ 1  &E'ڰ
D  D EZP JP US_  US11PU	 Y
 US WUS@1A1B1C  kJP JQ USR  JS UST  JU JV JUWX1Y1Z1U[1\1]1^1_  a` aa (bb bc bdef Glik`L>_VY-`g g}
3gE
 t04"6MDl$ [gu<4sU I2a   
$Z&E
;E%%%FW-B""K3" 1>]>f`̡PtO9u (g$
f -/,f-Pô%f´+ffffaVWМ/ft*0=2-f$t.f$<4ȋPlf`%M9-v /V%P+J0`f$@fWfVSQfVF! <Us^(2۹  <!F  +^D!8u3cf^ JW9VQCuK9! ذ;Ӹ!`<w ;$I^:u:\!uT: TrUq=f^Y[_SpL[dӆ.
tذÀu@u[+2,EE8,'obe$-@eD.&LH*e/  e 6ee1R1 e2Hey4&e\5Z266)67Hd$dIdd  d@Kd$軡dPRZ0xSط$0<:rd u[XÆU÷wH aw=V WQW& V P: fgfF`|XRyZÜSt	tv
\vt[ÌȎ؎ ЍRhe_Q.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRS_fV~ބu|11t u3N@f6 V1u^nuz1u?N1RopnN\m Shg1tEr2u1s1u&n%1t!]1p
Xsu
]]f^?TvTwTzT  	     x 0y G$ $  GN N  GP P  Gh h At t{   G   
G   G@~z\{0y `@V`  Qy q!fRfW.luqmf3gf&ff=SCAFtVG t"ffff Wuf(tfPf6fXf_f袀tp Tu Vlۃx 拔 tcPtpr>prKXSB$x$PXr$Byu! $
BB
yJJ4HX^fuBf=p| s:=6L
LtffFf fBL\r6>L t SWfS f 3f9Buf[ÿi p$м  .>K+G55,+lدr  
t4t p0掊+2撰ðuTf`0D Vfft;  Qf3ĽYp,vЙУa? eĐ1fPS^ۋ^&t$uG&uFtt] ( 躼ҫPoQd Xw˻QQ3ɀtUw7@sB$+rr
`r`Pҝt"
 Π  ௨u!p!߀t  &k X`P(
Xu!P<Xu @PQta`
  Pw@~0waeww	x"3 QetCOMPAQ
 
R3҄ F  tZoï /Ooˏ̯ /Ooԏկ /Ooݏޯ /Oo /Oo /Oo /O o /O	o

 /Oo /Oo " /#O$o%&'()+ /,O-o./0124 /5O6o789:;= />O?o@ABCDF /GOHoIJKLMO /POQoRSTUVX /YOZo[\]^_a /bOcodefghj /kOlomnopqs /tOuovwxyz| /}O~oς /Ooϋ /Ooϔ /Ooϝ /OoϦ /Ooϯ /Ooϸ /Oo /OoǏȯ /OoЏѯ /Ooُگ /Oo /Oo /Oo/Oo<V`VDH       ؀߁<Q7h *1߁*1DT`ur(D
@ JvArHvA.=sNfj@&t FN aR3V.vZr# Mju 6ur 0t 2rYP u v tpr&4&E0r_"(r$}2mRs ÆUu
FUF ô	f!}	ԕO	rg@e"g!5	pW	^F&?s $s& % &G&w&G %OD
 &	G'fPfR.Mf.߀u)E	_ff&)wE%*E+b+++VfQS/fD[+fP'fY^f& u#f&G0Wf1Q1 /WfZfXP'F~r .>_x؀t7P4y4/r?~P t8P4w tR4 tP4z62frV7ʀs{~	@819v~t$P:tP:u/~ǉ~ %3N?Vp<3su;^<Í6ٛ.|uLYR..z`> .:Uta?~aOWQS.ن? t0.}u.:Mw#.;]	w.:uw`Cw.;ww	 Dw[Y_P t>ـ?Br.u|
ՊGc)Ѐ ʋ.Ev p$fV|fv )dD!M IFfH
@NPPK.eXf~PȋHBs$
2~H
=JfX!MYKdDM!OfPUv]f^PR-_BYYYYZXRPXuUW:>_]sr  ZP$<pZ- r!P~Z@XuP[>~\ \@<@pZPY 1sXXt^y>PeDt_ \b?> Bb[\   PR`ZWdP@ ءf  X?rarTrOt :DvL*DoQlP umfmP:
u
rP
l
u2 P5k&:Ev&MAl&*ElmomozP:nZrFonr;Z@uu gBvu< r
to@r&wtpu
gZr roR^Xt2K uu@uu~ u2\S ذA[XPQc6Pǀ @8<tPp<[YD
>X` ID<7Ƌ%a`t>P	 C@@p$Q+r++YsaXt!$!ߡ"桡Zgf`ZPQȎP:Jr#P:Mw>lt #A @2:Tt
 аuOugYQ P~ <s& ? E\3pp >ٛ}uИ  
 VWf<u^<
uuw MzE<49<t5$SAB
[|u |
7|P5u5 t\_^FS}
uӜ}	q.O @)򠴡܀} "a`螑0uDad@QV 3۬`+^YD0!)G{c+fQ1ff?/bffJfT1N
O2Xpf F PX`ZfP~~t$=r0&Иw)0Efu1fuP:Cu~EpSVM|ttt
^[%\uE20%`URfQvV ufufYf/Q=fA<x1 uQ !qn r.V sfYZ]Tf;PfRff;{fZPހWf!rfhrf+f_fZr
8pfSȀ' r#Ɋ|s
s
<Sf[Gkζ_Ϝr rBQwʜPׯXPQɴr Px@>Sr[ɩ"ەܜgTڙEzczҏQzoQPfS蛎ff[fufXE t ft/+f #fSǻff3ۀfnX2ZfY1*VUt?$73tpv{ð-r@Wľ^WV` fSP~WB Q Y_W}x^ eܐst/V! <5u G	F^;^s.
<5x pokVX= Xf[2PX^YɣWfVf  t
P E(r&< u 03 _(PŲ߳ f^rY P93x3Xso ke/Ov.{PZ
 $ t`t {Zð) t`SYBH{u
 %QQ$
ǊQ*Q O P$P$ )Pd)R>>N Q3""YQ
t
t
zda$a&^%3ð&W())v F!tt	*tEPXQXS&X"
ǆX[X-X <t<!t
<<*3R )`@"ZQRs_	00 Z) ð  VP֎ލvS<û	 X2p^ð,RP4&4P4!RP4
VfW u؃ tvr
D̠1^ p5t9|ਐ>|> ˝ $><a?<a?7^P.pW ".mW|W`DNb1% _QN 6D؋0FJNZNJE]u {XðRQVWP>uX_^%VWK PL2LP߳Qj	؀7ð""dS  [tbN2JPRg?
XC1t0q&[ܠ%02yp4a2%>ʁCq o
P'b7f31	(Wbd%f  @ 谘 T	߰eShr 4 撠q	ٱJqUtq$DU&] >?0|͸`ɚL|0I <
SQRs3ɺ	ZY.o
X `.oƅafV`tוao	r ^"r" hs + h@	pqh+"af^`po*2$ԉNT@׎Ǎ~WlF$
&пFGBp&U_غ`g	 q!a8 !sSR,غ*3% Z[QcW  t2_eQ[G0w~t Zt
op褲xpv PQRVpo6f `Tq}쨀t|u}T~^Z`g Di &  Ҹ
SWd0wɞa 1`iu忌t;676 6 D͌3
t,=
u
"=

u5w<t<u F`<qS $s
Ê& 
 [<ua,w\wWQLu& R` AI<`'.saᎿY6 FF';Іt@2vPF X  dtPpqD3]q]	F
t	u%  "]g ,2Ot м  /rᝰ8p)tlFpoypOIEMAG  IZ P  A   	
?
 [ СHDA-L  H;DB3A-ES"C@USB-FLCDHcLS Intnl ? PCI-AѮC  % eOj_iyyx	uP 	/е<M ;;c!H3ֵU	b ` @ ! ?.CD001EL TORITO SPECIFICATIONҡϼ/IͲȨb/c*dd˦.j)j9tP 2XPUv F t	F !Ff ]XbX
P3e0PRuffZBcVW߸aZ ϑ#>Lv`aZ 蕑@aɃ AtAtPS ' [X<t#<tQ f1; !PK<u   0$ ߽_aRcUWV    aZ`u̐$6s.a;u uj@3QuSF!KՃtAX؋  ы o#и@ ސQu?rګ߬^_]dSG# ɶ[Á3oxupPjuAaZ o  Zq*tVQ@TPAa@ SaZҗX"PpUf ԏC@QRW`|{x}H2~$tu@}_3!Q}g$9/Dy3fUfPPfXZf]fff]rQm  enX
R% ,a.8%@@D@t`X_3_2_   r_SM_ PDMI_ >  #f`Eu ')$
)u&z)ô#p))f)fa1Мn)ta)$t7T) A	ȋº If` u1!)())( #(@)$(f{a!	*P+'@dTOYu0$	!sL D)C0fȞfšP]0sUSP PrX[%#<ucrh .p]iGuESx @
߸y @55I.ISz @L{ @ ~ @ @[r
}@`'$$
Ȱ5P.PI$
ȷPM D@\rF@P)?Xy#@;r@'%@(ȋȻ")?r, '?(fP}*ffP+d+#o0/0zp/R	1)os=oSP	 7XP rX[1< |?7` $$iu@֨`uph
'3^?n?21h r'7x?tu	iQ?<Xs:><;~@= V;fSq˸'_ ?[ ?e@kx A2AZ]BSRWP<u̋2.)  .E hu4`  ӧ 
E`E kE pZE3 YPH PH =E PH~@ PHL|y rt&roMjrey r` [rVj rQrL rG rB =t r8 r3 .r)= r$[ rqP I r
 rlZs_t1p	p<t<
uu5(Fu
#XX: =9b2X%W	u/><t,`0t-<v<u`X/<r<
w`#9tX	Y4wV
__PXEZp/
t	``Z`q| w<XYS~%UE"
ǰ \Evt2M<eۊܠfO<wu.!
o#EE2iEEaRts@ ڊZ[slZ[T uH`jD؊Ȁt, sl
{uIlrq7mZh1uW!= 2hf[eTDذf`iXDeiQDC۳`j"jf8Pv3DBDO;3k Vkkx1llFmK߰ ٬1n?f:tC2uCtW%زoDpxp_dr^PsOu=_u8!oho
ً@:Š:2}~w:03kURqu<u7G)|)p7:0:tooʀo0Z]aGbUps1lUq ]`K:Ѕ.qKx1l{׌Q3pY!`tM M>rQp4Ys. zEm 3ɶzZ[xtHBPuy{sUH 9?G 9{U葚L 8 K H86{ N aMCqS	mAjA@2'A83k$PMM w: pNR9 Zð@1AV
u$<`薋'ð` AË tt	@u f
t ڬ 3R $t
& ZgKt
7Ku 7&ۋwàBt'`W!&C 0ttĀtr û@ `:/j >N w r
?u ѱ^<  u'' t	3rwu o (siq
u` )뱳2 _B<該BDtkW艸EK`:?t
T} <`s /Vi 2ttD?@R 5H I+. uo$ȰttȰ<tP~ S`:8't
'  #lucs8tKTu<tB<t> 3>$
n3>q u) x>   (z
 <z3%>$Y>P3Ҏx ȫ0 hN.v 
hoɀ،_[a{{ݯA*qAAݰJs@PUFF
]X `j j 쿀v
)Mf.N. JྶT}FP~rp3@o^)tuw t&Du.⭋^^t<a.@t&ڃã.^2Ȏߊڀ3616^2. @ PSFݻ@g0'.:t	tX.3_0gepgUUuf   p5 f   E2f<r-s(Ӱ@QКrr
 rR1VvF\r:Gs5&DC H PrfڋykQ_ AFF(t S^$:u [r
F&F$%&=vHH&
D&d̠u rcwu
 !πϠ!&DB êĪǪ׭` T>Vsc  HUSap评1s!
 -s fqt
 E PF  &G )
V N8tr>u rG mo!F) r\ A{r= r8rWsTsP#@Rr
 ;@oMSa|`k 1F("r#謂Qlro@rI2<> rF( &dKV& %f)&t`.ÿf`g`t/7@t 0(T2ô$(>faRVМp*'t
`)$t^ZAfRf` u'B`)$ $$faZgP3@%2P    X& @F$$<r$:u s
jút좌 
   @^38  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (P<$<'E<&f$`
ĢF%lѐ$`B[G B<(0ø fF" PXQۋN8N`NГ o2N--O-!`GsH-ßGHmIn-@
 r
sHfQmr77u&-dfY/_"&&%'Á3bR&u 05t36rCE VQB A9O9 BY^N 4s
3
3u3`Y,dS@Q%uè0àt  !'&V&T tu^
* &u^ôp po  fqQPXuN%&:Lyr0PQ* r$C`J 0@uN<upZt+Q.϶@ Òh; E 77p+$<@tgA9Qj9" !$!$wQj  BoU0+0Vùg
+K<P[bз#*E.øJfUQEufVKrKfXfugfPwNPwVPwFYfu&gfFffffMuY2f^Yf]Ë: 3R)QSfVffLfTfDfLtf^[YrޠxXA3PXføMPøNIOBfSQfVfRfUfWfPj0t3 0 fRfZYv_f]fZq{[PfW/ t0tQ uUP@XYQR   kPQ `YXPt
 t$0t t`|tXRfVFtf^fZF*TVfw#t   r0{ Ԑr	0{ `f^QWVKǑ}^_YÐw.VW2! u[!N[P] R Vv 6^N nb VI>M󤀚R Ub^1{_f^ZYpV3۬
Êo^qۻ (e -rg $p0Sf0fV1fffa[.6+fff`;w	rf;ïwaf`fXS. " Eu߸ Цf%41?^oAR0ze$''ذ1000= <r <3fȐf
ffʝff   f-   cDfp.W>Q\3&G;r_1SQ <m  `2S\ Q	t[c )exfsC3    )4e f       PSVз-//߻׻^/пǻ.u/&&^2Q pf@is@ ŀ ʇ@@ifYX4Z4f4fZÀu< uEuPPu,uZHPPE EPP runtime BIOS - Version 1.1  
 by=b־$0@LX[^wU ."] .ȷ.ȝ;c;3R.ȃPBZ@QR Pj<rt2[U$ԁ !Ȁ
  -h?۸" ZYSUלo$!$ [vBuR״ xuߺQ
 S5,.4V 1	~ &n `.
n&UW ٷl _Z/ u
BJSU@@SR 	S<rP
 j ?G 
t<t  ).>  \. 
+vPv`R3qAB$ԡ3ɠ4+3ð4+h ?_@iSQuP`s"$@AX鄿u"Y"@1`"p"XU`ޤ<"$SC"S8`tu
q`9$`
,RVސVtf   ށcރuQ <V~eV <WeU  
  #T `![af>f F6!_s >up\J}>Ffah`wBBtݳf  Fd݁fwBFR.J>J u R1u蔧KR
iZ_^Z2\QԆV_ޑؾÌȎ1 Sr. uo ؀ˀa! ''u	!3r
`[Uf<tz r	P]íU Wp rВ$&&?ĉf!))~#*N#*Oeč#*qpҒ++k.7x)]e.!Yʔ,OĶYctwZĿ,P0:̑8{P+ĠϕP+c.fWsA!<ufl,`u#XlX@9f3gf&ff=SCAF9f_U< 
 	<! F ]W  <w&з'V3ɊȈCF>з1?^	  ?0RVV<v^.>
tзb@ ؋}B`#$($&],5紉UP XZs.V OuC]ÿrrAJw1'  '?"Ao]KLr,?]?cc?1'M^ 'M1'6	L(L-QWdSvn12CJQf:r2"S"U&s*PYUb\l["2ɵ"YùU١ݜٝXT SYYӒ0f0RVfг f90^BQ^>6׸@YYr`_ X0hj3ɍ6.L.:Ls&@U.D@U.LUs?` "b@cr2a0f!b2b߶ǖPb߶ǆhq KͿB^h$b[3@
tiA	
u! $R3ұPA	u ^ú tq>ٛ.| .ߛu}rs s Jr}uL !w`3}p!wuvrbWv_tUcRQ"jrUKjYZ6	u>^
 .D +b}t#V;T"bL7T^&T.L'T %b]e Qa |0Ys  uP:	 t	&Uu" Ǎ>D |  Êö.f.|f0 S.|SD\VxykPQW 3ۍSi_`  
` u #з $t$?aqh@ & r 3uR.R3A' $p#L
tI<u	.7 8t$\ ptmqpuqV $
4 0@ /u7<<uذUNNNOѝOfPSRtt$!ZQRt2M4ZXóA2۴
|~q$茰kAD#v+!0!t"Ĩ@t  
 ް  XPJXSP@ ߎ +. s#. sXP &   &X[ó5P϶.4EG6Oa1pσD
 uj@ t%v 0Iv0 t ArMv .sN-f-&A F'N- aύ6 _`
tr r	
F (|r
	u뿋^'Ât %轚?	xA*ڕ!trP/5rr[Qo
u< r<0s<"N@@tN \!
'P$nvPf<0 
ݠsP<js>uP{`.
I.
{M.}u tj@&u |t
` ^!N%V#~F`}2rp; sCs6< s
	OtE""Lt*$Ot"#Ot%" 2䒸)1ˀ  .EFr]RsHs1I9 <$uw2d*<#u"0<<v<%{2;0 
F!UF%z ËF~&=r&0wvCfP&M@:E&}CfX§sʝӀC^Ë^63܋F'Mrfg	DEĺ~(LuTMs fPfڋ}3r1r.  .GT  M:./M3V#:T }<~'t90LrEE&DDp%p5ߺLC~ 6כu0]Sf.f&]f0 [A!A'Q;  'r}迵rxtNrlFrd|tZ+r@ u~ (um-VƎދo^YtVffmruFr Y螵r)2r$]葵r)rrd谵_~pq rw
u fSfRW ـ?f.Efff׷f±
USffs@r̊MF F

tSuNff3f@ fVٛpW*f8f'w*f'F'*2t*܊f
VvfVvF`PFsQU n E]YRPXtUW:>蹶_]sUr  !AZâᶃ2_BPP0Aюً PopE?B0A1p c mo Ϳ གྷ # M #
t #P Z^Nz # t͆謳r{| rv=%>= ˫1SW>K1ߊ, c5<s-ٛߊO8L`
t" >G!#}$0N oEAPaX ٲ kӇ $ཏPrz[ru꿲ri8PNrWu
`ҋع ((诲r.Ǵm%۴ mtt @t	?tSE% surY	 2PPReZAF sH<t<)t<(u;>A u/WU>Խ >]_ӓ=ʞQ1`0-?P^ća1! 2¢RFtN+P(X!	F
+9#F
t
K
PK(XfS~ t=~^f~^^~^~FF
!FFF  f[OfQ
tW 8vN؈^~nNfnNUfNnfNnĢU~*Ċ^
^aSfYTSQfPv j 8rC 5sfZR aR߈FfFQVv%{跱EfXr+tk``1 tfZf   f+YÀLu$PΎq2st
.x<^ fF! PX0 t<"u<"tV3޾x 4 sgQ&߃?s0< ls& m &_GnnwGnt&O &O@Rf&GG
q1r5qWQs]Q qqWIqX> QVWy:W 0ztNu~u .w6 u/ ?.	
zy t,6p/o{OGA&&d&D&t&ƟDk_^VMޡ}}"]`uxPy
 ф^ uuچ~قّٗ٩ٯz,U~g0ۡEݾܿW.}
u.:wtLu% xt>JrS.[t.[u {yt	Ӌzt_M_7EfUw"RҵgRеMwpgŐ.V PXF
Xf]h@ øϑ? n ܰ\V20ǰ=Vأ6{}س.tL}!΀sϽ|bހ^SVD.d.$ʋд×^[AyOój?rcB֠@qDut
ttρ{10
}1zu	vA.<xAh ԕ@R:ÁUu	UFPTRG rТfL?\pg Zfa1D`0GfP`|wfDum
`@u}f!VWUuP &BrBnXu?>{ؽй0.>}ؽйu ؜`[Bra$3mBnݾ&G $n$PC&In(US*B>F &g0G1&O2C$ 2&G@AX]@[òl1<amn p
 |qrfBtGn 0`?WPs?޲ raYxؾQ붬eRE<sfQg0MjtpZr/0 g(? ѥq[Ü?_`@QWV.>xuG<tFb=>.1}}>U%5>َόɎv^_YSRӯt5۰`cSRg&/_p&_ @Y2E[fUfS@f]Ê>?">?U3 ]PU  ]XRd ߊrQ rZq@藣 r迂1Z  @>  B< tkY P5L g rr]91B+$f rX rtL rn Z`?r56bరɬఆ r/ a@RAr 5rPذ0`@PS [XQSWfu0v t!ufPs NfXt_[Y1T<t;f3fS t	fQNu
utǳf3fL[`
 3& a@[o q^(C)Copyright Compaquterrporation 1982-2000-All s reserved.j/w*VR@ ރ| 拴  t.Z^!VP  .1BBBX$JJJ_B1P0ܰ t
tJ Xu|a0b1@V tA&q JZ  C@2u*݄ uP= ]Xruŀ2	`1  F (8SQ2<

2ۆ.
$v2gp`1<ww0
u  ` 0      Q
! YQ#8  #$#PRS%@&+}@&;w[HRҹuaa@uXXZXp! / DPXǻ  Ü= srs+
3,,]{ _ ߸^ P1wt褀.{`蹀_! /0{諰2]ALq.j.b;a/PQN 3۸ K `?T'  A G#y 8P8 y " Ëuŀ}
$or8p`tW   d_oa?/@OAoBC?TvTwTzT18 p9@ @  "`:FD-18 <F҆GH    *tP9	G%18	p9``" 8d dc"F18  #Ga a|cF Fp p  Gwr r"Ls sL
OrEcN H"  M
 "p9 +O6bS  #	K҆
tXtX҆#Oci0,}`d$!<!uy
ء\`&`"&& x<&  V<tr^@K^D]8t( 2]']v233.f>"  t."   a0b2ۊ( ҊȰe) Ǌ&) "f* 뿸*g>+CfgPhf>,3gPh.- gi) rAji..jij~PgRm=x}DK   Fw   Q Q"FPk?XnfPS \@ ff.<O[r.<ft`uhL& hPrw uhTrwaú  +߹ y$ң.<QR3Ɇt ސw  Jt$
tAJBqB~  SQ q t$߰Nx.1u
<v<s<3v 3^mtQfRfV SPo .X[u f^fZf#u Y<u,fCISGu%f» f f f À2  2Ê$uGuwﴀ\PS3ێr?43' u f>$SMMu>X P dPu
@uX\r 43˰˘s\2&D
V &DtH  
y ǿr!`rsuEF.`26$D%rOsJɊڙK$?rr
jryϞZ @FFtN fF" ۋppB@F(	~r22ۀ~ `p]{  t3ҸK3  ;wu;sbFVFF"F
 F)t @r4F$
Ft?+ F p!VPXVP"aW% uz{@ZX_'Atp'_p$q,pⰻ.3۹ 3Ҵ@./@32 3ƀnu{o`n ݤC/p(]A63Z4BUWVRQSP36x \@ fFfsEYc ,Xu 
<t<0$< uI"<w<vr,ߊ2b? 袽&\@ N [[YZ^_]Fu9<u` taaFsGroP`tNð
2~
 8u	À>A`cA	}	
u'q &L H	sƨu	VuQ2^ ˋ
貽	~詽~製@u B 
	tG&A J
Emy2aeaHH'u$<s'
C	2f 	.c u-QطM`
~q`t
тd _P u pN> uGG t$p<pupukG'FO 8tWG߷ui[G` u33 	t<uSG[u8st_,H@>C0\> pd XϷ޻ PB st2 	=3u
Kuh&> C%Txr{3~ua k\PWR5SHC>95Z_SYSID_  1Y _UU! fl f@f="uf3p fl @ $q 0 P a v&  
 '  !2@ }rP'   %	:	 CK L   P

 t " P    	=ZHewlett-Packard 68BCU Ver. F.0D 02/16/2005 L[P
Cm   Q KBCsion XX.XX@X
 
 p#oC @088pZU10 Intel(R)?$[ PZ0NQ"rnal L1 Cache!& &Y'2%(	
   PC CARD-Slot 0 Y  8  
	Cen|US|iso8859-1H
 AZ ) vHYȃP-P
@ICDIMM #1&#/#PpG
?2!32/4ZK5K&`& 	TZ SST49F008`YXZ ?Z@KH~eCYH~rC
Y =PZH  ~S
@8 !"Y!rimary~OC-MultiBaE?FZ  c   M2  k]M U5r !KEND@?3 R	

 ORS	v1=ddW"-QTONo baut'y"WY_[;Q~Pj@Q t PS	@'[Xu	 C?~ðԵcư
F&? 
ĺࠋ ? $8t{0f`r#} 
@t@u8p|Q z쨀ulB@YÊE *F&dؠF`n}nG`n`ghttf
! `
	
"x2âF01v؊恋Pv@wⷳ~豳=< _< LYulug胀xπktxn{hxbhFFg$t#@u*{Fx @mڳ2;ܼDdՐ`*U#9.:f tP@9uD@.V.f] l(<sW ._.  2P$<wXs2Qg#...&+.	 P# @ t^T.&u @ u42..߶
tw5Ő*
t*İ&u XYP3 QP0 A3.G
XY0"3 *."b WȎ"%"_\|PW\Ooϟߤ?~~~l|8&8|r8|8a|çP<<M  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>P~~<Ыff f { >c8ll78x?~~® `LM 0``,  >PW$ff$PW"%0xx00 0 lll"llPl 0|x,0f 8l8vv ``"0```0    f<7<f!0p 0  || 0p0` x8`<l 8` Ppx|p`aRp Q|x0 ff|ff@೐lЫl bhxhb3`2gf>  ``x pflxlf bf  ΐ8ll8`xƁxpcʀ3x;0 `̀@ͱ`x ƌ2x``x}  xcx'0 x|``Z1ptA8l`vQ`lv-f0 Qx@?`QRځ  aPWA  ͐bvfҷ 0|004A!0ᶀԀP0d 00001qP v!ס  ut.Uf SvN .>Y2[]
fPQRwx>@zwag݀fZYfXÏkkTjkWkeMAY9Y.iHnSS " (B03P2X`3Ҵ Āu(N(<tDlQYRBlr8rzlr
2:6 v޿klZaaۉQf PCI01 IS z C BU03COMPAQꊙ c05   
  r     ˸ @؎&м  ; r' W@ P& u_SV  GG0G hv  8 Gu 6u t3  hc) 
h+rt & ^[SO
&hre
h[U샿VW ƿF F   `qf& FD2ED2E
2E2E 2 @D(2E($
f&EvPZXuf!tE/e.a	 ƅ @.<t	db>t <tjjjj3P% S.wj5Jp$<t.<@t$t = ;t= D hGcv ߱  7cFF~ t#^FLr
F Fa(U(~ t:]''kf
 h(r*F)'2(~ t
)F_^{Qd!
hRs .&4/udu0   hr$?wط2h8iRhJC4^Ch7
 qrf   f  f   gf&Q6..  1  Y`WVe1E0&E.&WV .^_U؏Una<Qc< 	`@.e1E0eE'E.U s Cm2a h
$e Du
g$Q
a3QCr  utw
t1w
tAPSQW33۹ G&./JNK__Y[X MMMc1@  @  @MpM dB FfO MMxsMURMMd* &  <!TXMC  3Q[MQVWh5:u% p u㾐K1__)  | = <ta;P09A9_^Y~!JRW`   e
Crr3ɺ {Qe܋
AB rN /_ZMSqe Y
ujiȞzjU zj%1 DE<@1p;<<1p<3Vu """ka#t
#m[VfPfSfQ f3f3PXfffDDG(	Dh f?Yf[fX^u\ 0gO Gx{QR@<3ۊED 	 C!~ҋG4Bi3u fDf3ۋfOË\y
S{  	T U S V ;	O	c	w		`h	Ph	  h;	 hO	 hc	 hw	 h	 av.L.< t)F.6Q3.PF.h+[+V.`.^̋] dF. P!?.h/+oXh'r QR  16W  0"XYZ#[  
\av_bA]cdb'^b` Џefgh qp10GpppQW> t		 u		.	_c   ?O idJһ -ww~C.e
/e
@m_noG`L3۸ E _F߸^FiQRrPS86[X%hqQDЍRh
     b       ?_ 	?
_
 ?_ ?_  !"$?%_&'( )*+-?._/01 2346?7_89: ;<=??@_ABC DEFH?I_JKL MNOQ?R_STU VWXZ?[_\]^ _`ac?d_efg hijl?m_nop qrsu?v_wxy z{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_ ߱?_ ߺ?_ ?_ɟ ?_ҟ ?_۟ ?_ ?_ ?_ ?_  ?_	 
?_ ?_  ?!_"#$ %&')?*_+,- ./02?3_456 789;?<_=>? @ABD?E_FGH IJKM?N_OPQ RSTV?W_XYZ [\]_?`_abc defh?i_jkl mnoq?r_stu vwxz?{_|}~ ߀?_ ߉?_ ߒ?_ ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ş ?_Ο ?_ן ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_  !"#%?&_'() *+,.?/_012 3457?8_9:; <=>@?A_BCD EFGI?J_KLM NOPR?S_TUV WXY[?\_]^_ `abd?e_fgh ijkm?n_opq rstv?w_xyz {|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ?_ʟ ?_ӟ ?_ܟ ?_ ?_ ?_-*p! -   i    Q4 %	 D0%&T8 06W (0800U8808@0U8H08P08X8
h 59i  2o =i/!D##&/&O'b  )&  y*  ,  .  0  2 PSQRй JZs hPv ZZY[Xg&ǅF@ۀ988 Ã tfPfS
u	0000<0Xf[f}X:g&8u-g&
@gf&fP!??PfL'+g&>Q9g&@T=SWVfW=&2>X>*>f PQtfGg&D= $"F<vwD"FCG D| u:tg菂ACDB'B_^c=QRfU۾ ?} 5t$R>0tK߸Qt!?E$fu
pNANtN0OqOt	dI  }f]ZYp=PSRi 9uQXrQ&QTG tuVb0< `Mc!'f5 ?*bX.bX28#Z`8P A; u
@:R[3 t
\=SQV3ҠQQQ  :QtzffKfۿQ?As8_Y8ta9fF*0I8$ЊBb*PE X1Pr=u2^Yf[PR 
 ZSR;2<9ޢ<9zhS2h7rZSixi8jħ

l:A.>-ru	f 5faXEf`?frqs=psq|r^fWDqaXPFfGuE fqD$
QDutv f|uqr_^Ye=fQf5pf7pfbutf  t
gfdD0q`~ |rfgE{{A|} R=P{VQ Qffq FFt
hZS7gvu ?>t!?6fӢQ qBf0KNf^fQ8SV  ^lQ  A;\LA;t% QA1 0P7>	uQQYMV:s  XBTq$t=f˻,|"q@0f%|@Uɗ0d=QRV&<0	<0&L"L"""01wxvBfDf% ffD?7@^Z =^gs0f X43ݠ|2KÉqd,\"\l"l"111&12wş"K(X:Pf 5пsf
p aXfff6{_`E8$1h &7Xkini8jZS0hkZS`8S [<O&A: oZhhR&0<[Z8AJAaApFfƲ:QfRVEu/:PN 
~ o 9`:`<`a=r0f3 ssdTpv!?!{@F0FfC/;P;˿_i'z#G cj#/v;&7Ơ_ cъ>Ouթ5e{ay脆vؠ@Nu TѓQ$U^fpSa=}001?11S*P(PP0G^lD	%ÉD	f@ƧoAfpC<v PfUPf{Pfff!	$f41f<1 f	<1f@1fff]Xo t P9/1f!1r _@8p=R@qӃf;3Z1C X;>0 t! X `<*
 X0<۳7{RVLLf;0tf0f`0 9y";$i#cj!Xf ugf ?EM> fù fgf;t?)gf+C0kΌ@̻&{`g4?1o? )Ra=KKPV`^0`; ^=X0;0u}0;r	wbf.0XÐ  , ,  ]0
  N0W >q22)q



 e &   .R4
,#
q
 `mOk/X0   Є -} %RA! "a!   R!' 0u#"("#0T-%Dt 0D/\s !)R! _,L
 2m %#p-U1.1T.&.!T//^06!."mRc"hB"4c#D0A!145q%5$4663$8W%DHS&6&'0$1</<)=!=>(U(P a)6)Q'C*11B.tC1!D~D+!C+q:,)D++Hq@a)JZJЀ&
X&@7Rr"DH2D. !N!N N%aO#t@j,=,#+XP &N}$hB "8S&.C*SRTDQC"<V@0jVRTW`/"SRS3S
\@  (#p#
 4!3	^#0@ySu
]	PP }^ ҟP 8JQ8)) `@bOTcUJQGJeh?Wc" *h
`d]s%] b^h	_b_eXEkll4mA
m^oeo`E`Ta5aWbZ&xiO	.Zր)):JbQRO"QRW:"/*@]a0  W Lw(x(Tx$x!TyyqpzPn{:{'x'TxE#x }~{&x&Tx"yme,@||#x0cAy9y4zQ
O{''1}c}@9AƄ&(ϐ{$$Bc/{`(Lc!$Rd13;.')'$Q$c ܜQ#LAz$1}N}cQR@qpdnᥑ:(.5(f"\Dqg@131Y#V.'ڭ&.fA?$.$f@AzL/"|A!(iUこX/o̭A!'iRaO_-A!iqaOX53߷$ A!1aOAo:!Z(tZ2t@6nJ8!Z'tZǀZu1?!Z$tZ13!(B(5O#Da`k8'ҁUˀ12EǓDo$U  rxl
 Rm $A #q
 `"	o  r#{Alߑ]߀Pmz]T
 "q/	 !P{K ]az{	 hAu  `SRs`
pt9a!w    $PSQW  hq.v h_Y[XPR P4 ZXð!0. !"#$%&21/-,	
9
+ '()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRS ݫ?*8۝6T  2 	!	
w##ƒ!	1 
  " 	!	r  .> `b
_OolQQo?_Po   S5O[P'Q&.Q u!;ru
>'Q t .> St.Q*Q*Q>*Q'Qu}ǀ QmS< tC!r,Q;, , ,P'QQ)Q#z`&;!3ۊ؀`P&Q(wPr%3( )QVSQ@t	T0P[^fPQVQQg&" v\PPF- uu1,hS¾0P7gf&0 	u5&Qg& vuQA,XP
kq1P_Q[^Yf!VfU>'QS>Q>Q@&QQt(
ߠQۢ- Q0P_[P77f]^!Vt>/Q/Q r1@P=w%@>=rHP&Q:a;40@|P@Q=SQ  # [+4vb,,hGA--`.D`.L./-0 A21C@P[Q+9rQ&QQQQ5S6fSQRV 2ǅQ2RMM 0P]) Gb OqN	uQQ    P $1Pg&-@v@ -a/sRRPS>Q  U 3f3۰  U% vu0"Y'1Pu29uvtYue19u^\&YuM"Y& vZu:  8YwPu)]t]t]h = IZ^ZYfg&8! vu	?g&  vfctd@sPVSN00P[^ARVf PW^D_»8P-qYAhZPdPlPtP|PPP6."Wtt0pP藀Q=S= MW>PPSR/<v
hQ,ƿKPʀ 7PG U{ vrr])N-sۢqisl8pr$WFPPP:?Pwul`P
 hPDq t
Ƶydywuw l1Pkrg&1PtlxPRrP9rblhP r
 Jth%~intlVLpQ2y>xC~5u@-ts${:X:Z/,M <Pn_bfPfU63f000 mr<f]p6f  PQf3fY[fR!  f`0Qfwf3pp`Гa̰fpp6F E * <FuQ3t	ADt<Hut2YAt}Yn o$u tP%X!?Q PQ uB<Ft<Tt<et<t<t<Rw*<Ir&Q
29tY>`9Y!_euaVW !0ptAQ ft(PǴ:?Qu 2Ɛ gXfC?Y⯖*Q9 ǩ2JQku3բ ? t&{Q@8r m2>tw$_^D PQlQ2 Pf?зt<C0"<?tSQ(pذ`Y[߀ u
l?O3dde fHffCopyright (c) 2001 Intel Corporationf[ {;uh~u& [f2f^ t;ff[t*ĩtt f󹠠p
   0L+%Pf[Űhjy)`u" Rsf[Pfȸ &WfPa&ŷ%  Ęǋf?[f  ̸}@!gfBWf;ugF[AffgfNfP fofPF[ff[Mmffԧg_@?gWfgGSBOtlS% 1tY9 uIfۋpًՃgV8~}@N^wfˁf0!!9 uǃ0af[SfWfV޵rf&fߎf3 2_ffGf;q.<uGf=_PR_uB	f=CPU0u0>i  40u4f=NPSSufOffvP[-/8f۸!p	fA3f;s@e:fF1rff׀12Pf$@ Ta0աa 	f6q$PFH] 2G	Q\ T )C_fRʱ C`V R
 =G
M q !fItg  O4!G	dSo~j/O?_yNfub
utdֆubSnmfP@+؋f+NP2F	hÙÂ!qοf^f_fA;_[wePMguA ӑ8t3gFg^%?? @X0Pbh 	 ΡesRupte[JhƂJ a-K uQf3fAt5f6ճ[u  Z2#F+d` f&[-uPh3<u	ΰ!%2/$<H<0u_$`@H˓`<t<t'<t<<t?$<t,!fp4 2B>=2O1) f=ISGufpsg][  "aòqt f6	\>f	pe;Bj@ Q@fzFt69I6+:X6!**<< 3V1I< #A&&P>7+#f@&#	ou0@dpU6GL?ۊf7E >g=L qs@2&`F  CL%BujW1_G@~SL0<P(TY)T$TiW<W11GZKMPK&buR ͑T,eaF ZpLطL`Q@C2cgfdRFj~Lfto0mn
urX3/4l5/t  )s b:(2? h+wAp   - cyi Ab6z @Fz|K@tTy}V~   X~U`XY~YpYpG| }ņE 		 pfWQf| D=BEYf_p:sD=f.!rD=. rg.D
$.>r.%
.D
Krr.% .> rt1AQ}_GsgSrrLd
r9㖰|= USBSu@"|= tctƕ_ q`_Cr@7b[r.Γ arFgr2 8Y/dyA`gЏS3>@/rt 0r It5Qf0.FiA`r
Џ#f~f;ݰ^Q@𝢠vhH.\
؀㧓ܗ.\@rr~ `hPosrSW3f Cs $g&D=V W9 $3Խҽ \þyO3oZ)(Zҽ0_(þQ$7q__=%d
/^$$:$Rz @.Em)3@RP2  h >}؁u x`@`T=
X(fT=q&@GȤ.6-r.-r . fPQeѫ f.>+Т+r M+ϰMf~^Vu06,,r +.Imf.6CEmÑ@E렱 YfXIqrr pfaÚW3Bs֏ׯu*QfPf~gfjAfXYr簘 a3׸G*/jsA`/$ҽ؃uC P"l=quߛttt rD$
ƈD򹠾PbEE r
rϹK %t-pt=pT= t:tt h[PQqA~
(uVrL"@u=@t=t=`	t=@uw6wfaPSVSr8dtd 軧P0̾[r8DtD$ ؾAg|Pv^[XSQgO	8t`g	G	_Y[#Ӱyg@ '	`'  F{Arr3ӿ {3!RzS !z!Pt#  5;~tt%{%{Kmnoott&UWRQSPV rw2j @(ur(ffWRdh.L-fZf_ 摫uc QaPSsb-pu% r rrr/ /'B//~ 0r)B// 0rd[XF f? spJv,t q- ^X[YZ_]c È/r2r 7Q17Q h fdAu
!0r!ddfdP;?dP;Sd6mT9d =dMd@d;1<<S90r!1rQfUO
f]wQ,> 8u%ttt t	tfN 7tF ÿGrCu 4qFGHs
 41qF6{uFvHhJ $KKSfQ9V5KtNt؊ـ?fPfDdv߶fSTTff_fXs 4!GqFyuptLuY`Sf3f_f.+rߛfWpU.*&+r8fw*fF*2t*܊.&,rfX^fY[aQQq7_q *"P`aĀu߆DPvr{ l&{$0	SQVWU&Q tQ wؿر]_^0LS-120ZIP 250PSQSRVS.Q//77@ p``w|!ka|drs
hGrgB<tV< uWQvf :uFfG(5qqrrXX  b-6ZYf`Qu %r!_Qrrr;r nrc`eRWe&f} tEE_Z[M-Sys   DiskOnKey~sw9'"xQ uy @  f<x fP P w˹q"rr 2rP0wb|=1s 1s
P C f@fPuL9sUt6P r)g&Aug&1sg&
Ȱo pR rLT?f<6xUxByyP5z&f솻{e}|)WyEfPf th;rt@  u Au A~Pw3`SAf;?Yf@^`Sv`Y
QfXuײ?dw w)"xxxByye&f 	 zؿ3@gPR	3W`|>#>;|>
<_<hrF; 4  hK* p潪Z !fu+@s!$?
u$b$[yp a 5 -9 i"#D8űT uYV` YD8Ųt\VhqMF5pDDYUX0 "Xp "IY "Y "Yp GE	 	 YfWQfaY 
D5 q6r;rHsR05qt`w|D
$&q
ĈD
ґs f_g&|5 Er`r ֤a`{tزӸnEM{ rӃ `F|H\
؀ҿq
܉\C[se7 V|aޟޱV|`	C§sr 0r r` K5&1p81	W3
#S Ϙr4D=Wt0rY!
/@_(SrkȒt偛u6-vi-r60rEQfPЊ5.3f.6/`gf׉fff.0fXY⿴er8gp
9*?5lOXYH竿`Dj/O~s&`諿 s6큅td hPSoߥGB:uќ@Ͽ(uIr?u=@t=t=`	t=u{tK}fapQV؋L	;t	臼k$PؑF|;h@bg`Q&{O	8tg	G	\g
!0 0  |R       1 a 00 3`$
%1Q&&$N U0 $
 )a "R'R `#3" (&q.- <"-+/--q. 0 `0 "*01/S.03D./"%/ (545,s,5,U,7 ,Q&q2*+3:,/5-? .?256 "4-#4?-!1/r/ >&@2!1+BQ-@?&4>r?&rEGFE##b?GS0R3AE .(F AAD!45$?QIuLQ>51)&EMA"fR3Tq!T5E QT3,s0%q., ;s-Q2Zs.1V?+*$])17 7GA q@u-5A21_6`C u3PY $S5*6p._q?3&<11Za. 01Hf5g TS?* Ku-54r-B;b <%`PsYcSTa<b!,Ts3 2U(r"rc-"p,b@c"dqg5R5R"41z  ${\`Q%Yr<f.;t4Uuf.oa#~f  0{f 3gf0֋=  v	  +v> f3݇f́ 1  ݇ 6Ã tQ@ⅉB pǋ;@t.}㊤ 1.fRfWz֫f_fZkrrafϋf11!fffROMIfMAGE ;uђWt`g f3TPQ@J 2`fGpZYXu;GG 2p2 22hƂ\t"t׀!q t	V  ЃSQhtuY[
Y[W  c c"u'f߃ t!w  @ 2ђG9 GGfsf}sfߊӸ 3l; !$ fr7@/Ȏ`!0`!*q>t caG r  gf!8  N hq.>Bhp  U Ʋ`m`HPQfWfV"UUЮ*UAhZ#f  '`GA .;t3f^f_YXhBc  RW0 ۿƳ3ɅA@k0o<.Qp2Xf36 f}}30f_\0fy}f ͰC ͢32f;Tu{f>>?.0E1E2E3P.&<0Ҋ?@Հ @԰3R ưC< u!Ƌ؊ð?ưCҨtXruUC҃``r/ȰC܊$8tZPSr$u簄n㰆g`rL_rG`@9%8r @q.aP !譋b	0 fPSfQfgW
BfeUGOb y suf3ɯf`gftfY[f QP@pg<t, tfUw r8tafG$@5@8t p}UvPЏF X P..!XP..XQ / Oo	/ O
o/ Oo/ Oo !"#$&/' O(o)*+,-//0 O1o234568/9 O:o;<=>?A/B OCoDEFGHJ/K OLoMNOPQS/T OUoVWXYZ\/] O^o_`abce/f Ogohijkln/o Opoqrstuw/x Oyoz{|}~/ Ooφ/ OoϏ/ OoϘ/ Ooϡ/ OoϪ/ Ooϳ/ Ooϼ/ Ooï/ Ooˏ̯/ Ooԏկ/ Ooݏޯ/ Oo/ Oo/ Oo/ O o/ O	o

/ Oo/ Oo "/# O$o%&'()+/, O-o./0124/5 O6o789:;=/> O?o@ABCDF/G OHoIJKLMO/P OQoRSTUVX/Y OZo[\]^_a/b Ocodefghj/k Olomnopqs/t Ouovwxyz|/} O~oς/ Ooϋ/ Ooϔ/ Ooϝ/ OoϦ/ Ooϯ/ Ooϸ/ Oo/ OoǏȯ/ OoЏѯ/ Ooُگ/ Oo/ Oo/ Oo/ Oo / Oo	
/
 Oo/ Oo/ O o!"#$%'/( O)o*+,-.0/1 O2o345679/: O;o<=>?@B/C ODoEFGHIK/L OMoNOPQRT/U OVoWXYZ[]/^ O_o`abcdf/g Ohoijklmo/p Oqorstuvx/y Ozo{|}~/ Ooχ/ Ooϐ/ Ooϙ/ OoϢ/ Ooϫ/ Ooϴ/ OoϽ/ OoÏį/ Oȍͯ/ OoՏ֯/ Ooޏ߯/ Oo/ Oo/ Oo/  Oo/	 O
o
/ Oo/ Oo !#/$ O%o&'()*,/- O.o/01235/6 O7o89:;<>/? O@oABCDEG/H OIoJKLMNP/Q ORoSTUVWY/Z O[o\]^_`b/c Odoefghik/l Omonopqrt/u Ovowxyz{}/~ Ooσ/ Ooό/ Ooϕ/ OoϞ/ Ooϧ/ Ooϰ/ OoϹ/ Oo/ Ooȏɯ/ Ooяү/ Ooڏۯ/ Oo/ Oo/ Oo/ Oo / Oo	

/ Oo/ Oo/  O!o"#$%&(/) O*o+,-./1/2 O3o45678:/; O<o=>?@AC/D OEoFGHIJL/M ONoOPQRSU/V OWoXYZ[\^/_ O`oabcdeg/h Oiojklmnp/q Orostuvwy/z O{o|}~/ Ooψ/ Ooϑ/ OoϚ/ Ooϣ/ OoϬ/ Ooϵ/ OoϾ/ Ooďů/ Oo͏ί/ Oo֏ׯ/ Ooߏ/ Oo/ Oo/ Oo / Oo	/
 Oo
/ Oo/ Oo !"$/% O&o'()*+-/. O/o012346/7 O8o9:;<=?/@ OAoBCDEFH/I OJoKLMNOQ/R OSoTUVWXZ/[ O\o]^_`ac/d Oeofghijl/m Onoopqrsu/v Owoxyz{|~/ Ooτ/ Ooύ/ Ooϖ/ Ooϟ/ OoϨ/ Ooϱ/ OoϺ/ Oo/ Ooɏʯ/ Ooҏӯ/ Ooۏܯ/ Oo/ Oo/ Oo/ Oo / Oo	
/ Oo/ Oo /! O"o#$%&')/* O+o,-./02/3 O4o56789;/< O=o>?@ABD/E OFoGHIJKM/N OOoPQRSTV/W OXoYZ[\]_/` Oaobcdefh/i Ojoklmnoq/r Osotuvwxz/{ O|o}~π/ Ooω/ Ooϒ/ Ooϛ/ OoϤ/ Ooϭ/ Oo϶/ OoϿ/ OoŏƯ/ OoΏϯ/ Oo׏د/ Oo/ Oo/ Oo/Oo6   	莋0  h.v 1 fPf fXf X8  øQؠР.&  Of>PAMSf>w`>~ f3f&Ef&E 	 !q/d 
B 
 f!f   f+M h}  `a3!M>H
 hBΑ qr&2 p <@_b`fbPQfRWVf h_ ##rY  E6fP < u h#hM'r f!)fR"h#^_fZYX"h; t.?#S$/+r@$ؾ0%E<u &&fe
&0)x*T, 5`)ft  1;  F+"a`j57D"Ў7Q*r&=t&} tV" &GF^8YՃ"aþY  h u0. u&'??@8*ߋ:1Bþ 	 h<@
VC!
VC"VCVC8C
ZVC.8CPVC 8F@& P~̀>?,߾X UCXS>?[PSJLUC[,N:ORغ0 t@ZOu<w'>,p&BT$<w}	RSB1fPS>+ t7p8u1 u+
$<t tuFrr	2 [fXVQfW8tZgf&gtKhFr3g&G 謾s?a] <u$
߳^諗 a]![Op 2f_YZPq[H8tg&G"rb]a[q[*8t^t7lS]聳^a [	
VȾw.PS 8t"8t豽r^SQTggyh^Y[t,&
u꽢>ut
$ZsE t> lAYu.l}ot$m	&
sDVaK
thp8,CY	>@W2
X耼DS;tL ߝ8@p8+:utCƐs puPYa8< toV$ Pn@m?pYmiGqh>zh؀
	P>t~1tUP~~kPp8o	up8[ Xqt>%Squ
 }2jt  "X<tS p8Vi~aQtZ }r K5tF[
d]_t"~]rűz`l`,5[x5ta[tR prD{_螻b]{]bs?u%
߀u1"^`JaBtzu Bطc?pb; sW;"sQBu	8u 6u"
u謼!"
2CBl	 	 à		諽to 袻p81x *PmtXSfWt @t
/4tb_8؊f_[ñߧ ?_߰ ?_߹` 脽@1  hN h
ɀ$ t
  0Y i
a`# /@ u Bi
O aSR`Qt@B Ru${Z[SfQWP h 3Xgg;_fkf`1 f1ǰgfafQRfWPSf3k
f0< ˃P<lf; Xߩ tbDtj
[Xf_ZfYù@ fPffffX,fV3ɎЋfVf   E gf^!f^VJ!̾Vy:Ϡj
Ϲ^hЭfEW*fWfX_`g&' fc[a"[WV3 5- t;ܿъ.>">h,Q -3 Yg-^a>ut,핖,a,.02@8aO  "sFE!*$*^#uDDl+nG,EF^ym+6-G*$` 
&螃aPRu"  @膃`3
ȿ ZOQW,%Gf)a[89:  .t9bR tcPffp0fffp$p, QV<Ysx [N }cܲO@ W` 
a@Vʿ Hf
  h
/S 33 #PK   *}Q4T`U q
  `*  t*z
PCd*

@CT*ZQR	߃Sfc;tH
	zc
ZfPRQQ% = uP_= uEv= 0V^= 0VƛTZY `s
  )q
 oS)s)aR~3f[~q9t b3[	!!(8!B.!QpB8!PWQ$@!D!H!f U&Q&Q&Q&5,Q&0Q&4P$P&ZbSq[+#`]}p'*aqt3/*a3SaU C[C vS3WǴtBt:Bt	C. [*t<w>t8sk Vâ`mSs
 
)ӣq3a r"snt3S,&,6B.B董B芣*}40. rSo6䳀V}<fP60&7aU
Crq4 S
6	 fXߜ*سS{@8!	6$4$:t10-0;pS(C;.fr7R8it07;@X~~
:`Gs`G aUC>@4u*tEaUCVa`KKH7

L6I6}pNJ6ÀL6؃pMN6`O62UK
s3y@s`S{@TYSRASFS$S:wu;pWu;Wt8WPPc<`H\ [ Jp[vP1K]F :3r:Ȉ]y& @Fu{ 	&Ø\ww
2JXr]/cpx`)
À
v(h>- 12h28iM1 _R w0
ЎP@ _ؠu u`ῦ؎ Rf쨀uqZlfa@Bpp/qArnؓr_v  pо q( ؾif&Efxl yP  DPy &Ety"Dq||$D(r@s ` xzCtȀ 0>@"nqn
&t
r rxL &}u? ?u8&=O r1cFym&
I$bnyr 0~r` w mm 
 m !12'C0] q0* $OaӀng/Qfq $<@thZ#KuKfݔKu`.>>sKt&Vr	NRru2kk貌k@aԙ`Vrr X ? :z塐tVrkdV=w(qnmn$4a0fRQS[YfZt'x;0F t]0Ft0Fu
| t謏am4X
᪕4mwASRf\2E`_ `   .JhX_ 2 4tR 1ft<Q )Y0ߋA f7A   u 蟭
0gh8?ݲ H   oQQhrܲa@2rZfq0
  hqsɃ0bbǼR0轻00Z
W & EVB 3^PR#Ỏ0Q Gh4-;R͒_z'?qt  qf`.&t.ٝput<ӺDZm6qL3(q>pj
"t*?
 [ڲtct-
0U朢璨K!!b!sӑp])!4!!
qC4&D""N5s4¿
CC4bե1֧PXc
"
`(hՕbxиfPE e"0!Pܹ+x A!x33 @f ..p*s^$9$  P }  [ poP0PնryxͶrqh7b&.f   Qff   ͸fR}r<fqݹ@r( wr or gr _4C #	0   s迵-'Q@h,s-]#[3.;'tFma 肨rA#!
䡢bu_!Ћ*2+aÜRQllJ쪊$JlJlBBJZRW(O/160=qT_ZR   Z6KQVW  _^Ya+t	3yaø^ ܶр!"@sq)q!X#hr@`8P%})Ⱥ:#%8  t
ف  @Q`j t(  u8Xt
 %@) Pé (3$0)tOcHf3  fwff3u濸  hfff#f  
fηh
/0pt#P h3# n  U1X/*@%$a3X# PSQR.#!3#K &"%3!&uS .-ff)  [%8$$Q#Y3# 33q:fwf%7f \4#
p3`2j`F@= ;`=2=`@=w'L
0@''f4W"t5%D p ;
a8f_ @k%m ap I$t ԰X#f$f#*$$_ 5 3I0a0EQB0*
 a!aQRfa8BG(رG#9(3A']7u
 Xa)AGwf6ZY#AMSUNG
RQLTN150XG-L01
P0P#RLGPhilipsLCD
LP~QE06-A2Q>TX08-A3MO1AUOSQQQBQ02V1PQR41XB0R2
IDTeCMWY70R6XYC2RTMDI_SPLAYsQD ZEA0VQUV5/\QAZ3
oWG01VU
 s&~&&&&&&&&&&&& "$&17DSc "&*0DVlvf$(,2DVjrrg*0Lbz~1f*06L`t~"$*:J\hfgFZrriPj:H\hi&,0BXrh(,4J^v~f2iBl.4J`~~jf>Pl~ .'@oPpoX?À&4@58`B uƐK;Dp@~̀>į?X * sPSR$$3%w  Z;	`L` O4u@vͿ0ԠvuZ 33Sfu]{ fH_f1vyfQ1833 fXbz3,*(?(i*f}f!-UCESu'ffRVfrfRMffff^fZU0LW~ 0߬،Ў~ PfXˀЅu   t ` rWf   O~*C@ t> &t t.QtS
 S@  [r~!fn -_PRV#ؾ  t
ff;tw7 
 ' &`5zAhhܲr| z	 u"`?!Ӏ"
fffL h-hDssz3ҹ  &hY.GVU 1 >~<$F10utC }t~]^[4Vޡ ^qVS 6yD2[^ħ@Q q:D~  +YTګ{tdgDApsk@=2rd r]rPPxX XP<s试XBVR+[<u 0߅:<̶}%@=r<r#u@FM Mb3@=r @=A>:.,\,b,`}s+r Bp
AaAr(c
 rzUDr rPԩ@Ü,,,-V}r .{,^ i VWQ>P gK Y_^3Ɋ3.:st
$ .h.tR4pm"h;颕ty0ݜh-rc ƿf4f` Oі` u
tbƳ < @?fapAf`!-XRfVfWL3ۿo҈< tǾٰPMX/f_fկ #"ٹ" h㠪{f`ըp2祖]Q Fq&/Ooݏaà> u( 與tfg (Qu!> tdes Qu;Quu> S _k 89 : 7 > t(TaeOц OdԀ`u$Cl$?< u22 pQW<u
%7uggw Ũ_YTF7	vf	x 
1C
	u`Sd1O	XrY迅S
 Wbfy`	^{ 
J
z`	/| 
Q
/}@/ð#UJhrbe" 0 a<2  ՜``` 3  gff=HIBM@w u`FfПۃt.ft%!t=kt"!p f[gf&10-[fV Ѐ=a tgfF Ð~gF '@  Q&C<(0N u;gf~fgfVf0  0fBfff3gfacfYls))F$V Аs	fp '!*  sfV/$N ~(*Ffg f+s
	p Gf;s z!+Ff{,f@3ffQt	T-fYf^P&N -.Vf fAg=uQ3$fIg8]13f3@#++A,6f 04ft. .(4 苓trA2xX.>PBuT%Ă,辂 Mt=> Ul4 *>FupFtfbpDD|F_ t95 l4ՑtԑF-גt sMLC ] EP&&X >&`QDduDL5PePÁOQݫDRS`@԰3 /<t+t&pu
$&P/.>apfWt"tauBstg&G ]!f_quȎY\u [>Аp&t_a bxq WVa8?eereC6W p 2:> u6 iHt42io hetj3Ҭ؋heB^9 %coe}C԰>^Ri2llתAm j>m2@n΃n@tn`kpNf*oor.x2JpA`
.qk.P})~>6 ذ0u:iT q訿pa~M]0u}\s6uuouk s u͟!t=O
u4l
A\6~Y @!̀ėSr%sl
,~@A>)9 u)9 >*9芉/#Az Вa999; uQb&j P`  ?/OoϢ /OoQ(A69̎r[> :X ot2:L c 6 %3{Ҁ7B~AM 8u!u
 8ut	3ҋPW
 
t	_ ك
_XwhN.phqՔ
/f33ɭwF`3f
P(fffu`2fcQRt`$fw@Zot8㸫QVWJh . @ p_{^Yڿ诜r5Vv蕑 <DPSQWh[pr6h,tQW _Yu  t
t0u_YcG	 􀈁aP sX[cPS_$pOcSA u23дˡ [A2Pp3ЉXxp2[a.P2
@$
ÀuE;Xo[X(ͩ؀ {
͎2;P qP(<KrKXސE
 ɢ@PP.)a f5@3f{  0$0.&-fa-bc' f@0^Ph $>l_ft|o[f%q$0^PfWf=&GѐX<t<\<k/TPS$<w
.>c o>oS2!hBf  pؑ$f[D? &D?D?
+]J 
8s %A@z  V$<
v
ط   tǀ><?   $
"hn$0F
-d t㋷Y&~ C^qwh~d

 
-dS
 BðDBu <?&=? ( <?=?>=? u
8w@"f.q6rл2Ph@?fA03A0.A`A gP rA 
uA'g	A|uP
P
h A.@P(Ïk j gW_fYS٩PR.AZ.ϠA`BZR""
ZPԻ ˺!AAàJJú2%Pǐ!PB "X#`SR Ëذ4ðZcQSW  _[.v&`s'@JQ)Q)r?V?Q)w	zC+ 	
4u,wEEש-ש*K"EG>?1K&EGE?oa0OL02C<CPCFCZCQKOL݀Hr?B27HV2&%20nC%5!0.&5, ˠC5pQ} dW	o  XWf033\ 褑93:赏_fY@899 P6f.ەCA:u<CF;8[Q<p f. =f1:f.=Z4;8` ߀@,`:AB	ÃDgDqD{DEEDD  SEEEDE' EUUEKGUH1HG]TQTL'JD\PUUIU UUT $L LIE  T T AMUNKOU р&tHu
h9puk/qr*UR>,Ű,~
c!EAQ
ðQ^@uSVu
 q뀊pVoÒX^U IΓTUFV @WPZqT0Kq  
03!4ש+t
3NO+t3GNO`UNEEEaNEJKba_pa`aP`a@bEEapepbba$΀˾FgFs2.FrB~orf&[|$h;R>uh^lqhFclqthbwh%gp"u"!toN4;Estb}u%#pI2׊r3@uDru& p7>u
Ds77o0Eo0Yy~P&34+oX0YG7pPGG߲2Z_ 2TauOUV<2 2 PظP)$P([. >'^]i2 	q?UA FىFh23?50j`&&& oҌuFFFppËahw
`huuiajbXjj0Y7 
٢8&9:sxw
ߖI+Sk rߟI@躿ir<w?isu8fr/oiu#  h$׀#hö2p$>w
 >wp`vϣ 9"J9ҼuqYqY 9ev м"H7ߔ s0oe$8vPJF X P.J.J.J!XP.J.J.JX0K&0K0K{$auT0̝S8rddrS<dr
d2ept
w t| d!QX XK XȰhS1
{hShTv$p'LvvpStOs@ӦB l0Yihꥠåp P6/Ooʏ˯ /Ooӏԯ /Oo܏ݯ /Oo /Oo /Oo /Oo  /Oo	
 
/Oo /Oo !/"O#o$%&' (*/+O,o-./0 13/4O5o6789 :</=O>o?@AB CE/FOGoHIJK LN/OOPoQRST UW/XOYoZ[\] ^`/aObocdef gi/jOkolmno pr/sOtouvwx y{/|O}o~ρ /Ooϊ /Ooϓ /OoϜ /Ooϥ /OoϮ /OoϷ /Oo /OoƏǯ /OoϏЯ /Oo؏ٯ /Oo /Oo /Oo /Oo  /Oo 	/O
o /Oo /Oo !"# $&/'O(o)*+, -//0O1o2345 68/9O:o;<=> ?A/BOCoDEFG HJ/KOLoMNOP QS/TOUoVWXY Z\/]O^o_`ab ce/fOgohijk ln/oOpoqrst uw/xOyoz{|} ~/Ooφ /OoϏ /OoϘ /Ooϡ /OoϪ /Ooϳ /Ooϼ /Ooï /Ooˏ̯ /Ooԏկ /Ooݏޯ /Oo /Oo /Oo /O o /O	o

 /Oo /Oo  "/#O$o%&'( )+/,O-o./01 24/5O6o789: ;=/>O?o@ABC DF/GOHoIJKL MO/POQoRSTU VX/YOZo[\]^ _a/bOcodefg hj/kOlomnop qs/tOuovwxy z|/}O~oς /Ooϋ /Ooϔ /Ooϝ /OoϦ /Ooϯ /Ooϸ /Oo /OoǏȯ /OoЏѯ /Ooُگ /Oo /Oo /Oo/Ooh!$SMM MODULE -- COMPAQVERSION: 1.0 tk.ǀ> uS4uuu&g ! Xs_m[DG$ htv r
8 	t ._D
wy?<v A
- !)4)!ӑƅ^#Bl ې["-GL4D  	{{< o 2PKd; 7@7d/ VQ6yDY^PV{;ty^Xf`ffh	t$hp$Ūr> .<t
../!N!!NfafPSRVݾ 411fpr  >tU.a!/t%B%
%N&N-hr^Z[fX111rP.4XPSWRh	 > u&E *Ou&} u.C.he	t.,Z_[X`-[h	$&]rw
%[h2[^2%^4aðÀ>7 uCTȨ t$<w:9h%	R>t"9t9t`9 u 
Z_SfQRW9&C::%;d ;<_ZfY[ 7 t|TTs蜂jgP<W6_p@XB..C.?.ø  PRBZCEBF3%0u$bH` um >89&:-  %AJt0 	 	qL
  3  ti  MV ".  f@@u.2h	P)P>0Qt
R<0R@TU;<x/GEPFXTX.$'7NN?O$O"FfYZq.GfP3f&T ff1w,S-0Lj	-xs.tH0_.S.>>sR2 hP	v r?vd r,ߺwdr rtB=u
p.H0[,k b6H,@ ۋ^SF ^Sh(	[^ l   R6PQRp쨀thGct
ޡ.ZY`)E؎ffR. n d %f30Uff,.s8ss> ?Qu>?v2U :\hr	f0p  ff.4 QsffffOO}o~ρ /Ooϊ /Ooϓ /OoϜ 20ؾ 1pP-Շ*   Ȏ؍6{ ўPp6Kd y`X1Q
 S{\	`fhjS9f`PX8  G ^ PO  SOt% r  Pp"#QO(*:43s!tL@U끰2)fE0tހ,.ߡZP)`p !	012  0m"[ N%@F`JZP    NuhZaÊa$v$
avCBPBB#"w2B;raP;'蛻!
 cww"R3ۓ	u  s5#ã3U{fwB7A7*h >K u&I&O$%LH;otC2QuP&??,ȁ%81@Ë؃3é t"q@﾿ hy  єr@DL
 <%I IW_E$<r'o dd_SH	l4L`fQ T h.R9`t.
h
/#y2f   ܿB  hcڿH hNcڀefY!m!`U蘽Ff`ȟӏ "PmVUh	D
  t{| uu| up QfFFF 
F行uo2wׁY<u UF ]罀!YnIu]^o`߃  Om߱@qɾjo a hS` prGɀ f2f3f% y
 0f ` tfIAyf  0pp!P!1 f۠b
 `0XX!"f`p]fgff%PgffPe 
e``BܐldaPDCX  D ; Z x     0NmP
k0	b<Pw2 aCfWfV0KsB2=6f+$؋6f6f;f^f1fSQfRWf3ہ>o w;0mp>K 2G%GGfflf _fZYf[SQRVW6謊Ȭ𬿊33	%	蒺*//h0RmZ0
tU 2.Tޠ
_@07 2e2#a+= v cp_^Z@$
W0
>	빪``깪_S aa +Qt$t" u`!!P.yt>*$,$+}$Es$>@ to:@s@$qÊ&P$rW'%rM|A($rCp$]4$:.''+)GрM`4r)Fou'- (ðD$&J ]gl%`0؀w5SVR_S.
[.t^X 2@2^vXD+xÃ&%&GD@$ &06*u&d dtKs	2s@xw-?< W-@tٸ /$09?	p!;q9p.Q.H5D4 ðd. CQ-
`.-.y]/YPQu	Qt2-軫X-otCAx, ø ׷"$<Gy" P<H6,ð3"`B% 
  _KJ?	&@BM	 ~3MH㶊ȃIѶJʶ2ȉ  uqQ Rg
R@u]<tuQ0uIPTS gU0@tUtXTWr= tS tD3ۊ:t
u
> u'㉇| 茶ؾA\@&
" [fA\d$t2M	a_f^]kyr^fb w	a"1&ְڢde-gÊ'È
}qƯ%9%0;}pO h#n$t?
\pi#nh#n.w @2hgh֧hrdVnoðh*h^h`ppfZrh-ursqf>QPH_u(lr#  f&fbz {_!`òy-_+r(6z1{zcAr{fRfVh ftY uN(t ;(wTf6*tQ r?fqgbgBqgrf
_f|A s[f сWf> Of ? tHǀ tf f? /#fB<fPfQfp$fftgf&
tg&fYPǡsւ09Ü͟ fbb 2<w.y
Ql`uFx t@$\5$ѝ2MeKA
!pa	&㛁2 b ^! t/ tW wptutj s߃ tQ#
t~  s`E]2<nBq %t"; !P

	Fs 3M^ _u4Y>`;>t,au-  A\&$\%a #ʰ跰e[P^  a1_  d {>uT>u%  o~uAtfsTQ1褓&> 1ѻ) 	Xc
d@aun<
u!* 
tB Ԯ
GPS55npC㍯01DDׯ$Fƺk$C$X[t9 !
r$7̰{TGS0pWqA[]`[&uCZՋ\_>`t'|a_uu{`_A\Ǯ 'ϒuq
ԡvk[ô7Dtu$@
2퉱N_zWwmEFu!^`u
YOe=Ǡ30b1!{
 3M;rAУ
\y 趭S#
~!OB!<u}4{Asd!P\a&&5溺$8 ܐ{R?TĠd E^nи 鴬P#2#[> u)1&;^ s`[Àp! = p s
aa퐸pp>t+&1ՠ&}
6 r)p}0H;Sp<;w?<w2q)
<w< t 
<w>_r2Y[MbQ3
~a$u ru[  ,PTX\`dt , ,<  <@DPp  DLh @, ,0@h
,<Hq <`hlpܠ@< <p
p   $(<!Y!  ,@DHTc#$& ?'_()*+,-/ ?0_1234568 ?9_:;<=>?A?B_CDEFGrxz07HPXYhijklmno@I	

 OPQRSU ?V_WXYZ[\^?__`:a" # $	` a>0bbcprcbh0豟
3
_0eðNNO0fOhZckû  諔0hhN}.thi舕 ސmi zj3kbks핑SfpVW f !p p!ppap!p!pf%Ϥ  f.2fffu_Yf|6of"СvءvfwrGs
wvf0tBoff fY@m`}fa}0z{}aJfaJ~P3XPSVWfQs:ؾ t
@u ufufpv @uf  fY_^[XÁ

RP.XZ

P ^f%ߣ,X  
@WSQ0sHB	
  	 hrjp
Y[_ `J4d{Ǫ
:j۫BӮf`f.1.r..16 ."v
0q.f.r.rfaõrr P1X
䏀eu`Pf hGh XE0u쨀t
F񡛃<u <u õIr$rp .p.B72aõr]rӤrx4p7a4R4j;3` P;"" QY;]Ĭ]ao r&.ԿOߵMҤyj7$' r 33F.&VҤR1Ѐ,ZQRr빸3Ht2ZY`ңٵP7t"@ZZYa1~r#3EnYŰa`ٸ 3x f3& &EZ2 Q&&,r豂#r8t2`.&EO hhУWSAahhh[&M.2otL $Q #h s 5W hsRhj2hӏ 뚿ќhѝfZrh  @σvAw35 &E
,1}#11	1	21ahj%00` 0P% @  Da`6(    aV魆ī^W  3 _r-@1 fDf@/D@@Հ tֻBBO䒱
r?Nr@p {nRпW2&*G_YS߷ 蛀&*@u&}Zu&E%_FPҤ1ڏn rg rb2ۃ<Ot	B<gtMBÎؐTr; 0rg r 3hXAɉÀSQP
pt~$<PtEKu #BŠY[Q @1uu2Yо	V o^WmPI%Q YPSg9[XPfPQ>Z uι c red`ZY tCZGr-t`w 0 r uҊ r
6u`d YPrdItf s`QRx!

`SRNr&r!ww3҆r r	[Z[ oRS..srQ.  .ї2.AZ
g{YAsj
#[r	ra5PPo   dtgfYKuGv>? fFSeT2 Ca^[߰ 
 " @$2g, JQ)2E>>?@SV-2 1޾> f<$F10tuP"X4 g-Sذ* W r[g PPS. 1 U Ȱ>pg?00Ǻ0?PX1à1(!1b3ء0b3!2(P>t
!2?1#S5 t33>|21/4
t8  ttÈ?aJQRWVسس+3> ? ^_Z2>>31?G<u
tp??Vҳ^ûW C_B'bC@DC!>(P^@ϋ7??jFBB?q( B
g>2//\r`LB
"2PR9q?Z!@V7 tU..FPQ/F{.^ 2uϐbSqSRVа7rNPUNrC2r<,r32trr;wWҀPsڋ^ZW
@T  е0u
˾   Su  fAT u2_f2_ J3322^t__ `Zrnc
$	"
upSƋ߱d;sRZ3bFcF252tf	uPz
S_ø
_.P.2.la.rys,@4Pn~PÐ< <qe <`T2<q
 h =u?v _wxyz{|~? _߄? _ߍ? _ߖ? _ߟ? _ߨ?_߱UPRPRVFZX} RR3Z_ ߻?_ ?_ʟ ?_ӟ%ՌȎ؎JЍRwhvS=OLSiqJS0ff%|h f
  fȺ4ًf#puOt\f   t(,#%9=t!a1 ًȱ tf.<fuff[fYb	-CcۿSW   | u  ߻ fXX	\^f=Rf=ø  <Zu!瀠X?r nX/<p*@X hc_ f r=`  t	f01Pڥhú:t-tbfXúA $t"t
D% t
H"W2荌fd￩ u"P!
 {t 05 @+ td|@% &[.QtC t࢔&.Q u'u! F~0Q t pt
Au
S% [Q t!A	uo2PRu+F
P  3%>`7
ҡ%b< St
b0b 7RsA:s u
A!St``t	t}
Z2RP*PXZ+c.Q..@ۺ8aPfSR. 03.$$,!fp?fZf
1ڲ@% PݒX"#8#s#9P  r,ہ2fSJ@>ر#t7  h.v fȿ ff33u^_fZfYf-R3һX3t@saG `0"`#hr.
7 10!%pP&W T +xff   5x_fY[S1hNc($_`3%0
CxP
t%-؃2Y!"`a f 	!=(
	
	
=fWfV3  Vwt܎f g&ff^05p.** End SetActiveDisplays: \ R$Yt5q )㋗ød_R;taF _uq Zb	Qg`G ^GiuuuRH`RSQ2teFS
كA5  l@t@P  2H?OKPb3RR aFL3`*zJS$S?D HUu
_ XPŐnOOtBX	g9@ {P`{P$O{{ċ؀̿ {X[{X{Z^+ZV[]\p]~I{R/ gZ\zR\ t[k{PbÀcp]_[Pp]?`QRPSaF[X3 Ae XHDCeSS
RUr[j`i/`ƸPPOu"`rW2s_*Ae3tr "$& `qE"&]B* _f'faP`P:???j:b	VS&fWU]f@+wW_p&ð c	y  At rH r`Pt *ء&W>jsftuo Ds?@3 XtfWf> f_`t5 tfetnIfgflg g_<_u	҃2gaup>tQ SP܀AeX[` f"6&dAt/O  I (v ؍൨Q(aHyx1t]Qȏ`SkO_ Oa'<`* OpGQ_pS6dWP{ 
<xp& :` & #}wV2&Ƀ: }cfX$
u'f( ffCTNIgf <oPgf AXt-t5tLtWt_ p zf:]f!&uA:D1"$&ɀa\t f3f& ffȐ<u<찯
΀<ff9ݱ鱄<u]ff@ f=  &f=f=	f=fu  u%^<J0
*@uм
ммpsuqD؊Đ$
npu#q   A qu
qSмp	p
ur`q% tx,tuLp3f!tf02  t,  t#`ɀt  t
r5#;u'Gf5 1$ .  f^S+p&Rf P+pQѾf ȿ  

 fw`тffZs.px+<: 2A;0; 
 R=	:wf91` ?&{Qfpf!
P;f?f=!f+UFT  pR Fp u
5y &0㾠@ ᠁fFPEfN@O*@`X : 8u	@f@f	^fvfX&$fӃ,!(f}?fsXbfXfXqõ4C&DԹèbwĨDD=5uӓ
n":[gېy.]
ӍcAHԒ"HӦ-GQb٦C
cUDD5O5>PXeϹsϴ}[h	hՕR4AlиP	 sϹ}01	#hrS rϹ}ϹաP
	{  s i?}  0lu 0Mٺ  33 @f  ..Fs נ!
{ 
PKh7R4& ۋf``DS a[XfR0Ca {PSK Z Qfff`Yf &XP ⛹  @:p2?P  $pЫpPr rwro
u\s
7r	rrXΒ`l`q  ?CҐ
Dr'1rr=% LܻM h')R4u؝`,Tyu$ӐaQ3((d BB)YÜRp*nBnBB2JJnB$-nnZRV!(//@/6`1v^ZáfQVW  _^Y`%~xG߿052䬊5aà
!  js-Wp这3.; tt[=rAWpp'+t3Њ5 <w<=a&Køл
ûHF&os;OF&PF&3;t<u d,J.^   PEAEAE8PE9F:F7 øtðq:wq$~`IÀ&j7`Cl` aÔKؾ#L]LkS`333 &&P4[wÜ`#  0-nnt QnJFn aS [TPU3ێ7!C}&?!C{u3ۏ&>CPQCu
>W^ _bXXuYR .'ZP}h%@fh< S .[Q3@ P= 󥝱QÀ>QG~1IuqIu`&o&OPr7^ߴaPQR
cf_&f=XDZYXð@VuAOuȰBHu5^frqf޶fS2c&W0cg&u&87u&8Wu	&*gAP_`
  YP#l2r(ں 2!l t!lS'sz#l
y#pSq!l@
 qBrWX`XfCu vevt	 r _bc@fdnr2ostqduQ%nYP_ XSQ# I аOsL迫s;vU&J &t uK H
QPִ薫 V谳XŴ5s{?1J_|>89&:}hWd%.հ~3Ɏ٣gi
r. u	ujPQfVfW@hq]gf&@Uf_f^YXQWV~ ^_YﮁD̨+t1QWPPhX@.X=X@uX_`QYPۊДP!.$>u
Pr@XuSWh , s h%>&M&E&MƝ_[`>av$PnPt3Ơt"3&MaE<tað6C @TAW 2PL 8[LPLw@Ѧ+ݦ[L ߦ?_pPL<RwS2.s[*qø 0q (qаpp\fY0+&\f3ɋ&Gý A 0kf&@tPffBf;йg&Gߋf怺wgwUBtNҸtG6f uOQgPYgh ?A]fP QfUf&fgfd0jTOIPdC jNFOR J 3fSgdfCf[ u|<Qȁ{    >Pf@ Kt6f!f! f3DgE 
PEF!t{{!	C< uɋC? u-ʀ rPmgdCPEZ҅ӅL҆ӆ>҃Ӄ0:҂ӂ"Т݁ӁgdK&f]f bŰR@Ƒh%hӏ ! rX.]`Va]fd}~:،aȋM¤ E;  .1:ӄԧhs[fZŏگ @
 2au0wh
0fR{hfZr?_@PS@P>[S kNh %rhX=%2f[JĒВےжq,%cI\D>*[[L-FpXX2IcII[LJ
JoTᢒ=3'8[Lr=	ߖ  >[=[L[L]#[L_r[L1[LKLm4KLww$hK~ش`7ȐF[Lw:'f.P!u<u<uwư}߂okf&
b_O..B`9BÿSp]ذsjrj[BS@V `&;xV4t`X?upf_ [ff[`^;_ W_UsMK;!]tu6ع"`g!a0XFf3fs
">.h:`fqff`B /a"ffQ #Xs#d 20g/2 Z%h^4F sr d[)1A&hS*+`WQT @fwt+ހ_fYRЋ_Z ^0@k)@A(%_BCEqAe"ߠQ)5Rfsg]  r
fG,-./01289AHIiAOL,014589LOPQS/TT`a 3 ЕWdWa`$a,PTr 	VP3WGWC\Y[2t*:aÜ`h>@ l> l`GA lBlh_a0_6`$?C@`! G1c@^pcA cpcB  Pb$0sFuf0_Ҁc_  aRbÀc  BnnnJF$k%JF?kxVljVofha< t~q̢	Pr
opp̶pqqq0raPޢbu   llB Swؿ `lBBPwL庇 lzzzzz l_Т`fhv,vx<}xSxY4a0Y@
@ ~!wFFnևyn0znpznznznj0{np{n|nn}@y__` rtq!щ w0wwP`uE
	BQxpynna1p	 n@ wnaYbYaPQR%> tVb"$b&臰~ub
gb$ȡ
p`bRb$RRbђ
 ZYm=A`dTߛ ?_ߤ ?_߭ ?_߶ ?_߿ ?_şƿ ?_ΟϿр?_ןؿOL Xۯ$("dܟ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$ &?'_()*+,- /?0_123456 8?9_:;<=>? A?B_CDEFGHJ?K_LM   p   
5MxMQR T?U_VWXYZ[ ]?^__`abcd f?g_hijklm o?p_qrstuv x?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_  &  u    PS#  - t	.H    [Xu
.'
uu  `fSfQfWfVt, uS l  @f[t݋3ff^f_fYf[f` a ffa   SQW؋2__Y[ò					%
ðc	
Pp[^B
`r		a2`SUf`fNr	
	fa fSfظp	fӝs(3Ҡ` ؋60 jea*
`e eueۚe	e7aP 33Ƀ t	APuhe&>ReaB
f7  ta  ?u _r    !S`	
hzW_+[% &E&_"
!x$fRQS	2[YfZfQRWP
u0B1^5d !, 8uf3W+0|A1X_ZfY2 s1r `ABCDE @fPRVWf	 fFf^fNfViЎ.< t ~.FuN._^fZf[fX@	1r
@
 &@
VfPhPf0  f.e ..edfX^=Bo>f?'Q@g Aoo1 .;dt*0t .G ATftvGnf  4 t 虿j u3  FEA#FSHt< 	[SAN> [[ÿ t$vNrqo !PSQ3۹)Y[Xf
	.`As.QI..Df.|qUfVfWQSo3rWt| uX!\t[Y``C`03k;B tS
tw*
t& 	6Noo#x#` p te"eCfTf6~
ߋ^ Ra[]
 UPSfVW2{ +t {f f t]fAhmP[AQ J rg>Ut2gFYPAXs\Pf3Xsf	][X]Sf0WfP f f;r[r}Wik mAюAog_Pp?mSn Wo._ p&5 rsgNY	g/Prs F@\ZSWP7gfFfgf;PCIRu-g{ u	gf;K`\gCufQgK1`	ffYfX_UAND^AhN s" ZЅ  QЅ `fn
@ zG봲i <7PhNV vy@AN"Q3ALYaE=5X_^Z0Q 0  t8Y=Qh8
Qf>!?f}?ffYq@~f
6ufWS[a^fWV߃3Y !P1폖h] fP.j "  ؎fVPf%!0 ԟ 2gVF
uNF3p	F8ȋ^Vuf
Fr;Vwr;FvN3Җ^i gҤ3E_ufA+FV
+FV؃ ⨂P"  m ' 8/y
5G
m> uA ౩*eF 81	j jFPFPN!' Gj F P 8V
ѷ iѷ iq~ ugzаm  òi{Jߘ	h0౉  WVߋF = %  k:؋.@0@Ftlf@P8FtF% { +t1Ht	HtHHt&-9Vu~r"Af~  r~r	F wsVFsF^_
  ĴNf*΀ǉVfF`л 
3Ft	p(pH _F@8ҫ!ҺP_؀tԢfҋ q< ~ut/tr!q~$wҋVjfF~ 7	V@V@^je(FFݘN*;~^ uݙ
)RPWVޮ@uFfHufFV;tL+=tݙFVF͐}!Vfn!J0W
q!a3;Vwr;Fw)FVFVFًFV
 eƁ	A>fG@G3VQF | j*΀#@p@f`N+TRP^$9Fs$#FVhDfפ*P^@RvЊY~ t	\Ë!ARnr:~t@#f+1f t_FPP` tc";vf9GrL+sGvfGf+@ fvv#?AΡ20;Gs@{~!F Q2Qf;OFv8Vҕ5
@f;Dv3יF͋VP2WV3vF k`sP֠FRPߤu@0j&PRꀼje uĴNF"FP2,ƉV=(ut'*$<u؋ƺ /RPeA,뼀~ [u0Rke+ұ8!a^*䊇	7> u ;7Cb5F96hew٨APSQ	u@A~+9D
r
w9|v&vvD ҋ^10v 
Ơ p)PH+;Wrw
3p) O;w`ەĴ a ~15NF Fa3ϥm`8$<uP3 FߋVP3SVbԑqCFv8Hw`t2Nf% 7F l~ t@f@f6V{;FVR5b&!(T
<!89Dv`P5A8RJA$3BS
wBEFsK5./0"a15 πtӊFtʐ$@M4B46HM3
6@/7U8Gr S9a9;0fq: I lgf;<!=>°3PhPZ3  j
RZ^  YPV+k:F%- ұwŐ0@]^_5``aFt߸!F 5?  %0`Њ%ypt
0 1gQТ1TATr`,Fkv1â	PbsF t'5  P^ȂtAP^%5~$sppr% afR		P^+F̸(3QoPPOWV*t 4
֡^$\;u;U)u A	e{+uV0Murs3 FP^(Ц=b ǃpBuNpPQÃTmF0(/k:@2fut@up$/;| V@3D D:B |/  :ꢢe	 <h^# FmFAw@1WVLؐĺ@F$<w"4k:@wG )p) uGW*@B= qяG!t
< \E	E	 1! E*= t0pjPEue$ + 2Epqy =A $R>WV}@ ~ D4W@
f+@@֐]@VPZBBɠDhN$fР#^``kN/:ىŉ!k밫f@ Q1_<u%F r2`Ǉ@PPBy9v^~wk:r.`Ǆ@$~@0 Ċ@2
8 $Vk:@/Ј ۋ
k:9@tC9;P^_áP3q~6@tu N>tFˁ@$!pt71uh_ϊeՄqpEp~XDK `}#@96'tbw@N';ta>'t>ԋdՒ$ S|~ofaЋ^0^9F!	FEz	Avv^f$4G2"M jC FLfq
P@g3W2
6
p
@9 ;WZw;Rp-Pf~ ]WЗ^	 *ph jqaS٬٪ VْpWu40^tp .3R>q%uk %u~W^KFO`[D]@`O@WOґ26B4-^:pu qu ?wF  
0KƉ~ :vgRd  vp`!{:P}ty1LhAQ0OS025mDQ9v7GOpfEwopO\PPHpVFf*cj@gv8hd2 txq!6
 t;5`OpvP2FP)a$ ^VOp c
t21gUU  UUv6[6 uWA hPԾA"OP+
*FN*+@tY>het-|	khe0!c"u鉅eeheVPSVu73>;Pr;7|  ^[XelYq%k_A`luN#p.fb߇@*&Ft>v9vv3Ѝ~@&`@ qCb`Ak^׀u 3҃ r} @3k!S*䊁ukuRv3;Ft7t- t#a++u
uGrvF߃r1B;yIk0SR0NN lFt׉vQФ蜖A{NPyyPy3ҋ{A!?3fe4̱yvhojP"px^` 87𓠢݈݀ W~_$}>'0a0ᒓ݋ǈ_@}B,.fIFު@B@Bs@B<@Bb" F,F҈FvFKaK KnAQu߄S3;V0 ϿvDLSPO*徠U ttR~yRv΀7Vx+;Viw;F`pDp8VF~U =BBACDVDVEPF?VBp+IDVJVFL8VF~;8Fnƺ  ۋ^p" 襜UpUܾp& ے[ߺ( 莕W, @BtfN F  f@BtFYJYAZZPYIs7F=v)]8j#Y]+8@fp 8\V_F +pnڠƺ ڿF֋Vpnþ5b dX0 @Bt,f% 0 F
 `e`'a,p `oھp> ڱiZ6Aڲ     U     U0H@  00IBM VGA Compatible BIOS. [ k y PCIR5   g u  d"	"	0"	dC	
	wP
@
P


p		qP
C		0$$C		 `"N @88  1X (V P 0X  d @A &06  A  0`u$ `A (000* Q *@0pu40@u= @uH?@0bo2@@uOYh[rߠ<P7tq##&'072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E` a.b .c d/e /f gp0h p0io j`1k `1l mP2n P2o p@3q @3|i}i
~ i   A	 5 5    6  j5B07   9For Evaluon Use Only.
 ( 	 c-'(+ P	    = <=>?P@@__OPUzA(_BCDEF?@@pAB  K	`7(_LMNOqH@ ITzkQ(PR V 7
QH v`7IM](
cJZ3[ C
 J	

? J89:;<=>?{] *  j**?`?? (-2 $8? *?`*p` ? *?* cb*``%( (,%*26', 49$,0	
!&.3+0$8=abah $(-2a/?'/7?-16:?  
 ]'mnq@ 	TQR Jz]sTpUqAVr L_xyz{}/~O*qXtU@Z'cv@A7]bX5_^](X@AYbZ? ߊGXH]Y_ ߒ?Z@gAO
A4[BHXgIIJ+f(bJZ[P tU>(  `x]oTptUAU@iJ\A?@Gx$VBT MONTARA-GM ѱd O0 
(_ _DATA_BLOCK r  V
 	`63104Intel(r)852GM/E5¶E  Accelerated S
Build Number: ѵ  Devѱ10/06/20037:07:36
DECOMPILATION OR DISASSEMBLY PROHIBITED@< Copyright o(C) 0-0rp. All Rs Re?served0<w9 `]  `6$	

 ! "LFPIO ϲȿ? W 02468:<@BDFHJLPRTVXZ\? D_ж  ! %  8 I 0  @@QeX<KU $8  ?W%X$3o@$q1__W/@'&M `      ߋD HLπ AA! A	    2   2  2΂ؠP:|큲 UT0@	 "? _ 5`= @	W 2	$ $$ ($
  ?_  !  	 CH-7009-!b  B#Ƴ%SIpj4p`FO-;45l
 <X x 
	P S( |  foŃF|X 9 [ ?! 9FÃyW1  
4O&  A(_()/,+,-/ (@73 ) ~(
(\	(@	R	
\	(		
	(		
	(
0

:
(h
z


(



(

(FX
b(
(
($6
@(n
(
(

*X@ X<}<' 0<h 		 `"76W  </=C>  1X_ (V?@AC>d @A &06γ6XD AE<EF0* Q 0@0pqV?I2xIJLx Q@
MR$?N_O=/xQ&@XQ"	@S?T4>H?@0b_2@@'M DX?GWH?"?\_]^_	[ab@cS_efgdi jkmnonopq ps?t_u^_I@/y%>@pQX 8'Mw}zd
 +1  /,%" UfPfVfWfVtSRu.VtfFkF	F]a ь }`젻
 `@wЌF`FF=@B\~@fI w'  NnVQRffZYf;F 0rufVWR᠖fFffffFffff^܀Zff_f^f 1;F}Nn߈^f~f~.sf~ t/:V^:nQ:ND~t0 (NfFtF-f~ v2À 
2:~s vv^*ߊffV2fX]  p 
Ь
 ` ,t/؃..	 
 
f.aP߰1VWQ t6 t a3_^@v t&]etemU tPSRV<v
W8_2q!fWb  <<t<t<u&Dufn  
<uC^Z[Xf.9uf.\f.|.\PL	;ufVPf(.% `= `Xf^PfSfQtfY@ fYf.; ro![X1	u cqq t Rf-襦ot+t{f.5+rf3fL0pufߋf%)0fո0ѐ2ʐr00ZfXfq+t/Rǁ̀3"t
 @#Rw8ZsӋttu
 `fw@f@CBpufx/f a/ w{ ЛYf[`  ,<tt uu1upuuPz||($ŀi&{_կ 'ۖm+?4^M&U^(6)-6U a'd eqfg!hy PS蟜.[XDՀfWU.64jހs u.w.0p=Ou
 ŋMa=_ | W(6I=OuFt=Ot=_t
=OtPIXOuAM
0 tV( F+P -X-]«ZϾ.<t.:u.T1_F`4013 W&;&F^@^
' Ëf -nf +u
+FЦt f# ߲w-}0*ftBWM-0HU0 !DuӀ-2rf ,++m#=*ti܏,R  nt)d*,R8 Sf[ u	uN}ý!Vp    #!W!!! Ǿ #&u$* x+Arˠt.9u,?
^1	|2ۄt_@ ^2=f{fr@w(
3)`P;+
lsrrwKst&
[t t f!)+ rf"!e(tZ(P$8X$@
؉PSQQq0o2;YtoQ
p srYWZpQDtM0t
@t@uY-Y0"u"t1r.D$tt	Æf^ZYS3pw1u0
+@r u%??>.s
@ {,f$ ??)(f`4% uW	a!рtASRk4Z[6p7t$]&4ʑ G?&u [&B$@ρwZ)чfa0 1/_`^z!&k:z&9$tb:0Wο.@S.Lw2.@
QP=fY
8Xt+fYI +.7A tB#t
2tPS#[;Xu$u9uѶ,
uPSߋEt"tSQOY[r[_/T9(=QRvu6ك`.tSD[r&  ~15a((f`P t	; PI > P1%BfS :'%PQS%<vYX%"t2%P `h%
 #AvXK%	d#X6#G.&U
b(a`MQNQO 5"4Y 9Ǌò
&(" ߀t#t^]![t
/81g!86&Y!1#!t4oVо ppi`DΑQXw

SX$w
؊ˣw#3Ҩt \W
( '''o((((()
&4!uQ |,Yrs u?= tio# uRu"au@%#Pב#Vt~VtXp#xk"$u Q.O2 ;Y   Pz"fP%< t! f ff3g&fG!P0!Pf.xf-  Ё K$k$ X5o$X1 -$C|͒$f^ f!7w$QB tm$Ye$pZ"8P$2 Eja:0P# r	 PPw@u 0 RS[Ȋ耻S=á$*Àu
SD$[fPhh Xfj s:`!P\0  u
ttP!D[
g#XA 7fW#87ep= )rfV.4.tf^@
f^&?E$JSQlX
s_u0TkI $ 4Y[Sp@f+Qff[k t2vfPWݐa&D˖"fPYՠ΂v"D u'~ df%2e8ubu@ՁRt*r_*srWosR2Cd
"Z(fXwѻf^a(x)k$$PDu@u7t3av+wt5*r!2pI( ;fYv]tZ@n++
{+f$ r
0Q2Srs[Y`turL rQYRPPa<v'/rs	 (a(W_rZ.\㿏 ..M m`}"SQ@"2NY8[r2QA÷sYf_XSWg__[`tFs{r?qPt+8t$PՊ+ Xw8uDA1h(Ѐ`ʰ8 \R
a< P-
ͺ po#T{PUuA2
2i*u".04f~dA[~tu$
Ѡe-PW`UYXAE[{ذ3 \P
>J_1U^ FVv
nB]PW s5&!G18uBJ0<ft~wZ @08j t0:jG{tav06j32۰>tt@P
<X,ˀ{UXM&2VS2.6j3_8r *[Y220F]WP>j1 >Àt&}&tBJ,(-)*.)`04jÿ1<v<t
1<v1ÜȫP@"3bN<w<?t0f>'/eu%
2&J&&L&ģ` 9	K LaÀ0 0000z0
00z00001uxf@Ou Zad b  @B? <w
2tн6
tH/8
 p3۱ u tF@rpt#u3WV ^_ 	6
? HS
7@"W _uGG
zs
d a 	 QI hGڃ. >(.[jRxXuπ0؁ uYz% @@%t	Ð5FFGuـ	Y÷XrÃQS&G&w&ߋ_OB JKu[ B&OP&
tuȋcPQV2 $̊FY^Y(&tJA# &&+	
$q`ug$Q$Qc$<0t&`'t2-2*u*"(~A' `AJX2; u= 3&w &߀?2SMw[

V A1Ѿ93O.8u3`uDt3b­}zyh`!  &$@F `D|M[9d``8JI~   1f   > L$ Xp>1yF@p6S4SK7
S`c@q@U? 9O {09F@0н u Ǻp] ! 9t<v<tP&Xp925s 09}p9CVWS ct#
F[_^÷sG(s軟-G
P/&W.  /PtXtgHH@-AGG/_/.> ` ߋëA#fP#IiZhu(R1*u
LlG!a:=!-  0SSv rffVГ2~Ê߹0=r8<w4t*uf2Q`+Sf[fSQWj~fP ؈X2A_YARVͥs.
Q=s0c.#*QE.LYt0
R"8}u^Z`lr1S[uQ Yrߊ̀wv}R Sf03MrcQpsO<tCQYr?I r:Pf;Xr-uYf.;v{uс	 0c rn_7fYf0!RVSӆIat|.<t.9uk.|t.9\u^.|a}8LuQ}a}ttD.DPjQ
.lYt(t/.>`gr' tPQr.DYXuP
~[0.t֧"`і
 
ifp|  0
 .0DP[S+C.].E
.eqÈ+à	/Z+`BUqʈ艵q $
a
@eV
.D^$0Pf
@f&ffȞ &e &}ﰕ]r` <tfur`+t' w7RZt	 $</t uHKdQPr 3pff+V@^3Pȃ 	b+^[P_^JmGâ
s34G7^HaK&C
tHKdf	f^ޓz R  IZvG婢0vPVPV1н	Z rL^1s<w >PkX?ffsfBѳf
4
f3f;w2뎰azhq .8P.<u- pQ2<v#<t<vнRt CtOqph:lpyٸfw
Q!X.`<
.&NȱzPQgPX`<f|0  wP7Y2Vr:
 xfXuwfa;t9a;
I$f^ VWuB 9d4@|&\Cr`wPO
Xu0	 Zro
 u^rc
f td  	


Jr;.t3׾=u
==2.@S6&[<|rw<~w<`qRZPư M r<#w3n
uFS[2ۀwvEShRffZnfU
@?[ܑD 
s@f^|qŲ1Vf$f6	ňqf0087HsSuNUX^z5p 2ɸ,"ypg!F&Asau\Ue÷ zMي3
x@!2 o@ڮXtr=jrpY=>uUӊetǋz% 2?VP3L^>:
wN  {WPPSȿ ^Z@[JHF Y.r6~VWR
PHԊr;~s8 p~JuZ_^N tpS0 [{_P
p8e>':!:e@Vzz  :2RQ;USz & X6 "2&J tuTA2RZΰa2拄PGð` 
؆pJa 1Pcr͢?	5
`KaPfQuBr
~ rf # P@芀D?66yD3VA 4ff.Vff~u
$'tGf%b14?`55E%Z	Et
^]#C	ѭrfwrif
U@'u]1 TÒ@s
ic&
 `7u,.>X t!fa;03 B 
$GtfXf^0nWUPiRN?W%M/6?%52u0q5yB΀@  Bf>?	ʩP	3PQ3&߉LL uGG  @ tO3YX.	XfŲr,,<#:5	ZXf]f^`h`d ^؁8tJu2À_uPN<XQVW_^YS. 	sK;[VS3
t
<a|<zw$Co^ᓑ   Bq&b~0 pґ@4@Zz.9Vs3aڴP2ݳn!t.:u.T1GV .qA=^f.<Inteu   	  
 	 nRaPa CPOPBPOBO PB;rXaSRtp8Z[ÿP.}.8tS|Tuf v .E3u .Ert+  R ZP40A3 f;q1z	P ܰr3?O .x
s+o؀þ."PXfu	fSffh00#3pbf? 1 ssFpsFV @8`gsF0csRf6 0.dfi
00.D`zhPR.ff@QFC'VQbr[apZ 0` G .FFMȋF 
tJHa  Dp rFpqFq R ݰ= #.$<,ڹ<eX}(GtBy ^.ϥG<vV)f.xww1yGu
PD$.GX"}	BLQv=.+w vBRۀt
u
r=
A|f`.ȃ v(.жuc.<s.tF_Pf u.t-.3uat. P
q@f̀  򢍢 Ŀ2P v00df'eP(&0_
fpn$F&Rm!telbUr hBڼC@q !VBRR
RZR @ $ bPBBCZ°Q
Q QQ0iPl|fƊȯ$fl~PlfffXt{
tfZYQ Q 	Qg@耥S&
Ӧ t P?첺`ơ.w᱀ e'$ `` 迱 S 0S2_ eqNQ$q$u@   `tf   gft
ѲQRR3AStgZYpNշ3ɒ|yvspӹfQR3og?Z 𸟿E؁PaPS@""
o[XȺBCfQ"fQ́]͂ `!fSf9Pŀn&Ptu bۑ25ffĥf#ff#OfѠkf1M `RpPu fPÇfXӋ#ك#[uX  g-/Oo /Oo.д 1-l	 -`  1X (d @A _&064QC)t|XwrwKQdHYm %\ DV ;v7v蔿Z+a"+RfZf+m@΃AfRqQRVP|t
@ylt|<uT@LP Use the force lukeS@?D
D
  p |D
u:RЋU"} 3t
Q, Y+" O   Z;t?[ì؀  U`FFF.8\uE.T;u2	u	Ff$f"uPqfV.  ^0j!)
uCa
<uD` fV.4.9y^IFa]~>-Qu(q`
0 ƒ:f^@=wQ@_$WV@{WtfCr_.|tW&
uMu@.Et0.@yu .\*r.M
 @%a^_kY%RWUЎ s" D&;uEu&]1_Z-Pf lZ <5.u^ $< ˎÀvt Nt.b'N#@Ҝp$$Cȋ;u/ b t"~$ (tN uĿtO"FYb]`Q tGZrw?&R2'u;Zr+;r'&
  [p
uBaq,. rB.E#U~QSR />sGBZ[Y.6пM.8t
 .;6Mrs>SRVWr;u+6f
f^&M;<0_^Z|qN 9r;ef<T==3c7| t;E8u2
4@&rD019(u#0WPݠ 
XY[sCP@@ `I!JI IQT .8uftހ$ADDfdIN30`M  
! "  O	C 
C pN pO 
	Q 
Q 	R  RPV3!.d.D T.;tpL.LP@fQ0f0*<t<0u"9r>&E  `a=0VMr`|6ZUor0*v 6Vv3@If`Ȏ؎F@3@ t .v+urg\ uZ`p   W GGd E
VcEe\E@f[E	^_.f^Pg tc2)
s7V! ۤ^ t@<M _^^Ps
L+ "-K.Mq
M)
bfaK`a
BAgf^$rܰ00}-SQWDfAIM3PMS߿0WwGwPu-owGPu[t+΋L(*nt!gw	@t.u_?p;_ uXPt	r}xR&P&X ZuAp
tPtKLums?@@$

^u߃t${2_#,  ~Z\QSWV6 W&=	r!s_߃~rS_[/PQq^7_mYX]f``F(8^M2Ƀta]FoF.
.D?;t|;F$Ft.
~9r.|^TN%<ʁ _0fPWo@9Q1AB_ t{P/f^X ;FCC=R@;˗u뙴CP@VVr3!u
xu
< u	of3ඛ[0t#M@f|@pXQWRYZS"[Z rQaYs
t sRfPYR.DZtr$uæ t@@u
 @swr2`uP"X@ 쀞/X0ħf`s%*uHfP `3ٜ1$0پ0yquuK= w4 w.HKPO󲵅Z;vdSp]f3ۃ~ u%P6.&Y
Xsۀ   3 Pu]QYrPSQ0n t	"@[
0sY[XfRVVf.Tf{fPC b35 u3oRfQqŚҽ ;fpVL  ;ް^fYZC2`I]NUK33`IqQf 9fFDFɀtfVrAϰ*ῐUA A aV`6fZ {_t+}Q,YrqSa.|PXt	Ztπto fТ% v¦ %Z|`
%u"ufZ[Cf^ΐQTY #[2   QtN Y n^^t^^twǾH^8 r÷ @  wf~ nPJupS`v[QR s9a0U.:u Q uA>85QYpP^kt tQR3ɀ sMZYw t1$P NêNuu<
uf_@t ZYsK`1QwCa#gvPQ@P+(  APfW`0t%,tfR tpfZQSNu&BtGNumYf_b P^A>5M[lyJ	W.>M!.:]u0 SF[y  	
PSfVˀrf@uJa .sf^=PPPPPPPP P!P$P%PSwf3ara0Y1Q2੷Y͠  PQRR/ t&P% ֊u2ZpS![ZYొtB @2'2ۨA2/ಱ ϊb0N5p 같~09
퀮{$v  ߐDS2 ' =S 2q't >S'i =`,utta`SR b'7 t#JunkPt
PӰ1fS`i% =]UfWF  5u
 50F 5
  5fX- S4^4865b7^
f[fX]fWf`s~ u^	ߊv9qŦpG.t< tPS\@=pk<@/P<<UGfWS[ FԀU$<u'f~tfA?@tB5rRW<uHt%Q3ɁB
AQCA~
R1B5Asf6<<_@Xf[
ffZ2rd
e*eAeJe^edeuSþdNðFo53p7۴ @.?B:|aO"##QR[ ZO0#Q  O2^pO  ee@f^fdfffMe2<v!S	[t{!f@!0:À{t,ҽ
 ?豽PA\,2sp2Pu xТs  þo. c ȉNaSOX/fSf  cXf ހOf  f t7fU<Ahh)`Ahff f4Ahof%k; 	F  dːQ-00
@  g:gggqX g`@ Wf_fVBE/fFP gPppWr0f« f ff+ uf
fpu\	l \f#$5l8u2uA]tb Nhoh rpMcSES
܃_Zu?
 uV\cgNpX!t u3ۊP uua r1Q$gYczS HNu}1OF b1R )` ZRVuO	r?^Z`V!3S[ t-R!o 0JuZvZoR`Xa``}tpa YLiTiiFT
s<_}s\ w S.i[`y{O.Ptr5P r.f0[؄HV
lrS
.\
XfuQdv ǈ^O_$ؑ$`08t\ t\t	twAf "`m㡯< #tas @CaaKPMID;t     9Intel(r)852WGM/bE5PE Graphics Chip Accelerated VGA BIOS  Corpo@ion#?_pontrol  Hardware Vers 0.0 `abcdefghijklmnopq|}~<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq|||}}}~~~  5  0  2   
llannnnnnosp	p i
gegk.<t.:u tOFûE2&+]=ppu`rWpESAPq H@jfj 
kfPfXfQv4kt/3s@wktk st$k*kfYf t_uVH f&E- ߃qÐEt6t@Ύ޾jP  @jP\uRSK$Hp  uڵ%wt@ @tv ts߫#a1˫Puտ͊@wfƫՁ`rf߸
`rt  uf
  f2GtkQRfpua3ZY%͊"uq<?]ܿf
Gvγr;蕯$:Iu.{` @%%Zab]^zd>\uQSr[Y \ͰLr`tVÀ>IvmwdtYw@t$`;wR$;v f$1#~ֺ p7`t@pwoooop&pHpr @0` `o.$fPt*RaZPXfv pߓ ~25F wf f t21¿fI@ yBPgtPg1!" D6*_tEs>e^Ptw1w@QQaِfQtrwta)vGwAºBff 
C
0BBhRVIfˋW uo"@lv`8 t3
 AUP@<ʀs Z e2,uPsX2As00fQfr\Pf1ċsfYRIR/:TtPuZP؊̃XVD u.fD
f=!w"f3f0# fqR fZcv^￨k`.E.eA##A#*$##	^ $Ȱ#
C&+$`&Ek .4j(Ϳ"(Ȋ	:׀8uf$?
g32IRרu	Ht
.
  \@$
CB.!רQV.|^arԥf^÷P@5 2Ot"ѽ+".DQCp6`YV^{r
+
2^û< <#t2 <"t
+ <!t  `u7
ۀȊȀpfPJ};@s @ՋиO O OY}pu3fB * u pdvˉ`uu t kBudu^<uY8s
tQG8s8s8t3ސFt-v&8swˊ
r*ˋc
ߊA㉗P8bu J NذJPKÆ2ۅ@LBP~1BtB0O0~P2$b&LN<v`Y	xorJUN狕PqPF ^at{rtw%qvk&JpR֋&ȋsBuՃUt'W WwPYPZuZ$0<0 t**F Ɗ
t*H2Po ؊šXAM>M0ULP~tSr<wBtte$XZ;Ju؊˰ f'
tQVǐh^YuhQW_Y`ju(pSeef+fZbdb2?@b1c2@oPP *ڀ n`d  toʋXZQ2Qg`i/V++s+Dj؋Xst+tvrkmd݁ǽr\tG?r:ssNOFGt|xu;vsOGGwTxڲmw X2cR@FKX@!+0``ȋPcXd"qqudQr e"g4h0Ԏ`g`ͽP h2{PK31mLR=ЍػP
`ȮAjJuk^}A3JuQŏOXi@Y_wPGAd eSrg&	ōhFm(OaZkӓ䢞Pm KY?tv
t-r ^q]sw r
&"PtЭàQX0YP20ct{yQg tO FƮS ƯPЎ،Ȏ1 0u.r&>| t
~]`OZȡXQEcC&0PD+{2tpY!6t
@F?uXCP_X!2&<uN뿷߸Ъ12ۭykËUƋt
 Ju]+
]Q +NL㋟;PL OߋYC]tЧv1u　?600Q_KHsfuzηCȤBPq&,G$CËA(r
y$6| 62䠼@u>
xĪk?í&0  &0%UÊPY)"wj>ٯMuX#`OLXu%K02Āu9VWѤ ts
ʃ_^GMu۸ Q3@ø&Dҋ餍n@YWR $FԊrǪ8JuZ_+PMu3s
{Ë &1  >ctG3PBÀ9[t3>f߷10 2
T Gf@@
pF$
 tu 0@ PW.>ju>&}.ҪǪ_Xwptp㾀r#ts-" &"%
Ī 
r0sي
u7豄P0
x !NLuP w(VwKؽAФsX ` f3aڱ <,P2ɸ,"y_N6@πʸ _(ݨ nr$$}İ<
tG<pP<u(  2 y yb2QU<
vR vZ: uP2:6vFR
tX8rSbƇP [Պ?׻t- ʊP3ɸ1PЃ
OuMMtNPSQRaPaDXaZY[X@Sv
LFЃF0݂ۂ	!Q^qx<s<txrttJ
A 2ۋ&<FA)w t3&ee<
E1(.~=( )@-Ê;&߭శ Ou'ËÐ 0
01ǀ  fnNËƊĊNuú52Fó π} 2  Q4 KNuf&Kl0nDSRP$?.&_RPŒ;;;[[Ӄ=  XʊZ[#PƊXPpX0]A~~~~l|8 8|C<<<C8PApD  0C <fBBf< Ù}x<fff<~

x rT88T  >>EZZE Hff f { "8DD8-p2B~~J~J N !N1K ~E 0``0QAPA$BB$PADAPCVAEPN l$P  llSl ||Qf6j 8L8xοz 0 #R0```0 0VU`T<<fQO00OQOUWA0 U || 8x N~ |pZ<| <l [|o[ƐY"W|0]1]]~[@Yv^ Y0ABr`!`Vx̐Y@Y|߂R^ ff|ff\[b H bhxhbcd`]~ bbR N< G flxlf Vbf }bb]bc|`CeW|b\|[~ZN<eiil|CjƂ  mO88laKR<`]׌2@hxV``wx !` ZxC@nWA0 Qx|v `` c^\[ؠrrqs[60x00xPAv|x`lv1k 8f sugvv PA܂Kqs1]x|@e  t|@\ v1jpsk| W4AOGBtm|֗l|lqG|X0d VaN{00] vTApB[cp̄|]t|8r̅rr0urq{@|QtQitfvpfvrb88`x`AP|~~ ~?ayhSiӆ2^||r~^i||pvl``V@H~ Rph1]fyfi 8<4`8ll8 ^0`y RAP`F=a\Rf>E6ll6PA l  "U=swfRt162QAB1Ş`QAPAPrTA3 uqš1NqEd770?RA?%0"ĥ񦱧66 51qĞ1RARĞ155(tqpt  tv`a@bo`z~llHp`ddPBL|PB 8||DbR^l( <s" tQufAW|||Atdi`Q`N~@N~ a`wpRPMau8RaEPA gl<pSPA'0Q{PA<_AAB#B C"ClC4 QQEZZBxPTBE&RqqFįFG¯2xGH⣾qH
xLIbQ`|ll|-QJ`J@pd֐QrKKAW K!L|`l8 CrCQ3 Q&0OQOQ0PP48|#QcՇ||8QQRff""qSSp!Q`llҒQ`Sv3t`Nݒ]0` aWE̸XuU`ݵWtY|Z 4dZZ#ԂY@[[ ^[zQQ\qc ]]#^ ^CYpBr`p"a6B@ CqX H c@c0cc5fd@h 73{0isÁi7sf 3xpggg2 o1hthdh#q@si jjl1k2`~~NƀDsl3} m l|8P#qqKqfCƆYbD<200Co0Qxp9qѠr r3ssUdt %u3uuu·r v$@NwC0s@rgw
x &qy6焎""j~{$qsp W3||
c}}0  nqi~~r$ ap N TDN--kLs0xd2'`0HH020WBi a6K'9'a6&A!D!n>3fpxxc>jE<h#Eix:4(a6(h3,xCyG ᠏`1s0!#qp 3'3'33 ("QP#<0<0%ÖSհdx0`ܶ=>uWlܬ>1瘳D[usw]y ՛Ğ5ոa` VDD [סhۢW. jZlmĞ$p$ ÞuppE fBuu4 ŢzddqŤoqzd 4tn+lhmu`WGs
̃@r7&trP0`´W(Ђ4 11 n ||@<` `D5V# deM d 脽Jq[#/0`h|rd EĭČ]?9Ԃ Fcxʈ%U42, GؤӇ _LW8 ٬|M/ޣ.dߍt8b0B0u W	J 9d1V "VF#0Y 4E {=
W (r $D  d!%f5
 bvR5W %U	w
# !u#D)	0W!`1 $}f/ GR8
 FR! = !!!t" CU"$N%G& ''sJ4** a1M,-$.. 7mu//N04112 2$5Ov475$5f6$50U7b2B wCvdDw;< f=8>" ?" ?hh@rUAA BB*CfD$I&F HG۷HII JJKFLL'MM #IOۦPQ XR# <STUwhVWޠWlWLXcY Y]Z9[[\]^_ y`aabcdef =ghijjkl]m ?n;oopqrst =uvvwxyz_{ [|}~~ـ}]= t UƇӈ$4֋S fݍƎD&|| zX씽 |NF ȯ ФEBP<ð؜a p@k`|3OtǪ ֪!"%#4$C0^v?12Ë5þ1&)ð{	{  æ{ @   .rÜ&6| &>~ 
*K@r
t	2. Ϲ 4 4 1111a߀w<
u&| ς2.R^FFF3ҹ `Pܠʠ Ġ X  * : aQYS s2t  [øqk _Y
>ctIc  ^^4Ĉ>I`@"uu
^ƀt 36ȢJ2 Lc&P̀>Iu	B$P
	JX̀v`
p0ʁ uHÍ8LaztA@@rw
2F.Ê.̀N$FP$FF. 4 ÿϭ(#<w$u$
u Àpǀ&&߀ڈ+	*<w9ΰ`Q% tS[QR2`& 쮞1<w`٧{@tbu5BcȫFtW!yC`
 艝#`pð8 u{ 3Ҵugtb(u]̊.ŴQYR  
 8 t$8u
(
28u2Zb aR23Z%t<vÊ>bSu
㋗PRФNVQ~ċюF&<
vu^Ft&FVRU t]Z:Jr92:6v/RSbƇP [
mZVm^ރ^Yu{ZQ[<t<t<
t<
tx (` t
t$0<0tu	߆͉NPu6,~s%&2FtBu*ш
Q}s&:s2& `hk  qp? ty2P] IͪgīI<vN.!.ItI<tE2<t?<r<v7<	r
<v/<v) @Ǉu0ۀt	t2ۊêSP@X[$Ŀt0! !ъ$ڠ
4
?Ī3P@$2.>juZ&G&Gt& '
A'& 'A'&_t%&
 'A'&;GA' & 'A'
 2à   _ 0-0-0-0-fPQVಹ fVf.D!/4f^^YfX< !!b. /4f3/FFr0fPfSL1f#fff f 0f%5;u2p0[0PSQRQଊ+YZY[ 8Q8_@Y"3 /j0/f`3~:f. ;.7/CCRRt:Q<̀YA=Z t
3ݔ	t&<t&wG Bx  ABC BCB
f ,ؕq轖Q3&&Ϭ&If It!J|!JfY08rVFF3 ^tJUP9QF	 DY`3RfW.PNP3f   VW _^qLP  qL~Q,NrQP@R fX f3Q  NQP1U BQCU6UV0V*p VUOv'RX @qS Y qS#Zf$ Z0Vĸ ̸>T:TQ!Sy2A\TeT^f{[XPNf_Z7 p}QVV-^⽿BQ\*&5"&&&^G&T@RVP\&$F@&F|A  P`iX@F2emN h0k^ZRD  ZPN$uY8VĊNu^>T9ڒ!C:R"f16Z=QfV<f^Yb>>@@A ԏA?dB7$C\ 脏CcD0E
åQ	 HSIIJaJJKPKRVKB3۾L^Z#N쪓NYØ    8 4 0 < !! !!!!0!!!!  !!!# $($0$8$@$$$$ $ ```@`D``H`L``a bb @``            !!!!!!!!     #qrOV5PP<tQ4Ip4R(R:S6T4U/fU쀒VtWX#XYĀZIZ[\q]诊f]k^mF_aA`Vc`paSQ  2Št$珀Ȑ$}  P\$  pj Ǐ?ĪAdSc?褏P cBd萏P@苰 @胰P\d"iXN 
1Cy +E	P=X^ödr.亽@2  SPsuf(Zڑr1ߏ t[f`Ȏ؎U
 T.>vpp f; lf3ArO|$t(uVtD rnF! ȋD4Vw rlr&u .S6vѷu?fR&VwQ rLTf .v+u/QW&D
&M"&}  rD(;v_Yfa  
 ftVp^tu_YQVWLDFot!gw
= uRtrfa_^@ /Qf&EA@MAy A̒$fPf@u(f40 r} t tA˸l A܆w<Wf;EEϖl r&kf&HIBuMAfHAyC4fӽC ru&} sPQS蘏[ Ōp%<`Mp:,_?`VB ^ ƣ&Eǣ\@¿E;P++\og;6s;>rڿta ʾ
Ǿօñu66xPt'`Fak t	@2_Px N ð  t%u7zҾYf܍YӍ S>[6[ $ADDIN30̿!BY%Jx}AIM34bSA  @ X@@ U  Intel Corp. LVDS 04Tp`QfЌfPZ...WS..ff[fX 2`;ZY߀2 /p-4uP.;w.;v
 ЌWvTtOYf.G u"02`>ufE!R00poZ)R0qZr
ᙻv_ b< PovEsfr#*0@3 AKf=QufXU
"SQW !U0<t_NӑwfV<{1@2S &@t 3 WR &tU
Z_WP+蝃.$.%GX..]_PW*~Jo_!3SRP$<u8."  P0}XfTA߽
f`A Z7`.5@ typ MO Q@[Ou_.3.cW6v..\= vf.L<&]fff.	\w.3"@ %@.&[
U/
u.3.3. .G$0<0u. a}fVf.t25.:f@uP02d H`Zf^Ɛ~:lЌ
	d2ͫ11fZܰ!2;Total time for VGA POST:   Seconds 0.000 
7 initializationЀ10 Milli~9 
 !豆.|Ã.~ø@>.ÿ诂.p!Nw o4B 6Btx%pr 1P*O
~X X$-P_% t\k
.8tFF+L^X	
>
a`fQ}ԓ5P*Q
_u2 t
^2"ot2`rp	r>Ău
 u4P*Z
~u N+UfV$m#a YaUtNsLF.>lu82 6Tpt$.Up0V[ha##Tp~f.f.+f%b t̀~~~!.M&@I FQWf] `	fb._Y!f`
NX}Nt
"d af  zcuf[!bfg]eaN=TaRpۋpXtT`!  f.xf[QfX~`
f+ffYf
Xo3@څfX% foIQёdf轅ffǠl YQ~01+fӁs1rrwrP.MvXú#c&π ǿ`	P^ 2@BtĊRvZ$`
s$.P
tA	tA.P
t*. 	23@$  . úU:UuP&w^#Uw.r e* ˿@   `Y 1 | 1P߫X@v<t<3@$ t u# af^.&$_<u!QWt	
 uuE_Ys	6?2` ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ !?"_#$%&'( *?+_,-./01 3?4_56789: <?=_>?@ABC E?F_GHIJKL N?O_PQRSTU W?X_YZ[\]^ `?a_bcdefg i?j_klmnop r?s_tuvwxy {?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$ &?'_()*+,- /?0_123456 8?9_:;<=>? A?B_CDEFGH J?K_LMNOPQ S?T_UVWXYZ \?]_^_`abc e?f_ghijkl n?o_pqrstu w?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_  "?#_$%&'() +?,_-./012 4?5_6789:; =?>_?@ABCD F?G_HIJKLM O?P_QRSTUV X?Y_Z[\]^_ a?b_cdefgh j?k_lmnopq s?t_uvwxyz |?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  0  3!    fSfQfVfWf   ff2ff߃ʓff3 7thf;|uf;Du 7fs30f\0fyffÀ32 ;Tuff_f^fYf[  (   / b AO
 IFt1vT"|} Pa>c(^)|'6CrT[Jy-Awg(^&1>G?D&W,EVrfz*UqF;%d%Ev4\ω7,7C3KS4.HɸaD)c%O?+Ǌj&j(@GNpQрOXNqKa
Ԍ02S<{{D&/	5e	mduNto@mbMɡ{ǎWN_ƭd\?*]n"P1 ywvj: TY,(.TjLy}Rs bL43E
䎫j,ƭ<2+vAt|3o;n6}70+=iG,N@g!CVO(:5o ]]`c:=cވ{>Oyh)U?ZH-9Ć@FAnr'Д/K!t_3/Zg?5bmR!`
9YG&$iV3P#Dֺe2HRk]>
xQgH]<C6<<g7zwɽ)$@$^ :D/' ZOVAliB-Zfa+y\*Af;
 }hw$;43B"qdV)]VH11s.4]F TJ/{- ~V&xm }
oל%adE}ކsg39Vmr`d;Ze]$y+U6~%y-	+|AX6RT[Mf+L*ޘRnhB׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH])X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=BMﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~de&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthEP  "=Ptm4gf~94R8Dsx^A`96b@kpgs9ԏS\})(d<f*̛(m:FW:9DT!zcUDh֏
^3,Τ\
8f	߈|	*Jn̄2CC~pF[>%/\tVyGۯ*7$ AkoxLŕ[Z\J	|Э0a!QQׅa_FH8qa]Oۂu秈]|xڵd|$SN(Et+3׫[]bKY/n<;ѧ҄Wkz㫷
Yvdo%9fmTL	nIxƼ29MEi!jJ-r%vx~
mwǖ)fL"^g{[AUOP(IcKۆ^Va_;2ʠSh)`cǥm'dN5~ù+8a!"LF{M怂#,뷿Bh.6DR
{h;M/cTD7գLloŤة2χn]*ѡ8CL/g1+f3#i%co Bvl7_BEt.Zx~i$/ftW
P/64hFC	%! G Q2;( аrYɵ2/nxs^)4 94JIn8-z9N/fj۽_pz}[;bï"8?9;U	NZK;#7-oښm IJKLN/OOPoQ RSTUW/XOYoZ [\]^`/aOboc defgi/jOkol mnopr/sOtou vwxy{/|O}o~ ρ/Oo菈͊	ҋ	ўP!}όg
eoղGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm⽻]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbܟka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlٱwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋏ /Ooя /Ooڏ /Oo /Oo /Oo /Oo  /Oot	
PGg
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_œ%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzմTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4;jQ0\ǁK15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwykK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]h9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC ÞUEu;iTBܐx/Dz1J8pQ?h
\Q	ʴL
mvfCG=?;kIJ KLN/OOPoQRS TUW/XOYoZ[\ ]^`/aObocde fgi/jOkolmn opr/sOtouvw xy{/|O}o~ ρ/Oo͊Eҋ	PBo">ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[M^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*G3
U^`juB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg.&Eۆys/Gȵ}C 7n5?:XR
	=Mg+Eح@̱C`sJjUɯ /Ooяү /Ooڏۯ /Oo /Oo /Oo /Oo  /Oo	
}@ P/&l o
2e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnC3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I IJKLN/OOPoQ RSTUW/XOYoZ [\]^`/aOboc defgi/jOkol mnopr/sOtou vwxy{/|O}o~ ρ/Oo Ɋc     t     G  T  ^TI{ jP  RI  oIB W v D } O  1BW 1D  PIBmWbDaoOB QWDCDM!MD ?#ME 
%F h&S bQM{ QC !'K (U  j*R  |DR 
SR 
CR 
B  BLP BC BE BD pTS 6.TC PRS .H  /?sDBG,0WIN[0OP *0GCR-)SDLG` > ^ Error
  ?_  0B2  Press Enter to continue  (CTRL-Z!abort) ? _!NEAX N" "L   OA` B  C{B$JEC"JP% %#K{C$FED"F' P'#GD$EB"@$!#6ESI 6) 2&)2݀* :(P w:P
 >)+>P, REI+R0- VCS0#0Dr..)0#,S.w*F.(G.ZF#a!rDR0 v@11 z@12 ~@13 @14 {@15 @16 @170^KCa1f 5P2j 52n 503a!"X#`7#b$3%Q% 9#&c'`p:8(@8!#
)
***	`;+	+l@<+,"---c.ͪ.C/ݳ/#00ŀGDT ɀICLCT
!5pE23~W4NN a!wBSGJXGF]
a!6bG2gG:{lGZ0KIV:a!R  G,4M>M0qG.uO*yO(}ILIa!"= (SCSDSSIT!UBP= D]ST= F VG VCS:IUSS:@,SFLAVVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=GvB$[zG$[~LIQ$[V$[[$[`]eb!p$[x$``QP1UR1b2b3b4b5b6b7VCLimit= , Base=!1Dte^$[f$[j$[nb5Vach51jdvG%HHVI
JMJ	@KIٖOU6PPvQMMVNryKIŀGɀtuOQ!Vegh^f_la!C= 0D= D= TR=kl!{{P}/}  ~  0>  | ߄?_ ߍo}~π** Divide e Invalid opcodeNMI (previous instruction)Break on SMIDebug hotkey ssedSdrg invoked via callPOST tab}lntry Tracepoint
 							

*
?
EXEC WRITE`RP  _ACCEQ/A! A BY2ORD
Dpª𛥭MONLY î NO?TRACE `{0# Disd _RealMOnlyEn"B#NO  INT3sP`"OT TEMP  OFFONeISABL ENR LOC#  SERI#f CONSOpRE20cc ս CP@
@sCT!Ҧ A]LLIõyo\oǏȯ0`Ȏ؎.V0| 5 tU0̓͆P>t:o$>U.#uG6J557 ѿqs
G{7} uVRό4"$r;s3|7۰$ 2 PSQRp.c(f._f.f@٭Ujٱnٵr
u, t$.t@N u% ;t	.^ /uϞPӵPCrt..9Vt!pc.툑!wv   a{ 0ֳurotib aa
uj. .>_P0u+.^t
u3t-t._ ;C 3u'߀u2_".  s0d&Q.ZY[XfP.^_afP`r"{>t"e"
w B$? 8 b ",  %" L faù   Ptu
D>=4 u	0rhN
	 :tw%3t3sT4= fPf0Ka}p	bҍ6U<uf.R=fu<=upfffDf.0
?f.rސRfCf.a./c .3Ӎ!>/d  /Ϲd  Ϡuf366p;ZY{f[PSVW< t"<\u
<nuF=3<~u s2*3_^@PS>:FsI>%=s@>a4s7>(r;< u<<<u2B
VM5'2^@  CyclesAf(uSec= ) ???fQfRVϨ u\@ًaڋۋr611ftf+fxvfu	61ff331f.x082^fZf .{݁Z<@ &Z֍J PQt0ϋc 2r	12tYQ 
#2'|##	 y2s
11t菟4r_^%W<;t=@"  ?@ $3s?v4u1rw$0.Ws_"1tT!I4u}1uP	
C=34u2r:f{ s2U1t 2r#D06
rQ0b ] 3 
4 5  1t-*3ur2r,D0$0t
>r.d. a г3Q@X\@	Pt5.R.;Iuf.;KtU\P06XR	r n6S p
ft<guX<t<t<ͳuL@	04t	.TS 34@"@1s1`/@?0֗Í:oG FFsG1G%5HUsGGa5HH Ñ/tI.> rI/rD/0 H0r5} ufǿu%$NNufP
ܠG RPpMSe [R6[SSQSSzG[b׋ߺ*a*/0s+"@%u/|-/--.(fpװ *\fW7O-@	ffGGt
S_9 [Vw2#-^f;t]-wߗ-G
-
PYfVEf3Ѐ?t-#.fGfsGbs,c fSXMemory, I/O andbqRs must use hardwarexf (0-3 ->Yr#-8]..N>Fr-=.뢙 l6`llmrD	{v m k-t.r__j@ k rk.՛k l@". f $- Gt >i
 r߈G 5  /! , u
0v G}pw WQr{W\
f\GG ,r u6@	P.O>
 rGGvs',tjd r#_Gzt |6f*3QM,r0fu!0P<upт0yQPY)U*c*i0_V	b- r' %3 `0P0͙R G+r2}tn  0SrS͓Gi]r
+r:1rlGQr+r$sm1r\+r 훱R .+P,rqss
6-u!+u PXYiP²
 fries_numb0 PQS ҈36(@	џτQ t"(6(.'))%BP#     0ype= Length= Bas rByt Trac YVW*   F(()u1?G`l!t )6o"(d@_u`  0({uJ 
Gw>  }'fGnat;)[	(GO(:
N(]0&)(P%=8E}	  Ѹ'(BhalPdy active. Do you wahto repl ihY/N)? "RVWU@	 t*@	.b 6[ w  rwfbGff.!!Y}t 	P}bOff3
G
G!3{q΢]_^S`pW؍ 2pFr{_rWS*
qg7 sp &Q q߈Ys<s8f Lf
u b1a`fSofthnoސvaila.
nrG w`w
tBtq u
*D u+*@_T r@	]; u629%P>&	XQU#_v`1V6@
 5|t/fTf TCC[./D.PGIuQG^` 4.D9Ou.Sq3)A -!{a`0  &	>VWQ Y^_.?@a`2 R_ *C={	f9Ou w.s ss݀PXa! ۶Cʄ
`".&^Q@L$ ù  o   P06.E..F 5 rGpGG0A$r8Ȱ|5f}{o##/O# = ~M#CP$39:0 r,pG;5@$tޒ	r0=G$r
13W$ts
 u	rcf=  w[3T}%rR  LwJ#tCi%r>psw8#t.T%r)psw#
؀#r#t_6%rQ_L Bu0, Devi, Fun@on= 
 tx0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** Errorading from PCI
 !  !#t+%tC #t6% #  pC  uR? +3ۂ!E!FfpCA!LT[s2!.!]Et.. pTp vt`[ p
#C vq#`4<ra
 a3~3U^Nx ~@v  ^xaAr
u!! @ !°!1 !B;Vr蓅!aWQU -  6 ! $s+ `,$/e XL.:I/.l0
 A0hsu0hU9!u0<# ;# fС"D4u
4@L) ;"#f.##@46`3`85vf`306 E_"f0z"CB-.99ud>p/u/ xt- =6)8w.#
t0 +)+# 3"qR36#..VW."@sp36f=qs^W7?s6E$k  >#󪔲2`[7(.# .PACr!2A&DD67@JJ/ |0n3$6p3$
4! 30q:."  9%9:"j/'ÿ] VW> %_rh< u
pV}@V @WtQ: EψqX@ +r6%&Gf."p$p$rS" .Rs9:}lBC^@
c65EIO"uPFoufat physical address  NPfxbԐ! ð#srk SOS2;tf8x&ps u2pu6;&>p3~rV&}%j~l6 }eh;.MemoްcompQsu;cccfulԀ_'0v7hx@4&p3|r m*!iip quf6']p7?f@g@p3z'j#w|wvwtfHtrh}@.y'lQrp5tgT4t[|tYrTQ
 `35Bg8xfqS vg{|l r^}U~I3ɍ>tA<'tZ"uج@(8t$ s&At!_TrptChecksum= k r[}3~Fsfghw> (wj[p3~=Np5l4tvv rqQ!Rt]T rp+`\rF2w"I<Lu4Fd r|84v.*#t5@]SWfl>r<:ufF	+rfF>	 r[SRir$r%} u`
frZ[p?.Ϣd3<*p3>*!Ds<$煩  3 .RՀƓVQ.04*lB* uV pKJ.B*?ro0*wH4* P2zr& E@ r..*k.8>*_#9 v~	!vD*9Fpp3!8*`4F* sQ`SASШ>:@6<U<q SFHpހR>J*=.6H* 3Ѩ0GJ* k@\DoH*?F*`.498*w
.B*D*NiIܒ̋D>0t %@  .;puf.;u>-(sMQ.l.f`,@4u ~ǀ g tPR»uIJ9t3..>ֿE.pV4m=!'"ï0 S 7 I.;Kt2%IKf`p;R3;	=>S@ԡK.,6S 3׉򥀱.,ޣ<`@\RFX@W@\۠ aCPU Time Stamp display= Speed= Must set s to ena_ble tPsP1BtJPr	d`}=@h.v&u&>rN@<uF`4v .{2.~ ,-n.6-YP$v3CӋBcbter =   uSec t
r!qh6o.xp.Í>'rtGSrS `<t.&Nt#>/r/.< u8t">r.r
u
#&
* T7argis@rt. Rs manually ifQfails6i/WMQI ˆ9^V6'~F A`!u`e@66 ^PQW> %>U s_YXLt,[r`@10Ur.J b׿ u`.& $rL2w,<r(.0Ur ߵ*s	 b@ 0@&
mkw
 u	1pW	.M"M}#rp.ݭPpMfQ__NPSٜp?ɝ`5P`FAaz· kAa"51
 1
 ?W.h
@i&(a
M̳zE"10sv$:% u0% M	gø6C	>phr6>niSn;;K;I;;**+o-?._/ 012346?7_8 9:;<=??@_A BCDEFH?I_J KLMNOQ?R_S TUVWXZ?[_\ ]^_`ac?d_e fghijl?m_n opqrsu?v_w xyz{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨЀ2g22Ѭ}[pW>2!2 t>6p_W} v	 EAC r3ۉ_P_rS t]AMw][P_)P٭
ЭPX
2t^𭢱2ѭ<w.2ؓ2 [SZrı`P  ( 1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?j_`!?`	3f<u.3<xZ.3<Q<
23< E<
u.2<.:7<u 4 0<s+.2<" &8<1<rÁTapu<<up08<.:X "3>0.?>2<:A$w4<.5b>؊5<t ˀu 8or6<7<[ø.1<.&2<@.=<X`E݊7<.*6< v&.6<#& Laz*3<S
.#!ԃS$3݊0<aR2< # ϊŴ* # 译K`
 a	AR.9<
 Z;<ZÆwBB5PV~^QR 3du t񰰱l`$<6t<*tPu.A<

y"A<
x<Cwp.A "B<<ڛt
ArZwG ZYA2
 d0 R7 r  dI r`.@<@r` d`Z	 .@<`a Qpt
QhGv Yuu#s3s`8umPf`8<!O W !Fq@ &} tC	t;k0ta3	h &,&E
 ظ@	 P ^ X @Wu-  ~pfaq`tQ"OA _ Yf`RW.OA.1Aw#.U! 	tff.PAƽ.TAʡ_PfXOAu.UAU.TA讽_f.PA+KdKK|JJJ9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH"r.A$$$AP <t<t<
SQVWێA<t<wPXrs<vA.A>A &_^Y$$$AQ Y8t	( PVtu@I0
<
t X2Qt .Qȵ$0<:|up06ff6PffXV/pϭo
p0^Vf38
9f^ << f`3Qߜf
p  >COCrf0f3ftYP0C++x@2 fa%

 CCR3 ۽CPE1< tN< XÀFu'Vu@߬<0r/<Zw<As<9wA;t^<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3! o!.SVW31rKt	s<<t<p; <w
t+&<Ru	& u@R< r KA< u4 _KPP0PECPEOI CN ۩ C1SQWU3t!;wOQ
G:Yu
;t} tۋG]_,rf s ZYf% r}s`^ r
<:uft_]Wf33ɋ1 r	f
ANLS:R ufP0wHa^<fwK,W<Fw7<Ae7JI,0@]WfU:af>fP3 fX`bfAN0\ u3d
df] Aef^a<'u"PS<'t	Ab3dk"eNt<Yt
<NtNP3t8tNX':*򮿋HH,
uÊGvO 7ÀM=GCp2PVWuu w_U "$$Jy$?y$4y$)y$y$jy$yAqA`T P G WIN HHHHHU$<w%.HGu~xt;wxߤȰ
r3Y]Kxff   `HB8uĀuBJu*@u
 ktgB$J E@tgB/AJ
 S70Zfb0z$ (u#QgpJ BJQB 1䅨@a SR1bNZ r. $0P@0m rPrfЊ  bH t$<+xbH+
JE$<u	f pgcHB칝1`hBu"J Cх J g` t t  ARڳrȀ $@$zчЋaU$`<`u`u uR
 Z- ' 2
JJr.JПAZ10@ρ r@OMTB B |ԧTR0ᱰw r"5u<۰PqԮ];u1p<t) u0JХ J"8t	2 ЭhkÝp J#?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ ?_  ?_	 

?_ ?_ !?"_#$ %&'(*?+_,- ./013?4_56 789:<?=_>? @ABCE?F_GH IJKLN?O_PQ RSTUW?X_YZ [\]^`?a_bc defgi?j_kl mnopr?s_tu vwxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ ǿ?_ п?_ ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CD EFGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_꒕ -RQ	 o 

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs?t_uvwxyvz
Compaq BIOScope
  - Skipping POST breakpoint
szB pz+~pzM~pz7~pzX~rzk  2j  A ~$@b	@
@ԄԄ @12Q ᅡbR /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯDBEXEPTN˰DBWAITCMRDCPUREG(6RDDBGPrSCTRP^MEMBUF) CMRSPIOPORT5AISPTEXTˆ/INSTCODEI*SMM!GŀdESETARG˦/ UMEsWR+WR,Q#/1RQ#AWR) Ds/˿WR)Ԋ @T T  ! !EOP
 / Oo/ Oo/ Oo / Oo	/
 Oo
/ Oo/Oo !˫#m#ϳ$4%  "#$  rpˌȎ؎  F߯.UfP.>A uWP.)G f3.U.H`,I`,O`,M`,N`,E`,B`,C`,.. ,..AXfX *fSRkP.Bug01)u_`*+tT.T$03t?$.040脨r'`*UE*`*Dp204r	)`1X
Zf[`001M01N09PS tatCu?`*L*7h9v t-u$ظP hv;hs=)Lp:r S6uE[X`*Cp2'Pa5
.-> t
)0A VXPs Xr$$
0
/=
q>)1 roE`C_x 2G G hP~; Hs=CruX HrTh;fP f"wqJC>
 f.|`0VQ6'?1A60R Y^PSQfR_V`*U*(&\f&Tf	 ^fZY[XðS3ێϹ  Vp@s H ˜W0 SXX#YUXYX	Y @B32uT6W`*B,`* u.>B.P_u.8_t.9_R@g JP艁GG }ay}rangac\aXQaM}FaB;a	70a,%a
!}aaa
 f`(* >(6.> ,6f.R6D.VffXmAmZ Пf ?buf.R>r>^)1Q1QqZۀ 3Pqr#svPsȪszPss~Ps!f%#6 .,.>>66@lsv6. vffaJ fpO!f%$uc0R1f{-&f 0 &yP
_.QXPmqfZ$zVs`*Bsf%'f
 y+`*^	.Q~w

z.|t}u..G`,s >s^ tbDB8S+.&Z5JxU .Gu
`*e?~u)`*EKp2!)`*B	) .c!h"T~
fWz.6V.6Iwf@mR|Kf }6Of3ffS'ArMotA6 fuD>Q
6ˇd 01Tt	6݇U  } 4tY=o.V0vg&;pRsZ^pu VVW>ˆ蓭b& _^VVWr>r6> _^V'ɯ s0fSfVfW)>64rt 3ҋ f|ݠG 
t O
?tw= ?  68)< 	s0B>uf_fVfY83נA :r<+u<-uPR+ZVR-aQȵ$0<:|uYX@Ju @ l>@> U@vu@V
lrS- w|Hro1PO
8rK}?rDer)ߋW.9u$% r$QqSVWލwP <r:D9Gu-D
9G
0u"ZLqt.Ws
F_^VRVր? t u
?3^VaWU3и<r<
t
<
t	:tuEF]_rs r r
ê<fw<ar,W<Fw<A7ÿ<9w<00 L0QѠf33w-.-6/mё)9/'"p2Yc0.0Ӳ>ޢm
OֺxӋ6t>|.s<u= Q> <u 鿅 <u0hro).> PmPmDQBҠ w?>dۨ؀ `*s!?^03B>B蛓FڤSQTpg&CX裤W )}q鷨J L6Mr, 馜fNfOf_Ag&?2fffXPt á#?TBPme2f.;ew-  r%Q1ਐ tfGɷJ>8 r,vf2BrmAVXTT)@ r ,fffFgf#K .䱃@{S2T~3?aM`t
`,ߠ ,ffV&vPmx@Qv"  u߸ $t.$撱 Q fU.E.9߂..F.:wGP;A5ŋf , tR5 uuufPm=R#f]Ѩ9@Po:w;5.=[ ! f4R RQ 
	`_Z Z\$S
Ｐf  X Z0Sf3[ffÊ$  ffff 1%0$`%߻Ӧ R&%   $ff8*** Please restart the system manually.
 xL.<t$
@..
$!/t/_$0!/t/?DH2撍6mR3PI8>Ko wQѠ ػ7f?{tuCkP O ntJfq<4T WFOPAtOPX >~ XTY*\~YfPQU T9GPF >J~us
, 6=A> > POXpV]Uf ]ayyŀ8Gbؾff&f&J!KG>̀ fG`GQa ATIIPJ6LMfWf>҈!_f!QQQQff4ss4ttf~}VP6ҧfasPVAVrAVؠ0h"3PhXX[ÕXڥ/<\$<sYr.r@O C]CAp?6t_r@Xπ`?`UAIJfQBEn}S  gf +u}
' u d[P}p&r/ c@CXra Jg=)xxPe14l 8lmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo  /Oo	 /
Oo
 /Oo /Oo !"$ /%O&o'()*+- /.O/o012346 /7O8o9:;<=? /@OAoBCDEFH /IOJoKLMNOQ /ROSoTUVWXZ /[O\o]^_`ac /dOeofghijl /mOnoopqrsu /vOwoxyz{|~ /Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&') /*O+o,-./02 /3O4o56789; /<O=o>?@ABD /EOFoGHIJKM /NOOoPQRSTV /WOXoYZ[\]_ /`Oaobcdefh /iOjoklmnoq /rOsotuvwxz /{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo /Oo  ?_ 
?_
?_??? fRfVfWfU..f.6. + f. 's 6э>us.a +C..+.> uj.^q:
qf.f=   sIqOq r.q
 .+"s q6 ptP#+#`$+pĐ Pf. "f.f]f_f^fZPSQ 3<dr<gw,d P$<&Xu
 $	,<w .	.p)N.Y[XQ<uF$<t
.? t#;OtYQRWSVw*t^w.;t
|u. >
эf3EG..fEfGpЈE
G
.f$ r-/t8  99- 9.Ѐ tZ8=9? :@;P:?XthP[G_ZYrepe  `>n>VW>S; t6Ss?1@CsQ?r$?s6A-`B+ 15GCЃ} ;, 5C7D s# qB`C	ArvBr_^ rE<PfPǋfEEHE
EEfXSQVW3?u-6qCt6#L6QLuC_^Y[VWf6Ї
 @HF`CÆQfQfPf$FfXsRSÒ3 Eg	7WTkUfQIffD$70W?uUcT+9% si}
uFoDdW+pWZE_}t8YuS uN~T-fD7  !]6\0u]07 ^ ui!]Yus]{_ KT߀u#8
fɁYrgV1gV d/u8	1cc߾17,R0JfXf 2TQ߀Ys0cYsVctfY+5 /j7 _"kk[gkq8Or߲Wm_lieoaȋTq8s"ns\fEVVcwD1SfönmQokETf+r8sx0W7T*WTߥ:dν fD@@'4'f irfe  Y2pV~Q^ t@lsF蓟N+r]Y
~]ym3w@lD tsM| /u
!9z897<a\!5|6^<uhs
`\ f!7s1kq8sk8!~Nnj	xj95bP:5i3wj+fTaB{s
qrD1pJg-kd
*fc.`vX~Q!}B'?t@R{f%{s@l"⋰Oj嘭@lq8wAsW-q+@lw~oscT8p\5?VF`^k5`K95FF<^jdR{w!mnlAWjPХ8VYpsVr4s7Ar\BnХ蚐f!E~F^Ë tttk%:5n7sdu1n`o¬p qrsTT%=upWqh-Vf$&?	!(=(tLQ	
v+`=urn2$n0yrSFtQhٻ0<t`1 (ұrn@k@l+1| 7u Øn3|}3k,Cm|`o1iVq$fedwOcDjSFjd8kn45>2cT0SG iAy!|sdgw@?G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsicdi0phrTeFbgOCf_2J0#escsssdsfsgsfWP DVaX
<P ݰ: tͫA:ArAⳔ`D覔A♔ A4  + *2+*4+*8+f5k-JYsMɟȁpuJføtsPørc@d
t?oslc#fE~{tЎ1 `J!%߰[B
۽@lK!߰]rBW!p2P!Fb_x+si dpp1B  }߃߉ߏߘߛߞ_ ucQ s0cE
WV6g4Fg^_rg tUY	P!!s
P! !M
fwo/rd d" q" " tbyte %*/r ptr c #WV.3t"h6@:hs6J,6K&Ys#[O0VBOO_f^f >eS fXPXP
$0<9~F[!J!JhD
 s봰+ !J$ CqYsp8e+s߰-шsf    Pr Pr  ޳ ;  r_   . `rx   $pr ' ]3( ,T/ 0 4T7 ^8 <!T? 	!x @ 
 H $P$X$x ` Wa 'b  f@r c &@r h ( i +}0 l 0!1(m 5,n 9,o ?,p Dwג+q G.wr K.s N.wt R.u U.wv Y.w ].wx `.y c.wz g.{ j.w| n.} q.w~ u. y.8&8ǀ:0:;66;: 6;=(:06;?8:  |}U.  B  ! PC: C  Q)8vے+ !F  r !   H ' ݪK H ݴ.# PCٵPCנN  Urw O AT O O O H H H H n! PCxLM?8 q)pXXXnX  X([8[  ROp]I E  ^8PC.ȿ /1( ]ːaI #rcb+{ 'E^ ,KW 1A^ :УX:SYfZfZfc[f\f\ 7eݒ+ ;Uk ?C^& D. Kn Qn Vn  [w ^p IIN  bDrrIr4pVp`quu WfE^ kE^w qE^ vE^w zC^8Ab`py~yvz vz(+z0vz8sz $E^ E^ E^ E^ E^ y`$z|8fܓ b}8(bՄ03FzM  ׶ 3`,?	 0Nщ ^1   A^1w 'č	 %e@+ T1Rҋ uҋ  ֥ ڹ*1 ݕ ᕔ 啔@w 2A 8UwB ?UC EUwD LUE RUwF YUG `UwH fUI lUwJ sUK yUwL UM UwN UO T8 o8(V0V8T@P鵍 e  Ee.@r1`/䧂0䧃0䧄$p1䧅 2䧆2I3䧈04䧉4䧊5䧋@6䧌$6䧍7䧎P8䧹 93 e1 e2 e0 d8 9ҡ {  w 	 w  w  $w * /w 5 :w @ F    Or!$  e K O8SXw ]ƻ0b g mkp u z (&g!`ᗶ䜶塶覶髶m빶쿶ƶͶҶض޶0(m
ܛm&.5߻:?ۻGLmRX^eGrklRFpsutz q8 ~݅(60684nuРq0(Tg 50vf83g(lRF8ۻ8u% (m08$fcuu8 D8$0 0V   
0{ 00{V8 dҰ8 f {s  txMUadd push pop or adc sbb and daa sub
s x
 cmps inc decb}aa bou
arpl imupnsb out q jo j%n0c@z@be ja j @jp@`l jglg test xchg mov lea ncbw cwd call waitbff KsaPl@s!s stos lKodcqbbbRb rolr rc~ cr shla@etp@enteft!o iavemd xlaoop@!#s#xza j@lwockpne%_e hlt ct ne div i'clP
tUc (i i (d dbx1zx lUf@g@sl0)hrd bsf+r btp,s\p,a,c i,x,sep!.`.p..zR./.e-@.pR.1 eQt 12b0gr*Ul*di14l14_msw l -s!4Usq4s4s5s -wver6w ffchs fab08tfx`"fld119l289e19pi9g29n~";z f2xmp9yl2x fptkan<a<re1<xtrac8sB1f>=S<pp9sqr8s0frnd!f@@|7Aucomp7en:dis:c[le<inf1 9B )fP@1esc19env19cƑ7stFGaGfreB8BB0ArG"G 5fbEiEb>>1EP@@CG12E>MfiBIaO"LaM'AL wbinv+wa@oQ`RARSzSRSR RUQRlQ DVTg!X8@puid rdmP,rdp&rdtFrsm ud2 wr!Zx1 .\ f\ y}\z`&^w{&^|&^}\&^%^.s\x\3%^3%^\}t_.\G&^%^%^{.g%^5a&^&^a&^&^,}(%^-)*\.V`)P}S\ \%p[&^X&^}a4s%^$%^<%^v%^ý\t%^5s&cxΤ\|\5syw&y'5a{t%^$%^I~{a5a5sQz&^5a|\fe{$\
{
迵z%\׋c~}<r%^<m t%^"y$v7%^&芵z){%^+t0%^-e{05s35s6wQe{9uf{;me{>5sAjDt+%^F&__JdL{%^Nt!%^P5sS<e{Vu%^Xe{[%^]` z2scHf5sie{lne{q{}vu
%^xL{d}W{޵e{w#\P&^߉O\e&ϐ\ۺ\WuuY&^\ur5s'nڗt杪~唱#tN%^8etH%^&~  6 f3 t3Vv^
j
a
SQW.8
F  1 [Fn6F?f.a
>0QHY.&f.>R[  t8svJ $GG _Y[PQ.>t7xFYX8eF N!SDr [5߰Hz QMY5 FJ2@ M)FKEQ̘R$ <t<t<uE* mfSùE' ; XEfPQfRf3 3JFfZYfXSt[_A B C D mP Q R ۂS ABCDóPO݀߁R߂S߃c?[ SpWP.@ơ.X.@ʽ u<u	L <r<w,@. <  .>
  <  <;u.À
s.p <0r$<9w ,0 P.p`ꏿ
 Y.l<?uf.[u
f.&^aR<[`Ow?uu1R8f;t'uG⠰ o._p	  ` hN.v ῟ hģȆg
Ȏ؎`ЍRߋh i
  W R00 o  Pf  K8     DSDT:b  HP nx5000 @  MSFT@[0\._PR_CPU0  _CST {PSB_C ݤ@12A

 A y 

  	

A1	2
i
\@32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 714ph`p
 gpid#d
 {`
ap2a bsbgcpcgz`
`vdgD15phg	gi
 A6gA7phpi1p
 fp
`'fg`f bc7f cufbc```~A8A9E
Microsoft Windows ME: Millennium Edition s NT C~@AF
p\_OS_`p1g`a.ag%q`r9 
bra
~ua%
 6%
} +%[1&I`,
%$2^ p
pA8_INI 1AH@B
fpig
f
 SpiP02gp2hPrgfata
apa`'ahha ߈`a u3
 bbiibd5ub`z\[K
@C_HIDAJ	_CRSD)
&	p 
 :@ @ 1;:A:
 C0k10<P=1tS12>W=P=3<P=4pyV>5
]+14t>4?D> .16P"C7C8CP=9 r1DiAEAdE  E[P=B   
,[GP=C 0P=D[ A=8 GEAA [
5JoFG20A9@[J8"L21@=22.23)AM4 L5֠)26!O7H00!O8!O9!OA$2BA=5@2CQDQEQF@30 C@=31@3V133S4S5S_6 @"R7S8S9SA  @n83B E3CbEC GEG3D+3C
[$XESF@40ZS4143M.44
0!`
p2Ba}aoiapa] 	]ib{ab][Z58
_ADR
 [Z6bGG47
ZqY$4]7+480P14/48E8Z9?& @fhAK4A [#~ZBK%4C*`p`qjp`b.48ee` ap G dpyTAcCߒdcqj
{a
;bp2d4DqjP.bbtd
oEpubk062dcrdq49` dza
a0Qp *rfuf1lf a)dou`['i
0aiZFL
_
 
B GwA  G&y
Axlry;9 ){ x({ Bx?y '&fDKZE䀣j[)4B B@51pibpkdrd
ed!lwd hb ub rb

bWhbЂ2`3`4#DjV+52#E3 B53crc)5}4"bNЂu5iwBnar&/4Fab 4bb4"64w$Q5Єbu~6atb
bc`6abkт`bac`х6p
 m56uCAܢ9<4F
052C54CPk53]12]Baas)_S3D
4D
[Ђ7b pW

[HNЂ8brc59
`?
[I	ћ!jv5CDI5AZ5Z6Z61U2 @} 63 H$64    .65AS66@a7 68 )69A H6Bk E6Q6D!E!F)70K71

L$71+723 
<[=ޱ  @4>75 aO77R8 } N79 A@7BC`
[+tbD@7E;a7FG)80o  $81K8282V3ү411P185V0C86V.87288qY!b9U8v888DGqE[#\_GL_*bp
`{s`Pb!
dv`J`8B8C{hsp2jp
p
H񵂸;w|62a|Q.8Db!t[0Bya
c}cbaa6F
/@ hdvdwd
`y
`ayik62c{ca A`@90 (8P 
!1}x 92"hi;0`y`jB.936``wh
+c94Pk66PayjabyPc67c d{}dЅ67M$95Eik3r5
bMbC{bswc
eufey res 
 dd)idnh
 y
ceрe+65cAaϠh\`z> buc/@࿘02u`ij}q`=Jq6
*705*6F&3Dԑ!
 i
 A97\2ip2k6BrGQ1ߡBGE08CD'%[pj
[IF09 @
9Zќ9ѫ9BC2S9!E qF CKA0
܁`AB`Cߠ
z0	;z{`J a0 
bw
t
	ra0/ Cz`U1@C2(P{@
!ry"@A1
pI6'wBP1A2
յrRipH9D`Fa{`s ` 
p{z wiA ;!){a` `bqA1ob AC3	_B`p!Dw
h РNn }QQ`c Q1
ccF~EA4
l
H3A5.A6Pe _{ky
P}A5  }`4emj
Q6{`Q
xQ7pp #6b}e
e/D t !6	^e@6e}`P4@dAy4{k
h`}aC
 Ѕ9C; y0̿Cp?d`0*Ad Pk9ABSBe@?A8 pfbcdyce@
!t.AAhif"f
j
rQ9p
EbRdB	! J '3!P.
D έp"M" 6*3!!C$H  I3!$Bb+(d' p3! !Ab	C@bDP}yacZD@cE ,Ub,`,EF dbrbAB*bAZA8crcAD

W[@AYAQAF-_PSWq\\AE4F Q1513F[?(C0B0bB1:72b0B313?4_567
84bZ:L_;<P=>?@CBPacQ:A eGIP9qLb
SL#qL;bL9bH\BA	9B	
#  y !RB lh``ـ `BDu!R@BE	Sp	aא`	`lBFV`yX vC0	PY1AZ	|AZ٤`[OC8a_UID
`_STA UE^^.њ!_DISQBFh^i^_SRS1C0hi^@Uy`\9\a]^B_fyfOafbA\@B\be^C /gnn_inj\$J\cm^D?ov voqvr\pN\	hu^EOw~y@zQ\ \i}^F_\\j^60o"Ɏ#H\Q\k!1@2ٖ3/B7YoAu^79 &22
[1ZBCC
rDz<YE [#1"Z0&67u[YBJbFơvX	6ӤB,C046D0MPD1
,;pD1PD2 3
Lu34 __S3D
4 mD52+(0!_D6
 h!!!33`02*X7#B4pYK8
`35 {i1`=h {`h`+`35i12$S q\._SB_9t
A._DOS1
 ao[^Ab/ha[DC0P
_DCcD5
aG aSS0Zhsc1 jRReD2⿆⿪eEjJehqFB D6	5@p
0{\/S4֑86
DFѼFD  жaa KqAh[ip.7A hO  t a\\/W3CA}QE QF,FGpJ58 E0
96hj
7hi0`~8Fl`CpE1#5pFhVB810CFDp#G7SDX 5E2
^/ E}0klG63 o86`q #a&5 [E4 0ľ$aaC0A_B[O	 6c+287P` 
p5_ON_ 87q3_OFF }_PR00ZE60Z58[H ׄ	_GPE
	3
 ]P
Gb b@Gof f@y E8E9ҠEA@ BC

@ED`EE F`
/_REG(pi1pP0A
a	iUEB:F0@[L @@F1  0ZF2 #3 45 6 7 8U9 A1 B FC" DF1FF C100^1 23 456789^A Bs]CsD@E C110
1U
21314151`1171819111B1Cp11D_INI T11EC
>NC1
F0w20q1
q2#3
q4
uq5Ѡ126s]78

q912AB
Unknown 
NiMH 
LiIon NCС0>-{ 3Ф!ѡE800`ѤE8д@
d1XDED
731TeAC c
@K A+}ha{a
V%#}i!3 
QS!*2q*2&Y12D	ZZE -Ѣ'6"E	-7p
{`QI1)F
[)h`p4`
csc
  dziWr`a[)}a2bsdba3U/3Tz4X56ccCC130	 UhgS0+Eg
#ʕ!11 {`gPPW919CAApFC!0
01>Y@=02w@ w 8axra
c 
dcbpbw@Ѣba"C9C@BE`?FaD A2`a*DM.11gA/1&@[I94
9:+;p
  'N4>;	ip
Q!2<>9Z[?3G4c?5cI4A6T C pھA
{ `z@[{``P6Jpq:7dd@1U  9X2c cpT e_e\eQ\xcpe'cpc\)J2J,@6 p}
28p
a !S113Ю(_Q0!3YTQPPʐe4eR!b
dp
aߡp
AC
b"a:e5\0TZ_ L7]l8['llTZ3_gK!h6|` 
;R0oa139
oPR_CPU0rRo1_
o2s2l7lmnsN!h8Sp0#@7#g
]
qA
zBp#e9Sp:|geA gqCdBDdE _Q10 8-(`z3ax1xYy(}_A#}1}z|{F
{ .BiAi[4
3PNp>a40[pα p 52 431l 546q7 L
849A1]414DEF50p 5q5354@
[P `'15a56ђ5 561515aL5BJ5Pp
UVaC aaв15DBrR.`)ҡ0`ҡpҡ1B a^Q
 y@7a`JE5F1/s1EPc b1Fb1DcGNR1Eb?Cc3!51bqaa0a53c0>5F[ya
A
 d
b
 0:bdpdAQc
 c
0:c&C/5FO
C160B3`kaa
a
vj albbжb
vbkb.P6zp 4FpbgD 49}ERC9P6і51#!!Bzj
j12b0Q53=p1ѓ6" b b/	a/ .bbG62@05Bס12j4J5 P`A63`p*412v t56p4
{C0P`{24 ia``aDh
!KA5	Ѡ`aE2Xa 9c7.abcq.K0)66 p^}^7cIuqo68L
069

Gy 9נ16BAĆ?5EP\@/6&6BQjBQԠ`9[E6D _DDN
COM16E6F6w
30%" a8y 0S 6F@06EvϡQ4
 !+_DIS ;23#.6E=
KF_SRS 2h
@0707`ag1/70R0"/6E@
0D

 xqS3xy큡c/HQ'[0@1   
r_ON_`#

_OFF``r0 71[H:@2 [4@3_ADR_FDI"
O
_

%


e


 ބ) 
GG?"@ * y4r 
`zscbr 75 .Qq77Q7j77Q7CDB	=`7E A 7FJ,1A1uq80:	@,780+
G_w#0c84#AQ+"I	r0/@"/84DFxB~r" 0)0#c#r%$+[4 	@0+41\RMV73a cU/0E3gcg`g	MpE!85O
:32b#6p^3q`y8685[L$z7M޽C
_G 0" *
9Co;b9mF4
<x
K/O	Fг@^,0K՝0FA]9 A: *;@#/$
	o%U#Q'()88	@(,,88[C89P䰏MAp`2] 2B
8#Ac^Q1a^'C6B6Q8CH
1 Gxx<xx":bx2;xxc@<Fec@<c "g dhehc oh1e lLjlo8PGTP%c6C6CENB/CP?r,_.ysQCG]lg *KD~'8DLM4MDqQr4Q/RaS 1x12Dqp1Lv& -UVpMF,E.& Gsܱ[F)90 p\/ Ӡ0C58Q(g>`{Fsi /PNV80[#\_GL_{16
a;['$hGP91b}ab
}[%lRSC  " C ypq,@ @ "m`~[7Fĥ 
9G "   *""@ĥ׿a a -갖5ĥ
Gp p Gr rЮ" ڶ6` }`Gd d]"J[I 9p7a
" yQ98
99E98 1ӵ3199&O.k!   0_[+Ap   Үs QqF	729B  "9C
@[QaD  INI4D#EFa,`A0p!1 C0AC_S3D
аS4!B@@jC9[B0x03 +E_GTM 1p2p`0Y4ЀDA506p@ǰA+{UA5
PAWA5 F5MhhdhѠFi 10/
w07a:`@!` bwb
bwc@ib ac qrbUrcqu`AabA8"cAo8bca͠:߹9/!{PJEsD9I
C[07]F A͆QK0Ń0C ?RO,A#֠I
=E3
`M
?_ڟ۽ܠ)_qCXOQB-3D.
G_PS /3# o +@A1`i!^.C0C2q	
# i q3C4C5OC6C76	C8C9L0D +\_PICu h`\/VM pT MqE
sZ
sGC5F
 Q\AA
Y +Bp5\
?sF!"`#h`#A
sds ;!
"(a#Y A$Y!%&Y&	b33@	F
@//d
d
Primary 
102 
LIon 
Hewlett-Pack?ard E/0?Travel13.2~@8r.19L30	E7!<h`/`p?%
 O4t}
@
 
g33hr A<U4a<\1Aa\AD<=4ha`3A2hAp3
_UID S/E@F2B
_BI!< KSTRK [CL\1[GP3C(H6R)Fs(EtJ	KTJLLIM9B_
ACPIp63LFRPcJC`3O0-`; prZ`B631`3DƢ[:.p
_*_LIDsOB86@
	/15?@SXr̀N^QD8jbFcfpB0c@vB1c`d2@kk`!h`piaF?B`z a?{`
 go }ahgiap`ۈkpak àg yk ˠg1Эm 7 AFck MB3

[ f@[mBqq `rBqq`rrp}
yj 0re >11@h)h`PB3`xibbasabcpcau`a9`d4rwr i`zC03F
`#aq|43|b`a
}b

AB5d?!`d6sH0WDGD
PRU4<SMrJ/NAA T-MP2T덶AB ;9Kp$[?AC+|Nr2J)lBC CWQAAg*u1UCES
 %{|AQl&q߇ rBy5 zs
K? B
FfghiGWSAB풰
FbB57ipi%1F@ 3`恐O C
COMPAQ|PC C֠3 S1tReader|GEMPLUS|GPR400|PSCR|B %W	QtBQRNWSBC$!Pig7`7a;31na$`|2Z034a046
a}[Q8 Jq[#!l[#\_GL_wy037 vpj|8pk|lq|B\AhB`	l['¢['!\@B9?

[``dA!BC C1C6CphQCq9˩B/zAǩ{h
DBAp{zh
i C	8L7 PGDCG倀FAD0D1+q2D3R>D4 5 5rD PR1D6DD5
[PD7@(AnD89 sҧD1DABO oDAUyA
	`rh`k`vQRFMDCao[D7М cdJac
`rdn b}yvbaya
a0alr  eraye
	 evepeD0c ucdcMdD0_ { bpbgC	bdp@ apbe)ee ffg
fape`pfzfgvdueA`bD0` g0`r<b pg$8aggagubdM:E04B0!ZD3p@`cpb1TB2fy@5ш0CD0Cо"EhD0h H
bh`ձPc `rVEcP)adAB
ecCD30-adOft`fuad´uc2ftdg:ݔI`Ĕbp@FDF D4P30CADEaD4`{
_INIFB51pibhbC1E0p0E0t1ZdjDE1x2c522rbPW3 w
aru ZDbAb@`babuaa@wbua`R+_CRS0D`ܒaoE3``2Ot0R}`'`Мњ~!
	   yZQE4AE5=
:GG   @   r  ySE5[wDB1E7067F
bGP G$ $ GN N P P Gh h Gt tr   G@p`s #y n^^0
E4{6T0_!@@
3Bp4RB`
5BP M\_PTSphO2HSp ˒ uWJ nufbEB"\_WAKQDg)B7CEA00EAC@C0F10o!k60TZE8 TZ1_
V!2!p@0A
DQ!r3NWXb%>C

%Da(Xcbcco*Fa
Kc$9"B9 oAB
 ˟AC
0!B L1LL150M,
720N\ 9G,<

08n6

78:o;b=;==;AҳEB T C D
E
@obFKB1HBlB3WB4ZD5BGFB6 37b38
wA F7
۠CjF6 
41FLJ0i0KB8
0 p
K2Kp
'L>!rIyIOiRL0IAGH0F9
rIhF6p
~`2Gpi`K9@z~NOrYQ=iaGRO`\QB0pFAHfahF5i0h qAbQ7BBi ` a I6f8
+piP^&pKDE
8370pPB2akhmRW37t
axa

`bPP08E

bt_kls
 nbm

pqm	1?r
!
H\Oou_L~BC	F eadP*sdIp{v3 I{b
 t bbwb

aranMpLa!1_*"KC?)a~;"a3h ~~1a4 "a@ $21gy
bI	`38b  ֡Cpibh  a`%.  dqN F2<Q#aBW1Sj1"я!yBD`h{V!3_
Rb38j M0FD
>b jh w`t`n`x`}fdf
p{tf{fϔ At<QBncbbn }b&8A{dbbFi`%

ep
dk
0MPdyRpmdpame@i)"ف!xB	sr{Baa_a[6BE	R@H
?_ON_QW`dVcFFQW9@F]
ԫw
200]
T
u1]
Բ
~[32B  _PR0E["3
mxF3w 35m1[H!_AL42q1CAsL2CpAL3C5_AC0ArA r11r2/r3P@pPSVERSLPR_CP_U0G60`BgҎG(r{aj юEBpECp
qAp
A$:E ͡pD_TSP
dC1TC2ѻCRT0kPTMP1 [[G"7@208jȲ,mѲ{f3  ǀL? LC\_GPEH9bC209>iH_L0yz E{` ,{`
4x!rm
2""p
p304?1SB<5C_2SD3N_L11{6`O36.X{{1
A+046
X45J
`maA*OIP^aaPa `a ~ ga   aI!p"07 {64?`}@/446C0D6?_t8$KrC"б./5KMDdr644
 ec9$C`H @c3r9'RR$$ ["SSDT%COMPAQCPQGysr   MSwFTA?(B:
e#б&y &O  &C%&
')a_PDC{h`Ў+PCT k
+(Q.B	_PPC YƐ-SS-N/.S/0O/ 22 124?567_:9 <;>?>_?AAC CFFHpI11 KH?L_MN?PPS RU?UXWXYZ \]___?bb          U|˅;   @ ` .UNDIL   ?OPCIR C      |P    $PnP   i\!ZAsusTek/ MSI/ 
Broadcom 440X Fast Ethernet Boot Agent v2.0.3Copyright (C) 2000-3 Corporation
19970 IntelAll "s reserved.
  , PXE-2.1 (build 082)E
MBA  
t2ôu3CUf`F  fa] j j
j
PS^< t	2PC[X] a$0<9vP EPb їFP"fPf!fsP #f~I#j:6$ݫ$SQ^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlV ,Vv-,#-^ ,^~P.˗.]0Uf^]2 tw@Q2?Ĉ  t^@:^QS0 [Y 5.> th  Ph2T6 M6 F6?SQfRWV`55	hJ$Af.>I t.;@  >  U  r rD: h'@ ۹H l 8tY[i
EC1: Base-code ROM ID structure was n	found.T@0: ASF is? enabl canBl .   YJ0;?	8Sfj j '>  t;sf=$BC$uErPj W1II떌WێE::0J f&J=  .W6O!P!P!P~j Ph9&u
˃Z t9hlRgo>?C_L er() ==  ްrI?hC%M0F: ExitingWAEAT6
?^_fZY[ M, ~\. f"]0]Q]S^pf
 T&6 +&`fRSfP& f1+3ffJtuہ 3fX[fZА+Pb.\ T6&aԋ`@#SfWfUj j  I IRV T&a.~6E.i.i.i.i
"] ]0,ЉVe^l_l6Usmp]IoWopRf6U_fVq@rRR{ t t`tȠ:ɐ=P`4@2DBIOS extended memory c
 errorgC6: driver imageqDinvaliXC8: !AEAC@{y2Asegm
gC9:NV+|}: u P:O u5hw_d5@3@iCA){feI\M^f^f.O sDhP:JEw/x  AHrVMTMԊzrvf&D F&D@+ Bђ H PeJR&DKV@I&(Dv"	xijkWj &\R
Qs;b5uBpءL ` N b f3҃Whf[ fR@#XfZR&  oYju*U R$8vuj@aH F FRqvXtuPWfG HF +F )F[fSVWFa  6_ QgfTN Э  f _^f[^Rf]f_f[fX1,q8S`aYfr PcpcJt ucS``tfp  OffP= t.. oﾭށ.s	N]&}t	At+{f&} us@#.N9wf&+f&;EyskfXRCw@=  
 s@ȼr@#&_f.+qꠓuf@Aqf]33pfP: mPXätA+ȓ+C'8^G3pŋ. G30󫧄Q1v=`` _ՐAԊs}
b  P:0  u	b [DbAtECԊ\sCO  `ʾ_&<|t.;60 rb %Xr< u`ɉw_G&DP?  &L5l W&  e" G(e*10 8e2:.06 >a Xƪht޼ ^◃W,r*!rدG  *s.r`Tۭ &$јp`Ƀ?I Q\f[]#<fZö@#h
!,t
fX  W`gQhf3 Rf8f` f u0Hu 065/fpfuff#°H`дuo fðl;(fu31 6	Itff )@Ha41t'0g#d1,+	AegfZL f f  f͘` aD0 f9 ȀdqRf qw _|`4 tfZZY N RYq5u 2
  @tf<A
 	fSp OA f\
a`
_fY
Oa
 
@T8
`SȀd@R@+a}`f
úfffZ2P8fXQf A
I=f;tfIu=@Zr`5pu$T?3.G.P #.1.`Pa	P I@I.( SXf% 	QdI]1,qp  f?_SM_ts OvQj S1I/֐IA# A$ЀwrgrafGtWO Q踠l Yuf wXf,g8 tIt#gfXfg)f@lg@tgeNPnPuW32&C&:]u
uB~,}
 t7pQ RSj`&]
[uh/e%03tBSW ߀;$u> PuAMu	>P5Gu݃f2P\3p 11I0f>tf  fWf   t;h6Y4@07:  PCI#callBsupport E~	:uQ.;D>7?8Dtttnh>+%<1yn><Device!OqpY%<4Xx read!Y<configuration space`p3ffbj  wPRXu
pü |U.~ QP>`PafR. .M2<tR?h%SU%<yOpRH1requires DDIM>lp$ h b"% ?CS6Q'jcfjсdfhfQAPeu0?h
b6x
Ic{ PMM funcRHnumbe yZ u&h[E\=ocCHxg`Pf1frgfgfff_.=P>I cI.@0tt	 t5` `fd>phpgfg &u zSeh`bi STk%t p>=q(r$.   2_qrstu vx?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_  !#?$_%&'() *,?-_./012 35?6_789:; <>??_@ABCD EG?H_IJKLM NP?Q_RSTUV WY?Z_[\]^_ `b?c_defgh ik?l_mnopq rt?u_vwxyz {}?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_ ?_  ?_	
 
?_ ?_ ? _!"#$% &(?)_*+,-. /1?2_34567 8:?;_<=>?@ AC?D_EFGHI JL?M_NOPQR SU?V_WXYZ[ \^?__`abcd eg?h_ijklm np?q_rstuv wy?z_{|}~ ?_߈ ?_ߑ ?_ߚ ?_ߣ ?_߬ ?_ߵ ?_߾ ?_ğſ ?_͟ο ?_֟׿ ?_ߟ ?_ ?_ ?_  ?_ 	?
_
 ?_ ?_ ! "$?%_&'()* +-?._/0123 46?7_89:;< =??@_ABCDE FH?I_JKLMN OQ?R_STUVWDXYZZZ%\(\&\&\;^T&_4^A2``3^UB2bb1^Y e-^
g`athbtcuj N%ҜkJo!c-ڱF)gB1Z5{^R9wVs=	G,bC
f(j$O יnKv8ϤS<rW[0ǉ~_z4\y7X3}?ȆqTu;P#mHi'лL@e+
D/ؖaUp>Q:̓t6x]|2ŮY*ݓdA`.EIl"M&hiZeeee@eeX d  	e0 
~ eP e` 
epcB} 6ee ~Id7PƄi["#\$$x'))))Z*<*J*t))+0//$$Z/^1'|ZDIX+802.3  tttttWS ˌt&  .V!POXEXe erE}Ɓe?6+@:e^S0NV+,9
e@p@
efUfSfQfRfWfVfPFwO. ~
,2&22ێӼ46h@ WP追
0 fXf^f_fZfYf[f].?>  u
o` @ Ѣfv
Phm.6 j }ːfUfBg]g}wer`áf&.2؎РfUӢS@f]f!& tPu`1Ϥfڃ>*2 tj ÐSf. ff"2&2. -  2f3"Q. 3h f&P f&*2 []`ñj "9h uf. ?fh `P eV@ g&5 e+g&B^r t0g S̸[Se5P?PfX&Ʋ=PVu NVf.ߋ f ]ϝp p Z 2.   ~F~`~ uː u^&鿐Fѧ5FsB҇sӗ{sӓsss%ssQs'sӷ{ssߕ{C	q1	g-	])	S%	I_	{?	5
+o!π== w. *4>HR\fpzF1щ~@aσ>
9 ta h@62X9^&G99&G	
9@6o
9Bu43Ȁg>6_u3$8fj@!븈 d
"4uPZ8K6p230F6^G#FG%F 6FF~sE>6 u>^`*F)^V@` ){ tGKTRt 	`
9 (:`  0jKdr^A^V":1"+/BCAt"G0H`0r~Gtp uG t>G ޡ7
$! W
 )
$ I
F- VF^	#	
+t*u!
 	m 

	3	C& 9 P0 P 6F9GwaÐii"9pwذBPV&  VF  	F0}@6pFrpT^ `ڿ^V usF~'}p6 !ta  2#u?B!!#" o->uL!F ^`OfNF?^F  ^+t2)@*^v&)F& #~|--./qvg@j.*Ht
H|p
H~H@2` FF^)Q-ftv;Qp{45pWF7"4 #Fv:6f&p:&?@
44.:Ʋ7@
p8#<<ݻP<s0<1
AFGGU?&G(7?*G,2?fGAGfG." G#BA}^ো_#!_%2!(3 r)LC 	Dr	t2PF
cpcM"PpCaVcr)F v@.ވ"p`/GDH3t@IB2"E 1
<
?3_1QC_%*1"\83TUu"뀵-pG ~6*Gff`Df
hAp\!W@bjjWաD C4m0G퐟$ZP^$&G	r
rc!QGvcgrxcgajGGubjZGbjՁdx	bjdx
]Gr{cg
r}cgF 6 /fl`G3@WgtrF--3- @v<
  FFuf f1#}Ǡ  't
riϐ>pKt, 
 kD@Ƌ^F^VpK" .
pf1ܠpC
  -"ZgB  @^7v3
*&o@D @+{u++u$+u3	 KFFg4PQs?&tbs4-  @
LA~ԝ7>h > %'`$fF$aaM?\F}k
zPu2aPSV ppN9u2Gv_@x|?GrЩGÐz]wO W@@ @Pj P3۸YFiV԰@pRS$1$ÜX	S[	[PA}Sf3یfff[F @]qQN$     YrfSQVߋNfP¸$" з[!ff``B@0ρ v0*f+fX" " +$^Yf[sVWv^~F
N~ tIfȃt_^PQWfaBğ~NWqªQYê_YfX]a0..v= c"yɠ
S2P%trIFyrr̢ȀϢ.ǋFҀ}F++ ɂ"2$2`N`&(	@pP P0 ;FtN 鰭aBG@pVQȋsLY^<  ^]1}WfP2ff
`BúffP~fX ŝ_]}ހ}f$ +ڜ2C@@bPQRѹ`;ssZY1ffRPFr2^*/NpF!=Dw=Ds-t01-Gr	- vHHt!!HP L 跊P&VjWpt	3cVF@
  ~ 33(L$p2	ೡub% $P`ntZuVAE
v P`dpKPS'  0]V @K Q%0F 6((0A  @RPV^c }I+ұWL9Pu(
!Q9@u9Pgu
pP
?ﾺޢ ?P%0f+}f9Fu0P*~u0P% @!LN_!t ?,0H? McM"~}+vu9P
uދG
:$
𰫀%@$̰cM%0P`NN pF+v&FPC9F|,㮬M]$pI j#0P!t_PC8h60#`À*PÃİVrx!G
r,
r"Ph v*@y 뷐2QǇY&0H./[t1QG0@!(,*,,,.,0,2,40S 7Ox32y|3HGBV t; u`0Wd|䞁Q`9 (SA:}w6/L8`?@S7`ӻOq@*T@C,K"$CmCp6+ҦQ>Z`R©fFڋFbA[Q:NA#;G  {*VA1	F J9FuN\!P@K+F{HP~p0P  V_v Pp!V7`Ӌw2@PK"*@u#(KH#؋v`UtRc `SwA5bZ9FD HUG+9(I#+3؁:TnZ_hGI@III0t0Bp;F"bp'F+FNFOaO.9FPcPb;FUf`CQQ.*VZ^V"SSjThUKVFbHcr)mrL fc  '"t"oJ P2Cq0;0e@u&jCXXYjYaZ0x[\<0\	^0^dx_;-%P2;j0?9?u⮥?2*K|V 9?@Jv "@Є  ~ ~8,)Fy}^3D`U@2;i0J@ьAD+p6;FsG+05[FVuxrG 0GGR3 lq? `Щ?Ѹ?A05F +*#{.]0I骀^ejQWQJ_fcwM `@Єa4+@oP~nVp0CvS@wTBhUr LVO^fMb?F\qVP2F  GPdxM0UԈ ?^9@ts@^
`@KT!'u9z^͸`\ 	+;u
;uܤ!
qa93vUءx t5䦃x t:VCB7t32v@?3Qe=Q^9f4u{"y#@Nt$L(X)=uGtDtDtu"Hje*+Pj+0c,؀^[؋>`ܱ20FډGj12ؑGq_G,2} _p߉G'v0؃'$@ ưɋV'820[氇`dpbPPfh  fh  j@RPFPvp_72B9߃ u-^ jp'3 P p T؃
G3
G4
G5
G6
G7
G8tjG-PG3+ӑ/?EfG7?tG{A7_q#GH8C"S`ؑv0s
P@+`jE_.GOBA8N
 



 
$
(,048<@DHLPTX\~xrlf`ZTNHB<_GC3?,-`9GtĀ8P"m p
rA1Ãn
@u .cDPf܀ t ݿ MGP9( o&Tu>$ o  A{c8 Z" Q" H" ?tP
 0C 0
Āt$0
37
ApB]Gor/)
!
`WI+`9F
  
0k t `-O!_ w-*+d-fv(f
ffff 
ס1- t 	
ZPՋV  t	Ր0/ 9 =   w t	a		8 4艁/
t2=~` t	dn !~ @^Q1/UA	1%	A,`B^_:RSf`=prP-X 	``@d&C`لP2ÙA&*&!9fg
 8:Q`bá>gG)Z.QG`
 ;q0Vff}!f~ ùQGV7R	G
	WP
WQGG/WpH Q;!Jq`gF"(U 9:::U: :!: :U@:%::):PRP(3A$A%
r#
1B u0U*PЊOԊ OъOa
 +ҕF*p
$AC8DhD1B\"A|
A%'0N)0O+AN-0O/N10O3N50O7aZS90O;SQ=0O0SA0OCSE0OGSI0OKjASM0OO䵆SQ0OSuZSU0OWadSY0O[SS]V0O_!BSa0Oc1Se0Og Si0OkjASm0Ooq0Osb0Okb0Ob0O!Zb0Ob0ObV0OAb0ON0Oeb0OjaTb0OCb0O!2Zb0O!b0Obٶ0OANV0Or0Or0Oau0Ou0O0ҋEG֋UI yKDyQ ySDyUa ycDye ygBy}p:;W }| })|+*lm yDy yӪDy yDy y۪Dy yDy yDy yD|
| }!|# }%|' }-|/~	~ڸ0T&Aet񱤈u	  0)ڀA薠PN
`{:u4tA*eH`0)0AEFсʫPQɎme>#PS$p	Fq3[rØ!<L2`)PS=P$h p6#}%^1pͽ@ h8 ϒ Gh"N Hppf!G
N   !
 *	HtHtHt@V0AAyS8Ģ  @ƁfyP	FuEuSfp͔pJ@.JsT?F t⑯`	ڬEfU៽38ျ7 ͋G#FG%F^F^VFVF~%3F tP+Ff%߀  f *_#Gb3_%FtSRf *$%3w2`>	O V%@8^P4Qf.S.ˑ#SƇ 3Gf Ghq	7=h=UరVЮ<;`4GѴVGW @u̐T'FFV FF+Ґ9Wdrw9GbvΫDܣq 2rrзvkt!o̅B ڼ@8W`FEP4y9~3ã36䧵R 82*p"bka4AÐజ6S+ fմF  7u	Q	"0t0QԪ	@NF~@8FB}  1
N~?? p 2~st.GGMF~
uFޠQ*PP'Ň uPYFt]  T@.S>stf" ?ۑ 
@χ f2sLP1bA@ut@XPǇ 5Ft!d [t뻱
 ?q(@	*bץ(C!퇰2f3ҿffu9	òރ"a HǇ@KJݣQGi@#A,sQ&Ǹ w0q~T wzaKƇ123PG
>

g Gw% qR0U"wqqДqiēq9 
 fPA##aݧ@Bк6$$v"4 E&k('.2E1J 1B #M ``  3PS΁GȃG`q0PAPSNN9u2Ѵv?@0>G{V99G쁇}2O|04@0[x ɬp  s Նnn< 1Q@FGz@@p@w;GQ@GvTC`CDx@,%7@AC{CG`1}CHCұH`f+f\ rIC
LpLC DWԠ4H#1h tPfj ܃
!ÊFr<t<uAÈGpQ@GjA׈Gq3RkAňGr3RlAĈGs3RmAǈGtz3RnAƈGu3RwoF`%ʩ)Q@ b X䐲bYSYzAuB@ff0Rpj|I?3pHG%C% u\R\%]#pDDwRqap$̕$% 'b'T vcq(WdpR)A)賸euQԞ_nF|t1JIrE,6b| Mא=#3 /@0@1234
FV
fq`t@ t^F&^F&
u; SWV~ANV^_|B}}~ŠߦA~y~ќFN
ȋNu	] }S!f{
2[N`SF PN3a_3E^yupfr;Vwr;Fv+FV
+FV؃ 2P#   P blksize tҌU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg`h i : ? a y w <v bt x j  s |1 
CLIENT MAC ADDR:!XENV+     GUID:
DHCP.Client:Arch:}0q:UNDIci0 dIP SKǝPROXYǢ
GATEWA£ ?MD  BD
Auto-select:
 0BOOT ?SERVERգ)ѝϦϫ/Ӫ-->  MTFTP0-T  Abortedroxy¢service did not reply toquest on p 4011.   coulClocate acureer Mi?ssing  address BIS bad ry structqchecksum get signaRinforma{tifail!free mecmoл)bopobj@ authorizþ flag!shutdow!i?nitial9mage/creYd  v0dϾintegrity54Netwo{rkcanc d by key ok`ARP timeoutopenError - F@ }NpfoundAcc Viol receivfrom unknopcoderep
Paconn@ө2Ը NoS poffers wep?Z Фހۢf@namw In џ API fun numbŠICr multicast4whathrb PHYfigurDataaћEEMsettarrupdtoo many /packs̒PisP M?edia tq!p,4cable NBPQbioӿbas Bp4discolip = nu and/fmp憾 C-آstrePnџ-mຠ de.  /-\
SM/D?MI BIOs ne d_U_	d
|!u
 zo uQPːz u{& 鐃>.3 u3\.3h[0N0-  r- vHHt
- r뾐:: 1LP3  P=?6 H10A)~!aoP='y$30-q6`k
hx9 -i[#3utyI[놢[3m{o33A뽼33=S#?	3=1 tw5= }.f   0))$=q 0w-2 tHt-= +7-s +HH -!
q` i  q9  >9 tQP JL`df99f22hP99@t{<I`kty3^h
J`kShRF~@g }R84RF9*9Fr䡸93M`k蹱3n>uY!" 1J7NMqIHp tptE|jOhR HFP)9Fu9R 9빮Q}/>0u>t/II7ؕL0N!//9P{0C  VPY+ҊԊ*ґE@zVF=+$ fVu3Aw>0t3E(3*3(h2OvqO E_/0N	1(37f(3Ifp7sEy WN뜐T3Ih96:6O636H3 |3O8tְE2u}dL% KҀĀfVQL0zGM|f+KfPI&VFVP7Puf6(RPK	0M" 9UabWFS?V^f`PVr$=NVu^F^f&{G(0zX^Pw؁yaCu-Е- v/&iGN@z^& u*&GaCz =pa u6s&GibCG#&br<a0]OfQ1N@]U .Dy/9u/@g0/0G|Fo9`[Gf9  fP2 ~UU2kHkm3l@k\3lPkKUajS*&`fPaj&(GbpG0FF5FF~bp9G6TNfNfQhsHT7U04t:T^*&O;~S*\Pp|S3`uc#w#wE#w#w@{Aw!wGG$ac`u޴o
P!w(G	TbeG7(3@#AP!V;.3fpBb  t&}?#AoghiE04|0І RP0+Ԅ
ԄЄ`e3& 2),04恒BA3*E3:}aORTfqe|1aCa V-tHHu9#A5#AdfEqOoiCbe GPQЕ Еїї І P3cC_S& f`[`K<2i?B_vJELS3 Kn*2CŐA;uQLc|bed=3 =2 } Yc!0-6 tPK?u@OhiB.044@L@y|fgB@mӈBP3DЎo2!05N~O tItEdefQ@]W9 cfƐv2AϱCb
Q!_
s܀wŷGP1@]&W2604PcfkFlPDQk+0TU0T0T0T0T$mIfjF=vG*F $KI~ t
0M! FËF_Ft0M#ސ0f@ÐBjfIQ #ƑF	U80;?2#ɰF$ fBŚH2ƭ=F8jx0;VE/F%!0 . Ҫ0e W)VmGR_&(ѼPD$GfUE
8ǘ-VDn'@NwF=|E@0L S+;Vr
w;FvFF3Wh3HE^K U!<"00@T0Q0ŋF<pﾭ`ð5[F2=D8ǰF~ tfRu@0f WV2a 1}2^_2&s;( ӳC0ɐo7Hv⸀22f kftrHuVHu0HuraRPK00N`ЋV!GHt.;ԻRSRPV tDt@u2^+v
rD7D0`eN&]@rNF( U04r`z@ F`4@aht3k Kt3R3u3 7v
 Kf2fx{3@0L|a[cSc>v`zt!wGHtP-I tJ-
 tE~3 n
 5FFb1-q t c\|K0]f3뷐S~+u!2$ bR 7Fv&$$$$$$
$$$$$+$6$<$C$$$$$$$$F*FN`u^9 V r -
 tT`Fu{>4P+h"(CcG			th&CpX	Ch. Cf>	 kt.aL FTƁU.
AIu(5 eha]GFJ"w^Lqp_o	au&S8!w9L  0h6H0kǺ
 _ /=1>{F> ???= ׄF&GF>^t'X;F6F9"-WEf% !I6QMX_39"7Fq!^33H6&PF39F|ך"4O
.@f`2V@WQfjp88Vh: C$,h:G PV3`e!{ ?BF젵;BG<@  o>W@sqzWD^ZwH^ZL^Z({uXSXXҌWwT^ZX^Zw\^Z`^Zh?___hEu! KQX2cMWd=)= wA.JNlߔ=ako-& 51nD- t-;^- tTV@Р9vO00V=4~C HtzNR - 頟F2WWRZWgG 7WpdÌ²W!&ǉWg4&xx;yy1x&wty{Gy{u$g$n	r"G$"hX	 苏DP hs F*Ci 鱮y`iW
 Sw"8~xyjvT:,,@Cg,&_*|&_~-5{ -1k	mt- t:p ` t$ u&?  u
Әbq ᣀ?tB&9Guf& u  t؍G =
 
*!ĩ`DW V DvvvBi7Vj
 &fXfYffff88A 9ߠ 7:QFQjPe+ hB ix pqUVBIRPE T
ix &nPF>_ ep`h0L FA=zӂP5@7u~ t	F
3
UtltppR32S'Ȏ  ǆr D0577 虍880[** ӒѸȍӆt𰓞 t^ uf~39Glu䁔pu-$F%@qSRQfP
R
21T7Tx&B𬏭6贐 777"+۰ϰ) ̋0- Dt-gut)ó uQpu7h)%?Ȍq}sPi0P)'
I`^+ y
FPR`0$10TsT% x`DP ivt u-FF9F"iPu3P9`RI
bv0տ¥i񤦵ruP}.ivQU tFs1 =P"b԰h\V2-.>_cu1MtiԒی&j&hy){CyX5?c۳tt(uwH!kl> zHjil`=iFoPqU<fXST㋀`@2	 9{RtPs: _j\^@HtHtoi  3h5&bĘ 3F0h92 ;; t	ՍYl P~3iF01P81+20! dם+1&$: g 2
o
K23dEX1;~ t3Ǫ@9)T cq0(ӡF٫2LP;3tq* u
1C D+~ r,rPL2FPL^ V@Cu~3*=*.FT2   oSRPW|*/P7=00oP!!k :1\!Opo8*:5:0̣iv@:ĘTydh2 F=9G@?@&=O#N; ~ ta=+RAP
@:#PG&WI9FVQLPNstգL9Mu9PMuNt[~ tH3LPNFAG-Lvi~@:ᢋ؎F"pP~;\usJt
F":`s	-!`V6hOb0Sn21f>&f`f9thxфѦhoS0@R9 t@3 Kf1V1ƹ +uhc0 R09oP藡X@0`rh?0^(
A") f|
f`:+h: o[6 P)dF 5 9F~_ ! `ux_ aak_ aa^`
_ pL_ !d?  p }/^ۋ }cFпPps_P dg.eB +.1Q à_`ujRjS  F9v[~!uꈤ@l[U lu1b$+"ɮl tuntI1"4#:%t\ jfjvÐ fv  軵4rƃ3P x"𾑺a t&Gtz,@ 8{!e|tzl (| u}Rl taԐÄ|0~rƋGulp upxJxXyЗhPC4*t--ePEz k*3cpJrƉf&)f\pFFtR~ t^eE{{ P99Ŵ t
^aEu4y:Ÿpq^B\4:FFu	+63 >;`#	*a+4*6FuHa^3PHa* u9,35B3@3ń t^>u
B33`pJVBC YApPe PEe> w$x׋V;xP^ÑׁӉtOf6 a1\aP)տq"T"&
Iz)_R!1u[&x3肱 7" 
 hTR f+F^!K
&Fpa^OCNFc	9FsA곋^	&9uG×p|C@\	 1aIu$GR&_GPt`|P|tw To'qxP tt>~ tz_Tm/h;)2g
*(xGpJ&F h(Rð=# /Ӽhf 3{.-4)/$&	#u^S!JrJsIb ˴_(F YGV`=(Dvf&0O3űa(Pw2f`~^NvVFn
fa
P[2݁ǿ  h&$6h^V6  u	rwPd t^`¾tfX u	   0[VADuyTT u
vxkP2   v wr@TX`|X>s$t̆uCwDQȥhR6=GXEZFp"	 Kຉ	@Xv&@*!Y F;Fw~T\ `tH`> t\n>rR
Q_N\E^UR


B!×OR
4`&8g@p%3u;v
軺% ZFrZ l0Zs
Vṵ@?Ht'&+h%)%[VNExEV3o+ǝW;%X*%Yo!qrZ%Z
%*3P$Is=R $eHAѵuUZ$ ǆp6fǆl @ Ɔh$2	& @}n$  hO%= Btw3--,uIA `t#)"3R6- [t- 
tؑאĞ&8t&pP
u!pa@)h#ǆqG vȾq# ȠڂZ#WP`G%
h C @f*!"W'2" @"M9! `Z*#eR
9FrF
 $*+`vЎf^f喇^*hXfhp p7VV73 Qc/@\
P_fh  pV1b)v6O+p0- Py33 `J #=.t = t -t߶)p tN&fh1V}1q'2;Q447>^6U鿐O-=KF{ i=Bk)B'p,H S-	t-
-= K-w- 9t-
t- 0Mt- tpHts![pV>Pu1$ >TJ9 QK$9>
 tFu&"L^Y ^^ f!24r0P9t3 2 ވv3@fQv&8 u@ffǀSoctegF@fTt `UF9EuES>? ~4pVv3` $&X%@ UXYV~ t?f(`<auX   ]]Y^ƀS0e$^e4[bK
'@'`9N`J`63ףL3_z`v'kRKt	t(>	!ht3h9 29 h8_ LRM.bL3 {zRK VijPǄ ff92uvf`ku:P`9u1h&_&;w!nm``pn ߄f9l&{:lt_i}ju|jJcbdu93ba0bL3١pua=Ë2 2 f2m>J3P VFVN3 &FtoHHt	HZf([u"hdFhl}}+h; \Lu< Owu	= > 6S[Y4[Q  x ep
 !$dN3 	>bKE%+ RHct
sa#wtkl9Q%- `9,~L~~`? k?Tc>2 upo9:?h2 >#TK nc#uBW_WKSRWYWmOQXX*<X)"YZ=Vt9느Ff=E~ v[Y`ה ]M]!zY(3O*3y|~>Nكq ,}ziˠ#; -c ah?v9Pۣv@u9|Y$#R&sv90CWl#PQv9_!>	>ewڰ aa>4d4Qb v$ h|ahcQq%
rtf'k[:klkEp:p/0ܭi	S0krk9 3t\jiu0ᭃ v\v5 i9f > isQ!c-k"l#>rwpؓaqRÐJP3`-E0 1Q'*N t:upVErɭA,:,v*+1B2@`fj
 fXfYffffF~*FwF0^)FX9Fv	FˋF _;Fs"Э́~#v#Fg"JKpKf+fPӣ63أH3OtRP`? tH#O9M}b   Rᎋ;F
c:t `aK8C0 Ek9f"z@\fpfFF432N`3-6 5|p~cN˙baݐߍFPж"}$SK9R݃t9"*ȍh1_x? @'W fKf 5Hj5͋*ڙډN^bwFV;r
w;vG:Rݏ@@+؋FVw RݽsP}tt11~`:aPtJFV43?`Ff\f`9FKOaBްndFu
/E
3aUVVvpZ$0=  t)ArZw <Ar<Zw FC:t^`  VfC*N-0S^RPTt@T0r@T9v Qb  WVׂ00N!2ےwߒӁV3{^_tV 
2C`=ʙ~ -utF0C_PVY
p\"Fɽb\@bh8hV3# ,V3X3Y!Z3@03\3`3ta3barP  PJ@ol3n3 Ipa$k9pZ#O99p391%9%9(Q9v0)2rp!'d3'h3( Z$""#^PX3
 b0#!'u	W3 &߀?r"1wh83P~ f Q O Ru!ap͉V`6FV
22##rZ&w#2#62;ȿu5;u1N72o894A\4aS2s%jNQ1 Z3ъ]R$E0"0?-f@B. @-ff-%/o
/ A2V =	- @`F ^%2DDE FtG@F0+F;FwwHIM-DE+V`L"F"LL9'qG4 ƣpH@FFf>6 tKa;8rBw;6v:>d'F
?+6 68= X 
 pV܀~t	F~drጒkú> ur[r]u`۞/a/;Fu$<u&pt
f>  @usM% Ht `&pS69FXc8wNX$0d0V~ t*f^&G&tpj&9&9WxFm%  F"\p3u9Fou ot䑬!\/ `aj!U~@xP'q (9g(Pz9) t99~ u-b`!* =tu s1G*]
a'0 t7_F^(l{t#U0q9Fq9FW`ۉc4	PtĨwG@ur BruF9FnaQwnЍF;Foz
 F09FO99v<w7a*[	^x? Áavma҂Qi) k5}0y	yQ01]0A6:3k^9u9ukFPa=0 s
! uhph? .Ӕp!Ƈy`h9!  9֠9  
9h9Q
 fP3S3&R39099ր't'Gr耤9жG
P G`\F:zS"akFS3rPOs!sWkLP<'9+	rж̝$f0= u 2Җz 
=z@Ā]
u^
 uf^49u$ч@ w_mĖ"".@@d`Ңbq"@5๖ -{aah:3Mp99[h.:  t!@b m  f W`Z3$FPj9&_@]3Ð ÇE;#$P

׍F:u6~Ku+~Tu%~ {ua :~Bu~Pu
 ɰtް-E Rxʑˆz   ǆ~ԍx~ǀ谖 _Fÿ_aSQ @@݆;؋s_Y[\pF̿0Fآ0)ֻR%ԣ0)w9҇Ftېч$`$FFV6PFF~nF0@ FFF FFFϢF}P	F&uFP

@FF`>F/ST$PnVF̢5oFP%

@[.&NXf* PWQRU>@[@ > j>]ȃ us>@ ul>L |ibw[>* L &D F +ȋ  ( B`V6H ^;s/# !sԡ( ]ZY_3 ~WW_f`.P>9tJw.0 q.A!0t9а r   fa.>*N t&.(N! 9r & ӄt"QfP(N u8Pwh3ظ O&.(N&G.*N[i Y@Y!ĜSQ3ۿËȋdtFAÑhf
Qt`Y[`f.(N}I f.@[PQRvo 
A	˃ӈ@
  .,N X tZYXÿ.",N
 V3YӋû^]
 @PuYБc Yt24W  _^]Q  2sYÀ>[
 u[
Z
XР3aP; CX
n&5T
ωV
&AX
`  @"ɀ>@*u1UV?+T
)0VfT
!|sPf!-f/  j.)*+9Vw-rowq) '/|"*댐>
 tZF0 04hl * %^9s6߷P m@506NohUPV37$
F 8Ft)F ~ t$:$* ^P +Ҁ>F`Ƃ9R$Th ?	-t-w,tPWV$pݚ;N ^~&&Q#2#222##;u;u3Fsf9 uETFbI?99EbI;`Ku;Ku?o^_03V}PF!URO;Fti"puP9BTHL24bI961M9Kt4Z7SSuIbI%`KKQRQ fSfQfR?f Šf;sf;wf;orZv[s@fZfYf[]`SQ?r`Y[ PS? [Ft%&?	u
h*~ FATށ(wp;@   a `: .c'QddQdqd*`@+!`(Th0>ɱAT`pd&Gfk\kR 
kwCk9l#k*k lnk	ln
nnn
n{nu@2\Ru	s2?2Z]vxuxPRwZXPRZX]!3P
pc FNp;3032AgG6,؂av 0^aȁF+2à @tHH @\Р^
t\
fw`
Оf!d
-P kepd
 @hРtd
37d
+ǰ_2f
9u+?f>`0&_4`ϡh
f`
fj
+j
l
f6j
2+>>`Ƌd
o)R@@p@@ɟÃ> `,8a  ;u!+V+ɉNFu3 >^f&3wsО WI&O
NHp0FF&9wvhV a9GtS
=u V>!3Y,thn
V	n
P ɊAP◐rÌ AXVfWtXˋf`V0 +N uf3lf3@fƉFfFfF / ߍlV ?Vv^ ˿^~0w3204\f_f^]PNrX OfCORPfEDOMf`༿q ]'fqufѳuf=23AIt
f=46AIu!a\P^_ | PtFncapp(BN0+V
OFtcOF&0i0+Pλ*#~ ~N?BR帾C F0N V#N'WV~Ťӻ!NS@WVBt5x5Dǳ9~F&%G<ar<zw, arzw :wr p18PSYp(G0iGWwGg
oF GFGWFGOG2Cuԉ[3a[[2ҹ G;tTwGg
0ogwww_ߒs|F,Vn*&'*@û@ &l &n f%Pf#f#f#f#f#f#f#fXS & [ÌرWVS3`(}Gڃ@V@(
VN3tii8 V Auif
r;Vwr;FvN3ҖOu؃ [^_\^N
Ȁuu	A\S#wf
2Ӓ\($0:<9vFbSW ۋSR3.:uJGuZRƀt%@}uw0йt
 t L`$Pr< u	ZXCu33_[΀Z^_SM_h^v_DMI_`0}^a$PnPR@^M_SYSID_PxP2P tP'+܀Ntatn$aOa /+t  ?_	
 ?
_ ?_ ?_ !"#$% '?(_)*+,-. 0?1_234567 9?:_;<=>?@ B?C_DEFGHI K?L_MNOPQR T?U_VWXYZ[ ]?^__`abcd f?g_hijklm o?p_qrstuv x?y_z{|}    
    	 _BM "v }( J   _    )?_! P 4܊p,@ A4$&"@2
A, R
K$

 
a
(R Q
p _{Q0OoNDK 	Rʹ	 q* }	,#%}	ݯ() #,,?-x Q
#1/01+5P5 /4O5o69C3 #H9889Bq
T/C '@q
>+>::8'! F^B*Z::%3$CH cH!SF
H<8H9 IL@
<
IC-P: p@G1'	8	gSZ0:X1Ha@H@5DaLYZX\W C#`^6#G[/`]fb\ vodefg hj/kOlomnoC(1HXP
0P!rrH	\Ԑ r L rt:(p
`pUY Lsv:&p
b	K rͩxv w@w_
zC"p"!d2t8r xy@zs Lry!d!3hquty&B}hwu|B}@xqu|3A}jp
yrC  F`szyIB`wtPxA֢lvupRF@0YvwZqlwfPKyAXဣ@z0YzʀF  w4|!3Az` tA ^u
sLrw
sZ:!H	ͪ/q	I@XQ|qI@VSt#	Tu!_ 	!y'R z]6a|XPp
#t.	!N:'uʢѠ"rw0C`L:!g2Q70z(622AJt!᪅4u
Hrw ܠ҂*F:8z4װC8s䲪1ͧD::u6w 0ym<綅B:>4|t!u͉@Tw8@0yWBXz!B&Uͧ>:D	(:b`tz*<`$|,4L`Rsyu
ʰ<<:#yw
	,AWX"rAyߊ҃sQ|rH u`tF@ uwT$L!H:: βR|eRՆݐ%V <ZE|ǈrrStA젎uޱͻܠ(He!Hrj4C8: \ǈ̽u. ZE$wϭ|;Ո ?.S?@nW:  rz
@
| w~Iom e/'I "_x$'Og܏*Og :" ?rzO0O䠎<% 5	8AG`;QOﲘ́w >O1|$2  D( QEY^.mM$ ? TzX3v ΚUH μhK[ѱ[BMOλBQu߱` Ƀa+T@ȱ`2a
dedfZ@df\ׁ@0̈ek$pl^ {b##nвg@XAa+$2&Z"RA tXk 0bVĒe7  zaV z\V_PTcNRCQ {\PVH XeK ۶6NPEǑLz3L6J}R`A+H=cث# F;𖣘ب᪅DZd BC⽻r7!<͠+E	 Tq#VRB梨 "ѯX9r7BaZQ-00Q\.0^h@1G,0.(ҫ`&d01tYfx82pAh¯Ah$'lpAj¯bҳC٠pnx vK @a¯ u7~O P  !@`hQ`9@b3$fvA|ߠ0 ѽ1@đɘ0)`wTaz2"aFH7x[aK@ѳcVb=@1: 1tsހtWpҳaDϲP6   .     @	 _BM. "v }( B  @      #?_! H <*z5(5&5	$r
"pp
p
p0

̷́P
q
 p
 |pp ߊ p&q



  `܁"e ߁a     
 @@d`
Q34 0 $!A &!q
@dR  "2 d	cta#`!2#+  a#$r*4# a
$DA)A d*&a#@+@-%π% 0p'/> %$ :CZA/!%*& 	 7H y,t7 70$#9g
!(;Q#" ?"c#"`A%a #>:2@9/D#'bA'6,UC=p-#9@1073+9,"+*UCEIH 1=C0KQ5,r gMJCN@9`rKpUP5 /:aNdV4/SD:PAG u`( BeJjX($F" u*D\19ITC^b-0,KQr_
_%#!4a#LaYt*!((W+'!&$49^M@< \7q&6,!"D9 R4(Hdl+WTnȁB0(/R
 edcrVClcV"|Y '%@\/DPuRcJ Mvkx:@\ D_u\9Dv@a
CI^̤:#@+rklf9dh2' a#A>'!#Fr @uYFh\2) DՍv,Cxv ^!}l1@C0a#  P#iCeF}Zc# Hq~T K8I !IQlWė|ŋ:
5WE$ g	mė3T?`3 9#!=cEWFV9ėbWc9a3$'@A;#eY
S 
K q.iL c%5譶kaV+ca0 q΀i A6YcKc%5DEʚ5 B}ud=n'm9X"űiUܣ']d96CN(FnUB gCxf5w9dqHJmdC,)ѡu2bYA>@Cc.́IQ yu T7Qo@$a$LCPhJlޱa?G@X#Ρ`RVt.1GU@ *e@
:撉 U~Qz7@
Da
A;$P,4"aAHf$`A+RZ`!(2;),!=*@́)$*Q Qq1\O!fpU a3;`3a!=~@RAH& RR$(A;!4a` *; I`3A $a!  !@Q@`R#[AOag ހ% 3:)
E:!2H$qI!a?@7r
2}p4J|qt  H\        `	 _BM "| ( n s    b#        d d> F ."    f  f  `/zj
/Oo
#(4UfeC0$g
S, ޑX_2; 2$_"w wOo2c~5xR@2}ch_UZ?p?d2&i% *Y !"Y"S?2R"_jWz"%"k? c& %k`&(_Os "i%* "
*U?) !j"_@"R,*-[++`&Z.{`&/_d0)Jb&? &2J2B1O2U0`&sdbQ14`& K2$e6"4468{0q/
"#4 4Q2_8oh9W	y8o Q2;2J-) &S?{9Rq/$1CJq/AD &;B)?C9E`&EH+2A; &:B2C3&eGu &>Hq/Uo$FB2b/A!"TKQ& &;H%D4@1SNJ(`K"%yot2=HK )B<QjN{(SUb/B12@1]H{ ?)Y`1=)KKI4"2/A@"A%TE[")FEBFQbIp$y ?$:IO]@"QF$@11^p0$E"9E`^$<(](X(T(qI&5S9J7dJX!5A#=Lf((HqI+W@RB.=U)mHq-]ks0SWS@1m8Kq/Zgo.d0 ar8DnWoRKOfd0Bo sodWQB"$0${xd9sziEt"+ 1a{D1&ra2&}(s<sz[O&)pJ&dh|8b91ak'}BbB~0(p6$xSqc=8C;FTqn2+B&|Z]$%Uzp<H`9K?g"59Ws<Y@|U+⁗QF_*w{O["s0I!D]]6-3JqQO _F~SpZ⏛]N-dhCє]s9"1wX]qI&)-FI1SnVo`'Y%`b=]d-Q&63cSS&$R]2)_$7)O)(3<1O$k`E-7HN(RAĬ2Üb/4 D22Q&_(I"631=oqI8SAD79(83_9$_SeWB2q|VOq/XBQ1t3C);"
q9""5Q21,Q&QoDq1$+`&m A-H:UtXk"-DEqJHS@"B9a?BrĞ(H")OBSAT 1EI'B_KY HS& 8o-2@")c|%>@"W &j &4@"-aQB8zq!s@ RzT1U !\RBxOhPB V`@%*ۺE"%!AoӍUHOPc i$:U_#	I VG"0% B{tb "E)"0B"O@PcB7" &3 7Π SE`7Q oӾzEƁE :"`$ !p"@6.RF@E4R@QmE8gw Ph%/Oo@	 /f B

 
 f5
n
     Q   	 _BM " ( _ }    .#3  \   G? uf  ! ~^ 	
H 
 0
 "02 
2}#=-# 
-W " " 0

!
K
ݠ P

 @P  
  iD0
0
 `0
A#BT$]P0!
0
Oa&% I%4&'%T&#&%(s)*A#N&*:+0
./ :(-!!//
+A$4D.2345'789	 0p"AB0#_<=>x+2,:tCA02AC 6,?'"A#@('	@_G5C(?/"+6O"c$E)\BOOO?p"p"@!2D* .2S (#S@T AS!S#S!SA$N7 , 2IaTz Wt-Xp%O4YTTXp%NZTJ6.\O@1YV!2AqW ?_`_^\PaZ"abc^2fd.a%@^p!Nfd*+[!!Nfd(+jRA7fd&h N
ZPDSfd$"gqlUNlA1Pg#OpMc"
#Oe"pB$OZEc#fd O(PgB$k4s't0sAOAuK'wwh&ue'xOv@p"qnz'z ,
k@V{NNpl)'z}J. pM@O|}}#.a~pn')k)AO .sZ.d."0
pD'Dtc")pn!.@6`WP,@1|]\TsJ f&AOFOT*OO!zJG -r)ra}!WP@0!c, 'Os(.#俘6"aJrAONr2t'@02!A.ARR"#."r-e@c$AOR Iw#c,A$!OPk(a$@pE,>қa$AO-9p",  v"qRYe,( AOAVeA}r g#A)!!ca"pn ,z1)Ғ9)rx KJA{}p6A1 rÁ#p0Ų !|B Tr{ ,KA$x$'ko m"al @TuH!|.S0$kNqMrSss
rpBPi ATWrne"  #02OrlBg$"Sp$,hS!SNDRTf"p! *rnUa0m67٭4+AJ8tBRdUX^XU ^U1!       	 _BM " ( k }    P  #???   |E L  ʼ  jD 3  ! x	jr
x
F
 
 ߲
> 
̲
E


ސT0aRUݰPr 
 6MCutR
E̐REѱT!RUtP
ur SM@%0#W,p0U>P BPI%ݐ:A( )ϐ(&%1(#/--
 <
ABa
R59-4A-,
r )|6+:8
6Rp8 "<0-<R86x=i> -
#4DC5/A2,c=A-pJ>s<BTDpCa+A9A8/>- $DQa!8!aAr2 D2B
M$DE>

 )AC<%O AC:pO$"P8$O&N6
 )(DBR PS*D>4S,D?2S./D_0S$0VO.ST0NpWT42DN,S44@V*S8D(SZEZ"S:D1&S<D/$g\P"S> Y]TE@@V S0_P BSS`D@Vzb`ACUTNWU4PC4pb30C3Qb`C
CO*pbPbO
TdabAfAfE \
GDAdrbBSpePi%te_}?4/$pb/PbakPk
h/#dcb0C?0CNPemnAj4jajkimhP#d!k`gmBcgneonpCgN
`Utq!oN0Ci3
4recneeeUT)Pd#ddoBrgPiqeB4xwi{bp43aBtzTrfRlg!Q
SNanN
2fu/Pe_rgh+? 
a!gAe@dj)anup{]r4BPCq"$!f"Cq!CEPiACW3Cu10Q4h$Z M4pk4QBjRUR_
 JLP qFpU?яBJP	 MSH hqGUS34\ . ($U_k (
fwxGw@?HqАyJԏL(яJyPM
vfw:mT opO4pOPwoy0oTyaњ.xPG,PSП
ph*П( tzП6Px$tqyPocКSaxoW1  Sҟ
갟ogPiЭopx
oA#SПvp𚁯ihpgfRh2Яy\pvrpyfMnҶ!v u_ПroAP0rھPbrFf]ПPv
ihПa ]JgPПoȘ2ѽК P\aAxrp`Кoi[21p@ZaGiѶP9wPPfҟay6YyУfvRvWipAhpfpfPvVph2ԗd@oXКҟZUPagPԡaT1o$pRpO@*TՖRROi1QCOѭPPOMi@J%NvNJhPͯDeBxH
АgވwL/
Ӕ    (     j[؎c Ћ|Zc+3f  m L!$F10fPfSfQfRfVfWfUCES>^  fB  _  ^   t^  t s $s@P$ ï t
P
@@
 
_apf3u 6T`< t_f3
 _>T`jR
 
 _{ b>__;a 3ب tKPPtPSQȁ u3Y[X	 SQ3ɽ0	  3 w XP
3	2
 P 5P  f@f_f^fZfYf[fXfV 3b>_"b t
	"u&"bfXf^PVW 3W PZ_t
r
>__^P  f&T f. 1ff&T $.ft& )Ot..<xu<\߽޻μ̯۾ݷاЮDD/(|/8-0124/5!7!7AA$$~"!7A:90@?==$^$$$`?$9 =I@s>0p>`-;`>:@ @'@C:'YarRE9 @&9<Ew<	I!!9d;Wp7A";BQCCC=(`K)))**LLH9BL~B<y =J  >""ZFYI#Bdf9N0Q#<2Q` B;I~ =hxPFN'yNQC<P!B2

	F"cXSI8 = F8 0 p81\	

dC3@qV?$$D9SE\CRt;((DDPE B=FJC#F@9
)HsURs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍cInIڍ׌߃OsJ\gpjځBȉymFGł񂪓rݏOڕKvxmȂ튮xrWԍtEÃ_xƂ׎쐬݉}֎~HS\zԕzfmQT{ǃ|sFV͈vd}YiEь십ċNԐUiTivǗ؊qlӔC~t`֖ؑ{pKWoYgȏlϏ[cxb `  0E  00 ` < 	iyԐ 6 @T ?'YV
 P! 1!!#"& p~|ޕ  ?6%p'? ߘ  x@ )`Ef !0Q 0R  R) %Y   `000;9BFLXp0@BD:H0E<&p08 _d`¢08 @a|õ   UP W  >"6>? >!0s>?~!B#""!B'  /!B#b&2 `   Ý4LX>p1@@@!@` Bft,?0<J`0` бx1^Кp|eȃ P&RÃJЦ ϶10 uv 
	00 P $&# 8 o F V| D~D D< V B f<,$$0$l= s ʀ 3`P ?"#!! P @ ` 	 8	  6 a`1ppp~!3p2E ⠙ @\D2"##x;1`®<|1 %rm  2 P R!!@ 1$Q$${yH a{HHK?x d $0̠`@@0!c $2&f# 0;Pxx R`{1xp RP"PE  _v@@`)X0$x|pTT T8_@#61ѥ05 "`$Q $484(d(lD`&1< ?! ?&!<? !!# f4cતę+#?||e10 \@0!,$9`0pe Ⱎ @@4A$B#'_ !}"""@ p0 zP QdIi&0P֫3f4d
 $A@^@B  \#2Bb"6T$-`0 |px3Y@@`Z@0p0E 0P.=|sBm|%o38"5U QHU' &
a! 3?!  !!3#a?2ba7#?1`		
	21"`n!9$i?$	$	::~"33a#W#?(sy8G0N0#@!"*22Hi)?""?"!BB'  <p$P$%)*$ $ 'D,!##y P-A$  \7 ga#1" ÷< ~ < qJ  <$$$= ??d)),?4+fI!ߡ'0 âp6( g~Ѻ}PPq6./@0 -2@0ǭQ V  <^@ <X_=$Y<0b64~
*P[hH\'=  ~  <p D=<$r_ 15'n0'Дeb 7̀ap# f_x3I 
8hТ? 0!p2ÿ2DRDl4""z"#n""Ys0 Ghq`q`a r_vrqC`"<1rd,%}IHTQy`鑑@,Up A
 .:23Vn& @} Ob@b~7x?RI@l 0n2"Rn  `@A-00` >ю?	<ŭ|3tpcD I]KhOH0D 6bOp /$$1 FD @@1#f~(3H2~RHH~HH   9 "} 8F ?8R)C)E+wD:< ~`""6`Q 6q"c  2"&	$  c21$0k"bķGodu6?e prt@UuńpA
2UBF0L ?r?$&""+  0p	{ x 1	#`4 c5TfX}@PpP tA
2(pC 0 ?@@DDDD0!sc!D7 u!P&DL|(0<qrAt@q3=|@ 4	6P0i#!Aj0 `  :?!#3"$$4!?5!#! ! ?@y wsQ7  H@4 }b2C"c?yҍ@ڇ@mAb@`!&=x<)f Xp( (  >!k">`?P{o8l>"%{&?3
7b2  1G#nE  Ғҡ$!E sޖg$?_%h|  1  -A    O   0 "r?&#0 P  P01 c |ƑBrt

@peG=` _BA aK]a lQ>#sЧ'	!?0SP*"2S8!%!  0RR2R2RRpP`?Bb.	쁨4d<p8%%Ar.ofp7
 P%pgL?Da,=%$>G\0A"bM@"0PC;)X|D2D"DvDTDD6_ # az`"]X#a B`  QUY:-Dd=}4e8!	  6 P>@: L D P`Bf$,892k'&a0`MP'xe 1PpxPX	 ­1]Q3"&,0?1dD6d<x 0oAno8|	(9H;)*;*$*%+8TT5Vd<όpV!`B;Ux`ϸ5p3 p=UQ ǁ0 ?rФ {`0!"}z @Mׁ )~0*HP&POK6c$ւ""8x?~!B#* #" +*`"0~-0o-{f8a5P0ē"***" /"$'$&*"$"D?^Re0`V?~$BdB4¡4B
BB~1P`	"&D$(-0_6,!1	()m2mf O.h/X~X_=I H<H$H$I$= ?@@<S>@"@">#"D"l>("8""8>(l6c    O@pġD4R$ze!0US R P	z!X! 	py0 ;6<ЂPpJ2a3"和!!
! 3 ?$$$$5d$Dd< ~  PP_`Y? $D$=
HTrψzP^ 	/$y,(8h(lqD?  /"?(/(/(h?OX  2\E2 3~#^&`$qq)F ''" @#fT4fФph0#	 	(0q0	!?$ Z?			?R?" N2:܀?PPh1h D= D~ =  Qpp< %Q8= @|D< !!"!"="""?;@P{BF\p8@h@A`uCb>HHHd,$|$$$TdTDTÈ#CC:p>?'$!$34, g A>п??$|] }1!ߘ L8i`h2 &2 +f!b62~Z*\*jI?0 O:g; x ;!pq6 H0	  y 	 	  	إ#$'a+2a---pzas8G0 a B F>lxPXHL0F`C po0``f0p0b64~
**hHI $lH UIHUH~HHQHU~{HmAC!A~S8 2`1b)) ?()()~?H!!!aGbc,40'" z#?s"K!7K`
`82p(@fѵ=p= b>{ <$p'Pq" ">+>>b"&"cb@	"00P   ` xo3 
WPa?"#
 1pxLc|  800 S#Q8#c"%9M8<
SPpD  > "~&%,(l)$ 7p?-P̀DQ02!;VR!q@# `b' <AJfXg "?**~*Bxb~B$fafA@BFD0@ @`@ @C""p@C@bBƿ !:?}~B
(L,0"2	3gTF'c)}8@Tl`l$5?b5dP>cqc^2_!x 	(	)	) ( )H	ߖp c 5aVr\A?~"A"2&460baÀ@B(*f+qBmi1g`8nAް0q$ &bBO6  | <  #<7A;3@3s `x  ᄌ2RmӜ8@ 	 `p1 3"f:2 B|t"t@Acp>"u@$	,	(	88(2l"Ff	W11WIaЃyosdA'$ bg3
D(z


 ~~h<p4 7  p }#"4&0PPPh`@   ZWa uU0cuW W	$../S./pZ /  [<u./ b `uVʊ8r
8s8t>8t: t3-v(8r*<rw./` a2S	PO %

@ዱ	p
C
B
RV^Z4
u`R\ts 2ǡ0G
aO svENjW1R	wts211 t<
t<
tD<tY<tw 
P D  V
PP t	| tL^fAt PDPXM@#t	&¹/ u 2 󥪪t.>/u .@$$ q$$ `.ߎ/& u2CQ2P Y*2Ȱ&߃P' a1%%RDr
././PSR' && Z[X ǇOp$p+$@&,-.6/FQ/eF/p1.p,~L1WtO42_H.26U33',QR.6/ʊƳP ZY[X:  &:2#;;OsP2 >sP
X3?<r<P <r /  /.&0,"06fu'h"𿦿/3P#ūB3!9`:/D.>/P2 EXw2)DD$CF!9PQRW.!*"_ZYX. 2.9At./u2FD##ߊDB<u< û<`O< <`O<`O<`O<`O<`O<`O}<  <`O<`O.>/ t A3ػ@ ./G./?/O09V`V././ Wќp U W0.././+U;P*  XdUzq$+]`]Xd  WV>~	 X
> tj6hm_t!j^TZ(_؃&  hEqabjF1c4_cTdGeFd9d>GeFddIGeַgdoGeFdlb1c4_%  = (dl?^Ge@Fdl#Unn|l$Ce5e_lJ1cf]fffc5lN2c&_(_رyc~l]%r% Qdpbf>_`Nj_v$w$|V1}j`v
~UKCe&ecvK&_v/wdXA8d.atՀ|
DZt	dEt2C8~c2HDyĊc1cFd{2SDy""|W2Uqyv0ۇ.2[4ccj2g6ccdiyc!(_ upc% = u	8_  6_t9jU9Ce6g"wme! 0^jQ_$wE!fh  Ld6!С.at,>ܰ}jh_fjhI>n}%j hna1t2>a t=afha㡪}b t+b3Pdkf3f
~fPFPhgwhb3ahp_3FдH`b= t#Bh&`th  &`lOd' V㴠a!&haB~tƀJaF`duޒ~c]~cBJo(!^賁^ґh1]FM0@SpjRh!ḹĲ1_ahak l=I~"oh^BD^Vz+5%h! V0*hj[hсӿСЙ
ͪ$)oRj^_   V$b^F FPL <tPvVpFF~rPы F FoIuF&L,^@ʊF*+҉FVc+;u;uà
c% ;Fu	;V@ÿc2U99bc% 
QÐ*a	
AWV~FF&8uǌ@8t
rƯ*
׈FNDNu! WpbFfj hc0){ f0fPʿc!n &]߃&6_jLfPk|a tjPbaj FP1O
 G$Fg,WVPdpbV=ut_ ]Vq # jaGF|濃 K	u
D
0
2<5|1ch4 h &	1 F OGPR	E1FNuFGp^p7+pO_<4	pb1[+5_ Fd2Nn 1d6>dR6Ic!6Uodf!6bdIsW 6?d%!@6#dj'6$spb2&5_% E9dȱ- u /q 6 6_ d-%0Q&6_6_0"6r`dk-
2&]% +1]1]jRkK-<u03%{(6_6C538(6K6&!6&_1yj6!<)<@<A6= $<<a6!<%<0</t73l l_jD6d!<	2&'@.<E6DE#F<C6$=@,<<H6G-AF<N6"<<gz6šM3ПΡ>1=Пji|M3<<|2N' jS6UvO#F@<U6UVO#F<\6)6OFm@.D5[dMPPRP3y+Cl_4_ &l_'_ jT)Da*l_VZ&o`@`^W1o q_r[W 8bk`
]@f}PUt}kJ4[s_0({ 8;q_o:]	$b11 Y0k̻ XZ^ČF&&g&`&` &.a &`2aʹ bqv`qq_qnrNtqntq*cqZtjL]Q!M$t` xO uI t
` .a yz1 u3an? tzo .a0x|J1 dp_wxKxERy0x.a@Wzz1@{||!}q}"|r^mEO`uQm& 0ݎZZDp_ԪK\Z!qpqP^TqP`r&_^XlQp_jwIAw91p~ȳʪj#д/
bvf&b &b@u-&#&&pbx@BahJG1Mb*_;!@5c*a&+a3v"dAʿ&`ʎfZ	 ah~tj^j[؃	s$2 &ׄ^՞f^^
rѓCmM1uN0x*a CCRHG+a1S5Ji@FJ Jp_P'0AC˺ⱺ*a$ < u@<@+Jд S|̠1]22pʡ"lοma#nZ տ`7j2aAϵzp_褰 gcF^Nr'~#t u^   %{ P p]0Ñed4VVF  jRЪK1F@`   =v3+QOYs0PРcvB5_th h A֙ŋ`RƋ6ǻ'9Fɸɷ _˙j  hhpVs5АjI^p  E~uп+`FoV svƂ F~ r~ttuF0~Pfv
VC,IuuSIı [t
z a ^пz~ fC F@B F~P|v^ KмF pN1FFV~tH }AJcFF׌V` vJc ͉vFW~?Vj
AO` v
^F&? uA^vq?A_|q_͖\VqA^v!va`NNF`lav!v0FAcFFoPjc_s^&/GaFPv4!vFcFj[ P AC_PC_y1ZpZ&ǯ@0泻6Ơ׊F0~2|FtFRWw^
@~м	C _ R݋F4QC	T
~ t;r¢QFTݓQ	z uP WV~͋NO^@м3

^_3"j(Tl 

rs[ ,M	T
(|WVvԋNcU`hڃ~(|?W~C_~@uq"c"}H`BF&%W%S} '  ./ҷ!yu@ Dy.A/24}:qA/,?-P.OF* .}@/A
02$373<8UWVv<~0>F
&GF=>&@Ի0V~ʋv>^>޿FG'Iu`=^&^&8t %!^^O}ے1#À0GFFN" }-AH ~sINFNB  ;uJ?0E3F`0AFC&=JfCfF ~pЋߥs	^K F0 ~@HДQпQP "@%MCVV,NGV~^B&FI?&Ѓa!a!beFeZ24W_%@`4rbe[Ph\v\u>eq]]U6^Ie3_]U6^oe3_]6^beuq]= ؂f0\ J6^?r[Q3_\@6^U#r[4d]6^$r[q]2&_5_% a9r[]6^6\r[رlc]c+1n1]j_R^l3nXo`psp
2&]% XoKpxl2&A\Qo&_1(_jp[snt@uAp;sn`atjuaplct0uQ%D3]l^l_jDpp	W2&'k(uEpU~~(uCpQ~bituHpQ~~1k~(uNpQ__tuSpU?~~@(uUpU~~(u[pf3(^+1`upjgQ^(b wi|t6um_t j^pb y挀&l_'_ ? _ӡŀZȜʜs$z:Xʜ>z)#z9	zƲ|"ݳ`!>pj6hfcj^(_؃ RljFW4_J"">땰g"IfN"o5"?@"#4_,i߀ ,fjbe Ѽj$?5b969{bf]ff_f,VbU`
(w1bK&b/f&_/bl1AO^a$蒍D	ύElJC^GHʋuĊ,&Nѩa,U؋PۇJ1Sߒ"jй"[,U"g¯,"Ii,a!h#nsF4BAZjh/!#prWVv~ &F<t<
brF*;]}7QNI~taF&8tF|T<r߭21@$=VpM^VNu	A(|;Ð Q@a! ~0WPfh#  FfXF;rFf?*Fݠ`Q F*N*ȁ vFhP f~Yv
u+$b^ƟF  PB FOuPQ}p
2@f4b&4b&>>b t?S5b@j%A% mWtQC`@8T = &
cD2	% Pu"c$<!Q
2c%Boc1cPuF= 
 ;rZ
+ɉN3c3
3Љ
 qu*c$<
%cc% 邢u$&	u|4pf20% WP	0 uU4I0 0q
u6#	u*S#Rg

cFO+$b%b&b 'b(b	)b*b+b
,b-b.b
/b0b?1b2bQ`ORlvFf4_ ^ l_ XZMp&πgQ&f~ t3f&4_Ft~u}5'7O)p)t)t) tu?5_t)+0)u+	(\) -u--fh6`hf`@X!5=`P f{c3 !4f`4`FO9|ZujzRP- |ZF  vB F~2|@E1~rF  0:'uF&`Fj[
@;a;jxsY6MV |ZFR_vp7aF@`8b*J*5NzQ<=V#FF 9|F؊f٣F-Rh @IOA`BѼ:
H;<F܊f- 6hDOEQB kF֊f5t@ t؉Fh SIvv`Ѽh 1MM~Sq)su@Pp+MPmuFh=h(  A h _MFފfPϊF්f5jy ETQBb::0F1F2F3F4F5F6F70:8F9FAFBFCFDFEFF~Ƌvƹ1Dڠ؊GFa^ދNB Ps aFNG&F;ua& bPW`=#hIhШ@|!dPj2Pv* L
-i- dC _NVqe _p|b<!2_$0PmFmmZmm6zPm$mj)alx
q`rehdrcvfϋ]e)v% fy0f15g- t*-} t9dh0𫸔ccdhz3dhz&fh{0rc0c#$ehk~#LR̈IFwfPxSgg37{xkQxe#fUiGKEB3j`Y 3|
/P_[FP_PRQ ƈHmm_Rq991Am$$2%p6_cuw2]P]1ujLFPtHj)srrE1ssSs1!dh]0KT|~`WV3_ W^&@RFG| k3ᅚ jbR& F%WB2㖛O Bj2fbYW>_ b `]]6 6? &= ``Yp%_ Ft @@՝B2$b/O


Oca`9u	2 =`6 &O&T`V'S~ t'j F IC t/ u#'jSiet= tf`|.au/aul ߀&l SX6_2tIR?c2cj PRh5bbm_tVr2tC(_e %r4_30ڃ+1&_10% `¢h0Ib_HbƷap c,aqapaAac`\ \\_UaʸU˳Qڡ˿Aّ0%`1ͰͱͲ#΃>u[h h:@Mh0JԚܦԪϢ^0*¢Ե0ԯZ赢0j訢0z蛢0ԊU3ԁt0Ժg0Zz0MԽ0@_6l
 ؕW줢ߢtҡ\tZF&? t5P(u%&|Ru)u&DPƋV@07SFF"	3b^8_fjfh 
# # 	# # } pGA?~A u &&_  Hp%>b^ tfj j 0 s3= H/=
td-
t]-! - ; -   o= M - -  - Nj@  5  &9w&EU 6  VVͽ"h s6G  9~ H;y f>>~ [ 0v&@u? 5^r	;P	vĴ 
F3w~k 
 ?_nX@~}oZ!b vV>  vV@U*䱚F^0p% 
P0K h
h  yN!F
+F@PWF!vvoh	FZNnQ_F@bj 1=FPNQ=*P!S BVW  ސ 3_^ Z%0&qqC1F q?
FZF@. }U!;F|!uF@P]0*1VvGNﰳC.Fat&" /A/0Sǰ::u9F  ! LFPFP G  L̴t5F)FC PF  Az
 L@f%㝴bY (c;*gp f%~vJ>Q0VA/ Lư2@@Ɗ*q uAU  }-Vn]c!>  tpЦur3NF 簚N &8tGb vNًK؉^GF
&Ft^L3GL fҢGtpHI
WJV^% = @ʃ@A3tGK@!TA!wc|B> uc|3qI&X*;tPJmrqUZ* HWf)4FF fF
tP^t"@Kؾ fb
VO`+/B@K?Vu	TL0S_(``MA`!=(EbprVeu. 1l^/>8_!>&d.RP3>>jXZ߸j[ Mt_N M@q;T M l	1mq;nE~Z`o> tOMuI p03+@bq; ~
 ~I~]Zr~ss~T sMpuMru~Ť\ߣZ˱r}#2s}xx}.u>~Z }Pz + s}w~Zrv~&@ss|!t|_~1. u*|w|qxSySyP zcz "{Z}Z@o9Fuo9oFt!6Z6~Z詡1Zz;~Z AV(zO ZZZ·r-» 1vЊs   r ·xЊ;~ tPQN%V!{0(FP;u?E Pr ;߾vu_39> ~@ vZ 1*HF\&7֝BF *;F|~
G;|ǋv A\>  T>򰐅J zJbFf&GW&GQu`F&M*+ȉNb&E"|&}1a7tOQ/VC,FG&:t~P}
AFF JuQp6u4#} D# 9*;}l ~uP̐3&8MtËF Nu\p=@tك*G;J^|`,Dt3696tVoB9> =9F
p7 3Ql^&9 ~m_Q&&Ь^F@AFtIu'9Nu"^*?& o b◛|AG0"Шv
 u#  B iF+F-   `F쾰73Ȁ\D] ]";^X`FP@|3ÊFPÊF 2˳ 72˓ŀ72s41ÝpkFP+ɉFN+ف H&wwfFf GVG؀a U`+ӫbԐ"~38tC8 uШV3a_~^
AF1G^Ї
uШ\"N3~(~p؋ uPۊ F;_| |2f VNVA.v<%tFu DDF
0N$ pF
PN%
 VFa V0:tQB/;v~6^F&uFA	Wq`a+aQ?}  +΋э8sݖ8vva+N&8 uN&= t@\p$fh  Zfhe 	PBQf6 caIQPtQ#8NU +ݐAj MCvя0WVxZ* 3~Bv*&ğ0:f;~Nu  p/_Fˁ  I𰄠,aPZVkpqpE2 ~0
~h3ҋW/Bt4cP]v"b%`P|`+pGW_^	22  9Fu
2 ?D
^ vv1.EBV5r pnFP}+F/- P 9 T!PYF rOqp T!A \F0EPD8pj0߮fh`Fߤ1$tjh0$*9u	fj X!4}O UVb P# E@@hRWF344']j3P8$Hj42pf")ԡRP)Q424+ +WV9f@蘁41$\mPF E+FFFP耑'<
`2Pɍ1$<`2
P68Ib0$DP_Q1$H@{|A<5+F+cрM0<?fa24? C=/?@PE
IAEBa4aC<`E!һM*A Rv9<`2V`bHQJ<MEMJgK@F;綋vp?PIbH1mJFI8J UJKtsDQQP,EНn4f?!QPWV96Es޹&/B4h᲋bDtY;}! <DȰKDPT3!ЉFF~
 qЬߡC`D&Fި@u[]aFt^ F;^]aҡc ed& tpf;v}v@aGF;F{+F-	F@؊F&Ev;v~i ~ ބe;FiFfP<} t~bV'cǋ~cPdtOC@eйG\P
t/*yBeF!9F}\f ;F~Aj?~~/B+F"D ky&L
q{DFF |{W| ``24_> `	PB@PF!. EpcQb.
p|0x!LqFa==* >r&bsv avFOv謠*lcقf~rgr 3u@et
+F"DFHfh %rg tքvr֐szqe9~b^waFy5vj+FQag񀐈Yj@>螠5P&Ok+σ_Q.}+ p ! Ïtj[覡*BqF%sdzQj]h 0v!,Fmѧw⿓/ @fJbp>JbLbj Ww 
Ht8-t-9t- 	t "f vB%	1bF~ tfJbF  F
Pj 1Q ׋v
 @ӆa%ѧj kP`yHPVހF
Pq&w/Pg`/t0|>`Ӑ6/a ~p	VV5SށF
tF
}%E 1~grANV6 tDup 31#`ۋ`_؋󌶁gG B_ cgD ] `*䡝3̵HQa2^9>u	 莰X_P;誱XGcR%RkϠXu(+wHuAuҷ@uAtpj	jfh%cBR͏PwbPf~
 t

ZB#; bDE aU5x7>pRFtp DVVtvv]g |p6n]bű((͠FͰU fu͍F$ETͅj
`RG$YjQ8~д]$1}p``4KQtDul@p@43?FFPIF@m
 b;^;NmNNQPu# !0;= K = ; -`--- lwW
FA  "P >b  iu@y;v1a@;vFPVOW `F~FtG;/~~PmPA - D- ߄*- #-  "e= Pk_'-`5.	G@6-;	F?tU tPPPuu~h9Fu
VVQIVFQ9vu@@A
NptnaNNbF ~9~}b;0V 9vu,< uNLǋv 7 3    @V {!VN;bu鵀@ x!^F;~ma XS~Du6b`2;W|4`N;v}O; mebo6V[q,~ uLFgAL0ߐu9v;|GCvcPc9F| ~p%^&+^& "F F"; hT.Vt ;tto Dǋ3ff4Whg
wrø1c1h72(263WV栱 `7c *a tWN@7@Q8V8Q8^8+a/ǫf8Q8>8rQ8F801 u`1};F~=ocP2PjrջN@uO?04.F=5=S>'>65?n?.Z@0D>&` u)>a tV>~c t^F>^ tfm_軔h1%:vhNI4cJujh1]hZ
j(hahZM=АMZMPL0MZMh^h[P֐P[sPߐP[czP͐P [SM#LZaLM^TayMưTaiOT0aYP[aPIPX^9zPX^)P= X^T0=zT4讐v42͚5^_= Ht.- t'ltF-4tcHt- t4A
/Q#Hjho ċttpbc$d Ue*䊇@)u0zg*HpWv(zPV@et/0&# 8Q8D:Q8D:;D:ntD:R<ؠ8h2] fj j PV)WVhÀtAV3j h.	dqrDΠ aHtHt#vh !fpw x x 耱t^ uP	
tvF(РHtHtHHt${1x"x}4yH}y}z0{q&&G<jhr	G+Pr
aGW>ALbЂ@XQ u^aɉGPv&ƀ h~RrjP16 fPQ3ⅇЉ> F~| " "޻}v@@b	&8 t"<9GP{u 7  >@j~쑌9@uȒf   ^f~ t  |֊Fu	KsJ+~	 L v	1	b^ r	ETAߋ^3&~/t&  v&߀8 ue*C;^|s6AFDiPbP ^ ? tvN~ ("߉v0jց(׃~ ubDFG&9 uԉ~עP7p~aF=/5 X=A 9-
 -" -L2 ;uP< tIf otst[`V-
tLƽ=`J-/C- 	tI- - Pda- tNA
Ij*o P++~D@F	07f0pPwt"@uNj  %qr % u
ױ&,`N3~*Ȏ^}
ފІ&8u	F;| 󡓂6	mP1
 n!ps\ 7
6
_$ *`8fu_b؋tP3,[&GF |F FP
t- f3 f^ f h 7C@j h}lXL[MK
˾ ѐ3L[^F&*Ht&= t	_@ &_(Ҁ   D
4  t^u	 h`O
h Hu__tAÐ7	 &	h 	p
G :00iq17	 	@
@ Dt5{	@׊q߀&	f&_ɢ"bc"b6"  q,[F M0
#MLP7Elj.7F,[^+L`Pl`$_&_`,a`3F`
1aA
4
Pexh_j #)j 8g
P
P0dfsVʽkblW3˿,[˹ L[2l_ t&
~qm 
GPe^<2vZ
\H%aB
@XQQ<0.`j 0E
D<B 2o*HHs	O*[%  PpR
/
~$*BѼ@4@gBxj"ʲ+[2"4V .@*B4"r^H*=	FPw- 9t7-
q= Mt%
- Ktn-Mt`PP%IXpj= N.o,20 ) 8["?&*[H)W((Q)o * (](((Ր,2!0 /p:[ qPu/ֿ h!h Pk3ݬ.Q PձsT1 蛊1=P.... 덐ޑl
gD:)*[_wüpVfhph wPePA@t&
4 
@A >>C??>>C??>>C??>z>xa?z?>r>a?r
@_*[p
 @l
r5,PeГg $#_-+{tP#t#'`Kt
- tu.(@@)+[;->
#00a1l]1ÐG3{Pfp= 	O
Q"PqP⣜  +! Gfb" # q]$ g%[>ԫ  pjP|Ht .0-@3B2 .@EU/#33trh
h ܡPlDu ua 1b;t&+[37!
3:3fk;Ķ
(Q4`s$iiQ񠠌zO'iBj^l B/Gk nen  B\$i`enpMB n?enpB̤s nUen pBs ntn@pBsnܥxpBisnxKsnxn+s	n}x@[t&@@~uqPC nIx`u2P辣p\ dU!i!Ml"X#ZFX%&^&0&	'&T'
&R`n|̩l(l1Ap+ƲnA0-pA .r@֠_0/ &[c.tcA9vA@ AڒumҒtfq_[ 2? 1C<&[G5~a+~1"a
btĜ;f[f4_r<Wfhr  6=qq=KԱ1Gf4_f[&5_"
@át a?  4 4?6 040@4% = $ u
8u8@u5u,tu#ԥu4uԩu1 <QG PlFrhjn߲#vS qVhWV	
[\HtHtHt$Ht-oL+fn!pfr
udOb趁 Sм'@zмr\'`мP}'P|м.6['мb9'0~мߠ<$f+fF}ܐF@F\^F6_FF DHD>== PW  -* -tR!   -! -*t:-* ߐ=L+- V[ p[-YZvp[t}Zxѽ4Ht/Ht:Hq162(0-ҹ .@R1`3} !~?=!oFt)
HVA

ޔhV\wC!  F*HF=~4 f< fFVvfvvFPvF6u63F΃~%v슅V\ :uF~G;F p` ~ t
&P&0P80~ &(8@P(8@! t&HX`ÃHX`@L"Ht)3ã npºu>Q WV&  != cr P3v@Q=.aG[Dttt\69F_h=\qSr
o[.a3Ph@bB,-9t- 	t 
KP=
= Ề fjj G0=3BTu.Աuh  Ɛ>\ tu}1fh  `	WDg
Y-sX@>[ t>h=h>r@bh\9Tq
3\d\& [`QF |%PVq >[ uu>6>`t(q?6[]@b}U @b;s1`! te3/f\3B> u	>[ \@ j2 t :(+3#g["%t'&' ^w6B	
=
HG k$&O'u$ a6u
tLfh蓩.j3)i1㐱#b. $[677`b`\_b\d\n;f\.alP۶`<Ѡ4 l_ w4bA;a;bE<n<@i=:52;v`;Bc<<C[=:2;N @;@Xº<#G%D2;*c;ZPIc<u<΃J=ߊzyx Dt,-
t%-.t,-	 tE-
tYtZ- t/ZC D\[:~ 轍tQ}tR  o"SiTq
"V/at`uR&Pa}/atVwu
s&P𺰁qX.aXSYaZsZ@XSYaZsZ XSY az~Zz@z@ut%@;>}`b`bހr=|hrUs@6tX6P`FHtHtpS'PQ^0
PfZdeu`^FV^tF b&u	1LLMNP"QQ TRS1S訵>uh hj[h襼hRyyj
ղUm@tͮ]}3҉65C@@;`}F6
r݋Fth2{x:}yJBk8<6wpf
W~b @bv3ɉNv~FV
tut9v~O@|܉~*̈fh\l^3
GF&F	?Qu^*ۍF؊F% FnvBĉFVy	NJ;33V~"9tG;|	FCFBF Pы3$uG"4!t%6%2@ćft\ff?fһ{F]5
D̠C`3t\ t&f
!Zf
DŠ ?tPd V`ѷ
8}zd {`̀^3v
v
tF^&ߊF!u	Զԙ\0$iFp cEPBPnG2cr2l6=0=	-tX-  - 9`V = M -at!Qs|-aӭ c0Q= Y.*DTbGrat\t\+11v\P- 2&u\% z  ! 3ߐj4 jhH
蟁麦_o% ý_*p갾OoPa uj{3v
l'GPc؎CB]񵘴Th\c]ft\]$@^
΃&[n
^
 f1ؗn
@Χs@{L
ji\{ tWd݃A}ET
t@fh
h2crcp
>aupf
6  O hEJ4F<tF
h`6̰4@F FC|ߊF|U PG֍VnF@$:Fv
@Ȑ%u(0"Ѝ$
F&N
뽐{q8kx\1@=֡P
x\z\5}HD {,QSDФ!f`̠)D{( UӡQ(̠Մ'(ī1𧯄(	"JPUU'[db1k.	
q
Wfzqӡ9
5Ǌ5Z
1I,	
5dpa,¶$L,B-
P¹
- Kt Qs00` @&}ഽf ®¼.>Nh~Ôêq,2Axz\ןA'' A'' A'' zA''0 A''@ `- 2&y뫝B--('_ (- B-^-dB--w@T1Ā-D1-  3O+-`3434u34 34@jsh*p p:r wl@E%
%n&{21.?(PD$p b&_I{Tf&_fx/l_vѥ8Z8@xWtx ѥ@D@Xl_t&PD!XPFAGhGhFm#GGSIAGG*FAGpGpSI2LUGSIAGGSIt& װD
0E@&_zA!D@t&xfhkalv!ZxFNGF6VF~fhh]V
NW aoV^/tfh'#$h"X1[ݠ[VfzWݸ rV.Wa`V>W*()h'HXnTW6Va$VUaVW-a, Va}ߦhVP#l`t
} &DF`t }&RTsiEcԀ&ʔG@@utOPf߃;>Poorh.hP ~\zZ& *~\Pe1o u$} 1 j h<shqu3  t~@ .` 6&:7  u j 6~\z`tu.&`P&jzrz`z&.{76rzxu8_vF z%qq g Dt,-
t%-.t,-	 tE-
tY- Ht- t/C D t:>~sht}hԆ  !pqPBaVfPzvfhI?
 ܄Pu h R؋F&?:tF&<:uFF
*0N&$P
u2!uu2va@"F ~ uF	 F
  
ѓ< w v8jy^P誡肴P! 
~@4~ tgh@Pvat~ tD驐=b=u5 «Г ^3 FPP  UAF9Fr 񀱝е-
 ؋rv v sd u= wrʐˋ~ P yv}q;z ~ tm`uF@a=  R  F : .ޅ " { 
AĘ>
~dzPt dr=,Qs3^輟@V .tCau^GCquK  KP.[I Nr@~uv0 W 㽦 I 0py(FVaF^ =uF N' ݗ	ÐWV*a$ < upTP@@<@ugXxnPnñ?oVp`rZ hhZqt106lP1 t 0Equ4-6aU>i!!"9!"4d\>E/} >9 "\Dա$B&PyٴgF pucpu.7 ߊF*䐇Ht
,uuv,v jI@l@uf4az;/F~QS߰2rջN@uO߃phVh,ye`WV3jPWR/
Gr@蕀PgAPaD    : MHzKB SIMPLO  MOTOROLA  HP  1.13Adrivelock Computer Setup  <F1=Help> File  System Information  Display ssiSave to floppyDconfigur2 diskette Restore fromH'defaults  IgnBhanges and exoit E s without savingT Securit0Administ or passworsd Pe aPower-Onw'pR`Device $'	d<
eD'$2
%D1LvsmartCaryd_pBIOSv supports Embedded$&
d	e]etac p s Tools Ba|Calib% thq
lectb HDDlf-T opAs Activ@  O!Statud  s$AdvanceLuag1 l5(Dem "Q) of grayfield Boo!b,$
-/Presy keyue F10=(, ES7C=C'l R3 |34Accep3=Yes#7No \!4, A02o-rQ2=M  8e4  UsarrowQ2po highlp=he appropri"menu i1p1<ENTER> begin!!.~;follow!< >`+!: -> PSPACE = Nex@-AFBACKF1vio&VGTABFc,SHIFT+JIK `3F6VJ 4Fc4O( E<r This%cann,bd Awn e1S oc rwhT .Sde 0x0K1 pSeSn@?entSp'CQYrequiVWa Adl!ba<mu!Tmov'T}e@.k/MEU\iRQU? lqUVW2KR$iRmcple! su6ssfuldManu1r  Nt`_d4ProjPtyp0mspye'nteppGCacize (L1/L2))0q ROM R0
sRrfamiddboaIBslse>l nu|0PlVideo'uO Keyt2rpC.verBsD^\v
zd@1Lv2}3~4LvH 0f%kvl_{_lefT@l
zAr=/{aGlownyhip(J(2dq|g~3?Ё삿 7XφOߝ{Xd(daUBSN)J$ 1J2J3LIMEJCJVKKK4XTVJ:D;;/:S;tFWarn : S`>j&`ll0 o2>! ?3I2Zsq+6T2re"a a/@,`leV!_inPvt0w@ab!" A: ŧd waqYt0t  alζϑ@@r`BInv 0}Pi(eAyouTwaZto A 1t?-  i_qI    q! r!1 (Quickqr!2 (arehens@3 (S.M.A.R.T.) Es3ti exCimPq): 3A0(Ɂ! A`>g1.&J0%jjeppp1 y ho@duph" "S:QQ'tTf-QUnkn ilDW<rֽServRea\do  T!4!rib:FX&Wexs1  "b Az.  Ol`lewV`vfy n@%EnOff OdPb8 @8 PE8KWroPz6 Z Y\S_P\vdAd* e6E\@ mZ!A
cp als0&AZSmarCtCx5? g if?2Ily
 K2k1rS1 Aloss +&`YhouQZ!n`!A!_oof aaago `5n 0evZsSɹ&Doissh2ed?/ power-'"D1L^+Blank +P ݄ oP ,`2t?m40 tv) S(AzvPws
 Ac\BP)On?
 s. F!T eAB&7 $ndPy o.stunu.0b\
"nAtУ"aPfraer>Para0yT>%Qs }S@lot MiP>A Fn+F2 W\l!net P,C 0t@bCD-s`f@F b xXHgH3jH4bmt4k pUPv)MQ ? aGbou޵phH u8Bq+78 bot&USE=R.MASTPT&7ct:։PpPca!nP`;rcq:T`5.keep ia#oc>bphysia`sep?:`  !jr. I b#rC1TZ,T0fn be  /un\V ATpQ (%0mev,@PS&0p(ibty. I
frdoTބQq,ESC!.. 4'3kjQ typC"'Q'. 9@]F10ptt`"rmpLd@iH4EzQEngl&+FAr~q~ Oer::~ayP
 (щ0|R) USBvA#FㆂH2Su XVZ`PFirX㣠hi@F:th@ifSi9xQb#h EN@h!Num ,=F SwapC/Ctrl!.s KD.A1}U.SpA`p)@Ad2legac]Cplro?r(In@>?KФ V`3o O NTSCKAL-JB-M?1t.BidD4al EPP ECPTj1size 32 MB 6Y43;  Q3oPn Alwayɟn whi`ACc52шCAghς) PXagj#.0IO )8StomFE 9rD;ծ Ioҁ2߰r3;Tok!R̰L ̳5E0IϸE]5EJJUnique IdPif]cLB e@  tu(u S(C;CbQ^pwNPsVqL/$HP #D ZƏOg/ˁ#bO-o/gBTB \J_ 濯H.` _</gɯځ#=L  MEUK@gɏ#R go#[0[1 : Crfg% ]P}C_leAH2@00	pR 9 {&3@Y @{'*
9 
΍oOyK s8j~cl  Spp'  Phnology Au ]c7LFre@cr5EadapLRGbbPXE RPL Ex#vbPopup Deq(0 10  20304*0506070v.F12*5 15@ 3 ^BS@wouchpaʰPeSP,NonPH<F1=HiOlfe>`iɃin4#ju/&5z3ei@2 ufB8ޠzpeic  -KiguDa_)r*9VP=+wie:?n*v?-X.ŝ7ein.un(0J-k*-:2ignorieDp:;dd:
7n@*wt jnehr8*(7*z8;<Set v=SB*heitsfunk&;Ad'istP^pEennytAB 55"8Pn lt-KBED Gerte]@HG-IDLGQFoNKptC"Fr⠇stt}z2 fr QBIOSFQyGg8p^@W@vorr:2oYJ)12zurckgz)ExPBAkkukR 8r[KuatГ+sgewhlt !aDD-Selbsqs&ativ#80 odA0a1ZP(bCГs$cc0jq`rw@aSpraP*ul!ccAnAI C(jgran Feldsrt-OVe+pGIGesoM_qii|i{nezliebnTQy, 'SfahAE=Am, ESC=Abbh)yWkyykzePe18yyJas}N@2}, yJ.v=Meh}B% Vek8Rv=zMark7fs zbMenCe dpvPfei#ltw`}8du!Fgabewm @Yf*fq_8:`(.|fol2n a*#8v:y-> @r LepX = NchF24<-CR_chritt-0Voa6nwTabulqB6dso H-oll3+/Öge/w= (7W:EscL6(7l "Ni`=rk kan9fat we^QeifFbS0Bvomrޑ+getrpn.Zĩc@ 0Apfs 68fi8tM An kdFT!vWsel@Bomv`.org&Ser'0l@*aqmfDesk0e-2ks@2\muP_ asbz{w."Mobirg`tze.07bSZ(ti8 PY/Od2(bhlgr1* ab chlospe.R-lulzbtyp ^rbZw@ig$PYSӕ@aq[Cl-B*-Gre (L1/L2kapazitOM-R0"s2FamEi  ͂f4p`pv q BummV Grafikẁ$shr-Con AőLП% xתҥ1 2 3_ 	4Ѓ-d/å/O"link {хVo=40!vsi@`Bx(FP!`2 ڟ!a_ @_/gj>ak8r- ::0 stRn bis0nEh xEu.T@-/aW
.
P,le2!b v9 eAiĐSZ&0L+ހk A:nfdlW9ge0A9KvbmSglPX
%03 L  _w-o^(M Cvwirkq"F4*6?=,S@RvCI, daQv(71ie2Ԁ(/*C+!(<o-\d  Tg 1 ( n0_p"42 (UmfadpGȄ2@yfhdauV(Min.): 30ad%d#ca7t .v0%`="484wu<^m Ho 0ep3=u1Sbr0z: 9(:<eAUnbe!VHAsgArvo-EL08>fs@rSPYhafAttribu0IDpmDASuzເi.M.A.R.T.MlmEz .R AjysSVU NeuSTp;s ́
 Deaen7Whp JaATa U=U}+t FalUgebelUR TUV+$x`dminpo\	 DurWM_c9  a@P"$'HoPm'o&W.hOLfSm@qCA&T2/iOj>, sofaP &W wa@}.s Zuu@`%# mq:`e}n@lust.1b sԥ$nO \l"sqvice#as ,#U@  hsCSgamv jw Z$tfa(T-#0$acFn k QuickoLockySup)nd!0  rre1Mb oQCWqoopbiпt 1p~|`1$chutz&m U2m$ӵnfU.p|3rT	I}, lrm<dmehr}|ҺZ `TdѬ4@  Infot-ܜPar@zepDr'aht`ĐNnre "k":mCD-@egu)PAst$i12ߪ3?32`QrFn:AnP퓰$mt$Brive "Q  $~`B| Ӡ΁	s 9-3|s mPbx$unbrhbar. %$IZ,1bew|s aP)RIUSb,`[t,n} b`uukהFi}, Bѐ6C,  "&qzuS`1n֒
Bzwbk&-`0_V%yra|7pp;deQtQantU@'Bfdp/at!A/ Esc-B&W`& P;r]6yWV'&'@nC F1A0kEδ$x:ݯ*^f>ggC $^rQD `"r iA<Mu@BayXfO (asp ( `US!Br-eKrrSu!rZ[ip 1k2kU3k4k5k6k7k8k9kQNum-Fun0Wons-PutOB~1Dn/Strgsւ}t@CA`eEngli`5SAtq fP-Ze
gerBiebssunabhngaZlwGrafik-Contr.IIaL? PrimIaVideo-077 
n~Bidireal Gr/0u)s g ' LMym`O.tzb ei2Kl cg<ss@ EgaparOf(o~)_QLhEta1N/tp8To1R Oo  " _J굢 O'ԫ@()aXAIti`abb1mo+vꆰWku:O2*3  4577ea1: KalibQL9=3M^k ;<A3NLrhpuR1A0}DualE/;!UDI> ?H_MC+DfQF GPUJKT_YO dL/OR(L\>]OVpK_>]ZTra@riff-1Q; gkOa?joe#DqL0Wobi Od];rsU]Omc@v/wU]ZRz{ ;~/gxᏁ'f[r  1 : La.̊ 4% ]a䯉ab 820Entlq x	ϋ83 sSɏ/
!*`i { aW .Ln?z10Prozor-x utom / Legacy-ff<R-adapa>ASBootmPz`A/Expq-A-Popup (.) Wadau/@R_F12 (aZ` PȐ4Compropstn% <F1=Hjlp>  Fѥ@oplysQVisc(ne Gtil qkonEfr"/ʺGpfraMZս r4@gnorndr o`fslu`1Q u2t0ڠrtneWjǰkhed Administowradskoд3 K$P aδAg fo(Pg`/XE %dd
e{և@-iL cyP
кV=Sm`C`-h 0  lsf  BIOS@Y	W[a`r ?2
idflsfa <Sks-l BP좄;zd valgpbSP2HDD-selvКGt@r oDR42? Avanc Spro_g Vl!sP+mon@тnedt t fel"GOӌJo2T/^Tryk p  tas PӐ@t ap=, ESC=AnnulFcGod%d?=JaNej9 , A1=Mг Brug pХ"e  relemeWnup,Qt<ENTER> e!qet.f 0A
༘: -> e! MELLEMRUM = N`!<-TILBAGErQ.\jpTABB3KIFT+u{ 3q= Accelp$Ʌsf'ejl&kd scodQ(en. F(01*)no!@pla@2*krvvek08)i da(0s fly s0ún.c/MEU2ӿ, b^@ uve tbrudG*,+-2'T8vpmfnBȰ92`duc9QctypBhigpAB@tr cache (L1/L2P*Fhuko  ROM-famili%ek`(fͤF i#VoJѮs!Qpr-contro"D.S4-ba sLOAd&ЌLR2?SR/3T/4
LH 
letPFX" OZ/QP91/[NPhj_Yat-taPFej蠭dp(Rat)R7dTg3h0W7d /X7dZ)m\l?^\_ /oasP8d÷ dvar: D0A s0е  alt{ 2hold !0o  dQ/P5b-R5ddQ,r )k1bGesk5  4r9A:䩣(թTs9)f<:A9(֩pUgyldcigRt  `ngivH@ u ,Ёvi(a?? iSK?Pȍ T^S(HurD)3NOmf)Psl@ (> ): 30@R. 1 .6#0% fr $ud@@2U9PdR0ىT:ȥa-: K@)~rU	!(cS2(esrv"MTLsXribut: ID-/;COBS.M.A.R.CT.@`:ya.}YNyڵ Be@1ft nμDeasU Fra0l zk e.ʨ@0:i㫶C5szŸ &1Ф/Z&`{0ٿ d5gs@5rp .<L@vⰘ> hvb/z EtU{őÓmectab~ata. Du bP<u64!@6fl0A>vicehDГnְ V YՌ7a0  QuicskLP44pau0ILsvNm`v`uSNdb1t Ќt8䠘 . HuYm Ġ40I),)di2J.p:ges. KQ1[a灍]l p`frard#Ɇdl k@?nappOCd-rom- 7Gc346esH  1@*U234!IHo`8:eyıuqaphT,Ar3r DAQ bBRUGER- HOVEDADGANGSKODEN,QA. algJC n d,opbe@AQA  ЁT#;)A6at lF[
P GOuFV@uPa ebi!:n. )EG,B5try)/P&d@=E eC52 or 'V' Աpe0r#F10V8(0
h45ӽ0?D HsF#.T0?ѢD k OsrflgKOMultiBay (4_)455a) USB-flop#pyA8cx@8328supe`ܐ1A8zipF`n0edjpFeF  Jj#Sy5O NcTANumE Q-PB\i I Fn/Ctrl$ѳc1El֠(aYi sk)O $egeeInP ^U:uPnPeG1mOeJ PrimqϒyMVideo Out PacraB T=j.Str/0z@$vNhuko Bl0`05d t nr compu-k^Qekz`_md52-{ UqdRpVsty8qu5topPGOZq5by&6ZEth 1p[^ O_P6	\To R{_ c`cb_g`gPEnt8gt? id-nur@\ unIoS.pr/s
txOo>wKalibᐌpOuywnd!@ x?~~!L}B P '`56}z8x ?σK|/o5bω?wύK|oS6ion?o?`ߞHagsϢߧxO@K|?/V5Vi mobuX4Q(MEU)xϴK|/O g7ߺ0 ߾LO#[in 1 : Opla 9.Cp% ]1.ˮ0nempt2Afx5̬_3Genoʻ3̻֘ !*9- O Ω_WƟProcessorl Autom pa;iBbT  Legacy-freeB!QmAL1HurtiArtpopup+sink/(sek.@QGx+`*@P*2a-G0>&b!gge PGp p0 Konfiguqx datamas  <F1=Hjelp>6Jil}in`@jonN7 om s2}LagJxkT-	;He0fra6*/PYB 0diU  +*k$ravsluA"|,s!lsprograC$t Adrator#paQIaOp1VA.PC,UyrsxI>sfunkquJtifFGkℵ"-UT+Gn Sm`C3@Q|+&  BIOS4J/ Ipby @Y O%!H|i&xTilbakelfabF5+Prkty &x !Yvalg!AlALp0آ!3 Vvt* Ak/pI/0,@FQus!/.QvG}eSprkPlg  
8 Dem 

9Pdtel92 vz<u<5M2_Trykk
 1E!!' =A8, ESC=AvbryxDRDOEAVp@LFJaHNei cE, Cer=MpiE  LkYAnepilKne tB<ENTER> hvdu v JAt?. Bruk10OP'R:  -> e +r MELLOMROM = N*)E, <-VTILBAKEWrig^XTABW;oHIFT+\Z]<o= GoP8[`EcZ{Gsfue!QFe unQkG8Pno&p5p pS MRm kjreshvYe1mkdfB.kp`7ba'jflysC V3 ]n!f;aEapzBqvfullf1. vkode 02d6vre du't No`blokk-mxll`typ |hCigR|-ga0vTbuff@(L1/L2pMengxPO-0{iedKeofTC`5r troWuSǄ,kob,nb*	%,o1 _'i 2Ү3/Ү4h2k
n {Ϗވ
ߌZy)`4dix E![("Dph oϤh oI//J__`ooވEk楨Ad v1: DCi|slr tidlZ(ho!lNiHGT! /he-  D, bD5u1CD skldvkPCnn`A:e׿s b0+regȑ76i5ؿUgyldigTESBĀuIƻ^ E5h;TUt@b*,?/ L¼h& igsnosUte?
Y + H^3T*_ 1 (RP)slp v~ (>): 3031hgr .V`0a%8vFvstpUvkuv:g Kautv8@3UkjeSee `oxLest R!pgrlhrib`o: IDW01Rfsj S.M.A.R.T.-VAE . # G
pUNokreft nAv {0JP cUfa@*vؐjv0ligkt Duj p@C5!)R8a1¼O ds s05r %0 pO f!s1 !  #TwgDޘ*yo+,2΀KpƱ:inC@pn. bukuPC*  lm UVl>7vice.qg!R
4lqT&D?->>2=lsXlanKrlpa`{p|us Lot!m 5l=7-1 gir beQKObeskoA :E-"/0ie. Ĺ  rVglAe!DSw&r p`N u0EppKre2UBm6p0Dfrard-r.ParaPllr.KATrdl @;tPk _Knappt1S1> . CD-W 42R SHolT:ReVhvvalgAtC#1C: Nhx'(V'  bxBRUKERR%HOVED-Tl@#Rumu:b+Qq#x;," 2d@UO@bev i~O: 0X@U`GP   uF ש-a +&''t?f,f ȃik,0QMER+o e$ B0׈!Լ=M.vԿ spR !<fl Ӏn vpDŹAEU, GѐPc-AL YZA2I'DALock'RR[ F10%\D)`b3e:7F4U'e	RNor;F4qOUreW MultiBaAynשCpOlnk()ϱVo_p0USBԿs%5xs;s ZipA Aa um `1wtBнFn/Ctrl$\eahEl>R(USA)iP)ekeen`08F
el!sT}s	reQsPq3p/T8;is rrA$!H%{ @id k¸Q+Q0Ëmk2@y>nAg ssDst	yՇq1n_<xr (vprkb Ea Eth`OוAH!3/oR!?xD2sa	ߛsnimBtifip"3B`d_܀4y o( .y Hm$߭ libR߲ABAI0pl aal l-/϶ ϹﺄqoϽo//ksp.ᒯ˞OpoOo Ond  ?ڷڏկ@o mob.  0/Լ ߓQr_G?һ[ Tz!n@: LaI9.% ]gfullg2 6iF%36@ igjen/n8*@&!E  AkProsu=:toU{Ќ %CndCa1j5i23IjFPhinkacc<E (se*I@}aa%F1#2-`c.8}S@epute P}pConfiguracimaI l 5omadora <F1=Ayuda>~ !rchivo.wormEl S'ma0&r`+sGuCF`; tco flexibS!c`;<" RpSa s o@-"%#&'P:o prCfinido'C+Ppad 6  Ign#ambios y s@`11L#< g5#0 #0O4"11eidadse/adpLra #99A
:
9`icio:=f8 tOposig>s@
AIĪcF!> &EX/9\6`;Fqs;IH Sm	C0oq}lK BIOSM>P|5N@incorp .1DETU_BW%"cP #`AfbrE HerramiЪaC8BI er F] ^ CZp>.pj`+`AAutoprueba HDD`!cg`;OagbE) ^*@*e_WAvanz\`/dio/S`4jDem8kn1ampbVco+ gr cO>"KoocAq]_pr,OprimpOquiP tecFOin!Q=j, ESC=CancelxHxy=Acsep{=S3}qN>y1, Cw9ofw=M@	z
  UP1KwM6"chwhaZal  !glemЪo apro[pisel 60bv<INTRO> DOz`;[F.1qn.s !]P+$EOQ p:Esp@o o -> = Prxv7Retro7ces<-@ai:TAB@SumMa/ys+Cmߒ 0@|3y8bSz3Errm]o@g DZE`^S Orpjo u`$ӛ є[>]. Cd C01hay nunh$ubEA80iCA3O+kb	0pI^P`Aaco0]Ti_p
ebook/MEU 8].q1 1.mat ⥟ߡ2p,eZ]ЈpleP~ gxitosae Fab\p eNtil TimP0:Vйc*dClzG =ug_Tamaemkr Eh (LO1/L20iZvisaROM иmil &d`ArZrÆ!NdVriRIl Iv G>Vrp8la wiAFoog1?ђg2?g3?g4<?anij=^ Og
яiz2w/_r5ϫEtiqqu0urs0RetC:Ȉ
(Cxa0 Ѵ3Oo ٿ? ^o@`O'	.
 (f spn!h!U`"FE*Adten:pOdfuirg  ;eQ,斓I). PROre`;)!=/%, inx)scri2éuP,CA:)eU@ Cp0@w!@K)дfteg;^!+vl`,,usa	nI5)m')vapnQrea"C 4@eCo(a) 
qea`фS)p,[j1a? jgn`U'o23 i6lD` ir6EEgT9;
bPSb1 (Rpz`C)?2 (Ct&@3 (S.M.A.R.T.) ClcutiMemejp[(1~Pds): 30
>tPgo .0%V?b ]X?AOPUu Uipal?irum?JL: #pu1#DјaVd eOFale0[rnQOServofR 4!!apoyaaôSatri=bPd: ID@!
Ûa0gx ]!k<5Xs 'B
J.]smsea@tpj]nuevpj@if  ^Dc aApagiEPzn
dQ*S "BѢx`y]B&e0wvoAcI^0`gaP_Pf L#x]ACad1es2weVc}i!inhab0p4/lDm, tQnkp4"8Ai"[ostQoq]s SmartC`, aKsotu,pw  lt "P op'斑0`Q$ci02f 8Pgtprcsinc S⹒qif"PlP1IaR ol+ `d2vvi.o;  ᨠa3P? OoonP!k<aso]qp!  QuickLockSuspe=nA Blo
7ː:rat0Yp4S.u%ppO{`| Kуmej6!<xHy/r. @pSrҒtpyx,!po5duiz/f[Rg y`YreE Pu &vxզ`)rojoզ¡nlPU--RedpalmB!oі#p1IGCD-Ç--EUd2 0Ɛ)P6*hPK:y];UsPio:!`&nu&jw/z  mediwDriveQR䤠PvUSUARIOzPRINCIPAL ~a3U o&P_O@ny}p1 L. An&Kq gy gu`40I lug7#8R3 e ij~EmppP\mw . E lŇ! `o,|X OqȡOnbv/ yoƀ6)gb]Cfiң*cde'iI0`3Oponsp .1p0!3aJ, WA}4 ESC. BaAa alab ~'' MF10[BAxx:kKBiSoqfmIk(Si6~IqGEsp?aol O`lpMu }Ba!a/P < () (r)^V$USB h 2~~p&Su`kUgZippme|p+ TercACP

x
wSp0}o O"vp*NoPp*Dp*l o Num`V' Cqes Fn/BhT#0cIngls (EE.UUBposia ]AmH}ImS$x1ec Db0^UhL R1!cp:peo Mo`O:  Bidia0LTa9mpmemX $QiB&sC fud cub+B& "CA[AVN&b/ook 20dmuegMosIBo," (s p)%&`'Ethet, "o%&*A,*-е/.*-PO0&Tok0IRing-O305/27196:2\:6:3 It`~DExclus bS<A(9o$A@UGgAAMBC0I/DANnqcPSFÍFHo ~y(AIJShJuYEMNI+JP/LHMs"b@BO_WQR YKLp<oX` a[Scd__S !bXbOjo[el^+MMEU jF@sn/o/voqrU0 j_u}wxzr2M[1 :p~rg. 3C% ]2 @0 <zCpleteՇ3@ ݵąۏ쌄<'*u~&  ]SNo?yAha N!$ x``!utom`cҪblLcy LpFe ArranQPpY%\D gb@5Ex@(@
ӥ`0F12
NAmbos TouchP P N8uېa`೎  <F1=Ajuda>`!yr`Infoۇso o iAo"m׀05R꒮ɒȵRvrt @/Zpadrc<㮥 Ign lӳe sair4ꕮss S&_$!.na0np}aV#RE =oaPD =QDRru xΦɤu  v>HhҰrw*إe Stpd 2dBIOSGjGܸca9!$?embutiopx_fb	ְFe0masD
"Ygqi0kleOpUT0@!$HDD Ar o Statu2a@#Mu0 1磤bH AvaSion#R!$camp@	cinzp	lizBHoCoesse qN
ctinu	 =@-SC=Cancel	Ace}imNaɡ, QouR=Mai Q Uiz =sCqqcyd1砊 o iPK? apropuȱc<ENTER> me*`o.LRgu@q r upKR:Ї ->`
PAO; =НxipK{<-qBACKCEJap*.CTABoSHIFT+C!=@BSCEr`' 	@naoжk%2ԁ. Cdig\Bpo 0p4N '#h&@PToЁ ̱
Y) @,`s`i 'CAc A&,gev'nsf2Cro notebook/y%(e0`m@e()*2k%( |m xi@AրelBN44  Ti .V>c 3X@  A Taphcache (L1/L2Dam ROMvis`Famlp`FBGgcxuGsriA&?Ho vdeVerdLro RRnJ01AaoPQoO 1+ ST:UT3OWT	4/Ygl[@iK_]x^ORoSJ^e`azaQc^ir?esQEtiBpeB zpbZKijeeAH&?p"(Ю)_j uk0+/qNr:sNr YuNrZOxNr`Q\ z{_o}~i/jO dehOQT1ITsecundaFG`Advertn: @&&@03 pe̤"-c Qѵ C/F,si
um  gravv0unSAA:$ɹUAw: nfoiЏ P01]p306HM0؛OG`1@'teg Ma8͘vlDbIG͘ 9T6tezҌ
eja 0ӿ?! i#p >Ħ#1 (Rpx qE2 (Ap9ng7v3 (S.M.A.R.T.ra*x0Q`N(0.): 30aw`k
."0%㽒Q}b1sucedr
A>hos9trom1$: I`ssatP
EFa	l!hKJˠermecLp  ƛs3
 trIiJfˠD8!+% 'exa ts ).أٓہig1]ov,d"Mifr4'"atlL ` (/RirrRiggN1cis1Pg ࠭@!ΥNAd I 7pNH.aSmodѧsPtaft tamb1Dݠ 8p\a3e'mCarQd1l,0
 P7Cvi7PpݰAvs8DfbrܠDus psaform. G 8AA6 3ₓJ`ios. IBv,A? ObqP
;\RQuickLock4 Suspenso Blo NFou0 S^X`&auB/ 0}X蠓q=B 	 `N.rp@sCs imp0RuBI. ExigU ' PPϰ%P erme44l0 $BRer'=V1otrI=CD-RHGr21$"#2_$#3%#G4 P4
Amse:ڠusu.?: Voc`@?umd\Q#utinN rive 6 t0USURIO=2  MESTRE =ѭ-j#0@l  Dapaz S. An@V4de-ࡀ AB0iAs0ꑆp\૤K. NvbPƝ1g T+,-;po0!Ipsb-k#f7 BfHAr+.Mf0  Lem?bre-see	vq?a@ ,sab/m0kH0,ssione ESC. PQPϠGіCl+av'f0' 	R<2CSF10.pe XBr:'MR*
cI2'H0
Augus OQ : Multiba!y'7dBek(5pght)NwUSB ނ#R#rmzipcmPrimeirrc2cpQ!SOvNY ނc@@eA2s Fn/Ctrl2bIngls /(E.U V+@
i`Osi1ס,?"Spmh yodeoK%}@}`p+
Aa FMo |P"@iqcYTaz8hmem}~OP~ fuY 0  qu/@oCAEj2geGerpcgRnergEj1*ij$ibjPEEt{net+o ,wʛ3Token Ringoϟ?Idч$ ϰO Ba𶀆߯?StatusV	S\C@\P$ -gemDSdFlQJCqNrRDup ted ٷ??sd/N@߹a`Ahͷ۷0Al0^ ?ȿâ DU_?ڷOGDalޣ[ Et9 1:rreg/.#%c ]0ble2:    .f3: ReD
g*V  d?ܿ|c
 Nme=@)V?mfle/xvecA`ēH|daApz1+uR}rÂPopup~c ExRSeg8Z<F12(=ly}s Var1Fza N2uTietoqkЊp tuk <F1=Ohje>dosqJrjP*elmtt Nyt j~TallentlevykGkee "a$"k +onNo"P X?"tV%#R&V%oPe% n)s'' Ohl muul jp"opLb-w02!"ttW,",?0,pou  2u;rv"isuYn5vojan `:asa sMri ?7 Kynny0
7V8k.: La0[t5e8l=6 tu:usnuat_8A!U-7GBDt lyki7Gti-BIOSWEu+kiVBG-z6%et3su7A6(/Mb?VBs4Mu7Mxie%tehd 8TykaluFLAkPT@o i  KT 9i:PaT Ki +Gvyt]0HxLO& tTWTn N Y*V4A LisKieliPVk^ e_ harsma5rki0;Q<Їa:<=xL>xLJatkain@/`jot~Ph npp =^, ESC=Per 1sjgj=Hyvksy?l=KyllmEi j-, Joku0Ui=]p(ja`|^nu7olicimi o"Vk кh T@/sissb3Qh <ENTER> mrBt%meuQ.: օn wy1xs seuraav쀆t: ->.i VLINPPIN =z.s  <-r|ASKELPAoLAUTR}Ed #inUP6ARKA[}ap&VAIHTO+''T<= dm0_mp}kXUЬvirhAkkua eVoiTda.U%: R@'di 01@hka@0
+VaP\3rtp4 p K`<ytket0akoPtaaxsi@1?RlakBsQ54s4.|kanpt}7olaaj@"us@zikkPYaskeytyi @"enѐi@x`U2"n0H[ɜoPJM^mA5j2(4hiPNQb tyypppUɥn`-#NallA6Vlimui (L/1/L2pMT   ROM-P@0;㩑Cot7eperEm HДsipsar7Ar `YĮN$ts?tohja2Ʈ`K_9usPnkoh1:$\2p3Op=4KahvPLT {)4}NOј?</7oikeDust`J᛫o$(jgoa) wsӻ Ȏo֛_1J*VkrAso`Vs: Tmń3ay"p(YatP\nh . J|ut luo 
prRus-  "n,r 'ir1jrOA/onP<ᘠ7A: LS`h}wu Y3큑;顣H  paAC')H&2koi0hP`qJ+n?X;,C-A ./O2   -0?Vp1 (NЧ2@3 .M.A.R.T.pArviq$ (min): 3y0Vu<s .#0%C`hosApUgIsaysYAiRW*WV32un!t@꓏KE
ServomoottP
LukuUtuA_YkPLttrib/ti2p}P`.@ap/pza ve`Ke xn .!s7 UIuax7V! 06& PBX!bX !G"xc#o o6 @N70A` +VJ@bCa o (-SCor{n`/okk ܰaadan! 8767n$xe"5mysP\  P>4U"35OKC45,hs Г Mai16#T RP335eoRLP\id;! un"1nATH9y0 ve0Tapahtum@-PCid?aa &iLc0)J⣰ʠ[n QuickLock : hluPa`v%d rz1* ;`5R"<QY,x0hra 'd-v/2 $Rta.psCd1咚`]n0t,@V11=c. /g(uuQ( &dTzSp`Infrapun`R`šh0fLangTdcto2Ein`  CD- -l:KDgBV 1k2ʊl3l4RRP10{$joAiot:en+ DecN(n4P) --llY  Yrek KYTTJNC PS~SANAN,pyb\ U]H.ay 9`Vsily0KTtur`0lsǐri`%ǚ t 0(Y5Z6x29-C9	,Ap$rr!yLLAQV1Jq 7xG9^a㐕ztb6 55o-"
pC= e^r]P:``oYA$"#P,qp+ESC-n pY&;n[4p+'vs'QVCs~ en F10ؔ0l)iDaa_Z:o p KU vs /t@u㞠7b=	mi$UVysppMultiBay+Wض (n$R) USBgd gì)!Zip~Ensimm T0 KolNeljP&Vi@GP&K"`&eiqt dek>s YKym GaNump`%PVaiv Fn/CtrlԔmp!N1opEngM (USAUst0(spinl r"Sd`Jddn7 CjaOa Si~a?8nFүsi1ᰠs=V@Golhйbqt Pckios!NRT#~Ԫ[.A~ 1@uu09$R75Qd`2\2-QlQacV`a0Uk1gi@ Kp-Ω- (ylos7ذ@oBEOtherЁtut 0OeY֯be3TTo+  bg?ROaЁwork doP/O,_ilivFQ Ak#kuWTAc1 @	0Ejo.Pwlib& ?dP
jPDual-o 	+¥b _	O_O
' O_O+  '#$+vJ()?"P#+ 0%'/4)*ŁF aaЎkk`O (_.t//8O9e:2 </=F:67@/: O;DE>?/IJFBV[ e:FavT.=R% ] PQd	S2RT@lprX pureqgPVX 'RMS/Y{US3_T! @kᰅP^`%RMSOaDhb|U*@gF Ag"orฐumerIn`  SpeedStep  techuogy AutoaILcgacy Free`u~rRkĀavu vdPys1i Π (w0e`0 pu A@ y:y0F12:ʤui`PAtappi!koske`` mmaK<zy  Ei mn Configurati]ord`teur  <F1=A@> FichwierPjforp{ p`smoAf=fage /ASauvPorderІr disquezla cz~K RQPZr @ r`'unew.؈(e֐als dfau/~Ǐ duIgnoŎmodiߓquSr`e l'inra9=preg
ϙ /ScuPi{-essOdݱ e~ҎPšp~e sousk𯰟HY*on.  priph:a s05вIDْIi'+qsWDrvѵ;ASm CpĢ9~ BIOS ?݂grWe DsfafֻRtabl@amМ`'usp Ou onnqa blerieª sl[ec~n@p
0osВA@oEtaBÃp]XP0 AmcoangP ChoiseIndmps garPqpdrEɪ'պ Appuy1toupoP0ru@w=SVer, ECH/AP=AAl M2Accep|O0=OuiN Q, /N'imqe`e=`lroA  UsPqzs fheamrcle tiucer@pq@brirP1yz1 <ENTREE>C2cCDsuaimFt  1C :c-> ou BARRE ESPACE = PAe-0IEPp?recede>5TABCAҧ:5MAJ+_5@w e!}rr  Il 1ssibOc Ua3s'prsodpendP󼐖. Co'6
01`ucFťn`q1	 emplacei{L'f! Qrep7s"d'accueil dph 5\ it
xbiQ Ke p
p{uO
o
2Sa r]u FacyMP
 Typ&cepVr K'Db)Taca(L1/L2) VoylimoiwVerbROMP%9mB+A.RevPдЋ Numro)F/vid0j-+r<aaclav1"`o@!D6 A609
p"<
3>\4/@\amov1_Bz&6`8ßGHMgaJKEfAb
inv-B
pri 
Sr(te)R:W<Y? ?\?A^_CtD`E& ocOIOfogM#Ni jodQ/nBVJsedqe <p! : CR	'0e0tru-@ie `b`Pb gz /a6, r苍nrorAc w3Aa$`eLvz !tro  Pa'|ρ`c|vzT QO|o}04!v臐a!2.0~ 
:)f 3@yfes-vA0Tlp-  }@ ? I'gno7IiPЛ Enr#egAe?ش T1 (rap)2 (coet)@u 0Ўim(@)v30tc`s .v0% +vr%" Ԉl'h"п0$:è!'c nuγd'ƊvP3mÔL ۗsupSppAƐibQ: ID!$ex@PŒs S.M.A.R.TސAbany .c Ax2`sd`Nai Vf5n?1saȂsAA MarAN  n uYPa!Ae%XʐѴcQ/Ųmme, vıKJad@QP8pobligatr-#%	SdƄ;I Is@ %iӦِxźS@otCzvu   si0	0p샣4 pesrT0EvAampɖa=la p vSqforQ. Nuz4	04  avPou0Ԃq:pAsr Sv4w{,z㗱@"O2Cd #`y -qs4 QuickLo;ck1sus! 3  @+ot51uw#ri`ː3Sq /¡wQreQcҢ);. L'AP5g `dra0 2Exig{u d7Pd"O @ra ll'$ Rssqfil Bo .\EoCD-/E6c;hp"h@h0BJ̀TxpalJ": @2i 0.Dr 1. Sde{z xdeux(UTILISATEUR1PRINCIPAL),  #g5!05
alors  , Nz@ %)1Pu`1q0
sr fye`rceluR .ordin<CuS. AuP %J.A((Фq8) p+!*et9+ (("1r#QP: tPu@	as}p&`ab u$ pق#, aOppuyP   PE ECHAP. "{eJ0
K)ґ=zA'#',O puiP,Kr1LܑLF10TaapPPRrm Ђ O@<UeJC !FranaQO7⋆MultiBayjeh|e/^B_n(labcp) UnAUSB
c"ih:iZ{ip"iPremī D&iRtTps΢mQuaQtCiynpQtSixi g Se0!p H^pNeuvmDoQtMo A num! Perm²Ls Fn/CtrC# \AnglP\ (SA) PphЀoQm^Чs Anc@4echnx0iad q eltrcf@hy}`n rimaHPpdDiИid0ryBid|S> GmmłQmJӂVDlPEj PER`X  ~rQu^2~1fbloc-n"P,Ga1}azRd_1
Oόr_(кur):fccue"0ǗBV EthtPzf$Ϟ$Tok Ring*_ 9`bըߥըFIdDZuT{Te[?^P ϲhU﷼l|h߶onQrepopP,oXAbs`@fAFDu  !_*¿?Y?_^b ȟп̣ m oMڏ/0ygnYe SdDhex DpH_? Y g MOo/O![ape 1 : C.[% 1][mi0
2PDӋ)	(m
3PR {	O*`	   a?OH?NumroAroce85 AutoaCh`h_Blib 5Legacy Amor]cGG3B% ?Retardc$%expGwE) DpwQSQ0F12\T)`posP|fxi aiqOux`tatQ`E!y!cun I`Fzzp|ql2Ft <F1=Ai!>nfoPC0zema#+l0_Й23SalvapIl floppy6V06hdtto6RipPtina dP6(:7:9(:
ifa^
:7 )p?ih:3Ignor<qWdLed esci ED:l'iY0Pz@16\C57Ci&7HEtupicWzza-sskwo(ePEam@zrato! 8`WM%NLЉcc#zN1Z?QQR&Lhs+voRsT8Uo3 IDsNН32YLDriveLoCckR?[LSctC'upQ#o|7O^ BIOSO\^Tg Na7+v iWgd?V>f;`rW0iA1tru!Wi CbE8baaulUmle0dOpjQ.0t=o rigidAtpap8gqSP lhn!N lomto AvUapFtLpu585o $yDimu0l{zQcaP0 m@!op ebF0}gqovva~No~oWagXPremi q@siatas`er@:uF   *=fy, ESC=AnnuvcN[AQt'e_=SiNxqD,xalt "=Ap񎒍"2 UsJchiavT freccnd}i1v !Q u #ap !@:o AP<INVIO> @@``$7G'cse.eeguj  unE: -> o SPAZIO = J0suQss0r  <-PBACKCE )cATABC|o2MAIUSC+!*= $XG9paÈ	ErrPN3|l  Qupvn`puDse`$gSi  v DAvu@}Ap&"<l. CC'T01 N@!u:v)!}@"A@Eoggiao L[s`Al{re蠵ts"|agg	a vJ!eb6  npbookPQespa#RLNlfb&roѦatA@ֱk?_2tlriuDd2>3Produ`9aN&д N  Ti"!QNVeloɅSteppxMisOca~J(L1/L2+&me`(AuR`}ROM FamiCglnX!9dV3` e !Qgq}oprroclltҙer@ +!ܯw1ےv2v3v4<Ovhand3 _Cn?w_w Mdp PP!0Cs00̄ÔeнHG(ņ)(o2$_z3_z4_z _zoO O	k

܄aU3p)onSdam'6F6A so:EqUkgger P|І`Q?x=-reF ĲF/r8:Qs, ina`$faAv1 
9]iLgA:,9UVtA:rvaonoDug!Xf# Iy=tR91Etq N
.vld`):fD,:IrDy.+2SjH?Seeev1oaGGa @A?CG0hBpB3 ir6GPrea?IkF:: ApsTp1 (Raps)?2 (C?ompletr@rtiPo (@P)O: 307>0}c`7o .F0%QA0x?Ʉ?ar'h{`͓CG
:3js2 @P  PT>IyA`s%qJUe)MN`.v U3ON`A2*Ls_@nK rribv i Ggol:0YPRan,Pde vUi S.M.A.OR.T. 1ul.S[ E`v@[nuoa`٢g]bazsvQr_xrxSiEx_#p|bbdqAġo^ Dpp 1)u_;14Ecqh6cAmrSa@ f^gXm,0  Ho0:)fu0|m0_@B2ezza?r)mSmartCa@\:s!r?tqi to (F@PsJB5aoГ\p!merdodp2dati`DEff1S14i|soin  caIe lcvQ"ipau&5~o@٠i>O G"	4<sospickLockspen_Bc^P:pmous '8M ^tnxos[y YP;  pgra +1`)Է|e p  n PM@w.$ ,aQTari  li uPZRH- PpTa.aCinf@9J%хPڨp4#R7wl>P Puls4|gao CD-S)#$?  +p +0䏰 +[`p*:[utaǐ3(Aa/ u0 +D  e1. D i b<6cR'UTENTEP:PRINCIPALE  r`ov!)a pmanzfu p:o. Anᶰ)Vp16_ gP:41Q{)Ca1ѝ2 <eх$fӀd{-Đ&."%lpdCu@Ȥ+pӽ,m(pu0K`.a:Adp sabR0reD}B4'cӽ.B p_!:4^t@ 4nqϱ<0Ghdo.n$A3!{`C,~m7o ESC. jsq'_Zdov7erV ''P:poB`ewF10.`fq4 @Jb״htfdטa\DIt@*0ң:* M 2iBamy (E) 	,i USB`7"Sup`k#Zip>PrimoP2ErzaP2 `PO vb*bDecAo A NumAi'aAl0 Fn/Ctrl T 1Inge (U'SA)``1i0aR8spuo mQ#plPb`To^bFԣborpl foHbaVPMNMo-xST BidCapapF memi
] @)A!is`dSl􆔩E2 uNeRharm>0OenergĠ'16 BaԚF(CalAsp@ 7Ethpet/% 12 3"e Toke?n Ring \% o"k%O$0©O&e+O(e+3 Iz2^Z`tH2 34721O4_78Cbf/6O7<  Dad9nO:o;@  0G>Du_D89CH /=M>G?MAB?Q EFPUJ/KT?ZNB0oZR\]/cWa?bZ[a niggk?` jOocd_nsh_\c{mo#? lvw
yOqz|
y uOolυ/~χ텋[  :Іros .Ñ@% ]0<o!comp0
Ò2АS05'M <&3А`'i/ʜ&*Ն/% _XqKLrio/ϋ
u@~a>Automa~FloppyLWlegacyC AA0d?@+S	0R~(sec.) veeִPF12R` s3jNpuup <F1=Hjlp> rkiv {Sy?infot/
s> S.! pkkigu@/ 8p	stll_ frnol>@C!
@Bn &ardL Annua nd0 ochslu A  n
+ɴ*ZJ͓ Sker@ dptrslЏ  KTa֠rct-ցmEn@ss)2-IDדަْ׏t`dtd fr  BIOS?byggd -Џi>abrikVerktyg Krc v fb2 SPvtpq0BHDD Ak0߿45us fpft V[lj
rPD0ɳ nedt

t0lqه߈#X )RTry@friu g nqu q@stp =A, ESC?=AvbryF/App	aC, Vj=OMer Bv pila: a pyt <RETUR> omvEbttԱd.`e1ljeer)a } : -> e@BLANKSTEG = Nީ  <- F?rege9ntTABf>75KIFT+Xt!= @A ? 4 &sfelt gr" > k5et# hP$aE  % uppstod00dAw$en. oFelk)01^inns gp%p$2Q'pla1 t@ؔm krv``)D2p%Cm@ fly`s t -d5r/ extC.h$͑`tid#ig(?)Y*2m6PKklTkN,e  Pխ, typ>hastigR>@gCaP-P9rlek (L1/L2) M+ B ROM rDfamiljk, 3E=s'nummn
0deAoGAb00DyrTB@f1(H
De 1.LM2$?Nr,3Or,4:Q 
AaAp$L=-?T rMeLVNeL
@v'XtLhg_ZNG
IU, vNt+ ()O1ZDOcP?eSRZSekv9rVar! D-ӭP@  "8 nehpG-skap /-tǐqi17kbp0"5A:!% K9%h	i`sI7s&tS<rrskyddad *apgoNpP oGp wȂɎb11& # GL?#ig̤?!SϟTA1PnabbbIfP@n@8bU09}kad kbj@d ( ): 330Ȋp%p%!0%<p%ld 7sՒP9ppNvr,ƒatڔ*:j%8aBOktBSr!%Úervo-wL%"17@%yttribut: ID +*d gr1S.M.A.R.T.-域 GammNp2ݠifiQnڤtVDj L p%a1"tA Pʤ1v?lika m`ӥU.\  h'aOinE0_R  ǳs =`` funp `\oD(K) oGm   lhttsOPja "s% mPlo. raxglm(3AtjZh`elsepreSsu0iuP hİo*כlQuick2
telge L2J"1mPA H? mjligqgAlpArbPSbyB-0  `/B`*ukoRMihg 'Fb#lixrFqa
rtK.7Aom4i> p!f P xFx1hTrd !tA=napp1OCD-EBDtt!̄{Hrdq{ +p;34y HuvuqRt
: D`mWcyoh\0
d DreҀQ@U#`lANV-"HUVUD!пQryuf1peĠt . H1q,Q-0oild frv3ܴ1 kavu2hQ
` lQ 9, On" @g. -kbe.fsem 1&AA@d4.  ,"-nF n&#1''1 sed
ta, hi a:[1sلQbS`` PKQ:z=MiBay)^8L (Zb \1SBf{$ $_ Zip-KFl Fj1a\a9 tto(N􀷡'Tt)Num 2ҸVx Fn-/CtrlJ E:lskt (USA0 pkd`E$/04dskrm]strobISn1aK2K!`0bbel Ў~B@eo@ne Flkxp䑏8校2BSpwr-PAgg`9smhSAB/<c> e?vl;<, exp0cLBnedB/C EthY?F cEH eHHfJToARH{MJ{M_L`NON3nS_PIU_RaUnik
 @8ntҥXc\>]tus 0^_asa Si|?]9dKalibA@`b/gd kde:fkF8$Dual<OjggeOm qOheipu/l6<u nvew_|reiO{?"vD@Bsy qp}t~Handtag Xe//eiV!Pmo 1
X:eϗO/ Oy#ϥ捻l[e0N : La΀r .# ^% ]0-Pklar
2u{%3ZOV* Fe$ ! t]4[Auto1.5b;brpegac?y Free*a7
!`3sad3aplӀ&drjaZsnabbr (seck.#`2F1 V D͡60BdStyr&PTC03gq[e&n .e@@e  ) WO@T opslaan Configu0o  Vanaf  G`v?T~ndaard5Pܠ s3cשWijzigne#Qrogramma `| WSetup; z)r w 	?RysveilBheersw?achtwo-? Au{ Aaatbg$ ID's+!WVSm C-kOuv@ BIOSo~Abouwde7sa4Fabriek9sݠugz1G{xtAccuC te eglecP ap szelftҁۀۀ-schijfe!Qi1Acï&^ D b^R? wpgn/ GeacqP-alA-alemC@2
Rgrijsgemaa /vel1o"4\!ukPՀQ g=S, ESC=Annu4	p&D@&O'0=e/'a&Ja*Nee +f::i 9, AAƀ=MpGz'Hulppijltj$pruitQ`dP
juip~0nukeuz@2ark<ENTER> ind`0$1z2bepՠvol0`$2  :  -> of SPATIEBALK =7
<-;BACK <C}E<VorigL=TAB"?8c]HIFT+UAp?SK= )@t*{@`,E't
fouDe`3k0n5iwgeDc FpJp`reqtijs6en. AMco01hJ@a%is6CFu we0@WetvoeDre2 ^ 9dbas2$K Pt n notok-pc/Đ `-eiSsSIAN Dwbe 5igd?M_NxO2I%[ָq]
`Kt N5XmOqypP0rocessSnel0SZSdppVMf Om@e (L1/L2Gucapacp-iROM-Revisԁk l HerzienNBYgav3bRS  3mma%Xl5video	kݐVlu8nptrop<oU  P%u-o1oxI2y3o{4| op`d~fp*v-o
3τn reOvIn@istogpI>tificPj3e?WB(0q7dz^) ׅyOdP{d |ϕdP~dOh*vpψwSBSecupi.BLVo'p: (tdKt aps engew2 PP&$befǧ 4 dQ A:|9g-  / Ձ31]G$eK^offIG$aUܲ!QedlAHA0Qogt%߮/


eVu3A`@2ґzwilt?	a5-?PNH
ZTQ1 (ze)2 (Um10)0j BYRrY^ (.): 3002Phєg.D0%7tooΆ"pb"U  hoϢb#ro1؁:mKbme҃]nbA8cJCۄbJC ov{o-leeseJ KRrP0]`U1ok:<P]bijte S.M.A.R.T.-IafY1.ud<XRieuw_XtASЌBloP50 A0&, #ķ0QKPS!M@sk1
NbV pБPFls X V؁Vɖg\`36is !pbPjB%sS@"up `-akeltC, pXqe j2 Q KC  SS3tC-I!:>,  d 33aceks<*ugze( tg` erlo2OZVrP"5 bЊAS^f"hou
dHi%ZPL  0(Ė! "дe D- g# ᱑  	TsA4m2F"BIS?pp7P/g!Q,2r%0Lbr׷. `3	ses;k>@traak0Q!pTn119b@S%pp%0Ypa\0fraro{od6 Part6p
D1dloo@etw KnO: Cd-!r%X=Na'VDy@P{@|@P~HoofdbG 3- UAvia;0LUiP1Izow@ HOOFD-GEBRUIKERScam@  ?permanA2 S pL  2wa*GH] SW fypskabpirgpfpcomp Rg_MnSKs 1!pLܱ 3t ?O3Ab>PmˀrYSS5?s. Ae)HI#,C0an$
lijkѵTI(sȵ, uAESC-s. O@w
!Q,fkͦI R$'I'pty`lkq;F10plPTrq 7eD Cܢ0:Icf]ckNel 1 MultiBay@ځlf~ (as)3bЂ USB-Gc<O 0p- EBĠ#we|a!~VQV\aZesPZPANP tus Num y%Fn/Ctr9lCmsse}#|`enOMx3@sapp08 O+qlu 蒳beWrmtl00nߖvBijVPWo-10 !k8&)do'lp7*v1g,uId2Pntiذ $u2p:ҠzTPN$X e~20 Gːie,pQҔ (bข)?Z㯪ahEt@:AOhBOhCOd TBR !==Rh:ȀAǺ23 Upk000tcp@ccuՌ7 1 SâaGekaCliСoK B@ꠓ=ual~ǯ 3ou~ǀ3/ׯ=āB A?_3 Hg@pvormUoƼLer-MUE-ǯ83/  R3/  [qp 1 : IBnoV10.% ]A|Of}tooD2nt 53S5t 
*$  zOwFMod z<@!gacyoafr:adapXiёp1rz}(0csec.)p~`Jpop-upr%s"6+ s`F12 iP)pbb  cursorb[ura'Ea/syPor-$G G^  Rs[^̃ZbgA#viSETUPj <F1=wv> t@C"VXeG&Ɋւ&\܂"t#s@#fB&Nɕۑ  ݒC(o)*(*畜|-,Ă+/&-f%H`%g+  H?o׎#2ye&+ɖ%-5ύXɏI  B7,7AA7ȌwԂ@-܃@#5e *:7l6ܴ07+eg<.o:;#L?3Ǘ҃p&@#hB̃3d?BD4'D *o &X 	AG@\L/53-e&IDG&IDJ h5 &u/N BMCJ#9A@-͍폜$-Sm}C߽ܰ`S BIO}SS ߰@ƜSFDzH^W  G^WED39?#Ҡ"c@#1&o#e̒  I=]D^&-nB*aH%e&g Iv`&`abMAJ&-] &A#Y^9(; ڍC["\?((R߂&aj^u2"@bӃ@#bObntB]!DmesD-u@#jbNrJGrUIIML[0 =^AEsc= A"@dysozy3Q/|0=͂}qς  }7A#x{zC%z"J@#\ xgp0j!#ڂ0c &OgyR[Eq]xgP-0ȉA̠"sT->Q&y@#PHo[ = ED  <-Q[Back?Space]9<;[Tab!Ao[Shift]+9ϒh!^A7mF[}~E  ^G[  ӂ#]`łͫ@-'`rf;= 01  4\Vy 1qlɂACO!F`3ڑ(KWv 1Mb A?O x(_ marON QMEUh"?ȂlϜ22󋽵e'ɫ&!/ɰ   ۾ txfï  ށiL1/L2$ROM?rWb̧r AU޼݇رٔԍ  ޵渷۰ׂ޽"ޯ ް	t  ޯQؠ23}4 m
l	3'Eɥ? дŰc(ÂC)v'ͥ34/MƗկ ڂe&^@J"_gߌxw:➈qƁAg/S ,u"> (ׂĎ퀠T*//pύ쐬wvOA:7݋ Jg/23*}	yo/  誔F'ⵣe֎~  rOJ)`335  E6Bz -H*#> 236K?X;/ O=g<G?";o/cHd|@b1iN &N$b2iS3`$.M.A.R.T$ \zsԁij: 30@gd .60%  OK z1b fb熎~"f":*d)m9QXeT@#{ǂ(O ZT|ar0֠sFIDp
.b4! F .$@j̉BV%F×J PJPbcA oCB7qr <@_C,-'.v"f߼!$7%CuVb?CJr@jSd yZ7棧X}21hiP 8:[\E8d CD!!*7Y)QLinCbq:P.!E f @Ƃ`l6A1BdIv: Af?+yb(#?SfTNhRuBS	TA@h#RGO\x{#1}EvS=XkeT8OO( %5(2ی삪#,A%P= D蕴` T81@yxL?ċNW87Ovq oV@>A  ԊOsth+Ghu)ȯܰ)%lݏ CD-Rr $nj5	t1p2jp3p4`R} ^<:`RUuQi0Ip8eS@ q_Q H vWu`[+@IDRP.AT`Idq FcSbq	q`R{iGld$ѠC~͎冐ǐĺR@s0^痣DS#ˊb  2I !IO}D@IҦ~Ez&	ud}7@3 1J_W_PE9PzpEϐGক؊ԓ |ł৒͗WL;`9y(Zyংql`BӔC4aBzybe[Esc]AWb `ȍ~x#x"My[B艺DriveLock @It<B/p[F10DC41J1p  E%qvQ-_u[qiSdi}`%nf: mb;u!V BDx˿zQb >O xPXiaa)aaUSBHZ	XPpg Zipvk1Ԗ U2345U678910#Num1c@ Fn/CtrlR̐ؑ GW`V{  p (USA)S|FBfCXǌKAVyDԳ	v jC gP % Q}`Rr	Io5i C'W Mo ECYgc 5Oa\ڑ͏7̧04#82 5gȓdca1Oď뉺$Etherne*  q_trts=gPN   Q3 	lB(NKKo Ćj I+D b Fv.  D	g /p
 F/
Of >2h  { *V?N_ ?W_!#$&!nUAh!N,?-.!VMEU2/o45 /7M83D:C_86=8??;Pkcbv1 : [d .sF A% ]aOE5XG2E!F	EpIoFJHv3EF	EiOKoLP6N*T&N T @_V19OBjq۽T iopIntel c SpeedStep technology  mWAtp:Pkޢx  h_@ڰu4nް Ӱ So`hR hEx(b) в@F12gԁi!bW  ^`pbiBpnopr ?s_tuvwxy{ ?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$& ?'_()*+,-/ ?0_1234568 ?9_:;<=>?A ?B_CDEFGHJ ?K_LMNOPQS ?T_UVWXYZ\ ?]_^_`abce?f_gg ` a b c d e f gh, =  ~    n     	 
      
  m          ޣ    x    $         ) * Է  - . R / 0 F  $ %   & ' `    j[g Nsg! sg( sg @j[lj[j["j[(j[/j[H5j[t;j[Aj[Gj[Mj_[$Tj[hkUlsPl0lg<BB<g>|gبg0`8l gv x|vF||gp0pg|  |g0j = ~  |=`{$$$<   DDD 0gOgaƄe  i  o䔕 u  y gngA  ﵏ Eg  IgO m  U+ gYgNpg ~ `' ^    gy z ~{ [ ] } \ @ ~ 2 V21!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>gs( ) +1)#'?
({[)|+}]-[{]}'@ (#:|4^()\|+-y~ z# {{ |[ }| ~ \ ^ @ ?] } `1&12"3'4(5-67	_8
90)aA$qQ'mM(%) +*,wW2,?3;.4:/5!բ@ z {zV"+*'(N$z|  c+a'()+'*/O1`3OoCğ2
\u()| o-cR' -=
^~+]}@`)  ';+(:*[{s\_}\|      gnj[τPgj[ `Tj[QπӨ
` Wj[>ЦъArڔՉ
h + 9g:g;{h C|h?g@gAgBgCg8 1 c _j[Pߒ\^vaj[cWj[CP߼Jbj[1]TgQgRgSgUTgUgVgW  WgXgZhhgO 6 _j[	BP*Pߑ:P&`Wj[P~\u#  ]h^gU_h`gagb(j[ZWj[ƐS[  iru}( 
tWkgPlmn 4 g 0dg  3 _	j[蕴Tq@F10 Setup Image_SETUP  grmm 5S 1:nU:RP6!t
t

uo
#
B:g U4gggU̐l0gU0g g0gتggggܪgghggop 0p4 0쪴z3 Trc Ug	z#'# gh
" 
" c" |+:,2 )U	5 2 	t)G33/5O6o789:)2")Rg|hJhs"I0 1  m#0 1 2  7
	89:;<=>?@A-H
j[52壿  !&j3Bin+0j1/*</0g$2PTgӋ PTng ` oۦZ 7 	u43  w2J\gNdrP@pߤPxpp*ppPxgzg{g3  }gg׃ׄ׆~׀Jׇׁ%}\< H =Xlblhl|lllll= 0oF0o^0o0o0o0o0o0o0o=$q4qNqZqpqqqjqְqq@opt<ptVpt\ptpptptptpt֚ptpt o0w0w,0wN0w\0wt0w0wxxxx=0z00z<0zB0zf0z0z0z0z0z q|B|d||||ܾ|=@~`~~~ΰ~O=0m<0UJ0Z0j0z0U0000000	W=">PUh
=U:pdpxppUpppp}p=.UNrav=2pRprppppp
pRprppppp
wLf=*TaHVpU𑾴=Up.pRp~pUppppMp 6UXtUUMw6U^~M
l40Uf0000M0 r0>0UJ0`000500$opUbpnp|ppUppppUppppS
@&4UBN`pՖT X5԰wpUZppppMp0X0Ud0n0x00U0000500pU(p.p6p<pUDpJpPpXpU`pfplppUpppppppTw(28U<DJ^Uhvz~U1lʰ水*Ffxj@>Vzj̰" rȰ𦰾o0n0j000  {j覰!@0`0~0Ô0ö00F0"w0!LpU^pppŀpŒpťpŶp!ppp#@o*.2RTX\`dhlpɈɊ4ʎtʒȖȬȲȼ̨qllҰް䚰$ TrО%~bҊҠҶڰ& BNh|ԞԴް'>d֌֦֔j(@z0>0J0R0d0l0ل0ٔ0ٲ*001)z0UJ0j0|0ܦ0մ0ܺ00.*T mpvpޖppS+ rjߢߚ!ذ, {0lj0004- Jpppapppp.T@DVdUp䌰䢰䲰5԰ / rpUHp\pppp5pp
0~pUXprpppUppppS1 !/hG! 2~ptppppp3@0aUd0000M04q0>0!j0000005ToXv6TqTtUM7ppUpp$pBpU`pppp8>0 p0 j0 0 0 09*eM
:@Bv";Top^pvpp飢pppp<p0pFp\prpppppp=@0^0000> r\rް? 0\0|0R0000M0@tjUUUATp2p:pJpU`pppp%pֱ|pKB,4aT幘ҰİCT {0j000M0D`5ΰE  5  Fo!Ղ!!!:GԀ0#0#0#*H 0$0$0$&I@m0%0%0%JTo0&h0&0&0&50&0&K'n''''''a
L*2*F*fD*%p*˚t,ȯͺ*̰*T*lڰ***M*M p3<p3U`p3tp3p3p35p3p3N@5U`5j555°555OT 7:7V7~7U7777SP0:Z0:f0:Uz0:0:0:0:M0:Q'p<"p<w0p<Lp<bp<p<p<p<p<p<R p?>p?Zp?hp?np?p?p?p?S'ADAnAAAئA T@zpC0pCdpCpCpCpC)Uz0Ed0Ex0E!30E!0E0EZ0E0E VCGU$G:GPGbGU~GGGG5GGW 0KUB0Kf0K0K0K0K0K0KXT'pM0pMDpM`pMU~pMpMpMpMYO;G;3,ONOrJOOOOOZzVNV!4lVVVVjV4XV[CXU(YHYVYfYzYYYʚYY\ \<J\N\^\an\U\İ\ְ\^M^]w_&_*_._2_<_X_|__Z__$^bHb|babb_ djd|d԰deҰdd`TfFfrfffffaUaˣ0i(0iB0iUN0i\0iv0i0iU0i0i0l0l0l0l0l"bT~mfmmm5̰mmc poUPpojpopopoMpod 0qR0q%r0q0q嬞0qղ0q0q0qeT_0t.0t<0tJ0tUV0t^0td0tl0tUt0tz0t0t0tU0t0t0t0t0t0t0tfpyDpy\pydpynpymxpypy%pypyZpypygǹ&0B0^0v000000
hp6pZjpppi jjuj"k kj luj(m ^j2n rj oOUDVhxEaǡ_Mp@F"%X,|4//J͞ζa qd0.0P0b00j000ryp`pjpppppps_FXְ&t@`R:UZz5 u@pUp p@pVpUxpppp5ppvpUFpRpXpzpUppppSwm`𤥨C(x @00Ĳ00EyÕ4>P^rJ%H°ڰ谨zTp6pNpfpU~ppppMp*{anU5| a0X000O 0oPQRa500}m0Uf0000V00~T@`@dUҴⰺ 0Z 0<0b0p0000000 _:j*|_%!aռְTt\ĂĤĭÔ(pZpƌpƲppp p6pFpbpȄpȖp̚pp,@cd*n|ʊʩUʮʰܰʑok!Vp pDptpϜp̚pp"jptpњpppp]0Z0~0Ӧ000O*>ZvԜ*ԢauufGwR,١DJUXj|ْٔ%z-aΤi}Lq02  ɰ^U|ᚰἰM@:VUv㖰㶰ܰSpPpxp5pp NpT0l000S yp\pp5pp( Մ T j0>0\0x0쥠00)01쒀0F0jJ000+0o-G0JÓp$p.pUNpZpbpzp՚ppp TtN5U0Xnը̰T@`Tn5 UN\vղְTb,@NUrMtpJpUdptppp5pp
VUZh5ڰ?UTxSH0
h0
0
e0
0
d2F`zҚ Ht֚?lj, Ivpbpppua/OoSaаHXhjyLd̰Q]FdUtMbp!Hp!Urp!p!p!t"5p!p! N#UZ#n###U####U]###S?p'bp'p'5'p'j0)Ղ0)0)0):p*vp*p*ejp*p*p* N,t,,ΰ,&, @0."0.)U>0.N0.j0.|0.U0.0.0.0.1._141L1~111@:3j33̚330t05T0505050505 a6`66fr6666 up9hp9tp9p9p9p9p9p9p9p9֪p9p9p9p9p9p9$?=F=N=^====ܰ==L=pA"pAe0pAe}LpA!~T*pA|pApApAeMpAtEBEUdEEḚEMEVGLGhGG!İGG( IIIIJjJJJ@c0L0L0L0L@cpMtpMpMަpM _N6NXNxNNN4ONd0Q,0QB0QV0Q!%Ul0Qx0Q0Q0Q0Qe0Q/
O&VFVLJVVV^VfVUZZZZ5ְZZ
@`p\UVp\hp\p\p\5p\p\ p^U>p^bp^tp^p^ըp^p^p^T`<`P`x`U``ְ``S!b:bXbUzbbbbb @ope0peHpelpepepepepe¨ jg:g@gjT1hggggS@pjdpjpjլpjpjpj
T30lT0l0l0lM0l@+mJmTa[jm~mmUm°mܰmmMmpDpUVpxppp5pp@+0sUX0s0s0s0sS(ȀYtptt5ttɀy0vX0v0v0v fpwxpwpw!dP/G!dpwpw5pwpw T}UJ}\}}}5}} F\Pt4,BX~̰ꦰPhπ!2>T^fpx|"^bj԰谊рyz4e+찌ҀU>d5 Q(.Lb|q`.@nʚ(jⰖ@+Nަ@@pVpzRpp7pp5pp&؀0R9^0a:p00J!;00;000040=0 y0U20J0h000qݬ0Ē00eqB00"^bަ
`Bdΰ򦰨@TLx1p堰̰T p^pppMp( 5߀Y0z000T3ppppp5pp  F0UZ0~000500 E0.0F0aRR\*0v000e0TVtoWX+CY4𻪡NdnxؚD^ܚ갿@TB^pΰ@T0T0h0Ā0Ĩ000ܚ00Ȱ@\jp~ƄƨƼؚ A<Tnɀɤɰɶڰ@TpDplp̖p̾pp 0N0j0Ίj0Τ00@>*tϔϦ!US@^p0p>pULpdpvpҎpUpҸpppSp<pRpUjpՈpժְS @^p6pPpUhp׀pטpװp5pp^jيٜƯxyzGơʚ T<HdT!ƴްS
.JUdx㐰㠰UְS& RnUM0T0Uj0z000U0000000 T@^T|우t(^
I@^000%V0Un0000S
^`򕔰jذ>LZhv~j@
dڦ Tp@p`pppp$@+0d0~0Tq7000S ADTMb@ ȰjܰAp(p8pPpnppppTp-ppp2%BpB E$aZTj0f000  M(pPpxpppp MD@>0|10MRpppMVpppWM^ppp_"Mbpp}p&MfpppMU,p`ppp}pMpULpR^pRppRpRpR4HhvD%TV	CT/X2pTp^pnp~paZpppppp
M0!T!!!ܰ!M>0#h0#0#0#0#0#MD$Z$$$$$$
M.&V&h&&&j&&&0)T0)h0)0)0)0)0)Ԛ0)0)+P+v+++К++ -&-Z---J-1./x///MU01F010101M01*22̰22 2@p4*p4@p4Tp4lp4~p4p4p4p4p4p4@p7@p7bp7p7p7p7p7p9p9p9p9 *:B:f:::ذ:M<p<xp<
p<p<p<)oۏ0|)a! BUTBBBҰBMB 'pDXpDUpDpDpDpD_M:0Fb0F!F|0FF0F0FMpHpHLpHtpHpHpHpHpHpH0KB0Kh0K0K0K0KԚ0K0K@pMpM$pM,pM0pM4pMBpMfpMpMȚpMpM<pPZJpPpPpPaZpPS. #0R0R0RM0R!N@pSUVpSpSpSpSS" %pUnpUpUpUpUpUjpUpUpU# NX8XFXTXbXB uXXXΰX$ 5p[jp[p[p[ %M6\v\\Қ\\2&[0^j0^0^0^'Rp_^p_lp_p_դp_p_p_"(@FaPa!`apaxaaaaaaaaaaa) )0f0f$0fH0fp0f0f0fR0f0f-0f^d0f0fe*@9Rk"kVkkզk̰kk(+Tmrmmm5mm, oU:oTonooMΰo-pqpq5pqpq<.Ir5rr&/s5sذs0t5t°t1<utuuu2TvBvdvvvvva=v3@FpyLpyzpypy!aMpyjpypypy40|o˸>|GUV0|t0|~0|0|0|0|0|bj0|0|5@0D0Z00j000"6@#0d0n00j0007 '0:0T0h0000008 Y`j°䚰&9!8JX:\pPplp|ppppܦp;!Vbذ< ;Zjʰ.=5j000>!0F0\0h0z0000Ȫ0000?p8p\p~ppppp@ NFpڰA YpXpxpjpppB\0p0000a/>O?o@Aa0CpRpxppppp"DpppTpapppSE@9p2pRtUfppppjHpp F+p(pBpjppppppG`rj 1HMUNptppp.Ib000
JNpLRp^qpp5pp"KDUL@pi$p2pLpZphpzppppjpppM<d"N@I0~0j000O@Iz&P0v0%`U0p0°000hbQT@060D0J0MR0ŘbX0U^0f0n0t0U|0Ŗ0Ŭ0Ŷ0000RL N0ܲ0L0ʒZ0it0ʥL0eLpi14q00S@U.T|ώլTT0H0b0|0ҵ00ҐhUԀ10Ԍ00V@%0ՠ00(W@0ְ00<X400
Y@I5Zզ[T '0P0f0ڌ0ک0!00&0
\ 5tܡz!ܖܪܺްe|/}K~S]Om$FL@dlr~ᖪ"^ ;d焪_ YHdt骪`NF^|윰fP켪ذ0Ea:u I*2URb~ծܰb 'R IFv=UFLv°"cTpnppp5pp&d0Ղ000
epdUparp~ppppppppf@94Df|g Y`ah@9 oY  !/A!UF j      i@	@	ab	~				Ftj@2PbrHаk@#N\lxj=lo7|]=*2Lh)m0j01pl500n ;lSjo 'pTppp*ppppSpp2p@pUNpbpnpzpUppppնppp"qT %0!l0!0!0!50!0!ro"U6"f"""M"sB$F$f$r$$$$ư$$$@=$
t-(de=(t0) (((0(8(@(H(`(x((((((f(A@p-@h(iuGj$/%kpi0/alQT/q0///M/va3@3U^3|3335ܰ33w\5\555xT[07v070707S y@Tp8p8p8S z p9tp9p9Mp9{а::5Ȱ::<|@n;U;;;;S }p=6p=Tp=tp=p=p=zp=p=o=zp=~@0@R@e|\qAZ~Q~tBoǀ@@@@@alHRplXq@@@M@NINIUvIIIIS@!KjKvKUKKKKMK@M>MUVMzMMM5MM 0PUd0Pj0Pz0P0PM0P 	Q:QUFQLQ\QjQUQQQQMQ 
TBTU`TpTTTզTTTT pW\pWpWpW5pWpW 0YUN0Yv0Y0Y0YM0Y$ Z|ZZZ!IZjZZZ p]Fp]Zp]fp]rp]p]p]p]p] _B_Z_r___̚__y0bj0bbưbbb=cZ4djccc eQGQIU$eHe^eeUeeΰeeQ l!JblvlUlll4n@poanFporJpopopopoMpo3q:qUVqqqq5qq@80tUH0td0tt0t0tU0t0t0t0t0t0t0t0t@wjwjwwwpy|pypypy =zZzlz~zzz°zަz|N|j|||Jp~$p~6p~Fp~UXp~pp~p~p~Up~p~p~p~*!Lp~q~*0Ub0000S
$V5䰄  0Up0000@hxҚ 	qW=p,p4pU<pBpJpRpUXp`php)UppppppppT ְFNT*mbz%Iͪβ1갏=p&0N0fpv0֚ Zxަ$V|ʰ pdppjppp&0p0000 fjܰ J0\00e000?u_
L=00#@R0%H0B|4/E0*p0001000T8R|՘T 
dxT@86\hUS 0*0D0U\0x000500@8U>HN~UưذS
 
0@0Z0Ut0000000 TTn5@ʰUFRp5谻 
UjUʰְ5ⰽ"U&:LUZrUа$pLplp~pĔpĨpĺpppp@0:0Z0z
0ǐ0Ǣ0ǡofgPha00S$0R0p0Պ0β00Jì.Nan)᭨aM=RUfvҌҤT pHp^prpUpնpppMp
4U:@FLURZ`ׄը(@*paTppp15ppWpUtp݀pݖpp5pp
@pߕFp߄pq1 @80>NTbn~UUS@8f嬰M6 1@Ě0j000 pjpvppꔪppppVp',>URbhnUtzUUM b0<0Z0f0r0-.~J000/0*e00q1M0@8:UTz5
0UR0v000500W0Uv0000S( Mܰ bՎT@7p np p p Mp =LUpiaAp<pPpdpxTpaؚppp%pqApoCȏE80
Z*0
`0
n0
0
1?$PnPj[/Oj[      %k      [a! Vb   QxLGB=   0{+&!	!$08/14/03 Copyright 20`by Hewlett-Packardmpany p
!`t`{p
Tp
  'p~}P >"q"'DTutp
0
p
tp
tVatp
p
"p
#tDt=tp
@t0`#~ 1TD#>0ȥtv@D@wt(trD	Tp
'T?DDD T0
%!tq
tp
tp
Du1ү%D"!"#$$"#!P%d%%Ô
@$$p#"2` $ Ѓ0&e'u uаS(2Txu. B/+>$4 `Op" ({ *{*!
"  "2/)z|m}~ }䓣𣮂~)D`s )Cpb`t   +,-.0
..-$-2,,+$+8 Ѐ)t" ~}|}R 5"{ z}7!:tu0:=tq;q<} |<t=9>$9% B'%($('&"!B&cC&PDB&%ӔP&`ӔP%/3d߀@D$d	p?C7%u( %B&u*I)**)p)N`.(('$'82C;i~@<%&$ 5|DqP!B!
D @%((sOaWlz"RR"EP P!B0DTA"1UqTt~ 33U']pPLI"EV=!B#"U.YU#߭""E!21\?j"U
T	"uPu4"%$B42tʎ"0"
pHLp"0"_d    55ta)t`0
5"+ d+/ÞP.%Rd@B Sp`ad`%߀͹adm^{ +u.I-s`..8-N`Ipb,g {
ad,g}hBie,`Ced`"s`7tp
80d" stuvx/yOzo{|} 	9 ;&i 01/09P3
07/28/04 kC?rystal	.00"x#T*T0	ϣT@t/{3"~@xDx_v$ÔdPx>0P2'"2"`'~?"x x *} ;uu u	`J22@)aT$3TD ȃ@VF @~`T?0	T2`T%`@2dłŃ瀾x!T.xT?T/TDx!TDfxD@p`p
0d/dp^01d11$0ÿ10 H@ޠ KB
T`
0 T%%0TO~.aOT"¯|()ŝ) K()(@f`	JKrdxtTa "23C>ٲ T0_33$2P2 P	dxt0$7d4@k@к K07?xD + 'I³P2
2~14"x 0p"0}2` b"ÔP;Q"xD¯./u7ү 6N./"xt}
~豨xWvvuur0DJ_uu!vү0``Tk}𑛐``
$`$pɀ@ڀp xп~c
[xx txDESxxxx`D@O3}Io}vha|?c}d`&xKFJJ*x%tx}D 
 ǐ`0xtxtyuu !.}_O}uf#t]}mO+*-LQѴxdD0ȗ2 пx^D$pTxcD%xfoTP_@p# ) ,AaLYU1+*0߀Ps	ڐȎT@ӈ" x	0.7Ȑ}Џ)b`\ ` ¯u@ !3s#~l01 6\
1-¯)u)$4CU_QLࡿ)}+o)(햚Q@_}*x)( !#!@G(0%[vp"x)(*_0.}+,
-Ӱ@"x^}5}8=" }}:5'x%~x=0Td~`} 	D#R00x)xb`xc p~K0S(;ٿTB(x0)L09LP4B.1(0F{(`xR	(
xx 5!AC	
_(>ԤTBKPF< y(P>A
 0Tdp(	!?(P(
=}% !T"3 Ô2@Y0¯xЯx8x00`3)03 T߀}`	pYl"c_@#h^^%5M4๐ȉᛴx,pxtxx,P0{!x*b-t+bZ.С`YbC^b ݚ`}<TT?)T0Qp<0w)T`A*d`
u)?T'd`dpUp'D-Tr)T?Ӕ @
,T?M<T?`d`}*}W)pKP.,@p6y)Q-- 6/@3~1~W)'ѡ33T'?O)`8 4   )!94 )$`$pXo~," ," Ed0;`bux@_>N>0B? @T? @?0BЂЃ2>x^p` 	2@^;LAK!?*Q?Lx-?+_MLNx*MMx+H1LaeK`
LWM>?Q?J?J0}M\gMfM0M@KA~P
>FQxZ?YQ?RNSmRa@~`JQ`ǏRA>FS0?^Q?T!SMT1W?<;eSATTTUU?cQ?V!SVT~.EVBX\AOJUATViYS2A}4 A}:_2 !, uuҌВ}"`aDCa5Aax'`pqf#5d`!5F78f5`'`2`=`HpQxWwjf6uuuu`"Ģluu0muuludˏO$bƨpN`0T`
0CC0O  !A!Q!| }(xWp"(E(p
@vxp(Ц ()(x)(0U(!{)))((xY))"o*+fT0B 7/t
A!t&0%pd `.ge..>tb;uҌ( u響,-mp,l`
,-3wd@t 5u/1NPԅ+*,-"uPu4+p" Ebx]j	bxtcߍ#x70;x8q7t<P"#$%&c:bda"xe&%P$x," -DtF)AG;qs=1v8z:Bp#$W@23{;"xy> !u
C9./0H*5,7jU?4c~;V~Pno|ZQ}_%]	`
e(i[&b'g>d\af|X6h+l  >}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RХZ  a  " ! * 2 1  ` I J Q Y  ? ) >g d  F  pq kli/ur}z'tw l k i h Ju s r p v t z q { y m Zc v v       
  	 x   ~  _  2Y}PJ @|Pгӳ !ww ~~   @".x4BaD`aDx2tx1tI#p%Eb0% %xivv T%_xi6e=PIxk"# $ $ !2x1 	ү  ¯߀0 ܯ#! K@3"0! Mx3=
Ēb
"xjF`@r D"pv~p"" %	x30#L0$<T`"p"xkjfp?
0!#3tJ.4}wxkq$3z 
 Hp_ʓ̐`m$I$'ykNv0@xgv"xw0	D0x$FӔ@Txwyv!D"0R԰48?xexvڵDpT0
QPðP|0r"xmAxn1xu"xmxvxnxxxu~"xpƾxo0q byoxpf`Ӏ`OxpP嬑qbvqpp".0&u)p9)@&a(@&"*f`@"x*ft %u*%o-@{-0*t7U-,-b,R--o++|,U-`RU,`  +u%*$U,00u,,u,0,*+P, 0  d0`PÔ@"0  	0
0 	@	"0 @U@H@@U`@@$U@@<@@T@"   R`(1  ?1ÔP2p0/0`0T%110 }0//A1Ӕ@t -tQ>.nY!=.¯P x.xgo`x[T`*Txf0gv"/*r37TOp0 0@0 
0 ^`]"`0/^aP!+00"7P` ""56q2 "2T1u$406S20 |09}> ~ } | 1+ ONMLVs:_^]\7>Tp7 6`7507505}1$Y2"150#1dn`1o #n0u1o!# u1n 6R3 7x%23Ӕ@
3_ԏ33p22
0
1#95@0
*1$`$`$p*&\Q,*'g55A,$c*$M*e.%/&0'01%e"476  7"4xg@@3xh4d|p%06#/7+{zy6$9p5v3v@30/4?_`)06#%51356:6
P86 - 
8A&; [$6
a>@38V<8688C16@>5679567`A/9t%77566 99b23rPF60r0+06&_<y?964@36	8 8976 K<~76r@I `4 
 o
 *A0`4
 63KLMhHI?74o`130"320u0-06(G8
@J9K=YQBAhR>N65Z\+];OWxoX:p260 ?r3+`*jP666QSfDIbEffbHIge4pve=[fBAg66b20 \0G6CʳEba262V+nbL>IbU3on\3o0n^?o=bQ76Ehfp79UwX#tOpm;	FRonndsnm#tws$t?3xfpJ	`F0}D~
)
) 1)3 3@"xfy}[{@"xz>MNOpxD Fe1``}HX@0
T"`(J" ##?pC{z}y[1zxyOd]P0@0
0 (YP~`0`010$`+$`W$`6$`$`&[$pYATp݀QAzRF>0Txv)!p؀Dx9ؠ00`沆``_P01 ߥ`@ 	DbPCA*89`{" PhTG`xd o R.3I~x~v
xD}E*0{^`
}_T?Dt}W_fi~4ti4mgpEA@`TﰞCl34a3$``$p"t1e4`tg4BH ǃb"A0ƾ0+0)1Td`x0dp# xF TTÔP
.xFt°fͭ׮[xBB2tͭ׮xNN2mͭ^׮xJ_J0r78_9t/qC:(x үR7%$ƽt:t:821(0 (:$⠾x`vT"` R9x"`үs 78 0(87wP p0 xvs#ď3xV53}+0̏4  %4',g4 ͫr""55?@P3p`, Ӡ ϐrc@cЎd`
*~'R-T0PO#-Cՠ,Cb<C@40120``/`@$pNՅ2o1Հ:I&IHE)?P~A [xP03oppG*`6u>p1 '?P"@TP~ +E?T@;үd`pxH @"i55@dq;"-.?Qڑm0`0j-x00 <m@
*0
DDTؠ0a	 0>Ԁ`_Y a}Dt
u/ /t߀l@@_-  r.ldpe`0-DxFu@0u rxPu000u0QY//}Cܣt`../0..}00 $0/	J!ϧ- }p
#.͂
ˠqY"^p @2IR)x0):E)4R⊿`+,02&).7pha)
0kO1 25 
x(0	(`!*((p@L@0v@|	!`@0`T``1_`8pϰd0p3DCD?ܣ%50op;Cc"2J.AT6%p0: ")p	S05B0D) >%%O0/Ҽvd-N-H/G"1r)-	|P.P*46P4p0B&S,8?-`Y 	3-c	FU,`		,._7|D.8TA-*. P3pu.
pGu.O.T)3*JЀ
O*+%KKӣ@+ 90&@Ⱛ0awT0 +	a`>APҼ050upo)?=*+pFR}}~0
pQ/+y*t%)ƿ!$Sp$S;"쎿uWP*1p5BŐ}`BT!p0=/&|$`$<*T0O_U45UpY2xO`Ti)ii[`i00̅54.pI/fDgSC88%mMo2̨WjW	0̀lUrr!jbs!lA$`{0Vk}
1s9'vȈ'kaBtd5swP7s6$$?P3c_x2|rVk}Fr)lWlz8-x5m8m}{` X0"pR"pLxwpGPp?'1b'#2't'TU``|Tx{}Bxz Hxy Fxx Gxw Cxv =xuxextx[xs xr ~xqxxpxЫx| Bx{ Hxz Fxy Gxxxw =xvxexuk{xt xs ~xrxxqxxp/"xdv0`iPTx`pIү9" -8d0-Tx` `bi``ipI -)^XC**W**!4c Z7C"ߏ)u,/n.-T*/.d^ $ XW2kO'c4)%,(֐;)d-AO*q+p·pGQ)䨤Dm++R
0;-pP X-y0hP5$p8?QY}EH)Dtm|E4N  $0 X6 $xpAPy
׮ "u*Pߒ09"RQ }/)PaI X~"=#) R 1)G+0R½$=+pMsQ0Do@`TPp$`Lů;D S)0)u+B+!12 K pp$u+T~aI6/#+"5%TwOd r в	p ``` =ӑ>nc$0>z	Ӕ@6   x?0@ @ x:"%P7?PQ?xv_
 (Ǉ
 % 0NP`> ;PQײ"0z*^AopT+-"L]Meq¿30.RT``P0}u}S?@533oTBDЗD xdw3"?t|`}#xVgxFЎP0PsP@TSmR
j-RM~Hqq3"x)"O[Ql Q0!OQ1#!743t"]V`
O0 )J'' 'BPDbV` !wP`	AVF"HߋI.B1TY*I{PEH05)nA^rpAPSAP}aYpo0:VQ5
 75
0q] $f:aeV1p$,
;
 e@s	D0s	 7"	1Oѵ@"BCC^paV!Cdp;Y2tǣt2rJºCF{D0`DCxgvBC@k"xF?xG@xEAxFt@0( @T.`x@@0xAFt"("r @CJ`"0"AA"xB!CqAB4 9!B
""'#N!OqMNT?%9!N+'(#UJ!KqIJ_**9!J+'(#DEFGT^`N JCT&`3S0ouE`HE@7
GFt#Y8 DBED}_}f}t}mEAMI !~++GxMp<Ô@"NxDTR|NEۀ ?D<$0k* ??⽽p}@1TPp}DOEpEjE^EHE<E&EEDDDDDDDDD  E|FB"<Yp\Gai1pt"x\@/IBJJ0JGM"G`iD1NIM <!6OMID 9GGMI`MT`MP:qPDpP$`RFFX`$FuOӔ@fVOpaiO1O0	xgZÀӛp}!MO`#`5?`2$pCHG`ix!HpiDQMC` `Vx[OOT?xfIMLV7f_PYQh
xc GÔ@π<@iTxcGPhӔ@Dh`aixBhRhNaTO\t{pcxhQQ[v+xfv2 <pt`4}t rt0}>{ t	"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTAT=R> ?H&@VBуIR$QJ!0O`Od`[YuORCHHHHHHIII2I>IQI\IkIzIIFI:TDD$D JRpH_HT Ɲ!$UPĈA '@GdpG' &TGJJS
BSx>SHB[ha\@C0PZcO^D=Ěd
`#@`n@(`@<`pdP`@d`oO ǀ20:RD~ttdaRxtx\xXx\t x]txat"xbt2*xJxFxBxtx(tb}0DxxtxtxxtxPx #x> x=tP0x@t@0xTВŤ$"x3tԩƪxqVx!TToTD	ڭxTTx=Tx"``T=DЧ"Dӭxdv0}=t 1GWCWHWFWB}E?c"x0xN"xa@P"rS?/?@>"ޑ$tr>!$-"TpcÔ
P~0~7%OO_NN7%NN{ z yN=@Ld Lk+Ls3L{4L6L7L8L9L:L;L< w L`>NRK=PQpI0A91~5KWN&8S;SuNuNK0ůN"$`($`*`-`X/A^p4`
Ta>BVp=ASCRGRFRHRBPN$`$`!`0`?$apA_:3P2B0  :c. 卂,P3`G`[]Np_"Nב dpF_ $S `aDAST+7ۀ}. N07@O"K}$pL`PPKd`ПKxaK PKK?L9a@P
;Poxav@#@NՐNՑNՒNՓNNOO#O>OYOaOrOzOOOOOOOOOPPPP2PFPWP\PaPfPqP  P0q
v"xz>MNO`uL 8LLx@g}[dtxybt")L1
L'?4!pPo`"} XK}Uv`Ai"uM SMMTp_TM0CMu?0/ 0@x[TavjpdxTxdD0x~> x0x`@J`}K}I	*
 й"3<LxN| } ~ M4/AfoK`RLL  RP((sQ
QRR*R5R@RFRQQ/Q7QGQOQQQRZRnRyRRCpÔ_`PP"T?} 0xtp"K&MKAi`Jj0 V	>Po50 TPk?JuK"  Pcr@i0a>3 ,`PM"H$pa?x0Kp."xydP J"{z}y[yzML5daMucw!#"c~1`0M}?0p!p"!q p% :p(KFнT0P4ffdfampHS#l0#`>0xD  1TQhx@b_!A,,wxv`n魔flTfA,l12>3`lx0.u0/}+  $0.T`600//@"Sl0  " 6`6,g7:"09   6:}`6",.S-c9,Ô`,pC-S--S0:6-0"
Mxpo0 "@Ťox`A⭎/012*@t?0t /x}2x?D,? 0/2R1U2B|9դ[xxDxDK J K@ӭ3xWo`YW`M
WUU/UnUU$PVWW8WXW_Wl3x
,-Dx
tN,P
-,px
S`Tx
1SQ F{TRx
1S #N3QU0"t "T $Qxl	}JUBxkYxkßP2T#0 R%Z$JrUY$ÞPxk=NMp^QU`.`
)*u+S4e-7ү`M$`&0p<T7H7}_tdpJe_Fx+*)3Y^QU$xxl l@v FpYAxkvykxlsP] [   FZ\0{ 	b[3
QT xov 3^x^`rLi
nQUfnPQ`i Fxx
xBUQx	03W)`74P$WU@sV03bs@W WWWWWXAX	X
  Y`Tq$DDaC{D@0Pa<"?xD'Pi$P``qrн=@}TO((  +D" >1}T 2}}6~`/#@W *`@!fa_`OJt`н!mr_33TOzA D `ӌP  4"RΑ`p}TУ`- ,*))K9XS)S)x_vS))"()?,0,ZS Zx	`א}NMZu- u.DSS0S0u/ u1/U-0U.Np.%.-3-111P-2xp7x	1.-Q^P_ѕ22􀠙^,Nxa s@ Д\`3-ӗ`w--Ӕ@ nЫ0q`ҐZZZZ[[P[k[[[[[[[\$\%\+&\4+\@,\M-  \Rs,ps\Raxu,x@jsӫ!R*+RP
+* UyI
xҬ砡Rt?e+pt e* 
 F	cFѫF߆`rx Ѭ}}S{txҐ0ܐ-x't`[,^ѫ_vpqлo}U qtquuqvq$}ϵ}3̰r' A݀QX0:_ѬA>;ą)("`N^`A\\\\\\\\	\]]]]]']4];]X]]3]  ] r] rssssq
tt)%UUs	s
spʖB_*ϰeTepʣ(KQqT0BK
/$:D%0{\Pi$'#' B%&T'Q1~ iBuZQ`!qk0T[Gt('D4s䣢ڰBuc[xBUq`M`PCD !
Q ÅP'D  %+x"nqD13~"0'
  `""0. H" 0[`2o%$l`0Te1p<B30 ֣3d	`3

3 xgv"Ô
@"2}2D	1F.(1$`$`$Ap9^"_ u#	"`
la;󠜄
Dxg1@Tf"
g"xaJTB0J?p__" `0"$``#`$`%$p#F0 ꠺x
=#"x%tz%aCx<Fd' G"^ ^}te0	
}Q`Ax00Dx!ToT`p1K@K -TAL
! |1F!D`,!TM%5ў!
Q"  :	;
Z
123B=>C	D

~x`!ÔP^`_c"
%p=@MF`7PC0x( (c2xQC!bwˏ((`C0.+xT 3 L} 2 J. D0T_`
6 ، 3p
p00	3 bQS0cx($```9`B$ bxv z#!q DxTҎxStTT"Ha!(xS(<x)3)$``$p#(xSwx@!(A!	xD03QS0aP"*+*@*ӔwPQ,@
+;Pb=*$&~$cp!0.-C+(}W+֗/Sڏ+*d'+_C++++NcR,N2@2-@o-~ `J`N`R$dpT+ +Qs"+16d6dp0Q60ӀÒ.k+9+p0"*+i" ""xi@!"߀&<	1}i`$3mp`1}@,/@xdde8e>eGePeYeYe{e{eeeeŕeeef	ffffff͢gfgfgggggg̪gghhhRhRhhhhhĹhĺhԽhԾhhhhiii?i?i?i?ifif  i~)i0>`iC/MMT3/MC/00u6$5\ 0` ~PR/pOwՀMu/AN_}/RR=R,}RO5\c+4TT_UERJpTTWRTT)YRTT\SN P  ?:PO"`zOPLQ/OPӝ 03ME_~ R`| }e@^_іMCTBT?^RTRO_hR3a6c bӔ r dfb bÔdAmM| `z {eo@\?]L`ba?-.bfWj!r .pT_.-VT)jRTT/vRTTOxRTTozRTT|3Sm@#poV_ߎ-stS"!t{dz VT~RTIpACTɶTRT˶ToRTζTӎ`,$/0TP/ P5PP/9PO0q`!pTTQÔ@πu/0,/y`  & SP@+Q;qS:;~%`j`j$j!`T}Q`$;`!¯!xlաJܢKܣLxiA!<<xlP< q--0#70"p"; 0_"$P;OПUKLM<xl@-"678x>T9!35TJܷd@l09p5ip}ep& 5pҝ| $ >6/78P0 {dp!T`"9"}m~'ø}¸noC |qk`> @2/} }` ç`&TTm Mt
۫ܮ~`A( 'pЏ((1 p~'b2dDm@@sE@&h~+pr]~|D}o] 
1/n:l+la"/1Pɀm	s:мM }p
T?T`1"1"pAu0<.M.`~0Q~^ QBT0ЫOTOѺP../p3pO21*İX aPMpA.ߞ`1r1ǶPC15o~`1Co~P@PB1OPp053s,`&PP@0ۀm`p1"x_0@T_O"\`.4b 2oB00_0e.`.!ù6wMe.foB.oм M/@n/0}s  ~$w P	ADo)2@T3`Ð2"202` `2. p(u.r/u.@Mp}^0Q}]bUӝ d/Xu.8r B/.bllr'b6x"bb۴u0;ѷo@X0p.~sPFT1TT%%ҴHp0`t_0
P	.d`._/ӟ@	APO"bwp#5x^tpejEhrEU\Uu^tx^ՉOt}5}{z~y~qfs*2s*01L&trе4pލ(u)O&g'E~ @оe`-tB~@_"r`"2"¯02Q!`
)t`1	ÔP7o_үٰ11n`2o|0Q|\```23~@dz+'z1411dyt((st^tttuu?u`uuvmvwYwwxIxxxy yAybywr#{	j;7<mP6`>1TFfEF"Ju2`u3 { z y2K;+M2T`p[d`fzIJfEKDfERJl0;fE
FYle3p2l`&"0C.+JfEKM4WK4,9Reop455544D45s^
^`/aObncdTrVfE WImYZ@9\#UedLpjVfEK4T(vfE?wTV`ppNVfE_o|?{:}PVfEx?(@?fERfERfE<fE=JfE>/fEQ?TJw}MVfEq _t`SX6D!}09q08lTisD  4ct`DE
1?"04eE}1QIpǚ uy,u1(#!1$`=`l {î$|1u1!uxSoC4ı{`dE@ tu/( !)(]3aTT Np\ `, @M򯊫Ô@ oCѱ?u1{tpuҋ4|?1͢4as}
}`01s721*/n z3Y/GaH|d)ȖP.,ץ1|vA1{0W}"!$}_.3A8ܰoV%<p}ԣ X}tɠ90p0@0fӏpӕ/~/.Ð2cP$3/tP"sѐ}18
 9"""pqt~P
#0cQ pD"LION x1x2`TTxDxDp"p0À"x0 0p\A2	 x"0~	~ o`Ӏ2~10hbh opn`dx"@"P-- np3x&03%T~TOp&p"x!To`	xDpT}p"dp;"	F	>	2x#pd ײX"2LҀƀi3ꀚڀʀ3䓣Ń?
"ۤ0$ P##EN``#s"P"]"$


"  )"/33@" 
3@p"@"( p8

߇	
	4t)ς:!?	%

"*p7@		"g$q`""""BBE"`;Q 31p`!"""Ѓ?Ђ`%Q%tsߨ%&'sŃŃA(("% 	5$pp
s%h`ߑp - -~Q -v -n$U -b -Vb-UJe0 1~ 1F4ppO~4{pΖ6#.s _;<=>?@ B?C_DEFGHI K?L_MNOPQR T?U_VWXYZ[ ]?^__`abcd f?g_hijklm o?p_qrstuv x?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_ ! #?$_%&'()* ,?-_./0123 5?6_789:;< >??_@ABCDE G?H_IJKLMN P?Q_RSTUVW Y?Z_[\]^_` b?c_defghi k?l_mnopqr t?u_vwxyz{ }?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_ ?_  ?_	
 
?_ ?_ ? _!"#$%& (?)_*+,-./ 1?2_345678 :?;_<=>?@A C?D_EFGHIJ L?M_NOPQRS U?V_WXYZ[\ ^?__`abcde g?h_ijklmn p?q_rstuvw y?z_{|}~ ?_߈ ?_ߑ ?_ߚ ?_ߣ ?_߬ ?_ߵ ?_߾ ?_ğſ ?_͟ο ?_֟׿ ?_ߟ ?_ ?_ ?_  ?_ 	?
_
 ?_ ?_ !" $?%_&'()*+ -?._/01234 6?7_89:;<= ??@_ABCDEF H?I_JKLMNO Q?R_STUVWX Z?[_\]^_`a c?d_efghij l?m_nopqrs u?v_wxyz{| ~?_߄ ?_ߍ ?_ߖ ?_ߟ ?_ߨ ?_߱ ?_ߺ ?_ ?_ɟʿ ?_ҟӿ ?_۟ܿ ?_ ?_ ?_ ?_  ?_	
 ?_ ?_  ?!_"#$%&' )?*_+,-./0 2?3_456789 ;?<_=>?@AB D?E_FGHIJK M?N_OPQRST V?W_XYZ[\] _?`_abcdef h?i_jklmno q?r_stuvwx z?{_|}~߀ ?_߉ ?_ߒ ?_ߛ ?_ߤ ?_߭ ?_߶ ?_߿ ?_şƿ ?_ΟϿ ?_ןؿ ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_ !"# %?&_'()*+, .?/_012345 7?8_9:;<=> @?A_BCDEFG I?J_KLMNOP R?S_TUVWXY [?\_]^_`ab d?e_fghijk m?n_opqrst v?w_xyz{|} ?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ !?"_#$%&'( *?+_,-./01 3?4_56789: <?=_>?@ABC E?F_GHIJKL N?O_PQRSTU W?X_YZ[\]^ `?a_bcdefg i?j_klmnop r?s_tuvwxy {?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$ &?'_()*+,- /?0_123456 8?9_:;<=>? A?B_CDEFGH J?K_LMNOPQ S?T_UVWXYZ \?]_^_`abc e?f_ghijkl n?o_pqrstu w?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ SP       VBT             $VBT MONTARA-GM     d 0 
 0                   BIOS_DATA_BLOCK r  V
  d3104Intel(r)852MG/852MGE/855MG/855MGE PCI Accelerated SVGA BIOS
Build Number: 3072 PC Dev    09/01/2003  17:06:58
DECOMPILATION OR DISASSEMBLY PROHIBITED
  Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        		
	
		 	   ! "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ D                             ! %  8 I 0    Qe    X<KU $  ??W%X$3 oWX$q __/W'X&M `   `   `    @`   D`   `    H`   L`   `                           !                                         0  UT                                                            =                       $    (     
 
     X`                                                                                                                           !  	 CH-7009-A                  CH-7009-B                 SI-164      p             	 FO-450                                                                                   
 J   <   
    	 P S( | 
                                                                                                                                                                                                               <                    
                                     <                        <                        <                        <                        <                        <                  (  s ) ~(
(	
	(@	R	
\	(		
	(		
	(
0

:
(h
z


(



(

(FX
b(
(
($6
@(n
(
(

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@1      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 	         @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h  d @A &06      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +1                 ,          PY @      $AIM@             1	 CH-7009-B           C              $ADDIN30 [    $ADD_OUT               AIM3     I            \ i n     Chrontel Inc 7009 B CH7009-FP 05/02/03 #&0` ޱ #0`  -&0 	 # #&0` ޱ # #0`  - -&0 QW=  3ɳ
 Àrttc8 u.Mu
    .G.Gu5WгP$r, uu2< = 
_Y8 2óu t = 2f vf fa  s
fa   
3Sh<.$? 8 .U
u#ff3f  s
  0  &u!ff3f  s
 	  	  t.G.Gfʸ2 j j fXh fPfVW * ._Ѓ

u[ S$WM
 Ȱ@;ff  s%$@ u'Ȱ f  s$+j j fXh fPfVW * ._Ѓ

u[ S2
[S2<t<u
t	<tC
u*8 .U u	ha$?Nt
[SQRW8 .ǀt
 ֹ  ֹ .؇ u2
_ZY[SQRW8 .ǀt
 ֹ  ֹ .؇& ulGw <r\Ȱ  b <u
 V $ L @  ? u"Ȱ } * <u
o  $g 2
_ZY[ô
ô
fS hSh  fVW * ._Ѓ

t#h Sh  fVW * ._Ѓ

f[S fPhSh  fVW * ._Ѓ
t#h Sh  fVW * ._Ѓ

[ C@@QȰC@$<u++rYPa @      $AIM@             1	 CH-7009-A           o              $ADDIN30 Zwy#Baf    $ADD_OUT               AIM3   	  A   X   \ j o     Chrontel Inc. 7009 A CH7009-TV 05/02/03   :cȞ Y.ς~E: "^Ȟ 
*Ă~EZ m g!H
z=

 
_R 1X @      0X!@     QW=  8 .} 4 %+ ˰n  $< < .} ɰ ; ǀt+uwurt.
h  fVW * ._Ѓ
ut.t6.= u.<r
, uu2< = 
_Y8 2óKu+P  4Xz? u=2< = 
fRW8 .;Ew.;]v2Y .
ut" tRu f.f
   ff;tfȴ2_fZ`
ut
  *   t<Ru
    .G.GuT3Ɋ<u
  (<!u
  <Ru
  <bu   t.G.GJu2aW8 .;Ew.;]v $#2$
u<u<uR<uSh  fVW * ._Ѓ
ut
[!w$P!l$_ 2Z$< u WfXh! fPfVW * ._Ѓ

( #haHZU K 
_S2
t<t<t
<t 
up $<t<u   P      X ߀
u "u<u2u0[ $߳ u2
[SW2? uÀ"r22_[SW2&k uGÀ"r2_[ô
ô
fS hSh  fVW * ._Ѓ

t#h Sh  fVW * ._Ѓ

f[S fPhSh  fVW * ._Ѓ
t#h Sh  fVW * ._Ѓ

[:  rX%  tZ:  t
%  !&  $  s9r%  c6  r%  Z5  r5  rH6  i9  \:   撰68BCU   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $ g  r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  L  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ X  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 2  X  f=$ J  f$ f$ f    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 7  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t:  $ =$ u	=$  w$ $       f$ $         f=$    f$ $ u     f=$    f$ $ wf$ |  9  bf=$ uXf$ $ $ Cf=$ u9f$ $  
  $ f$         f$ f=$ 	r	f$       s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz.ZXfPfRfx < fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytEsZ[Xfz.fyu&sZ[XSR=$ tO$ @
 fyf@t	s/fxfz,fyB@u	sfz.Z[                                   P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPUNNNO$ONNO$ O'NNO$O#NONX     lFpoypvp @  쨀tYRfZ @  쨀t	c7     fmRfZ     55 uf
-  
f
-        Q$  sYa  ޿`     t  r@Y8Y  |  fCfz     3   r    F   r   rR   fPfSfRf*fff,fff*ff3f uUN0NONfOufZf[fXúvpf  ftRffZf=tPSQ   P  XsHuY[Xfu ff;uPSQRWf  	ufz  3f} f ff ff frf%fGff;wf} _ZY[X    SVa    .: ^[VL  .: ^V=  .: ^SfQfRf P=$  u +=   sf 0 tW$  Sf  [rRSUU*UUUUU*U[$ p  Or<u   f f  fZfY[SQR   Sr   $ tZY[À=$  u r  r@$  fPSUU*UUU[fX$    r
8uf f    PSQRf8fff`f  N$ffN$
fffظ  Nf$fN$
ff        =$  u ZY[XPRSf8fff f  N$ffN$
fff  Nf$fN$
ff[ZX`8 8 8 WUU*UUU{  'G_PQW3   f.;
: t3_YXfP >>?<u>>?<t>>?tĀ fXð>>?ð    2ff fff戰䈽!   戰O     戰   戰䈻              u׾%   %   u戰f @KC8BBaaff fKua$aff fKuf f u           ܂  Ӌ  ܂      ܂  ܂  VQN   `  ܂  aQ  J   a    ܂  Y^ð   ܂  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP    @t
	 %"XP 
   `"	X                                            `   Y$ffY$
$0ظ   Y$ffY$
ЊZ   $ff$
$3ظ   $ff$
Њ_vaÐ            f  f  f  f f f f TلDf f  /f f  f f  f     fHt쨎t<w.$f ffH$tt
                                    `      D                D                F          P     D  `              F      X     F          \     D                D                D  1              D                E  4             D                D               E  @             E                D                F             D  i         @     F             D                D          T     F               D               E                E                E                 F             D          @     D         F   9    E8        E0      `  .   U       .   "       /           .   #       /           .   $       /          .          /   	       .   `       /           .   a       /   >       .   0       /          .          >          ?                  E       <fQf%f  $f$
tppqtfff   $f $
и f  $f$
аf  X$fX$
и f  \$f\$
аf/ff. f"  ؎ f%" 3؎f f  gfnf̼gn!fgf  $f$
Ћfgf  $f$
Њfgff  fffff̼ԥ$f̹ gf.f̼$ff f  gf  P$fP$
Ћfgff  @fffff   tfff%f
   ff  p$fp$
%gff  `ffffgff  p$fp$
$
f  t$ft$
$gf  $f$
Њff  r$fr$
f  xfff
  ff  t$ft$
`f̼V%ff̼b (fgff  pfffff   tfff%fgf&    f  $f$

 f  ~$f~$

%gf  h$fh$
Њfgf   `$f`$
Ћff   `$f`$
$@fPf   fkff   =u;f3ffff%  0ff?  0fF  0ff  0=u f%  2f%0f  2f%0f]ff  @$f@$
= u$<]2f(ff  @$f@$
и f  D$fD$
аf  $f$
аf  $f$
и 4ff% = uf©f fשnf % ugfTfU../0./.f,f d< uf4fd< t<t
u掰f\f䎊fnfff掺<uff  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  fffl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0f    UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f̼r2f̺ t
^+;w 瀸	ذf%   f
   fʺfffʋfʃЃf3f   f̼fsf̼ fsf   uff̼,f̰Df%   f
   fʺfffʋfʃЃ$<@t< t<`t] f̼yff   u fuf̼fs ufɋf5f̀  f̼߭^fsf̼fsf̼fsf̼$fsf̼9fsf̼N?fsf̼cyfsf    t  f%   f
  fʺfffʋfʃЃ瀃vCt>t9t4t/v*f f 
 
 %%]f f%?ft  f	 ƹ )f f
   f   `"f"rf    f   tf̼v*ff̼Tff̼ff̼>ff   f̼t/ff̼/ff̼įGfU f̼֯{ff   u fuf̼
ofs ufɋf̀  f̼9fsf̼Q*fsf̼iCfsf̼~_fsf̼fsf̼fsf̼fsf    t;Df%   f
   fʺfffʋfʃЃ $<u> 9Df%   f
   fʺfffʋfʃЃ  $<@u f%   f
  fʺfffʋfʃЃt@tEv
tt ; f f 
 
 %%tv  
tt f f%?ft  f	 ƹ )f f
   f   `"f"rf   @f   tf̼Nff̼Zff̼f.ff̼rfff   f̼,ff̼,ff̼of} f̼ff   u uf̼ݲfs uf̀  f̼2fsf̼#Xfsf̼;qfsf̼Pfsf̼efsf̼zfsf̼Mfsf    tDf%   f
   fʺfffʋfʃЃ $<u f%   f
  fʺfffʋfʃЃt,; f f 
 
 %%ev f f%?ft  f	 ƹ )f f
   f   `"f"rf   `f   t?f̼ɴff̼մff̼9ff̼ff   f̼!*ff̼q*ff̼f̸f̼(
f̰tf%   f
   ffff%f
   fpf%   f
  ffff%ff̼f̸瀰`f%   f
  ffff%f
   *ff  f  uf
   f  uf
   f
   f   tf f    tff   f   uffff   f   uffff   `f    uf
   @ff   f̼jfff   t&pf%   f
  fffffftf%   f
  fʺfffʋfʃЃf    f32ɰ@f%   f
  ffff%  8tff̼_ffǊf3ffff uf32ɰAf%   f
  fʺfffʋfʃЃȰ@f%   f
  ffffff8tff̼ffǊf3ffff uf̼ȷ9$f̰f%   f
  fffɰtff̼$ff̼7%ff̼@ff̼df̰pf%   f
  ffff%ff  8 f  8 tf
   f
   $p
 
 @
 
 f
    ff%   f
   fff< wf%   f
  ffftf%   f
   ffff%ff%   f
  fʺfffʋfʃЃ
 Ћڰf%   f
  fʺfffʋfʃЃf%   f
   fʺfffʋfʃЃ< t?gf&    ~f%   f
  fʺfffʋfʃЃ
 %
 f   uf̼Ĺ4ff̼йD$ff̼ܹff̼f̰f%   f
  fʺfffʋfʃЃf f t't"ttttt	t(f   t	fX3瀰pf%   f
  fff$fذpf%   f
  ffffgf&f   f̼ӺM$f̰pf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$@fذpf%   f
  ffffgf&pf%   f
  fff$0fذpf%   f
  fffff   t	fP  f     fP  f   tff   gf&f   pf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$`fذpf%   f
  ffffgf&gf&gf&gf&gf&gf&gf&gf&f   t	fP  f    t	fP  pf%   f
  fff$0fذpf%   f
  fffff   tfgf&f   瀰pf%   f
  fff$fذpf%   f
  ffffgf&f   f̼~!f̰pf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$@fذpf%   f
  fffffư  gf&ffpf%   f
  fff$0fذpf%   f
  fffff   t	f   f     f  f   tff   gf&ffpf%   f
  fff$ fذpf%   f
  ffffgf&pf%   f
  fff$`fذpf%   f
  ffffgf&gf&gf&gf&gf&gf&gf&gf&f   t	f   f    t	f  pf%   f
  fff$0fذpf%   f
  fffff   tfgf&f   丫f3f3f3f3fffr;@  f%   f
  fʺfffʋfʃЃ@ffrAf s:@ f%   f
  fʺfffʋfʃЃ@f̼6f̨t$$Ӱf̼f̨t$$
؊f3g.  8tfg.  g.  @ۊf%   f
  fʺfffʋfʃЃ2f slPf%   f
  fʺfffʋfʃЃ$
ߊf%   f
  fʺfffʋfʃЃi
Pf%   f
  fʺfffʋfʃЃ$
ߊf%   f
  fʺfffʋfʃЃffAff@2ۊf%   f
  fʺfffʋfʃЃ؊ۊf%   f
  fʺfffʋfʃЃDt2ɰf̼)fr<tr2ɰf̼frtrff   % = uaf%   f
  fʺfffʋfʃЃ<w+<t'f,   2f%   f   uf    3ɰf̼^hfr
2u#r f̼@f 2+tt9 taf̼f.:vf̼f.:Gv]f̼f.:vf̼f.:Gv0	f̼f.:v
f̼%f.:GvA2ɰf̼J|fr".:vf.:Gvf.:Gvr2ɰf̼>fr.:vf.:Gvr2ɰf̼
fr.:vf.:Gvr2f  8 f̼fr$< t<sf<tr2ɰf̼$frufr3ff̼Rtfr,<t(<t u	f   tf   r3f?
f̼%fr,<t(<t u	f  @ tf   rff%   f   fffffff%   f   ffffffff   fffff3.<uff%  @ f  @ fffffff%   f   ffffffff   ffff؋.s<u uvfff   ff   `f   @f    sf䰀f%   f
  ffff%   f
   f
    f
   f   tf  f  ff   ff.ffڰf%   f
  ffff䰀f%   f
  ffff%   f
   f
    f
   f   tf&  fX  ff   ff.ffڰf%   f
  ffff䰀f%   f
  ffff%   f
   f
    f
   f   tf  f  ff   ff.ffڰf%   f
  ffff䰄f%   f
  fʺfffʋfʃЃ% 
䰆f%   f
  fʺfffʋfʃЃ$䰄f%   f
  fʺfffʋfʃЃ% 
<䰆f%   f
  fʺfffʋfʃЃ$䰄f%   f
  fʺfffʋfʃЃ% 
䰆f%   f
  fʺfffʋfʃЃ$tf%   f
  fʺfffʋfʃЃ両f  Hf%   f
   ffffPf%   f
   fʺfffʋfʃЃ%
   f     ff%   f
 ؋ǲ$2ظ.fʳǲ$܃f3.Xf.
Hf.
8f.
(f.
f.
f.
f.
f  f$f   gff$f  ItG ff%   f
 ؋ǲ$2ظff.fʳ@ǲ$܃f3.Xf.
Hf.
8f.
(f.
f.
f.
f.
f  f$f   gff$f  It?fʸf3
f  f$f   gff$f  fh  ?瀰Yf%   f
  fʺfffʋfʃЃXf%   f
  fʺfffʋfʃЃ$fd   f̼uf̰Xf%   f
  fʺfffʋfʃЃf  f̼3f̰Xf%   f
  fʺfffʋfʃЃ$Yf%   f
  fʺfffʋfʃЃ$%f%   f
  ffff% ٰf%   f
  fʺfffʋfʃЃf%   f
  fʺfffʋfʃЃ$0@f%   f
  fʺfffʋfʃЃ$  f%   f
  fʺfffʋfʃЃ$ f%   f
  fʺfffʋfʃЃ$ f%   f
  fʺfffʋfʃЃ$f%   f
  fʺfffʋfʃЃ$ff%   f
   fʺfffʋfʃЃ$f   f
   f
   f
  
 f
   0ffٰf%   f
  fffff%   f
  fʺfffʋfʃЃ$f%   f
  fʺfffʋfʃЃ$f%   f
  fʺfffʋfʃЃ$Rf%   f
   fʺfffʋfʃЃf%   f
  fʺfffʋfʃЃ$Rf%   f
   fʺfffʋfʃЃ$f%   f
   fʺfffʋfʃЃ< hf%   f
  ffff
   f
   fﰀf%   f
   ffff%f
   `f
   ff%   f
   fʺfffʋfʃЃ<r}f̼9
ff̼Ef̄taf%   f
   fʺfffʋfʃЃf%   f
   fʺfffʋfʃЃ
 f   % = tAwf%   f
   fʺfffʋfʃЃuf  Gf  ?wf%   f
   fʺfffʋfʃЃuf  f  f3ٰHf%   f
  fʺfffʋfʃЃg.ЋڰFf%   f
  fʺfffʋfʃЃAfrf   % = tAwf%   f
   fʺfffʋfʃЃuf(  Gf8  ?wf%   f
   fʺfffʋfʃЃufH  fX  f   ٰHf%   f
  fʺfffʋfʃЃg.ЋڰFf%   f
  fʺfffʋfʃЃAfrf3fh  ٰzf%   f
  fʺfffʋfʃЃg.Ћڰxf%   f
  fʺfffʋfʃЃAfr丬瀰Df%   f
   fʺfffʋfʃЃ$<df   2ɰf̼ 
fr<Htfrf   -rf%   f
  fʺfffʋfʃЃȀπ ٰrf%   f
  fʺfffʋfʃЃhf%   f
  fʺfffʋfʃЃȁ ٰhf%   f
  fʺfffʋfʃЃjf%   f
  fʺfffʋfʃЃȀٰjf%   f
  fʺfffʋfʃЃf    ٰRf%   f
   fʺfffʋfʃЃJٰ`f%   f
   fʺfffʋfʃЃ"ٰYf%   f
   fʺfffʋfʃЃٰZf%   f
   fʺfffʋfʃЃٰ[f%   f
   fʺfffʋfʃЃٰ\f%   f
   fʺfffʋfʃЃٰ]f%   f
   fʺfffʋfʃЃٰ^f%   f
   fʺfffʋfʃЃٰ_f%   f
   fʺfffʋfʃЃf%   f
   fʺfffʋfʃЃȁ ٰf%   f
   fʺfffʋfʃЃdf%   f
   fʺfffʋfʃЃȀٰdf%   f
   fʺfffʋfʃЃ	 f
   `"f   f   f    0f  f  f   0fP  ff0fX  0fY  0fh  0fi  0fj  0fk  0fl  0fm  0fn  0fo  0f  f   f    0 f%"	Cf%   f
  fʺfffʋfʃЃffff3f3gf	 f
   `"f   f    f    0f  0fY  0fh  0fi  0fj  0fk  0fl  0fm  0f  0fP  ff0fX  0fn  ff0fo  0 f%"	ٰ`f%   f
   fʺfffʋfʃЃ ٰYf%   f
   fʺfffʋfʃЃٰZf%   f
   fʺfffʋfʃЃٰ[f%   f
   fʺfffʋfʃЃٰ\f%   f
   fʺfffʋfʃЃٰ]f%   f
   fʺfffʋfʃЃٰ^f%   f
   fʺfffʋfʃЃٰ_f%   f
   fʺfffʋfʃЃ0ٰRf%   f
   fʺfffʋfʃЃ f%   f
  fʺfffʋfʃЃ ذf%   f
  fʺfffʋfʃЃذf%   f
  fʺfffʋfʃЃ f%   f
  fʺfffʋfʃЃt  ذf%   f
  fʺfffʋfʃЃ ذf%   f
  fʺfffʋfʃЃ瀻 tDpf%   f
  ffff
   fذpf%   f
  ffffxf%   f
  ffff%?ff   f   f   f   f  ff   fpffذxf%   f
  ffff瀰f%   f
   fʺfffʋfʃЃ< tzhf%   f
  fʺfffʋfʃЃfx  ff   ff.
Њڰhf%   f
  fʺfffʋfʃЃff3ۊكrt, .H $ttfffʻ
t@fغ  ff% f؀f   ttf   ff% f;rfn䠢uu`p2<F&-4$*Px<Z0HPx<Z0H       a a a a a a a a a a a a a a a a a a a a a a a a   i i i i i i i i i i i i i i i i i i i i i i i i   1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1   9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9 9   A A A A A A A A A A A A A A A A A A A A A A A A   I I I I I I I I I I I I I I I I I I I I I I I I                                                                            
                   

       
    
   
	   

   	 

	 

	











	
	


		

		

		

		

		

     "!d!Bǅ 8080,( (   ,( (                                        '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽k񾰱fNf^f
8f{f#"f-f9fC
2fSf] fiܾfs<y]ff f骾f 騾f钾ff|fоfif f"f  f.f. f"  ؎ f%" 3؎ Q -pqtO  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        02/16/05BUC   p   `      POST  f   f.V .X <  
 f.d ` j  I     '     p      POST3 T| ) F  Y xz G 	 s
 #) { (
 { } U( ې Y  ) e ƴ 2 3 3 ]3   z  t bv Tu  p! `" +#  $ -% & z' pO( X) ̀*	+ l, y- 9. G8/ Y0 01 2 Њ3 .4 5 P6 N7  8 t9 8-: Ц; 9-< = -> ? /@ :-A 'ZB .ZC V-D zE F tG H TI (J YK {L *)M vN 3_ 1)P Q R {+S T k-U V jW X ;*Y@Z mt[ Y\ 	] G^ 4|_ ` Ya f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ h@O [X /<t
PW f&E1_X  PRWfQ
u5p (t'@9=Rff  u߿ h<8ufY_ZXSQW< s۱1
2
 hZ3_Y[ABCDEx} UfPfSfRVWf
fFf^fNfV.< t ~.FuN._^fZ?f[fXQ	
}H@
	y	! &
%s
> h3Chyp ?   t  Ãu
.(u	u/ SPVF	` u tR	k@.ytމ^~u 8	kt/ t^6
5
^XfQW~
 
' _fP	$S .#00r#Lt<
tw
u!ο 	1+ظ_^p	+!QfWfVu*p#)6S
F f[tҋ3ff^ff[f`K.fa2 Ap8fVWUkA t  f`h2%3 tkfϿAh6 Px'Q20D7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^Cf`Sfff@= hR3>+f;r[@ Wp
2h_
 WX
_: r
gN1
g.@r g@99 \!BWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_qBU/tg^H2N@?" h fR   둡4]]QRWV^NV vyq6Q3qI4GYGʫ}ΕI^_Z!3Q'M0 pC8 YfWV3ff"1
bIfPS.` ,.:(F,(  f$(0e^
#N~u!pY
h.`   蟵GFjQVRaQR?(
`zۀO2ۊ~f@m{k:P`?tWuf@y f.((|ftf!f.@# >=
uF8Fuf_ZBfX^ÑGVR.>(s$0q	.k6(.(K

ZF(wPn2
F~0,(FPPv2PqN~ t4vf2&fߋz10{
FNNI..($fQvPu@f(.;8(s0ep~  ;u
t`gs_t@Ѵ 8^rf(  _^ZY eWQ3.>8(2 .ǅp.ƅr ` P@hNV.:( `s$' ip3.w8(lh>z? o.N /p\wFk@"~ 
N~f.t=6@.x2̠0/tlyu4.Btf<t؅f  `b$< F. 
1wq3V@~rpF F;F F2u~w
`Mg~f1 kЖ lt
fNqu
ffsfF;^P46)FQz
*q4rF$<u&j/F ~#~ ~$w_p` z.p< O<uO8q^`V@;8(@..8(;8(^éV0&0
9t@-2xk@2
E/1^S 65^35}#wuB.X:NЎu{P:
t3S9)vu=8N0w_^WV~\SVR`FfnA*J[.z!ffAyRffP%Ѐ`2ff
ZKf;w
2.fPRfPt#f3!fD`XfffNL$ss4
tu+q%
u	AfF~aJff^Z6Waf F^~K"8ueffFՋN_QtcV@hvb!F;pIz3ϋ~+c:tsRVRfQF;F8u p? kv@k7F:`pb:$$@Kz@3frD` w;=< u  r,.;D$<uπ r0	 @BvFfYZt4}VWv Ђfq|~|URd
t"t_t̢ @DvP }Pkq9SV@޾O3; t	 r^0PkO˸#Aq[%S ^Y@jx*pt@;?v7h!1k~@st 1;FtFk^% Bk^cՊOa 3҃  V3k`[
*䊁O;oFuR*3]ft7-+k	y	# a
@S
+FHu
4uGrvFvVB7s0;~HVW΂tS03ދ[^NuVp 3+0_&61-Dr<lFxkHpBHPy뷋A(7,oZ &0V  ˋ~1|\0PN~ tKv0}YFA.Qz$ x
fpO3g FfN@P@ 
0K SQh$(	 s\P,Q23If.` tf.&!. .8:(tOьL$QVW
fvUFp䲋"`F^^~F  FψF
fgFF ^Vڐeb"e^`L`Ч!ɺ ``Nf~ tFt'fy`e 9Fv@f0
FfHf;FyQkr@րi`QbbbfC<4zRVFъF8F^ pVF0 N$ &(,ytN!!fsШ#tE rts@CA9FvG 3r%if.$(NͿ  `Ne0ƺ0 
t
F%  .,p >fg~ t(i'i_f^z eu
 v@aQI8t%  tu Qu  vfIft'fAff#a f𑘐pЊ=srSf.6 G                                                                                                                                                                                                                                                            o  PQRa&hk@ $`Ȱ hf?rZYXSQWa$a$a  h= hy >5_Y[2 TCA6  @A Q C@@ @;uY!$p h*
f`  H hf4gf&zP   fa..h
 
<hZsfPfW@&|'_fX`i
u/h	.t_%`0h+Q@c   &  @Q~@ ؀  >J&}uu h|lb!3d 
  % V߸WU]-e&$@#h&ff
q߀tf%af5h +su h9*,Ⱥ: @p 3ȰS, @uwSh3.hń PCN P
V0	
`  
hb2p!úvû   P0I"E" f4%  0BHT12X21-220LTN121XJ-L03 4IAXG02C41LTDEC5V=        + + P + ,
 P f`O  3,3ۃOu+,,q73ɊOt
,r3_ø_{ h99[   й `U;aÿP hc5G`8 h	#> t
  Q`? @ PQ= `t
3f3	@fYX _Tðd߫`Jd  UP@V `S |04'F  :ؿ
Et&؁U uM9NwN#uӃ~ t"F= wt%   +ȧXXh2R`..   !	 O a `( ?u2hVbcp6t*6u `RuraÑTtPRfZX[@(~f._~ AYf` f   O]la"fSfQfRfP_  f,%=uf?a2 ffZfYf[\SQRfW8f_Z YhCef  cs1@^OZ	 /\r)f`Y0s0 h9rf)rOsg QEy
RKjfa't5<t1nf  q)@ Ā Æ B<  C< $ # Q R ST}f`/RVW3y, '+#D#
` b~Paf!< WуtR gR``_^ZY}1 Q   Q tc4TC4nc4NC4/P< f`Ȏ)1)!  hS)i11NNB1+G;rO}1rܰGq֔
腖fa A	   > 7 A  T ӟ M e M A@  9 Y .    ?n SA 8>b (
O  `T+T{!`U0@2 P f2!PX62fߥ6<2; > 3 p"ߎ 602>xQE.h3cPS㓻 $<t4r [X)    ЍOƋoh33 \ f`4 S  y6h3%h>`  D 3y "r< tbF26,2"2e+Jm 1,5+r7+6,ސ r%@X,A+&5&D&EN+?A)`
phœ p߿v,psZ%pn,V~_^ 
8
3
~3
,^{M
,Kb o0|Q,b&@ U$=u&,f= =u X&,&,&,I
, fgh  0 pqr  <ABCDE xyz{|}   )aV S#
fl jm쾶5 r&M-&O-5 r
&  ^ 5x"s u-3nfX@cCf  `rf5f]x&V3
Ê^`0(.'t%.FuN.P), _XWfVUSWSQ,fvXT  ޿RvU~2V2ك!IN܀3d	^
u
t_NA&>5+_[]f^_ PV&=;u&&4u&^P
P<q +&~& 1E&Dp#bSV h@r^[þ7ݹ`[WfP@FhS@ <fX_6_F10=ROM Based Setup  Entering{8`. u  8? J ot.8 `9 Su)!`- W  98p 1A	A8 18q&rJp &8tFò  et
.>	t.6Nt
(*At hoCPXhm:s{F12=Networkrvice BootWake On LANAttoemptto %  h}Bt8 0`9 ;r	 A`9u a91iIQ	t yItsR QP.`9$<0,(o 9H*B"`9! ds@C	%25ؾJ<^s 7_E%з VRyoJlNF J3؁áJ?	uCFG~N0tG;hջawJ<vshZ^@òP*Notebook hard drive MultiBay"DoKckQ%b<#b (top)b?ottom)leftf	Floppk  US9BCD-!F :HDis/SuperN#IC*
!1	23                         D=bP  	 
@ڐ
>m4P R p @صpqlectZDeb]s  ͹U8 and _mo@=the highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   6?L?(t?$P ?'?;S A;Zip.F`u߳ hs d0ô0.?Ӎt@< A VJ3J؊' tA<v<st1(?& 2آٍ;2D=Q#YAr	 > P K@.$?
*}&? @&?+jjj(Pj
8  ?`$?> z    ?a R 2җ
  ߀ t03(?2Ɋ F8tFޣhJ $_ Zbqqp URVQ.,.L.T^Y^Z]S,.&?*[QSVW/ s&Q@.<.-00?0?0.Y_^[YQr> u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰw`2҂ X7@
$?>>r
;w2p$?Jơ}gFY.*&?<u2K0fhZi= hshy7d hb<u`B J qWo rf.>C5 h9	fgf&G, @ fo   PG0f@G,Nu
hEtG,f",7f_ffP QW2_Yf= TKSt0fXbo    ? o  J  b؁h5p.
W
g&Fg&Fg&F"t7g&F0va 1 2H޾tD׎~ذ:{ rsvD	 _k  QRVDTQF r&e^ZYDffL (]LрY`VUfQWo
ِx
K&@
C' C$vC$0Grx  q## r]".0tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ!$&C"u#%$u!#,wABM  f.FwPS [XAu.6Ff.FIDNU.FSfV#{3O #^3%%Ýf@	~3u
u\ru!q!} "@*W3 hmZ **hXr3p%5cf_ ]`= vH O1H aP߰ hk"$@<@X7N4 PR ZX@ P.>G t.G.G@aGSQRWh@r_Z>P TC r99 r/ u t t@XR1$tutZ 2 WW$ f3hcXRISWQR Zuʀ[Ppq4{B XZY_U M%Zу< @3ɹ2 uhXdo#W)¼ P% = @uXu%)4_g&@LhH0VQfPvf  g&?t9g@YR%fP<u @^  f%?f^#   f@"f<tf Q	 f !pf 1^fAaZY^$fVL/
/ZGP@t


q 
"
f^}ff? wD Pf%2к
!
hfi4H30m4r H5 0P@p <8	.12 P` E q "R= LP@pȈa L`	P  	`}i~t  DA& Atf &-&-@0PWfP'B"(rt ufo*H./D.@ F c>- tuc ~rh^
& .p=C<thp}.  G11?}4 Q < t&(.GH.f>&QI_
py3f30 2ɴ*f&- uf
ffKP.&.&.fC0.H.ʁ.p.15RfVWf D3ffCf[fKfS܃fF0rw0а K I+r-_;Zf5SQVWϾ u3_^} 	!BKsV 
R3
t<^f~
w/vƐN0fkd`afft@`[^ɳХVQWfv h-F&/F&p & &P&&0&&{&ŀ_&/^zPUȡf  rX)Tu'P h{|l" h᳂hgaX`a؀atiof]PRqQ ² t%  sS fEQ ffff>AQfhܳ Kg&; Qu70W)f)Pf~Y~/u! /u/u/u	g&t(tx3	[rnf!ǂPR  ;`o	1/uP~/t ~r!	 u;NQ5 -                                                           @   10Uf`f.<Q@Q?u hNrW2rRrM@Qtf0f 0R| Wb t#Cr"t߃ p ; (PJR  ZR 7f]L@V0r*6^  R ZrG	Ku ezdB rC\Aݹ 3?Xy8E tސyEG 	U~gSm r	S>EQ	tlkQkpbƥcW rt r
  GC_SRA0Zt$ؤ5$]WPݰ  _W}  sp  a!`P
߰@S P  	ð D v Sذ8 3 e _R	Ǥ!
R'
9//&QQWjuptPX_Yù
 d h7Cx1s y
2P -C<u4-uĀ qRRaR12e< uZ#ȴ$? t	xJ  U[
	a!"(D pn@ K@{^hYB*h=aßhr$T/h 7Jh{B.u_va { r PQW 0> 3_YX
hac=F H=#h`5s	W> ;Dð   ! $!f` T ahk8@u[' t/ h=Ca0vPZF X>(Z`!ؾL &>J&DEP&D >Ju kdW j@ t~J}
 +Ȁ}	 >J 33SPb[tS[>? 2[sDy3 t^h#ʊWs
ߴJhO#OaàhL"PD
ϰ<DuL
p
E$ߠ<u D
@Q1Csd
rSi&pS]@` uL
 ߃6 6J u  (X6 &uhT
	\

u.0   ND&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  st"& xu	\	PS   ? 4P'>J_3& ?! W>J	_[XB
t+# P xt  t  w\DPV!$!"桾tKh10&,@ &  ^X  hC!r!L	vTt
v߲`WU$/! $<v@a`l3  v
p
u$"<uP>ȷX\PRt N:1thE[!&ķ=0߿ZXv` 22PEǿJ&PCt5ǱJ=ǡJtOu570: u	At!sy96 u5 .,\s
t!Z&q s   a
׃/]3m "s{&=  V P;Ku 0< ^  3f4G -Kf_  }0 U!    K&egWʃO&MuO OqfGtM!tߴ$Ot, t"OGr ǾJM0oOg&K/` 2%
<t29m21_kרt O<uLDHD =_7_D D	 d
z=1:B]tSpprG&}	r??23P3t`h߇2a&ES$`	&Mo&]AH`.'	@[%# r`S UϠRnb0ZW&= uAF:%I)
hJ
 m_XP
pt   U!w#w !#`܊|unhS0 c.-.MSNv=tI! //(rJ
c.58v@Mu% @BS߿B 0hshyaW!$
"1D h<b
hZCYp@[X_Ë
`PS@e![X SϲWH<vLR
 Z,<u(Rff9ş,ZJ vGu

 jS1 6o[Qaw$ ;@aáf3Ұ	fh`֎` hs73۹ F
t):u%b7bD	& h.翱J & 	 hRJ3Gaº3 
3 =Ѧ  J aSu   [R rOrFEqfQ r.<t*DN<u&' t&A+ Ĺ'v
v'+QQy;s& 0R&xZ0xtp_ h qYQ<?v [r(˥u% = tpYjLYS3J+6 
{HHaE&E , ^rpVpVhp#rxfV @$P<PtRZDP۰ۑuO  ZGZ^+WWV 0  PhrX@ 0x2e&
󪓭%2bƀb ̀?!C@5p?r@Dtg51+pu,{u1 
@a

+&C32o3&@t  %
t&
0  ⫰5  t" -  ( 4?
u: >0.b!	"	? A%w ^QmPRW?&wA &]&Up
t ˀAi{] _ZXr#3һ -wƍ2C.u#o/5$N#h΃&<'߸^  Vj    x 3Ѐ>u _ 'SἿ W [j!Vf\ Wf3fu 3 Q>JW:uBE&8Uu8p]
R +B&U
ZK!ؾjZ6fYB<)%qr U; ;e	Q(0=
  5Ãh`bx8.
<tZێûPV#
@F^f  XJED
yC /  n}ppUf``؎ Fwl. ڎfafSfQf.lf fff#fYf[2VftGf   lIg@f;t&f 	F ǀ%f^`2۲faf`cfaPP3_X.>l, . PTACO F|"  
J!	& .l ws<F	l fFf.l  lF.lf.>l<E.l@  tlttYpltNp  D@SIVfB.f$;VrT%WL B!Z\ܐ	i %Qf{2$fP'fffgf"'r.m p l%f@c .ffHpӡfXf1df33ۃ!u+`s?I
s*"/S"Vf+f;wfff}33RRE׭lo4^q4'r44$.x71p6ɐp08333Ҹ  QW>M% _F
3}5u'JE#ȩ t0 t 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^F uQ` &t Y&  
 < tr&\]p &\U  
&N!d J
SR[u0	F@& $F^[_RF FY<p߀TV~'}PVWًذ ' J! _^WfQSng Zpfat
  [fY_` t =$P nPu2MtaË6!s } tp( ` j &?&E?SRUQj@6^]ZV` j(s0ŌD^XP
~*F
  t# b QlF F`(r d3duhX$Ku`<Uuùd `h4d & Xtû   h9B& h PhE'`X!$!   °"s} O
eh2G   t7t 4  h J` {tKu& &  
 P` h,s@<t<uuR 
0u?1*7`P	hd# oXhS: % Pk 0'pjD[%ys%aPXw$# )Р)t`($} f.`G  0m3 西DAm@7 À   ; Z x     0N@`^~#bhW1fF3.
w% r 
\0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہw.~r@V»/ 㐂û< f㺰 fﻀf @ffRfPf!N
 ffFf3fvZfFsfBf〶fp1 r9pf3ɰ`ǿJmfAP  fafPVa3v޸ͿrF3X

S,0<	v	,$x.[W D`

[Lb f s  fɀ
T
ST p s 	 }
Sf_fp fvPUkYP, Pݼ:Fp
uf^fNf?V_f^pPRp*f:VA6F@20hC@ Ϣ
 ff  fffffXCh?q p  `90gz P9d{" 6 ay)P*h|lP, %ofPRh廒K2R ĺZP  (Q * 4ff:aD0  f2MMSqhm   h<rR߀ɀhZhSZ?;PSSΕ袮@Apq$~ q!ͰĀup!A tvntt<1w(<v7&PEh3_ P&
0
3q 33ĆtW/g.&;u;@.ont)@)hPmt؀a`2G@t03@ @u  a[
u93Q^2,;8#fN 

P5-j1rX?03?Qr |X@Y4SQ;o2P5'a&& &߶0hmC hزu򿣶ɰ h
t[ Ȱ t
嘪ŀv#t̰,5-PXv8v&> `tw`_P3 u $h&J
#RV s}h uu22hSgu]襺uXP&
wL`2 Q޻ hNu= Dt= tYԀ'
YY0.h^ZeZ?踸P #> \U  Pf^ y]  _`yrr	 V'afOLPH       @6|P0;V(e
u^V- ^"(P*^  2{oMqSP( 22 pX[úB  $@7R  ?Z`7              zKtP(Q % $ 0rxfL+  %rSr$rF!f+Df+\ r*,r3w r@ .Phrjfa2P PR3U0 Z@AR `&Fdx??uho}P&Xhm r.>R.Spu 	AїQR.۠S@h f3f%  f`YURQSWF^
D= F\ ^F \^t
;v F;F
 < uWP  <022 IF t ~uޠ% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              $?`ރ6.u;v` Ql0 >bh *Yb`"QwLQ`f&YCC`K (   bP3YaPSRP3@mn?[`H@4$&%<GP 	 oپ <BMtf3蕱4P2W X` Er
JRU3 fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	tŀ   
 fް@3t# %t5ubfDqa $<@tS<tO`NBH$u>f=Pۊf@+rCtq Bt#Bt	ݱ]P0f
aff6pZXW_ RWO  3OtCxx ؎ P.BB <t BB2J &ݾ(   8u!@屆`23Ұ
ShTSt0`́ y aut0i at]U U[aSR  4hǣf
 h^SgZ[`-1Pϻ  h=7	 hՕ
 "BPaԀa$8uXRP<u1ZtQrtwvYu0ѹ }R0wZhEU2<Uw  h[2 u
3oҸ EmF)v upQstT 9 
( 3Pf.p UfQfRfUfVf@>h: rsNrBwW3f. ff_2f^fq3Yf.>pfCgffgfׅ suYKU q u, P3	fgf CPpaIfAgabf.#f9ufpfY'40  _  /p ;W5hل 6 Z	7  @Q 5f %"Р  OV3%@tվ p;F ;
V3"/fUi &g3  f% '"꣎ #WFfF^faQ_V p @Z  ?
^`q[3[<   f DTDw R  o 0 ȳhz  17   l ( Pb @0 W HL P`A T W Xb, `
`! p@p x o A0
|\D`QWhD3 3_p 0 PQ= `tq1 @0YX 05SPp
& p  ff&Ϝ X[@aa"&    ir  vf{@Q [J&OfQ9QMh2 ./ Ζ 4Ϧ <t 萍l~̦ tq.ri."D.|u.:DtSI ^ wD:r5+s&v;
uAm
?c1PQRfWT}c`
fXÑ2a`2	  "	f 2f@0f@R %  3f3OfPaX Ah lUv  fb #&f fa dD 	h}W"ϻ (;sQSf  r`
 t
2>fƃ	40q!a
 Q[ff{Y+vf[Wf+_f t%ȡH+f@`h0Qpg-m f@kf`0z q_L2_&U uZ=Pr?Uf uCf*f=`  t0  t( f{{f
1"0"}fph2%/$_!"
 \\-f g&%Իf2@t
 <t+p g1~f&f о  , Xuup Lr}fLBt<rfa&'?rGfʰQÉ_F?<
 M 
"a	Ub	'~p@@R2BuE1BcffF &Ff}{ t@sf @{f;~wt	uɁ~qNїV&##`WfVfPXfXcr<w.Y0ճа_Ѱcf@&ˀtg&TfVR3g&Pf0 `&fnu=жtsaNu(g&fVffA>"[.f+E)^f^uS2u  w & PP0Xt'vt
t@   % r/o h>u  thrs-3&>rwqrRPzsRܑuthX$uul	r` 	߹ +Zjjw b6uPS`` FF ph rou
@ f& ﺁ ؀>t !$!f$< uRC  
N<2<ăƁ	"3uA'y@h[u TYP=t 
u2Ɋ،в3`t<u
E< tE$<u&w $tRVL  N L N@ڰu û` t  P[2u
@j jY!(!!2(<!1ʰe$ h5u$0t$~.#K,.t4&^ t<r&Pw 3.\  5!.\e@.dw b    W	x .|h=_DuQ&~% t P辫Xӹ
 D.:t
 ._
vXP%8Xr6%ȸfyc4;La    PJNL p      QKOMp @Kt  Jt P(.DGH h2h  hvQ h҅ h~E Б?E^  ` f  Cp m& OE 
v? %&Mÿt&:
&;sr"`p$t1TKub 
HM` `(q p" s*r#	cp&3a C 	H ]r5r`2gpjh!˰vZaVRQShm4Thؚ4J.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Ph3UX<?tFohUujjjj P
8 &hm:޳X\ h $vbwt = ;t= Dt
hEsp[]@WVS$`$
w[? @n< u"*׿OطhNt`-->J=Ot_1 0_ tyr rh  >S^1  0 hL PͲ5[ ?  :Nz2?Aq%  	
   >VFPgbǋVW 2_2zt"@uG2 
u
2 ߠ
 o2E2&&&EA &e?
td&E&&E E &E<r&}	r@ VW^2۠^2*
&}vPuh`VRPRQ3{f 
%*t,AYZXRPSQY[XZh?tuS	pp Є> qQ 5rXY`^W-: t
*֮hDRL&&  t8ot' u ag,& nq00r6$^$ rZ& && ;`Z@ `dde`P`  XU @>
ڹ  .PB B把䇿8uG` A ; 5䋀/)@#BS 냑6VŜPX
 a@A@ B C    FtV$%Ȱ%蝊<;weċ X؊<wM3ɆQ#"XR<  YыƊȊĴ3Їу\E pY8@C$0	 FWYwuF5<uz`0Df&	2
pu8f߻hNePӀk 'B@. ,".  濥&k !< uf& bÊ$
r wAu%1uh~Ӳ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<fMKff
f[h*[f3f3ɹ f [f0m f+f[ ! KMu*MآMcf3ہfsV4C\` a^_^fZfYf[fv3hI 5U=`2K ۟揀L0s< |&	3ytvou4PP 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .0\3۸ 2wҹ%&@GaaÍ6<h&^VWa<,z_^pk` h$h  uP$<X%sf @  t<   4 r	.Ѩ$<u
 f3hh.Ш 
d?]XiJ	hT=  tdbw_3s.>ШNwfm tghtC	
A!U2 u@? o > ?`c 3Fd@ e f Fc~ce@7~e uQ@C9?  hosz`5
P	|h0ӳBFe:Ffu1r,
 h
 _Fdt;   	:  <g ht5Lh{sh`!af`7UPKh!u>fB05񿤯SCA[t$w N hD&N r hPf0̾   F^P XSĻ  y ,    hbS[t(t@_t,Vj Pj,>" ' À thtZdúߋw."**=ED/.EqEq+Ë؀F/VU2NfQa dYF :uE]Àg33t
t
u
1t#u
tN`2t"FF0u3! :5tFFdz ulmb9p`F: uYeb +Πu"<6F1 ep0Fwff`Fup  0j(j	R"	aURϥhT2  ɺ i1 h8rZ]ÓoR+Zr@!  tCgRQ QK.YsY2$
 !u$0idU|Z f`3 w 3uW fI.&Ԩ"^fԨ  sChB%
>C ƀu8u.>Ҩ 1fa
ZURtLޱUHh|lxk:Yn Yp to(tq ;CPZi@"ƽg  squ4@VfRf恎h~$0;^f[r]8" ۡ[Z߂bhdTr s U6Sj@ 2P s rGZ45'_UqWqW`.ӨuQơJ$<u:`pr"&  tޒ  ttҨ} tAtw $uPq9(
ː

 J`XSQ 3u,S?8[rE	ˡ-Y[C& <ff<`00xx00`||	>>.r tr~ (ЃrL]CX̀'tCVG =`Q<Q7W &TZsps6C  Eo ц߆ԆrB zuN! D I/u 0/)0/f#-&A ;q5 F -7&/p0W aUfV3vCDPDQD 7@4?f^]&໠QPЂJ wPduXd@I(aߏ@ `O` ͟/////- "  @f%pк FACSPZ DBGP4BHP=  0938 A|!  8  APICZOnK	a	a
@  		
  MCFG<	1P	 0S   u@(z@
 2! RSDT(  	f`hhwsif  fhpfp  gfFgf  FPTR ff0WgFpf. p^$f3..f.fgfN}0~$f+ ghpJ~3ffgf&f.>Pf(.	t~22@_u~( N g&F	f P  rgfffff+f+.
aM.> gf
$$#DP~Xff-qAFV3g&fFgY[@ff=TDSDt3 wSt+Pt#SBStf=CIPAtf=PGBDtf=GFCMt@HбQr< uBONRUfQъ̓2 tPpx@rAr v; tg&P)XfY8]|VfWfV*f& _fP&ؐ@(#f"fP)6Ȁ$ 4 
Ȱ ּ
ff	hcp (fߡ t  h`jsfPW EfX3/ wdZ$wc g~ t+M
h*3=a+0Q~;g&h&P_g  PSV	 o 4Yt >Gu	߃Ci? uDb& @ {u  ?D` ^ RW D h< hZ=_Z!PShu7tSЌȒfP3h f&L f? C@$L fX`h%Q" 037fP&?   6Ku    EOGKf3{i pH  } U!   K>K&geE E puMPMpMGfEtXAt$Ot3 t)O$fM
?rþQpmMe&KaZtS\U  r.0]h2.Ԩ<kXq_   kø ޳ ltWp`f
hl0lf%ttӿ' t E(뭿7 5)P*io_ԝVΎގE^3f`FF  h>x }us h  $g(,0w4'8  y7Ã9FtFfNA:F> hS:ɀuh(fa`
Ex13ɊMh$Ӱt?

hRp;r#uac5WF _^9sCf fN_Nf.9y0u }0tc` rfQPH_Erf;^uf;Nt;oft) @ 
tF~U_վ NfPV t;6L(.<t1l!RRhǄ
,,׃  ^_pV00 u,h..D+hXڃ p1_fqtA"   u
3   t'0gfy GhEC~G$L<LD^COMPAQ PC Card Smart Reader,GEMPLUS GPR400,?PSCR C1LB REFLEX 201241 PCMCIA6Reflex v.2$c:r$HP
  a@!g&O@ zGd `P ߳ rLfK sor>G	 .D
A O@.d.D?4f_ PQWh  
G.g&:uG Y.~  _YXQ8t *F 
⡥fW
"
@
@Bg"
*
3%Qf_V`bSh:0Gu#{  e~uu .Ѩu = Ў~ 1rp&tj  t_& rT  r&= us0=6>
r/6r4.ѨV@< t ^pJv 
w x y   h8Shmsz %Z굒h{aGsia
qTrPqtI	f| U
u 
!tQ&p9s{	GYV
},`؍vfD   ,AfLs-<t(<#@06~ h	L^PRU32t
t
u
5# t u9<0r<9w/tM>ư7SQ Y[t>"$,0>*SQLiE;f 	tu]ZXnf`3Ҡ&w&h#G֎fwv*`%h㝿gf9t0Xa` 2   0 thbq egf@ Vff3f"gf F f0ɱf!
!޾:h3۹: 8tCRP #t r1hf˩ uf@q  00i{? 0    0     q'  ' D 
 Y/ -bbk`oC@GY kϐi0PS_?.{pVW ǌ׎Ǎ~Qr&} uBr	:`_^d>r5r!r\E@&=ߐu	#0#Hr&E$7u:5}ɐɣm0¯Yӆa
Cr&a)rI DTtr&ϊe`4o5:0
T3
 ʗ5q4S1r#@itct  t$?BffLo  	] 	KVQ
RNQ3q
]
Öʱu0i+oW!z PJʿr8u`_QY_ þL[ r&Uó'N׀gL螳`
Pw4$X` $2L nB0<tH`8u6
uBp & DBlTt
aP 3 r/) r%BBn!J@ 
; 05 aù<t

B Jw 2o@u8` BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&a$vQ> Yr	2Qd'Y}B@?Aq Br蹐M^	 fpb3׾   _ @ P`ңP@\`j h\  H h	S7蛳(k?l hÈ`% `f= @u [jh hc Sjjjj P
8 g\ h4cuq?j&Rv^$bwtQ= ;tbu= <t/E3 {hZtpkfaÐ  ?   tHuuu):p*< uwuup@ z`3'jr! grπ DƆ    rZ у-Z1p$Wp_ǀ uu' 3a re+ tg	%  .Ѩ{fԨ  f~ tpuY[ߋr/s3hoƮ ڻ > ڻe ЃF  ~f c `W tI%r=? OӋ~ t@Ԩ@t0(5@ MF t w0Ó3N !F ~ tٳ	-e0鰠SZAt9A`d f` W܋f3Q fY~@ Ix G"
 /2uJp2:!&= t:~8 lr Ԩl0VQ&oUq
e<sY^{D^
=>f"A	
lq
&:!& :X.Ջ IhBB s
Di@P ;(3 ހ?  A-ݻsC"upm\Y1u[	q	1D!IFt3$a3; 2| + f~B \	(Nf@2Bt1Qr$!$$
7R< !zZ_t'
QVJPf^DUY!Ұ.&Ԩ++t'H"`Xtt.a:``s;߄ 6sce_p_pkoCdqooo#Ueooao
fo谫Dcdםasf@SfQfRp>fGenu fnteluxfineIuofPH>f%`f=rYf˹a2?I@؀ Ut/f00t[fPF 
= ZfYf 
  K   
 SETU ˸ @؎&м  3 r' W@ P& u_SV  GG0G h@    Gu Fu t3  hC) 
h{Bt & ^[SO
&hk" `[U샿VWƿF F@    ԐZ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @-<qt	dR>t <tjjjj3P
8 K.wj5$<t.<@t$t = ;t= DP  hEn 揿  7[FF~ t#^FLr
F FQ  ~ wt: ] cf
 h;\2%PFA~ t
F_^Q
h8ss.&udu   hb,$?wط h;*"h4| #h*f_01FhB%..  @  Y(`p3WVe1E0E.WV .^_UɭP)UIQS6(6*`e1E0eEE.U s@ m2a h4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	   kQVWAu% p u㾐  6  | = <t ;E@+9 +_^Y~RWS Ê WCrr3ɺ ޑ܋e\AB rN _ZqSYKK=K
ZQujvz%NOJ5> DE<@ ;<<!<3TuU OOpPt
Pm[VfPfSfQ0ppf3fk3CpP\p|pXfffDDG(	Dh fYf[fX^v#KgO G߉xpQRްC3ۊ%<} t CҋwyB`s|fDf3ۋfË\` 	
C  	T U S V 3	G	[	o	}	`h	xh	  h3	 hG	 h[	 ho	 h}	 axv.L.< t)F.6I3.PF.h:r[+V..^̋] }DF. P .hmXh0؃ 7R  16W  0"mXa Y Z #[  
\a a _BA]a fv g'^a ;b ` `mhcij!k qp10G pppQWĀ>t		 u		.y	_7   O 4a9Tһ -w C.ő/⅒2R+m?n8o7Y3۸  _`߸^va>QRrkPS[Xh(hЍOƋwh
3     o     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;g   09/10~z8S12/00 4 kLite{J{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdP_x>0@Zݨ"2""Pf"x xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`@pcłŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5FeGauu!,}x00Q<k俐}Dxe``
$`$p

xc2
$xx txDESxxxxfD@/C0y}}r k ;]}d`xGC FP&x}DmQ¯00xtxtyuup*}iQb}ps ~aU{}wc+*")@xjD00q x^Dx_T_xcD 
T e p# ) ,1`~V|
-%&0!PI	P1Tx"p2x~p3T0/ߴ/}@!T_ _$ u!`	rT`#8 )m	04`ht	sP	;G	"+u+$4?iq}T+}'د+p (++@^:,+G
H
0%1vP7",`^80/}@j+.@ /1@'"  "+7x0&x+Ix_`t 7"6}

P} }e	!	  @$#}!}a 
xpxt"xd}<ߗ}?A"@+ 0}A[z#A00x )xh`xiw  p@0S+;/TB+x+¯0);0b 9P4.+20B+`xOՀ	+ xTx !
+:DTBKPF y+kP>

C \Tdp+$!$OP+0.`z 9sR
 ðÔ2@VD0¯xx7x8r x009`6%06 ATߠH`	p5V5l ;A@#[8[N1G0ϫ*05E"`X`X# LXQx,Uxtx0x,q@PD0xT?Tx*Y-tx+YZ@?TxYZ3M^[0MM&	,^wk`qAkPqux__DND0W>   R  V>Ђgxd?pF^	;<[dQh`kQt@*ARx-	+_SRNx*SMxY+` !Lz `R0 
PpeQ`
 RSPPf1% 0Y fPRoe GYWxZAYAXNSXW }#X$0Yip^qZ1ZTMZ1uԱ
YZR[m0c1\߿\TPR\
r[	\S2A}; A}A ",A~> B~@  5A~? uuҌВ"c4"7x'D
 Y /7d`!70h33TT?OC}`07`'`2`=`HpQx] 6uuuuPl uu0 uu5ˏO$pN`0T`
010P@ A"| }(x]`U"+,,E+p
0  +C,,+ +,+x,+0`y!,,,++x_,,"-.?T0L72Qt
!Mt&Ipd `1g11![tU!(0響/0mp/l`
/0d@TzE2AӠ.-Ϯ/0" *xc"+xt`
o3x7Px8NW7tP}0h"[ZYYcdYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >wg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~T@ 2 Y	J @ | @ s   ww ~~ ]r  "8_x4D` T ` D)YRDx2tx1tI- &%[0& &xpvv Q&xp[Sxr#$ % % "2x1 	ү  ¿0 _$"@K`ҿ3#b0"	Mx3C
r beJ"xqF`V0 pC #" &	x30$0%<T`P#"xr`bfp
0"$""tT.4} 
xr$3z 
`Hp`p$S$ yrp C pxnv"x~0	wD0$ 6@Tx~y}D"0p4hxlx}@ oDT 0
 pcB"pxt1xux|"xtx}xuxx|	"xwm#xvPxyvxwf`Ӏp>xw ( Qu}B@
"-`"x-pt %-o00p2tU0/0b/R0h0o../U0`OU/`!!.-[/0/0u/ u/0/-.3P/0!d0Ô@"120! 
0
0!

"0!PǿUH `Up$P	U<0
`Tb" ! R0 º P!1D12Knѧ2!1¯Fx1"`u ?T""34Ӊ53 /:}N+"35{54!_Q0` !xno`xaT`aߓxmp)nvpP*r 3}TOp0@0 0 
ֱ]):Q}0`*/\@P*'2B7Ѩ P` XӀQ7' "0a T?2u$407S0!{z}yD2378
u8 7+
`8608606@2$h' @^Bp4?


פ$Y	0
	@À{0-$`
$`$p"Ya"V4#K0! :0!@À-0
  Ҥ s	!~2!
2xnfPYo0*2d|p06SU{zy{ x xovpW[%_`gK6P2 ( 	4 { W t@;H	5345q3`	t%5544r	@ :0	h0"06`	2A06< L	r@1k 
  
 *90 B 6,G 
jm	" !!`BQ
p0( 6"W^ 
-NU
]nDU 6.(
j'	@bG+6,,f-e2pO7)0	LP-85p
b3.&/05"	c)	0
S +":"088;ofpO:2%!/nc)P3
U1:@Cxm`qe`?0}DН h,g,!a,a b}ew"4xFMNOpxD  Pe4_`^}R Vp0
T4d`$?"4#5p~}e4xӿd@P3 0
3 $(`3`3$`e$`1$%I$`9$`$`)3]$pv~AT Vnq2c1[0TxvF>&`!	0,0)%0Dx  Z3c0a ?3]cP):6P 	@Rи?&|¯43`p`w p\TQ`xj  O*`/CKxv
xD}O`&z0{^`
}iT?DtJ`PpYKT~LwOq"@`T`M	0676$``$p``1e7`tgE7r((^b)ґ(0?'0)a a
Td`x0dp#  xF 0TÔP
*xFt pxBB~xUNNw}wxJqJpȏ:;<t/?=(x ү!:%$t=t=;2!(0 (=o$Px`vT"` 2'<x"ү3y:; 0( ;:@ p0 xόv6QxV86}'p p 7  %76([7  ""88Ô@3`p/p0 
(` /..d`
&~r7?) TP5?O) 4"  40040@O453``/`@$pN54&:I&duP2);P [x 
33oppG*L2o>gp1 ';P"ސT~ +?T#>үd`pxHo 8@22P65b3e1@d@>"01h/ 
m
`,d0xA%30 B1
@
 0E00
TDT@5q0	 3:΀@a_& AP}Nt
 u2P2bt߀l@
Y0.
@	  r1l0dpe`30!DxF105@2`e bC7xnu30 0u3r2+(t1123|#.1}p<0 $32  a<0 }
1pAR ErpM&"^p  d.CBS)x0,u`2:E,`e4 2UU.X5%.? ,* 2732pha,
$,eO!% *R5 }
Q'x`S+0	+`# -R	++@@s@`p7v@}	 `@~A0y!T``;Y_` VWy
7p~Dxp/EDy?N%@k53Eop;OCD߯.DqXTQϠu:93: !p	S3_1B3dUA`hy%%Ovt0:QON@pHR/ N9
d.0
`0X6Fp0X-64F<0570`5#O˭0]c6e`	S8@1
!b-1|I%P/;u1
p< u1a1[Qŉ*C{p4Iz5z5
3z*+	yuv {| A+ 90& n`AT0 +	al:zpd01o0upo6o,/-.rpF}}?0
P?/.-rdct%,f Wu tq70YS 8S;"Wΰ4쑔p1ƫBŐ}BT_0=_<I?`$<p:T0Oܑ78e`pYלBxfT)Ax`%daz0  87`>P$42q"W¥A3U	``uqq
r	1Q`{0
}
9ȷrdP9$$P6"{ 2F/}&e'AChS4Iqo}aw X@apR`pLxpGN3p?u]1ԒU^#5_`@TU`#v@|T kx{}Lxzp Rxy PxxPQxwMxv0Cxuxlxtxaxs`xrxqxxpx`x|Lx{`RxzPxy@QxxRxw Cxvxloxup&xtPxsxrxxqxxp"pxjv00,pTxfL@" -4j0-TxfQf/_p0NP -^ ##----Ji C?",u/212Bp-21Կ^ L.e'q,Đ/$7,T{AO-.`۷pGRQN.E.OJP7֔0p0Y))y70h
P5
PIs|?`d\7]}OPn,rtIar4N:0`a32Е
p1
P

Q "u- 09r"l  _},n1vg9, : A3.02z.pM=1s0D@dT:0u`z^P;DS,c,u.B.` +2 |p0Ⱦ`u.Ta2)lC
.%TOлQN]03p	 `` 9a :b ]$ :t>)NӔ@6S ? x0!  x6E0Qq7prrqxv(WUP	Xu

		0
  `}
7P"q #
G1opWTrAL`>M~)60.?T`@}w}S?AP33TBDWD  Axj6"@tI C9xVxFdⰣҢX`T`H>T
PɞM>@D!3"x)W"U\]@0Qqڢ97F 03tƘv`
pUr )J'' 'BP_P` qw0P `	qPa"NO.eB"TOcEN Є1n`=\=NA=NaYpo0:BP e0!JI$:1PJ1,"F;KF	D0c
^"CO`@"OHIOv30aA!Idp @0t=t A2bIBJ``JIxnvHI<i"xFExGFxEGxFt@0( FT.`xFF0xG@Ft"("F?N 0 G_=}"xB!C!A!B/)B*Q( #NA
OA
MA
N/I
N+)D
JaKaIRaJ/iJK
g
b^0JKoLM`N T&` @ws0uK`K@ 
MLt ~HKJa}i}p}~}wEAMI!!K..C~ Ô@"TxDҭTp𼯿TAp @@$0*F;B}@qRTHC}Np(UAtAnAbALA@A*AAA @@@@@@@@  AC Q[HH" p&bbr! t"xbo o o"C pD )p4	KNp#q! * 	A[ ]9qV`N YVo$`RBJb d$ByUo@U1OůU0	xnZÀӒ }a?U`#`5`2$pCxD4SS [CxaUUTߓxms& LYq 
xi0v GÔ@π<PT~xiCӔ@/`Bxr
T"  Ptixo aa?v+xmv25 st 4}nt  to}D
 "YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTkATAAAD,!@b*>}ۉEb $QxF%!0U`Ud`0)&uUADDDDDDEE%E8EDEWEbEqEEEAE9D otNA8pCb,0D
m@T g@ܗ@KL7 &T FP7Txa@ZEQ
hˀa>WP A7O0D=Dd
`#p`(`0<`PdP`d`U]ȐيUw09NN/ .0ttd	QRxtxxXx\x]txat"xbt}xJxFxBxtx(tbxx%t &x)xxxxxxtxtxtxxtx x#x> x=tp x@t	0xTВ
W}࠱%x"Ttx!TTTaD	x?D@xTpT@=TT	Tx= Q
@TxDp?=DmDTxjv0}CtU QdMdR eP`eLO;]"x0xK"xg/M"B S?/?@>"$ւtO>$-"T_Ô
P~0~7%UUdTT7%TT{ z yT H H+H3H4H6H7H8H9H:H;H<  I'TY1	 Q
 I`A @tR1~5H_)T& 8 `;cuTuTK0T"$`($`*`-w/rp4
nTB [CMb UQ P"RLT$QIa|JIb P X$1`r$c}JuTxt x   uT  ! Z0t @ 
A^::32 *}0 C #N'/A0`,`0$`3`G`[$ap]Tp^9"T 8 dpF{^A0$s `!DTJwwq/0 T p U "&$pR_PMQd` RQxgQÔ PQHH|sq@P
qJPxgv@@0KKKKKLL7L;LVLqLyLLLLLLMMMMMMMM/MUMoMMMMMM  M0
?v"xFMNO`u{R RRsxИ}ew  x^  "%"0RQg?
R;. Hp"}} HG}0Q"uS@	0?SSST
TS0SCS 0P 0@4xatgvaQ =`0jxTxjoD0Sx0Uxbx"x@$xx"x`}K}UIF	
Q@ Z0""3HFxT| } ~ K4|Q`*O԰]RR &OԐM((sN3N9OBOQO\OgOmOxNXN`NpN NOOOOOO.?!PÔ`P/QI
"T?ޣ } 00x`r"QfSQJ0pV	 50T0;DuQ0]p 0@I0)	\S":D$p
;r!/0Qp,"xdP P0A3R"~7}e 0?I[R3AP>l2J1c>cGq0M}E@J`d)Ca
 .:0fTN@g QyT0PTB֑PPJ@0#@60xD Tax h!1?xxhvpaԩ$PT AA=B@011u32}'  $31T3322@"P0  "}([W ]"   p}"/v*Pʏ0/Ô/pC0S0߯0P200PЯ"
xp0 "x`2345&}@"(t?3t ?2x`325R4U5B axQxQDQx@Q  09Ī6xT_nT CTR2CRVRRS!5 T7T_TTT6x
/0!x
tP/P
0/ x
  x
Q{Qyx
! $60#t #T %Qxs	}TBxr0xrP2QJ0 p%@$T$ÞPxr`O1 	_*_,-u . <Tү$`&p<Q^(}_ p% 9C x.-,6	%xxsӔ@v $(xrvyrxsP!  P&0 	r6
pxov 6xa`r
pqfP 0	,xx
xR!x	06T)_7|P$3p 06d2T TTTUU
UhU	U
  V/{pwfD4 D@ @B@"xDbU$P``3T[OWD#X0 +D "z:zTphO`/AE@E *@@jCEpUi O`~@  w 33TOBOT? @ 2^00"p<`p}Tp`- ,*,, F5RS,  ~S,`xevS,,"+,/0,WP@W.x	W.}wNW.u0 u1SSS0S3u2 u42U03U1Np1%10304440}P-5xp7x	410a^_55,Ӕ@xA=-Ps Y60c
+p00Ӕ@@60,	`	@WWWX
X*XwXXXXXXXY
Y,$YF%YR&Y[+Yi,Yv-  Y{,6S	Y{Qxu/@xB![-.![P
.-`Y<	
x3 {t?e.?pt e-``l	clQrl"	`Ax@}v}t&܀
-   bt_,Qev  q} pQ t u vAO}	}5!`N)q倩 Q!q^="P/b0 ,+"7`w[7YYYYYZZZ 	Z'Z.Z5Z<ZFZPZ]ZdZZ[3['  ["^PX['Xs U S1
tt)ŵx#	
pp&Ŧ ,D lTQ@ST0BQ|
ba:Zl00QQŔ IZP  cZP[`!!I0~GJ{t(ಚDc4rKrgQ
xﰒj)1O`D,1P
`QJAS[ "gD `C -Pc80.u,,^,SÔ@ ."W,ҰP#t .`
T/Ӕ@""@
u/$ -$U/"x@|Ӑ T"50/}5"24 g\B`2y\\\\'\/\@\I\J\K\N\Z\[  \  `	xk0/_" ` 0/ *6uq(QSa  " 0f33%$'я`e2pG2(640!+E4d	`e
4Xe"anv""44$`$`2$`B$`J`[$Wpk\ P S0/V_QR
ZD	qv3]4A@=G4pH@T
>q
0D"×"""  ^l^t^z^^^^^^^  _u2#_u22:b ! 0!ZrQcPyA=r!
C]cb }6Pr2UUDE. u8QZ/0!ׄHQ R 0 32"0"x%0qT~t@"7@P@n@	T3" Ox~ d' "0~Ő}t𐿿0	ˁj_bA;x0x!TT`D_pT!D`q!T1 71[xD@&?A\"  :	;
/123B=>C	D
WX`~x`!ÔP ^`_cV"
%{P翖F`70x+ +bxq}qa+s+H `C0/+xT 6} 2@RZ DT_`X c}@TT`}40	61 aِS 
0cx	+$```9@=a_xv 0z q DxT"ҎxStTTH`S+xS+<x, 6,@C`$p#+pxSx+	x~060/E

0` " .-Ô@-ӔPq @
QPQ/-s$A$cp`NC.I}?.A+ }9VQ`@\DkT ]P-Bp}} cC..sc1@ $~SSN`R$dp[..". dpD0߀Ò/ۣ.Aܡq xk..TpQ"-.{{ oi" #N"x7" 	5}i`$3mp`(5_}`` Ϗ/0i!UdNdxdddƇdψd؉d؊ddeMeSeSeueueeefNfNffffgcgcgggggɩgɪggh
h
hOhOhhhhhhhѽhѾhhhhiii<i<i<i<icic  i~=0~p~ @i0p C3`T330C3@4u:$ŌV 4`kR3Pu3Q}3  #/}R_c^$&M.03;_
Քf	R		//pX K૵(L(O 7 ~ q`| }` @^_NcC3cf~R &?PPo3Ôd%a*=|(z {@
` @\]L`+#91"#
''21&(**/,R,////2161/s4# 1/1`p6Q8"!!z{dz bJV:v<O>)`??ݏBRB/2D6D.`/$/4uvF/ {5 39M^`P!PIVI/Nπu3/3"$y`@!S]PPch! O "@A~9`{jPLj$`j`T}`%A`"0"xs@}	TPP
U
VxpBBxsPBQ0$70#"A "%@ABOr+pUUpVpWpBxs		 ɒ":;<x>T=|Q
38T>?~`dPkP?> Pw0=pCb ̰8i ?} P' 8@
QZ| $ >:;<0
 krd Ep6ь"}`~; }oQ k# b!@1c ɐ}  :TTngt
>DP	h0  ]_RR+p?ro++A. 
~;uk2@$@] @uTl@&p0tp^% 
41nl|l"14Pmt1xe606
 0qۃ_Ϣ60'z zUr}pp
T?T`4"4"cu27<0b}0h~^fvv0˒TOD001p32k2q]* u1İADl0 	3 cP8PPR*PD2^fB32ŕp087Pc`&RlP}`"!QpP0 T_΀O"070% o03;3@,pe0`01?2_ ?V"eqoo0oP3p1 n10}  c~8g`4 	1Dcܢp@T3`02`;:+"45675E4`546#P
(45u77$ǵTo`MӐ4}`TM=`` `'p->T
r D DԢ i0(a~$ $CBD[0qd BPkZa@	*u1au0)'2Su0p
a1}@O}][?2u2u0 a`20Z `@'V6/{[pCl85002V@T1TT%%O 7=<Bp;3`SB
9
~p	0d`0@_1YZT?`<@!?$p*3t1TO Q'	 A!aE@CA/	:2`cOA8WKk$U'NtPlƷ $	8Uhہ
'$5P}5
E8Uhu)txŲ7Ut}5}{zyqT?hH5tf1t04.<t o0^u/'P~ pfq/p5%tYBte~@A_QYaqoЕpTnN`;L=2t@Y1	ÔPtીѶ1Wo`E~`pw453*`~z/G~zk4P73a}Аu((sv+vvvvw6wWxx2xyz{]{|%||||}}>}_	{ z y4j	`5P4F w
:DfS$TlS3D*{pu4`u5g 	]4T`pd``~`Q:?
p0
PF4s	ǖ		ym
"6W7d6İL}67"P!nR`q@d%ne5p4l`&+@ӈ0C/QqKFB8u u8:Uri| `z {0;` @\]Lyk<899?9886 u[k8`%9s
@8($d<9P(cYz4ÊDQ-0/*}`u} p@~
jV2n*.@;@;P2EpdLp{qtP+#1?1s_b[u?mpl`*
`r+@~+uzdNpt/,V+5/B	B7LѭNp7>	ThGȵoVjp?pNSZwdi[/Y'P#&Z/i L(0?_?VRac<Je=h)>ѕj?TŝMm iƵ1}sxVD,T-09L80࣌,`78z۩3 7u֖|E3uZ"27%~}3a+PC PQ| 3$`A`ymP~c $~ 2|`u3#ux77 dER tu`
Ô|		qjPt7pz7qTT Np:W );4u3tp7uq$x37 1a`04t0s4f 1 Żn~~~314ђ"H?6P_
R1p!2<?8}0ـ 2"u0_
^03}bY%҂/^}N|a^ :> 2pPau2f	op` 0Ʉq
``ӕ19100b6xeT`&$3o1Ptw2"u}`q 
 """4}t t ?HP
3U02	~:TD"LION x9psP
 D!T":p
~"|a!~ dx ÀӲ  0d"0Ӏ 7p8`0@
D 
~g,T e8"a7Vpa~psP,~"`@s@"x0 5"5q"psx 
qUÒC>A;>~ 0!" on`dx"56uX`,5bP| б`  Pn{p	64gk6$2@"89I;u<98~@98lpe;"9E8 `vj@@~+k P" W
pm@ P`I@x33 d ::Ӕ@o:@>x#q,	: P,Y=x@-:zQ 'W<p 
; B
հ0^=<>?u@`"H  /(p??p>ÿ?
>y+@5ސ5@@	x&T@/"%T~ O7& @{"`"E"x!To`	TT@5S7?3o`@2D"C
xCp'xa6@>4ra/T(--,r e,p,,~?e,`,,|21G3>d$-t"u;2rA&8<9@Ju;;;`ӔP9:9@ɐl56x>~FM pb?b-55	d` 
Ga~G6C!"] DJptO*q+,U
,, +,0+@_b&@T` fOGG$&_xt
 T0xT1QT4TDx!CD@gp
0g1dpa23%3{3+23 2@
4pk0V4clN(%%q
O Z0a00*OMTeT+		TY!~>` #Aq""	߀F	 >	@[2xp=d X LҀƀԀio3ꀚڀ3䓣łŃ 
`	"3/ߟ$ ̈$ P ##EN``#sB"P""):"P%g0 "b``"  )"/33@p " 3xPտ"Ø"(p p8

r
		^
tQ
X
	


 *2y 	1	"/t 
""BBE"""ЂP  tsی6 s$ŃŃ1" ";%5@bpp
s@h`/1p1 $1@~1v1@In1 b1V1J1e 111,1 p0p00p000#*s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)    K   P DSDTDSDTI}  HP  DAU00    MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 D y 

B9G  D
AAIG
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	g߇i
  #11g 2 phpi p
 f"`'fsg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_OS_`pga.ag)`B4
bra/13oua
 6
 s %[I` 
u	273213415p0135_INI 5H7
fpig
f 9i` g9hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\a@[K
  8_HIDAJ	_CRSR 9)
&	F1
  GPG 02
 $C %DtR6E p'FCC020pyF21pB1t#209G2Y2% 23 4 5 r 7"3([8   
,[8129A3[
 BC	5
[1 DAEFV30Q 1 2W33 34H35
7@g[G36!7"38'5 9AX3BQ CV`
3D EAFPZk40Q 1 42A06 4` 4@`45Q 6 7 8A9A0 @BqCzDE  @F M@,51
E!P`pua42a}aiapa ib{{ab[C@102E'
_C _ADR
 [&   ~n_STAi `	3p
45`56
T
7C[)56tq}r 5 D070 857Uo57Er2@t58& @? < }A@#59 [#PAKu5BeD`p` p`bt57e Ze` ap dpy40cCdc
{at
 b`zdx5C!{bbtd
q6puP@2dcrdZ58` dz?a
aa{
N `afuff aOdu7`['A
2Ja
EL

  BGqv
EDw `xH d2?Oy '&}} 3[A B60pibpkdrd
eϢdA
d hb @brb

bhbU1  2m3Cj`a61SD 2K661crc63BbN04!warj5Ea%b ]b][@]
]
buq]atob
bP c^ya%
`bac c`/$65S SK]Z5E
f61 }63c)626P=aacq`\66@1E~_Sy30p 4D
evL67U< W

X6X @4[ p9 [A%@ 
"@6B
K6B>a@{^.Qh2BACDDF@[gB:H 
E
`
[6EFе70jQ 1 2^73aAW7AW76T77AG7Pq 9} pg7A @!^7C!^7E F q80F#81 H82 l83O

d13842j85 
<[=   @`687 8qf892@ f8B[ 8CQDp8E`
[0 F	 MA90P
aT9`	  92T93
qv94$
94596R 
!
pW9X@397 g0~98gqx9A
[! BA9CQ 9E FG`A0[#\_GL_Rbp
`{ʔP[!
dv`J`Q9D69E{h jp
p
HrА"ǐaP9FbqV[Jp	rya
c}cbaa0A1 (8` 3A2x0 A3Bhiq`y`j0OA4
yh1Ы7E: \p3 D+Ba(80V1(@pwA5!ikp@"m7APFbA
i9DF17BO&$r8C}j80[+GG6C@:*BA7
@
[+  A8VA9Q AA$AC06D C>0AE
A`9`C
	^   z{` `za 0 
bw
t
	rab.C
 101
a )*ۤT{@rv"OL&F
pI6'B`B0
y
rw iPH2AB`Da{P ` ?
p{z1O wip{a` rb~qAFb yC11	_9`pBw
h nc }r    AA3
ccFB2
7l
 B3 SB4 pBt e {ky
 B3ee} `e Aj
4a{g`ц xq5@p #b}e
eˡ/p !	e e$}`@dAyA4{k
 	``;}qA
 ЈAA y!-Ap?d1p68d ^pA8"9 9e@{B6q0fB`7 D dyce@
QTѢB8hif"f
j
7@
Eb~dB	!ba'c@z!Doby
PMTU6CTHPCI^Bb(p`Ab	s@bB/cnpyacaABw'C`C~De  dBߤb[FB9DŅGGGGD DB6 7#BB
Ĭ@BBBQBD-_PSW%12ڡB`k (!`AD[(0@E֡ F C0c	C1uVm	V o	o	o	o	o	o	i	Rc	po	o	o	 o	o	o	 t.ҙo	o	o	o	o	o	$N!T%[M 5c#x`0833bý
o[@PCBO /@CC
P
[ہ5   CD K ECFвD`OлD1  0D2pD3z3D @~  PD5OT 9 62oQ
 U0D=:
c`7
 d 8 0D9DAA!D$*/D(D//*/D 'D//Pf!e!(. G!G!@($3( N #F(FX//M E0@ #F   //A eA !A N A GA "A  "c0EV/6BE2g0E2//*.3`03'3//@a0%1a0%1a0n0 a0G1a0G1a0@1BEtJ  JHE5	E6	
#  y  Eh`и``
`p`aspa!E60'E9	@	V`Q	``EA` :a'#B	 p$qCq С	A`v[ODPHIDA_UID
`{|E9^^06F!_DISEAx)_SRSEBh_CRS5Wa70r)H$+b1 r)4f;c!2r)`C EDM 	h13r)@ U[(iA 4r)$`k0jQ(5 r)3IFp{8k6@r)71>8B[U!a42[F21F3
r 4
 <5 [#"GP9uZ[@KF26Iv1(W 8E,C054|zF8
,Ѿ 0F9 A
LAB _S3D
p 4p PkFCؠ}(FD
 h246 `U 5XIEc7CZKFF
048`
{i}`h`?{`h@48{i  {@ 5$ q\._SB_C100tB~ o._DO{Sq	4
` a![^ 1bb ha[Â7ɠkDC^YFC
 G E SSaF
h3À˚rRcp*r&R%$C 

 
h06E0FD	8hfp
` {\/0{02<98
PҐt1`0D W Q   P Chi82`
hA@ \\n8\/	F1 YF5 @E6|o6HI"7
 i 74hj	 5hijkCq8c.5[0h92s 1 0p
Л93r8F2! F)9
^/p´0kl0^IRdN	_GPE	Ó
pOI
Gb bGf f y F10AF10mBF10 #0DE

p1F@111`
 2/_REG(pip015
 a	ia113[J  @@@0140ް15p #  6!7)8A9ArB 11DoE F20+21Q 2 3s 4b2[52678 p9ABQCDE\A130Q 1R33334^5 6s 7@,383-AB CA3EF064q4Vq42 3A4045Q 
474 Q4A_INI U4B qBq14DG[  I E @F:C150	wh
@axa
d?b`t
@`@QP
a
 @}a
a
y`\}`a!@81AZ Aazw`
d`xr`
  
@bauaaF52
q 3s 4
Q &6+57 9
1-5B2C
Unknown 
NiMH 
LiIon N dPpupuY>0
  a@tgq0Aw/1(`0AQM5G5
a
D+0F7DAyPS56@`	ذ9qǅ}ha{{a
/54y}Q952!
 
0[QQt!3!3D15]PU7p A7"E	`bBp
fP?{`{@I	F
[)h`pXD
csc
  dzir`a[)absdb1/2J*(ccCC160	hg3
}qEg
BlU25B/{`g  1`2hC N 1FQ23v0a3h - 126 w"9axra
c 
dcbpb:b,Ar	38`fa 9a$(`a-q-2g2t$@IX64
I+Ep
 vW 	i'p
q:/39"29cBhcD c600 f{P`p{``EFA;  9H2c cp e_eexcpe'cpci3%46s 5qp
g5IZD520BAjC-P+6F@+1yN)V1D,  
t>/
>b2`(1v1pz!o
 5 Wo%)!3((*ABCBH)P1se0(a5h.EC0	A547ata
Ƒd
bczcRhv 

D

6Aaah34
@ ra8P paupaHT9bc6hb6E40>U772@EERBEF>00 [
P~67@QA
HP   aл3A
Sp
SIMPLO`ySMp
MOTOROLA a`wU8!~68
p
 
iq0(_Q039z4B"pB4u0Fbp#p
apvbba:lQTZ69Q] A['coTZ3_J
6mu
JyD
a6Bo
PRe01A 
 M1_2 N8s#P 
]C
_D#9`nO
11691_C316

,
{` (i28Ci$Q [F@}E
6F
N C1771 F7`71072 pq |P!6 FU78A9As7Bs 7D77Fa80
[  A8182u8Q84ak85887b 88B85aUVa90A
^85M 888Ba` 78`
J9>k 089Oh8B8C rA Q!cذlBbaAcϡ3gDbOaA
MCBFc18 ya
 Rd
b
 `bdpdSpc
 c
@c
98CBШ8A88`kaɕa
v2C albab`b
vbDb777Bp`E7A9qp!D#!d9zj
!%ECW89=!E#'6qbp
b	ay  bbӫ8FQ
824Ҫ5`90
0726" 46"5
q1
{C039
`{  ia` `P8Ahp!
`!zqK92	1$AB0$b cU09abcA'K 93 p^^04cIX9w5LA
96

Gy 198 A	9/  99h@d796Pn@[Op9AF_C  _DDN
COM1a9B9C6
30U"    8oy `NS p9CD_STA 3{\/ f002e3C_098
`-90
`1
-`p	IS_RMV
+ dk038ps9Q
F_SRSXbh
aD7DBBh)9B@
_C
>z9

a `e bcq$OxA[QT9E   
CF
_ON_A"0&_OFF q!PR0E[Ll9F#jMz$"C
_!G 0" *
7"~3.&[%p= ""B K,  CA0! !&}A1r=^<!`t4APv9Da;!Ah!
zI A *"0"	pA5
r
;@?#pA0s 5$S1$$$30%2\h[46m&i&!P'`& $A6[C: 7mA8p?  WA9
." ZE!fSR@ArAAAULH
1 Gxx&xx"q)x)xx`OF Po r ^r_ _u\}VcV@NAAT0 s%SSPHqAESASN?3?303?LTaX3xTn*AGm3 *o3tUb uAB44PAC4?X!4X550Z5`z|Х{xp
,, ` ACPr885_AD=_75_?_a =_PEX:D)AE p\/@u|a(`{vz  1tP}Ar`.d C1BayB` 2 ;0[3B24BDГp hq0j QBRB2AB4!P*5&{`h`h [ۂEB6\#_UIu# 1B75A_PS0pB3@3 
  K"@RmC β1B8y "
4렭 apB81Ǥ  paJC pF	 z`
a
B8BcfbB9 BA7BBQ `v2AB9Gp!
$1BD`a 0#BF  C!C$C2 
G``?Gpp +eC0k
q 1`EgCv%EiBE!C2[%P3#¢ "  y#q4`w@ @ "O[Au1U
 
 P
     *"5žtBa_ a !-,A
0 p Gr r " 7v` `0_Gd d"[IC8
" 0b[PMCAQEC9у  C9CAP9O.    @W[+ B@
   
 
@fOC067C5ADR   'CD
D
[)CDE еINI	pfCsAgD00PRW
	
[NDL@D21W=7H/7j[CB@D2D@[\GPE_L1A`aaD
C0D:	PPI
@A0
`*?
	Q p*_EJD Bi.P CQ BEQ -FD5Q 6@SD@$>  "qaS
:CD3
@6t
p*S3@p 4AuOְC2N<

[A

E (A_Dd#E#	pB#
		C+						F7C0B`
+ 2A#C E_GTM p
* `d`3  E4 .E5p E'r BX{pPQr4
mEЈE4{F0MhhhFi  `p
w6qa:` A` bwb
bw`
c ib ac  rb rc u`A
2!abq6%
2cE7bc0oE2:6q !{ xz0I([E2 F &uE	088P`o0iq7	
# Y1 8OD9ODAOEmDOEEOEFL`H\_PICph\/ND6M T MqK6E

P'   p
 0
CJ #0$ 
 G?C

 
	
$Q a				 		!	A	 b052# "cD
%6p,!1|!G!EH  J@ !ޱG .	@!A0E T63@	_F
~R  RVd
d
Primary 
A   
LIon 
Hewlett-Packard EyTraveloka	2O@ 1-5[L60	00Q60h`/``%
 
e
" 
 
qZ6C3hg 4A+10PEBaHaudB4G%`2t6
 c_^{5E 
_BI YXap ST 4rCL\][˂G676Ƞ)CocbrJ`6ӱ
ACPI3	G	R/005`D55 $Ja# l&]PR0  81`쬓`[Sw֑:@
LImD{_80["`AHP_Tab4PC_Buttons6
	/15?@SX"pXNќ7jqF0  F1 
 23֑0k0k`qh`piaFa
 ?ЏF1я
 a{`
 ks }a
a]apk
 kЋ3 2@4/ 0F,F0  *F4zo

 ` `2W`@hp}
yj  >qb1h)gh`@	4` ibppbasabcpcau`a`5BF6! Pa a7J/8`9 FA BFCC	39  p
`

S P  r
` a0D ECee[wre
W 
FQF@2BpFAIL qM9?SECUpdAA1A1Rp^C200bwr1}2R3]j4-3`;FCP
cp 5cpbB
#A3B
{  QF6t
-A	
6B718U9%A	uB4B  u%a%SIMWa620C&O7 b;2J^T7`̆C0q  ``#PGASSA'1=7$aOAC`y`~4Cap	!o a14E>H ES?;	2CC+ap^bb`a ՃB b ub\#p`920t _WDG?
<4_c,E=DAAyB{M4C~ !f )ABxWMAA~xF8ij=10tAEp{ 6
TvHQ%{h
`3{Ez44S[ `5`o047}54
17  0I 8U Aq2	
0l97T"& 1#q,'pd'a'Mԡ<Ow68a{a
}z` NC`)g a"	I40*	aAnKO1B gCph4A-
r.0ѓ2AI!h16h	 _WEDs**WQABNߩFOM`'  `8:  DS }TK B"!,8.@YP!O : SAND L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@6?QV&X)xx52
9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =D&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`Q"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐĿ
LذWyWr24	;wpQvY#{|exuH#D#o0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'{,03[F

[  10 \C1B7
 +518_INI  {[1 JP00[@11l[#\_GL_yh`04Bpipj҂k F\_C0F1hFpl['['}`!12
!h  3Q45 b6 C2215gph5U4445` p{zhX Q7h7	k3 6 2 -A6o	T
6B57	P[ED22E672oF30 12 3@w34 ]5 rv9`"36035
[ 7@(23829 h
39AA B `UyA
	`rh``vF3C!37c`dpĢJac
p`{rd b}y    baya
a0apaňc1eraye
	 evepe30c ucdcM
DrCcpc  bpbgC	bdp apbe)ecpe ffg
fape`pfafgvdueA`b30` gT`$b pg18agg7ag^dMpE,05A , p0`c`ʀbq1 2`_ u`py 1 jC B  D "h 30h H
bhc `r Dcada
e,33-adft`f	ru>'adRuc2ftd gpr:`4bA m7@.F F34FQ&-9%DE`Q&3aqD34
LBC060pibhbC240p0<40rb
jD1
j?412c22"bwF3 w6
arS9abpb.0+bϢab`babuaaP `bua/_CRuS!4Q19`vs1-43`T}`ZSTA t
`}``569XD!

	        y p344 ([Kd245mHH
 e46F
RGGP   @    s3	z0	  1	[Ci48}Q kk194F
rG G$ $ GN N 
P P Gc c Ge e g gt t   >  #p
 A-\/[	BCa


W!3p
`q ^^.C16E3\_S0?_
 !  3    4  5   M\_PTSph%_37Hh
 Lhk
}	0pz15eˠ`Zb1E8 BA {WAK } @3092?0109A&10C@pbR 115a	``6qTZw4A~ TZ1_
 2 15
a(< 005bE

OrFacbcc:c6B
[APRA0;1 
 b556A6 1
Y `BA-CN#C2N Ll4,2"0 /E\FBG,
@
|
0Q 
ob [PJqOC4PQPE0HeF
050
q  Q0\M455=6 72W a8С@B9pW16Aw
59
1({!h s?# >4Eil25A
piayh
p
y"?1F$
`Hpa_gn
DB
hl5 D`pi``
p
A#i p`OrB5Cp`phahщ57ikr@
Q! A#~Di ` aP6VQE
P iQ30;opKALA(!p
   t1t
axa

`b@LRA0

bts
 2
<Q


	/s
!
P'OL00E_	FU@&Yd^d+Q[p{43 -{b
 t bbwb

araMpLabb1ReT17fМ)ar&5h 1Q'6' b#y
h`:I	{;b  @pui*h aBw`%  1;54<`/6s AAQ@IF`hm3_
b D*M5F
40-h `t`)`x`f3f={tff 1tqB.cbbs.b&8!9bbFiv

ep
d
M& d&5d26eiI~( =,D	B*\aFa[mBN60¸X
9_?ON_ XW# CqLRcR_OFFSB:D1M
OR]OjCH
u2
OcOp
3
OiOcw
[64 0 460["@DH1C6ǆ273[H^q_AL4 91PAL2	AL3C
7_GAC0%""1&DB2Fb3fPSV@SLѾDGu68ÁnBG3fB([an4CHw4DpF4Ep(4Fp
$Y50SQP4F_TSP
dp TCRTs0TMPx8p,[GA89PS6A

,"
3XМ/$@\_GP26BO
_L00	 q2`@TI{` P{`{
a Upb` 0ucB3a aazBGK 1 I{v*67p9 @ICBC0D^c}CCE/["
d,B`fa@3z4F 9 HOH0*_6o3 S/oiB67IC_#DE_H_L17 182?`}P7@24:98
Ds11D1@ RpEA5 Fk:Y{4
P`C;P耢 1F00Y)EF5 =8?MfG06E 0D `EC{ ?L98`Ko9
DunJC ~ `A?


%&00wc1
p D r #!""X8?0ˠ!F^6a}`0SO`)Z72EW@	+Fe>9`Ld'à.p"""<`
`
v#Le
*	 q h`?n097bc@5fPQΠo+{aP&mc{bQ7Ke3
AcEdD}Co	7OfH/C 
œ&6a~ EMG?P4SSDT{q@rHP  HPQPpc@s  MSFT L4F@	1 3      #__T	_w 
_	OC270wj
ara
[aV34a1P]271ijq 2  Ah02Ed22F 273_274!3$'1 J7303
 yjFA2eB3Ej95
D0`bb`h6Fa bub P)21Ru2+16Ph 7RE2Ar5yB76,_
b+1 y U  V!7'*[A8Ж_PDC{hp178PCT 
1p77q 6	_PPC @1S7@K787Y 7NLPR7y1_EJ0nD2@AQq   ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ  _     	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n           VIDEU[0  @ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`. aP b  cH dP e  fb gP h  i|o jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0 
b3 _DATA_BLOCK x  
`3412Intel(r)915GM/910ML` 5MS а Accelerated S
Build Number: q Deva	09/27/2004  Q01:16
DECOMPILATION OR DISASSEMBLY PROH?IBITEDCopyright (C) 0-`3 2`rp. All RAs ReservsedPa@  g  $	

 ! 	TV׾D "LFPiz(      | 02468:<@BDFHJLPRTVXZ\ 9{   (  8  [0 _ @ Ā ( e/ `ࣀ _   ӕ@DԄHLB  p_ ! !Ԓ        0܂ 17 3		 ޽ @>   H `  |  `] =  # 1" $ (
 5 V}          A !  R`SI-1362-!Up _2  @i7 <cU
 x 
	 Z (?-  	Q    e	>N Ia(  QVSC dS?4O  
`	 w7 c<  \* 
ZcTZcu$M
 23 ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*!P @ X  ' 0hPR	 `"c6 X  1X (a$n!7C	d @A &066\ <0* Q 0@0p
wxx Q@ϯ(/x?Q&@X!k @H?@0b2@@
|/d  P 
00 d  @
%,@`@	Ƃ
)(<p#%%%
 PB. $< 00C"2/<@PpQX 82

,{ +a ?L  Xo o o o o ,4 Z  UfPfVfWfVtRu.t
fF䠆   w FF\  耹*FXF <uY=?}Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^~pZffq_f^f !;F}Nn߈^f~of~`.sf~ t$:V^:nQ:ND~tPfFtF;u )  
f~v ø t2:~sPv0v^*fދfV2fX]P!Rf3ffZfXþ   
@|   @M` +sw.2 t 
؃p.	 
 
f.aИVW6 tM r/u*B
 tVff" v f..L^߲ .pff^3_^28ev t&B1t1U
PSRV<v
W_2G$fWb  < t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufRe.u5 P.f
fZ
fVPf!0% `= `Xf^2dfP r  mf D 耈f ;r;r.T" 6f"2P#ESfQ@tfY-ffXz@G=-fS fYf.; r$ )[fVlu跦8u p+^`@H b,VW7u%f-2f1/O%1f^b,t$5&-rp%ufÂ 1fQf"s UP/ffXu
RJ8Zsfn5b1J7uf-qB7c1q9J1, >1AJQ9[Q,tt22<6	<"tR7Zr.
 @) j7Zs b	4.#_tu
 `, *az@f ` }uVu0f'}0 0"P.0nroooopept<wwyzi{
||}{!' < .  @[ &a[(8)8U!a*d!e!f%g<#h?!$P!fWU.64eހs u.Hw.p p=Ou
uοFa=_ i %)6I=OuFt=Ot=_t
=OtPfIXOuF
_u pt n)]XZ-.<t.:u.T!_F`.a   .aPw2143  p;%(VFE ^(p 
Oq  @=,. f@-"-u
/-F t߰ f#00.fB,fP*# I"7 n.tJf4%90h,fF$ 6+6u 2c0Sf[ u	uN I$Vp !"%"P""""	#
# Ǿ!%A!-(u, xR-̿rkPPt(0.u\
?
^qP9 2ۄt_q  P'1\wSfr/w*]'u{+`	,s`!+
"	Trq&s
!bt&S
[t t fM,ru%B_		l?s
B0(f"Q(*fR*P$8X$@
؉b1	f`2e(qQ	ؾf#.8u@rin#uc]3ZR,pU
 )  [_+a   ufj) + ff_UQA3+M*޴Y+dZ+4+!cuw'+pzkr{`q
W+faPSQmQ	2;YtlQ
 srYTZAQDtp^Ű@t@uY*Y_"utH/r.D$tt	Æf^ZY[~Sv w/u#
 u3 /-"ba@   0@1ʊ7 
[`}.tN0˶V uf`.VPQX	.r0 k%.8tYX^r
gf&⢊f_C	f`	s	qt!рtSR0Z[633xu0KbP<='$ {?p)|$'[ ?^X!&+&U$t Whw.QYS.L2.pe
QPfY
8Xt+$YI~Ц+.W tG#t
2tPS#[;¿Xu)&t0uq

uPSϊߋYSQY[r[o/(cQRvPu8ك zALtS=[rt  p#M2,,`U 0#;˯ qF
1Gs 0
p ѰRB	&Ыx$fS :8!ux'%PQ`UL%<vYX%r2%P PO`w% #`vX%	#XTw#@#G.&6
?";a`mzQ4
81w?0YGpoò_&@?XrPu(s#}0 ѩz Wf_ V.4.tf^0^0ѱ m0/D! fs'$t#f%@ }8ue? u̲t,rE,s@t9@ ̀C~ &Zf*ɿ3fK
f^	 f0ڸQ4,ry0S̃>|c ?e%YE# t3!iakʺT%V1`QXw

SX$w
؊"3Ҩ 8
?.[ *o+++;,_,p,,,	,*R{h"u\uS"u@$#P"BtPPP!(#fSf[A!#Xa0tX"dab!$u  Q.20;YrWot  !fP$ff ff3g&fGy#f^%T2#QB #Yӯ|8@!8##p ѱ2U z 0 c r	g Uw	t .:\s^\0W*.$tBuIP⢛  ^Xu,.8 #.t/s!P~//XSB#[dĀt
 Sg+r!0ÿ
"ff" H'`k&r7
f^&E$x $ 4.{
f+أ20t2p/fPWvPJ	&!QPYP4,̠4!2P`V CΦ! T !F C9%$t`u@uUtQ!2I's#f w<fQ%yxfYvt&w_u!C;Ht Q>..Ͷ.G$ r
Q2Srs[Yr
rL rQjY߂\PPtª<v>rs	 hPfWjrZ, . u.Mpm2ft!"SQP2~Y8[r2QA÷sYf_XSWJ_H_[drFsr?
D
t+8t$P`ՊX8udѡȱ`ʰ8px3
a >i	dA0`@4C&f ¢I]Еu{1
&&Ks"*f4pp끃 tހ hut
ъ-4Pb$
u$XB	X[	3`1
>J~U^ FVv
nB]FPW s&!Gt8uXuD>L t=+pMs4
й @B8e tC:er3vD6e3UX?&2VS2.6e3RF8r *[Y22@]F]W.>>et>Àt&}&t2,(-)*.)` O4eÿ~<v<t
ц<vєÜȫP 3bN<w<?t0f`u2e*s
2&J&P &L&ģ`&&pK L`  a3 43333
33344454
sIuM@B? &<w
2RtE>
tH&38pl
и 7a3۱R u tF@r!tu!WV ^_ 
?GW _uGG zd a `Zj	 QIڃ. `(.[IXuπð/؁YP%@@t	pTF}F!Gpu Y÷sssQS&G&w&_t0B JKu[pr&OP0 &
tuȋcPQV2
$̊
FY^Y0_ s0&G
Pp&?W&w@
p߀?ZotHH,2۰>tr:osr&9p,uh_ 30p?o1 

$0_s'h
 4G__.>`;`;^9ëp 0&$F@e;	@su Ǻ ܺ@+o߹  4t<v<tP&X@F20s @&f` P1ftJf &&	7
aTugQc$_<0tqZt2- ku "Eo aE1^X qqyߊѾ7P.8u*f{0 @)z"}aq`A(  `	s63ftft\eU} t$D ut' $dc4 AǀX$1>&0 )1VWS t߃#`IF[_^ rZf fV 2~Ê߹  r:<w40r*%uf21Sf[fPDV@gs05`t*Q.LYt  u
"8ӻu^ZSQ"s	.So[ Yrߊ̀vXq̡PSf #brcŀtʀ tO<ЛrCQoYr?I`PPf;Xr-u f.;vuqw	 `r_aYf@MRVSӆit|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ0e.DYXuP!
~[` 0"`Rf
2f&ffȐX&e&} ]@.Dufѯp0 tR3Zt	pp   t ϐHK%Q Ms, f+VmwP^ 	X^[*0
 ^94S
9B^HQKtE&gE`JE aJ ^oxйLHKDA&< <  I m  @   	 -`pPPд 1-l#PSPS +׀ `3 s<s at< rj7I<S<.97H<r[._{E#[t/u..s߃l6&=	r	;v1SSߊWм|@*t
 #u[[_[ø RvvvZvxЖnQrg  0K YPVPV<v	w rL^ r WffP@X2A5?$_@lsPDl

f*2L<w 7PEXffsfB fߋ^
`p
f?3f;w<<R i.8ab.<usv@C pQ2<v+<t'<v! tƐtN"DS_polQf
QPX@. p
.&R Qs] P;sf0  w| YrVgI^w
PZfXuEu$Pu
$0VW#sB d @&|&\CrwP#
Xu Ѻ	 Z0
 u^C7
f ts    	

#
Fr=.t 35W`@`8u
X@P@_2.@S6&[X<`r<qwRZP$<pw s2S#(S[2ۀvESp%RffZ{fp 
[pmP =.c?fY.1snfARm	Ca@?0xa,0Rb#MQN[sSuNqz5u߸ `2,"y:.F+o9sau\Uص÷ zMي3
x`@!2 g80"
Xr+5}r 45uUǋz% 2BVP3Q^5 M3
N] `WP1PS ^@0[HF`ۋY.6~VWRr;~s8 ~JuZ_^N t0S[_`\w
Đ2110CVz 
  j2r@p  _2Ph@ & PX60"2P	X uA0`2RߋZ !Pç[ ؆! PX PҪ C"	ƀu̀_<$
2`aesUDtMrEWfV.4.tc.TP&} _w(&
&Ut.9
u.9UuA>fQs^r
\/ r"DfPP@XÀPˀ  V"E`fa[f.Vf&f!u
$'tPAf%`b:ahq`5j#t
^tXqtftY
0t'u-`C1ȵqZڀ \`^PreFc4ܩPdpЯ @pS P P ?J	Ӣ&/	&  u"A#P
	tAfXf^r s  r߀tХ̀_u
_ma<XQVW_^YS. 	sK;pM`0a@s  Cy B jVS3۬
t
<a|<zw$C`^#V    A 72PP2@it.:u23PV .^f.<Inteu   	  
 	 RaPa C` PB BA B;rXa~s  .oH@uSb@ uP4[.oHBar+ 6  ;`&  f}8f%f;19RC}`VPMp 3f.f
`+؀nҖfAJ\ Iu	fSff@ܰP/]sPa 3{WI pWI^YRA.WI0PRf6 0.df 
00.DPR.ff.V` I .FFMȋF 
tJHa?  ׉FACFARR A䀀V@`*
  )]!9p#~1_$<AP-<uX.>Jt  +.J< P.tfcARtsZf²Ĳeg|ۀt5r	?Hr2dR]ۀt¥ `.ȃ v(.жuc.<s.tFbf u.t-.5߀ut."pe1
fQ̀Y   @FV *Os`5P@DXe<DG$hZ0kt	jf'`p- _P4=裂DHPbCCot!N`	DM 4Qbb< PrQQbU vhдS+	3TQgQӡs

rRR
RZR   $ bPBB쿊CZQ
Q QQ0_P<fƊ_$f==fffX°"t
p tf0ZYQ Q `  	Qϱq` S{
 tPP첺P q;4P U'$@``` ЖS S2  1dQ$d[$P50aɀS
S` 
  Rf`
 P`P @8ftsrg Z UdPҩ ` ğaܟPS""
[XȲ"Cc^p!%!ff6QPAQ﵀`  PA%
  wfS%f%PŀrЌ}P tn%2'ff)f#ff#fSahfA(-S-('RA'@u_ fP('fXӋ##[u9X.=          @     @QSr|wrwKH؂n1 V ;v7 xֿZ+q+±2\\sRfZf+`faf GU`F FFP.8\uE.T;u2	u	Ff$ f"uPfVe.  ^0!

uC⦾DD?  + оA<u /f^a]|s(1F3Pprif^@=wA@_`SRWVPtCO	r<.|t4.Et"0t.\Q" YsÀtǀP^_Z`UЎ Qs"0f&;u Eu&M]p ArA	ȋ+;r1;r-fQ&
 8;nfYuaSR sZ[.6P.8u.| P.;6PrSRVWr;u6wb	M1 	_;^ZV3St Uu2
^`WV_rGf^u4t@u&u!SQRP XZY[s`^_X@0`Q  qQ{,U .8utPYf$ADDfIN30 (>Et_'WuA &Ѕ1/f^T4r$/<t<R?r~f&?E   3@zG$<<<f RVr
.|!!^`Ȏ؎ `# t8.D;..\f^t@ 

sV! 
r.PP

]aÿ`'r~yRӊP` X Zun1tQtLM4s@Ass45s
7=v<?Wf_JJ^uS6BЅЅ<}P't0BN-C.
t<2,!+t.
,G<|`$QET:< PW4 ht@YV]6ϋ6`1PVH9""bZl@#u;ndWfA6fQ6PrUwP2B#u[< mk EZXYv]_֊|PǿXt	+t8 o  d %-|Ph%pM  := f^Vr+;t"s	Eu
< u	f3@h3[pt#|=p@fpQwJSAH[8 rQZYs
R sf=RDZtr$|qC}Kr. u)"XбbtkLUsqPSQfVQ  rٰ6.&:
Qyf tFf^Ya`s%(T?sHQwf ݽ3꾝0QѓsxuK= w4 w.HKPPιaUZ;v| Q+tN z[[[[ twǾT[`P÷ p  wf~%L t@ffRZXQ`;v
t
 
 
" p0ƒ΀wWRZsNp/p  .:?u0.>`(bJ pZu.n2`Ґ0 
30;} .	fv?fQ
P pZ
@JZyyۑHp	iAZ3f
 ?Q1VWfǀvf`K1ZP	-ހrs$DV)`) ! 	
PSfVPMrA!$@uc] .@^PPPPPPPP P!P$P%PSwf3]˶a0!{Ct3`
ނ(ZAt2 2h2ۨ#?qfq 8 !)} s@PWvijRfZP[tuU  updsEjtz Rs3 @	<wPpXs uPF !Gb'_1G G
t$ 1C ]#;tt|AqjFGo R*N_@uNQIM_____``@sþ_-FF3F۴ 6.:註Q0Y 024/sR Zk>B p!K2^@7 V```aaFaaa
4`~2C<vSƋ[tq&fa/ q'@'fk^@T#t,x
<pŰgĊ~,+ ,2s2Su; xx |s Z þ/.0p Ϳ ȉNcfCp7: c0Y ;f P(fu _t7f<) i!ff f4Af% ;WF  Àu#\"dnR \gQ-00
Őh*ab_bpbae@ Wf_fVBE/fFP﫰zA
@C1r0f« f ff+À fG
f p	4
zqf# $0-p8u2uA\4 c/ctr ޾ 2SE4
/Zs
 u6@$ .(vӀ۶vu
RSpڷQ[Zb[S 3ɶ6u6F #Q5$d"i@ PQRVtHc.? pVP<	觧r`9f t4W_s)v!f&y=&} u &G
aÝ`SasSRZ q{3ҋʰgrU]deddF5
s;pw S.)d[,JP@t  5r=$ ? r@o{:Hp?7
cr" ^N2$1`8t\tCf	gtwAf@btir߰a< tA@CӴ1a[PMIDn_    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS  Cor;poion#~ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq  5  0  2   fg;iiiii7j<k	kn/daM`bf .<t.:utOFûE2&+]OuMWPESAP Ÿ@efefP@fXfQv4F@;t/aQ@wetf s tfffYfS_uV f&E-  ߃aXðQ .V@Ύ޾eJ  @e suVoO$ G֨_  u к a^@ @`^֠ ^_n_ի o p﫸pՊwfۊơ ܀rf
P rf@@f2tm?QRf`af3ZY 
LՁ
Պu9
mr;g$:Iͤr	 {@p`O%nN}ӏͰLrf
VÀ>Ivm@wdtYw@t$;wR?$;v@fc1q t@~`3xcjjcjjjjkRۃ`܀  )j.$fat*R`@	蠟ZP	XfN Hߓ ~


F wf f` ta f{I | B0a~"_ $y+Ca6ӀtE#>âw1gia% _ftԛt)vGwAºBffP S ǯBB젡T 
RVIӋ_ݺ P!=ݰvp,8 t3
9P%ҀsZ2fQfBQP
fT0fYR CIR[:Tt` uZP̃XVD u.fD
f=8w"Њf`IR VfZ	[D^ÿf0.E.e! *$P	P0
 +$pE0	f .4e{ fڐ	߀8u{$?
!32IBߨu	pVr
.
 @?$
ÑߨaV.|^쁓"2f^PP>} t"tt+t.D/@t au V^r
ޠ
2^< <#t2 <"t
+ <!t  Q`u7
0Q2ъȀ
ufPqu;pusY@>݋иO O sOYˀ u3u"*D\讬u> &p`uu t kudu^sY8s
tQG8s8s8t3 t-0vv&8swˊ
r*ˋc
qP8bu J NذrPÆ2/ۋ<q`R
tB@a1p@2$b&LN @<v0	r	e狕P鑘쿉F ^Sr{Bgtw%gvk&J`֋&FЋsBuՃdr' wP酓zu$0<0 t**F 
t*02P ؊֡	a>`w@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQWw_YuCW B~~	2@
2@PP *ڀ n@
  toʋ?XZQ2	/ ++(+t؋X:  + 
"a݁{BtG:#sNOFGuxsOG$	B y*2n10>K , !?+ 'k'ȋP&1u'D`'$4$p&z  %2C3, B"pCR S w؎
]ȑ'Jur&^=ց3Ju=>wP67)4&	55Fb1QZ6c5 XqJrv
t-r^ <G!M`sw r
&XtR٭נQqQ0QP2GtB2E tO FƮS ƯPЎȎ~ 0u.&>| t
$𻋄c-0@ȱ\/,ppRC&PD+(2 _6t
0su@a#Pb0 2&<u2ۭypWËUƋ0t
Ju]+
]Q wLwPaz x͋Y$r!v$$:ˀu　?600Ql$$s$guz
o׫3*48*0*^OFH,G}`/$ְ /Ë?*) j
y$6| 62 u>
xĪm?í&0  &0%Ê)"r>^!Mu0+,GY3,+K'B2Nğu9@ZZVWѤ ts
҃_^GMu۸ ]3@ø&C$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>fo߀  
T fR@
 F$
 r7uɊ PW.>eu>&}JPbQǪ_XwLԸoǀr#Yts-" (&"%
Ī&#Z
rɀ\sي
u7!~y@s
x`ALuͿ1x  w 
pd!! esX @
ff

W,	0	ϳ2,"yN6@	@	ʸ (⨀Pbr$$pt<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [Dorp^ʊ3?ɸa~0
uVЊdЊPSQRaPaDnXaZWY[X|*v
܀ՈF0F02<}:}C}\}}}	}}}}}~~~&~G~<s<trtt|0ù 2&<F 4w t3&ee!3<
EQ.~T  @@5 ß`P&0y OuËÀ8 0
1>ǀh  fnNËEϊĊNuÿq 2Fó π?} Q ` K#Nu	f&K͉DSRP$?.&\~RP ^ `~[[c   XʊZ[PΊXPvXP) ~~~~l|8 8| <<]<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DD8[p
~~~  Q  	 0``0A$BB$@

V` l$Q  ll  l ||f6j 8L8xz 0 0```0 @ y <<fG00'0  || 8x~ |p <| <l |ƀD |  ~H  a00!2  
x | ff|7ff    bhxhb `·~ @< p flxlf bf  ΰ|`Ư||~Z<ql)Ƃ  88l#<2 xp``x  x -/0 U x|v `` p 60x00x3v|x`lvn 8 1̀b /P7ܢ-T| p| v | q$4-4 /ll3
6|p&0d; (1B 00 # vp?&qp|8B
|!f!&88 `x`:|~~ ~΀)".a0%||`l``p9PH~ w?p

6ff+ 8<}448ll8 6{0` BU6F{ \E|1S6ll6W~` l  "# {U# wA 4T d  6 dP [ 5 NOqP_U1UQ2dt770?dK?0aa66R9j a	
Q R>     tv Q@bC8~llHO3O rg8 s 8||`rTXl( <"CBfa||"|DPh"  l~`l~ Y%r[&; p0jo
G<8p(5ly:}Xl<p&PlN~0QEP< cSld$DtUtZ3ZNTvTu W32xQ|2)
xpbn|ll[|}20ư a4!֕BP{ |`Sl8>70k B @sV &
񉅇R`g#Z8|||8鋊;ff""AR	+p+q`llҒMv	܃od  $5)/ԑ#| 1DVsr  @Pb
1upbᔳ 2ES67
  ц%25R$FPB@S9byA1 `	Q$(f  PC=' # 7%7@Pa "D"%
t@Ý
0l2`6$6~~$E47㠃#
l|8@s3OƆpb#<,00PcRr-0Lu;T 3'$D bZЦe  1d23]%@`aB=`_ ְr;b95Qp$R "ëBfӬ03*Pw~Ry Ap otmeۯk5̓Oh0xӰ`0HH0i ! ah tC[D 0fAxxAcl>j%Uڨ	%SQ#xFΤ W1hPr`xC0q C'7!1^ H(F/`1L!#<0[<\Qj0FespfS_dx0`ܶ=> lܬ>ҚdwD) ew) )ü ut  (Yǳx 7ȥWU> T 4˳ ^S̅d s͢Ͳ5Uc 	&
J TӄK$%҇`Kӧiso
̓@"bRt``0`&"bct "1آ1vetn v ||@<`p`v3 9 tt!K pܶܵ*$1R3Co0`
7| / %4 FU}' 27Whu -7tu #8] /䳔TJ}800% 7]i4&4Eb6 ‸ <Be aְ" 8Fdv D%Eu\fRU 閝\
 5cх ե0&C`e t% EWu % Em  'D~+NWB^ ]Ë
  1 
Met4 G= &tDftt0
"$d #$%e2 3401hK"r5B Vgv	! "f,`G'aw D 	8Fif. GeEt8Bm`lx@-Mo 
/on 	/Oi .Mm +Ok /Im`tܠk$5Fpctq =FTfv||6<] }RRfyѯHU<9ر p>| o` ,4@IXg v!"ť#$0v?ѤƢË5þц&) ~ð 	!S P   1 0 a.Ԝ&6| &>~ ÷
*r
t	2.ò`Ϲ  ~   ц~тє! w<
u&| ϲ 2.^FFF3ҹ `P樸` Ԩ ΨȨ X  * : aQYSظ s2t  [߸{u ic
>ctSÐ/    ^^ >I辙su
^ t 36ȢJ2 Lc&>Iu	B$P
	JX̀v`
p uH-ب <ĩ_tQ @ rw
2F.Ê.̀Nп$F $FF.q( ک _ZUoȨè<w$u 4$
p À0&&_WQ	_@Z<ow?1 A tSD[
*!&VUNq<w4#@tÂ u5Bcb?ȫFt#!)#
 `԰8 u{ 3ҴugĠtb(u]̊.-ŴQYR  
 8 t$8u
;(
=
28u2ɋZ aR23Z%t<vÊ>bSu
PRYNVQ~ċюF&<
vu^Ft&FVRU r̒,]Z:Jr92:6v/RS=b=P [
tZV t^^YuZO[
<t<t<
t<
tx@(` t
t$0<0tur ͉N`u6׆s%&2Ft0 u*ш)s&:s2& #   a     ? t"<(* II `ga!I<v}	.ǫ.﫪tI<tE2<t?<r<v7<	r
<v/<ov)W  WuCt	t`2êSPm@X[$t   ͡ъ$g`Ip
P4
ğ3RQ$2.>euZ&G&Gt R 
 &_Wt%
&;G 
 2    _ @    fPQV fVf.Da 4f^^YfX< !!ȭ14f3f^FFfPfSLqfa#fbff f Qf% ;ëu@[`PSQRQm+YZY[Q Ƞ@YbMfp/Pf.}.7/
CCRRt!Q̀YZ蓟7t&p
t&wG  x    b2
f X蚠=Q3&&Ϭ&I1f P tQ | fYÀVFF30^XtJ՞QF	 DYPRfW#0f "!fP   f3{迀   0K@P sg  ['u_ ^P
Dys-pCR*  CA	  
 f$ wq	y
`F0
!3
y1

f{[X@f_Z) QVV԰?^B*&5%&&&^0 &T@pRV0&$F@&F{誜  PX@F2ܜ q`^ZRDMZ@ h$Āu[Y27V蕛嫊Nu^D7QOC7R虛f<Z4QfV6qf^Y55`4h s4?t47t4\@̗4c464
åQqc22222222RV2B3۾2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              !!!!!! !!     #v1xx">Vz==8f=,=.=d@===H=z===y==BH=0== = ==
=v{f=Y=[=O2%>DU>.P>SQ0!2t$L-`}$Od   : ,ĪaAUc	PCP@P @ UqD"wΗX# ԙ0] 
gh2  ,h	PX^oߵƮ`. fȎ1)`.>f; lf3AHr(|$utD rq  m.6rӄPgTP r   r{Wށ{
 g !^f t-
f&9af&_ M f+W?. T&= tf&m)!_qffaðPfq EQ M y aR $fpf	u(ff(`m}p r} tܰUl pAw<f;%+"l r&;f&_HIBM
fHQf=ؗQ
 r2u&} s
PQS-[  <
QW 
 ftV`^tu{A_Y `VqeB ^
Dƣa&Eǣc\ ;v++\P{=;6as;>crڿqa .qǾ覎ñu6xPt'v %+	@Px N ð  t%u7m!Pfpۯ? @6 S衖[ 虖[ f $ADDIN30,ϺVͻ AIM3b0A  @ X@ Q Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Ef.>_ v `pݺb 0p8fX 2ZY๷2 о0sbuL.;w.;v
RWfVvTtOBf.G} u"Ұu0R j`ZR Zr
`
yf^_fZ fV$< v99fb #Vg}? s1 3LҸq_S fۭVѓ2П[S @t o3ɐRW칀t
_ZP9.$ W4Jv0_ `@n$<u<.\.r   PXfTA2f`1 #`Z`@.&<
UKs....@  "PO߳  5bOukRK6	~f.d..\= rw rL<&]fff.	\. .FG@ P	3@  .G$0<0u.afVf.t2A.Qf;P/uPd H0gZf/^[ ~Q2fuf؃ %	 ͫlqEd34UDpīĳcŝ
D	V  AY DDPU@DSDTY@ " HD|   G? 	  
@  $ 6 d_   IL  J ]B 	 @ , "	eJz ,?,Sg[ 00?	s  i,,


j6Kd@Xkl 
 
PÖ` q@Q@kQm v lC q \ l @AEq@k6
-2-3 A  ``_  3 dj 
=uz 
< FL "Z  L  "oV 
u
 ?E _S   
E 
y 
O 

SZ ߀ MnE(  02<@(@(w<2 3 = < @3`= @<`3w=0; 3 ;1 0 4 >`{; `4@>w ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9  6@?906`? 90@06 (8  7 (`8@7   `07~?7`0r `;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 0=p    
>* *w8 1 g)  @? 7@1`?*)   2 )6@2*)  `2@(v 5  3`w`)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3~ 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0=H`)`' >H )@?X(`$@#a6@-@6-6 -,5~,7@-,@ 7-@,4~-8 .+@ 8 .+ @9@.@+3`*:`. +@3: *  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ @? /`61 1)/)1  `p< < + + `0* `"ú0*  1X (& @A &06DPѐ  ]Ń mP鈱 f%Ѣf=u˷XПP R@efթu= w
`}w6fQWP3܅tf
@@@$	Xr/QYv
wfD f0W_{fؠt
!c@C"A_T2. t.w軇f7?0<1̉@ൣנrWRZ_Sr3F!f%SSpt@f
qTaf+Q2<n܆ `2f2!t&º2"@t f0fXf^q 
fш"[ @:=vL= v^"m@RfP0e
ڠd+3
0ub(  <  wrP+ Sg[0]uB1
j  ! R b r "2B !Rz r [   dteuVfvW V
fq  %"
v
=r 
~ #¿ %B
  #  #{  }& & F $Д e Vf W ظz@ о?ǻǹP0 	߰ǻP`S8t< u	[X󭿋ج@0F f fpG G1w^0 u4!+ ^_ع  `J_ ^V @uKfRPA|3 mX{/ ΁ J G!OGfZȹ	 .8t.L
ǃ	!p91 SQUT;AfWaŅf@tXa覅b¾Z$̥̉  _ͼ    ʚ#ʡOGDGoration Generic Device 12 A N@1f^t" gr	c@a	ÿ@tdaQW&]rfS+~f[r$
ط]Y@00  @  8WPXEtpD(2f Yt2Q"Y[Z jAvdlaw{wuLff@#
M[ZQV:˹,t.9Tr.9\r	^Y 8t&;Ew-&;]w'f0PYr;Crp WsQ@sVfW^W &  &E _^rC&E
t{&E&E0QW  _Y@f趇fZr
4ps,i_^ t`mItuȊȰfu}<u,."/\pE QrH&
qqEq
	.\Io膂7fX~{'_[5  ()bc./1 24 7 8 :; !  {t	M8 Y͹ *m͹ !Hf2~QR?ZYa [<Q+ +
P>SQWO60#t&#E_QVfS zt!`h"2BRbr#3CcshWj[zV  6zu	 
 fftF.vfSVй-PQ3PFffs{f  ff^}qz{~ {ffI  .`^s fPHfXϊsfQ@6Q@2{tQ^qUۄs`+e6X%P?q_`f3*r`g}fe  7br   _rO8 9 f&] R     ~ f&	Ua WIf3fƱD<	t<tQ<"tm< c<<<<tt    BfP
-B?p. 
@@t^@@"f@  ) ?  9 0 f@ tϱ3TX1  f&U&]" sSY t;Q7FYd15_ҩ2Q
ffڹ?)r'z}SS
S  } P`;C&]_X|RVJr.|QQ.S6[rPXff_Yq6fPp )SQP}XPSe| [#w[ \n #
RSL[rS =ArIr@	yr9<uu΀t"tt
rfPfػfXQQ t!` u@rt@nr
dcwπPtdx @x0u!̱t`pt `|RXD8tmrZ6fa``!scwT KgֹArQ9rIԹ-SKQr3&ttsms](a!&0']v'M'ag I!/]Qޡlr ;E]#`;`ߡrMfa%q_fotdЏѰ #^21P@U#Rpf;r)glsPR$4
ZX	@CRրZr-kH&}_uu4 e
$rӦbQxTotal time for VGA POST:   Seconds 0.000 
 initializ" < 10 Milli 
 `.&Zx.ԃ.Ը@FA.Կt.ԋ.u  6*Qjn` 1.&0
qs .aPVJP% t*.?
.8tFF.L2t<cs^X	
>
2.Aw k09
ps4pW苿oꀰ4@
;
jps.$f{#9y52
?ps2O2@nq"ʀ)2ɳPr0kptN3pp.>,uyp2 6pt$.ppbZ 0nHվpf.?f.+Բ"rp{p(sp .
&t ?詡:0fg	fPf.>1l
UsOsIs &Cv { 0@f`RupA׬1@f.=A~`JpAa
P`+ qfpf tp=wpI8a`p+qXf-wfwffI sQp% f1vYP.
hXú#c&π `	 2Ϻ "ĊRZ$`
s$.
tAP0ԋ	tA.
t*. 	23.. úUpUuu_&
#0F.Ի e* ˿@   Y ~ | тPëO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       u     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    NEAX N`  p L   OA B  C{B JECJ`  p K{CFED`F`  p aGDcEB !6ESI 6`  2 2݀`  :P w: > >`  REIR`  VCS
0Drq .@,SQw*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 {05 6 7^KCfp Pj PnPPQsXsp qQp 1##`p 

		lѳٳͪճݳŀGDT ɀIq L Tp:!rp Ps~wNN a&wBS JXDF]
A(6b2g$:{lZ" "V:,R  C,D>F0q".u *yD(}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=vB zGD~LQV$[`e>pxDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^Tfj
nX4`h4  ####
#M#	#%& U& & & &%%%&%Fy(b+ŀ-ɀ '%!VVVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` | 5 tUP ~>t:o$>U@P #uG6J557 qs
G{7} u V" "$r;sc|7۰$ 	 PSQRp.	c(f._f.f  Uj AnAr
u, 
 t$.tN u% ;t	.^ /urt..9Vt!`	c.툱		!wvp a{ P0urotib aa
uj. .>_0u+.^t
 u3t-Bt._ ;33u'߀u2_". ڠ d` &.ZY[XfP.^P1_af`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%4)u	`,Ò!h	N
	 :tw%3q ct3sT4=  fPf&@1Ka}1q	21 -6U<u f.R=fu<=upfffDf.
?f.@#ް(RfC  f. ./c .3Ӎ!>/d /8d A9
uf36p;ZY{f[PSVW>< t"<\u <nuF=3<~u s2*3_^ !PS>:FsI>%=s@>a4s7>(r;< u< <A<u2B
VM5'2^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??r611ftf+fx`Bvfu	61ff331f.x082^fZf .{ CZ<7 &ZKJ PQt0Sc 2r	12tY`Q`sV2'| !	 y2s
11t菟4r_^QW<;t=  ?A $3s?v4u1rw$0.Ws_b>1tT!I4u}1uP	pX
C=34u2r:f s20W%U1t 2r#t-6-0/
r\afb ]   
   P 1t-*3ur2r,$0t
>r.d.NWa УJJaXW\p2Wt5@"7.R.;Iuf.;KtU J^\ o`96XR	r n6S p2ft<guX<t<t<ͳuL@8
t@8.T><pV34!<1?1?(/?pÍ:@!4`AoG `dc1a%eUa Ñ/tI.> rI/rD/> H0r5} uf!u%$ "PufP 
t	 Rᾀ]MS?e [ 6[ޣ QCzP
[}ߺ++/0s+Bhp2u/|-(-C-.ұ0fP@A0\fW7O- RffGGt
S_9 [Vwb:-^f;t]-wpaߗ-GQ-
@YSb@HfVf3Ѐ?t-#.fGfsG s,  fsEXMemory, I/O andBb!˂s must use hardware (0-3P->Yr#-2]..@N>Fr-=.뢙6lmrDP[	{v  {k-t.r__@  .՛QPpP. f $- G@  >i
 r߈G@  /h ,
 G}P W'r{W
fv`GG ,r u6rП.O>
 rGG s',td r#_G  |6f*bMQM,r0fu!`A~Fue`f10y1pkY!\/[[iP'0	Y r'%3pp@b  B+r2Qtn   9r͓FA%]r
+r:1#Gar+r$#1r\+r0	.+`,r s
]-us+u PXYR
 &ies_/numb PQc bS6(  τ t"@Q(6(.'))~BP#     Eype= Length= Bas BytTrac NVW~  F(()ukG>!t )6o"(d M7`(108J 
G6>}'fGnt;)[	(GO(:
N(])"=-8E 6	 @'Laldy active. Do you wa`Nto repl  i@OY/N)? RVWU` t0@.b 6[PpErw
f[Gff.!!Y At`	PRB Of`fm3
G
GcH]_^dW؍ 
2 @ T{_oS
Hg7 sI &Q AAAr<s8f f
up10Soft=jnovailq..
naGww
`VVQ@ u
D- u+@_T rP] u629%P>&	 EXA!~vAV6@
 A5|t/fTfpdc[./D.GIuG^`!4.Da9Ou.S3)a-{a` &	>!VWQ- Y^_.?@aPPR_ !Cr=0 r	f9Ou w.s SP# PX1m ۶(
 #0b`".&^An$ ù p o    PQ1.E..Fô rGGA$r8 ~5f}o#`#O#p~M#CP$OOF9A:A0 r,P;A5@$t"	r=G$r
1W$ts
 u	rcf=  w[3T}%rR wJ#tCi%r>w8#t.T%r)0w#
؀j#r#t_6%rt_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    !#t+%t`C #t% #    u ? +3R0EFfƀA!  [s02!.!] E!t.. ȰV ঀt  E

`t#C v#0<r!
 1~2Ui^Nx ~@v  ^xA+
u!>! v !9!.,!, !B;Vr蓅!wAɡ`L -  6 ! $s $/e P{X" :i . 
 A`zsuz9!u#P# f"Ћ޴ u
@)@"<#f.# #` !vf :Ц3Sp_"f2bZp-.9Ɛud@VW/u^/ xtR-)w.#
t0 +)0#"#"E..VW." s 
f=8sW@6E$k  ># 0!.# .	Cr!
&A4s: |0;n$6$E@0 ."  %?="/'ÿ] W> %X_rh< u
P} PtQ: ψ1@+r6%&Gf." $p$rS" .s{9:|}l^
C*I O"uHdFouat physical address  N fxpC ðSmsrkP_,tB0xBs u2@u6;&>07!q~rV&}%~ 6o +@Memocompsu;ccpfulpW_'@9	x`>&?|F *кPuf6']b>?f@`DzaQ1#|!v!t fHt2}.y'QrpHtgIt[|tYrTK.
 LU>eAJx1/P6{| r^uUuI3ɍ>tA<'tp,"uج`(8t$ s&At _Trt~Checksum= k r[ecF s&&&w>t(r%[@^~=0N 
\Q&4tvv rqBBt]T rp+9rFB"I<Lu4F"d r`adv.*#tud0]SWf.>r<:ufF	+rfF>	 r[SRir$r%} u   
frZ[ps   r<*r>*!Ds<$煩 0t`.RՀ6VV.0 4*=B* uV  Ka.B*?r`o0*wH4* 02zBr&`j r..*k.
8q>*#R9 	v~	Pv`D*zFp ܠ!8*PF* sQжec`c>||U|qgF!
Hh>J*~.6H*@G@J* kaDoH*@F*.4`98*w
.B*PD*N Wqw2D>t@Pp1`  .;uf.;u>-(sw.lAf`0,  5~p gq	tPuI` 9t3..>ֿ 
E. V	4m= ''0'"~ "

IP.;Kt2IKfQ @c3Ú	!>Sq@K.,6S%3@(.,ޣ<@쾐~RFXPW\@J  aCPU Time Stamp display= Speed= Must set sA to ena_ble tsBtJPr@de=@h.v&uʨ&>rN <uFv%0.{2.~0-n. 6-YQv3CӋR"
c ter =   uSec	t
r!6o.Cx!.Í>rtG
SrS 
<t.p&Nt#>/r/.< u8t">r.Z
u
#&W
*T7argpis@rt . R  manually if fails 6i/WMq9P=ˆ9^V6'~F auЗP66 ^D PQW> %>U s_YXLt2,[r0 p1pPnr.Jp׿ u  .D;& $r 2w,<r(.됲 #rCF XA*s	_ @p>&
mkw@zbu	1PW.Àr p}#rTR.ݭD V fRQ__NSٜ4jX?ɝ0x I FIJV  @kALqecYQ 1
`P?W
q.Li
(.a
`0Uz`E`	dy's0
 u &M	gø C	>thr6>riS;;K;I;;@ ߀ #                                                                                                                                 А2g22}[W>2 2 t>6 _ W} v	 EAC r3ۉ_?2St]AM][Q_)Ϡ &
09P
PXq2t^2<w.22 [SZrġΑzPb  1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:_` ?	3f<u.3<xZ.3<Q<
3< E<
u.2<.:7<u 4 0<s+.2<"&8<b1<r1Ta`@u< <up8<.:Xp ː3>02p .?>2<:	w4<.5> 5<t@p ˀu 8or 6<7<[ø.1<.&2<p1p.=<X@E2@7<.*6< v&.6<& Laazp7*3<
.C30<2<  ϊŴ* # K`
!R.9<
 Z ;<<ZÆwBB PV '~^QR 3du tCl`$<6t<*t` u.A<

y"P%A<
x<Cwp:.A$`ןB<p <t
ArZwG ZY12
d0 R7 r  dI r`.@<r`@ d`Z	 .@<`!Q
t
QhE@ Y@us33`8um"ɀf`8<O W  F F@ &} tC t;k0Tta30h &;&E  ظ@ P ^ X Wu-  ~apPfaV	tQOA _ YRfRW.OA. 
Aw#&.U!
tff.PAƽ.TAA_fXOAu.UA.TA讽_f.PApqKKKJ	JCK9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH+ r.A觳  cAPPJ <t<t<
)SQVWێÍA<t<wPXrs<v@A.A>A &_^Y0/3	0		AQ zY!<8t	 `<PVt:=EIAc
<
t0FXAP QpRt @Qȵ$0<:|u.P ff PffXV	 Xi
Pj}^Vf3
?f^  Z  f`
Qf
|  >COCrf0f3ftY C++x fa

^E    1C< tN< XÀ ް{pju7A!Vٿu`U<0rp<Zw<As<9wA;t^M<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3A_ 7_!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4 _jP&{OIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3wx0<fw,W<Fw<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p<'t	A
kNt<Yt
<NtNP3t8tNXPL9*HHHì
uÊG O?À=/3EPVWuuu0_U UUUJ V?cU0W4W)UXs@Y#YAAPT P G WIN HHHH8U$<w%.HGu0
t;wP
Ȱ
 3]8fx`f`ؿf   0`HB8uĀuBJu*@u
tgB$JQ @tgB/~!J
 Zfp$ u#@=gJ BJ0?B  a4[@ASR0p~NZ  r.1	ؿ$d Q @m krPf  bH t$<+ @bH+
cJ$<u	f n g0cH Bh4]uЋ PܠRJaJ u<]! J `4gBpJt0  t t ]!Jr赳r TA0!$1 "	$`<`ut
*B5
u0t		 uJ
T. + ( @}
JНJr?.J"%
ZED!:r re0Mds"B B˰ *U
ǃax ." r"<۰#iP _  "
 5<  nwu;0@ "8t2TuNuF;1t> p wu.SutsJ "1J?J
 "  hs* 4 J*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ꖿ P % R R  A        9  P                                                                                                                   
Compaq BIOScope
  - Skipping POST breakpoint
F / PQ ;p\@ x      d ưʴD` q 	                                                               Z DBEXEPTNDBWAITCMRDCPUREG(6RDDBG rSCTR ^MEMBUoF)ɰ CMRSPIOPORT5aT ISPTEXTˆ̮/INSTCODEI*	SMMGŀdESET7ARG/0UME
wWRWRQ
/]RQ	A^^WR 2Ds/1]WR	 	T T  !!EOP
                                                                < VK @϶    -$  rtˌȎ؎  F߯.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bug u_tT.T$ t?$. 0脨rW'pEpD r	
XZf[`M0Np PS tatCu?L7hؚ@ t-u$ظPo hh Lr 	uI[XˠC'P{e
.> t
P ZXPw Xr$$
0
w5 r?x   hP Γ	ruX0rPhBfP f"wC 
 f.|!VQ6'|6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  sϿ ˜0   # Zq	t a*u'迚 4,4 u.>.} u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.߃>0A6f.R6D.VffX QZ f / 
uf.R>r>^)n1  p ߁Z P3~r# Uv  z Ѐ~!f%#6 .,.>>6ˍ6
0 6.ffaJ f)!f%@UPJR1f-pTf  K 0UP
.QX`0fZt
0T <f%?'f
  TPV!	.Q~

.
..GPWS ^) 0 MSZ.&ZπQ<tQ .G+u
@_!QJ+u)``KX!a @aI	`b  .S	!@%"
?f8.6V.6If#RAKf6Of3ffSkAor3$tA^`.u	DVQ
6ˇd dTt	6݇U  } 4
tY).V0#g&;B*R'Z=u EVW>ˆ菭b& _^FVW~ +䡍>Pdr6>]_^HPx_š pfLfVfWw>ߍ64 /t 3ҋ f1@
G` 
t O
twQ	= ?  68) <R se>uf_f RfYpo/p 3 p 6r<+u<-uPR+ZUR- Qȵ$0<:|ݟuYXP E {  F>@
>W  u
lr3- w|HroQO
8rK<?rDuqr)W.9Pu$e r$q:lVWލwP <r:D9Gu-D
9G
u"VLAt.Ws
B_^ToRVߋր? t  %u
3^RrWU3 8r<
t
<
t	:tuEF]_Ar r r
ê<fw<ar,W<Fw<A 7<9w<0`00AQ1f3aB3w-.-B6/A)A/"G2e-YE.p"PG>q޶BHr
x6ta >|.s<u=0> <u  <u0Pvr).a>PN{ÀssDQ w?QB>@
 Q0s?^P2>BoNYѓJހJg&IҧM 9}rqWGJ@6TMr,	fNfOfAg&@ ?S2fffXPtw aBA@i f.;iw- AZ r%&Q0PPY tfGɰʚ
>A_ r,f
 2mWT)bd@ r@f؀ffFgfd# 
 .႐S3a `t
~܃ffVp xv"  u $P.ߠ$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@f]anQn90P:P;ق651.=Q[ {fDJR_ RQ T
T
{
 Z Z\$
fX Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ~ffC*** Please restart the system manually.
 .<t$
  
$!~$$0AD?O2撰撍6ŢҘҘӯPE@> Q1Q ػf?tuPRP ү ntJfp˂a T WFOP}tO@wX >vTY|YfPQUGPF >JMu
,~2 6  POX]0qUf ]Qǃ0ŀ@Gbؾff&f&  G>̀ fG`GGaQ6VfWf>҈!f!Q =С ffD4D$fOЬV 6҈fP ʡ  ஀h}$Ph X[õ ޥߦ3@$<sA|Yr.ˠUrO ` SA (tD_orq XPנ"Q!f/0ѣ!EnS  gf /u
> up[PȰ&  cB|`&Xq!og= Bxx<w ˴                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          i ??? fRfVfWfU..f. 6. ` + f.0 's 6э>u. +C..+.> uj.^q:
qf.f=   sIqOq r.Ьq
 .+ s q}6ppt+Ȓp+p
f.f.f]f_f^fZPSQ@ 3<dr<gw,d P$<&Xu
 $	,<w .	.N.Y[XQ<uF$<t
.Ã? t#;OtYQRWSVw*t^w.;0t
|u. >
f3EG.Љ.fEfGЈE
G
.f$ r-/te   @ -@.Ѐ tP=? @ ?XthP[G_ZYrepe  ` np VW>S t6SsCsq?s6 &- + aGp }p	, 5' #  	&r&r_^ rERPfPǋfEEE
EEfXSQVW3#u-6Q	t6# 6QuC_^Y[VWf6
 `F
Æ  fPf$FfX    E	@ k fQffD$ us+ؠ% si}
uFD4/ E}t#uS uN-fD~'  620( iQu K
߀u#*
f	rg
1g
 _u,	 1q/϶, fXfp5 Qߐsw`psY+5 < 7 6bga5rq_~ie@ aȋa8s"s1fE-p[!`D1S
چ	侥!f+B>sQ@"*#%>d{D@@@_RS`rfe  #bV+^	sF?N+R!%
!p	D
MRu
HaI I7<&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$ ,r
.`.qFbb$)Z7+P1wPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ ttt%EEw)|CP{u
s
>c`uF@F2	E TEDDd%=upQb5AIaR-df$0	К(=(t@q	
v+Ұ=uruQ2$GrStY0< 	("rLUY!
R"pY+C J g'S ÈZ1"b#SN1NsX`_|0^ eVfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0gOCf_2`0#escsssdsfsgsfWPʠB6X
TA tWA  @親tAD   + *2+*4+*8o+f5c|- sM?ȁy@ߋu@føtsPørcwp d
q wt ?P~a slc#fEst~ a1`6`%["	
Kѧ]&rbpBb
Fÿbx+si ` d
` p p P" }߃߉ߏߕߘߛߞ uAcA s@E
WV6g4Fg^_rg t 	p!	
  	M
fw_ord db q tbyte %*/" Q ptry  WV.t"Ü6@:s6J,6K&ps#!0RO_Οf^f˕ fXPBXP $0<9~Fab !Ò  s봰+   1$  se+s-!sf    n `@  c w     e\ d  |(    $  ' ( ,ܰ / 0 4 $7 $8 < 4? 		 @ 
/ H  P0dX ` Wa  b  f@ c & h  i +` l 0!m 5 n 9eo ?p Drq G r Kes Nt Ru Uuv Y%w ]x `y c5z g{ j| nE} q~ u	 ylS
8&&#8 ` mf 6 (0 8  |UA     !k  	    10'8 0 % 2  , '  ߚQ+ e #,   u )  k9װ   U3    4   u  ص e 
 5 x~\
8 q/  f  ( 8c  /rð T s  ] 8؃1 /9 %˰ t/ #rFͲ b8 '5 ,$ 1 ,
,
 
b


r
QL 7e? ;  ?s*Fw DD? K w Qe V  [Z ^  (I#  b%  )`$ B`  f k qu v% z8x7r ~   f(+m08su0ZU  !w ! e"w # 0^D8 ۉc b87(be0٣@9 s  (,	 ;Ԓu tn ,   ; e q/ ' 	 % `d$ T  e  ҕ E sj	 ݵ w e @ 2A 8 B ?eC ED LE RuF Y%G `H fI l5J sK yL EM N 	O T
8 ށ8(ݶ 0f8Te e   y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 u$w1 %%2 %0 ̄&8 w9   e  	  e   u $% * / 55 : @ FC      Urڲ ! $e  ȥ5 K9 O 8wSuX% ]v0b5 gv k&p u zv& ̓(ɧЍ󽱻  fmv&빆쿶6͖mFަ	V
f
 6f&v.&5v:?uwGL RfX^	eU
Gr|lBp udz y8 ~sf( 0f8ݚР ़`誴 7 50 8۾(l8w8u  ƶ (f08t
ܶ ؅s'8 $ $`}$80 $ 0&ڻ  e$
 0 008  `o8 ˶  5!  MUadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl imuP nsbQ  out a  jo Kjn@ cp @ z @ be ja jjp0@ l jglg test xchg mov lea n cbw cwd call waitff sa lQ 0ss stos lod cP
bbb b rol@ r rc cr shl4@  a@et`^ente"f`tA o iave`md xla@oop q c fxzQ jlockpnea e hltPc t ne doiv iQ cltc i
i d@d"xzx lf0gpsPl@`hrd b{sf@ r bt0 sp  c i x!seP 0 P b zbb p"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxf7ld1Q l2q me1piBg2nr z f2xmyl2x fptan` as re>xtrac.s0
f`/ p.sqrs01%/frndq f &+q
ucompvPendis0	clein+fQTf /wesc
env
cst   fre0Q /ar(AfbibC

;  ?	A	 r=fi2a ( wbinv%w	a ::ob @? 6 s zs 0@F@:@s s AlBA CgQIA 8@=puid rdm-rdp 4rdt`rsm ud2 wrxO .  f  yz` {|F}{.s߈x{33	t.dG
U.ޕ
EaF,(-)*d.V)PS ޤ[XFe{$U<v{$tU	&䝀$!!w'E t$$$I4芥"$Q(',}fU$-

迾E%$0c<5r1<" t3"$v74&)6+t06-U0{E#3$6Q9uF;m>{'A0Dt+=F&_<JF8L?Nt!ޕ@PE,S{<$VuBXU&[UD]` 20cf^1i*l
nޕ+q#*vu
UJxL%{E}G/轆'0#dPPOOQoIߑϐ$TT<w(YU_WeC}C'ICߪ<kU&@'tN^86tH`&@  6 f3 t3Vv^

ѷSQW.8
F  1 [Fn6Ff.0.>0QHY.&f.>R[  t8svpJ $GG _Y[PQ.> t7xFYX78eF PNS?r [!Hz %NYa F߸J2 uQFoKEMe	$ <t<t<uAE* om"ME' ;蜡  XEfPQfRf33JFfZYfXSt[OABC`mDP ҀQPہR҂S҃ABC DpPOP R S c?[ QSWP..X. u<u	L <r<w,@.`<  .>
  <  <;u.À
s.  <0r$<9w ,0 P. ` 
 Y.l<?uf. &[u
f.&R<[pOp?uu18xf;t'u_G2p~ .0
_	   h<@ ῀ hZ=6Ȏ؎OƋh3     R  O O      y     F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` a b c acD Y     i 0 0^j h=``;@:Wff > hp
襠 DϊfPff
fр aVWA+S@)'WŢpr;_t[s(`(F[_^aW|f` f vrup6fffGfY܂h2 R1Xfߊ$
(ff A	S22*OPr'}!$ 
 uf 8s֊ҊʠXQ;RP
t0^r#XPX  uf 趾auSf{UPfPfXZ治+ ]f0)ff]rff^~m`e#n z= srscB
Cb_ 1f^ ɉw @t; *f@Ikw  B)ђuW6ѩȢ=+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu F1KMuY ^Y]Pg>!f0rRg'QSVfNVFfL z^[YrfqXftA3PXQM| N{ O蛂PQA蹊` XPhWGU豐^PԀͻʡ AFд j ]dXÀ-p΋_P^Z`Wᐊ f}W mp_ÿ 0                                                                           -  8o%  >@8sUv V ufu`wQ2=fA<t1 u!ϱ n #r.V sfYZ]fTf;P¿f;fZWf=!r@nurf+Rcr
d`|s
ua

<1GM	k;rrmBaoP蜗XPQrr Pp$Ss[OBzMI6E{/6|JO ~0p`XE)t fat/+f %#fSfQ<g t0dQ#2" ʥUt?j$7 3#tcp֦ꪫ0
ð-@_ɯWV@ ~WB Q Y_W
t^9lst6]V! <5u G	F^B^= ts.
<5 = 
un>9r@  Xf[2P
X^#WfVf桖0t
P E3r&< u P B S f^cô PXs #M#1$!$#$PRT)
u $ސCT C'ð) 1U
 ? 2$
Ǌ4D O $ $
utzpS  Y uðQ3)3zð&pFa
!tt	*tEPZSQSSS&6S"
=S[KS"S <t<!t
<P	<*^Rp`@ ZQRs	 2
 Z3) ӼVP֎ލvS<û	 [rqkX2A^a
 ð!R7 $VfW7 u؃ t^
r
sDp<A) @i2@e^PD3J|
u|	 t0  $<<q<
Av^Àw t" Q
R ؊% ȑ؋ *0Uu Xð2HQVWP 
J0?X_^YaQsJpUP2b袿= 2LB2`|ʁChY
P'/#f@1Q_;ðWB12	RP@1 (S)ðT)ժ Y"5@Z5. Qb	U27
.iQfUfQܐ`fVaMQrMfXf}Q gf@ N V FP`(gf ff"f0f@MufY(A#f]Ë< 3+fQSfVffLfTfDf1Pf^[fYr!սX	AXf P2p 0P,R
WfPPt3  fRfZ軨PP_f] ^YPfWP tOtQD}UP/XY f@P_ YXt
 t$t%I  v n&P@X(RfVt `9?(7VSQWfw#t /r@?d$or	`@* _Y[f^/QWV<wy^_YSQV3۬
Ê^Y[S { e    rV1fffa.6,fff;w	rf;w@0S.- "  u f%3c/aBRrM@u$ Ċ Ċذ1YM0RM= <r <3@Ȁf
ffʝpff   f-   fPSQRW >E謘3&G;r_ZY[Xc%aTU   AS = t	tpQ fp  f@PPu$@f`U4Z4f4f pg&>wtq r 	r
  u f_@ǀ gf&^$f] tt,$
g&"Fg&
FI*$
g&#Fg&FJ	f#F	Pfa
`VR	t#1
t.
t9ttt&U&U2
~w	t
t11wtFt`?
t~g&`
g&@
p
 
u
g& 	TA1P a3Rf\&^q\QU`S՚[PS3[
`}@Xњa CRsɄ3Kr?`,.J3t  .JfPAMS2VW< ЎЦ`9P u
 
P  t 	˻ʆ@uJrr vF0 & O 
bj0&OWˁFUWn+_]v
 ` w_^p< [ ߃Ip  MB  AA$+ D 5+&= @
+&FGvu ,v ,p cu#' -п,&` 
;uO-au-f3ɐALuBH.&"} WIGFp  u2DFȠsN~ rSu[@&zfS h ff8h  `  `^   H  $p@|[ f@_ol f
O艐a Ѝ[q5f 00Z% ;t}f f  f@QQ_Rfx 0BKppK`F5Z`PXfSd``d f@~tf<~OftPSef%0

Ph`DpB_B3NEA1ݐ9Qsݝ{`fхftp" Q@fY fff`fa!Wf@ff3fj`f tf 0OuYÿWr~1Ϩtu ްul`?hk?FrVa?Q L G B = 8 3 . ) $      0p_&GYÀP!.4ðd:WV,.3^_׺PTErD.\SRU|0@EZ0QRMȊm̱EWQR  ZR  pok|Ru8AS؀u
RRp	В PX E%
cE%	X< $ZT
 0
"~
t`0VWt_wZwU
uQ6rEt> r2
tC rͲ  r  P 
`!   v _^eu2
u[rVei1sCr"trS '~;Wr6"Qr
Er3T o")ܠue  
 `  tK\	\*P')0\;#$ rIW("  k_!ڀP(͝B O5}5Bpn0@@r4;3r!- ,-lB`SbA@DQRȳpGKAA1,6,+@ +q X, ^,0 ,P  ,b F-& l@ - -	 - @  -Q <.Q .( . @ . @ / /
 #/G j@ / /   ` 	=Hewlett-Packard 68DTH Ver. F.03 04/13/2005  I ]  Z  l ~q oKBC
sion XX.XX0
 _
  _ 	o~Ar#  @  A  tJP12 Intel(R)  rnal L1 Cachea bi2e	
   6PC CARD-Slot  
 8  	 www.hp.com@;
 p    
  @}! 
 
P DIMM #1/H
28 
B̈́0 	q.SST49LF008 ,
0? ?.P~.!P0
4e   72"3$0~]2No bat y'1"Λ5_t=$W=1 _T*u	 E
yjt)Ӏut&  5& A)wu&u#]
u! /À8W@W AU RtY pvMuG	0bu< u3uOQtru1 ta_0> S:u@8*6R:EFu E0P} jQtTt̀t߀EtH7ݚ1 F )t%> t:& tSuEu?3  wt pE>I q u	PXuP3 t*X,tS%yE wutT 0#)	&2!qp=E3誯*x3;r.Dv+W+Xu432#*u!.ð-s*1!	 2M<Gr<Svƀ ,Gh.#]hC%J u$
<.r!Lu24$`.2K#/h4rPA)<.t<+u
0 uN<- " uJ,0r& 
P56 ;6 %10Ü   EAX= EBQ C D P@SI Q S CS= D@ E S I1xcept1z4 - Overflow!5Bounds Check6@Invalid Opcode7 Device NmAvailablJ8Aou` F/ault9@{ Reserved	10TSS1Segme[ntPr n+12AtЕ V
}3GenerP~ProtecEOrrorq  1 =  System Ha!P'
ߊ
-XÜPRw'u Z fVfR6 4Fup84诇/vzT4pcPr4Yύ63{3tfÍ63j 63`fX/3T ſ63J`64A0Ǎ647XY_WQP64$Q4Q4p4
646g5F
04诳t4]&4贯x4na5WJ`05_o@b	[Q G%; I1`(0X[S	 m6Y5ڟ p C8BBaacaa$aӜ@0UFfFɷ͋N
~fE F Nu3׺ '7ȷn ]
 cRQP~
XÊܹ /FFYNZ1A`QjY`Њ  aÇًP8"ԃ 8 & G9.&7'@'dQR{ Zw
  c Zş 
G XYZ
< 
7 Q   r  `؋   9 _  Q!y
@ 	`uua@ ؀ `
UЋ؎ ]_a@]3G
AF `P C0[oq$9Q` $<u 3 0ؾ   fan3S l^Q]n VQ=3AUAY^` 
aËf3RQ3ff tff3fRAыf;v+R'TYX0P@YP\UfWf&и`1fW聀]^f_f?f_]p_8f <u ~<~  u<  l<c<@%Z<	;Q<
`QH<i?<6<
-P= uX<`<<pXL]WfPCI 2u_fQfRVWfSt$ѻ"r   f;ttN f[_^fZfYffr }  u
Nu`oX  `R s r 2fSRfP%ȝfXZf[ff\Fk5	vf s"`s t s t QVW&= & s fPf&EffXO  _^Y@VWPwO`;t
X2 *W 
_ #tX _^!DNp sP6уufQ fPfsf8 P8s2fYZu< uEuPPuAuZ5?PPE EPP runtime BIOSVers.1  
 O?f?p??@*@O@t@@@@AA-A9AEAHAKAAwU .?]>.[.[ r HR.[
ZpQRP<rt2[5$ԁ !Ȁ
  -" Z`5	$ 2Y~ p[		uR xutRf] SUUUA.UVf	`&n m^CN CWf	al *Z uà ~@u U nPSR<r
 j ?Gpp0^r
t<t ).>A 4z.A 
%  % PQR3uAB$ԡ 3ZYXPS)"
%)[1Q \Ԡa໊\֠Y`t+uWt= (u^
fz)es)ذfw)ep)20W R)a)苠a VR	+txSR _ڊZ[  Z[Kbޠwu? g"ۊȠ((t%kp0Q0
udmB9Z^`*u=蚕u8qρBp4
@ʟp ß2 g賟0URH*u<Pu7Gt_)sltۋڱ
@;Z]PG?bXU 
 s ]`K:KxS>Y {M M>rQ4Ys\ PY)߅ 3Z[x0"g'{`"P3
ݸH WٸG OS QL<IQK *S
 pN qM@B&c'
(<Pd/E\EEEE#F^FFPQ&` XW<ram .D_Swt 
' t r
2[e 9u0^r!<i	rr&_ Qs" r2.D2& r $ ŀs  r 9q	8 r 	&& rr	 ՁôSs+&' @>'  sa$sQ
u>[ WQr%p$S r rq	A9 f" ?$ pQ@	Pm @Xa\#t sq]@t[Radߨt bpt t
@uYм`
 ݨXr`QPPPtRXdYQPQ0 tg	`DXd$!<!tQQ_Q  q&@tPG0X@ػ (`<u
 @&   >!@tA AuqP#@0  , & XV߁  0`O  r
 P<Fu u/s	` 	߀uA
 fu	 X RtGTtu`6FtEuUrPRtKxGr t& 0R] Z&Duhq8Z h 
Xuh$:rX&  U u@ ϡt@Q!	 'rr
Xrrc dP d@y  $& 8t   `{QX uSQ^ `b+OH 7`*C: EN8r011 @Ϩ@X@3QOC*Y  G  0 " p	C  lFpoypOIEMAG  IZ P      	
  `# HDA-L  HDBs A-E r Cu 0USB-FLr CD Hs LS Intnl  -As B C  % _eO  [ H	P 	/` <M IK` c!VKFc	pK /K ?<KCD001EL TORITO SPECIFICATION VMMML  A " * Gxx  x y 1 " *
x"x 0K   s  w_X _y\[8y y P\b é uT ËEtE
_U ʡ0
kr 0 t
XrÀxwf`!i2tW & d_&E3aB&U
&{]@ &EL t û\Mu0&E@ !Af~A<$PnP!`=N 'N N  = "fPff  @ fXtfUfp fSfPfQfRfVfWg]?rdef_f^fZfYXf[f]ge333prVd4Ad^;sgu` 
3 #s M tAt<V&rdDg}
^z` VWq^gEdTg_}
}goE `tr	 	t}d8 W<yt@Dou
`PfUf]3
t縅 `$u Ó' e.;Gt ._
u fg6$+' +k!$PIR    A@>` a b c  T 	AhU    i 0 5F0j h`3. W wp
_ϊͻ 
p aVWOS;pPt[1
 [_^W3`  Qup t`GYh /#_QV.O ۍ6O.O^pj 4cB C QRRRRQQg]\jN tN,3N@j0]$
UQ udQ?jN 3   p4SQ>Nu5߸ôL% Gr!<p3ɸ 
 3Y[ ?SRVi&
NiXCy'_tt# ꬸ>p:
N<t<tG< tp._3^ZBX]V  @Pu P	ir
- `CZQP =c
uhNNN2hÀw*VRރ| 拴  t.?SZ^KS|SSsS ToTP .TBBBX$JJ2J쯊BP@eǛtJ Xu` o SQ V tA&q JZ  C@A u*uP= ]Xruŀ̀2	
 ; (8SQ2<

2ۆT.
$=2rۆqd$<w0
u@ð ~ G0     OU uP0yXd]<te r
ted8D^uaq;RWucffsw T^uq>@<`|h&
yt,ـBt&M1&G&a|f~f`qfLAAAS{+Íu 2fȃtm
 Q ܈$FKuðW B
u	ۍY;wY_uS؀u@u)4  R A  @[fߊ$f
и?f@# BRWS22f0-\r\ u 8s܊[_Z?fQWRfP
t)@r ff  u E8ufXZ_fYP M rI@3@r: t+a
4 v 
th8t	
uY0	g&;t4g&Ct,g&Cf4<vf[a٠}
g&:#PC1	0Wr7fg&F 	f`r!f`Gag&O@` Nb O q,@_f[ûpI2p n Wl C  Ơ #  Ȱ2Ҩtð
%,ppy$zҿtxøa
 jQаwJ	C2<s s	2 9 p20*# 	  {22 	À tN :4
$ 
$0 B$2
ïWWW
XJX}XX Y.Jt'} 蝉<u 2hp:Z h l1qvqs{w;sSt!xUps
2 \"  |  0.D.DS~ `` pY&&D aø0 м Pj ȿ&&E  3Լ{1ˈOQPTP !1XY`.\.T	Ǎ>M.L` `uaa.D`saaQPƌМ`XXɎ6aÌUÿUUUa_  @ȏ "PۑU-pRGw   Ъ*[%	|p`Э God d ", hGa O 
p 7Gr rrs qsq]
sq"  
0q  6r `r	 
B
 1ݣ ` u # $t$?aQh@ & r 3u_.[_3' $?< u@LI<u	.[ ;u<p `H$\   ptu vu	V $
4 q}`S~@ u7`P:<uip UNNN_O Oط0ߴ$#c#jU fJ$MON"ýfdâf>0"uf   > t&r_Vu`v P`of+0vQf׸@bYrfǳ]A$Xm>uIfs@e
f60 utrr<> SWAs @o_;_I_2_  M [6`?~  " *;00 *
rB~68y Ay boc  uaU Ë]EU  ʋUuо"*r t
r ff`tJRQW %  dߤ_̺&UY U &E!  &]@ Z`&`  u(<sW.__.0"_2CP0=Xs$`Q[Pru..&+.	pv[ @ t^P.&u @ u42..
t _wPUU*P*о&u XY`-3P A3.{G@
X԰PZ *.ZrWȎZZ_Q aaaaaaabb
bbbb#b%bVS3м.::au0;aK @[^* UFP~a2SF۹ S.CaF[C`N[QF ?tOasF2~ tY@ ø7
 _`  _ ø8g
 d`d@37&Aoۍ`0ԍ7 3`7$ $ccc*c9cLcccc`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233pqbf>"  tq" P a2ۊ( p ) ǊȊ&)  * 븊-* >+#1 d>,0.- &) r..PR ut;60n6 6 P3
t,=

"=
 
0I5w<t<u FÀ t<\ ` s
Ê& 
<uaw\wWQu& ` u5`!A &
^4~Y6 FF;t2`ee#oeeSaa\"c` \0ba3ac]aR]臷D]E]pj`[\o!a\\N\5\+t\ I|\ZP\ Z|ZeN  N N rQ Q TTQ    U	 Y
 T TWTABC@P Q TR  S TT  U V_ WXUYAZ[\1]^_  <` Ga xb c d!eqf s[[[ZZ[>[Z
mKd^SQfPVF! s^(2۹  0F  +^D!8u^Nf^`[WVQCuKE`T! ؐ!0 w $I^:u:\!u 莵rY[_S  [3gӡJW.@h4`5@p[{ R {E~}uߵ $
j`&vaTJ0`@faRпHt ;$ot. ȋZ#11)_| #$ЂQ.9.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPRZط@$0<:r*uP}P P߰ H  = r q& fV`:PgfF`XRyZÜt	tv
 vt[0؎ ЍOߋhi3 @ SQN<tt	fP!XfP BnհYˆ_Q4ذi½YQu vY<u,fCISGu%f» f  f P`3.>i .ifPS ~@f.nj
kO[:.njf`ՄuhiZ h"  躄uhUaúB   $sÜ.njuw酰RVP
ۃx 拔 tcPtt>@ KXSx$PzXr$-Qu!$
BB -JJq4HX^ZY[Ϝp
$ q#  3Ҵ./@32ƀnuo n Xp'ðм  N﮸G(xw0r @pt4t op`	k2fUfP5XZ+ f]ffŝf]rPmn SWQ  GЃtуY_!*UÿUUU	  " "yQ+F _SYSID_  Am _UU  fl f@f=  uf3p fl P3Ҏx ȫAZ]                                                                                                                                                                                                                                                                                                        
E    S   _ -%  DX' p Jā݁2L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.JZr# Mu 6Jr pt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF ô	 q`E	 ӥ/2	r@e		p'^F&?s  s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	ffPEEabgVfQSjof[fA1fY^f& u#f&GP Wfu   4WfZfXP'F#~r .>׀t7  /{r?`. t8 w t t  2SrV ʀs`,J	p J~t$` t u/~ǉ~ %"NV 1	s^Í6K.|uL>R..J`>J .:UtaJaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w)[Y_0? tl>ـ?r.u|
_ Ѐ ʋ.E~;v j'fVfv`$dD @؊̿f
@NP.eXfa ȋP	rs$
2

	fX!9
dDfUv]f^PRWB@    ZXRPXuUW:>_]s*r  ZP$< - r!Pߨ@Xup>qw @<@0P  *sXXty>Wc * BQ	?Q	߸ QV  PRW> P@   XFrr#r^rT:rOt :DvL*Dȱ f umfm4
u
rPbl
u2 VWrd [_^ q QP&:Ev&M!&*E9aVBoCo<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt2߁4 uu@uu`  u2&fPS |`00v[fXPSpsoq`D
>X`?D<PƋ4a`t a1t!$!"条q1&2PQȎ`SJr#SMwO "t 
`P2:Tt
a YXuOkuQ,9a"   <s& ? `P93 >K}uǀ   Jt| JJVW_<uW<
uuFw ><@g2<t.$S[M[|u|
`g|`it\_^FS`}w
u}	 !.b>܀}@a`pO1uD}a1 #%D0QV 3߬+^YD$fރfA~ff?ffJf\c
bPZ#f F PXpZfP~Đ=r0&pw)Efpu fau}Cu~s3SV|wt` t t
^[PfQ
 0 < @f	t
` vka f`ffafGߒfg$Prf  pqHff#f+ִ f;wfg 3g&Sg&c
uff+fX撝faf6SR	Z=>$pfP躑~qffX0ORBZruAZr
|gQ2ǜpXZ[fW|bt~b u:
rrw`U~a `B Ua p 0`cQSQVf1֙fiѥU@P U   ^Y[+u(PUFP @| ^	u<Vf
Eo 0QpLP	r=^ uS@]#^[u"X
 ! P ^~u.t Uj@w`V	_L
 B8`.
u&*P,uχ#_>SfQfV `@Ł=Ut<*MPThZ &Ep` `&ufރÁP  \f^fYfalSUh &]S^ ] $!&@&D0DV& fȡ\AL
^rPfWދ@VЎ & f`t@jLʃe^0 ݤP P&t_ 'f='+a¡f;MPE   Wf.ޒ	Zg&G_ǃE!#3crYR-uTf.ޒQ,f_utf`@]StQY fLOfpy,  !fPv H4f# ,;!`U
UEG &E"r@ifa{Ñ 'rnOGw{|P_@0 `n~ %؎`1#w裊 \0<t+Q 脊Y<%H
fu f` N` p?t{ Yp6.WM"fxNf.ޒg
袩7 -""#:qOOP9D	rQ99: Lxp;.9r()u zD>(uf.ޒp @- r=b*VQ$T$D
 V?&Ta<^3Csry9
lY^BG0 ~50L80o"B1EvfL *(A=D`s(d8PVWPW@NTP
DP EDLDra
fMt]LJWAM ;?f: vM^_OTrNe?:YffWfQ@Q4T=M
e UL`L@BLR G>`G^WXVyXPVFPW)G@(WPcWV+t	P& 	3

5O`f$Op%UOaaoؾ:!P	Qơb;`#SS(SQ@q	)UfhR`e_W3na  {Dku_1nhQfhhVhphgpmN`rpPjYj|t= YXi,`{Am
1$pf[iPQR Bȣu J|Ci uTf`0D 3fft; ``Qf3|Y,6i5 !ZݥTc/s@ Pk_X1Y@ 0 qmP0`pЭRW`R3pfˎۍq:W	?rf+_`SfW.ܘuO!˵f g&$f ɋ? `2ۨu<@tĀut.l˸_ f_[Q
! YQ 8  ` PRS%` +ð ;w["l SRW*׿OзIr 2 p3_pQ,{AsN Y rO:=3ɐ!RQWSP b	$`X Q쨀tY͝l !`@ sX Jt	uRX( V_m 7	XAP)[_YZ@2<UuX
8
DYJ܊Bǃ   brT
!uAP [ 2
XS@
u	 蟅 ت *ê臅[XVWQPuDt!WQ:t`
Tu8v
Y_PY_XY_^ _SM_ PPQ_DMI_ ,+  #9%  2XPUv F t	F !Ff]X"X?
W8 A t" i &g +  pa
u
fN@  ]ϰ?2ðq  S\8@&G &GPиG [ W!@   栊@@\&\p 0F0 ]
..c3 и( и-  2P
C@@ XWP/<w3t u*p O $9F& V._@P X^2$31     R`۳4!fb ufQ8fYgBW[z<Ȏ3]Ou r 2	fPS=Au@u;Áp u39 u+ f?wufP@u BXu
_ffP`I< tXI%[a{At{N#|S{[_ k@Q  ~{%{ o{KVǠ !qO D{E{9{_{Q   A,j{opYxRfW. um3hff=SCAFtViG t fff kWuf(#3tfPf[fXPZ"O_32_p9 x
` tODu (Ӽ$
豼`,a蛼ô%葼´+蝼} PKп}Jt*w ug$t0Z$< ȋKf`~a
%D	7	 %` +!$fa rυ<
%	*P' @[TO xOy^ ere$DIs}L:  h                                                               0   RDS@    aO IYOO L vPQF 0 .p	˸` q && f"ꊦ  ~f3 f f@i.<f.:p >` 6a m !.P wf."U"""" ! a
#
P" f3xgf+С f`ffWgf{#Eg ٠^`ܺA vT2gfޠgƃg u	f@w1  @f@f_gf1 gfgf0	arfQ@;gg&ofG7~;wf+fa f7gggfb	fפP#f}ɰfa
t@@P	3:
y
ff0
gf3  P
@r@
A
@  gfo3fS̓ Š΃wff#b ffyZ?'wf3f30n,߃;w#`4ܼbf[gf߷ p2
fOfP	c	

fAAXAPۂ
P#W!fكs À +SfVQp g46fFC3YQ  Y`@.f^\ g&{GCffTp[PfVfWQfR
/ШY__f^RWf;rf`Ȁ u0s?'1 t-r(@tD<u u P faUQ	U F @ E] < t<t
<t Uq`Y]p4 RPQRbfv2 0q ^~qRZYXɓ	pr3`	x tt -  t	  i09`Kr=s  "~#@@Np18P,Nff3u
P t  f3g RrfF!b"XtԳ$PPTff`U^Ɓo3&fPeQXYqo)YaP'у` koP!8 #	]of<t`L< u#f$!6oA<oPtofaáPf䠄t"
桰   u$! !tp &k Xa{{ݯ *qݰ Js@P}FF
]X `j . j v
)Mf.N. utI4~r@5p3؊^)tuw t&Du .⭋^^;ZIaϠ~@t&ڃã.^2Ȏߊڀ36t6^2. @ PSFg
t'.:t	tX._[X`PG
Xu!P<<Xu @P/t1a`
  P?3@C3aP2Xr-s(@r3H rr
 rR VvF\r:Gs5&DC Hrfڋy苡_FÉF(t S^$:u [r
F&F$%&=vHH&
D0&du rcwu
:	A	πϠt&D@B êĪǪoAT0	VcH UrpUsʁ `-su fqt
E$՗Eab&G )
V oNh8Kr>u rG Po3F) r\ {r=H r8QWss#

Rr
3 s@÷M1 |#km##'F("r#謲Qlr@rk20!0p ×!r"!F( Q'&d&K}0#V&Ơf)&t N.QSWf`ŀu/ r)v{!ufPs BfXtā_[Y`<t;f3f t	f !u
utǳЮ`f[`
 3 P  phf<	8PO W校F X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$`
ĢF f%R$PG ;B(FGq1ø fF" PXN8NwN 4o2N?0(`00sO/ mlpR
 r
fQmru$fY_b/++U+Ñ^ &u b%tr_q? VQB  BY^	G $s
3
P&u3` @
r
%uèt?àt <q66V&T߀Еߠup 
*&u^ô  ǁ  QPXuN%&:Lr * r$ P @uP<ut.@ ;& ; E q2s2p$<@t22P !$!$qX{w [|[ĺ"~.Pù[K<P~  = sffP SQ  !臅Y[$p
 F H 
۰N8tSFt f% f @f tU0    ";   t0@bqP@fX
PRV s Zn!
J
8
0
$۶g4 Nff`4eA fu4fafFDP2`a  tfFP ۈ^DPm fp]fWzf=`3#"fF$QiF,0 As{rBrf-1fv,v0h,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfր َ pp#f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	ffvAfI )Bwf*ݸfwf
fAN
Xff%	G,fA d!`
;Vt
f5AP
Q
ĳ6"  f%" f%  @"	 "f'F0002KFR) ~!.PSQR30? 藁ff%fZYnPQRWSӶ3t"X  >
蓁[_ZYXS[  QW 
߀@` _Y[Fpû z
  5u
 @ @Üu8 0 R ;Pa@ F4;@H0(P ߈>%;5 N0Mt(BR'9ETDHP ~ SIMPLOiMOTOROLAVP_dVS\~ЎH}dE/ۇP-s@^s˻ >(/h>*/ݐ ,/﷡ ./˰0/@2/hSR &-&Z[>4/6/﷟菢;/W ;0 t
y@~Ph+؋Ò~c8/R@	=/I	?/@`
A/﷩7 C/. V/w%h؎&3&M<St<Mt6 6 
6^V#cOɌ ĭ*og>q sy upwjg@y^gy{=}4)B}_f> U ܰU@RR+ 
r)>j/&~X^ádUY?t@̋ r.])`^%% +zor.f%0[ P UCESsjfr 3 1f!u%f#f P}	s`t_ s``u q`VQaff#boдP|OrfⱇfVRQ<t2f3Cr6@n
+flu g> ttr(A2p uPYfZf[f^ZPfR53t?t! r2-fZz u8_-t(mr?!f1@bt

J?t:R!4g&? t0cQfR8t , tu
@u$2Hp)@t'@u''*tp(t
 /!-  t> `Au2B[ϲ a33q 
t@  ct}GXri/p/B/RZ/rGU/Z3۷À@譧$߻
Ê ,蝧$?t P謧 Z
fVQ! 0fF,Yf^PS0Zap  ?[@;$BoQ2#2@$
	  w mS4fX 	ش  [ò}fV~W` _ W
t<5t^fи+r0f}^{p5QRVPû  f FKYf J8u^ZYfVW7  5)EP2q VD@t0	_f^f@ fl  =  up fl >@t@&?   ZYfXj3ɍ6J.Lu.:Ls&3.D}.L~s` 2`r2.`Vs QP u K߃^t
`3t t
t
u! 3ү u Iú t>K.|` .K u} P J}uL   u3}puv`bW_tURQRUK2YZ6	u>^
 .D t+ t#VL^ 
.L ]yÅQ3| Ys. u&	 t	&Uu" ώǍ>M |  Êö.f.|f@  3.|4߿M\PQW 3ۍJ#_,`Jp1(p  `3菢$_蘢<`ht+aP`)}
t 	
t>J .:UǀV tMRZJ| $p$u$$<t} ^^Q3䆊!*Vh K| ^t
.uu
cs)t!vR@ ۵u3ێێZ
t	'u
u
0NouP@s+XPt [%ڰ`mHz︝jt"Ĩ@t  p 
 I XPJXSPOߎ .+. s#. sXP辠&   &X[ó5P϶'->@/HAC  I@ σD
0j@ t%v v t ArMv .sN-f-p̡&A F'N- aύ6& @	 !
 ar ^	
F (|r
 	u뿋^'Ât %轲1+	d1*515r0/5Mrr[o[
u< r<0s<"N@PQN \
󧐡
' 
$nvf<0rw
sP݈Í>Pu.
I.
MȎ.}Aj@&u |t
  ^!N%V#~FpS2 rr20sus6< s
	OtE""Lt*$Ot"#Ot}%" 2!)A
 ؀	.EFC
r]wsmsߴ1I9  <$u2 *<}#"< u<@v<%p!2 Æ ]
F!UF%` ËF4~}R=r&@mvP8fRF'P^S^!S&EF'f&U&]rQ[P@ [þsSQtP^Ë^6K	Arf;	DE⻀~(LuTMsPf}3fXr1Q}K.  .GTAf f "./p 3V#:Ttv<~'t9~0l졂EE߀&Kq<D_D@ % 5I$~~6K06u0&Mf.Kf&]f&} 
0'Qf* pr}讵rxLt=rl`x5rdPtZ+ٿcr@ H u~ (um-VƎދo^@tffmݵru蠡Yr)8r$耵rre	rj蟵P_TPQX rpw
u s`WBt:ـ?f.EfffAUffsP-EMF F
tSuNffaVK0WP*f8f'w*f'F'*2t*܊f
Vv~Vv 4_ٰFsQU n E]YRPXtUW:>_]s#r  1!ZRP`2B@ ހ ZXюً 0oRBn`SQRQK0% [ĳ m!{h謀 Bt Z^N軳rot
r`a r}[v">K fKf K, 3S5<s-KO8L9" >KG<}P#<Q$@ d}KZY[PQX h   trzvru3rij`wNrWu
p`dع 
!r.Ǵʷ%a@tt t	tCHa% su~rt	 2PPRZF sH<t<)t<(u;ь>A u/WU>ӽ`x]_{3r0Cy q`_^a'c`&PSR 2_ZPÉRFtN+P X7D	F
+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFF  f[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP FfCF VvuKQfXr+ʯtðP@Pώ3 G& tff   Rf+IYÀLzuu$`Ύk2t
.q^G fF! PXG t<"u<"tlV3޾x 4Q&?s0  s& p  &Gu` ` G@w`  в&O &O`uR~p`f&G`TPa  AWQb bҵ  Wsa*,ZX7RQVW:WtNᒀuuw .!6a u/AŠ ?L	
? t,{6pNoAOGA&&d&D&t&D3p;_^VQ
} " uRPK
  ^   @ deTPQ@RP?  4
W j <
1BQRs3ɺ軓Opl.
X `.afV`f  
u 	rpoCr" s  y6	pA}Caf^U`@*ǿ2$ԉNT@׎ǯ~WF$
&FG &U_@
	 `CaW  cc t2_R Z؀ˀ$0ZP` pbЊt
    { {o Ab EpȎغf  T `333ۺI u؟F;D ݀u	p66u߀u%2#p &ւ,ڡ	ҥ	Ɛo
`
	끎hS$ ![ ^L2Or$< f~f	R  0d ap0ff#f' \אf@1f.4 tff                                   0ߎؾ +>۹&  =6a Á.6ͻ0#RRRCFf3۰S8k"fV$
Ѐ
tfP`Tw"T4%ffrP`WfV@f  {gtgPGffpb fExf o  L	g R#f^f_@AWn ]^!Uf`g t/ou (}}$
[}ô$Q}g}G}faRVМ۶P}[C}$t?^Pf` u'Pt| $|p }$|fa2tQR3Ɇ_!ёw 0JB<t"<t$PAJBqpvB(C)Copyright Comp{aqr uter rporation 1982-2000-All s reserved.*578F'()+3457~ u v5u t
&  {x_t^t]t\7utF5R3< v
<ar5<{s1$PɎ~|Xu2o`r yհѾhƆr9_2.:hkq G$!u@t0<zw,  
tզ

	t
w
 thb2]hRSJ, E ?G@2q)Pı?
   tr0r	
2vPQ5s	} uU	gEHHP  IPRuaa@uXXZXp! / *WP߄X@ŻÜ= srqts
0{ _ ߸^ c~Qwt.荈 ! !$= 01QjQb;˂QN 3۸ K PU'  A G y   y " ËEup
$prq`QGWǿ  d_qa(    K P3@σ0W%w,.s 8 fg&'fA X= X_f@`$<t'<t#<t?N< ucX TYM_ Hް<u 5  %~\l  
 aS W#XAVW3xu@ G	Ou1ҁW W@ٲ%WV 1 S!؀ WX#_Wi"kR$	ppquV.A u ȵH"$tu!2$qQ  ~pVD	0Wgg
BuBf߄CCpCC*r@0 *UUUU%17   6  IG F"6! ,@`b k g}
3gE
 t "6JD  [gu0ARsU I2JJ  
$&&E&]&E[
3@E   F˽	>>]>
P `  fV`@ ބuZ{~{t u3N@f6 V]{u^ uX{u?,{@׿N`R\p Sh{tE {uzQ u{t!;{vi
6  
]]f^eU  	    @  pVaG$ $  GN N P P  Gh h"Gt1$  G   
G   s$Ф  U  0    %)^r 4鏂QTKKU  Mv&Qa fWJ.}
u.:tL u% t>JrSK.[t K.o[u t	t_M_`EfUv"v t Ar Mw ű.V PXF
Xf]h@ &A ϴ2j@!Q nru\0V
	=VK.6# .t.I.
Lj@s&  |0u{ 
^SV#؁D.d.$ʋд_^[>	ã3j0rc߁Ot` 	OtOtLtDKt
KtKtK

1u	.<.}h ;$ BÁUu	U SfQR~#G rp
fL\Zfε fP<r|wofDu
 S_RVWUuP&wBrP XK,K>Ϝ齨 ..?>齮@u Pa 3PB &Gݾ&wG $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]r|sa0's@Q`b 
 ff&GfE  A߿ff@! ]SRWP͋޲ }ra$ꢙE艛˿LuR <sfQ@M}3  fYr/>KK.  EGώǿM ./17p;[Ü}͝_Z[.> tG0Fr=N.EP .&K>J@A%50ɚ @ٍَ6K CSRt5ËfQfS.q&Gf.Kf&_f&_ - f[fY2PZ[fUfBSsQS)}f]Ê$uqﴀKݸsء NS3ێۻr?4ðPt W6 E1*_Q{PX2%T?{ u!pXuO߿<2{f]
 N] d `5dPQ3 27y4rdr
` r`f oϰ4pF{ )oð4@   K SQuP $@X߀u@A_Xe$Htu
߂I4
<RVWf1.1Vtfz1{ c'{iQ<V@jV<WjU   PT `HafP >} f 6s >upzƿf2>f@Jzf0dzzOtzf .> uz &R"quk`a ߊ؀ a@ u
_^Z| s x_@V_-oؾ`;\>, KrЧ" u !eQ3rN[U  r.]za /  ob#f&
!@BѤK K(K'`1`O"bji~5%߄d%D		&`fW2sA< uf,u#ǉp f3gf&ff=SCAF2 f_U< 
<! F ]  q<w&< t'V3ɊȈCF`[  ^ t	  SQRVV<v^.
t"A_ ؋B%^ZpZ2 4 ]dmUP XsB Ou]ÿ|l|l%A fr%! 7!?%;! g |lff뙡"%{ %u%/g%#|l"f()%QrAt1S.[$1 t@t=4@"2ɵ"#Y8 .6,s\豽&D
V &DtH @ 
B Fr!0rnsuľF. u豾/$褾rO菿sJ)ʊKZ S达rr
r{;a?yoiZ2
 0
FFt N fF" B@ BF(	r2BB2ۀ~ `{  t3ҸK3 ;wu;sb߉FVFF"PҺ F)tа r4F$
Ft+ F P  !VPX_V@" aWPR u	ZX ?PRA쿨tZX& * p6.:f tdu .f] gu
#p d+}PfdfBd)! s dMd5g}d0ø J V9+dP <d;]ttdd]=  R 3
' '迿 FǠ  F/3 .;v+GuBG
`F/ {@ Ë% 	pXvNuQ
 	0ʕ NY%_'
r0123456789ABCDEFS@ۻ׆[`tfPS^ۋ^&t` $ueG&uFtt[fX]逳( o?~~~~l|8 8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~pq Q pp		 0``00$ff$
0xx00 0 lllll  l 0|x0f 8l8vv ``0```0 @  <7<f0 0  || 0p0  x8` <l 8`p  x@ |pH `a
 
|x  ff|ff ll bhxhb `gf> @p x p
pflxlf bf  ΀ 8ll8` xxp$ x;0  Px ƌ2 xp``x}  xa"cx -701x|``Z pt 8l`0
@v!`lvf0 x [ `b    ! vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
!ґ u!=`f SvN .Y2[]`g i &  _
ld@að
 `
R3҄u  t a TŇAE eMA9Y.nSS<  wAb( p
`3ҴqĀu N <tDZQY
 Ir8r502:6 v&Z a U$PMM l PCI01 ISA#+T DH03COMPAQꊙ 04/13/05  :     F10_  m؎g ЋH_g+3f  3m L!$F10fPfSfQfRfVfWUfUCES>"c  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdfe	 3ua 6d< tf3
@d>Sd  0 g>0;e `ef3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>Jf t
	RC &JffXf^PVW 3W __t
r
>
d_^X \ɰޯ۾ݷاб?m,c-DD(|1 8     I50  ``6~ "k!A8>8  B9 @'Yar:  @;@?i<@ &3?$	?	I!!
0T!A>q

( )))**LLH#Eo$$E~B ~B
y$$$@ $
  >""ZFYdld  #<r sM` hx"'y(PQ<R!2

	" g %8 0 pV	

$$D81 dZI 
!e$F   A4'?((DD@%)0P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInI`Fڏڍ׌߃Os\gpjځBȉymGł񂪓rݏOڕKvxmȂ튮xtԍÃ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉE십ċNԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb - @t  ސS   0 ` R 	iy D  Q @' 'D ?'@$C" 
 P '1!!#"& pc
~|u m ?0
Fq% pt? ߘ  ! x % )  Ef	! ( 02 S   `00m) BFLXp0@t  0dEg!<"F p0lpY.$`"08 D(#ds$A|   UP W F  >"6>?0-@  ޣ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@@@a!!: ' ( <'Bft,?0<<` *0`  x?qt2pC Bg ? @~00 H$@"@ 
	`0 P $&# DK8 o &  | D~D D<  B f<,$$0$l=   M@ 3` B?"#!O!  8@ `: 	4H 8	  6 a@)1p?pp" `$!3pHBQ0@S` P0ZT@L@\D2"##(RY@>B&Z" Nk=bN@-A |a  %rm  2c Q " $!2xa2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxx0a1 
c
AZxAp0!
g
  p!rE  @>>@@`)X0$x|pTT? T8PcCQa- : Db0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{ijv+ dDs?|e0v0a !"s 6`S!cS,t. T8$9`0opGy 4g @ dt>$B<' @}""" c px% `\vdnIi&0WP?v3$fv$d
  ]@^@.*  @#2Bb"6T$-`0|p(x3 OV@@k` F0Vpq]@ 0ua4`m|sGXm|%o38"5U QHU' &@'a! 3?! @( !d(!3#\2b" '?1`		
	`21"`n{9$i$	$	`  "33a0k' l?HzM8 0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!## DEB`@].A^! ^nxRK)t ?` ?0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P< { b <$  '  |D!  D|? d%4 >!d??$C @ 1bp#1{8 < ~ < a   <$$$= ??d)),??4+fIAp'0p6( g!}@ @Fq?6pբǀ66@ƀy9@0ya؈  >`%,#?% p$'!G@x pwc 1$&? l@ 2?$?$?b S< @$<b _=$! <`0b64~
*  hH"e g * ~  <@ {D=a<$" AL`5' '-恴pp^  ) 
8hRF qpà2q2DRD" T@""z" ""s,bn0 CF`  ||~ ނIE`<?aBzd, %}IHT! 㡬aeE@AjD0p 
 .:23V!& ~   B5I@  `2"R`   @!  0`'|Cd p5D ( H ʐH  0
DP6Oe  /$?$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c?2`."b4'?e +"@P,  b
WBF0L 02?$&""  0p	 x 	#`4 c$}R S SPpP !
a(#?@@DDD@"D0τ!c 7=E u0DL|(0<t ` O='4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Rydws7  H 4?b2C"cyH@QnMx<0	`Z8 ̀7( (`C2)v&^N?0JbW8l>/&23
b21#n0  ~!#$ #L`,!3p$?Aq%$"h| "  1  A q }    &o <"rV&#0 I  81 c QQR0S"PC 8`A a ˀ4 usn# 8ٳBY 
 Pw]IYf   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,?=%$>ǒ)jP|D52D"DvDTDD6 # a|b,ހ  1рp#\  7ajė=  4a8	  6 P>tTڅ  ptL D@~@Bf$,892Ok&arg@eP 1 WpxPX	 ^x! 3"&,0@J[D% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`6U0` . `09H~ ܁ց 	 d~@_*H  ~K6cNCc48x F?~!BC  G#" e `QP060o!  8!` "***" /"$'$&*"$"? CJ0``]0?~$BdB  a B
BB~15,"&D$(-jB ,!.	,HO
 =I H<H$H$I$=Շ@ @v 4R$ze bU?S R P|7 8y0 ;6@
bPgA[aq! 3 ?$$$5d$Dd<? ~   ݀Z  $D$y= *XGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? {? pw 0,0  ""bp $ & "9  q?2@G_
i-_ nF:@e$  a  @
#]](00]V?$P?			?R" N8S8

 ek| 0@	! y g	 	 ! ~o>""	& u">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDT C
$>?  '$!$34, g A#A <8S`hO `&#f!~b6@2~Z*\*jI0 Bn5	G x RRptF H0	 ;   	  a |$# '!!b[aa{ap 2zasR0A: <  B F>lxPXHL0Fw`Cu@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs	"`7 `C  `rL(  fMQp" "7>a}>>b 2 "&"cb@	"00P oG  A` xz   Vj_<@` <1p0?O3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"gb>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8_<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~B$fiBFD0@ @`@.AY`M`  I2R2RR 0Bb.	o4d0.t ""p bBƿ ?}~b
(LA0%ɧgUE``AC}}8@Tl@l$5?b5d >qcQ"tdaxR4䣄	(	)	) ( )H	p ^c 5] 1 aA#?~"! "2&460baÀ0"` @"{D1 X8|@ @0 P` !bF! ~°?(HD>!"? |?" p?.a ee   	 `p13_"fd Bi|"@Acp>@$	,	(	88(2l"FfV@@`'$pzBp03
D(zo

@ 
{t~<$4 7 a  p ߬}#@B"4&0PPP`@   p   uUp cuU`  U`	 e`0 ..d1S.b1lp `1  [<u.d1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.Z1` a2P SP!bRV^Zu
`R\ts 2ƃǡ G
}a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F¹. u 2 󥪪4.>i1u . 2 13 `.Z1&1 u2CQ2P Y*2Ȱ&P} aj RDr
.j1.k1PSR  && Z[X ` Op@kp
oo.6W1FF!.WtOT_G-p
QR.6`1ʊP ZY[]X  \"2S2OsP2 sP
XÃ <r<0 <rp1@l1  n1.&@E0u'2!n13[!a01.>ߔ1P20X2$CFAPQRW ((_ZYX. 2.9 t.l_1BA	#+D<uo<RaN<P<S<0<{<<<<`< T<@<.>f1 t3ػ@ .d1G.f11O#0.d1.f1pd`X@Y 0..1.ό10;Pp2  X:XUFN
ȋNu	F] S܁ f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M 
> tj6hejF_c&  hEWHu->uRIW1o1c% = ۫ۘ2?g	@Wv	#B$s
|
qJAfaffпfG
NcӜcm!
fw>
dQjut$Q1`	j	c	)	A	
WRaUUf	_b	E
E>rCh	
=eH%'}SF _"4UcیB *+6+RRg"-uRUi//X"	~T
!72y#B
z&-%7x6='{FM)!ct;j9;~;0rs=9qA"cjQd$ QA
fh  nb@B1 tAt=dtfh jnd$d.C
dtfhL   >tShet3 tE>R5jhRdfjhI2>c t%j hc1t2>e tefh| 	f t+f *$!f3f
0č~f PFPh|@Uhf"7 WQh/!3׉F``H[(=#2hd[h dŁ<od V05&	he,ƀ)BoFy_g
g4	xAzfcMKfc2CBha7FP7@ pljh!pV
	~`#eh!fBHz8YIhRh]c,@kW]c@
OY05%hK01!4 V )F!!*hmhTkO	PBD	Br	Tq	^_ !2FFTf^ F&<
uI) u&*_&8hftFFP9 1FOuÀٹ F FIuF)1 F*+҉FV2g+;u;uà3g% ;Fu	;V@á2gG2@4A996g%_ 
Ð7L*	6
{ WPP@Bj'@,\ f f`/2gc/ &a&cjLfPAj FPfj h

R苦[]P"1V=ut_ V%#.
GF|ǯ  02 S|W, h & F GP	FNuFG0:?7 
[yO4(H!F  a(qtFҴ
v2  1p jvr>2aI*bf?һ3@6#nq_r	v	$J2&ߩc% 1Wc o)ZU

92aFPmu+&c53q?3ȉ`Z	/cpaժb`ʛ	2&a% +1a1_aj_R{3p%[2cw%  c10KjA; 	a
Ft2`h~ Ѕ3cjD
 E

C @	HP 	Na(g<	3ɳ1 jiTX 
ȢT(jS"
 U@(cj~a'&ccRXѮx2UWt1:	ar$p_Ft@c t#!yV*@z"ƣrP)c*A{#&c/cjTtrA (qAc@w _&w@8 +?OБ<"_& &O g[ 1	߁j_ RdƫW 1hfK
a wfp'od t}JRAH=?A?a  p^PpF2g^F  ^F&F~
r
,e?&"e &h` &d^߀gP@ f~@ c?Rde  e# r6GD ΁*pU`E  p  V6а^aF@tp)t_d Z*tT*uN&,e"e he 2,9ʀtp"Pkt ߃ Ѡhew@tO
_duUA&`{2 $_&0d&  (!og*d!r΀&d"cŴ7ofitD@.Fw10   &dw.j j  3
vB %#rSzFГzp_
(,_B&f"&
g &fav5&{ +&C!&u)&Ƈfd rp |ehJg%  M"9cAKx@K 9de߀&eeA_FVD.A_fc0}2ae4d	s$6B8aT :K<]c6rvqS0u`,de شeeOF핺)@t#yZj$	>jgZ	Ձ de$ <w u @<@/u""r1=` 1 e a(94>14!f@4G(v!XeA0 }P
t%rc̋F^Nr'~#tp  u^    %  + P`ߠ)^`  ~u +ËFV VF6Ƃ6~ r~t` q~uFCfv
0V32,pIuquSIXX[t

 ^F^ApaظL~  f#} FB F~P|v^ KF{ NFFߌV~ PHt@HtcH} P )npg0謁6^F&? u <cvA8>sd|mhxcΐQ$RacV;a%.cvm.cm`
NNFpev!q齼$Fq*?gFF R?g_S^ޠ|/GFPv4AvF?gFmPQ1coaPa?:!Z`dB_&@0Uc16`b`~2|FtFr(QW^
4~`4	b-/ _`-P+FVFQC94%~ t;׍F4FҔ0
z u WV~vN^?>S
A0@
^_C
"jY(c
l`


[t ,md(|WVvԋNshODRHAA~(|W~FIt_~@u"2F#}HFB^F&W} 
 
.APU!u<@## KVkDiaҶ
%%		 	F*Pg	}`	
 g<d-UWVv<~P F
&wGFq&'h*V~ʋv!^PFߊGIub: ^&^&8t@#^^}۲h!#ù
 0GF N% }p,-Ar  ~s԰ NFN+;u0g03ɋFpPAFC&PfSp  ~0gЋs;G^AaQFp ~
vД@x|r
CVV,GV~^&FIa&a82jaFQ2Wc%0b>"⻐Ikbf?BN3a3#b1!
= r	v	$
a2 %k 59b
oB`*PV_#?j`2#	2&_a% 82o!2c% 2c1/cjA2OpϪ 	a2/! (!Q023ޓcjDEӮ
	C@H
p

Ns#ST
	 U4	@g
31 jiMQ,pyXr~y*z{	@*	{	[ʧx;(' &ccf`f   df	 ke 0 g .fcm؃[2@B T Kc]cFr	c`6y Vi@a1FRc4CS0B3~Qt8R kߑߺˣ>j6hhLjFc NUPe:]>"b]Ic	?@#c,S UƢ$+"9WoyT3E\A	}j`faf	ff؃'fcPXAz@ VA V\a$CZDxUE$
C4
?
_HH_ 2
NBUac۷B %5q'SpF _"4ɂgPL2i)p+~0PzryL^2	zB
xB&{
q;;9Fֱ .Bjh!Xa۰SWVvЋދ~ &F<t<w
brTF*;a}7A~y~tF&8tFu|t<r2$VP^Ʀu	A(|NÐ ~Pfh#  PF;rF f?* F  F*N*ȁ vFܾP0џ"v`Q
u+eTf^F  FOu)	fdf &dfwctmfq0  R*&3g@w2`% 2g14gȾu84= +N32g33 Љ  u6g$<u~6g% bpu&7u]f2 % DP	u><uB )
u/,au#aڲ68g#FOr dTfUfVf WfXf	YfZf[f
\f]f^f_f`f_afbf XaLʶ f3 f  Ψ9H_ujvRPp- H_{FB~2|ۿ1~ĠF  p ~ uFdm
 e jtWV@H_FRvKzF@ b*J*p
NvQWV詑qFFP
|Fo؊f- oh h
~'F܊f Kh F֊ft@ t؉FjRvvlh 0-~St` su P0M2muhLh @h߀ FފfPw~sFf KjuM!v:;F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌvoƹڰ\؊GFASƦư {|^`ഌ 'pORQ0AaPjs, *`
- ek)@@@ NV$Y^p|"[([> [<1[劆2d$0   yq$mj)!fP4
CeeQ A2gu u fЙ`EŕՉ6*qV+- t*-} t9K4!1)3o$RFa+2 OEOboLrЁF 40#"7g
1-1  GEBr{/ 3|
/@+F+PRquH6pd qa"$2@d%໪c2g2 ka`a1jLFPA> j)"#2#"#	
1#C/]LDE@WV3 WD\^&@RFG|吋3x96+ 2 R& FW1<` r<"JW>
d ێRݖda~a6  &=  t@M[_  Ft  
V"Tf#-/(/

	
@yu	( L &O&TЦVP{S~ t'jF I  t/ u#'jfyq`t= tA:?@>u
,e&he""e2hwe% 0he  t&,ep1`ul À&l yfdxkf egfeee{e>gdaPaQadĪrdհ>u[h hJ퐔h Z^âp:h@jBz肪uhR 	[z"		N	
A
ސ4!F* FLF`Z  @AL62X 19Mpb$< w6rud" rAԀ>dt"߾a`&ca
uc"&c	Oʀ>rd uzfh  a  {PB@card,c
\!F$ !J=
u< cp3Iupv tŢtrt$Btt`Ra3+&?(u"&Rup )u&GPGP됽F^ u
 启fj
 0 	{   (D.~  / u p݀&cEF`U>~ tf Dj j P P= HtVjP M-
 -!/봐> ~ H	둺;	~p	9	߃>	aQ@6ưRĴ &@uO3pTyl  	¿&&G&W鱻lp[D"   s- ;t- t- te= M-H- -యD@ ++fjsg ? ;@g~p oJ_p "f vV>   vVP*AF^ VP% 
P h
 h  yRaNF
+F@pF!vvo`	FJ_NnQF@`{vj qCFPNQ=`*P!ؑ`VW  ް 3_^a #J_%A  S!F
FJfF.
%
_;F|!% F@P!]aVv р`NcF&< t&@A0FAu
 )F~u<  tFF7 PF@50
 f=#4@@*`P>~v*VA ;Г2*1 ufU  Vn֠']`!> tur3NFAY F~Nَ&8tGr vNً! ؉^GF
&Ftw^ G f +tp
뎐V^% = @ʃ@A3t`߰ߋ@!A;?w">
 u31&A *;t{r1A 
*/F0 F
t t" 0`fp
V=O:`2P.B@A͟?Vu	.SEHDa!E'(E02rVu`5 3
l	Sd7RP3>>Q XZB~38tC8 u31~^
AF9G
u݋N3~({~ q  F;|Ԁ;pUƄ  ߸fUVNVv<%tF` u DD^ù
00NÈ u0+1WRP MX ]V^tQrJ;v~ F^F&uF$=IW\qQb]R}   P+΋э8sYdvva!VpN&8 uN&=w t&@*A|a0&1tP߱+ G0 !
`f/+IQ kqCTNi
ʐ kj ##vAD_
&F3v~Bv0JQ&ğP0zb;~ANuv 0dFa 
feP{0VV -cPQP F ~ ~
~h3ҋ P{W@t4>gPǰv~dPq 	ptGWy5ӽ"p j9FuQ_PK vv#5~@jFV2#0NvD"F9F}+F- P@!b' Iɒq YFF`Y%"{ nT\QPEP@DPAEEP:Ҁ! fh  39> ~jy/0`*9Pu	RA
@0
A/\&7%6%'@2)}
G;|2*& P c`8(F0
A
j Qj V
VRP=AQda'P? WV9< n@]Pac E +FWFVa2#
0UcSpbyf 0aDPdQ虡xQ	5Q`,+Fϙ+Ѡ`M*2 Rg@=D$=ӁF3@**A;}RvsN`V6r1qTyg*@F;ﶋvwP) _4C
sR14+

uK#aQCPSfdD$A84	PeVs輡VB1r~&-24hQR}tYAS;}`=y#DȰdf&D&TfF3F@F~
P  q &Fި@u[] ᐡF{tdF;@]Ɛ]q<ЁN; b®PO;v}vmǑa<GF;F+F-	@pFF&Ev;v~Qm~{ $	;F3F	_F	} t~0V=g~P龐tOC tG\'F
t/* F T9F}\LF ;F~AZM
?~~2G+F50%&L
q DFF 0W  Ϡf@`	PX f@PwF^^UEAgTe l2s|Pѹxb<FA@ o0H&v7QvFvFꎐՍ\Pɒ #R@~ɫU 3'tsF+FJFH鿈fh iR( tT,T4Kv/ .9~4aFek6,+F!}=pu.tPoq &OC@ +σQ._+ǀ
!0|ctj[|񈺈

FDB.=Q oj]>oW0L# ' ۥCA& !!pa2#$QBC}PPCfzfpL@>zf|fj qWw 
Ht8-t-9t- 	t "fޢ 	`!QF~ tfFfzfF  F
Pj   v
u}Ӌ1Aj >PHPV`s
Ϲ&wc¯F/tB$P=
Qи>N	VV2ٓF
t\!@D% QD
莡QӼ
VQ6 B tDu遌Ǡ
!_o؋!bG C pDPk*. H!MbB`tu	 r QSGg	R4O1maiDu(+Huu @uqt j	jfh	m	"	P裲V^FPqf~
 ;t

>axQ-EPzU@: ]FY m DVVjv/vxX= 6G w]3?鲯S002Rr~wFR0BP1q*E~
G jR[807+$ }p  9]te #S#/E=/`a/FFP9B \ dpg
p; ;NNNQP @C7 Ƒ򠽋= K = ;  -Pp---xАWp'Fj  ܩk >f`{ Pi;v1!;vFPVOW>FP~FPG;/~~P1% - D- ߄*-ࠁ#- " e= Pk_'-
|5. G@6- ;sFc?atU^ tP` zFa~9Fu
VVIVF]v9vu@XPNPN  PNNRF ~9~};V 9vu< uN0빋v T` 3P P|p & !VN;
uڐxA^F;~mOaXS `
$~Du6f b;+|qT/QN;v}O;6Vf~ uFgApL怰9v;|GI0Đ0%9F| ~'A^&+^& 'F'302F`g!ihj@vVt ;tto D@gx3|f4Whyl
 rz/~I>FWV  Gc de tWd@ @ l tee
ǫ|tATDr\[u0Y;F~ ZpӁrջN@uOp0
DK=2Np>d u)>e tl>g tt >fc t|c`hb?0N Whp.u"jhahL_ i
j(h!fh^_e?h_ j _h]ch_K _T _}zB _m#L_a%^ !fB"	 e% jes% ]cc%	 KcSz%
 TcC%= Bc3#+=(`+Ͱ(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhoНpt1rt߀DODpU*䊇>AvuA*HWvAPVt0<@p& }554465245rt659hӾ@E@ jpPVCpWV_h
	 !V3j hD	~D$Հ`HtHt#h !x    C wt^ý f	$F~ HtHtHHt$" ^@ $Ѻ&&G<P j 4	G+PX
G>U7x@n ^]aGP0v&ƀ ~RrjV6 fP)3nP Ы>X F`~|֢"®s}vI@x	&8 tr
9GPu   >p~q9	uarf   ^f~ t  |֊FÑ!	eMٮ	L0#	Ka c 	3$0(`(hpa^p3&~/tC&  v&8 u*C_;^|ckÎF^P9P8P`^? tvN~}"v{`<1
ރ~ u0fDFG&9 uԉ~W޴Rr0~F Z= ?-
 -_ Ү<5 1 ;uJ< tCBtZPU-
tKŐtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@Fk	 0 v% t" uNj p貁F  Bܲ u
gށ?MN3~*^
7ފ 8&8u	F;|?`̸,Bdnߣ
eP $
Pڋ PPC 
Cc!
d$  *8fudg"^u Q/	tP3_0F |n FPf@
t)f3fn @Hpfh 륐j h0`h` 4$u @3l3 1`F*A;HtϠ5= t	d@ &d鵫 ڑ.dQu鉀&
:	@
ʠ
 &
&
hHhN
ho ?AA7B 
@
@~ -*

@5q&
 3F! "&d&d Jf]jJf!B"  _FP~H AKN
g3a`#U\'"%0$:GBHǿF_^_`^Z0 Tč&Í,W3F
46 x$|d0"dj(Ͼj 9
P8
PPfsOV
b}W&*_)^@&` 0 d t&<
 <)뀖 |x
Q %'@q<`
! Oƙhdj  %VcbN0Pff3	諠_%  P5Ѐ`RB/
?
$/*0/z$c30/04R$R"_RVdDp%W
d
aH*=	- I- 9t7-
 wqrMt%
- Ktq-Mtr` MYnp= d.&FbxB,2@0`  8&_0'ՐR!"Ր^,20` = 0PXu/1V hh ST  9YY݂Yހ
Y&"0Zd +a=	_[Q["
@4z |o
U!@ _d_da0y y Vfh0/h y Pc@t&
 W
@ UACUCCUT΁!#!
@d_d_
Ɛ޾
r4C( + (#~+-+tp*tcmKt
- tu] &3& tGђv 1vh^h
hG P!wuc
j8%A#&A
-C@#'M$'^a'a{Ðj˞؁ yڰ @&
)3bPf w
0>{+>>G>d'>n!>/>f'>< Ћ5GP$pD۫ D:EG489JR4"" :L%9W
5Bδhh͏ V2^Du+! 5 {31;utX&s_S7AuA@A@tR_!P!_!
@>P`O? 6`L.ࡠAL&_P`~<!Q"Q Q*|3ɻm &Ar?hOEӟ@Qup@	{XrQU݀UtD33,i
; YKP`LmrFv!
or0t$Pv0%@txDP!D$mD`
P#wBf~O$x0%YAǑK=D=H=yMP`;Ա;
fhZ " [BGb %^
vtн
]
ct,W*@t>t2q *``(@a@1)@v+AER`ŏ9ƏxCQ # LғƦ $ 򗶨$%0@04p@
%@tDR~2S6V$
2`~R`ҟ8B	S`vuvTUPT	b
A
 05K8$   ڡ	 ̥ڥ .<RZ H1p  AЗc!@] 0S`0uS`}b"뱤Wab 눋R` 2 1 ;5r1p "(9@( f fcEWfh  _!zfcfR`&cN&..@SR56P6e!7U>d>8FF% 9N$NR@fdfAcu
nuvu-du$uu~u	V@V ,ǈ"]|rh,2;䐃voF8FPVh@PwMv_
WVO 
1!X` ^HtHtt-oLV!B+ f@!!b?f>
<¶O13d %\B4S 9@EET'`eE|tG:lEg@C
J
Ŝs( ,f+fF@ ؀  F估F0FFFR\|D>== p ƿ -  -tRp   -ݵ -*t:-`ս {=+-B `-j@Pt}qx$Ht/Ht:HC 6 Pۢ c( !"!13 Rgc" 'ހA
Fy
t)j UPTPfsV,ttp? ;Ґ|a&yBY!Fp *HFL~f fFa^vfvvFPv{ڐ5Fpu63F *~%v슅a _:uFG;ǏF :a~ t
&x |xP ~@W&p! U p!qq t&AÃ@̌?"Ht)3Ã?@A ~pr}b|ɀ&X qpV>X` ucuHj 
&3v0 RhewV`ff\`f ` U| ܄ 9FhDעo R
V`heᠫ3`8-9t- 	t FY`r
  *OXfjj a
#5	1	u.#JN1uh Ɛ>` tu!fh  PZ	-NVR>| `6
LhawhB6a3`*a&_ | & ?F |b ?rPpSc}A >p#}u>p\t&el6X`豼w  륃h`te3_,a13^
>\*u	> µ0!jj2>3t;:73Be'kJP t'{80:2R%4;44Z
`ǯbh j@p@g@A!F@[$
eu$&4pQ*StS?=<=5
5
`Kh@a	@Ba	 fh+rDW-q(p|pJ$Qې#;$ r%\/P&aRd(a*ac,ahe`P"r ) c%  = $Keaf1 L`2 RJb
b
~c
XrՒ
 }g
Pg
 

 Gw֢A] Dt,-
t%-.t,-	 tE-
tYt- t/PC DɣX`:B~B _ }y  oU&Viet,eu& riewtu
q0t`heҪ@  -Ǿ@ut ;>}`  Pr%/h	pj;tXя60cHtHt `t' Q 軽hplou
^_  WV3> N3һBrZ׃ґ@FPWr~Pur
NpDt  & Q ׿FV^tF&Oud,,0,,,,,p+,,.T>uh hmhE h 6 j v~
B"@ts) 3҉65?Q@;@)}F~
r݋F 
h´΢	
J襾
Z豖 5#W<B6f
 ~Ĳfdf v3ɉNv~FV
tut9v~O|܉~*Pӿf.a^?3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3Vs~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|bpf:afffI&XS  
:at&
S
 WPjt	s0p` ^3

tF^&oF!u	 |03$NFְ#@
hEP2pn{GW^r\F*f+}= 0=a -tX-  - 9B m= M - t!Eh-@  Or= E.pʹڹ/ /  p- 2&;a% +11<a :a:a@ 3 ֐j5B jh
@E
 C
FPZ/ /  (YP)@ wj}Q'3
|^'G`h2g5؎G|S.aAc.a2g, :aa$ a
0&
c
.Q 
@DM
F@f
fh0V" !{B
p},pfh*+`w()&' $%h#fb\rc t
Kc eu
M0  O hE `F<tF "7hڸ"B} by^_F ۄ-FC|ߊF÷>aGͮVAװ
>aO@aa!J/PFdq`lLQ}H fz`OeO KUS]RU)D
B
3HT4PT	^Ċ70SdBE

H
<U|F U\X~Q_Q
	[(t
R2V@2A `
TBe5ephhj$&%l4"65nfD2pFEpET
BOQ
y !\,B`C`LB`fB`-
@- `
- Kt <%_Pc_`d_$___hĿҿ&6FVpz4,2"5^>^@a  zab AB  !" 8- 2&?dcld^t d@TĀDa?-  3 @+- bu	i]c )#@  
#j+{v qpo wb{ {FNX{@ʣ~"Lcfcf>ncpwp@taƵ axx`ޞ `&CADTPt &hD&? _t
&ؐ
`?@U# 

UC	@
U

A C	 @c:Qq@t&fhvo+xհ@{{n~߶fhzh0
5}4R5tfh:}89h7R/^с0vrv?=>h<^@L`	BA}:2hhWVde$ < u@a@<@u"d s@utA;>`  *r$ hh$-Qp1@66Fa+ =u%///)Fa/R+3 (-AҐ:PP%@u'$F P=c= 0Ht
q j r j賝6|@uf4腱;F~ w ʃbrջ|N@uOphhB[WV 6WOp 
nrvƐdt
Q &"F Fdt &Ͽce7$οKA8JM&PAD@T%V%} _%T%&rhh }$ 'Fc"HaF_& *HaPeA u$2,<7 hsh:<9  t~@ rb` zj~=  TP԰0 jP,Hazp0u.&bPjj`ޤ&rz"pq|荐
F@0#0000H000!,a:kVfvfhI
 .2u @mh bFb:tF&<:u-FF
*0N&$x  
u3ػQ@C7 ~ uF	 F
  
 
 <  C
v`
芵Pjq<L^P
RP謢
? 0
~ `~ tghj1v&~ tD軪`E=f=u=5 
`
 ^3 FPPP FF9Fr ҅qF% -
 ؋0v v sd ƨu = wѧɐ>JVbnzʆ~FPX.ac y ~ t 4Fa    R F  :ޅ .E {" / 
Qlp~dzt}' 趄ƂOFZIZ#3^ \Lo*1hV$.tCq u^ GCauK  K .g"ǹŁWI Nr@~u~_t W    I t@FqqFV!F^=uFv2N'22g+7@]WV6ڳKh*h萸y*Ny fyfu}oyDt4H-H4HSHugHHH7I2yFIP;9Az"CLzDzߡza
"zj &z<f+fF@ ^ o ^V^KFP6aLv3+Q OYڀ?`- t$phfFf~ sAGuh鵕d fQVaڙRPSQfXfYf3fffPfvѩMF j!0}АuCFpvh  cYꠒ!u"uƶ ufE  p P0  V6PrQJm		% 6|aD6Pf\ 6Lf|< ub)
Ԥ!Y0Ð3Ð   MHz` KB`SIMPLO  MOTOROLA  HP  1.190   K    Restore default system configuration mpleted!  a) Press <Enter> to Shutdown ]S...a <  driv?elock V`B C 	u Setup  <F1=Help> FilesInformR  Display5iSavefloppy[ diskette= from +(s.Ign2hanges and exit EP  s! witho}uaving
o Securit@AdministP!or passwor:=C"e a/"Power-OnWGpP&DevicedeDgDbD$L $s mart Card%G
supportE?mbedde&Lf
taA!e6'etr*acp",p(s$:aut?hentic;e
credal Auto2cH%Tools Ba /0Calib( @(`'lec`B b HDD:lf-Tp- opDs Activ O wMem
Chep?e r s: ll
31mb 	>>uA@AdvanceiL`4uaYgaC lDt7  of grayq6fie?ld Boow1b..Ua?ny keyUpY ue F10=
, ESC=Cl  9RAccep/=YesSNo D, Ao$r=MpI W  UsSarrow
 o highl@ *he appropriQ?menu iAfqKpcNTER> cbegiggK%#.followM%%k&: tj->  KSPACE = NexBR3c-BACKlvio8"FnTABE3~iSHIFT+&*TsF2@&10`
v[J #'9 Er This60cann)b`mU;d Awn e oc U@ whs6c.de 0x0K1 e jn dApGPu@p0{6}Crequi  yayE`d~jba@%mu0C
mCovP:0 e4k/MEU) hQ1& ilAl//+2SD|`a06ssfulManuZqr  N0
d:Pr9ottyp@speItepp+CacVize (L1/L2)SQ ROM ydd famiaseP8l nu|pi 	Videovis"KeybooFr06verDbI1<ed2e3Bbg4`1qa<8Phip(TdG
W
O3O	*	Ĩtafdai5u%BSNK)$ 1$
2
3	ME
C

V@


4TV
o
D@o
So ྶ:@ D%FPA2d!J#bisFaWalRXS0s&1&H} Addlinqe4 AlHXn.%F$oWarn: rk Tpll0o  zshfTreKa /VՀ, lef ea 
waba02 A: 
de` waqt tҰ_)Vu @rnInv ȍP
)!	Ayou̔ wa@|to  @Z?m  ioa	  0o b+-c(Quick`n22 (Cvre@sʅ3 (S.M.A.R.T.) EP1p3exim@s ): 30¾# g3>0%@v}} ty ho#0#FuprХ:13't4	f-Unknkil䑬WR!mSer9vReaPS)doџ47࿸`?a}ribp	:0`exP9 'b`G H  Olp New Vfyc nY7Enc8Off O  ɥA LA66#%AKroE   `p dV
Ad1 ݰU@ҭ5Ocpcaus7APp(@=AH"h` A&فOpoOwer-.A SQVQa?Uׁ=> loss  (:dYAhou  nlcof aQgoH04)ev`ۢ?[YDocHis9haR`ed?!0f]Dddial JJe HP`"UTool Cr.@%oF8IL` Bk g Uмn qpm`@jtWSN !arv0s /UcwcQɡP2"O	nj* e:Z%%% F@%԰#D
n -f  TndĠfӰunuR?*$n)tartBQK`fsra Par1yNs Spdl?ot CD-Q & vb$۠@yU@	11` aGbourzph҂ u2W!?1 bUSER"MAST xApanPO9`cRR%Tkeep i2acIewph#ysD`<phhaR  7mpp`r. I62?R>
,ҚnRVun *"gFOxOAutoOQcEdp ptY55)0?#O N;
O[?k 2{C,b_pur?t \22th@Pqsow k ebdpPerpJa@naff+bdata, ]ssiblma8!aKpkigi0d!V I0sWPl r mmAM @| Tu@yl,lreplap[@۳o o/*  y4y Xr"t,CoHA= Wy|'qu{me`1r, @M6h`*p0uibty. IfRdo4Ǆw8`!ESCs.!
T V ͲtypB'>'nђ@F10"q@rm,bShxt+  E$@ MpiBjQ  Orpr: U ay OPXrDCgDLb! (left@/hUSB t 1HQbSu K wZipoFirۢo!F`thifp Sixa h ENh`ASwap Fn/Ctrls KTU.S`aslegac`kC>is`7)n0=Pr@riy Vpo  d NTSC`AL6 -J -M+rt
Bid`EPP ECPd2size 32 MB 64a F@pAlwaynPPi0AC3 gWLAN{ D Radi ViBluet h /rS :chHAӡ  SgB@1rᱠNtЖ Ed (%+n,2())+P z+f1Ebqn7)e 1҂23TokRAHp
 kP	M3Uniqu/e Id!fD`&pep   (tu    S`KCalibP!6N@sP D KA.Xb 0B H wO
ELi MEU k'g'MRoN/G/U[:1 :s C0@g . N% ] /C le2  yc 1`dik-d3	s
H

,
* A @5>M(o!ylsSp` @hnologygYadapAPXE ?RPL Exc"Popupz(`@0 10  U2@ 3 4 5 6@7F1=2z5 15`@ 3 "MnB `o_uchpaPuSNon`<F1=Hilfei> piYin[OnzeigpfҠPpweict  KaKguaobVwiePxnLveinun	-hkz
.iKgnepd`t*nt nehP78/%Set#SRheitsfGunk:n`ɉtoa u
nBlt-KuO] Gertesp/--ID FO`t耉7	Usttz !@ 0Qz#  be7im 3st

ng!KAЀr`5nHsvorrq##7..zurck z9
B .p,
Pf_g{ms>ThEx)`Akku)kr_eK tpBsgewhlDD-Selbss@´ItivS9#LtIp;r 3g 0: tppllTL
PZ`OS
q@ PErw :%SpraQ 1a;n!4:#U"gran Fel{dsrt-O& O9!86")Ke SePMbqTa@0, um p_3fahB@i=A, ESC=GAbb!#`WBkze!TJasN0\ , Ja	=Meqh`m VeZ
zpMarkė"sy!*!'MenS% dPfeilt!
^dxQgabe2RmOq>ko?9 c`s.	folj
Bn 
sg:@)-> 0r LeGQ ?= Nch A\pd<-RBc?hritt-`VowA(GTaGbul!fs+ Holl+gedOx F2@
38= {gy EscLhlrLi@<PK kan~Lt we YeiffMgy16P=`?rgetrЮn.:Dc 01 L`fitM B kqcQFY+<W\selnomvPorB]er0ilXW^qDeskU-KsBhmu f 3asÃbzw=.2MobiޯZbgtz%.` Qz qh4Bi///"2f!
}[KAlgrѫ ab>	chlos@`F-M`ll Proz yprtt`wig!60a"Ca`-i-Gre (L1/L2kkapazitOMdPm"Famik Sp; ummU Graf/ik-R0sa@Q "f]r-Con "
A   a?7J	b31O m2O 3O 4d0qV si H>(F ` 	o	o
o1
L
2aSe
krET*  L$ƍ"D%'$b-!3Kc(1  WalkZero-T\<One EdA(`@PnO`D+: bX7 stqbislwnKp  ZEucQN-/aWB _leQb s AteAi#CP0&ILp`ak A:nfdC6
lW$ge`KR/+Pglp%ɏ53 L  8	/  M0$wirkQh"vQM?`|3, daᱭ
l^ie0w QPocF\Lˤ01 ( anH12 (UmfUafdIGc$fhrxdauP(Min.):G 30ZБdS`@0% cgt̯59wuwm #HoPuy p%ubr`"w: ؑH	ԑUnbeaaMTHC52^'rvo-L 5.
32@lhafAttoribu0FID 2u"LS.M.A.R.T.˒XXMs K`kwp eus~1L Dea  JaQ`eD/t Fal8geb e
U	ңBU5Ip dminIoz Dur1@`'@z`|  mg1i@eFN1s
gd,E.@"< ttifiz eq s{0yrt.@s Zu@1`0LzO 9p袓enl@~.Ajb s0Q!Qnp'PlsAviceTa s ,ܠF$0@ h`$pSga|F	 :	 JZΰtfa@npWUm Fun)S7O, m3e\Wn HP{tectToolsP=c^ty MaGnagпUo-- cڑ}- k QuickLock6Subnd$Fr#q\M#"e$bi sϢnchutz  f_-?1dԨ@imd& "+a A)N+ *W"$B><#, lp8$meh1A #I Nk>"ʠo3f`ot-Parpen}imCD-ҏ&g1M!UP:an3A7m$"rive&Ftpla`t9;XPcJs E-=\s mU8unbrapjb'ar.IpT
:b,ҋbewB>SD!sTD,d {¼ !C&&0,	I, 2.8\v%,    H2i<nc4z@ N󝀞}Begriff0diautomLs O75@:ohl<? i Q֩g`yp #ps\V*f ~
T'U!!´!mU"n# OP o"e o )lnYy#OBzs瓡58c<sQy:Sn@ iQ.) r`uM(qS!|qs mh!ac%Cw Pr qғ+`I o0  6qurn׳zhE . Escdrr empf`/qS	 d?zu!тRO`x t.  󉡛  f.МY@ұF&1 2 B 7 b-B`ntra tAdant!Whj`!@Esc-&VlȠ>m kW'p'p`\ F10 `esh:
x3fg`gL sbD} m  ܡ@MM]uBay&m ̀)bBtgk`-EQb(links (1tUSB-b#-2؆ƢSu`1Zip 1`234 5`678 9`QFn/Strg!Pt  ų dEaCГ (USApfN-ZeP]}B`iebss"unabhngB`  cAIAn Grafik?-ContrPrimSek% VideoQ- rnԿBidireba?l GrP |us Lfa`iCb0tzbB
d}r WLAN-Gf0Bluetoot%h9UnU/a Eg{paAggr e_%7(&.(o)u -E`t# 12P3Y5ToRR aC :=A q1t v^Q1I0NqkBoF AkCkuN  `PtaA   x a~  Kalib(  M`k`O  NƘiual_ !  O  k   O DO,rOTra-?6. .O .L84obi!q p9OO5"R!P 	EgnOOf`.[цrІ 1 : . % ]!ablo(2Entl ho3Pp1 
m* 2
 GS-2'@su' `RadaQp0aBPmbƀzA}ExpA-!-Popup ( .) =W0edau Qt0Pd2 (eZ@  Ke`~Compropstn@ <F1=Hjlp>Atoplsys!pVisúne G0til !Akonf@b[GwendPfraMqzp@QrU
J`gnorndr =o&fslu r ,1 u*t`gBOtne k)hed AdministoradAsko KP aodA7 fo% ˇhE"djeG-iSq		 *	v*
J	Sm-k	God0d7elsf 7do_dbycggPGOds -&2	 Nu@00fakis l2 Uag
s)9FHk@\HF Ba.@ġV  cb"dvalg b&HDD-seliv\tPr HukoQA.ainPQ2h OGH omv	Ir/ Avancq Sprog Vl1?s @mo2nedtt felOC4+'/#5l5!Tryk pP7 tas<G0=tZO^=A, ESC=OAnnuaFsp!3=JaNej "J, A!R=MGb Brug pr
NA`RP70we~  releP %menup(,1Wt<ENTE'R> bqec>A)et. saf pPr'f!f~7: -> e!& MELLEMRUM = Nl<-TILOBAGEr!JTAB&2$KIFT++ԻF2@	:*~= Acce1h0!hk>{sf#ej 8A3ku1id0gs 2dodQ)!FF1n. Fg01BRnoVD-p% qpla`9G!krvNvek`EnJJ
i db!?zs flyMsÈn/McEUqoO5 bp* uvetzbrud 2JI,nemfB J@`  Prc c~@or-typ hBigH  ztr`7Crcache (L1/L2HVROM-d@ famOiliei;\AWdeo#f0pds:@Xr-cs]D-ba`si`9e2o`%3o&4Z&at-ta`ofej1E("Wat)	O3OWEw ex{%Ipsr4E$ TyPy%xy l=ydes!Bmis 0'bvD1I'j`Qe0je var0: DB1! se  alt@P02[hold a@ poPdqt`/b Bb-ɊBdqduw5,&pr Pk
kEuGrBA:ރTETf DF%Ugyldig/
t-  <@ngivuİ,vAi av٦,?# i#K?@ $1 (Hur P)%Omf`) sl(`{ (): 30˄2j  `1x0% f3rpudZ44b2@DR 	8cq: KuB+"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5ܐpyCD@F8Ny  Be@}ft nDeae Fra@l !e@+ń 4PR@{	s0FC		ƈ 4D
&KE  beviвB7 9!Cfd~es, f.. <ramG261A PoRR.`RVuAj@me+tabWata. Du bup$AM flAX:Ը viGcehCa D[@G @ߒ[&?0r !,ci HP tectToolo9"jK Quickp;au`LsQmP SkrAp!0rKvt%#k|qX)/sa1-$$ HvisatՀ `w@x6r,
di u.pbilK2;p+1ol p@~frard )x  Cd-rom- cU?:Bg Ho2A%:e@AuΑ5Huhu,;̠ Dq .  bOBRUGER-s OVEDADGANGSKODEN,22QՉLU albtga9`s  n Be  ne]d op@Ia0X'edS T#
{	aMD Clj Ђ D_aBAQ>Nhjlp eutom`oK, D,ZAbyg !iWj?5B^.k permaf@an`Pig`v2n:j fys dsk5 2 rbppc(On @O"k	v A .cBna
  @ucW"EKm/, somءмa ckx@
ҚTut. Ur8d}U pbz(@oPc/cÀ pikoSӴ`@.P  |бbefalkrafǓP apx 'A1쀽@"pl . PAXu	u
׈q  &cO. q#m"J"4,Q/pd i`$HuA0˗ 0.a.j2`:@ENtrA!5ESC. 奘% orPx 'F':ge@F10 FYӄMsf
i/hPcD+su  !Dk Ossrf'lgm vDRRenAHPskm yDSP-bas MultiBay (K0/$hjUSB-?floppy%#{cc{2|wbsqu SbAzip~Fr@aVTr7edj Fj ސe SjSyvRV O Ni \ ȃ Skimѩm Fn/CtrQl E`lPv(a@i`sk)8  UegeUstt!
u@PnPAQ֠ߑrm-cr Prim@Se`d V@o Out ParaX  TjStrCL`ohukoЙ Bqld t 6nr compu 10P0^trm
gAt WLAN-!spioBluet hK/A (trdllo|netr0U|c!mstyApփ&(x(top1*b*Ethqft 1K23KToJR aYHL	pe+	 	Ent 5gt id-nu 2 0ı@  S@   Z 7b/ JKalibB' nndaigO  x 9p6  @WNMH KO OM2[b o  O  O#0 OOOO6$HAgs  1 1O O
1VSi mo`gPa(MEU)J=K= OOGOqOO  OOO[ TPq 1 : O 9. `% ].UgAmt2 AfFH5L)zO3@	Genos	
k

, *  J/X 4%G)g `hB`At `r`bpop{upsink(sek.!HH025f-1T@bgpP`pA Konfigu!2mas   <F1=Hjelp> ilDwin0jons sypLa@3$ak")Hefra6#:p`di!opQ	:k@'Pg avslu!A ,l BDE;sprograpt STt ZpWass@ a/&$OpFA0`:|U'yrse|i!vsfunkur!tif @ԃ%@%-
vn Sm4 |#godkj0RƐ!neby3Pi%it"ot5sTilbake@l#3fabP@PBQ`g
i
 C7;avL`Srkty & valg !AlPP 65;vt AkL MbT !#[SS;G@$π*
`H!4v prlg 6  Dem75bM @ZdtJIel[3
.5E6o%<}5TorykkC taJqLL&pg _=, ESC=Avbrya bBʯAPpJaCNei rP, T\Rer=Mbb `kYneRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMROM = NQ&86  <-TILBAKEPvrig*TAB&"HIFT++F2@	)}= Go  f#l`bWsfeF`  SPk0`pZmno&p@5 PS M0|m kjresvYe!@m d,;@i pp 9!osbaRaflysbc^ 0dS  w}a`1A|rv full1z. kode 02Io|"Produ _t Nopablookk-mll  {typ h@igv&-ga zvAӄbuffN(L1/L2Meng`	Q	Nenu V@wo-ЏTjrNtroUSW,kobgRiJ,oK51 qNi 223"40,p( E
,9(Q`
oa
`oA
o,
NEkg#Iml۔$Eo%Hq ok!i*ps("Walp9g 0s"-h1jH( Adss e7"~e PRnAd 4~: DsA#.s@QtisdlSCholp`@DH[aQ "/he-  &d, rnP}u1p3 sakl<k`nn02A:%ڲO b@Ҽreg1i%HUgylGdig#DSR`	F
	#NE"h0mtEb`?̀{]F igno\3t_te?-  HN 1 (R @nsl؀XbP (): 30A3gg3r 0$s0%[Lv\st!vhF_f!_: Ka"qut``QUÓ5$SQ&eGtt To(Lesb'1Du+q vr{ib: ID301rs<pS.M.A.R.T.-f^C0CC  G#Npu  Bekreoft njAv`l	 ePcᰔ1qrEّjv}likt aDu!0o@C2Ѽ	aXokag3ogs.ror dmpel&! Tp}?ّ.rPa(A=pph. `bkYu  amK࠯#0vice.0u	la?eD(s aݢI 0"~H i HP ptectTools3curityo Man0`r.'-RN%lq  ēlanppa0usG L@$AOmpEr`i!gi$eu beCska u"-U+/- +ӂWE%q  '. tgl`rh,v@=$ڀPŶ. K$RmEp! rfrard- Parll+vSzq1   CD- )FsU1ut Ho $-:Be5B`Dhpug hh!3@bBRUKERHOVED-T5 BI Ryumu0B@EQ
 n0]*RDCbe!1KPP
 0P v@ " 2Va! #
6R,ARZP<0 	!؆ 5)pp  t~I@HOM @ aOutomPYpD!wLock	3cbyggZ)b0`  @]maPqilg ]g%e0.S k_[h fysAad $0GmqW l#=	 |u!m:fnd1]VsQEs Ѻdda g }u%x. U⿲g omd@N1|0/e XG)0zn0q
` uPb}Vnbefat 31G	 A|q.1A,=w A0k1 E5ϓ f hP_!R!'Y}I@7MT֐s wp-QVflans NPBv
,2ʰES#C-yL ΢`rb'fD'<J F10$Z4Cb#e:hf`$ nd  ˗Nor iFGO%re  Mu?ltiBayPG]@y "Q'n7(ve!e)pPko.ngsbahhyOBUSBA|w Zip-U
A A0AaFn/Ctrle EAVd(USA)GekeenAel a	jZtroA2deoP@!"pT;isrr`2FViA7tiࢀ0mFgradi/@trdl |t
WLAN) OFBluetooth j/-PbftQ`mbQ҅ Agss`B	styQ'1_"&2o! (v"*b/!1 Eth ?	)	3 R@NsA'ooo/
8ni|> gtifikO4C&\=B6riQG Ht@    3ymbo KalibPaK B!es- IA09plХal ,-N	O	 I	O	O	51O	O	O	O	8ksp._O	O	O	`lnd  4oO	O	
%O	O	_Cs mob. ^
H.\L. \O	!zo
{{O	B.[ yTAO: La9. % ]!fullC2 Fa{i3
Qi!n/h* Oy  (o J/D
irpk)mA sin hurtig (/sekuPrF12- f1.Sep_ute P pConfiguracie la Com`adora <F1=Ayuda> rchivo  mn%l Sma``pGu isco fOlexicX1pٻ Ra`&sAvalopf@dobPay Ignambios y`li a AL{  g3 'Ln@epidadAse
'  ' Axj0iciof%0posi@s_SIc )$ +5`*KskSm!=C SoqPe*cP#<) Sect}yincor% E 0e"@ 30/c`VxP>6fbrI
aBVc!3nci@])AutomaHerrami aC2}H`er  8P(8 ;prueb_a HDDKc 'EOGVЇ&Memoria2aDd*mp.l1@0JNKRMu0G`SG#
s
 AvanzX`ESvVDD
W? nFampr)co0N gr0<1o?)<UOprim'quitec0g2) Pbm=, E_SC=Ca06la==Acep\ u=SSNK\1"Y, CoN2	=M y p UyB$dchDha6@alvP}  alem o apropiu=@[*<I?NTRO> z qx:N1n.Fs{3pkTYu :@Esp~o o -> = PrxcRetroces<-{0@aؼTAB S	S'a~Mays+#1C(/`F2!-910`rXŠ"8b"uErr0^6F  No@8 AiWGSPrjo u@QRA6K. CdК`01Bha7y nunw>э&qubRnY2"@AC1+>b1 `r(Rp[corUD)JН@ebook/MEU? IXQP\ 2O8`0ple0Vxitosa4e Fak T1ytil TiPsOp7,VclGpuWXTamauZ_0h (L1/L2Oc FAAR;OM mil@cNmerD}ribvisUv@ j6r g-l@yo!!
/H#j1l2n3p4 EtiqurAsI2VeFK (ga`@Woo.o3o`opoi B	Esn!*J8T 5:Z$  ProbU%bssfactcXJ$ǔ =gll4Reo 0poX@y1'	lnedi$l@z,
(CE|`oD"FF%Ad :vH uir  eapn. PreP4#/, WcqscpYcuA:'p, Uu c l Qas ' Ӣ,hp9tegAң
S^@vClQI$`\e'vaPa)00٠o(a) 8!@%c	Za?`ganޗod iAlO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcuv7tieej 2( s): 300go LB0%&~Db  EaH0 _`ipalGirumq
 : s,pu10  qIQ{`3nh7Servof 44apoya atri=b0: IDp#@exs G
X0YA`seaـKHnuevL@)Df ApagE ndq9S!@gOB".X		:@e voc"	ؐk"alpa 
0 Lstnad ;`fRn"]e#թ9 	A*# \A<Q, (02o,vA`Ơbs (R6% E  Wci@R|LLBa hrp梅inR3 S$Bf_ olı9al ol`X#A!vu	jvip.AoQ C '{Ùv?%( ֠WapaAuydAn14n HPctTool@O)%!!&  QuickLockSuspen Blo`^Թ\rat S 6""t mej `eO@`?:0d++-y	(BI	( @!)(rALlRt0,"D,P0X&upizQ,.`xHO;re PunP+roj	o%q>lWS9M9ICD-(
Eec%'WePi:XUsio:Mpu;NmediriveA'0 tzUSUARIO2I PRINCIPALьj oe c&s UaJ7manT p w. Anp2 >y gu # lug3b.P  p_jဈz.p-%H @d\WcG S1
!Qbb;v aYp=O@mc}7PJ67EБor1ܯ?b9
 4: @G:iR u(?s } , fs`m1$ 겞RhArQOoc, G"o~ /]y"<:Xou d/aap{sRcu2bRt	£B! ?1 #zda$
kosag а6Se r0wo0enf 8d lic㡖Ӣ@refaz. &?k дu "`#PZҝ4=ԬFainO} a cjTBBfi t8Z`
`ri01pons2>敩Y_, i0҅ ESC. BP1alab:'Fd'  ,F10B:lFRrfG@ǋ7cT/Espaol OӗtMultiBatNQPa DiPsi`$3-pA  ;]SfbԢsco+d(iz"a(@jech@-5 cB b a01ЇpSuwkrZipcpmeaaewTer Jo C`5t `x SO vNo0 DPƀC|As Fn/`T@ncIngls (EE.UU.)s (m3So}"leA`$1nt!Ac@ GC>0eo Mod"y!  Bidyi0 Tam&mempIׁ͙i#	si0fQu0{ B,P޳ICA R<k*WLANy{-Bluetoo/th IA  zQyyQhoвergRsGCpoos3B_-PF8{(s)ior)Ethet, N0boo0 S 1/,2/L3/TokR@bOO@`P23 IPtifd Exclus`pᑅAJa@4`   !,a*AC~d`*-N@X0S#ӏoATr)3Vh!,o	o	k	o	h	s0bhn	o	o	ehao	 o	o	 ao	o	%MEU 6}o	.@o	o	o	o	Ub o	o	o	o	rB8[ 1 :rgR. c% ] /{Am2 c4-Clē3 	0k",B'* r 9ODJ)o!Ѥoh` ~aБAbbl" @zArran@pٓc#uXDᎰ0gEx!`F12QTAmbTouchPaud`uo N`qubaưub  <F1=Ajuda>yrInfoȻsobo[ Sd E@i?5m!HDbβМR!0
r t@7padr0
3r  Ign`air@A	sPs'&_pA1na	nJ4aP@OaDr%&U' _`#Ɠb!X _d#!

SPtSd!܂υ.8liz/p@ʉO
(I 0@!ԇs@/R Q*?g%Ϡb9r
aut<n 4dcЬealha2@o`Ma (QFeOmPasDg1=i0CP8$!leRߠ֋OpT`HoDD A1)r Ɲ VR#Le Mem@A< 4tactu S`MuW^G[⩨ Av8S%,io Qa^d; camppJcinz "o?CA9`essNe qlr wycи'tinug=' SC=CelaAceX imNKܡ!S, Q%ou<=MaikgO Uti0: sC	qqn'	da o i  apr#op@w *u@Tt#<ENTER> t5meRez[@o.Tgut@n9 ^r u:b:  ->
PAO = PrxiK\<-QBACKCExaQE06TABo$SH/IFT+C%* F2 	*:`a=kSC# 9nErrrOA@,Q@na0WoQpڃmRHE. CdigTGo 01  NPhG`,`:o `+f)  s@ viKCA 1A	bMev
;nsf`ZWotebook/ C[(RWS mGsTe2_DKKXqmBm? xitonzN  Ti0HPۀ3VpcS_࠹\ Tahcache (L1/L2ȦFX a` ROM FamlY  N 3sri
RevisSvde@̠_aJroQLa 
Al!D	Ob a(344`Rtiep	JIOeu6(]) { 7on)oo.Oo$alS~ƕSecunda'$ 1rcCq% vfoi"gv@!mO al  WalkN  0e gy1i	a lien!M!oc0I@Advert: 0[Aqo vae!djWAcqP/u,!i@um  gravv
uu:e)EӎA: n@Adc NS3  >B^hO🽠!QtegiEa	c]
vl0IyI= kT@ctezx0eja $,C?C iN >?ý1 (Rp b2 (A@ng!qf3 (S.M.A.RG.T.ax`=б_(.): 30<`хѡ00@CT =4Q0%?1$bucedeA,qAhosstDCrom1
: Iss-P$Eg
Ch`Ӂƫ(*{erPmec ` `6Q3sM tribߒLD`AМexa@s wQUUig:Tgrg`alTPSLs   qƀL rB+ۤifPArrfDig8cis gҐSAdP)PPЉxacmod!CsާB! fazA@ArEr@a,Πer dfor!m!r3Dn,Pja0.@eHCsHfbrcausadQerF. TbZ Q[e a 㷑2k_rvio 	Iy0rqX)QT?%0Р ur@r0k
ad`pis0S,B,QuickLock!Suspenso Blo0ktB #u@aSM%` mabnbP1IY @k,$$al#.2P4sia eiSib0RPuseu sEExigLU`re*PbM0Q+ &perme@$1lp즅+8!CD-"˯gGP$qme:PDusua: Voc È@gp4@la0vr2utzooDriv)e& t@$RUSURIOBG@ESTRE _FSC%ɑ7q<Vapaz:@I. AaN4P@9de-ФrMis PJEB>p"}@.. NNv p[X֣'6Ve ,@V`(_K` 0+abu:*Ƥa !ECde]D.H@f``7/{s1!Bi屧O7T>WDIAV
l`9w9o  sumǛEf`lo,al Af Caa_erf
a `uuzAoT :aq(2˂40  Àoqur<ǵ x@FkgڲU yaf0T y 2y, pو;) F `3Bor nal|p`#a-t
A^ ˢtEsubtu!d C{ ?@ *hR)ppa۵8ptA-l VJ/qrWL !8Z  Lembre ՚vqMac`Pasa8
"qui_se<`R ESC ]ŉ9Š\q3lav'f'rF10. r`r:MrʷTAc]D u?gus Op1k: MultibayQYNc`iFsi reAFpBa byaФcopld(RP diBtzB	Rc"zipcPrimeirV"rc QtөO]v@N Ղc@aqAs Fn/CtrlIngls (E.UV`ыxS[hp1troahvdeAcund a@hMo#aGPadrƁBiQTazPhBmemO"sem fubw>zec10CA.#RPa 0Rlm|WLAN)` &Bl0oothkAnP2πڐ(a/ Eomeonerga  ere*agBC/*1w62,12oo-'0suЁȰ/0Et#netg	O p
/*3/CToken Ring OObo`Id!fDPPb 3abraT qUSt IsPSڼC!bQGP_NtgemNSrTl1CsrNWDuplo&	ted/	)	E /	fONOOHO'as7AXj O/	kC/	cIAlЏ OO/	Ojb{MEU/	/	-/	G9Dq	/	/	/	O6[ Etp 1:rreg. З% Q]@Oc3l 2:cv0N3:@M* d
 o9ayCJm*O"(sfOlex QScp`xrydapR 쇕 i3Popup޴ Exǐ ~F12( "ߢ dQZs Varava Nu`Ti k yktukP  <F1?=Ohje>PaJrj`PtQt Nytt v0`tu kP Tallenna levykkee !dk@onoP2PuVtF?DFo0ej'unsW Ohק mupA lopQ4Lr  t
tt7f,Tpou@aurlisuinvojoan ssaPMrit^oKynytk La Ityl	
 P ~usnumep
o$-
t lykiu '
,(moPnu kiGa
/!(et  F0.t13!fsBg5*tehd W'og"@t!B$j;A6)ma*in@#Tykalu"A: o9K < Ki3Gvyt?0Oa9@@DMuNk! EaR6npC:m-GdHLisKKieliH O Ik aec o harll1@1Q0= 22R2#2h%Jatkin0jot  nppՄ]=d, ESC=PerF=Hyvksy=KywllEi ~cM, JokuALB=TY_ fnuoli
mi$p_k`ah$@
sics"N <ENTER> mB@t
ep+.!I`Kgn C/ss seuraavU: ->Xi VLINPPIN =P[s  <-bASKELPALAUTEd0fb1!9ARKA+! hVAIHTO+', F2@
)_}= d@!x;0virhvAkkua e =soi>da.>: Rvdi 301*ka c1s} apHrtRPl pU@eyt3ke`"6ko>@	siP.Qlaks1qdиrsrW` kaC9t qlaaP^ TikkI)>skeytyi Fn
i(pO2"nL^o2hPecaGmA|ja|}1?i`d tyypp iIn :fapllVlisQ (L1/L2ࠅU  ROM-Sbmkoh	tuotepe")sar` {W]`si ?stohjab T;{	&!1:"#2o L	3o`M4m魠J`L#taQovn7(j \oa)
 


\	V\JEkA'Gra- Dq ACuP$#:D$ P9a%dzb~ lpi!iEepo3i Walking 0 -[1Yloso`V?aihtoe@ :uvi7 us: Tm`󵐅@atpsnhp . J>lt luo}p2us-  sn,pirj1onc !K A: L"X $AYhk0uV V3beFAG`8p_Cpa༠ ᣾
gHk	oa]Wi `n?a `O  PҤ?ͨ,i`%(N92R`3.M.A.R7.T.@Arp$ [࿀n (min): 30-%s3 p2y0%cL <dv0 Ispysi- 4iVgR
{fb%untq'c{K)jServomoottj
Lau!5ÂvtuQꪼ	k@Fttribti2`З`Žy@a 6eqKxe nGG9w UueVahvu L x P>2Ȕ@	! P@C }A"+@2`s@a	,-ãPAJrn4-okkpDad`5an /)inDP -e@7p$Rmysba
`k 1h@`! ЁeT@	dE	ZEY(O i0Xj [!K unQnwbay:p\veapahtum"b@^id FLaJ4tii l <HP PrpctTools`cuQ`Pger -GapuД큶.f(-/U i` n QuickLockfa hlu5 qf,V "@PraZ&-8Q,:*sekm #o$j$it)a{d||}yh ' PP`0#UC.7>uu	SApor InfrPnR% C[D- -!fl ~QԌV"s ŎPANyjUWAiot;\"nn De"(1o")Jlola.    KYTTώJNI9! PSSANAN,0IBfw.la"q %sily1Mgur R7qg  gri^PfaZꀝAt]r
f$VV-`$U,Ap 8 iwLLAQ0<ѨWZ& OPAMA  Qops ) V
 suE=4:d,#tu@>x	 _4`o'lA N
E  U7lE r
pRw%y iC. Nyky 3b`+mPezsv6Ar
t  N. TmttS`|q$ihveip=upe1rRU$<eh?  IPa*?-@l@wp[1tЋHta1U]=c zAojAaiemlV|3tp. Anm "P$PtTV@UG. 2!`ZX2qїaF_`Qy#А ek rm@o#\X d,aT0ESC-n"sR;n,%'¦e'> F10 ŴY4aQaqw:	o .cVQ llQݠtmiA$ys u"bn MultiBa@Opc&Jlakoiu (ƐenA/$oi>P) USB$@)ZipEnsimm0 AKooelj }Vi@r}Kieit@ְKa0k Y Kymὁai Fn/Ctrl"mhAEng(USMA@UsPs#inla!ǁB- RsఠS Rn1 jPBsi PPs Vo'lh̙t\Vakio0s2sNb#Ig3uuQH Dpl verkko
WLAN-ro'Bl]u`Voth @/HE@h^@sV@Qs	 s`9l@@Ǝ
|+1`i<9.2v+-p	+ ?(ylosp*OG COr5EthCerPn1E Y oeo3o8+To@ p#gOo(@workQ#%G lH1liv3 AGkkuR < TAJq 0ѿ r{jolibr@du c`d  Wual^-OO  OI OK"kb_OO  O ONr O$O$O$tva_ O 1 O1 OMЩaanusBkOD OO OM"OOO`O
OI[ e`i:r
ada n . Э% ] `ODPW2l ur00&OE-O
3
FGo@MOH*  j ,9@ ƠаBk F1vuCP` ɐiư  '(se nA@S`: F1S2:ٴi@P%3tappikoskePPP. 'mmaK  Ei mn Configurati3ordPteur  <F1=Ap> Fichier Infor m Aff age Sauvegarder sur dis!qc R@a*r x'uneA.H_DHeals dfauow {du'Igno%modi Tpqu S$e l'in`p$@p@reg om	\ Scurita%Z
e ssLd S"#j@e sous te Ion.D
 priphP %J	a sEIIDy'As
{Dr`<Lockq
Smp(CD0 Br13r3̒  'heP5 Q ,b#a <ۂgre taR, 9)+5p7am''us3;),;rfrencHM =``t"#Ou@[ !@lonnLb`beriZ sle-cqSn@psQBs AIATA$ BFoV,?mmoir`hc BDX C0ZZaFB_V Az0c`oLang4? ChoisPJ Ul3Ind)!5_mps g! 5ePMd.rpa`k2Z}:z? AppuyDfatouqpo@gezu@l v=Ser, ECHAP=AlH>Accep S_0=OuiuN*#Q3V, N'impp_e``D
=p0aw  UrPzi3
s f'heM
mo!04ecle hme;nuucer@r0wbri2qh@z!y <ENTREE>2nj+W	ss	sui0@/fa  !/ :-> ou BARRE ESPACE = EPBe`-$IEpreced@STAB`CA*'MAJ+ix F2 =1p"w-`$!S( rr`x@P<TJ Il FA%ssibcQ7L U cs='Jprod{endp#B$P. kCoa<'401)c5CntP@-1 empla3ce(L' 0D SaQre@}@C'y
GJ 
s}^ccueil dн "4 itaxsmobia``
W 
u` B!OOOF2BfCX+)a wru Fa0;cq0M\ TyQp0osBV8pwDb KTa@rcaa(L1/L2) VGolu`e!gD o ROMOamR~ Numro#p	Rev`cdo erS2ItrQclavpoLA}ud @;n+/Zp$/zr3/t4n"3inv!/Qzi&5 #priF!L( Ute)OOoOOOBV'edA Eo MT֍ :$/.   %Er4 Q!SUPc;Walking 0ᥒ81l;ig'ad`aauZC	od g al0ifAtip1SC[a=e@ptcruA ieЪvPR! /0簹r,  mz{ nroc	cY0R]A}jDL_聡v
 tro Pa
0s
TX	  _D[Rvjaˈ"`dH.On m:YfPS 0"Ӏf   +-AvaPC lp  ߚV ? Igno7ꉈ+| z Enregeo#=1 (rap`)#>2 (coet)u`|pimA(z) B30堿s pAU0% nv$D9yl'hA+bF  `:@˗	AsGinpnud'+,`v`t
$.ELu( pG3p 5A`ib!O: IDP0ࠒ0@"s S.M.A.R.TAbanG2WpW AIBY`se N!=apYeAø?/@;sa#A Mar, uinKS ;A, e,ecoac	;mme, vK*ad11POobPbatCs	eSdp4D	 pe>a1a`(`ifh s4[,p@s蒵 `Ug"  for	mQg-hq#xRѼsJ.)rmQފb	hJU@0`
1AJ.6zT"`QDP~aR avoupR!Afr Cww7A^	 	zY R`(p"}ff1Qd  k;#l2TcgN<q`rHP P`o կTool:eRyW Mar O4K8CF!/  QuickLo;ckUsusA |$cp!#ri 9 س<S&ocl'S+C)re!cB!
`Kp)!nk:,   v qi4//  / L'(a'a
S$ud!v
 KP
dra+D hn 4`ExiAudP `  4raQ8llƙۗX C#D-'EǞ8VpalJXd
¡:!5pr5Sfe DriveA). SS@@@Ade{z deux"(UTILISATEURPRINCIPAL)@!D犵	Ъ"r R䊳N N:z ?I`!@~`E"Q!qhsr @+lfe/"celu&MsDordi`Bb. A W	z(@o@DNU(Co cn0 U@fet#qxI+}M"+t"~"asW"qmoeP: :""Bt qD)<Z=Ianiq45#'Oǅp#!2/r,"c̓û!pk!  3PߍIX!$! ܐ!!{ e ZQM7j]%uelП21`2܂T :HD,g" ""o }a8kE
O' f@W'!b_^w# ,d'originIl2v`O"2Cwa B	uD
vqSaP AQy9)Pt0M`
5djabvps{s`Pze*@-$݁WQa0prs0`Ta aon: top@TP 2ԡa3440pab0yt3ץk'
1uj, appuy
`  ECHAP. @@ OTzR'~o', pui`CrDF10 TapXc 1xCxY^u}	U:/QFrana
OgvACJiMultiBayulBphA 1!3D,xsoca%(ga)pOOFRz) U[<8V USBfQpr
jZiprYP: Dhit@s QuaQCin`NSi;xi Se ߑ  Hud NeuvCD`Perm/r(s Fn/Ctrl`s AnglpSOA) Poprm1`s A@stanPhnfROd'ad`n el!trl:3' Uich1uer&mr`
*d :i@7idoAѫa˭Bid`Ԃ 0 m)mVl@1jEK!al ږ R o!=ril WLAN (rsei{l)AgrBlooth7S/?1 K  ;o`! qg`N loc 9G ``!WnXԏ-b61abP-n o82ooypu9	3ccu@jodogB Ep!t # 1a"23TokRingo`oU/Id!uT6*ao haX  /     h ll` n!Hre0/ x Ab!AC.!f*Du ph*/) ///tb/ ////* *-//8/Jngn$ , /,/ /ce s` BtkexЯsqbmo P//7// /,///7[qRpe 1 : Char. % ]A.  2D` Gic(M*n3@	Rkio.
* T  @@/M.@$oOAg$Á4Amor1cFe"5 RetardBĎTexp `) Dгa  Fs12tposf[iP+Aux/  PatqbAKw ucun I@z!Nl1 <F1=Aui0>`nfo0\gema	l p'Salval floppy%APttoRipr>Pina dmThifAap`i |Ignor`daed esci EP a
l'iI?z`ciBPŷtup icz{za sswo!%e am C0rato gPccsP
_QC*vos7v% IDs
Ҥ&gDriveLock	LPr`ǃ)S t C7 SupP;  c30 g@HQg/ o+:,i fabbrP
4=i	/.nzi[lOco
ruWi Cb5<b!ae9E`lrOpa@t2;o rigidAEtaA'V<â,a mepT W`<HKJhMiM;A>op !Ava=t Lu!O l$Dim"& q6ca X sso eviQ 1g	vv!'#o*62wH8Premi qsiasicsXperQVu L  @i=f, ESC=Annu ,aA Etpoe.o=SiSN1T,altro#	=A bj Us"Schiav~I frecc'!i1`voc<u ap`=f"_`<INVIO>  \kZ\'e.ipYgui  un%: -> o SPAZIO = xsuWss`0  <-pBACKCEĭ`c<ؽTAB@C%o"M?AIUSC+)XF2	>-= m "AC"IErriS0D  Qu A87npupvse@t"ViO  v@u4T|XJ. C{'01 Npu0F>9|a0 Doggiao Lk`IP'0  Q>re0
z4Es"@agga%FvpSAcғ { npabook"RQzespa jT:\ Zf.atp1_
2o{briuPrf uduA NoC  Ti"+0<PS^pVeloIStepp@YMis1ca(L1/L2 d&dDbROMIamiglk N@o0H`(	RP[3[oxi#qSroll TsjrAer H~i1OFk2m3n4ࡐ7w PVSTeP)DE(d)8
	2
3
4摭xFonda
 ,o:EV$ Tr%$OupyP!gTpŒ@lliASprB:bits 0t 1ИRindirip	i]  `|@'uFAЎso:5X%? gger `|vpAhAre!0M/rѧ, `1favi PPb`iVYXA:'mU[A:"maconou`Ah(_ IISɁQritVa] Nsv@dp RlIQOyളSe3 `voPga ?AF0bb iQfre?@?: Aɐ51 (Rap)62 (Complet"2tio }(): 30>0%Q5"rƤ6ar0䠈'hD5|:s *Щ-@
 ֤(aD୆%aerv|")LċAPLA'	rib i0gol: IaD$Ban`de@z قi S.M.A.R'.T.!ޱuTx0U _word9c(nuo!i&2 pDs c(Ui%LH?bq+d`ᗑ {â"Znd?՛O .A7Tcq^B&
Am AVf! B;YECr	t>J&2fum y3"CePe<B #Eu _t0s!1a.Q]ՒbdFo!erqdPКatiwEff+Jizso@in  ca@2ivEvPgaζOdesХ @Jm9Yy HP tectTools Od.ZRV2+ ickLockspen`3B05EY. mou`s8 MM d?#<#,p  gra@p'!oe -!e$C-))`v!pKsm@]H0x!! b	,'URar i "lі@NR(@@|ГV|a infraQ)p y)o CD-" Se$PDFVp:W <!SRQ#3ęwusanD: e1&. D6AF$<P @@b}W'UTENTEPRINCIP?ALE  r@*रa m3an4fu`o. AnPV:FcP0r о a!eQB<p0b:0.l@d0AAuULTkZs,^h	Q[m2H sabR; 3reDV\b.ALN = Q_o0%54 dE h=>Ё`@
 >rea,@q  d (`8t rOD r luogo DF T!B'     #h$ f@ER#:,!vE</ sI"I@5-"̿WpClv {s"k mP0!R/DaB  /$BH @xQE~a(  ٰa~DA'Pa gQ#}QAi  	Pktat{fa+ ueY/ cdO::ly&.2nPCqu_{9㐓!. Y)qA`YE	snOP䮅@K1'56h,mP邆эo ESCƚM9'Ý)dovQr 'n'pom!nF10. !n!k KWyĴ_6\%גPt qIP(i 3G  OA:D0@ $d5m MiBay ba1.ggas$Z) ogC}hi USBژ]$Suk\bC
ZipBP6o ;Terz `OЁvN% ec AН" Fn/?Ctrl TIngl  (OUSA) Yi u`2O mp!l 01aЃ`R7pl Aaп 0Mo@eQנ Bid0HCapa memqX5eImbs"Fl@DQ2'c/wNPs (WLAN){oBluetoothCommu5/ U(j)@sm energZphT1$0&1 N*'2HB*Cad6*(0@o)ol,sp Eth0etW V123e Token RingOE3 IahbyC@B@
taI   aov  CP/b// TD zS^oo  YHiPDuPT  / o  6 / o ,o // ooba c   / o `uY\mo 9S//-o oooų ///oo[ PAs 1 :: 
ro . @% ]ocomp#2S '4,n6E3`
ij* 
 /JoXaX/3i 'o
   FloppybUAİIAd c`Ƭ@(sec.)C velP`F12b 2pz@amb(`Nu up <F1=Hjlp>@rkiv Sya|infot 0sv~ S pk%kigu @1( stll frnl1Zn@ard Annuaa nd` ochsl  anȑ S'ker0 dPR?trslpD'  K!aOB@rt-OaE
n ss	(b -ID
S aoТ
`tPd-Std frutQ !av 7K
byggd 
 usBi=*abrikP+ .J
sbeh #DEsktsrktyg 9Km +r vڐ6 S`;vt0HDD Ak_V Minnes: $@01q5`?@An'@#B
Q  oVljrD;cBnedttlD!v(C-j+eTryQI fri Dg@q nr? du viJPst0x X=, ESC=AvbryNaFDA/ccepaF, V=Mer X JvI pil	c	/pCa yEt
<RETUR> oqm6
YRtt .ie,lj`SeferI  : -> MELLANSLAGSTANGENTEN = N1S@<-BACKSTEG FregeyK TABf#OKIFT+H& F2``+?z=  'fO @%Aoi?Cfel 3t gqL` kA@t h+AO` ~Dstod uGen. Felk0197 AsgF{P|plat  NtPhm krv3?A @`pbygm0 fly5s t6 -dato;r/r ex$(|0YtiGdigooi2-@kl`TA UkN4,  Pr Pr, t{yp
hast^hg0Ca-	rlek (L1/L2)Yd ROM,tum  familjrenummn0Ddeo,`r !Y ttNb ~pqyrQ!]H' 1.z2#)3$4rbinvp ˦3+ (bZ)g	1[


Sek# xIrq.$4$@gaxr#q%Ex!z=ok!ŎvidClmissl l.s Walk0s S- ~P f1jH Add0s li7Aet nVar! D@/ѹ  7neh g"Ccuskapay /G-t!ڱxiƱ=k b!h$2AA:1R K>#Rh	i{wIBB?skyddad
ag

    E˂ˎ҇A!^Ԉ # |? #ig?D܇jGa- 1nabb8If@րn`X9UW}k`ad k$pQd (0): 330@npan 2?0%bX A4Pp/]pp01vir katPo:,t	!قGOk%S(|x ervo-LzB!i @(f%ttrib?ut: IDpx?grobsr.M.A.R.T.->5 GammqN u7 ifin@ D> LܰQ R4d% pm}v~lika mǄ  0'InE?kan orsa@3i ЈP9aHSsNypPO@COm=<s1A1lo. |'Na om =hglmnabtj@Deh ;else- @^uQuayVqΦ >fun 0`ʎperl^7!i HP tec?tTools%R-6-Quicka"q`tel?ge Lp׌mPs Hgk
gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!a<ot. Kж7AompHi )p@1f   Pk`anCD-pP"Vt N
"4oSq HuvudG@x@H: D`+@luAhrdsd D`}e. .Ч#`a]r AN}VSHUVUD!{@Pmaqt W.[  !q>`KՠQ@ild fr0!+A
 GOha0w L l1փ'l GSWN.
X (oF XإAd/bbycgg05P0 g`2///dY5- FbW:o	mC eB
07(b!>=  >Dq8asB1GcgCZ@ktu0ai`Qږafanpkhp@.Fut!L#\tg`Rs p]Vo,sursprung_cJXJ. Vi  reko@ޡt2F	B}c	Vrй`+D,ps`_b@}. A`K4ɡ ˄3w_Bg  &Ӄg`!(g}AyO-kbeflse qm ihђޖflj1ens. Trp  >ESC-QBS RVPw#`'Z'R-WsedMtaGF10@cVi3Fa:+dD1}shxE ASve a 1: N?, MiB;ayCrut@!}opBP5vi B1a 0G (Pyr (h aSB G Zip-=PW As1Fj!Б1. utto NT VxPFn?-/Ctrle j E@ls(USAbmYkd !AA b`nrmstrorx+,f hbbelorlekhPeo2ne Flk paLPaiIfEsio"trqtK ?(WLAN)Bluetooth p/() f-v@ANѾϔmbe Aggгs`hahE%-21,2v[,p$Neyd Eth)& 0	3n To!|RQN"|Unik '@$<QiD K @tus İ     S"b|o Kalib o dp{  F:DualQ.O
o  

 
9
 Fo 
E 
D0!j1s
Aoo
E
Htag *o@ 
* 
VCy emol]A*5 ooe
DI OOKood
PD?[Ne _ : Lapr 9. 0% ]
^klar2u j253omFjOF* &V@1 >I*O! DgOߧ̀U«br@4sadap@$lg rdrjQsnabb0 (seck. F1 Bd StyrPTguen!he 0ae/ \`P}Op e@slaan ConfiguPpo<anafpvt ardQ3!/  scy	WiojzigS%ne@" programma @٠0Soetup  zr w ؃ svei !Behee rswachtwoo1څ
 $X. A=p aatbOgl$$ ID's  	Sm4CP p 	Oau3P$PEcR%mj+p%O
Ge0`g3 gvssvzie2"Fabrieks.Cugz7/);Vref.s:nieuawB8ONc  ExtAcc)uwB ZeN geselec Ea  es ~ zelftGa -schijfeai`AcAt PXvG0u?1I R! a/ 4UBgDAUcg@7n ,DP=0%_
 w 9ʠaKc!: alaal =r/em 	rijsgemaak el;o" /;09
8ukAZ@ ]0ayMLg]@f=S, ESC=Annul"EbDG0=!emJacNee fslui@Q, AQ-f`=MNHulppijltjkp`gebrui0d )jui~Pwnukeuzk@ark^<ENTER> ind 
cr]be8Zo !vol%@@01  0aiX:  -> of SPATIEBALK =>{<-BACKCEVorigl)TABb	#>EHIFT+%%ܺ2+Kq= ykp=t#<B~fouta6r4k p It w_3ge15 F0Mv0reqatijasFen. AcoZ01b`a0.i1ZCu  we   Netv3oe are0#F0MPNp diVbas`e3
 t n0 notebook-pcI/P @.istNOQb;ep*igdooh2L	MЛa\ft NmpALyp6roce;ssnel3Q̷ pp OmPЂP}e (L1/L2`Zapac?i VH^aROM @ -es!fS<mm <E  Hebvrgav_0ideokp&p;b  bpM	m	ra1b2rd3ďe4ahis(gI t}.jne C(_B(ЉwMdzQ%) 
  `D#/SecuibE.aw~~$DFtb%)҆2!dHU2L53Hac-0-*1Tho~_adresrlafwi}snd pao=LTop: zPt<ts e'ge t3 PSBbeЉif  s d1 A:og-  /ޖ"x0zbLe6`NoffaG1Y\f_dقڑD@`ѱ

bo
gAt
wXOC'We nu duъ"N
wil?oݩ""a? Ox
Zl"+1 (b),2G (U0Y ) Аpqwrpn (min.): 30aee&p:L0%Qtoo 4;q{hqo:5broAD):]eeqx/nb!p$32#kvo-IPsEI"
2ހ"qk:J S.M.A.R.Tc.-af@0APP@udh "/)Bloa*+  A  I-7B4kXqc rlpSX8
 Vr!a1&\ is bBsAYohCf#/k, T=m]lijk0pUKQߛ zoFik` dvors:ka?0QH fQeksKPug/zet,r lorZ@¶ZOb$ uswb sqwYfur9h7oud'Hi`!  AQ`R`T`R@&BѴ񡘾 vuaYߐHP Pr@ctTools(*%/D k  p?gsp0p`b TWmE h#M"g$rgβ9b   ~e!rX#W>,P.o(h( o( S("7'EAJb"f }k otraakP)5w sXb tK;?ݳ ]Qʢŉ p1׀frapd  Par౤ˊ Cd-!r 7HN񸆆Hoofd8UG8r@JD  UQ0w`fbia DB1LC5!;i0zow)HOOFD-"RGEBRUIKERS^K  pf"an< SSC  hbwACI t fykgcompS$ajsLQ}0ZP$t d 0Bb&qӜ. @XPpQ~^zA/utompJc4@9	yT `r:ZcY<<|7t7 O!V)?!9NP sN! !. MoWdLioNTCb,p@  #i RS8pò̀QU nt@@Odq K8/ # `hui,H50d@wұ?was to/!wk wgeaГ. PWVA?nvloeC~XkhWSs0n@Pܩ׍zYUdTr!ra=8	2 torH/)К Bget. /o
 s  vBn. O
m2un
1]ѝA&`3fe*& gol q. Aܹ_ӱ_,@cdtabҔh ! Dcㅻp3ruk3!ESC- (A9н0@2i Rb'k'tyUbkn F10@`T*Z lusTB r`V4  Neplg g MultiBayjVzkd@\base; (ks)re  USB	-Մ cb+z6p- ER #we瑟V V@{Zes >Z$>Aa8NFn/Ctrl `Owiss/@p`SStaMcW3MijsappOU e% 0 nĳlBi5j V o-1PF@A/A뜂0d`{dition  G`vgp<uqVpilatE?Bvp neVd$Radioj W/LAN-aoe_Blueth
/oG`rgieм@ qYI1L[,(b!)0ۏ`Et@0 1
2
3,fTozRa/ -OMom@023 UUrtcu!G< 4us     Sa~Gekali@!тOK"r2
NQc ual P\JOOO  EWOOO[B['O0OO H{ap!ң
O$O"Lpier-MUE-$J$O C$Pn+OpO+O  [jp 1 : Bo. % ]A/&p[лd2knte ~l/{	3	# 
fohl/)b* Jt  ;>.C,$ VęçaդXadap Fpr(0sec.)Cpop-up bij sno F12i )Kbb@ cursorytuyEasyP}o-muisG Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe߀ ɿւa\w܂tsfBNɕۑ  ݒOCOF畜>Ăg&f 
H
g  Hꏟo׎ <
ɖE	ύXɏI e `AȌԻ܃@ea L(eA`LCǗW҃p h/do'o "X yf@\̗L/cE%ID&ID: h (uN XBSA$폜eX} 0g J8 23T|OH, @v".eI*"%ɀ;FX
 ؖ>'f
cA>oAe̒  II(f:nA%e> pCeBI;vC"F@ `}F  H D%Jc9J; ڍc R5BM NP$߂Ad%E@U`U:O tB!#sNu %.37($b74L[BR af=~!AEsc=Cq@bsAS60=͂
  <aRAg)gjq5\{ 3gp] jkڂQ %iA@gp>[Ex]  e=ȉ#wA̀r_->Epy`tOo[ = ET  <-SG[BackSpace] xa%[Tab!AG#[Shift]+eF2!,,,10nmF/[%  !CG[  @DBCś}@BD?rp o 01 yNF`+@~3a
ACOk ~ڑKv@&eb~ rO x1X
Mp!mQ^0fGdMEU		?Ȃ2󋽵e`	уɰ   ۾  xï  ށiL1/L2|"`OM οOM̧Fرٔԍ  ޵ ޼ޮ ް ۰ׂ{ްޯ ްir? ޯ*#2.3N4h	? pŰch3(ÂC)FE-3N4(JkvJ" _!nFw 3XcopF?1$qv 䠇sxП6!̼;LsV+W7alk0s?A-1B/Z hѢp^`OD4ߌx:2B}tƁACN %C颴 ׂĎDa/ŗp>쐬AFA:/݉ b>#}v!hү F FSPl	NXWM~@YqZo s/9@y(c  ցB	!H #ċ g Oog'`,گЯ1iNp`2iS3p.M.A.R.T \zsԁij: 30Bpײ>v0% bj!c OK z43 eB~ 'f{:x@	{em`Q1kTz {ǂݨUעfIFIDP. Ba"R`R AFfV!'/i `¢k@@dAJg(B(a ͈DAJhvٓB"̏߼ /  Ǘ7߽@{R@ȄrRVdNJǂ̂*p4u`@ȂaU@C	 !]ţF"^
Yꍇcxei!ݡ£	8龂 ÉƂ`Ƣa7df!f
`?"dHP ProtectToolsh}lWŒTBq#j, .qB4УMmUNu<"T҂ h8' k){-E`O'@OH&J8-.))Tی?D<yD%蕴` g4`dt!(!ċN<b8v"񊰔Q Ԋ'O GPu CD-pu$(3H\@}@^ 7Q: axUKߑ #iC^"c. t%``y 
x7"	3@9>+ VAT:!eN,Bi	.	i	 A!!F	͎2R qĐR`s~񽂩痣HSCۊ"o"F`pAF/'@Aefw`6W 1E<r@߰ XPۏ؊ԓ "łbͯL |ił`Ȩk)/)%)!?ƈ UX3oNu@"*fBBFa(`o(e|~!@#$'m8`X ( IO)F)u
 ((?(9(.㜨gDsЯ}Dv#<43ɑqƈ	{MS f=e|^`Fa)F1j 8fcB  BgB<b{aȑOB%
O#&@H2ef̯ "8먎ߨql`Ӕ5C aU$/g'"wEE[Egsc]1 쉟`}ȍ~elaӫm⛡ThM?DriveLock tO[F10a MS   y_97`E!: ESxtkGb`ÓO xXioi;EcUSB Xp H Zip1ԖW 2b 3 4"U567B8910r Fn/Ctrl%̐ؑ `{`\p (USA) `|*B#fo+X
KV&Ws
v C\g @}ZJ@_ rIo`̢ ރWo% т݊ACY Oڑ͏̧fal"Ni!LANj%MdBlueto#ot/cyj!>`ߓd p
 2Intel  Execution Disable-@++1)2)++odhEthernetX& 123 g! p
AOKO3O >H!O Dj' I+D 4b`K AM      ϰ`@f@R?k ejZ o \(%*nP/h/!!8!MEUt $)o zoooD2s!5bv1 : [ds . % ]O<2 !gOnv3		@)J*   5`$>s'pmj&vSpeedStep@ technology
u'"( 	_Ħް Ӱ # px(b) 3F12QԁibyH a ^E`PbZB  @d                                                                                                                                                                                                                                                         K  ` a b c d e f gt" L         P  	 
    ,  
  D           ~                    n  / 0 z  3 4  5 6   ( )    , -   * +   mp
 uN % @.   mm $ + 1 8>E K RXm `@E<B7B<U> FبE0`8l v x_|v||p0p7c   c 0A   = ~ 
=$$$<   DDD  Q O aƄe  i  o䔕 u  y $n%Ap E%0IC&O p   U `   Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'/@ (#jodߍ^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] σ} !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'o(

C$: | i s+'()+'*&83&

OO
\?()|O276'6 -=
^~+]}@`pZ';+(:*[{s\_}\|      ^g|mA  _m^@  &.@  bm@ EUD @n}.mL@@ I mp  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
m9 sdmxcmRa em?gm@@p < f+m@W{Xt|dU Zt}[}#L  ]~&  W_t`$itVaV!
	$
| 	 
U`	
 `
U`
fabUcDdeDf4Ph(>{&SL_@!@   U @؀
 j( 
( 
r l0T |n o_ : *R  	m$ $ 9 D VF10 Setup Image_SETUP  !D	Sq  ; 	Г* *v)@J$"P a|` 6
&$`ԩVC ؄ TԫUTԠ*U<g!"$8Dcz: 'Uᴳ4㴴4U崵d紶4ՄD8b_ : (m
6  U($))$*U*$++$,,$--9 Ռ-g U 0	`
9 a
E#8i3jG@ #!" #" #" |
8 RMNLNOO 8 @
:	 
  P    /	&Wc  b"  N  % ]   N''U!(( )O)UP*Q*R+S+UT,U,V-W-X.3V
mUd-dh.h1diUi2dj3j6dkU;kdlIlYdmU@mCdnDnJdoUEFdpGpHdq}5 ajmfoq$HrHs $[b{̠{`{|`|$|ܪ`|`}}{L`}8}B}. ~X`~tu wRx~Uz{  }􎃔H kv 
44(F3)]Bx`oU2您T$\` J䇧0L'\tU ;U
敇d @9S ڠGxTnxL*@ U4 : N j@Uz @}L0@ UR h  @U @_L @ , UB V t@_( L @5Ԁ@@ UJ j  @U @_L$@ 8 U\ f p@U @ր} L@ U2 L d t@U @}L6@ UB b  @5ƀ
 
@ U> `  @}
	L.@ R    @
L&@ 2 < H `@p @Қ@@ . F ^ r@ @j @@ X x  j@؀
@@ X x  @؀A@L"@ : N ` t@ @ @ V p  @ƀI@!@ 4 R U`@z @UȄ @S@ 8 \ U @}  L@ U, @ b ~@U @U @M@+@  U( @ h@՞ @,T@@ n   M@@&@ X Uj | @ն @T(@ `   M@ @@  U( 6 >@JUVd p@Ւ @T$@ P z  5@ -@ Ub   @'@ v j  @@.@ h   @4@ d j  @C@ ` t  @Ԁ @L@ 2 P n z@ @ @Ҫ @C@   8 L@hpz @ @ @* @JS @Q@ J ^ Un @5 @!@
@ U6 N f @U @} "LD@ Ur   @S#=@ n  5 @$S@ Uj   @S%@H@ f  5 @&Q@ U: \ | @AB@'2@ & 8 JT A1jt U@ U@ր A D
( T . 4@>N`hUT`f z@ @ )R@ v   @* J@ 8 \ p @ @ + ^@ f x  @
,@b@ h  ª @܀-Z@ L t  @j @. ^@ 6 T  @ /p@ . h j @
0 L@ x   Q1q@ A	  M@2u@  5  <3 A@ x  @ @4B@ 2 B d @j @ 5@ 2 L b x@ @hhhhA6u@ H \ | @Ҁ"@7Ty@ r   5@8@ %b  @ƚ9n@ <T  h @ h:<@ V t  @;@s@ R r  @ƀ @<@@    "@@^ @R=@ h  M  >@ j U  @?h6 R z@ .@@   Z @Ah U2 L b@pU @SB@ N x բ @$CT@@    SD@   M *E@  5  &F@@ Ո   "GT %@    SH@   5 @I@ hJ \ n@ @Jr@ , : L P@TX\ `@dhl p@t @& K@   
hI.hN@h\ Rhv@  Lh"R N@h| 5@M@@ Ur   @S$N 9@   SOW@   SP j@   M @Q@  M 4R@@  M $S@  5  
T@ U\ z  @AB
U@@ * V hA1J @h hhDhhVH@ h6 >UP\ b@tU @@ S W @ : V U @ĀM X@ L U\ | @ @Y@ P x j @ZĪ@ : N l @ )[@ 2 8 UF@bx ղ@ր\T@@ D T p U~@ M@"]@ Z U  @S^@ J h ՜ @_T@ h   Rހ @S`@ 8 P UZ f@|U @؀Sa @ 0 D UV h@|U @Ҁ hhhA b @ < V j @"Ѐc @ `  * @Ԁ%Sd@@ < L Uh  ̀ 
e : b n@ Z@f U( h z@U @ʀh@ր  g@@ z   @ h @ t   @
i@+@ ХZ x аj @ j@(@    @k " .@<Vb t@Қ @l@ Z |  @ަ m -@ ^ j  @n @ f   @o@@ n j  @(p
@    
q2@ \  j @rR@ > R@hz @j  s@   " *@08@ HJ@PXhv@U| @܀ 
,@t U4^n @Qu@ < T Ul@ @vT@?@ n   S2wJ@   <x@   yT @ ~   Bz @  {@2@   |TK@ P@ d  U @܀AB"}@l@ F V  A1 @h~Dh
4DhV)hn@x~U~ @i@ Ҫ@ : P ~ j@Ȁ2@ 8 Z l @ @4@ P p  @ܚ &@d@ lR  h@M *@ * U> d n@tU @Ā5  <@ UR l  @ U   @SA@ @ \ U @΀ {@ ^ hp @I @ ~ h  &@ a@ . hU<@Tb| U@ M@ @ @ UZ p @)h@܀h@hhhAS e@ $ : UL b@x"@ҀM@ ^ j  h% @x@ Z l   J @h S@ D Z Up @ @T@ P ` n Jh Ќh @@ \ j  @@@ d @  Ț  j@ F T d @j @ \   J@h@h $ 4 X@  @ b   @覀@ b j  @@h@ j   Ԧ@ @ V j  @@@ ~   @@ Z   @ހ 
 >@ 6 R x @T@hAh@h t@  ( : hR
\$ t|@Щ о@@ B Z x@ @@ R r  @؀$@@ t    @ lj    @ h   @(<@    $@@    @@ X t R @	h@h0 T@xDІ@hhDhh@4Ah@ @ U* B b |@ը T@ b   @ڀ T@@ V p  ծ@؀ @ X x j@Ϫ@ V v  @ @@ h   @ @ > f  @ƀ  @ ( V  @֚@ V v  @ޚ]@ j   J@ r  @ռ  T@@ > T b Ur@ M@ @ V Uv  @S B@ R x U @hhhA@ D d  @@ H p  @Ѐ *@ ~   @ @ f v    @ @ V   @ꦀ@S@ F X t@j @@Ȫ@ ( 0 :@>Jb ~@ .T@    S(@   i U< T x@5  @@ U   @iԀ  @ 8 D Z rj@ @ ^   @$@ b j  @@ r   @*@@  j  @"@ x   u@ ^   @ @ <J j  Шպ @T@ r   U@ƀ U@ S@   U$ >@FNU^ @ @
ހ ( P n@Z ( UR@| 5@@@ Ub ~  @h@@ vj   ̀@ j    @:@ j  Φ   .@ d *  AπQ@ Ul   @܀CB> P j z@A1@2 hh
hQ0DhLlr |@Ќ @ؚ @ :@ P |  @Қj@ L d  @j @*@ F b z Aբ T@ J r  @΀T@ N f  @΁  i @׀@ V* l  @h  h$ * T @j @G@ N p  j@ @ b   &@ |@ X hx@ @
 @ 6 H j @ @ J n  @ހ)@@ V j hhh~ @ @ 8 b  @ ]@ B l  @Fဏ@ A%6 UZ r@ռ ΀ T@ ( > d U@ S@@ N l U @ʀS
@ $ : UD L@V^Ub f@r5 @@ UL |  @S C@ f   @LAh@ P Ub  @S耱@ j x  @вj @@ ( V  @ꀣ@ l   @@n@    @@ \   @@x@ v  Қ @,@   @M@ X   @)@ J v hU@ @ W@ hL h^@rh|R @h @@iĪ @) @@ < H 
hX p@xh@h@) @ ~  hվ@ԀT@ X z  5@@ UH f  @z@ j   @(@     @     @ p   @ @ X z J @؀AB S
@ : R A1hj D@ hDhhh4@i0R B J`Uj t@ո @T@t@ D ^  զ@܀T@@ B ^ p U@ @C6 Z n @  \@ J h r @ @\0@ < J P ^@d @Ȁ@ 4 N ` @ @\$@ L v  @\B@ T p j @*@ z   Uƀ @_\"@ 6 UD d |@բ @ W\@ , B UX t@ @W\(@ : D hhhhANj @b	%< ` v @ F@
 
@ %\ t@ @ \&@ 6 F V l@j @@ > T n @  
\@  6 F T@blr v@j @&@ \   ܦ@
 (@ h   @O\@ @ UX@ M@,$@  U  @ހ \ @ 6 > L `@ @$3@ r   @ \.@ V ~  @"\R@   ξ \2@ `   @@@   
\*@ Z   @./\H@ | U @5 @ .@ : J X@dlt |@ @ @ #@ <J J X 
d@%zhЩ@AQ I=@ 0 H Ut@ _\8@ ^ U  @S( C@   3XN@@ 5   @ 5  !@M@ 5  ""*@ 5  &#9@ 5  .$,@ Ռ   %T@ f  ƀAS&o@&ˑ8 hA1A@&&@L hHDhp@ @hƪ @' M@ B n  @(\@@ |  ޚ @).@ P   @К*T@ @ h  @Κ+ T@ x   @즀,X@ V l  @Ԁܚ -1@ N h  @ր. f@ R ` f @ʀ./m@ f   @
0 o@ n   @$1@8@   F 62 l@ b Ul @ @A 3 =@ L p  @΀4@w@ N l  @؀&"5 v@ H h@hhA\Uz @5 6@H@ "H t @֚7 t@ P v  @ 8 x@ d   Ā
9z@ L \ $ @j @(:)@ Z p  j@̀;@ 2 T ^ f@ltx |@ <E@ T   @"=W@    > g@ H* z   hM ? r@ P 5  @@ Uv   @Ȁh @A  2 R v@B z@ t  ަ C@ z   D@@ f   @*Ed@   ަ F @ f *  AG@@ 5  H@ Uj   @Il@ h@ V x@& Jq@ D UT d@lvU @U @U @S Ko@ h r )~ 
h@fд@A.L@ x  h@MT @ t   @܀NT@@ P j  5@&O @ 5  P@ 5  Q@ t   &R@@   S@   TT@ B X z U@ ABU @ P b  A1 @VDh
,DhDUbl z@jД @4@4 @W@ UH z  @MހX@ R U\ z @5 Y@ UB V v @U @SZ @ \  U @@  S[@ L d U @Ҁ5 @\@ UJ f ~ @ƀ ]T@ N Z ` Ո@^T@@ 8 b  զ@Ȁ_T@ R   M@:`@  5  a@@ U6 H X l@U @վ bT @ D ` | U@ Sc@@ R r U @̀hhhhAd @ V t  @̀e @ T z  @$f@@ r R  ހSg @ D Z Uz  @h (h@@ P j  @ʀi@ B r  @Ъ @i@j@ v   @k@ h   l@ R x X@Ϣ@Ԁ@*mT@@ x   Sn@ t   @в @o@@ B j j @(p ͪ@    @4q 1@  ʚ  (r@@ j   s @    t@ n  ަ u T@ r   v #@ Z* ~  @@wT@ J n gU@ 5@ƀ@iU@Ҁ 5@x@@ U ( L b@_L~ 
И@hd h
y@/*@ X ~  ղ  zTj@ : X v U@ S{ m@ B r nv@@8|4@@  } 7@ 5  ~ Q@ 5  *@ 5  >I@ Mƀ @ x U  @;@ V ABv @ A1 @@ @ d vhQDhЪ @r@ @@@  4 F h@ AT@@ R x  U@ M@z@ 0 D d x@ @ p@ P t  :ZLj @<@ > \ nSLf@r U@ @ L D\|  LՌ @T@B@ : l  M@ @ ` Ք  @Tb@ N   @_L * < L@bv @ ښ@D  K@ B Z r @ @}CaL   hhhA2TA D b@xU @΀ " @ ` |@ @%8 T  @ @@ 8 HT h^@ն @TM@ 2 B N 5l@>\ U@Ҁ <L?fL @ U" > l @ծ (T1@ p   @;@ hXR l Ж 5@ހ@k@ Ub   @̀ @ * 0 @ N@rj @@ F f  j@@@ ^   @
 :@ Z r  @"I@@ ~ A M@( @ | 5  @ UN r  @и @
@@ D zoLP ,Jlt sLz*  @ @ @ @_KL@ Rm$ h8F@hI\ Ѐ @
$ < T |@j @ O@ P p  j@ʀ"j@   
@@ ~   ( @    )@ |   & @  Ц @ @ V v @2 AB@ * : d A1U @Ԁbhh
 h
 @.4@R H@*UN@Vh U@ S@ n   @Tf@ B b v U@ M@@ P Ut  @S@@ Z  U @S@ Z h U @ @T@ @ d  U@ M@ @ N Uz  @S@ F j U @΀S&@@ p  5 @, L@ R \ l@| @j @ X v  @ @ h   @؀@^@ hhhAT"@DdU| @ 
", P f @j @ T@ %j ~ @ռ  @ N z R@о @S @ B ^ U @M  @ P Ul | @ @hƪ @AT@@ r   M@@ ~ 5  @ H t @ @@ ^   @*@ `J p  В 6Ѐ @@ n   @@ j  ƚ @$Ā@ j   ŀ@ v   @*@+@     @@ j    ת@    )@@ L | @RrLծ @T:@   h2 U@@HPV U^@flt |@i @ &@@@ * 
Е8P Z@j ЀA@&̀@ 6 U@мPx_!L@M  @ D Uf  @M@N@ V U  @Sπ@ h  5 @Ѐ@ UP v  @Mр@ ^ Ր  @T@ T   ABԀ 1C hA1U{@%(P^hDhh 0VWL4@i @[@  , N h@ @& @ z  j @ Ϫ@ 6 L r ~@ UC, P b U@ M@M@  U8 ` @ @ T@@ 6 L ~ U@ M@@R@ F U\ t @ղ @T@@ H j  M@ P@ F UR p @M @@ j U  @U @M @  U  2 @@XUn @U @S߀f@ ( : UL b@thhhhA @@@ > ^ T " S$M@ h   @ %&R F A%f@J% @%S
 @ J ^ Un @5 @ p@ U@ V j @U @S倉@ , 2 U8 >@DJUR X@|5 @@ p  @T2@ x   @2T@ T r  5@܀
@ Uh   @Ȁh@ n@ & : N @ځ@   =:J@    H@ |  ڦ @ d T @@ p@   ABBꦀ@@ ~   S@ t   @$ G@ > H `@|T ր S:@   U$ *@06U< B@J\Uh p@|U @܀
h  A@ hI h0AQR@U~ @M@ : U`  @5 @ U\ |  @Mڀ@X@ \ Ո  @T@ h   M@@ t ՠ  @&Te@    M@@@ V Ut  @ЀjAB @J@ 6 J A1j@p hhDh@@O@ & @ h$PnPm / /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй =_s# hNfP u	fX@  h _ZY[Xg&ۅF ;9   Ã tfPfS
u	p  4af[f}XRg&u-g&
pAgf&A"f,  ,fUvg&Ƴ,9g&PESWVfW&O*f%,g&D= $ <vD# D| u:tw'_^
QRfU

}0tCR>tK-tE$fu
0t0t	dpQ  f]ZYPSRi u-{]r-&-sG tu0< 0
Ag'fA$. +"(zwZ "P  u
P! 3 t
 SQV3Ҡ---  :-tzffKf- AƜ(Y)9wfP98$Њ;`	P#X,)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>BA0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
,D$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	V, -ff@EFt!hXUgvuN>tO6f뿢, Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% ,SA _u,# XA	u-->1&BZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@_))FbfDf% ffDg^Z# j00f 4sp*2{ÀD6^U^nBn@& B7ӥi({Pfpsf
  @WXfffL:0[3`'E8q4ж3U? L؇PgOS?NYYYYrZ1q\~YZ ЍSpk< w 			;/eE1`eR#tZVoQ`C F%frQfRV-u/	` 	R
~>  !P # $ &B=h+( Q Ơ  f3۹ fbdTt ` t0Q ?\8ZFfCPŧ@sw$<yk{s>
p"o
d
\9VuO@S1?"U5`,UuZ苆FFUu FQ$-$?G^f  @s++~g^D	%߉D	f8O2+f<v PfU I?fPIfffa$f6f> f	>fBf@)ff]X߀ t *rNԁf_x@R@Ӄfw3 ZpbЃ>/ t50 A0U@@!p0 ҳ
@lҟWRV6[S 8f;tff ' F#4?^$u qcf gfEˀ>  fù fQ@;t)gf+ C k#@;`CaM`dWk Ѣ}wR7RPV0  ^h0 ;u;~ ;b4P4SXf.0Xa0. !"#$%&21/-,	
9
+ '()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRS ݫ      Z *8۝6TϷ  	Ad  !
  	 0 ! ## *     " 2 r	 .>  B
   ,1    8     K   S
+`,&,A!Mru
o>, o  >  t,,,>,,u} ,"_< tC2`r,:Mb,,,,ggQ	`=PL`
e3ۊ؀`,&~-,w-g3v M,pVS`@t	Vm,[^PQV,0ӊ"@ӈ9,1,Wf u5uqyߧS1-,5,,-[^@sfU_>
-S>->-G&-t(
ߠ,bވ',%,=[:QpQxVt>,, r1߻,w%0r ",60}S+,  g6bdhEe!)) `!Q	胢pDt1,8h[R-ZJr-&-, a-PRVqp!)w7p	O* 3:  , &},g&&@v@ '1&s0 ,i>,y ۍ$3P w% u> &
'
u$uvatue&u^\uMu:8FPu)ttfpFg= IL^z1X@8! u	g&AFtF@s|S,X[0|SRV#+WC^/'ۊ˻
1>qZڢ,A,I,Q,Y,a,i,2.RtvM,xAW>pI,SRA<v
T-,-@,ʀ 7ߕ,G&r )&uH¡I_S	
I",,,:,w/=,!
ľ	cdx
	,rg&5tU,x}r],_drէ!"E,FKr?
 Jt x Ztĳe,=2oxLg13
	WupePaD$[X[Zd,_@[@[,_1OGѿN &}luBSQ -f3f2̓A,fwf3 =0]-dF E *  <Fu-3t	 Dt<Hut25t5 y2$u tPX- }- uB<Ft<Tt<et<t<t<Rw*<Ir&-
2rt5>s5obqur(q#VWpӄptAQ ft(PǴ:-u 
  gXfCYv q9~ w2-k-0t&-8r >tw
$_ ,-9-2 ,f? t<C<tSQذ&Y[0u
lq.&
d  & 
 R #  DH ! 
 6` ёd %#t@ ,Xd& "$hB "8@
 . PF <^
 0$,L	
 2)Pq P'   (# P4Pqk 	  @
p	 uP	8J8 }@) p@: {>  * P s%Q R!	R2
X "

 &(xiQ)	(.0)d )(b+" +(P): ,Ȼ2	*z0, LU(($!pU'#	'$	#$	 T*	&
&
"1
q,

F1(AhBFK4CO''A,A
/	
#	&hE$
$
A5
Ip:(|:!TMt:BJS'y'dQ$> 1#uU#!,)$3+Y +F'Ya:Fq=DA;( G0$G"]\D#GV9/'ANd@CN)$
$Qa!q>Q!Hr>PRBSRAh93e$bNL'UnaoM#uYrQl!%Ai
$
$ v(Jcp(dpy+t@
 >\c8Kss'tsv Q:y$y!`!4F;	(D@a䈣!blxW'QJ#&@$q3$n+$3	8q//  @iv
 v $a #
 `"9	 w aZ izazzT
 " /	 !=mKap{ 	 hw Ѐ Sz
zPRfWfg&f_ZR P ZPððð  Q|@0 m 	`@  a1BB r !^B !;  eTfgdbEEMM\^_o_xEE UWRQSPVrwCt ur6ffWRfP0 eXh+( Q Ơ fZf_ >Bu2C-aPSB puBB` BBWB/BBD[XF f sftwfఖ  ^X[YZ_]e ÈBCԻB@B  C, j0fdQu!B! Puddfod԰  >P6Sd dПdP (B CfUg&t=` T=f]t,>@u%ttt t	tfN tƀ!r]@u_al!s
 1Qh 6KuFk . u$
SfQV+eS tKrtـ?fPfD`*f f0T fffXs "
y#up`LeB ` B uYf3f` feBKfWpe*&B8fw*fF*2t*܊e&BfX^fY[f`--''B +"  Āu!g&pvBa  t8!a%faSQVWU&- t- i]_^Y[LS-120ZIP 7250 RV:1:2:2A2PKp
˄w
x z
\5	BdWs!hEfP u	fX@  h rg`/;<tV< uWQoGfӹ g&:D= uFfG(u'X!X  gHAZY]f`-u BQ-BBBwBB0 RW1h

J} tEJ4/_Z[M-Sys   DiskOnKey 1 #aB- u @  f<x fP f_I"~%|= 2r 0w"1s sU3IH t_ gf&RfQ ff@fPuLst6Lu2r)g&	ug&g&ۍc,f_7 PA	% rLTf<?T7(QRRVTcF5Qo~me}Q2?0;; t0ht3t@ u gu#P-3RAf?LfHS N 
1fXuײ?D0 @0B0B0JB0B0G05F6F 	 Ϯ&3FPRR`o?3W1>ߊ#>;!2>
(1_YGh|GPh`p& 4  ߰h*<W SW+ 1s!$?
uo$˄[         Ұ,X @xnY rTBM!r5@  i|X  tk   ` 	bhwoddfHffMf[rPJf&nh\ufnw&fy ` ffMfP   $_Mf%% @@Mf  z6fHMf=A&  `  fAV_fLaDf=%t 5t;@3tZ0_tZD_fX$0g]M  :MI:MS~f@ ot@[|P:M"sƑ tDf  f q@Mߡ:M<<Mf>M u ` _D  2ft.r@^#rf6u$ M@s11 >M@!R0[M'r"b"q0 f!?1VC@f,S	  tX	"riH'	"	0 %9 uf-%tq00 P3$  J 	PM|tpa '	M X1  rf 
 pQDP؊*>M@6P%f>DMgGf	gOg}G]`db>td"3	0	n5
`6@#Du	%&rf6DMf	f >MfIng^g׊~W!
*t4h 0A		0	  FFhiJ<t
 &G5"pu
 "؃ CG&G<_M&GqN&ibLҠ6%@( 0Mf (f?( 42a3uf6MW  bf+8`сawSgff9Mu gF9(Mu 90Mu
gF9<MtgNXfF>WMzr=БC=mPrxi?GsVfS'`c(gF'	(Mg^0 g"G0gFֱ V*	 /e*eP`d&b&g&g&G
G
 d0Gd*PGg&Gg&{G
 G 3gn Fp
p5t	f AkGF^ 0\PfV csf@ܲmdf p^fIf!2M&*M(M+*M(,M0 2 4M < t,M  ;vȉ.Mqv  f@
BqygfgG p ,gG
	q?Gf6up"a ?Hf%ofE@* !gG!&4M,M t@(bk!f#p.F❪cn `_fOB'*PR7з[f=S
f35 !f$fӃW\Qfp#{-  !Siy `9At ````aJ`b	`c	0]	0^	  
		  
							
 0hfWQ[f`1Yf_`QD=fBD=BWD
$>B%
ĈD
Cr% >BbASLsdW"CArI`d
Q/r7R@|= USBSug&|= t t
U	 	`CTܾ *Cơ p arQr C0 % P`W`2|P>Bt Q?rIt2QfF`AdY{rSf]1fM^!WA@4XH\
؀e7܉\bJ
porA
x @
`DX!?
0
ޱ"ysTnq
aWa'"CS# iD=qqp*W.?43'ЫT2'n ^oZ(ڒZ
2(
_7
_=%t9 R$RS$2Q	@ ?\@RP2 3* h >Ku? ᠅ T=
XS<(wfT= ;& y#j6BB- r}QtA3`>B{Bp+` pta^Vu6 B +.\f.6\OPpYfX`\I|G<B fa>9b?,B3zU+*/G/~%QfPfph`1@YfXY"ϵN0\rΐJ?;G7/Os~c`Mo^DABA<e=S$l=^38%rpBKt Kt KtBD$
ƈDFP!r r
9rYdʿ /p%stFPtt=tT= t2:t+u:u? hNodty(u~(rt{^@K=@tK=tK=`	tK= Kh)6`oXaPSV"C8dtd}Ơrƀoƾ*C8DtD$PQWPhƠd^[XSQdWO	8t`g	G	Y[ - i8   '`  8 h
   0	p    
		
							
 

  "@6/a5 B6B
C-_sRIEcR&˩Be 1s fg&|tEB 1%b	 	6	Mb5bOA5b`=b&Br@seWÖ`oޢbpŧ RsQHS r`Q@QQQ-QQ&p\W3
	#[诘rgA{ೝt԰ÛYe?Ĵjrjtstx6Dtq=eetOtesfh~ +0W~~	~	~Y~~F
,}}}T `Hù !sJ%Otdoo%"o:u2;qqq!(~rgpppp2opQVp%bL	;t	wĿPA辿o=蟿[^Ypapp\"I 0   0    |Ro d    n  A` r 00 3`  
& Aa % N 	%
0 #
*a
| 
3`@& <a` @@ 
b
	 CF
? ?a	  " d q a	!? % %@%
R +3F	 
+ (E+
"3$ 4̂  C8$+(3+- E-(C -0294- (`(E  E3 .c+!  0
 @/9F. 7'GC@<6A6D
!: 7' "J",A !E?9B@,3
O<bJ# 
 S<R"G 3D%M TVaXCJ UK8'(X4AIc  WI kopqq rrCopyright (c) 2001 Intel Corporationf`@ f.@M<t<t$<tc<tK<tSnf&nr sfn   uh   uRfADf380=ISGuђ s
g]n~!t f6n	pgftcRa tpt5Hr @u  u u0 ߰# 92  u
P f%63 
f>>MfDt	u)f>MI;>Mwouf@ffhiUtf3ۊf"Qt
0fofs\
B  v@#tyz21݅~!<ugb


7	u\	Q	'h/ś_>MKf6DM	g u%S F:M s@[%;u!,'f=4R0	ff4	)ffp	Q(f	f'@f[aSfSfQfRfV*sWr15 uBT tApNC6g88fI4g^f3f@70-@7f^fZfYf[fP"Vf~
Mf=`Bt"f=Ё &f= P/f=0ށ 3f=@+=t8_t34 , 't"#
ttfr0 rfFP0fXURf.  fXr  	 Qf`*ufQD8}@M TR2p@(2Of2f0&cBZ{RO>V\3hɚ+( ՑQ Ơ uf3`_fbDf6E  =Z<tatG@]_ToK<u	RͨupWJ$< t<0t$ RHP?ky"PWT%j_uPlAP#,RfWPR;>Mr/fc%1f f>ޱ=	f!Effg8uU#>_444
f@[Jf_,,PSt{w&,G1=`QYr;f.;vt3UufӔvSmpfAzffm~ fPtP= v	 +v:P,P}vf́   :vfP ݋ 6v1|Ã tL;f ǰǋPtv Q.vBYrrf u0`b h+-Ñarffpc_f`f"0~ffROMIfMAGE@;uq Wt#g0 yKPQ (J 2 ofG f_ZYXug&wag&GhG0  "2/t"t:  V   scu'[0i&w zj3
G94g&GGfԣ f}Cf-+Ӹ00pD;gfg@ h쀀1"`W, `П..`B@ԑ
>t1a"pR ZyR  ygP&abpZ&&ĢFdOR< uQS_RpBgtXr),uRG`SQr9R'`$8tYOtr$V簄O㰆HAr(QSFr{(!sq^trp@۴ppq9P`~N `4fq48 f܀?g'p!>@  ` FFBZY}}`b j nb PQfWfVEwUU&*4P U 'hX.7['PG 4 .;|t3_YXhw)p  $`p0 	׀pG ڿ  m' tJ@4 "`".ߒ-2(.| |80 0AW
sfUgg& suf3_ɊfX^ptWfYўfWs^g_<t,ofUgR r!8tfGP0PQ1_$@a@8tճP1UvP~F X PS2O&w~p u~؎[XPSROw~a@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   `t/ a3S#[C vS3ۀ> tt#t:#tC  [`蹸t<w>t8t aâ> u
 
?.ñ a r gt3C,% #.#쬊#寬-
 r3쭷!ݷ<O8!fP@ &^$r! 

A	 fX{ ѷt
t+3jgd
uA
 /t1-b㋇$.fr
Rbt0
< t?
:@ `_  $a`> u#t$ aÉ_  H(

p(I( J(@(؃@Pm(f(2s3y@si  {Y 11F0  	:u;npu;thPXP 0!   u0+K`{:u~r:Ȉ@&u[  OuA 7 &	&%0ww
2:rp	T
À
v >̀<  #22Q# f`8P%,Ⱥ:#%j  t
ف     t(  $Xt
 %@  Pé t u>u 7  tP @~ 3 %tNtGf3ȿ fff3u@ fgf&fff#f  
f΀*

 XPfafPSQR.Aa#؁ ~~t%=s	%Q#Y3o#P1` t
ff
 fZY[fXQ
hwe $u%fϳ d`u
SQjuPk  `15  t eh2GfP u	fX@  h $  Gog H dt`KuaR$F
 c$$%5`0J!Q QÀ)f(f#"$) 5 q 0f t' &
 ZfpfC ++3-`>Zu
͹PF,q{f 0ZYfQPSw#4@RS#Ti T}#hP4PQ RfCx1A"5  "-#4 X--##@*3p #؀`5@uR"ttQ@t
1
"u) z) aRfWfQ@Qt2PtEOw Np  P+GhD5~ yQ ^ /:3 ; g&G4g&tCf<ft.fQ>A q=A   u1  dh2)
  '   ؠ--ohRCa)@$#4"f_Z&fW b
f_babR
p  ZPQu4 pyKqb 
YwR0R- h"$:	
2
~c.&,g t#.,gc' T
.t&*0 00`RVh_BWtDh^dYhv5h{w7r2, f^fZf`2 =rb2 <@vTrshfa{f`!X
RfVKPf3a//`ffPcX/f_f!7"" hs{Qgf`/)
4/O
\ "	 	 Rb"	k/	(	!e&!_!!! h<$h=$9ZwIyG	q߭fxf0&u 2Rt F<tP$rf@03dKtsfQVWXv 0 _^Y}Tf  Dfq6ffot
t/%S/ygf5rSQ?f  DP s^ЛW>WVhV?dr=ыt
 t
@u	 ¯ t` uʋ^_fQf&:Eb3:EF c6W p 2:> u6 GHt\o hk/4T3Ҭ؋hB?^_fZfj
XK̈́
>
2

VT->T2@OHBp
Nt.
Or&   +
,1-,/ faׯo/ / /  O,<RwS2.N[ø  аfQh*_fYnщ ;aEf3ɋPx`0X&G     &Wft ffBf;Pgf}ww~rtwRtpff@OhDjp3QgfY tghom#.a$%AX0Y[0U>aPS ?2hįWh`$u2f[t9  `    *࣋6U&Qf=HIBMS&@ u_Ff! g.9u
g.RFf0Fo "S7f= @t1pu  ÷ PFQ Of a Ѐ| a!NuFgf~fVf  t
fP#fff;ygfY#F$AV f;s	f
	  fV2~(F7f ) f+s
0	@Nf;sfȢF@	rf}@f qg&g&fFfGgk`^N &Vf fA=uTA$<ufIg:!
g
@t~T	f@f t=> uge *>p u0hv^#_"3>t;*t3tP 誜s BtӜ PXߓ>*p 	du
)dP
` u9 5r/<t+Wt&Pu
$&Л;.JaP%t"\tq2!tn` "G Q !ОDޛu|u>&t鈐@J MX 0 &XX
À>ڰ 
8s e  
t V$<
v
ط  ' tǀ>P t $
ؐ &h?UŊ$(
d tP{ XR!  ;^hm

]d]`
@

#
P)rÐ-u P&QX PQ>Q u
8w z߀4
A 0ubZ L@Rif>]fp\pNf ajfyW' @/%~jPh  >ft	` (f%ː`PfWaDGԼX<t<t<PS$<wR .R 
S   6   E` mTa c m!~	  [ S&%fmmmmkff{U&kfH+ '%k0{t²  j`bff3fUr  軷fP񸜐f<`)ɾ|<w   a fXf?f
`}
E
ðG	 I  ?Pĳ6
P XuBDVbS!m uli B [ED2P >X	@2P2@Cˀa		$

Àu
<X[X )a؀a
2t P@<KrKNPR9 Z` .9  BZ s  ""
ZPpD`S좆 ߠ  Jq vJúQ R (
PBX
	SRذ4ZaQSW 7L_[4!!!!!!!/ / j 3;CKT^|3=GQ[f h S[z<ENWa~r8<AFJc| !à@ PP q*a_RP,:%  3` U@ˋȾCN  QlѺSWP633ª30  
@|f rf_fj"ZUfF2FR>'NT>!t"ffvfXfD X ѼfpfufT0f M "  0I0 F@ +fqPFT  Hl
 
S1Hh JP,,T,uΡ  j q$% o!m 	
;s% %R ΐ,n%,-'R ,r 4'Y;Ͽ;! )$3$G$=$Q$}@r
_'17O'j 
e$% 0d0.>`(Jz  hd M (JXQWк
bٹbٴy ;{_}+z ٹٴ|"?~:ðL'hᰀ愿薰谺$ tpSu%th/uCr>a> u,0
?m%@u3
 
:[Dm%Pۃ-ݩ b{a`Pq` 
 "0 L+  К Y&f`Dy_R t5fBJS&Y&f[- fa}CTNI kS&AG f(fR3  v03'>+P3'3'2s 2cۼUV<22 P`X? ]$z pog[.@@>!pA^]{2 	V?s(S rs.ߟ'/grɦ.t 6~ru_hV0>ߜOhT2f.f7f.q _hż? ;  r躟. mb = o~h蓪u@ hO_).K)/
03!40+t
3NO+t3GNO UN])V)])Nd)쪺P aT])SRd[)``$fӃ*@[QXffXܞfX*fX>ahht~W yQ  M (>uuu&gq q  l%?[hk_e$P0X! hfh(LxL	@MPA608N4/J7DJҡSvP+F X PSÑ&+&+&+[XPS
+++O9H587,Np&,,$!M_$NwPNwS8rdd r}S<dr
d2t۰7iSt诩K辫Ѹp,oް覫m & ޠ@p0ߊ&?膀4Pd t+Ð                                                                                                                                                                                                                                                                                                            /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                騨!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( ((     ښ  Ւ  ς  g `g  h }  V  ;p    / 5hل 6jۄ	7
  S          P        (  %X%H_&                                                                                     `*} ` Pz*Q@ U   @U 	@U
 
@UP X@UYhi j@Uklm n@eo { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`hfPu	fX@  h  fUf&paf&>۲` 6a  !X[ &SP`\@ /'aߝ&&@r
f3fgf }f3fh   _@p h &ïީf`f1fffeWf   % ŀ-ff0M00!0)ffXf9ffaf 
  fUi@] 0 m uq  ,f5q f~^PeP Q   ͪAp  A` e׃fama  !6>eуp Ń ՃPك"` pew T	
e} fe&:` b "jeɃffefAffgd:ugdfepf3 ~gCTʰ "8fF3ۊde3 
tdg	  p)O @ 
pezu{xu.G_RT=C u:/
'
%&bfgfd.S` [WP9A`XP&EX% &E_YǨ dooooǸoc e֏%?}SΔf`PHkIa  6&P&`WX 23v
``.0Sr&&faõr!Br  Pq X
䏀  Pf hE3\ǰ Xga20u쨀t݁	<u <u õr$Rr K|&&Z2qrr]rN a`z7da(Svx^Q`es"" QYaeWP  r&&0߃` Ob 
y' P"S""F"&o&2a 1bR ~ ZQRr3'H2't2ZY`2ٵ/t"5߀ tt(TZYa~r#S-EnR-Y03!pٸ q4 AY f & &EZP 2 &rr8t32估~.0B?O h?,.1tGS/؀1?Eh[&M.22t{J$(F0K#h 6,5 +W< t 5+4fRh^2hv~ yQ ޠ hw<fZrj  pvw@5 pS
, #!	A	2hk
%00`P ?0S׿%-  Da`6(    pM aV魆ī^`W  3 _r- `+˸ nfDED`b;Հ B@<Be O B<`<2rruO0W2&*G_YS	 7&*,u&}Zu&E__[DAP`QFگ>  0 2ۃ<OtY	B/<tmH¡7[77_rPBBLѯ: r1 r,q h/$d0SQk
pqlat)u$<Pt+fKuҴhQpB`UY[Qn @qj"yjuOBAuYoof0P	VPo^W mQfR h3?tD=F==rN|UtGVR4^t1Vh_5f^Df`  Da   ; Z x     0Nm1=$
Pdu	q 42ɄXҏ	 )i HȃIذJ2ȉ-' %.7SQRfRBP' w	.Z0"T9a  y8 )a*$t2+`` *0hHtÓh rEd/(#3/J+(b\*f(fYïʥRh}ihlfPSf>QP?H_u(DЇ/ fP  [fX-r(qQP-roSfP>fVfWp(>f1t P tf0Z f@ f  f 5fff!52g&g
fKffRg` gwre h՟6r , VhݨZ,
-f_f^fZfYf[ r  sRfbXPSfRj07W6uLt;wEf6fQHf8 r/f־g&bP Bfg&rfN`b0oZ[XfWKu
 f   酀> Àff`g@? t]ǀ t
t@  f?t
 :  
@(Y! _ 0f` `; 6frv`gGwf3 f[PfcfPr:p> ff0;w!fVg&f^ufF=tf!Q. $pft Qg'&$9R<&m<f=ATADtlf q:&Ǉ  p s  S3a  ob 1݋ D 0Z3ɊFj q`UFWP3J XU .>J   ub >u `	`	v跌=p$l0{$C_AR?J0(lvfSIMWuUf, ^f@ENrdfOfAf;w(hw/FI"Q;[ap qQ08?SECU7fuBflS@:AR@P_ɧSXfGؐu(AE_-n$81B0].g q Gt+S2
 CT!T<tTt}hP޿
u^ 
lPlf@ | ͡簾ff
 w	ßJl& t
fWk&f_r2if$g&  EOg&	2tWVip^fGtt2t~tyf   f`w'pA,u(0v z^ @ u~^uBO`x_ rFf;r>`L: t, f    ur%)rQY9	 ]sh   t%htI`A
A!:0.2 r&q
"

Tr@ZSV!rP#j   t
ff;t;0
 + t D@@D@Ò*@00/rwp		]P? u ff!` B
fffLp 


grϧS@~1
!Х3Ұ"~t3 v %`hNVGܡ밣V1
< t601}2:u"FIhqr()PD01' E-fY&7@ wY.	A_S 
fUfp>t	--


f+Рf<
B#f]^P)x""  ,gbXv0? An@u`$fB %  
9@_#`_#_#Mfvfrg)(\*S+r[ ం0ૐPQ>ꦠι c r\d`PSCtC>r-t`w 0 r uҊ1 r
-`u`dPqQ rdItf s?` 3fցSRNr&Kr! [ww3҆r r	ʟ`HЮfsPRc!0rp܍ȇQ7PQq	s
d Sr	?r!V>Rf   dg3{uwR Z '?}hГk)C蹀   . Ӱ P " Y0 `2  p",u   P hE33R밍

Z@u
Sذ* o rQ(`( @PS  I 1' R۰RU  厢rPX3DC	 4ïP>DS t3306J*bRމ
t#4 c ttaÈ  PQRWV+3"a^_Z$"#P1$G<u@$V 4^W _ |	"  !(e_ 	J
R
q0<J
g&/ܱ1q;-r r;x;q;óPR(XוJ2Z 0[RVа$rN ;rCr<,	r32`trr;w tsڋ^ZW
   е0u
˾Ш 
u P f! uf _2 J332[2t@@ 0 	rn
$	"
ſupmƋ߱d;sRZ3QFqF2t
2t	u˸
S_
_......6r.Y.2YDذVPCߊP?q%8f #_g&   hpLfPfb` Cu a2X+U ~ø8	q帠 dpxax)pv$<	< Q- C  zBbJC 
يIڄ#蒈
Nyx yfqq f+fMf-Effgfq  f>PAMSuff>r^0[wSPݸ`#X>Q fi|	h! f#SIIWV`rY  E`/fP < u s󤏢orfcQ fQh^`b
h$t.ԜrB  ؾ@
E@u@
P
`Yft0!0 H\"a`̅j uL$<tD"ЎQg[r&=t&} tV" &GF^YՃ"
\ؾԨaþ 	 hyų
!s
"N
N


ZN
P 

h@ٰL  rg1P~̀RRغ0 t@Zld `	eqAd
	
fWfV3 0IZt-t`˸0f\c ôf^_Y[ќ.fUf.6ôf]f]** End SetActiveDisplays: \ R$nt5 Pp)㋗˴d_;t  __um AZ1Ӹg @t}0uQ2tN
͋Y  u@t P< tG QO
i p
R 13t0	p $ D paU"
ֿ "Pn QtR	g9P ZiP~liP$0 ki\iċ؀[iXSiX9iÀ@'W 21k,$
iQ(^ *hPab tQhP ÀhXhܠ h~QRPSa[X3oжa B"cu
vr j ܿK f`dҷKOu$Ujr
u.2*q	,r@0$p&` E&] @ _fofaP.A4t
11???LTSQ/"S`}fWU]fq~rW_Pð? ғ qE  rH rIPtp	0SfQWBUftu UAC?_fYfq@f`ffǷ ;@v0fҺ faB|k_<_ Rgf2gv#Qut SPQ$~X	[ fp Ǌ6qHȎt/O  3 (v؍mq$^at`ZONFa D{OOwA_ B  . 1gu$$t$
$$"h1|hs`9tw4>0t,@z uXa![aʐ  }  `   V D ` d h            a @  b  `: HX \  HT3L 4 u50@
@
/;                   `     14D    PXYhijklmno 	
}
                   o,89:4NNO OfhXJ"lW  O?SO #gf&fgf&f`wPf0	@g&OZ	 pvA ry㲓Pf@wsfRVW f Q  !Q  A!!ȑf%gf3f3f.2fffu_^fZv_f"Q ء f' g
f0P3@PSVWfQs:QJي Ru ufufpv @uf  fY_^[XQfǺff
ff   fА f  4 D4q'@fC_Y"OB jbR5   躠ཐ3 < i <u2<
   c                                                               UPRPRVFZX0RR30Z O                              ߸ ЍOƋhs3   f` tg)t$A)p$ŪT)r쪺  .<t
../ժ NA Nfa@SRV	fprtU./tA
 NUN蟣hϚ4^Zި4 hZ_À> t{%Bfs`fQWY_fs߁bЛf߁?UàPR좐BZPȿB3 $ `%>&t%	 
  3  t!  { ! @fu#2Gh24ҡtRW0_r TÐR8fZR0fPq&T ffX@ !+q+
䐟 fh` vE pE jE!dE0^E1XE2RE LEFEa?P  /!⼹&?t"g&Gbg&Gbu ` uq  κ( 
u#` `!B!]s7ra a* : , 22RQ8ĺZP X,a%*A Ë34 z g&DA4*
 <c. 1"0h2`ѿ1f@ހ͐% 
 0p!P!q ? f`
 `0XX!Jf`~fpf%? gffPv *
 `C  f!Av"aP<w'> ux##$<w	#f<u21V> t='u7 u1 )R*<t&\t!u_L^rr	B?6 4:ԿgNtZgtK^r3g&GȻ s00-G$
p-G!O  2O02APMt"G";r0MttoqX	
 ?  VȾrS 8t"8tr'1^SQ)^Y[t,&
u>ut
$rsE t> u.Qþ"t$	&
3sD pW
t|\`f	> [
 yl\@$ht`~0/KYW@I mguR/CtC P  K< t &$  
` u[ޑ> P
	 >t PtW00PS'u Tg *r$@, t׀>1u
 QdA  (r"/]t YJ]SQPX0tV
r@.[GoXKtB0T0.r//6Kt_6tP rB豰S36hs`Qu%
uN "DK6 seZE6A$Qtzu .Yطc5tb';sW;sQaYu	$Nu u"
u"
23Xb- ! à!Ӣ-to sxځ* -)P16tXSfW0~`
It@g_8؊f_[0M,fsg]  r&
,# fQfS !|{hQe1 fplf# uOf3\f   t{s,#%9tf!! ht1 fuf0 t0if.cf@Ff0mf[fYb! Rb`vՌ +9CCfW Ey1W u8  *ՠъt Җ t	L5f= f_À  
n ø  <Zu?mH_r}H /<G@ hn~ yQ  f `QÞP Qfdpa$
	юckt.f@
h@pW劐ЙƇБ 0`   b_údP u"AunP s  t 	Vf@ @ #bt0E9X`p % o&!#  ´d!Q~a-f#@~%1փ 80$B'  wf03pQ'
f~墤aAS	  ';'p
f1fg`s!=qfYfĪ & |ìS؁ Ӆ!^fPVp#t6T %f&ȿ ffP]t33uO^ fpqSR3X3t@s7rSߺ` hqx`2 
 *+ 4 !RR4'T0	Q̠pÖ*&$b
 P1T؃2沱1B0RfZ,.028  l+T,b1}-w=)A&T,˅*!
޿@ͫ)2ͼͩN*׾#j Fޅn?_`ȱʀEPt  !̃&pRu hx  _
 ڻ| mQm YCte P9ffXP:f cf l `a   ` ?
aa|!tc7ٿLٻ>ٹ 33j#IB@S3g!g-ff<f
 
# ^f RV\T%\h8T`n,0@k  ek Bk@2Xsf28f^- #PϨthV[PdBJ^UQ = u5
zH= i={ ,Q7` H7!k\CVѐ8[  9^t 3oEQ!\ `R]"P Q   ,A048X N1G@p\#qW>`5 A  ~F@N#ht_!p{3 P?f4qIY dN[Vf߁@2 QL7t2 t,NfP D_$P!Pc4Rc"'SS'1'U gZҲ~a&c'`,6   2ki1~` غ   nBnnntnJFn aS [ 0̀ 3ێ7!C &?!Cu3ۏR .Zðoh*:ðPJMXmZy/Ip &JJ5W>&go#.pu	 `uQy
 ^pktȿݦtC+t8QWP3 PhX@.X=X@uX_EYP!qup$ q!! .$> u
PJ@Xuð6C @B T A3gfpg tH~u.g :f g&ffS}׃| ffgfff6.<(.&ߋgfBfsDP
hki!t@
WBDBfR`6c6U z u

ޛ(@kރukXO0f?qPf  |o!ڃ tѾ`Np Mp pjXhu\AR@t%tgP&g!ggωf`ҜRft9tg>E @ t9g5CggfRVWf),g>E %^g> !P(^d`g
ز
U.  ofRA"Q2` t1YPQ O݀tu
QPYXP` ؠu 
X``K؎PRfu ZlOfa 	nM @(00	{EfZ :p! D  &E{t"D  $D( s``ف&tPΟ 4>2@"۰Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m Qam p's 0P ar * $mOQa	 & aO# $$<@t"hXRĔKuKK|Kuף`.>st&3r	&ߟ*rFH^;a`prr X ? trC0}qww1#!8Q909$蓨a0){fRQS[YfZwt'1 [( u
| pGa?r0PJ
ADȁmG> f  h4 f>Trxz#w%fYr<fffHff#f+ִ f;wf!3Sc
uff+f
 -/ -j߭:!~!cb흠  TK }.ӎ_dΓ $ -""c:D-ĭU\N--- -F-
%-,f,%iLّW۹:	ʧf
f.O+!u<u<ww2.߇@eBf&@ Sؐذs@r@`'[fS fAƁ;x_V4tp? u_z&[ff[`>ø_ >@``i///6͢rm7" 1_2(fhkvs"q#8,.hMr0A-@fP/c'6fA+uwZq}sdr
qh
	z=sGʱyhfuR ZI0M|M+r	a~ G@ hQ}
 W#!`K|"tz&t.@_fYVA:(3Hݰ1Yf^@qR7_)oRQ.ɟS΁qa:B-ràq$Й,-./01289     +`a 3 RRFu$a,PG3""
P![2t*:@ 	 a`> %l>l!GA lBla6~$?C (o! G @ A B  $0sF  on _"o  BnnnJF$a %JF0P < tq ̢P ̠̡mޢn   0llBߺ  ؿ( lBB@X l@    @ lkТlN8&H'_e /!%а 
@  
FFnR  	n	n	Un	n	n	n	nnn 
 kl t8a  pֲCd̀"`  3>nnC q
p	p.nA
` nm5nq5޿aPfWO4g&g&f_'/>                     [T 80 Oɀ$ tb]T PA7 u BPKnaRP@B u$ZfQWP Xgg3p`Q
`߱fgfafQRfWPSf3f3ɿRf0<  P tSf; X tDtQ[Xf_ZfY<fPffffX,{>  PJE gf^! p|	V					:		Q	^		[f	W		 	_
g&'p?f @ :fPSQWV!  tOъޱ5"1 5hoTTQ 
sY ^_oY[fX>uD?!  A( Ǹ
 E                                                         `     ,O~   
dƐ             p                                                                     6  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  ;P       VBT             $VBT ALVISO         d 0 
" 0                   BIOS_DATA_BLOCK x  
  d3412Intel(r)Alviso PCI Accelerated SVGA BIOS 
Contact joe.david@hp.com
Build Number: 3412 PC Dev    10/08/2004                                               Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ 9                 (  8  [0    ( e `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                     @   H `   H                                           =                       $    (     
 
                                                                                                                                                                   !  R`SI-1362-A   p                                                                                                                                                                               I X <  X<
 2	 Z (-  	
                                                                                          	                                                                                                                                                         
                                     <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                            (  s ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a N  XN  XJUXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                                   
ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               68DTH   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰f    Q7sY 戰f
!  ff !  f   tf ff
#  rfBYf戰YgC!,f3f   戰fHr4f f戰䈰貆f戰 rfFf    戰戰3袉f  f   f戰fS蓋f[f   f   3f   f  戰g&efFfCg戰诉 撰fPfSfQf   fQf3یff
!  fYsQYfIufYf[fXSgu
5  ;u[fPfSfQfRfWf   f3یff
#  	 莅fBf   !f3g}
5    fg
#  r%fG;wg}
5  f_fZfYf[fX   fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   Ifsf ff   fT   Ifsf wfD   f @Ifsf [Ifsf EIfsf Jfsf !Jfsf 	7Jfsf <MJfsf ycJfsf yJfsf b5Jfsf xJfsf Jfsf V	uJfsf 	_Jfsf 
If   t Kfsf 
*Kfsf 4,Kfsf s
nnfLg&nffOg&fffsf fsf f   f   Kfsf f~fsKfsf !Kfsf PmKfsf Kfsf Kfsf ^Lfsf #f   tLfsf ,Lfsf Uf   tELfsf NULfsf eLfsf 9uLfsf Lfsf q%f   uLfsf !Lfsf Lfsf $Lfsf Lfsf %Lfsf %Lfsf )&Mfsf )3 f%"f   t
f_uf  JMfsf ta$f  hMfsf ndf  Mfsf f  Mfsf L   Iuf  Mfsf f fsff   f   f   Mfsf 
tff Ag&uf2Nfsf A%r8u:JNfsf )%u$f3f   u
ffuf   tf fsf   Nfsf t<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf   Ofsf $f  :Ofsf bf  SOfsf f  mOfsf z   Iu f fsf   ffufOfsf #tf   )Ofsf #8uf   uffuf fsff   ftL Pfsf S#f   t$<t)<t/JPfsf )#ufffff   uf fsff   ft(
Pfsf "<t<tfffff   uf fsf   t8f   ftPfsf "t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tss0f   Qfsf [$t<tff @   f Qfsf !2  +R.Rfsf h!<  ff   f.:w .D:Rfsf 9!<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2sff   f
.f   2f   f   ft/JSfsf ) < t8stff   uffff fs2sff   f
.f   2f   ft(Sfsf < t8stff   uff ff fs2sff   f
.f   2f   ft(NTfsf %< t8stff   uffff fsf   f    ft'Tfsf $t<s
f   <tff   ufff fsf   ft Ufsf suff   uf fs2sff   f
.f   2f   ft($bUfsf < t8stff   uf?fff fsfffsf fsf 2sff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%~f   t~.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfs2.<u f   t2kf   uff   u@Wfsf #uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   Wfsf *<|f`Agf&   f    f    f   Xfsf 9f    f    3f   ftOXfsf UfftiXfsf ;fftXfsf !fftXfsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   ,Yfsf <|g&f~fsf fsfLf   f3f3ftr2f   t~Yfsf tf˰Yfsf <	rIаYfsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fuf~.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f~  f Lgf&fftfh~  f~fsffHfuff Lgf&f   ftf@]fsf f Lgf&fftf ~  f   tf8~  f@~  f   tfX~  f Lgf&fpffHf   tfHf~fs]fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	Y^fsf fBgf&u^fsf  ^fsf  tff%   f
fHf   t
.f@Cg&tff%   f
fHf   t
.fCg&fKgf&^fsf f fstff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsHtff%   f
fHf   tPtfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}3.fDg&(Kσ.fDg&.DfDg&f3`tf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f` {f~fsfffsf fsf f Ef   .@ fffsf fsf `wfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@cfsf ;f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
~fHf   t~fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	f   tf~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H'f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   f9i  Yifffsf fsf f ~.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf~  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   $ifsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gft  f Lgf&f   tf0t  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsf   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f{  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   f  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   f fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afAqf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   qfsf *f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  =sfsf $f  Wsfsf f fs<f fsfffsf fsf  fӇ.sfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  jfsf }ǰ< urf   fsf $<  <t<t
<t xfNgf&f   uf   Ӏfsf 6$p2<uB >tHH3f  fsf ȳ 
f  fsf ƻ  f  6fsf ư < uHf   Rfsf $` < te<t
<t UfNgf&f   uB >tHH3f  fsf dǳ
f  fsf (ƻ  f  ہfsf .$
f  fsf f  fsf Ƴ

f  %fsf ŀf  >fsf ŀf  Wfsf f~fsf fs    f   ff   2fff   ff3.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2          "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         [                           o~jGDkED͍#(:of`0]ٶUVo^#j	lfYF;EbRi; _ OA 9@fhP) ?ٱCbNv4gғjF^SzDM6c)@#$i`]).?mCmϰg;І\[A;n-]uM^h:9*!1F;ޑW誩O0~1_)W*yBd.vOr/ϴ
%>2=ׅYXtSc!TFm֦U`aMH1':
Z󑈷5Ԙ|ްao#1\nѓkݷOL|)<F+z  :~VU-PadX;*?.5Uc-oh@x/Rdlۑxf&\݁'KAqOrbUd	Csʩ^w<AO<q)+	dCfu%_,[S\
[+f(=]FlJ߼qS:<xM+ٟ;ݞ^^פIQ>wm|
{OYS^9E@3OZ@_БHg(R	"t3٨_1UW!ߣGhϿl4d	}N*w|<gFz+Bs.4<0
2yUsiɕchLEH2$ql[_B,>)c-6+AjS;MF,kOHUAimX?}DS}[!AnjZfe\Ҥn(.VV"O3%;H׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        D   @    L       @       H         `      T    G|   @ Ď    Ď    	 T    G                   0        	    	 		 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D    X      P    `                O    O    
Ol 

Ol 
Ol 	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 	 x   @
1 1  @  @
	 	P 	P0	 	0	T
	t         @  4     	4,  <8	    , <8	     <8	    <8	    ,<8	    ,<8	    ,<8	    	,<8	    	 T <8	    , <8	    ,0<8	    ,<8	    ,<8	    	 _. U . " /  . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /  . a /   . p /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         =                    	4 @     T                      d  ` h  $X  '     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<8	     #<8	    P0#<8	    @#<8	    PP#<8	    	 #       8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O  N            0              < ff%f  $f$
t)ppqtf[fupppppquJffupppppqf f  gffLggf^gfnf    f
   "}f۬'fupppppqg- fffff  @$f@$
= u$<& fTff  @$f@$
и f  D$fD$
аfgf% = ufKf f̭6f % ugffU../0./.ff d< uf)fd< t<t
u掰fQf䎊fcffuf掺<ufif  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f.  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   ff˱  "ϫfױ  對 f    < tg                                                	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8       8     p     -         8i        8i 0       8     p     -         8i         8     PR 
 ZXPR t tZXPSR  !Z[XPSR t t
 !Z[XfPf   .> uf   f  f& fP  f  ff& fXfPf   f& f& fXfPSQVfWf   ff&fGf&EN fP  D$
&D ff&f|u؃ >fP  f  f& f_^Y[fXfPfSf    f   f  fdff   rf[fXfPfSf    f   fdff   rf[fXPSQfV5$ "  f0   &Dtvu;6r$ &V O f^Y[XPSRV t8 % &&  w-k&>	u^Z[XPSRV t8 % &&  w-&>	u7^Z[XPSR      Z[XR t tZPSRRZZ[XÃ<t  <   2  (PRt'tPZXfPfSQfRV+f fU x  f   fdV fdVfdVfdVf]  N t' 6 t p ~% f  fP5X t"%f  fP
X t"%f  f`PX^fZYf[fXRf  Ӄf3ӃZfPSf   > t!f    > t
f 0  [fXfPSfQRVfUf  f;tff  $ t$ t$f       ff&    f  > u[fù fW  gf;tgf)gf+gf)Cgfkf0f3ۻgf;tgf)gf+gf)Cgfkff]^ZfY[fXPV% ^XfP   x;u ;u   xfXPSRV&  w- &>r&> rG5>$ u&>.u&>.u&>/uE^Z[XÃ t                         '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Ĺ    戰䈽j戰䈽ff
갳ff#d찴f/f97fEfO[ f%"fgfqwffHfif gfQf찺f;f f
   `"	f   f3f30f  0ffuf   f f    0f  f f   0	 f%"fDff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f.f  
_f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pf    Uus 
 -
  >
rfg  Ձ ( r  .9V>Mff<>3fffrrfff> wf   >ff%fՠ3fff> trf> wf   >/>m>dff   fF>=ՠ,>#ա>	ff  > ff'fՠ[
r$fff> trf> wѰf    
t >urd>u]R	 D>u=բ/>u(fհ 	T  Ճ>	r  KL	s 撰 XåŴd~Ɲ%~ǋǑǦǸfSgf[gfPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf @
 > u> 5xzyt^sfZf[fXúz.yuBsfZf[fXPR tĺZXfSfRf @
 > uB ;yM@ts(xغz,y0@usz.fZf[Ru	sZ       p     -          i    p    8-        8       8`        8i    t    8-        8h       8i          i  t     i       i       i0       ip       i       i  4     i0        ip        i   f`>' tI%(&4&&;Āu< &>vU' WEG{
ɻ="yfaPSQV ʋL	;t	 0 ^Y[XPSD	%ÉD	f<t[XfWQ f&    Yf_f`f  &)6UMcs>)t fafWf  &&E f_`r r3 a` ʊD
$&*
ĈD
&*Ms>)taf`ʊD
$&,
ĈD
&,MsTf  &< t>)thfa6rfWrNf_    f`f_if  &(ff&Uf&ErY6   U  rCQfP 3f  f.>_̹ fgf&fff.>_fXYrufa`0ʊ&* D
$
ĈD
0ʻMsZ>)t|a                 `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva   f
   `"	f3f3f   0fffP  0 f%"	= t*PR ZXtu! 
sô ` uR Zts+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f  +   f"     f6  *  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_ZA`AjAnAfPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X   <t ø fSQ >tf r	f  r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f p  rg<uf   ⃸   Yf[fS>tf r	f  r>PfSfUUgf*gUfUUgf[Xgf    r
g8u   f[           f  f@  fPQgf0& YfXf    gf~gfNgfVgf/KfPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX            A PSQRW0  3  3  3_ZY[XPSȎػ       !    A   f   $   c  X  M[XR # 1 ZSQW   _Y[SQW   _Y[SQW   _Y[                                          Q  YPSR+;wZ[Xf>  tf tf`f  f3f3f3f  gfffCgftftfaf    f uQYfVfSfQf
!  f   frffYf[f^fQfWfVf @  f   f  gff^f_fY               fPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfXfff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{f2ffEfd    2ø     b @ ڻCR04/13/05DHTb