#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTH ROM)  - Linux-Based"
BIOS_VERSION="F.03"
FILENAME="sp30431.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` /@` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  tz22  z2 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  z22  yp2 Y  8DTD   BIN  0z22  22    8BAR   BIN  KG22  U2    8BDD   BIN  H22  cW2    8BAR   BIN  O22  U2    8DTD   BIN  qP22  JY2    68DTH   BIN  fQ22  K2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZYY  @  
   _             
(      C   
  `  C            P  
          v  -  Q  t  c  Z                y  S  =        {"  u"                     ,
 ,
 ,
&  &  &  |&  Y&  )&  &   
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
B  A  A  ?  ?  ?  ?  j?  D  D  sD  B  vB  ,,
,
,
,
,
,
l,
N,
$,
,
,
,
,
,
,
d,
F,
(,
 
kO  (O  O  O  N   
\  \  \  \  u\  _  d`  `    G	,
,
,
,
  v                                                            3Ðj茏ː
  F  F~ F F^Z9 uvfv%}fvfv%~hH	h jKRP蟊Vtj
fvvP輋
hH	h jL`RPrVtj
fvvP菋
 Ð3f>\  tf6\  f>  tf6 
j ]胃  Vh jh jth jih  h j]h ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hl ǀF^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPfjbRP芄jRRPzjBRPjj2RPZj"RPJj	RP:j
RP*jRPjRP
j
RPj]NFF9F}-^v&&?-t^F&&?/uF jYZ=sjvtRP蜃j]@YtjwURP}jt]>V   hH	h hl bFHFuj fh  ! h(
h4豈f6Ffh   h(
h4tbz f6FXafF    .^	| ^&04^&4F~	vF  Fz 9F|F= t= ujRP谂j\BYXfh  j l\ ^ \ ujxMRPujl\i
>R  t5C  Xt( !  9  =  A  E  I jJj1fj   ujxRPj[t(`       ؎f&fjvRP豁j[>P  t>R  tZ  X  L  >Z t>Z u& & & >Z uuD>T  u	>L   >L   >Z u3T Ht	HtHt8j uwjJ-ulj?j.>Z u?T Ht
HtHtHtIjj AȐj3u+jRPˀjT HHtH
>T  t7>N  t0fLA  hLhLj#}
>X tjJRPr>J  tj \ZhD  F >D >P  t>R  tZ  X  L  >Z t>Z u& & & >Z uC$~ tfj fj ,F  t=HtkI-
 -!- - - 
tFf>  ~  H    6 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G|&Wpfj ?d     F >J  tE<KD B= M- K- '-M- 0- )fjF6>J  tp
j 6X^ÐU	^&H&JÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&ÐL"N
z hthLhLj=>X2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP襀
3Ðfv T  Vfh  P FPՀfLK  FTzhthLhLj}>X t3^ÐFPTwBFVhH	h FP@~RPhvhH	h fv$~RPhb vfvhb Hv ^Ð  F4F(
L"NFTFzhthLhLj0}M*ÐU~uhH	h  Ð~ fh  `hH	h hb YFHFu3Ðf@    
f@   ff9@sVfh   f6@fh  `f6\ Iu*u%f6Ffh  f6\ Z= uF&G
 tf6FX놐f6FWA~ uhH	h 3a     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP~
#fh   vfh`  j f6\ r
Bv  WVH	~" f~ thH	h FPRt~ FPu3^_hH	h hb WFHFtj ff-   fPf6Fv
f6FjFPu
f6Fx~ uF.~uF6d 8Fue 8Fuf 8Ftf6FVkFPh`Rf6FU ^_Ð~ fh  G.hH	h hb VFHF
f@    	@Bff9@sTf6Ffh  f6\ V= XF&G
 Kfh   f6@fh  `f6\ )t!f6F>Ufh  `b^_Ðfh   vfh`  j f6\ \U     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP${
FF> tjJj1j f6 Z{jhH	h(      RPz
6 h(
h4     RPz
     ء^ +\  &&W    f&        ؎f&       ؎&  E&  FF܌VF X   R   Z   fL
S hLhLj^q
>X u_>O@X RfLN  fP    FޣtFܣVhthLhLj%w>X t>MuR   hJNu~ tZ   Ft
F$p*Z Ð&  VFF܌VfLD VQCzThthLhLjv>X t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	L&LZhthLhLjMv>X tjifRPs  fh  ! h(
h4xj=RPUF  @ +FHuF F^	&4,x(&*(h(j*mVF 9F}j zĈf<t<uhH	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>X  u#jIzRPrjJjRPr3ø ,x(&(h(jUh~tuÐ  fh  u3fF    fFfff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "h(j
TjoRPSFF*;s6PjNRPSF*Pu,x(&
(뫐,x(&
(h(j
}TjzRP!qju,jCRPqjDRPp>J  t`hhb jRP-SÐ  fh  h`hqt"jKeRPpjLURP}pjyCRPkpfh  ujEF  h(j
SjRPRF~uJ~FF*;sPjRPbRj F*PNu,x(&
(띐t~ F b,x(&
(h(j
RF~sF F sh(j
RjQRPQ>J   FF*;sfh   Pfh  j f6\ fh   F*Pfh`  j f6\ F*Pj&RPjQj F*PVu,_(&
(\h`hb jRP)QjYRPjXRPhH	h4 	QÐ  fh h`hMt"jKARPinjL1RPYnjyRPGnfh  ujEF  h(j
kQjRPkPF~uJ~FF*;sPjRP>PjF*P*u,x(&
(띐it~ F b,x(&
(h(j
PF~sF F sh(j
Pj-RPO>J   FF*;sfh   Pfh  j f6\ qfh   F*Pfh`  j f6\ F*Pj&RPFOjF*P2u,_(&
(\h`hb j RPOjYqRPjXgRPhH	h4 NÐ  F >Z ut~ thH	h< hH	hH FP.hhH	h FPKFVu3vPfh  f6\ |K= s^&G
 tF  fvPJO>Z u~ t	hH	hT hH	h` FPghH	h FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6\ FPy0F~rhH	h hH	h< IFVtvPfh  f6\ QK= s^&G
 tF  fvH~ uj/RPLhH	h< j!RPLF*  F xu3E-t*t~ thH	h< FPej"hH	hH FPej#RPFPehH	h FPIFVtvPfh  f6\ H= s^&G
 tF  fvG~ tj$MRPK/F~  F oh(j
LF  h(j LFj$;F~,x(& (܊F*PjRPcKf6\ FP/FF~s#~ t~ u,w(&
(tFPFPj%RPK~ u~ tjjgRPJF  F f6\ FP).~uPhH	h hH	h< GFVu3vPfh  f6\  I= s^&G
 tF  fvdFFÐUf6\ FP.Ð  F u3F F~s7F*PjRP*Jf6\ FP<uhH	h2 JhH	h hH	hT FFVtvPfh   f6\ BH= s^&G
 tF  fvE,x(&
(
h(j
JF h(j wJFj N*;~,x(& (Ր,x(&
(h(j
+J~ ujRP%IhH	hT j!RP
IF*  F u3t~ thH	hT FPQbj"hH	h` FP<bj#0RPFP'bhH	h FP~EFVtvPfh   f6\ yE= s^&G
 tF  fvMD~  j$RPIH9EF ph(j
IF  h(j 	IFj$R;F~,x(& (܊F*Pj[RPGf6\ FP:FF~s#~ t~ u,w(&
(t~ tFPFPj%RPG~ u~ tjjRPaGF  F f6\ FP9u3À~uLhH	h hH	hT DFVtvPfh   f6\ rE= s^&G
 tF  fvBFÐUf6\ FP9ÐU  
2

 UvV>
Ð  >
vVF*^&F^&  >% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2F>F 	F  iÐFi  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRhH	hl ^Sab~uvvhH	hv fvaÃ~P|FlFFPvvhH	h fvaÐ  FPNQVRhH	hl fvavvvhH	h FPraFPNQVRhH	hl fvavvvhH	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;D}DF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FDPv~ 7
FDF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>Z uFP_!ÐFP>Z u0 ÐU>Z uFP+ÐFPU>Z uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh4FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh4vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh=htLth=hِ 1= t= ut Ӄ>X  t fj h
N3  F"1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 "Sh>h(*F*P̓uF"z j h>h( j̓]FUtKjh̓h(
hb j h@lfj hG=th>h(EtÐh(
h`h(
h~&u{Ðu&{ÐU~ u h(
hjhHh(
h`jh7F  F~ ujFÐF Df>   FXy j h
@h^fh  L΃uF  Fff   ffffN*+;=|;s7F*@N*1 XSh
@h^j F*P̓uF2uF~ u~ X1 F F~sF X1 F cFff   ffffN*+;t|;snjSF*PShSf6\ Tڃfh   F*Pfh`  j f6\ ڃF*@N*1 Xj h
@h^j F*P	̓h~ tfj h!F\  fh  ̃h(
hb !fh  ̃t"h(
h`h(
ht";fj hE/fj hb=uuh?ht!h
@h^tfj hrU~ u h(
hjhh(
h`jhF  F~ ujOFÐF Df>   Fy j hBhdfh ˃uF  Fff   ffffN*+;=|;s7F*@N*1 ShBhjF*PR˃uFuF~ u~ 1 F F~sF 1 F cFff   ffffN*+;t|;snjSF*PShSf6\ ׃fh   F*Pfh`  j f6\ ؃F*@N*1 j hBh#jF*Pyʃh~ tfj hF\  fh 5ʃh(
hb fh ʃt"h(
h`h(
h聻t"fj hEfj hb=uhlBht!hBhtdfj hÃ>J  tj htD D   1 ~ uj߃FÐF Dj Ճub j h EhtF F~s3a F*1 j h EhFPuFA j h Eh|he>Z utTtMttFj t:hlBhCfj hb=th EhtÐ  1 ~ ujރFÐF DF F~s-F*1 j h4FhFPuFA j h4Fhh
또>Z ut>t7j h@wfj h=th4FhtÐ  01 ~ uj݃FÐjӃuÐF D*b j h Gh6tF F~s3*h F*1 0j h Gh6FPuF0A j h Gh6h
c>Z utTtMtFjt:hlBhafj hb=th Gh6tÐUfvhf  |JF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
|NJOÐU*FP|PKJ*PKÐU*FP|PKF*PJPwKÐ  >x u7]  FVL;Vrw;Fv	x ÐFP
uh h Ux  >x u
FPh iÐUx  >x u
FPh IÐUFPh 9FPh -j>x th UFPh FPh FPh j|MÐ  >z tRFPh FPh FPh FPh j0 h l<uz  >z u&v*N"FF FF
FPvB|JÐ=tw$-t-| u)~  >~t% Ð~ -t-t t-0 t~ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U~FPgÐFPtHtÐ~	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  p h FF )fF~}j v`tFp  F~s#>p tFPh F  f+fF볐>p  F  `>p t(^&k^&?tp  FfF~|F~s>p tFPh ;f+fFҐ>p uKF~}Afh   j FV^& ^& h.p F 닐FPh j FV^&^&pÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h rfh   FrPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~urPh Zj FF  	& FP*ătFPh(
hփ~ thH	h
hH	h
FP3hH	h FPUFVu3vPfh0  FPLfv4FPh(
h`kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhlnfh\  hj 6lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6lhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	& FP貶tFPh(
haɃ~ thH	h
hH	h
FP&hH	h FP	FVu3fj hvPo(
fvfh  FP	fvFPh(
h`ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû~ |Ë~aË|aUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..^f^gef[UfS..^f^gef[UfS..^f^gfeff[UPfS..^f^Fgef[XUPfS..^f^Fgef[XUfPfS..^f^fFgfef[fX                           UfPS^tf3ff^  f.
_._ "  u  $" u [fX 0!<s3P˿(
6 + r ׁĞsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6
+3	O3X 66666נP.`ظ MaP.`ۚe  y>	uXP	 P(
 5! %J`!	)&6, 		3	sx		 	&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
8t 88z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï  <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  & U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV 
;t@t3_^] UWvt 3I >	u	@!_] SQ |QP,[|Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UW(PFPvv(PF(PWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuG(t4tLu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVxFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWv (t4t	LuVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.~wpsZuZuZu>wr>w>w>w>wJuss>w>wp>ws>w>wr>w>wpRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] yy4yhyyyyyUwVW3FFv&vF
t~ }F, <Xw$ FF.xV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uumsWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
~FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>z tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uwuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B(
&|=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WVX3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWV(vv&(PF(PW Pvv;u),x((&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3(
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	8t	F3] UFu		u { rFGFF3҃vvډWNu(t$> uS#5![j#%!us厌ʻ 	FV]U컧 .8tK
Iໜ	]PPR.`؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PU(
ء	F	F]XSQR(
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغy$%!3]UWVRQSP.`ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;u΁t΁^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    (
              4.63  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   H	                          68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) A  + , Z?  . / TD  Z [ D _ ` E c d F f g G '  (
 ^  (
  D10/17/2001  O                                                                           H	 H	 H	 H	 H	H	VH	H	H	H	(H	ZH	H	H	H	0H	LH	jH	H	H	H	
H	,H	LH	\H	rH	H	H	H	H	H	H	$H	LH	hH	rH	zH	H	H	H	H	H	H	H	H	6H	LH	TH	|H	H	H	H	H	H	H	H	H	H	H	H	H	$H	6H	JH	^H	tH	H	H	H	H	H	"H	BH	fH	H	H	H		H	*	H	:	H	L	H	T	H	b	H		H		H		H		H		H	
H	"
H	F
H	L
H	f
H	~
H	
H	H	
H	
H	H	H	 H	JH	LH	jH	H	H	H	H	H	&H	2H	8H	ZH	H	H	H	
H	
H	2
H	h
H	
H	
H	
H	                                  E    F    B j V(
      C    D    B j t(
      G    H    B j (
      K    L    B j (
      O    P j (
      N    M l (
      I    J    P j (
      -     1    + m (
      T     Q l :(
      *    1    ( m R(
      R    S     U   
V   
Q k p(
      X    Y    W j (
      0     1    . m (
      ]    \ k (
      a     1    _ m (
      e     1    c m (
      h     1    f m *(
      o    p    q    r     s     n j H(
               Ta                           _C_FILE_INFO=                                                         (
               
	
\ \                                  1(
  1(
                                                                                                                                                                                                                                                                                                                                                                                                                                              (
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          6b6b6b6b6b6b6b               (((((                  H                                                                                                                                        
                                                     I`I`I`                  i(
(
(
(
(
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                         p   `      POST  f   f.V .X <  
 f.d ` j  I     '     p      POST3 T| ) F  Y xz G 	 s
 #) { (
 { } U( ې Y  ) e ƴ 2 3 3 ]3   z  t bv Tu  p! `" +#  $ -% & z' pO( X) ̀*	+ l, y- 9. G8/ Y0 01 2 Њ3 .4 5 P6 N7  8 t9 8-: Ц; 9-< = -> ? /@ :-A 'ZB .ZC V-D zE F tG H TI (J YK {L *)M vN 3_ 1)P Q R {+S T k-U V jW X ;*Y@Z mt[ Y\ 	] G^ 4|_ ` Ya f3" f" @ ؠ   ؎  f{  3  3    U QVW.D7 PX' hX@ .X=X@u
_^rYʜPPSظ h@O [X /<t
PW f&E1_X  PRWfQ
u5p (t'@9=Rff  u߿ h<8ufY_ZXSQW< s۱1
2
 hZ3_Y[ABCDEx} UfPfSfRVWf
fFf^fNfV.< t ~.FuN._^fZ?f[fXQ	
}H@
	y	! &
%s
> h3Chyp ?   t  Ãu
.(u	u/ SPVF	` u tR	k@.ytމ^~u 8	kt/ t^6
5
^XfQW~
 
' _fP	$S .#00r#Lt<
tw
u!ο 	1+ظ_^p	+!QfWfVu*p#)6S
F f[tҋ3ff^ff[f`K.fa2 Ap8fVWUkA t  f`h2%3 tkfϿAh6 Px'Q20D7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^Cf`Sfff@= hR3>+f;r[@ Wp
2h_
 WX
_: r
gN1
g.@r g@99 \!BWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_qBU/tg^H2N@?" h fR   둡4]]QRWV^NV vyq6Q3qI4GYGʫ}ΕI^_Z!3Q'M0 pC8 YfWV3ff"1
bIfPS.` ,.:(F,(  f$(0e^
#N~u!pY
h.`   蟵GFjQVRaQR?(
`zۀO2ۊ~f@m{k:P`?tWuf@y f.((|ftf!f.@# >=
uF8Fuf_ZBfX^ÑGVR.>(s$0q	.k6(.(K

ZF(wPn2
F~0,(FPPv2PqN~ t4vf2&fߋz10{
FNNI..($fQvPu@f(.;8(s0ep~  ;u
t`gs_t@Ѵ 8^rf(  _^ZY eWQ3.>8(2 .ǅp.ƅr ` P@hNV.:( `s$' ip3.w8(lh>z? o.N /p\wFk@"~ 
N~f.t=6@.x2̠0/tlyu4.Btf<t؅f  `b$< F. 
1wq3V@~rpF F;F F2u~w
`Mg~f1 kЖ lt
fNqu
ffsfF;^P46)FQz
*q4rF$<u&j/F ~#~ ~$w_p` z.p< O<uO8q^`V@;8(@..8(;8(^éV0&0
9t@-2xk@2
E/1^S 65^35}#wuB.X:NЎu{P:
t3S9)vu=8N0w_^WV~\SVR`FfnA*J[.z!ffAyRffP%Ѐ`2ff
ZKf;w
2.fPRfPt#f3!fD`XfffNL$ss4
tu+q%
u	AfF~aJff^Z6Waf F^~K"8ueffFՋN_QtcV@hvb!F;pIz3ϋ~+c:tsRVRfQF;F8u p? kv@k7F:`pb:$$@Kz@3frD` w;=< u  r,.;D$<uπ r0	 @BvFfYZt4}VWv Ђfq|~|URd
t"t_t̢ @DvP }Pkq9SV@޾O3; t	 r^0PkO˸#Aq[%S ^Y@jx*pt@;?v7h!1k~@st 1;FtFk^% Bk^cՊOa 3҃  V3k`[
*䊁O;oFuR*3]ft7-+k	y	# a
@S
+FHu
4uGrvFvVB7s0;~HVW΂tS03ދ[^NuVp 3+0_&61-Dr<lFxkHpBHPy뷋A(7,oZ &0V  ˋ~1|\0PN~ tKv0}YFA.Qz$ x
fpO3g FfN@P@ 
0K SQh$(	 s\P,Q23If.` tf.&!. .8:(tOьL$QVW
fvUFp䲋"`F^^~F  FψF
fgFF ^Vڐeb"e^`L`Ч!ɺ ``Nf~ tFt'fy`e 9Fv@f0
FfHf;FyQkr@րi`QbbbfC<4zRVFъF8F^ pVF0 N$ &(,ytN!!fsШ#tE rts@CA9FvG 3r%if.$(NͿ  `Ne0ƺ0 
t
F%  .,p >fg~ t(i'i_f^z eu
 v@aQI8t%  tu Qu  vfIft'fAff#a f𑘐pЊ=srSf.6 G                                                                                                                                                                                                                                                            o  PQRa&hk@ $`Ȱ hf?rZYXSQWa$a$a  h= hy >5_Y[2 TCA6  @A Q C@@ @;uY!$p h*
f`  H hf4gf&zP   fa..h
 
<hZsfPfW@&|'_fX`i
u/h	.t_%`0h+Q@c   &  @Q~@ ؀  >J&}uu h|lb!3d 
  % V߸WU]-e&$@#h&ff
q߀tf%af5h +su h9*,Ⱥ: @p 3ȰS, @uwSh3.hń PCN P
V0	
`  
hb2p!úvû   P0I"E" f4%  0BHT12X21-220LTN121XJ-L03 4IAXG02C41LTDEC5V=        + + P + ,
 P f`O  3,3ۃOu+,,q73ɊOt
,r3_ø_{ h99[   й `U;aÿP hc5G`8 h	#> t
  Q`? @ PQ= `t
3f3	@fYX _Tðd߫`Jd  UP@V `S |04'F  :ؿ
Et&؁U uM9NwN#uӃ~ t"F= wt%   +ȧXXh2R`..   !	 O a `( ?u2hVbcp6t*6u `RuraÑTtPRfZX[@(~f._~ AYf` f   O]la"fSfQfRfP_  f,%=uf?a2 ffZfYf[\SQRfW8f_Z YhCef  cs1@^OZ	 /\r)f`Y0s0 h9rf)rOsg QEy
RKjfa't5<t1nf  q)@ Ā Æ B<  C< $ # Q R ST}f`/RVW3y, '+#D#
` b~Paf!< WуtR gR``_^ZY}1 Q   Q tc4TC4nc4NC4/P< f`Ȏ)1)!  hS)i11NNB1+G;rO}1rܰGq֔
腖fa A	   > 7 A  T ӟ M e M A@  9 Y .    ?n SA 8>b (
O  `T+T{!`U0@2 P f2!PX62fߥ6<2; > 3 p"ߎ 602>xQE.h3cPS㓻 $<t4r [X)    ЍOƋoh33 \ f`4 S  y6h3%h>`  D 3y "r< tbF26,2"2e+Jm 1,5+r7+6,ސ r%@X,A+&5&D&EN+?A)`
phœ p߿v,psZ%pn,V~_^ 
8
3
~3
,^{M
,Kb o0|Q,b&@ U$=u&,f= =u X&,&,&,I
, fgh  0 pqr  <ABCDE xyz{|}   )aV S#
fl jm쾶5 r&M-&O-5 r
&  ^ 5x"s u-3nfX@cCf  `rf5f]x&V3
Ê^`0(.'t%.FuN.P), _XWfVUSWSQ,fvXT  ޿RvU~2V2ك!IN܀3d	^
u
t_NA&>5+_[]f^_ PV&=;u&&4u&^P
P<q +&~& 1E&Dp#bSV h@r^[þ7ݹ`[WfP@FhS@ <fX_6_F10=ROM Based Setup  Entering{8`. u  8? J ot.8 `9 Su)!`- W  98p 1A	A8 18q&rJp &8tFò  et
.>	t.6Nt
(*At hoCPXhm:s{F12=Networkrvice BootWake On LANAttoemptto %  h}Bt8 0`9 ;r	 A`9u a91iIQ	t yItsR QP.`9$<0,(o 9H*B"`9! ds@C	%25ؾJ<^s 7_E%з VRyoJlNF J3؁áJ?	uCFG~N0tG;hջawJ<vshZ^@òP*Notebook hard drive MultiBay"DoKckQ%b<#b (top)b?ottom)leftf	Floppk  US9BCD-!F :HDis/SuperN#IC*
!1	23                         D=bP  	 
@ڐ
>m4P R p @صpqlectZDeb]s  ͹U8 and _mo@=the highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start:   6?L?(t?$P ?'?;S A;Zip.F`u߳ hs d0ô0.?Ӎt@< A VJ3J؊' tA<v<st1(?& 2آٍ;2D=Q#YAr	 > P K@.$?
*}&? @&?+jjj(Pj
8  ?`$?> z    ?a R 2җ
  ߀ t03(?2Ɋ F8tFޣhJ $_ Zbqqp URVQ.,.L.T^Y^Z]S,.&?*[QSVW/ s&Q@.<.-00?0?0.Y_^[YQr> u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tuͰw`2҂ X7@
$?>>r
;w2p$?Jơ}gFY.*&?<u2K0fhZi= hshy7d hb<u`B J qWo rf.>C5 h9	fgf&G, @ fo   PG0f@G,Nu
hEtG,f",7f_ffP QW2_Yf= TKSt0fXbo    ? o  J  b؁h5p.
W
g&Fg&Fg&F"t7g&F0va 1 2H޾tD׎~ذ:{ rsvD	 _k  QRVDTQF r&e^ZYDffL (]LрY`VUfQWo
ِx
K&@
C' C$vC$0Grx  q## r]".0tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ!$&C"u#%$u!#,wABM  f.FwPS [XAu.6Ff.FIDNU.FSfV#{3O #^3%%Ýf@	~3u
u\ru!q!} "@*W3 hmZ **hXr3p%5cf_ ]`= vH O1H aP߰ hk"$@<@X7N4 PR ZX@ P.>G t.G.G@aGSQRWh@r_Z>P TC r99 r/ u t t@XR1$tutZ 2 WW$ f3hcXRISWQR Zuʀ[Ppq4{B XZY_U M%Zу< @3ɹ2 uhXdo#W)¼ P% = @uXu%)4_g&@LhH0VQfPvf  g&?t9g@YR%fP<u @^  f%?f^#   f@"f<tf Q	 f !pf 1^fAaZY^$fVL/
/ZGP@t


q 
"
f^}ff? wD Pf%2к
!
hfi4H30m4r H5 0P@p <8	.12 P` E q "R= LP@pȈa L`	P  	`}i~t  DA& Atf &-&-@0PWfP'B"(rt ufo*H./D.@ F c>- tuc ~rh^
& .p=C<thp}.  G11?}4 Q < t&(.GH.f>&QI_
py3f30 2ɴ*f&- uf
ffKP.&.&.fC0.H.ʁ.p.15RfVWf D3ffCf[fKfS܃fF0rw0а K I+r-_;Zf5SQVWϾ u3_^} 	!BKsV 
R3
t<^f~
w/vƐN0fkd`afft@`[^ɳХVQWfv h-F&/F&p & &P&&0&&{&ŀ_&/^zPUȡf  rX)Tu'P h{|l" h᳂hgaX`a؀atiof]PRqQ ² t%  sS fEQ ffff>AQfhܳ Kg&; Qu70W)f)Pf~Y~/u! /u/u/u	g&t(tx3	[rnf!ǂPR  ;`o	1/uP~/t ~r!	 u;NQ5 -                                                           @   10Uf`f.<Q@Q?u hNrW2rRrM@Qtf0f 0R| Wb t#Cr"t߃ p ; (PJR  ZR 7f]L@V0r*6^  R ZrG	Ku ezdB rC\Aݹ 3?Xy8E tސyEG 	U~gSm r	S>EQ	tlkQkpbƥcW rt r
  GC_SRA0Zt$ؤ5$]WPݰ  _W}  sp  a!`P
߰@S P  	ð D v Sذ8 3 e _R	Ǥ!
R'
9//&QQWjuptPX_Yù
 d h7Cx1s y
2P -C<u4-uĀ qRRaR12e< uZ#ȴ$? t	xJ  U[
	a!"(D pn@ K@{^hYB*h=aßhr$T/h 7Jh{B.u_va { r PQW 0> 3_YX
hac=F H=#h`5s	W> ;Dð   ! $!f` T ahk8@u[' t/ h=Ca0vPZF X>(Z`!ؾL &>J&DEP&D >Ju kdW j@ t~J}
 +Ȁ}	 >J 33SPb[tS[>? 2[sDy3 t^h#ʊWs
ߴJhO#OaàhL"PD
ϰ<DuL
p
E$ߠ<u D
@Q1Csd
rSi&pS]@` uL
 ߃6 6J u  (X6 &uhT
	\

u.0   ND&}?u
 t&Eb t

&E^D
&Efw>Bt6j t.&t	&  st"& xu	\	PS   ? 4P'>J_3& ?! W>J	_[XB
t+# P xt  t  w\DPV!$!"桾tKh10&,@ &  ^X  hC!r!L	vTt
v߲`WU$/! $<v@a`l3  v
p
u$"<uP>ȷX\PRt N:1thE[!&ķ=0߿ZXv` 22PEǿJ&PCt5ǱJ=ǡJtOu570: u	At!sy96 u5 .,\s
t!Z&q s   a
׃/]3m "s{&=  V P;Ku 0< ^  3f4G -Kf_  }0 U!    K&egWʃO&MuO OqfGtM!tߴ$Ot, t"OGr ǾJM0oOg&K/` 2%
<t29m21_kרt O<uLDHD =_7_D D	 d
z=1:B]tSpprG&}	r??23P3t`h߇2a&ES$`	&Mo&]AH`.'	@[%# r`S UϠRnb0ZW&= uAF:%I)
hJ
 m_XP
pt   U!w#w !#`܊|unhS0 c.-.MSNv=tI! //(rJ
c.58v@Mu% @BS߿B 0hshyaW!$
"1D h<b
hZCYp@[X_Ë
`PS@e![X SϲWH<vLR
 Z,<u(Rff9ş,ZJ vGu

 jS1 6o[Qaw$ ;@aáf3Ұ	fh`֎` hs73۹ F
t):u%b7bD	& h.翱J & 	 hRJ3Gaº3 
3 =Ѧ  J aSu   [R rOrFEqfQ r.<t*DN<u&' t&A+ Ĺ'v
v'+QQy;s& 0R&xZ0xtp_ h qYQ<?v [r(˥u% = tpYjLYS3J+6 
{HHaE&E , ^rpVpVhp#rxfV @$P<PtRZDP۰ۑuO  ZGZ^+WWV 0  PhrX@ 0x2e&
󪓭%2bƀb ̀?!C@5p?r@Dtg51+pu,{u1 
@a

+&C32o3&@t  %
t&
0  ⫰5  t" -  ( 4?
u: >0.b!	"	? A%w ^QmPRW?&wA &]&Up
t ˀAi{] _ZXr#3һ -wƍ2C.u#o/5$N#h΃&<'߸^  Vj    x 3Ѐ>u _ 'SἿ W [j!Vf\ Wf3fu 3 Q>JW:uBE&8Uu8p]
R +B&U
ZK!ؾjZ6fYB<)%qr U; ;e	Q(0=
  5Ãh`bx8.
<tZێûPV#
@F^f  XJED
yC /  n}ppUf``؎ Fwl. ڎfafSfQf.lf fff#fYf[2VftGf   lIg@f;t&f 	F ǀ%f^`2۲faf`cfaPP3_X.>l, . PTACO F|"  
J!	& .l ws<F	l fFf.l  lF.lf.>l<E.l@  tlttYpltNp  D@SIVfB.f$;VrT%WL B!Z\ܐ	i %Qf{2$fP'fffgf"'r.m p l%f@c .ffHpӡfXf1df33ۃ!u+`s?I
s*"/S"Vf+f;wfff}33RRE׭lo4^q4'r44$.x71p6ɐp08333Ҹ  QW>M% _F
3}5u'JE#ȩ t0 t 110 't
Ήt} tWM_ } ,   ؉F EF^V/ SV^F uQ` &t Y&  
 < tr&\]p &\U  
&N!d J
SR[u0	F@& $F^[_RF FY<p߀TV~'}PVWًذ ' J! _^WfQSng Zpfat
  [fY_` t =$P nPu2MtaË6!s } tp( ` j &?&E?SRUQj@6^]ZV` j(s0ŌD^XP
~*F
  t# b QlF F`(r d3duhX$Ku`<Uuùd `h4d & Xtû   h9B& h PhE'`X!$!   °"s} O
eh2G   t7t 4  h J` {tKu& &  
 P` h,s@<t<uuR 
0u?1*7`P	hd# oXhS: % Pk 0'pjD[%ys%aPXw$# )Р)t`($} f.`G  0m3 西DAm@7 À   ; Z x     0N@`^~#bhW1fF3.
w% r 
\0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہw.~r@V»/ 㐂û< f㺰 fﻀf @ffRfPf!N
 ffFf3fvZfFsfBf〶fp1 r9pf3ɰ`ǿJmfAP  fafPVa3v޸ͿrF3X

S,0<	v	,$x.[W D`

[Lb f s  fɀ
T
ST p s 	 }
Sf_fp fvPUkYP, Pݼ:Fp
uf^fNf?V_f^pPRp*f:VA6F@20hC@ Ϣ
 ff  fffffXCh?q p  `90gz P9d{" 6 ay)P*h|lP, %ofPRh廒K2R ĺZP  (Q * 4ff:aD0  f2MMSqhm   h<rR߀ɀhZhSZ?;PSSΕ袮@Apq$~ q!ͰĀup!A tvntt<1w(<v7&PEh3_ P&
0
3q 33ĆtW/g.&;u;@.ont)@)hPmt؀a`2G@t03@ @u  a[
u93Q^2,;8#fN 

P5-j1rX?03?Qr |X@Y4SQ;o2P5'a&& &߶0hmC hزu򿣶ɰ h
t[ Ȱ t
嘪ŀv#t̰,5-PXv8v&> `tw`_P3 u $h&J
#RV s}h uu22hSgu]襺uXP&
wL`2 Q޻ hNu= Dt= tYԀ'
YY0.h^ZeZ?踸P #> \U  Pf^ y]  _`yrr	 V'afOLPH       @6|P0;V(e
u^V- ^"(P*^  2{oMqSP( 22 pX[úB  $@7R  ?Z`7              zKtP(Q % $ 0rxfL+  %rSr$rF!f+Df+\ r*,r3w r@ .Phrjfa2P PR3U0 Z@AR `&Fdx??uho}P&Xhm r.>R.Spu 	AїQR.۠S@h f3f%  f`YURQSWF^
D= F\ ^F \^t
;v F;F
 < uWP  <022 IF t ~uޠ% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
50:_[YZ]`P 2&X&0`PQ0^ kPY@vUkPkPR]]]/?              $?`ރ6.u;v` Ql0 >bh *Yb`"QwLQ`f&YCC`K (   bP3YaPSRP3@mn?[`H@4$&%<GP 	 oپ <BMtf3蕱4P2W X` Er
JRU3 fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	tŀ   
 fް@3t# %t5ubfDqa $<@tS<tO`NBH$u>f=Pۊf@+rCtq Bt#Bt	ݱ]P0f
aff6pZXW_ RWO  3OtCxx ؎ P.BB <t BB2J &ݾ(   8u!@屆`23Ұ
ShTSt0`́ y aut0i at]U U[aSR  4hǣf
 h^SgZ[`-1Pϻ  h=7	 hՕ
 "BPaԀa$8uXRP<u1ZtQrtwvYu0ѹ }R0wZhEU2<Uw  h[2 u
3oҸ EmF)v upQstT 9 
( 3Pf.p UfQfRfUfVf@>h: rsNrBwW3f. ff_2f^fq3Yf.>pfCgffgfׅ suYKU q u, P3	fgf CPpaIfAgabf.#f9ufpfY'40  _  /p ;W5hل 6 Z	7  @Q 5f %"Р  OV3%@tվ p;F ;
V3"/fUi &g3  f% '"꣎ #WFfF^faQ_V p @Z  ?
^`q[3[<   f DTDw R  o 0 ȳhz  17   l ( Pb @0 W HL P`A T W Xb, `
`! p@p x o A0
|\D`QWhD3 3_p 0 PQ= `tq1 @0YX 05SPp
& p  ff&Ϝ X[@aa"&    ir  vf{@Q [J&OfQ9QMh2 ./ Ζ 4Ϧ <t 萍l~̦ tq.ri."D.|u.:DtSI ^ wD:r5+s&v;
uAm
?c1PQRfWT}c`
fXÑ2a`2	  "	f 2f@0f@R %  3f3OfPaX Ah lUv  fb #&f fa dD 	h}W"ϻ (;sQSf  r`
 t
2>fƃ	40q!a
 Q[ff{Y+vf[Wf+_f t%ȡH+f@`h0Qpg-m f@kf`0z q_L2_&U uZ=Pr?Uf uCf*f=`  t0  t( f{{f
1"0"}fph2%/$_!"
 \\-f g&%Իf2@t
 <t+p g1~f&f о  , Xuup Lr}fLBt<rfa&'?rGfʰQÉ_F?<
 M 
"a	Ub	'~p@@R2BuE1BcffF &Ff}{ t@sf @{f;~wt	uɁ~qNїV&##`WfVfPXfXcr<w.Y0ճа_Ѱcf@&ˀtg&TfVR3g&Pf0 `&fnu=жtsaNu(g&fVffA>"[.f+E)^f^uS2u  w & PP0Xt'vt
t@   % r/o h>u  thrs-3&>rwqrRPzsRܑuthX$uul	r` 	߹ +Zjjw b6uPS`` FF ph rou
@ f& ﺁ ؀>t !$!f$< uRC  
N<2<ăƁ	"3uA'y@h[u TYP=t 
u2Ɋ،в3`t<u
E< tE$<u&w $tRVL  N L N@ڰu û` t  P[2u
@j jY!(!!2(<!1ʰe$ h5u$0t$~.#K,.t4&^ t<r&Pw 3.\  5!.\e@.dw b    W	x .|h=_DuQ&~% t P辫Xӹ
 D.:t
 ._
vXP%8Xr6%ȸfyc4;La    PJNL p      QKOMp @Kt  Jt P(.DGH h2h  hvQ h҅ h~E Б?E^  ` f  Cp m& OE 
v? %&Mÿt&:
&;sr"`p$t1TKub 
HM` `(q p" s*r#	cp&3a C 	H ]r5r`2gpjh!˰vZaVRQShm4Thؚ4J.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Ph3UX<?tFohUujjjj P
8 &hm:޳X\ h $vbwt = ;t= Dt
hEsp[]@WVS$`$
w[? @n< u"*׿OطhNt`-->J=Ot_1 0_ tyr rh  >S^1  0 hL PͲ5[ ?  :Nz2?Aq%  	
   >VFPgbǋVW 2_2zt"@uG2 
u
2 ߠ
 o2E2&&&EA &e?
td&E&&E E &E<r&}	r@ VW^2۠^2*
&}vPuh`VRPRQ3{f 
%*t,AYZXRPSQY[XZh?tuS	pp Є> qQ 5rXY`^W-: t
*֮hDRL&&  t8ot' u ag,& nq00r6$^$ rZ& && ;`Z@ `dde`P`  XU @>
ڹ  .PB B把䇿8uG` A ; 5䋀/)@#BS 냑6VŜPX
 a@A@ B C    FtV$%Ȱ%蝊<;weċ X؊<wM3ɆQ#"XR<  YыƊȊĴ3Їу\E pY8@C$0	 FWYwuF5<uz`0Df&	2
pu8f߻hNePӀk 'B@. ,".  濥&k !< uf& bÊ$
r wAu%1uh~Ӳ$s}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh<fMKff
f[h*[f3f3ɹ f [f0m f+f[ ! KMu*MآMcf3ہfsV4C\` a^_^fZfYf[fv3hI 5U=`2K ۟揀L0s< |&	3ytvou4PP 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .0\3۸ 2wҹ%&@GaaÍ6<h&^VWa<,z_^pk` h$h  uP$<X%sf @  t<   4 r	.Ѩ$<u
 f3hh.Ш 
d?]XiJ	hT=  tdbw_3s.>ШNwfm tghtC	
A!U2 u@? o > ?`c 3Fd@ e f Fc~ce@7~e uQ@C9?  hosz`5
P	|h0ӳBFe:Ffu1r,
 h
 _Fdt;   	:  <g ht5Lh{sh`!af`7UPKh!u>fB05񿤯SCA[t$w N hD&N r hPf0̾   F^P XSĻ  y ,    hbS[t(t@_t,Vj Pj,>" ' À thtZdúߋw."**=ED/.EqEq+Ë؀F/VU2NfQa dYF :uE]Àg33t
t
u
1t#u
tN`2t"FF0u3! :5tFFdz ulmb9p`F: uYeb +Πu"<6F1 ep0Fwff`Fup  0j(j	R"	aURϥhT2  ɺ i1 h8rZ]ÓoR+Zr@!  tCgRQ QK.YsY2$
 !u$0idU|Z f`3 w 3uW fI.&Ԩ"^fԨ  sChB%
>C ƀu8u.>Ҩ 1fa
ZURtLޱUHh|lxk:Yn Yp to(tq ;CPZi@"ƽg  squ4@VfRf恎h~$0;^f[r]8" ۡ[Z߂bhdTr s U6Sj@ 2P s rGZ45'_UqWqW`.ӨuQơJ$<u:`pr"&  tޒ  ttҨ} tAtw $uPq9(
ː

 J`XSQ 3u,S?8[rE	ˡ-Y[C& <ff<`00xx00`||	>>.r tr~ (ЃrL]CX̀'tCVG =`Q<Q7W &TZsps6C  Eo ц߆ԆrB zuN! D I/u 0/)0/f#-&A ;q5 F -7&/p0W aUfV3vCDPDQD 7@4?f^]&໠QPЂJ wPduXd@I(aߏ@ `O` ͟/////- "  @f%pк FACSPZ DBGP4BHP=  0938 A|!  8  APICZOnK	a	a
@  		
  MCFG<	1P	 0S   u@(z@
 2! RSDT(  	f`hhwsif  fhpfp  gfFgf  FPTR ff0WgFpf. p^$f3..f.fgfN}0~$f+ ghpJ~3ffgf&f.>Pf(.	t~22@_u~( N g&F	f P  rgfffff+f+.
aM.> gf
$$#DP~Xff-qAFV3g&fFgY[@ff=TDSDt3 wSt+Pt#SBStf=CIPAtf=PGBDtf=GFCMt@HбQr< uBONRUfQъ̓2 tPpx@rAr v; tg&P)XfY8]|VfWfV*f& _fP&ؐ@(#f"fP)6Ȁ$ 4 
Ȱ ּ
ff	hcp (fߡ t  h`jsfPW EfX3/ wdZ$wc g~ t+M
h*3=a+0Q~;g&h&P_g  PSV	 o 4Yt >Gu	߃Ci? uDb& @ {u  ?D` ^ RW D h< hZ=_Z!PShu7tSЌȒfP3h f&L f? C@$L fX`h%Q" 037fP&?   6Ku    EOGKf3{i pH  } U!   K>K&geE E puMPMpMGfEtXAt$Ot3 t)O$fM
?rþQpmMe&KaZtS\U  r.0]h2.Ԩ<kXq_   kø ޳ ltWp`f
hl0lf%ttӿ' t E(뭿7 5)P*io_ԝVΎގE^3f`FF  h>x }us h  $g(,0w4'8  y7Ã9FtFfNA:F> hS:ɀuh(fa`
Ex13ɊMh$Ӱt?

hRp;r#uac5WF _^9sCf fN_Nf.9y0u }0tc` rfQPH_Erf;^uf;Nt;oft) @ 
tF~U_վ NfPV t;6L(.<t1l!RRhǄ
,,׃  ^_pV00 u,h..D+hXڃ p1_fqtA"   u
3   t'0gfy GhEC~G$L<LD^COMPAQ PC Card Smart Reader,GEMPLUS GPR400,?PSCR C1LB REFLEX 201241 PCMCIA6Reflex v.2$c:r$HP
  a@!g&O@ zGd `P ߳ rLfK sor>G	 .D
A O@.d.D?4f_ PQWh  
G.g&:uG Y.~  _YXQ8t *F 
⡥fW
"
@
@Bg"
*
3%Qf_V`bSh:0Gu#{  e~uu .Ѩu = Ў~ 1rp&tj  t_& rT  r&= us0=6>
r/6r4.ѨV@< t ^pJv 
w x y   h8Shmsz %Z굒h{aGsia
qTrPqtI	f| U
u 
!tQ&p9s{	GYV
},`؍vfD   ,AfLs-<t(<#@06~ h	L^PRU32t
t
u
5# t u9<0r<9w/tM>ư7SQ Y[t>"$,0>*SQLiE;f 	tu]ZXnf`3Ҡ&w&h#G֎fwv*`%h㝿gf9t0Xa` 2   0 thbq egf@ Vff3f"gf F f0ɱf!
!޾:h3۹: 8tCRP #t r1hf˩ uf@q  00i{? 0    0     q'  ' D 
 Y/ -bbk`oC@GY kϐi0PS_?.{pVW ǌ׎Ǎ~Qr&} uBr	:`_^d>r5r!r\E@&=ߐu	#0#Hr&E$7u:5}ɐɣm0¯Yӆa
Cr&a)rI DTtr&ϊe`4o5:0
T3
 ʗ5q4S1r#@itct  t$?BffLo  	] 	KVQ
RNQ3q
]
Öʱu0i+oW!z PJʿr8u`_QY_ þL[ r&Uó'N׀gL螳`
Pw4$X` $2L nB0<tH`8u6
uBp & DBlTt
aP 3 r/) r%BBn!J@ 
; 05 aù<t

B Jw 2o@u8` BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&a$vQ> Yr	2Qd'Y}B@?Aq Br蹐M^	 fpb3׾   _ @ P`ңP@\`j h\  H h	S7蛳(k?l hÈ`% `f= @u [jh hc Sjjjj P
8 g\ h4cuq?j&Rv^$bwtQ= ;tbu= <t/E3 {hZtpkfaÐ  ?   tHuuu):p*< uwuup@ z`3'jr! grπ DƆ    rZ у-Z1p$Wp_ǀ uu' 3a re+ tg	%  .Ѩ{fԨ  f~ tpuY[ߋr/s3hoƮ ڻ > ڻe ЃF  ~f c `W tI%r=? OӋ~ t@Ԩ@t0(5@ MF t w0Ó3N !F ~ tٳ	-e0鰠SZAt9A`d f` W܋f3Q fY~@ Ix G"
 /2uJp2:!&= t:~8 lr Ԩl0VQ&oUq
e<sY^{D^
=>f"A	
lq
&:!& :X.Ջ IhBB s
Di@P ;(3 ހ?  A-ݻsC"upm\Y1u[	q	1D!IFt3$a3; 2| + f~B \	(Nf@2Bt1Qr$!$$
7R< !zZ_t'
QVJPf^DUY!Ұ.&Ԩ++t'H"`Xtt.a:``s;߄ 6sce_p_pkoCdqooo#Ueooao
fo谫Dcdםasf@SfQfRp>fGenu fnteluxfineIuofPH>f%`f=rYf˹a2?I@؀ Ut/f00t[fPF 
= ZfYf 
  K   
 SETU ˸ @؎&м  3 r' W@ P& u_SV  GG0G h@    Gu Fu t3  hC) 
h{Bt & ^[SO
&hk" `[U샿VWƿF F@    ԐZ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @-<qt	dR>t <tjjjj3P
8 K.wj5$<t.<@t$t = ;t= DP  hEn 揿  7[FF~ t#^FLr
F FQ  ~ wt: ] cf
 h;\2%PFA~ t
F_^Q
h8ss.&udu   hb,$?wط h;*"h4| #h*f_01FhB%..  @  Y(`p3WVe1E0E.WV .^_UɭP)UIQS6(6*`e1E0eEE.U s@ m2a h4$e57;$|!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N_Y[X   }sc1@ @ [p^ B  (xMsqUmf* %  < ! 1C  3	   kQVWAu% p u㾐  6  | = <t ;E@+9 +_^Y~RWS Ê WCrr3ɺ ޑ܋e\AB rN _ZqSYKK=K
ZQujvz%NOJ5> DE<@ ;<<!<3TuU OOpPt
Pm[VfPfSfQ0ppf3fk3CpP\p|pXfffDDG(	Dh fYf[fX^v#KgO G߉xpQRްC3ۊ%<} t CҋwyB`s|fDf3ۋfË\` 	
C  	T U S V 3	G	[	o	}	`h	xh	  h3	 hG	 h[	 ho	 h}	 axv.L.< t)F.6I3.PF.h:r[+V..^̋] }DF. P .hmXh0؃ 7R  16W  0"mXa Y Z #[  
\a a _BA]a fv g'^a ;b ` `mhcij!k qp10G pppQWĀ>t		 u		.y	_7   O 4a9Tһ -w C.ő/⅒2R+m?n8o7Y3۸  _`߸^va>QRrkPS[Xh(hЍOƋwh
3     o     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	 ;g   09/10~z8S12/00 4 kLite{J{-1|4?|6|.TU"x#T[T0	T@ 
t/{3" 2xev$ÔdP_x>0@Zݨ"2""Pf"x xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`@pcłŃ 瀾xD¯01uү0d01"xt}
~0"x]vvuu˰x!Du(u)u*) + 5FeGauu!,}x00Q<k俐}Dxe``
$`$p

xc2
$xx txDESxxxxfD@/C0y}}r k ;]}d`xGC FP&x}DmQ¯00xtxtyuup*}iQb}ps ~aU{}wc+*")@xjD00q x^Dx_T_xcD 
T e p# ) ,1`~V|
-%&0!PI	P1Tx"p2x~p3T0/ߴ/}@!T_ _$ u!`	rT`#8 )m	04`ht	sP	;G	"+u+$4?iq}T+}'د+p (++@^:,+G
H
0%1vP7",`^80/}@j+.@ /1@'"  "+7x0&x+Ix_`t 7"6}

P} }e	!	  @$#}!}a 
xpxt"xd}<ߗ}?A"@+ 0}A[z#A00x )xh`xiw  p@0S+;/TB+x+¯0);0b 9P4.+20B+`xOՀ	+ xTx !
+:DTBKPF y+kP>

C \Tdp+$!$OP+0.`z 9sR
 ðÔ2@VD0¯xx7x8r x009`6%06 ATߠH`	p5V5l ;A@#[8[N1G0ϫ*05E"`X`X# LXQx,Uxtx0x,q@PD0xT?Tx*Y-tx+YZ@?TxYZ3M^[0MM&	,^wk`qAkPqux__DND0W>   R  V>Ђgxd?pF^	;<[dQh`kQt@*ARx-	+_SRNx*SMxY+` !Lz `R0 
PpeQ`
 RSPPf1% 0Y fPRoe GYWxZAYAXNSXW }#X$0Yip^qZ1ZTMZ1uԱ
YZR[m0c1\߿\TPR\
r[	\S2A}; A}A ",A~> B~@  5A~? uuҌВ"c4"7x'D
 Y /7d`!70h33TT?OC}`07`'`2`=`HpQx] 6uuuuPl uu0 uu5ˏO$pN`0T`
010P@ A"| }(x]`U"+,,E+p
0  +C,,+ +,+x,+0`y!,,,++x_,,"-.?T0L72Qt
!Mt&Ipd `1g11![tU!(0響/0mp/l`
/0d@TzE2AӠ.-Ϯ/0" *xc"+xt`
o3x7Px8NW7tP}0h"[ZYYcdYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >wg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x   ~T@ 2 Y	J @ | @ s   ww ~~ ]r  "8_x4D` T ` D)YRDx2tx1tI- &%[0& &xpvv Q&xp[Sxr#$ % % "2x1 	ү  ¿0 _$"@K`ҿ3#b0"	Mx3C
r beJ"xqF`V0 pC #" &	x30$0%<T`P#"xr`bfp
0"$""tT.4} 
xr$3z 
`Hp`p$S$ yrp C pxnv"x~0	wD0$ 6@Tx~y}D"0p4hxlx}@ oDT 0
 pcB"pxt1xux|"xtx}xuxx|	"xwm#xvPxyvxwf`Ӏp>xw ( Qu}B@
"-`"x-pt %-o00p2tU0/0b/R0h0o../U0`OU/`!!.-[/0/0u/ u/0/-.3P/0!d0Ô@"120! 
0
0!

"0!PǿUH `Up$P	U<0
`Tb" ! R0 º P!1D12Knѧ2!1¯Fx1"`u ?T""34Ӊ53 /:}N+"35{54!_Q0` !xno`xaT`aߓxmp)nvpP*r 3}TOp0@0 0 
ֱ]):Q}0`*/\@P*'2B7Ѩ P` XӀQ7' "0a T?2u$407S0!{z}yD2378
u8 7+
`8608606@2$h' @^Bp4?


פ$Y	0
	@À{0-$`
$`$p"Ya"V4#K0! :0!@À-0
  Ҥ s	!~2!
2xnfPYo0*2d|p06SU{zy{ x xovpW[%_`gK6P2 ( 	4 { W t@;H	5345q3`	t%5544r	@ :0	h0"06`	2A06< L	r@1k 
  
 *90 B 6,G 
jm	" !!`BQ
p0( 6"W^ 
-NU
]nDU 6.(
j'	@bG+6,,f-e2pO7)0	LP-85p
b3.&/05"	c)	0
S +":"088;ofpO:2%!/nc)P3
U1:@Cxm`qe`?0}DН h,g,!a,a b}ew"4xFMNOpxD  Pe4_`^}R Vp0
T4d`$?"4#5p~}e4xӿd@P3 0
3 $(`3`3$`e$`1$%I$`9$`$`)3]$pv~AT Vnq2c1[0TxvF>&`!	0,0)%0Dx  Z3c0a ?3]cP):6P 	@Rи?&|¯43`p`w p\TQ`xj  O*`/CKxv
xD}O`&z0{^`
}iT?DtJ`PpYKT~LwOq"@`T`M	0676$``$p``1e7`tgE7r((^b)ґ(0?'0)a a
Td`x0dp#  xF 0TÔP
*xFt pxBB~xUNNw}wxJqJpȏ:;<t/?=(x ү!:%$t=t=;2!(0 (=o$Px`vT"` 2'<x"ү3y:; 0( ;:@ p0 xόv6QxV86}'p p 7  %76([7  ""88Ô@3`p/p0 
(` /..d`
&~r7?) TP5?O) 4"  40040@O453``/`@$pN54&:I&duP2);P [x 
33oppG*L2o>gp1 ';P"ސT~ +?T#>үd`pxHo 8@22P65b3e1@d@>"01h/ 
m
`,d0xA%30 B1
@
 0E00
TDT@5q0	 3:΀@a_& AP}Nt
 u2P2bt߀l@
Y0.
@	  r1l0dpe`30!DxF105@2`e bC7xnu30 0u3r2+(t1123|#.1}p<0 $32  a<0 }
1pAR ErpM&"^p  d.CBS)x0,u`2:E,`e4 2UU.X5%.? ,* 2732pha,
$,eO!% *R5 }
Q'x`S+0	+`# -R	++@@s@`p7v@}	 `@~A0y!T``;Y_` VWy
7p~Dxp/EDy?N%@k53Eop;OCD߯.DqXTQϠu:93: !p	S3_1B3dUA`hy%%Ovt0:QON@pHR/ N9
d.0
`0X6Fp0X-64F<0570`5#O˭0]c6e`	S8@1
!b-1|I%P/;u1
p< u1a1[Qŉ*C{p4Iz5z5
3z*+	yuv {| A+ 90& n`AT0 +	al:zpd01o0upo6o,/-.rpF}}?0
P?/.-rdct%,f Wu tq70YS 8S;"Wΰ4쑔p1ƫBŐ}BT_0=_<I?`$<p:T0Oܑ78e`pYלBxfT)Ax`%daz0  87`>P$42q"W¥A3U	``uqq
r	1Q`{0
}
9ȷrdP9$$P6"{ 2F/}&e'AChS4Iqo}aw X@apR`pLxpGN3p?u]1ԒU^#5_`@TU`#v@|T kx{}Lxzp Rxy PxxPQxwMxv0Cxuxlxtxaxs`xrxqxxpx`x|Lx{`RxzPxy@QxxRxw Cxvxloxup&xtPxsxrxxqxxp"pxjv00,pTxfL@" -4j0-TxfQf/_p0NP -^ ##----Ji C?",u/212Bp-21Կ^ L.e'q,Đ/$7,T{AO-.`۷pGRQN.E.OJP7֔0p0Y))y70h
P5
PIs|?`d\7]}OPn,rtIar4N:0`a32Е
p1
P

Q "u- 09r"l  _},n1vg9, : A3.02z.pM=1s0D@dT:0u`z^P;DS,c,u.B.` +2 |p0Ⱦ`u.Ta2)lC
.%TOлQN]03p	 `` 9a :b ]$ :t>)NӔ@6S ? x0!  x6E0Qq7prrqxv(WUP	Xu

		0
  `}
7P"q #
G1opWTrAL`>M~)60.?T`@}w}S?AP33TBDWD  Axj6"@tI C9xVxFdⰣҢX`T`H>T
PɞM>@D!3"x)W"U\]@0Qqڢ97F 03tƘv`
pUr )J'' 'BP_P` qw0P `	qPa"NO.eB"TOcEN Є1n`=\=NA=NaYpo0:BP e0!JI$:1PJ1,"F;KF	D0c
^"CO`@"OHIOv30aA!Idp @0t=t A2bIBJ``JIxnvHI<i"xFExGFxEGxFt@0( FT.`xFF0xG@Ft"("F?N 0 G_=}"xB!C!A!B/)B*Q( #NA
OA
MA
N/I
N+)D
JaKaIRaJ/iJK
g
b^0JKoLM`N T&` @ws0uK`K@ 
MLt ~HKJa}i}p}~}wEAMI!!K..C~ Ô@"TxDҭTp𼯿TAp @@$0*F;B}@qRTHC}Np(UAtAnAbALA@A*AAA @@@@@@@@  AC Q[HH" p&bbr! t"xbo o o"C pD )p4	KNp#q! * 	A[ ]9qV`N YVo$`RBJb d$ByUo@U1OůU0	xnZÀӒ }a?U`#`5`2$pCxD4SS [CxaUUTߓxms& LYq 
xi0v GÔ@π<PT~xiCӔ@/`Bxr
T"  Ptixo aa?v+xmv25 st 4}nt  to}D
 "YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTkATAAAD,!@b*>}ۉEb $QxF%!0U`Ud`0)&uUADDDDDDEE%E8EDEWEbEqEEEAE9D otNA8pCb,0D
m@T g@ܗ@KL7 &T FP7Txa@ZEQ
hˀa>WP A7O0D=Dd
`#p`(`0<`PdP`d`U]ȐيUw09NN/ .0ttd	QRxtxxXx\x]txat"xbt}xJxFxBxtx(tbxx%t &x)xxxxxxtxtxtxxtx x#x> x=tp x@t	0xTВ
W}࠱%x"Ttx!TTTaD	x?D@xTpT@=TT	Tx= Q
@TxDp?=DmDTxjv0}CtU QdMdR eP`eLO;]"x0xK"xg/M"B S?/?@>"$ւtO>$-"T_Ô
P~0~7%UUdTT7%TT{ z yT H H+H3H4H6H7H8H9H:H;H<  I'TY1	 Q
 I`A @tR1~5H_)T& 8 `;cuTuTK0T"$`($`*`-w/rp4
nTB [CMb UQ P"RLT$QIa|JIb P X$1`r$c}JuTxt x   uT  ! Z0t @ 
A^::32 *}0 C #N'/A0`,`0$`3`G`[$ap]Tp^9"T 8 dpF{^A0$s `!DTJwwq/0 T p U "&$pR_PMQd` RQxgQÔ PQHH|sq@P
qJPxgv@@0KKKKKLL7L;LVLqLyLLLLLLMMMMMMMM/MUMoMMMMMM  M0
?v"xFMNO`u{R RRsxИ}ew  x^  "%"0RQg?
R;. Hp"}} HG}0Q"uS@	0?SSST
TS0SCS 0P 0@4xatgvaQ =`0jxTxjoD0Sx0Uxbx"x@$xx"x`}K}UIF	
Q@ Z0""3HFxT| } ~ K4|Q`*O԰]RR &OԐM((sN3N9OBOQO\OgOmOxNXN`NpN NOOOOOO.?!PÔ`P/QI
"T?ޣ } 00x`r"QfSQJ0pV	 50T0;DuQ0]p 0@I0)	\S":D$p
;r!/0Qp,"xdP P0A3R"~7}e 0?I[R3AP>l2J1c>cGq0M}E@J`d)Ca
 .:0fTN@g QyT0PTB֑PPJ@0#@60xD Tax h!1?xxhvpaԩ$PT AA=B@011u32}'  $31T3322@"P0  "}([W ]"   p}"/v*Pʏ0/Ô/pC0S0߯0P200PЯ"
xp0 "x`2345&}@"(t?3t ?2x`325R4U5B axQxQDQx@Q  09Ī6xT_nT CTR2CRVRRS!5 T7T_TTT6x
/0!x
tP/P
0/ x
  x
Q{Qyx
! $60#t #T %Qxs	}TBxr0xrP2QJ0 p%@$T$ÞPxr`O1 	_*_,-u . <Tү$`&p<Q^(}_ p% 9C x.-,6	%xxsӔ@v $(xrvyrxsP!  P&0 	r6
pxov 6xa`r
pqfP 0	,xx
xR!x	06T)_7|P$3p 06d2T TTTUU
UhU	U
  V/{pwfD4 D@ @B@"xDbU$P``3T[OWD#X0 +D "z:zTphO`/AE@E *@@jCEpUi O`~@  w 33TOBOT? @ 2^00"p<`p}Tp`- ,*,, F5RS,  ~S,`xevS,,"+,/0,WP@W.x	W.}wNW.u0 u1SSS0S3u2 u42U03U1Np1%10304440}P-5xp7x	410a^_55,Ӕ@xA=-Ps Y60c
+p00Ӕ@@60,	`	@WWWX
X*XwXXXXXXXY
Y,$YF%YR&Y[+Yi,Yv-  Y{,6S	Y{Qxu/@xB![-.![P
.-`Y<	
x3 {t?e.?pt e-``l	clQrl"	`Ax@}v}t&܀
-   bt_,Qev  q} pQ t u vAO}	}5!`N)q倩 Q!q^="P/b0 ,+"7`w[7YYYYYZZZ 	Z'Z.Z5Z<ZFZPZ]ZdZZ[3['  ["^PX['Xs U S1
tt)ŵx#	
pp&Ŧ ,D lTQ@ST0BQ|
ba:Zl00QQŔ IZP  cZP[`!!I0~GJ{t(ಚDc4rKrgQ
xﰒj)1O`D,1P
`QJAS[ "gD `C -Pc80.u,,^,SÔ@ ."W,ҰP#t .`
T/Ӕ@""@
u/$ -$U/"x@|Ӑ T"50/}5"24 g\B`2y\\\\'\/\@\I\J\K\N\Z\[  \  `	xk0/_" ` 0/ *6uq(QSa  " 0f33%$'я`e2pG2(640!+E4d	`e
4Xe"anv""44$`$`2$`B$`J`[$Wpk\ P S0/V_QR
ZD	qv3]4A@=G4pH@T
>q
0D"×"""  ^l^t^z^^^^^^^  _u2#_u22:b ! 0!ZrQcPyA=r!
C]cb }6Pr2UUDE. u8QZ/0!ׄHQ R 0 32"0"x%0qT~t@"7@P@n@	T3" Ox~ d' "0~Ő}t𐿿0	ˁj_bA;x0x!TT`D_pT!D`q!T1 71[xD@&?A\"  :	;
/123B=>C	D
WX`~x`!ÔP ^`_cV"
%{P翖F`70x+ +bxq}qa+s+H `C0/+xT 6} 2@RZ DT_`X c}@TT`}40	61 aِS 
0cx	+$```9@=a_xv 0z q DxT"ҎxStTTH`S+xS+<x, 6,@C`$p#+pxSx+	x~060/E

0` " .-Ô@-ӔPq @
QPQ/-s$A$cp`NC.I}?.A+ }9VQ`@\DkT ]P-Bp}} cC..sc1@ $~SSN`R$dp[..". dpD0߀Ò/ۣ.Aܡq xk..TpQ"-.{{ oi" #N"x7" 	5}i`$3mp`(5_}`` Ϗ/0i!UdNdxdddƇdψd؉d؊ddeMeSeSeueueeefNfNffffgcgcgggggɩgɪggh
h
hOhOhhhhhhhѽhѾhhhhiii<i<i<i<icic  i~=0~p~ @i0p C3`T330C3@4u:$ŌV 4`kR3Pu3Q}3  #/}R_c^$&M.03;_
Քf	R		//pX K૵(L(O 7 ~ q`| }` @^_NcC3cf~R &?PPo3Ôd%a*=|(z {@
` @\]L`+#91"#
''21&(**/,R,////2161/s4# 1/1`p6Q8"!!z{dz bJV:v<O>)`??ݏBRB/2D6D.`/$/4uvF/ {5 39M^`P!PIVI/Nπu3/3"$y`@!S]PPch! O "@A~9`{jPLj$`j`T}`%A`"0"xs@}	TPP
U
VxpBBxsPBQ0$70#"A "%@ABOr+pUUpVpWpBxs		 ɒ":;<x>T=|Q
38T>?~`dPkP?> Pw0=pCb ̰8i ?} P' 8@
QZ| $ >:;<0
 krd Ep6ь"}`~; }oQ k# b!@1c ɐ}  :TTngt
>DP	h0  ]_RR+p?ro++A. 
~;uk2@$@] @uTl@&p0tp^% 
41nl|l"14Pmt1xe606
 0qۃ_Ϣ60'z zUr}pp
T?T`4"4"cu27<0b}0h~^fvv0˒TOD001p32k2q]* u1İADl0 	3 cP8PPR*PD2^fB32ŕp087Pc`&RlP}`"!QpP0 T_΀O"070% o03;3@,pe0`01?2_ ?V"eqoo0oP3p1 n10}  c~8g`4 	1Dcܢp@T3`02`;:+"45675E4`546#P
(45u77$ǵTo`MӐ4}`TM=`` `'p->T
r D DԢ i0(a~$ $CBD[0qd BPkZa@	*u1au0)'2Su0p
a1}@O}][?2u2u0 a`20Z `@'V6/{[pCl85002V@T1TT%%O 7=<Bp;3`SB
9
~p	0d`0@_1YZT?`<@!?$p*3t1TO Q'	 A!aE@CA/	:2`cOA8WKk$U'NtPlƷ $	8Uhہ
'$5P}5
E8Uhu)txŲ7Ut}5}{zyqT?hH5tf1t04.<t o0^u/'P~ pfq/p5%tYBte~@A_QYaqoЕpTnN`;L=2t@Y1	ÔPtીѶ1Wo`E~`pw453*`~z/G~zk4P73a}Аu((sv+vvvvw6wWxx2xyz{]{|%||||}}>}_	{ z y4j	`5P4F w
:DfS$TlS3D*{pu4`u5g 	]4T`pd``~`Q:?
p0
PF4s	ǖ		ym
"6W7d6İL}67"P!nR`q@d%ne5p4l`&+@ӈ0C/QqKFB8u u8:Uri| `z {0;` @\]Lyk<899?9886 u[k8`%9s
@8($d<9P(cYz4ÊDQ-0/*}`u} p@~
jV2n*.@;@;P2EpdLp{qtP+#1?1s_b[u?mpl`*
`r+@~+uzdNpt/,V+5/B	B7LѭNp7>	ThGȵoVjp?pNSZwdi[/Y'P#&Z/i L(0?_?VRac<Je=h)>ѕj?TŝMm iƵ1}sxVD,T-09L80࣌,`78z۩3 7u֖|E3uZ"27%~}3a+PC PQ| 3$`A`ymP~c $~ 2|`u3#ux77 dER tu`
Ô|		qjPt7pz7qTT Np:W );4u3tp7uq$x37 1a`04t0s4f 1 Żn~~~314ђ"H?6P_
R1p!2<?8}0ـ 2"u0_
^03}bY%҂/^}N|a^ :> 2pPau2f	op` 0Ʉq
``ӕ19100b6xeT`&$3o1Ptw2"u}`q 
 """4}t t ?HP
3U02	~:TD"LION x9psP
 D!T":p
~"|a!~ dx ÀӲ  0d"0Ӏ 7p8`0@
D 
~g,T e8"a7Vpa~psP,~"`@s@"x0 5"5q"psx 
qUÒC>A;>~ 0!" on`dx"56uX`,5bP| б`  Pn{p	64gk6$2@"89I;u<98~@98lpe;"9E8 `vj@@~+k P" W
pm@ P`I@x33 d ::Ӕ@o:@>x#q,	: P,Y=x@-:zQ 'W<p 
; B
հ0^=<>?u@`"H  /(p??p>ÿ?
>y+@5ސ5@@	x&T@/"%T~ O7& @{"`"E"x!To`	TT@5S7?3o`@2D"C
xCp'xa6@>4ra/T(--,r e,p,,~?e,`,,|21G3>d$-t"u;2rA&8<9@Ju;;;`ӔP9:9@ɐl56x>~FM pb?b-55	d` 
Ga~G6C!"] DJptO*q+,U
,, +,0+@_b&@T` fOGG$&_xt
 T0xT1QT4TDx!CD@gp
0g1dpa23%3{3+23 2@
4pk0V4clN(%%q
O Z0a00*OMTeT+		TY!~>` #Aq""	߀F	 >	@[2xp=d X LҀƀԀio3ꀚڀ3䓣łŃ 
`	"3/ߟ$ ̈$ P ##EN``#sB"P""):"P%g0 "b``"  )"/33@p " 3xPտ"Ø"(p p8

r
		^
tQ
X
	


 *2y 	1	"/t 
""BBE"""ЂP  tsی6 s$ŃŃ1" ";%5@bpp
s@h`/1p1 $1@~1v1@In1 b1V1J1e 111,1 p0p00p000#*s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)    K   P DSDTDSDTI}  HP  DAU00    MSFT[L\._PR_C000   1
 L_CST p\/_SB2P345`p
1I{6
o `_7
  p@8 U 9AsurBC WG@ QUCYCYCYCP^Cp
DDD!DA7CAD8
 D y 

B9G  D
AAIG
&
qB;9
d\`E2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Fph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD010phg	g߇i
  #11g 2 phpi p
 f"`'fsg`f b 2f cufbc``34E
Microsoft Windows ?ME: Millennium Editions NT C5F
`,p\_OS_`pga.ag)`B4
bra/13oua
 6
 s %[I` 
u	273213415p0135_INI 5H7
fpig
f 9i` g9hrgfata
apa}`r
ahha `a u
 bbۇi@ ibub`\a@[K
  8_HIDAJ	_CRSR 9)
&	F1
  GPG 02
 $C %DtR6E p'FCC020pyF21pB1t#209G2Y2% 23 4 5 r 7"3([8   
,[8129A3[
 BC	5
[1 DAEFV30Q 1 2W33 34H35
7@g[G36!7"38'5 9AX3BQ CV`
3D EAFPZk40Q 1 42A06 4` 4@`45Q 6 7 8A9A0 @BqCzDE  @F M@,51
E!P`pua42a}aiapa ib{{ab[C@102E'
_C _ADR
 [&   ~n_STAi `	3p
45`56
T
7C[)56tq}r 5 D070 857Uo57Er2@t58& @? < }A@#59 [#PAKu5BeD`p` p`bt57e Ze` ap dpy40cCdc
{at
 b`zdx5C!{bbtd
q6puP@2dcrdZ58` dz?a
aa{
N `afuff aOdu7`['A
2Ja
EL

  BGqv
EDw `xH d2?Oy '&}} 3[A B60pibpkdrd
eϢdA
d hb @brb

bhbU1  2m3Cj`a61SD 2K661crc63BbN04!warj5Ea%b ]b][@]
]
buq]atob
bP c^ya%
`bac c`/$65S SK]Z5E
f61 }63c)626P=aacq`\66@1E~_Sy30p 4D
evL67U< W

X6X @4[ p9 [A%@ 
"@6B
K6B>a@{^.Qh2BACDDF@[gB:H 
E
`
[6EFе70jQ 1 2^73aAW7AW76T77AG7Pq 9} pg7A @!^7C!^7E F q80F#81 H82 l83O

d13842j85 
<[=   @`687 8qf892@ f8B[ 8CQDp8E`
[0 F	 MA90P
aT9`	  92T93
qv94$
94596R 
!
pW9X@397 g0~98gqx9A
[! BA9CQ 9E FG`A0[#\_GL_Rbp
`{ʔP[!
dv`J`Q9D69E{h jp
p
HrА"ǐaP9FbqV[Jp	rya
c}cbaa0A1 (8` 3A2x0 A3Bhiq`y`j0OA4
yh1Ы7E: \p3 D+Ba(80V1(@pwA5!ikp@"m7APFbA
i9DF17BO&$r8C}j80[+GG6C@:*BA7
@
[+  A8VA9Q AA$AC06D C>0AE
A`9`C
	^   z{` `za 0 
bw
t
	rab.C
 101
a )*ۤT{@rv"OL&F
pI6'B`B0
y
rw iPH2AB`Da{P ` ?
p{z1O wip{a` rb~qAFb yC11	_9`pBw
h nc }r    AA3
ccFB2
7l
 B3 SB4 pBt e {ky
 B3ee} `e Aj
4a{g`ц xq5@p #b}e
eˡ/p !	e e$}`@dAyA4{k
 	``;}qA
 ЈAA y!-Ap?d1p68d ^pA8"9 9e@{B6q0fB`7 D dyce@
QTѢB8hif"f
j
7@
Eb~dB	!ba'c@z!Doby
PMTU6CTHPCI^Bb(p`Ab	s@bB/cnpyacaABw'C`C~De  dBߤb[FB9DŅGGGGD DB6 7#BB
Ĭ@BBBQBD-_PSW%12ڡB`k (!`AD[(0@E֡ F C0c	C1uVm	V o	o	o	o	o	o	i	Rc	po	o	o	 o	o	o	 t.ҙo	o	o	o	o	o	$N!T%[M 5c#x`0833bý
o[@PCBO /@CC
P
[ہ5   CD K ECFвD`OлD1  0D2pD3z3D @~  PD5OT 9 62oQ
 U0D=:
c`7
 d 8 0D9DAA!D$*/D(D//*/D 'D//Pf!e!(. G!G!@($3( N #F(FX//M E0@ #F   //A eA !A N A GA "A  "c0EV/6BE2g0E2//*.3`03'3//@a0%1a0%1a0n0 a0G1a0G1a0@1BEtJ  JHE5	E6	
#  y  Eh`и``
`p`aspa!E60'E9	@	V`Q	``EA` :a'#B	 p$qCq С	A`v[ODPHIDA_UID
`{|E9^^06F!_DISEAx)_SRSEBh_CRS5Wa70r)H$+b1 r)4f;c!2r)`C EDM 	h13r)@ U[(iA 4r)$`k0jQ(5 r)3IFp{8k6@r)71>8B[U!a42[F21F3
r 4
 <5 [#"GP9uZ[@KF26Iv1(W 8E,C054|zF8
,Ѿ 0F9 A
LAB _S3D
p 4p PkFCؠ}(FD
 h246 `U 5XIEc7CZKFF
048`
{i}`h`?{`h@48{i  {@ 5$ q\._SB_C100tB~ o._DO{Sq	4
` a![^ 1bb ha[Â7ɠkDC^YFC
 G E SSaF
h3À˚rRcp*r&R%$C 

 
h06E0FD	8hfp
` {\/0{02<98
PҐt1`0D W Q   P Chi82`
hA@ \\n8\/	F1 YF5 @E6|o6HI"7
 i 74hj	 5hijkCq8c.5[0h92s 1 0p
Л93r8F2! F)9
^/p´0kl0^IRdN	_GPE	Ó
pOI
Gb bGf f y F10AF10mBF10 #0DE

p1F@111`
 2/_REG(pip015
 a	ia113[J  @@@0140ް15p #  6!7)8A9ArB 11DoE F20+21Q 2 3s 4b2[52678 p9ABQCDE\A130Q 1R33334^5 6s 7@,383-AB CA3EF064q4Vq42 3A4045Q 
474 Q4A_INI U4B qBq14DG[  I E @F:C150	wh
@axa
d?b`t
@`@QP
a
 @}a
a
y`\}`a!@81AZ Aazw`
d`xr`
  
@bauaaF52
q 3s 4
Q &6+57 9
1-5B2C
Unknown 
NiMH 
LiIon N dPpupuY>0
  a@tgq0Aw/1(`0AQM5G5
a
D+0F7DAyPS56@`	ذ9qǅ}ha{{a
/54y}Q952!
 
0[QQt!3!3D15]PU7p A7"E	`bBp
fP?{`{@I	F
[)h`pXD
csc
  dzir`a[)absdb1/2J*(ccCC160	hg3
}qEg
BlU25B/{`g  1`2hC N 1FQ23v0a3h - 126 w"9axra
c 
dcbpb:b,Ar	38`fa 9a$(`a-q-2g2t$@IX64
I+Ep
 vW 	i'p
q:/39"29cBhcD c600 f{P`p{``EFA;  9H2c cp e_eexcpe'cpci3%46s 5qp
g5IZD520BAjC-P+6F@+1yN)V1D,  
t>/
>b2`(1v1pz!o
 5 Wo%)!3((*ABCBH)P1se0(a5h.EC0	A547ata
Ƒd
bczcRhv 

D

6Aaah34
@ ra8P paupaHT9bc6hb6E40>U772@EERBEF>00 [
P~67@QA
HP   aл3A
Sp
SIMPLO`ySMp
MOTOROLA a`wU8!~68
p
 
iq0(_Q039z4B"pB4u0Fbp#p
apvbba:lQTZ69Q] A['coTZ3_J
6mu
JyD
a6Bo
PRe01A 
 M1_2 N8s#P 
]C
_D#9`nO
11691_C316

,
{` (i28Ci$Q [F@}E
6F
N C1771 F7`71072 pq |P!6 FU78A9As7Bs 7D77Fa80
[  A8182u8Q84ak85887b 88B85aUVa90A
^85M 888Ba` 78`
J9>k 089Oh8B8C rA Q!cذlBbaAcϡ3gDbOaA
MCBFc18 ya
 Rd
b
 `bdpdSpc
 c
@c
98CBШ8A88`kaɕa
v2C albab`b
vbDb777Bp`E7A9qp!D#!d9zj
!%ECW89=!E#'6qbp
b	ay  bbӫ8FQ
824Ҫ5`90
0726" 46"5
q1
{C039
`{  ia` `P8Ahp!
`!zqK92	1$AB0$b cU09abcA'K 93 p^^04cIX9w5LA
96

Gy 198 A	9/  99h@d796Pn@[Op9AF_C  _DDN
COM1a9B9C6
30U"    8oy `NS p9CD_STA 3{\/ f002e3C_098
`-90
`1
-`p	IS_RMV
+ dk038ps9Q
F_SRSXbh
aD7DBBh)9B@
_C
>z9

a `e bcq$OxA[QT9E   
CF
_ON_A"0&_OFF q!PR0E[Ll9F#jMz$"C
_!G 0" *
7"~3.&[%p= ""B K,  CA0! !&}A1r=^<!`t4APv9Da;!Ah!
zI A *"0"	pA5
r
;@?#pA0s 5$S1$$$30%2\h[46m&i&!P'`& $A6[C: 7mA8p?  WA9
." ZE!fSR@ArAAAULH
1 Gxx&xx"q)x)xx`OF Po r ^r_ _u\}VcV@NAAT0 s%SSPHqAESASN?3?303?LTaX3xTn*AGm3 *o3tUb uAB44PAC4?X!4X550Z5`z|Х{xp
,, ` ACPr885_AD=_75_?_a =_PEX:D)AE p\/@u|a(`{vz  1tP}Ar`.d C1BayB` 2 ;0[3B24BDГp hq0j QBRB2AB4!P*5&{`h`h [ۂEB6\#_UIu# 1B75A_PS0pB3@3 
  K"@RmC β1B8y "
4렭 apB81Ǥ  paJC pF	 z`
a
B8BcfbB9 BA7BBQ `v2AB9Gp!
$1BD`a 0#BF  C!C$C2 
G``?Gpp +eC0k
q 1`EgCv%EiBE!C2[%P3#¢ "  y#q4`w@ @ "O[Au1U
 
 P
     *"5žtBa_ a !-,A
0 p Gr r " 7v` `0_Gd d"[IC8
" 0b[PMCAQEC9у  C9CAP9O.    @W[+ B@
   
 
@fOC067C5ADR   'CD
D
[)CDE еINI	pfCsAgD00PRW
	
[NDL@D21W=7H/7j[CB@D2D@[\GPE_L1A`aaD
C0D:	PPI
@A0
`*?
	Q p*_EJD Bi.P CQ BEQ -FD5Q 6@SD@$>  "qaS
:CD3
@6t
p*S3@p 4AuOְC2N<

[A

E (A_Dd#E#	pB#
		C+						F7C0B`
+ 2A#C E_GTM p
* `d`3  E4 .E5p E'r BX{pPQr4
mEЈE4{F0MhhhFi  `p
w6qa:` A` bwb
bw`
c ib ac  rb rc u`A
2!abq6%
2cE7bc0oE2:6q !{ xz0I([E2 F &uE	088P`o0iq7	
# Y1 8OD9ODAOEmDOEEOEFL`H\_PICph\/ND6M T MqK6E

P'   p
 0
CJ #0$ 
 G?C

 
	
$Q a				 		!	A	 b052# "cD
%6p,!1|!G!EH  J@ !ޱG .	@!A0E T63@	_F
~R  RVd
d
Primary 
A   
LIon 
Hewlett-Packard EyTraveloka	2O@ 1-5[L60	00Q60h`/``%
 
e
" 
 
qZ6C3hg 4A+10PEBaHaudB4G%`2t6
 c_^{5E 
_BI YXap ST 4rCL\][˂G676Ƞ)CocbrJ`6ӱ
ACPI3	G	R/005`D55 $Ja# l&]PR0  81`쬓`[Sw֑:@
LImD{_80["`AHP_Tab4PC_Buttons6
	/15?@SX"pXNќ7jqF0  F1 
 23֑0k0k`qh`piaFa
 ?ЏF1я
 a{`
 ks }a
a]apk
 kЋ3 2@4/ 0F,F0  *F4zo

 ` `2W`@hp}
yj  >qb1h)gh`@	4` ibppbasabcpcau`a`5BF6! Pa a7J/8`9 FA BFCC	39  p
`

S P  r
` a0D ECee[wre
W 
FQF@2BpFAIL qM9?SECUpdAA1A1Rp^C200bwr1}2R3]j4-3`;FCP
cp 5cpbB
#A3B
{  QF6t
-A	
6B718U9%A	uB4B  u%a%SIMWa620C&O7 b;2J^T7`̆C0q  ``#PGASSA'1=7$aOAC`y`~4Cap	!o a14E>H ES?;	2CC+ap^bb`a ՃB b ub\#p`920t _WDG?
<4_c,E=DAAyB{M4C~ !f )ABxWMAA~xF8ij=10tAEp{ 6
TvHQ%{h
`3{Ez44S[ `5`o047}54
17  0I 8U Aq2	
0l97T"& 1#q,'pd'a'Mԡ<Ow68a{a
}z` NC`)g a"	I40*	aAnKO1B gCph4A-
r.0ѓ2AI!h16h	 _WEDs**WQABNߩFOM`'  `8:  DS }TK B"!,8.@YP!O : SAND L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O긱;~oh@6?QV&X)xx52
9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =D&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'aށ^2]8O.m (.ܣ?! vB G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`Q"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=֐X|gMsb31/~[A70x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC zÑ--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐĿ
LذWyWr24	;wpQvY#{|exuH#D#o0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'{,03[F

[  10 \C1B7
 +518_INI  {[1 JP00[@11l[#\_GL_yh`04Bpipj҂k F\_C0F1hFpl['['}`!12
!h  3Q45 b6 C2215gph5U4445` p{zhX Q7h7	k3 6 2 -A6o	T
6B57	P[ED22E672oF30 12 3@w34 ]5 rv9`"36035
[ 7@(23829 h
39AA B `UyA
	`rh``vF3C!37c`dpĢJac
p`{rd b}y    baya
a0apaňc1eraye
	 evepe30c ucdcM
DrCcpc  bpbgC	bdp apbe)ecpe ffg
fape`pfafgvdueA`b30` gT`$b pg18agg7ag^dMpE,05A , p0`c`ʀbq1 2`_ u`py 1 jC B  D "h 30h H
bhc `r Dcada
e,33-adft`f	ru>'adRuc2ftd gpr:`4bA m7@.F F34FQ&-9%DE`Q&3aqD34
LBC060pibhbC240p0<40rb
jD1
j?412c22"bwF3 w6
arS9abpb.0+bϢab`babuaaP `bua/_CRuS!4Q19`vs1-43`T}`ZSTA t
`}``569XD!

	        y p344 ([Kd245mHH
 e46F
RGGP   @    s3	z0	  1	[Ci48}Q kk194F
rG G$ $ GN N 
P P Gc c Ge e g gt t   >  #p
 A-\/[	BCa


W!3p
`q ^^.C16E3\_S0?_
 !  3    4  5   M\_PTSph%_37Hh
 Lhk
}	0pz15eˠ`Zb1E8 BA {WAK } @3092?0109A&10C@pbR 115a	``6qTZw4A~ TZ1_
 2 15
a(< 005bE

OrFacbcc:c6B
[APRA0;1 
 b556A6 1
Y `BA-CN#C2N Ll4,2"0 /E\FBG,
@
|
0Q 
ob [PJqOC4PQPE0HeF
050
q  Q0\M455=6 72W a8С@B9pW16Aw
59
1({!h s?# >4Eil25A
piayh
p
y"?1F$
`Hpa_gn
DB
hl5 D`pi``
p
A#i p`OrB5Cp`phahщ57ikr@
Q! A#~Di ` aP6VQE
P iQ30;opKALA(!p
   t1t
axa

`b@LRA0

bts
 2
<Q


	/s
!
P'OL00E_	FU@&Yd^d+Q[p{43 -{b
 t bbwb

araMpLabb1ReT17fМ)ar&5h 1Q'6' b#y
h`:I	{;b  @pui*h aBw`%  1;54<`/6s AAQ@IF`hm3_
b D*M5F
40-h `t`)`x`f3f={tff 1tqB.cbbs.b&8!9bbFiv

ep
d
M& d&5d26eiI~( =,D	B*\aFa[mBN60¸X
9_?ON_ XW# CqLRcR_OFFSB:D1M
OR]OjCH
u2
OcOp
3
OiOcw
[64 0 460["@DH1C6ǆ273[H^q_AL4 91PAL2	AL3C
7_GAC0%""1&DB2Fb3fPSV@SLѾDGu68ÁnBG3fB([an4CHw4DpF4Ep(4Fp
$Y50SQP4F_TSP
dp TCRTs0TMPx8p,[GA89PS6A

,"
3XМ/$@\_GP26BO
_L00	 q2`@TI{` P{`{
a Upb` 0ucB3a aazBGK 1 I{v*67p9 @ICBC0D^c}CCE/["
d,B`fa@3z4F 9 HOH0*_6o3 S/oiB67IC_#DE_H_L17 182?`}P7@24:98
Ds11D1@ RpEA5 Fk:Y{4
P`C;P耢 1F00Y)EF5 =8?MfG06E 0D `EC{ ?L98`Ko9
DunJC ~ `A?


%&00wc1
p D r #!""X8?0ˠ!F^6a}`0SO`)Z72EW@	+Fe>9`Ld'à.p"""<`
`
v#Le
*	 q h`?n097bc@5fPQΠo+{aP&mc{bQ7Ke3
AcEdD}Co	7OfH/C 
œ&6a~ EMG?P4SSDT{q@rHP  HPQPpc@s  MSFT L4F@	1 3      #__T	_w 
_	OC270wj
ara
[aV34a1P]271ijq 2  Ah02Ed22F 273_274!3$'1 J7303
 yjFA2eB3Ej95
D0`bb`h6Fa bub P)21Ru2+16Ph 7RE2Ar5yB76,_
b+1 y U  V!7'*[A8Ж_PDC{hp178PCT 
1p77q 6	_PPC @1S7@K787Y 7NLPR7y1_EJ0nD2@AQq   ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ  _     	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n           VIDEU[0  @ 
00IBM VGA Compatible BIOS. [ k y PCIR%    a Q g !E u  ]3dr  0Rdq w 0 @41w @ @q  0$Q$Sq 	 `"N @sA88%  1X (V! Pd 0X  d @A &06  A  0`e$ `A (00&0* Q *@0p4#= Q 0@@H?@0b2@@	O-YMh[r<Pоt!%072m4	8:<EA7CmE
IKMEP 7R mT X Z \ E`. aP b  cH dP e  fb gP h  i|o jP k  l mP n  o pP q     1(         ,@   PFor Evalu5on Use Only.
 ( 	 c-'(+  0   { 6 hP _OPU
(@	@ D  2PF0	@ T(    N
 `!MQ](
c    CO
 	

 89:;<=>? *  j**?0 ?? (-2 $8? *?B*@ ? '*?*P  *H%( (,%*26', 49$,0	
!&.3+0$8=GA  $(-2/?'/7?-16:?  
0a  g0 	  h (:    l       (,@x(c  vH!{v{L4&,Bo(7*( 02HH00 LH 8H
8Xt  XgXO
X@TDgT	Tf(XHHPk 0P> ( # E9 8J
P$$ < 8XAX@	d5RAp@8$VBT ALVISO  d 0 
b3 _DATA_BLOCK x  
`3412Intel(r)915GM/910ML` 5MS а Accelerated S
Build Number: q Deva	09/27/2004  Q01:16
DECOMPILATION OR DISASSEMBLY PROH?IBITEDCopyright (C) 0-`3 2`rp. All RAs ReservsedPa@  g  $	

 ! 	TV׾D "LFPiz(      | 02468:<@BDFHJLPRTVXZ\ 9{   (  8  [0 _ @ Ā ( e/ `ࣀ _   ӕ@DԄHLB  p_ ! !Ԓ        0܂ 17 3		 ޽ @>   H `  |  `] =  # 1" $ (
 5 V}          A !  R`SI-1362-!Up _2  @i7 <cU
 x 
	 Z (?-  	Q    e	>N Ia(  QVSC dS?4O  
`	 w7 c<  \* 
ZcTZcu$M
 23 ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*!P @ X  ' 0hPR	 `"c6 X  1X (a$n!7C	d @A &066\ <0* Q 0@0p
wxx Q@ϯ(/x?Q&@X!k @H?@0b2@@
|/d  P 
00 d  @
%,@`@	Ƃ
)(<p#%%%
 PB. $< 00C"2/<@PpQX 82

,{ +a ?L  Xo o o o o ,4 Z  UfPfVfWfVtRu.t
fF䠆   w FF\  耹*FXF <uY=?}Zf@w
FA'  NnVQRffZYf;F  rufVWRfFffffFff1ff^~pZffq_f^f !;F}Nn߈^f~of~`.sf~ t$:V^:nQ:ND~tPfFtF;u )  
f~v ø t2:~sPv0v^*fދfV2fX]P!Rf3ffZfXþ   
@|   @M` +sw.2 t 
؃p.	 
 
f.aИVW6 tM r/u*B
 tVff" v f..L^߲ .pff^3_^28ev t&B1t1U
PSRV<v
W_2G$fWb  < t<t<t<u&Dufn  
<u ^Z[Xf.9uf.\f.|.\ 
		;ufRe.u5 P.f
fZ
fVPf!0% `= `Xf^2dfP r  mf D 耈f ;r;r.T" 6f"2P#ESfQ@tfY-ffXz@G=-fS fYf.; r$ )[fVlu跦8u p+^`@H b,VW7u%f-2f1/O%1f^b,t$5&-rp%ufÂ 1fQf"s UP/ffXu
RJ8Zsfn5b1J7uf-qB7c1q9J1, >1AJQ9[Q,tt22<6	<"tR7Zr.
 @) j7Zs b	4.#_tu
 `, *az@f ` }uVu0f'}0 0"P.0nroooopept<wwyzi{
||}{!' < .  @[ &a[(8)8U!a*d!e!f%g<#h?!$P!fWU.64eހs u.Hw.p p=Ou
uοFa=_ i %)6I=OuFt=Ot=_t
=OtPfIXOuF
_u pt n)]XZ-.<t.:u.T!_F`.a   .aPw2143  p;%(VFE ^(p 
Oq  @=,. f@-"-u
/-F t߰ f#00.fB,fP*# I"7 n.tJf4%90h,fF$ 6+6u 2c0Sf[ u	uN I$Vp !"%"P""""	#
# Ǿ!%A!-(u, xR-̿rkPPt(0.u\
?
^qP9 2ۄt_q  P'1\wSfr/w*]'u{+`	,s`!+
"	Trq&s
!bt&S
[t t fM,ru%B_		l?s
B0(f"Q(*fR*P$8X$@
؉b1	f`2e(qQ	ؾf#.8u@rin#uc]3ZR,pU
 )  [_+a   ufj) + ff_UQA3+M*޴Y+dZ+4+!cuw'+pzkr{`q
W+faPSQmQ	2;YtlQ
 srYTZAQDtp^Ű@t@uY*Y_"utH/r.D$tt	Æf^ZY[~Sv w/u#
 u3 /-"ba@   0@1ʊ7 
[`}.tN0˶V uf`.VPQX	.r0 k%.8tYX^r
gf&⢊f_C	f`	s	qt!рtSR0Z[633xu0KbP<='$ {?p)|$'[ ?^X!&+&U$t Whw.QYS.L2.pe
QPfY
8Xt+$YI~Ц+.W tG#t
2tPS#[;¿Xu)&t0uq

uPSϊߋYSQY[r[o/(cQRvPu8ك zALtS=[rt  p#M2,,`U 0#;˯ qF
1Gs 0
p ѰRB	&Ыx$fS :8!ux'%PQ`UL%<vYX%r2%P PO`w% #`vX%	#XTw#@#G.&6
?";a`mzQ4
81w?0YGpoò_&@?XrPu(s#}0 ѩz Wf_ V.4.tf^0^0ѱ m0/D! fs'$t#f%@ }8ue? u̲t,rE,s@t9@ ̀C~ &Zf*ɿ3fK
f^	 f0ڸQ4,ry0S̃>|c ?e%YE# t3!iakʺT%V1`QXw

SX$w
؊"3Ҩ 8
?.[ *o+++;,_,p,,,	,*R{h"u\uS"u@$#P"BtPPP!(#fSf[A!#Xa0tX"dab!$u  Q.20;YrWot  !fP$ff ff3g&fGy#f^%T2#QB #Yӯ|8@!8##p ѱ2U z 0 c r	g Uw	t .:\s^\0W*.$tBuIP⢛  ^Xu,.8 #.t/s!P~//XSB#[dĀt
 Sg+r!0ÿ
"ff" H'`k&r7
f^&E$x $ 4.{
f+أ20t2p/fPWvPJ	&!QPYP4,̠4!2P`V CΦ! T !F C9%$t`u@uUtQ!2I's#f w<fQ%yxfYvt&w_u!C;Ht Q>..Ͷ.G$ r
Q2Srs[Yr
rL rQjY߂\PPtª<v>rs	 hPfWjrZ, . u.Mpm2ft!"SQP2~Y8[r2QA÷sYf_XSWJ_H_[drFsr?
D
t+8t$P`ՊX8udѡȱ`ʰ8px3
a >i	dA0`@4C&f ¢I]Еu{1
&&Ks"*f4pp끃 tހ hut
ъ-4Pb$
u$XB	X[	3`1
>J~U^ FVv
nB]FPW s&!Gt8uXuD>L t=+pMs4
й @B8e tC:er3vD6e3UX?&2VS2.6e3RF8r *[Y22@]F]W.>>et>Àt&}&t2,(-)*.)` O4eÿ~<v<t
ц<vєÜȫP 3bN<w<?t0f`u2e*s
2&J&P &L&ģ`&&pK L`  a3 43333
33344454
sIuM@B? &<w
2RtE>
tH&38pl
и 7a3۱R u tF@r!tu!WV ^_ 
?GW _uGG zd a `Zj	 QIڃ. `(.[IXuπð/؁YP%@@t	pTF}F!Gpu Y÷sssQS&G&w&_t0B JKu[pr&OP0 &
tuȋcPQV2
$̊
FY^Y0_ s0&G
Pp&?W&w@
p߀?ZotHH,2۰>tr:osr&9p,uh_ 30p?o1 

$0_s'h
 4G__.>`;`;^9ëp 0&$F@e;	@su Ǻ ܺ@+o߹  4t<v<tP&X@F20s @&f` P1ftJf &&	7
aTugQc$_<0tqZt2- ku "Eo aE1^X qqyߊѾ7P.8u*f{0 @)z"}aq`A(  `	s63ftft\eU} t$D ut' $dc4 AǀX$1>&0 )1VWS t߃#`IF[_^ rZf fV 2~Ê߹  r:<w40r*%uf21Sf[fPDV@gs05`t*Q.LYt  u
"8ӻu^ZSQ"s	.So[ Yrߊ̀vXq̡PSf #brcŀtʀ tO<ЛrCQoYr?I`PPf;Xr-u f.;vuqw	 `r_aYf@MRVSӆit|.<t.9uk.|t.9\u^.| 8LuQ ttD.Dt=Q
.lYt(t/.> gr' tPQ0e.DYXuP!
~[` 0"`Rf
2f&ffȐX&e&} ]@.Dufѯp0 tR3Zt	pp   t ϐHK%Q Ms, f+VmwP^ 	X^[*0
 ^94S
9B^HQKtE&gE`JE aJ ^oxйLHKDA&< <  I m  @   	 -`pPPд 1-l#PSPS +׀ `3 s<s at< rj7I<S<.97H<r[._{E#[t/u..s߃l6&=	r	;v1SSߊWм|@*t
 #u[[_[ø RvvvZvxЖnQrg  0K YPVPV<v	w rL^ r WffP@X2A5?$_@lsPDl

f*2L<w 7PEXffsfB fߋ^
`p
f?3f;w<<R i.8ab.<usv@C pQ2<v+<t'<v! tƐtN"DS_polQf
QPX@. p
.&R Qs] P;sf0  w| YrVgI^w
PZfXuEu$Pu
$0VW#sB d @&|&\CrwP#
Xu Ѻ	 Z0
 u^C7
f ts    	

#
Fr=.t 35W`@`8u
X@P@_2.@S6&[X<`r<qwRZP$<pw s2S#(S[2ۀvESp%RffZ{fp 
[pmP =.c?fY.1snfARm	Ca@?0xa,0Rb#MQN[sSuNqz5u߸ `2,"y:.F+o9sau\Uص÷ zMي3
x`@!2 g80"
Xr+5}r 45uUǋz% 2BVP3Q^5 M3
N] `WP1PS ^@0[HF`ۋY.6~VWRr;~s8 ~JuZ_^N t0S[_`\w
Đ2110CVz 
  j2r@p  _2Ph@ & PX60"2P	X uA0`2RߋZ !Pç[ ؆! PX PҪ C"	ƀu̀_<$
2`aesUDtMrEWfV.4.tc.TP&} _w(&
&Ut.9
u.9UuA>fQs^r
\/ r"DfPP@XÀPˀ  V"E`fa[f.Vf&f!u
$'tPAf%`b:ahq`5j#t
^tXqtftY
0t'u-`C1ȵqZڀ \`^PreFc4ܩPdpЯ @pS P P ?J	Ӣ&/	&  u"A#P
	tAfXf^r s  r߀tХ̀_u
_ma<XQVW_^YS. 	sK;pM`0a@s  Cy B jVS3۬
t
<a|<zw$C`^#V    A 72PP2@it.:u23PV .^f.<Inteu   	  
 	 RaPa C` PB BA B;rXa~s  .oH@uSb@ uP4[.oHBar+ 6  ;`&  f}8f%f;19RC}`VPMp 3f.f
`+؀nҖfAJ\ Iu	fSff@ܰP/]sPa 3{WI pWI^YRA.WI0PRf6 0.df 
00.DPR.ff.V` I .FFMȋF 
tJHa?  ׉FACFARR A䀀V@`*
  )]!9p#~1_$<AP-<uX.>Jt  +.J< P.tfcARtsZf²Ĳeg|ۀt5r	?Hr2dR]ۀt¥ `.ȃ v(.жuc.<s.tFbf u.t-.5߀ut."pe1
fQ̀Y   @FV *Os`5P@DXe<DG$hZ0kt	jf'`p- _P4=裂DHPbCCot!N`	DM 4Qbb< PrQQbU vhдS+	3TQgQӡs

rRR
RZR   $ bPBB쿊CZQ
Q QQ0_P<fƊ_$f==fffX°"t
p tf0ZYQ Q `  	Qϱq` S{
 tPP첺P q;4P U'$@``` ЖS S2  1dQ$d[$P50aɀS
S` 
  Rf`
 P`P @8ftsrg Z UdPҩ ` ğaܟPS""
[XȲ"Cc^p!%!ff6QPAQ﵀`  PA%
  wfS%f%PŀrЌ}P tn%2'ff)f#ff#fSahfA(-S-('RA'@u_ fP('fXӋ##[u9X.=          @     @QSr|wrwKH؂n1 V ;v7 xֿZ+q+±2\\sRfZf+`faf GU`F FFP.8\uE.T;u2	u	Ff$ f"uPfVe.  ^0!

uC⦾DD?  + оA<u /f^a]|s(1F3Pprif^@=wA@_`SRWVPtCO	r<.|t4.Et"0t.\Q" YsÀtǀP^_Z`UЎ Qs"0f&;u Eu&M]p ArA	ȋ+;r1;r-fQ&
 8;nfYuaSR sZ[.6P.8u.| P.;6PrSRVWr;u6wb	M1 	_;^ZV3St Uu2
^`WV_rGf^u4t@u&u!SQRP XZY[s`^_X@0`Q  qQ{,U .8utPYf$ADDfIN30 (>Et_'WuA &Ѕ1/f^T4r$/<t<R?r~f&?E   3@zG$<<<f RVr
.|!!^`Ȏ؎ `# t8.D;..\f^t@ 

sV! 
r.PP

]aÿ`'r~yRӊP` X Zun1tQtLM4s@Ass45s
7=v<?Wf_JJ^uS6BЅЅ<}P't0BN-C.
t<2,!+t.
,G<|`$QET:< PW4 ht@YV]6ϋ6`1PVH9""bZl@#u;ndWfA6fQ6PrUwP2B#u[< mk EZXYv]_֊|PǿXt	+t8 o  d %-|Ph%pM  := f^Vr+;t"s	Eu
< u	f3@h3[pt#|=p@fpQwJSAH[8 rQZYs
R sf=RDZtr$|qC}Kr. u)"XбbtkLUsqPSQfVQ  rٰ6.&:
Qyf tFf^Ya`s%(T?sHQwf ݽ3꾝0QѓsxuK= w4 w.HKPPιaUZ;v| Q+tN z[[[[ twǾT[`P÷ p  wf~%L t@ffRZXQ`;v
t
 
 
" p0ƒ΀wWRZsNp/p  .:?u0.>`(bJ pZu.n2`Ґ0 
30;} .	fv?fQ
P pZ
@JZyyۑHp	iAZ3f
 ?Q1VWfǀvf`K1ZP	-ހrs$DV)`) ! 	
PSfVPMrA!$@uc] .@^PPPPPPPP P!P$P%PSwf3]˶a0!{Ct3`
ނ(ZAt2 2h2ۨ#?qfq 8 !)} s@PWvijRfZP[tuU  updsEjtz Rs3 @	<wPpXs uPF !Gb'_1G G
t$ 1C ]#;tt|AqjFGo R*N_@uNQIM_____``@sþ_-FF3F۴ 6.:註Q0Y 024/sR Zk>B p!K2^@7 V```aaFaaa
4`~2C<vSƋ[tq&fa/ q'@'fk^@T#t,x
<pŰgĊ~,+ ,2s2Su; xx |s Z þ/.0p Ϳ ȉNcfCp7: c0Y ;f P(fu _t7f<) i!ff f4Af% ;WF  Àu#\"dnR \gQ-00
Őh*ab_bpbae@ Wf_fVBE/fFP﫰zA
@C1r0f« f ff+À fG
f p	4
zqf# $0-p8u2uA\4 c/ctr ޾ 2SE4
/Zs
 u6@$ .(vӀ۶vu
RSpڷQ[Zb[S 3ɶ6u6F #Q5$d"i@ PQRVtHc.? pVP<	觧r`9f t4W_s)v!f&y=&} u &G
aÝ`SasSRZ q{3ҋʰgrU]deddF5
s;pw S.)d[,JP@t  5r=$ ? r@o{:Hp?7
cr" ^N2$1`8t\tCf	gtwAf@btir߰a< tA@CӴ1a[PMIDn_    Intel(r)915GM/910ML` 5MS Graphics Chip Accelerated VGA BIOS  Cor;poion#~ontrol Hardware Vers 0.0 `abcdefghijklmnopq<M\:KZ00224488:::<<<AACCEEIIKKKMMMPPRRTTXXZZZ\\\```aaabbbcccdddeeefffggghhhiiijjjkkblllmmmnnnooopppqqq  5  0  2   fg;iiiii7j<k	kn/daM`bf .<t.:utOFûE2&+]OuMWPESAP Ÿ@efefP@fXfQv4F@;t/aQ@wetf s tfffYfS_uV f&E-  ߃aXðQ .V@Ύ޾eJ  @e suVoO$ G֨_  u к a^@ @`^֠ ^_n_ի o p﫸pՊwfۊơ ܀rf
P rf@@f2tm?QRf`af3ZY 
LՁ
Պu9
mr;g$:Iͤr	 {@p`O%nN}ӏͰLrf
VÀ>Ivm@wdtYw@t$;wR?$;v@fc1q t@~`3xcjjcjjjjkRۃ`܀  )j.$fat*R`@	蠟ZP	XfN Hߓ ~


F wf f` ta f{I | B0a~"_ $y+Ca6ӀtE#>âw1gia% _ftԛt)vGwAºBffP S ǯBB젡T 
RVIӋ_ݺ P!=ݰvp,8 t3
9P%ҀsZ2fQfBQP
fT0fYR CIR[:Tt` uZP̃XVD u.fD
f=8w"Њf`IR VfZ	[D^ÿf0.E.e! *$P	P0
 +$pE0	f .4e{ fڐ	߀8u{$?
!32IBߨu	pVr
.
 @?$
ÑߨaV.|^쁓"2f^PP>} t"tt+t.D/@t au V^r
ޠ
2^< <#t2 <"t
+ <!t  Q`u7
0Q2ъȀ
ufPqu;pusY@>݋иO O sOYˀ u3u"*D\讬u> &p`uu t kudu^sY8s
tQG8s8s8t3 t-0vv&8swˊ
r*ˋc
qP8bu J NذrPÆ2/ۋ<q`R
tB@a1p@2$b&LN @<v0	r	e狕P鑘쿉F ^Sr{Bgtw%gvk&J`֋&FЋsBuՃdr' wP酓zu$0<0 t**F 
t*02P ؊֡	a>`w@P~tAr<w!#tte$XZ;Ju؊˰ f'
tQVP^YuQWw_YuCW B~~	2@
2@PP *ڀ n@
  toʋ?XZQ2	/ ++(+t؋X:  + 
"a݁{BtG:#sNOFGuxsOG$	B y*2n10>K , !?+ 'k'ȋP&1u'D`'$4$p&z  %2C3, B"pCR S w؎
]ȑ'Jur&^=ց3Ju=>wP67)4&	55Fb1QZ6c5 XqJrv
t-r^ <G!M`sw r
&XtR٭נQqQ0QP2GtB2E tO FƮS ƯPЎȎ~ 0u.&>| t
$𻋄c-0@ȱ\/,ppRC&PD+(2 _6t
0su@a#Pb0 2&<u2ۭypWËUƋ0t
Ju]+
]Q wLwPaz x͋Y$r!v$$:ˀu　?600Ql$$s$guz
o׫3*48*0*^OFH,G}`/$ְ /Ë?*) j
y$6| 62 u>
xĪm?í&0  &0%Ê)"r>^!Mu0+,GY3,+K'B2Nğu9@ZZVWѤ ts
҃_^GMu۸ ]3@ø&C$\p/0 a
WR $FԊrǪ8JuZ_+P*Mu-3ɬs
,p&1  >ctGBÀ
9r3>fo߀  
T fR@
 F$
 r7uɊ PW.>eu>&}JPbQǪ_XwLԸoǀr#Yts-" (&"%
Ī&#Z
rɀ\sي
u7!~y@s
x`ALuͿ1x  w 
pd!! esX @
ff

W,	0	ϳ2,"yN6@	@	ʸ (⨀Pbr$$pt<
tG<P<u(  2 y yb2`@<
vR vRAZ:ZuP2:6vFR
tp8rSbƇP [Dorp^ʊ3?ɸa~0
uVЊdЊPSQRaPaDnXaZWY[X|*v
܀ՈF0F02<}:}C}\}}}	}}}}}~~~&~G~<s<trtt|0ù 2&<F 4w t3&ee!3<
EQ.~T  @@5 ß`P&0y OuËÀ8 0
1>ǀh  fnNËEϊĊNuÿq 2Fó π?} Q ` K#Nu	f&K͉DSRP$?.&\~RP ^ `~[[c   XʊZ[PΊXPvXP) ~~~~l|8 8| <<]<80    <fBBf< Ù}x<fff<~

x rT88T  >>`ZZpff f { "8DD8[p
~~~  Q  	 0``0A$BB$@

V` l$Q  ll  l ||f6j 8L8xz 0 0```0 @ y <<fG00'0  || 8x~ |p <| <l |ƀD |  ~H  a00!2  
x | ff|7ff    bhxhb `·~ @< p flxlf bf  ΰ|`Ư||~Z<ql)Ƃ  88l#<2 xp``x  x -/0 U x|v `` p 60x00x3v|x`lvn 8 1̀b /P7ܢ-T| p| v | q$4-4 /ll3
6|p&0d; (1B 00 # vp?&qp|8B
|!f!&88 `x`:|~~ ~΀)".a0%||`l``p9PH~ w?p

6ff+ 8<}448ll8 6{0` BU6F{ \E|1S6ll6W~` l  "# {U# wA 4T d  6 dP [ 5 NOqP_U1UQ2dt770?dK?0aa66R9j a	
Q R>     tv Q@bC8~llHO3O rg8 s 8||`rTXl( <"CBfa||"|DPh"  l~`l~ Y%r[&; p0jo
G<8p(5ly:}Xl<p&PlN~0QEP< cSld$DtUtZ3ZNTvTu W32xQ|2)
xpbn|ll[|}20ư a4!֕BP{ |`Sl8>70k B @sV &
񉅇R`g#Z8|||8鋊;ff""AR	+p+q`llҒMv	܃od  $5)/ԑ#| 1DVsr  @Pb
1upbᔳ 2ES67
  ц%25R$FPB@S9byA1 `	Q$(f  PC=' # 7%7@Pa "D"%
t@Ý
0l2`6$6~~$E47㠃#
l|8@s3OƆpb#<,00PcRr-0Lu;T 3'$D bZЦe  1d23]%@`aB=`_ ְr;b95Qp$R "ëBfӬ03*Pw~Ry Ap otmeۯk5̓Oh0xӰ`0HH0i ! ah tC[D 0fAxxAcl>j%Uڨ	%SQ#xFΤ W1hPr`xC0q C'7!1^ H(F/`1L!#<0[<\Qj0FespfS_dx0`ܶ=> lܬ>ҚdwD) ew) )ü ut  (Yǳx 7ȥWU> T 4˳ ^S̅d s͢Ͳ5Uc 	&
J TӄK$%҇`Kӧiso
̓@"bRt``0`&"bct "1آ1vetn v ||@<`p`v3 9 tt!K pܶܵ*$1R3Co0`
7| / %4 FU}' 27Whu -7tu #8] /䳔TJ}800% 7]i4&4Eb6 ‸ <Be aְ" 8Fdv D%Eu\fRU 閝\
 5cх ե0&C`e t% EWu % Em  'D~+NWB^ ]Ë
  1 
Met4 G= &tDftt0
"$d #$%e2 3401hK"r5B Vgv	! "f,`G'aw D 	8Fif. GeEt8Bm`lx@-Mo 
/on 	/Oi .Mm +Ok /Im`tܠk$5Fpctq =FTfv||6<] }RRfyѯHU<9ر p>| o` ,4@IXg v!"ť#$0v?ѤƢË5þц&) ~ð 	!S P   1 0 a.Ԝ&6| &>~ ÷
*r
t	2.ò`Ϲ  ~   ц~тє! w<
u&| ϲ 2.^FFF3ҹ `P樸` Ԩ ΨȨ X  * : aQYSظ s2t  [߸{u ic
>ctSÐ/    ^^ >I辙su
^ t 36ȢJ2 Lc&>Iu	B$P
	JX̀v`
p uH-ب <ĩ_tQ @ rw
2F.Ê.̀Nп$F $FF.q( ک _ZUoȨè<w$u 4$
p À0&&_WQ	_@Z<ow?1 A tSD[
*!&VUNq<w4#@tÂ u5Bcb?ȫFt#!)#
 `԰8 u{ 3ҴugĠtb(u]̊.-ŴQYR  
 8 t$8u
;(
=
28u2ɋZ aR23Z%t<vÊ>bSu
PRYNVQ~ċюF&<
vu^Ft&FVRU r̒,]Z:Jr92:6v/RS=b=P [
tZV t^^YuZO[
<t<t<
t<
tx@(` t
t$0<0tur ͉N`u6׆s%&2Ft0 u*ш)s&:s2& #   a     ? t"<(* II `ga!I<v}	.ǫ.﫪tI<tE2<t?<r<v7<	r
<v/<ov)W  WuCt	t`2êSPm@X[$t   ͡ъ$g`Ip
P4
ğ3RQ$2.>euZ&G&Gt R 
 &_Wt%
&;G 
 2    _ @    fPQV fVf.Da 4f^^YfX< !!ȭ14f3f^FFfPfSLqfa#fbff f Qf% ;ëu@[`PSQRQm+YZY[Q Ƞ@YbMfp/Pf.}.7/
CCRRt!Q̀YZ蓟7t&p
t&wG  x    b2
f X蚠=Q3&&Ϭ&I1f P tQ | fYÀVFF30^XtJ՞QF	 DYPRfW#0f "!fP   f3{迀   0K@P sg  ['u_ ^P
Dys-pCR*  CA	  
 f$ wq	y
`F0
!3
y1

f{[X@f_Z) QVV԰?^B*&5%&&&^0 &T@pRV0&$F@&F{誜  PX@F2ܜ q`^ZRDMZ@ h$Āu[Y27V蕛嫊Nu^D7QOC7R虛f<Z4QfV6qf^Y55`4h s4?t47t4\@̗4c464
åQqc22222222RV2B3۾2^ZS1c1YØ    8 4 0 < !! !!!!P!!!!  !!!# $($0$8$@$$$$ $ ```D`@``L`H``a bb @``              !!!!!! !!     #v1xx">Vz==8f=,=.=d@===H=z===y==BH=0== = ==
=v{f=Y=[=O2%>DU>.P>SQ0!2t$L-`}$Od   : ,ĪaAUc	PCP@P @ UqD"wΗX# ԙ0] 
gh2  ,h	PX^oߵƮ`. fȎ1)`.>f; lf3AHr(|$utD rq  m.6rӄPgTP r   r{Wށ{
 g !^f t-
f&9af&_ M f+W?. T&= tf&m)!_qffaðPfq EQ M y aR $fpf	u(ff(`m}p r} tܰUl pAw<f;%+"l r&;f&_HIBM
fHQf=ؗQ
 r2u&} s
PQS-[  <
QW 
 ftV`^tu{A_Y `VqeB ^
Dƣa&Eǣc\ ;v++\P{=;6as;>crڿqa .qǾ覎ñu6xPt'v %+	@Px N ð  t%u7m!Pfpۯ? @6 S衖[ 虖[ f $ADDIN30,ϺVͻ AIM3b0A  @ X@ Q Intel Corp. LVDS04Tp`Qf jfPi...W S..!ff[
0Ef.>_ v `pݺb 0p8fX 2ZY๷2 о0sbuL.;w.;v
RWfVvTtOBf.G} u"Ұu0R j`ZR Zr
`
yf^_fZ fV$< v99fb #Vg}? s1 3LҸq_S fۭVѓ2П[S @t o3ɐRW칀t
_ZP9.$ W4Jv0_ `@n$<u<.\.r   PXfTA2f`1 #`Z`@.&<
UKs....@  "PO߳  5bOukRK6	~f.d..\= rw rL<&]fff.	\. .FG@ P	3@  .G$0<0u.afVf.t2A.Qf;P/uPd H0gZf/^[ ~Q2fuf؃ %	 ͫlqEd34UDpīĳcŝ
D	V  AY DDPU@DSDTY@ " HD|   G? 	  
@  $ 6 d_   IL  J ]B 	 @ , "	eJz ,?,Sg[ 00?	s  i,,


j6Kd@Xkl 
 
PÖ` q@Q@kQm v lC q \ l @AEq@k6
-2-3 A  ``_  3 dj 
=uz 
< FL "Z  L  "oV 
u
 ?E _S   
E 
y 
O 

SZ ߀ MnE(  02<@(@(w<2 3 = < @3`= @<`3w=0; 3 ;1 0 4 >`{; `4@>w ;4 :` 5>@( (`:@1 0@5 ( :  5 ? 9  6@?906`? 90@06 (8  7 (`8@7   `07~?7`0r `;`*  ;  0 :@  0`<p*@*:``0<P   =* *9 0=p    
>* *w8 1 g)  @? 7@1`?*)   2 )6@2*)  `2@(v 5  3`w`)@ @3@)43(* )4  4(*(  @ 5 . . 5 0`5.-4 @6.- 4 6. -3~ 70/, ! 8P/,2 8/ , 29/+1  :/`+`1: +  @;(*0@`<8    =8)@0=H`)`' >H )@?X(`$@#a6@-@6-6 -,5~,7@-,@ 7-@,4~-8 .+@ 8 .+ @9@.@+3`*:`. +@3: *  @;.!2 '<. *@20 )  @= /@)1! /10>@/(@ @? /`61 1)/)1  `p< < + + `0* `"ú0*  1X (& @A &06DPѐ  ]Ń mP鈱 f%Ѣf=u˷XПP R@efթu= w
`}w6fQWP3܅tf
@@@$	Xr/QYv
wfD f0W_{fؠt
!c@C"A_T2. t.w軇f7?0<1̉@ൣנrWRZ_Sr3F!f%SSpt@f
qTaf+Q2<n܆ `2f2!t&º2"@t f0fXf^q 
fш"[ @:=vL= v^"m@RfP0e
ڠd+3
0ub(  <  wrP+ Sg[0]uB1
j  ! R b r "2B !Rz r [   dteuVfvW V
fq  %"
v
=r 
~ #¿ %B
  #  #{  }& & F $Д e Vf W ظz@ о?ǻǹP0 	߰ǻP`S8t< u	[X󭿋ج@0F f fpG G1w^0 u4!+ ^_ع  `J_ ^V @uKfRPA|3 mX{/ ΁ J G!OGfZȹ	 .8t.L
ǃ	!p91 SQUT;AfWaŅf@tXa覅b¾Z$̥̉  _ͼ    ʚ#ʡOGDGoration Generic Device 12 A N@1f^t" gr	c@a	ÿ@tdaQW&]rfS+~f[r$
ط]Y@00  @  8WPXEtpD(2f Yt2Q"Y[Z jAvdlaw{wuLff@#
M[ZQV:˹,t.9Tr.9\r	^Y 8t&;Ew-&;]w'f0PYr;Crp WsQ@sVfW^W &  &E _^rC&E
t{&E&E0QW  _Y@f趇fZr
4ps,i_^ t`mItuȊȰfu}<u,."/\pE QrH&
qqEq
	.\Io膂7fX~{'_[5  ()bc./1 24 7 8 :; !  {t	M8 Y͹ *m͹ !Hf2~QR?ZYa [<Q+ +
P>SQWO60#t&#E_QVfS zt!`h"2BRbr#3CcshWj[zV  6zu	 
 fftF.vfSVй-PQ3PFffs{f  ff^}qz{~ {ffI  .`^s fPHfXϊsfQ@6Q@2{tQ^qUۄs`+e6X%P?q_`f3*r`g}fe  7br   _rO8 9 f&] R     ~ f&	Ua WIf3fƱD<	t<tQ<"tm< c<<<<tt    BfP
-B?p. 
@@t^@@"f@  ) ?  9 0 f@ tϱ3TX1  f&U&]" sSY t;Q7FYd15_ҩ2Q
ffڹ?)r'z}SS
S  } P`;C&]_X|RVJr.|QQ.S6[rPXff_Yq6fPp )SQP}XPSe| [#w[ \n #
RSL[rS =ArIr@	yr9<uu΀t"tt
rfPfػfXQQ t!` u@rt@nr
dcwπPtdx @x0u!̱t`pt `|RXD8tmrZ6fa``!scwT KgֹArQ9rIԹ-SKQr3&ttsms](a!&0']v'M'ag I!/]Qޡlr ;E]#`;`ߡrMfa%q_fotdЏѰ #^21P@U#Rpf;r)glsPR$4
ZX	@CRրZr-kH&}_uu4 e
$rӦbQxTotal time for VGA POST:   Seconds 0.000 
 initializ" < 10 Milli 
 `.&Zx.ԃ.Ը@FA.Կt.ԋ.u  6*Qjn` 1.&0
qs .aPVJP% t*.?
.8tFF.L2t<cs^X	
>
2.Aw k09
ps4pW苿oꀰ4@
;
jps.$f{#9y52
?ps2O2@nq"ʀ)2ɳPr0kptN3pp.>,uyp2 6pt$.ppbZ 0nHվpf.?f.+Բ"rp{p(sp .
&t ?詡:0fg	fPf.>1l
UsOsIs &Cv { 0@f`RupA׬1@f.=A~`JpAa
P`+ qfpf tp=wpI8a`p+qXf-wfwffI sQp% f1vYP.
hXú#c&π `	 2Ϻ "ĊRZ$`
s$.
tAP0ԋ	tA.
t*. 	23.. úUpUuu_&
#0F.Ի e* ˿@   Y ~ | тPëO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       u     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    NEAX N`  p L   OA B  C{B JECJ`  p K{CFED`F`  p aGDcEB !6ESI 6`  2 2݀`  :P w: > >`  REIR`  VCS
0Drq .@,SQw*F(G1ZF 
rDR0 vp 1 z 2 ~P3 4 {05 6 7^KCfp Pj PnPPQsXsp qQp 1##`p 

		lѳٳͪճݳŀGDT ɀIq L Tp:!rp Ps~wNN a&wBS JXDF]
A(6b2g$:{lZ" "V:,R  C,D>F0q".u *yD(}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=vB zGD~LQV$[`e>pxDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^Tfj
nX4`h4  ####
#M#	#%& U& & & &%%%&%Fy(b+ŀ-ɀ '%!VVVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` | 5 tUP ~>t:o$>U@P #uG6J557 qs
G{7} u V" "$r;sc|7۰$ 	 PSQRp.	c(f._f.f  Uj AnAr
u, 
 t$.tN u% ;t	.^ /urt..9Vt!`	c.툱		!wvp a{ P0urotib aa
uj. .>_0u+.^t
 u3t-Bt._ ;33u'߀u2_". ڠ d` &.ZY[XfP.^P1_af`"r"{>"e"
w B$? 8 b ",  %" L faù   Ptu
t>=%4)u	`,Ò!h	N
	 :tw%3q ct3sT4=  fPf&@1Ka}1q	21 -6U<u f.R=fu<=upfffDf.
?f.@#ް(RfC  f. ./c .3Ӎ!>/d /8d A9
uf36p;ZY{f[PSVW>< t"<\u <nuF=3<~u s2*3_^ !PS>:FsI>%=s@>a4s7>(r;< u< <A<u2B
VM5'2^P'  Cycles(uSec= ) ???BfQfRVI u\P@@??r611ftf+fx`Bvfu	61ff331f.x082^fZf .{ CZ<7 &ZKJ PQt0Sc 2r	12tY`Q`sV2'| !	 y2s
11t菟4r_^QW<;t=  ?A $3s?v4u1rw$0.Ws_b>1tT!I4u}1uP	pX
C=34u2r:f s20W%U1t 2r#t-6-0/
r\afb ]   
   P 1t-*3ur2r,$0t
>r.d.NWa УJJaXW\p2Wt5@"7.R.;Iuf.;KtU J^\ o`96XR	r n6S p2ft<guX<t<t<ͳuL@8
t@8.T><pV34!<1?1?(/?pÍ:@!4`AoG `dc1a%eUa Ñ/tI.> rI/rD/> H0r5} uf!u%$ "PufP 
t	 Rᾀ]MS?e [ 6[ޣ QCzP
[}ߺ++/0s+Bhp2u/|-(-C-.ұ0fP@A0\fW7O- RffGGt
S_9 [Vwb:-^f;t]-wpaߗ-GQ-
@YSb@HfVf3Ѐ?t-#.fGfsG s,  fsEXMemory, I/O andBb!˂s must use hardware (0-3P->Yr#-2]..@N>Fr-=.뢙6lmrDP[	{v  {k-t.r__@  .՛QPpP. f $- G@  >i
 r߈G@  /h ,
 G}P W'r{W
fv`GG ,r u6rП.O>
 rGG s',td r#_G  |6f*bMQM,r0fu!`A~Fue`f10y1pkY!\/[[iP'0	Y r'%3pp@b  B+r2Qtn   9r͓FA%]r
+r:1#Gar+r$#1r\+r0	.+`,r s
]-us+u PXYR
 &ies_/numb PQc bS6(  τ t"@Q(6(.'))~BP#     Eype= Length= Bas BytTrac NVW~  F(()ukG>!t )6o"(d M7`(108J 
G6>}'fGnt;)[	(GO(:
N(])"=-8E 6	 @'Laldy active. Do you wa`Nto repl  i@OY/N)? RVWU` t0@.b 6[PpErw
f[Gff.!!Y At`	PRB Of`fm3
G
GcH]_^dW؍ 
2 @ T{_oS
Hg7 sI &Q AAAr<s8f f
up10Soft=jnovailq..
naGww
`VVQ@ u
D- u+@_T rP] u629%P>&	 EXA!~vAV6@
 A5|t/fTfpdc[./D.GIuG^`!4.Da9Ou.S3)a-{a` &	>!VWQ- Y^_.?@aPPR_ !Cr=0 r	f9Ou w.s SP# PX1m ۶(
 #0b`".&^An$ ù p o    PQ1.E..Fô rGGA$r8 ~5f}o#`#O#p~M#CP$OOF9A:A0 r,P;A5@$t"	r=G$r
1W$ts
 u	rcf=  w[3T}%rR wJ#tCi%r>w8#t.T%r)0w#
؀j#r#t_6%rt_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    !#t+%t`C #t% #    u ? +3R0EFfƀA!  [s02!.!] E!t.. ȰV ঀt  E

`t#C v#0<r!
 1~2Ui^Nx ~@v  ^xA+
u!>! v !9!.,!, !B;Vr蓅!wAɡ`L -  6 ! $s $/e P{X" :i . 
 A`zsuz9!u#P# f"Ћ޴ u
@)@"<#f.# #` !vf :Ц3Sp_"f2bZp-.9Ɛud@VW/u^/ xtR-)w.#
t0 +)0#"#"E..VW." s 
f=8sW@6E$k  ># 0!.# .	Cr!
&A4s: |0;n$6$E@0 ."  %?="/'ÿ] W> %X_rh< u
P} PtQ: ψ1@+r6%&Gf." $p$rS" .s{9:|}l^
C*I O"uHdFouat physical address  N fxpC ðSmsrkP_,tB0xBs u2@u6;&>07!q~rV&}%~ 6o +@Memocompsu;ccpfulpW_'@9	x`>&?|F *кPuf6']b>?f@`DzaQ1#|!v!t fHt2}.y'QrpHtgIt[|tYrTK.
 LU>eAJx1/P6{| r^uUuI3ɍ>tA<'tp,"uج`(8t$ s&At _Trt~Checksum= k r[ecF s&&&w>t(r%[@^~=0N 
\Q&4tvv rqBBt]T rp+9rFB"I<Lu4F"d r`adv.*#tud0]SWf.>r<:ufF	+rfF>	 r[SRir$r%} u   
frZ[ps   r<*r>*!Ds<$煩 0t`.RՀ6VV.0 4*=B* uV  Ka.B*?r`o0*wH4* 02zBr&`j r..*k.
8q>*#R9 	v~	Pv`D*zFp ܠ!8*PF* sQжec`c>||U|qgF!
Hh>J*~.6H*@G@J* kaDoH*@F*.4`98*w
.B*PD*N Wqw2D>t@Pp1`  .;uf.;u>-(sw.lAf`0,  5~p gq	tPuI` 9t3..>ֿ 
E. V	4m= ''0'"~ "

IP.;Kt2IKfQ @c3Ú	!>Sq@K.,6S%3@(.,ޣ<@쾐~RFXPW\@J  aCPU Time Stamp display= Speed= Must set sA to ena_ble tsBtJPr@de=@h.v&uʨ&>rN <uFv%0.{2.~0-n. 6-YQv3CӋR"
c ter =   uSec	t
r!6o.Cx!.Í>rtG
SrS 
<t.p&Nt#>/r/.< u8t">r.Z
u
#&W
*T7argpis@rt . R  manually if fails 6i/WMq9P=ˆ9^V6'~F auЗP66 ^D PQW> %>U s_YXLt2,[r0 p1pPnr.Jp׿ u  .D;& $r 2w,<r(.됲 #rCF XA*s	_ @p>&
mkw@zbu	1PW.Àr p}#rTR.ݭD V fRQ__NSٜ4jX?ɝ0x I FIJV  @kALqecYQ 1
`P?W
q.Li
(.a
`0Uz`E`	dy's0
 u &M	gø C	>thr6>riS;;K;I;;@ ߀ #                                                                                                                                 А2g22}[W>2 2 t>6 _ W} v	 EAC r3ۉ_?2St]AM][Q_)Ϡ &
09P
PXq2t^2<w.22 [SZrġΑzPb  1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:_` ?	3f<u.3<xZ.3<Q<
3< E<
u.2<.:7<u 4 0<s+.2<"&8<b1<r1Ta`@u< <up8<.:Xp ː3>02p .?>2<:	w4<.5> 5<t@p ˀu 8or 6<7<[ø.1<.&2<p1p.=<X@E2@7<.*6< v&.6<& Laazp7*3<
.C30<2<  ϊŴ* # K`
!R.9<
 Z ;<<ZÆwBB PV '~^QR 3du tCl`$<6t<*t` u.A<

y"P%A<
x<Cwp:.A$`ןB<p <t
ArZwG ZY12
d0 R7 r  dI r`.@<r`@ d`Z	 .@<`!Q
t
QhE@ Y@us33`8um"ɀf`8<O W  F F@ &} tC t;k0Tta30h &;&E  ظ@ P ^ X Wu-  ~apPfaV	tQOA _ YRfRW.OA. 
Aw#&.U!
tff.PAƽ.TAA_fXOAu.UA.TA讽_f.PApqKKKJ	JCK9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH+ r.A觳  cAPPJ <t<t<
)SQVWێÍA<t<wPXrs<v@A.A>A &_^Y0/3	0		AQ zY!<8t	 `<PVt:=EIAc
<
t0FXAP QpRt @Qȵ$0<:|u.P ff PffXV	 Xi
Pj}^Vf3
?f^  Z  f`
Qf
|  >COCrf0f3ftY C++x fa

^E    1C< tN< XÀ ް{pju7A!Vٿu`U<0rp<Zw<As<9wA;t^M<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3A_ 7_!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4 _jP&{OIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYfো% r}sP r
<:uft_Wf33ɋ1 r	f
ANp:  uf3wx0<fw,W<Fw<A 70,0@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p<'t	A
kNt<Yt
<NtNP3t8tNXPL9*HHHì
uÊG O?À=/3EPVWuuu0_U UUUJ V?cU0W4W)UXs@Y#YAAPT P G WIN HHHH8U$<w%.HGu0
t;wP
Ȱ
 3]8fx`f`ؿf   0`HB8uĀuBJu*@u
tgB$JQ @tgB/~!J
 Zfp$ u#@=gJ BJ0?B  a4[@ASR0p~NZ  r.1	ؿ$d Q @m krPf  bH t$<+ @bH+
cJ$<u	f n g0cH Bh4]uЋ PܠRJaJ u<]! J `4gBpJt0  t t ]!Jr赳r TA0!$1 "	$`<`ut
*B5
u0t		 uJ
T. + ( @}
JНJr?.J"%
ZED!:r re0Mds"B B˰ *U
ǃax ." r"<۰#iP _  "
 5<  nwu;0@ "8t2TuNuF;1t> p wu.SutsJ "1J?J
 "  hs* 4 J*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ꖿ P % R R  A        9  P                                                                                                                   
Compaq BIOScope
  - Skipping POST breakpoint
F / PQ ;p\@ x      d ưʴD` q 	                                                               Z DBEXEPTNDBWAITCMRDCPUREG(6RDDBG rSCTR ^MEMBUoF)ɰ CMRSPIOPORT5aT ISPTEXTˆ̮/INSTCODEI*	SMMGŀdESET7ARG/0UME
wWRWRQ
/]RQ	A^^WR 2Ds/1]WR	 	T T  !!EOP
                                                                < VK @϶    -$  rtˌȎ؎  F߯.UfP.>A uWP.G f3.U.H@ I O M N@EBC .@    AXfX`fSRoP.Bug u_tT.T$ t?$. 0脨rW'pEpD r	
XZf[`M0Np PS tatCu?L7hؚ@ t-u$ظPo hh Lr 	uI[XˠC'P{e
.> t
P ZXPw Xr$$
0
w5 r?x   hP Γ	ruX0rPhBfP f"wC 
 f.|!VQ6'|6  Y^PSQfRV0*U0*,&\f&Tf	 ^fZY[XP3ێù  sϿ ˜0   # Zq	t a*u'迚 4,4 u.>.} u.8 t.9  g JPqG } yrsng#c\XQMF3B;	70,%C
!S
 f`B* >(6.߃>0A6f.R6D.VffX QZ f / 
uf.R>r>^)n1  p ߁Z P3~r# Uv  z Ѐ~!f%#6 .,.>>6ˍ6
0 6.ffaJ f)!f%@UPJR1f-pTf  K 0UP
.QX`0fZt
0T <f%?'f
  TPV!	.Q~

.
..GPWS ^) 0 MSZ.&ZπQ<tQ .G+u
@_!QJ+u)``KX!a @aI	`b  .S	!@%"
?f8.6V.6If#RAKf6Of3ffSkAor3$tA^`.u	DVQ
6ˇd dTt	6݇U  } 4
tY).V0#g&;B*R'Z=u EVW>ˆ菭b& _^FVW~ +䡍>Pdr6>]_^HPx_š pfLfVfWw>ߍ64 /t 3ҋ f1@
G` 
t O
twQ	= ?  68) <R se>uf_f RfYpo/p 3 p 6r<+u<-uPR+ZUR- Qȵ$0<:|ݟuYXP E {  F>@
>W  u
lr3- w|HroQO
8rK<?rDuqr)W.9Pu$e r$q:lVWލwP <r:D9Gu-D
9G
u"VLAt.Ws
B_^ToRVߋր? t  %u
3^RrWU3 8r<
t
<
t	:tuEF]_Ar r r
ê<fw<ar,W<Fw<A 7<9w<0`00AQ1f3aB3w-.-B6/A)A/"G2e-YE.p"PG>q޶BHr
x6ta >|.s<u=0> <u  <u0Pvr).a>PN{ÀssDQ w?QB>@
 Q0s?^P2>BoNYѓJހJg&IҧM 9}rqWGJ@6TMr,	fNfOfAg&@ ?S2fffXPtw aBA@i f.;iw- AZ r%&Q0PPY tfGɰʚ
>A_ r,f
 2mWT)bd@ r@f؀ffFgfd# 
 .႐S3a `t
~܃ffVp xv"  u $P.ߠ$qQnfU.E.9..F .:0G;5A1>5ŋf  t265 uuuf0=/R@f]anQn90P:P;ق651.=Q[ {fDJR_ RQ T
T
{
 Z Z\$
fX Z"Sf3[ffÊ$P  ffff%$pߋ'RC%  ~ffC*** Please restart the system manually.
 .<t$
  
$!~$$0AD?O2撰撍6ŢҘҘӯPE@> Q1Q ػf?tuPRP ү ntJfp˂a T WFOP}tO@wX >vTY|YfPQUGPF >JMu
,~2 6  POX]0qUf ]Qǃ0ŀ@Gbؾff&f&  G>̀ fG`GGaQ6VfWf>҈!f!Q =С ffD4D$fOЬV 6҈fP ʡ  ஀h}$Ph X[õ ޥߦ3@$<sA|Yr.ˠUrO ` SA (tD_orq XPנ"Q!f/0ѣ!EnS  gf /u
> up[PȰ&  cB|`&Xq!og= Bxx<w ˴                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          i ??? fRfVfWfU..f. 6. ` + f.0 's 6э>u. +C..+.> uj.^q:
qf.f=   sIqOq r.Ьq
 .+ s q}6ppt+Ȓp+p
f.f.f]f_f^fZPSQ@ 3<dr<gw,d P$<&Xu
 $	,<w .	.N.Y[XQ<uF$<t
.Ã? t#;OtYQRWSVw*t^w.;0t
|u. >
f3EG.Љ.fEfGЈE
G
.f$ r-/te   @ -@.Ѐ tP=? @ ?XthP[G_ZYrepe  ` np VW>S t6SsCsq?s6 &- + aGp }p	, 5' #  	&r&r_^ rERPfPǋfEEE
EEfXSQVW3#u-6Q	t6# 6QuC_^Y[VWf6
 `F
Æ  fPf$FfX    E	@ k fQffD$ us+ؠ% si}
uFD4/ E}t#uS uN-fD~'  620( iQu K
߀u#*
f	rg
1g
 _u,	 1q/϶, fXfp5 Qߐsw`psY+5 < 7 6bga5rq_~ie@ aȋa8s"s1fE-p[!`D1S
چ	侥!f+B>sQ@"*#%>d{D@@@_RS`rfe  #bV+^	sF?N+R!%
!p	D
MRu
HaI I7<&!5 6^<us
(N3A&aNs@OA
Na Q5Q5Q"3"+28Qs
1|D1 F$)-R&d
*fs.:a	qmncVt@f1%$ ,r
.`.qFbb$)Z7+P1wPH_+KgD5VF`^q65PKAj5FF<^P9d)w76P9N#; ސnV@Ai8sR176fsAN1*B<-p fgF^ ttt%EEw)|CP{u
s
>c`uF@F2	E TEDDd%=upQb5AIaR-df$0	К(=(t@q	
v+Ұ=uruQ2$GrStY0< 	("rLUY!
R"pY+C J g'S ÈZ1"b#SN1NsX`_|0^ eVfedwcDA+dS 
pedeb4j1>"
S~0 : `ka[X449Bnp^@G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrteF@0gOCf_2`0#escsssdsfsgsfWPʠB6X
TA tWA  @親tAD   + *2+*4+*8o+f5c|- sM?ȁy@ߋu@føtsPørcwp d
q wt ?P~a slc#fEst~ a1`6`%["	
Kѧ]&rbpBb
Fÿbx+si ` d
` p p P" }߃߉ߏߕߘߛߞ uAcA s@E
WV6g4Fg^_rg t 	p!	
  	M
fw_ord db q tbyte %*/" Q ptry  WV.t"Ü6@:s6J,6K&ps#!0RO_Οf^f˕ fXPBXP $0<9~Fab !Ò  s봰+   1$  se+s-!sf    n `@  c w     e\ d  |(    $  ' ( ,ܰ / 0 4 $7 $8 < 4? 		 @ 
/ H  P0dX ` Wa  b  f@ c & h  i +` l 0!m 5 n 9eo ?p Drq G r Kes Nt Ru Uuv Y%w ]x `y c5z g{ j| nE} q~ u	 ylS
8&&#8 ` mf 6 (0 8  |UA     !k  	    10'8 0 % 2  , '  ߚQ+ e #,   u )  k9װ   U3    4   u  ص e 
 5 x~\
8 q/  f  ( 8c  /rð T s  ] 8؃1 /9 %˰ t/ #rFͲ b8 '5 ,$ 1 ,
,
 
b


r
QL 7e? ;  ?s*Fw DD? K w Qe V  [Z ^  (I#  b%  )`$ B`  f k qu v% z8x7r ~   f(+m08su0ZU  !w ! e"w # 0^D8 ۉc b87(be0٣@9 s  (,	 ;Ԓu tn ,   ; e q/ ' 	 % `d$ T  e  ҕ E sj	 ݵ w e @ 2A 8 B ?eC ED LE RuF Y%G `H fI l5J sK yL EM N 	O T
8 ށ8(ݶ 0f8Te e   y5$ y  yd yI y yt y$ y y$ y4 y yI yD y yr	 yT
3 u$w1 %%2 %0 ̄&8 w9   e  	  e   u $% * / 55 : @ FC      Urڲ ! $e  ȥ5 K9 O 8wSuX% ]v0b5 gv k&p u zv& ̓(ɧЍ󽱻  fmv&빆쿶6͖mFަ	V
f
 6f&v.&5v:?uwGL RfX^	eU
Gr|lBp udz y8 ~sf( 0f8ݚР ़`誴 7 50 8۾(l8w8u  ƶ (f08t
ܶ ؅s'8 $ $`}$80 $ 0&ڻ  e$
 0 008  `o8 ˶  5!  MUadd push pop or adc sbb and daa sub s x cmp s inc decaa bouParpl imuP nsbQ  out a  jo Kjn@ cp @ z @ be ja jjp0@ l jglg test xchg mov lea n cbw cwd call waitff sa lQ 0ss stos lod cP
bbb b rol@ r rc cr shl4@  a@et`^ente"f`tA o iave`md xla@oop q c fxzQ jlockpnea e hltPc t ne doiv iQ cltc i
i d@d"xzx lf0gpsPl@`hrd b{sf@ r bt0 sp  c i x!seP 0 P b zbb p"epprb `et gpr 	l	diQ l msw l`sssss	verR w f fchs fabP t "fxf7ld1Q l2q me1piBg2nr z f2xmyl2x fptan` as re>xtrac.s0
f`/ p.sqrs01%/frndq f &+q
ucompvPendis0	clein+fQTf /wesc
env
cst   fre0Q /ar(AfbibC

;  ?	A	 r=fi2a ( wbinv%w	a ::ob @? 6 s zs 0@F@:@s s AlBA CgQIA 8@=puid rdm-rdp 4rdt`rsm ud2 wrxO .  f  yz` {|F}{.s߈x{33	t.dG
U.ޕ
EaF,(-)*d.V)PS ޤ[XFe{$U<v{$tU	&䝀$!!w'E t$$$I4芥"$Q(',}fU$-

迾E%$0c<5r1<" t3"$v74&)6+t06-U0{E#3$6Q9uF;m>{'A0Dt+=F&_<JF8L?Nt!ޕ@PE,S{<$VuBXU&[UD]` 20cf^1i*l
nޕ+q#*vu
UJxL%{E}G/轆'0#dPPOOQoIߑϐ$TT<w(YU_WeC}C'ICߪ<kU&@'tN^86tH`&@  6 f3 t3Vv^

ѷSQW.8
F  1 [Fn6Ff.0.>0QHY.&f.>R[  t8svpJ $GG _Y[PQ.> t7xFYX78eF PNS?r [!Hz %NYa F߸J2 uQFoKEMe	$ <t<t<uAE* om"ME' ;蜡  XEfPQfRf33JFfZYfXSt[OABC`mDP ҀQPہR҂S҃ABC DpPOP R S c?[ QSWP..X. u<u	L <r<w,@.`<  .>
  <  <;u.À
s.  <0r$<9w ,0 P. ` 
 Y.l<?uf. &[u
f.&R<[pOp?uu18xf;t'u_G2p~ .0
_	   h<@ ῀ hZ=6Ȏ؎OƋh3     R  O O      y     F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu	  	6r]dt "
#
C"
EG"
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$qfQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_Py 4JvR6Wl_-8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch ` a b c acD Y     i 0 0^j h=``;@:Wff > hp
襠 DϊfPff
fр aVWA+S@)'WŢpr;_t[s(`(F[_^aW|f` f vrup6fffGfY܂h2 R1Xfߊ$
(ff A	S22*OPr'}!$ 
 uf 8s֊ҊʠXQ;RP
t0^r#XPX  uf 趾auSf{UPfPfXZ治+ ]f0)ff]rff^~m`e#n z= srscB
Cb_ 1f^ ɉw @t; *f@Ikw  B)ђuW6ѩȢ=+f;q%Nf fArg eq}VP$^}p.RfJyZRUQf fuffVfKr=XfuNVFYYu F1KMuY ^Y]Pg>!f0rRg'QSVfNVFfL z^[YrfqXftA3PXQM| N{ O蛂PQA蹊` XPhWGU豐^PԀͻʡ AFд j ]dXÀ-p΋_P^Z`Wᐊ f}W mp_ÿ 0                                                                           -  8o%  >@8sUv V ufu`wQ2=fA<t1 u!ϱ n #r.V sfYZ]fTf;P¿f;fZWf=!r@nurf+Rcr
d`|s
ua

<1GM	k;rrmBaoP蜗XPQrr Pp$Ss[OBzMI6E{/6|JO ~0p`XE)t fat/+f %#fSfQ<g t0dQ#2" ʥUt?j$7 3#tcp֦ꪫ0
ð-@_ɯWV@ ~WB Q Y_W
t^9lst6]V! <5u G	F^B^= ts.
<5 = 
un>9r@  Xf[2P
X^#WfVf桖0t
P E3r&< u P B S f^cô PXs #M#1$!$#$PRT)
u $ސCT C'ð) 1U
 ? 2$
Ǌ4D O $ $
utzpS  Y uðQ3)3zð&pFa
!tt	*tEPZSQSSS&6S"
=S[KS"S <t<!t
<P	<*^Rp`@ ZQRs	 2
 Z3) ӼVP֎ލvS<û	 [rqkX2A^a
 ð!R7 $VfW7 u؃ t^
r
sDp<A) @i2@e^PD3J|
u|	 t0  $<<q<
Av^Àw t" Q
R ؊% ȑ؋ *0Uu Xð2HQVWP 
J0?X_^YaQsJpUP2b袿= 2LB2`|ʁChY
P'/#f@1Q_;ðWB12	RP@1 (S)ðT)ժ Y"5@Z5. Qb	U27
.iQfUfQܐ`fVaMQrMfXf}Q gf@ N V FP`(gf ff"f0f@MufY(A#f]Ë< 3+fQSfVffLfTfDf1Pf^[fYr!սX	AXf P2p 0P,R
WfPPt3  fRfZ軨PP_f] ^YPfWP tOtQD}UP/XY f@P_ YXt
 t$t%I  v n&P@X(RfVt `9?(7VSQWfw#t /r@?d$or	`@* _Y[f^/QWV<wy^_YSQV3۬
Ê^Y[S { e    rV1fffa.6,fff;w	rf;w@0S.- "  u f%3c/aBRrM@u$ Ċ Ċذ1YM0RM= <r <3@Ȁf
ffʝpff   f-   fPSQRW >E謘3&G;r_ZY[Xc%aTU   AS = t	tpQ fp  f@PPu$@f`U4Z4f4f pg&>wtq r 	r
  u f_@ǀ gf&^$f] tt,$
g&"Fg&
FI*$
g&#Fg&FJ	f#F	Pfa
`VR	t#1
t.
t9ttt&U&U2
~w	t
t11wtFt`?
t~g&`
g&@
p
 
u
g& 	TA1P a3Rf\&^q\QU`S՚[PS3[
`}@Xњa CRsɄ3Kr?`,.J3t  .JfPAMS2VW< ЎЦ`9P u
 
P  t 	˻ʆ@uJrr vF0 & O 
bj0&OWˁFUWn+_]v
 ` w_^p< [ ߃Ip  MB  AA$+ D 5+&= @
+&FGvu ,v ,p cu#' -п,&` 
;uO-au-f3ɐALuBH.&"} WIGFp  u2DFȠsN~ rSu[@&zfS h ff8h  `  `^   H  $p@|[ f@_ol f
O艐a Ѝ[q5f 00Z% ;t}f f  f@QQ_Rfx 0BKppK`F5Z`PXfSd``d f@~tf<~OftPSef%0

Ph`DpB_B3NEA1ݐ9Qsݝ{`fхftp" Q@fY fff`fa!Wf@ff3fj`f tf 0OuYÿWr~1Ϩtu ްul`?hk?FrVa?Q L G B = 8 3 . ) $      0p_&GYÀP!.4ðd:WV,.3^_׺PTErD.\SRU|0@EZ0QRMȊm̱EWQR  ZR  pok|Ru8AS؀u
RRp	В PX E%
cE%	X< $ZT
 0
"~
t`0VWt_wZwU
uQ6rEt> r2
tC rͲ  r  P 
`!   v _^eu2
u[rVei1sCr"trS '~;Wr6"Qr
Er3T o")ܠue  
 `  tK\	\*P')0\;#$ rIW("  k_!ڀP(͝B O5}5Bpn0@@r4;3r!- ,-lB`SbA@DQRȳpGKAA1,6,+@ +q X, ^,0 ,P  ,b F-& l@ - -	 - @  -Q <.Q .( . @ . @ / /
 #/G j@ / /   ` 	=Hewlett-Packard 68DTH Ver. F.03 04/13/2005  I ]  Z  l ~q oKBC
sion XX.XX0
 _
  _ 	o~Ar#  @  A  tJP12 Intel(R)  rnal L1 Cachea bi2e	
   6PC CARD-Slot  
 8  	 www.hp.com@;
 p    
  @}! 
 
P DIMM #1/H
28 
B̈́0 	q.SST49LF008 ,
0? ?.P~.!P0
4e   72"3$0~]2No bat y'1"Λ5_t=$W=1 _T*u	 E
yjt)Ӏut&  5& A)wu&u#]
u! /À8W@W AU RtY pvMuG	0bu< u3uOQtru1 ta_0> S:u@8*6R:EFu E0P} jQtTt̀t߀EtH7ݚ1 F )t%> t:& tSuEu?3  wt pE>I q u	PXuP3 t*X,tS%yE wutT 0#)	&2!qp=E3誯*x3;r.Dv+W+Xu432#*u!.ð-s*1!	 2M<Gr<Svƀ ,Gh.#]hC%J u$
<.r!Lu24$`.2K#/h4rPA)<.t<+u
0 uN<- " uJ,0r& 
P56 ;6 %10Ü   EAX= EBQ C D P@SI Q S CS= D@ E S I1xcept1z4 - Overflow!5Bounds Check6@Invalid Opcode7 Device NmAvailablJ8Aou` F/ault9@{ Reserved	10TSS1Segme[ntPr n+12AtЕ V
}3GenerP~ProtecEOrrorq  1 =  System Ha!P'
ߊ
-XÜPRw'u Z fVfR6 4Fup84诇/vzT4pcPr4Yύ63{3tfÍ63j 63`fX/3T ſ63J`64A0Ǎ647XY_WQP64$Q4Q4p4
646g5F
04诳t4]&4贯x4na5WJ`05_o@b	[Q G%; I1`(0X[S	 m6Y5ڟ p C8BBaacaa$aӜ@0UFfFɷ͋N
~fE F Nu3׺ '7ȷn ]
 cRQP~
XÊܹ /FFYNZ1A`QjY`Њ  aÇًP8"ԃ 8 & G9.&7'@'dQR{ Zw
  c Zş 
G XYZ
< 
7 Q   r  `؋   9 _  Q!y
@ 	`uua@ ؀ `
UЋ؎ ]_a@]3G
AF `P C0[oq$9Q` $<u 3 0ؾ   fan3S l^Q]n VQ=3AUAY^` 
aËf3RQ3ff tff3fRAыf;v+R'TYX0P@YP\UfWf&и`1fW聀]^f_f?f_]p_8f <u ~<~  u<  l<c<@%Z<	;Q<
`QH<i?<6<
-P= uX<`<<pXL]WfPCI 2u_fQfRVWfSt$ѻ"r   f;ttN f[_^fZfYffr }  u
Nu`oX  `R s r 2fSRfP%ȝfXZf[ff\Fk5	vf s"`s t s t QVW&= & s fPf&EffXO  _^Y@VWPwO`;t
X2 *W 
_ #tX _^!DNp sP6уufQ fPfsf8 P8s2fYZu< uEuPPuAuZ5?PPE EPP runtime BIOSVers.1  
 O?f?p??@*@O@t@@@@AA-A9AEAHAKAAwU .?]>.[.[ r HR.[
ZpQRP<rt2[5$ԁ !Ȁ
  -" Z`5	$ 2Y~ p[		uR xutRf] SUUUA.UVf	`&n m^CN CWf	al *Z uà ~@u U nPSR<r
 j ?Gpp0^r
t<t ).>A 4z.A 
%  % PQR3uAB$ԡ 3ZYXPS)"
%)[1Q \Ԡa໊\֠Y`t+uWt= (u^
fz)es)ذfw)ep)20W R)a)苠a VR	+txSR _ڊZ[  Z[Kbޠwu? g"ۊȠ((t%kp0Q0
udmB9Z^`*u=蚕u8qρBp4
@ʟp ß2 g賟0URH*u<Pu7Gt_)sltۋڱ
@;Z]PG?bXU 
 s ]`K:KxS>Y {M M>rQ4Ys\ PY)߅ 3Z[x0"g'{`"P3
ݸH WٸG OS QL<IQK *S
 pN qM@B&c'
(<Pd/E\EEEE#F^FFPQ&` XW<ram .D_Swt 
' t r
2[e 9u0^r!<i	rr&_ Qs" r2.D2& r $ ŀs  r 9q	8 r 	&& rr	 ՁôSs+&' @>'  sa$sQ
u>[ WQr%p$S r rq	A9 f" ?$ pQ@	Pm @Xa\#t sq]@t[Radߨt bpt t
@uYм`
 ݨXr`QPPPtRXdYQPQ0 tg	`DXd$!<!tQQ_Q  q&@tPG0X@ػ (`<u
 @&   >!@tA AuqP#@0  , & XV߁  0`O  r
 P<Fu u/s	` 	߀uA
 fu	 X RtGTtu`6FtEuUrPRtKxGr t& 0R] Z&Duhq8Z h 
Xuh$:rX&  U u@ ϡt@Q!	 'rr
Xrrc dP d@y  $& 8t   `{QX uSQ^ `b+OH 7`*C: EN8r011 @Ϩ@X@3QOC*Y  G  0 " p	C  lFpoypOIEMAG  IZ P      	
  `# HDA-L  HDBs A-E r Cu 0USB-FLr CD Hs LS Intnl  -As B C  % _eO  [ H	P 	/` <M IK` c!VKFc	pK /K ?<KCD001EL TORITO SPECIFICATION VMMML  A " * Gxx  x y 1 " *
x"x 0K   s  w_X _y\[8y y P\b é uT ËEtE
_U ʡ0
kr 0 t
XrÀxwf`!i2tW & d_&E3aB&U
&{]@ &EL t û\Mu0&E@ !Af~A<$PnP!`=N 'N N  = "fPff  @ fXtfUfp fSfPfQfRfVfWg]?rdef_f^fZfYXf[f]ge333prVd4Ad^;sgu` 
3 #s M tAt<V&rdDg}
^z` VWq^gEdTg_}
}goE `tr	 	t}d8 W<yt@Dou
`PfUf]3
t縅 `$u Ó' e.;Gt ._
u fg6$+' +k!$PIR    A@>` a b c  T 	AhU    i 0 5F0j h`3. W wp
_ϊͻ 
p aVWOS;pPt[1
 [_^W3`  Qup t`GYh /#_QV.O ۍ6O.O^pj 4cB C QRRRRQQg]\jN tN,3N@j0]$
UQ udQ?jN 3   p4SQ>Nu5߸ôL% Gr!<p3ɸ 
 3Y[ ?SRVi&
NiXCy'_tt# ꬸ>p:
N<t<tG< tp._3^ZBX]V  @Pu P	ir
- `CZQP =c
uhNNN2hÀw*VRރ| 拴  t.?SZ^KS|SSsS ToTP .TBBBX$JJ2J쯊BP@eǛtJ Xu` o SQ V tA&q JZ  C@A u*uP= ]Xruŀ̀2	
 ; (8SQ2<

2ۆT.
$=2rۆqd$<w0
u@ð ~ G0     OU uP0yXd]<te r
ted8D^uaq;RWucffsw T^uq>@<`|h&
yt,ـBt&M1&G&a|f~f`qfLAAAS{+Íu 2fȃtm
 Q ܈$FKuðW B
u	ۍY;wY_uS؀u@u)4  R A  @[fߊ$f
и?f@# BRWS22f0-\r\ u 8s܊[_Z?fQWRfP
t)@r ff  u E8ufXZ_fYP M rI@3@r: t+a
4 v 
th8t	
uY0	g&;t4g&Ct,g&Cf4<vf[a٠}
g&:#PC1	0Wr7fg&F 	f`r!f`Gag&O@` Nb O q,@_f[ûpI2p n Wl C  Ơ #  Ȱ2Ҩtð
%,ppy$zҿtxøa
 jQаwJ	C2<s s	2 9 p20*# 	  {22 	À tN :4
$ 
$0 B$2
ïWWW
XJX}XX Y.Jt'} 蝉<u 2hp:Z h l1qvqs{w;sSt!xUps
2 \"  |  0.D.DS~ `` pY&&D aø0 м Pj ȿ&&E  3Լ{1ˈOQPTP !1XY`.\.T	Ǎ>M.L` `uaa.D`saaQPƌМ`XXɎ6aÌUÿUUUa_  @ȏ "PۑU-pRGw   Ъ*[%	|p`Э God d ", hGa O 
p 7Gr rrs qsq]
sq"  
0q  6r `r	 
B
 1ݣ ` u # $t$?aQh@ & r 3u_.[_3' $?< u@LI<u	.[ ;u<p `H$\   ptu vu	V $
4 q}`S~@ u7`P:<uip UNNN_O Oط0ߴ$#c#jU fJ$MON"ýfdâf>0"uf   > t&r_Vu`v P`of+0vQf׸@bYrfǳ]A$Xm>uIfs@e
f60 utrr<> SWAs @o_;_I_2_  M [6`?~  " *;00 *
rB~68y Ay boc  uaU Ë]EU  ʋUuо"*r t
r ff`tJRQW %  dߤ_̺&UY U &E!  &]@ Z`&`  u(<sW.__.0"_2CP0=Xs$`Q[Pru..&+.	pv[ @ t^P.&u @ u42..
t _wPUU*P*о&u XY`-3P A3.{G@
X԰PZ *.ZrWȎZZ_Q aaaaaaabb
bbbb#b%bVS3м.::au0;aK @[^* UFP~a2SF۹ S.CaF[C`N[QF ?tOasF2~ tY@ ø7
 _`  _ ø8g
 d`d@37&Aoۍ`0ԍ7 3`7$ $ccc*c9cLcccc`d$!<!uy!!`& t"&& x<u&  V<t @K!D8t( 2 '2233pqbf>"  tq" P a2ۊ( p ) ǊȊ&)  * 븊-* >+#1 d>,0.- &) r..PR ut;60n6 6 P3
t,=

"=
 
0I5w<t<u FÀ t<\ ` s
Ê& 
<uaw\wWQu& ` u5`!A &
^4~Y6 FF;t2`ee#oeeSaa\"c` \0ba3ac]aR]臷D]E]pj`[\o!a\\N\5\+t\ I|\ZP\ Z|ZeN  N N rQ Q TTQ    U	 Y
 T TWTABC@P Q TR  S TT  U V_ WXUYAZ[\1]^_  <` Ga xb c d!eqf s[[[ZZ[>[Z
mKd^SQfPVF! s^(2۹  0F  +^D!8u^Nf^`[WVQCuKE`T! ؐ!0 w $I^:u:\!u 莵rY[_S  [3gӡJW.@h4`5@p[{ R {E~}uߵ $
j`&vaTJ0`@faRпHt ;$ot. ȋZ#11)_| #$ЂQ.9.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPRZط@$0<:r*uP}P P߰ H  = r q& fV`:PgfF`XRyZÜt	tv
 vt[0؎ ЍOߋhi3 @ SQN<tt	fP!XfP BnհYˆ_Q4ذi½YQu vY<u,fCISGu%f» f  f P`3.>i .ifPS ~@f.nj
kO[:.njf`ՄuhiZ h"  躄uhUaúB   $sÜ.njuw酰RVP
ۃx 拔 tcPtt>@ KXSx$PzXr$-Qu!$
BB -JJq4HX^ZY[Ϝp
$ q#  3Ҵ./@32ƀnuo n Xp'ðм  N﮸G(xw0r @pt4t op`	k2fUfP5XZ+ f]ffŝf]rPmn SWQ  GЃtуY_!*UÿUUU	  " "yQ+F _SYSID_  Am _UU  fl f@f=  uf3p fl P3Ҏx ȫAZ]                                                                                                                                                                                                                                                                                                        
E    S   _ -%  DX' p Jā݁2L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.JZr# Mu 6Jr pt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF ô	 q`E	 ӥ/2	r@e		p'^F&?s  s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	ffPEEabgVfQSjof[fA1fY^f& u#f&GP Wfu   4WfZfXP'F#~r .>׀t7  /{r?`. t8 w t t  2SrV ʀs`,J	p J~t$` t u/~ǉ~ %"NV 1	s^Í6K.|uL>R..J`>J .:UtaJaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w)[Y_0? tl>ـ?r.u|
_ Ѐ ʋ.E~;v j'fVfv`$dD @؊̿f
@NP.eXfa ȋP	rs$
2

	fX!9
dDfUv]f^PRWB@    ZXRPXuUW:>_]s*r  ZP$< - r!Pߨ@Xup>qw @<@0P  *sXXty>Wc * BQ	?Q	߸ QV  PRW> P@   XFrr#r^rT:rOt :DvL*Dȱ f umfm4
u
rPbl
u2 VWrd [_^ q QP&:Ev&M!&*E9aVBoCo<@,rFAnr;A@uQBu< r
tr&tptu
ZB\r rR$!Xt2߁4 uu@uu`  u2&fPS |`00v[fXPSpsoq`D
>X`?D<PƋ4a`t a1t!$!"条q1&2PQȎ`SJr#SMwO "t 
`P2:Tt
a YXuOkuQ,9a"   <s& ? `P93 >K}uǀ   Jt| JJVW_<uW<
uuFw ><@g2<t.$S[M[|u|
`g|`it\_^FS`}w
u}	 !.b>܀}@a`pO1uD}a1 #%D0QV 3߬+^YD$fރfA~ff?ffJf\c
bPZ#f F PXpZfP~Đ=r0&pw)Efpu fau}Cu~s3SV|wt` t t
^[PfQ
 0 < @f	t
` vka f`ffafGߒfg$Prf  pqHff#f+ִ f;wfg 3g&Sg&c
uff+fX撝faf6SR	Z=>$pfP躑~qffX0ORBZruAZr
|gQ2ǜpXZ[fW|bt~b u:
rrw`U~a `B Ua p 0`cQSQVf1֙fiѥU@P U   ^Y[+u(PUFP @| ^	u<Vf
Eo 0QpLP	r=^ uS@]#^[u"X
 ! P ^~u.t Uj@w`V	_L
 B8`.
u&*P,uχ#_>SfQfV `@Ł=Ut<*MPThZ &Ep` `&ufރÁP  \f^fYfalSUh &]S^ ] $!&@&D0DV& fȡ\AL
^rPfWދ@VЎ & f`t@jLʃe^0 ݤP P&t_ 'f='+a¡f;MPE   Wf.ޒ	Zg&G_ǃE!#3crYR-uTf.ޒQ,f_utf`@]StQY fLOfpy,  !fPv H4f# ,;!`U
UEG &E"r@ifa{Ñ 'rnOGw{|P_@0 `n~ %؎`1#w裊 \0<t+Q 脊Y<%H
fu f` N` p?t{ Yp6.WM"fxNf.ޒg
袩7 -""#:qOOP9D	rQ99: Lxp;.9r()u zD>(uf.ޒp @- r=b*VQ$T$D
 V?&Ta<^3Csry9
lY^BG0 ~50L80o"B1EvfL *(A=D`s(d8PVWPW@NTP
DP EDLDra
fMt]LJWAM ;?f: vM^_OTrNe?:YffWfQ@Q4T=M
e UL`L@BLR G>`G^WXVyXPVFPW)G@(WPcWV+t	P& 	3

5O`f$Op%UOaaoؾ:!P	Qơb;`#SS(SQ@q	)UfhR`e_W3na  {Dku_1nhQfhhVhphgpmN`rpPjYj|t= YXi,`{Am
1$pf[iPQR Bȣu J|Ci uTf`0D 3fft; ``Qf3|Y,6i5 !ZݥTc/s@ Pk_X1Y@ 0 qmP0`pЭRW`R3pfˎۍq:W	?rf+_`SfW.ܘuO!˵f g&$f ɋ? `2ۨu<@tĀut.l˸_ f_[Q
! YQ 8  ` PRS%` +ð ;w["l SRW*׿OзIr 2 p3_pQ,{AsN Y rO:=3ɐ!RQWSP b	$`X Q쨀tY͝l !`@ sX Jt	uRX( V_m 7	XAP)[_YZ@2<UuX
8
DYJ܊Bǃ   brT
!uAP [ 2
XS@
u	 蟅 ت *ê臅[XVWQPuDt!WQ:t`
Tu8v
Y_PY_XY_^ _SM_ PPQ_DMI_ ,+  #9%  2XPUv F t	F !Ff]X"X?
W8 A t" i &g +  pa
u
fN@  ]ϰ?2ðq  S\8@&G &GPиG [ W!@   栊@@\&\p 0F0 ]
..c3 и( и-  2P
C@@ XWP/<w3t u*p O $9F& V._@P X^2$31     R`۳4!fb ufQ8fYgBW[z<Ȏ3]Ou r 2	fPS=Au@u;Áp u39 u+ f?wufP@u BXu
_ffP`I< tXI%[a{At{N#|S{[_ k@Q  ~{%{ o{KVǠ !qO D{E{9{_{Q   A,j{opYxRfW. um3hff=SCAFtViG t fff kWuf(#3tfPf[fXPZ"O_32_p9 x
` tODu (Ӽ$
豼`,a蛼ô%葼´+蝼} PKп}Jt*w ug$t0Z$< ȋKf`~a
%D	7	 %` +!$fa rυ<
%	*P' @[TO xOy^ ere$DIs}L:  h                                                               0   RDS@    aO IYOO L vPQF 0 .p	˸` q && f"ꊦ  ~f3 f f@i.<f.:p >` 6a m !.P wf."U"""" ! a
#
P" f3xgf+С f`ffWgf{#Eg ٠^`ܺA vT2gfޠgƃg u	f@w1  @f@f_gf1 gfgf0	arfQ@;gg&ofG7~;wf+fa f7gggfb	fפP#f}ɰfa
t@@P	3:
y
ff0
gf3  P
@r@
A
@  gfo3fS̓ Š΃wff#b ffyZ?'wf3f30n,߃;w#`4ܼbf[gf߷ p2
fOfP	c	

fAAXAPۂ
P#W!fكs À +SfVQp g46fFC3YQ  Y`@.f^\ g&{GCffTp[PfVfWQfR
/ШY__f^RWf;rf`Ȁ u0s?'1 t-r(@tD<u u P faUQ	U F @ E] < t<t
<t Uq`Y]p4 RPQRbfv2 0q ^~qRZYXɓ	pr3`	x tt -  t	  i09`Kr=s  "~#@@Np18P,Nff3u
P t  f3g RrfF!b"XtԳ$PPTff`U^Ɓo3&fPeQXYqo)YaP'у` koP!8 #	]of<t`L< u#f$!6oA<oPtofaáPf䠄t"
桰   u$! !tp &k Xa{{ݯ *qݰ Js@P}FF
]X `j . j v
)Mf.N. utI4~r@5p3؊^)tuw t&Du .⭋^^;ZIaϠ~@t&ڃã.^2Ȏߊڀ36t6^2. @ PSFg
t'.:t	tX._[X`PG
Xu!P<<Xu @P/t1a`
  P?3@C3aP2Xr-s(@r3H rr
 rR VvF\r:Gs5&DC Hrfڋy苡_FÉF(t S^$:u [r
F&F$%&=vHH&
D0&du rcwu
:	A	πϠt&D@B êĪǪoAT0	VcH UrpUsʁ `-su fqt
E$՗Eab&G )
V oNh8Kr>u rG Po3F) r\ {r=H r8QWss#

Rr
3 s@÷M1 |#km##'F("r#謲Qlr@rk20!0p ×!r"!F( Q'&d&K}0#V&Ơf)&t N.QSWf`ŀu/ r)v{!ufPs BfXtā_[Y`<t;f3f t	f !u
utǳЮ`f[`
 3 P  phf<	8PO W校F X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (@$3'E&f$`
ĢF f%R$PG ;B(FGq1ø fF" PXN8NwN 4o2N?0(`00sO/ mlpR
 r
fQmru$fY_b/++U+Ñ^ &u b%tr_q? VQB  BY^	G $s
3
P&u3` @
r
%uèt?àt <q66V&T߀Еߠup 
*&u^ô  ǁ  QPXuN%&:Lr * r$ P @uP<ut.@ ;& ; E q2s2p$<@t22P !$!$qX{w [|[ĺ"~.Pù[K<P~  = sffP SQ  !臅Y[$p
 F H 
۰N8tSFt f% f @f tU0    ";   t0@bqP@fX
PRV s Zn!
J
8
0
$۶g4 Nff`4eA fu4fafFDP2`a  tfFP ۈ^DPm fp]fWzf=`3#"fF$QiF,0 As{rBrf-1fv,v0h,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3f1	 f p N xfր َ pp#f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	ffvAfI )Bwf*ݸfwf
fAN
Xff%	G,fA d!`
;Vt
f5AP
Q
ĳ6"  f%" f%  @"	 "f'F0002KFR) ~!.PSQR30? 藁ff%fZYnPQRWSӶ3t"X  >
蓁[_ZYXS[  QW 
߀@` _Y[Fpû z
  5u
 @ @Üu8 0 R ;Pa@ F4;@H0(P ߈>%;5 N0Mt(BR'9ETDHP ~ SIMPLOiMOTOROLAVP_dVS\~ЎH}dE/ۇP-s@^s˻ >(/h>*/ݐ ,/﷡ ./˰0/@2/hSR &-&Z[>4/6/﷟菢;/W ;0 t
y@~Ph+؋Ò~c8/R@	=/I	?/@`
A/﷩7 C/. V/w%h؎&3&M<St<Mt6 6 
6^V#cOɌ ĭ*og>q sy upwjg@y^gy{=}4)B}_f> U ܰU@RR+ 
r)>j/&~X^ádUY?t@̋ r.])`^%% +zor.f%0[ P UCESsjfr 3 1f!u%f#f P}	s`t_ s``u q`VQaff#boдP|OrfⱇfVRQ<t2f3Cr6@n
+flu g> ttr(A2p uPYfZf[f^ZPfR53t?t! r2-fZz u8_-t(mr?!f1@bt

J?t:R!4g&? t0cQfR8t , tu
@u$2Hp)@t'@u''*tp(t
 /!-  t> `Au2B[ϲ a33q 
t@  ct}GXri/p/B/RZ/rGU/Z3۷À@譧$߻
Ê ,蝧$?t P謧 Z
fVQ! 0fF,Yf^PS0Zap  ?[@;$BoQ2#2@$
	  w mS4fX 	ش  [ò}fV~W` _ W
t<5t^fи+r0f}^{p5QRVPû  f FKYf J8u^ZYfVW7  5)EP2q VD@t0	_f^f@ fl  =  up fl >@t@&?   ZYfXj3ɍ6J.Lu.:Ls&3.D}.L~s` 2`r2.`Vs QP u K߃^t
`3t t
t
u! 3ү u Iú t>K.|` .K u} P J}uL   u3}puv`bW_tURQRUK2YZ6	u>^
 .D t+ t#VL^ 
.L ]yÅQ3| Ys. u&	 t	&Uu" ώǍ>M |  Êö.f.|f@  3.|4߿M\PQW 3ۍJ#_,`Jp1(p  `3菢$_蘢<`ht+aP`)}
t 	
t>J .:UǀV tMRZJ| $p$u$$<t} ^^Q3䆊!*Vh K| ^t
.uu
cs)t!vR@ ۵u3ێێZ
t	'u
u
0NouP@s+XPt [%ڰ`mHz︝jt"Ĩ@t  p 
 I XPJXSPOߎ .+. s#. sXP辠&   &X[ó5P϶'->@/HAC  I@ σD
0j@ t%v v t ArMv .sN-f-p̡&A F'N- aύ6& @	 !
 ar ^	
F (|r
 	u뿋^'Ât %轲1+	d1*515r0/5Mrr[o[
u< r<0s<"N@PQN \
󧐡
' 
$nvf<0rw
sP݈Í>Pu.
I.
MȎ.}Aj@&u |t
  ^!N%V#~FpS2 rr20sus6< s
	OtE""Lt*$Ot"#Ot}%" 2!)A
 ؀	.EFC
r]wsmsߴ1I9  <$u2 *<}#"< u<@v<%p!2 Æ ]
F!UF%` ËF4~}R=r&@mvP8fRF'P^S^!S&EF'f&U&]rQ[P@ [þsSQtP^Ë^6K	Arf;	DE⻀~(LuTMsPf}3fXr1Q}K.  .GTAf f "./p 3V#:Ttv<~'t9~0l졂EE߀&Kq<D_D@ % 5I$~~6K06u0&Mf.Kf&]f&} 
0'Qf* pr}讵rxLt=rl`x5rdPtZ+ٿcr@ H u~ (um-VƎދo^@tffmݵru蠡Yr)8r$耵rre	rj蟵P_TPQX rpw
u s`WBt:ـ?f.EfffAUffsP-EMF F
tSuNffaVK0WP*f8f'w*f'F'*2t*܊f
Vv~Vv 4_ٰFsQU n E]YRPXtUW:>_]s#r  1!ZRP`2B@ ހ ZXюً 0oRBn`SQRQK0% [ĳ m!{h謀 Bt Z^N軳rot
r`a r}[v">K fKf K, 3S5<s-KO8L9" >KG<}P#<Q$@ d}KZY[PQX h   trzvru3rij`wNrWu
p`dع 
!r.Ǵʷ%a@tt t	tCHa% su~rt	 2PPRZF sH<t<)t<(u;ь>A u/WU>ӽ`x]_{3r0Cy q`_^a'c`&PSR 2_ZPÉRFtN+P X7D	F
+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFF  f[fQ
tW 8vNC؈^~nNfnNfˈNnfNn"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP FfCF VvuKQfXr+ʯtðP@Pώ3 G& tff   Rf+IYÀLzuu$`Ύk2t
.q^G fF! PXG t<"u<"tlV3޾x 4Q&?s0  s& p  &Gu` ` G@w`  в&O &O`uR~p`f&G`TPa  AWQb bҵ  Wsa*,ZX7RQVW:WtNᒀuuw .!6a u/AŠ ?L	
? t,{6pNoAOGA&&d&D&t&D3p;_^VQ
} " uRPK
  ^   @ deTPQ@RP?  4
W j <
1BQRs3ɺ軓Opl.
X `.afV`f  
u 	rpoCr" s  y6	pA}Caf^U`@*ǿ2$ԉNT@׎ǯ~WF$
&FG &U_@
	 `CaW  cc t2_R Z؀ˀ$0ZP` pbЊt
    { {o Ab EpȎغf  T `333ۺI u؟F;D ݀u	p66u߀u%2#p &ւ,ڡ	ҥ	Ɛo
`
	끎hS$ ![ ^L2Or$< f~f	R  0d ap0ff#f' \אf@1f.4 tff                                   0ߎؾ +>۹&  =6a Á.6ͻ0#RRRCFf3۰S8k"fV$
Ѐ
tfP`Tw"T4%ffrP`WfV@f  {gtgPGffpb fExf o  L	g R#f^f_@AWn ]^!Uf`g t/ou (}}$
[}ô$Q}g}G}faRVМ۶P}[C}$t?^Pf` u'Pt| $|p }$|fa2tQR3Ɇ_!ёw 0JB<t"<t$PAJBqpvB(C)Copyright Comp{aqr uter rporation 1982-2000-All s reserved.*578F'()+3457~ u v5u t
&  {x_t^t]t\7utF5R3< v
<ar5<{s1$PɎ~|Xu2o`r yհѾhƆr9_2.:hkq G$!u@t0<zw,  
tզ

	t
w
 thb2]hRSJ, E ?G@2q)Pı?
   tr0r	
2vPQ5s	} uU	gEHHP  IPRuaa@uXXZXp! / *WP߄X@ŻÜ= srqts
0{ _ ߸^ c~Qwt.荈 ! !$= 01QjQb;˂QN 3۸ K PU'  A G y   y " ËEup
$prq`QGWǿ  d_qa(    K P3@σ0W%w,.s 8 fg&'fA X= X_f@`$<t'<t#<t?N< ucX TYM_ Hް<u 5  %~\l  
 aS W#XAVW3xu@ G	Ou1ҁW W@ٲ%WV 1 S!؀ WX#_Wi"kR$	ppquV.A u ȵH"$tu!2$qQ  ~pVD	0Wgg
BuBf߄CCpCC*r@0 *UUUU%17   6  IG F"6! ,@`b k g}
3gE
 t "6JD  [gu0ARsU I2JJ  
$&&E&]&E[
3@E   F˽	>>]>
P `  fV`@ ބuZ{~{t u3N@f6 V]{u^ uX{u?,{@׿N`R\p Sh{tE {uzQ u{t!;{vi
6  
]]f^eU  	    @  pVaG$ $  GN N P P  Gh h"Gt1$  G   
G   s$Ф  U  0    %)^r 4鏂QTKKU  Mv&Qa fWJ.}
u.:tL u% t>JrSK.[t K.o[u t	t_M_`EfUv"v t Ar Mw ű.V PXF
Xf]h@ &A ϴ2j@!Q nru\0V
	=VK.6# .t.I.
Lj@s&  |0u{ 
^SV#؁D.d.$ʋд_^[>	ã3j0rc߁Ot` 	OtOtLtDKt
KtKtK

1u	.<.}h ;$ BÁUu	U SfQR~#G rp
fL\Zfε fP<r|wofDu
 S_RVWUuP&wBrP XK,K>Ϝ齨 ..?>齮@u Pa 3PB &Gݾ&wG $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]r|sa0's@Q`b 
 ff&GfE  A߿ff@! ]SRWP͋޲ }ra$ꢙE艛˿LuR <sfQ@M}3  fYr/>KK.  EGώǿM ./17p;[Ü}͝_Z[.> tG0Fr=N.EP .&K>J@A%50ɚ @ٍَ6K CSRt5ËfQfS.q&Gf.Kf&_f&_ - f[fY2PZ[fUfBSsQS)}f]Ê$uqﴀKݸsء NS3ێۻr?4ðPt W6 E1*_Q{PX2%T?{ u!pXuO߿<2{f]
 N] d `5dPQ3 27y4rdr
` r`f oϰ4pF{ )oð4@   K SQuP $@X߀u@A_Xe$Htu
߂I4
<RVWf1.1Vtfz1{ c'{iQ<V@jV<WjU   PT `HafP >} f 6s >upzƿf2>f@Jzf0dzzOtzf .> uz &R"quk`a ߊ؀ a@ u
_^Z| s x_@V_-oؾ`;\>, KrЧ" u !eQ3rN[U  r.]za /  ob#f&
!@BѤK K(K'`1`O"bji~5%߄d%D		&`fW2sA< uf,u#ǉp f3gf&ff=SCAF2 f_U< 
<! F ]  q<w&< t'V3ɊȈCF`[  ^ t	  SQRVV<v^.
t"A_ ؋B%^ZpZ2 4 ]dmUP XsB Ou]ÿ|l|l%A fr%! 7!?%;! g |lff뙡"%{ %u%/g%#|l"f()%QrAt1S.[$1 t@t=4@"2ɵ"#Y8 .6,s\豽&D
V &DtH @ 
B Fr!0rnsuľF. u豾/$褾rO菿sJ)ʊKZ S达rr
r{;a?yoiZ2
 0
FFt N fF" B@ BF(	r2BB2ۀ~ `{  t3ҸK3 ;wu;sb߉FVFF"PҺ F)tа r4F$
Ft+ F P  !VPX_V@" aWPR u	ZX ?PRA쿨tZX& * p6.:f tdu .f] gu
#p d+}PfdfBd)! s dMd5g}d0ø J V9+dP <d;]ttdd]=  R 3
' '迿 FǠ  F/3 .;v+GuBG
`F/ {@ Ë% 	pXvNuQ
 	0ʕ NY%_'
r0123456789ABCDEFS@ۻ׆[`tfPS^ۋ^&t` $ueG&uFtt[fX]逳( o?~~~~l|8 8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~pq Q pp		 0``00$ff$
0xx00 0 lllll  l 0|x0f 8l8vv ``0```0 @  <7<f0 0  || 0p0  x8` <l 8`p  x@ |pH `a
 
|x  ff|ff ll bhxhb `gf> @p x p
pflxlf bf  ΀ 8ll8` xxp$ x;0  Px ƌ2 xp``x}  xa"cx -701x|``Z pt 8l`0
@v!`lvf0 x [ `b    ! vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
!ґ u!=`f SvN .Y2[]`g i &  _
ld@að
 `
R3҄u  t a TŇAE eMA9Y.nSS<  wAb( p
`3ҴqĀu N <tDZQY
 Ir8r502:6 v&Z a U$PMM l PCI01 ISA#+T DH03COMPAQꊙ 04/13/05  :     F10_  m؎g ЋH_g+3f  3m L!$F10fPfSfQfRfVfWUfUCES>"c  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdfe	 3ua 6d< tf3
@d>Sd  0 g>0;e `ef3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>Jf t
	RC &JffXf^PVW 3W __t
r
>
d_^X \ɰޯ۾ݷاб?m,c-DD(|1 8     I50  ``6~ "k!A8>8  B9 @'Yar:  @;@?i<@ &3?$	?	I!!
0T!A>q

( )))**LLH#Eo$$E~B ~B
y$$$@ $
  >""ZFYdld  #<r sM` hx"'y(PQ<R!2

	" g %8 0 pV	

$$D81 dZI 
!e$F   A4'?((DD@%)0P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInI`Fڏڍ׌߃Os\gpjځBȉymGł񂪓rݏOڕKvxmȂ튮xtԍÃ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉE십ċNԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb - @t  ސS   0 ` R 	iy D  Q @' 'D ?'@$C" 
 P '1!!#"& pc
~|u m ?0
Fq% pt? ߘ  ! x % )  Ef	! ( 02 S   `00m) BFLXp0@t  0dEg!<"F p0lpY.$`"08 D(#ds$A|   UP W F  >"6>?0-@  ޣ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@@@a!!: ' ( <'Bft,?0<<` *0`  x?qt2pC Bg ? @~00 H$@"@ 
	`0 P $&# DK8 o &  | D~D D<  B f<,$$0$l=   M@ 3` B?"#!O!  8@ `: 	4H 8	  6 a@)1p?pp" `$!3pHBQ0@S` P0ZT@L@\D2"##(RY@>B&Z" Nk=bN@-A |a  %rm  2c Q " $!2xa2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxx0a1 
c
AZxAp0!
g
  p!rE  @>>@@`)X0$x|pTT? T8PcCQa- : Db0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{ijv+ dDs?|e0v0a !"s 6`S!cS,t. T8$9`0opGy 4g @ dt>$B<' @}""" c px% `\vdnIi&0WP?v3$fv$d
  ]@^@.*  @#2Bb"6T$-`0|p(x3 OV@@k` F0Vpq]@ 0ua4`m|sGXm|%o38"5U QHU' &@'a! 3?! @( !d(!3#\2b" '?1`		
	`21"`n{9$i$	$	`  "33a0k' l?HzM8 0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!## DEB`@].A^! ^nxRK)t ?` ?0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P< { b <$  '  |D!  D|? d%4 >!d??$C @ 1bp#1{8 < ~ < a   <$$$= ??d)),??4+fIAp'0p6( g!}@ @Fq?6pբǀ66@ƀy9@0ya؈  >`%,#?% p$'!G@x pwc 1$&? l@ 2?$?$?b S< @$<b _=$! <`0b64~
*  hH"e g * ~  <@ {D=a<$" AL`5' '-恴pp^  ) 
8hRF qpà2q2DRD" T@""z" ""s,bn0 CF`  ||~ ނIE`<?aBzd, %}IHT! 㡬aeE@AjD0p 
 .:23V!& ~   B5I@  `2"R`   @!  0`'|Cd p5D ( H ʐH  0
DP6Oe  /$?$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c?2`."b4'?e +"@P,  b
WBF0L 02?$&""  0p	 x 	#`4 c$}R S SPpP !
a(#?@@DDD@"D0τ!c 7=E u0DL|(0<t ` O='4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Rydws7  H 4?b2C"cyH@QnMx<0	`Z8 ̀7( (`C2)v&^N?0JbW8l>/&23
b21#n0  ~!#$ #L`,!3p$?Aq%$"h| "  1  A q }    &o <"rV&#0 I  81 c QQR0S"PC 8`A a ˀ4 usn# 8ٳBY 
 Pw]IYf   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,?=%$>ǒ)jP|D52D"DvDTDD6 # a|b,ހ  1рp#\  7ajė=  4a8	  6 P>tTڅ  ptL D@~@Bf$,892Ok&arg@eP 1 WpxPX	 ^x! 3"&,0@J[D% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`6U0` . `09H~ ܁ց 	 d~@_*H  ~K6cNCc48x F?~!BC  G#" e `QP060o!  8!` "***" /"$'$&*"$"? CJ0``]0?~$BdB  a B
BB~15,"&D$(-jB ,!.	,HO
 =I H<H$H$I$=Շ@ @v 4R$ze bU?S R P|7 8y0 ;6@
bPgA[aq! 3 ?$$$5d$Dd<? ~   ݀Z  $D$y= *XGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? {? pw 0,0  ""bp $ & "9  q?2@G_
i-_ nF:@e$  a  @
#]](00]V?$P?			?R" N8S8

 ek| 0@	! y g	 	 ! ~o>""	& u">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDT C
$>?  '$!$34, g A#A <8S`hO `&#f!~b6@2~Z*\*jI0 Bn5	G x RRptF H0	 ;   	  a |$# '!!b[aa{ap 2zasR0A: <  B F>lxPXHL0Fw`Cu@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs	"`7 `C  `rL(  fMQp" "7>a}>>b 2 "&"cb@	"00P oG  A` xz   Vj_<@` <1p0?O3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"gb>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8_<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~B$fiBFD0@ @`@.AY`M`  I2R2RR 0Bb.	o4d0.t ""p bBƿ ?}~b
(LA0%ɧgUE``AC}}8@Tl@l$5?b5d >qcQ"tdaxR4䣄	(	)	) ( )H	p ^c 5] 1 aA#?~"! "2&460baÀ0"` @"{D1 X8|@ @0 P` !bF! ~°?(HD>!"? |?" p?.a ee   	 `p13_"fd Bi|"@Acp>@$	,	(	88(2l"FfV@@`'$pzBp03
D(zo

@ 
{t~<$4 7 a  p ߬}#@B"4&0PPP`@   p   uUp cuU`  U`	 e`0 ..d1S.b1lp `1  [<u.d1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.Z1` a2P SP!bRV^Zu
`R\ts 2ƃǡ G
}a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F¹. u 2 󥪪4.>i1u . 2 13 `.Z1&1 u2CQ2P Y*2Ȱ&P} aj RDr
.j1.k1PSR  && Z[X ` Op@kp
oo.6W1FF!.WtOT_G-p
QR.6`1ʊP ZY[]X  \"2S2OsP2 sP
XÃ <r<0 <rp1@l1  n1.&@E0u'2!n13[!a01.>ߔ1P20X2$CFAPQRW ((_ZYX. 2.9 t.l_1BA	#+D<uo<RaN<P<S<0<{<<<<`< T<@<.>f1 t3ػ@ .d1G.f11O#0.d1.f1pd`X@Y 0..1.ό10;Pp2  X:XUFN
ȋNu	F] S܁ f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M 
> tj6hejF_c&  hEWHu->uRIW1o1c% = ۫ۘ2?g	@Wv	#B$s
|
qJAfaffпfG
NcӜcm!
fw>
dQjut$Q1`	j	c	)	A	
WRaUUf	_b	E
E>rCh	
=eH%'}SF _"4UcیB *+6+RRg"-uRUi//X"	~T
!72y#B
z&-%7x6='{FM)!ct;j9;~;0rs=9qA"cjQd$ QA
fh  nb@B1 tAt=dtfh jnd$d.C
dtfhL   >tShet3 tE>R5jhRdfjhI2>c t%j hc1t2>e tefh| 	f t+f *$!f3f
0č~f PFPh|@Uhf"7 WQh/!3׉F``H[(=#2hd[h dŁ<od V05&	he,ƀ)BoFy_g
g4	xAzfcMKfc2CBha7FP7@ pljh!pV
	~`#eh!fBHz8YIhRh]c,@kW]c@
OY05%hK01!4 V )F!!*hmhTkO	PBD	Br	Tq	^_ !2FFTf^ F&<
uI) u&*_&8hftFFP9 1FOuÀٹ F FIuF)1 F*+҉FV2g+;u;uà3g% ;Fu	;V@á2gG2@4A996g%_ 
Ð7L*	6
{ WPP@Bj'@,\ f f`/2gc/ &a&cjLfPAj FPfj h

R苦[]P"1V=ut_ V%#.
GF|ǯ  02 S|W, h & F GP	FNuFG0:?7 
[yO4(H!F  a(qtFҴ
v2  1p jvr>2aI*bf?һ3@6#nq_r	v	$J2&ߩc% 1Wc o)ZU

92aFPmu+&c53q?3ȉ`Z	/cpaժb`ʛ	2&a% +1a1_aj_R{3p%[2cw%  c10KjA; 	a
Ft2`h~ Ѕ3cjD
 E

C @	HP 	Na(g<	3ɳ1 jiTX 
ȢT(jS"
 U@(cj~a'&ccRXѮx2UWt1:	ar$p_Ft@c t#!yV*@z"ƣrP)c*A{#&c/cjTtrA (qAc@w _&w@8 +?OБ<"_& &O g[ 1	߁j_ RdƫW 1hfK
a wfp'od t}JRAH=?A?a  p^PpF2g^F  ^F&F~
r
,e?&"e &h` &d^߀gP@ f~@ c?Rde  e# r6GD ΁*pU`E  p  V6а^aF@tp)t_d Z*tT*uN&,e"e he 2,9ʀtp"Pkt ߃ Ѡhew@tO
_duUA&`{2 $_&0d&  (!og*d!r΀&d"cŴ7ofitD@.Fw10   &dw.j j  3
vB %#rSzFГzp_
(,_B&f"&
g &fav5&{ +&C!&u)&Ƈfd rp |ehJg%  M"9cAKx@K 9de߀&eeA_FVD.A_fc0}2ae4d	s$6B8aT :K<]c6rvqS0u`,de شeeOF핺)@t#yZj$	>jgZ	Ձ de$ <w u @<@/u""r1=` 1 e a(94>14!f@4G(v!XeA0 }P
t%rc̋F^Nr'~#tp  u^    %  + P`ߠ)^`  ~u +ËFV VF6Ƃ6~ r~t` q~uFCfv
0V32,pIuquSIXX[t

 ^F^ApaظL~  f#} FB F~P|v^ KF{ NFFߌV~ PHt@HtcH} P )npg0謁6^F&? u <cvA8>sd|mhxcΐQ$RacV;a%.cvm.cm`
NNFpev!q齼$Fq*?gFF R?g_S^ޠ|/GFPv4AvF?gFmPQ1coaPa?:!Z`dB_&@0Uc16`b`~2|FtFr(QW^
4~`4	b-/ _`-P+FVFQC94%~ t;׍F4FҔ0
z u WV~vN^?>S
A0@
^_C
"jY(c
l`


[t ,md(|WVvԋNshODRHAA~(|W~FIt_~@u"2F#}HFB^F&W} 
 
.APU!u<@## KVkDiaҶ
%%		 	F*Pg	}`	
 g<d-UWVv<~P F
&wGFq&'h*V~ʋv!^PFߊGIub: ^&^&8t@#^^}۲h!#ù
 0GF N% }p,-Ar  ~s԰ NFN+;u0g03ɋFpPAFC&PfSp  ~0gЋs;G^AaQFp ~
vД@x|r
CVV,GV~^&FIa&a82jaFQ2Wc%0b>"⻐Ikbf?BN3a3#b1!
= r	v	$
a2 %k 59b
oB`*PV_#?j`2#	2&_a% 82o!2c% 2c1/cjA2OpϪ 	a2/! (!Q023ޓcjDEӮ
	C@H
p

Ns#ST
	 U4	@g
31 jiMQ,pyXr~y*z{	@*	{	[ʧx;(' &ccf`f   df	 ke 0 g .fcm؃[2@B T Kc]cFr	c`6y Vi@a1FRc4CS0B3~Qt8R kߑߺˣ>j6hhLjFc NUPe:]>"b]Ic	?@#c,S UƢ$+"9WoyT3E\A	}j`faf	ff؃'fcPXAz@ VA V\a$CZDxUE$
C4
?
_HH_ 2
NBUac۷B %5q'SpF _"4ɂgPL2i)p+~0PzryL^2	zB
xB&{
q;;9Fֱ .Bjh!Xa۰SWVvЋދ~ &F<t<w
brTF*;a}7A~y~tF&8tFu|t<r2$VP^Ʀu	A(|NÐ ~Pfh#  PF;rF f?* F  F*N*ȁ vFܾP0џ"v`Q
u+eTf^F  FOu)	fdf &dfwctmfq0  R*&3g@w2`% 2g14gȾu84= +N32g33 Љ  u6g$<u~6g% bpu&7u]f2 % DP	u><uB )
u/,au#aڲ68g#FOr dTfUfVf WfXf	YfZf[f
\f]f^f_f`f_afbf XaLʶ f3 f  Ψ9H_ujvRPp- H_{FB~2|ۿ1~ĠF  p ~ uFdm
 e jtWV@H_FRvKzF@ b*J*p
NvQWV詑qFFP
|Fo؊f- oh h
~'F܊f Kh F֊ft@ t؉FjRvvlh 0-~St` su P0M2muhLh @h߀ FފfPw~sFf KjuM!v:;F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~Ƌvoƹڰ\؊GFASƦư {|^`ഌ 'pORQ0AaPjs, *`
- ek)@@@ NV$Y^p|"[([> [<1[劆2d$0   yq$mj)!fP4
CeeQ A2gu u fЙ`EŕՉ6*qV+- t*-} t9K4!1)3o$RFa+2 OEOboLrЁF 40#"7g
1-1  GEBr{/ 3|
/@+F+PRquH6pd qa"$2@d%໪c2g2 ka`a1jLFPA> j)"#2#"#	
1#C/]LDE@WV3 WD\^&@RFG|吋3x96+ 2 R& FW1<` r<"JW>
d ێRݖda~a6  &=  t@M[_  Ft  
V"Tf#-/(/

	
@yu	( L &O&TЦVP{S~ t'jF I  t/ u#'jfyq`t= tA:?@>u
,e&he""e2hwe% 0he  t&,ep1`ul À&l yfdxkf egfeee{e>gdaPaQadĪrdհ>u[h hJ퐔h Z^âp:h@jBz肪uhR 	[z"		N	
A
ސ4!F* FLF`Z  @AL62X 19Mpb$< w6rud" rAԀ>dt"߾a`&ca
uc"&c	Oʀ>rd uzfh  a  {PB@card,c
\!F$ !J=
u< cp3Iupv tŢtrt$Btt`Ra3+&?(u"&Rup )u&GPGP됽F^ u
 启fj
 0 	{   (D.~  / u p݀&cEF`U>~ tf Dj j P P= HtVjP M-
 -!/봐> ~ H	둺;	~p	9	߃>	aQ@6ưRĴ &@uO3pTyl  	¿&&G&W鱻lp[D"   s- ;t- t- te= M-H- -యD@ ++fjsg ? ;@g~p oJ_p "f vV>   vVP*AF^ VP% 
P h
 h  yRaNF
+F@pF!vvo`	FJ_NnQF@`{vj qCFPNQ=`*P!ؑ`VW  ް 3_^a #J_%A  S!F
FJfF.
%
_;F|!% F@P!]aVv р`NcF&< t&@A0FAu
 )F~u<  tFF7 PF@50
 f=#4@@*`P>~v*VA ;Г2*1 ufU  Vn֠']`!> tur3NFAY F~Nَ&8tGr vNً! ؉^GF
&Ftw^ G f +tp
뎐V^% = @ʃ@A3t`߰ߋ@!A;?w">
 u31&A *;t{r1A 
*/F0 F
t t" 0`fp
V=O:`2P.B@A͟?Vu	.SEHDa!E'(E02rVu`5 3
l	Sd7RP3>>Q XZB~38tC8 u31~^
AF9G
u݋N3~({~ q  F;|Ԁ;pUƄ  ߸fUVNVv<%tF` u DD^ù
00NÈ u0+1WRP MX ]V^tQrJ;v~ F^F&uF$=IW\qQb]R}   P+΋э8sYdvva!VpN&8 uN&=w t&@*A|a0&1tP߱+ G0 !
`f/+IQ kqCTNi
ʐ kj ##vAD_
&F3v~Bv0JQ&ğP0zb;~ANuv 0dFa 
feP{0VV -cPQP F ~ ~
~h3ҋ P{W@t4>gPǰv~dPq 	ptGWy5ӽ"p j9FuQ_PK vv#5~@jFV2#0NvD"F9F}+F- P@!b' Iɒq YFF`Y%"{ nT\QPEP@DPAEEP:Ҁ! fh  39> ~jy/0`*9Pu	RA
@0
A/\&7%6%'@2)}
G;|2*& P c`8(F0
A
j Qj V
VRP=AQda'P? WV9< n@]Pac E +FWFVa2#
0UcSpbyf 0aDPdQ虡xQ	5Q`,+Fϙ+Ѡ`M*2 Rg@=D$=ӁF3@**A;}RvsN`V6r1qTyg*@F;ﶋvwP) _4C
sR14+

uK#aQCPSfdD$A84	PeVs輡VB1r~&-24hQR}tYAS;}`=y#DȰdf&D&TfF3F@F~
P  q &Fި@u[] ᐡF{tdF;@]Ɛ]q<ЁN; b®PO;v}vmǑa<GF;F+F-	@pFF&Ev;v~Qm~{ $	;F3F	_F	} t~0V=g~P龐tOC tG\'F
t/* F T9F}\LF ;F~AZM
?~~2G+F50%&L
q DFF 0W  Ϡf@`	PX f@PwF^^UEAgTe l2s|Pѹxb<FA@ o0H&v7QvFvFꎐՍ\Pɒ #R@~ɫU 3'tsF+FJFH鿈fh iR( tT,T4Kv/ .9~4aFek6,+F!}=pu.tPoq &OC@ +σQ._+ǀ
!0|ctj[|񈺈

FDB.=Q oj]>oW0L# ' ۥCA& !!pa2#$QBC}PPCfzfpL@>zf|fj qWw 
Ht8-t-9t- 	t "fޢ 	`!QF~ tfFfzfF  F
Pj   v
u}Ӌ1Aj >PHPV`s
Ϲ&wc¯F/tB$P=
Qи>N	VV2ٓF
t\!@D% QD
莡QӼ
VQ6 B tDu遌Ǡ
!_o؋!bG C pDPk*. H!MbB`tu	 r QSGg	R4O1maiDu(+Huu @uqt j	jfh	m	"	P裲V^FPqf~
 ;t

>axQ-EPzU@: ]FY m DVVjv/vxX= 6G w]3?鲯S002Rr~wFR0BP1q*E~
G jR[807+$ }p  9]te #S#/E=/`a/FFP9B \ dpg
p; ;NNNQP @C7 Ƒ򠽋= K = ;  -Pp---xАWp'Fj  ܩk >f`{ Pi;v1!;vFPVOW>FP~FPG;/~~P1% - D- ߄*-ࠁ#- " e= Pk_'-
|5. G@6- ;sFc?atU^ tP` zFa~9Fu
VVIVF]v9vu@XPNPN  PNNRF ~9~};V 9vu< uN0빋v T` 3P P|p & !VN;
uڐxA^F;~mOaXS `
$~Du6f b;+|qT/QN;v}O;6Vf~ uFgApL怰9v;|GI0Đ0%9F| ~'A^&+^& 'F'302F`g!ihj@vVt ;tto D@gx3|f4Whyl
 rz/~I>FWV  Gc de tWd@ @ l tee
ǫ|tATDr\[u0Y;F~ ZpӁrջN@uOp0
DK=2Np>d u)>e tl>g tt >fc t|c`hb?0N Whp.u"jhahL_ i
j(h!fh^_e?h_ j _h]ch_K _T _}zB _m#L_a%^ !fB"	 e% jes% ]cc%	 KcSz%
 TcC%= Bc3#+=(`+Ͱ(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhoНpt1rt߀DODpU*䊇>AvuA*HWvAPVt0<@p& }554465245rt659hӾ@E@ jpPVCpWV_h
	 !V3j hD	~D$Հ`HtHt#h !x    C wt^ý f	$F~ HtHtHHt$" ^@ $Ѻ&&G<P j 4	G+PX
G>U7x@n ^]aGP0v&ƀ ~RrjV6 fP)3nP Ы>X F`~|֢"®s}vI@x	&8 tr
9GPu   >p~q9	uarf   ^f~ t  |֊FÑ!	eMٮ	L0#	Ka c 	3$0(`(hpa^p3&~/tC&  v&8 u*C_;^|ckÎF^P9P8P`^? tvN~}"v{`<1
ރ~ u0fDFG&9 uԉ~W޴Rr0~F Z= ?-
 -_ Ү<5 1 ;uJ< tCBtZPU-
tKŐtHtL- t<17@t0- tOAJ뛐j*Q`
0 R~D@Fk	 0 v% t" uNj p貁F  Bܲ u
gށ?MN3~*^
7ފ 8&8u	F;|?`̸,Bdnߣ
eP $
Pڋ PPC 
Cc!
d$  *8fudg"^u Q/	tP3_0F |n FPf@
t)f3fn @Hpfh 륐j h0`h` 4$u @3l3 1`F*A;HtϠ5= t	d@ &d鵫 ڑ.dQu鉀&
:	@
ʠ
 &
&
hHhN
ho ?AA7B 
@
@~ -*

@5q&
 3F! "&d&d Jf]jJf!B"  _FP~H AKN
g3a`#U\'"%0$:GBHǿF_^_`^Z0 Tč&Í,W3F
46 x$|d0"dj(Ͼj 9
P8
PPfsOV
b}W&*_)^@&` 0 d t&<
 <)뀖 |x
Q %'@q<`
! Oƙhdj  %VcbN0Pff3	諠_%  P5Ѐ`RB/
?
$/*0/z$c30/04R$R"_RVdDp%W
d
aH*=	- I- 9t7-
 wqrMt%
- Ktq-Mtr` MYnp= d.&FbxB,2@0`  8&_0'ՐR!"Ր^,20` = 0PXu/1V hh ST  9YY݂Yހ
Y&"0Zd +a=	_[Q["
@4z |o
U!@ _d_da0y y Vfh0/h y Pc@t&
 W
@ UACUCCUT΁!#!
@d_d_
Ɛ޾
r4C( + (#~+-+tp*tcmKt
- tu] &3& tGђv 1vh^h
hG P!wuc
j8%A#&A
-C@#'M$'^a'a{Ðj˞؁ yڰ @&
)3bPf w
0>{+>>G>d'>n!>/>f'>< Ћ5GP$pD۫ D:EG489JR4"" :L%9W
5Bδhh͏ V2^Du+! 5 {31;utX&s_S7AuA@A@tR_!P!_!
@>P`O? 6`L.ࡠAL&_P`~<!Q"Q Q*|3ɻm &Ar?hOEӟ@Qup@	{XrQU݀UtD33,i
; YKP`LmrFv!
or0t$Pv0%@txDP!D$mD`
P#wBf~O$x0%YAǑK=D=H=yMP`;Ա;
fhZ " [BGb %^
vtн
]
ct,W*@t>t2q *``(@a@1)@v+AER`ŏ9ƏxCQ # LғƦ $ 򗶨$%0@04p@
%@tDR~2S6V$
2`~R`ҟ8B	S`vuvTUPT	b
A
 05K8$   ڡ	 ̥ڥ .<RZ H1p  AЗc!@] 0S`0uS`}b"뱤Wab 눋R` 2 1 ;5r1p "(9@( f fcEWfh  _!zfcfR`&cN&..@SR56P6e!7U>d>8FF% 9N$NR@fdfAcu
nuvu-du$uu~u	V@V ,ǈ"]|rh,2;䐃voF8FPVh@PwMv_
WVO 
1!X` ^HtHtt-oLV!B+ f@!!b?f>
<¶O13d %\B4S 9@EET'`eE|tG:lEg@C
J
Ŝs( ,f+fF@ ؀  F估F0FFFR\|D>== p ƿ -  -tRp   -ݵ -*t:-`ս {=+-B `-j@Pt}qx$Ht/Ht:HC 6 Pۢ c( !"!13 Rgc" 'ހA
Fy
t)j UPTPfsV,ttp? ;Ґ|a&yBY!Fp *HFL~f fFa^vfvvFPv{ڐ5Fpu63F *~%v슅a _:uFG;ǏF :a~ t
&x |xP ~@W&p! U p!qq t&AÃ@̌?"Ht)3Ã?@A ~pr}b|ɀ&X qpV>X` ucuHj 
&3v0 RhewV`ff\`f ` U| ܄ 9FhDעo R
V`heᠫ3`8-9t- 	t FY`r
  *OXfjj a
#5	1	u.#JN1uh Ɛ>` tu!fh  PZ	-NVR>| `6
LhawhB6a3`*a&_ | & ?F |b ?rPpSc}A >p#}u>p\t&el6X`豼w  륃h`te3_,a13^
>\*u	> µ0!jj2>3t;:73Be'kJP t'{80:2R%4;44Z
`ǯbh j@p@g@A!F@[$
eu$&4pQ*StS?=<=5
5
`Kh@a	@Ba	 fh+rDW-q(p|pJ$Qې#;$ r%\/P&aRd(a*ac,ahe`P"r ) c%  = $Keaf1 L`2 RJb
b
~c
XrՒ
 }g
Pg
 

 Gw֢A] Dt,-
t%-.t,-	 tE-
tYt- t/PC DɣX`:B~B _ }y  oU&Viet,eu& riewtu
q0t`heҪ@  -Ǿ@ut ;>}`  Pr%/h	pj;tXя60cHtHt `t' Q 軽hplou
^_  WV3> N3һBrZ׃ґ@FPWr~Pur
NpDt  & Q ׿FV^tF&Oud,,0,,,,,p+,,.T>uh hmhE h 6 j v~
B"@ts) 3҉65?Q@;@)}F~
r݋F 
h´΢	
J襾
Z豖 5#W<B6f
 ~Ĳfdf v3ɉNv~FV
tut9v~O|܉~*Pӿf.a^?3
GF&F 	 u^*ۍF؊F%'Fn"	[6FV N; 3Vs~&Év ؋9t
G;|FCċFvBF  ы3$uG

41t%I6%|bpf:afffI&XS  
:at&
S
 WPjt	s0p` ^3

tF^&oF!u	 |03$NFְ#@
hEP2pn{GW^r\F*f+}= 0=a -tX-  - 9B m= M - t!Eh-@  Or= E.pʹڹ/ /  p- 2&;a% +11<a :a:a@ 3 ֐j5B jh
@E
 C
FPZ/ /  (YP)@ wj}Q'3
|^'G`h2g5؎G|S.aAc.a2g, :aa$ a
0&
c
.Q 
@DM
F@f
fh0V" !{B
p},pfh*+`w()&' $%h#fb\rc t
Kc eu
M0  O hE `F<tF "7hڸ"B} by^_F ۄ-FC|ߊF÷>aGͮVAװ
>aO@aa!J/PFdq`lLQ}H fz`OeO KUS]RU)D
B
3HT4PT	^Ċ70SdBE

H
<U|F U\X~Q_Q
	[(t
R2V@2A `
TBe5ephhj$&%l4"65nfD2pFEpET
BOQ
y !\,B`C`LB`fB`-
@- `
- Kt <%_Pc_`d_$___hĿҿ&6FVpz4,2"5^>^@a  zab AB  !" 8- 2&?dcld^t d@TĀDa?-  3 @+- bu	i]c )#@  
#j+{v qpo wb{ {FNX{@ʣ~"Lcfcf>ncpwp@taƵ axx`ޞ `&CADTPt &hD&? _t
&ؐ
`?@U# 

UC	@
U

A C	 @c:Qq@t&fhvo+xհ@{{n~߶fhzh0
5}4R5tfh:}89h7R/^с0vrv?=>h<^@L`	BA}:2hhWVde$ < u@a@<@u"d s@utA;>`  *r$ hh$-Qp1@66Fa+ =u%///)Fa/R+3 (-AҐ:PP%@u'$F P=c= 0Ht
q j r j賝6|@uf4腱;F~ w ʃbrջ|N@uOphhB[WV 6WOp 
nrvƐdt
Q &"F Fdt &Ͽce7$οKA8JM&PAD@T%V%} _%T%&rhh }$ 'Fc"HaF_& *HaPeA u$2,<7 hsh:<9  t~@ rb` zj~=  TP԰0 jP,Hazp0u.&bPjj`ޤ&rz"pq|荐
F@0#0000H000!,a:kVfvfhI
 .2u @mh bFb:tF&<:u-FF
*0N&$x  
u3ػQ@C7 ~ uF	 F
  
 
 <  C
v`
芵Pjq<L^P
RP謢
? 0
~ `~ tghj1v&~ tD軪`E=f=u=5 
`
 ^3 FPPP FF9Fr ҅qF% -
 ؋0v v sd ƨu = wѧɐ>JVbnzʆ~FPX.ac y ~ t 4Fa    R F  :ޅ .E {" / 
Qlp~dzt}' 趄ƂOFZIZ#3^ \Lo*1hV$.tCq u^ GCauK  K .g"ǹŁWI Nr@~u~_t W    I t@FqqFV!F^=uFv2N'22g+7@]WV6ڳKh*h萸y*Ny fyfu}oyDt4H-H4HSHugHHH7I2yFIP;9Az"CLzDzߡza
"zj &z<f+fF@ ^ o ^V^KFP6aLv3+Q OYڀ?`- t$phfFf~ sAGuh鵕d fQVaڙRPSQfXfYf3fffPfvѩMF j!0}АuCFpvh  cYꠒ!u"uƶ ufE  p P0  V6PrQJm		% 6|aD6Pf\ 6Lf|< ub)
Ԥ!Y0Ð3Ð   MHz` KB`SIMPLO  MOTOROLA  HP  1.190   K    Restore default system configuration mpleted!  a) Press <Enter> to Shutdown ]S...a <  driv?elock V`B C 	u Setup  <F1=Help> FilesInformR  Display5iSavefloppy[ diskette= from +(s.Ign2hanges and exit EP  s! witho}uaving
o Securit@AdministP!or passwor:=C"e a/"Power-OnWGpP&DevicedeDgDbD$L $s mart Card%G
supportE?mbedde&Lf
taA!e6'etr*acp",p(s$:aut?hentic;e
credal Auto2cH%Tools Ba /0Calib( @(`'lec`B b HDD:lf-Tp- opDs Activ O wMem
Chep?e r s: ll
31mb 	>>uA@AdvanceiL`4uaYgaC lDt7  of grayq6fie?ld Boow1b..Ua?ny keyUpY ue F10=
, ESC=Cl  9RAccep/=YesSNo D, Ao$r=MpI W  UsSarrow
 o highl@ *he appropriQ?menu iAfqKpcNTER> cbegiggK%#.followM%%k&: tj->  KSPACE = NexBR3c-BACKlvio8"FnTABE3~iSHIFT+&*TsF2@&10`
v[J #'9 Er This60cann)b`mU;d Awn e oc U@ whs6c.de 0x0K1 e jn dApGPu@p0{6}Crequi  yayE`d~jba@%mu0C
mCovP:0 e4k/MEU) hQ1& ilAl//+2SD|`a06ssfulManuZqr  N0
d:Pr9ottyp@speItepp+CacVize (L1/L2)SQ ROM ydd famiaseP8l nu|pi 	Videovis"KeybooFr06verDbI1<ed2e3Bbg4`1qa<8Phip(TdG
W
O3O	*	Ĩtafdai5u%BSNK)$ 1$
2
3	ME
C

V@


4TV
o
D@o
So ྶ:@ D%FPA2d!J#bisFaWalRXS0s&1&H} Addlinqe4 AlHXn.%F$oWarn: rk Tpll0o  zshfTreKa /VՀ, lef ea 
waba02 A: 
de` waqt tҰ_)Vu @rnInv ȍP
)!	Ayou̔ wa@|to  @Z?m  ioa	  0o b+-c(Quick`n22 (Cvre@sʅ3 (S.M.A.R.T.) EP1p3exim@s ): 30¾# g3>0%@v}} ty ho#0#FuprХ:13't4	f-Unknkil䑬WR!mSer9vReaPS)doџ47࿸`?a}ribp	:0`exP9 'b`G H  Olp New Vfyc nY7Enc8Off O  ɥA LA66#%AKroE   `p dV
Ad1 ݰU@ҭ5Ocpcaus7APp(@=AH"h` A&فOpoOwer-.A SQVQa?Uׁ=> loss  (:dYAhou  nlcof aQgoH04)ev`ۢ?[YDocHis9haR`ed?!0f]Dddial JJe HP`"UTool Cr.@%oF8IL` Bk g Uмn qpm`@jtWSN !arv0s /UcwcQɡP2"O	nj* e:Z%%% F@%԰#D
n -f  TndĠfӰunuR?*$n)tartBQK`fsra Par1yNs Spdl?ot CD-Q & vb$۠@yU@	11` aGbourzph҂ u2W!?1 bUSER"MAST xApanPO9`cRR%Tkeep i2acIewph#ysD`<phhaR  7mpp`r. I62?R>
,ҚnRVun *"gFOxOAutoOQcEdp ptY55)0?#O N;
O[?k 2{C,b_pur?t \22th@Pqsow k ebdpPerpJa@naff+bdata, ]ssiblma8!aKpkigi0d!V I0sWPl r mmAM @| Tu@yl,lreplap[@۳o o/*  y4y Xr"t,CoHA= Wy|'qu{me`1r, @M6h`*p0uibty. IfRdo4Ǆw8`!ESCs.!
T V ͲtypB'>'nђ@F10"q@rm,bShxt+  E$@ MpiBjQ  Orpr: U ay OPXrDCgDLb! (left@/hUSB t 1HQbSu K wZipoFirۢo!F`thifp Sixa h ENh`ASwap Fn/Ctrls KTU.S`aslegac`kC>is`7)n0=Pr@riy Vpo  d NTSC`AL6 -J -M+rt
Bid`EPP ECPd2size 32 MB 64a F@pAlwaynPPi0AC3 gWLAN{ D Radi ViBluet h /rS :chHAӡ  SgB@1rᱠNtЖ Ed (%+n,2())+P z+f1Ebqn7)e 1҂23TokRAHp
 kP	M3Uniqu/e Id!fD`&pep   (tu    S`KCalibP!6N@sP D KA.Xb 0B H wO
ELi MEU k'g'MRoN/G/U[:1 :s C0@g . N% ] /C le2  yc 1`dik-d3	s
H

,
* A @5>M(o!ylsSp` @hnologygYadapAPXE ?RPL Exc"Popupz(`@0 10  U2@ 3 4 5 6@7F1=2z5 15`@ 3 "MnB `o_uchpaPuSNon`<F1=Hilfei> piYin[OnzeigpfҠPpweict  KaKguaobVwiePxnLveinun	-hkz
.iKgnepd`t*nt nehP78/%Set#SRheitsfGunk:n`ɉtoa u
nBlt-KuO] Gertesp/--ID FO`t耉7	Usttz !@ 0Qz#  be7im 3st

ng!KAЀr`5nHsvorrq##7..zurck z9
B .p,
Pf_g{ms>ThEx)`Akku)kr_eK tpBsgewhlDD-Selbss@´ItivS9#LtIp;r 3g 0: tppllTL
PZ`OS
q@ PErw :%SpraQ 1a;n!4:#U"gran Fel{dsrt-O& O9!86")Ke SePMbqTa@0, um p_3fahB@i=A, ESC=GAbb!#`WBkze!TJasN0\ , Ja	=Meqh`m VeZ
zpMarkė"sy!*!'MenS% dPfeilt!
^dxQgabe2RmOq>ko?9 c`s.	folj
Bn 
sg:@)-> 0r LeGQ ?= Nch A\pd<-RBc?hritt-`VowA(GTaGbul!fs+ Holl+gedOx F2@
38= {gy EscLhlrLi@<PK kan~Lt we YeiffMgy16P=`?rgetrЮn.:Dc 01 L`fitM B kqcQFY+<W\selnomvPorB]er0ilXW^qDeskU-KsBhmu f 3asÃbzw=.2MobiޯZbgtz%.` Qz qh4Bi///"2f!
}[KAlgrѫ ab>	chlos@`F-M`ll Proz yprtt`wig!60a"Ca`-i-Gre (L1/L2kkapazitOMdPm"Famik Sp; ummU Graf/ik-R0sa@Q "f]r-Con "
A   a?7J	b31O m2O 3O 4d0qV si H>(F ` 	o	o
o1
L
2aSe
krET*  L$ƍ"D%'$b-!3Kc(1  WalkZero-T\<One EdA(`@PnO`D+: bX7 stqbislwnKp  ZEucQN-/aWB _leQb s AteAi#CP0&ILp`ak A:nfdC6
lW$ge`KR/+Pglp%ɏ53 L  8	/  M0$wirkQh"vQM?`|3, daᱭ
l^ie0w QPocF\Lˤ01 ( anH12 (UmfUafdIGc$fhrxdauP(Min.):G 30ZБdS`@0% cgt̯59wuwm #HoPuy p%ubr`"w: ؑH	ԑUnbeaaMTHC52^'rvo-L 5.
32@lhafAttoribu0FID 2u"LS.M.A.R.T.˒XXMs K`kwp eus~1L Dea  JaQ`eD/t Fal8geb e
U	ңBU5Ip dminIoz Dur1@`'@z`|  mg1i@eFN1s
gd,E.@"< ttifiz eq s{0yrt.@s Zu@1`0LzO 9p袓enl@~.Ajb s0Q!Qnp'PlsAviceTa s ,ܠF$0@ h`$pSga|F	 :	 JZΰtfa@npWUm Fun)S7O, m3e\Wn HP{tectToolsP=c^ty MaGnagпUo-- cڑ}- k QuickLock6Subnd$Fr#q\M#"e$bi sϢnchutz  f_-?1dԨ@imd& "+a A)N+ *W"$B><#, lp8$meh1A #I Nk>"ʠo3f`ot-Parpen}imCD-ҏ&g1M!UP:an3A7m$"rive&Ftpla`t9;XPcJs E-=\s mU8unbrapjb'ar.IpT
:b,ҋbewB>SD!sTD,d {¼ !C&&0,	I, 2.8\v%,    H2i<nc4z@ N󝀞}Begriff0diautomLs O75@:ohl<? i Q֩g`yp #ps\V*f ~
T'U!!´!mU"n# OP o"e o )lnYy#OBzs瓡58c<sQy:Sn@ iQ.) r`uM(qS!|qs mh!ac%Cw Pr qғ+`I o0  6qurn׳zhE . Escdrr empf`/qS	 d?zu!тRO`x t.  󉡛  f.МY@ұF&1 2 B 7 b-B`ntra tAdant!Whj`!@Esc-&VlȠ>m kW'p'p`\ F10 `esh:
x3fg`gL sbD} m  ܡ@MM]uBay&m ̀)bBtgk`-EQb(links (1tUSB-b#-2؆ƢSu`1Zip 1`234 5`678 9`QFn/Strg!Pt  ų dEaCГ (USApfN-ZeP]}B`iebss"unabhngB`  cAIAn Grafik?-ContrPrimSek% VideoQ- rnԿBidireba?l GrP |us Lfa`iCb0tzbB
d}r WLAN-Gf0Bluetoot%h9UnU/a Eg{paAggr e_%7(&.(o)u -E`t# 12P3Y5ToRR aC :=A q1t v^Q1I0NqkBoF AkCkuN  `PtaA   x a~  Kalib(  M`k`O  NƘiual_ !  O  k   O DO,rOTra-?6. .O .L84obi!q p9OO5"R!P 	EgnOOf`.[цrІ 1 : . % ]!ablo(2Entl ho3Pp1 
m* 2
 GS-2'@su' `RadaQp0aBPmbƀzA}ExpA-!-Popup ( .) =W0edau Qt0Pd2 (eZ@  Ke`~Compropstn@ <F1=Hjlp>Atoplsys!pVisúne G0til !Akonf@b[GwendPfraMqzp@QrU
J`gnorndr =o&fslu r ,1 u*t`gBOtne k)hed AdministoradAsko KP aodA7 fo% ˇhE"djeG-iSq		 *	v*
J	Sm-k	God0d7elsf 7do_dbycggPGOds -&2	 Nu@00fakis l2 Uag
s)9FHk@\HF Ba.@ġV  cb"dvalg b&HDD-seliv\tPr HukoQA.ainPQ2h OGH omv	Ir/ Avancq Sprog Vl1?s @mo2nedtt felOC4+'/#5l5!Tryk pP7 tas<G0=tZO^=A, ESC=OAnnuaFsp!3=JaNej "J, A!R=MGb Brug pr
NA`RP70we~  releP %menup(,1Wt<ENTE'R> bqec>A)et. saf pPr'f!f~7: -> e!& MELLEMRUM = Nl<-TILOBAGEr!JTAB&2$KIFT++ԻF2@	:*~= Acce1h0!hk>{sf#ej 8A3ku1id0gs 2dodQ)!FF1n. Fg01BRnoVD-p% qpla`9G!krvNvek`EnJJ
i db!?zs flyMsÈn/McEUqoO5 bp* uvetzbrud 2JI,nemfB J@`  Prc c~@or-typ hBigH  ztr`7Crcache (L1/L2HVROM-d@ famOiliei;\AWdeo#f0pds:@Xr-cs]D-ba`si`9e2o`%3o&4Z&at-ta`ofej1E("Wat)	O3OWEw ex{%Ipsr4E$ TyPy%xy l=ydes!Bmis 0'bvD1I'j`Qe0je var0: DB1! se  alt@P02[hold a@ poPdqt`/b Bb-ɊBdqduw5,&pr Pk
kEuGrBA:ރTETf DF%Ugyldig/
t-  <@ngivuİ,vAi av٦,?# i#K?@ $1 (Hur P)%Omf`) sl(`{ (): 30˄2j  `1x0% f3rpudZ44b2@DR 	8cq: KuB+"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5ܐpyCD@F8Ny  Be@}ft nDeae Fra@l !e@+ń 4PR@{	s0FC		ƈ 4D
&KE  beviвB7 9!Cfd~es, f.. <ramG261A PoRR.`RVuAj@me+tabWata. Du bup$AM flAX:Ը viGcehCa D[@G @ߒ[&?0r !,ci HP tectToolo9"jK Quickp;au`LsQmP SkrAp!0rKvt%#k|qX)/sa1-$$ HvisatՀ `w@x6r,
di u.pbilK2;p+1ol p@~frard )x  Cd-rom- cU?:Bg Ho2A%:e@AuΑ5Huhu,;̠ Dq .  bOBRUGER-s OVEDADGANGSKODEN,22QՉLU albtga9`s  n Be  ne]d op@Ia0X'edS T#
{	aMD Clj Ђ D_aBAQ>Nhjlp eutom`oK, D,ZAbyg !iWj?5B^.k permaf@an`Pig`v2n:j fys dsk5 2 rbppc(On @O"k	v A .cBna
  @ucW"EKm/, somءмa ckx@
ҚTut. Ur8d}U pbz(@oPc/cÀ pikoSӴ`@.P  |бbefalkrafǓP apx 'A1쀽@"pl . PAXu	u
׈q  &cO. q#m"J"4,Q/pd i`$HuA0˗ 0.a.j2`:@ENtrA!5ESC. 奘% orPx 'F':ge@F10 FYӄMsf
i/hPcD+su  !Dk Ossrf'lgm vDRRenAHPskm yDSP-bas MultiBay (K0/$hjUSB-?floppy%#{cc{2|wbsqu SbAzip~Fr@aVTr7edj Fj ސe SjSyvRV O Ni \ ȃ Skimѩm Fn/CtrQl E`lPv(a@i`sk)8  UegeUstt!
u@PnPAQ֠ߑrm-cr Prim@Se`d V@o Out ParaX  TjStrCL`ohukoЙ Bqld t 6nr compu 10P0^trm
gAt WLAN-!spioBluet hK/A (trdllo|netr0U|c!mstyApփ&(x(top1*b*Ethqft 1K23KToJR aYHL	pe+	 	Ent 5gt id-nu 2 0ı@  S@   Z 7b/ JKalibB' nndaigO  x 9p6  @WNMH KO OM2[b o  O  O#0 OOOO6$HAgs  1 1O O
1VSi mo`gPa(MEU)J=K= OOGOqOO  OOO[ TPq 1 : O 9. `% ].UgAmt2 AfFH5L)zO3@	Genos	
k

, *  J/X 4%G)g `hB`At `r`bpop{upsink(sek.!HH025f-1T@bgpP`pA Konfigu!2mas   <F1=Hjelp> ilDwin0jons sypLa@3$ak")Hefra6#:p`di!opQ	:k@'Pg avslu!A ,l BDE;sprograpt STt ZpWass@ a/&$OpFA0`:|U'yrse|i!vsfunkur!tif @ԃ%@%-
vn Sm4 |#godkj0RƐ!neby3Pi%it"ot5sTilbake@l#3fabP@PBQ`g
i
 C7;avL`Srkty & valg !AlPP 65;vt AkL MbT !#[SS;G@$π*
`H!4v prlg 6  Dem75bM @ZdtJIel[3
.5E6o%<}5TorykkC taJqLL&pg _=, ESC=Avbrya bBʯAPpJaCNei rP, T\Rer=Mbb `kYneRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMROM = NQ&86  <-TILBAKEPvrig*TAB&"HIFT++F2@	)}= Go  f#l`bWsfeF`  SPk0`pZmno&p@5 PS M0|m kjresvYe!@m d,;@i pp 9!osbaRaflysbc^ 0dS  w}a`1A|rv full1z. kode 02Io|"Produ _t Nopablookk-mll  {typ h@igv&-ga zvAӄbuffN(L1/L2Meng`	Q	Nenu V@wo-ЏTjrNtroUSW,kobgRiJ,oK51 qNi 223"40,p( E
,9(Q`
oa
`oA
o,
NEkg#Iml۔$Eo%Hq ok!i*ps("Walp9g 0s"-h1jH( Adss e7"~e PRnAd 4~: DsA#.s@QtisdlSCholp`@DH[aQ "/he-  &d, rnP}u1p3 sakl<k`nn02A:%ڲO b@Ҽreg1i%HUgylGdig#DSR`	F
	#NE"h0mtEb`?̀{]F igno\3t_te?-  HN 1 (R @nsl؀XbP (): 30A3gg3r 0$s0%[Lv\st!vhF_f!_: Ka"qut``QUÓ5$SQ&eGtt To(Lesb'1Du+q vr{ib: ID301rs<pS.M.A.R.T.-f^C0CC  G#Npu  Bekreoft njAv`l	 ePcᰔ1qrEّjv}likt aDu!0o@C2Ѽ	aXokag3ogs.ror dmpel&! Tp}?ّ.rPa(A=pph. `bkYu  amK࠯#0vice.0u	la?eD(s aݢI 0"~H i HP ptectTools3curityo Man0`r.'-RN%lq  ēlanppa0usG L@$AOmpEr`i!gi$eu beCska u"-U+/- +ӂWE%q  '. tgl`rh,v@=$ڀPŶ. K$RmEp! rfrard- Parll+vSzq1   CD- )FsU1ut Ho $-:Be5B`Dhpug hh!3@bBRUKERHOVED-T5 BI Ryumu0B@EQ
 n0]*RDCbe!1KPP
 0P v@ " 2Va! #
6R,ARZP<0 	!؆ 5)pp  t~I@HOM @ aOutomPYpD!wLock	3cbyggZ)b0`  @]maPqilg ]g%e0.S k_[h fysAad $0GmqW l#=	 |u!m:fnd1]VsQEs Ѻdda g }u%x. U⿲g omd@N1|0/e XG)0zn0q
` uPb}Vnbefat 31G	 A|q.1A,=w A0k1 E5ϓ f hP_!R!'Y}I@7MT֐s wp-QVflans NPBv
,2ʰES#C-yL ΢`rb'fD'<J F10$Z4Cb#e:hf`$ nd  ˗Nor iFGO%re  Mu?ltiBayPG]@y "Q'n7(ve!e)pPko.ngsbahhyOBUSBA|w Zip-U
A A0AaFn/Ctrle EAVd(USA)GekeenAel a	jZtroA2deoP@!"pT;isrr`2FViA7tiࢀ0mFgradi/@trdl |t
WLAN) OFBluetooth j/-PbftQ`mbQ҅ Agss`B	styQ'1_"&2o! (v"*b/!1 Eth ?	)	3 R@NsA'ooo/
8ni|> gtifikO4C&\=B6riQG Ht@    3ymbo KalibPaK B!es- IA09plХal ,-N	O	 I	O	O	51O	O	O	O	8ksp._O	O	O	`lnd  4oO	O	
%O	O	_Cs mob. ^
H.\L. \O	!zo
{{O	B.[ yTAO: La9. % ]!fullC2 Fa{i3
Qi!n/h* Oy  (o J/D
irpk)mA sin hurtig (/sekuPrF12- f1.Sep_ute P pConfiguracie la Com`adora <F1=Ayuda> rchivo  mn%l Sma``pGu isco fOlexicX1pٻ Ra`&sAvalopf@dobPay Ignambios y`li a AL{  g3 'Ln@epidadAse
'  ' Axj0iciof%0posi@s_SIc )$ +5`*KskSm!=C SoqPe*cP#<) Sect}yincor% E 0e"@ 30/c`VxP>6fbrI
aBVc!3nci@])AutomaHerrami aC2}H`er  8P(8 ;prueb_a HDDKc 'EOGVЇ&Memoria2aDd*mp.l1@0JNKRMu0G`SG#
s
 AvanzX`ESvVDD
W? nFampr)co0N gr0<1o?)<UOprim'quitec0g2) Pbm=, E_SC=Ca06la==Acep\ u=SSNK\1"Y, CoN2	=M y p UyB$dchDha6@alvP}  alem o apropiu=@[*<I?NTRO> z qx:N1n.Fs{3pkTYu :@Esp~o o -> = PrxcRetroces<-{0@aؼTAB S	S'a~Mays+#1C(/`F2!-910`rXŠ"8b"uErr0^6F  No@8 AiWGSPrjo u@QRA6K. CdК`01Bha7y nunw>э&qubRnY2"@AC1+>b1 `r(Rp[corUD)JН@ebook/MEU? IXQP\ 2O8`0ple0Vxitosa4e Fak T1ytil TiPsOp7,VclGpuWXTamauZ_0h (L1/L2Oc FAAR;OM mil@cNmerD}ribvisUv@ j6r g-l@yo!!
/H#j1l2n3p4 EtiqurAsI2VeFK (ga`@Woo.o3o`opoi B	Esn!*J8T 5:Z$  ProbU%bssfactcXJ$ǔ =gll4Reo 0poX@y1'	lnedi$l@z,
(CE|`oD"FF%Ad :vH uir  eapn. PreP4#/, WcqscpYcuA:'p, Uu c l Qas ' Ӣ,hp9tegAң
S^@vClQI$`\e'vaPa)00٠o(a) 8!@%c	Za?`ganޗod iAlO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcuv7tieej 2( s): 300go LB0%&~Db  EaH0 _`ipalGirumq
 : s,pu10  qIQ{`3nh7Servof 44apoya atri=b0: IDp#@exs G
X0YA`seaـKHnuevL@)Df ApagE ndq9S!@gOB".X		:@e voc"	ؐk"alpa 
0 Lstnad ;`fRn"]e#թ9 	A*# \A<Q, (02o,vA`Ơbs (R6% E  Wci@R|LLBa hrp梅inR3 S$Bf_ olı9al ol`X#A!vu	jvip.AoQ C '{Ùv?%( ֠WapaAuydAn14n HPctTool@O)%!!&  QuickLockSuspen Blo`^Թ\rat S 6""t mej `eO@`?:0d++-y	(BI	( @!)(rALlRt0,"D,P0X&upizQ,.`xHO;re PunP+roj	o%q>lWS9M9ICD-(
Eec%'WePi:XUsio:Mpu;NmediriveA'0 tzUSUARIO2I PRINCIPALьj oe c&s UaJ7manT p w. Anp2 >y gu # lug3b.P  p_jဈz.p-%H @d\WcG S1
!Qbb;v aYp=O@mc}7PJ67EБor1ܯ?b9
 4: @G:iR u(?s } , fs`m1$ 겞RhArQOoc, G"o~ /]y"<:Xou d/aap{sRcu2bRt	£B! ?1 #zda$
kosag а6Se r0wo0enf 8d lic㡖Ӣ@refaz. &?k дu "`#PZҝ4=ԬFainO} a cjTBBfi t8Z`
`ri01pons2>敩Y_, i0҅ ESC. BP1alab:'Fd'  ,F10B:lFRrfG@ǋ7cT/Espaol OӗtMultiBatNQPa DiPsi`$3-pA  ;]SfbԢsco+d(iz"a(@jech@-5 cB b a01ЇpSuwkrZipcpmeaaewTer Jo C`5t `x SO vNo0 DPƀC|As Fn/`T@ncIngls (EE.UU.)s (m3So}"leA`$1nt!Ac@ GC>0eo Mod"y!  Bidyi0 Tam&mempIׁ͙i#	si0fQu0{ B,P޳ICA R<k*WLANy{-Bluetoo/th IA  zQyyQhoвergRsGCpoos3B_-PF8{(s)ior)Ethet, N0boo0 S 1/,2/L3/TokR@bOO@`P23 IPtifd Exclus`pᑅAJa@4`   !,a*AC~d`*-N@X0S#ӏoATr)3Vh!,o	o	k	o	h	s0bhn	o	o	ehao	 o	o	 ao	o	%MEU 6}o	.@o	o	o	o	Ub o	o	o	o	rB8[ 1 :rgR. c% ] /{Am2 c4-Clē3 	0k",B'* r 9ODJ)o!Ѥoh` ~aБAbbl" @zArran@pٓc#uXDᎰ0gEx!`F12QTAmbTouchPaud`uo N`qubaưub  <F1=Ajuda>yrInfoȻsobo[ Sd E@i?5m!HDbβМR!0
r t@7padr0
3r  Ign`air@A	sPs'&_pA1na	nJ4aP@OaDr%&U' _`#Ɠb!X _d#!

SPtSd!܂υ.8liz/p@ʉO
(I 0@!ԇs@/R Q*?g%Ϡb9r
aut<n 4dcЬealha2@o`Ma (QFeOmPasDg1=i0CP8$!leRߠ֋OpT`HoDD A1)r Ɲ VR#Le Mem@A< 4tactu S`MuW^G[⩨ Av8S%,io Qa^d; camppJcinz "o?CA9`essNe qlr wycи'tinug=' SC=CelaAceX imNKܡ!S, Q%ou<=MaikgO Uti0: sC	qqn'	da o i  apr#op@w *u@Tt#<ENTER> t5meRez[@o.Tgut@n9 ^r u:b:  ->
PAO = PrxiK\<-QBACKCExaQE06TABo$SH/IFT+C%* F2 	*:`a=kSC# 9nErrrOA@,Q@na0WoQpڃmRHE. CdigTGo 01  NPhG`,`:o `+f)  s@ viKCA 1A	bMev
;nsf`ZWotebook/ C[(RWS mGsTe2_DKKXqmBm? xitonzN  Ti0HPۀ3VpcS_࠹\ Tahcache (L1/L2ȦFX a` ROM FamlY  N 3sri
RevisSvde@̠_aJroQLa 
Al!D	Ob a(344`Rtiep	JIOeu6(]) { 7on)oo.Oo$alS~ƕSecunda'$ 1rcCq% vfoi"gv@!mO al  WalkN  0e gy1i	a lien!M!oc0I@Advert: 0[Aqo vae!djWAcqP/u,!i@um  gravv
uu:e)EӎA: n@Adc NS3  >B^hO🽠!QtegiEa	c]
vl0IyI= kT@ctezx0eja $,C?C iN >?ý1 (Rp b2 (A@ng!qf3 (S.M.A.RG.T.ax`=б_(.): 30<`хѡ00@CT =4Q0%?1$bucedeA,qAhosstDCrom1
: Iss-P$Eg
Ch`Ӂƫ(*{erPmec ` `6Q3sM tribߒLD`AМexa@s wQUUig:Tgrg`alTPSLs   qƀL rB+ۤifPArrfDig8cis gҐSAdP)PPЉxacmod!CsާB! fazA@ArEr@a,Πer dfor!m!r3Dn,Pja0.@eHCsHfbrcausadQerF. TbZ Q[e a 㷑2k_rvio 	Iy0rqX)QT?%0Р ur@r0k
ad`pis0S,B,QuickLock!Suspenso Blo0ktB #u@aSM%` mabnbP1IY @k,$$al#.2P4sia eiSib0RPuseu sEExigLU`re*PbM0Q+ &perme@$1lp즅+8!CD-"˯gGP$qme:PDusua: Voc È@gp4@la0vr2utzooDriv)e& t@$RUSURIOBG@ESTRE _FSC%ɑ7q<Vapaz:@I. AaN4P@9de-ФrMis PJEB>p"}@.. NNv p[X֣'6Ve ,@V`(_K` 0+abu:*Ƥa !ECde]D.H@f``7/{s1!Bi屧O7T>WDIAV
l`9w9o  sumǛEf`lo,al Af Caa_erf
a `uuzAoT :aq(2˂40  Àoqur<ǵ x@FkgڲU yaf0T y 2y, pو;) F `3Bor nal|p`#a-t
A^ ˢtEsubtu!d C{ ?@ *hR)ppa۵8ptA-l VJ/qrWL !8Z  Lembre ՚vqMac`Pasa8
"qui_se<`R ESC ]ŉ9Š\q3lav'f'rF10. r`r:MrʷTAc]D u?gus Op1k: MultibayQYNc`iFsi reAFpBa byaФcopld(RP diBtzB	Rc"zipcPrimeirV"rc QtөO]v@N Ղc@aqAs Fn/CtrlIngls (E.UV`ыxS[hp1troahvdeAcund a@hMo#aGPadrƁBiQTazPhBmemO"sem fubw>zec10CA.#RPa 0Rlm|WLAN)` &Bl0oothkAnP2πڐ(a/ Eomeonerga  ere*agBC/*1w62,12oo-'0suЁȰ/0Et#netg	O p
/*3/CToken Ring OObo`Id!fDPPb 3abraT qUSt IsPSڼC!bQGP_NtgemNSrTl1CsrNWDuplo&	ted/	)	E /	fONOOHO'as7AXj O/	kC/	cIAlЏ OO/	Ojb{MEU/	/	-/	G9Dq	/	/	/	O6[ Etp 1:rreg. З% Q]@Oc3l 2:cv0N3:@M* d
 o9ayCJm*O"(sfOlex QScp`xrydapR 쇕 i3Popup޴ Exǐ ~F12( "ߢ dQZs Varava Nu`Ti k yktukP  <F1?=Ohje>PaJrj`PtQt Nytt v0`tu kP Tallenna levykkee !dk@onoP2PuVtF?DFo0ej'unsW Ohק mupA lopQ4Lr  t
tt7f,Tpou@aurlisuinvojoan ssaPMrit^oKynytk La Ityl	
 P ~usnumep
o$-
t lykiu '
,(moPnu kiGa
/!(et  F0.t13!fsBg5*tehd W'og"@t!B$j;A6)ma*in@#Tykalu"A: o9K < Ki3Gvyt?0Oa9@@DMuNk! EaR6npC:m-GdHLisKKieliH O Ik aec o harll1@1Q0= 22R2#2h%Jatkin0jot  nppՄ]=d, ESC=PerF=Hyvksy=KywllEi ~cM, JokuALB=TY_ fnuoli
mi$p_k`ah$@
sics"N <ENTER> mB@t
ep+.!I`Kgn C/ss seuraavU: ->Xi VLINPPIN =P[s  <-bASKELPALAUTEd0fb1!9ARKA+! hVAIHTO+', F2@
)_}= d@!x;0virhvAkkua e =soi>da.>: Rvdi 301*ka c1s} apHrtRPl pU@eyt3ke`"6ko>@	siP.Qlaks1qdиrsrW` kaC9t qlaaP^ TikkI)>skeytyi Fn
i(pO2"nL^o2hPecaGmA|ja|}1?i`d tyypp iIn :fapllVlisQ (L1/L2ࠅU  ROM-Sbmkoh	tuotepe")sar` {W]`si ?stohjab T;{	&!1:"#2o L	3o`M4m魠J`L#taQovn7(j \oa)
 


\	V\JEkA'Gra- Dq ACuP$#:D$ P9a%dzb~ lpi!iEepo3i Walking 0 -[1Yloso`V?aihtoe@ :uvi7 us: Tm`󵐅@atpsnhp . J>lt luo}p2us-  sn,pirj1onc !K A: L"X $AYhk0uV V3beFAG`8p_Cpa༠ ᣾
gHk	oa]Wi `n?a `O  PҤ?ͨ,i`%(N92R`3.M.A.R7.T.@Arp$ [࿀n (min): 30-%s3 p2y0%cL <dv0 Ispysi- 4iVgR
{fb%untq'c{K)jServomoottj
Lau!5ÂvtuQꪼ	k@Fttribti2`З`Žy@a 6eqKxe nGG9w UueVahvu L x P>2Ȕ@	! P@C }A"+@2`s@a	,-ãPAJrn4-okkpDad`5an /)inDP -e@7p$Rmysba
`k 1h@`! ЁeT@	dE	ZEY(O i0Xj [!K unQnwbay:p\veapahtum"b@^id FLaJ4tii l <HP PrpctTools`cuQ`Pger -GapuД큶.f(-/U i` n QuickLockfa hlu5 qf,V "@PraZ&-8Q,:*sekm #o$j$it)a{d||}yh ' PP`0#UC.7>uu	SApor InfrPnR% C[D- -!fl ~QԌV"s ŎPANyjUWAiot;\"nn De"(1o")Jlola.    KYTTώJNI9! PSSANAN,0IBfw.la"q %sily1Mgur R7qg  gri^PfaZꀝAt]r
f$VV-`$U,Ap 8 iwLLAQ0<ѨWZ& OPAMA  Qops ) V
 suE=4:d,#tu@>x	 _4`o'lA N
E  U7lE r
pRw%y iC. Nyky 3b`+mPezsv6Ar
t  N. TmttS`|q$ihveip=upe1rRU$<eh?  IPa*?-@l@wp[1tЋHta1U]=c zAojAaiemlV|3tp. Anm "P$PtTV@UG. 2!`ZX2qїaF_`Qy#А ek rm@o#\X d,aT0ESC-n"sR;n,%'¦e'> F10 ŴY4aQaqw:	o .cVQ llQݠtmiA$ys u"bn MultiBa@Opc&Jlakoiu (ƐenA/$oi>P) USB$@)ZipEnsimm0 AKooelj }Vi@r}Kieit@ְKa0k Y Kymὁai Fn/Ctrl"mhAEng(USMA@UsPs#inla!ǁB- RsఠS Rn1 jPBsi PPs Vo'lh̙t\Vakio0s2sNb#Ig3uuQH Dpl verkko
WLAN-ro'Bl]u`Voth @/HE@h^@sV@Qs	 s`9l@@Ǝ
|+1`i<9.2v+-p	+ ?(ylosp*OG COr5EthCerPn1E Y oeo3o8+To@ p#gOo(@workQ#%G lH1liv3 AGkkuR < TAJq 0ѿ r{jolibr@du c`d  Wual^-OO  OI OK"kb_OO  O ONr O$O$O$tva_ O 1 O1 OMЩaanusBkOD OO OM"OOO`O
OI[ e`i:r
ada n . Э% ] `ODPW2l ur00&OE-O
3
FGo@MOH*  j ,9@ ƠаBk F1vuCP` ɐiư  '(se nA@S`: F1S2:ٴi@P%3tappikoskePPP. 'mmaK  Ei mn Configurati3ordPteur  <F1=Ap> Fichier Infor m Aff age Sauvegarder sur dis!qc R@a*r x'uneA.H_DHeals dfauow {du'Igno%modi Tpqu S$e l'in`p$@p@reg om	\ Scurita%Z
e ssLd S"#j@e sous te Ion.D
 priphP %J	a sEIIDy'As
{Dr`<Lockq
Smp(CD0 Br13r3̒  'heP5 Q ,b#a <ۂgre taR, 9)+5p7am''us3;),;rfrencHM =``t"#Ou@[ !@lonnLb`beriZ sle-cqSn@psQBs AIATA$ BFoV,?mmoir`hc BDX C0ZZaFB_V Az0c`oLang4? ChoisPJ Ul3Ind)!5_mps g! 5ePMd.rpa`k2Z}:z? AppuyDfatouqpo@gezu@l v=Ser, ECHAP=AlH>Accep S_0=OuiuN*#Q3V, N'impp_e``D
=p0aw  UrPzi3
s f'heM
mo!04ecle hme;nuucer@r0wbri2qh@z!y <ENTREE>2nj+W	ss	sui0@/fa  !/ :-> ou BARRE ESPACE = EPBe`-$IEpreced@STAB`CA*'MAJ+ix F2 =1p"w-`$!S( rr`x@P<TJ Il FA%ssibcQ7L U cs='Jprod{endp#B$P. kCoa<'401)c5CntP@-1 empla3ce(L' 0D SaQre@}@C'y
GJ 
s}^ccueil dн "4 itaxsmobia``
W 
u` B!OOOF2BfCX+)a wru Fa0;cq0M\ TyQp0osBV8pwDb KTa@rcaa(L1/L2) VGolu`e!gD o ROMOamR~ Numro#p	Rev`cdo erS2ItrQclavpoLA}ud @;n+/Zp$/zr3/t4n"3inv!/Qzi&5 #priF!L( Ute)OOoOOOBV'edA Eo MT֍ :$/.   %Er4 Q!SUPc;Walking 0ᥒ81l;ig'ad`aauZC	od g al0ifAtip1SC[a=e@ptcruA ieЪvPR! /0簹r,  mz{ nroc	cY0R]A}jDL_聡v
 tro Pa
0s
TX	  _D[Rvjaˈ"`dH.On m:YfPS 0"Ӏf   +-AvaPC lp  ߚV ? Igno7ꉈ+| z Enregeo#=1 (rap`)#>2 (coet)u`|pimA(z) B30堿s pAU0% nv$D9yl'hA+bF  `:@˗	AsGinpnud'+,`v`t
$.ELu( pG3p 5A`ib!O: IDP0ࠒ0@"s S.M.A.R.TAbanG2WpW AIBY`se N!=apYeAø?/@;sa#A Mar, uinKS ;A, e,ecoac	;mme, vK*ad11POobPbatCs	eSdp4D	 pe>a1a`(`ifh s4[,p@s蒵 `Ug"  for	mQg-hq#xRѼsJ.)rmQފb	hJU@0`
1AJ.6zT"`QDP~aR avoupR!Afr Cww7A^	 	zY R`(p"}ff1Qd  k;#l2TcgN<q`rHP P`o կTool:eRyW Mar O4K8CF!/  QuickLo;ckUsusA |$cp!#ri 9 س<S&ocl'S+C)re!cB!
`Kp)!nk:,   v qi4//  / L'(a'a
S$ud!v
 KP
dra+D hn 4`ExiAudP `  4raQ8llƙۗX C#D-'EǞ8VpalJXd
¡:!5pr5Sfe DriveA). SS@@@Ade{z deux"(UTILISATEURPRINCIPAL)@!D犵	Ъ"r R䊳N N:z ?I`!@~`E"Q!qhsr @+lfe/"celu&MsDordi`Bb. A W	z(@o@DNU(Co cn0 U@fet#qxI+}M"+t"~"asW"qmoeP: :""Bt qD)<Z=Ianiq45#'Oǅp#!2/r,"c̓û!pk!  3PߍIX!$! ܐ!!{ e ZQM7j]%uelП21`2܂T :HD,g" ""o }a8kE
O' f@W'!b_^w# ,d'originIl2v`O"2Cwa B	uD
vqSaP AQy9)Pt0M`
5djabvps{s`Pze*@-$݁WQa0prs0`Ta aon: top@TP 2ԡa3440pab0yt3ץk'
1uj, appuy
`  ECHAP. @@ OTzR'~o', pui`CrDF10 TapXc 1xCxY^u}	U:/QFrana
OgvACJiMultiBayulBphA 1!3D,xsoca%(ga)pOOFRz) U[<8V USBfQpr
jZiprYP: Dhit@s QuaQCin`NSi;xi Se ߑ  Hud NeuvCD`Perm/r(s Fn/Ctrl`s AnglpSOA) Poprm1`s A@stanPhnfROd'ad`n el!trl:3' Uich1uer&mr`
*d :i@7idoAѫa˭Bid`Ԃ 0 m)mVl@1jEK!al ږ R o!=ril WLAN (rsei{l)AgrBlooth7S/?1 K  ;o`! qg`N loc 9G ``!WnXԏ-b61abP-n o82ooypu9	3ccu@jodogB Ep!t # 1a"23TokRingo`oU/Id!uT6*ao haX  /     h ll` n!Hre0/ x Ab!AC.!f*Du ph*/) ///tb/ ////* *-//8/Jngn$ , /,/ /ce s` BtkexЯsqbmo P//7// /,///7[qRpe 1 : Char. % ]A.  2D` Gic(M*n3@	Rkio.
* T  @@/M.@$oOAg$Á4Amor1cFe"5 RetardBĎTexp `) Dгa  Fs12tposf[iP+Aux/  PatqbAKw ucun I@z!Nl1 <F1=Aui0>`nfo0\gema	l p'Salval floppy%APttoRipr>Pina dmThifAap`i |Ignor`daed esci EP a
l'iI?z`ciBPŷtup icz{za sswo!%e am C0rato gPccsP
_QC*vos7v% IDs
Ҥ&gDriveLock	LPr`ǃ)S t C7 SupP;  c30 g@HQg/ o+:,i fabbrP
4=i	/.nzi[lOco
ruWi Cb5<b!ae9E`lrOpa@t2;o rigidAEtaA'V<â,a mepT W`<HKJhMiM;A>op !Ava=t Lu!O l$Dim"& q6ca X sso eviQ 1g	vv!'#o*62wH8Premi qsiasicsXperQVu L  @i=f, ESC=Annu ,aA Etpoe.o=SiSN1T,altro#	=A bj Us"Schiav~I frecc'!i1`voc<u ap`=f"_`<INVIO>  \kZ\'e.ipYgui  un%: -> o SPAZIO = xsuWss`0  <-pBACKCEĭ`c<ؽTAB@C%o"M?AIUSC+)XF2	>-= m "AC"IErriS0D  Qu A87npupvse@t"ViO  v@u4T|XJ. C{'01 Npu0F>9|a0 Doggiao Lk`IP'0  Q>re0
z4Es"@agga%FvpSAcғ { npabook"RQzespa jT:\ Zf.atp1_
2o{briuPrf uduA NoC  Ti"+0<PS^pVeloIStepp@YMis1ca(L1/L2 d&dDbROMIamiglk N@o0H`(	RP[3[oxi#qSroll TsjrAer H~i1OFk2m3n4ࡐ7w PVSTeP)DE(d)8
	2
3
4摭xFonda
 ,o:EV$ Tr%$OupyP!gTpŒ@lliASprB:bits 0t 1ИRindirip	i]  `|@'uFAЎso:5X%? gger `|vpAhAre!0M/rѧ, `1favi PPb`iVYXA:'mU[A:"maconou`Ah(_ IISɁQritVa] Nsv@dp RlIQOyളSe3 `voPga ?AF0bb iQfre?@?: Aɐ51 (Rap)62 (Complet"2tio }(): 30>0%Q5"rƤ6ar0䠈'hD5|:s *Щ-@
 ֤(aD୆%aerv|")LċAPLA'	rib i0gol: IaD$Ban`de@z قi S.M.A.R'.T.!ޱuTx0U _word9c(nuo!i&2 pDs c(Ui%LH?bq+d`ᗑ {â"Znd?՛O .A7Tcq^B&
Am AVf! B;YECr	t>J&2fum y3"CePe<B #Eu _t0s!1a.Q]ՒbdFo!erqdPКatiwEff+Jizso@in  ca@2ivEvPgaζOdesХ @Jm9Yy HP tectTools Od.ZRV2+ ickLockspen`3B05EY. mou`s8 MM d?#<#,p  gra@p'!oe -!e$C-))`v!pKsm@]H0x!! b	,'URar i "lі@NR(@@|ГV|a infraQ)p y)o CD-" Se$PDFVp:W <!SRQ#3ęwusanD: e1&. D6AF$<P @@b}W'UTENTEPRINCIP?ALE  r@*रa m3an4fu`o. AnPV:FcP0r о a!eQB<p0b:0.l@d0AAuULTkZs,^h	Q[m2H sabR; 3reDV\b.ALN = Q_o0%54 dE h=>Ё`@
 >rea,@q  d (`8t rOD r luogo DF T!B'     #h$ f@ER#:,!vE</ sI"I@5-"̿WpClv {s"k mP0!R/DaB  /$BH @xQE~a(  ٰa~DA'Pa gQ#}QAi  	Pktat{fa+ ueY/ cdO::ly&.2nPCqu_{9㐓!. Y)qA`YE	snOP䮅@K1'56h,mP邆эo ESCƚM9'Ý)dovQr 'n'pom!nF10. !n!k KWyĴ_6\%גPt qIP(i 3G  OA:D0@ $d5m MiBay ba1.ggas$Z) ogC}hi USBژ]$Suk\bC
ZipBP6o ;Terz `OЁvN% ec AН" Fn/?Ctrl TIngl  (OUSA) Yi u`2O mp!l 01aЃ`R7pl Aaп 0Mo@eQנ Bid0HCapa memqX5eImbs"Fl@DQ2'c/wNPs (WLAN){oBluetoothCommu5/ U(j)@sm energZphT1$0&1 N*'2HB*Cad6*(0@o)ol,sp Eth0etW V123e Token RingOE3 IahbyC@B@
taI   aov  CP/b// TD zS^oo  YHiPDuPT  / o  6 / o ,o // ooba c   / o `uY\mo 9S//-o oooų ///oo[ PAs 1 :: 
ro . @% ]ocomp#2S '4,n6E3`
ij* 
 /JoXaX/3i 'o
   FloppybUAİIAd c`Ƭ@(sec.)C velP`F12b 2pz@amb(`Nu up <F1=Hjlp>@rkiv Sya|infot 0sv~ S pk%kigu @1( stll frnl1Zn@ard Annuaa nd` ochsl  anȑ S'ker0 dPR?trslpD'  K!aOB@rt-OaE
n ss	(b -ID
S aoТ
`tPd-Std frutQ !av 7K
byggd 
 usBi=*abrikP+ .J
sbeh #DEsktsrktyg 9Km +r vڐ6 S`;vt0HDD Ak_V Minnes: $@01q5`?@An'@#B
Q  oVljrD;cBnedttlD!v(C-j+eTryQI fri Dg@q nr? du viJPst0x X=, ESC=AvbryNaFDA/ccepaF, V=Mer X JvI pil	c	/pCa yEt
<RETUR> oqm6
YRtt .ie,lj`SeferI  : -> MELLANSLAGSTANGENTEN = N1S@<-BACKSTEG FregeyK TABf#OKIFT+H& F2``+?z=  'fO @%Aoi?Cfel 3t gqL` kA@t h+AO` ~Dstod uGen. Felk0197 AsgF{P|plat  NtPhm krv3?A @`pbygm0 fly5s t6 -dato;r/r ex$(|0YtiGdigooi2-@kl`TA UkN4,  Pr Pr, t{yp
hast^hg0Ca-	rlek (L1/L2)Yd ROM,tum  familjrenummn0Ddeo,`r !Y ttNb ~pqyrQ!]H' 1.z2#)3$4rbinvp ˦3+ (bZ)g	1[


Sek# xIrq.$4$@gaxr#q%Ex!z=ok!ŎvidClmissl l.s Walk0s S- ~P f1jH Add0s li7Aet nVar! D@/ѹ  7neh g"Ccuskapay /G-t!ڱxiƱ=k b!h$2AA:1R K>#Rh	i{wIBB?skyddad
ag

    E˂ˎ҇A!^Ԉ # |? #ig?D܇jGa- 1nabb8If@րn`X9UW}k`ad k$pQd (0): 330@npan 2?0%bX A4Pp/]pp01vir katPo:,t	!قGOk%S(|x ervo-LzB!i @(f%ttrib?ut: IDpx?grobsr.M.A.R.T.->5 GammqN u7 ifin@ D> LܰQ R4d% pm}v~lika mǄ  0'InE?kan orsa@3i ЈP9aHSsNypPO@COm=<s1A1lo. |'Na om =hglmnabtj@Deh ;else- @^uQuayVqΦ >fun 0`ʎperl^7!i HP tec?tTools%R-6-Quicka"q`tel?ge Lp׌mPs Hgk
gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!a<ot. Kж7AompHi )p@1f   Pk`anCD-pP"Vt N
"4oSq HuvudG@x@H: D`+@luAhrdsd D`}e. .Ч#`a]r AN}VSHUVUD!{@Pmaqt W.[  !q>`KՠQ@ild fr0!+A
 GOha0w L l1փ'l GSWN.
X (oF XإAd/bbycgg05P0 g`2///dY5- FbW:o	mC eB
07(b!>=  >Dq8asB1GcgCZ@ktu0ai`Qږafanpkhp@.Fut!L#\tg`Rs p]Vo,sursprung_cJXJ. Vi  reko@ޡt2F	B}c	Vrй`+D,ps`_b@}. A`K4ɡ ˄3w_Bg  &Ӄg`!(g}AyO-kbeflse qm ihђޖflj1ens. Trp  >ESC-QBS RVPw#`'Z'R-WsedMtaGF10@cVi3Fa:+dD1}shxE ASve a 1: N?, MiB;ayCrut@!}opBP5vi B1a 0G (Pyr (h aSB G Zip-=PW As1Fj!Б1. utto NT VxPFn?-/Ctrle j E@ls(USAbmYkd !AA b`nrmstrorx+,f hbbelorlekhPeo2ne Flk paLPaiIfEsio"trqtK ?(WLAN)Bluetooth p/() f-v@ANѾϔmbe Aggгs`hahE%-21,2v[,p$Neyd Eth)& 0	3n To!|RQN"|Unik '@$<QiD K @tus İ     S"b|o Kalib o dp{  F:DualQ.O
o  

 
9
 Fo 
E 
D0!j1s
Aoo
E
Htag *o@ 
* 
VCy emol]A*5 ooe
DI OOKood
PD?[Ne _ : Lapr 9. 0% ]
^klar2u j253omFjOF* &V@1 >I*O! DgOߧ̀U«br@4sadap@$lg rdrjQsnabb0 (seck. F1 Bd StyrPTguen!he 0ae/ \`P}Op e@slaan ConfiguPpo<anafpvt ardQ3!/  scy	WiojzigS%ne@" programma @٠0Soetup  zr w ؃ svei !Behee rswachtwoo1څ
 $X. A=p aatbOgl$$ ID's  	Sm4CP p 	Oau3P$PEcR%mj+p%O
Ge0`g3 gvssvzie2"Fabrieks.Cugz7/);Vref.s:nieuawB8ONc  ExtAcc)uwB ZeN geselec Ea  es ~ zelftGa -schijfeai`AcAt PXvG0u?1I R! a/ 4UBgDAUcg@7n ,DP=0%_
 w 9ʠaKc!: alaal =r/em 	rijsgemaak el;o" /;09
8ukAZ@ ]0ayMLg]@f=S, ESC=Annul"EbDG0=!emJacNee fslui@Q, AQ-f`=MNHulppijltjkp`gebrui0d )jui~Pwnukeuzk@ark^<ENTER> ind 
cr]be8Zo !vol%@@01  0aiX:  -> of SPATIEBALK =>{<-BACKCEVorigl)TABb	#>EHIFT+%%ܺ2+Kq= ykp=t#<B~fouta6r4k p It w_3ge15 F0Mv0reqatijasFen. AcoZ01b`a0.i1ZCu  we   Netv3oe are0#F0MPNp diVbas`e3
 t n0 notebook-pcI/P @.istNOQb;ep*igdooh2L	MЛa\ft NmpALyp6roce;ssnel3Q̷ pp OmPЂP}e (L1/L2`Zapac?i VH^aROM @ -es!fS<mm <E  Hebvrgav_0ideokp&p;b  bpM	m	ra1b2rd3ďe4ahis(gI t}.jne C(_B(ЉwMdzQ%) 
  `D#/SecuibE.aw~~$DFtb%)҆2!dHU2L53Hac-0-*1Tho~_adresrlafwi}snd pao=LTop: zPt<ts e'ge t3 PSBbeЉif  s d1 A:og-  /ޖ"x0zbLe6`NoffaG1Y\f_dقڑD@`ѱ

bo
gAt
wXOC'We nu duъ"N
wil?oݩ""a? Ox
Zl"+1 (b),2G (U0Y ) Аpqwrpn (min.): 30aee&p:L0%Qtoo 4;q{hqo:5broAD):]eeqx/nb!p$32#kvo-IPsEI"
2ހ"qk:J S.M.A.R.Tc.-af@0APP@udh "/)Bloa*+  A  I-7B4kXqc rlpSX8
 Vr!a1&\ is bBsAYohCf#/k, T=m]lijk0pUKQߛ zoFik` dvors:ka?0QH fQeksKPug/zet,r lorZ@¶ZOb$ uswb sqwYfur9h7oud'Hi`!  AQ`R`T`R@&BѴ񡘾 vuaYߐHP Pr@ctTools(*%/D k  p?gsp0p`b TWmE h#M"g$rgβ9b   ~e!rX#W>,P.o(h( o( S("7'EAJb"f }k otraakP)5w sXb tK;?ݳ ]Qʢŉ p1׀frapd  Par౤ˊ Cd-!r 7HN񸆆Hoofd8UG8r@JD  UQ0w`fbia DB1LC5!;i0zow)HOOFD-"RGEBRUIKERS^K  pf"an< SSC  hbwACI t fykgcompS$ajsLQ}0ZP$t d 0Bb&qӜ. @XPpQ~^zA/utompJc4@9	yT `r:ZcY<<|7t7 O!V)?!9NP sN! !. MoWdLioNTCb,p@  #i RS8pò̀QU nt@@Odq K8/ # `hui,H50d@wұ?was to/!wk wgeaГ. PWVA?nvloeC~XkhWSs0n@Pܩ׍zYUdTr!ra=8	2 torH/)К Bget. /o
 s  vBn. O
m2un
1]ѝA&`3fe*& gol q. Aܹ_ӱ_,@cdtabҔh ! Dcㅻp3ruk3!ESC- (A9н0@2i Rb'k'tyUbkn F10@`T*Z lusTB r`V4  Neplg g MultiBayjVzkd@\base; (ks)re  USB	-Մ cb+z6p- ER #we瑟V V@{Zes >Z$>Aa8NFn/Ctrl `Owiss/@p`SStaMcW3MijsappOU e% 0 nĳlBi5j V o-1PF@A/A뜂0d`{dition  G`vgp<uqVpilatE?Bvp neVd$Radioj W/LAN-aoe_Blueth
/oG`rgieм@ qYI1L[,(b!)0ۏ`Et@0 1
2
3,fTozRa/ -OMom@023 UUrtcu!G< 4us     Sa~Gekali@!тOK"r2
NQc ual P\JOOO  EWOOO[B['O0OO H{ap!ң
O$O"Lpier-MUE-$J$O C$Pn+OpO+O  [jp 1 : Bo. % ]A/&p[лd2knte ~l/{	3	# 
fohl/)b* Jt  ;>.C,$ VęçaդXadap Fpr(0sec.)Cpop-up bij sno F12i )Kbb@ cursorytuyEasyP}o-muisG Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe߀ ɿւa\w܂tsfBNɕۑ  ݒOCOF畜>Ăg&f 
H
g  Hꏟo׎ <
ɖE	ύXɏI e `AȌԻ܃@ea L(eA`LCǗW҃p h/do'o "X yf@\̗L/cE%ID&ID: h (uN XBSA$폜eX} 0g J8 23T|OH, @v".eI*"%ɀ;FX
 ؖ>'f
cA>oAe̒  II(f:nA%e> pCeBI;vC"F@ `}F  H D%Jc9J; ڍc R5BM NP$߂Ad%E@U`U:O tB!#sNu %.37($b74L[BR af=~!AEsc=Cq@bsAS60=͂
  <aRAg)gjq5\{ 3gp] jkڂQ %iA@gp>[Ex]  e=ȉ#wA̀r_->Epy`tOo[ = ET  <-SG[BackSpace] xa%[Tab!AG#[Shift]+eF2!,,,10nmF/[%  !CG[  @DBCś}@BD?rp o 01 yNF`+@~3a
ACOk ~ڑKv@&eb~ rO x1X
Mp!mQ^0fGdMEU		?Ȃ2󋽵e`	уɰ   ۾  xï  ށiL1/L2|"`OM οOM̧Fرٔԍ  ޵ ޼ޮ ް ۰ׂ{ްޯ ްir? ޯ*#2.3N4h	? pŰch3(ÂC)FE-3N4(JkvJ" _!nFw 3XcopF?1$qv 䠇sxП6!̼;LsV+W7alk0s?A-1B/Z hѢp^`OD4ߌx:2B}tƁACN %C颴 ׂĎDa/ŗp>쐬AFA:/݉ b>#}v!hү F FSPl	NXWM~@YqZo s/9@y(c  ցB	!H #ċ g Oog'`,گЯ1iNp`2iS3p.M.A.R.T \zsԁij: 30Bpײ>v0% bj!c OK z43 eB~ 'f{:x@	{em`Q1kTz {ǂݨUעfIFIDP. Ba"R`R AFfV!'/i `¢k@@dAJg(B(a ͈DAJhvٓB"̏߼ /  Ǘ7߽@{R@ȄrRVdNJǂ̂*p4u`@ȂaU@C	 !]ţF"^
Yꍇcxei!ݡ£	8龂 ÉƂ`Ƣa7df!f
`?"dHP ProtectToolsh}lWŒTBq#j, .qB4УMmUNu<"T҂ h8' k){-E`O'@OH&J8-.))Tی?D<yD%蕴` g4`dt!(!ċN<b8v"񊰔Q Ԋ'O GPu CD-pu$(3H\@}@^ 7Q: axUKߑ #iC^"c. t%``y 
x7"	3@9>+ VAT:!eN,Bi	.	i	 A!!F	͎2R qĐR`s~񽂩痣HSCۊ"o"F`pAF/'@Aefw`6W 1E<r@߰ XPۏ؊ԓ "łbͯL |ił`Ȩk)/)%)!?ƈ UX3oNu@"*fBBFa(`o(e|~!@#$'m8`X ( IO)F)u
 ((?(9(.㜨gDsЯ}Dv#<43ɑqƈ	{MS f=e|^`Fa)F1j 8fcB  BgB<b{aȑOB%
O#&@H2ef̯ "8먎ߨql`Ӕ5C aU$/g'"wEE[Egsc]1 쉟`}ȍ~elaӫm⛡ThM?DriveLock tO[F10a MS   y_97`E!: ESxtkGb`ÓO xXioi;EcUSB Xp H Zip1ԖW 2b 3 4"U567B8910r Fn/Ctrl%̐ؑ `{`\p (USA) `|*B#fo+X
KV&Ws
v C\g @}ZJ@_ rIo`̢ ރWo% т݊ACY Oڑ͏̧fal"Ni!LANj%MdBlueto#ot/cyj!>`ߓd p
 2Intel  Execution Disable-@++1)2)++odhEthernetX& 123 g! p
AOKO3O >H!O Dj' I+D 4b`K AM      ϰ`@f@R?k ejZ o \(%*nP/h/!!8!MEUt $)o zoooD2s!5bv1 : [ds . % ]O<2 !gOnv3		@)J*   5`$>s'pmj&vSpeedStep@ technology
u'"( 	_Ħް Ӱ # px(b) 3F12QԁibyH a ^E`PbZB  @d                                                                                                                                                                                                                                                         K  ` a b c d e f gt" L         P  	 
    ,  
  D           ~                    n  / 0 z  3 4  5 6   ( )    , -   * +   mp
 uN % @.   mm $ + 1 8>E K RXm `@E<B7B<U> FبE0`8l v x_|v||p0p7c   c 0A   = ~ 
=$$$<   DDD  Q O aƄe  i  o䔕 u  y $n%Ap E%0IC&O p   U `   Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'/@ (#jodߍ^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] σ} !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'o(

C$: | i s+'()+'*&83&

OO
\?()|O276'6 -=
^~+]}@`pZ';+(:*[{s\_}\|      ^g|mA  _m^@  &.@  bm@ EUD @n}.mL@@ I mp  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
m9 sdmxcmRa em?gm@@p < f+m@W{Xt|dU Zt}[}#L  ]~&  W_t`$itVaV!
	$
| 	 
U`	
 `
U`
fabUcDdeDf4Ph(>{&SL_@!@   U @؀
 j( 
( 
r l0T |n o_ : *R  	m$ $ 9 D VF10 Setup Image_SETUP  !D	Sq  ; 	Г* *v)@J$"P a|` 6
&$`ԩVC ؄ TԫUTԠ*U<g!"$8Dcz: 'Uᴳ4㴴4U崵d紶4ՄD8b_ : (m
6  U($))$*U*$++$,,$--9 Ռ-g U 0	`
9 a
E#8i3jG@ #!" #" #" |
8 RMNLNOO 8 @
:	 
  P    /	&Wc  b"  N  % ]   N''U!(( )O)UP*Q*R+S+UT,U,V-W-X.3V
mUd-dh.h1diUi2dj3j6dkU;kdlIlYdmU@mCdnDnJdoUEFdpGpHdq}5 ajmfoq$HrHs $[b{̠{`{|`|$|ܪ`|`}}{L`}8}B}. ~X`~tu wRx~Uz{  }􎃔H kv 
44(F3)]Bx`oU2您T$\` J䇧0L'\tU ;U
敇d @9S ڠGxTnxL*@ U4 : N j@Uz @}L0@ UR h  @U @_L @ , UB V t@_( L @5Ԁ@@ UJ j  @U @_L$@ 8 U\ f p@U @ր} L@ U2 L d t@U @}L6@ UB b  @5ƀ
 
@ U> `  @}
	L.@ R    @
L&@ 2 < H `@p @Қ@@ . F ^ r@ @j @@ X x  j@؀
@@ X x  @؀A@L"@ : N ` t@ @ @ V p  @ƀI@!@ 4 R U`@z @UȄ @S@ 8 \ U @}  L@ U, @ b ~@U @U @M@+@  U( @ h@՞ @,T@@ n   M@@&@ X Uj | @ն @T(@ `   M@ @@  U( 6 >@JUVd p@Ւ @T$@ P z  5@ -@ Ub   @'@ v j  @@.@ h   @4@ d j  @C@ ` t  @Ԁ @L@ 2 P n z@ @ @Ҫ @C@   8 L@hpz @ @ @* @JS @Q@ J ^ Un @5 @!@
@ U6 N f @U @} "LD@ Ur   @S#=@ n  5 @$S@ Uj   @S%@H@ f  5 @&Q@ U: \ | @AB@'2@ & 8 JT A1jt U@ U@ր A D
( T . 4@>N`hUT`f z@ @ )R@ v   @* J@ 8 \ p @ @ + ^@ f x  @
,@b@ h  ª @܀-Z@ L t  @j @. ^@ 6 T  @ /p@ . h j @
0 L@ x   Q1q@ A	  M@2u@  5  <3 A@ x  @ @4B@ 2 B d @j @ 5@ 2 L b x@ @hhhhA6u@ H \ | @Ҁ"@7Ty@ r   5@8@ %b  @ƚ9n@ <T  h @ h:<@ V t  @;@s@ R r  @ƀ @<@@    "@@^ @R=@ h  M  >@ j U  @?h6 R z@ .@@   Z @Ah U2 L b@pU @SB@ N x բ @$CT@@    SD@   M *E@  5  &F@@ Ո   "GT %@    SH@   5 @I@ hJ \ n@ @Jr@ , : L P@TX\ `@dhl p@t @& K@   
hI.hN@h\ Rhv@  Lh"R N@h| 5@M@@ Ur   @S$N 9@   SOW@   SP j@   M @Q@  M 4R@@  M $S@  5  
T@ U\ z  @AB
U@@ * V hA1J @h hhDhhVH@ h6 >UP\ b@tU @@ S W @ : V U @ĀM X@ L U\ | @ @Y@ P x j @ZĪ@ : N l @ )[@ 2 8 UF@bx ղ@ր\T@@ D T p U~@ M@"]@ Z U  @S^@ J h ՜ @_T@ h   Rހ @S`@ 8 P UZ f@|U @؀Sa @ 0 D UV h@|U @Ҁ hhhA b @ < V j @"Ѐc @ `  * @Ԁ%Sd@@ < L Uh  ̀ 
e : b n@ Z@f U( h z@U @ʀh@ր  g@@ z   @ h @ t   @
i@+@ ХZ x аj @ j@(@    @k " .@<Vb t@Қ @l@ Z |  @ަ m -@ ^ j  @n @ f   @o@@ n j  @(p
@    
q2@ \  j @rR@ > R@hz @j  s@   " *@08@ HJ@PXhv@U| @܀ 
,@t U4^n @Qu@ < T Ul@ @vT@?@ n   S2wJ@   <x@   yT @ ~   Bz @  {@2@   |TK@ P@ d  U @܀AB"}@l@ F V  A1 @h~Dh
4DhV)hn@x~U~ @i@ Ҫ@ : P ~ j@Ȁ2@ 8 Z l @ @4@ P p  @ܚ &@d@ lR  h@M *@ * U> d n@tU @Ā5  <@ UR l  @ U   @SA@ @ \ U @΀ {@ ^ hp @I @ ~ h  &@ a@ . hU<@Tb| U@ M@ @ @ UZ p @)h@܀h@hhhAS e@ $ : UL b@x"@ҀM@ ^ j  h% @x@ Z l   J @h S@ D Z Up @ @T@ P ` n Jh Ќh @@ \ j  @@@ d @  Ț  j@ F T d @j @ \   J@h@h $ 4 X@  @ b   @覀@ b j  @@h@ j   Ԧ@ @ V j  @@@ ~   @@ Z   @ހ 
 >@ 6 R x @T@hAh@h t@  ( : hR
\$ t|@Щ о@@ B Z x@ @@ R r  @؀$@@ t    @ lj    @ h   @(<@    $@@    @@ X t R @	h@h0 T@xDІ@hhDhh@4Ah@ @ U* B b |@ը T@ b   @ڀ T@@ V p  ծ@؀ @ X x j@Ϫ@ V v  @ @@ h   @ @ > f  @ƀ  @ ( V  @֚@ V v  @ޚ]@ j   J@ r  @ռ  T@@ > T b Ur@ M@ @ V Uv  @S B@ R x U @hhhA@ D d  @@ H p  @Ѐ *@ ~   @ @ f v    @ @ V   @ꦀ@S@ F X t@j @@Ȫ@ ( 0 :@>Jb ~@ .T@    S(@   i U< T x@5  @@ U   @iԀ  @ 8 D Z rj@ @ ^   @$@ b j  @@ r   @*@@  j  @"@ x   u@ ^   @ @ <J j  Шպ @T@ r   U@ƀ U@ S@   U$ >@FNU^ @ @
ހ ( P n@Z ( UR@| 5@@@ Ub ~  @h@@ vj   ̀@ j    @:@ j  Φ   .@ d *  AπQ@ Ul   @܀CB> P j z@A1@2 hh
hQ0DhLlr |@Ќ @ؚ @ :@ P |  @Қj@ L d  @j @*@ F b z Aբ T@ J r  @΀T@ N f  @΁  i @׀@ V* l  @h  h$ * T @j @G@ N p  j@ @ b   &@ |@ X hx@ @
 @ 6 H j @ @ J n  @ހ)@@ V j hhh~ @ @ 8 b  @ ]@ B l  @Fဏ@ A%6 UZ r@ռ ΀ T@ ( > d U@ S@@ N l U @ʀS
@ $ : UD L@V^Ub f@r5 @@ UL |  @S C@ f   @LAh@ P Ub  @S耱@ j x  @вj @@ ( V  @ꀣ@ l   @@n@    @@ \   @@x@ v  Қ @,@   @M@ X   @)@ J v hU@ @ W@ hL h^@rh|R @h @@iĪ @) @@ < H 
hX p@xh@h@) @ ~  hվ@ԀT@ X z  5@@ UH f  @z@ j   @(@     @     @ p   @ @ X z J @؀AB S
@ : R A1hj D@ hDhhh4@i0R B J`Uj t@ո @T@t@ D ^  զ@܀T@@ B ^ p U@ @C6 Z n @  \@ J h r @ @\0@ < J P ^@d @Ȁ@ 4 N ` @ @\$@ L v  @\B@ T p j @*@ z   Uƀ @_\"@ 6 UD d |@բ @ W\@ , B UX t@ @W\(@ : D hhhhANj @b	%< ` v @ F@
 
@ %\ t@ @ \&@ 6 F V l@j @@ > T n @  
\@  6 F T@blr v@j @&@ \   ܦ@
 (@ h   @O\@ @ UX@ M@,$@  U  @ހ \ @ 6 > L `@ @$3@ r   @ \.@ V ~  @"\R@   ξ \2@ `   @@@   
\*@ Z   @./\H@ | U @5 @ .@ : J X@dlt |@ @ @ #@ <J J X 
d@%zhЩ@AQ I=@ 0 H Ut@ _\8@ ^ U  @S( C@   3XN@@ 5   @ 5  !@M@ 5  ""*@ 5  &#9@ 5  .$,@ Ռ   %T@ f  ƀAS&o@&ˑ8 hA1A@&&@L hHDhp@ @hƪ @' M@ B n  @(\@@ |  ޚ @).@ P   @К*T@ @ h  @Κ+ T@ x   @즀,X@ V l  @Ԁܚ -1@ N h  @ր. f@ R ` f @ʀ./m@ f   @
0 o@ n   @$1@8@   F 62 l@ b Ul @ @A 3 =@ L p  @΀4@w@ N l  @؀&"5 v@ H h@hhA\Uz @5 6@H@ "H t @֚7 t@ P v  @ 8 x@ d   Ā
9z@ L \ $ @j @(:)@ Z p  j@̀;@ 2 T ^ f@ltx |@ <E@ T   @"=W@    > g@ H* z   hM ? r@ P 5  @@ Uv   @Ȁh @A  2 R v@B z@ t  ަ C@ z   D@@ f   @*Ed@   ަ F @ f *  AG@@ 5  H@ Uj   @Il@ h@ V x@& Jq@ D UT d@lvU @U @U @S Ko@ h r )~ 
h@fд@A.L@ x  h@MT @ t   @܀NT@@ P j  5@&O @ 5  P@ 5  Q@ t   &R@@   S@   TT@ B X z U@ ABU @ P b  A1 @VDh
,DhDUbl z@jД @4@4 @W@ UH z  @MހX@ R U\ z @5 Y@ UB V v @U @SZ @ \  U @@  S[@ L d U @Ҁ5 @\@ UJ f ~ @ƀ ]T@ N Z ` Ո@^T@@ 8 b  զ@Ȁ_T@ R   M@:`@  5  a@@ U6 H X l@U @վ bT @ D ` | U@ Sc@@ R r U @̀hhhhAd @ V t  @̀e @ T z  @$f@@ r R  ހSg @ D Z Uz  @h (h@@ P j  @ʀi@ B r  @Ъ @i@j@ v   @k@ h   l@ R x X@Ϣ@Ԁ@*mT@@ x   Sn@ t   @в @o@@ B j j @(p ͪ@    @4q 1@  ʚ  (r@@ j   s @    t@ n  ަ u T@ r   v #@ Z* ~  @@wT@ J n gU@ 5@ƀ@iU@Ҁ 5@x@@ U ( L b@_L~ 
И@hd h
y@/*@ X ~  ղ  zTj@ : X v U@ S{ m@ B r nv@@8|4@@  } 7@ 5  ~ Q@ 5  *@ 5  >I@ Mƀ @ x U  @;@ V ABv @ A1 @@ @ d vhQDhЪ @r@ @@@  4 F h@ AT@@ R x  U@ M@z@ 0 D d x@ @ p@ P t  :ZLj @<@ > \ nSLf@r U@ @ L D\|  LՌ @T@B@ : l  M@ @ ` Ք  @Tb@ N   @_L * < L@bv @ ښ@D  K@ B Z r @ @}CaL   hhhA2TA D b@xU @΀ " @ ` |@ @%8 T  @ @@ 8 HT h^@ն @TM@ 2 B N 5l@>\ U@Ҁ <L?fL @ U" > l @ծ (T1@ p   @;@ hXR l Ж 5@ހ@k@ Ub   @̀ @ * 0 @ N@rj @@ F f  j@@@ ^   @
 :@ Z r  @"I@@ ~ A M@( @ | 5  @ UN r  @и @
@@ D zoLP ,Jlt sLz*  @ @ @ @_KL@ Rm$ h8F@hI\ Ѐ @
$ < T |@j @ O@ P p  j@ʀ"j@   
@@ ~   ( @    )@ |   & @  Ц @ @ V v @2 AB@ * : d A1U @Ԁbhh
 h
 @.4@R H@*UN@Vh U@ S@ n   @Tf@ B b v U@ M@@ P Ut  @S@@ Z  U @S@ Z h U @ @T@ @ d  U@ M@ @ N Uz  @S@ F j U @΀S&@@ p  5 @, L@ R \ l@| @j @ X v  @ @ h   @؀@^@ hhhAT"@DdU| @ 
", P f @j @ T@ %j ~ @ռ  @ N z R@о @S @ B ^ U @M  @ P Ul | @ @hƪ @AT@@ r   M@@ ~ 5  @ H t @ @@ ^   @*@ `J p  В 6Ѐ @@ n   @@ j  ƚ @$Ā@ j   ŀ@ v   @*@+@     @@ j    ת@    )@@ L | @RrLծ @T:@   h2 U@@HPV U^@flt |@i @ &@@@ * 
Е8P Z@j ЀA@&̀@ 6 U@мPx_!L@M  @ D Uf  @M@N@ V U  @Sπ@ h  5 @Ѐ@ UP v  @Mр@ ^ Ր  @T@ T   ABԀ 1C hA1U{@%(P^hDhh 0VWL4@i @[@  , N h@ @& @ z  j @ Ϫ@ 6 L r ~@ UC, P b U@ M@M@  U8 ` @ @ T@@ 6 L ~ U@ M@@R@ F U\ t @ղ @T@@ H j  M@ P@ F UR p @M @@ j U  @U @M @  U  2 @@XUn @U @S߀f@ ( : UL b@thhhhA @@@ > ^ T " S$M@ h   @ %&R F A%f@J% @%S
 @ J ^ Un @5 @ p@ U@ V j @U @S倉@ , 2 U8 >@DJUR X@|5 @@ p  @T2@ x   @2T@ T r  5@܀
@ Uh   @Ȁh@ n@ & : N @ځ@   =:J@    H@ |  ڦ @ d T @@ p@   ABBꦀ@@ ~   S@ t   @$ G@ > H `@|T ր S:@   U$ *@06U< B@J\Uh p@|U @܀
h  A@ hI h0AQR@U~ @M@ : U`  @5 @ U\ |  @Mڀ@X@ \ Ո  @T@ h   M@@ t ՠ  @&Te@    M@@@ V Ut  @ЀjAB @J@ 6 J A1j@p hhDh@@O@ & @ h$PnPm / /          
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй =_s# hNfP u	fX@  h _ZY[Xg&ۅF ;9   Ã tfPfS
u	p  4af[f}XRg&u-g&
pAgf&A"f,  ,fUvg&Ƴ,9g&PESWVfW&O*f%,g&D= $ <vD# D| u:tw'_^
QRfU

}0tCR>tK-tE$fu
0t0t	dpQ  f]ZYPSRi u-{]r-&-sG tu0< 0
Ag'fA$. +"(zwZ "P  u
P! 3 t
 SQV3Ҡ---  :-tzffKf- AƜ(Y)9wfP98$Њ;`	P#X,)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>BA0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
,D$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	V, -ff@EFt!hXUgvuN>tO6f뿢, Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% ,SA _u,# XA	u-->1&BZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@_))FbfDf% ffDg^Z# j00f 4sp*2{ÀD6^U^nBn@& B7ӥi({Pfpsf
  @WXfffL:0[3`'E8q4ж3U? L؇PgOS?NYYYYrZ1q\~YZ ЍSpk< w 			;/eE1`eR#tZVoQ`C F%frQfRV-u/	` 	R
~>  !P # $ &B=h+( Q Ơ  f3۹ fbdTt ` t0Q ?\8ZFfCPŧ@sw$<yk{s>
p"o
d
\9VuO@S1?"U5`,UuZ苆FFUu FQ$-$?G^f  @s++~g^D	%߉D	f8O2+f<v PfU I?fPIfffa$f6f> f	>fBf@)ff]X߀ t *rNԁf_x@R@Ӄfw3 ZpbЃ>/ t50 A0U@@!p0 ҳ
@lҟWRV6[S 8f;tff ' F#4?^$u qcf gfEˀ>  fù fQ@;t)gf+ C k#@;`CaM`dWk Ѣ}wR7RPV0  ^h0 ;u;~ ;b4P4SXf.0Xa0. !"#$%&21/-,	
9
+ '()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRS ݫ      Z *8۝6TϷ  	Ad  !
  	 0 ! ## *     " 2 r	 .>  B
   ,1    8     K   S
+`,&,A!Mru
o>, o  >  t,,,>,,u} ,"_< tC2`r,:Mb,,,,ggQ	`=PL`
e3ۊ؀`,&~-,w-g3v M,pVS`@t	Vm,[^PQV,0ӊ"@ӈ9,1,Wf u5uqyߧS1-,5,,-[^@sfU_>
-S>->-G&-t(
ߠ,bވ',%,=[:QpQxVt>,, r1߻,w%0r ",60}S+,  g6bdhEe!)) `!Q	胢pDt1,8h[R-ZJr-&-, a-PRVqp!)w7p	O* 3:  , &},g&&@v@ '1&s0 ,i>,y ۍ$3P w% u> &
'
u$uvatue&u^\uMu:8FPu)ttfpFg= IL^z1X@8! u	g&AFtF@s|S,X[0|SRV#+WC^/'ۊ˻
1>qZڢ,A,I,Q,Y,a,i,2.RtvM,xAW>pI,SRA<v
T-,-@,ʀ 7ߕ,G&r )&uH¡I_S	
I",,,:,w/=,!
ľ	cdx
	,rg&5tU,x}r],_drէ!"E,FKr?
 Jt x Ztĳe,=2oxLg13
	WupePaD$[X[Zd,_@[@[,_1OGѿN &}luBSQ -f3f2̓A,fwf3 =0]-dF E *  <Fu-3t	 Dt<Hut25t5 y2$u tPX- }- uB<Ft<Tt<et<t<t<Rw*<Ir&-
2rt5>s5obqur(q#VWpӄptAQ ft(PǴ:-u 
  gXfCYv q9~ w2-k-0t&-8r >tw
$_ ,-9-2 ,f? t<C<tSQذ&Y[0u
lq.&
d  & 
 R #  DH ! 
 6` ёd %#t@ ,Xd& "$hB "8@
 . PF <^
 0$,L	
 2)Pq P'   (# P4Pqk 	  @
p	 uP	8J8 }@) p@: {>  * P s%Q R!	R2
X "

 &(xiQ)	(.0)d )(b+" +(P): ,Ȼ2	*z0, LU(($!pU'#	'$	#$	 T*	&
&
"1
q,

F1(AhBFK4CO''A,A
/	
#	&hE$
$
A5
Ip:(|:!TMt:BJS'y'dQ$> 1#uU#!,)$3+Y +F'Ya:Fq=DA;( G0$G"]\D#GV9/'ANd@CN)$
$Qa!q>Q!Hr>PRBSRAh93e$bNL'UnaoM#uYrQl!%Ai
$
$ v(Jcp(dpy+t@
 >\c8Kss'tsv Q:y$y!`!4F;	(D@a䈣!blxW'QJ#&@$q3$n+$3	8q//  @iv
 v $a #
 `"9	 w aZ izazzT
 " /	 !=mKap{ 	 hw Ѐ Sz
zPRfWfg&f_ZR P ZPððð  Q|@0 m 	`@  a1BB r !^B !;  eTfgdbEEMM\^_o_xEE UWRQSPVrwCt ur6ffWRfP0 eXh+( Q Ơ fZf_ >Bu2C-aPSB puBB` BBWB/BBD[XF f sftwfఖ  ^X[YZ_]e ÈBCԻB@B  C, j0fdQu!B! Puddfod԰  >P6Sd dПdP (B CfUg&t=` T=f]t,>@u%ttt t	tfN tƀ!r]@u_al!s
 1Qh 6KuFk . u$
SfQV+eS tKrtـ?fPfD`*f f0T fffXs "
y#up`LeB ` B uYf3f` feBKfWpe*&B8fw*fF*2t*܊e&BfX^fY[f`--''B +"  Āu!g&pvBa  t8!a%faSQVWU&- t- i]_^Y[LS-120ZIP 7250 RV:1:2:2A2PKp
˄w
x z
\5	BdWs!hEfP u	fX@  h rg`/;<tV< uWQoGfӹ g&:D= uFfG(u'X!X  gHAZY]f`-u BQ-BBBwBB0 RW1h

J} tEJ4/_Z[M-Sys   DiskOnKey 1 #aB- u @  f<x fP f_I"~%|= 2r 0w"1s sU3IH t_ gf&RfQ ff@fPuLst6Lu2r)g&	ug&g&ۍc,f_7 PA	% rLTf<?T7(QRRVTcF5Qo~me}Q2?0;; t0ht3t@ u gu#P-3RAf?LfHS N 
1fXuײ?D0 @0B0B0JB0B0G05F6F 	 Ϯ&3FPRR`o?3W1>ߊ#>;!2>
(1_YGh|GPh`p& 4  ߰h*<W SW+ 1s!$?
uo$˄[         Ұ,X @xnY rTBM!r5@  i|X  tk   ` 	bhwoddfHffMf[rPJf&nh\ufnw&fy ` ffMfP   $_Mf%% @@Mf  z6fHMf=A&  `  fAV_fLaDf=%t 5t;@3tZ0_tZD_fX$0g]M  :MI:MS~f@ ot@[|P:M"sƑ tDf  f q@Mߡ:M<<Mf>M u ` _D  2ft.r@^#rf6u$ M@s11 >M@!R0[M'r"b"q0 f!?1VC@f,S	  tX	"riH'	"	0 %9 uf-%tq00 P3$  J 	PM|tpa '	M X1  rf 
 pQDP؊*>M@6P%f>DMgGf	gOg}G]`db>td"3	0	n5
`6@#Du	%&rf6DMf	f >MfIng^g׊~W!
*t4h 0A		0	  FFhiJ<t
 &G5"pu
 "؃ CG&G<_M&GqN&ibLҠ6%@( 0Mf (f?( 42a3uf6MW  bf+8`сawSgff9Mu gF9(Mu 90Mu
gF9<MtgNXfF>WMzr=БC=mPrxi?GsVfS'`c(gF'	(Mg^0 g"G0gFֱ V*	 /e*eP`d&b&g&g&G
G
 d0Gd*PGg&Gg&{G
 G 3gn Fp
p5t	f AkGF^ 0\PfV csf@ܲmdf p^fIf!2M&*M(M+*M(,M0 2 4M < t,M  ;vȉ.Mqv  f@
BqygfgG p ,gG
	q?Gf6up"a ?Hf%ofE@* !gG!&4M,M t@(bk!f#p.F❪cn `_fOB'*PR7з[f=S
f35 !f$fӃW\Qfp#{-  !Siy `9At ````aJ`b	`c	0]	0^	  
		  
							
 0hfWQ[f`1Yf_`QD=fBD=BWD
$>B%
ĈD
Cr% >BbASLsdW"CArI`d
Q/r7R@|= USBSug&|= t t
U	 	`CTܾ *Cơ p arQr C0 % P`W`2|P>Bt Q?rIt2QfF`AdY{rSf]1fM^!WA@4XH\
؀e7܉\bJ
porA
x @
`DX!?
0
ޱ"ysTnq
aWa'"CS# iD=qqp*W.?43'ЫT2'n ^oZ(ڒZ
2(
_7
_=%t9 R$RS$2Q	@ ?\@RP2 3* h >Ku? ᠅ T=
XS<(wfT= ;& y#j6BB- r}QtA3`>B{Bp+` pta^Vu6 B +.\f.6\OPpYfX`\I|G<B fa>9b?,B3zU+*/G/~%QfPfph`1@YfXY"ϵN0\rΐJ?;G7/Os~c`Mo^DABA<e=S$l=^38%rpBKt Kt KtBD$
ƈDFP!r r
9rYdʿ /p%stFPtt=tT= t2:t+u:u? hNodty(u~(rt{^@K=@tK=tK=`	tK= Kh)6`oXaPSV"C8dtd}Ơrƀoƾ*C8DtD$PQWPhƠd^[XSQdWO	8t`g	G	Y[ - i8   '`  8 h
   0	p    
		
							
 

  "@6/a5 B6B
C-_sRIEcR&˩Be 1s fg&|tEB 1%b	 	6	Mb5bOA5b`=b&Br@seWÖ`oޢbpŧ RsQHS r`Q@QQQ-QQ&p\W3
	#[诘rgA{ೝt԰ÛYe?Ĵjrjtstx6Dtq=eetOtesfh~ +0W~~	~	~Y~~F
,}}}T `Hù !sJ%Otdoo%"o:u2;qqq!(~rgpppp2opQVp%bL	;t	wĿPA辿o=蟿[^Ypapp\"I 0   0    |Ro d    n  A` r 00 3`  
& Aa % N 	%
0 #
*a
| 
3`@& <a` @@ 
b
	 CF
? ?a	  " d q a	!? % %@%
R +3F	 
+ (E+
"3$ 4̂  C8$+(3+- E-(C -0294- (`(E  E3 .c+!  0
 @/9F. 7'GC@<6A6D
!: 7' "J",A !E?9B@,3
O<bJ# 
 S<R"G 3D%M TVaXCJ UK8'(X4AIc  WI kopqq rrCopyright (c) 2001 Intel Corporationf`@ f.@M<t<t$<tc<tK<tSnf&nr sfn   uh   uRfADf380=ISGuђ s
g]n~!t f6n	pgftcRa tpt5Hr @u  u u0 ߰# 92  u
P f%63 
f>>MfDt	u)f>MI;>Mwouf@ffhiUtf3ۊf"Qt
0fofs\
B  v@#tyz21݅~!<ugb


7	u\	Q	'h/ś_>MKf6DM	g u%S F:M s@[%;u!,'f=4R0	ff4	)ffp	Q(f	f'@f[aSfSfQfRfV*sWr15 uBT tApNC6g88fI4g^f3f@70-@7f^fZfYf[fP"Vf~
Mf=`Bt"f=Ё &f= P/f=0ށ 3f=@+=t8_t34 , 't"#
ttfr0 rfFP0fXURf.  fXr  	 Qf`*ufQD8}@M TR2p@(2Of2f0&cBZ{RO>V\3hɚ+( ՑQ Ơ uf3`_fbDf6E  =Z<tatG@]_ToK<u	RͨupWJ$< t<0t$ RHP?ky"PWT%j_uPlAP#,RfWPR;>Mr/fc%1f f>ޱ=	f!Effg8uU#>_444
f@[Jf_,,PSt{w&,G1=`QYr;f.;vt3UufӔvSmpfAzffm~ fPtP= v	 +v:P,P}vf́   :vfP ݋ 6v1|Ã tL;f ǰǋPtv Q.vBYrrf u0`b h+-Ñarffpc_f`f"0~ffROMIfMAGE@;uq Wt#g0 yKPQ (J 2 ofG f_ZYXug&wag&GhG0  "2/t"t:  V   scu'[0i&w zj3
G94g&GGfԣ f}Cf-+Ӹ00pD;gfg@ h쀀1"`W, `П..`B@ԑ
>t1a"pR ZyR  ygP&abpZ&&ĢFdOR< uQS_RpBgtXr),uRG`SQr9R'`$8tYOtr$V簄O㰆HAr(QSFr{(!sq^trp@۴ppq9P`~N `4fq48 f܀?g'p!>@  ` FFBZY}}`b j nb PQfWfVEwUU&*4P U 'hX.7['PG 4 .;|t3_YXhw)p  $`p0 	׀pG ڿ  m' tJ@4 "`".ߒ-2(.| |80 0AW
sfUgg& suf3_ɊfX^ptWfYўfWs^g_<t,ofUgR r!8tfGP0PQ1_$@a@8tճP1UvP~F X PS2O&w~p u~؎[XPSROw~a@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   `t/ a3S#[C vS3ۀ> tt#t:#tC  [`蹸t<w>t8t aâ> u
 
?.ñ a r gt3C,% #.#쬊#寬-
 r3쭷!ݷ<O8!fP@ &^$r! 

A	 fX{ ѷt
t+3jgd
uA
 /t1-b㋇$.fr
Rbt0
< t?
:@ `_  $a`> u#t$ aÉ_  H(

p(I( J(@(؃@Pm(f(2s3y@si  {Y 11F0  	:u;npu;thPXP 0!   u0+K`{:u~r:Ȉ@&u[  OuA 7 &	&%0ww
2:rp	T
À
v >̀<  #22Q# f`8P%,Ⱥ:#%j  t
ف     t(  $Xt
 %@  Pé t u>u 7  tP @~ 3 %tNtGf3ȿ fff3u@ fgf&fff#f  
f΀*

 XPfafPSQR.Aa#؁ ~~t%=s	%Q#Y3o#P1` t
ff
 fZY[fXQ
hwe $u%fϳ d`u
SQjuPk  `15  t eh2GfP u	fX@  h $  Gog H dt`KuaR$F
 c$$%5`0J!Q QÀ)f(f#"$) 5 q 0f t' &
 ZfpfC ++3-`>Zu
͹PF,q{f 0ZYfQPSw#4@RS#Ti T}#hP4PQ RfCx1A"5  "-#4 X--##@*3p #؀`5@uR"ttQ@t
1
"u) z) aRfWfQ@Qt2PtEOw Np  P+GhD5~ yQ ^ /:3 ; g&G4g&tCf<ft.fQ>A q=A   u1  dh2)
  '   ؠ--ohRCa)@$#4"f_Z&fW b
f_babR
p  ZPQu4 pyKqb 
YwR0R- h"$:	
2
~c.&,g t#.,gc' T
.t&*0 00`RVh_BWtDh^dYhv5h{w7r2, f^fZf`2 =rb2 <@vTrshfa{f`!X
RfVKPf3a//`ffPcX/f_f!7"" hs{Qgf`/)
4/O
\ "	 	 Rb"	k/	(	!e&!_!!! h<$h=$9ZwIyG	q߭fxf0&u 2Rt F<tP$rf@03dKtsfQVWXv 0 _^Y}Tf  Dfq6ffot
t/%S/ygf5rSQ?f  DP s^ЛW>WVhV?dr=ыt
 t
@u	 ¯ t` uʋ^_fQf&:Eb3:EF c6W p 2:> u6 GHt\o hk/4T3Ҭ؋hB?^_fZfj
XK̈́
>
2

VT->T2@OHBp
Nt.
Or&   +
,1-,/ faׯo/ / /  O,<RwS2.N[ø  аfQh*_fYnщ ;aEf3ɋPx`0X&G     &Wft ffBf;Pgf}ww~rtwRtpff@OhDjp3QgfY tghom#.a$%AX0Y[0U>aPS ?2hįWh`$u2f[t9  `    *࣋6U&Qf=HIBMS&@ u_Ff! g.9u
g.RFf0Fo "S7f= @t1pu  ÷ PFQ Of a Ѐ| a!NuFgf~fVf  t
fP#fff;ygfY#F$AV f;s	f
	  fV2~(F7f ) f+s
0	@Nf;sfȢF@	rf}@f qg&g&fFfGgk`^N &Vf fA=uTA$<ufIg:!
g
@t~T	f@f t=> uge *>p u0hv^#_"3>t;*t3tP 誜s BtӜ PXߓ>*p 	du
)dP
` u9 5r/<t+Wt&Pu
$&Л;.JaP%t"\tq2!tn` "G Q !ОDޛu|u>&t鈐@J MX 0 &XX
À>ڰ 
8s e  
t V$<
v
ط  ' tǀ>P t $
ؐ &h?UŊ$(
d tP{ XR!  ;^hm

]d]`
@

#
P)rÐ-u P&QX PQ>Q u
8w z߀4
A 0ubZ L@Rif>]fp\pNf ajfyW' @/%~jPh  >ft	` (f%ː`PfWaDGԼX<t<t<PS$<wR .R 
S   6   E` mTa c m!~	  [ S&%fmmmmkff{U&kfH+ '%k0{t²  j`bff3fUr  軷fP񸜐f<`)ɾ|<w   a fXf?f
`}
E
ðG	 I  ?Pĳ6
P XuBDVbS!m uli B [ED2P >X	@2P2@Cˀa		$

Àu
<X[X )a؀a
2t P@<KrKNPR9 Z` .9  BZ s  ""
ZPpD`S좆 ߠ  Jq vJúQ R (
PBX
	SRذ4ZaQSW 7L_[4!!!!!!!/ / j 3;CKT^|3=GQ[f h S[z<ENWa~r8<AFJc| !à@ PP q*a_RP,:%  3` U@ˋȾCN  QlѺSWP633ª30  
@|f rf_fj"ZUfF2FR>'NT>!t"ffvfXfD X ѼfpfufT0f M "  0I0 F@ +fqPFT  Hl
 
S1Hh JP,,T,uΡ  j q$% o!m 	
;s% %R ΐ,n%,-'R ,r 4'Y;Ͽ;! )$3$G$=$Q$}@r
_'17O'j 
e$% 0d0.>`(Jz  hd M (JXQWк
bٹbٴy ;{_}+z ٹٴ|"?~:ðL'hᰀ愿薰谺$ tpSu%th/uCr>a> u,0
?m%@u3
 
:[Dm%Pۃ-ݩ b{a`Pq` 
 "0 L+  К Y&f`Dy_R t5fBJS&Y&f[- fa}CTNI kS&AG f(fR3  v03'>+P3'3'2s 2cۼUV<22 P`X? ]$z pog[.@@>!pA^]{2 	V?s(S rs.ߟ'/grɦ.t 6~ru_hV0>ߜOhT2f.f7f.q _hż? ;  r躟. mb = o~h蓪u@ hO_).K)/
03!40+t
3NO+t3GNO UN])V)])Nd)쪺P aT])SRd[)``$fӃ*@[QXffXܞfX*fX>ahht~W yQ  M (>uuu&gq q  l%?[hk_e$P0X! hfh(LxL	@MPA608N4/J7DJҡSvP+F X PSÑ&+&+&+[XPS
+++O9H587,Np&,,$!M_$NwPNwS8rdd r}S<dr
d2t۰7iSt诩K辫Ѹp,oް覫m & ޠ@p0ߊ&?膀4Pd t+Ð                                                                                                                                                                                                                                                                                                            /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                騨!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( ((     ښ  Ւ  ς  g `g  h }  V  ;p    / 5hل 6jۄ	7
  S          P        (  %X%H_&                                                                                     `*} ` Pz*Q@ U   @U 	@U
 
@UP X@UYhi j@Uklm n@eo { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ л=/`hfPu	fX@  h  fUf&paf&>۲` 6a  !X[ &SP`\@ /'aߝ&&@r
f3fgf }f3fh   _@p h &ïީf`f1fffeWf   % ŀ-ff0M00!0)ffXf9ffaf 
  fUi@] 0 m uq  ,f5q f~^PeP Q   ͪAp  A` e׃fama  !6>eуp Ń ՃPك"` pew T	
e} fe&:` b "jeɃffefAffgd:ugdfepf3 ~gCTʰ "8fF3ۊde3 
tdg	  p)O @ 
pezu{xu.G_RT=C u:/
'
%&bfgfd.S` [WP9A`XP&EX% &E_YǨ dooooǸoc e֏%?}SΔf`PHkIa  6&P&`WX 23v
``.0Sr&&faõr!Br  Pq X
䏀  Pf hE3\ǰ Xga20u쨀t݁	<u <u õr$Rr K|&&Z2qrr]rN a`z7da(Svx^Q`es"" QYaeWP  r&&0߃` Ob 
y' P"S""F"&o&2a 1bR ~ ZQRr3'H2't2ZY`2ٵ/t"5߀ tt(TZYa~r#S-EnR-Y03!pٸ q4 AY f & &EZP 2 &rr8t32估~.0B?O h?,.1tGS/؀1?Eh[&M.22t{J$(F0K#h 6,5 +W< t 5+4fRh^2hv~ yQ ޠ hw<fZrj  pvw@5 pS
, #!	A	2hk
%00`P ?0S׿%-  Da`6(    pM aV魆ī^`W  3 _r- `+˸ nfDED`b;Հ B@<Be O B<`<2rruO0W2&*G_YS	 7&*,u&}Zu&E__[DAP`QFگ>  0 2ۃ<OtY	B/<tmH¡7[77_rPBBLѯ: r1 r,q h/$d0SQk
pqlat)u$<Pt+fKuҴhQpB`UY[Qn @qj"yjuOBAuYoof0P	VPo^W mQfR h3?tD=F==rN|UtGVR4^t1Vh_5f^Df`  Da   ; Z x     0Nm1=$
Pdu	q 42ɄXҏ	 )i HȃIذJ2ȉ-' %.7SQRfRBP' w	.Z0"T9a  y8 )a*$t2+`` *0hHtÓh rEd/(#3/J+(b\*f(fYïʥRh}ihlfPSf>QP?H_u(DЇ/ fP  [fX-r(qQP-roSfP>fVfWp(>f1t P tf0Z f@ f  f 5fff!52g&g
fKffRg` gwre h՟6r , VhݨZ,
-f_f^fZfYf[ r  sRfbXPSfRj07W6uLt;wEf6fQHf8 r/f־g&bP Bfg&rfN`b0oZ[XfWKu
 f   酀> Àff`g@? t]ǀ t
t@  f?t
 :  
@(Y! _ 0f` `; 6frv`gGwf3 f[PfcfPr:p> ff0;w!fVg&f^ufF=tf!Q. $pft Qg'&$9R<&m<f=ATADtlf q:&Ǉ  p s  S3a  ob 1݋ D 0Z3ɊFj q`UFWP3J XU .>J   ub >u `	`	v跌=p$l0{$C_AR?J0(lvfSIMWuUf, ^f@ENrdfOfAf;w(hw/FI"Q;[ap qQ08?SECU7fuBflS@:AR@P_ɧSXfGؐu(AE_-n$81B0].g q Gt+S2
 CT!T<tTt}hP޿
u^ 
lPlf@ | ͡簾ff
 w	ßJl& t
fWk&f_r2if$g&  EOg&	2tWVip^fGtt2t~tyf   f`w'pA,u(0v z^ @ u~^uBO`x_ rFf;r>`L: t, f    ur%)rQY9	 ]sh   t%htI`A
A!:0.2 r&q
"

Tr@ZSV!rP#j   t
ff;t;0
 + t D@@D@Ò*@00/rwp		]P? u ff!` B
fffLp 


grϧS@~1
!Х3Ұ"~t3 v %`hNVGܡ밣V1
< t601}2:u"FIhqr()PD01' E-fY&7@ wY.	A_S 
fUfp>t	--


f+Рf<
B#f]^P)x""  ,gbXv0? An@u`$fB %  
9@_#`_#_#Mfvfrg)(\*S+r[ ం0ૐPQ>ꦠι c r\d`PSCtC>r-t`w 0 r uҊ1 r
-`u`dPqQ rdItf s?` 3fցSRNr&Kr! [ww3҆r r	ʟ`HЮfsPRc!0rp܍ȇQ7PQq	s
d Sr	?r!V>Rf   dg3{uwR Z '?}hГk)C蹀   . Ӱ P " Y0 `2  p",u   P hE33R밍

Z@u
Sذ* o rQ(`( @PS  I 1' R۰RU  厢rPX3DC	 4ïP>DS t3306J*bRމ
t#4 c ttaÈ  PQRWV+3"a^_Z$"#P1$G<u@$V 4^W _ |	"  !(e_ 	J
R
q0<J
g&/ܱ1q;-r r;x;q;óPR(XוJ2Z 0[RVа$rN ;rCr<,	r32`trr;w tsڋ^ZW
   е0u
˾Ш 
u P f! uf _2 J332[2t@@ 0 	rn
$	"
ſupmƋ߱d;sRZ3QFqF2t
2t	u˸
S_
_......6r.Y.2YDذVPCߊP?q%8f #_g&   hpLfPfb` Cu a2X+U ~ø8	q帠 dpxax)pv$<	< Q- C  zBbJC 
يIڄ#蒈
Nyx yfqq f+fMf-Effgfq  f>PAMSuff>r^0[wSPݸ`#X>Q fi|	h! f#SIIWV`rY  E`/fP < u s󤏢orfcQ fQh^`b
h$t.ԜrB  ؾ@
E@u@
P
`Yft0!0 H\"a`̅j uL$<tD"ЎQg[r&=t&} tV" &GF^YՃ"
\ؾԨaþ 	 hyų
!s
"N
N


ZN
P 

h@ٰL  rg1P~̀RRغ0 t@Zld `	eqAd
	
fWfV3 0IZt-t`˸0f\c ôf^_Y[ќ.fUf.6ôf]f]** End SetActiveDisplays: \ R$nt5 Pp)㋗˴d_;t  __um AZ1Ӹg @t}0uQ2tN
͋Y  u@t P< tG QO
i p
R 13t0	p $ D paU"
ֿ "Pn QtR	g9P ZiP~liP$0 ki\iċ؀[iXSiX9iÀ@'W 21k,$
iQ(^ *hPab tQhP ÀhXhܠ h~QRPSa[X3oжa B"cu
vr j ܿK f`dҷKOu$Ujr
u.2*q	,r@0$p&` E&] @ _fofaP.A4t
11???LTSQ/"S`}fWU]fq~rW_Pð? ғ qE  rH rIPtp	0SfQWBUftu UAC?_fYfq@f`ffǷ ;@v0fҺ faB|k_<_ Rgf2gv#Qut SPQ$~X	[ fp Ǌ6qHȎt/O  3 (v؍mq$^at`ZONFa D{OOwA_ B  . 1gu$$t$
$$"h1|hs`9tw4>0t,@z uXa![aʐ  }  `   V D ` d h            a @  b  `: HX \  HT3L 4 u50@
@
/;                   `     14D    PXYhijklmno 	
}
                   o,89:4NNO OfhXJ"lW  O?SO #gf&fgf&f`wPf0	@g&OZ	 pvA ry㲓Pf@wsfRVW f Q  !Q  A!!ȑf%gf3f3f.2fffu_^fZv_f"Q ء f' g
f0P3@PSVWfQs:QJي Ru ufufpv @uf  fY_^[XQfǺff
ff   fА f  4 D4q'@fC_Y"OB jbR5   躠ཐ3 < i <u2<
   c                                                               UPRPRVFZX0RR30Z O                              ߸ ЍOƋhs3   f` tg)t$A)p$ŪT)r쪺  .<t
../ժ NA Nfa@SRV	fprtU./tA
 NUN蟣hϚ4^Zި4 hZ_À> t{%Bfs`fQWY_fs߁bЛf߁?UàPR좐BZPȿB3 $ `%>&t%	 
  3  t!  { ! @fu#2Gh24ҡtRW0_r TÐR8fZR0fPq&T ffX@ !+q+
䐟 fh` vE pE jE!dE0^E1XE2RE LEFEa?P  /!⼹&?t"g&Gbg&Gbu ` uq  κ( 
u#` `!B!]s7ra a* : , 22RQ8ĺZP X,a%*A Ë34 z g&DA4*
 <c. 1"0h2`ѿ1f@ހ͐% 
 0p!P!q ? f`
 `0XX!Jf`~fpf%? gffPv *
 `C  f!Av"aP<w'> ux##$<w	#f<u21V> t='u7 u1 )R*<t&\t!u_L^rr	B?6 4:ԿgNtZgtK^r3g&GȻ s00-G$
p-G!O  2O02APMt"G";r0MttoqX	
 ?  VȾrS 8t"8tr'1^SQ)^Y[t,&
u>ut
$rsE t> u.Qþ"t$	&
3sD pW
t|\`f	> [
 yl\@$ht`~0/KYW@I mguR/CtC P  K< t &$  
` u[ޑ> P
	 >t PtW00PS'u Tg *r$@, t׀>1u
 QdA  (r"/]t YJ]SQPX0tV
r@.[GoXKtB0T0.r//6Kt_6tP rB豰S36hs`Qu%
uN "DK6 seZE6A$Qtzu .Yطc5tb';sW;sQaYu	$Nu u"
u"
23Xb- ! à!Ӣ-to sxځ* -)P16tXSfW0~`
It@g_8؊f_[0M,fsg]  r&
,# fQfS !|{hQe1 fplf# uOf3\f   t{s,#%9tf!! ht1 fuf0 t0if.cf@Ff0mf[fYb! Rb`vՌ +9CCfW Ey1W u8  *ՠъt Җ t	L5f= f_À  
n ø  <Zu?mH_r}H /<G@ hn~ yQ  f `QÞP Qfdpa$
	юckt.f@
h@pW劐ЙƇБ 0`   b_údP u"AunP s  t 	Vf@ @ #bt0E9X`p % o&!#  ´d!Q~a-f#@~%1փ 80$B'  wf03pQ'
f~墤aAS	  ';'p
f1fg`s!=qfYfĪ & |ìS؁ Ӆ!^fPVp#t6T %f&ȿ ffP]t33uO^ fpqSR3X3t@s7rSߺ` hqx`2 
 *+ 4 !RR4'T0	Q̠pÖ*&$b
 P1T؃2沱1B0RfZ,.028  l+T,b1}-w=)A&T,˅*!
޿@ͫ)2ͼͩN*׾#j Fޅn?_`ȱʀEPt  !̃&pRu hx  _
 ڻ| mQm YCte P9ffXP:f cf l `a   ` ?
aa|!tc7ٿLٻ>ٹ 33j#IB@S3g!g-ff<f
 
# ^f RV\T%\h8T`n,0@k  ek Bk@2Xsf28f^- #PϨthV[PdBJ^UQ = u5
zH= i={ ,Q7` H7!k\CVѐ8[  9^t 3oEQ!\ `R]"P Q   ,A048X N1G@p\#qW>`5 A  ~F@N#ht_!p{3 P?f4qIY dN[Vf߁@2 QL7t2 t,NfP D_$P!Pc4Rc"'SS'1'U gZҲ~a&c'`,6   2ki1~` غ   nBnnntnJFn aS [ 0̀ 3ێ7!C &?!Cu3ۏR .Zðoh*:ðPJMXmZy/Ip &JJ5W>&go#.pu	 `uQy
 ^pktȿݦtC+t8QWP3 PhX@.X=X@uX_EYP!qup$ q!! .$> u
PJ@Xuð6C @B T A3gfpg tH~u.g :f g&ffS}׃| ffgfff6.<(.&ߋgfBfsDP
hki!t@
WBDBfR`6c6U z u

ޛ(@kރukXO0f?qPf  |o!ڃ tѾ`Np Mp pjXhu\AR@t%tgP&g!ggωf`ҜRft9tg>E @ t9g5CggfRVWf),g>E %^g> !P(^d`g
ز
U.  ofRA"Q2` t1YPQ O݀tu
QPYXP` ؠu 
X``K؎PRfu ZlOfa 	nM @(00	{EfZ :p! D  &E{t"D  $D( s``ف&tPΟ 4>2@"۰Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m Qam p's 0P ar * $mOQa	 & aO# $$<@t"hXRĔKuKK|Kuף`.>st&3r	&ߟ*rFH^;a`prr X ? trC0}qww1#!8Q909$蓨a0){fRQS[YfZwt'1 [( u
| pGa?r0PJ
ADȁmG> f  h4 f>Trxz#w%fYr<fffHff#f+ִ f;wf!3Sc
uff+f
 -/ -j߭:!~!cb흠  TK }.ӎ_dΓ $ -""c:D-ĭU\N--- -F-
%-,f,%iLّW۹:	ʧf
f.O+!u<u<ww2.߇@eBf&@ Sؐذs@r@`'[fS fAƁ;x_V4tp? u_z&[ff[`>ø_ >@``i///6͢rm7" 1_2(fhkvs"q#8,.hMr0A-@fP/c'6fA+uwZq}sdr
qh
	z=sGʱyhfuR ZI0M|M+r	a~ G@ hQ}
 W#!`K|"tz&t.@_fYVA:(3Hݰ1Yf^@qR7_)oRQ.ɟS΁qa:B-ràq$Й,-./01289     +`a 3 RRFu$a,PG3""
P![2t*:@ 	 a`> %l>l!GA lBla6~$?C (o! G @ A B  $0sF  on _"o  BnnnJF$a %JF0P < tq ̢P ̠̡mޢn   0llBߺ  ؿ( lBB@X l@    @ lkТlN8&H'_e /!%а 
@  
FFnR  	n	n	Un	n	n	n	nnn 
 kl t8a  pֲCd̀"`  3>nnC q
p	p.nA
` nm5nq5޿aPfWO4g&g&f_'/>                     [T 80 Oɀ$ tb]T PA7 u BPKnaRP@B u$ZfQWP Xgg3p`Q
`߱fgfafQRfWPSf3f3ɿRf0<  P tSf; X tDtQ[Xf_ZfY<fPffffX,{>  PJE gf^! p|	V					:		Q	^		[f	W		 	_
g&'p?f @ :fPSQWV!  tOъޱ5"1 5hoTTQ 
sY ^_oY[fX>uD?!  A( Ǹ
 E                                                         `     ,O~   
dƐ             p                                                                     6  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
    
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  ;P       VBT             $VBT ALVISO         d 0 
" 0                   BIOS_DATA_BLOCK x  
  d3412Intel(r)Alviso PCI Accelerated SVGA BIOS 
Contact joe.david@hp.com
Build Number: 3412 PC Dev    10/08/2004                                               Copyright (C) 2000-2003 Intel Corp. All Rights Reserved.

        $		


	   ! 	TV                           "LFP                                                                                                                                                               02468:<@BDFHJLPRTVXZ\ 9                 (  8  [0    ( e `   `   `    @`   D`   `    H`   L`   `                                 !                                         0                     @   H `   H                                           =                       $    (     
 
                                                                                                                                                                   !  R`SI-1362-A   p                                                                                                                                                                               I X <  X<
 2	 Z (-  	
                                                                                          	                                                                                                                                                         
                                     <                        <                        <                        <                        <                        <                  * 
ZcTZcu$M                            (  s ) (
(	
	(G	Y	
c	(		
	(		
	(%
7

A
(o



(



(
(M_
i(
(
(+=
G(u
(
(	

*   @ X  ' 0 h  	 `"      6      X   @ X  ' 0 h    1X (      6          @ X  ' 0 h  d @A &06      6        < @ X  ' 0 h  0* Q 0@0p      6     x < @ X  ' 0 h  0*x Q@p      6    x < @ X  ' 0 h  /xQ&@X      6    @ < @ X  ' 0 h  H?@0b2@@      6          @ X  ' 0 h   P 
00 *      6     @ < @ X  ' 0 h  ,@`@0 *      6 	     < @ X  ' 0 h  (<p#@0 *      6 
         @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6          @ X  ' 0 h  d @A &06      6 
         @ X  ' 0 h   P 00C      6      X   @ X  ' 0 h   pQX 8      6          @ X  ' 0 h  d @A &06      6     +a N  XN  XJUXL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  XL  X,                                   
ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$                                                                                                                                                                                               68DTH   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰f    Q7sY 戰f
!  ff !  f   tf ff
#  rfBYf戰YgC!,f3f   戰fHr4f f戰䈰貆f戰 rfFf    戰戰3袉f  f   f戰fS蓋f[f   f   3f   f  戰g&efFfCg戰诉 撰fPfSfQf   fQf3یff
!  fYsQYfIufYf[fXSgu
5  ;u[fPfSfQfRfWf   f3یff
#  	 莅fBf   !f3g}
5    fg
#  r%fG;wg}
5  f_fZfYf[fX   fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   Ifsf ff   fT   Ifsf wfD   f @Ifsf [Ifsf EIfsf Jfsf !Jfsf 	7Jfsf <MJfsf ycJfsf yJfsf b5Jfsf xJfsf Jfsf V	uJfsf 	_Jfsf 
If   t Kfsf 
*Kfsf 4,Kfsf s
nnfLg&nffOg&fffsf fsf f   f   Kfsf f~fsKfsf !Kfsf PmKfsf Kfsf Kfsf ^Lfsf #f   tLfsf ,Lfsf Uf   tELfsf NULfsf eLfsf 9uLfsf Lfsf q%f   uLfsf !Lfsf Lfsf $Lfsf Lfsf %Lfsf %Lfsf )&Mfsf )3 f%"f   t
f_uf  JMfsf ta$f  hMfsf ndf  Mfsf f  Mfsf L   Iuf  Mfsf f fsff   f   f   Mfsf 
tff Ag&uf2Nfsf A%r8u:JNfsf )%u$f3f   u
ffuf   tf fsf   Nfsf t<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf   Ofsf $f  :Ofsf bf  SOfsf f  mOfsf z   Iu f fsf   ffufOfsf #tf   )Ofsf #8uf   uffuf fsff   ftL Pfsf S#f   t$<t)<t/JPfsf )#ufffff   uf fsff   ft(
Pfsf "<t<tfffff   uf fsf   t8f   ftPfsf "t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tss0f   Qfsf [$t<tff @   f Qfsf !2  +R.Rfsf h!<  ff   f.:w .D:Rfsf 9!<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2sff   f
.f   2f   f   ft/JSfsf ) < t8stff   uffff fs2sff   f
.f   2f   ft(Sfsf < t8stff   uff ff fs2sff   f
.f   2f   ft(NTfsf %< t8stff   uffff fsf   f    ft'Tfsf $t<s
f   <tff   ufff fsf   ft Ufsf suff   uf fs2sff   f
.f   2f   ft($bUfsf < t8stff   uf?fff fsfffsf fsf 2sff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%~f   t~.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfs2.<u f   t2kf   uff   u@Wfsf #uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   Wfsf *<|f`Agf&   f    f    f   Xfsf 9f    f    3f   ftOXfsf UfftiXfsf ;fftXfsf !fftXfsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   ,Yfsf <|g&f~fsf fsfLf   f3f3ftr2f   t~Yfsf tf˰Yfsf <	rIаYfsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fuf~.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f~  f Lgf&fftfh~  f~fsffHfuff Lgf&f   ftf@]fsf f Lgf&fftf ~  f   tf8~  f@~  f   tfX~  f Lgf&fpffHf   tfHf~fs]fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	Y^fsf fBgf&u^fsf  ^fsf  tff%   f
fHf   t
.f@Cg&tff%   f
fHf   t
.fCg&fKgf&^fsf f fstff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsHtff%   f
fHf   tPtfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}3.fDg&(Kσ.fDg&.DfDg&f3`tf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f` {f~fsfffsf fsf f Ef   .@ fffsf fsf `wfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@cfsf ;f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
~fHf   t~fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	f   tf~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H'f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   f9i  Yifffsf fsf f ~.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf~  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   $ifsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gft  f Lgf&f   tf0t  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsf   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f{  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   f  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   f fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afAqf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   qfsf *f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  =sfsf $f  Wsfsf f fs<f fsfffsf fsf  fӇ.sfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  jfsf }ǰ< urf   fsf $<  <t<t
<t xfNgf&f   uf   Ӏfsf 6$p2<uB >tHH3f  fsf ȳ 
f  fsf ƻ  f  6fsf ư < uHf   Rfsf $` < te<t
<t UfNgf&f   uB >tHH3f  fsf dǳ
f  fsf (ƻ  f  ہfsf .$
f  fsf f  fsf Ƴ

f  %fsf ŀf  >fsf ŀf  Wfsf f~fsf fs    f   ff   2fff   ff3.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2          "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         [                           o~jGDkED͍#(:of`0]ٶUVo^#j	lfYF;EbRi; _ OA 9@fhP) ?ٱCbNv4gғjF^SzDM6c)@#$i`]).?mCmϰg;І\[A;n-]uM^h:9*!1F;ޑW誩O0~1_)W*yBd.vOr/ϴ
%>2=ׅYXtSc!TFm֦U`aMH1':
Z󑈷5Ԙ|ްao#1\nѓkݷOL|)<F+z  :~VU-PadX;*?.5Uc-oh@x/Rdlۑxf&\݁'KAqOrbUd	Csʩ^w<AO<q)+	dCfu%_,[S\
[+f(=]FlJ߼qS:<xM+ٟ;ݞ^^פIQ>wm|
{OYS^9E@3OZ@_БHg(R	"t3٨_1UW!ߣGhϿl4d	}N*w|<gFz+Bs.4<0
2yUsiɕchLEH2$ql[_B,>)c-6+AjS;MF,kOHUAimX?}DS}[!AnjZfe\Ҥn(.VV"O3%;H׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        D   @    L       @       H         `      T    G|   @ Ď    Ď    	 T    G                   0        	    	 		 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D    X      P    `                O    O    
Ol 

Ol 
Ol 	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 	 x   @
1 1  @  @
	 	P 	P0	 	0	T
	t         @  4     	4,  <8	    , <8	     <8	    <8	    ,<8	    ,<8	    ,<8	    	,<8	    	 T <8	    , <8	    ,0<8	    ,<8	    ,<8	    	 _. U . " /  . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /  . a /   . p /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         =                    	4 @     T                      d  ` h  $X  '     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<8	     #<8	    P0#<8	    @#<8	    PP#<8	    	 #       8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O  N            0              < ff%f  $f$
t)ppqtf[fupppppquJffupppppqf f  gffLggf^gfnf    f
   "}f۬'fupppppqg- fffff  @$f@$
= u$<& fTff  @$f@$
и f  D$fD$
аfgf% = ufKf f̭6f % ugffU../0./.ff d< uf)fd< t<t
u掰fQf䎊fcffuf掺<ufif  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
f.  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   ff˱  "ϫfױ  對 f    < tg                                                	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8       8     p     -         8i        8i 0       8     p     -         8i         8     PR 
 ZXPR t tZXPSR  !Z[XPSR t t
 !Z[XfPf   .> uf   f  f& fP  f  ff& fXfPf   f& f& fXfPSQVfWf   ff&fGf&EN fP  D$
&D ff&f|u؃ >fP  f  f& f_^Y[fXfPfSf    f   f  fdff   rf[fXfPfSf    f   fdff   rf[fXPSQfV5$ "  f0   &Dtvu;6r$ &V O f^Y[XPSRV t8 % &&  w-k&>	u^Z[XPSRV t8 % &&  w-&>	u7^Z[XPSR      Z[XR t tZPSRRZZ[XÃ<t  <   2  (PRt'tPZXfPfSQfRV+f fU x  f   fdV fdVfdVfdVf]  N t' 6 t p ~% f  fP5X t"%f  fP
X t"%f  f`PX^fZYf[fXRf  Ӄf3ӃZfPSf   > t!f    > t
f 0  [fXfPSfQRVfUf  f;tff  $ t$ t$f       ff&    f  > u[fù fW  gf;tgf)gf+gf)Cgfkf0f3ۻgf;tgf)gf+gf)Cgfkff]^ZfY[fXPV% ^XfP   x;u ;u   xfXPSRV&  w- &>r&> rG5>$ u&>.u&>.u&>/uE^Z[XÃ t                         '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Ĺ    戰䈽j戰䈽ff
갳ff#d찴f/f97fEfO[ f%"fgfqwffHfif gfQf찺f;f f
   `"	f   f3f30f  0ffuf   f f    0f  f f   0	 f%"fDff.f. f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.f.f  
_f  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      Pf    Uus 
 -
  >
rfg  Ձ ( r  .9V>Mff<>3fffrrfff> wf   >ff%fՠ3fff> trf> wf   >/>m>dff   fF>=ՠ,>#ա>	ff  > ff'fՠ[
r$fff> trf> wѰf    
t >urd>u]R	 D>u=բ/>u(fհ 	T  Ճ>	r  KL	s 撰 XåŴd~Ɲ%~ǋǑǦǸfSgf[gfPfR>uz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf @
 > u> 5xzyt^sfZf[fXúz.yuBsfZf[fXPR tĺZXfSfRf @
 > uB ;yM@ts(xغz,y0@usz.fZf[Ru	sZ       p     -          i    p    8-        8       8`        8i    t    8-        8h       8i          i  t     i       i       i0       ip       i       i  4     i0        ip        i   f`>' tI%(&4&&;Āu< &>vU' WEG{
ɻ="yfaPSQV ʋL	;t	 0 ^Y[XPSD	%ÉD	f<t[XfWQ f&    Yf_f`f  &)6UMcs>)t fafWf  &&E f_`r r3 a` ʊD
$&*
ĈD
&*Ms>)taf`ʊD
$&,
ĈD
&,MsTf  &< t>)thfa6rfWrNf_    f`f_if  &(ff&Uf&ErY6   U  rCQfP 3f  f.>_̹ fgf&fff.>_fXYrufa`0ʊ&* D
$
ĈD
0ʻMsZ>)t|a                 `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva   f
   `"	f3f3f   0fffP  0 f%"	= t*PR ZXtu! 
sô ` uR Zts+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f  +   f"     f6  *  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_ZA`AjAnAfPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZPR Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X   <t ø fSQ >tf r	f  r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f p  rg<uf   ⃸   Yf[fS>tf r	f  r>PfSfUUgf*gUfUUgf[Xgf    r
g8u   f[           f  f@  fPQgf0& YfXf    gf~gfNgfVgf/KfPfSfQfW<w f.
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX            A PSQRW0  3  3  3_ZY[XPSȎػ       !    A   f   $   c  X  M[XR # 1 ZSQW   _Y[SQW   _Y[SQW   _Y[                                          Q  YPSR+;wZ[Xf>  tf tf`f  f3f3f3f  gfffCgftftfaf    f uQYfVfSfQf
!  f   frffYf[f^fQfWfVf @  f   f  gff^f_fY               fPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfXfff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{f2ffEfd    2ø     b @ ڻCR04/13/05DHTb