#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68BAS ROM)  - Linux-Based"
BIOS_VERSION="F.2B"
FILENAME="sp29126.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK
# Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

## bzipped file
##bzcat $FILENAME.raw > $FILENAME
## gzipped file
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file
#tar x --gzip $FILENAME.raw
## bzipped Tar file
#tar x --bzip2 $FILENAME.raw
## plain Tar file
#tar x $FILENAME.raw 
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK

make_bootcd()
{
    echo "Creating .iso image from $FILENAME..."
    mkdir -p iso
    cp $FILENAME iso 
    mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
	eval $ERROR_CHECK
	echo "done."

    # Prompt for a CD
    echo "Please insert a blank CD and press <return>"
    read ans
    echo -n "Writing..."
    cdrecord -v gracetime=2 dev=/dev/hdc -dao driveropts=burnfree -eject \
			-data bios_update.iso
	eval $ERROR_CHECK
    echo "done."
}

make_bootfloppy()
{
    # Prompt for a floppy
    echo "Please insert a floppy disk and press <return>"
    read ans
    echo -n "Writing..."

    # Write boot image to diskette
    dd if=$1 of=/dev/fd0
	eval $ERROR_CHECK
    echo "done."
}
#### Process
while ( test -z "$done" )
do
    ans="floppy";
    echo
    echo -n "Please enter [floppy] to create bootable diskette or [cd] to create bootable CD:";
    read ans
	if [ -z "$ans" ] ; then
		ans="floppy"
	fi
    case $ans in
	    C*|c*)
            make_bootcd $FILENAME
		    done="yes"
	        ;;
	    f*|F*)
            make_bootfloppy $FILENAME
		    done="yes"
	        ;;
	    *)
            echo "please enter 'floppy' or 'cd'"
	        ;;
    esac
done

#### Clean up and exit
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi
exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @` @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  *pNZ1Z1  qNZ1 6   AR o m p a  ?q . e x e     ROMPAQ  EXE  ?qNZ1]1  ;1   8DTD   BIN  rNZ1Z1  *OZ1    8BAS   BIN  &zZ1Z1  'zZ1      8BAS   BIN  kPV1Z1  lPV1    8BAR   BIN   ݨ]1]1  ݨ]1   8BAR   BIN   ݨ]1]1  ݨ]1    68BAS   BIN  ]1]1  F01                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          MZX  @  
   f^      C        
 
  F  )  
    
  
  
  6
          \     
7              _  9  #      |  Z  I  @  a!  [!        q      }       
 
 
%  %  {%  b%  ?%  %  $   




















~
z
v
r
n
j
f
b
^
Z
V
R
N
J
F
B
>
:
6
2
.
*
&
"









































~
z
v
r
n
j
f
b
^
Z
V
R
N
J
F
B
>
:
6
2
.
*
&
"









 
 
 
 
 
@  @  @  >  >  >  >  P>  {C  uC  YC  mA  \A  



~
f
H
*
 




v
^
@
"

 
QN  N  M  M  M   
[  [  u[  m[  [[  t^  J_  h_    6	



  \  Ս                                                                              3Ðjrː
  F  F~ F F^:9 uvfv$}fvfv$~h7	h jIsRP腉Vtj
fvvP袊
h7	h jJFRPXVtj
fvvPu
 Ð3f>Z  tf6Z f>j  tf6j j \i  Vh jeh jZh jOh  h j\h  ~F ^v&v& =c   -!  - tHHt-3 t_ L  F^v&v&8 D^v&v& ot^v&v&   T  T  P  T  N  >T  uT  |H  J  m-d _HHt- t- t- tf6B jRP$fjRP踃jRP訃jpRP蘃j`RP舃jPRPxj	@RPhj
0RPXj RPHjRP8j/]FF9F}-^v&&?-t^F&&?/uF nX:=sjtRPڂj\~XtjuRP軂j\MYXfh  j wZ \ Z ujvXRP耂jw\t
>R  t@C  Xvt(n ! ~ 9  =  A  E  I jJj1fjj l j ujvRPj[ t(^  v j   l ؎f&fbjtRP轁j[>P  t>R  tX  V  L  >X t>X u& & & >X uD>T  u	>L  >L   >X u3T Ht	HtHt8j uwjJ9ulj?j.>X u?T Ht
HtHtHtIjj MȐj?u+jRP׀jT HHtH>T  tD>N  t=,?h,h,j2}
>8 t jYRP聀jIRPq>J  tj [Zg$  F >$ >P  t>R  tX  V  L  >X t>X u& & & >X uC$~ tfj fj ,F  s=HtjH-
 -!- - - 
tEf>  ~  H    7 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G}&Wqfj ?e     F >J  tE<L$ C= M- K- (-M- 0- )fjF6>J  tp
j 6X^ÐU	^&,&.Ð  F fj fF j   l ;Fu;Vt^& FFԡ j  l ؊F&Ð,".
Z hTh,h,j=>82  fFfbfFf+fFFPj fbf-    fPfvFP~ uf~uF    ÐfFfbfFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FFd+; w; r j ӹ l ؋F+NV&&Wt j   l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h
h| j  l RP襀
3Ðfv T  Vfh  P FPՀf,K  F4ZhTh,h,j}>8 t3^ÐFPTwBFVh7	h FP@~RPhfvh7	h fv$~RPh` vfvh` Hv ^Ð  FF
,".F4FZhTh,h,j0}-*ÐU~uh7	h  Ð~ fh  `h7	h h` Y&(&u3Ðf     
f    fbf9 sVfh   f6 fh  `f6Z Iu*u%f6&fh  f6Z Z= u&&G
 tf6&X놐f6&WA~ uh7	h 3ar j   l ء\ +Z  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h
h| j  l RP~
#fh   vfh`  j f6Z r
Bv  WV7	~ f~ th7	h FPRt~ FPu3^_h7	h$ h` W&(&tj fbf-   fPf6&v
f6&jFPu
f6&x~ uF.~uF6b 8Fuc 8Fud 8Ftf6&VkFPh@Rf6&U ^_Ð~ fh  G.h7	h$ h` V&(&
f     	 "fbf9 sTf6&fh  f6Z V= X&&G
 Kfh   f6 fh  `f6Z )t!f6&>Ufh  `b^_Ðfh   vfh`  j f6Z \Ur j   l ء\ +Z  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h
h| j  l RP${
FF>v tjJj1j f6j Z{jh7	h( p j   l RPz
6n h
h| j   l RPz
r j   l ء\ +Z  &&Wt j  l f&    v j  l ؎f&   x j  l ؎&  E&  FF܌VF V   R   X   f,
S h,h,j^q
>8 u_>/@V Rf,N  f0    FޣTFܣ6hTh,h,j%w>8 t>-uR   hJNu~ tX   Ft
F$p*X Ð&  VFF܌Vf,D 6QCZ4hTh,h,jv>8 t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	,&,ZhTh,h,jMv>8 tjgfRPs  fh  ! h
hxj=RPUF  @n +FHuF F^	&x&*hj*mVFn 9F}j zĈf<t<uh7	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>V  u#jGzRPrjHjRPr3ø x&hjUh~tuÐ  fh  u3fF    fFfbff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "hj
TjoRPSFF*;ds6PjNRPSF*Pux&
뫐x&
hj
}TjxRP!qju,jARPqjBRPp>J  t`hfh` jRP-SÐ  fh  h@hft"jIeRPpjJURP}pjwCRPkpfh  ujCF  hj
Sj
RPRF~uJ~FF*;dsPjRPbRj F*PNux&
띐t~ F bx&
hj
RF~sF F shj
RjQRPQ>J   FF*;dsfh   Pfh  j f6Z fh   F*Pfh`  j f6Z F*Pj$RPjQj F*PVu_&
\h@h` jRP)QjWRPjVRPh7	h4 	QÐ  fh h@hfgt"jIARPinjJ1RPYnjwRPGnfh  ujCF  hj
kQjRPkPF~uJ~FF*;dsPjRP>PjF*P*ux&
띐it~ F bx&
hj
PF~sF F shj
Pj-RPO>J   FF*;dsfh   Pfh  j f6Z qfh   F*Pfh`  j f6Z F*Pj$RPFOjF*P2u_&
\h@h` jRPOjWqRPjVgRPh7	h4 NÐ  F >X ut~ th7	h< h7	hH FP.hh7	h$ FPKFVu3vPfh  f6Z |K= s^&G
 tF  fvPJO>X u~ t	h7	hT h7	h` FPgh7	h$ FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6Z FPy0F~rh7	h h7	h< IFVtvPfh  f6Z QK= s^&G
 tF  fvH~ uj/RPLh7	h< jRPLF*  F xu3E-t*t~ th7	h< FPej h7	hH FPej!RPFPeh7	h$ FPIFVtvPfh  f6Z H= s^&G
 tF  fvG~ tj"MRPK/F~  F ohj
LF  hj LFj";F~x& ܊F*PjRPcKf6Z FP/FF~s#~ t~ uw&
tFPFPj#RPK~ u~ tjjgRPJF  F f6Z FP).~uPh7	h h7	h< GFVu3vPfh  f6Z  I= s^&G
 tF  fvdFFÐUf6Z FP.Ð  F u3F F~s7F*PjRP*Jf6Z FP<uh7	h2 Jh7	h h7	hT FFVtvPfh   f6Z BH= s^&G
 tF  fvEx&

hj
JF hj wJFj N*;~x& Րx&
hj
+J~ ujRP%Ih7	hT jRP
IF*  F u3t~ th7	hT FPQbj h7	h` FP<bj!0RPFP'bh7	h$ FP~EFVtvPfh   f6Z yE= s^&G
 tF  fvMD~  j"RPIH9EF phj
IF  hj 	IFj"R;F~x& ܊F*Pj[RPGf6Z FP:FF~s#~ t~ uw&
t~ tFPFPj#RPG~ u~ tjjRPaGF  F f6Z FP9u3À~uLh7	h h7	hT DFVtvPfh   f6Z rE= s^&G
 tF  fvBFÐUf6Z FP9ÐU  
2

` UvV>
Ð  >
vVF*^&F^&  >`% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU젶
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2*>* 	*  iÐ*i  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRh7	hl ^Sab~uvvh7	hv fvaÃ~P|FlFFPvvh7	h fvaÐ  FPNQVRh7	hl fvavvvh7	h FPraFPNQVRh7	hl fvavvvh7	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>  tF ^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvh W  
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F F F3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6 ^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj 9Fufh  jjG^& tDfh  yj  +FHu
^&Guʡ +F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh    9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;(}(F;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F F(Pv~ 7
F(F
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6`FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%>` tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>X uFP_!ÐFP>X u0 ÐU>X uFP+ÐFPU>X uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHF`F`  F
FFFF  F9F~FF^v&8 uvvE~ u
F`F^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"  n HPhFP
FPj hUF=
tK-
t
-.t-	 NF n HP*PPhvFt(=t#= ;t= DuÐ- Ht- t- t- tàn Ȣh<htLth<hِ 1= t= ut Ӄ>V  t fj hN3  F/ ~ ujQFÐF Df>b   FF Ffbf   ffffN*+;<|;s6F*@N*/ Shx=h*F*P̓uFx j hx=h j̓]FUtKjh̓h
h` j hlfj h\G=thx=hEtÐh
h@h
hf~&QWÐQ&WÐU~ u h
hfjhdHh
h@jhd7F  F~ ujFÐF Df>b   F4w j h>h:fh  L΃uF  Ffbf   ffffN*+;=|;s7F*@N*/ 4Sh>h:j F*P̓uF2uF~ u~ 4/ F F~sF 4/ F cFfbf   ffffN*+;t|;snjSF*PShSf6Z Tڃfh   F*Pfh`  j f6Z ڃF*@N*/ 4j h>h:j F*P	̓h~ tfj hz!F\  fh  ̃h
h` !fh  ̃t"h
h@h
hf+t";fj hE/fj h>=uuh>hdt!h>h:tfj hrU~ u h
hfjhdh
h@jhdF  F~ ujOFÐF Df>b   Fw j hAhdfh ˃uF  Ffbf   ffffN*+;=|;s7F*@N*/ ShAhjF*PR˃uFuF~ u~ / F F~sF / F cFfbf   ffffN*+;t|;snjSF*PShSf6Z ׃fh   F*Pfh`  j f6Z ؃F*@N*/ j hAh#jF*Pyʃh~ tfj hzF\  fh 5ʃh
h` fh ʃt"h
h@h
hf蛼t"fj hEfj h>=uhRAhdt!hAhtdfj hÃ>J  tj ht$ $   / ~ uj߃FÐF Dj Ճu` j hDhtF F~s3_ F*/ j hDhFPuF? j hDh|he>X utTtMttFj t:hRAhdCfj h>=thDhtÐ  / ~ ujރFÐF DF F~s-F*/ j hEhFPuF? j hEhh
또>X ut>t7j hwfj h\=thEhtÐ  / ~ uj݃FÐjӃuÐF D` j hEhtF F~s3f F*/ j hEhFPuF? j hEhh
c>X utTtMtFjt:hRAhdafj h>=thEhtÐUfvhB  \*F.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
\N*OÐU*FP\PK**PKÐU*FP\PKF*P*PwKÐ  >T u7]  FVL;Vrw;Fv	T ÐFP
uh h UT  >T u
FPh iÐUT  >T u
FPh IÐUFPh 9FPh -j>T th UFPh FPh FPh j|MÐ  >V tRFPh FPh FPh FPh j0 h l<uV  >V u&v*N"FF FF
FPvB\*Ð=tw$-t-| u)^  >^t% Ð^ -t-t t-0 t^ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U^FPgÐFPtHtÐ^	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  P h FF )fF~}j v`tFP  F~s#>P tFPh F  f+fF볐>P  F  `>P t(^&k^&?tP  FfF~|F~s>P tFPh ;f+fFҐ>P uKF~}Afh   j FV^& ^& h.P F 닐FPh j FV^&^&PÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h Rfh   FRPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~uRPh Zj FF  	&f FP*ătFPh
hfփ~ th7	h`
h7	hl
FP3h7	h$ FPUFVu3vPfh0  FPLfv4FPh
h@kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhLNfh\  hj 6Lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6LhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	&f FP貶tFPh
hfaɃ~ th7	hx
h7	h
FP&h7	h$ FP	FVu3fj hvPo(
fvfh  FP	fvFPh
h@ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tûZ XËZaËXaUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..]f^gef[UfS..]f^gef[UfS..]f^gfeff[UPfS..]f^Fgef[XUPfS..]f^Fgef[XUfPfS..]f^fFgfef[fX                           UfPS^tf3ff]  f.].] "  u  $" u [fX 0!<s3P˿
6 + r ׁ~sh3P1L!66ƱH6`b66gP6g
P6g6g6&\6 +۴J!6
+3	O3X 66666P.h_ظ ^3`P.h_ۚzd  y>	uXP	 P^
 5! %0_!	)&6, 		3	sx		 	&, >3&= t4
 |t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
t z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;|uQVW| _^Yt^?G^
u͎^O]UVWV	;t@t3_^] UWvt 3I >	u	@!_] SQ XQP,[XYt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGtt(u%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVTFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvtt	(uVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*ot/ppPvvPvvF^&*ou^&?%t2XdVZ\T`3jfh~` uoF^*&otfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt ot)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPotou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\ou̓.uMhhtAĞrr&.hht'jĞrr&pvv
ou̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnoupVvvj u
T t nĞr& \~P|z\Pf
 P|z\P\^*&;tpVvv RT uInC-c = w.dvoxr@t@t@t$vq$v$v$v$v0txrjr$v$vo$vxr$v$vq$v$voRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^ot$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvou^] wxxNxzxxxxUwVW3FFv&vF
t~ }F, <Xw$ FF.wV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuIOWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
dF
ZFFt~ u	W`guF u	W^&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>V tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uSuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B
&X=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV43V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVvv&PFPW Pvv;u)x&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;xvJ;vvv ;s33󫖹 +v*39p	tvvvp	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3
 u
_^]U VW 3~v
tȰCvu&6r	% uN&6r	&t	HȰ"Cu׍D&r	&t	% uDȰ"Ctd&r	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋv	tv	F3] UFu		u { rFGFF3҃vvډWNu(t$>h uS#5!hj[P#%!u鍋s̍ˍʻ 	FV]U컍 .8tK
Ix	]PPR.h_؃> ux	z	w1uRUVV EE< ujF hF]ZXXˣ		UWVQS3x	z	 P	X[Y^_]ZXX˃PU
ء	F	F]XSQR
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغ_$%!3]UWVRQSP.h_ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;ut^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;xv;vvv3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]              
              4.61  mm/dd/yyyy    .BAK  wb  .BIN  rb  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/Dock] [/Update] [/Backup] [/Restore] /X [/!]  where: /Dock    = operation applies to docking station         /Update  = update BIOS with new version         /Backup  = save BIOS to disk        /Restore = program BIOS with backup image         /X       = clear ESCD and CMOS/ECMOS        /F       = force docking station recovery         /C       = do not allow exit to DOS (power cycle)         /!       = do not allow exit to DOS (power off)  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Invalid command Machine is not docked Could not clear ESCD and CMOS because a password was  set or because the command is not supported Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   7	                        68xxx.BIN                $ ( , 0 & ' @  ) * @>  , - :C  X Y C ] ^ D a b E d e F %  
 \  
  D10/17/2001  O                                                                           7	 7	 7	 7	 7	7	N7	~7	7	7	 7	27	l7	7	7	7	7	$7	L7	r7	7	7	7	7	$7	<7	N7	t7	7	7	7	7	7	7	7	(7	D7	b7	n7	v7	7	7	7	7	7	7	7	,7	07	87	@7	J7	T7	`7	l7	z7	7	7	7	7	7	7	7	
7	 7	&7	N7	r7	7	7	7	7	 7	@7	z7	7	7	7	7	7	7	&	7	B	7	b	7	v	7		7		7		7		7		7		7	
7	D
7	n7	Z
7	v
7	
7	7	
7	
7	7	 7	07	R7	p7	7	7	7	7	7	7	7	D7	r7	7	7	7	7	.
7	@
7	P
7	                                  C    D    @ h 2
      A    B    @ h P
      E    F    @ h n
      I    J    @ h 
      M    N h 
      L    K j 
      G    H    N h 
      +     /    ) k 
      R     O j 
      (    /    & k .
      P    Q     S   
T   
O i L
      V    W    U h v
      .     /    , k 
      [    Z i 
      _     /    ] k 
      c     /    a k 
      f     /    d k 
      m    n    o    p     q     l h $
               :`                           _C_FILE_INFO=                                                         
               
	
\ \                                  

  

                                                                                                                                                                                                                                                                                                                                                                                                                                             
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          aaaaaaa               (((((                  H                                                                                                                                        
                                                     /_/_/_                  h




<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                	      ]Pg%\5G[m;pL|.Ba7Scx	F	X	g										
6
F
L
Q
V
_
o


	Kv)
i
y






),03;CHOX^coy9]e&Hj 203-Memory Address Error 
Non-System disk ore
replace and striky key when ready
}
602-D ette Boot RecordH5 !Run Configuration Utility1720-SMART Ha0Drive detects imminent failure (Fing Attr: ??)

Please back up the co{nts ofh1drun
HDD Self Test in F10`"tup 1800-Tempe!Alert  7{A proc~@has be eda"s n0orq'#C7MOSA%3-1)d(s a%'&1(&by POST o1155uBo1?Comm P(6Assignm!lic0%611-Prima Flopp@-?/R0n02-S nd12/001 tGrol %85sType17A88q ;94O<f=03<0;W@0;f@H=C8 1;DH=348@>G=60-Fix'@doe(sup( wBloPModrI%1I1JK7g1>6K0 AO=PL01s73IMDMAL3L?W$L5V'IdifymAmQ[X\]4[ Q_#K`?^av]8VParamr Table1BI)dHalp' c 538P!apgE=Updb.49h... Invalid el ronic serial _numbe108I/O ROMW%308Kl93r8304r@UnitLoad_all -hi4Monochrom$k 164Sizu;qrHx"0V$Inst`wi etwork`"rvp9bActe!No rachi164Op*stq# Pg@ CheP2  PCI BusAg|A910-ExgnoStorag:eviD= HvF1x`1`gP9lS1T0xk2_{3\3o02 08:rpqQs.E=IOCHECK acwlz3-{Tipy& Dap O X B  Powe{r-Pass@dXOKDo you!llzato pp  s? [Y/N]?RҞsVMAdpiaP/R"orhipn01 n (ABO= 'C_trl +$tDel'pz8-11A: X&changedu2: m oqne!&1PpP3߯: Video	m-4z:rrup+f@_u5 i8͹6ߺan3(@_#expansb  TurnҠcej &f]qr<F1>:G AbSb^+rmal2Upo mu"տ 3gi wa0,Q+B0kA(Strg+Un/tbr,I ϪnaTf@9owo$uWtomculed: [:s To~ mie~: Kbyt@) cksum #bn,NfauЪ`nuMl0wiW'Next? EAAgti#Exv0Ӯs7saEA7cce=   F1`0 OF2 CTS`k I .pugy # Mai Oances EntQ;F.5w9ipw, usimodut~Yme@erequi{reQ0s.  `oD٤. rLK1"Bj>GMib?_ay126re| Mexcee 'K'Ś1) >CircuU=uUn$N'wPlJn$dӇ%'.,i.Sc,eT !"P.0S1t	C11(ppc1@%#9	,vInr÷ypD	Shut2l/down` P~ %0Ѳڡe K۷PIN: [5]Nxoq left0
ERROR
wY`ha߰A}7goney 5la"MQIndex (MSGIDX)   t   _      8     
   .h   n f  ffff0 ISvݓV Q'  A  0  Y        > Qi    T h  gG W e M AY 9|@. 0NH  EnSa0~ G ( @ ظ   f3  ?f
 4 P f pπp6 f6   } /  6 >x  .h1ʚv PS $<t4r g[X `
u1WGWrBXr<W. u)(.< t.߈h^.a !!`6PhDrAV(< 
u^V3$  ^(P*^`% &2 4aSP( 22< tFX[úB *$PQR  ZY?._/012 346?7_89:;f`.t.0, ~ xri rakfL+@ Aكpr$ wr/讁@f+D`Af+\ r@ .hdfa= PR),3HZiX0GG,
@I`&Fa`.> GuhP'XhF r.>.puFKfPfQR>.fh f3f% aZfYfXURQSWF^
D= F\ ^0TFU\މ^t
;v F;F
 < uWX < ȭ22 IF t%[Ջ%[[~%[뽹Y% #Z8t
` @[uPj Ѓ;}
+V 
N JZ=`[uAN3V5,_[YZ]`P P&X&0KPQW^ kPRY+UkPkP]]] -klmo?p_qrstuvx?y`ރ6.uߋ;v{Q0h *Yp[QwLQ?f&YCCpfKXݻ  a3YapdP=SRP3pX?[>?P$&%<GP1PP	 ff}M t    <BMtf3@S..& u<t`| `<?hP2PIX0P )r
:@PSfRU3Kt.fGenu fineInteluwf=sl=r'=v f%f2ft PY tI f  =|x	tǀunWj0`f@3tᜀ5uRfDQQ $<@tC<t?`>ҜH$_u.fA-ۊffҜCt	]fZf[я
ffȱ qڋh`
=?   ,z	qYh:&hGhŲF ؾj  <_D @10Ëދ38t" QW_YFð N;r+A+&FGN uF`="0rF~1󤒴ؿ:~?6b"_h)N@߿8E?9m` @6mM ӨՓ~~U= r&+==rW>0 _ps&m0Ŵ&v
, fgh  0 pqr  <ABCDE xyz{|}  ߆ ÿfQfR쿾{R &
¾B r
&Py̕0R̭.0Y1%SQV3
Ê^Y[.<  .FuN.PW _PSWfVUSW! fv߿ hw ޿RV~2,ك!oIN 3t^
u
t_ ֋N_[]f^_SV h^[þ
  âS}
)F10=ROM Based Setup! Epring=G"K t0` '[aF=  O t+ 3@1  9Op "B	`&2ú $t
K`t/.LF12=Networkrvice BootWake On LANAttemp-tto" 5D`3ht6迍 r	a8W#t A(4E_ b6# [$8>bV3F<^h#as 蝏{uNs	2QWVRuy3 G0NF F3؁F?	uCFG?~NtGf`hqvhs	f(Z^__Y[Notebook hard driveH
MultiBayJDockbCb>(top)bottom)left@
Flopp  UsSBCD-QtHDis>!SuperGNICj1!1!"2#"3o!() *+,.?/_012 3457?8_9:;<=>@?ApBpB	pB
m*CHC
fCCCVCްCyolectDeͿHI͹U@ and mothe _highlLtyour cho.  PresscMose.Seconds until au atic defa` start: ($R'?3;S!ZipCA`t= Dr= k`d hmܒ S0ô0.3&t X?  [0޶ 2F3F؊' tA<v<s䁊t1x& 2Z2A`Q[YAr Y@j@i.t
*Рv `v+jjj(Pjߚ #\ 5 ~dt8fz  :f  IA 02gX
 蔿  t0Z3x2Ɋ <tF8tF3F $ Zqfgq URVQ0., L.T^Y^Z]oSp.v*[pqQSVW/ s&QS.<.-00?0?0.AY_^[YQB8 qVu h^ Vt0Wt+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu@`;2b}Xʱvfmd~ qdt88r
;w2g`tJAo1gFY.*v<2ufQWa h⒩  X  h= fhԉ h~ h`Ӊ_fPQ> 浉Y,` hǓ;BBJQX@ 6xjf.fffȞƊ 2ɉX7O2Micro SmQCBus Reader PW .g&:u&Gf_g&gO߾_X   ?  R   	`hqPFg&F Rg&F  u
hhybg&F&XPg&F  r?@ &   @ ro)   [޾׎Ǎ~    QRVੈDT r&%^ZY2fЬfL	
⭾ Lу  rр ^ ^"  UG$r&YPS( t  r[XRN(Q'CYZQ2' ug&9N(  Pmr`r[ 2;w(;r
VꉲtGB  r݋B
۠/FVFCPQGysrPRb1 Z.>hohD\yfPS@Ȼ0ǀuh3裈thB p.>` t.`fQfRWf  2f?YffP_fZfYQfgf&!=TDSSu ϋff3mgf_uf.>if^f_YP̱QRWUr_ZЌжVW t@ߊոHu`ut_^`8 tX@޶, 
^ Z USۂwO0 F?SM䞘@ H/P JaÍ62pq$A
iW0W $rtDDRF8 @ A D]EHTFmd   $x'z b | 
   z PFQF         r k lPFrւ 	 ϿP@CS  C  鑐G@ H T@ X 	   Y 1ó QF$4&. U `/.s p@. r0`\. ab	h
    !! 
@!  U
AC 6^@pQ #qPp	qCU 
 ' f
heyu,!-!P=
PQR"Z߿ h
fQ3Ҁ
t
PЊ͞&ɭr`fYf[	ÐrP!ZYXw&> tRc ~rE^& xf3C h)Ny}  G 1% < t&G[ #	Q##3$&$& &()p(f3.2#*f&© uf
ffKf&&&fCڤ(0A1/	îO011@2#1l 2rd.hy;`l@ 08 !8&&i6SQ"Z3r`&&q&q@::r;Y{[wfPffRfVW3ffCf[fKfSF0r![0#а K I+r"ZO_0Ӏf@SQVW3_^Ќ3t`د3ff@+
%\p
_A![f   m rQ'Mu2`1fȸ uȻ" h[yhaL}%
 4nPRǡRU>fW Qt% s	 f& fff>&fhZ03j础; 	  u7)fw)fľ~/u!\/u\/u\/u	g& 8(tx3VOrnfQXP (X@[` XP&~/u\/t ^a	;&Q^(GfFDïijkm/n Ooopqrstv/w Oxoyz{|}/ Ooυ/ Ooώ/ Ooϗ/ OoϠ/OoPATff.&&u h^5rWrRrM&tf݋fŠ | pVV t#8r" #   /  gyN O7pf]g  EfUr*6V  R Z +rGq ?Kuf]F a> rCF+ @'3bcg&8E t fEGxf #RhEV(L(>& t`04>QThWSX a P҇f&xfgDW{ r^ r
  GC_NNOt$AǊO$wȠWw  _Wl  sq?_  ?Q q0߰@B ? ð 3 S Sp' "Q ΀PΟ ̀ȰcAQy/AҊOQWEҨuptPGX_Yù
 d hcxs@d
P <uAbڭuĀ PRO Ohh < ugZ0܊AD t	Aݕހ eݝ<|<t<t2<tH0M +[\E"L
Lhs#L`UfH#Lf
ïT2+"D
D#DDf_f#Df0f`Sn l 1l 
 1 R t {ik U 1  L Ak	 pU
 j U  t
 j i 1 k 5i J   So `*i = u S o `i EL N M  < Kn!  Y" Ln# 7( S$ $q % <&Pj <i* |d X_ G; 1' p) v+ \, Z- i/ T0 1 Є2 L3 `n= P> an? %@ nS &A rp bn5 2m "26 ~n7 'S9 ZiG >MH  : 4 jC 1D UE HkF 1I0J 0O. 
K OkL 5SM #N CnO XP nQ R V SiW TmXPY LZ 1[ hb c 'Ve ig 1\*" f"0 @ ؿ   !L  f   30/00/ E.DϴPX% hX@ .X=X@u
_^rYPnҊظRפc
9PWC;f&E1_Xh{ԚRhszha
%( h+Ru PQq0> 3_"BN	h_YcP dF$h8!s VM   ! $Ͽ!Õh=vP2F X ?9Spf	 If3uf @  7)`)*z)`))=``))õS?`3 :JL &>F&DEJ&&D >Fu d.Y/ή60 .Y/2j@ } 8F}
}	6>F 33S[tS[Sv 829[p#M:3 tth`Ocs
Jha-hR׈D
ϰ< =)DuL
p
E$<uAD
@sd
{#Cr& uCfp3` uL
 6 6F󦀿uW9  FX 86G &uh/s=	\
bF@u pF D&}?u C t&Eb t DA&E^DA&Ef߀w>Nt6Nj t.& Zt	&  tRQ&Rxu	B\	PSqQ@6& ?Q؍>F_3& ?WW>F	_[XNt+tQ# S xtR  t Zw\D@?PV!$!"桾tVh1.e2q&  ^X??hARr!L	@+vTt
v#n\`W?VV5'QXf$<v @L߯u<c_\SQ3  v
p
u$@"<u@P>ȷX\PRt¿:1thU4!Jă po=AZX`2ҿǿF& 1t5F=FtOu?0: u	6t!s? C u}x5,esx߃
t!B&Sa}}}at׿/PǷ3`0hRs&=  V @GHu @G}^ p3f`PG@XEHf_ } U   2H&egWʃO&MuOOofGtWt$Ot,t"OqGr p3MoOg&IH/  `Po
P2\hpdGe_kרtJ<uLD8V =_7D D	 d_
z-1QdbAtSrG&}	r??23nt`hy?a&EwO$B	&M&]\`.'	J%f rR 0Q3ϠUڀ ShچRF 
~|h8s܃]vRRB ZW&߃= uAPqa)
hf
߹ m_  P
2 
31XDе31` ߊ[Ы#Cfh~Tx q;.
!c[ Z +v;.-ы% ucu8w@M.:tl;.Yj]  5GtG5Xw \ & н  "Cu 忻T aË

	`PS@[Xr=2俱<.VW nS1e
5[g Pdο ȿу[ap$nu @\SQWf3Ҁ	fk_`t`֎ftha73۹ F
t):u%FD	& hTF & 	 hy	s.F3'a?B3 
3 a6p F \S . [9 r6Qo- r*䕃<u&' t&f1+ '1^1䨠t
vq,'+` QQps& 0R׃sZstt hԧr = YQ怶?wC[r=Fus(IE% = tPYvhWV]血p3F+S6 w
`PHH2E&MEQP,[MWr5P-0wuSvW[jh?xf?D^1 @u$P<PtRuqZD1prO"sZZRWV 0  PEX@_  C̢
r.heW26ƀB7߀?C@%?r@D	dUߋÐߊu,{u
@1

+&C32o3&t
PU
t&
0  ⫰5  tU2P-(4?
u: >02? %w ^PRW1&w%A8 &]7 &UE
t ˀA!{]H$_ZX3һ -w2C.%o/%N 8hC'_ %^F+%`t-//0O1`>u  '~au  Bmfs޿f3f`u 3? Q>IFS:wuBE&8Uu8 8]
R +B&U
ZK5ؾB6:ZfYB'qr hkS)RG/`8t%@@A8pÃh8Yrۑ\
<to|ZێûPbVs=^f~  XIFI_D
	Ld\pSOFHHUf`^؎ Fw!E.  ڎfafSfQf.EfUfff#fYf[TVftGf   ~ UEIgf;t&fW XژXSY	XF0P7f^V`2ۂۈfaf`PV0faPӗ^3_X.>E4 .`YXTACObFRKb QYb&ctcb	&c .p}E Wb%c@BeF5cgE fFf.E`mmEF.Ef.>E3E.Ep t@aEtRtY@aEtNpr XmZ@SIaVfB.qq0fe;VrT%1sWtXuvܠ`ri PWQfRYfVfffgp6\Wr.m m E[f@kfPf.sf³fHkmfXfqdf3pqu|Yts?Ixs*XmeVf+f;wfff33Rm҃UmEW^Y'RYYSÍ$.pXQPZɠ~}`Y333Ҹ  QW>PJpm_F
3}5upmJE#ȩ t0 tߋ A з~qt
нt} tWM_ }o   ؉F EF^V n SV^icQ&tY&  
`< tr&\]&\U@
&dNd F
S؂[u	F΀&4F^[_YCF FOUS}A݀VW>ًذД0' G'r_^WfQS h
#f U fOt
!p[fY_` t =$P`nPu2Mرtp6s } tp( ` j N& m_SRU`Qj@6^]Z0V` QhK ȑ^X~p*F
 ' t#[pmyPRF FN d3duhhdKu`<Uuùd `FhQʾ4d&&;Xqtû   hmrۻ& h9Ph>CĜ%İİ`ĝX!$!A   °AsQQiПۑA 
ehìr   tMt 4 aԠh?(` {tKu& &  
 e@	 `hdCsP<t<uVuЂA0ªu?1R*w`Ph7Xh4-0 % P5 &' tȵ[s#_ P?X7ā#eeKt?P`Z}  ,`G  ]#^ 3 ȽD1pÀ   ; Z x     0NPQ`^~bhWC1fF3.]OM r q
0ވBFuр~2wFd#^-00
<2wd8F w(8F wI N@\F ;t
 u@mF^KہcO.~r@V»/  aPvû< fPypfﻀf @ffRfP2f!Np&
 ffFf3fv1ZfFsfBPfUfO1 r9@\`f3ɐ04ǿ:fщ faÒfPV3v޸ͿrF3KX

S,0<	v	,$MQ.[W D

[LffO
T
ST #	#}
#f_Cf fv@kS  P :FP
umf^fNf?V_f^5PTR0f:!P!VVF h!`Vb
àff  fffffXC)4ѻ 6f>f>f  f{_!gfg`p0R 9 mT/ a3P*hDCP,0SVW00fQhjYÆH2۰uBqth,3/0_^[ø0CPRhȈ B Ph`H fP;T;M h=T;Q<R: =w whǝC=O@ hc@ @5;fQh c  8 h
ZXf  w$fF
п$EBPF$FB$
_иEHUFQfI VEIM8FMFGQ8FQLRHRH/FBGPSS@ED0` 7    AGpq$UqV p3qð V&qCɡW VĀu̀WVYt%Z XӀtӠ4\u`V%5û 3ɰV<KuPW;`kEhC:_01s-$d1S - t+==vPdP ZtPa XePہ?UuC33Ɋou uߌ- PԦ$ 0>3@` Pf^ X)U da&& &06t h30` hSi
t[ Ȱ t
ŀv#t̰u7vvs45\PX~awv[{B|8v&> 㟸 h`t`_P3 u $h)1D
#oVsyqst.>XX ul2hS`!艬uVUuQ 
wGPX2 Q  h^u= Dt= tY蝵LY.XX^!r@h蹵PfA]{s,uc0<  Qhs× `Vv_(L 6jf.ff0)E<a rfRPR r ERW37@tt_Z"SQ !fP"RWVw^tv"؀%kr3k@RA.Z;wpI ARD;+ȿV РE;6@.Z
= .Z=8@=^_&& " 8o@xxY=`SZ .BB <t BB2JݾZ   8uQ@U`23Ұ
ShGUs@t0`́ y autдi at]U [aSR  4 $@`1-1a`  h	 h{
 "B2PaԀa$8uXRP`2XZ@QrtwvYu0ѹ }R wZP\ U2<UE@TJuoTƿuJuǧtC(f<gUW@  whAոU u
3WҸ GΡF۸Fΰ) uγPs\tг _
߹N0U 0KBO

i0  @_pSS&i &&g & & & & wp@tp @wA2ێû0 ۾] o
 q80^1&>r 4Ou=fSmO( 1}8f[      f ǀ( )^3@")^*j	r>@s݀ _  ` ` 
  "# 
 Uuo A t&r .s t v; t虐q@o"of"3wf@O  f>  <  vlC f) '@  wf fQf.S @!a[A`uft@ ^&|}i~frC #m X 
8t"*e {t.xy{ 0UG5wو.= n21_ >=@,s
nPu @
Aˁ.
ݡ u	
t R.O#52&  ~#5h ًP hh s%  t>arcyh Y$ f%"a j j hMnXX1`@RCڋzSh6hR5[" tE2s 1|1x{0y t Gum1}/  tE. 0 
$%0   t!E@k66cta@a aPfSZ09pv%`鯡 D . s.(t/!R0B1/2[SW&L 2 >u
m @oB
u
>@ud >Pu>L rp7L wf@rHmSVWU]_^[s.L `&O  9WQSL O 33ۃ <@t[Y_h ЏW@u$5BSd3`<u-!f[U :7tuo
9 0w@"R8t8uL 2Hp0_[WSPR`ZXӢL`k:Ԋ<6= &-23 G&CM2 鿖 &EfN NdOM r&uO&5Q4MMX&NQ GHFOQ6nPA
6@X$OO&2uG&2%& !;Xߣ ױ@[_q:p޵_B ܙ@oޢ 0\+ \= u0\]t2!SRUfVЌňL Őf&7f u&Z&?Zu `b G&!d &@otL *f&6  80;t L "e2f^] VWf| @  !XfAg3f0 OOf G 1ckr_^0gWV p>`
m`70318 `> \ DTDo   p]|q 0 ȳ h`>tw pl  Q va (  vW @`>^ vL H`> vA P`> v6T W ׀X2u`2``> vtؾ]qhAaq|\D Pi?S  ր S h5Gq[`g?
uh XoVhd!!*4v*i#!*@PQWh3 0_Y` 0hPQ= `to0 @fY?X "@SP
&  ff?& X[@h  @g p?r  Òr `yBfRf JhDOFfPQ   hX.]V5 E <t. i~ tq.ri."D.|u.:DtSISwD:Sr5+Ss&zSv
uqPQj
cl`
 Z Z?2PQRa!&$`Ȱ hycSQW@a$a_m2揺 TCA6 @1}Q0C@԰@;uYð!$00f` =h^3`\ 33h`ݞ *39faÚ0.߶oh ߿ hǳh=S@vsI h|r< t t t@t߿(t(tɿ
 2c> BSfQWLH0!
Sf\hSkrT  v_fopQ# BBaTذʀt!8 DHhaW	6e贷Ch&cCf`  f0 "3 ߬`+~b @u>F&}uu FѶ!p 6USؑغ
  % {quB
h,ܔ7-v "h)"x@ #2sr&+-蘪8 й`{~Օ`>aPDܾ>/Xð? t
^53h@-P [W 30.n3И" p`ðdo`d"݄U ๻ pՕFPؿE04&؁` uM9NwNuӃ~ t"F= wt% @+7h@s1 @K I 	 @o a `wτ `*tsF4 v}G t>`uD*o䎨 f 7G adt5 t2 t tf{2f
A0CҁGenuu#fineIunteluw CЋ` 3Ҋut/g.f;tezZP4fPfQVWSR , 6jf.fffCv XÐ/1[__^fYfXr{jb \!ĝȝUНԝF0؝ںf`h% ZEp S0fZ@[a&u
  %=u?2KA(f`p
hqcd5rX 0eŋ:r;s 0ᅫ
!h⓫%d,fa+.t1(,.-f o<0X`6Uo6Ì  7 C"%8'% C< B<9b$~fȀt<p
 t0#ȋپP޾ Q t!u>?FYZ0i 
3@ @urf uyip
A3A@.A
;oCn<#EEE	F u @Mqr u؀ޱ%#hP"tM	OPˢ%TQPjFrX?r  PX@ASQ 32PEQVݤv@fWChq3
fnX	Zϻ ;sQSfArA G3҃f  2fƃ`0fXffA
 fA0[ffpaY+vA^qq_L2_&u҃ uZ=PrUfS%Pq uCfy**hf= i t0ai t( fg0f
Q0"p`wh:ӻd 0Դ h}CQ_Z $O۸8Ot1q

36xv@ h"E"F F h"="P72Xt vvOx hn
v3؋
 
>`|t. h3-@uKh~u;Pӓ.9z/~Ć% < t<ut
u8ùtPR@䈰52u  w & PPXRt'vJt
t@ර hms⻀d% r/k hSiBP>u` hBs?d-t&>! rwrԒRzspZ thhuuh	r`	 `'Zjj 6uS`` FF ph ru
VO@ VF  >t !$!$< uҒC` 
N<̣W2<ģ_	$ܣ䡿"3`Aʟ7ur1ŝd[@׃TYP=`E2t 52
u2Ɋߌ؎ |Ȏ؊t<u
52ȵE$<u&w $ĲݚF"L  N L N @ؠu û  t W P؟[UÐu
j ?jɟgI(!!2(<o!`հF Pzsu$0}t}$}~}.#Kp .t4&^<r&.w 3.\  U.\U.d b Γ 0 W	x .|_@DuQ&~% PsтPXӹ
 P|.:t
a ._
vXP%8Xr6%ȸu {Ua    PJNL p      QKOMp @{t  t P(.DG H_ hsQ? hvsp{hu hu࿒ AE^  f  Pp m o 
v %&.|t&ư
&桮r"$.:Dt1֗Ku
؟ E(A@W"W s	EX&P 3C  H mrr`2h!rJܰvaVRQSh,ƯThJBZ.68u,2
t&6@@t2 s>ޝ[YZ^SûPVcX<?tFh)NEjjjj P &h#\ hc`;5t = ;t= Dt
hU[]YWVSp``1
w0[`Τ 𜵋QΪ
u"1	*׿Oطh9Ct`>J=O2 0бf8~T rh¤P0:so^A\@0t!ltus:^ xQ%v Suyt-$p<pu ʟ7u z4 u1G /hγ~0O0q÷hD<÷ ~E!uhe3ZRu? ?#Y `Z Л3aaav'8af0  u@"t@"3P&&W(Xfu33ff&3>uEFȋY@0hL p<5[Q0?  :NQ02  ?AQ0%n 	
1333r3ċF_@=ǋVW 2_2FOt"72
u
2E O
 @2EO2&&&E=&e?
td&Ep=&&sEr?=E@&E<r&}	rw>>>VW^27^2*>
&}vBh8YPRQ377G
%GtWIlY3yR`WXZhw$8u5
g@vM > EpQ .XV/Yػvū}-7: tOQVTS
G*6h&&  t8Vwt' u G,6Ғ6}$ $ "`& && p]\`d՗dXe`P`  XCnU @p	
ڹ 0 . BddB把8uGfwAf;fw5f/f)f#CdBfdiiG66P濄Xc b@ApnBpnCpnnnoÜVwtwvMvMȰvM蝊`<;weċStX؊H<wM3ɆQ#"XR< rvYƊȊĴ3Їуڕy.87@r{zWIhu@tJzz	]z2z&M}Pwk 2a$ђf&. ]"\  V&k !< h^Єu$f&PBÊ$
ۿ Nu%q}uhsߡ$档&X@Pf  f#f#f#f#f#f#f#KG&fPfSfQfRVWhfgJ&$LxM%Xff
fhf3f3ɹ of0Q* f+f ! KPJu*XJآX$l_3ہ_sV4C\`] a^p_^fZfYf[fK3hIM
  `X3hҢMFtKFFߊ?q	1tu*S2Hg
 twt	IHtWЧuG⻹ D
  8u|* u
q	t	 ߯Da=`$2X 揀 Y`s< |&	3yt`*7u΄WuՌ F-&Xt
cZ4&KBC Kernel: xx.xx
 ` ؾlh) t? p.``S3۸ 2ҹJ%kaVWQغI ;_^t` h#73_h6M u
$<r (r	.P f3hh/.  %
ptwdw t
Xh$ZgTXDh=  t^bwY-s.> HpfѮ5X st&0f u@? o > sc 1Fdef Fc~ck7~e uQ C9  h#{
dFPhBFe:Ff`{r, ΰ h s Fdλ;  Qѧ 	:  <gĆ htm%h!hsaf`Wp8Kh u>ofB !SCA[t$ 8 hDsN rp@Kf`   F^ïְ%P XSĻ  y ,p   hs[t(t@tU,| M,ՌÂ ' qhń
XÿߋwM."I*ܿ*Ռ/.%X+ D/U2NfQdYF :uE1K]!1-t
t
u
t#u
tN `t"FF! u3! :5tFFdz ulm` F:_ uYP eb +  u6FO1eFfP f6`@up  jjj(j	R 	UaURqhN#12_   ;p1 hDZ]RZr@q  t0[CRQ QYsY2X$w
a !u$MՌ5Zf`GtB`u#IN *s! ƀu.> %faн`7ĞRt9k  m ׀+l0tn to͋Ϳi ݤ!gP sE" 8HhD3P/#rhֻo p o%Q2B Zi
!߱.uQ$<u:LpƧr"&!4tB1 tB1 tKt ΁P u4-z4Nި$-- . Lਢ{FSQ 3/u,S/w[rE1	ˁY[C <fÿf<1`00xx00`6a||@>>>r$.{RDtRDp~ Prċ8~'G z<a7= &2hC  E ҀHorB kvEuN D M$0)0N/WsA N0F7޳0l aUfV3vCDPDQD Z7MXf^]`Y#[`%K'
PduXTfߏ@  'O>o?@ABtoa  "..F tf%pty@@6FACS@wwO{4DBGP4yCOMPAQCPQ005A !z}R~y  m8m  xP0|}|~3	 0К20" y
 2m/z RSDT(?}  	~f`ht3hBt]f  fĔfj  gfFgf` FPTR ffggF f.^$..f.tgFm0}gfN~$f+0ChZi0qԘt3ffgf&f.>fKff(.t2@@~(@N g&F	f  rgcfff3ff+f+.⒵ u4f.>f3d$1dP`Xff-ñhV3g&fFgf^fY[Paff=TDSDt+ҩSt#ҩPtЩSBStf=CIPAtf=PGBDtl`Qrd< urg0bhRUfQъ̓2 twSPrDr@vӅ;0tg&P.XfY8]lehfWfVf&߀f0.vk0@(f`fPӣ)Ȁ$ 4 
{ j-jff	h3j@f t =hB¿fPW efX3 ˌcĿ gf`ְң.@P33PDDX PUUXPffXg&sѻhuhШ_lfPV F	 σAϜurzPЛМ^l3RW  h`#8 v h=_Z83CPStS`$8fP3h f&L qfsġ L fXp3`؊vߡh" 03of0C&?   6Hu  ` pOGEoHfa3[Ӿ Pހޭ1U1  Pވ IH>2H&geE E uMMpGfEBtXAtߴ$OAt32t)O$fM~orþ0mMe&IHawA   mø ՊTW`f
0Chb^! hǝrttտ =ϥƿ@4߿ Ԋ_lPShێ̌ҎӼRQzYZҋhp3^f`FF  h|t ]uᰒ hT w$w(w,w0w4w8w Ӌ9FtFfNDvFo> hɀ	(fa`E13MhAlt
߳
hmr ;ruazhWFH ^
f/ fNф %N9f.9ߗsu st_8 rfߺQPH_$rf;^uf;Nt7ft 2
tF~Yg_lɾwPR0 tY,!6FUZfV!	f%po
 `f}%Q%"2ϳHw`$z6 s
s r"6j.<t..T{ hh]^_l8PQR`;u'f@B cgZYXr10r,@ % 
 r/ % rB %r?1y/$P/ B A) X%@Q# h}]Y/12PQ't  eu5]7y8Os."7<8@tU8%7A8C:R.Z>*>fX?>h?pAS@hU]B_ [w^` SH[ u#x  pEEuH] .u  Lߍ~0rp&tjKt_& rT  r&= us)6>
qMr/r4.؋VpM< t ^Js 
t u v IN  hDVVw 2S]Z%h!Ta1EJqM6rPMtI	Ty 
TpM
MtQ& ds¥TGYwW~V
STz w+F`J؍vfA fDrb +<ffLs-<t(<Y#0T*]L^032t
t
u
hTtrt
<0r<9w*tM> ~]SQ \Y[,0>?E*SQli];| n1htiu$of`3pM& thY]ֿfv0ȿPhsgf9taW2@t  t th6r^1as@ctgfzVff?3u"%fp̀ufa
Q_޾=a3۹: 8tCrgP #Etrhsxf  |u  0   ? 0    0  _   ' ' $ߜ 
 م/[ bFk C$ Gم k"|цAVzsPS_.PBVW _׎~Qr&} u\Br	a:_^WҐr5#r!r&E@&=u	~3Hr&E$duĨ5-ת~sB@EӿΎޣ ͩr7waurWPDTtr&eY op
T3
Õ$S	ѝ@r# t itct t$ғgkffL ]`RWBQ31]
 ;Vs@E+Wz  Ԫr8uAP_QY_{qL[ r&U`+þN4ѡL螸Cҳ
P$X` $2LnBa耷<tBH~8`8u6
uB& DBlиdt
[`a@ 3 r/) r?%BB7J °
`; 5 aù<t
6BȰJ è@uH` ŊBI2۬2 Ƒ'u+BIńl&2]8uS\m ri@e raPv rYrñ@ t}Aq>f r2a r-&Α$vQa> Yr	2QƀrWYެB0ְA.׀Br@@}g_fQtA"p  u
3A t'g&_gfǰ GBg&G$<lCf ,COMPAQ PC Card SmartReaderܮGEMPLUS GPR400ܮPSCR bLB REFLEX 20241 PCMCIAReflex  v.2Tc!r$HP  ~a@g&O Gd uHq`fD7rLfK  )Br>qPG	 .Da
qPO@.d.Df.4fƱ_ 7W QfV0*
G.g&:uG`f^Y.5_.0`)~F`ffWr@PހgH
 f#G f_dD          VQ    P`@`;t
YY ^NV^$TBL$PCI    P  $CLM"    4$fptqfPfSfQfRf3f f3fg.}	/ 	@ 2 	fƀnuo 	nZfYf[fXpWUu
  	3`r]aq #6CERXYgc> 2Q`ް(Yùm `ù DaV  .:u.n!^$l	f_Q8aY!fQRfCPt
' "`
Pv
"O2ɵ PZ t"
ǆmWPfP  ؊2fl 2QW pw	tv2Y$_Yôq3f@
%S~` [Pp 0X.
tÀu@u[Pf
4 	g*f8 *a,Rff~%fؐ..+.;w
Z
$Ue <u
`V`<12a2@`|<z@=q<@]Q4f<	@}4[<
@4P<u@4E<@=p:<
A47/f= uffX<@7<@7]]fW f_2pPuf_QRfVfWSft,fff ^r!fp;tftfN77  +[ff_f^ZY^>с 	 r?prf r ;u*A
`A0BBC= @	ҠH sQ;tp_r"R{ fRO fZ z,X
[2JKLLLLVJLHM	NKL .PffqM PMLNKqSR RLqSfMUPKcWbqSLZXV>YPsZ_cW+ P[SfT^RXMf s#(` sf t` s	a t
 `QVWf&? f&bﴉ3.fSP&Gf&_fXf[ ` }`5 _^YSQR@>fPw&fd P g f;t
fXRv39W
ffff_fBfEff#tk f_TCM!p߀MQWfu`# P"f UI8s2ہs
Z*SfW`@)6-y`t#uP{aHXt}xPC[PSf<t; /30e ts
Hfu
utǳ%[`3}aPZfvl`_X1e'$PIR   8 39t0 $@ (!H   XF )0*  	 
`%UPWffp,"͆. 
2:_nPnf
f aOVW贠H#gSikW2;_t[lPmF[_^ð` @ p@WVpfHW ;2fA	f2f.f@fGfYfy^PC
XPS fS[s$fR
wf_fX$s[`fCRР%D Ð[AfS22Er'}z} uf8s֊Ҋ
 XQ iRP
_t0r?C#bE?E  uf 0úM % UPfPBTZ훱]fa_f]rffr%m?&On訡&Sq f@ yv` @D 蘀  @L ' AN@pUVPA_
!,= srs2
誱_ 	f^ i
w t;kp-rß*f0mk 	w:"Av *)ur6	z"+	f;򱛹 f{ 	BgRfPQNNO(aa 	rO	ðc
]

#/Vـ^/ f.RfJ迠HZRUQf fuffVfK蝠Hr=XfuNVFYQku F{MuY ^Y]9g><afPRg'QSVfNVFfL$H^[YrfXftA/3PX|`ڸM2NOPhUWV} spP  ֡ ^_]`phWUSq!蕪㋡ ]BpXRV 	^VcC  	? _? _?  _?	 _

? _?__32_  rQ%`S
[PS3
[
u		X 
0R@ø
 ô	u
 tw}P#ۚhsɄ3ǚrÊñap%3t_ (30K"* YfPAMSho_^ap%3&Xkb,f+WP_@,fppw h؃ un0 MB RW p$u! D   &FGvuv p c$u#' 3 &P7
;u
a70f37 |fuɲ8	&( 3_3GF< u< u?2Dp%P2Xð =NuBq$=,u0P ff A AXh}՚I HB"pB
qq$-w4"|r.-U`Du4 $
Ǌ@EN]DBr؊*fQifS hZ@qy؉0hQ  `  fۻI  fHJ pJpnyl f`qy rMf[q$5f 0Pf%O;t`ϐf0MnfX2*_@{x `[ú&ATST0SUXfvIp`d fw@u觙
f<I~Ҡ`PJef%
 Uy|[D[pZRYBI_Y35Z'CZ\]g9
 ݙ`fftpy" QB[Yдffhfa`RWfGa03ff¡tf Ou YWry12tp 4g tc%˻ʆ hrQ L G B = 8 3 . 0ȷ$     ; _Q&GYðwat
t0<[t = s0cVfP SQP28Y[$
P藆	fFf 
tN 8tS~PFtjpOp fu t0 | |"} tr} t	C|xVaRVY sZ  Zñum
vwcw$gy4 q$Nuff`4eApu4fakFD@2@ZtfFP;^DF} s u
fWz !#ufwF$"~F(b|'F,]0RrB}rf-ޡ}fv,v0hfN,-Pgvu(UX($иP@N$fFfV fNu2N t
ffFDl 9Nжc pN xf`:`0q#f#ff 0fHfVPf#f@f+¿f;FLvLfFPf)FLBŹɊ0fpvfQI۠pOp Bwf*s!fLff@0ONpoXfUG }PfA!0;V_t
fAPĳ0c P f%]" P`]L@"	 "ؖWF`]0.~Fr@ eP.WPߒ j9`yf_. SӶt1u	葑QY 
n[_ZYXS賩,#QBi ΁߀@;@_Y[`!0û  
 0M 0
 @p@Üۨ!8 ! PRZc@y+L 0@õ谖%s36;3@ɳXrUfQfP3˃P  P] USP#X[t>#<!crh& .]:uESxŻN
߸y L55vΰγSz ųL{[ų ~ vų n[yr@CNŐpt'$$
Ȱ5!
ȷPMq+\rP)?uX-;r@qU?ȋȻpcr, b+f݋f ccr ``/t#s!SP	0XP rX[t< M u`$߃u~`u 
ڠ/?oh rxtu	qtP<Xs<tw@`kfS˸'u[Ô " % 4 C a p  SRWP<  2.J  .  `/u`   
 ۠ Kk^^K s@Q@ = @ G鯏 @@`|y rt&roMjrey r` [rVj rQ rL rG  =t r8 r3 .r) nr$[ ra I r
 rl>Zs_Z[ up	><t<
uЈ5u
XXRX
	u>t, $t-<v<uP<r<
wPր-t	w	
P& gʐj
>?
t	P`>| HzU	ppRt.!]!!""&&Q""#P##rf%!OUCES	H  ufuf#sfVXRQ<t2f3r6@+fu g> tX br `R	Yh[f^U %!"<"'##WR$Q$-%x,&pg"tt
Jr2cfX8..*`/m/ +0 6.8.-<t( $r!fQ#_ t $**0&(4<1- 5>6N27`+7X~f f#etP tu
 ?u$u totjP2Xr`sRH  :GfZ3Az{@I$
 FNǰ,9$tpGHǴqZa8bfVQ! R#fF Yf^ FFǷ  !K$F2bLLGƻ@`LwL$ߒF#NX0NOLS )fX@	ش  {[PఽfV~W _IW
t<5t^Јfprz0f^0r{P0QRV`û fpWFK Yf 1\8uq^iHP L_SIMPLOI_MOTOROLAG_bUEs4w~ЎHrr"  Ĺ
 &s7c5}dWeLfSUVPV׃Scc;Ňd0fws˻ʆ D߆d >ŷ> ŷp"ŷp$ŷ>&ŷ0r(ŷSRr&
 3-&Z[>*ŷ0r,﷟Rs1ŷW0r1squs t
@ tP+؋"wt.ŷ0r3ŷz~0r5ŷq0r7ŷh0r9ŷ_0rL߷Vd؎|&3&M<St<Mt6&|0f{6(~
6~^V"gVlOɂemcminㄯ*oe1p>gp0iQq0kq0mjqr0osasostqun0suexQvZ0xBvs_wsxtuqyU(0zz0|zU0~!{
0{0A||O}e~~+s`/ e>`&~X^jWVI.\GF< u^_QR׺`n荃rD.߉\ZSRǊi@	pnȊRP [ȰNOO@@^OY$O+?^Su
?Ӱ#T#[PZ POXFPѣPX( NO	؁򧡪ppW pVWuht_wZwU
suQ+0Et>+ r2
tH° r $V Q0& $A  $ 
r_^p2
uC>r>ѣF>rtٷ>rG C/a>r*ݶn>r
b>r^ НL6>L9  
 +O ?+  t3;\ն\\$=r:WQ 焹Um
_S0 $@ $O $G1SF NR9 Zð赾pV
u$rWrZh'ð 脾Ë tt	@u Êf
t Н s3PR $PG
& Zt
u蒁&àBt'P
!&C 0tĠ'Āt@, û@ P/j >N wQ r
?u pW^< u'' t	3r upW n`:(Vsi1
u` )뱳2 _<rDtkжWxEpK?T} <`ps /V i ttD?R 5I+. u$Pptpt{p<t~ S8't
' [lucsP8tKTu<tB<t>u3
$
@3
q u) Pﻺ  Aƻ
 3Ի$ݻP3Ҏ¿x ȫX08 Xx}؎i &g +Vpa `U
u
fN@@]ϰ2?u@S\8&&G&G&G  [] !@
@
]@
`

\&\`UF0 ]..03 и( и`  ZP@C@ȀXWP<w3t u*0O $H! & ^X _O@P@U{X<$B   ߞ =Rr4!fXufQ}fYgٝ1H I[ø <3]Ou  Q2+{fPS=Au@u;Áp u39 u+PC?wufP@u@#`Xu
_ff@[fX軵%{A2{N	{S_{&&&$1{&{&'0{V'm0)&&'{+ؒ{AX{++++Ko{@('3ɍ6F.L.:Ls&3.Dn.Ls` ./roZg12.`J~. /Q5u KbU^5.03tP6t
t
u! 귨t ;u b ta6>2H.| .IH u}?}E@ @ JIW?}uL9W C u3pC߀uv>b~C_tURQ6?UpoKr7YZ6	u>^
.D +Jt#V.L^ 
.L  .s]å2oQ3` |pYs. u&	 t	&Uu" ώǍ>PJ |  Êc.f.O|fX0T p.|qQR߿PJ\UQURVPQW 3ۍF6_YXfVfWf fRff[f_fgZR Gf;t@[[f`Ȁt  s߸@/ uf tr @_u
 faUQZU F cE] < t<t
<tk\Y{]GjPQRZfv u
ˀtuu@j2PO' ^~f[ZYXhZiPkcrg?f5!^[f`0eX ttP
  Q	~r Fe/qwr(srs@/fahZ i ea ooNff3u
`[pPZZ  f3g1}fF	\[Xw{c\w`ee0efgfffm^Axʀ[\1}mfPQ(~~Aox[YSRW*׿OзIr 2 v 3w_RWQ|ԴqsNӴ Y|q r3Osv QͰRQWSP $0X Q쨀t_vY1p3l@B;|sX Jӑ 	uuX( V_ m 0P[_YZÃU2<UuXՑquDYJBBt{r5P!uAPpu؎ZXS
u	 ׿ ت *êVWQP Dt!WQ@:t
Tu8v
Y_ Y_XY_^Ç#`  Xtj~ uu3pqt$t;73s.t;;fqa;Z?߀tO;tG;B`t9t5F  F!duPA
  mP{u<IrˌN.TV
@0cu
pr.2^.lnLN{oBZ?`߇X0nV3f	'O	O"O<$OI<V	 kuL rxe0<u.;oTtqt@O<t rZQH=@fe3r3[R0ZuPuLY9>Y
`e(4o}Y庅 ._\Ycз 31δ23	PXa''tOTVyO"Rε/qILcL OHkX g#XV`t t`<u
 @&   >@tA AuԿaP6@u  ,(q&w XVQ  0`O  r
 P<Fu us	ۮ Հuaփp:u	 X7 tG=u6FtEuU߇rPRtKxGt& 0R] Zu$Duhop2 h
Xuh#"X&  U au@ ϱY"`:=rRr
#r{rH d P dXP @$& 8t  Q`quS!^ ` &pP̰o`*s: &o!@ZP @@XQ0odY^ [Z萩t+ 1ǿ> &=$R&}FI1@07 : uU~ ~~Ȱ~P[rl`_aB0BggSf f f_f@  
V_Q _Ha݀_?[!!%fF $ f&|  |0:u9fT`#o AP2}p fr >u] (a6 ,_9  [[b{QfV 3&=UtZ$035yf   f  g&Ng&_y%E~ &ufރf&& ÀP\f^#}SUh &]S^ ][z&uDf&D0 V_f!QL
^跟Ɛ 2} 0 ` u,0bq!=$`e`Na+Ё$?aځ j@& r-0$^eu `@#
B @#;uu.Av3Sp@# $
u[2u:
t5<u
.A u'3 e.8AtCS@# $[
ó&* ؃.)[ô` ab u ppI $
Na0.߸tt5*
 P  '0p   p  ut@bЀuXR2 B8 Z`3& B( 4PXW$5۠55pQ#6a7SR߷ Ptϰ$ 2ZЧP28Q |3ҳq;`p _bt+;F;  UVS<  K=(u=}+>j@ a PSQ'8[Xu	mQ&A 
tÊF yD@ N
F&? 
ĺ?&0`Gr#}&\
~tJ/8sjQ߼ jurjB@YÊE *F&dؠFNAO=GNGIt耮QG
$j&>  $> Pj0Sp2ø fF ıV؊恋VWÊ~
~+~%MN >A  taZ	P|Y ]lȨugVXπn@\A\@\]FF@H$t#*@\ eu B t8iGaDE  (cdqccpcqe¹dcfcoi  lFpoypOIEMAG  IZ P  ki 	

 [ `goHDA-L  wHDBoA-EopCqoUSB-[FL"rCD"rHrLS Intnl?  PCI-ZatBCtC  % eOu_uuj	v	vv	vP 	/`{<M Gv |c{G{f{q|	G mG` @ zG2 ?GCD001EL TORITO SPECIFICATIONbg_	.FP  `3L$UUu  ?tP+a>F.}
t"	
t>IF .:Ut V	 V tVR+Z|0P0u-щ$<t" 򕉀}Zau^^ Q  | Ys32 ur^Pks2t*RBAF.u 3ێێZ
t	 "uuq 
 Ǭ]`auY!{񡀔
^sou!աuP`s4XPt)a&VڀT
[u5!uX$PnP!vJ J ~J  dfPff  @ fXtfUfwPP9'tg]`rfw? q`rd^fX]ge333
rVd4Ad^;sgu0
304
s M ptAt<V7
r0dDg}
^P᳋VWd_^gEdTg}

	}gE Ptr00t}d8tPW<ytqM@DMr	0fU@f]3
t Q 0KP Ó' ^.;Gt._
upfg6$+' +k#1dm}rP0fdjfrdj񰾠+ dMd5p
Vdmd<d;]t"td|d^UP~vЎF^r ~vFUn ]~ й
 X 3
'}`4'` F`pF/=M3 .;v+GuBG
pF/ǐ{p % 	`XvN֋Q
 ߀0ʕNY%'`0123456789ABCDEFSۻN׆[OEOSO<O  A " * Gxx  x y 1 " *
Hxx 0e/ 3  $+8y y   -é uTE ذE
U`
 r~  t
rpPxf`ti2P/tW &  q&E3ҀtB&U
&]&E  t0ûOlu&Em&EP0!fa*578F'()+7E À v5u t
&  `
x_t^t]t\w7utF53< v
<ar5<{s1$BPɎP aXuôr2հѾaUr9`=2,=a uk1
G$1
u1
@t <zw, VtA	4
{둠t
w
,wab2]aSJ, E OsG|2)P!	
 %P	 t[r0r 	p22vPQGs	} 莢	EYX pZB C iR$S3SaShSMR[Rg]ɊvJ ttJQ3wJ`]!
Q* uQɟsJ## $!;>tJu5MGôu辬%`9r&<Z3   3Y[ШSRV#Ɉ&}J$ɸX}ZmwZZC &蘨tit#c,V>MZ^}Jn6ZƝ< t3^ZX+VZ &P,uo (*Y`r(- ZY2SQ2 34r(4uKȉwJtJvJ7@輕t/w*VRރ| 拴  t.SZ^STRTTTUP .-UBBBX$JJ2JB`%P:ܰ@֔tJ ΔXu!@B)SQ AV tA&q JZ @C@ıEߨu*DuPyE= ]Xruŀ̀	pC)P? J (8SQ2<

2ۆT.
${6>20<>A?Ǵ?{)<wI
u@@À>  ` 0     U uP0Xd]<t r
t!d8D^u
PSQRWul__sWVT^uV_ZY[X`|&
yt,ـt&M1&G&a`Ň![[LAAAa+Íu 2఺t
`bۊacQb܈$FKuðW@"Zu	ۍY;Y_]leuffS؀upu)4 i(  [2p n l kPlll #  返Ȱ踔豔2tð
袔 c, n蝔薔菔oz$ztoyøb
skRаKqn	Dn2=Pos s	2 : | +${q	0rr1s{s2rÀo tN :`6q0rޓrד
$s
ɓߡ$桀o s{$sVVV&WfWWWX]XY(<sW .;X_. 0bÈP@XspiDQP.u..&+.	Є9ð@ t^P:.&u @ u42.. wW勥u*U*ľU&u XY 3aeP A3.G0d
XgPW *.WWȎrՒl_AZ)Sf3[ffÊ$Rf
f}IX$0)fRffߋvR%  ff0fPRWS22f@k r3	 Cu C8s܊[_ZQWRfP
t)=Er@nCff  u mC8ufXZ_fYþqZC4 ӟv IC
tbC tPCWQ3GCrxY_}[+[9["[b  :c` G07" *p0q衬ܐ6	PA~b YK]}7""}!CBRQd ̺ RYӸU Z"  PQR菒u6 SaԀa$8uP& _*ZP= u4pQ 0S<Yuq<u
 u3 1uuu@1uk ufgR@Pu5?kaĆ];]I]2]SDEswĭUqaRu+D`!k+d m "  D !S"6FDa_ @ [gu)IsU IFG޹  
$&&EP
ZEAPPF_ߕ )4>>!]>0fJ  $K K  R ,R CU  CU1CU  U	 Y
 CU CsU@1CUB1C  MLP LQ CUR  LS CUT  LU LV LUWXYZU[\]^_  ]` ]a ^b l^c ^def GlijBN\ZWcWfVSQf汜VF! [Ys^(2۹  /F  +^D!8u`Y[f^hWVQCuK3/{!p w$I^:u:\!ud Xr6YԆf^Y[_SPk<`F.UذÀu@u[PRZpSط$0<:rd uPZ@PiH qi=pAr	& V: fgfFf^0RyZÜSt	tv
 vt[ ؎ Ѝqڋh	aQ.FF.:$t Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSfVUr:ud66t u3N@f6 Vg6u^@ ub6u66 N\` Shb6tE#6uw6[$u
6t!E66"
@$5 4
]]f^QSWfau/ r)v t!ufPs :fXt*_[YfSf<t;P3fp t	fQ.:u
utǳf3fVf[^
 /a𝃃 --VdVeVh{VR	     5 . .  GN N6c c  Ge e7g g  	Gt t;Gג 7 n GppRG7 GН6b;5k == y0)y`b>|`e>? >@BOBoC?FE:HfPS@klff.d?eOzI.df#K`PuhYXp2 hM 5uhMaúB   P$HÜ.dϻ0 f`X D 8ffty  Qf3
9Y ,U8DV U8T8 _8Y xUeWVkWXRX8faQ1@.I -RfW.k0u"mf3gf&@Jf=SCAFtV_G t"ffff _Wuf(abatfPfFfXdf_ft LVu SQRVlx  tc_Pt#>#KXSQx$PXr$Hkuk_!Q$
BB [HJJk4HX^ZY[ϹUJFMFOFÉpEpNEqEópdE0^fV0IvQfRv>f6v׸@EYrѰafX f`I 1%/ӊpR0۝ ]VRQuѳ0ۨt0yʋZ^ ״. 0\۵ pp+$
p}tt$
!fǍuBf=   s:2E
tfçfv`f f`rE> t SW,f 3f9u1QI^ۋ^&t0$uG&uF0t0t1K]` (`\rPh䠄t"
   _u!!tА &k XQR3Ɇ 
tw ZYJB<t$`AJB䄁֖B  `ÁUUuf   f   P@`Pρ
Xu!P<Xu @Pta`
  Pxq=@x Pu NNO`

Ef`rOr	â`g ji &  _
9_dP_ŝa3o	05" аrQ>_SM_ P#G_DMI_ >o  #7HC_OMPAQ8H ϱ/Oo Ϻ/Oo /Ooɏ /Ooҏ /Ooۏ /Oo /Oo /Oo /Oo  /Oo	 
/Oo /Oo  /!O"o#$ %&')/*O+o,- ./02/3O4o56 789;/<O=o>? @ABD/EOFoGH IJKM/NOOoPQ RSTV/WOXoYZ [\]_/`Oaobc defh/iOjokl mnoq/rOsotu vwxz/{O|o}~ π/Oo ω/Oo ϒ/Oo ϛ/Oo Ϥ/Oo ϭ/Oo ϶/Oo Ͽ/Ooŏ /OoΏ /Oo׏ /Oo /Oo /Oo /OoF<`ШԨ       
3f_evxgqbńD
 uj@ t%v v t ArMv .=sN-f-&A F'N- aύ6IF @ t3
tr r	
F (|r
	u^'Òt %?	xQ*1}tr`/5rr[Qo
u< r<0s<"N@` \1u'`$nv`f<0r
ݠsujs>G.u.
I.
MȎ.}u tj@&u |t
p! ^!N%V#!~F2r2%ss 6< s
	OtE""Lt*$Ot"#Ot%2( 2)A *$.EF2d$!r]RsHs1I9 <$uw2t1*<#1"< u1<}v<%12 ÆUu
F!UF% 4F~&=r&}v&fP&Mf&E&}CfX sm&t&^Ë^6G3܋F'6;rfg	DEbPQ~(LuTMs fPf-}39r1>2HJH.  -.GTώǿPJ 蓗	./40.脗3V#:Ttt<~'t9r0[AEE&IH!
DDH%H5O8&~0762H Du0JfPfS8f.EHf&]f@90A[QA6'6QK  Kr}]KrxtKrlKrd|tZ+r@ u~ (um-VƎދo?^ @TtfUfUfmKruFr Y<Kr)2r$]/KrJrRVKrdNK Y~P
 >r>w
u ?fSfRW ـ?f.Effff`Ucaffs<  MƿF F
]tSuNff3ffV2Hf.Wb*f8f'w*f'F'*2t*܊f
VvfVvF_fZQNFsQU n E]YRPXtUW:>WL_]sUr  NZòmPRL2B`q`qZXQR`Uюً `
o^ZYPpBn0rSQRAP syI m ?  {Uv H]txv`d Z^Nzdv t JIr{| rv= %>
H= !H1S>G KA, s,5<s-2HO8LpE
t" >HG<1#;<1$0GZY[tPqmX_ wx k waHrzGruQHri8`NvHrWu
pp%ع {qMHr.Ǵt%ttt t	tcDa% suGrG	 2PޠtReZF sH<t<)t<(u;>A u/WU>5 I]_ӣ5Gr@ߔGa`@-Œ`^aPp0rPSR 2Z[@pRFtN+P{X1dX	F
+3TU XXF
t
 
`{NXfS~ t=~^f~^^~j^~FF
1dFFF f[fQ
tW 8vNa؈^~nNfnNfˈNnfNnĲ~*Ċ^
^qdfY SQ_fPv j 8¿rCЈsfZRfXfPtFfjFaVv~5dfXr+t a}a3kp tf~f    af+} kYÀLVu$`UΎJ2IHt
.v	?^Pp fF! PX0r t<"u<"tNV3޾x 4|Q&?s@ s&  &GG
  P&O &OPLR af&Ga a A8Waaaak WcU  kX𑞰sQVWA:W 7tN7uu .G67 u/ ?	
͒ t,6o!OGA&&d&D&t&DJ_^oYXV!
]HޱA}"]pu`IH
 F^4&^} ^؂`# /ݵSQuP T$@PΊXu~BߧT@QTTXUzT$sᯑT8tu
W9$
,RVWf1.1Vtf cQ <VV <WU  Ѷ T `aύf˰>}ðǍf@6Ӎ̖s >up|ƿf2>f쁀`Jf fdOfݍr.> u# RQu u
[_^Z0.!Nq%pQWVV_ ߾J^_Yñ>ؽ5S. u  RˀRuYu	qc3r
+[Uf@ot r	%.1]ô&&U v rDVGG5AC^GCݕG&G\C@?tҲ		k9CMaGW7A_KޓUwaߗ߁&߲pmܛJpSGA&Tp	?@	fWsA1< ufk,u#zk{ f3g8ff=SCAF%f_U2 	<! F ]tW  Q<w&< t'V3ɊȈCFQ^ t	ǶeN_sVV<v^.BQ; ؋PBcPs 2DC]þUrP Xs.V O&]ÿDD&!&wQ&@?\:&'Df88__8Qp)^@Q70&袏''
-ʏ!8`;v,,*B(,#&Qlr7t'$r-S"X*~p O1O0OO["2ɵ"K@mP|
q@tXZt'3쨀t
N&A 䙨PltgR't$<s@t+u8<tPa'谙8FPFZ= Z
X 7a8!83 xtuCF <r!80񁴓<@t<t@<wgr =56*u8Gv <t]=<'wVkur~ u$<s?=<w<'s*ñ>a߃f ^YNuE u| w&Au tf"K tB"Kt tP"Ki tEa"K^!RM t.!8 g =`p8-躗u)H:   =- ÏF 2v  X'u}!/ PpT[F P|utmz
SQVP͗1ZZYМ2fWA  
Bu$,3ۊ^Ð8tMNԖ0`BU$< u*<*
q tJ @t2!K1?23!8a (88xx0gp0gP3Xû w "Pph8 q "`AМf`HttPS t  [XfaPPU t6;u+f 2 f}pq kfȃuff#_4]PfR uXQRW$  v $tu_ZYQQ Yx@uvdPv1zv͐zzyzvvuCwvAz`u%<zygzl`ux 1 u1t;6p6 6 y13`,=
u
"=

u5w<t<PW FQqS $s
Ê& 
 [<uaw\wWQu& 臦` uOq`'?c&aHᎿY6_ FF';Іt@2!vPF X ꏙ pq BDӗ }q	t 
t	u%  @ g ,2OtIG м  ?H.Ft6} H<u@2Hhp2 wh:JOt蘯s@Θ1A㞡Ws
t% s
2"  |  c .Dt.D
E0`` 3&&D aø0 ` j NH&&EЩ H3Լ{h  AGQP!AAXY}`.\.TώǍ>PJ.L `蛀a.D`虀aQPPXXɎ6a̛؛囐	r*.mfd /GPIq4GX$#GPcdvd
PzNqF$B3cr2m5WOqFҸqF:XpးFa!9dP 2XPUv FpF !Ff ]{XbX
@f Q~<0 u<0 l<0c<0%Z<	0?Q<
~0YH<0?<06<
0-P= PX<0<0/o<p0|]WfPCI 2)Ju_fQfSt$fѻ9r f;0`tN紃)" f[_^fZfYff !r  f {up
NPIu00`I }sͳ0 2SRP߻RZȝXZ[ڼۉZWԻtܼfqePAXZ覻ffuڊg4Z[ڋD~Z\F*f캧fP+ s"s t s t  k&= & sV0&ߋEfX Z lWPwﾐ;t
X2 *W 
 $_ #tYX PN sRQqу sn fPffÜff 8s2fˁYZ 
CwzVS3 .:ğu.şKu0"[^* @F.21SF  3Sѷ͟F[C3N[v QF ?tٲٟsF2+~pY7~A` _`8)d)dp6+	o)`P	)	ϛ通`$ $b%	*P'@TO OYWe$	!L !GG|xpƢ*S|eޣO.CWF.}
:utLpu%vt>JrS2H.[tIH.[u p{wtp	xt_M_EfU쀿v"%v t Ar"Mw Ŏ.V PXF
Xf]h@ a82/j@QRp&`]nu\OV(c ((=VH}.6y,{.t.I.
Lj@s& `-|/u &^SV+D.d.$ʋд/^[!(wq(*Ó1c4j4rcOt6	OtOtLtDGt
GtGt?Gy,
{,xu	x.<?x.}hੴ% 214ÁUu	?U `a&SfQRG r2fL/\pM#`&Zff?@4?2'AfP<r|wfD Wu
@ESxtjU4uP؎&Br ˿HߋG>yI.>{󽋰I:8 ⽉PQHa 3HBGݾ&wG $@N$PCN&I@N(USN*B>`Ë&g0&G1&O2#M$U&G{ QAXsl&? ڻwaSsH H@N@NU
 }ff&GfE1WW1Wf"Wf@N!@N eWPv޲`zravE./LuRE<sofQ@@M}3@ fYr/>2HJH.  EG]PJ u./5&[Üu_QWV.>vWu@/GPmFr =yuQ_.E`e.&IHW>IF`eee%e5ec-Iu(َᴍ62H &^_YSRcct5ێۋS.]&Gf  EHf&_f&_@ f[fY2FZ[fUf,Sf]$@u  8 D }ɀT8+eT?r 4PtPQYXðq)D
q$,Du NORP;XZP <u
XPs귄3ɺ] |.
X `s.safV`f } !p>r"sw   	 1af{^ `*2Ұ$ԉNTw@~WpF$
&FG&U_V 	 @#aø 3 PV ר<^XrsCsL SQW  '_!FT7/UqE@ pm ytpXH Q Y3ɃdtA<u韺 6& ךּۃdnC-1@ܔ2Wu濔!F
(<Pd5bKPu&XW<ru .{_Swt 
' t r
5ae u0^r!<u	r@2 @&΀Zs" r2.t`& r&>As?  rP I8o r && rr	&ô Ss+&' @>' @s$桖sQ
u>[ W r% $ r~ rȑ	i_ fд" $ Ы&QPpX uót s@t	`('pt"
@uqYÜP`
 Xr`QP	tXdYQPpȐ
 t	`FX˄d$!<!tDA>ϱ@tPGX	fUfPPZ;f]qfŝf]rPm  |nPAW @ J @sQЍ]f  BL  xBN 갰BPa_AXa{{ݯA*qAݱAݰJR/w@PFP%]X `j j !v
u)Mf.N. 躪tI F ~rp؊^)̀uw t&Du⭋^^t<a.@t&ڃ.^2pڀ3`6t6^2߯.u @ PSF@gp''.:t	tX._P}Q
! ͋͜?8  ͑PRS% + ;w[ZXf Zr-s(@tH rr
 rRVvF )r:Gs5&DC H Prf?ڋy6Q_ AFÉF(t S^$:u [r
F&F$pC%&=vHH&
D&d̠u rcwuu
 !πϠ}t&DB ĪǪ߼`Z T(q)c  HUr@ap_1s!
 -su fq}
 E PF 0G )
V N8tr>u rG o!ƻF)r\ A{r=H r8r{WsTspF#@Rr
 T@÷M
a|`km PF("r#謂Qlr?@rk`Pd rF( &d&K߉V& %f)&t N.f`O tGRӊ?Z0訐faVWkPѳ0螐NfXfYʋ_^`!(+ 0y ppH$
Mtt9$
>aïggK򍲲,NeIeA72u   树 X& @F$$<r$:u s
jút좌 
   @738  $tVrF.^ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (P<$<'E<&f$`
ĢF f%P$m`BG B<y(0ø fF" PXۋN8NwN o2NO!`GsHßGHmI|p
 r
sHfQmr77u4贀fY_"Ø4&%'Á3bR&u 05t*36rm CEo _VQB A9O\90B ^N 4s
3
3u3`Y菐QS@Q%uètàt  !54V&T tcu^
* &u^ô  T> @QPXuN%&:LrPQO* r$C`J@uN<upZtQ.@ Àh; E 77p$<@tgA9Qj9" ÿ!$!wQjzBoU`>ùgK<P[b#*E.øJ`UQEufVKrK,ugfPwNPwVPwFYfu&gfFfff`MuY2f^Yf]Ë: 3R)QSfVffLfTfDfLFf^[YrxXt	A3PXføM"øNOfSQfVfR@WfP<0t3   fRfZ+,_f]fZq{[PfW t0tQ uUP@XYQfhВ `YXPt
 t$0t_ t`˻|tXRfVFtf^fZF*TVSQWfw#t {r0{ Ԑr	0{ _Y[f^QWVKǑ}^_YÐQЍW2! u[ك!N[P] R Vv 6^N  (b VI>R a^1{_f`SQV3۬
Ê^Y഻ DЭ;r 2p01fffa[.6fff`;w	rf;waf`f`PS`*. " Eu Ц?f%4?^oAR0e$''ذ10 +0= <r <3fȐf
ffʝff   f-;  ,QRW>`[3&G;r_sZള <m  `S\ Q	t[c )exfsC3    )4e f       PSVз-轿//߻߻/пǻ.u/܃&&^QQ p_f`ibs`@ ū @`ifYX4Z4f4fZÀu< uEuPPu9uZHPPE EPP runtime BIOS - Version 1.1  
 by=b־$0@LX[^wU ."] .A.ߋA;c;KR.APBZ@QRτ Pj<rt2[U$ԁ !Ȁ
 o -h?" ZYSUל$/ [[؎BuR״ xuߢi
 S5D.4V 1	 &on ^n&Wٖl _Z@- u
BJƯSU@@SR t<rP
 j ?G 
t<t  ).>  )\. 
P`R3qAB$ԡ3ɠo@ q  0pFP a & '@M j
 t'   ``=' d u @@	 K L e l  
 t " `     	=QiHewlett-Packard 68BAS. F.2B 09/15/2004 hh oJ
 O

 
 o@KB}CXX.XX 
H `o
# h @  A  ! U10 Intel(R) гQrnal L1 Cache 2 	
   PC CARD-Slot 0  
 32  
	[
en|US|iso8859-1
 `Q vPa&ȓ &p DIMM #1
*	,2,- @*" 	гhSST49LF04P%h
Qi/ ?`i@2w~h S&~h
8Rf6гb& P~~

@8 QiPrimarqy_/~;b&MultiBa=>tQi?  c0$`QFh  k
F hr !KEND7hR
	

 J_L	5ddO"_&TJH}
No bat@ yG"PQ14Qf`C t!ыӊ}0}faQP0P~}t.}X?Y tг 0\} pp+}$
0}2j$W_T*u	 E 
yjt6c)ӀuRct&  5& Qc)u&Qcu#ff
AgQcu! 8e|gff_ j5hhk(ll mdRtYpdvMjuG	jpu<ppu3puOptRcup tWs3tAg0>pZRtpp:u@08*6Rw:EFful_EwEjPg} ,jtTt̀t߀EtHepZ7ۄAvPF )t%> t:& tSu0ZvEul!3oqhppo t0z lvE>I@fu	PXfuP3 tDX랓tt#r#l@cpsyIvEo uotpot0r)f"lq =uE3Ĉ dx3;r.Dv+}WdXu4r32#r*u!.Û-rhAr	Ss2g<Gr<SvP Ê,Ga.r]a#rJӑ2 us
<.rpwLu2fu@l2wKC"laJr렐s<.t<+u
0 uθN<-Н" uJ,0r& 
j6 ;6 opÜ   ad `
d`PQ3`t
ǣPä0Zrdr
`r`P߰!0!t"{@  
 ް  XPJXSP@ ߎ +. s#. sXP &   &X[ç ]'7Su!̤# `ur(D
@ vArdHvA.sNfj@&t FNfaR3V.FZr# M u16IFur_j t 2rY@ u v pr&4&E0|pr"|(pr2|mRs ÆUu
FUF `	fpϽ徰ɋ}	ԅďrO	rg@eg5	ƌpWp	^F&?s s&  &G&w&GP&OD
 &	GfPfR.Mf. quE	ffֶE]׶ERVfQS/foD[f@  fY^f& u#f&GWfAރ ܉WfZfX@fF~r  vt7 w/r?@08 u tB t x2frVʀsF	0!F~t$@t@u/~ǉ~ %NV`se^Í62H.|uL軼..F`>IF .:UtapFaOWQS.ن? t0.}u.:Mw#.;]	w.:uwPw.;w	w[Y_@ p]>ـ?r.u|
ՊSЀ ʋ.Ev `fV|fvdD؊f
@NP@.eXfȋ.us$
2
ў-fXIdwDfUv]f^PR-B    ZXRPXuUW:>_]sr  ^$<~`- r!P@Xu@>~ 	@<@`P bsXXty>Dd 	 > 2qZ   PRPNGP⫑ЪX?rarTrOt :DvL*DA@ umѯfm@
Нr@l
u2 P%&:Ev&wM1&*ET̂oo@НZrFnr;?@u"2#u< r
t@r&du
 Zr rRXt2 u@uu+ u2	S ؿ1PaPQS-6Fǀ8<t-@.`/<[D
>X`D<Ƌ%a`t>;P	 C@@`4$4Q+r++Ysap!$!"ΑWPPQȎ@Jr#@Mwq t }.12:Tt
  uOuA; ހi<s& ?O 	23` >2H}uE  FoF 
 FFVWp3f<u^<
uuuHMxIE<I9<t5$S1p[|u |
|u@Ku t\_^FSG}
uI}	OaJ.LMMN܀}OKa`EsGOP
 DRa9F2.QV 3۬P+^YD 4sSfAff?R^ffJf!
p`=f F PXPfP~dр=r0&Ew)Ewfu!eof`fu@Cu~`aSVM|`|tpht
^[õ׹_+ص5kX"kػ k/URfQvV ufufYfQ =fA<ް%1 H uQ !apn r.V sfYZ] ^Tf;@mfRf¿f;fZ@mptWf!f1Nrf+ f_fZurq
vw`rfSu~p r#v|s
,pr
<wf[uzG[{8O|wzr/{ruBAvvgwP^XxPAv?r P%0t}vSr[owR v{}Ϝ
zEj{z}Avj_QptPfSdHff[fufXEmt fѕt/+f 啇#fSwfѕf3p3wfѕ7HwX2wZfYGUUqt?73ӗt`e֕qfqGkð-b@{ľWVP fSP~WB Q Y_W%^neJst/mV! <5u G	F^q;^2[sq.?
<5% `4JnppXf[2P[Xo^}YɓWfVf  t
P Er&< u  # @rȇ f^bYô P(gXs 4FU Ѹ?ѸfѸEkP߰
 , $ tPp3) [ðmtPS?Yóu
 VI$
ǊK[ O ($=$!E) oĀŰQ32YQ
t
t
QQм3ð&e)ӱF!tt	*tEPGQ@S&#"
ǆ*[8  <t<!t
< _<*R`PZQRFsu	  Z) ð  VP֎ލvS<û	 [rmX2`^ë,B`&ޢ`!B`ĎVfW u؃ t?Kr
Dᴳ?! x^ Ef5t_U|UΠ|Vw9 pZg$H<qw<qm^`"̿pr% F@Z 
u XðBQVWPG "X_m^ VWF`2Pd4ð2dÿS  m[otRNBPRp͙XSmtaИ?[n w܉ޞ2 ptʁCa
P['R¼f1ðWRx $PMMo 'E  `f(C)Copyright Compaquterrporation 1982-2000-All s reserved.	
/
0 m$(,jiwߜ: ø(ø Á(u0C/x+UUub< Mu~ r]0C`ж}?: hEp2   hv hJ 	uFYhB= v O hB8 	$@<@AfRf  %p߇f Pvg&Zf3fZX0   м  .>  9GʐCĸ@ ؋r dt
t4t ୴p`$掊F2PRuap5a+XXZXp! / P怽X`'ǻ `Ü= srs+
3,,PSp{ _ ߸^ ZY[gQwt.蹐0! /0PY[- uɀ.j.b;a/PQN0[ K 0@-V'  A G y 8P8 y " ËEu t
#qqr&r`tW  d_qa??_@ABC -VdVeVhV18 p9@ @  "`:FD=-18 FG HNA *P9	G%18	  p9` `  8d d L"F18 w Fa a LF Fp p  Gr; r"Ls sL
OrEcN H"  M
rN u+O6bS pNS	K
tX0tX Fci0,}`d$!<!uy$ $`& t"&& x<u&  sVpor^@K^D]8t( 2]']233.f>"P."   a0b2ۊ( ҊȰe) ǊȊ&) "f* 븊跊*g>+CfءgPhf>,3gwPh.- g>i) rAji..jijPgR=;DKo   F  n0Q Q"FP3qjl>18   "@ *T GOsuy dmT é umF:tE
Mv;$m@<?n< $wmr<nf<3W$ a=>&]~&E &E_ ~
b>mfaP3yo  SQq $Nx<t.1u
<v<so<3v 3 N^mXVSPoĊX[up !^Qu*Y<u,f ISGu%f f f f`"2 .2Ê$uUuﴀ\ S3ێۻr߁?43{ 6w f>$SMMu>X P dPu
@ XSr 4ras\2&D
V &DH  
B r!}`ruEF.w26$D%rOsJڙK Û$?rr
jr{yϞZ @FFtN fF" pB]B@F(	r2BB2ۀ~ tp]{  t3ҸK3  ;wu;sbFVFF"F
 F)Ў@r4F$
F+ F} p  !VPXVP"aWPR!u{@ZX_'AtZX+pr$q,氻.3۹ 3`&./@3Pƀnuo0nC/p0DeDE:֕v;UWVRQSP36x $@ fFfsEYcP,Xu 
<t<$<  ^"<w<vr,2b? @&\@ N [[YZ^_]豦u9<u` taaM RrP`ƝtNð
2
t
08u迷WÀ>A`cA	tW
u'q &L HWsƨu	VuQ2^ ˋ
.@W~%@~@@كu B WtG@&A J
趥y2aea'u$<s'~?
KW2f 	.c u-QطM?
~諂?وq?`t
тVd gVtPC? u pN> uVG t$p<pupukU<'FO 8tWG>>>_ u33 	t<uSɦ[u8s{":H@>50$> pd XϷZ> PE>B st2 	=3u
辿KupU&> 8%Tv==3~u=/= =5S=o=p/Z_SYSID_  1Y _UU!fl f@f= f3p fl PSS"
ǆZQ2KMa/``<u.|

P!2	ѶR'<tSR@ ڊZ[`}Z[T`|e uH

؊Ȁt, s0Pir!W
yZ0;uW|=u2	fYeR{fPVeO`
B
f6p1@MSsoV@;UxQf
KǻdQ? Rt%ئdxd^p:u=肵u8|	
ً@#2| $uP$SUR!:u<8u7Gt )#5 $.пtʠ Z]Gp5XU!+sQ ]`K:%+Kx,Q,Q3>-Y|M -M>rQ-4Ys.`e
$-9 3Z[x Fp75,u6ݸp?G 5u6:L >@;K 5V4 :N =M >s6)
7
@2'S C8BBaaa$at@0 GUĀfFɷ͋N
~E F Nu3_ I'JȷInJJ ]
 HRQP~XÊܹ HFFYNZ2PoAP$NQȴY`࿤Q aً t"ԃ0Ҿ & GӡU.&a'@'WQR0 ZCV
 | Z  X@O` XYZð
U 
P  S{r{ = ufh   XX؋7[	R6 ^   '_ %_Q@P^
pS_ 	c`yssae `
hUЋ؎c]Fa^WD3<0zA0xa_`P *Pjch[himPN\$Y9SR^Z[` $<u 3 0ؾ   faq!r3rrS cַqc}`wPwVQm3ɱjAY^` 
awËpR0fPtf
f3fRAыf;v+RрTTYX0GY@_ÜPUfWf@XиMfW#]#f_ff_]XÁՐ`*Ul2.:f{92u9.V.f] $PIR   8 3>0 9@{ 9  9H   6X )(  	 
`zAlW8 s"͆.0
Τ_ϊͻ 쁦ѐaVWS;t0t%[ 
DHt[_^u  @ Ў@PQRWfV3ҿH 0Qƣ. ЊUGY݋f^_ZYRV.  3ۍ6.^] r
R3  tZ~~~~l|8 w8|r8|8a|ç|  << p  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>P~~<Ыff f { >c8lol8x~~:® @ 0``0>$ff$ vxx00 0 lllllPl 0|x0f 8l8vܿv ``0```0  y0|<<fc0p g0  || 0p0` x̯8`̣<l 8`N Ppx<|p`aRp Q|x0 ff|ff@೐lЫl bhxhb3{`2f>  ``x pflxlf bf ƿ ΐ8ll8`<xƁ_xpcʸ3x0 `փ̀@ͱ`x ƌ2x``x 7 xx70x|``1EpAW8l`vQ¿`lvf0 Qx  `QRځ  aA   bvfҷ 0|004A!0ᶀԀP0d 00001qP v! uHf SvN .+X2[]`'
fpx>@  t@&? ZYfXπQiQiThQiWQieMAY9Y.NHnSS  (B03P2X`3Ҁp Āu~PNP<tD]tQ_Yppr8rr
2:6 vߡZp gaPkXf PCI01 ISAA BS03COMPAQꊙ 09/15/04   
  s     ˸ @؎&м  : r' W@ P& u_SV  GG0G hv  8 Gu 6u t3  hc) 
h+rt & ^[SO
&hre
g[U샿VW ƿF F   `ip2 FD2ED2E
2E2E 2 @D(2E($
f&EvPZXuf!tE/e.a	 ƅ @-<t	db>t <tjjjj3P R.wj5Jp$<t.<@t$t = ;t= D hUru 揿  7bFF~ t#^FLr
F Fa(U(~ wt:]''jf
 h\r*F)'2(~ t
)F_^Qd!
h|Rs .&4/uduP  ߷ hr$?ط2hTmRh'VC4ChZ0
 qrf   f  f   gf&Q6..  1w  Y`WVe1E0&E.&WV .^_UUna<Qc< 	`@.e1E0eE'E.U s߲ Cm2a h
$ǈe Du
g$Q
a3QCr  utw
t1w
tAPSQW33۹ G&./JNK_Y[X MMMc1 @  @ w @MpM dB FO MMxsMURMMd* %  <!TXMC  3Y[MQVWha5:u% p uK!__)  | = <tka;P09@9_^Y!JRW`  Ê e
Crr3ɺ Ae܋
AB rN_ _ZMSqe Y
yuji=jjU jj%1 DE<@!p;<<!p<3u """jvka#t
#m[VfPfSfQ f_3f3PXfffDDG(	Dh fYf[fX^u| 0gO GxQR@<3ۊED 	 C;~ҋG$B i#u fDf3ۋfË\py
C{  	T U S V :	N	b	v		`h	Ph	  h:	 hN	 hb	 hv	 h	 av.L.< t)F.6P3.PF.h+[+V.P.^̋] TF. P~.h+Xhr QR  16W  o0"XѐYѐZА#[  
\qaq_RA]cdR'^b`i efgh qp10GҘpppQWĀ> t		 u		.	_c   O idJһ -wg~C.e
/Se
@ mOnxo7`L3۸ E _F^FiQRrPS(m[XhaQDЍqڋh
s     8       ?_ 	?
_
 ?_ ?_  !"$?%_&'( )*+-?._/01 2346?7_89: ;<=??@_ABC DEFH?I_JKL MNOQ?R_STU VWXZ?[_\]^ _`ac?d_efg hijl?m_nop qrsu?v_wxy z{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_ ߱?_ ߺ?_ ?_ɟ ?_ҟ ?_۟ ?_ ?_ ?_ ?_  ?_	 
?_ ?_  ?!_"#$ %&')?*_+,- ./02?3_456 789;?<_=>? @ABD?E_FGH IJKM?N_OPQ RSTV?W_XYZ [\]_?`_abc defh?i_jkl mnoq?r_stu vwxz?{_|}~ ߀?_ ߉?_ ߒ?_ ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ş ?_Ο ?_ן ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_  !"#%?&_'() *+,.?/_012 3457?8_9:; <=>@?A_BCD EFGI?J_KLM NOPR?S_TUV WXY[?\_]^_ `abd?e_fgh ijkm?n_opq rstv?w_xyz {|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ?_ʟ ?_ӟ ?_ܟ ?_ ?_ ?_?_ p prq /Oo\p0px	@	G  
&HKOouPWBX@p_C`PpgDh`poDpwDxDDO  O 07U8?)!" #@$% &Ps'V(0' ((0(*@(*P(*`(*p(*( @@(tfSf0gfeWf[w1$2Q1	fY12PV3f1!"4fXPSQRй ~\s h^v ]ZY[Xgf& (88f t
fÝ1pP2
u
f1;0;0[T48fR1>4>Rf!H)5fPSVfWf Rg&D= $A<vwDAB D| u:tof_^@Ő8D1>D f%f
:p#F fE}8d
:Hݐ8	\
!Id
94RfUQ8}pt%)i fP  tS[rS&SfXYf]Z543t"g&T fA1Aۻ&7s@SRfP  , tSt VmQ88>R:r9Wf>(fWY t_dUEVU0ECWW6X\Y f)f\_Z tO(2>'GbG!F`FIH"b`b (8f!f*f ( UtsfIffXZT4QCR~f+t/ER+v//XfR[i (t$ 4R>|i0uQ{ `:u
ɡfu8f u:fT0s4j fX:=2n0<  M!'rjd!a#ds#	5QRVWift:33?3po茰vQtf(uBqދ3_^ZYP2QV3ҠSS pS@U :St{ffKfSP1g&!1oY$Њ?g&ǳ~effߋffqf-\ X)1R`rg&u2^D4Ckf% f
ӅS&7[ A1=v5hHR{iu<kwc3xf}qf;F QeQ`:ӄ?5 fd 7dcy4k4frR@;ּ "i 4R1@f
. '!ff
/*FR#s_R %(R CsdGqfrfA13f;EU8YGj;5fS< =࡟f`8fQqpt@AXf3f+F| tf͐89Ltf^Fۀǲqf1{p3+4kЗtfRk8Syitrjtf64Qȟt3k`A杀=PQA0 fF Bf6H?f9Du_>❦Hqj ttqj@ 
>0X`GG2_f$R@R@0_PK@S4k]9 fQk0Ey[4$fGR S"i
fAutu@R/fYڸ@cR@ cEP1__2 G09ϵUf,RL Rk= ̓"p|عtpn?2A4f_'ǾfihhS7gB	&t&"ju	t?rŘVN(tKO tF< Rg&ƅDA 0R迧g&	uSSR15SS2W42o SXi qj R-d&7b4WE/dE 2`eVrE@@Q>% @eѴ!XpaWQ\2/IB _഑]\hpwqj ( PaRspؠXfrqfF6wf(I5h[j(wH`gR:#Pȭs4<= V 3  i8 9 O; <tL0R'1Uǰqf0f <rsf0!o@
rZ
| N5Sb-S$756V"R R~ 0\^ 6fRfW<vUp0fPB`g0P剿m1fu1fGfq1gf]X [tgp{Tq1p@8UKLf3f;0t;
`0 \ gf8EL> ~fù10R0a{0`
gf)CFkF{R$ Ik Is{4$:kg`ffAL#%/&D'`'ÓiO(o)*%'N#P]7:FGeq<=bKQ
2#!KO3r4aKC x@V{Ơ
;
 ^@jf@;70uR:f. XÐ  ,P=  ]
  N>1=2=2=)Z>1?
}?
 e= &R>>   .ATВ?,T>#>C1?rA `m B+CrFoAGF_D}Eݔ@=0N  Є - } %GC=C.a> >NNOQJ!GqE= R> >zIRS 0uOS(TTC>CnUF0*G-J%K4CXRʱI0J/J3@ ![NS [_BP,L>E
 2Q%VUpq_1_1`U&`!aabRA`SR#ThBFT4#ULbS1fT1Wg$gtheluVjWWDHX6X'jbqV1m/Tn)n!ToloYUZPF[6['\bFE1t.4uJu>v`\t]>1@:s^+)v+I+z1r>![{EG|@=&u
В& JR2TDrBR"Q%!#`Pt@q^roP>,UXBF&`O$`PhB "=8X.\lRuAT<r0*f`ATaW
 J'@l (#0U
/ 4!`e	@a[@9
 P>W	P>  _ 8J8[) C@b#{yA|x#TE*I
 O:$=%C "A	BZ"bX=
tàTSAgq?&=xi	`C@=`P
  $` # 
 `"@l	  2UQ L-qFP>=	 h  Cq)R)Al""`P:T:aBQ* !bi(!(t$!t1!Sli'!'t# &!&t"bܺ,/`@Ua!hF鲼4óqo''4QѶ!hɻa?&xE$$414Ĩ9Oʴ O(!rd.Ƨ'I'$ QQ/"Ղ!#la$Q Ѷ1Ql(_(t"`P\DკdC߈Qv_'&_ea_	$_$ta{QQOBS(dS!aS'dу!MSU!qd$SQ !a֏Z(4qdt@ha#|X'4P 	ڋQ_$4d0A!   S2RSQWm hǝv @. _Y[/
thj
Á 0. !"#$%&21/-,	
9
+ '()345:;<=>?@ABCDWXF E7JNOPQKLMGH?IRS ݫ?_*8۝6T FR@= t 	C!
3`"""	ġS`"R#2#%*%%%3DӀ2@ _ "@ ! .> +`+
`O-o.l/RRo/124?5_67R9   S-Q[PS&S u!(<ru
>S0诉 <<> XPS=tSSS>SSu~?R}[!>< tC@a>r> AB<??`@@RSRS.Y#><;`E;<@3؀`R&SGRS@3G S>VSR@t	Y0R[^fPQVRRg&g \RTRCL uu1KeSAKPRAKXR0R|S[^Yf!>VfU>RSS>S>S5&JSt(
ߠRL R0HR[@TTf]^@Vt>SS r18RZw%0[Zr@R&RsWQX90@]AZSR ?B> [J9bKKhSU
ALLL`M<`MDeMN?KO^2P`P.`8R"|[S9rS&SRSSRCSfSQRVgf&RBkR 0R7PdAΑ#*mal	uSS   = R Y1Rg&L@v@ LGaNsp
pRtqS>R rT3f3۰ rwUu>wV#nwW#u"Vuvutxue!Vu^\wuMwSyu: 8xPu)wtwtw;!= IL^ZYf@g&8Qu	g&gP6t@sPVSl0(RB[^^RVsRW-^a»0LawZ:RdRlRtR|RRRrS.uty0pRAZyCZkW>`TRSRN<v
hS,ƯSiRʀ 7RGr0 rP)lsڠLёLE瓋0@GuFRRR:Rw`R߻
 h^a t7
߅dvax稖 )1Pmrg& txRrsRr0PhRr
 JtbintؓREL@Q92v> u@LPzI$W	XWZN,YPYR_|@fPfUS3f0 	wYf]`Sf @Sf3fY[fR  f0 Sfлf3`@N01汰f@`SF E *  <FuS3t	Dt<Hut2o[tj[q $u tP(X$?S QA>S uB<Ft<Tt<et<t<t<Rw*<Ir&S
2 Vtv[>PVy[@/Ooeu1SVW p;tAQ ұAft(PǴ:?Suм` gXfC?Yf`j!9~ 2Skur˷ ;t&S8r >pta>w`$_^RS\S2 Rf?t<C0A<tSQG@ذ0Y[ـ u
lQ?9ܱ ffwgg5hhCopyright (c) 2001 Intel Corporationf]۹ ;
uhvp2 ]f2f| t;f` fְt*⩑tt f(@
  0L+V% f])Eu"osf] fȸ &`f %☃f?]f f`CgfWf;ugF]PffgfNff F]ff]M=fwfg_`?gWfgGpSMtlS[p(tY	 uIf@gV8~ N^f!f`_0!	 uV0Af[SfWfVBf&iff}ް3l_ffGf;qM<uq	Gf=_PR_u	f=CPU0u 
> 
0
u
q	f=NPSSufOff
o ]L/8f!!=`	f}vf;sWfF
rffذP Rf$@gc&p1 1p	f6A F0lG	R!`)f"Pla"
!Gq$"A# !fItgO
$Qd!S?Q~j@/Il_u4Qr!4fE 42!
ut"dV#ub#$n$mf 
`./+؋ë0p=of+4N 2`F	hRR@Af^f_f;]wej Q7
uAza8t 3gFg^%??0v0 J 	w p]RRQupteP]JhI H@L"0Luof3`
ft5f6]Vu  ZBJd0 f&]Ku܀ h3<u	!y%N$<@e<0u$02H`<t<t'<t<<t$<t,[f@SPB>=PPO1) f=ISGu	flsg]]  AaÂAt f6]	>f	l5	;paj >!_fPet6IJN`:(UH*R[[ &Pg q[  &Q& >J#f2RB	u 28f%UWfk۟fwVpd4>gj*1sl&0e 
b4pbk`uj'P}_Yf@Prjn < (xr$s9v<'P1Yfxjk K227u"asEP1e @k-؇k0	!_pb|˂gfdB"7F5붉 ԕkfD0ȌuB(RPNOSiTNtЭG 2YtG2 ? gh`  A
21ݰpPqP jdd/1ݱB
Ԝ000op@0ݯ*䝰P0!`_!_pp_Q󩰰_L*LLLL0j0j0jJPI@ fWQcfQ;D=2dYf_@Yîq	D=f.tPD=.ti.D$.>t.%
.Dtjr
% .>tt1`QOb_×KjSs#j$itrQѸd೟0r>%;|= USBSuA|= ttF A`t~DuRtlc ar4rQ~&`f|ur
=``i tt @pr?*ItDQf@O.FQ~ Y{zP vcfQf݉5?fC2AcjWfPHBSODfXƳ^ Ι0C `sjks
ەkʏWqCCBg&D= aWOdp:0ɀ
0z7doZD(Z| 0(V/s7DA=%odD$C$`Ù.o:d@RP2 ޔ h >{Gu 0101T=
yXL(f4T=&ȃv.tZ@u&tN tfPQ̀ f.{>t l+πlfQ^Vup6t +.of.6o8>Ud@YfXIlrt fayysB *?QfPfQ0gfQ<Z
f{XYxr⬳>nos׸Gj/sR``o?"dRS) Al=SGpbtGtn,Gtz,Gtt{D`ƈD 7Pd@r
kr&`йK w%t-бt=бT= t:tt h^A3(uVQsrLR@G=@tG=tG=`	tG=P.ΙGg6,faPSVt8dtd.&j.	jt8DtD$?S??j^[XS.@8t.?.uj@CCj[c P`EeE	EЀG }}tӥtOI   M! !hI}DL` ၄'w;w}}oq+rr%wcwqNUWRQSPV rwj Pur(ffWR~`h1\fZf_ utSaPoSUpuUtUttWt/`WWX`XtWX`Xt"c[XF f s`"Ut U ^X[YZ_]c ÈtƐ A`pR `R h fd}u
!t!ddfd԰cdcrd6adedvdfAdddr(bt!tRÿfU3f]a5,>`u%ttt t	tfN !tF ÿQrku\np8zp%s
\1n#,6yGuFqr 5s,JtSfQVstvtH;}ـ?fPf׶D`ѱof{Ts|ff/fXs\onyuptLuY{f3ff.t2HfW}.*&t8fw*fF*2t*܊.&tfX^fY[q!SS^A`_A``t бR`bĀuNG`vt~ 4\}ߐ6SQVWU&S qS u]_^Y[LS-120ZIP 250PSQRVV*WX `A`HЈ'ށut@s
hU6rgбR9<tV< uWQy{fqJ *:uFfG_('ҚXX  U^ZY@Bf`Su tStttt`Ǣt /RW1!<F} tEU=_Z[M-Sys   Dis?kOnKey@ӟ9S u @  f<x fP `/}'z'9"Қ 2r0w|=1s s6`5 !D9 9f@fP?uL{st6`5@]r)g&ug&qJg&ۍ3' z< rLTf<F=BP!e}$wU=pp th;=t@  u >u {3{Af?f{a
fXuWײ?ğ @U⠣B߆ 	 x PRi3W>#>;!>
_Fh`Ղ=;  4  hILS_ ZPBu+s!$?
u$˄[ðD  KKDI@0z K1M @pE roRa]!r\!d ?ҡ@!s*P KtF3 tG p1'1rT'!߿r@P@ I@ Q fWQf/(K0Yf_!f3D5 at6ttsU]att!!\D$&`t
ĈDt's fg&|5 @r`{r  a`<~^8^l!_vQL~ E`~fPHf%Kfa]ffDfX\_t
鉠_pXsP+ _/B~ʐ!S+ *+|@4)r`$,s,-/a]/0 Xb`A2W3
#c)σrC]D=1WG_ R+D0J6ہ/($ |%r]򜁐Gu.rEQfP0a].߁f.6灹p0gff0f0f.#fXY[rb`u
*0_ p!!#D/$XYr`%Pq%&p2r FJ(//)s`6? ;s6etd h^泗ej:u`7(uIa`r?G=@tG=tG=`	tG=M`G's%faм.&l.	Wl$0@s@p@pClADl5BpCpgI0 PE0!OrIPTG   K@K!  00S 3pF0KDAVL!LeMKPE'PGD0PE IDIKcPaHMr I3PIİNVMUAT <SaCV@TPTU.V VHBWpVTVYTpVIaL$VNZC\ RSSRRi^vSL YgQc`fS6VEAT?T`\]Z TZ Tf#TWQVVcefEY WaIiCg?Zie fXMl5nkqJpJQe7nVPF3Vh
!lÐTlhhhj ZJEfosdWOPeM%lsWhx3t{HzR\%lzEY SWgLU1SEbTX cU|QDQAKO W]]nEhgTg QYc]'iZJ [bQV] UXfEcM<X!XdTWgog ō"Gr{ePqTZThaF<RLwzpF<G"SzE3VNHvFE !f]fCxxHAXc JI`Q%Yr<f.;Wt4Uuf.Wa#$Pf fb3Pgf= v	 +v> f3Ff́  "F"JN6RÃ ;tQ@$rՉҬ2 ǋ;Ъt.Vs .VfRfWu vf_fZfrff eQfffROMIfMAGE ;uaWt@.g f3TPQгJ 2`8fG0ZYXuw7G`0G@ Y º2hǂt"t׀ t	V  `SQhtuY[
Y[W   󿲽u'f߃ t!q#w @ $aG9Gq#Gff}f=ߊӸ  3r#;#ӍΈfϊ7?@1z/Ȏ#رP8`ʱP x˃>t aB @1  hǝC$׊h=B>8 G׃Efa1/#؀@n|=|QPQfWfVUU`ժ*U1hh#7f  ʊ'`8G1 .;t3f^f_YXhBc? PVh3>;ר`hy3>  Uݷ^X?QRkZYB.S`36 faa30f_\0fy0}0f`2`s2f;Tu{0fǂNNO.defgP.&< pO 0g갂< uށ؊OBPtXruU`SQr/ȰS $8tċY[?r$un㰆g`rLS_r0G@S9%{S8r ˱	J.Ա 12	0 fPS?fQfW
s2+fU)y suf3Ɋf@gf4_fY[fQPߴ@`g_<t,`ofU7" r8tfGq$@%@8tM``
P2DUvPF X P..ӎXP..XÑ"$/%O& o'()*+-/.O/ o012346/7O8 o9:;<=?/@OA oBCDEFH/IOJ oKLMNOQ/ROS oTUVWXZ/[O\ o]^_`ac/dOe ofghijl/mOn oopqrsu/vOw oxyz{|~/O oτ/O oύ/O oϖ/O oϟ/O oϨ/O oϱ/O oϺ/O o/O oɏʯ/O oҏӯ/O oۏܯ/O o/O o/O o/O o /O o	
/O o/O o /!O" o#$%&')/*O+ o,-./02/3O4 o56789;/<O= o>?@ABD/EOF oGHIJKM/NOO oPQRSTV/WOX oYZ[\]_/`Oa obcdefh/iOj oklmnoq/rOs otuvwxz/{O| o}~π/O oω/O oϒ/O oϛ/O oϤ/O oϭ/O o϶/O oϿ/O oŏƯ/O oΏϯ/O o׏د/O o/O o/O o/Oo? _
? _
? _? _ !"#%?& _'()*+,.?/ _0123457?8 _9:;<=>@?A _BCDEFGI?J _KLMNOPR?S _TUVWXY[?\ _]^_`abd?e _fghijkm?n _opqrstv?w _xyz{|}? _߅? _ߎ? _ߗ? _ߠ? _ߩ? _߲? _߻? _¿? _ʟ˿? _ӟԿ? _ܟݿ? _? _? _? _ ? _	

? _? _!?" _#$%&'(*?+ _,-./013?4 _56789:<?= _>?@ABCE?F _GHIJKLN?O _PQRSTUW?X _YZ[\]^`?a _bcdefgi?j _klmnopr?s _tuvwxy{?| _}~߁? _ߊ? _ߓ? _ߜ? _ߥ? _߮? _߷? _? _Ɵǿ? _ϟп? _؟ٿ? _? _? _? _ ? _	? _
? _? _ !"#$&?' _()*+,-/?0 _1234568?9 _:;<=>?A?B _CDEFGHJ?K _LMNOPQS?T _UVWXYZ\?] _^_`abce?f _ghijkln?o _pqrstuw?x _yz{|}~? _߆? _ߏ? _ߘ? _ߡ? _ߪ? _߳? _߼? _ÿ? _˟̿? _ԟտ? _ݟ޿? _? _? _? _ ? _	

? _? _ "?# _$%&'()+?, _-./0124?5 _6789:;=?> _?@ABCDF?G _HIJKLMO?P _QRSTUVX?Y _Z[\]^_a?b _cdefghj?k _lmnopqs?t _uvwxyz|?} _~߂? _ߋ? _ߔ? _ߝ? _ߦ? _߯? _߸? _? _ǟȿ? _Пѿ? _ٟڿ? _? _? _? _ ? _	
?
 _? _? _ !"#$%'?( _)*+,-.0?1 _2345679?: _;<=>?@B?C _DEFGHIK?L _MNOPQRT?U _VWXYZ[]?^ __`abcdf?g _hijklmo?p _qrstuvx?y _z{|}~? _߇? _ߐ? _ߙ? _ߢ? _߫? _ߴ? _߽? _ßĿ? _̟Ϳ? _՟ֿ? _ޟ߿? _? _?_ SQVW33 &&_^Y[Ü` غ   nBnnnt nJFn aS [ 3ێ7!C &?!Cu3ۏf&>CPQCu
>W^ _2E	R .'ZSfQhv f< 芔S .  [a@ = 󥝁À> u:ðqHq`&o&O&7ߴaPQRf&f=DtZYXð@fHA_HȰBXHrAS2P&W g&u&87u&8Wu	&*guA   YP2r(ں 2 t'sX
y# #!u
 !"W`0Cu%5&t	 r _Qr2#$!ds%QYP XSQ I аOFLF;vhJ &t u2K )4P轈X蔈bC77ȇH8&>89&:ȹ!8߰h8`.  .3Ɏ٣gi
EP/./u	`?upPQfVfW߸ hq @gf& Af_f^YXQWV
 ^_YUCD}D+t1QWPPXhX@.X=X@uX_0YPaGDP!Xf. $>`7u
PE@XuSWh , s ߳h>&M&E&MM_[`L>1&$PnPt3Pt"3&M`P1NE<taðTCA#]JE8hJ]UJhPUVU.VJUOZo[k\e\]c\a]J
<RwS2.d[FDø LD DDаCCȧfY?&@f3ɋߎd&G Qg  ߀  f&Pgt`iffBf;hg&GfiwhjwmURgtNgtGFkf0mhZ0QgfY tghapg eAB
fP@faeUf&ffgfdTOI vCNFOR J 3fSgdfCf[ u|<aw{    'f@t6f!f! f3xDgE 
tfEF!t{ f!	xC< uxC u-y0 rPmgdC gZL>0"tgdK& t?f]fYf[rtJRPuu@hh[ נ1,0rXu. ]prVfv]fAd} ،vMqeERs.#AăhB[fZt0 /B~vu@hNr0fR;haZr/OoɕPPSPd`>[JS %hh%rh62f[Mǥޥ¤t/FB>hpWhJ7_IFFGhJHH,:vG;Ƅvj
L



ahJhJ(hJPhJ4hJXJ4XJԐY<	$8!ԼԅšDhJ}hzn*f.蒗P!u<u<uw_
>`>f&2].e.Rs΢oeRsS@
ذs=r=dRstS0vpv&;xV4t0?u@_A[ff[0B1]@~1`;1] t u6ع"PIa Vsfffds
"2ˋ>_.hpfdfdf
pʉ?#qv̩faʖҢc̞sd/eȺˠϳ̇/w`دjh&nF sr dkQNdhِpeW@ad̠efAtyېt_fY`0R/_Z@&O9oy
w82~"àa?fsg]  re
vèu<w'>, @$<w	B@f z`tS>+ ot2 u Mu&'<txt4]r	!} [QPS~S+tUQgCtFXg&G #su0 <u$
Ӿ !QO   2_`tY}P*tgk?"芿r`t*tǿtܿuatX	
@8t"8-rB`0y\t,&
uf>ut
$ݾsE *t> 01u.05bt$s	&
?sPpJP
tp@"3	>02
X	u8t0a+4ph+p-t?tC  @ p< tp$  qu `0;q>{@!؀
	%>tP%
5t+$$7pup[ $  t׀>%u
#wj! !); " _t&{pV+i+Qt# #{Yv(t_ftP orBi!6su%
u4"	tzu 6طctb޿; sW;"sQ؁86u	+u0u"!5
u舾<"
2}:u6B`  à9 qt xp/ |r*1 q@PqtwXLfW`t
/'t
_8؊fOtw/*a3SQ&A[C vS3t@t:@tCJ@`߾t<w>t8` p aây8`
 )T)1 a t3,EKR`A.!AAFS J rRp<M82fP RpL&RQ0AraP 
R	 fX1Ft
蚽43萬荬] RP$1 Vt1pL-LW@NAW.frRRT7t0RW0 'y@!
z:Pc`z Q:Aa`>0Pu_ItaQDApaÉ gHT3

phF3I<3`jJ/3ph 3؃`ij3Pk32EgQ
s3y@s.o0pYon1oFoCPQS{ /:Pu;`su;st(ssPy2d0 ݪ yv ː`wq1<pK!5ry0 :=责r:Ȉ&18A)0b,uʴugC	Wasxww
2Qrpy $
À
v3$Є>0  `-u22(-@/ ;~=
p0P@ ؠu p`ῦ؎ RfZlfa#1nsߑ0`(0ȾEfӔ+ zP  DP &Et"Da$D(s `ٓȳWtȀɿ t>@"۰pa
&t
b ЎL &}u??u8&= r16Љ&
I$Rb  Ў` mm 
 Gmq!-"'3q d  * !۰OQ^pKa0$f" $$<@thhv ?KuKf{Ku`.;soKt&rNRr.iiyyBi'aĵ`rrrp.X ? :呬trr/kTdr=aЉ쀊$P3Ǚa fRQS袘[YfZOt'ӔȾt
| t?a[Xe
ƕ5mg PSRBaĵ,?=tqtr0bts~   hZL{  PfB1XhA<,  `  pSSh[	u<aӫ?JS@ӬOS٭_Zf7SW h
R_@WКfQRf0A0ZfYp	Q9`CP߿0I tv_S h4є Tmfr0fSsh)3ff#fY:P W!Sfgfe	f _  [0`t.f/Π`t.9@Oڔ+AѝaG!Q  t%0 c@#t0
A=#shgZRb7wWfH18aof
  F
 !"#$%&'
/`a    3 d $ar [ 	fGRVW@ l 8  p >GA lBl_^q`6$?C! G@A !dB a$0sFQn o ^FBY!B  ` ! nBnnnFJnn P!ހ%!B ? o & $ cpǿ!]"  _lF!Т!2ڻ
& np'+p߾!b(nG    nnBؿ .B!!  t!!11p. .o .1R11
2p55kb//.	!.	 n
!7 n! 9R%> tV'&"$`j%&&}0<0<
&
%$ȡ
=%@;%$;%Q:
 ZHFr!U&"&_ &'!!֤ʃLo&d"@
'' `A%5OBV'ȗ`'5!!@ AAD՗@_  $.ܗPXtd$|$ $߹d$AxhaRҔиf߷PGߚ H|$HBMPIP N
Ô3@O3 @f`J J..4%8%   N }   `N  0N~TryДrqhZ0R&.p. Qfߋf  脷fRaRR ro<fW  @;r( @P.r &r r  C lBQ1PPJQ&& svCOaRQ0s-p@3.;'t}Tۜ3rA!
䡢Hu!@ep#pf2faÜRAllJ쪊$JlJlBBJiZRW(O/k6k诶=lp_ZR `n`nZ6KQVWp  _^Ye+οt	3aaqqcraø$PUPRZXsqx"qPv?#hDRS D 03f1Wf    z@WtfP fXޑxH f1zxfYf%0xL pQt?xM ~}Yi$1WVxN FQ᰺Y t *  
 t%fP ߳hR =۾ ӳ 5{Q #Y}^_!xIQyt lY$[t  u!uf!RfW䀉ɀ S }k hBWf'   pIUry f&f_0`Nu
~YN
awT  aPp 
㰖m | ~ RtWuQf'fp|pgf
皐QS uf @f'[GAGW!f ܯ,**,f UCESuf*ffRVfrffffff^fZUf[QĦA AЎ~  P.fXˀ u   t ` rWf`S  O tC@ t>ҰÀ t.tS
 S  [r~!fn  ]_ɐ~a#ؾ
ff;t7]P
 Ը'3ԸԸe0phwh[r|Ӿ	f_ uR!ӰR
fffLP°3'whN]haNąt 3ҹ  &1hYGVЇVU1"> <$F10u@ts ]^[V ^VS 6oD2[^pоQ0#:D~Z +Y ҄
Ա{d$#8חDqԠdk2rd rr]rPP 肙XPhXP<s)sXS+[<u P:<%їrr#M0ϰroPȘq⹘>:ñ...`ѥs{.r &
qaAr(H
0zrzDr rp/)/L//Vѥr ..^ i VWQ>c"]K Y_^c30#.:it
$ .{^b".j4mRh;wt0ܯhMĝr f4fw` ƾ` u
t <0V@?o/fa@f`aXRfVfWP3< t`X/
O`#"" {hɪf`Pվ]@Tv&_a> u( Etv (u!>0tus"" w"uuu; RP k"! "A(8"9(:(7 > t PuvM莏" @Md蔔u$C$?< ub,b :W<u
)7u]]wpI?S_@071v1xpIs2(9)**75+uLƎX0U\Pc1' Wڒ$',0QݹQݴy1@<wݴ{pIЉ2C<z1wݹ/ݴ|pIk=9Fp9Fðd.h関w:,h" 0 x.m4 $tE24\.>Fu	b,蹍谜 t=> y4 *>0KuJbpb}BIwK_ t50 4脞t莝K-tz0 ,-sQ?趛@QO*V PIP&ߢ&X>& *@/UbRedubBg!QT"UyUb(WW`P=.3 /<t+﷝t&u
$&YS.bPAOt"tuFpt
&g&׈G a!Xguh^u}P_ڊ&t/fPfϼP2WVF8oires6W p 2:> u6 mHt4mo hBn3Ҭ؋hBB^_!fJhiվ}s୽>m2p3qqpn->q2rrx"0soƾu~Okzsor.NE
.֡.ǀ_yhǝBhe
t=`f33ɭFff
EfPffu/22SQRt$fayZs@tcdQVW`.C >` u ݠ_^YZ蔫rVz<ĔPph{ZBr6hg,tQW _Yu  t
tu_YϰG	 P=w ٠;S0ĳP0hmXI
PSBmT5
DbSQ6ua'0Ӵ Q2Pb~X0m0.P2
pˀQ$
QÀu0:;X[X ?f`Q؀ {p2
Q2t _P(<KrKCXI
 /Pt 	a ff@3f  fgf4' f@_񾅴b1Ph f&>k_ft1| t_f%gb@PfWf}@1GX<t<t<oûPS$<w
.U;h ᙐ f;tSfءhBf  1f[ "\< I &\<\<

À{>+ *#O 
8s *z PPǠV$<
v
  
 t>T 
$
آhr$J
-d t㋷AG` n
^h,s

"-od H
 7
pZEu T<&U<a T<U<>U< u
8wp9"f.wлPh=?f>@@f>>>? YC0 PrC rKDC+YDڟ>zZuh>. Qi quࣰq gqWfuYuSTErEPR?.>Z=Q.>QBZS ""
ZPw>> JVJúa8Ja3ȡ@PBX SRذ40ZhQSW(`?_[p  "# `?ap00rE+3p<uqIp+3wG
qGb`Q#B좿????֠ai?#?BPS"D?$8`rq2??bMH<n<Au
 	
CCQ7IKCaEV<>IOChE]<eӻ\J%XAbAvAlAA^I\J݀E<}Op퀃En3f'A0.&5, G=5 *dSEptW	  XfP033\ 30_fY tz f.mAg1AVM.V`X7  I5i 	߀@p# q%	ìBBBB>CDCBWB  'T(P(B7(' EUUEf*Ud+*`*]TQTL,D\PUUQ,U UUT ..+    T T AJ0=U<1A.B2U  &tHu 
hŧBuo/_~r*V5>, ,b
?JCPcY|@4B@ucY
 
Vq[VJC Z#7 8́99q~@7[b~X5DJP?LDs2.DУrNb 1mf&]/tiu>uhx`\h3e\b>6Uhd\hi-H1u"1t}`<c4FaR4PЋu%RJtG} @
BJu3LFr~L& ;u
Fs }[};tP P&34|X;gEQpgEgE2L_ 2LOkUV<22 Pظ Ͽ$@Y^[.`>\GpϮ^]2 	Yy?U F0F``~``hB3A u`&&q&qĸ bbcBdaFFbFgË?w
?uL"A;Ab;7ۥ08&9 a:ON	sl/mOnboQGr &,4? .]Gà:tPu`G2AuPNOXé  w  t%q^AJyQXq%Gw.Sk rcGvr<w|} J|srvnu#  KhΤؑPߣ̷h7C2tG$׀>PN
 >pN裏tGMA_S:.u<< pUX@ Ј,]  7s>rP_v@IF X P.H.H.HȡXP.H.H.HX=I&=I=I$LƻtȮ>S8rdd rS<dr`
d25@t
Qw `Ot;N3:0^:5:s̀h#h#h$Xp4JQX}pSt?QvX!pC;k#AVkuuð ߪ?_ ߳?_ ߼?_ ÿ?_ ˟̿?_ ԟտ?_ ݟ޿?_ ?_ ?_ ?_  ?_	 

?_ ?_  "?#_$ %&'()+?,_- ./0124?5_6 789:;=?>_? @ABCDF?G_H IJKLMO?P_Q RSTUVX?Y_Z [\]^_a?b_c defghj?k_l mnopqs?t_u vwxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ǟȿ?_ Пѿ?_ ٟڿ?_ ?_ ?_ ?_  ?_ 	
?
_ ?_ ?_  !"#$%'?(_) *+,-.0?1_2 345679?:_; <=>?@B?C_D EFGHIK?L_M NOPQRT?U_V WXYZ[]?^__ `abcdf?g_h ijklmo?p_q rstuvx?y_z {|}~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ ßĿ?_ ̟Ϳ?_ ՟ֿ?_ ޟ߿?_ ?_ ?_ ? _ ?	_
 
?_ ?_  !#?$_% &'()*,?-_. /01235?6_7 89:;<>??_@ ABCDEG?H_I JKLMNP?Q_R STUVWY?Z_[ \]^_`b?c_d efghik?l_m nopqrt?u_v wxyz{}?~_ ߃?_ ߌ?_ ߕ?_ ߞ?_ ߧ?_ ߰?_ ߹?_ ?_ ȟɿ?_ џҿ?_ ڟۿ?_ ?_ ?_ ?_逽!$SMM MODULE -- COMPAQVERSION: 1.0b t*}Ā> u
S/@uuu&g !_ s"(b%p&[ðDT$ ht隿v r
8 	t .Bhþ
yB&<v A
0& ? n4o&֤m%܄Ndޣpb4Dm  	Qqq<  2PPKdP; 7@7d_ VQ6oDY^PVq!;to^Xf`fff  w$`
$@W  e_N p<t@ B fafPSRV`<fprN؀t!@ Q# Bt L9h	%A"f^Z[fX<\< .=rP:4 À>7 uCǨ t$<w:9h%	R>t".t.t`. u %
ZSfQRUW.&c//E0d 0P%_ZfY[@, t*..>u
PtfMP2W_6_`5XP8: :`9:?z:ø  PRBZp9;B`<3he	u$>` um    s9   %?t0 	0	A
  3A ti  `CV !.  f@u.2h:S&XaFFt
3*H2hC&B5J5K%`;û8 X vɏ苳P802 ߜ hꝲ	%Nh`JS9N
 OQ9p;`<fP3f&T ffX`;QRp쨀thU	t
uZY  ؎ff uVQMp uf3ɺ_ f$[w]%&\hD	&)_  ff._B$B$
и 3@_'g hijkm?n_op qrstv?w_xy z{|}?_ ߅?_ 0 qX>xk   ȿ؍6
1w B.X6x``dXU`
 OfQd\Ifh>s.f`PXN8 %w N h}#Oh=sP UA  Dt% r @eP!!02Ac [fy`d`fw.PJ/¡@Ԣ튀` H I MY  a@+q9!2 zNH f^C%B5 a$q]$
aq]CPBcq]rB;ra`ND 0f   AЩ70R3KN@ M1T:;! 23۔6u[#O
 1\0;B)%&P8,$-*h > ut&O$L t;t`9S]0rN NcA
 4BM.PC2撰A  GA;Sbc 㫃8`<f`  ,!h@s.  @DLTX\htx @  $(,048<@DHLP`dhlptx|퐐ˠ˴(/OoΈ8 ,f pψ *tԗO40 ,D@ @PHX @ ,< ,<] ,<` 0ڿ<@H@A<HTX }
 H 
<I݀  ,@Oo /Oo /Oo /Oo  /Oo 	
/
Oo /Oo /O o!"#$%'/(O) { <(<T?,-)`-1234 P4xz4PXYhijklmno07	

 4_>? @ABCE?F_GHIJKLN-O" # $ ` apb crp0	PN0Pb Rpr RPh0ڪB*軯D* T8ðp?BrUBhhSZt @뢻0 FWࢻ@A`Ѣ߿ e.>;u ̒ @\SQWV9[[@\^O_Y[p]w\_pfPfRVW f aa!ҁbb!b!a!bf%f3f3f.2fffu/_^ffC`f":ahahfWid擿d
Pihf0faf1=f  tfmY of!oC0lmnR!OoP3XPSVWfQs: `Fي t
؀u ufufpv @uf  fY_^[Xq_Tlrun =s`&&"&RP.  XZ&&>^U~hX &|WVSQksHU&  &8zźl&tY[^_P}`RW* t.f`w72gcw'Br@甋f#/ CTD zcH#ugŋ}L"uPCP甊 n@f%u%ŋ$ 
t$u eé @t	  tzdpᕌfᕆ\CRH H@#3_sƋÑ`nf Cfᑳ.ffiAIПOapr@ApLHL"jԛMHMÑRp* VNHNVEHP,Ó etϒ㓰B e @<Zup   ?ErW /< g @ he6f r!O3hbar  &PRwtz/t śV4u:t&w. rś~IfZRppfŕtfX=áՉ %%<tCѰa/ត2 fY NtADa6jP 2_X< tˀt\RH\穡`H`ģϛί
pvYܰ  &Яffà (cHcdHd/b i%aĸOOià|W(THT=XX
 /t؉bs?SY%opRbs7 u
P!tt	t
ZPRfP ]Ќf!8RQ@ ߖ.{D ݖf}L 迖.N P AcS. 贖0f}豖.p󔖠P0~ޱfQSWQB s Yf  pMxVQGf  X_[fYpQ@  @:23ɱ#L  $  $!Q2%@_QWQX ו$? 
r?ɀ֕r&"]B0ZÕ'W跁)àpWW''蠕_yf+ # J<rA_P7R  "LQ _2#RYK)fV  D   ; Z x     0Nm2=P
u@w	l<Pw2 kfWfV`6U6L2G6@f5.؋6f6f;f^f_!S aWf3ہ> w;`6t[>N 2G%GGfpk3ؿlf _fZ gP]@a6謊33@9 V	*//h`?RmZ`:~U 20W{:i@`?7 2F2#G+= v ؓ@p_^ZP_$
W`6>>@96 M:_t O}O +Nt$tRP9uQO#ROrwt>*蛤$,AT+ATE}AT[>pPtP:pOspTqÊ=&TraWUrWqX UrMàT>T;W!X5YG&'owb@rYFuW-0XD$&u `jo(ΐ`w5SVtŽSP[^t^X0bP^0GXm [xÃ&=U&DpTPV`fAZu&d dtKs	2s?q O<`QÀ>tٸ 蚣$e@wiPS	ɑOQki^}^xeD4 ðd.aQ^
^^6^wB_&Nu	Nt2-ЕX^ytC`i øO RT1lxRPPP1lx7ð3,r@U% t
  !|z&@pr}	 emc}HȃIذJԡ2ȉ  uqݠPg
@u]AuQ0[uIPӅ6@ttXr= tS tD3ۊ:t
u
> u'| ߡqwpV
AR [Ъqn$tb}	of`n|Aޢf  w	F߇%aK&JҔ3g^qÊWÈk:i%0o%`kehAO h.$t
h~. @/w2h.h>ʔQrdݧH<h}.*h[hAN-fZrha-Sf>QPH_u(lr#  f&ft0⏛Q[+-_+r(fa@@Ar.Vh f6tYв@4 uNf3Ҍ+t ;+wTf6-ҲcQ r?f֡JgbgߊB;grf
/f1q7 sЋ?fP<Wf> Jff?gf? tHǀ tfм fw? /Ѽ~Sf׽r!fAQfJ$fftgf&
tg&fY̤ٲ3<Ư в#ϴ!3Ȓ02<w.|
BuFx t@$̍5$@{b}1Kq=@QOOPS	&̱< ! 1Q / tW wptutj$
 s߃ tQS=t~  s`E]b<nB %t"; !

	vѣ c}0_udЉ>ܐ;>t,u-  q0$/OPSԛ_1P/<P aPՆ  >@uT>u%  ["uqtfs^1$u&>P;"fP	!
9X#
@uhT
u!* 
"?tB ߲
wPS55oxDzos`ؒ&!N$DPĚ$s$X[Nt9{ Q=r$^wS`bqq򍐋Wusv Њ@5>t'uuӏq50Wu
߳[Z7tt$p
퀟2Ӵ	zwUmu
F!^u
 yY  ױO=< 3`ؒ1!{
0
c};rqѢ}
y ٘SS=RTrQ<}dC{qs<$dQ \&&!5豗$D8P#"7Do5Q+!0(@u@  -$b-[ u) ,) b&04ޣ3[À! = o p ]
OOރ>3t+&a&ףM.
6 r)`5 yk.1S<;w?<w2پ<)=<w< t0=<w ?>Erb[}#>3
!请$u- .u-1鴆͵ܵW\-c%Jf`f.a.Ғ.".QH6 .Bnv
PH.f.Pr.b}faõr! r wPQNX *
reu`Pf hU}" P:QXeQ2R0u쯨t
fQP<u r õAr$r Nz.0.V2VõrSr{YrlT[Z-Z]UT[[FT[\Z\/S[` ؾ;"" QY;`]a]a4f0d r&pk߃eOfoE^ydWefDg'_ r SNSN}FN.&m1ll^RQeРeLf \
ZQRrSNHNt2@`Xٵt"` @b@`oZZY/aQo~0ouSNENYp#qQg@ٸ 3!Ĺ f3& &EZy2 Q&&,r#r8t2x`.k&EXlSߊ؀O[&M.m1~2t@~$@~#h  5W? h,Ť2ϡrh } `vaw35 &E
,Q#QQ	Q	2Qa}h"%00` 0`% `k ?  Da`6(   0Q aV魆ī^W  3 _r-}`Qs˸ D0ED``eՀ tBeBЙOЙf gPDr` ߏbrVtW2&*G_YS 蛾o&*`{u&}Zu/&E@_@fei RgQeگmf  r\2ۃ<OuB<7tLbxذxf[r: " rd r 3h:~=à}SpP
pPVtu$<PteQKu洀aUwPB`no[2R @QTTuu2P#0wV o^Wµm_H%Q͹ Y`΂9ppPQ> uι c red`aPSøtCGr-``w r uҊ㑼 r
6u`d YprdItf s`aQR0f!qSRNr&p0r!ww3҆r r	@ZPRS.8@.H3rqL.pg.2ɇ.ua/Z`{YuAj#[r	ra5PfQf   dgfYKuGvNO fFSeT2 Cspme 󑷰 @ذ_2!P+,    )' eQNNO@uSV- 1޾> f<$F10tuP"X4} P+-^pSذ1W r@SP+ r| 1 ѺU ȿNӐӏӎOn܊!bb!P>t
!OOqS t33|0)1ޅ
t   t@ÈEPQRWV+3N O ?^_Z2}31G<u
tpV  {_
b@!ӱ$`7jBq` 
grѠǋ/\rҀL M.3EPRqZ!V tU..FP/F{.^ѳ 2uϰbqRVа7rNP	NrC2r<r32t  rr;wҀ @sڋ^ZW
@  е0u
˾E u  fA u2f2 J3322t rn
$	"
upƋ߱d;sRZ3FF22t	u
S_ø
_.pK.RK.lY.Irys@诈P"nⴆP2622Q7ȻX  o h=SPfǨ's,PfX B @h`s')N uu&oø4ȸE CCLPvà4if>PAMSf>/w,P(0EH@@&f&E 	 u4,/344F5E36r4P5 @Q9 f+M'8 h{S  pϘ6:;3:Q9M>x5 hBS"44 8&8qrV?b@!4 7=@7 <(BB@C8R(HP(Ц0fp(Qf@f rY  E!fP < u hNharfQf<χ^_fKh;~t.oK_ur@M`ME<?uPNNf3ANYQR4TPs(^PR`if>tr 7kg" }[U`D"Ў`Qjr&=t tVW" &GF_^aYՃ"q 	߰ he~
Vh!
Vh"VhVh8h
ZVh8hPVh 8khshL$~ g|Uhྙ oDgUhgtroQW)0pက 
p@ pp_h8`~JÿUc.2K.a(Ʉ3 -."0^u
   .}ʆB}%~ |󐼷ɍvQ|  |}RFY؃f?.Q03 30 gg& fO 
 30g&Of.>uef!E}4ÅFUWnhM_]ff_v
@ 
. .spϒ/ Ooϛ/ OoϤ/ Ooϭ/ Oo϶/Oo` [~$`<`u*& +ɸ.} -ɻY"q ,h .a ~ u B+J. -@C,An .O aSRؠİ0 t@B{u$Z[SfQWP h
s'~Xg@g7_fY`&gf˰gPfafQRfWPSf3=0fX e Pe2fq_d 1@Yy?a[Sc; X tDt/[Xf_ZfYù@ fPffffX,fV3Ɏ؋fVf   E gf^!f^2V=/DҾc )ӧԾV://^hطfEW~*fWfX_b`g&']PFg`9f_fwV&i a@tTъ!~{"!{hҎViQ ki$G\i#YO}i&YEi^yfX>u5j#5hiVhQW& ߱h&D fh;BBJAX	

 @`3(PMht@C  d fϸh@.ϡ ** End SetActiveDisplays: \  wR$Kt5Nx )ڊϸ 8t8u}@ZyPQS![00t@u ^SQ2tW`P  y@t+ v# < ta T<uȸ
 
!u`@Q 	
3q0D ` $vvLu
  rP|Ѡ
 [}ѐaev"	X}90
SRlP}(
mP$p 	mlċ؀̿ lXlXlmPlEϐP;lZvR}2 tlP`!ÀVPlzPiQRPS y[X"3t߀"$cb@$$p
2\?uv(o ha@` $V
uur2,RWA_Z
r "_&& &E"&]@  'sPP???У3 wrS UfWU]PcSW_vð /JRs7_P  ~  t rH rPt ~*fdftt`dq@f I&?f=>V`  f_pbQ``t' tfF ITAfg{f>ؾP я2gaYg21b0nҎ bAI  uu#=tGapSe<v fы"J6z`Ȏ؎t q (w >{N!s6MxtNObOVP<0 O P0а5{ffLPH/>-tq`%	t`% 7Iu3@uQuF,
uQ&hГFu
3quCu3ыfGN"IpC0WzWf7pv`
 <c	a <u2<c
 h 3g/hOiojk lmnp/qOrost uvwy/zO{o|} ~/Oo ψ/Oo ϑ/Oo Ϛ/OoϣUPRPRVFZXRR3ZOoϭ /Oo϶ /OoϿ/OoŏSM ЍqߋhC "$& /v@ A@ D  E  F G  L N O  T  V  W  X  \  ]  ^  _    B C H I J K M Q R SLJg"!!)@CmyΓ)<)o?!5"(̈́mB)ϱd[S@VhCp6EsDmoX)O*y`P&P2Ru-.>;t	 
R80t %]
8 9:  c],9QR`8  YZ  L hǝFh= ߿@ h
Cf hD+&0忘% -:PfffXfffL$ , fQZ fYtYc?R	@>%$P(/ݡ# $#` 
0P"f`ܻܹܿ 33 s#ܿ;ݹC  $fOs"
Dۻ   7XOf WPfki< Wa3Gita; ;Q`?<  t7ȁ NuR$Nu;Zu"q=sd )ZW  pSB;&W;Wa2 ;3fH>9Ht 1@3>0ں_f $(d  P25WYf#g&!QɠYfR#ua hgZF tP-g tGzu"r< t =P7 wWP7 oW!H f WVfW% pC&mp{ Zrupl?@AOB$._ mB:d "`pVhd!F5xVHb]?!܄D_B xm,mB.5a-;.PX⹠ⴆ 8!haFȀMиJp1V! ࿠q20!#hD#3 r,2P kfk  C9999}    ]909933:3 @f33..
:B^ <m<<c3r=3hZ0F& f   bS61EE[XfR :EEu1E hF_KPSFFZ Qf@" f0:Yf   (B   w@
< :uy r} ru rm reڿr] 9u]Jb>AA0BA>3>TX`@,r':r:rJz2L M hRnu؝`,Ldu$ů_aQYYd BB [YÜR[nBnBB2JJnB$ _nnZRV!ƿ(0a/`6bv^ZáTQVW  _^Y%vcG߿f2䬊 gaà
!  Rs-^[{3.;'{$ ?%rAk[X+t3A@gpmwmena&KøJ㻾`@ûHWos;OWPW3;t<u8W臛.sP3   ƑvǑv7 ø @q2bq$İzÀ&R`BRPP0AF al@|ؾs}}>6  >vu:ߣ zaߨ  tYa (u>调軿suuoavuka ;s bv>uy
тMI=1a
u4⃃AdϿQy	bvdʢr;sBaQyPVԼ  u >!C/u(ay$ 6vv O@"ѐv vw Q#urj2P{ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ Ɵǿ?_ ϟп?_<؟  \Jی!
1" ۯ$
 #&"ܟ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_ ! "#$&?'_()* +,-/?0_123 4568?9_:;< =>?A?B_CDE FGHJ?K_LM  p   
5Mx MQRT?U_VWX YZ[]?^__`a bcdf?g_hij klmo?p_qrs tuvx?y_z{| }~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ß ?_̟ ?_՟ ?_ޟ ?_ ?_ ?_   &  }    PS#  - t	.H    [Xu
.'
uu  `fSfQfWfVt, uS l  Jf[t݋3ff^f_fYf[f` a ffa   SQW؋2__Y[ò					%
ðc	
Pp[^B
`r		a2`SUf`fNr	
	fa fSfظp	fӝs(3Ҡ` ؋60 zea4
`e eue۪e	e8aP (33Ƀ t	APuxe&>R(eaB
f7  ta  ?u _r    !S`	
hzW_+[% &E&_"
!x$fRQS	2[YfZfQRWP
u0B1^5d !, 8uf3W+0|A1X_ZfY6 s1r `ABCDEx} ~@fPRVWf	 fFf^fNfViЎ.< t ~.FuN._^fZf[fX@	1r
@
 "@
VfPhPf0  f.e ..enfX^=Fn>?'@v
 Akv1 .;nt t+0t .PG AKftv}	Hnf  4 t j u3  3GEA3GSHt<  [SN> [[ÿ t$v~ Oio !PSQ3۹)Y[Xf
	.`As.QI..Df.|VfVfWQS3Xt| uRY\t[Y`^ f`03a~;B tS
tw*
t& o	PO볆o##`G z tfeff7~
^轶 `a[]
 UPSfVW2{ Gt {f \ t]fAh6nP[AQJ rg>Ut2gFYPAXs\Pf3Xsȿf	P^[X]SfWfP`Kf f;r[r}WitlmAюo]_pmn WAp$_p&5 rsgNZ	g/Prs <@\ZSW7gfFfgf;PCIRu-g{ u	gf;K\gCufQgK1`	ffYfX_UND^A^Ns" Pp  Gp  fn
y@ pGRj@<7PiNV vyN"Q3ABY;3A+X_^Z0Q 0  t8Y=QhB
Qf?a?p}?pfY@~p
6u`fWSQ[a^fWV߃3!Z !P11/Pi0] fP.t "  ؎fPWPb`f%: t 2rhVF
uNF3p	F 8ȋ^V`uf
Fr;Vwr;FvN3Җ^ƀj rh?r3Eȡf7+FV
+FV؃ "𦡣"  m '80y
+G
vm> u怲A*eF81	j jFPFPN' @Gj FPB8V
q	q	~ uazpm  c_{ߘ	BhBб  WVߋF= % k:؋>@@@Ftlf&@8FtF% { +ұt1Ht	HtHHt&-9Vu~r"f~  r~r	FwsVFsF^_
  dNf*΀ ȉVfF ѻ
Ɂ3Ft	( I _F81ӫ`!1!0ӺPU؀՘f0Ӌа< ְ~k%hq~$wP!ӋV`fF~ 7	V@V^ze(FFݘN*;~^u@ޙ
)ȰRPWVa߮uFfHuf@FVc;tL+=t"ޙFVF֐ΐ}VfnJāW
a3S;Vwr;FwS)FVFVFًFV
 @e!	>fG`G3VQF |Πj*΀#@@fN+TRP^#p9Fs$FVp`0iDf0פ*QQ^@Rv@ъa0Z~ t	\Ë!An0r:W~ptA#f+f t_ӡAP  tc`;vf9GrLC+sC AGvfGf+`Bfvv? AF@s0 {~!F f;OFv8`SVӕ 
f;Dv3י`΋VWV3vF k AsPS@5FcFRPDujP0뀼ze uvdNFFA,ƉV=(ut'*$<u؋ƺ`DRPA,뼀~ [uRk+e+ұ8! ^*䊇*a 	7>uS;7F96xew٨PS¡	u~+9D
r
w9|vd'vvDҋ^0vB
@ *H+;WrwQ
3*O;w ߳ܕd~15NFaΠF3cEm8$<uՓ32!FߋV3SVe21Fv8H w t2Nf% ]8Fl~Gf@f6VA< A@PFVR846'(T
d89Dv0 5Ԅ8JV@Bw DC@FFs52/?0S1a246A c tӊF!t0$"DPNs546PN!4Ҫ6qA78rTT#:a:0f; `JlfYO<h=!3>>APP3PhZr3 j
Z^  3ZPV+k:ߊF%- ұ݀PƐ@@x^_``&`a(aFt!F5 P%az1 ъ%t
 gB1T1Tr -FvB	F t'5  f^0p"tA^%5~$sqr% g		^+F`̸(3oP#WVS*! 
 A^E\;u;UQ>)u	pf+^uVӓut F0^(p=bp _CN݉Q`A3n F(/k:@2fut @u% 0; |V@3D D:B | 0  0ꢲe	 6b^|ΠF0Fm1VM0źF$<w`"@5k:@@G  **uGW *␀= gqGr"t
< RE	E	 b2s" E*= t0&jP#Eupf$ + 2E~z 飘yq> ւ%>WVQ~@ ~ ߍD@5M?
f+o@0׉VZ➿@hN밼$@fp^ akN:ى@Ɖs"`lP@K&0(@ѡ<Wu%DFB ȇ*@PPo氩9v^~wko:> &@ $~= @sڿ0 ŊTҘ
E8%Vk :@ 0p
k:9@tC90B^_A3~6 "@tu$ NtF3!ǁ%^t7B1uϊ5$~!b:  ~߿96't`}b%@O0';t|>'pt@ՋZ2%S!}~fы^9Fp 	Fza
avvo^42M  ˢjp F򢧑ft@r
PvD26E
2t
9Q!;WZw;R-fڠ]Wp`
 *1h 9j $٥٬5ڠVQzْuQUЋ^bt.>&u`l u~W^DFDP1 `\]#A Py°WDP164-랪^\uq!?FgG  P
K`o~:vR! v :}tyhQDbP5mbE9v7yGDPgJwtobPǣP0HzRVF@?f*1k2Aw8h3گ 5tay}6
 t;|a6 PpvPFPaĠ^eDPpc
t2gUU  UUv6\ } uAEht"aP}+*FN*+@tRZQ>xet-T}	?kxe!@v鉅+e(exeVPSVu@83>;r;8| ^[Xpfam`Z&k``!muN#. pgPb$@*'Ft>v9v7v3p~&p} @ `PqCA% Ak^u3҃ r PA3wk*䊁u luRv3;Ft7;t- t#i S+`,u
uGrvFr`2By cIplЀSRNN `0mFtv`Rmp{Ny`zy3ҋ|3fs5Qzawh1pj"$`y^ @8@ӿ` W$pP?'0Q1ǈ%@}, .fJFBBBB`#` ܈F-F҈FvԿFKL QLo QuS32<V Mpw#Md PbP*$@V tPtR``BzPSv 8Vsy+ ;Viw;F`LE9VF1V =PCC$DDV/EVF$QGډVPCIޡDV?KVF?M9VF0<8Fnqƺ  ۋ^^"  V  V& |2\ƺ( }5X, xBtfN F  fBtF0ZsZZ1[YqJs܀σ8F v]r9YR^+8@fҍ8@]V鋕F+o@`ڋF֋Vob Y0 Bt,f{%  FRʯ
`a'3b,  e> kQiP`m#X7R          Ux NtAIBML 761295520C??Cr   2004/02/04 18:54A. bBG ZF
U2 27Mhz VBIOS Rel5772,BR5868
 (C) 1988-2, ATI Technologies Inc. BK5.0.0 VR001.00p07d3 1 mssaphi.270 v611  MS2 AGP ?UN  \  \ T  q  !7CEeurj?
^  :0$TVSjJ0  ~  HD8P_CIRAAx P RADEON I`340M  CZAy0 3Q CD  <  AP @X A`wT M[H   Bf!0@@	  @#dM#A`$ uHAM1#! 1#DYp 4@s_tA @ u
A-A<@
 Q 3 *L  @, 
H < B _  .-uA.B,B`,Q-(A 
 T?0T A
-   $	
3  # CAav0p  lBwg
`D d6h6l6r 9t  9:F:f`.>, u..,..	 u1> .0.9?u.0Ȳ.,faf`S.=[P#R$yQP+$XdD .kfa Vi^dpz.>Dt贤_V F.< 
 ǣ	(I诉$eAF JPBXpJLB6P ?u3۩ t߀M0MM{ M  MPN = NXuM2@t	O @ÀQQ@t÷O!CB0S M ǀqTt
Z(vZOtcZ0tįuVZ<T u=T첺2ĸ FG葈f@ f@fb)f| u-ff]@ nf.TȣpV^ <v  !  32Ĉ&! .~ a@2ad^	AdNhV  *81@Ld
Ff^&|G
< .   k P+ @K_
(@dehF6 F
u'XxYt|Vho"G_oVX2FS_N)N=SY2`mnV<tipWVqtWVtuu	Wqt; t6f;Q= Y#l-F;$u<t<t<t
<t
뉰F f;X[# ~ tF: FphfǻF6r<F2AY\ wtÈn<uj`@atf ct p~^"N  3X8u qxP 
X"8tN ;N"rҋNN"ar /s2~}tRSf_Lf@  ffff&f݋p~oq {sQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ܀ 
F  yFf@F$ߋFFF@F&F(( tR.&P@,X.?
po[PR.Tt2K ZX`"@ FGon@rj=Y	;5vu tU;5tEt:]r9Urmt5f3nq\f3ۋ^$f3fq!}Cs
<2
8sn~=}:n=a P 1'(x#D Da S?BDR*C梦cOQ]0eGᅨu @gOVࠥ@hOQNbRU0TJu`ljBcgvW?X _ce
pdV0f|71cj`O| !f7µhsb |h cf	3JUB' $|yĽA)1% LyqHdy32½w G @ן/?  =ҟ)$ǡf1ҟ 81qҟ*$0*űǟw
 	
fŐ3ӟ,"

` A13G羢oY]M``aH袦ip}1 颦q ?UJꢦ3r 
u<2ū Ujۑ Uۈ Ճ ܄v 3ЫPÀu#ڋ GuD u	 2ôU qxƿFF
 F ҋ[ ]FbVuR S|j`UU```$VF\쨷ut@ @0 ,^P@p Xj  U   SQRVWPw<A=D...Tt& _^ZY[XPSRsP$ BbXZZ!2&G@а薨u
R$@
 XfPSFTE݄EFАst? F% qPu AOu/~@J2K@jqJ;[f1 EEF!Xː.?6
A|t%	u<@	2@ n.
6]_V
GP
X
c
#g
@	EgQـ.2VdYe	 
؀
u@	&Z^NF k pfFig FCgF40 F.$FCVap@@@?f`01fpfafFk[FNF rjF]kW  0_$<P⩗_QFY_kSW>NP u0x 0" 0"0"X_[( NX$M[_"ltF$F&p~@o?
u/~B~C
Mq;M`mMVD Gp*J( f3!, v GJ  P-yfN-A. @.{ty+ @	 Tw CU](  .wp'Mo
Ģ+]*u`
L"tML@荖`It<uN(߃u#3y  AEq b;b;wt+SAU1([Y$`>JACJ:{C@jQijtjKB0Bt
 6tK@@L%?%P%@
Ā?
XÐ( 	 c-'(+ Ҝ  ' PoGHԯIJPpK`c_OPUjL(@OMoNOPQJ@K`LiM  U@i0OWoXY|ZaS@ ST[\(@] ҫaڀi
AS mZTMB](
cpUe#f ç
   `bc7`LO
b MBHU89:;o<=>?J+_gGL_BReiJdpgZ"ozcfkjhI2Oi`jf1ogڱop>hꏟ2 qrP~ps 
`> @،(@uU	

JpRK 	_\ \wy^0{c_{`|1a}~ %( (,%*26', 49$,0	
!&.3+0$8=-2o $8?ce!ac8`xecpy#@~	Rc%m~(pcKLd _m|joRcS MdOoϝJ	eKgLh9MuScgTh9Utf(RUȯefewwy ?~_x{w_A@YUzAJ@0{ O<..puð=Ou&"P=: sX.4X;B;ݞEɔp_Y\l"/x=>|؎= q&P$$(%$C<~.;u*6G<t8Dt	\S
OX=PC
uX1체0&G	tԱ G	`)?
u&.+X&c b%VX͑ɊP`tXubtju
D2Z}X&I=0p!UF 3`]U 
F CE]Y[	A*FXPs(h ?XSƇ[i(.>ku\9Y9V9S9  ss't
18 7+8$%@uP{z7']c;PR: XC  Q S[RS݋ڸ026'C[2S  &'[ ĸ Ë#Butt&FS޹ 2&CQort	 F[7	 2n Ȋ_3Sa
.f[t 5v @7t ̓rP?XuSصK[	$
tSÊg% oŀt4$
@# t$Êpػ
}P X3<JQu <~$<t <t<t@؁ð@d  a u Á@W  3  @
@@ b !"# 3@Qtb
%%o`aSI߀ e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;uPXmuK>L tDI @.>T@ϯ3u"T<~T&g7!0u3 30;(W2PQ33 !X2PR3$@tZXtQ3g0R< J3Z8 43oQ'3S3U3
1QR2aW;B;T; f3fRȊtlZj0#ZX8t`P ZYXkuT  &w@&2u ʈ2$
t	u$ 01 PYΊX@0Au3$0<0u e+&o
6o<uA,	*U+t	
te+/
 1)<u+,봀1u 
-
,a<3u< r3,<
܀4u< u̰-56u& <t	 p5ް뤜B"
0%d %^N49 * 7)Sr:P 7Ȁ>cu:,%@ 3ۊÜ.B.EC JXð+Qt8 &B BH<8t<?t1B .B 迼  D뷀% G.`G* BQ`J&Co G>CYJ 3X BQ
 |YkB.%NON% *P?#QPQG@HC G`C3S	 GDޝ~~|ֺ| |88|V8 WlW <~<0XffX Y@Y6xx~~~p`>>66f<ff<  >XXf^ f {; <f8ll8]x]~^ 2^ }0pp0$ff$j8||Qc|V<<Qa wlllllfl ~|0` 8l8vvb g``0 @ih`   W1A[$ehQc88 gP]|?| xalgfl<| <l n|onƀlЍ|@pAp q~n qэhg0@PcPc1sine q~g ff|ffp_ cf< l^l  b`|``oޚnƢu e <ryp ؿ  i`bqVup y|uCx y0g4z p|n~Zy|xlV}{l88uq^e< gP{0x i| 1s]||VP0Pix|~ `0vRPv onЅ6000_vΠq|P8yx`flxl`L" r l{ܒ^Ap|Px 0h|Ax g| 0!6a0Phpg2!f0"vЎ 0dG [qDa [ v0lqvY_{ |ƣƕ8y8l8| qa|f|ƣ0l3uuPlwQcl~n ~lppgopry0 ~l`?fl f^X>c8c> _ >a<Qqg A`{P|> >`gc=L`a0`vq`iqPo 0|w6>l<~te  6ll60l  "6UwRA6  `RAձ `QcQcCbj մAaUt7ұ70??0ø2!Ը!`Aû66E AԱA#b@ԱAEE  f`x̯ `b i8 ` ff`gPc~Pzr^|0a8 ul8qul8f_~`|1m 8`w`|k̈́j~ t͠gPs`Π[xakX je8fpK0D| dd cRH	UUaq2VdlVV5#WdlBX$X3XeX YAYYYZ AZZZd!add[d>6\vfasp~Y~%d>~~>%e"aXSp^d`{@_?`||` ka`℮ddbd $cdYrb7 p ?6ݢej9 ffj pxnbqf!n4 h0v~B`t9gr@shBf8 ɩj ZMp]l!mуmmlQ0no3o@o ` co	x0pтp r!qт|~	 cel4s6`2tpj|2uy4 v!vC" cS w#wcf`d|d``Pn
Rs cё| 4y4'Azzzp4{0{{ {|Q!}P}}xwp	e% ##a#
`c" s34DV¦d^$@d !C96Cd#V8 (pPo!@_ P80w(>a٢{ 7"&%W"2x$= 
F~3 t<Rd:,s  !uK=` ddQ QQГ3=d9Y0|Q#z;0x{7ŉ7Ai 7 h{73С#Y ;ŊXPs;`?p {?tgy\u2! ikf7 P YE0ED`jPYW A[WcU%3R] `{Acc0cB X7!Ή? DX:7 0> P$$! 3`03 B< ;D>
p
` ~"֠	"l06>6n6tѡQ$  D ;FŴ ԱƱE캌 c윏#'  #	ŵ5剘5 ܘԱùձ%  ձ%5úU #ұT%5 յշ4 T XÍ	{ah7ؒ!Ɓ"'>b0P"h: 4|t..te]%0<P``<f<( A| 0f0BV%v4P stǁ0:7Xt @y<_I/x8بSؐ0~4 u-t?W2@ _ר&&MPWI &FG_&E"&E#WKj_&]%&}&I2.2
tk@@' ܰ)ڊ = ~=^~=~=~ &U*&$
$

P0B$
-1|P2;t4&w_t eU e e 2OԊ%@+Fhݐt:b Sݸ  t`:t?F&݋o p4uf&	Rb]abvRъĐJ_O 2  &GF`%GpGÜQW+&N&D&TAΡ	ʡ p&RW_&TAF2 MD/Z
C37@	 !W_Z_Yσ`GQWM$0C󤾄V rt|q:&?Q	 G	ĸ  2WR% RҩZ42z0	2dYQMp&GCw/'Bw"wY5MP4 iY t'EPJJ B2BBXJߝ04wLT(VBBA wI^ ` (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0%433258:=<:98899:741	
	
(A*+ *

	

			`--


.0..R..30
{6*N1 **111u2? 3??13R3`3 -00B   $$$(((---2228884? ? ?/  4 4/? ? <7X888?'?/?7??a<7?/?';<_==--?1-?6-?:-??@:?-6?-1<@XAAA@   aE  uDE_FFI<IXJJJaN"MN_OO`U   R  KRXSSS
aW
VW_XX
[
<[X\\\P$
ĲXðKðK[  c1>I~&G3ue	u&Iú}ftԀpcN0jb  P3&2J&Gۢj ڋGLqkģ`À0cO BRl ljmbmlmmnpomÐ
  !"#$k(
K1z[1z{1z ;1zl(L}ߔ\}|}<}n2N^~>m@M}]ߵ}=`P@qPqpq0q aPAAQ}AqA߆1AbPBRr!/cj)dCSs}"?dU/DTt#4f?FVv$6eVESA w  0 JGϿI  00ATI Technologies Inc. MS2  01.00  @ @   &N   C>VBE/FP !.6P<r2.TWVSQR  f&= 2u " Wi_WȎ؋ʾ~IPW@" uz &u@&E6_W@`!@`@` __ǃ"@ڽ`0uZY[^_O ËRQSVWU?WQ3Y_l|u5WV6I2^_
.TEE
VtE M]2].l.DEEӀ~ZӰƿEE!# 
E"$ ~7꠷ a+~$ `к#к @"%~  EeUeB(S23[N
tȈE}~=
 P`,E*؋EMډE,].

+E0 X 
 2O]_^[YZ0RQUSˊ$Pw
 x < @t| dQL Y~b 
3Pɰ c}t
	$XPAjDmIjDj2rjDPku-tuY.pb%O[]YZPø VP$6Gشǿt8\t`	2^ƀ t %Ԃ@^;O ց	93&PWVFfPYfXF^&Vf=F^_ FG< uû7Q.T.0W,
._?twCCpPS(Q$ F[XSh*= rH[ ktpt
uPSR Z[X8
t
<RBB@Z2Àuptp<wjut`2.T
,a<u`O2͋iaPX(
uÊ uW^@!p*_O< uL0*؋RIS ;[2;vȁ~#?JS,f[Dt@SC[%@عSQ)2f3ff3fY[f;Ës >klIft2uGf`P1RPfZf ff3)fX	<u觾S$f[faw==f$` %%>(؀XZRQZfXr
uQR~ZY uRYhZt3t	! wl wf=	]QRW!9Dq޽a f&Pfǟ$
`&fA_u7Q&   0T8<\ }VRJ0fPtZ^fOfƢPRTZXtfffPf7VX ÑV~`RfֲS7ZuñQRfRfQY  ` $  ZYX
!f	^@
ff
v QWf`i !0B~r&@
~
fIu$t%B&t&@[\tWa_f.`**;t+u 2`+@Xw.,QSu3tA
[YQ
$Y@?SQVW# I  &I5z55^Y[7QRVW 	_^ZYڋ_ } T Q9̃8U@MR2 Zt $Q=ľ=
`= tSR <uZ?DQSO=o>?Ā&= 3JJeL=M{N~MNOdPP!QTHRMSHSÐPMIDT`   aB܌أp@ܼTXR ZRw M
 M ZÜW _Ü  .,3d f.;xu	W 
߀	r2[fXP3Q& $4
 UzyRHSQffQQ2
QQQRWPH f3fXR2Z ff_fXZ@2@ZYZ%Zo[\\ZV^fQ\fY`̏YZad\m\]jeV\)ggR`e}=OifZf ]f_Z^afl g +رKK;rZ` S 
S  S@ [phSSSR	QqQ @2QYÜ2C @pO@` Cw w Iwd xwxl zwzz{fn^~a.D= ="f`.T.
D~#PwQZSRC~l.s OZ^3~`
	.DfXu_ Z
B|Q3ɊOb.d"YTcV
 GQ A8ttuP3צt }bu
vt  U`PXP aĚSQ nt)hkrOIC-KuY &V
pEk8t
]NPKXBL`('`A! `Qvjr
g]Pᝅ
XQ臡P$B<93X㱭7r0PXQ QP`XrrXsYY2Y SQW _YQWar
&@G	Ku_@P AYs"'и'Yr?
 Pft2+QYIn00QU2F F  IЩF EK`pe~  tf~[  u
P t p]-wu @ktuS@[2SހXY@[<t<t0ⰠMu[<u <@˱u 2뎻' 
PQW&EN_Y&='XuSq0/upW&
_
t `p䜐uÀuW u		.WðpPXq v<Zr,ZPA [SE@r6_;w2XXnVW@pnH$S舗QUHyvA. t:uF
qPt0XqF}
d
0$4 tp]зR)`82
ڴ
Q$߻ 
ǨY0_$7q,|$ARm|$N\URN!$|#ۀg$RX$Z Cu9@0S%$'"2[M$%RB`CtP4vX%mm Sno`?KÑNNOF,F"Fan0v tWolnnnt
uut
NONpR $?ΠMS"
n2ACɹD  0q $`?  D b?+$p'$R b#$P䗯
ēPR_u$jW2Wp12;p p)
st`?
B8pP.ktP ^XзR vqN裯M^Mp)mEskmlem	phH($"R50t\
&辷O p)uC
kk;lm%"`?u%" dILLM T $ZBRW	 	2	$	$PS
[pPG_PQWP1XXp
u$<0!<t<t<p <0! r0!F, u	FfF6%:R._`*EfP%~GF6XHݎ u@F8XH0Xf%  fF:(B)f=(	F:qi2E..>̋FF(PwX0!}#r]L0!SK[0! Q Uu	 Qp'TtR3Z0Y.C2HFP$'GFF$.
Gz2 4F 4$`4Fp'	F 4$4.M	̀

7388
ňFF	$4	F	 4
F 4_Fp'3 4F G
F3F)F4FBFGD '%%>a$WPQRF;
!t7<t3<
t/"P"
<t<t(s2NAVBxJF Z`fv!-P%2XtkorDujP n0X P)P%G:u@P X0Pc X #u#PLP@hLx : p0d ;>u;852/,j[Xf 
@	[ihZgqgI"I;JCKհRu
	Y gg5hipu@TtIfEߴHHAGtڽtauIe{q[f.? t.;u.;Wt3E@^-'(+ ]cߺ@^ߏh_^_OPUU_ wb` _bЏc XGW@c n6gOad  _`ccbTF_fc2kUjj. `cImn  qZ @Ȁp
2[ESQp3`
/@+3!pt!p		t!p0uuC@S ux[>'B1J4g+PwwwvJ4g
ﰰ5gtx2w	npy 7g
ux;gpy	xPw py	Q|
uxPw
̀<g gwA 
Ȏ? pm&v$@
Jv@=^v	@=vB?
ú
 ^A0IJS b߲Q$P$fP,
 _fXEfX=ьP5쿲S#q?
;s.:Gu]u.@R&2 H pa f3.tUĀuB@y u*@ ff`'Gtff.#Gf.GfۊРuR}S&9[Y  fSfQfR\Hm  <afXf+@߹@ +`fSGS1rfDGN1f.N= NFd.Qf@if= N  ssfA!ff ffе f0u  r88
@YfZfYf@@ K PZ d ¦   	 0 0R  ߀ 	{    0    ߀p{pp ^0^0^0^'CxA𰱰 "p௰P	 @KZP´   2 KY[VS]XW πQSfXk  @}õpf[@ V	 f`
^fXQV2kk.^=a ~8Bb YR{
`fXf2@UГº
QpP$?`X"PUaw0P%PP%X3Qf
?Yfp2fPV.^2NfX ̝AȰ
Iquf&$Pϊ32fb˹pYf#PWVRQ+Ë&G
P36 2r-v8t3t.t)$t$)t/r
4v6sPQ@apfX⺲&2&YZ^_fX QR
FF?:q50+a&!0ƠSحfظ`  b.
$ Àtr_tt(It°0SIt 0tR0ro `da{@t@.
莰f.?=WZt Rp f.;Tvvy`'P  wjvef+б0RvM `v?~v2dtv%jv` e	r	wUNf߉V`^f*f.fff;rf@frx*f.?O^f;rLf?.q@f;wff?+f'av
ACX.LIa؋N]t= r = r5.DP.Ã (		[@E1À tpװPR	V$T$@Ru$ZXya&GG@tP@щ!!$&W7u t@v@nvHZXv`ZX   RWaq3t4Ж_ Q@w@`0a6؟f.qͰ E-  ͸pff  
N!>!  ! j"@#.qf.&s@ff;s!%f6#
߸${v%q&X&'r#5 6]'f60"6;Ewf6@#qQ@p7t<Q2P5aft@f\f
 \?
P@ "Sf44  Q3ff%_Q@ø \DwuHۿà     SPŊfD%f#p@Ƕ87p 7087
  7 0 7  7  SX\$p[ $Z
Ҡv)$@R  i u  @и(.q.&q6sE.q.qhw`F @@pH<Hqp$.@ZO>@!Rl 0%g +uKK;r 4 S`<
S  S@ [ 4hSSSR	Q OQ YQ2 QYÜ2C @S 				  aU p V
eu2[Y."D
.
veutcnus] @C &C2oࠢ2?/Z[հ00`U W&E_PZ[YOXZ[&DVZY^&^fpb$^fFtf
^~FfNn;w`K ߨ[Xu;ifG??P︀D
UlFF m	BkkUtfߞelUp@
߸TVp;UpF0͐ۋF-7ho{VpzUp	FȊă1n4RsQwnh%w8&UpF%! tQx0	VvPFf=P~)h@f
 ZsU]Ë؀~Àu聎Tt
 $Vܸ
t҉<071
Rp܊2M Z 4 ޡO",嵉"!?S 	QRc3ҹd 4R#x.yZ[  RP۲UXnP聐$`K@ݨ L ($$< 3tp  $$@!h206
u
&4u5 * u.0t.,ﾭ3Ý W߃ [ WQRVSQӰ.۲+$sܨ g 2@ W؀۲|P~@-Ϩ t	 |X  PxEbBt-OD@
7._[^ZY_V衿/=`VWwV?'P2Ҁ?څ2LnTС p  WPQӤ_ a5 P uD_pz
q Vf^fP_  @!@.fZ>Pu&?_0@Ɛ =ËË}ƫòA0؃"r  V پ?y ҤuMy ZX^.t6Wؿ
	Ծ_R0Կ 1VS|
;uwq[^ؿ_y\aؾ@}^ 
 3 3"QcОV胔 6  5  QPcײPpⲸ'X1RСXӑq NلA?;u@بu[û" 𻐧ڰ[!
gf1![z!`3ɎAۋf @  r/@s*tCVf gf@f!*f^f[Ao;tw59  f@AA:uf`Aa Xh l  Bp   & @*@LN  QRS1֐P0Pf0 
0ײXP%
XXUI[@Q ?NAtЃ@ tP/X0RR@s~  q.mց<NׂX F `یN.L/.xɋF2K Bd߀趠ۃ^ !֓ד
u3ɻX0ZL֊ȵPN鰓u: ջP u !$2逾P  $WdaOԲ) $л
Pu轎u"Lt Q  VQ 8Kt
;$

	(גђ@Q@ZXt3o&p;ߊPEߊ2bKt ^6r	 wa w tӲ&$P
0NR2!uaH
+Q޺PXY0^8bp%Tt$Uh$ 0MwɠuPN
麑T R	 
t U߿6錑P鍰w}邑BJ{f3.O>f.O&%߲$*
poof  f 
45f..O>u%s%usrE%
p
 M 	<w б 'ΐ` t ҲV_B&EJw0J
Wΰ`v0J.$FGG<v_T2`/HHز80pa69C6"4 >18\/hѲ8&E695$&%{+W 3	 &OO_969P$p/:ʏuCP[@uA?PX,fۺ U!-@0+fOf'>u/вޒ/j>u/C$:+M>.[/&`8f0fmƀ t
q$	TqRIAHcEFуKQL3?3ۻ  DK 0f+k&qo =5KK0tЋ&1f?PpGDK۴QLo_Ak_X࿊f% pQIu9]t*V~ϲPPqGX$
RIq<paDꍀuznG(WI`J`J!\JPQLraTQLL&M@&EAkpܡaQLck\uoRQS؀〰	[@@t#fY;vȋZ;ЀgPRfQnZSXnaUWϿ"ku$,,γJڌ!-܌q^Jƾku?!m2ۨR0 pSq1ϕ[op'@qpvk	u*,k萚u@w
=-iBSk
l@p$>m@n$*klgvkmnkPQR $ظJ/ZYXً$< t W}& G@<Q Y鿋p 0/ul R
,{-Bpu~P5u
uu]EOT`q+YE+23!"Eq]FpB@Q Nt b03F0BF11
`
t0%$ݯG 
Su}`
$zur`u$
Eu $*/u6Nͯ= NdSP[
OŔ oo 緀
rȉZXâe;#f0fql&Meg&U
g+'p33a 3У3fu@s@*` fЁ  "  s'i2~ol P $Q  f%oH˻
% 
	Qp$0!(f@ YQ tpB ౬h%[pPX
Nð
`  
- P@-ࡳP`$? xa? -gpoZ =u?Gb	$94 $ `F  jjjQ%A}IɸG(/$ɸA 4T,bf%QP @߸@Ŕm  3 ߱Aða3p߀8tR_
ZPSRUȲP IXoZ[X pRߊf$f[_ 1f "gR23Ұ
)u
Z`..T un> tgҊb2P>bP22AQJ2=QRPN, 32sZYYy2 XaZYYR*8}2.TZàʠ11m 2Ku2W S!u
@j[+2Ê2+`**&R  11ZHuÚ 31"JÜB J.TcwQ @ 0PQC3BBaaPQ YXaYXPԨuXGN!+p܋.J
u8~ސ؀T$0<0tTQ:Jt. `S /B_+`*2+1uX ʻ u*tX߰ . |`"aq0׊4"
ވÊ"ð( .ѝSr= $dm݁ ? +Q,QVW++    %_^1YԊǊ竊`4D2_`8v2QY2P >I?tP
RSbӇ PL[[ZRРJ2ZË.ߋ2 03<?& t
u߈V EÁ~
&J
Zv[
2RaZ`Lȴ
1
t
2&Lp`  >&}S`YظUJ<t
@A<Ut2[ð
` 6w`%P2+Q+w+ZPȐ"+Ջ+Nu`p$` t  .	{t	|A(.o!8~
td\8tX΀|+I~D*p
8t8*t2
8~
~߀ȐF}*t+Ɋ*Ŵ
RQVW3ۋs  2 ߀!t  `ޑ5 _^Y@ ZQR2ۋ3`T445G  ZYËxs& 	r ;b;;<	 P͍`@>р>ff@xfd?`R"S[F$fWfVfRfPb;f0D+Ɗ2BafXfZf^f_SRPf3݋f0GZ2f[迻@N(wy拄f䊷&Iplw$KE|t;@7pM_v[`+pMovI#CERZoO@REAP݆׆ѐ3p鿆yKtwFsL餆鞆OP+>PRR+ZRhiMt_o&XrRR+ZZq7UB	~(|R( 詿&F +	u &F E&  AcP b+>2u	&}utGVW_^t!hut
>| d2@b!ab	|`\Tt1b 0	rA(`u
QcAc6JX 2Ba\pmSXO@ 2cҐFf qKu[q3^K~RqV|A?g(
o`Q:uCG<PBaFgӁX$6| 62YtmU ؊P hu)#ë0&Ni>Xz ҿă脡1{  ׃Pi善O 陃cÀ?t!&0?$ n&WO O8r2Ê 2aЋ"s1RaGJ@A~PXWQPsêuXYo_QjIY+΂MtM_vNov
 驂 _uPUP[l.5X0qVPQۀf|@gFum4XPRJWQQWj_G8v
 IGY_۰ ![KZѝ&%_G+B;v
@Gzr0 3òθ~_rR_mp<@XߚRWQRQWP8tXP@u$֑X_YF"Z Y_Z?_ߦF4ªūTҬ3>ct鋀鏀>
u&f3 f _f$߀ }
ؐJDSP
S) Dt& `&]{Xp!9kĴ !GĀ# K
0) y'C[Pm1T1%  !%%ﰣxѣ"WYX&EzKt
x3k%t-ϐТ2" v}~~YǊ@0a~sK>b2PI<
vL^5$IǪA8sZ y`ayt u2<
u:6u ƉH~<u>~<u
t22+t++&eP>IR7`P}}1y}߉}މ.U~F2O 3Ɋ۱ʰ')uF r}h}ﳘ 8buܰR'}~0'0kNV6}b$
I((!Q̊.M\t.;t$.
DsY2k^|#+3*2d!d"<{PRZXt
t
|u<s I.ǟ3v>QXptDSݢ@@v3<JnktÆt``&F|+`&}Sa 2乿 0ì밀w 0$&e te ò @NsQ 2ĜB JG_  /^ {Q&5&m&M CYj{
u$0k cu4L){ vS	 &w5& 
M
z` I@kz}4 {  0k^a ,T 
ztM9 )3.>P;PY d߀2| XRa ZSںpB|w [= SBB  PfQf  Ѿt%tfIu! u t	0!uM!fY>0 vu ՗!Zu {"$ .aã<t
yy ny<wPSPR2п@vo@	f`B=s=s=|s^=Js ZXj[Xu<t<tˊ~03@mS'[xut05>05B05Fx.| ~ xȎpA2..x 
*@ b%Ƚu- 
u08p8w5wp6&İ8 u͎..v=.FF xu-b%b)b-uASK`[{&G&g3t!:<}{8<}:8ôPC<t
<PL̀
&Gw2 eТm 0֋P$u"3ҹ <uސ: K?:ށtpI0o
PqHuÀu
&~Ґ@Sҁ[t (22Q@iF t  +YSuPW>&}t0&<t$8tGWȢ&E@-Vpf8_XF3tV_tu cWG8 u&2}P. 1pt@$
J	U_Ǌȋ1uXtHవ10{&a L2u-t
bdt<t FQ S@TUVJQWW>X=&]&M&U&E
WȝP @-XX}2QZPSQR.Tt	>0ZY[X<|u?SBSz5[VQS&F E<
@<
t2P<Wd0\p' t&^ EQ	[trs`߉-P 5t}	t2SU' ][xX[YZ u߉:ubt`Isx;^F6t<u	C~&t.:r2c.׋]p7à$0<0tuPtá
2.;t8~û o tpg1#_^ߺPAwЇtӉg ҊЉ 1   ?     _Ϗ3R櫲*$Z.g$SQSQ@Y[f.
uY  ͵Xu	f.> Ofmf.ߋŀt
uꀓmRwŬ-
PFtZo ?
.1(m2.OA.WBotW+A_t;rÀtwX耐
u򪒑.&hċȸ 3  u,1tpt@F 
ݸ]wwu?G@2@
uJ@JЀ@

@ 訫`Pګ@[ZPQ.>dNu$.dTrT/>9_SQf@輪[#H`) 
XÜf`KPSZYvt	 轱 2!wPfӪ[1fЮl	2Dg	
f @502`)<࢐20FP6f))f  lT`
f Hh
uD˩P o$ut fafP2ɻ| @P$虩T 質fP諁wqP𲊩Q^P 谩߻舀f3f ߰"ֿ@Ã"諿d1øff	ҪϪ̪ީ2p, $
 fXM"@m@{X?X@d@h!@`pXfXS.= t.;u.;]t3o W.uRf 0fW.e0FD<t<<t8<t4<t0<P u0Pp~.=@uuX5
X
=u
M_@E=@pXx ^}0Րp׼0p P@jPmm@{wj X--   T ҿ4t~<VPuJ0f@.MtM%.M߸ ߊq;{0PPAOK  XPA֠P  $G蘦|$P2ק$-·$k 货$u $苧oWW PйW .? t.9u.9Wu.G2t}Г32_SQ.iɊ
܀ϳQkp<[QRS$puskN2[ZYÿhw.;WtГ3PR~$Z#Rm%fSfQfR蚼 t3t+t#@t.tpt>tD%ffȰ+0ff$<t$f- < tf+ 02f
 2f2) ffffZfYf[V@24ȴ2`.Df3ɋ% f{ f. UL  
QP!mfff   ! qXff;t9
0}fX!"
E"0a'$3#O@ް
Fb ?=a 4m0+0".^'@C)+`D뺰E溰FẰG.F+.~0 Яط t%tttt	t蔺菺߰芺 |PsC?j0a 2Xq PO'2CQfX^    = Y + s"+"C p"Ryou@:u	 .F3H艢p& Hq&'PNf_Xfp&'	(2)^p-.~1pa

p&1~,b	s`ðqtfP
0#)4٣@)   /8b00ofPRQa'nupRP`03`0q&H`0XP`5v5l4 _z4	`5$Q4`5,C4?L6a0p&=/T'b0/X:^/\:/`:#fmuo ] tqt= tߊ p p 
uu
߹XTtY]IUpEp~Mx<~	<%pD YtWE`GN`> YZRSfPW1fKQ&`>.E_fX[Za224
KF
 1 #M￸<5}IF; 00q(;; > 7POQP 41  )088 OYQI? C:QfQ ·n%Z<t0
 
0Z$ BNpE<H!\;0N
RP!00j X2Zf
  P&F.fΞP@)/pac  f./t acK/0ťyte/jtef
@ SPB$WXf% b i  [/&4d0q_ZY^ҕRVWtVV`ø %3ҿ.;s&@i?0.\P?ËQ O^~n  o[L.boL.o2Jp0&qqG_^2SSD4o[û\]w{w벞`uSw3x띰 w cy@൞0uYX@Wr`PS2 .
RPJ3XAmfW+&G ff
thf.#\fߑߝP43۹#fC fbv 	WfVwVჭf
`-Є
fU͇ܜr_ X躜f^l[H  $,48 DLPTX\`dhlptx|  ;VQ  _    ? c$
k*6
mc8*1 TT
  
 !c!1͚@^#
AQ"  @b @ rT  
  @ .PA&d!   |AEs b}Jށ0=PAQ; Im` $aP 8h.!td-4}A`삜Hy^, y-10- =d io"z%@A#o koVҲW̑` sqj P"&O۪¨/odOG` ) '9qAҲ [GTF+ A 8/~-ҲUp+,  z LmLҲQ\G(p# ' 9   PB ( 1Ҷ@:  # J Ϛ/
!(+ h(,1PUaC@U? PC؏'Û-'.]hA,,.֏
e1^OPT0]$[]`UU  SPQa7ސ$^_R2fQTWݪPP$][UT1߀  !X |1
w*
O"|1
:?"c0"ԭ@rҲz 74H  pSZ 

3sҲIhH  WF
➐wTH_{{ #ƶE) 	ë&Ҳ~CW;' +O4 ` O  ! H2юOSA	
(THk	»{ 1ŢOB  jҲ8~G[T 5 AupΰҲ \LG  S% 4 #7P ΂Q-ҲO`36Gr  &5 !$β[̳4S> oS pd\Ҳ^x0zp%6c#@~
(Dд C q) XмPG'+V*W+W0a*/,c=. 2w.*q., 1103r31`j2aP/6335o@274py4Ra6Va:5Wi:"5So0/t<>`>k>V).?_{ҲGT@3F,FGŠ3FIfG= A-YҲ+^zp`5 a }FyҲ_) >8 # A|@ҫҲթp)+ !*Ʈ@R SfUT% _A/FJ[ D
e\IG^~WҲ>
w}pN`! Q^9y RN STɖłRR/g@ )QU"}N\Pc	p8 UĦFҲn,+8 u- Eβ1̳yO`= `}ϭ;A !; 	 Ѯx ym{}ԟտOoۄܐ+. 18ݐ,clްS޲UA8b9,	 P$&/Bs>TUg$TV N ~@  0 $ 
t腋d  øN = Nt.x& Ȏػ2؃? u2A PVɬ0	8uĊ^X2t.یې؋7tP۹++.' t._'.G t.((@.?tS?.EtqECCRPVfSؾo.]1f..M0f[^XZРf9$
p
̀ 2P*H$3XP.E6ʊfѨp$
^$	
W$.e9
_W=	_L.]9t=6lHhfPfQf3.MIff @af% f迬fYfX$߰ $. 8 $Ьߊ R脋$C =%
Ĳ`=2.E.w̡0uf3fѼM>f&w%u

o轉2ta
蹈)$
ûG$<ۉ$< R苈ZP
XހWRq$Zr`%RRR$ZWР.E#_VQSPQtX q$Afذ9%<оf= t*f="f;t
 Pŀ~ f[fXΊY^fPAˁf=qu_fX 1PS1$  Bˁ}@r	脇T_[$Nqذ@֨u$@d
莈$蒐t݇"QR1uuKm ߵ肞1`ึOm@`l.>kou"L0%1读 ZYW1ְt]3#$Wv
QˋM,ӝtv@;_1ۮ@qأްٿqՇ$s0&m0$g轆_TTt߇$߆P7$ !ش @( |f Rt^PTYOF$fF"P赆 ߯F/-T虿F(2&P贆[?$
qsm31DUO?uBF+ 1m$
F+qˆf$
FT ~P х fF6᳋F:|$F9h X装FDB0ŅF)F*F4f ׀352^w:2@њY[u觢Y03ۃ0 `뽰 $J f /f J$
ffu
` 
f_fu
 
f	
 	
f	ﰯfu
 
f̀ff`oCRۧKAkeMGτ=e3qÄ
݄ fq  ux_ fX΃A%$荃u0Vǘ	@WUF 2F E]u	FfF6~`,:ҕY._VP , .GF6XqaF8XHf%~AfF:fXb//f=.f	F:3F>F@Oj2E..>FFAu_
R P0 q= u;60=Z	SRW =Xt = t
0:u.Kʺ!.= t.u3_Z[v~4   @>D>
ɺ""
ĺWף.Et.;
u
.;Uu3_PQR8;OZY`DQDtMtDS2t	E
 BP6Q.p5.%?F"0+.
IF$FQJ2N*̀oKN*IoF GfK)L)N)I+$fF 0@f`f.LN+ LF
F&pQ2.O$?F($FP%HF-F%
f_f.T?F/FbU@
DV.oN5P.G$ P
Xn TMcUF~f	f	TsXY4cYw Zn T+ M.V1SFD[UWcKZ$F3?fF	HyI.F,3QI0UQf..gQe`JFqe0@e@^eFrfe}fG	[ڡi$["j
F0pY \ F\I
qVbl GblpY0^fk@e`fnUaoG0^S2n4e|APe
@epgpn/
 _Rerf/f8 N	k n0V`N2AVBF0 F.   tW訆tR-_:A.:.̎0d2 `{ 12@00	F2+:h,23BFD(u374Q5qc a2 8 < C F H K L U Z d x     ( , `D|S$^O蒡Ft\
F u	F=b^~.Ff.`'΋E| ~Nn.X wf0
2}}0	fkA}Ցf^
֑PՑF͸{}Hg֑  Zё Pp6JґF6tP7<S2f[|x{ёXf^߃fٸ4|^r~/ 85^ `8_^5PF=$1 O, @)t
謝!3ZYqá{${r{%A{Rz1{$3ۊS{
[{53_H4_SQWJ`=zDzKE_z_Y[>Rb{#RB
t{  RS200M  OEM INFO!-_1024x768 |  
Ĺ t }    ! `   \XT  @^ -dd!-S0'0@ %]12fd!-; '>]_1  
YJ @Pl%ÏJ2U* oUH'Vk QI!-ORG<>]Ƀ߁q2D 
 X{͜1[ ʣW2"dw	!-Y 1>}WY2 @QĀ  ;Gɀ?{b A!-g ? B "АȀ^=`O`j p0w R À8Uʚھǀw%ڙnΚ 	a@6ΚڕBa`{LYLoΫ!- \v@=@4?23<e?Aӣ` s8c8t!- c mffӀP̽,i,w}!- i l
%q(  3 ?_x?Rο ?_ǟȿ ?_Пѿ ?_ٟڿۿ ?_	BB2q,  2ATI  ۱Ϲ:;#<1COD$q`$^sPS3۸ .G.>s.$.*1INI??SQP2i.N= NXu2˃	w,.'
t #jPBgpDPBi.&ep pGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_      t     G  T  ^TI{ jP  RI  oIB W v D } O  1BW 1D  PIBmWbDaoOB QWDCDM!MD ?#ME 
%F h&S bQM{ QC !'K (U  j*R  |DR 
SR 
CR 
B  BLP BC BE BD pTS 6.TC PRS .H  /?sDBG,0WIN[0OP *0GCR-)SDLG` > ^ Error
  ?_  0B2  Press Enter to continue  (CTRL-Z!abort) ? _!NEAX N" "L   OA` B  C{B$JEC"JP% %#K{C$FED"F' P'#GD$EB"@$!#6ESI 6) 2&)2݀* :(P w:P
 >)+>P, REI+R0- VCS0#0Dr..)0#,S.w*F.(G.ZF#a!rDR0 v@11 z@12 ~@13 @14 {@15 @16 @170^KCa1f 5P2j 52n 503a!"X#`7#b$3%Q% 9#&c'`p:8(@8!#
)
***	`;+	+l@<+,"---c.ͪ.C/ݳ/#00ŀGDT ɀICLCT
!5pE23~W4NN a!wBSGJXGF]
a!6bG2gG:{lGZ0KIV:a!R  G,4M>M0qG.uO*yO(}ILIa!"= (SCSDSSIT!UBP= D]ST= F VG VCS:IUSS:@,SFLAVVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=GvB$[zG$[~LIQ$[V$[[$[`]eb!p$[x$``QP1UR1b2b3b4b5b6b7VCLimit= , Base=!1Dte^$[f$[j$[nb5Vach51jdvG%HHVI
JMJ	@KIٖOU6PPvQMMVNryKIŀGɀtuOQ!Vegh^f_la!C= 0D= D= TR=kl!{{P}/}  ~  0>  | ߄?_ ߍo}~π** Divide e Invalid opcodeNMI (previous instruction)Break on SMIDebug hotkey ssedSdrg invoked via callPOST tab}lntry Tracepoint
 							

*
?
EXEC WRITE`RP  _ACCEQ/A! A BY2ORD
Dpª𛥭MONLY î NO?TRACE `{0# Disd _RealMOnlyEn"B#NO  INT3sP`"OT TEMP  OFFONeISABL ENR LOC#  SERI#f CONSOpRE20cc ս CP@
@sCT!Ҧ A]LLIõyo\oǏȯ0`Ȏ؎.V0| 5 tU0̓͆P>t:o$>U.#uG6J557 ѿqs
G{7} uVRό4"$r;s3|7۰$ 2 PSQRp.c(f._f.f@٭Ujٱnٵr
u, t$.t@N u% ;t	.^ /uϞPӵPCrt..9Vt!pc.툑!wv   a{ 0ֳurotib aa
uj. .>_P0u+.^t
u3t-t._ ;C 3u'߀u2_".  s0d&Q.ZY[XfP.^_afP`r"{>t"e"
w B$? 8 b ",  %" L faù   Ptu
D>=4 u	0rhN
	 :tw%3t3sT4= fPf0Ka}p	bҍ6U<uf.R=fu<=upfffDf.0
?f.rސRfCf.a./c .3Ӎ!>/d  /Ϲd  Ϡuf366p;ZY{f[PSVW< t"<\u
<nuF=3<~u s2*3_^@PS>:FsI>%=s@>a4s7>(r;< u<<<u2B
VM5'2^@  CyclesAf(uSec= ) ???fQfRVϨ u\@ًaڋۋr611ftf+fxvfu	61ff331f.x082^fZf .{݁Z<@ &Z֍J PQt0ϋc 2r	12tYQ 
#2'|##	 y2s
11t菟4r_^%W<;t=@"  ?@ $3s?v4u1rw$0.Ws_"1tT!I4u}1uP	
C=34u2r:f{ s2U1t 2r#D06
rQ0b ] 3 
4 5  1t-*3ur2r,D0$0t
>r.d. a г3Q@X\@	Pt5.R.;Iuf.;KtU\P06XR	r n6S p
ft<guX<t<t<ͳuL@	04t	.TS 34@"@1s1`/@?0֗Í:oG FFsG1G%5HUsGGa5HH Ñ/tI.> rI/rD/0 H0r5} ufǿu%$NNufP
ܠG RPpMSe [R6[SSQSSzG[b׋ߺ*a*/0s+"@%u/|-/--.(fpװ *\fW7O-@	ffGGt
S_9 [Vw2#-^f;t]-wߗ-G
-
PYfVEf3Ѐ?t-#.fGfsGbs,c fSXMemory, I/O andbqRs must use hardwarexf (0-3 ->Yr#-8]..N>Fr-=.뢙 l6`llmrD	{v m k-t.r__j@ k rk.՛k l@". f $- Gt >i
 r߈G 5  /! , u
0v G}pw WQr{W\
f\GG ,r u6@	P.O>
 rGGvs',tjd r#_Gzt |6f*3QM,r0fu!0P<upт0yQPY)U*c*i0_V	b- r' %3 `0P0͙R G+r2}tn  0SrS͓Gi]r
+r:1rlGQr+r$sm1r\+r 훱R .+P,rqss
6-u!+u PXYiP²
 fries_numb0 PQS ҈36(@	џτQ t"(6(.'))%BP#     0ype= Length= Bas rByt Trac YVW*   F(()u1?G`l!t )6o"(d@_u`  0({uJ 
Gw>  }'fGnat;)[	(GO(:
N(]0&)(P%=8E}	  Ѹ'(BhalPdy active. Do you wahto repl ihY/N)? "RVWU@	 t*@	.b 6[ w  rwfbGff.!!Y}t 	P}bOff3
G
G!3{q΢]_^S`pW؍ 2pFr{_rWS*
qg7 sp &Q q߈Ys<s8f Lf
u b1a`fSofthnoސvaila.
nrG w`w
tBtq u
*D u+*@_T r@	]; u629%P>&	XQU#_v`1V6@
 5|t/fTf TCC[./D.PGIuQG^` 4.D9Ou.Sq3)A -!{a`0  &	>VWQ Y^_.?@a`2 R_ *C={	f9Ou w.s ss݀PXa! ۶Cʄ
`".&^Q@L$ ù  o   P06.E..F 5 rGpGG0A$r8Ȱ|5f}{o##/O# = ~M#CP$39:0 r,pG;5@$tޒ	r0=G$r
13W$ts
 u	rcf=  w[3T}%rR  LwJ#tCi%r>psw8#t.T%r)psw#
؀#r#t_6%rQ_L Bu0, Devi, Fun@on= 
 tx0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** Errorading from PCI
 !  !#t+%tC #t6% #  pC  uR? +3ۂ!E!FfpCA!LT[s2!.!]Et.. pTp vt`[ p
#C vq#`4<ra
 a3~3U^Nx ~@v  ^xaAr
u!! @ !°!1 !B;Vr蓅!aWQU -  6 ! $s+ `,$/e XL.:I/.l0
 A0hsu0hU9!u0<# ;# fС"D4u
4@L) ;"#f.##@46`3`85vf`306 E_"f0z"CB-.99ud>p/u/ xt- =6)8w.#
t0 +)+# 3"qR36#..VW."@sp36f=qs^W7?s6E$k  >#󪔲2`[7(.# .PACr!2A&DD67@JJ/ |0n3$6p3$
4! 30q:."  9%9:"j/'ÿ] VW> %_rh< u
pV}@V @WtQ: EψqX@ +r6%&Gf."p$p$rS" .Rs9:}lBC^@
c65EIO"uPFoufat physical address  NPfxbԐ! ð#srk SOS2;tf8x&ps u2pu6;&>p3~rV&}%j~l6 }eh;.MemoްcompQsu;cccfulԀ_'0v7hx@4&p3|r m*!iip quf6']p7?f@g@p3z'j#w|wvwtfHtrh}@.y'lQrp5tgT4t[|tYrTQ
 `35Bg8xfqS vg{|l r^}U~I3ɍ>tA<'tZ"uج@(8t$ s&At!_TrptChecksum= k r[}3~Fsfghw> (wj[p3~=Np5l4tvv rqQ!Rt]T rp+`\rF2w"I<Lu4Fd r|84v.*#t5@]SWfl>r<:ufF	+rfF>	 r[SRir$r%} u`
frZ[p?.Ϣd3<*p3>*!Ds<$煩  3 .RՀƓVQ.04*lB* uV pKJ.B*?ro0*wH4* P2zr& E@ r..*k.8>*_#9 v~	!vD*9Fpp3!8*`4F* sQ`SASШ>:@6<U<q SFHpހR>J*=.6H* 3Ѩ0GJ* k@\DoH*?F*`.498*w
.B*D*NiIܒ̋D>0t %@  .;puf.;u>-(sMQ.l.f`,@4u ~ǀ g tPR»uIJ9t3..>ֿE.pV4m=!'"ï0 S 7 I.;Kt2%IKf`p;R3;	=>S@ԡK.,6S 3׉򥀱.,ޣ<`@\RFX@W@\۠ aCPU Time Stamp display= Speed= Must set s to ena_ble tPsP1BtJPr	d`}=@h.v&u&>rN@<uF`4v .{2.~ ,-n.6-YP$v3CӋBcbter =   uSec t
r!qh6o.xp.Í>'rtGSrS `<t.&Nt#>/r/.< u8t">r.r
u
#&
* T7argis@rt. Rs manually ifQfails6i/WMQI ˆ9^V6'~F A`!u`e@66 ^PQW> %>U s_YXLt,[r`@10Ur.J b׿ u`.& $rL2w,<r(.0Ur ߵ*s	 b@ 0@&
mkw
 u	1pW	.M"M}#rp.ݭPpMfQ__NPSٜp?ɝ`5P`FAaz· kAa"51
 1
 ?W.h
@i&(a
M̳zE"10sv$:% u0% M	gø6C	>phr6>niSn;;K;I;;**+o-?._/ 012346?7_8 9:;<=??@_A BCDEFH?I_J KLMNOQ?R_S TUVWXZ?[_\ ]^_`ac?d_e fghijl?m_n opqrsu?v_w xyz{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨЀ2g22Ѭ}[pW>2!2 t>6p_W} v	 EAC r3ۉ_P_rS t]AMw][P_)P٭
ЭPX
2t^𭢱2ѭ<w.2ؓ2 [SZrı`P  ( 1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?j_`!?`	3f<u.3<xZ.3<Q<
23< E<
u.2<.:7<u 4 0<s+.2<" &8<1<rÁTapu<<up08<.:X "3>0.?>2<:A$w4<.5b>؊5<t ˀu 8or6<7<[ø.1<.&2<@.=<X`E݊7<.*6< v&.6<#& Laz*3<S
.#!ԃS$3݊0<aR2< # ϊŴ* # 译K`
 a	AR.9<
 Z;<ZÆwBB5PV~^QR 3du t񰰱l`$<6t<*tPu.A<

y"A<
x<Cwp.A "B<<ڛt
ArZwG ZYA2
 d0 R7 r  dI r`.@<@r` d`Z	 .@<`a Qpt
QhUv Yuu#s3s`8umPf`8<!O W !Fq@ &} tC	t;k0ta3	h &c&E
 ظ@	 P(^ X @Wu-  ~pfaq`tQ"OA _ Yf`RW.OA.1Aw#.U! 	tff.PAƽ.TAʡ_PfXOAu.UAU.TA讽_f.PA+KdKK|JJJ9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH"r.A$$$AP <t<t<
SQVWێA<t<wPXrs<vA.A>A &_^Y$$$AQ Y8t	( PVtu@I0
<
t X2Qt .Qȵ$0<:|up06ff6PffXV/pϭo
p0^Vf38
9f^ << f`3Qߜf
p  >COCrf0f3ftYP0C++x@2 fa%

 CCR3 ۽CPE1< tN< XÀFu'Vu@߬<0r/<Zw<As<9wA;t^<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3! o!.SVW31rKt	s<<t<p; <w
t+&<Ru	& u@R< r KA< u4 _KPP0PECPEOI CN ۩ C1SQWU3t!;wOQ
G:Yu
;t} tۋG]_,rf s ZYf% r}s`^ r
<:uft_]Wf33ɋ1 r	f
ANLS:R ufP0wHa^<fwK,W<Fw7<Ae7JI,0@]WfU:af>fP3 fX`bfAN0\ u3d
df] Aef^a<'u"PS<'t	Ab3dk"eNt<Yt
<NtNP3t8tNX':*򮿋HH,
uÊGvO 7ÀM=GCp2PVWuu w_U "$$Jy$?y$4y$)y$y$jy$yAqA`T P G WIN HHHHHU$<w%.HGu~xt;wxߤȰ
r3Y]Kxff   `HB8uĀuBJu*@u
 ktgB$J E@tgB/AJ
 S70Zfb0z$ (u#QgpJ BJQB 1䅨@a SR1bNZ r. $0P@0m rPrfЊ  bH t$<+xbH+
JE$<u	f pgcHB칝1`hCBu"J Cх J g` t t  ARڳrȀ $@$zчЋaU$`<`u`u uR
 Z- ' 2
JJr.JПAZ10@ρ r@OMTB B |ԧTR0ᱰw r"5u<۰PqԮ];u1p<t) u0JХ J"8t	2 ЭhÝp J#?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ ?_  ?_	 

?_ ?_ !?"_#$ %&'(*?+_,- ./013?4_56 789:<?=_>? @ABCE?F_GH IJKLN?O_PQ RSTUW?X_YZ [\]^`?a_bc defgi?j_kl mnopr?s_tu vwxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ ǿ?_ п?_ ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CD EFGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_꒕ -RQ	 o 

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs?t_uvwxyvz
Compaq BIOScope
  - Skipping POST breakpoint
szB pz+~pzM~pz7~pzX~rzQi  2h  > ~$@b!@%@)Ԅ-Ԅ1 @12Q ᅡbR /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯDBEXEPTN˰DBWAITCMRDCPUREG(6RDDBGPrSCTRP^MEMBUF) CMRSPIOPORT5AISPTEXTˆ/INSTCODEI*SMM!GŀdESETARG˦/ UMEsWR+WR,Q#/1RQ#AWR) Ds/˿WR)Ԋ @T T  ! !EOP
 / Oo/ Oo/ Oo / Oo	/
 Oo
/ Oo/Oo !˫#m#ϳ$4%  "#$  rpˌȎ؎  F߯.UfP.>A uWP.)G f3.U.H`,I`,O`,M`,N`,E`,B`,C`,.. ,..AXfX *fSRkP.Bug01)u_`*+tT.T$03t?$.040脨r'`*UE*`*Dp204r	)`1X
Zf[`001M01N09PS tatCu?`*L*7hŧv t-u$ظP hv;hs=)Lp:r S6uE[X`*Cp2'Pa5
.-> t
)0A VXPs Xr$$
0
/=
q>)1 roE`C_x 2G G hP~; Hs=CruX HrTh7;fP f"wqJC>
 f.|`0VQ6'?1A60R Y^PSQfR_V`*U*(&\f&Tf	 ^fZY[XðS3ێϹ  Vp@s H ˜W0 SXX#YUXYX	Y @B32uT6W`*B,`* u.>B.P_u.8_t.9_R@g JP艁GG }ay}rangac\aXQaM}FaB;a	70a,%a
!}aaa
 f`(* >(6.> ,6f.R6D.VffXmAmZ Пf ?buf.R>r>^)1Q1QqZۀ 3Pqr#svPsȪszPss~Ps!f%#6 .,.>>66@lsv6. vffaJ fpO!f%$uc0R1f{-&f 0 &yP
_.QXPmqfZ$zVs`*Bsf%'f
 y+`*^	.Q~w

z.|t}u..G`,s >s^ tbDB8S+.&Z5JxU .Gu
`*e?~u)`*EKp2!)`*B	) .c!h"T~
fWz.6V.6Iwf@mR|Kf }6Of3ffS'ArMotA6 fuD>Q
6ˇd 01Tt	6݇U  } 4tY=o.V0vg&;pRsZ^pu VVW>ˆ蓭b& _^VVWr>r6> _^V'ɯ s0fSfVfW)>64rt 3ҋ f|ݠG 
t O
?tw= ?  68)< 	s0B>uf_fVfY83נA :r<+u<-uPR+ZVR-aQȵ$0<:|uYX@Ju @ l>@> U@vu@V
lrS- w|Hro1PO
8rK}?rDer)ߋW.9u$% r$QqSVWލwP <r:D9Gu-D
9G
0u"ZLqt.Ws
F_^VRVր? t u
?3^VaWU3и<r<
t
<
t	:tuEF]_rs r r
ê<fw<ar,W<Fw<A7ÿ<9w<00 L0QѠf33w-.-6/mё)9/'"p2Yc0.0Ӳ>ޢm
OֺxӋ6t>|.s<u= Q> <u 鿅 <u0hro).> PmPmDQBҠ w?>dۨ؀ `*s!?^03B>B蛓FڤSQTpg&CX裤W )}q鷨J L6Mr, 馜fNfOf_Ag&?2fffXPt á#?TBPme2f.;ew-  r%Q1ਐ tfGɷJ>8 r,vf2BrmAVXTT)@ r ,fffFgf#K .䱃@{S2T~3?aM`t
`,ߠ ,ffV&vPmx@Qv"  u߸ $t.$撱 Q fU.E.9߂..F.:wGP;A5ŋf , tR5 uuufPm=R#f]Ѩ9@Po:w;5.=[ ! f4R RQ 
	`_Z Z\$S
Ｐf  X Z0Sf3[ffÊ$  ffff 1%0$`%߻Ӧ R&%   $ff8*** Please restart the system manually.
 xL.<t$
@..
$!/t/_$0!/t/?DH2撍6mR3PI8>Ko wQѠ ػ7f?{tuCkP O ntJfq<4T WFOPAtOPX >~ XTY*\~YfPQU T9GPF >J~us
, 6=A> > POXpV]Uf ]ayyŀ8Gbؾff&f&J!KG>̀ fG`GQa ATIIPJ6LMfWf>҈!_f!QQQQff4ss4ttf~}VP6ҧfasPVAVrAVؠ0h"3PhXX[ÕXڥ/<\$<sYr.r@O C]CAp?6t_r@Xπ`?`UAIJfQBEn}S  gf +u}
' u d[P}p&r/ c@CXra Jg=)xxPe14l 8lmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo  /Oo	 /
Oo
 /Oo /Oo !"$ /%O&o'()*+- /.O/o012346 /7O8o9:;<=? /@OAoBCDEFH /IOJoKLMNOQ /ROSoTUVWXZ /[O\o]^_`ac /dOeofghijl /mOnoopqrsu /vOwoxyz{|~ /Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&') /*O+o,-./02 /3O4o56789; /<O=o>?@ABD /EOFoGHIJKM /NOOoPQRSTV /WOXoYZ[\]_ /`Oaobcdefh /iOjoklmnoq /rOsotuvwxz /{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo /Oo  ?_ 
?_
?_??? fRfVfWfU..f.6. + f. 's 6э>us.a +C..+.> uj.^q:
qf.f=   sIqOq r.q
 .+"s q6 ptP#+#`$+pĐ Pf. "f.f]f_f^fZPSQ 3<dr<gw,d P$<&Xu
 $	,<w .	.p)N.Y[XQ<uF$<t
.? t#;OtYQRWSVw*t^w.;t
|u. >
эf3EG..fEfGpЈE
G
.f$ r-/t8  99- 9.Ѐ tZ8=9? :@;P:?XthP[G_ZYrepe  `>n>VW>S; t6Ss?1@CsQ?r$?s6A-`B+ 15GCЃ} ;, 5C7D s# qB`C	ArvBr_^ rE<PfPǋfEEHE
EEfXSQVW3?u-6qCt6#L6QLuC_^Y[VWf6Ї
 @HF`CÆQfQfPf$FfXsRSÒ3 Eg	7WTkUfQIffD$70W?uUcT+9% si}
uFoDdW+pWZE_}t8YuS uN~T-fD7  !]6\0u]07 ^ ui!]Yus]{_ KT߀u#8
fɁYrgV1gV d/u8	1cc߾17,R0JfXf 2TQ߀Ys0cYsVctfY+5 /j7 _"kk[gkq8Or߲Wm_lieoaȋTq8s"ns\fEVVcwD1SfönmQokETf+r8sx0W7T*WTߥ:dν fD@@'4'f irfe  Y2pV~Q^ t@lsF蓟N+r]Y
~]ym3w@lD tsM| /u
!9z897<a\!5|6^<uhs
`\ f!7s1kq8sk8!~Nnj	xj95bP:5i3wj+fTaB{s
qrD1pJg-kd
*fc.`vX~Q!}B'?t@R{f%{s@l"⋰Oj嘭@lq8wAsW-q+@lw~oscT8p\5?VF`^k5`K95FF<^jdR{w!mnlAWjPХ8VYpsVr4s7Ar\BnХ蚐f!E~F^Ë tttk%:5n7sdu1n`o¬p qrsTT%=upWqh-Vf$&?	!(=(tLQ	
v+`=urn2$n0yrSFtQhٻ0<t`1 (ұrn@k@l+1| 7u Øn3|}3k,Cm|`o1iVq$fedwOcDjSFjd8kn45>2cT0SG iAy!|sdgw@?G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsicdi0phrTeFbgOCf_2J0#escsssdsfsgsfWP DVaX
<P ݰ: tͫA:ArAⳔ`D覔A♔ A4  + *2+*4+*8+f5k-JYsMɟȁpuJføtsPørc@d
t?oslc#fE~{tЎ1 `J!%߰[B
۽@lK!߰]rBW!p2P!Fb_x+si dpp1B  }߃߉ߏߘߛߞ_ ucQ s0cE
WV6g4Fg^_rg tUY	P!!s
P! !M
fwo/rd d" q" " tbyte %*/r ptr c #WV.3t"h6@:hs6J,6K&Ys#[O0VBOO_f^f >eS fXPXP
$0<9~F[!J!JhD
 s봰+ !J$ CqYsp8e+s߰-шsf    Pr Pr  ޳ ;  r_   . `rx   $pr ' ]3( ,T/ 0 4T7 ^8 <!T? 	!x @ 
 H $P$X$x ` Wa 'b  f@r c &@r h ( i +}0 l 0!1(m 5,n 9,o ?,p Dwג+q G.wr K.s N.wt R.u U.wv Y.w ].wx `.y c.wz g.{ j.w| n.} q.w~ u. y.8&8ǀ:0:;66;: 6;=(:06;?8:  |}U.  B  ! PC: C  Q)8vے+ !F  r !   H ' ݪK H ݴ.# PCٵPCנN  Urw O AT O O O H H H H n! PCxLM?8 q)pXXXnX  X([8[  ROp]I E  ^8PC.ȿ /1( ]ːaI #rcb+{ 'E^ ,KW 1A^ :УX:SYfZfZfc[f\f\ 7eݒ+ ;Uk ?C^& D. Kn Qn Vn  [w ^p IIN  bDrrIr4pVp`quu WfE^ kE^w qE^ vE^w zC^8Ab`py~yvz vz(+z0vz8sz $E^ E^ E^ E^ E^ y`$z|8fܓ b}8(bՄ03FzM  ׶ 3`,?	 0Nщ ^1   A^1w 'č	 %e@+ T1Rҋ uҋ  ֥ ڹ*1 ݕ ᕔ 啔@w 2A 8UwB ?UC EUwD LUE RUwF YUG `UwH fUI lUwJ sUK yUwL UM UwN UO T8 o8(V0V8T@P鵍 e  Ee.@r1`/䧂0䧃0䧄$p1䧅 2䧆2I3䧈04䧉4䧊5䧋@6䧌$6䧍7䧎P8䧹 93 e1 e2 e0 d8 9ҡ {  w 	 w  w  $w * /w 5 :w @ F    Or!$  e K O8SXw ]ƻ0b g mkp u z (&g!`ᗶ䜶塶覶髶m빶쿶ƶͶҶض޶0(m
ܛm&.5߻:?ۻGLmRX^eGrklRFpsutz q8 ~݅(60684nuРq0(Tg 50vf83g(lRF8ۻ8u% (m08$fcuu8 D8$0 0V   
0{ 00{V8 dҰ8 f {s  txMUadd push pop or adc sbb and daa sub
s x
 cmps inc decb}aa bou
arpl imupnsb out q jo j%n0c@z@be ja j @jp@`l jglg test xchg mov lea ncbw cwd call waitbff KsaPl@s!s stos lKodcqbbbRb rolr rc~ cr shla@etp@enteft!o iavemd xlaoop@!#s#xza j@lwockpne%_e hlt ct ne div i'clP
tUc (i i (d dbx1zx lUf@g@sl0)hrd bsf+r btp,s\p,a,c i,x,sep!.`.p..zR./.e-@.pR.1 eQt 12b0gr*Ul*di14l14_msw l -s!4Usq4s4s5s -wver6w ffchs fab08tfx`"fld119l289e19pi9g29n~";z f2xmp9yl2x fptkan<a<re1<xtrac8sB1f>=S<pp9sqr8s0frnd!f@@|7Aucomp7en:dis:c[le<inf1 9B )fP@1esc19env19cƑ7stFGaGfreB8BB0ArG"G 5fbEiEb>>1EP@@CG12E>MfiBIaO"LaM'AL wbinv+wa@oQ`RARSzSRSR RUQRlQ DVTg!X8@puid rdmP,rdp&rdtFrsm ud2 wr!Zx1 .\ f\ y}\z`&^w{&^|&^}\&^%^.s\x\3%^3%^\}t_.\G&^%^%^{.g%^5a&^&^a&^&^,}(%^-)*\.V`)P}S\ \%p[&^X&^}a4s%^$%^<%^v%^ý\t%^5s&cxΤ\|\5syw&y'5a{t%^$%^I~{a5a5sQz&^5a|\fe{$\
{
迵z%\׋c~}<r%^<m t%^"y$v7%^&芵z){%^+t0%^-e{05s35s6wQe{9uf{;me{>5sAjDt+%^F&__JdL{%^Nt!%^P5sS<e{Vu%^Xe{[%^]` z2scHf5sie{lne{q{}vu
%^xL{d}W{޵e{w#\P&^߉O\e&ϐ\ۺ\WuuY&^\ur5s'nڗt杪~唱#tN%^8etH%^&~  6 f3 t3Vv^
j
a
SQW.8
F  1 [Fn6F?f.a
>0QHY.&f.>R[  t8svJ $GG _Y[PQ.>t7xFYX8eF N!SDr [5߰Hz QMY5 FJ2@ M)FKEQ̘R$ <t<t<uE* mfSùE' ; XEfPQfRf3 3JFfZYfXSt[_A B C D mP Q R ۂS ABCDóPO݀߁R߂S߃c?[ SpWP.@ơ.X.@ʽ u<u	L <r<w,@. <  .>
  <  <;u.À
s.p <0r$<9w ,0 P.p`ꏿ
 Y.l<?uf.[u
f.&^aR<[`Ow?uu1R8f;t'uG⠰ o._p	  i hǝv ? h=Ȇg
Ȏ`Ѝqڋh{ i
  ௎ R0 0o  Y  3     DSDTaU  COMPAQEVON800 ~@ MSFT@[0\._PR_CPU0  _CST PSB_C000@12O
?
 P y 

}  z	}

	
dA1A

\@32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 74ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdߤgD5phg	gi
 A6gA7phpip
 fp
`'ϓfg``f bC7f cufvbc@``A8A9E
Microsoft Windows !ME: Millennium Edition"s NT C@AF
v p\_OS_`p!g@a.Sagi'Q`R9
bra
q uah'
 q 6b'
 s-%[(IW`.
&2/ p
q pq A8_INI AH@B
fpig
f
 pi0 4gP4h0 rgfata
apa`(ah`ha `a u5
 bbi`ibD7ub`\[K
@C_HIDAJ	_CRSrD)
g&	p 
 `<P P =<!;
 C010>0?1t12?7?0?3>0?4py6@5
.,14t@4AD@ 016T0 E7bE8E0?9 rF! FADG  G[0?B   
,[I0?C 00?D !?8 bIECA [
LFaI20C9?@[J`:N21 ?22`023Z+AO4M5+k26Q7J00Q8Q9QA&2BZ!?5`B2CSDSESF`B30 YE ?31@3133U4U5U6 @"T7U8zU9UA  @`:3B F3CBGCH%I3D,3C_
[$ZEUMF@40\U4143M`044
!`
p2Ba}aiapa^ ^ib{ab_[׎\5:
_ADR`pW
	
[͂ ?46cH [\7e aI48

[&48,49K4A
Z
[hQhB0 @ hC034}B4BE9\D& @lmAL4E [#\FK`'50,`p`App`b04Be`e` apH dpy4CcCdcAp
{a
<bP4d`5 A5000bbtd
u@ vu2q82dcrdQ4D` dza
a!v ,Pxހfufrf }a+du`['o
r21o@53B
n
 


Gp}
H~
~rB<7
 } ''k51K|2sp[+4pB|5pibpkdrd
edq|d_ hb {bPrb

bhb@p6ԉ7ԉ8S1j,56jS2B7C57crcq+58RbN@p9vowtar(53a%b 6bB686|T17 bu7atob
bc@8ya2q`bac@`Ap
r5A{EA;>53
56s5i8s!q7^12_raaS+1юE035B	|C
f<y ߠA2
qCQ05Ep\/Dk5aha{a cA3!qCbpb1 _S3D
p4D
[A?5Fe"g60
H
[K`06N61QO6U3Q4Q5Q6Q}7Q8 Hu9`W!A E}6J6C(D
!{h
aE69`i}`ha{`hPrE (8P Fxxq70pW71Rhi< 
`}yaaNP72
hP4,6BI"C9@pI7 A6Eia{\1AN0373eA}QS70VгNqCT]FAC3qAVϼ[WL4e"g75
@I	x=&76 J77 +78 K7H b7B DCRaD!\7q\8\8aO8230U8ZV8qS86!780`:8q8A88S8D~aI8E

N&8AL8FaI90 
6bim9@ @1@`092@3
[.Π̱V9W9617181q9A1BN&9C[#\_GL_,bp
` 94
 `
 [!
dv`A`9B97k<pj1ѻp
94p?9u5S63ԑ<37rנaְ09/8by[`0ya
c}cbp[G<jDe"g9E7 []9EͰP9FKA\AUAM2`BA3AVAWUAAAaAqAAPA AC
AiP4A`a7`kAB`npbza	ۏp
aAu0rabcwc
ccpXccD
'6Ippp3`Ew
ryi`zQy`
 ant QADt  qFw

PB0	C0PPrp P} !LAB1
l
fJB2`0B3@B4`BB 
@67	e{k
^`:AF@sj B3eVQ
x41@61a}e
eKMy3@63e-@6Dep
@6Xge,B qA5~pA6< R7(ʒ 9 A5 qbbcyc
c} A2y
cqbc,A2/eK 6B1@67D{k0yp00B8hipf
j
7
 00@6EbWL!
's
Q`!
U6s
00	@6C`y!
Is
00Bb(!
ps
!Ab_	p
@9FhahV,9F3`3b"fB9efBAe;BB	
  Cb  	 
ED	E	
#  y  q+CwaQ^}`RBB` b0a"DBE0UCm1`qy	E AC2	"3 &b`	-&`v"C`#m"4Q^r
`15[I C6c
_UID DC4
 _STAr,1^^5F_DISq-_SRSpEC2%h-"A$D-*Hpe+,,.2o. 5/5O12fO3,4.36=7s=8Q28:,_<.4=AE/?#E@ 2PB,D.5ELFL_H2H`_J,K.6/M@TNTPA2BQ,oS.7TQ\?V3\W2CY,[.8\d]co_|cCD-74p
i8F2haCECF
D0j,/l1roCEo0pm.iBwD0{CEBm2mvdl8nnoOPmO46HasDp'qD4
,
vD4D5 t6
L%u6u7 :_REG3@bu)3t!D31tx`D:LD8(p
_D9
 hba
{33a}`}U2a}%lA|Ң~4c}ЖKDB5
Д3x
{`«`!35@iP @ 32$u@  DCt
,._DOS3g1
Qڀa`a[^lDebhPްDE RDC1D80<ЊGASS lphӉãA拲ŌS#E0DJŌ1ԍۑBŌhE2BPD9	Ϡ5h0'Dp
`{\/RjA}`@E=2@$E2 `,   PFјD>hip7h`ϟ9s*h\/CDh*mʣD 12<2"-E3
01q ` 6Dl`m+iE4|!Ahp!`Ā E5
^/0whijkl~~ l5F[K 3	_GPE
w	b
!g
Gb }bGf fy kE7E8lE0} EB

xECAD E`
/w(ẑE9p** iv`EAEF[Lq @@@F0 FF1 2U3ٻ456r89A] @FBCýFFE F C100  12  3456789 U A3B3C0Χ10DP  FP11111e2311p11p1111u8111A1B C_INI 11D
N
[DEvF20
w1212
G3
,53m67
 12 k129A
Unknown 
NiMH 
LiIon NBmn[>{ 0oqmE7n`u4`q`oE7  ң
$%DECG7de9aۡ:#٤a@´1
U}haj}iР!? 
qj111d`1C	' Qҡp15"ЃD	Axp
{`aa`12E
[)h`p*4`
csc
  dzi r`a[)absdb!/Vr`0: _ccCF	g}QDg
UA0ڰԀ{`gC130͈1hmC	BpFBFࡈ(1~A( q7 wq7axra
c 
dcbkpb72!8OD`fEa`a8ptd0gol mI3
+p
 K	Oip
A1bW9²3c4305 ۠Q氐{ꀘ`'{``U0p16$ټ$  92c c( eeexcpOecpci1t m6 *p
27p
!ԠcӁA8135 m(_QC03A´AP 4 `b
*p
aB
b:awQ05mWTZ_6'7['''TZk3_"K"6 ´_
;)138
)P?R_CPU0,*/1_
)2`.&7_'()P.AP 8+U#x@zb@
+w9
o5A
#P 9+6"P A ',BT:B:CT:E: `_Q10 -T 5N"1v3489OB90@81؆8_5q6,
{:AiG~:9i[O@1DEa
3EGpTPK@1F4041 E42 rQQLp
^`3F
L3 r!JFH44Q41\_GL_p42N`40 NLp431P!41 1G45P?QNjLRO6R4hi`{j`a}wkabQThib |'147`!Y
`ZY`ya
|`[naIL8A49u?[!\J@a40}E_p a
`
0`ap` (p
T_tabp^BLAyZ1]kaa
a
v% albhb
 b
vbY
KaiRg`R}6a
ackt
bg+4Ba4_4

 p `b!paQA4`^C	T_"`z`h{a qb{bbrD"`y1h}ak"` aP14E
P`{`24 iab0R7h x
` xlF	Cl7hR8p탈a"{ b"{ cabcf鄆K50 p^^~1cI5,52L47
53

Gys `15556z
{aq@5Z@B}53 @[B5!~7P _DDN
COM151596
30e" Q>Ê8y  -h0ᰠ 58xˡREEa+_DIS >g23^58py
F_SRSHrh
A7Վ  2gAK58@
aa0D

PUs0x pCAotg[M?B   
Ӱr
_ON_Ag
&_OFF 0x |PR01BIX5CQ#VC
=?' *
؋uԉfrEN`+5D>^lօ@A
6 *oS-\2ObCDrW[4C160MYQ`Tè60/[C:1J62pJ`Ƒ]63
."P!ȑRBaȠ63 f63Ǔ@H
1 Gxxx"́bx@xe͠pV͠ @>"ҟ#һ EB֯ō64Ri "y%&04N
1pM0)?l6qx"4G
Ѐ *d/DB673u6893cB'۠4/Ý6!o0qxcp
69%Qp%lrR a1Ͽ6AMY/AݍA)5,6B p\/p=C05F1Jsy(q`{&vPa]C
NdJ$K6E
~K`L7LQ @K712L73
G~ ~ Gٹ+M71

2Q]`hRyM73Z0UQNQ!73[%4uJ
  "  y!5uJ
@ @ " [qfJ
 
G@G    W*Q"6uJ
2a a Q-

Gp pr r" f8vuJ` `@_Gd d@"[I`79

" pA
W[pW727Apʃ%{7A7B&"ޑJO.R( ( JO[+     7`JADR   K7E
@[07Ev'F pINI&F80-D.81.81/0 82-	a43E1	 C0BR'W_
	K"8`-7_[S3P[Pv8- 8h:a:q:a:[!8"c189(:/;JB<HV8P'-O>9C7@/A}<EBE9E1EF_C09D0 1<-8E}E_GTM p
?M`Ɋp 1FNl90N91pC0AC^N PB@]OMo91 tPESP90
8P	90yF %M@}Nl`OhOFi  `p
w@O2>{a:`V {V` bwb
bw{c {ib /ac 1YrtYrc1Zu_0B1,UPOabP6uR[|193bcu8E:v]^!={@Y  {EDCI
~g[$@OELF v]9`R68l mp
.C0C5	
# #af6fCm7gC8?iC9jCAkCBlCC<n6TC

?R@o
 pSqBq	SqrsSq7qSq0pSq9qSq\wqtxxQf4gTpVvЀ32@	F
q}}Ld
d
Primary 
10 
LIon 
Hewlett-Packard Eo}~Travelۀ|1
 @|0m23L"2F	 0E92Fh`/`PM%
 K
R
 
X32h֡|97A"331 749K7aq9 1Q7Oa33ha`1hAP'
__UID %xq
_BI`c@LИST!33~CL\ [G3t(s6%)FuDA٘B
ACPI@
>_PSRSB`-22ˤ`B43*[9H
)o_LIDC{7D
292
	/15?@SXN^!3j"Q8fP999A௵@OBWkk`Zh`piaF?Q9Q
 a{`
 
 }a
aǴ~ap`k {pa  QBR  QAT 
98@!  q9Crehp

- 0`йrpe `¾⽱`pe(Ep}
נyj` p S>cBV1Wh)h`LC`"ib2basabcpcau`a@9Drw@ i`zC03F
@qa43b`a
1b
פ
EҌ[+F!@OFvs WDGD
PRU4<SMrJ/NAA T-MP2T덶AB ;9Kp$[?AC+|Nr2J)lBC CWQAA*qe`u
UCES
 %{A`&A<5 
@9E` 
KҌ`B
FfghiGWSABU
F&9EoipiE1FP3O`Ӱ
COMPAQ|PC Cp Spt2Reader|GEMPLUS|GPR400|PSCR|## %WQtLQ3
ABWSBC5`AQpiQ `@a?31`Aa(`20m3a46 7
a
A1 JAaA1l[#\_GL_yQU037@pj8pk9&073B\pfDhA 	l['BA1|1A2
34r
A5 Fr50h"5BU2K47/3G{h
A3p{zh@Bi140 +AD%B)C^8q 9 Aq BC|"
BD E r&D .  !BF 
BE
[EbC0@w(ATC1q.C2  RCC34R
C3Uy
	`rh``v!FC5C0 c@d!Jac
W`{rd b}yC
0@baya
a0aP Ya
  eraye
	 evepe9c ucp
dcMC6b5@@ bpbgC	bdpq apbe)e!Y e ffg
fape`pffgvdueA`b39` g4pY `Y@db pgq1aggagubdMp704qFaVBCp`cOpbA`BҲy5`p5I0!2" h#9h H
bh"W!c `r2%2cPtard%
e3BC-adft`fb R(uadcC(uc2wftd geL")`4+b 7p8 qBED@`EqM6C7 [a!BD
_INIa8B55pibhbp9pC9Z3A'jaA4B3B"6B4bF CC w
arC00D \bPb0^3`babuaaВ9"%9Pb.uaS+_CRSR0D`/9bC]`$2`t9ze}A/``!f\/9o
ypMBq1CJ`CE
G  F  y >Y)CED. 1D0mBlI51N
G. . GN NbMc c Ge ebNg g 	Gt t G bN  GppqMqNGwqMQ   	N  GTTGC>`魥16]D
L
67WoPW@6`69^^.@DL0 0_Z3B[i
p[Z4B[
Z5$]@E
\_PTSphƝ2@	e78`}` `i8E 
 OcqqQyg7F\_WAK@g_i9BeadDABokG0E9 l7!nF1iOp`q10qo0`0hh TZD3~vTZ1_
vm2@w0A
v3C os¦bzcd
zRdCaO}cbccc7yI8QwiD809ApBN\!v`D4G,<
bn6

׈7
a6na0m5R D62FD7`K0J8
PЄB#?#FDEW[0JFE01``36a 37
An8E2
qCE1#
~1EߘFiipQ8K3

p
p9
{>2RiA`HE4
2uh`Eq~`_pi`9~_rwrϧC=ip	!_v`BBpE5 awhAE0ip%Pq&6i ` a6^f_8
ifyO2{pKQ8mD`D3/36!pp
  Y`!36t
axa/

`b8`9C

bd" "

@Do
	q
#!
/cL7	F ud`pÙdїp{30'{b
 t bbwb

araѼMpLa_nvo1n~2B2Вo:)a`͠BEh `QQF#B Բ*fy
hI	37b  ap)h' a[`%  $1`DD<DaCޱ#ޠǾ8`hv3_
ـb`372ME8
|h `t`м`x`ff
p{tfʑf tcbbcb&ʰ`bbFiu
ep_
d
d0d?qeiyw0wQ6	2ʁa{a[@E9T H@r
_ON_3FQp
uA
I\u
B
Iu
ụC
Iu
~[3D2vvJK _PR0Y`0n"E-8AF-EVBFgJ8C[Hw_A9Lt0EAL1PAL2	AL3F0_ACQ0DP 21U7426430PSV0SLgPR_CPU0GЮF10_mCi(2"56pQuDY1p
$@YaY8_TSP
mdpC1QTCp HTTMP1E@B[G
w [3F3*r,B / 
J!&"3"[
$&!BG'\_GPE_L02ЃXyB.3X.B xM{1
[w9{bD
ji9`4`d47 .9V.e/ .AуVZ0EL15ρ
["Y4C0X04"5B8B``6`>pݖjp.Po>?5K_L21j1AF
	pB`~GII0a1{`
PaKKQvDK`PsL L@va6Pp7P"LaสvrRRxSSDT3  COMPAQCPQGysr   MSFTPUN@) 4`
   AYy= X  FY#5WXDYzY\#a_PDC{h03F6_PCT 
Q^ްF5`4&_PPCR04CpS `_SSU`NpcaSpcdO  Offf?ghijk nmp?psrs_uuOwxz_z?}} Aee| ߇?_ߌ ߐ_?   x  R     U<ps   d$ $PnPqo  p
Copyright (C) 1997-2000  Intel Corporation
 Base-Code, PXE-2.1 (build 082j) $I $BC$+   @:^   
t2ôu3cUf`F  fa] j j
j
PS^< t	2PC[X] 0
$0<9vP ePFP!ӶfPf>fP@f%ij:64SQ0
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlV@Vv C ^@^~p!˷!]0Uf^]2 thP~SwQpRibWZT1
-AX- -B)C)D"*S)ES-:-DI)S+SP-ÜPh)tX
Waiting...   t^

h 0@ 3SfQfRfVv&  &\f?UNDIt?h_2 o
EC4: 3 ROM ID structure was not found. Gs<h{kA4 '45o56is invali7Pj Sj < uf. fGf;sf=_ f3>>=T?>  f
@ &6 +&AfRSfP& fQ3ffJtuہ 3fX[fZNа0CW.;@=s.@=@A6&BԋfP1WfU_j j fIR@RVQ@A&Bv &D6ELPLLPLLPLL
PL
~p=FfP?ЉVE>Ny>N6U?yQWhTw
˃f6UfVQTT
Z cK tl tc" tZKW tQW tHh]Rjh*4099nexpected9loader error.  Status ==  P420: BIOS extend[memory c\469dri=v`\imagK;48: !?6S7;ac segment`ZNV+def.>  u=,$K ݕ43^CO:i;f0G=fp=^f. sLh\PCm  rm^_  AyHr]0r pqqtr*rv&D &L. &;D&s&D&N{@T{BN{H{Pu|J|R&D <Vp<&(Dv
V2}|~=	KLNWj 1z\pU
U  ujvL t  uj@BH FF  R{Xt&t1uf
G HF+F)F[?fSVWB  6	p=q|IfoT     fp_^f[ T^pUf]f_f[fXQ? t83ABgf` |0DPDJt u]D3AA2< f^fZf fXt ]˜= t.. ﾭށ.Гs	N]&}t	џt+{f&} us`.9wf&+f&;EsPMfXRӠwP~=  o
 s@Xr`&f.+| &uf@
Af]r.>pu	. 	PIp<.( s%
1P<Xt/-Press <Esc> to abort&nin0.;zR.1RfW ߀>  $u> PuAMu	> Gu[fZ? qa<V<f>/f . 1. . 20<t8hquZaOpanrequiP DDIM sup gf`  ˂._UzfU fRjfj =@f~ <hfQTRFfu0h;|p{
I; PMM fun}cnumbe`  u)hqE4@al'locR`0I@Pf硩Crgfgffߋf_p.A<h .tf.>@ r
{P  blksize t?_ҁU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j p | !LIENT MAC ADDR:  h     GUID{: DHCP <XEClig:Arch:@00:3#0bs $I5P SKePROXYc
GATEWA MD  BDӰ
Auto-selp[:
 aBOOT ?SERVER)b-->  MTFTP`T l AAed`roxyser?vice d !7replyest ! 4011.  s0`u!7re a@gc6aer MissP. d` addQ BIS bad g`ichecksum  get sign0]1;nfor=mfailfree%vAbo07objp[ authorDS  flagshutdowۮ|b/credg ;integrit `NetworkScancd byo key iok ARP timeoutopenzE\ - F s N57[AccaViolb rece bdomy xunkn3opgre0x!7connp[ix Nopoffers we6e0! pd"!@bf nam7! \:APIm إ֮`ICP7r multicastwhA֮!th"+ _,y-PHYk.-pfigu=rData0-	a'e'EE@MW .setyt!
rrup$too many_ packbs;R+b Media t1`i,cable NBPb;bi-op&q*bas B0+disc1o0bli0,B+CeBQdgu oand/mpq*F Cbt's ]1!Pinb-Lm`bg.@  /-\p
SM/DMICuuiedVP_UP_	T$
`}
p~ u@ːV u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- rZ뾐:: 1LP3 @Z fv?FFW)~!!_o]'Ґb``[b`-^u
hx9@i[FPX`btYacI[b`[`mob```A``=g?	3=1 tw5pZ= }.f   lOm$=q )w-2 tHt-= 7-s HHp!?3pcCV9  >9 t!W JLff99f2uhP99@t{<Ibtyqw^h
JbShRFP }R^PxRF9*9Fr䡸93Mbqwn>YuYb"޳d1J{NMqIH0_ t0_tEVjOhR@^sFP)b9Fu9R 9뮐Cs>\u>p\tsII{L ZrPV`s9^P  VYYpZ+Ҋ*QFVFP+$FVu3^Ã>t3و(3*3(wh2pva E/ Z	u(37f(3@f0{sEy WN뜐WT3]]h96:6P636H3 |3O8tְE뽐X2u}$% pҀĀ FVfF}GFf+pv晋FoV`7u]]f6(K
b	" 9U!cbWFPV^f Xa޸PVr$=NVu^F^pG(X]^p  !G-- vs&iGNЉ^& u*&G!V=0 u6&G"G#7&ХrO  !UqrusSG\ssG|F9 Gf9  fP2 ~UHVm@V\PVKU!S*& P!&(G"G0FFPFF"9G6NfNfQhHT7Ubҷ:T^*&O;~S*\P
u3 @ẋ#G$P@ t
P(G	\"G{(pwY!V;?.3u0V  t&}}?X/OdEb`tV RPV`t
Ȍ 3& _2),bQ\R3*?E3:s!VAơpf1T|1^! -tHHu9ㄸ5B^ѧs1X/dC" GP)ڎbڒ`ڐ٫ ٘ۚۜu ʆܗ `3#¢b& t  ߱ Ood?t6QEЏS3n*^25Cu#."ǰ$=3 =2 =}cse-6 t[KEu(]B4  C\t'۸̳B@P3/LsPyN~ tI4p$fQ 9dtv¡^
~QQ
@G &W26@sޣЮF+$mIfjFPvG*F $KI~ t
! FËFFt#aXPtfאf		 	Q	

~䰃s2pF}
$ 	HZ	PF
x~E^F
%$WqÁTPt% )-GIR&x$G&E

Z D.'B FP|E tL @+;Vr
w;FvF*F3h3HE^K%"QRt PtPtFyڢ0ﾭ Xpy	F	PD
ޱF~ ts(A'u6q WV2!3 2^_2&s( CP:t7H⸀22fftrHuVHu0Hu?`c2:!VRPEK?0]a` V汏HtBrazBVSRPVW tDt@u2^c+v
rD7D0 N& NGP2G  F8F`4 ht3 Kt3Ro3u3zvYY
 Kf2fx3 tL|p!cSc> tG;aHt[-pFIZtJ-
 tE~3 PQ 5FsTF"R1pqR{tZc`S\|p^f3PU~Wu!sT2TT|"XP `YdT7FSvTsTTTUTTTTU
TTTTUT+T6T<TUCTTTTUTTTTF*F ^PIsT9] 젚V 2V -
 t^ ґTFu{>4oh"(CcG			th&C0	Ch. Cf>	 t.sTab FƱAqNAI[u(XcZA([asT]]GOFJ⺐[sTq^^p]1_]	!&@i|ẑ}d twh6*HtPǺ
  /tFA łR{ `YdT~rcF&dToGF>t'^wFzF}>T-GZf% !]IjzM`3}z@UF!^33Hcz&PF[39F|5sTTQ.@f OR. Qf0O蟊88QLh: C$,h:QLGÞPV3H BFA0v`XG< X~߆  o@1:DHLP`5ITX\`rhs_h:uc~
d=PV)= wA.JNl=!Wk-PV&U5D- t-;PV^- t@9vOJQٙ=4PVC^ HtzpNW -PV ?FvOvGzpd?Ìrԏ&Wwx;ȼ&t9G];$$:	r"ZG$hX	 D@D3DߊF* c`ؼ W
ZSб|D<~Ij[~,,D<@C,&?_*b`|&_~-5PV{U-	t- t:ݳ X tq$ u&  u
"?tSO&9Guf& Pu  t؍G{
M*Ä WADDvvv7Vj
 &fXfYffff88 9 7:卧FjPEPe+9hB9ix 0Q1VB	RPAT
ix &nF}sap 2 F=zPx 7u~ t	ƴQ3Q4l4p032'rȎ  ǆr D%މ77ߖ 8Q8**9RȧtS@F t^:uf~tw9GluutApu@q$@1іtr8PfP

21
Qx&KO6Po 7Q7o)9- Dt-guRJt)@F utpuoh)?t֣Ȍ@Y}Pi
PʵO)
@ 뎐.^óAy
3FP`0c$0c3%@. FBDivvt u-FF9F")u32} "
"vN)u{rPV;u2.q?}.iv"t3"!=b=P""phaP%!$"$-%e "#u$)R*&j&?hyd0S{'9&X+5,f#t4d't"u!Hᮇï> zH)l =iFpP1<&̀Xі'` >2	 9;4<`P3<
]߄_*=\0^ >UUHtHti@ < 3(=kR&V>"sĘ3Fh92 蟸;p3퐧K;f!Y 4Wt-MFYWG01oHI3iF$4GPGN`G6xS4I2tB $8;Qo
&$<:D cUF20NZR/XIK2AEV93^Qd'SJ1;~ t3
jU P9^D#1k}aF3򏠔;3	wt1n u
 C Dao~ 7rAprFP`^ V Cu~3*=*qFQ2J  SRPWQ%o*/n0=0Q0޿P!BktJ@\KVpBO0F/8}C}ϣiv ~ĘT$v F~|9G  jO#N; ~ tawWR1PP1N ~fP0G&WI9FVP4ss`c9Аu9ust[~o tH׋F-bovi~ ~á柋؎Fe0RPs=;\u>3t
F} _s	-B`PpV6hbߐ`nѐ21f>&f ]f9thxސ袐h蕓0 9 t@3f1ƹ +uhc0 R09Pa@0 
rh/?0^`l
lfo|
f ءP@{:coh:K߰[6?DmdF 5ߊ 9F~a !uxa !ka !^Q
a 0La ?  0}/^ۋ F~AP0aGg]Ӡn\`ZuQ `PuԭRRpS F9v~!kuH޶ U u1"h+\ tGut1ee=s>t>\rDӭ̐aĹBÐfvK w42
30cǂ ѻ}QaD tP&_GtF,Q@ 8h!%tFlQ (D| ul t!P|~2
GlDp uTRpDxȕxD@րА4nt--ŐEz k*302
f&)f0FFtq҃~ t^%{ 0왣99	 t
^ݴ!u4ru:	0^\4:FFu	W63ļQ| g	*!+4*6JFuH!^3H!n uנ9,3k3 c3߀	 t^Qu
״33? 0ǋVR 0 `> w$ѻV;лA^QA[t}O
f6 A1!VP G)G1Hef&ğ	Jz)`v1t=@p_u&л!3cz
CT f+F^᎟
&F>0^NF#!	9FsA^?	&9u0 	 !u$qŋGR&GPt Patw T'qLpƲP tu t~ t]zq_Tm/hw)
*C (лpU0&F
(Bpz Z yhfv.pq4)(o/&o	
M	u^2sIb(F`VB(vf&0b!l@vf`~^NvVFn
fa
@͊ A  h&$zѳh^V6  u 	2Bd t^ u tfX u	  9 $uy$T u
vs#)@6F**  vD*+ OwrC*@$XPH XQs$h-tF.uw)Q&e.hvz=A*GX`ZF0f		 &C*Xv&ߊ@* F5;Fw57~M$\ P%`(ut)`Q tC*\QrݠR
RNā3\`^4R
4
)
>*?۞6R
;7^C*`&8gP0\%3Ľ5A;v
@6w%FrBDqs
hupZ@?Ht'&+h%\)%qG[iN?Ex)i3+];%Vp*%ȜoN1FrB%}B
%*2hIsPC{6 $ptC7H8uC@@uИ`$ ϐǆ0zITfǆl @ Ɔh$2	&uY Z@X@Jn$DO%= Btw3-`
-,u@,qIW  Wt#)vz- [t- 
tQ`Ğ&8t&0aY
uZ0@)h#ǆ1WEdv}16#d׃`FB#ZrY ZG%
h td @e"8kQSe @fp9ed B*#pR
9FrF
Y$*+ BvߎfPfߥ^@hXfhp 0{VoV3Q#s 
6fPfh  pu})vzz`+0t- P9w3  d#=.t = t \-tv])0# tNAjfhtVuI1k_vxxxGzUPaq=KF{vp=k'0pHS-	t-
-p= K-w- 9t-
t- _Mt- t0tυ0V>u$ {>Ts9 h9>
 tFu&^@ {^f"24@B@=9t3 p2~Sވv3 Tv&8 u f@octeF t  F9PEuE>~A? ~40v3  ;$&%@A`~ t?f( !5  t@J࠲c^@0pa"
'@' 9ǻN J ڡ_63L3z`v'Pt	t(>PM!ht_3h92A98 .bL3 z pjpP ff92uvf u:9u1ʀ&&;w龱 0 f9ӯ&:qtCu|J"u?9󥑥gL30=2 2 >J3D߄FN3 &`toHHt	H_Z(Qu"hdFhlppopݸ; \Џu< Ou	= ` 6dR4 PDxp
 !$N3? 	>"E%+Ht
3gtE9%-  =9`p~L~~ ?? k?œ>2 u09P@&:?h2 >#`{u_u/Ss_YvOt*5<)"uZ=t9ъFf=Ep veR`M !:Y?(3*3oƀyNevڃr1 `p}vi/-#+!v9lSʣv 9A|Y$#&3Σv9l#PQv9!>PM\₩wpp!>4{4$ |!ړQO%
tf[DtЮ:/y	29 3t\6iBuBL35 ir9f뻁> paʫ!r-"E>}2ʇ0S1ӕP3q@2 1k*䊇N tA~u0@2
p:`pvn+2@fj
 f@XfYffffF~nFwF^)FX9Fv	FF;Fs"?m~#v@#F0f+fpPO63H3btyR` :? tH9M}b  qҋF
`3:a`_  O8r E`Ю9f" f0fWFp&HHHFx32N =@3-6.@y|p`~N"%r!!FP(}$N9!Cs%xbAs%9"*18?R  kX ffxHj`yqnڙډN^"wFV;r
w;v:!O6b7& ,@+؋FV@ !35+s4K}t&3~ 
qR6:!tJFV43? ;FfПf E9FK=!>Bp>n]$;FC
/TC@$2E
3!!UVVv0$a=  t)ArZw <Ar<Zw FC:t^P  `O ȠVfpS*Nɯ-0^t 0r 9v "U  WVB
0QRNuwRXRXWA
VLSHT3^_4U7V[Pֺ=~puAtF0SRV
0`FUS"@"Uhp38hV3c,V3X3p+YJZ3@03\3`3Pa_3bbr΀	   l3PAn3 Ipp!h90㒾99po39h9Qik9Al`9%vl2r0Ejd3Fkh3@l Zpgpfff^ˍX3
 bf@eBku	W3 &?r"uwh83  `Hu!,{0V zFV
22##2&w#2#62;u5;+u1{/|P}xx!;Sav%YNu Z3ΨI$@Aq&t"t-}f ,Br  cpf&qro
sadFavV 	b
-   BF ^@i_ 蹙4 F=+F;FwBpn+VM ⏝@'1w	cV0 'FFf>6 tKa;8rBw;6v:>P'F
?+ۑ86 68 
0@&c~t	F~drKВú> u22u r!s;Fu$<ut
f>   upM% Ht P{`S69F}8Nl$`~ t*fۡp&^&G&t0&9&9WF?%  F0wu9FP-utլ r !ᘃ~ ӀkRk9ql9q@m99~ u-"m@ _=t1an]
P' t7pԉF^(Яt#9FR9F?Wq Yb#x	` 'ҵ BѵuF9Fn!nF;F@A`APި9w
F=9FO+9<7!cn[	R? v@!'Ɩ̮x@A
=6~vk^9u9ukFP!U=qOYAs
 uh0h_? yC0ӟƇO Lh9c o9`9`}
90h9
 fPݢS3&R39ݢ`29~@/9@j4kG@}9G
Pϙ`U	FUp::"ԝ!kFK2s3׶{k9U]	 2>Yߝ@$f
Y= u^ 2zE c
= @
u`
 ufx9u5cƜaڑ  {ߓcޠp+Rfq@@/! Sbp=  qȽQg`Ӥc`h:aĚ3M099h.:  [΀tOÁ! @b m  j@ 3`hpҍFPj9&_׃ wUKGthQQQFu6~Ku+~Tu%~ u@a :~Bu~Pu
 A
pBtްE8?Qz   ǆ~^`x.~p,p F5B!aSQ @@r  ;؋sY[`
0KFΰ0Fػl֣R@i{lң97F4KPUbPUaґ(`hFFV=6SFF＃~F - FFF@A<ċFFFFPMF&uFQRQ0 c߉FF KF$"h~VF$byFPơ%
\(QQ .&NXf* PWQRU> @ c> j>]a us>@ ul>L |i<b<w[>* L &D F +ȋѽ  ( B ?V6H ^;s# ;3<7ԡ( ]ZY_ÐB ~W::_f`.9>9tJ.B:0 c.;;0At9а r   fa.>*N t&.(N! 9r & ӄt"QfL(N u8Pwh3Ɏظ O&.(N&G.*N[i Y YSQ3ێËȋ^$OtFPQPhfPQt~ Y[ Gf.(NI f.`O BPQRTvMM˃ӈ N  .,NNX tZYXYZ./",N[
Z\V3߭`^]t`
  aP5aYŐ#a `t2aaW`b  _^]Q  2sYÀ>[
 u[
PZ
GXw!
PX
j5?T
V
j
X
 _   > nuV+T
mĉVfTm
sfpf  brpmn+9Vwrw1)jsm댐Ҁ>
 tZF ȓ@xhl* %ڋ[^U9pO3zP m yyNAhUQpPVCw7$
F 8Ft)F ~ twPP$~$* g^
+@2oҊF 
B}Ra$Tah?	-t-,tc
PWuV䳚1N߆ ^U~&&Q#2#222##;u;u3FsްUf9 u"99t"; u;`uo^_BvVR큊;Ftiu79L24"99`t4hPt͡u" `fSfQfR?f``f;sf;wf;rvОs@fZfYf[] SQrPP Y[ PS [b`@2Ft%&?	u
h*/FAk0 $  P/ : .I'jqa*䁤׃b+ l0>q`pa&GfԮ\ԮR 
ԮCԮ9*Ԯ ۔Ԯ	
䔲
ДAu 2Ru	s22Zhû5PRFZXPRZXvP
0d F.N`60)v2GÀpB6+^BF+2`6 @tHH  \^
~@t\
f`
fd
-DYk%0d
 @hptd
37d
+p~p2f
9uof>`|i4 =ȡh
`6f`
fj
+j
l
f6j
2+p 
d
)땫R ~ Ã>  p`Ƒ|!/~unV+ɉNFu3^f&pwwsW	&O
N`0FF@&9wvahV `6!9GtSQ
u.VvYpthn
V	p*n

Ѓ
P0rbÌw VfW4ˋf TV0 +N uf3lf3 VfƉFfFfF /-lVVvap^^~7320>f_f^]2OfCORPfEDOMf - 11'f1ufuf=23AIt
f=46AIp@Z !^_O`D ?tFqQsnq.V
QFtSFF&nP*S#~ ~N	 xaـ}N1V㑲kWVg~cWVF
tyWxys}>F&%G<ar<zw, arzw :wrg p-0`Sp0lGGWwGg
oF GFGWFGOG2Cuԉ[3![[2ҹ G;tqwGg
ogwww_ϒ3FpV*&'* û@ &l &n f%`Pf@S`#f#f#f#f#f#f#fXS  & [Ìq`WVsS3 lP6}G@ڃ ,V lR&&
V`6N@23a@+p8)P)V1{upf
.r;Vwr;FvN3ҖOu؃ [^_aN
@)u	*aS)f
)yRk$0~<9vFPSW ۋSR3.:uJGuZRƀt%@u0t
O t hr< u	ZXCu33_[ö΀Z^_SM_h^v_DMIw_ ;0P;}^a$PnP=@^M_SYSID_Pv tE'od@@S>NtPt䤊!D+t۲  `EFGI?J_KL MNOPR?S_TU VWXY[?\_]^ _`abd?e_fg hijkm?n_op qrstv?w_xy z{|}     {     UX(l   @ ` d$ UNDI  N MdPCIR$I E      ?X b S$PnP ]ԁo!
Broadcom NetXtreme Ethernet Boot Agent v6.2.11Copyright (C) 2000-
3 Corporation	199710 IntelAll R
s reserved.
   PXE-	 (build 082)h	Remote Progroam L erf	wMBAf	 Sl 0')Pps Ctrl-S to Ernfigus Menu ..  
t2ôu3Uf`F  fa] j j
ܿj
!PS^< t	2PC[X] !$0<9vPp##_P%%FPuq'%fPf@'fP!)fu#(j:6)*SQ^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlV1Vv13v@22^1^~34]0Uf^]2 t`h+  dh+ !VP@ ء .;uXuX.6>| . <^SQW  :_Y[QSH .> t"?u.uXH S2.{r*= eu 4= fB  `BgB0  .9u
 :>l :pEtIu[YPF??Fu DFG  B!WSR..>f&=u#&uFPj`hfJ
˃Ŀ u D  S3=_Su}M_u22]r"[Cu[V[}#|OfSf]S_fS.= t#It2EQuQGGRG؀}|_E$tCBZ[_]0V?ԀG- 1h  fPh @XO@X"{p@X%tCXm@X f#Y_SQfRWVsVf.> t.@   ځ>  Utt r rD] h1
PH ?X%
EC1: Base-code ROM ID structure was nfound.   PQr댊  t	|Sfj j H"k>  t;sfpJBC$uErPj Wg!h뛯ێE]]>h RJiǰ`  .]6I6nnnj Ph#J}
0LZpLt'hDRH3a+XC_() ==    rpSho%M0F: Exiting1cP6 X^_fZY[tVfX1k, ~z. f"{0{sVt"{{B}pf
:&6 +&@fRSfP& f03ffJtuہ 3fX[fsZWЀ.z{:6&`ԋ~(SfWfUj j ggRV{캐:&`.6E.{q.q.q.eq
"{ {0Q{F|(V|FV}F6Usp{IW0qf6U_fV@1qpLk	 t	 t`Ƞ]
p`WPOa20bIOS extended m ry c 
 error.b6:driv image is ?invaliea8: !qwcd@<bsegm0	7;9:NV+ߛ\] uXP] u
h
If @}ӎF.3 wF"v Ԥ5Ria3bC?c)f^f" sDh,P?xe/  AHsR#0trvf&D FO&D@1@BU@H@PJR&DjVg&(DovB"	ǃ/OcWj 0&\@q
Q\ f3fp  
Wh86 u96} t2 :L ` N b 6EP6]
 6u]fS˶R(rf	fXfZ  Y0I!jUuJ q$!8uv ˃uj@PH F FRuvXtutf"G HF +F )F[fSVWFr  6Se qPfTpm 0  f؝_^f[^@q?f]f_f[yY8~Tf@ M  ЁJt u`~@tV%d%{fqfPNˀ?א0	= t.. oﾭށ.s	IN]&}t	Qt+{f&} us(.pm9wf&+f&;EsfXRSw`=  
 s@r(&/f.+!uf@؁If]k3e_fP] tfXDt0~1F޳, \^{PG3. 󿫎G3 0֐Eap_ pvP]0  u	r apRgѴ.w 1%_s
r  J _:espCup~&<t.;60 rr ºXr~6< upwG&D
p  &sL@&@U " G1(*Q0@82:@Xʺرt V,r{P	˒	G 
 
*.ܒT
 *2$
=	@p?pS yf[]3fZ>tOfX20G
W~PQhf8.f8hp~ ` 9f}` !f~U8$!!Hd !`  1.؁±7/fpof8u ff# Hp%EC f0
r!fqu)*.	Itff!u f -)~R,pf  ~.0q~11 n /.pD00Ub211 |W11G1 ]0@A1E11 6`ff9!9fP0%ps&%Рq!G!W1z W	P۸ Q!&!  V@" H G#$!}SA!<Q23!fZ@1C@ oBu$!SF D3ES踿 rR[ I !&1EFA&}@" &f n@"&LMfn._  [;!V swfLHKU&LqMM7UN NVA&zV@Qf Ma= f'DVPT ufdf?Iu0;xWEV3  CEeR (Q xAM\WAX08t/f<DF[@J^G Bʆ\3A.@ S]H^W9fSx	fOc d/7d|e0f/qd3|-p V%<D=ݾpRB0>:?F6LIR@/u0/&dNi/FMOL@kdOUR, fItP^á/`Y%ttu@S  fP x @ֶV2P9fsb &czuU t!@ J pۊl }:~t7 fXw+  R``f
@݀úfffZeP#fXтSQ~~8tYOPVPLDr:?f;taYZr`XPH X3. .P #.Ao.pPֿ	Pfj .( SXf% L[A;m  l]Broadcom NetXtreme Ethernet Bo@AgP v6.2.11
Cright (C) 2000-3 6Corporation
All rs reserve MBA0nfigu Menu   <Esc>BCtrl-F6QLeft/R<Up/DownF4}> QuitBlink LEDsChange ValueFieldSave Th`opB`nselectableA  ӣߦ?_Protocol `e}bExecuBEnvironma()   R@teagram LP (RPL) strapf (BOOTP >SBv    OdjS"Type  Au?to DetBS(Ip18hI9z8x    Hide SetuRmpt  Dis@En  $>e wheqdisplayed during ROM initializo 02&Key&!ok"S@"B  k@s in-v@ tcʗ_u xƉ1BannMessaT_imeou`10Q  2   345678910ϗ|g  Non4  *7DQ^kxxd    LSpeedӸNegF10Mbps HalfFu )( "2BRb"rXy`.-BWaOn LANAz``& yCp)ff<f5 Pv[OuIu QWhRf3& tହ# X@E[.0_W <.p..T>T u
fUPf]T`dKu
' m<mf0fauWޒ*E,=
u l%4=(  t >511nq+  .fH R2 3m
E2  u
`P@_WSQؑ@xt9f% 0\00::CfEP`E`*%>
 tPv6_f!P5DB@FnSjD
@> u
>sUBB}CfEP-
 `D/:?XAPYfr:$AEY[_Uq 3KtRMtpPtHt.ct>   =} 뺳s }h } t=} u7} uEEHEE B""#@;Ev3#& b_.20uUCRVUmUPXU'um
>@]^ZQP>=; ,uXYWQU+R=m uUZd,]Y_PRR .ZXQR	 xZR {A1 m$2r1 [ ZYQR 2Of$4r14O#4 4x6R2X7_8SQ  Y[P< FXô
PSQU߸  *>V]Y[XUP3>F 
tEA;]PQS >R p?&S?P[YXw ; <ް=RU @; 
<Pp:]Z(*q3ɺO ;f`@  `& \o:BC!="%)1.)BbHL7RZRZL0N>S[F3faVSfQ ۻ@?_SM_ts OvQj S ;ARqSЀwrgrafGWO}QQ Yuf= 0wPmXP,g8 tIt#gfXhg Yf@fg@tge f&=$PnPuW32&C&:]u
uB[}
 t7j &uSj`&]
[@#^eU_3ۿtҎXCPRfW ߀>  $u> Pu~1Mu	>dGuf` bpBb A!SS< uf> sf_ 	Qb߸f t;h_&rfY
 -E07:  PCI BIOS callԢuppt!.i	iuM.;D umgn4 toh,'Uk1: UnFmlDevices! h`'ڊP]Uk4: Erroradl;space. f3ffDEFGHS]m
T^Bus =@Ssr{Funcq{QW '_Y1`P϶sЇ`Gf~f_
D	 MOf~/b8{rфAbЉPh'.Ph'4Ph'2PfX[f3S.z o0F@oPֈuֈuֈ.>t B@V .[j  wP Xu
U |U.k  >.VfTSAFu u
.둍.>t'h p }pД`hqPfR. .@2 <t@h)PH XUk6: Oc1requirDDIM5m. e"  fQ  f.Wj_fjf.ffPjs2*?fQ˃Au0hR*ex
InvrMM f|numberw u_&h*fEPkloceu. f`df	Vfrgfgf@f_1f.> "ك0t=t	 t` b 3fd f.] d f o   $ `h  0S.w(%tf0 r. K ѝѝUU *
 V4r33 x ZZ j Z:P. `ѝ  `  p, ͠( 0   СѝН
t < @7!. <W&@R'< $0 44 <$ $ $!8WW004   '0 < h`hb B4`ǯ @cP$ <_p"xtȀo c4 ȯQ0!<" B0 $ CBD P> Pe̼04Db8DcDdrxȡȈ#R/t$Əƒ  U<Uc4  pêU<U ʴ CyPaa  G! 0	 !(  hwcpCR $* @̡Ppax+C ؀<P0~Pڃ @_DDcD0$ptH0ΡB00 B$ B,@<$%  8\dc0\p`!@ѝ c2B0ۡaڰѝ!!({<0!0  È)
-Ŋ10B4 0 7<@u Ȕ4ό ?` c$!ܠݹPa%!HĪҒٌp ë#!p
cc@ !p!H@D )p )%hd% D E FPG; J Kң0(   k a̷Bg Н§<0a̸4ks@p0
 
 b <1& 2&- hp 2q 2PR "tap $
 @P   "$~`
 B,8  @hsН`dTB"vtB0B3 ˠtamMPƐq(Pspѝ`U :0 S
phpPqґ8Š0! @B4 {c4b`<pc˜p\c ] Ƞ<V0h  <$ ~ȴw$ ˪4춲P b8, c,%pڡ% Ȅ  0p% 
$apΗ ȡ/ h
Ǡ(˯\
`)>cȿ"\$B  R0  *'-0ai!0!PŲ! ơѝh\qb_d &a	t`p  +B0`4t 1Ɛ 0 
҂eaE|88#: :;a| 6R%!ƥi 
(!ڥ1eوܑΓ;<1#P ݡoPB5
Lb 3#$p$& J Le=90ALd%c $ b pˢڼ$! L0A1 Ŭ0!$p lXbMTL%vt0,U,4U,\d'p E@ը̡0A%2XȧUΰV VROb$p  RͰ`@AʈKo! @0a & }D "0` @T @4I@aaaa4 aaa *a@ aaba40`a0`) 4paajbНj 4pa # &j
pa`8"ӎp(a̬  0%b xҠ,łAM,0p(amaEp0qQ(<"ưc$  b <Xp ]b4 ]d'$(EpW<%0x p 2`2^T<b?8<c!(`<<bA0 J]$}p{  rq70}0pv! ֡ar!wnG4!00 !  4 !@( P$8 !  <p,  T
3NRdCaOpҁ'X0W<Ae@ф4a!'ed+ qD`OB!ߡ
tNp $c(aB,#$ <$bҌ8< R6 _<sP,g! `~. 2 A<0B4% <e&!'!& 42&dpʰea!0 8< 4rR씀^s!ʥ*a%X>ȴg
pâ.0(a8@8&e&^ B4㘁rQe
0 N*tشuВ1&!  %aei2V
5p᛭(G $#)i:. 0a <bȕ 0m((8@ՄB4(  PI0i9 ãqa*`C
tpáU 3c @տ`` H@4HPpL0HD@<080@1a˥%3!&0<@"!'iŀeġᘡN$}' <<$pps6G4pPqP{16!%5!eh`Q u͐`C:a"&SB,o `!נ,#=>  Rae .@ET!йt!  la^ <a
0%
a(1ڡDa()t! &d:2q"2pCaO.ạ"20!!"_c"2aa!&! !'c@$!  ` Ï`PGX/rD tƢt
aa_H :}p/!?` !@  `B@`du- 'c[!p1!3 pppp
  b0"  baaա` 
 )`]@<OO 
!p")!   Õp /b,N@xEP?'!" "rP$@t  p0< č%ʠu  :0	
p @0!kaAP$g	  Í" o
"2!'e
p #~0CqB,cи
a	
<J5! ȍ$$$@|a4%@
$8a^ @c0%8 $oH o H"R$$0&°o%0$$(H(zpJ$  ! q JRo! źíp $JQPc!^	
 ÑpMo! H)	4P!
P!CpJ!"D $d tá	z Ò!!Lq < ̍@J5	)5544
5;P4

! ˕$`B\c0 %1$PC@Í%PB$HI"Α P?2H#$@( 0% %@m!C48 $0ĝ!BS2pA%0 $h 6a6 J%h2!x°ä0!V!B@x!, ʐW˥0ap 5a Do c4a	!%! K$N!",<t*j
r,w@.ga,!aIH)
a! GDR)
t*
	F@a	a,5!a4td_wfv_vr11.1  0.rDwfrevitatafrrEltebifknLrrdwfinIvita_whgotutxp\p\ 80]@q]W d]]]h ^W \p_p_|_it_ata DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:@downlo{adeed

fSearching for RPL Server ...  Abort0iBCM570X Foun!ibjERVER NODEg

Transferrid`X fromRjsj0hne0i eniControl to program @  :   /-\|dt tttttWS ˌt&  ˍ  !PXEX8X{XMcMXI|}x0yNV+,rx{@p|ZfUfSfQfRfWfVfPF= twO. ~
&ێӼ h@ WPJ
ux fXf^f_fZfYf[f].>  uy
 w` Є afv
Phv.6 j  fUf҄g]g}Bweur`Sf&؎0fUcSІ f]Qfp汎&pRu _qf⒂ڃ> tj ЂSf. ff f3. 3h f& f& []áj ӚR9h uf. ?fh ` PV@ g&5+g&r^ tw Θ3Sߙ[wIePoȞfXVF=PVu NVf. Ђf ]ϝ    . . SR[.9u r   Z[AVSvGfD[^]f`Є > t;s u.$%tа _fa  t-. .>pt!  r ӄt"Qf 8Pwh3Ɏظ&.&G. [i Y3YÜSQ3ێËptFqh9wtY[Лր7Hpо@|3PQR@v0q˃ӈp 0X tZYX"
 S҄|ONQ+73!XuVV66N^VbON3txZnU[? V=OFc	5Z  cf~ Г   u^&ꐋFayFaBCB{T뽸7u5ߙ{Bq{g]SI?E5+!= tw#=
 w@. 
= tw#- dHinsxF+= t_w-pv{-pHt-p1݉~@ۃ>G tq hD2VZ^&GFPF0!!!!
F߂D<b?KGu0f3d!FFdrYFF~q
ubrz!GKT>oFu @B \? >F	B
P4 G!OFD  % F@oPPPP YF"&9Gw1^;>AZ	tb%>F*Ȑ`FDf+fF!GNR1"ޯ&
lXFF^FVw"	  V D^uRptu?LB
FVFt.
;Fu;Vt 
u; ^!E?FÎ 	~  u	PPX	F  Y=F~'}*f0fP <o	!N&#o f#t6$o
fj$	&u&PF>\QOfNPG F^F@0L `.t.,`Nc%P&~}-^v&F&b%1d0|xb% 1153 *HtH|pH~I	P` FF^,/ftpvQUV@8Fb:c%57P&FQv:Q9f&pB=&@
V 1`=2:@
:>3?뻐PG.fGA|!-FG0G2A4G6A<AfG"fG8,' G&AA
qz4FN+=33C"be		?X
*U/HSF	PVC B"RJFvP1ވ"FL|DDGHf JA|w'ar	O#ubV!ǐ	 !G#[M#[E],!pJ*F\ Q@_"g_RաD\.
E\0DGтqbGfc
fcfcTXDhQRv i	Ђ4B^~$$&G	#Um
#mgO@kGpp_kG_ʴr_Ѵr(Ҵr
a_0\pp
ppTXтF `CQfiga_d 3P[0\sXPwFIt!3$[PFR"L9&FV;F  p!(  F!@Ht- r0w!$&[~p琰p>8F_0*a%Jc _!F#F#V{&G$fPh8&[4_'!m>@t
zk` P!P& }pґPd
#k`[eأhG\"-$t@-@^1:v6
*&oF] A`.u+`.wu$`.uØ2 \R"F@F b!\d2?&tbn%~- t- t齇}ts^E/
u!$[ $`1F~F%%5F~}1!QQ|F6v
G\fo<'89Gu9Wt ҇VвfF#F#Vp!jÐxfpfP)!fhfj҇!$#ČB5pËMu2;òXPSV@޲0NM9u2PGÑv@ t|`fGPXpa1S^O|QP@PRPx10:0ÑxB 0 0UxRP u @˨*t |S4+W4ïŔƔ{!4Ą4bS;W οFV!Aw w0V0L^fhѠ7cFfjNE1@jEC G؉FGh^@raD0+DpD  sG_7HOA΃#GPfF -#f~ t\`Ͱl%CM2F2VppaqQ+f~
ttMt
mu
pƇ<Љ$,<=(u up+p`F<nta∇ 111ဿptqt@' Ǉ2P|1efj  YQC"Fн 1j% pCqTTv,eK$oFX%0 +- t&Ѐ|aa {t<V%FF@t.q/At"= @YΤAt>At?%? V`<RJ% А	F/	V"A@k,Rp~p$-Mp
 }p &{t`v>@ /@quL/Nf1j
/
1_NBmڇ@/ub^TU
 &k.Aݠ8 s1P=u܁u1%#tu- ۸Dj  ` 8jF+ҊԊ*Ϊr@R &xQ
p		~kǇ5 AǠ!9!Ƈ;$-@ `uP)a\-  tW- tR-0 ~7 tExfb*5!! AA""  NR#f>b  o  sI(	` `+; Ƈ+{=a+뼐/+u&& ~𠑊F /5&Q1u0r!u 3T`ӉT@40Pjt@00~t	2 4 8+ Ƈ4c 軔"	tf- uOh @_h 1@hEf@1<m@o
P> B{?h@r@>pth 	@)tuBuqC CP3wĊQ*󇠓'qF2*'VGG pG3LL3LL3LL3LL3LLD`*B$v̇ሇsR]ቇ SS Ǉ "dK fThUjTlUnTpRWrSSz xSS~ |SS SS Ttv~>@*
f	 up]Nf}ph@  u^0xP'p	HHǇ UǇ Ua"s&F u.0SgRPcG:0t`a0g`̾  t kQkÎDlll*ll܂lQk {    (`k`{WoGuGpzA|   $q^'RpǉW`kpFs~tRt Qq@bBr`6QqƇtqT @aaq9Pv(kD<G ͋q ߀`Bl@	C#ǐfv+@pyoGv)!{\IG
  ck}"c%ApP@XPP s`k  xQSVǨ6h@p1 t}  ? t	"%5j6 ``dibig%]0u	ǇT +cVcT /䁋8.BafFPs@V~R?0R!" *ŕЮŕPŕj u5 vG]Q\ u!h
5?v'5 ;5@=v#6@v t".Z;p_6l=s/ t"5 u#S\-"
 "{54 $fj@Dw0 ]0`040
8;5pQp    ,0x0 \n0 Ҭd0˸ ZQt"P$FwTp8Q7Xp"`@\p0Hp²hphf/P,  t*i5 ƌY`A.@ 1 еոе^C еqO9q"HS3r
zӌ;`tw*ոjc5лRW22t3"*qL*튏`ƪƣ$Ǥ$ǥ"%vPm8`HҸ<`H@ &@d`H y@ʁc l@ _0HUUHP>"d<4h 4lW4p0Hz4x{C|нԀ ^Ԅ$ot(з8Эw<П0ЕD[4Ї`@U@z@DЅm0Ѝ
0JЍy@ 46T #0U$5khf9Pf_N	6eP?Ԥ햽#@yNP6(=:!d5LЩʡ;*_d H/i(̀Ѝ8#KA`f⭺ - p##P`\#?t\spo\\`H쓋5XIX(aoXh`H1ΥP`Hao-U56`H|a
r$bЈ2\C#5𐾲5p0/u50ds^ a9Gu9W;uڂ~zV vc@v_9 u69Pu1Azf`uf0ffsws9@u9PtCzt` a1F~/^Pjxo; 31/GW$aD3CSA;RPztbtbq3@d 1j  PSV%7؋GFF 3؃
HpF(ce-pyVSFFwyQ@x^
vpgD@{f)!Gpy p{q!w@>f@0@h&@s'](@P xF^GW`NA#y F+!9Ww r0"WOPz%Wrb%uV_Ґ?VPz+;Fu;V7`FV8"4w4] B455U5645556s,1@zq-bFp3AxF}F=MRPFYP9btaqujf>+,96"$q ~ #(  R HfZyFtfpEEpEEfFЈNf`]kpEG`EqFEv `^ҋVeP@RFyyyFXN^ҁ@ FVڊF$F$`Fހff  Nf%
vށ 	B?	RF;L9>bv0Sfr;pASp
}4LcՠdC@SVsPqD^^ &yf~'  s[/uL.\9]!I`qjK`6>e`t`bF~skF|F"{vP '>0#@0$!.Pt<ý`u`!@'@mQ^[t!u -b-dC9A	^nu sn;4ýg2^ʋGzW|G~QgOr$WFV1zf9F9xBt_-V/72̉V΍FА+TVs1UFVsn*v P6Qw^	+ k tsk E!`- GGGPsp#vDGpfQGra;vu-$lqw:B;r狇5o𔴄
P'zC}wGWnq򸄠pCnSpRâ^1P#
`#wFf0zvo\PRɀ߀#t"u; tt
KN5Pm	`0708 DRtIFt)0tFt0 7t10 *#㘚ޠ0 e^X0tG
1W2\ﰟpR!qU죍t
Q[r=SF쀓юoPm@u/ȏ#!(2Fu@p^h 'jh0#j sBa߳hUSh2vCI|Ch UOrh P$Ce"(0- t	-  ?hu
RBhh5P(Yh 	 3_
h ,%V=(u# u)4^芇<2FF칊𿰿FB&<6	9!1v, Pf !0¹fv~! ËSVr! hz!@A \! @ P!!^@D !@00 3ѐaapu- = w.|55 5,585D5V55 t!v3'Q@`}!~uw	h ⴱs=U;j.Pᴢtua u_jq[Q&Ǐu6t
0
c'F~' }AbtܐQ&$A= u8
 ܐ tB¾`F9oF~rQ&GA!T V!EfNF%@ N!( `
p`fj}B pub Ea duSMʚ;dʿ= wč7P7667AP0 *Vp≱v{  8fh[ +.Azfj
aO0%1)B/@4P
@	N2ePLPiܯ[\CD ur\rHAٱ; v N0PQD\& ȠRPxS۸@,  հ@t2SF~|QmCfj @p2.fhTveK
P@۰Ept`	Iwt= pwpa\BBpDtfhQ7۸(ì`	0ϰ W@w=i$u` 	퐳@ 0Kt7`	To_h a3 dsĀu粼0 oPtn Z8v 
@8 se	N=ut=	b

0KT ^&ptbpuDWPٸ `$ $2V
fjp  &Cp& $qP7V8`pD2fc+$> tV΂ )
L~d}r)\%$@tݱ,u΁C<`;t-*ȋъĊ֊n*ɋVԊրCC*j P\
{F3`
~+Fu. {!u 5t逐  P  Fq @47T7F;*qh{JG3 [~_ {=@ @r^&0fP=
&GY #==U=>?==> 3?FWSV  ==C 5S:Cנ𱁶CD{
ڈsDG&9u&9oWuCvR;~Gj{:fFk0vwF0\*FV(׿ a=@ PN Tb
oh\,C*!DֹG*$Wt\u:PSVpZ_7F~}+F%fFtfv d@}9F}v 1F1)뭳P%Bm
qd \sNr,u3QXp um<L	 
 FF@}NP[ 
Pi t^(7	zpj֛0Plh@vjlw`hh snh ®hajoR0\Z 
ylhlAcAnihqAcptBu0 ffp_x^9 u@]yy 󄴡! j}ph@qoh|`^`bi;rjstS_xy'laP~5|h怆vt iP{!F~PipqS]qt5rׅ?qad~}TȀ `;qŃXؠ
pu٦Pp獲h pAcPCp7lt Ung0tj[^=uD $EF嘦G嘧H嘨򠘄 !StyޤTtn]{tc^tXmtM
tBt7t,t!ޤtt!
MuÐ2lV`fRaf% @R0gUdG>2FG pË9Gu" Z?@+w/K2 aP7@u`OG"aG@uuGN20KgvѰ1 !3<}O0P@q2"0KtWӯa_G\^fGt ]0bOt[6X P0G
^`9_I#+U
о> fGx0˽뜐^GtWvPb:8Sst2"0t(r}҈F@ȞtrEfh `
|QVSƇmf+fqǇ  >Gs Pdf#hj#lV[n#prqvtqwƇb͈q8,t-
 +'%<&0R*k>0:P0ٯ p`Q Q {Q t`RH= wSpF F,F4F<FDFLuFRx*۠#d40*99W$rLw9G"vEW&O1i  p GǽGPd  i^ _p ё Wxp 뤉VҊ'ߗ rOw9pvGÎ 8G &Y8lC"W$xAf0YQ4O  7P@:u dVF+F<: y<Puӿ;Ftb~ P@  l &gn rB\/f0*+Qḵ'`̱@BA7N1ð\9Fv2`NYf3ff>Ь2f6>QNX ]/DBfh  4t#f Mϳ/Oc	2ff
耊fP fP ff[f ]W<O_]:2C@@QRN;ssZYX]1 	Vff½p
&6 +&s	X	S[	[P6aZ  ]F| f^fbFfd!hF jn gVF ȲGAP:(Y0NV)D&!=G DGh4GG@7G"GpׂDP:	0I^*船>F*A:P:) 1%t"h"'$BG% hg(svވM_ @`+wF~orؠpX$Pq P:h.(ptf.yGD>2G{xM#G T2T2
yT2sT2$h@ 3 P:h`À>p"u+0 $Q"Pj
 .Gtf 

YG*HtHHt7K>G}<GU9!9]
<GwV1G!8H8"0N#FqpxP)c	o
u!C	҈CX	aG@WB0ahu?^p0&GM%H@F |W 
D4$CB#/E!vnPPR	PXTÇ0fP <wCP2L_ 0Y-~'|FM
fj-NRuu`bPv#ͷG"fWG0V4V<讁͋G"0W8yk,p*V
Xހ&Ѕ !aG @PS  GQCGQC]GQE QQE_@ B_W  0_W	@ߺ _!W#_%
Rc _'W)1`u +@
 f-W/T,#+@1-|@ߺ 貃f7W9-P_;( 虃f<W>$ 轇f@WBh4GhD-|`!NfLGBfN 6xf*@R eiBSfXBZ PhhIPd gú[R\] )[G05^^5_ѫ1`Pb#za#zaGߋG"G/Wbw#zbIe#zdJ#zeG#ze,#zf)#zg/i @PzjHkhlmoRpq}qrYtWtAu=ºU# !]F^^&߇}^-^?a׀ Y`QGЕG1F=C;$Ht	HH~: W	=@  W
t=WtueNu	2p#  Q"sCp}-ufช@")N t݀N뤡#GI}0t0rQG<)!phxrb ,~xG1Ihqf=:w   uЕG tGWn *G,pn@t)GWRعN.G0Gf"-`0*GfР*G%`F ptP+*G0@)h`
@k8t1`hj
0G
h]
@0{

10 wARXLPD+CC& `_ |pRVFse^&9G,~_q&x2 ~Gef&p.fvfċ@2
 ÜX)FIoDp D PD	TP˂Dû!G̲\pKKQ]YPfP44b+0ԡIPDFfp 8vYh	`ч0#9 V<Zʠ}q2?_	>wD uwDvD/tD B;ޣtDvBpDωrDAtDV>uwV+pDpVfpD@sf/ 0P+9Vw[rPw )U[F-F8 ,Fqt`$* 	}	<u!ĊfT!V ȋ ֊n* ]VԊwu		-t?-,uB	  Adapter - BCM570x NetXtreme Family B57hHardwareDriverMLID do
  #""`X  0	 Z   		  
	 ih
 O p	

`gapphi  Rں  ZWPPPXXXEP"[[0[[`\*[w\Z|\\/\`\\!\"\)\$\Z\K]E]/]Q]]]`+]+][U>Z4 \+&Uu[p 	X
 ]˺Z SVsrt*ݕ+Y^[ø.3Z* &D&Tr+.+ډD&5&].3Zù  ZøtK
t(S [;Wrw;GrWڋR [;u+u+ۉD 'p+DuP XÎ\.Et߹. 䫋ǃPG*_G,_.O7Huù@fR.X tXu跩 &glPgnP7 ñ..Y.ZYr0`7Gÿ6Z P(7t&&ߋTW0'L+`$`34< .:'uOu让.3ZY+.:<uuL
Lt\
DPX B~u< $s"UX+Ұ.:4Zt+EZnZ]8  Q(Y :OΌOWti&7`:& KD$V ^uY&?,Y AE"u.oY!P(YYV迟^EU*QuMZYcQ XPCu.4ZeZ`]Q".>uSPu;YPP5PQWu(go<Z<5ZD,ث+|t#@3X`6X~0`<rg3.X.X &u&D=vV pY3M .nW&`\9##At2Z.9Yu.9Yu.9Yt@RY.XrF;wrZtItJYE ]'XD&D tz}a@Mt] ss.Ub@_YQ&|uY0GdE
XEXED)72Z Y@Yf<w0ZX
Dxt.X;wŉ5EEEU.>XtE  m. ^M
u+P.XE{PXEnEn
EP
ZE.;YuYuJ&Dqqq3&L,p/&W`2&l &T*:M Vt
+;rs*X.X3Ã
Ëŋ?+Ht`3iu&0.ٿ]2Z+\2r&/`2Ius*\`  KBPUSQRW"$_ZYo[]X1GD*'5Z+tZ,T+ێÊ&SX&G[úY|w! Lr	t+u0+YTLʉLuIuËDDV返^\ uAD<w<XøZøYø0YWVQX/ Y.Y1ZюююZY^_PS [X FFt%&?	u
h?p&FAЀ? uށ΁?!ߴ{u@2`QR 3ɺO>3} V
Ftf?~ t@Ѐ  F&VˀRPWV~NV^_r{~@a1WVS3}GVڃ؀_VF
4
V Np3@F8@PVٱuf
r;Vwr;FvN3ҖOu؃? [^_]SpߋN
@u	Sf{
[pۑ/Cȋ^զWۂ/J^r$00<9vF
!@/O oϻ/O o¯/O oʏ˯/O oӏԯ/O o܏ݯ/O o/O o/O o    
    	 _BM "v }( J   _    )?_! P 4܊p,@ A4$&"@2
A, R
K$

 
a
(R Q
p _{Q0OoNDK 	Rʹ	 q* }	,#%}	ݯ() #,,?-x Q
#1/01+5P5 /4O5o69C3 #H9889Bq
T/C '@q
>+>::8'! F^B*Z::%3$CH cH!SF
H<8H9 IL@
<
IC-P: p@G1'	8	gSZ0:X1Ha@H@5DaLYZX\W C#`^6#G[/`]fb\ vodefg hj/kOlomnoC(1HXP
0P!rrH	\Ԑ r L rt:(p
`pUY Lsv:&p
b	K rͩxv w@w_
zC"p"!d2t8r xy@zs Lry!d!3hquty&B}hwu|B}@xqu|3A}jp
yrC  F`szyIB`wtPxA֢lvupRF@0YvwZqlwfPKyAXဣ@z0YzʀF  w4|!3Az` tA ^u
sLrw
sZ:!H	ͪ/q	I@XQ|qI@VSt#	Tu!_ 	!y'R z]6a|XPp
#t.	!N:'uʢѠ"rw0C`L:!g2Q70z(622AJt!᪅4u
Hrw ܠ҂*F:8z4װC8s䲪1ͧD::u6w 0ym<綅B:>4|t!u͉@Tw8@0yWBXz!B&Uͧ>:D	(:b`tz*<`$|,4L`Rsyu
ʰ<<:#yw
	,AWX"rAyߊ҃sQ|rH u`tF@ uwT$L!H:: βR|eRՆݐ%V <ZE|ǈrrStA젎uޱͻܠ(He!Hrj4C8: \ǈ̽u. ZE$wϭ|;Ո ?.S?@nW:  rz
@
| w~Iom e/'I "_x$'Og܏*Og :" ?rzO0O䠎<% 5	8AG`;QOﲘ́w >O1|$2  D( QEY^.mM$ ? TzX3v ΚUH μhK[ѱ[BMOλBQu߱` Ƀa+T@ȱ`2a
dedfZ@df\ׁ@0̈ek$pl^ {b##nвg@XAa+$2&Z"RA tXk 0bVĒe7  zaV z\V_PTcNRCQ {\PVH XeK ۶6NPEǑLz3L6J}R`A+H=cث# F;𖣘ب᪅DZd BC⽻r7!<͠+E	 Tq#VRB梨 "ѯX9r7BaZQ-00Q\.0^h@1G,0.(ҫ`&d01tYfx82pAh¯Ah$'lpAj¯bҳC٠pnx vK @a¯ u7~O P  !@`hQ`9@b3$fvA|ߠ0 ѽ1@đɘ0)`wTaz2"aFH7x[aK@ѳcVb=@1: 1tsހtWpҳaDϲP6         	 _BM "v }( <  > _   H)?_! B 6(r&u$~u"u
p0ܾ0pp`


@ zp`Z`%B	 
*  ΁@ 5YA"a$20@a! H͚g$1&0R1!%4@tA2(
P
PĀ	!"NQ
s$߀`%!a#r"u(r$&d0*$pH', #(-~-p`R2B
)ޡ#$-,A1812 
!!55"8q$P6228`!	!05΀18@="0!08%?
g&@Q.A8B0Bρ$E*"5FF5QB8bHdG..`NF5AGLr>E3N  `%6dP>T$DQ 7@SdP!aT!0BDVrF!PC?
% Q%02"R 9$QqF&5A1%\p!] -B;>#)DU'N% c&-R# -Q\_2eZ..1]*(722 [Ai/U#_.vT$h01݁JU
s$UcH@c$+AoP* .tZhsD5 W&eva%$UXUw rZChasb>1c)\z !^%|__} Ch[P`b&p2& uotc `"AeCgj%+ 9B$U\$3n `n,2Z"']`Adn5_ u, 3q(b0]!:es\zW#Up$9!ibV~ !HaFY _%@(X& !bc$d %adJ3vy$?.a%Zt#ré~@5TM%p'8a>SUTVDyՕ qM%o Q;4?q(%r H"!6P^0"85PC Cb)bQP
ucRhd8	DMur!rfKJʑua< AF Rb%UJR+
cdQ=qM$R\d`c Ne
6>bX
a<CB@(@P`Spq(? A4(A>f)q2a<A@(X1(2NQ<Y@ 
$M,0p䑧!I, 9`.fbg9aF@]!`.DA(gpM`24`.$ r&a%S#QA2A(AB(R! ^2$7A41\ TgҪ ^r) ! 3#!# asU bG2aCa=!1ߠD1RsbC`ޠ L( @d(V> pF 1"b(\2"ɰ_  B	        @	 _BM "| ( n s    b#        d d> F ."    f  f  `/zj
/Oo
#(4UfeC0$g
S, ޑX_2; 2$_"w wOo2c~5xR@2}ch_UZ?p?d2&i% *Y !"Y"S?2R"_jWz"%"k? c& %k`&(_Os "i%* "
*U?) !j"_@"R,*-[++`&Z.{`&/_d0)Jb&? &2J2B1O2U0`&sdbQ14`& K2$e6"4468{0q/
"#4 4Q2_8oh9W	y8o Q2;2J-) &S?{9Rq/$1CJq/AD &;B)?C9E`&EH+2A; &:B2C3&eGu &>Hq/Uo$FB2b/A!"TKQ& &;H%D4@1SNJ(`K"%yot2=HK )B<QjN{(SUb/B12@1]H{ ?)Y`1=)KKI4"2/A@"A%TE[")FEBFQbIp$y ?$:IO]@"QF$@11^p0$E"9E`^$<(](X(T(qI&5S9J7dJX!5A#=Lf((HqI+W@RB.=U)mHq-]ks0SWS@1m8Kq/Zgo.d0 ar8DnWoRKOfd0Bo sodWQB"$0${xd9sziEt"+ 1a{D1&ra2&}(s<sz[O&)pJ&dh|8b91ak'}BbB~0(p6$xSqc=8C;FTqn2+B&|Z]$%Uzp<H`9K?g"59Ws<Y@|U+⁗QF_*w{O["s0I!D]]6-3JqQO _F~SpZ⏛]N-dhCє]s9"1wX]qI&)-FI1SnVo`'Y%`b=]d-Q&63cSS&$R]2)_$7)O)(3<1O$k`E-7HN(RAĬ2Üb/4 D22Q&_(I"631=oqI8SAD79(83_9$_SeWB2q|VOq/XBQ1t3C);"
q9""5Q21,Q&QoDq1$+`&m A-H:UtXk"-DEqJHS@"B9a?BrĞ(H")OBSAT 1EI'B_KY HS& 8o-2@")c|%>@"W &j &4@"-aQB8zq!s@ RzT1U !\RBxOhPB V`@%*ۺE"%!AoӍUHOPc i$:U_#	I VG"0% B{tb "E)"0B"O@PcB7" &3 7Π SE`7Q oӾzEƁE :"`$ !p"@6.RF@E4R@QmE8gw Ph%/Oo@	 /f B

 
 f5
n
     Q   `	 _BM " ( _ }    .#3  \   G? uf  ! ~^ 	
H 
 0
 "02 
2}#=-# 
-W " " 0

!
K
ݠ P

 @P  
  iD0
0
 `0
A#BT$]P0!
0
Oa&% I%4&'%T&#&%(s)*A#N&*:+0
./ :(-!!//
+A$4D.2345'789	 0p"AB0#_<=>x+2,:tCA02AC 6,?'"A#@('	@_G5C(?/"+6O"c$E)\BOOO?p"p"@!2D* .2S (#S@T AS!S#S!SA$N7 , 2IaTz Wt-Xp%O4YTTXp%NZTJ6.\O@1YV!2AqW ?_`_^\PaZ"abc^2fd.a%@^p!Nfd*+[!!Nfd(+jRA7fd&h N
ZPDSfd$"gqlUNlA1Pg#OpMc"
#Oe"pB$OZEc#fd O(PgB$k4s't0sAOAuK'wwh&ue'xOv@p"qnz'z ,
k@V{NNpl)'z}J. pM@O|}}#.a~pn')k)AO .sZ.d."0
pD'Dtc")pn!.@6`WP,@1|]\TsJ f&AOFOT*OO!zJG -r)ra}!WP@0!c, 'Os(.#俘6"aJrAONr2t'@02!A.ARR"#."r-e@c$AOR Iw#c,A$!OPk(a$@pE,>қa$AO-9p",  v"qRYe,( AOAVeA}r g#A)!!ca"pn ,z1)Ғ9)rx KJA{}p6A1 rÁ#p0Ų !|B Tr{ ,KA$x$'ko m"al @TuH!|.S0$kNqMrSss
rpBPi ATWrne"  #02OrlBg$"Sp$,hS!SNDRTf"p! *rnUa0m67٭4+AJ8tBRdUX^XU ^U1!       	 _BM " ( k }    P  #???   |E L  ʼ  jD 3  ! x	jr
x
F
 
 ߲
> 
̲
E


ސT0aRUݰPr 
 6MCutR
E̐REѱT!RUtP
ur SM@%0#W,p0U>P BPI%ݐ:A( )ϐ(&%1(#/--
 <
ABa
R59-4A-,
r )|6+:8
6Rp8 "<0-<R86x=i> -
#4DC5/A2,c=A-pJ>s<BTDpCa+A9A8/>- $DQa!8!aAr2 D2B
M$DE>

 )AC<%O AC:pO$"P8$O&N6
 )(DBR PS*D>4S,D?2S./D_0S$0VO.ST0NpWT42DN,S44@V*S8D(SZEZ"S:D1&S<D/$g\P"S> Y]TE@@V S0_P BSS`D@Vzb`ACUTNWU4PC4pb30C3Qb`C
CO*pbPbO
TdabAfAfE \
GDAdrbBSpePi%te_}?4/$pb/PbakPk
h/#dcb0C?0CNPemnAj4jajkimhP#d!k`gmBcgneonpCgN
`Utq!oN0Ci3
4recneeeUT)Pd#ddoBrgPiqeB4xwi{bp43aBtzTrfRlg!Q
SNanN
2fu/Pe_rgh+? 
a!gAe@dj)anup{]r4BPCq"$!f"Cq!CEPiACW3Cu10Q4h$Z M4pk4QBjRUR_
 JLP qFpU?яBJP	 MSH hqGUS34\ . ($U_k (
fwxGw@?HqАyJԏL(яJyPM
vfw:mT opO4pOPwoy0oTyaњ.xPG,PSП
ph*П( tzП6Px$tqyPocКSaxoW1  Sҟ
갟ogPiЭopx
oA#SПvp𚁯ihpgfRh2Яy\pvrpyfMnҶ!v u_ПroAP0rھPbrFf]ПPv
ihПa ]JgPПoȘ2ѽК P\aAxrp`Кoi[21p@ZaGiѶP9wPPfҟay6YyУfvRvWipAhpfpfPvVph2ԗd@oXКҟZUPagPԡaT1o$pRpO@*TՖRROi1QCOѭPPOMi@J%NvNJhPͯDeBxH
АgވwL/
Ӕ      E
   	 _BM  " ( n x      #uf T>B \ 3  G?  f  2   v! ^̠H3EUVk		
	UaUwuUQ3@35
UW
	΀


6sU-i0	
2]#  "'0">=Uwb`N/Q2`W?`3>b=U^
l KHQ B"Q ?QWQfQQ #!#B "4w`$0 &d!()_R!l$Q,-3R@0B0%1/  Sq%?3s.##5  r0	$%Q" Q &$ 9;FA5e//`a<QQ.$b ?`DA5Q^/Bb&0  q!"3"TBqJ#
Մ;W@,QBQ< 4; M ?NPLq01MRLPuKJJ!E ;IP
0
TWwHPAV 
(W1XB
6XO  O1LL=XQpJѿ
Ԡ
W
Pa_u_tpJRa0>`au `
Q&@eeQW``g.1eݡeaiKi20j1ee107k2 gQa8l`e1m7k`b>W1e&``b_BpHqKDpVqH0S
`eg<<ܸrt`<@u2`ZpwJv&w݌w xq<Iwg!Li 
 xU hB{{"#` vCBwv}wQ"#Q0d wedmN0rd06}փdc 
Lf2a"xuuf} |ii.tփ@}Ui L0$t{@}L.g%.v{1AS0i 
(
'> p
>%d B vzƘ12a !Ë!̚q/Cq@}$1A! 1D2 uDAl1>b1}qDl8  x#2 A#C q?	; F%#qS"p!0( !	B8/=1(S1Qu[2Q801QS8 =⹑8r#q1D QwxQp%`"Q 1qR`@20Al?qKs+7Qİ=0F; +[Ǵ:1p~12@ UpD $sD+r 
ΐ.@2c+FUQp"3"a+C/ס1`sUqQϐ&ܢ1F@¬q˓!2b1A/"?p}N`=2i2Ġ1Q0 `զbp adq./ D1A$Q+D퓧D13??1@2310pz0Q"a b0d3q.& A SV@20a{ٓu A䷑1U q'138l3Y1
гPalRb0 bb.`p F1> u.PVЕ>   d
4 *C "2; qI?v!S@t`Qq 0 #:0꣺`A#P% QQ&Ҕ@QCQV/i&!JI2Vqh&$$1C$q /1>ч'2I3 2 B0A}5@]W"f8㡐&1".;(< V`8q Ğ?Jq8DD=0Ld&D󋳇wB3ALFd."}pz#Dd fd`Kacp4hbJpLȀNJ3\A]fsN )$SN$"ZS t-@\S(ҁ%U*OY#OHdVl@nJ  t`yZUL[[[ []^2^ ȶZa   e\          	 _BM "v ( e }  g Q#3 f [5   [ s  ? v! rD   FH !	
3	 O @
Q
?`1`-`(g`r   v o`g"'h   B  $``Р`
(p`Tr "/r?(`bf! QU?a8c!0/"O#N%31H&O!'/(D)X(0 `
H&@(!q.#&D0r+8H&Q' QUO`"b(@7w`S0*N6f"<q&!Jb5fB`=T==B>f` !0?C& q=v8`AS6_ADCwdC#B Q>
%#
r+#
XO	/KK(&<K2M<w߈D`/H`v<K C1GwOODDQOuUKq=gD Qy0RbO5KsS:DH.~ R5QKMUpO8QDC5#WB`X%&@;&x`HH3TH5KW"2X(Y\Z2TS@80V][Q"\OH|1TTw
fS|T ]H`b`bUNxHW Tbac9^*b1T bNU<`]gr&q=Wcbb!"ltmb@
GGx` qOOb"o	eb1Tp YZA@_QQOPp Y!i  h=q@;QYROeqTr#tt
1TFv12^  @;'@lw0! Qy$As^Oh@;dnb QyzAs;bh"|}{0bbd T0}@;( r~"|p(O2smOrr@;
p G'V` [PePxAH&pxo"gp H Ѓxq/"ube~b rw
?B"eQQ ݓQqQѐ`D@lonۙ  &0V3!Pq(P/p$" Aq RbOӔ0Q/ўQEoOt`T2wo "@l`T
F" t- LSz1-EoB!/b1 ­P@lQ$Q/әd&`Ӵne 3No"HBhqaκsoBByQ"51gL-r:q"(1_1m÷ /`Tә"ĥPTQQұ'Ʋ!1-ݺ3DS)F" &SQ_q&DV}Б@$tF<02	Us(@s֢Ƅo8qa2a$q 1!Pݥ` r1(/
B!ݺQUT O0us3s& |hQ3O(~stb|d?ӽ🄉"O p b12$ffxq'ۆbS`AĻ N@U1-RrT"}q ʟ ХW s1 1qa? RpR!$ 1&?ϝP
αqw!iUs@u
1qӔ$(H3/SG< ^T
&}3@s/@;o$s [qa p3 2|Կ "&QrȽўUD{r&B b5Ѿqۓ?Q8ӳHBQxԓ%=V@Tɑ5/ m~Vxӷ?U 134W ƀcsBsSw(s 7;R$z.3svuƴͺO Ō8TӣǑ5Et/F㐁O`Xb`$1m1`3Sp ђ_tǰ}
 Y/D1ѹ"h Rp+$b yQt sWߥ~SѠQ4b y@~6u(Aorɀrs0=~)'`(s vtewA fӘyDpЩohZӘsjLk0z2i' ٱRta& @`@l p hsޓo"`v h߃P hp|Yw'x_O
"_ h1qYw&BgbPn
O"v1vAEf'PAnzhz:v'kOAoB@l&;$b:(R
Gp&bL`-g-|NpBDvG`sh@0SYӏ0O
fApdh1rҏ
f`  horm*Hv(2xSc]$Ax"$-P"rSx$%Y?&UHwawO*sgwf"@f:1v-|.ROxfQh6
Dh2Ш$LL [ XШh"Ls@!@Dhbh ߈@DL    ȃ     [؎c Ћ㿂Zc+3f  n L!$F10fPfSfQfRfVfWfUCES>^  fB  _  ^   t^  t s $s@P$ ï t
P
@@
 
_apf3u 6R`< t_f3
 _>R`jR
 
 _{ b>__;a 3ب tKPPtPSQȁ u3Y[X	 SQ3ɽ0	  3 w XP
3	2
 P 5P  f@f_f^fZfYf[fXfV 3b>_ b t
	"u& bfXf^PVW 3W XZ_t
r
>__^P  f&T f. 1ff&T $.ft& )Ot..<xu<\߽޻μ̯۾ݷاЮDD/(|/8-0124/5!7!7AA$$~"!7A:90@?==$^$$$`?$9 =I@s>0p>`-;`>:@ @'@C:'YarRE9 @&9<Ew<	I!!9d;Wp7A";BQCCC=(`K)))**LLH9BL~B<y =J  >""ZFYI#Bdf9N0Q#<2Q` B;I~ =hxPFN'yNQC<P!B2

	F"cXSI8 = F8 0 p81\	

dC3@qV?$$D9SE\CRt;((DDPE B=FJC#F@9
)HsURs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍cInIڍ׌߃OsJ\gpjځBȉymFGł񂪓rݏOڕKvxmȂ튮xrWԍtEÃ_xƂ׎쐬݉}֎~HS\zԕzfmQT{ǃ|sFV͈vd}YiEь십ċNԐUiTivǗ؊qlӔC~t`֖ؑ{pKWoYgȏlϏ[x=b m@  0E  0 ` < 	i޴ 6 @璇T ?'YVҕ
 P g1!!#"& pt~|u  qp?  7  ^ )@fc1 z02  )2	` %Y   `00;BF?LXp0B$(%ҙ׎<Ҡ`Е08 _D`?08t ԢA|ģ   UP W  >"6>O >ǐs>?~!B""!B'  /!B#b&2 `   డaLwX>ap1_@@@dР @Р Bft,0<J@Р0` ~1^pEc P&RÃJgІ 0 UV 
	0 P $&# 8_ o & V| D~D D< V B f<,$$0$l=  ܀ʀހ?3`0 ?"#!! 0@ `c 	Ԛ 8	  6 a@1ppP!3p%`မ @\D2"##X;ᒠҠ@<| %rm?  20Р 2  1$Q$$ށyH A{HHKxď d $̀@@@0!c $2&f# 0;0xx R@rcxp RT0E?V@@`)X0$x|pTT T8_ Тx#60 @$1$484(d(lD@&1< ?! ?&!<? !!# f4cd!,?p|E0 \Ҡ ޶!c,$9`0p6Eb ° @ !$B' }"""  p 0 1dIi&0o`@0ⶫFD
 $_v!@^@"  \#2Bb"6T$-`0 |px39@@` 0֠pa0E 00`.=|s"ѠҒ`m|%o38"5U QHU' &a! 3?!  =!!3#AO2bAb7?1`		
	`21"`n9$i$	$	p::"33aΫ7#F?S8G0N0#@!"*22Hi)""?"!pBfBИ'  <p$P$%)*$ $ 'D,!## 0-!$  \7 gac#1" < ~ < QJ  <$$$= ??d)),?4+fI`a߁'0¢p6( g}0P`q6` b_.u/  -'@01 V  <  <X=$aY<p0b64~
w*0[hH\=  ~  <P {D=<$R_ܱ15''v谔Ebw`Apt#e?XI 
8hiЂ? 8P2pq2oDRDl""z}"n""s0 'Q@Q`Aq?V`Rq#@<1Rd,Д%}IHT1y(@qq@,Tp !
 .:23Vn&  } Sb b~r7/x?`RI l n2"Rpn  @@4!
0`ԙ ?;>g|TpcD ƃ)]+H/Hp0D 6bpS `$$Ϩ1 FD @@1#fѾ~(3H2~RHH~HH   9 "} 8F ?8R)C)E+D:< ~@""6@Q6q"c  2"&	$  c2$`k"b'gODu;?e ůRtb@5uŸdP!
U?BF0L ?q?$&""  0p	ޠ x ۤ	#`4 cp4F8} sPpP? !
(P# ?@@DDDD0!cD7 u!0&DL|(0<QR!=t Q>= 4	6a00i#!!`j0 ` 9?!#3"$$4!?5!#! ! ?@yw`Qq7 }H 4 }b2C"cy @l!b @!q=x	<	pf8Pg( (=ϔȖk">@?0{o8l>%q&?3
p7b2  1#n%sr~#$% SvG$?a_%h|  1  !    İO {   "rт&#0 0  wP1 ?c q"rиT

 Pd'=@߀ Ġ"!A+] A l1>se0S0*38%  RR2R2RRP0@Bb.a4dP8%cAR-OeeP7
 PpgK?Da,=%$>'\!"BM "00#;	X|D2D"DvDTDD6 #W ay`]x8#A `Ga"@  Ȁ1U9-$d=_4d8!a	  6 P>@ pL D 0`Bf$,892k&	a@M0'Ee 10bpxPX?	 ]1a3"&,0x>dDd<x n!nႢo8|	(9H;)*;*$*%+8TT5Vd<p36b";5X@աp{ pUO1 0 ?R {`0C"cpz @M 	~*H0&0K6cւ""8x?~!B>* #"**@0-0o,`f8a00"***" /"$'$&*"$"D?^2E?0``V?~$BdBp44B
BB~10@	"&D$(-y`_6,!	'	smsmf /.H/pX~X_=I H<H$H$I$= ǉ? @<S>@"@">#"D"l>("8""8>(l6cЋ   N@PāD4R$zeUS R Pe	Zf!8! 	py?0 ;6PPJ2A3r
~! 3 ?$$$$5d$Dd< ~  P0_@Y $D$=ЋGC1qTRЛZ0^ 	/$y,(8h(lqD?  /"?(/(/(hOX \%2 ~^~`a$bqQ	F'"@f`Tf`Pg0#t	 	(00	?$ Z?			?R" N1:?00gh ѓD= D~ = yPPp< %Q8= @|D< !!"!"="""?;@0{BF\p8@hі@A@uCb>HHHd,$|$$$TdTDTa##:wP>?~'$!$34, g A>??$|. }1Ò aL8`H2 &2 +f!b62~Z*\*jI0 /:G; x pQ H0	  y 	w 	 	lc$Ê'Aȡ+e2A-`-ސ-pzAsG0 a B F>lxPXHL0F`C Po0`@fǠ0P0b64~
**hH)  $lH UIHUH~HHQHU~{HA6pC!!`S8 2@1b)) ?()()~?H!!!aGaC,40p" zs"rK7K@
p`2P( F`p= B> <$P'~0q" ">*>>B¨"&"cb@	"00P  ` x7a3Va0a?"#
 1pxLC|  80 S#Q8#C"9L8<
S0PD  > "~&%,?(l)$ 7P?-0`DQ2!;VR!q # @b p<䇢Ap*f8g "**~*B`Xb~B$fAf! BFD0@ @`@ C""p C bB ߄:?~>"
(L,蘥"22gS&pC)}p8@Tl@l$5?b5d0>cqc\^_x	(	)	) ( )H	p_c 5aVR\A?~"!"2&460ba "(*F+8"mqig@8pn!̠ސ0q$
&bBO6  |<  #<@;3 3s `
xp ds12m8@ 	 `p1 3"f2 "|st@Acp>u@$	,	(	88(2l"FfAgAcyOed!'$Bg3
D(zo


~g<P4 7  p }#"4&0PP0h`@   :Wao uUcupp*	ppp$p..z/S.x/Zv/  [<u.z/ B`uVʊ8r
8s8t>8t: t3-v(8r*<rw.p/` aa 23P  	P#"RV{^Zua `R\ts 2ƃǡG
aa O sV
ENjW12wts2o		 T<
t<
tD<tY<t軮 PC  VPP t	| tL^fn!t PD0XM  Àt	¹/ u 2 T.>/u W. "! Q"" `.p/&
 u2CQ2P Y*2Ȱ&P% a#`#RDr
././PSR% && oZ[X
 OCP"P)" $*+.6/F1-F2q-P..P*,/WtO0_P(,4511
*QR.6v/ʊƳP ZY[X7  p$r8299OsP2 <sP
X=<r<0<rà
/  /.&*.5fu'ha /30!b? 67@8/B.>/P2BX;2&BB$CF{7PQRW,f
 _ZYX. 2.9`?t./DqB!D?<u<<@M<<@M<@M<@M{<@M<@M<@M<<@M<@M.>|/ t ?3ػ@ .z/G.|//O7S@T.z/.|/TzPS U0.././(eS;P(?  XDSQ"[@[Xd  WV>	T
>  tj6 hm_t!j^\Z(_؃&  hEuA`jFa4U_aXb'c&bu=b>'c&bu bI'ceboa4_% = bbbUj j"l?'c@&b"l#UjVm{"l$#c5c^"lJaf]fffWa4"lNa&_(_wa
"l]j% Qqb}P`f>_^mj_tTu$za{j`t
|"~K#c&cZ"~t&_u_u*bbW"~Ah/bbU-"~az"~D	/bE?bCh|abHtwGĊaa&bzb}StwR_"zVbUw`۫O-b[aua
avPalu =~ jXzbgaa"i<wa!(_ u = u8_  6_t9j9#c6jeU"w&b7!^jQ_$览}!fh  nbb! t+t'fhjn_$߱z괨LbbtL,at,>{jh_fjhI~`>n~{%j hnaWRf3f
~fpPFPhhb@_qh13׉FHWT@=#h$`$[h  $`A,< VP&ha1$ƀiA@`FqBvcY1IvcAq_Drxr^袽^AG&h0]F൮A@0j~h!9?ľfh _aha{I@`=I løoh^!^џao~z te%h ѵ V!Jaѵ :~e*h[h$EhӤO`{gT͂ӳ^_  V"b^F FPL <tPvVϐFF~rpы F FIu0F&6-^ ɊF*+҉FVc+;u;u2ác9Fu	9Vuàc% o;0
;Ð	c% 	S	>
 WV~FF&8uǌ@8t
rƋ*
 ؈FLDNuA2 WP`F fj hൻ*0{ ff ʿcc;#!&]&6_jL_fP{Q  tj0P_Qj FWPp
 WAF -VWVPbbV=ut_ VP#$QGF|W 0a2
S|pr h &T F GPFN_uFG_f
z?O<	P`m,Fbb2Nj 10bbɑ">bb"IbbC"ʆbbbs1q" ?RbbOC@#bbU2""$bb2&5_% 5_ obb""9#A+өu{0E660* 3A++ /q,6_6_. 6`bbkA+
2&]% +1]1]jR{KA+<u@3+yH4_5c336H4K5&QA4&_1wj5A:b%:@:A5<p!::a5A:+:0:6ll_jE5dA:W2&'):C5QD<'::H5Q$A:q)aD:N5Q<::g5r33<ɳ10;ji{(K::RJ$#_jS5KUCD@:U5vKUCD:\5VK/	2&m)C5[bb9K2LpNLؒ3w+6Al_4_ 0UjXr0m_a$Pj$0̋ u&(_o߃@](s*TbbA[b%B%l_^Z&h@&l_WW`[h6b{1`
]@,f{ ػ{kJ"H_#y 7(A[8]$$h"b脱0̿	qZ0̻ `Z^ČF&&g&`&` &,a &`bAabʹ bbpt`pDq_pnjDrLplp"cpmR@tjLrJ­O Q K$t^`PwP uJ t
` ,a xQy1 u3m t0z`n?,a"|!| ^DmE~Owul& `ݎbZo_ ժdZqppPfRR@qPh@r&_o^ط>5AP=F~.#10a&_&.kP@[jrej@8s0fo~cWj#ôP
jvf&b &bиu-&3#&3&3gob @ahJy`3/M"b*_qKc(a&)a3/v"l$`ʎnZ	 aup2v@tr2^󫸀[؃	s$2P&^ߖ^}^ rsb@:aڒ^a s:sӻx)aJz@2؄*SF2iz2BO*`4*23*(a$ < u@<@+#ɀ AP0];)3@ї"tݷa#vZ0տjbaڳKӵ	p?𙗴D0F^Nr'~#t0 u^   %  uP1"d"RVF  jW RЪ`U2F     >v3+QOYo10РcvB5_th h Za¹ËـRVŻ/G9FǸǷ cȟɹj  ?hhpRţ6ii^  e~ou+ FVa vƂ F~ r~ttuFfv
0~ Vc}Һ,0IuuSI± [t
  ^"t~ fc} !FB F~P|0v^ KF{ NQFFߌV~ O.FFVBc/ ܻBc@ ˉvFW~_j
PGc
^F&? uv1^WV_Bo[h_{W\1^vgNyFPN0.jav袑g[:1cqc?^&/GFPZgFcFu[1kC_q&C_RpFfP(a \h >hPV ORPa@L  t@Ǹ  +FPqu}F-C_FR-C.r h.@B@QB\vgIqu3MP(F\0|`8F .QF6=,n/iӁPؿ^F)C0 uH0 taa0F 6aՊFP~2|FSt0@YW^
`~	 _0 ~R  $FTQCI~ t; +,QAF'G?z u&~s&WV~?N^`!"^_""Sj(Ų#'
-̐(1q.T$ ,
(|WVvԋN#!(!-P#Ԕ#'U$R06P1 ك~(|W~]2"A_~@u"#7}H؊B^F&:`:W:} ;4+d*.$w10!`" (Y%@0D9C@*Җ2=,<".)($@ACF*#s(I
EFGDLgH|aMT$U^&^&8t 5^^?}۲7ð0GFpUNP7 }@1-ArW ~sԀXNFNyG<4;uY& -0S3ɋFPAFC&< u`YPfF ~Ћs^!Z{FP ~VKТ_qQ[CVV\GV~^Y&F?Iu&{!6qv~ F҅24_% 1jZ҅qjjkE>҅qj҈jkUI҅mjkb҅qj= j ko҅fzqjJk?҅Bmj@kU#҅%zqjk$҅qj2&_5_% %k9҅$l6l6r҅{bt]t+1 ~1]j_R1{3~h~`"
2&]% h~K"i{2&ja~&_1(_j"L}@)A",} pj)a"{bt0(:0S3|lll_jD"	2&'z8E"8C"rx)H"pAz8N"Q0n)S"1@8U"8["m30l+1p0jgQ:1b
i||Ft j^"Ōb曀&l_'_ jnXbw_+$Pj	Ӌ΃ &(_߃@@&)a_3v·la$`nZ	  [pvcr^؃	s$2`&!^^F?r`q$`hH  "a ^hIm)aW V2a@2FVvcrꯀ2X^=2#0~1Pp s& ܲG|p0]d" ܼRh> 0#j6 hmcj^(_ऋ؃ bw\~!jF4_zUDR.R]>RIza?@B#4_,xā eúA=jb1yXr UB$5YBʯ96iCBf]fff\UB`D
{aK&}f&_֩kAdkadܵ$_蒜vUDd	UEdU4Cd?ߪkHp܋Ċ\aN\2U_ۇzå2SW"42[\f1v|ru #=b jXƪ82g\22i\mf i{j!'pjvB!6v0ދ~ &F<t<
b#r0F*;]}7\~tF&8tF5|<r2$kQV\^\u	A(| Ð!6 ~ePfh#?  m@gF;rF f?*
F  ` F*N*ȁ vF
Pu$bhv
u+"b^F F FOu_g
f2b &2b?&><b Au=3b>?0|tpc e*&c&ޒ2% c1cuF=  wxZ0+ɉN3c3@ [3#Љ#A  u*_c$<!ΐ"btc% B%u$&	0u|!apf2(% W	u"%<uU!1I'w 0Q%
u6(Vau*#C*  
c`FOr@"b #b$b	%b&b'b
(b)b*b+b,b-b.b/b0b_  nObw8!F4_ Nl_f&4_`Z& &gI8~t :t : uH8O);f~ t7fh}6hm`[5
 ~rF*F*NuuǂIXI > _ f#B& Bf C0FP^9ZujzĿRP- ZF  vB F~2|S1~ĠNF  H<uF$`F[
 JaRJjxYE\VQZFRv0F~F@ Gb*J*DNzQKLV!mFFG|F؊fCU-`h &OP Q!¢I
JJFܷfDhSTQ zF֊fנDt@ t؉Fh SXvv^!h 1
\~S:su_P _Mb_muFh >h0 Ah \F޿fPqΊFfDjySbQq:A`PI0F1F2F3F4F5F6F7H8F9FAFBFCFDFEFF~ƋvRڍF؊GF!mދNƿB soFNG&F;up& P2f L5^wPrPjo2*Z
-`"i-r  NV1tm|
X$<劆2_$0T|||||ˡ6|$6|j)a{ _x
 eQwd߾cАШfP֋]% ;Cu0Su1u- t*-} t9$w0#r$wR32$wtVQw2r r&6OtBwkAq5L~Fuivv3Zktt~xGE)y h 3|
/}nFn[PRᕗ|P|_|$$2.%6_cȃ`2s]Pq0]1jLFP1jFj9)3ӀEs&1$w]YWV3 W^&@RFG|y3X]E yR?RpR_& FWaVp $ҭaytB?"hW>_o `]]6 6 &= P hY_ PFt  ?ZB"bcݴe
ݴ
# Hu	:  >	6 Ĵ &&T	5V<S~ t'j@I t/ u#'Sja)`t= tt Ѝ,au-aul &l .X6_2tIC#S/
ccj P4Sw3b`"m_tV 2tC(_t724_(3+1&_1!  A1Gb_Fbap2c*aoana?apc02`\\\V@_r!UqٳaڕQ1#`۰Aܱܲ܃> uu[h hB \hRyfzb2b㽵bb^rb⯂bWbbtbgbZbMb@a#Jl
EU yevbdb4a\zZF&? t5(u%&|Ru)u&DPƋV@EFF3b^8_fjfh 
5 5 	5 5  jVH~    u 0&&_ %I>b^ 葿tf@j j 0 3= H/=
td-
t]-! - ; -  o= M - -  -`" N@  R 5ۋ  &9w&EU 6P  VV"w 36?#Hp  9~ߡ Hb;@@@^ 
fQM>~vv&@u?
{D^21;>vĴ8b3ûPwAk 
 snA @O Z3{
b ӧvV>
ҍ  S#vV d*qF^%0"% 
PYÿ h
b'h  b'"N##F
+F@fF!vvow	FQ#ZNwnF@p"j @L)FPNQ=+*PaQ+.VW  P 3_^{E   >ӧZ%a%4@%0@?
FZэD$F %.}0;F|+5, F@PQ+]8VvV1豠+Np=F!t&"=>P?ApIIu9Fq//eZFPFPe*G Z̴tqDF8FC PFp/Q/A
Z %f3Q)c"hD7c*J * ;Bv0t3~v
M?V>Zp2NdOƊ*1 uFPU  };Vnp)]`rᬃ> t ur3NF όpN&8tG"pvNًZ؉^GF
&Ft^`[3G[tkVtpWX
YV^% = @ʃ@A3tV߀Z@bA%w#> u#31X&g*;tYur1di*V!Pft7TUtF
tܢmt" Z
fpv
Vr.O :p>B Zq?Vu	Ta[?SUnnoMo!+L(q0rVsup=?ll>>8_L&d<RP3>>yXZ#߸[[t_N[@1JTP[ {	{1JnTZ* ~>0UO[uI~)3+ *"; ~
 ~IZp~ԁV~TM~u[qu~Ԥ@kZq}#}ĆF}.Ѓ>'Z }P c:}wZr}Q~& ASS~1.*Ҋ b1чq#P ≆Z}Z ~9Fu`~9Ft0P6Z6ZaߊZZre7baO ZZZr-» 1ûws   r? ·AJޠ~ tsQ\3Vp#ᬾހ6F;{uME ;vPu_39> ~@{ a|Z?*HF\&7PQF`*8;F|P~߃
G;`|gvOP>  T>pJqHbFf&G@W}@&Gдu`qF&M*+ȉN"&E|&}1!7tOr>V,FpV&:t~P}
AFFfXu06uC@s} D㧐ֳ 9Ta@*?;}Qpۃ~زu̐3&8MtËF ڰNu\0L tك*G;߰Y^| ,Dt3696tVoPQo9>` 9U
0TP7 3{
^&?9 ~mRn&Q&^F AFtIu'9Nu"^*&ϊ *@ʾ ۋ"|fAGv
<u`   iF+F-   `FѰpF3/ϑ@kpr C I^g FP -|3ҊF:ҊFs ES@F3ՐC%ҝ0&kFPPЁ+ɉFN+ف H&wwfFf G@VQ@Q!  :h"b1~38tC8 uæe3!n~^
AF@G
u퐷rkb1N3~(~0޶uҕ F;|Q5)#߸f*VNVq=v<%tFu DDF
?0N$0F
]3.`
.VF!/p*VHtQ>;v~E^F&_uFdPW1oc.!:s.!}  P5+э8sv6.!:P5N&8 uN&= tr@Tk0$pfh  Z}Qfh  	Q  PQf6 X!㡡IQ ܀b4#FN9P  Q .j MvWV~ZƼ3~Bva	&ğ@0:f;~aNu0>Ff	Aƈ`ʁ Iup*aP{ZP V0-Q o0EqPA ~~h3ҋ`.W
pt4cPv""#`Pځ :0GW_ԐAA 9/Fu
A)@m v?v.?!
PQpVVBDn0.n#F}+F- P9)hF@ p2O1n0)?0D+\+F(EP;-DpG+ΐ0jb 0fh  2R4j(289Pu	fOj-),a	}OI-*-n	~"ʾ P1 T O(R-FBB4Q6jP2H-oj@z0u7田RPQ@ACra:a:WVf- ACb`2sk|pFsE+FFPFPɀQ6J
 A2J Ap
P6FGb2DP_Q[2FO{OJ5%+F+1@\JN!AMQM@P跁T$OEP!@C!RJ T0M*ARvcK AV`"WAYJP\E\DYgYЫ@F;v0uNP$"W-mAYXFA/%UDYYܡ3S:rQ_P迀TnAC&N0_P菡fV輜PE'T3&\d>Q4h"StY;}ǀ0JDRpZ
ЪDTQ3މFF~
␻PaR S&Fި@u[]!FtF;Ơm]!ri Bt`s&t0(t;v}wv !GF;F+F-	F0~F&Ev;v~x}~ Dto;FxFtJ} t~qVq~r&stOsC tG\
t/*伀tF@09F}\ru ;F~,My~~>+sFRSzǥ&L
1DFF+bn ACϠ&nQMn	P(@PF0.%UE0r)Śp=
B|x\@0F!LpL`9LF&^"vavFv'`9{0vм@Bru%~'  tts
ޓ+FRFHfh Q4뱏2v teĝDԄyݖ@K1t9~wqąaFQ`D6y+F)gPEy@M`D&Opz+σQ.x=+(P0(0їtj[a9xB1FBs)їj]h? 0BsvїЎ0@UȟmїR򁗚_sїS> ofHb0>HbJbj AWw 
Ht8-t-9t- 	t "{f ;4	pF~ tfHbF  F
Pj  Dv
  
i!4 鑶j Rz]P HPV@U
 O
&wPߓu (tM ^PE/! A)}~	VVrDAF
tF
% "u2AħVq6 twDu0ڰ3C2  _؋AvG #vD"n*aHA^9>u 	 pg_PNqgG1vRTkqgTڀu(+Huub@ut0j	jfh%1vPv䠆QboP觱f~
 t
`
ZBdJ lpdEoUDxL0aPαF4 DVVvKvl`v6 ]s"ӝ8܀q7(aFܐQruܓ]܍FQ)ˀi(EEyU
 aGP̈$ܼy@`8ã ]}0  đCK't5 0 ݂CDrAB?FFP?IF |
p;Ϡm;Np|NNQP~uϿ pJ= K = ;
 - ---zW]
F 0 7>b xP &y;v1! -;vFPVW F~FG;~~|& - D- *-#- "e= Pk'-P
@ 5.SG@_6-;SF?AtUtPPl@a~pw9Fu
VV`IVF}`9vu@, N0}pNNbF ~9~q;V 9vu,< uN[빋v Q  3M	 #%PQ  % @!& ^(VN;Pq~A u  x(^F;~ma%QX+S-@!'~Du6b  ;| N;v}O;"Ǎ|tp6Vaj1;~ u[FAِ[P9v|GNR@rr@9F| ~0A4^&+^& /F̡	FIqh\.ŋVt ;tt D֋3nf4W_hg
@rep?#@op7@0AAȰWV`  Fc (a tVU@F@G^dGGfbG)a>ndGGFdGGN`G?u @};F~QLo@rAyrջN@uOpNB6L5LM'MMvƁN6!OR>$` u)>a t^>vc tfU>^ tnm{_P芸Wh
b@%P`h:XC#Yu޲jh0]hZð
j(hahZ[P\̧Z[[.P\Z[h^h[^P_[s^^P_[c^P_&[S[ZZ![[pcay[pcai]pc.aY^[!_I^^pg^9^pg^)^&pgͧ^b?CP@pD^_u` = Ht.- t'ztF-4tcPHt- t4/Q#H{j`\t tߤ0DqqrU}Dt*䊇 8] uav*H0Wv`7PV tt>w
&O FGIGIBJФI|IK`Ghkŀfj j*PV)pWVh@V3j h6	d1`D`~oHtHt#фh !u0   qt^ X	
4F(`HtHtHHt$q"@E􇀌tA1&&G<jhz	G+Pr
!G>[jꐑ@БX ^м!؉GPUPv&ƀ v~Rrj@6 fP3MP>X FP?~| RS}Av T@j?	&8 t9GPuE S > >Q9 usARf   ^f~ t  S|֊Fñߘ	K3Y	Z	1Ħ	ab^ 2	f7»^3&~/tӫ&  v&8 u%*C;^|3EFpPS'x¡bα/^? tvN~6"vxA(׿~ uP!bDFG&9 u7~b	F0~!F=/5 X= 9-
 -" - L
Q ;uP< tIf齠tst[nV-
tL=oJ-@>C- 	tI- - P$p- tNI_j*oP::~D@F	EA00$t"} uNj 3G1cp rR4 u
q5գ; N3~*^
aފ&8u	F;|ְaBET茠	胠PP@
඀00q`7@
CEQ
_$~ * !8fu_bϋPQtP32[&GF |FඋFP
t- f3fpm fh 7p j hrpgR[[pZ
ھ ѐ3@`{R[QF&*`Ht`&= t	_@ &_ Q  D
4 t^u	 hh8
h Hu_tAqPF	 &
h w²
0<p :w11PF	 
@
@ Dt5P߀	@1&	of&_آ bbw bQE"  1ܿ2[F[8
#T[@RtPUrt.֯F2[[^&R Qr `m&cnn],!o3Fo
o4 
tCdh_j18j u#
P"
PrfsVSB}zb{Wپٿ2[pڹ R[rP_ t&&
1| ;&
t@m@6b
Eba_J
 Q (|`j VoMLB@P/OoTPP	3^
0[%  P0Rr
/`

"$*#d# $^E$$d# $T$TPv#xd##r(1[$Vd#< $Q*#4d##q(qmH*=	pнFw- 9t7-
1= Mt%
- Ktqn-wMt P4IX0y= N.|ģڣ{",2$077"&0[Wq8a7z78 d9 a77za77Ր*,2*0==u}/q h#_h zl= 	QqӒ3?W q@=l=.a== 덐Q.t
ga
I)0[_w0Vfh0h wt@t&C 
@ AMMNsNAMMNsNAMMNsNAMMP!NsNAMzM!Nz
@_0[x
 {w
r?,tȐ'/`3#`nн-+t2t#'oKt
- tpua=7* 81[J*"-v#
hsҰ>T?Ѳ!@Pl@ÐV3pPf0L =	л
`^qcǲ/ +B0 G"1 1u 12 '4i  0yHtQ R=;*AA<*>@2BeB4^h
h rRрa{Duq{ 5p p;t&1[F!
ItkvJ*&v#
*( #shwxǱ_^`pabO
fhL =
t
N
4pnqd"v#J-xЂ # 
e &3'QWt#Qy * uE#X@, u #7`. Uu@#Uhu#.Gr")rȄ		q[t&HHqPу䑠  `
 u2P@0/t0y0]|1h2TiV46^4/@r5
566BXlzªЪު.@7҂1c!:a;a<!>> &[ lp=Ҋ뱢a`Ha^@ amu{ttP[m[ 2? 10íQ3J&[GC!:1c0="a
pĳ}pJf[f4_2KWfhr  Kq1LqҀUf4_f[&5_"\
@ø့ N ԺUԺU ԺN6@8Ժ8U@ Ժ S% = $ u
@GHUu5u,tu#Լu4u5u@(V {`Nrhʭr
dvoš1Vh9@WVrP

[pkHtHtHt$Ht-L"+!
v#j22t_TIԜt='d@A\cQ' *Uؼt3PӪU<ׇ@,ӈUbt0f`K$f+fF}ܐF F\^F<_FFD>== f  -9 -tR!   -Q0 -*t:-9 ߐ=P[+- ej 0j-haiv0jt}aix轁4Ht/Ht:Hϑ16 2(;< R1`3} !"!oFt)%$Vv`
[Th\\Q.w. F*HF >~< fK fF\vfvvFPvF`Eu63F΃~%v슅\\ :uFG;?F pq /~ t
&X&8XG8~ &U0@HP0@H! _t&P`hÃP:`h@L"Ht)3ã 4→ђ>/WV&( 	!K c&r 3v@QL,aG[P 444\C<9F_h"L\qSr
o[,a13(h! qB,-9t- 	t 
^NL
= (fjj G0LPqacu.Pq(uh |p(Ɛ>\ tu }1fh  ` WD##g$-%X&'>[ tMh >hFrp qh̯D
3\j\& [fQ1F |%0eq >[ u'u><>'`t(q?6[ٸ q&U& g+;s'1%
+te3l\031B2׀> 5-u	o>[j@ 6j6b#7t- (+`u &#&g"<t'=#77^6;B 
L!PU $=˷37$7a/!$t'Lfh(蓩E]Ci1:]h ;[1MNNpojf\_Q\nRl\{,aP`SѠK l_ 4jARaRb0ESaSW萂TQ-52Rt`RYcSSZ[TQ2RL WRlWS#^%[2R"cRRP`cSSaTx Dt,-
t%-.t,-	 tE-
tYtai- t/`iC D@k[:~{ th}y@.ti  o"jq J"V-at`ui&Pa-atmu
Ns#&PqoW,aoSpnUqsq@oSpUnqsq oSp nq@@ut@;>}`y`yƀrThXrl@MtX6PȱwFHtHtpj'PQ	0!KP}{|kuw^FV^tF y&?u1ccdeg"h h@.ij1j$> uh h[hߢ!hRjh>
tl ?@tt36 5ۿ@@;w}F>
rwFh2B=RrᚅM<6pf
~bf2bv3ɉNv~FV
tut9v~O@2|܉~*fn\^35
GF&F'	?Qu^*ۍF؊F% FnvBĉFVy	NJҰ;33V~"9tG;|	FCċFBF Pы3$7uG"}4!t%67%2@Ğfz\fff҇F )ѠD̷]ĸ`z\ t&n
!qn
Dŷ ?tP ĸ ڪ`r
8}C `H䀯^3~
~
tF^&ߊF!u	Զ԰\0$Fp|EPBРnG2z&rq24=0=	-tX-  - 9`V = M -ڰat!Q_|-a c0h= Y.fĽa׷z\z\+11|\P- 2&{\%   !ڀ 3؀ŐjK jhoP
麦%ԣ P?Zd?_Pa uj{?3~
'GPoc؎CB]̘˃kn\c]fz\ߠ]$@f
&v
	fu
 
n1v
@צs@T
d{ tlA}\
|@fh
h2z$rzx
>au`#
6  O hEF<tFȿ
hмBP/@F ˭FC|ߊFY PG֤^VnF@$:Fv
@Ȑ%	u(0"Ф$
F&N
{!~\1@TָqP~\\5K,Ϥл!!f`̷P/UW {U̷QydĊ1U+}U	"S'שӸ)b%1k#	ʽ$%qՁ#
q'Tqc#r'5C#+5"#
tJ-1, #!Z-5Ӹ2q'a,$Lα,B-
PЭ
- K{t Qɗ00ӄ`7@=},:HVfĎĞĮľ=ŀ,2A~ـ\zA>> A>> A>^> A>>0 A>>@ `- 2{&띐BDD?'_ (D BDDdBDD@THĀDDH-  3+-`JKJKJஓK JK@jh2pp'pQr w@%ZE<z<Ō}n=I1E?P[$b&_IҒkf&_f~Fl_Ѽ@q@@tj ѼH[Hol_t&XT[!oX]A^p^Up]m#^^S`UA^^]A^x^xS`2c^S`A^^S`t& [
0\@&_zX![@t&fhkal萸~!q \![e^@cj>^N߆fhhBj
Vn a0jfFtfh>#$h"o1rpr jnn 6znauFn*()h'u
vnuxuxun-^a,|ux}juhX'P#`t
 &[]`t &Rks\c뀻&Ҕ^@@ut˶ɋ߃;>Prhh,Q~ \Z& *䣄\Pe1 u$  1 j h(thfP~3  t~@ 6&` >.B7  .! j 6\z`u.&& .jr`ԑ&6>rƌ@ F %@@ህ g4 Dt,-
t%-.t,-	 tE-
tY- Ht- t/C D :>~Pqst{}ԝ  諂!pcPYaVfPvfhI
 NPu h Ɏ؋F&?:tF&<:uFF
*?0N&$P^

u!Ќ2&a @"F ~ uF	 F
  
Ѫ<  v誂Pj^P&QRPCP! ;
~@K~ tgh~Pva~ tDe=ި=u5 21Ъ ^3 FPP  PF9Fr QF-
 ؋v v sd ƨu= w;ː:FR^jv̂̋~ 	P !qRz~ ~ t`F@az  R~  F :© .ª "« ¬ 
҅­Aį
~dzP߃t րr{୊C|hs3^8@3V .t}Cau^GCquK  KP.Qȧ I Nr@~u8 W Ԧ Io 8pFVaF^ =ugF 	NS' 	ݗÐWV(a$ < upkX@@<@u`X憅??Vhrb hrhbݽt106P16 0Eiu4-6aUFi!!99!94d\FE/} F9 "\D᠁Y&Xy˲~F pcp67 F tHt
4uЌ4v jǔ@3t@uf4߮;F~1с:rN@uOPhh4e `4WV30W2
Gor@P~At&   w : MHzKB  (  +0SIMPLO  MOTOROLA  HP  1.27!drivelock C Computer Setup  <F1=Help> File ystem Information  Disp_lay siiSave to floppyconfigur'	 diskette Restore fromU	E;
6defaults.:
  Ign
hanges and exit E  s withou@aving%	MoV Securit	Administ
or password S
e a?RPower-Onp
?Deviced!D0J$DL so&@martCard()BIOS support)s Embedded`."4#e/1et"	acps Tools Ba  4CalibD5th!lect /b35 HDD`lf-TP ops Act+iv6 k8OT95Statu1&47 sR<AdvancepLPuagb7 l?Dem9JA of gray /1field Boo'9bZD!D5#GPresy key!	0
`4ue F10=C@, EoSC=C1?l JJKAccepK=YesNNo KA, AIoZ7rI=M rP<K!  Us	 7arrowI6o? highlT`3he appropri:menu ipRI<ENTER> 0	begin&
7C9.gSfollow@eT5
UBR9: -> SPACE = Nexra4-]BAC9K^@Ivio >^FTABU^C4?SHIFT+cb` cCJP^CNaKP^K'g5 ETr This6=cann`Db
u6d An ej ocp0r /whfl.j 
de 0x01 je kn8PX45aWent  7 k>Cprequinpn%5Xd baSmu9@lmov`?0	 leEk/MEU Oti0`lQW !l?m_n{o2iE<icle7suPNssful|Manu3 r  N4xPwd!LProqtypspe`?tepp_Cac!7ize (L1/L2) PA4 ROM R!sAfa3mi|bo)`se Vl nu.ЃVideo KeySQJr\Z@verD)v$܍d651̍%5I2R53R54̍H}F=ߚߜlef l/r2UQ3a0_Fownhi)pa(UJdPg7畏3P7l ?دOoϠ_,د$5!@0
d9a=պBSNa;%$1?ʽ2?ʽ3?ɽME?ʽC?ʽVǟǟ24?ؽTV?ʽ?ѺDл?ջïS?ٻFt	W7arn: kULqllo JBU `W`QJ rsB7T0Jre:a /F,levinЍtwabL 0	 A: 'r|\B(` waptt7)6%d` r0xInAv5/P<!@aAyou0,warto  PIrR:
?  ipC  ppe8 8 81 (QuisckP82 (?rehensU3 (S.M.A.R.T.) Egsti /ex
imЈ`): 30"@09XUgRI.a0%sBe.d`pp7y hoPsp|up7%	j:h't27f-&Un3knp3ila\5yW=Serv3[Rea0tDsdolD,8@L@.05ribP: &P^LApsoexp W9b,. g Ol*ew=Vfy n<bEncOff OyPP Ou Pp+PcWroБ + rpvsfAd1rB|+s 1XrrC9UYO%< als2a=AYr2J+SmartCf* W , ifQW`ly  "aPcPC4Ja%PIaXloss  C8>Yh#ou0q 9n1Xޡvof axgo0qqHev` rj49>DoishJbed?G power!-P9HL vB?Blank B70/ RDIS!Wim1t@ S/,P0QvЎs "c'DAQtYPAOnW) e*s. F92|p5TY4pZN ;ndА \unuB.s9n4t0.Pfra!}UParaUs Slot M`iPVfY Fn_+F2 W tlGnet*C
[ tyCD-!`xW ^Pp`p
`3_4K&UЍd6V abou5h` uRPB?OQP bot`>`US{ER2FMASTk@N*QQF	hpzCan1&SpcbRClߵAFkeep ia,0o}cyphysi0y1sep0WaQbR%x  Pr. I``:p5k'r,BLl}n b3e F"'unPt On1/Qqke*b&i b@E=mea,@k0@p@ib ty. Ifdo22i,Q15QESCE.  >2h9 #typ*'&i'2FPtQF10R YrmLd# |2Kő2ѨEngl@>4C!^bY Or R:wCay0wh5 (Q"ң) USB]c`!Suo֟ZchFirPc hiFpRthif`Ssixѣ:h EapNh0Num RD U␷!^ SwapZ/Ct;rlEs KEHCU.SbY@d ޲legacpu(0pYl0ro`Wr0@I
nUpcpPf VJo  g oNTSC`cALr-J²-MWa'9t@FBid0\Lal EPP ECPԱ@3size 32 MB 64R  Jon Alway> n whi-PACL2QìAg1A oag 0;`ϛq) ktomP
ƘEPr[UƠ`2_3Tokp9RL8 8L˵\`O ]\pbUnique7 Idif uceBPe3  @tu0@Oo QSRpCbu(/NscHPP7;D$ !;BboBq8@f/OhXH@F -ݯ/oz;L MEUoݏO/;R a/	o/

;[0s1 : C ~gX% ]4ДoCpwle_d!2 i 5 Ed3 q3D8F|* " !"Oo
$
yqcs P pl  Sp> ghnology Au`ŀtcL3Frez\adapqd^PXE RPL ExPopup De(@0 _10  2434U44546474AAFF1235 154838bުB0kouchpa0PS -CNon_<F1=Hilfe>@itinpLp=aMgzeiIufO peicq [ KQgu"a@rAVTfCwie R(p@`Wn<BvDEnEeinFunp@/H6-kZB~ERCJignorieQSd|RNnAt pneh 0OANAO_SuTSet3TSAheitsfunkvt>Ad0?istu.\ennpt_YqZ LOФnlt-KEZ\
\ Gerteu4XO`m_-IDهcm_&i0]ebtC]r  sttz@J fr GiBIOS]Oi |_gOuXooDXvorrQ@Jp/b@OIaJzurc5k z@ExYAkkukOrKxtPCsgewhltϡx DD-Selbsspt>xtivO`H {Yx١ZP@SzPsz'{wrwpXSySpraAz{1Yn`Z3@gran Felds1rt-O|o_@`|dpwi0ine liebaTѐ, 0`? kgfah\`6=A, ESC=Ab%b h@Wr]kze|O_JaNI@), JEm=Meh8*< VePqPzҍz0Mark} s2qzMen| dPfeGilt!Pdx<@^gabe2bmp~KB~0w0Pt0?.fol`J0n EBO!r:P-> 1r LeoA = NchA^Jִ<-éRqwchritt-VoMaoTabulYs2 [Holl+Cge4a6= NQrEscNleizr kanUQxt we@vei~yAkY0PrCgetrn.Dc1 0A`}PN0PfipPt  k{FАk1W ,selYomvEorMgAker`?`HlAxx~Desk|e-HsIbtmu2@wƀas1-bzw.Mobih@gtza.yAkpr@@ti @RPp2yp*qlgrA abchloAs Epje--!/ll)z)typurb1rwiIgppSSarC1-@+A-Gre (L1/L2P4%kapazit@OM-R9sFami ~SLp0@Zumm`ne- Grafik sB r-Cond9 6"=*Rm1_ 2 3 4-{/qClinkow/
QQncLap9si0w"Z(Fhw @Jqz4	 
!\9oO JZ/ gatk P!r$DQ:G$ 0st0j0nO bissGn``]`EEԧX̇-/WE%мCleaJbrQ AeikqG@yL C k A:&nfw+l*dQg	eXPK"*++(jgl%p%$&G LO'
3  `34/uq@MaÍwirkɢKH'B՝M?oUCDS|ҍ`, daэ8*@\OieqJ!  @AB/@fTD{  T  1 (nvK2 (UmfadGr߄)fhdau`n(Min?.): 30E|r<dzNt .0%T#aԢKڄKwu@v`m HoH ֠Ѱ|puK<Uujcbr": P𨽈QXUnbeQnsX(,Xrvo--]L,~PU/XjpshafAttribuIDAt mP\ju` .M.A.R.T.feqő .cj APsmm Neuk6lRs" Deat} n@ JakEUm3U-QCt Faqlq(mrgeb!} lElm2R#BCä11`dmin01oRSt Dur@ŇnPez`"Q  agG'HoЄ#3'Bn.(cg1d1f1pSmC=Flρ@, sofyЛp n waz.0s Zuq f=
;Q"enlust9. #b s %<an00gsls^vice;a s p,010FmȠ h0QL@gaT 9 ;tfa ) @"El-;c#ƅ k QuickLockqSMu@ndݰ F.rre"IMs alѼ@n1lbiPt H1<chutzFm1<r`5p~l.4Blx !aav, l`rmehr aRҗq  k| Q!L  wInfot-\Pare.,DrahtNQ-e "k"Tm@CD- 缆,7@Xst,1p-2_p-3p-@TѺrƅ:nЧCa<m;¾rive6'()q׀ꤕ P!s -ls mPzp<X)unb}rAbar. C<IdǇq,"IbsewSs a@T`aS,rt`DnP zp%݁`W`, ZpQlǶU[,  p#6o&zuwnVȑ6zp#-Uwpn raXRdepitantlYڧdZ}FዡXTG Esc-º8AnB $StWm''6q F104<A:]Cvf0Vg gV[大RvwcD(q:riX1TvMu2Bay7`F6 (1sO o (BUSB5--0bSu0&nZip 1U2345U6789Num-Fun^nons-Ќt`g[n/Str	gatZX|>TEngli MSAf-Ze "gera	Bpiebssrunabhng2ڃGrafik-ContrEpaIca$ PrimraaVideo-N!$inBidireal GrpGs@s g  L eamf tzbs 2˃zg`Tss E0g`yparP.b(o0)()+cp++EtH pf ./02t3,ToR06 8_39855o8 >T_@Apq-I tiayB0okuFRIJ  OLoMNHOaIR KalibѝpdPU%KMavkVST_Y%KNc0hiXDual1\Rl\ `OVkW_dZ[ h?^X_hlObkck pfc_Gicstmlcwt
rTr}ariff-I _ivS~xkW_}[L@#Foobi{ uIS/t@τWt
rR /pIS,oa/&?}[r 1 : Lara.LK% ]/abb`2^Entl @;O
35sӡI/5*7  /oc=oH?ovHProz or- 0#&utomFO Le?gacy-fR5Dadap jBootmRzGExp&--Popup ( .); Wdau@#G|F12 (Z 0 LCompropstnp= <F1=Hjlp>  FQ4Xoplsys`Vis@#ne G`tilpc 1#konf rF J9G fra1@U prٴКgnor@#ndr ofsluH"" ut #7dOtӆne0khed Administ oradQskoP K at4A fo@bŨP#FE<d'eX-iAfX:SmC١-	pls@f F BIOS&r5Gi?dlsAAfMaSkspEl	 eaBA	" &CSd5valgb8HDD-selvPR_tr 
@sK Avanc! Sprog Vl9s2Bmonnedt(t felP_O,Tryk p tCast=, ESC=AnnulrFGod =d=JaNej "2, A=M 3#vb Brug pP@A`eA?  rele0_menup,tt<ENTER> d"eӡget. Q&f `d'$`: -> e MELLEMRU?M = NI0<-D1TILB'AGE@2@rE2TABF27KKIFT+3747cK~= Acce  ;t sfejl`k`qsPod!@!Geng. F0@r01RBaqAno@-U $plaaBkwrv`vek@
#:@i dp?3s fKly
sCnPF/MEU?ED{ b( uve=tbrudP_oBDCD2Z?
Pv0mf퐅0 QducpQѾcN#typpgZh ighZptr(cache (L1/L2ʞ]hukop ROM-familie4k!@f!iP)V@oIbQs,&
r-controDK-bascIgdPc%jI2jG3lG4c5HlFeth pIgrh h`Q8Urghjw,q=at-taej |e(aCt)j{kO3 n{o{qs| uvy/g{Ce0搜dv;ar@
: DG s&P  alt0P˲2holdҰ@oǀ
@/ .Lb)-Ldd,@r bAkbeskAMK
r QA:@d#@UԜPbAfS4RbPҨVoUgyldigatm  ?ng#iv0ud,PviP@!.4ٜ? i܈B?;ᐫj
 
yT
j(Hur0\9)Omfq
@.)Шslb 5 (): 30hT
E  .:?0% frudqXP{, ɰ	QHD: K5AT
B!U!@@S#@$ervdԿLsp
ribut: ID@2tERf,S.M.A.R.T.'Qy!.3@NyZ BeHft; n<Dea

o Fral # %E( B   Q+Ls@C' /EЦHo$dbdG2qYbI dБgsLrpKS80 hv0zsG
@ tbhECmetabata. Du bSu NꡡMflaqPY:D1`viceh@ap-D"P0) 02~*OT  QuickLKKpauN`Lse!m	vS
T4q"bt w!'  :. H""ur@qD1m 4h``,AdiPaFQges. KHStl pfrardIAdl0pkVnapp0$Cd-rom-NódMHa 1%*2h3h4#`Ho:2&e1uAh,rr D^ zbP.BRUGER-A HOVEDADGANGSKODEN,rX@.u al`gqJ 05np- n#@d,Aopbe@XFP蠞S P"# A_#'Mat l^$f 0,]uw耙ebiQna. ubA,L,tryqA@G= |!TL or '' 12e4rH;F10'?s4hLSհVD_s^EVQD 8k Osrflgpcu=gMultiBay (v)KLry) USB-flop#pyecOcbxOKOsupeIOzipbF0qnedjF }AFajSy0M@O NzATXNum -¼b
'iPـ` Fn/CGtrl#<QHEl (a@qi
sk)  g;egeenuUARuN*PnP^mfe1~b PrimaeVideo Out ParaɓZ TzjPFStrF;vQfhuko A BlܰLd t@nr? compu0pE1k uaiekpvmH|L2- UdiQ+mstypqFLtop^qLb0M2rEthksvv@lsTop Rq vzxzyTvUxUEntPPgt id-nu"scɆSPFo|φKalibqό1nd W ogc Z%>L0N/? O˓
LbOmO ˓?/Mion&??_HagsO_Ͻ˓oƯ
V|CMi moburp@@L(MEU)/O˓ ϏdaO_Ӱ _מۖԣ[Pin 1 : Opla!s .㠇% ]H\
nemt
2 AfRf,93 GenoCu;;C *`pE a ϨN6Processor AutoAmR/p7bP*%l  Legac?y-freeZhm7c6 !EI'Hurtirtpopup`CsinkRG(sek.^aCA)A2D-a_U`>b_gge Pp_p07 
 Konfigu datamas  <F1=Hjelpm> bilinjon0fp' om s`LagPbkpEvHefraSp`Z0HdimaCk@<0p&@rQa/vsluAA#
,8l2FOAo sprogra0@[6t Ad`,ratoGrpaa&&OpTI&A FZ:)U yrs60|v,sfunk2u,5atif p^c@i0(b5:-&H1&RC3.n SmC KV4h@RC7 BIOSh_4Pb7Iby
@p,<P._,i?>0Tilbake:1lcfab`^PMB rkty  pval1g 9$aAlc𹰰"9Kmvt`B AkrG`G<HqDѹus"9E%v^e!Sprklg $O Dem$p&P 3dtPel+ I91*S+S'It/Trykkp" D\"9!9P?@  =O, ESC=Avbry0A\ [\Ampco^J=a`Nei \2, PQ [er=QM\
 ckXnepilcne  #trZ<ENTER> hvp/du v 'Xt. Brukfh0i:  -> eBr MELLOMROM = N`B@C <-dnTILBAKE`o ri9gojTABfoS>WHIFT+Strxus!= Goŀ]s\q@'sfehF0} unkaP 1!nMop`M @j# M`m kjresqveHm0d"*~BeFPpNq$sba`?afly@srp7 dn 2 ݅19:~a0]vfull}". akode 02Y|`/a2}du`?t Noblokk-m0llqtyp
uh [iig,f-ga*yvqbuff(L1/L2Meng@@(f4a!-cHQePdeoT [LrNtronSG,qkobDbAJ,qo{%1Nߢi 2/R3*R4,hk5nV6Or^pڨy/K3di!9 E@019\s([p 贘O 贜ɫʴ߯$^Eka&%AdH: DÀs`slr tidlPrs@hCol0fTHkQ "/h2e7-  , [PMuZ s`klAk3nnA:5"}DW bBregq(ObiXU?gyldigSS PF+*ESMhS-Pmt0"BF?cBs,q ignol"te?" l HJT`B 1 (R)*sl }(@(): 30a|Hpgr .w0%ƍst*Amv0F6a: Ka!utp -VK#Ukjr1}#Sae'}oLesؠ8Trib: ID`o017}s1# S.M.A.R.TC.-#].G  G%&N P
kreft -n:Av`aP&@mAb5a)av-likt 	!'Du a**/(!'C[RaM 9iaPa4IBqk d6ssLrph=/Ofb8s75 #  v,k61@ B!BD1 cp1Rin@[0.5  bkuZB  m@m5sn| Ovice.~  9u$"O%PLlk[?-VIvUvlsrpla1n1paus L`m MuU@OI gir bebbesk! @R0-e. D  b(rdnglej=p, &eŇK#reAJ(6m57aNp[frar{d-EPara'llETrdlRtk Knapprt>ISU `F CD-0o7%L޲"ާ Ho (:rjen hvalgtp[U;ZQ fh1>@snC?  b@BRUKER<HOVED-(pl:Aumup!RBшU;@SCIdW@m g0be　@0g  Ro`XAmc_F2  ]W-pAa6C>D?V, ~ik Dh\Bc+ @2eA< xZt<'d.T׀s0jSflq [Em, _bz-5c2 _qpr`ar'DLock'Rjr FC10s\w#be:zO
 LUm|e!ҷNorpS7iF7O0reBo MultiBayWÇVσn
7()O@ֆr߇USBuTCLaSQ Zip4,A AȠN`um xt6B1PFn/CtKrlsepE $}l0j(USA)>@ekeenaPq%el`Ԕsre/~  15Jp:GTvOis7rr;郗@=p i {0`BБB#m626AgssP\sty1fxߥ/ (v3bo\ Eth/@ϧW?ːuu3`oR19IsP!op0_nip`Ztifiq٢JBD L  P.ɀEy_m:_ plib_ʂB&̐/Iаplal -̯O ioOopOՀ܏iϯߏگ@ksp.a//ifnd _Z//s mob. x̯<<o <?щyk=k R[ T 9n: Lara.J % ]aMfull +RC2%9-
J
30 ig'jenn?*19  _P'ros uqU@oUPP&<nd`[HrMiWK@Ɂ#5FinkzS0 (sepB ay<FG12-zv+1-.0bP:Sepute PPpConfiguraci` lLomP1adora <F1=Ayuda>8rchivo1Form2l S&Q?ma=r(5
s6Gu`[P^Rco flexi	b@k9cZ2RP69K Rja2`s'o9g=+;>+?Qo  pr[finidoo?2bCadMX8 Ign 4 ;ambios y s0H3+;`T g:H @:HKH^I e2idad1207seMFadPdr3 72;PAQP(icioOR=UO3posi Vs_XsYIDc28HV P35¦\FP`tP6w]sS
a\` Smp(C' o p>b BIOS[eOVgeGXincor pF#[]kmYnb=`:cP3+;Xfbr\ He_rramiPaqC2er] 3uvZ rUaFAx0CXAutoprueba HDDB4c RxyEP( !A23`rvPB(P6QB}waoAvanz3`GdioAGS8x`7Dem7OiRIampmco C gr	{Ubo	{Yt߇/ DOprimfpq;uitecP3fin9-=(, ESC=Cancel4a`_=Acep`(=SⳔNVqI, Croa~=M 4 U+blBe:chThaAr al`(  ~lemPo apropi|l `0Ny1<INTR'O> f`zRr\R^n.s2t0CfTi y:
Esp2o o -> = Prx2ORetroocesa<-K2a)i RTABS3
 M_ays+CR
_ P.0D'Kppӑ&KErr0(Fu`o~ [rPų&P(6vSfr*jo u;S2Q|r7u. Cd,3÷01hay n@un<!Cub\O`)i0#CAfAb!)2ɻv+Xaco
tԬ i"w$ebook/MEUoO)uF7Emat2b?_q2|ڳ)uPple3~xitosaae Fas!6@8}aftil CTisНRVPUcZlGTu5Tama}mprpà\h (L1/L2/iqvis2ROM PmilpA81ȦXqrC8Np#mriyl v^VV@6rOl328`oFbgi1$Z2Z3Zy4anijrU EviOoo&izFr+Etiqu03 ursPH)ҝeZL(Ïa//F@'	?
Q̟]
3
 ?7/_ owZ? o o !$Q }:8E(sn@9a9@m9FAAd.0ten`:fzdA~uir~  SeCfaaA7. PfreRSAz9/f=, in `0SAscrid"CuC [A:7\A{+$}UU5ÀZ𛀰(̑0,cLA4G5s+@~tegA/S84s+1A90CvlC)Dusan0|+I3|65M@4@vaѴrQe9ƀK|Zo(a) p%-eaQ@rHa?gnlIK iTNl@ĲirN*Ųg*oQRyPy1 (RpZ)V2 (CΦW3 (S.M.A.R.T.) ClcuctiedejBs(`I{s): 30U@Нg`o .&0%ΆVbt΀Vf`l(lipalViruamaWbcB: :#pu I[Qa{|fFal`} .rh84fServofi 8P9apoyaxya4katr{ib{: IDCa~xtAT&os Ya.tqseaaunuevifР^vDpz^dyApagQEБndASw,t:²wt=evocRaMv(a0pРow} LDu(ad`I)pՐe Pa*ceֵ`iq9inhab0#LĄ, tѲnp. LOԂ.i :ps(oѐ4us @6SmartC*, asAo_q,(  lt 19м c>f`ha <ci`@oHI4fq НA3pr0{rinr S$bf:*l±`a- olPBx1vu vi@.qo   yPKs*? 
OPonдv Tas2݈  QuickLock1+Susp{en Blop%8NdRrat@qKSIϒPc +Q`mejpN`ϡ`TwȪ
y. ӟ0Pr4th,A9pkodp.u@izF(psR w@qreŮ Pu,=A@U ArojoU!lTmDR{edalmCBoQHzI4CD-2ƭDE U41+|6dmdpJA ʐݰ
̐͐RpPPUc:tvUs*io:= u>F?  medi/QDriveѫҷ $ЍUSUARIO3PRINCIPALp.J 0m@>vg 5Pqp@I`d. An0>ˈ y gu L`3lugNOJ`2  pj!ũmpg . ElBE  ,@Sg!g1 .b F @چtfi RBc&pde맱i awqKponsR.`P9#KTy, n L ESC. 0g y34@Yalab''9 F10ps@YS:<Fcӆ/faa@'Ӏrpa_Espaol O؂MuBaFP% мl
&()? (#);USB ƃs+a`6L`SuP0kdmZipme AB TercC*%q%0x%Spo O :vANoСADa0A0-Cl ?o Numm槮 C|es Fn/	TIngls (EE.UU0ZP0posipyauqmaPSe z"m&԰um(@Cd*Aӡcd-PReo MoPgA  BidiᦰcTsam4mem ". qѡi+=s![fu0|2 cuB=":KCApsAnN0>_book e
2{4egePkospaB/o,:' (sq)<>4?Eth,et,9<>EBˏCDPͯEDG!>To=k`RingoEJ GMIEO1PQ2_RQ3 I`	tw\Exclusyak%TAP0<Y^#XeeZC .`a[mYNc]Co^_oyP "Yah1bu@q ?]df`aohcds:b

Z.gn_i@jq_cd?To_p x8yOsk?{S|vuk pyozρro}o<OvdMEU v^U _ߌ??d[ p1 :rgB7.Z% ]po , 1d2"&u(=CleteU35D[rl*` at?kfN>ha Nq;Q)8utom2cqRblB7 7P`/L@(cy L]e Arr#anܑЭp2+ s/	4tD3p1gAWEx6(%SF12?%U&Af@'Ambos Tou7chP PԁN0Pu`"a3#  <F1=Ajuda>8rInfo )so` oD40i+q.ma  ƒp7HRQrtQvw`Ưpadrpxac%4 Ign`l ,Se saCirp.Ѵs0s٦ܤm\nana:ҵŀT &TDr &$'pr Ub0/_d|%e+ SP-tdQ'<B*BIOSs /8+a;~embuti#DPfb 0Femas!pg1 ,i` +S`ӄ &le6@OpT X6;HDD A!r 
 Stateu@*aWAvq26S5Qiop4An!;;cam=p cinzA#w!lizow0e;ss6e qPf  "@tin =gDSC=Cancela!AAcceBim#qNA!, Quou "=Mail U 5izTAsc	%`d  o ib aprop@3#0u1<ENTEwR> Tmer8୰o. gu Fr ub':P -> 0PAO =PxibK<-,BACK`,CE,a1A+ZTAB,oS0SH/IFT+1CsE00=XjZS1C3SErXna0obPV9QT.? Cdig2 o 0KN;h';koPQ"=3 @sp0i2;CA A(;~ev#< nsf`0Zo notebook!/AS8:eP$0m	e=?>U?2	:rrڟm xiX el2NH  Ti`#!C"VPScG0T\V Tahrcache (L1/Li2Xa`$m ROM vis>Faml [[a`cBǴsri2VSF]o vdeV3eraro@r_]E1a  e"fd3
?_huiHO/jfi3kHi4mlgo	`qsfhre?v#fw'siryfEtiep3w_	#eVSo7(P)~ ?υO/m op/O s/}~/yOz //}O#fඔAdvertnP: :T̰
) #eaD0*Ac*QԠ/,si@um 5 gravv@@Eun&UA:9IUӬA: n`foi0pqSӬ ТPKb"EOgTtegsba"S浬vlӧIg ˭T0pKtezxrЬ"eja S?oء$C iأߐ #1 (RpZ22 (ANngL3 (S.M.A.R.T.4A?xeCcu
 -@c(.): 30aa#nd.v70%2qbuced#ʐ"QVQShost"romQג9: I 4ss !eFalAhP!kj er0mec0l0A  1srH- triPR_fD,?9;exa@с`)s A
I.!0igqovaif" rHGaRlL   HD&!irrQrig#$cis4Qgp ```A@cAd@А^KcBa%mo	ds7r)at4tamb	qFdt)PMq HeG1mCard$Q5,! KvisLp$P A'sXfbr0@Yus  0pformB.[@`& qMaapK ,SHb_ios'. IaW v`A 
a? O f/[p1-QuickLockH Suspenso Blo`Ьےc$ouТ 'S~? ;auC Б"	xRb  
 c.@ !Uss impPrusW^. Exig u;0!4Pp!E)p@ermeT)Il8b
'Re<Q0{Botʣ r-I!RCD-\/0'G$-˯ rR1452653854 PhT me:4usuaC: Voc`וT0um׭dq"5uti!n@c rive# V$ tP0USURIOqRD  MESTRE0pR 	@53 P`aXxLapaz= s. An` v8Fde- 0U*bPisP
!10p D`. NvPwCj t=,MMpo$P]"sbP5?5I 3/fha&=.3#bB  Lembre'-sevґQa >sab Aq!"hB,!ssione ESC. p%cppgclav'B'@dRceFg10.e jX"br:GMr< *[RG hB*a)ugus O$q  1: Mu?ltibay+9D#IvB!wA(՚А̯yz)USB@5R6ȯzipPrime[irrcQR£аOvN l@c`  `w!лa1Ds Fn/CtrlR)tIngls (E.U@V=`
iasi 0Q>QSh @3oxdeo1]E`2=c7unda#Mo@+PB .eick*TaJ=hmemҞ#Op㐲0.0 fu l B  CquB`o0CCA"e|2wGer0gxdnergV|1J|D{`?|peEtnetK࢏>0Ϭ3ϮíToken Ringﱯ/ϰ-_IdD oᭇ Ba ٠Statusv&S'|C!`|qPD ?gemƢS҄flq\Cr`rвDup ted= _е_̓vOn ȿɟ7aèAzϿɿAlP~_ #1VU_ogD~//[ EtK 1:rregB.C % 1]Ptle2:  @2N
%3: Re	3-"* 8 v ? w_;ν > NmeO&`;iQflexvec@H%11dap9Q/KRrPopupu sExd Segl0NF12&(O~ϋs VsarQfa N<u0Tietok𜐲@tuk/ <F1=Ohje>.dosJrjp<elmt0t Nyt j1Tallenlevykkee@4D4k /on`o4P@jQ4Ctv76r8v7o/73n3;sG9 {Oh~ muu// j4opLP?/PDA4ttw>`!&4>_B?po u 02/ 1Durv04isuy1n~Gvojan Lasa Mri2_I KynEn yPJvJkL LaPmtGJlOH tuMusnutJ?S3g-IgTVt lykiIYti-BIOSwWukivTY-/7et FsuIaHO_QvTsT_uI`/</7tehd J/Tykalu_Ak c0f`o@iW  Kg Kibaf Ki@0=v#ytoPZ^O92tf?i/f7 N@kJh!Fa2Lis/KiGeli0-phkp2eq harm9a H1rkiPMqN𙄰sL//N/Ox^
Q^Jatksin`Asjotpz npp@)=q, ESC=Per C!|z|=Hyvksy_~=KyllEi |?, OJokuCu{=o:|0qnuoli{mi@Bhkd 1h@f`Asi/sEqz <ENTER> mTtec.L2/n ÉyQs seuraavv5: ->@i VLINPPIN =|4@s  <-ASKELPALAUTrEd 5inu/pHARKA{s8$VAIHTO+GGt\!)= C4}xgvirh%Akkua e0hoifda.̧gE: r`9dig 01Ҟ`zkaP10=h apnrt6F p ]NygtkeІPskoptaaЊsip`Q_dlak!s0qG 7FsFkantIlaaj`4us`ikkpksskeytyi `4enBi`gɡ2nPZmoc]_pmaGj1DHFzip`q tyyppgn?C`allaHVlimu i (L1/L2)Mf /  ROM-P`PMýUotepeEm /2Zssi	.sarIT2kNDstohjaRkK1uspngkoh
1:|ƒ23o4Kahvp^f IFϝno_OIoike<"t\.oDv.(jzoa) ˟ߓ( ڮнҏտ`QJ1hkraϓohs: TmbEa4:latpnsnh32. J+>t luo@pdus-  4n,/ 9irj2aaAon3p#IA: LsH1h uy 1S2[.h@@paBAcG;HRko!iPzbj=n?j[>c?a
 @BoD  @?B?i11G (N2`3@).M.A.R.T.)ArviD  (min): 30iNs .0%cȀzoSgIstӥys1ki diJwV7SR unt` Ke*$Servomootytp*$LukuuL1tuaqk }kp^ttribAtiR#p @0`sAa *eKe n .0A0I Uu$JV0A PH1 PbkAtj3g45" ЁV``J"CA1 =00h\`tca 2:A-s/1UoЍ9nAokk аaad an KIHInDї<4Umyspn@ c^Fu4SGo]U0/G, {s  F_aiQV5Te pE
EUd^rpniMA unQnafhKyP vePfapahtum`?pi!dQa8^uCI\mn QuickLogck 1L h0lupsEv! Q<2" MG5dBNdq%k,PzraE Gv-AD DdWta.s"UdQȲonCt,`h!0QQO1.@A:uuq єFvtS1pInfrapunrRr峈PxLang#tvto2 RWin o CD- -lZ]d!z,bLv 1 }2~3~4rdPC6j/AiotL"n D 'e`($Tb) -?ll#k  k0ek KYTTJN|U! PS?SANAN,n goh).$a 0KhsislyP] gturBelѰs0ri7@/2tP:3kUlVRK-UK,ap3
D؄3LLAqhQ\W gKpHGU?BU4O eqopLȀ##o$kTDBCb,|=ESC-n3kF[nmT0J=''qhcs ?en F10~;daar
ƞ:ف p@]u  O`&IO1mi6ghysMultiBayKw)ַ (n/Dr) USBy 2@yp2IAZip?Ensimm@yTP Kol `eljp8Vi`Yp8KB8eit  dek0P 9YKym YwNum2p7bVai Fn_/CtrlmA8`QEng_@ o(USA0UsP: ;sinl0Bsd0\0nI@Uja0aaG Si QXnsiQsV`Yolh<tt8 pukio	sANrfCm!@a Q%`uuP0KDrIUcw%RǓ|2-l(qVaВ$PPg?ߋ1yi@] /M- 9 (ylos?WR#bEt'her𓔇t. 5PoyY3To= @tgzrxwork1 wo p/O L rilivX+!c Akku
WTauC ``
4	PWjoplib"8 ?dp}pDual0-o@	"+b_! "O%_*O'O) _.O#+.-'1 2+'56/+v0\:;?4P5=B 7'AF;< #aa}ka :_@tA/JOKeLDN /OFLHIRҽ/LOM VWPQ/[JXT+[ e0:Xa !f.=d% ] bcv	e2Rf`lj puregbhj'dMe/k{ge3_fA`} Åbpr%dMeOsht"|g*@yX AyBr ˰umerIn  SpeedStep  tech ogy AutoցI^9烾gacy Freeǵ "r9k֠avu #Pysi@  ( PeP@p S`@:<PF12: iPStappiAkoske  -0mma0K<  Ei mn Configuratioordteur  <F1=A`> Fichi;erP|forp `mAffage /ASauvPrderr disquzezla czK RqPlr x` `'unewA.ؚ(eals dfau0/ǡ {duIgnoŠmodiquБS`e l'in஠ap9=regЮ
ϫﬡ ScuP{essadﱮ eҠPųp?e sous}ఱHk*on.  pripqh:a s5ĪID٤I'4+qsWDr`;AļSm 	Cp֢9? BIOS ? gre+ Dsfaf͏Rtabql@amЮ`'us Out onnqa b~erieԪ sle-cn@p0osФБA`oEtaBՃp]P0 AcangP ChoiqswIndmps grPpdr E۪'~ Appuyn1toupoPd0u@=SVer, ECHAP=ASl |M2AccepO0=OuiN갱 Q, N'imqe`w=`~rA  UPzs Mfheamyrcle :{ucer@p@briP1z1 <ENTREE>C2cCDsui0Ft  1C :u-> ou BARRE ESPACE = EPAe-̄0IEPprecede
>GTABCA	:GMAJ+_G@ e!rr  Il 1ssibac Ua3s'pro9dpendP^. Co'01`ucFn`1 e?mplace{L'x!# Qrep7!s"$d'accueil dFpz G"(. itxCbiQ ]ep#!pu@/Oo2S&-a ru Fac	M<P, Typ1cepV1r ]9Db);Ta-ca(L1/L2) Vol{moiVerb,ROMP7mB=A@RevPН Numroϑ)-FAvida0|?=raaclavC`o@!)DHA H0 K
p4N
3P\4/R\amov1_Tz8HJ0՟YZMga\]WxAbinv#?-B1pri 
e

(te)dLiNkQ?n ?Sp_UtVrW8ou a[Oxoy_#`{|ovc/BV%ede p!# : CR9r0e0tru?@ie `Ųbц`Pb ΃gϖ /a, rnroтrc  3($Aa$`eL$v !tro  Pa 'ϓ`cvT1A QOo0F!v#a!2+.H0 
:;f 3@0f<es-vA0hflp?  @ ? Igno7IiP%Э EnregAe? T1 (rap)2 w(co"et)@u +0Рimj(@/)30c`s .
0% =vr7" 戠l'h"00-D$:ú!'Âc nuFd'ƜvEmæL sKupSppAibQȑ: ID! $ex@	Pגs S.M.A.R.ToAban .cC A2`s``ai VfGn?1saґڂsAA MKarA`  nۇYP!a!Ae@7Xܐ0cQ#/ײ)mme, vֱKJad@/QPJpobligatr?#%S&d؄; $[s@(7 i됊̎
S@tCu;   si0pF pesrf0EAѠamp	ɨala p Sfsor/Q. Nuāz40F  avPoubliq	:p
AsrS4>z㩱%	D@O2Cd@#` ?q%s4, QuickLwock1sus!2 E @=tG1w
Fri`ݐ,3S q#/ԡ,QreQc%Ҵ
)";. L'A (PGg9 `draB DExiigu %dIP"a !@ra8  ll9$^ Rssq?fil Bo @8\%ECD-A'E6cMh+ p4h+Rh+0TJހfpalJ4:@2i Ԙ0@Dr 1. Sdez deux(UTILISATEUR1PRINCIPAL),  #g530ѠGalors  X Nz @%;1P`1q80sr fe`rceluR  @ordiynCue. Au  P 7\@A(: qJ; p=3<et9 +(:"15QP: tP&@asMp`ab u62p낖5, appuyP  PW ECHAP. "e\0];OzS'5', puiP>]r1^^F10TapPbRrm Д2aRN/ge\U Fr/anacOI MultiBayjwh+|w/pBq(~st<u) UnAUSB
c("{h+:{Zip"{PremV D8iRTsQuaQCinpQSixi  Se0! HNeuvDQMo A
 num!   Permĳ^s Fn/WCtr'C# nAnglPn :SA7) Pph•oQmpйs Anc@Fechn0{ad  eltr)uf@h`n !rimaPdDiЪid0#BideP mmŔQӔVVlPWj PWRT`j  rQ)up21xbloc-nDP>Ga1яaR1vq1
OϞ䏤q(́!ur):xccue'"0"ǩBV EthtPzf,$,ϰ$-To=k Ring* _9`b%պ߷պ-IdVlu TTe!m4?^ÐP @ǦhUɼlъonQrepP>o̟XAbsߑ@xAXDu  0!q*̟Կ?Y ?_pb ڟޣ moM/80gn Ye SvD1zexDpZ_? YП y	 MOo
/O
!+[ape 1 : C.m%c ]mmi02PDӝ)Pm3PR   O!*`%	  a%?'܀OH?-.NumroSroceJG AutoaUzrzqBlib GLegacy AmorocYY3B7 Retardu$7expYW) DpQeQBF12T;rposPfbi a{qaux`atQ`W!>3cun I`Xzpql2X <_F1=Ai3>nfoPUBema#=l0qЫDESalvap[l floppyHhpBHzvttoHRipPtina dPH(LILK(Lifap
LI ;pQizLEIg'norNqid^ed esci 9EVLl'iYBPz1HnU5IUip&IZWtupicizza?sswo:ePWam<@rato! Ji_%`^Лcc #z`1l?cQd&^zs=vodsfJgЁE IDs`ЯE2k^DriveLockd?m^SfutC9upQ5o7ap BIOSPOnpfg `a7=v2iigv?h>xM`WBiS1tru!i CbEJbau~UleBvOp|c@0tOo rigi-dAtpaJgSP2lh!` lom AvapXtLpupG5 6DimزB{ccaPB m@3op ebX01gvva`oisgjPremi q@siatasreirRLuX   <=f, ESC=Annuc`T[Act9e_=SiNqV,xalt2"=A񠒟"D Us\chiavf freccdi1v 3c uG ap 3@L SP<INVIO> @``6IY'ce.wegu|  unE: -> o SPAZIO = JBsucss0  <-PB7ACKCE ;qcSTABCo2MAIUSC+!<= $XY9paÚ	ErrP`3~  QuȈn`puVse`6y?Si  v VAu@Sp8"N~. CU'T01 N@3uL;!@4A@Wogg;iao L[S0~׍res"agga਱2v\!wbH  nbookP0cespa#dL`̙~b8roѸatS}?_28~riuVv|DEProdu`Ka`8 N  Ti"3Q`VeloۅSteppMisaca\(L1/L2L=me`:AR`ROM FamiglX!KdhE`2e2!Qޔgqoprrollҫer =!1$23y4Ohand32_Cn?_@_d  bP30U00ފæeHG(Ř)(oI2_
z3_z4_ z_zo O Ok+agE$p;onda'HFHA so:Eqg}?gger PИ`QQxO?r1eX ֲX/r8LQ, ina`6fav1 
KoiрgA:,KUt1A:ra.onoVuyX3Xf5 IyOߡtRK1W1tq N@v~d`-)Lf,,L'Ir/V0y0.=DS|HQSewwcvoaG.Ya RS?UY0zBBE irHYPre?[}X:L AT1 (RapЅ)Q2 (CompletrRvrtiPo (@b): 307P0cn`o .F0%`QSQۄQar'h`ߓUY:3|s22@P / bTP[A`7 q\Uw;M`'`@Avg3O``S2<Lsq@] rib i Ygol:0kPRaYnPde gi S.M.A.R.T. Cu"~.Sm Erv@mnuoa`yotasQqSiE(q$5pbtdA֡p Vp.p&1;uq-M1F(Ecqz6u#AmrS)a xpyj,0  H0L;fu0m0q@TDezza?)SmartCa@n:!?i t :F.Ps\B+GaoХp!erddpDdati`VEfif1e1Fiso?in  ca)Iw ~cvQ"ipau&G⁬ {PO G"FNs+࣠spickLockspenqBcpPLpWmous '8M^x[ kPv  pgra =1;e    P_@$@6 (,acvfari  +#li PlRH@?P&p(,fa@aCinf@K\%їPPpF5'RIw/}lP Puls4ga(o CD-棼'S;'5. $Q =p =0  =m`.Up:mu*ta 3:A*-a/S u0 =D 2e1. D { +bN6uR'UTENTEPLPRINCIPALE  r`*o!;a pman淌fu pLo. #AnȰ;VpC 6qgPLF1c;U -aCѯD Neї6fv?֐8E.7lpv)Uu@++,(pu0]`@aLAvp sbR0reDBF'u. Bpq!LFpƆ@ FnqN0Yzd.р6AE!rC,mIo? ESC. |s'qldovhIwrh 'M'PLpoB+`ewF10.rxq F@\tztfvתsnVIt<0ҵ:< M DiBay# (E)  	>i USBr74Suprk5Zi}pPrimoPD&Wrza)PD rPO vt<tDecAo A NumA{'ԵAl0&. Fn/Ctrl T CInge (U'SA)r`Ci0sRJspuo mQ#plPt`
fopbXԣ	b"or)pl foZ&taVP_`Mo?xef Bid/CapapX memԀ{o @;S!{s`vSlE2 uNeRzarm>0aenerg Ġ '1%6% BaԬF(UalS*+spR 7Ethpet%/-% /10122134e Toke?n Ring2\7 o4k7O60»O8e=O:e=3 I2pl`*tZ D EF7D1a4_IJCbx/HOIN  DavKOLoMR % 0YԉPDu_VJKUZ /OMPY?_ST+?c WXbg\/]f?l`TBoldno/uis?tlm a nigy}?r |Ouv_υz_nc{-mo#Q ~ψ
O
 Oo~ϗ/ϙ헋[ ǰ :Иros .ã@% ]0<o!comp0
ä2ТS05'M <&3Т`'i/ʮ&*՘A% _jq%]^io/ϝ
u&@/~aPAutoma~Floppy^WlegacyC A A0dQ@=S0R~(sec.)  veePF12RǠ`& s/3jNpu
up <F1=Hjlp> rkiv {SyQinfotA"s> S.! pk
kigu@A 8ӏpstll_ frnol>@C!@ Bn 8ardL Annua nd0 och slu A  n+۴*ZJߓ Sker@ dptrslС  KTԁarct-mEn@ss)2-IDt`dtd fr  BIOS?byggd -Сi>abrikVerktyg Krc v, xbD SPσvtp
,q0BHDD Ak04Gus fpxt V[ljrP)D 0۳ nedt
t0 lq
#X
RTry@fri g nu8 !q@stp =A
, ESC=AvbryӡFT/A"ppaC, Vj=Mer Bv pila: Ka p#yt<RETUR> comvEbtt,jd.`)e1ljeer)"a  >": -> w@%MELLANSLAGSTANGENTEN = Naܩᐤ'G<-'BACKSTEGP)Fregep$)*.TABV)f.GKIFT+/,1%G!= 3&G@5x?`*sfel
_t gr" Ps k5wt hP$aE # ; up_pstod0BdA%w:en. Felk?01
inns gp;$2Q=pla1 t@m krv ``?Pp;ؑCm@ fly`s t -dator/ extCDh:a3`tidig>??Y@2mLPklTkNr,w  Pտ, typThastigRT@gR*CaP-POrlek (L1/L2) MA X ROM rZf_amiljk, 3[Ss=nummn0deo ]Ab00ZyrTB@x1(^NDw 1.bc2?drB3erB4:g a Ap$bS-?jrc ebldeb@v=ntbhg_pd]Ik, vd7 ()e1pDeypf?{ShpSekOrVar! DCӿP@  "N nehpGC&skaUp /-tHqi1Mkab&0"KA:
̃!; KO;hi`IM&SRrskyddad 
@apgąNP ŗG үb11<  GL?ig$?҇6SPTA1PǏnabbxfP@n@NxU0Ok>ad kbVd ( ): 30Ƞp;p;!1C0%Rp;l2MsըPOppvrBƨaItڪ@:;aBOkBS!;ðervo
-wL;"1M@%;֏#ttribut: IDP) A@d grGS.M.A.R.T.- OGammNpH\ifiQnں`	tVD Lp;a1"t PʺGvlika m$ӻ0UDr  =4aO!inE0_R  s `v funp` roɏD(̀K) om#  htctsO Pa s; mPlMo. a<glm('Atjph`else#pres)u& iuP hڰ*lQuick2telge LH`" mPA H? mjligg8ApQ0rbPihbB-0   /аB`@πkoRcihg =Fblir\qatb#KD7AomiT p!fP F<G~Trd !ytASnappGOCD-[XDt!ℑHrdq ApQ34  HuvuqR: AD`Wch.0d DeQ@k'` ANV-" HUVUD !QGpeڠt . ^1 qBQC0ild frI
Z1 kau2hQ` l( OB On"  @g. 	-beDfsem 1<AA$@%J2.`  B8-$F	&#	G 'z	'1 sedt!aB5"4i) a:[G"s/SD`v PaQ:S=MiBay)t8b4 (px6r1SBf:5 : /Zip-aF Fj1ara\O tto>Nz=Tt?Num 2Vx Fn?-/Ctrl"` 2EPlsk?t (USA04 pkd`[:᳈E0JdskrmstrobIinGaKHK!v0bbel ФX@eo@ne FlkpN2XSp4-PAgg`sДmhiAXERyT {Uv|;R, expcbBedX/Y EthoU\y[^ {^^|`ToAR^{c`{c_b`NOd3i_fIk_haUnik @Nntһnyr|>stus tuwsw S?s>9zKalibA` x/}z kd{P|FN$DualRO}g{O O~e/6R v{_eO?όD@%Bsq~H?andtag X{//eaV7PmoG 
n:{ϭO/O y9@ϻＤ[}e0d : Lar .# t% ]x02-Pklar2uě{%3áZOɬV* F{$ ! ]4qAuto1D5bQbrpegacy Free@aM !`Isadapl<drj3apsnabbr (sek1.9`+2F1 l pDLFBd'OStyr<PCF*Igqqe<n DQe@@&e  ? mO@T opslaan ConOfigu0o  Vanaf ](`v?T2?ndaardKPXя s3c~Wijzigne9Qrog?ramma `' mSetup z?r w(	?Rs<veilBheerswachtwoC?A/u =Aaatb	g$ ID's +
'!mSm C-kOT(uv@ BIOSoA?bouwde-7sa4Fabrieksugz1]x=t'AccuC te 0el3ecP a"p szelft(-sc_hijfe!giGAc1ٯ%&'"<t D btR*?$֐" wpgn GeacqPCalACal$emY@"2#1R*grijsgemaaN EvelGo")4
45\7uk 'P뀠Q g=S1, ESC=AnnuJp<D@<O=0="e/=a<Ja^@Nee AfPi O, AA뀠=Mp]z=Hulp,pijltjp:pruig:`dP#juip0?nukeuz@Hark<ENTER> ind0:0Gz25bep ,volF`̡:25  :  -> of SPATIEBALK =M <-QBACK RCE>RVorigLSTAB"UNc4sHIFT+UWpUS4K= ) @%t@{V`Bp[=t#fouDe`I.k0niwgeD0 Fp`p`reqtijos6en.m Acco014`@a;is-C\u we0@metvoeZreH" t" dbasH:a ft n notok-pcI/ڐ$ `C{iis'i_Ad Zb;e Kigd?c_dxe2_%,q-qs\ `at N5nmeq0ypPFroce{ssSnelSpS-zpplM| Om@e (_L1/L2G}ucapacpCiROM-Revisꁁ  HerzienBogav33bRS  Imma*%n5-videokVuNptrop<k ,P;-.1o.2$.3o.4. p`zf*- IϚn creOIn@/FistgIttificfj33eUmX(X0Mdzt) 텏OdPdВ ϫdPdؕOh*pϞSB%SecupiDB%Llop: >tzat[ aps e7gewH Pf:be'3fݧ vJ dQ A:O>g-  /뀁IGsG$epĢatoff_G:akȶ!ge
dA/AŤ0gogt ;Ċ/  elu)IA`@Hxzwilt?	a5C? PNH
Zt)'TQ1 ({=)2 (UG0()0' Bohrot (.): 300HP純}.Z0%Mtoo"px8k hobroG:)ma1esnbANc`Cb`C vo=-leese`) aRrf's`kGk:RfΓsbije S.M.A.R.T.-_afdoG.%udXhieuw_XAi:ТBloPK( A0<B# ڷ0gaPi!c@k1. Nbl p)ЧP\ls X Vlߖ}`I.Lis !bP;!si@8u `Cakelt,! pnq-2ej2Q(a  i)SItC-_!>,  d 333payeks՞@ugze> g` -erlo2eZlrf5' bРAitf"houdHi;p(Pb(  0ؔ>ږ758ʡ{ DC6g#6Ǒ TǉAJmHF8B.3_AS?!ppMP/!g!g$,2r;0bjb-r. %H`Is-eQk@traak0g!T11Obi;pp;0opar0fraroo=dL ParLp#DGdloo@	etw KnOP Cd-r;XSNa'VDVPVВ|VPHoofd1G IC U/pWviaQB0Lk-)if1_zow@6HOOFD-GEBRUIKERScaV  permanA-H eS pb  2wa@]^ .Sm fypkaxp𐈣}pfcomp@ hg_cSas1!b It ?e3WbTProiSKUs. AAe)^_#,!CFan$ lijk /T_s޵, uAްESC-. O@#!QBfD_ R
$,'_M'ptyvkqQF10pPT ꇠ 7{ZC
 $0P_!cfsXc
Nel 31 MultiBayVڗf6 (as)3|bИ USB-GÂcRe 0p- EBڠ9weHa!VQ/V.aZesPZ(P؉ANP tus Num ;Fn/CtrlCsse}9ǒF`
eneM3<@sapp0N6O+qu bYemrmtl00n߬BkijVPmo-10 !kN&հdo=lpMv1gBu_dHP
nti*:uHpPՠ*PN$n e2 ]-ieB8Q (bΡ&)?Za~Et @PWOhĐXOh\YOd TBR!" ==R~PW2Ѹ3 URpk00Ftc8@ccu7 1 SøaGekal!ioKB @ Sualݯ 3ou@3/SėBA?_3 Hg@pvormkoܼLer-MUE-ݯ 3/  R3/
  [qp 1 : B$҄ol1F.؇% ]AOfГtooD2nt 53SKt *$$  $zO'\wFMod z@7gacy3ӅafPadapn33ѧpGr(>0ysec.)p%``pop-upr;s8LA vF12 i0P1)pbb  cursorbqura=EasyPo-:G6Gt  Rs[^̃ZbgA9viSETUPj <F1=wv> t@C8VXe߀G<ɿւ<\w܂8t9s@9fB<Nɕۑ  ݒC>o?@>@畜C>BĂAE&Cf;H`;gA  Hꏟo׎9H<e<Aɖ%CKύXɏI e BMBMAAMȌԻ@C܃@9e @PMlLFMAegRDoPQ9LUIǗW҃p<@9hX̃IdXZ'Z @o <X 	W]@\̗L/cK3Ce<IDG<ID` h <uEN XcY`#OA@Co폜$CSmC߽ܰ`i BIOS>i ߰@iNFZz^^m ]^mEZIOU98c@91<o9e̒  OISst&CnX@a^;e~<g Iv`<Ǉvwx&A`&Cs <A9otO>; {Cq8p\U>>h߂atuH8@x@9xObtBs!Zσ{sDCu@9jxN`]ȈU__cL[F 3=tAEsc= W8@zďÍso3g/0=ς͂  MA9ɐC;8J@9\ gpFj~!9ڂ0y <egh[EEq]}PC0ψȉAb̠8T->g<y@9P^o[ = EZ  <-g[BackSpace]O;[Tab!A[Shift]+OϨh3!AM/mF[E  tG[  鱀9svł@C=vrϒfQS 0?1  JyrV Gчɂ?ACO!\`Iڑ>Kv Gcb WO x(uD maed gMEUh"Ȃlϲ22^e=］<!Eɰޯ   ۾ tȑxfȽïݸ  ށiL1w/L2:RvOMUrWx̧r Ak޼ޮ݇Ǽرٔ  ηκ۰ׂް"ޯ ް	ӓt  ޯبЃ234> m
l	Ӎ'ӉEߥǱ ʖǵŰc(Â)v'34 /Mܗ Ӧe<tVJ8_}x:ⴈςƁAgEɩ Bu"T >?Ď퀶Tڡ@/Epg쐬wveA:M݉ `gEH3@G}	oE  F 'xe֎~  rO
`?`IIK  ~ELB C=H@#T H3LKUXQ/OS gRGU8Qo/yHz>@x1iN <d:x2iS"3`:.M.A.R.T: \zsԁij: 30Vgz$w .60% & OK z1x |xs~8)f8:*z$),wmOQ,e0T@9{0ǂ(1e Z-T|aFֶsFIDp#.bJ7 * .:@̉XV;\í`$P` PՀxyఴA YBMqr @uYBC=xDv"|߼$M%Yulb?Y`r@d  ypMXӃ}21hif 5NPqrEN 2CZƂ!7*MYꍇgbiYbpqPPD![ | VƂ`6W1*Xd_vP A|?Ayx>9?S|!Nhhu4BiTA@h9hGer{{#G}EiSn{TNOe> %K>2*ی삪BW;P Z蕴`๐TN1@xbċNm8Mvq V@TA6 ԊO9t~AG~u?ȯ㰸?% GCD-R $PȀ05t41234`h}J ^R:`hUˋ^gi_pNe4i@  DuQ ^ m`q@_ZhPDAT`_zq6Fyib8	`hi]lz$ѶY͎rǐ0R@s0^ߩ痣ZS#ۊeb6 2_ @!_OZ@_ҼЏE&u4dMV31`_m_P [ߜPܐpE綂]༕ۏ؊ԓ ł২±͗L㹂`.9>
p༂wql`XӔCJ
aBx{[Esc]Amb6v~*#"cyqB̗DriveLock @_tBEp[F10D@C4	1`Gp  E%qg-uuqqOiid}(`%|:W mbQu!l DԡxڐQ4b T_O xPXiaa$)aa$USBH ZXPpg Zipv1Ԗ 234567891q0Ձ9Num1cV Fn/CtrlR̐ؑ Gm`l{  p (USA)|\BfCX݌KV5Dv C gP % g4}`hrIsoK C=W co [CY}y KOarڑ͏̧0J#N25 Kgȏdc10Oڏ$EtheGrne@ _t	tgPN  Q
 3 lB>NK
Ko چj
 ID b \v'.?  Dg /'І !"\/#O$.f T2~  &{"(*%+,*( V?/N"_12%4?' W(_7"9:%<70nkA~7N"B?C%D7V(MEU HE"oJK%/M MNIDPC_NLSNU?Q0Pybv1 : [dϒ .s\ W% ]aO[-X]2[!\	[_o\`^v3[\	[ieaobf6d	*j&d j6,_.lGOOXjq^T iopIntel  SpeedStep technology #mWtpPP(x  ~_@4ް Ӱ S`~h ~[x(b) @߂F12|?ԁibm  ^`"pbBđ p߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ˟̿?_ ԟտ?_ ݟ޿?_ ?_ ?_ ?_  ?_	 

?_ ?_  "?#_$ %&'()+?,_- ./0124?5_6 789:;=?>_? @ABCDF?G_H IJKLMO?P_Q RSTUVX?Y_Z [\]^_a?b_c defghj?k_l mnopqs?t_u vwxyz|?}} ` a b c d e f g~4  >  j    Z     	 
 v     
    p        ʤ            ʧ    x   җ  ) * D  - . ¾ / 0   $ %   & '     [} uNp}! p]}( p} H[t[["[([$/[P5[|;[A[G[ N[,TT@~Ё0P0}<BB<}>"}ب}0`8lƀ}v x|vƕ||}p/0p}"  "}0   = ~ =$$$<   DDD }O}ae  i  o䔕 u  wy   nz}A0 E}  I}O v}U   Y}N} ~ `' ^    }y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>}( )O +#'?
({[)|+}][{]}'@ (#^()\|+y~ z# {{ |[ }| ~ \ ^ @ ] } &12"3'4(5-67	_8
90)aA0$qQ'mM(%) +*,wW2,?3;.4:/5!U@ z {V-+*'(Maθs$?|  9+'()+'* Ǳ!ɳì#β?
\()|̏/ϏoЏҭҪ'5 -=
^~+]}@`)  ';+(:*[{s\_}\|  ǫ  [匐Xg[(PP\[QP刔鰐h֐(W[FPPPzP	
~ + 9}:};~Ò~?}@}A}B}C}8 1 [~ _[\[^[ja[c[UCPB?b[0]@}UQ}R}S}T}U}V}2  UW}X}Z~h}O 6 U	T@*M:$``vq  ]~U^}_~`}a}bX0 VZW[S[`&A i}A( 
t	Wk}
lmn 4 :} 044} 44 3 _	[V4U4PHVF10 Setup Imageq_SETUP  }򡰃" 5S 644Up44Up̺44RCP6P	  
 
`V #
J"}s Uд&}}}U
t"V}U
"V}!}
а"ت}}}}ܪ}}~}}oTp2 4 "V444444444z463 \ r64 4U44}	0Pp:)E!:	}~#" c!" !" |AB2 "0@U	VTT5TTT 2 	|0@TCJ-JKLMO/PMQ)0I"0@V}|3~J~s2"P	F G  m3F H H  733
33	38393:3;3<3=3>3?3@3A3-
P
[VTHT#  TTT!T&TjT3TBTiTnT+T0jT1T/
2)SF}$0Ij"S PjG+}d Tc` Tq 7 )u&  w0IR0sNdp> PxP  *  x5}z}{}  }}~JP0sWS >`>jԀ`>~>>ҀրA> b>(Nfİܰ >,0<0V0b0x000000D^dx >pp&p4pVpdp|pppppp
 >8DJnܰ谐@0J0l00000 >H0h0000 S> !DRUbrUİа氖	 >U*pFpXpppUpppp}p
 >BUl T060V0z0000z01 >:UZz5
 UZz4"@0UT0n00000  >020P0^0x040ƪ4000
 >"6Zjp>p`p|pppppppppp  >&>f𱆪t <n갴ư >p<pFpRphpppΚpp, jv𸠪j 0 0.0<0J0V0h0x0j0000`000ܾ0 >4b즰 @p:p`plpvpppp²pppp@"06>DLRX`hntŌŞŨŰŶjа@&0:@DLRfp~ʂʆʘʞʤʬRʲˀS
@p2pNpUnpЀpИpаppppT0F0^0ӂ0զ000*T0z0ը00M0& vṴ"^UJ^r^^^M^!hUٜپްٍ"@ۡTfxۈۚJ۬۾ۡް5
#0U2060:0Z0U\0`0d0h0Ul0p0t0x4Ut0U0ߴ0ߺ00Q߀a00Y0m>060U\0z0001%@0j0钪00000&0J0V0p000뼚00
' pFplpppjppp(FRZlt*ʰ) URrռ°6*T~S+0r000
,tj<-J5.U.L^lUxM/<UPdx5ܰ0@U`z1T 0R00000oǤa2H|ʰ3
Ul


а
M
4@FrҰް!5T p`p~pp5pp60U,0\0|00U0000S7 U",JUh8CFxʰ 9 0z*0000M0:pJp~ppp*;T f~i< 8Ndz=!f!!!!>0#d0#z0#0#0#?$d$$R$Ұ$eް$$S@0'D0'r0'U0'0'0'0'U0'0'0'0'U0'0'0'0'U0'0'1'A@ƪ+:+B+R+h++++Ԓ+1,+!B00i400<D00\1000eР00i00a00"C4r44ư44D 06h060606Ep7p7p7
F p8p8p8G p9zjp9p9p92Hj:::.Ij;;;"J <p<<<<<$K p>aUvp>p>p>p>Mp> Lap@Up@:p@Np@np@"xp@oBJp@p@%qAj0p@p@ M@pIpI2pIDpIhpI|pIpIpIޚpIpI&N0Lh0Lr0L0L0Lʚ0L0L O0N*0NB0N^0N0Nj0N0N0NPpP@pPbpPnpPpPpPpPpP&pPQ@>R*R!U8RTRjRRդRRRRTU6UFUbUUpUvUUİUMUS@>0XL0XUv0X0X0X0XSTY8YlY՚YYYU [l[[IT[[Ȱ[ܰ[[V p^,p^Bp^Xp^jp^p^p^p^p^p^p^WaJanaaİajaaaX@>c8cLchcccccY 0faR/OoǤTaR!J40fV0fz0f0fqf0f0fIZ 0mV0mJt0mU0m0m0m0mn [ on0*oPo^onoUooooMo\0sD0sV0sf0sv0s0s0s0s0s]u&u.u2Tua6u:uDuU`uuuuu,^yPpypyᴼpypy$_T0{r0{0{0{j0{0{`@p}Np}zp}p}Zp}p}aù0i000J0V0d0~000000̚00bHnԚcXrdZzeæ!ĺj̰e@v6DR^flt|*Ȱ!,5氊찊f fU4LdlIvˀ!͖R͞mμ氏gG.JTaf~UȰⰕSh@>b5i2p5pp j p5pp*kp5pp(l@p5pp0mtp5pp:n2pUzpppppo 0!fL0^0p0000!v0&0ppNp`p/CᄴE䥦pp!pTppppMpq {6UXj5ΰ찬r UhrռsT@v0N0`00U0000tvpZpaQbppppؚppu(H^𵀪v@0NZ`ڰw@phpppp!ZpxT@pbpppYp!\yC<0UF0X0f0z000^0j000
z >Vnº{v0`0v0Ő0Ū0000|p:p`JpǎpǺp!fpǀ!fh/i!p}@vpHpn*pΒpΞppampa~2HlЎРк4Q ʰeq(DUjxӎӤUİְS@v0B0r0ו0ה0ע0%v0׼0a0סwj000"@pdpۊp۬pVp
C0bUܺS@>NUjތޞS Plv)H@8 m(UL|S V|UʰܰS@tb醰ծа
T fp$p2pFpUbp~ppppq@pዓOaR4!,LRU`r.֤e0 UC(NfUİS@^U~S
@X5dpxpppT 2tаS d502pՌpppTFdΰ 2iNrJeBưKDtoFJC",%6UVbjբT pVppp5pp 0U80`0v00հ000Tvp\pvpp5pp0UV0d0~00պ000"T@yp4pHpVpUzppppMp RUl|5@m0Ub0p000M0 {FU\S@_ p  eڰ  ! {p":p"Np"hp"p"p"p"p"ښp"p"0%P0%|0%0%0%ޚ0%0%@V0'tj0'0'0'4_p(~p(p(p(p( 2)j)))  0+0+0+Gjj0+0+ 01B01`01p01j010101 03T03l0303j030303@R05>05!5N05l05U|05050505M05@y7P7Uz7778M7@0:L0:Ub0:v0:0:0:U0:0:0:0:Upt0:0:0:S@V=j==5t>=$@?5?Ȱ?@_@l@~@@e|ʚ@@,BLB|BBB&B,D*DUFDVDrDDUDDҰDDS,0H&0H<0HUT0H0H0H0HSP0Jr0J0JM0J@mpKDpKU\pKpKpKpKMpKwpMhpMQpMpMpMpMMpM$OpOU|OOOOUOOOOUOOOOMO@ySFSUNSVSfSSUSSSSS-
@W*$W8WTWU\WWWWW 0\J0\l0\0\0\Ԛ0\0\@m0^TJ0^p0^0^0^M0^00`0`50`0`$@paՎpapapa$TybbbbSyc|ccMc@v0e>0eU`0e0e0e0ei1f+0e
 {*g4gJg^ga;tggggҰggS
-.pmNpmTpm^pmfpmanpmpmpmpmjpmpmpmvr^rprrjrrr$tFtjt|ttttt 0wD0wX0w0w0w0w0w0w  8pyBpy`Jpypypy!qyppypypy
@p|Fp|\p|~Rp|p|!p|p|p|!,0D0r000Κ00@0`00000Ā\jtpqa"DpXplppppjpppƀ[0RzҰǀjZȦ@0J0n0000ɀjb"ʇ+zo,-.T/zR0f00U0000S 0b00000as@0>0R0l000j000
@0f0~0000΀8Pz pp"p*p.p2p>pXpxpppVpC:bՆΰTypTpfpvpAppppA0b00000000T@%pJp`pzpUpppp5pp o0|000TjpfpppMp VfՐפypXpeNfp~ppppCPP"6Q@0J0eRR*0Z0b0h00aT00j000 JBN-^%v~XiYU԰S NdUS \U*܃R~ pvjpâpp hlĚư,߀0Ɛ0ƾ00" dptpǔpǮppp0R0p0Ʉ0ɘ0ɸ0
000!aaiS@wp:pfp"|poklmopojpLp  U*<TjUӞӾM䀹XUֺ֜M@<UZ؀ؔذ5怏0U20Z0r0|0U0ۤ000M0@"U06ZnUݚݲM 2UVbhUS p㚰5İ @0U<0V000S @FX檡r~搰椪渰ΰ@w0@0N0j00ꬪ0000@:\숪첰ΰ2Jb|°&ANa@/Oo/a!XU|50IV0x0a0U00000*0B0R0b0r00000 BZpئ@0 ,0 :0 R0 b0 p0 ~0 0 0 0 j0 0 0 􀩪LLp5pUΰA P^	F	V	lT	iEz			U°	ڰ			S@p
(p
0p
U>p
Rp
vp
p
5p
p
AUdM xլְ `0d0eNn00000f0 @t2>FNV^fpz 6LJZht%eeY1pjp Np zp jp p p 50"d0"0"0"  M(p#Tp#jp#p#p#D Mp#>M~p%¾p%MB0&0&0&MJ0'0'0'MN0(0(0(MR0)0)־0)MZ0*0*0*0*M8p+^p+p+ƪp+Thfhxhhhp+|p+!M&.F.X..j./KϺ0o.	 (p5p5.Tp5p8p5Rp5\p5Udp5zp5p5p5Mp5
+8Z8Ռ888WMP0:Z0:v0:ՠ0:0:0:
WM4;B;^;Uv;;;;S
 :=8=X=Ux====M= :0@D0@5L0@T0@& U0@U0@0@0@0@S  /BFBdBUBBBBMB
@60En0E՞0E0E0ET#FPFFFȰFF8MjpHpHpH@6pI|pIpIa7pIpIpIpIpIMK.K:KFKdKKKKKK <NVNxjNN̰N @60Pt0P0P0PΚ0P0P@6Q^QQQQ()@7pSpSpS!@@/!@7pS1T@%YTYYYYްY@%p[bp[p[jp[p[p[\U,0]T4]r0]0]50]0]" 0]}0]$M00`UH0`d0`0`0`0`0`0`T <pb`pbppbpbUpbpbpbpbUpbpbpbpbMpb <exeՠeee
@pg|pgppgަpg @:hhhhh!T jjNjjjMj"@plPpl`plppl)pmpmpmpmpmpmpm# )0pJ 0p:0pZ0p~j0p0p0p$@(pr|prprpr&%@)sss⦰s&@/trtttt'UMpv2pvTqvpvpvpvpv W(Mx xU(x2x<xFxUPxXxbxlxUvx~xxxUxxxqy)@&}b}l}x}}f1}e}%}}Ҥ~1 * 00V0|j000+@_>Zvа간,5J~:-@^ppp$. 7ppp/@:ppp0@6prjppp$1@ܰ򦰌2 00H0jR00S00500*3/Tcnz%%0ΰ0bKto34 `*.<Pa6UVpjp6|US
5 jpRppՠppp6T50<0d0|0U0000S7 :p8pLpUnppppMp8@r0UPrUְడ谡S9 jpNpjpUppppS : Lp,pRpU^pdpppMp; )<UfΰM
< <z5ް= 7US> :p*p:pUNpbpxppUppppMp? 6DU`|5԰ @ OUSA#pHphpՎppp B/0~00᢯TPUVXᢦ00M0C#p\pUjpppp}p DM6pfpxppjpppEU6L\a_njذFRrÌìjG@_2NX`jlvWłŤ$HM@pvtɨppa6IT`0ˀ0˺00˭0Jj@V̖̄ҰKɰxΖΤJζưΩm԰5
L :U*BZrUіѬѾMM@lդҰ.NT@*0ֈ0֨0ּ0M0*O[זդȰ&Pv40ٌB0`0ن0٪0p0y00000Q@'؀_0y$,F\fp~ܢܸ,m
RC$%2T@Ja6|1ʚS]0>0\0z00j000T]jpFpvph@pp<U@G0Ħ0
V@:ئWb.XPBYRZ O|︚ް [ *0<R0Z0z00զ000$\T:FZ%j%0ڔ4/4԰T@#] pa6Up"p.p4pUFp^ppppUppq^ <\|_ `0:0D0Z0n000j000`]LnP,lFu_aASa )p.p@pU^pppp36R_pNvpMp&b@'
r
՚

ܰ
cT0p000M0d@/
r
Ւ
İ

evU0b0n000000000f `4V4lj̰g#pPpvpppppp1hY@oXa6ZzְQi@` R n U   ! j""p#@Jp#Rp#bp#a_xp#Up#p#p#p#Sk 6p&>p&Lp&U\p&hp&p&p&_r >p&p&Mp&lp)p(-p(7@0]p)U"p)<p)Xp)p)Up)p)*m@R,,a6,,S n 0p.\p.pp.p.%jp.p.p.p.o01p01010101011m01pT@_04004>04R04U^04j04v0404U04040404M04q <7\7U~777ܰ7S rp9&p9Vp9Up9p9p9p9sp;Vp;ebp;pp;p;p;p;p;pp;@ >=p;tRvep?|?p?Up? p?(p?0p?U8p?Pp?hp?t?p?p?p?p?fp?A C<p?ap?
%u! FDFfFFFFF vN0J00JN0Jl0J0Jj0J0J0Jw
pLLpL~pLpLpL0x@MMڦMy uNNNN.zS0P0P0P{0Qj0Q0Q0Q,|$pRpRpRpRҚpRpR}
0TDT0Tad0Tv0T0T0T0To >!a)0T0T~$yWBWLWo˔nXW*WWWWUP`WİW5ְWW@p`U>p`fp`p`p`Mp`
 f0bZ0bUf0b|0b0b0b50b0b pdU.pdFpdjpdpdղpdpdpdT.fTfZfjfUff0h0hS*h<hLhUZh~hhhոhhhT.kPk`kkUkkkkSmLmtm՚mmmT Po>ofoo5oo 'pqlpqpqpq_ªpqpqpqpqys6sJsVsbsssƚsspv2pvJpvbpvzpvjpvpvpvxZxxxҚxx

pzJztpzpzpzpzCh/OoǺTah!`p|8p|Np|Upp|p|p|p|p| Pp`Rpfpppjpⴄp"ÄU60b000j$00p*pFppppppppTdvRa*պ6T Y|ذSl5& pU\pnpppղpppT簓pΰM 0&0)36H`rRΰbްS AR|՞ȰT OpxpppMp. 5 A0X0eh0x0000000 > $,2:BHPX?`~jܰJp>pDpRp%jptppeIp!1p}p
 >SpnfpUppppS
 pJphpUppppS Oplpp5pp PUTxM`U԰S$p|pp5pp 'z!|teV!L k>D8/YlT[Rⰺ5 AUBl¾Mа  pTpUhpĢpĴpp5pp
ULXpƊ°԰Tv4LhUpȀȞM Pp8pU>pnp˄p˶ppppT Jd~UͬͼM 1pDpU^pЀpТppMppBpU`p|pҨppS $0Z0v0U0Ԛ0Ԥ0Ԭ0U0000M0 ppU*p<pJpbpUxp׊pלp׮pppp T <\nUژڪڼTJj݀!|~/!˪¦`za(^|aĥ
pBpVpfp|pppjppp$0N0b0x0즪00000*06<BJPtj D0`00Ʀ0 dpܚ"0t000@.>)3R^n|°Ҫppp&I!pp^pS8ʰStMް P Z Uf v   զ   >p.pBpRpXp^pdpjpppvp|pppppppppp@RJVRbDnI%%G	^ 9p*pDpjppppޚpp f-fjÀ0r0000$@$~ذ ^9p<p`p~*ppppMp ,@TheXKZ
Tm\& H N \ v ^$PnP[$%     j      [h Vi   QLGB=   0{+&!	!$08/14/03 Copyright 2002 by COMPAQmputerrporation. 䐿
!`t`
T
  'p~}P >" "'D Tut


t݈
tt

"
#tDt3=t
@t0`#~ 80TaDs>0[t`D@t#(trD	T
'T?DDD _T% !t
t
t
Duү,"!"#$$"#!P%d%%%Ô
@$$p#"2` `%> ЂЃ&'_u u (2 Txu. B/,>$4 `Op" /{ 1{1
"  "/)z|t}~ }䓣𣮂)D;` ) Cp`t   +,-.
..-$-03,,+$+`9 )t" ~}|}Yp5"{ z}R8:tu݋:D>tA;<} |U=t>9,?$@%B'%($('&u"B&C&DwB&%ӔP&`P%/3d@~qD$d	p?aDR8%u( % C&u*aJ)**)p)N`.(('$'`903aD4<p<%&$p5qDEB!D @,((sVh^QܒRXSE Q' QBDTH"UqbUt~ 33V']p@MIEV=B#U.3ZqU#"E!9\qՒUT"uPu4"%$I403tʎ"0"
pLp"0"_d   55t~)t
5"+pd+/ÞP.%d@ Sp`d,͹dm _{ +u.aJ-`..9-N`Ib,sg 
d,+hiBSje,`Ced`"`7tu
8d" su?v_wxyz{|}	up ;H   01/{09Q705/14 kLite 3qHewlett-Packard	any.01A1"x#Ta+T0	T@t/{3"~0@xDx_v$ÔdPx>02"2"'}"2x x*} 0<uu u	`@3@3@)aT$3TD ȃ@VF @~`T?0	T@3`T%`@@3dłŃ瀾xT?T_"x!T.0s/TDx!TDxD@pp
07/dp1 Dx>J@0P T%%TO~.`OT"2`() d)K()?(@좌JKPWxt}TA"/0g}` Tq000$/P/ P	d`$7ⴕ䟏PZк0{07?xDO+0'yJ~1``"x 0D9BD¯./uүp6ޅ./"xt}
~1PxWvvuuˀ𮀚D
I`uu!W\ү0@SkQ}1``
$`$pl
}P`x~ce
Cxx txDESxxxx`D@2پn}u@g@`@{>}d`&xKFI*Bx x}D7a!P`0xtxtyuup!./}^aP}eSs1^}laP+½*,܁˴xdD0D x^Qx_cD%xfT_bp# ) ,!`X0*h0wA˾qs	!Tp͈"c0x	}0.@ϴ@8}5@ʎ%tȐp)_? `P¯~u| p!~@T`#lU00p6`]7aνּ¯)u)$R4C_L`)}+t)(ѤÔ{@_>*w_x)(0#Q w X0%v@"x)(*`_00.}+,-2  
)"x^}4`q}7>"  }9@6!'B00x)xb`xc @p L0S(; TB(x`0)0 9P4r.( 0F(`xR=	(x᪀x 5! q_(>dTrK~PF = y(.P>q
P0Tdp(D!?(fP( @		5
<}p!Tu"2P Ô2@Y$0¯x 8Rx00`2)6020 T߰|`	pXl@ܱה ]]4C4A@ t1x,xtx@x,qހA0x*-t+ZP`TOxY#^֚b࢐};TT?)xT0p ;pހU!T`a"d`
u)?Td`dpUpD!%T!T?Ӕ @
$T?M;T?`d`}W}*)pKp&$@p6!q%% V'@+~ *~*)Q33T?O)`8 3  ] )A13 )$`$`
$-p} Y}"A3ȐEP3"`uxp_>N>0WA7 87B67`BЂЃ2:6x^p` 	?]g9@K07*q7Lx-!7+_MLNx*MMx+AQVL0x"b=qŧ= BB=@eK`LWM,6!7q7J7J0}G[Gf@2G`GF9KB996>QxZ!7Yq7RNSR8}DQ`R96 ?S07^q7TLTQuDSNTNROU07cq7VL߿VT`}V8 VAIDUNVRS2A}3 A}9 !, uuҌВ}"YZd;Z0AZx'D
q_0d`!0f/00_`0`'`2`=`HpQxWc_6uuuueuu0fuueu]ˏO$[ƨpN`0T`
0c;0  q"| }(0xWP/"(@E(cp
@oqP(qPP ()(x)ߎ(0դ(!t)))((xY))"*+p_T0 7/t
at&Ppd `.g..
t{[;nҌ( |n響,-mp,l`
,-3|d@zt 5n/1H΅+*,-"uPu4+i"o E[x]c=	[xP͠zl߆#x7x8ǧ7t4"PcdǇ"xe0!px," -AtF)DG;qs=1v8z:Bp#$W@23{;"xy> !u
C9./0H*5,7_U?4c~;V~Pno|ZQ}d%]	`
e(j[&b'g>i\af|X6h+l  >}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RОZ  a  " ! * 2 1 : A I J Q Y  ? ) >g d  F  pq kli/ur}z'tw l k i h Ju s r p o t z q { y m Zc v v       
  	 x   ~    2YPJ @|PЬӬ !ww ~~   @"x7x4QApDYaD x2tx1tI#%E[0% %xivv T%_xi6^=Hxk"# $ $ !2lx1 	ү  ¯߀0 l#! K@3"0! Mx3=
⽒[
"xjF`@kz <"p7"" %	x30#0$<T`"p"xkcfp?
0!#3tI.4}࠼xkb$3z 
 Hp_ÓŐ`$H$ykHxgv"xw0	D0x$FӔ@Txwyv!D"0R 48xexvӵDpT0s
QP÷PuPr"xmAxn1xu"xmxvxnxxxuп"xpƷxmo0qP[yoxpf`ӀY'xpޑְj[vpp".0&u)1X)3@& @&"* _`@"x*_t %*%o-@-P"/t7U-,-b,R--o++,U-`RU,`  +u%*$U,00u,,u,0,*+0P, 0  d0`PÔ@"0  	0
0 	@	"0 @@H@@`@@$@@<@@T@"   RӀ 1 }1ÔP2p_0/b`%110 v0//A1Ӕ?@t -tq6wnR!.P ]x.xgo`x[T`"Txf0gv"/*r3/TOp0 0@0 
0 `]"`0/]P 00!P`	 7""452 "2T1u$b405S20 |09}= ~ } | 1| ONML
:
K_^]\6=iTi6 5`64064041$cY2"140#1dn`1o n0u1o! Wu1nX3Y3Ӕ@
3_s33p22
0
1"ɒ4@0
*1$`$`$p#%֐#&v#'Bϒ44A%##$#'%(&) )1$"465  6"4xg@@,xh4d|p%05#(6${zy#p.,v@,0/~-_`)05#%.1,./35
P1/ - 
1&4 #/
Xa7@,7V57/711/975678567`A(8t%77566 88b+,rP?50r0+w05&_5y9/4@,5	1 k17/ D7/r@B `- 
 
 *A0>`-
 53DEмFAB86-o`1,0",+0u0-05(@1
C9D6YJB:hK7G55SU+V4OPoQ3p+50 ?Vr,`*jI5/5JS_B[__[I`e4pv^6[_B:`/5b+0 \0@5Cs,[2/2OWg[>B[3hg3h0Wg?h=[97/p,hfp02"Up#mHpf;?hgglrg#mpy$m~82xfpJ`F0}D){) 1	})	2 2@
"yxfy?}Z@xzMNOpxD Ee1``א}G~X@~0
T`'" #}|XpC~{z}yZ1zxydVP~y0@~0
0 'P~`0`0*0$`+$`W$`6$`$`&[$pYA~TpրQA~RF>0Txv)!pрDxՠ001```	^P0* إ}`@~ 	D~bPC^A*¯7`ү" )T|F`xd  R=./2x~v
xD}D}*0{^`
}^T?Dt
_ei4si24lgpD`P~[@`TﰗBl34a3$``$p"t1e4`tg4B |}"}A~0Ʒ0+o0)1Td`x0dp# xF TTÔP
._/xFt°eͦקxBUB2sͦקxNN2lͦקxJ_J0rߏ789tZ/qC:(x үR7%$Rƶt :t:821(0 (:o$⠷lx`vT"` R9x"`үs q78 0(87P p0 xυv#ս3xV53}+t0ŏ4  %4 +4 ƫr""55Ô@̠Pp`,R̠Ȑrc@cɍd`
*h~R,ϜT0PO,CΠμCC@4A0120``/`@$pNο21΀I:I&IHE)?6PA [xPέ03oppG{*`	6>p1 '?<P"@TP~ ۵+܂E?T@;үd`pxH @"5i5@dq;"-.?hQӑm0`/-x00 <@
0
DDTйѠ0a	 0>d}`	 a}Ct
u/ /tl@@'- _ r.ldpe`0ߴ-DxFu@0u rxPu000u0//GCգt`../0..}00 $0/J..!ȧ- }p
.Ƃ9ˠq"pڡ	 @1R)x0).:)4R`+,01)'.7ݸ
pha)
/O1= 2
5 
x(0	(`!*((p@@0v@{	`~	@0|`T``1_`pȰd0p2CD?գ%5߃0op;Cc"w1AT6%p0:o ""p	S05qB0D" %%O0(ҵd-N-H/G" 1r)&P'P#46P-p0 Bۏ& S%1?-` 3-2cU%`	й%._0D'1T:-#?.P3sp_u.
p@u.H.T-V),*Ҁʀ
*+%DḌ@+ 90&@۸0aT0 +	aހ`>7AIҵ05[0upo)?6*+pFR}}}0
pzQ/+*tZ%)Ƹ!SpS;"쎸W P#1Āp5\BŐ}YBT|!p0=/`$<#T0?O_Nw45U pY}2x`TJbߴbb[`b0>0Ņ54'pB/_D`L7%fFhB2šPcP	U0ŀeUkk!cbl!eA`{o0Vd}
1lE9'o'dZBmd5lpP7s6$$P3cX2urVd}KFkePes8&5f1f}z` X0pRpLxpGIp? 1b #2  TU``|Tx{}A{xz Gxy Exx Fxw Bxv <xuxextx[xs xr }xqxxp{xФx| Ax{ Gxz Exy Fxxxw <xvxexudxt xs }xrxxqxxp"
yxdv0`bPTx`pB8" -88d0-Tx` `bb``bNpB -^XC****!J-c S7C^")u,/g.-T*_/.d^  Q1H'jc-ޭ)ۼ,(f;l)d&AO*+pǇKpGQ䨝iD++kR=
0;l-pPB Q-3މy0hP5$p1q?JR}DAm)=t>4N  0 Q6 xpAP
ק "u*PБ09"RJ ~})IaB Q"<) R <1"+0R¶<$+pMsJ0D@YTIxp`E;D S)))u+B+12 D ppu+TaB5#+".%TOyd k ǔЫ	p ``` =cʫ$0>|`E'~Ӕ@6y   x0@ @ x9P7T?PQxvP_
Ԡ ǀ
  0GI` ;oPQв"0*WAopT&"LtM^q30.~KT``I0}n}S?@.Ŀ33TBDАD xd3"8t`#xVxFЇI0II@TLK}
c<&RM~Gqq3"x)"O[Qe J0OQ17|-3tR"LVV `
O0 )J'' 'BP=[O`k !wP`	AO?"HI.gB*TY#IPEH0~."nf@yri@L@vZY?po0:OJ5 050vq $_Y:a^1p,; ^@	FsD0s 0"*OѮ@"BCCWpaO!Cdpe7R+tt2kC³CFD0`DCxgvBC?"xF?xG@xEAxFt@0( @T.`x@@0xAFt"("r@B`0AA"xB!CqAB9B
 N!OqMRN?9N+ !UJ!KqIJ_#9J+ !|DEFGTW`N JCT&`7,S0uE`AE@0
GFt#R1 =BED}^}e}s}lEAMI !++Gp5@"NxDTK{{NoE 8C̓$0* 8?Ap}@>1TPp}CO	E DDDDDDDDDDDzDaDHD/D'D  EF;V"AOx\@ab1~p|t"x\@Ԅ/BBCC0C@F"7F`bD1GBF 5!6HFBC 2@@TFB`FM`FP9q|PCpP$`RE֢Q$FOӔ7@OOpabO1O0	xgZӒ}|!FO`#`5`2$pCH@`b!ApbDJFCY YOx[OOTyxfBFEOfXPYQa
xc GÔ@π<@bTxcGPa@Da`abBaRaGZTrHUtpcxhJJ[v+xfv2 5p4}t kt0㐿}= m	"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTׂAT6R7 8G9HO;|INR{r$QI!0O`Od`TuOR<H-H9HEHPHzHHHHHHHHI
II)?IG9T|D%~$C CKpAXAT| $UAPA| '@$@~p@' &;TIڇSr;Sx7؇LABha2U~@<0PS\ODz=ēd
`#@}w`@}(`@}{<`pdP`@}d`R 209KC{ǹ}ttdaKxtxxXx\t x]xat"xbt2#xJxFxBxtx(tb}0Dxxtxtxxtx@x#x> x=tQ x@tp0xTВŝ"x3tĢxaFѡx!TToTD	ʦxTpTx=Tx"PPT=D"Dæxdv0}<t 1FPBPGPEPA}D>"x0xM"xa@P;"bpS?/?@>"ޑ$tk>!$-"Tp\Ô
P~0~7%OOXNNrи7%NN{ z yN6@~K K+L3L
4L6L7L"8L-9L8:LC;LH<  LM`7NY$Q@Q`I A౱0PG1~5KuN& 8C ;CuNuNK N"$`($_`*`-`Q/AWp4`
 Tma7Bp<ALBBFBEBGBA@N$`$`!`0`?$apA_>p:3@2r*}_0  puS.qčr,@ 3`G`[]Np_7"N0dpF_e$kC`QDALWT'p. N00@O"K}$pL`nPP:Kd`ИKxaKÔ PKKdKȭQ@P
:ۀPxav@@~NdNdNdNdNqNNNNͨNNOO	OOO1OsOxO}OOOOOOOOOOOOP P3  P:0a
гv"xzMNO`uL 1oLLx@`}Zdmxy峑mp")L1
OL>`Phr`y"} H?K}UfPAb"uM SMMDpXTM0CM|80^ 0@tރx[Dav av*ppxTxdoD0x7px xP@C`}_K}I	
p"35KxN| } ~ Mzǐ41 VK`q R<LL R<P]((sPPQQQQQQPPPPQZQ`QmQQRRR+C~pÔ`PڭKLV"T?	} 0xti"KMKAb`yJc0
V	7Ph50}
TPd>uK6
@@b0fa7 %P@l
M"G$pQ
?Kp."xydP "{z}yZ	z<rLL%ٲpQ
Mqcuqgcz1Y?0M}8T ppqp 3|p !K#T0P$___QfpARe0#`70xD  *TQaxpb!1%%x v`gq٦_eT1%e*+7,Yex).u0/}+t  $0.TP/00//@"R0  "/P/+u'3" 2  /2}P/",./S2-S2,Ô`,pC-S--ST 36-0"
Flxp0 "@lŝ7xP:xҦ/012*@t?0t /xp+x?D%?0/2R1U2B2՝[xx=pD ?xD C  CpD@æ2x{W_ WPF}WTrTTUUIV'VVVVV2x
,-q=x
tG,P
-,`x
LPMx
!LJ>{Sx
!L #G2AN0"t "T $Qxl	}INBxk RxkP2S0 K%S$IkN R$ÞPxxk=GbF`WAN_._)*ux+ L4^үPF$`& p<SH}_d]p`C^XFx+*)2IWAN$xxl e@v>`R:xkvykxlsPVS  >qSU0{ 	RT2
JTxov 2WxqW`r<b
௡gANfgPJPb>xx
x2NJx	02W)_7P$PN0lO02[l@~WG WNWXWbWiWuWX!	XR
  XvaD4Z3tD@ @Z5"xD @b$P``3@b0vTO!!  +De">x"vv&w`/xxy@^y *Pz@z{yea^*`Os`}lb33TOs1x D@PÅP 4A"KƐ`p}TМ`- ,*))D8S)9S)x_vS)Љ)"(),0,YRYx	`}NFYu- u.<SS0S0u/ u1/U-0U.Np.%.-3-111P-2xp7x	1.-A^_22􀐒N,xalp [2-ÐsPp--Ӕ@zg0a`ҀZ>ZMZaZrZZZ[[%[3[A[V[d[r[$[%[&[+[,[-  [,`lә[Qxu,x~0cäK*+KP
/+*M9
x¥t?e+pOt e*Ф?	S??`{kxЬ}}Czt Հ-h t_,_v`ao} atauava}3Πk'1րA6H 3_K1 7Ѝp)(ߨ"`t G]P:\D\K\R\Y\`\g\n\	\\\\\\\\\]3]w3]  {]j]jUcccca
tt)r Nrc	c
c`2X*aZȠ^T`Ó!KJaxT0BK
r:4 t@bK'  2T`$!J!w2nmZJ`!a0DTGt( Du4c䣒Ӕ2nSTx2NpaPF`@<D
A~@DA "pgqD13"0,p'
  `vӿ""0.p`%T"" 0[P2%$e` Me1p<2◖30 ϓ3d	`3

3 7xgv"Ô
@"2}2416.(1$`$`$Ap 2^"[_	WP⪙;ұ쫖␕
Dxg10Mf"
"xQCT2 C8p_70e_;>"` 0"$``!`"`#$p!F0 䐳
=#"x%ts%13x<q?d @"rW}t^0	W
A:x00Dx!ToT`@)D0D%T1E
 |p!?!D`%!TM.ñʞ
A݀"  :	;
Z
123B=>C	D

P	~x`!ÔP
^`_c"
%`60FF`7@<0x(
(bxA<bh(($=`C0.+xT 2E} 2zC.u DT_`
& ь+@@00	2
 bDJS0cx($```9`B$bDxv zq DxTҎxStTTH`(xS(<x)2)$``$p#@hxSwx(	x02o0. 2]#0`
"*+*Ô@*ӔP!&@
%PR6*$a w$cp!0.-C+(}+ϖQ)zSi+*cď%C++2P%% Gcd"&Gn,@'@o'~``J`N`R$dpT}++A>c"+0T0dp0A00ӀÒ].y+y3+@*"*+oiE"N"xP"5	1}i`$3mp`1_}y:,/0qdddՅdۆddddeee:e@e@ebebeeef&f&fHfHfjfjggg%g%gGgGgigiggggggh/h/h?h?hahahqhqhwhwhhhhhhhhii  i9~(i<00i<C/yPGFT3/GC/00u6$%U 0` @R/@IPGu/H}/bLLL,}鉑LrI%UcNpˤNQ/OL@NNOQJ"NNS"NNU#H P ~PHYrII{LAҨrIIӝ  -GY~ L`| }_?@^_GNNX"NN/bsL[][ӗ ]f\[dgF| ?`z {_i@\]L`\i[-.Q\6Qk.@N.-JONOd"NN)o"NNr"NN?t"NNt_vMf@#@iP0-mYnMy!Qzz{\n{dz ONx"N(@;NɆNο"NˆN?"NΆN^`,$/0NI/I5 J/9V I0AZ!@NNKÔ@πu/ ,/ y`  SP]PP:!5a񧰔M:;~$`jPj$$ jy`T}!Z$;`!!xl UI աJ սKxi<<xlP<oAp'~p'0#70"p@"; p"$Z ;nO❨ J K Lў<xlp'"678x>T934T`љԶÿd@l0_9pஐ4ir@}5@& 4@P| $ >678 Pd;ppN`2"q}op~&s}n{~Ak50802/}}P0%TTm/^^qt
Ԫ }( pe((@~&[×2]cvf@sX$~̻@&8}pq}{|n؏ 
0/mkk"/0PlrҠp^ }p
T?T`0"0"@;u0<.^.`~ K~^J2T {ITO˹I..O/p3@Iz*&R1 G@;.01~ް ~;PC14~FpZ1QP@JB1TIIp043C,V`&J@@ =`@ԑ1"x_0 
T_
O"0.32ϻ `,nסm/e.`.܈܀^e.`n.ov^/ m/0}C  k~#AQP	D7# @T3``1"2 2`p̰2.Ќoǽu.B!/Su.^`} K/}]_\Oӝ]/[Ru.P2p/.\D<fB'\r[\մu0o X @.~0P`TzTT%%̴p0`DY0`
~J	.d`·/ӟ@		O"\Gj$rt@$5db5Q$OU$%5Eeٮ%tx$ݮIt}5}{z~yAɐ`rٿ/`,rw00t9@!u"η E~ ʎ_`-˥t~@_Qq"1"¯01Q`
tz	ϔP1үpan`i | K|\`0023Q^z4$ z3;131^ys((sstNtotttturuvvqvw.wlwxRxsxxxxyᗳq{	j155fPQ/0;a7#1?S>U?rCu2`u3 ?{ z y2
Eb4{F2T`pd``+zC>
E>U>^Ke4>
_?)fe3p2l`&[{0. a{C>
EuRF4P4"&9^bz`_ip455544>e
45W
 ?X_YZ[\EI^7NljOƶ>PfRS@ԉUsNa_dLpOʶ>

E3MbUo̶>pN&0ppNO>hIv+t
vPOж>xi}`z\(?{>_KR>O><_J>=o>)>>?oM*vMOҶ> 	`z
|QDL͘09kR09R1Tl>; 3s>1p("0¤7>}頯1B+1 %u{1(#q1$`=`lp{4$`{ou1ڤ!ux{@Mn3x˩dE|ptu|ޤÔ(qPq"x3TT Np\ q% @MBtڤ`	@pn!8u1˩tpu.3з̩ؤ131C|}`00?r̂*A@/` npz7g3/A"H"P(R*|p*a0}`Q"qO}u.31 O%p}^ͣ? X}^¾90pa0߶/A/. 1 ǳ$3/ tP"ʐ}ת1
~P2"""0@t%ܳPD"LION x1x2`TTxDxD"0"x04 03spA3"43px"Tq2Ⓑ4pDÒ44"56"x&3~oTO&0"x!To`	 xDT"	F	>߃	2Vx3pOdPX#BLҀԀi3ꀚڀ3!䓣łŃ&
! "/ߟ۴@̈$ P@##EN``#\s""P"]"4"  )"@/33@" 3@"P"(0p8 
"߇		D t )ς:q8"		%
"*
 pP				"w4p2
"""BBE"`;a3Ap"""Ѓ?Ђ patsߨ6s ŃŃQ8"%5 p p
 sh`ߡp""~a"v"n$e"b%"V"UJe@11V)pp_){pΦ]d#s o012346 /7O8o9:;<=? /@OAoBCDEFH /IOJoKLMNOQ /ROSoTUVWXZ /[O\o]^_`ac /dOeofghijl /mOnoopqrsu /vOwoxyz{|~ /Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&') /*O+o,-./02 /3O4o56789; /<O=o>?@ABD /EOFoGHIJKM /NOOoPQRSTV /WOXoYZ[\]_ /`Oaobcdefh /iOjoklmnoq /rOsotuvwxz /{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo /Oo  ?_ 
?_
 ?_ ?_ !"# %?&_'()*+, .?/_012345 7?8_9:;<=> @?A_BCDEFG I?J_KLMNOP R?S_TUVWXY [?\_]^_`ab d?e_fghijk m?n_opqrst v?w_xyz{|} ?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ !?"_#$%&'( *?+_,-./01 3?4_56789: <?=_>?@ABC E?F_GHIJKL N?O_PQRSTU W?X_YZ[\]^ `?a_bcdefg i?j_klmnop r?s_tuvwxy {?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$ &?'_()*+,- /?0_123456 8?9_:;<=>? A?B_CDEFGH J?K_LMNOPQ S?T_UVWXYZ \?]_^_`abc e?f_ghijkl n?o_pqrstu w?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_  "?#_$%&'() +?,_-./012 4?5_6789:; =?>_?@ABCD F?G_HIJKLM O?P_QRSTUV X?Y_Z[\]^_ a?b_cdefgh j?k_lmnopq s?t_uvwxyz |?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  ?_	
 ?
_ ?_ ?_ !"#$% '?(_)*+,-. 0?1_234567 9?:_;<=>?@ B?C_DEFGHI K?L_MNOPQR T?U_VWXYZ[ ]?^__`abcd f?g_hijklm o?p_qrstuv x?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_ ! #?$_%&'()* ,?-_./0123 5?6_789:;< >??_@ABCDE G?H_IJKLMN P?Q_RSTUVW Y?Z_[\]^_` b?c_defghi k?l_mnopqr t?u_vwxyz{ }?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_ ?_s     
     U$   4 G  N U  fWfVfSێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.15 Copyright 2003, Infineon TechnologiesQfSfRgf.g.3g.

Ƈ}~ǇvJ gf   uq u QfP< fXfZYQP

{At2[RS l eg{q "  诟3[Za@
  
a 
5
; a[g.Qt|P@f
 DF<d~ug{$u	N"##:o3ff@~1QfW
Pf6ffffg0f3ɹ 
Q +r&u3gb&Rfgݎf(g3fGf_ \-"& gf4$ +Iffgސ0fG(. J&>/(0 1	.1g/	2fGg&q/g_f6f6s47f76_Jrr&v:7Z$8x8g6{47S6<|.=}.=~'=0  f_fYڠZ@!3RQ`[DaDD3YZRfQSDڃ <u-Hu!HuH u3
߹  4 pgx@FDMDwTEPE 4 t L3 s d 0SPPJuOD0Et  ED&NbAE'CWUDpDEqDFh
Tt2@]Cf[1^PQP fa nd) f t|gf> tub~ {tm1c te1c t]ff 8N 8^ 86
f;s"u
 '^QΒh1 
@K [W)Da(g Bq^ 
_3ҷar& ~A *u
r& ur& ЃuBwog,1-[0g#sf8魾uqq@ L	uqWwS/uF"0~ouS p2zIƀtB 8t$2 8D$e{ff+f+Ȥ{92z3{pu~` SY^@QQ{ 8wL$ 8	25
|0 Y Bl_3 zǐo 7muj ),,Q tLW)ff3fsf%ffK8s{`fClQR*gً1-*
tffpUf;sg^,g,WZB%V)&6Gr *fss2tQtÓ1 vfV*ʻ *쓫ʚ<ڛ ־Ƈ,d +GĚRP_EQ! [@FPQ `~!fRS2 Q@\ nZ"AA 0BÀP;P s
E 0 Cr
 xRO_f3g#~|ǃrtfwQWf9ˉAP bA 1^S*pQ$"PrPrt Dtt%53A. )0 tн t1@t`5t
I o:ɚ̙&!'g%aa fQVPmQ\0l0"AA|!26Ps؀P"rc2ېl ɹ@b&'"ff+f}HlhUOBB`%Q%`
Go!tO"BY&Ѭ1OsѬ1Or
q"tfu`3yȀUq a 7pTPsIu3PBHa8 XHPS! 6#a P [Xp$
pqSq[ 
 tKCX 裝P0#"3`   = 肦r2#fr
fff#@k%  t	f!bf#fk%tbx 9$yz 4Fidk  4Buf0b!b/OoV9  rX%  t9  t
%  !&  $  s9r%  5  r%  5  r5  r5  8  9   撰68BAS   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $   r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  N  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ Z  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 4  X  f=$ J  f$ f$ f
    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 9  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t<  $ =$ u	=$  w$ $       f$ $          f=$    f$ $      f=$    f$ $ wf$   ;  bf=$ uXf$ $ $ Cf=$ u9f$ $    $ f$         f$ f=$ 	r	f$     B  s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz/ZXfPfRfz$<fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytCsZ[Xfz/fyu$sZ[XSR=$ tO$ @
 fyf@t	s/fxfz-fyB@u	sfz/Z[                                 P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPQfp#fpfpfqfpfq`fpfqafpxfqfp fq0fpfqfpfqfpX         r
   r   SQY[           V    .K9 ^V  .O9 ^Vw  .S9 ^SfQfRf P=$  u +=   sf 0 tW$  Sf  [rRSUU*UUUUU*U[$ p  1r<u   f f  fZfY[SQRXr   $ tZY[À=$  u r  r@$  fPSUU*UUU[fX$    r
8uf f  SfQfRf 0=$  u +=   sf P tW$  Sf  |[rRSUU*UUUUU*U[$ p  r<u   f f  fZfY[SQRXr   $ tZY[         PSQR 8 G$ffG$
@ظ 8 G$ffG$
Њ  $ff$
 ظ  $ff$
Њ  $ff$
@ظ  $ff$
ЊZY[XPRS  $ff$
$ظ  $ff$
Њ 8 G$ffG$
؀㿸 8 G$ffG$
Њ[ZXn6 6 26 =7 6 W7 Q6 6 26 WUU*UUU#  'G_PQW3   f.;I9 t3_YXfP NNO<uNNO<tNNOtĀ fXðNNOfPQP  NNO
ﰂNOYfXð      2ffSfQfVfWf   ff   2fff   ff3 7thf;|uf;Du7f   f   f30f\0fy   f3f3Ҍff0f   f3f30f   f   2f;Tuf3ҝff_f^fYf[	!)                                                                                                                                                                                                                                                                             b                           IFt1vT"|} Pa>c(^)|'6CrT[Jy-Awg(^&1>G?D&W,ҷEVrfz*UqF;%d%Ev4\ω7,7C3KS4.HɸaD)c%O?+Ǌj&j(@GNpQрOXNqKa
Ԍ02S<{{D&/	5e	mduNto@mbMɡ{ǎWN_ƭd\?*]n"P1 ywvj: TY,(.TjLy}Rs bL43E
䎫j,ƭ<Ǵ2+vAt|3o;n6}70+=辸iG,N@g!CVO(:5o ]]`c:=cވ{>Oۨyh)U?ZH-9Ć@FAnr'Д/K!t_3/Zg?5bmR!`
9YG&$iV3P#Dֺe2HRk]>
xQgH]<C6<<g7zwɽ)$@$^ :Dǉ/' ZOVAliB-Zfa+y\*Af;
 }hw$;43B"qdV)]VH11s.4]F TJ/{- ~V&xm }
oל%adE}ކsg39Vmr`d;Ze]$y+U6~%y-	+|AX6RT[Mf+L*ޘRnhB׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE       "  tm4                           f~94R8Dsx^A`96b@kpgs9ԏS\})(d<f*̛(m:FW:9DT!zcUDh֏
^3,Τ\
8f	߈|	*Jn̄2CC~pF[>%/\tVyGۯ*7$ AkoxLŕ[Z\J	|Э0a!QQׅa_FH8qa]Oۂu秈]|xڵd|$SN(Et+3׫[]bKY/n<;ѧ҄Wkz㫷
Yvdo%9fmTL	nIxƼ29MEi!jJ-r%vx~
mwǖ)fL"^g{[AUOP(IcKۆ^Va_;2ʠŷSh)`cǥm'dN5~ù+8a!"LF{M怂#,뷿Bh.6DR
{h;M/cTDގ7գLloŤة2χn]*ѡ8CL/g1+f3#i%co Bvl7_BEt.Zx~i$/ftW
P/64hFC	%! G Q2;( аrYɵ2/nxs^)4흥 94JIn8-z9N/fj۽_pz}[;bï"8?9;U	NZK;#7-oښm׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   	    	  !}                           eoղGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:׃FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm⽻]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbܟka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlٱwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋬ׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         G                           
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_œ%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzմTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4҉;jQ0\ǁK15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwyꤎkK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]hÔ9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC ÞUEu;iTBܐx/Dz1J8pQ?h
\Q	ʴL
mvfCG=;k׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE      f fff戰䈽!   戰K  `  戰   戰䈻              u׾$   $   u戰f @KC8BBaaff fKua$aff fKuf f u           ܂  Ӌ  ܂      ܂  ܂  VQN   `  ܂  aQ  J   a    ܂  Y^ð   ܂  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP    @t
	 %"XP 
   `"	X                                              `   Y$ffY$
0ظ   Y$ffY$
ЊZ   $ff$
3ظ   $ff$
Њ_vaÐ            þ P                                  t.'4/:@Fw4慰 .fˋf   ú$fӃЋf.#W.W.fˋ؋f   úfӃËf˃⚰Lf   
ú$fӃĊÆ@  ؋f  úfӃËָB  ؋f  úfӃËְmf   
ú$fӃĊÀu$Sf  
ú$fӃø a؋f  úfӃËָ  ؋f  úfӃËְLf   
ú$fӃĊÆ$ Q.fˋf   ú$fӃЋf.#W.W.fˋ؋f   úfӃËf˃⚸ f   ú$fӃЋÃ uOp f   ú$fӃЋÁ p ؋f   úfӃËָ f   ú$fӃЋÃ uN f   ú$fӃЋÃ⿸ ؋f   úfӃËLf   
ú$fӃĊÆXf  
ú$fӃĊÆ$| D $Lf   
ú$fӃĊÆ$of   
ú$fӃĊÀƃfʺ2fȱ ..'8v.G 
.Ŋ.'8v.G 
.f.'8v.G
ȺjfЋ.Ŋ.'8v.G
ȋѸ ؋f   úfӃËff3r.< ;t	f.Fи ؋f   úfӃËf.Ffи ؋f   úfӃËf.FfЃ@ ؋f   úfӃËf.Fи ؋f   úfӃËfff   
t@fغ  ff% f؀f   ttf   ff% f;rLf   
ú$fӃĊÆ f  
ú$fӃð f  
ú$fӃð f  
ú$fӃð f  
ú$fӃð f  
ú$fӃðpf   
ú$fӃĊÆ$?qf   
ú$fӃĊÆ$f   
t@fغ  ff% f؀f   ttf   ff% f;rpf   
ú$fӃĊÆf   
t@fغ  ff% f؀f   ttf   ff% f;rpf   
ú$fӃĊÆ@f   
t@fغ  ff% f؀f   ttf   ff% f;rqf   
ú$fӃĊÆf   
t@fغ  ff% f؀f   ttf   ff% f;r󰀴3f  
ú$fӃð3f  
ú$fӃð3f  
ú$fӃð3f  
ú$fӃð f  
ú$fӃðLf   
ú$fӃĊÆ$Ǌf   
ú$fӃù .fˋf   ú$fӃЋf.#W.W.fˋ؋f   úfӃËf˃⚋ϊ2.# ո ؋f   úfӃËֺ   ؋f   úfӃËִۋf   
ú$fӃðf   
ú$fӃĊtٴ ۋf   
ú$fӃú
 
ո ؋f   úfӃËֺ

ո ؋f   úfӃËִۋf   
ú$fӃðf   
ú$fӃĊtٴ ۋf   
ú$fӃú
 
ո ؋f   úfӃËִۋf   
ú$fӃðf   
ú$fӃĊtٴۋf   
ú$fӃfʇո ؋f   úfӃËևffϋո ؋f   úfӃËfո ؋f   úfӃËfffűfff2ffȋи ؋f   úfӃËff ؋f   úfӃËf< x( Px <Zx(( -<KZi
 (2<F %-4:JZZ O  O  O  O  O  O   O     P `0p?/`?f̼Yff̼ ff̼ ff̼gff̼ff̼ff̼*ff̼6Ef22ɵԼI < Լ_rr< u~Լqr`<@ul	ԼrN<uwZԼr<<uHԼ}r*$u4Լir<w"ʀta ΀f33 ft`յԼ r8vеԼr8vfյԼ4r8vеԼHr8vffrf3f3 t0
Լr"$~t2t@ trf3f3  f3ҲԼJrnfɊf$еԼ0rTfɊf$ЀrCw>fft:fɊfɀt+fɊfr
w
fʀf͋ffNf    Լr f$ش..:	~.	fԼ_ԊfԼKԊfԼ7r>f .: .: 
s?"܆ˆf"fFff̼O7ft0f̼]ff̼isff̼u.ff̼fʸ ؋f   úfӃËָ ؋f   úfӃËָ  ؋f   úfӃËָ  0؋f   úfӃË֋33f3gf&UUgf&GUUgf&f   f=UUu&gf&UUgf&GUUgf&f=UUuf   rΊ3fʸ   ؋f   úfӃËֺ  ؋f   úfӃËָ   ؋f   úfӃËֺ  ؋f   úfӃËfʎԼf 2t3 fʸ  ؋f   úfӃË3Ҹ ؋f   úfӃËָ  ؋f   úfӃËֺ ؋f   úfӃËfʎԼ42tff   gf&ZZgf&    UUgf&f=ZZtf=UUt6 f   gf&ZZgf&    UUgf&f=ZZtpf=UUtlbf   gf&ZZgf&    UUgf&f=ZZtAf=UUu1f   gf&ZZgf&    UUgf&f=ZZtf=UUt2fˎ d <t벺 d <t` d <t. d  `u_<t d <t`fˋ䣡 T X   Z    \    ^         @          0             Д     Ԝ  O   L  TV B dF  ?L
h  ?p!r t  v     |    p  r  R          D          @8     D  !        @8     D           @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        09/15/04BSA  U<ps                 d$ $PnP       o              
Copyright (C) 1997-2000  Intel Corporation
 Intel CorporationIntel Base-Code, PXE-2.1 (build 082j) $    I $BC$+   @:^   
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 thP~SwQpRibWZT1
-AX- -BX- -CX- -DX- -DS- -ES-:-DI- -SS-:-SP-
 ÜPh)tX
Waiting...               
  t^@:^ 
h h@ UfPfSfQfRfVv&  &\f?UNDIt?h_& o
PXE-EC4: UNDI ROM ID structure was not found. Gs<hk& '
PXE-EC5: UNDI ROM ID structure is invalid. Pj Sj < uf. fGf;sff. ff. ffGffGff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZNffW.; s. @ 6& ԋfPfSfWfUj j fj fj RfRVQ@ & v &D6E&D6E&D6E&D6E&D
6E
fFffЉVf. ffЉVf. ff6UfGff6UWhTw
˃f6UfVf6UfV
Z cv & tl tc" tZK tQ tHh]Rjh*
PXE-E09: Unexpected UNDI loader error.  Status ==  P
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>  u=h$v & 
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sLh\Pv &  r
PXE-E20: BIOS extended memory copy error.  AH ==  . f.f^f. *rv&D &L. &;D&s&D&fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(Dv
F&DF&D&DPj Vj &(D	v &D6E&D6E&D6E&D6E&D
6E
Wj v&\Z
  Wjuv&\Z Wjvv&\Z  t  uj@ H FF  RWjv&\Z  t{Xt&t
 u tfS^
G HF+F)F[fSVWF  6	fff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 v&< f^fZfYf[fX  t ]˜= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]r.>  u	  . 	Pfj j .(   fZfYf[h
1P<Xt/
Press <Esc> to abort ROM initialization... fPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j V< uf>  tf . fSfQfR. . .2 <t8hq
PXE-E06: Option ROM requires DDIM support. f    ff    .  f    ff  fRjfjf. ffPj hfQ˃ffu0h;fZf    {
Invalid PMM function number. f u)hqfZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.. Pj h j .( . . tf.>   r
.                  blksize tsize                                         U ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j    |      
CLIENT MAC ADDR:  
  PXENV+     GUID:   
DHCP. PXEClient:Arch:00000:UNDI:000000  PXEClient CLIENT IP:    MASK:   
DHCP IP:    PROXY IP:     DHCP IP:  
GATEWAY IP: MD  BD  UD  
Auto-select:
      
BOOT SERVER IP:    (  )   
Auto-select:
                                                                                                -->  MTFTP 
PXE-T :   TFTP Aborted  ProxyDHCP service did not reply to request on port 4011.  Client could not locate a secure server Missing MTFTP server IP address BIS bad entry structure checksum  BIS get signature information failed  BIS free memory failed  BIS get boot object authorization check flag failed BIS shutdown failed BIS initialization failed BIS image/credential validation failed  BIS integrity check failed  Network boot canceled by keystroke  ARP timeout TFTP open timeout TFTP Error - File Not found TFTP Error - Access Violation Error received from TFTP server TFTP unknown opcode TFTP read timeout TFTP cannot open connection TFTP cannot read from connection  No DHCP or proxyDHCP offers were received.  proxyDHCP offers were received.  No DHCP offers were received.  No boot filename received Invalid UNDI API function number  MTFTP cannot initialize NIC for multicast Error while initializing the NIC  Error while initializing the PHY  Error while reading the configuration Data  Error while reading the initialization data Invalid MAC address Invalid EEPROM checksum Error while setting interrupt TFTP too many packages  TFTP packet size is invalid Media test failure, check cable NBP is too big to fit in free base memory Bad or missing discovery server list  Bad or missing multicast discovery address  Bad or missing PXE menu and/or prompt information Could not locate boot server  Invalid state returned from UNDI  PXE-  Invalid message code.
   /-\|            
SM/DMI BIOS functions needed.
 _UUID_  
									       
      
 f~ u ːf~ u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- r- v뾐:: 1LP3 뫋F fv?FF^&)~!~ofv'ҐfvȐfv뾐fv-Fu
hx9 i[F 롐fvFth I[fv[fvmofvАfvƐfvA뼐fv벐fv=fv?	3=1 tw5-  = }.f             $=q )w-2 tHt-= 7-s HHH!3  F  
9  >9 t  JLfFf99f2hP99@t{<IutyIu^h
JuShRF   }R^
RF9*9Fr䡸93MuIun>huYu
"Ft1J9NMqIH~ t~tEVjOhRF FP)Fu9Fu9R 9뮐U>9 t>P3 u>: t  II9Lt9 9 9^&9   V3Y-  +ҊԊ*҉FVFP+$FVu3^Ã>3 t3+ҊԊ*ң(3*3(h2fj vPfj  E/t	f(3    7f(3*3f9FsEy WN뜐T3 fvfvh2fj h96:6:6636H3 |3O8tְE뽐>2u}(3*3% (3ҀĀ FVf(3fFGT3 fFf+(3fPfvh2fj fj fj fj FV37ufvfvf6(3 |K
u	E" 9Uhx9bWFFV^f& |  PVr$=NVu^F^f&G(fFXfv^^  ^&G- r- v  &iGNF^& u*&G^& u=& u6F&GF^&G#&r&G^f&OfQfv&GU3   >9 u  >: t  >P3 t  G|F9f&G    f9  fP2 ~Uf9H fP2 mUf9@ fP2 \Uf9P fP2 KU9S*&GP9&(G9&G0FF  FF9&9G6 fNfNfQhhHT7Uuh:T^*&O;~S*\P
u3^&G^&G^&G^&G^&G^&G^&G$&G
  &G^S*&G
P^&(G	fF^f&G9(It  3!V;.33   ^&  t&  }?  >9 u  >: t  >P3 t  Eu֋FV RPF RPF
 RPF RP^3& 2),u: >: u  3*E3:   >9 u  >: u  >P3 t  fF fP^f&OfQ|1F^&G  F-tHHu9  5  F^&G3   ^& >9 u  >: t  >P3 t  Cu^f& GP P P P& & & & & & 33^&^&Fuf(3f& 3 f&Ǉ     F   >9 u  >: t  >P3 t  ?Cu֋FV RPF RPF
 RPfj E S3ҳn*F2CF^&~ uf(3^f& ^f&Ǉ     F=3 =2 }
c F -6 tHHtKU>9 u  >: t  >P3 t  Bu47f^f&GP33 >9 u  >: t  >P3 u  B3P3   >9 u  >: t  >P3 u  FN~ tIFV RPF RPF RPF
 RP^f&OfQ&G9Ft^&G3 F^&Gv  F>9 u  >: t  >P3 u  ^&
 uQ&G
^f&OfQGPGP&G&W26uF3 F  fF   fF   f+fFfFfFfFfF$mIfjFPvGRPfj*F $KI~ t
E! FËFFtE# fFf Ð  fF   ffF$ IfjFP	GRPfj*F $H~ tE! 2FÐFFtE$ 萸 Ð  fF   ffF$HfjFPFRPfj*F $xH~ tE! EÐFFtE% f~ t 3  RPfF   ffFfFfF$ HfjFP)FRPfj*F $G~ tE! REÐFFtE& 萸 Ð  fF   ffF$GfjFPERPfj
*F $G~ tE! DÐFFtE' fvFP|E L  F+;Vr
w;FvFFF3fvh3HE^KFV "  RPfF    ffFfFfFfFfFfFfFfFfFfFﾭfF    $FfjFPDRPfj*F޸ $F~ tE! D f~ uf~ t  3 WV2   It2^_2&sE( C^_ÐS*&G7H
u⸀22f   ftrHuVHu0HuHu 2^_  RPKHu0fvfvfvFVFHtF  ~u  3   SRPVf~ tDt@u2^ F+v
rD7D0^N&FN+FFNu^ 
  SRPWVF`4^ht32 Kt3R3u39v3h3h
 Kf2fx3 L|3^f&cSc>
  t^&G^_ FHtHHt- tI- tJ-
 tE~3  ^& 5F^& FFHt1HHq- t- c-
 \|3  ^f&f3뷐^& F~u!^& 2F^& F^f&^f& ~ ^& 7FvF^& F^& F^& F^& F^& F^& F^& F^& 
F^& F^& F^& F^& F^& +F^& 6F^& <F^& CF^& F^& F^& F^& F^& F^& F^& F^& F*F^^&^& 9F^& F^& F-  -  -
 t^& ^& Fu{>  t4  h"(CcG			th&Cf6	Ch. Cf>	 t.^& aF^& F^&  FfFfPf6	 AI~u(^& 6F^& F^f&^f& a^& ]F^& FGFJ^& ^& ^F^& F^& F9&_&G	^*& FF9&_&G^& FF^& <F^&  FfFfPh6  HfF fPǺ
  /fF fPF
  fF fPF
   ~ ^& +F^F& ^& GF>  t'^& F^F& ^F& F^&-^& F^F& f% !I^& ^&>2uM^& F^3& ^& FF  !^33H^& &PF39F|^& F^&^& ^_ .@f2fj fj  3Qf    f2f88ht3fj h: C$,h:ht3GUPV3^*& BFfFV^f&G<^&Ǉ  ofFV^f&G@fFV^f&GD̐fFV^f&GH븐fFV^f&GL뤐fFV^f&GP^&Ǉ  ^&Ǉ   fFV^f&GT֐fFV^f&GXfFV^f&G\뮐fFV^f&G`뚐fFV^f&Gh^&Ǉ  ^&Ǉ  ^&_h&u 3^& cfFV^f&Gd= )= wA.JNl=
 k- &H5HD- t-; ^- t^*&@ 9vO^   PV3^*& =4 CtHtzHHtN-
  -  FfF^f&GfF^f&G^&_f&G^f&GpdÌ^&G&W^&_f&G^f&Gx;Ì^&&W^&f&G^f&GtÌ^&G&WfF^f&G$^&_$&	r"^f&G$ fPhX	 DuF F  F*^&  Ì^&G&W
^Sf&G fP&_*&G~Ì^&G&WjfF^f&G,h^f&G, fP&_,*&G@C^&_,&_*^&G|&_~-5 {H- 	- t- t:^*&@ 9v^f& tf&$ u&  u
& & ^ U^&?t3 f2f&9Guf& cScuf&  t؍GPh
9*Cuø    WV3F Dvvv^&7Vj
 & RPfXfYffff88 9 7:fj FPfj fj j 3Pe+thBtix  RPhVBix  RPix RPT
ix &n tF ^&ix&p tF F Fix=zP^&7~ u~ t	^_ 3^_ UFVl RPFp RP 332ht3fj h: C$' Ȏ  ǆr Dfj
 & RPfXfYffff77 8 8fj rPfj fj j 3P**thtȍtPhBf~ t^&uf~  tfF^f&9GlufFf&9Gpuh&$h@fFffFf2  3 UhfFp fP
 3
21ht3fj fFp fP$x& Ȏ  fj
 & RPfXfYffff66 7 7ǆr  hrPfj fj j 3P)t̋r- Dt-guhttPh)f~ tf~ ufF^f&9Gpuh)h?  3 Ȍ  PV3F}Pirx  RPirx  RPtʍtPh)
>2u~ u ^ÍtPirx  RPy
FPFP 3`0$0ht3fj FP C$%3^  RPVF  ivx &t u-FF9F"ivx &n u3FFF>2u
ivx&v uF ivx &p tivx&r ivx &p uF  FF9F}.ivx&n tivx&t tۃ>2u
ivx&v u9F=F Pivx &p "ivxf&h F  FF9F}
ivx&n t9F-ivx &p F  FF9F}ivx&n tivx&r u9F ivx &r ivx&j&hyivx&t {ivx &p XF  FF9F}5ivx&n tivx&r tivxf&h tivx&t uF9FH= .> zHivx &l t=h&$iFxP<ivx f&Xfivxf&`f2	 9f    f2fiFxPiFx  RP_ivx f&\&^fFHHHHHtHtiiFx P 3ivx f& t&ivxf& fPivx&Ę&G*3Fh92 ;F  h92 ;FF9F ivx &n tivx&r uiFx P Y3ivx &&t&ivxf& fPivx&Ę&G*3iFx   RP 3ivx f& t&ivxf& fPivx&Ę&G*2F F9F~  h)h&$: iFx P 2ivx &&t&ivxf& fPivx&Ę&G*K2iFx   RP 32ivx &&divxf& fPivx&Ę&G*1;~ t3h)iFx  RP9ivx &\&^ ^Ð3^Ð  RPFFF  .;3f~tf~ u
F C D~ r~ rF  hFP^^ V~ Cu~3*=*ht3fj FPF$2F   SRPWVFF  fj
 & RPfXfYffff*/3=0 0F  fj FPfj fj j 3P!kF- Dt-g\hOiFx  RPh8iFx  RPiFx RPivx &ĘT&uF Fivx &ĘT&9G F9ivx &ĘT&O#N; ~ taivx &R&P ivx&ĘP&G&WI9FVF  F39FsF^93u93u39Ft[~ tHF  FF9Fs-^vi~x ؎Ff& &P f&;\uȋF9Ft
FiFx=zs	-`F^_ V6hb0h1hn0h21f> t&ff9thx0h0h0hh0h0f>9 t@3f9 t1ƹ +uhc0 R09P0 @0Frh?0^Ð
  WVF9*f|
f2f2f: Dh:2[6f    ffFdF 5 9F~F !uxF ukF u^9F~
F uLF u?  F~}/^ۋ  FPFPtЋF g~ ~ u
FQ ^_ËF9FuFR ^_ÐFS 3F9v~!ix &n uix&p tFU 9vu1~ t+3F9v~!ix &n tix&p uFU 9vt1ix f&Xfixf&`f2ixf&\fFF^_F3^_ÐUfv2 4^f& u 3^& fvfF fPa^f& t&_&GtfvfF, fP@ 8^f& t!&_&GtfvfFl fP (^f&| u^&l tÌl ^&G|&W~^f&G^f&Gl^f&p u^f&G^f&Gp^f&x u^f&G^f&Gx^f& u 3&  Ȍ  >2u4f~ t-tPh-~ uEz k*3 fF^f&tPh)f&)f2fuFFtfFf2f~ t^&G&WE{ 륐399f~ t
^&Gu43:f~ t^&G\43:FFu	63  ^&u&G	*&G+4*63FFuH3  ^&u&G	*&G3*H3f~ u39,3^&G3,3^&G39f~ t^&u
&G333  FV   RP>2u 3F     > w$fvFV;fvVF^Ftʃ~  >2tOh)f6 1f  fP ) f& tf& fP&ğ&G*z)F h-f6 1 f&\fF     > w&fvF3fj F33
tF T3   PVf+fFFfF^ğ
&Fu^ >2uNF  F	9FsA^ğ
&^ğ	&9uً^ğ	*&GF^f	 fF~ u$^&GR&GPt&_P&GtEw T'qF ^f&P t&_P&GtF  ~ tz^&_Tf&GfFm/h)FP
*^&_P&Gt(fvfv^ğ
F&Ft(^ fvfj ^ğ
3&F F ^f&P t&_P&GtF  ~ thfF.h4)^&_P&Gt(fvfv^ğ
F&/Ft&^ fvfj ^ğ
3&	Fu^F  FF9FsIb.h(FFVRP(^vf&0fj ^ğ
3&Ft^ 3^ USRPf`~^NvVFn
fa
 Ȋ WVF  ^&  hPh&$Ph)h^V6  u^V6  u	3^_ ~ ud t^f&P t&_P&GtfX u	   
  ^f&P  &_P&Guy^f&T u
v ^_ &_Tf&t^&_Tf& t^&_Tf&   v^&_T& wr^&_P&Gt@^f&X t&&_X&s$^&_P&Gt^f&X uw ^_  
 ^f&X thF  =^&GX&WZF 				^&_Xv&@* F^&_X*&G;Fw^&_X&G;F~^f&\ tf&` u
t ^_ &_`& t^&_\&r3R
FN^&G\&W^F R


R
ğ
& tR
ğ
*&G FR
^&_\*&G;Fw^&_`&8g h%3
*&G;v
&@%FFrh%3Fs
f9 ufvF@?Ht'&+h%h&)%s[f9 tNEx ^_ f9 t3+ǹ +uh;% *%9Po% %Frh%h
%*F  ~Is)^&_`v& $F^&_`*&GH;Fw^&_`&uh$ ǆ  ^&_`*&Gfǆl @ Ɔh$2	&2&%hn$%tO%= Btw3-t-,u^& Iǆ  t#)F  F  - [t- 
t- 
tאĞ&8t&
uu@)h#ǆ  
*&G;v&@#Frh# +G%
h #ǆ  ^ğ
*&G;v"^ğ
& @#FrȋF9vFh*#FR
9FrF
2$*+R
FvЎf   f^ğ
*&GhXfhp  j VV33Q^f
 fPfh  p VV3 )vPF+- Pfh  p VV3 F#=.t = t -t-t^& )~ tNh fh  j V33f
 fPfh   V3 vPF+- Pfh   V3UF+R
=KF{~ =F  kF+R
='R
HFS-	t-
- = K-w- 9t-
t- - Mt- t- t
  SRPV>63 u63$ >T3 u9 >T3آ9>
 tFu&>T3^P ^f&f2f~ u	24
^&&W99t3   F  ^v& ވv3^Fv&8 u^fǇv3octeF^Ǉv3t FF9~ EuEf~ t>^&? ~4Fv3Ph $&h %@FFv3P^&FF9~ t?f(3    Fv3Ph  %h  %@F^Ƈv30F^Ƈv3 FF9>T3 u
'@'F9N3  J3  63L3>T3 u
z'@v'>T3 t	t(>9 t!ht3h9h2F9t8 >
 tFu.bL3 z>T3  fj fj fj fj j 3P ff92uvff9u:9u1>T3  F&&;w&&; f9f9u&:9tfj fj fj fj j 3Pu|J>T3 t>9 u963L3J363L3J3J3= uE2 2 >T3 >J3~ EF EN3 &- toHHt	HZ>
 t(~ u"hdFhlhh>u; \>u< O>u	= ^ 6 ^ ~ t4ft3   hx3hp
 !$ht3h9h2N3 	> ^ >T3 uE%+Ht
N3  >T3 tff9u9u9ԡ%- F99F~L~~E? k? ^ >T3 t>2 uF9F92  :?h2 >#>T3 u3^ ~ uf~ _^&? SF   f~ tY^&? ~OFPh *u<h )"@FFPZ=~ Et9느9Ff=E  v~ t`FPh  uMh  !@FFPY(3*3ft3   hx3hp
 y"ht3h9h2N3 NFP!@F- 9F}FPi!@F- 9Fft3   ht3h9h2N3 -^    v9t3 v39 >|Y$#^&- v9tf~ tfvl#PQv9!>9 tht3h9h2N39w  v9 J3  >43 t	43L3L3$ L3| >T3 tQfj fj fj fj j 3P%
tfff92u[ff9u9 f9f9u::9/hhfj fj j 3P	t92u9 3t\i>43 u>9 u L3J3J3= uE5 i ht3h9h2N39f뻁> >9 t!+H>T3 t-ff9u"9u>9 u>9N3      Ð
  P3FFFF 1^*䊇N t~ uFFFFF:9FvȋF+F+2@Ffj
 fRPfXfYffffF~ tF9FwF  ^)FXF9Fv	F+FFfj
F RPfXfYffff;Fs"fj
F RPfXfYffffF~#vF#F  SRP9 T3 f+f(3Pj
 fRPfXfYffff63fj
 fRPfXfYffffH3f~ tR^f&? tHf&f9M}b  T32  F
:9 F :?h2 8T3 FF E43  f9f"   fFfFfFfvfvfvFPF32NFt3-6 t&- |p- ~>T3 tNF ET3 봐F FPfj F}$>T3 u9  >43 t43  9v43  9"T3*>T3 199F~F92  :?h2 ?~  ^*䊇N  f9fPFHj PfXfYfffȋFڙډN^:9FwFV;r
w;v:  f9fPFHj PfXfYffFfFfvF@+؋FVt   N^299F}tfFf(3~ ~F~ uFH::92tJFV43?fFf(3f(3f9FKfvF@+؋FVBnf9fF>9 t
99F/>T3 t:92T3 2  E
3 UVVv^$&=  t)ArZw <Ar<Zw FC:t^^ ^3^   VfF    & *N-0 FF^v&8 t&80r&89v3^ F^   WVf+fFF0& *-0 N^ӉFVF^v&8 t&80r&89v3^_ FV^_   VF  F'F=F~F
u~ tF0^v& FFNV
 FF~ u^v&  F@^ h28hV32,V3X3EY3 Z3@03\3`3a3b3  r3  Ð  RPVl3Fn3 Ip3r3  ff9^f&f99p399F9p399  fv9F2r3ffd3^f&fh3p3 Z3b3  0303\3^3  X3
 b3V3^f&? tf&?u	W3 &?r"&?wh83&&W  ^ f~ t
^f&? uhfvfj FVFFV
22##^&&w#2#62;u5;u122##^&&w#2#62;u;uf&    ^f&? ufvSh83%FNW3 Z3F99F$fFfF^f&? "f&?9- FfF- F^3  F fZ3b3  X3
 o
b3hV3fvh83V 	FF- FFFOF ^3F Z3b3  X3
 
b3hV3fvh83 V	FFFFF+F;FwF^3F+F Z3b3  X3
 b3hV3fvh83V+V hV3fvh83 V'	F^   Pf+fFFFFFf>6 tKa;8rBw;6v:>9 t'F
?+ڃ6 689  
f6    hu~t	F~dr3 >uff9ú> uh뼐>uF  
 ;Fu$<uf9f9t
f>  u>uM% Ht H`f9f9Sf+f69Ff>  8N
?+ڃ$>f~ t*ffF^&G&t&9&9WF%  F~tu9Fu9Ftf~ ~ FffF~  ff9ff9999999~ u-F9  t =th1- 9]
;F'f~ t7F^&? t(&9t#F9Fff9FWf~ tf^f&f~ t	^&- F~ u~  - F~ uF9FnfvhnFF;FfFFfPhF
FFF9FO9F9  t<=t7fv9F[	;F? f~ tF9FvFfvhFf~ t^f&? ufFf&f~ t^&? uF&F   RPF  6^&&Wk^9u9ukFPfvF= F~s
k^ uhh? kFPfvFkFPfvFk^Ƈ Uh92 99 h9h
9*h9fF
 fP9*S3&R39999 99 ff9^f&Gf9h9fj G
P ` 
  F  :^&&Wk^9u"9ufvkFP9*3 F~sk^ uh92 99h9h
9*ff9^f&f9S3&R39999 99 F  F	 h9fj fj  FFt$fFF= uΰE 2Fz  h
=tĀ>
u>
 uf
^f&9ufvh
9*fvfv9* F>T3  h2E @0303@   f9fff  f9f 0303 
 hfj h:3Mh:99uh.:  th:h.:!tEb m  6893Ð  FPj9&_t Ð3  FPj9&_t Ð  fF    FPj9&_u6~Ku+~Tu%~ uEa : Ð~Bu~Pu
 3Ð~tްEVԐ  FPj9&_t ÐȈ  fǆz   ǆ~  xPj9&_t ÐȈ  fǆz   ǆ~ FPfv FPfv xPj9&_t    SQ @@@@;؋sY[FPj9&_t 2  FPj9&_u0Fآ9F֣R3Fԣ9Fң9fvFP9*3     fv  `  RPFFV؋F6F FFF~ uF  F FFFfFfFċFFFF^&F&uFfF    F FFFFFPj9&_t    RPFVFPj9&_ufvFP %
3          .&NXf* PWQRU>   @  h> j>9&] us>@ ul>L |i>L |b>L w[>* L &D F +ȋѽ  ( B +V6H ^;s#  u>@ u
3ԡ( ]ZY_3 ~W>   @  h> j>9&]_f`.&N>9tJ.   0  h. j9&_ u0  t9а r   fa.>*N t&.(N! 9r & ӄt"Qf.>(N u8Pwh3Ɏظ O&.(N&G.*N[i Y3YÜSQ3ێËȋf.>(N tFwhf Of&9tY[9f.(Nf&I f.(N    3PQRv ! ˃ӈ&   .,N"X tZYXPQRv ! ˃.",N  
X tZYXUV3 Ӌ^]UV
 3P Yv  t2؃ Ӌ^]UVW  _^]Q  2sYÀ>[
 u[
Z
X
   Ð3ÐUPFX
uZ
5T
V
Z
 ÐX
Ð  t À>Z
 uFV+T
V
FVfT
f9FsfFf+T
f  fFfFfT
X
+9Vwr9FwF)X
fFfT
3ÐZ
 댐  RP>
 tZFh FFhlF* %F^9N u^P mhFNuhUÐ  PV>
 t7$
F 8Ft)F ~ t$ $* ^ÐU+ҋFF    PRt$TEVh ?	-t-,t  PWVf~  ~  FN ^~&&Q#2#222##;u;u3Fsf9 u^&&Q99^~&&Q;9u;9uo^_   V^f&f#2fF^f&f#2f;Ftif~ u99^ 3FsL2499u99t4^&&W99u99uFs99^ 24^ UfSfQfR?f3^f^ff;sf;wf;rf;vf;s@fZfYf[] SQrY[ PS [XUFFt%&?	u
h*&F^&? u UPF  ^F&*: .^F&*' .^F&* .q^*&    P
 +tF
 +0>U^&p^&Gf^&G\^&GR 
^&GC^&G9 ^&G*^&G  ^&G^&G	 ^&G
^&G^&G^&G
^&G^&G u32SQRu	s22ZY[SQRu	s22ZY[SQPRs2ZXPRZXY[  PF 
^F& FFNuF   2*&GÉF&? u2*&G F^&? uF^&? uFF+2u @tHH  \
  ^
\
t\
f&Gf`
&Gf
&Gd
-\
  ^
\
tk\
f&Gf`
&Gf
d
 @h
  d
td
d
37d
+2  2f
9h
u f>`
 uh4 áh
h
uf`
fj
+j
l
f6j
2+2 d
)3뫐URtt Ã>  u3u2&8Fu  V+ɉNFu3^^f&
 t&ws&G
&W&O
NF3^&GFF^&9wvfvhV u^&9GtS&G
uċFV^Ð  YVthn
V	 RP n
Ð t3Ð2&rhn
Ì UfVfWfSfQfRˋffV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F320fZfYf[f_f^] fSfQfVfWOfCORPfEDOMf    f    r'fCORPufEDOMuf=23AIt
f=46AIu   ff_f^fYf[h^_  F  f~ tF^F&? uF   fFV
fFFtf~ t^F&^F&
uFV   PfFV
fFFt*f~ t#~ ~Nt^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_   PWVF  ~vNtFxF F^_   PWVF  ~vNF&%G<ar<zw, arzw :wr F  FF^_ US^FGFGWwGg
oF GFGWFGOG2Cuԉ[3] [[2ҹ G;tWwGg
oogwww_ϒ  PFFV^*&'*&Oû@ &l &n f%  fPf  f#f#f#f#f#f#f#fXS@ & & [ÌUWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] UP$0F<9vFFÐSW ۋSR3.:uJGuZRƀt%@u20 tt
 t2r< u	ZXCu33_[ö΀Z^_SM_h^v_DMI_΀0}^a$PnP΀@^M_SYSID_  P3 f~ tf~ u'  f~ tܸ NtF&? tF^&^&+t   :  rX%  tK:  t
%  !&  $  s9r%  c6  r%  Z5  r5  rH6  9  L:   撰68BAR   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $ k  r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  L  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ X  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 2  X  f=$ J  f$ f$ f    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 7  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t:  $ =$ u	=$  w$ $       f$ $    7     f=$    f$ $ f     f=$    f$ $ wf$ u  9  bf=$ uXf$ $ $ Cf=$ u9f$ $  -  $ f$         f$ f=$ 	r	f$   N    s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz.ZXfPfRfx < fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytEsZ[Xfz.fyu&sZ[XSR=$ tO$ @
 fyf@t	s/fxfz,fyB@u	sfz.Z[                                   P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPUNNNO$ONNO$ O'NNO$O#NONX     lFpoypvp @  쨀tYRfZ @  쨀t	c7     fmRfZ     55 uf
-  
f
-        Q$  sYa  ޿`     t  r@Y8Y1  |  fCfz     3   r    F   r   rR   fPfSfRf*fff,fff*ff3f uUN0NONfOufZf[fXúvpf  ftRffZf=tPSQ   P  XsHuY[Xfu ff;uPSQRWf  	ufz  3f} f ff ff frf%fGff;wf} _ZY[X        =      5  =  (  QS$    P $ O r$$
t   $ uf f  [$  @$ <   br$
tf f  $  Sf  P[rKSUU*UUUUU*U[P$ p  r
<uf f  SQR      <`u
     wr   $ tZY[$  fPSUU*UUU[fX$    pr
8uf f            PSQRf8fff`f  N$ffN$
fffظ  Nf$fN$
ff        =$  u ZY[XPRSf8fff f  N$ffN$
fff  Nf$fN$
ff[ZXfP >>?<u>>?<t>>?tĀ fXð>>?      2ff fff戰䈽!@   戰O     戰   戰䈻  @      @      u׾C%   C%   u戰f @KC8BBaaff fKua$aff fKuf f u           Ԃ  Ӌ؂  Ԃ      PԂ  Ԃ  VQN   `  Ԃ  aQ  J   W  ܂  Ԃ  Y^ð   Ԃ  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP	 %"XP 
   `"	XË                                                    `   $ff$
$0ظ   $ff$
Њ   $ff$
$3ظ   $ff$
ЊvaÐ            f  f  f  f f f f TDDf f  D/f f  Ef f  Ef     fHt쨎t<w.$f ffH$tt
                                         F          <     D                 D                 D                 D          x0     D     ?     0     D                D                 D                 D                D                F          P     D  `              F      X     F          \     D                D                D  1              D                E  <             D                D               E  @             E                D           @     F             D                D          T     F               D               E                E                E                 F             D          @     D         F   9    E8        E0      `  .   U       .   "       /           .   #       /           .   $       /          .          /   	       .   `       /           .   a       /   >       .   0       /          .          >          ?                  E       <qfUMf%f  $f$
tPppqtAfNUff   $f $
и f  $f$
аf  X$fX$
и f  \$f\$
аfUff.~ f"   f%" 3f  f  gf. ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 pV	 f
   `"f  f3f30	f  f%
  u% t
 غf  fVfV|ff  fغf  f﹖ WfW@ff  f  gff   `ffffgf   p$fp$
Ћfgff   xffffgf   $f$
Ћfgf   $f$
Њfgf   $f$
Њf   $f$
Њfgf   ƺ$f$
Ћfgf   ĺ$f$
Ћfgf   $f$
Ћfgf   $f$
Њff|  fff
   fgNf   ~$f~$
Њgf   |$f|$
Њf   }$f}$
ЊgNf   $f$
Њf|  fff%ff   $f$
$@f_Yf   fzYff   =u;f3ffff%  0ff?  0fF  0ff  0=u f%  2f%0f  2f%0fY]ff  @$f@$
= u$<]2f7Zff  @$f@$
и f  D$fD$
аf  $f$
аf  $f$
и <fZf% = ufZf fZnf % ugf [TfU../0./.f([,f d< ufC[fd< t<t
u掰fk[f䎊f}[ff[f掺<uf[f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  fffl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0f    UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
~] t
^+;wUN&NNO'NN ONf  X$fX$
и f  \$f\$
а08$     3ذf f  fff   t! tf  tf f3f  f<vn2ɵ|^rVtT<tq^t`^t	ـݵ^u<t^g<Hu	ـ݀rfffffffs sf;uff
怼$_f   u3 F_u#;sݰ怼n_};tMfa   ufa   ufa  f   f_g.:vfG_q< tg.:vPfa   ufa   ufa  f   f	_6< tg.:vfG
` g.:v fGff   gf.f
f;w
fffb   ufa   ufa  `` g.:v0f   tff   g.:Gvfg.:GvdfG` g.:vfg.:GvBfG`kg.:vfg.:Gv!`L$< t<w=C  B  Ba  a  Kuas6 .va<tH$tt
䠢
t@fغ  ff% f؀f   ttf   ff% f;r       uu uuuu      `p`p2PP<xxF&<<-ZZ400$HH*~2nf|  fff
   fغf|  fff ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 b	 f
   `"f  f3f30	f  f%
  u% t
 غf  fbf)  fݺf  ff  fff$ ff$ fffݼRcfs_cy2sG怿scuŁ$<r
ffŰ怼cj怼cr~	f  ffs2fs+f`  fnf  f~fn2ff32  tkfsdf  f	f`  fff*	f  ffƊf+Ëff`  fffﰥ怊f   @tŀr&`f   $f$
2f3f怼d}f   @us	f   @ffsJfsC~f  ff`  fffÊffغf`  fff^efj(  def  fغf  ff  ef   tec怼e>f|  fff%fغf|  fff("f|  fff
    fغf|  ffff  f%غf  ff  fغf  ff  fغf  ff  fغf  ff  ff """ff  f""f  f"f  fJ	f  f3f  0 f%"	f3f`  ffff3f3gff  ff  ff    ff  f  f  f f  fغf  ff  f
 غf  ff  fغf  f	 f
   `"f  f3f30	f|  ffff    f|  fff~.u;t~.\`f   $f$
Њs.\nf   $f$
Њŀcwf   $f$
Њ݋侨~.uC;t.\pf   $f$
$
Êغf   $f$
Њ
i"%t8t9fص,i %t8t% صLif~f  f<vnf  fغf  f￤if   if;!  ifG!  ifq!  if!  if"  if"  if^$  if%  if>%  f  fغf  ff   $jUf  .f  f怿Jjf_   ff   f|  fffff|  ffff|  ffffff|  fffgff|  fffff f|  fffff   rff   gffgfff|  fffff@f|  fffgff|  fffff0f|  ffffff%   fgf.l  f   ffsff   gfff|  fffff f|  fffff   rff   gffgfff|  fffff`f|  fffgfgfgfgfgfgfgfgff|  fffff0f|  ffffff%   fgf.l  gfff|  fffffpf|  fffgf XV X     ff|  ffnf%fغf|  fffff3nnfp  fff%   tf   fnn tf   fnf`  f<  f3ff f@  ffLs  fȎgff   u	f   f~ffftf`  ff%   ffغf`  ff%   ff;uf`  fffff8 f%   ffff f@  ffLs  fȎgff   u	f   f~ffftf`  fff%  f*2ffغf`  ff%   ff;lf  f
 غf  ff  ff  fȺf  f	f  f3f  0 f%"	f`  f<  f3ff fLs  ff    tfL{  f   f    fHf3Ҽof   fHf3Ҽof   fHf3Ҽof    uf   fHozf   u
f   kf~fffSf`  ff%   ffغf`  ff%   ff;f`  fffff8f%   ffff fLs  ff    tfL{  f   f    fHf3Ҽp f   fHf3Ҽp f   fHf3Ҽpx f    uf   fHq] f   u
f   kf~fffSf`  fff%  f*2ffغf`  ff%   ff;	f|  fff5   fغf|  ffff   t]f    f2   qr ws < ur ws 3r ws 㹸f  q|f  f u	 f
   `"f  f3f   0	~f|  fffr ws 3ff?   fL{  sf3f    f fL|  s)gf&?  ffff uf   xfsfL}  s>f uf   fgf&;ukfffgf&? uWfffmHf~  s!f@   gfgf&;u+fffugf&;ufff(fH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @                                                          @                                                          @                                                          @                                                  @                                                          @                                                          @                                                          @                                                                                                                                           WW                                                UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU   
 
 
    
 
 
                                   ' ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ~戰䈽ֽհf'-f1=Ұf=fGZ԰fSf]Ͱfifs=2ff ffԽ<հff fˇf ׇհfqf԰f[fְfHf f"f @ f.f.~ f"  ؎ f%" 3؎ P_ -pqt]  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I                                                  s6 .d<tH$tt
䠢f  ffff  @ f  ffff  ff   ff  fffff  ffff  ffff   g(
g(33s
uuf,  g
g3f  f   ug.
f@   u f   uʀ f   ug.
Qfŀ   u f   u f   u
g.
Qg.
Qf.  g g8f3s0s
؋Bts
t	ffff  g. f3fȴ2 uf  f  g. 
f0  g(
g(#f1  g(
g(#f2  g(
g(3f3  g(
g(f4  g(
g(f5  g(
g(fX  g(
g(f\  f%
 'Ⱥf\  ff3ff%   ffff%   ffff%   ff tf    uf   3	f   ff   f
f3.߉f3.fff3f   t.ǉffʺfx  fff% fȺfx  ffff3f   u	f   f    u	f 0@f 0@~ wfwff|  fff%?fȺf|  ffff3ɱ u
 u2f@   tfŀ   tf   tf   t2f  g.f3ɱ u
 u2ff%   f
f  g.
f   g.
f  f% غf  f uK uK.f  f$
Ⱥf  f
Ձ 
f   tf3 u t=f
   f3.ffȺf  fff%fȺf  fff               10/29/xxBRA  U<ps                 d$ $PnP       o              
Copyright (C) 1997-2000  Intel Corporation
 Intel CorporationIntel Base-Code, PXE-2.1 (build 082j) $    I $BC$+   @:^   
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 thP~SwQpRibWZT1
-AX- -BX- -CX- -DX- -DS- -ES-:-DI- -SS-:-SP-
 ÜPh)tX
Waiting...               
  t^@:^ 
h h@ UfPfSfQfRfVv&  &\f?UNDIt?h_& o
PXE-EC4: UNDI ROM ID structure was not found. Gs<hk& '
PXE-EC5: UNDI ROM ID structure is invalid. Pj Sj < uf. fGf;sff. ff. ffGffGff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZNffW.; s. @ 6& ԋfPfSfWfUj j fj fj RfRVQ@ & v &D6E&D6E&D6E&D6E&D
6E
fFffЉVf. ffЉVf. ff6UfGff6UWhTw
˃f6UfVf6UfV
Z cv & tl tc" tZK tQ tHh]Rjh*
PXE-E09: Unexpected UNDI loader error.  Status ==  P
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>  u=h$v & 
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sLh\Pv &  r
PXE-E20: BIOS extended memory copy error.  AH ==  . f.f^f. *rv&D &L. &;D&s&D&fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(Dv
F&DF&D&DPj Vj &(D	v &D6E&D6E&D6E&D6E&D
6E
Wj v&\Z
  Wjuv&\Z Wjvv&\Z  t  uj@ H FF  RWjv&\Z  t{Xt&t
 u tfS^
G HF+F)F[fSVWF  6	fff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 v&< f^fZfYf[fX  t ]˜= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]r.>  u	  . 	Pfj j .(   fZfYf[h
1P<Xt/
Press <Esc> to abort ROM initialization... fPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j V< uf>  tf . fSfQfR. . .2 <t8hq
PXE-E06: Option ROM requires DDIM support. f    ff    .  f    ff  fRjfjf. ffPj hfQ˃ffu0h;fZf    {
Invalid PMM function number. f u)hqfZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.. Pj h j .( . . tf.>   r
.                  blksize tsize                                         U ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j    |      
CLIENT MAC ADDR:  
  PXENV+     GUID:   
DHCP. PXEClient:Arch:00000:UNDI:000000  PXEClient CLIENT IP:    MASK:   
DHCP IP:    PROXY IP:     DHCP IP:  
GATEWAY IP: MD  BD  UD  
Auto-select:
      
BOOT SERVER IP:    (  )   
Auto-select:
                                                                                                -->  MTFTP 
PXE-T :   TFTP Aborted  ProxyDHCP service did not reply to request on port 4011.  Client could not locate a secure server Missing MTFTP server IP address BIS bad entry structure checksum  BIS get signature information failed  BIS free memory failed  BIS get boot object authorization check flag failed BIS shutdown failed BIS initialization failed BIS image/credential validation failed  BIS integrity check failed  Network boot canceled by keystroke  ARP timeout TFTP open timeout TFTP Error - File Not found TFTP Error - Access Violation Error received from TFTP server TFTP unknown opcode TFTP read timeout TFTP cannot open connection TFTP cannot read from connection  No DHCP or proxyDHCP offers were received.  proxyDHCP offers were received.  No DHCP offers were received.  No boot filename received Invalid UNDI API function number  MTFTP cannot initialize NIC for multicast Error while initializing the NIC  Error while initializing the PHY  Error while reading the configuration Data  Error while reading the initialization data Invalid MAC address Invalid EEPROM checksum Error while setting interrupt TFTP too many packages  TFTP packet size is invalid Media test failure, check cable NBP is too big to fit in free base memory Bad or missing discovery server list  Bad or missing multicast discovery address  Bad or missing PXE menu and/or prompt information Could not locate boot server  Invalid state returned from UNDI  PXE-  Invalid message code.
   /-\|            
SM/DMI BIOS functions needed.
 _UUID_  
									       
      
 f~ u ːf~ u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- r- v뾐:: 1LP3 뫋F fv?FF^&)~!~ofv'ҐfvȐfv뾐fv-Fu
hx9 i[F 롐fvFth I[fv[fvmofvАfvƐfvA뼐fv벐fv=fv?	3=1 tw5-  = }.f             $=q )w-2 tHt-= 7-s HHH!3  F  
9  >9 t  JLfFf99f2hP99@t{<IutyIu^h
JuShRF   }R^
RF9*9Fr䡸93MuIun>huYu
"Ft1J9NMqIH~ t~tEVjOhRF FP)Fu9Fu9R 9뮐U>9 t>P3 u>: t  II9Lt9 9 9^&9   V3Y-  +ҊԊ*҉FVFP+$FVu3^Ã>3 t3+ҊԊ*ң(3*3(h2fj vPfj  E/t	f(3    7f(3*3f9FsEy WN뜐T3 fvfvh2fj h96:6:6636H3 |3O8tְE뽐>2u}(3*3% (3ҀĀ FVf(3fFGT3 fFf+(3fPfvh2fj fj fj fj FV37ufvfvf6(3 |K
u	E" 9Uhx9bWFFV^f& |  PVr$=NVu^F^f&G(fFXfv^^  ^&G- r- v  &iGNF^& u*&G^& u=& u6F&GF^&G#&r&G^f&OfQfv&GU3   >9 u  >: t  >P3 t  G|F9f&G    f9  fP2 ~Uf9H fP2 mUf9@ fP2 \Uf9P fP2 KU9S*&GP9&(G9&G0FF  FF9&9G6 fNfNfQhhHT7Uuh:T^*&O;~S*\P
u3^&G^&G^&G^&G^&G^&G^&G$&G
  &G^S*&G
P^&(G	fF^f&G9(It  3!V;.33   ^&  t&  }?  >9 u  >: t  >P3 t  Eu֋FV RPF RPF
 RPF RP^3& 2),u: >: u  3*E3:   >9 u  >: u  >P3 t  fF fP^f&OfQ|1F^&G  F-tHHu9  5  F^&G3   ^& >9 u  >: t  >P3 t  Cu^f& GP P P P& & & & & & 33^&^&Fuf(3f& 3 f&Ǉ     F   >9 u  >: t  >P3 t  ?Cu֋FV RPF RPF
 RPfj E S3ҳn*F2CF^&~ uf(3^f& ^f&Ǉ     F=3 =2 }
c F -6 tHHtKU>9 u  >: t  >P3 t  Bu47f^f&GP33 >9 u  >: t  >P3 u  B3P3   >9 u  >: t  >P3 u  FN~ tIFV RPF RPF RPF
 RP^f&OfQ&G9Ft^&G3 F^&Gv  F>9 u  >: t  >P3 u  ^&
 uQ&G
^f&OfQGPGP&G&W26uF3 F  fF   fF   f+fFfFfFfFfF$mIfjFPvGRPfj*F $KI~ t
E! FËFFtE# fFf Ð  fF   ffF$ IfjFP	GRPfj*F $H~ tE! 2FÐFFtE$ 萸 Ð  fF   ffF$HfjFPFRPfj*F $xH~ tE! EÐFFtE% f~ t 3  RPfF   ffFfFfF$ HfjFP)FRPfj*F $G~ tE! REÐFFtE& 萸 Ð  fF   ffF$GfjFPERPfj
*F $G~ tE! DÐFFtE' fvFP|E L  F+;Vr
w;FvFFF3fvh3HE^KFV "  RPfF    ffFfFfFfFfFfFfFfFfFfFﾭfF    $FfjFPDRPfj*F޸ $F~ tE! D f~ uf~ t  3 WV2   It2^_2&sE( C^_ÐS*&G7H
u⸀22f   ftrHuVHu0HuHu 2^_  RPKHu0fvfvfvFVFHtF  ~u  3   SRPVf~ tDt@u2^ F+v
rD7D0^N&FN+FFNu^ 
  SRPWVF`4^ht32 Kt3R3u39v3h3h
 Kf2fx3 L|3^f&cSc>
  t^&G^_ FHtHHt- tI- tJ-
 tE~3  ^& 5F^& FFHt1HHq- t- c-
 \|3  ^f&f3뷐^& F~u!^& 2F^& F^f&^f& ~ ^& 7FvF^& F^& F^& F^& F^& F^& F^& F^& 
F^& F^& F^& F^& F^& +F^& 6F^& <F^& CF^& F^& F^& F^& F^& F^& F^& F^& F*F^^&^& 9F^& F^& F-  -  -
 t^& ^& Fu{>  t4  h"(CcG			th&Cf6	Ch. Cf>	 t.^& aF^& F^&  FfFfPf6	 AI~u(^& 6F^& F^f&^f& a^& ]F^& FGFJ^& ^& ^F^& F^& F9&_&G	^*& FF9&_&G^& FF^& <F^&  FfFfPh6  HfF fPǺ
  /fF fPF
  fF fPF
   ~ ^& +F^F& ^& GF>  t'^& F^F& ^F& F^&-^& F^F& f% !I^& ^&>2uM^& F^3& ^& FF  !^33H^& &PF39F|^& F^&^& ^_ .@f2fj fj  3Qf    f2f88ht3fj h: C$,h:ht3GUPV3^*& BFfFV^f&G<^&Ǉ  ofFV^f&G@fFV^f&GD̐fFV^f&GH븐fFV^f&GL뤐fFV^f&GP^&Ǉ  ^&Ǉ   fFV^f&GT֐fFV^f&GXfFV^f&G\뮐fFV^f&G`뚐fFV^f&Gh^&Ǉ  ^&Ǉ  ^&_h&u 3^& cfFV^f&Gd= )= wA.JNl=
 k- &H5HD- t-; ^- t^*&@ 9vO^   PV3^*& =4 CtHtzHHtN-
  -  FfF^f&GfF^f&G^&_f&G^f&GpdÌ^&G&W^&_f&G^f&Gx;Ì^&&W^&f&G^f&GtÌ^&G&WfF^f&G$^&_$&	r"^f&G$ fPhX	 DuF F  F*^&  Ì^&G&W
^Sf&G fP&_*&G~Ì^&G&WjfF^f&G,h^f&G, fP&_,*&G@C^&_,&_*^&G|&_~-5 {H- 	- t- t:^*&@ 9v^f& tf&$ u&  u
& & ^ U^&?t3 f2f&9Guf& cScuf&  t؍GPh
9*Cuø    WV3F Dvvv^&7Vj
 & RPfXfYffff88 9 7:fj FPfj fj j 3Pe+thBtix  RPhVBix  RPix RPT
ix &n tF ^&ix&p tF F Fix=zP^&7~ u~ t	^_ 3^_ UFVl RPFp RP 332ht3fj h: C$' Ȏ  ǆr Dfj
 & RPfXfYffff77 8 8fj rPfj fj j 3P**thtȍtPhBf~ t^&uf~  tfF^f&9GlufFf&9Gpuh&$h@fFffFf2  3 UhfFp fP
 3
21ht3fj fFp fP$x& Ȏ  fj
 & RPfXfYffff66 7 7ǆr  hrPfj fj j 3P)t̋r- Dt-guhttPh)f~ tf~ ufF^f&9Gpuh)h?  3 Ȍ  PV3F}Pirx  RPirx  RPtʍtPh)
>2u~ u ^ÍtPirx  RPy
FPFP 3`0$0ht3fj FP C$%3^  RPVF  ivx &t u-FF9F"ivx &n u3FFF>2u
ivx&v uF ivx &p tivx&r ivx &p uF  FF9F}.ivx&n tivx&t tۃ>2u
ivx&v u9F=F Pivx &p "ivxf&h F  FF9F}
ivx&n t9F-ivx &p F  FF9F}ivx&n tivx&r u9F ivx &r ivx&j&hyivx&t {ivx &p XF  FF9F}5ivx&n tivx&r tivxf&h tivx&t uF9FH= .> zHivx &l t=h&$iFxP<ivx f&Xfivxf&`f2	 9f    f2fiFxPiFx  RP_ivx f&\&^fFHHHHHtHtiiFx P 3ivx f& t&ivxf& fPivx&Ę&G*3Fh92 ;F  h92 ;FF9F ivx &n tivx&r uiFx P Y3ivx &&t&ivxf& fPivx&Ę&G*3iFx   RP 3ivx f& t&ivxf& fPivx&Ę&G*2F F9F~  h)h&$: iFx P 2ivx &&t&ivxf& fPivx&Ę&G*K2iFx   RP 32ivx &&divxf& fPivx&Ę&G*1;~ t3h)iFx  RP9ivx &\&^ ^Ð3^Ð  RPFFF  .;3f~tf~ u
F C D~ r~ rF  hFP^^ V~ Cu~3*=*ht3fj FPF$2F   SRPWVFF  fj
 & RPfXfYffff*/3=0 0F  fj FPfj fj j 3P!kF- Dt-g\hOiFx  RPh8iFx  RPiFx RPivx &ĘT&uF Fivx &ĘT&9G F9ivx &ĘT&O#N; ~ taivx &R&P ivx&ĘP&G&WI9FVF  F39FsF^93u93u39Ft[~ tHF  FF9Fs-^vi~x ؎Ff& &P f&;\uȋF9Ft
FiFx=zs	-`F^_ V6hb0h1hn0h21f> t&ff9thx0h0h0hh0h0f>9 t@3f9 t1ƹ +uhc0 R09P0 @0Frh?0^Ð
  WVF9*f|
f2f2f: Dh:2[6f    ffFdF 5 9F~F !uxF ukF u^9F~
F uLF u?  F~}/^ۋ  FPFPtЋF g~ ~ u
FQ ^_ËF9FuFR ^_ÐFS 3F9v~!ix &n uix&p tFU 9vu1~ t+3F9v~!ix &n tix&p uFU 9vt1ix f&Xfixf&`f2ixf&\fFF^_F3^_ÐUfv2 4^f& u 3^& fvfF fPa^f& t&_&GtfvfF, fP@ 8^f& t!&_&GtfvfFl fP (^f&| u^&l tÌl ^&G|&W~^f&G^f&Gl^f&p u^f&G^f&Gp^f&x u^f&G^f&Gx^f& u 3&  Ȍ  >2u4f~ t-tPh-~ uEz k*3 fF^f&tPh)f&)f2fuFFtfFf2f~ t^&G&WE{ 륐399f~ t
^&Gu43:f~ t^&G\43:FFu	63  ^&u&G	*&G+4*63FFuH3  ^&u&G	*&G3*H3f~ u39,3^&G3,3^&G39f~ t^&u
&G333  FV   RP>2u 3F     > w$fvFV;fvVF^Ftʃ~  >2tOh)f6 1f  fP ) f& tf& fP&ğ&G*z)F h-f6 1 f&\fF     > w&fvF3fj F33
tF T3   PVf+fFFfF^ğ
&Fu^ >2uNF  F	9FsA^ğ
&^ğ	&9uً^ğ	*&GF^f	 fF~ u$^&GR&GPt&_P&GtEw T'qF ^f&P t&_P&GtF  ~ tz^&_Tf&GfFm/h)FP
*^&_P&Gt(fvfv^ğ
F&Ft(^ fvfj ^ğ
3&F F ^f&P t&_P&GtF  ~ thfF.h4)^&_P&Gt(fvfv^ğ
F&/Ft&^ fvfj ^ğ
3&	Fu^F  FF9FsIb.h(FFVRP(^vf&0fj ^ğ
3&Ft^ 3^ USRPf`~^NvVFn
fa
 Ȋ WVF  ^&  hPh&$Ph)h^V6  u^V6  u	3^_ ~ ud t^f&P t&_P&GtfX u	   
  ^f&P  &_P&Guy^f&T u
v ^_ &_Tf&t^&_Tf& t^&_Tf&   v^&_T& wr^&_P&Gt@^f&X t&&_X&s$^&_P&Gt^f&X uw ^_  
 ^f&X thF  =^&GX&WZF 				^&_Xv&@* F^&_X*&G;Fw^&_X&G;F~^f&\ tf&` u
t ^_ &_`& t^&_\&r3R
FN^&G\&W^F R


R
ğ
& tR
ğ
*&G FR
^&_\*&G;Fw^&_`&8g h%3
*&G;v
&@%FFrh%3Fs
f9 ufvF@?Ht'&+h%h&)%s[f9 tNEx ^_ f9 t3+ǹ +uh;% *%9Po% %Frh%h
%*F  ~Is)^&_`v& $F^&_`*&GH;Fw^&_`&uh$ ǆ  ^&_`*&Gfǆl @ Ɔh$2	&2&%hn$%tO%= Btw3-t-,u^& Iǆ  t#)F  F  - [t- 
t- 
tאĞ&8t&
uu@)h#ǆ  
*&G;v&@#Frh# +G%
h #ǆ  ^ğ
*&G;v"^ğ
& @#FrȋF9vFh*#FR
9FrF
2$*+R
FvЎf   f^ğ
*&GhXfhp  j VV33Q^f
 fPfh  p VV3 )vPF+- Pfh  p VV3 F#=.t = t -t-t^& )~ tNh fh  j V33f
 fPfh   V3 vPF+- Pfh   V3UF+R
=KF{~ =F  kF+R
='R
HFS-	t-
- = K-w- 9t-
t- - Mt- t- t
  SRPV>63 u63$ >T3 u9 >T3آ9>
 tFu&>T3^P ^f&f2f~ u	24
^&&W99t3   F  ^v& ވv3^Fv&8 u^fǇv3octeF^Ǉv3t FF9~ EuEf~ t>^&? ~4Fv3Ph $&h %@FFv3P^&FF9~ t?f(3    Fv3Ph  %h  %@F^Ƈv30F^Ƈv3 FF9>T3 u
'@'F9N3  J3  63L3>T3 u
z'@v'>T3 t	t(>9 t!ht3h9h2F9t8 >
 tFu.bL3 z>T3  fj fj fj fj j 3P ff92uvff9u:9u1>T3  F&&;w&&; f9f9u&:9tfj fj fj fj j 3Pu|J>T3 t>9 u963L3J363L3J3J3= uE2 2 >T3 >J3~ EF EN3 &- toHHt	HZ>
 t(~ u"hdFhlhh>u; \>u< O>u	= ^ 6 ^ ~ t4ft3   hx3hp
 !$ht3h9h2N3 	> ^ >T3 uE%+Ht
N3  >T3 tff9u9u9ԡ%- F99F~L~~E? k? ^ >T3 t>2 uF9F92  :?h2 >#>T3 u3^ ~ uf~ _^&? SF   f~ tY^&? ~OFPh *u<h )"@FFPZ=~ Et9느9Ff=E  v~ t`FPh  uMh  !@FFPY(3*3ft3   hx3hp
 y"ht3h9h2N3 NFP!@F- 9F}FPi!@F- 9Fft3   ht3h9h2N3 -^    v9t3 v39 >|Y$#^&- v9tf~ tfvl#PQv9!>9 tht3h9h2N39w  v9 J3  >43 t	43L3L3$ L3| >T3 tQfj fj fj fj j 3P%
tfff92u[ff9u9 f9f9u::9/hhfj fj j 3P	t92u9 3t\i>43 u>9 u L3J3J3= uE5 i ht3h9h2N39f뻁> >9 t!+H>T3 t-ff9u"9u>9 u>9N3      Ð
  P3FFFF 1^*䊇N t~ uFFFFF:9FvȋF+F+2@Ffj
 fRPfXfYffffF~ tF9FwF  ^)FXF9Fv	F+FFfj
F RPfXfYffff;Fs"fj
F RPfXfYffffF~#vF#F  SRP9 T3 f+f(3Pj
 fRPfXfYffff63fj
 fRPfXfYffffH3f~ tR^f&? tHf&f9M}b  T32  F
:9 F :?h2 8T3 FF E43  f9f"   fFfFfFfvfvfvFPF32NFt3-6 t&- |p- ~>T3 tNF ET3 봐F FPfj F}$>T3 u9  >43 t43  9v43  9"T3*>T3 199F~F92  :?h2 ?~  ^*䊇N  f9fPFHj PfXfYfffȋFڙډN^:9FwFV;r
w;v:  f9fPFHj PfXfYffFfFfvF@+؋FVt   N^299F}tfFf(3~ ~F~ uFH::92tJFV43?fFf(3f(3f9FKfvF@+؋FVBnf9fF>9 t
99F/>T3 t:92T3 2  E
3 UVVv^$&=  t)ArZw <Ar<Zw FC:t^^ ^3^   VfF    & *N-0 FF^v&8 t&80r&89v3^ F^   WVf+fFF0& *-0 N^ӉFVF^v&8 t&80r&89v3^_ FV^_   VF  F'F=F~F
u~ tF0^v& FFNV
 FF~ u^v&  F@^ h28hV32,V3X3EY3 Z3@03\3`3a3b3  r3  Ð  RPVl3Fn3 Ip3r3  ff9^f&f99p399F9p399  fv9F2r3ffd3^f&fh3p3 Z3b3  0303\3^3  X3
 b3V3^f&? tf&?u	W3 &?r"&?wh83&&W  ^ f~ t
^f&? uhfvfj FVFFV
22##^&&w#2#62;u5;u122##^&&w#2#62;u;uf&    ^f&? ufvSh83%FNW3 Z3F99F$fFfF^f&? "f&?9- FfF- F^3  F fZ3b3  X3
 o
b3hV3fvh83V 	FF- FFFOF ^3F Z3b3  X3
 
b3hV3fvh83 V	FFFFF+F;FwF^3F+F Z3b3  X3
 b3hV3fvh83V+V hV3fvh83 V'	F^   Pf+fFFFFFf>6 tKa;8rBw;6v:>9 t'F
?+ڃ6 689  
f6    hu~t	F~dr3 >uff9ú> uh뼐>uF  
 ;Fu$<uf9f9t
f>  u>uM% Ht H`f9f9Sf+f69Ff>  8N
?+ڃ$>f~ t*ffF^&G&t&9&9WF%  F~tu9Fu9Ftf~ ~ FffF~  ff9ff9999999~ u-F9  t =th1- 9]
;F'f~ t7F^&? t(&9t#F9Fff9FWf~ tf^f&f~ t	^&- F~ u~  - F~ uF9FnfvhnFF;FfFFfPhF
FFF9FO9F9  t<=t7fv9F[	;F? f~ tF9FvFfvhFf~ t^f&? ufFf&f~ t^&? uF&F   RPF  6^&&Wk^9u9ukFPfvF= F~s
k^ uhh? kFPfvFkFPfvFk^Ƈ Uh92 99 h9h
9*h9fF
 fP9*S3&R39999 99 ff9^f&Gf9h9fj G
P ` 
  F  :^&&Wk^9u"9ufvkFP9*3 F~sk^ uh92 99h9h
9*ff9^f&f9S3&R39999 99 F  F	 h9fj fj  FFt$fFF= uΰE 2Fz  h
=tĀ>
u>
 uf
^f&9ufvh
9*fvfv9* F>T3  h2E @0303@   f9fff  f9f 0303 
 hfj h:3Mh:99uh.:  th:h.:!tEb m  6893Ð  FPj9&_t Ð3  FPj9&_t Ð  fF    FPj9&_u6~Ku+~Tu%~ uEa : Ð~Bu~Pu
 3Ð~tްEVԐ  FPj9&_t ÐȈ  fǆz   ǆ~  xPj9&_t ÐȈ  fǆz   ǆ~ FPfv FPfv xPj9&_t    SQ @@@@;؋sY[FPj9&_t 2  FPj9&_u0Fآ9F֣R3Fԣ9Fң9fvFP9*3     fv  `  RPFFV؋F6F FFF~ uF  F FFFfFfFċFFFF^&F&uFfF    F FFFFFPj9&_t    RPFVFPj9&_ufvFP %
3          .&NXf* PWQRU>   @  h> j>9&] us>@ ul>L |i>L |b>L w[>* L &D F +ȋѽ  ( B +V6H ^;s#  u>@ u
3ԡ( ]ZY_3 ~W>   @  h> j>9&]_f`.&N>9tJ.   0  h. j9&_ u0  t9а r   fa.>*N t&.(N! 9r & ӄt"Qf.>(N u8Pwh3Ɏظ O&.(N&G.*N[i Y3YÜSQ3ێËȋf.>(N tFwhf Of&9tY[9f.(Nf&I f.(N    3PQRv ! ˃ӈ&   .,N"X tZYXPQRv ! ˃.",N  
X tZYXUV3 Ӌ^]UV
 3P Yv  t2؃ Ӌ^]UVW  _^]Q  2sYÀ>[
 u[
Z
X
   Ð3ÐUPFX
uZ
5T
V
Z
 ÐX
Ð  t À>Z
 uFV+T
V
FVfT
f9FsfFf+T
f  fFfFfT
X
+9Vwr9FwF)X
fFfT
3ÐZ
 댐  RP>
 tZFh FFhlF* %F^9N u^P mhFNuhUÐ  PV>
 t7$
F 8Ft)F ~ t$ $* ^ÐU+ҋFF    PRt$TEVh ?	-t-,t  PWVf~  ~  FN ^~&&Q#2#222##;u;u3Fsf9 u^&&Q99^~&&Q;9u;9uo^_   V^f&f#2fF^f&f#2f;Ftif~ u99^ 3FsL2499u99t4^&&W99u99uFs99^ 24^ UfSfQfR?f3^f^ff;sf;wf;rf;vf;s@fZfYf[] SQrY[ PS [XUFFt%&?	u
h*&F^&? u UPF  ^F&*: .^F&*' .^F&* .q^*&    P
 +tF
 +0>U^&p^&Gf^&G\^&GR 
^&GC^&G9 ^&G*^&G  ^&G^&G	 ^&G
^&G^&G^&G
^&G^&G u32SQRu	s22ZY[SQRu	s22ZY[SQPRs2ZXPRZXY[  PF 
^F& FFNuF   2*&GÉF&? u2*&G F^&? uF^&? uFF+2u @tHH  \
  ^
\
t\
f&Gf`
&Gf
&Gd
-\
  ^
\
tk\
f&Gf`
&Gf
d
 @h
  d
td
d
37d
+2  2f
9h
u f>`
 uh4 áh
h
uf`
fj
+j
l
f6j
2+2 d
)3뫐URtt Ã>  u3u2&8Fu  V+ɉNFu3^^f&
 t&ws&G
&W&O
NF3^&GFF^&9wvfvhV u^&9GtS&G
uċFV^Ð  YVthn
V	 RP n
Ð t3Ð2&rhn
Ì UfVfWfSfQfRˋffV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F320fZfYf[f_f^] fSfQfVfWOfCORPfEDOMf    f    r'fCORPufEDOMuf=23AIt
f=46AIu   ff_f^fYf[h^_  F  f~ tF^F&? uF   fFV
fFFtf~ t^F&^F&
uFV   PfFV
fFFt*f~ t#~ ~Nt^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_   PWVF  ~vNtFxF F^_   PWVF  ~vNF&%G<ar<zw, arzw :wr F  FF^_ US^FGFGWwGg
oF GFGWFGOG2Cuԉ[3] [[2ҹ G;tWwGg
oogwww_ϒ  PFFV^*&'*&Oû@ &l &n f%  fPf  f#f#f#f#f#f#f#fXS@ & & [ÌUWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] UP$0F<9vFFÐSW ۋSR3.:uJGuZRƀt%@u20 tt
 t2r< u	ZXCu33_[ö΀Z^_SM_h^v_DMI_΀0}^a$PnP΀@^M_SYSID_  P3 f~ tf~ u'  f~ tܸ NtF&? tF^&^&+t   