<!-- Copyright (c) 2004 by Cisco Systems, Inc. -->
// discover.js for c2970 devices.

// CHGESM models.
// OS-CHGESM-24T-E

function OSCHGESM24TE (int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 24;
	dev.x=0;
	dev.y=0;
	dev.image = "images/chgesm24.gif";

	drawLeds(dev);

	// Create the ports
	var port;
	var portWidth = 11;
	var portImages = top.hbportImages();
	var portInvImages = top.hbportImages();
	var xPortGap = 4;
	var xPortStartPos = 550;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	for(i=0; i<24; i++) {
		if(i%2 == 0) {
			yPortCoord = 35;
			port = new top.hbport(portInvImages);
		} else {
			yPortCoord = 48;
			port = new top.hbport(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		
		if(i%2 != 0) {
			xPortCoord -= (portWidth + xPortGap);
		}

		dev.addPort(port);
    }
	
	var rj45Ports = top.rj45portImages();
	xPortStartPos = 325;
	xPortCoord = xPortStartPos;
	portWidth = 19;
	xPortGap = 7;
	yPortCoord = 39;
	for(i=22; i<24; i++) {
		port = new top.rj45port(rj45Ports);
		port.index = i + 2;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + (i + 2);
		xPortCoord -= (portWidth + xPortGap);
		dev.addPort(port);
	}
	
	// Adding the label for displaying the slot info.
	var lbl = new top.label(265, 0, 136, 11);
	lbl.id = "lbl0";
	dev.addLabel(lbl);
	
    dev.modes = new Array("STATUS", "DUPLEX", "SPEED");
	return dev;
}

function drawLeds(dev) {

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/hb_mode.gif");
	modeBtn.x = 576;
	modeBtn.y = 44;
	modeBtn.height = 18;
	modeBtn.width = 18;
	modeBtn.id = "CHGESM_mode";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 604;
	tempLed.y = 27;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	//tempLed = new top.led(ledImages);
	//tempLed.x = 604;
	//tempLed.y = 60;
	//tempLed.id = "rps_led";
	//tempLed.device = dev;
	//dev.sysleds["RPS"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 604;
	tempLed.y = 35;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 604;
	tempLed.y = 43;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 604;
	tempLed.y = 52;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
}


function createDevice(int_status, media_type, deviceType) {
	var device = null;
	if(deviceType == null)
		return device;
	if(deviceType.indexOf("OS-371098HP00-24T-E") != -1 || deviceType.indexOf("371098-001") != -1) { // OS-CHGESM-24T-E
		device = new OSCHGESM24TE(int_status, media_type);
	}

	if(device != null) {
		device.type = deviceType;
		device.family = "CGESM";
	}

	return device;
}
