#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68BAS ROM)  - Linux-Based"
BIOS_VERSION="F.2A"
FILENAME="sp28856.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK
# Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

## bzipped file
##bzcat $FILENAME.raw > $FILENAME
## gzipped file
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file
#tar x --gzip $FILENAME.raw
## bzipped Tar file
#tar x --bzip2 $FILENAME.raw
## plain Tar file
#tar x $FILENAME.raw 
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK

make_bootcd()
{
    echo "Creating .iso image from $FILENAME..."
    mkdir -p iso
    cp $FILENAME iso 
    mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
	eval $ERROR_CHECK
	echo "done."

    # Prompt for a CD
    echo "Please insert a blank CD and press <return>"
    read ans
    echo -n "Writing..."
    cdrecord -v gracetime=2 dev=/dev/hdc -dao driveropts=burnfree -eject \
			-data bios_update.iso
	eval $ERROR_CHECK
    echo "done."
}

make_bootfloppy()
{
    # Prompt for a floppy
    echo "Please insert a floppy disk and press <return>"
    read ans
    echo -n "Writing..."

    # Write boot image to diskette
    dd if=$1 of=/dev/fd0
	eval $ERROR_CHECK
    echo "done."
}
#### Process
while ( test -z "$done" )
do
    ans="floppy";
    echo
    echo -n "Please enter [floppy] to create bootable diskette or [cd] to create bootable CD:";
    read ans
	if [ -z "$ans" ] ; then
		ans="floppy"
	fi
    case $ans in
	    C*|c*)
            make_bootcd $FILENAME
		    done="yes"
	        ;;
	    f*|F*)
            make_bootfloppy $FILENAME
		    done="yes"
	        ;;
	    *)
            echo "please enter 'floppy' or 'cd'"
	        ;;
    esac
done

#### Clean up and exit
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi
exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  M8181  M81 L   Ar o m p a  ?q . e x e     ROMPAQ  EXE  M8181  Q1   HIMEM   EXE  ]M8181  SV' D  8DTV   BIN  JM8181  [81   8BDD   BIN  +R8181  \0   NEEPROMEXE  [z081  [z0	,  68BAS   BIN  s8181  I0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
device=a:\himem.exe 
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                    MZU  @  j
   \X      M        
       M

      n  
  
  
  	  	  o	    `       M
5  ;        i  )      ^  M  D          +                       	 	 	               U   8    M
																		~	z	v	r	n	j	f	b	^	Z	V	R	N	J	F	B	>	:	6	2	.	*	&	"						
																																			~	z	v	r	n	j	f	b	^	Z	V	R	N	J	F	B	>	:	6	2	.	*	&	"						
			 	 	 	 	 	;  ;  S;  M;  1;  #:  :  9  9  9  <  <  <   				v	^	@	"						n	V	8			
 M
G  G  qG  iG  WG   M
MU  T  T  T  T  jX  @Y  ^Y    				z  R  ˇ                                                                              3Ðjhː
  F  F~ F F^J9 uvfv' }fvfv ~hh jGRP{Vtj
fvvP蘄
hh jHRPNVtj
fvvPk
 Ð3f>X  tf6X f>j  tf6j 逃>\  t
6\ UV|Ð  Vh jQh jFh j;h  h ݆h ~F ^v&v& =c   -!  - tHHt-3 t_ J  F^v&v&8 D^v&v& it^v&v&   R  R  N  R  L  >R  uR  |F  H  m-d _HHt- t- t- tf6B j RP`jRP}jRP}jRP}jRP|}jRPl}j	RP\}j
RPL}jRP<}jpRP,}j#WFF9F}-^v&&?-t^F&&?/uF nSJ=sjrRP|jVStjsRP|jVTSfh  j k~X Z X ujtRPt|jkVQuhh Y|jPVQFF*PFPhh> ^fh   Q\ uhhR |jV>P  tS<  St(n ! ~ 9  =  A  E  I jJj1fj}j l j ujtRP{jU		t(^  v j   l ؎f&frjrRPQ{jHU>N  t>P  tV  T  J  >V t>V u& & & >V u=>R  u	>J  >J   >V u3R Ht	HtHt8j uwjJulj?j.>V u?R Ht
HtHtHtIjj 1Ȑj#u+jRPkzjR HtHH>R  tD>L  t=<?h<h<jv
>H t jYRPzjIRPz>H  t7
j SK4  F >4 >N  t>P  tV  T  J  >V t>V u& & & >V u <~ tfj fj 'F  W=HtjH-
 -!- - - 
tEfUm
>  ~  H    7 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G}&Wqfj 8e     F >H  tW5L4 C= M- K- (-M- 0- )fj*>H  tj Q^ÐU	^&,&.Ð  F fj fF j   l ;Fu;Vt^& FFԡ j  l ؊F&Ð<">
j hdh<h<jy>HT  Vfh  P FP|f<K  FDjhdh<h<jy>H t3^ÐFPsBFVhhx FPyRPhvvrhhx fvyRPh` Zrfvh` q ^Ð  FF	<">FDFjhdh<h<jx=*ÐU~uhhz  Ð~ hh h` =U686u3f0    8f66fh  f6X V= s6&G
 t	SSf0   f02f9r~"fh   RP6\ f6X \Lut뉐f66SO~ uhhz Adr j   l ءZ +X  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h	h| j  l RPy
Mfh   f6X vj 6\ ,KR{  WV~辄 f~ thhz FPp~ FPu3^_hh h` MS686tj frf-   fPf66q
f66jFPKq
f66Pt~ uF.~uF6b 8Fuc 8Fud 8Ftf66QkFPhPbf66Q ^_Ð~ hh h` R686f0    	02f0f9r~f66fh  f6X gR= j6&G
 ]fh   f6X f606\ I=t5fh   vj 6\ f6X Ir j   l ءZ +X  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h	h| j  l RPw
x> tjJj1j f6j Lwjhh p j   l RPv
6n h	h| j   l RPv
r j   l ءZ +X  &&Wt j  l f&    v j  l ؎f&   x j  l ؎&  &  FF܌VF T   P   V   f<
S h<h<jPm
>H u_>?@T Rf<N  f@    FޣdFܣFhdh<h<js>H t>=uP   hHNu~ tV   Ft
F$p*V Ð&  VFF܌Vf<D FQCjDhdh<h<jr>H t3^F  FvڊB^& Fڃ~ | ^Ð>F  t	<&<Zhdh<h<j?r>H tjeRPo  fh  ! h	htjRPQF  @n +FHuF F^	&x&*hj*_RFn 9F}j vĈf<t<uhh CQÐ  o= t= u%F  F~}
FOu~|3Ð Ð>T  u#jERPnjFRPn3ø x&hjQhzt{u{Ð  DJ;fh  hPhvt"jGARPmjH1RPmjuRPmfh  eujARPm>H   2F hj
Pj
RPOΐFfrf   ffffN*+;B|;s<F*PjRPOj F*Pux&
hPh` jQRPiOjUARPjT7RPhh IOÐ  jF "hj
PjRPOFfrf   ffffN*+;@|;s:F*PjRPNF*P7ux&
x&
hj
{OjvcRPlju,j?GRPlj@7RPk>H  tlhvh` jRP+NÐ  D;fh ChPhvt"jGRPkjHRP{kjuRPikfh  ujARPIk>H   F hj
uNj]RPuMΐFfrf   ffffN*+;B|;s<F*PjRP5MjF*Paux&
hPh` jRPLjURPjTRPhh LÐ  F >V ut~ thh hh FP fhh FPwIFVu3vPfh  f6X nI= s^&G
 tF  fvBHO>V u~ t	hh hh FPehh FPHFVtvPfh   놋FÐ  F 4,u3tF f6X FP.F~rhh hh HFVtvPfh  f6X J= s^&G
 tF  fveG~ ujKRPcKhh j3RPKKF*  F 6u3s+tt~ thh FPdjhh FPrdj RPFP]dhh FPGFVtvPfh  f6X G= s^&G
 tF  fvF~ tj!iRPJ#.F~  F ohj
QKF  hj =KFj!;F~x& ܊F*PjRPJf6X FP-FF~s#~ t~ uw&
tFPFPj"RPI~ u~ tjjRPIF  F f6X FPW,~uPhh hh IFFVu3vPfh  f6X G= s^&G
 tF  fvEFÐUf6X FP,Ð  F u3F F~s7F*PjRPHf6X FP:uhh Hhh hh EFVtvPfh   f6X F= s^&G
 tF  fvVDx&

hj
9IF hj 'IFj N*;~x& Րx&
hj
H~ ujRPGhh jRPGF*  F u3at~ thh FPajhh FP`j LRPFP`hh FP.DFVtvPfh   f6X )D= s^&G
 tF  fvB~  j!RPF8EF phj
GF  hj GFj!R;F~x& ܊F*PjwRPFf6X FP<8FF~s#~ t~ uw&
t~ tFPFPj"RP1F~ u~ tjjRPFF  F f6X FP7u3À~uLhh hh BFVtvPfh   f6X "D= s^&G
 tF  fvAFÐUf6X FPA7ÐU  
2

p UvV>
Ð  >
vVF*^&F^&  >p% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU젰
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2*>* 	*  RhÐ*Gh  ~ t	h7FNuÐ  FjfvFP]\
F FPNQVRhh ^Sa~uvvhh fv`Ã~P|FlFFPvvhh fv_`Ð  FPNQVRhh fv`vvvhh FP"`FPNQVRhh fvi`vvvhh FP_FPFP#[ÐUvCRP:[
  F  FFVF#PFF9F~FF^F&uډFFFÐ  VfvfvxZfvZF
^v&  FF9F|^v&  ^UVfvfv5ZFN^v&8 t&@ ^fj <fh  vfh   !jWRPf6B BZ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPYFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0VFVRPFXFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& )RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>  tF ^fvjFVRPyV *+ȃQ *P%jj fvvvvv9ÐUj=fvh 6V  
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7jRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wZRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F F F3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0݃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0nڃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv	  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pكRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6 ^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj 9Fufh  jjG^& tDfh  yj  +FHu
^&Guʡ +F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh    9Fufh  lj ^v&0E׃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;(}(F;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F F(Pv~ 7
F(F
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6pFPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%>p tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>V uFPÐFP	>V u^ÐU>V uFP+ÐFPU>V uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFpFp  F
FFFF  F9F~FF^v&8 uvvE~ u
FpF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"  n HPhFP
FPj hUF=
tK-
t
-.t-	 NF n HP*PPhvFt(=t#= ;t= DuÐ- Ht- t- t- tàn Ȣh7htLth7hِ 1= t= ut փ>T  t fj hN3  F- ~ ujQFÐF Df>r   FF Ffrf   ffffN*+;<|;s6F*@N*- Sh8h*F*PЃuFv j h8h jЃ]FUtKjhЃh	h` j hlfj hTG=th8hEtÐh	hPh	hv~&IOÐI&OÐU~ u h	hvjh\Hh	hPjh\7F  F~ ujFÐF Df>r   F,u j h6:h2fh  <уu,- F Ffrf   ffffN*+;|;sF*@N*- ,Sh6:h2j F*PЃufj hr F; j fh  Ѓh	h` fh  {Ѓt"h	hPh	hvăt"fj hE
fj h6=uSh:h\t!h6:h2ttfj hzPU~ u h	hvjh\h	hPjh\F  F~ uj-FÐF Df>r   Fu j h;hBfh σu- F Ffrf   ffffN*+;|;sF*@N*- Sh;hjF*Pσu됐  fh ΃h	h` cfh ΃t"h	hPh	hv'Ãt"}fj hEqfj h6=uh;h\t!h;ht6fj hzÃ>H  tj ht4 4   - ~ ujFÐF Dj ؃u^ j hz=hhtF F~s3] F*- j hz=hvFP^uF= j hz=hNhe>V utTetMFtFj t:h;h\fj h6=thz=htÐ  - ~ ujFÐF DF F~s-F*- j h>hFP\uF= j h>hlh또>V ut>kt7j hIfj hT=th>htÐ  - ~ uj߃FÐj5փuÐF D^ j hZ?h
tF F~s3d F*- j hZ?h
FP|uF= j hZ?h
lhc>V utTtMdtFjt:h;h\3fj h6=thZ?h
tÐUfvh:  l:F.fh. U Lfh.   }Lj/gLFfh. ! fLj/PL~ufh.  LL~u
lN:OÐU*FPlP&L:*P
LÐU*FPlPLF*P:PKÐ  >L u7+  FV;Vrw;Fv	L ÐFP
uh h UL  >L u
FPh iÐUL  >L u
FPh IÐUFPh 9FPh -j>L th UFPh FPh FPh j|MÐ  >N tRFPh FPh FPh FPh j0 h l<uN  >N u&v*N"FF FF
FPvBl:Ðb=tw$-t-| u)n  >nt% Ðn -t-t t-0 tn Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? UnFPgÐFPtHtÐn	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  ` h FF )fF~}j v`tF`  F~s#>` tFPh F  f+fF볐>`  F  `>` t(^&9^&?t`  FfF~|F~s>` tFPh ;f+fFҐ>` uKF~}Afh   j FV^& ^& h.` F 닐FPh j FV^&^&`Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h bfh   FbPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~ubPh Zj FF  	&v FPȃtFPh	hv؃~ thh
hh
FP4hh FPFVu3vPfh0  FPfvFPh	hP=ظ U؊FPfh  fh@x hZh:RPhEÐfh@x h.h
RPhfh   fh  nh׃h 
ufh  h j
u  Mfh@ hhRPhFPfh  =fh\  hwhV\^fh\  hXj 6\hIfhL8 h:hD  fh@ hh
RPh
fh\  h
f6\h
fhL8 h
hCFfhL8 h
F$PhCfh   Tfh  H hփh 
ufh  #h 
uÐ  hxC$PhxCj2ՃhxBPhxB
hxBPhxBj
ՃhxBPhxBj
|ՃF  hxB$PhxB=
hxBPhxB.
F~|hxcB$PhxeBh   fhx MBF  F~
}Yhx%B$Phx'Bj2ԃhxBPhx
Bhԃfh  gFhԃ~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhԃm$PÐUj
ӋFPh fh  	jmjӋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
JӋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx ]?fhx N?h	҃Ð  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2уfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h#Ѓfhp   j FPfu3Ð  fh    j FP@u3ÐF F~
shσfhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ΃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRve1
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ˃2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	&v FPBtFPh	hv3˃~ thh
hh
FP'hh FP_
FVu3fj hvP(
fvfh  FPF
fv.	FPh	hPʸ   F CFPPj/U'
~ u3FCFPNQQj/@-FN

 PÐU>P u3ø  
ÐU>P u3Ð 
Ԋ*  f   fFffffFFtF>P u3ËV 	
tVF  FU>P u3ËV 

  VF
^>P u3^fFVf
FFFF^v 
uFVFVFV^UF

fFf
F
fFf
fv~U
  fF
f
F
fFf
fvVUF
fF
f

  fFf
fv.SQR ZY[UfPVfffX]UfPVfFffX]Q YPR؃ tCZXÜa$aaCaBaBa++҃ a tûT RËTaËRaUCaFBaBa t]fB  s     t =4u<f  fff%f
   ff  fff%f
   f 0!<s3P˿	6 + r ׁĎsh3P1L!66ƱH6Z\66gP6g
P6g6g6&V6 +۴J!6
+3	O3X 66666P.^Yظ X)ZP.^Yۚp^  y>	uXP	 PX	 5! %&Y!	)&6, 		3	sx		 	&, >3&= t4
 vt3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
"t ""z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;vuQVWv _^Yt^?G^
u͎^O]UVWV	;t@t3_^] UWvt 3I >	u	@!_] SQ RQP,[RYt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGt
t"u%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVNFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvt
t	"uVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*it/ppPvvPvvF^&*iu^&?%t2XdVZ\T`3jfh~` uoF^*&itfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt it)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPitou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\iu̓.uMhhtAĞrr&.hht'jĞrr&pvv
iu̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvniupVvvj u
T t nĞr& \~P|z\P`
 P|z\PV^*&;tpVvv RT uInC-c = w.Zpinl6n6n6npkpppp&nnl`lppipnlppkppiRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^it$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vviu^] qqrDrprxrrrUwVW3FFv&vF
t~ }F, <Xw$ FF.qV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuCIWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
^F
TFFt~ u	WZguF u	WX&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>P tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uMuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B	&R=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV.3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVvv&PFPW Pvv;u)x&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;rvJ;pvp ;s33󫖹 +v*39j	tvvvj	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3	 u
_^]U VW 3~v
tȰCvu&6l	% uN&6l	&n	HȰ"Cu׍D&l	&n	% uDȰ"Ctd&l	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋp	"tp	F3] UFu		u { rFGFF3҃vvډWNu(t$>b uS#5!bd[F#%!u߇sʻ 	FV]U컃 .8tK
Ir	]PPR.^Y؃> ur	t	w1uRUVV EE< udF bF]ZXXˣ		UWVQS3r	t	 P	X[Y^_]ZXX˃PU츱	ء	F	F]XSQR	2P P/ZY[UfԀu	u3
tuH]U^h! UV		ȎغU$%!3]UWVRQSP.^Yۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;uztz^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;rv;pvp3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]        	              4.54  mm/dd/yyyy  Error: XMS driver (himem.sys) not installed XMS Version %d.%d
  Error: could not allocate XMS memory    .BAK  wb  .BIN  rb  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/Dock] [/Update] [/Backup] [/Restore] /X [/!]  where: /Dock    = operation applies to docking station         /Update  = update BIOS with new version         /Backup  = save BIOS to disk        /Restore = program BIOS with backup image         /X       = clear ESCD and CMOS/ECMOS        /F       = force docking station recovery         /C       = do not allow exit to DOS (power cycle)         /!       = do not allow exit to DOS (power off)  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Invalid command Machine is not docked Could not clear ESCD and CMOS because a password was  set or because the command is not supported Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp                            68xxx.BIN                $ ( , 0 $ % ;  ' ( 9  * + <  V W V= [ \ *> _ ` ? b c @ #  	 Z  	  D10/17/2001  O                                                                          *2>|:f
(Db 6bz <FNf
2LPX`jt *@Fn@`	
		F	b							

4
d
z



  Pr6d
N
`
p
                                  A    B    > f *	      ?    @    > f H	      C    D    > f f	      G    H    > f 	      K    L f 	      J    I h 	      E    F    L f 	      )     -    ' i 	      P     M h 	      &    -    $ i &	      N    O     Q   
R   
M g D	      T    U    S f n	      ,     -    * i 	      Y    X g 	      ]     -    [ i 	      a     -    _ i 	      d     -    b i 	      k    l    m    n     o     j f 	                 0Z                           _C_FILE_INFO=                                                         	               
	
\ \                                  	  	                                                                                                                                                                                                                                                                                                                                                                                                                                             	             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          [[[[[[[               (((((                  H                                                                                                                                        
                                                     %Y%Y%Y                  b					<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                  MZ #           ?:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         #XMSXXXX0Copyright Compaq Computer Corporation 1989,1991                                                 T                             

Error HM21: Windows 3.0 does not support memory above 16 Megabytes.

            Add the /ISAONLY parameter to HIMEM.EXE in CONFIG.SYS.

$                                                                                                                                
. . S. G vO[Ct7=uC u=. u5.>  u.>  t%RP 	!X
u<u@.. %)Kr
AtHVWP
tcĀtrv
rw
.:&M rX3J.>  uH .} .>_  t.I .Q . . u	X33XP% X. .} _^RQSPV.Y .+k .Q =@ s.Y   .>_  t.Y  .b  .)Q w	.Q   U.>h  t-.Y  .Q .h +w3.Q .h .Q .b =  t 33.b .Q .>Y  t@-@ ..>W u.` .D 2.F .I 3..6y &. &D. ^X[YZ._  3&f 3&> VDu4&> ISu+&> Ku#._ &- &, t@.b - .     u.b - πuM..& `.a. .> t
` .A a.P.%.	X.6 .. =u.   .>  t.b - .. .>h  t.>Y  t   <@u.;t%.>Z t.>Y  t.;o r
 .Z 23.>Y u.Z 
t.Z   23.>] t8 t
.]   2ó3.>]  tX t
.]    2ó3Q.>X u+. .>O  tz u .A . u.O  2Yó3Q.>X  t;.>O  t:. 8 .>O ut3u .A . u.O  2Yó3Q.>U  t
 .A '..%x |3H@ t@2Y  3ø 2.>  u.[ .Y O s"ڀtGW_

и ó3 sڀ t	O 2ó3`.;d r!.;f w.+d 3ҹ
 u?uaaĀu:QVW33.d .K ?uwG;s2҃
Ǌڋ._^Y?ĀuQVW3.d .K u?u	;Wwu?u t u
u+t9u1D  DED+Euָ 2_^Yó3QRVWsX| uT| t-\D.>d .K =uU;tU;t
 2_^ZYÇTUT뼳3ĀuBQVs3| u+3.d .K ?t@
T|
t^Yظ ^Y3ó3ĀuQRVWU>ӳs5| u-;Tw`r 2]_^ZYRZtD+T>F>)F3.>d .K =t	
DED+EE TReZt"+D>;Fwt
>)F>F>F TwtEDt>F;v tt>FD>F EDtEDED&w&w
&G  &G  X+Dȁ% &G&OXȁ% &&OVWR.6Z_^MLD+TtTUE3VRIZ^tED&w&
3&O&O&O&ODȁ% &&OVW.6_^DEDDEDLM]_^YY\DT3.d .K V?uw;uuw;uu
^ÐUSQR3FFF&F&LN?\r r_FV^\
a rZFV^n^rG*= u@|,= u4^tO^tOZY[ ~ tH^]Àt^V&w&&t+tLG +rB+FVr2GG^ËǺ ƃ v~wr߃vڳΐ                                                                                                                                         |        3                               FVNv*,6<0HtPQR6.7.w.w.4.t.t&. . ~ w9NsNU ˺3 3ÿ|&؋3ۋ.F EEӋʋ
  
  ])Nt^ 6*, > l^ u>H t20.G.G.<.G.G.Z[X*,6H.G.O..W..GËЋ3d K ?uu=9?u4GG;r*;Gr!GG;wvw;s+u
t
E uUÌȣ
@H  Ā3 VWfPfQfR( f=  vf  vfZfYfXƋ_^fVfWf3f3f3d K ?t&fffOf;sf?ufff;sfǃ
fγft2f_f^Ā VfRf fZ^QVW3d K u?u
f;Wwu?u t u
u:tHfu?fD    %fPfDffEffDf+fEufXָ 2_^Yó3VWQfRfPfSsf| udf| t2f\ffD>d K =ufUf;tfUf;t
f[fX 2fZY_^ÇfTfUfTf[f[fX3ĀG QVs63d K ?t@
| tT|
t^Yظ ^Y3QVs(3d K ?t@
fT|^Yȸ 2^Y3Ā VWfPfSf f[fX_^UfRVW֋fӳs?| u7f;Ts r 2_^fZ]fRfZtfDf+fT>fF>f)F3_^fZ]Q>d K =t

YYffDfEfDf+fEE fTfRbfZt(ff+D>f;Fwt>f)F>fF>F fT\tfEfDt>fFf;v ftt>fFfD>F fEfDftfEfDED&w&w
&fG    fXf+Df
&fGfXf
&fVWfR6fZ_^MLfDf+fTtfTfUfE3_^fZ]VRZ^tED&w&
f3&fG&fGfDf
&fVW6_^fDfEfDfDfEfDLM_^XX]fDfTf3d K fV?ufwf;uufwf;uu
f^                                                                    UfPfQfVfWS3FFF&ffNfn  \  f^]
  ^[VW*_^=  3Ɏf
f6&gf4   ffNfgfgfggfXf&gf4   ,= u:^tO^tO[f_f^fYfX ~ tH^]ót^&f&t(sDfGf
f+r;f;r.GfGf
ffffffff= v೧UP    uB9Fu;~Ut~^u- . "W
 Î$"e
  3؎X]X]..fvf~f   f;NvfNfQ6>fFf&e>fFf&efYrf)NffNfN2.
 .;d r%.;f wSR.+d 3һ
 Z[u.?ufPfRfVff3.d .K ?uuKG?uBfGfGf;r5fff;Gr)fGfGff;wvfwf;sff+u
tE fufUf^fZfX= s.#þj
C.6.0.2R.4 .<.>	.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         t)R uMdI uD`@ u;>V  u0d0 u+%) u$d  u` u>V  ud  33d$= tr$ 
t$ 
u    3= t
r䒨t,&䒨u$3䒨t$3䒨u 3ËR?Z% ;u ÜuR ?Zu	 }  `@ 6 6  .A `  .q  ?퐐.q   2 ?at4 u/d+ u&d" u ud u
d	 u 33d$tR)Z ôr &&?PTu&Lu&Gt 33S &>P OLu&&> uf$<um  [ôr!&Gu&	t&u	3v 3Î&& =HPu& $u 3Ë9t	""S.[u.OU .w.O+ >A "   /"8!!  b" 8! "!!  ,"!"  ("`    t4>$ u?O   V 3A 1t.t'?1tt-9>V  tX  
À>9 tV  >V  t3>#W>#_     PSQRWVU.> &]
t~430.9.&9B ȎЋ3 .9.9Ћ.>  &E.} ]^_ZY[X. p00!0<rP C/2<tD 3= t9=@ sP.I u?.9 u2.9 . . u2H3B3.#.> &E
[i4+.[ rHYdrt .>C  t	.94r( .><u	.9(.> .#&E&M33 &. &D. Ü3PX% = t# PX% tt 
                                             3S.w &&Btk&Wtc&G+SP.D .F  .I .6s Ȏ G  DT .G 
tX[3.D .F .I .W  "X[&G  &G.6s .G  [03COMPAQVWSR+ u"&&Bt&Wt.I .W Z[_^VWQ.>u 4& Y_^ZDS CORP &.& u	sEE>E  E E  .I .W &D  &|
&D  &D  &D &D & &D  VW.6_^&|&D
  &DO,&L&D  &D  W.6.& O, ui>3R   .ZO, 3&D  _W&|
&D  &D  &DO,&L& &D   VQ.6Y^&D s&D_R.><u7.>W u.` 2.D .F .I 3..W  r.<Z0s3.+k .Q RQSV3rCs37ú@ .S .>9u$   @..6y w&. &D. ^[YZÌ.c
 .}.s ..-.6.>W u"VWQW%0 .>s % .>` Y_^.><t	!Q
 3YtRZ0!.Q . .  .S  .I  .+  .+h  } RP53Ҹ  ! N9v    |K9d.>h  t.>Y tg=NG.>[  t?i5>3Ҹ@  EH9-@5'.o =u@ Q
Y3 H9.>< t5. 3 H95XZy '=  tPRZX H953.K K K9K9ù  ts-=s( # ='s =s =d s =
 s PSQR+ك ~3Ҵ tu.!ZY[XPSQR=  tʸ;sP0!X
 3= wZY[X.# t@.d 
 .K .#.d 3.K GGGGG
.f .   .    rPSQRVW3Q Ys        | m  cQ؍6O,rIq,? q,5 6,e ! V3=   B  >9 ^DuY __^ZY[XS û&?EIu&SAt[Ê$y<tRL\ًDtH 2PS  :r;r[X[X2   @ 2Z                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 C   `Ȏ3.- ar< r=.>.t3 3ҹ &<tr r
Q B$&[1.- Ȏ؎  ?   . .Q .a.-ÉEUu
%-`Ȏ3ҹ -  -3   --PXs4$ sBKua`3ێ..CCt;&$<t..3ێ..CCt&$<t< t.. 1aaPQR..Ȏ3ҹ .  -.3 - -ZYXð%pq
tt.d .K ?t
        
HIMEM: XMS Memory Manager  Version 3.06   
Copyright Compaq Computer Corporation 1989,1992.

$
Error HM1: Unrecognized A20 hardware.$
Error HM2: HIMEM requires MS-DOS 3.00 or higher.$
Error HM3: Invalid command line parameter.$
Error HM4: Cannot unmap the Shadow ROM.$
Warning HM5: Cannot disable A20
$
Error HM6: Cannot enable A20!$
Error HM7: Unable to unmap Shadow ROM - memory area is in use.$
Error HM8: HMAMIN parameter value out of range.$
Error HM9: LEAVE parameter value out of range.$Warning HM10: LEAVE parameter value out of range.

$
Error HM11: Available extended memory was not found.$
Error HM12: An XMS manager is already installed.$
Error HM13: NUMHANDLE parameter value out of range.$
Error HM14: SHADOW parameter not valid on this system.$
Error HM15: SHADOW parameter only valid on COMPAQ systems.$
Error HM16: HIMEM requires an 80x86-based machine.$
       XMS Driver not installed.

$
Error HM17: Move Block failure clearing memory - unmapping Shadow ROM incomplete.$
Warning HM18: The High Memory Area is unavailable.

$
Warning HM19: The A20 Line was already enabled.
$
Warning HM20: ISA memory above 16 Megabytes does not exist

$  COMPAQ Shadow ROM area recovered. . . $  Minimum HMA residual size . . . . . . $  High Memory Area available  . . . . . $  Total XMS extended memory found . . . $  Maximum extended memory blocks  . . . $  XMS specification version . . . . . . $ HIMEM.EXE is an installable device driver that allows MS-DOS 
 programs to access extended memory using eXtended Memory 
 Specifications (XMS).

 To install the extended memory manager (HIMEM), include the
 following in CONFIG.SYS file.

        DEVICE = HIMEM.EXE [Option]
 Option:
        /HMAMIN=nn      Sets the minimum amount of the HMA in Kbytes.
        /NUMHANDLES=nn  Sets the maximum number of EMB handles.
        /ISAONLY        Manage only 16 megabytes of memory.
        /LEAVE=nn       Do not manage this amount of extended memory (Kbytes).
        /SHADOWROM      Free extended RAM used for ROM BIOS. (386 or 486)
        /ABOVE16        Manage memory above 16 megabytes on an ISA system.

 If HIMEM is executed from the command line, the current extended 
 memory information is displayed.
$ KB
$.$/INT15 /HMAMIN /NUMHANDLES /SHADOWROM /SHADOWRAM /LEAVE /!SHOW /ISAONLY HELP help ? /WINNOISAONLY /ABOVE16                    ptlcascade att6300plus ps2 hpvectra acer1100 at                    .:Ȏ؎иB p0: u   L! C/=<umøC/<< E n ~<Jú>C 3  <S<*>$ 3X<ô <= tg=ú<=3Ҹ@ H9ô< t>tt	=Ãu
s; s8PRB>XP3EH9X_=  t m>3%H9}fPfSfRfQ<fY   fZf[fXfPfRB>LfXfPff4 H95fXf[f tm>%fff H9fZf[fXfQf
   f3ffYftfRfZ0!s=r<ô< t	=tú<u<fQ<fY f; ff	<3ô<R3=u}sXQX;|ȃ} Q 3R].!X
 ؁ 	
؃	 3R0X,Y        A20 line currently enabled.
$  A20 line currently disabled.
$
$  (Additional free XMS memory could be available for this system.)
$  High Memory Area available  . . . . . . $  High Memory Area not available.
$  Unable to report available memory size.
$  XMS driver not installed.
$  VDISK loaded, unable to report on A20 status.
$  VDISK loaded, unable to report extended memory status.
$  Total XMS Extended memory free  . . . . $  Largest block of XMS memory free  . . . $  XMS resident driver major version . . . $  XMS resident driver minor version . . . $  S.:33Ɋ  u Ȏ & >BB^ [.1Bގ6 &t
 >BB< t#<
t<
tg rF&BP3JÊ< tG<
tC<
t?< t8<	t4</t
<-t<?t)F& rF&B<<&:FWSQRS3Ҁ<?uF<
t!< t&?hs.1&B[	[&NZY[_<=uFt"r=? wt
u.o ú
2&B.h   <=uF~t-Sr(.;Q w=@ sm2;.h .[   ú<2&Bt<=uFk3trk= w
t.K ú
3&BO?<=uF6 r<oft<onu!/)Ȏfr
tr
.<ú|3C3&B  Ȏ7r
Er
.<ú|3C3&B .C   .<  .  Mr.9 =  t.<4&VQ  u<A|	<Z FY^SQRV
 33Ɋ0 |	wF^ZY[V3< t$<	t< t<
t<
t<0|	<9wF@3= w^P< t<	tNXP< t< t<=t<
t<
uXVP3ɬ< t<$tAX^WVQ3ɀ< t<
t< t<=t
&= tAt|Y^_P$p  q<1t<3uXXȎ؃:
6Ð999BBBW9_9k9v99P99999@@*A@Q@Q@YAdAoAzA                                                                                                                                                                                                                                                                                              	      ]Pg%\5G[m;pL|.Ba7Scx	F	X	g										
6
F
L
Q
V
_
o


	Kv)
i
y






),03;CHOX^coy9]e&Hj 203-Memory Address Error 
Non-System disk ore
replace and striky key when ready
}
602-D ette Boot RecordH5 !Run Configuration Utility1720-SMART Ha0Drive detects imminent failure (Fing Attr: ??)

Please back up the co{nts ofh1drun
HDD Self Test in F10`"tup 1800-Tempe!Alert  7{A proc~@has be eda"s n0orq'#C7MOSA%3-1)d(s a%'&1(&by POST o1155uBo1?Comm P(6Assignm!lic0%611-Prima Flopp@-?/R0n02-S nd12/001 tGrol %85sType17A88q ;94O<f=03<0;W@0;f@H=C8 1;DH=348@>G=60-Fix'@doe(sup( wBloPModrI%1I1JK7g1>6K0 AO=PL01s73IMDMAL3L?W$L5V'IdifymAmQ[X\]4[ Q_#K`?^av]8VParamr Table1BI)dHalp' c 538P!apgE=Updb.49h... Invalid el ronic serial _numbe108I/O ROMW%308Kl93r8304r@UnitLoad_all -hi4Monochrom$k 164Sizu;qrHx"0V$Inst`wi etwork`"rvp9bActe!No rachi164Op*stq# Pg@ CheP2  PCI BusAg|A910-ExgnoStorag:eviD= HvF1x`1`gP9lS1T0xk2_{3\3o02 08:rpqQs.E=IOCHECK acwlz3-{Tipy& Dap O X B  Powe{r-Pass@dXOKDo you!llzato pp  s? [Y/N]?RҞsVMAdpiaP/R"orhipn01 n (ABO= 'C_trl +$tDel'pz8-11A: X&changedu2: m oqne!&1PpP3߯: Video	m-4z:rrup+f@_u5 i8͹6ߺan3(@_#expansb  TurnҠcej &f]qr<F1>:G AbSb^+rmal2Upo mu"տ 3gi wa0,Q+B0kA(Strg+Un/tbr,I ϪnaTf@9owo$uWtomculed: [:s To~ mie~: Kbyt@) cksum #bn,NfauЪ`nuMl0wiW'Next? EAAgti#Exv0Ӯs7saEA7cce=   F1`0 OF2 CTS`k I .pugy # Mai Oances EntQ;F.5w9ipw, usimodut~Yme@erequi{reQ0s.  `oD٤. rLK1"Bj>GMib?_ay126re| Mexcee 'K'Ś1) >CircuU=uUn$N'wPlJn$dӇ%'.,i.Sc,eT !"P.0S1t	C11(ppc1@%#9	,vInr÷ypD	Shut2l/down` P~ %0Ѳڡe K۷PIN: [5]Nxoq left0
ERROR
wY`ha߰A}7goney 5la"MQIndex (MSGIDX)   t   _      8     
   .h   n f  ffffT0 ISvݓV Q'  A            > Ji    T h  gG W e M AY 9|@. 0G  EnSa0~ G ( @ ظ   f3  ?f
 4 P f pπp6 f6   } /  6 >x  .h1ʚv PS $<t4r g[X `
u1dWG~WrBWr<TW. u)(.< t.߈h^.a !!`6PhDrAV(< 
u^V3$  ^(P*^`% &2 4aSP( 22< tFX[úB *$PQR  ZY?._/012 346?7_89:;f`.t.0, ~ xri rakfL+@ Aكpr$ wr/讁@f+D`Af+\ r@ .hdfa= PR),3HZiX0GG,
@I`&Fa`.> GuhP'XhF r.>.puFKfPfQR>.fh f3f% aZfYfXURQSWF^
D= F\ ^0TFU\މ^t
;v F;F
 < uWX < ȭ22 IF t%[Ջ%[[~%[뽹Y% #Z8t
` @[uPj Ѓ;}
+V 
N JZ=`[uAN3V5,_[YZ]`P P&X&0KPQW^ kPRY+UkPkP]]] -klmo?p_qrstuvx?y`ރ6.uߋ;v{Q0h *Yp[QwLQ?f&YCCpfKXݻ  a3YapdP=SRP3pX?[>?P$&%<GP1PP	 ff}M t    <BMtf3@S.
.&uo<t`y;| `6<?P2PIX0P )r
:@PSfRU3Kt.fGenu fineInteluwf=sl=r'=v f%f2ft PY tI f  =|x	tǀunWj0`f@3tᜀ5uRfDQQ $<@tC<t?`>ҜH$_u.fA-ۊffҜCt	]fZf[я
ffȱ qڋh`
=? ^   	 hh]GhF ؾj  D @0`="0r F1""ؿ:=?@hMױ@߿8EɀVm^ ?юp#Փ~~U= r&+==rҺW>0&_pc&n &w
, fgh  0 pqr  <ABCDE xyz{|}  ߆ fsQfR쿾
R &
¾B r
&@yp$0Bŭ.0Y1&SQV3
Ê^Y[.t?.FuN.PW# _PSWfVUSW! fv߿ h ޿RF~2p,ك!IN3d^
u
t_΋N_[]f^_SV hP^[þp
  âS>
)F10=ROM Based Soetup! Epring=
G"K
 t0` 
'aF
= O t+ 3@1  
p' 蒑B	`^ދ
ݶ2nú $t
K`t.LF12=Networkrvice BootWake On LANAttemptto" 5D`3ht6 r	aܺ8W#t Aޘ4E b6# Ud)bFV3F<^h#as_ 蝏{uN{s	2sͽQWVRuy3FஈNF }F3؁mF?	uCFG~NtGf`hq }vhsf(Z^_Y/[Notebook hard driveHMultiBayJDoKckbC	b	(top)
b?ottom)left@Flopp	  US9BCD-Qٯ:HDis!SuperN#ICj11	23o!"# $%'?(_)*+, -.0?1_2345679?:$Bp;`p;	~p;
p;p;p;
p;o2=P=n=ylectDesͿAB͹U@ and mothe highlEtyour cho.  PresscFose.Seconds until au atic defa`	 start: ,(T$xK';L!ZipC:`t= Dr= k`d hm"XS0ô0."&t p_ S0 2}F3mF؊' tA<v<st1& 2S2}AY$QTYAr R @i.
*Р `+jjj(Pj #U  ]_z  _  mAރ  2gQ
   t0S32Ɋ <tF8tF3}F $ Zeq_`q URVQ0., L.T^Y^Z]hSi.*[i݁jQSVW/ s&Q.<.-00?00.AިY_^[YsQB qOu h^"ۙ Ot0Pt+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu@w`2bvXʱo_dw j]r
;w2Ҁ``JAh1gFYô.*<2ufQWa h"  X  h=Ӳ fhԂ h" h`ӂ_f@Q> ̀Y,` hǓ;BBJQX@ 6jf.fff=ƃ 2ɉX7O2Micro SmJCBus Reader\ PW ?.g&:u&Gf_g&gO߾\_X   ?  K   rPhq}P?g&F Kg&F  u
hhrbg&F& XȿPg&F  r?@ &   @ r) ޢ  T޾׎Ǎ~ع  _  QRV࢈DT r&%^ZY2fХfL	k
L  rр ^ "  UG$r&YwPS(  r^[XRN(Q'CYZQ2' ug&9N( Pfr`r[{ 2;w_(;r
V퉫utGB  r݋BԠ/?V?CPQGysrPRb1 Z.>ohD".fPS@0ǀuh3tB `.> t.fQfRWf  2f?YffP_fZfYQf gf&!=TDSSu ȋff3gf_uf.>f^fs_YPűQRWUr_ZЅЯVW t@θHu`ut_^`_8 tX@o, 
ῆ ԷZ SԂw0' F?SMݘ@ H/P JaÍ62簍pq$AiW0W $rtDDR?8 @ A D]EHT?md   ҿ$x'z b |끀 
   z P?Q?       ߿  r k lP?rւ 	 _P@CS  C  G@ H T@ X 	 Ӏ  Y~ 1 Q?$4&. U `/ .s p@. r0`\. ab h    !! @!  UAC 6
^@pQ 
#
qPpqC

U 

 f
heu  P=
PQR"S߿ h
cfQ3Ҁ
t
PЊ͞&ɭr`fYf[	ÐrPZYXp&> tRc ~rE^& qf3C hM}  G 1 < t&G[ 	Q3& !)p!f3'2*f&© uf
ffKf&&&fCڤ!0A*(	îO)**@+#*l +rd'h;`e@ 01 !1&&i/SQ"S3r`&&q&q@33r4Y{[pfPffRfVW3ffCf[fKfSF0r!T0а K I+r"SO_0̀f@SQVW3_^Ѕ3t`ѯ3ff@+
rfp
_A!Tf   m rQ Mu2`1f u" h[haE}%
 4gPRKȽU7fW Qt% s	 f5& fff>1&fh/3c皀; 	  u7)fw)f~/u!U/uU/uU/u	g& 1(tx3OOrnfQQP (Q@TY QP~/uU/t WZ	;>&QW(GfF=bcdf/g Ohoijklmo/p Oqorstuvx/y Ozo{|}~/ Ooχ/ Ooϐ/ Ooϙ/OoŽPAMff.,&0&u h^5rWrRrM0&tf݋fŠ | pOV t#8r" #   /  `yN O7pf]`  >fUr*6O  R Z $rGq 8Kuf]? a7 rCF+ @ 3[cg&8E t fEGx_ #Ra>O(E(>5& t`047QMhPSQ Z Pˇf&x_`=W{ r^ r
  GC_NNOt$AO$wWw  _Wl  sq?_  ?Q q0߰@B ? пð 3 S Sp' "Q ǀPǟ ̀cAQy/AˊOQWE˨uptPGX_Yù
 d hcxs@]
P <uAbӭuĀ PRO Ohh < ugZ0ՊAD t	A֕ހ e֝<|<t<t2<tH0F $[\E"L
Lhs#L`UfA#Lf
ïT2+"D
D#DDf_f#Df0f`Sn Al 1l  ]1 R  ik U B1 K jSU
 j %U s
 Fj Hi p1 j h ږ   So `*i ͅ @u /S !o I K :N .M  < m! X" m# ǡ( R$ `$q % <&Pj h* d _ 
; 1'  ) tv+ `\, nZ- / 0 N1 `2 L3 m= > m? @ KnS A arp m5 1m 16 n7 R9 hG LH : 4 |jC 91D ]UE jF f1I   J N. 
K jL RM N mO tXP #nQ 3R V hW lXPY =LZ T1[ ihb c Ue .ig 01\#" f"i0 @ ؠ   !E  f   3.T0. >.DȴPX% hX@ .X=X@u
_^rYP
ˊظX
)c

9
PW<;f&E1_XhԚXhOz\h
%{( h+Xu} PQq0> 3_BN	h[YcP dF$h4s VM   ! $!Õa6vP2F X 89Lp_	 Bf3uf @  7"`"*"^`""``"O"L`3 3CL &>]F&DEJ&&D >Fu d'aY(6) 'eY(޷+j@  1mF}
Ȁ}	/>iF 33S[tS[S述 122[pM33 ttoh`Hcs
Jha&hXD
Ͽ< 6)DuL
p
E$<u:D
@١sd
{#<r& u<fp,` uL
 6 6QF󦀸uP9  ?X 16K@ &u{h/s6	\
b?9uP
 D&}?u < t&E_b t =:&E^D:&Efww>Gt6Gj t.& St	&  tKJ&Kxu	;\	PSqJ PJ ?J>jF_3& ?PW>kF	_[XGt+tJ# L xtK  t Sw\D@8PV!$!"桾tVh1'e+q&  ^X88hA7r!L	@$vTt
v#U`W8VO.'QQ_$<v߰ @Eu<\_USQ3  v
p
u$@"<u@P>X\PRtߊ﹘:1thU4!~Că ih=:ZX`2ҿǿF& *t5}F=mFtOu80: u	/t!sy8 < uq5%esq
t!B&avvvam׃/P3`0h7sy&=  V @@Gu_ @@}^ py3f`IG@QGf_z{ {} |U  { G&egWʃO&MuOO~fGtWt$Ot,t"߹OqyG}zr Ǿp,MoOg&G/z  xYPh
P2Uhp]G^_kרtC<uLD8O =_7D D	 d
z-1Q]b:tSrG&}	r??23gt`hy8a&EH$;	&Mo&]U`.'	C%f rK 0J3ϠUڀٷ Shچ7F 
~|ߴh1s܃]RRB ZW&=w uAPjZ)
hf
 m_  P
2 
31X}DЮ31` Ф#<fh~Tq~|;.
!\[ Z +;.-ы% u\u8w@|M.:t:.Yc]  5GtG}5X \ &   "<u T aË

	`PS@[Xr=2A<.VބW gS1e{
5[ P]ǿ у[ai$gu @USQWf3Ҁ	fd︠_`m`֎fmhZ73۹ F
t):u%FD	& hT}F & 	 h	s'}F3'ԃa8B3 
3 a/p mF US . [9 r6Qh- r*䎃<u&' t&f1+ '11ݨt
vj%'W+`QQis& 0RlZltt hԧ7 6 YQo?p<[r=?u?(B>% = tkPYaWV]血p3mF+S6 
`IHH+E&NFEQI,{[Fr5P-0pu{So[uch8~xfD^1ݹ @쨀u$P<PtRujZD1ikO:"ZZRWV 0  PE
X@  C
lr'heW2/B0Ɛ؀? C@%?r@DdU؋Ð؊ߊu,u
@1

+&C323&vtP
}
U
t&
0 迪 
5  OU2

P
(4
uӴ
: >

02
? %w ^ޑPRW1&%A8&]7&U>
t ˀA]H_ZX3һ -w2C.%/%N 1hC _= %߸^F$ `m&(/)O*Y>u  'an  rBfsf3fYu 3 Q>ES:wuBE&8Uu8 1]
R +B&U
ZK.؟rB/3ZfYB
'qr hS"KGY1tY%9@:1p	Ãh4YBU
<tuZێûP[Vs6^fw  XEBD
EdUpLHxFMH\HUf`W؎ FwD.  ڎfafSfQf.DfNfff#fYf[MVftGf    NDIg~f;t&fP QQSR	QF0P0f^O`2ۂfaf`PV0faPӐW3_X.>D- .YRQTACO[F|RD[ QRJ[&\\[	&\ .D P[%\@B^F5\`D fFf.D`ffDF.Df.>D,E.Di t@ZDtKtY@ZDtNpk QfS@SIZVfB.qj0f^;VrT%lLPmQnoܠYki PPQf{RRfOff?fgp/U{Pr. f yDTf@dfPf.lffHdfyfXfqdf33ijuRms?Iqs*Qf^Vf+f;wfff}}33Rfl|UfDP+^R'RRRS=Æ$.pQQyPSɠwv`Rx333Ҹ  QW>Ipf_F
3}5upfJE#ȩ t0 t A аjt
жt} tWM_ }h   F EF^V g SV^icQ&tY&_  
`< tr&\]&\U@
&dNd mF
S؂[u	F&4F^[_YC?F FHNL{?}AրVWًЍ0' }Fr_^WfQS {h
#f N f^Ht
!p[fY_` t =$P`nPu2Mߋرtp6s } tp( ` j G&&EoSRU`Qj@6^]Z0V`} JJ ȑ^X~p*F
  tI#TpfPKސF FG d3duhhdKu`<Uuùd `FhQ4ﰭd&&Xqtû   hmBo& ho9Ph>C%{罰`罝X!$!:   °:sJJiԑ: 
ehìB   tFt 4 a͠h?!` tֺKuˀ& &  
 ej@ `hdCsP<t<u}VuЂ:0u?밮1R*`PɽhXh4-0 % PM ' t[­s#_ POX7ʽ#e eDt?P`}  ֺ%`G  V#W 3 D1p   ; Z x     0NPJ`^~bh/B1fF3.NF r j
0ވBFuр~2wFd#W-00
<2wd8F w(8F wI N@UF ;t
 u@mF^KہN.~r@V»  {a{Poÿ< fPypff @ffRfP2f!Np
 ffFf3fv1|ZfFsfBPfNfH1 r9s@U`}f3ɐ0-ǿ:fт 	faÒfPV3v޸rF3DX

S,0<	v	,$P.[W ߈D

LVffH
T
TT {#	#
#f_C
f Ўfv@S  P:FP
uff^fNfVO_f^5PMR0fPVVǈF h`Ob
àzff  fffffX%"4Ѵ 6f>f>f  fX!gfg`p0GR 9 S( a3P*h{D<P,)SVW0)fQhcYA2u;qth,3/)_^[ø)GPRh B Ph`H fP4T4M h=T4Q5R3 6w hݝ6@ Shc9 @54fQa \  1 h
ZXf  w$f?
$>BP?$?B$
иW>HU?fB OEBM8?M?@Q8?QERARA/?B@PSgS껐E=0` ػ 7 ?   xAG갋pq$NqO p3q O&qCɡP Ou̀PORt%S Q̀ts̠-Uou`O%.û 3밀O<KuPW;`dE7hC3_0*s-$d1L - t+==vP]P ZtPa X^Pہ?UuC33Ɋoђu uw& PͲ$ )3@` Pf^ X)N dZ&& &0/t h򿣶30Y hLi
t[ Ȱ t
̪ŀv#t̰n57ool-5UPXap_v[tBu8v&> 㟸 h`t`x_P3 u $hO&*D
#hVsyqst.>W ul2hS`!uVUuQ 
wGW2 Q  h^u= Dt= tY蝵LY.W^!r@h蹵Pf|A]s,ޙu\0<  Qhl× `OvX(L 6jf.f?f0"E5a rfKP?R r >RW379tt_Z"zSQ g!fPRWVwWto"؀kr3ok@K:.JZ;wp>I AKD4?+ȿV ЙE469.LZ
6 .MZ6z896^_ " 8h@xxoY`S`Z .BB <t B_B2JݾhZ߿   8uQ@N`23Ұ
ShVs9t0`́ y autЭi at]U [aSR  C4 $@`1-1a`  h	 h{
 "B2PaԀa$8uXRPY2XZ@QrtwvYu0ѹ }R _wZPUտ U2<U>@MJuۋM俧uJutC!f5gNW@  hA u
3Ҹ GǡFǸvFǰ) uPs\t _
N" u0KBO

h0  @pLL&i &&g & & & & p@tp ߮@ݧA+û0 ۾] 
 q10W1&>r 4u=fSfH!G 1ۙ8f[ ɣ     f ! "o^3@"""^*j	r>@sր  W ` ⽙` 
  "# 
 Uuo A t&r .s t kv; tu@hܣ"f3f@O  f> ? <  v< f) '@  wf fyQf.Sǻ @!aA`uft@ W&|}~fsr< #f X 
8t"*e t^.xyo{ 0G5]҈.O n21_ >@%sPn @
A.֡ u{	t R . .O#5z2& ⿧ #.h_ 
Phxh  Հ t>arcrh R$
 f%"#a j j hgXX1
Y@K<ӋSh/h[{"
 tE2s 1|1
x{0y t um1
}{/  tE. 0 
0   t!*E@d6ڬ6cta@a aP_S09pv%` D ' s'(t(!R)B*(+[SW&L o2 >u
f y@hBu
>@u] >Pu>L rp0L wf@rHfSVWU]_^[s.L `&O  2WQSL O 33ۃ 5@}t[Y_h Ј@u$.ۋBSd3`<u-!f[U :0tu
9 )w@"R1t1uL 2Ap)_[WSPR`ZXL4`d3͊566 &&23 G&CF2  &EfG GdHF r&u&Ӂ5J4FFX<&GJ GFHJ6nI:
/@X$OO&2uG&2%& !4Xţ ױ@[_uq3pB ՙ@h 0U+ U= uk0UVt2!zSRUfVЌňL Őf&7f u&Z&?Zu `[ G&!] &@htL *f&߉6  804t L "^2f^9] VWf @  !XfA`3f0 OOf  1cdr_^0`WV p`
f`|00318 `7 U DTDo   i.]|j 0  h`7mw i?l  Q oa (  oW @`7 oL H`7 oA P`7 o6T W X2n`+``7 omؾ.]qaAaj|\D 9Pi8S } yy S {hG|q[`g8
uh XV[hd!!#4v#i#!#pPQWh3} 0_Y` 0aPQ= `th0 @fYX "@SP
&  ff&Ϝ X[@h  @` prO  Òr '`rBfRf JhDOFfPQ   hX.6]V. E <t. i~ tq.ri."D.|u.:DtSISwD:zSr5+Ss&Sv
uqPQj
ce`
 Z Z?2PQRa!&$` hycSQW@a$a_f2 TCA6n @1Q0C@ԩ@;uYð!$00f` 6h3`\ 33h` #39faÚ0.Foh  hǳh=S@osI h|r< t t t@t߁(t(tɿ
 2c BSf+QWLH0!
SfUhSrTۼ  ս_fhpQ# BBaTذÀt!8 DHhaW	6e蚐xCh&cCf`  f30 3 `+b @n>mF&}uu F!p 6USёѺ
  % {qu;
h,L7-v "hOy&x@ #2sr&$&蘪8미 й`tՎß`aPD|7o/Xð,? t
53Wh@&P TW 30.Gn3|Б" pYðdߛ`d"U  pՎFPؿE}0-&؁` uM9NwNuӃ~ t"F= wt%  @+7h@Á1 @D I 	 @Fo a `wτ `#tsF4 v}G t>`u᰽D*o䎨f7G adt5 t2 t tf{2f
A0<ˁGenuu#fineIunteluw <Є` 3Ҋut/g.f;tez
ZP-fPfQVWSR , 6jf.fffսCv X/1[__^fYfXktjb \׼!ĝȝUНԝF0؝Ӻf`a% SEp S 0fZ@[au  %=u ?2D:!f`phqcd5rX 0|e:r;s 0څ
!	hⓤd%fa$'t1(%.&f o<)X`/Uo/Ì  0 C"%1'% C< B<2b$~fȀt<p t0#ȋپP޾ Q t!u7?FYS0b 3@ @urf uyip:3:@.:;o<n<#>>>	? u @F	qk u؀ޱ#hPtM	HIˢTJPjFrX?r  P	X@ASQ 32PEJOݝv@fWChq3
fgX	Sϻ ;sQSfAr: @3҃f  2fƃY0fXff:
 fA0[ffpZY+vAWqq_L2_&u˃ uZ=PrUfS %Pj uCfy*#af= b t0ab t( f`0f
Q 0"p`wh:̻d 0Դ hL}CJ_	Z $H۸8Ht1j

36xo@ hDF F h<P7+Xt ooHq hn
v	3؋
 
>`ut. h3֨@uKh3֊u;P̓.9s(w% < t<ut
u8ùtPR@䈰52u  w & PPXRt'vJt
t@௻ hmsۻd% r/kPh9i2P>u` h2s?d-m&>! rrԋﲁRzspZ thhuuh	r~`	 `'Zjj 6uS`` FF ph ru
V@ VF  >t !$!$< uҋC` _
N<̣2<ģW	$ܣ"3`Aʘ7u1Ŗd[@ЃTYP=`|E+t 5+
u
2Ɋ، uȎ؊xt<u
5+ȵE$<u&w _$īF"L  N L N @ؠu û  t  Pؘ[UÐu
j OjɘgI|(!!2(<!`[ΰF Pssu$y0G}tY}$k}~}}.#Ki .t4&^<r&.w 3.\{  U.\U.d nb Ǔ 0 W	x .|_@DuQ&~% PlʂP蝟Xӹ
 {.:t
a ._
vXP%8Xr6%?ȸu{Ua    PJNL p      QKOMp @{t  t P(.DG H hsJ϶ hvsihuٞ huْ AE^  f  Pp m o 
v %&.|߰t&ư
&r"$.:Dt1֐/Ku
ؘ E(A@P" s	EXe&P 3wC  H rr`2h!L/ܰvaVRQShwuThkJBS.68u,2
t&6@@t2 s7ޝ[YZ^_SûPOcX<?tFhMEjjjj P &h#o\ hc`45t = ;t= Dt
hU~[RWVSp݀`Y1
0][`Ǥ Qu"1*׿OطhV9Ct`>J=O+ 0Ъ7M rhP8MP
0 :s7^AU90mΠ!lmns:^ qQ%o Snrt-$p<pu ʘ7n s4 u1G oh\-L 0j÷hlnt<÷~Euhe3SRn? ?
#R `S Д3'aaav ?8af)  u@"t@"3P&&W!Xfu33ff&37u>FȋR90hL p55[Q)?  :NQ)2  ?AQ)%g 	
1,,,r,FX@6ǋVW 2_2FHt"x02
u
2Ղ ߂
 @2EH2&&&E6&e?
td&Ep6&&sEr86E9&E<r&}	rw777VW^20^2*7
&}v;h4YPRQ307@
%@tWBeY3yR`PQZhw$1u5
g@|vF > EiQ 'XO/YѻoŤ}-7: tOJVTL
G*6h&&  t8Vpt' u G,6ҋ6}$ $ `& && pVU`dՐdQe`P`  XCgU @p
ڹ  . Bd]B把8uG_wA_;_w5_/_)_#C]B_]bbG66P濄X\ [@ApgBpgCpggghÜVptwvFvFȰvF蝊`<;weċSmX؊H<wM3ɆQ#"XR< roYƊȊĴ3Їуڕr.80|@ktsWI|hu@tJss	]s2s&FvP⁀wk 2Zыf&. V"U  懀&k !< h^}u$f&PBÊ$
òۿ Gu%qvuhsߡ$档&Q@Pf  f#f#f#f#f#f#f#DGfPfSfQfRVWhfI&LxF%Qff
fhf3f3ɹ of0Q# f+f ! KIu*Iآ$h_3ہ_sV4C\`] a^p_^fZfYf[fD3hI
  `Q3hFtK}FmFߊ?q1tu*SGg twt	GtPРuG⻹ D
  1u|# u
qt	 ߯Da=`2Q 揀 R`s< |&	3yt`#0u΄PuՅ ?-&Qt
c}S4KBC Kernel: xx.xx
 ` ؾh&
 t? p.`L3۸ 2ҹJ%daVWQغI 4_^t
` h63_hzø u
$<r (r	. f3hh/.ߋ %
pxtdw t
Qh$SgTQDh=  t^bwY-s.>Hpfѧf5Q t&)f u@? o > lc \*Fdef Fc~ck7~e uQ C9  h#t
edFPhBFe:Ff`r, ǰ hǴ FdG~ǻ;  Q 	:  <g ht%h!h øaf`W{p1Kh u>fB !SCA[t$ 1 h}҃N rp@Df`   F^mïϰ%P XSĻ  y ,p   h"ø[t(t@t,u F,ՅÂ ' qhń
QúߋwF."َ**Յ/.%Q+Ëy D/U2NfQdYF :uE1D]!1&t
t
u
t#u
tN `t"FF!  u3! :5tFFdz ulm`F: uYPeb + u6F1eFfPf6`@up  jjj(j	R 	UaUR\rhN#12   4pw1 hDZ]RZr@q ÿ t0TCRQ QYsY2Q$
a	 !u$FՅ5Zf`~GtB`u#I곿N
 *s! ƀu.> %faж`7Rt9k  m $l0tn tƋߋi gP sE" 8HhD٭3P/#rhϻo p %Q}
2B Z4!ر.uQ$<u:EpƧr"&!-{tB* tB* tDt ΁P uG-&z- ި&& ' EࡢmFSQ 3(u,S([rE*	ˁY[C <ff<1`00xx00`6a||9>>>r$.R=tR=p~ kPr8w'G Ž<a7= &2høC  E ˒ˀAorB kEڻuN D M0)0G/sAo G0F7׳0Hm	 aUfV3vCDPDQD S7FQf^]`R#୻`E'
PduXTf@  'O7o89:;th  "..֖ mf%pm	@?Ж6FACS@ppOt4DBGP4rCOMPAQCPQ005A !svRwr  8f  qP0r|v|w3	 lГ2|0j|||"} r
 2f/s RSDT}(?v  wf`ht3hBt]f  fč(fj  gfFgf` FPTR ffgg߈F f. ^$.+.(f.$tgFm0(N~$f;+0<h/2qԑt3ffgf&f.>$fp<ff(.)t(2@@~(@N g&F	f  rgcfff3ff+f+.,⋵ u4f0.> gf|3d$ѧdP~`Xff-ñaV3g&fFgf^fY[Paff=TDSDt+ҢSt#ҢPtТSBStf=CIPAtf?=PGBDt e~`Qrd< ur`0
baRUfQъ2 tSP	rDr@v_Ӂ;0tg&P.XfY8]eeafWfVf&fm0.k0@(f`fPӜ)$ 4 
Ȱ c-cff	h3c@f t ߺhBfP{W efX3 cĸ gZ`Ҝ.@P33PDDX PUUXPffXg&Ѵhu|hС_efPV?( )F	 ȃ)+A,urP+,^e,RW  h`#8 v 7h=_Z13<PStǸS`1fP3h f&L qfsްġ L fXp,`ъvh" 03f0<&?   6Gu  ة` pOGGfa3M[־ P׀׭1U1  P׈ G>G&geE E uMMpGfEBtXAt$OAt32t)O$fMorþ0mMe&GapA    mø  TmW`f
0<hb^! hǝ̀tt߿ ϥ@-Ϳ }͊_ePSh{ێË̌ӼRQsYZҏhp,Wf`FF  h|t ]uᾰ hT w$w(w,w0w4w8w ̋Ã9FtFfNDvF> h궤ɀ̿(fa`E13ɊMhAet

hm ;ruaaWFH ^@b
f fN⠳ф %N2f.9su st_8 rfQPH_rf;^uf;Nt7fyt +
tF~Y`_epPR0 t,!U6FZfV!f%ph
 `߳fQ"2Hw`s6 s
s r"6=j.<t..T{ hhV^_e1PQR`;u f@B c`ZYXr10r,@ % 
 r( % rB 藗r?*(P( Bߋ A" X%@Q#W h}VY(*+PQ t  eu.]0y1sd'"0<1@mU1m%0A1C3R.ӫZ77fX87h8p:S@hUV; 倃[pW` SH[ u#x  p>>uHV .u  E~0rp&tjDt_& rT  r&= us"6>
qFr/r4.؋VpF< t ^Js 
t u v IN  hDOOw 2LVZUh!>Ma1>zCqF6rPFtI	My 
MpF
FtQ&0ds¥MGYwPV׸
LMz w+FYCߍvfA fDr[ +5ffLs-<t(<R#O0VY#VL^032t
t
u
hMtrt
<0r<9w*tM> ʇVSQ UY[,0>E*SQeiV;| 1atbu$
f`3pF& thYV֎fv0Ihs_gf9taP2@m  m th"6H̤W1Zl@\mgfsVff3uC"fpznfao
QX޾9a3: 8tCr`P #Etrh]zsqf  uu  0   ? 0    0     ' ' $~ 
 ~/ %bFk ~C$~ G~ k"uA誨0
sPS_.痕PB
VW x׎Ǎ~Qr&} uBr	:=_^P҉r5#r!r&E@&=ߐu	%#JHr&ߊE$]uT5sB
@>ӆΎޣ ]rưpanrPPDTtr?&e oT
T3
%_:O$S	іЩr# t itct t$Ҍ`ffL ]`0fBh31]
ð˪s@>+Wz  dr8uAI_QY_þL[ r&U`$þAN4>њLCҬ
Pz$X` $2LnBa耰<t;H߀8`8u6
uB& DBlбdt
`a@ 3 r/) r%BϰBJ 
`; 5 aù<t
6BJ @uH` BźI2۬2 ļ'u+BIl&2]ȑ8uS\m ri@e raPv rYkñ~@ tAq>f r2a r-&Ǒ$vQa> Yr	2QkWY}׬B0ǰA'ЀBrF@@
g_fQtAﰑ"p  u
3A t'g&gfǰ G;g&G$<l<f %COMPAQ PC Card SmartReaderlGEMPLUS GPR400lPSCR bqLB REFLEX 20q241 PCMCIAvReflex  v.2Tc!r$HPٻ  a@g&O Gd uAq`fPȳ0rLf{K  "Br>qPG	 .Da
qPO@.d.Df.4fƱ_ 0W QfV0#
G.g&:uG`f^Y.5{_'0`"߶F`ffWr@P׀gH
 f#G f_d=          VQ    P`@`;t
YY ^NV^$TBL$PCI    P  $CLM"    4$fptqfPfSfQfRf3f f3fg.}	/ 	@ 2 	fƀnuo 	nZfYf[fXpWUu
  	3`r]aq #6CERXYgc> 2Q`ް(Yùm `ù DaV  .:u.n!^$l	f_Q8aY!fQRfCPt
' "`
Pv
"O2ɵ PZ t"
ǆmWPfP  ؊2fl 2QW pw	tv2Y$_Yôq3f@
%S~` [Pp 0X.
tÀu@u[Pf
4 	g*f8 *a,Rff~%fؐ..+.;w
Z
$Ue <u
`V`<12a2@`|<z@=q<@]Q4f<	@}4[<
@4P<u@4E<@=p:<
A47/f= uffX<@7<@7]]fW f_2pPuf_QRfVfWSft,fff ^r!fp;tftfN77  +[ff_f^ZY^>с 	 r?prf r ;u*A
`A0BBC= @	ҠH sQ;tp_r"R{ fRO fZ z,X
[2JKLLLLVJLHM	NKL .PffqM PMLNKqSR RLqSfMUPKcWbqSLZXV>YPsZ_cW+ P[SfT^RXMf s#(` sf t` s	a t
 `QVWf&? f&bﴉ3.fSP&Gf&_fXf[ ` }`5 _^YSQR@>fPw&fd P g f;t
fXRv39W
ffff_fBfEff#tk f_TCM!p߀MQWfu`# P"f UI8s2ہs
Z*SfW`@)6-y`t#uP{aHXt}xPC[PSf<t; /30e ts
Hfu
utǳ%[`3}aPZfvl`_X1e'$PIR   8 39t0 $@ (!H   XF )0*  	 
`%UPWffp,"͆. 
2:_nPnf
f aOVW贠H#gSikW2;_t[lPmF[_^ð` @ p@WVpfHW ;2fA	f2f.f@fGfYfy^PC
XPS fS[s$fR
wf_fX$s[`fCRР%D Ð[AfS22Er'}z} uf8s֊Ҋ
 XQ iRP
_t0r?C#bE?E  uf 0úM % UPfPBTZ훱]fa_f]rffr%m?&On訡&Sq f@ yv` @D 蘀  @L ' AN@pUVPA_
!,= srs2
誱_ 	f^ i
w t;kp-rß*f0mk 	w:"Av *)ur6	z"+	f;򱛹 f{ 	BgRfPQNNO(aa 	rO	ðc
]

#/Vـ^/ f.RfJ迠HZRUQf fuffVfK蝠Hr=XfuNVFYQku F{MuY ^Y]9g><afPRg'QSVfNVFfL$H^[YrfXftA/3PX|`ڸM2NOPhUWV} spP  ֡ ^_]`phWUSq!蕪㋡ ]BpXRV 	^VcC  	? _? _?  _?	 _

? _?__32_  rQ%`S
[PS3
[
u		X 
0R@ø
 ô	u
 tw}P#ۚhsɄ3ǚrÊñap%3t_ (30K"* YfPAMSho_^ap%3&Xkb,f+WP_@,fppw h؃ un0 MB RW p$u! D   &FGvuv p c$u#' 3 &P7
;u
a70f37 |fuɲ8	&( 3_3GF< u< u?2Dp%P2Xð =NuBq$=,u0P ff A AXh}՚I HB"pB
qq$-w4"r.-U`Du4 $
Ǌ@EN]Dr؊*fQifS hZ@qy؉0hQ  `  fۻI  fHJ pJpnyl f`qy rMf[q$5f 0Pf%O;t`ϐf0MnfX2*_@{x `[ú&ATST0SUXfvIp`d fw@u觙
f<I~Ҡ`PJef%
 Uy|[D[pZRYBI_Y35Z'CZ\]g9
 ݙ`fftpy" QB[Yдffhfa`RWfGa03ff¡tf Ou YWry12tp 4g tc%˻ʆ hrQ L G B = 8 3 . 0ȷ$     ; _Q&GYðwat
t0<[t = s0cVfP SQP28Y[$
P藆	fFf 
tN 8tS~PFtjpOp fu t0 | |"} tr} t	C|xVaRVY sZ  Zñum
vwcw$gy4 q$Nuff`4eApu4fakFD@2@ZtfFP;^DF} s u
fWz !#ufwF$"~F(b|'F,]0RrB}rf-ޡ}fv,v0hfN,-Pgvu(UX($иP@N$fFfV fNu2N t
ffFDl 9Nжc pN xf`:`0q#f#ff 0fHfVPf#f@f+¿f;FLvLfFPf)FLBŹɊ0fpvfQI۠pOp Bwf*s!fLff@0ONpoXfUG }PfA!0;V_t
fAPĳ0c P f%]" P`]L@"	 "ؖWF`]0.~Fr@ eP.WPߒ j9`yf_. SӶt1u	葑QY 
n[_ZYXS賩,#QBi ΁߀@;@_Y[`!0û  
 0M 0
 @p@Üۨ!8 ! PRZc@y+L 0@õ谖%s36;3@ɳXrUfQfP3˃P  P] USP#X[t>#<!crh& .]:uESxŻN
߸y L55vΰγSz ųL{[ų ~ vų n[3r@CNŐpt'$$
Ȱ5!
ȷPMq+\rP)?uX-;r@qU?ȋȻpcr, b+f݋f ccr ``/t#s!SP	0XP rX[t< M u`$߃u~`u 
ڠ/?oh rxtu	qtP<Xs<tw@`kfS˸'u[Ô " % 4 C a p  SRWP<  2.J  .  `/u`   
 ۠ Kk^^K s@Q@ = @ G鯏 @@`|y rt&roMjrey r` [rVj rQ rL rG  =t r8 r3 .r) nr$[ ra I r
 rl>Zs_Z[ up	><t<
uЈ5u
XXRX
	u>t, $t-<v<uP<r<
wPր-t	w	
P& gʐj
>?
t	P`>| HzU	ppRt.!]!!""&&Q""#P##rf%!OUCES	H  ufuf#sfVXRQ<t2f3r6@+;fu g> tX r `R	Yh[f^U %!"f'##C$Q$-p%,&pgx)tt
JQr2cfX8.J)`/m/ #+0 6.8.-<t( $r!fQ#_ t $c90&(41- 5̕6N7`+i7Xf f#etP tu
 ?u$u totjP2)Xr`RH  :GfZ3Az{@I$
Ê FNǰ,9$tpGHǴqZa8bÿfVQ! R#fF Yf^ FFǷ  C!K$F_2bL$LGƷ@`LL$ߒF{#N0NS ,)fX@	ش  [PఽfV~W _IW
t<5t^Јfpsr0f^0r_P0QRV`û fpWFK Yf 1\8uq^~iVI.\GF< u^_QR׺krD.߉\ZSRǊ`@	``@lȊ`@b [ȰNOeeeOCi?efY?gfifhS؀u
PCɂkTktPZ PriOX Ffnrf@kjjl~@fX( qf?NOjqqiqnqlqpWp``VW߀uh_wZwU
uQ+0Et>+ r2
tH^w r $VW Q0& $1y  $ 
Or_^m``2
uC@Br>rijfFfnBBrt~,Br?G 3b|/Ar*}Ar
ЀAr dLsrfA
?t  
 ~+ ?+   t3\}\euf\o$VAr:WAmq? U󳠹_S0 $@} $O $G!{q{C|RPXZ*'s3`
N&A ju ,ltgR't$<st?uP,'<ta'6FPF@ XFᘡ3tĀuC2F <r0pW"5t 'ﴗ+}+`uGv <t] <'wVu~	$<s?<wP<'s*1a߃f ^YNuE 8u| w&|up tf~ tBǢ BPi tEa^ t=0ҭ t.ܡ g-@uprP G F 2vm,@X'u`/ PFF P qp0utz襃
YA` $S ^Qb2fT 
  @$,@3ۊ^Ð``tMN? ntB艿s$ _*!*
BȊJ @t212g3dbR9 Zð 'PV
rWrO'0ð Ë tt	@u Ê
tw z S3`δ@`Rq $ G
& Zt
u&àBt'P
!&C 0tĞ' @@, û@ P/j >N w1 r
?u qpW^<ۋ u'' t	3r u^pW ݗ`:(6si
u`˰۠ )뱳2 <RD˿tkЖ׫XEPKP?T} <`Ps /Vfi ttD?hR 5wI+. u۲rPt~PtP<t~ {S8't
 [lucs 8tKTu<tB >u3|$
03q u)00n  1ǻ
 3F$OP3Ҏ¿x ȫXË08 Xa t}ø`؎i &g +Vpa `U
u
f_N@ `]ϰ2su S\8&&G &G&G  [ 0k!   P`\&\p`UF0 ]../3 и( и}@  Z}P C@`	XWP`Щ3t u*O $_H
! & ^X _@P0ǺXb$a   o =RR
4fXufQ~fYgH I[ <Ȏ3]Ou `12{fPS=Au@u;Áp u39 u+PC?wufP@u@Xu
_ff [fX-%{A1{N	{S{0{&o{0/{"{#ؒ{_=X{$$$$K{ !ꣁ 3ɍ6F.L.:Ls&34.D ,.L-s?` '(rZ-`B+'`J'}'m1.u K߃bU^z.' 3t0/t
t
u! \߅tpޱ3u ԡ tA/>G. .G u}h8ͳ%9Ā9 ߴJWc8}uLW < u3p<uv7bf<_tURQ/nb8U 0R0YZ6	u>^
x.D t+Bt#V'L^ 
q.Lr ']~+ Q3@ |PYs. u&	 t	&Uu" ώǍ>I |  Êc.f.|fX@ tM .|1K߿IW\MÃNNPQW 3ۍ}F._YXfVfWf fRfpf[f_f^GSRGof;t0}pTTf`Ȁt  s ( uf tr  Xu
 qfaUQ`SU @\E] < t 
`ￂ)݂pWY]ðvG0PQRbSfv u
ˀtuP20H ^~_{~TZYX`hSa0d\crgf5WTf`^X t@y
  Q	`k Fq^`tjvk(Skk@_fa`aS a]Ӂ hhNff3u
$YTiPS`S  f3g!fFpWTXosSS4p@^^^_gfffۋڰx^!q<TveffPQwLw!hqTYzSRW*׿OзIr 2 Cw3_Z[~Q\~ԴQs9@  Y\~Q r3Ov`3A RQWSP ~$߁X߅ Q"_vYP3lq "|sX Jq	uGvX( V_ m ׈P[_YZÃU2<UuXupDYJBB`T{rĊ0!u5qPPu؎bXS`
u	 ؿ ت *êVWQP Dt!WQ :t
Tu8v
Y_߃ԐY_XY_^Ça@  Xtju3pqt$t;73s.t;i;f man;T?߀tOx;tGs;B@t9t5F  F]0!
  MP{u<IrˌN.TV
 )cu
pr.2^.lnL}N0op?pYXnV pŇ	'O	O"O<$OIn<V	cuL rx^0<u.;Ttqt <tRZzQH<} _e3R3[R0 ZuPue9
@^(4ų .`C|`3Ake	PXA''tOTVO"2/QIpLcL OHkM `#@V`T t`<u
 @&   >q@t]AAuͿAP@u  ,Q& XV1  0`O  r
 P<Fu uVs	 ̀u~AcP3u	 X雉 tG`6u6FtE`uUQrPRtKxGbt& 0R] Z3u$Duh
 2 h
XuhX&  U au@ ϑY@3؝6drćr
蕊rr& d P dXP  $& 8t`jP Q@juS^ ``՘p0Ű`*S: e SP @`鿨@XQDpdYWSqSt+ 1ǿ> &=$R&}F}I1@07 3 uU~~~Ȱ~0Trl`Ua"0"i`gSf ff`Xf@ k 
pXQp XHAX?[%fFp $ f&|  |3u9Of@o !Ip fr >u] (A/ X p`胝 rTqT[sQfV 3&=UtZ$,yf   f  g&Ng&qX}y
E
~ &ufރf&&ǿ À0 \f^vSUh &]S^ ][s&u`Df&D Vf1L
^Ɛy v  ` u,0b m!=$ `Na+Ё$?aqځ j@& r-0$^u ` 
" ;u.uA3Sp  $
u[qu:
t5<u
.uA u'3].8xAtCS  $[
óa# ؃."[ô` ab u ppI $
NZ'ttm5#
P'P  p  ut [ЀuXR2 B8 Z@,& B(,PX.ۀ..pQ#簻/A0SR 0t񠞹$ +踻ZP20Q|3ҳ m~4`P_ЊOb$3F4W  V35K5(U6+6jw@ Y PS6芽'1[Xu	砠&A 
taÊF Y=@ N
F&? 
ĺࠋ?0@@r#}&\
~tC`(8sjQ jujB@YÊE *F&d_ؠFG!HGG@At`1@
j&>  $> 0jLy2ø fF O؊恋OPÊ~
~+~%jp+ >_A  tAS	0uYUl:ug6Qπ U!U U緃VFF A$t#`* U שu B tiG]A=>  \\Q\"\pl\Q^]\_\Ob  lFpoypOIEMAG  IZ P?  db 	

 [ @`gHDA-L  HDBh'A-EhiCihUSB-FLkCDkHkLS Intnl  PCI-`SAmB#mC  % _eOn_nnnnn	nP 	/@t<M o"G uctg/GtFt<Qu	IG F` @ Gx ?GCD001EL TORITO SPECIFICATIONB`?{q.F0  `3辣$ǣUu ހ?t0+aÍ>mF.}
t"	
t>E .:UtV	 V tVRZq|0u-$<t"u}SAu^^ Q} | Ys3䆡+ uo آR_0ks2t*R"!?.u 3ێێZ
t	 "uuq 舢
 9@ZWu9cQ
^оsuGQP@s4XPt)A&ߎU``␲M}a
[u !u~$PnP!J 'J J  \{fPff  @ fXtfUf]P02tg]`rfw q@rd^fX]ge333]rVd4Ad^;sgu0
30s M ptAt<Vr0dDg}
^PᬋVWd_^gEdTg}z
}gE Ptr00t}d8tPW<ytQF@Drb0fU@f]3
t Q D0 Ó' ^.;Gt._
upfg6$+' +kÑ#1dmrP0fdjfrdj񩠩+ dMd5p
Vdmd<d;]ttd|dp^UP~vЎF`^br ~vFUn ]~ 
 X 3
'@-'`ɿ F`ɵpF/L3 .;v+GuBG
pF/{p Ë% 	`XvNϋQ
 ̀0ʕNY%'`0123456789ABCDEFSۻM׆[)ONNN  A " * Gxx  x y 1? " *
Hxx 0e޼ %3 ݷ |$+8y y 6 é uTE ذE
Uʿ`
 rZ  t
rpPxf`ti20(tW &  q&E3ҀtB&U
&]&E  t0û/OHu0}f&EP0!{fa (88ܰpP33û w MZNPR$MHNZ3VW8 M"(N_^$f` ;tPS}a`[XfpWU t6;u+f f 0Mff#M]_YPR10QRW$ ߰ "
 $tu_ZYQQ YP
d <ta
`Ld V 
Rg
	軤c
#	;
 

`u%<]Pg
gl"*578F'()+7>  v5u t
&  `
x_t^t]t\7uQstFR53< v
<ar5<{s1$:qPɎQYXuôr2Ѿarw9@62%9a uk#G$#u#@t<zw, 닐tS	 `t
w
#sab2]aqS%J, E$'G@<'2a)P
 翑Q ` t߀rr	0&21vPQFs	} "	>EYX p`SB C STTTTSSg]jȊJ tJQ3J 6N]!
OS* u^S!JYp:: P;SQ>Ju5MôuR% Mrq=<>Y3ɸ  3Y[fSRVǈ&
JǸXYmYVY<|tt#Cꪸ>X
J`nXƝ< t3^ZX迪MVr}X<Cu ?AX`rh?- ZqXH I߸ @J4_r?qKuƉJJJRNPt/w*VRރ|   t.LUZ^XUUUU-V|VP .VBBBX$JJ2JB <PQܰ@jtJ bXuVY`@SQWV tA&q JZ } ~C@q\u*[uP9\= ]Xruŀ̀!	0Z`@V ޒ (8SQ2<

2(V.
$T2RUVtV`@<w`
u WP	  ` 0     U uP0Xd]<t r
t!d8D^u!RWuh__snlT^u` `|&
yt,ـt&M1&G&aw`y`lćqTrLAAANa+u 2ళȃt
 y!zy܈$FKuðWQqu	ۍY;Y_,|uA}}S؀upu)虓4 ?  [YXU`(<sW .7X_. xÄz`P Xs0׃eQT.u..&+.	=@ t^P.&u @ u42.. `_w`5*l*Đlb&u XY3!|P A3.{Gz
X}P£ *.ґȎvp`p @Sf3[ffÊ$Rf
f`X$ИG@afffߋ6RÙ%  @ffGfPRWS22f  r3	 Cu C8s܊[_ZQQWRfP
t)AEr Cff  u qC8ufXZ_fY1^C4 v0>C
tfCtTCWQ3KCr Y_y['[5[[b  :c` Gp "W *p0fqaجɭ0լPAbYoK]PNO 
"y"U{
B aBRQd o̺ RYU jZ"YPQRM蓒u6 SaԀa$8u P& 砂Z3P= u4@Q 4S<Yu1<u
 uuuu@	uku=fROcа@P_u5|?QY]7]E].]%St3v"7X΄qaR5_rD`P!L9^Ķ+d А- v"g 7á8i"6F}D!  7~[gu?IsU ImFFݹ  
$&&EP
qEAPPFˍU?DK>]>}&ۅJ  J K lS S V  V3V  U	 Y
 V V@@4VBC  KP LQ VR LS VT  7LU ;LV ?LUWXYZU[\]^_  ]` ]a ]b h^c ^def GlijM\ZScWfVSQfqVF! _Ys^(2۹  FF  +^D!8u} p^WVQCuK3`ذF!0w^$I^:u:\!u$ Xr:YA`Ԇf^Y[_S8`mF.lذÀu@u[PSط$0<:rd uꝾ` տPPH- 1P=02	& SV: fgfFf^GRyZÜSt	tv

vt[؎ qڋhaCQ.FF.:$0Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSfVU2Quh66t u3N@f6 Vk6u^  uf6u:6 N\  Shb6tEQ#6u6_@$uf6t!I6!/
D@$L ?
]]f^QSWf!u/ r)v t!ufPs :fXtq*_[YfSf<t};3fP4 t	f.:Шu
utǳf3fmf[u
 Q/aC,GWWWWi	     4 P. .  GN N6c c  Ge e7g g  	Gt tPRG 7   GppiG7 G6";`5 <p= yy ">| %>L?>?BB/CEoEGfPS{ ػ@`f.d;eOC:I.dfJ`TuhW 2 hM 9uhMaúB  O$
HÜ.dϻ f`X D 8ffty  Qf39Yo,VU8V U8AT8 8Y 8U%WwV+WzrXX8fam}t Vuۅ mVIx 拔 tcPtz#>#KXSQx$PXr$+IaaWuaaP"!Q$
BBHJJQa4HX^pϹU`JFMFOFfFgNhphfdgyF`RfPPHlQfl>f6m׸@@FYrp_f0f`I ӊ0RG۸0۝\VRkѳ0tYo抿ʋZ^״0۵ ppT$
sttE$
J۰H,k_.k ucmf3gf& Jf=SCAFtVzG t"ffff zWuf(|}|tfPf%Eo oBǍuBf=   s:9E
tfÍfmff arE> t S`W,f 3f9uP1I^^w&t$u%G&uFttJ]` ( 苍P䠄t"
   @_u! !t` &k XQR3Ɇ@ 
tw ZYJB<t$ AJBfB `ÁUUuf%   f   4Йuˑ`Pց
Xu!P<Xu @Pqta`
  Px=@Pxk NNO 
Ef Qr1Or	S`tg ji &  _
@_d _Mŝa3o	4" 2>  _SM_ PDMI_ >o  #GCOMPAQG ϱ/Oo Ϻ/Oo /Oo ʯ/Oo ӯ/Oo ܯ/Oo /Oo /Oo /Oo  /Oo 	
/Oo /Oo  /!O"o# $%&')/*O+o, -./02/3O4o5 6789;/<O=o> ?@ABD/EOFoG HIJKM/NOOoP QRSTV/WOXoY Z[\]_/`Oaob cdefh/iOjok lmnoq/rOsot uvwxz/{O|o} ~π/Oo ω/Oo ϒ/Oo ϛ/Oo Ϥ/Oo ϭ/Oo ϶/Oo Ͽ/Oo Ư/Oo ϯ/Oo د/Oo /Oo /Oo /OomF<`Шۨ       
3f_evxgӀqbńD
 uj@ t%v v t ArMv .=sN-f-&A F'N- aύ6E @ t3
tr r	
F (|r
	u^'Òt %?W	xQ*1trz`/5rr[Qo
u< r<0s<"N@` \o1u'`$nv`f<0r
sujs>\G.u.
I.
MȎ.w}u tj@&u |t
p! ^!N%V#!~F܀2r2y%ss 6< s
	OtE""Lt*$Ot"#Ot%2( 2)A *$.EF2d$!r]RsHs1I9 <$u2t1*<#1"< u1<v<%ސ12 Uu
F!UF% 4F~&=r&}v&fP&Mf&E&}CߋfX s&t&^Ë^6G3܋F'6;rfg	DEbPQ~(LuTMs fPf-}39r1>GG.  -.GTώǿI 蓗	./40.3V#:Ttt<~'t9r0[AEE&G!
DDH%H5O8&~076G Du0JfPfS8f.Gf&]f@90A[QA6'6QK  Kr}]KrxtKrlKrd|tZ+ٿr@ u~ (um-VƎދo^ @TtfUfUfmKruFr Y<Kr)2r$]/KrJrRVKrdNK Y~P
 >r>w
u ?fSfRW ـ?f.Effff`Ucaffs<  MF F
]tSuNff3ffVGf.Wb*f8f'w*f'F'*2t*f
VvfVvF_fZQNFsQU n E]YRPXtUW:>WL_]sUr  NZòmPRL2B`q`qĿZXQR`Uً `
o^ZYPpB0rSQRAP syI m ?  Uv H}]txv`d Z^Nzdv t JIr{| rv= %>G= !G1S>G KA, s,5<s-GO8LpE
t" >GߊG<1#w<1$~0VGZY[tPqmX wx k waHrzGruQHri8`NvHrWu
pp%ع{ {qMHr.Ǵt%ttt t	tcDa% suGrG	 2PtReZF sH<t<)t<(u;>A u/WU>5 I]_ޣ5Gr@Ga`@-Œ`^aPp0rPSR 2?Z[@pRFtN+P{X1dX	F
+3TU XXF
t
 
`{NXfS~ t=~^f~^^~j^~FF
1dFFF f[fQ
tW 8ؿvNa^~nNfnNfˈNnfNnĲ~*Ċ^
^mqdfY SQ_fPv j 8rCЈsfZRfXfPtFfjFaVv5dfXr+t aa3kp tff    af+ kYÀLVu$`UΎށJ2Gt
.v	?^Pp fF! PX0r t<"u<"tNV3޾x 4|Q&?ws@ s&  &GG
  P&O &OPLR af&GQa a AM8Waaaa׃ Wc  kX<sQVWA:W 7wtN7uu .G67 u/ ?	
͒ t,6o!OGA&&d&D&t&DJ_^YXV!
]HA}"pu`̀G
߰ F^ð4&^ ^# /ݵSQuP T$@PΊXuBߧT@Q߮TTXUT$^sT8tu
W9$
,RVWf1.1Vtf cQ <VV <WU  Ѷ T `aύf˰>ðǍf@6̖s >ύup|f2_>f쁀`Jf fdOfr.> u# RQu u
[_+^Z0.!Nq%pQWVV_ ؾJ^_Yñ>{5S. u  R؀ˀRuYu	qc3r
+[Uf@ot r	%.1]ô&&U v rDVGG5AC^GCݕG&G\C@?ܥt	߅	k9CMaGW7A_KޓUwaߗ߁&߲pmܛJpSGA&Tp	,?@	fWsA1< ufk,u#zk{ f3g8ff=SCAF%fo_U2 	<! F ]tW  Q<w&< t'V3ɊȈ[CFQ^ t	meN_sVV<vg^.BQ; ؋PBPs 2DC]þUrP Xs.V O&]DD&!&Q&~@9&'D7%8___P8Qp)@Q70&袏''
-ʏ!4`;v,,a'B(#&Qlr7t'$r-S"X*p O1O0OO["2ɵ"KYHP |4SIMPLOy4MOTOROLAw4U~s1  ~ЎHrP Ĺ
J&?s48 <W~9W:L;ɐ!7VPq@8VS89~;ˇ:J8s˻ʆ : >ŷʂ> ﷍PE"ŷPE$ŷPE&ŷPE(ŷSt(&
 3-&Z[>*ŷ|PE,ŷs"H1_ŷhPE1HAJH t
 8+؋KsI.ŷ6PE3ŷ-~PE5ŷ$PE7ŷPE9ŷPELş	L&3&M<S`Mt?6iPw6{S
6WS^V"<&AC}?O5B9زB9C*WDeEo>UgEf [i!F] [UkFT [mAGK [-oGB1HoHIUqI! [sqJ]Ux!K
 [xKs/LCMasIuANۀ>zN@d|aOɪ@d~O@dPJ@dQ QR
5SS+CTei0TQUei
:>`&~X^`?@ 2p n l lm nƾm # PدTTȰT2Ҩtð
Tt,oTTxTpcT$ztpbTøKT
auTT;Tа4o	-Qp2&ps s	2 #T | T
T{0sT	s[SpSt{RuS2tSpS tN :4{0sSsStS
S$Pu
S$潡pS RuR}S$RuS	=}3 1 u1t;6p6 6 13`,=
u
"=

u5w<t<u FQqS $s
Ê& 
 [<uaw\wWQu& ` uO`'\&aֲᎿY6 FF';Іt@2?vPF X ꏙ pqDPu◰ }q	t 
t	u%߰  mؾg ,2OtՕ   ?H.Ft6} H<u@2Hhf 2 hʃJO,t&s@\1A՜㞡Wis
t% {s
2"  |  c .Dt.D
u0`` 3&&D aø0 ` j 
`I&EЩ H3Լ{h  AGQP!AAXY}`.\.TώǍ>I.L `蛀a.D`虀aQPPXXɎ6a̛؛囐	r*.mfdAz/GPAz4GX$#PuGPcdvd
PzNAzF$B3cr25W[OAzFҸAz;F:XpPzFa!9dP 2XPUv FpF !Ff ]XbX
ϱ7f  ~<0 u<0 l<0c<0%Z<	~0?Q<
0YH<0?<06<
0-P= PߎX<0<0/<p0|]WfPCI 2 )Ju_fQfSt$fRr f;ttN紃)" f[ٿ_^fZfYff !r  f up
NPIu00I sͳ0 2SRPۻR註ZȝXZ[ڸۅZлtܼfq۔aPAXZ被ffuڊc0ZW{[ڋ@
ZXF*fOfP' s"s t s t QVW&= & s 0&EfX Z _^YWPwﾐ;t
X2 *W 
 $_ #tYX PN sRQmуuf C fPff Üff 8s2fˁYZ 
CwzVS3 .:ğu.şKu0"[^* 7Fw.2t?SF  3Sѷ͟F[C3N[v QF ?tٲٟsF2䀕~pY7A` _`8)d)d`q蹝	艷)`P	)	通`$ $%	*P'@-TO OYe$	!L !\G\G|xpƢ*S|eޣ.CWmF.}
:u{tLpu%vt>JrSG.[tG.[u pwtp	xt_M_EfUv"%v t Ar"Mw Ŏ.V PXF
Xf]h@ &A ϴ2j@&p& nu\ôV(c ((=VG}.6y,{.q.I.
Lj@s& `-|/u &^SV+D.d.$ʋд^[!(wq(*Ó1c4j4rcOt6	OtOtLtD\Gt
zGtnGthGsy,
{,xu	x.<x.}shੴ% 214ÁUu	U a&SfQRG r2fL?\#`&Zf?@4?2'AfP<r|wfD u
@EufXVWU4uPQ&Br ˿G\G?>yI.>{I:8 ⽉PQHaߋi3HBGݾ&G $@N$PCN&I@N(USN*B>`Ë&g0&G1&׈O2#M$&G QAX][&? ڻaSsH sH@N@NU
 }ff&GfE1WW1Wf-"Wf@N!@N 3WPv޲ ravE./LuRE<sfQ@@M}3@ fYr/>GG.  EG]I u./*&[Üu_QWV._>vu@/0G<tFr =yuQ_.E`e.&G>E`eUee%e5ec-Iu(َᴍ6Gk&^_YSRcct5oËS.]&Gf  Gf&_f&_@ f[fY2FZ[fUf,Sf]貈@u  8 D }ɀTp+eTr 4PtPQYX߰q)D
q$,Du NORP;XZP <u
XPжs귄3ɺ] |.
X `s.safV`f Ч !p>r"s   	 1af^ `Ч*߃2Ұ$ԉNT@~WpF$
&FG&U_uV 	 @#a 3 PV <^XmrsCsE SQW  '_!FT7UqE@ pm ytpXH Q Y3ɃdtA<u 6& dnC-1@ܔ2]u濔!F
(<Pd5bKPu&XW<ru .{_Swt 
' t 迃r
5ae u0^r!<uw	r@2 @&΀Zs" r2.t`& ?r&>As  rP I8 r && rr	&ô Ss+&' @>' @s$sQ
u>[ W r% $ r r}ȑ	i fд" $ Ы&QހPpX uót s@t	`('pt"
@uqYÜP`
 Xr`QP	tX_dYQPpPx tg	`FXd$!<!tDA_>@tPGX	fUfPPZ汻;f]qfŝf]rPm  |nPAW @ J @QЍ]}f  BٿL  xBN BPa_AXa{{ݽA*qAwAݰJR/@PFP%]X `j j !v
u)Mf.N. tI F ~rpߊ^)̀uw t&Du⭋^^t<a.@t&ڃã.^2pڀ3`6t6^2~.u @ PSFݻ@gp''.:t	tX._P}Q
! ͋͜8  ͑PRS% + ;w[ZXf Zr-s(@tH rr
 rRVvF )r:Gs5&DC H Prfڋy6Q_ AFÉF(t S^$:u [r
F&F$pC%&=vHH&
D&d̠u rcwu
 !πϠ}t&DB êǪ`k T`=q)c  {HUr@~ap1Us!
 -su fq
 E PF 0G )
V N8tr>u rG o!F)r\ A{r=H r8rWsUTspF#@Rr
 T@M
a|`k PF("r#謂Qlr@rk`Pd rF( &d&K}V& %f)&t N.f`O tR͏Z06faVWkPѳ0,܏fXfYދ_^`!(+* 0 pp֏$
ۏttǏ$
ag7gK򍲲,JeEeA72u   树 X& @F$$<r$:u s
jt좌 
   @738  $tVrF.^ࠍ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (P<$<'E<&f$`
ĢF f%P$`BG B<(0ø fF" PXN8NwN o2N?!`GsHOßGHmI|p
 r
sHfQmr77u4fY_b"&&%'Á3^bR&u 05t36rm CEo VQB A9qO90B y^N 4s
3
3u3`Y?QS@Q%uètàt  !5&V&T tcu^
* &u^ô  T> @QPXuN%&:Lr=PQ* r$C`J@uN<upZtQ.@ Àh;o E 77p$<@tgA9Qj9" !$!{wQj|zBoU`>ùgK<P[bз#*E.ÿJ`UQEufVKrK,ugfۉPwNPwVPwFYfu&gfFfff`MuY2f^Yf]Ë: 3R)QSfVffLfTfDfLFf^[YrxXt	A3PXføM"߸NOfSQfVfR@WfP<0t3   fRfZ+,__f]fZq{[PfW t0tQ uUP@XYQfhВ `YXPt
 t$0t t-`|_tXRfVFtf^fZF*TVSQWfw#t r0{ Ԑr	0{ _Y[f^QWVKǑ}^_YÐQЍW2! u[ك!N[P] R Vv 6^N  (b VI>󤀚R a^1{_f`SQV3۬
Ê^Y഻O DЭ;r 2p01fffa[.6fff`;w	rf;waf`f`PS`*. " Eu Цf%4?^ӎoAR0e$''10 +0= <r <3fȐf
ffff   f-  ,|QRW>`[3&G;r_Zള <m  `S\ Q	t[c )exfsC3    )4e f       PSVз-//߻߻/пǻ.u/܃&&^QQ pf`is`@ ŀ @`ifYX4Z4f4fZÀu< uEuPPuǄuZHPPE EPP runtime BIOS - Version 1.1  
 by=b־$0@LX[^wU ."] .wA.uA;的c;لR.uAPBZ@QR] Pj<rt2[U$ !Ȁ
  -h?۸" ZYSUל$/ o[}BuR xuߢ] S5]] .4UV ٬V1	 &n ^_&Wٖl _Z@- u
BJSU@@SR ٞS<rP
 j ?G_ 
t<t  ).>  )\. 
P`R3qAB$ԡ3ɠo@ q  0pFP a & '@M j
 t'  լ ``=' d u_ @@	 K L e l  
 t " `     	=QiHewlett-Packard 68BAS. F.2A 05/07/20046 hh% oJ
 O
^
 
 o@KBCXX.XX 
H `o
# h @  A  ! U10 Intel(R) гQrnal L1 Cache _2 	
   PC CARD-Slot 0  
 32  
	[
en|US|iso8859-1
 `Q Pa&CГ &p DIMM #1
*	,2,- 4@*" 	гhSST49LF0]4P%h
Qi ?`i@2~h S&~h
\8Rf6г~b& P~

@8 QiPrimary_/~;b&MultiBa=>tQi  c0$`QFhw  k
F hr !KEND7hR
	

 J_L	5ddO"_&TJH~}
No bat@ yG"PQ14Qf`C tYӊ|0}ofaQP0P}t|XY t
 0| pp|$
|2j$Wǐ_T*u	 E 
yjt6c)߀uRct&  5& Qc)u&Qcu#ff
AgQcu! 8egff j5hhk(l>l mdRtYpdwvMjuG	jpu<ppu3puOptRcup ts3tAg0>]pZRtpp:u@蜋8*6R:EFful_vEjPg} ,jtTt̀t߀EtHepZ7AvPF )t%> t:& tSu0ZpvEul!3Toqhppoߖ t0z l3vE>I@fu	PXfuP3 tPX,tt#r#l@cpsyuEo wuotp]ot0r)f"lq =uE30 dx3;r.Dv+WdXu4nr32#r*u!.7ð-rhAr	Ss2Ӊ<Gr<SvP Ê,Ga.r]a#rJӑ2 {us
<.rpwLu2fu@lm߉2KC"laFr렐s<.t<+u
0 uθN<-Н" uJ,0r& 
j6 ?;6 opÜ   ad `
d`PQ3`t
sǣPä0Zrdr
`r`P!0!t"Ĩ@  
 ް  XPJXSP@  +. s#. sXP &   &X[çw '7Su!̤# `ur(D
@ vArdHvA.sNfj@&t ߉FNfaR3V.]FZr# M u16Eurj t 2rY@ u v pr&4W&E0|pr"|(pr2|mRs ÆUu
FUF `蛤	pϽ徰-}	ԅďrO	r蟦@eg5	ƌpWp	^F&?s s&  &G&w&GP&OD
 &	GfPfR.Mf.ݷ quE	_ffwE׶ERVfQS/fD[f@  fY^f& u#f&GWfAރ ܉WfZsfX@fF~r  vt7 w/r?@08 u tB t x2frVʀseF	0!]F~t$@t@u/~ǉ~ %NVg`se^Í6G.|uL軼..aF`>E .:UtapeFaOWQS.ن? t0.}u.:Mw#.;]	w.:uwPw.;w	w[Y_@ p]>ـ?r.u|
ՊS ʋ.Ev `fV|fvdǋD؊f
@NP@.eXfȋ.us$
2
{-fXIdDfUv]f^PR-Bê    ZXRPXuUW:>_]sr  ^$<`- r!P@Xu@>~ 	@{<@`P bsXXty>Dd 	 ~> 2qZ   PR9PGP⫑ЪX?rarTrOt :DvL*DA@ umfm@
Нr@l
u2 P%&:Ev&M1&*QE̂oo@НZrFnr;@u"2#u< r
t@r&du
 Zr_ rRXt2 u@uu+ u2	S ذ1PaPQS-67Fǀ8<t߀-7F`/<[D
>X{`D<Ƌ%a`t>;P	 C@@_`4$4Q+r++Ysap߿!$!"桑WPPQȎ@Jr#@Mwq t߸ .12:Tt
  uOuA; i<s& ? t	23` >G}uE  FoF 
 }FmFVWp3f<u^<
uuuHMxIE<I9<t5$S1p[|u |]
|@Ku t\_^FSG}
;uI}	OaJ.iFLMMN܀}OKa`EsGOP
 DRa9F2.QV 3۬P+^YD 4s{SfAff?R^ffJf!
p`=f F PXPfP~~dр=r0&Ew)Efu!ef`fu@Cuo~`aSVM|`|tpht
^[׹+5kX"kػ k/URfQvV ufufYf׹Q =fA<%1 H uQ !apn r.V sfYZ] ^Tf;@mfRff;fZ@m<ptWf!f1Nrf{+ f_fZu>r
vw`rfSup r#v|s
܀,pr
<wf[uzG[{O|wzr/{ruBAvvgwP]XxPAvr P%0tvSOr[ow v{}
zEj{z}Avj_QptPfSdHff[fufXEmt fѕt/+f 啇#fSfѕf3p3fѕ7HX2nwZfYGUUqtU?73ӗt`e֕qfqGkð-b@wľWVP fSP~WB Q Y_W%^neJst/mV! <5u G	F^q;^Zsq.
<5% ^`4JnpQpXf[2P[X^}YɓWfVf  t
P Er&< u  # @rȇ f}^bYô P(gXs 4FU Ѹ?ѸfѸEkP
 , $ tPp3ð) ðmtPSYóu
 VI$
ǊK[ O ($$!E) oĀŰQ32YQ
t
t
=QQoмϯ3ð&+)ӱF!tt	*tEPGQ@S&#"
ǆ*[8  <t<!t
< <*R`PZQRFs	  Z)   VPލvS<û	 [rmX2`^_ð,B`U&ޢ`!B`uĎVfW u؃ tGr
ǙD?! x^ Ef5trU|U|VF9 pZ$H<q<qm^`"pr% F؋@Z 
u XðBQVWP!X_m^ VWmF`2Pd4ð2dÿS  m[otRNBPRp͙XSmtaИ?[n w܉ޞ2 ptʁCa
P['R¼f1ðWRx $PMMo D  `f(C)Copyright Compaquterrporation 1982-2000-All s reserved.	
/
0 m$(,jiwߜ: ø(ø Á(u0C/x+UUu[< Fu~ r]0C`ж}?: hE 2   hv h(J YhB= v O hB8 	$@<@AfRf   譇%p迻f Pv߇g&Zf3fZX0   м  .>  9GʐCĸ@ r dt
t4t ୴p`$掊F2PR=mu_ap5a+XXZXp! / P{X`'ǻ `Ü= srs+
3,,PSp{ _ ߸^ ZY[gQwt.蹐0! /0PY[- uɀ.j.b{;a/PQN0[ K 0@W'  A G_ y 8P8 y " Eu t
#rrs`tW  d_?'sa??_@ABC WпWWW18 p9@ ?@  "`:FzD-18 F~G HA *P9	G%~18	  p9` `  8d d L"F18  Fa a| LF Fp p  Gwr r"Ls sL
OrEcN H"  M
rN +O6bS pN	K
tX0tX Fci0,}`d$!<!uy$ $`& t"&& x<u&  Vpor^@K^D]8t( 2]']233.f>"P."  栿 a0b2ۊ( ҊȰe) ǊȊ&) "f* 븊o*g>+CfgPhf>,3gPh.- |gi) rAji..jijPgR=;DK   F  0Q Q"FP3qm>18   "@ *T GOsuy d,oT é uoF:tE
M{v;$n@<{o< $nr<2pf<3Wo$ a=>&]~&E &E̻ ~
b>	ofa3y  SQq $Nx<t.1u
<v<s<3vp 3 N^mXVSPoX[uWp !^Qu*Y<u,f ISGu%f» f f f`"2 .2Ê$uUuﴀ\ S3ێۻr?43 6w f>$SMMu>X P dPu
@ XFSr 4ras\2&D
V &DH  
B r!`ruEF.w26$D%rOsJɪڙK Û$?rr
jryϞZ @FFtN fF" pBB@F(	r2BB2~ tp]{  t3ҸK3  ;wu;sbFVFF"F
 F)Ў@r4F$
F+ F p  !VPXVP"a?WPR!u{@ZX_à'AtZX+p$q,.3۹ 3Ҵ`&./@3Pƀnuo0nC/pþCC8Ed:+~)*;UWVRQSP36x $@ fFfsEYcP,ߨXu 
<t<$<  f?"<w<vr,2bߗ? ?&\@ N [[YZ^_]<u9<u` taaU< Z=roP`tNð
2
t
08uEWÀ>A`cA	tYW
u'q &L HWsƨu	VuQ2^ 
?W~?~?@كu B VtG?&A J
辵;y2aea>'u$<s'?
V2f 	.c u-QطM`
~q?`t
тܒUd UtP> u pN> u^=G t$p<pupuk@UD='FO 8tWG>s>=j>_ u33 	t<uS<[u8s{":H@>50$> pd XϷ= P=B st2 	=3u
辿KuT&> 8%Tv|==3~uk= f= aV\=5SRM=HC=p/n_SYSID_  1^Y _UU!fl f@f= f3p fl PSS"
ǆZQ2KᆷMa/`;u.|

P!2	ѶR;tSR@ ڊZ[`Z[T`|g uH

؊Ȁt, s0zPir!W
yZ09;uW|=u2	fYeRذfPVeO`
B
f6p1?@MSsVU:xQf
K1fQ? Rt%dxd^pW:u=/u8|	
ً@#2|> $uP$SUR!
:u<8u7Gt eQ)ސ#5 $.tmʠ Zu]Gp5XU!~+sQ ]?`K:%+Kx,Q,Q3ɐ-Yy|M -M>r}Q-4Ys.`e
$-9 3Z[x Fp<75,u6ݸpٸG 5u6:L @;K 5V4 :N<=M >s6)
7
@2'S C8BBaaa$at@0 GUĀfFɷ͋N
~E F Nu3 I'JȷInJJ ]
 HRQP~XÊܹ HFFYNZ2PAP$NQȴͿY`࿤Q aÇً t"ԃ0 & GU.&a'@'WQR{0 ZCVw
 | Z  X@O` XYZ
U 
P  S{r{ = ufh   XX؋7w[	R6 ^   _ /_Q@P^y
pS_ 	c`rssae `
hUЋ؎c]Fa^WD3<0zA0xa_`P *Pjch[hioPN\$Y9SR^Z[` $<u 3 0ؾ   fǥaq!r3rrSo cַqc}`wPwVQm3ɱjAY^` 
aËpR0ጱtf
f3fRAыf;v+RTTYX0GY@_ÜPUfWf@XиMfW#]#f_ff_]XÁՐ`*U1.:f{'92u9.V.f] $PIR   8 {3>0 9@ 9  =9H   6X ){(  	 
`zAlW8 s".0
Τ_ϊͻ 㯺쁦ѐaVWS;t0t%[ 
DHt[_^  @ Ў@PQRWfV3ҿH 0Qƣ. ЊUGY݋f^_ZYRV.  3ۍ6.^] r
R3҄  tZ~~~~l|8 8|r8|8a|ç|  << p  <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>P~~<Ыff f { >c8ll8x~~® @ 0``0$ff$ vxx00 0 lllllPl 0|x0f 8l8vv ``0```0  0|<<f0p g0  || 0p0` x8`̣<l 8`; Ppx|p`aRp Q|x0 ff|ff@೐lЫl bhxhb3`2f>  ``x pflxlf bf  8ll8`x|Ɓxpcʀ3x0 `̀@ͱ`x ƌ2zx``x  xx70x|``1pA]8l`vQ`lvf0 Qx  `QRځ  aAG   bvfҷ 0|004A!0ᶀԀP0d 00001qP v! uHf SvN .B2[]`'
fpx>@  t@&? ZYfXπJiJiThJiWJieMAY9Y.GnSS  (B03P2X`3Ҁp ĀuPNP<tDwtQ_Yppr8rr
2:6 vZp gaPkXf PCI01 ISAA BS03COMPAQꊙ 05/07/04   
  s     ˸ @؎&м  : r' W@ P& u_SV  GG0G hv  8 Gu 6u t3  hc) 
h+rt & ^[SO
&hre
g[U샿VW ƿF F   `Ai 2 FD2ED2E
2E2E 2 @D(2E($
f&EvPZXuf!tE/e.a	 ƅ @-<t	db>t <tjjjj3P R.wj5Jp$<t.<@t$t = ;t= D hUru 揿  7bFF~ t#^FLr
F Fa(U(~ wt:]''jf
 h\r*F)'2(~ t
)F_^Qd!
hRs .&4/udu  ߷ hr$?ط2hlRhUC4.Ch/
 qrf   f  f   gf&Q6..  1w  Y`WVe1E0&E.&WV .^_UUna<Qc< 	`@.e1E0eE'E.U s߲ Cm2a h
$ǈe Du
g$Q
a3QCr  utw
t1w
tAPSQW33۹ G&./JNK_Y[X MMMc1 @  @ w @MpM dB FO MMxsMURMMd* %  <!TXMC  3Y[MQVWh5:u% p uK!__)  | = <tka;P09@9_^Y!JRW`  Ê e
Crr3ɺ Ae܋
AB rN_ _ZMSqe Y
yuji=jjU jj%1 DE<@!p;<<!p<3u """jvka#t
#m[VfPfSfQ f_3f3PXfffDDG(	Dh fYf[fX^u 0gO GxQR@<3ۊED 	 C;~ҋG$B i#u fDf3ۋfË\py
C{  	T U S V :	N	b	v		`h	Ph	  h:	 hN	 hb	 hv	 h	 av.L.< t)F.6P3.PF.h+[+V.P.^̋] TF. P~.h+Xhr QR  16W  o0"XѐYѐZА#[  
\qaq_RA]cdR'^b`i efgh qp10GҘpppQWĀ> t		 u		.	_c   O idJһ -wg~C.e
/Se
@ mOnxo7`L3۸ E _F^FiQRrPS(m[XhaQDЍqڋh
s            ?_ 	?
_
 ?_ ?_  !"$?%_&'( )*+-?._/01 2346?7_89: ;<=??@_ABC DEFH?I_JKL MNOQ?R_STU VWXZ?[_\]^ _`ac?d_efg hijl?m_nop qrsu?v_wxy z{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_ ߱?_ ߺ?_ ?_ɟ ?_ҟ ?_۟ ?_ ?_ ?_ ?_  ?_	 
?_ ?_  ?!_"#$ %&')?*_+,- ./02?3_456 789;?<_=>? @ABD?E_FGH IJKM?N_OPQ RSTV?W_XYZ [\]_?`_abc defh?i_jkl mnoq?r_stu vwxz?{_|}~ ߀?_ ߉?_ ߒ?_ ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ş ?_Ο ?_ן ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_  !"#%?&_'() *+,.?/_012 3457?8_9:; <=>@?A_BCD EFGI?J_KLM NOPR?S_TUV WXY[?\_]^_ `abd?e_fgh ijkm?n_opq rstv?w_xyz {|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ?_ʟ ?_ӟ ?_ܟ ?_ ?_ ?_?_ p prq /Oo\p0px	@	G  
&HKOouPWBX@p_C`PpgDh`poDpwDxDDO  O 07U8?)!" #@$% &Ps'V(0' ((0(*@(*P(*`(*p(*( @@(tfSf0gfeWf[w1$2Q1	fY12PV3f1!"4fXPSQRй b[s h^v [ZY[Xgf& (88f t
fÝ1pP2
u
f1;0;0E48f۟E1>4>Ef\ 5fPSVfWf Eg&D= $A<vDAB D| u:tf_^@Ő8D1>D f%f
p#F fE>8d
:Hݐ8	\
!Id
94RfUQ8}pt)i fP  t_FZr_F&nFfXYf]Z543t"g&T fA1A&7s@SRfP  , t`Ftn VmQ88>ìE:r9Wfڂ>(fWY tdUEV*0ECWW6X\lY f)f\{_Z tO2>'GbG!F`IH#"b`b (8f!f*f ( UtsfIf_fXZT4QCR~f+t/ER+vWfR[i (t o4R>i0uQ{ `:u
ɡfu8f u:fT0?s4j fX:=2n0<  MV'rjd!a#d~+	5QRV k"ift:333povQtf(uBqދ3_^ZYP2QV3ҠmF{gF pfF@U :mFt{ffKfgFP1g&!1oY$Њg&ǳ~effoffqf-X)1hE`rg&u2^D4Ckf% f
ӅwS&7[ A1=vhHR{iu<kwc3xfqfF QeQ`:i?5 f?d 7dcy4k4fsrR@; ^"i 4R1@f
. '!ff
/*R#s_R (R CsdGqfrfA13fEU8YGj{;5fS< =࡟f`8fQq}pt@AXf3f+F| tf͐89LtfȒF/ۀǲqϩf1{p3+4kЗtfRk8Syitrjtf64Qt3k`A杀=PQA0 fF Bf6Hf9Du_>❦Hqj ttqj@ 
>0X`GG2/f$R@BR@0_PܐK@S4k] fQk0Eyk[4$fGE oyF"i
fAutu@EfYڸ@cR@ cEP1__2 G09ϵ_Uf,RL Rk= ̓"pعspn2A4f_'ǾfihhS7gB	&s&"ju	srŘVN(tKO tF< Eg&ƅDA 0PEg&	ufFfFRo
J15SS2W42 SXi qj Rd&7b4WEdE 2`erE@@QR2>% @e?Ѵ!XApaWQ\2/IB_ ഑]\hpwqj {( P\aRspؠXfrqfFwf(I5hZ[j(w`g$R:#Pȭs4<= V ;  M7 8 3: ;}ssL0R'1Uǰqf0f <rsf0!o@
rZ
| N5Sb-`F$?756VDD ?0\^ 6fRfW<vUp0fP|B`g0Pm1fu1fGfq1gf]X tgp=Tq1p@8UKhKf3f;0t;
`0 \ ogf8EL{> fù10R0a{0`
gf)CFkF{ؐR$ Ik I{4$:kg`ff|#$&&'`'whO(o)*%'N#P]7:Feq<=FJQ
2#!KO3It4 x@V{Ơ

 ^@jf@;0uR:f. Xñ0. !"#$%&21/-,	
9
+ '()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRS ݫCDEFH?IJ*8۝6T LK	A^  !
MM	 !M#N#P*QQQNM   "BS L .>VVb?
K/YOZZE!o\]^_`b/c qLd C[PE&E1o !THwrЀ>ϱ_ hRh> QitEEE>ҿEEu kE PSurCBlirqjEnH kdk\AlEEE?EviAhfpH@hBl3ۊ؀`xE&YFAs|EZFAl3Ǒr"EiVS@t	Y0HE/[^aVEހފR EEC&x} ޲a uveSvEvE0`E`F[0RfU mFS>aF>mF}߈&]Ft(
ߠwEqވE0 E[[ n 70f]pt>EE r1DQw%RrDϊ&Eу90SWEj`n`jk [(v9vTwShUèwxxD y=yг{藲{00|v!Dj|[7_FEr_F&nFE8aFa~~"С!@!R7ЏANO*Bͱ ^E Y1XEg&qx@v@  xGys R`^E>pT 3P {pU Wu>VWOuuvut6ueu^]\uMVӤu:,86Pu)VtVtV g--p= ILXg&8Q	g&tf@sPVSD芷[^RVDWu^%»D xᢑYZPflEE$E,E4E<EעDER.ty0(E/(Å@W> rESRAz<v
hfF,R9gF8Eʀ 7pEƻGpB rм)"軵 xQxE 1DƿGFEEE:Ew 1Eg
f
ؾ0-au
( )1hИPrg&JOt10E诹re8ErէaHɜ1 Er?
 Jtuinet@ELQX>Óh]uwPI $ 	X ZAz,5򐄞ЄEqےfU?A QA01 Ef3f!q!Eff3މFf3^ۉ8F݉ !дF E *  <Fu^F3t	Dt<Hut2'Nt"Nq `$u tP(X$[F iXF uB<Ft<Tt<et<t<t<Rw*<Ir&^F
2t.N>]Ё1NABluRYVWp۾!yAQ RNft(PǴ:\FuP gXfCY	Q9 27\FͯkϠ[Ft2tߊ&ZF8kr 1>tiw>$_^E^FF2 Ef?} t<Cl<tSQ sذY[ u
7_lאL,  ]   
  SN@T>2U2$)
 M2 
 eW &No .b
U,#"=
 `m_{@
?h
L00   -   } %bQ1. "0!2q1  "zb 0u3(0*d-%T0T/	 !
%"b [_,L
 2%Vp(1)1d)U&)!d**n+F)pxhBF4s+Q1D0T 0$D11.d3䀤!DHc!6!'+1$7/7)$8!8l.9&#U#PFS$6$'S%,E1>.>A1??`&1>&	:'+)?++C;q$EEЀL&u
 &PRD<"1I1I J%0qJ#`t@'8,XKRX&I$`hPm" 8c!.S%*NbOTL>[<;0zQbOR*cM*N
WP'5 (#
 4!.	Y3+@։N
 X	`K Y үK 8P)M8$)  
@]_OsPEaBE`ORs!@2*c
ptX %Y rYc	ZrZ`Xgg gDh
hZj`j[[d\0]ig]& xiJ	*r`g
 bh $` #PX
 `"5	  { LrKX\ 	 hQp   
r( s(rL^"0q1`: 1,PXq+v'qz'z$D{!{D|k|iq}5v&Bqz&?_v$qzU$z"D{{D|Xh߅v(p(\^!4M_A..N}')~1'4L$^ *1B%L#|/Y$1 I_aMk`Pi5;()(a
"`\D!bA.ATӖV~)'Oo&)aqa$)$aaa|H*ߤ"za3(dPqJ!S*j|a3'd!MqJݡa3d@!qJSE.$a3UqJ1U(UMt@a1tcH8~1U'U!*U %r1U$U aA.Ѿ}w@SQW0m hǝB t _Y[qİthjBҰ!ưUÿɫee[ffgqgCopyright (c) 2001 Intel Corporationf\@  d h;Buhv 2 \f!2f  t;fPwf֐t*&ѩ!tt f
 0L+%`fۦ\Ұ)u"  sf\` fȸ &f`׿6%[@јf?\fN fٸzP!gfWf;ugF\QffgfNf s ff`F\ff\M}ff!gS_P?gWfgGStlS5[tYI uIfgV8~PN ^f˱f0t!I uԃ0f[fPfSfWfVf&ff3gf&_ffGf;qg&<uGf=_PR_uR	f=CPU0u@> "ρuD0uDf=NPSSufOffۅ `\/8of!`O	fQCf;sg&fFArffAB` f$@gc&q@q 	f64 `FHG	aڠ׀)Sfb

S
Ub

OG
`
!f?Itg00-OD!S~j ?_/Oo	
 o#
#f/#r
ut#dubcnmfx`P+؋y!+f+!#N`2F	hВ.f^f_f[fXÿ;\we`ܪwuA08t3gFg^ %??3f0 	 ۡe\RΑuptef3\JhǂI_ H:"p:ua5fQt5f6\u΀I t ? ZB0V8d< t f/&\/:u`h3<u	w!!%ξB<$< P<0u$ AP Hٓ!@`<t<t'<t<<t$<t,w["fA?B>=|9?O1"ۿ) "f=ISGuf0z sg]o\  /at f6\>/f	`u{;OjPaMf t
St6IF8?t:hC17*"II 3f> V I `֑&\9Y`>G8#fP 0	7uP &gfeCTY?ۊfDR0#>g=&Y0!sPQҀYpSPpYcPY5Oujg>}_T@`/Y@<u(g9a$byd<:g>1Tg8Y3Z` K6!r%6ub
0a<rqS0ȀYYpaMPB qgfd	b%F#wYfބ0{{uh@<AB=t 06 rG52 ? hBڶńN  d°N XчX ई$:/  V00`o$Up@`ү$&0 %`Mdap#p:ׯ"󰰛чU"쌋쌌쌍쌎pppPЍI@ fWQf;#D=RYf_GD=f.sD=.sh.D$.>s.%
.Dsir
C% .>stNᜑנ~ios#i$whsrQd Lr>ӢЧ%|= USwBSuP/|=@Ct֣F `6sЄsУ C ar4ϱr?0&`?W쵢«9r
Ʊ O`h`áТPУst ,r*ItDQfD.F121PoY9YP`ff0#?fCrGifPH0DfXz@٢Tp= 0`Wi?RP$sJɱ9k1WC1g&D=! W9Ф3pTRpһ0iC7ӤoZ("ZR@po(VCo7d_=%$ޛ^$z"$О.n:@RP2 Ի $h >{hGu p<pT=
X݌(f!#T=&ȃv._s$u&sNo  tfPQ! f.> s Z+ZfǑ^V߃u6s +.nf.6nSRÀYfXIlrys  ~fa>?B/Hz*_QfPfqpgfwxafXYor~PG/OsN`1o֓l=GRFs\GtR zGt^ nGtjsDƈDC	 Ӌp`%
R1r
kr|ѹK %t-C	t=T= t:tt h^nǁў!(uV~srLQ@\G=@tzG=tnG=`	thG7=\GR6ńfaPSVs8dtd.&i.	is8DtD$P-ؓ-.i^[XS.P.8t.-.i1n1i[ dЍR33	Џ35 |}A<ss懺7 "  !# )!Qo7`=: ŀhuv||noqhq	vGv<UWRQSPV rw1j >ur(fߋfWR@rh1fZf_ usoFaPSDpuݏ D~s Dsszs/EEBF~F{sEBFF|s"c[XF f? s vbCtC	 D ^X[YZ_]c Èsp
 xNE@NE h fd`u
!s!ddfdQdQ`d6zOdSd ZdURR!S`hPs!sEfU 9"f]#,>Nu%ttt t	tfN a
tF Qwr0ZuJ}]A^&^%s
J1]c6yzGu߰FP_a uabSfQVaһt1e#tGջ}ـ?fPfD@rf jTjfffXsJ]]yӻuptLSuY jf3f!f.sGfWl.*&s8fw*fF*2t*܊.&sfX^fY[mFbFBNCNDs eR֠YQwwuNЭGvvs|  #\|_$SQVWU&`F 
`F u]_^Y[LS-120ZIP 250POSQRVDEBFŉ@NN6wgwZxz}ss
h}UC$rg'<tV< uWQwf8 :uFfG(WxgRXX  }D MZY0f``Fu sucFss߉sszqs`z  |RWq||qW*mF} tEu*_Z[M-Sys   DiskOnKeyA9dF u @  f<x f_P _eyg"ҭ 2r0wAy|=1s s9%# ?a' 'f@fPuL{s4	t6#]r)g&ug&8g&"~0 iW* rLTf<+1{FPՐ|q~[e}dwu*|
 th;+t@  u u 3 jAf?Rpft j p
fXuײU? e"|G5|| 	 x C~PRR3W~ >#>;a>
_Gh`+;" 4  ߰hIA ]Z0|u+s!$?
u$m[à5 6R8358
y06q; y3 /C˯KaaȤї C?0@0a0Pʀ6005 6 pqAp9qԲaU : :t :4yP@ I@ Q fWQf!DQ8oYf_f!0"D5 Es6vsssUKEstA@~D$&Ds
Ĉ?DPX~Cs f!?g&|5 Rr`{r Pa` }BzxB2P~a軿_0}A ꃯ }fPHf%9fKffDfX\}0Cs
܉C2T~tsP  Co} S"r`d0b/FK4XN W3#rK D=qW_QP0
DpS8%´
(&`jr]2>yhGu.rEQfPpK.Àf.6瀹Rgffff.PfXY[rNu9(*?
0?UoXYrḐ_0  F/os&`R? ;s6!td h^ߥX:uR霠%(uINr?\G=@tzG=tnG=`	thG=Mh\Gg2!bfa.&P~.	WP~$p.س.T#/T~02P~2P5~1TR1T~
70 30RaO58ֽ̐̔5   99aP 0 00S 34p92A:a!;;9̐3'5%303 29O>6"< 0837<A;ACB <AփDBBAC.D 0E6ւ FD#CDGCD7:dD<IJ ACAA%ALA!; AG?OAvD4B?B8KKH`BH TcBEDBDSTG E։W!ӃU?HS BT;BZu\Z88Q2Tw\#E43V
aZBZVVVX H9T!^Ea!SF=P;eZaV6g3iA6h̒JeZ!i3G ACE:ACqAPCB!G oCCk@?9-> EKKS\VAUEBV GtKguWEH n8 #J?K@CtAT4;<RFaFo1C F]{ |b5i#T>_EBIBBVOv4<:VueCnx#i4<26bAh30E%=64Ç3 !aT"L2UxxA|gg6F 8OqA`Q%Yr<f.;;t4Uuf.;# f f3gf= v	 +v> f3*f́   * .њ2њ66Ã ;tQ\@ ՉrЛ@ǋ;t.: .:fRfWuPvf_fZfrB1ff`efffROMIfMAGE`;uWtg f3TPQJ 2Ҡ&fGpZYXu
w0&GpG@G 2hǂt"t׀A t	QV  SQhCtuY[
Y[QW  3 3u'f߃ t!wИ @`RG9 GGfCf}Cf7,ߊӸ `3; Ӎ!fBw-/Ȏ1c0x`񣻐`fA>t 3aB   hǝ$Ŋh=,8 G6ƃ῅faqocƀ@nՏ`=Ӑ`QPQfWfVUUê*UqАhhc%f  '&GqP .;t3f^f_YXhB- PVhs,רhys,  ˷^X .QRk,'ZY0.mF36 f30f_\0fyBp}pfàްrߠ"2f;Tu{pf
NNO.HIJKP.&<@O  pT0TKQذ< u؋؊0O0PtXr7uU`SQr/Ȱ'U$8tɸY[ .r$un㰆g`rLS_rpG@9%{8r0 J.1ñP`2Q2	0 fPS?fQfW
r+f5U0y suf3Ɋf}0gftpfY[fQPߴ@g_<t,of4Uwb rA8tfG汪$@eAҀ@8tM5Pr2UvPF X P.同.XP.后.㐎X/Oo /Oo  "/#O$o%& '()+/,O-o./ 0124/5O6o78 9:;=/>O?o@A BCDF/GOHoIJ KLMO/POQoRS TUVX/YOZo[\ ]^_a/bOcode fghj/kOlomn opqs/tOuovw xyz|/}O~o ς/Oo ϋ/Oo ϔ/Oo ϝ/Oo Ϧ/Oo ϯ/Oo ϸ/Oo /OoǏ /OoЏ /Ooُ /Oo /Oo /Oo /Oo  /Oo 	
/
Oo /Oo /O o!" #$%'/(O)o*+ ,-.0/1O2o34 5679/:O;o<= >?@B/CODoEF GHIK/LOMoNO PQRT/UOVoWX YZ[]/^O_o`a bcdf/gOhoij klmo/pOqors tuvx/yOzo{| }~/Oo χ/Oo ϐ/Oo ϙ/Oo Ϣ/Oo ϫ/Oo ϴ/Oo Ͻ/OoÏ /Oȍ /OoՏ /Ooޏ /Oo /Oo /Oo / Oo /	O
o 
/Oo /Oo  !#/$O%o&' ()*,/-O.o/0 1235/6O7o89 :;<>/?O@oAB CDEG/HOIoJK LMNP/QORoST UVWY/ZO[o\] ^_`b/cOdoef ghik/lOmono pqrt/uOvowx yz{}/~Oo σ/Oo ό/Oo ϕ/Oo Ϟ/Oo ϧ/Oo ϰ/Oo Ϲ/Oo /Ooȏ /Ooя /Ooڏ /Oo /Oo /Oo /Oo  /Oo 	

/Oo /Oo / O!o"# $%&(/)O*o+, -./1/2O3o45 678:/;O<o=> ?@AC/DOEoFG HIJL/MONoOP QRSU/VOWoXY Z[\^/_O`oab cdeg/hOiojk lmnp/qOrost uvwy/zO{o|} ~/Oo ψ/Oo ϑ/Oo Ϛ/Oo ϣ/Oo Ϭ/Oo ϵ/Oo Ͼ/Ooď /Oo͏ /Oo֏ /Ooߏ /Oo /Oo /Oo  /Oo 	/
Oo
 /Oo /Oo  !"$/%O&o'( )*+-/.O/o01 2346/7O8o9: ;<=?/@OAoBC DEFH/IOJoKL MNOQ/ROSoTU VWXZ/[O\o]^ _`ac/dOeofg hijl/mOnoop qrsu/vOwoxy z{|~/Oo τ/Oo ύ/Oo ϖ/Oo ϟ/Oo Ϩ/Oo ϱ/Oo Ϻ/Oo /Ooɏ /Ooҏ /Ooۏ /Oo /Oo /Oo /Oo  /Oo	 
/Oo /Oo  /!O"o#$ %&')/*O+o,- ./02/3O4o56 789;/<O=o>? @ABD/EOFoGH IJKM/NOOoPQ RSTV/WOXoYZ [\]_/`Oaobc defh/iOjokl mnoq/rOsotu vwxz/{O|o}~ π/Oo ω/Oo ϒ/Oo ϛ/Oo Ϥ/Oo ϭ/Oo ϶/Oo Ͽ/Ooŏ /OoΏ /Oo׏ /Oo /Oo /Oo /Oo?_ 
?_
 ?_ ?_  !"#%?&_'( )*+,.?/_01 23457?8_9: ;<=>@?A_BC DEFGI?J_KL MNOPR?S_TU VWXY[?\_]^ _`abd?e_fg hijkm?n_op qrstv?w_xy z{|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ SQVW33 &&_^Y[Ü` غ   nBnnnt nJFn aS [ 3ێ7!C &?!Cu3ۏf&>CPQCu
>W^ _2E	R .'ZSfQhv f< 芔S .  [a@ = 󥝁À> u:ðqHq`&o&O&7ߴaPQRf&f=DtZYXð@fHA_HȰBXHrAS2P&W g&u&87u&8Wu	&*guA   YP2r(ں 2 t'sX
y# #!u
 !"W`0Cu%5&t	 r _Qr2#$!ds%QYP XSQ I аOFLF;vhJ &t u2K )4P轈X蔈bC77ȇH8&>89&:ȹ!8߰h4`.  .3Ɏ٣gi
EP/./u	`?upPQfVfW߸ hq @gf& Af_f^YXQWV
 ^_YUCD}D+t1QWPPXhX@.X=X@uX_0YPaGDP!Xf. $>`7u
PE@XuSWh , s ߳h>&M&E&MM_[`L>1&$PnPt3Pt"3&M`P1NE<taðTCA#]JE8hJ]UJhPUVU.VJUOZo[k\e\]c\a]J
<RwS2.d[FDø LD DDаCCȧfY?&@f3ɋߎd&G Qg  ߀  f&Pgt`iffBf;hg&GfiwhjwmURgtNgtGFkf0mh/QgfY tghpg eAB
fP@faeUf&ffgfdTOI vCNFOR J 3fSgdfCf[ u|<aw{    'f@t6f!f! f3xDgE 
tfEF!t{ f!	xC< uxC u-y0 rPmgdC gZL>0"tgdK& t?f]fYf[rtJRPuu@hh? 1 rXu.{ ]prVfv]fAd} ،-vMqe2ERs.#A:ăhfB[fZtЋ /B~vu@؇h2r0fRhEZr/OoɕPPSPd`>[JS %hh%rh 62f[Mӥޥ¤t/FB>hpWhJ7_IFFGhJHH,:vG;Ƅ{vj
L



ahJhJ(hJPhJ4hJXJ4XJԐY<	$8!ԼԅšDhJ}hzn*f.蒗P!u<u<uw_
`>f&t2.e9.RsoeRsS@
ذs=r=dRstS0vpv&;xV4t0?u@_A[ff[0Bw1@~1`;1] t u6ع}"PIa 6Vsfffds
"2ˋ>.h]pfdfd+fpʉ?#̤qvfaʖҢ̞sd/ eˠϳk/wcDjh
nF sr dk8QՐdhpeW@ad̠e~fAtېt_fY`0RԿ_Z@&Ooy
82"àa?fsg]  re
vèu<w'>, @$<w	B@f z`tS>+ t2 u Mu&'<txt4]r	!} [QPSS+tUQgCtFXg&G #su0 <u$
 !QO   2`tYP*tgk"芿r`t*ttܿuatX	
@8t"8؀-rOB`0y\t,&
uf>ut
$ݾsE *t> 01u.~05bt$s	&
螾sPpJP
tpہ@"3	>02
X	u8t0a+4ph+p-ttCƨ  @ p< tfp$  qu w`0;q>@!؀
	%>tP%
5t$$ü7pup[ $  _t>%u
#ߴj! !); "~ t&pV+i+Qt# #Yv(t_ftP orB=i!6su%
u4"	tzu 6طctb޿; sW;"sQ؁86u	+u0u"!5
u<"
2:u6B`  9 qt xp/ |*1 q@PqtXLfW`t
/'t
_8؊fOtw/*a3SQ&A[C vS3t@t:@tCJ@`߾t<w>t8` p aâ8`
 )_T)1 ?a 荾t3,EKR`A.!AAFS J rւRp<M8'2fP RpL&RQ0AraP 
R	 fX1Ft
43萬荬w芬 RP$1 Vt1pL-LW@NAW.frRRޱTt0R|W0 'y@!?
z:Pc`wz Q:Aa`>0PuItaQDApaÉw gHT3

phF3I<3`jJ/3ph 3؃`ij3Pk32EgQ
s3y@s.o{0pYon1oFoCPQS{ /:Pu;`su;vst(ssPy2d0 ݪ yv C`wq1<pK!5ry0 :=r:͈&18A)0b,uʴugC	Wasxww
2Qrpy $
À
v3$Є>0  `-22(-@/ ;~=
p0P@ ؠu p`؎ RfZlfWa#1nsߑ0`(0ȾEfӔ+ ᰕP  DP &Et"Da$Do(s `ٓ~Wt t>@"opa
&t
b ЎL &}u??u8&= r16Љ&
I$Rb  Ў` ݂mm 
 mq!"'3tq d װ * !oOQ{pKa0$f" $$<@thhv KuKfKu`.;sKt&rNRr.iiyyBi'aĵ`rrrp.X _? :呬trrkTdr=aЉ쾀$P3ϙa fRQS袘[Yf?Zt'Ӕtɾ
| t?amX
ƕmg PSRBa,?=tqtr0bts~   hM,  PfB1XhA,,  `  pbFmFohs,a)c?S@dOSee_Zf7SW h
R_@WКfQRf0A߿0ZfYp	Q`CP0I t~vmF h4ѩ Tfr0fSsh)3ff#fYP W!Sfgfe	f   [0`t./Π`mt.9@kO+Aa!Q  Wt%0; c@#t0*A=#shcZRbw\fH18yaof
  F
 !"#$%&'
/`a    3 d $aro  	fGRVW@ l 8  p >GA lBl_^q`6$?Cް! G@RA !dB a$0sFQn o ^FBYg!B  ?` ! nBnnnFJnn P{!%!B  o & $ cpǿ!]"  _lF!Ϣ!2
& 6np'+p߾!b(nG    nnBؿ .B!!  t!!q11p. . .U1R11
2p55b//.	!.	 n
!~7 n! 79R%> tV'&"$`j%&&}0<0<
&
%$ȡ튷
=%@;%$;%Q:
 ZHFr!U&"&_ &'!!֤ʃLo&d"@
'' `A%5OBV'`'5!!@ AAD՗@_  $.ܗPXtd$|$ $d$AxhaRҔиfPGߚ H|$㹊HBMPIP N
Ô3@O3 @f`J J..4%8%   N } ߿  `N  0NTryДrqh{/R&.p. Qff  fRaRRܾ r<fW  @;ܿr( @P.r &r r  C lBQ1PPJQ&& svCOaRQ0s-p@3.;'t}Tۜ3rA!
Hu!@ep#pf2}faÜRAllJ$JlJlBBJiZRW(O/k6k=lp_ZR `n`nZ6KQVWp  _^Ye+t	3zaaqqcraø$PUPRZXsqx"qPvٸ#hDRS D 03f1Wfo    z@WtfP {fXxH f1zxfYf%0xL pQt?xM ~}Yi$1WVxN FQ᰺Y t *  
 t%fP hPR =۾O  5{Q #Y~}^_!xIQyt lY$[t  u!uf!RfW䀉 S }k耽 hBWf' o  pIUry f&f_0`Nu
YN}
awT  aPp 
㰖m |  Rt]uQf'fp|p7gf皘QS uf @_f'[bGAG;W!f ܯ,**,f UCESuf*ffRVfrffffff^fZUfN[QĦA A،Ў~  P.fXˀ u   t ` rWf`S  O tC@ t>ҰÀߩ t.tS
˿ S  [r~!fn v _ɐa#ݾ
ff;tw7P
 Ը'3ԸԸe0pwhwh?r|Ӿ	f uR!ӰR
ff?fLP°3'h2]hENt 3ҹ  &1hYG[ЇVU1"> <$F10u@ts߻ ]^[V ^VS 6oD2[^pоQ0#:D~Z +GY ҄
d$#8ח֣DqԠdk2rd rr]rPP ߂XPhXP<s)sXS+[<u P:<%їrr#M0ϰrPȵq>:ñ...`ѥs{.r &
q臀aAr(H
0zrzDr {rp/)/L//Vѥr ..^ i VWQ>c"]K Y_^c30#.:it
$ .^b".j4wmRh;wst0hfMr f4f` ƾ` u
t <0:'@?o/fa@f`aXRfVfWP3< t`X/
O`#"߾" hɪ=f`Pվ]@[Tv&_aà> u( Etv (u!>0tus"" "u؊uu; RP "! Ƶ"A(8"9(:(7 > t PuvM莏" @Md蔔u$C$?< ub,b :W<u
)7u]]wNpI?_@071v1xpIs2(9)**75+uLX0U\Pc=1' Wڒ$',0QݹQy1@<wݴ{pIЉ2C<z1wݹݴ|pIk=9Fp9Fd.hOw:,h" 0ߤ x.m4 $tE24\.>Fu	b,蹍谜 t=> y4 *ۀ>0KuJbpb}BIwK_ t50 4腝脞t莝K-t0 ,-sQ趛@QO*V PIP&&X>& *@/UbRedubB!QT"UUb(WW`P=.3 /<t+距t&u
$&YS.bPAOt"跁tuFpt
&_g&G a!Xguh^uP_ڊ&tfPfP2WVF8oires6W p 2:> u6 mHt4mo hBn3؋hBB^_fJhiվ}s>m2p3qqpn>q2rΈrx0soƾu~Okzsor.NE
[..ǀs_yhǝBhe
t=ꅆ`f33ɭFff
EfPffu22SQRt$f{aZs@tcdQVW`.C 追>` uw _^YZrVz<ĔPphZBr6hc,tQW _Yu  t
tu_YG	 P= ٠;S0ĳP0hXI
PSBT5
DbSQ6^ua'0O Q2Pb~X60m0.P2
pˀQ$
Qu0:;X[X f`Q؀ pݥ2
Q2t _P(<KrKCXI
 =/Pt 	a ff@3f  f>gf4' f@_b1Ph f&>kft1 t_f%]gb@PfWf@1GX<t<t<oûPS$<w
.W;h ᙐ f;tSfhBf  1f[ "\< I &\<\<

À>+ *#O 
8s o*z PPǠV$<
v
ط  
 tǀ>T 
$
آhr$J
-d t㋷AG` n
^h,s

"-d H
 7
pZEu T_<&U<a T<U<>U< u
8wp9"f.wPh=f>@@f>>> YC0 PrC vrKDC+YDڟ>zZuh>. Ji quqय़ qWuYuSTErEPR.>Z|=Q.>^QBZS ""
ZP>> JVJ_úa(8a3ȡ@PB/X SRذ4ۋ0ZhQSW(`_[lp  "# `ap00rE+3p<uqIp+3G
qGb`Q#B좿???[?aio?#ߠ?BPSz"D?$8`r2??b럽MH<n<Au
 	
/CCQ7IKCaEV<>IOChE]<eۻ\J%XAbAvAlAA^I\J݀E<Op퀃Enf'A0.&5, G5 *dSEptW	  XfP033\ 30G_fY tz f.Ag1iAVM[.`X7͋  I5i 	߀ɏ@p# q%	ìBBBB>CDC_BB  'T(P(B7(' EUUEf*Ud+*`*]TQTL,D\PUUQ,U UUT ..+    T T AJ0U<1A.B2U  &tHu 
hŧBu~o/~r*V}5>, ߰,b
JC|PcY|@4B@ucY~
 
Vq[VJC k#7 8́99q~@7[b~X5DJP?LDs2.DrNb 1mf&\tiu>uh\_>\hd\b>6Uhc\hg-H1u"1t}`<c4FaR4PЋu%RJtG}? @
BJu3LFrL& ;u
Fs }[};tP P&347|X;gEQpgEgE2L_ 2zLOkUV<22 Pظ? $@Y{[.`>{\GpϮ^]2 	Yy?U F0F````hB3A u`&&q&qĸ ҁbbcBdaFFbFgË?w
?uL"A;Ab;7ۥ08&9 a:ON	sl/mOnboQGr &,4? .]GàtPu`G2AuP̀NOXé  w  t%q^AJy{QXq%Gw.Sk rcGvro<w|}Z J|srvnu#/  hΤؑPߣh7C2^tG$>PN
 >pNtGMA_S:.<< pUX@ Ј,] ߔ s>r܄P_v@IF X P.H.Hؿ.HȡXP.H.H.HX=I&=I=I$LƻtȮ>S8rdd rS<dr`
d25@t
Qw `Ot;N3:0z:5:s̀h#h#h$Xp4JQX}pStQ,vX!pC;Xk#Akuuðߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs ?t_uvwxyz| ?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  ?_	
 ?
_ ?_ ?_ !"#$%' ?(_)*+,-.0 ?1_2345679 ?:_;<=>?@B ?C_DEFGHIK ?L_MNOPQRT ?U_VWXYZ[] ?^__`abcdf ?g_hijklmo ?p_qrstuvx ?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_ !# ?$_%&'()*, ?-_./01235 ?6_789:;<> ??_@ABCDEG ?H_IJKLMNP ?Q_RSTUVWY ?Z_[\]^_`b ?c_defghik ?l_mnopqrt ?u_vwxyz{} ?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_?_逽!$SMM MODULE -- COMPAQVERSION: 1.0b t*}> u
S/@uuu&g !~ s"(b%p&[ðDT$ htv r
8 	t .Bh
yB&<v A
0&ß ? n4o&֤̫m%܄Ndޣpb4Dm  	Qqq< o 2PPKdP; 7@7d_ VQ6oDY^PVq!;to^Xf`fff  w$`
$@W  e_N p쪿<t@ B쪰 fafPSRV`<fprN؀t!@ Q# Bt L9hO	%A"f^Z[fX<̽\< .=rP:4 À>7 uCǨ t$<w:9h%	R>t".t.t`. u %
ZSfWQRW.&c//}E0d 0P%_ZfY[@, t*..>u
PtfMP2W6_`5XP8: :`9:?z:  PRBϢZp9;B`<3he	u$>` um    s9   %?t0 	0	A
  3A ti  ~`CV !.  f@u.2h:S&XaFFt
*H2hC&B5J5K%`;û8 X v?苳P802~  hꝲ	ߋ%Nh`JS9N
 OQ9p;`<fP3f&T ffX`;QRpthU	t
uZY  ؎ff uVQMp 蹲uf3ɺ f$[?w]%&\hD	&)_  f_f._B$B$
ϸ @_' ghijkm?n _opqrstv?w _xyz{|}? _߅?_ 0ߎؾ qX>xk   Ȏ؍6
1 BX6x0``dXU`?
 fQd\Ifh>s.f`PXN8 %w N h#Oh=sP UޠA  Dt% r? ;@eP!!02Acߊ [f`d`fw?.PJ¡@Ԣ` H I MY  a@+q9!2 zNH {fC%B5 a$q]$
aq]C.PBcq]_rB;ra`ND 0f   AЩ70R3K~N@ M1T:;! 23۔6u[?#
 1\0;aB)%&P8,$-*h > ut&O$L t;ts`9S]0rN NcAO
 4BM.PC2A  G3A;Sbc 㫃8`<f`h䍚  !h@s.  @DLTX\htx @  $(,048<@DHLP`dhlptx|˴(/OoΈ8 ,f pψ *tԗO40 ,D@ @PHX @ ,< ,< ,<` 0<@H@A<HTX 
 H 
<I݀  ,@Oo /Oo /Oo /Oo  /Oo	 
/
Oo /Oo /O o!"#$%'/(O)  <(<T?,-)ۏ-1X234 P4xz4PXYhijklmno07	

 4_>?@A BCE?F_GHIJKLN-O" # $ ` apb crp0	PN0Pb Rpr RPh0ڪB*D* T8ðpBrUBhhSZt @뿢0 FW@A輢`Ѣ e袣.>;u ̒ @\SQWV9[[@\^_Y[p]w\_pfPfRVW f aa!bb!b!a!ȁbf%f3f3f.2fffu_^ffC`f"ahahfWid擫d
Pihf?0faf1=f~ tfY۸ of!o0lmnR!OoP3XPSVWfQs: `mFي t
؀u ufufpv @uf  fY_^[Xq_Tlrun =s`&&"&RP.  XZ&&Ų^U~hX &|WVSQksߺHU&  {&8zźl&tY[^_P}`RW* t.ߣf`w2gcw'Br@甋f# CTD cH^#ugŋL_"uPCP甭 @f%u%ŋ$ 
t$u eé @t	  tz~dpᕿfᕆ\CRH H@#_sƋÑ`nf Cfᑳ.ffiIП#Oapr@ApLHL"ԛMHMÑp*T VNHNV'EHP,Ó egtϒ㓰B e @<Zup   ?E?rW o/< g @ hdf͸ r!O3hbar  &PRwtz/t śV4u:t&w. rśIfZRppżfŕotfXáՉ %%<tCѰa/ត2 fY tADa6jP 2_Xà< tˀt\H\穡`H`hϛί
p3vYܰ & Яf˿fà (cHcdHd‰/b i%aOOià|U(THTXX
 /؉bs?S|Y%opRbs7 u
P!tt	t
ZPRfP Ќf!8RQ@ ߖ.{D f}L 迖.߿N ߿P AذS. 0f}.p蔖|蒖P0~fQSWQB /s Yf  opMxVQGf  X_[fYpQ@  @:23ɱ#L  $  $!Q27%@_QWQX ו$? 
rO֕r&"B0ZÕ'蕷)àpWW'~'蠕_f+ # J<rA_PR  "LQ _2#RYK)fV  D   ; Z x     0Nm2=P
u@w	l<Pw2 kfWfV`6U6L2G6@f5.؋6f6f;f^f_!S aWf3ہ> w;`6t[>N 2G%GGfpk3ؿlf _fZ gP]@a6謊Ȭ33@9 V	蜥*//h`?RmZ`:~U 20W:i@`?7 2F2#G+= v ؓ@p_^ZP_$
W`6>>@9륪6 M{:_t_ OO +Nt$t~RPuQO#ROrwt>*蛤$,AT+ATE}AT>pPtP:pOs~pTqÊ&TraWUrWqX UrMúT>T;W!X5YG&'obݔ@rYFuW-0XðD$&u `jo(ΐ`؀w5S}VtSP[^t^X0bP^0GXm [xÃ&U&DpTPV`fAZu&d dtKs	2sq O<`Q>tٸ 蚣$@wYiPS	ՑOrQki^^xeD4 ðd.aQ^
^^^wB_&Nu	Nt2-ЕX^ytC`i ø RT1lxRPPP1lx7ð3,r@U% t
  !|~z&@p~r}	 emc}HȃIۡذJԡ2ȉ  wuqPg
@u]AuQ0uIPӅ6@t}tXr= tS tD3:t
u
> u'㉇| 薡qpV
ARw [Ъqn$tb}	f`n|Af  w	F%aK&JҔ3g^qÊWÈk:i_%0o%`kehAO h.$t
h. @/2h.h>ʔQrwdHw<h.*h?h+fA2-fZrhE-Sf>QPH_u(lr#  f&?fݖ0Q[+-+Wr(fa@@Ar.Vh f6tYв@4 uNf3+t ;+wTf6-ҲcQ r?fJgbgB;grf
f1q7 sЋfP<Wf> Jff?gf? tHǀ tfм f? /ѼSf׽r!fAQfJ$fftgf&
tg&fY뤬ٲ3<Ư ±#!3Ȓˊ02<w.|
BuFx 蒝?t@$5$@{b}1Rq=@QOOPS	?&̱< ! 1Q / tW wptutj$
 s tQS=t~  s`E]b<nB %t"; !

	vѣ c}0udЉ>ܐ;>t,u-  q0$/OPSԛ1P/P aPջ  >@uT>u%  V"uqtfs^1$&>P;"fP	!
9X#
@uhT
u!* 
"tOB ߲
wPS55xDzs`xؒ&!N$DPĚ$s6$X[Nt9 Q=r$xڳwS`ؠqq򍐋Wus ]Њ@>t'uuGӏq{50,Wu
߳[7tt$p
2t	zwmu
F!^Րuy
 Y  ױOڕ?= ϕ3`ؒ1!{j
0
c};roqѢ_
y ٿSS=R=rQU<}dC7{qs$OdQ \&&!5豗$Do8P#"MDo5+!0(@u@  嗀-$b-[ u) ,) b&04ޣ3[À! = [ p 
OO:>3t+&a&M.
6 r)`5 yk.1S<;w?<w2١<)=<w< t0=<w ?>rb[}#>3
!$u- u-1͵ܵW\-c%J_f`f.a.Ғ.".QH6 .Bnv
PH.wf.Pr.b}faõr! r PQNX *
reu`Pf hU" P:QXeQ2R0u쨀t
fQP<u r õAr$r Nz.0.V2VrSr{YrlT[zZ-ZUT[[FT[\Z\/S[` ؾ;"" QY;`]a]a4f0d r&pkweOf[E^ydWefDg' rW SNSNFN.&m1ll^RQeРeLf \
ZQRrSNHNt2@`Xٵt"` @b@`oZZYKaQo~0oSNENYp#qQg@ٸ 3!Ĺ f3& &EZy2 Q&&,r豂#r8t2x`.k&EXlSO[&M.m1~2t@~$@~#h  5WO h,Ť2ϡrh  `_vaw35 &E
,Q#QQ	Q	2vQa}h"%00` }0`% `k ?  Da`6(   0Q aVī^W  3 _r-}`Qs˸ D}0ED``eՀ tBeBeЙOЙf g~PDr` brVtW2&*G_YýS 蛠o&*`{u&}Zu&KE@_@fei RgQemf  r\2ۃ<OuB<tLbxذxf[r: " rd r 3h :~=à}SpP
pPVtu$<PteQKu洀aUPB`n[[2R @QTTuuG2P#0wV o^Wµm_H%Q͹ Y<`΂9ppPQ> uι c red`aPSøtCGr-Ǿ``w r uҊ㑼 r
6u`d7 YprdItf s`aQR0f!qSRNr&p0r!ww3҆r r	k@ZPRS.8@.HrqL.pg.u2ɇ.a/Z`{YuA°j#[r	rsa5PfQf   dgfYKuGvNO fFSeT2 Cspme 󑷰 @ذ2!P+,_    )' eQNNO@uSV- 1޾> f<$F10tuP"X4 P+-^pSذ1W r@SP+' r 1 ѺU ȰNӐêӏӎwOn&܊!bءb!P>t
!OqS t33|0)1ヅ
t   t@ÈをEPQRWV+3N O O^_Z231G<u
tpV  _
b@!ӱ{$`7)jBq` 
grѠǋ/\rL4 M.3EPRqZ!V tU..FP/F.^ޠѳ ༊2uyϰbqRVа7rNP	NrC2r<r32t  rr;wҀ @sڋ^ZW
@  е0u
߳˾E u  f~A u2f2 J3322t ~rn
$	"
upƋ߱d;sRZ3FF22t	u
S_ø
_.pK.7RK.Y[.Irs@P"[P2622Q7ȻX   h=SPf's,PfXo B @h`s')N uu&ø4ȸEw CCLPvà4if>PAMSf>/,P(0EH@@&f&E_ 	 4,/344F5E836r4P5 @Q9} f+M'8 hS  pρ6:;3:Q9Mx5 hBS"44 8&8qV?b@!4 7=@7 <(BB@C8R(HP(0fip(Qf@f rY  E!fP < u h2vhEr5fQfχ^_fK7h;~t.oK_nur@Mؾ`ME<uPNN/f3ANY4QRTPsM(^PR`if>tr 7k" }[U`D"Ў`Qjr&߀=t tVW" &GF_^aYՃ"q 	 hP~
Vh!
Vh"VhVh8h
ZVh8hPVh 8khshL$~" gUh ogUhgtro>QW)0pက 
p@ pp_h4`~JUoc.2K.a(3 -o."0^u
   .}ʆB}%~ |󐼷ɍvQ|  |}RFY؃f.ϷQ03 30 gg& fO 
 30g&Of.o>uf!E}4ÅFUWnhBM_]ffv
@ 
. .s pϒ/Oo ϛ/Oo Ϥ/Oo ϭ/Oo ϶/Oo` [~$`<`u*& +ɸ.} -ɻY"q ,h .a ~ u B+J. -_@C,An .O aSRؠİ0 t@B{u$Z[SfQWP h
s'Xg@g_fY`&gf}˰gPfafQRfWPSf3=0fX e уPe2fqd W1@Y?a^[ScҢ; X tDt/[Xf_ZfYù@ fPffffX,fV3Ɏ؋fVf   E gf^!f^2V=t/DҾc ʧԾV:נ/^hحfEW*_fWfX_b}`g&'P׃Fg`9f_fwV&i a@뒄tTъ!~{"!{hҎViQ ki$G\i{#YOi&YEi^yfX>u5#5hikVhQW& h&D fh;BBJAX	

 @`3(PMht@C  d fϸh@.ϡ ** End SetActiveDisplays: \  wR$Kt5Nx )ڊϸ 8t{8u@ZyPQwS![00t=@u ^SQ2tWﶇ`P  y@t+ v# < ta T<uȸ
 
!u`@Q 	
3q{0?D ` $vvLu
  rP|
 }֐aev"	X}90
SRlP(
mP$p 	mlċ؀ lXlX_lP[lEϐPlZNvR2 tlP`!ÀPlzPiQRPS y[X"3t"$b@$$p
2\uv( ha@` $V
uur2,RWA_Z
r "_&& &E"&]@  ߉'PP???3 wrS UfWU]PcSW_vð ˹JRs7_P  ~  t rH rPt. ~*fdftt`dqu@f I&f=>`  f_pbQ``t' tfF ITAfgf>ؾP я2gaYg1Lb0nҎ bAI  uu#=tGapS>ev fы"J6z`Ȏ؎t q (w >N!ܠ6MxtNObOVP<0 O P0а56{ffLPH/>-tq`%	t`% 7Iu3@uQuF,
uQ&hГFu
3quCu3ыGN"IpC0WWf7pv`
 <ca <u2<c
 h  3g/hOiojklm np/qOrostuv wy/zO{o|}~ /Ooψ /Ooϑ /OoϚ /OoϣUPRPRVFZXRR{3Z Ooϭ/ Oo϶/ OoϿ/OoŏSM ЍqڋhC "$& v@ A@ D  E  F G  L N O  T  V  W  X  \  ]  ^  _    B C H I J K M Q R SLJg"!!)@Cmy)<)o?!5"(̈́mB)d[S@VhCp6EsDmoX)O*y`?P&P2Ru-.>;t	 
>R80t %?]
8 9:  c],9QR`8  YZ  L hǝFh= @ h
Cf 3hD+&0% -:PfffXfffL$ , fQZ fYtY?R	@>%$P(/ݼ# $ݐ#` 
0P"f`ܻܿ 33 s#߿;ݹC  $fOs"
Dۻ   7XOf WPfi<ڐ Wa3Gikta; ;Q`?<  t7ȁ NuR$Nu;Zu{"=ܰsd )ZW  pSB;&W?;Wa2 ;?3fH>9Ht 1@3>0ںfW $(d  P25WYf#g&!彌QɠYfR#uaߐ hcZ] tP-g tGzu"r< t =P7 wWP7 oW!H f WVf% UpC&mp ^Zrpl?@AOB$._ mBۃ:d "`pVޣhd!F5xVHb]?!܄D_B x,mB.5a-;.PXⴆ 8!ha]|ȀMиJp1V! ࿠⹪q20!#hD#3 r,2P kfk_  C9999}    909933:3_ @f33..
:B^ <m<<c3r=3h/]& fߺ   bS61EE[XfR :EEu1E hFKPSFFZ Qf@" f0:Yf¿   (B   @
< :uy r} ru rm reor] 9uJb>׾AA0BA>3>T{X`@,r':r:rJz2L M h]nu؝`,Ldu$ůaQYYd BB [YÜR[nBnBB2JJnB$ _nnZRV!(0a/`6bv^ZáTQVW  ߤ_^Y%vcGf2߬ gaà桠
!  Rs-^[{3.;'$ ?%rAk[X+t3A@gpmݐmena&KۿøJ`@ûHWs;ۻOWPW3;t<u8W臛.sP3   ƑvǑv7 øs @q2bq$İzÀ&sR`BRPP0AmF? a@|ؾs}}>6  >vu:蜣 za  tYa (~u>调軿suuoavuka ;s bv>uy
тMI=1a
u4⃃AdϿQy	bvdʢr;;sBaQyPVԼ  u >!C;/u(any$ 6vv @"ѐv vw QuHrjk2P{ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_Ɵ ?_ϟ ?_؟  \J!
1"# ۯ$
 #&"ܟ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_ !"# $&?'_()*+, -/?0_12345 68?9_:;<=> ?A?B_CDEFGHJ?K_LM  p   
/5MxMQ RT?U_VWXYZ []?^__`abc df?g_hijkl mo?p_qrstu vx?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_   &  }    PS#  - t	.H    [Xu
.'
uu  `fSfQfWfVt, uS l  Jf[t݋3ff^f_fYf[f` a ffa   SQW؋2__Y[ò					%
ðc	
Pp[^B
`r		a2`SUf`fNr	
	fa fSfظp	fӝs(3Ҡ` ؋60 zea4
`e eue۪e	e8aP (33Ƀ t	APuxe&>R(eaB
f7  ta  ?u _r    !S`	
hzW_+[% &E&_"
!x$fRQS	2[YfZfQRWP
u0B1^5d !, 8uf3W+0|A1X_ZfY6 s1r `ABCDEx} ~@fPRVWf	 fFf^fNfViЎ.< t ~.FuN._^fZf[fX@	1r
@
 "@
VfPhPf0  f.e ..enfX^=Fn>?'@v
 Akv1 .;nt t+0t .PG AKftv}	Hnf  4 t j u3  3GEA3GSHt<  [SN> [[ÿ t$v~ Oio !PSQ3۹)Y[Xf
	.`As.QI..Df.|VfVfWQS3Xt| uRY\t[Y`^ f`03a~;B tS
tw*
t& o	PO볆o##`G z tfeff7~
^轶 `a[]
 UPSfVW2{ Gt {f \ t]fAh6nP[AQJ rg>Ut2gFYPAXs\Pf3Xsȿf	P^[X]SfWfP`Kf f;r[r}WitlmAюo]_pmn WAp$_p&5 rsgNZ	g/Prs <@\ZSW7gfFfgf;PCIRu-g{ u	gf;K\gCufQgK1`	ffYfX_UND^A^Ns" Pp  Gp  fn
y@ pGRj@<7PiNV vyN"Q3ABY;3A+X_^Z0Q 0  t8Y=QhB
Qf?a?p}?pfY@~p
6u`fWSQ[a^fWV߃3!Z !P11/Pi0] fP.t "  ؎fPWPb`f%: t 2rhVF
uNF3p	F 8ȋ^V`uf
Fr;Vwr;FvN3Җ^ƀj rh?r3Eȡf7+FV
+FV؃ "𦡣"  m '80y
+G
vm> u怲A*eF81	j jFPFPN' @Gj FPB8V
q	q	~ uazpm  c_{ߘ	BhBб  WVߋF= % k:؋>@@@Ftlf&@8FtF% { +ұt1Ht	HtHHt&-9Vu~r"f~  r~r	FwsVFsF^_
  dNf*΀ ȉVfF ѻ
Ɂ3Ft	( I _F81ӫ`!1!0ӺPU؀՘f0Ӌа< ְ~k%hq~$wP!ӋV`fF~ 7	V@V^ze(FFݘN*;~^u@ޙ
)ȰRPWVa߮uFfHuf@FVc;tL+=t"ޙFVF֐ΐ}VfnJāW
a3S;Vwr;FwS)FVFVFًFV
 @e!	>fG`G3VQF |Πj*΀#@@fN+TRP^#p9Fs$FVp`0iDf0פ*QQ^@Rv@ъa0Z~ t	\Ë!An0r:W~ptA#f+f t_ӡAP  tc`;vf9GrLC+sC AGvfGf+`Bfvv? AF@s0 {~!F f;OFv8`SVӕ 
f;Dv3י`΋VWV3vF k AsPS@5FcFRPDujP0뀼ze uvdNFFA,ƉV=(ut'*$<u؋ƺ`DRPA,뼀~ [uRk+e+ұ8! ^*䊇*a 	7>uS;7F96xew٨PS¡	u~+9D
r
w9|vd'vvDҋ^0vB
@ *H+;WrwQ
3*O;w ߳ܕd~15NFaΠF3cEm8$<uՓ32!FߋV3SVe21Fv8H w t2Nf% ]8Fl~Gf@f6VA< A@PFVR846'(T
d89Dv0 5Ԅ8JV@Bw DC@FFs52/?0S1a246A c tӊF!t0$"DPNs546PN!4Ҫ6qA78rTT#:a:0f; `JlfYO<h=!3>>APP3PhZr3 j
Z^  3ZPV+k:ߊF%- ұ݀PƐ@@x^_``&`a(aFt!F5 P%az1 ъ%t
 gB1T1Tr -FvB	F t'5  f^0p"tA^%5~$sqr% g		^+F`̸(3oP#WVS*! 
 A^E\;u;UQ>)u	pf+^uVӓut F0^(p=bp _CN݉Q`A3n F(/k:@2fut @u% 0; |V@3D D:B | 0  0ꢲe	 6b^|ΠF0Fm1VM0źF$<w`"@5k:@@G  **uGW *␀= gqGr"t
< RE	E	 b2s" E*= t0&jP#Eupf$ + 2E~z 飘yq> ւ%>WVQ~@ ~ ߍD@5M?
f+o@0׉VZ➿@hN밼$@fp^ akN:ى@Ɖs"`lP@K&0(@ѡ<Wu%DFB ȇ*@PPo氩9v^~wko:> &@ $~= @sڿ0 ŊTҘ
E8%Vk :@ 0p
k:9@tC90B^_A3~6 "@tu$ NtF3!ǁ%^t7B1uϊ5$~!b:  ~߿96't`}b%@O0';t|>'pt@ՋZ2%S!}~fы^9Fp 	Fza
avvo^42M  ˢjp F򢧑ft@r
PvD26E
2t
9Q!;WZw;R-fڠ]Wp`
 *1h 9j $٥٬5ڠVQzْuQUЋ^bt.>&u`l u~W^DFDP1 `\]#A Py°WDP164-랪^\uq!?FgG  P
K`o~:vR! v :}tyhQDbP5mbE9v7yGDPgJwtobPǣP0HzRVF@?f*1k2Aw8h3گ 5tay}6
 t;|a6 PpvPFPaĠ^eDPpc
t2gUU  UUv6\ } uAEht"aP}+*FN*+@tRZQ>xet-T}	?kxe!@v鉅+e(exeVPSVu@83>;r;8| ^[Xpfam`Z&k``!muN#. pgPb$@*'Ft>v9v7v3p~&p} @ `PqCA% Ak^u3҃ r PA3wk*䊁u luRv3;Ft7;t- t#i S+`,u
uGrvFr`2By cIplЀSRNN `0mFtv`Rmp{Ny`zy3ҋ|3fs5Qzawh1pj"$`y^ @8@ӿ` W$pP?'0Q1ǈ%@}, .fJFBBBB`#` ܈F-F҈FvԿFKL QLo QuS32<V Mpw#Md PbP*$@V tPtR``BzPSv 8Vsy+ ;Viw;F`LE9VF1V =PCC$DDV/EVF$QGډVPCIޡDV?KVF?M9VF0<8Fnqƺ  ۋ^^"  V  V& |2\ƺ( }5X, xBtfN F  fBtF0ZsZZ1[YqJs܀σ8F v]r9YR^+8@fҍ8@]V鋕F+o@`ڋF֋Vob Y0 Bt,f{%  FRʯ
`a'3b,  e> kQiP`m#X7R          Ux NtAIBML 761295520C??Cr   2004/02/04 18:54A. bBG ZF
U2 27Mhz VBIOS Rel5772,BR5868
 (C) 1988-2, ATI Technologies Inc. BK5.0.0 VR001.00p07d3 1 mssaphi.270 v611  MS2 AGP ?UN  \  \ T  q  !7CEeurj?
^  :0$TVSjJ0  ~  HD8P_CIRAAx P RADEON I`340M  CZAy0 3Q CD  <  AP @X A`wT M[H   Bf!0@@	  @#dM#A`$ uHAM1#! 1#DYp 4@s_tA @ u
A-A<@
 Q 3 *L  @, 
H < B _  .-uA.B,B`,Q-(A 
 T?0T A
-   $	
3  # CAav0p  lBwg
`D d6h6l6r 9t  9:F:f`.>, u..,..	 u1> .0.9?u.0Ȳ.,faf`S.=[P#R$yQP+$XdD .kfa Vi^dpz.>Dt贤_V F.< 
 ǣ	(I诉$eAF JPBXpJLB6P ?u3۩ t߀M0MM{ M  MPN = NXuM2@t	O @ÀQQ@t÷O!CB0S M ǀqTt
Z(vZOtcZ0tįuVZ<T u=T첺2ĸ FG葈f@ f@fb)f| u-ff]@ nf.TȣpV^ <v  !  32Ĉ&! .~ a@2ad^	AdNhV  *81@Ld
Ff^&|G
< .   k P+ @K_
(@dehF6 F
u'XxYt|Vho"G_oVX2FS_N)N=SY2`mnV<tipWVqtWVtuu	Wqt; t6f;Q= Y#l-F;$u<t<t<t
<t
뉰F f;X[# ~ tF: FphfǻF6r<F2AY\ wtÈn<uj`@atf ct p~^"N  3X8u qxP 
X"8tN ;N"rҋNN"ar /s2~}tRSf_Lf@  ffff&f݋p~oq {sQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ܀ 
F  yFf@F$ߋFFF@F&F(( tR.&P@,X.?
po[PR.Tt2K ZX`"@ FGon@rj=Y	;5vu tU;5tEt:]r9Urmt5f3nq\f3ۋ^$f3fq!}Cs
<2
8sn~=}:n=a P 1'(x#D Da S?BDR*C梦cOQ]0eGᅨu @gOVࠥ@hOQNbRU0TJu`ljBcgvW?X _ce
pdV0f|71cj`O| !f7µhsb |h cf	3JUB' $|yĽA)1% LyqHdy32½w G @ן/?  =ҟ)$ǡf1ҟ 81qҟ*$0*űǟw
 	
fŐ3ӟ,"

` A13G羢oY]M``aH袦ip}1 颦q ?UJꢦ3r 
u<2ū Ujۑ Uۈ Ճ ܄v 3ЫPÀu#ڋ GuD u	 2ôU qxƿFF
 F ҋ[ ]FbVuR S|j`UU```$VF\쨷ut@ @0 ,^P@p Xj  U   SQRVWPw<A=D...Tt& _^ZY[XPSRsP$ BbXZZ!2&G@а薨u
R$@
 XfPSFTE݄EFАst? F% qPu AOu/~@J2K@jqJ;[f1 EEF!Xː.?6
A|t%	u<@	2@ n.
6]_V
GP
X
c
#g
@	EgQـ.2VdYe	 
؀
u@	&Z^NF k pfFig FCgF40 F.$FCVap@@@?f`01fpfafFk[FNF rjF]kW  0_$<P⩗_QFY_kSW>NP u0x 0" 0"0"X_[( NX$M[_"ltF$F&p~@o?
u/~B~C
Mq;M`mMVD Gp*J( f3!, v GJ  P-yfN-A. @.{ty+ @	 Tw CU](  .wp'Mo
Ģ+]*u`
L"tML@荖`It<uN(߃u#3y  AEq b;b;wt+SAU1([Y$`>JACJ:{C@jQijtjKB0Bt
 6tK@@L%?%P%@
Ā?
XÐ( 	 c-'(+ Ҝ  ' PoGHԯIJPpK`c_OPUjL(@OMoNOPQJ@K`LiM  U@i0OWoXY|ZaS@ ST[\(@] ҫaڀi
AS mZTMB](
cpUe#f ç
   `bc7`LO
b MBHU89:;o<=>?J+_gGL_BReiJdpgZ"ozcfkjhI2Oi`jf1ogڱop>hꏟ2 qrP~ps 
`> @،(@uU	

JpRK 	_\ \wy^0{c_{`|1a}~ %( (,%*26', 49$,0	
!&.3+0$8=-2o $8?ce!ac8`xecpy#@~	Rc%m~(pcKLd _m|joRcS MdOoϝJ	eKgLh9MuScgTh9Utf(RUȯefewwy ?~_x{w_A@YUzAJ@0{ O<..puð=Ou&"P=: sX.4X;B;ݞEɔp_Y\l"/x=>|؎= q&P$$(%$C<~.;u*6G<t8Dt	\S
OX=PC
uX1체0&G	tԱ G	`)?
u&.+X&c b%VX͑ɊP`tXubtju
D2Z}X&I=0p!UF 3`]U 
F CE]Y[	A*FXPs(h ?XSƇ[i(.>ku\9Y9V9S9  ss't
18 7+8$%@uP{z7']c;PR: XC  Q S[RS݋ڸ026'C[2S  &'[ ĸ Ë#Butt&FS޹ 2&CQort	 F[7	 2n Ȋ_3Sa
.f[t 5v @7t ̓rP?XuSصK[	$
tSÊg% oŀt4$
@# t$Êpػ
}P X3<JQu <~$<t <t<t@؁ð@d  a u Á@W  3  @
@@ b !"# 3@Qtb
%%o`aSI߀ e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;uPXmuK>L tDI @.>T@ϯ3u"T<~T&g7!0u3 30;(W2PQ33 !X2PR3$@tZXtQ3g0R< J3Z8 43oQ'3S3U3
1QR2aW;B;T; f3fRȊtlZj0#ZX8t`P ZYXkuT  &w@&2u ʈ2$
t	u$ 01 PYΊX@0Au3$0<0u e+&o
6o<uA,	*U+t	
te+/
 1)<u+,봀1u 
-
,a<3u< r3,<
܀4u< u̰-56u& <t	 p5ް뤜B"
0%d %^N49 * 7)Sr:P 7Ȁ>cu:,%@ 3ۊÜ.B.EC JXð+Qt8 &B BH<8t<?t1B .B 迼  D뷀% G.`G* BQ`J&Co G>CYJ 3X BQ
 |YkB.%NON% *P?#QPQG@HC G`C3S	 GDޝ~~|ֺ| |88|V8 WlW <~<0XffX Y@Y6xx~~~p`>>66f<ff<  >XXf^ f {; <f8ll8]x]~^ 2^ }0pp0$ff$j8||Qc|V<<Qa wlllllfl ~|0` 8l8vvb g``0 @ih`   W1A[$ehQc88 gP]|?| xalgfl<| <l n|onƀlЍ|@pAp q~n qэhg0@PcPc1sine q~g ff|ffp_ cf< l^l  b`|``oޚnƢu e <ryp ؿ  i`bqVup y|uCx y0g4z p|n~Zy|xlV}{l88uq^e< gP{0x i| 1s]||VP0Pix|~ `0vRPv onЅ6000_vΠq|P8yx`flxl`L" r l{ܒ^Ap|Px 0h|Ax g| 0!6a0Phpg2!f0"vЎ 0dG [qDa [ v0lqvY_{ |ƣƕ8y8l8| qa|f|ƣ0l3uuPlwQcl~n ~lppgopry0 ~l`?fl f^X>c8c> _ >a<Qqg A`{P|> >`gc=L`a0`vq`iqPo 0|w6>l<~te  6ll60l  "6UwRA6  `RAձ `QcQcCbj մAaUt7ұ70??0ø2!Ը!`Aû66E AԱA#b@ԱAEE  f`x̯ `b i8 ` ff`gPc~Pzr^|0a8 ul8qul8f_~`|1m 8`w`|k̈́j~ t͠gPs`Π[xakX je8fpK0D| dd cRH	UUaq2VdlVV5#WdlBX$X3XeX YAYYYZ AZZZd!add[d>6\vfasp~Y~%d>~~>%e"aXSp^d`{@_?`||` ka`℮ddbd $cdYrb7 p ?6ݢej9 ffj pxnbqf!n4 h0v~B`t9gr@shBf8 ɩj ZMp]l!mуmmlQ0no3o@o ` co	x0pтp r!qт|~	 cel4s6`2tpj|2uy4 v!vC" cS w#wcf`d|d``Pn
Rs cё| 4y4'Azzzp4{0{{ {|Q!}P}}xwp	e% ##a#
`c" s34DV¦d^$@d !C96Cd#V8 (pPo!@_ P80w(>a٢{ 7"&%W"2x$= 
F~3 t<Rd:,s  !uK=` ddQ QQГ3=d9Y0|Q#z;0x{7ŉ7Ai 7 h{73С#Y ;ŊXPs;`?p {?tgy\u2! ikf7 P YE0ED`jPYW A[WcU%3R] `{Acc0cB X7!Ή? DX:7 0> P$$! 3`03 B< ;D>
p
` ~"֠	"l06>6n6tѡQ$  D ;FŴ ԱƱE캌 c윏#'  #	ŵ5剘5 ܘԱùձ%  ձ%5úU #ұT%5 յշ4 T XÍ	{ah7ؒ!Ɓ"'>b0P"h: 4|t..te]%0<P``<f<( A| 0f0BV%v4P stǁ0:7Xt @y<_I/x8بSؐ0~4 u-t?W2@ _ר&&MPWI &FG_&E"&E#WKj_&]%&}&I2.2
tk@@' ܰ)ڊ = ~=^~=~=~ &U*&$
$

P0B$
-1|P2;t4&w_t eU e e 2OԊ%@+Fhݐt:b Sݸ  t`:t?F&݋o p4uf&	Rb]abvRъĐJ_O 2  &GF`%GpGÜQW+&N&D&TAΡ	ʡ p&RW_&TAF2 MD/Z
C37@	 !W_Z_Yσ`GQWM$0C󤾄V rt|q:&?Q	 G	ĸ  2WR% RҩZ42z0	2dYQMp&GCw/'Bw"wY5MP4 iY t'EPJJ B2BBXJߝ04wLT(VBBA wI^ ` (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0%433258:=<:98899:741	
	
(A*+ *

	

			`--


.0..R..30
{6*N1 **111u2? 3??13R3`3 -00B   $$$(((---2228884? ? ?/  4 4/? ? <7X888?'?/?7??a<7?/?';<_==--?1-?6-?:-??@:?-6?-1<@XAAA@   aE  uDE_FFI<IXJJJaN"MN_OO`U   R  KRXSSS
aW
VW_XX
[
<[X\\\P$
ĲXðKðK[  c1>I~&G3ue	u&Iú}ftԀpcN0jb  P3&2J&Gۢj ڋGLqkģ`À0cO BRl ljmbmlmmnpomÐ
  !"#$k(
K1z[1z{1z ;1zl(L}ߔ\}|}<}n2N^~>m@M}]ߵ}=`P@qPqpq0q aPAAQ}AqA߆1AbPBRr!/cj)dCSs}"?dU/DTt#4f?FVv$6eVESA w  0 JGϿI  00ATI Technologies Inc. MS2  01.00  @ @   &N   C>VBE/FP !.6P<r2.TWVSQR  f&= 2u " Wi_WȎ؋ʾ~IPW@" uz &u@&E6_W@`!@`@` __ǃ"@ڽ`0uZY[^_O ËRQSVWU?WQ3Y_l|u5WV6I2^_
.TEE
VtE M]2].l.DEEӀ~ZӰƿEE!# 
E"$ ~7꠷ a+~$ `к#к @"%~  EeUeB(S23[N
tȈE}~=
 P`,E*؋EMډE,].

+E0 X 
 2O]_^[YZ0RQUSˊ$Pw
 x < @t| dQL Y~b 
3Pɰ c}t
	$XPAjDmIjDj2rjDPku-tuY.pb%O[]YZPø VP$6Gشǿt8\t`	2^ƀ t %Ԃ@^;O ց	93&PWVFfPYfXF^&Vf=F^_ FG< uû7Q.T.0W,
._?twCCpPS(Q$ F[XSh*= rH[ ktpt
uPSR Z[X8
t
<RBB@Z2Àuptp<wjut`2.T
,a<u`O2͋iaPX(
uÊ uW^@!p*_O< uL0*؋RIS ;[2;vȁ~#?JS,f[Dt@SC[%@عSQ)2f3ff3fY[f;Ës >klIft2uGf`P1RPfZf ff3)fX	<u觾S$f[faw==f$` %%>(؀XZRQZfXr
uQR~ZY uRYhZt3t	! wl wf=	]QRW!9Dq޽a f&Pfǟ$
`&fA_u7Q&   0T8<\ }VRJ0fPtZ^fOfƢPRTZXtfffPf7VX ÑV~`RfֲS7ZuñQRfRfQY  ` $  ZYX
!f	^@
ff
v QWf`i !0B~r&@
~
fIu$t%B&t&@[\tWa_f.`**;t+u 2`+@Xw.,QSu3tA
[YQ
$Y@?SQVW# I  &I5z55^Y[7QRVW 	_^ZYڋ_ } T Q9̃8U@MR2 Zt $Q=ľ=
`= tSR <uZ?DQSO=o>?Ā&= 3JJeL=M{N~MNOdPP!QTHRMSHSÐPMIDT`   aB܌أp@ܼTXR ZRw M
 M ZÜW _Ü  .,3d f.;xu	W 
߀	r2[fXP3Q& $4
 UzyRHSQffQQ2
QQQRWPH f3fXR2Z ff_fXZ@2@ZYZ%Zo[\\ZV^fQ\fY`̏YZad\m\]jeV\)ggR`e}=OifZf ]f_Z^afl g +رKK;rZ` S 
S  S@ [phSSSR	QqQ @2QYÜ2C @pO@` Cw w Iwd xwxl zwzz{fn^~a.D= ="f`.T.
D~#PwQZSRC~l.s OZ^3~`
	.DfXu_ Z
B|Q3ɊOb.d"YTcV
 GQ A8ttuP3צt }bu
vt  U`PXP aĚSQ nt)hkrOIC-KuY &V
pEk8t
]NPKXBL`('`A! `Qvjr
g]Pᝅ
XQ臡P$B<93X㱭7r0PXQ QP`XrrXsYY2Y SQW _YQWar
&@G	Ku_@P AYs"'и'Yr?
 Pft2+QYIn00QU2F F  IЩF EK`pe~  tf~[  u
P t p]-wu @ktuS@[2SހXY@[<t<t0ⰠMu[<u <@˱u 2뎻' 
PQW&EN_Y&='XuSq0/upW&
_
t `p䜐uÀuW u		.WðpPXq v<Zr,ZPA [SE@r6_;w2XXnVW@pnH$S舗QUHyvA. t:uF
qPt0XqF}
d
0$4 tp]зR)`82
ڴ
Q$߻ 
ǨY0_$7q,|$ARm|$N\URN!$|#ۀg$RX$Z Cu9@0S%$'"2[M$%RB`CtP4vX%mm Sno`?KÑNNOF,F"Fan0v tWolnnnt
uut
NONpR $?ΠMS"
n2ACɹD  0q $`?  D b?+$p'$R b#$P䗯
ēPR_u$jW2Wp12;p p)
st`?
B8pP.ktP ^XзR vqN裯M^Mp)mEskmlem	phH($"R50t\
&辷O p)uC
kk;lm%"`?u%" dILLM T $ZBRW	 	2	$	$PS
[pPG_PQWP1XXp
u$<0!<t<t<p <0! r0!F, u	FfF6%:R._`*EfP%~GF6XHݎ u@F8XH0Xf%  fF:(B)f=(	F:qi2E..>̋FF(PwX0!}#r]L0!SK[0! Q Uu	 Qp'TtR3Z0Y.C2HFP$'GFF$.
Gz2 4F 4$`4Fp'	F 4$4.M	̀

7388
ňFF	$4	F	 4
F 4_Fp'3 4F G
F3F)F4FBFGD '%%>a$WPQRF;
!t7<t3<
t/"P"
<t<t(s2NAVBxJF Z`fv!-P%2XtkorDujP n0X P)P%G:u@P X0Pc X #u#PLP@hLx : p0d ;>u;852/,j[Xf 
@	[ihZgqgI"I;JCKհRu
	Y gg5hipu@TtIfEߴHHAGtڽtauIe{q[f.? t.;u.;Wt3E@^-'(+ ]cߺ@^ߏh_^_OPUU_ wb` _bЏc XGW@c n6gOad  _`ccbTF_fc2kUjj. `cImn  qZ @Ȁp
2[ESQp3`
/@+3!pt!p		t!p0uuC@S ux[>'B1J4g+PwwwvJ4g
ﰰ5gtx2w	npy 7g
ux;gpy	xPw py	Q|
uxPw
̀<g gwA 
Ȏ? pm&v$@
Jv@=^v	@=vB?
ú
 ^A0IJS b߲Q$P$fP,
 _fXEfX=ьP5쿲S#q?
;s.:Gu]u.@R&2 H pa f3.tUĀuB@y u*@ ff`'Gtff.#Gf.GfۊРuR}S&9[Y  fSfQfR\Hm  <afXf+@߹@ +`fSGS1rfDGN1f.N= NFd.Qf@if= N  ssfA!ff ffе f0u  r88
@YfZfYf@@ K PZ d ¦   	 0 0R  ߀ 	{    0    ߀p{pp ^0^0^0^'CxA𰱰 "p௰P	 @KZP´   2 KY[VS]XW πQSfXk  @}õpf[@ V	 f`
^fXQV2kk.^=a ~8Bb YR{
`fXf2@UГº
QpP$?`X"PUaw0P%PP%X3Qf
?Yfp2fPV.^2NfX ̝AȰ
Iquf&$Pϊ32fb˹pYf#PWVRQ+Ë&G
P36 2r-v8t3t.t)$t$)t/r
4v6sPQ@apfX⺲&2&YZ^_fX QR
FF?:q50+a&!0ƠSحfظ`  b.
$ Àtr_tt(It°0SIt 0tR0ro `da{@t@.
莰f.?=WZt Rp f.;Tvvy`'P  wjvef+б0RvM `v?~v2dtv%jv` e	r	wUNf߉V`^f*f.fff;rf@frx*f.?O^f;rLf?.q@f;wff?+f'av
ACX.LIa؋N]t= r = r5.DP.Ã (		[@E1À tpװPR	V$T$@Ru$ZXya&GG@tP@щ!!$&W7u t@v@nvHZXv`ZX   RWaq3t4Ж_ Q@w@`0a6؟f.qͰ E-  ͸pff  
N!>!  ! j"@#.qf.&s@ff;s!%f6#
߸${v%q&X&'r#5 6]'f60"6;Ewf6@#qQ@p7t<Q2P5aft@f\f
 \?
P@ "Sf44  Q3ff%_Q@ø \DwuHۿà     SPŊfD%f#p@Ƕ87p 7087
  7 0 7  7  SX\$p[ $Z
Ҡv)$@R  i u  @и(.q.&q6sE.q.qhw`F @@pH<Hqp$.@ZO>@!Rl 0%g +uKK;r 4 S`<
S  S@ [ 4hSSSR	Q OQ YQ2 QYÜ2C @S 				  aU p V
eu2[Y."D
.
veutcnus] @C &C2oࠢ2?/Z[հ00`U W&E_PZ[YOXZ[&DVZY^&^fpb$^fFtf
^~FfNn;w`K ߨ[Xu;ifG??P︀D
UlFF m	BkkUtfߞelUp@
߸TVp;UpF0͐ۋF-7ho{VpzUp	FȊă1n4RsQwnh%w8&UpF%! tQx0	VvPFf=P~)h@f
 ZsU]Ë؀~Àu聎Tt
 $Vܸ
t҉<071
Rp܊2M Z 4 ޡO",嵉"!?S 	QRc3ҹd 4R#x.yZ[  RP۲UXnP聐$`K@ݨ L ($$< 3tp  $$@!h206
u
&4u5 * u.0t.,ﾭ3Ý W߃ [ WQRVSQӰ.۲+$sܨ g 2@ W؀۲|P~@-Ϩ t	 |X  PxEbBt-OD@
7._[^ZY_V衿/=`VWwV?'P2Ҁ?څ2LnTС p  WPQӤ_ a5 P uD_pz
q Vf^fP_  @!@.fZ>Pu&?_0@Ɛ =ËË}ƫòA0؃"r  V پ?y ҤuMy ZX^.t6Wؿ
	Ծ_R0Կ 1VS|
;uwq[^ؿ_y\aؾ@}^ 
 3 3"QcОV胔 6  5  QPcײPpⲸ'X1RСXӑq NلA?;u@بu[û" 𻐧ڰ[!
gf1![z!`3ɎAۋf @  r/@s*tCVf gf@f!*f^f[Ao;tw59  f@AA:uf`Aa Xh l  Bp   & @*@LN  QRS1֐P0Pf0 
0ײXP%
XXUI[@Q ?NAtЃ@ tP/X0RR@s~  q.mց<NׂX F `یN.L/.xɋF2K Bd߀趠ۃ^ !֓ד
u3ɻX0ZL֊ȵPN鰓u: ջP u !$2逾P  $WdaOԲ) $л
Pu轎u"Lt Q  VQ 8Kt
;$

	(גђ@Q@ZXt3o&p;ߊPEߊ2bKt ^6r	 wa w tӲ&$P
0NR2!uaH
+Q޺PXY0^8bp%Tt$Uh$ 0MwɠuPN
麑T R	 
t U߿6錑P鍰w}邑BJ{f3.O>f.O&%߲$*
poof  f 
45f..O>u%s%usrE%
p
 M 	<w б 'ΐ` t ҲV_B&EJw0J
Wΰ`v0J.$FGG<v_T2`/HHز80pa69C6"4 >18\/hѲ8&E695$&%{+W 3	 &OO_969P$p/:ʏuCP[@uA?PX,fۺ U!-@0+fOf'>u/вޒ/j>u/C$:+M>.[/&`8f0fmƀ t
q$	TqRIAHcEFуKQL3?3ۻ  DK 0f+k&qo =5KK0tЋ&1f?PpGDK۴QLo_Ak_X࿊f% pQIu9]t*V~ϲPPqGX$
RIq<paDꍀuznG(WI`J`J!\JPQLraTQLL&M@&EAkpܡaQLck\uoRQS؀〰	[@@t#fY;vȋZ;ЀgPRfQnZSXnaUWϿ"ku$,,γJڌ!-܌q^Jƾku?!m2ۨR0 pSq1ϕ[op'@qpvk	u*,k萚u@w
=-iBSk
l@p$>m@n$*klgvkmnkPQR $ظJ/ZYXً$< t W}& G@<Q Y鿋p 0/ul R
,{-Bpu~P5u
uu]EOT`q+YE+23!"Eq]FpB@Q Nt b03F0BF11
`
t0%$ݯG 
Su}`
$zur`u$
Eu $*/u6Nͯ= NdSP[
OŔ oo 緀
rȉZXâe;#f0fql&Meg&U
g+'p33a 3У3fu@s@*` fЁ  "  s'i2~ol P $Q  f%oH˻
% 
	Qp$0!(f@ YQ tpB ౬h%[pPX
Nð
`  
- P@-ࡳP`$? xa? -gpoZ =u?Gb	$94 $ `F  jjjQ%A}IɸG(/$ɸA 4T,bf%QP @߸@Ŕm  3 ߱Aða3p߀8tR_
ZPSRUȲP IXoZ[X pRߊf$f[_ 1f "gR23Ұ
)u
Z`..T un> tgҊb2P>bP22AQJ2=QRPN, 32sZYYy2 XaZYYR*8}2.TZàʠ11m 2Ku2W S!u
@j[+2Ê2+`**&R  11ZHuÚ 31"JÜB J.TcwQ @ 0PQC3BBaaPQ YXaYXPԨuXGN!+p܋.J
u8~ސ؀T$0<0tTQ:Jt. `S /B_+`*2+1uX ʻ u*tX߰ . |`"aq0׊4"
ވÊ"ð( .ѝSr= $dm݁ ? +Q,QVW++    %_^1YԊǊ竊`4D2_`8v2QY2P >I?tP
RSbӇ PL[[ZRРJ2ZË.ߋ2 03<?& t
u߈V EÁ~
&J
Zv[
2RaZ`Lȴ
1
t
2&Lp`  >&}S`YظUJ<t
@A<Ut2[ð
` 6w`%P2+Q+w+ZPȐ"+Ջ+Nu`p$` t  .	{t	|A(.o!8~
td\8tX΀|+I~D*p
8t8*t2
8~
~߀ȐF}*t+Ɋ*Ŵ
RQVW3ۋs  2 ߀!t  `ޑ5 _^Y@ ZQR2ۋ3`T445G  ZYËxs& 	r ;b;;<	 P͍`@>р>ff@xfd?`R"S[F$fWfVfRfPb;f0D+Ɗ2BafXfZf^f_SRPf3݋f0GZ2f[迻@N(wy拄f䊷&Iplw$KE|t;@7pM_v[`+pMovI#CERZoO@REAP݆׆ѐ3p鿆yKtwFsL餆鞆OP+>PRR+ZRhiMt_o&XrRR+ZZq7UB	~(|R( 詿&F +	u &F E&  AcP b+>2u	&}utGVW_^t!hut
>| d2@b!ab	|`\Tt1b 0	rA(`u
QcAc6JX 2Ba\pmSXO@ 2cҐFf qKu[q3^K~RqV|A?g(
o`Q:uCG<PBaFgӁX$6| 62YtmU ؊P hu)#ë0&Ni>Xz ҿă脡1{  ׃Pi善O 陃cÀ?t!&0?$ n&WO O8r2Ê 2aЋ"s1RaGJ@A~PXWQPsêuXYo_QjIY+΂MtM_vNov
 驂 _uPUP[l.5X0qVPQۀf|@gFum4XPRJWQQWj_G8v
 IGY_۰ ![KZѝ&%_G+B;v
@Gzr0 3òθ~_rR_mp<@XߚRWQRQWP8tXP@u$֑X_YF"Z Y_Z?_ߦF4ªūTҬ3>ct鋀鏀>
u&f3 f _f$߀ }
ؐJDSP
S) Dt& `&]{Xp!9kĴ !GĀ# K
0) y'C[Pm1T1%  !%%ﰣxѣ"WYX&EzKt
x3k%t-ϐТ2" v}~~YǊ@0a~sK>b2PI<
vL^5$IǪA8sZ y`ayt u2<
u:6u ƉH~<u>~<u
t22+t++&eP>IR7`P}}1y}߉}މ.U~F2O 3Ɋ۱ʰ')uF r}h}ﳘ 8buܰR'}~0'0kNV6}b$
I((!Q̊.M\t.;t$.
DsY2k^|#+3*2d!d"<{PRZXt
t
|u<s I.ǟ3v>QXptDSݢ@@v3<JnktÆt``&F|+`&}Sa 2乿 0ì밀w 0$&e te ò @NsQ 2ĜB JG_  /^ {Q&5&m&M CYj{
u$0k cu4L){ vS	 &w5& 
M
z` I@kz}4 {  0k^a ,T 
ztM9 )3.>P;PY d߀2| XRa ZSںpB|w [= SBB  PfQf  Ѿt%tfIu! u t	0!uM!fY>0 vu ՗!Zu {"$ .aã<t
yy ny<wPSPR2п@vo@	f`B=s=s=|s^=Js ZXj[Xu<t<tˊ~03@mS'[xut05>05B05Fx.| ~ xȎpA2..x 
*@ b%Ƚu- 
u08p8w5wp6&İ8 u͎..v=.FF xu-b%b)b-uASK`[{&G&g3t!:<}{8<}:8ôPC<t
<PL̀
&Gw2 eТm 0֋P$u"3ҹ <uސ: K?:ށtpI0o
PqHuÀu
&~Ґ@Sҁ[t (22Q@iF t  +YSuPW>&}t0&<t$8tGWȢ&E@-Vpf8_XF3tV_tu cWG8 u&2}P. 1pt@$
J	U_Ǌȋ1uXtHవ10{&a L2u-t
bdt<t FQ S@TUVJQWW>X=&]&M&U&E
WȝP @-XX}2QZPSQR.Tt	>0ZY[X<|u?SBSz5[VQS&F E<
@<
t2P<Wd0\p' t&^ EQ	[trs`߉-P 5t}	t2SU' ][xX[YZ u߉:ubt`Isx;^F6t<u	C~&t.:r2c.׋]p7à$0<0tuPtá
2.;t8~û o tpg1#_^ߺPAwЇtӉg ҊЉ 1   ?     _Ϗ3R櫲*$Z.g$SQSQ@Y[f.
uY  ͵Xu	f.> Ofmf.ߋŀt
uꀓmRwŬ-
PFtZo ?
.1(m2.OA.WBotW+A_t;rÀtwX耐
u򪒑.&hċȸ 3  u,1tpt@F 
ݸ]wwu?G@2@
uJ@JЀ@

@ 訫`Pګ@[ZPQ.>dNu$.dTrT/>9_SQf@輪[#H`) 
XÜf`KPSZYvt	 轱 2!wPfӪ[1fЮl	2Dg	
f @502`)<࢐20FP6f))f  lT`
f Hh
uD˩P o$ut fafP2ɻ| @P$虩T 質fP諁wqP𲊩Q^P 谩߻舀f3f ߰"ֿ@Ã"諿d1øff	ҪϪ̪ީ2p, $
 fXM"@m@{X?X@d@h!@`pXfXS.= t.;u.;]t3o W.uRf 0fW.e0FD<t<<t8<t4<t0<P u0Pp~.=@uuX5
X
=u
M_@E=@pXx ^}0Րp׼0p P@jPmm@{wj X--   T ҿ4t~<VPuJ0f@.MtM%.M߸ ߊq;{0PPAOK  XPA֠P  $G蘦|$P2ק$-·$k 货$u $苧oWW PйW .? t.9u.9Wu.G2t}Г32_SQ.iɊ
܀ϳQkp<[QRS$puskN2[ZYÿhw.;WtГ3PR~$Z#Rm%fSfQfR蚼 t3t+t#@t.tpt>tD%ffȰ+0ff$<t$f- < tf+ 02f
 2f2) ffffZfYf[V@24ȴ2`.Df3ɋ% f{ f. UL  
QP!mfff   ! qXff;t9
0}fX!"
E"0a'$3#O@ް
Fb ?=a 4m0+0".^'@C)+`D뺰E溰FẰG.F+.~0 Яط t%tttt	t蔺菺߰芺 |PsC?j0a 2Xq PO'2CQfX^    = Y + s"+"C p"Ryou@:u	 .F3H艢p& Hq&'PNf_Xfp&'	(2)^p-.~1pa

p&1~,b	s`ðqtfP
0#)4٣@)   /8b00ofPRQa'nupRP`03`0q&H`0XP`5v5l4 _z4	`5$Q4`5,C4?L6a0p&=/T'b0/X:^/\:/`:#fmuo ] tqt= tߊ p p 
uu
߹XTtY]IUpEp~Mx<~	<%pD YtWE`GN`> YZRSfPW1fKQ&`>.E_fX[Za224
KF
 1 #M￸<5}IF; 00q(;; > 7POQP 41  )088 OYQI? C:QfQ ·n%Z<t0
 
0Z$ BNpE<H!\;0N
RP!00j X2Zf
  P&F.fΞP@)/pac  f./t acK/0ťyte/jtef
@ SPB$WXf% b i  [/&4d0q_ZY^ҕRVWtVV`ø %3ҿ.;s&@i?0.\P?ËQ O^~n  o[L.boL.o2Jp0&qqG_^2SSD4o[û\]w{w벞`uSw3x띰 w cy@൞0uYX@Wr`PS2 .
RPJ3XAmfW+&G ff
thf.#\fߑߝP43۹#fC fbv 	WfVwVჭf
`-Є
fU͇ܜr_ X躜f^l[H  $,48 DLPTX\`dhlptx|  ;VQ  _    ? c$
k*6
mc8*1 TT
  
 !c!1͚@^#
AQ"  @b @ rT  
  @ .PA&d!   |AEs b}Jށ0=PAQ; Im` $aP 8h.!td-4}A`삜Hy^, y-10- =d io"z%@A#o koVҲW̑` sqj P"&O۪¨/odOG` ) '9qAҲ [GTF+ A 8/~-ҲUp+,  z LmLҲQ\G(p# ' 9   PB ( 1Ҷ@:  # J Ϛ/
!(+ h(,1PUaC@U? PC؏'Û-'.]hA,,.֏
e1^OPT0]$[]`UU  SPQa7ސ$^_R2fQTWݪPP$][UT1߀  !X |1
w*
O"|1
:?"c0"ԭ@rҲz 74H  pSZ 

3sҲIhH  WF
➐wTH_{{ #ƶE) 	ë&Ҳ~CW;' +O4 ` O  ! H2юOSA	
(THk	»{ 1ŢOB  jҲ8~G[T 5 AupΰҲ \LG  S% 4 #7P ΂Q-ҲO`36Gr  &5 !$β[̳4S> oS pd\Ҳ^x0zp%6c#@~
(Dд C q) XмPG'+V*W+W0a*/,c=. 2w.*q., 1103r31`j2aP/6335o@274py4Ra6Va:5Wi:"5So0/t<>`>k>V).?_{ҲGT@3F,FGŠ3FIfG= A-YҲ+^zp`5 a }FyҲ_) >8 # A|@ҫҲթp)+ !*Ʈ@R SfUT% _A/FJ[ D
e\IG^~WҲ>
w}pN`! Q^9y RN STɖłRR/g@ )QU"}N\Pc	p8 UĦFҲn,+8 u- Eβ1̳yO`= `}ϭ;A !; 	 Ѯx ym{}ԟտOoۄܐ+. 18ݐ,clްS޲UA8b9,	 P$&/Bs>TUg$TV N ~@  0 $ 
t腋d  øN = Nt.x& Ȏػ2؃? u2A PVɬ0	8uĊ^X2t.یې؋7tP۹++.' t._'.G t.((@.?tS?.EtqECCRPVfSؾo.]1f..M0f[^XZРf9$
p
̀ 2P*H$3XP.E6ʊfѨp$
^$	
W$.e9
_W=	_L.]9t=6lHhfPfQf3.MIff @af% f迬fYfX$߰ $. 8 $Ьߊ R脋$C =%
Ĳ`=2.E.w̡0uf3fѼM>f&w%u

o轉2ta
蹈)$
ûG$<ۉ$< R苈ZP
XހWRq$Zr`%RRR$ZWР.E#_VQSPQtX q$Afذ9%<оf= t*f="f;t
 Pŀ~ f[fXΊY^fPAˁf=qu_fX 1PS1$  Bˁ}@r	脇T_[$Nqذ@֨u$@d
莈$蒐t݇"QR1uuKm ߵ肞1`ึOm@`l.>kou"L0%1读 ZYW1ְt]3#$Wv
QˋM,ӝtv@;_1ۮ@qأްٿqՇ$s0&m0$g轆_TTt߇$߆P7$ !ش @( |f Rt^PTYOF$fF"P赆 ߯F/-T虿F(2&P贆[?$
qsm31DUO?uBF+ 1m$
F+qˆf$
FT ~P х fF6᳋F:|$F9h X装FDB0ŅF)F*F4f ׀352^w:2@њY[u觢Y03ۃ0 `뽰 $J f /f J$
ffu
` 
f_fu
 
f	
 	
f	ﰯfu
 
f̀ff`oCRۧKAkeMGτ=e3qÄ
݄ fq  ux_ fX΃A%$荃u0Vǘ	@WUF 2F E]u	FfF6~`,:ҕY._VP , .GF6XqaF8XHf%~AfF:fXb//f=.f	F:3F>F@Oj2E..>FFAu_
R P0 q= u;60=Z	SRW =Xt = t
0:u.Kʺ!.= t.u3_Z[v~4   @>D>
ɺ""
ĺWף.Et.;
u
.;Uu3_PQR8;OZY`DQDtMtDS2t	E
 BP6Q.p5.%?F"0+.
IF$FQJ2N*̀oKN*IoF GfK)L)N)I+$fF 0@f`f.LN+ LF
F&pQ2.O$?F($FP%HF-F%
f_f.T?F/FbU@
DV.oN5P.G$ P
Xn TMcUF~f	f	TsXY4cYw Zn T+ M.V1SFD[UWcKZ$F3?fF	HyI.F,3QI0UQf..gQe`JFqe0@e@^eFrfe}fG	[ڡi$["j
F0pY \ F\I
qVbl GblpY0^fk@e`fnUaoG0^S2n4e|APe
@epgpn/
 _Rerf/f8 N	k n0V`N2AVBF0 F.   tW訆tR-_:A.:.̎0d2 `{ 12@00	F2+:h,23BFD(u374Q5qc a2 8 < C F H K L U Z d x     ( , `D|S$^O蒡Ft\
F u	F=b^~.Ff.`'΋E| ~Nn.X wf0
2}}0	fkA}Ցf^
֑PՑF͸{}Hg֑  Zё Pp6JґF6tP7<S2f[|x{ёXf^߃fٸ4|^r~/ 85^ `8_^5PF=$1 O, @)t
謝!3ZYqá{${r{%A{Rz1{$3ۊS{
[{53_H4_SQWJ`=zDzKE_z_Y[>Rb{#RB
t{  RS200M  OEM INFO!-_1024x768 |  
Ĺ t }    ! `   \XT  @^ -dd!-S0'0@ %]12fd!-; '>]_1  
YJ @Pl%ÏJ2U* oUH'Vk QI!-ORG<>]Ƀ߁q2D 
 X{͜1[ ʣW2"dw	!-Y 1>}WY2 @QĀ  ;Gɀ?{b A!-g ? B "АȀ^=`O`j p0w R À8Uʚھǀw%ڙnΚ 	a@6ΚڕBa`{LYLoΫ!- \v@=@4?23<e?Aӣ` s8c8t!- c mffӀP̽,i,w}!- i l
%q(  3 ?_x?Rο ?_ǟȿ ?_Пѿ ?_ٟڿۿ ?_	BB2q,  2ATI  ۱Ϲ:;#<1COD$q`$^sPS3۸ .G.>s.$.*1INI??SQP2i.N= NXu2˃	w,.'
t #jPBgpDPBi.&ep pGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_      t     G  T  ^TI{ jP  RI  oIB W v D } O  1BW 1D  PIBmWbDaoOB QWDCDM!MD ?#ME 
%F h&S bQM{ QC !'K (U  j*R  |DR 
SR 
CR 
B  BLP BC BE BD pTS 6.TC PRS .H  /?sDBG,0WIN[0OP *0GCR-)SDLG` > ^ Error
  ?_  0B2  Press Enter to continue  (CTRL-Z!abort) ? _!NEAX N" "L   OA` B  C{B$JEC"JP% %#K{C$FED"F' P'#GD$EB"@$!#6ESI 6) 2&)2݀* :(P w:P
 >)+>P, REI+R0- VCS0#0Dr..)0#,S.w*F.(G.ZF#a!rDR0 v@11 z@12 ~@13 @14 {@15 @16 @170^KCa1f 5P2j 52n 503a!"X#`7#b$3%Q% 9#&c'`p:8(@8!#
)
***	`;+	+l@<+,"---c.ͪ.C/ݳ/#00ŀGDT ɀICLCT
!5pE23~W4NN a!wBSGJXGF]
a!6bG2gG:{lGZ0KIV:a!R  G,4M>M0qG.uO*yO(}ILIa!"= (SCSDSSIT!UBP= D]ST= F VG VCS:IUSS:@,SFLAVVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=GvB$[zG$[~LIQ$[V$[[$[`]eb!p$[x$``QP1UR1b2b3b4b5b6b7VCLimit= , Base=!1Dte^$[f$[j$[nb5Vach51jdvG%HHVI
JMJ	@KIٖOU6PPvQMMVNryKIŀGɀtuOQ!Vegh^f_la!C= 0D= D= TR=kl!{{P}/}  ~  0>  | ߄?_ ߍo}~π** Divide e Invalid opcodeNMI (previous instruction)Break on SMIDebug hotkey ssedSdrg invoked via callPOST tab}lntry Tracepoint
 							

*
?
EXEC WRITE`RP  _ACCEQ/A! A BY2ORD
Dpª𛥭MONLY î NO?TRACE `{0# Disd _RealMOnlyEn"B#NO  INT3sP`"OT TEMP  OFFONeISABL ENR LOC#  SERI#f CONSOpRE20cc ս CP@
@sCT!Ҧ A]LLIõyo\oǏȯ0`Ȏ؎.V0| 5 tU0̓͆P>t:o$>U.#uG6J557 ѿqs
G{7} uVRό4"$r;s3|7۰$ 2 PSQRp.c(f._f.f@٭Ujٱnٵr
u, t$.t@N u% ;t	.^ /uϞPӵPCrt..9Vt!pc.툑!wv   a{ 0ֳurotib aa
uj. .>_P0u+.^t
u3t-t._ ;C 3u'߀u2_".  s0d&Q.ZY[XfP.^_afP`r"{>t"e"
w B$? 8 b ",  %" L faù   Ptu
D>=4 u	0rhN
	 :tw%3t3sT4= fPf0Ka}p	bҍ6U<uf.R=fu<=upfffDf.0
?f.rސRfCf.a./c .3Ӎ!>/d  /Ϲd  Ϡuf366p;ZY{f[PSVW< t"<\u
<nuF=3<~u s2*3_^@PS>:FsI>%=s@>a4s7>(r;< u<<<u2B
VM5'2^@  CyclesAf(uSec= ) ???fQfRVϨ u\@ًaڋۋr611ftf+fxvfu	61ff331f.x082^fZf .{݁Z<@ &Z֍J PQt0ϋc 2r	12tYQ 
#2'|##	 y2s
11t菟4r_^%W<;t=@"  ?@ $3s?v4u1rw$0.Ws_"1tT!I4u}1uP	
C=34u2r:f{ s2U1t 2r#D06
rQ0b ] 3 
4 5  1t-*3ur2r,D0$0t
>r.d. a г3Q@X\@	Pt5.R.;Iuf.;KtU\P06XR	r n6S p
ft<guX<t<t<ͳuL@	04t	.TS 34@"@1s1`/@?0֗Í:oG FFsG1G%5HUsGGa5HH Ñ/tI.> rI/rD/0 H0r5} ufǿu%$NNufP
ܠG RPpMSe [R6[SSQSSzG[b׋ߺ*a*/0s+"@%u/|-/--.(fpװ *\fW7O-@	ffGGt
S_9 [Vw2#-^f;t]-wߗ-G
-
PYfVEf3Ѐ?t-#.fGfsGbs,c fSXMemory, I/O andbqRs must use hardwarexf (0-3 ->Yr#-8]..N>Fr-=.뢙 l6`llmrD	{v m k-t.r__j@ k rk.՛k l@". f $- Gt >i
 r߈G 5  /! , u
0v G}pw WQr{W\
f\GG ,r u6@	P.O>
 rGGvs',tjd r#_Gzt |6f*3QM,r0fu!0P<upт0yQPY)U*c*i0_V	b- r' %3 `0P0͙R G+r2}tn  0SrS͓Gi]r
+r:1rlGQr+r$sm1r\+r 훱R .+P,rqss
6-u!+u PXYiP²
 fries_numb0 PQS ҈36(@	џτQ t"(6(.'))%BP#     0ype= Length= Bas rByt Trac YVW*   F(()u1?G`l!t )6o"(d@_u`  0({uJ 
Gw>  }'fGnat;)[	(GO(:
N(]0&)(P%=8E}	  Ѹ'(BhalPdy active. Do you wahto repl ihY/N)? "RVWU@	 t*@	.b 6[ w  rwfbGff.!!Y}t 	P}bOff3
G
G!3{q΢]_^S`pW؍ 2pFr{_rWS*
qg7 sp &Q q߈Ys<s8f Lf
u b1a`fSofthnoސvaila.
nrG w`w
tBtq u
*D u+*@_T r@	]; u629%P>&	XQU#_v`1V6@
 5|t/fTf TCC[./D.PGIuQG^` 4.D9Ou.Sq3)A -!{a`0  &	>VWQ Y^_.?@a`2 R_ *C={	f9Ou w.s ss݀PXa! ۶Cʄ
`".&^Q@L$ ù  o   P06.E..F 5 rGpGG0A$r8Ȱ|5f}{o##/O# = ~M#CP$39:0 r,pG;5@$tޒ	r0=G$r
13W$ts
 u	rcf=  w[3T}%rR  LwJ#tCi%r>psw8#t.T%r)psw#
؀#r#t_6%rQ_L Bu0, Devi, Fun@on= 
 tx0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** Errorading from PCI
 !  !#t+%tC #t6% #  pC  uR? +3ۂ!E!FfpCA!LT[s2!.!]Et.. pTp vt`[ p
#C vq#`4<ra
 a3~3U^Nx ~@v  ^xaAr
u!! @ !°!1 !B;Vr蓅!aWQU -  6 ! $s+ `,$/e XL.:I/.l0
 A0hsu0hU9!u0<# ;# fС"D4u
4@L) ;"#f.##@46`3`85vf`306 E_"f0z"CB-.99ud>p/u/ xt- =6)8w.#
t0 +)+# 3"qR36#..VW."@sp36f=qs^W7?s6E$k  >#󪔲2`[7(.# .PACr!2A&DD67@JJ/ |0n3$6p3$
4! 30q:."  9%9:"j/'ÿ] VW> %_rh< u
pV}@V @WtQ: EψqX@ +r6%&Gf."p$p$rS" .Rs9:}lBC^@
c65EIO"uPFoufat physical address  NPfxbԐ! ð#srk SOS2;tf8x&ps u2pu6;&>p3~rV&}%j~l6 }eh;.MemoްcompQsu;cccfulԀ_'0v7hx@4&p3|r m*!iip quf6']p7?f@g@p3z'j#w|wvwtfHtrh}@.y'lQrp5tgT4t[|tYrTQ
 `35Bg8xfqS vg{|l r^}U~I3ɍ>tA<'tZ"uج@(8t$ s&At!_TrptChecksum= k r[}3~Fsfghw> (wj[p3~=Np5l4tvv rqQ!Rt]T rp+`\rF2w"I<Lu4Fd r|84v.*#t5@]SWfl>r<:ufF	+rfF>	 r[SRir$r%} u`
frZ[p?.Ϣd3<*p3>*!Ds<$煩  3 .RՀƓVQ.04*lB* uV pKJ.B*?ro0*wH4* P2zr& E@ r..*k.8>*_#9 v~	!vD*9Fpp3!8*`4F* sQ`SASШ>:@6<U<q SFHpހR>J*=.6H* 3Ѩ0GJ* k@\DoH*?F*`.498*w
.B*D*NiIܒ̋D>0t %@  .;puf.;u>-(sMQ.l.f`,@4u ~ǀ g tPR»uIJ9t3..>ֿE.pV4m=!'"ï0 S 7 I.;Kt2%IKf`p;R3;	=>S@ԡK.,6S 3׉򥀱.,ޣ<`@\RFX@W@\۠ aCPU Time Stamp display= Speed= Must set s to ena_ble tPsP1BtJPr	d`}=@h.v&u&>rN@<uF`4v .{2.~ ,-n.6-YP$v3CӋBcbter =   uSec t
r!qh6o.xp.Í>'rtGSrS `<t.&Nt#>/r/.< u8t">r.r
u
#&
* T7argis@rt. Rs manually ifQfails6i/WMQI ˆ9^V6'~F A`!u`e@66 ^PQW> %>U s_YXLt,[r`@10Ur.J b׿ u`.& $rL2w,<r(.0Ur ߵ*s	 b@ 0@&
mkw
 u	1pW	.M"M}#rp.ݭPpMfQ__NPSٜp?ɝ`5P`FAaz· kAa"51
 1
 ?W.h
@i&(a
M̳zE"10sv$:% u0% M	gø6C	>phr6>niSn;;K;I;;**+o-?._/ 012346?7_8 9:;<=??@_A BCDEFH?I_J KLMNOQ?R_S TUVWXZ?[_\ ]^_`ac?d_e fghijl?m_n opqrsu?v_w xyz{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨЀ2g22Ѭ}[pW>2!2 t>6p_W} v	 EAC r3ۉ_P_rS t]AMw][P_)P٭
ЭPX
2t^𭢱2ѭ<w.2ؓ2 [SZrı`P  ( 1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?j_`!?`	3f<u.3<xZ.3<Q<
23< E<
u.2<.:7<u 4 0<s+.2<" &8<1<rÁTapu<<up08<.:X "3>0.?>2<:A$w4<.5b>؊5<t ˀu 8or6<7<[ø.1<.&2<@.=<X`E݊7<.*6< v&.6<#& Laz*3<S
.#!ԃS$3݊0<aR2< # ϊŴ* # 译K`
 a	AR.9<
 Z;<ZÆwBB5PV~^QR 3du t񰰱l`$<6t<*tPu.A<

y"A<
x<Cwp.A "B<<ڛt
ArZwG ZYA2
 d0 R7 r  dI r`.@<@r` d`Z	 .@<`a Qpt
QhUv Yuu#s3s`8umPf`8<!O W !Fq@ &} tC	t;k0ta3	h &c&E
 ظ@	 P(^ X @Wu-  ~pfaq`tQ"OA _ Yf`RW.OA.1Aw#.U! 	tff.PAƽ.TAʡ_PfXOAu.UAU.TA讽_f.PA+KdKK|JJJ9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH"r.A$$$AP <t<t<
SQVWێA<t<wPXrs<vA.A>A &_^Y$$$AQ Y8t	( PVtu@I0
<
t X2Qt .Qȵ$0<:|up06ff6PffXV/pϭo
p0^Vf38
9f^ << f`3Qߜf
p  >COCrf0f3ftYP0C++x@2 fa%

 CCR3 ۽CPE1< tN< XÀFu'Vu@߬<0r/<Zw<As<9wA;t^<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3! o!.SVW31rKt	s<<t<p; <w
t+&<Ru	& u@R< r KA< u4 _KPP0PECPEOI CN ۩ C1SQWU3t!;wOQ
G:Yu
;t} tۋG]_,rf s ZYf% r}s`^ r
<:uft_]Wf33ɋ1 r	f
ANLS:R ufP0wHa^<fwK,W<Fw7<Ae7JI,0@]WfU:af>fP3 fX`bfAN0\ u3d
df] Aef^a<'u"PS<'t	Ab3dk"eNt<Yt
<NtNP3t8tNX':*򮿋HH,
uÊGvO 7ÀM=GCp2PVWuu w_U "$$Jy$?y$4y$)y$y$jy$yAqA`T P G WIN HHHHHU$<w%.HGu~xt;wxߤȰ
r3Y]Kxff   `HB8uĀuBJu*@u
 ktgB$J E@tgB/AJ
 S70Zfb0z$ (u#QgpJ BJQB 1䅨@a SR1bNZ r. $0P@0m rPrfЊ  bH t$<+xbH+
JE$<u	f pgcHB칝1`hCBu"J Cх J g` t t  ARڳrȀ $@$zчЋaU$`<`u`u uR
 Z- ' 2
JJr.JПAZ10@ρ r@OMTB B |ԧTR0ᱰw r"5u<۰PqԮ];u1p<t) u0JХ J"8t	2 ЭhQÝp J#?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_ ?_  ?_	 

?_ ?_ !?"_#$ %&'(*?+_,- ./013?4_56 789:<?=_>? @ABCE?F_GH IJKLN?O_PQ RSTUW?X_YZ [\]^`?a_bc defgi?j_kl mnopr?s_tu vwxy{?|_}~ ߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ ǿ?_ п?_ ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_() *+,-/?0_12 34568?9_:; <=>?A?B_CD EFGHJ?K_LM NOPQS?T_UV WXYZ\?]_^_ `abce?f_gh ijkln?o_pq rstuw?x_yz {|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ̿?_ տ?_ ޿?_ ?_ ?_ ?_  ?_	
 
?_ ?_  "?#_$% &'()+?,_-. /0124?5_67 89:;=?>_?@ ABCDF?G_HI JKLMO?P_QR STUVX?Y_Z[ \]^_a?b_cd efghj?k_lm nopqs?t_uv wxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ȿ?_ ѿ?_ ڿ?_ ?_ ?_ ?_꒕ -RQ	 o 

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs?t_uvwxyvz
Compaq BIOScope
  - Skipping POST breakpoint
szB pz+~pzM~pz7~pzX~rzJi  2h  > ~$@b!@%@)Ԅ-Ԅ1 @12Q ᅡbR /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯDBEXEPTN˰DBWAITCMRDCPUREG(6RDDBGPrSCTRP^MEMBUF) CMRSPIOPORT5AISPTEXTˆ/INSTCODEI*SMM!GŀdESETARG˦/ UMEsWR+WR,Q#/1RQ#AWR) Ds/˿WR)Ԋ @T T  ! !EOP
 / Oo/ Oo/ Oo / Oo	/
 Oo
/ Oo/Oo !˫#m#ϳ$4%  "#$  rpˌȎ؎  F߯.UfP.>A uWP.)G f3.U.H`,I`,O`,M`,N`,E`,B`,C`,.. ,..AXfX *fSRkP.Bug01)u_`*+tT.T$03t?$.040脨r'`*UE*`*Dp204r	)`1X
Zf[`001M01N09PS tatCu?`*L*7hŧv t-u$ظP hv;hs=)Lp:r S6uE[X`*Cp2'Pa5
.-> t
)0A VXPs Xr$$
0
/=
q>)1 roE`C_x 2G G hP~; Hs=CruX HrTh7;fP f"wqJC>
 f.|`0VQ6'?1A60R Y^PSQfR_V`*U*(&\f&Tf	 ^fZY[XðS3ێϹ  Vp@s H ˜W0 SXX#YUXYX	Y @B32uT6W`*B,`* u.>B.P_u.8_t.9_R@g JP艁GG }ay}rangac\aXQaM}FaB;a	70a,%a
!}aaa
 f`(* >(6.> ,6f.R6D.VffXmAmZ Пf ?buf.R>r>^)1Q1QqZۀ 3Pqr#svPsȪszPss~Ps!f%#6 .,.>>66@lsv6. vffaJ fpO!f%$uc0R1f{-&f 0 &yP
_.QXPmqfZ$zVs`*Bsf%'f
 y+`*^	.Q~w

z.|t}u..G`,s >s^ tbDB8S+.&Z5JxU .Gu
`*e?~u)`*EKp2!)`*B	) .c!h"T~
fWz.6V.6Iwf@mR|Kf }6Of3ffS'ArMotA6 fuD>Q
6ˇd 01Tt	6݇U  } 4tY=o.V0vg&;pRsZ^pu VVW>ˆ蓭b& _^VVWr>r6> _^V'ɯ s0fSfVfW)>64rt 3ҋ f|ݠG 
t O
?tw= ?  68)< 	s0B>uf_fVfY83נA :r<+u<-uPR+ZVR-aQȵ$0<:|uYX@Ju @ l>@> U@vu@V
lrS- w|Hro1PO
8rK}?rDer)ߋW.9u$% r$QqSVWލwP <r:D9Gu-D
9G
0u"ZLqt.Ws
F_^VRVր? t u
?3^VaWU3и<r<
t
<
t	:tuEF]_rs r r
ê<fw<ar,W<Fw<A7ÿ<9w<00 L0QѠf33w-.-6/mё)9/'"p2Yc0.0Ӳ>ޢm
OֺxӋ6t>|.s<u= Q> <u 鿅 <u0hro).> PmPmDQBҠ w?>dۨ؀ `*s!?^03B>B蛓FڤSQTpg&CX裤W )}q鷨J L6Mr, 馜fNfOf_Ag&?2fffXPt á#?TBPme2f.;ew-  r%Q1ਐ tfGɷJ>8 r,vf2BrmAVXTT)@ r ,fffFgf#K .䱃@{S2T~3?aM`t
`,ߠ ,ffV&vPmx@Qv"  u߸ $t.$撱 Q fU.E.9߂..F.:wGP;A5ŋf , tR5 uuufPm=R#f]Ѩ9@Po:w;5.=[ ! f4R RQ 
	`_Z Z\$S
Ｐf  X Z0Sf3[ffÊ$  ffff 1%0$`%߻Ӧ R&%   $ff8*** Please restart the system manually.
 xL.<t$
@..
$!/t/_$0!/t/?DH2撍6mR3PI8>Ko wQѠ ػ7f?{tuCkP O ntJfq<4T WFOPAtOPX >~ XTY*\~YfPQU T9GPF >J~us
, 6=A> > POXpV]Uf ]ayyŀ8Gbؾff&f&J!KG>̀ fG`GQa ATIIPJ6LMfWf>҈!_f!QQQQff4ss4ttf~}VP6ҧfasPVAVrAVؠ0h"3PhXX[ÕXڥ/<\$<sYr.r@O C]CAp?6t_r@Xπ`?`UAIJfQBEn}S  gf +u}
' u d[P}p&r/ c@CXra Jg=)xxPe14l 8lmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo  /Oo	 /
Oo
 /Oo /Oo !"$ /%O&o'()*+- /.O/o012346 /7O8o9:;<=? /@OAoBCDEFH /IOJoKLMNOQ /ROSoTUVWXZ /[O\o]^_`ac /dOeofghijl /mOnoopqrsu /vOwoxyz{|~ /Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&') /*O+o,-./02 /3O4o56789; /<O=o>?@ABD /EOFoGHIJKM /NOOoPQRSTV /WOXoYZ[\]_ /`Oaobcdefh /iOjoklmnoq /rOsotuvwxz /{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo /Oo  ?_ 
?_
?_??? fRfVfWfU..f.6. + f. 's 6э>us.a +C..+.> uj.^q:
qf.f=   sIqOq r.q
 .+"s q6 ptP#+#`$+pĐ Pf. "f.f]f_f^fZPSQ 3<dr<gw,d P$<&Xu
 $	,<w .	.p)N.Y[XQ<uF$<t
.? t#;OtYQRWSVw*t^w.;t
|u. >
эf3EG..fEfGpЈE
G
.f$ r-/t8  99- 9.Ѐ tZ8=9? :@;P:?XthP[G_ZYrepe  `>n>VW>S; t6Ss?1@CsQ?r$?s6A-`B+ 15GCЃ} ;, 5C7D s# qB`C	ArvBr_^ rE<PfPǋfEEHE
EEfXSQVW3?u-6qCt6#L6QLuC_^Y[VWf6Ї
 @HF`CÆQfQfPf$FfXsRSÒ3 Eg	7WTkUfQIffD$70W?uUcT+9% si}
uFoDdW+pWZE_}t8YuS uN~T-fD7  !]6\0u]07 ^ ui!]Yus]{_ KT߀u#8
fɁYrgV1gV d/u8	1cc߾17,R0JfXf 2TQ߀Ys0cYsVctfY+5 /j7 _"kk[gkq8Or߲Wm_lieoaȋTq8s"ns\fEVVcwD1SfönmQokETf+r8sx0W7T*WTߥ:dν fD@@'4'f irfe  Y2pV~Q^ t@lsF蓟N+r]Y
~]ym3w@lD tsM| /u
!9z897<a\!5|6^<uhs
`\ f!7s1kq8sk8!~Nnj	xj95bP:5i3wj+fTaB{s
qrD1pJg-kd
*fc.`vX~Q!}B'?t@R{f%{s@l"⋰Oj嘭@lq8wAsW-q+@lw~oscT8p\5?VF`^k5`K95FF<^jdR{w!mnlAWjPХ8VYpsVr4s7Ar\BnХ蚐f!E~F^Ë tttk%:5n7sdu1n`o¬p qrsTT%=upWqh-Vf$&?	!(=(tLQ	
v+`=urn2$n0yrSFtQhٻ0<t`1 (ұrn@k@l+1| 7u Øn3|}3k,Cm|`o1iVq$fedwOcDjSFjd8kn45>2cT0SG iAy!|sdgw@?G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsicdi0phrTeFbgOCf_2J0#escsssdsfsgsfWP DVaX
<P ݰ: tͫA:ArAⳔ`D覔A♔ A4  + *2+*4+*8+f5k-JYsMɟȁpuJføtsPørc@d
t?oslc#fE~{tЎ1 `J!%߰[B
۽@lK!߰]rBW!p2P!Fb_x+si dpp1B  }߃߉ߏߘߛߞ_ ucQ s0cE
WV6g4Fg^_rg tUY	P!!s
P! !M
fwo/rd d" q" " tbyte %*/r ptr c #WV.3t"h6@:hs6J,6K&Ys#[O0VBOO_f^f >eS fXPXP
$0<9~F[!J!JhD
 s봰+ !J$ CqYsp8e+s߰-шsf    Pr Pr  ޳ ;  r_   . `rx   $pr ' ]3( ,T/ 0 4T7 ^8 <!T? 	!x @ 
 H $P$X$x ` Wa 'b  f@r c &@r h ( i +}0 l 0!1(m 5,n 9,o ?,p Dwג+q G.wr K.s N.wt R.u U.wv Y.w ].wx `.y c.wz g.{ j.w| n.} q.w~ u. y.8&8ǀ:0:;66;: 6;=(:06;?8:  |}U.  B  ! PC: C  Q)8vے+ !F  r !   H ' ݪK H ݴ.# PCٵPCנN  Urw O AT O O O H H H H n! PCxLM?8 q)pXXXnX  X([8[  ROp]I E  ^8PC.ȿ /1( ]ːaI #rcb+{ 'E^ ,KW 1A^ :УX:SYfZfZfc[f\f\ 7eݒ+ ;Uk ?C^& D. Kn Qn Vn  [w ^p IIN  bDrrIr4pVp`quu WfE^ kE^w qE^ vE^w zC^8Ab`py~yvz vz(+z0vz8sz $E^ E^ E^ E^ E^ y`$z|8fܓ b}8(bՄ03FzM  ׶ 3`,?	 0Nщ ^1   A^1w 'č	 %e@+ T1Rҋ uҋ  ֥ ڹ*1 ݕ ᕔ 啔@w 2A 8UwB ?UC EUwD LUE RUwF YUG `UwH fUI lUwJ sUK yUwL UM UwN UO T8 o8(V0V8T@P鵍 e  Ee.@r1`/䧂0䧃0䧄$p1䧅 2䧆2I3䧈04䧉4䧊5䧋@6䧌$6䧍7䧎P8䧹 93 e1 e2 e0 d8 9ҡ {  w 	 w  w  $w * /w 5 :w @ F    Or!$  e K O8SXw ]ƻ0b g mkp u z (&g!`ᗶ䜶塶覶髶m빶쿶ƶͶҶض޶0(m
ܛm&.5߻:?ۻGLmRX^eGrklRFpsutz q8 ~݅(60684nuРq0(Tg 50vf83g(lRF8ۻ8u% (m08$fcuu8 D8$0 0V   
0{ 00{V8 dҰ8 f {s  txMUadd push pop or adc sbb and daa sub
s x
 cmps inc decb}aa bou
arpl imupnsb out q jo j%n0c@z@be ja j @jp@`l jglg test xchg mov lea ncbw cwd call waitbff KsaPl@s!s stos lKodcqbbbRb rolr rc~ cr shla@etp@enteft!o iavemd xlaoop@!#s#xza j@lwockpne%_e hlt ct ne div i'clP
tUc (i i (d dbx1zx lUf@g@sl0)hrd bsf+r btp,s\p,a,c i,x,sep!.`.p..zR./.e-@.pR.1 eQt 12b0gr*Ul*di14l14_msw l -s!4Usq4s4s5s -wver6w ffchs fab08tfx`"fld119l289e19pi9g29n~";z f2xmp9yl2x fptkan<a<re1<xtrac8sB1f>=S<pp9sqr8s0frnd!f@@|7Aucomp7en:dis:c[le<inf1 9B )fP@1esc19env19cƑ7stFGaGfreB8BB0ArG"G 5fbEiEb>>1EP@@CG12E>MfiBIaO"LaM'AL wbinv+wa@oQ`RARSzSRSR RUQRlQ DVTg!X8@puid rdmP,rdp&rdtFrsm ud2 wr!Zx1 .\ f\ y}\z`&^w{&^|&^}\&^%^.s\x\3%^3%^\}t_.\G&^%^%^{.g%^5a&^&^a&^&^,}(%^-)*\.V`)P}S\ \%p[&^X&^}a4s%^$%^<%^v%^ý\t%^5s&cxΤ\|\5syw&y'5a{t%^$%^I~{a5a5sQz&^5a|\fe{$\
{
迵z%\׋c~}<r%^<m t%^"y$v7%^&芵z){%^+t0%^-e{05s35s6wQe{9uf{;me{>5sAjDt+%^F&__JdL{%^Nt!%^P5sS<e{Vu%^Xe{[%^]` z2scHf5sie{lne{q{}vu
%^xL{d}W{޵e{w#\P&^߉O\e&ϐ\ۺ\WuuY&^\ur5s'nڗt杪~唱#tN%^8etH%^&~  6 f3 t3Vv^
j
a
SQW.8
F  1 [Fn6F?f.a
>0QHY.&f.>R[  t8svJ $GG _Y[PQ.>t7xFYX8eF N!SDr [5߰Hz QMY5 FJ2@ M)FKEQ̘R$ <t<t<uE* mfSùE' ; XEfPQfRf3 3JFfZYfXSt[_A B C D mP Q R ۂS ABCDóPO݀߁R߂S߃c?[ SpWP.@ơ.X.@ʽ u<u	L <r<w,@. <  .>
  <  <;u.À
s.p <0r$<9w ,0 P.p`ꏿ
 Y.l<?uf.[u
f.&^aR<[`Ow?uu1R8f;t'uG⠰ o._p	  i hǝv ? h=Ȇg
Ȏ`Ѝqڋh{ i
  ௎ R0 0o  Y  3     DSDT^U  COMPAQEVON800 ~@ MSFT@[0\._PR_CPU0  _CST PSB_C000@12O
?
 P y 

}  z	}

	
dA1A

\@32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 74ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdߤgD5phg	gi
 A6gA7phpip
 fp
`'ϓfg``f bC7f cufvbc@``A8A9E
Microsoft Windows !ME: Millennium Edition"s NT C@AF
v p\_OS_`p!g@a.Sagi'Q`R9
bra
q uah'
 q 6b'
 s-%[(IW`.
&2/ p
q pq A8_INI AH@B
fpig
f
 pi0 4gP4h0 rgfata
apa`(ah`ha `a u5
 bbi`ibD7ub`\[K
@C_HIDAJ	_CRSrD)
g&	p 
 `<P P =<!;
 C010>0?1t12?7?0?3>0?4py6@5
.,14t@4AD@ 016T0 E7bE8E0?9 rF! FADG  G[0?B   
,[I0?C 00?D !?8 bIECA [
LFaI20C9?@[J`:N21 ?22`023Z+AO4M5+k26Q7J00Q8Q9QA&2BZ!?5`B2CSDSESF`B30 YE ?31@3133U4U5U6 @"T7U8zU9UA  @`:3B F3CBGCH%I3D,3C_
[$ZEUMF@40\U4143M`044
!`
p2Ba}aiapa^ ^ib{ab_[׋\5:
_ADR`pW
	
[͂ ?46cH [\7e aI48

[&48,49K4A
Z
[hQhB0 @ hC034}B4BE9\D& @lmAL4E [#\FK`'50,`p`App`b04Be`e` apH dpy4CcCdcAp
{a
<bP4d`5 A5000bbtd
u@ vu2q82dcrdQ4D` dza
a!v ,Pxހfufrf }a+du`['o
r21o@53B
n
 


Gp}
H~
~rB<7
 } ''k51K|2sp[+4pB|5pibpkdrd
edq|d_ hb {bPrb

bhb@p6ԉ7ԉ8S1j,56jS2B7C57crcq+58RbN@p9vowtar(53a%b 6bB686|T17 bu7atob
bc@8ya2q`bac@`Ap
r5A{EA;>53
56s5i8s!q7^12_raaS+1юE035B	|C
f<y ߠA2
qCQ05Ep\/Dk5aha{a cA3!qCbpb1 _S3D
p4D
[A?5Fe"g60
H
[K`06N61QO6U3Q4Q5Q6Q}7Q8 Hu9`W!A E}6J6C(D
!{h
aE69`i}`ha{`hPrE (8P Fxxq70pW71Rhi< 
`}yaaNP72
hP4,6BI"C9@pI7 A6Eia{\1AN0373eA}QS70VгNqCT]FAC3qAVϼ[WL4e"g75
@I	x=&76 J77 +78 K7H b7B DCRaD!\7q\8\8aO8230U8ZV8qS86!780`:8q8A88S8D~aI8E

N&8AL8FaI90 
6bim9@ @1@`092@3
[.Π̱V9W9617181q9A1BN&9C[#\_GL_,bp
` 94
 `
 [!
dv`A`9B97k<pj1ѻp
94p?9u5S63ԑ<37rנaְ09/8by[`0ya
c}cbp[G<jDe"g9E7 []9EͰP9FKA\AUAM2`BA3AVAWUAAAaAqAAPA AC
AiP4A`a7`kAB`npbza	ۏp
aAu0rabcwc
ccpXccD
'6Ippp3`Ew
ryi`zQy`
 ant QADt  qFw

PB0	C0PPrp P} !LAB1
l
fJB2`0B3@B4`BB 
@67	e{k
^`:AF@sj B3eVQ
x41@61a}e
eKMy3@63e-@6Dep
@6Xge,B qA5~A6< R7(ʒ 9 A5 qbbcyc
c} A2y
cqbc,A2/eK 6B1@67D{k0yp00B8hipf
j
7
 00@6EbWL!
's
Q`!
U6s
00	@6C`y!
Is
00Bb(!
ps
!Ab_	p
@9FhahV,9F3`3b"fB9efBAe;BB	
  Cb  	 
ED	E	
#  y  q+CwaQ^}`RBB` b0a"DBE0UCm1`qy	E AC2	"3 &b`	-&`v"C`#m"4Q^r
`15[I C6c
_UID DC4
 _STAr,1^^5F_DISq-_SRSpEC2%h-"A$D-*Hpe+,,.2o. 5/5O12fO3,4.36=7s=8Q28:,_<.4=AE/?#E@ 2PB,D.5ELFL_H2H`_J,K.6/M@TNTPA2BQ,oS.7TQ\?V3\W2CY,[.8\d]co_|cCD-74p
i8F2haCECF
D0j,/l1roCEo0pm.iBwD0{CEBm2mvdl8nnoOPmO46HasDp'qD4
,
vD4D5 t6
L%u6u7 :_REG3@bu)3t!D31tx`D:LD8(p
_D9
 hba
{33a}`}U2a}%lA|Ң~4c}ЖKDB5
Д3x
{`«`!35@iP @ 32$u@  DCt
,._DOS3g1
Qڀa`a[^lDebhPްDE RDC1D80<ЊGASS lphӉãA拲ŌS#E0DJŌ1ԍۑBŌhE2BPD9	Ϡ5h0'Dp
`{\/RjA}`@E=2@$E2 `,   PFјD>hip7h`ϟ9s*h\/CDh*mʣD 12<2"-E3
01q ` 6Dl`m+iE4|!Ahp!`Ā E5
^/0whijkl~~ l5F[H 3	_GPE
w	b
!g
Gb }bGf fy kE7E8lE0} EB

xECAD E`
/w(ẑE9p** iv`EAEF[Lq @@@F0 FF1 2U3ٻ456r89A] @FBCýFFE F C100  12  3456789 U A3B3C0Χ10DP  FP11111e2311p11p1111u8111A1B C_INI 11D
N
[DEvF20
w1212
G3
,53m67
 12 k129A
Unknown 
NiMH 
LiIon NBmn[>{ 0oqmE7n`u4`q`oE7  ң
$%DECG7de9aۡ:#٤a@´1
U}haj}iР!? 
qj111d`1C	' Qҡp15"ЃD	Axp
{`aa`12E
[)h`p*4`
csc
  dzi r`a[)absdb!/Vr`0: _ccCF	g}QDg
UA0ڰԀ{`gC130͈1hmC	BpFBFࡈ(1~A( q7 wq7axra
c 
dcbkpb72!8OD`fEa`a8ptd0gol mI3
+p
 K	Oip
A1bW9²3c4305 ۠Q氐{ꀘ`'{``U0p16$ټ$  92c c( eeexcpOecpci1t m6 *p
27p
!ԠcӁA8135 m(_QC03A´AP 4 `b
*p
aB
b:awQ05mWTZ_6'7['''TZk3_"K"6 ´_
;)138
)P?R_CPU0,*/1_
)2`.&7_'()P.Nj"8+U#@zb@
+9
o5A0#P 9+6"P AU ',B$:B:C$:E: `_Q10 - 5!31v3489B971V8_5q6,
{:AibG:9i[kO@1DEa
?3EpT K@1F4041 E42 rQ!Lp
`3F
rpL3 rIFH˷44Q41\_GL_p42M`40 MqLp431P!41< 145OQMjqLRO6aR4hi`{j`a}kab!Th;ib |147`X
`ZpY`ya

|`ZnuIaL8A49E?PZ[@a40}_p a
w`
0`ap`o (p
$_tazb@^
BaLAyY]kaa
a
v% albgb
 b
vb]Y
aiRPg`R6a
ackt
bf+4Ba44

 p `aoraQA4ڡ0^C	$_"`z`hapb{b2rD"`y1hak"`{ aP14E
P`{`24 iab0aR7hw
`wlF	Cl7haR8puaz bz cabcqf鄆K50 p^^p~1cI5,52L47
53

Gy `155Ӂ56z
Ea{aA@5PZ4B`}53 @[B!p~7P _DDN
COM151596
305" qu!։蓊8y A - ᰠ [58xaREaEQy+_DIS ;u>23^58py
F_SRSHvBh
A7@q҂  QgA>58@
aa?0D

  %cC xpr?Xa7[MB   
ӰQr
_ON_gP
&_OFF  x 벣PR0BIpX5C^Q#&C
? *
E6sB}ufE`+rO`5D>ծ^<Up~̳A
 *?_#ӱ-\2DOkB'[4C160)!0P$~x60[C:`1``J62}pJ`a]63
.a"PaRBaǠ63e63ǓH
1 GxxPxg"Q2xPx5po@&p o ѡּ649 "`y%s 4UN]
`Hd@M ?u<s6Ab4G
Ѐ' *c67E68c`93ڌ۠4ɓ6ϼ? Axp
69p%lr" 1Q🿷V6A)t]zA)5,?6B p\/@=C05FJCQy(|wp`{hv aS]C
N`4J$}J6E
~Kh0`QL7L!nq @K71a2L73
G~ ~ GP+QM71
Q
2F!]`hR`yRMց730U!N!!73[5%p4EJ
b  " S y5EJ
b@ @ "M[A6J
 
GG    *!"p6EJ
a /a !-pv

Gp pr r" 68EJx` `Gd d"[I07}9

" @aA
[@W7e7A@QbS%P7A7B&"aJO."( ( }J[+pr   W 70JADR   J7E
[ 7E&F @IkNI&F80-m.81.81o/,082-	1431	 C0B"'W
	JK080-6_S3 [B v8-б88:p1::1:[8"31_8r9Q(9:<HU8 '->c9C7?@M<qEBD9qEEFC09D 0-8E`}E_GTM p
NM`p0FPNl90PN91pC0AC^NOBl]On91szOE#P90
`m8 	90`yF$M}Nl0OhsOFi  `p
wO2{a:`VzV` bw_b
bw{czib ac YYrsPYrcZu_g0B1%POabP6ER[e|193b=cPu8E:F]w^!{Y  {DCI;
}[$OD;`LF F]90RP68ul mp
.C0C5	?
# #1fm6fC7gC8iC9OjCAkCBlCCn6TC

YQRo
 p#qEBq	#qrYs#q7q#q p#q9q#qP\wAtxSx!f4gTp&v32@	F7
pr}T}Kd
d
Primary 
10 
LIon 
Hewlett-Packard E?}Y~Travel|1P
 @j|0=23PL2F	~ 0E92Fh`/` M?%
 K}
"
 
W32hq|97PA33 74\pP97aA9Q7133ham`ӎ1hAp 'd
_UIDP $ϒAQ
_BI0cLST33bCL\ [G3D(ו6$qC)u\
ACPI
x>_PSRO#Bo`Y2`43*[9pPHd
)_LID{{n7D
92
	/15?@SXR`N3j2P8 99߫9AOBquPWkpk`Zh`piaF?qQ9Q
 a{`
 
ӳ }a
aӳap`ۈkpaз qQB"з qQAP$o 
98з A9CBeh@o

q  0ʠ@eR `RW`@ep}
yj0 @ pS>cV1PWh)gh`KC`ibbasabcpcau`a9Drw i`zC03F
qa43b`a
b

aE^[F!OFFC@WDGD
PRU4<SMrJ/NAA T-MP2T덶AB ;9Kp$[?AC+|Nr2J)lBC CWQAA*Ae`u
UCES/
 {A0a&Ւ 
9E0𿤷
K0B
FfghiGWSABU
F~%9EipiK1FԠP3PΑO0Ӏ
COMPAQ|PC[ C@ S@tReader|GEMPLUS|GPR400|PSCR|R '%WQҘtRK!3
BWSBC0APpipQ`a7?310a(`m2`03aj46 7
a~Q
A1 JaA1l[#\_GL_wy!U037vpj8pkȽ9&03B\@fDyhЦ	l['qA11A2
34B
A5 FB5 h5B24/z3{h
?A3p{zhLPB1r4[0 ADB(Ͱ8zA 9 AA BCQ
BD E rDf- BF?BE
[pE2C0@(ATC;1A.C2 "mCC34"
C3Uy
	`rh``vFPC5qC0 cdJac
W`rd b}y
 baya
a0a Q Y1
  eraye
	 evepeQ9c uc@
dcMC625 bpbgC	bdpp ap?be)eXQ e ffg
fape`pfƠfgvdueA{`b9` g@YQ `Y 4b pgtA1aggagubdM@704F1VpBCp`c-`OpbQA0ByP50@LpP50P!2!` h"9h H?
bh!W!c `r%2c taVd%
ePBC-adft`f2 "(uQad3(uc2ftdcge)`*b7@8- ABDtj0EA6pC7Z`aBDp
_wINI18B55pibhb@9pCU9Y3A'j1UA4BB5B4bFCC wQ
arCw00D[b b ^Q3`babua뢇ab9$9 b`.uapS+_CRSQ0D`f/82C`1`Ҝtb9d}/``e\/|q9
y@3MBA1CJ[0CE
G  F  y =p)CErCj1D0=B<I51N
G. . GN N2Mc c Ge e2Ng g 	Gt t G 2N  GppAMANGAMֲQ  w 	a F2SRTGC=0}16Dќ
ZQL
67Wo WP6069^^.DPL0>К0_ӍZM3[
@[Z4[S
Z5\E
\_PTSph2@	Pe_78`}`K _`8E+
PмcAq!vIg7F\_WAK7_yiBOe1dD9AB?k0E9lP7OnF1qip0q0qqoa ` 8hTZD3uTZ1_k
vv2w{0A
qvF3Cо?sby3d
y"dCa}cbccKcy8!w9D8 j|9~A@N\u0D4G,<
bn6

?o
1n1i х5" D6FsD70K J8
х ххBp?хEDE'[ JFE0הQ100361 37
wAp8E2
A۠CѶE1P#
~1ELFi@!8KQ3
p
p
_p
_{c>!"ŏUi_r؀A0ѕHE4
h0E`q~`pi`9P~/Gr=Ci@	/F`B@E5вahE0i@p% A&Ѱ~`6i ` a66_8
Ҽif{pkK!8D0D3R/36@¯
  )p036t
axa

`b7|`9C

#bߺ s

D?
	q
!
e3L`7	FtdO`@Ùdp{30`'{b
 t bbwb

araMpgLa/nFo1m~B1bo`:)a0͠Eh 0!!F P#pԂ*6oy
hI	p37b  1puhp' ab[w`%  |0DD<ѥDCށ#a`8`hvv3_
؀Mb037SP2ME8
ΰh `t``x``fqf
Op{tfwaf_] tҼcbb3b&ɀ0b~{bFit
ep
d
d_ dTAeiIw w!6	Qara[E9TG@B
_WON_3F!@
sA
dE
sB
\E
sC
dE
~[3`D2uFJJ _PR00 nU"`EAQFE&BF7JC[Hv_ALD EAsL1S AL2S`	AL3RF0_AC0rD U 1f72f63f PSVf SLagPR_CPU0GF1 _Q=bCS(5VS6p!DY7p
q$Y1Y8_TSP
d@C1V!TC@GTp^TMP1EPB[Gw0P[F3B, !!3 "P[q
$%t!PBG'\_GPE_L02\(yB-3(.BwM{v1{
`[9{aD
gj9x`4&0d47-9&.e
. -A\VbZ
 EL15݃["jҳ4C0`034B8B0`6`>@fj@. ?>_?~4K_L21ej1AF
O@0~GPIp0aa1{`
 aKT!uDK` CL
 Laur!aP@PPLazvBRRwSSDT3  COMPAQCPQGysr   MSFT UN@)40
   ٱYy UX S Y#5'XYJY[#1_PD?C{h 3aF6_PCT 
!^F5`4&_PPC"Ƀ04CkpS`_KSS%`N@c`S@cdO ffeg hOijkonmpp rOros/uuwwz/z}}ee| OoOτ O/ύ/ oO   x  R     U<ps   d$ $PnPqo  p
Copyright (C) 1997-2000  Intel Corporation
 Base-Code, PXE-2.1 (build 082j) $I $BC$+   @:^   
t2ôu3cUf`F  fa] j j
j
PS^< t	2PC[X] 0
$0<9vP ePFP!ӶfPf>fP@f%ij:64SQ0
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlV@Vv C ^@^~p!˷!]0Uf^]2 thP~SwQpRibWZT1
-AX- -B)C)D"*S)ES-:-DI)S+SP-ÜPh)tX
Waiting...   t^

h 0@ 3SfQfRfVv&  &\f?UNDIt?h_2 o
EC4: 3 ROM ID structure was not found. Gs<h{kA4 '45o56is invali7Pj Sj < uf. fGf;sf=_ f3>>=T?>  f
@ &6 +&AfRSfP& fQ3ffJtuہ 3fX[fZNа0CW.;@=s.@=@A6&BԋfP1WfU_j j fIR@RVQ@A&Bv &D6ELPLLPLLPLL
PL
~p=FfP?ЉVE>Ny>N6U?yQWhTw
˃f6UfVQTT
Z cK tl tc" tZKW tQW tHh]Rjh*4099nexpected9loader error.  Status ==  P420: BIOS extend[memory c\469dri=v`\imagK;48: !?6S7;ac segment`ZNV+def.>  u=,$K ݕ43^CO:i;f0G=fp=^f. sLh\PCm  rm^_  AyHr]0r pqqtr*rv&D &L. &;D&s&D&N{@T{BN{H{Pu|J|R&D <Vp<&(Dv
V2}|~=	KLNWj 1z\pU
U  ujvL t  uj@BH FF  R{Xt&t1uf
G HF+F)F[?fSVWB  6	p=q|IfoT     fp_^f[ T^pUf]f_f[fXQ? t83ABgf` |0DPDJt u]D3AA2< f^fZf fXt ]˜= t.. ﾭށ.Гs	N]&}t	џt+{f&} us`.9wf&+f&;EsPMfXRӠwP~=  o
 s@Xr`&f.+| &uf@
Af]r.>pu	. 	PIp<.( s%
1P<Xt/-Press <Esc> to abort&nin0.;zR.1RfW ߀>  $u> PuAMu	> Gu[fZ? qa<V<f>/f . 1. . 20<t8hquZaOpanrequiP DDIM sup gf`  ˂._UzfU fRjfj =@f~ <hfQTRFfu0h;|p{
I; PMM fun}cnumbe`  u)hqE4@al'locR`0I@Pf硩Crgfgffߋf_p.A<h .tf.>@ r
{P  blksize t?_ҁU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j p | !LIENT MAC ADDR:  h     GUID{: DHCP <XEClig:Arch:@00:3#0bs $I5P SKePROXYc
GATEWA MD  BDӰ
Auto-selp[:
 aBOOT ?SERVER)b-->  MTFTP`T l AAed`roxyser?vice d !7replyest ! 4011.  s0`u!7re a@gc6aer MissP. d` addQ BIS bad g`ichecksum  get sign0]1;nfor=mfailfree%vAbo07objp[ authorDS  flagshutdowۮ|b/credg ;integrit `NetworkScancd byo key iok ARP timeoutopenzE\ - F s N57[AccaViolb rece bdomy xunkn3opgre0x!7connp[ix Nopoffers we6e0! pd"!@bf nam7! \:APIm إ֮`ICP7r multicastwhA֮!th"+ _,y-PHYk.-pfigu=rData0-	a'e'EE@MW .setyt!
rrup$too many_ packbs;R+b Media t1`i,cable NBPb;bi-op&q*bas B0+disc1o0bli0,B+CeBQdgu oand/mpq*F Cbt's ]1!Pinb-Lm`bg.@  /-\p
SM/DMICuuiedVP_UP_	T$
`}
p~ u@ːV u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- rZ뾐:: 1LP3 @Z fv?FFW)~!!_o]'Ґb``[b`-^u
hx9@i[FPX`btYacI[b`[`mob```A``=g?	3=1 tw5pZ= }.f   lOm$=q )w-2 tHt-= 7-s HHp!?3pcCV9  >9 t!W JLff99f2uhP99@t{<Ibtyqw^h
JbShRFP }R^PxRF9*9Fr䡸93Mbqwn>YuYb"޳d1J{NMqIH0_ t0_tEVjOhR@^sFP)b9Fu9R 9뮐Cs>\u>p\tsII{L ZrPV`s9^P  VYYpZ+Ҋ*QFVFP+$FVu3^Ã>t3و(3*3(wh2pva E/ Z	u(37f(3@f0{sEy WN뜐WT3]]h96:6P636H3 |3O8tְE뽐X2u}$% pҀĀ FVfF}GFf+pv晋FoV`7u]]f6(K
b	" 9U!cbWFPV^f Xa޸PVr$=NVu^F^pG(X]^p  !G-- vs&iGNЉ^& u*&G!V=0 u6&G"G#7&ХrO  !UqrusSG\ssG|F9 Gf9  fP2 ~UHVm@V\PVKU!S*& P!&(G"G0FFPFF"9G6NfNfQhHT7Ubҷ:T^*&O;~S*\P
u3 @ẋ#G$P@ t
P(G	\"G{(pwY!V;?.3u0V  t&}}?X/OdEb`tV RPV`t
Ȍ 3& _2),bQ\R3*?E3:s!VAơpf1T|1^! -tHHu9ㄸ5B^ѧs1X/dC" GP)ڎbڒ`ڐ٫ ٘ۚۜu ʆܗ `3#¢b& t  ߱ Ood?t6QEЏS3n*^25Cu#."ǰ$=3 =2 =}cse-6 t[KEu(]B4  C\t'۸̳B@P3/LsPyN~ tI4p$fQ 9dtv¡^
~QQ
@G &W26@sޣЮF+$mIfjFPvG*F $KI~ t
! FËFFt#aXPtfאf		 	Q	

~䰃s2pF}
$ 	HZ	PF
x~E^F
%$WqÁTPt% )-GIR&x$G&E

Z D.'B FP|E tL @+;Vr
w;FvF*F3h3HE^K%"QRt PtPtFyڢ0ﾭ Xpy	F	PD
ޱF~ ts(A'u6q WV2!3 2^_2&s( CP:t7H⸀22fftrHuVHu0Hu?`c2:!VRPEK?0]a` V汏HtBrazBVSRPVW tDt@u2^c+v
rD7D0 N& NGP2G  F8F`4 ht3 Kt3Ro3u3zvYY
 Kf2fx3 tL|p!cSc> tG;aHt[-pFIZtJ-
 tE~3 PQ 5FsTF"R1pqR{tZc`S\|p^f3PU~Wu!sT2TT|"XP `YdT7FSvTsTTTUTTTTU
TTTTUT+T6T<TUCTTTTUTTTTF*F ^PIsT9] 젚V 2V -
 t^ ґTFu{>4oh"(CcG			th&C0	Ch. Cf>	 t.sTab FƱAqNAI[u(XcZA([asT]]GOFJ⺐[sTq^^p]1_]	!&@i|ẑ}d twh6*HtPǺ
  /tFA łR{ `YdT~rcF&dToGF>t'^wFzF}>T-GZf% !]IjzM`3}z@UF!^33Hcz&PF[39F|5sTTQ.@f OR. Qf0O蟊88QLh: C$,h:QLGÞPV3H BFA0v`XG< X~߆  o@1:DHLP`5ITX\`rhs_h:uc~
d=PV)= wA.JNl=!Wk-PV&U5D- t-;PV^- t@9vOJQٙ=4PVC^ HtzpNW -PV ?FvOvGzpd?Ìrԏ&Wwx;ȼ&t9G];$$:	r"ZG$hX	 D@D3DߊF* c`ؼ W
ZSб|D<~Ij[~,,D<@C,&?_*b`|&_~-5PV{U-	t- t:ݳ X tq$ u&  u
"?tSO&9Guf& Pu  t؍G{
M*Ä WADDvvv7Vj
 &fXfYffff88 9 7:卧FjPEPe+9hB9ix 0Q1VB	RPAT
ix &nF}sap 2 F=zPx 7u~ t	ƴQ3Q4l4p032'rȎ  ǆr D%މ77ߖ 8Q8**9RȧtS@F t^:uf~tw9GluutApu@q$@1іtr8PfP

21
Qx&KO6Po 7Q7o)9- Dt-guRJt)@F utpuoh)?t֣Ȍ@Y}Pi
PʵO)
@ 뎐.^óAy
3FP`0c$0c3%@. FBDivvt u-FF9F")u32} "
"vN)u{rPV;u2.q?}.iv"t3"!=b=P""phaP%!$"$-%e "#u$)R*&j&?hyd0S{'9&X+5,f#t4d't"u!Hᮇï> zH)l =iFpP1<&̀Xі'` >2	 9;4<`P3<
]߄_*=\0^ >UUHtHti@ < 3(=kR&V>"sĘ3Fh92 蟸;p3퐧K;f!Y 4Wt-MFYWG01oHI3iF$4GPGN`G6xS4I2tB $8;Qo
&$<:D cUF20NZR/XIK2AEV93^Qd'SJ1;~ t3
jU P9^D#1k}aF3򏠔;3	wt1n u
 C Dao~ 7rAprFP`^ V Cu~3*=*qFQ2J  SRPWQ%o*/n0=0Q0޿P!BktJ@\KVpBO0F/8}C}ϣiv ~ĘT$v F~|9G  jO#N; ~ tawWR1PP1N ~fP0G&WI9FVP4ss`c9Аu9ust[~o tH׋F-bovi~ ~á柋؎Fe0RPs=;\u>3t
F} _s	-B`PpV6hbߐ`nѐ21f>&f ]f9thxސ袐h蕓0 9 t@3f1ƹ +uhc0 R09Pa@0 
rh/?0^`l
lfo|
f ءP@{:coh:K߰[6?DmdF 5ߊ 9F~a !uxa !ka !^Q
a 0La ?  0}/^ۋ F~AP0aGg]Ӡn\`ZuQ `PuԭRRpS F9v~!kuH޶ U u1"h+\ tGut1ee=s>t>\rDӭ̐aĹBÐfvK w42
30cǂ ѻ}QaD tP&_GtF,Q@ 8h!%tFlQ (D| ul t!P|~2
GlDp uTRpDxȕxD@րА4nt--ŐEz k*302
f&)f0FFtq҃~ t^%{ 0왣99	 t
^ݴ!u4ru:	0^\4:FFu	W63ļQ| g	*!+4*6JFuH!^3H!n uנ9,3k3 c3߀	 t^Qu
״33? 0ǋVR 0 `> w$ѻV;лA^QA[t}O
f6 A1!VP G)G1Hef&ğ	Jz)`v1t=@p_u&л!3cz
CT f+F^᎟
&F>0^NF#!	9FsA^?	&9u0 	 !u$qŋGR&GPt Patw T'qLpƲP tu t~ t]zq_Tm/hw)
*C (лpU0&F
(Bpz Z yhfv.pq4)(o/&o	
M	u^2sIb(F`VB(vf&0b!l@vf`~^NvVFn
fa
@͊ A  h&$zѳh^V6  u 	2Bd t^ u tfX u	  9 $uy$T u
vs#)@6F**  vD*+ OwrC*@$XPH XQs$h-tF.uw)Q&e.hvz=A*GX`ZF0f		 &C*Xv&ߊ@* F5;Fw57~M$\ P%`(ut)`Q tC*\QrݠR
RNā3\`^4R
4
)
>*?۞6R
;7^C*`&8gP0\%3Ľ5A;v
@6w%FrBDqs
hupZ@?Ht'&+h%\)%qG[iN?Ex)i3+];%Vp*%ȜoN1FrB%}B
%*2hIsPC{6 $ptC7H8uC@@uИ`$ ϐǆ0zITfǆl @ Ɔh$2	&uY Z@X@Jn$DO%= Btw3-`
-,u@,qIW  Wt#)vz- [t- 
tQ`Ğ&8t&0aY
uZ0@)h#ǆ1WEdv}16#d׃`FB#ZrY ZG%
h td @e"8kQSe @fp9ed B*#pR
9FrF
Y$*+ BvߎfPfߥ^@hXfhp 0{VoV3Q#s 
6fPfh  pu})vzz`+0t- P9w3  d#=.t = t \-tv])0# tNAjfhtVuI1k_vxxxGzUPaq=KF{vp=k'0pHS-	t-
-p= K-w- 9t-
t- _Mt- t0tυ0V>u$ {>Ts9 h9>
 tFu&^@ {^f"24@B@=9t3 p2~Sވv3 Tv&8 u f@octeF t  F9PEuE>~A? ~40v3  ;$&%@A`~ t?f( !5  t@J࠲c^@0pa"
'@' 9ǻN J ڡ_63L3z`v'Pt	t(>PM!ht_3h92A98 .bL3 z pjpP ff92uvf u:9u1ʀ&&;w龱 0 f9ӯ&:qtCu|J"u?9󥑥gL30=2 2 >J3D߄FN3 &`toHHt	H_Z(Qu"hdFhlppopݸ; \Џu< Ou	= ` 6dR4 PDxp
 !$N3? 	>"E%+Ht
3gtE9%-  =9`p~L~~ ?? k?œ>2 u09P@&:?h2 >#`{u_u/Ss_YvOt*5<)"uZ=t9ъFf=Ep veR`M !:Y?(3*3oƀyNevڃr1 `p}vi/-#+!v9lSʣv 9A|Y$#&3Σv9l#PQv9!>PM\₩wpp!>4{4$ |!ړQO%
tf[DtЮ:/y	29 3t\6iBuBL35 ir9f뻁> paʫ!r-"E>}2ʇ0S1ӕP3q@2 1k*䊇N tA~u0@2
p:`pvn+2@fj
 f@XfYffffF~nFwF^)FX9Fv	FF;Fs"?m~#v@#F0f+fpPO63H3btyR` :? tH9M}b  qҋF
`3:a`_  O8r E`Ю9f" f0fWFp&HHHFx32N =@3-6.@y|p`~N"%r!!FP(}$N9!Cs%xbAs%9"*18?R  kX ffxHj`yqnڙډN^"wFV;r
w;v:!O6b7& ,@+؋FV@ !35+s4K}t&3~ 
qR6:!tJFV43? ;FfПf E9FK=!>Bp>n]$;FC
/TC@$2E
3!!UVVv0$a=  t)ArZw <Ar<Zw FC:t^P  `O ȠVfpS*Nɯ-0^t 0r 9v "U  WVB
0QRNuwRXRXWA
VLSHT3^_4U7V[Pֺ=~puAtF0SRV
0`FUS"@"Uhp38hV3c,V3X3p+YJZ3@03\3`3Pa_3bbr΀	   l3PAn3 Ipp!h90㒾99po39h9Qik9Al`9%vl2r0Ejd3Fkh3@l Zpgpfff^ˍX3
 bf@eBku	W3 &?r"uwh83  `Hu!,{0V zFV
22##2&w#2#62;u5;+u1{/|P}xx!;Sav%YNu Z3ΨI$@Aq&t"t-}f ,Br  cpf&qro
sadFavV 	b
-   BF ^@i_ 蹙4 F=+F;FwBpn+VM ⏝@'1w	cV0 'FFf>6 tKa;8rBw;6v:>P'F
?+ۑ86 68 
0@&c~t	F~drKВú> u22u r!s;Fu$<ut
f>   upM% Ht P{`S69F}8Nl$`~ t*fۡp&^&G&t0&9&9WF?%  F0wu9FP-utլ r !ᘃ~ ӀkRk9ql9q@m99~ u-"m@ _=t1an]
P' t7pԉF^(Яt#9FR9F?Wq Yb#x	` 'ҵ BѵuF9Fn!nF;F@A`APި9w
F=9FO+9<7!cn[	R? v@!'Ɩ̮x@A
=6~vk^9u9ukFP!U=qOYAs
 uh0h_? yC0ӟƇO Lh9c o9`9`}
90h9
 fPݢS3&R39ݢ`29~@/9@j4kG@}9G
Pϙ`U	FUp::"ԝ!kFK2s3׶{k9U]	 2>Yߝ@$f
Y= u^ 2zE c
= @
u`
 ufx9u5cƜaڑ  {ߓcޠp+Rfq@@/! Sbp=  qȽQg`Ӥc`h:aĚ3M099h.:  [΀tOÁ! @b m  j@ 3`hpҍFPj9&_׃ wUKGthQQQFu6~Ku+~Tu%~ u@a :~Bu~Pu
 A
pBtްE8?Qz   ǆ~^`x.~p,p F5B!aSQ @@r  ;؋sY[`
0KFΰ0Fػl֣R@i{lң97F4KPUbPUaґ(`hFFV=6SFF＃~F - FFF@A<ċFFFFPMF&uFQRQ0 c߉FF KF$"h~VF$byFPơ%
\(QQ .&NXf* PWQRU> @ c> j>]a us>@ ul>L |i<b<w[>* L &D F +ȋѽ  ( B ?V6H ^;s# ;3<7ԡ( ]ZY_ÐB ~W::_f`.9>9tJ.B:0 c.;;0At9а r   fa.>*N t&.(N! 9r & ӄt"QfL(N u8Pwh3Ɏظ O&.(N&G.*N[i Y YSQ3ێËȋ^$OtFPQPhfPQt~ Y[ Gf.(NI f.`O BPQRTvMM˃ӈ N  .,NNX tZYXYZ./",N[
Z\V3߭`^]t`
  aP5aYŐ#a `t2aaW`b  _^]Q  2sYÀ>[
 u[
PZ
GXw!
PX
j5?T
V
j
X
 _   > nuV+T
mĉVfTm
sfpf  brpmn+9Vwrw1)jsm댐Ҁ>
 tZF ȓ@xhl* %ڋ[^U9pO3zP m yyNAhUQpPVCw7$
F 8Ft)F ~ twPP$~$* g^
+@2oҊF 
B}Ra$Tah?	-t-,tc
PWuV䳚1N߆ ^U~&&Q#2#222##;u;u3FsްUf9 u"99t"; u;`uo^_BvVR큊;Ftiu79L24"99`t4hPt͡u" `fSfQfR?f``f;sf;wf;rvОs@fZfYf[] SQrPP Y[ PS [b`@2Ft%&?	u
h*/FAk0 $  P/ : .I'jqa*䁤׃b+ l0>q`pa&GfԮ\ԮR 
ԮCԮ9*Ԯ ۔Ԯ	
䔲
ДAu 2Ru	s22Zhû5PRFZXPRZXvP
0d F.N`60)v2GÀpB6+^BF+2`6 @tHH  \^
~@t\
f`
fd
-DYk%0d
 @hptd
37d
+p~p2f
9uof>`|i4 =ȡh
`6f`
fj
+j
l
f6j
2+p 
d
)땫R ~ Ã>  p`Ƒ|!/~unV+ɉNFu3^f&pwwsW	&O
N`0FF@&9wvahV `6!9GtSQ
u.VvYpthn
V	p*n

Ѓ
P0rbÌw VfW4ˋf TV0 +N uf3lf3 VfƉFfFfF /-lVVvap^^~7320>f_f^]2OfCORPfEDOMf - 11'f1ufuf=23AIt
f=46AIp@Z !^_O`D ?tFqQsnq.V
QFtSFF&nP*S#~ ~N	 xaـ}N1V㑲kWVg~cWVF
tyWxys}>F&%G<ar<zw, arzw :wrg p-0`Sp0lGGWwGg
oF GFGWFGOG2Cuԉ[3![[2ҹ G;tqwGg
ogwww_ϒ3FpV*&'* û@ &l &n f%`Pf@S`#f#f#f#f#f#f#fXS  & [Ìq`WVsS3 lP6}G@ڃ ,V lR&&
V`6N@23a@+p8)P)V1{upf
.r;Vwr;FvN3ҖOu؃ [^_aN
@)u	*aS)f
)yRk$0~<9vFPSW ۋSR3.:uJGuZRƀt%@u0t
O t hr< u	ZXCu33_[ö΀Z^_SM_h^v_DMIw_ ;0P;}^a$PnP=@^M_SYSID_Pv tE'od@@S>NtPt䤊!D+t۲  `EFGI?J_KL MNOPR?S_TU VWXY[?\_]^ _`abd?e_fg hijkm?n_op qrstv?w_xy z{|}     {     UX(l   @ ` d$ UNDI  N MdPCIR$I E      ?X b S$PnP ]ԁo!
Broadcom NetXtreme Ethernet Boot Agent v6.2.11Copyright (C) 2000-
3 Corporation	199710 IntelAll R
s reserved.
   PXE-	 (build 082)h	Remote Progroam L erf	wMBAf	 Sl 0')Pps Ctrl-S to Ernfigus Menu ..  
t2ôu3Uf`F  fa] j j
ܿj
!PS^< t	2PC[X] !$0<9vPp##_P%%FPuq'%fPf@'fP!)fu#(j:6)*SQ^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlV1Vv13v@22^1^~34]0Uf^]2 t`h+  dh+ !VP@ ء .;uXuX.6>| . <^SQW  :_Y[QSH .> t"?u.uXH S2.{r*= eu 4= fB  `BgB0  .9u
 :>l :pEtIu[YPF??Fu DFG  B!WSR..>f&=u#&uFPj`hfJ
˃Ŀ u D  S3=_Su}M_u22]r"[Cu[V[}#|OfSf]S_fS.= t#It2EQuQGGRG؀}|_E$tCBZ[_]0V?ԀG- 1h  fPh @XO@X"{p@X%tCXm@X f#Y_SQfRWVsVf.> t.@   ځ>  Utt r rD] h1
PH ?X%
EC1: Base-code ROM ID structure was nfound.   PQr댊  t	|Sfj j H"k>  t;sfpJBC$uErPj Wg!h뛯ێE]]>h RJiǰ`  .]6I6nnnj Ph#J}
0LZpLt'hDRH3a+XC_() ==    rpSho%M0F: Exiting1cP6 X^_fZY[tVfX1k, ~z. f"{0{sVt"{{B}pf
:&6 +&@fRSfP& f03ffJtuہ 3fX[fsZWЀ.z{:6&`ԋ~(SfWfUj j ggRV{캐:&`.6E.{q.q.q.eq
"{ {0Q{F|(V|FV}F6Usp{IW0qf6U_fV@1qpLk	 t	 t`Ƞ]
p`WPOa20bIOS extended m ry c 
 error.b6:driv image is ?invaliea8: !qwcd@<bsegm0	7;9:NV+ߛ\] uXP] u
h
If @}ӎF.3 wF"v Ԥ5Ria3bC?c)f^f" sDh,P?xe/  AHsR#0trvf&D FO&D@1@BU@H@PJR&DjVg&(DovB"	ǃ/OcWj 0&\@q
Q\ f3fp  
Wh86 u96} t2 :L ` N b 6EP6]
 6u]fS˶R(rf	fXfZ  Y0I!jUuJ q$!8uv ˃uj@PH F FRuvXtutf"G HF +F )F[fSVWFr  6Se qPfTpm 0  f؝_^f[^@q?f]f_f[yY8~Tf@ M  ЁJt u`~@tV%d%{fqfPNˀ?א0	= t.. oﾭށ.s	IN]&}t	Qt+{f&} us(.pm9wf&+f&;EsfXRSw`=  
 s@r(&/f.+!uf@؁If]k3e_fP] tfXDt0~1F޳, \^{PG3. 󿫎G3 0֐Eap_ pvP]0  u	r apRgѴ.w 1%_s
r  J _:espCup~&<t.;60 rr ºXr~6< upwG&D
p  &sL@&@U " G1(*Q0@82:@Xʺرt V,r{P	˒	G 
 
*.ܒT
 *2$
=	@p?pS yf[]3fZ>tOfX20G
W~PQhf8.f8hp~ ` 9f}` !f~U8$!!Hd !`  1.؁±7/fpof8u ff# Hp%EC f0
r!fqu)*.	Itff!u f -)~R,pf  ~.0q~11 n /.pD00Ub211 |W11G1 ]0@A1E11 6`ff9!9fP0%ps&%Рq!G!W1z W	P۸ Q!&!  V@" H G#$!}SA!<Q23!fZ@1C@ oBu$!SF D3ES踿 rR[ I !&1EFA&}@" &f n@"&LMfn._  [;!V swfLHKU&LqMM7UN NVA&zV@Qf Ma= f'DVPT ufdf?Iu0;xWEV3  CEeR (Q xAM\WAX08t/f<DF[@J^G Bʆ\3A.@ S]H^W9fSx	fOc d/7d|e0f/qd3|-p V%<D=ݾpRB0>:?F6LIR@/u0/&dNi/FMOL@kdOUR, fItP^á/`Y%ttu@S  fP x @ֶV2P9fsb &czuU t!@ J pۊl }:~t7 fXw+  R``f
@݀úfffZeP#fXтSQ~~8tYOPVPLDr:?f;taYZr`XPH X3. .P #.Ao.pPֿ	Pfj .( SXf% L[A;m  l]Broadcom NetXtreme Ethernet Bo@AgP v6.2.11
Cright (C) 2000-3 6Corporation
All rs reserve MBA0nfigu Menu   <Esc>BCtrl-F6QLeft/R<Up/DownF4}> QuitBlink LEDsChange ValueFieldSave Th`opB`nselectableA  ӣߦ?_Protocol `e}bExecuBEnvironma()   R@teagram LP (RPL) strapf (BOOTP >SBv    OdjS"Type  Au?to DetBS(Ip18hI9z8x    Hide SetuRmpt  Dis@En  $>e wheqdisplayed during ROM initializo 02&Key&!ok"S@"B  k@s in-v@ tcʗ_u xƉ1BannMessaT_imeou`10Q  2   345678910ϗ|g  Non4  *7DQ^kxxd    LSpeedӸNegF10Mbps HalfFu )( "2BRb"rXy`.-BWaOn LANAz``& yCp)ff<f5 Pv[OuIu QWhRf3& tହ# X@E[.0_W <.p..T>T u
fUPf]T`dKu
' m<mf0fauWޒ*E,=
u l%4=(  t >511nq+  .fH R2 3m
E2  u
`P@_WSQؑ@xt9f% 0\00::CfEP`E`*%>
 tPv6_f!P5DB@FnSjD
@> u
>sUBB}CfEP-
 `D/:?XAPYfr:$AEY[_Uq 3KtRMtpPtHt.ct>   =} 뺳s }h } t=} u7} uEEHEE B""#@;Ev3#& b_.20uUCRVUmUPXU'um
>@]^ZQP>=; ,uXYWQU+R=m uUZd,]Y_PRR .ZXQR	 xZR {A1 m$2r1 [ ZYQR 2Of$4r14O#4 4x6R2X7_8SQ  Y[P< FXô
PSQU߸  *>V]Y[XUP3>F 
tEA;]PQS >R p?&S?P[YXw ; <ް=RU @; 
<Pp:]Z(*q3ɺO ;f`@  `& \o:BC!="%)1.)BbHL7RZRZL0N>S[F3faVSfQ ۻ@?_SM_ts OvQj S ;ARqSЀwrgrafGWO}QQ Yuf= 0wPmXP,g8 tIt#gfXhg Yf@fg@tge f&=$PnPuW32&C&:]u
uB[}
 t7j &uSj`&]
[@#^eU_3ۿtҎXCPRfW ߀>  $u> Pu~1Mu	>dGuf` bpBb A!SS< uf> sf_ 	Qb߸f t;h_&rfY
 -E07:  PCI BIOS callԢuppt!.i	iuM.;D umgn4 toh,'Uk1: UnFmlDevices! h`'ڊP]Uk4: Erroradl;space. f3ffDEFGHS]m
T^Bus =@Ssr{Funcq{QW '_Y1`P϶sЇ`Gf~f_
D	 MOf~/b8{rфAbЉPh'.Ph'4Ph'2PfX[f3S.z o0F@oPֈuֈuֈ.>t B@V .[j  wP Xu
U |U.k  >.VfTSAFu u
.둍.>t'h p }pД`hqPfR. .@2 <t@h)PH XUk6: Oc1requirDDIM5m. e"  fQ  f.Wj_fjf.ffPjs2*?fQ˃Au0hR*ex
InvrMM f|numberw u_&h*fEPkloceu. f`df	Vfrgfgf@f_1f.> "ك0t=t	 t` b 3fd f.] d f o   $ `h  0S.w(%tf0 r. K ѝѝUU *
 V4r33 x ZZ j Z:P. `ѝ  `  p, ͠( 0   СѝН
t < @7!. <W&@R'< $0 44 <$ $ $!8WW004   '0 < h`hb B4`ǯ @cP$ <_p"xtȀo c4 ȯQ0!<" B0 $ CBD P> Pe̼04Db8DcDdrxȡȈ#R/t$Əƒ  U<Uc4  pêU<U ʴ CyPaa  G! 0	 !(  hwcpCR $* @̡Ppax+C ؀<P0~Pڃ @_DDcD0$ptH0ΡB00 B$ B,@<$%  8\dc0\p`!@ѝ c2B0ۡaڰѝ!!({<0!0  È)
-Ŋ10B4 0 7<@u Ȕ4ό ?` c$!ܠݹPa%!HĪҒٌp ë#!p
cc@ !p!H@D )p )%hd% D E FPG; J Kң0(   k a̷Bg Н§<0a̸4ks@p0
 
 b <1& 2&- hp 2q 2PR "tap $
 @P   "$~`
 B,8  @hsН`dTB"vtB0B3 ˠtamMPƐq(Pspѝ`U :0 S
phpPqґ8Š0! @B4 {c4b`<pc˜p\c ] Ƞ<V0h  <$ ~ȴw$ ˪4춲P b8, c,%pڡ% Ȅ  0p% 
$apΗ ȡ/ h
Ǡ(˯\
`)>cȿ"\$B  R0  *'-0ai!0!PŲ! ơѝh\qb_d &a	t`p  +B0`4t 1Ɛ 0 
҂eaE|88#: :;a| 6R%!ƥi 
(!ڥ1eوܑΓ;<1#P ݡoPB5
Lb 3#$p$& J Le=90ALd%c $ b pˢڼ$! L0A1 Ŭ0!$p lXbMTL%vt0,U,4U,\d'p E@ը̡0A%2XȧUΰV VROb$p  RͰ`@AʈKo! @0a & }D "0` @T @4I@aaaa4 aaa *a@ aaba40`a0`) 4paajbНj 4pa # &j
pa`8"ӎp(a̬  0%b xҠ,łAM,0p(amaEp0qQ(<"ưc$  b <Xp ]b4 ]d'$(EpW<%0x p 2`2^T<b?8<c!(`<<bA0 J]$}p{  rq70}0pv! ֡ar!wnG4!00 !  4 !@( P$8 !  <p,  T
3NRdCaOpҁ'X0W<Ae@ф4a!'ed+ qD`OB!ߡ
tNp $c(aB,#$ <$bҌ8< R6 _<sP,g! `~. 2 A<0B4% <e&!'!& 42&dpʰea!0 8< 4rR씀^s!ʥ*a%X>ȴg
pâ.0(a8@8&e&^ B4㘁rQe
0 N*tشuВ1&!  %aei2V
5p᛭(G $#)i:. 0a <bȕ 0m((8@ՄB4(  PI0i9 ãqa*`C
tpáU 3c @տ`` H@4HPpL0HD@<080@1a˥%3!&0<@"!'iŀeġᘡN$}' <<$pps6G4pPqP{16!%5!eh`Q u͐`C:a"&SB,o `!נ,#=>  Rae .@ET!йt!  la^ <a
0%
a(1ڡDa()t! &d:2q"2pCaO.ạ"20!!"_c"2aa!&! !'c@$!  ` Ï`PGX/rD tƢt
aa_H :}p/!?` !@  `B@`du- 'c[!p1!3 pppp
  b0"  baaա` 
 )`]@<OO 
!p")!   Õp /b,N@xEP?'!" "rP$@t  p0< č%ʠu  :0	
p @0!kaAP$g	  Í" o
"2!'e
p #~0CqB,cи
a	
<J5! ȍ$$$@|a4%@
$8a^ @c0%8 $oH o H"R$$0&°o%0$$(H(zpJ$  ! q JRo! źíp $JQPc!^	
 ÑpMo! H)	4P!
P!CpJ!"D $d tá	z Ò!!Lq < ̍@J5	)5544
5;P4

! ˕$`B\c0 %1$PC@Í%PB$HI"Α P?2H#$@( 0% %@m!C48 $0ĝ!BS2pA%0 $h 6a6 J%h2!x°ä0!V!B@x!, ʐW˥0ap 5a Do c4a	!%! K$N!",<t*j
r,w@.ga,!aIH)
a! GDR)
t*
	F@a	a,5!a4td_wfv_vr11.1  0.rDwfrevitatafrrEltebifknLrrdwfinIvita_whgotutxp\p\ 80]@q]W d]]]h ^W \p_p_|_it_ata DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:@downlo{adeed

fSearching for RPL Server ...  Abort0iBCM570X Foun!ibjERVER NODEg

Transferrid`X fromRjsj0hne0i eniControl to program @  :   /-\|dt tttttWS ˌt&  ˍ  !PXEX8X{XMcMXI|}x0yNV+,rx{@p|ZfUfSfQfRfWfVfPF= twO. ~
&ێӼ h@ WPJ
ux fXf^f_fZfYf[f].>  uy
 w` Є afv
Phv.6 j  fUf҄g]g}Bweur`Sf&؎0fUcSІ f]Qfp汎&pRu _qf⒂ڃ> tj ЂSf. ff f3. 3h f& f& []áj ӚR9h uf. ?fh ` PV@ g&5+g&r^ tw Θ3Sߙ[wIePoȞfXVF=PVu NVf. Ђf ]ϝ    . . SR[.9u r   Z[AVSvGfD[^]f`Є > t;s u.$%tа _fa  t-. .>pt!  r ӄt"Qf 8Pwh3Ɏظ&.&G. [i Y3YÜSQ3ێËptFqh9wtY[Лր7Hpо@|3PQR@v0q˃ӈp 0X tZYX"
 S҄|ONQ+73!XuVV66N^VbON3txZnU[? V=OFc	5Z  cf~ Г   u^&ꐋFayFaBCB{T뽸7u5ߙ{Bq{g]SI?E5+!= tw#=
 w@. 
= tw#- dHinsxF+= t_w-pv{-pHt-p1݉~@ۃ>G tq hD2VZ^&GFPF0!!!!
F߂D<b?KGu0f3d!FFdrYFF~q
ubrz!GKT>oFu @B \? >F	B
P4 G!OFD  % F@oPPPP YF"&9Gw1^;>AZ	tb%>F*Ȑ`FDf+fF!GNR1"ޯ&
lXFF^FVw"	  V D^uRptu?LB
FVFt.
;Fu;Vt 
u; ^!E?FÎ 	~  u	PPX	F  Y=F~'}*f0fP <o	!N&#o f#t6$o
fj$	&u&PF>\QOfNPG F^F@0L `.t.,`Nc%P&~}-^v&F&b%1d0|xb% 1153 *HtH|pH~I	P` FF^,/ftpvQUV@8Fb:c%57P&FQv:Q9f&pB=&@
V 1`=2:@
:>3?뻐PG.fGA|!-FG0G2A4G6A<AfG"fG8,' G&AA
qz4FN+=33C"be		?X
*U/HSF	PVC B"RJFvP1ވ"FL|DDGHf JA|w'ar	O#ubV!ǐ	 !G#[M#[E],!pJ*F\ Q@_"g_RաD\.
E\0DGтqbGfc
fcfcTXDhQRv i	Ђ4B^~$$&G	#Um
#mgO@kGpp_kG_ʴr_Ѵr(Ҵr
a_0\pp
ppTXтF `CQfiga_d 3P[0\sXPwFIt!3$[PFR"L9&FV;F  p!(  F!@Ht- r0w!$&[~p琰p>8F_0*a%Jc _!F#F#V{&G$fPh8&[4_'!m>@t
zk` P!P& }pґPd
#k`[eأhG\"-$t@-@^1:v6
*&oF] A`.u+`.wu$`.uØ2 \R"F@F b!\d2?&tbn%~- t- t齇}ts^E/
u!$[ $`1F~F%%5F~}1!QQ|F6v
G\fo<'89Gu9Wt ҇VвfF#F#Vp!jÐxfpfP)!fhfj҇!$#ČB5pËMu2;òXPSV@޲0NM9u2PGÑv@ t|`fGPXpa1S^O|QP@PRPx10:0ÑxB 0 0UxRP u @˨*t |S4+W4ïŔƔ{!4Ą4bS;W οFV!Aw w0V0L^fhѠ7cFfjNE1@jEC G؉FGh^@raD0+DpD  sG_7HOA΃#GPfF -#f~ t\`Ͱl%CM2F2VppaqQ+f~
ttMt
mu
pƇ<Љ$,<=(u up+p`F<nta∇ 111ဿptqt@' Ǉ2P|1efj  YQC"Fн 1j% pCqTTv,eK$oFX%0 +- t&Ѐ|aa {t<V%FF@t.q/At"= @YΤAt>At?%? V`<RJ% А	F/	V"A@k,Rp~p$-Mp
 }p &{t`v>@ /@quL/Nf1j
/
1_NBmڇ@/ub^TU
 &k.Aݠ8 s1P=u܁u1%#tu- ۸Dj  ` 8jF+ҊԊ*Ϊr@R &xQ
p		~kǇ5 AǠ!9!Ƈ;$-@ `uP)a\-  tW- tR-0 ~7 tExfb*5!! AA""  NR#f>b  o  sI(	` `+; Ƈ+{=a+뼐/+u&& ~𠑊F /5&Q1u0r!u 3T`ӉT@40Pjt@00~t	2 4 8+ Ƈ4c 軔"	tf- uOh @_h 1@hEf@1<m@o
P> B{?h@r@>pth 	@)tuBuqC CP3wĊQ*󇠓'qF2*'VGG pG3LL3LL3LL3LL3LLD`*B$v̇ሇsR]ቇ SS Ǉ "dK fThUjTlUnTpRWrSSz xSS~ |SS SS Ttv~>@*
f	 up]Nf}ph@  u^0xP'p	HHǇ UǇ Ua"s&F u.0SgRPcG:0t`a0g`̾  t kQkÎDlll*ll܂lQk {    (`k`{WoGuGpzA|   $q^'RpǉW`kpFs~tRt Qq@bBr`6QqƇtqT @aaq9Pv(kD<G ͋q ߀`Bl@	C#ǐfv+@pyoGv)!{\IG
  ck}"c%ApP@XPP s`k  xQSVǨ6h@p1 t}  ? t	"%5j6 ``dibig%]0u	ǇT +cVcT /䁋8.BafFPs@V~R?0R!" *ŕЮŕPŕj u5 vG]Q\ u!h
5?v'5 ;5@=v#6@v t".Z;p_6l=s/ t"5 u#S\-"
 "{54 $fj@Dw0 ]0`040
8;5pQp    ,0x0 \n0 Ҭd0˸ ZQt"P$FwTp8Q7Xp"`@\p0Hp²hphf/P,  t*i5 ƌY`A.@ 1 еոе^C еqO9q"HS3r
zӌ;`tw*ոjc5лRW22t3"*qL*튏`ƪƣ$Ǥ$ǥ"%vPm8`HҸ<`H@ &@d`H y@ʁc l@ _0HUUHP>"d<4h 4lW4p0Hz4x{C|нԀ ^Ԅ$ot(з8Эw<П0ЕD[4Ї`@U@z@DЅm0Ѝ
0JЍy@ 46T #0U$5khf9Pf_N	6eP?Ԥ햽#@yNP6(=:!d5LЩʡ;*_d H/i(̀Ѝ8#KA`f⭺ - p##P`\#?t\spo\\`H쓋5XIX(aoXh`H1ΥP`Hao-U56`H|a
r$bЈ2\C#5𐾲5p0/u50ds^ a9Gu9W;uڂ~zV vc@v_9 u69Pu1Azf`uf0ffsws9@u9PtCzt` a1F~/^Pjxo; 31/GW$aD3CSA;RPztbtbq3@d 1j  PSV%7؋GFF 3؃
HpF(ce-pyVSFFwyQ@x^
vpgD@{f)!Gpy p{q!w@>f@0@h&@s'](@P xF^GW`NA#y F+!9Ww r0"WOPz%Wrb%uV_Ґ?VPz+;Fu;V7`FV8"4w4] B455U5645556s,1@zq-bFp3AxF}F=MRPFYP9btaqujf>+,96"$q ~ #(  R HfZyFtfpEEpEEfFЈNf`]kpEG`EqFEv `^ҋVeP@RFyyyFXN^ҁ@ FVڊF$F$`Fހff  Nf%
vށ 	B?	RF;L9>bv0Sfr;pASp
}4LcՠdC@SVsPqD^^ &yf~'  s[/uL.\9]!I`qjK`6>e`t`bF~skF|F"{vP '>0#@0$!.Pt<ý`u`!@'@mQ^[t!u -b-dC9A	^nu sn;4ýg2^ʋGzW|G~QgOr$WFV1zf9F9xBt_-V/72̉V΍FА+TVs1UFVsn*v P6Qw^	+ k tsk E!`- GGGPsp#vDGpfQGra;vu-$lqw:B;r狇5o𔴄
P'zC}wGWnq򸄠pCnSpRâ^1P#
`#wFf0zvo\PRɀ߀#t"u; tt
KN5Pm	`0708 DRtIFt)0tFt0 7t10 *#㘚ޠ0 e^X0tG
1W2\ﰟpR!qU죍t
Q[r=SF쀓юoPm@u/ȏ#!(2Fu@p^h 'jh0#j sBa߳hUSh2vCI|Ch UOrh P$Ce"(0- t	-  ?hu
RBhh5P(Yh 	 3_
h ,%V=(u# u)4^芇<2FF칊𿰿FB&<6	9!1v, Pf !0¹fv~! ËSVr! hz!@A \! @ P!!^@D !@00 3ѐaapu- = w.|55 5,585D5V55 t!v3'Q@`}!~uw	h ⴱs=U;j.Pᴢtua u_jq[Q&Ǐu6t
0
c'F~' }AbtܐQ&$A= u8
 ܐ tB¾`F9oF~rQ&GA!T V!EfNF%@ N!( `
p`fj}B pub Ea duSMʚ;dʿ= wč7P7667AP0 *Vp≱v{  8fh[ +.Azfj
aO0%1)B/@4P
@	N2ePLPiܯ[\CD ur\rHAٱ; v N0PQD\& ȠRPxS۸@,  հ@t2SF~|QmCfj @p2.fhTveK
P@۰Ept`	Iwt= pwpa\BBpDtfhQ7۸(ì`	0ϰ W@w=i$u` 	퐳@ 0Kt7`	To_h a3 dsĀu粼0 oPtn Z8v 
@8 se	N=ut=	b

0KT ^&ptbpuDWPٸ `$ $2V
fjp  &Cp& $qP7V8`pD2fc+$> tV΂ )
L~d}r)\%$@tݱ,u΁C<`;t-*ȋъĊ֊n*ɋVԊրCC*j P\
{F3`
~+Fu. {!u 5t逐  P  Fq @47T7F;*qh{JG3 [~_ {=@ @r^&0fP=
&GY #==U=>?==> 3?FWSV  ==C 5S:Cנ𱁶CD{
ڈsDG&9u&9oWuCvR;~Gj{:fFk0vwF0\*FV(׿ a=@ PN Tb
oh\,C*!DֹG*$Wt\u:PSVpZ_7F~}+F%fFtfv d@}9F}v 1F1)뭳P%Bm
qd \sNr,u3QXp um<L	 
 FF@}NP[ 
Pi t^(7	zpj֛0Plh@vjlw`hh snh ®hajoR0\Z 
ylhlAcAnihqAcptBu0 ffp_x^9 u@]yy 󄴡! j}ph@qoh|`^`bi;rjstS_xy'laP~5|h怆vt iP{!F~PipqS]qt5rׅ?qad~}TȀ `;qŃXؠ
pu٦Pp獲h pAcPCp7lt Ung0tj[^=uD $EF嘦G嘧H嘨򠘄 !StyޤTtn]{tc^tXmtM
tBt7t,t!ޤtt!
MuÐ2lV`fRaf% @R0gUdG>2FG pË9Gu" Z?@+w/K2 aP7@u`OG"aG@uuGN20KgvѰ1 !3<}O0P@q2"0KtWӯa_G\^fGt ]0bOt[6X P0G
^`9_I#+U
о> fGx0˽뜐^GtWvPb:8Sst2"0t(r}҈F@ȞtrEfh `
|QVSƇmf+fqǇ  >Gs Pdf#hj#lV[n#prqvtqwƇb͈q8,t-
 +'%<&0R*k>0:P0ٯ p`Q Q {Q t`RH= wSpF F,F4F<FDFLuFRx*۠#d40*99W$rLw9G"vEW&O1i  p GǽGPd  i^ _p ё Wxp 뤉VҊ'ߗ rOw9pvGÎ 8G &Y8lC"W$xAf0YQ4O  7P@:u dVF+F<: y<Puӿ;Ftb~ P@  l &gn rB\/f0*+Qḵ'`̱@BA7N1ð\9Fv2`NYf3ff>Ь2f6>QNX ]/DBfh  4t#f Mϳ/Oc	2ff
耊fP fP ff[f ]W<O_]:2C@@QRN;ssZYX]1 	Vff½p
&6 +&s	X	S[	[P6aZ  ]F| f^fbFfd!hF jn gVF ȲGAP:(Y0NV)D&!=G DGh4GG@7G"GpׂDP:	0I^*船>F*A:P:) 1%t"h"'$BG% hg(svވM_ @`+wF~orؠpX$Pq P:h.(ptf.yGD>2G{xM#G T2T2
yT2sT2$h@ 3 P:h`À>p"u+0 $Q"Pj
 .Gtf 

YG*HtHHt7K>G}<GU9!9]
<GwV1G!8H8"0N#FqpxP)c	o
u!C	҈CX	aG@WB0ahu?^p0&GM%H@F |W 
D4$CB#/E!vnPPR	PXTÇ0fP <wCP2L_ 0Y-~'|FM
fj-NRuu`bPv#ͷG"fWG0V4V<讁͋G"0W8yk,p*V
Xހ&Ѕ !aG @PS  GQCGQC]GQE QQE_@ B_W  0_W	@ߺ _!W#_%
Rc _'W)1`u +@
 f-W/T,#+@1-|@ߺ 貃f7W9-P_;( 虃f<W>$ 轇f@WBh4GhD-|`!NfLGBfN 6xf*@R eiBSfXBZ PhhIPd gú[R\] )[G05^^5_ѫ1`Pb#za#zaGߋG"G/Wbw#zbIe#zdJ#zeG#ze,#zf)#zg/i @PzjHkhlmoRpq}qrYtWtAu=ºU# !]F^^&߇}^-^?a׀ Y`QGЕG1F=C;$Ht	HH~: W	=@  W
t=WtueNu	2p#  Q"sCp}-ufช@")N t݀N뤡#GI}0t0rQG<)!phxrb ,~xG1Ihqf=:w   uЕG tGWn *G,pn@t)GWRعN.G0Gf"-`0*GfР*G%`F ptP+*G0@)h`
@k8t1`hj
0G
h]
@0{

10 wARXLPD+CC& `_ |pRVFse^&9G,~_q&x2 ~Gef&p.fvfċ@2
 ÜX)FIoDp D PD	TP˂Dû!G̲\pKKQ]YPfP44b+0ԡIPDFfp 8vYh	`ч0#9 V<Zʠ}q2?_	>wD uwDvD/tD B;ޣtDvBpDωrDAtDV>uwV+pDpVfpD@sf/ 0P+9Vw[rPw )U[F-F8 ,Fqt`$* 	}	<u!ĊfT!V ȋ ֊n* ]VԊwu		-t?-,uB	  Adapter - BCM570x NetXtreme Family B57hHardwareDriverMLID do
  #""`X  0	 Z   		  
	 ih
 O p	

`gapphi  Rں  ZWPPPXXXEP"[[0[[`\*[w\Z|\\/\`\\!\"\)\$\Z\K]E]/]Q]]]`+]+][U>Z4 \+&Uu[p 	X
 ]˺Z SVsrt*ݕ+Y^[ø.3Z* &D&Tr+.+ډD&5&].3Zù  ZøtK
t(S [;Wrw;GrWڋR [;u+u+ۉD 'p+DuP XÎ\.Et߹. 䫋ǃPG*_G,_.O7Huù@fR.X tXu跩 &glPgnP7 ñ..Y.ZYr0`7Gÿ6Z P(7t&&ߋTW0'L+`$`34< .:'uOu让.3ZY+.:<uuL
Lt\
DPX B~u< $s"UX+Ұ.:4Zt+EZnZ]8  Q(Y :OΌOWti&7`:& KD$V ^uY&?,Y AE"u.oY!P(YYV迟^EU*QuMZYcQ XPCu.4ZeZ`]Q".>uSPu;YPP5PQWu(go<Z<5ZD,ث+|t#@3X`6X~0`<rg3.X.X &u&D=vV pY3M .nW&`\9##At2Z.9Yu.9Yu.9Yt@RY.XrF;wrZtItJYE ]'XD&D tz}a@Mt] ss.Ub@_YQ&|uY0GdE
XEXED)72Z Y@Yf<w0ZX
Dxt.X;wŉ5EEEU.>XtE  m. ^M
u+P.XE{PXEnEn
EP
ZE.;YuYuJ&Dqqq3&L,p/&W`2&l &T*:M Vt
+;rs*X.X3Ã
Ëŋ?+Ht`3iu&0.ٿ]2Z+\2r&/`2Ius*\`  KBPUSQRW"$_ZYo[]X1GD*'5Z+tZ,T+ێÊ&SX&G[úY|w! Lr	t+u0+YTLʉLuIuËDDV返^\ uAD<w<XøZøYø0YWVQX/ Y.Y1ZюююZY^_PS [X FFt%&?	u
h?p&FAЀ? uށ΁?!ߴ{u@2`QR 3ɺO>3} V
Ftf?~ t@Ѐ  F&VˀRPWV~NV^_r{~@a1WVS3}GVڃ؀_VF
4
V Np3@F8@PVٱuf
r;Vwr;FvN3ҖOu؃? [^_]SpߋN
@u	Sf{
[pۑ/Cȋ^զWۂ/J^r$00<9vF
!@/O oϻ/O o¯/O oʏ˯/O oӏԯ/O o܏ݯ/O o/O o/O o    
    	 _BM "v }( J   _    )?_! P 4܊p,@ A4$&"@2
A, R
K$

 
a
(R Q
p _{Q0OoNDK 	Rʹ	 q* }	,#%}	ݯ() #,,?-x Q
#1/01+5P5 /4O5o69C3 #H9889Bq
T/C '@q
>+>::8'! F^B*Z::%3$CH cH!SF
H<8H9 IL@
<
IC-P: p@G1'	8	gSZ0:X1Ha@H@5DaLYZX\W C#`^6#G[/`]fb\ vodefg hj/kOlomnoC(1HXP
0P!rrH	\Ԑ r L rt:(p
`pUY Lsv:&p
b	K rͩxv w@w_
zC"p"!d2t8r xy@zs Lry!d!3hquty&B}hwu|B}@xqu|3A}jp
yrC  F`szyIB`wtPxA֢lvupRF@0YvwZqlwfPKyAXဣ@z0YzʀF  w4|!3Az` tA ^u
sLrw
sZ:!H	ͪ/q	I@XQ|qI@VSt#	Tu!_ 	!y'R z]6a|XPp
#t.	!N:'uʢѠ"rw0C`L:!g2Q70z(622AJt!᪅4u
Hrw ܠ҂*F:8z4װC8s䲪1ͧD::u6w 0ym<綅B:>4|t!u͉@Tw8@0yWBXz!B&Uͧ>:D	(:b`tz*<`$|,4L`Rsyu
ʰ<<:#yw
	,AWX"rAyߊ҃sQ|rH u`tF@ uwT$L!H:: βR|eRՆݐ%V <ZE|ǈrrStA젎uޱͻܠ(He!Hrj4C8: \ǈ̽u. ZE$wϭ|;Ո ?.S?@nW:  rz
@
| w~Iom e/'I "_x$'Og܏*Og :" ?rzO0O䠎<% 5	8AG`;QOﲘ́w >O1|$2  D( QEY^.mM$ ? TzX3v ΚUH μhK[ѱ[BMOλBQu߱` Ƀa+T@ȱ`2a
dedfZ@df\ׁ@0̈ek$pl^ {b##nвg@XAa+$2&Z"RA tXk 0bVĒe7  zaV z\V_PTcNRCQ {\PVH XeK ۶6NPEǑLz3L6J}R`A+H=cث# F;𖣘ب᪅DZd BC⽻r7!<͠+E	 Tq#VRB梨 "ѯX9r7BaZQ-00Q\.0^h@1G,0.(ҫ`&d01tYfx82pAh¯Ah$'lpAj¯bҳC٠pnx vK @a¯ u7~O P  !@`hQ`9@b3$fvA|ߠ0 ѽ1@đɘ0)`wTaz2"aFH7x[aK@ѳcVb=@1: 1tsހtWpҳaDϲP6         	 _BM "v }( <  > _   H)?_! B 6(r&u$~u"u
p0ܾ0pp`


@ zp`Z`%B	 
*  ΁@ 5YA"a$20@a! H͚g$1&0R1!%4@tA2(
P
PĀ	!"NQ
s$߀`%!a#r"u(r$&d0*$pH', #(-~-p`R2B
)ޡ#$-,A1812 
!!55"8q$P6228`!	!05΀18@="0!08%?
g&@Q.A8B0Bρ$E*"5FF5QB8bHdG..`NF5AGLr>E3N  `%6dP>T$DQ 7@SdP!aT!0BDVrF!PC?
% Q%02"R 9$QqF&5A1%\p!] -B;>#)DU'N% c&-R# -Q\_2eZ..1]*(722 [Ai/U#_.vT$h01݁JU
s$UcH@c$+AoP* .tZhsD5 W&eva%$UXUw rZChasb>1c)\z !^%|__} Ch[P`b&p2& uotc `"AeCgj%+ 9B$U\$3n `n,2Z"']`Adn5_ u, 3q(b0]!:es\zW#Up$9!ibV~ !HaFY _%@(X& !bc$d %adJ3vy$?.a%Zt#ré~@5TM%p'8a>SUTVDyՕ qM%o Q;4?q(%r H"!6P^0"85PC Cb)bQP
ucRhd8	DMur!rfKJʑua< AF Rb%UJR+
cdQ=qM$R\d`c Ne
6>bX
a<CB@(@P`Spq(? A4(A>f)q2a<A@(X1(2NQ<Y@ 
$M,0p䑧!I, 9`.fbg9aF@]!`.DA(gpM`24`.$ r&a%S#QA2A(AB(R! ^2$7A41\ TgҪ ^r) ! 3#!# asU bG2aCa=!1ߠD1RsbC`ޠ L( @d(V> pF 1"b(\2"ɰ_  B	     
   @	 _BM "v ( n s    "#       { b< I 3  y["   f0  f#b32b2b"#1B#fU" b	2	#
 /Oo
$3
2,""?"EfwveB/2(EgUCBkd "%O &$R`"@0  !b 
SeD "$@$EV{#t "zx 3?'u$@'b H '@#1%x '_ )qCb"?&[]-/i, Y-QG.@#9/+02o@* I"4r"@t.BK.?4P-2@64. 2`# X-/2O1-Q9(/`2T`9@*&2?;/j2n<!@+E_$#B*#2B5X9;<>/
< DU I Dd!4w/K2B`D#BjDDqEgD&2oF/Z DP<;2HY Df29/N2;K D\NqLIj DGo D8&<u2@6?bQ#NIJPzQqE 9u 62B?3@6*GoND3T1EOobNVID0#@62OG<5PT>ZQ_Td\IP`4ZA/@6]p9]qQb2^b_AcS`qEaq<PO]?(OAcfB@9fA-GQqQf2Q]<PY/PZGfHEIq>A<`/ D]9]D:d+hon>qQi?F1pnP_qYp/4fYJCn nP
i'bio ^qRDWn<pba':YqQdQsuqy1sdAOb>Q_qkfn{(AcWD"\i@z+B!O1Auo#dQEbid_n{)_@6`B@3qTV`R0a;EhCJibQl{Bsp_@3S|N@3/U%WၢMEU_dnvf|Zf&Ď' qWqLESK govWj@@(9?fdX DA"&^PNOk u9G6#3qdw0H>ѓ<ϝ8QrgabR?h`1wOak"4KaB`<P_ADbEz@V< 	? 71j1Q_7+H<Yuw37$_k2EDASMq_Gn#d_SdFiUqE "usL16i9u_U__N9PC!@(V/Qo qq9](6 Dog- CQsPںvQWKu<@DB/ uwc 9tqTQ]eNYPº@pqE<|9'_KBt@C1[tׁJKqQn(OpBp Z2OJUW2@uA#`Ds_b4OZ 'uK_#vӺaDTچP]]sϛ2npq;H܀XNKC_uJ2y0@ SudD3`qQ*`.D|bE_@CplM?[AFwOB#5Q_W1R/ tun"K⇰N&9;-1iad>^B*+29;3@ p#| 'РxQMS 59?51# -Т?`rs:	]`51W2GNS^$Az2/N`5?b>z(baPI.[Odb@q-pLP.].y>@(W?1 'J`rS-)rĺa $39cpE(QF/Q2Tt9WB&-.9+Udz@0x
r	;#F )9W]UUy =Db-P<4 JEz s"w AsD*PN"1B+T?{ rUEq JV"@:?H s! 0(z=":V"q+q//RB@3Q5% A uA  52B%\sQ!Ry`BB1g'@!8s0R"E@ipqX	*[*! \Tb pa	**h-@)B1REypDh- \vfҸ"/SV" ii*2	*"h(J5$.$r	*M&"a	*(4a{	*,F0-@.W B/P14*WEfU@iU58p p3AV"f[\]^`?a_b"# c2b"2b1d#be f  fg       J   `	 _BM "v ( _ }    f# uf ) 3  \ G? T>B   2   " Z   \ X"  A"T3A"V3O2"	Xp	B
/
Ohp	OcF3V#wScAn@
qpf,Jg@`x3G}v9;Ҁ1D_ ~!30`P"NN"J$'#J%X&7"Q	#r(b("'&f`N #2f`bw5`2 ,,V*`0 +4 .U&Oq+^@0} ,3`9@0>]9@01ISC$21c/_ 4b 6(媂3: 42767'4434@073.397/3s84_9:q83 6a%.<F8B_?"K#E'A6`BCDEFJG@H/IOJfK/b ,P7(QR<./NBLOSS6PQ0i@01nB<6f!"4RT5րYWSQ3 #6+Y54Y1D77;u] _rQ<U #9QAW #4`1 # 8cAX _rA 8q<Cb:b 85U3Q&q<61gf#nbRg(37Hq8jbi@XSHj Q<4`ielnoпpqrt#&tXAlݿ< wJ6wZ9y/zE{2<G6{,9Uzi% ~6{*1U#3%]6{(6S ##UTC`%6{&6Q,% c|q| #%6{$0S`	Q P 9e&6{"53!U	
 ]iB@#6{ 52Z _ ,ڀ f-%  ,-j@0ꀂ`	
'RZ&7
3) }Q= 4E2 @#!B71^En! fjʖZʗ5Bѕ -ʖSȚ 4D/) !!$z"$.B1.I 4PwBj!bUbނ<T]]cN>U.hbIYj. 3f12p ^ѡcJbƩ^aaD#a`1ꄫ"ʀEb_5U _`gᤫ:@$Y*^N@7 c10M 3@0UaLѵ૩_A`2ME%	 _/ _3`gYa @"0.1}DQYY*@03I૿T0^"KD%Y5E9e0Pݿ0LőC_7E@$1`	101Jf6C84[%³M0]b2)9ssāa6 _5QQNǤ0 >Tб5]9@$UTECtQ<	A1M 0Ⴎ➐Aa !`	SQ7AEBᩀNDbrCb c褲> $ QQ	^R@kЈ @0頡UTj #
9CDq2R B
 Q	7Q	b Y@"R ю3% QR` SꂀR}~;aR)." UA
'0(7'`|6T
+") 6S ~`g0'>"]"{{o`X0bp`	ݘz`vzxRxG!     	   	 _BM "v ( k }    ># PPP  u 8    {] V0 3  ! `
 1df}hd   j	@ !
J@  
u
q:@
 `W@
@NbS
5,"
1b
B @݀
1 Jb@

QW13 AH@L@`#
̀:Ѩ"#bqѢ)lq'#T&)

 QI'1-
Q!@,-4+	
R
<,@

B`/ 
q2A/(C+1*
"'ߒ(4@$6#4+Πb%596ޢ`;#99%+#DUDC/&W8Q?9 4KU@$qD65Y<  $U2%BQ
U23/"-SI1+  ?UBC  K%US/>KE2L<  
{ 2L:M%"UT/8̲	M5$0LOE&0L6	0K*pK4UQ,G2UQ./U?0UQSPO.UQ%00LT52pK,U4S*UQE_6U/(WSgXU8pK&W:S$9ZzPO"W<UR\=>S &]PO/W@\^WBSMW@T34QD3E@OEaT@CjdbTab
@E2O)U@/ bMRaO%eO?fSfT`epKBecS`dpG!VabfDej$f_eEBf3fgza/`@/S9TaS@eJ@Sg_ feoBk@l0j@mSmH1pTn@#geSfqoSo_"p/@gicBSiQb0j2fqwjSjjee?auEc/96R@?$ig?`f/bfswx|	5 eUlDanc{P(!n@ffm@feсxPn"fOwg4`@5 d?Ob"glG@f$3h1t?@}fqwqmT`@4cFb M/abaDpKuO MBE@m O/	K QP ORfph PD Q?	GL0O D/#EJpK
?Pk"/# Hp@FpK#}0K"#paD`V?C+6Q"/	0$
 fgwgxoC+D P<C+xH#@@hJÒ DhLoÒG l K1o:&yMy4cMa@gow`@i00ƌ	2 
o` y.Pƌypࠉ*CQ@V&࣯	1 }&f{&q$0vQ ` oJvi ģSi=y Pmy Q!oh`p\2j`Ufࣗfdpp `zࠖ H`sQqv1w"Up`	`oi`2+p	B@y P^7pDGb@x q  ]7TDÏ  	i2ŏೕƀ*`` o\qp@⬀ w` f  [qUÙ@*Q`ࣇ`PJϘ࠙  !р`*&Zo h©ʑhbՀfXB⡐ 0 WSТ1``PWi`0bPR ТV	`:טv@QܕT p"g S`PSJb`ՈEoSp@ Afä#RM3`!ACQMQ׈q1pO"PN" pMpL- p@y PyBQDCVH?gwFoL		 IϤ3ܡ_^Ѡ        	 _BM "v ( n x    f#fbg NCD  P, 3  V  a |b  "   ^  #HDUV Q
s 5U`UUPD2@	
U_X
V
/F 
Uhy*
@C4w9*IB33bquCb@U*U b/ ?C_; b$ QJ@U[b
9'B1? b  1)1X
3I`D"IB
  
dJ@"#P$%%!C
_ 
`(K#*+,$@..B0S!612'- 4@.s.d*B&372 5@e--: lB`32 *?4-@:rB4q9R1 "D3BO9?:X`0F 1&Q2B - ."MS% 1IN uPhOC"ICP!Q4QBJqG.TXTC@1	R$	
sOFX@	XPK"*
ZszP9 \1peB]3^* q_feZysSPa! q0qeb ]c0*ddcXK9f0aq̣fhd65ie@.ih<2iiXǀ@jf`mmF2io
̓O3qOoHq0˻_oJanjO@qm$p0q00o_|Ou|Gvbd& \[tfr x_OY#y xa A4`f`{tOuU {|aש4Ndu  @u|a)@Mh
q0sxx~|{Va#
2^P3U+b x t̠_p_q0$f+1"fЇrBw|a_(4K2dRKC@w)fKj1)KIË qwEbb}@B ,P@:rd%Kq0 sY	#`Љ|zpq0qGb:b}EJDo@;ܢ!$!
bs՚b{)``0 @
fwq3qd2Ⓓ@ur-	{CDw1CJ``{Q: SQ1
f`Q$p`$`{i4`Y@w@Sc xx4a51C`01@wQ2./C"Љ51`/Bѻ 1b 4rȰh3qubD@*Da
bq&3$25Q@ IqR@wu)!`{`"HQ Q1p@w̔; ϒqϯ`dqT" ub s/2U@w2q	*Btϑ"#b`BBQCPb0")5S$b
@w{@w'D :@$Bw߰aCՂ/Q1?S04B̿qmB߿;@+"%$!S$4ꑛKAqRf׮b;Bwb`0?S"Dq0p*N9J9#Q/S1CD 1zៀH5г3K/FRBq:#"wfU 	1S{S  p
`qR&bWD;;B⧱3ѷB0r% ٗ!Uq1&6A1B/)@a327ʯ)QC*侟 & 1IsʫCP#Bqӡ/ $ԯ`0I۱q酟 FBwsqGD$sJ¥ sq鱇IЦ4D@0h$Qq=J qCDIaD1DpMpj2qDP=q
dq/$  s;6ۂy˿9s ў :b.sq2(b/?a  ]+1B>pM-C ;3}SFB`0 b{6 s-`1zJ#~`AnJСH@S1tD(d`pb{Ja`Ўb+}t(!EbuR{\b{JIS/$ (`pwVVB3@s34/ Zp] ` f"]V!Fb{^"  4W`p؂Ї2db"`c@0F-5_1f9z11C*b 3_rjЧ$# zqi` pR~dSUP8fʠz0ha`#)s⟔%@k
b}`$ur~3G9qs1s``}F#$0`z")"{$1Ӣ|&4T0pz*K"@K4sl*pt,Ս"w"])0pB؄^p{z(G\q;  @w^w|          	 _BM "v ( e }  g Q#3 f [5   [ s  ? v! rD   FH !	
3	 O @
Q
?`1`-`(g`r   v o`g"'h   B  $``Р`
(p`Tr "/r?(`bf! QU?a8c!0/"O#N%31H&O!'/(D)X(0 `
H&@(!q.#&D0r+8H&Q' QUO`"b(@7w`S0*N6f"<q&!Jb5fB`=T==B>f` !0?C& q=v8`AS6_ADCwdC#B Q>
%#
r+#
XO	/KK(&<K2M<w߈D`/H`v<K C1GwOODDQOuUKq=gD Qy0RbO5KsS:DH.~ R5QKMUpO8QDC5#WB`X%&@;&x`HH3TH5KW"2X(Y\Z2TS@80V][Q"\OH|1TTw
fS|T ]H`b`bUNxHW Tbac9^*b1T bNU<`]gr&q=Wcbb!"ltmb@
GGx` qOOb"o	eb1Tp YZA@_QQOPp Y!i  h=q@;QYROeqTr#tt
1TFv12^  @;'@lw0! Qy$As^Oh@;dnb QyzAs;bh"|}{0bbd T0}@;( r~"|p(O2smOrr@;
p G'V` [PePxAH&pxo"gp H Ѓxq/"ube~b rw
?B"eQQ ݓQqQѐ`D@lonۙ  &0V3!Pq(P/p$" Aq RbOӔ0Q/ўQEoOt`T2wo "@l`T
F" t- LSz1-EoB!/b1 ­P@lQ$Q/әd&`Ӵne 3No"HBhqaκsoBByQ"51gL-r:q"(1_1m÷ /`Tә"ĥPTQQұ'Ʋ!1-ݺ3DS)F" &SQ_q&DV}Б@$tF<02	Us(@s֢Ƅo8qa2a$q 1!Pݥ` r1(/
B!ݺQUT O0us3s& |hQ3O(~stb|d?ӽ🄉"O p b12$ffxq'ۆbS`AĻ N@U1-RrT"}q ʟ ХW s1 1qa? RpR!$ 1&?ϝP
αqw!iUs@u
1qӔ$(H3/SG< ^T
&}3@s/@;o$s [qa p3 2|Կ "&QrȽўUD{r&B b5Ѿqۓ?Q8ӳHBQxԓ%=V@Tɑ5/ m~Vxӷ?U 134W ƀcsBsSw(s 7;R$z.3svuƴͺO Ō8TӣǑ5Et/F㐁O`Xb`$1m1`3Sp ђ_tǰ}
 Y/D1ѹ"h Rp+$b yQt sWߥ~SѠQ4b y@~6u(Aorɀrs0=~)'`(s vtewA fӘyDpЩohZӘsjLk0z2i' ٱRta& @`@l p hsޓo"`v h߃P hp|Yw'x_O
"_ h1qYw&BgbPn
O"v1vAEf'PAnzhz:v'kOAoB@l&;$b:(R
Gp&bL`-g-|NpBDvG`sh@0SYӏ0O
fApdh1rҏ
f`  horm*Hv(2xSc]$Ax"$-P"rSx$%Y?&UHwawO*sgwf"@f:1v-|.ROxfQh6
Dh2Ш$LL [ XШh"Ls@!@Dhbh ߈@DL    ~     Z؎c Ћ㿂Zc+3f  h L!$F10fPfSfQfRfVfWfUCES>^  fB  _  ^   t^  t s $s@P$ ï t
P
@@
 
_apf3u 6R`< t_f3
 _>R`jR
 
 _{ b>__;a 3ب tKPPtPSQȁ u3Y[X	 SQ3ɽ0	  3 w XP
3	2
 P 5P  f@f_f^fZfYf[fXfV 3b>_ b t
	"u& bfXf^PVW 3W XZ_t
r
>__^P  f&T f. 1ff&T $.ft& )Ot..<xu<\߽Ļμޯ۾ݸҧخ͵DD(|/8-012357!7AA$$~"!7mA:90@?<z<$$$ >$9 oI?0 @`:`>q:P?>>AB. :'YaD9 @9GD$#@	I!!d9U;>BB$F( J)))**LkLH9BdK~B<y<I  >""ZF;SA@d9lDMO#<O` @;EN`7A	N<h3xWObM'yLBvN2

	YDB9< D8 0 /p"YN8Z	

 $BFDEDV[AtQd;?((DDD@9$$DBBDQ?9
)HcURs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩猳ăHHoזߕύXIAOԂeLǎ҃phdo@\Lu͍cInIڍ׌߃OsJ\gpjځBȉymFGł񂪓r݂OڕKvxmȂxrWԓtEÃ_xƂ׎쐬݉}֎~HS\zԕzfmQT{ǃ|sFV͈vd}YiEь십ċNԐUiTivǗ؊qlӔC~t`֖ؑ{pKWoYgȏlϏ[ߩxb m@< 	i޴   ?HZsNҊ
 P 0 `  1!!#"& p4`c~|u  p?P  7  Pޥ )@f G@ cP1 02  2	` EZ   `00PPB%Ҏ|P<ҕ`Њ 8XPaUD`0#8t @©ԗ<   UP W  >"6>0?Ǉ#@?~!B""!B'  /!B#b&2 é`   ࡗaLX>ap1@@@Е @Е Bft,0<I:0` ~`pøEc P&P 0 UV 
	0 P $&# !8 o &  <| D~D D< B f<,$$0$l=  ѻ̀3`0 ?"#!O! 0@ `c 	ԏ C8P?!3pЀҩЩҕ\@<| %rm  2Е 2ݥ  1$Q$$3@@@0!c $2&f# 0;xxP@rcxpP0E?V@@`)X0$x|pTT? T8`a  3З0 @$1$484(d(lD@&1< ?! ?&!<? !!# fo4c?p|E0 Q[ҕ !c,$9`0pCIb £ @ !$B'  01d  ӤIi&0#`0C
 _v!@^@"  P[#2Bb"6T$-``;9@@` 0paC 0 0`
$Fг|s"ѕ`m|%o38"5U QHU' &a! 3?!  !!3#A?2bAb ?1`		
	`21"`n9$i$	$	p6"33a?Su/<0#!"*22Hi)""?"!pfЍ' #1φs< ~ < Q#  <$$$= ??d)),?4+fI"́'0ೢp6( g}0) )q6&C_
uө@  @0؂<^  </_=$a0<p0b64~
*02hHڃ3e  =  ~  <P D=<$R6˱\5''r8?X" 
8S< 8P2#@q2oDRD?'"Q@Q`AB?V YRB#09bd,Љ%}IHT1Hɏ@qq2@-p !
 .:23V""&  L 0M^rx_+" ? "2"R"  @@Ѻ4!S
S0`&Ue+W4X%HpZ_D6bp `$$ϝ~(3H2~RHH~HH   9 "} 8F 08R)C)E+D:< ~"""6_@*e6q"c  2"&	$  c2`Q>"b¥'^gVOUDF?e ůÊREb@5F;
.BF0L B?$&""  0p	 x ʤ	#`4 c} wsPpP !
( Hx4u= }[4a00i#!!`=0 `yw`*p7 H 4 Lb2C"cy @?`M@x<p9 ( (Oi$ғ"?0NJ0 ?8l>qh&}3
pb2  1#n%sr7$ % ۜSvG$?a6%Dh|0  1  !   ӫ1(    77 "rQ0Ɓ0 )o1 c "򮄸aY
y
Of  ɠ"!AVW4 <0?S\38xЃ~  RR2R2RRP0@Bb.aq4d  8aҀ]cYOe8P
 P%$?Da,=%$>'3AH`BVC4S`"0laY  1.9104z=m4С8a	  6 P> pZL D SBf@,892kO&aV1]a3"&,0q҂zoDz {<x |""spQQ 8|	(9H;)*;*$*%+8 TT5Vd]Gp4^ς5^Xi@R2A3 p`ߠ< pm m ѴcVpI @& 	^~*H00nOK6c8?~!}B #"߸ߡ00o `9 80Ij0]0^"***" /"$'$&*"$"$ $?52]Ei?0``l?~$BdBpB
BB~10@"&D$(-y`6,!@AiAiC3H[9 /Hp/~/6 =I H<H$H$I$=> ? ,>@"@">#"D"l>("8""8>(l6cR5 S '@P4R$zeRUS R P~jY f:֥ArWWp! 3 ?$$$$5d$Dd<? ~  0]6 @0 $D$y=׷qi?RdUjY05~2D"/$y,(8;(lqD?  /"?(/(/(hOX %!"Mr pV`abB =	?F,,`nmA<(00\?$ 
?			?R" Nd@O?0s0p=^5D~ ?= 6P!< %8= @|D< !!"!"="Щ""?;@-BF\p8@h@%A@&Cb>HHHd,$|$`0TdTDT<]##d@@>?M $ '$!$34, g A>??$푃- .1\ $&2 f!F 0b62~Z*\*jI0 /HH0	  y 	 	5 	`;v]@T$7C'AemA`@?Fp~z!ls0  B F>lxPXHL0F`C{P 0`I0{)$lH UIHUH~HHQHU~{HApDC!!q`38 2@b)) ?()()~?H!!!aG|eC40p zs"PK7Dπ Sp`D( OF7p= aQ Q<$PR'0"" ">͢>>BSS "&"cb@m xa𰀷_kul2j"#
 1px|  80 S#Q8#co8_<
ŋSp_P  > "~&%,(l)$ P-m3z @? p*8 ""p  gbB ߄?~>
(Lᇥg#N&3pCׁ}p8@Tl@\l㲀qx	(	)	) ( )H	?~"!u"2&460ba #F8"S@@8pz{!o}0q$&bBO6  |<  #<͔; s `xd9s9ۂ8$N
0 	 `p1 63_"f ":|$%@Acp>&@$	,	(	88(2l"FfAAqc*O  3
`D(z

Џ
06  p }#["4&0PP0`@   :
o uUcuЖЖpЖp*Ж	pЖppp..J)S.H)YF)  [<u.J) B`uVʊ8r
8s8t>8t: t3-v(8r*<rw.@)` aa23P  P#"RV{^Zua`R\ts 2ƃǡG
aaO sVENjW12wts2oѬ T<
t<
tD<tY<t軮 P  VP t	| tL^fn!t PD0XM Àt	¹. u 2 T.>O)u W.  Q `.@)& u2CQ2P Y*2Ȱ&P aP`RDr
.P).Q)PSR && oZ[X OCPPưQ ǿ.6z)F1F2qP.P,̿WtO_P(5QR.6F)ʊƳP ZY[XԿ  pB2րOsP2 sP
X<r<0<ràR)  T).&˹Ru'Ta`T)30b܉p@|).>z)P2X;2$CF{PQRWf
_ZYX. 2.9`t.R)qߊD<u<<@<<@<@<@{<@<@<@<<@<@.>L) t 3ػ@ .J)G.L))O@.J).L)JP 0..|).~)e;P?  XDQ@Xd  WV>	T
>  tj6 hm_t!j^\Z(_؃&  hEuAjF4_X' &=>' & I' o4_% = [bU "	?' @W&"	#U
{"	$# 5 ^"	Jf]ffЯf4"	N&_(_ѧ
"	]% QPf>_^mj_Tk$aj`U
"K# & "&_T_bW"Ah/ b-"a"D	/%UE?'b(QChb(HtĊ&zb(StR0"Vjb(U`0WۇO.-b([
a(v|P	u 6=6 jXVg"9i<!9(_ u6 = u8_?  6_t9jU9# 6jU"9w@&7!9^jQ_$%!9fh  nb!9 t+t'{@fhFjn_$ELbItL,at,>jh_fjhI~`(>n%j hnaLKLR~Lf3f
Е~fpPPFPhhbQ@RJqRh1R3FQQHT@R=G#~Th$`$Sh  L$`AU,xUOQ VQPUU&Qha1$Sƀ[AU@FZUq][BVvc1RI\vcAU q]_XQ]DZrx^r[o^袽_^AUG&aaPh0]FRӮA@Rh0Rjhh!9|?aPfh MahaIz@TI 	Uh^T,!jW^nanoj~Y nten%h oRo V!tnJan] n:en*hZhߊ$oho\wnHpObn`gwTtx͂p|^_  V"b^F FPL <tPvVFF~rpы F FIu0F&6-^ fF*+҉FVc+;u;u2ác9Fu	9Vuàc% ;0
;Ð_	c% 	ኧʋ	|
 fWV~FF&8uǌ@8t
ĂrƋ*
 uFD?NuA2 WJPF fj hR*0i{ fЙf gccg;#!&]߃&6_jLfP|Q  tj0PQj FPїp!
 MWĘAF ݭ-WVEPbV=ut_ VPy#$QGF|ǯ դ0na2ܥ
䤧|kprԢ h &TѨ F GP嫉ѨFNuFG:_f?JO<7ԗ	PѠm,EFb㑷2 10EZbɑ"u>b"UIbC"bbs1_" ?bOC@#b2"$b2&5_% 5k_ Eob"9#AFu0660 @E3=A q6_S6_6¹`bkA
2&]% +1]1]jRKAȐ<u;@?3jH_c3kHK&QA&_1jEAb @EAp5aҠA׋Ƞס0Fll_jEdA2&'CDĠ׀H$AqaN٠g6r3=g10=jiQנR$jSҖC@UvC\V^	2&mjE[b92p/3+6l_4_ 0jXrF0߀m_$Pj$0i΃ u&(_߃@(
sTbAbl_^Z&h@&l_WfEW w6b1`
]@,f\ g¤kEEJH (A]$$h"bc0iњ	qЗ0i `Z^F&&g&`&` &,a &k`bzAabg bb
kt`
D_
nDL
l
"c
R@jLrJJ MQL L$}t`PP uJ t
` ,a Q1K u3K
? t0`~,a"z!^D
EOu	&ķ `zbZ_ r/dZq

PfR@Ph@&_ߢ^E>jFAPG=F.k"#F1#H0GH&a&&o_&.P@jrjw@(8(0(f~Ȯcgj#QQP
jRvf&b &bUu-&3/#&{3/&3/gb rw@?ahJy`-M"*_8 (a&)a_3v"lf$`gnZ	 a6p27v@r27^Z؃	s$2P9&^:ߖ:^^ rs2W@awa ts2spx=)aYw]z=@2@u*?F2@`iz=2@yO*?`vwe4*?2@3*?(a$ < u.J@<@+#+f<Qi A3hPiw0]S;3@R4"tnza#vZ0r7jbyΩawlR	p]?P6QD0F^Nr'~#t0X u^  Y % m PW1dVF  j Rm`oU2OXFn    =v3+Q`OY]10imcvB5_th h a`¹`ـaR6aVb`/aGb9Fdd efgj ~ hhpFb6iW^  eZ~uZ+Ҿ FVa \vƂ F~ r~tvtvuFИfv
0 ~VcWW,0XIuvuSI_ [t
Z Y ^Z"th~ fc~ !FB F~P|0yv^߷ KWF YN|Q}FFV~ O.FFV}OBc/ yBc@9 hvFW~_iaj
POGc
^F&? uvS^WV_BoZh_W\S^vۑ:NyFP{N0x.jav袑:Scqc?Д^&/G^FPZFcFZ˓SC_q&C_RpєFfP(a h=h~PWV ZRPa@  t@d  Z+F?Pq}F-C_FR-C]r h.@)B]@QB@\vIq3MP(F3\0`8F֡ .QF%6{,n/ӁP^F)C0 ]H0 taa0F]V 6a\r׊FP~2|Ft0x@pcYW^
`W~W	\s' _0v R;$FVT\QCI~ t;]Y+Q3AxFc~Gz usWV~~hN^`WbW}^_"j(b
ʐ1xqT ,
(|WVvԋNP#PԔUR6uP v~(|W~]r¿_~@u"\d#}HuB^F&u`W} Vd*V.2w0X!`1"%0XD9Җ=y)(F*)sŽ
Dg|aTU^&^&8t ҋ^^}۲rðP0GFpNP }@-Ar ~ߋsԀNFNG٠;uN& }03ɋFrPrAFC?&< u`PtfF ~~Ћs;^!FPw ~.lТZqWQVPCVVGV~^&FIu&V!q% 脵3F"%24_% 1j3"q>"q%UI"
b"q=  o"fz*?"B
U@#"%zՀ$"q2&5_% %9"$	6	6"b]+1 1]j_R[3h`"
2&]W% hK"i2&a&_1_(_j"L* @)!A", 
 )!a"b 0(!^03l	ol_jD"	2&'8!E"**8!C"*r )!H"p*A*8!N"Q.0 )!S"1**@8!U"**8![v"
30	+1p!0jgQ[8(b8#8i98 8F!t j^"9b8%8&l_'_ Xb_8'+$Pj	p΃ I&(_@I@&)a3vTlPaL$`LnZ	 n RpFvcGrF^󫀇؃	s$2~`&!IJ^^Fr`oS$`hHc y _"Da L^hI
L)a_ V2aLUL@O2NN[FOvcLrLUO2NXNR^L=NO2N#N0EE~1Fp & yZGpZp0]d" yR> 0j6 h
c=j^(_A b\!_jF4U_z`DRaa`u.Ra>a`uRaIacaa?a@`Bg#4_,a `Ag=ijb1iXa U`Bg$l5aYBg96icCBgf]fffU\`Bg`Ds
s`aaK&awf&_ss;wARdyy;wady~s$9UvwDdy	~UwUEdy4wCdy?|;wHpyޠ!Ċ\`zaaN\`2Uwۇz`52S_"42[_\`f1v_u #=b jX82g_\`2i\`
Y\[f[ jZ!'pB]EWVv͋ދ~ &F<t<
b#rF*;?]}7ɜ~tᜊF&8tF5|Ԟ<r[2V^u	A(| Ð!ӿ ~Pfh#  
@F;rF f?*F   F*N*ȁ vFߊPubvB
u+"b^F F FoOu𡟈g
Hf2b &2b&><b (A=Ӵ3b>?v0tѷõ  *&c&2% <c1cХouF=  xZ+N3c3@3ЉA Хu*c$<ržbc% ~Bu$&	0?u|Ծapf2% wWХ	u"<uUԾ1I 0Q
u6au*ӷ#C绑¼ 
}c`FOr"b #b$b	%b&b'b
(b)b*b+b,b-b.b/b0b  Ob8!F4_ Nl_f&4_`Z& &gI~wt t w uHO)f~ t?fh6`h苴
` ~rF*F*NuǂX=  f^#߬& f 0EFP9ZujzRPB- ZF  vB F~2|1~ĠF_  uF$`ǿFZ
 =aRjxYVZFRv0F@ b*J*NzQV!
FF|FطfC-7h  i!_
翊F܊fhe F֊fנt@ t؉Fh Svv^!_h 1
~Ssu[P MbmuFh=h{0 Ah FފfPqkFfᖠjyÔqk:A`P0F1F2F3F4F5F6F78F9FAFBFCFDFEFF~ƋvƹF؊GF!
ދNB sFNG&F;u
& P ^IXP(ᮐPj22*
-`i- B _NV1
K|⧽X$<2_$0Z6`&$j)Ma x
 eQdcvEfPsϋ]!% Cy0\S1- t*-} t9$0B#$&32$&Q&22 ӦOBkA*q@Lt~,IF#$3&#k$GKE­),  3|
/FPRѭr4P_888$o$2%p6_c `#2]Pq]1!jLFPa,j7Fj)3E1s1A$](*WV3_ W7^&@RFG|3XEF RREpFR& FW­aHFVGpF' J­aHB"W>_ \`aA]aA]6 6 &= P ~_ PFt  SI?O\BP"b
cQQRTOeV
Q
X#Y u	: =ঋ6 Ĵ &&TডVS~ t'j݀IF t/ u#'j b`H,t= t (*,au-aul &l X6_2tIC#S
ccj P4S3bՠ`"<<m_tV 2tC(_u2i4_(3Ј+1&_1Ј!  |mAGb_Fbapψc*aoana?apvc0`\\\@y_ruժu!vqvvwawwx\Qx#`xAyyy> uu[h hB hRy轊fb2bbbrzbbbjbtbgb^ZbMb@a#zl
E كyvbdb4a\zZF&? t5Х(u%&|Ru)u&DPƋV@ޠFF3b^8_fjfh 
  	   jVH~    u 0&&_ %IR>b^ tf@ej j 0  3= H/=
td-
t]-! - ; -  o= M - -  -` N@ Ӥ R 5_ۋ  &9w&EU 6P  VV{" 36#Hp  9~ H;@@@ rfQ>~{v&@u?_^2;гv鴰b3PwA*k 
 ?裖n E~@)нvZ
b DvV>
ͽ*  SvV *qFF^~0% 
P h
}bh  bĞNF
+F@F6!vvo	FQZNF@pX"^j b@ƍFPNQ='*PQEVW  PE 3_^E нDZ%1aJD0
FZ*YDF ˛;Fk|5ɹн_F@PQ]՞DVv1c轱N2p_F!t&ڍPgAp_u9FqFPFP~G ̴tqFFC PFpQA&
n fдQ=cY"DR6Ǣ瀽* B0Rg>Ѐ~v
VƦp_2gdƊ*1d uFU  ؋V[np]`I> t Rur3NFѓ 񠓾pJN&8tG{"pvNً؉^GF
&Ft^`GNktp
뎐V^% = @ʃ@Ao3t߀ߋ@Aw#(E> u#(31&*;tuor1*󈰾PF
tg
t"v fpv
VrO pB qF?Vu	aSUj!(0roVup~ܢl	޳ۃ>8_&dRP3>>XZZtN@1P 	r1Z{ >0=OuI3+ "; ~
 ~IZp~V~TMuquת~q@Zq}w#}#}F$}. ?>Z }P& c}wZrQ"~& AS(S(~1. *'#b(1$+$+q%+%#&P- &Z}}Z 9Fu`9FtͷP6Z6wZa0DZv&ZrF2bRa&O Z.ZZ·r-» 1ûq6s  r ·6A砛~ tDQV8p8Ib~ӘF.;uE< ;vP<u_39> ~@ a>|Z*HF\&7;PF`;F|PC~
G;>`@|ǋv>  To>p<J%q<HbFf&G@aW@&{G]Qu`qBF&M*+N"C&EH|&}1!L7tOrIV,Fp&:t~P}
A7FFuJ0L6u@CDsQ}׾ DDP 9TSa>@J*;}QUpJU~LuR̐3&8MtËF ڰONu\0 ItكH*G;߰^|q S,Dt3696tVoP9>`W{ 9
0_TSP<7 3^&9 ~)mR&Q&XM^F qAFtIeu'9Nu"^*& @g "C6C|ZAGfbTv
_u`TD   iF+F-   `FM}p3ϑn@pnooooCq ^ JFP| ʠ9|3o׊FooFvspvSq@v3rv±o0kFPPm+ɉFN+ف H&wwfFfm G@V@OQ}!{ 0 h"b~38tC8 kuTæ3!~^
AߋF݋߽G3
uTrb΋N3~(~0u]퐁2 F;|QDfVNVq;v<%tFu DDF
0N$0F
Ё`
VFu!pǌVtQ;v~^F&uFdW1c!s!~}  P+΋э8s,v6ˋ!PN&8 uN&= t@T0$p0fh  ZQfh 	QPf6 !>JIQ܀M4NPQj Mv;kWVO~Zacg3?~Bǉvaa&Ľ@0:f;~aZNuD0_FfAbc`g Iup0*aPZPVk0Qo0EqP9 ~~h3ҋ`Wѯpt4cP]Mv°""#`PځM| 0GW_^Ԑޯ M9Fu
л@
л vv1.ѡ?PpHVBrM0nF/}+F/- P9ѡकЯүTƐ}F@p2O1n0TƳү?0DȽ\ȋFōEPʍDpȢk0jb®0ѯfh  4@j@(rղ9PEu	fjbaA}蓟IOѯǹDn"g P苴  (R^Fu4Qj-P}Hj키0MRPȠVQݼAraaWVf AbspFsKtE+FFPFOPQ
 & pKo
P6GbDPߖ_QϠF{5+F+@U!擟@P$°E!	@ࡸ! ;gM*ARRvc V`D"􁼾APEDgH@F;v0Ju'P"mA)AUDIܡ^3rJQP豿I哟npA&P菡VP3&dۢ4h^"tY~^;}ǀͯDpGDHTQH3{FF~
/XPa &Fި@u[]!gF{tF;Ơ
mA]!BMN B`&t0;v}v њ!gGF;F&+F-	gF0`~F&Ev;v~~{ D;FFһn} t~V~tOC eG\gu
t/*䀓F@9F}ۍ\rB ;F~M~~.+FBSǥ%&L
1'DFF'^'b() ޠϠQ	P@PF.E0Ŋ+p
,һB|Fx@F!p`F&"va+vF?v`֐0Y@B5r~˫'   ts3
++FFH/fh Q,2/ t:D;!ⓟݖ<@;19~{"aFQꠣ`6+Fg,P45E]@`E&OpV+σQ.xA
=B+Pj094;tOj[axAB1BFB55?Ʈ4j]hK?B 0s3v4+Ͳ4@<m4R44S_#s34kS| fHb0~>HbJbj AWw 
Ht8-t-9t- 	t "fһ [	o
F~ t}fHbFk  ?F
Pj Z Dv
  
O!НSj RP %HPVz@
O&wPߓ t' [P/!d A~	VVrAуF
tF
)% )Z29kAabĔVq6{/ twq?Du0wǐ3C  g_؋AG2~r #uD*aIewH+^䀤9>u	 p_wPqG1JrRTzkzउqTwu(+Husunb~@ust0j	jfhz%z1xyPv#QJboP觱f~
 t
`
]ZzBXdg 
E{Uxt0P+yF4/ DVV _vv	`26 ܩD]sN":yqq	(yFyrܓyFJQˀ=iBũEyE
 GP+∏$y@8` ]䲜bty}0  a=Ktm5ك zв0 zD`roA?FFPIFǆ 9

;Ϡ
;NpNNQP谂ul ր=.p= K = ; ߄- 7---/W
Fj? 밂? >b/ P! y;v1! ;vFPVWo F~F G_;~~ - D- *-/#- /"Ӳe= Pk'-PT@ 75Ӳ.SGӲ@6-઀;SFӲ?AtUtPgPÀ@!a!~p9Fu
VVIVF9vcu@m N0 
NNbF ~9~;V 9vuԺ,< uN돹vmQo 3 PQ  @Ü VN;P@Auk x^F;~mԺ?aQXS@~Du6b ;| N;v};O;
6Va޾1~ uFAP!9vw|G"​@@9F| ~0A^&+^&} F̡Fbqoh\.bVt ;tt Dsb3nf4Whgo
@#+rop{#p7ݫ0ވȰWV`]  せc (a tǯV@@^jdfb)aWndFdN`ܿu },;/F~Qo,@rN@uOp߿6U5'5v6>$` u)>a t^>vc tf>^ tnm_PK車{hڍb%zP"`h
b#u޲jh0]hZð,
j(hahZ=PZ.PZh^h[P[sP[czP&[SZ!^p ayp aip .aY[!Ip^9zp^)=&p^=P"͢p^_uX`= Ht.- t'tF-4tcPHt- t4/Q#Hj`oqt汝't0]DdUD*뇤 u%a*H>0SWv`~PV t{&l $B`hob`fj jPV)p[WV_h@ mV3j h6	d1`D`HtHt#!h !x0]# $ $ qt^ý !X	
4"F(`HtHtHHt$q'#"E$)$)%)t&&At1q&&G<-jhz	G+Prz
!uG>Uj.@.X/ ^Y]!uGPUPqv&ƀ ~Rrj6 _fP/3n15YP>X2 FP3~|_5 t,RS3}Aqv @j	&8 ts09GPu  > >7Q89 6ussAtRf   ^f~ t  S3|֊Fñ!	K3	!	1C	ab^ 2C	fE7FaX^Ї3&~/tH&  v&8 u@%J*C;^|3FPĀ_sbѢY̋^? tvN~"vA(׃~ uPbDFG&9 uԉ~ib0Q~!QF=/5 X= 9-
 -"ж -ЛLQ ;uP< tIftsЩt[V-
tL=J-@C- 	tI- - P$
- tNIj*oTAPא~D@ǯF	AU0`0=t"Y ZuwNj 1c_pJ rcR u
qR N3w~*t^
a2ފ2&8u	F;|sa?BTt~f	胠fPP
S0`Ѕ7@n
CQR
_$p * 8fu_b؋PPQetP32[&GF |FSFP{
t-o f3}fp
 fЅh 7p|k uj hrpR[p
w ѐ3@l`MR[QiF&tu*`Ht`M&= t	_@ &_} Qe  D
4 pt^u	 hzh8
h Hu__tAqP	 &
h O
0p :y11P	 
@
@ Dt5PU	@Ղ1&	ovf~&_u bh bQ"  1y2[F.F8O
#@yRtUPrt.LǿF2[^R =r `
&c,!3F
4 
C$dԂh_jΐj #
P"
Pf?sVB}bWvv2[pw R[rP_ t&&
1 &
Ŋ#@
6_b
ר$婥רЕa_ښJ
 Qy`jg oMLB/OoTPڥP30[%  P0_R^r
/`
$*d EdЕ NTPxd5r1[pVd ǣq4dqq
H*=	p\ZF[w- 9t7-
1]= Mt%
- Ktq^n-Mt ^PѰIX0= N.LXxd,20"&0[qՄa d aaՐ,20u/q hԜh l (Qq҄3y q=lڟ.za 덐Qot
ga)0[?_woo0HVfh0h wY@t& 
@ AꚓsA꒓sAꊓ*sAꂓP$*!sAz9!z
@_0[x
_{ 
r܇,?'`#`Z-+tt#'Kt
- tp^uaڠ 1[տ-v
sok&Ttn!P	Ð3pPf0 	XS
q/zcHǲ +Bͯ ZG"Y ~ 1]ϗ 'Ѳ  0(Ht REޚQ@ϐe҄4.h
h/ RnaDuq 5
 
;t&1[!
茓kvÕ=v
/ǊŹ sf/ǱL.
OT
fh =
t

4
qƿvJ- h  !
e! x3Ą Qt!#y   !Uu%#X T@ !u% #Q7 ` !u%@#U !hu%#!Gr%ƿ.!)r%!.	!	q%[t&H?H1(qP. !`
 u2P@0_ty^]|hTV6/@r
6(<JX?Ԥ:1A!Ʋ!aAز#aA%!BAۓ &[ 	pA'aA`)aAA@ ՆaAAEu{Ett[m[ 2 10LJQ3KJ&[C14!1130N"5a6
np%P}pf[f4_2Wfhr  q1qof4_f[&5_ˀ"4Х4
u@U  WWUXWUX ZW6@8W8UX@ W SX% = $ \u
@HUXum5Wu,tXu#Y[u4[u]u(d `|Nrh!rvl1mVh?9@n/WVPg
oЧ[pHtHtHt$Ht-L+l!!l#l%
l(=vj2i2Mt_IpqEt='r@-pjA\c'r pUut3P/*pUu<uׇx@*pUutx01pf`$f+fFܐ~F F\^F<FFUD>==  ƿ - -tR!7   -Q͵ -*t:-ֽ ߐ}=P+- 팓 0-ja0t}ax4kHtl/Ht:HlAl6 O2mc(mْn PRo1`3 !1"oĐi!7Ft)%$=Vv`[Th\}\Q ȶF*HF=~< f fF\vfvvFPvpF`u63Fq΃~%v\\ :uFG;F phq ̃~ t
&X&8X8Ф~^ &0@UHP0Ѥ@ѤH! t&P`hɯÃPѤ`Ѥh@Lk"Ht)3ãl4m#n(WVS&( Ц!= &r 3v@Q~,a[кTP444\C<9Fht\qSr
[,a13h! B,-9t- 	t ºiN
 𕻀(Фfjj 0qa gu.yuPquh |pƐ>\ tu 1fhw  `Dg-{wXĀ>[ t𕠾h=hFrp h◵D
3\j\& [fQF |ן%q >[ uu><`t(qqi6[ٸ Uý {g;sį1
te3l\y3B> u	>[@ sjb#t (ȧ` g"t'z#Կ^6Bs
ԾPң $˷3$a̴!tLfh=ـCi1h ؼ[Eù뜟pjf\_\nl\,aP`Ѡ l_ *_Ͽ4jA
abEam萂52t`cn)[2L aln#%-2"cRPcr(P񞄓,_x8 Dt,-
t%-.t,-	 tE-
tYta- t/`C D@ߘ[:~T t=}@t  o"q"SV-at`wu&Pa]\-at
u
s&P4q,aS
s@S
s S
 @U@ut@8;>_}``{ƀr_h(r	Tv@tX6PeFkHtHtkp'PnQo{0iPu^gFV^tF &'u1  " @1$> uh hZh!hR--jh>/
t	U !@tЁ13҉6 5@8@;}F>
r݋Fn(h\2/,B聻-Rr7<~6pwf
~b߫f2b~v3ɉNv~FV
tut9v~O@|܉~*fn\ ^3
GF&_F	A?=Q>u^*ۍFF% Fn?vBĉFVy	NJoG;33V~"DЙH9tG;|	FCċFFBF P@ы3$uGC"D4!Mt%D6%OE?2:@~;fz\fffo>Fp ѠyDTET]Ur`VVz\ t&n
!n
DTT tGP U w`VrV5
8[}[Cp /`VHVL^3~
A~
tF^&F!au	aMz\N0Y$FpE[|^EPBVРyn=G2&rS2 ;4;Т=0=х	-tX-  ?- 9`V = M_ -ఇat!Q'|-ma c0= Y.6j㲷rtatz\vz\+1Y1|\PT- 2&{\% 㐁uu  !w 3uŐj jhP
6麦z[%q q0r *4?~_PTaw uj{Y3~
i c'GPhcL؎:CBT]ihn\c]fz\]$@恥f
&v
f
 n1vK
@;߂Cs}@քmT
篵傑d{ tWӂlA}\
|@fhЯЯЯ
hw蔀2$rx
>au`
6Я  O hE輋6F<tFd
hBVPS@9WF č˭FC|ߊF0; LMPAGABVnCF@E$:Fv
@EȐV%u(0L"MA$
F&N
E{!~\1U@UqPY~\ϋ\=5U^K,խ[(X!!f`TET\P̼UT [{¬ȴTQ¬dī1U[+¬}ȴ	"[¬Sȴ'V[שU¬)_b1Uk[	¬ʨqU
¬ӦqĠqUcR¬rİ5UCE¬Ȱ5U"U
¬t1U,5UਊU¬2qĘ$anW,j$kLk߱,Bl-
Pwm
- Kt Q'Ko0l0p`^@}q|qƽ
&6^n~Ծ꾀,2Av~v\ןA A A zA0 A۽@ `- 2&w뫝B'_ ( B^dBw@TĀD呭-  3O+-`u @jsh2pVppr| wl@q*EJR\n{1?P$$b&_I/f&_f~l_vY@@@,Wt, YHHl_t&X!XAppm#SA*AxxS2 USASt& 
0@&_z!@t&fhkal7萸ѓ~! t!@אc>^NfhhB
V ^a0f)tfhЕ#$h"F1p n շѓ6aF*()h'N
vU-a,|jh[(P{# `t
1_ &`t 1&WRsܐc&Ҕ@9@ut˶f;>P4##hrhnh,QǄ 4I9\Z& *䣄\Pe1# u$1  1 j hmhfP)3  t~@ 6&` >.B7  !# 4j 6\z`(u.&& .jr.`.&6n/>r.f|,)@ *'F .%%@@3%ׅ9 g Dt,-
t%-.t,-	 tE-
tY- Hto- t/pC D| (:w>~Pst:}:  ;!Vp%P{aVfP.vfhI?
 NPYu >h Ρf؋F&?:tF&<:uFF
*0N&$PCC
u2!))2*&a@"F ~ uF	 F
  
G
G< w ?v?誂PYj-^P&QARPP{?!Vz 3;F
~G@~ tghPLva(~ tDe;=޿=u5? 21JGG ^3 FPP g 3PYF9Fr?o QMFe-
 ؋&v v sGd ƨu= wA}Ő
".:F_RƋ~ PRl -K!Kqz [~ tR`)F@Ha]^  RR [ {F_ :_ ._ "_ _ 
_AIL
~dzPWt? րSޒJsF3^J;8@ЉVA B.tCaku^kGCqkuK  KP.LQeI Nr@l~u*8 Wq q I 8p-{jFVanF^ B=?uF CNt' DDݗLÐWV(a$ < upX@y@<@u`,6"X"??#V$hrb hBhb蚽%t10:6P156%1 j0:E~i~u554U6-76a7U7_F:i!8!89!4d9\FE/: 9F9 ;":D\<D~&hXhF p)cp)67 F /tHt
:4u)*4v jǔ@оt@uf4߮._;F~1сB:rջN@uOPhh4e`WV3Ԁ0W2~
G~Br@?+P&    : MHzKB  (  +0SIMPLO  MOTOROLA  HP  1.27!drivelockћC Computer Setup  <F1=Help> Fileystem Information  Display siiSave to floppyĥconfigur' diskette Restore fromUE;ȩ6defaults.|:  Ignªhanges and exit E  s withou@aving%ԦMoV SecuritAdministor password РSe a?RPoweOr-OnpһDeviceHdD0(DL so@martCardBIOS supports Embedded` 4e1et"acps Tools Ba  CalcibDҀthlect b3 HDD`lf-TP ops Activ kO|TStatu14 sRAd_vancepLPguagb l܇Dem֑ѣJ of gray 1field Boo'֘bZ᤾5Presy key!0`ue F10=C, ESC=C1l 砹Acc{ep=YesNo A, Ajor=M r!  Us| arrowo highl`he approprimeOnu ipR<ENTER> >0begin&C.gfollowe5Rֽ: -> иSPACE = Nexra-BACK@viop FTABU4SHIFT+ c CPCֳP' E~r This6/cann`buӿd An e kocpr whf	. de _0x01 e nP4aent   C
requipd%Ҡd basmu@	mov`0 	ek/MEUO0`	Q􄠣 l?
_{2hEclesuPssfulManu r  N4Pd!Psroqиtyp"spe`#teppCac!ize (L1/L2) PѰ% R/OM RsңA'famiboƑ'!se l nu Vid{eo) KeyS)rQr@ver'D)*.d1$*%21R33R4*HF*!p7/9:lef 	/< .r2>8rQa0F*own.hipC(Ud P&g17C2G3HP6 7Cl7?C9LO;oN= L@_R,0L$!0daWBSN;Z$1?ZZ2d?\Z3?^ZME?`ZC?bZV[d]d_d4?jZTV?lZ?nZDml?r`YZS?vvFtWarn: 0qll	o  `Q sԶT0rea /F,|lein*twabL <0 A: z'prB` wa
tt )6% d{`r0InvzAP<!aAgyou0ԑwato  PrR~::?  i߰pɵ  ppe  1 (QuickP&2 (rehensU3 (S.M.A.R.T.) Esti exçim%`): 30"0~֠jgR.0%sBed`ppy hoPsFpup%:3'tԟ2f-ѡ&UnknpDila5W=Ser9v[Rea0Dsdo	Dɗ@@0ribP:0 PA
sexp(z Wb..  Ol ewV*fy nbEncOf'f OP uz PP Wro. 
ܷ+fAd1rߠ 1!rCUO{ als2aAJSmartC-fǵ:   ifQly aP PCa &%{Paloss  8Yhou0 nxΡof ago0q#qev ~9Doishb{ed? power-PL Blank  0# RS)!mΠt AS/ɓ.Q{v+	s cDAQPOn es. FϠpTp ndp- #(unuBQ.nt0pPX6Ћfra!Para-ѯs Slot M`iPf Fn+F2 W lnet
u tCD-!( `⊀-P
(p34! WU*> abou5h uR¯<?Q bot``~USER2MASTQ~F	
pan}&p'cbC	|Ak_eep ia0>ocphys9i0sep0aQb%  Pr. I``~p҈Ó',B~L	n be "un PCO1QqKe& bEڰmea+,{@Ͱ@ڐpib tyo. Ifdo2Ԓ,QΐQ~ESC.  ۳ typÓ'&'2Q~F10R% (Y)rmL Ϙ.EEngl@4!b2.2 Or :wMC3aywMS55 (Q>F7"8@) USBy:c;!&:Su<ZDcFirPcX hiFpthif`@Six@h )EaTp@Nh0ANum R T! Swap/Ctrls K8C2U.SbSd }{:legacpð(Gf0pl08}ro`r0InJp pPYfX Vo   NTSC` AmLrO-JO-Maıt@FBid0al EPP ECPN@size 32 MB 64U  oбn Alway ~n whiLPAC42Q=FIAg1 ag0خ4Y88)^8 to)mP5Er`Ucce2_ed3.`TokpRaLe 8if8iLhOm ^p`Unique Id}if  BPet - @Rtu0Ovoww? StpuCBb/ytNФAsz {|PPD!8~z| }BGbφz}o`B q܎ʂߐft/OhXH@ߎz}/oL8 MEUozO}/Ra:/zo/}[u01/ : C gXu% ]1oCpl	ed2= 5Ed3 3D8FD|* } ! Oo
Ϫyq Hs  CpKl  Spۂ hnology' Au`bc];L3IFreQLadapq3QPXE RPL Ex*3Pop_up DeJ(@Nb0 10  234567A+AF125 153bGB0+ouchpa0PGS Non<F1=Hilfe>4^@{it~inp8p*azeiZuf< /peicqc  KQguĿaVfwCie pc@V`n<qvEReinunp/6R-~kZ~CignOoriedtnt pneh0\ި8_uSetSheitsfunktAd0isstennp.t_q Anlt-KE
 Gertep4Om~-IDv m&MtC<r  <Lsttz@ fr GBIOS O .|LgxoDvorr@
/Oazurck zExvAkkuk(}KtPHsgewhltl DD-Selbssp`tې'tiv` CvZPSuPHs'rw<pSSpra 1n3݂gran Felds1Rrt-O $o'pi01ine /lieba#T-, 80C` fah`=A", ESC/=Abb Sh݁-qWr ].-kzeX_.-Ja1N@F)2, Jm+=Meh2 VeP q*z0CMark ss/qoMen d*?Pfeilt!,1dx*;@gab	e2<b,m
K&000.7fcol`056n 8Eߣ!+@:Pt-{> r LeA< = NchGAE<-FRqchritt-6GVoa#oHtTabulJGs2$ HoHll2J+MCKge:4Otta= RruEscJlir kanUt we@seiA+0$P"rgetrn.D^c 0nAYP0fipt " k^F;]1+W selomvnorgAer``lޒ!De+sk-H sbmu@c;as1bzw.=MGobi@h]gtz[.Ap@ti rR
\]^_2i*rqflgr abnchlos pZe-!llz7typrb1xMwaigpb
SSJRea|C1!-@-Gre ?(L1/L2P%kapazit^@OM-Rs^Fami5 SpM0+%K@umm`e Grafik 8s|BC r-Cone y9h6i"ڀ,h*RZ1_ 2 3ߐ 4- /qzCZύlinkoQ: Qcapqsi"S(F @qz4 ߧ!\9o OJZ/ߝgatk r$Z᠇:hZ${ 0st0>0?n bissK!n`i``,EDi-/WY&lea8bJ+r AJeix@sL  \k AM:nfswl&dgeK"+p+rŐglp0%
$å LO
Ѓ  ѭqMya*wirkf ='߄r?oCSa*, da?8xie q! ݯߡ=?u  T  1 (}nb2 (UmfaydG|-fhidau`(Min.): 30Edt 
.S0%#~aqb̸wDwu@`pm #Ho snp5ubrO"/s: HZH\UnbeZQss^rvo-Ln >QZ
sshafOAttoribuIDTHA`ts |mu/`p .M.A.R.T.&q". .# APs

 GNeus Deat #w@= Ja3EЀu
ʄ1t FalqY	rngeb!	i	
2f:R"`@1`k{d'min0?oRf Dur@bG9p`  a=@'Ho!#Ёi	'#f.# 1fYf1cpkSm%C	<o@G, sof8pp f wa1.0s Zuq*:sf
`!ر8"enelust. b s %akn0j@lzdsvice-a s p~,I0881s
eny h00>(`@KgaB!+ + ؐftfa  	-@Kc"7 kD QuickLock61.Sundzv FrreM gsn8aq,$Y@Z1f#$biPtt d21chutzf!
r!1r `"pk?P	.d0s&	 !62, l`vb!rZmehr!20RoW |  FQa}y  Inf~ot]-QPar.eP|DrahtxNQʲ<e "OVk"TCOm@nCD-尧YTL~st1]p2_p3`p@PsFrD5Wr":!nDCdam؂[riveR;a qtd20 :Ps Ee-s0,ds m~pXXhunbrbar. CIPM$dG,bew61s QaҀ ST,t@n20qL%zA)I Ek1j, E,dvM, a p/nzu"q=nGMez0,fg-0 e-craP0w$de0tiantA	w gg$Wf(a$ Esc-WHZfLfg Ȉv-WQ
'fg'Ӏ|1# F104٤Z:dfgSg؁dD7'ѳcD@cqr@uiPPSMuBay7}Fϸ6 (s/ (BUSBʲCZ-XhSu~òZipǤ U1234U56789Num-F{unpons-)t >qn/S'trg!2tB<EngliLcSA@Mfm-Ze ger!B0uiebssrunabhng Grafik-Contrq0I a Prim2a?Video-p3wS)QnD<BidireRal Gr@pX3s{ gB  L!.msNtzb3 Vv2 `g ssg Eg parPR",ƞ(o2)ſ`Ǒ 0_ȨEt{0OoP`tXa?xToqR`> ͯ_ԟҊ V/Տ`?ޡa1IMtia`q!߶ku8jë  /OZa Kalib:0O
M!k֕NB &h)Qqp1Dualo a	_+OO kO_	 + O
O ƞ h _~
, ~Trariff-6O+$cLp obiѺ	& '!O*o+RQ./0g	O2o3/-!56\[QDr`T 1 : La!F.?P% ]=ab"}@X Kzx@2p>Entl> =IC>@DAx@3QC@Ps>	DI>oFKMH*P@A Pn "./;E9/W6Prozior-`utom`AVv Legacy-fЙAlPҒadaplBoo3tmjzQExp-b-Popup (.) Wdau 】rF12 (Z; \q|CompPropstn0 <F1=Hjlp>  FZoplysj Vis hlne GN vtil0# n^konfrb
oG{sfra q]prr@r0|rXsUvtmZpgn{or ndrl{ oQfsluXzFj urOtpynztoF~nez{kPVhed Admini{stporad7skoi Kdp a߂A fo{"bh㘇EE`dEJe-iPf`&J}SmCv-Y@p=@0ls f  BIOSIr`rjJidЪlso6ofa@ks0џ%ll %!B8Ad`valgbrHDD-selivOtr  ˦® c3mr Avanc Sprog Vlazsmonnedt@t/ felOӇ̠ ćˠno싞Tryk p?!qCas`|t`juf=A, ESC=AnnulkF!Godd_=JaNej º, Aq==Mӿ"k Brug pZ@bo| PVe?  releP_menupѡ,zt3<ENTERpkeKpae3t.hf`p= Upa qؠ: -> eA MELLEMRUM = Nma@<-TILBAGEr|Ϫ$TAB΂KIFT+ӕћ#f?= AcceaX}$!X}ţsOfejlf k v18@sod`pjlfsen. F201!no`plakrv Ovek pn'i d0pps8 fly@sp@on<]/MEUr b` uvez`tЀbrud/K2۔v|smfP"|8r\[duc[c[typ0hиig0ztr@Ccache (L1/L2<g*huko`\0 ROM-fam/iliekk!fР၆]@mic\%V iocsAqr-contruoBDS-ba`B	s dPfA 2?34j
 H`=let ]b\/pq/hjz
aPRt-taF]eja%%(at)73 07/7)!  ?\/#'8l%`efP9Ƭdwvar : DQ= sPj  altn/`hRholdaEopP|!o@d@ }/PSb-GoRdQTd¹4Eo, r Qm=kqbesk@ rA: $^^T9sf"AEo(9^7XUgyldig4u!t3  =\nGgivFvu$x`|5vil hsFv\p?y iyH}?}G*}mL ˦TP(Hurr)QPgOmf1:)PEsl" (@): 30r q .~V0% fr AQudRURvPrɑepiXTY: KWpH2BR\UaC\S28܄_erv"4\Ls8`0ribut: ID/sCbS.M.A.R.T.b@E
`y.h 1Nyi Be@fwt njDeaޕ Frail  .A~<@0jCs. Ïkl&/p  !zm/psw dmQgs?skrp

~ڕ,|L hv(. %~t/p(EڠG meC]tab2ata. Du bPupԆ!>@fl!p3r viGcehJ!D3 G5 J>굻,  ?QuickLPwpau0LsvJLmv@TS{qb1;tA ,ؗL w. HBu
Amw40ɠ,dip2pges. KQAsl pBfrardê:dl@[k@nappC?d-rom-  _v45H4S 1`2314ak8!Ho v%:eYx9uq?(`G8ah, DЎr D`~ bBRUGER-a HOVEDADGANGSKODEN,pQ8v alNQg nʲ_ `d,aopbeQfp ;s 5þۿ|5Aat l0d Lhduu PuQGN 6ebaJ!nt. ޡ%~,B1tryp?@pڀX@3%~ CF28 or< M'' QPee=rgF10.ĸ |и4q0
D s84~t0VD k O#srflg𐷆MultiBay (4)) USB-floppy4csupe@WzipF`g@e]nЬedjpBFҡvF j#5Sy4vOR NvTtNum -"Yiu  Fn/Ctrl3ԱgENl@(a:
isk)b>egeen U>!uPnPmeBg^? Prim-AVideo Out Parae Tj0Strpp?v1huko@aBqlb@yd tJ 9nr compugPk @3ek.`mWu;2-+ Udaq	styJ%)hGtopo
b-
EthOPQ0o`)To^ R/<((;t,Ent0gt id-nuB7)HfV!i"S10$/%O&*',o",*Kalib@o(-*Qnd`W,_1 20 0-X+4_96@k/O8=23rb< _B
+@E/Ck/DIp>3!ion_I F7?M_NF;PQK3H^ags UZ++oY^[k/]_bOW3V#vdi mobu` >(MEU):+e fgk/Oiojk/dY AmoPh,\qs>t@l`uv6topC4[pin 1 : O7plaA .c@#% ]pN~Щnemt52~Af~~Uك3~Geno~~ۇ0S< * YxP᷆ oD/8\mzwky֔Processor# AutomU	ːbp  Legacy-fr#ee1m"ӡV %ǜHurtiaUrtpop{up@sink2(sek.AHŰ25<-A`bgge PPpP Щ Konfigu+ datamas0U  <F1=Hjelp>il40in`jonW om sR0 iLag0aktP)HePfraVJOp@di/A3JkPPravsluAø6B/,l Ҭ淴;sprograИ< t Ad0ratorpaqd0ia0Op4vALUyrs+isf'unkҮuթptifPg	ȵ8U-utx2g&n SmC Ϡa2F BIOS0OIby `'oi+Tilbakeџlfab@0U00ޣprkty F+ AvalgaiAlUPP	;vt  Ak൪`qUusOqvpeSprkplg <@0 Dem 0*져pdt0el2Y̖ƚǟUmTryKkk ?a10=a, ESC=Avbry+boA@	pJaNgei Ҹ, <er=Mj"  kynewpilne t<ENTER> hvdu v ǹjt. BrukQP$|G:  -> e@r MELLOMROM = N "e 0<-
TILBAK9E rig~
cTAB"HIFT+
#= GopaXp
gsfeA]F unqkgpnop?̀~Í r m?kjresve!䰒m vНB0pba  flyasc
S@]![a"$v0fucll/Q. )kode 02`) % du t NoUblookk-m+ll0ktyp@/higr/-}gaPvktbuff`(L1/L2Meng+pԩ-P.e\deoF6T:r@tro!
U6uS7,kob(!;,o:a91@?>i 2?a3Aa4BhRakՏ:n.֏B;`:m_I:DyK	<di+F E@0кP(2 }HP>T@OVaB WCHPDOP)GYO *P?K?_xZONObP;3Ek[Ad(0: DS/ sl~!r tidl
.hol?dHgA ¬/hްe-  d, druQd s &!kl(kpccnn0A:ՙ䙗r bP޲rCegıoiUrUgyldigneSw@r(	yPnkr3~Ehttl"nj݆}L?O@o?  igno?te?  H~T  1 (uRp)0sl(r1 (): 30GS pgor .v0%)&)stvp'v): KaPrut`)`cUkjcSqe@:o8Les4Bs jr˕rrib: ID 01wrsѾ S.M.A.R.T.-!8 4.ӡ  G0uN"֢kreft nzAv-ЂAP&u !`)52i vPlikt ODu `ÀIao߬ dss?!a,/ wAsQ65c C ݁,ޣlq4рpinP0#ְ!.  bp(ku,p  mu5
vice.5l6?U-B}^8c3lsd3lanArpa|@.P/us L"T9m~Tm gir {beqbesk"!3 -↏@e. l  "r
gle8d` B (R5#0KreÂmp@Pvfrard-Parallt!8Trdl`t~k KnapptSQ   CD-
Ay򗜒y Ho:e	 h(v?algt ?QPҊhVڼ
  b+BRUKERHOOVED->l!umuj݀1$֠+Q`d0[be(~p?1P `@ioro   4\-=afdƱ,`*zikPPm"? e  (~].6rsP3aGfl!(@pޅlBm,@p-(c
 Q 'D>Lock'r
 F10E)"be}IԨp&%Nor c3F#OreP	 MultiBay!\3#*/n(`)d4p6!c?"`USByr%e%% Zipp2CA A8Ad6um )t^BqpFn//CtrlDe6AEl(USA)rekeen0!1el%J4/sЖr59ePv1S8@`#RpTPisArr1 -1 `i  kќc$u82 +6 Agss2;'styQg#1&;@8A$ (vP$bCD !E EthʀBG@ fGA?JG3KoњRINKNMq*sA2OT`Q?WMs%nitifi0tbdBDd_`+ /aObnc@y mth_ libvd]hBfpog\kyIQjp?pl.al -j^f mhipkleEtoovqiytuEksp.D/}^fziς}~HndU_߃iV! mob. :fO|i 1$9K?Km[ Tn V: La.``% ]y full024I&3 igjenvn߫* F%  !ݎKPros@><u 1`p&< U->f<0@nde2i3U)F0inkr7a (se0ݠ /F12-`đ.pG"/S ?ep_ute P/pR8Configuroaci l@omadora <F1=Ayuda>`rchivoorm%l Sma5Ar4@sGu &co fle'xibecː, Ra so
֋o׋غo prfinido6#̘ܐ@8ad` Ign``ambios y s``@q̋  gs |/@g=eidadː7sead@8ErA bA<@icioxFq &posipR{sI\c& Ѩu\8 6shm KSmC@goQ675L BIOS incorP6b_ p?c0̼Ԑfbr Herrami\a6Cb)`er h	PPܐAutoprueba HDD@cp@/GEڒ̠^| °ϱfAvanz@dioSfDemprampB;co` gr6i/oixQ?!|#`OprimP squi0tecL& inp1=, ESC=Cancel)b)*=Acep,=;S?".No *b, C'or(=M*  U`7r(ch(haal  lem\o apropiSl 6?yP'<INTRO0$ 6zp@"n.V3s3%  !:Esp o o -> = Prx'kRetroces?<)- @aai؏TAB @S5<~``Mays+D)CC 0 @-؏*"G3+Errp]rYo  @pM@S  =rPjo u@ՓL ̑E. CdqQ01Mhoay n[unaaOub!AipOCA Qbar3	Urp3aCco 
F@5iPebook/MEUW wQmat ̢V_PQRS2M9ple0xito{sa6e FaB
aiPРutil Ti7AcUVjcDl:lGuGHlTamaumr\ h?(L1/L2)?pPqvisARO;M imil\ѐQtsRr7NмDri[	ku'l v pVYerPlA͒r(wZ[F4~[}I1߁2߃3߅4߇panij xo/Fiz(?rk[EtiquphqЙur!sjI7eTx4HHl(#)aOfG?_e}3 _WO ߮ z _[Ǚκ? esnҁshҠ@F%A]dpYten\:0?Aduir?el qe1ݦGsn. P2 re@d/, in@xEpbQSscribaZu0`A:wLڛĄUU ]	 05p(eMp3aA?tZGTР?7tegAs8TʜAҐvl@݉u'sanp7I|0ͧvaPNre` ?>	o(a) ea5 0>a?gn@K.  iTl`L y 5LgoP31 (Rp@)2 (C4h3 (S.M.A.R.T.) Clcujtieej(`0s):G 30`7g57o .VH0%hb h! h0¼aipaliGrumaL: pu Iqa6 Fal 2m8̈́Se/rvof Papoyat4atrib0: ID @SLax0
As .
$seaG %PnuevPzifiK^D52dApagZE0+ndSqtL?*e(vocQM YBav:oL)Dad`0°n`Ae$V(5eO#;aiqinhabtpO#, mtLn r? (Rm1i .#$o1kaT=40J@ϿSmartC ,7 as0moo%, Ult q@V@TC!sצG`Qm{eci[``ofiq 71%pr0撋in`#d Sdjflo;ca olpzېTkqbv1@xvi?.eoa?4Z5  @䓡? 
O0 onNL[ as e?! !;  QuickLockQSusp{eny Blo8|ratg@
bC0S~% )!+,P ?3|gmejphW`')(C
y".  S89prt)),Apodr?ukiz.y?1
re%G PuŠ!$`xVp5 rojoVlmTAR{ed alm3CBoFÔ[IrCCD-RtG^E UQ|d_d`a bvЦOdv0evRPL*PU:
6_Usio0Qu$1p:c mediȱSDrive1D2P@PlM&$1USUARIOqo PRINCIPAL@.r?0 n`   Π)p.p@x`. An ׫! >ty gu@Q lug  Pj.%Bmqp . E :l7  yOB4s,zzS x!  b uE)v pF+zs
fi5S&pMcVde2Ji <apons2!. PTo, a- E ESC. ɇ@5p3@^alab .'&ps' NF10p a@(s:Ffpa L_GV.pEspaol O@Q\cC0Mu@-B	aOPEOg`hܰ(01()?_ (4)USB ^c/ /FSu yPkdZip0jme0oG TercCAC!Gx0SpP-o 5O vNoP:D0Pc~l ~cEo Num3G CEs 'Fn/0TF`Ingls ?(EE.UU0Pposipa!F"2m1-0ST(ѩe亍mCakcP5p8eo CMo@FP Xq;K?  BidiA?ΰTammem/ S0Q:ids!Tfu00!cuֱ"nqDCA.Poy8}N book 2eexgpospBOo, (s/)pp5Eth0et,f%d oۊܐe݊gTokRingOݯo%A]12?3 ItExcl#usaAȧa p_C!OeCЕ`MNqq!cC OnoB@.y hu@
oO sb ?__	?_PKo?/3 Uxo
OO/MEU  _"o% !UO?$,&(/_*[ 71[ :-rgB.`6% ]O5 ĀOQD725> <65М9U67;Clete5735:$5 ;?R6L<@8*@D-bL8 AD.(1ha Nh0q  A/utom cZblBϱ pǽL`cy Le? ArrantEpR@]šD1gayQEx (13U8_ ЈF12eW_u!`Ambos TouchP0S PlNuB0}a >C  <F1=Aj/uda>Mr oInfo@so@Q opdPAi`am  >d]?p)eRqrtbq~_gGf1^h>gpadrPcifAmC^EIgn`hl 3ce sairhԙ
]sesdpdptdq-r]naвn,pCaҲM] ` yMy`졐xDr{}xiY z_`Bco PDd{j~\<e SPt5dqҿ{bBIOSaYWembutimqpgfbPFeQMm0asge i 3@kD le`OpTpNHDD A}r ͝ S/tatu`apAv1yASi	o!UnӒxIcampcinz73lizxo_x7ـϨ|Pesse q0 $ tin X='SC=CancelAce0ݱimNxq, Q5ou|3=gMai[_ U ͫiz`s5dse dqC o i aprop`TuPwWî<ENTER> meRhjEpgo.?{gub: r u:07 ->PAO =0Mxix<-BACK CEpĪ]apqvTABvotSHIFT+CC3zȁX=0BsJSCrsErLgVna oo"0f6cyr41Й. CdigTo 0Nh?Ҡo01 P ?Mn0s0Ƞvi
CAMҌҙsev|nsf 8o not?ebook/!)heQEWmDӘe2Gh@22rm xiSelTNt  TiP `|Vc@q op`BB TahR^cache ?(L1/L2pYFa m ROMBvisxFamlE A!r@c|Lsrifo vwdeVeraroZa^2a:Na 1 󡰛0I3 4ol '_G	

eae)
O
irAEtiqee)pBcefO a(e0^)Go 0P/"0$ E&'K)* Oo-O0-/4?7dNteAdvertn: fqOp? кae!|
ibc1eNd/ڦl,Бsi Xum l gravv RunA:T)iUEssDA:; n@^foiL0 Rq	AsDp:1ܘEOH?`teg@aDĤUDBБvlAgkG<ICHB kETetez9pDAeja ZTULr#o`?OpVW i_pcw?Nv ~sf^ߟc~a1 (Rp@a2 (Ang16d3 (S.M.A.R.T.x2dxecua(p|.): 30aa!n5d.60%gaIbAsuced2QaPehosstaromcܘoR: Iss!E4lหirFalr}nhIuؗN
uermecx@`!܄UHs2!a<trifqu`rDppābрexahA 4~s Wfn.cӇigq	oYvbifPrPD焀aҞblp*PLC  Q<@0RHs_Iei@K3rr8IigPË'cis񄰣g0 ?  =eAdh0@8pmodqsd׆2$a&t>atamb?C>P?E|emPRCa#rdp,Arp0A6XCsXfbrЅus Xp2form`. PQJ KS !ߡB= yios. IMvٱoXf? O"C1&శRњQuickLockP Suspenso BlopDs2pFPyoup:US 4:ir Mخ@`=h  .=#2asss impmu$PExigծ6pP|y0Der#meu1l`FGFReQp;B+otrYI
!GCD-FGNXkkGbrM1?̒T2T3T4 Pm>e:ԃ`Wusu: Voc?QM R oX5M`umwEdѹ.	utiQnROriveq  t??tUSUϵRIO  MESTRE~r?!WĪM `1#apazD `. AnݰDPde-K@J`aHiAsu2Bprl\U. NP2vPG4' ,poЛA#Csb+ !f@.1  Lembre-seauvjaS@X sabHpQ,ssione2 ESC. CAR18y@Rlav
@{''QgF10`qe XY0r:M ʎҟʎkugus O  *: Mu?ltibay+/DS
BA?:(u20d6)7OUSB"ObRcͲhGzipPrime[irlrcQPRb;`hp;Ovp;N  Ocph`4Q @@JsapS=qAs Fn/CtrlIngls (E.UfVisi К֡PSdAh_`S"RKoxa@XRdeoqe&p'Rc7und)aS)#Mo@=PY ei6cpTa=h1memr6%'C'Oo(QMЎ fuP= ` quRQM YIo ?CCA;d2AGer0K?gx@ygnerg1*65i:d`|`"@_<E>Et0%net+6A9o? ֐wA6CD3EDToken RingoCHEKGDBIO?LONDId1Ԑ y0OTD Bap/XkStatusVXSS\YC@ eavZ\YqP`\gem][SjdXFXlCrr`h7Dupo\tedce_` ?ge?csa
/\N]m _`pbaa`c?Aevwq`ywu|Al^?o q{tl"BqU߀_?`ϋOGXDpόc[ Et 1:rregR.# Z% 1]pjle2: .f3: ReŚ
"g*V a o!?jeߗ>c Nme 1 2flexvec`(+ѐHE%+=dap#Y(+kRr,Popup sEx=Seg>pF12("&ks Vsar1#a NpujTietok3pI Wtuk <F1=Ohje>dosJrj1elmtt Nyt?yj~Ȱ.llen0levykkee k onobPpt?VRVoeuns' Oh muuŐ jpopLbwƐ
!t.tW9ˏl?poau ɸaurvisuZYnvojan asa@M?ri? _Kynnay0tTk Laptcl tuusnuat_-Ot_ lykp,iti-BIOSuki>-؇0$etsuAostu"ietehd TykaluAk 0@fo`(i  K ia Ki`(vyt1Oϐt??ܢ11 N@xJALisKielip?ke harmaQ/rki 13VƂJatk,in@	jot0 nppՄ`(?=, ESC=Per =Hyvksy=Kyll?E?, Joku5=?aǠ%nuoliCmit Qk a h@@sissb1 <ENTER> mq se.t?n Byseuraav/? ->i VLINPPIN =B"s  <-#ASKELPAoLAUT$Ed inUPߜYARKA$	pZVAIHTO+g)g'*|(Z= Dٟ-$/UvirhAkkua e0oida.e3: 3@di 013 ka@0Q4 42aprtpI p kytke?vP	;ko6taa0 43;si`<p;9lak9sbQ Zݹs#kanpGt0%laaj@u}s!ikk?n5*skeytyi- @en8i5622nCo@mAj(qiQJbk tyyppLnh`cLaDllA߿Vlimuai (L1/L2pMP   ROM-P3RPotepe3E1m r;sipGsarrɔUNstohja2MUK?V_ZK{usPKnkohФ&<1:\[<2^3O`4aKahv{[)d}ZNfO\??h/goik!ejV tBbo]$pN0(joa)w^o_tsa ubodoezg o|}j|l_1[VoJkJrAdsos: Tm?ay?m atpnh. J"t Gluo@Bpus-  n,r irjrRAonP?A: Lr3ӑ@Q4	h0%pu9Q88 cR-IJ(Xd`4 PpaЭAhߍ#'Hko!:@i<QJn p,՟C! ،pO   e?xpQ1 (NNDsè2@QB3 .M.A.R.T=.pArviq$J] 8 (min): 30s?.(0%C]@rQoIs 
:ys1i
$D7VF¨?f43J!u 6K%ʸServomoottPJʸLucku3?Q4tua?kttribtiB)7`	Їp!a) Vhe`KKDn .Đ UuVd!K L0X P21
@ ra  @EB4ْJAH 0?rQ
#ai -*n +) o n@okkEYaadan ߂n,%mysp d@ۏfaK,s ; JTaij1RTЇԞ@3%Epi. un1^naAy0A! JvePapahtum050idasa̩/miqn QuickLock Xa h=fl!up	 %! ``Ќ5QB$,  ra E '-!	 DWta.psBdȒAnUt,?T4Ep;5Vquu, f&!SWp`UEInf_rapunRH 9EHH0Lacngs<4
to] <bin`m  C[D-S -qli s
A"y&S 1φ2*3*4MrP:˄yjӇAiot#\n Deq(q[T) -ӛll#  ek?KYTTJNP?S~&SANAN,Х@?a '  P`߀silyt?tuurlEsa 8ri  -AQǒ@- @t3U I-,4ph8`6LLA qqaQ< rے]ute]  o$0C䃊ӑ,Q%ESC-nXn`;ʌ7n, a''q8s Men F10w9<2aahf1:X pP
.  2C`0Lmiys:+VMultiBay+VI (jn/LDM>Rm) USBr
2P 
P2PIKAPZipQEnsimm9p>T0p> Koylelj̓VipK/eitj V ddekP YXVKym0VNumRDp? aiP Fn_/Ctrlt9m8 rGEng o(USAUsPW:@spinl_ł3BPS`dfd_n`ja0aG Si#8cnSsi1eUTseVpolht8 `0	kioy)s5eN1##P& {  A# 1ckpuu`BZ8U
 !w&s|I2-l!AcbV 3a@%@~pI1`
ii1spouriwM- (ylosz{|/x>rEther&tkՀww%zo%3NTo
  goN&workъ
wđzo/LNiliv? 4 k#kuƯT!	 @h_"`jo.libb 82CEd(g%`Dual0J-Ϡ/@G//KIb_ ϬO_oeO ?OK.NXo ÏeoƏoKWvPo0ƏΟ e׏̭͕&@#aa3 kM D4o ?_]O݀/OOoM[ [eЊ:B7a`!.0% ] G$
I%2 ,l pure10Oe%3O@g*	$FG 	r@>\ސdumerkIn{  SpeedStep ? otech`ogPJAuto8hTxP0gacy FreeG >#1"pkhnavuGiP%Zys$iq`t@@ (`0je 90_@V@a>:t?-F1S2:`<i!Pq%tappi-koskeEp: 0 }.mma]Kk?  Ei m F,Configurwati@
ord 9teur  <F1=A`V> Fichierfoar`!Pm{ff#age #ޡ$Sauvrder+r disquoe&la c ' R0r ?pa''une'p0G+N)+*[lePtal"s='fau]-!'2 duG$Ign=o%1modi %#&pquA>0"Sq'?e l'in A *a!$(6SregAO6m7/<O=88 ScuzoZ 5e4ssPd ?! 21?C%DB8]e sous
TBDEHonP-EBprip!hM( S3sTBV= 	Ms ID95Di'kPBsEDr YD?/SATRSmP/C@']phKE>W BIOSMNUxW6BgrDhshf8N^M]Rtabl88a1@/am0?Uw'uspj Ou i/s  P9o hP%8a b erieee sle-cQ!ndp#2o}s 5,050"APhpR1ohjEtaE	f$8bmN5ha^A cqan=gMhoiscarInd@8s ~ %mps grXdh8dWr@% ZkugumOvwMAppuyt',tounpo'p)uP#=Sper, ECHAP=AlT`IrAccepA0=Oui%NB CQ@, N'iEmXe7~=qrK"  UrzR1#~s f0hSheQO~m-r8Q/cle @5 ua)cer}'bri q7 P}z' <ENTREE>~ro38kP-8C1Usui Pl̆~D  ,k :A-> ou BARRE ESPACE = PceT@"-!ĘpIE9precedeATAB CtMAJ+YWؠ ?Ba  rr"P,6e Il <iqssib@֨2p'c-'f Us{s'iprod@Eend8. Cou'Ĭ01Rc}gnD? emplace t L'Q)@hire 7`KSqwgPsN$d'accueil d
 p5p,Og'exH[bi p8bq$ApF	? uѡϮ2em;a ruP Fa0c1M
TypJceJ!"VpJDbfTaPcan(L1/L2) VolPKmoi VerrROMPmBARevrP)P/pHe$NumroC_g9Fvidϑ~r18clavA#ӠPoA5vD !؁v;gpJgHpJg3o4/oamovq_;g:ؾeogaA~1	!Qinv*prib
N(Pte)ܿ ?? _t goOo	#o/5vB(ge$ep)dPqe8JQ : Cɂpje1Pxtcrua1qie@@UpUPa'P~`P^}gQ_& /8c0s,  9r/na4ro bcLS8!Ad^E0Lutv$ !"tro`: Pau'#c vT"^Oo0!"122a48+.ps - 
/):fFs@0RcPxyf lAmes-vHp9lp  @"8 ? I'gnow[i>ӤpQf= Enr#egF?e?B@شAЈ?l Ti1 (rap0)H2 (coet)^uP^xLs0im"(`)30FЎc~s ..Ɲ0% vA"Hr"H@vt?8l'h"H b I@PU:JRa'lR cQ6@nuUd',UBPvMW6-L+] }suppp(TAЌib=1XqV: ID ad?ltgr^s S.M.A.R.T. Aban .#c ADro@]s`(aЍ)d %V zfס6nd1-saj?jFAP/ MarA `dn[da1!AkelСVcP[g6m?me, vSfd
nad`QDPp&obligatr cme{dthĒ$|pt xsJ@#?`DiOxoyuf{h\N~S@tC.5|  | sipPE #t?horu8EaPam8na\la p SforпQ?. NUTzth0֑G9 avP3ouu?vokAMs(ra@ŉz9ѵ oAOwDeCd<Dw`}p ϑs:D QuickLock1Msus! (@́t1A7Кri miSL|}{ss`B,p[xrec"ӵBaϙ隰t. L'r񏠸ȄP cl dra:ҀQ KԞpExig|~u@dPQ"  ra (all½3&( RsAgsq6fil BoL PhEC#D-AX!E6#% c-Gpp0
npal$
nĔu:є@83iGcD9r{. ScxBadez deux,(UTILISATEUR1APRINCIPAL),  ӎgG aBaloarІIÇz N`zd1APY Tq6Ю1qqsrQ Efe 2dceluЏ'ordin{. AuR vǐfɀprd1D٧ `v͕MÆetv okqa<D1pf1^nP?: t a|Q\aO34p`?ab2 ƀ\up({&f, appuyP3Ⱓ `Y ECHAP. "Юp:1zn'~f', puiІcr1TF10pTapP3xR<rmD$"3@eAV MFranaaO0-d*Q1҇MultiBay@j| (JOo) U9n(USB&p

&Zip
oPremf DiRTs"Qu9a`^QCinpAQSixi Sew HA#Neuv#DpQMo<( num' PermTSs Fn/Ctr0C Angl|SA) Pr#phr2coQ9m Is AS0{ncechn!Њ
'adVelїtr80f@Eh	 QnrimaavVd"\i:idpZBBid`v!P mmHQvE$@S$Vq	lujMhP0@ч6P{q"n ruf 2blOoc-n`ІGaK1KQa`i+o A1.1O.4 (\!ur)ccue!67б/8G9B^. Eth1"t# 8=>?O@?p
BTokcRing@DADC`OEUJ_GUJpIdq!0bu\+<BPae0aQR+ OToUV&WPoY<Sl ?_X\Z
nreІ[aaAbsn&`&:Du ^[ d?e^_ghbkr bhf_opir ?s_mznCO]qoz{uyO~oxjngn`_[0_/?e 	'ex p և?ȋG uGvA	o,__ [Spe 1 : Cc-9.p% ]A "miA2PDS- )m
3PROD*`9 a /vNw?=l~ooOɽNumr=o"roceځ,AutoP

%r$libLegacy Amor1c pM"$ Retasrd"$exp< P) DF12Tʱposf{i0A
{ux,av?t@ B 硂cu'n I  z$lA <F1=Ai> Nnfoema#l P;ӖSalval floppy Ua 
 ttoRip~,tina dl@ۏرiOfa ڼ Pi	ەIgnordNed ?esci E'l'i9`z0py؏i_n ,tup #iczzasswoe0am@rato# ؒ@+ccSZ`1
svo{sٖP IDsxP?DriveLockj %S`tC, #upQo BIOS/}"g a7viGi!7ix"truwi UC`+b%b`aU
5 ,leѡOpϰ=tbo rigid$AEt*ahGS+lH$ loxBM AvaPt$LHu Dimr[[ca0 m@o!# e )Bga$&vvAoG!Premwi qlsia0+7tas er`ۭu   =F, ESC=AnnuC(';)a(Ate?)=Si,NQ),X&a3lt'=A/r.ܕ) Uschiav fre#cca'Di( v  
u ap  ۀ b0&<I?NVIO> c'@@3`Ř'C!e.1eguaN&s'8  un%9:Ч -> o SPAZIO = *suss  <-0=BACK&`=CE= cRn.XTAB=Cb>oBMAIUSCa+BhAX!= ,8BP)AG)GErr0
  Qutn Opu?A`ńKSi ?v@Q!u Jpǜx
. C4'&P01@@uAn@!' ogwgia
o LQpp2⠿p

reA`VLtsa'gga7vM`B  nbGook0=QZĿi`pa5a'P[
b3roGa6at
 NP?QYR2lKj
riuӖProdu@AU Nt]  TixE"1Veloj9?xneppinMisca(L1/L2̤qme`!R@3_ROM Famigltsd`e:ьmtQoor3_'rollp'c:er?wZ  6N}O|Sg$3/4hand@φLmn߈~vods p Ppn2m*5Get?m(B'B('A)1Ȁ)234T mo)) }/Hl}AfpondaFA@ so:UunQgger? 0'@5:`uA1X%q'rḛd/r1, inx`a'fav KdPvi_@]&&^A:JUq^A:RM?\`WonouCS^`Yޑot2vQtcpMvp
d@= 	ۄIOy`3(Sevo{a	 ? k	" i06qjre?P AT1 (Rap)2 (CompletRCtibo }( ): 30޺Tc o .&B0%q7q"Tja1r`T3hU'hp nP4bJ:s  \0:Qv!' @Q.dfPvk	LS^aMs  grib1 igol`,:= SJf^anX&de u Ri S.M.A.R.T.ъ"bu
.%%v8 32HnuoA? z 2dfAs1?`( Si嶐Pb5zdp\?d`VK[p`Nd@ܱԂ%!$cb4Am7lSkqa_pZ,Ы  `[& fu4mezza
S?martCa @IARc AY 漡[z@DA6o4P?
erdzddatiEffizsoPmin  ca@RQcQd`bvVXipaUfULR B cy@srna	Ob<#©S1S<Z2G#_PLickLockCCspen B@o{\!mouZsI'.MC؀`X  !graˑ#qɔXR-Bze fEt$@p :,!RMsar?pi?li_RsW# qraDinfـ1eD1&zԢÄRAwPl\ PulseXHo GCD-ruJSe@vtЛMoНOoПoPoС@lT9H p[p EPfutU!h_b19adQ  uPIuDe/. De$g  p	 `0cb"ݶ`'UTENTEPRINCIPALE  r@P0 P]X9b ]7manfuso. AnPV V*^ ձ  PP1>AӠ	e1&f0tb(cd.lPQu $cs],z
dpu?HrW` R(b0W`;^ԧs].,1aY BV &" nn1ݰ0	 @Ӂ !Y,am@B8A1o ESC. !F*vq's swudovAشCusr 'Y'po e|F10.Pa]! 1akwTsnr$(9YJP1It@P=* 'D:Q܀˅i  MiB[ayN ()Ohi USBBGNSut]`k(ZipPrimoQArzᙰҀ ЙO`vP PDecRVo 0 Nu5m	'DAlд`B1 Fn/Ctrl TT1IngHe (USA)Qipu87o mђplЗo 5o Grqpl @#aPV)@0Mo`FBidPq!ECapa?mem @b	1p%!P	 ; ~lb$T'IwŒ2 NՏR	armKener!g0𭧒1& B0ya4;ƒ
(Pal+Ps Ethe)to 12߿3e Token RingįďÐ'Ipťʏǥ3 Isp's-]t P0/"wѱ(@ֿC boֿ  Dٯ  fa0jDuC o܍ 'O@o
?o ??o_ t?!a`6nig0 /_	
_ pmo 1BcS<+l //Od s 
_"#$?&'$f[ AUN :PrDho .0% ]//comQpz12/SZ/ .
4t0052e13/B/5):u06;2*@?U2 A?_i + OEoF
- НePi1~AutomaZYFloppy"Ə?legacy!hAwdRӨAcR!q(sec.) ve␝eVSPЂF12 S MeKF[QZ@WNnu`@up <F1=Hjlp>rkiv Sy/info@at0s\ Sg pIskP4_k iCgug1πf_stll frn_8b`bbpbn@ar?fd` Annu>Aa nd h och sluAk "[  ln pa_kg4_jgknk~l Skerd\Btrssl.`  K`jasu rt-tjwEnsspVsiuw\-IDZu ^!}&wu~`pt 2dYtd fr  BIOS_yPbyggd zm.{i~HbabriknVerktyg Krjr v ` S[vt 񞰢HDD Ak}]>us fO jt VljprDpga@T nedt tplcwǒ[}\czpZ}ZTryY{p?fri f]g. npuPbstA&U=, ESC=AOvbrycFD*oApa
l, V=Mer [Pjv k pilQj0`sa yȒ!rt<RETUR\om`tt񹤐.Zeqlj ge埳eri  ;: ->  MELLANSLAGSTANGENTEN = NhmP1g<-BACKSTEGF?regeѰ)ڶTABfKIFT+OeԡU=  &jfԀjVޠsfel0t grQ  ku t hdE@` uppstodpden. FelkP01!innsQgd_pap{laq Ntvm krv a3ݰP- g색pam\ fl]ys t uN-dator/RG exJѨpaltidig_˙2؀klRhTk*NN,@G  PUL, typhasGtigs\gCaP-prlek (L1/L2) M̀L ROM0`h^familj\k@,TSsnumsmnP]deo'эFbp|PyrBqzHP' 1.2_I34Z`aQd-_ ? \ɟhgei,Qv./ (2)'1dp_sSekۻrGVarg! D5SL1ett  Bڀ*Qnehh_RӠskaUp B_/7b-aHЇHi_QkЀabQIBA: aa KhiI2&srskyddad 
agN QG %_fhzPqȴ UhG!`?_jhig jdr?4_m()׏T!-1SnGabb- VfjRbn`UPkHad kd (@v): 30,p<0!%ސc-l ٙs4pppq5vӄr Ϧ4aТt$6:ǔ	"9Ok@"9Saǣ<ervo-W<LRbzQP"6Pttribut: IDx@Рd grJ2S.M.A.R.T.-A G'amm!'|N|.ifi1(nF0s6Id LԄ@A+6Q9TA%| БcFva_lika mPGs5M  KFǒOҭin%IS?Qv2K  Us  fune ؇OUoV$KX`SX?k	Z om  6 h[tsZpa f$sW0m×lo&K. aqabglmM!Ctj2h@+elsep9rresu iifu0- Hf 6,J9ju|ےwQuickC telgeG Lbm!C HZbY mjliggaPKrbb4-p  \"KؠZkorihg@a&MbliHQaat1KM!Comv=Mi p@afЎ^PO&FӞTrd FQt<a napp/CD-r4DT<bnHrdBq P捐34 HuvuQ2FE: DhV#ch .pd Des~1i`㳀` iANV-bHUVUD _aQӳpefYt .< ꜘWq`-OQKp?10ilpFfrv~Z \kauPh@)| lXa@@n /nbg$ Q GW. -kbeftsepm q!P`րO.@5  p? -~'I o)?"''v sed`taw.h:R da:;ԑs{D]3S@ rpQ":zMpliBayI ǔgE ($O0SBfǔ_ Zip-F!IK Fj7A2A2 QttoQN`YaT4Num tvVx$Fn-/CtrluԠ4 EElskt (USA0BПPkd?HPdskrm]s%troBIna+A"bbel d0 [p? Ceo }nQLlkPq1١ C)R䰾^pE-ҟ0Agg@ls`\mh`@v >, expC`YA7Ned Ethq@oTo!RC_;?; QÈt	|A7Unik ntGC6>rtus ď ")bKalib!(@R @k$dF@LDual Ao	'
% o_
6@%!D "1s!1_$%_'(>#Handtago,o0.@_3)%O2?7-Vs0h6Ymo 9:;5<>;9. Q?A_B{1?D_EtF?PGHdFX[re : LaPr 9.O% ]N^0TklarP2GOuNRO[P;TQP3GOaNXUlYW*\+Q  \  [6@_LxoKOcwAuton8"brPoegacy Free`| մsadap҇rlt@drjA!snabb~R| (sek.0vF1 {moaBdStyrџPgJ1epnae } aget O 4 opslaan Configup{vow  Vanafy`@xvz|ndaard0]O~` stcxiWijzig]ne`Ő1rogramma `Soetupƅ zr w؃ypcxɃ DxObszPtveilPthee`rswachtwo5`pwn AOaatbXg>t ID's똫Sm*jC`-+Oq`umv  GBIOSܟO/tbouwdegsahFa?brieks`kgugzwxtOAccu@u 4]ejelecLu aPpu}szelftptA}@}`-schijfeiAc doApA  D" P w0gPn GeeaP}c1alcal@bBem` igrijsgemaavel҄o{0ҕíuky@w@,\?{gxo=SƼ, ES?C=Annu`֑b0D 0=@eal!JaNWee f@i`, AѠw@,=Mx0:HulpB?pijltjptƜ0rui Zdjui0bjnukeuz wark<ENTER> indŔ:be0Aw`vol] Za  {:  -> of SPATIEBALK =GW<-BACKCE`Vorig߹7TAB#HIFT+08o=  4; Mv4ufouPDe RkniP?wfӤge@ F0쐌 tre1tijz`s?en. co01rw sais`u xwe etv3oere`ԓ0A`N d`abas԰ƥ?t nP not~ok-pc/eRP  Pis뒡beigd82 xhppx1ѫ t Nm1yprocessAiSneljpp
 OmP} e (L1W/L2PoGpu]_capac0iPROM-RevisuA
?
 Herzienga)vābS6mm!A??videokPPVR5ځ0tro 0|lYǾ$R1/R2R	3/R4R06  O d!&O"d!𠬰o%&n re(TIn jis4y'I tificuje @j-7(qdzq )_,yE 4$55$57$5  O9$5!;(<O=p'??,*+,lvSecu0iL@op: Aʰytt a0|s yeygew` PRbeP`fhgL  d A:W`xg-  /{wAR RSOgeOb\xoffAGa@w!TvT%d BARNQnQ)oQgqMtƟP@J\O~De@ui c ԂtQ^:wilt{?Aɇeea? ߋhiZ\]To1 (a)p2 (U`@) P]ra  (`v.): 30AcsT	n.f0%toopFxp0@hqoPMpbbroDzAS:-QesC@Pnb`c#}pDN"}vo-lees%쇵cKb btz2\b ӆ`k:P`SbijQe S.M.A.R.T.1-AguafPә.S@ud@ieuw.BloC@r AaIfw@b! k YC"3ls H VzAjV	 ciKs bBskA `u ~!skelt, cK01e*~`  hQStCdA-GAVߣ,A  d!kqekszaPugze gxg FerloAZ@2zaK Qchb,qZf≒{houdHi@qĳlfe cTʑfVdGDVa gR0SQtb TAmP@S00*gi,2h폦brY. E թ3ek htraakbdBC0~(0r)p!Efrarood ParKt{Tz0D@dloo wetw KnS> Cd-r`PDXN!0v\ZVo  _HoofdHGr UMo✥YVvia`OL`SJIѴi@/zow HOOFD-BGEBRUIKERSH#!3Y  pergman SSN 0c  hSMw!0C  fy0k!0Pc	<0&comp`S's}`bh~qrt dP "qm2pנW3f. A%j@tI,Za=nlijkp !W!g3~iu,Ou/pEwSC-r. O  LqRu&
BofQ 'f'0btyPk1F1!00b
|T `PL`~b A\ۅi#&#
ҕwNeЅl!W2 MultiBay##& ( 
(!As)"#"D$ USB-O&c`ޣ&&p-O3 Ef`wep!VpOVN!+ZKesdZqdAQ&`ONQZd`tus Num sZF?n/Ctrllsse=p enR.VMRR hOsappqOb1up&4beP\rm4lE`Dn89^Bij^Vo-~U`! 5+`p<dPIpEolV0\v<g`u$nti]zpa5ԁps`a`{N
 % 2˩VrmPieSBHrtTpNF (bZa)I0KoL!
Et \ AO(PPQ(PPSd T|RPU RUT
@o[\2?]x\3 U0~kt@cResL ccuwc. qďeff? SDacGekalira/hwKib՟ojw `5quualq hiook q/n45 hivr xou߄#B$hp}zs?| H`?g jpvorm hi/c_h|nL`$er-MUE-hioO󟯎  RA&ipϏo  [14p 1 : BAvo.d% ]&toio`c2ntR՚ߠn3 4ƚ_x٫֟*@J  Av:tòL7F.'Mod.zrG gacyuafxaR:adap@fP302(sec.)0 p_op-up2sP F12i ))0tbbC cursorbPur!EasyKPop-qGP   R?s?[^̃ZbgA`viSETUPj <F1=w?v>`t@C? VXe?ɊւQȂ\_܂P?`sfB Nɕۑ ݃ɯ?T˩?AΏ?'5f~`H?g! Ho? v!̂ɖ42XɿI  ׁAבO̏ԂPνeB?ڂ!4ׄ(ص=!̓eܲϘ@L? ?҃pXḥd??Wn0oCX @\̗L/?2DfIDh?@
uaN XcفAPν͍[?4Sm`C?߽ܰgW BIOSY0 ? @hɡp`c[o`̒? I%5n5ˀ?`e g IvVP&A53 
;  ڍףጾ  k`ɀ߂Mf@0OtB,
sSuY
U ?L[Q=AEsc=v"Z?so<͂#P
  !؁A ŰrR. J\ogpуj?ڂ@ug[E1:]`΁7ȳ#Ag̙ ?!->c ypo[ =   <-c[BackSpace]0'٣c[Tab!)ԅ)[S?hift]+++*`!)׊mF)[0揷  G ӂ 4łݫPι2r?ņ 0Vݡ3q 3 a
!5S5qɂACO?aڑQɕKv?h`L?O x&39Am
u! cMEU7Ȃ;o56Bu6Y󋵄9ɮxC }R ɰޯ? ۾ Iߑx Iݸ ?iL1/L2p L ROM?rWP1NwH 0޼ޮ?5IرٔPwP O۰ׂް#Rޯݸ?ް QTt ʟޯ?1T3V2V3V4V?BVQDIZ	TZSύ[STE_DI PŰrb*(Â)5V6bDWe3e4eVZ6bZ[i \6bO^/kk`nTi&BJ?_>s x?:3ƁA!7FЂS ͵8BPׂĎ8!/ϗpGvύ쐬w>A:?݉ F
T}#"N C3F} {F4  "O@|Gv;C3Vv<>s|֎~4! 3y #ψ' `{~_3  ֿB0΢H#Ci  iϐo e`<` |B01iN@0p2iSv3 .M.A.R.TM\zs?ԁij:G 30B ѬSd0% AGYAG OK`z!?~ߤg?f B3: P4mcQs|T={ǂݥ<@&)T|
9sa?FID0'66.?Q3M   .7WV!ov0P`It? PA t W͂854p "`f㪓͈Ի
Ɓ0 zwv2C3߼d9(; buNd}'DƝ<X}2?h Om/CƠ3xbҪ(!xY87EBiP
 ђ;07p#ϱƂ!πQФxֶ"0;Ⱥgq@$v?? p&qe7{{ӿ}E/6Ʈ܀A=Rی삪ԻQH҂xp <Ƥr4PٍċNs7v?q>ΐr?A ԊOtк??VPȯܰ O CD-@N
 s|{6E34ay }*r^G:2Ui 3?i{@C!@ 4Qp#;B\: `缕 0Ta𡍖
Ƣ8 i9э͕?`Av?`p#R?sa^痣҈SȢ7ۊ2֋A Gm֫>0 uR
 O4BpA,	  &7u;#>ۏ؊ԓ ł2$͗L5B<̰4 (h3~>ql`ӔC :)rt%[Esc]ppȍ~d@ĂO/j> uDriveLock `?t[F102A )" V8  9~z*"u~qdyg}?`b?: mu
 ExF	a@sL?O x XGi^MJ8'K`USB8}NrNX p7qN ZipvI1ԖW 2R3R4RU5R6R7R8R9R10R3FNum8s  Fn/Ctrl"2̟ؑ {  p (USA)~ ?|Cr̺Lf sCXbN?KV[*vp Qg`qo^_^E s =r Io  W? _ob TYrbO?ڑ%̧?FG2 gȓd]_iG1_lsj?LKKMDqmE?therneQqt q_usvqwsvqqg N?eOv{{x{{_zJl!aNmOo3??j{ ID @\bވ Oo f b?^ԯ݈;f#Gߒ .JgtE ϝ_ q(?hnљ8/RMEUԱK ﯃/oMϷOϼϺ  f@6v1 : [d? .C% ]C/!OCE2 æ?~o7v3č sʾIϧ*Җ ϡ@\ﳡsOcaaT i?o OIntel  SpeedStepC technology -HN\t`Dd_ Aσ_vA  Ӱ ?`apx?(b) P:sF12 ?ԁibs4o[\	@^@6`@!bȁd1BA6Q  /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&') /*O+o,-./02 /3O4o56789; /<O=o>?@ABD /EOFoGHIJKM /NOOoPQRSTV /WOXoYZ[\]_ /`Oaobcdefh /iOjoklmnoq /rOsotuvwxz /{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د݀/Oo ` a b c d e f g4 =  :    *     	 
 F   `  
  z  @                        H     ) *   - .  / 0   $ %   & '     Z Np! p( p HZtZZ"Z(Z$/ZP5Z|;ZAZGZ NZ,T@0P0<B߹B<>"ب0`8lƀv x|v||p0p"   "0 ߐ  = ~ =$$$<   DDD OaƄe  i  o䔕 u  y nA0 E  IO U   YN ~ `' ^    y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>( ) +#'?
({[)|+}][{]}'@ (#^()\|+y~ z# {{ |[ }| ~ \ ^ @ ] }  &12"3'4(5-67	_8
90)aA0$qQ'mM(%) +*,wW2,?3;.4:/5!U @ z {=V-+*'(as($|O  )9*++'()+'*-.!001335/07?8
\2()|3;/6=o89'5 -=
^~+]}@`)  ';+(:*[{s\_}\|      ZLLLXgZML(LPNPNL\ZQPOLLPLMhM֐M(WZFPNPNPOPzPOS	T
 + 9:;娀?@ABC8 1 Z~" _Z\\Z^ZjaZcZUC\P]B^]?bZ0]@UQRSTUV2=  WXT hO 6 [	T\@]*\^:\$``^]v^][  U]^_`5abXe0 Vf_ZZnnMn[`Qoo&oAe iAc( 
]tpkq]lrmrnr_ 4 :m [0mSb4u4u 4up 3 	ZVfU4u4uPyHyVfF10 Setup Imageq|_SETUP  " 5 {6vp4uppTpp̺4uI4uCcPuy6vPpt 
`VftJVs дUttVfUtVfQ!~tа{۪oTcp2= 4 Vf4u4u4u4u4u4u4u4u4u4u6u3 \ \6v4u U4u4u4u	0PypEV!	v嶃" c" " 韨2 U"0	VfTcTc5TcTcTc '2 |0yTYC-ϳ/M)00VfU|(3=s2="Ppɭ   m    7
	89:;<=>?@A-tP
+ZVfTcTc#=  TcTcTc!Tc&TcjTc3TcBTciTcnTc+Tc0Tc1Tc/t2Q)$0\S	 Py0Gd TYc` TYtؠ /7 u  w0R0{N]d]_p]>gP]]]]x]P_gԪggg]x5z{  }UUUUU~U*UUUPy0W=`pjpppp꠪pppp=(Nf숰잰캰ܰ=,0<0V0b0x000j000D^dx޾=pp&p4pVpdp|pppppp
=8DJnܚ@0J0l00000=H0h000>0= !UDRbrUUİа_	=*pFpUXpppppոppp
W=BlUM 060UV0z000001W=:ZzUS
 	
Z
z
E

"

S@0
T0
n0
U0
0
0
0
_ =020
P0^0x0404000
="6Zp>p`p|pppªppppppp =&>fƚt 	p<nư=p<pFpRphppppp, jv 
0# 0#.0#<0#J0#V0#h0#x0#0#0#0#0&`0&0&0&0&='4'b'j''' @p):p)`p)lp)vp)p)p)p)p)p)p)p)@,",0,6,>,D,L,R,X,`,h,n,t,,,,,,а,䦰,@1&101:1@1D1L1R1f1p1~1111*1112p511
@p7U2p7Np7np7p7Up7p7p7p7Mp7#0:F0:U^0:0:0:0:M0:*0<z0<ը0<0<0<&T =v==̰=M=" 0?r0?ՠ0?0?0?!T@h@@@վ@ް@@"@BTBfBxBBBBTBBBBS
#0F20F60FU:0FZ0F\0F`0FUd0Fh0Fl0Fp0FUt0Fx4GtGGUG0F0F0F0F0FFpa0F0F0F $T@0N60N\0Nz0NU0N0N1N%@0Pj0P0P0Pj0P0P0P&0RJ0RV0Rp0R0R0R0R0R
' pTFpTlpTpTpTpTpTpT(VFVRVZVlVtVVVVʰVRV) YRYrYUYYY°YMY6*[~[5[[+0]r0]0]U0]
,^t^^^<-G__T_M___S.a.aLaU^alaxaaժaaa/Td<dPdddUxdddܰdS0@f`fzfUffffMf1 0iR0iU0i0i0i0iVo	
VaN2oHo|ooʰoڰooQ3kqNlqqպqаqq4@sDssps*ssȰsڰs!1t5pv\pvzpvpvpvpvpv6pxXpxxpxpxpxpxܚpxpx7zzzzz(zFzdzzZzްz8C}B}Ut}}ư}}S49 pppipp:pFpzppp&;bzRi!5<@U4J`vUM=kbՌఈ>T 0`0v00M0? `ΰe*j찋@ 3pnpppppppЪpppppppppA@6>Nd*2Y!4B40Ji50080X0)z0e700a8M0Cn՘°찛DT0d000SE pppSFpppSGpvppMp.H M氡*I@MⰢJlUְ K@.pajrppppppDazL06J0J0j0Ft0DoGHIK0I0%L00500M@U.@dxUڰS"Nk0d0n0U0000M0O p>pUZppppMp P'p<pU^pjp~ppռpppQD&11PUf5R@-U@\jpՖST@0F0p00500T@U2fMU@-dIx¡¡԰ Vbp$p:pPpbp~pŚpŬppppW BfȒȼаX'0D`~ʠY0a@/kOloma!,0UN0r0͚0ͼ0500Z@-0ԩN0ԡl0Ԅ0Ԙ0Ԩ00V0[&0F0ץT0d0!x0ה0׼000\0:0L0\T0l0ڂ00000]'0$0(0a{,000:0V0z0ݰ000"^Dpvp࡯pp_0dJ0v000500` 3Ul䞰ȰY aK!U"<HVUp|戰攱檰欰澰Ұb0`0넪0000c Jdj
d *Hhe*!+ܚe 2@LTZbjpxR!Mf :RZd12n$!44m5ըҰgJG74a8PUh̰hT@F0 L0 0 0 Si@pppS
jpppSk  pppSlpppSmpppS$n@pdpxpUppppo6pHpZ*pjpppDj!ppp p8pFJp/HQnKppJ!LpppUppppSq BTUtSr@R\Ur5sYpUJpvpppppptaLl°u@p2pHpjp~ppppp
v@8DJlĚw@p"R*p"tp"p"p"!5p#p#x@?$~$$ް$!UyC"0&,0&>0&UL0&`0&x0&0&Ŝ0&0&0&֚0&0&z 0*<0*T0*l0*0*j0*0*0*{@p,\p,vp,p,p,p,p,p,| .F.t..!ͼ.!/Шn!ʰ..
}@ް5R5v555aʰ5a榰5 ~ 08,08P08r080808*49080808eS@ ;N;\;Ur;;;;̰;ܰ;;
Tp>Vp>hp>xp>)p>%ݜp>p>a{p>ިp>p>֦p> pBBpBh*pBpBpBpBS@pDppDpDռpDpDpDT 10F*0FF0Fh0Fz0F0F0FT@0HH0HR0H`0Hn0H)0H0H
0H0H0H0HM0H@ pMXpMՀpMpMpMTNVN|NNնNNNT P^PPPUPPPPS 0S80ST0SUz0S0S0S0S#@0S0Soh@0S0S
U"pX(pX6pXHpX%ZpXrpXpXIpXpXepXJpXZpXS"@p_Xp_vp_Up_p_p_p_S@paRparpaՒpapapaT@0cT0c0c0cM0c$dzd5dܰd eneee T0gf0g0g0gM0g$ ذhhղhΰhhT0jF0jn0j0j0j0j0jUK
l8lZl~le1nHtoolalil%l@ u0uHuhuuuΰuuwhwwwwww& y\yvyyyyy" {j{{j{{{}D}d}}}}}}} 0@0T0v000ޚ00@p@pdprpxpjppp&\ƚ谄
 pDpppp^T!vS@0F0h0U~0000500@۰U`Mఌppp5ppUfذM, ppMp(plp@~012G~p՚pppT 0HzըΰT@ްNpUưచS@0<0N0Ub0x000M0@pbpU|pppMpذ6UHdpxUpێ՚̰T@0L0~t0M05"0L0e0000@p`ppppppIp
Tp8pRpnpUpppp5pp0Ul0000S$谱5갱@0U`00000Xj֦0.0J0X0h0p0x00000000j000 쪰<Rv*-[Ұܰ%ꬰ]4JPlպT ^Âæ5 ũPšczŦަ ptpǦpp
 hȠҰ6p0ʔ000*@Vp˔p˶jppp *Df̡̆U̸MC
"U.HZπ"%пo4/rjܰR00a080UD0L0h0׌0U001׽ pFp`pڌpڦpppp@B\܀ܚ԰Vhފިؚ0X0!j0t0*00010@j0R0!pJ000!0500@UdzM@XUl萰辰ذSpfppEppapS@80FU`t쀰쐰UȰڰS$^|՚︰ܰT oprpppMp 'dՊ@pppo4p oVj oZzTaڬа̀0D0^0v00j000@Fdİ$jªܚ@pXp~pp4p
Ѐp	Bp	vp	p	p	p	Q 0D0Z0U0000S 7
N
\
p

i


԰

 0:0T0n0x000J01~5ڰ
ՀUjS
p`pppppe.6NzaRذje؀J0060aN0UX0f000U0000&-[ ـ(! !.!iJ!P!t!!!ְ!즰!ڀ%Z%p%%%ְ%%ۀ7'`'~J''Ȱ'c'S)))M)*x*5**
ހS0,Ud0,0,0,0,S.@---M-.L.Up....M.@060UV0f0~00aaЬ00004oҋӑL4Gsd04ֺJpq0404מ04U04040404M04@p<<p<U\p<np<p<p<5p<p<, >UX>|>>>ռ>԰>>T@j@D@X@t@U@@@BS怡0C0C40CUP0Cx0C0C0CU0C0C0C0C50C0C@FU>F`FzFFUFFFFMF opIHpIUdpIxpIpIpIMpI@pKppKUpKpKpKpKSk0M~0M0M0M0M;0M0M@pO6pOLpO`pOnpO|pOpOpOpOpOpO@jpR@pRVpRlpRpRpRpRpR TLTfTTTTȰTTT0Wn0W0W0W0WaD/OoǖaD!<0W0WT]X]j]v]]]]<4^ ذ`8`L`\`x`ta``ΰ`ް``cTcdccccԚcc 0f40fR0f0f0f0f0f0f0fj0f0f0f@pipi&piBpizpipipijQkׂkkMk-pm@pmTpmxpmpmjpmpmpm,@0p~0p0p0pR0p0pi0p0pS@0sB0sX0sUf0st0s0s0sU0s0s0s0sS0vL0vt0v՘0v0v0vT4wLwlwwMw@py:pyjpypypyejpypypy0|F0|V0|d0|@ 0|0|0|0|0|0|0|0|0|0|0|ޚ0|0|@(8Pn* Le p$pPpppĚppb԰$pxpp  M$pҩDpppMT֦ ؾMZM\j "MV0~000MXTfxψ*Ϛ*p>p!hU^plppppp/5 Q×7(JTdt~j&	@p~pppp4
M^𠖪@pPpxpppppp"@\|İަ 
H\&@ȰްpDpjpppppppNp~pppWMFplpp5pp@|WMR0z000a00000D0\0n0z0000000R0t0000M@zҚ pVpzpppp,Mh0
00!XZ/[G\!Tp~ppp5pp 0U~0¢000_M*RêlÔ4ĲZ  0<0d0p0Ɔ0Ƣ000 0VrȜȬM
0000 0.0R0p0˴j000(J0΀0θ00S όڰen, MBxш.!MX0~0ӊ0Ӛ0ӪT0q000M0" p0p5>pLpJpUtp֔pָppS*# 0و0ٶ0}0 $M`pՌpڼpp%T ۀ۬Ȱۍ& 0%VTq0ݎ0ݦ00ݓ' p8pߡHpXp`pjptp~p߈pߐpߚpߤp߮p߶pҪpppp(pXpzpJppp p%f0pe"p%#p)@p:>pjpppڦp*pZpvppppp+ p<pVpppp0,000$- 000.0000:/ppp 0@ppΚpp1 Dbx԰ְ2 0Z002U00000e4qZ63m86T^Jj~:q:İ⚰"40j0000 5BLjΰ䦰62Ffzj7@pHp^p~pjppp8@p
p
(p
6p
jp
|p
p
p
Қp
p
90
J0
Z0
0
0
j0
0
0
:p@pjppjppp ;ߪp`ppp
< 
=@6BTdx>M060X0n000000 ?@jҰ@ 0R0r0000A@
	ϼG\	B 0#R0#0#0#0#0#0#"IC 0%^0%#0%U0%0%0%0%
Dp'!'>p'^Jp'tp'p'aƖp'ծp'p'p' ETp*Bp*^p*zp*Up*p*p*p*S"F߰,J,Z,Uv,,,,M,j,,5ʰ,,$G@00f00t000HC81n11&1
I 03403enUf03|030303M03.J@55U5Ȱ5ڰ55q5Kp8,p8:p8Lp8bp8xp8p8p8p8ƚp8p8Lp;^p;p;p;p;M<r<<<<Np>zp>p>p>p>QO@?zL?UZ?x???U"0???P@pCpCT0 pC&pC.pCU6pC<pCDpC^pCUtpC~pCpCpCpCCF=#QpHm"pHa:pH%HpH=0^H0 pHpHpHpHpHR 0NR0Np0N0N0N0N0NS@0P@0PZ0P0Ph@V0P
TQQQURRR2iV SS WjTTΰTX jUUڰUY@VVVİVꦰVZ 0XH0XfT0X0X0X0X50X0X,[-UBZNZbZrZZ%ZĨ4]/GܰZZE@H\pb! $pbU*pb6pb<pbNpbUfpbvpbpbpb5pbpb]eU`eeeeeee^T 0h>0hH0h^0hUr0h0h0h0h50h0h_jMPjjPsjpjUjkjjt@ jaj`pn2pnDpnbpnpnpnpn0R@ pn8v pn apqNpqvpqjpqpqpqb0st0s0s0s0sc@tttjtưttdS=N0vcd0vp0v0v0v0v0v0v0v0v0ve@y6yX4znyyyjyΰyy
fêp|Rp|xp|p|p|p|p|p|g{|azY=&~lo lad8~\~z~~~ְ~~F~hdRUni *p>pPp`paUvppppMpj p<pUJpZpfpp}pV=p5ppk@ppp7]W=p p:pUVpppp%lz! լ0m@n3İ氕n0n00*0000M0o0.0U<0P0\0h0Ut0000դ000pT\Z|ռڰqT T~5ְr\pIRp^ppUppp}p@=pppZe=SskU$,4ULdpxUA=𪊉$<aKt!L! @b|𭔪u pJphpppppv@BpHpzppp,w@o𴘚x@j*yj000
z0~000({@p~ppjppp|@BR0@0a`0r0Ղ000o 0a00
I}b>\HDo]j_GU! P0 `0  ~bǄǮذ0V0b0x0ɚ0ɬj000@p*pBpfp~pˮppp
PVf͈Ͷ&\8HVzψϤϴL\~ҌҒҶަ
@HpԖԸ  :b֒jָܰh*phpؘpتpءUppppSb2FUR^ڀڞTF^vՖݸް
T@V߄߲5ΰ@BpUFpppp
p C/Ooa!p4pJplppppp  pUNpbpppնp޴p20^000!)00 T@p&pBplpUppppMpPU`ra2аxԦ1hj" =pXpjpppppp1lʚ 0"T0i72D\Unʰڰꦰ  0 N x  İ  @ptppКpp*@$QUpe@dptpUpppppp=S
@ (U.6>DULT\Uzվذ\p
:p
@
HNJp
fp
pp
Jp
%p
!L
p
p
=1pnbppppp@pFpdppppp@phpjppp  PtĚ,\а @pxpjppphRv!Ųte!LԀB&"\4!/^h"ªa! `R!!ź!!!!!T )\)v))ո)))6T++++U++++Sm0.<0.T0.U0.0.0.0.50.0. v0U$020N0r0U00ְ00M0p3Np3U^p3zp3p3p3p3p3p3T@505<5B5Ud5555555 f8U^88885Ȱ88b:Up:::а:ڰ:::Tj<<*<:<UN<V<b<j<U|<<<<U<<<<S0A(0A<0AUV0Ar0A0A0AU0A0A0A0AM0AtpD0pDUJpDhpDpDpDpD!2/G!2j)pDpD
KPKnKKʰKذKKa*(M*ZMvMa+MM+MM fPLP\PrPPPjPְPP0S40SF0SZ0S0S0S0S0SҪ0S0S0S0S@|pVpVpVpV pVBpVdpVpVpVpVXYŰYYYY@p[<p[jp[xp[p[jp[p[p[T]ņ]]]]̰])ް]ꚰ]]t0a,0a<0aL0a\0al0ar0a0a0aR1accc(hddܦd0fh0f0f0f pg^pgpgpgpgʪpgpgpgpgI iZi!hiUziiiiUiiiiUiiii5ii]nUn$n>nVnUpnnnn*nn°neʰn%ܰnnLp@0u80uUP0uh0u0u0u0u0u0uTwZwzwwնw԰wwT@
ynyy°yMy0{f0{Ր0{0{0{TP|`|||Mܰ|@0~\0~U0~0~0~0~S@F\~EĪQĀUBH`te"Kto%j@$PnPZ ό     j      [h Vi   QLGB=   0{+&!	!$08/14/03 Copyright 2002 by COMPAQmputerrporation. 䐿
!`t`
T
  'p~}P >" "'D Tut


t݈
tt

"
#tDt3=t
@t0`#~ 80TaDs>0[t`D@t#(trD	T
'T?DDD _T% !t
t
t
Duү,"!"#$$"#!P%d%%%Ô
@$$p#"2` `%> ЂЃ&'_u u (2 Txu. B/,>$4 `Op" /{ 1{1
"  "/)z|t}~ }䓣𣮂)D;` ) Cp`t   +,-.
..-$-03,,+$+`9 )t" ~}|}Yp5"{ z}R8:tu݋:D>tA;<} |U=t>9,?$@%B'%($('&u"B&C&DwB&%ӔP&`P%/3d@~qD$d	p?aDR8%u( % C&u*aJ)**)p)N`.(('$'`903aD4<p<%&$p5qDEB!D @,((sVh^QܒRXSE Q' QBDTH"UqbUt~ 33V']p@MIEV=B#U.3ZqU#"E!9\qՒUT"uPu4"%$I403tʎ"0"
pLp"0"_d   55t~)t
5"+pd+/ÞP.%d@ Sp`d,͹dm _{ +u.aJ-`..9-N`Ib,sg 
d,+hiBSje,`Ced`"`7tu
8d" su?v_wxyz{|}	up ;H   01/{09Q705/14 kLite 3qHewlett-Packard	any.01A1"x#Ta+T0	T@t/{3"~0@xDx_v$ÔdPx>02"2"'}"2x x*} 0<uu u	`@3@3@)aT$3TD ȃ@VF @~`T?0	T@3`T%`@@3dłŃ瀾xT?T_"x!T.0s/TDx!TDxD@pp
07/dp1 Dx>J@0P T%%TO~.`OT"2`() d)K()?(@좌JKPWxt}TA"/0g}` Tq000$/P/ P	d`$7ⴕ䟏PZк0{07?xDO+0'yJ~1``"x 0D9BD¯./uүp6ޅ./"xt}
~1PxWvvuuˀ𮀚D
I`uu!W\ү0@SkQ}1``
$`$pl
}P`x~ce
Cxx txDESxxxx`D@2پn}u@g@`@{>}d`&xKFI*Bx x}D7a!P`0xtxtyuup!./}^aP}eSs1^}laP+½*,܁˴xdD0D x^Qx_cD%xfT_bp# ) ,!`X0*h0wA˾qs	!Tp͈"c0x	}0.@ϴ@8}5@ʎ%tȐp)_? `P¯~u| p!~@T`#lU00p6`]7aνּ¯)u)$R4C_L`)}+t)(ѤÔ{@_>*w_x)(0#Q w X0%v@"x)(*`_00.}+,-2  
)"x^}4`q}7>"  }9@6!'B00x)xb`xc @p L0S(; TB(x`0)0 9P4r.( 0F(`xR=	(x᪀x 5! q_(>dTrK~PF = y(.P>q
P0Tdp(D!?(fP( @		5
<}p!Tu"2P Ô2@Y$0¯x 8Rx00`2)6020 T߰|`	pXl@ܱה ]]4C4A@ t1x,xtx@x,qހA0x*-t+ZP`TOxY#^֚b࢐};TT?)xT0p ;pހU!T`a"d`
u)?Td`dpUpD!%T!T?Ӕ @
$T?M;T?`d`}W}*)pKp&$@p6!q%% V'@+~ *~*)Q33T?O)`8 3  ] )A13 )$`$`
$-p} Y}"A3ȐEP3"`uxp_>N>0WA7 87B67`BЂЃ2:6x^p` 	?]g9@K07*q7Lx-!7+_MLNx*MMx+AQVL0x"b=qŧ= BB=@eK`LWM,6!7q7J7J0}G[Gf@2G`GF9KB996>QxZ!7Yq7RNSR8}DQ`R96 ?S07^q7TLTQuDSNTNROU07cq7VL߿VT`}V8 VAIDUNVRS2A}3 A}9 !, uuҌВ}"YZd;Z0AZx'D
q_0d`!0f/00_`0`'`2`=`HpQxWc_6uuuueuu0fuueu]ˏO$[ƨpN`0T`
0c;0  q"| }(0xWP/"(@E(cp
@oqP(qPP ()(x)ߎ(0դ(!t)))((xY))"*+p_T0 7/t
at&Ppd `.g..
t{[;nҌ( |n響,-mp,l`
,-3|d@zt 5n/1H΅+*,-"uPu4+i"o E[x]c=	[xP͠zl߆#x7x8ǧ7t4"PcdǇ"xe0!px," -AtF)DG;qs=1v8z:Bp#$W@23{;"xy> !u
C9./0H*5,7_U?4c~;V~Pno|ZQ}d%]	`
e(j[&b'g>i\af|X6h+l  >}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RОZ  a  " ! * 2 1 : A I J Q Y  ? ) >g d  F  pq kli/ur}z'tw l k i h Ju s r p o t z q { y m Zc v v       
  	 x   ~    2YPJ @|PЬӬ !ww ~~   @"x7x4QApDYaD x2tx1tI#%E[0% %xivv T%_xi6^=Hxk"# $ $ !2lx1 	ү  ¯߀0 l#! K@3"0! Mx3=
⽒[
"xjF`@kz <"p7"" %	x30#0$<T`"p"xkcfp?
0!#3tI.4}࠼xkb$3z 
 Hp_ÓŐ`$H$ykHxgv"xw0	D0x$FӔ@Txwyv!D"0R 48xexvӵDpT0s
QP÷PuPr"xmAxn1xu"xmxvxnxxxuп"xpƷxmo0qP[yoxpf`ӀY'xpޑְj[vpp".0&u)1X)3@& @&"* _`@"x*_t %*%o-@-P"/t7U-,-b,R--o++,U-`RU,`  +u%*$U,00u,,u,0,*+0P, 0  d0`PÔ@"0  	0
0 	@	"0 @@H@@`@@$@@<@@T@"   RӀ 1 }1ÔP2p_0/b`%110 v0//A1Ӕ?@t -tq6wnR!.P ]x.xgo`x[T`"Txf0gv"/*r3/TOp0 0@0 
0 `]"`0/]P 00!P`	 7""452 "2T1u$b405S20 |09}= ~ } | 1| ONML
:
K_^]\6=iTi6 5`64064041$cY2"140#1dn`1o n0u1o! Wu1nX3Y3Ӕ@
3_s33p22
0
1"ɒ4@0
*1$`$`$p#%֐#&v#'Bϒ44A%##$#'%(&) )1$"465  6"4xg@@,xh4d|p%05#(6${zy#p.,v@,0/~-_`)05#%.1,./35
P1/ - 
1&4 #/
Xa7@,7V57/711/975678567`A(8t%77566 88b+,rP?50r0+w05&_5y9/4@,5	1 k17/ D7/r@B `- 
 
 *A0>`-
 53DEмFAB86-o`1,0",+0u0-05(@1
C9D6YJB:hK7G55SU+V4OPoQ3p+50 ?Vr,`*jI5/5JS_B[__[I`e4pv^6[_B:`/5b+0 \0@5Cs,[2/2OWg[>B[3hg3h0Wg?h=[97/p,hfp02"Up#mHpf;?hgglrg#mpy$m~82xfpJ`F0}D){) 1	})	2 2@
"yxfy?}Z@xzMNOpxD Ee1``א}G~X@~0
T`'" #}|XpC~{z}yZ1zxydVP~y0@~0
0 'P~`0`0*0$`+$`W$`6$`$`&[$pYA~TpրQA~RF>0Txv)!pрDxՠ001```	^P0* إ}`@~ 	D~bPC^A*¯7`ү" )T|F`xd  R=./2x~v
xD}D}*0{^`
}^T?Dt
_ei4si24lgpD`P~[@`TﰗBl34a3$``$p"t1e4`tg4B |}"}A~0Ʒ0+o0)1Td`x0dp# xF TTÔP
._/xFt°eͦקxBUB2sͦקxNN2lͦקxJ_J0rߏ789tZ/qC:(x үR7%$Rƶt :t:821(0 (:o$⠷lx`vT"` R9x"`үs q78 0(87P p0 xυv#ս3xV53}+t0ŏ4  %4 +4 ƫr""55Ô@̠Pp`,R̠Ȑrc@cɍd`
*h~R,ϜT0PO,CΠμCC@4A0120``/`@$pNο21΀I:I&IHE)?6PA [xPέ03oppG{*`	6>p1 '?<P"@TP~ ۵+܂E?T@;үd`pxH @"5i5@dq;"-.?hQӑm0`/-x00 <@
0
DDTйѠ0a	 0>d}`	 a}Ct
u/ /tl@@'- _ r.ldpe`0ߴ-DxFu@0u rxPu000u0//GCգt`../0..}00 $0/J..!ȧ- }p
.Ƃ9ˠq"pڡ	 @1R)x0).:)4R`+,01)'.7ݸ
pha)
/O1= 2
5 
x(0	(`!*((p@@0v@{	`~	@0|`T``1_`pȰd0p2CD?գ%5߃0op;Cc"w1AT6%p0:o ""p	S05qB0D" %%O0(ҵd-N-H/G" 1r)&P'P#46P-p0 Bۏ& S%1?-` 3-2cU%`	й%._0D'1T:-#?.P3sp_u.
p@u.H.T-V),*Ҁʀ
*+%DḌ@+ 90&@۸0aT0 +	aހ`>7AIҵ05[0upo)?6*+pFR}}}0
pzQ/+*tZ%)Ƹ!SpS;"쎸W P#1Āp5\BŐ}YBT|!p0=/`$<#T0?O_Nw45U pY}2x`TJbߴbb[`b0>0Ņ54'pB/_D`L7%fFhB2šPcP	U0ŀeUkk!cbl!eA`{o0Vd}
1lE9'o'dZBmd5lpP7s6$$P3cX2urVd}KFkePes8&5f1f}z` X0pRpLxpGIp? 1b #2  TU``|Tx{}A{xz Gxy Exx Fxw Bxv <xuxextx[xs xr }xqxxp{xФx| Ax{ Gxz Exy Fxxxw <xvxexudxt xs }xrxxqxxp"
yxdv0`bPTx`pB8" -88d0-Tx` `bb``bNpB -^XC****!J-c S7C^")u,/g.-T*_/.d^  Q1H'jc-ޭ)ۼ,(f;l)d&AO*+pǇKpGQ䨝iD++kR=
0;l-pPB Q-3މy0hP5$p1q?JR}DAm)=t>4N  0 Q6 xpAP
ק "u*PБ09"RJ ~})IaB Q"<) R <1"+0R¶<$+pMsJ0D@YTIxp`E;D S)))u+B+12 D ppu+TaB5#+".%TOyd k ǔЫ	p ``` =cʫ$0>|`E'~Ӕ@6y   x0@ @ x9P7T?PQxvP_
Ԡ ǀ
  0GI` ;oPQв"0*WAopT&"LtM^q30.~KT``I0}n}S?@.Ŀ33TBDАD xd3"8t`#xVxFЇI0II@TLK}
c<&RM~Gqq3"x)"O[Qe J0OQ17|-3tR"LVV `
O0 )J'' 'BP=[O`k !wP`	AO?"HI.gB*TY#IPEH0~."nf@yri@L@vZY?po0:OJ5 050vq $_Y:a^1p,; ^@	FsD0s 0"*OѮ@"BCCWpaO!Cdpe7R+tt2kC³CFD0`DCxgvBC?"xF?xG@xEAxFt@0( @T.`x@@0xAFt"("r@B`0AA"xB!CqAB9B
 N!OqMRN?9N+ !UJ!KqIJ_#9J+ !|DEFGTW`N JCT&`7,S0uE`AE@0
GFt#R1 =BED}^}e}s}lEAMI !++Gp5@"NxDTK{{NoE 8C̓$0* 8?Ap}@>1TPp}CO	E DDDDDDDDDDDzDaDHD/D'D  EF;V"AOx\@ab1~p|t"x\@Ԅ/BBCC0C@F"7F`bD1GBF 5!6HFBC 2@@TFB`FM`FP9q|PCpP$`RE֢Q$FOӔ7@OOpabO1O0	xgZӒ}|!FO`#`5`2$pCH@`b!ApbDJFCY YOx[OOTyxfBFEOfXPYQa
xc GÔ@π<@bTxcGPa@Da`abBaRaGZTrHUtpcxhJJ[v+xfv2 5p4}t kt0㐿}= m	"YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTׂAT6R7 8G9HO;|INR{r$QI!0O`Od`TuOR<H-H9HEHPHzHHHHHHHHI
II)?IG9T|D%~$C CKpAXAT| $UAPA| '@$@~p@' &;TIڇSr;Sx7؇LABha2U~@<0PS\ODz=ēd
`#@}w`@}(`@}{<`pdP`@}d`R 209KC{ǹ}ttdaKxtxxXx\t x]xat"xbt2#xJxFxBxtx(tb}0Dxxtxtxxtx@x#x> x=tQ x@tp0xTВŝ"x3tĢxaFѡx!TToTD	ʦxTpTx=Tx"PPT=D"Dæxdv0}<t 1FPBPGPEPA}D>"x0xM"xa@P;"bpS?/?@>"ޑ$tk>!$-"Tp\Ô
P~0~7%OOXNNrи7%NN{ z yN6@~K K+L3L
4L6L7L"8L-9L8:LC;LH<  LM`7NY$Q@Q`I A౱0PG1~5KuN& 8C ;CuNuNK N"$`($_`*`-`Q/AWp4`
 Tma7Bp<ALBBFBEBGBA@N$`$`!`0`?$apA_>p:3@2r*}_0  puS.qčr,@ 3`G`[]Np_7"N0dpF_e$kC`QDALWT'p. N00@O"K}$pL`nPP:Kd`ИKxaKÔ PKKdKȭQ@P
:ۀPxav@@~NdNdNdNdNqNNNNͨNNOO	OOO1OsOxO}OOOOOOOOOOOOP P3  P:0a
гv"xzMNO`uL 1oLLx@`}Zdmxy峑mp")L1
OL>`Phr`y"} H?K}UfPAb"uM SMMDpXTM0CM|80^ 0@tރx[Dav av*ppxTxdoD0x7px xP@C`}_K}I	
p"35KxN| } ~ Mzǐ41 VK`q R<LL R<P]((sPPQQQQQQPPPPQZQ`QmQQRRR+C~pÔ`PڭKLV"T?	} 0xti"KMKAb`yJc0
V	7Ph50}
TPd>uK6
@@b0fa7 %P@l
M"G$pQ
?Kp."xydP "{z}yZ	z<rLL%ٲpQ
Mqcuqgcz1Y?0M}8T ppqp 3|p !K#T0P$___QfpARe0#`70xD  *TQaxpb!1%%x v`gq٦_eT1%e*+7,Yex).u0/}+t  $0.TP/00//@"R0  "/P/+u'3" 2  /2}P/",./S2-S2,Ô`,pC-S--ST 36-0"
Flxp0 "@lŝ7xP:xҦ/012*@t?0t /xp+x?D%?0/2R1U2B2՝[xx=pD ?xD C  CpD@æ2x{W_ WPF}WTrTTUUIV'VVVVV2x
,-q=x
tG,P
-,`x
LPMx
!LJ>{Sx
!L #G2AN0"t "T $Qxl	}INBxk RxkP2S0 K%S$IkN R$ÞPxxk=GbF`WAN_._)*ux+ L4^үPF$`& p<SH}_d]p`C^XFx+*)2IWAN$xxl e@v>`R:xkvykxlsPVS  >qSU0{ 	RT2
JTxov 2WxqW`r<b
௡gANfgPJPb>xx
x2NJx	02W)_7P$PN0lO02[l@~WG WNWXWbWiWuWX!	XR
  XvaD4Z3tD@ @Z5"xD @b$P``3@b0vTO!!  +De">x"vv&w`/xxy@^y *Pz@z{yea^*`Os`}lb33TOs1x D@PÅP 4A"KƐ`p}TМ`- ,*))D8S)9S)x_vS)Љ)"(),0,YRYx	`}NFYu- u.<SS0S0u/ u1/U-0U.Np.%.-3-111P-2xp7x	1.-A^_22􀐒N,xalp [2-ÐsPp--Ӕ@zg0a`ҀZ>ZMZaZrZZZ[[%[3[A[V[d[r[$[%[&[+[,[-  [,`lә[Qxu,x~0cäK*+KP
/+*M9
x¥t?e+pOt e*Ф?	S??`{kxЬ}}Czt Հ-h t_,_v`ao} atauava}3Πk'1րA6H 3_K1 7Ѝp)(ߨ"`t G]P:\D\K\R\Y\`\g\n\	\\\\\\\\\]3]w3]  {]j]jUcccca
tt)r Nrc	c
c`2X*aZȠ^T`Ó!KJaxT0BK
r:4 t@bK'  2T`$!J!w2nmZJ`!a0DTGt( Du4c䣒Ӕ2nSTx2NpaPF`@<D
A~@DA "pgqD13"0,p'
  `vӿ""0.p`%T"" 0[P2%$e` Me1p<2◖30 ϓ3d	`3

3 7xgv"Ô
@"2}2416.(1$`$`$Ap 2^"[_	WP⪙;ұ쫖␕
Dxg10Mf"
"xQCT2 C8p_70e_;>"` 0"$``!`"`#$p!F0 䐳
=#"x%ts%13x<q?d @"rW}t^0	W
A:x00Dx!ToT`@)D0D%T1E
 |p!?!D`%!TM.ñʞ
A݀"  :	;
Z
123B=>C	D

P	~x`!ÔP
^`_c"
%`60FF`7@<0x(
(bxA<bh(($=`C0.+xT 2E} 2zC.u DT_`
& ь+@@00	2
 bDJS0cx($```9`B$bDxv zq DxTҎxStTTH`(xS(<x)2)$``$p#@hxSwx(	x02o0. 2]#0`
"*+*Ô@*ӔP!&@
%PR6*$a w$cp!0.-C+(}+ϖQ)zSi+*cď%C++2P%% Gcd"&Gn,@'@o'~``J`N`R$dpT}++A>c"+0T0dp0A00ӀÒ].y+y3+@*"*+oiE"N"xP"5	1}i`$3mp`1_}y:,/0qdddՅdۆddddeee:e@e@ebebeeef&f&fHfHfjfjggg%g%gGgGgigiggggggh/h/h?h?hahahqhqhwhwhhhhhhhhii  i9~(i<00i<C/yPGFT3/GC/00u6$%U 0` @R/@IPGu/H}/bLLL,}鉑LrI%UcNpˤNQ/OL@NNOQJ"NNS"NNU#H P ~PHYrII{LAҨrIIӝ  -GY~ L`| }_?@^_GNNX"NN/bsL[][ӗ ]f\[dgF| ?`z {_i@\]L`\i[-.Q\6Qk.@N.-JONOd"NN)o"NNr"NN?t"NNt_vMf@#@iP0-mYnMy!Qzz{\n{dz ONx"N(@;NɆNο"NˆN?"NΆN^`,$/0NI/I5 J/9V I0AZ!@NNKÔ@πu/ ,/ y`  SP]PP:!5a񧰔M:;~$`jPj$$ jy`T}!Z$;`!!xl UI աJ սKxi<<xlP<oAp'~p'0#70"p@"; p"$Z ;nO❨ J K Lў<xlp'"678x>T934T`љԶÿd@l0_9pஐ4ir@}5@& 4@P| $ >678 Pd;ppN`2"q}op~&s}n{~Ak50802/}}P0%TTm/^^qt
Ԫ }( pe((@~&[×2]cvf@sX$~̻@&8}pq}{|n؏ 
0/mkk"/0PlrҠp^ }p
T?T`0"0"@;u0<.^.`~ K~^J2T {ITO˹I..O/p3@Iz*&R1 G@;.01~ް ~;PC14~FpZ1QP@JB1TIIp043C,V`&J@@ =`@ԑ1"x_0 
T_
O"0.32ϻ `,nסm/e.`.܈܀^e.`n.ov^/ m/0}C  k~#AQP	D7# @T3``1"2 2`p̰2.Ќoǽu.B!/Su.^`} K/}]_\Oӝ]/[Ru.P2p/.\D<fB'\r[\մu0o X @.~0P`TzTT%%̴p0`DY0`
~J	.d`·/ӟ@		O"\Gj$rt@$5db5Q$OU$%5Eeٮ%tx$ݮIt}5}{z~yAɐ`rٿ/`,rw00t9@!u"η E~ ʎ_`-˥t~@_Qq"1"¯01Q`
tz	ϔP1үpan`i | K|\`0023Q^z4$ z3;131^ys((sstNtotttturuvvqvw.wlwxRxsxxxxyᗳq{	j155fPQ/0;a7#1?S>U?rCu2`u3 ?{ z y2
Eb4{F2T`pd``+zC>
E>U>^Ke4>
_?)fe3p2l`&[{0. a{C>
EuRF4P4"&9^bz`_ip455544>e
45W
 ?X_YZ[\EI^7NljOƶ>PfRS@ԉUsNa_dLpOʶ>

E3MbUo̶>pN&0ppNO>hIv+t
vPOж>xi}`z\(?{>_KR>O><_J>=o>)>>?oM*vMOҶ> 	`z
|QDL͘09kR09R1Tl>; 3s>1p("0¤7>}頯1B+1 %u{1(#q1$`=`lp{4$`{ou1ڤ!ux{@Mn3x˩dE|ptu|ޤÔ(qPq"x3TT Np\ q% @MBtڤ`	@pn!8u1˩tpu.3з̩ؤ131C|}`00?r̂*A@/` npz7g3/A"H"P(R*|p*a0}`Q"qO}u.31 O%p}^ͣ? X}^¾90pa0߶/A/. 1 ǳ$3/ tP"ʐ}ת1
~P2"""0@t%ܳPD"LION x1x2`TTxDxD"0"x04 03spA3"43px"Tq2Ⓑ4pDÒ44"56"x&3~oTO&0"x!To`	 xDT"	F	>߃	2Vx3pOdPX#BLҀԀi3ꀚڀ3!䓣łŃ&
! "/ߟ۴@̈$ P@##EN``#\s""P"]"4"  )"@/33@" 3@"P"(0p8 
"߇		D t )ς:q8"		%
"*
 pP				"w4p2
"""BBE"`;a3Ap"""Ѓ?Ђ patsߨ6s ŃŃQ8"%5 p p
 sh`ߡp""~a"v"n$e"b%"V"UJe@11V)pp_){pΦ]d#s o012346 /7O8o9:;<=? /@OAoBCDEFH /IOJoKLMNOQ /ROSoTUVWXZ /[O\o]^_`ac /dOeofghijl /mOnoopqrsu /vOwoxyz{|~ /Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&') /*O+o,-./02 /3O4o56789; /<O=o>?@ABD /EOFoGHIJKM /NOOoPQRSTV /WOXoYZ[\]_ /`Oaobcdefh /iOjoklmnoq /rOsotuvwxz /{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo /Oo  ?_ 
?_
 ?_ ?_ !"# %?&_'()*+, .?/_012345 7?8_9:;<=> @?A_BCDEFG I?J_KLMNOP R?S_TUVWXY [?\_]^_`ab d?e_fghijk m?n_opqrst v?w_xyz{|} ?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ !?"_#$%&'( *?+_,-./01 3?4_56789: <?=_>?@ABC E?F_GHIJKL N?O_PQRSTU W?X_YZ[\]^ `?a_bcdefg i?j_klmnop r?s_tuvwxy {?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$ &?'_()*+,- /?0_123456 8?9_:;<=>? A?B_CDEFGH J?K_LMNOPQ S?T_UVWXYZ \?]_^_`abc e?f_ghijkl n?o_pqrstu w?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_  "?#_$%&'() +?,_-./012 4?5_6789:; =?>_?@ABCD F?G_HIJKLM O?P_QRSTUV X?Y_Z[\]^_ a?b_cdefgh j?k_lmnopq s?t_uvwxyz |?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  ?_	
 ?
_ ?_ ?_ !"#$% '?(_)*+,-. 0?1_234567 9?:_;<=>?@ B?C_DEFGHI K?L_MNOPQR T?U_VWXYZ[ ]?^__`abcd f?g_hijklm o?p_qrstuv x?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_ ! #?$_%&'()* ,?-_./0123 5?6_789:;< >??_@ABCDE G?H_IJKLMN P?Q_RSTUVW Y?Z_[\]^_` b?c_defghi k?l_mnopqr t?u_vwxyz{ }?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_ ?_s     
     U$   4 G  N U  fWfVfSێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.15 Copyright 2003, Infineon TechnologiesQfSfRgf.g.3g.

Ƈ}~ǇvJ gf   uq u QfP< fXfZYQP

{At2[RS l eg{q "  诟3[Za@
  
a 
5
; a[g.Qt|P@f
 DF<d~ug{$u	N"##:o3ff@~1QfW
Pf6ffffg0f3ɹ 
Q +r&u3gb&Rfgݎf(g3fGf_ \-"& gf4$ +Iffgސ0fG(. J&>/(0 1	.1g/	2fGg&q/g_f6f6s47f76_Jrr&v:7Z$8x8g6{47S6<|.=}.=~'=0  f_fYڠZ@!3RQ`[DaDD3YZRfQSDڃ <u-Hu!HuH u3
߹  4 pgx@FDMDwTEPE 4 t L3 s d 0SPPJuOD0Et  ED&NbAE'CWUDpDEqDFh
Tt2@]Cf[1^PQP fa nd) f t|gf> tub~ {tm1c te1c t]ff 8N 8^ 86
f;s"u
 '^QΒh1 
@K [W)Da(g Bq^ 
_3ҷar& ~A *u
r& ur& ЃuBwog,1-[0g#sf8魾uqq@ L	uqWwS/uF"0~ouS p2zIƀtB 8t$2 8D$e{ff+f+Ȥ{92z3{pu~` SY^@QQ{ 8wL$ 8	25
|0 Y Bl_3 zǐo 7muj ),,Q tLW)ff3fsf%ffK8s{`fClQR*gً1-*
tffpUf;sg^,g,WZB%V)&6Gr *fss2tQtÓ1 vfV*ʻ *쓫ʚ<ڛ ־Ƈ,d +GĚRP_EQ! [@FPQ `~!fRS2 Q@\ nZ"AA 0BÀP;P s
E 0 Cr
 xRO_f3g#~|ǃrtfwQWf9ˉAP bA 1^S*pQ$"PrPrt Dtt%53A. )0 tн t1@t`5t
I o:ɚ̙&!'g%aa fQVPmQ\0l0"AA|!26Ps؀P"rc2ېl ɹ@b&'"ff+f}HlhUOBB`%Q%`
Go!tO"BY&Ѭ1OsѬ1Or
q"tfu`3yȀUq a 7pTPsIu3PBHa8 XHPS! 6#a P [Xp$
pqSq[ 
 tKCX 裝P0#"3`   = 肦r2#fr
fff#@k%  t	f!bf#fk%tbx 9$yz 4Fidk  4Buf0b!b/Oog9  rX%  t9  t
%  !&  $  s9r%  5  r%  5  r5  r5  8  9   撰68BAS   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $   r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  N  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ Z  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 4  X  f=$ J  f$ f$ f
    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 9  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t<  $ =$ u	=$  w$ $       f$ $          f=$    f$ $      f=$    f$ $ wf$   ;  bf=$ uXf$ $ $ Cf=$ u9f$ $    $ f$         f$ f=$ 	r	f$     B  s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz/ZXfPfRfz$<fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytCsZ[Xfz/fyu$sZ[XSR=$ tO$ @
 fyf@t	s/fxfz-fyB@u	sfz/Z[                                 P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPQfp#fpfpfqfpfq`fpfqafpxfqfp fq0fpfqfpfqfpX         r
   r   SQY[           V    .K9 ^V  .O9 ^Vw  .S9 ^SfQfRf P=$  u +=   sf 0 tW$  Sf  [rRSUU*UUUUU*U[$ p  1r<u   f f  fZfY[SQRXr   $ tZY[À=$  u r  r@$  fPSUU*UUU[fX$    r
8uf f  SfQfRf 0=$  u +=   sf P tW$  Sf  |[rRSUU*UUUUU*U[$ p  r<u   f f  fZfY[SQRXr   $ tZY[         PSQR 8 G$ffG$
@ظ 8 G$ffG$
Њ  $ff$
 ظ  $ff$
Њ  $ff$
@ظ  $ff$
ЊZY[XPRS  $ff$
$ظ  $ff$
Њ 8 G$ffG$
؀㿸 8 G$ffG$
Њ[ZXn6 6 26 =7 6 W7 Q6 6 26 WUU*UUU#  'G_PQW3   f.;I9 t3_YXfP NNO<uNNO<tNNOtĀ fXðNNOfPQP  NNO
ﰂNOYfXð      2ffSfQfVfWf   ff   2fff   ff3 7thf;|uf;Du 7f   f   f30f\0fy   f3f3Ҍff0f   f3f30f   f   2f;Tuf3ҝff_f^fYf[  (             b                           IFt1vT"|} Pa>c(^)|'6CrT[Jy-Awg(^&1>G?D&W,ҷEVrfz*UqF;%d%Ev4\ω7,7C3KS4.HɸaD)c%O?+Ǌj&j(@GNpQрOXNqKa
Ԍ02S<{{D&/	5e	mduNto@mbMɡ{ǎWN_ƭd\?*]n"P1 ywvj: TY,(.TjLy}Rs bL43E
䎫j,ƭ<Ǵ2+vAt|3o;n6}70+=辸iG,N@g!CVO(:5o ]]`c:=cވ{>Oۨyh)U?ZH-9Ć@FAnr'Д/K!t_3/Zg?5bmR!`
9YG&$iV3P#Dֺe2HRk]>
xQgH]<C6<<g7zwɽ)$@$^ :Dǉ/' ZOVAliB-Zfa+y\*Af;
 }hw$;43B"qdV)]VH11s.4]F TJ/{- ~V&xm }
oל%adE}ކsg39Vmr`d;Ze]$y+U6~%y-	+|AX6RT[Mf+L*ޘRnhB׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE       "  tm4                           f~94R8Dsx^A`96b@kpgs9ԏS\})(d<f*̛(m:FW:9DT!zcUDh֏
^3,Τ\
8f	߈|	*Jn̄2CC~pF[>%/\tVyGۯ*7$ AkoxLŕ[Z\J	|Э0a!QQׅa_FH8qa]Oۂu秈]|xڵd|$SN(Et+3׫[]bKY/n<;ѧ҄Wkz㫷
Yvdo%9fmTL	nIxƼ29MEi!jJ-r%vx~
mwǖ)fL"^g{[AUOP(IcKۆ^Va_;2ʠŷSh)`cǥm'dN5~ù+8a!"LF{M怂#,뷿Bh.6DR
{h;M/cTDގ7գLloŤة2χn]*ѡ8CL/g1+f3#i%co Bvl7_BEt.Zx~i$/ftW
P/64hFC	%! G Q2;( аrYɵ2/nxs^)4흥 94JIn8-z9N/fj۽_pz}[;bï"8?9;U	NZK;#7-oښm׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   	    	  !}                           eoղGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:׃FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm⽻]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbܟka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlٱwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋬ׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         G                           
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_œ%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzմTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4҉;jQ0\ǁK15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwyꤎkK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]hÔ9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC ÞUEu;iTBܐx/Dz1J8pQ?h
\Q	ʴL
mvfCG=;k׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE   E    	  B                          ŋ>ui |\ț$qixD\*e fqQgtGY{Ϸ1dkGõ@UWNILr1[*m>Dxx,^x

A1Gt.N~CRC+I^ka7*,
"4ţg<Y;kwǷʣUQ2S	YqQڻAJm܁@;n|x]s1l|"V[MՌ^GL$'K#A?T)T'Zohmm?FKɀJ)(iYsC\^|wL$BmX:x.*١rM ѽ9$& CD+lEUӇ:$2% %Q]9f|S[W%Rǆz+/TFVkۊ20Hڌ@V)!dWY*ŉG3
U^`jɕuB*zz$Gp̀SO'.	텧G`r]}{t`w}سOgD,6c#^1ZȜ-N0-Ī)yR9#l#dEvhd S`S-{Hw\u]T\-J{]Gs] GUNH4-zKr'#oRh/Ie-
XJmVp82MuxQ&HFOeg0H&Eۆys/Gȵ}C 7n5?:çXR
	=Mg+Eح@̱C`sJjU׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE         &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE      f fff戰䈽!   戰K  `  戰   戰䈻              u׾$   $   u戰f @KC8BBaaff fKua$aff fKuf f u           ܂  Ӌ  ܂      ܂  ܂  VQN   `  ܂  aQ  J   a    ܂  Y^ð   ܂  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP    @t
	 %"XP 
   `"	X                                              `   Y$ffY$
0ظ   Y$ffY$
ЊZ   $ff$
3ظ   $ff$
Њ_vaÐ            þ P                                  t.'4/:@Fw4慰 .fˋf   ú$fӃЋf.#W.W.fˋ؋f   úfӃËf˃⚰Lf   
ú$fӃĊÆ@  ؋f  úfӃËָB  ؋f  úfӃËְmf   
ú$fӃĊÀu$Sf  
ú$fӃø a؋f  úfӃËָ  ؋f  úfӃËְLf   
ú$fӃĊÆ$ Q.fˋf   ú$fӃЋf.#W.W.fˋ؋f   úfӃËf˃⚸ f   ú$fӃЋÃ uOp f   ú$fӃЋÁ p ؋f   úfӃËָ f   ú$fӃЋÃ uN f   ú$fӃЋÃ⿸ ؋f   úfӃËLf   
ú$fӃĊÆXf  
ú$fӃĊÆ$| D $Lf   
ú$fӃĊÆ$of   
ú$fӃĊÀƃfʺ2fȱ ..'8v.G 
.Ŋ.'8v.G 
.f.'8v.G
ȺjfЋ.Ŋ.'8v.G
ȋѸ ؋f   úfӃËff3r.< ;t	f.Fи ؋f   úfӃËf.Ffи ؋f   úfӃËf.FfЃ@ ؋f   úfӃËf.Fи ؋f   úfӃËfff   
t@fغ  ff% f؀f   ttf   ff% f;rLf   
ú$fӃĊÆ f  
ú$fӃð f  
ú$fӃð f  
ú$fӃð f  
ú$fӃð f  
ú$fӃðpf   
ú$fӃĊÆ$?qf   
ú$fӃĊÆ$f   
t@fغ  ff% f؀f   ttf   ff% f;rpf   
ú$fӃĊÆf   
t@fغ  ff% f؀f   ttf   ff% f;rpf   
ú$fӃĊÆ@f   
t@fغ  ff% f؀f   ttf   ff% f;rqf   
ú$fӃĊÆf   
t@fغ  ff% f؀f   ttf   ff% f;r󰀴3f  
ú$fӃð3f  
ú$fӃð3f  
ú$fӃð3f  
ú$fӃð f  
ú$fӃðLf   
ú$fӃĊÆ$Ǌf   
ú$fӃù .fˋf   ú$fӃЋf.#W.W.fˋ؋f   úfӃËf˃⚋ϊ2.# ո ؋f   úfӃËֺ   ؋f   úfӃËִۋf   
ú$fӃðf   
ú$fӃĊtٴ ۋf   
ú$fӃú
 
ո ؋f   úfӃËֺ

ո ؋f   úfӃËִۋf   
ú$fӃðf   
ú$fӃĊtٴ ۋf   
ú$fӃú
 
ո ؋f   úfӃËִۋf   
ú$fӃðf   
ú$fӃĊtٴۋf   
ú$fӃfʇո ؋f   úfӃËևffϋո ؋f   úfӃËfո ؋f   úfӃËfffűfff2ffȋи ؋f   úfӃËff ؋f   úfӃËf< x( Px <Zx(( -<KZi
 (2<F %-4:JZZ O  O  O  O  O  O   O     P `0p?/`?f̼Yff̼ ff̼ ff̼gff̼ff̼ff̼*ff̼6Ef22ɵԼI < Լ_rr< u~Լqr`<@ul	ԼrN<uwZԼr<<uHԼ}r*$u4Լir<w"ʀta ΀f33 ft`յԼ r8vеԼr8vfյԼ4r8vеԼHr8vffrf3f3 t0
Լr"$~t2t@ trf3f3  f3ҲԼJrnfɊf$еԼ0rTfɊf$ЀrCw>fft:fɊfɀt+fɊfr
w
fʀf͋ffNf    Լr f$ش..:	~.	fԼ_ԊfԼKԊfԼ7r>f .: .: 
s?"܆ˆf"fFff̼O7ft0f̼]ff̼isff̼u.ff̼fʸ ؋f   úfӃËָ ؋f   úfӃËָ  ؋f   úfӃËָ  0؋f   úfӃË֋33f3gf&UUgf&GUUgf&f   f=UUu&gf&UUgf&GUUgf&f=UUuf   rΊ3fʸ   ؋f   úfӃËֺ  ؋f   úfӃËָ   ؋f   úfӃËֺ  ؋f   úfӃËfʎԼf 2t3 fʸ  ؋f   úfӃË3Ҹ ؋f   úfӃËָ  ؋f   úfӃËֺ ؋f   úfӃËfʎԼ42tff   gf&ZZgf&    UUgf&f=ZZtf=UUt6 f   gf&ZZgf&    UUgf&f=ZZtpf=UUtlbf   gf&ZZgf&    UUgf&f=ZZtAf=UUu1f   gf&ZZgf&    UUgf&f=ZZtf=UUt2fˎ d <t벺 d <t` d <t. d  `u_<t d <t`fˋ䣡 T X   Z    \    ^         @          0             Д     Ԝ  O   L  TV B dF  ?L
h  ?p!r t  v     |    p  r  R          D          @8     D  !        @8     D           @8     D     ?     l8     D  `        D8     D          X8     D  D        `8     E  b!      x8     F  0n      |8     D  2         P8     D  @        p8     D            t8     D            H8     D            H8     D            H8     D            H8     D            t8     D           t8     D           8     D           8     E  a         8     F          X8     D           |8     D          t8     D            p8     D           ؈     D  @              E                E                D  F         Ј     D                D                D                 D                D  <             F               E               D           Ĉ     D                D               D                 E              D                D          t     D         p  Q       p  #       p         q         p  `       q         p  a       q         p  p       q          p         q          p  0       q         p         .   U       .   "       /           .   #       /           .   $       /          .          /          .   `       /           .   a       /   p       .   b       /           .   c       /   r       .   p       /          .          /           .   0       /          .          /   	       .   `       /           .   a       /   N       .   0       /          .          N          DO           <Ff(
f%f
ff 8 $f$
а@f 8 $f$
аf 8 $f$
аaf  $f$
и f 8 $f$
аf 8 $f$
аf 8 G$fG$
аf   L$fL$
f  @ff  ff   m$fm$
$uf  S$fS$
аf  ffa ff  X$fX$
$|f
   
t@fغ  ff% f؀f   ttf   ff% f;rDf
   
t@fغ  ff% f؀f   ttf   ff% f;r$f  ff    ff  $f$
а f   p$fp$
%?f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
f   
t@fغ  ff% f؀f   ttf   ff% f;rf   p$fp$
@f
   
t@fغ  ff% f؀f   ttf   ff% f;rf   q$fq$
f
   
t@fغ  ff% f؀f   ttf   ff% f;rf  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а3f  $f$
а f   L$fL$
$f7ff. f"   f%" 3f f  gf   b$fb$
Ћfgf   $f$
Ћfgff   ffffgff   ĺffffgff   Ⱥffffgff   кffffgff   Ժffffgff   ffffgf   $f$
Њfgfff   غffffgfff   f   pfffff   $f$
f   W$fW$
f   $f$
и0f   W$fW$
$f   i$fi$
$Hf f   f  $f$
=  f  $f$
и f  $f$
аf 8 $f$
а0% = uL  u7U../0./. d< ud< t<t
u<tfff D$fD$
2撰<uf2f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  ff0fA0fl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0	 f%"pQ#"pB$#pB$pB`pBapB0pBpB`pBapxBpB$0pBp3ۋӊ+;wf  $f$
= tOf 8 $f$
аU..	/0. /.UN&NN~O'NN ON                              '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 戰䈽Affffff찴f)f3
2fCfM fYfcifuf fpf fXffBfh˰f/f f"f  f.f. f"  ؎ f%" 3؎徰ٹ -pqt  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I        05/07/04BSA  U<ps                 d$ $PnP       o              
Copyright (C) 1997-2000  Intel Corporation
 Intel CorporationIntel Base-Code, PXE-2.1 (build 082j) $    I $BC$+   @:^   
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 thP~SwQpRibWZT1
-AX- -BX- -CX- -DX- -DS- -ES-:-DI- -SS-:-SP-
 ÜPh)tX
Waiting...               
  t^@:^ 
h h@ UfPfSfQfRfVv&  &\f?UNDIt?h_& o
PXE-EC4: UNDI ROM ID structure was not found. Gs<hk& '
PXE-EC5: UNDI ROM ID structure is invalid. Pj Sj < uf. fGf;sff. ff. ffGffGff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZNffW.; s. @ 6& ԋfPfSfWfUj j fj fj RfRVQ@ & v &D6E&D6E&D6E&D6E&D
6E
fFffЉVf. ffЉVf. ff6UfGff6UWhTw
˃f6UfVf6UfV
Z cv & tl tc" tZK tQ tHh]Rjh*
PXE-E09: Unexpected UNDI loader error.  Status ==  P
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>  u=h$v & 
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sLh\Pv &  r
PXE-E20: BIOS extended memory copy error.  AH ==  . f.f^f. *rv&D &L. &;D&s&D&fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(Dv
F&DF&D&DPj Vj &(D	v &D6E&D6E&D6E&D6E&D
6E
Wj v&\Z
  Wjuv&\Z Wjvv&\Z  t  uj@ H FF  RWjv&\Z  t{Xt&t
 u tfS^
G HF+F)F[fSVWF  6	fff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 v&< f^fZfYf[fX  t ]˜= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]r.>  u	  . 	Pfj j .(   fZfYf[h
1P<Xt/
Press <Esc> to abort ROM initialization... fPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j V< uf>  tf . fSfQfR. . .2 <t8hq
PXE-E06: Option ROM requires DDIM support. f    ff    .  f    ff  fRjfjf. ffPj hfQ˃ffu0h;fZf    {
Invalid PMM function number. f u)hqfZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.. Pj h j .( . . tf.>   r
.                  blksize tsize                                         U ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j    |      
CLIENT MAC ADDR:  
  PXENV+     GUID:   
DHCP. PXEClient:Arch:00000:UNDI:000000  PXEClient CLIENT IP:    MASK:   
DHCP IP:    PROXY IP:     DHCP IP:  
GATEWAY IP: MD  BD  UD  
Auto-select:
      
BOOT SERVER IP:    (  )   
Auto-select:
                                                                                                -->  MTFTP 
PXE-T :   TFTP Aborted  ProxyDHCP service did not reply to request on port 4011.  Client could not locate a secure server Missing MTFTP server IP address BIS bad entry structure checksum  BIS get signature information failed  BIS free memory failed  BIS get boot object authorization check flag failed BIS shutdown failed BIS initialization failed BIS image/credential validation failed  BIS integrity check failed  Network boot canceled by keystroke  ARP timeout TFTP open timeout TFTP Error - File Not found TFTP Error - Access Violation Error received from TFTP server TFTP unknown opcode TFTP read timeout TFTP cannot open connection TFTP cannot read from connection  No DHCP or proxyDHCP offers were received.  proxyDHCP offers were received.  No DHCP offers were received.  No boot filename received Invalid UNDI API function number  MTFTP cannot initialize NIC for multicast Error while initializing the NIC  Error while initializing the PHY  Error while reading the configuration Data  Error while reading the initialization data Invalid MAC address Invalid EEPROM checksum Error while setting interrupt TFTP too many packages  TFTP packet size is invalid Media test failure, check cable NBP is too big to fit in free base memory Bad or missing discovery server list  Bad or missing multicast discovery address  Bad or missing PXE menu and/or prompt information Could not locate boot server  Invalid state returned from UNDI  PXE-  Invalid message code.
   /-\|            
SM/DMI BIOS functions needed.
 _UUID_  
									       
      
 f~ u ːf~ u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- r- v뾐:: 1LP3 뫋F fv?FF^&)~!~ofv'ҐfvȐfv뾐fv-Fu
hx9 i[F 롐fvFth I[fv[fvmofvАfvƐfvA뼐fv벐fv=fv?	3=1 tw5-  = }.f             $=q )w-2 tHt-= 7-s HHH!3  F  
9  >9 t  JLfFf99f2hP99@t{<IutyIu^h
JuShRF   }R^
RF9*9Fr䡸93MuIun>huYu
"Ft1J9NMqIH~ t~tEVjOhRF FP)Fu9Fu9R 9뮐U>9 t>P3 u>: t  II9Lt9 9 9^&9   V3Y-  +ҊԊ*҉FVFP+$FVu3^Ã>3 t3+ҊԊ*ң(3*3(h2fj vPfj  E/t	f(3    7f(3*3f9FsEy WN뜐T3 fvfvh2fj h96:6:6636H3 |3O8tְE뽐>2u}(3*3% (3ҀĀ FVf(3fFGT3 fFf+(3fPfvh2fj fj fj fj FV37ufvfvf6(3 |K
u	E" 9Uhx9bWFFV^f& |  PVr$=NVu^F^f&G(fFXfv^^  ^&G- r- v  &iGNF^& u*&G^& u=& u6F&GF^&G#&r&G^f&OfQfv&GU3   >9 u  >: t  >P3 t  G|F9f&G    f9  fP2 ~Uf9H fP2 mUf9@ fP2 \Uf9P fP2 KU9S*&GP9&(G9&G0FF  FF9&9G6 fNfNfQhhHT7Uuh:T^*&O;~S*\P
u3^&G^&G^&G^&G^&G^&G^&G$&G
  &G^S*&G
P^&(G	fF^f&G9(It  3!V;.33   ^&  t&  }?  >9 u  >: t  >P3 t  Eu֋FV RPF RPF
 RPF RP^3& 2),u: >: u  3*E3:   >9 u  >: u  >P3 t  fF fP^f&OfQ|1F^&G  F-tHHu9  5  F^&G3   ^& >9 u  >: t  >P3 t  Cu^f& GP P P P& & & & & & 33^&^&Fuf(3f& 3 f&Ǉ     F   >9 u  >: t  >P3 t  ?Cu֋FV RPF RPF
 RPfj E S3ҳn*F2CF^&~ uf(3^f& ^f&Ǉ     F=3 =2 }
c F -6 tHHtKU>9 u  >: t  >P3 t  Bu47f^f&GP33 >9 u  >: t  >P3 u  B3P3   >9 u  >: t  >P3 u  FN~ tIFV RPF RPF RPF
 RP^f&OfQ&G9Ft^&G3 F^&Gv  F>9 u  >: t  >P3 u  ^&
 uQ&G
^f&OfQGPGP&G&W26uF3 F  fF   fF   f+fFfFfFfFfF$mIfjFPvGRPfj*F $KI~ t
E! FËFFtE# fFf Ð  fF   ffF$ IfjFP	GRPfj*F $H~ tE! 2FÐFFtE$ 萸 Ð  fF   ffF$HfjFPFRPfj*F $xH~ tE! EÐFFtE% f~ t 3  RPfF   ffFfFfF$ HfjFP)FRPfj*F $G~ tE! REÐFFtE& 萸 Ð  fF   ffF$GfjFPERPfj
*F $G~ tE! DÐFFtE' fvFP|E L  F+;Vr
w;FvFFF3fvh3HE^KFV "  RPfF    ffFfFfFfFfFfFfFfFfFfFﾭfF    $FfjFPDRPfj*F޸ $F~ tE! D f~ uf~ t  3 WV2   It2^_2&sE( C^_ÐS*&G7H
u⸀22f   ftrHuVHu0HuHu 2^_  RPKHu0fvfvfvFVFHtF  ~u  3   SRPVf~ tDt@u2^ F+v
rD7D0^N&FN+FFNu^ 
  SRPWVF`4^ht32 Kt3R3u39v3h3h
 Kf2fx3 L|3^f&cSc>
  t^&G^_ FHtHHt- tI- tJ-
 tE~3  ^& 5F^& FFHt1HHq- t- c-
 \|3  ^f&f3뷐^& F~u!^& 2F^& F^f&^f& ~ ^& 7FvF^& F^& F^& F^& F^& F^& F^& F^& 
F^& F^& F^& F^& F^& +F^& 6F^& <F^& CF^& F^& F^& F^& F^& F^& F^& F^& F*F^^&^& 9F^& F^& F-  -  -
 t^& ^& Fu{>  t4  h"(CcG			th&Cf6	Ch. Cf>	 t.^& aF^& F^&  FfFfPf6	 AI~u(^& 6F^& F^f&^f& a^& ]F^& FGFJ^& ^& ^F^& F^& F9&_&G	^*& FF9&_&G^& FF^& <F^&  FfFfPh6  HfF fPǺ
  /fF fPF
  fF fPF
   ~ ^& +F^F& ^& GF>  t'^& F^F& ^F& F^&-^& F^F& f% !I^& ^&>2uM^& F^3& ^& FF  !^33H^& &PF39F|^& F^&^& ^_ .@f2fj fj  3Qf    f2f88ht3fj h: C$,h:ht3GUPV3^*& BFfFV^f&G<^&Ǉ  ofFV^f&G@fFV^f&GD̐fFV^f&GH븐fFV^f&GL뤐fFV^f&GP^&Ǉ  ^&Ǉ   fFV^f&GT֐fFV^f&GXfFV^f&G\뮐fFV^f&G`뚐fFV^f&Gh^&Ǉ  ^&Ǉ  ^&_h&u 3^& cfFV^f&Gd= )= wA.JNl=
 k- &H5HD- t-; ^- t^*&@ 9vO^   PV3^*& =4 CtHtzHHtN-
  -  FfF^f&GfF^f&G^&_f&G^f&GpdÌ^&G&W^&_f&G^f&Gx;Ì^&&W^&f&G^f&GtÌ^&G&WfF^f&G$^&_$&	r"^f&G$ fPhX	 DuF F  F*^&  Ì^&G&W
^Sf&G fP&_*&G~Ì^&G&WjfF^f&G,h^f&G, fP&_,*&G@C^&_,&_*^&G|&_~-5 {H- 	- t- t:^*&@ 9v^f& tf&$ u&  u
& & ^ U^&?t3 f2f&9Guf& cScuf&  t؍GPh
9*Cuø    WV3F Dvvv^&7Vj
 & RPfXfYffff88 9 7:fj FPfj fj j 3Pe+thBtix  RPhVBix  RPix RPT
ix &n tF ^&ix&p tF F Fix=zP^&7~ u~ t	^_ 3^_ UFVl RPFp RP 332ht3fj h: C$' Ȏ  ǆr Dfj
 & RPfXfYffff77 8 8fj rPfj fj j 3P**thtȍtPhBf~ t^&uf~  tfF^f&9GlufFf&9Gpuh&$h@fFffFf2  3 UhfFp fP
 3
21ht3fj fFp fP$x& Ȏ  fj
 & RPfXfYffff66 7 7ǆr  hrPfj fj j 3P)t̋r- Dt-guhttPh)f~ tf~ ufF^f&9Gpuh)h?  3 Ȍ  PV3F}Pirx  RPirx  RPtʍtPh)
>2u~ u ^ÍtPirx  RPy
FPFP 3`0$0ht3fj FP C$%3^  RPVF  ivx &t u-FF9F"ivx &n u3FFF>2u
ivx&v uF ivx &p tivx&r ivx &p uF  FF9F}.ivx&n tivx&t tۃ>2u
ivx&v u9F=F Pivx &p "ivxf&h F  FF9F}
ivx&n t9F-ivx &p F  FF9F}ivx&n tivx&r u9F ivx &r ivx&j&hyivx&t {ivx &p XF  FF9F}5ivx&n tivx&r tivxf&h tivx&t uF9FH= .> zHivx &l t=h&$iFxP<ivx f&Xfivxf&`f2	 9f    f2fiFxPiFx  RP_ivx f&\&^fFHHHHHtHtiiFx P 3ivx f& t&ivxf& fPivx&Ę&G*3Fh92 ;F  h92 ;FF9F ivx &n tivx&r uiFx P Y3ivx &&t&ivxf& fPivx&Ę&G*3iFx   RP 3ivx f& t&ivxf& fPivx&Ę&G*2F F9F~  h)h&$: iFx P 2ivx &&t&ivxf& fPivx&Ę&G*K2iFx   RP 32ivx &&divxf& fPivx&Ę&G*1;~ t3h)iFx  RP9ivx &\&^ ^Ð3^Ð  RPFFF  .;3f~tf~ u
F C D~ r~ rF  hFP^^ V~ Cu~3*=*ht3fj FPF$2F   SRPWVFF  fj
 & RPfXfYffff*/3=0 0F  fj FPfj fj j 3P!kF- Dt-g\hOiFx  RPh8iFx  RPiFx RPivx &ĘT&uF Fivx &ĘT&9G F9ivx &ĘT&O#N; ~ taivx &R&P ivx&ĘP&G&WI9FVF  F39FsF^93u93u39Ft[~ tHF  FF9Fs-^vi~x ؎Ff& &P f&;\uȋF9Ft
FiFx=zs	-`F^_ V6hb0h1hn0h21f> t&ff9thx0h0h0hh0h0f>9 t@3f9 t1ƹ +uhc0 R09P0 @0Frh?0^Ð
  WVF9*f|
f2f2f: Dh:2[6f    ffFdF 5 9F~F !uxF ukF u^9F~
F uLF u?  F~}/^ۋ  FPFPtЋF g~ ~ u
FQ ^_ËF9FuFR ^_ÐFS 3F9v~!ix &n uix&p tFU 9vu1~ t+3F9v~!ix &n tix&p uFU 9vt1ix f&Xfixf&`f2ixf&\fFF^_F3^_ÐUfv2 4^f& u 3^& fvfF fPa^f& t&_&GtfvfF, fP@ 8^f& t!&_&GtfvfFl fP (^f&| u^&l tÌl ^&G|&W~^f&G^f&Gl^f&p u^f&G^f&Gp^f&x u^f&G^f&Gx^f& u 3&  Ȍ  >2u4f~ t-tPh-~ uEz k*3 fF^f&tPh)f&)f2fuFFtfFf2f~ t^&G&WE{ 륐399f~ t
^&Gu43:f~ t^&G\43:FFu	63  ^&u&G	*&G+4*63FFuH3  ^&u&G	*&G3*H3f~ u39,3^&G3,3^&G39f~ t^&u
&G333  FV   RP>2u 3F     > w$fvFV;fvVF^Ftʃ~  >2tOh)f6 1f  fP ) f& tf& fP&ğ&G*z)F h-f6 1 f&\fF     > w&fvF3fj F33
tF T3   PVf+fFFfF^ğ
&Fu^ >2uNF  F	9FsA^ğ
&^ğ	&9uً^ğ	*&GF^f	 fF~ u$^&GR&GPt&_P&GtEw T'qF ^f&P t&_P&GtF  ~ tz^&_Tf&GfFm/h)FP
*^&_P&Gt(fvfv^ğ
F&Ft(^ fvfj ^ğ
3&F F ^f&P t&_P&GtF  ~ thfF.h4)^&_P&Gt(fvfv^ğ
F&/Ft&^ fvfj ^ğ
3&	Fu^F  FF9FsIb.h(FFVRP(^vf&0fj ^ğ
3&Ft^ 3^ USRPf`~^NvVFn
fa
 Ȋ WVF  ^&  hPh&$Ph)h^V6  u^V6  u	3^_ ~ ud t^f&P t&_P&GtfX u	   
  ^f&P  &_P&Guy^f&T u
v ^_ &_Tf&t^&_Tf& t^&_Tf&   v^&_T& wr^&_P&Gt@^f&X t&&_X&s$^&_P&Gt^f&X uw ^_  
 ^f&X thF  =^&GX&WZF 				^&_Xv&@* F^&_X*&G;Fw^&_X&G;F~^f&\ tf&` u
t ^_ &_`& t^&_\&r3R
FN^&G\&W^F R


R
ğ
& tR
ğ
*&G FR
^&_\*&G;Fw^&_`&8g h%3
*&G;v
&@%FFrh%3Fs
f9 ufvF@?Ht'&+h%h&)%s[f9 tNEx ^_ f9 t3+ǹ +uh;% *%9Po% %Frh%h
%*F  ~Is)^&_`v& $F^&_`*&GH;Fw^&_`&uh$ ǆ  ^&_`*&Gfǆl @ Ɔh$2	&2&%hn$%tO%= Btw3-t-,u^& Iǆ  t#)F  F  - [t- 
t- 
tאĞ&8t&
uu@)h#ǆ  
*&G;v&@#Frh# +G%
h #ǆ  ^ğ
*&G;v"^ğ
& @#FrȋF9vFh*#FR
9FrF
2$*+R
FvЎf   f^ğ
*&GhXfhp  j VV33Q^f
 fPfh  p VV3 )vPF+- Pfh  p VV3 F#=.t = t -t-t^& )~ tNh fh  j V33f
 fPfh   V3 vPF+- Pfh   V3UF+R
=KF{~ =F  kF+R
='R
HFS-	t-
- = K-w- 9t-
t- - Mt- t- t
  SRPV>63 u63$ >T3 u9 >T3آ9>
 tFu&>T3^P ^f&f2f~ u	24
^&&W99t3   F  ^v& ވv3^Fv&8 u^fǇv3octeF^Ǉv3t FF9~ EuEf~ t>^&? ~4Fv3Ph $&h %@FFv3P^&FF9~ t?f(3    Fv3Ph  %h  %@F^Ƈv30F^Ƈv3 FF9>T3 u
'@'F9N3  J3  63L3>T3 u
z'@v'>T3 t	t(>9 t!ht3h9h2F9t8 >
 tFu.bL3 z>T3  fj fj fj fj j 3P ff92uvff9u:9u1>T3  F&&;w&&; f9f9u&:9tfj fj fj fj j 3Pu|J>T3 t>9 u963L3J363L3J3J3= uE2 2 >T3 >J3~ EF EN3 &- toHHt	HZ>
 t(~ u"hdFhlhh>u; \>u< O>u	= ^ 6 ^ ~ t4ft3   hx3hp
 !$ht3h9h2N3 	> ^ >T3 uE%+Ht
N3  >T3 tff9u9u9ԡ%- F99F~L~~E? k? ^ >T3 t>2 uF9F92  :?h2 >#>T3 u3^ ~ uf~ _^&? SF   f~ tY^&? ~OFPh *u<h )"@FFPZ=~ Et9느9Ff=E  v~ t`FPh  uMh  !@FFPY(3*3ft3   hx3hp
 y"ht3h9h2N3 NFP!@F- 9F}FPi!@F- 9Fft3   ht3h9h2N3 -^    v9t3 v39 >|Y$#^&- v9tf~ tfvl#PQv9!>9 tht3h9h2N39w  v9 J3  >43 t	43L3L3$ L3| >T3 tQfj fj fj fj j 3P%
tfff92u[ff9u9 f9f9u::9/hhfj fj j 3P	t92u9 3t\i>43 u>9 u L3J3J3= uE5 i ht3h9h2N39f뻁> >9 t!+H>T3 t-ff9u"9u>9 u>9N3      Ð
  P3FFFF 1^*䊇N t~ uFFFFF:9FvȋF+F+2@Ffj
 fRPfXfYffffF~ tF9FwF  ^)FXF9Fv	F+FFfj
F RPfXfYffff;Fs"fj
F RPfXfYffffF~#vF#F  SRP9 T3 f+f(3Pj
 fRPfXfYffff63fj
 fRPfXfYffffH3f~ tR^f&? tHf&f9M}b  T32  F
:9 F :?h2 8T3 FF E43  f9f"   fFfFfFfvfvfvFPF32NFt3-6 t&- |p- ~>T3 tNF ET3 봐F FPfj F}$>T3 u9  >43 t43  9v43  9"T3*>T3 199F~F92  :?h2 ?~  ^*䊇N  f9fPFHj PfXfYfffȋFڙډN^:9FwFV;r
w;v:  f9fPFHj PfXfYffFfFfvF@+؋FVt   N^299F}tfFf(3~ ~F~ uFH::92tJFV43?fFf(3f(3f9FKfvF@+؋FVBnf9fF>9 t
99F/>T3 t:92T3 2  E
3 UVVv^$&=  t)ArZw <Ar<Zw FC:t^^ ^3^   VfF    & *N-0 FF^v&8 t&80r&89v3^ F^   WVf+fFF0& *-0 N^ӉFVF^v&8 t&80r&89v3^_ FV^_   VF  F'F=F~F
u~ tF0^v& FFNV
 FF~ u^v&  F@^ h28hV32,V3X3EY3 Z3@03\3`3a3b3  r3  Ð  RPVl3Fn3 Ip3r3  ff9^f&f99p399F9p399  fv9F2r3ffd3^f&fh3p3 Z3b3  0303\3^3  X3
 b3V3^f&? tf&?u	W3 &?r"&?wh83&&W  ^ f~ t
^f&? uhfvfj FVFFV
22##^&&w#2#62;u5;u122##^&&w#2#62;u;uf&    ^f&? ufvSh83%FNW3 Z3F99F$fFfF^f&? "f&?9- FfF- F^3  F fZ3b3  X3
 o
b3hV3fvh83V 	FF- FFFOF ^3F Z3b3  X3
 
b3hV3fvh83 V	FFFFF+F;FwF^3F+F Z3b3  X3
 b3hV3fvh83V+V hV3fvh83 V'	F^   Pf+fFFFFFf>6 tKa;8rBw;6v:>9 t'F
?+ڃ6 689  
f6    hu~t	F~dr3 >uff9ú> uh뼐>uF  
 ;Fu$<uf9f9t
f>  u>uM% Ht H`f9f9Sf+f69Ff>  8N
?+ڃ$>f~ t*ffF^&G&t&9&9WF%  F~tu9Fu9Ftf~ ~ FffF~  ff9ff9999999~ u-F9  t =th1- 9]
;F'f~ t7F^&? t(&9t#F9Fff9FWf~ tf^f&f~ t	^&- F~ u~  - F~ uF9FnfvhnFF;FfFFfPhF
FFF9FO9F9  t<=t7fv9F[	;F? f~ tF9FvFfvhFf~ t^f&? ufFf&f~ t^&? uF&F   RPF  6^&&Wk^9u9ukFPfvF= F~s
k^ uhh? kFPfvFkFPfvFk^Ƈ Uh92 99 h9h
9*h9fF
 fP9*S3&R39999 99 ff9^f&Gf9h9fj G
P ` 
  F  :^&&Wk^9u"9ufvkFP9*3 F~sk^ uh92 99h9h
9*ff9^f&f9S3&R39999 99 F  F	 h9fj fj  FFt$fFF= uΰE 2Fz  h
=tĀ>
u>
 uf
^f&9ufvh
9*fvfv9* F>T3  h2E @0303@   f9fff  f9f 0303 
 hfj h:3Mh:99uh.:  th:h.:!tEb m  6893Ð  FPj9&_t Ð3  FPj9&_t Ð  fF    FPj9&_u6~Ku+~Tu%~ uEa : Ð~Bu~Pu
 3Ð~tްEVԐ  FPj9&_t ÐȈ  fǆz   ǆ~  xPj9&_t ÐȈ  fǆz   ǆ~ FPfv FPfv xPj9&_t    SQ @@@@;؋sY[FPj9&_t 2  FPj9&_u0Fآ9F֣R3Fԣ9Fң9fvFP9*3     fv  `  RPFFV؋F6F FFF~ uF  F FFFfFfFċFFFF^&F&uFfF    F FFFFFPj9&_t    RPFVFPj9&_ufvFP %
3          .&NXf* PWQRU>   @  h> j>9&] us>@ ul>L |i>L |b>L w[>* L &D F +ȋѽ  ( B +V6H ^;s#  u>@ u
3ԡ( ]ZY_3 ~W>   @  h> j>9&]_f`.&N>9tJ.   0  h. j9&_ u0  t9а r   fa.>*N t&.(N! 9r & ӄt"Qf.>(N u8Pwh3Ɏظ O&.(N&G.*N[i Y3YÜSQ3ێËȋf.>(N tFwhf Of&9tY[9f.(Nf&I f.(N    3PQRv ! ˃ӈ&   .,N"X tZYXPQRv ! ˃.",N  
X tZYXUV3 Ӌ^]UV
 3P Yv  t2؃ Ӌ^]UVW  _^]Q  2sYÀ>[
 u[
Z
X
   Ð3ÐUPFX
uZ
5T
V
Z
 ÐX
Ð  t À>Z
 uFV+T
V
FVfT
f9FsfFf+T
f  fFfFfT
X
+9Vwr9FwF)X
fFfT
3ÐZ
 댐  RP>
 tZFh FFhlF* %F^9N u^P mhFNuhUÐ  PV>
 t7$
F 8Ft)F ~ t$ $* ^ÐU+ҋFF    PRt$TEVh ?	-t-,t  PWVf~  ~  FN ^~&&Q#2#222##;u;u3Fsf9 u^&&Q99^~&&Q;9u;9uo^_   V^f&f#2fF^f&f#2f;Ftif~ u99^ 3FsL2499u99t4^&&W99u99uFs99^ 24^ UfSfQfR?f3^f^ff;sf;wf;rf;vf;s@fZfYf[] SQrY[ PS [XUFFt%&?	u
h*&F^&? u UPF  ^F&*: .^F&*' .^F&* .q^*&    P
 +tF
 +0>U^&p^&Gf^&G\^&GR 
^&GC^&G9 ^&G*^&G  ^&G^&G	 ^&G
^&G^&G^&G
^&G^&G u32SQRu	s22ZY[SQRu	s22ZY[SQPRs2ZXPRZXY[  PF 
^F& FFNuF   2*&GÉF&? u2*&G F^&? uF^&? uFF+2u @tHH  \
  ^
\
t\
f&Gf`
&Gf
&Gd
-\
  ^
\
tk\
f&Gf`
&Gf
d
 @h
  d
td
d
37d
+2  2f
9h
u f>`
 uh4 áh
h
uf`
fj
+j
l
f6j
2+2 d
)3뫐URtt Ã>  u3u2&8Fu  V+ɉNFu3^^f&
 t&ws&G
&W&O
NF3^&GFF^&9wvfvhV u^&9GtS&G
uċFV^Ð  YVthn
V	 RP n
Ð t3Ð2&rhn
Ì UfVfWfSfQfRˋffV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F320fZfYf[f_f^] fSfQfVfWOfCORPfEDOMf    f    r'fCORPufEDOMuf=23AIt
f=46AIu   ff_f^fYf[h^_  F  f~ tF^F&? uF   fFV
fFFtf~ t^F&^F&
uFV   PfFV
fFFt*f~ t#~ ~Nt^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_   PWVF  ~vNtFxF F^_   PWVF  ~vNF&%G<ar<zw, arzw :wr F  FF^_ US^FGFGWwGg
oF GFGWFGOG2Cuԉ[3] [[2ҹ G;tWwGg
oogwww_ϒ  PFFV^*&'*&Oû@ &l &n f%  fPf  f#f#f#f#f#f#f#fXS@ & & [ÌUWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] UP$0F<9vFFÐSW ۋSR3.:uJGuZRƀt%@u20 tt
 t2r< u	ZXCu33_[ö΀Z^_SM_h^v_DMI_΀0}^a$PnP΀@^M_SYSID_  P3 f~ tf~ u'  f~ tܸ NtF&? tF^&^&+t   :  rX%  tK:  t
%  !&  $  s9r%  c6  r%  Z5  r5  rH6  9  L:   撰68BDD   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $ k  r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  L  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ X  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 2  X  f=$ J  f$ f$ f    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 7  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t:  $ =$ u	=$  w$ $       f$ $    7     f=$    f$ $ f     f=$    f$ $ wf$ u  9  bf=$ uXf$ $ $ Cf=$ u9f$ $  -  $ f$         f$ f=$ 	r	f$   N    s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz.ZXfPfRfx < fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytEsZ[Xfz.fyu&sZ[XSR=$ tO$ @
 fyf@t	s/fxfz,fyB@u	sfz.Z[                                   P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPUNNNO$ONNO$ O'NNO$O#NONX     lFpoypvp @  쨀tYRfZ @  쨀t	c7     fmRfZ     55 uf
-  
f
-        Q$  sYa  ޿`     t  r@Y8Y1  |  fCfz     3   r    F   r   rR   fPfSfRf*fff,fff*ff3f uUN0NONfOufZf[fXúvpf  ftRffZf=tPSQ   P  XsHuY[Xfu ff;uPSQRWf  	ufz  3f} f ff ff frf%fGff;wf} _ZY[X        =      5  =  (  QS$    P $ O r$$
t   $ uf f  [$  @$ <   br$
tf f  $  Sf  P[rKSUU*UUUUU*U[P$ p  r
<uf f  SQR      <`u
     wr   $ tZY[$  fPSUU*UUU[fX$    pr
8uf f            PSQRf8fff`f  N$ffN$
fffظ  Nf$fN$
ff        =$  u ZY[XPRSf8fff f  N$ffN$
fff  Nf$fN$
ff[ZXfP >>?<u>>?<t>>?tĀ fXð>>?      2ff fff戰䈽!@   戰O     戰   戰䈻  @      @      u׾C%   C%   u戰f @KC8BBaaff fKua$aff fKuf f u           Ԃ  Ӌ؂  Ԃ      PԂ  Ԃ  VQN   `  Ԃ  aQ  J   W  ܂  Ԃ  Y^ð   Ԃ  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP	 %"XP 
   `"	XË                                                    `   $ff$
$0ظ   $ff$
Њ   $ff$
$3ظ   $ff$
ЊvaÐ            f  f  f  f f f f TDDf f  D/f f  Ef f  Ef     fHt쨎t<w.$f ffH$tt
                                         F          <     D                 D                 D                 D          x0     D     ?     0     D                D                 D                 D                D                F          P     D  `              F      X     F          \     D                D                D  1              D                E  <             D                D               E  @             E                D           @     F             D                D          T     F               D               E                E                E                 F             D          @     D         F   9    E8        E0      `  .   U       .   "       /           .   #       /           .   $       /          .          /   	       .   `       /           .   a       /   >       .   0       /          .          >          ?                  E       <qfUMf%f  $f$
tPppqtAfNUff   $f $
и f  $f$
аf  X$fX$
и f  \$f\$
аfUff.~ f"   f%" 3f  f  gf. ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 pV	 f
   `"f  f3f30	f  f%
  u% t
 غf  fVfV|ff  fغf  f﹖ WfW@ff  f  gff   `ffffgf   p$fp$
Ћfgff   xffffgf   $f$
Ћfgf   $f$
Њfgf   $f$
Њf   $f$
Њfgf   ƺ$f$
Ћfgf   ĺ$f$
Ћfgf   $f$
Ћfgf   $f$
Њff|  fff
   fgNf   ~$f~$
Њgf   |$f|$
Њf   }$f}$
ЊgNf   $f$
Њf|  fff%ff   $f$
$@f_Yf   fzYff   =u;f3ffff%  0ff?  0fF  0ff  0=u f%  2f%0f  2f%0fY]ff  @$f@$
= u$<]2f7Zff  @$f@$
и f  D$fD$
аf  $f$
аf  $f$
и <fZf% = ufZf fZnf % ugf [TfU../0./.f([,f d< ufC[fd< t<t
u掰fk[f䎊f}[ff[f掺<uf[f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  fffl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0f    UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
~] t
^+;wUN&NNO'NN ONf  X$fX$
и f  \$f\$
а08$     3ذf f  fff   t! tf  tf f3f  f<vn2ɵ|^rVtT<tq^t`^t	ـݵ^u<t^g<Hu	ـ݀rfffffffs sf;uff
怼$_f   u3 F_u#;sݰ怼n_};tMfa   ufa   ufa  f   f_g.:vfG_q< tg.:vPfa   ufa   ufa  f   f	_6< tg.:vfG
` g.:v fGff   gf.f
f;w
fffb   ufa   ufa  `` g.:v0f   tff   g.:Gvfg.:GvdfG` g.:vfg.:GvBfG`kg.:vfg.:Gv!`L$< t<w=C  B  Ba  a  Kuas6 .va<tH$tt
䠢
t@fغ  ff% f؀f   ttf   ff% f;r       uu uuuu      `p`p2PP<xxF&<<-ZZ400$HH*~2nf|  fff
   fغf|  fff ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 b	 f
   `"f  f3f30	f  f%
  u% t
 غf  fbf)  fݺf  ff  fff$ ff$ fffݼRcfs_cy2sG怿scuŁ$<r
ffŰ怼cj怼cr~	f  ffs2fs+f`  fnf  f~fn2ff32  tkfsdf  f	f`  fff*	f  ffƊf+Ëff`  fffﰥ怊f   @tŀr&`f   $f$
2f3f怼d}f   @us	f   @ffsJfsC~f  ff`  fffÊffغf`  fff^efj(  def  fغf  ff  ef   tec怼e>f|  fff%fغf|  fff("f|  fff
    fغf|  ffff  f%غf  ff  fغf  ff  fغf  ff  fغf  ff  ff """ff  f""f  f"f  fJ	f  f3f  0 f%"	f3f`  ffff3f3gff  ff  ff    ff  f  f  f f  fغf  ff  f
 غf  ff  fغf  f	 f
   `"f  f3f30	f|  ffff    f|  fff~.u;t~.\`f   $f$
Њs.\nf   $f$
Њŀcwf   $f$
Њ݋侨~.uC;t.\pf   $f$
$
Êغf   $f$
Њ
i"%t8t9fص,i %t8t% صLif~f  f<vnf  fغf  f￤if   if;!  ifG!  ifq!  if!  if"  if"  if^$  if%  if>%  f  fغf  ff   $jUf  .f  f怿Jjf_   ff   f|  fffff|  ffff|  ffffff|  fffgff|  fffff f|  fffff   rff   gffgfff|  fffff@f|  fffgff|  fffff0f|  ffffff%   fgf.l  f   ffsff   gfff|  fffff f|  fffff   rff   gffgfff|  fffff`f|  fffgfgfgfgfgfgfgfgff|  fffff0f|  ffffff%   fgf.l  gfff|  fffffpf|  fffgf XV X     ff|  ffnf%fغf|  fffff3nnfp  fff%   tf   fnn tf   fnf`  f<  f3ff f@  ffLs  fȎgff   u	f   f~ffftf`  ff%   ffغf`  ff%   ff;uf`  fffff8 f%   ffff f@  ffLs  fȎgff   u	f   f~ffftf`  fff%  f*2ffغf`  ff%   ff;lf  f
 غf  ff  ff  fȺf  f	f  f3f  0 f%"	f`  f<  f3ff fLs  ff    tfL{  f   f    fHf3Ҽof   fHf3Ҽof   fHf3Ҽof    uf   fHozf   u
f   kf~fffSf`  ff%   ffغf`  ff%   ff;f`  fffff8f%   ffff fLs  ff    tfL{  f   f    fHf3Ҽp f   fHf3Ҽp f   fHf3Ҽpx f    uf   fHq] f   u
f   kf~fffSf`  fff%  f*2ffغf`  ff%   ff;	f|  fff5   fغf|  ffff   t]f    f2   qr ws < ur ws 3r ws 㹸f  q|f  f u	 f
   `"f  f3f   0	~f|  fffr ws 3ff?   fL{  sf3f    f fL|  s)gf&?  ffff uf   xfsfL}  s>f uf   fgf&;ukfffgf&? uWfffmHf~  s!f@   gfgf&;u+fffugf&;ufff(fH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @                                                          @                                                          @                                                          @                                                  @                                                          @                                                          @                                                          @                                                                                                                                           WW                                                UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU   
 
 
    
 
 
                                   ' ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ~戰䈽ֽհf'-f1=Ұf=fGZ԰fSf]Ͱfifs=2ff ffԽ<հff fˇf ׇհfqf԰f[fְfHf f"f @ f.f.~ f"  ؎ f%" 3؎ P_ -pqt]  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I                                                  s6 .d<tH$tt
䠢f  ffff  @ f  ffff  ff   ff  fffff  ffff  ffff   g(
g(33s
uuf,  g
g3f  f   ug.
f@   u f   uʀ f   ug.
Qfŀ   u f   u f   u
g.
Qg.
Qf.  g g8f3s0s
؋Bts
t	ffff  g. f3fȴ2 uf  f  g. 
f0  g(
g(#f1  g(
g(#f2  g(
g(3f3  g(
g(f4  g(
g(f5  g(
g(fX  g(
g(f\  f%
 'Ⱥf\  ff3ff%   ffff%   ffff%   ff tf    uf   3	f   ff   f
f3.߉f3.fff3f   t.ǉffʺfx  fff% fȺfx  ffff3f   u	f   f    u	f 0@f 0@~ wfwff|  fff%?fȺf|  ffff3ɱ u
 u2f@   tfŀ   tf   tf   t2f  g.f3ɱ u
 u2ff%   f
f  g.
f   g.
f  f% غf  f uK uK.f  f$
Ⱥf  f
Ձ 
f   tf3 u t=f
   f3.ffȺf  fff%fȺf  fff               07/23/04BDD  MZ         
      
        ,1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              U ]
VW!!_^]ÐU E
VW!$!_^]ÐU -
VWdFF% % =  t_^]ÐU 
VWdFF% % =  u_^]ÐU VWFF FFaLd`F`xF``FPF  _^]U VWFF FF
:Kd3`,F`$F`F`_^]ÐU 7VWF   B PF~}   _^]ÐU VWF   FF   }~ =`s_^]U VWFF% =y u F% =Y t	  ( " F% =N u F% =n t    _^]ÐU
 aVWv!FZ P@PFAF     FFFFF9Fr F^؊Pvx$ PveD Pr P.22=  } 00% 
 0P  _^]ÐU
 
VWF   F^؊PvyF~
s$ Pv P4 P*.22=  } 00% 
 0PL  _^]U
 
VWF  F  FFFF~ v F^؊PvHF^؊P P,Fvy= t F^؊P P P_PU.22=  } 00% 
 0Pw  _^]ÐU =	VWv= w       _^]U 	VWv=
 u       _^]U VWv= v v= r       _^]ÐUV VW\%Pk
.::=  } 88""%  8P""PFA vkFF% =$ t6 .::=  } 88""%  8P""P
D .::=  } F88%  8PF% P
F~Owl@PFF% =Y u F% =y tr ePfFPFP6=  u
 P@P3FPPw=  u
 FP ( % F% =N u F% =n t   G_^]UV VWP.::=  } 88""%  8P""PjF  F vF.::=  } F88%  8PF% P F~	w.::=  } 88""%  8P""PP
FF% =Y u F% =y tr =P
FP8FP=  u
 qP
P
FPaP
=  u
 FP ( % F% =N u F% =n t   G_^]UV SVWP
.::=  } 88""%  8P""P
F F vF.::=  } F88%  8PF% P
F~ wF F vF.::=  } F88%  8PF% P*
F~ w.::=  } 88""%  8P""P	P%FF% =Y u F% =y tr PFPAFP=  u
 JPPFPjP=  u
 FP E( % F% =N u F% =n t   G_^]ÐU [VWH WFF%  D  =1 u=2 u=3 u_^]U VWPPP"PCPZP_^]ô0!<s3P˿-6 + r ׁsj3PL!66ƱH666gP6g
P6g6g6&6 +۴J!6 +3Q3P 666P
.ظ P.ۚ  G>uXP P- 5! %z!> t1&6, 
3sy &, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky   U3U UVW UVW.
Q
u't z b >uM S  tX
Pu~ uF  X
uFL!_^]Ë  %!;s
OO
;sEt U P> t Pw]ø Y+r
;rQ3 V3B 22Ut
 P8 ^Ï <t)&, 3 3uGG> ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?CC6 
u6 3< t<	t<
t|
tx6?CCN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  &U&, 333t&>   tFu@$F	  P ϋ3_I&6;uQVW _^Yt&?CC
u&] UVWV;t@t3_^] UWvt 3I >u@!_] SQ QP[Yt[ËN r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG@tG  Du Vށ0FV7D*P_
|Q~ tN*PFP
FF~\t,PFPN
 Pvv0
FP|tD ^_]UVWFf\F^v
-0DutE FDut1Dt*;vPSQPS4GY[X+)D us;NrFDut
SQVZY[uV3ҋv+PSQPS3DPY[Zt.+;u(3SQVPY[tCIEu@F닀L F+3vF_^] UWV8VFPv8PF8PWoF^_]U`

t
]UVWvDtX@uTuAD0u
uVkXDuP3ۊ\S	tuL 
L 	LD  $炀u|ǂu
 HD3C_^]UVWvDth@udD  ttWL$$D03ۊ\uLuuC8t@tPu$@t ~QWS >L \SV [[Dt֋T+BUJT QQtSY|V;u3F3 t QPPSa3_^]UVvDttt
Yd3DD^]UVv P
Yށ0tLG LG GDD  ^] UVWvr8tt@t	vPuH0Du8u3tDD E L S P
[[t3_^]UVWv0t#3ۊ\@tVf X~ t3ED_^] UV~ u3P 7v6 t%v0@t^*GP,
= ^]UWV3F؋OрuEu0t5+DF~)PtD*P
;Fu
DtdL DD  ^_]Ð P UWV03~~ uDtV@uF96pr~uDtV@tGސ~uF^_] AIrUVW3FFvvF
t~ }Fx, <Xw$ FF.\V #3FFFFHF랊F<-uN<+uN< uN|<#uNqNjN*uVy؀N02F
 F>F  6N*u"y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuWN2uOY+YFFt3>F0u,9/Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ p GFN@F ~ tF 
guF vvVWvFt
F
F
Ft~ uWguF uW&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v5Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pk XFtȲ { 	vvËvЭvF tuØW^Ox
?3_QRSPkZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^] U^;r 	>!rƇ U^;r 	1> tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rn U^;r 	h3NauZ>uNV?!s	>t7VW%
<
u:t<uG+_^t<
t@t D!  u	V?!r԰
,F V?!rt~tѸB! ~
t
V떋V딀~
u QWGtc t+IAAwtLs	30?&=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_ U׋ތ؎~3u~+F tI] U׋ދv؎3ы~ǨtI]U׌؎~3I] UVWNF3҃
u~ 
u>u	S[! WVX3V@tG96ps^_ÐUVW0~O7
Q:X7t))GSSZ[<
tt;~tG t
3+)GO3F_^]UWVv8V>F8PW Qv;u&:x88
V
 PF  FVvaF^_]UWVv|96	 4&=}3#tV t
>	 ^_]ÐU׋ތ؎v~ǋNtI]ËN
FV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] U^h! U^;r 	>u tB3ɋ!rtnV3FFWVfN8
uJ = vFܺ =(s +ԋN<
t;t" j
;u 
F ^_^=PSQ+Q^@!Yr
F;wY[Xß~ us	@t^?u F+Ff^_NuV@!s	u@t
ڀ?u  Y;s+3UV^9\s
KK9\v\^]UVWNw( s!r s39tvuЙ_^] ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌUVA!   -                      MS Run-Time Library - Copyright (c) 1992, Microsoft Corp 
 
The information has been updated to EEPROM.
 Press any key to continue... 
The information has been updated to EEPROM.
 Press any key to continue... 
The information has been updated to EEPROM.
 Press any key to continue... The current Model Name is  
Would you like to change it? (Y/N)
 Please enter the model name you wish to change:  The Product Name you enterd has wrong format, Please re-enter:  Model Name:  Is this correct? (y/n) The current Serial Number is  
Would you like to change it? (Y/N)
 Please enter the serial number you wish to change:  The Serial Number you enterd has wrong format, Please re-enter:  Serial Number:  Is this correct? (y/n) The current Service ID is  
Would you like to change it? (Y/N)
 Please enter the service ID you wish to change:  The Service ID you enterd has wrong format, Please re-enter:  Service ID:  Is this correct? (y/n) HP Tornado EEPROM Manage Utility        version 0.90
 For Service or Test purpost only
         1. Change Model Name
         2. Change Serial Number
         3. Service ID
 Enter the number of action you would like to proceed (1,2,3)
                              _C_FILE_INFO=                                                     -             	   
	
\ \                                                                                                                                                                                                                                                                                                                                  EEE50 P      0PX 000WP         ``````  ppxxxx        (null)      p
p
p
p
p
p
p
            yyy                  <<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                                                                                                                                                                            