#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68BAR ROM)  - Linux-Based"
BIOS_VERSION="F.12"
FILENAME="sp28730.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK
# Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

## bzipped file
##bzcat $FILENAME.raw > $FILENAME
## gzipped file
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file
#tar x --gzip $FILENAME.raw
## bzipped Tar file
#tar x --bzip2 $FILENAME.raw
## plain Tar file
#tar x $FILENAME.raw 
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK

make_bootcd()
{
    echo "Creating .iso image from $FILENAME..."
    mkdir -p iso
    cp $FILENAME iso 
    mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
	eval $ERROR_CHECK
	echo "done."

    # Prompt for a CD
    echo "Please insert a blank CD and press <return>"
    read ans
    echo -n "Writing..."
    cdrecord -v gracetime=2 dev=/dev/hdc -dao driveropts=burnfree -eject \
			-data bios_update.iso
	eval $ERROR_CHECK
    echo "done."
}

make_bootfloppy()
{
    # Prompt for a floppy
    echo "Please insert a floppy disk and press <return>"
    read ans
    echo -n "Writing..."

    # Write boot image to diskette
    dd if=$1 of=/dev/fd0
	eval $ERROR_CHECK
    echo "done."
}
#### Process
while ( test -z "$done" )
do
    ans="floppy";
    echo
    echo -n "Please enter [floppy] to create bootable diskette or [cd] to create bootable CD:";
    read ans
	if [ -z "$ans" ] ; then
		ans="floppy"
	fi
    case $ans in
	    C*|c*)
            make_bootcd $FILENAME
		    done="yes"
	        ;;
	    f*|F*)
            make_bootfloppy $FILENAME
		    done="yes"
	        ;;
	    *)
            echo "please enter 'floppy' or 'cd'"
	        ;;
    esac
done

#### Clean up and exit
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi
exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(Hhȏ)Ii	ɐ
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hhȉ艟(HhȊ芯(Hhȋ苿(HhǈɨȌ(Hh׈٨ȍ(Hh爎騎Ȏ(Hhȏ)Ii	ɐ
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  /J*1*1  J*1 L   AR o m p a  ?q . e x e     ROMPAQ  EXE  J*1*1  Q1   HIMEM   EXE  J*1*1  SV' D  8DTU   BIN  J*1*1  )1   68BAR   BIN  B3u*1*1  j1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
device=a:\himem.exe 
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                    MZU  @  j
   \X      M        
       M

      n  
  
  
  	  	  o	    `       M
5  ;        i  )      ^  M  D          +                       	 	 	               U   8    M
																		~	z	v	r	n	j	f	b	^	Z	V	R	N	J	F	B	>	:	6	2	.	*	&	"						
																																			~	z	v	r	n	j	f	b	^	Z	V	R	N	J	F	B	>	:	6	2	.	*	&	"						
			 	 	 	 	 	;  ;  S;  M;  1;  #:  :  9  9  9  <  <  <   				v	^	@	"						n	V	8			
 M
G  G  qG  iG  WG   M
MU  T  T  T  T  jX  @Y  ^Y    				z  R  ˇ                                                                              3Ðjhː
  F  F~ F F^J9 uvfv' }fvfv ~hh jGRP{Vtj
fvvP蘄
hh jHRPNVtj
fvvPk
 Ð3f>X  tf6X f>j  tf6j 逃>\  t
6\ UV|Ð  Vh jQh jFh j;h  h ݆h ~F ^v&v& =c   -!  - tHHt-3 t_ J  F^v&v&8 D^v&v& it^v&v&   R  R  N  R  L  >R  uR  |F  H  m-d _HHt- t- t- tf6B j RP`jRP}jRP}jRP}jRP|}jRPl}j	RP\}j
RPL}jRP<}jpRP,}j#WFF9F}-^v&&?-t^F&&?/uF nSJ=sjrRP|jVStjsRP|jVTSfh  j k~X Z X ujtRPt|jkVQuhh Y|jPVQFF*PFPhh> ^fh   Q\ uhhR |jV>P  tS<  St(n ! ~ 9  =  A  E  I jJj1fj}j l j ujtRP{jU		t(^  v j   l ؎f&frjrRPQ{jHU>N  t>P  tV  T  J  >V t>V u& & & >V u=>R  u	>J  >J   >V u3R Ht	HtHt8j uwjJulj?j.>V u?R Ht
HtHtHtIjj 1Ȑj#u+jRPkzjR HtHH>R  tD>L  t=<?h<h<jv
>H t jYRPzjIRPz>H  t7
j SK4  F >4 >N  t>P  tV  T  J  >V t>V u& & & >V u <~ tfj fj 'F  W=HtjH-
 -!- - - 
tEfUm
>  ~  H    7 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G}&Wqfj 8e     F >H  tW5L4 C= M- K- (-M- 0- )fj*>H  tj Q^ÐU	^&,&.Ð  F fj fF j   l ;Fu;Vt^& FFԡ j  l ؊F&Ð<">
j hdh<h<jy>HT  Vfh  P FP|f<K  FDjhdh<h<jy>H t3^ÐFPsBFVhhx FPyRPhvvrhhx fvyRPh` Zrfvh` q ^Ð  FF	<">FDFjhdh<h<jx=*ÐU~uhhz  Ð~ hh h` =U686u3f0    8f66fh  f6X V= s6&G
 t	SSf0   f02f9r~"fh   RP6\ f6X \Lut뉐f66SO~ uhhz Adr j   l ءZ +X  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h	h| j  l RPy
Mfh   f6X vj 6\ ,KR{  WV~辄 f~ thhz FPp~ FPu3^_hh h` MS686tj frf-   fPf66q
f66jFPKq
f66Pt~ uF.~uF6b 8Fuc 8Fud 8Ftf66QkFPhPbf66Q ^_Ð~ hh h` R686f0    	02f0f9r~f66fh  f6X gR= j6&G
 ]fh   f6X f606\ I=t5fh   vj 6\ f6X Ir j   l ءZ +X  &&Wt j  l ؋F&  &Gv j  l ؎f&   x j  l ؎& 6n h	h| j  l RPw
x> tjJj1j f6j Lwjhh p j   l RPv
6n h	h| j   l RPv
r j   l ءZ +X  &&Wt j  l f&    v j  l ؎f&   x j  l ؎&  &  FF܌VF T   P   V   f<
S h<h<jPm
>H u_>?@T Rf<N  f@    FޣdFܣFhdh<h<js>H t>=uP   hHNu~ tV   Ft
F$p*V Ð&  VFF܌Vf<D FQCjDhdh<h<jr>H t3^F  FvڊB^& Fڃ~ | ^Ð>F  t	<&<Zhdh<h<j?r>H tjeRPo  fh  ! h	htjRPQF  @n +FHuF F^	&x&*hj*_RFn 9F}j vĈf<t<uhh CQÐ  o= t= u%F  F~}
FOu~|3Ð Ð>T  u#jERPnjFRPn3ø x&hjQhzt{u{Ð  DJ;fh  hPhvt"jGARPmjH1RPmjuRPmfh  eujARPm>H   2F hj
Pj
RPOΐFfrf   ffffN*+;B|;s<F*PjRPOj F*Pux&
hPh` jQRPiOjUARPjT7RPhh IOÐ  jF "hj
PjRPOFfrf   ffffN*+;@|;s:F*PjRPNF*P7ux&
x&
hj
{OjvcRPlju,j?GRPlj@7RPk>H  tlhvh` jRP+NÐ  D;fh ChPhvt"jGRPkjHRP{kjuRPikfh  ujARPIk>H   F hj
uNj]RPuMΐFfrf   ffffN*+;B|;s<F*PjRP5MjF*Paux&
hPh` jRPLjURPjTRPhh LÐ  F >V ut~ thh hh FP fhh FPwIFVu3vPfh  f6X nI= s^&G
 tF  fvBHO>V u~ t	hh hh FPehh FPHFVtvPfh   놋FÐ  F 4,u3tF f6X FP.F~rhh hh HFVtvPfh  f6X J= s^&G
 tF  fveG~ ujKRPcKhh j3RPKKF*  F 6u3s+tt~ thh FPdjhh FPrdj RPFP]dhh FPGFVtvPfh  f6X G= s^&G
 tF  fvF~ tj!iRPJ#.F~  F ohj
QKF  hj =KFj!;F~x& ܊F*PjRPJf6X FP-FF~s#~ t~ uw&
tFPFPj"RPI~ u~ tjjRPIF  F f6X FPW,~uPhh hh IFFVu3vPfh  f6X G= s^&G
 tF  fvEFÐUf6X FP,Ð  F u3F F~s7F*PjRPHf6X FP:uhh Hhh hh EFVtvPfh   f6X F= s^&G
 tF  fvVDx&

hj
9IF hj 'IFj N*;~x& Րx&
hj
H~ ujRPGhh jRPGF*  F u3at~ thh FPajhh FP`j LRPFP`hh FP.DFVtvPfh   f6X )D= s^&G
 tF  fvB~  j!RPF8EF phj
GF  hj GFj!R;F~x& ܊F*PjwRPFf6X FP<8FF~s#~ t~ uw&
t~ tFPFPj"RP1F~ u~ tjjRPFF  F f6X FP7u3À~uLhh hh BFVtvPfh   f6X "D= s^&G
 tF  fvAFÐUf6X FPA7ÐU  
2

p UvV>
Ð  >
vVF*^&F^&  >p% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU젰
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2*>* 	*  RhÐ*Gh  ~ t	h7FNuÐ  FjfvFP]\
F FPNQVRhh ^Sa~uvvhh fv`Ã~P|FlFFPvvhh fv_`Ð  FPNQVRhh fv`vvvhh FP"`FPNQVRhh fvi`vvvhh FP_FPFP#[ÐUvCRP:[
  F  FFVF#PFF9F~FF^F&uډFFFÐ  VfvfvxZfvZF
^v&  FF9F|^v&  ^UVfvfv5ZFN^v&8 t&@ ^fj <fh  vfh   !jWRPf6B BZ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPYFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0VFVRPFXFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& )RPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl>  tF ^fvjFVRPyV *+ȃQ *P%jj fvvvvv9ÐUj=fvh 6V  
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7jRP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&wZRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F F F3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0݃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0nڃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv	  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pكRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6 ^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj 9Fufh  jjG^& tDfh  yj  +FHu
^&Guʡ +F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh    9Fufh  lj ^v&0E׃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;(}(F;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F F(Pv~ 7
F(F
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6pFPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%>p tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>V uFPÐFP	>V u^ÐU>V uFP+ÐFPU>V uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFpFp  F
FFFF  F9F~FF^v&8 uvvE~ u
FpF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"  n HPhFP
FPj hUF=
tK-
t
-.t-	 NF n HP*PPhvFt(=t#= ;t= DuÐ- Ht- t- t- tàn Ȣh7htLth7hِ 1= t= ut փ>T  t fj hN3  F- ~ ujQFÐF Df>r   FF Ffrf   ffffN*+;<|;s6F*@N*- Sh8h*F*PЃuFv j h8h jЃ]FUtKjhЃh	h` j hlfj hTG=th8hEtÐh	hPh	hv~&IOÐI&OÐU~ u h	hvjh\Hh	hPjh\7F  F~ ujFÐF Df>r   F,u j h6:h2fh  <уu,- F Ffrf   ffffN*+;|;sF*@N*- ,Sh6:h2j F*PЃufj hr F; j fh  Ѓh	h` fh  {Ѓt"h	hPh	hvăt"fj hE
fj h6=uSh:h\t!h6:h2ttfj hzPU~ u h	hvjh\h	hPjh\F  F~ uj-FÐF Df>r   Fu j h;hBfh σu- F Ffrf   ffffN*+;|;sF*@N*- Sh;hjF*Pσu됐  fh ΃h	h` cfh ΃t"h	hPh	hv'Ãt"}fj hEqfj h6=uh;h\t!h;ht6fj hzÃ>H  tj ht4 4   - ~ ujFÐF Dj ؃u^ j hz=hhtF F~s3] F*- j hz=hvFP^uF= j hz=hNhe>V utTetMFtFj t:h;h\fj h6=thz=htÐ  - ~ ujFÐF DF F~s-F*- j h>hFP\uF= j h>hlh또>V ut>kt7j hIfj hT=th>htÐ  - ~ uj߃FÐj5փuÐF D^ j hZ?h
tF F~s3d F*- j hZ?h
FP|uF= j hZ?h
lhc>V utTtMdtFjt:h;h\3fj h6=thZ?h
tÐUfvh:  l:F.fh. U Lfh.   }Lj/gLFfh. ! fLj/PL~ufh.  LL~u
lN:OÐU*FPlP&L:*P
LÐU*FPlPLF*P:PKÐ  >L u7+  FV;Vrw;Fv	L ÐFP
uh h UL  >L u
FPh iÐUL  >L u
FPh IÐUFPh 9FPh -j>L th UFPh FPh FPh j|MÐ  >N tRFPh FPh FPh FPh j0 h l<uN  >N u&v*N"FF FF
FPvBl:Ðb=tw$-t-| u)n  >nt% Ðn -t-t t-0 tn Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? UnFPgÐFPtHtÐn	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  ` h FF )fF~}j v`tF`  F~s#>` tFPh F  f+fF볐>`  F  `>` t(^&9^&?t`  FfF~|F~s>` tFPh ;f+fFҐ>` uKF~}Afh   j FV^& ^& h.` F 닐FPh j FV^&^&`Ð
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h bfh   FbPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~ubPh Zj FF  	&v FPȃtFPh	hv؃~ thh
hh
FP4hh FPFVu3vPfh0  FPfvFPh	hP=ظ U؊FPfh  fh@x hZh:RPhEÐfh@x h.h
RPhfh   fh  nh׃h 
ufh  h j
u  Mfh@ hhRPhFPfh  =fh\  hwhV\^fh\  hXj 6\hIfhL8 h:hD  fh@ hh
RPh
fh\  h
f6\h
fhL8 h
hCFfhL8 h
F$PhCfh   Tfh  H hփh 
ufh  #h 
uÐ  hxC$PhxCj2ՃhxBPhxB
hxBPhxBj
ՃhxBPhxBj
|ՃF  hxB$PhxB=
hxBPhxB.
F~|hxcB$PhxeBh   fhx MBF  F~
}Yhx%B$Phx'Bj2ԃhxBPhx
Bhԃfh  gFhԃ~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhԃm$PÐUj
ӋFPh fh  	jmjӋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
JӋFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx ]?fhx N?h	҃Ð  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2уfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&h#Ѓfhp   j FPfu3Ð  fh    j FP@u3ÐF F~
shσfhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ΃fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRve1
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ˃2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	&v FPBtFPh	hv3˃~ thh
hh
FP'hh FP_
FVu3fj hvP(
fvfh  FPF
fv.	FPh	hPʸ   F CFPPj/U'
~ u3FCFPNQQj/@-FN

 PÐU>P u3ø  
ÐU>P u3Ð 
Ԋ*  f   fFffffFFtF>P u3ËV 	
tVF  FU>P u3ËV 

  VF
^>P u3^fFVf
FFFF^v 
uFVFVFV^UF

fFf
F
fFf
fv~U
  fF
f
F
fFf
fvVUF
fF
f

  fFf
fv.SQR ZY[UfPVfffX]UfPVfFffX]Q YPR؃ tCZXÜa$aaCaBaBa++҃ a tûT RËTaËRaUCaFBaBa t]fB  s     t =4u<f  fff%f
   ff  fff%f
   f 0!<s3P˿	6 + r ׁĎsh3P1L!66ƱH6Z\66gP6g
P6g6g6&V6 +۴J!6
+3	O3X 66666P.^Yظ X)ZP.^Yۚp^  y>	uXP	 PX	 5! %&Y!	)&6, 		3	sx		 	&, >3&= t4
 vt3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
"t ""z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  &U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;vuQVWv _^Yt^?G^
u͎^O]UVWV	;t@t3_^] UWvt 3I >	u	@!_] SQ RQP,[RYt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UWPFPvvPFPWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuGt
t"u%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVNFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWvt
t	"uVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*it/ppPvvPvvF^&*iu^&?%t2XdVZ\T`3jfh~` uoF^*&itfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt it)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPitou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\iu̓.uMhhtAĞrr&.hht'jĞrr&pvv
iu̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvniupVvvj u
T t nĞr& \~P|z\P`
 P|z\PV^*&;tpVvv RT uInC-c = w.Zpinl6n6n6npkpppp&nnl`lppipnlppkppiRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^it$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vviu^] qqrDrprxrrrUwVW3FFv&vF
t~ }F, <Xw$ FF.qV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uuCIWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
^F
TFFt~ u	WZguF u	WX&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>P tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uMuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B	&R=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WV.3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWVvv&PFPW Pvv;u)x&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;rvJ;pvp ;s33󫖹 +v*39j	tvvvj	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3	 u
_^]U VW 3~v
tȰCvu&6l	% uN&6l	&n	HȰ"Cu׍D&l	&n	% uDȰ"Ctd&l	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋp	"tp	F3] UFu		u { rFGFF3҃vvډWNu(t$>b uS#5!bd[F#%!u߇sʻ 	FV]U컃 .8tK
Ir	]PPR.^Y؃> ur	t	w1uRUVV EE< udF bF]ZXXˣ		UWVQS3r	t	 P	X[Y^_]ZXX˃PU츱	ء	F	F]XSQR	2P P/ZY[UfԀu	u3
tuH]U^h! UV		ȎغU$%!3]UWVRQSP.^Yۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;uztz^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;rv;pvp3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]        	              4.54  mm/dd/yyyy  Error: XMS driver (himem.sys) not installed XMS Version %d.%d
  Error: could not allocate XMS memory    .BAK  wb  .BIN  rb  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/Dock] [/Update] [/Backup] [/Restore] /X [/!]  where: /Dock    = operation applies to docking station         /Update  = update BIOS with new version         /Backup  = save BIOS to disk        /Restore = program BIOS with backup image         /X       = clear ESCD and CMOS/ECMOS        /F       = force docking station recovery         /C       = do not allow exit to DOS (power cycle)         /!       = do not allow exit to DOS (power off)  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Invalid command Machine is not docked Could not clear ESCD and CMOS because a password was  set or because the command is not supported Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin          MS Run-Time Library - Copyright (c) 1992, Microsoft Corp                            68xxx.BIN                $ ( , 0 $ % ;  ' ( 9  * + <  V W V= [ \ *> _ ` ? b c @ #  	 Z  	  D10/17/2001  O                                                                          *2>|:f
(Db 6bz <FNf
2LPX`jt *@Fn@`	
		F	b							

4
d
z



  Pr6d
N
`
p
                                  A    B    > f *	      ?    @    > f H	      C    D    > f f	      G    H    > f 	      K    L f 	      J    I h 	      E    F    L f 	      )     -    ' i 	      P     M h 	      &    -    $ i &	      N    O     Q   
R   
M g D	      T    U    S f n	      ,     -    * i 	      Y    X g 	      ]     -    [ i 	      a     -    _ i 	      d     -    b i 	      k    l    m    n     o     j f 	                 0Z                           _C_FILE_INFO=                                                         	               
	
\ \                                  	  	                                                                                                                                                                                                                                                                                                                                                                                                                                             	             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          [[[[[[[               (((((                  H                                                                                                                                        
                                                     %Y%Y%Y                  b					<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                  MZ #           ?:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         #XMSXXXX0Copyright Compaq Computer Corporation 1989,1991                                                 T                             

Error HM21: Windows 3.0 does not support memory above 16 Megabytes.

            Add the /ISAONLY parameter to HIMEM.EXE in CONFIG.SYS.

$                                                                                                                                
. . S. G vO[Ct7=uC u=. u5.>  u.>  t%RP 	!X
u<u@.. %)Kr
AtHVWP
tcĀtrv
rw
.:&M rX3J.>  uH .} .>_  t.I .Q . . u	X33XP% X. .} _^RQSPV.Y .+k .Q =@ s.Y   .>_  t.Y  .b  .)Q w	.Q   U.>h  t-.Y  .Q .h +w3.Q .h .Q .b =  t 33.b .Q .>Y  t@-@ ..>W u.` .D 2.F .I 3..6y &. &D. ^X[YZ._  3&f 3&> VDu4&> ISu+&> Ku#._ &- &, t@.b - .     u.b - πuM..& `.a. .> t
` .A a.P.%.	X.6 .. =u.   .>  t.b - .. .>h  t.>Y  t   <@u.;t%.>Z t.>Y  t.;o r
 .Z 23.>Y u.Z 
t.Z   23.>] t8 t
.]   2ó3.>]  tX t
.]    2ó3Q.>X u+. .>O  tz u .A . u.O  2Yó3Q.>X  t;.>O  t:. 8 .>O ut3u .A . u.O  2Yó3Q.>U  t
 .A '..%x |3H@ t@2Y  3ø 2.>  u.[ .Y O s"ڀtGW_

и ó3 sڀ t	O 2ó3`.;d r!.;f w.+d 3ҹ
 u?uaaĀu:QVW33.d .K ?uwG;s2҃
Ǌڋ._^Y?ĀuQVW3.d .K u?u	;Wwu?u t u
u+t9u1D  DED+Euָ 2_^Yó3QRVWsX| uT| t-\D.>d .K =uU;tU;t
 2_^ZYÇTUT뼳3ĀuBQVs3| u+3.d .K ?t@
T|
t^Yظ ^Y3ó3ĀuQRVWU>ӳs5| u-;Tw`r 2]_^ZYRZtD+T>F>)F3.>d .K =t	
DED+EE TReZt"+D>;Fwt
>)F>F>F TwtEDt>F;v tt>FD>F EDtEDED&w&w
&G  &G  X+Dȁ% &G&OXȁ% &&OVWR.6Z_^MLD+TtTUE3VRIZ^tED&w&
3&O&O&O&ODȁ% &&OVW.6_^DEDDEDLM]_^YY\DT3.d .K V?uw;uuw;uu
^ÐUSQR3FFF&F&LN?\r r_FV^\
a rZFV^n^rG*= u@|,= u4^tO^tOZY[ ~ tH^]Àt^V&w&&t+tLG +rB+FVr2GG^ËǺ ƃ v~wr߃vڳΐ                                                                                                                                         |        3                               FVNv*,6<0HtPQR6.7.w.w.4.t.t&. . ~ w9NsNU ˺3 3ÿ|&؋3ۋ.F EEӋʋ
  
  ])Nt^ 6*, > l^ u>H t20.G.G.<.G.G.Z[X*,6H.G.O..W..GËЋ3d K ?uu=9?u4GG;r*;Gr!GG;wvw;s+u
t
E uUÌȣ
@H  Ā3 VWfPfQfR( f=  vf  vfZfYfXƋ_^fVfWf3f3f3d K ?t&fffOf;sf?ufff;sfǃ
fγft2f_f^Ā VfRf fZ^QVW3d K u?u
f;Wwu?u t u
u:tHfu?fD    %fPfDffEffDf+fEufXָ 2_^Yó3VWQfRfPfSsf| udf| t2f\ffD>d K =ufUf;tfUf;t
f[fX 2fZY_^ÇfTfUfTf[f[fX3ĀG QVs63d K ?t@
| tT|
t^Yظ ^Y3QVs(3d K ?t@
fT|^Yȸ 2^Y3Ā VWfPfSf f[fX_^UfRVW֋fӳs?| u7f;Ts r 2_^fZ]fRfZtfDf+fT>fF>f)F3_^fZ]Q>d K =t

YYffDfEfDf+fEE fTfRbfZt(ff+D>f;Fwt>f)F>fF>F fT\tfEfDt>fFf;v ftt>fFfD>F fEfDftfEfDED&w&w
&fG    fXf+Df
&fGfXf
&fVWfR6fZ_^MLfDf+fTtfTfUfE3_^fZ]VRZ^tED&w&
f3&fG&fGfDf
&fVW6_^fDfEfDfDfEfDLM_^XX]fDfTf3d K fV?ufwf;uufwf;uu
f^                                                                    UfPfQfVfWS3FFF&ffNfn  \  f^]
  ^[VW*_^=  3Ɏf
f6&gf4   ffNfgfgfggfXf&gf4   ,= u:^tO^tO[f_f^fYfX ~ tH^]ót^&f&t(sDfGf
f+r;f;r.GfGf
ffffffff= v೧UP    uB9Fu;~Ut~^u- . "W
 Î$"e
  3؎X]X]..fvf~f   f;NvfNfQ6>fFf&e>fFf&efYrf)NffNfN2.
 .;d r%.;f wSR.+d 3һ
 Z[u.?ufPfRfVff3.d .K ?uuKG?uBfGfGf;r5fff;Gr)fGfGff;wvfwf;sff+u
tE fufUf^fZfX= s.#þj
C.6.0.2R.4 .<.>	.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         t)R uMdI uD`@ u;>V  u0d0 u+%) u$d  u` u>V  ud  33d$= tr$ 
t$ 
u    3= t
r䒨t,&䒨u$3䒨t$3䒨u 3ËR?Z% ;u ÜuR ?Zu	 }  `@ 6 6  .A `  .q  ?퐐.q   2 ?at4 u/d+ u&d" u ud u
d	 u 33d$tR)Z ôr &&?PTu&Lu&Gt 33S &>P OLu&&> uf$<um  [ôr!&Gu&	t&u	3v 3Î&& =HPu& $u 3Ë9t	""S.[u.OU .w.O+ >A "   /"8!!  b" 8! "!!  ,"!"  ("`    t4>$ u?O   V 3A 1t.t'?1tt-9>V  tX  
À>9 tV  >V  t3>#W>#_     PSQRWVU.> &]
t~430.9.&9B ȎЋ3 .9.9Ћ.>  &E.} ]^_ZY[X. p00!0<rP C/2<tD 3= t9=@ sP.I u?.9 u2.9 . . u2H3B3.#.> &E
[i4+.[ rHYdrt .>C  t	.94r( .><u	.9(.> .#&E&M33 &. &D. Ü3PX% = t# PX% tt 
                                             3S.w &&Btk&Wtc&G+SP.D .F  .I .6s Ȏ G  DT .G 
tX[3.D .F .I .W  "X[&G  &G.6s .G  [03COMPAQVWSR+ u"&&Bt&Wt.I .W Z[_^VWQ.>u 4& Y_^ZDS CORP &.& u	sEE>E  E E  .I .W &D  &|
&D  &D  &D &D & &D  VW.6_^&|&D
  &DO,&L&D  &D  W.6.& O, ui>3R   .ZO, 3&D  _W&|
&D  &D  &DO,&L& &D   VQ.6Y^&D s&D_R.><u7.>W u.` 2.D .F .I 3..W  r.<Z0s3.+k .Q RQSV3rCs37ú@ .S .>9u$   @..6y w&. &D. ^[YZÌ.c
 .}.s ..-.6.>W u"VWQW%0 .>s % .>` Y_^.><t	!Q
 3YtRZ0!.Q . .  .S  .I  .+  .+h  } RP53Ҹ  ! N9v    |K9d.>h  t.>Y tg=NG.>[  t?i5>3Ҹ@  EH9-@5'.o =u@ Q
Y3 H9.>< t5. 3 H95XZy '=  tPRZX H953.K K K9K9ù  ts-=s( # ='s =s =d s =
 s PSQR+ك ~3Ҵ tu.!ZY[XPSQR=  tʸ;sP0!X
 3= wZY[X.# t@.d 
 .K .#.d 3.K GGGGG
.f .   .    rPSQRVW3Q Ys        | m  cQ؍6O,rIq,? q,5 6,e ! V3=   B  >9 ^DuY __^ZY[XS û&?EIu&SAt[Ê$y<tRL\ًDtH 2PS  :r;r[X[X2   @ 2Z                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 C   `Ȏ3.- ar< r=.>.t3 3ҹ &<tr r
Q B$&[1.- Ȏ؎  ?   . .Q .a.-ÉEUu
%-`Ȏ3ҹ -  -3   --PXs4$ sBKua`3ێ..CCt;&$<t..3ێ..CCt&$<t< t.. 1aaPQR..Ȏ3ҹ .  -.3 - -ZYXð%pq
tt.d .K ?t
        
HIMEM: XMS Memory Manager  Version 3.06   
Copyright Compaq Computer Corporation 1989,1992.

$
Error HM1: Unrecognized A20 hardware.$
Error HM2: HIMEM requires MS-DOS 3.00 or higher.$
Error HM3: Invalid command line parameter.$
Error HM4: Cannot unmap the Shadow ROM.$
Warning HM5: Cannot disable A20
$
Error HM6: Cannot enable A20!$
Error HM7: Unable to unmap Shadow ROM - memory area is in use.$
Error HM8: HMAMIN parameter value out of range.$
Error HM9: LEAVE parameter value out of range.$Warning HM10: LEAVE parameter value out of range.

$
Error HM11: Available extended memory was not found.$
Error HM12: An XMS manager is already installed.$
Error HM13: NUMHANDLE parameter value out of range.$
Error HM14: SHADOW parameter not valid on this system.$
Error HM15: SHADOW parameter only valid on COMPAQ systems.$
Error HM16: HIMEM requires an 80x86-based machine.$
       XMS Driver not installed.

$
Error HM17: Move Block failure clearing memory - unmapping Shadow ROM incomplete.$
Warning HM18: The High Memory Area is unavailable.

$
Warning HM19: The A20 Line was already enabled.
$
Warning HM20: ISA memory above 16 Megabytes does not exist

$  COMPAQ Shadow ROM area recovered. . . $  Minimum HMA residual size . . . . . . $  High Memory Area available  . . . . . $  Total XMS extended memory found . . . $  Maximum extended memory blocks  . . . $  XMS specification version . . . . . . $ HIMEM.EXE is an installable device driver that allows MS-DOS 
 programs to access extended memory using eXtended Memory 
 Specifications (XMS).

 To install the extended memory manager (HIMEM), include the
 following in CONFIG.SYS file.

        DEVICE = HIMEM.EXE [Option]
 Option:
        /HMAMIN=nn      Sets the minimum amount of the HMA in Kbytes.
        /NUMHANDLES=nn  Sets the maximum number of EMB handles.
        /ISAONLY        Manage only 16 megabytes of memory.
        /LEAVE=nn       Do not manage this amount of extended memory (Kbytes).
        /SHADOWROM      Free extended RAM used for ROM BIOS. (386 or 486)
        /ABOVE16        Manage memory above 16 megabytes on an ISA system.

 If HIMEM is executed from the command line, the current extended 
 memory information is displayed.
$ KB
$.$/INT15 /HMAMIN /NUMHANDLES /SHADOWROM /SHADOWRAM /LEAVE /!SHOW /ISAONLY HELP help ? /WINNOISAONLY /ABOVE16                    ptlcascade att6300plus ps2 hpvectra acer1100 at                    .:Ȏ؎иB p0: u   L! C/=<umøC/<< E n ~<Jú>C 3  <S<*>$ 3X<ô <= tg=ú<=3Ҹ@ H9ô< t>tt	=Ãu
s; s8PRB>XP3EH9X_=  t m>3%H9}fPfSfRfQ<fY   fZf[fXfPfRB>LfXfPff4 H95fXf[f tm>%fff H9fZf[fXfQf
   f3ffYftfRfZ0!s=r<ô< t	=tú<u<fQ<fY f; ff	<3ô<R3=u}sXQX;|ȃ} Q 3R].!X
 ؁ 	
؃	 3R0X,Y        A20 line currently enabled.
$  A20 line currently disabled.
$
$  (Additional free XMS memory could be available for this system.)
$  High Memory Area available  . . . . . . $  High Memory Area not available.
$  Unable to report available memory size.
$  XMS driver not installed.
$  VDISK loaded, unable to report on A20 status.
$  VDISK loaded, unable to report extended memory status.
$  Total XMS Extended memory free  . . . . $  Largest block of XMS memory free  . . . $  XMS resident driver major version . . . $  XMS resident driver minor version . . . $  S.:33Ɋ  u Ȏ & >BB^ [.1Bގ6 &t
 >BB< t#<
t<
tg rF&BP3JÊ< tG<
tC<
t?< t8<	t4</t
<-t<?t)F& rF&B<<&:FWSQRS3Ҁ<?uF<
t!< t&?hs.1&B[	[&NZY[_<=uFt"r=? wt
u.o ú
2&B.h   <=uF~t-Sr(.;Q w=@ sm2;.h .[   ú<2&Bt<=uFk3trk= w
t.K ú
3&BO?<=uF6 r<oft<onu!/)Ȏfr
tr
.<ú|3C3&B  Ȏ7r
Er
.<ú|3C3&B .C   .<  .  Mr.9 =  t.<4&VQ  u<A|	<Z FY^SQRV
 33Ɋ0 |	wF^ZY[V3< t$<	t< t<
t<
t<0|	<9wF@3= w^P< t<	tNXP< t< t<=t<
t<
uXVP3ɬ< t<$tAX^WVQ3ɀ< t<
t< t<=t
&= tAt|Y^_P$p  q<1t<3uXXȎ؃:
6Ð999BBBW9_9k9v99P99999@@*A@Q@Q@YAdAoAzA                                                                                                                                                                                                                                                                                              	      ]Pg%\5G[m;pL|.Ba7Scx	F	X	g										
6
F
L
Q
V
_
o


	Kv)
i
y






),03;CHOX^coy9]f'Ik 203-Memory Address Error 
Non-System disk ore
replace and striky key when ready
}
602-D ette Boot RecordH5 !Run Configuration Utility1720-SMART Ha0Drive detects imminent failure (Fing Attr: ??)

Please back up the co{nts ofh1drun
HDD Self Test in F10`"tup 1800-Tempe!Alert  7{A proc~@has be eda"s n0orq'#C7MOSA%3-1)d(s a%'&1(&by POST o1155uBo1?Comm P(6Assignm!lic0%611-Prima Flopp@-?/R0n02-S nd12/001 tGrol %85sType17A88q ;94O<f=03<0;W@0;f@H=C8 1;DH=348@>G=60-Fix'@doe(sup( wBloPModrI%1I1JK7g1>6K0 AO=PL01s73IMDMAL3L?W$L5V'IdifymAmQ[X\]4[ Q_#K`?^av]8VParamr Table1BI)dHalp' c 538P!apgE=Updb.49h... Invalid el ronic serial _numbe108I/O ROMW%308Kl93r8304r@UnitLoad_all -hi4Monochrom$k 164Sizu;qrHx"0V$Inst`wi etwork`"rvp9bActe!No rachi164Op*stq# Pg@ CheP2  PCI BusAg|A910-ExgnoStorag:eviD= HvF1x`1`gP9lS1T0xk2_{3\3o02 08:rpqQs.E=IOCHECK acwlz3-{Tipy& Dap O X B  Powe{r-Pass@dXOKDo you!llzato pp  s? [Y/N]?RҞsVMAdpiaP/R"orhipn01 n (ABO= 'C_trl +$tDel'pz8-11A: X&changedu2: m oqne!&1PpP3߯: Video	m-4z:rrup+f@_u5 i8͹6ߺan3(@_#expansb  TurnҠcej &f]qr<F1>:G AbSb^+rmal2Upo mu"տ 3gi wa0,Q+B0kA(Strg+Un/tbr,I ϪnaTf@9owo$uWtomculed: [:s To~ mie~: Kbyt@) cksum #bn,NfauЪ`nuMl0wiW'Next? EAAgti#Exv0Ӯs7saEA7cce=   F1`0 OF2 CTS`k I .pugy # Mai Oances EntQ;F.5w9ipw, usimodut~Yme@erequi{reQ0s.  `oD٤. rLK1"Bj>GMib?_ay126re| Mexcee 'K'ƛ1) >CircuU=uUn$N'wPlJn$dӇ%'.,i.Sc,ed !"P.0S1t	C11(ppc1@%#I	,vInrypD	Shut2l/down` P~ %0Ѳڡe [PIN: [E]Nxoq left@
ERROR
wY`haA}7goney 5la"MQIndex (MSGIDX)   t   _      8     
   .h   n f  ffff0 ISvݓV Q'  A            > p    T   gG W e M AY 9|@. 0 J  EnSa0~ G ( @ ظ   f3  ?f
 4 P f pπp6 f6   } /  6 >x  .h0v PS $<t4r g[X  DisplayCompaqLogo `
u1WGWrBWr<W. u)(.< t.߈hP.c a Oo !"$#`6PhFlrAV(< 
u^V3!&  ^(P*^ ''2 aSP( 22< tFX[úB +$PQR  ZY/02?3_4 56789;?<_=eAGraphics f`qt<.-  D.&.ރ6.u  #l O .PAtELrsCalling GetIntelBitmapAddr r8C vJr-+D+\  r@ .hcfa0A PR1.3PZiX@OOA.PQ`&Fa`.>OuhPP)XhNr.>CNSÿfPfQR	PaintBG A.fh f3f% aZfYfXeH URQSWF^
D= F\ ^^F_\މ^t
;v F;F
 < uW`b < ȭ22 IF t蘾eee~e빀c% d8t
`  euPj Ѓ;}
+V 
N JZ=@euAN`5-_[YZ]`PY&X&@SPQa^ kPZY0-UkPkP]]].uvw xz?{_|}~߀`Q0]h *Y]PeQwLQDf&YCC7PpKpabݻ  ]a3YaPnð@SjP3pX?[ADRY$&%<GP WP	 ff? t@  [h<trrvsgntGP2`Q24`Qf3XW k[WS_fRU3S`F.fGenuuhfineIu_fHuVf=sL=r=vPtK f  =   	tŀuvrr{ f@3t5uZfDY $<@tK<tGFrH$u6f5ۊff#rCt Bt	]fZf[
ffȱ bˋh
f`  , z	qh馲hm?hNؾ  <D 10Ëދ38t" QW_YFð N;r+A+&FGN uɆF@"0rF1
ؿ:D6
b"hS@߿GE\9}   6M} Ӹu00U= r&+=ƹ=rW>@ _<us!&
0&6
, fgh  0 pqr  <ABCDE xyz{|}   fQfRR Ƣ&B r
&  0R>@0YQSQV3
Ê^Y[.<  .FuN.PW _XUWfVUSW! fv߿ h ޿RV_~2,ك!IN 3t^
u
t_ ۋN_[]f^_SV h²^[þ0 0OSRZF10=ROM Based Setup/# EHrHePrt 0AP  OP$  Q} )aNPSuR  wp b hd"I/TF12=Networkrvice BootWake On LANAttYeHto" 5D>2W  Ƒ- r	S8 !1zuE_ 9Rdf\right01 q6/ D1s^RV3L<^hb]3%yas a ?uAWPu[s	rQWVRЗuy3L0NF L3؁ôL?	uCFG~N@		t`
Gf`hܲ1Lvh3
f)Z^_Y[Notebook hard driveHMultiB{ayJDockHbCb(top)bottom)left@Opcal DeDUSB? FloppGCD-1H!Super!NICj1%I1%&2'&3o% ,-./02?3_4 56789;?<_=>?@ABD?EpF	.G
LGjGG
mGGG IlectͿLMU@ and mothe hplqyour cho.  PressCQose.Seconds until au }a` defa` start:   ($(VL's;W!ZipCE`t= Dr= k\d h"bS0ô0o.s&t   i _ 2L3L؊' tA<v<st1& 2^02ƾAdQ_YAr ]@D s.
*. .ph+jjj(Pjߚ #` u ~hxjz  zj  1 02g\
 蔿  t0^32Ɋ <tF8tF3L $ Z`qjkqURVQ.,.L.T^Y^Z]sSt.*[t݁uQSVW/ s&Q.<.-00?00.1Y_^[YQ	x qZu hP"ۙ Zt0[t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu 	w`2bXʱzjd uhxxr
;w2ҀkhJAsgFYô.*<2ufQW߻0ްhN fhČ h" hqÌ_fP!> ۱1;BFJ! h؃f@ 6if.fffȵ3vO2Micro SmUCBus Reader PW .g&:u&Gf_g&g Oa߾_  ?  V   B\`hqPJg&F Vg&F  u
hZ}bg&F&XPg&Fa  r?a@ &   @ r) a"  _޾׎Ǎ~ع   ל vaQRV`DT r&ߊ%^ZYfPfL	
"bLу  rр|^ " Gǣ6a$&Y@( t  rP N(Q'CYPQ2'Ar ug&9N(t Pqmr`r[ ޲;w(;Wr
ֲ	ttǲ`³  r݋BCPQGysrPR`1 Z1.>XohFl"fPS@ǻǀuh3"<tXB p.>P t.PáWf 2f?\fӗf@_!Q}fgf&=TDSSu  ff3]gf_uf.>Yf^f_YP˱QRW5r_ZPPVW TGI$tu!t쪃u ܺ&_^ H>$ f3ɵ`6ܘA, I v߮v I;vaSWQRߤHuʀPpq4bXZY_V@A<A@3ɹ2 u# P% = @uXu"V@%ajRJ߼ x@     V@P`PJ d k`hUT X? `q	 @@P        {*QJ A0`   1n,9SJ0@48 (@*  .P@b ,P :8ch @d  f   !`QQW 1!qC 6 s@
. U /. p\0. rq0V. `abO
hp NAN  ON aNT`p
aGR0
O$a(aC
O J3a@ON 4aN@b
 he颊uG!L_O!"^ȿ` hfQt &@ fYf8t*m$ ""{&> tRc ~rE^(&|f3C hS}  G 1& < t&G $$Q$$~3%&-%';'(Da)f3/2$*f& uf
ffKf&&&_fC)0A2ۺ0$O122@3#2 3d/wh뢊`p߀@!9 !9&&7SQ"^3r`&&&G@;@;r<Y[$#fPffRfVWf 3ffCf[fKfSF0r!_0$а K I+r="^_0Ҁf@SQVW u3_^3t3pȾ!_f M r;(7u'P ߸uǻ"o hhXJhMrPRAO U?fW Qt% s	 fe& fff>a&?fh	13ngr   ; pu7)f) f' ~/u!X/uX/uX/u	g& 9tx3ROrnfQTǂÀT@W\aTP'~/uX/t Z]	 ;n&QZGf&Eïe fgi/jOkolmn opr/sOtouvw xy{/|O}o~ ρ/Oo ϊ/Oo ϓ/Oo Ϝ/OoPAPf`f.\&`&u hP#5rWrRrM`&tff| pRV t#Br"p9}#   / 'ߚ cy> ?f]c  FfU进r*6R  R߄ Z rGq~ Kuf]G a? rCF+ @(3^cg&8E t fEGH #RdER(m r(>e&> t4?QPhST ]Pf&HcEW{ r^ r
  GC_>>?t$AÊ?$wWw  _Wl  sq_  ưQ q0@B ? ð 3 S SpĀ' " TPʟ scAQ/AΊ?QWEΨuptPGX_Yù
 d hcLxs@`
P <uAb֭u PR? ;? < uZ0؊AفD t	Aۀ eٝ<|<t<t2<tH0K[\߃"L
L{E#L륦#LfU
뿈T2+"D
D#DDff#Df0f`Sn yk B1l  1 pS d hk )U r1 L j	 U
 j 5U u
 j i 1 j h ڙ   So  *i ͈ rw T 	o h L %O N  <  m! X" Lm# Q( S$ $q % V&Pj h* hd x_ ; 1' p) ty+ [, Y- / 0 N1 `2 lM3 `m= > am? @ mS &A  tp bm5 2m 26 m7 S9 : 4 EjC i1D mUE jF hG MH 1I0J O. 
K jL SM N lO XP mQ 3R V hW kXPY (MZ 1[ 9hb }c Ue hg `1\+" f"0 @ ؠ   !J  f   3.0. F.D˴PX% hX@ .X=X@u
_^rYP
ΊظHӢӐ
y9
PWD;f&E1_Xh[bhhڵ%# h+Ev& /H}  PQq0> 3_YXhc~SF2hX# _hЃ8D>L &=tG4G HI$h}s s	I 1O   ! $!f` TW *h=b uOpKffad>vP2F X@8`3 ;DؾL &>L&DE{&&D >Lu d/Y061k /Y061j@  9B#}
Ȁ}	~7>L#33S[tS[ }א#2:[sM;3q tthCMc&s
Jhca.hDbD
ϰ< >DuL
p
E$<uBD
@ܡgsd
{#Dr& uDfp4` uL
 6 6L󦀻u9_  GX#6H &uhps>	\
bGAuE~$G pG eD&}?u D t&Eb t EB&E^DB&Efw>Ot6Oj t.& Vt	&?  tSR&Sxu	~C\	PSqR PR ?R؍>L_3& ?XW>L	_[XOt+tR# T xtS  t [w\D@@PV!$!"桾t#h߶1/3q&?  ^X@@h@r!L	vTt
v]`W@VW6'QYg$<v߰ @Mu<dYa3 v
p]
u$@"<ul@P>ȷX\PRt:1thG4!Kķ qp=B߿ZX0`2ҿǿL& 2t5L=ǴLtOu@08 u	7t!s@ D uy{ $hsyau׽3`0hs~#  V @HMu @HP^ ~3f`QG@YNf_E##}`AUA  # N&egWʃO&MuO OofGRtPQt$OQt,"t"O~GErp4MoOg&N}oaPp
P2]h"aeGf_ktK<uLD8W =_7D D	 d
z1QebBtSPrG&}	r??23ot`hׇa&EP$C	&M&]]`.'	K%f rS(tUڀܷ ShF 
~|h}ss܃]RR۶ QZW&= uAn楀Prb)
hb6
 m_P
t  U!w#w !#` ۊ[#D67h  C;.-.kM!dN0ztI ȶrJM;.58vou@
@~kB 0(aW$
1(D U
5Y* @[X_Ë
ß`PS@[X Sϯ1(H50iLR
`(Z,<u(fPfRffPf,ZJ vGdu
pχÊ PeS1( ƿу[aq$ ƀ@]	SQoWf3Ҁfl<fְ
<u	fpkv@_`u`֎fuhb73۹ F
t):u%LD	& h	)L & 	 h<"ؾL3߃a@3 
3 #P L ]S 80Z= (u 3*tF& [9 r6Qp- r* &' t&?f+ w+ '0r
vr'+՝ QQqs 0R׃tZtt~t hC^A YQ?xDP[r=Gu(JaF% = t_0Y!:려[rS3L+6 
`QHH3wE&NE0QQ,0Nr hZ{xf!V @쨀u$P<PtRurZDvqsO2Z7:Z^0WV 0  PUX@ 	"R

M
r/FW27ƀB8Ɛ#?C@?r@yD0""Ð#u,u1
@

+&C323&v@t }C"
t&
0 迪 b5  O"@ a@(
uӴ: >Qq? 1w ^aPRW&	A&&]&&UF
t ˀA(]*_ZX3һ -w2C./N 9phΓr`._= 	߸^1, `u4567Րa>u  'av  MCqfSpf3fau 3 Q>"L@J#:uBE&8Uu8>]
R +B&U
ZKa<؟MC=tAZf`YBqr h0S
a|> tP:GG> Ãh}r]
<t
tZێûPpVy#D
^fX"LPD
YS]8 VVXG-I<IUf`_؎ FwE.Н ڎfafSfQf.Ef\fff#fYf[[VftGf    \~EIg f;t&f^ _|_S`}	_F >wf^]`2bۈfaf`PqVqfaPe3_X.>}E; .g`_TACOiFRi) Q`i&jji	&j .|E ^i%jBlF5jn~E fFf.E`ttEF.Ef.>E:E.Ew t@hEtYtY@hEtNpy _ta@SIhVfB.qxfl;VrT%z^{t_|}ܠgyi P^QfR`f]fffg =c^r. t |Ebf@r.zf³fHrtfXfdf3wxu|`{s?Is*_tlVf+f;wfff33RtҊUtE^^`'R``SÔ$.p_QPaɠ``333Ҹ  QW>PptP_F
3}5uptJE#ȁ0 t0 A `xt
Ήt} tWM_ }v   ؉F EF^V u SV^Qp&tY&  
`< tr&\]&\U@
&mNd Lo
S؂[u`	F& 4F^[_F FV\Z}!0VW>ًذЛ' L'r_^Y[XÿWfQSǵ \ fVt
!p[fY_` t =$PnPu2MtaË6ps } tp( ` j  J&& t_SRU	Qj@6^]Z%V` XoK1^X~p*?F
  t#b0pt0PY0{F 0F0XU d3duhZ$Ku`<Uu߿ùhzC߹d `h2}p4dw&qt   hm}2& h3{F
9Phۜ˰ї̰`̝Xÿ!$!2H   °2HsXp?AH 
eh52   tSt 4 ܠhEC/` tKurڀ& &  S
 `0hEs <t<u[u2H_u?1*`PyhnXhϻ % Pk @-'	j$[és# PXz#ȡpRɹtUP`X} mU`G  d#e 3 蘽Do1pÀ   ; Z x     0NPX`^~Vbh^1fF3.OS _r x
0ވBFuр~2wFd#e-00
<2wd8F w(8F wI N@cF ;t
 u@mF^KO.
~r@V_  aP}û< fuPypff @ffRfPf!N -
 ffFf3fv1ZfFsfBPf\fU1 r9@c`f3ɐ:ǿ:fѐ faÒfPV3v޸rF3QX

S,0<	v	,$Q.[W D

Lfz  fU
T
T "##	##
##f_Cf Ўfv  P&к:FP
utf^fNfV_f^5%P[R%0fu)P)V&>V'}F &h&)`]b
àff  fffffXcU14 &6f>f>f ffgfg`p07S 9 󤾰T%7 a5P*hFlJP,8SVW08fQhqYÆPO2uIqVth7Ɠ 5/8_^[ø8cUPRh<>?? (CU*C4C:C@CDC0E f&Qo j  @PCBh >ZXoCDREEPSS3G0` ػ7   pQAUpq$sO CqP p3qð P&qBQ PĀu̀QPSt!%T RVt<Vu`P%= 3ɰP<Ku{Pf;iEhe#.09s-$dqM - t+==vP^P ZtP¯a X_Pہ?UuC33Ɋoђu uN5 PV$ 83 Pf^ XeOAd[&& &߃0>t@u30Z h
t[V Ȱ t
ŀv#t̫o7ppm<5VPXaqv[uBv8v&> 㟸 hΣΨ`t߃`y_P3 Vu $h9
#iV 
 s0W uz.W0W t_2h4`!CuPӸuK 
wAW2 Q  hPδu= Dt= tY	.YW^!U h??Pf}=s,u]0<  1hU햦 `PvY L 6ihuڀ tu6if.ff01ha rLPR r IހRW3 hثÐtt_Z"{SQ |Prr	?!xxfY`Y&.BB <t BB2JݾYഐ  8uQ@A`23Ұ
Sh/YÐt0`́ y autФзi at]U [aSR  4V@`1-V1a h{C	 h{Q
 "B0PaԀa$8uXRPZ2XZQrtwvYu0ѹ }R wZPV6 U2<UI@OJuoO䶿uJu󓷧tC0f`gOX@ e hWڸ u_
3Ҹ w%mvv U
 sC)V uP[ف>D A 
谁0@t0hNy$hYX# 0KBO

dh0  ~ MM&i &&g & & & & p ݮt0p @wA:ێû0 ۾\ o
 q@0X1&>r 4ou=fSgf G  1ؙ8f[P     f 0 1]@"1]j	r>݋@sӀ   Օ`ߍ ߙ`ߏ 
 ߋ "# 
 Uuo A t&r .s t v;V tޙ "f*3f@O  f>  <  vPG f) '@  wf fQwf.S @!laA`uf@@ ^&|}i~ߟfrAG #g XP
8t"{*eP^.xyo{ 0G5]ψ.柊 nA1_ >@4s Po @
Ae. ӡ u	 t \R.O#52닠&~ ߧ #=h Phqh - Ҁ t{>arcsh S$ f%к"` j j h&hXX1
ZLGGЋнSh>h{"
 tE2s 1|1
x{0y t um1
}{/  tE. 0P0   t!E
@e66ct1
@at aP`S09pv%ޑ`ߡ D ߣ$ s$(t%!R&B'%([SW&L o2 >u
g y0iBu
>@u^ >Pu>L rp-L wf@rHg0:U!]@s.L `	&O  /WQSL O 33ۃ 2@[Y_h ЋW@u$+؋BSd@>3`<u-!f[U :-tuo
9 &w@"R.t.uL 2>p&_[WSPR`ZXӢL`e0Ɗ263 &#23 G&CC2 鿖 &EfD DdEC r&uO&5G4CCX&DG GHFEG6nF7
,@X$OO&2uG&2%& !1Xߣ ב@[_0pԵ_B ҙ0iޢ 0R+ `R=`k0RSt2!{SRUfVЌňL f&7f u&Z&?Zu `X G&!Z &0itL *f&߉6  801t L "[2f^9]`VWf @  !XfA]3f0 OOf  1car_^0]WV p`
^`-ώ3~18 `4 R DTDo   f\|g 0 ȳ hz`4jw fl  Q la ( ^ lW @`4 lL H`4 lAW P`4 l6T W kX2k`(``4 ljؾw\q^Aag|\D sPi5S  vv S\pvGyq[ g5
uh XVhd!! 4v i}#! P~PQWh33 3_Y  0^PQ= `te  @fYX "@SP
&  ff&Ϝ X[@@h  @] prO  Òҗ `o h`ܢfRf  J%OFf!Q   hX.]BV+  <t. i~ tq.ri."D.|u.:DtSI^SwD:Sr5+Ss&Sv;
uqPQj
?cb)A<-PQRau!&U$`Ȱ hcSQW@a$a  hSɿ hq3ʻOg>E_c2揺 TCA6 @QC@p4@;uYð!$h~f`p3}%f`} 3ʻ蔭Ќu6fa@o.oh< pF`u
dBt"_ih[#:0mEzf`f`	  ߢf%=Zwh3a 8ڲ/FA@k>L:*&}t#Mth/}Yctb uu F3!d ʺ
  % hVWU- "h~X@ #F7sr&!# úvhr#0 Ջ׻ 
% 0_4%  0 й`qՋ`F%a!:(PDy42XðEc t
|d@ 
H܃"ðd`PdFt`'ɬ s`a@@Q@BZPo& <`s$3	 +3,`Z `&ߢXYPU QWw เ  Fؿ6\E0*&؁〦 uM9NwN\uӃ~ t"F= wt% @+7XÓ@@_h=2Ѿ%r [
Y" 5\] ]`h#1@   !	 @ݿo a `w ` Dts&4 v'% t>u *ۨq' Aaٔt?5 t2 dyu t tf2f
 09ӺGenuu#fineIuntelu 9Ё` 33Ҋt/.;tCA9@q.Gq hCfff.CqfP f .f.6Cq5hEѴP*À@ffaWdf@`i  {,@қsP$[ Pf M qi q` p%x
%&%&&Ī&&,)|%f<``^ ƀ6#PfQ	0fZfYS1p  0=u	?~Ѻ2A<73[ñ ԰p!wq/5G(}%0 (ـ&;+:'f`hq#%8?r600y&1r_2s1=@AA?2s )q#0T?fa>CtL?@f   E3AUI*3E;L  M C"%N'% C< B<DPODQDQ@Q$j PRR
	 ff3uf? @  DaU7 U*tU`U ^UrUU~uP
Q/H 63@ @ur~T uiQ3[@.[;o]n<#___	~` @gZu؊؀0h{P~tM	ij0TkPjFrX?Zr  PX@ASQ 32PEkpݚ7, 6if.fffȗПfWh3
fX 
 `"	  "	(2@2}	% 2>a3fPA{ {X|Azh$}lV@{v| }~f|#|n}fPfQU}~T}	v ;sQSfArP1"|`	C2fƃ 0fXffQ
 q}[ff{pY+vAq_L2_& uZ=PrUf	% YuCf*b5f=  t0a t( f㠟ݟpf
	0"P`ѦuZd [԰Xk_EhZ $ni8it1

36x @ hHmF F hDCmPFXt5 i hn#
ﰳ&Eh3ߋ

>t. hpc@uKh? ; u!.9F% < tpt
u8tZR 䏈05s2u  w & PPXt'vt
t@  / hmSͻD% r/o hmP>u  @ ohms?D-&>! rrԻRzspZthZmuul	r`	߹ `+Zjjw bv6u S`` FF phm ru
V@ V&  3>t !$!~$< uһC` 
WN<̣2<ģ	$ܣ"桻3`A.7y1ưh[@u TYP=`Ft 
u`2Ɋ، Ȏ؊t<u
۰Pȵ3E$<u&w $tuۚFbˣ/EL  N L ǷN ؠu û  t_  P[Eu
j jGgI(!!2(<!`bv՝ Psu$0Kt]$o~t.#K .t4&^<r&.wPX3.\  U.\E.d b P p W	x .|U_DuQ&~% PPXӹ
 ~.:t
 ._
vXP%8Xr6%ȸCEa    PJNL p      QKOMp @t  t P(.DG H hs3	g hvChҵ	 h	 AE^  ~f  %Pp m
 oʂ 
v %&.|t&ư
߲&r"܀P$Q.:Dt1KuR
`E(@q" sR	EXòQ&`31C `H 	rU
r`2h!mٰvaVRQSh7uThm5<SJbv.Ā68u,2
t&6@t2 s -ޝ[YZ^SPpcX<?tFhSc-Ejjjj P &h<\ hc$f-b.t = ;t= Dt
hGm[ vWVS
`q
y[W ŋ4u"q2*Oؿh?ꀯt`5-6>J=Ot1 0ھƈ>n_ rh::p;@s;^ax0!ls:^ }Q% St-$p<pu}B 7 4 u1G hm FF0÷HhÞt<o÷IEJuheS#SvR? s   3'YaaavP?U~?8afm  u@"t@"3P&&WQXfu33ff&3 u_Fȋ3sm0װ{L f5[QY?  :NQY2  ?AQY%a 	c
1\\\r\FݿpǋVW 2_2wFit"`2
u
2 ߅
 @ۭ2Ei2&&&Ef&e?
td&Epf&&ErhfEi&E<r&}	rgggVW^2`^2*g
&}vkP㠶h}PRQ3{`7p
%ptrY3RPSQY[XZhXp$au5
g@vv > EQ W)TXY-7:Ϩ tOz$|
G*6h3/&&  t8Vt'V u G,6\ m˹һ6$@
$ & &_& E1 p`odde`P`  XCOU @2
ڹ  . BdB把8uGЏAЏ;Џ5Џ/Џ)䊺Џ#CBЏ󍰒ђG66P怷X ы_@ApBp]Cp֐ЗÜVtvvvvȰvv蝊`<;weċSXH<wM3ɆQ#"XR< rYыƊȊĴ3Їуڕ 0E8`@Ihu@tJ	2fvPⱀk 2Mѻf&׋. "  技&k !< hPaЭu$f&PBÊ$
 wu%ϊqϦuh$߻档b&@Pf  f#f#f#f#f#f#f#tGOfPfSfQfRVWbh</f'P&MLxveff
fhf3f3ɹ f0ªQS f+f ! KPu*Pآ$>g3ہ^gsV4C\`< a^(_^fZfYf[ft3hK/
  `"`3hD/LtKLôL?21tu*SNg6 t߀wt	NtuG⻹ D
  au|S u
2t	 ,Da`M2 揀 s< |&	3yt`S`u յ o&#;-&t
cdXKBC Kernel: xx.xx
 ` ؾhv    t? p.`|3۸ 2ҹJỈx%aVWQ߿Y d_^=BO` h:3hq u
$<ur r	. f3hh/. %
Pp#tdw t
ha+gTPDh.=  t^bwY-s.>{HfW9? t&ܰYf u@? o w> c ZFdAeAf Fc~ck7~e uQ C9  h#.
dDF PhDBFe:Ff`Fr,  h _Fd8;  Q 	:  <g ht%h!.haf`WpaKh5٣E u>fB0((;SCA[t$ a h>N r @tf"   F^ö%P XSĻ  y ,p   h[t(t@t,֥ v,յÂ ' qhz
úߋwv."ّ**5ڴ/.եڄ+Ëؼ Dڊ/U2NfQ"dYF :uE1t]!1Vt
t
u
t#u
tN `t"FFa0 &u3! :5tFFdz ulm'`)F: uY(P)eb + )u6F1,*e*+FfP)f6/`@up  jjj(j	R 	UaURvohN#112 ׻  dp15 hDZ]RZr@q  t0CRQ QYsY2$
a98 !u$vi55Zf`GtB`u#I誝: *s! ƀu.>ߎ %fa`7Rt9wk  m Tl0'tn tۗoi /JgGP sE" 8HhFl3P/#rho p %Q:2B CzCZG6	!E.uQ$<u:upr"&!]tBZ tBZ tEtto ΁BP u]Vz]0SިMVV W uFѢLSQ 3Xu,SX`[rEZ	ˁBͿY[CE <ff<1`00xx00`6a{||i>>>Qr$.ސRmtRmpH~ Pr8'G <a7= {&2hC  E qorB kE
uN ?D M 0)0w/sA w0Fn70bj9 aUfV3vCDPDQD 7vf^]`#୻`C%'
#PduXT7f7<@ >> 'Ogohijkt  "..֙ f%p	@?Й6FACS@O4DBGP4HP HP088C  !CPQR  8  APICZ?["!1
 2 		0
 P񬼩a3	 2t (upPUӢ
 2Ϥ RSDT(  f`ht3hB4pf  fĽf0q  gfFgf  нFPTR ffggFf . ^$.+.(f.$ſtgFm}`gfN~$f+0lh	12qsE43ffgf&f.>$fpff(.)t(2]C  ~( ȋN g&F	0   rg#fffff+f+., u4 .?> fǋ$$$P Xff-QñV3g&fFg?f^fY[P7!ff=TDSDt+St#PtSBStf=CIPAtf=PGBDt0`7Qr$̏< ur0:bRUfQъ̓2 tSP/9rDr v~;ɠAptg&P.XJfY8]|efWfVź`Wf&of.@һDq@f fPҫq)Ȁ$ 4 
Ȱ @-@ff	hUΓT$ pf thfPW %fX ԄpF gfP˹. ӑ Ӱsg&sh5`@(Ԑף_5V	()+ ,|r +@,f  f%=  w@ǟDb^\RW D hث"o hN"_ZalPSWtS`MafP3h f&L fPWp"Lw fXp\`h`4" 03f0l&?  5 6Mu  ` 0OGNfa3M[
 P@˶1U1  P N>N&geE E uMM0GfEBtXAt$OAt32t)O$fMorþ0mMe&NaŻ   +ø@ E7W Ǌ	f
0lh@^Xttտ Eƿ@]E >E''w_Fh5ێË̌ҎӼRQYZҋh*p\f`FF  h4 ]$upW hT' w1$w1U(w1,w10w14w1]8w1 /qcÃ9FtFfN11F߿> hɀ57957(fa`C6\Ep13ɊMhQt?

h}B搮;r\ua-WF. _^0cf fN`фB 4%CNbf.9tu Ftt_h rfQPH_Mrf;^uf;Nt7BCofAtJ [
tF~WY_ɐ\fV Bt> j.<t1!;uEha,,`RR^_0aMQ0R0 u,hQO..D+h}ZCuS^VWSRQN, if.fa؋ȅ1Z[_ؠ8fS!_ftA"p]  u
3A^  t'gfy@_GhGC~G$<lDCOMPAQ PC Card SmartcReaderGEMPLUS GPR400?PSCR bccdeLB REFLEX 20e241 PCMCIAeReflex h v.2Tic:!cr$jHPbi  a`@g&O pGd uqp`p ȳ rLfK sr>qpG	 .WDa`
qpPuO@.d.D4fƱr_ PQW8 0V
G.g&:uG`sY.5z_YXÁ8t P Fg`sۧfWrpt@̀gHtt
t*tttt#`G f_` S[ ?u#x  p~uq .u  Ў~rp&tj`␊t_& rT  r&= us P6>
qr/r4.؋Vp< t ^OJs 
t u v 翸  hDhCw@繻ВqZ%Hh}!Óa-1q6rP~tI	y |
|p
tQ&ds&¥GYwV
z? +F؍vf fDr +A fLs-<_t(<#0{ hL?^<32t
t
u
hÓtrt
<0r<9w*tM> ʇSQ Y[,0>E*SQi;| 1tu$Af`"3p& thYӜ֎fvhs#gf9t ba2@   tGh:B椝в@gfVff3EЀU"ѽ1\Rf0f!
޾k3۹: 8tCrP #t rvAhqsf @u b *  00` K? 0    0     ' ' $Ĝ 
 / %b6\k0`3\$  e k"1\
FtPS_.BAVW O׎Ǎ~Qr&} uLBr	Q:=p_^_r5#sr!|r|E@&=u	о#ЪHr&E$u5
_tBA@ӆΎޣ ϽrarP҈DTtr&ge ׄop
T3
ÅK$S	0r# t itct t$ް[ffL ߋ]J`ߐWBQ31]
+Ft@+oWЋz  Įr8uA_QY_þkqވL[ r&U0X۾N4LC
P$X` $2LRnBa<t`HސP|8u6
uB& DBldt
[`aa@ 3 r/) r?%BB7J 
 ` ; 5 aù<t
6BȰJ  @uH` B I2۬2  'u+BIl&2] 8uS\u rq@m riP!~ rañ@ tAc rF n r:i r5&D@u-&
$vQa> Yr	2QWY`BA Br
p8\     r     VQ    P`@`;t
YY ^NV^$TBL$PCI    P  $CLM"    4$fptqfPfSfQfRf3f f3fg.}	/ 	@ 2 	fƀnuo 	nZfYf[fXpWUu	  	3`r]aq 
#)C
ERXYgc> 2Q`ް(Yùm `ù DaV  .:u.n!^$5f_Q8aY!fQRfCPt
' "`
Pv
"O2ɵ PZ t"
ǆmWPfP  ؊2fl 2QW pw	t2$_Yôq3f@
%S~` [Pp 0X.
tÀu@u[Pf
4 	g*f8 *a,Rff~%fؐ..+.;w
Z
$Ue <u
`V`<12a2@`|<z@=q<@]Q4f<	@}4[<
@4P<u@4E<@=p:<
A47/f= uffX<@7<@7]]fW f_2spPuf_QRfVfWSft,fff ^r!fp;tftfN77  +[ff_f^ZY^>с 	 r?prf r ;u*A
`A0BBC= @	ҠH sQ;tp_r"R{L fR fZW z,X
[2JʲKL .ZLHM	NKOROPffqM# PMLNKSc RLOfMUPK_S+OLiZXV>YPsZ(SP[SfT'RXMf s#(` sf t` s	a t
 `QVWf&? f&bﴉ3.fSP&Gf&_fXf[ ` }`p _^YSQR@>fPw&fd P g f;t
fXRv39W
ffff_fBfEff#t߰k f_TCM!p߀MQ fu`# P"f UI8s2ہs
Z*SfW`@)6-y`t#uP{aHXt}xPC[PSf<t; /30e ts
Hfu
utǳ%[`3}aPZfvl`_X1e'$PIR    $t` a b c $ b a >r i  f}0 c j !fphGhktt`   0 `%;`0MWff `p
dz_nfnf
f`?aVWޠH#gSikWĒ ;_t[lPmF[_^qWp!f` f(u cfffGfY2haϘ뙋yPC
XPS fS[s$fR
wf_fX$s[ؒfӠRq1%D Ð[|ѠBS22E}r'} Ipuf 8p8s?Ҋ
XQ iRP
t0r?zr#bEvpE  uf úM % UPfPCT".0.[fXZsoKf4._  tp [bM`_SM]fa_f]rff}r%mz 	|&ngt@..%ıO,fEѷ.&8&2%ѷ@"ѷD.%Ш!,= sMrsb
üg2誱߸_ 	f^ i
w t%;+:>*f0mk 	uwARAv *)u_6	R+	f;N`f f{ 	Bg❊>?r>?f?> fPDWB< t}+
 t
3β轮 	r& 
A1~ذx 	Pc` ;


!vVz~^Îf.RfJ)HZRUQf fuffVfK=XfuNVFYQku F{MuY ^Y]9g><afPRg'QSVfNVFfL^[YrfXftA/3PX|Mc"NWOKPhUWV spP   _]`ph/WU鳱q3話蟱!蕶鋡 ]]~BpXRVr 	^Vc~3   	 /Oo /Oo  /Oo	
 /Oo/Oo~@ q /1 `P a & 70 ] z '  p!@ @ X'  " 0#0#	 K 4L   $
 t 4" {%    	=Hewlett-Packard 68BAR Ver. F.12 08/17/2004&*
( _-:. )?.|./ * _,0/8051Q)sion XX.XX  
 
 `5_26.0# ar @ =A  q U10 Intel(R)6=0  @PQ<rnal L1 Cache? _@	A2A	
  PC CARD-Slot 0   www.compaqG  
	Ћen|US|iso8859-1  
 `5 J;a@Cq 
;G&tDIMM #1<<1
L:M/O2P i@@ 	p@rSST49F008A  惡V ?2py@To~sw H~惹
YR:Xp@H  h~*
@8 mpyPrimaryO2/8s1~]HMultiBa_`d1   cgr  kg 烀r !KENDY*	

 l_n	;dddq"Hlim.No bat:@Ay71"_rs80UQY[걄MM$<Naa~a~߰WL.}
u.:tAu%t>JrSN.[t`N.o[u PtP	t_M_%EfUv"v t ArMw .V PXF
Xf]h@ &A ϴ2j@
ô nâu\OVC=VMc.6Áp.t.I.
Lj@s& X@|wu ^SVcёD.d.$ʋд^[Q觞sCjrcOt`	OtOtLtDMt
MtMtϯM
u	.<ԋ.}h  ÁUu	?U QP0RÁG rfL?\Љ@Zf{ ۥfP<r|wfDu
 uXSQ0uP؎&Br& ȎXMߋM>.>鐯`詻u P1a 3B &Gݾ&G $ $PC&I (US*B>F &g0&G1&O2$ 2&G AX {&?sߴas=   »
 ff&GfEa߿ff &  3SRWPω޲ VraEjmnLuRE<sofQ M}3۠ fYr/>NN.  EGÌώP p./q[Ü^_Z[QWV.>`ۀtG<tFr=/1.E@.&N>"L@%5plَɎٍ6N߹ 󤀌^_YSRCt5ێËfQfS.&Gf.Nf&_f&_ PY2pZ[fUfŒcSNf]ð48@΃bvگۛ|SQuP $@Xu~"޹@1XUz`ߜ$S௣8`tu
9$`
, f1.1VtfQM cM`Q <V`V <W`U  ^PT `9af>}f 6|
s >upMƿf>fa`@J,Mf 1dMOMfR.> ucM R1uZP u
聆_^ZtQ{V_ ؾ3Ю> `r. u   Ê؀ˀaɀ3r
	`[UfRtf r	`. ]X]bU p r$ D )")"Β!#)"#)"͓#X|P!Ґؒ
ri%08Ŗe2 
()"˔&Zeܖw(^H"oyP
4P)"5)"E[fWsA< ufDq,u#謄Hq譄@f3gf&ff=SCoAF2䐤f_U< 
 	<! F ]W  6<w&< t'V3ɊȈCF 1^ t	0+_qQRVV<v^.
wtbΊ ؋B^Z{ Ձ$ %"],5紉UT"P X"sm0Ou]FlFlA$1~@a%&Fl>>iji>1?f 11=	&v&-+((i) qvpQ"$!~C$Qr2t"S"*P߿/¿ 輿["2ɵ"rY$F$i$$O%$А232~3$%R%ffPf~#fP34P#^] USP sX[P#<crh# .4#]uESx 
߸y055ǰǳSz L{ 龳 ~ ᾳ پ[xr
1;u'$$
Ȱ5 A
ȷ?PMa1;\rP@;P)GX{1;_;r2@;aDGȋȻ#bE5r, 3D7FGf5ؾ!Gf]P6f\GGpK$Kt	q8'sSP	 XP r_X M< 踽 u`@@$u  `uP
PO󪽿N1Nh rgSx[t p!P<@<X %W-<Wҗ@З PWfS`['oF`[[`[)&\/&<`]I&&&&&&&&''!^SRWP<߇0 2%E  .a  0LuAP`   
a a ka pa | Őd d =aPސd G ƐdCh 3|y rt&roMjrey r` [rVj rQ rL rG rB t r8 r3 .r)= r$[ rl I r
 rlZs_MP	P<t<
uu5du
0@XqXL1W@;ZVNXts	u1L>1;9߻tt-<v<ut1L<r<

1Vtu	SuPws
{z|PPtèEv`s1L
t	|Ev``s| 賺tSuUtt* H(]`(?(()1)))4*rf%fRUCESIf  `fAuf#s҆fVfSfRQ<t2f3r6+f  u g> ta@x LripΒRYfZ^G.g,@Y0Z6_|fR#tt
ar,цfZj@Qv/{Q8{E-Et(Pwr!fh)tPqz%A,%6 t1g&?0\NQ -QfR ff#ptZ tu
 u$u t0Zo@ntjP/|Xr`ffR f݊P7%rGfZ3 t@$
Ê௰,$_tHw ZYf[fVQ! fFYf^PSXr_n  [=X9$rޯO2B}!0w@@^$r?6SfP3fX	ش  ápf~W   _pW
t<5t^tfp
p fP[r
3Ҡыû  fPFKt
 ;8uBpÊ$W._T*u	 E 
yj@)Ӏut&  5& )uQ&h!zu! À8G @΀ Ax1PRtYQ@vMuG	oRu3RuOQ׷tuQ t0> S:u@'8*6Rw:EF!u E@Ҡ} (AtTt̀t߀wEtH7F )t%> t:& tSuE
u3é@S1ז   RE׀>Iau	PͻX!u`s3 t&XtsىsӐyE1 ;uBtSC03)crӀq gE3+&px3;r.Dv+WXuw4332s*Bu!.ð-3 Б	2%B<Gr<oSvƠ ,Gk.3/]lsJ# u
<.rLu2cܐӰh%2KrӾ0l/?;r1<.t<+u
0 uθN<- " uJ,0r& 
06 ;6 EÜ   ì18 q
 tr;ø@ i &g +pa @
u
fN@0p]ϰ2R'u0

YYS\8&&G&G&G  [ !000栊p\&\~@F0 ]
..03 ( иP_  P0
C@pXWP@_<w3tPՠ* O $V !! & X _蠹@Pp覹Xr $!q!    R@4f K ufQ?fYg!%q[ø <Ȏ3]Ou 8A*2~9fPS=Au@c;Áp u39 u+0?wufP@uPXu
_ff0 [fX%`{A2{N{S#{ 1111{{1Q 10{ 1211 13{ 6t!{{U6666-"{{ 1
(<Pd3 4h4444"5~5.&!W<r2ǁ  .3_Szwt 
' t r
1u@M[e Pu0^r!<u	rr&PRC`>s" r2.32& r!Os  rAF`qG@8{0erPB&& rr	Ĵô QSs+&' @>' sMM] 桖GY>sQ
u>[@ W r%PB$޳K rB rH	L puG H" $  ?ĀPm :XQGt sQ@CtKdt`vK[pt t
@uO`YÜP`
 2:Xr`Q ZP`[tDXdYQP Z3_[ t	`K^`d$!<!t ^ c>@tPGXÃ3ɍ6L.L&.:Ls&3Wo.DNOo.LPos` fgr2-jfffAmu K߃B^mf 3t@n@]`
u! kI3ұ u $S tQn>N.| .N u}xw5x x Jsw}uL艞 { u3}p{uvvbW{_tURQnrwUoboYZ6	u>^
 .wD+t#VmfLm^ 
m.Lm{ f]Õj`Q3P) | Ys. u&	 t	&Uu" ώǍ>P |  Êö.f.|f@ t  m.|mA߿P\llPQW 3Lm_YX1WlP%Ӳf_WR
Mf;t[вՓf`Ȁ u!s0g uf t r<uP u
  faUQ0UF @E]ɿ< t<t
<tN~Y]PA@oPQRrpvX
ˀؐ?uA2@~ ^o~~/ZYX3xRl~rgf5޵f`X a_ 
  _Q	Ъ `F/թ(êS@^@fa3qВR} Nff3u
t"Ppf3gqtf'F񐟲XTQhS3 gffҷf ^Eq}㓁եfPQx9!}Yj   PoipTރ0t2r 4100߰qtaq$w6 >?RPYXZP <u
XPSQRs귄3ɺ/ZY[P.<
X `<i.<=iafV`fQ

u}	r1o|r"0s 	 1{af^c`*2Ґ$ԉNT@`~W F$
&FGR&U_fcp˰n{0ø 1SR,غ*3% Z[aW  Mn p_aIZ@  mt
p РV0)؀Ӎ6=f  T쨀t༅d^A^2Yr$<ـ~m`&`SRW*׿OзI? 2 衣IO3_`QԴs{`@ Y4ёH3O5C/3P1RQWSP $< uX Q5YQl` #vsX J[	u襢X( V_ m   P9[_YZÃU2<UuXADYJ BB3 0  iurp!u5PP  ؎5X 
u	 ' ت *ê0 VW` Dt!WQ`
:t
Tu8v
Y_IY_X?Y_^Çq.<  Xtj~ u#u3pqt$t<u;73s./t;A聅aaB,~?߀@HtOBtGBBt9t5F  Fqpa
  P薄u<I҄rˌN.TV
0h~u
苄r.2^.lnLN芽}?XPV3f	'O	O"O<$OICV	PuLrx 0.;Ttq""t`
<t ""Z#Q#HϾ2C<e3"3[RP ZuP#u|~'9|
('4| .|ˈ@3N ,"*	PH X''tOTVy0O"r0/I/LcL@2Oc膃%| >|'q`<Z`<u
 @&   >5@tA 6Au66P@u  ,9& X"7V6q7  0`O_  r
6"7 P<Fu u7s	= "7u~6@A]u	 X >tGTuu ?6FtEDAuU2rPRtKxG3DFt& 0R] Z蟤RDuh2 h3I
Xuh_BIX&  U au@ 6YBEPrA]u8Err
vrr d P迕 dPǠ $& 8tQ  PQuSAR^ `"ZB ?p.`*ƓS: QFR8TUAR0Pߗ @R@wXa_袜SaY𒁒nt+ 1> &=$R&}F}I\1@\07r uU 7Ȱrl^`1_Waba a0baa_&eSf0 ff dfdc@  
dOUd Ff=[u%f%dFd  " f&|  | ru9fCdoh 1Rdph f%dr >uj]_ (!w Le d蛡 ᓁ@ffV 3&=UtZ0sf   f  g&Ng&r5sE v &ufރf&& Àpi\f^YSUh &]S^ ][C&uxDf&DPg Vf!|ay|L
^Ɛ} j@ t PSYw'[Xu	
wɈ&A 
t,ÊF @ N
F&? Ժ}0Qpߠ? $ R0Єr#}&\
~t`u8s蝙QquB@YÊE *F&dؠFP=GPPt
?&>  $> p*J0虦2ø fF !؊恋@0Ê~
~}~}sRNt >A  tї	Y
ulug]p䕀πkNrHBp<}@FF$t#9* p }莥uӿB tSGw}с.L@G `3z$ ăUu\?t`x+aÍ>L.}
t"Х	
t>"L .:?Ut 05 *KP֋V tVR_~Z| PpPu-$<t" #򵦀}
u^^ Q  |̸Ys3䆊k tpks2t*zRb5.u 3ێێZ
t "uuq D!
 wОuyA
(s_uAuᶴ0Ps4XPt)&UzVڠ"
[uҶc1!u/Xd@@XpI1şį dlFpoypOIEMAG  IZ P  ! i 	

 [ cHDA-L  HDBNA-E3Ce~ USB-FLrCDrHCLS Intnl  PCI-BC  % eO_ZIYYX	UP 	/<M iMpcvMٶ	M BM` @ OMܔ ?\MCD001EL TORITO SPECIFICATIONį߱kO.O<O%O  A " * Gxx x y 1 " *
xx 0/ @ Gh y\8y y `
b é u	T ËE@ذE
U` t
 	r}
 t
	r xf`Ai2tW &  d_&E3tB&U
&{]@&EG tûOk
u &E!	fa$PnP!d6P WP ?>P  fPff  @ fXtfUf{P~[.Ftg]`rfw߂ q?rd{fߝ%rfX ]ge333rVd4Ad^;sgu0
30
\s M ptAt<V_r0dDgį}
^PVW^gEdTg}

}gE Ptr00t}d8tPW<ytኃ@DrfU@f]3
t Qaj ' {f.;Gt._
upfg6$+' +kÑ#1d|rP0fd(frd&砉+ 
dMd5p
%V d|@&<d;]t}d|dz^UP~vЎF^葈r ~vFUn ]~ ,
 X ..3
' '`, F`,p1F/R3 .;v+GuBG
p1F/ǐ4{p1% S	0`,Xv1N2Q
} /0ʕ9NY5%'`,50123456789ABCDEFS+S׆[*578F'()+<7 À v5uAE`ML `
x_t^t]t\7;uAEtFRA@5rL3< v
<ar5<{s1$qAPɎSpXuVLôr2հ"lr9_2.k uJG$JuJ@tE<zw, [닐CtASA	G`@t
w
Jkb2]k_SpTLJ, EKNG@C<N2a@)PF
 TG torBrE}	0M21@vPQCs	} 貞	bEYX d@ B C EV WW=WDW)V7Vg]P6P t4PQ37P ]O
]!
U6 uUO3P,pa$跒a Pb$SQ>4Pu5Mkôu% ݨrqd<3۸q  3Yc{RV[O&=P\OXmGict荨t#jz>s=Pn\Ɲ< t3^ZOV:$cu fh `rhf- $Zow~p @q4rfqruN7P4P߀6PRuxN@
` u #m $$?a@h@ & 'rw 3uN.WN3ô'~< uycwLذI<u	.Ww u<d t$\  !tuuxV $
4 |SVd@ x7 y}< <u[S0UNNNO]OؗPSRtt$}Z|PR芐tHM4ZXó}2
|y$蛌cx|ӎ#vj%U uPXdD]<t
 r
t!d8D^uAyRWu>g^gsrT^uvA_Z|`|&
yt,ـt&M1&G&aLL`LLAAAKa+Íu 2ȃt
ࠊѠ$FKuWQ`u	ۍY;Y_죮usS؀u (u)4 `f  [Ã.Lt[6Y	`Ъ2h2 hv聎ts@[1ѪӇ0s؇"stes
2E "  |  p+.D@.D
pu ``pr~[&&D aø0  ` j  J&߉&E` :3Լ{h  "~Ѫ QPD3 ѴXY}`.\.Tώ>P.Lٰ`Ia.D`IaQPƌXXF68.ƾ}\\\\VWƆ\\wFI_^ø  Á u<s/+UUuR<蔰pwRu~ PWs\}p: haF"Bpphv hK"y`h= v O? hy~ X$@<@ @fRf  Q7p\Qf+ Qg&\f3fZ	Z@ 2p n l #ډډ0ư #  ՍȰ΍Ǎ2@ð
踍,܊賍謍 ސ$zt ޏøx
⁍hаa	Z2S݀s s	2 P  A:`3	,{ނ2@  tN : t`@팰
،$
ߌ$ Č ˌޑ굌$߂⼌õ]]]^P^^^_gSf3[ff$Rf
f?X$Вngf	ffߋRc%  ffnfPRWS22f RrzS #Lu L8s܊[_ZQWRfP
t)'Mr 1Lff  u K8ufXZ_fY}K4 3v K
tK`tKWQ3KrKY_ ```aaa a'a*a1a3a:a<aGaIaVS3.:^`u._`KPu[^*  )F.`2(SF fp+S.g`F[C3N[
QF ?tRs`sF2~ tׇY0%7,` _ ø8
ddQз`߀ #`倝$ $SWoQ  ZJptуPY_`C =bBAbb)b>bJbWr *Qanq羀PqÀX$#G dvd 갿

qq$e0"3	rU[Xw!mqeqj2"	X{qZ(#4	0"D	0"E	ZQRPQRdu6 aԀa$8uP& c!XwZZP=4 Q B<ЯYuq/<u
}3nuuu@c%uk/ uf*@++,Шu@8u5*~O4,-$cba2fPS LogoTrapInt10h ۜ0ff.cdO:B;Restore;.cf=y>EnterTextMode `uohW# pքuh.	aúB  ۴ 0F$Ü.cWeeeeS  A  G ?" y 0JqK KaKtKL8y J@Ka'R é uD ËE@E t
!rQ t
r@/f`t+W   d_ &U&]V&E fa3feee>I   "@ *J G yYZNcMTO?FcPPQ
MQ#RRSST3W$ 1UUVV`W &E@oӵV
W* XP  P EQ U V +Y  +YQhQh  U	 Y
 +Y +Y@QhAQhBQhC  
RP ?RQ +YR  cRS +YT  gRU kRV oRWlXQhYQhZQh[Qh\Qh]Qh^Qh_  ^g` iga gb hc 'hdieif Gli	q+NdIɟemg}
3gE
 t"6LDt tDw>u[gu
sU I~RvLLw 
$V&wE
@E } } }FǿMuZbyyz@uQv>v]>Ĭvtf` tOXu (4$
 ,@ô%+faVWпt*Љu$t $<ȋ}f`T%iW$x w%r+l$b XWfVSQfVF! Os^(2۹  <uF  +^D!8u3sf^`WАVQCuK
! В!xw $I^:u:\!ut <OrOQf^Y[_SЩiӴL.
tÀu@u[れREaV'脷$bd&nLÆ B X8R ?2<&$!10ZR)U$   `$ XPRZp.Sط$0<:rd u[XÆH q.= kq& V@:<gfFXRyZÜSt	tv
vt[ÌȎ؎ Ѝbˋhck#Q.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSfUfP XPR0ZXZRP4 _ XZfQ]ǋfŝf]rPm~nR%Ǻ,  .80%@@D3fZLZMZPZI  	      J G$ $  GN N  GP fGh h  Gt trӒ   G pkG   Gy@0.  pK @ q\y T f`0D0%>ffty  Qf3>Y,&۲ qۣ>ڝ> t>1ۇteB<Y>pB:!fRfW.Hqxumf3gf&<f=SCAFtVG t"ffff Wuf(tfPfwfXf_QAU<JXMROK;^N0)f    dâPrfa> udo м  .>P'G@e̸@<r p at4t p掊E;2撰fuOf=sGq t;
t#?ff f@hfr߸ +r> SQW*dm rqa.Q3ptrurr
`r`PB䠄t"
0  0u!!t0 &k X`9g pi &  L
zdazI	@" q\NyCOMPAQ^$PMMїEp
 ~
R3҄  FtZ/ Oo "/# O$o%&'()+/, O-o./0124/5 O6o789:;=/> O?o@ABCDF/G OHoIJKLMO/P OQoRSTUVX/Y OZo[\]^_a/b Ocodefghj/k Olomnopqs/t Ouovwxyz|/} O~oς/ Ooϋ/ Ooϔ/ Ooϝ/ OoϦ/ Ooϯ/ Ooϸ/ Oo/ OoǏȯ/ OoЏѯ/ Ooُگ/ Oo/ Oo/ Oo/OoL<p\6\==1    <P]7h *1Ձ*݂1DT`r(D
@ JvArHvA.=sNfj@&t FN aR3V.LZr# Mju 6"Lr 0t 2rXP u v thr&3W&E0r" r$2vRs ÆUu
FUF ôo	!	_	r@e"!E	p脀^F&?s $s& % &G&w&G %OD
 &	G'fPfR.Mf.u)E	fuf&)E%*WE+b+++VfQS\f[+fP'A fY^f& u#f&G0Wf0A1 /WfZfXP'F~r .>t7@4Հ4/r?P t8@4 tB4 t@4ր62wrV7ʀsL	08!9L~t$@:t@:u/~ǉ~ %3NV`<3se;^<Í6N.|uLZR..L`>"L .:Utap?LaPWQS?ن? t0.}u.:Mw#.;]	w.:uwPCw.;w	Dw[Y_P t>ـ?Br.u|
ՊGc)Ѐ ʋ.Ev p$fVfv )dDMHF؊fH
@NP@K.eXfPHBs$
2H
{-JfXMIKdDMOfPUv]f^PR>Bê Y Y Y YZXRPXuUW:>_]s*r  ZP$<`Z- r!PZ@Xu@[>[ \@<@`ZPY 2sXXt^y>/OUd_ \ b* 2bq[1[   PRPZ> P@ !f  XFrrPr^rT:rOt :DvL*D۶lP umfm@:
u
rP
l
u2 VWrd _^ rQPk&:Ev&Ml&*QE9m"nono@:0o,rFonr;Z@uxfyu< r
tCpr&tpu
fZf\r r`pR^Xt2K uu@uu u2\S ذA[X$D
>X`HD<7Ba`t>;P	 C@@p$Q+r++YsapXt!$!"桑ZePZPQȎ@:Jr#@:Mwq>lt߸ A@2:Tt
 YXÀu_OufYQ   <s& ?O E\3 >N}_uЙ L 
 LLVWf<u^<
uu ME<49<t5$S1B'[|u w|
7|P5u5 t\_^FS}
uӝ}	<q.@ )򡴢܀} "a{`F0uD~aBtQV 3۬`+^YD0!)sGc+fA1ff?/bffJfmT!N
O2pXpf F PXPZfP~t$=r0&Йw)0EfP u1fu@:Cu~EpSVj|ttt
^[PfQ
  < 5@ f	t
` va f`ff f.f  f@.$P蔤_f  Hff#f+ִ f;wfg+3g&Sg&c
uff+f@-X撝faf@SR+6=$XfPWXffX{ r2ǜ ]XZ[RUWXb[Go_]rQt	rme` ]<XGKGFBMGURfQvV ufufYf/Q=fA<{}1 uѿ !ρn Oqr.V sfYZ]Tf;`քfRff;fZ`օWf!P rf=rf_fZA r
fSހ' r#ߊ|s
`
M<f[G{orNrBaP_X(Par P{PSy[ "2񜞩rSEaQPfSgfÿf[fP ufXE~0t ft/+f #fSff3f:X2ZfYVuUY t?4 7 3 tpð-΂@WľWVp fSP~WB Q Y_Wp{^0 l豚st6]V! <5u G	F^B^= ts.?
<5{  p9~詧"Xf[2PmX^YɳWfVofĀP E''r&< u  &` C f^Yô Pq谏Xs[ 0u   a"?_a"a"PY
 $(Y )ð) tA*)SYBHp,-Q,u
 O/O$
Ǌؑ/OO 2/O O$ 0q2O$I121,)b
>-/4 /6/-Q38YQ
t
t
{ ;q
= <3ð&`?e)"@b7FA*!tt	*tEPWQyWS&\W"
ǆcW[qWCHW <t<!t
<._<*R?`8ZQR趩su	- Z)- ð  
VP֎ލvS<û	 ا[rX2^ë,b
J&KJ!b
J-!Vf0q t&r
Dq,a ^0K"Ft|U|U  $U<U<U N^Dt"@EVVZG% Lq7Z°\LL[0u PXðb
QVWPPULwX_^; qRU0b2!cPh E Nð8dS@r} [t+N`PRXG!t+:%[߰ސ;	0IJq
2|;ʁCހ
P'+ Nf J1B踦ðW+fV
@ ބu>bt u3N@f6 VAp^ru{<@2sPrN\q ShutEuwu l 5vur t!t
wu@
]]f^ϊ>ߊ?A{>?V|QR>  B쀇_MJYP|  P R|SRrrذ}@МPSpJ[X 1t;6M6 As3
t,=
@z
"=

u5w<t<u? F`<qS $s
Ê& 
pu[<ua Cw\wWQu& 詬` AI蓬`'㎅ϊajᎿY6 FF';Pst@2
vPF X ꏙ dtPpwqD3 qp	
t	u%  pؾg ,2O   m$PIR   ? $` a b c b a  i  f0 c j a"phGhkt`6   0 `3. W $p
_ϊͻ 
`aVWS;tЮt[ 
D[_^PQRW3` &Q߾ 9tPoGY&h0y_ZpPSQV@b.  36.^Y[XM 'u SQRVpۃx 拔 tcPtPv>PvKXS}$x$PXr$}FaWuat!P$
BB HF{JJQ4H^ZY[9P 2XPUv F t	F !Ff ]XbX
WVY.GF^_R׺srD.\~ SRǊƝтp oƆϐHȰ`{W?`{ˆ`{?38 J//밇`{~S؀u
	[P#ZPqϐ{Xˀ{b0бС0f( a|Baς|(8|qWt_wZwU
uQrEt> r2
 C rRݍ r [  1!} `  S_22
uC#r>bϱˬq{rtrG #/Lr*kr0
 D_r_AǀCcآ3e 
  Pft3\N\Be\Պ$r:W1| T0J_#v@ORGH3Ɇwt w ~J}t$AJB䄑B_32_  _SM_ P_DMI_ J~  #f` tE# u 'F$
$ Ჴ&0ô#fa HМt$tW	ȋº_f` u1A)$蜷蒷 #茷΢$肷fa%	*P'@TO OYeʠ$	!L  = s
ffP`  29
Y[$

	fFf ;N8tSFp> f% f @&W t0@ "@Ц tr0Cx fXQ`RV s Zñ
d	ҿ$g4bNW!ff`4eA fu4faf(FD f 2fAtfFd ^DF* s fu
fWzf=T3#)fFО@F(NbF, .00Qf3C rBrf-fv,2v0hfN,-34(U4X4(4$иP@/N$fFfV fNuf2N 0
ffFDlf3fQ2;f ;N xf`:<`:@Qq9fYf#f#ff 50,fHfVPf#f@f+f;FLv,LfFPf)FLB*09넀++ff+vw8fI2|,p?ù Q20@wf*fPFFfof
Af@  5p?XffUAG +EP8fA+K!0L@;Vt
f5APDDĳ-
 P8 f%;" P8f%; I  @"	 "ؖ+FQP0B~RKFr?@R, P`A3HGev`f`SӶCt1Cu	ƀQW 
k[BSɀfA^QWQWo߀@8 _Y[^_p`  
 ߀ P.u
 @b@ÜZs8 *PQRfX@+3 I0QQ@RfQ+%SHP <jSIMPLO9jMO?TOROLA7j@B2s4~ЎHg2r"H &
 &s7n*morqpgp41VP1VSrnn1Vo qƊ˻ʆo >9.8>;%~p{=p{?p{A
p{C8SR}&
 3-&Z[>E7>G7Q~LWPL~a~ t
y@ +؋~IPNPPPR﷩PTvPgwm7o؎&3&M<S Mt6Ŧ q6ר
6^VrFw0OUxnxYy6*wz!{6>{ A| | a} }6Q~~  |*Aq ӁOcTa? U6 - U$  1K6?UA+cPq
o>{&~X^u/K<|Ahh,iGjmmll;qmf <c ~<~c u<c l<cc<c%Z<	c?Q<
cYH<c?<c6<
c-P= uX<c<c/<pc|]WfPCI 2聴u_= fSt$fѻRr0GptN)" f[_^fZfYְff; 1r  fu쀳
N`$u X . r pPtRAZ茳oȝXܻQмZiػf-мPXZ;`9fuٻRɲZ[ٻPĦZ񲓽F:f"ƴPāfPf s"s t s t  QVW&= & s PH&EXfX  _^YPw  ;t
X2 *W 
_ з#t*X N sRQу 9fBPffff8s2fbYZP3@ Ba{{{ݯA*qAAݰJs@PpmFF
]X `j j Bv
@ )Mf.N. JtI F ~rp3؊^)tuw t&Du.^^t<a.@t&ڃã.^2ȎP36t6^2. @ PSF@g0'.:t	tX._PYVpPY\ÁUUPغ     < E2aur-s(@tH rro
 @R@dVvF\r:Gs5&DC H PrfyQ_@AFÉF(t S^$:u [r
F&F$%&=vHH&
D&d̠u rcwu
 !πϠ'&DB êǪ`k TVc@ HUrap评1s!
 -su fqt
n E PF&G )
V N8tr>u rG mo!F) r\ A{r=H r8rWsTs#@Rϕr
.@M
a|ۗ`k@@dF("r#Qlr@rk2<t fr1&d&KV& 1f)&t N.QSWeu/ r)v t!ufPs fXt)_[S<t;3f}Ñt	fu
utǳf`f[`~p.OPۋԊ܁Ɋ`ef<P   树 X& @F$$<r$:u s
jút좌 
   @_738  $tVrF.^ uDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F (P<$<'E<&f$`
ĢF f%$`BG B<(0PbfF" PXۋN8NwN o2N---!`GsH-ßGHmIn-{`
 r
sHаmr77u&-贀_b"&&%'Á3^bR&u 05/t36r_CE VQB A9O9 BY^а 4s
3
3u3`Y,QS%uèt?àt  !'&V&T߀ ߠu^
*x&u^ô  T>  J@Q@vXuN%&:Lr * r$C`J \@uа<upZt+Q.@ -h; E 77p+$<@t-gA9Qj9" !$!$wQj`BoU0+0Vùg
+K<P[bз#*E.JfUQEufVKʴrKfXfugfPwNPwVPwFYf҃u&gfFff+MuY2f^Yf]Ë:R)QSfVffLfT@DfLHf^[YrXt	A,PXøM$øNO+QfVfRfUfWfPj0t3  fRfZ;Yv_f]p{[PfW/0tQ uU=P@XYQR   P`YXPt
 t$0t tZ`|t׳XRfVFtf`F*TVSQWf氶 w#t {r0{ Ԑr	0{ _Y[f^QWVKǑ}^_wY!QЍW2! u[ك!N@ňF R Vv 6^N  (&VI>󤀚R 
^~1{_fV3۬
Êw^S (e -r $p@SfV1ًfa[.6fff`;w	rf;waf`q2PS. " Eu ~Цf%4?^oAR0e$''ذ1000= <r <3fȐf
ffsʝf   f-   cDfP W>p	3&G;r_pSQw <m  `AS Q	t[c )exfsC3    )4e f       PSVз-//߻߻/пǻ.u/܃&&^QQ pf(s@ Vŀ @ (fYXRP!qߋ
ԋ@tXZ	І'	P3@g
Nk&A;u0{ltgR't$<stu	<t<ta'y	蛋FP/1 1X߈F逡a0tĀuCF <ra0
t""t<t} @ u;Gv <t]<'wV4u;~ u$<s?<w؀<'s*af ^YNuE 8u| w&|u迺 tfb tBbt tPbi tEab^ t=t t.~a g@)-?ui @G F 2vP	 X'u /ސ[&F PuXutЉz+#
Ѵ qA2fP  
u$, 3ۊ^Ð;tMNpB,$<p**
BȊJ @t2a12P3a0P3Xú0PRUff ZbVW  #w:_ПX`Q @a뀟tAtP}St[X #Q ~PK<u    ;%$p? P_aҴUWV  Ј` ?$蠈`6s.A;u uj /SwFKutA8 ы  #иm ;R^_]2SC7# p 3xu֠P 	u!Q   VQqWV1 4A ms SQX0p5b #u  QRW H)$tu_ZY'8($)$*2+ ag&uEuPPu膔uZùPPE EPP runtime BIOS - Version 1.1  
 óýPwĜ5^jzņŒŕŘŀwU .\] :.W8.;W;cR.WPBZ9QR_;Pj<rt2[:$ԁ !Ȁ
? >>;"Q@ .<:$QDۆC[Ñ<Г><u:xuCBFF USGeHF.GUSHV<`FKEGG	L&n״ ^H7H TLJW<FKIaQ"Ol _`
TJT`UVU99SR<C<<rF
 j ?G? F	r
t  =).> @.Ő]@
o.]9PQR3uAB$A@3ɠjp"R9 Zðx%@bV
yҤ`<wR.`'ðbG%Ë t@u Ê
t jh Ci3PihpR֑1 $PQ
&FtQ见uG&}pàBbt't!&C 0tt P8 û@ ۻ /Z>N w!u r
?u am`^< u'' t	3ru`霐@x (&ysiz
u`ˠv )߱2x {]<xB~{Dtk]І}H~E@uKt? T} <`@s /VttD?R 5H I+.u2@t@ߡt@<t~@Xt8't
 [lucsP8tKTu<tB>u3"$
03"q u)  f"   S-
 g-3"$"P3¿x X8Ɋ  M  G G`" * y 0> *
/8y Ay bWc q'IU Ë苻]ЫpEU `ʋUc t
"rǏ෰r} Nf`JRQW %  d_̺ &UYU &E! to&]ZФФf !0w! " Ϳ  
 ް  XPJXSPPt +. s#. sXP &   &X[ó5P϶.4EGO6Oa1pσD
 uj@ t%v v t ArMv .sP-f-F'N- aύ?6"L 3hr r	
 (|r
	u^'t %?	xjA*!_tr /50r[Qo
u< r<0~"N@P \!u' $nvPf<0@
ݠsjs>M.u.
I.
MȎ.}u tj@&u |t
` ^!N%V#~Fp2r2P8 s]s6< s
	OtE""Lt*$O#Ot%" 2䒸)1ˀ ׌ .EF2Tѱr]Rs@Hs1I9 <$uw2d*<#"< u<}v<%2 ÆUu
F!UF%y * ËF~&=r&}vfP&Mf&E&}Cf{X§s۝Ӏt^Ë^6M3F'=rfg	DEԺ~(LuTMs fPf}3r1>NN.  .GTǿP :./ jV#:Ttp<~'t9pY0֡EE&NDDp%p5(}~ 6N u0fPfSf.Nf&]f0 [A'Q:  &r}辵rxtMrlErd|tZ+r@ u~ (um-VƎދo?^tVffmrНFr Y蝵r)2r$]萵r(rrd~pq rw
uߴ fSfRW ?f.Effff±
USffs̊MF F

tSuNff3ffVNf.W*f8f'w*f'F'*2t*܊f
VvfVvF_fZAFsQU n E]YRPXtUW:>ɶ_]sUr  Zâ '_2 HBPP'Pюً{ Po^CP_B컊'SQR1p cڳ m  གྷ轶 # L #
t #P Z^Nz # tͱHr{_| rv=%>M= M1S>MK1ˊ, c5<s-NO8L`pd" >MG<#<$0 ˝MZY[!PaX ز ?k $²rzZruri8NײrWxu
_2ع (a8讲r.Ǵt%ttt t	sSQ1% szrX	 2P!R7e F!F sH<)t<(u;>A u/WU>Խ N]_ӓ=r0>Tʞe`1`0-?^'a@1  l 2ȱnPRFtNw+P(X!Н	F
+#НF
t
K
PK(XfS~ t=~^f~^^~^~FF
!FFF  f[OfQ
tW 8ؿvN^~nNfnNUfˈNnfNnĢU~*Ċ^
^maSfYTSQfPv j 8rC5sfZRfXfP!FfFQVv%ް跱EfXr+t3`1 tfZf   f+YÀL@E<fu$PΎq2Nt
.A^@ fF! PXk! t<"u<"tV3x 4|gQ&?s0< ls& m &GunnGwn  @&O &O@R~f&GT
q1rqWQsQҵ qqW*IqX> QVW:W }tNuu .6 u/ P?.	
?zy ,6p/o{OGA&&d&D&t&DE_^YXVM} "`uxPyN
 ф^ ꆱ?	<`Sp[PS3}[
@E̀g?Xla@[!W_a2c˿ǳПû3@sɄ3ɺrQ13tP3>bݒfPAMSU!VW  ؀  p#  u
  
݃1߻ʆЗro8ɍvm F0@8& O@8
 30&OWa5FU wnYy_]v
 _^P1TבR1fQW f`1w h؃`np MB RW Q! D  @8&FGv@uv p c :u#' ֩ &@
;;uQ@f3ɰ ЁwVp;u䢮$& 3_ZҩGF< u u2Dӕ ZsN~ t
S[aO}ð =NuBP P
u0P ff  Xh;D ᑺE 
qvݐ҆Q-w5"r/-u4 $
p r	؊YYfQWAph fdf8h   ` ? f uH {pl f
׀0ā rMf[5f 0 f%R;tfЯff   XfXpA _dRfxpffú̸,EZP=XfZ@[pP`d f@u
f<~OfAQ@ef%
 |pp]B_"3@$֐9Z`fft" QBY pffhfaZfrӿ c3fftf Ou[ӡbpQѧ؎rh
2 6rذw8Du_22f3Y@[p 6; w cbS$ ۜh ̓͡f.ff Ϳ! f6gfFfP f$Q <@Pqg ufX۰AP!ۡ ́Ɇ  ̃ffa WryQtp gcrQL G B = 8 3 . ) $      _Q?&?GYѕ]^ۋ^&t` $uG&uFw` t` t]uw((C)Copyright Compaquterrporation 1982-2000-All s reserved.j/w*VR@ ރ|   t.Z^!VP  .1BBBX$JJJB@P0ܰ t
tJ Xua0b1@V tA&q JZ  _C@2wu* uP= ]Xrù2	=`1  F (8SQ2<

2ۆ.
$v2p`1<w0
u  `P     Q
! YQ#8  #$#PRS%@&+@&;w[HR`ݜuaa@uXXZXp! / PX  Ü= srsu+
3,,]{ _ _߸^ P1P?Qwt.蹐0! /0諰2ѡ]ALq.j~.b;a/PQN 3۸ K `Z'  A G#y 8P8 y " ËEuŀ}
$Yurv`tW   d_ua@/AOBoCCZLZMZPZ18 p9@ @  G"`:FD-18 FӉG H  O  *P9	G%18	p9``" n8d dc"F18  #Ga acF Fp Gr r"Ls qsL
OrEcNw  "  M
 "p9 +O6bS  #	K҉
tXQtX@#Oci0,}`d$!<!uy
ء\`&"&& x<u&  V<tr^@K^D]8t( 23]']v233.f>"A"   a0b2ۊ࠿( ҊȰe) ǊȊ&) "f* ߊ*g>+bCfgPhf>,3gߎPh.- gi) rAji..jijPg?Rs=}DK   F  0Q Q"FPkX nf`g =/يu (9q$
qô$
q#qqRVМ`uqt
Ptp$t@^Z-f` u'=Ptp$p $pup$pfaR/`P
Xu!P<Xu @P輑}t0a`
  oP!@pa  SQ q t$Nx<t.1u
<v<s<3v 3>^m`fVSPoX[uP 2f^@#u Y<u,fCISGu%f»   f .>2 .2Ê$uGuô \ S3ێۻr?43' u>$SMMu>?X dPu
@uXYr 4ʅras\2&D
V &DtH  
B r!`rsuEF.`2P6e$D%rOsJڙK Û$?rr
jr=PyϞZ @FFtN fF" ʶppB@F(	r22ۀ~ tp]{  t3ҸK3  ;w ;sbFVFF"F
 F)tЎ@r4F$
Ft+ F p  !VPпXVP"aW% u{@ZX_'At~p'p$9q,氻.3۹ 3Ҵ./@32 3ƀnuo0nݤC/pH<HI@J꼉BUWVRQSP36x @ fFfsEYc ,Xu 
<t<t$< u"<w<vr,2bߗ? [&\@ N [[YZ^_]%u9<u` aasroP`tNð
2
t
޲8u[À>AA	t[
u'q &L H[sƨu	VuQ2^ ˋ
k[~bي~\ك@u B ZtGKو&A J
*my2aeawъ'u$<s'ذ
"[2f 	.c u}-QطM
~Őq`t
тYd >ZtP u pN> uGt$p<pupukYЊ'FO 8tWG."Њ u33 	t<uS=[u8st_,H@>50\> pd XϷ PۂB st2 	=3u
KuGY&> 8%T鰫+43~u׷ ZP5Sַ5X_SYSID_  1Y _UU! fl f@f="uf3p fl PSS"
ǆZQ2K~M|u.=

P!02	ѶRdtSR@ گZ[`Z[T蔿i uH

Ȁt,O s0Piπr!W
Z0ԻuW==s2	fYeRذfPVeOs۳
B
f6p1@MS V}ԪxQf
KvǭhQ?o Rt%Mdxd׌^pu=7Ju8z	
ً@#2| $uP$SUR!u<Iu7Gt gQ)#5 $.tۊʠ{`3Z]Gp5XU!+_sQ߰ ] }Ks:%+Kx,qQ,Q3ɐ-Y=M -M>rQ-4GYs.`e
$- 3Z[ tx F߻p75,u6ݸpٸG G5u6:L @;K 5V4 :N Ӂ=M >s6)
7
@2'S C8BBaaa$at@0 GUfFɷ͋N
~E F Nu3 I'JțInJJ ]
 HRQP~XÊ HFFYNZ2PAP$NQȴY`ۋ࿤Qp aÇً t"0Ҿ & GӡU.&a'@'W濆QR0w ZCV
 p| Z  X@O` XYZð
U 
P Ðy~ S{r{ = ufh   XX؋7[	R6 ^   _ _Q@P^
pS_ 	c`tae `
hUЋ؎c]Fa^WD3< t
AF wa_`~= *Pjch[hiPN\$Y9SR^Z[` $<u 3 0ؾ   faqq!r3rrS [cqc}`wPwVQm3ɱjAY^` 
aËpR0fPtf
 f3fRAf;v+RpTYX0GY@_ÜPUfWf@XиMfW]ԭf_ff_]XӝÁՐ`*U3.:f{H:3u<:.V.f] u(<sW ._.  2P$<Xs׃2Q...&+.	  @ t^T.&u @ u42..
twW5Ő*
t*İ&u XYP3 QP0 A3.G
XY0m3 *.ZbpWȎA%;)_4| ?O oϟߤ~~~~l|8 w8|r8|8a|çP<< p  <fBBf< }x<fff<~?3?00pcccgZ<<Z >>P~~<Ыff f { >c8ll8x~~® @ 0``0 $ff$  %0xx00 0 lllllPl 0|x0f 8l8vv ``0```0  0|<<f!0p䵑 0  || 0p0` x8`̣<l {8`' Ppx|p`aRp Q|x0 ?ff|ff@lЫl bhxhb3`=2f>  ``x pflxlf bf  ΐ8l_l8`ɞxƁx/pcʀ3x0 `̀@ͱ`x _ƌ2x``x  xx's0x|``1pA8l`ˑvQo`lvf0 Qox  `Q9Rځ  a̰ pA  4bvfҷ 0|004pA!0ԀP0d 0000a1qP v! uHf SvN ._2[]`'
fPQRrx>@  t&? ZYfXppTpWpeMAY9Y. JnSS  (B03P2X`3Ҁp Āu NP<tDqtQ_YRBqr8rqr
2:6 vqZp gaQf3PCI01 ISA A BR03COMPAQꊙ 08/17/04   
  r     ˸ @؎&м  ; r' W@ P& u_SV  GG0G hv  8 Gu 6u t3  hc) 
h+rt & ^[SO
&hre
h[U샿VW ƿF F   `i2 FD2ED2E
2E2E 2 @D(2E($
f&EvPZXuf!tE/e.a	 ƅ @.<t	db>t <tjjjj3P S.wj5Jp$<t.<@t$t = ;t= D hGcv ߱  7cFF~ t#^FLr
F Fa(U(~ t:]''kf
 hr*F)'2(~ t
)F_^{Qd!
hRs .&4/udu   hr$?wط2hkRhUC4hRh	1
 qrf   f  f   gf&Q6..  1w  Y`WVe1E0&E.&WV .^_UUna<Qc< 	`@.e1E0eE'E.U s߲ Cm2a h
$ǈe Du
g$Q
a3QCr  utw
t1w
tAPSQW33۹ G&./JNK_Y[X MMMc1@M@  OMpM dB FO MMxsQURMMd* &  <!TXMC  3Y[MQVWh5:u% p uxK1__)  | = <tam;P09A9_^Y!JRW`  Ê e
Crr3ɺ Qe܋
AB rN _ZMSqe =Y
ujizjU zj%1 DE<@1p;<<1p<3uU """ka#t
#m[VfPfSfQ f3fk3PXfffDDG(	Dh fYf[fX^u 0gO G߉xQR@<3ۊED} 	 C!~ҋG4Bi3u fDf3ۋfË\y
S{  	T U S V ;	O	c	w		`h	Ph	  h;	 hO	 hc	 hw	 h	 av.L.< t)F.6Q3.PF.h+[+V.`.^̋] dF. P!.φh+Xhr QR  16W  0"mXYZ#[  
\a_bA]cvdb'^;b` Џmefgh qp10GpppQWĀ> t		 u		.	_c   O idJ -ww~C.{e
/e
@m_noG`L3۸ E {_F߸^FiQRrPS8[X%hqQDЍbߋh
            ?_ 	?
_
 ?_ ?_  !"$?%_&'( )*+-?._/01 2346?7_89: ;<=??@_ABC DEFH?I_JKL MNOQ?R_STU VWXZ?[_\]^ _`ac?d_efg hijl?m_nop qrsu?v_wxy z{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨ?_ ߱?_ ߺ?_ ?_ɟ ?_ҟ ?_۟ ?_ ?_ ?_ ?_  ?_	 
?_ ?_  ?!_"#$ %&')?*_+,- ./02?3_456 789;?<_=>? @ABD?E_FGH IJKM?N_OPQ RSTV?W_XYZ [\]_?`_abc defh?i_jkl mnoq?r_stu vwxz?{_|}~ ߀?_ ߉?_ ߒ?_ ߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ş ?_Ο ?_ן ?_ ?_ ?_ ?_ ?_ 
?_
 ?_ ?_  !"#%?&_'() *+,.?/_012 3457?8_9:; <=>@?A_BCD EFGI?J_KLM NOPR?S_TUV WXY[?\_]^_ `abd?e_fgh ijkm?n_opq rstv?w_xyz {|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ?_ʟ ?_ӟ ?_ܟ ?_ ?_ ?_-*p! -   i    Q4 %	 D0%&T8 06W (0800U8808@0U8H08P08X8
h 59i  2o =i/!D##&/&O'b  )&  y*  ,  .  0  2 PSQRй Ys hPv ZZY[Xg&ǅF@ۀ988 Ã tfPfS
u	0000<0rXf[f}X:g&8u-g&
@gf&fB!??BfP+g&>B9g&@T=SWVfW=&2>X>*>f BSCtfGg&D= $"F<vwD"FCG D| u:tHg菂ACDB'B_^c=QRfUۼ ?} 5tR>0tKBCt!?E$fu
PpNANtN0OqOt	dI"  }f]ZYp=PSRi 9uAC.XrAC&PCTG tuVb0< `M'f5 ?*bX.bX2Z`8P A; u
@:R[3 t
\=SQV3ҠOCICHC  :OCtzffKfIC?As8_Y8ta9fF*0I8$ЊBb*PX1JBr=u2^Yf[PR 
 ZSR;2<9ޢ<9zhS2h7rZSixi8jħ

l:A.>oou	f 5faXEf`?frqs=psq|r^fWDqaXPFfGuE fqD$
BDutv f|uqr_^Ye=fQf5pf7pfbutf  t
gfdD0q`~ |rfgE{{A|} R=P{VB QCffq FFt
hZS7gvu ?>t!?6fӢB qBf0KNf^fQ8SV  ^lQ  A;\LA;t% BA1 0*B7>	uHCHCY1MV
:s  XBTq$t=f˻,|"q@0f%|@Uɗ0d=QRV&<0	<0&L"L"""01wxvBfDf% ffD?7@^Z =^gs0f X43ݠ|2KÉqd,\"\l"l"111&12wş"K(X:Pf 5пsf
p aXfff6{_`E8$1h &7Xkini8jZS0hkZS`8S [<O&A: oZhhR&0<[Z8AJAaApFfƲ:QfRVEu/:PN 	 o 6`58`9`ʣ:Uo0f3 ssdTpv!?!{@F0FfC/;P;˿_i'z#G cj#/v;&7Ơ_ cъNuթ5e{ay脆vؠ@Nu TѓBC$U^fpSa=}001?11SAAP0G^lD	%ÉD	f@ƧoAfpC<v PfUPf{Pfff!	$f41f<1 f	<1f@1fff]Xo t P9/1f!1r _@8p=R@qӃf;3Z1C X;>0 t! X `<*
 X0<CL`Lf;0tf0f`0 8z";$KicjXf uogf ?EM{> fù fgf;t?)gf+C k@̻hix`d/ 1_y *Ra=K9KPV`^0`; ^=X0;0u0;R	bf. X50. !"#$%&21/-,	
9
+ '()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRS ݫ?_:*86T M54	# !
  5# #U4444!	 p 4$44q!p  "!"!3  .>$ %

O'o()BB)+,-./1r12  S@ hB&Bc;!Iru
w>Bj @O7>r6> S!7tBBB>BBu 9BlpWCl!7r8B_J@990*ZBBBB賔7a64 ?I`6l3ۊ؀`ZB&;CaA^B;<CZ3Ǳ@PB7VS@t	T0"B [^KVB"AFBFFFUuDhS¾0BBۭL	u5&SCuSCDA߀kJ:Bt_b0P[gS> @OCS>CC>OC]&?Cpt(
ߠB2B0B[O0PrlVt>BB r1AVw%VVrAϊ&B#ST40XSWB8<ƀ8k [HD4EtEhG3E9FB GAPGG<pYI`\A*[0AC?GrAC&PC]BCCNN0RV1J2e|))_rhC u 8B $12B迌g&F@v@p{HsPkBk8B$l[w> po$3@ p%u0q'huQuvtrueQu^w\quMq&#su:+8rPu)FvtFvtFv@5 ,= IZ^QXp8!u	g&|t|@sSAX[P@CAWC^U]»A`r' PNBAAABBעBV.ott0A/0W> @BSRaH<v
hHC,bICBʀ 7RBƻGmr )R艵@F1FRcAG]oFBBB:BwPA5
a t
d1`x `1JBrgo&htBrC
BrAr
 JtVŖxintco=LQ2ag>a6՚WuEP g$PSXPSZaH,T UB_{%AA K} "u3Q Bf3fÇ" Bfлf3Q^ C㫉PF E *   <Fu@C3t	Dt<Hut2KtKn $`u tP%X!=C !7:C uB<Ft<Tt<et<t<t<Rw*<Ir&@C
2QtK>? RKA?QuYVWЭ5tAQ ft(PǴ:>Cuҵ0 gXfCYG609N g2â>Ck>Bŷ=C0Bt&<C൯8r ҵ>@t!7w{0$_B@CB2 Bf?pt<C:<tSQ@Aذ oY[pu
?l!21ֽUqVWWW*XCopyright (c) 2001 Intel Corporationf_M  Q;]uhy2 yMfޱ2f°v t;ff[0t*ܩpt tt@
   0L+&_%f_Mqްhj胒)u" sfsMfȸ &Pf%mܘSf?qMf }00YgfW`;ugFsM aqfgfNf!f벑FkMffgMM
ffg_r0p?gWfgG@SktleS[@ޡ!tY uIfgV8~N^fn f00! u&ȷ0f[QSfWfVUf&Yff{3J_ffGf;qG<uAGf=_PR_u	f=CPU0;u>pڭ ځ0SuAf=NPSSufOffbk0v/8f!0{0	fF
f;sv}SfFrff3u "
f$@g&@@
	fM6FH.JG	"0)/f Qe1yQ
잡G
f`أ
!fItgJO_	S
!~j
_D̱f/E.!BQ.f_.^
utd&ubnmmf0(+؋{*@7f+ֱ.N20F	hs"":f^f_f;kMwe!cuA1J8t3gF`2g^ΐ%??pQ0z 	 @ceM" RR!upVte kMJh΂D FE u`jf3pft5f6_MRڡuRR  Z;`Cd  f&_MEuPh3<u	P!%RG$<`<0u_$ +HQ`<t<t'<t<<t$<t,[fMJB>= JO1) f=ISGuPf0sg]M  p;aRt f6MP>fe	0;@[j
Xf _t6sIC0:NB*"UUg IaAU <&}!&>pC#fw+O"<	u<+P2fN'`PeۊfGP@^.>gdɮ$1s&& _ `.@\veZujI_)`@ ld<(rl$m	p<I1)`rde)K,1puX1m }_eWe X@\|gf'dP0Fa/􆃢eef{0kiu`K HM9NHtA SDA2?Z h`UqZY,P,  ]}n
  Nn212)

A
 wed &d   K.@Je,U#D" `mۗ"ПȚ-Y0Є -> } %1 6ћ!  ꂓ§ 0	ua(1q0ě-4%(a0/4㔗 !j§o _,LQ}t
 2r[%Sp!1qU1Ĵ&D!ĵDaζqRӨhBS4өQ1Q$$?%EWCDmHì6C'!1/)!ĆU3PmF63'tq1d.ɡʁvA1ᔘ:#)9+a+D1ѯqAրY&
@J&RDHsёq`%#t@!" ,SXJp&Q$hB "8ì.D<C0qS
A㰞' (#
 4!	l䓶@
@J] P	}  P  8Jkؤ8Bo) `@ q(Өځ*
У%@a 	jXbQq3
$Pcs3D0b1&xiq	bÚ֖Y( [(R"Ѽ:`,Ѷp LU!'q'$D!D  qq&q&?_($q$"DD q	(*У(!4롹w.')*1'$4 1# /Y$1QՑa	aq;(jq($"\D!3aVq'O o!"&qqa$($"$q$$aa$ q("( qՁ!DqD|"'/ %!$ա$!ߥ,$U'6d,(!t@a+B1b8' <=%?2?r$$a?B\w=av  F HFPSQW  hihqi_Y[XPR P4K ZXðLp@  pG i zVN YfNgPKYttMQvRW УxR`УxSУyRУyS [yT [gP V8Y RZeS TZ)U\)VZ8W\8X]:Z _ NfWQf!P gf&D=F?Yf_c dD=f.cog&D=.boe.D
$.>Xo.%
.D
or.% .>botcbcԹd2eggVhhsdo]rL!md
hJr93ikk|= USBSu g&|=rti j`ooouoгm gwarFr  x8t(Omhio0{w{j`8ezcsgSh0i`kiqot P}hIr? It5QfP}cO.F1G e{or
vcCfݻ!RfЁ^qf@teH.\
؀g.\hK{`vr|~  }`q}h~"phuϛs$vjϒsw{}W3ek rCk g&D=Vx lWy /Dk3Hu㒦oSoZ$(Z}(yQD7$|!N=%dĝy
OD$$#$F`e.jϢS@RP2  ėh >Mu g&``T=
X,(fʴk&`_Gė:.6oo.oo . fPQ f.>mvmo f{+f!R^VuP6nno +.j?f.6jek[pfAl YfXIqrQo JfaúWߨSBϬ譕*QfPf!Rgfk
fXYrλl aS׸GJ/js⻡j`GODأc`l=3 oMt*Mt6׵MtBoD$
ƈD5ƹdAl r
rђҹK i%t-Ơft=fT= t:tt h[PIǑjae~ށ(uVỿrLeB@M=@tM=tM=`	tM=`٣Mh3I6EfaPSVo8dtdw mepy_P}YϾo8DtD$ aew@ :p4^JSQdO	8t`g	G	Y[CN@"GmG	`G@ xab`oCaoUGF!F !O'`bAGw|(}}}{qqgxgxjkl5mqr1UWRQSPV rwtj `ur(ffWRfhMD !E fZf_ uƥ@QCaPSƵpug@VoZ@Xo[o_Ro/ ib\] Sokb_^ Tod[XF f scO t  ^X[YZ_]c Èqoto P BsB h fdabu
!ro!ddfdpodp>p6t
d@ddSܐQ
ro!soBfU}	f]q,>@u%ttt t	tfN tF Gru@>^:s
@136MuoF ėD
 SfQVUt"×tMـ?fPfDpf'f 'T3(fffXs@AyuptLuY'f3f0	 f.moNfW).*&mo8fw*fF*2t*܊.&nofX^fY[̠OCDCo rԠf["p^f4"5ĀuDrp^vNox lhxlԠjSQVWU&BC tBC ]_^PLS-120ZIP 250PHRVsq`a``44A?5|58Uoos
hGrgfb<tV< uWQsf]c `:kuFfGW(UEEFXX  U
ZYf`BCu goA3EC`oZoao[o BRqo79RW9F:A׊'L} tE.E_Z[M-Sys   DiskOnKey SSK9iBLFC uy @  f<x fP px _=uE"F΂r 2rp0s0w6|=1s 1s	p ?ec促 f@fPuLsu[t6p r)g&aWug&Eg&ޕ~В ؐ&' rLTf<VL\M]bMSMPUNF:A׆~Oe}PE0:p: th;t@  u amu aRpK3ހ'Af?-f`2'-!q
q]fXuײU?K  LkBLGL_M^bMTM9F: 	 `W;PR)j3Wj>ߊ#>;P>
_lnh銒fm;n 4  hE 5~~Z A:u+`^s!$?
uo$D[p 6@	 - iBd8兀t 0	v`S 0	d8t|vh!mf!	d֎dЎ0	x0@Jxp@y@y@y cg 8e ))88: : >0	fWQf!ژqY ! D5 o6No}osRP	?otAzD
$&o
ĈD
𦱤s f!g&|5@er`r a`xvveM;y %߃@`yH\
Цo
܉\cse `°y> c#Pߒr`4װh!	&Qp"W3*#~sr	aD=1W?tPֲ9?Y0q|ô('蛿rkȲHMu6o=oo 6PrEQfP^!	.u|f.6q|\gffff.PfXYer"gZYK!9*_?UͳoXYˤϴ0Ѯ¹D/osF`g¹? s6Ytd hPsCg:u`(uI!r?M=@tM=tM=`	tM=Mp&MOHejfahQV0L	;t	E ?$pرy& ;QhxO	8tg	G	s;-0 0  r    @  Q  6 00 3 
*Qq:u!0 3*@rr J3@ <B1  "@P s30d @U	  U u q3SP U? ? 	BCA FA1q?F$f Js3 H;AU q qU37!̆&3)5( 	q(31  q.Q*_}10  UQ3
 41p- s	
 3S< .P:U;) s2(U'#\&6#<4%-8s( C< ((G3@@uG0G  7B8;U&U&1N @O0p`QYr<f.;0t4Uuf.0y# Rf  P]f0 3rgfP=  v	  +v> f3f́ QXw   #!Z'!Z6+Ãw tQV@ ϪZbZZ [{ǐYǋ;`Xt./_ Q[./fRfW9@f_fZ?*r_U?ffQUT+QAcfffROMIfߺMAGE ;{ufWtg f3TPQ`a߹J 2ҀfGZYXuɃУG|0G  Cl Rh2h|t"tAo~o t	hV  WSQh~|tuY[
Y[hW  s 霃mBku'f t!vw X @ RfG9 G}GfԓxfxfӸ fU3; 4@||W0{
UȎccAcUVP`Achx>t m PU  g8@ B; Ѱ fPfSfWU`cu	fP
sKcg йhGCg#Āu`&ztPfhfT@  gfӯp% _fa[QAqifVf3 m XUfĈ]gPg<ufG!@gt!>tfOuIu0f.BgO t% ^jfYAcr p  fW
fUUx_f*UǜـϜ❋p suf3ɊjtfYPQP@{Y 0t  XQfR dr
fl fZY@aOr uQT4Pbt,fU'b r'8tfG⻻j$@hZЬ@8tpQ[G` lfQm8  N hbhqb0dc_  gp ֲ`}hB  RW0  ֳ3Mɕoaj`rK0Oºÿ.OCP2Xf36 f۹30f\0f%yƥ # ǂ2_f;Tu@f">>?.%ό%Ќ%ьP.&̊? `̴ Dʹ2α#< u؊Ð?񿰔#̨  ruU#̃`r/Ȱ#胶֊$8tFPSr$u簄n㰆g`rL_rۯG@@9a%8rބ  aQIUvPPF X P.=.;AXP.=.;X/ Oo/ Oo/ Oo / Oo	
/ Oo/ Oo /! O"o#$%&')/* O+o,-./02/3 O4o56789;/< O=o>?@ABD/E OFoGHIJKM/N OOoPQRSTV/W OXoYZ[\]_/` Oaobcdefh/i Ojoklmnoq/r Osotuvwxz/{ O|o}~π/ Ooω/ Ooϒ/ Ooϛ/ OoϤ/ Ooϭ/ Oo϶/ OoϿ/ OoŏƯ/ OoΏϯ/ Oo׏د/ Oo/ Oo/ Oo/Oo ?_
 ?_
 ?_ ?_ !"#% ?&_'()*+,. ?/_0123457 ?8_9:;<=>@ ?A_BCDEFGI ?J_KLMNOPR ?S_TUVWXY[ ?\_]^_`abd ?e_fghijkm ?n_opqrstv ?w_xyz{|} ?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ ?_߲ ?_߻ ?_¿ ?_ʟ˿ ?_ӟԿ ?_ܟݿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_! ?"_#$%&'(* ?+_,-./013 ?4_56789:< ?=_>?@ABCE ?F_GHIJKLN ?O_PQRSTUW ?X_YZ[\]^` ?a_bcdefgi ?j_klmnopr ?s_tuvwxy{ ?|_}~߁ ?_ߊ ?_ߓ ?_ߜ ?_ߥ ?_߮ ?_߷ ?_ ?_Ɵǿ ?_ϟп ?_؟ٿ ?_ ?_ ?_ ?_  ?_	 ?_
 ?_ ?_ !"#$& ?'_()*+,-/ ?0_1234568 ?9_:;<=>?A ?B_CDEFGHJ ?K_LMNOPQS ?T_UVWXYZ\ ?]_^_`abce ?f_ghijkln ?o_pqrstuw ?x_yz{|}~ ?_߆ ?_ߏ ?_ߘ ?_ߡ ?_ߪ ?_߳ ?_߼ ?_ÿ ?_˟̿ ?_ԟտ ?_ݟ޿ ?_ ?_ ?_ ?_  ?_	

 ?_ ?_ " ?#_$%&'()+ ?,_-./0124 ?5_6789:;= ?>_?@ABCDF ?G_HIJKLMO ?P_QRSTUVX ?Y_Z[\]^_a ?b_cdefghj ?k_lmnopqs ?t_uvwxyz| ?}_~߂ ?_ߋ ?_ߔ ?_ߝ ?_ߦ ?_߯ ?_߸ ?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  ?_	
 ?
_ ?_ ?_ !"#$%' ?(_)*+,-.0 ?1_2345679 ?:_;<=>?@B ?C_DEFGHIK ?L_MNOPQRT ?U_VWXYZ[] ?^__`abcdf ?g_hijklmo ?p_qrstuvx ?y_z{|}~ ?_߇ ?_ߐ ?_ߙ ?_ߢ ?_߫ ?_ߴ ?_߽ ?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_ !# ?$_%&'()*, ?-_./01235 ?6_789:;<> ??_@ABCDEG ?H_IJKLMNP ?Q_RSTUVWY ?Z_[\]^_`b ?c_defghik ?l_mnopqrt ?u_vwxyz{} ?~_߃ ?_ߌ ?_ߕ ?_ߞ ?_ߧ ?_߰ ?_߹ ?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_?_6   訋0  hNv 1 fPf fXf X28  ߲÷QǻؠР.&  "Tf>PAMSf>1`>󋰃 f3f&0Ef&E 	 qn!/
V H
Sp
 fqf   f+0MG h  @
"3qM
 hBqB 
FqvA  <H@(b4`2fPQfRWVf  h4S ?1$h0$rY  E6fP < u h'$h:'rk f3")f"h['^_fZYX"h; t.#$+r@!%ؾ%E<up&&f0a&"1)*, H6`'ft P1;  f)"a`蔅7D"Ў8Q(r&=t&} tV" &GF^9YՃ"aþY  h u0. u&z#e?e?8*:BþX  h4AC CHDbCEhCFEH CA& P~>?,1CCXSz?e?[PS1CC[,OJPRغ0 t@ZPqӒƗL(VF?DD	VFV	V%VVVFΨDD
Oԁ8S7]VF!
(
VV
!VV  ,`k7fBVF<VF0VFVVF*VFFF-FFNN~:v3az|@VF;
J4
#-A>f.]̀u!u1<yw2.P?f&pcQVW33 .)_^Y])S|ذs"?r?uӃPgi[fSfgf&;x_V4t0n?qnuf&_ n[ff[  ;5598
8;P6t]rtru%P=>)ff؏.s
*"uB.h|$@p ZQvvf%P!xuA{Fvf%fyu$m|uv's5"ud v(w/uPv`G9x:~hMF sr d;!PvhwfQfWfV4vP@gf ntӄf^f_fYSQRw_uZY[
ɪZњ[?s@ϜQ9"*à1
Gdf
sg].
  r3"
Fèu<w'>,&=ҥ$<w	ϗ)>10ffPS>+ t28[u, u&7
<ttu r	!  [fX.tU!ngtFg&G Ƨs? <u$
Ӿӯ !!nO 2f_YaPᬆ.tg&G"-rвh.tjtsuӯвp	
!8t"8tЦrB
 yIt,&
u	>ut
$sE ͩt>  u. *2t$C	&
AsP0fqL
t萷8$,	> 2
X謿9Sto .68+Rut.tC 8K< t0fS$ @@0}w pA>؀
	>t K*tΈqz`P8uA $p 艨_t>%bu
`ߴj ; "~pTtп թ8ץVqiQ2t`ͺ \,,t_h	tP 萩rB٤s?u%
`s{u"ү~ȱղӨaL蟧tzu ,8طc裤tbu; sW;"sQ8u	1/uP6u"
u1"
2S7٥D
  -
t 8V. pp*wPAt@XSfW0p@t
*t_8؊f_OQ 讒׀`ǚ@
,P@ נu @p`ῦ؎ Rf쐤AZl¿faR@n3ñk:(ߋ08Ef8 `1 D &Et^"Db$D(pÑs `crc&tȀ _$>@" 
W&t
~ L &}u??u8&= r1cr&
I_$} ` ¿mm 
 m!'!a` * 4·O  a f2 $$<@thZAKuK,qKu`.>V9sKt&3NRr&4ss^sat`@rr X ? :zC At@rk$@@A%=w%a10$m!ݨa07K)fRQS[YfZt'8rDss
| t٧9"pX*C C&
/4 D0pm1>  ~u   =|h A?rof`r`f#vAghBAf  ff \r9fffHff#f+ִ f;wfgf3gSgc
u ff+f뷽.сhS<,.02@8! 4O?! ^8yUA ?1&0t?|RF
SAӍυư/ŨA(#4j` t 
G&s~aPRGu" [~  
"H ZPQW,%L𲁬89:  $t9!RL oPfffXPQfff y0p, QhC7<Y0ĩpm0L`!MBV V` 
$WXPfQR  FTff
  hdT 33 #PK   M0K;4MT` s 3  QPl    ,cccۻcrccZf YQR$]]3^ sZ0ve\ /tha!bqbП#ffwPRQb`G% = u~p= ue`= ^= u
o``t`ZYp`_ ; 0`3_# 3fZrt9Zt >!30^g0wG0wY(0w M*0w.0wp``PQy@0wD0wH0wf  {A{A{A{,A{0>A{48@{!S!f#`|вWd  !`t|/*a3S!P>[C vS3Ө艝t>t:>t^C0@t<w>t80 @Pݜ0
 P)臮P)~a pA0t3c,ы0A>.K>EF>>Pt rc[R@<PfPЋ@ !Z>r1 c
ыa	 fXrPt
d=,víw轭Ћ$ct1@-R0x>.frǌRށ+t0P Z`
: @U  !d>$> uכt!n>@aÉ `H+

@+I+0J+@q+؃y0P_+ X+2} -
s3y@sp {YpFp3Қ:u;0u;pt=0PP8p XË6 KBP8ԫ:!礴r:Ȉ6y&Ӵ R֨.u蚫ޠ 3	߈&Q=)-ww
2Ar@T

v
> 4&2t2&ñtSRf-2-E w @@@.JhxJS ?1h02 4 ߃tR1 Q[ft<Q1 Y60ۋA f0ۉA D̩  u4pbpecRZdROh8?ǎ H    DCOCh-oa4Eԥ@4F4GײZfaPLb  hB7@c/ܢdRP0 0 0ZPrb[ .& c[B d$^PPR3O"0OC Gh4m1P4;' eXP f`.&;tP<;Ơ  t<
߱ msC/ѐXPLbqt*cdݣt-b0eqUbwC8_o""@#vcF"Z4\X'#-#r>W.y?Np#9z#8.4r?>eF4] MPXLP h 
 P Jh<B7,иޠ5Prg h vP=Ecc
;
,3 3 @f 	 c	.. !$!   1
 } _   p,
]J0
`0A-տrqh	1B7&t.f> Qff   ջfR!r<fqݹJ@r(  r wr or4g0C |KT	!"%" soǸ5!/Q 4s-_P谕3.;'tP8@וrA!
䡢Lu!&`D#(2Ð(aÜRllJ$JlJlBBJ+ZRW(O/1-60-=q._ZR  0 0Z6KQVW  _^Ya'&0&+t	3Ϭ(32034aø  0I%HLsqL"q7`#hFl%#O$2& i`:f!kfUCESu#@bfRVf\_rfpRQfff^fZUfLPLM=$;; s3،Ў~  PfXˀ`Bu   t X` rWf O tCߩ@ t>2E t t.DtSBG
 S@  [r~!fn >t_Yf[q<#ؾP ff;t7]ðF
 4M'H4MHL4MJ?fKhh4r|fB	] uOH!PO
fffLVOHVwh'Rh:XE=?eQ3ҹ  &AhYfGVU01 T>`;<$F10uE ;]^[}Vn^ H^VS= 6yD2[^Tdd9eQ e:D~  +GY4gfgjhedjfkjDh bs&k nrd r]rPP XİpXP<sXyZ+[<u P:{<\sK% o
rr#wMpp{!d orְpE oxPw6>p:'%(+(`s'r ¼" yѹ}r(
orz0p}dD{rSrdfЀe(o(((V`r .ߔD(^Q i VWQ>P	gK Y_^{Å3pg.:s$ %.h2	.KtA}"} à> u( ;tlݻ(!u!>st,ls !uٯΘ!uuV9 ,Z _谰k89:7 >Z)lV?脝 fVdk(u$C
$?< u?	qss PQW<u
%7ugg=wг_YTU7rv6xLٖE	՘akU輜Xp.`.Zє W 22Up6?y0/={z0=|!$$ðnh i5^" 0 `P;Q;t0Rǜh[XrS ƿf4?f` ?&S` u
tBƣ <_/@t@䦹XYfafPf`A;XRfVf?WfPf3ۯ_~x< t@T@M=Xf_f ?"~" /f`ظSSͿ ]&?_a .- t2耙.>u莻 $],W辅 t=> 0c- *ۀ>PuKb_pLb2_ ct5Ѝ-蓆蒇t蜆2-~tЍ;sل`]d pP&&X虘ǀ>& $du= $AJ3\ $խ9p `3 /<t+ņt& ]u
$&g.wapnfW t"
t\u}tg&G !f_0duuv0jupq>jpn&t/0p0d f`8P%},Ⱥ:#%0  t
ف  H  tR] t
  u  t   u>/uPQYX/  ؃3@ÃHf3ȿ f0f@f3u  h]ff#f  
fhD t7PY h ]P	I |`X* 1Xfa{pnQR.^#؁:auSOff@Y[%0H? tP3
  #a QPQ@

  ou۳ o `p o a8߀
5Dp6
%a7t~QI$tv p7PXfQWV8ore36W p 2:> u6 #Ht4"o hн2#3Ҭ؋h2B^_\f[pj5S}3@B>"2&S&ڱ&#>'2"''-P($Ԃ&S&*Yo ƚ(or.|o
..|67>?6 ؀ u:X q`@1La霵<u=as `uuoፀ Auk ?<s ⍑unt}=
ui4<CQa^КXrs<zX^4 4Ѝ:>4_/Jq0KC `6ӍJŬKJ5Tp5L5 QPuPPr<2sjpPhث2hThNUqUf33ɭFff
@ÀfȺffu2fRPt Y$2YfށYZyZ)Pt[Y1]]QVW .C :{7a b_^Yz`
raVbbɦ@ec<c
Wh{B`2r6h
$h,tQW _Yup t
tp u_a7_lmn5o"$(,04>JXj~آ#7àz@qPpqXDPS8>p
 Dra~̀>?XÜ  uPSRB"3%  Z	`   P
w@x 辠xw _33pyÐWw f迭_fY[X{)33 /fXb|Qr${Đa3PG
	  A
ĳ=
P 0oXk$p|
Sт
u3_
L
 |тA2Pp34
X#
p2[g.P2
т
$
т
Àu;X? fĀ[gтf
؀P0K
тK
2M (<KrK@
 @ JP)a{f@3f   fPfagfRPc'_ f@ߖPh f&>Dqft@)f%qgp`PfWf@GPX<t<t<%ÁPS$<w
.2:fPpSV91)Sfw!hB3hf  pޱf[ : P &::
׻
P:++{0 
8s0 %{z ЋȐ~SQV$<
v
ط  | tǀ>:  l$
"hS/$
-d t㋷6 ^ah73

-d
 
OGu :&ۍ:
  ߌ::p>: u
8wð"f.!,л`Ph;˿f<W `XfQ<Pã<`< me< 9
rEo %F }e0 <{ǑuP:PM	hP<.L p f? 3W_YËS0`?.<̟.<BZRΠ""
ZPwk!+=+=àJJú2ԸτJPǐγ!`PB X#Π`SRcذ4úP^QwfQS{pϫ_[X~`sEE?;D
QQ::Q,> 	
^uW%E陀}B:,EB:XXaJF>>>>>LEJF݀B:=퀟B6%>%X0.&5, .>5p( a{	wo n 03 {!}^ oj|PBf./>!}6M a>f|P-'20of.4 xPx@G lj@	????h@n@@?  @   @a' EUUEKUa ]TQTLWD\PUUU UUT T0@    T T A{U0 U@0@s2.t@r8Â79+f&_M/6g%u>uhP|4hT|4sq:thJ=
hX
  
03!4+t
3NO+t3GNO`UN-ASa'A-A-QN3AJ쪺EKa$D3A3A26 agsCu"CtOS4JsЪ_pu%CcNBkR3CpwJrB& pV9u
`Js軴0" 8P&34訄X$B"PpPBB2`H_ 2TOUV<2 2 P{ظd$d[. >"7p^]i2 	+]?UA F}F 2 2h³3k70K`&&& A4iE4563FF}@4FԠ9C'Sk r㢋CӐ|r<w;Oq<@aQFiM|rP,u# $ #hcW2T$>pbR
 >kN{TabC ,LP?1I wj`a ZۿNN욿 s0{$1vPDF X P.D.D.D!XP.D.D.DX+Ei&+E+E$X~TI0S8rddrS<dr
㳿d2V Ct
=w W`bt@%X  0uZZZvZ"`ZhB1 
]h]gp"F賌spStƉ|VaaP
$ b@P @+ gpeU@uUA@gP ghj?k_lmno pqs?t_uvwx yz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ǟȿ ?_Пѿ ?_ٟڿ ?_ ?_ ?_ ?_  ?_ 	
?
_ ?_ ?_ !"# $%'?(_)*+, -.0?1_2345 679?:_;<=> ?@B?C_DEFG HIK?L_MNOP QRT?U_VWXY Z[]?^__`ab cdf?g_hijk lmo?p_qrst uvx?y_z{|} ~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ßĿ ?_̟Ϳ ?_՟ֿ ?_ޟ߿ ?_ ?_ ?_ ? _ ?	_

 ?_ ?_  !#?$_%&'( )*,?-_./01 235?6_789: ;<>??_@ABC DEG?H_IJKL MNP?Q_RSTU VWY?Z_[\]^ _`b?c_defg hik?l_mnop qrt?u_vwxy z{}?~_ ߃?_ ߌ?_ ߕ?_ ߞ?_ ߧ?_ ߰?_ ߹?_ ?_ȟɿ ?_џҿ ?_ڟۿ ?_ ?_ ?_ ?_  ?_	 

?_ ?_ ? _!"#$ %&(?)_*+,- ./1?2_3456 78:?;_<=>? @AC?D_EFGH IJL?M_NOPQ RSU?V_WXYZ [\^?__`abc deg?h_ijkl mnp?q_rstu vwy?z_{|}~ ?_ ߈?_ ߑ?_ ߚ?_ ߣ?_ ߬?_ ߵ?_ ߾?_ğſ ?_͟ο ?_֟׿ ?_ߟ ?_ ?_ ?_鸻!$SMM MODULE -- COMPAQVERSION: 1.0 tǘ> u)SDuuu&g !_ \sD[ðDB$ ht隿v r
8 	t .?þ
yd<v A
R; o"-"cF0\|ӍυlF2¼;-A#4k  	{{<  2PKd; 7@7d/ VQ6yDY^PV{;ty^Xf`ffhO	t$h=p$Ūr> .<t
.._/!N!!NfafPSRV DA1fpr  >>?؀tU.$p!`%/tA&%
 &N'N=h ^Z[fXAqA蝿ArP>4XPSWRh	 >L u&E *Ou&} ua.Ca.he	tb.,Z_[X`v-߰[h	$&]r
n %[hC3^%3 %^5vaðÀ>7 uCI¨ t$<w:9h%	R>wt"1:t1:t`1: u 
ZSfQRW3:&:;;d <L_ZfY[7 tXҎ=Ys蜇jgPP=W6_@XC>> D>?>ø  PRBZ0DQFB G3Å0u$H` um    =  %Jt0 	 	aL
  3  ti  ~MV ".  f@@u.2hN	)P Qt
RR=0?@TUKL胉?PH@F.0N!(7NNOIO""GiXHRY.$Y!HW$[XOYcZZ!HfP3f&T ff"2,Sv-#1=	 .x.tI1_a.S.>V9sR2 hP	v r?vf r,wrgr rtB=u
pa.H1[,k te6I,@ ۋ^SF ^ShH	[^n   9W07PQRp쨀thGCft
/ZY)E؎ffV p d f3 Uff,.v8vv7x"U J\whFl	fr  ff.4 uffffO~? _߇? _ߐ? _ߙ?_K`20ؾ r-*   Ȏ؍6ć Βar6ۢ {`ݐ1Q
' }#` fhp9f`PX8  G ] @O  COt% r  PB"I#AO(A*A:A4A3Qvvm
 !U)f@F0qw , .
Z)`p !012 ᪻ ۪oY kRq%в G`YP @   NuYaÊa$1x$
a1xCPBÿxCҿB;ra47	
 )Qww"U/3ۓ	~u  `v>Ų#Ã C#U-1}fayC 8"P8*h > utM&߰O %LLM;t D2۰C%?h,%0Ë؃3@ß t/Y h	a  P4@D6sL
 <40J <aE$<r' @grgUyI	$ouP fQ T hRb.
h2f   ޿B  hN$H hثn	fYo|PUl Gf`hjS_ ?h"oVUhD	D
  t{| uu| up QfFFdAF 
F쨈u~q2 P[<u UF ]#ꀑY`qIu]^Ar`~ pmߔ!a˾L afhb  u^ɀ f   2f3f% `{
 ?0f  tofI A {fp 0p!P!䡡 f
 0XX!"f` `fgff%   gffP `m  o aPGX  DA ; Z x     0NmQ
?	6<Pw2 51DfWfV20	
f؋6f6f;f^f 2fSQfRWf3ہ> w;ȴPp>r趴 2G%GGffQlf _fZYf[SQRVWPȬ33m %	f*//hRmZHU 2.{
3@7 22#+= v p_^Z@$
WcPг0	辳_ !! +t$t"su#"c$!]>Zt>*e$,[~&+Q&EG&>"t:!s&qÊ&&r+9 * (r!*`'_r&#'> *a*ðG;vrp-Fos *-p*ղðDĲ$&J Â6:?ГJ2؀w3SVa&.4 1t^Xs42^QX{zÃ&'&D&(8,w&d dtKs	2syR=ï!> 2= Atٸ x$;!q=<;007D4 ðd. @QP0
0P0}01\]1YPu	t2-XA0EtCyt< øO 迱&Q>1J"B"RQ>J<ð3+
  ANM߰&`BO	 OH蹰ȃIذJ蠰2ȉ  uqTݠpTg
T@u]<tuQ0uIP0WViW@t}WtX0WZP
r= tS tD3:t
u
> u'㉇| tؑ^sư(
$ [f^L$tO	oaf`Âҕ˖0`f e w	߇GС&DfSgaA0=Ê *ÈDv%;% Au O hγp$t
i_k߳php. ;2jhCfh2rdphq hB*h4lh[Jl7s0s'Mu?fZrh:Muu1vf>QPH_u(lr#  f&fe}P}[bqbc~i{-+r(|}1}`e`ArO~PfRfVw rк s]fC@
Rh fAtU uJqt ;qw<f6sfк6 r-fgbgB
grff!`Z`fW ˰1u
   f> 3ێ= f  ? t\ǀ t
wt@ f f? 9T  |sfҕpqf[ƎA ǇH; 06fPкrm SgGw`g fgfVfкr7g0>0ff;w
 gf^u
fFкQQf$ftgf&Qg&fY ,P\0 x  $<@`dh <L <@DPp  DLTX\p @, ,_    ,0@h
,<Hw!cc <`hlpP@< p
  $(<!	  ,@DHTo Ϻ/Oo /Ooɏʯ /Ooҏӯ /Ooۏܯxz&<PXYhijklmno0	

 B?_ ?_i" # $	` a>0 b@pr@ h0r~$C$o`)KðNNOOhZmû =G(0  05@ 6<f.fff0   ;  9ٔ~`#轔ΔrSf sVW f Z

!!!
!q
!!f%@pf.2fff7u_	_f"f 
@

@f0?	fftfYЖ6f0/OcfhP3XPSVWfQs:!4ؾLي t
u uf>fpv Uf  fY_^[XÁOQ!e3!RP.kXZ!.!BP ^k"%z|k7X; A #WSQ:sHBs   b  h ~v Y[_`$**v	UCܧRf?fpeeˊ`2<w.
nbbuFx Ot@$_0J5觢$`M12OQg WA?A?K	?&C00@ `4 t/ tW wptu!:tj$
 s tQ>3t;~  s`E]=<nB9 A:%!?t;"; !=

N@	5/ O|``9u\ߔCmD[>D;>t,Eu-{  ^$__qKKlQ3ϟ[P`8Ø Ea79 g >pHuT> Hu%  H"RJuLL@JtEsH	"1H_&NORH1P!	QHjXSEM
g@SEu7p
u!* 
0ߠtOB 4CA
5PS55#%0o1< =03Z$Z0$[\$ =X[7t9<r ?$@@:` ?abX5S<:q>
u :uF0e㋇ߣ>Ft'4`utu~IG@]GX`5c7uh
 iziD@[<7It8C$a
27
Bnz7wm*nF8!C^:;u
^P;Y<P\P;O ?u=P\ xv3<u1!\@
`ArCC;rߋ5оj
Ġ[y }ýS< 76T78<8C}usa{ȡbs<Twd\u&&5\$Z^8pp=7Z?zeB]X[SqK4!Q4`pb31H@eٸ7~{ 2؜2؜[>BE u)P &:7԰Bz/	B0[Àu!  W= PVp /
C0k1H1HLFFB> t+&i&}
C06 r)P}}$S<;w?<w2Ѡ)<w< t~`<wP>r[3u3W
~$ Ksuqluoߪ?_ ߳?_ ߼?_ ÿ?_ ˟̿?_ԟտ#` ؘ$`<`u* .} 1Rq h ߢaB؝ u BJ. @C!ݯqn O aSRܰ t@(`$ZfQWP hR 3Xgg_fY[fs`f1g/BfafQRfWPSf3f3ɿf0e @P tf_d p1y?2[S%; XDt좲[Xf_ù@ fPffpX,fV3ɎfVf   E gfw^!f^bV_tNc 쾆y:/B^fuWZfWfǈ_g&'߀  @f&{f_ SQWV  ?ptTъQ"Qh4ńQ_ ڄT˄SY3Y贄^_Y>uU54}enކ	v&
lل
QW ﱇV"
D fX1;BFJqXf`f2f 
 2f00`60g&ש t ug&׀! qpC &葃ffa	

 @`B3 q1t  d fh@#
.$** End SetActiveDisplays: \ PR$Kt5<!x )ڊ}48t)`y8upZPQS!)[00t@u+YXSQ2t)WP  Z@t \# P  +<uȸ
 .!3qu@'Q 	
3q"066D `+ Z\\Lu
  XP! [1e\";	X901SRP^"P ^1ċ؀ X>X_ψP[=ȈE>ǐ@?P@ZN\R=>2? t=P`EÀP@Ո>rP@aCQR\ [X"3t="Hb+@'$Hp66
28\u\L h1@ ` HV
ur2,RWA_Z tr  "`&& &E"&]p0  '@PP2???/Pr+8SQ=fU] c+SW_\ð PRs[Z .$t rH r}P2t\*0f!Vftt4` 0q"pf Pf&fab@Cp荁r	 C f_Q`Vt' tfАf ITAfgfbؾP 
 2gaYd 
?`tX_guhWbH &=&M_0g.g͵ ? t0;r+gCCn i j1'>b+Ph2 34b+АTuuUts +8@ f@"v6`Ȏ؎-t   (w >y7ywtzk{OT0#{<T O G-{^Yw͋wfqx0t/>Qt`I	t`I /
Yu3PuQUr<
uQ&hsr+u
3~uCu/rpu<grvsNu&hP:fa
A8+ 3%׹Vú',\3d߼f..".r.ݴQ6P3Y.b>v
Pv.f.r.B1r! r PQX
䏀eu`Pf hG# :Xe20u_쨀t
f<u <u õAr$r *q.w.߮L2䁣õrSr{r{lT-ѧUTFTzѧ\/S y  i;"" QYo;]]{W0 r&.;ԿOߵEyjűWD' r SSF.&=V1<RQРL 
Zp5rSHt2P+` 4埀t"Tp5ZZYaQ~r#ռSEnYн#쁣  3f3 f3& &EZ2 Q`D&&,r豂#r8tϸ2 jj.;&EO h#<tS؀#[&M.=12T@$/@#h 
 5W hڃRh22h4S ?hӜh[ӝfZrh } `уvaw3pL5 &E
0,Qp1`}Q	Q_	2QQqVr%00` }0 i% `@; `a`6( 1ƿ 0 aV魆ī^W3 _r-}`Q˸ o`DP_ED`^`Հ 0 _B O  rDr` (}0fbrW2&*G_YS0)&*`u&}Zu&E!+_[úW Qگf0 r\2ۃ<OuB<tLbŎذг[r: " r*r 3h@ax jSp?
ptu$<PteKu{ CB[2 @Quu2#0wV o^Wm_C%Q͹> Y~quం9bfPQ>j uι c red`jYtCjGr-t`w> a rD2Ҋ	 r
6	u`d rdItf s`QRf!qq=Nr&r!ww3҆r r	?1+PRS..Еrq
.  .x2.aZBǏ{YAj#[r	ra5PЂ   dtggf3iuGv>? @fF8SeT԰2@ CWTQQ201Q <P 2012!þB, :Q) e>>?@u-PSV- 1޾> f<$F10tuP"X4 B-^Jذ* W r@B 8 /_1auQU Ȱ> 1 1 1?sn2)I!2b4ء1b4!3)P>t
!3?q($S6 t33pL|`R(r5
t9   ttp~ÈW(XQRWVù+3> ? ^_Z 2??31@G<u
tp@=@V ݿ D_CbD@ED!? |)`/7@@jGBC@qx) C
gr(/\rMB
"R[:q@a\QV tU.ߊ.FPR/F.^  	2u1!t0A0RVа7rNPVNrC2r<-r32t  rr;wXҀpsڋ^ZW
@  е0u
˾  tu  fA· u2`f2` J3322_t`` a[rnd
$	"
upTƋd;sRZ3cFdF262tg	u
S_ø
_..R.w.rs-^@5PoPÐ<
 <rck <`U2<r
 ?h >v ?w_xyz{|} ?_߅ ?_ߎ ?_ߗ ?_ߠ ?_ߩ?_߲UPRPRVFZX RR3Z_ ߼?_ ÿ?_ ̿?_%֌Ȏ؎KЍbˋhS6>JFSiӀKS0ff%|h f
  fȺ4ߋf#puOt\f   t(,#%9=t!an1 ڋȱ tf.Lfuff[fYϡr߳'=SsϵSW   f u  ~ fYY	Of>  Hf>ø  <Zuv7耠Y?HkrZk Y/<pjj@Y hDUS ?mhf rޱ>s`"  t	f1Pۥ
ú:tte`fYúA $t"t
D% t
H"X2xvfd uSv0} @+>0 a@%* &͒/QtC tࢤ̀&ߣ.Q u'u! G0Q t pt
Au
S% [Q t!A	u"Y3PRDu;
Q?  3&>`8
%b< t
b0b*RLsA:s u
A!Tt@Ut	t
Z3RPv*PXZ+c.Q.ѺѺ.Ѻ@Ѻ8aPfSR.~с 0$3.$$,!fpڋÏfZf1۲@% PސYd"#8#s#P  r q63fSK@?ر#t7  hv fȿ ff33u^_fZfYf.R3һX3t@saQ `0"`#hr.
 M10!%@Q&W T 5bff   ?b_fYw[S1hثr($_`3%}0
8xQ
t%-2沬!"`a fZ[4>y?Nw_ij?lF9;9ؙշrm{Ӎ:-x`tx.ةH2°䃅AWُ;F?r5>?5@.?:@PXӹӴ 	7h<r(pиfPPPD	 ӹˡD0I	#hFlSEr%ԹOӹ%԰DP"	6q(mKK}  Y*KL0eKLE33 @fEE..)-LIj0KM@cOO#PQK{yRISEO3h	1r(& ` PSS HaZZ[XfRCZZuaZ ~[cPSK[ \Z Qf  f[Yf &@W ⛹ Q"pK2'uy r} ru rm rer];uJPVPUo`WqPE Q֫ Dr'1LrSr۬%EL M hr(u؝`,nupɐaQn!od BBPpYÜRpnBnBB2JJnB$0tnnZRV!(`v/ۮu6wv^Z#QVW _^Y`%nG{2䬊P|aà桠
!  js-g3.;'tDS=
rABgm&0&+t3a|20魕a&KۿømԻpiûHls;ۻOlPl3;t<uP.E  Ћ8jЋ9a:a76átqlq$g`p,`2U#e`VL ߤaؾv(Sy3aO &&z[Ü`#V   ~ tnntnJFn aÿS p3Л3ێ7!C &?!Cu3ۏf&>CPQCu
>W^W _GR .'wZQ1hr(Q3< S .ko[ypr= 1À> uэBkqPBk`&o&O&7bߴaPQRf&f=@DtZYXð@jAjȰBjkbr6S2 &Wg&u&87u&8Wu	&*guAХ`O  YP2r(ں 2 t@'s
y_#cӷ	
 Aw¸W\ACut	 r __sur2l/BAd#QYPB X3#V I аOEiL>i;vlJ &t u:K ؊A5ߕ4_X脰zD_aϱ+>89&:-pϰhɽir(.k03Ɏ٣g/ih  `u	 u PQfVfWhyqPgf&Mf_f^YXQWV
`^_Yڮۿd%+t1QWPPGhX@.X=X@uX_YPDPP!桀&.l$>u
Pg@XuSWh , s hs(>&M&E&MF_[{`q>$PnPt3Ft"3&ME<taðTCA\ KF37VFKoF S'VF ?_KF<RwS2.[fø f fа=f6fWfYq?&Q1af3ɋߎ@&G   ߀ f& t ffBf;g&Gf@ w wmUtNtGofuXBQgPPY tghX 3AQ3fPaע&Uf&fgfdTOI 1
CNFOR J 3fSgdfCf[ u|<{    Jf@`t6f!f! f3DgE 
tfEF!t{ f!	C< uC u- rPmgdCЋׇZbuLb>b]0b"bgdK&
f]q+"&R&Qahr(h4S נ?!h!rX.ް] 	VzF1
]fd}S،[1
MEܲ`E  .&r'9\(th[!3[fZO o!! "#]$1
u%%7&h'~]+r0fRh:^+Zr&')?*_+\y,  PS $>[0S >Hh,rh:2f[,-./01289AHIi,014589B?E_FGHI`a^&8 3 ?JTڡLLa {^$a,Pcr(䷿:@	LĥLnMQaO[2t*:pp`h=؍>@ l>blUGA lBlhO3UP`6U$?CU! GX@ YA tY YB  P$0sF\thU  eWAo0unnJF$a%JF`aAKע_d`]eW<a t a̢bgc9e̺ fFfgdzSgdgޢake   llB lؿu QVlBBl亇 loUoooo lOТ]@llmgnbntfW {а 
@ tlFFnK@uxbonoUn pn@pnpnp5n qnhrnn;s |n^ gt`_8alel"|Cm$|~j@c"b@Ⴞ%n#} onneWw |	 nxy nOOa!%> tV4]"$2]&퀾)@ @]
	]$ȡo
 ]Po\$\a
   &H\u_t
hz<u/r*`>,Ч,\ t
"2p1b/ðy\@uS
 
 .ü /l";@P {XJߛ?_ ߤ?_ ߭?_ ߶?_ ߿?_ ƿ?_ Ͽ?_LؿJFٚJK ۯK*JKdܟ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_ ! "#$&?'_()* +,-/?0_123 4568?9_:;< =>?A?B_CDE FGHJ?K_LMP  p   
5Ux MQRT?U_VWX YZ[]?^__`a bcdf?g_hij klmo?p_qrs tuvx?y_z{| }~?_ ߇?_ ߐ?_ ߙ?_ ߢ?_ ߫?_ ߴ?_ ߽?_ß ?_̟ ?_՟ ?_ޟ ?_ ?_ ?_   &  }    PS#  - t	.H    [Xu
.'
uu  `fSfQfWfVt, uS l  Jf[t݋3ff^f_fYf[f` a ffa   SQW؋2__Y[ò					%
ðc	
Pp[^B
`r		a2`SUf`fNr	
	fa fSfظp	fӝs(3Ҡ` ؋60 zea4
`e eue۪e	e8aP (33Ƀ t	APuxe&>R(eaB
f7  ta  ?u _r    !S`	
hzW_+[% &E&_"
!x$fRQS	2[YfZfQRWP
u0B1^5d !, 8uf3W+0|A1X_ZfY6 s1r `ABCDEx} ~@fPRVWf	 fFf^fNfViЎ.< t ~.FuN._^fZf[fX@	1r
@
 "@
VfPhPf0  f.e ..enfX^=Fn>?'@v
 Akv1 .;nt t+0t .PG AKftv}	Hnf  4 t j u3  3GEA3GSHt<  [SN> [[ÿ t$v~ Oio !PSQ3۹)Y[Xf
	.`As.QI..Df.|VfVfWQS3Xt| uRY\t[Y`^ f`03a~;B tS
tw*
t& o	PO볆o##`G z tfeff7~
^轶 `a[]
 UPSfVW2{ Gt {f \ t]fAh6nP[AQJ rg>Ut2gFYPAXs\Pf3Xsȿf	P^[X]SfWfP`Kf f;r[r}WitlmAюo]_pmn WAp$_p&5 rsgNZ	g/Prs <@\ZSW7gfFfgf;PCIRu-g{ u	gf;K\gCufQgK1`	ffYfX_UND^A^Ns" Pp  Gp  fn
y@ pGRj@<7PiNV vyN"Q3ABY;3A+X_^Z0Q 0  t8Y=QhB
Qf?a?p}?pfY@~p
6u`fWSQ[a^fWV߃3!Z !P11/Pi0] fP.t "  ؎fPWPb`f%: t 2rhVF
uNF3p	F 8ȋ^V`uf
Fr;Vwr;FvN3Җ^ƀj rh?r3Eȡf7+FV
+FV؃ "𦡣"  m '80y
+G
vm> u怲A*eF81	j jFPFPN' @Gj FPB8V
q	q	~ uazpm  c_{ߘ	BhBб  WVߋF= % k:؋>@@@Ftlf&@8FtF% { +ұt1Ht	HtHHt&-9Vu~r"f~  r~r	FwsVFsF^_
  dNf*΀ ȉVfF ѻ
Ɂ3Ft	( I _F81ӫ`!1!0ӺPU؀՘f0Ӌа< ְ~k%hq~$wP!ӋV`fF~ 7	V@V^ze(FFݘN*;~^u@ޙ
)ȰRPWVa߮uFfHuf@FVc;tL+=t"ޙFVF֐ΐ}VfnJāW
a3S;Vwr;FwS)FVFVFًFV
 @e!	>fG`G3VQF |Πj*΀#@@fN+TRP^#p9Fs$FVp`0iDf0פ*QQ^@Rv@ъa0Z~ t	\Ë!An0r:W~ptA#f+f t_ӡAP  tc`;vf9GrLC+sC AGvfGf+`Bfvv? AF@s0 {~!F f;OFv8`SVӕ 
f;Dv3י`΋VWV3vF k AsPS@5FcFRPDujP0뀼ze uvdNFFA,ƉV=(ut'*$<u؋ƺ`DRPA,뼀~ [uRk+e+ұ8! ^*䊇*a 	7>uS;7F96xew٨PS¡	u~+9D
r
w9|vd'vvDҋ^0vB
@ *H+;WrwQ
3*O;w ߳ܕd~15NFaΠF3cEm8$<uՓ32!FߋV3SVe21Fv8H w t2Nf% ]8Fl~Gf@f6VA< A@PFVR846'(T
d89Dv0 5Ԅ8JV@Bw DC@FFs52/?0S1a246A c tӊF!t0$"DPNs546PN!4Ҫ6qA78rTT#:a:0f; `JlfYO<h=!3>>APP3PhZr3 j
Z^  3ZPV+k:ߊF%- ұ݀PƐ@@x^_``&`a(aFt!F5 P%az1 ъ%t
 gB1T1Tr -FvB	F t'5  f^0p"tA^%5~$sqr% g		^+F`̸(3oP#WVS*! 
 A^E\;u;UQ>)u	pf+^uVӓut F0^(p=bp _CN݉Q`A3n F(/k:@2fut @u% 0; |V@3D D:B | 0  0ꢲe	 6b^|ΠF0Fm1VM0źF$<w`"@5k:@@G  **uGW *␀= gqGr"t
< RE	E	 b2s" E*= t0&jP#Eupf$ + 2E~z 飘yq> ւ%>WVQ~@ ~ ߍD@5M?
f+o@0׉VZ➿@hN밼$@fp^ akN:ى@Ɖs"`lP@K&0(@ѡ<Wu%DFB ȇ*@PPo氩9v^~wko:> &@ $~= @sڿ0 ŊTҘ
E8%Vk :@ 0p
k:9@tC90B^_A3~6 "@tu$ NtF3!ǁ%^t7B1uϊ5$~!b:  ~߿96't`}b%@O0';t|>'pt@ՋZ2%S!}~fы^9Fp 	Fza
avvo^42M  ˢjp F򢧑ft@r
PvD26E
2t
9Q!;WZw;R-fڠ]Wp`
 *1h 9j $٥٬5ڠVQzْuQUЋ^bt.>&u`l u~W^DFDP1 `\]#A Py°WDP164-랪^\uq!?FgG  P
K`o~:vR! v :}tyhQDbP5mbE9v7yGDPgJwtobPǣP0HzRVF@?f*1k2Aw8h3گ 5tay}6
 t;|a6 PpvPFPaĠ^eDPpc
t2gUU  UUv6\ } uAEht"aP}+*FN*+@tRZQ>xet-T}	?kxe!@v鉅+e(exeVPSVu@83>;r;8| ^[Xpfam`Z&k``!muN#. pgPb$@*'Ft>v9v7v3p~&p} @ `PqCA% Ak^u3҃ r PA3wk*䊁u luRv3;Ft7;t- t#i S+`,u
uGrvFr`2By cIplЀSRNN `0mFtv`Rmp{Ny`zy3ҋ|3fs5Qzawh1pj"$`y^ @8@ӿ` W$pP?'0Q1ǈ%@}, .fJFBBBB`#` ܈F-F҈FvԿFKL QLo QuS32<V Mpw#Md PbP*$@V tPtR``BzPSv 8Vsy+ ;Viw;F`LE9VF1V =PCC$DDV/EVF$QGډVPCIޡDV?KVF?M9VF0<8Fnqƺ  ۋ^^"  V  V& |2\ƺ( }5X, xBtfN F  fBtF0ZsZZ1[YqJs܀σ8F v]r9YR^+8@fҍ8@]V鋕F+o@`ڋF֋Vob Y0 Bt,f{%  FRʯ
`a'3b,  e> kQiP`m#X7R  k/      U NAIBML 761295520C??r   2004/05/06 14:59A "BDR(7PNC
RUBY1.0 M10P/GL 64/128MB 212m/203m/344e
 (C) 1988-3, ATI Technologies Inc. BK-
VER008.01@02 
9  pae7.409 v611  P10 AGP DGD1UpOEM VR 
@58 h 	h ?#\)  A Ae  yFB0$TVSNɰ50r  r   
EPCIRCA  
MOBILITY RADEON 9600    c`{F  AiK@ @ D  H  
t|!@@  R` @AS!!@0 3Q0{`t OD@   P`e[X |1!g r%&%hA#q @'= xBP&p *h*h*a*+b* fb*`*b*Ub*!b*I  b*P(1&b*/b*m۶0%#1""sMt[
u ` 8At
 QP!"7q a 1!"b*OU  L  'Hp q Tq //D)1)(c%2 21	AZ s@AdM`>A Q'>
>s Hd@!5AAD< p 4`? Aw M0LL 0aEP&z01 
0B'A1Ha:
 (50 W  &-AE 
3$@l%7 0 ?!N  PO  POPpO`PP LPQP0
 (H < B -V07207STBrOBO SmA -  p   "uu- 7_0 #  ! op   2 2  PZ21[Z2  ߧ  A\G %BA@]e]]!QB;_BAaaHa&a1cUk]^^]`  )a*2b*b*&*c(H?,H?acm$

3` #:)@@4W@
 } pP  rd|@pE\Q3AB%`t)8 u g   u{ruug
`D d6whw s!yt  r {zf`.>6 u..6.8	 u~ .:.9`u.:Ȳ.6fa.v4.>au.v.&v.vм!x.vf`f"1INIub0s.u2E h rE ST[)$
 t.VW _^FIRE T2ZJc0PU$UUT+$X)3oATH	fa4t.Q24P mX ` *sefoWP2X _W PXuC &GOfGGOOf& G`OOR? Z"О+ 3@ßP2?FXR1FXfPSff L f
y$ f$f Vs^mons>X=Zu脩5Vr^4 
 k3
K肎j$*}CPCXD~R ?uar=2et߀ ԭt{e0įueÍ1mÂ& $B(B,BG>@}] up~]첺2ĸ tP趍f@ f| 
1~ 5>#@ 1B@@.]ȣ###VҺ <v  ` 32Ĉ&! .@2ؽd^Ð	ANhV0*814 Ld
F&[ uqpF
 ay8$ k
.>پE F
u6/c臧dttYaxw"twb2>S(N)N=8d2%<uo 0a    Ϭ {t
u<eϒϋ tu	<to tjf;Qs YaF;$<t*<t0<
t'<t<t)<t<
	t<t(<t<t (83
mh(c"I/ ?F f;  [# ~ tF: ǽF0fF6"}F2Ag wtÈn<uj`0t }t ^"N @39X8u P $X"8t+N ;N"rҋNN"F;t
~<uF1 a`0s2~tRSf_Nfy &f݋r  syQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ܀ 
F X[ÊFf@F$FFt@F&F(0( tR.&! 6Zџ.[PR.]t2M ZX`t2@ Fwv@߿y=	;5vv tU;5t Et:]r9Urmt5f3ivf3^$f3f1Cs
}8sn~=}:n=a	  1'(?t 	

 S?B/	D&|cOQ]07
r	 quOV'OQ[NKRu0jjbcgvWX 91ce
pV0WQcj| t!Whs 9pF Wcf	SjUb'  S"1_#2b|"Q%# La"h'd"r2# 7
 |ן/  =+1ҟ)D-,Q/ 81|+ҟ*D-0*+*ǟ
@-	
+rӟ,B-
*&Ү2,3
m7
 A1K3 Гs|_oY]Mahip>  q=?J* ?A_v|
u<2ū jEEUEEEEEv 3Ы0HÀu#HIZIIH` Hu	 2ôLU߃ F
 ҋ[ ]KHbu0Oj@PPU@PP@PP@PށP$  H\uTt@ @
,^P@PW Xj  U    @x0SQRVWhf<t< tux.D.< uhdG$?
t\2Ҋ`tʊ»22..;w~
]( 6 @..Tt`& _^ZY[!&G@@u
5ee`e$@_
`eeSZPUφ G<uTG<u1GHA_,Pt G2#gjuAjG%eKru/腂BJmLpg po!mYcwmPjGe[aS FrwsXːst.6vg
vxtSwuG2@ u.,Qxt	|a||#|Ŀ|n
 xn?YP	VQـ.(kYD	 
 pfFn FnF  .!$FDV.60j<Onpd j!f- 0n߈F:QFNF yFy"W߹  @_ Q6Y_S\[SWXP u2 ) KX_[(@WX@W[_tF$F&{n
u9C+$
``jWWXW$1 蝲f3q v K^0 mNAᑝ`ԾtD7h} H x y鵀)^Z!+XCPDu@f0mu  w V^
]u`
 V"tMtV@HpIt<uN(u#A: V faQM t>SpDLBU[pEY$ ĀPt
u2B[XS\DzSUD  A")tq;Ut!%Ut $Ug0t
 qtҐ-J
t;SuT@A %?P%@
Ā?
XÐ( 	 c-'(+ < 1 dBp"P/OoP0@@c_OPU*(/OoƏǩ@w "  c˰"0/Oi!@ T(  kD9 `M>](
c0c 

   @@bco O
"B89:;<=>?Z+AՊGc_BQo߇d0ݠ`"ozcfk*2 f@q>E?2 ?ZP0 
> @B( F	

`PD"; 	j7eB#ՁW?Z %( (,%*26', 49$,0	
!&.3+0$8=-2 $8?#@%!ـqqTc0F
"
`ZblZ(0bW</	O
o@ qɲ
/OoPۀgW4RgWʿf(oۇ%' ?k'X%?P_z@pAg@Ae@KQO/Bw.r13tup3=Ouހc&v1.vwP=: sX.#XBò$%wKӠgkc:ŧ4ԩ7d*䱋#g:? EoFEB=#; ;2u&P$@l$ToM<~.;u*6O<t8Dt	\S
OX:PL
uX.체0&G	tԱ TG	?]
u&.+X&c 
-FHX CQ?`?PW.E#00_w^賿uu
u2aX&IgUDp[UD 3P]U `e
F CE]Y[	1E`FXP]w(Xv 褉>S%[( y1w)wu k9$7Hu m8u`O{H'Lgt999999_D]P[U XM-  Զu踩thG pGU]Q S[[S݋HQ026'C[2S  &'`[ ĸ Ë#2Eutbt&FS޹ 2f&Cfarvt	 F_7	 2b`n Ȋ3S0!y.&[t 0v 0E7t o̓rPGXuSصR[R	$
[Êgq% ot4$
@t#u t$ÊO
}P X3<JQeu u<~$<t <t<t@؁ð@dzzaz`1uxzÁ@ÿ'$(3  @
@@ b !"# 3@xtb
%pƿ`]axSIm}(e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;uPlpuK>L tDI @.>
]0E3ud"]<~]&g7r)0u3 3Ь2PQ33 YX2PR94$@t_ZXÐ$ѐ"R< 3Zp8 3傔 ё3߲S31QR$WCrCTC f3fRȊoZ쐐ZX8tЙZYX2ouTu w2u ?83$
t	u$ O0t PwDX0D0u
u$0<0u &o6<umAr	Qդt	
t 
߈)<u+v뿴1u 0q[_3u< q㑄܀4u< uQ?0GV6u& <t	 며wbB"
( DEx%ȋ쿉^N2  Se0PfB򳰌P ?Ȁ>cuA,@ 3ۊ'.B.EѽJbX
B]R+xt8 Iy<8t<?tA .B  躻 Ѿ밀y%/+0QĿJ  Ki YpŹ 3Y yQ
 YcѼ.,BBɍ, *3?0&̜rq Gp{	 GѾޝ;~~|ֺ| |8@8|48 lP <~<0}f ff@Ӏә6xx~~~p`>>66f<ff<  >1f f {; <f8ll8x;u~#} 0pp0;;$ff$n8|||A;<< lll;lll ~|0` 8l8vvR >0``0  /`  ;88 !|| xp fp<| <l A|P |~A 0s !0qݐݱA A~p ff|ff٠f< l l  b`|``qPƦ"  #<p  `bP'q|r:ְA|A~Z#SƹlP0`l88  <  | ,P||p ;0;x?|~ `) qP0 P `6000Vqv | P82px?`flxl#& l!;| | | 06
vP	 0d# 01$ 1
0 v;l`@``0 |#   88<# 	l8|AAf|ƀ# A p l~n ~pr$R#2cB~ l`fl f@>c8c>  >a<` rQ
`
 >? >`gc=p"#&0`P ``  0|6;>%l<~1  6ll6;~&l  "'U(w()t))6***%**U,4,݁**;)wU/A/0A1*7nR,70?;?0C3	11T3A31A004A5!0C66640 2T,32;23T, 8!20.A1=2 =>>E=  fxW̠bڜ`@~g| ܰ8  l8eAl"w8fb~{| 8` `G~ PH H )x AHPӀ3tΔ<8 'p%0.|NgAސ1Ё OCl#ѵEl ҤTҳҗAӅ=E=Aԅ= C=PCZCֲ0J`BA>6vf~!~ۥD>~~>2b?cCd{DN`||K4怃AzbF])Fc@s_CE EOVfNUPW"S*p@Aex16Lbf80v~4
j0p xHVs8C)q'wj wImKeK@2eAe 2jp  FKxveK~7w w}Hm0e2E޲v@ \ ݃#+ff?`d|d``芕ΖK" 18UA 0x(ђXPxwp77Y  @fxc`VAu` e$yKj1IkB!A@dABveG6 	C 1Kֲd @!Fcв  f)S" UdN!
  dg2k 	CTwF
  G{zFڔB  
!
A
isC Pgu\!@bVx0x`@		PuP
 `@

	Y EaH@6fd 
	7	 	҃)՟K(t!ci`c]r^cc0c t݆	H	 6AU!6ОT! 3`"3O B< ; >UPx`jf ~ Q 0}l6>6n6 K!&&Xa w&u'qD  (((
E/e)& T,F,f:
+,
f 
-vr.i.u+ /iE0=ej \&T,C4U,3u%4 U,4C5&7:
 6R,+7&U0 
&U2j
&# --&=	=vX=
>>y,U\ `@@f"Adtb00U0Uc|FBUi  5rإDD^``<f12gEE| @7t00d֟G@{dRFBByfXRJKJwK1g~XL*ؗx8SZ(4+~Oopݐ5t?W2@ _&&MSWI &FG_&E"&E#Wxm_&]%&}&I2.2
t@T'VPT)TT = ~=^~=~=~ &U*&$
$

S0B$
PT-PT1S2;t4&wt______Z2RԊ%T+FWt=feBe   t߃`@gt:t@h?ߋF`e܋ Qgwg?huq&PiiRgOfk`kkak~jڊ]JR 2n p &GFq%G rnqGÜQW+&7R&D&߉TAtt	tt p&RWt_%&TAP
 XF2 CwD%Zy
xztz# z	 
qzw` xz_Z_Y`stGQW"Q$0R ҁt3|3с~:A&?Q$y`c 0wGz	ĸ wx 2~zWRUFzySZ~z챿2fPq	2PQY#Q?Pq&GR2bYHZP\4]SY t'tEPJJa B2BBXJw㓱wUg$轨/}VBB`ww3q^ʃz5$]:) (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0433258:=<:98899:741	
	
_

	

			0

o
 C"P
*P **ꡮ?Я??"0p 1   $$$(((---222888? ? ?/ /? ? (a?'?/?7??17?/?'/--?1-?6-?:-??:?-6?-1(a>   1  p/(ǯa1
pʨ/     ?  (a
1
/

(ٯaٟOsP$
ĲXðNN_?  Qq>I~&G3uP	u&IútԀZcNb  P3&2J&ߊGaTGLAģ`À0c Bòza :'2{mobmÂ
  !"#$@ABCDrstuvk(
K1[1{1 ;1l(ߓL\|}<n2N^~>m@M ߴ] } = `P@qPqpq0q aPA}AQA߅qA1AbPB	R	r	!/	cj)dCS}s"?dU/DTt#4f?FVv}$6@h@AHQBXQCxQD8QrgJsG!tW!uw!v7!eVESA w   OҭQ  ATI Technologies Inc. P10  01.00  @ @   V  p7 OVBE/FP խ.6x#v<r2.\WVSQR  f&=!2u " W_WȎ؋ʾQWT@R@R" uzs &uT&E迂_W*T +@+m+T +@+X+T + @+C__ǃ"*T +T uZY[^_O ËRQSVWU?WQ30&Y_u6WV6Q2 ^_W
.]EE
tE M]2].l.DEEӀ~ZӰƿEE!0;#0; 
E"0;$ ~7@;;<+~$: ;@;p>#p> <"%~: EeUe WBtS23[ AN
tȈE}~=
 P &2E*؋EMډE,].

"+E01XQC0h
 f3O]_^[YZP2%RQUSˊ$2w
 K< @t| dQLEY
 b 
-uZdP9T2ʋD<u<t<u<uA62PQo23@3 3X23 M XPCDۢI`D2ڀzBD 5tu*\.
-X n2O[]YZ1ø WVP$6Oش!Kt8\t 1	2^ƀ t 3Ӿ"^@^OP2 0_!\\	9^#]3\" MWV>pF^&Vf=>^_Ê`FG< uY.].:Wd60e
._twCCsPS($]i ^[XS0[ tt
uPSR Z[X8
t
<iRjBB@Z2ÀuPpmtp<wjut`2.]1a0P`O2ˋaPXo(
uË uW3&!ppps0_s!2OP2< uL5/؋AIS [@R;v߁~u~AJS,f[Dt@S[%@عSQM/2f3`_ff3f~Y[f;Ës #Az}rI~fiu2uGf`P@@RPfZf {ff3.fX<użS$f[fa=s=f0g$i[f%fP@zx؀XZRAZfX2v
uQR~ZZY!2 luRY0Zt!23nt	!lz wl wf=]QRW!l9oq~ f&P~fs$Ԕ`Дf0_uY~u& n  T8<\ VRfPjtZ^fO×fƢklfffPfVX VЭPQRfRfQwY Э $  ZYXӠ
!l f@ffڐva%WMfЭ!l0BAr&@fIusrBO&@[Ӡ\t1W!_f.ஏ1;t37u2@X@,uQSuz3ɆtA
ڿ 2[YQ
̿$Y!2@s?؟SQVW0&'# .R( &ICCB^Y[!20P7QRVWkB	_^ZY0_ڋ_  cc ѽ#2 :2_@MR2 Zt $Q
 t}SR SuZDQSa0&ĘH 2&= vmR8STUVVvWPXXYY\ͯ6[[%PMID)#]!   dأ###d]XR ZR !
 ! ZÜW`8 _Üdт  .63d f.;u	W 
ÿ	rd2[fXY3%& $4
Ҡ״Q~ffQQ2
QQQR`WPH HfXR2Zff_fXZP djb +{ff&L6hj/틩pR=fZff_Zpa~fPRl g +Q4KK;rZh S 
S  S@ [ hSSSR	Q Q @5QY2C @@h   ` 8cBid B	fPp3.Df.T
.d"R! 4ZBRc&	`{`R	.Dt fXWZ
RM4
/a<tpU
D? /  W
D*
'Q e8tQsfu*cr YQPTXr	8u
TP u5_,XP	 r%Tr trTjr XQfu#2 Pv ta%SP?u$XP&rKru
 uKuXWq_ _++QSۖ   O ztGT{rN  r0t;Vt3Tr,Gt$Tr r1P% B,NKu@}u!Tr dr
 srz$,Y i߲#`s RP* s2Z3W _YQWs@& 5Gr	zKuq_6P 
Q Ys% C==_ D>= 蘥;OO<Su:rj|[rbfفBuٷIrE8w8rIP2X0/r+VDf ErrVDM~ r 謀AXЎu3@Ptu3S Q8XY@[<t<0Ⱐ[<u]L<M0Mǃ3豤PQWGGN_Y蜤X_uĤ"PPqmu08ZWPj_
t `nplJkÀ@A<jt`:u`0UR	fV u	k	-	u_wðp̧q[ÐK<Zr,ZP2@K [[S]@6_;w2XXXYf`	u鷰vt6P%2}X` I{ C 8t P DyDX ut!P%݈a XtP+ueP dX }P)P%at:u@PXt0P^ f #u#P	hPA ưf 5  k@ h
d20
u譐>u[XfaPmv	t_t,s!
2nghtuQQR_L p Pn_pPnBX1ou
{	\rt YۏZЏrsst uh|f?fCg`qxx;RN
Q7QtQRڮatZ	tQ߻	h1|h.? t.;u.;Wt3@^-'(+ ]c@h^_OP{U 7r O XGW  O!   #T&ۤ. W 	Ў<@{<+ T
2$SQ
t/p+ '3߀t		ttuC6 `U *-h 
j ]aS3 ![/B$J .g3`J$
య2Q	﫰
	zB W	

̿
Ȏq P /`$@
J`@=^v	@=v1$?
úZ[tS+|@{۫IJS Q$P$0fP,(1T  0{z᭟cfXa[qS<S㑻;s.:Gu`~u.6R&$ZVWQPSN= NubwrЎ3f<8ATIuI 4ك4 t4D@u*D.ND.P...>z0k[XY_^ PVk<u2P`8uĊ^Xû..z.?t uP.G@{ ZYWVQVlPWTl2Y^_ÿ   SOUop6 2iuhb. t[uAcoPsX`@d'uYbb,haa/b:d
$ P'kl5][3۩0   ̀P RXu22@t' $CUpt0HAﲟW@ Pf$AAA
uԿ)$<t2
Sըr

P${Ԑ
Q@m|0t$$ 	Aۨ_$۝ރ  Aۆ}ui$
n$w

V$>[4 ~ѩR|Ѱ/, ̂ﻌx ﲩR?U֠Ѻ琙R$@SAIo߃$ ! Wm@tRST%@'@"2[:$%`-zS $"`uPQX0vRtj}kmuklx^Q^u^?_` gFFQ	I3I+JF,F"FR<yQol";Pjk7lrQ,s3pP^x^k_^aq
HqI覛HZѩL<[ *b1pR!R?Zո "
[ZA2ɲ Ē" `@ g@x@s Rc["R
Oް$
R@'$0v$AR,`B #$P
3b`R$=({$ q,@$(Z"QW2"d@F2u90v<B "
oJ  g
P_QSP.H	tP X[A``Naq``GGFQo"NjwhCj_iir	0vo^k	/s	u Vq#4\"hkP]D\A(RK
` 0vu&q`n!aublgGh7`h赿iA gϨuDB*klC+EFFxUu" `[[[\N~$RW&I<#t=<2t9<3t5	 ߵ{	 
SM[l_fPfXp`.
$<`<t#<t<0  <` <` <
` ߋmbF* S&E3uu u	FfF4  ?8A?Y._f.EfP> .GF4XHP u ىF6XHfQ7f%  fF8fXBbBf;@Af	F8Kme2i..>ًFF4;f_[(cb;E`SD[`  Mu	 Q@MtR3ZF :@LHF< AGFF
G MN{FpG$`@OF@	F G
G.M	̀

0RRR
ſFF	 
G	F	N
FGF@ NGF`G
F3F'F2F@FB A
? ?<A?< QRF;8t7<t3`/99
<t<tn2NAVB9CpwF0X2?`ac /dOeofghijl /mOnoopqrsu /vOwoxyz{|~/ S@(4f
   .fX[oQE( ĀuB u*@f@Gtff.#Gf.Gf뺊 u҅u}S @~
[ .O.t	tIt䰔ٻPIt$<Ȳ2YW@뾎 _ @ n Pd    	 0 0R  { 	    0    {ppp ^0^0^0^CA𙱙O "pҰP	 @KZP  fPWQ2ɋYSQ2xY[SQt93.OɃ.;vP߃ː@2U
2Y[VST-U@5Ut)*X~ 0QSfX PQ3@G YX fSff%f[~!Ћõgf[B  ֋H
^_fX2QV2y.^= v8B} YRfPP fXfXfP 
- fXPQ觺ô:Qo22P$? Xk"дfQfR1	O$r5BP;%Pa1$i% [Xr3Qfw
`?YpfLfPV.^2pfXfZfYº&u5f?$PJBfrYfӽ7
(<tŊ-PWVRQ+Ë&G
o36 2>Ѱ!$@!`fX&2&YZ1 BQR
FFpP$έfPGZY160SQR.
Q< I09 Àtnttt"@@.pğtRܤ Q0Yyv|@t.Q1
yYf.9VZYSQV| K<\u It	3.X|ߊP($o
}PYյt^1 CRpf± f.;Tvv@ `7fٱwjvef+бp8RvM@HϽv?Pv2v%A{vA@	r,w-p֟ZY*W`@@._@ UNfVf^pfCf.fff;rf@f߃rxCfw.`?1^f;rLfc.ACf;wff+f'qcv
AC0X.LON]Tt)t= r = r;.DP.Ã0A_w[06r 輨t6$ EP[} _ܲV$T$P5XY=X_S$y@m)ܲP%&O@tp$&W7u t@ߺP@0H6ZX0ۀZX 6RWۿŁpMtݲ EP_ @`0Ѻf6pf  E-R¸@fuf
V"  jc!!! f=  sfށ#f03җ6pۄ"  5 6]%f6 6;Ewf6!ؾρڲQڃ03@6Z7Lr@»5qfta7f||`?   wۃ2Sf4>0?b[ "?ø \Dw3Hj{0l p+?KK;rp.S 
S  S@ [.hSSSR	Q 4Q YQ2 QYÜ2C @8 				  : p 4;
U92qٲ[Y."D
$.
tc_s]  C J2ۆ Cr//@AAo E@: ]ز[&EEP@@@?OX@E&ߊDV@@?PD&A^Ha֎ؐ$^P&0L1Ftf
^~Tf\Nn;w ٨[Xu;OfP_%ظP  P R_FF S	bQ`(ESES
T讶U蝡ESF@°,}FQ(腶UxES	FȊăr,T4PgX[nN%{T8$ESF%a`Y1U0ZPFf=$$,`cIN@f
 ZYf
Ë؀~ÀuQfָ
tQ$<`gK$
R H}Z. 44,klbl4kQRc3ҹdy  .R@֨h./Z[   (_d
$ tp  $$@!Ҁ
u{&4 *) u.:t.6n3Ý W߃ 耿7p[ WQRVSpղ+$ 2@ WfuŰ4PXf-ղ|P}3 a} t	~ |X~  .ta3}0]I=Ѓ
@37_[^ZY_B(o@*:|Ww2~f@tu% tA!lԥ_%{t  W7C !  uZ1`  Vf^fPo 	&|Ԡ~$g]_ 
ƀoz9ËËߎ臾輿 @σ3Ǣr V0PӾA quQ ZX^0.ۋptwW0ӿT_ҠTӑVS y;u[^BҿgᣮҾ} ^( 
- 3CQqI2ܓ #֮eГ/ @2ԟj`Q@?Ѳ"XQ7ѲP4Өu/kSѲ,X  Q;Ȁ ߋ%ϋ@YըбЂs9H
 K8S93ﳾ Xh l   Bp   & @*@LN  QRSвUPpջ
ѿP$NP5f߸0  XP%
X@X'XU0
[oQP ?t@ ttP73}P@ б 鸫Ь&cѡBX fXA1X_2r~@C텱o 7s>  1.Ǎg
Qܖ@Ǒ$F PN(L.֋Fpӌ2صKQ̌$W4SL00K{^ ݖ@
u3ɿF:ЊȵNpuq(gsWuqа @Aq$E$O)ˀ$߻ŀ
莚 tuaKt  VN8ʋ<Kt
+!$

m(P陋wt	
 v鄋~m0q@Z@3㋃`Cۊ2~Jt72^?到  ^t{Ͳ&$P
N늻2QhoYa  
QPՐXY^8z{\%T$rȰU$ P2@<3Puv/$@w%T Qu  UNR艀w؉݉_I։;f3.O>f.O%(̲$$
tf-ffp
f.O>ucunYrĿ
Lp
u
= Nu
u 4p
p,p
-
@ 謗u  
@2资	<\܈݈"
Jˈ
J龈1.at0%$	 q}
S	1u$!@p0uq}iV0u$$ j;0u/ʲ"@(ap2ˀu$(pjT 00&v)$p퇀u3tL$x( 试 2#' .u r$> .u7{$( j
%$-'c .
d
T˿ 
#'7 5ZX} P( 6ʻD P&5[XÀ(8tBwu=05Sg[
tQhsK,FGGð=%  pDvk%ɸUQ\2:1 I P R;ɻx=D)$D($~
%ߵfQ
fYfPfQ
IQIIk IG
  .IZ IQ@w  ,f%gz߈L
%,ɸ|k qYe#Ȋ pSY0JKyeR
PIwS
Tø OP PPM 渍  uqC XX-aYmX币VVD,QC1AΦ\X˔X0YAΎ븈!^X ~!MfM@ȸMXc帍UO0XqXb`GYA?0Z 帿_ /Z^X'AV[+$帕ag ]Ph^丟!^(mfDese^N<fsg _`h@Xn gkV>`i xkpmpll 3ItRZ8uR;
ZP:RŲP PuXπZ;@_$fL.? f.R[#AyP !T
 t 㰅hR23Ұ
Ϳ)u}
Z`..] un> tg0b2P>bP22AQJ2A~=QRPϊp 32#~ZYYy2 XaZYYR*8}2.]Zà؋m 2Ku2W Sр1j[+с2Ê2+**&R  āZHuB$JÜB J.]rcȒ`  PQC3BBaaPQ YXaY@:ԨuXp #Nь+ .JP8~@0]$0<0t0
]:Jt. S ߜ_+a*2큍+᠏uX ʻ󫰣up*tX߰ u. p"t04"
ވÊ"ð(рğ" 1$mB݁  +Q,QVW++    հ_^YԊ_ǊP_ 8v2QY2P >It``P
RS PL[[ZRРJ2ZË.曋⻆ 03<?& t
uV E1ņߊﱺO&JPAZ0&P[2R@Z}LQȴË
t
2&L   >&}S`0YظUJ<t
A<Ut2[
Ί6% `2+Q++YZ @++Nu` $` t{ ݍbtq|ka8~
td\8tX|`I~D*
8t8t2ſ
8~
~ }ݿbtA*Ŵ
RQVW3ۋsG tp Ѱt A _^Y@ ZWQR1f`Ar⫤G  ZYxs& 	r ǲq	 PO芊@:0ffPFnfR/2S[F`fWfVfRfPb06PfP+Ɗ2BRZf^f_SRPú@f@Z2f[wQNPwy}ro&I3wP"$̃ƃ|t;@ _v[` ovI餃袭RZ鄃sҐRX^X@3 @twF#%p1P+>P   B+Z5 h1to"  +p㸂rq~ƒ|@0ߋ&F醂 +ru &F E&  P +>2u	&}uƀtGVW_^t!ut
>| @2q|u\Ձ2wtp? qr`u
@oQ6JX 2B2041ȣ
 SOw 2
FfKu[S3Ds~!|Ayغ[uĀG齀P>1F1Xp$6| 62tm߰UЈ؊Pu)#ë0&N0>Xz E}Q11{r3  P0F2O 0Àt!&0Y6U4B2?2$ &1O`77 8r2Ê⿋20/Ћ J,P2XWQP͵suXY_:{QI@Y+O1tAnB_va5Bov
 * _u　PoP[CP.XPËVي0.|F@6umXPRJWQQWpP@_G?8v
AGY_P[KZK&%_G+B;v
A"M òθ+  _o GXHIRWQRQWP8tXoPك"$?X_YF1Z Y_Z@0Z0BQSTUVWAcXKXUuYZɂZZ>ctA}}>
u&f`g3 f f$߀0| @i
@||SP
 6t&ۈl m&]X 90e
 mGPmĀTu
ְ&'6|P,|ط]AJ% Ί%%`Q{QMwPd[bX&{*t
&۾{-{̂uP2"ٰ#}~r{	zuW${>b2PI<
vLc5`=Ҋ@ǪA8sZ1@sz&t u2<
u:6u Ɖ@z<uz<u
t22+at͆++&eP>@? +iz`y~Tza.ۉ~2O3Ɋpa^ʰ'uF yycFF8buqy~FNVyb$
I,3(!Q̊.(7t.;t$.
DYq^cy#+3*2d!d"<PReZXt
Aet
7y~Beu<s.jĪ٪Q3KOt}𥃫%IbtÆfm&x|+m&} 32乿 p밀w0$&e te òNsQP2ĜBzJG_дz/^ xQ&5&m&M CYw
uB$ǡi0]Ccu4>wl rvw &5&ME}wqtfw}A4 `~ ^ ,lT p-wtl9 pl.P;PYǱd2|XR~ ZSں pPBJE [Z SBB  Ȋ@PSfQf t^$t"$2t t=fIuv5αt%utfY[X$ .|=<t
uMvu<wPSPRп@#n@	e@-^=s=s=|s^=Js p;ZXj[XaF#<t<tˊ~S&[Nu#t>BF7u.| ~ ,uȎ 2..u 
*9 
-pXȽ5P
u0w5wf0&p u͎..EaF.uFF t5
-
1
5Sq[mx&G&g3t!P<}{<}aô<t
< ̀
&G#w2ÐGPP P֋P$#"3ҹ <uPw' XM0e0
P0puÀu
&~qÌ>@S/[t (22QF t  +Y#uÁ{PW>&}t0&<t$8tGȢ&3E   _XÀ3t_t G8u&2ܟ ᆱ^ gt$
J	ȱS;0eu@tH(&  L2ܾ5t

@t<t FP =BJ>h=&]&M&U&{E
 P\ XA}2PSQR.]t	0Z<|qSH FǠ(5[VQS&F E<
}@<
t2 Bd\ ' t&^ Eo	prpas-Ph p	t2{䆀SUP][&X[YZ u:up`mp~1^Fp<u	C0R+p.:r߻20.]0fÆà$0<0twuà/t,
2.;t1ǐ8~û  et~2m߿#1.V4 5t.#7 7"8 7 8 9  ? 9     8 :9==RY*$Z.K$SQ߳SQ0Y[f.
uY庨Xu	f.>  f@f.1At
u@R%8ݪ
txZԋ뿾 ѿ.( 2.OA.WBtW+A_t;rÀt@FNL@
ue>.&LɆċȸ 3  u,Ft t` @y*N
0:tu?M2@_
uJ}JTЀ@A\

@ S0zPM@[ZPQVWS.>HNt .HTYTuxo.P޺QY@P 3f<8ATIu? 7!2QRS$<ux<2[ZYĠ_Y.Iɰɿ.LɡEp@Ƨ[_^Y,Ŵ  
XÜf`PSZYspLtytrSE+軁Ef9ݧ[3W)aff܁gbbfZfNg
h	gg\	f߹  hgr fa?fP2ɻ| fPf Ogf	n>gUingDppqf h 0bqӧ_LIqQrbq41.as@20 $
qX3`pvPovܦ@nv]fXAS.= t.;u.;]t?3pEW6uR3 W:.eD|<t<<t8<t4<t0<t< u0P+6=@uuX5
X
 =u
ȥ_QG@E=@@Xx ^W} @ @  @jPmm@{wj X--p    zX~`~u@-P=uptEԥf*{|$ysE$bq$L T蕥$u{ ݤ$ހqg$bl¤WOW PbW .? t.9u.9Wu.G2t A22@B_S4.MɊ
܀ϡ/@_0[m^H~^_ûTyWt A3PR_$ ZRNq%ffRY t3t+t#@t.tpt>t %ffp%f<~f$<t$f- < tf+ f
 Pf2) ffffZfYf[VnͰ22f3.Df3ɋ% fХf.ХL Х
P!"ffހf  Ѧ!Xf_f;t9@;fX!Ͽ"+""ӵ
@`b? m鿰࿰׿q^'¿C߿.^(P蕿萿pًD芿EF耿G{.F*.~/ cط aҀtttt	t23.߰)$ C?	0g    墰fX^    q  +{   C @#1CRlu u	 .F3HG H@B \fXfu	1 X}^0ۿ.~0

0qԐ 	PtfPȟ0tӸ4g藡PR  8nf@EfPRQ迯kuP~Y 3N H@u XP [4q* ݽ	 $ ,?L=T1PO{ X4\4ސ`4#fju @u8 Ѐtqpt= pY E@{ p6Ч
uu
XTtY]IU E  M<~	<% Yt 0 YZ@ERSfPW{LٟE_fX[Z坸4F
s<sF; PP9(9?;; >xX^/ =n  )Pٌ88 !I? WCfPQЈ<t%<t|׃Ч
$ОB=EHqaRN
@f
  F-f诜߸Pqސp}d f.tyit؈Zt؀qKtff
@ Spf% qtuv rw x P [ؐw_ZY`^"CRVWEVwP 3ҿ`.;s&ꀭ@?p.\ ?Q O^` ϠL.L.D20DG_^ܵISD[û +o J'(Qb؛_ I Qj FP-ڳS3QK衛 Q> t"@褜A0u{ﮨXSGЛPS2`e`
zR}PbSJX7)0)*fW+&Gv fftf.#fߡEPf30W#fC}EX֚f 	+WfVߋw-fￜ.-
fʡE="004{31k觚Xpf^ [H  $,48<DLPTX\`dhlptx|  ;Q  _``  ? c$
k*6
mc8*1 
  
 {!B!nC@^#
Q"   @   
I @ .{&yE?BF>GEEQ?I2GJ @ ~0K- ~QK ILm$ jw8Nh1H̈́E&@L?FPGRGPQEc۶R, - Y- =GEPL y5G%{#~H)oLIGZ[_L][NcORUP_[H8] "QRFS0d@HфE#RCJF|fNNE ؏h	=# wE9ATjƢE [hF+  /Cm-EvkUV[P@Wz Bmk܏kly m ` Q B+ 1r_@ : IR# PQC?{	|`D(+? hH}Q(,<~PT}CPT PAdP{Upag~D-'}.}]hA~,.~dQÄ
e^OA{0] -``UU AdS PagQȉD扂_ŊR2fōQWPP0ഐV1߀  $TV N? `xPWV0!  S[^
-؎$@< u+~@PVf }进^[A   N {?f=vA?_f=Л @#d?  {?=	wIu;߰]?PV?=@ru!͹ ?SU@Ћ=[<wqȎ؋tD`VУhУz봨ĀУ@У %뎨at{2a-?_fY(wp  q_0*(䫀 x@ PSRX $PpX
XtuZ'RP$'"
XW$譿L$蠒Q0$󧒑*㑲'` /rѡ: 
tRP译ratt M	荑 `XZp2WPX2 t3ɿ;t 5t_p8P33 t5=@"$@Њ$ʊ$ޡ$2p=u	a= P= u= <g0H0}K0,ݯ0w0Ɵ0ǐf
=x0<j0
\<R<$
ă@π@6<裀Xü4 Q *@d @A &0}6L 0  A  0`Ӡ  1X (ӈ 0XB 8xV=V P	 -`N (( @6@a2@@QW]_YuE'葟t? (͐$À3$!Tt{$ Ï>	̎Td
$%t@XQ##@qߏ5IA%>o輏pr$67颏 (2뒏* uz$ЎoűُA%*AR$討ï茞A)4P0aP avRэP& }"*躍#S!*٠)񴘍$ S%zextgbt
tnڍ2tMF2;r( DWF+FV_R BG Z0 0 {99pð8A88q1	sԢ	1		轠	?B0	
8r]1	0Q]1	
0
 |$(2pƌW  A%ZP'hTo Xs\HHx$k
^_[Ua2F|;s I7 RFNP'uڃ?^
[F 72FF
V0Fً" 
0?PU7XӀ
!YINYs ^HF#7!FVЉVWA""S#g]p6F  F^A*9F$v$Ff0F,f8f6( F0 .۫A"u6"F/	F,}0-pp%Sr.F \*&2090C(FPQR2$& 6
Ⱥ$?
ZYfS@Uސ A]f wf_fj;w]9]S ;$
؀S3;5>;<';;<;;<
Ӹ4`C<8C  и _z@fĜcB$J&eQII

IRIJ׀
ĠIIQIIL	QIߣM׀ LIK D%= {vG$U*3070S% 鱗SdVP 0Q@f3 P>3ҹ IXA;r00	ҥRX;v;tX@YƿXPQ ƥ@Y
YX  tpVƿ`R;0SfPF}@V~VIX]fQffffYaX;fX\0]p_  f"T^bf^RfPꆁ;r:fXZbe͆@0ff࡝$t ސ蜆 @øN = Nt+躇`k$c複$ȑlm.<  93f<8ATIu 2؃? u2$ PV`;׬	8uĊ^2d.WopMp؋7t@ 󤻰.& t._&@.?ty?.EtzECC VfS`z@P.]1f}..M0}Z|Xf[^ xfz91
2O0
̻m$
.E6迅fp$
_S$0J$.e9N藅W z=z	_X.]9t"=f"	@=%f	}&fi7㈻ e$08!Aa_諅{B腆 D0=%
Ĳ=2.i.ٱk@lufAM>f_`~%qx%u

辄kk2 ї
躃)
2
腄2p` 8Pm[u!苃j{{u0j
  N  0u  t < RTZRpѴn[-S{ ta%R$ZWx.E#_Ƥ@_VQ8@tX $Рf`	?%@0F%f=-  t*f=2"荿f;t1;
 @`ŀ~ AH?ΊY^Ѥf=  9_ q P$0߂w Ҥ}B&_pQRiu0倶0曂0pSQRR$ $4
A
p
aZauaP>mS Wa0t.m ۾am@0ᤋM,tc_ĺA$vQ댂ﾂ$s7译*Sq~ᤃ}4 t&qF01tq+$o聁n^jW!XW0HQL8f\7IF"F eF-+qp@joF&2$Pqw[=qJ5D 1E/2q6,a9uPI@F) aJ$
F)蝀Q먽r
F2T [PꮀfF4ـ8Ar`cp?F7twF;ـ許Xl_FB@0ێqF'F(|F2f 
#3"]^_@2ްY[uѤt 3 |q G7I f fPIJ$A	
f׊fe`
ffe}@	
fNJ$߱
f	feaY
f̀ff臎oCR[vQp`ZuH:54 "q6Q7/E:ԍm~a՘~ַf!~m~%ؾ~Aa/JڗfX~~m~N~mMFЙcWUD 2F E]u:u Ju	F_fF4 8Y._zPP .G &4X!H0yܱq06XHPfT fF8fXf;f	p x2iQq..>ًFFb}$u|#_3v}4   @r}Dr L
7""7
đ7W yy.Et.;
u
.;Uu3_q5M5Pm71GtS2~t	
`ҤE_N. 0QB 
0QF"F12N(̀N(0QF1F''N'0Q+P\$fF N !Lf_`fN)F0
F$P#2.O$F&F"%HF+`-ߊ%
ff&F-F"'
(.oN3P.G$ 
Xn&#'Ff	f	A&3*z*2#++Wn&+ Er(/05-`')C,$F1fF N && n1f1F,1&#f..7g#7@F8 L7@c8F9759G	p,1<$@-<
Fu00+- FB.K(
1(>1>0+/fp>7p fqA`'AG/`%2n7!"7_
7 :SCn/
07Ef/fk{4	> n'`N2AVB۠ F.  0y tZ݈tUWF:6RC_a
p_0{gP
2W`H		F2_U":6227d
Q60 a2 8C F H K L U Z d x     ( `0wS1t$^@MQYXFt-
F u	F=3^~.Ff.p fr|bwQf=ydfe0~^Nn.*If0
`y`F	] x^ ^df^
!hdgdFE$c@ҟd0d%d! _ d{F6 _g#k2f5x59Z5wkwi2dXf^߃ٸ4d^o"`~/Sp8йw_^ s f^sPF=$sp,w\@ v)t
ŞyuaX ZYȎؿ_D	DfD Ee]}gQ !*ILDu'u?DQ++؊}@@%??4DdpCEeAÿDE	RpPDEe}}~HDL+S2]Ë؃;㰇$'ĈD\\[ˊE
+PA  2ȉL qQ-D{3D|< _vRD|<@`$Pw}X;&D!|#ËQЋȉD)&~뱆'{E/2P?D(D*&@D+)-wD`D0߉D.E`g4#\1\/ЉT23 ]P~Ht@P ЉHD;XD5 p@^@ӧ@X ^Ш@ ?XP1  x@  Samsung LTN150P1-L02   
 A  H }  !Rl L  "0Tn0F"d`U Vf3ɹ ҋy^
uyЎ؎?fБPudf|P uZft7q# =	wIu 3|tDнVߨ֨ н2ѼĀ ]Y``UG |A|	 󏥃|"v}PeE;$Ľ  E;X e9= v?U9r3Ƀ= t(9w$= u9EwAEE ӋAᾐ@`Ȁ}w u7p|EDEDSQWV^_Y[| u ?^ Е.|& t.|&=p@|v}DDMmp`M{m2r]a$@VWVS 2 Ў308ATIt[ 7[tFAa%&G^±
   . u = uDu

 Aڹ  _^VQfS q0@
Nff;uf[.Y^ÿ7po kp%oQ3 0Y}4 _t_ aVoo$3ۊS  0،p0͌3
 p
o
[?oE3_4_ο5 (EȻooEonnPo#nfPVWSu}$!0΋ϰ*ǢP,蹋1ъD0.D1ؕ.}4u
'+Z -
 2f1._11R6 's {}&3>`AE.e@-;p3[_^ S s [À
t6D0JonM10 OEM INFOq Oo	
/
 Oo/ Oo/ O o!"#$%'/( O)o*+,-.0/1 O2o345679/: O;o<=>?@B/C ODoEFGHIK/L OMoNOPQRT/UOVoWX2  1COD  P h$:h[-hS@.h[.ngFgz$!{i[h$gp\ifDA]01INI??SQP2M.N= NXu2˃	w,}.'
t #Naguc}aMu.&Iɐ0n g hijkm?n_op qrstv?w_xy z{|}?_ ߅?_ ߎ?_ ߗ?_ ߠ?_ ߩ?_ ߲?_ ߻?_ ¿?_ ˿?_ Կ?_ ݿ?_ ?_ ?_@8Z~Xsg/X _?	_

1600x1200 @  
 BY H }@gf! 'Yݧ=H   O=: E
R` YA   !!Y0 3Q0`Y OD  P gP`YX   |a! mg XV%hAB#a@(= x@|`*** *+* f*`+*U*!*I  *PX1&*/*m۶1%S1""cM$[
u ` 8A$
  R7(!Ya!"*OU  L  'H`aTa//D?)a))%2 21	Z @dM>Y@  ?Q?
>$ Hd%@Q5qAD< `4`?Հ?A 0#w M`;LL 0E&Q&
11' 
1(Y1lI:
P(5@E   '-YF  
3$@l% 0 1#N  O  P PPOPP LPQQ@E
P(H <0-`72`7*S1TBOBPPSmA -5PCp  0"uu-߀ _0 #  ! o`  2 2  Z2a[Z2 \q\ %A#A#]2]]1#Q <_ UA# baa&!b_1%d]^]?`  !*a*bb*b*&*d(H?
H?aDrmLO`?!"#$&?'V((*?+_,-.P0/}0b11 2C_3P4567ae88 :?;_<=>?@APC?D_E~F1_HIJKLMNO PR/SOToUVWX@aY[?\_]^_  "`b/cOdoefghikղln!_pqrs tu(?x_yz{. /013_7 8?_ ߏ?_OG ߘL?_ ߡ?_OY?   ?_ o`߰?_klNoϾ`/O?vŭ
p/Eˈ/Ooҏ) /Ooڏۯ /Ooߚ!S ?_)_ ?_/ 8?_8/	O
o 
?_Ooƿ _  _$%&' ()+?,_-./0 124?5_6Oo9 :;=?>_?@AB DFߪ_HIJK LM ?P_QoTUVXռZ\ /]O^o_`ce /f?ijkln /o"?#rstuw /xOyoz{|}~ /Oo78 /OoϏC /O?GϘ /Oo/S/O  !/O  ? c$
k*6
mc8*1C
p
 !S!B@^#
qa" 	~  @  
I .@&yT ـ\>d>Ea qaJ @  /-Xr KVm0̒$ jw8hT & Ra 	r cື
, - Y- = r P_g y5%^#~v?"/	񇣷
%[H%8s r T #_
F!P	Nr  ؏#	 # wE9@%r  [#@F+ o /( -r vk[Pz {PP	Bm%_&r'y' Ш qaB+ 1B@ : IR#  66(+ yhs8Q(,9PTၳ8;:PT PPU@;Ä1"=9-'q8.8]h?,.9'Q?
5A^O; >]k `0CU%A #C AC1"!CDpAD_E"@Dd6IH!I<W =WP DKVLPLX01
w*
O "|1C*p !@="Q"0"A0 p
b6!ANTؿTUps2TF }`  t` P	<	cZ 	[@f\Rr2TUZ4x#[
6]b! 	r=2T oڛ'	`'& GX4 \cZ`s Z:ƹHQATTWYAi؟jklm
YΔ`~ ?a`obQ('sXatC%q%m2THW.#4Lhu(%~2Tj镇#Ѕz% Q6b1+o-2Tb{6#r0epeJ5 !1.</#T- XWv U_ho3(3/2Thhx} `p~{731
aW+ @c3eP o0a(8 >9Q:e9߀:Vd;WD<W =r=>R>肑Q.?2w.C/@p.b@ВASq.`1PDjœboœ1"FCGn)cKVwWZKSworL$?
u F)C./Oo 2 2aW jQ!9%W \raWs^sa\\	aW'_
pGs_ԧ!~raW yL!.G \q$Ti ߧnVKpSrO2"0soO$(Q	%aWs/'# 'r++aWn,NW3.TA/xbp K122aWA23Mua4Joُ[7 _7}8U:9=w;><=>+.s Cu@,#AòA@HU AJ2E1"GAt^K#FLQ<  1  L!    fSfQfVfWf   ff2ff߃ʓff3 7thf;|uf;Du7fs30f\0fyffÀ32 ;Tuff_f^fYf[	!)o
 /Oob &	  4(` obGb૔ yuJL2ŭޮȧnNLdSlQKlE8?H[~U
dc1(S >||5.)a{hTuz[3:Y%7zv8n̰5MǢ}=KK[lO- CEVW R 蝔QtmܝIځu乧&s=ڍ .h~%rc9-8ua.<WreωQ>^AW|e@K"kK-	a"Ǜ>_̷2T҅1`ak&>;&.z{4415-V׭ l8bQcк+7&V'*yi	AI5ގ~	rQfDI-e)}v1/v@cm=/.;(mٱ>
J4OKN`.'f3ސqM%>-Zs>gp¼/^b_b
<*`r-j6OYS  [(*SJE(<SsVuU$r#X2~4.v&s-I3 iv1/1%ڜeB_-SK=@|3h%Wb>t\"u|6.L{W/&ݚ[&eab#A= rTq	>Rs.ܧ(6b|^#
5
oV:sp%\R<n,AGK 6n2u@7QmIc/sϴDM d=>͇
΁Z;b&U57>eʈg (z"a 8W׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eS
-Gc#('S)\S:s~deߛ&{޳]uTLemdF|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthEPbcIFt1vT"|} Pa>c(^)|'6CrT[Jy-Awg(^&1>G?D&W,ҷEVrfz*UqF;%d%Ev4\ω7,7C3KS4.HɸaD)c%O?+Ǌj&j(@GNpQрOXNqKa
Ԍ02S<{{D&/	5e	mduNto@mbMɡ{WN_ƭd\?*]n"P1 ywvj: TY,(.TjLy}Rs bL43E
䎫j,ƭ<Ǵ2+vAt|3o;n6}70+=辸iG,N@g!CVO(:5o ]]`c:=cވ{>Oۨyh)U?ZH-9@FAnr'Д/K!t_3/Zg?5bmR!`
9YG&$iV3P#Dֺe2HRk]>
xQgH]<C6<<g7zwɽ)$@$^ :Dǉ/' ZOVAliB-Zfa+y\*Af;
 }hw$;43B"qdV)]VH11s.4]F TJ/{- ~V&xm }
oל%adE}sg39Vmr`d;Ze]$y+U6~%y-	+|AX6RT[Mf+L*ޘRnhBYZ[\^ /_O`oabcdeg /hOiojklmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ/Oo͚P  "Ptm4Ϝgf~94R8Dsx^A`96b@kpgs9S\})(d<f*̛(m:FW:9DT!zcUDh
^3,\
8f	߈|	*Jn̄2CC~pF[>%/\tVyGۯ*7$ AkoxLŕ[Z\J	|Э0a!QQׅa_FH8qa]Oۂu秈]|xڵd|$SN(Et+3׫[]bKY/n<;ѧ҄Wkz㫷
Yvdo%9fmTL	nIxƼ29MEi!jJ-r%vx~
mwǖ)fL"^g{[AUOP(IcKۆ^Va_;2ŷSh)`cm'dN5~ù+8a!"LF{M#,뷿Bh.6DR
{h;M/cTDގ7գLloŤة2χn]*ѡ8CL/g1+f3#i%co Bvl7_BEt.Zx~i$/ftW
P/64hFC	%! G Q2;( аrY2/nxs^)4흥 94JIn8-z9N/fj۽_pz}[;bï"8?9;U	NZK;#7-omٯ /Oo /Oo /Oo /Oo  /Oo	 /O
o/Oo		P!}geoGY0W#,у+YZbk`ym(p0=Ʈ.A$`]Ab}tV
wP5̷`34O/lnSO}\ꭎ7aF6$Me&g9na^O08,in<[Ze1T*Q9iν?(kOqL}O
y!fVb=	?ci,F:׃FQ2k'y<.$Z!N~D>qIHHA';-qZND0tffcy9:@ i3\حCToT{$	+qZFzbS:~ccU>?t \]jX//w;cwE;QD@6؃Xy8JMVVn<zD.p"9Џ"|߸nꀃ-/
<1NB1bM\Cm]N[/ ?rߜf4@'
s(B(3SCwL٫j:llW)@v}EvA</Sf3`zbka|p
y,lbyR"rt$>\ӤXc#5Oamx'X݄:Gg>H@46 0zF`V'tQ PWNAf+Ki-K6GZCs*ڋRl:J ;cDwIHlwGea)LnosV+3QE1hi4S	sdDTFݛۓC$^dxX߯cpݴ/gADJjKAea?zJ>AFǔZ֙{ꋏYZ[\^ /_O`oabcdeg /hOiojklmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ@/Oo͚қPGϜg
$Bp$JFJ`7U!#cf/ j8m{
H;̜ 1Dx,r`!/*'n#m@[r"I	8^AE1D8k
:Vĉ]
csbCA#_%Ws"Yx^o[)gJGϋf~>?zl@t 1c%Axb7TUw7-^ [lw\:+9uzTGBs;٭IyL ױk Rdhd]DRrOR;~[^wNiZmcVzx57pJil8$$6`'﵆KlzQ6mxKc[4҉;jQ0\K15=MVwOg	a"Cl\(*,l_2Iy鬒y|ߒ];+B1"0k~6PNvdcH d#%p$lKS#9:Wk&p_D(.~hOf2+ mNp[-;ᓿwyꤎkK҈~5ʣ)B2konot'(CK!iZ$CJKnM^AM-]hÔ9{)r.o+q{{?*aAv/z{%:щ
W6h5^	Qyأ${DơG$@^rlLFqC UEu;iTBܐx/Dz1J8pQ?h
\Q	L
mvfCG=;kٯ/ Oo/ Oo/ Oo/ Oo / Oo	/ O
o/Oo@ P&lge<sQTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuupW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3IYZ[\^ /_O`oabcdeg /hOiojklmnp /qOrostuvwy /zO{o|}~ /Ooψ /Ooϑ /Ooɚc     t     G  T  ^TI{ jP  RI  oIB W v D } O  1BW 1D  PIBmWbDaoOB QWDCDM!MD ?#ME 
%F h&S bQM{ QC !'K (U  j*R  |DR 
SR 
CR 
B  BLP BC BE BD pTS 6.TC PRS .H  /?sDBG,0WIN[0OP *0GCR-)SDLG` > ^ Error
  ?_  0B2  Press Enter to continue  (CTRL-Z!abort) ? _!NEAX N" "L   OA` B  C{B$JEC"JP% %#K{C$FED"F' P'#GD$EB"@$!#6ESI 6) 2&)2݀* :(P w:P
 >)+>P, REI+R0- VCS0#0Dr..)0#,S.w*F.(G.ZF#a!rDR0 v@11 z@12 ~@13 @14 {@15 @16 @170^KCa1f 5P2j 52n 503a!"X#`7#b$3%Q% 9#&c'`p:8(@8!#
)
***	`;+	+l@<+,"---c.ͪ.C/ݳ/#00ŀGDT ɀICLCT
!5pE23~W4NN a!wBSGJXGF]
a!6bG2gG:{lGZ0KIV:a!R  G,4M>M0qG.uO*yO(}ILIa!"= (SCSDSSIT!UBP= D]ST= F VG VCS:IUSS:@,SFLAVVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw=GvB$[zG$[~LIQ$[V$[[$[`]eb!p$[x$``QP1UR1b2b3b4b5b6b7VCLimit= , Base=!1Dte^$[f$[j$[nb5Vach51jdvG%HHVI
JMJ	@KIٖOU6PPvQMMVNryKIŀGɀtuOQ!Vegh^f_la!C= 0D= D= TR=kl!{{P}/}  ~  0>  | ߄?_ ߍo}~π** Divide e Invalid opcodeNMI (previous instruction)Break on SMIDebug hotkey ssedSdrg invoked via callPOST tab}lntry Tracepoint
 							

*
?
EXEC WRITE`RP  _ACCEQ/A! A BY2ORD
Dpª𛥭MONLY î NO?TRACE `{0# Disd _RealMOnlyEn"B#NO  INT3sP`"OT TEMP  OFFONeISABL ENR LOC#  SERI#f CONSOpRE20cc ս CP@
@sCT!Ҧ A]LLIõyo\oǏȯ0`Ȏ؎.V0| 5 tU0̓͆P>t:o$>U.#uG6J557 ѿqs
G{7} uVRό4"$r;s3|7۰$ 2 PSQRp.c(f._f.f@٭Ujٱnٵr
u, t$.t@N u% ;t	.^ /uϞPӵPCrt..9Vt!pc.툑!wv   a{ 0ֳurotib aa
uj. .>_P0u+.^t
u3t-t._ ;C 3u'߀u2_".  s0d&Q.ZY[XfP.^_afP`r"{>t"e"
w B$? 8 b ",  %" L faù   Ptu
D>=4 u	0rhN
	 :tw%3t3sT4= fPf0Ka}p	bҍ6U<uf.R=fu<=upfffDf.0
?f.rސRfCf.a./c .3Ӎ!>/d  /Ϲd  Ϡuf366p;ZY{f[PSVW< t"<\u
<nuF=3<~u s2*3_^@PS>:FsI>%=s@>a4s7>(r;< u<<<u2B
VM5'2^@  CyclesAf(uSec= ) ???fQfRVϨ u\@ًaڋۋr611ftf+fxvfu	61ff331f.x082^fZf .{݁Z<@ &Z֍J PQt0ϋc 2r	12tYQ 
#2'|##	 y2s
11t菟4r_^%W<;t=@"  ?@ $3s?v4u1rw$0.Ws_"1tT!I4u}1uP	
C=34u2r:f{ s2U1t 2r#D06
rQ0b ] 3 
4 5  1t-*3ur2r,D0$0t
>r.d. a г3Q@X\@	Pt5.R.;Iuf.;KtU\P06XR	r n6S p
ft<guX<t<t<ͳuL@	04t	.TS 34@"@1s1`/@?0֗Í:oG FFsG1G%5HUsGGa5HH Ñ/tI.> rI/rD/0 H0r5} ufǿu%$NNufP
ܠG RPpMSe [R6[SSQSSzG[b׋ߺ*a*/0s+"@%u/|-/--.(fpװ *\fW7O-@	ffGGt
S_9 [Vw2#-^f;t]-wߗ-G
-
PYfVEf3Ѐ?t-#.fGfsGbs,c fSXMemory, I/O andbqRs must use hardwarexf (0-3 ->Yr#-8]..N>Fr-=.뢙 l6`llmrD	{v m k-t.r__j@ k rk.՛k l@". f $- Gt >i
 r߈G 5  /! , u
0v G}pw WQr{W\
f\GG ,r u6@	P.O>
 rGGvs',tjd r#_Gzt |6f*3QM,r0fu!0P<upт0yQPY)U*c*i0_V	b- r' %3 `0P0͙R G+r2}tn  0SrS͓Gi]r
+r:1rlGQr+r$sm1r\+r 훱R .+P,rqss
6-u!+u PXYiP²
 fries_numb0 PQS ҈36(@	џτQ t"(6(.'))%BP#     0ype= Length= Bas rByt Trac YVW*   F(()u1?G`l!t )6o"(d@_u`  0({uJ 
Gw>  }'fGnat;)[	(GO(:
N(]0&)(P%=8E}	  Ѹ'(BhalPdy active. Do you wahto repl ihY/N)? "RVWU@	 t*@	.b 6[ w  rwfbGff.!!Y}t 	P}bOff3
G
G!3{q΢]_^S`pW؍ 2pFr{_rWS*
qg7 sp &Q q߈Ys<s8f Lf
u b1a`fSofthnoސvaila.
nrG w`w
tBtq u
*D u+*@_T r@	]; u629%P>&	XQU#_v`1V6@
 5|t/fTf TCC[./D.PGIuQG^` 4.D9Ou.Sq3)A -!{a`0  &	>VWQ Y^_.?@a`2 R_ *C={	f9Ou w.s ss݀PXa! ۶Cʄ
`".&^Q@L$ ù  o   P06.E..F 5 rGpGG0A$r8Ȱ|5f}{o##/O# = ~M#CP$39:0 r,pG;5@$tޒ	r0=G$r
13W$ts
 u	rcf=  w[3T}%rR  LwJ#tCi%r>psw8#t.T%r)psw#
؀#r#t_6%rQ_L Bu0, Devi, Fun@on= 
 tx0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** Errorading from PCI
 !  !#t+%tC #t6% #  pC  uR? +3ۂ!E!FfpCA!LT[s2!.!]Et.. pTp vt`[ p
#C vq#`4<ra
 a3~3U^Nx ~@v  ^xaAr
u!! @ !°!1 !B;Vr蓅!aWQU -  6 ! $s+ `,$/e XL.:I/.l0
 A0hsu0hU9!u0<# ;# fС"D4u
4@L) ;"#f.##@46`3`85vf`306 E_"f0z"CB-.99ud>p/u/ xt- =6)8w.#
t0 +)+# 3"qR36#..VW."@sp36f=qs^W7?s6E$k  >#󪔲2`[7(.# .PACr!2A&DD67@JJ/ |0n3$6p3$
4! 30q:."  9%9:"j/'ÿ] VW> %_rh< u
pV}@V @WtQ: EψqX@ +r6%&Gf."p$p$rS" .Rs9:}lBC^@
c65EIO"uPFoufat physical address  NPfxbԐ! ð#srk SOS2;tf8x&ps u2pu6;&>p3~rV&}%j~l6 }eh;.MemoްcompQsu;cccfulԀ_'0v7hx@4&p3|r m*!iip quf6']p7?f@g@p3z'j#w|wvwtfHtrh}@.y'lQrp5tgT4t[|tYrTQ
 `35Bg8xfqS vg{|l r^}U~I3ɍ>tA<'tZ"uج@(8t$ s&At!_TrptChecksum= k r[}3~Fsfghw> (wj[p3~=Np5l4tvv rqQ!Rt]T rp+`\rF2w"I<Lu4Fd r|84v.*#t5@]SWfl>r<:ufF	+rfF>	 r[SRir$r%} u`
frZ[p?.Ϣd3<*p3>*!Ds<$煩  3 .RՀƓVQ.04*lB* uV pKJ.B*?ro0*wH4* P2zr& E@ r..*k.8>*_#9 v~	!vD*9Fpp3!8*`4F* sQ`SASШ>:@6<U<q SFHpހR>J*=.6H* 3Ѩ0GJ* k@\DoH*?F*`.498*w
.B*D*NiIܒ̋D>0t %@  .;puf.;u>-(sMQ.l.f`,@4u ~ǀ g tPR»uIJ9t3..>ֿE.pV4m=!'"ï0 S 7 I.;Kt2%IKf`p;R3;	=>S@ԡK.,6S 3׉򥀱.,ޣ<`@\RFX@W@\۠ aCPU Time Stamp display= Speed= Must set s to ena_ble tPsP1BtJPr	d`}=@h.v&u&>rN@<uF`4v .{2.~ ,-n.6-YP$v3CӋBcbter =   uSec t
r!qh6o.xp.Í>'rtGSrS `<t.&Nt#>/r/.< u8t">r.r
u
#&
* T7argis@rt. Rs manually ifQfails6i/WMQI ˆ9^V6'~F A`!u`e@66 ^PQW> %>U s_YXLt,[r`@10Ur.J b׿ u`.& $rL2w,<r(.0Ur ߵ*s	 b@ 0@&
mkw
 u	1pW	.M"M}#rp.ݭPpMfQ__NPSٜp?ɝ`5P`FAaz· kAa"51
 1
 ?W.h
@i&(a
M̳zE"10sv$:% u0% M	gø6C	>phr6>niSn;;K;I;;**+o-?._/ 012346?7_8 9:;<=??@_A BCDEFH?I_J KLMNOQ?R_S TUVWXZ?[_\ ]^_`ac?d_e fghijl?m_n opqrsu?v_w xyz{|~?_ ߄?_ ߍ?_ ߖ?_ ߟ?_ ߨЀ2g22Ѭ}[pW>2!2 t>6p_W} v	 EAC r3ۉ_P_rS t]AMw][P_)P٭
ЭPX
2t^𭢱2ѭ<w.2ؓ2 [SZrı`P  ( 1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?j_`!?`	3f<u.3<xZ.3<Q<
23< E<
u.2<.:7<u 4 0<s+.2<" &8<1<rÁTapu<<up08<.:X "3>0.?>2<:A$w4<.5b>؊5<t ˀu 8or6<7<[ø.1<.&2<@.=<X`E݊7<.*6< v&.6<#& Laz*3<S
.#!ԃS$3݊0<aR2< # ϊŴ* # 译K`
 a	AR.9<
 Z;<ZÆwBB5PV~^QR 3du t񰰱l`$<6t<*tPu.A<

y"A<
x<Cwp.A "B<<ڛt
ArZwG ZYA2
 d0 R7 r  dI r`.@<@r` d`Z	 .@<`a Qpt
QhGv Yuu#s3s`8umPf`8<!O W !Fq@ &} tC	t;k0ta3	h &t&E
 ظ@	 P ^ X @Wu-  ~pfaq`tQ"OA _ Yf`RW.OA.1Aw#.U! 	tff.PAƽ.TAʡ_PfXOAu.UAU.TA讽_f.PA+KdKK|JJJ9+I@=A3A<O??=k====>R>K=?IQIvIHdH1IH"r.A$$$AP <t<t<
SQVWێA<t<wPXrs<vA.A>A &_^Y$$$AQ Y8t	( PVtu@I0
<
t X2Qt .Qȵ$0<:|up06ff6PffXV/pϭo
p0^Vf38
9f^ << f`3Qߜf
p  >COCrf0f3ftYP0C++x@2 fa%

 CCR3 ۽CPE1< tN< XÀFu'Vu@߬<0r/<Zw<As<9wA;t^<ar<zw, <~w< s.^ Error
 QV+AU6D^YR3! o!.SVW31rKt	s<<t<p; <w
t+&<Ru	& u@R< r KA< u4 _KPP0PECPEOI CN ۩ C1SQWU3t!;wOQ
G:Yu
;t} tۋG]_,rf s ZYf% r}s`^ r
<:uft_]Wf33ɋ1 r	f
ANLS:R ufP0wHa^<fwK,W<Fw7<Ae7JI,0@]WfU:af>fP3 fX`bfAN0\ u3d
df] Aef^a<'u"PS<'t	Ab3dk"eNt<Yt
<NtNP3t8tNX':*򮿋HH,
uÊGvO 7ÀM=GCp2PVWuu w_U "$$Jy$?y$4y$)y$y$jy$yAqA`T P G WIN HHHHHU$<w%.HGu~xt;wxߤȰ
r3Y]Kxff   `HB8uĀuBJu*@u
 ktgB$J E@tgB/AJ
 S70Zfb0z$ (u#QgpJ BJQB 1䅨@a SR1bNZ r. $0P@0m rPrfЊ  bH t$<+xbH+
JE$<u	f pgcHB칝1`hYBu"J Cх J g` t t  ARڳrȀ $@$zчЋaU$`<`u`u uR
 Z- ' 2
JJr.JПAZ10@ρ r@OMTB B |ԧTR0ᱰw r"5u<۰PqԮ];u1p<t) u0JХ J"8t	r ЭhXBp J#?_ ¿?_ ʟ˿?_ ӟԿ?_ ܟݿ?_ ?_ ?_ ?_  ?_ 	

?_ ?_ !?"_# $%&'(*?+_, -./013?4_5 6789:<?=_> ?@ABCE?F_G HIJKLN?O_P QRSTUW?X_Y Z[\]^`?a_b cdefgi?j_k lmnopr?s_t uvwxy{?|_} ~߁?_ ߊ?_ ߓ?_ ߜ?_ ߥ?_ ߮?_ ߷?_ ?_ Ɵǿ?_ ϟп?_ ؟ٿ?_ ?_ ?_ ?_  ?_ 	?_
 ?_ ?_  !"#$&?'_( )*+,-/?0_1 234568?9_: ;<=>?A?B_C DEFGHJ?K_L MNOPQS?T_U VWXYZ\?]_^ _`abce?f_g hijkln?o_p qrstuw?x_y z{|}~?_ ߆?_ ߏ?_ ߘ?_ ߡ?_ ߪ?_ ߳?_ ߼?_ ÿ?_ ˟̿?_ ԟտ?_ ݟ޿?_ ?_ ?_ ?_  ?_	 

?_ ?_  "?#_$ %&'()+?,_- ./0124?5_6 789:;=?>_? @ABCDF?G_H IJKLMO?P_Q RSTUVX?Y_Z [\]^_a?b_c defghj?k_l mnopqs?t_u vwxyz|?}_~ ߂?_ ߋ?_ ߔ?_ ߝ?_ ߦ?_ ߯?_ ߸?_ ?_ ǟȿ?_ Пѿ?_ ٟڿ?_ ?_ ?_ ?_꒕ [RQ o 

 ?_ ?_  "?#_$%&'() +?,_-./012 4?5_6789:; =?>_?@ABCD F?G_HIJKLM O?P_QRSTUV X?Y_Z[\]^_ a?b_cdefgh j?k_lmnopq s?t_uvwxyvz
Compaq BIOScope
  - Skipping POST breakpoint
szB_ pz+~kpzM~pz-7~pzX~rzp  2  Q< ~IU@bY@]@aԄeԄi@12Q ᅡbR /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯDBEXEPTN˰DBWAITCMRDCPUREG(6RDDBGPrSCTRP^MEMBUF) CMRSPIOPORT5AISPTEXTˆ/INSTCODEI*S{MM!GŀdESETARGs/ UMEosWR+WR,Q#/1RQ#AWR) Ds/˿WR)Ԋy @T T  ! !EOP
  /Oo /Oo /Oo  /Oo	 /
Oo
 /Oo /Oo !˫##ϳ$4%  "#$  rpˌȎ  F߯.UfP.>A uWP.)G f3.UW.H`,I`,O`,UM`,N`,E`,B`,}C`,..W ,..AXfX *fSRkP.B3ug01)u_`*+tT.T$03t?$.040脨r'`*E*`*Dp204r	)`1X
Zfy[`001M01N09PS tatCu?`*L*7hz<v t-u$ظP h;hs=)Lp:r S6uE[X`*}Cp2'Pa5
.->π t
)0A VXPs Xr$$
0
/=
q>)1 rE`Cx 2G G hP; Hs=CruX HrTh;fP f_"wqJC>
 f.|`0VQ?6'?1A60R Y^PSQfRV`*U*(&\f&Tf	 ^fZY[XðS3ێù  Vp@s H ˯0 SXX#YXYX	VY @B32uT6`*B,`* u.{>B.P_u.8_t.9_R@g JP艁GG }ayrangac\aXQaMFaB;a	70a,%a
!aaa
 f`ߠ(* >(6.> ,6f.R6D.VffXmAmZ ?f ?buf.R>r>^)1Q۹1QqZ 3Pq_r#svPsUszPss~Ps!f%#6 .,.>>66@lsv6. vffaJ fpO!f%$uc0R1f-&f 0 &yP跿
.QXPmqfZ$zs`*Bsf%'f
 y+`*^	.Q~

z.|t}u.o.G`,s} s^ tbDB8S+.&Z5JxU .Gu
`*?~u)`*Kp2!)`*B	) .c!h"T~
fWz.6V.6If@mR~|Kf }6Of3ffS'Ar輓otA6 fuD>Q
6d 01Tt	6݇U  } 4tY{o.V0vg&;p7RsZ^pu VVW>ˆb& _^VVWr>r6>] _^V'_ɡ s0fSfVfW)>ߍ64rt 3ҋ fݠG 
t O
tw= ?  68ꢡ)< 	s0B>uf_fVfY83A :r<+u<-uPR+ZVR-aQȵ$0<:|uYX@Ju 轤@ l>׎@> @vu@zV
lrS- w|Hruo1PO
8rK}?rDer)W.9u$% r$QqSVWwP <r:D9Gu-D
9G
0u"ZLqt.Ws
F_^VRVߋր? t u
3^VaWU3и<r<
t
<
t	:tuEF]_rs r r
<fw<ar,Wÿ<Fw<A7<9w<00 L0QѠf33w-.-6/ё)9/'"p22Yc0.0Ӳu>ޢہ
tOրxӋ6t>|.s<u= Q> <u  <u0hr).ڲӧ> PmPm߂DQBҠ_ w?>ۨ؀ `*s~!^03B>B7FڤѧQTpg&SCXIW )}9q鷨J L6Mr, 馜fNfOfAg&?2fffXPt ;á#?TmBPme2f.;ew-  rE%Q1ਐ tfGoɰJ圥>8 rU,vf2rmAVXTT)z@ r ,fffFgf¡#K .ɘ@{S2T~3a~M`t
`, ,ffV&Pmx@Qv"  u $t.$撱 Q fU.E.9..F.[:wGP;A5ŋf , tR5 uuufPm=RGf]Ѩ9@P:w;5.=[ !w f4R RQ 
	`ȿZ Z\$S
yf  X Z0Sf3[ffÊ$  fff?f 1%0$`%wߋӦ R&%   $ff8*** Please restart the system manually.
 xL.<t$
@..
_$!/t/$0!/t/?DH2撰撍6R3PIv8>Ko QѠ ػof?{tuCkP |O ntJkfq<4T WFOPAtOP;X >~ X;TY*\>~YfPQU T9GPF >Ju~s
, 6=A> > POXpV]U쁿f ]ayy8Gbff&f&J!KG>̀ fG`ƣGa ATIIPJ6LMfWf>҈!f!QQQQff4ss4ttf~}VP6O҈fasPVAVAVؠ0h"3PhXX[ÕXڥ/<\$<sYr.r@O C]CAp?6t_7r@Xπ`?`UAIJfQBEn}S  gf +u
' u d[Pp&^r c@CXra Jg7=)xxPe14l 8lmn p/qOrostuvw y/zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo  /Oo 	/
Oo
 /Oo /Oo !" $/%O&o'()*+ -/.O/o01234 6/7O8o9:;<= ?/@OAoBCDEF H/IOJoKLMNO Q/ROSoTUVWX Z/[O\o]^_`a c/dOeofghij l/mOnoopqrs u/vOwoxyz{| ~/Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /Oo  /Oo	
 /Oo /Oo  /!O"o#$%&' )/*O+o,-./0 2/3O4o56789 ;/<O=o>?@AB D/EOFoGHIJK M/NOOoPQRST V/WOXoYZ[\] _/`Oaobcdef h/iOjoklmno q/rOsotuvwx z/{O|o}~π /Ooω /Ooϒ /Ooϛ /OoϤ /Ooϭ /Oo϶ /OoϿ /OoŏƯ /OoΏϯ /Oo׏د /Oo /Oo /Oo@/Oo  ?_ 
?_
?_??? fRfVfWfU..f.6. + f. 's 6э>us.a +C..+.> uj.^q:
qf.f=   sIqOq r.Ьq
 .+"s q}6 ptP#+#`$+pĐ Pf. "f.f]f_f^fZPSQ 3<dr<gw,d P$<&Xu
 $	,<w .	.p)N.Y[XQ<uF$<t
.Ã? t#;OtYQRWSVw*t^w.;t
|u. >
f3EG.Љ.fEfGpЈE
G
.f$ r-/te8  99- 9.Ѐ t8=9? :@;P:?XthP[G_ZYrepe  `>n>VW>S; t6Ss?1@CsQ?r$?s6A-`B+ 15GC} ;, 5C7D # qB`C	ArvBr_^ rE<PfPǋfEEHE
EEfXSQVW3?u-6qCt6#L6QLuC_^Y[VWf6
 @HF`CÆQfQfPf$FfXsRSÒ3 E	7WTkUfQIffD$70WuUcT+9% si}
uFDdW+pWZE}t8YuS uNT-fD~7  !]6\0u]07 ^ i!]Yus]_ KT߀u#8
fɁYrgV1gV d_u8	1cc17϶,R0JfXf 2TQ߀Ysw0cYsVctfY+5 /j7 "k6k[gkq8r߲Wm_~lieoaȋTq8s"ns\fE-VVcD1SfڶnQokETf+r8s0W7T*WTߥ:d{ fD@@'4'f irfe  Y2pVQ^ t@lsF?N+r]Y
]ڐy3w@lD tM| /u
!9897<a\!5|6^<uhs
\ f!7s1k&q8sk8!~Nnj	xj95P:5i3wj+2fTaB{s
q|rD1pJg-kd
*fc.`vX~Q!}B'?t@R{f1%{s@l"⋟j嘭@lq8wAsZWq+@lw~oscT8p\5VF`^k5`K95FF<^jdR{w!mnlAW#jPХ8VYpsVr4sf7Ar\Bn-Х蚐f!E~F^ tttk%:5ȵn7sducn`o¬ʆp qrsTT%=upQWqh-Vf$&	!(=(tLQ	
v+`=urn2$0yrSFtQhٻ0<`1 (ұrLn@k@l+1| 7u Øn31|}3XkCm|`o1iVq$fedwcDjSjd8kn4j>2cT0SҎ iAy!|sdgw@?G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidi0phrTeFbgOCf_2J0#escsssdsfsgsfWP DVaX
<P ݰ: tWA:AAⳔ`D親A♔ A4  + *2+*4+*8o+f5k-JYsM?ȁpߋuJføtsPørcw@d
wt?oslc#fE{t~Ў1 `J!%[B
@lK!]rB!p2P!Fÿbx+si d
pp1B  }߃߉ߏߕߘߛߞ ucQ s0cE
WV6g4Fg^_rg tY	P!!s
P! !M
fw_ord d" q" " tbyte %*/r ptry c #WV.3t"h6@:hs6J,6K&Ys#O0VBOO_Οf^f >eS fXPXP
$0<9~F!J!JhD
 s봰+ !J$ CqYsp8e+s-шsf    nPr Pr  ޳ w  r  \  `|rx   $pr ' 3( ,܀T/ 0 4T7 8 <!T? 	!x @ 
/ H $P$X$x ` Wa 'b  f@r c &@r h ( i +0 l 0!1(m 5,n 9,o ?,p Dג+q G.r K.s N.t R.u U.v Y.w ].x `.y c.z g.{ j.| n.} q.~ u. yl.8&8:0:;m6;: 6;6=(:06;?8:  |U.  B  !k PC: C  Q)8ے+ !F  r !  ߚ H ' K H .# PCkPCנN  Ur O AT O O O H H H H ! PCx~LM8 q)pXXXX  X([8[  /ROp]I E  ]^8PC. /1( ]ːaI/ #rcb+ 'E^ ,K 1A^ :X:SYfZfZfc[f\f\ 7eݒ+ ;Uk ?C^&w D. Knw Qn Vn  [ ^p IIN  b%DrrIr4pp`qu WfE^ kE^ qE^ vE^ zC^8xAb`py~yvz vz(+mz0vz8szu $E^ E^w E^ E^w E^ y`$z|8fۉܓ b}87(bՄ03FzM   3`,	 0NԢщ ^1 ;  A^1 'č	 %e@+ T1Rҋ uҋ ҥ ֥ s*1 ݕw ᕔ 啔@ 2A 8UB ?UC EUD LUE RUF YUG `UH fUI lUJ sUK yUL UM UN UO T8 8(V0V8T@P鵍 e  e.@r1$`/䧂0䧃0Ip1䧅 2䧆2䧇3䧈04䧉$4䧊5䧋@6I6䧍7䧎P8r䧏 93 ew1 e2 e0 d8 w9ҡ    	     $ * / 5 : @ F    UOr!$  e K O8wSX ]v0b g kp u z ̓(&Ѝ!`ᗶ䜶m覶髶겶빶쿶ƶͶmҶض޶ϛ0(
6&.5v:?wGLRX^eGrklRFpsutz q8 ~(60684ݚuР़q0(Tg 50f83۾g(lRF8w8u% (08$fcuu'8 }D8$0 0Vڻ   
0 00V8 do8 f s  txMUadd push pop or adc sbb and daa sub
s x
 cmps inc decbaa bou
arpl imupnsb out q jo Kjn0c@z@be ja j @jp@`l jglg test xchg mov lea ncbw cwd call waitbff saPl@s!s stos lodcqbbbRb rolr rc cr shl4a@etp@^enteft!o iavemd xlaoop@!#s#fxza j@lockpne%e hlt ct ne doiv i'clP
tc (i i (d dbx1zx lf@g@sl0)hrd b{sf+r btp,sp,a,c i,x,sep!.`.p..zR./.e-@.pR.1 et 12b0gr*l*di14l14msw l -s!4sq4s4s5s -ver6w ffchs fab08tfx`"f7ld119l289me19pi9g29n";z f2xmp9yl2x fptan<a<re>1<xtrac8s1f>=S<p.p9sqr8s0/frnd!f@@7Aucompv7en:dis:cle<inf1 9B )fP@1wesc19env19c7stFGaGfreB8BB0AarG"G 5fbEiEb>>1EP@ @CG12E>MfiBIaO"LaM'AL wbinv+w	a@oQ`RARSzSRSR@RUQRlQ VTg!X8@puid rdmP,rdp&rdtFrsm ud2 wr!Zx1 .\ f\ y\z`&^{&^|&^}\{&^%^.s\߈x\{3%^3%^\t_.\G&^%^%^.g%^5a&^&^a&^&^,(%^-)*\.V`)PS\ ޤ\%p[&^X&^a4s%^{$%^<%^v%^{\t%^5s&cx䝀\|\5syw&y'5at%^$%^I~a5a5sQ&^5a|\}fe{$\

迾z%\c~<r%^<m t%^"y$v7%^&芵z)%^+t0%^-e{0{5s35s6Qe{9uf{;me{>{5sAjDt+%^F&__JdL%^Nt!%^P5sS{<e{Vu%^Xe{[%^]` 2scHf^5sie{lne{q}vu
%^xL{d}W{轆e{#\P&^O\oe&ߑϐ\\WuwuY&^_\ur}5s'nt杪ߪ~k唱#tN%^8etH%^&~  6 f3 t3Vv^
j
a
SQW.8
F  1 [Fn6Ff.a
>0QHY.&f.>R[  t8svJ $GG _Y[PQ.>t7xFYX8eF N!SD?r [5ʿHz QMY5 F߸J2@ M)F/KEQ̘R$ <t<t<uE* mfSùE' ; XEfPQfRf3 3JFfZYfXStï[_A mB C D P Q R S AmBCDgPO݀߁RS߃c?[ SpWP.@ơ.X.@ u<u	L <r<w,@. <  .>
  <  <;u.
s.p <0r$<9w ,0 P.p`ꏿ
 Y.l<?uf.[u
f.&aR<[`O?uu1R8f;t'uG⠰ ._pل	   hثv  hNȆg
Ȏ؎`Ѝbˋh i
  _ R00o  \h  9     DSDTFd  XHP nc8000 @  MSFT@[0\._PR_CPU0  _CST {PSB_C ݤ@12C

 A y 

  
A2A


\@32
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 7Q4ph`p
 gpid#d
 {`
apRa bsbgcpcgz`
`vdgDQ5phg	gi
 A6gA7phpiQp
 fp
`'fsg`f b7f cuf!bc``A8A9E
Microsoft Windows ME: Millennium Editions NT C@AF
p\_OS_`pQga.agԩ#`9 
bra
oua#
 6#
 )%[Q$I`*
E"2 pK
pA8_INI QAH@B
fpig
f
 pipP0g0hprgfata
apa`"%ahha `a u1
 bobiib3ub`\[K
@C_HIDAJ	_CRSD)
&	p 2

 8@ @ Q98
~!8
 C010;mp;1t12!<w;p;3;p;4pyv<5
0)14t=4>D5< ,16pBA7A8Bp;9 =rQBa"CmAC  D[p;B   
,[Ep;Cw 0p;D a;8 EE?A [
UHFE20?9@[J6BJ21`;22,23'AL4 J5'26ZAM7F00AM8AM9AMA#2Ba;5V>2CODOEO}F>30 A`;31@3133R4R5R6 @"Q7Q8Q9QA  @63B !C3CCC EeE3D0)3C
W[$WERF@40XR4143wM,44
P!`
p2Ba}aiapa7[ )[ib{ab\[X56
_ADR
 [X6"` E E47
W#470)480p/46-48E"6X9& @e<f}A0I4A [#XBK#4C(`p`hp`b,48ee` ap E dpyt?cCdch
{a
09b0d4Dhp,b_btd
mE2nuiP42dcrd49` dza
aPqn@(pfufQjf a(du7`['g
.gXFL

 
2
B GuA  EvFw
avjܒw!94
 Iy@v5
Hy bv?y 'FdDXEh['4B B@51pibpkdrd
edAj~1ud hb sb@rb

bhb2ă3jă4CDj0)52CE23 @53crc'54BbN5gwblar$4Fab@2b2B4`21uDq3bu14atb
bc4ai`bac0`6p
f@k56tBA7n ;4F
P52cf54cpi53&[c12\baa'!_S3D
 4D
[7a pW

_[HN8aa59
`
[I	Au5ҀCDG5jaX5X6Y61S2 @ 63 H#64    ,65]aQ66@7 ް68 '69#A F6B 0C6P6DAEAF'70I71

J#710)7223 
<[=ѥo  @475 ࣁM77r8  L79 A>7B2C`
[+:D@7E90_7F F'80  #81I8m2ѬĤ8234Qp/85UPA86U,87R88W!98u8р88DGE[#\_GL_(bp
`{졳r`p`!
dv`J`!8B8C{hr0jp
Ρp
HE0904>Ra0q,8DbAr[P~bya
c}cbaa{6F
/` hdvdwd
`y
`ayii62c{ca a@90 (8p@A1x@9{2Bhi09|P!`y`jB,936``wh
0)94!pi66payjabypc67c d}d67M#9?5Ei"iS5
bMbC{brwc
e1sfey rer 
 dd)idlh
 y
ce"πe0)65caaghZ`z buc/` P0̕`ij}0`J6
)705)6F&SDàұA
 i
 A97qZ30ipRi6BGqQ bVGe0}8cD'%{㐺2j
O[IFP$]9 @
"999BCRQ90AE F }C0IA0
"`aB`wC ޠ
P	09&Nz{`H a0 
bw
t
	rab@ C#*1@C0p%{Aw"@A1
pI6'Bp/A2
0rriH9D}`Fa{q ` 
p{z! wi? 9A'{a` bA1b a}C13	B`pADwo
h Πl }q( qQ
ccF0CA4
l
FA5 ,A6 1p6e {/ky
p{A5  }2e0 lj
zq
6{`q}Vxq
7p #04b}e
e/d
\
 r !04	e`04e}`p2@dAy4{k
\
0f`}C
 9C yPCp?d!`P(Ad pi9ABsBe[@=A8p Ԑbcdyce@
	
Ar,AAhif"f
j
q
9
Ebrd_B	!'Sp,1D@V M 6SC"HIS$"Bb(%pS@oAb	c@bsD1p{yacʭD`cE@**`*EF mdb`ABaaXA6#aaAD

[>A1WAqAF-_PSWeZZ!AE3F@qQ3Q1F[(C0B0&`B1Z52#`/B3 0?1_234564az8J9:;(<=?CBp_!a
q8A cF?Gp7J`
sJCJ09J9#`H0ZBA	7B	
#  y ɋAP!B jh`^0`׀0@`"BD:AP`BE	Ri	հ`	`BFT` <!V tC0	pWq1 aXޡ	aXפ`[OC 7__UID
`_ST{A SE^^.~!_DISqBF\\_SR]SQC0h\ S^4Z7Za[\B?]ddo_d`aH4Z`@Zbc\COe mlgmh4ZHZck\D_mutouq4ZLZhs\Eou"}|w#} yq4Z@Zi|\F}2ل3/4ZZj\60 B錿C?4Z$0OZk/A1RϏSOb7WA7\79з@UF2з2-[QX]B!CC
D޽<WE [#Q"XPF6V	7u![WB%Fv!x)6LW46[KDWDID Y>8D2
,19D2pD3 4
L45 :_REG3QD3`@D1ȑ1__S3D
4m0D6R)(P_D7
 hA33`PP2*!VЧ84ñWKЧ9
35@{
h {`h)35i/12$ 1\._SB_ЧAt
a._DOSA1
`aж[^ЧBbbha[D/p/
_DC"aD`!5Gs8SSPXе+h3D(F%Ef
%F4;
%h^E0 B ؟D7	5`Նp{
P
{\/y40Ա86

E0SE0`D   ҳ !ҰK1B}풓hip7A@h ! ?@_\nҚ\/CA{FE { FFGH58,1
`96hjߡ
7hi``8Fol`CE25Fhb810R7FCE7Q!V E3g
^/uE1klG4 n/86` "oa& ΕEE!"aaC@AB[ׄO	7+R87`@05_ON_ ?87̟13_OFF }b_@_PR0PXE7PX58[G	_GPE
	S
@[p
Gb b Gf f y 1E9EAEB`CqD

EEF`
# pi~iط0A
EC8F0 [Bq  @@
@F1  PXF2`p 3456789AB ВFC FD AFEF oC100100U2	3	4	5	6	7	8 9ABK@C1	 EFC110Q1Q2Q3Q4Q5Q6Q7
1u890	1A11B_INI 
11C
>LA`DQEQF
vP201
2
312e450K267
Unknown 
NiMH 
LiIon N8P>{R QE9P@EBF8`E9
h!VDEE77TUA11@Ia)E}}hQa{a
Q"}qiq5!q6)20 *20T&W129	X0XCá-&4"A	1-pp
a	{`bI(B
[)h`p4`
csc
  dzi Vr`a[)av2bsdb3/b31R*45O6ccHC	@Shg0A+Ag
1E0!1F{`glDEhH!'BpмFCܑ0`=Fhi 	@=00'@ w`

axra
2 
dcbpb'@AC`fADa1`aCx0KT1Fg.1FT&`IC130
9+:p_
 'K=;;	ip
$1!0o<G>9	?P	D2cA3cF >A4Q 0
{``Y{^``VGp!:5@1R  9U2c cpQ eבeYeQYxcpecpcY(G20Gv,r32`(_Q03PVTNͲ _4o_<p
aCp
a`aQ05\TZ_ I3Q]Vf4['WfSfTZ3_paLa6 D
 0
h!135
hPR_CPUy0kh1_
h	2@me7/fOgjh0mɀ ' _8 
7Mj
 I`4`=E0dj
k7kCk8
`=H# _9 	Fj
v[ _A k9$zBzA$zEz`_Q10 -uM ~XrJ
sttQ/y	vđwx1^xuF
g{-z8iR=z7i?sd0^a`<W}aP(32pTaP [QC
3B
N$ `|13D[O(3Ca `|E_  `|F4p41r4P43 44 L
5!	4Vq4789
m414 14;14j4EA5051?@
[  '15153ҁ5q55V56r5I[58G55QU+p95515A8r.`)P0@`p`0ނ a/
 y6aa JpB5CE.#bcCbAcNB~9c3g~EbHp! dp50c=5CXya
@
 d
b
 9bdpdAc
_ c
9cֱ9@/5CO`5!3`kaa
a
vad_ alb1bb
vbdbS. 6pХ4CpbqD` 46B9#9Pcp 6E#!8zj00D5-0a=pE3ҥ bb	a.c-bbG
5F/583pdW3F12`  `E
60 *3EFFL& *41A2}61
{C0`{` 24 ia`q`-Ahp
py!@162	ӴB`2Uar c㎠.abc!.dK~(63 p^^4cIk65۠L
P66

Gy Q׎`j168sqȱE5BY.668QB 6P`n09[E6APS _DDN
COM16 AC6
30" uv38y S 6C/6BQϡې)е!+_DIS u~233`-6Bt`F_SRSph
D7ED𢧠r.6B@
aa0D

(Q!0(@u1줱[6E O  
"䡴F}__ON_0r
_OFFq` l0E[H:pFE4C170_ADRp_FDI"`
O
_

߰r%r


e
_

31İ4
GG?"@ *Jy4"3 
`z#pb" ~72p S..77U7!7q7779aAB	,`7B`CJcꀲk7eDp:)75*GX_v'rC1810cSrA@+cʀ""0.81"C(.r("`P#G"%A4$[P3 @D+Pu3EaȁRMV78 c/0E4gcpgpg	M E^82
)2a2#3p^0!`@u838_2[L$4CMC
_G 0" *
G9;9(
KCc@^qհEA
G9 Q*!?_;@"#
%P/'O(a)85@+,85[C@86 `QM7p`ˡ\ Q28
;87`^x r48Ѳ58a6
89eH
1 GxxR<xxg"A:rbx:xxucoefcb fNd2he3hb hdUliRlB58P %U659NAB qxx#Q9G
g *JKR~&8AOLaM`MLpr4PQ?Sٰ&x`1Q2A0!5pq&b& -/UOV@)MqC(+0.&0 r4΁aZC)58D p\/Q45C058@5(`O{r`  N7D2[#\_GL_{ϖ3
a['R$hQGPE`MEob}abg
9}[%`MRS = J"  y  9,6@ @ "~[7Ct 
9G Ҩ  _ *Q" ta aW Q-2t
Gp p Gr[ r" f3` `@Gd d@"J[˂I9 71
" y95[
29695烵᳞W96&Ow.	Ѹ и [++7 w    ^![N8$
99

[AѳB[\ @QCѳD[102"
G   1Ȼ _9C
9`. [#p
Ua@v['F	p79`  
A0
0[큐A0A1 nINIA1⦩Aa3H3H!A 7c P C0A@S3 G04 GB^ 7^PZ@NC098[O/ 6 7Gq,18E
_GTM 1p2 n`P ˙90DAAPA0Ab,ߢAB{T߰
nA
0A9T1CPMA`3ߠAC!AyAD1@5Mhh4hhSPޠFi `1.
w Epa:`` bw_b
bwcib ac ArbTrcAue`4eab8c5AFb[caA٠:5B!.!{P JprDAI
Dj?_}jj/C21zO`pڟ[6-F &1AّB-}-
_PS0r3p K3 ߠO1c`AI{
ƙE4
_tM
od@B3^ O/Z
B A`1`ia].C0C2o	
# %3O&C4'C5(C6*Cm7O+C8,C9-܀OoT OB4G
11 1Z
1$4p5GC1&
 V7)88(88.58q59Q6A'P5%41+0!121>7G%5q,01!1:16BCz1G 7S7BA,58qCF QD9PD8PD9S7
7&;1E+22F@	F

1"NNd
d
Primary 
10aP 
LIon 
Hewlett-Packard EM	OTravel?P[Q1ME'@W1MDW`tL2C	Ey2Ch`/` %
 R
^
 w
A2Fh/A30Z2!`a B5bZy30ham`_EhpA`|ԽТ
_UIz c[A !
_BIqZPPiSTA3P CLw\[G 93xf6)rochB Yi2ifj*keP_
ACPIT3j>`!Rn[8`9nP22 px3A^v[:`9v?
*_LIm9<a86@Q%!
	/1?5?@SX/P{NFjcY6peB7p
e8pkk`ah`piaFQ?Bpx@ a{`
4ޓ }aWqap`k
aW 9 Bp/ B M B6@ lBA%h o

 +`! %rW `Rr` %~Վp}
yj`-   `>q1h)σh` AA`ibpbasabcpcau`a`BBrw i`zC03Fm
PDaA43b`a
b

/CR][F!ʀDvlWDGD
PRU4<SMrJ/NAA T-MP2TA;9Kp$[?AC+|Nr2J)lBCpCWQAA*%uqUCES
 K{QA`!&эxťR 
q rBC𖰐
KR]B
FfghiGWSAB0
FBCipi1F[33QOC
COMPAQ|PC[ CQ SOt±Reader|GEMPLUS|GPR400|PSCR| '%WQt3ŠBWSWBC/E0iqrqE ~a?w31a(ג``2y03m4aa46P0
aBF JQ1BFl[#\_GL_yΑ037и`pj`8pk`a`B\ &AhѯB`	l['ҿBFpy`C0

G[pP1`C2C3 PDC3phaC3,PۀD02p{D1{h
@_C1p{z` Sژ	PFD2NCE  ȠeDDsap67T89TA\DB pC r~D   p1DD@DC
[bE@(AADF1E0i EAE12mЋE1UyQ
	`rh``vpF lEX@"נ cdJac
P`rdp b}y baya
a0a  eraye
	 evepe7c uc dcmME4E3З bpbgC	bdp1 apbe)ee ffg
fape`pfpfgvdueA`b7` g`Aу<b pg4ܿFaggagubdM: 504B@ǡ yDApP`c
pb8TR9by5`* aDaC yAE h7h H
bhpݑ1`c `rVEc adQR
edDA@-adOft`fuӟaduc2ftdg0J`8SbÀ7 6 DQЋ4ӀaAq4 yE5@ aDB0
_INIE6B51pibhb 7p[@E7PU8tj8999bF0EA w
arC00D`bQbpP`bab{uaQa"
hP
b uap+_CRS0D`& 	bA`.`mt"
p=}``\/u1

	0   yFUa1EBC`EC1
.GG 0 @0/   yrEC[D.a1EE@L64F
bG` G$ $ GN N P P Gh h Gt t! B   G@ $0  s$$y ^u^.E@63k0_4KA'3R'("(4')"(5'* H\_PTSp}hFn2CqX?v b g
蒐,[ ;605L \_WAKb+)3B9A`/0EB5J b96aF3`_8p997',Xye^1)v=TZEF?TZ1_
f@2 AP0ia@pv3wbC-
C-EaG3wcbcccB5A)a9dB2
 0YAiLB3M4M5LH&F ҶN\?`F0G,<

Tn
J
bT|UVWkbAZYAZ֐VS1F2prS3@S4
SSSnS8H]SA'SB`CRbS3ty4
A0	FE
C6FD
_Q0p?1DfgEi KSF
:@0p
ohgsp
OEsi>f╟feliooi@@fcH	C200
fhFl~`cpi`9~?kWlru#n=Ci d?oVl`y"nB0s1eahFCi0~S~0s2i ` ae6+8
ʒiP/{DpKDF 3
 0R}Hщs33t
axa

`blK08E
X
btg*/
0/
{ߎX
#
PoyWl~C|I0s3	O?p
d{	p
dHoYdeap{ֆ30 e{b
 t bbwb

araMpL3ao671?6Hno7 )aЛ}A#h Л}B}p0TBaFy
 "bM034	h0 a`<}se882A0s4`hf@3_
bP3Y4c@!
~h `t``{x` ff
p{tf!f? a啱tcbybC0b&qb[bI	iep
d
iddefBi @H=v>H=w>9A܈@	a_a~a[60s5`%bpe
__ON_sFwFF 2s
6
)tU
7
q)U
8
)tUǿ
~[39R?V _PR0["A
6Շ 67C
8[{H@_ALT91c0AL2cՀAL3cC_AC0|^E 1vN2vĐL3v\PSVvQSL1PR_CPU0G|D+a_M
6PdF83(19]p
n^p
^$59A4_TSP
dPC11TC2qCRTЇTMPpAP~`[GAEsP>]g20F
R,"V
**3P>oNF\_GPEd  M
_L00 `ɀ7{` @>,{`
%y@ o'o_
p3JL"4M	BK57	CN	DPI_L11%6`43W6.0up{g1
946=0A0uOQeRE R@~H_aI@ >b@ 1~?F9pajam b?!" !   $K 7 {64?`}` @/'4=7 8\6CK C'."((p08N0oKLRG	R D0$116@3C9AN,:686  Ɩ29,. s10	p,ЂF
3{~.8i@%/7iSSDT1COMPAQCPQGysr   MSF;T1A??1@W
DpϑGy F  GQF2FGGkJQF!_PDC{h`L PCT y
L 12O1	_PPC ,A@PNSSNNP`OSPQQO 1RDSR SUUoW?X[Z_] \_^`a_bcdgfi0jQ_Rl ?iln?opq_ts vux?x_yz{_} }q  p  
    	 _BMp "v }(   @    #)?_! ̮ _ 	

?_2ܾPV̾ $q&"@κ`31$
@π/H@l"!  "A$o%&a'1**?+Y,2`%*./r,`P%,23,Qp'O.o78$22@S;:;? O>o?@g:"DCBC EeHA22GGF H=06O@My:M9IQ)Ρ)4AIEsG06)$ܢ$ U^HPIAQV$W)T
WQKFG dX ?[XO"3Kv`X2R^"@I$Q%%U5PGabPIXV`6q$RFhX?i2VjfXRT$ mmVPn$qRXlqkT_ stuvx?y_z{h|}~RVXercWP\0 ZVtPI\~N`dZqvPIZ~LbpZZx0 X3
zRV~Jd҂ G1d$qZ!rEHh ċhV|ċl|R!qHj!`	!qi pE $ Qx$lppogj!2lfYrgCg)2 UCCԊAC`0 ,^20 4`0A`A@YZPIV J$3>ࣔX #(0ঔV󠱂%2TR2͊a6 !R0 A`6@֬AagGP2.0aCNPI`6R" jq0PR rLPI2״02a@ִ2421J%44@͇H0 @@ߠ7ܨ@r@ΧFPI8224w8AA܄ѼGDPI:36(Ї@ϊ<V4͇BPI>ԊA ɷ`ɲ*Q`R@)@	8C@0  Ї`B2JUB(&3%G>PI%D0(RIj D*3K ԗLչ,Zj HĈqViF%
̀PKg<PIÛ!
0,1P`*ٱV*ᰛF ݣ!U)᠖ZV':PIR&0 ߂aKe(j@y䱀j@QB[@ߑi@rVi$
ԒC8PI (]FQQQ 5jA !/"uMo``~(۱ Rq?O A"2l% (o
+  -0 O3oO6/9" > @L4<AD OGUO,NJ]=R!/M?A kĨ#S7 [S)\!O=
\$.@ !`B`:`} zd/W`\Z	 1Qj[0Qi]`[_Qot#pbQons߄tPuau!ځtA${am@pqB|Rvqga$&Q`"Oqg[rz݇ ЙjsqV=2t!Fԅe;qkRVqnqT:a]R _qkP]V !Z{QEPNSaLeB	LVEJQ (%:Hݻ,@ x."C@Hx%&D)RBR[!F<!b@˯T8 %TV*G q!XٲQFZ@;0л\@6.л^Up,л*(Br`a&P
dтۀhf ~!hD߀yv
l2xbbr>@pA} edwvSN/:S1F~]P  HIhQo4# QҕHʱf|p@ذS8ЬJq6@1س cz0QݳcLE#x3j1֓ܣUraA2q`bKAŀ`ȠQ4@At"дƠ afprR?_쀿?_|        @	 _BM "| ( n s    b#        d d> F ."    f  f  `/zj
/Oo
#(4UfeC0$g
S, ޑX_2; 2$_"w wOo2c~5xR@2}ch_UZ?p?d2&i% *Y !"Y"S?2R"_jWz"%"k? c& %k`&(_Os "i%* "
*U?) !j"_@"R,*-[++`&Z.{`&/_d0)Jb&? &2J2B1O2U0`&sdbQ14`& K2$e6"4468{0q/
"#4 4Q2_8oh9W	y8o Q2;2J-) &S?{9Rq/$1CJq/AD &;B)?C9E`&EH+2A; &:B2C3&eGu &>Hq/Uo$FB2b/A!"TKQ& &;H%D4@1SNJ(`K"%yot2=HK )B<QjN{(SUb/B12@1]H{ ?)Y`1=)KKI4"2/A@"A%TE[")FEBFQbIp$y ?$:IO]@"QF$@11^p0$E"9E`^$<(](X(T(qI&5S9J7dJX!5A#=Lf((HqI+W@RB.=U)mHq-]ks0SWS@1m8Kq/Zgo.d0 ar8DnWoRKOfd0Bo sodWQB"$0${xd9sziEt"+ 1a{D1&ra2&}(s<sz[O&)pJ&dh|8b91ak'}BbB~0(p6$xSqc=8C;FTqn2+B&|Z]$%Uzp<H`9K?g"59Ws<Y@|U+⁗QF_*w{O["s0I!D]]6-3JqQO _F~SpZ⏛]N-dhCє]s9"1wX]qI&)-FI1SnVo`'Y%`b=]d-Q&63cSS&$R]2)_$7)O)(3<1O$k`E-7HN(RAĬ2Üb/4 D22Q&_(I"631=oqI8SAD79(83_9$_SeWB2q|VOq/XBQ1t3C);"
q9""5Q21,Q&QoDq1$+`&m A-H:UtXk"-DEqJHS@"B9a?BrĞ(H")OBSAT 1EI'B_KY HS& 8o-2@")c|%>@"W &j &4@"-aQB8zq!s@ RzT1U !\RBxOhPB V`@%*ۺE"%!AoӍUHOPc i$:U_#	I VG"0% B{tb "E)"0B"O@PcB7" &3 7Π SE`7Q oӾzEƁE :"`$ !p"@6.RF@E4R@QmE8gw Ph%/Oo@	 /f B

 
 f5
n
     Q   `	 _BM " ( _ }    .#3  \   G? uf  ! ~^ 	
H 
 0
 "02 
2}#=-# 
-W " " 0

!
K
ݠ P

 @P  
  iD0
0
 `0
A#BT$]P0!
0
Oa&% I%4&'%T&#&%(s)*A#N&*:+0
./ :(-!!//
+A$4D.2345'789	 0p"AB0#_<=>x+2,:tCA02AC 6,?'"A#@('	@_G5C(?/"+6O"c$E)\BOOO?p"p"@!2D* .2S (#S@T AS!S#S!SA$N7 , 2IaTz Wt-Xp%O4YTTXp%NZTJ6.\O@1YV!2AqW ?_`_^\PaZ"abc^2fd.a%@^p!Nfd*+[!!Nfd(+jRA7fd&h N
ZPDSfd$"gqlUNlA1Pg#OpMc"
#Oe"pB$OZEc#fd O(PgB$k4s't0sAOAuK'wwh&ue'xOv@p"qnz'z ,
k@V{NNpl)'z}J. pM@O|}}#.a~pn')k)AO .sZ.d."0
pD'Dtc")pn!.@6`WP,@1|]\TsJ f&AOFOT*OO!zJG -r)ra}!WP@0!c, 'Os(.#俘6"aJrAONr2t'@02!A.ARR"#."r-e@c$AOR Iw#c,A$!OPk(a$@pE,>қa$AO-9p",  v"qRYe,( AOAVeA}r g#A)!!ca"pn ,z1)Ғ9)rx KJA{}p6A1 rÁ#p0Ų !|B Tr{ ,KA$x$'ko m"al @TuH!|.S0$kNqMrSss
rpBPi ATWrne"  #02OrlBg$"Sp$,hS!SNDRTf"p! *rnUa0m67٭4+AJ8tBRdUX^XU ^U1!       	 _BM " ( k }    P  #???   |E L  ʼ  jD 3  ! x	jr
x
F
 
 ߲
> 
̲
E


ސT0aRUݰPr 
 6MCutR
E̐REѱT!RUtP
ur SM@%0#W,p0U>P BPI%ݐ:A( )ϐ(&%1(#/--
 <
ABa
R59-4A-,
r )|6+:8
6Rp8 "<0-<R86x=i> -
#4DC5/A2,c=A-pJ>s<BTDpCa+A9A8/>- $DQa!8!aAr2 D2B
M$DE>

 )AC<%O AC:pO$"P8$O&N6
 )(DBR PS*D>4S,D?2S./D_0S$0VO.ST0NpWT42DN,S44@V*S8D(SZEZ"S:D1&S<D/$g\P"S> Y]TE@@V S0_P BSS`D@Vzb`ACUTNWU4PC4pb30C3Qb`C
CO*pbPbO
TdabAfAfE \
GDAdrbBSpePi%te_}?4/$pb/PbakPk
h/#dcb0C?0CNPemnAj4jajkimhP#d!k`gmBcgneonpCgN
`Utq!oN0Ci3
4recneeeUT)Pd#ddoBrgPiqeB4xwi{bp43aBtzTrfRlg!Q
SNanN
2fu/Pe_rgh+? 
a!gAe@dj)anup{]r4BPCq"$!f"Cq!CEPiACW3Cu10Q4h$Z M4pk4QBjRUR_
 JLP qFpU?яBJP	 MSH hqGUS34\ . ($U_k (
fwxGw@?HqАyJԏL(яJyPM
vfw:mT opO4pOPwoy0oTyaњ.xPG,PSП
ph*П( tzП6Px$tqyPocКSaxoW1  Sҟ
갟ogPiЭopx
oA#SПvp𚁯ihpgfRh2Яy\pvrpyfMnҶ!v u_ПroAP0rھPbrFf]ПPv
ihПa ]JgPПoȘ2ѽК P\aAxrp`Кoi[21p@ZaGiѶP9wPPfҟay6YyУfvRvWipAhpfpfPvVph2ԗd@oXКҟZUPagPԡaT1o$pRpO@*TՖRROi1QCOѭPPOMi@J%NvNJhPͯDeBxH
АgވwL/
Ӕ   D 1     [؎c Ћ㿄Zc+3f  _o L!$F10fPfSfQfRfVfWfUCES>^  fB  _  ^   t^  t s $s@P$ ï t
P
@@
 
_apf3u 6T`< t_f3
 _>T`jR
 
 _{ b>__;a 3ب tKPPtPSQȁ u3Y[X	 SQ3ɽ0	  3 w XP
3	2
 P 5P  f@f_f^fZfYf[fXfV 3b>_"b t
	"u&"bfXf^PVW 3W XZ_t
r
>__^P  f&T f. 1ff&T $.ft& )Ot..<xu<\߽޻μ̯۾ݷاЮDD/(|/8-0124/5!7!7AA$$~"!7A:90@?==$^$$$`?$9 =I@s>0p>`-;`>:@ @'@C:'YarRE9 @&9<Ew<	I!!9d;Wp7A";BQCCC=(`K)))**LLH9BL~B<y =J  >""ZFYI#Bdf9N0Q#<2Q` B;I~ =hxPFN'yNQC<P!B2

	F"cXSI8 = F8 0 p81\	

dC3@qV?$$D9SE\CRt;((DDPE B=FJC#F@9
)HsURs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍cInIڍ׌߃OsJ\gpjځBȉymFGł񂪓rݏOڕKvxmȂ튮xrWԍtEÃ_xƂ׎쐬݉}֎~HS\zԕzfmQT{ǃ|sFV͈vd}YiEь십ċNԐUiTivǗ؊qlӔC~t`֖ؑ{pKWoYgȏlϏ[x=b m@  0E  0 ` < 	i޴ 6 @璇T ?'YVҕ
 P g1!!#"& pt~|u  qp?  7  ^ )@fc1 z02  )2	` %Y   `00;BF?LXp0B$(%ҙ׎<Ҡ`Е08 _D`?08t ԢA|ģ   UP W  >"6>O >ǐs>?~!B""!B'  /!B#b&2 `   డaLwX>ap1_@@@dР @Р Bft,0<J@Р0` ~1^pEc P&RÃJgІ 0 UV 
	0 P $&# 8_ o & V| D~D D< V B f<,$$0$l=  ܀ʀހ?3`0 ?"#!! 0@ `c 	Ԛ 8	  6 a@1ppP!3p%`မ @\D2"##X;ᒠҠ@<| %rm?  20Р 2  1$Q$$ށyH A{HHKxď d $̀@@@0!c $2&f# 0;0xx R@rcxp RT0E?V@@`)X0$x|pTT T8_ Тx#60 @$1$484(d(lD@&1< ?! ?&!<? !!# f4cd!,?p|E0 \Ҡ ޶!c,$9`0p6Eb ° @ !$B' }"""  p 0 1dIi&0o`@0ⶫFD
 $_v!@^@"  \#2Bb"6T$-`0 |px39@@` 0֠pa0E 00`.=|s"ѠҒ`m|%o38"5U QHU' &a! 3?!  =!!3#AO2bAb7?1`		
	`21"`n9$i$	$	p::"33aΫ7#F?S8G0N0#@!"*22Hi)""?"!pBfBИ'  <p$P$%)*$ $ 'D,!## 0-!$  \7 gac#1" < ~ < QJ  <$$$= ??d)),?4+fI`a߁'0¢p6( g}0P`q6` b_.u/  -'@01 V  <  <X=$aY<p0b64~
w*0[hH\=  ~  <P {D=<$R_ܱ15''v谔Ebw`Apt#e?XI 
8hiЂ? 8P2pq2oDRDl""z}"n""s0 'Q@Q`Aq?V`Rq#@<1Rd,Д%}IHT1y(@qq@,Tp !
 .:23Vn&  } Sb b~r7/x?`RI l n2"Rpn  @@4!
0`ԙ ?;>g|TpcD ƃ)]+H/Hp0D 6bpS `$$Ϩ1 FD @@1#fѾ~(3H2~RHH~HH   9 "} 8F ?8R)C)E+D:< ~@""6@Q6q"c  2"&	$  c2$`k"b'gODu;?e ůRtb@5uŸdP!
U?BF0L ?q?$&""  0p	ޠ x ۤ	#`4 cp4F8} sPpP? !
(P# ?@@DDDD0!cD7 u!0&DL|(0<QR!=t Q>= 4	6a00i#!!`j0 ` 9?!#3"$$4!?5!#! ! ?@yw`Qq7 }H 4 }b2C"cy @l!b @!q=x	<	pf8Pg( (=ϔȖk">@?0{o8l>%q&?3
p7b2  1#n%sr~#$% SvG$?a_%h|  1  !    İO {   "rт&#0 0  wP1 ?c q"rиT

 Pd'=@߀ Ġ"!A+] A l1>se0S0*38%  RR2R2RRP0@Bb.a4dP8%cAR-OeeP7
 PpgK?Da,=%$>'\!"BM "00#;	X|D2D"DvDTDD6 #W ay`]x8#A `Ga"@  Ȁ1U9-$d=_4d8!a	  6 P>@ pL D 0`Bf$,892k&	a@M0'Ee 10bpxPX?	 ]1a3"&,0x>dDd<x n!nႢo8|	(9H;)*;*$*%+8TT5Vd<p36b";5X@աp{ pUO1 0 ?R {`0C"cpz @M 	~*H0&0K6cւ""8x?~!B>* #"**@0-0o,`f8a00"***" /"$'$&*"$"D?^2E?0``V?~$BdBp44B
BB~10@	"&D$(-y`_6,!	'	smsmf /.H/pX~X_=I H<H$H$I$= ǉ? @<S>@"@">#"D"l>("8""8>(l6cЋ   N@PāD4R$zeUS R Pe	Zf!8! 	py?0 ;6PPJ2A3r
~! 3 ?$$$$5d$Dd< ~  P0_@Y $D$=ЋGC1qTRЛZ0^ 	/$y,(8h(lqD?  /"?(/(/(hOX \%2 ~^~`a$bqQ	F'"@f`Tf`Pg0#t	 	(00	?$ Z?			?R" N1:?00gh ѓD= D~ = yPPp< %Q8= @|D< !!"!"="""?;@0{BF\p8@hі@A@uCb>HHHd,$|$$$TdTDTa##:wP>?~'$!$34, g A>??$|. }1Ò aL8`H2 &2 +f!b62~Z*\*jI0 /:G; x pQ H0	  y 	w 	 	lc$Ê'Aȡ+e2A-`-ސ-pzAsG0 a B F>lxPXHL0F`C Po0`@fǠ0P0b64~
**hH)  $lH UIHUH~HHQHU~{HA6pC!!`S8 2@1b)) ?()()~?H!!!aGaC,40p" zs"rK7K@
p`2P( F`p= B> <$P'~0q" ">*>>B¨"&"cb@	"00P  ` x7a3Va0a?"#
 1pxLC|  80 S#Q8#C"9L8<
S0PD  > "~&%,?(l)$ 7P?-0`DQ2!;VR!q # @b p<䇢Ap*f8g "**~*B`Xb~B$fAf! BFD0@ @`@ C""p C bB ߄:?~>"
(L,蘥"22gS&pC)}p8@Tl@l$5?b5d0>cqc\^_x	(	)	) ( )H	p_c 5aVR\A?~"!"2&460ba "(*F+8"mqig@8pn!̠ސ0q$
&bBO6  |<  #<@;3 3s `
xp ds12m8@ 	 `p1 3"f2 "|st@Acp>u@$	,	(	88(2l"FfAgAcyOed!'$Bg3
D(zo


~g<P4 7  p }#"4&0PP0h`@   :Wao uUcupp*	ppp$p..z/S.x/Zv/  [<u.z/ B`uVʊ8r
8s8t>8t: t3-v(8r*<rw.p/` aa 23P  	P#"RV{^Zua `R\ts 2ƃǡG
aa O sV
ENjW12wts2o		 T<
t<
tD<tY<t軮 PC  VPP t	| tL^fn!t PD0XM  Àt	¹/ u 2 T.>/u W. "! Q"" `.p/&
 u2CQ2P Y*2Ȱ&P% a#`#RDr
././PSR% && oZ[X
 OCP"P)" $*+.6/F1-F2q-P..P*,/WtO0_P(,4511
*QR.6v/ʊƳP ZY[X7  p$r8299OsP2 <sP
X=<r<0<rà
/  /.&*.5fu'ha /30!b? 67@8/B.>/P2BX;2&BB$CF{7PQRW,f
 _ZYX. 2.9`?t./DqB!D?<u<<@M<<@M<@M<@M{<@M<@M<@M<<@M<@M.>|/ t ?3ػ@ .z/G.|//O7S@T.z/.|/TzPS U0.././(eS;P(?  XDSQ"[@[Xd  WV>	
>  tj6 hm_t!j^\Z(_؃&  hEP`jFa4_ab'c&bbo'ceb>'c&bbI'c&bbbba4_%  = Wb?b?'c@&b!b#5llb$#c5crJaf]fffarNa&_(_ؑwa~r]%p% ׊Qqbnrf>_^j_Ztu$vzBrU`t
|!rK#c&crCt&_tubbbAR߂bbRaTU~vzRDTU	߇nRETEMRC|a#R=H$wĊaa&bbS$w"Uz"UQwۇZ"[aa"Ugaao"ivaI!(_ uPa% = u	8_ў  6_t9j9#c6je"WjP`^jQ_$Wǁfh  nbb t+t'fhjn_$UzLbbv.at,>ܐ{jh_fjhIP>n{%j hnaꡬ 1t2>a tOafhA㡬ϱπ>b b3Pdl_ tU1Av`v`1Js㱖PRJ$Af3f
~fPFPh=hb蛦Pq_h`A3FʐмH0}=#h&`k4h  &`Q$ V`&ha4OƀQ[F $KR~cAY~cQ /TP
^^Q̴r1īh1]FӿAP@j}h!bjr1ahaBdPIT#h^@`^B,vİO%hְὓ4? VޡؑװȰ*_h[hߴW4Sؘۜ(1k@^_   V$b^F FPL <tPvV0FF~rыّ F FIu`F&N-^ ҊF*+FVc+;u;uàc% ;Fu
;VuÐc	A2Wá9Q9@c% G*a*	
WV~FF&8uq@ړ8t
drƋ*
߈FLDNuq W~P`F @fj hľc*@{ f0fҿcs"J!&]߃&6_jLfPq|a t[jP_faj FP1uo $F -WVPbb
V=ut_ V1#P`GF| K50u2<5|1c:4 h &1 F? GPREa1FNuFGp>SppO_
<k4"1Y,Fe"2l 1Ԑ&bb"&&>bb"&&obbh)&&IbbK)&&bbb."p*& &?bb
)s&@&#bb	)/&&$bb!32&5_% &9bb!3u 	0!(6s(6_bb|!3-8.6_6_d8a*6"'`bbO!3
2&]% +1]1]jRq/!3<wu3-Ԓy=_>=3a@=K>rR&&&=&_1`wj>C1@D@DA>E+@DjDa>C-B@D0DҦ?!(ls(l_jD>HC_	2&'5DUE>(sMMDEC>E3@DDMH>t5NDEN>qS)@DDg>qS3aF1DjEiqS!(@DJ?5_UT/_jS>UcWUM@DU>5cWUMD\>cWJMm5L[2WZVX3`w+Jl_&l_'_ jT	qb1`L2l_fw^Z&h@e 1 ~qb"'W Q8bq`
]@f\{MT{kEJ2;#g/y @qb/B]$$h$b@1 a0i@Ի `Z^ČF&&g&`&` &.a &`arҹ byv`yy_ynzNtynty*cyZ|jL	=Qpb$t` O uI t
` .a 1 u3av? tw 	.a01 dyKrER0.a@WU1@ф!q"CrѶ R$ ~LUFW1Uфw[awÅфr
^u7%O``uQu& `bZDx_ܪdZ!ypy0frTy0hrz&_^[Zǥ>A0M=&.1d)0A&_.tB ~j:ң2ң*ң"ѣx~sҪj#Ӽ P1
jevf&b &bu-&{#&&xb@`BahJhpSr9Mj*_!bCk*a&+a3vrl`ҿ&`nZ	 Waбp~|r^[؃	s$20&^v^^r'S^pbu0*a SCX+aQ&Z@S
F$ ~C(+aQѼ*a$ < u.@<@
<@ر !P1`1]SO20㱯t`nտavZܻpjЩaQCk ~ бwqȐF^Nr'~#t u^   %  p0ɵad2^VF  _j$@R`ͪ`i1ʐ F``   >v3+QOYs0rՠcvBh [@Ak`R܋6'9Fth h >߯j hh~^5rIm^p  E~u+`FV s׋v F~ r~ttuF0Pfv
!VCҊ,{IuuSIڱ [t
 a ^^ v~ fc !F@B F~P|0v^ KF pNQFFV~ 
tH 1 FFVJc. ĻJ}c  vFW?~oj
POc
^F&? u^v ?_|a	_-	\C
Va	^v`	qNN	F
lav0FcF濉FPjc^&/GFPv4FcF[ P C_P;qC_a
ZpxZ&@0讑# 6$FP~2|FtFr}W^
@җ~	CO _0 r  ċF\4QCt~~ t;ݺ q$Ftq$z up& &WV~ N^@S" #^_NS#"j(#lp$1
.([.$ ,mt(|WVvԋN!"u-#$061 ~(|WÍ~2"#aK_~@u"ݐ7}HBF&:W
;} T><5 5.O%r1!u` (  DCaDT+L2,Z#/aD$?A_BpCFS*C}`D
F/GDHLH<M$UWVv}<pċ~PSF
&GFSS&`-@sP+V~ʋvS^SFߊG<IuR^&^&8t E6^^}۲Q8Ð˙0GF[N7 }1-A] ~s _NFNW@5;u`U0$Z3ɋFPAFC&S_fcfF ~s^ܡ`FP [~`]"fJQpBUȠEbCVVLcGV~^W_&FIT&6!% aFro24_% 1@qar2qqorڑr*2qq>rֽStРPqqIr֠St2qqbrփr= U2q q?r_St#q@q#rBy2qq$rr2&5_% q9rr6#s6ڒsrx]x+11]j_RƑ3x`2
2&]W% xK22&aqq&_1_(_j2i*É@9A2It9a2)I2x08rY_3rl#sol_jD2󢅯	2&'HE23HC21~9H21QHN2m3Р9S2M3@HU2-3H[2
13(!s+1j[gQ iСVm_tW j^2 &l_'_ /Oo϶ŠoI豾걩sJX>#I	mȏ" z6> #j6 h0vj^(_؃ rֻjF4_jţBōBotB>\BICB?@*B#4_,~Ɓ/  Ľjbz [Q$_5Ɵ96Yȉf]fffWLd`
H?K&'f&_ OڂAoQa5$課"D	囪"Ez"CRU"H߽ĊL4z"N؁L"U1pۇjkQS ""ZB[LŬBUgLŐBiLoACFp
$b(AojPh!#WVv1ދ~ &F<t<wbr1F*;]}7qc~i ~t1  F&8tF|t<r2DRVb^vcu	A(|NÐ 6 ~PlPfh#  T0vmF;rFf?*
Ff F*N*ȁ vFܾP@
$nv
u+/$b^F   pW FOupf
f4b&4b4b&>>b t?5@pA]@taj5!S &
cf22P% =p	uc$<C 2c% 0_p	u&!E<% 2x"bc1c}1!uF =  zZ01C +ɉN3c3p%3(Љ(q% 1!u*#''2x$邂*u$&pu|'pf2.% Wp		3u"+!uU'qIR"-"01!
uY6.u*#' /P%}c FO}@$b%b&b 'b(b	)b*b+b
,b-b.b
/b0b1b2byObXFf4_ n l_ '`Zb&gf>f~ t3 f&4_Ft~u}?OA
pAtqAtpA t@qu5_ tABAWubC	@@ EuDhEfh6hWx0vaX>e fCK Lf@LFd9ZujzRP- ZF  vB F¿~2|`Z1~rF  R?uF&`F[
 SarSjxYNcV ZFRvPOF@@Pb*J*MN?zQTUVۃFFP|F؊fٹ
 ߙ-0gh X/Y@ZZR
(SSF܊f Nh\/]1Z !F֊fMt@ t؉Fh Savv}4h 1-e~SQAsu`PPCMhmuFh>h(  A@h߄ ?eFފfP~!FfMKjy\k1Z!ʂ:  pR0F1F2F3F4F5F6F7R8F9FAFBFCFDFEFF~Ƌvoƹ\p؊GFAvދNƿB sxFNG&F;uy& e0o@U;J0!`Q|Pj20*c
-'ik- | NV4G|2 
<A
2_$00&ʅZʅ6 $j)ax
Ӊ@eqdъcv0Ъfϋ]	% c~y0s~1- t*-} t9D0C{Dђ3DҒ~q0R{P{<o}bka;LbjјIF~033k1}~5GKEbј@q 3|
/0wF0wPRqr(p_2!$o$23%6_c茊2]pֱ5]1ЍjLFPVѣj)SE1⊓31D]c4WV3 W4 ^&@RFG| 3V rR& F%WbQvO b~Q⢂~BqW>_  `]]6 6? &=  @qP=_ Ft  _ЮB$b/˻


/CŁ@Qu	2 >
6  &O&T
V?S~ t'j F~ I P t/ u#''jjIt= t}@.au/aul &l 3X6_2tIރ	S5ccj PSЀ5bBm_tV2tC(_}0_R4_3P+1&_91P% Ѐ7Ib_HbaP8c7,a`7qapaAacp7`\\\W_AU1ځ㕿!q7%`a山> u[h hB ehR܆z2콵b赂^r訂쯂蛂W莂쁂tgZM@c踒l
eU n߂T\|ZF&? t5p	(u%&|Ru )u&DPƋV@OpkFF3b^8_fjfh 
; ; 	; ;  j<H!~   ! u ;&&_ IP=>b^ 葿tf`j j 03= H/=
td-
t]-! - ; -  o= M - -  -' N`  r 5ۋ  &9w&EU 6p  VV"Ѐ S6?	Hː  9~ߡ Hb;```^ fqV>~v ; v&@u?{M^R!1;0!vĴ s"&
3Bwpwak 
 Ꮟnp `)ۊZ8
b vV>
ͽ  s,vV m*F^.P+% 
Pc h
}0h  0+N,-F
+F@0oF!vvoЀ	Fq,ZN1wF@Bj `U2FPNQ=4'*Pkq47"VW  p 3_^e) )󰠊Z%q.>Q.#/F 
FZfd-F .859_;F|5U5)F@Pq4]BVv_Q4N#FFAt&FH!GpH3aǐRRu9F88cFPFP3G c̴{tMFAFC PgF8q8AВu
c .f<q2õBqd @3S)*PbP}<~9v*V1HV!Gc7Ɛː2WXƊ*Q ufYU  DߋVn2]{> t ur3NF N &8tGBvNߋًc؉^GF
&Ft^dG̰d}_tp`a
7b뎐V^% = @ʃ@A3t_ߠcߋߊ@lA~/wC"> u~C3Qa&p*;t0burQmr*_ `*0po}@^^}?F
t0vt" c f{v
V7uO@CGB c>?Vu	dHUSuwxx!xS!4U(%zP rV|uF IluG>8_V&dERP3>>XZ,[dtNd@QSpd 	QS]ۆZ3@>P^OduI 33+ 3B; ~
 ~IZ~v~Tn Mudu~ݤ`tZɽˑ}#}f}.>Z }p0 C }wZrq_~& ass~1.% *Q@330 Cp Z}Z 9Fu9Ft9`6Z6Z詁ZZs!n@lO ZКZZ·r-» 1ûPxs  )r ·aS~ t0Qe<Vᤐ,@F0;uVE0 ;vpu_39> ~@ ށ~Z I*HF\&7pZF3A;F|p~
G;|ǋv Yt>  T>J JbFof&G`W`&G1{u`F&M*+ȉNBȿ&E|&}1A7tO1GV#,F_&:t~P}
AFFau1P6uL`} D~ 9t`*;}q ~Ҹu0̐3&8MtËF лNu\PU tك*G;b^|@,Dt3696tVopZ9> 9^
Pt7 31^&9O ~mrw1&q&^ߊF AFtIu'9Nu"^*& 3`Ӿ жB¯|AGv?
 u  " iF+F-   `FO3ϱ`t$)c S^p@FP 6|3ۊF0ۊF O s`OSްL.=P/kFPp١#+ɉFN+ف H&wwfFf G~`V`TqA Ɯ@CB쐂:~38tC_8 un3Aw~^
AFIG
ut:N3~(~P  um0 F;|Ő 3,f3VNV!Fv<%tFu DDF
0N$ PF
0f<7/
7VFA83VRtQ"G;v~N^F&uᗋFYWQx7AC7A1}  +΋8sgvV7ACN&8 uN&= t@ttP$fh  Zq(_fh 		q	0	pZ1
f?6 AIQ0	ܠTX1
,PN Cp	!	q	7j }M#v~WVZ
κ м3?~Bv
&ğ`&0:f;~Nu PGF*aψӡ
 I𐜠,aPZ^p	VPq	KqPEpJ= ~%~h3s7W"&t4cPv"B%`P䡹@CP#GW_ !zJJ "9Fu
'J 3&$"`v' vv.
_*%pZVݕbM P7n,F0}+F- P 9
 (30qF`)gR OQpP3APd4\4F2EP6DP4װ>Pj	0fh  <TjЬH<A9pu	fj6 3K}O 65366BӾ_ P: ] XHR6FKK4q?jP<H6jJP~A紹R?P%QJaL(C =CWVf6 'aL<tX0F E+FF~pFPq?2S
@J0<Sy@J
P6OIb(<DP_QÖ<HX{XS5.+F+`eTWAJW [W@'P跡]"XIEYA$`L$A[S@]9M*=A RvT@J'V`B`(abS*peEedbgb@F;v<PWPB`7Imab&aOa8UdbbS\QhP迠]naLFW9hP;oVpN0']S&GZ4hʋB\tY;}{Ǡ9SDȐcD0Tq3FF~
 p[@\&Fި@u[]AFtFk;v]As{ b}|&tP1};v}v AGF;F}+F-	FP~F&Evo;v~~ d};F谁F}'0~S} t~zV{~{/0|tOC }G\0?
t/*"}F`99F}\~ ;F~!5m~~G"+F\\ ső&L
QDFFJw@JL/wqVw	P"1@PFv9..EP{U12źF
ј,'b|x`9,WFAUUB Vf&Bv avFv	BP`b~.~_G  }t
+F\FHfh q=yјR tYdݶ^֋`TЧQ}9~ݒza+FqMV/+F12gјp9e@VrM0&O+σQk.]+ 2 pP1ॡ9 񠣧tj[要BBQFbDá«|12j]hܷ_ 0v9`^訛mr桠sG  fJbP>JbLbj aWw 
Ht8-t-9t- 	t "f' "Ǳ=	zF~ tfJbF  F
Pj 1 dv
  
A=Z	鱿j rP@HPV`^
;0)o!&wP߳~@1ǥtV@pNW/A a2~	VVM3aF
tF
% ~R!a V6 tDu9P 3 c;@@_؋aG" CD+w+*䁵H12J^9>u		 莐p_P誑pSGQ2Rtk ptu(+Hu!wu@u!tPj	jfh%Q"2PqbPf~
 t

Z:";S zmۋE yUMxVPjpFT DVVvvu6 ɰ]&BN@( F帰Z~܃Fq˔2Ee
*@jGp̨$9`i8̣ O]~}P@@ͱLK1t$U MP Ld̒aK?FFPIF 
y;v;NNNQP谢u_ ֠S= K = ; -@-߄--W
F!  :0 >b Ёp /y;v1A 6;vFPVW @F~FG;~~00/! - D- *{-#- "e= Pk'K-p`@5.s!G@6- ;s!F?atU tP{0
Pà`~9Fu
VViIVF>i9vu@ '!"NPІyNNbF ~9~z;V 9vu&,< uNd빋v)q) 3&  -.p(q)ߎ .x `*6/ 2/VN;pza)u )x2^F;~m&a.q(X4S6`*0~Du6b@(*;|ʡ'@N;v}O;+}y6VsQD~ udFAdp9v|G['ࠎ`{0{`9F| ׉~Pa=^&+^& プFFS ϑh\.΋Vt ;tt Dߋ3nf4Whg
`r۸HCIp7I0JKWV @Oc *a tV@O@1P^P1PfvP+aGnPU1PFP1PNPnI u@I}ј;F~qUoј`{0J0rջN@uOW]L6&U5UU3V'VWvW6*:X\>&` u)>a t^>~c tf^>^ tnm_phhI%phaLCbujh1]hZИ
j(hahZdpeZd0d0peZdh^h
[g^ph[sgph[cgph(g[SddZAddlaydΐlaizfl0aYg[
[AhIgp^9gp^)g(p^kH4LpJM^_Ā	= Ht.- t'tF-4tcp#Ht- t4!%/Q#Hjh ܋ߨt	tIPdzz| Ud}*䊇 A	u*HPWv@PV }tG& O*1P$R1P$RbSI$R$R2TP7hzu fj j3PV)WVh`!V3j h6	ydQD΀xHtHt#>h !~Pҏ  { 耑t^ X	
TF(ЀHtHtHHt$"eĠaQ&&G<jhz	G+Pr}
AG>!dj@X1 _^A׉GPupv&ƀ ~Rrj0I6 fP13p>~x Fp~| ̰rs}av ]@j	&8 t9GPu O  > ^q9 uarf   ^f~ t  s|֊Fþэ	KSb-	 d	1	b^ R	4!ċ^3&~/t&  v&8 uЬE*C;^|SN!Fp\00ˡb08^? tvN~ @"va(׃~ up*bDFG&9 uoԉ~ׂ0OP~AF=/5 X=! 9-
 -"" -Lq ;uP< tIf tst[wV-
tL=xJ-`GC- 	tI- - }PDy- tN!%Ij*o0pC
C~D@Fk	Oa0vP0-t" uNj  =Qː Ϩr= u
ב>?þD@N3~*^
ފ&8u	F;|? bNtߣ	PpI
 9P  7`
cNq
_$ *@*8fu_b?؋pqtP34[&GF |F FP
t- f3fv f h/ 7# j htpT[dc
? ѐ3`؀T[qF&*Ht&= t	_@ &_ q  D
4  t^u	 h<h8
h Hu_tApO	 &
h 
P :Q1pO	 
@
@ Dt}5p	@Q&	f&_"b1b"bqN"  Q4[F d8
S#d`TPU%t.Fo4[^/T@E0t@w&wuw,Ax3Fx
y!%4> 
0}c> _j:Aj #
P"
P|fsVSb
bW4[㹿 T[tp_ t&&
Q ;&
0}`vIVb
E<b aJ
 8Q1	|`j V
MLBIPO
otPPS!g2[%  PPR
/
+$*",, -^e-., -t-Tp",x,-ʒ13[.V, F -Q3",4,-1vH*=	F0w- 9t7-
Q= Mt%
- Ktn-wMt@P0=IXP= N.:Vlz{&+,2-0@@"&2[`A@z@1A B @@z@@Ր3,240FF0u}/ h-_h 0F 0qӒS4HW 蛑I=0F.FF 덐q7t
g$R)2[_wPVfhP'h w0}0!@t&L 
@! aVV#WWaVV#WWaVV#WWaVVpAWWaVzVAWz
@_2[x
ˈ w
rH,0}ȰG8<#w-+t0;t#'xKt
- tuF@ 4 A3[S3+-Ɩ,
hHtH6ڲAIpuIÐ_3PfPU =	
ihq08 +b9 GB: :u Q; G=r  P0HtQ rFE 4J"JE 45G`;KKTm
h rڀ܁0Du Uy z;t&3[O!
3R~kS3/Ė,
(132@,s1ѸiizjkO
fh!U ="
1t
2W
݀Tym+Ö,Jy- ",ѻ@
  0S0q*",y@3@˕",X`5@ ",77@@","hj",#7U"G+U")荷	"	[t&HH>#qP	@Հ
@u2OP,P<8t59y9]|:hԟ;trV8=6=/@>
>64?(Tbpҫt@1ыACҍꁭEҏ1܁E΁FAG[  &[鯰 uQ딁^ҭ@ 놁ҭu{ttm[ 2쟁 1PQSJ&[C AC10FB쁢w
軐}Sf[f4_RTWfhr  TqQUӑ۠_f4_f[_&5_BР
@ [2W $@&+ QРKW6`8U8u@  s% = $ u
@PHuu-4um$uDuȿu	(0_~*( 0Nroh\",ߒ}vQVhS`WV
[tHtHtHt$Ht-L++!!!
',jL RyiP*۞W`PE\5@3PՊapP
>dS`5Pޔ'PP߀T$f+fFF F\^F>PFF$(D>== 0o ߄ -B -tRA   -q9 -*t:-B ߐ=pd+- nvs Ps-qrPst}rx뮄Ht/Ht:H ױ36 1(EREF@13 A"SD AFt)"%P{$(V萀!%{%t&h^\q78 "F@*HF>~4 fT fF^PvfvvFPvrFNu63F1΃~%v^\ :uF

G;F ґ&@8~ t
&X&8XP8P~^&0@UH0Q@QH t&P`hɯÃPQ`Qh@&"Ht)3#׃"18WVS&(PT= 
&
p0 3vQ~U.a[&Tp)$''T(T(T(\c(> !9Fh2U\"S
[.a&301h; z,-9t- 	t B%А
`g`%hU
 p (P0fjj 0UZ%"lgu.S1j1u$"h 薐1Ɛ>\ tufhw  '*F+*+-sQ	T--5.>_[ tp Vh>h> zhDb"
3\l\& [h8F |k%"70n" >[ u/u>>0/`t(p6[ z-- 軁 z;.1,$?-te3n\a8y89><5u	>[s@=jB>|>t5 2~-E+@.gCt'zXE.>(?^6's
UT)PR^ $XE巚>$(?64"0A",tp/Lfh=Q0!Mɀ!%" A!Hi1BjB["h92UC$UVxjh\_j\l\nZn\.aP`1[ S l_ 4jmYa%ZbZb[_\aY5Yv`%ZaZLb[Cb[\aYYN^DZ^b[e%gcY*c%ZZgZ"b[i<\0ؘ Dt,-
t%-.t,-	 tE-
tYtr- t}/rC D`t[:~ p#t=2p}5p  oq'QBV/at`wu#q&aȢ/atquu
*&Рv.acww0vxx@cww0vxx cww 0vx@0@ut`;>_}{ rn\߄hжs	v"tX16*1HtHt`q'Q{(@ɉЄuTu^AFV^tFߠ&Ouj/k0Olomno p5|qrq>> uh h[h;hҗ,ajp
et0a "@tsP| 3҉6 5`@; }F>
r݋F 7h9ҒiB蛻wRcaPU<B6f
~`bv3ɉNv~FV
tut9v~O9|܉~*@fp\0^3<p 
GF&Fp/	&Ѩu^*F؊F% FnvBĉFVy	?NJ0;33V~"pPp9tG;|	FCċFBF Ъы3$up G􏭢4t%	6%l\@`Df|\fffRڡ  ľLwD@!|\n
!n
ľE tP:D*(
}pDb!p ^3~
ǐ~
tF^&Fu	6Tz0$FpƖڍEP n{G&r\16aP
}=!0=Q	-tX- - 9pV&= M -0t!ё|א-`}s co= Y.޽,<J/ǿZoݏޠ|\1|\+11~\о- 2&}\% R  ԡ 3aŐj S jhP
5&ѷۣ Cܔ0Aоa uj{qĿ3~
``-'Gc ؎0¾]qsp\c]f|\]$@f
  &v
f
nvK
@4_W} @Vmg!T
gk!d`{t"l`}"\
|`fhPPP
h ޲$rNx
>au
6P  O hEF<tFp
h+H6F vD-FC|ߊF4U@ЫGV%VF$:Fv
u(P$
F&!N
뽐u{$k\[9Vߺá\\qH`eUpS`;f L `6 pƕJdB6LkdB!WĊⱿpEdUB!	 "pUdBm! 'pSBC$,kpD+	B.,r-D+
BMà"}D+UBρ10赿]D+Bd30U<D+
Bf5I,a(D+#)f5+SBL1^,Bͤ}L"ֱ,-
Bح
- Kt ё/"ڗְy>D}P4NnĖĤĲ&6Pſf|Œ ,2_\EF EF EF EF0 EF@ ~- 2&0띐K#LF'_ (0L zK#LdK#L@T1Pĝ#LD1P-  3 ?+-XR]SIRSIRS IRS@jh21pdY w,aCaDDBQLQGb&_IRsf&_f Nl_Q@x@]@AtA QHCcH wl_t&X@cvXSeepfpQemefgefSeexfxTgjfgefgt&@c
c@&__b@t&fhkl誸Q~Сxcb2mf@w}rr>^Nfh2 h\pr
Vz0v Jrryf PNtfhPFP #$h"+Qwy zrrn0v rr60vQF0v*2 ()h';ް}
v0vuU̲}}ը}0v-,薲}}oh"1ã`t}
1 &Cc}Qe`t 3_&.rqd&f@@ut ы[;>О@@rhʿhFх \Z& *䣿\Pe u$0  1 j hthЅ3  t~@ 6&` >.B7  `6 @j 6\zu.&&.׿j`T&6> AF@ FZ\a ; Dt,-
t%-.t,-	 tE-
tY- Ht- t/> C D 瀒:> ~xt}T  craVfИvfhI
 F|u h  ю؋F&?:tF&<:uFF
*0N&$Э!
u⡓P@F ~ uF	 F
 _ 

Q<  v] 袃j^P}@ѫRP萩U
~R~ tghֳ vᒃ~ tD==u5 *`P ^3 FSPPр 
 F9Fr ѷF`-
 ؋ v v sd ƨu0= waZ̲̐̋~P;c0zŃ~ tFa2Ȧ  R Fʨ {:ʩ . "ʫ ʬ 
ʭD0
~dzt q`pKdp3^`R:Vy.tCu^aGCuK  K./'I Nr{~u@8 W  cܦ I ۣ8𗾞AFVF^=uFNb߈'ԠpÐWV*a$ < urX@@<@u`0XY֎hrb hhb贽Bwt166 Aհi Suϕ,4A-6U1F0i@A9@4䣈\oFE F9 %"ܦB!b!raXY2F c67 F*Ht
p4uP@4v jߔ:t@uf4`;F~!0	p:rN@uOh>h4&;WV3 WP
Gpor     w : MHzKB|  SIMPLO  MOTOROLA  HP  1.0C| drivelock	 Computer Setup  <F1=Help> File  System Information  Display ssiSave to floppyDconfigur2
 diskette Restore fromH'defaults  IgnBhanges and exoit E s withouavingT Securit0Administ or password P
e a!"Power-Onw"'#pR%`"DevGice $!'#d<(BeD'#$2+D1	L	v"s#,martCard_/p0BIOSv" s?upport#0s Embedded
$!&5()	#e]6etac p s To?ols Ba:Calib%< {thq(lect5b; HDD
lwf-T opA
s Activ@= >O?;Stactu,
d> sBAdvance:"Luag1=; l5FDem @"Q
G of gray5field Boo?#bJ$(K)MPre}sy key:ue F10=F, ESC=
CEl RQ #QRAccepQ=Y;es#UNo !RW, A0Po=rQP=M  VeR  Us=arrowQPp=o highlp[9he appropri~@menu i1pO<ENTER> begin!=?.Yfollow!Z \`I?: -> P"SPACE = Nex:@=-AdBACKdOvioDVe	TABdcJ	SHIFT+hgi	`Q dTVh RdcRm(< EZr Th{isCcannJb<d An ]e1q oc !r5#whr .qde 0x01 pqeqn^;]ent=qp	E}CQwrequit ua
; _d	!baZmu?rmCovEre@Lk/MEUzip
 #Qs] 
#lq!sDtu2KpBipcp
le!>suTssfulManu<1:#r  N~}dRProP"tsyp0speEވteppeCac=ize (L1/L2)G:~0 ROM R0(ysR
famidboa0gBs=e\l nu05PVideo' KeyӒPrpa
verBD|\
d$@=;1L;2;)3;4LH0Ck__lCefr@
r[/{"9aeo;wnhip(h(PdЏ皷g3?П젿7X ϤO߻X0d;FdaDUBSN)h$ #1$J2J3IēMEJCJV@KKK4ӆXTVJĿ:D@;ֿ;/:S;tFWarn : q`\`lIl0 $oP\ ]3gPxsqI=6TPre@a a/@,`le!}inPt0w@!ab!"	 A: . +waqwt0t>a 
@@!&9r~BInv0<5}PiF:eAyou2T{waxto  Ot?-  ai_qI   > q? r?1 (QuickЏr?2 (a
rehens@	3 (S.M.A.R.T.) Esti 
5ex!Cim|P#): 30FP? _`\gO.&h#0%ep5pp1>y ho0@up">"q:Qo'tT	=fy-QUnkn& :ilbWrServ:Re1azdo r2?R!;rib:,dvuex1  @b 3A.   Ol0`ew$V`fy n!@CEn>Off OPV @V PE2iWroP62x w\!S}Pzd" Ad H 62Ez^"x?#_+c&p als0D_x91SmartCБ05] 2 if]2gly(i :P1SO| _loss ItD`Yhou Qx?n`8!_!}of aago 5& Nevxsq;DDoishPed?&M ?power-	'@DOL|IBlank IP> P6! J`PӒ]m08 
tvG S2$A6JvPs( c-	z`PGOn]
0 0s. F?T9 ;_`&U BndP sunu#.0bz@nA;t4"aPfrar\Para0T\SDPo&Slo1%zl!net 1PJMiPqFn+F2>` :0t@CD-~tYdb v(HfHf3*f4btR ,pUPjQ=> ] abouphVf uVBqI<UV botDUSERLMASTr&Uc1tXIn
pPanP`8Ycq&Xr`5&Lk_eep ia#3ocphys9i`8sep]X~  !r. I	bAr;Cqgx,r0n be  M-un ztA6q0p fo FC0me,Pq&70
pFibtyo. IfrdoT8Wo,7<ESC!L. 4E8*o *typC"1'fo'L W {F10`"rmpj*`@9؆HR8QEnglDIadba2.1 OrX:ayXn
u (ѧ0ObR) USBvcBf&SuuZ`nFirhi@!FXth@ifΠSixbAh )EὰN@h
Num J[ad Swapa/Ctrl!Ls K8DLAOU.Sp ba`
pG@Adlegac{Chfplpro]rFIn@\i V`Qo @m NTSCiAmL-J-M]-1tLRBidpbRal EPP ECP1:size 32 MB 643Y  QQoPn Alwayn whiL`4	ACcSߝ2FAgG vagpAO`Fp{ ADD )ǜS`qtomE Wr`uf!23Tok?R!lXXl bfo@cg@chUnique IdPif`{#jBe@:  tuFoޏ S(CY/ܐCb|pONPs1j$P>AD*a /AbB> OoxHL`4  OA=L MEU@o/OAR OO/A[py1 : Cr@g% ]C}lef2 0'0p Ue=3 @wS@dX"f#*@' A'o-yisV`~#l  SppE mhnology Auzc7DLsFre 2Fbadapje""PXE RPL Ex>"Popup01(0 10  293949596979LF{1285 159"0=30=Bpq ouchpaPPr%SPJNonf<F1=Hilfe> `iinRㇰBSzei@PufV`pweic  KKgu'aEGV KHwieXˀ]n\GvIJein"KunEOMv-kzGJXcOi?gnoriepXYdPXSnFt nehpUISIUXYSet8ZSFheitsfunkCAdPDist|0cen%nt^_ QTzn1lt-Ke_b-a GerteP{T]oed-ID0ާhdfobkgf0tCѥbr@|`Qsttz`O fr gnBIOSbon@dAgT0|']td]vorrV`OvOgEoNOzurck`zEEx^0AkkukTxK~t!Hsgewhlt} DD-_Selbs0sȜC}tivTM  3^}!ZpEsݐsGІ}rw]s~Spra F!Q^ne_SEgran Feldsqrt-#ˌde火j|ipine^@liebT, pD@pfaha;=A5, ESC=Abb`hġEW}kzaeTJaqNNI, JJ=Meh/;AG VepUzpOMarkׂ@s7!Men dPfeiltA !Ud`cg'abeRmu1kG1#P|PUP E.folOP"nA eGTA:p-> 6r Leua = Nchac$Oԭ<-R|chrit3t-"ЯVoS|Tabul_tֲsR Ho"llӲ+ϵcge`T݁;= S8VEscֲSSl0ji r kanuV~t 3we`{ei"~ap^1Ppr1Hgetrn.dc6 0A lpSPUfiUt  k1ƣFp/źQW@1sel^omv Korgape	rDMlF}"DeskЁ-hsNymu7`|ˠasQ2bzw.¥Mobi`-g tz.~apw`Eti@rUu2~1$JlgrF ab>chlos hKo2-A4ll.z/typzrb4QwwiguISsa2xCQ-`0F-Gre (L1/L2p9Ekapazi{t`OM-R>ysFami %"sQp P`_umms2 ?Grafik sb@r-Con1iY?VBBJr1 m2 3 4;#-Oc<link  qqs Q>si|B_+	(F0m|`OT ?
A|Y 7ojzOg/ak UrD°IV:L"D P
stPoPn bisLnрbEpK#]1-/WJ"*HleObh$V aei0pvL`L@H k7 A:+nfۗ0l/Vge]UKB//K0
.oglEu/*D+L Lo,*8  8:4{EMwirk¥PGGڽR?ďZcISe, daJE|TieOA EFGpOEYJ  T / 1 (n{
P2 (Umfa*!d
G.wfh"daus(Min.): #30eAdT7t .0% ZC0PߤPwu`{؏m Ho Ёp4P\ZuobrзB: U¨V$^Unbeqs]x.41^rvo-MbL41UZ5"]puhaf1Attribu$I!DaȔ@mpaou! .M.A.R.T.j[ .o Apsr!r Neu?pVqXys!' Deap s` Jap@e$urSZ2qHt FalHrgebAreqr R7r(bHĨQ6Ӟ dminP6oxr
sy Dur`spjBV  qal¥Ĩ'Ho$C8's.HldQiQfQːSmCBfqҤυ`, sof6~ s wa.Ps Zu ܆B`*@W Ben͟lust.  (b# s@EAnPPlxlsvice!@a@
s , ñPQfr0 hPq`gat 
 @t#fa . Eeq-è@bc!(& k9 QuickLockSuFnd frreBNMϓٌ`sQ$bi&pt  NQAchutzƉfr҉QAUӟq.Tӎbq@&f, l3mehr0r׷v@  q"<"qAQ|  Inf0wot-|PareN1Draht 0Nq2e "k"tm`CD-¦10WF]st	2I1Ɛ22ǐ23@2`ӮҬ r抅:	nc
3́Am<Arive; G-.ܠĚ☠X@!p&s -Әs mpAx.޸unbraba'r. cAI:v,BNbew2sGs aEfS, xtInp   E⡑0w	#, 2_qֵu`,  (;,zu|ѥnvͱ;z)0- 
u|s ŕra׌Xduentantq !yτ_L|]tL Esc- Xas  DX(Tz֕Wr'';x䑋 F100TAa:}c{f
P[g@gv`8Ĭr{D ̑?rbi]QYMu7BayW	8f	 V (s
os (b USB&:&2-hSuP+ZipV'
 102030U405060708090Num-Funsons-t2l`n/Strgt_]% tEng3li @RSAf-Ze 'gerTradiR1!Grafik-ContrJfIi) Primf#A ?Video-SA׻)nBidireal GrLFs{ g  L@j⁖m l@3tzbieb 2gYss uEg~parp3t]o~cal@=A-x6
,(oP)/0`1hP22EtN@ko5678tX_:3ToR 7=>?:@>< UO?Et?G_H1ulPs I@ti@aщIPtkupfWPQ#  /SOToU(VaOX KalibioW[RM{k6Z6Z$?`RNhPhn<_ЙDualQc Yqbg/]K^ofk oabooe8fns /iKjorwomj?N& pjz{tLj}{xriff- O?pVZoK^?bL'&vobiq" |)Z{^o{xR 
)Zo3@OF|[=r 1 : /9.,`R% ]Cab2/EntlѨ اi /뫘3q`< /m!*۫ v jOeOOVOProz@or-x@' +utomMo Legacy-f0Բ#F<p<Kadap >!fBootm#z MExpQ+--Popup ( .) Wdau'M_F12 (Z
 Be0!P@RCompropstnPD <F1=Hjlp>  F1_oplsysVis's=ne Gti-t ؑ'konf@rM *G'fraۑ} 5 `ܐrxuxz gnor'n0. ofsluO1'f ut'/tfnePkphed Administoܐ!sko0 KL aA foB̈'MECdp+eje^-i!pаjSm C-yls f >& BIOSi A@+r7'jid0ls!!fa0^ksPL	l Ba
*#Zd^7valgb0HDD-selv02ftr " S Avanc Sprog VlsImonnedt,t fel0fO 

شTryk p= tasDt=a, ESC=An'nulR$F#$a$God Dd&={Ja$Nej %, A"=M`*V%B Brug p0"!@pe!  relepmenup,tT"<E?NTER> D#qekځ et.1-f"@D.uڡ+@
: -> e% MELLEMRUM = cN)7<-$8TILBAGE 9 &rL9ʎTAB&9RKIFT+>;>CR= Accex̎ %aBT%x
 sfej	l@k@Q`s0od"G|'
en. FGR012IAQHno 45" +plax
AIkrv@'vek 
gGi dF۽s fly`s䐪#n0M/MEU
%K b/ uvetbrCud0fOIoJK2:FVvpmfpWducPXctyp4PGah #igHaPtr/c cache (L1/L2ъdhukoP  ROM-familie	k#Gf
`)i00V o)i1s3"r-contro%DR-Kbaskj)ndp퐆0yjq2qM3TrM4jjHl&etnv)nxon@X5yhnhj}xapt-3ta
ej :E(#at)pgr/3_uv oxoz\|}hn#Epdvar :c DbNq! s->0  alt0<Ғ9hold  &o``" / 5Sb-gٲSdqd#", r BHqkbesk!T&Rr XA: DG5ȴWBHf qZYBW܈6OUgyldigAtM  <ngivfuD",0vAi0G5f|?# ih?pJ Tppq(Hurc)pOmfQ 5)slB < (`): 304L  .A0% f3r`udQ_Wrం3 А8X(K: KHr4"U' GSGervkLsPribut: ID 9TLYݣm3S.M.A.R.T.Pe-Xy. "vNy: BeOft nDea Fral )La "#XSs #.%׆OO D#BDN9Q 9B#) dqg;sSrp+rZ  hvSN  t	BH
%
#metabrata. Du bZu U񁨠TflA Q0`$8@viceh A P4D 00#^
 {U4  QuickLRpRpaugLslmvS@4Qbt W.  .. HuR x$8m` ;@g,Gdi0hLXges. KO83a{l p#?frard)!"dl#`P=k]napp+Cd-rom-`U@c3ޔTdH`A 1,2H3bH4gHoJ8:-euѩPб!h,rr D> Zb05BRUGER-!
 HOVEDADGANGSKODEN,R_ U% al@gQp <ndP4b N* d,!
opbe_&03 0)* H?*-Tat ld+F% 3 pd&u%W`ebᴁXnA. UBHa&9,S2tryQH N Dà[s&S񰒢 or M'&' 9e;r(BF10.FSq$c;#m!S3ܐ]DfsdL]1D>k Os{rpflgP"iU%nMulti_Bay (})RSR) USB-?floppyECVcsBVQVsupeOVzipBFQn.edjЬF!iF`hjSyT Oc Np!T^t_Num -Ģüi0`gp F?n/CtrlC1jOEpl (a xi`sk) mBegeen`|Ut!Yua1PnPemhme^i PrimAlVideo Ou?t Paraps` Tp!j0MStrpMBv1mhuko !! Bl8Sd t `nr compuPLkp|ApekP}m(uS2- Udqp12tstyQ@GptiEcaEeP=tf&ahSt#opeo{SbT{Ethл}`o )}ToP RQ<((;4,Ent0Wgt id-nu7} C$iS0M/O*A^o,KalibQ ond^ _jp$`a,# `ESUϞߛX_kOrSb _
ﮟ/k߷ϬTion _ƥ?_ߴ߾Hpags+o̯k_OV#Tvi/ mobpuRw !| S(MEU): kOo؇/ AVP,>lΟ6oC[0in 1 : oOpla& .c0% ]pONnemt52AfU=3Geno`S< * YPL o/ۿwٿProcessor#? AutomY6P>b01s  Legacy-fGree`om=j%P
Hurtiartpopup@Jsink>2N(sek.eAJH0H25-Af\@Eb gge+ PPfp> pj0 Konfigu datamas0  <F1=Hjelp>hil4in`jonmP.W om 9sR Lag0i´ktPL)HePfraVJO0w@a`%Odis/! &AJ3Jk CzP-`zg avsluA&6B,?l%%*&;sprogra b=t Ad0@3ratorpaq0{ia/0{Op4Pv0ALaL3U
yrsu=Йi6sfunk#u85phtifPe%@g	:#A-u0:t02zg=&8n SmC R=o2z>FA BIOS=0iOAIby w'6oF7f6iGЙTilbake
lfab@e00T0L)p rkty Fyt valgBAljP#2zeYtvt L AkQgPQN`Fqus2zOOq/vpe}eSprkp lg @.0Y Dem .0*Z&pdt0el2
4YS :4]5]U1mS9oTrykz t%B1zH =aY, ESC=AvbryЙereofAptpjhJaiNei f&, "%er=Mf"  mkybnepillne ,td<ENTER> hvdu v 'jbt?. BrukQP$pqb:  -> e@Lr MELLOMROM = N L"JeM 0<-xTILBAKE yrig~y
TABy\HIFT+}{~<= GopX)|f{%0gsfueArFІ unqkgZ%p;(no&p W t Mr m kjresvYe!R mЌdʇBP0pX.ba IflyscA x;S@)}Bڇ[am'zbv0	full/Q,. kode 02V 9҆ du It Noblokk-mЙll0ـtyp@h%igr6-gaP4vtbuff`(L1/L2Meng1pp
-P#%edKeoT%Vr@tro!xS,kobMK)%,o1@'i 2ϭ3Oϕ4̰hRk*n *ۼ zyϹIUdiٴ E0"(B8|(Be 8/!ġ! <iOOj`ȏľEk0Ad 0R: Dc sl!r tidl{Jho!lo00%Hgu(A) /h;e-  d, eVuQdd s !kld1#kp=c(nn0
A:s bPL(reg2ȱXViUUgyldig(teSbi34~!EVh\t7vt@%ۂKL?O%@m6F igsnov?,te?+Y )K H~TT L_ 1 (Rp)04sl'  (>1): 30SRgr .v0a%X"f"st4vvЌ% :g Ka(ut8`7TUkjцSeǆ oLes@rBp+rib lo: ID y01
rs, S.M.A.R.T.-vaf@.3 # G.u0N6kreft nAv  PkP 0v`K5?ذvP7ligkt 0Du 4`410dWBIsZaRo ds@sPVr GP7!p"BsQAA5?,3"  6Cu@шd#KLMR1lp[ind`Џ. bkupdK  m@v5?x>Xvice.B.r,.UluFe?-_b_lszlan
k;paus L Am V_XM"R
=" gir beqlObeska [_-BO$Pe.   2rxglAeAdtGϒ6 0o@PeKreSu2b@m@XpPefrard-OParap1llOkaTrdl  `\tpk _KnappVtRSQ_  P CD-x!AU&Rr,% SHot2:te%wh0valgAteDQd0[2 oh;6HIxH  bBRUKERrFHOVED-t2l`D rumu[LqD\2MB@Sd;avpEbe!1 p[ Py bvip@ݣ  g@-a LFHH` ,@ikMPrmfrL ;eE dPA0]n. ss@A]')fl  eڢae#v, hp-a?(m z|aR k'DaLock'sr| F10E}eIbSe:Yf4UvG+rNor]@F40@Ou:rex MultiBaAy0con׌(4)vPUSBEVx\ Zip#6A1 A@
 um Qt>@BFn/CtrlD}eE-l>s(USA)pJekeen)PZF/elA ts0	r0%eq9P>2TpPT0Y;is!ArraEAH#F #`i0 @9 1qL qPm֌2`&^Ag@ssestyyktica6ue3 ve=s茜 (vӌb f Eth9?w1$ϳh2h3Ϲ o1	RB߷dSs*`ni dtifiBT,BU /N Oy imtD libr=Ba00&O<1IPpl 00->o։ oُڤo߉`ksp.O>Opnd zO/O` mob.  P> \\׏\ _3q
]r[ TzBn: Laj9.j0% ]mfull4c2 !E	YMj3E igjen6n_*#B  #=(Pros!u_`Z!U𜐰ƫ# FCnd eRWiRT`i>Fpink]E (seLj`FF1#2-3Q5.PZڞS`epute PpConfiguracimj l Vomp9adora <F1=Ayuda>~@BrchivoOworm:l SHmaP!Gr 1=s>Gu eg\@co flexibt%Acz:\p>A Rta:s/o@AEKC/FKGp[o@ prdfinido0G:Kad@Wx@ Ign < Cambios y s 9P1;LKC ^ gB3P B<PSP~Q e:idadQ:P?seNadmr< W:"CXAYX 1iciooZ]]X1;@Oposi;^s`
aIdc:@h^p; UdNX ~p>Veqs([-i|h Sm0	C/ ok BIOS{mo^o|mg`incor N+c"et0uavEBcp;KCPcfbr Herramipa0C8:ereS} (~`x@z^NaPKPcAutoprueba HDD =!c [Ep0AI R;̒~pJ0p>qJ&wAvanz\ <OdioaOS&?ԉDem2?WnrQampvco K gr )]jo)8a}O LOprimoquitecp;nin0A5=H, ESC=CancelTX"=Acsep0?=SӜqN0^"Q, C9o2=M
 < U3j2bm60Bchthaaz@al0  lempo apro[pil PVЁQ<INTRO> nz [zrf.ѐn.6s:|PPKĢntq :Esp:o o -> = PrxR+WRetro7ces<-k:a!1i@Z8TABSS0Ma/ys+Cr p60dGS88FSErrP2f}o c0z廨 /p0V~Snr3jo u Ds:qz>W}. Cd41;01hay n`un!DAub4gW1аiPCAãab!)1Rp2~3PcacoȲ| iB-ebook/MEUWI}7N#?Mmat:?_2p̄I}pple;~xitosae Fa|A?`@5ntil Tiа#ZVpc*clG\u>(_Tama5mr@gh (LO1/L27/iyvis;ROM pmila@QdPczrc@N+vriٙl Ivf0^V`%>rXl<R@2ɥAF쉇1z2z3z4<anij]e~ o/F izҖN ? rKEtiqquP1;urspPI
ec(l
(㗣a7O
fG ?_qԿ}3 _WO  
!z_ ʀ$!'()?, (Z@e0sn`Ah(A`u BFIAdPten:ndauir  1[eK3iI. Pnre [sI$A=/E, in@瀴xPsI1scriB2cuK cA:W|I3DUu=`x0@0ԱP4!klITg=3`1
tega73[X<39aAPKvl LILusa	nP3I4;>UUH
=HvareBΠScxo(a) -6ea`qHz
Qa?gn uǺR$S itVl` ir0V2g2YZP1 (Rpz c)^2 (C_3 (S.M.A.R.T.) ClcutiMeejb{(Q~s): 30]t`go .60%֦^b|֦^ѣt0
tipal^irum_jkb: Bpu QcqanFal 6zqX<nServofq @pAapoyaTsatri=b: ID
caІx|a\ws ai.|sea(}nuevif~~DApagqEn
dIS4BѢ}EeЖvoAcrim~0 "a L×d}0CadQ01ݰepŁ2ãe}iAinhabpPCTϋ, tn6@TW216Ai@B{#0oذ4T}s `>SmartC 3, aKsao,w  ģltQ A ÃF10 q@Dciʲ`PQ!<f 8aSprPsin Sْf0B2lha5 olpJ(dQv@vi`.o1
ۤ  @pS2? Opon@\asR%0  QuickLockQ3Suspe=n Blo-V0Zrat`y"TSΔŏi pk 3qmejVƀ\yϑ. Pp
r2<t,aApo5d6u`izN1{R!`yre Pu4Ea`xu :rojou1ltuLRed0alm#B!oqQI2!<GCD-R'LEu<Q3>udRa /԰0հ)PֻʇPuk:};Us2io: F u3FO  medi7qDrive@D,𕤠USUARIOSPRINCIPAL6SPu `5F~&o@=1pp`Ql. AnPF y gu @Th;lugVWR: e jAmpp\  . Ele!  4, soAo8 6b5O 1 '0H+}Cfi@r&!Jcde2ǹi i@SOponsr
.я0pACSt, v@T ESC. 8  5S<`a alab'&' F10{`a&s:\fk8fi`ȻG֝igEsp?aol O l#MuBaOPE /@/ʰ(&)?_ (r4+)CUSB Σ3Ӂ?&Su p8kugZipme |aK Terc"AC20-!-Px0-wSpМo O@BvJNoJDPJP5cl #o Num0 vǶ Cs Fn/0TõIngls (EE.UUPbp8posi}ᵑmH0ipSėe *.}2u1cl 2a"$c#5pZeo Mo po2a  BidikTa9m!<mem 6 Ñi3EsAcfuP0:!# cuKEBB1CA{A0vNPFb/ook 2Ѓeg!mpoAsi`ʕ-s"o`%P BOo,6B (s )FH 4IEth04et, AFHELӏMNpONQ!HTokhRingoOTQWSJ!1Z[2\_\[3 It~"dExcluss%^AZPDc@fC'bᾅmdC6iemcNcPgcohioy ("ckh1lu`y?gnpjkormns3Bb
d.qx_st {_mn?^o_z 8O}u?S߀uu yϋ|ooOnMEU h@Uо _ߖ??rn[ 1 :rgb?.d% ]o 4@Qd2Эc&u(z=CleteU35D[rl*`"  a~?upNha N"Cxq1 Autom c&rblb?'@?p&7L`0cy Lge Arran'зpR3 ͈74~D1;"gaaEx0>("1-Sǰ F12_-u.Ap`/Ambos TouchP0 Pܡ"N0Zu&B0a  3C  <F1=Ajuda> Ayr &Info@
ۇ1so` od<Pi3ԑ6 m (	ɒ?HRqrt qvw`Яpadrpa<cE< Ignl 4Se sair6	s0s m$.na"npaBҿπ^ .P^ Dr &$' _bP7_d|%e Sp5tdq /b2BIOS	/84aC?embuti+pDpfb(P
Fem0asD)zg1 4i 30S`݄ .le>`Op	T b6CHDD A!r 
 Statu2`2aaMu@'#
e Avq?S5Qio<AnACiCcamp(cinzpA+w3)lizow 05ess>e qPp ($*tinu)=GNSC=Cancel)!&Ace&"&im'N!'!, QU$ou$=Mai U =iz^s$q`yd0 o il? aprop`;#0u1#<ENTER> 4%merڪැo.L_-gu r ul4:P ->+'PAO; =PxilK{<-8BACK@9CE9a1K8.dTAB9o3=SHIFT+c>CS%===bb(jdSC@3)Er`*
na0obPVFQT. Cdig\
o 0UNH#hH#uoP1/J MsP=i2HCAc AHevI nsf@=do notebook/A3%Ge0)0meIK5L2F|Rrm xib elNU  Tip`0P"V0`cT 0a<c Tahrcache (L1/L2ˆea@1m ROM visFaml
`hha`cxBǾsric`&jo vdeVerm%ro ́$k=R1Aa qsp5 L ?uUvp\wFv3x(v	4zlg|
@l~ste`sira(rEtieBpl鋃0ebH`oqD(%P)ߋ 
LΓp\Γ zoΓp|ϙΓ} /Ϣ /Ϥ/sUvekUvsecundahAdvertn0: Ga63 /%ea$=*ۢNc7Qנֵ/,si ,um 5 gravv@ RunbA:tFIUd 3Aw: n`foiP $ı~30XHqoRXOǿa'tegSoaS8MvlDIuǿM +9T0PXtezR`a/eja #͌S?oo΄ iю &1 (Rpxf2 (AZngqY3 (S.M.A.R.T.@!Lx : p(.): 30taA0
.VD0%ct}b@Ssucedp/%1c1`hos9tt"romXrF: I@ss+ .kFa	lRhPag er0mec`(	FsraUـtrIiP2lf1 D98LFHexaa@6s !.#=ig~ov,nif
rU"@a"l0L  ) q*pQ3b4i rr1igp(N1cisgP$ 4 r% pAdpkXoOa2modtQsPR6a	tAtambQS T60Z}p(pU#emCarQd1,. XCviSY0-Ac4sfbr fus` pform. hbɠ@3QZPX C 93UaBlios. IAd`v@NrO`"%? O# F<+$}:QuickLockU Suspenso BloTrp1Fou͇'SXCGauP bł& 
 ^ 	 jo.`Abss impuSddk. Exig&H1APR018erme@8qVl0EReH^Vot0rY=I
1a_CD-i?Gk<+`r1$?DTE2ETE3GTEG4 P/,mase: usuAP?: Vocɰua um7d\1	EutiQ1n priveq(3 ƶ3 t4USURIOQ_T  MESTRE 5a_QiOD/A"e@apaz$  . An/
VpP$de-`  ba9iAsUB@p2\`$m. Nv0PpFTS
 L,\po4j1sb)KODX B>f 

5L.%oQ  Lem?bre-seQ	vQ`aC"  Nsab0QQt
Q,ssionep2* ESC. $Ʌ'Xs
QAl+av'Q'*t<tF10.@e )zr:MKj/QeQ8ugus O 4 *A: Multiba!y/IX"B!(,)NUSBERcE(zipPrimeirrrc2QP$S OPvN`{c0`A s(!10SA*s Fn/Ctrl8CIngls /(E.UVM
ipsi!NQa"
S4h`נ oa* "deolS(V`M,aC"FTMoA:PicQ{p9TazZhBmem#tOPCŐ= fu`{Q  qurQBoCA@4ŋ2Gergt Anerg@!ǋɮLt `o porEEtpne	t1Ow䯼ʽ3Token Ringo įB=0?řǔIdQ p0'O Bap TSta'tusV 6Sc6\AC@1܁\PNgemSPdFlkCor Dupted޿? ?s&/N؟Ha`ܣAX ޟٟAl^?ꀿ"32"eU _?O GDPx
 [ Et[ 1:rregrrQ.#% ]le-2: #!.f3: Re
 g*#V #ڿa?ޝc, Nme@_ 6JaxRaCflexve(cc	H8+Adap>RrCPopup ExtSeg0|]'F126( _B/s Var\1%ƛa NPTu?TietokPp tuk? <F1=Ohje>>dos!JrjKelmt@t Nyt j~~ATallenplevykkeeh D$Dk ?onpoDPy0aDtVGERHVGo?eGBnKs'I Oh muu>? -jpDopLbOw?S!DttWND؏N?RNpou pB>TurvDisuYAnWvojan [as}aMriB~?Y Kynny0/YVZk\ L%a|tWeZl_X tu\usnuBa.t_ZcCFw-YGdft lykpiYiti-BwIOSWgukiVdńi-?pGetUsuYAX/obaVds4ouYo?i?eGtehd Z?TyߔkalunAkrv@oi  UKv [irav KiMvytP0jxnOHBtvy?vq N {*xVABLis?Kieli=PxkBe~ harmaWrki0]Q^P \?^?_xn`xnJatkin@QjotP npp9=, ESC=Per S≿=Hyvksy?=KyllӏEi ьO, JokuRU=pJٌa@nuoli&cmi "xk AYh v@Qsis?sbUQ <ENTER> mrdtes.\B?n y1s seuraav : ->Pi VLINPPIN =	Ps  <-rASKELPALAUmTREd EinU?<PXARKA[уpHVAIHTO+''T<ҡ9= dR_pXwvirh4Akkua exo0vda.w%: R@Idi 01@ka0/Mx4ஙaP~rtpV p m`^ytke찖0kotaasi@1?.tlaksQWVsVkanptYlaajv@Dus@ikkP{skeyty[i @DenѲi@(`w2n0j}BɾorloрmAWjT(ViPpQb? tyypppwn`O#pall~AXVlimui (L1/L2p9M˰v ?  ROM-P@0]|ˑeotepercEm ?jжsip>sarYcrB`{N$stohja2K_ՠ[usPnkohL·1:\·23O4KahvPnv{)V}NOѺ?/YoiCkeрt`lὫ>o$(joa)w٬ sݬ߬ o_1֬JAxkrAso`xs:_ TmUayDlpJ{atP~nhB. J;t Gluo ,prtus-  Dn,r? IirjrqAQon
P3ẠYA: LS
`
	huY3 
;>H	X  pa&A
hC'KH2koᴂi0r`qJMnA?z;NCOA PQOT   OR?xp 1 (Nɰ#2@̠$3 9.M.A.R.{T.p9Arviq$ (min): 30xu^s7 .0%C`r#oscpwIsys{ity*-$W.V#320unt@0KE
4Serv?omoottP
4LukuUtuA{0kPntotribQti23 pP0P@pQpa v&:e`K:e n .?!Y UuaYVd! 0XA PBz!zCGDcE 6@pYRAA Mxl@&Ca oBJ-S?(Aeon`Qokk aadan ZYXYn$(eD5mysP~ r>VUD@3WOme>W,s е ŀϑoai16ETtPU@U5eotnP~id].! un1nAvH[y0* Šve0vapahtum0@OP	id-aaaHinR)lŰ}n QuickLock ̙\ hlu P`%r1L2 ]`Wt"^Q{,0ra! '-聘QT $tta.
sed1`nRt,@!x1811_. QgJuuQ &TSp`Infr/apunRh0Lan1g3Tto2gin`  CD-- -)l:mD<B V) 1׍234RtPRFj?Aiot\e)n D6ecp()4r) -6Oll{  {ek KYTTJNe PSSAN'AN,p~ wVH9.4aɛ |[`xsily0mvtur`Rlsǲri`G?ǼB	t0J{5|62[-e[,Ap$㸔CLLAQx1lq7G[рa 
zbXW5O0"	,pe_ erP\`3`3o{c$"#r,qpMESC-np-{&B;n}4@pM'v'QxCs en F10ضKiDaa: Up mU v /@6Yb_+m1iFwxyspMultiBay+W9 (n$$R) USBd )!ZipEns'imm T0 KolpeljPHVi@iPHK"`Heit 7dek` YKym iaNump`GrVaiИ Fn/CtrlԶm!!p1pEngo 0(USMA'Us0Jspinlr@°"BSd`l-dnY ejaqa Sihaa8nsi1ҠsV@iolht P'kios!NRv#}PA1 1@uu0[ $RY5s`52\2-lQ)a-cV`a30wkǀi mp- optical d
/ce d=Aaa (ylos%bc|BEtherУttu0$D 2 3VwToM  g: 
!	hУwork1w/ Db`,>ilivh;>s Akku*oTAS @+0gjoPlibH d P %,Q%^PDual-_% /&O(-"#,1&'b1O2o+A  5:/#9>3' ̟=?7OAoBO;# OEoFO?'vloJ JCEMRG#Q`VKLţ aaаqk`qDJP4Q Y[%\oT]^\_X Yb[]ofgo``aj
hdr([ %e0:havy.s% ]  orsu2v@lpz pure q'rxys
uz;wu3v!@Er@ǁs
u(<w* $h "rސumerIn`  SpeedStep  techog?y Autoa	nYcgac?y Free`A ŠRkGavu Pysi  (0e`0 Ԑ0b@ :0F12:diP|btappi!koske``\<@mmaK~˚  Ei mn Configurati@ord`teur  <F1=A@> Fichierfor0 mАAffpage SauvrderШr _disque:la c: RQ|r @ ''unU.hOtealps dfaupv duIgnomod1i`DquSѓ e l'in`capregͶa\ Scuess0(d0qS%oJ0e sous`p@{on. մ ?priphpa sjӓID	'1sDAӖ|SmCpbf BIOS ӯ@gre Dsf!&ΖOKRtabl am 'usN Ou ϐqo 氤1a beriej solecn (qoPsBA@EtaŉCA`0ε Acѐang ChoisIndt΀mps gre0dprnjOez AppsuyԦtouapoШuer  =Ser, ECHAP=Ablȓ
 Accepp 0=OuiNp QC, N'iEm1e = qrА  U@rzs fShe!mrAcle `ucer 0 bri``z <ENTREE>ϲ#8

sui4   :-> ou BARRE ESPACE = Pea-DIEprecedeVTABCgVMAJ+wW %߾!" #`rrp Il <AssibqV(2Цc U!'{s'Aprod@0endPw(. Coa'D,01 ucan, @* emplace`PL'P2T(Are 0i(P1-s3d'accueil d0 rW27itA/xD`bi*lзPe03w(,$pŊq10u`?R!,/-O.f/25=a ru) +FacM/< TypRPAce0ʁVA2lID3b9JTa<caa(L1/L?2) VolbmoiVer."<ROMGmMPRevt~ţNumroxQ<QvidOQMpr!!cGlavR o 
8DPXW@/[0D]3_4aamov )d:HW~ZM_ij
galmg8"/inv3@O8</PApritt2(te)s \y^{`}b? e4fggH/Oqk /noo/sDBţGeШde02 : C+IetruAO ie r"F P"C'V /!`ѪR, r`
Knr5o2c a7@D4A!' %LD4a6p t;ro PaC@ #6A^ /Uv`3	G!a@;Ȫ.R ͮ?:Kf  @fes-v
vl0O  o  ? Igno	$i߽S$A5~ Enreg$e_tP TA1 (rap	)2 (c]o2et) uݰ;bim( ?)p30iPc s .60% 6MvrF`ᡸl'h ǐ@p<x':)'҂cnud'vpU-׃ѬLŪ psupp0APibxpQ: ID4/'ex Rs S.M.A.R.TPAban@ .# A s pѧa,P
) VfpWansaQ3A Marp n 1!$eGP!p֐@c3r9amme, avSq

ad ?Z0obligat2O*6!dtD| k	s `8PGo@)fPNS tCPAÛ5   si*0
Cf`V 0Гesrpv`am0a`la pfor\?. N5z*UQ avou103ra 	s
PN`&Azq5q OĉC$T }N15s; QuickLocksusAU MA`4W7ri P<SM13aBЫPrecs5İ<@2. L'r@8W'& c %draTR`ʀQTpExigb|u4dYPQp 0 ra0allHK RsAs1fil BopO5PC#D-Px7GEG #ǁ](;0D(;a(;pc
@vpal
D-: c$.)-PD9r. S
cxB
*dez RdeuxL&(UTILISATEURPRINCIPAL),  'B`Wb,alors  d- N$z J 1.Q,qs3rq(fe %2celu*DPordin5u. AubGPl?P Ipd1-PYJ 0MmCLetIpDE: t6Җa +aQ3dp ab- 5F`ܕB0BE, appuy# "g` ECHAP. @%l.lKйQ_zb'E', puiNmrmQ*tnF;10pTapr%rmPĐBBSq ?b]?w%la*$e FranasOPYF0BQMultiBay*(;<~(or) sUn#jUSBʥp#8(;ZipoPrem DHiTsbQu9a@Cin0Sixi Se H@cNeuvcDMo< num/G0 Permsns Fn/CtrP7C }Angl|~ISA) P#ph@&op9ms AӠ{nc Vechna
adeltrCPf hIߞ rn0rimaadiidpق2Bid`apu_ mmHQ-Vf	lgjBs@õpg z r9u2blOoc-n$NG!ʑaAƀc?1MEpAۄppQȀÀ(A1ur=)ccueA7Ϸ1oB Ethqt:&;Ͽ<=MT{okRingO  "5ƕȕː=Idfa|Aupٽ@eP1h}Ԑ ďՀf(-|l@/nre0N/_AbsQU hfDuO_@쒀b? ?_ c"-/
Opgn?  ܿO_?
oFe AЉ@ex(@&0j	 _p 
/O :[!pe 1/ : C.(}% ]a}'`mi4ܖ)2(Dg'+(-)J-*3(R@k,I1.n2** 6"*  !67 }
%"#>?NumroBcroceZpW Auto!eqぱTlibVLegacy AmorQc@iiEG RetardBGexpi`pg) D0uRFs12Lсposfi!!1qux
 aPtB g|ךaDcun I h`z01lg <F1=AiD>`nfoewSAemaMlUvVSalva0kl ?floppyX`uxdSAYP@ttovYRiptina dY\oZ]4[\ifa\ZK0biЉs]uVIOgnor^1ydned escis E`g]l'iS'zpX~YfYofiY?kgptupv@icxzzapPsswoJehaym +PratoᣀZyopocc!:q{sunA3Nvo[usw[vx<V IDsXqtV{woDALockJu`}oStYCJ@upFoq> BIOS]TwAgpaMvpCiy'xI^ SiXdtrui Cb[bSa05QpleqSCOpsqtQtB`o rigidФAt0aH['SqCl(p lo-ڑ Ava*0itФL0uXFÛDimRrS;atcaS m Dob0 д gALФvv!gqo~਒z'zPremi q siantaseracZ@]ui  L=&, ESC=Annu`#`qAAttJe=SEiìNp1g,8galt`C=ARuT Uslchiavv frGeccA$i`vCatu apC ]` Bd<INVIO> C +  GxZi'#e9.ҳeguҨxSe  un:) -> o SPAZIO =m 
Ssutss  <-BACMK@CEKcd\TABCBoMAIUSC+HØL= j0!ɃErrqg  Qun "pu@gse GdSi  vfu c0I^X. Cf'01 N Du`]K E hoggiao LPPd0`APre`TsaggaqCvmᇠ"Y  nbookQ܂AatespatA@qY"I3roAatc q?Z2ՖLJriu`gjUvVProdu \!qI Nt  TixbCqVelo}SteppnMisqcaqm?(L1/L2Mme KR CROM Famig!l[dyV CeaC'1o0rCၩrol1lPCer_ Mnoę1OI23O4handB	n
ә 
әpdS PsDePJBe(A)?Q/I2:3 :4":t
 $:&I/)I ?,+-O/h0D<!xfV50LondaaXFYAso:ו1xgger  `Ub8``PQreiri/r\, in! GAfav [pi@&'A:[Ur4BA:2ϊҘaQono`guCըDV&F I9`t\hgBt1 NQvPd >\&=\"8I2@goAyM@UbSebvo!?ia cd?ej@V i2Yire?0lpi\ AoT1 (Rap)Sb2 (Complet2c2tio ( s): 30`c %o .0%QdQbbtDbar`S'hP SfTYj:sB q@r alЛ G1l@琈L
qp8 Qvxq dLLTAsps nrib iigol@:`{anږde@ xi S.M.A.R.T.SBu.~v `~nuo! b摊RF!sÔh`ÔaSi9ǁF0IbѷdPފ@a`؋f0?p7 RL5ׁ=T^V9pc1BAmH2.S:aЈAXz,- a `\pLfuĞm eSUezzaSmartCa )r 4AJ? 3m<X!o0erdqd0Udwati gEffuViڞsopin  car:	q#vipa 5Wl1 ``OB +Wq_3<`30ickLocyk``spenPB`#]0moUus'M8O{`  0graMK0ڲ?be  Ԧp` AQG 9w,!Dtvari ;li}Rs`P709=bw!Qa
inf \qmƑ0WTE8RZwp@l Puls'>!9o CD-c8SL8E?aa OM0MOM@`~ ?pp:~u;t!AȲK;Q>a uMDBe. ADŦ`Ћ <Pbb_'UTENTE]PRINCIPALE  r ;a/Ka 0manwfu0]o. AnppLV0Tq' ]sppLfp>!THU^ePGfP@@QPPI.PHl0p:fu <ad뒓,ڏpum Q!]0 sb0?reW煓.rq0 \A ऀn1q_i$.FV,mZo ESC. 3'8}dovZZrPy '']po< e7 F10.Z1aWq  mӊ4&`܊ԃqgItM P@p:ԱM MTiBay6n4 (.) 1AOi USaBaESu0rkREZipRPrimoUq7hrz!9UOv@MDecro  Nu5m'Al6? Fn/Ctrl TSVIngpe (USA) Ti[pupQo mpl Qwo@"ic"35or:pl`&'@/)ckC7V@ppMoPPvSwg Bidp@ѨCapa0i mem@q- qLHd`s l¦pT̷'2 N%Rparmpqenerg1`1  op<eviic=! k& BDpa
(falAd/;K<s0c Eth0"e)t6= @1A8B2B8B3De Token RingBGDGFpHMJM3 Ia } Rӯ{ q6gUV b Tq(¿YZC`brXY^  D!"\a\]?c 6i`pDu@Qf[ /\f?k_`/joc eG<sgirxol@m/w|p-e_So/} _u?_y?}t_~1anigp O/~`!#=mo ăaO/Om OomϢA̳ ///OMf[ ap :0ro .# % ]ϲ&comQp#20S N30 rɽ**5CR @¿z16mniϩ@O/m`u7b?`AutomaݐFloppybnU.legacy AadraM,F.!Ra@(sec.)C ve e86אF12`% ђ7%φ&?ޑ'( 9N0uup <F1=Hjlp>!rkiv SyainfotPRP-p3sv S p)kk`	igu QR0,stll frnl, Zn`Har_d Annu)a n9 och@sluA 
 @n-A S'ker !d?trsl0
'  Ka2` rt-E
n ssv(-IDzAfP'	tdytd fr >& BIOS3?$byggd 0>ihabrikP:Verktyg KRr v =T 
Svt0 =1"%~HDD Ak%60Xus f@t Vlj-rkmo  nWedt`0tl {|z
z Trypݠ0fri g@ nń)u1 (st=, ESC=Avbry&Ft%&A@3p0,a*(&", V>#=Mer p=v  pil$$X$P
a 04yAt5#<RETUR> om$!Stt=. eklj e$er2$  [3: -> @5BLANKSTEG = Ny 	  <-8 Frege49TAB9f WKIFT+`>;얁= F) nA&B``HsfelPt gkr a k t h$E`3G uppstodRd5Fen. FelkpK0y1AinnsgGpIpla
`τtm krvL TG@
p{m fly%s t % U-dv@Xr/ ex̀
OQFp"@tidigJKL2,X$kl0T % kNd,1  P5, typ~*ahastigHag:Ca-[rlek (L1/L2) MM<`Se ROMP+"gfamiljtkp%,ؓg'`s>1Jnummnp,deogi1$$Yb fyr
Bpjp, 1.:oo2pN3rN4s,a+o%`-vonxCqn -pIznhg|(qjw,v@pp (b%)gq1^}q3st\}Sek \rgVar! DeO3Q錰  Zneh"Pr6%skap! "/BW-a$i
Ykbq6T͂WcA:@G K\&3Hhi%IrYo^ҔskyddWad Lag$@@% o!$H$  u짡?0ig 	?wC6Tz1nabbP$b fnZPU[kPad kcd (`): 30(GpHS?0%_aGl@# Zs5[p9p1vrPO&Ma@*t:L: G)Okp$SᔁG#eorvo-׼LrG Yp5BHV6p3ttribut: ID 9`ML %d grrS1S.M.A.R.T.}-E GammAG NT7  ifin: ɤ LT GՂE  -*DTvAlika mp4 3PP  fIO1ianɐӿѲ  's  fun 3~֤ QAv om  `@hQtsQۯa sGa`%mllo@. g a$1glm͓:tjr|helse04Oresu17iru@p$f%eY"Quick1 -telge LUGm0m" Hfk mjliggˡ>rAb%Qv"-0  ܢLek=ooihg`Ia⎦bliPha- t04K Q͡omcPi` pDp%fbP`6SPTrdƁ$t_ naspp TCD- h 0e򴤖r!/Hrdѝ pMf]f34
 Huvup -v: DPÛrht/d Deqw:	@ANV-0HUVUDW0ⱔ⛘t Tpe  t g.c 0kA 0 OOild fr@!V5 hka
@uh, G lp[AO n0礀Ѡ. &-bePf0s
epm B Hvᐡ45 W .0
0 	  OE-55 (7R .RV&DTQ3
'&' s+ed#tA.aOpB/C5t *a:DT!/s8*3;$FޱS 2m걢:`MiBaayVn@ (d|0RB~SBƝaF|'B`F Zip-3nqFa! FjQ\ttoJNJTKNum *QVx`Fn-/CtrQl/ Gm >E\lskt (USaA@` kdgaFAQVdskwrmstroI!vn$TaT<fbbel0@Te@eon?e Flk@cZ!	  dSEr!Й@-b AggspܔmhvdQ^,d!ptica0evic 51r=cru
tfpb4nsv@Maexp Ęnedf/g Ethp!|Ebjilll nToRQğl{qn{q_pNC	Orw_tIy_vUnik Znt2T|v|>0tus ςs S$?>9Kalib / ӀkdB]CFZDual^OgO Oe/^ v_eO?ϚD1sq~H?andtag X//eaVDAmo0T 
|:ϻO/O yEßĻƟ@ʤȘ[ }e0r : Lar .# % ]t>-ф lar2upқ{%3ZO׬V* F $ !]4͏QAutoPQ]brc! egacy FreeBMYb,U4	sadapR2lpHdrj?a~snabb (sek1.0F7F1 zpDYgRBd)OStyra !IPR*pUgqeIn`PQe2e `K {O&dslaan Configu0o  Vanaf k4v?TQ?ndaardAXߏ  s3cWijzigne F rogramma 3p  {Soetup zqKr w4	 ?RsveilBhee)rswachtwoAP?;u AppPWatbg|$ ID's+'4!{SUm C-kO	4uv@ !BIOS"!o AbouwdeP:7((sa4)(FabrieksΠugz1kxt3AccuC te(`<elecP a0"bes#zelft <-schijfe!uipSAc!>3450I D bR8?20 wpgn GeacqOal0Oc2emg@021?R8grijsgemaa`Qve1lpSbesB04C\Euk5@PQc	g=S?, ES?C=Annu W-bpJD@JOK0=0e/KaJJaNNWee Of\i[, A#A=MxpkzKHulp:?pijltjHp+ruiu`dP1juip0nukeuz@Vark<ENTER> ind0HUz2C
bep:vol(T`ܡH2C  :  -> of SPATIEBALK =[.<-_BACK `CE`VorigLaTAB"c\cBHIFT+UepcSBK= )@3tN{d OiKt1fou+De`W<k0niwf'geD> Fpnp`req tijz"s6en. Aqco(01n@aIis;Cju we0@{etv3oehreV#00 0 d#basVHo tt n not~+ok-pc/R2 `Qiws5wm#Ar hbe Yigd?q_rxs2 m%:;q.`ot N5|msq>ypPTrocessSnelS~S;ppzM Om@e (L1W/L2Gu_capacpQi+ROM-Revis  HerzienB}ga)v3AbRS  Wmm	a8%|5;?videok+Vu\ptro p<y :PI$-<1o<2<	3o<4<p `f*-.WϨn re&OIn@=istgI"tifictj3Ae c{f(0[dz) OdPdРϹd PdأOh*pϬSB3SecupiRB3Lzop: Ltot aps egewV PtHbe5Af X dQ A:]g-  /W U
G$eҢo\offmGH@ayֶ!ued
 
A=AӮ0u)o+gtI@/..
ezu7WA`@V^zwilt?	
a5Q? PN
Z75]TQ1 ()2 (UU06) 05 B}vr} (.): 300VP.h0%[too"pFy $hqo	broUD:7moenbA\cnCpbnC vo-leesen7͢o 	R#rt5`yUk:`tbije S.M.A.R.T.1-
maf`U.3udXvieuw_XAwа(BloPY(6( A0JP#@0uoPw!q@k1< .Nbz 7(еPjls X Vz햋`WZiKs !bPIsw@Fu  `Q~akelt, p|q;@e+j,2$`Q6"#$o  %hw7SWtCA-m!&>',  d A3)3a'eksNugze*L gx` ;erlo2sAZzrt55 (bЮAwf"houdHiI~6Pp6  0LECFDm DQDg#0DՑ$ TǗAXAmVFFB<AmS?/pp[P//g!u2,2r I0p(b;r. 3`W-s;e_k@traak*0u!T11]bwIp (pI0}pa0fraroodZ ParZzp1DUdloo@wetw
 Kn>O^ Cd-rIDXaNa'V D	dPdРdP_HoofdG WQ U=evia_0Lỷ;7it1mzow@DHOOFD-GEBRUIKERSc%ad  pergmanA;V S pp  2СwaNkl S{ fypkap<pfcomp vg(_qSos*1 !`p  Wt  ?s3ebbPr }wpSYcs. Ae)lm#,/CTa=n$.lijk= T(ms , u%AEwSC-. O@ 1!ϱQPfmQ R$:'m'ptykq_F1!0pPT  7hC 2 0^m/c%fcNel A1+ MultiBaydڥf 
(as)3bЦ USB-Gc``s 0p-3 EBGwea!VQ=VaZKesPZ6PANP tus Num IF?n/CtrlCsse}GǠ`ensM3)@Osapp0\DO+,bqu be{rmtl0!0ȠnߺBijVP{o-10! !k\&㰾d˰EoKlp[v1gPumdVPnti$8HuVp^㠞
PN
$| e2, k;iePQN (bܡ4)?0ZaEt@^ eOhҐfOhҐgOd TBR!0= =R^e޹2߸3 Up k0 0TtcΎ@(ccu7 1 Sa~Gekali oKB"@aual3" ou3"/aĥBA`? _3 H}g@pvormy o	Ler-MUE-3"/  R3"/  [qp? 1 : BҒoz1T.% ]AOfСtoo4D 2 nt@#$!5 3  SYt*+,."*2$"   2zO5wFMod z@EggacyAӓaf<^adap|AAѵpUr(0sec.)p3`npo/p-uprIsFZO F12 i>P?)pbb  cursorburaKEasyPo-HGDG  Rs[^̃ZbgAGviSETUPj <F1=wv> t@CFVXeGJɊJ\܂]FtGs@GfBJNɕۑ  ݒCLoMNLN畜QPďOS&QfIH`IgO  Ho'׎GVeJOςɖ%QYύXɏI  B[P[AA[ȌԂ̮@Q܃@Ge N^[lZT[{Oeg`pRo^_GLcWǗ҃pJ@GhfWdfh'h No JX 	ek@\̗L/Y3QeJIDGJIDn h JuSN fqgn#]A@Q͍[$QSmC߽ܰ`w BIOSw ߰@wFhzl^{ k^{EhDW]cGFc@G1JoGe  Ia&QnfNalIeJg Iv`JυᆂAn	&Q JAG}]L; ڍCF\cLLv߂aduVF@@G:ՆObtB!hϑsDQu@GjNnkȖUmmqL[T A=ႁAEsc= eF@ĝso3u/0=󂢣 y [AG@ɞCIFJ@G\ gpTj!Gڂ0 Jsugv[Eq]ՋPQ0ȳA̘FT->uJy@GPlo[ = {Eh  <-u[BackSpace]];[Tab!A[Shift]+]϶hA!A[m˔F[E  G[  Gł@QKrf_a 01 O X^V UѕɂACϊO!j`WڑLKv Uqb eO x( masr uMEUh"ĵȂl22eА׳Kϼ{J!Sɰޯ   ۾ ̽t֑xfֽïݸ  ށiL1/L2HROMcrWwr Ay޼ޮ݇رٔԍ  ޵ܺ۰ׂް"ޯ ް	t ? ޯؠ ު234 ޥmx
l	፶'Eձ ؖյşc(Â)v('34 /M@eJdJF_x:sAgS Pu"b LׂďTN/Sp٬wvsA:[݉ ngSV3N}	oS  >F' 
ǣe
֎~ r O
nM`WWY  EZ_B QHN#b V3ZKcX_/#Oag`GcF_o'/H*@1iN JrH2iS03`H.M.A.R.TH \zsij: 30dg2 .60% 4? OK z1 ~F7fF:*2):m]Q:e
>T@G{>ǂ(?s Z;T|aTĎs(FIDp1.bXE 8 .hH@̉fV# Ijûn2PnP ྴA gB[qr (@g#PQK
Rv"?߼$[D%guzb?gnqrʀ@d y~[X}21hit Cƀ\^ŀE\ 	ŌChԂ!E	*[Y>Ľꍇupigbq^PR!i  dƂ `6e18fd	mv^t ǯA?OyƓLG?S/N*hvuBBwTA@hGvGs{^#U}Ewa|ĉT\OsL ,%YL28ی삪P+eIP h蕴`	(T\1@xpċN{8[v)q V@bAD ԊOtNOGuMȯܰM% CD-R $Ȏ>T5-tB1234`v} ^`:`v%U˙uimp\eBw@ )QQ+ l p{`@mhvPR?AT`m qDFwbĽ	`vNikl$g͎\>R@s0^痣hS{#ÕۊbD 2m !mOh@mʏE&-uBd[d31n_ {_PРiPܞpEǐkʕۏ؊ԓ ł৶¿͗Ljϳǂ`<9L~ʂq]l`fӔCXaB>[Esc]A{bDЄȍ~ 8#"qyB̗DriveLock @mtBSp%['F10DηC41nUp  E%qu-uqSiwd}6`%: Umb_u!z DxڞQBb bO xPXiaa2)aa2USBHZ-XPpg Zipv1Ԗ 234567j8910GNum1cd Fn/CtrlR?̐ؑ G{`z{  p (USA})(|jBfCX>댃KVChD-v C ­gP C% uB}*`vr-IoY̍ CKW qo  iCÃY  YOaڑ͏̧F0X#\2C Ygȓdcoptical device dODEtherneN ?zgPN  Ȓ1O23$ lBLNk pk  膃j ID b jv5N(  !)*d+g O'5?Д,-.jO/o0<f  b2 2.5?61 78J4v_;n.=> 1?@_3w4%C.E F1HCJ4nyA Cn.?N_O1PDv4MEU5TR.V W1OYmZUd\CZ X_[a_]<Pbv1 : [d .h@c% ]aog9׮xi2gAh)glhljv
3g#h)gqnHn
sVp*vFp v B8:xS[odjqT i opIntel  SpeedStep technology_  Wt\P   _@4ް Ӱ S`u gx(b) @F12ԁiCb6y * ^`pbBґ)ߑ ?_ߚ ?_ߣ ?_߬ ?_ߵ ?_߾ ?_ğſ ?_͟ο ?_֟׿ ?_ߟ ?_ ?_ ?_  ?_ 	?
_
 ?_ ?_ !" $?%_&'()*+ -?._/01234 6?7_89:;<= ??@_ABCDEF H?I_JKLMNO Q?R_STUVWX Z?[_\]^_`a c?d_efghij l?m_nopqrs u?v_wxyz{| ~?_߄?_É ` a b c d e f g, >         F  	 
    "  
  <          \    `        \    
   d  ) *   - . : / 0 .  $ % t  & ' H    [] Np! p( p H[t[["[([$/[P5[|;[A[G[ NO[,T@ЍU0P0ŉ<BB<ŉ>"Ɖبŉ0`8lÉv x|vơ||p0pǉ"  "0   = ~ =$$$<   DDD OaƄe  i  o䔕 u  y   nA0 E  IÉO   U YÉN ~ `' ^    ŉy z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:?5-_V<>( ) +䱴#'?
ߨ({[)|+}][{]}_'@ (#^()\|+y~ z# {{ |[ }| ~ \ ^ @ ] } ॱ&12"3'4(5-67	_8
90)aA0$qQ'mM(%) +*,wW2,?3;.4:/5!U@ z {V-+*'߇(as$|  9+'()+'*ӱ!ճ0øb?
\()| /ۏoݏޭҶ'5 -=
^~+]}@`)  ';+(:*[{s\_}\|    w  ӡ[X[(P|P\[PTh֐([FPPPzP	
  9
ĉ:ĉ;Þ?ĉ@ĉAĉBĉCĉ8 1 [ _[\[^[la[c[CռPJbO[1]@ĉQĉURĉSĉTĉUĉuVĉ2  WĉXĉZhĉO w6  	TUB*:_&`[~q  ]U^ĉ_`ĉaĉbX
0 VZW[_
[[(A
 iA( 
]tk]lmn_ 4 :  0S44 44 3 	[VU44PHVF10 Setup Imageq!_SETUP  򭰏" 5  6U4p$$4U4p$̺$4I4CP*6P,, 
`V,/J.Vs д2ĉĉUĉt.VUĉ.VQĉ!#а. ĉĉĉ۪ĉĉĉᔊĉĉoTp2 4 .V444444444463 \ 64 U444	0PpF5E*V!F	ĉꔊ/" c-" -" MN2 U"0L	VTT5TTT '2 |0LTCV-VWXY[/\M])0U0LV|(3s2"PR S  m?R T T  7??
??	?8?9?:?;?<?=?>???@?A?-P
+[VTTT#  TTT!T&TjT3TBTiTnT+T0T1T/2Q)_RÉ$0Uv\.S PvG7d rc` T} /7 5u2  w0UR0 Ndr@PxP֪x5ĉzĉ{ĉ  }ԉ~*P0W_ H >Xpbphp|ppppp> F^԰>$040N0Z0p000000<V\p@,>,N\t같а같>0<BfԚజ @0B0d00000>@0`000>0>!U<JZjUz0000U0000_	>"p>pUPphpppհppp
W>:dxU>U.pNprpppppp>2RrҚ
 R*r"
@0L0f000000S>*pHpVpUpp4p4pppW>.RU~5pU6pXptppUppppUpppp5pp pU6p^p~pp5tp
 pU4f5U>J`՘ư$T bn|UĘĦĸtU_>p"pU0p>pJp\pUlpȒpȸppS 0T0|0զ000W>(V̄մTT`jUt΀ΒΦUİS@$*U28@FULT\bUhрђќUѪM 0$0U.04080@0UF0Z0d0r0Uv0z0׌0ג0ו0נ0צ000!0T PbzUܪM p@pUdp߈p߶ppS0\00500 UX↰⮰ְS @0T00500 ! ͰUJh~堰԰"6HZj*|硼US
#pppU<p>pBpFpUJpNpRpVpUZ4rttxU|ppppEppapppp $Tp>p\pp5pp %0UL0t000000&T@p8pRpfpUppppS' ͰNvU~ʰ(0<0N0V0n0~00000)Tfަ* ` j   +RppppS,,S-~.p@pNpZpvppppp
/ 	2	F	Z	t				*00\0v0000Κ001pj*pppp@oǰapS
2^U3NpQ4 Tr!Ԛ05`ΰ䚰6^ªܰj7 , J ~ j  4"(8 0#0#0#0#9p$p$p$p$p$p$:T@&`&&԰&S; 'H'`'R!x'ƌ''ռ'''<T 0+00+F0+\0+Uj0+|0+0+0+M0+ =-H-Ur--ư--S> p/\p/p/5p/p/4? 0f000e0000&@˰3j3~33333333°3ƪ3ʰ3ΰ3Ұ3֚33A 08$08408J08j08*08080808I08!0808Fi
B=2=T=!v==4=a= C @Up@@İ@@SD0Bf0B0BM0BE pCpCMpCFpDpDMpDG@pExpE5pEpE0H F5FF,I G5GG JHUnHHHذHH"KpJatpJpJpJpJbpJpJL *0M80ML0Ml0Mv0MoN%0M0M%0M0M0M0MMT@U0UBUfUUzUUUܰUMU$N@0Xf0XUp0X0X0X0X50X0XO pZU@pZ\pZpZpZ5pZpZP p\U>p\`p\lp\p\Up\p\p\p\Q^(^!6^R^h^^j^^^ R a4aDa`anataa°aꦰaS0dJ0dt0d0d0d0dTe6ejejeeeUJgjg~gUggưgڰgVgVpj*qjpjVpjhpjpjpjpjpjpjpj
W ͰmHmlmm°mְm蚰mmXo6oJofoojoooY 0ra^/Ooǰa^!VU20rT0rx0r0riqr0r0rZR0yT0yVr0y0yU0y0y0yz0y [z.0|NJ0|\0|l0|!0|U0|0|0|0|S\ 0B0T0d0t00j000] *$,0a U48B^U+*^NppT5pp"_s0p000%0M0
` pLpUxppppK a00U.0H0T0b10000ʰްb FlcVpjd *Xxeϩ!иʰ즰e@4BP\djrzRư!8䰖갖S f 2Jbjt~$!ٜٔmպ䰛g*,XtaUذMh3p<pURphpppSiO000Sj@000Sk@000Sls000Sm@#000Sn 000ո000o R!rv𬈪p!0 0BJ0X0x0eN0D/OQ0)0!00TM0q U2N`USr@^U԰氺}s>:UPx5tj:\a]u p2p8pDpRprppjppp v000J0Z0x0Ą0Ċ0Ĭ0ʚ00w |HrƒƴVxf,UZȌ°K"yhFafUpʂʐʤʥҰʥjz@p4pRphp΀pΘpΰjppp{ \ЊРкj |,FdҊҸ!r }rt/u!000P0r0՘*0ռ000ay~C,pFp\prpܖpܸpZppCޥ2De}Rnޔޢ޸Κ  p"p2pPplp*pppp%%ppa p⡃MpLUn TZj辰
p2pZphpxppppp0 zJ(e)A |0 0B0UR0v000M0.@զ̰T0@0h00հ000T 0>pNp\pUpppppp ְ |0o@J@^0:vU|Iưް:; G<)="R*TRxaְ Rp@jj& p	p	p	p	


⦰
 v
@0
n0
0
0
0
Xvʰ  M000N0i`*0000eN10-)"a4>%UHht|UΰS phppմppp"T 0J0r00ը000 T@0 D0 n0 0 ն0 0 0 T@k0"h0"v0"0"հ0"0"0"T 0$>0$F0$Z0$Uh0$0$0$0$M0$@&H&Ud&~&&&&ư&&$T@0)t0)0)0)50)0)@*UX*n***M* @,,,,*-6-L-`-z----ܚ-- 0@0b000К00F2Xj222 ݪ04j040404ܦ04 5N5|j5552@
070707#֨Gv#77 30=T0=r0=0=0=0=0=  0?f0?~0?j0?0?0? @2@P@`@~@@@@ʚ@@&\CbCCCCDC@w0F^0Ft0F0F0F0F0F0F0Fܪ0Fp0F0F |IXI|IItJ@pKhjpKpKpK@*L~LLLe5ܰLL NU^NNNN
}pP,pP<TpP%XpPhpPpPUpPpPpPpPMpP 0T80TUN0Tf0T0T0TM0T(@90V0V50V0V@pWUVpWnpW0X0XM0X 0YL0Yz0Y0Y唸0Yʚ0Y0Y@[d[[[[[Ȱ[а[ذ[ર[[[[[ p_p_>p_Xp_`p_hp_xp_p_p_p_Fp_ pb- pb%2pb<pb%Jpb埩fpbnpbpbpbpbpbTgfgzgg5gg iULihiii)Ұii@ZkՒkkk(T@0m0m0m0mS"@pnpnpnMpnoo5oopUVpnppppp7(r:rTrdrzrraGrjrrrpvB4w/U^pv~pvpvpvpvapvpvjpvpvpv p~Bp~bp~p~jp~p~p~@pTp^pvppppp "DXtڰ즰 P\rZ$&0U80F0h00դ000*'"<N!(UrxаM pTpU|ppppS
 "0B0p0Ռ000 zl}a.UM@s4UD`|հذT 30N0l00500&@ZUS zpdpppq p𙡆o89:jFbj JVzaUã p:pRpdpzpppp΀@n𦾚 cF\jv𨌪𨰪ޚ4 %v4IT*ڰ찮MS$ 0d0v0՜000Ӕb<Pa`Tvմ TPp4pNpXpUfpxpppS 3`5참@0Ul0000S@°jްeZ찻؀P2^𽈤a\\D]1e^٪C`2<Jj ¾R- K0ie.0U40Z0v0ǚ0վ000T e`ʂʤ5UPň̸̚߰rjΞְ 3hϖ(pьpѺpp@xjҰް <`ӂӚӾ 0F0V0nB0ֆ0taau0֕000
Owmx<y{T$0{0܆0|U0ܤ0ܮ0ܸ0000T@L^ᄰ՞ȰTHnpUppppS >RUnM  
00U20N0v00U0000000T@s@b|U뮰5@pUPpnppp5pp(@VpU|ppppMp 00000 2F\p~ܚspPpfp|ppjppp \vذ
P~
a/Oo;a!
TIDj|UȰVC0.0UJ0^0n00Ut000M0  F6UfvаT0H0f00U0000500 F
U
 
*
@
U\



+6php|jppp* eJp\pppMpծpppT e~%eSv4PUh~U̰M@PUzS j5аs0Ud0t000i0eZ0@s @ b    @ (  ̰ ԰ ܰ 䪰    @$$<$V$b$h$x$$$$$2$$vp)Ip)d.p)eeBp)Vp)dp)|p)Ěp)p)0-N0-r0-0-  N&p.Lp.tp.p.p.p.kNH00l00D@0000N^11ް1"Nb222&Nf33꾰3*Nn4442Nr555*NT6x66Ԛ66.2086tHtZtj*t|t0808!
U08080808/	Nv,;/ڢxV<{~;*;;;;|;;; 
WNpC6pCPpCU|pCpCpCpC_(NNpEpEմpEpEpET<F^FFFFFF
WN:HRHzHUHHHHS 0J6JXJUvJJJJJJ@)WN M6MZMUtMM°MMS  0O0O^OUlOrOOְOS
 IQHQrQ՞QİQQT DpSdpSpSpSS<TvTTְT 8UaCDUNUbUvUUUUUJU1V 00Y,0YUN0Yr0Y0Y0Y50Y0Y<p[hp[p[p[T 8\L\j\\ղ\ְ\\$@I^^İ^ ._8_!L/ (!LCL_x1`_5ڰ__ PpfUTpfzpfpfpfMpf$@00hh0hU0hth0hthS IpjPpj`pjS@?pjpjpj5pjpj YlUDl^ltllմlllTM0o60oX0ob0oUj0op0ox0o|0oU0o0o0o0oS<prXprprprpr CBBszsss I! IpuPpuepuբpupupu$"T@Nwwwweww#Gt"y2yJy\ypyyyyy> y֚yy$K}j}}}%.~~~~& `0~000'4pNp~Rpp%ppMp(<n)F6PXbpްQ* <"Z0I:eJ%`hn!,Κ+E,2p@p^p|ppppp*-0澰.NVа/zj400j1 kj2zlj3 vT_Rt54@Aתo&<Nl%<z<>Qto?@!,5 0pb0,(pBp`prppjppp06.0~000ʚ007@ELb𩰪8 IpNprpppppp9Vj谮: 80P0v000000
;\p8pdppppp< vpVpzpjppp&=Kj000> P0v00000000?^4BPjڰ@@EpDp`pjpppAC0T0t00j000B I0b000	C4p>pᮯ`abdRpdpjp®ppDC.X~ȦET^0H0d0x0U0ˮ00˭0FCk2\j̈́͞G `XvЦмΰްH o"@.PnҪ*qITՊ!,5,J3ור׺e즰K PB~jٴ$L@J0P0b0ayr0۪y0ێ0ۨ0۶0000M@M6BXjޘN D0~0ᨚ00O vpTphpppP@PtR㥂MQ5VU0l~撰ՠ榰殰T'0溰°ذRFpp*pNjpdpp .pp-padp%*p륍fd2p!,(SVS? &1TM>^~jU ;h@9000(V@]ppp8iWppX.j000Y kj000.Zpj000"[V0^000Z00 \ U6L`Q! ]\ 4 %<F >b4/@z    T !,   5  ^Cp	U8p	Pp	xp	p	5p	p	_2pUHpRpjppUppppMp ` <040UH0j000մ000lPL0a 805T0r02u@0aM000Lq0b5pHpbp4R@pxvT .ppppSc0P0x0դ000dT|N|5*e kjU@dȪ԰fM060D0R0^0r000400g1p 2p Pp np p p p p h4"B"Z"r" CY>"oÏįdTa	"""M"i@+H+b+|++	j+԰++jMR0.D0.!.X0.x.U0.0.0.0.ak0. k3p16p1Rp1lp1p1p1p1p1p1p1l*(04D04R04j04v04Zp4p46@] :0404040404m V08Z08080808!tnT|9f999e99%voת0<N0<\0<0<0<0<p@.=.=<=ayL=y\=n=======ܪ====q PBTBxBjBBBr ۪DBDfDvDjDDDs|F^FFFTFȰFְFFMFt -IMDI@ )I`I}hIje>nIUzKvI~IqJIIIIΪIIIIu o0O*0OA{>Oމ>-IF0Oab0Op0O!0O!t0O0O0O0O0v /UUUjUΰUUwתpWLpWjpWpWjpWpWpW<x#jpYpYpYywjpZpZpZz@p[pp[p[p[{ /\\İ\| -]n]]⦰]}I^2^R^p^^^^a%^^~4	a@apd0a5hataaa°a̰aoˠ1dIpi"pi.pi6pi!tH0tX0t<piDpiVpinpipipipipipm\pmpmpmpmpmpm poPpodpopopojpopopoqVqnqqq԰qڰqq@sps|sssssښss@pv8pvTpvxpvpvjpvpvpv xx:xbxxx̰xx ezZzzjzzz e|`||̰|F|@>0~kB0~UL0~\0~l0~0~U0~0~0~0~M0~pFpUdpppppppT ebM1pRpUnpppʴMp$ 簇xat/&O'o(at!l0000Op>pbJppplpMp ۰:UbvⰐ 800&0L000j000 *:v԰䰕I0&0*T0a6.020:0UX0v000M0( /pp5pp
@UpʰܰMp2pUNpxpppq<pvppp!ܦpܶpppp ߰.>NTn^nUҰ ,zư$ w0p000 p^*ppppe5pp
 UBbp|_>UUՠKT 0B\Ux,S!)"Z|!_,g>3P *1pUFphppp5ppopUNpxpppMp@0`0U0000S" ,l5
opUTp~pppMp0t0000!)@6Lteb!L?nÂêed/e1ǯg ŕf 080̡>0b0n0x0̆0̨000Pπϖj԰"pFp^ptpѐpѦpppp
 ETpӈӚӴj  ߪpFp|p֐0׮0׸0׾001Hfzؖذʰ䚰@<0<0D0j0ې0۞j000 @ѪpJprpݔpݶpppp( /ߐښ  0$0,0:0F0R0b0v00Ꭺ0000j000
Ip.p@pRphppppܚp 0*0<0N0`0v00000  8!P/)!&NUvM" 5xJaϞapU\pppppppT[Nf~UM&pZpUhpzpppUppppUppppS0f0~0009ppppp[ J \ z  Z  4pT%M@p2pUBpRpbphp|ppp6CT|			40000* Gpppppp"0&0B0hR00!J00U0000U0000M0 4U&8DLUXtʰְmF@WpeRp*%S*p4p<p9^ppapjpppD@\jvFnȚ"À<zj԰ @> Z    ŀ[p"fp"jp"p"p"#j###j###T%P%d%|%U%%%%j%%@.0)B0)edL0)KfQlt*oh0)0)0)p/p/9$PnP[01[     l      [Y VZ   QpLGB=   0{+&!	!$05/29/03 Copyright 2002 by COMPAQmputerrporation. 䐿
!`t`
T
 'p~}P >""'D Tut


t
tt

"
#
=t
@t0`#~ )0{TaD>0$`D@t#(t}bD	T
'T?DDD T;%t5 !t
t
{t
Duү"!"#$$"#!P%d%%Ô
@$$p#"2` нp$ЂЃ%&u u '2Txu. 俓B/+>$4 `Op"  { "{"
"?  ".)z|e}~ }𣮂)D` ) Cp`t   +,-.
..- $-@2,,+ $+p8  )" ~}|}J4"{ z}b79tu9T=tA:;}{ |e<t!=8<>$1%A'%($('&_"A&B&CA&%ӔP&`ӔP%/3d@C$d	p?qCb7%u( %0B&u*qI)**)p)N`._((' $'p8Y@2qCD;a;?%&$4CA!D @((sGYOdr͢QehRۢDPPACS9"TqrTt~ 33"U]pPLIDU=A#T.CYT#"բD!*[bƢTT"uPu4"%$:4@2tʎ"0"
pKp"0"_d   45t~(t
5"+c+/ÞP.%c@ Sp`c͹cm0^{ +u.qI-_.. 8-N`Ia,f 
c,;g#hBcie,`Cdd`"_7tu
8c" s/tOuovwxyz|/}}	2x-{| ;_   01/0A02/~ 04 kRu3qHewlett-Packard	any.@0Q0"x#Tq*T0	T@t/{3"x0x`v$dPx>0#1~"};TT?"2"2
!x x)} @;uu u	`P2P2@)aT$3TD ȃ@VF @c~`T?0	TP2`T%`ר@P2dŃ瀾x!T.xT?T/TDx!TDxD@x``p
00/dp*tP M0 T%%0TO~P.!OT"r()B)J()(@BbhR PMoMxtPTa"C#x7$0./R// $.Ô.P	107xTxD࡯')RSM~;0`ӧx 0p"xD¯./uvү5./"xt}
~q3}xXvvu_u0P0Dࡸuu!B
Lڠ!ү0V~m 𑛐xvE``
$`$p
?sషxЊe
'xx txDE SxxxxaD@5} n}upgp`p{A}d`3 &xNI>L,x%tx}Dq a Pa0xtxtyuu V0}^qOא}eCsA]}lqO-,/ƴxeD0 ZѠD 1^x_RcD%xfTP`P'p# * .cd[3l-0iI񛧴Ɓr	@ T`ɉ"10x a	>00Pǻ0}pŎѽ3)" b P¯^u` w$T`#BRn045p\NQʄХد)u)$O4F^Kࠞ)}.*)Y(Ô@a*"x)(`#ڔx0%ovՒ"x)(*a00}++,`- "x_}408}7!=" }9P5*/x%~x=0T4d~` 	D#Q"00x`)xc`xd @p0K0S(;~TB(x0¯0*09P4.(0H(`xU(	( xTx ! (ATKCPF0< y(P>
0Tdp(D !+OP( @z5?n WO"6p@Ô2@YD0¯xx78Rx00`6+060
 Tߠ|`	p1[mnה  `a7!6"ڀ нᛴx,Kxtxx,!p0x]*-tp+»Z`AY$^ҚR ~xT0T?d?pp
0aT`ad`
u)?T d`pUpD"TӔ @
"T?Mp;T?`d`}*}W)pK0$"G@p`
1#u# %@~'~W)33TT?O)` 7  . )/7 e""G`rux_?N堕DD33333PE:ЂЃ2
2x_p` 	B_?a"ٸ5L 3*A3Mx-2+_NMNx*NMx+<QM0x"b=!==9qeL`
MN12A3K3K0=`C_D`C`CP`C4N-522+"F	2:RxZ2YA3SNSSQ4<@R`SH5t2:T  3^A3UIUQ}:@T1JUJKVҰLcA3WIWTW3PRE@V1JWNS2A}3 A}9 !.A}  uuҌВ"HVc_W47jW0Vx'
q[0d`W!0&--\P@'`2`=`HpQxX"`1\6uuuuҸbuu0buubYO$rWƨpN`0T`
0370Ѝ  q"[| }(xX"(`E(p
kAn(  ()(x)(0(p)))((xZ))"*+д[?T0 7/at
at&Ppd `g.堪2@t%x6XjҌ(px#k響,-mp,l`
,-xd@nvt j/Dtpʅ+*,-"uPu4e"[ Wx^!`yWxtwlOx7px8§7t1"Pcd"xe!px,"". -BtF)DG qs=w1v8zrAp#$W@n23{;"xy> !u
Cֻ9./0H*5,7_SU4cU~TVV~OPK|QZYQP}d%]	`
e(j[&b'gi\af6h+l:@<>L|RX>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L R Z  a  " ! * 2 1 : A I J Q Y     )   3TP g d   pqkli/ur}z'tw l k i h Ju s r p  l t z q { y m Zc v       
  	 x   ~  _  Y }J | # qww ~~   @".Gux401rWڱD x2t 1tI%W0% %xjvv %xjkZ> HRxl"# $ $ !23x1 	ү  ¯0 3#!PK03"0!PMx3>
2rWZ"xkOF`g7rp"" %	x30#0$<T`д9"xl `fp
0!#atI.4}xl$3z 
PHp`$Ht ylDˀxhv"xx0	Dc0Uy$Ӕ@TxxywqD"0 4xfxwU` еDT0
ϠqP" xnxoxv"xnxwxoxyxv "oxqxp˛rP
rWypxqf`0SVxq` g5rW1wB".0&u)P/})S@&*@&"*@\`~"x* \t %*un o-~-PtU-,-b,{R-h-o8++ѓ,U-`RiU,`  +u%*$U,00u,,u,0,*+P,0 Pd0`Ô@"0  	0
0 		"0 H`$<T"   R1 apy1ÔP2f0/ _\%110r0//}1Ӕ@t -A2]nO2zq.¯	 .x. xho`x\T`)Tgxgdx`yR"33"x4!,r3TOp0 0@0 
0 ]]#000+1d'`8`2`,`&:` ;`5`M`A`P+3{ z y5"CPNH0 =5`<}DPA5d`5d`
w`
`
	`5

5a"3!54Y4#P "l"8̓6 "63qْ9S6|09}= ~ } | 6" ONMLPM:_|b_^]}\T:=T0f: 9+`:80:808u6$`4D   6"6789x80ΐ6789t:_#I$%UI$%I$%6d'p/ $%0q+.+c$06$):$	%Uz-;E/
/f-U1E//R-2E/U/>-3E//U*-BE//-E//-:I #8@ $ t8 78v0	0+
  +u7x:370 t082;
V;8?;C:
K>>;+:
<_u8#:EAF
:T<u8= 2;m:|7pu8J2;u7Q0Nu7!I:{< u8| + 	6_u71:yuF{GaG:J<u8yu7 G`G;8@
8b,88p!77
0
6%os8@-0
05$`$`o$p0N(P0N) PPϒ88 O&N$ʀNqRR-SKT6'"9:9  :"9xhVxi9d|p%09R:N{z?y&sYsWvV0/0X_`)09#XVY|Z]9
Pi\1΃Z - 
[^ &-JbZ
 bVV;_; Z;S\Y3dEb:;<<:;<`R<t%<<5;; <<VVrPi90r0+09&_yY9V9 [ Zb\Y 3oYr@tm   
 
 ,0 
 93o?p\qlmQc:Wo`V0VSV0u0-g09(k\
m n4atdvEbCr95~ˀ_z|]V90 ?W`*
t9 Z9+uqm e9p2ad%Z9V0 \oj9CWYylӒcӒ0Ucߒ=YWifp[\H×s;q ipcc×"ė`c6xgpJp `F0 `)k" ) ) 6 6u"xg z}Zr "1x{5MNOp#D Ee1``}GX#0
T1d`*"1#2`pQ{z}yZ1zxz?d 0#
0 *`0`-0$`+$`W$`6$`$`& [$pYTY ԀQFQ>Q0Txv)Q!R̀Dx000a R 0a_P-PE`# c	PF,¯:z`ү"Q TPF`xe  U(05xv
xD}D_,0{ ^`
}^T?D=_e	Ӫs	ln`@ TPB34#3$``$p"t1e4`tg4⺑g1Y§ᨀ`&0.%0*Td`x0dp&   xF TTÔP
xG@0_xFtPemѽw xB_CWBsmѽw xN_ONlmw xJ_KJ В"789t/F"!:(x ү7%$&t:t:8230(0 (xv@3x`vT"` 9x"ү878 0( 87 p0 xv33xV53}.* @4  %4`.40""55Ô@@	p@/@؈ssd`
-~~/MTO/]S@mS}XS6Я12s0``/`@$pN$21:Y &DY X U ҿ)AP [x@03oppG,8>p1 ?'AP@ {"PT@~ o-93U ?TP;d`pxH @2

4E
E
@dq;"-.Oam@`2-x00 <. 	@
pޑ0
T DT00q	 0A q}Ct
}u//퟿tl@P-0 r.ldpe`0-ADxwFG0"U@#@"" #"xu00&0u0/1}S tp../0$..}@0 $0/#-Z)1- })*
#.2.˰/@"^/4 4*x0)a:E)4b+,@4g)1::!	77	89ph;a)
2OA?@B55 
x(0	(c 1C*;((@@@?v@{	E`ސ~4P0 ϐ&T``A_`8Ю<@:p5S D?& % 50"
op;S s224.QTF  50: 22Mp	S08"B0T M>%%O@S2vЏ-!	N-H?<W=2+A:9Q-|`R`N6Ǒ6`Xp0R06+cP\O0*-`Y-C-c-FeP`	-0P.o[|TR%\de-N. ! EP6$/u.
/ku.!s.ހW9W,J:::
O,-5oo P2- 90&PPгq	wTн -	q	 Ȁ@ɀQt2080uQpo	)Oa*+pF}}}0
a,/+y*t%)&$	1H&SHS;"g+`NAp8
BŐ} BT|1&0=?J'>H`$ < OT0?Ooyw45e+pY}BxaTJ %"
č#\p0 >@54Sm?Tw:y5rBB{{	 U@e1r1QH`{o0f}
AE977RdE؛ PG6$$P3s%Bf}KV嵐{籐HQE\ё}z  X@FpRFpLxpGtp?2K12K#2K2K
TU`6 |TBx{}A{xzGxyExxFxwBxv<xuxfxtx\xsxr}xqxxp{xpx|PAx{PGxzPExyPFxxxwP<xvxfxuxtPxsP}xrxxqxxp"6y0xev0p`Txam;BB" /:e0/Txa0#arbpNm /^S****1Xs	 ~93GF")u,?.`-T*/.tf00) 0'H0|4+ 's	X	)x IP,+>%)tQQO*+ǗpG8ґT+̭+U(@>%t-p=0|/y0h&P5-/ǉ\?u }k}Dl)htёi[4rNHg00|93HfpP
gޑ "u*`w09"bu P})tqm0|?_l) b	 M+0QPRPO+pM&u0D@[TۓtǀHppp;kDےS)T)u+B+tE 20o&Hu+Tqm8pB+2Y%TO]3 7`	  B``֐@"d"$@@Ӕ@6   x0PQ  x_<_ I`	q7"xv7׫o0I @rt`>(PB"C^ : Q:opTQL%QM30.vT`spt@'}?}S?P Y33TB DD xe3"ﮠtpxV?xFl t@tTwQvµ
x QMnRJ*"P#[a0u0COaAAGE7X>3tf+`
PP *J'' '+fz` 1:P`	a'z!j"IߋJ>
UTiNJ{
EI-@YMn:C٠CwCYpo0:-zuU10[U10b:q1H,2;1i`4-D0-dr0["-UOa@"CD/S(az!D_dp }<VPt=tqR?! oRDHEP=`EDxhvCDB"xF@xGAxEBxFt@0( AT.`xAA0xBмFt"("DAEF0FBC"xB*ACCCACB?DYEB*FGLGN*ACOCMCN_IYEUNKK9LGJACKCICJNYEJKK9LG:EF?;GHd`NJDT&`W sA0uFplF@[
HGt3}\q0hCFEB}^}e}s}lEAMI AB++I`Ô@"OxD Tv{OGĀ@cF~$0,Z@cAr#}@Tsp#}C0?PGGGGG~GhGVGDG>G8G2G,GFFFF  GI>go##i" 0` ]kqAt"#x]OmbnnPnkq"I^pDArmr@`ABVs,qnPC@]kkqnqbxq p=wQC#Q$`R!H|$HPӔ@zPqOAP0	xhZÀӒ}|ABrP`#`5?`2$pChkpxAlDurc ۄzx\PPT@?gxg#mqpz7qp@Yq
xdp GÔ@π<`T`xdJpӔ@d`xbrsTs t{ dxi vu\v+xgv2@`#t "4}t tP)}=r 	+"ÔP@ӔPq $$P`	ӛYCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATamrb@cJey{f}~!L9]$q/L10P`Pd`uPrgKK$K0K;KeKqKKKKKKKKKLjL2"=DŰ~0?԰C`qv@pl"lM#кԶ ǰװ@7kG~kװ aְT߶L7s.g9 xbwl!lh a~`g@P~1{OD=td
`#`(`<` dP`d`PȐPB0=vCqPP}ttdrvxtxxXx\t lxat"xbtRNxJxFxBxtx(tb}P#Dxxtxtxxtxx#x> x=tQӿx@t 0xTВu"x3ttfxx!TToTaD	zxT Tx=Tx"  TK=Dp"Dsxev0}<t F{B{G{E{A}DA"x0xP"xbS&" S?`/@?@>"ޱ=$t>A&$-"TÔ
P~0~7%PPOO"7%OO{ z yOaN N+N3N4N6O7O
8O9O#:O.;O3<  O8bOY$QaIaAa9Pa1~5N`O&8;uOuOK`O@`($`*`-|/apu4
TbB`<awBFEGAO$`$`!`0`?$apAa :w32"}*r0  w)0!",3`G`[P]Opa_"OdpFb$  `qDawT 0 OP[CP"L}$pMbPS%Ld`ǀLxbLÔ PLNON	@P
q		Pxbvb
@QOQOQOQOQ\QwQQQQQ۪QQQRRR^RcRhRmRrRwR|RRRRRRRRRS  S%0
v"x{5MNO`uM@\MMx`}ZxzY "+"0M
MA}$pf"} N}U a"uNP0SNNTN0CN2P!d0P! 0P!@$ 3xw\bvAUAAAAA`<xTxeD0xb (x;x `n`}K}If$	A
Ap "3`N}xO| } ~ Pe4-.LbU'MM U'SH((sSSTTTTTTSSSSTETKTXTTTTUp	F0`Ô`P	LOA"T?s8} 3
0xt"LNLaJ0;;V	bp50;TpAuL<;>>1?`P@0b P :9`Nm"p	Jr7$p9AA0Lp."xzd_PDA"{oz}yZp8z"p	OMc ir79!HeIIeQ0M}d`USI`SI!!`L ^``OLpT0 ˄̲ҊAlU0#b0xD @Tqx c!S?TxxcvҀqմTS@BYbDAZbZ@<xDX.u0/}.*0.T ^00//PE@"U]^.Ga"ڣ`^} ^",0Vd-_,Ô,dpCSV6@a93-"
q3xpo0 "3uoxg`@ۂՎ./01,@RDt?/t .x} Zx?DT?/.1R0U1B; v\xpԲ x !Dб!xDR"q p :q@s6xpYobYs2YWt"3WWWXcvYoYYYY6x
,-kx
tu,P
-,_x
szzx
yjxl{Vx
y #qu6{0"t "T $Qxm	}I{BxlxlßP2V0{ y% $I{$ÞPxxl{Iu'!t I{bb)*u`+yTүs$`&p<V}e  qUI>x+*)t6{$xxmӔO@vl hxlvylßxmP!  l߀0 	6
xTUxv 6dx`r<
0ޡ{ᔀP`xPlxx
x{xx	06Y)bP$~^|0 f}060:Z ZZ(Z2Z9ZEZZ	["
  [g'LDcĀ3D@c"xgD@BO@$P``G3@ p0TO2P02P  -Dm0"".@!TA"~&`/걥@ U,P@eT^Opsplb33TO1p0RPò R6
0`p}T˄`- .*))~Pr;S)зS)x`vS)ж)"(),0.\\ߌx	`}FN t\u- u./0SS0S0u/ u1/U-n.Np.%.-3-111PEPS2xp]x	1.-kA^_p  6  .sĢ6 +22􀐿M.?@x  _=6-ýP ʀ--_Ӕ@p0.`@]7]F]Z]]^
^-^H^c^s^^^^^^$^%_&_+_,_*-  _/.`3_/xu,ӐF./x0."ӣ ցat0ձx*+!yP
+*{
Gx٢`at?e+pt Se*l	lڂm`
pxvEvmxӅ`䠘xp`:0հؐ};}#zt¶N0ӐHrOtb.`Wv@A}o}UAtAuA]vApL}3A 3'0&(@abPeкP)ۅ( bct`g0
________	_____````?``3`  {``UCCCCA
tt)"/{RC	JC
C@҅-T@CPLxaT0{BL9)0"|
"L:L @L'N MWPOxI!p`2Zx[`!a0G{t(OD#4	2 x{Pas`iD:
0« D AM*"pq`Dp:2}x#201bD"00(1$`$`$Ap`aH"_ߣ	%$%ђc=ze1p;A&d	`
`DDxh1jzg"
"xpaTp opa@a"΀ `P "$``#`$`%$p#F0 c
=#"x%txm.d~%m"&I}t~0	
!}h""X@rxqTTr
* `+l!D`T!T\Ñ.P<*
`+"  =>C	D

~x`!ÔP2^`_f"
% osF`7i0x(5(eJxi6d(37(@S(a3`C00+xT 6r} 2p. D:T_`*  ATT900	ҩ6+@5Q>qd`xSp60cx`7($```9`B$d_xv (zBq DxT2?ҎxStTT4DHc9(xS(<x)`76)$``$p#(P8xSxB(B	x606008=A>0ch2A<"*+*Ô@*ӔPM@
aM{P o*$H$cp!00-C+(}+ÖQVH+*f?PMC++ MSMteM`uCT[@N@oPO~B`J`N`R$dpT++AC"+W4`Xdp0!q`X0ӀÒ0ט+Q[+Q"*+k"`=0D"xB0*"
]	1}i`$3mp`0<0õ}ୱ@b,/0fggPgVg_ghgqgqggggggݕgݖggh!hhhßhàhhiiiߥiߦjjj#j#jEjEjgjgjjjjjjkkk+k+k1k1kSkSkukukkkkkk  k~'1rkkC/ onT3/C/00u5$ł 0` R/p ou/o}/tutst,}At"qłfuE6vvsu6v)xu6v{u6v}o P GRPp"qqL"qɅqӝӔ Tqoŀ~ At`| }@@^_Tqou6vſ
u6v߉#t~Ӕ  Psi\Ôd@n| `z {p@\]L`S~-.YAt)x~ÕP{.u_.-w6v)u6vu6v忝u6vߟu6vt@# _x֎-PBМQau!o{dz Jw6vubu6v_uR6v߲u6v`,$/0u6vՄq/q{5q/9p0!М6vAsÔ@u/,w/!y`A`H S 3P b\P`uP;<~#`j0ol$m3'`T}с$<`!!xmPI
J
ހKxjB==xmP=7U440#70"'~"<|ɀ'"$<vBO+@ŀ
UJ
K
Lqʂ=xm ǟ4Ɂ"8o9:`38T Aqq
d@Y08l,}}Ep& 8| $ >89:PԤ0'`圡d±Z"8}כ~%}qo݂AޡmՂ_'ɀ#21}'}p``$TTopקt
zb

(H?sN((&@~%2iݰ@v1$lg@#9pp t.q 
41pnnbn"14Po=Ku\Ҡq }p
T?T`4"4}"bu0<.r.`~r~s^rTp^+qTO..O/p3p* &0z`ѿ
nb.ߠ1 PC18o 1oP@hrB1qqp08y3@׸`&br@p`@t1"x`0Tw`2T_2O
P.e72ܳoqnoƏ`;e.`.b v7	re.@qn.o/qp/ppR/0} } ~"7Mݐ	DCps@T3```5"2p2`r 2`.p~"rKu.</u.$q }r}]s`|3wӝꠅ/0zu. Z/*u܅qr'SSu0q pap.ρPTTT%%n!pԑ $`r0
`r	w.d(.`/ӟ@0S}	nx B. b0Yx70w0,@.0& /Op`/`^rېPQ/p`^O"!Sk 6,>6%t@ऴ4 6ŉ6Ūp4v =}6p`SŲ@6XBXB>6etx4>6E6uq4t}5}{z?y>@ufbM04iM M$5vkPUMf>`-tc|0~@_
QAt"5"¯05Q;5p`
ݼ!t 	ÔP0/Eүίqد`ȡ>n`p|r|\`à234m5Á}M}4171|v((svw wAw\wwx/yyGyhyzFzz{6{{{|
|.|O|pSJ{/	m>cnWc !\}Gn1lkulpu2`u3 { z y2*ras2T`pd`dnpk*ry{s03GWcɔe3pe2`({IS0o03p@1326kŪ03x
lyfcٍE|Qu`  @FMdP;|q$K00~13E2pUzS7[H0$46k405x{sǄU6kk{xrs6U6R9r`z {TЗ@\]Lpb)6777666k;6p7t
ϗ:^=A!dLp=k*r7u?B!դk)Ʋp_pNk_ɫ{A=oVPkWB( :?~J"k*r6kk)Ϻ1k<߼1k=1k>1k?Ã5D*GMk /!5DA^vDlIM09,0^<T~6k|F@ 7v'k1"0k}1o+q τl2au{1 (#1$`=`l~c$@# u1*!uxo0X7`xd dEB|tu0|`.Ô(`Y02TT Np\ q 2` @M*aÔ`@qo@q fu1tpu07 4(17a/Dz}` O?uX` /A^L`n*}3/eEj2n Ht1+6PUgX?`/p!X0)}D02"<(_L0̯.3!_ހI%[` k~ X}~090p0.O//.QP* 0"#%A$3/ptP}a" 2s _}p_;
_"4Ct`#o$j23D2x 0 ``Ð}P 2_x0 @2xD)	V"LION 1`TDx"qÀ"0tpΓr"8bP3px"/`qq8  18!ӀÒ88
"bB!2S#"x& 3%T~TO &&"x!To`	p+p3@xD T"	߿F	1*>	@*2*x*pz+S+d"*X-*LҀƀԀi3ꀚڀʀ3-䓣łŃ1
-`1 *"113*̈$ P37##EN``#s-"P""4䫓"9:P:"  )"/33@ >" }S=3@0"Ø>"(Ap_8;
- :	P:	{:t;):eC	%P:
F"*70E;CP^C	!D	_"EIFBG"""BBE"`O3=P@=P"""ЃЂ䧓`ETTtsqTVs`1ŃŃ4W"%p85@bTp`Ep
~`Es@Uh`B*pT*p\*p\~+p\vA,p\n,p\b-p\VE.p\J/eʠ/1/11cpr2p3c66p7Ħ7~A8#%s j km/nOoopqrs tv/wOxoyz{| }/Ooυ /Ooώ /Ooϗ /OoϠ /Ooϩ /Ooϲ /Ooϻ /Oo¯ /Ooʏ˯ /Ooӏԯ /Oo܏ݯ /Oo /Oo /Oo /Oo  /Oo	
 
/Oo /Oo !/"O#o$%&' (*/+O,o-./0 13/4O5o6789 :</=O>o?@AB CE/FOGoHIJK LN/OOPoQRST UW/XOYoZ[\] ^`/aObocdef gi/jOkolmno pr/sOtouvwx y{/|O}o~ρ /Ooϊ /Ooϓ /OoϜ /Ooϥ /OoϮ /OoϷ /Oo /OoƏǯ /OoϏЯ /Oo؏ٯ /Oo /Oo /Oo /Oo  /Oo 	/O
o /Oo /Oo !"# $&/'O(o)*+, -//0O1o2345 68/9O:o;<=> ?A/BOCoDEFG HJ/KOLoMNOP QS/TOUoVWXY Z\/]O^o_`ab ce/fOgohijk ln/oOpoqrst uw/xOyoz{|} ~/Ooφ /OoϏ /OoϘ /Ooϡ /OoϪ /Ooϳ /Ooϼ /Ooï /Ooˏ̯ /Ooԏկ /Ooݏޯ /Oo /Oo /Oo /O o /O	o

 /Oo /Oo  "/#O$o%&'( )+/,O-o./01 24/5O6o789: ;=/>O?o@ABC DF/GOHoIJKL MO/POQoRSTU VX/YOZo[\]^ _a/bOcodefg hj/kOlomnop qs/tOuovwxy z|/}O~oς /Ooϋ /Ooϔ /Ooϝ /OoϦ /Ooϯ /Ooϸ /Oo /OoǏȯ /OoЏѯ /Ooُگ /Oo /Oo /Oo /Oo  /Oo	 
/
Oo /Oo /O o!"#$ %'/(O)o*+,- .0/1O2o3456 79/:O;o<=>? @B/CODoEFGH IK/LOMoNOPQ RT/UOVoWXYZ []/^O_o`abc df/gOhoijkl mo/pOqorstu vx/yOzo{|}~ /Ooχ /Ooϐ /Ooϙ /OoϢ /Ooϫ /Ooϴ /OoϽ /OoÏį /Oȍͯ /OoՏ֯ /Ooޏ߯ /Oo /Oo /Oo / Oo /	O
o
 /Oo /Oo  !#/$O%o&'() *,/-O.o/012 35/6O7o89:; <>/?O@oABCD EG/HOIoJKLM NP/QORoSTUV WY/ZO[o\]^_ `b/cOdoefgh ik/lOmonopq rt/uOvowxyz {}/~Ooσ /Ooό /Ooϕ /OoϞ /Ooϧ /Ooϰ /OoϹ /Oo /Ooȏɯ /Ooяү /Ooڏۯ /Oo /Oo /Oo /Oo  /Oo	
 
/Oo /Oo / O!o"#$% &(/)O*o+,-. /1/2O3o4567 8:/;O<o=>?@ AC/DOEoFGHI JL/MONoOPQR SU/VOWoXYZ[ \^/_O`oabcd eg/hOiojklm np/qOrostuv wy/zO{o|}~ /Ooψ /Ooϑ /OoϚ /Ooϣ /OoϬ /Ooϵ /OoϾ /Ooďů /Oo͏ί /Oo֏ׯ /Ooߏ /Oo /Oo /Oo  /Oo 	/
Oo
 /Oo /Oo ! "$/%O&o'()* +-/.O/o0123 46/7O8o9:;< =?/@OAoBCDE FH/IOJoKLMN OQ/ROSoTUVW XZ/[O\o]^_` ac/dOeofghi jl/mOnoopqr su/vOwoxyz{ |~/Ooτ /Ooύ /Ooϖ /Ooϟ /OoϨ /Ooϱ /OoϺ /Oo /Ooɏʯ /Ooҏӯ /Ooۏܯ /Oo /Oo /Oo /F     
     U$   4 G  N U  fWfVfSێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.15 Copyright 2003, Infineon TechnologiesQfSfRgf.g.3g.

Ƈ}~ǇvJ gf   uq u QfP< fXfZYQP

{At2[RS l eg{q "  诟3[Za@
  
a 
5
; a[g.Qt|P@f
 DF<d~ug{$u	N"##:o3ff@~1QfW
Pf6ffffg0f3ɹ 
Q +r&u3gb&Rfgݎf(g3fGf_ \-"& gf4$ +Iffgސ0fG(. J&>/(0 1	.1g/	2fGg&q/g_f6f6s47f76_Jrr&v:7Z$8x8g6{47S6<|.=}.=~'=0  f_fYڠZ@!3RQ`[DaDD3YZRfQSDڃ <u-Hu!HuH u3
߹  4 pgx@FDMDwTEPE 4 t L3 s d 0SPPJuOD0Et  ED&NbAE'CWUDpDEqDFh
Tt2@]Cf[1^PQP fa nd) f t|gf> tub~ {tm1c te1c t]ff 8N 8^ 86
f;s"u
 '^QΒh1 
@K [W)Da(g Bq^ 
_3ҷar& ~A *u
r& ur& ЃuBwog,1-[0g#sf8魾uqq@ L	uqWwS/uF"0~ouS p2zIƀtB 8t$2 8D$e{ff+f+Ȥ{92z3{pu~` SY^@QQ{ 8wL$ 8	25
|0 Y Bl_3 zǐo 7muj ),,Q tLW)ff3fsf%ffK8s{`fClQR*gً1-*
tffpUf;sg^,g,WZB%V)&6Gr *fss2tQtÓ1 vfV*ʻ *쓫ʚ<ڛ ־Ƈ,d +GĚRP_EQ! [@FPQ `~!fRS2 Q@\ nZ"AA 0BÀP;P s
E 0 Cr
 xRO_f3g#~|ǃrtfwQWf9ˉAP bA 1^S*pQ$"PrPrt Dtt%53A. )0 tн t1@t`5t
I o:ɚ̙&!'g%aa fQVPmQ\0l0"AA|!26Ps؀P"rc2ېl ɹ@b&'"ff+f}HlhUOBB`%Q%`
Go!tO"BY&Ѭ1OsѬ1Or
q"tfu`3yȀUq a 7pTPsIu3PBHa8 XHPS! 6#a P [Xp$
pqSq[ 
 tKCX 裝P0#"3`   = 肦r2#fr
fff#@k%  t	f!bf#fk%tbx 9$yz 4Fidk  4Buf0b!b/Oo	UX(l              @ ` d$ UNDI  N MdPCIR$    I PCIRE      X b   $    $PnP       o          
Broadcom NetXtreme Ethernet Boot Agent v6.2.11 
Copyright (C) 2000-2003 Broadcom Corporation 
Copyright (C) 1997-2000 Intel Corporation 
All rights reserved.
 Broadcom UNDI PXE-2.1 (build 082) v6.2.11 
Remote Program Loader v6.2.11 MBA v6.2.11  Slot 0000 Broadcom Corporation Press Ctrl-S to Enter Configuration Menu ...
                            
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 t`h+  dMd            h+ VP@ ء .;uXuX.6>| .6^SQW  @ _Y[QSH .> t".>u.uXH S2.{r*= eu 4= fu  *= gu0  .9u
 @ ؊>l :>l tIu[Y[Y.> t.>u0 .>u  ø UWSR..>f&=$PnPu#&uFPj`hf&u
˃ u0   S3=_Su}M_u22]r< t[Cu[V[}#|OfSf]S_fSf[2= t#It2E= u= tGG= uG؀}|E$t0  Z[_].>u-fh  fPh hOh"ph%th mh fh_SQfRWV.>f.> t.@   ځ>  Utt r rf.>  h1
PH ?X%
PXE-EC1: Base-code ROM ID structure was not found.   r댊  t	|Sfj j H< tk>  t;sf=$BC$uErPj Wj < t뛌ێf.> t.@   f&=$BC$ h  .6.6.6.6.6j Ph#&u
˃Z t'hDRHPH +X
BC_Loader() ==   r tho%PXE-M0F: Exiting Broadcom PXE ROM.
 P6 X^_fZY[.>ufXff., f.. ff.0 f.>tf.ff.ff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZff., @ 6& ԋffPfSfWfUj j fj fj RV@ & .6E.6E.6E.6E.6E
f., ff.>t(Vf.ffЉVf.ff6Uf.. ff6UW0f6UfVf6UfVZ k	 t	 t	 t
 WPO
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>. uX.> u
h
If.f.fӎF.3.f.F.3 .> u5h
i
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sDh,P?
PXE-E20: BIOS extended memory copy error.  AH ==  .f.f^f. rvf&D    fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(DvF&DF&D&DPj Vj &(D	.6E.6E.6E.6E.6E
Wj v&\Z
 .> f3fp  
Wh v&\6 u96} t2  ءL ` N b 6E6E6]
6U6uf6]fSf6]fRfPfp  f	fXfZ  YWjuv&\Z  t$  8Wjvv&\Z  t  uj@ H F F  RWjv&\Z  tvXt
 u tfS^G HF +F )F[fSVWF   6Sfff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 .>u%fp  %f tfP  ءL ` N b .> u0	= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]k3e3_3..fP. tfX. tf3ffFfUfSQfRW^  G33.. G3.0 . ua^_f..^G3.>0  u	^ af.^f.f^G.3 .. 1f.^%^f_f. s
^  .>0  u	^ f.^f.f^f_f. s	^  ^G  f&<!PXEt.;60 r^ &DXrPj Vj 6< u^wG&D&D&D  &L
f., &D&&D ff&D"fG&D(ff&D*fG&D0&D8ff&D2f&D:.&DX&DPj Vj &(D^G  f&<PXENt.;60 r^ V&D,rPj Vj {< u^wG&D&D*., &D&TG&D G&D$&DPj Vj =&(D	  ^? t _fZYf[]f   fZfP.>t.> tfX2fX.>t
.> tfRfPfWfSfQhf   .f8h  f  ` 9fh  !ff   fh  fHh  f    fh   f..>t7.> t/fp  f   uf ff#f H ffp  . uC f   ff
f t!fff uffff.	Itff   .>u f   tf   fff ff   f.ff   f.ff    t.0ff   f.ff  0 f.ff   f.ff  @ f.fffp  ffffp  fYf[f_fXfZfRSfPfp  pf   t/f   t'fXfffff	ffffX[fZfPfRf h  &ff    f h  ".> t#fh  fff   fh  fZfXfPfRf h  fff h  .> tfh  ff   fh  fZfXS rR[fPffp  fZf fp  }f p  f  nf   f p  Mf   t_ [fRSfV sfHf fp  &f p  f  f   7f p   f   tV fp   f[fZfPfRfQf p  f    f'  f p   f   ufd   fIuf3fYfZfXfPfRf p  f     fZfXfRf  `ff8h  x f   f8h  W f   @tf<h  F fZfPf<h  G f  `BfXff8h  3 f   Sf8h   f   @tf'  9fSxf[fSxff[fS|f[fS|ff[óhf   f.f.> .>  V  fp  f   tf   t fR t#fffff	ffff fp  If   uf  f p  /f   Of p  f   tfp  ff&fZfItP^f`f&fIufPfRShf     fP fPf @  f   f3fP  .>t.> tfh  f  .>uhf   U tf  @ J @ ۊl :l tfX2 fX+ [fZfXÜfRf3.ff
   úfffZÜfRfPf3.ff
   úffXffZSQ@ ۋȊl 8tY[fRfQffh  ffh  f;tfIufYfZr.>  uPH X3. .P #. . .P 	Pfj j .( SXf%  fZfYf[fX t]fBroadcom NetXtreme Ethernet Boot Agent v6.2.11
Copyright (C) 2000-2003 Broadcom Corporation
All rights reserved.  MBA Configuration Menu  
       <Esc>    <Ctrl-F6>       <Left/Right>      <Up/Down>       <F4>
        Quit    Blink LEDs     Change Value      Change Field     Save This option is not selectable                                                                                                                                                    Boot Protocol  Preboot Execution Environment (PXE)   Remote Program Load (RPL)             Bootstrap Protocol (BOOTP)           >Select Boot Protocol     dj  Boot Strap Type  Auto Detect   BBS           Int 18h       Int 19h      Select Boot Strap Type x      Hide Setup Prompt  Disable   Enable   $Configure whether Setup Prompt is displayed during ROM initialization     .2  Setup Key Stroke  Ctrl-S   Ctrl-B  Configure key strokes to invoke this configuration menu x      Banner Message Timeout  1 Second     2 Seconds    3 Seconds    4 Seconds    5 Seconds    6 Seconds    7 Seconds    8 Seconds    9 Seconds    10 Seconds   11 Seconds   12 Seconds   13 Seconds   14 Seconds   None        *7DQ^kxSelect Timeout Value      Link Speed  AutoNeg         10Mbps Half     10Mbps Full     100Mbps Half    100Mbps Full    1000Mbps Full  "2BRb"rConfigure Link Speed       Pre-boot Wake On LAN  Disable   Enable   Configure Pre-Boot Wake On LAN       fRWf3ҊC fRf3ff   tf5 f fZfOuIu_fZfRQWf.fRf.    ft   # XfZf._YfZWfRfSfP>uf   tTX>T u
fUPf]TfU`f]dfff   t
 ff<ff0ffuW f t E,=
u ff%   f.  t ff%  0 fff%   ff uf   fHff%   fff%    f
E2=u
fXf[fZ_WSQfPfRXf @  f   fp  f%ffffffp  >T ufEPfE`ff%>
 tfffffffffBfffffff
f>Wu
> t ffffȀ>T ufEPf   
fE`f   f:X fYfff   fZfXY[_Uq 3KtRMtpPtHt.ct>  U =Uq} Us }Uqh 륃} t=} u7} uEEHEE 낃} t} uE@;Ev3E& b.2UUquUCRVUmUPUXUuUum
>n ]^ZQP>=;>uXYWQU>R=m uUZƋ=;>u]Y_PRR ZZXQR	 ZR { ZR m ZR [ ZYQR 2f ZYQR 2O ZYQR 2xZYQR 2_ZYSQ  Y[P< tFXô
PSQU  U>V]Y[XUP3>F 
tEAX]PQS >R &S P[YXø PS U>V[XRU  
U>VP ]Z(*q3ɺO f`P  .  : P ͊>V"UPU1.XU bP ͊>VL7RZRZ0N>S[P3fafPfSfQ ۻ  f?_SM_ts OvQj Sj < tAQj Sj < tЀwrgrafGf tWO  Q f Yuf=   wPfXf,g8 tIt#gfXfg8 tf@fg@tgef&=$PnPuW32&C&:]u
uBf&}
 t7j &uSj`&]
[uj &uSje&]
[3tfYf[fXfPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j S< uf>  tf fPfQfRfWf     t;h&rf_fZfYfX
PXE-E07:  PCI BIOS calls not supported. .  	 uM.;D u. 	 u4 toh,'
PXE-E01: Unsupported PCI Devices! h`'ڊP]
PXE-E04: Error reading PCI configuration space. f3ffDEFGHS]m
T^Bus =   Device =   Func =  QW '_YfRfPfSsf  Gff  f_   D	 Mf   f  /	 8{rf  ff[fXfZSfPh'.Ph'.Ph'.PfX[f3S.z .0..0..0..0..>t.B@ ۋ .[j  wPЃ Xu
U |U....>.VfTSAFu u
...>t'h h h.> uhfSfQfR. . .2 <t@h)PH X
PXE-E06: Option ROM requires DDIM support. f    .  f    f.f  fRjfjf. ffPj h2*fQ˃ffu0hR*fZf    x
Invalid PMM function number. f u&h*fZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.f.> tf."ك0t=t	 t  ` b   fd f.d f    .$ Pj h  j .(% . tf.>   r. K         UU *
 V4 *
 33 x ZZ j*
  Z*
 3 .                                   `  p ,  (                  
   
    < @7! <  &      
   '< $   4       <$ $ $!8                '' <  h`hb B4hb @cP$ <p"x$ <" c4 @cQ  !  <" B0 $ C     <pBD  
 P <pB P4Db8DcDd <x" <# <t$    ' <  U<Uc4<     C $U<Uc4     CP $ <  G ! '	 !(  hchbC     $* @      'PDc <xB +C  @ < <PDb + @ <DDcDDb$C @    HDb B00 B$ B, @ @<  
$%  8\d0\b B0@!       PDb <tc  
B0PDbB0+C @         '!(  <$!0  !8         
        '             < 0B4 < 0c4 <74 <"@ $ <" <   ` c$+ @P  `     !H   <B <  C$+D  <# @!@   <  <B <c  $@ !C !H  %  D )@ )% <B <chd@ !C  D E F G J  K        '( $    k   <B @          <" <B @ks< <pc
 
 B4 <pc b $ <1& 2&- hp 2 @  2P       2 @           " @    a  $
 @P   " B$ "
 B, @     <pB  @hs
       >       B" @    b B0 @ $B  C     B @          B B0 @ks< <pcM 
 B4 <pc b <Ɛ <$!(  !8      (Ps 
    ( $      0 '     hbh 
 hb  B8  B0' < B4< c4 b<bc $b\c ]c <  < h b <  <  < $   <$ C 0 B, @ $ <" <$    b8 B, c,%C  @ $ <" <p   $0 B0 C $ <" b$$C  B4 b  <"ks< hb B4hb\b B4\bDb <c B$ <"\$d <B   <$   <ƌ <$  !(      '' !  !   -     h\qhbd &+C 	 @     @hphb  B0 @         `\b B0@           '    B0@          $ <|#    B0 @     <|     B0 @     <|  <|B@         '  PDc <xB 
 -     PDc <B +C @ <DDcDDb$C  @     <-     DDb$P @    HDbB0    ' <B @    Lb	 @ $ b$$$C  b Le9 
Ld      <c $ b     b B0 @     <pB  @ $hbL 
         ' <$$       lXb b    PDb <cB0+C v @    \b \b  4\b \d'  @$ <B B$ < 
" <B B$ <"\b \d 4 \b  $  b$ B0   <B @ 
 !C  $!   ! @  0 @ & D $ " 0 @T @4@ 0 @T $ 0 @T c4 0 @T c4 0 @T c4 0 @T c4 0 @T  c4 0 @T@ c4  0 @T c4 @0 @T c4b0 @T 4 0 @ 0 B 4 " 0 @     B  4 " # & B
 "  "   "  <B    %b    $ , $  B $  $      ( '            ' <c$    b < B$  b]b4 ]d'$(E   @<%(E    22
 T<b8<c!(@  <  <<bA 4 $  $    $    b!  !(   B4   b    '     <B'0 !  4 !  (  $8 !  < , $     T b B0 @    b B0 @ $b 
 $ <B B0 @<c4 b8< 4$C  b $bdb B0 
+ qD` <B B$ B,
 @     b $c B0 B,# $ <$b q8<p <Ɛ R6 <s&  g! `  !(   2 2 <0B4%b b8<$$C  b b 42 $ B4 bd  e! ` $!0 8< 4r  
 s @P!  b B0* @! ` <B   B$ <"g
 $  !0 <B B(
 @8< b$$C  b b B4 b 
!   B4 $d  br!  b B0 @    d  
 $ & N*@    u <1&!    g $  !0 2 @    b B05 @!  hb B4hb\b $!   B4\b  g $  !0 <  
!        <<0B4%b <1&  " B( @!  8< B4( $d  bp 2 @        $ <$  g $!0  !   $ $d  qb B0 @ &*@ $b <$ $  g 3  !0 ! < 8 4 0 , ( $      @ ' <B' $P L H D @ <   C8       
 B0b B0	 @     b$ <%C d   b 
!   <B B0 @     b<c4$C  b $bb B0 
+ d   $ 
 $  '!   <<$ s64B4$  q 16( $%5D`d   bh`    '!@  C: c,&S B,%b  `    hb B0+@      R &b B0 @     & .@T 16  ' $ B $$  <$C 
 C $(  <$C  @ $hb B4hb\b B4\b $b $ B!  d  d $q "2@ &.@ $ 
 "2q "2 B8 B,! @  "2 @ 0 b!    <%C  b 0 @ $ $b $b! P L H D @ < 8  X ' Db b <%C   b b<c4$C   bb B0 @!  Hb $   !` ! ( $  `B$@ c$  B4 c4   !p   	 @'     
   b B0 @!  Hb $   b0 @ $    b     å
  
   B$ ¥B0 B, @ $
 ¡   ¥  @ B0 @ $ 
 ¡  
  ¡  
        Õ ¥ b,N@!x    <!" " @       B0 @ $   ¥ < čc4$C  ­  $ 0$C 
   ­ $   
   a 
  ¥ $a 
  ¥   Í  ¥$$b   íD` b $ <%C  b $  ¥  Õ#C qB,@T $ $a 
  ¥a 
 $
<J5  ȍ $$$@   B0%@ Í$8 @  @c0%8 $H   B0%H" $$0&  B0%0  $$( @  B0%(  $$     B0%   $$  B0 %b    ȭ ǭ ɭ ƭ ŭ ĭ í Õ$J   ­Dc b <%C  b $a 
  ¥
 Ñ $ b!  @ $a 
  ¥ @ B4 ­ Db b <%C  b $  ¥  $
 C$  Õ$D $d  C $	 $a 
  ¥
  C!  @!L 
 $ č<$  @< ̍<c4
<J5	<)5<5<4<4
<5<4
 $  ¥  ˕$`B  c0 %`$P  B0@  Í%PB$HI ĕ    %H#$@( 0% %@$8  B0  Í%8 $0  č  B  c0 %0 $h %  0 $ %h$(E   B8 B0 %(  $$  B  @B0%    $ ̭ ʭ ˥ ɭ ȭ ǭ$ ƭ ͭ  ŭ$   ĭ   B0%b  c4a 
  í
 Ñ $ b     , @ $  Õ#C qB,< @!  B0
 @ < $C 
 @ $  B0. @T<    B0* @T< $a 
  ¥ < ¥ bc4 $$C  b $a 
  ¥
 Ñ $ b      @ $a 
  ¥  Õ#C qB, @!
 $a 
  ¥  $ <%C  @<%C a 
 ­<5!  '    d_wfv_vr11.1  0.rDwfrevi        atafrrEl        ebifknLr    rdwfinIv            a_whgotu        ` x   8 @ @ d   h   \  |                                                            DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:  Download failed

 
Searching for RPL Server ...  Abort

 BCM570X Found

 RPL SERVER NODE ADDR: 

Transferring data from RPL server ...   Done

  Transfering Control to program @  :   /-\|               tttttWS ˌt&  ˍ$        !PXEX8             {                       M      d      d                              PXENV+,$                        M@ d@                 fUfSfQfRfWfVfPF= twO. ~
&ێӼ h@ WPJ
&  fXf^f_fZfYf[f].>  u
~
&` . h@ fv
Phv.6 j ˃
fUffSfQfRfWfVfP. g]g} twer`f&؎м fUh@ WS
f]f&g}& tu   fXf^f_fZfYf[f]fg}&` ڃ> tj USf. ff f3ff   f. 3h f&f. ff& []  Ã>tj j ff9h uf. fh     Ý   V@ g&5   +g&5   ^Ã> t&j f. ff f3ff   f. S3h f&f. ff&[&   Ã>t&j fPj ff9h uf. fh fX&    ÝfX&   Ü=PVu NVf. Uf ]ϝ.6 .6 . . SR[.9 u r   Z[UVSvf&ff&GfD[^]f`. > t;su .$%t а r   fa.>  t-. .>$t!  r ӄt"Qf.>  u8Pwh3Ɏظ&. &G. [i Y3YÜSQ3ێËȋf.>  tFwhff&9tY[ f. f&H f.     3PQRv ! ˃ӈ  "X tZYXPQRv ! ˃"  
X tZYXS. &ێӼ ON t+73!XuVV66N^VbON3tڋxZ&[S. &ێӼ V=OFN3t	ڋ5Z&[   f~ u f~ u^& ꐋF fvyFafvCfvfv֐fv̐fv{fv븐fv뮐fv7뤐fvu뚐fv5됐fv놐fv{fvqfvgfv]fvSfvIfv?fvE5fv+fv!fv= tw#=
 w@. 
= tw#- dHiHnHsHxF += tw- vH{- Ht- ϐF^&~@  >G t  hD2VZ^&GF&GF&GF&GF&GF&GF&G
FD<D?KG  >G u  G 3 3   >G u  FFhD2rYFF   D
uЍDru^&GK^&GT>oFu^@B&G \?^&G >Fu^&G	B^&G
P^&G	 ^&G
 G 3   >G u  FDF  %F@P P YFF^&9Gw&G^>^Z3 >G t>GtD%>F*G 3   FDf+fF^&GtN&GtN&GtNF&F@P P lXFF^&9Gw&G^>^FV"^G 3   VFD^uRptu?LB
FVFtL.
;Fu;Vt L
u^; ^ E?F^Î 	F ^ u	PPX	F   Y=F~'}*^f0fP <	^N&^ f	Ftŋ^ u
fjX	~'u^fPF>\^f&OfN^G F^F  ^&  &t.f&OfNF  F~}-^v& ^F&F  ^F&F~|F  ^v^F&F~|^*&GHtH|pH~I	^& FF^f&OfNftfvvQ&UV^&F&FF  ^&FF&9Gv:fvf&p&@
Vv^&@
Fv&@
F뻐^G  ^fG    ^FG0G2  ^FG4G6  ^fG<    ^fG"fG8F, G*^fG
   ^FNF=3^ DG 3   >G u  FDF  %F@P P *UFF^&9Gw&G^>^F3   V>G u ^ F  F^v& ވ"FF~|3^   >G u  fF    ^&GtN&GtN&GtNDFV3   V>G u ^ >GuDVu^&G  >F*^&G^&G^&G ^&G
 ^&G,  F  ^*F^v&@^"F^v&@F~|աD^&G.
E^&G03^ UfE^f&GfE^f&G
fE^f&GfE^f&G3 3 3   >G u  DhFNRvh3 U^&G^&G ^&G^^&G$&G	^&G&G
^&G&G3   FD^&G^^&G^^&G^^&G^^&G^^&G	^^&G
F^&G^^&G
^^&G3 UfF fP6  QfgF^f&G^3&G&G   FDF  >Gt^^&G F ^uLptu9L&FVFtL;Fu;Vt Lu	^뚐F F^&GHt- r-  ^^&G  qp>8FVF^0u
fF   fF  _uF#F#V^fG$fFfPh8^&G  ^_'^>  t
3&G  k8F  ^>  t^& ^   ^Pd
^&G ^PFأ G^&G^G^&G^GF^^&v*&G
*&oF^&G A&u+&u$&u*&G*&oF^&G ^&G F  F^&GF^&G
^&?u^&G&t
^&G^&G F- t- t^&G ^&G}^&Gs^PE
u!^&G ^PF^1F^F   %5F~}^_t^Q^_'Q^&G  F6   
UG^&G3   FD<<8^9Gu9Wt øFV^0u
fF   fF  _uF#F#Vu3ÐfFf#Fft!^0ufh   fj ^fG$fPhB5^ _'Ë9Gu2Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^RPx10:0ÐURPx 0fv0 URP u @u
fj @fv|S4+4URP u @u
fj @fv|!4fv4   Sf+fFF^; GW ҉FV^fw^w^fwFV  ^^fh  FV  ^FfjFV  ^1vFV  ^CGG؉FG ^G^fG^fG^fG^f^FG_^7HOW #GG  fF^&-Ff~ t^fwlXCF  S2F2FV^扇^FFVQ+
u f~
tf~tf~Mt
f~mu
^Ƈ< ^Ƈ<,<2FV=(u u^+^戇<F<2FV^FFVċ^∇h1^,1FV^扇^F^怿ptqtǇ0Ǉ0 Ǉ2  1F^Ffj |1^fG   ^fwh1h% ^fj @^TFV=Tv,eK$F^XFVF%0 +- t- t&F ^抧F% +- t- t<VFFF@t^Ƈ.Ft^Ƈ/Ft^Ƈ=F΋^Ƈ= ^t>FVFt?F%? ؉FVFF  % ЋF	F	VfF    ^Ƈ,^pFVF^$-F^$p
F ^Ƈ, p {t^Ƈ /^Ƈ^怿quL/FVNfRvL//FVN^怿uNBfNFfv/^怿/ub fF    
 k.fFf~8 s^P=u܁u֋^ #^抧0t #^-fj Dhfh  ` 8h^fǇ   ^ +ҊԊ*ҋ^扇^ xFF  % ЋF^		^抧0ukǇ5  ^Ǉ7  ^Ǉ9  ^Ƈ; ^拇$-@ `uta- t\-  tW- tR-0 ~ tEfFf^F*5Ǉ5 ^Ǉ7 ^Ǉ9 ^Ƈ;f>b    s Ƈ* ^抧pt	fǇ `^抧ptu;(uƇ+=Ƈ*뼐Ƈ+^怿* u&~ t ~ tF+~ t~ uƇ+f+fF^抧0u!=u 0u
fF  ` fF  @ fvt ^怿.t~t	/ 4  *  Ƈ4^ "^抧t uOh  h ^ h*^ ^ mF
P^ FP^ h^ ^怿< th 	 )t^怿< uj 	 h ^3wFĊ֋^*^FFVF^*䈇^FFVĊ^*^F^抇^抇^抇^抇^抇^抇^fǇ    ^fG   ^f+f^戇^戇^扇^扇^Ǉ ^ǇdK f^ǇhK j^Ǉl n^Ǉp r^扇zx^扇~|^扇^扇^Ǉtv^怿u>@*FVf^抧 ufNf @  uN0fFf^拇HHtfǇ   ^Ǉ fǇ   ^Ǉ  Ǉ ^Ǉ ^Ƈ^s&uF^怿 u(uƇƇ^fGfG"^怿* tfǇ    ^Ƈ3Ð  SP #^& #^Î 	 #^è 	 #^ 	 #^ 	 #^G    (^GW^G  ^f+fG^쀿;uGGA|   $FG^'^GW^싇7FFG~^'^쉇  ^Ǉ   ^fǇ  @  ^Ƈ^f+ fFfFfF^f9 v(kD<GFf+fG^G^Î FC#ǐfv fF    fFfF^f9Gv)kD\I؉FG
 ^fG   ^&F"%u(^Ǉ PP| ^ u^ƇÐ  SVF  fwhh(^/ t ^}^ t^/% @fF   fv h^fǇ    ^fǇ    fj | gfj @]^*u	ǇT ǇT ǇV  ^fT /^0t.fF    fFf~Psfj FV ^?ݐ^_f+f^_G
  ^_G  ^_G  ^_G  ^_G  ^pufF   vG u!0u
F  F?v'F 񐊧 u
fF @vfF@v^tpuNfvl /^  u#up FVN Rvp fF4 $fv hfj@Dfj Dfj`Dfj4Dfj
8D^0t5fD^fDfh    ,Dfh    0Dxfj \nfj  \dfj DZ^;t"fj P$F^fwT$8^7hj X$"fh `  \$fjH$fjh$^fGffP,fj^*^fǇ     ^fǇ     fj Yfj Yfj ^ fj ^^f ^9j ^9HǇ  ^;u
fGz    fj;fǇ     fj ^ ^f wfj ^j^5j ^Wfj lXfj tXfj |X^fG    ^*䊇*튏****%FF  vP8fh  <fh &  dfj yfh   lfh  _fj Ufh Hfj>^fd</^fh< ^fl<^fp<^fx<^f|<^f <^f$<^ft(<fj 8<^fw<<fj 0<^fw4<fh   @<zfh   D<m^f0 <^^;t
fj 0Jfj  @fj 46^fT  ^* uU$fF  khf ufN	 khfv?^fT ^;u#+FNPvh( :!fj dfF  fv LfF  ^u uf @  uNfv Hifj (_fj 8Ufj Kfj A^; ufj ,-fj $#fj fj fj ^fǇ\   ^t\^f\\^fǇX   ^tX^fXhfjP^ptuUF F  fv|^
^b^ t2^ 0 F  fF    +uF fFf~ds
 ,^9Gu9Wuf~d fF    fFfFV^f9Gvc ^v_9 u69Pu1fFff`  ff^^w^9@u9PtfF^f9GtF ~ tF~ ^Ð^ t; 3^  SfjX/^GW$FNRvh^3Ð  Sfj X^GW$FRPhz^_thFNRvh^3Ƈ  Sfj X^GW$FNRvh 3  PSVt7؋GFF F؃
H^F(^e- F؃SFF  ^fGx^f9G
v^F^fD3^ÐfG
^f)Gx^GpFFGFfF    ^w*^f@^fG^w*^f@^f^w*^@F  FF^VGW
^拇9HNA#FFF+ҋ^9W r9G
 ^O^FGpWrFGFV ҉FVF+;Fu;V ^f7^FV8^fwFV  ^^fwFV  ^^fwFV  ^^拇9HNV #FF  FFufF @  FfFFMRPFYP^怿ptquj vFY+,^6F^qF~ 3^Ð(  RPSVFVfXZfFFtfFtfFtffF tNffFtN`ff~ t ^ÐFXZfvhF^ҋVf+fFfFfFfFFX^ҁ@ F؉VڊF$F$`Fހff   Nfffvށ 	B	RFF^9>F  vfrFp+F~}^Ҁpufj3^Ð
  SVs^f+fX^^\PPhfj \fF    fFf~'  sh[uf+fFfFf~'  s\9uF  I^ ^PF^6>Fu^P^ ^FuF~skF|F F붋^^ ^>^_G
FF+ҋ^9Gu9Wt<;u`w@F^&[^7HNA#F3^Ð  S/ t A	^^/%  s	^
 3Ð4  SV;u_G
FF  ^ʋGzW|G~F_GFF  ^GWFVfFf9F9^ʀ; t_FV ҉F̉V΍FЉFF  F~s1FFV΋^^v PԋF^F^GF t^ʃ& ^ʰE  ^G^- GG  ^f^fG^f^G  ^ʃPF^ʀ;u-7HNV #FF  _G
FF  5HNV #FF  _Gѐ^ʀ;u
fFfGzF^VGWfvXp^Ð  SRFV^* t
fF   0tfF  fFf#Fftz^^3  F   tf tfu; ttt
NFÐt	NFtNF  RPSF  tIFt)FtFtF 7Ft1F *Ft#FtFtFtF F^XFt^ tt
^X^fXh^\Ft^ tt
^\^f\\3ÐUSt
^Ǉ 3Ë^Ǉ 3Ð  SF * tÐu/0t# ^ FFu	^ ^h ^ j^ h^ j^ h^ h^ h2^ h^ h2^ h ^ rh 
^ e^苇t- t	-  ?hu
 Bhh^ 5hh^ (hh^ h ^	 3
h^  ,FV=(u# u^F^芇<2FFFꈇ<F  ^耿< u6j 	 ^fv,fǇ    !hh hh^ vh 	 ~^苇SVF! hF FA \F  F PF !FDF@ F F 3F@F F !u- = w.|55 5,585D5V5^f t!v3v^ v^	 ~u	h 3^ G^ =FF  j^ ^tpu+ujj  qfF   ^芧0u 0t
0tF F  c'F~ }^ FFtF ^f u F= uF ~ t~ u^Ǉ FF9F~F  똋^Ǉ ^ GF^fTVfFfNF% F N^fǇ ~uNfjP ^芧pu+tfNfǇ ~uSNM^芧pu+tfNfǇ ʚ;~ʐ= w.7P766777P7P7F^VTVfv 8fh  +݋^芧0ufh   fj
݋^胿uF^  F^FV/3Ð  P
@NF  FPvLfF    fFf~'  sL܉FVF  uF  f~'  rfF    F  P
 NNFPQLDfF    fFf~'  sL܉VF  u   RPxSܸhۉF@RPhF  hۉFF@t SF~|Ð  RPSfj @۸ .fhTveK^P۰FV^tIpt=fj pwfF    
 fFf~a  s pBۉFVFtfh  h7۸( ^f^fwh^=u$ 0ufF  ` 	fF  @ fvtfj @ڋ^ 0u_h 3afF    fFf~ds^3Āuh^ 0^< th j 	 h ^3fv^u
f@fF    fFf~8 s^PN=ut	
 
fv^^ڋ^ ptpuDfjPٸ PىFRP Pٸ V
fjp  ٸ C
fj  P3Ð  PV8hىVF  fcF$FV΂RP8hF  
 LF~d}8h\ىFVF @t݃~du3^Ð<h;ىFV*ȋъĊ֊n*ɋ؋VԊ^  RPS*j P\
F*j P`
F  
Fu.F~{~ uFtfF   fF P  FfF @ fF T  FF*+ҋ^{t  F  fj FVF {؃F~ @r^&wf&w
FV&G ^ ^&wf&wFV&G ^ ^&wf&wFV&G ^ FFfjFV ^f&7FV F  :fjFV fh   FV^f&7FV ׸ {
F~sFV ^&9u&9WufjFV vfj FVj{3   RPfF    fFfFf9Fw^Ff7FVFV(   = uuF PF TF  fF    
 o
fFf~'  s,fjFV fh   FV֋FVtf~'  u 3  PSVfFF  7F~}+F% FF  fFffFFFtfv FF9F}^v 1F1VF  뭋FV^Ð
  SfFd   fFfNft^ ,uF  PSF  ptuh 3m< L	3F
 FF3FFN~ 
~ th ^3( 	F  F ^ 0P^ h@^3^	 wFh ^	 h ^ h^ h ^ F   F
P^ h ^ ^h^ p^ F   ffF^^9 uF^9  F  F j^ h@^ h@^ F~~ F
P^ j^ F  ^^ ^ F~|h^ ^FF !F~p^ F^ F^FF ?F  F~}TF
P^ j^ F  j ^ F~|h^ ^uFh^ j ^ h ^ j ^ h ^ ^ P^ tv^	 gv^3[F=uD =uE =uF =u =uG =u =uH =u =uSty=uTtn=u]tc=u^tX=umtM=u
tB=ut7=ut,=ut!=ut=ut=u
MuÐ2Ð  hщFfRvhѸhщFf% = UPS  ^G  ^FG^G  Ë9Gu2Ð  PSV@+wV9Wu2^ËF7@^F^G^Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^  SVGF9u3^Ð@+wW^Ov^@^Ð  S F_GFF  ^fGtfFfFf9Ft[^6X؉F  ^PF^G
^F9I#+҉FV^fG
^fGx^_GFF  뜐F^VGtWvÐUfvb 8  Sst2"=t(rF^Fs^Ft^stfh   h
Ð  SƇ^f+f^Ǉ   ^G G
^Ǉd f^Ǉh j^Ǉl n^Ǉp r^vt^Ƈ^^8,t-
 +%< FF  V>F F  PF F F F ڐF ҐfF    uH= w.pF F,F4F<FDFLFF^V3Ð  SF  FF+ҋ^9W$rLw9G"vE&OFiF ^p G^fG    i^ p  ^GW^&F뤉VFF+ҋ^9 rOw9 vGÎ FiF ^p8G ^fG&    i^ p8l ^G"W$^Î Ff3  S
^&O^Pu  FFFFF+F   Ã ÐUPÐ  PF;FtN~ Ð@ &l &n   h̉FfFRPhfj hfF@B fF    fFfFf9Fv퐸hRPf@B fYf3ff> Ð  f6> RPfXfYffFfF    fFfFf9FvBfh  4RPfXfYf3fffÐ3Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^          2ff
   fP UfP fºffff]UWfP fºffFf_] Ð3Ð2C@@UPQRN;ssZYX]1ff       Vff  
@ &6 +&6 3^     X	S[	[P6  SfZ fFF| f^ fFfb fFFfd fFfh fFFfj fFn FVFP^ȲAt 3  VF  ^f+f&G^&G DGh4GG fG    fG  FD^t	 ^ ^*䊇船>F* ^:tF ^t"hF ^B^*䊇荹 hgF  ^vވM @^MwF~r؋^ X^Pq th.F ~tf.G^f&G>2G xM#G^&G^&G^&G
y^&Gs^&GF^ h@ 3 th`À>G u+0u$GPj
 .GRPfXfYffff

tYG*HtHHt7K>G}u<GPj
 .!GRPfXfYffff]
>GwVuG>GH3Ð  FDF F^^Pc	
u!^P	F^X	^G@WBÐ3Ð  PVF  ^^v& ^M^v&@F~|֋F 
^&G^   FD^Î /	Fuv^ u	PPX[F  ^f0fP <Cǋ^^ Fu F~'|ŋ^ u
fjXǁ~'u^fPFÐ  PSFDG  ^fG    fF^fG0fF^fG4^fG<    ^fG"fG8F, G*^fG
   ^F3  VFu^Ð؋G FPS ^G^G^S GQ	^G E	^G@ B	^GW  0	^GW	@ 	^G!W#	^G%
@  	^G'W) ^G+@
 ^G-W/F  ^M^v@1F~|@ ^G7W9^ G;( ^G<W>$ ^G@WBF  ^4G^v@DF~|础DN^GLGB^GN 6^GPF  ^v@R F~|BS^GXFZ PhhI^d 3^Ð  VRFu^Ð؋G FPS ^)GG^G^S G^G ^G@ ^GWGG^GW  w^GW	@ e^G!W#J^G%
@ G^G'W) ,^G+@
 )^G-W/F  ^M^v@1F~|@ ^G7W9^ G;( ^G<W>$ ^G@WBF  ^4G^v@DF~|础D^GLG^GN }^GPF  ^v@R F~|BSY^GXFZ Phh^d =3^  VFD^PF؋GF^^&} F^G- F^?aYQGF^GFF+F=CG*$Ht	HH~~:^GW	=@^GW
t=WtueNu	2G 2G  GF  CF~}-f^v@"*N t݀Nא^v@"F^F#GF~}>2G tF F  먐^G<)GhphxF   ~^#GF~|hqfj
 .!GRPfXfYffff ~ u^GW
^G tGWnF*G,G^G@t)GWRF؊N.G0GfG^G- Ff*GfР*G% RPF  PFF+*G,GG  ^G)h
 t thj
0G
h]
.G
G
^Ë^&F^^ÐA  SFD^P
u+^PF^&^G^_^G3  RVFF  eF^&9G,~_&x2 ~Gf&p.fv&@2
v^&@2Fv&@2)FF~ D3^ D 
u	DÐD  PVFu^ FDG FPfF fP^&GF  ^v^@F~|^&GFf&GfFF  8vf&p&@v^&@FFF^&9F^VG@WB^F3^ 9Gu2Ð  PSVGFuGFNF9u2^ËFv@^FG^G^Ð  SVF9Gu3^ÐuGFNF^Ov^@^À>wD uwDvDtD   Ð3ÐUPFtDuvDpDrDvD ÐtDÐ  t À>vD uFV+pDrDFVfpDf9FsfFf+pDf  fFfFfpDtD+9Vwr9FwF)tDfFfpD3ÐvD 댐  PV-F8Ft,F~ t$* 	 	^ÐUPĊfÐUPV*ȋъĊ֊n*ɋ؋VԊ^	t	-t-,u 3Ð            Adapter - BCM570x NetXtreme Family B57           HardwareDriverMLID        
            `X  X                      	  
                             
                                                                                                                                            `a                    p                                                                          `ں  ZZZZXXX                [[0[[`\*[w\Z|\\/\`[[0[[\\!\"\)\$\Z\K]E]/]Q]]]```+]+][U>Z4 \+& Uu[u 	XZ
 ]˺Z SVsrt*ݕ+Y^[ø.3Z* &D&Tr+ t+ډD&5&].3Zù  ZøtK
t(S [;Wrw;GrWڋR [;u+u+DDڋDuP XÎه\.Et.  ǃPG*_G,_.O7Huù R.X tXu跩 +gl  gn  7 ñ..Y.ZYr`7Gû6Z 7t&&TW&L+.Xu< .:3ZuOu让.3ZY+.:3ZuuL
Lt\
DPX3~u< s"UX+Ұ.:4Zt+EZnZ]˻6Z  Y  &LOΌOWtَډ7G+&&DøV ^uY&,YXE"u.Yt!YYV^tEU*+QuMZYcQ Xu.4ZeZ`]Q".>Z u.>Z u;Y.>5Z uWu(g.Z.5ZD,ث+|t#+.X..X<rg3.X.X &u&D=vV pY3ɈM .X&&\&T##At.X.9Yu.9Yu.9YtÿpY.XrF;wr&\tItJpYE ].XD&D tz}.X@Mt.X s..X.X@_pYQ&|upY+&dE
&DE&DED)7.X Y@pYE<w.X
Dxt.X;wŉ5EEEU.>XtE  m.XM
u+P.XEP&DEP&DEP&D
EP
ZE.;YuYuJ&D&D&D&D3&L,\.&W&l &T*&LMt
+;r&l*X.X3Ã
Ëŋ+Ht.X
u&Dٽ.X.X+\2&L,&/Iu&l*\`  KBPUSQRWV^_ZY[]X+&D*.5Z+tZ,T+ێÊ&S+ێÊ&&G[úY|w! Lr	t+u+YTLʉLuIuËDDDV^\|uAྼYD<w<XøZøYøXøYWVQX  Y.Y.Y.Z.Z.Z.Z.ZY^_PS [X UFFt%&?	u
h&F^&? u UPFUPFÐu32PSQR 3ɺO3ZY[X   fFV
fFFtf~ t^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_ UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] USVF
uNF3؋F8ȋ^VFuf
Fr;Vwr;FvN3Җ^[]  UP$0F<9vFFÐ  U<ps                 d$ $PnP       o              
Copyright (C) 1997-2000  Intel Corporation
 Intel CorporationIntel Base-Code, PXE-2.1 (build 082j) $    I $BC$+   @:^   
t2ôu3
t2Uf`F  fa] j j
j
UPS^< t	2PC[X] UPF$0<9vPX] UPFPPX] UPFPPX] UfPfFfPfPfX] UfPfFfPj:6fPfX] UfSQF^f^NgfCYf[2]
 UfV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F]0Uf^]2 thP~SwQpRibWZT1
-AX- -BX- -CX- -DX- -DS- -ES-:-DI- -SS-:-SP-
 ÜPh)tX
Waiting...               
  t^@:^ 
h h@ UfPfSfQfRfVv&  &\f?UNDIt?h_& o
PXE-EC4: UNDI ROM ID structure was not found. Gs<hk& '
PXE-EC5: UNDI ROM ID structure is invalid. Pj Sj < uf. fGf;sff. ff. ffGffGff  f
@ &6 +&6 fRSfP& ff33ffJtuہ 3fX[fZNffW.; s. @ 6& ԋfPfSfWfUj j fj fj RfRVQ@ & v &D6E&D6E&D6E&D6E&D
6E
fFffЉVf. ffЉVf. ff6UfGff6UWhTw
˃f6UfVf6UfV
Z cv & tl tc" tZK tQ tHh]Rjh*
PXE-E09: Unexpected UNDI loader error.  Status ==  P
PXE-E20: BIOS extended memory copy error. 
PXE-EC6: UNDI driver image is invalid. 
PXE-EC8: !PXE structure was not found in UNDI driver code segment. 
PXE-EC9: PXENV+ structure was not found in UNDI driver code segment. .>  u=h$v & 
PXE-EC3: BC ROM ID structure is invalid. f.f.ff^f. sLh\Pv &  r
PXE-E20: BIOS extended memory copy error.  AH ==  . f.f^f. *rv&D &L. &;D&s&D&fF&D@ff&DBfF&DH&DPff&DJf&DR&DPj Vj &(Dv
F&DF&D&DPj Vj &(D	v &D6E&D6E&D6E&D6E&D
6E
Wj v&\Z
  Wjuv&\Z Wjvv&\Z  t  uj@ H FF  RWjv&\Z  t{Xt&t
 u tfS^
G HF+F)F[fSVWF  6	fff& j fT f& f  fT _^f[^Zf]f_f[fXf t8@ & f       f&uJt u ߸@ &6 v&< f^fZfYf[fX  t ]˜= t.. ﾭ    . s	UN]&}t	&}t+{f&} usfPf. f&9wf&+f&;Esf&EfXRf&} wJf&=  
 s@fPf. f&9rfPf&f.+ f&EfXf&fXf&+f&;Euf   f&EfXUf]r.>  u	  . 	Pfj j .(   fZfYf[h
1P<Xt/
Press <Esc> to abort ROM initialization... fPfSfRfW ߀>  $u> Pu> Mu	> MuGuf    f_fZf[fX Pfj j V< uf>  tf . fSfQfR. . .2 <t8hq
PXE-E06: Option ROM requires DDIM support. f    ff    .  f    ff  fRjfjf. ffPj hfQ˃ffu0h;fZf    {
Invalid PMM function number. f u)hqfZf    E
PMM allocation error. fWf.> f	  frgfgfff_fZf.. Pj h j .( . . tf.>   r
.                  blksize tsize                                         U ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j    |      
CLIENT MAC ADDR:  
  PXENV+     GUID:   
DHCP. PXEClient:Arch:00000:UNDI:000000  PXEClient CLIENT IP:    MASK:   
DHCP IP:    PROXY IP:     DHCP IP:  
GATEWAY IP: MD  BD  UD  
Auto-select:
      
BOOT SERVER IP:    (  )   
Auto-select:
                                                                                                -->  MTFTP 
PXE-T :   TFTP Aborted  ProxyDHCP service did not reply to request on port 4011.  Client could not locate a secure server Missing MTFTP server IP address BIS bad entry structure checksum  BIS get signature information failed  BIS free memory failed  BIS get boot object authorization check flag failed BIS shutdown failed BIS initialization failed BIS image/credential validation failed  BIS integrity check failed  Network boot canceled by keystroke  ARP timeout TFTP open timeout TFTP Error - File Not found TFTP Error - Access Violation Error received from TFTP server TFTP unknown opcode TFTP read timeout TFTP cannot open connection TFTP cannot read from connection  No DHCP or proxyDHCP offers were received.  proxyDHCP offers were received.  No DHCP offers were received.  No boot filename received Invalid UNDI API function number  MTFTP cannot initialize NIC for multicast Error while initializing the NIC  Error while initializing the PHY  Error while reading the configuration Data  Error while reading the initialization data Invalid MAC address Invalid EEPROM checksum Error while setting interrupt TFTP too many packages  TFTP packet size is invalid Media test failure, check cable NBP is too big to fit in free base memory Bad or missing discovery server list  Bad or missing multicast discovery address  Bad or missing PXE menu and/or prompt information Could not locate boot server  Invalid state returned from UNDI  PXE-  Invalid message code.
   /-\|            
SM/DMI BIOS functions needed.
 _UUID_  
									       
      
 f~ u ːf~ u^& 鐃>.3 u3\.3h[t0F-  r- vHHt
- r- v뾐:: 1LP3 뫋F fv?FF^&)~!~ofv'ҐfvȐfv뾐fv-Fu
hx9 i[F 롐fvFth I[fv[fvmofvАfvƐfvA뼐fv벐fv=fv?	3=1 tw5-  = }.f             $=q )w-2 tHt-= 7-s HHH!3  F  
9  >9 t  JLfFf99f2hP99@t{<IutyIu^h
JuShRF   }R^
RF9*9Fr䡸93MuIun>huYu
"Ft1J9NMqIH~ t~tEVjOhRF FP)Fu9Fu9R 9뮐U>9 t>P3 u>: t  II9Lt9 9 9^&9   V3Y-  +ҊԊ*҉FVFP+$FVu3^Ã>3 t3+ҊԊ*ң(3*3(h2fj vPfj  E/t	f(3    7f(3*3f9FsEy WN뜐T3 fvfvh2fj h96:6:6636H3 |3O8tְE뽐>2u}(3*3% (3ҀĀ FVf(3fFGT3 fFf+(3fPfvh2fj fj fj fj FV37ufvfvf6(3 |K
u	E" 9Uhx9bWFFV^f& |  PVr$=NVu^F^f&G(fFXfv^^  ^&G- r- v  &iGNF^& u*&G^& u=& u6F&GF^&G#&r&G^f&OfQfv&GU3   >9 u  >: t  >P3 t  G|F9f&G    f9  fP2 ~Uf9H fP2 mUf9@ fP2 \Uf9P fP2 KU9S*&GP9&(G9&G0FF  FF9&9G6 fNfNfQhhHT7Uuh:T^*&O;~S*\P
u3^&G^&G^&G^&G^&G^&G^&G$&G
  &G^S*&G
P^&(G	fF^f&G9(It  3!V;.33   ^&  t&  }?  >9 u  >: t  >P3 t  Eu֋FV RPF RPF
 RPF RP^3& 2),u: >: u  3*E3:   >9 u  >: u  >P3 t  fF fP^f&OfQ|1F^&G  F-tHHu9  5  F^&G3   ^& >9 u  >: t  >P3 t  Cu^f& GP P P P& & & & & & 33^&^&Fuf(3f& 3 f&Ǉ     F   >9 u  >: t  >P3 t  ?Cu֋FV RPF RPF
 RPfj E S3ҳn*F2CF^&~ uf(3^f& ^f&Ǉ     F=3 =2 }
c F -6 tHHtKU>9 u  >: t  >P3 t  Bu47f^f&GP33 >9 u  >: t  >P3 u  B3P3   >9 u  >: t  >P3 u  FN~ tIFV RPF RPF RPF
 RP^f&OfQ&G9Ft^&G3 F^&Gv  F>9 u  >: t  >P3 u  ^&
 uQ&G
^f&OfQGPGP&G&W26uF3 F  fF   fF   f+fFfFfFfFfF$mIfjFPvGRPfj*F $KI~ t
E! FËFFtE# fFf Ð  fF   ffF$ IfjFP	GRPfj*F $H~ tE! 2FÐFFtE$ 萸 Ð  fF   ffF$HfjFPFRPfj*F $xH~ tE! EÐFFtE% f~ t 3  RPfF   ffFfFfF$ HfjFP)FRPfj*F $G~ tE! REÐFFtE& 萸 Ð  fF   ffF$GfjFPERPfj
*F $G~ tE! DÐFFtE' fvFP|E L  F+;Vr
w;FvFFF3fvh3HE^KFV "  RPfF    ffFfFfFfFfFfFfFfFfFfFﾭfF    $FfjFPDRPfj*F޸ $F~ tE! D f~ uf~ t  3 WV2   It2^_2&sE( C^_ÐS*&G7H
u⸀22f   ftrHuVHu0HuHu 2^_  RPKHu0fvfvfvFVFHtF  ~u  3   SRPVf~ tDt@u2^ F+v
rD7D0^N&FN+FFNu^ 
  SRPWVF`4^ht32 Kt3R3u39v3h3h
 Kf2fx3 L|3^f&cSc>
  t^&G^_ FHtHHt- tI- tJ-
 tE~3  ^& 5F^& FFHt1HHq- t- c-
 \|3  ^f&f3뷐^& F~u!^& 2F^& F^f&^f& ~ ^& 7FvF^& F^& F^& F^& F^& F^& F^& F^& 
F^& F^& F^& F^& F^& +F^& 6F^& <F^& CF^& F^& F^& F^& F^& F^& F^& F^& F*F^^&^& 9F^& F^& F-  -  -
 t^& ^& Fu{>  t4  h"(CcG			th&Cf6	Ch. Cf>	 t.^& aF^& F^&  FfFfPf6	 AI~u(^& 6F^& F^f&^f& a^& ]F^& FGFJ^& ^& ^F^& F^& F9&_&G	^*& FF9&_&G^& FF^& <F^&  FfFfPh6  HfF fPǺ
  /fF fPF
  fF fPF
   ~ ^& +F^F& ^& GF>  t'^& F^F& ^F& F^&-^& F^F& f% !I^& ^&>2uM^& F^3& ^& FF  !^33H^& &PF39F|^& F^&^& ^_ .@f2fj fj  3Qf    f2f88ht3fj h: C$,h:ht3GUPV3^*& BFfFV^f&G<^&Ǉ  ofFV^f&G@fFV^f&GD̐fFV^f&GH븐fFV^f&GL뤐fFV^f&GP^&Ǉ  ^&Ǉ   fFV^f&GT֐fFV^f&GXfFV^f&G\뮐fFV^f&G`뚐fFV^f&Gh^&Ǉ  ^&Ǉ  ^&_h&u 3^& cfFV^f&Gd= )= wA.JNl=
 k- &H5HD- t-; ^- t^*&@ 9vO^   PV3^*& =4 CtHtzHHtN-
  -  FfF^f&GfF^f&G^&_f&G^f&GpdÌ^&G&W^&_f&G^f&Gx;Ì^&&W^&f&G^f&GtÌ^&G&WfF^f&G$^&_$&	r"^f&G$ fPhX	 DuF F  F*^&  Ì^&G&W
^Sf&G fP&_*&G~Ì^&G&WjfF^f&G,h^f&G, fP&_,*&G@C^&_,&_*^&G|&_~-5 {H- 	- t- t:^*&@ 9v^f& tf&$ u&  u
& & ^ U^&?t3 f2f&9Guf& cScuf&  t؍GPh
9*Cuø    WV3F Dvvv^&7Vj
 & RPfXfYffff88 9 7:fj FPfj fj j 3Pe+thBtix  RPhVBix  RPix RPT
ix &n tF ^&ix&p tF F Fix=zP^&7~ u~ t	^_ 3^_ UFVl RPFp RP 332ht3fj h: C$' Ȏ  ǆr Dfj
 & RPfXfYffff77 8 8fj rPfj fj j 3P**thtȍtPhBf~ t^&uf~  tfF^f&9GlufFf&9Gpuh&$h@fFffFf2  3 UhfFp fP
 3
21ht3fj fFp fP$x& Ȏ  fj
 & RPfXfYffff66 7 7ǆr  hrPfj fj j 3P)t̋r- Dt-guhttPh)f~ tf~ ufF^f&9Gpuh)h?  3 Ȍ  PV3F}Pirx  RPirx  RPtʍtPh)
>2u~ u ^ÍtPirx  RPy
FPFP 3`0$0ht3fj FP C$%3^  RPVF  ivx &t u-FF9F"ivx &n u3FFF>2u
ivx&v uF ivx &p tivx&r ivx &p uF  FF9F}.ivx&n tivx&t tۃ>2u
ivx&v u9F=F Pivx &p "ivxf&h F  FF9F}
ivx&n t9F-ivx &p F  FF9F}ivx&n tivx&r u9F ivx &r ivx&j&hyivx&t {ivx &p XF  FF9F}5ivx&n tivx&r tivxf&h tivx&t uF9FH= .> zHivx &l t=h&$iFxP<ivx f&Xfivxf&`f2	 9f    f2fiFxPiFx  RP_ivx f&\&^fFHHHHHtHtiiFx P 3ivx f& t&ivxf& fPivx&Ę&G*3Fh92 ;F  h92 ;FF9F ivx &n tivx&r uiFx P Y3ivx &&t&ivxf& fPivx&Ę&G*3iFx   RP 3ivx f& t&ivxf& fPivx&Ę&G*2F F9F~  h)h&$: iFx P 2ivx &&t&ivxf& fPivx&Ę&G*K2iFx   RP 32ivx &&divxf& fPivx&Ę&G*1;~ t3h)iFx  RP9ivx &\&^ ^Ð3^Ð  RPFFF  .;3f~tf~ u
F C D~ r~ rF  hFP^^ V~ Cu~3*=*ht3fj FPF$2F   SRPWVFF  fj
 & RPfXfYffff*/3=0 0F  fj FPfj fj j 3P!kF- Dt-g\hOiFx  RPh8iFx  RPiFx RPivx &ĘT&uF Fivx &ĘT&9G F9ivx &ĘT&O#N; ~ taivx &R&P ivx&ĘP&G&WI9FVF  F39FsF^93u93u39Ft[~ tHF  FF9Fs-^vi~x ؎Ff& &P f&;\uȋF9Ft
FiFx=zs	-`F^_ V6hb0h1hn0h21f> t&ff9thx0h0h0hh0h0f>9 t@3f9 t1ƹ +uhc0 R09P0 @0Frh?0^Ð
  WVF9*f|
f2f2f: Dh:2[6f    ffFdF 5 9F~F !uxF ukF u^9F~
F uLF u?  F~}/^ۋ  FPFPtЋF g~ ~ u
FQ ^_ËF9FuFR ^_ÐFS 3F9v~!ix &n uix&p tFU 9vu1~ t+3F9v~!ix &n tix&p uFU 9vt1ix f&Xfixf&`f2ixf&\fFF^_F3^_ÐUfv2 4^f& u 3^& fvfF fPa^f& t&_&GtfvfF, fP@ 8^f& t!&_&GtfvfFl fP (^f&| u^&l tÌl ^&G|&W~^f&G^f&Gl^f&p u^f&G^f&Gp^f&x u^f&G^f&Gx^f& u 3&  Ȍ  >2u4f~ t-tPh-~ uEz k*3 fF^f&tPh)f&)f2fuFFtfFf2f~ t^&G&WE{ 륐399f~ t
^&Gu43:f~ t^&G\43:FFu	63  ^&u&G	*&G+4*63FFuH3  ^&u&G	*&G3*H3f~ u39,3^&G3,3^&G39f~ t^&u
&G333  FV   RP>2u 3F     > w$fvFV;fvVF^Ftʃ~  >2tOh)f6 1f  fP ) f& tf& fP&ğ&G*z)F h-f6 1 f&\fF     > w&fvF3fj F33
tF T3   PVf+fFFfF^ğ
&Fu^ >2uNF  F	9FsA^ğ
&^ğ	&9uً^ğ	*&GF^f	 fF~ u$^&GR&GPt&_P&GtEw T'qF ^f&P t&_P&GtF  ~ tz^&_Tf&GfFm/h)FP
*^&_P&Gt(fvfv^ğ
F&Ft(^ fvfj ^ğ
3&F F ^f&P t&_P&GtF  ~ thfF.h4)^&_P&Gt(fvfv^ğ
F&/Ft&^ fvfj ^ğ
3&	Fu^F  FF9FsIb.h(FFVRP(^vf&0fj ^ğ
3&Ft^ 3^ USRPf`~^NvVFn
fa
 Ȋ WVF  ^&  hPh&$Ph)h^V6  u^V6  u	3^_ ~ ud t^f&P t&_P&GtfX u	   
  ^f&P  &_P&Guy^f&T u
v ^_ &_Tf&t^&_Tf& t^&_Tf&   v^&_T& wr^&_P&Gt@^f&X t&&_X&s$^&_P&Gt^f&X uw ^_  
 ^f&X thF  =^&GX&WZF 				^&_Xv&@* F^&_X*&G;Fw^&_X&G;F~^f&\ tf&` u
t ^_ &_`& t^&_\&r3R
FN^&G\&W^F R


R
ğ
& tR
ğ
*&G FR
^&_\*&G;Fw^&_`&8g h%3
*&G;v
&@%FFrh%3Fs
f9 ufvF@?Ht'&+h%h&)%s[f9 tNEx ^_ f9 t3+ǹ +uh;% *%9Po% %Frh%h
%*F  ~Is)^&_`v& $F^&_`*&GH;Fw^&_`&uh$ ǆ  ^&_`*&Gfǆl @ Ɔh$2	&2&%hn$%tO%= Btw3-t-,u^& Iǆ  t#)F  F  - [t- 
t- 
tאĞ&8t&
uu@)h#ǆ  
*&G;v&@#Frh# +G%
h #ǆ  ^ğ
*&G;v"^ğ
& @#FrȋF9vFh*#FR
9FrF
2$*+R
FvЎf   f^ğ
*&GhXfhp  j VV33Q^f
 fPfh  p VV3 )vPF+- Pfh  p VV3 F#=.t = t -t-t^& )~ tNh fh  j V33f
 fPfh   V3 vPF+- Pfh   V3UF+R
=KF{~ =F  kF+R
='R
HFS-	t-
- = K-w- 9t-
t- - Mt- t- t
  SRPV>63 u63$ >T3 u9 >T3آ9>
 tFu&>T3^P ^f&f2f~ u	24
^&&W99t3   F  ^v& ވv3^Fv&8 u^fǇv3octeF^Ǉv3t FF9~ EuEf~ t>^&? ~4Fv3Ph $&h %@FFv3P^&FF9~ t?f(3    Fv3Ph  %h  %@F^Ƈv30F^Ƈv3 FF9>T3 u
'@'F9N3  J3  63L3>T3 u
z'@v'>T3 t	t(>9 t!ht3h9h2F9t8 >
 tFu.bL3 z>T3  fj fj fj fj j 3P ff92uvff9u:9u1>T3  F&&;w&&; f9f9u&:9tfj fj fj fj j 3Pu|J>T3 t>9 u963L3J363L3J3J3= uE2 2 >T3 >J3~ EF EN3 &- toHHt	HZ>
 t(~ u"hdFhlhh>u; \>u< O>u	= ^ 6 ^ ~ t4ft3   hx3hp
 !$ht3h9h2N3 	> ^ >T3 uE%+Ht
N3  >T3 tff9u9u9ԡ%- F99F~L~~E? k? ^ >T3 t>2 uF9F92  :?h2 >#>T3 u3^ ~ uf~ _^&? SF   f~ tY^&? ~OFPh *u<h )"@FFPZ=~ Et9느9Ff=E  v~ t`FPh  uMh  !@FFPY(3*3ft3   hx3hp
 y"ht3h9h2N3 NFP!@F- 9F}FPi!@F- 9Fft3   ht3h9h2N3 -^    v9t3 v39 >|Y$#^&- v9tf~ tfvl#PQv9!>9 tht3h9h2N39w  v9 J3  >43 t	43L3L3$ L3| >T3 tQfj fj fj fj j 3P%
tfff92u[ff9u9 f9f9u::9/hhfj fj j 3P	t92u9 3t\i>43 u>9 u L3J3J3= uE5 i ht3h9h2N39f뻁> >9 t!+H>T3 t-ff9u"9u>9 u>9N3      Ð
  P3FFFF 1^*䊇N t~ uFFFFF:9FvȋF+F+2@Ffj
 fRPfXfYffffF~ tF9FwF  ^)FXF9Fv	F+FFfj
F RPfXfYffff;Fs"fj
F RPfXfYffffF~#vF#F  SRP9 T3 f+f(3Pj
 fRPfXfYffff63fj
 fRPfXfYffffH3f~ tR^f&? tHf&f9M}b  T32  F
:9 F :?h2 8T3 FF E43  f9f"   fFfFfFfvfvfvFPF32NFt3-6 t&- |p- ~>T3 tNF ET3 봐F FPfj F}$>T3 u9  >43 t43  9v43  9"T3*>T3 199F~F92  :?h2 ?~  ^*䊇N  f9fPFHj PfXfYfffȋFڙډN^:9FwFV;r
w;v:  f9fPFHj PfXfYffFfFfvF@+؋FVt   N^299F}tfFf(3~ ~F~ uFH::92tJFV43?fFf(3f(3f9FKfvF@+؋FVBnf9fF>9 t
99F/>T3 t:92T3 2  E
3 UVVv^$&=  t)ArZw <Ar<Zw FC:t^^ ^3^   VfF    & *N-0 FF^v&8 t&80r&89v3^ F^   WVf+fFF0& *-0 N^ӉFVF^v&8 t&80r&89v3^_ FV^_   VF  F'F=F~F
u~ tF0^v& FFNV
 FF~ u^v&  F@^ h28hV32,V3X3EY3 Z3@03\3`3a3b3  r3  Ð  RPVl3Fn3 Ip3r3  ff9^f&f99p399F9p399  fv9F2r3ffd3^f&fh3p3 Z3b3  0303\3^3  X3
 b3V3^f&? tf&?u	W3 &?r"&?wh83&&W  ^ f~ t
^f&? uhfvfj FVFFV
22##^&&w#2#62;u5;u122##^&&w#2#62;u;uf&    ^f&? ufvSh83%FNW3 Z3F99F$fFfF^f&? "f&?9- FfF- F^3  F fZ3b3  X3
 o
b3hV3fvh83V 	FF- FFFOF ^3F Z3b3  X3
 
b3hV3fvh83 V	FFFFF+F;FwF^3F+F Z3b3  X3
 b3hV3fvh83V+V hV3fvh83 V'	F^   Pf+fFFFFFf>6 tKa;8rBw;6v:>9 t'F
?+ڃ6 689  
f6    hu~t	F~dr3 >uff9ú> uh뼐>uF  
 ;Fu$<uf9f9t
f>  u>uM% Ht H`f9f9Sf+f69Ff>  8N
?+ڃ$>f~ t*ffF^&G&t&9&9WF%  F~tu9Fu9Ftf~ ~ FffF~  ff9ff9999999~ u-F9  t =th1- 9]
;F'f~ t7F^&? t(&9t#F9Fff9FWf~ tf^f&f~ t	^&- F~ u~  - F~ uF9FnfvhnFF;FfFFfPhF
FFF9FO9F9  t<=t7fv9F[	;F? f~ tF9FvFfvhFf~ t^f&? ufFf&f~ t^&? uF&F   RPF  6^&&Wk^9u9ukFPfvF= F~s
k^ uhh? kFPfvFkFPfvFk^Ƈ Uh92 99 h9h
9*h9fF
 fP9*S3&R39999 99 ff9^f&Gf9h9fj G
P ` 
  F  :^&&Wk^9u"9ufvkFP9*3 F~sk^ uh92 99h9h
9*ff9^f&f9S3&R39999 99 F  F	 h9fj fj  FFt$fFF= uΰE 2Fz  h
=tĀ>
u>
 uf
^f&9ufvh
9*fvfv9* F>T3  h2E @0303@   f9fff  f9f 0303 
 hfj h:3Mh:99uh.:  th:h.:!tEb m  6893Ð  FPj9&_t Ð3  FPj9&_t Ð  fF    FPj9&_u6~Ku+~Tu%~ uEa : Ð~Bu~Pu
 3Ð~tްEVԐ  FPj9&_t ÐȈ  fǆz   ǆ~  xPj9&_t ÐȈ  fǆz   ǆ~ FPfv FPfv xPj9&_t    SQ @@@@;؋sY[FPj9&_t 2  FPj9&_u0Fآ9F֣R3Fԣ9Fң9fvFP9*3     fv  `  RPFFV؋F6F FFF~ uF  F FFFfFfFċFFFF^&F&uFfF    F FFFFFPj9&_t    RPFVFPj9&_ufvFP %
3          .&NXf* PWQRU>   @  h> j>9&] us>@ ul>L |i>L |b>L w[>* L &D F +ȋѽ  ( B +V6H ^;s#  u>@ u
3ԡ( ]ZY_3 ~W>   @  h> j>9&]_f`.&N>9tJ.   0  h. j9&_ u0  t9а r   fa.>*N t&.(N! 9r & ӄt"Qf.>(N u8Pwh3Ɏظ O&.(N&G.*N[i Y3YÜSQ3ێËȋf.>(N tFwhf Of&9tY[9f.(Nf&I f.(N    3PQRv ! ˃ӈ&   .,N"X tZYXPQRv ! ˃.",N  
X tZYXUV3 Ӌ^]UV
 3P Yv  t2؃ Ӌ^]UVW  _^]Q  2sYÀ>[
 u[
Z
X
   Ð3ÐUPFX
uZ
5T
V
Z
 ÐX
Ð  t À>Z
 uFV+T
V
FVfT
f9FsfFf+T
f  fFfFfT
X
+9Vwr9FwF)X
fFfT
3ÐZ
 댐  RP>
 tZFh FFhlF* %F^9N u^P mhFNuhUÐ  PV>
 t7$
F 8Ft)F ~ t$ $* ^ÐU+ҋFF    PRt$TEVh ?	-t-,t  PWVf~  ~  FN ^~&&Q#2#222##;u;u3Fsf9 u^&&Q99^~&&Q;9u;9uo^_   V^f&f#2fF^f&f#2f;Ftif~ u99^ 3FsL2499u99t4^&&W99u99uFs99^ 24^ UfSfQfR?f3^f^ff;sf;wf;rf;vf;s@fZfYf[] SQrY[ PS [XUFFt%&?	u
h*&F^&? u UPF  ^F&*: .^F&*' .^F&* .q^*&    P
 +tF
 +0>U^&p^&Gf^&G\^&GR 
^&GC^&G9 ^&G*^&G  ^&G^&G	 ^&G
^&G^&G^&G
^&G^&G u32SQRu	s22ZY[SQRu	s22ZY[SQPRs2ZXPRZXY[  PF 
^F& FFNuF   2*&GÉF&? u2*&G F^&? uF^&? uFF+2u @tHH  \
  ^
\
t\
f&Gf`
&Gf
&Gd
-\
  ^
\
tk\
f&Gf`
&Gf
d
 @h
  d
td
d
37d
+2  2f
9h
u f>`
 uh4 áh
h
uf`
fj
+j
l
f6j
2+2 d
)3뫐URtt Ã>  u3u2&8Fu  V+ɉNFu3^^f&
 t&ws&G
&W&O
NF3^&GFF^&9wvfvhV u^&9GtS&G
uċFV^Ð  YVthn
V	 RP n
Ð t3Ð2&rhn
Ì UfVfWfSfQfRˋffV0 +N uf3lf3ffƉFfFfF / FlVfVvfF Fl^f^~fF F320fZfYf[f_f^] fSfQfVfWOfCORPfEDOMf    f    r'fCORPufEDOMuf=23AIt
f=46AIu   ff_f^fYf[h^_  F  f~ tF^F&? uF   fFV
fFFtf~ t^F&^F&
uFV   PfFV
fFFt*f~ t#~ ~Nt^F&^F&
uFV URPWV~FNFV^_ UPWV~vNFV
^_   PWVF  ~vNtFxF F^_   PWVF  ~vNF&%G<ar<zw, arzw :wr F  FF^_ US^FGFGWwGg
oF GFGWFGOG2Cuԉ[3] [[2ҹ G;tWwGg
oogwww_ϒ  PFFV^*&'*&Oû@ &l &n f%  fPf  f#f#f#f#f#f#f#fXS@ & & [ÌUWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] UP$0F<9vFFÐSW ۋSR3.:uJGuZRƀt%@u20 tt
 t2r< u	ZXCu33_[ö΀Z^_SM_h^v_DMI_΀0}^a$PnP΀@^M_SYSID_  P3 f~ tf~ u'  f~ tܸ NtF&? tF^&^&+t   :  rX%  tK:  t
%  !&  $  s9r%  c6  r%  Z5  r5  rH6  9  L:   撰68BAR   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         fQf    fYfPfSfRfffff+f;wfZf[fXÃ=$  t
$ t$ þ  333  Cttûf;xx$    s
$ uPSf$ fHf3ffBff fHf3ffBʊ [XVSQ     $ k  r$ Y[^$   $    $  
t
$     È3   3       VWQ   33%   %     !!!!栰p桰桰桰Y_^               $        r      b  $  L  =$ I  $    f$    
   `"	{  =$   $    =$ t$ $ $ -   =P   rf$   * f$ $ X  ~  f=$ p  f$ $ $ X  f=$ J  f$ $ $ '$     $ 
$ =$ u	=$  w$      f=$   f$ $ $ :$ $ O  $ 
$ =$  t  $ =$ u	=$  w$      f=$ s  f$ f$ 2  X  f=$ J  f$ f$ f    '  f=$   f$ f$        f=$   f$ f$ $   f=$   f$ f$ f$ f  f=$   f$ f$ $ w  f$ $ 7  ]  f=$ O  f$ $ $ <$ $   r5$ 
$ =$  t:  $ =$ u	=$  w$ $       f$ $    7     f=$    f$ $ f     f=$    f$ $ wf$ u  9  bf=$ uXf$ $ $ Cf=$ u9f$ $  -  $ f$         f$ f=$ 	r	f$   N    s 撰 ' ' >' ' ( >( o( ( ( ( ) 9) ) ) ) ) * 4* S* z* S[ÈPRfz.ZXfPfRfx < fZfXSRfy$$8u4@Z[fP$4fXPSR$ @
 $  fxfzfytEsZ[Xfz.fyu&sZ[XSR=$ tO$ @
 fyf@t	s/fxfz,fyB@u	sfz.Z[                                   P , M , M , P , P , P 	, P , M 	,  ,  ?- CD001%eO %eO %eL %eO %eO %	eO %	*PO% eO % eO pv        r(f  }(E (f~   r
Z  uf]4Q    ro  rh      rW  rPfF
 t  rA    r5{  t'  +  rm  ruJ  r      Y1  r:.  r3b    r'  r fF
 tB  rg  6  ro  {     fF
 u     u    PSRW   ـ?GWЃs{fE4OE E
 fF
 tNuI3һ   U0, Sд*e8e4w*e4E4*2t*܊e
UuUuE_Z[XEsQU   m E]YRfPXt$UW:  =F/   _]sN  rf  ZPXZPR  f2ffBfBfBZXQRVf    fo^ZYPRffBZXSQR=G,      f~U     N      w3          fF
 tO     E ZEMe4  rn  tff"  r\[   rUfF
 u%=, <0sB< r=G, , '0, K8Nt
t=, C<u#$ZY[SQRPfX   f~f     _      D          fF
 t`  r}E MyH  re  uf2f!ffع   f   f  r.Ǵt%ttt t	t2ZY[PXSRf~NZ[SQR   sV<t<)t
<(uI=$ u@WU=q1     ]_Ί~fE  rrh  uZY[Ü` f~E ]aPRfZXPSRf f2fZ[XPfF
 tWEtM+PfXE fu	E
+fF
 ufmmfuE
tM
fXSf} t@S}]}]]}]}EE
E fEfEfE  [   t<"u<"tVw~^RPff 쨀XtUWy  =A3    _]sf  ZP쨀XZ=$ tUW:  =3 p   _]sf $  PRfZXÀ=$ P$   XRfPXu$UW:  =3    _]s   rf  ZP$<XZ`3ttKaPRft!$!"f$  ZXRr)Pf@XuUW  =J4 _]sf ZP$@<@XZRPfXt0f좍   uu@uu u2ZSQ
tUf f8vJ؈]}mMmMˈMmMmf؈]}*Ċ]
]E
 fE  Y[         `   fE4%$ aQ}5Jr}5Mwtf 5- f5- !- YPUNNNO$ONNO$ O'NNO$O#NONX     lFpoypvp @  쨀tYRfZ @  쨀t	c7     fmRfZ     55 uf
-  
f
-        Q$  sYa  ޿`     t  r@Y8Y1  |  fCfz     3   r    F   r   rR   fPfSfRf*fff,fff*ff3f uUN0NONfOufZf[fXúvpf  ftRffZf=tPSQ   P  XsHuY[Xfu ff;uPSQRWf  	ufz  3f} f ff ff frf%fGff;wf} _ZY[X        =      5  =  (  QS$    P $ O r$$
t   $ uf f  [$  @$ <   br$
tf f  $  Sf  P[rKSUU*UUUUU*U[P$ p  r
<uf f  SQR      <`u
     wr   $ tZY[$  fPSUU*UUU[fX$    pr
8uf f            PSQRf8fff`f  N$ffN$
fffظ  Nf$fN$
ff        =$  u ZY[XPRSf8fff f  N$ffN$
fff  Nf$fN$
ff[ZXfP >>?<u>>?<t>>?tĀ fXð>>?      2ff fff戰䈽!@   戰O     戰   戰䈻  @      @      u׾C%   C%   u戰f @KC8BBaaff fKua$aff fKuf f u           Ԃ  Ӌ؂  Ԃ      PԂ  Ԃ  VQN   `  Ԃ  aQ  J   W  ܂  Ԃ  Y^ð   Ԃ  ӻ    Ff~NV3fn6PSQWU$< u'V;wȋˀt^+w   VQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FY<    PQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYQVՊ^FYX^P%       X
t	]_Y[X戰U`]uMMU3һ  ZfMuQuUMMYfsV       "Ȁ𬪁   r    C   r    M^tLuMuQuUMMYжsMuQuUMMYMtC   r    aP	 %"XP 
   `"	XË                                                    `   $ff$
$0ظ   $ff$
Њ   $ff$
$3ظ   $ff$
ЊvaÐ            f  f  f  f f f f TDDf f  D/f f  Ef f  Ef     fHt쨎t<w.$f ffH$tt
                                         F          <     D                 D                 D                 D          x0     D     ?     0     D                D                 D                 D                D                F          P     D  `              F      X     F          \     D                D                D  1              D                E  <             D                D               E  @             E                D           @     F             D                D          T     F               D               E                E                E                 F             D          @     D         F   9    E8        E0      `  .   U       .   "       /           .   #       /           .   $       /          .          /   	       .   `       /           .   a       /   >       .   0       /          .          >          ?                  E       <qfUMf%f  $f$
tPppqtAfNUff   $f $
и f  $f$
аf  X$fX$
и f  \$f\$
аfUff.~ f"   f%" 3f  f  gf. ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 pV	 f
   `"f  f3f30	f  f%
  u% t
 غf  fVfV|ff  fغf  f﹖ WfW@ff  f  gff   `ffffgf   p$fp$
Ћfgff   xffffgf   $f$
Ћfgf   $f$
Њfgf   $f$
Њf   $f$
Њfgf   ƺ$f$
Ћfgf   ĺ$f$
Ћfgf   $f$
Ћfgf   $f$
Њff|  fff
   fgNf   ~$f~$
Њgf   |$f|$
Њf   }$f}$
ЊgNf   $f$
Њf|  fff%ff   $f$
$@f_Yf   fzYff   =u;f3ffff%  0ff?  0fF  0ff  0=u f%  2f%0f  2f%0fY]ff  @$f@$
= u$<]2f7Zff  @$f@$
и f  D$fD$
аf  $f$
аf  $f$
и <fZf% = ufZf fZnf % ugf [TfU../0./.f([,f d< ufC[fd< t<t
u掰fk[f䎊f}[ff[f掺<uf[f  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfl  vf3f3f   0fAf  vfffP  0fX  0f3f3fA0fh  fffl  0fA0fA0fA0f   f f    0f  f f   0f  2f
   0f    UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
~] t
^+;wUN&NNO'NN ONf  X$fX$
и f  \$f\$
а08$     3ذf f  fff   t! tf  tf f3f  f<vn2ɵ|^rVtT<tq^t`^t	ـݵ^u<t^g<Hu	ـ݀rfffffffs sf;uff
怼$_f   u3 F_u#;sݰ怼n_};tMfa   ufa   ufa  f   f_g.:vfG_q< tg.:vPfa   ufa   ufa  f   f	_6< tg.:vfG
` g.:v fGff   gf.f
f;w
fffb   ufa   ufa  `` g.:v0f   tff   g.:Gvfg.:GvdfG` g.:vfg.:GvBfG`kg.:vfg.:Gv!`L$< t<w=C  B  Ba  a  Kuas6 .va<tH$tt
䠢
t@fغ  ff% f؀f   ttf   ff% f;r       uu uuuu      `p`p2PP<xxF&<<-ZZ400$HH*~2nf|  fff
   fغf|  fff ty	f  f3f  0 f%"	f  2f%   f  f N  ffȺf  f
 b	 f
   `"f  f3f30	f  f%
  u% t
 غf  fbf)  fݺf  ff  fff$ ff$ fffݼRcfs_cy2sG怿scuŁ$<r
ffŰ怼cj怼cr~	f  ffs2fs+f`  fnf  f~fn2ff32  tkfsdf  f	f`  fff*	f  ffƊf+Ëff`  fffﰥ怊f   @tŀr&`f   $f$
2f3f怼d}f   @us	f   @ffsJfsC~f  ff`  fffÊffغf`  fff^efj(  def  fغf  ff  ef   tec怼e>f|  fff%fغf|  fff("f|  fff
    fغf|  ffff  f%غf  ff  fغf  ff  fغf  ff  fغf  ff  ff """ff  f""f  f"f  fJ	f  f3f  0 f%"	f3f`  ffff3f3gff  ff  ff    ff  f  f  f f  fغf  ff  f
 غf  ff  fغf  f	 f
   `"f  f3f30	f|  ffff    f|  fff~.u;t~.\`f   $f$
Њs.\nf   $f$
Њŀcwf   $f$
Њ݋侨~.uC;t.\pf   $f$
$
Êغf   $f$
Њ
i"%t8t9fص,i %t8t% صLif~f  f<vnf  fغf  f￤if   if;!  ifG!  ifq!  if!  if"  if"  if^$  if%  if>%  f  fغf  ff   $jUf  .f  f怿Jjf_   ff   f|  fffff|  ffff|  ffffff|  fffgff|  fffff f|  fffff   rff   gffgfff|  fffff@f|  fffgff|  fffff0f|  ffffff%   fgf.l  f   ffsff   gfff|  fffff f|  fffff   rff   gffgfff|  fffff`f|  fffgfgfgfgfgfgfgfgff|  fffff0f|  ffffff%   fgf.l  gfff|  fffffpf|  fffgf XV X     ff|  ffnf%fغf|  fffff3nnfp  fff%   tf   fnn tf   fnf`  f<  f3ff f@  ffLs  fȎgff   u	f   f~ffftf`  ff%   ffغf`  ff%   ff;uf`  fffff8 f%   ffff f@  ffLs  fȎgff   u	f   f~ffftf`  fff%  f*2ffغf`  ff%   ff;lf  f
 غf  ff  ff  fȺf  f	f  f3f  0 f%"	f`  f<  f3ff fLs  ff    tfL{  f   f    fHf3Ҽof   fHf3Ҽof   fHf3Ҽof    uf   fHozf   u
f   kf~fffSf`  ff%   ffغf`  ff%   ff;f`  fffff8f%   ffff fLs  ff    tfL{  f   f    fHf3Ҽp f   fHf3Ҽp f   fHf3Ҽpx f    uf   fHq] f   u
f   kf~fffSf`  fff%  f*2ffغf`  ff%   ff;	f|  fff5   fغf|  ffff   t]f    f2   qr ws < ur ws 3r ws 㹸f  q|f  f u	 f
   `"f  f3f   0	~f|  fffr ws 3ff?   fL{  sf3f    f fL|  s)gf&?  ffff uf   xfsfL}  s>f uf   fgf&;ukfffgf&? uWfffmHf~  s!f@   gfgf&;u+fffugf&;ufff(fH                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               @                                                          @                                                          @                                                          @                                                  @                                                          @                                                          @                                                          @                                                                                                                                           WW                                                UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU   
 
 
    
 
 
                                   ' ~                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ~戰䈽ֽհf'-f1=Ұf=fGZ԰fSf]Ͱfifs=2ff ffԽ<հff fˇf ׇհfqf԰f[fְfHf f"f @ f.f.~ f"  ؎ f%" 3؎ P_ -pqt]  f3f3.Àt uau[u8u.T.D@t	."D	
 .T.D@t	.#D	 .Tf.D@t
fff.#D	fftrf.Tu>u.D@tg.."D	
g.J.T.D@tg..#D	g.+.Tf.D@tfgf.f.#D	fgf..T
I                                                  s6 .d<tH$tt
䠢f  ffff  @ f  ffff  ff   ff  fffff  ffff  ffff   g(
g(33s
uuf,  g
g3f  f   ug.
f@   u f   uʀ f   ug.
Qfŀ   u f   u f   u
g.
Qg.
Qf.  g g8f3s0s
؋Bts
t	ffff  g. f3fȴ2 uf  f  g. 
f0  g(
g(#f1  g(
g(#f2  g(
g(3f3  g(
g(f4  g(
g(f5  g(
g(fX  g(
g(f\  f%
 'Ⱥf\  ff3ff%   ffff%   ffff%   ff tf    uf   3	f   ff   f
f3.߉f3.fff3f   t.ǉffʺfx  fff% fȺfx  ffff3f   u	f   f    u	f 0@f 0@~ wfwff|  fff%?fȺf|  ffff3ɱ u
 u2f@   tfŀ   tf   tf   t2f  g.f3ɱ u
 u2ff%   f
f  g.
f   g.
f  f% غf  f uK uK.f  f$
Ⱥf  f
Ձ 
f   tf3 u t=f
   f3.ffȺf  fff%fȺf  fff               08/17/04BRA  