<html>
<!-- $RCSfile: MS-DACTL.TPL $ $Revision: 1.2 $ -->
<!-- (C) Copyright 2003 Hewlett-Packard Development Company, L.P. -->
<head>
<title>Drive Array Controller Information</title>

<script language="JavaScript">
   writeAccess = (2 & <!cpqDaCntlrBlinkTime.access>) != 0;
   if (writeAccess) noAutoRefresh = 1;
</script>

<!#/COMMON/JPN/PAGETAGS.TPL>

<script language="JavaScript">
contextHelp = true;

<!cpqDaCntlrEntry>
<!cpqDaAccelEntry>
<!cpqDaCntlrPerfEntry>

<!#/COMMON/JPN/COND.JS>
<!#/COMMON/JPN/STDITEMS.JS>
<!#/COMMON/JPN/TABLES.JS>
<!#/COMMON/JPN/PARSEARG.JS>
<!#/COMMON/DISPBASE.JS>
<!#DAENUMS.JS>
<!#MS-DACMN.JS>

function getIndex(form, CtlIndex)
{
   form.INDEX.value = parseInt(CtlIndex);
   return true;
}
</script>
</head>
<script language="JavaScript">

writeBodyHead();

idx = 0;
cntlrIdx = findArg("index");

if (cntlrIdx == -1)
{
   parseArgs(tryPrevPage());
   cntlrIdx = findArg("index");
}
for (idx = 0; idx < cpqDaCntlrEntry.length; idx++)
{
   if (cpqDaCntlrEntry[idx].cpqDaCntlrIndex == cntlrIdx)
      break;
}
if (idx >= cpqDaCntlrEntry.length)
{
   reportMissingArgs();
}
else
{
   perfData = null;

   for (i = 0; i < cpqDaCntlrPerfEntry.length; i++)
   {
      if (cpqDaCntlrPerfEntry[i].cpqDaCntlrPerfCntlrIndex == cntlrIdx)
      {
         perfData = cpqDaCntlrPerfEntry[i];
         break;
      }
   }
   postfix["cpqDaCntlrPerfCpuPercentBusy"] = "%";
   postfix["cpqDaCntlrPerfCommandCount"]   = "/b";
   postfix["cpqDaCntlrPerfAvgLatency"]     = "/10000 b";

   writePageHead("AC Rg[", "/WEBAGENT/IMAGES/MASSHDR.GIF", "AC Rg[");
   thisCntlr = cpqDaCntlrEntry[idx];
   duplexed = false;

   if (typeof(cpqDaCntlrEntry[idx].cpqDaCntlrCurrentRole != "undefined") &&
       cpqDaCntlrEntry[idx].cpqDaCntlrCurrentRole != null &&
       cpqDaCntlrEntry[idx].cpqDaCntlrCurrentRole != "")
   {
      duplexed = true;
   }
   cntlrCondition = new cpqCondition(cpqDaCntlrEntry[idx].cpqDaCntlrBoardCondition);
   writeTableLabel(cntlrCondition.image() + daCntlrBoardName(idx));
   writeTableHead();

   if (thisCntlr.cpqDaCntlrModel < 5)
   {
      // IDA controller, limited info in this table
      writeSingleTableRow("f:",
         displayItem("cpqDaCntlrModel", thisCntlr.cpqDaCntlrModel));
      writeSingleTableRow("t@[EFA o[W:",
         displayItem("cpqDaCntlrFWRev", thisCntlr.cpqDaCntlrFWRev));
   }
   else    // SMART controller
   {
      if (perfData == null)  // no perf data found for this controller
      {
         cpuUsage   = "N/A";
         cmdCount   = "N/A";
         cmdLatency = "N/A";
      }
      else
      {
         cpuUsage   = displayItem("cpqDaCntlrPerfCpuPercentBusy",
            perfData.cpqDaCntlrPerfCpuPercentBusy);
         cmdCount   = displayItem("cpqDaCntlrPerfCommandCount",
            perfData.cpqDaCntlrPerfCommandCount);
         cmdLatency = displayItem("cpqDaCntlrPerfAvgLatency",
            perfData.cpqDaCntlrPerfAvgLatency);
      }
      writeSingleTableRowInDoubleTable(
         "f:", displayItem("cpqDaCntlrModel", thisCntlr.cpqDaCntlrModel));

      if (duplexed)
      {
         writeDoubleTableRow(
            "Rg[ Xe[^X:", displayItem("cpqDaCntlrBoardStatus", thisCntlr.cpqDaCntlrBoardStatus),
            "__V [h:",   displayItem("cpqDaCntlrRedundancyType", thisCntlr.cpqDaCntlrRedundancyType));
         writeDoubleTableRow(
            "݂̖:",     displayItem("cpqDaCntlrCurrentRole", thisCntlr.cpqDaCntlrCurrentRole),
            "__V G[:", displayItem("cpqDaCntlrRedundancyError", thisCntlr.cpqDaCntlrRedundancyError));
      }
      writeDoubleTableRow(
         "t@[EFA o[W:", thisCntlr.cpqDaCntlrFWRev,
         "CPU p:",        cpuUsage);
      writeDoubleTableRow(
         "irW:", thisCntlr.cpqDaCntlrProductRev,
         "R}h JEg:",    cmdCount);
      writeDoubleTableRow(
         "VAԍ:",   displayItem("cpqDaCntlrSerialNumber", thisCntlr.cpqDaCntlrSerialNumber),
         "R}h:", cmdLatency);
      writeDoubleTableRow(
         "ADGCl[u Xe[^X:", displayItem("cpqDaCntlrAccessModuleStatus", thisCntlr.cpqDaCntlrAccessModuleStatus),
         "h[^{[h ^Cv:", displayItem("cpqDaCntlrDaughterBoardType", thisCntlr.cpqDaCntlrDaughterBoardType));
      writeDoubleTableRow(
         "č\z Dx:", displayItem("cpqDaCntlrRebuildPriority", thisCntlr.cpqDaCntlrRebuildPriority),
         "|[g:",  displayItem("cpqDaCntlrNumberOfBuses", thisCntlr.cpqDaCntlrNumberOfBuses));
      writeDoubleTableRow(
         "g Dx:", displayItem("cpqDaCntlrExpandPriority", thisCntlr.cpqDaCntlrExpandPriority),
         "", "");
   }
   writeTableTail();

   // Display accelerator information
   accelIdx = -1;
   for (i = 0; i < cpqDaAccelEntry.length; i++)
   {
      if (cpqDaAccelEntry[i].cpqDaAccelCntlrIndex == cntlrIdx &&
          cpqDaAccelEntry[i].cpqDaAccelStatus != 2)
      {
         accelIdx = i;
         break;
      }
   }
   if (accelIdx >= 0 && accelIdx < cpqDaAccelEntry.length)
   {
      thisAccel = cpqDaAccelEntry[accelIdx];
      thisAccelCondition = new cpqCondition(thisAccel.cpqDaAccelCondition);

      postfix["cpqDaAccelMemory"] = "KB";
      postfix["cpqDaAccelReadMemory"] = "KB";
      postfix["cpqDaAccelTotalMemory"] = "KB";

      if ((typeof(thisAccel.cpqDaAccelReadCachePercent) != "undefined") &&
          (thisAccel.cpqDaAccelReadCachePercent != MAXCOUNT))
      {
         readCache  = thisAccel.cpqDaAccelReadCachePercent  + "%";
         writeCache = thisAccel.cpqDaAccelWriteCachePercent + "%";
      } else {
         readCache  = displayItem("cpqDaAccelReadMemory", thisAccel.cpqDaAccelReadMemory);
         writeCache = displayItem("cpqDaAccelMemory", thisAccel.cpqDaAccelMemory);
      }
      document.write("<br>");
      writeTableLabel(thisAccelCondition.imageSmall()+"ANZ[^", "ANZ[^");
      writeTableHead();
      writeDoubleTableRow(
         "Xe[^X:",         displayItem("cpqDaAccelStatus", thisAccel.cpqDaAccelStatus),
         "obe Xe[^X:", displayItem("cpqDaAccelBattery", thisAccel.cpqDaAccelBattery));
      writeDoubleTableRow(
         "VAԍ:", displayItem("cpqDaAccelSerialNumber", thisAccel.cpqDaAccelSerialNumber),
         "Ǎ݃G[:",   displayItem("cpqDaAccelReadErrs", thisAccel.cpqDaAccelReadErrs));
      writeDoubleTableRow(
         "v:",  displayItem("cpqDaAccelTotalMemory", thisAccel.cpqDaAccelTotalMemory),
         "݃G[:",  displayItem("cpqDaAccelWriteErrs", thisAccel.cpqDaAccelWriteErrs));
      writeDoubleTableRow(
         "Ǎ݃LbV:",  displayItem("cpqDaAccelReadMemory", thisAccel.cpqDaAccelReadMemory),
         "G[ R[h:",  displayItem("cpqDaAccelErrCode", thisAccel.cpqDaAccelErrCode));
      writeDoubleTableRow(
         "݃LbV:", displayItem("cpqDaAccelMemory", thisAccel.cpqDaAccelMemory),
         "sǃf[^:",    displayItem("cpqDaAccelBadData", thisAccel.cpqDaAccelBadData));
      writeTableTail();
   }

   if (thisCntlr.cpqDaCntlrBlinkTime != "" && thisCntlr.cpqDaCntlrBlinkTime < 4294967295)
   {
      document.write("<br>");
      writeTableLabel("hCu");
      writeTableHead();
      if (thisCntlr.cpqDaCntlrBlinkTime > 1)
          imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'>";
       else
          imgStr = "<img src='/WEBAGENT/CQMGSTOR/ENG/DRIVE.GIF' width='72' height='42' border='0'>";

      if (thisCntlr.cpqDaCntlrCurrentRole == 4)  // Backup
      {
         document.write("<tr><td align='center' width='30%'>" + imgStr + "</td>",
            "<td><small>̃obNAbvRg[ɎtĂhCuʂɂ́A",
            "ANeBuȃRg[IĂBڂ<i>wv</i>QƂĂB",
            "</small></td></tr>");
      }
      else if (writeAccess)
      {
         actionStr = "MS-DACTL.TPL?index=" + cntlrIdx;
         if (thisCntlr.cpqDaCntlrBlinkTime > 1)
            document.write("<tr><form action='", actionStr, "' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisCntlr.cpqDaCntlrIndex);'>",
              "<input type='hidden' name='TABLESET' value='1'><input type='hidden' name='INDEX' value=''>",
              "<input type='hidden' name='cpqDaCntlrBlinkTime' value='1'><td align='center' width='50%'>",
              "<img src='/WEBAGENT/CQMGSTOR/ENG/DRVBLINK.GIF' width='72' height='42' border='0'></td>",
              "<td align='center'><input type='submit' value='~'></td></form></tr>");
         else  // Not blinking
            document.write("<tr><form action='", actionStr, "' method='POST' target='_self' ",
              "onSubmit='return getIndex(this, thisCntlr.cpqDaCntlrIndex);'>",
              "<td align='center' width='50%'><input type='hidden' name='TABLESET' value='1'>",
              "<input type='hidden' name='INDEX' value=''><small>hCuCg_</small>",
              "<select name='cpqDaCntlrBlinkTime'>",
              "<option value='600'>1 <option value='1200'>2 <option value='1800'>3 ",
              "<option value='2400'>4 <option value='3000' selected>5 <option value='6000'>10 ",
              "<option value='12000'>20 <option value='18000'>30 <option value='24000'>40 ",
              "<option value='30000'>50 <option value='36000'>1 </select></td>",
              "<td align='center'><input type='submit' value='Jn'></td>",
              "</form></tr>");
      }
      else  // Read only
      {
         document.write("<tr><td align='center' width='30%'>" + imgStr + "</td>",
            "<td><small>Ǘ҂܂̓Iy[^݂̂A",
            "hCuʂ̂߂ɃhCuCg_ł邱Ƃł܂Bڂ<b>wv</b>QƂĂB",
            "</small></td></tr>");
      }
      writeTableTail();
   }
}
writeBodyTail();
</script>
</html>

