// $RCSfile: MS-DACMN.JS $ $Revision: 1.3 $

function boxName(idx)
{
   var name = "";
   var box = cpqSsDrvBoxEntry[idx];

   if (box.cpqSsBoxPlacement == 2)
   {
      name = "";
   }
   else if (box.cpqSsBoxPlacement == 3)
   {
      name = "O";
   }
   name = "|[g" + box.cpqSsBoxBusIndex + " - " + name + "Xg[WVXe";
   return name;
}
function storageSysName(idx, port)
{
   var i = parseInt(idx) + 1;
   var name = "Xg[WVXe ";
   name += cpqSsChassisEntry[idx].cpqSsChassisName;
   name = "|[g" + port + " - " + name;
   return name;
}
function logDrvName(idx)
{
   var drive = cpqDaLogDrvEntry[idx];
   var name = "_hCu " + drive.cpqDaLogDrvIndex;

   if (drive.cpqDaLogDrvFaultTol == 2)
   {
      name += " - tH[ggXȂ";
   }
   else if (drive.cpqDaLogDrvFaultTol > 2)
   {
      name += " - " + displayItem("cpqDaLogDrvFaultTol", drive.cpqDaLogDrvFaultTol);
   }
   return name;
}
function phyDrvName(idx)
{
   var i;
   var drive = cpqDaPhyDrvEntry[idx];
   var size = parseInt(drive.cpqDaPhyDrvSize, 10);
   var name = "|[g" + drive.cpqDaPhyDrvBusNumber + " - hCu" + drive.cpqDaPhyDrvBay;

   if (!isNaN(size) && size > 0)
   {
      name += " (" + drive.cpqDaPhyDrvSize + " MB)";
   }
   if (drive.cpqDaPhyDrvConfigurationStatus == 3)
   {
      name += " - ݒ";
   }
   else
   {
      for (i = 0; i < cpqDaSpareEntry.length; i++)
      {
         if (cpqDaSpareEntry[i].cpqDaSpareCntlrIndex == drive.cpqDaPhyDrvCntlrIndex &&
             cpqDaSpareEntry[i].cpqDaSparePhyDrvIndex == drive.cpqDaPhyDrvIndex)
         {
            name += " - XyA";
         }
      }
   }
   return name;
}
function daCntlrBoardName(idx)
{
   var rc = displayItem("cpqDaCntlrModel", cpqDaCntlrEntry[idx].cpqDaCntlrModel) + " Rg[";

   if (cpqDaCntlrEntry[idx].cpqDaCntlrHwLocation != "")
   {
      if (cpqDaCntlrEntry[idx].cpqDaCntlrHwLocation == "Slot 0")
         rc = "VXe{[h - " + rc;
      else
         rc = cpqDaCntlrEntry[idx].cpqDaCntlrHwLocation + " - " + rc;
   }
   else if (cpqDaCntlrEntry[idx].cpqDaCntlrSlot == 0)
   {
      rc = "VXe{[h - " + rc;
   }
   else
   {
      rc = "Xbg" + cpqDaCntlrEntry[idx].cpqDaCntlrSlot + " - " +rc;
   }
   return rc;
}
function daCntlrName(idx)
{
   var name = daCntlrBoardName(idx);

   with(cpqDaCntlrEntry[idx])
   {
      if (typeof(cpqDaCntlrCurrentRole) != "undefined")
      {
         if (cpqDaCntlrCurrentRole == 3 && cpqDaCntlrPartnerSlot != -1)
         {
            if (cpqDaCntlrPartnerSlot == 0)
               name = "VXe{[h - " + name;
            else if (cpqDaCntlrSlot == 0)
               name = "Xbg" + cpqDaCntlrPartnerSlot + " - " + name;
            else
               name += " - " + cpqDaCntlrPartnerSlot;
         }
         if ((cpqDaCntlrCurrentRole == 3 || cpqDaCntlrCurrentRole == 4) &&
              cpqDaCntlrPartnerSlot == -1)
         {
            if (cpqDaCntlrRedundancyType == 3)
               name += " - ̑T[o";
            else
               name += " - s";
         }
      }
   }
   return name;
}
function compileDaCondition()
{
   this.state = 1;  // reset to unknown
   this.update(cpqDaCntlrEntry[this.index].cpqDaCntlrCondition);
}
function daTapeDriveIndex(cntlr, bus, id)
{
   for (idx = 0; idx < cpqDaTapeDrvEntry.length; idx++)
   {
      if (cpqDaTapeDrvEntry[idx].cpqDaTapeDrvCntlrIndex == cntlr &&
          cpqDaTapeDrvEntry[idx].cpqDaTapeDrvBusIndex == bus &&
          cpqDaTapeDrvEntry[idx].cpqDaTapeDrvScsiIdIndex == id)
         break;
   }
   return idx;
}
function daTapeDriveName(i)
{
   var name = "";
   if (i < cpqDaTapeDrvEntry.length)
   {
      name  = cpqDaTapeDrvEntry[i].cpqDaTapeDrvName +
            " - oX " + cpqDaTapeDrvEntry[i].cpqDaTapeDrvBusIndex +
            " hCu" + cpqDaTapeDrvEntry[i].cpqDaTapeDrvScsiIdIndex;
   }
   return name;
}
function daTapeLibraryName(i)
{
   var name = cpqDaTapeLibraryEntry[i].cpqDaTapeLibraryModel +
        " - oX " + cpqDaTapeLibraryEntry[i].cpqDaTapeLibraryScsiBus +
        " foCX " + cpqDaTapeLibraryEntry[i].cpqDaTapeLibraryScsiTarget;
   return name;
}
function hotPlugGraphic()
{
   return ("<IMG SRC='/WEBAGENT/CQMGSTOR/JPN/HOTPLUG.JPG' ALIGN='MIDDLE' WIDTH='11' HEIGHT='15' HSPACE='3' BORDER='0'> ");
}
function daDriveCapacity(item, size)
{
   var rc = parseInt(size, 10);

   if (isNaN(rc) || rc <= 0)
   {
      rc = "N/A";
   } else {
      rc = displayItem(item, size);
   }
   return rc;
}
