/* _NVRM_COPYRIGHT_BEGIN_
 *
 * Copyright 1993-2001 by NVIDIA Corporation.  All rights reserved.  All
 * information contained herein is proprietary and confidential to NVIDIA
 * Corporation.  Any use, reproduction, or disclosure without the written
 * permission of NVIDIA Corporation is prohibited.
 *
 * _NVRM_COPYRIGHT_END_
 */

#ifndef _NV_MISC_H_
#define _NV_MISC_H_

#include "nvtypes.h"
#include "rmretval.h"

#ifndef VOID
#define VOID            void
#endif
#ifndef BOOL
#define BOOL            S032
#endif
#ifndef TRUE
#define TRUE            1L
#endif
#ifndef FALSE
#define FALSE           0L
#endif
#ifndef NULL
#define NULL            0L
#endif

/*
 * Power of 2 alignment.  (Will give unexpected results if 'a' is not
 * a power of 2.)
 */

#define NV_ALIGN_DOWN(v, gran) ((v) & ~((gran) - 1))
#define NV_ALIGN_UP(v, gran)   (((v) + ((gran) - 1)) & ~((gran)-1))

#define NV_ALIGN_PTR_DOWN(p, gran) \
        ((void *) NV_ALIGN_DOWN(((NV_UINTPTR_T)p), (gran)))

#define NV_ALIGN_PTR_UP(p, gran)   \
        ((void *) NV_ALIGN_UP(((NV_UINTPTR_T)p), (gran)))

#define NV_PAGE_ALIGN_DOWN(value) NV_ALIGN_DOWN((value), RM_PAGE_SIZE)
#define NV_PAGE_ALIGN_UP(value)   NV_ALIGN_UP((value), RM_PAGE_SIZE)

/*
 * Device state and configuration information
 */

typedef void *PHWINFO;


#endif /* _NV_MISC_H_ */
