#!/bin/bash

function error {
  echo "$(basename $0): fatal error, $1 failed"
  exit 1
}

modconf=""
mktemp=`which mktemp || echo touch`
tmp=`$mktemp -q /tmp/nvidia.XXXXXX` || error "mktemp"

paths=" /etc/modutils/aliases    \
        /etc/modules.conf        \
        /etc/conf.modules        "

for path in $paths; do
  test -f $path && modconf=$path
done

if [ ! -z $modconf ]; then
   sed '/^alias.*\(NVdriver\|nvidia\)/d'  < $modconf   > $tmp
   if [ -c /dev/.devfsd ]; then
     echo "alias /dev/nvidia*   nvidia" >> $tmp
   else
     echo "alias char-major-195 nvidia" >> $tmp
   fi
   mv $tmp $modconf
   test -x /sbin/update-modules && /sbin/update-modules
else
  if [ -f /etc/rc.d/rc.modules ]; then
    sed '/.*\(NVdriver\|nvidia\).*/d' < /etc/rc.d/rc.modules > $tmp
    echo -e "\n/sbin/modprobe nvidia" >> $tmp
    mv $tmp /etc/rc.d/rc.modules
    chmod 755 /etc/rc.d/rc.modules
  fi
fi

if [ ! -c /dev/.devfsd ]; then
  for i in 0 1 2 3 4 5 6 7; do
	node="/dev/nvidia$i"
	rm -f $node
    mknod $node c 195 $i || error "mknod \"$node\""
    chmod 0666 $node     || error "chmod \"$node\""
  done
  node="/dev/nvidiactl"
  rm -f $node        
  mknod $node c 195 255  || error "mknod \"$node\""
  chmod 0666 $node       || error "chmod \"$node\""
fi

exit 0
