#!/bin/bash

PATH=/bin:/usr/bin:/sbin

package="nvidia"
driver_rev="1.0-4431"
gfx_base_dir="/opt/hp/graphics"
package_dir="${gfx_base_dir}/${package}"

function usage {
    echo "config"
}

# Check for proper kernel headers before we build.

        if [ ! -e /usr/src/linux-2.4 ]; then
	    echo " "
	    echo "Error: Linux kernel source required for this installation."
	    echo "       Please install RPM kernel-source-2.4.18[*].ia64.rpm" 
	    echo "       and rerun this install script afterwards"
	    echo " "
	    exit;
	fi

# Save the existing X and OpenGL stuff.

        for file in /usr/lib/libGL.* \
                    /usr/lib/libGLCore.* \
                    /usr/X11R6/lib/libGL.*  \
                    /usr/X11R6/lib/libGLCore.*  \
                    /usr/X11R6/lib/modules/extensions/libGLCore.* \
                    /usr/X11R6/lib/modules/extensions/libglx.*
        do
            if [ -e "${file}" ]; then
                mkdir -m755 -p "${package_dir}/save/"`dirname "${file}"`
                mv -f "${file}" "${package_dir}/save/${file}"
            fi
        done

# Install nVidia libraries & driver

	cp nvidia_kernel_4431.tgz ${package_dir}/.
	cp nvidia_glx_4431.tgz ${package_dir}/.
	cd ${package_dir}
        tar xzvf ./nvidia_kernel_4431.tgz
        tar xzvf ./nvidia_glx_4431.tgz
        cd ${package_dir}/NVIDIA_kernel-1.0-4431
        make install
        cd ${package_dir}/NVIDIA_GLX-1.0-4431
        make install
        
        sed '/^alias.*char-major-.*nvidia/d' < /etc/modules.conf > /etc/modules.conf.tmp
        echo "alias char-major-195 nvidia" >> /etc/modules.conf.tmp
        mv -f /etc/modules.conf.tmp /etc/modules.conf
        sed '/^install.*nvidia.*insmod.*-x.*nvidia/d' < /etc/modules.conf > /etc/modules.conf.tmp
        mv -f /etc/modules.conf.tmp /etc/modules.conf
        sed '/NVdriver/d' < /etc/modules.conf > /etc/modules.conf.tmp
        mv -f /etc/modules.conf.tmp /etc/modules.conf

        ldconfig
        depmod -a

# Force X to point to XFree86
        if [ -e "/etc/X11/X" ]; then
	    rm /etc/X11/X
        fi
	ln -s /usr/X11R6/bin/XFree86 /etc/X11/X

# Get Nvidia-specific XF86Config file
	if [ ! -e "/etc/X11/XF86Config.nvidia" ]; then
	    cp /usr/share/doc/NVIDIA_GLX-1.0/XF86Config.sample /etc/X11/XF86Config.nvidia
	fi


	if [ -e "/etc/X11/XF86Config-4" ]; then
	    mv /etc/X11/XF86Config-4 /etc/X11/XF86Config-4.orig
	    echo " "
	    echo "You already have an XF86Config-4 file in /etc/X11"
	    echo "I've moved it to XF86Config-4.orig so I can put"
   	    echo "one with the proper options for the accelerated"
	    echo "Nvidia driver in it's place"
	    echo " "
	fi
	ln -s  /etc/X11/XF86Config.nvidia /etc/X11/XF86Config-4
	

exit 0
