#!/bin/bash
# Script to configure a E-Class C-GbE switch to pre-determined
# configuration
#
# Usage is
#
# cpqebcfr.sh  -i <I.P Address> -c <SNMP Community>

Usage()
{
echo "Error!!"
echo ""
echo "cpqebcfr.sh -i <I.P Address> -c <SNMP Community>"
exit -1
}

#
# Utility Functions to handle cpqswcfg
# Return Status
# HandleSuccess() and HandleError()
# Are called by HandleStatus() based
# On the Return Value of cpqswcfg
#

SaveSettings()
{

  echo "Switch-A Configuration Completed Succesfully"
  echo "Log file for this configuration is available in"
  echo "The file $LOGFILE"
  echo "Saving Configuration to NVRAM .."
  $CPQSWCFG reset nvram >/dev/null 2>&1; ret=`echo $?`
  wait
  HandleStatus $ret reset nvram

}

HandleError()
{
echo "Error: Failure in running the command $1 $2 $3" >> $LOGFILE
echo "Exiting Script">> $LOGFILE
exit -1
}

HandleSuccess()
{
echo "Command $1 $2 $3 Completed Succesfully" >> $LOGFILE
}

HandleStatus()
{
      if [ $1 != 0 ]
      then
	# Call Error Handler with rest of arguments
         HandleError $2 $3 $4
      else
	# Call Success Handler with rest of arguments
         HandleSuccess $2 $3 $4
      fi
}

Wait_For_Switch_Reboot()
{
echo -n "Waiting for switch to reboot.  Hit CTRL-C for long delay "
sleep 60	# ping hangs forever if started with switch down

ret=1
while [ $ret != 0 ]
do
	echo -n "."
	/bin/ping -c 2 -i 1 $ipaddr >/dev/null 2>/dev/null	
	ret=$?
done
echo " Switch is alive"
}

Issue_Switch_Reset()
{
echo "***************************************************************"
echo "                       WARNING!"
echo "***************************************************************"
echo "	Switch must be reset to factory defaults for this"
echo "	script to execute correctly. "
echo "	The current I.P Address will however be preserved"
echo "	after the switch reset"
echo "***************************************************************"
echo "If you do not want to reset the switch to factory defaults, press"
echo "N, n, no or No to continue without resetting the switch"
echo "Default action is to reset the switch to factory defaults"
echo "***************************************************************"
read choice
echo $choice | egrep "N|n|no|No" > /dev/null
	if [ $? != 0 ]
	then
		echo -n "Resetting switch to factory defaults.."
		$CPQSWCFG reset def_noIP  > /dev/null 2>&1
		wait
		echo " Done"
	fi
}

#########################################
#
# MAIN FUNCTION STARTS HERE
#
#########################################
LOGFILE=/tmp/E_Class_Switch_A.log
FIRSTVLAN=1
SECONDVLAN=2


TEMP=`getopt -o i:c: --long i-long:c-long: \
     -n 'cpqebcfr.sh' -- "$@"`

if [ $? != 0 ] ; then echo "Terminating..." >&2 ; exit 1 ; fi

# Note the quotes around `$TEMP': they are essential!
eval set -- "$TEMP"

ipaddr=
while true ; do
        case "$1" in
                -i|--i-long) ipaddr=`echo "$2"` ; shift 2 ;;
                -c|--c-long) community=`echo "$2"` ; shift 2 ;;
                #-i|--i-long)  shift 2 ;;
                --) shift ; break ;;
                *) echo "Internal error!" ; exit 1 ;;
        esac
done

if [ "$ipaddr" = "" ]
then
	Usage
fi

if [ "$community" = "" ]
then
	Usage
fi

#
#
# Indicate to the user where the log files are created
#
echo "***********************************************************"
echo ""
echo "The Output Log file for this script will be created as"
echo "			$LOGFILE"
echo ""
echo "***********************************************************"
# Create the first part of the command below

if [ ! -x ../cpqswcfg ]
then
   echo "Missing Configuration Tool ../cpqswcfg"
   echo "Please ensure that you have installed the Utilities"
   exit -1
fi

cd ..
CPQSWCFG="./cpqswcfg -i $ipaddr -c $community -d cpqpgbe"

# Reset Switch if user wants it.

Issue_Switch_Reset

# Wait for switch to get back on to the network. This needs
# To be called anyway for switch health verification

Wait_For_Switch_Reboot

# Start of actual config template generation happens her

#..........................STEP 1........................


# Create One Vlan with name as Mgmt_VLAN and VLAN ID as 1
# Create Second Vlan with name as NIC1_VLAN and VLAN ID as 2
# Set Egress masks on Vlan 1 for ports 21,22,23 and 24
# Set Egress masks on Vlan 2 for ports 1-20,25,26

echo -n "Creating New VLANs..."

egmask1=0x00000F00
egmask2=0xFFFFF0C0
fomask1=0x00000000
fomask2=0x00000F00
stmask1=0xFFFFFFC0
stmask2=0xFFFFFFC0

#
# Since Vlan 1 is already present for the switch as
# a default, we just need to modify it to our needs
#

#
# Let us create two non-default Vlan Id's for now
# Note that we use vlanModify for Vlan ID 1 since
# it already comes created default with the switch
#
$CPQSWCFG vlanModify $FIRSTVLAN Mgmt_VLAN $egmask1 $fomask1 $stmask1 >/dev/null 2>&1; ret=`echo $?`
wait
HandleStatus $ret vlanModify VlanName=Mgmt_VLAN

$CPQSWCFG vlanCreate $SECONDVLAN NIC1_VLAN $egmask2 $fomask2 $stmask2 >/dev/null 2>&1; ret=`echo $?`
wait
HandleStatus $ret vlanCreate VlanName=NIC1_VLAN

echo " Done"

#..........................END OF STEP 1........................
#..........................STEP 2........................

#Set PortName of port 1 to Server1_NIC1
#Set PortName of port 2 to Server2_NIC1
#Set PortName of port 3 to Server3_NIC1 ... and so on

#Assign Ports to Vlan's as explained in subsequent comments

#Make each Port untagged ( means set all option ) with accept and enable_gvrp 

#Enable STP on all 16 ports

#Configure each port to have flow control with 100 MBPS full duplex


echo -n "Configuring Ports .."
for i in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26
do
echo -n "$i "
case "$i" in 
	1) name="Server1_NIC1";;
        2) name="Server2_NIC1";;
        3) name="Server3_NIC1";;
        4) name="Server4_NIC1";;
	5) name="Server5_NIC1";;
        6) name="Server6_NIC1";;
        7) name="Server7_NIC1";;
        8) name="Server8_NIC1";;
	9) name="Server9_NIC1";;
        10) name="Server10_NIC1";;
        11) name="Server11_NIC1";;
        12) name="Server12_NIC1";;
	13) name="Server13_NIC1";;
        14) name="Server14_NIC1";;
        15) name="Server15_NIC1";;
        16) name="Server16_NIC1";;
        17) name="Server17_NIC1";;
        18) name="Server18_NIC1";;
        19) name="Server19_NIC1";;
        20) name="Server20_NIC1";;
	21) name="XConnect_1";;
        22) name="XConnect_2";;
        23) name="IA Mgmt Module";;
        24) name="Mgmt Uplink";;
        25) name="SwitchA_Uplink1";;
        26) name="SwitchA_Uplink2";;
	*) break;;
esac
#**********************************************************************
# Now, set the portname accordingly
#**********************************************************************
   $CPQSWCFG portName $i "$name" > /dev/null 2>&1 ; ret=`echo $?`
   wait
   HandleStatus $ret portName Port=$i "PortName=$name"

#**********************************************************************
# After setting the name, assign ports 1-20 and 25,26 to vlan1 and
# ports 21-24 to Vlan 2
#
#**********************************************************************

   echo $i | egrep -w "2[1-4]" > /dev/null 2>&1
   if [ $? = 0 ]
   then
      $CPQSWCFG vlanPort $i $FIRSTVLAN all accept disable_gvrp>/dev/null 2>&1; ret=`echo $?`
      wait
      HandleStatus $ret vlanPort "Port=$i" "Vlan=$FIRSTVLAN"
   else
      $CPQSWCFG vlanPort $i $SECONDVLAN all accept disable_gvrp>/dev/null 2>&1; ret=`echo $?`
      wait
      HandleStatus $ret vlanPort "Port=$i" "Vlan=$SECONDVLAN"
   fi

#**********************************************************************
# Enable stp on all 26 ports
#**********************************************************************

   $CPQSWCFG stpPort $i enable > /dev/null 2>&1 ; ret=`echo $?`
      wait
      HandleStatus $ret stpPort "Port=$i"

#**********************************************************************
#Configure each port to have flow control with 100 MBPS full Duplex
#For Ports 25 and 26, make the speed 1000 MBPS Full Duplex
#Since these settings are defaults, we will not do anything.
#**********************************************************************

#**********************************************************************
# Enable all the ports
#**********************************************************************

   $CPQSWCFG portStatus $i enable >/dev/null 2>&1; ret=`echo $?`
      wait
      HandleStatus $ret "Port=$i" enable
done
echo " Done"
SaveSettings

#..........................END OF STEP 2........................

