#!/bin/sh

if [ "`id -nu`" != "root" ]; then
	echo
        echo "ERROR: This script must be executed as the 'root' superuser."
        exit 1
fi

if [ -f ProLiant_eGbE_Interconnect_Switch_Documentation*.rpm ]; then
	echo
	echo "ProLiant e-GbE Interconnect Switch Documentation Installation, version 2.0.0"
	echo ========================================================================
	echo

	echo "Press N (Enter) to skip documentation install.  Press (Enter) to continue."

	read x
	if [ "$x" != "n" -a "$x" != "N" ]; then
		rpm -U --force ProLiant_eGbE_Interconnect_Switch_Documentation*.rpm
		rpm -qa | grep eGbE_Interconnect_Switch_Documentation > /dev/null
		if [ $? = 0 ]; then
			echo
			echo Installation to /usr/local/ProLiant/Interconnect_Switch/Documentation/e-GbE/version2.0.0 complete.
			echo
		else
			echo
			echo "ERROR: The following packages were not installed succesfully:"
			echo
			echo     ProLiant_eGbE_Interconnect_Switch_Documentation*.rpm
			echo
		fi
	fi
fi

echo
echo "ProLiant e-GbE Interconnect Switch Utilities Installation, version 2.0.0"
echo ========================================================================
echo
echo "NOTE: The switch configuration tool in this package, cpqswcfg, has been"
echo "deprecated.  Version 2.0 switch firmware provides a scriptable command line"
echo "interface for switch management.  See the User Guide for more information."
echo
echo
echo "Press N (Enter) to exit installation.  Press (Enter) to continue."

read x
if [ "$x" = "n" -o "$x" = "N" ]; then
	exit 1
fi

# check dependencies
dep=0
x="`rpm -qa | grep -i snmp`"
if [ $? = 0 ]; then
	echo $x | grep -i net-snmp > /dev/null
	p1=$?
	echo $x | grep -i ucd-snmp > /dev/null
	p2=$?
	echo $x | grep -i netsnmp > /dev/null
	p3=$?
	echo $x | grep -i ucdsnmp > /dev/null
	p4=$?

	if [ $p1 = 0 -o $p2 = 0 -o $p3 = 0 -o $p4 = 0 ]; then
		echo $x | grep -i snmp-utils > /dev/null
		if [ $? = 0 ]; then
			dep=1
		fi

		echo $x | grep -i snmputils > /dev/null
		if [ $? = 0 ]; then
			dep=1
		fi
	fi
fi

if [ $dep = 0 ]; then
	echo
	echo The switch configuration tool, cpqswcfg, requires the following
	echo SNMP packages be installed for the tool to manage the switch:
	echo
	echo "   net-snmp and net-snmp-utils"
	echo "             OR"
	echo "   ucd-snmp and ucd-snmp-utils"
	echo "             OR"
	echo "   ucdsnmp  and ucdsnmp-utils"
	echo
	echo This package installation will continue, but the above packages
	echo must be installed for correct operation of the \(deprecated\)
	echo switch configuration tool.
	echo
	echo
	echo "Press N (Enter) to exit installation.  Press (Enter) to continue."

	read x
	if [ "$x" = "n" -o "$x" = "N" ]; then
		exit 1
	fi
fi
		
rpm -U --force ProLiant_eGbE_Interconnect_Switch_Utilities*.rpm
rpm -qa | grep eGbE_Interconnect_Switch_Utilities > /dev/null
if [ $? = 0 ]; then
	echo
	echo Installation to /usr/local/ProLiant/Interconnect_Switch/Utilities/e-GbE/version2.0.0 complete.
	echo
	exit 0
else
	echo
	echo "ERROR: The following packages were not installed succesfully:"
	echo
	echo     ProLiant_eGbE_Interconnect_Switch_Utilities*.rpm
	echo
	exit 1
fi
