#!/bin/bash
# Script to configure a P-Class GbE switch to pre-determined
# configuration
#
# Usage is
#
# cpqpbcfr.sh  -i <I.P Address> -c <SNMP Community>

Usage()
{
echo "Error!!"
echo ""
echo "cpqpbcfr.sh -i <I.P Address> -c <SNMP Community>"
exit -1
}

#
# Utility Functions to handle cpqswcfg
# Return Status
# HandleSuccess() and HandleError()
# Are called by HandleStatus() based
# On the Return Value of cpqswcfg
#

SaveSettings()
{

  echo "Switch-A Configuration Completed Succesfully"
  echo "Log file for this configuration is available in"
  echo "The file $LOGFILE"
  echo "Saving Configuration to NVRAM .."
  $CPQSWCFG reset nvram >/dev/null 2>&1; ret=`echo $?`
  wait
  HandleStatus $ret reset nvram

}

HandleError()
{
echo "Error: Failure in running the command $1 $2 $3" >> $LOGFILE
echo "Exiting Script">> $LOGFILE
exit -1
}

HandleSuccess()
{
echo "Command $1 $2 $3 Completed Succesfully" >> $LOGFILE
}

HandleStatus()
{
      if [ $1 != 0 ]
      then
        # Call Error Handler with rest of arguments
         HandleError $2 $3 $4
      else
        # Call Success Handler with rest of arguments
         HandleSuccess $2 $3 $4
      fi
}

Wait_For_Switch_Reboot()
{
echo -n "Waiting for switch to be back on the network. "
/bin/ping -c 2 -i 1 $ipaddr >/dev/null 2>/dev/null
ret=$?
while [ $ret != 0 ]
do
        echo -n "."
        /bin/ping -c 2 -i 1 $ipaddr >/dev/null 2>/dev/null
        ret=$?
done
echo " Switch is alive"
}

Issue_Switch_Reset()
{
echo "***************************************************************"
echo "                       WARNING!"
echo "***************************************************************"
echo "  Switch must be reset to factory defaults for this"
echo "  script to execute correctly. "
echo "  The current I.P Address will however be preserved"
echo "  after the switch reset"
echo "***************************************************************"
echo "If you do not want to reset the switch to factory defaults, press"
echo "N, n, no or No to continue without resetting the switch"
echo "Default action is to reset the switch to factory defaults"
echo "***************************************************************"
read choice
echo $choice | egrep "N|n|no|No" > /dev/null
        if [ $? != 0 ]
        then
                echo -n "Resetting switch to factory defaults.."
                $CPQSWCFG reset def_noIP  > /dev/null 2>&1
                wait
                echo " Done"
        fi
}

#########################################
#
# MAIN FUNCTION STARTS HERE
#
#########################################
LOGFILE=/tmp/P_Class_Switch_A.log
FIRSTVLAN=1
SECONDVLAN=2

TEMP=`getopt -o i:c: --long i-long:c-long: \
     -n 'cpqpbcfr.sh' -- "$@"`

if [ $? != 0 ] ; then echo "Terminating..." >&2 ; exit 1 ; fi

# Note the quotes around `$TEMP': they are essential!
eval set -- "$TEMP"

ipaddr=
while true ; do
        case "$1" in
                -i|--i-long) ipaddr=`echo "$2"` ; shift 2 ;;
                -c|--c-long) community=`echo "$2"` ; shift 2 ;;
                #-i|--i-long)  shift 2 ;;
                --) shift ; break ;;
                *) echo "Internal error!" ; exit 1 ;;
        esac
done

if [ "$ipaddr" = "" ]
then
	Usage
fi

if [ "$community" = "" ]
then
	Usage
fi

# Create the first part of the command below

CPQSWCFG="/usr/local/Compaq/Interconnect_Switch/bin/cpqswcfg -i $ipaddr -c $community -d cpqpgbe"
if [ ! -x /usr/local/Compaq/Interconnect_Switch/bin/cpqswcfg ]
then
   echo "Missing Configuration Tool /usr/local/Compaq/Interconnect_Switch/bin/cpqswcfg"
   echo "Please ensure that you have installed the Tools Feature Correctly"
   exit -1
fi

# Reset Switch if user want's it.

Issue_Switch_Reset

# Wait for switch to get back on to the network. This needs
# To be called anyway for switch health verification

Wait_For_Switch_Reboot

# Start of actual config template generation happens here

#..........................STEP 1........................

# Create One Vlan with name as Mgmt_VLAN and VLAN ID as 1
# Create Second Vlan with name as Data_VLAN and VLAN ID as 2
# Set Egress masks on Vlan 1 for ports 1,3,5,7,9,11,13,15,17-20,23
# Set Egress masks on Vlan 2 for ports 2,4,6,8,10,12,14,16-18,21,22,24
# Create a Trunk called XConnect and assign ports 17 and 18 in the portmask

echo "Creating New Vlan's .."
egmask1=0xAAAAF200
egmask2=0x5555CD00
fomask1=0x00000000
fomask2=0x00000000
stmask1=0xFFFF3F00
stmask2=0xFFFF3F00
trmask1=0x00C00000

#
# Let us create two non-default Vlan Id's for now
# Note that we use vlanModify for Vlan ID 1 since
# it already comes created default with the switch
#
$CPQSWCFG vlanModify $FIRSTVLAN Mgmt_VLAN $egmask1 $fomask1 $stmask1 >/dev/null 2>&1; ret=`echo $?`
wait
HandleStatus $ret vlanModify VlanName=Mgmt_VLAN


$CPQSWCFG vlanCreate $SECONDVLAN Data_VLAN $egmask2 $fomask2 $stmask2 >/dev/null 2>&1; ret=`echo $?`
wait
HandleStatus $ret vlanCreate VlanName=Data_VLAN

echo " Done"
#..........................END OF STEP 1........................
#..........................STEP 2........................

#Set PortName of port 1 to Server1_NIC1
#Set PortName of port 2 to Server1_NIC2
#Set PortName of port 3 to Server2_NIC1 ... and so on

#Assign Ports to Vlan's with all odd numbered ports to Vlan 1
#and even numbered to Vlan 2

#Make each Port untagged ( means set all option ) with accept
#and leave gvrp as disabled since that is the default

#Enable STP on all 16 ports

#Configure each port to have flow control with 100 MBPS full duplex

echo -n "Configuring Ports .."
for i in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24
do
echo -n "$i "
case "$i" in 
	1) name="Server1_NIC1";;
        2) name="Server1_NIC2";;
        3) name="Server2_NIC1";;
        4) name="Server2_NIC2";;
	5) name="Server3_NIC1";;
        6) name="Server3_NIC2";;
        7) name="Server4_NIC1";;
        8) name="Server4_NIC2";;
	9) name="Server5_NIC1";;
        10) name="Server5_NIC2";;
        11) name="Server6_NIC1";;
        12) name="Server6_NIC2";;
	13) name="Server7_NIC1";;
        14) name="Server7_NIC2";;
        15) name="Server8_NIC1";;
        16) name="Server8_NIC2";;
        17) name="XConnect_1";;
        18) name="XConnect_2";;
        19) name="UpLink1_NIC1";;
        20) name="UpLink2_NIC1";;
        21) name="UpLink1_NIC2";;
        22) name="UpLink2_NIC2";;
        23) name="Frnt_Pnl_NIC1";;
        24) name="Frnt_Pnl_NIC2";;
	*) break;;
esac
#**********************************************************************
# Now, set the portname accordingly
#**********************************************************************
   $CPQSWCFG portName $i "$name" > /dev/null 2>&1 ; ret=`echo $?`
   wait
   HandleStatus $ret portName Port=$i "PortName=$name"

#**********************************************************************
# After setting the name, assign even ports to vlan1 and
# Odd ports to Vlan 2
#
# As Special conditions, ports 17-20,23 belong to Vlan 1 and
# Ports 17, 18, 21, 22 and 24 belong to Vlan 2
#
# Also Ports 17 and 18 need to be tagged
#**********************************************************************

   echo $i | egrep -w '1|3|5|7|9|11|13|15|19|20|23' > /dev/null 2>&1
   if [ $? = 0 ]
   then
      $CPQSWCFG vlanPort $i $FIRSTVLAN all accept disable_gvrp>/dev/null 2>&1; ret=`echo $?`
      wait
      HandleStatus $ret vlanPort "Port=$i" "Vlan=$FIRSTVLAN"
   fi
   echo $i | egrep -w '2|4|6|8|10|12|14|16|21|22|24' > /dev/null 2>&1
   if [ $? = 0 ]
   then
      $CPQSWCFG vlanPort $i $SECONDVLAN all accept disable_gvrp>/dev/null 2>&1; ret=`echo $?`
      wait
      HandleStatus $ret vlanPort "Port=$i" "Vlan=$SECONDVLAN"
   fi

   echo $i | egrep -w '17|18' > /dev/null 2>&1
   if [ $? = 0 ]
   then
      $CPQSWCFG vlanport $i $FIRSTVLAN tag accept disable_gvrp >/dev/null 2>&1; ret=`echo $?`
      wait
      HandleStatus $ret vlanPort "Port=$i" "Vlan=$FIRSTVLAN"
      $CPQSWCFG vlanport $i $SECONDVLAN tag accept disable_gvrp >/dev/null 2>&1; ret=`echo $?`
      wait
      HandleStatus $ret vlanPort "Port=$i" "Vlan=$SECONDVLAN"
   fi

#**********************************************************************
# Enable stp on all 24 ports
#**********************************************************************

    $CPQSWCFG stpPort $i enable > /dev/null 2>&1 ; ret=`echo $?`
    wait
    HandleStatus $ret stpPort "Port=$i"

#**********************************************************************
#Configure each port to have flow control with 100 MBPS full Duplex
#For Ports 21 and 22, make the speed 1000 MBPS Full Duplex
#Ignoring since these are the defaults anyway
#**********************************************************************
#**********************************************************************
# Enable all the ports
#**********************************************************************


    $CPQSWCFG portStatus $i enable >/dev/null 2>&1; ret=`echo $?`
    wait
    HandleStatus $ret "Port=$i" enable
done
echo " Done"
SaveSettings
#..........................END OF STEP 2........................
