#!/bin/sh
# Copyright 2002, Compaq Computer Corporation.  All rights reserved.
# SNMP Security Vulnerability Update for Red Hat Linux 7.2
# Version 1.0.0
#
SPNUM="sp19715"
SNMPVER="4.2.3"
SNMPREL="1.7.2.3"

installsnmpd() {
  # $1: snmpd filename
  echo
  echo -n "Stopping running snmpd ..."
  echo -n "Stopping running snmpd ..." >>$INFOFILE
  $RCPREFIX/snmpd stop >/dev/null 2>&1
  echo done
  echo done >>$INFOFILE
  if [ ! -f /usr/sbin/snmpd.orig.$SPNUM ]; then
    echo
    echo -n "Saving /usr/sbin/snmpd to /usr/sbin/snmpd.orig.$SPNUM ..."
    echo -n "Saving /usr/sbin/snmpd to /usr/sbin/snmpd.orig.$SPNUM ..." >>$INFOFILE
    mv /usr/sbin/snmpd /usr/sbin/snmpd.orig.$SPNUM
    if [ $? = 0 ]; then
      echo done
      echo done >>$INFOFILE
    else
      echo "ERROR: move /usr/sbin/snmpd to /usr/sbin/snmpd.orig.$SPNUM failed!"
      echo "ERROR: move /usr/sbin/snmpd to /usr/sbin/snmpd.orig.$SPNUM failed!">>$INFOFILE
      echo "`date`: Exiting $0!" >>$INFOFILE
      return 1
    fi
  fi
  echo
  echo -n "Installing new snmpd ($1) as /usr/sbin/snmpd ..."
  echo -n "Installing new snmpd ($1) as /usr/sbin/snmpd ..." >>$INFOFILE
  cp $1 /usr/sbin/snmpd
  chmod +x /usr/sbin/snmpd
  echo done
  echo done >>$INFOFILE
  echo
  echo -n "Starting new snmpd ..."
  echo -n "Starting new snmpd ..." >>$INFOFILE
  $RCPREFIX/snmpd start
  if [ $? = 0 ]; then
    echo "done."
    echo "done." >>$INFOFILE
    return 0
  else
    echo "failed!"
    echo "failed!" >>$INFOFILE
    return 1
  fi
}

savesnmpdconf() {
  if [ -f /etc/snmp/snmpd.conf ]; then
     cp /etc/snmp/snmpd.conf /etc/snmp/snmpd.conf.$SPNUM
  fi
}

restoresnmpdconf() {
  if [ -f /etc/snmp/snmpd.conf.$SPNUM ]; then
     rm -f /etc/snmp/snmpd.conf
     mv /etc/snmp/snmpd.conf.$SPNUM /etc/snmp/snmpd.conf
  fi
}

removesavedsnmpdconf() {
  if [ -f /etc/snmp/snmpd.conf.$SPNUM ]; then
     rm -f /etc/snmp/snmpd.conf.$SPNUM
  fi
}

freshensnmprpms() {
  echo "Start Installing (Freshening) ucd-snmp $SNMPVER-$SNMPREL RPMs..."
  echo "Start Installing (Freshening) ucd-snmp $SNMPVER-$SNMPREL RPMs..." >>$INFOFILE
  savesnmpdconf
  rpm -Fvh ucd-snmp-devel-$SNMPVER-$SNMPREL.i386.rpm \
           ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm \
           ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm
  if [ $? = 0 ]; then
    echo "Successfully installed (freshened) ucd-snmp $SNMPVER-$SNMPREL RPMs."
    echo "Successfully installed (freshened) ucd-snmp $SNMPVER-$SNMPREL RPMs." >>$INFOFILE
    restoresnmpdconf
  else
    echo "Failed to install (freshen) ucd-snmp $SNMPVER-$SNMPREL RPMs."
    echo "Failed to install (freshen) ucd-snmp $SNMPVER-$SNMPREL RPMs." >>$INFOFILE
    echo "`date`: Exiting $0!" >>$INFOFILE
    removesavedsnmpdconf
    exit 1
  fi
  # just in case NO ucd-snmp RPM is installed
  rpm -q ucd-snmp-$SNMPVER-$SNMPREL >/dev/null 2>&1
  if [ ! $? = 0 ]; then
    echo "Start Installing ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm..."
    echo "Start Installing ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm..." >>$INFOFILE
    rpm -Uvh ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm
    if [ $? = 0 ]; then
      echo "Successfully installed ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm."
      echo "Successfully installed ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm." >>$INFOFILE
      restoresnmpdconf
    else
      echo "Failed to install ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm."
      echo "Failed to install ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm." >>$INFOFILE
      echo "`date`: Exiting $0!" >>$INFOFILE
      removesavedsnmpdconf
      exit 1
    fi
  fi

  rpm -q ucd-snmp-utils-$SNMPVER-$SNMPREL >/dev/null 2>&1
  if [ ! $? = 0 ]; then
    echo "Start Installing ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm..."
    echo "Start Installing ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm..." >>$INFOFILE
    rpm -Uvh ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm
    if [ $? = 0 ]; then
      echo "Successfully installed ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm."
      echo "Successfully installed ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm." >>$INFOFILE
    else
      echo "Failed to install ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm."
      echo "Failed to install ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm." >>$INFOFILE
      echo "`date`: Exiting $0!" >>$INFOFILE
      exit 1
    fi
  fi
  # Configure the snmpd RC script
  if [ -x /sbin/chkconfig ]; then
    /sbin/chkconfig --add snmpd
    for i in 1 2 3 4 5 6; do
      ls /etc/rc.d/rc$i.d/S[0-9][0-9]cmafdtn >/dev/null 2>&1
      [ "$?" = "0" ] && /sbin/chkconfig --level $i snmpd on
    done
  fi
}

if [ `id -un` != "root" ]; then
  echo "ERROR: this script can be executed by \"root\" only!"
  exit 1
fi

RCPREFIX="/etc/init.d"

TMPROOT="/var/spool/compaq/foundation/tmp"
if [ ! -d $TMPROOT/$SPNUM ]; then
  mkdir -p $TMPROOT/$SPNUM
  chmod go-rwx $TMPROOT
  chmod go-rwx /var/spool/compaq/foundation
  chmod go-rwx /var/spool/compaq
fi

INFOFILE="$TMPROOT/$SPNUM/$SPNUM.info"

echo "" >> $INFOFILE
echo "###############################################################" >> $INFOFILE
echo "`date`: $0 started!" >>$INFOFILE

# Change current directory
DIR=`dirname $0`
if [ ! -z "$DIR" ]; then
  cd $DIR
  if [ ! $? = 0 ]; then
    echo "ERROR: cd to \"$DIR\" failed!"
    echo "`date`: Exiting $0!" >>$INFOFILE
    exit 1
  fi
else
  DIR="."
fi

SOFTPAQDIR=`pwd`
# Check for files
FILES="$SPNUM.txt \
         $SPNUM.sh \
         cmaX.c \
         cmaX.h \
         read_config.c \
         ucd-snmp-$SNMPVER-$SNMPREL.src.rpm \
         ucd-snmp-devel-$SNMPVER-$SNMPREL.i386.rpm \
         ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm \
         ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm"
ERROR=0
for i in $FILES
do
  if [ ! -f ./$i ]; then
    ERROR=1
    echo "ERROR: ./$i does not exists! Un-tar $SPNUM.tgz and try again."
    echo "ERROR: ./$i does not exists! Un-tar $SPNUM.tgz and try again." >>$INFOFILE
  fi
done

if [ $ERROR != 0 ]; then
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

# Check for the Red Hat Linux 7.2
grep "Red Hat.* 7\.2 " /etc/issue >/dev/null 2>&1
if [ "$?" != 0 ]; then
  echo "ERROR: Only Red Hat Linux release 7.2 is supported by this Softpaq!"
  echo "ERROR: Only Red Hat Linux release 7.2 is supported by this Softpaq!" >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

# Check for the verion number of CMA
CMAFDTNVER=`rpm -q --qf '%{VERSION}' cmafdtn 2>/dev/null`
if [ "$?" != 0 -o -z "$CMAFDTNVER" ]; then
  echo "ERROR: Compaq Management Agents are NOT installed!"
  echo "ERROR: Compaq Management Agents are NOT installed!" >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

#
if [ "$CMAFDTNVER" != "5.30.0" ]; then
  echo "WARNING: Compaq Management Agents version 5.30.0 is required for Red Hat"
  echo "         Linux 7.2! Currently, Compaq Foundation Agents (cmafdtn) version"
  echo "         $CMAFDTNVER is installed!"
  echo "         Download 5.30.0 agents from following web site and upgrade them!"
  echo "           http://www.compaq.com/support/files/server/us/index.html"

  echo "WARNING: Compaq Management Agents version 5.30.0 is required for Red Hat" >>$INFOFILE
  echo "         Linux 7.2! Currently, Compaq Foundation Agents (cmafdtn) version" >>$INFOFILE
  echo "         $CMAFDTNVER is installed!" >>$INFOFILE
  echo "         Download 5.30.0 agents from following web site and upgrade them!" >>$INFOFILE
  echo "           http://www.compaq.com/support/files/server/us/index.html" >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

# Check install (freshen) of ucd-snmp binary RPMs
rpm -Fvh --test ucd-snmp-devel-$SNMPVER-$SNMPREL.i386.rpm \
               ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm \
               ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm \
               ucd-snmp-$SNMPVER-$SNMPREL.src.rpm

if [ ! $? = 0 ]; then
  echo "ERROR: Can't install (freshen) following ucd-snmp RPMs!"
  echo "       ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm"
  echo "       ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm"
  echo "       ucd-snmp-devel-$SNMPVER-$SNMPREL.i386.rpm"
  echo "ERROR: Can't install (freshen) following ucd-snmp RPMs!" >>$INFOFILE
  echo "       ucd-snmp-$SNMPVER-$SNMPREL.i386.rpm" >>$INFOFILE
  echo "       ucd-snmp-utils-$SNMPVER-$SNMPREL.i386.rpm" >>$INFOFILE
  echo "       ucd-snmp-devel-$SNMPVER-$SNMPREL.i386.rpm" >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

# Check for gcc
which gcc >/dev/null 2>&1
if [ $? = 0 ]; then
 GCCOK=yes
else
 echo "Warning: \"gcc\" RPM is not installed on your system!"
 echo "Warning: \"gcc\" RPM is not installed on your system!" >>$INFOFILE
 GCCOK=no
fi

# Check for autoconf
which autoconf >/dev/null 2>&1
if [ $? = 0 ]; then
  AUTOCONFOK=yes
else
  echo "Warning: \"autoconf\" RPM is not installed on your system!"
  echo "Warning: \"autoconf\" RPM is not installed on your system!" >>$INFOFILE
  AUTOCONFOK=no
fi

if [ $GCCOK = "no" -o $AUTOCONFOK = "no" ]; then
  echo "ERROR: You must install the missing RPM(s) and rerun this script."
  echo -n "Press Enter to continue ..."
  read ANS
  exit 1
fi

# Now we can freshen ucd-snmp RPMs and rebuild/install snmpd!

freshensnmprpms

# Install Source RPM
echo "Start installing ucd-snmp source RPM..."
echo "Start installing ucd-snmp source RPM..." >>$INFOFILE
rpm -ivh ucd-snmp-$SNMPVER-$SNMPREL.src.rpm
if [ $? = 0 ]; then
  echo "Successfully installed the ucd-snmp source RPM."
  echo "Successfully installed the ucd-snmp source RPM." >>$INFOFILE
else
  echo "Failed to installed the ucd-snmp source RPM."
  echo "Failed to installed the ucd-snmp source RPM." >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

#
PREFIX="/usr/src/redhat/BUILD/ucd-snmp"
UCDSNMPNAME="ucd-snmp"
SNMPSPECSDIR="/usr/src/redhat/SPECS"
SNMPSPECFILE="ucd-snmp.spec"
SNMPSRCDIR="/usr/src/redhat/SOURCES"
SNMPSRCTARFILE="ucd-snmp-$SNMPVER.tar.gz"
SNMPSRCTARDIR="ucd-snmp-$SNMPVER"
SNMPSRCPATCHFILES="ucd-snmp-4.2-ia64.patch \
                   ucd-snmp-4.2-rpm40.patch \
                   ucd-snmp-4.2.1-libtool.patch \
                   ucd-snmp-4.2.1-manpage.patch \
                   ucd-snmp-4.2.1-security3.patch \
                   ucd-snmp-4.2.1-tests_num.patch \
                   ucd-snmp-4.2.1-walk.patch \
                   ucd-snmp-$SNMPVER-snmpnetstat.patch"

SNMPSRCPATCHFROMCOMPAQ=$SOFTPAQDIR/read_config.c




# Check if UCD SNMP source RPM is installed
SRCRPMINSTALLED="yes"
if [ ! -f $SNMPSRCDIR/$SNMPSRCTARFILE ]; then
  SRCRPMINSTALLED="no"
fi
for i in $SNMPSRCPATCHFILES; do
  [ -z "$i" ] && continue
  if [ ! -f $SNMPSRCDIR/$i ]; then
    SRCRPMINSTALLED="no"
  fi
done
if [ ! -f $SNMPSPECSDIR/$SNMPSPECFILE ]; then
  SRCRPMINSTALLED="no"
fi

if [ $SRCRPMINSTALLED = "yes" ]; then
  echo "Proper UCD SNMP source RPM is installed on this system!" >>$INFOFILE
  echo "Proper UCD SNMP source RPM is installed on this system!"
  sleep 1
else
  echo "Failed to validate the ucd-snmp source RPM."
  echo "Failed to validate the ucd-snmp source RPM." >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

echo "Start preparing the source files and patches ..."
echo "Start preparing the source files and patches ..." >>$INFOFILE
rpm -bp $SNMPSPECSDIR/$SNMPSPECFILE
if [ $? = 0 ]; then
  echo "Successfully prepared the source files and patches."
  echo "Successfully prepared the source files and patches." >>$INFOFILE
else
  echo "Failed to prepare the source files and patches."
  echo "Failed to prepare the source files and patches." >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

SRCROOT="${PREFIX}-$SNMPVER"
cd $SRCROOT
if [ $? != 0 ]; then
  echo
  echo "ERROR: \"cd $SRCROOT\" failed!"
  echo "ERROR: \"cd $SRCROOT\" failed!" >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

if [ ! -f ./configure ]; then
  echo
  echo "ERROR: \"$SRCROOT/configure\" script does not exist!"
  echo "ERROR: \"$SRCROOT/configure\" script does not exist!" >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

ERROR=0
for i in $SOFTPAQDIR/cmaX.c \
         $SOFTPAQDIR/cmaX.h \
         $SNMPSRCPATCHFROMCOMPAQ \
         $RCPREFIX/snmpd \
         /usr/sbin/snmpd; \
         do
  if [ ! -f "$i" ]; then
    echo
    echo "ERROR: \"$i\" does not exist!"
    echo "ERROR: \"$i\" does not exist!" >>$INFOFILE
    ERROR=1
  fi
done

if [ "$ERROR" = "1" ]; then
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

echo
echo "Ready to rebuild snmpd, source directory is `pwd`"
echo "Ready to rebuild snmpd, source directory is `pwd`" >>$INFOFILE
echo -n "Press Enter to continue ... "
read ANS

mv ./snmplib/read_config.c ./snmplib/read_config.c.orig.$SPNUM
cp $SNMPSRCPATCHFROMCOMPAQ ./snmplib/read_config.c
if [ "$?" != 0 ]; then
  echo "ERROR: Copying $SNMPSRCPATCHFROMCOMPAQ failed!"
  echo "ERROR: Copying $SNMPSRCPATCHFROMCOMPAQ failed!" >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

cp $SOFTPAQDIR/cmaX.[ch] ./agent/mibgroup
if [ "$?" != 0 ]; then
  echo "ERROR: Copying $SOFTPAQDIR/cmaX.[ch] failed!"
  echo "ERROR: Copying $SOFTPAQDIR/cmaX.[ch] failed!" >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

./configure --disable-shared --with-mib-modules="cmaX" --with-ldflags="-lpthread" --prefix=/usr <<EOF





EOF

make

NEWSNMPDEXE="agent/snmpd"

if [ ! -f $NEWSNMPDEXE ]; then
  echo
  echo "ERROR: rebuild \"$SRCROOT/$NEWSNMPDEXE\" failed!"
  echo "       Please rerun this script and redirect output to a file with"
  echo "       following command: "
  echo "             # ./$SPNUM 2>&1 | tee $SPNUM.out"
  echo "ERROR: rebuild \"$SRCROOT/$NEWSNMPDEXE\" failed!" >>$INFOFILE
  echo "       Please rerun this script and redirect output to a file with" >>$INFOFILE
  echo "       following command: " >>$INFOFILE
  echo "             # ./$SPNUM 2>&1 | tee $SPNUM.out" >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

strings $NEWSNMPDEXE | grep "Compaq Management Agents eXtension" >/dev/null 2>&1
if [ "$?" != 0 ]; then
  echo
  echo "ERROR: rebuild \"$SRCROOT/$NEWSNMPDEXE\" failed!"
  echo "       new snmpd does not contain cmaX!"
  echo "       Please rerun this script and redirect output to a file with"
  echo "       following command: "
  echo "             # ./$SPNUM 2>&1 | tee $SPNUM.out"
  echo "ERROR: rebuild \"$SRCROOT/$NEWSNMPDEXE\" failed!" >>$INFOFILE
  echo "       new snmpd does not contain cmaX!" >>$INFOFILE
  echo "       Please rerun this script and redirect output to a file with" >>$INFOFILE
  echo "       following command: " >>$INFOFILE
  echo "             # ./$SPNUM 2>&1 | tee $SPNUM.out" >>$INFOFILE
  echo "`date`: Exiting $0!" >>$INFOFILE
  exit 1
fi

echo
echo "\"snmpd\" had been successfully rebuilt!"
echo "\"snmpd\" had been successfully rebuilt!" >>$INFOFILE

while true; do
  echo
  echo -n "Do you want to replace /usr/sbin/snmpd with new snmpd (y/n)? "
  echo -n "Do you want to replace /usr/sbin/snmpd with new snmpd (y/n)? " >>$INFOFILE
  read ANS
  echo "ANS=$ANS" >>$INFOFILE

  case "$ANS" in
    y|Y)
       break
       ;;
    n|N)
       echo "`date`: Exiting $0!" >>$INFOFILE
       exit 1
       ;;
  esac
done

installsnmpd $NEWSNMPDEXE

echo "============================================================="
echo "$0 completed successfully!"
echo "See the bottom of $INFOFILE for more information!"
echo "============================================================="
echo "$0 completed successfully!" >>$INFOFILE
exit 0
