Summary: A collection of SNMP protocol tools from UC-Davis.
Name: ucd-snmp
Version: 4.2.3
Release: 1.7.1.3
License: BSDish
Group: System Environment/Daemons
Source0: ftp://ucd-snmp.ucdavis.edu/ucd-snmp-%{version}.tar.gz
Source1: ucd-snmpd.init
Source2: ucd-snmp.redhat.conf
Source3: ucd-snmpd.logrotate
Source4: ucd5820stat
Patch0: ucd-snmp-4.2-rpm40.patch
Patch1: ucd-snmp-4.2-ia64.patch
Patch2: ucd-snmp-4.2.1-manpage.patch
Patch3: ucd-snmp-4.2.1-walk.patch
Patch4: ucd-snmp-4.2.1-security3.patch
Patch5: ucd-snmp-4.2.1-tests_num.patch
Patch6: ucd-snmp-4.2.1-libtool.patch
Patch7: ucd-snmp-4.2.3-snmpnetstat.patch
Prereq: /sbin/chkconfig
Obsoletes: cmu-snmp
BuildRoot: %{_tmppath}/%{name}-root
BuildPrereq: tcp_wrappers

%define __libtoolize /bin/true

%{expand: %%define _includedir	%{_includedir}/%{name}}

%description
SNMP (Simple Network Management Protocol) is a protocol used for
network management. The UCD-SNMP project includes various SNMP tools:
an extensible agent, an SNMP library, tools for requesting or setting
information from SNMP agents, tools for generating and handling SNMP
traps, a version of the netstat command which uses SNMP, and a Tk/Perl
mib browser. This package contains the snmpd and snmptrapd daemons,
documentation, etc.

You will probably also want to install the ucd-snmp-utils package,
which contains UCD-SNMP utilities.

%package utils
Group: Applications/System
Summary: Network management utilities using SNMP, from the UCD-SNMP project.
Requires: ucd-snmp = %{version}
Obsoletes: cmu-snmp-utils

%description utils
The ucd-snmp package contains various utilities for use with the
UCD-SNMP network management project.

Install this package if you need utilities for managing your network
using the SNMP protocol. You will also need to install the ucd-snmp
package.

%package devel
Group: Development/Libraries
Summary: The development environment for the UCD-SNMP project.
Requires: ucd-snmp = %{version}
Obsoletes: cmu-snmp-devel

%description devel
The ucd-snmp-devel package contains the development libraries and
header files for use with the UCD-SNMP project's network management
tools.

Install the ucd-snmp-devel package if you would like to develop
applications for use with the UCD-SNMP project's network management
tools. You'll also need to have the ucd-snmp and ucd-snmp-utils
packages installed.

%prep
%setup -q
%patch0 -p1 -b .rpm40
%patch1 -p1 -b .ia64
%patch2 -p1 -b .manpage
%patch3 -p1 -b .walk
%patch4 -p1 -b .security3
%patch5 -p1 -b .tests_num
%patch6 -p1 -b .libtool
%patch7 -p1 -b .snmpnetstat

%build
autoreconf

# First build the static library
# XXX remove privacy support?
%configure \
	--enable-static --enable-shared			\
	--with-cflags="$RPM_OPT_FLAGS"			\
	--with-sys-location="Unknown"			\
	--with-logfile="/var/log/snmpd.log"		\
	--with-persistent-directory="/var/ucd-snmp"	\
	--with-mib-modules="host agentx smux"		\
	--enable-reentrant				\
	--with-libwrap=/usr/lib				\
	--sysconfdir=%{_sysconfdir}			\
	--enable-ipv6					\
	--with-sys-contact="root@localhost"


make

%install
rm -rf ${RPM_BUILD_ROOT}
%makeinstall

install -d ${RPM_BUILD_ROOT}%{_sysconfdir}/snmp
install -m 644 %SOURCE2 ${RPM_BUILD_ROOT}%{_sysconfdir}/snmp/snmpd.conf

install -d ${RPM_BUILD_ROOT}%{_sysconfdir}/rc.d/init.d
install -m 755 %SOURCE1 ${RPM_BUILD_ROOT}%{_sysconfdir}/rc.d/init.d/snmpd

install -m 755 %SOURCE4 ${RPM_BUILD_ROOT}%{_bindir}/ucd5820stat

install -d ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d
install -m 644 %{SOURCE3} ${RPM_BUILD_ROOT}%{_sysconfdir}/logrotate.d/snmpd

%post
/sbin/ldconfig
/sbin/chkconfig --add snmpd 

%preun
if [ $1 = 0 ]; then
   service snmpd stop >/dev/null 2>&1
   /sbin/chkconfig --del snmpd
   # remove stale autogenerated file
   rm -f %{_datadir}/snmp/mibs/.index
fi

%postun
/sbin/ldconfig
if [ "$1" -ge "1" ]; then
    service snmpd condrestart >/dev/null 2>&1 || :
fi

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root,-)
%doc	AGENT.txt COPYING ChangeLog EXAMPLE.conf FAQ NEWS PORTING README* TODO
%doc	local/passtest local/README.mib2c local/ipf-mod.pl

%dir	%{_sysconfdir}/snmp
%config(noreplace,missingok) %{_sysconfdir}/snmp/snmpd.conf

%config(noreplace) %{_sysconfdir}/rc.d/init.d/snmpd

%dir	%{_datadir}/snmp
%dir	%{_datadir}/snmp/mibs
%attr(0644,root,root)	%{_datadir}/snmp/mibs/*
%dir	%{_datadir}/snmp/snmpconf
%dir	%{_datadir}/snmp/snmpconf/snmp.conf
%dir	%{_datadir}/snmp/snmpconf/snmpd.conf
%dir	%{_datadir}/snmp/snmpconf/snmptrapd.conf
%attr(0644,root,root)	%{_datadir}/snmp/snmpconf/snmp.conf/*
%attr(0644,root,root)	%{_datadir}/snmp/snmpconf/snmpd.conf/*
%attr(0644,root,root)	%{_datadir}/snmp/snmpconf/snmptrapd.conf/*

%{_libdir}/libsnmp.so.*
%{_libdir}/libucdagent.so.*
%{_libdir}/libucdmibs.so.*

%{_sbindir}/snmpd
%{_sbindir}/snmptrapd
%attr(0644,root,root)	%{_mandir}/man1/snmpd.1*
%attr(0644,root,root)	%{_mandir}/man[58]/*

%files utils
%defattr(-,root,root,-)
%{_bindir}/encode_keychange
%{_bindir}/mib2c
%{_bindir}/snmpbulkget
%{_bindir}/snmpbulkwalk
%{_bindir}/snmpcheck
%{_bindir}/snmpconf
%{_bindir}/snmpdelta
%{_bindir}/snmpdf
%{_bindir}/snmpget
%{_bindir}/snmpgetnext
%{_bindir}/snmpinform
%{_bindir}/snmpnetstat
%{_bindir}/snmpset
%{_bindir}/snmpstatus
%{_bindir}/snmptable
%{_bindir}/snmptest
%{_bindir}/snmptranslate
%{_bindir}/snmptrap
%{_bindir}/snmpusm
%{_bindir}/snmpwalk
%{_bindir}/snmpvacm

%attr(0644,root,root)	%{_mandir}/man1/snmpbulkwalk.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpbulkget.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpcmd.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpdelta.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpdf.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpget.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpgetnext.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpinform.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpnetstat.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpset.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpstatus.1*
%attr(0644,root,root)	%{_mandir}/man1/snmptable.1*
%attr(0644,root,root)	%{_mandir}/man1/snmptest.1*
%attr(0644,root,root)	%{_mandir}/man1/snmptranslate.1*
%attr(0644,root,root)	%{_mandir}/man1/snmptrap.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpusm.1*
%attr(0644,root,root)	%{_mandir}/man1/snmpwalk.1*

%files devel
%defattr(0644,root,root,0755)
%{_libdir}/libsnmp.so
%{_libdir}/libsnmp.a
%{_libdir}/libsnmp.la
%{_libdir}/libucdagent.so
%{_libdir}/libucdagent.a
%{_libdir}/libucdagent.la
%{_libdir}/libucdmibs.so
%{_libdir}/libucdmibs.a
%{_libdir}/libucdmibs.la

%{_includedir}
%attr(0644,root,root)	%{_mandir}/man3/*

%changelog
* Mon Jan 07 2002 Phil Knirsch <pknirsch@redhat.com>
- Included the Axioma Security Research fix for snmpnetstat from bugtraq.

* Mon Dec 03 2001 Phil Knirsch <phil@redhat.de>
- Update to 4.2.3 final.
  o Fixes old buffer overflow problems directly. Removed security2 patch.
  o Fixes another overflow problem as reported by CERT (VU#617947)
- Fixed libtool/rpath buildroot pollution problem.
- Fixed library naming problem.

* Fri Oct  5 2001 Philipp Knirsch <pknirsch@redhat.de>
- Fixed a server segfault for snmpset operation (#53640). Thanks to Josh Giles
  and Wes Hardaker for the patch.

* Mon Sep 10 2001 Philipp Knirsch <pknirsch@redhat.de>
- Fixed problem with RUNTESTS script.

* Tue Sep  4 2001 Preston Brown <pbrown@redhat.com>
- fixed patch related to bug #35016 (Dell)

* Fri Aug 24 2001 Philipp Knirsch <pknirsch@redhat.de> 4.2.1-6
- Fixed snmpd description (#52366)

* Wed Aug 22 2001 Philipp Knirsch <pknirsch@redhat.de>
- Final bcm5820 fix. Last one was broken.
- Fixed bugzilla bug (#51960) where the binaries contained rpath references.

* Wed Aug 15 2001 Philipp Knirsch <pknirsch@redhat.de>
- Fixed a couple of security issues:
  o /tmp race and setgroups() privilege problem
  o Various buffer overflow and format string issues.
  o One signedness problem in ASN handling.
- Fixed an important RFE to support bcm5820 cards. (#51125)

* Fri Jul 20 2001 Philipp Knirsch <pknirsch@redhat.de>
- Removed tkmib from the package once again as we don't ship the Tk.pm CPAN
  perl module required to run it (#49363)
- Added missing Provides for the .so.0 libraries as rpm doesn't seem to find
  those during the build anymore (it used to) (#46388)

* Thu Jul 19 2001 Philipp Knirsch <pknirsch@redhat.de>
- Enabled IPv6 support (RFE #47764)
- Hopefully final fix of snmpwalk problem (#42153). Thanks to Douglas Warzecha
  for the patch and Matt Domsch for reporting the problem.

* Tue Jun 26 2001 Philipp Knirsch <pknirsch@redhat.de>
- Fixed smux compilation problems (#41452)
- Fixed wrong paths displayed in manpages (#43053)

* Mon Jun 25 2001 Philipp Knirsch <pknirsch@redhat.de>
- Updated to 4.2.1. Removed 2 obsolete patches (fromcvs and #18153)
- Include /usr/share/snmp/snmpconf in %files

* Wed Jun 13 2001 Than Ngo <than@redhat.com>
- fix to use libwrap in distro
- add buildprereq: tcp_wrappers

* Fri Jun  1 2001 Bill Nottingham <notting@redhat.com>
- add a *new* patch for IP address return sizes

* Fri Apr 20 2001 Bill Nottingham <notting@redhat.com>
- add patch so that only four bytes are returned for IP addresses on ia64 (#32244)

* Wed Apr 11 2001 Bill Nottingham <notting@redhat.com>
- rebuild (missing alpha packages)

* Fri Apr  6 2001 Matt Wilson <msw@redhat.com>
- added ucd-snmp-4.2-null.patch to correcly handle a NULL value (#35016)

* Tue Apr  3 2001 Preston Brown <pbrown@redhat.com>
- clean up deinstallation (#34168)

* Tue Mar 27 2001 Matt Wilson <msw@redhat.com>
- return a usable RETVAL when running "service snmpd status" (#33571)

* Tue Mar 13 2001 Matt Wilson <msw@redhat.com>
- configure with --enable-reentrant and added "smux" and "agentx" to
  --with-mib-modules= argument (#29626)

* Fri Mar  2 2001 Nalin Dahyabhai <nalin@redhat.com>
- rebuild in new environment

* Mon Feb 26 2001 Tim Powers <timp@redhat.com>
- fixed initscript, for reload and restart it was start then stop,
  fixed. (#28477)

* Fri Feb  2 2001 Trond Eivind Glomsrd <teg@redhat.com>
- i18nize initscript

* Sat Jan  6 2001 Jeff Johnson <jbj@redhat.com>
- don't depend on /etc/init.d so that package will work with 6.2.
- perl path fiddles no longer needed.
- rely on brp-compress frpm rpm to compress man pages.
- patch from ucd-snmp CVS (Wes Hardaker).
- configure.in needs to check for rpm libraries correctly (#23033).
- add simple logrotate script (#21399).
- add options to create pidfile and log with syslog with addresses (#23476).

* Sat Dec 30 2000 Jeff Johnson <jbj@redhat.com>
- package for Red Hat 7.1.

* Thu Dec 07 2000 Wes Hardaker <hardaker@users.sourceforge.net>
- update for 4.2

* Thu Oct 12 2000 Jeff Johnson <jbj@redhat.com>
- add explicit format for syslog call (#18153).

* Thu Jul 20 2000 Bill Nottingham <notting@redhat.com>
- move initscript back

* Thu Jul 20 2000 Jeff Johnson <jbj@redhat.com>
- rebuild per Trond's request.

* Tue Jul 18 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix syntax error that crept in with condrestart

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Mon Jul 10 2000 Preston Brown <pbrown@redhat.com>
- move initscript and add condrestart magic

* Sat Jun 17 2000 Bill Nottingham <notting@redhat.com>
- fix %%attr on man pages

* Mon Jun 12 2000 Jeff Johnson <jbj@redhat.com>
- tkmib doco had #!/usr/bin/perl55
- include snmpcheck and tkmib again (still needs some CPAN module, however).

* Tue Jun  6 2000 Jeff Johnson <jbj@redhat.com>
- update to 4.1.2.
- FHS packaging.
- patch for rpm 4.0.

* Thu May 18 2000 Trond Eivind Glomsrd <teg@redhat.com>
- add version to buildroot
- rebuilt with new libraries

* Sun Feb 27 2000 Jeff Johnson <jbj@redhat.com>
- default config was broken (from Wes Hardaker) (#9752)

* Sun Feb 13 2000 Jeff Johnson <jbj@redhat.com>
- compressed man pages.

* Fri Feb 11 2000 Wes Hardaker <wjhardaker@ucdavis.edu>
- update to 4.1.1

* Sat Feb  5 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- change %postun to %preun

* Thu Feb 3 2000 Elliot Lee <sopwith@redhat.com>
- Don't ship tkmib, since we don't ship the perl modules needed to run it.
(Bug #4881)

* Tue Aug 31 1999 Jeff Johnson <jbj@redhat.com>
- default config permits RO access to system group only (Wed Hardaker).

* Sun Aug 29 1999 Jeff Johnson <jbj@redhat.com>
- implement suggestions from Wes Hardaker.

* Fri Aug 27 1999 Jeff Johnson <jbj@redhat.com>
- stateless access to rpm database.

* Wed Aug 25 1999 Jeff Johnson <jbj@redhat.com>
- update to 4.0.1.

* Mon Aug 16 1999 Bill Nottingham <notting@redhat.com>
- initscript munging

* Sat Jun 12 1999 Jeff Johnson <jbj@redhat.com>
- update to 3.6.2 (#3219,#3259).
- add missing man pages (#3057).

* Thu Apr  8 1999 Wes Hardaker <wjhardaker@ucdavis.edu>
- fix Source0 location.
- fix the snmpd.conf file to use real community names.

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 3)

* Fri Mar 19 1999 Preston Brown <pbrown@redhat.com>
- upgrade to 3.6.1, fix configuration file stuff.

* Wed Feb 24 1999 Preston Brown <pbrown@redhat.com>
- Injected new description and group.

* Tue Feb  2 1999 Jeff Johnson <jbj@redhat.com>
- restore host resources mib
- simplified config file
- rebuild for 6.0.

* Tue Dec 22 1998 Bill Nottingham <notting@redhat.com>
- remove backup file to fix perl dependencies

* Tue Dec  8 1998 Jeff Johnson <jbj@redhat.com>
- add all relevant rpm scalars to host resources mib.

* Sun Dec  6 1998 Jeff Johnson <jbj@redhat.com>
- enable libwrap (#253)
- enable host module (rpm queries over SNMP!).

* Mon Oct 12 1998 Cristian Gafton <gafton@redhat.com>
- strip binaries

* Fri Oct  2 1998 Jeff Johnson <jbj@redhat.com>
- update to 3.5.3.
- don't include snmpcheck until perl-SNMP is packaged.

* Thu Aug 13 1998 Jeff Johnson <jbj@redhat.com>
- ucd-snmpd.init: start daemon w/o -f.

* Tue Aug  4 1998 Jeff Johnson <jbj@redhat.com>
- don't start snmpd unless requested
- start snmpd after pcmcia.

* Sun Jun 21 1998 Jeff Johnson <jbj@redhat.com>
- all but config (especially SNMPv2p) ready for prime time

* Sat Jun 20 1998 Jeff Johnson <jbj@redhat.com>
- update to 3.5.

* Tue Dec 30 1997 Otto Hammersmith <otto@redhat.com>
- created the package... possibly replace cmu-snmp with this.
