// $RCSfile: MS-DACMN.JS $ $Revision: 1.10 $
// Copyright (C) 1998-2000 Compaq Computer Corporation

function boxName(boxIndex)
{
   var thisBox = cpqSsDrvBoxEntry[boxIndex];
//   var thisName = " Storage System on Port " + thisBox.cpqSsBoxBusIndex;
   var thisName = " Xg[WVXe - |[g " + thisBox.cpqSsBoxBusIndex;
   var kluge;  // required because of file size limits in IE3.x

   if (thisBox.cpqSsBoxPlacement == 2)
   {
      kluge = "";
   }
   else if (thisBox.cpqSsBoxPlacement == 3)
   {
      kluge = "O";
   }
   else
   {
      kluge = "s";
   }
   return kluge+thisName;
}

function logDrvName(drvIndex)
{
   var thisDrv = cpqDaLogDrvEntry[drvIndex];
   var drvName = "_hCu " + thisDrv.cpqDaLogDrvIndex;

   if (2 < thisDrv.cpqDaLogDrvFaultTol)
   {
      drvName += " - " + displayItem("cpqDaLogDrvFaultTol", thisDrv.cpqDaLogDrvFaultTol);
   }
   return drvName;
}

function phyDrvName(drvIndex)
{
   var thisDrv = cpqDaPhyDrvEntry[drvIndex];
   var drvName = "|[g " + thisDrv.cpqDaPhyDrvBusNumber + " hCu " + thisDrv.cpqDaPhyDrvBay;
   var i;

   if (thisDrv.cpqDaPhyDrvSize != -1)
   {
      drvName += "  " + thisDrv.cpqDaPhyDrvSize + "MB";
   }

   for (i = 0; i < cpqDaSpareEntry.length; i++)
   {
      if (cpqDaSpareEntry[i].cpqDaSpareCntlrIndex == thisDrv.cpqDaPhyDrvCntlrIndex &&
          cpqDaSpareEntry[i].cpqDaSparePhyDrvIndex == thisDrv.cpqDaPhyDrvIndex)
      {
         drvName += " - XyA";
      }
   }
   return drvName;
}

function daCntlrBoardName(cntlrIdx)
{
   var rc;

   rc = displayItem("cpqDaCntlrModel", cpqDaCntlrEntry[cntlrIdx].cpqDaCntlrModel) + " Rg[ ";

   if (cpqDaCntlrEntry[cntlrIdx].cpqDaCntlrSlot == 0)
   {
      rc += " - VXe{[h";
   }
   else
   {
      rc += " - Xbg "+cpqDaCntlrEntry[cntlrIdx].cpqDaCntlrSlot;
   }
   return rc;
}

function daCntlrName(cntlrIdx)
{
   var rc;

   rc = daCntlrBoardName(cntlrIdx);

   with(cpqDaCntlrEntry[cntlrIdx])
   {
      if (typeof(cpqDaCntlrCurrentRole) != "undefined")
      {
         if (cpqDaCntlrCurrentRole == 3 && cpqDaCntlrPartnerSlot != -1)
         {
            if (cpqDaCntlrPartnerSlot == 0)
               rc += " - VXe{[h";
            else if (cpqDaCntlrSlot == 0)
               rc += " - Xbg " + cpqDaCntlrPartnerSlot;
            else
               rc += " - " + cpqDaCntlrPartnerSlot;
         }
         if ((cpqDaCntlrCurrentRole == 3 || cpqDaCntlrCurrentRole == 4) &&
              cpqDaCntlrPartnerSlot == -1)
         {
            if (cpqDaCntlrRedundancyType == 3)
               rc += "/̑T[o";
            else
               rc += "/s";
         }
      }
   }
   return rc;
}

function compileDaCondition()
{
   this.state = 1;  // reset to unknown
   this.update(cpqDaCntlrEntry[this.index].cpqDaCntlrCondition);
}

function daTapeDriveIndex(cntlr, bus, id)
{
   for (idx = 0; idx < cpqDaTapeDrvEntry.length; idx++)
   {
      if (cpqDaTapeDrvEntry[idx].cpqDaTapeDrvCntlrIndex == cntlr &&
          cpqDaTapeDrvEntry[idx].cpqDaTapeDrvBusIndex == bus &&
          cpqDaTapeDrvEntry[idx].cpqDaTapeDrvScsiIdIndex == id)
         break;
   }
   return idx;
}

function daTapeDriveName(i)
{
   var rc = "";
   if (i < cpqDaTapeDrvEntry.length)
   {
      rc  = cpqDaTapeDrvEntry[i].cpqDaTapeDrvName +
            " - oX " + cpqDaTapeDrvEntry[i].cpqDaTapeDrvBusIndex +
            " hCu " + cpqDaTapeDrvEntry[i].cpqDaTapeDrvScsiIdIndex;
   }
   return rc;
}

function daTapeLibraryName(i)
{
   rc = cpqDaTapeLibraryEntry[i].cpqDaTapeLibraryModel +
        " - oX " + cpqDaTapeLibraryEntry[i].cpqDaTapeLibraryScsiBus +
        " foCX " + cpqDaTapeLibraryEntry[i].cpqDaTapeLibraryScsiTarget;
   return rc;
}

function hotPlugGraphic()
{
   return ("<IMG SRC='/WEBAGENT/CQMGSTOR/ENG/HOTPLUG.JPG' ALIGN='MIDDLE' WIDTH=11 HEIGHT=15 HSPACE=3 BORDER=0> ");
}

