<HTML>
<!-- $RCSfile: MS-SCSI.TPL $ $Revision: 1.17 $ -->
<!-- Copyright (C) 1998-2000 Compaq Computer Corporation -->
<HEAD>

<!#/COMMON/JPN/PAGETAGS.TPL>

<SCRIPT LANGUAGE="JavaScript">
   <!#/COMMON/COMPAQ.JS>

   <!cpqScsiCntlrEntry>
   <!cpqScsiTargetEntry>
   <!cpqScsiPhyDrvEntry>
   <!cpqTapePhyDrvEntry>
   <!cpqTapeCountersEntry>
   <!cpqTapeLibraryEntry>
   <!cpqTapeLibraryDriveList.raw>
   <!cpqSsDrvBoxEntry>
   <!cpqCdLibraryEntry>
   <!cpqScsiCdDrvEntry>
   <!cpqCdLibraryDriveList.raw>

   <!#/COMMON/JPN/COND.JS>
   <!#/COMMON/STDITEMS.JS>
   <!#/COMMON/JPN/TABLES.JS>
   <!#/COMMON/JPN/PARSEARG.JS>
   <!#/COMMON/DISPBASE.JS>
   <!#TPENUMS.JS>
   <!#SCSENUMS.JS>
   <!#SSENUMS.JS>
   <!#MS-SCSIC.JS>
   <!#MS-DRVBX.JS>

   postfix["cpqScsiTargetNegSpeed"] = "MTS";
   postfix["cpqScsiTargetNegWidth"] = "rbg";
   postfix["cpqScsiPhyDrvSize"] = "MB";

   function hotPlugGraphic()
   {
      return ("<IMG SRC='/WEBAGENT/CQMGSTOR/ENG/HOTPLUG.JPG' ALIGN='MIDDLE' WIDTH=11 HEIGHT=15 HSPACE=3 BORDER=0> ");
   }

   function boxStatusGraphic(boxIndex, alignment)
   {
      var boxStatus = new cpqCondition(cpqSsDrvBoxEntry[boxIndex].cpqSsBoxCondition);
      return boxStatus.imageSmall(alignment);
   }

   function writeScsiDevInfoTable(targetIndex)
   {
      writeTableHead();
      writeDoubleTableRow("foCX ^Cv:",  targetType(targetIndex),
                          "x_:",       displayItem("cpqScsiTargetVendor",  cpqScsiTargetEntry[targetIndex].cpqScsiTargetVendor));
      writeDoubleTableRow("t@[EFA rW:", displayItem("cpqScsiTargetFWRev",   cpqScsiTargetEntry[targetIndex].cpqScsiTargetFWRev),
                          "f:",        displayItem("cpqScsiTargetModel",   cpqScsiTargetEntry[targetIndex].cpqScsiTargetModel));
      writeTableTail();
   }

   function writeScsiBusTable(targetIndex)
   {
      var dispSpeed;

      if (cpqScsiTargetEntry[targetIndex].cpqScsiTargetNegSpeed == -1 ||
          cpqScsiTargetEntry[targetIndex].cpqScsiTargetNegSpeed == MAXCOUNT)
      {
         dispSpeed = "N/A";
      }
      else
      {
         dispSpeed = displayItem("cpqScsiTargetNegSpeed",
            cpqScsiTargetEntry[targetIndex].cpqScsiTargetNegSpeed/1000000);
      }
      document.write("<BR>");
      writeTableLabel("SCSI oX");
      writeTableHead();
      writeDoubleTableRow("peB G[:",    displayItem("cpqScsiTargetParityErrs",      cpqScsiTargetEntry[targetIndex].cpqScsiTargetParityErrs),
                          "oX:",   displayItem("cpqScsiTargetPhysWidth",       cpqScsiTargetEntry[targetIndex].cpqScsiTargetPhysWidth));
      writeDoubleTableRow("tF[Y G[:",     displayItem("cpqScsiTargetPhaseErrs",       cpqScsiTargetEntry[targetIndex].cpqScsiTargetPhaseErrs),
                          "ꂽoX:", displayItem("cpqScsiTargetNegWidth",        cpqScsiTargetEntry[targetIndex].cpqScsiTargetNegWidth));
      writeDoubleTableRow("ZNg ^CAEg:",  displayItem("cpqScsiTargetSelectTimeouts",  cpqScsiTargetEntry[targetIndex].cpqScsiTargetSelectTimeouts),
                          "ꂽx:", dispSpeed);
      writeDoubleTableRow("bZ[W WFNg:",  displayItem("cpqScsiTargetMsgRejects",      cpqScsiTargetEntry[targetIndex].cpqScsiTargetMsgRejects),
                          "","");
      writeTableTail();
   }

   function actionFromStatus(status)
   {
      rc = "ΏKvȂ";

      if (status == null)
      {
         rc = "s";
      }
      else if (status == 8 || status == 9)
      {
         rc = "SMART hCu";
      }
      else if (status == 3 || status == 6 || status == 7 || status == 11)
      {
         rc = "hCu";
      }
      return rc;
   }

   function writeScsiDriveTables(cntlr, bus, id, targIndex)
   {
      var i;
      var rawData;
      var j;
      var k;
      var volName;
      var volSegment;

      // find the physical drive that corresponds to this target
      for (i = 0; i < cpqScsiPhyDrvEntry.length; i++)
      {
         if (cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvCntlrIndex == cntlr &&
             cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvBusIndex == bus &&
             cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvScsiID == id)
         {
            break;
         }
      }
      if (i < cpqScsiPhyDrvEntry.length)
      {
         writeTableHead();
         writeDoubleTableRow("Xe[^X:",             displayItem("cpqScsiPhyDrvStatus",               cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvStatus),
                             "hCuΏ:",       actionFromStatus(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvStatus));
         writeDoubleTableRow("VAԍ:",      displayItem("cpqScsiPhyDrvSerialNum",            cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSerialNum),
                             "ۑv:",    displayItem("cpqScsiPhyDrvStatsPreserved",       cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvStatsPreserved));
         writeDoubleTableRow("e:",           displayItem("cpqScsiPhyDrvSize",                 cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSize),
                             "ғ:",      displayItem("cpqScsiPhyDrvServiceHours",         cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvServiceHours));
         if (cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHotPlug == 2)
         {
            writeDoubleTableRow("SMART T|[g:", displayItem("cpqScsiPhyDrvPreFailMonitoring",    cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPreFailMonitoring),
                                ":",          displayItem("cpqScsiPhyDrvPlacement",            cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPlacement) + hotPlugGraphic());
         }
         else writeDoubleTableRow("SMART T|[g:", displayItem("cpqScsiPhyDrvPreFailMonitoring",    cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPreFailMonitoring),
                                  ":",          displayItem("cpqScsiPhyDrvPlacement",            cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPlacement));
         writeTableTail();
         document.write("<BR>");

         writeTableLabel("hCu CWP[^");
         writeTableHead();
         writeDoubleTableRow("pςݍĊ蓖:",     displayItem("cpqScsiPhyDrvUsedReallocs",    cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvUsedReallocs),
                             "XsAbv:",      displayItem("cpqScsiPhyDrvSpinupTime",      cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSpinupTime));
         writeDoubleTableRow("^CAEg:",         displayItem("cpqScsiPhyDrvTimeouts",        cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvTimeouts),
                             "Zt eXg G[:", displayItem("cpqScsiPhyDrvPostErrs",        cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvPostErrs));
         writeTableTail();
         document.write("<BR>");

         writeTableLabel("hCu v");
         writeTableHead();
         writeDoubleTableRow(
            "[hZN^:", displayQuadNumber(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHighReadSectors,
                                               cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvLowReadSectors),
            "CgZN^:", displayQuadNumber(cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHighWriteSectors,
                                                  cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvLowWriteSectors));
         writeDoubleTableRow(
            "n[h [h G[:",  displayItem("cpqScsiPhyDrvHardReadErrs",  cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHardReadErrs),
            "n[h Cg G[:", displayItem("cpqScsiPhyDrvHardWriteErrs", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvHardWriteErrs));
         writeDoubleTableRow(
            "[h G[:",  displayItem("cpqScsiPhyDrvRecvReadErrs",  cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvRecvReadErrs),
            "Cg G[:", displayItem("cpqScsiPhyDrvRecvWriteErrs", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvRecvWriteErrs));
         writeDoubleTableRow(
            "ECC ς݃[h:", displayItem("cpqScsiPhyDrvEccCorrReads", cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvEccCorrReads),
            "V[N G[:",         displayItem("cpqScsiPhyDrvSeekErrs",     cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvSeekErrs));
         writeTableTail();
         log = cpqScsiPhyDrvEntry[i].cpqScsiPhyDrvParent;
      }
   }

   function writeScsiTapeTables(cntlr, bus, id, targIndex)
   {
      var i;
      var j;
      var fw;

      // find the physical drive that corresponds to this target
      for (i = 0; i < cpqTapePhyDrvEntry.length; i++)
      {
         if (cpqTapePhyDrvEntry[i].cpqTapePhyDrvCntlrIndex == cntlr &&
             cpqTapePhyDrvEntry[i].cpqTapePhyDrvBusIndex == bus &&
             cpqTapePhyDrvEntry[i].cpqTapePhyDrvScsiIdIndex == id)
         {
            break;
         }
      }
      if (i < cpqTapePhyDrvEntry.length)
      {
         if (typeof(cpqTapePhyDrvEntry[i].cpqTapePhyDrvFwRev) == "undefined")
         {
            fw = displayItem("cpqTapePhyDrvFwSubtype", cpqTapePhyDrvEntry[i].cpqTapePhyDrvFwSubtype);
         }
         else
         {
            fw = displayItem("cpqTapePhyDrvFwRev", cpqTapePhyDrvEntry[i].cpqTapePhyDrvFwRev);
         }
         writeTableHead();
         writeDoubleTableRow("Xe[^X:", displayItem("cpqTapePhyDrvStatus", cpqTapePhyDrvEntry[i].cpqTapePhyDrvStatus),
                             "f:",  displayItem("cpqTapePhyDrvName",   cpqTapePhyDrvEntry[i].cpqTapePhyDrvName));
         writeDoubleTableRow("Firmware Revision:", fw,
                             "VAԍ:", displayItem("cpqTapePhyDrvSerialNumber", cpqTapePhyDrvEntry[i].cpqTapePhyDrvSerialNumber));

         if (cpqTapePhyDrvEntry[i].cpqTapePhyDrvHotPlug == 2)
         {
            writeDoubleTableRow("}KW TCY:", displayItem("cpqTapePhyDrvMagSize",   cpqTapePhyDrvEntry[i].cpqTapePhyDrvMagSize),
                                "zu:",      displayItem("cpqTapePhyDrvPlacement", cpqTapePhyDrvEntry[i].cpqTapePhyDrvPlacement) +
                                hotPlugGraphic());
         }
         else writeDoubleTableRow("}KW TCY:", displayItem("cpqTapePhyDrvMagSize",   cpqTapePhyDrvEntry[i].cpqTapePhyDrvMagSize),
                                  "zu:",     displayItem("cpqTapePhyDrvPlacement", cpqTapePhyDrvEntry[i].cpqTapePhyDrvPlacement));
         writeTableTail();

         // find the appropriate entry in the tape counters table
         for (j = 0; j < cpqTapeCountersEntry.length; j++)
         {
            if (cpqTapeCountersEntry[i].cpqTapeCountersCntlrIndex == cntlr &&
                cpqTapeCountersEntry[i].cpqTapeCountersBusIndex == bus &&
                cpqTapeCountersEntry[i].cpqTapeCountersScsiIdIndex == id)
            {
               document.write("<BR>");
               writeTableLabel("e[v hCu G[");
               writeTableHead();
               writeDoubleTableRow("e[v G[:", displayItem("cpqTapeCountersTotalErrors",           cpqTapeCountersEntry[i].cpqTapeCountersTotalErrors),
                                   "ă[h:",    displayItem("cpqTapeCountersReReads",               cpqTapeCountersEntry[i].cpqTapeCountersReReads));
               writeDoubleTableRow("ăCg:",     displayItem("cpqTapeCountersReWrites",              cpqTapeCountersEntry[i].cpqTapeCountersReWrites),
                                   "s\:", displayItem("cpqTapeCountersTotalUncorrectable",    cpqTapeCountersEntry[i].cpqTapeCountersTotalUncorrectable));
               writeTableTail();
               break;
            }
         }
         document.write("<BR>");
         writeTableLabel("e[v hCu eiX");
         writeTableHead();
         writeSingleTableRow("e[vhCuwbh̓N[jOKv:",
             displayItem("cpqTapePhyDrvCleanReq", cpqTapePhyDrvEntry[i].cpqTapePhyDrvCleanReq));
         writeSingleTableRow("N[jOe[v͌Kv:",
             displayItem("cpqTapePhyDrvCleanTapeRepl", cpqTapePhyDrvEntry[i].cpqTapePhyDrvCleanTapeRepl));
         writeSingleTableRow("N[jOs:",
             displayItem("cpqTapePhyDrvCleanTapeCount", cpqTapePhyDrvEntry[i].cpqTapePhyDrvCleanTapeCount));
         writeTableTail();
      }
   }

   function writeScsiTapeLibraryTables(cntlr, bus, id, targIndex)
   {
      var i;
      var j;
      var n;
      var driveLink;
      var rawTable;

      // find the physical drive that corresponds to this target
      for (i = 0; i < cpqTapeLibraryEntry.length; i++)
      {
         if (cpqTapeLibraryEntry[i].cpqTapeLibraryCntlrIndex == cntlr &&
             cpqTapeLibraryEntry[i].cpqTapeLibraryBusIndex == bus &&
             cpqTapeLibraryEntry[i].cpqTapeLibraryScsiIdIndex == id)
         {
            break;
         }
      }
      if (i < cpqTapeLibraryEntry.length)
      {
         writeTableHead();
         writeDoubleTableRow(
            "Xe[^X:", displayItem("cpqTapeLibraryState", cpqTapeLibraryEntry[i].cpqTapeLibraryState),
            "f:",  displayItem("cpqTapeLibraryName",      cpqTapeLibraryEntry[i].cpqTapeLibraryName));
         writeDoubleTableRow(
            "t@[EFA Rev:",  displayItem("cpqScsiTargetFWRev", cpqScsiTargetEntry[targIndex].cpqScsiTargetFWRev),
            "VAԍ:", displayItem("cpqTapeLibrarySerialNumber", cpqTapeLibraryEntry[i].cpqTapeLibrarySerialNumber));
         writeDoubleTableRow(
            "ғ:", displayItem("cpqTapeLibraryStatHours",  cpqTapeLibraryEntry[i].cpqTapeLibraryStatHours),
            "ړv:",   displayItem("cpqTapeLibraryStatMoves", cpqTapeLibraryEntry[i].cpqTapeLibraryStatMoves));
         writeDoubleTableRow(
            "hA Xe[^X:", displayItem("cpqTapeLibraryDoorStatus", cpqTapeLibraryEntry[i].cpqTapeLibraryDoorStatus),
            "__V:", displayItem("cpqTapeLibraryRedundancy", cpqTapeLibraryEntry[i].cpqTapeLibraryRedundancy));
         writeDoubleTableRow(
            "x:", displayItem("cpqTapeLibraryTemperature", cpqTapeLibraryEntry[i].cpqTapeLibraryTemperature),
            "zbg:",   displayItem("cpqTapeLibraryHotSwap", cpqTapeLibraryEntry[i].cpqTapeLibraryHotSwap));
         writeDoubleTableRow(
            "ŏIG[:", displayItem("cpqTapeLibraryStatus", cpqTapeLibraryEntry[i].cpqTapeLibraryStatus),
            "", "");
         writeTableTail();

         document.write("<BR>");
         writeTableLabel("gݍ܂ꂽe[vhCu");
         writeTableHead();
         rawTable = cpqTapeLibraryDriveList[i];

         for (j = 0; j < (rawTable.length/4); j++)
         {
            var tapeName = "e[vhCu - ";
            var drvCntlr = rawTable[j*4];
            var drvBus = rawTable[j*4 + 1];
            var drvId  = rawTable[j*4 + 2];

            for (n = 0; n < cpqTapePhyDrvEntry.length; n++)
            {
               if (drvCntlr == cpqTapePhyDrvEntry[n].cpqTapePhyDrvCntlrIndex &&
                   drvBus   == cpqTapePhyDrvEntry[n].cpqTapePhyDrvBusIndex   &&
                   drvId    == cpqTapePhyDrvEntry[n].cpqTapePhyDrvScsiIdIndex)
               {
                  tapeName = cpqTapePhyDrvEntry[n].cpqTapePhyDrvName + " - ";
                  break;
               }
            }
            for (n = 0; n < cpqScsiCntlrEntry.length; n++)
            {
               if (drvCntlr == cpqScsiCntlrEntry[n].cpqScsiCntlrIndex)
               {
                  tapeName += "SCSI Rg[ Xbg " +
                               cpqScsiCntlrEntry[n].cpqScsiCntlrSlot;
                  break;
               }
            }
            tapeName += " oX " + drvBus + " ID " + drvId;
            driveLink = makeLink("CQMGSTOR/MS-SCSI.TPL?index=" + drvCntlr +
                                 "&bus=" + drvBus + "&id=" + drvId, tapeName, "_self");
            writeOneItemTableRow(driveLink);
         }
         writeTableTail();
      }
   }

   function writeScsiCdLibraryTables(cntlr, bus, id, targIndex)
   {
      var i;
      var j;
      var k;
      var serialno;
      var rawTable;
      var drvCntlr;
      var drvBus;
      var drvId;
      var drvLun;

      // find the physical drive that corresponds to this target
      for (i = 0; i < cpqCdLibraryEntry.length; i++)
      {
         if (cpqCdLibraryEntry[i].cpqCdLibraryCntlrIndex == cntlr &&
             cpqCdLibraryEntry[i].cpqCdLibraryBusIndex == bus &&
             cpqCdLibraryEntry[i].cpqCdLibraryScsiIdIndex == id)
         {
            break;
         }
      }
      if (i < cpqCdLibraryEntry.length)
      {
         writeTableHead();
         writeSingleTableRowInDoubleTable(
            "Xe[^X:", displayItem("cpqCdLibraryStatus", cpqCdLibraryEntry[i].cpqCdLibraryStatus));
         writeDoubleTableRow(
            "VAԍ:",  displayItem("cpqCdLibrarySerialNumber", cpqCdLibraryEntry[i].cpqCdLibrarySerialNumber),
            "Rg[ LUN:", displayItem("cpqCdLibraryLunIndex",     cpqCdLibraryEntry[i].cpqCdLibraryLunIndex));
         writeTableTail();

         document.write("<BR>");
         writeTableLabel("gݍ܂ꂽ CDhCu");
         writeTableHead();
         writeColumnTableHeaderRow("x_:", "f:", "t@[EFA Rev:", "LUN:");

         rawTable = cpqCdLibraryDriveList[i];
         for (j = 0; j < (rawTable.length/4); j++)
         {
            drvCntlr = rawTable[j*4];
            drvBus   = rawTable[j*4 + 1];
            drvId    = rawTable[j*4 + 2];
            drvLun   = rawTable[j*4 + 3];

            for (k = 0; k < cpqScsiCdDrvEntry.length; k++)
            {
               if (cpqScsiCdDrvEntry[k].cpqScsiCdDrvCntlrIndex ==  drvCntlr &&
                   cpqScsiCdDrvEntry[k].cpqScsiCdDrvBusIndex ==    drvBus &&
                   cpqScsiCdDrvEntry[k].cpqScsiCdDrvScsiIdIndex == drvId &&
                   cpqScsiCdDrvEntry[k].cpqScsiCdDrvLunIndex ==    drvLun)
               {
                  writeColumnTableDataRow(cpqScsiCdDrvEntry[k].cpqScsiCdDrvVendor,
                     cpqScsiCdDrvEntry[k].cpqScsiCdDrvModel,
                     cpqScsiCdDrvEntry[k].cpqScsiCdDrvFwRev, drvLun);
               }
            }
         }
         writeTableTail();
      }
   }
</SCRIPT>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">
writeBodyHead();

cntlr = findArg("index");
bus = findArg("bus");

if (cntlr == -1 || bus == -1)
{
   // missing arg, try prev page load args
   parseArgs(tryPrevPage());
   cntlr = findArg("index");
   bus = findArg("bus");
}

for (index = 0; index < cpqScsiCntlrEntry.length; index++)
{
   if (cpqScsiCntlrEntry[index].cpqScsiCntlrIndex == cntlr &&
       cpqScsiCntlrEntry[index].cpqScsiCntlrBusIndex == bus)
      break;
}

if (cpqScsiCntlrEntry.length == index)
{
   reportMissingArgs();
}
else
{
   id = findArg("id");
   box = findArg("box");

   if (id != -1)  // SCSI target
   {
      for (i = 0; i < cpqScsiTargetEntry.length; i++)
      {
         if (cpqScsiTargetEntry[i].cpqScsiTargetCntlrIndex == cntlr &&
             cpqScsiTargetEntry[i].cpqScsiTargetBusIndex == bus &&
             cpqScsiTargetEntry[i].cpqScsiTargetScsiIdIndex == id)
            break;
      }
      targetidx = i;
      pageTitle = targetName(targetidx);
   }
   else if (box != -1) // storage box
   {
      count = 0;
      for (i = 0; i < cpqSsDrvBoxEntry.length; i++)
      {
         if (cpqSsDrvBoxEntry[i].cpqSsBoxCntlrIndex == cntlr &&
             cpqSsDrvBoxEntry[i].cpqSsBoxBusIndex == bus)
         {
            if (count == box) break;
            count++;
         }
      }
      boxidx = i;
      pageTitle = displayItem("cpqSsBoxPlacement", cpqSsDrvBoxEntry[boxidx].cpqSsBoxPlacement)
       + " |[g " + bus;
   }
   writePageHead(pageTitle, "/WEBAGENT/IMAGES/MASSHDR.GIF", "SCSI ");

   if (id != -1)  // display the devices
   {
      tableTitle = targetStatusGraphic(targetidx, "TOP") + targetName(targetidx);
      writeTableLabel(tableTitle, "SCSI foCXڍ");

      // display any type-specific info here:
      thisType = cpqScsiTargetEntry[targetidx].cpqScsiTargetType;
      thisTypeExt = cpqScsiTargetEntry[targetidx].cpqScsiTargetTypeExtended;
      if (thisType ==  2) // drive
      {
         writeScsiDevInfoTable(targetidx);
         writeScsiDriveTables(cntlr, bus, id, targetidx);
      }
      else if (thisType == 3)   // tape
      {
         writeScsiTapeTables(cntlr, bus, id, targetidx);
      }
      else if (thisTypeExt == 4) // tape library
      {
         writeScsiTapeLibraryTables(cntlr, bus, id, targetidx);
      }
      else if (thisTypeExt == 5) // CD library
      {
         writeScsiDevInfoTable(targetidx);
         writeScsiCdLibraryTables(cntlr, bus, id, targetidx);
      }
      else
      {
         writeScsiDevInfoTable(targetidx);
      }
      document.write("<BR>");
      writeScsiBusTable(targetidx);
   }
   else if (box != -1) // display storage boxes
   {
      tableTitle = boxStatusGraphic(boxidx, "TOP")
          + displayItem("cpqSsBoxPlacement", cpqSsDrvBoxEntry[boxidx].cpqSsBoxPlacement)
          + " |[g " + bus;
      writeTableLabel(tableTitle, "Xg[W VXe");
      writeDriveBoxTable(cpqSsDrvBoxEntry[boxidx]);
   }
   writeTableTail();
}
writeBodyTail();
</SCRIPT>
</HTML>
