<HTML>
<!-- $RCSfile: MS-FCSS.TPL $ $Revision: 1.7 $ -->
<!-- Copyright (C) 1998-2000 Compaq Computer Corporation -->
<HEAD>

<!#/COMMON/PAGETAGS.TPL>

<SCRIPT LANGUAGE="JavaScript">
   <!#/COMMON/COMPAQ.JS>

   <!cpqSsChassisEntry>
   <!cpqSsIoSlotEntry>
   <!cpqSsBackplaneEntry>
   <!cpqSsPowerSupplyEntry>
   <!cpqSsTempSensorEntry>
   <!cpqSsFanModuleEntry>

   <!#/COMMON/COND.JS>
   <!#/COMMON/STDITEMS.JS>
   <!#/COMMON/TABLES.JS>
   <!#/COMMON/PARSEARG.JS>
   <!#/COMMON/DISPBASE.JS>
   <!#SSENUMS.JS>
   <!#FCAENUMS.JS>
   <!#MS-FCCMN.JS>

   postfix["cpqSsTempSensorCurrentValue"] = "C";
   postfix["cpqSsTempSensorLimitValue"] = "C";
</SCRIPT>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">
writeBodyHead();

idx = findArg("index"); // the controller index passed in to the page

if (idx == -1)
{
   // missing arg, try prev page load args
   parseArgs(tryPrevPage());
   idx = findArg("index");
}

if (idx == -1 || idx >= cpqSsChassisEntry.length)
{
   reportMissingArgs();
}
else
{
   thisChassis = cpqSsChassisEntry[idx]
   thisChassisIndex = thisChassis.cpqSsChassisIndex;
   slotControllers = new Array;

   for (i = 0; i < cpqSsIoSlotEntry.length; i++)
   {
      if (cpqSsIoSlotEntry[i].cpqSsIoSlotChassisIndex == thisChassisIndex)
      {
         slotControllers[cpqSsIoSlotEntry[i].cpqSsIoSlotIndex] = displayItem(
            "cpqSsIoSlotControllerType", cpqSsIoSlotEntry[i].cpqSsIoSlotControllerType);
      }
   }
   powerCondition = new cpqCondition(thisChassis.cpqSsChassisPowerSupplyCondition);
   tempCondition  = new cpqCondition(thisChassis.cpqSsChassisTemperatureCondition);
   fanCondition   = new cpqCondition(thisChassis.cpqSsChassisFanCondition);
   chassisCond    = new cpqCondition(powerCondition.state);
   chassisCond.update(tempCondition.state);
   chassisCond.update(fanCondition.state);

   writePageHead(fcChassisName(idx), "/WEBAGENT/IMAGES/MASSHDR.GIF", "Storage System Information" );
   writeTableLabel(fcChassisName(idx));
   writeTableHead();
   writeSingleTableRowInDoubleTable(
      "Model:", displayItem("cpqSsChassisModel", thisChassis.cpqSsChassisModel));
   writeSingleTableRowInDoubleTable(
      "Name:",  displayItem("cpqSsChassisName", thisChassis.cpqSsChassisName));
   writeDoubleTableRow(
      "Connection:", displayItem("cpqSsChassisConnectionType", thisChassis.cpqSsChassisConnectionType),
      "IO Slot 1:", (null!=slotControllers[1] ? slotControllers[1]: "Not Installed"));
   writeDoubleTableRow(
      "Serial Number:", displayItem("cpqSsChassisSerialNumber", thisChassis.cpqSsChassisSerialNumber),
      "IO Slot 2:", (null!=slotControllers[2] ? slotControllers[2]: "Not Installed"));
   writeTableTail();
   document.write("<BR>");

   writeTableLabel("Backplane Information");
   writeTableHead();
   writeColumnTableHeaderRow("Firmware Revision", "Drive Bays", "Duplex");

   for (i = 0; i < cpqSsBackplaneEntry.length; i++)
   {
      if (cpqSsBackplaneEntry[i].cpqSsBackplaneChassisIndex == thisChassisIndex)
      {
         writeColumnTableDataRow(
            displayItem("cpqSsBackplaneFWRev",        cpqSsBackplaneEntry[i].cpqSsBackplaneFWRev),
            displayItem("cpqSsBackplaneDriveBays",    cpqSsBackplaneEntry[i].cpqSsBackplaneDriveBays),
            displayItem("cpqSsBackplaneDuplexOption", cpqSsBackplaneEntry[i].cpqSsBackplaneDuplexOption));
      }
   }
   writeTableTail();
   document.write("<BR>");

   writeTableLabel("Asset Information");
   writeTableHead();
   writeColumnTableHeaderRow("Board", "Serial Number", "Board Revision");
   writeColumnTableDataRow("System Board",
      displayItem("cpqSsChassisSystemBoardSerNum", thisChassis.cpqSsChassisSystemBoardSerNum),
      displayItem("cpqSsChassisSystemBoardRev",    thisChassis.cpqSsChassisSystemBoardRev));
   writeColumnTableDataRow("Power Board",
      displayItem("cpqSsChassisPowerBoardSerNum", thisChassis.cpqSsChassisPowerBoardSerNum),
      displayItem("cpqSsChassisPowerBoardRev",    thisChassis.cpqSsChassisPowerBoardRev));
   writeColumnTableDataRow("SCSI Board",
      displayItem("cpqSsChassisScsiBoardSerNum", thisChassis.cpqSsChassisScsiBoardSerNum),
      displayItem("cpqSsChassisScsiBoardRev",    thisChassis.cpqSsChassisScsiBoardRev));
   writeTableTail();
   document.write("<BR>");

   writeTableLabel(powerCondition.imageSmall()+"Power Supply Information", "Power Supply Information");
   writeTableHead();
   writeColumnTableHeaderRow("Location", "Status", "UPS State", "Serial Number", "Board Revision", "Firmware Revision");

   for (i = 0; i < cpqSsPowerSupplyEntry.length; i++)
   {
      if (cpqSsPowerSupplyEntry[i].cpqSsPowerSupplyChassisIndex == thisChassisIndex)
      {
         thisPS = cpqSsPowerSupplyEntry[i];
         powerCondition.state = 1;
         powerCondition.update(thisPS.cpqSsPowerSupplyCondition);
         writeColumnTableDataRow(
            powerCondition.imageSmall() + "Power Bay " + (thisPS.cpqSsPowerSupplyBay-1) ,
            displayItem("cpqSsPowerSupplyStatus",           thisPS.cpqSsPowerSupplyStatus ),
            displayItem("cpqSsPowerSupplyUpsStatus",        thisPS.cpqSsPowerSupplyUpsStatus),
            displayItem("cpqSsPowerSupplySerialNumber",     thisPS.cpqSsPowerSupplySerialNumber),
            displayItem("cpqSsPowerSupplyBoardRevision",    thisPS.cpqSsPowerSupplyBoardRevision),
            displayItem("cpqSsPowerSupplyFirmwareRevision", thisPS.cpqSsPowerSupplyFirmwareRevision));
      }
   }
   writeTableTail();
   document.write("<BR>");

   writeTableLabel(tempCondition.imageSmall() + "Temperature Information", "Temperature Information");
   writeTableHead();
   writeColumnTableHeaderRow("Location", "Status", "Current Value", "Limit Value");

   for (i = 0; i < cpqSsTempSensorEntry.length; i++)
   {
      if (cpqSsTempSensorEntry[i].cpqSsTempSensorChassisIndex == thisChassisIndex)
      {
         thisTemp = cpqSsTempSensorEntry[i];
         tempCondition.state = 1;
         tempCondition.update(thisTemp.cpqSsTempSensorCondition);
         writeColumnTableDataRow(
            tempCondition.imageSmall() + displayItem("cpqSsTempSensorLocation", thisTemp.cpqSsTempSensorLocation),
            displayItem("cpqSsTempSensorStatus", thisTemp.cpqSsTempSensorStatus),
            displayItem("cpqSsTempSensorCurrentValue", thisTemp.cpqSsTempSensorCurrentValue),
            displayItem("cpqSsTempSensorLimitValue", thisTemp.cpqSsTempSensorLimitValue));
      }
   }
   writeTableTail();
   document.write("<BR>");

   writeTableLabel(fanCondition.imageSmall() + "Fan Information", "Fan Information");
   writeTableHead();
   writeColumnTableHeaderRow("Location", "Status", "Serial Number", "Board Revision");

   for (i = 0; i < cpqSsFanModuleEntry.length; i++)
   {
      if (cpqSsFanModuleEntry[i].cpqSsFanModuleChassisIndex == thisChassisIndex)
      {
         thisFan = cpqSsFanModuleEntry[i];
         fanCondition.state = 1;
         fanCondition.update(thisFan.cpqSsFanModuleCondition);
         writeColumnTableDataRow(
            fanCondition.imageSmall() + displayItem("cpqSsFanModuleLocation", thisFan.cpqSsFanModuleLocation),
            displayItem("cpqSsFanModuleStatus",        thisFan.cpqSsFanModuleStatus),
            displayItem("cpqSsFanModuleSerialNumber",  thisFan.cpqSsFanModuleSerialNumber),
            displayItem("cpqSsFanModuleBoardRevision", thisFan.cpqSsFanModuleBoardRevision));
      }
   }
   writeTableTail();
}
writeBodyTail();
</SCRIPT>
</HTML>

