<HTML>
<!-- $RCSfile: MS-FCPHY.TPL $ $Revision: 1.7 $ -->
<!-- Copyright (C) 1998-2000 Compaq Computer Corporation -->
<HEAD>

<!#/COMMON/PAGETAGS.TPL>

<SCRIPT LANGUAGE="JavaScript">
   <!#/COMMON/COMPAQ.JS>

   <!cpqSsChassisEntry>
   <!cpqFcaCntlrEntry>
   <!cpqFcaPhyDrvEntry>
   <!cpqFcaPhyDrvThrEntry>
   <!cpqFcaLogDrvEntry>
   <!cpqFcaLogDrvPhyDrvIDs.raw>
   <!cpqFcaLogDrvAvailSpares.raw>
   <!cpqFcaSpareEntry>

   <!#/COMMON/COND.JS>
   <!#/COMMON/STDITEMS.JS>
   <!#/COMMON/TABLES.JS>
   <!#/COMMON/PARSEARG.JS>
   <!#/COMMON/DISPBASE.JS>
   <!#SSENUMS.JS>
   <!#FCAENUMS.JS>
   <!#MS-FCCMN.JS>

   postfix["cpqFcaPhyDrvSize"] = "MB";

   function determineDriveAction(drv, thr)
   {
      var condition = drv.cpqFcaPhyDrvCondition;
      var status = drv.cpqFcaPhyDrvStatus;
      var actionString;
      var violation;
      var thresh;
      var value;
      var i;

      if (condition == -1)
      {
         actionString = "Unknown";
      }
      else if (condition == 4)
      {
         actionString = "Replace Drive";
      }
      else if (status == 4)
      {
         actionString = "Replace SMART Drive";
      }
      else
      {
         violation = new Array;
         violation[0] = thr.cpqFcaPhyDrvThrViFunctTest1;
         violation[1] = thr.cpqFcaPhyDrvThrViFunctTest2;
         violation[2] = thr.cpqFcaPhyDrvThrViFunctTest3;
         violation[3] = thr.cpqFcaPhyDrvThrViUsedReallocs;
         violation[4] = thr.cpqFcaPhyDrvThrViSpinupTime;

         thresh = new Array;
         thresh[0] = thr.cpqFcaPhyDrvThrFunctTest1;
         thresh[1] = thr.cpqFcaPhyDrvThrFunctTest2;
         thresh[2] = thr.cpqFcaPhyDrvThrFunctTest3;
         thresh[3] = thr.cpqFcaPhyDrvThrUsedReallocs;
         thresh[4] = thr.cpqFcaPhyDrvThrSpinupTime;

         value = new Array;
         value[0] = drv.cpqFcaPhyDrvFunctTest1;
         value[1] = drv.cpqFcaPhyDrvFunctTest2;
         value[2] = drv.cpqFcaPhyDrvFunctTest3;
         value[3] = drv.cpqFcaPhyDrvUsedReallocs;
         value[4] = drv.cpqFcaPhyDrvSpinupTime;

         actionString = "No Action Required";

         for (i = 0; i < 5; i++)
         {
            if (violation[i] == 2 && thresh[i] != 0xffffffff && value[i] != 0xffffffff)
            {
               actionString = "Replace Drive";
            }
         }
      }
      return actionString;
   }

   function checkThreshold(val, thr, viol)
   {
      var rc = "N/A";

      if (val != null && thr != null && viol != null)
      {
         if (val != "" && thr != "" && viol != "" &&
             val != -1 && thr != -1 && viol != -1)
         {
             if (viol == 2) rc = "Replace Drive";
             else  rc = "OK";
         }
      }
      return rc;
   }
</SCRIPT>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">

writeBodyHead();
idx = findArg("index"); // the index passed in to the page

if (idx == -1)
{
   // missing arg, try prev page load args
   parseArgs(tryPrevPage());
   idx = findArg("index");
}

if (idx == -1 || idx >= cpqFcaPhyDrvEntry.length)
{
   reportMissingArgs();
}
else
{
   thisDrv = cpqFcaPhyDrvEntry[idx];
   for(boxIdx=0; boxIdx<cpqSsChassisEntry.length; boxIdx++)
   {
      if (thisDrv.cpqFcaPhyDrvBoxIndex == cpqSsChassisEntry[boxIdx].cpqSsChassisIndex)
         break;
   }
   for (i = 0; i < cpqFcaPhyDrvThrEntry.length; i++)
   {
      if (cpqFcaPhyDrvThrEntry[i].cpqFcaPhyDrvThrBoxIndex == thisDrv.cpqFcaPhyDrvBoxIndex &&
          cpqFcaPhyDrvThrEntry[i].cpqFcaPhyDrvThrIndex == thisDrv.cpqFcaPhyDrvIndex)
      {
         thisThr = cpqFcaPhyDrvThrEntry[i];
         break;
      }
   }
   thisSpare = null;
   thisSpareIdx = -1;

   for (i = 0; i < cpqFcaSpareEntry.length; i++)
   {
      if (cpqFcaSpareEntry[i].cpqFcaSpareBoxIndex == thisDrv.cpqFcaPhyDrvBoxIndex &&
          cpqFcaSpareEntry[i].cpqFcaSparePhyDrvIndex == thisDrv.cpqFcaPhyDrvIndex)
      {
         thisSpare = cpqFcaSpareEntry[i];
         thisSpareIdx = i;
         break;
      }
   }
   for (i = 0; i < cpqFcaCntlrEntry.length; i++)
   {
      if (cpqFcaCntlrEntry[i].cpqFcaCntlrBoxIndex == thisDrv.cpqFcaPhyDrvBoxIndex)
      {
         cntlrIdx = i;
         break;
      }
   }
   thisDrvCondition = new cpqCondition(thisDrv.cpqFcaPhyDrvCondition);
   writePageHead(fcPhyDrvName(idx) + " - " + fcCntlrName(cntlrIdx), "/WEBAGENT/IMAGES/MASSHDR.GIF", "Physical Drive Information");
   thisCntlr = cpqFcaCntlrEntry[boxIdx];

   document.write("<BR>");
   writeTableLabel(thisDrvCondition.imageSmall() + "Physical Drive - " + fcPhyDrvName(idx));
   writeTableHead();
   writeDoubleTableRow("Status:", displayItem("cpqFcaPhyDrvStatus", thisDrv.cpqFcaPhyDrvStatus),
                       "Action:", determineDriveAction(thisDrv, thisThr));
   writeDoubleTableRow("Capacity:", displayItem("cpqFcaPhyDrvSize", thisDrv.cpqFcaPhyDrvSize),
                       "Model:",    displayItem("cpqFcaPhyDrvModel", thisDrv.cpqFcaPhyDrvModel));
   writeDoubleTableRow("Firmware Version:", displayItem("cpqFcaPhyDrvFWRev", thisDrv.cpqFcaPhyDrvFWRev),
                       "Serial Number:",    displayItem("cpqFcaPhyDrvSerialNum", thisDrv.cpqFcaPhyDrvSerialNum));
   writeDoubleTableRow("Service Hours:", displayItem("cpqFcaPhyDrvRefHours", thisDrv.cpqFcaPhyDrvRefHours),
                       "S.M.A.R.T.:",    displayItem("cpqFcaPhyDrvPreFailMonitoring", thisDrv.cpqFcaPhyDrvPreFailMonitoring));
   writeDoubleTableRow("Current Width:", displayItem("cpqFcaPhyDrvCurrentWidth", thisDrv.cpqFcaPhyDrvCurrentWidth),
                       "Current Speed:", displayItem("cpqFcaPhyDrvCurrentSpeed", thisDrv.cpqFcaPhyDrvCurrentSpeed));
   writeTableTail();

   document.write("<BR>");
   writeTableLabel("Logical Drives");
   writeTableHead();
   logDrvCondition = new cpqCondition(1);
   logDrvs = 0;

   for (i = 0; i < cpqFcaLogDrvEntry.length; i++)
   {
      if (thisDrv.cpqFcaPhyDrvBoxIndex == cpqFcaLogDrvEntry[i].cpqFcaLogDrvBoxIndex)
      {
         rawData = cpqFcaLogDrvPhyDrvIDs[i];
         for (j = 0; j < rawData.length; j++)
         {
            if (rawData[j] == thisDrv.cpqFcaPhyDrvIndex)
            {
               logDrvs++;
               logDrvCondition.set(cpqFcaLogDrvEntry[i].cpqFcaLogDrvCondition);
               logLink = "CQMGSTOR/MS-FCLOG.TPL?index=" + i;
               document.write("<tr><td>");
               writeStatusNameTable(makeLink(logLink, logDrvCondition.imageSmall(), "_self"),
                                    makeLink(logLink, fcLogDrvName(i), "_self"));
               document.write("</td></tr>");
            }
         }
         if (thisSpare != null &&
             thisSpare.cpqFcaSpareBoxIndex == cpqFcaLogDrvEntry[i].cpqFcaLogDrvBoxIndex)
         {
            rawData = cpqFcaLogDrvAvailSpares[i];
            for (j = 0; j < rawData.length; j++)
            {
               if (rawData[j] == thisSpare.cpqFcaSparePhyDrvIndex)
               {
                  logDrvs++;
                  logDrvCondition.set(cpqFcaLogDrvEntry[i].cpqFcaLogDrvCondition);
                  logLink = "CQMGSTOR/MS-FCLOG.TPL?index=" + i;
                  document.write("<tr><td>");
                  writeStatusNameTable(makeLink(logLink, logDrvCondition.imageSmall(), "_self"),
                                       makeLink(logLink, fcLogDrvName(i), "_self"));
                  document.write("</td></tr>");
               }
            }
         }
      }
   }
   if (logDrvs == 0)
   {
      writeOneItemTableRow("None");
   }
   writeTableTail();

   if (thisSpare != null)
   {
      document.write("<BR>");
      spareCondition = new cpqCondition(thisSpare.cpqFcaSpareCondition);
      writeTableLabel(spareCondition.imageSmall() + "Spare Information");
      writeTableHead();
      writeSingleTableRowInDoubleTable("Status:", displayItem("cpqFcaSpareStatus", thisSpare.cpqFcaSpareStatus));
      spareName = "None";
      rebuildPct = "N/A";

      if (thisSpare.cpqFcaSpareStatus <= 5)
      {
         for (i = 0; i < cpqFcaPhyDrvEntry.length; i++)
         {
            if (cpqFcaPhyDrvEntry[i].cpqFcaPhyDrvBoxIndex == thisSpare.cpqFcaSpareBoxIndex &&
                cpqFcaPhyDrvEntry[i].cpqFcaPhyDrvBay == thisSpare.cpqFcaSpareReplacedDrvBay)
            {
               spareName = fcPhyDrvName(i);
               break;
            }
         }
         rebuildCaption = "Percent Rebuild Complete:";
         rebuildData = percentGraph(thisSpare.cpqFcaSparePercentRebuild);
      }
      writeDoubleTableRow("Replaced Drive:", spareName, rebuildCaption, rebuildData);
      writeTableTail();
   }
   if (thisDrv.cpqFcaPhyDrvHasMonInfo == 2)
   {
      document.write("<BR>");
      writeTableLabel("Predictive Indicators");
      writeTableHead();

      writeColumnTableDataRow(
          "Func Test 1: " + checkThreshold(thisDrv.cpqFcaPhyDrvFunctTest1, thisThr.cpqFcaPhyDrvThrFunctTest1, thisThr.cpqFcaPhyDrvThrViFunctTest1),
          "Func Test 2: " + checkThreshold(thisDrv.cpqFcaPhyDrvFunctTest2, thisThr.cpqFcaPhyDrvThrFunctTest2, thisThr.cpqFcaPhyDrvThrViFunctTest2),
          "Func Test 3: " + checkThreshold(thisDrv.cpqFcaPhyDrvFunctTest3, thisThr.cpqFcaPhyDrvThrFunctTest3, thisThr.cpqFcaPhyDrvThrViFunctTest3));
      writeColumnTableDataRow("","","");
      writeColumnTableHeaderRow("Indicator", "Value", "Status");
      writeColumnTableDataRow(
          "Used Realloc:", displayItem("cpqFcaPhyDrvUsedReallocs", thisDrv.cpqFcaPhyDrvUsedReallocs),
          checkThreshold(thisDrv.cpqFcaPhyDrvUsedReallocs, thisThr.cpqFcaPhyDrvThrUsedReallocs, thisThr.cpqFcaPhyDrvThrViUsedReallocs));
      writeColumnTableDataRow(
          "Spinup Time:", displayItem("cpqFcaPhyDrvSpinupTime", thisDrv.cpqFcaPhyDrvSpinupTime),
          checkThreshold(thisDrv.cpqFcaPhyDrvSpinupTime, thisThr.cpqFcaPhyDrvThrSpinupTime, thisThr.cpqFcaPhyDrvThrViSpinupTime));
      writeTableTail();
      document.write("<BR>");

      writeTableLabel("Problem Indicators");
      writeTableHead();
      writeDoubleTableRow(
         "Failed Recovery Reads:", displayItem("cpqFcaPhyDrvBadRecvReads", thisDrv.cpqFcaPhyDrvBadRecvReads),
         "SCSI Bus Faults:",       displayItem("cpqFcaPhyDrvBusFaults", thisDrv.cpqFcaPhyDrvBusFaults));
      writeDoubleTableRow(
         "Other Timeouts:", displayItem("cpqFcaPhyDrvOtherTimeouts", thisDrv.cpqFcaPhyDrvOtherTimeouts),
         "", "");
      writeTableTail();
      document.write("<BR>");

      writeTableLabel("Failure Indicators");
      writeTableHead();
      writeDoubleTableRow(
         "Spinup Errors:",    displayItem("cpqFcaPhyDrvSpinUpErrs", thisDrv.cpqFcaPhyDrvSpinUpErrs),
         "Aborted Commands:", displayItem("cpqFcaPhyDrvAbortedCmds", thisDrv.cpqFcaPhyDrvAbortedCmds));
      writeDoubleTableRow(
         "Format Errors:",   displayItem("cpqFcaPhyDrvFormatErrs", thisDrv.cpqFcaPhyDrvFormatErrs),
         "Hardware Errors:", displayItem("cpqFcaPhyDrvHardwareErrs", thisDrv.cpqFcaPhyDrvHardwareErrs));
      writeDoubleTableRow(
         "Not Ready Errors:",  displayItem("cpqFcaPhyDrvNotReadyErrs", thisDrv.cpqFcaPhyDrvNotReadyErrs),
         "Bad Target Errors:", displayItem("cpqFcaPhyDrvBadTargetErrs", thisDrv.cpqFcaPhyDrvBadTargetErrs));
      writeDoubleTableRow(
         "Fail Recov Writes:", displayItem("cpqFcaPhyDrvBadRecvWrites", thisDrv.cpqFcaPhyDrvBadRecvWrites),
         "Media Failures:",    displayItem("cpqFcaPhyDrvMediaErrs", thisDrv.cpqFcaPhyDrvMediaErrs));
      writeTableTail();
      document.write("<BR>");

      writeTableLabel("Statistics");
      writeTableHead();
      writeDoubleTableRow(
         "Sectors Read:",    displayQuadNumber(thisDrv.cpqFcaPhyDrvHReads, thisDrv.cpqFcaPhyDrvReads),
         "Sectors Written:", displayQuadNumber(thisDrv.cpqFcaPhyDrvHWrites, thisDrv.cpqFcaPhyDrvWrites));
      writeDoubleTableRow(
         "Hard Read Errors:",  displayItem("cpqFcaPhyDrvHardReadErrs", thisDrv.cpqFcaPhyDrvHardReadErrs),
         "Hard Write Errors:", displayItem("cpqFcaPhyDrvHardWriteErrs", thisDrv.cpqFcaPhyDrvHardWriteErrs));
      writeDoubleTableRow(
         "Recov Read Errors:",  displayItem("cpqFcaPhyDrvRecvReadErrs", thisDrv.cpqFcaPhyDrvRecvReadErrs),
         "Recov Write Errors:", displayItem("cpqFcaPhyDrvRecvWriteErrs", thisDrv.cpqFcaPhyDrvRecvWriteErrs));
      writeDoubleTableRow(
         "Total Seeks:",    displayItem("cpqFcaPhyDrvSeeks", thisDrv.cpqFcaPhyDrvSeeks),
         "Hot Plug Count:", displayItem("cpqFcaPhyDrvHotPlugs", thisDrv.cpqFcaPhyDrvHotPlugs));
      writeDoubleTableRow(
         "Seek Errors:", displayItem("cpqFcaPhyDrvSeekErrs", thisDrv.cpqFcaPhyDrvSeekErrs),
         "", "");
      writeTableTail();
   }
}
writeBodyTail();
</SCRIPT>
</HTML>

