// $RCSfile: MS-FCCMN.JS $ $Revision: 1.8 $
// Copyright (C) 1998-2000 Compaq Computer Corporation

function fcChassisName(chassisIdx)
{
   var rc;
   rc = "Storage System " + cpqSsChassisEntry[chassisIdx].cpqSsChassisName;
   return rc;
}

function fcCntlrName(cntlrIdx)
{
   var rc;
   rc = displayItem("cpqFcaCntlrModel", cpqFcaCntlrEntry[cntlrIdx].cpqFcaCntlrModel)
       + " Controller in Slot " + cpqFcaCntlrEntry[cntlrIdx].cpqFcaCntlrBoxIoSlot;
   return rc;
}

function fcPhyDrvName(drvIdx)
{
   var rc;
   var thisDrv = cpqFcaPhyDrvEntry[drvIdx];
   var i;

   rc = "Port " + thisDrv.cpqFcaPhyDrvBusNumber + " Drive " + thisDrv.cpqFcaPhyDrvBay;
   if (thisDrv.cpqFcaPhyDrvSize != -1)
   {
      rc += "  " + thisDrv.cpqFcaPhyDrvSize + " MB";
   }
   for (i = 0; i < cpqFcaSpareEntry.length; i++)
   {
      if (cpqFcaSpareEntry[i].cpqFcaSpareBoxIndex == thisDrv.cpqFcaPhyDrvBoxIndex &&
          cpqFcaSpareEntry[i].cpqFcaSparePhyDrvIndex == thisDrv.cpqFcaPhyDrvIndex)
      {
         rc += " - SPARE";
      }
   }
   return rc;
}

function fcLogDrvName(drvIndex)
{
   var thisDrv = cpqFcaLogDrvEntry[drvIndex];
   var drvName = "Logical Drive " + thisDrv.cpqFcaLogDrvIndex;

   if (2 < thisDrv.cpqFcaLogDrvFaultTol)
   {
      drvName += " - " + displayItem( "cpqFcaLogDrvFaultTol", thisDrv.cpqFcaLogDrvFaultTol);
   }
   return drvName;
}

function compileFcCondition()
{
   this.state = 1;  // reset to unknown
   this.update(cpqSsChassisEntry[this.index].cpqSsChassisOverallCondition);
}

// RA-8000
function compileSsRaidCondition()
{
   this.state = 1;
   this.update(cpqSsRaidSystemEntry[this.index].cpqSsRaidSystemCondition);
}

function compileFcTapeCondition()
{
   this.state = 1;
   this.update(cpqFcTapeCntlrEntry[this.index].cpqFcTapeCntlrOverallCondition);
}

function fcTapeCntlrName(tapeCntlrIdx)
{
   var rc;
   rc = displayItem("cpqFcTapeCntlrType", cpqFcTapeCntlrEntry[tapeCntlrIdx].cpqFcTapeCntlrType);
   rc +=" (";
   rc += cpqFcTapeCntlrEntry[tapeCntlrIdx].cpqFcTapeCntlrWWN;
   rc +=")";
   return rc;
}

function fcTapeLibraryName(targetIndex)
{
   rc = cpqFcTapeLibraryEntry[targetIndex].cpqFcTapeLibraryModel +
        " - Bus " + cpqFcTapeLibraryEntry[targetIndex].cpqFcTapeLibraryScsiBus +
        " Device " + cpqFcTapeLibraryEntry[targetIndex].cpqFcTapeLibraryScsiTarget;
   return rc;
}

function fcTapeDriveIndex(cntlr, bus, id)
{
   for (idx = 0; idx < cpqFcTapeDriveEntry.length; idx++)
   {
      if (cpqFcTapeDriveEntry[idx].cpqFcTapeDriveCntlrIndex == cntlr &&
          cpqFcTapeDriveEntry[idx].cpqFcTapeDriveScsiBus == bus &&
          cpqFcTapeDriveEntry[idx].cpqFcTapeDriveScsiTarget == id)
         break;
   }
   return idx;
}

function fcTapeDriveName(drive)
{
   var rc = "";
   if (drive < cpqFcTapeDriveEntry.length)
   {
      rc  = cpqFcTapeDriveEntry[drive].cpqFcTapeDriveModel +
               " - Bus " + cpqFcTapeDriveEntry[drive].cpqFcTapeDriveScsiBus +
               " Drive " + cpqFcTapeDriveEntry[drive].cpqFcTapeDriveScsiTarget;

      for (cntlr = 0; cntlr < cpqFcTapeCntlrEntry.length; cntlr++)
      {
         if (cpqFcTapeCntlrEntry[cntlr].cpqFcTapeCntlrIndex ==
             cpqFcTapeDriveEntry[drive].cpqFcTapeDriveCntlrIndex)
         {
            rc += " (" + cpqFcTapeCntlrEntry[cntlr].cpqFcTapeCntlrWWN + ")";
            break;
         }
      }
   }
   return rc;
}

