set GUI_PATH [exec dirname $argv0]
#cmdtrace on [open "/tmp/IMLError.log" a+]

source $GUI_PATH/iml.msg.tcl
set EXE_FILE "$GUI_PATH/imlbe"

set Options(LOG) 1
set Options(REPAIR) 2
set Options(CONNECT) 3
set Options(CLEAR) 4
set Options(APPEND) 5

set OldIml 0
set ClearLogRequired 0
set Class ""
set Severity ""
set InitTime "" 
set UpdateTime ""
set GridRows 0
set Sort 6
set IMLList [list]
set FullIMLList [list]
set FileName ""


proc Quit {} {
 destroy . 
 exit 0
}

# This command is called whenever the background of the grid needs to
# be reformatted. The x1, y1, x2, y2 specifies the four corners of the area
# that needs to be reformatted.
#
# area:
#  x-margin:	the horizontal margin
#  y-margin:	the vertical margin
#  s-margin:	the overlap area of the x- and y-margins
#  main:	The rest
#
proc SimpleFormat {w area x1 y1 x2 y2} {

    global margin
    set bg(s-margin) gray65
    set bg(x-margin) gray65
    set bg(y-margin) gray65
    set bg(main)     gray20

    case $area {
	main {
	    # The "grid" format is consecutive boxes without 3d borders
	    #
	    $w format grid $x1 $y1 $x2 $y2 \
		-relief raised -bd 1 -bordercolor $bg($area) -filled 0 -bg red\
		-xon 1 -yon 1 -xoff 0 -yoff 0 -anchor se
	}
	{x-margin y-margin s-margin} {
	    # border specifies consecutive 3d borders
	    #
	    $w format border $x1 $y1 $x2 $y2 \
		-fill 1 -relief raised -bd 1 -bg $bg($area) \
		-selectbackground gray80
	}
    }
}

proc ParseIMLList {} {

  global FullIMLList IMLList EXE_FILE Options OldIml

  catch {exec $EXE_FILE $Options(LOG) "" ""} retval

  # If the wellness driver isn't loaded or installed on the remote server
  if {[lindex $retval 0] == "WARNING:"} { 
    	DisplayErrorMessage [lrange $retval 1 9999]
        set retval ""
  }

  # If failure occurs on the localhost
  if { [lindex $retval 0] == "FAILURE" } {
    	DisplayErrorMessage [lrange $retval 1 9999]
        set retval ""
  }

  set IMLList [list]
  set FullIMLList [list]
  set OldIml 0

  set list1 [split $retval [list "\n"]]
  foreach elem1 $list1 {
  	set list2 [split $elem1 [list "*"]]
	set list3 [list]
	foreach elem2 $list2 {
		set elem2 [string trimleft $elem2]
		set elem2 [string trimright $elem2 [list " " "."]]
		set list3Length [llength $list3]
		if {$list3Length == 4} {
			lappend list3 [clock scan $elem2]
		} elseif {$list3Length == 5} {
			lappend list3 [clock scan $elem2]
		} else {
			lappend list3 $elem2
		}
	}
	set isValid [isValidEntry $list3]
	lappend FullIMLList $list3
	if {$isValid > 0} {lappend IMLList $list3}
  }
}

proc FilterIMLList {} {

  global IMLList FullIMLList

  set IMLList [list]

  foreach elem1 $FullIMLList {
	set isValid [isValidEntry $elem1]
	if {$isValid > 0} {lappend IMLList $elem1}
  }
}

proc UpdateRow {index row} {

  global IMLListWidget

  set x 0
  foreach rowElem $row {
        if {$x == 4 && $index > 0} {
		$IMLListWidget set $x $index -itemtype text -text [clock format $rowElem -format "%H:%M %m/%d/%y"]
	} elseif {$x == 5 && $index > 0} {
		$IMLListWidget set $x $index -itemtype text -text [clock format $rowElem -format "%H:%M %m/%d/%y"]
	} else {
		$IMLListWidget set $x $index -itemtype text -text $rowElem
	}

	incr x
  }
}


proc UpdateList {full} {

  global IMLList IMLListWidget GridRows

  if {$full == 1} {
 	$IMLListWidget delete row 0 $GridRows
	set GridRows 0
        set header [list Description Class Status Count {Initial Time} {Update Time} {Event ID}]
        UpdateRow 0 $header
  } 
  set IMLListLength [llength $IMLList]
  for {set index $GridRows} {$index < $IMLListLength} {incr index} {
        set rowIndex [expr $index + 1]
	UpdateRow $rowIndex [lindex $IMLList $index]
  }
  set GridRows $IMLListLength
}

proc ParseAndUpdateList {full} {
    ParseIMLList
    UpdateList $full
}

proc FilterAndUpdateList {full} {
    FilterIMLList
    UpdateList $full
}

proc RefreshNow {} {
	ParseAndUpdateList 1
	UpdateMenuOptions
}

proc TimeFilter { timeVal filter } {

  set rawTime [clock seconds]

  set difference 0

  if { $filter == "Since Yesterday" } {
  	set difference 86400 
  } elseif { $filter == "Since Last Week" } {
  	set difference [expr 7 * 86400 ]
  } elseif { $filter == "Since Last Month" } {
  	set difference [expr 31 * 86400 ]
  } elseif { $filter == "Since Last Six Months" } {
  	set difference [expr 365 * 86400 / 2 ]
  }

  if { [expr $rawTime - $timeVal] < $difference } {return 1}

  return 0
}

proc isValidEntry { row } {

  global Class Severity UpdateTime InitTime
  
  set retval 0 

  set descr [lindex $row 0]
  set class [lindex $row 1]
  set severity [lindex $row 2]
  set count [lindex $row 3]
  set init [lindex $row 4]
  set update [lindex $row 5]
  set evtID [lindex $row 6]

  if {$Class != "All"} {
  	if {$Class != $class} {return 0}
  }
  if {$Severity != "All"} {
  	if {$Severity != $severity} {return 0}
  }
  if {$UpdateTime != "All"} {
        set validTime [TimeFilter $update $UpdateTime]
  	if {$validTime == 0} {return 0}
  }
  if {$InitTime != "All"} {
        set validTime [TimeFilter $init $InitTime]
  	if {$validTime == 0} {return 0}
  }

  return 1
}

proc DisplayErrorMessage {msg} {
   tk_messageBox -default ok -message $msg -title "Error" -type ok 
}


proc GetIconType {List} {

  if { [string first Repaired $List] != -1 } {
    return 0
  } elseif { [string first Critical $List] != -1 } {
    return 1
  } elseif { [string first Caution $List] != -1 } {
    return 2
  } elseif { [string first Failed $List] != -1 } {
    return 4
  } else {
    return 3
  }

}

proc RepairEntry { } {

   global IMLListWidget IMLList Options EXE_FILE
   
   set selection [lindex [$IMLListWidget anchor get] 1]
   incr selection -1
   if {$selection < 0} {return}
   if {$selection >= [llength $IMLList]} {return}
 
   set row [lindex $IMLList $selection]
   set elem [lindex $row 2]

   if { $elem == "Repaired"} {
     DisplayErrorMessage "The requested entry is already repaired."
   } else {
     set EvtNum [lindex $row 6]
     catch { exec $EXE_FILE $Options(REPAIR) $EvtNum 0} retval
     if { [lindex retval 0] == "FAILURE" } {
       DisplayErrorMessage [lrange $retval 1 9999]
     } else {
       ParseAndUpdateList 1 
     }
   }
}


proc ClearLog { } {

   global form Options HostName OldIml EXE_FILE IML_GUI_MSGS

   set TYPE 4

   if { $OldIml == 1 } {
     DisplayErrorMessage $IML_GUI_MSGS(MSG_NOT_REAL_IML_FILE)
   } else {
     catch { exec $EXE_FILE $Options(CLEAR) "" "" } retval
     if { [lindex retval 0] != "FAILURE" } {
       catch { exec $EXE_FILE $Options(APPEND) "Message Log Cleared by root" $TYPE } retval
       if { [lindex retval 0] == "FAILURE" } {
         DisplayErrorMessage [lrange $retval 1 9999]
       }
     } else {
       DisplayErrorMessage [lrange $retval 1 9999]
     }
     ParseAndUpdateList 1
     UpdateMenuOptions
   }
    
}

proc WarningCB { } \
{
  
   global IML_GUI_MSGS ClearLogRequired
   set msg $IML_GUI_MSGS(MSG_CLEARLOG_WARN)
   
set retVal [tk_dialog .dlg "Compaq Integrated Management Log Viewer" $msg "" 1 Clear Save Cancel] 

   if {$retVal == 1} {
	set ClearLogRequired 1
	GetNameAndSave
   }
   if {$retVal == 0} {
	ClearLog
   }

}

	

proc UpdateMenuOptions { }  {

  global OldIml

  .app.menu.logmenu entryconfigure 0 -state normal 
  .app.menu.logmenu entryconfigure 1 -state normal 
  .app.menu.logmenu entryconfigure 2 -state normal 
  .app.menu.viewmenu entryconfigure 1 -state normal
  .app.menu.file entryconfigure 2 -state disabled
  
  if { $OldIml == 1 } {
  	.app.menu.logmenu entryconfigure 0 -state disabled 
  	.app.menu.logmenu entryconfigure 1 -state disabled 
  	.app.menu.logmenu entryconfigure 2 -state disabled 
        .app.menu.viewmenu entryconfigure 1 -state disabled
        .app.menu.file entryconfigure 2 -state normal
  }

}


proc GetNameAndSave { } \
{

#  global IMLList IML_GUI_MSGS

#    set types {
#	{"IML files"		{.iml}	}
#	{"All files"		*}
#    }
    set dialog [tix filedialog tixFileSelectDialog]
    set dialog_fsbox [$dialog subwidget fsbox]
    set dialog_btns [$dialog subwidget btns]
    set dialog_fsbox_selection [$dialog_fsbox subwidget selection]
    set dialog_fsbox_filter [$dialog_fsbox subwidget filter]
    set dialog_btns_help [$dialog_btns subwidget help]
    set dialog_btns_apply [$dialog_btns subwidget apply]
   
    bind [winfo toplevel $dialog] <Alt-Key-s> "" 
    bind [winfo toplevel $dialog] <Alt-Key-f> \
	"focus [$dialog_fsbox subwidget selection]"

    $dialog_fsbox_filter appendhistory "*.iml"
    $dialog_fsbox_filter appendhistory "*.*"

    $dialog config -title "Save To A File" 

    $dialog_fsbox config -disablecallback true
    $dialog_fsbox_selection config -label "File Name" 
    $dialog_fsbox_selection config -selectmode immediate 

    $dialog_btns config -cancelcmd "GetNameAndExitCancel $dialog"
    $dialog_btns config -okcmd "GetNameAndSaveExit $dialog"
    $dialog_btns_help config -state disabled 
    $dialog_btns_apply config -state disabled
    
    bind [winfo toplevel $dialog] <Alt-o> \
	"after 0 tkButtonInvoke [$dialog_btns subwidget ok]"
    bind [winfo toplevel $dialog] <Alt-c> \
	"after 0 tkButtonInvoke [$dialog_btns subwidget cancel]"

    tixPushGrab $dialog
    focus $dialog
    $dialog popup
}

proc GetNameAndExitCancel { dialog } {
  tixPopGrab
  destroy $dialog
}

proc GetNameAndSaveExit { dialog} {
  global IMLList IML_GUI_MSGS ClearLogRequired

  set dialog_fsbox [$dialog subwidget fsbox]
  set dialog_fsbox_selection [$dialog_fsbox subwidget selection]

  set filename [$dialog_fsbox_selection cget -value]
  #puts $filename
  if { $filename == "" } {
	 DisplayErrorMessage $IML_GUI_MSGS(MSG_ENTER_FILENAME)
	 return
  } else {
    append filename ".iml"
    set fd [open $filename w+]
    seek $fd 0 end
    set IMLListLength [llength $IMLList]
    for {set x 0} {$x < $IMLListLength} {incr x} {
	 set row [lindex $IMLList $x]
         for {set y 0} {$y < 7} {incr y} {
	 	set elem [lindex $row $y]
		puts $fd $elem
	 }
    }
    close $fd
  }
  tixPopGrab 
  destroy $dialog
  if { $ClearLogRequired == 1 } {
	ClearLog
	set ClearLogRequired 0
  }
}


proc GetNameAndOpen {} \
{

    set dialog [tix filedialog tixFileSelectDialog]
    #puts $dialog
    set dialog_fsbox [$dialog subwidget fsbox]
    set dialog_btns [$dialog subwidget btns]
    set dialog_fsbox_selection [$dialog_fsbox subwidget selection]
    set dialog_fsbox_filter [$dialog_fsbox subwidget filter]
    set dialog_btns_help [$dialog_btns subwidget help]
    set dialog_btns_apply [$dialog_btns subwidget apply]

    bind [winfo toplevel $dialog] <Alt-Key-s> "" 
    bind [winfo toplevel $dialog] <Alt-Key-f> \
	"focus [$dialog_fsbox subwidget selection]"	

    $dialog_fsbox_filter appendhistory "*.iml"
    $dialog_fsbox_filter appendhistory "*.*"

    $dialog config -title "Open A File" 
    $dialog_fsbox config -disablecallback true
    $dialog_fsbox_selection config -label "File Name" 
    $dialog_fsbox_selection config -selectmode immediate 

    $dialog_btns config -cancelcmd "GetNameAndExitCancel $dialog" 
    $dialog_btns config -okcmd "GetNameAndOpenExit $dialog" 
    $dialog_btns_help config -state disabled 
    $dialog_btns_apply config -state disabled 

    bind [winfo toplevel $dialog] <Alt-o> \
	"after 0 tkButtonInvoke [$dialog_btns subwidget ok]"
    bind [winfo toplevel $dialog] <Alt-c> \
	"after 0 tkButtonInvoke [$dialog_btns subwidget cancel]"

    tixPushGrab $dialog
    focus $dialog
    $dialog popup
}

proc GetNameAndOpenExit { dialog } \
{
    global IMLList FullIMLList OldIml IML_GUI_MSGS FileName

  set dialog_fsbox [$dialog subwidget fsbox]
  set dialog_fsbox_selection [$dialog_fsbox subwidget selection]

  set filename [$dialog_fsbox_selection cget -value]

  if { $filename == "" } {
    DisplayErrorMessage $IML_GUI_MSGS(MSG_ENTER_OPENNAME)
    return
  } else {
    if { ![file exists $filename] } {
      DisplayErrorMessage $IML_GUI_MSGS(MSG_FILE_NOT_FOUND)
    } else {
     
      set FileName "$filename"
      set OldIml 1
      set IMLList [list]
      set FullIMLList [list]
      set fd [open $filename]
      set cont [gets $fd line]
      while {$cont >= 0} {
	 set row [list]
         for {set i 0} {$i < 7} {incr i} {
		lappend row $line
		set cont [gets $fd line]
	 }
      	 lappend IMLList $row
      	 lappend FullIMLList $row
      }
      close $fd
    }
  }
  tixPopGrab 
  destroy $dialog
  UpdateTitle
  FilterAndUpdateList 1
  UpdateMenuOptions
}

proc FilterCBExit { w } {
	FilterAndUpdateList 1	
	tixPopGrab 
        destroy $w
}

proc FilterCB { } {

  	global Class Severity InitTime UpdateTime

	set w .filter
	catch {destroy $w}
	toplevel $w
	wm title $w "Filter Events"
	wm iconname $w "fevent"
	wm geometry $w +300+300
	
	tixPushGrab $w
        focus $w

	set f [frame $w.options1]
	pack $f -side top -fill x 
	set m [label $f.label1 -text "Class:" -underline 0]
	pack $m -side left
	tk_optionMenu $f.menu1 Class All {Internal Test} {Machine Environment} {Main Memory} {Cache Memory} {CPU} {Host Bus} {EISA Bus} {PCI Bus} {Expansion Slot} {POST Messages} {POST Error} {Power Subsystem} {UPS} {ASR} {Operating System} {Diagnostics} {Network} {SCSI Subsuystem} {Drive Array Subsystem} {System Revision} {Maintenance Note} {Maintenance Clear Log}
	$f.menu1 configure -width 30
	pack $f.menu1 -side right -fill none 
	bind [winfo toplevel $w] <Alt-c> \
		"focus $f.menu1"

	set f [frame $w.options2]
	pack $f -side top -fill x 
	set m [label $f.label2 -text "Status:" -underline 0]
	pack $m -side left
	tk_optionMenu $f.menu2 Severity  All Information Repaired Caution Failed Unknown
	$f.menu2 configure -width 30
	pack $f.menu2 -side right -fill none 
	bind [winfo toplevel $w] <Alt-s> \
		"focus $f.menu2"	

	set f [frame $w.options3]
	pack $f -side top -fill x 
	set m [label $f.label3 -text "Update Time:" -underline 0]
	pack $m -side left
	tk_optionMenu $f.menu3 UpdateTime All {Since Yesterday} {Since Last Week} {Since Last Month} 
	$f.menu3 configure -width 30
	pack $f.menu3 -side right -fill none 
	bind [winfo toplevel $w] <Alt-u> \
		"focus $f.menu3"	

	set f [frame $w.options4]
	pack $f -side top -fill x 
	set m [label $f.label4 -text "Initial Time:" -underline 0]
	pack $m -side left
	tk_optionMenu $f.menu4 InitTime All {Since Yesterday} {Since Last Week} {Since Last Month}
	$f.menu4 configure -width 30
	pack $f.menu4 -side right -fill none 
	bind [winfo toplevel $w] <Alt-i> \
		"focus $f.menu4"

	set f [frame $w.buttons]
	pack $f -side bottom -fill x -pady 2m
	set m [button $f.ok -text OK -command "FilterCBExit $w" -underline 0]
	pack $m -side left -expand 1 
        bind [winfo toplevel $w] <Alt-o> \
		"after 0 tkButtonInvoke $f.ok"
}

proc SetToAll { } {
   
  global Class Severity InitTime UpdateTime

  set Class "All"
  set Severity "All"
  set InitTime "All"
  set UpdateTime "All"
}

proc MaintNoteCB { } {
	set w .mainNote
	catch {destroy $w}
	toplevel $w
	wm title $w "Maintenance Mode"
	wm iconname $w "mmode"
	wm geometry $w +300+300

	tixPushGrab $w
        focus $w

	set t [text $w.msg -height 7 -width 40 -wrap word]
	pack $t -side top -padx 5 -pady 5

	set f [frame $w.buttons]
	pack $f -side bottom -fill x -pady 2
	set m [button $f.ok -text OK -command "LogNote $w"]
	pack $m -side left -expand 1 

}

proc LogNote { w } {

  global EXE_FILE IML_GUI_MSGS Options

  set TYPE 3

  set str [$w.msg get 0.0 end]
  set str [string trimleft $str]
  set str [string trimright $str]
  set strlen [string length $str]
 
  if { $str == "" } {
    #puts $IML_GUI_MSGS(MSG_MAINT_NOTE_EMPTY)
    DisplayErrorMessage $IML_GUI_MSGS(MSG_MAINT_NOTE_EMPTY)
    return
  } elseif { $strlen > 40 } {
    DisplayErrorMessage $IML_GUI_MSGS(MSG_NOTE_TOO_LONG)
    return
  } else {
    set ret "\n"
    set rep " "
    regsub -all $ret $str $rep str2
    catch { exec $EXE_FILE $Options(APPEND) $str2 $TYPE } retval
    set retval1 [lindex retval 0]
    if { $retval1  == "FAILURE" } {
      DisplayErrorMessage [lrange $retval 1 9999]
    } else {
    	ParseAndUpdateList 0
    }
    tixPopGrab 
    destroy $w
  }

} 


proc DetailsCB { row} {

   global IMLList IML_GUI_MSGS

   # display the entire entry in the text field since there is sooooo much data to show in the listbox
   # In Tcl there is just no easy way to let the user see everything on the screen. Also, there is no such
	# widget like a CListCtrl in Visual C++.
   set str  "$str Description:    [lindex $IMLList 0] \n"
   set str  "$str Class:          [lindex $IMLList 1] \n"
   set str  "$str Status:       [lindex $IMLList 2] \n"
   set str  "$str Count:          [lindex $IMLList 3] \n"
   set str  "$str Update Time:    [lindex $IMLList 4] \n"
   set str  "$str Initial Time:   [lindex $IMLList 5]"

   tk_messageBox -default ok -message $str -title $IML_GUI_MSGS(MSG_DETAIL_EVENT_TITLE) -type ok 

}

proc DoErrorDie { msg } {
  tk_messageBox -default ok -message $msg -title "Error" -type ok 
}

proc SortOptionsExit { w } {

 	global Sort FullIMLList

	if {$Sort < 3} {
		set FullIMLList [lsort -index $Sort $FullIMLList]
	} else {
		set FullIMLList [lsort -integer -index $Sort $FullIMLList]
	}

	FilterAndUpdateList 1

	tixPopGrab 

	destroy $w
}

proc SortOptionsCB { } \
{
	global Sort 

	set w .sort
	catch {destroy $w}
	toplevel $w
	wm title $w "Sort Options"
	wm iconname $w "hscale"
	wm geometry $w +300+300

	tixPushGrab $w
        focus $w

	label $w.msg  -wraplength 3.5i -justify left -text "Choose a Sort Option"
	pack $w.msg -side top -padx .5c

	set f [frame $w.f -relief groove -bd 3]
	pack $f -fill both -padx 2 -pady 2

	set m [radiobutton $w.f.radio1 -text "Sort by Description" -variable Sort -value 0]
	pack $m -side top -anchor w 

	set m [radiobutton $w.f.radio2 -text "Sort by Class" -variable Sort -value 1]
	pack $m -side top -anchor w

	set m [radiobutton $w.f.radio3 -text "Sort by Status" -variable Sort -value 2]
	pack $m -side top -anchor w

	set m [radiobutton $w.f.radio4 -text "Sort by Count" -variable Sort -value 3]
	pack $m -side top -anchor w

	set m [radiobutton $w.f.radio5 -text "Sort by Initial Time" -variable Sort -value 4]
	pack $m -side top -anchor w

	set m [radiobutton $w.f.radio6 -text "Sort by Update Time" -variable Sort -value 5]
	pack $m -side top -anchor w
	
	set m [radiobutton $w.f.radio7 -text "Sort by ID" -variable Sort -value 6]
	pack $m -side top -anchor w

	set f [frame $w.buttons]
	pack $f -side bottom -fill x -pady 2m
	set m [button $f.ok -text OK -command "SortOptionsExit $w"]
	pack $m -side left -expand 1 

}


proc MenuToolTip {menu} {
   global menustatus IML_HLP_MSGS
   if {[catch {$menu entrycget active -label} label]} {
	set label ""
   }
   set menustatus $IML_HLP_MSGS($label)
   update idletasks
}

proc CloseFile {} {
   global FileName
   set FileName ""
   UpdateTitle
   RefreshNow
}

proc UpdateTitle {} {
   global FileName form IML_GUI_MSGS 
  
  if { $FileName != "" } {
   set newTitle "- "
  }
   append newTitle "$FileName"
   wm title $form "$IML_GUI_MSGS(MSG_APP_TITLE) $newTitle"
}


################### Build Screen Layout #######################

#set app [VtOpen IMLUI IML]
#set CHARM [VtInfo -charm]
set OSInfo [exec uname -a]

# Make sure we exec the correct path/hostname for each OS --> UnixWare or OpenServer. 
# Execute the "who -r" command to see what the current run level is.
set RunLevel [lindex [exec runlevel] 1]
set HostName [exec hostname]

#set PrinterExists 0
#if { $UW7_RL == -1 || $OPS_RL == -1 } {
#   set LPSTAT_Str [exec lpstat -a]
#   if { $LPSTAT_Str != "" } {
#      set PrinterExists 1
#   }
#}

wm withdraw .
set form .app
catch {destroy $form}
toplevel $form
bind .app  <Destroy> exit 
wm title $form $IML_GUI_MSGS(MSG_APP_TITLE)
wm iconname $form "menu"
wm geometry $form +300+300

#menu creation
menu $form.menu -tearoff 0

set m $form.menu.file
menu $m -tearoff 0
$form.menu add cascade -label $IML_GUI_MSGS(MSG_FILE_LABEL) -menu $m -underline 0
$m add command -label $IML_GUI_MSGS(MSG_OPEN_LABEL) -command {GetNameAndOpen} -underline 0
$m add command -label $IML_GUI_MSGS(MSG_SAVEAS_LABEL) -command {GetNameAndSave} -underline 0
$m add command -label $IML_GUI_MSGS(MSG_CLOSE_LABEL) -command {CloseFile} -underline 0 -state disabled
$m add separator
$m add command -label $IML_GUI_MSGS(MSG_EXIT_LABEL) -command {Quit} -underline 1

set m $form.menu.logmenu
menu $m -tearoff 0
$form.menu add cascade -label $IML_GUI_MSGS(MSG_LOG_LABEL) -menu $m -underline 0 
$m add command -label $IML_GUI_MSGS(MSG_CLEAR_LABEL) -command {WarningCB} -underline 0  -state disabled 
$m add command -label $IML_GUI_MSGS(MSG_REPAIR_LABEL) -command {RepairEntry} -underline 0 -state disabled 
$m add command -label $IML_GUI_MSGS(MSG_MAINT_NOTE_LABEL) -command {MaintNoteCB} -underline 0 -state disabled

set m $form.menu.viewmenu
menu $m -tearoff 0
$form.menu add cascade -label $IML_GUI_MSGS(MSG_VIEW_LABEL) -menu $m -underline 0
$m add command -label $IML_GUI_MSGS(MSG_FILTER_LABEL) -command {FilterCB} -underline 0
$m add command -label $IML_GUI_MSGS(MSG_REFRESH_NOW) -command {RefreshNow} -underline 0 -state disabled
$m add command -label $IML_GUI_MSGS(MSG_SORT_LABEL) -command {SortOptionsCB} -underline 0

#set f [frame $form.frame1]
#set w [label $f.label -text "Viewing IML on:"]
#pack $w -side left
#set w [entry $f.entry]
#pack $w -side left -fill x -expand true
#pack $f -fill x -padx 2 -pady 2

set w [tixScrolledGrid $form.listctrl -bd 0]
pack $w -expand yes -fill both -padx 3 -pady 3
set IMLListWidget [$form.listctrl subwidget grid]
#set IMLListWidget $form.listctrl
$IMLListWidget size row default -size 1.1char -pad0 3
for {set x 0} {$x < 8} {incr x} {
	$IMLListWidget size col $x -size auto
}
$IMLListWidget config -formatcmd "SimpleFormat $IMLListWidget"

set f [frame $form.frame2]
pack $f -side bottom -fill x -pady 2
set w [label $f.menustatus -textvariable menustatus -relief sunken -bd 1 -font "Helvetica 10" -anchor w]
pack $w -side left -padx 2 -expand yes -fill both

# Create the balloon widget and associate it with the widgets that we want
# to provide tips for:
#tixBalloon $form.balloon -statusbar $w -state both 

#$form.balloon bind $form.listctrl -balloonmsg "Grid"  -statusmsg "These are events" 
#$form.balloon bind $form.menu -balloonmsg "menu" -statusmsg "Press this button and it will get rid of itself" 

$form configure -menu $form.menu



#$form.frame1.entry insert 0 "localhost"

SetToAll
ParseAndUpdateList 1
UpdateMenuOptions

# Since this app is being ported over to OpenServer we need to make sure the correct library path is given
#set OSInfo [exec uname -a]
#if { [lindex $OSInfo 0] == "UnixWare"} {
#  loadlibindex /usr/lib/sysadm.tlib
#} else {
#  loadlibindex /etc/sysadm.d/lib/sysadm.tlib
#}

bind .app.menu <<MenuSelect>> {
	MenuToolTip %W
}
bind .app.menu.file <<MenuSelect>> {
	MenuToolTip %W
}
bind .app.menu.logmenu <<MenuSelect>> {
	MenuToolTip %W
}
bind .app.menu.viewmenu <<MenuSelect>> {
	MenuToolTip %W
}

proc tixScrolledGrid:B1-Leave {w} {
	tixGrid:B1-Leave $w
}

proc tixScrolledGrid:B1-Enter {w x y} {
	tixGrid:B1-Enter $w $x $y
}
#VtMainLoop
