#! /bin/sh
#
# Copyright (c) 1998, by Deltec (An Exide Company).  All rights reserved.
# ******************************************************************************
#
#
# $Date: 1998/03/04 23:14:57 $
#
# $Id: agent.sh,v 1.8 1998/03/04 23:14:57 ronp Exp $
#
# $Revision: 1.8 $
#
# $Log: agent.sh,v $
# Revision 1.8  1998/03/04 23:14:57  ronp
# This revision is for LanSafe III v4.00. Fixed aix4 and solaris problems.
#
# Revision 1.7  1998/02/26 19:22:50  ronp
# Commented out old AIX4 functions not needed anymore.
# Added files created/modified by Solaris section.
#
# Revision 1.6  1998/02/25 20:54:29  ronp
# Modified detection of Solaris Ext. Agent to be like HP-UX 10.x has.
# Changed Solaris ls3agent.init to start at S99 instead of S89.
#
# Revision 1.5  1998/02/24 00:25:13  ronp
# Fixed command line argument passing from install.sh.
# Added ls3.ver into Convert_Case function.
#
# Revision 1.4  1998/02/20 02:45:23  ronp
# Fixed uw2 problems. This works now on hpux 9.x. Fixed automatic detection of ls3 installation directory.
#
# Revision 1.3  1998/02/18 02:46:14  ronp
# This revision now installs nicely on uw2. ls3agent startup on uw2 is not complete yet.
# Also fixed sco3/sco5 detection. Started with solaris functions.
#
# Revision 1.2  1998/02/17 18:16:02  ronp
# This version runs now on sco5 and aix4.
# Modified comments in the beginning of agent.sh.
#
# Revision 1.1  1998/02/17 18:11:57  ronp
# Initial revision
#
# 
#
#             agent.sh
#
#         This agent.sh script installs LanSafe for SNMP files ls3agent and rfc1628.defs into
#         the same directory where LS3 for Unix is installed.
#    
#         ls3agent file is the LanSafe SNMP Agent executable. It requires ls3 daemon to be running
#	  in order to work.
#
#         rfc1628.defs file has RFC1628 MIB settings. ls3agent uses this file.
#
#         On AIX4 it modifies or creates files:
#
#                      /etc/snmpd.conf
#                      /etc/snmpd.peers
#                      /etc/mib.defs
#                      /etc/inittab
#
#         On HP-UX 9.x it modifies or creates files:
#
#                      /etc/snmpd.extend
#                      /etc/inittab
#
#         On HP-UX 10.x it modifies or creates files:
#
#                      /etc/SnmpAgent.d/snmp.extend
#                      /sbin/init.d/ls3agent.init
#                      /sbin/rc2.d/S568ls3agent.init
#                      /sbin/rc1.d/K485ls3agent.init
#                      
#         On SCO5 it modifies or creates files:
#
#                      /etc/snmpd.peers
#                      /etc/init.d/ls3agent.init
#                      /etc/rc2.d/S89ls3agent.init
#                      /etc/rc0.d/K99ls3agent.init
#
#         On Solaris 2.x it modifies or creates files:
#
#                      /etc/SnmpAgent.d/snmpd.extend
#                      /etc/init.d/ls3agent.init
#                      /etc/rc2.d/S99ls3agent.init
#                      /etc/rc0.d/K99ls3agent.init
#
#         On UnixWare2 it modifies or creates files:
#
#                      /etc/netmgmt/snmpd.peers
#                      /etc/init.d/ls3agent.init
#                      /etc/rc2.d/S89ls3agent.init
#                      /etc/rc0.d/K99ls3agent.init
#
#
# ******************************************************************************

PATH=$PATH:/bin:/usr/bin:/usr/ucb:.; export PATH

compute_files () {
if [ $system = "aix4" -o $SYSTEM = "AIX4" ]; then
cat <<EOF
ls3agent
rfc1628.no_mw
rfc1628.mwise
rfc1628.defs
EOF
fi
if [ $system = "sco" -o $SYSTEM = "SCO" ]; then
cat <<EOF
ls3agent
rfc1628.no_mw
rfc1628.mwise
rfc1628.defs
EOF
fi
if [ $system = "hpux" -o $SYSTEM = "HPUX" ]; then
cat <<EOF
ls3agent
rfc1628.no_mw
rfc1628.mwise
snmpd.extend.v3
snmpd.extend.v4
EOF
fi
if [ $system = "uw2" -o $SYSTEM = "UW2" ]; then
cat <<EOF
ls3agent
rfc1628.no_mw
rfc1628.mwise
rfc1628.defs
EOF
fi
if [ $system = "solari" -o $SYSTEM = "SOLARI" ]; then
cat <<EOF
ls3agent
rfc1628.no_mw
rfc1628.mwise
snmpd.extend.v4
EOF
fi
}

Convert_Case () {
    case $1 in
	ls3agent)
	    echo LS3AGENT
	;;
	rfc1628.xmw)
	    echo RFC1628.XMW
	;;
	snmpdext.v3)
	    echo SNMPDEXT.V3
	;;
	snmpdext.v4)
	    echo SNMPDEXT.V4
	;;
	snmpd.extend.v4)
	    echo SNMPDEXT.V4
	;;
	snmpd.extend.v3)
	    echo SNMPDEXT.V3
	;;
	rfc1628.defs)
	    echo RFC1628.DEF
	;;
	rfc1628.mib)
	    echo RFC1628.MIB
	;;
	rfc1628.no_mw)
	    echo RFC1628.XMW
	;;
	rfc1628.mwise)
	    echo RFC1628.MIB
	;;
    esac
}


compute_disks () {
    case $system in
    #(
    linux)
	echo  1 2 3 4	# linux_disks
	;;
    #(
    sco)
	echo  1 2 3 4	# sco_disks
	;;
    #(

    ia)
	echo  1 2 3	# ia_disks
	;;
    #(
    sunos)
	echo  1 2 3 4	# sunos_disks
	;;
    #(
    hpux)
	echo  1 2 3	# hpux_disks
	;;
    #(
    solari)
	echo  1 2 3 4	# solaris_disks
	;;
    #(
    dec)
	echo  1 2 3 4	# dec_disks
	;;
    #(
    uw2)
	echo  1 2	# unixware2_disks
	;;
    #(
    aix3)
	echo  1 2	# aix3_disks
	;;
    #(
    aix4)
	echo  1 2	# aix4_disks
	;;
    #(
    svr4)
	echo  1 2 3	# svr4_disks
	;;
    esac
}

compute_system () {
#

    set `uname -a`
    case $1 in
    #(
    Linux)
       echo linux
       ;;
    SunOS)
	case $3 in
	#(
	5.*)
	    echo solari
	    ;;
	#(
	*)
	    echo sunos
	    ;;
	esac
	;;
    #(
    HP-UX)
	echo hpux
	;;
    #(
    OSF1)
	echo dec 
	;;
    #(
    SCO_SV)
	echo sco
	;;	
    #(
    UNIX_SV)
	if [ -f /etc/issue ]; then
		grep "UnixWare" /etc/issue >/dev/null 2>/dev/null
		if [ $? != 1 ]; then
			echo uw2 
		else
			echo svr4 
		fi
	else
		echo svr4
	fi
	;;
    #(
    AIX)
	case $4 in
	#(
	3)
	    echo aix3
	    ;;
	#(
	4)
	    echo aix4
	    ;;
	esac
	;;
    #(
    *)
	if [ -c /dev/tty1A ]; then
	    echo sco
	elif [ -c /dev/ttyd0 -a "$1" != "Linux" ]; then
	    echo ia
	elif [ -c /dev/ttypa -a "$1" != "Linux" ]; then
	    echo ia
	else 
	    echo "Unknown System"
	fi
	;;
    esac
}

compute_SYSTEM () {
#

    set `uname -a`
    case $1 in

    Linux)
	echo LINUX
	;;
    #(
    SunOS)
	case $3 in
	#(
	5.*)
	    echo SOLARI
	    ;;
	#(
	*)
	    echo SUNOS
	    ;;
	esac
	;;
    #(
    HP-UX)
	echo HPUX
	;;
    #(
    OSF1)
	echo DEC 
	;;
    #(
    UNIX_SV)
	if [ -f /etc/issue ]; then
		grep "UnixWare" /etc/issue >/dev/null 2>/dev/null
		if [ $? != 1 ]; then
			echo UW2
		else
			echo SVR4
		fi
	else
		echo SVR4
	fi
	;;
    #(
    AIX)
	case $4 in
	#(
	3)
	    echo AIX3
	    ;;
	#(
	4)
	    echo AIX4
	    ;;
	esac
	;;
    #(
    *)
	if [ -c /dev/tty1A ]; then
	    echo SCO
	elif [ -c /dev/ttyd0 -a "$1" != "LINUX" ]; then
	    echo IA
	elif [ -c /dev/ttypa -a "$1" != "LINUX" ]; then
	    echo IA
	else
	  echo "Unknown System"
	fi
	;;
    esac
}

compute_sco_system () {
    set `uname -a`
    case $1 in 
    SCO_SV)
	echo sco5
	;;
    *)
	echo sco3
	;;
    esac
}

compute_uncompress () {
    for subdir in `compute_tapedirs`; do
	if [ -f $subdir/gunzip ]; then
	    echo $subdir/gunzip
	    return
	fi
    done
    if [ -f gunzip ]; then
	echo gunzip
    fi
    echo uncompress
}

untar_to () {
    name=$1
    dst=$2
    perm=$3
    prefix=.
    for subdir in `compute_tapedirs`; do
	if [ -f $subdir/$name ]; then
	    prefix=$subdir
	fi
	if [ -f $subdir/$name.z ]; then
	    prefix=$subdir
	fi
	if [ -f $subdir/$name.Z ]; then
	    prefix=$subdir
	fi
    done
    src=$prefix/$name

    create_path $dst
    check_fatal

    if [ ! -f $src ]; then
	if [ -f $src.z ]; then
	    $uncompress_cmd $src.z
	    check_fatal
	fi
	if [ -f $src.Z ]; then
	    $uncompress_cmd $src.Z
	    check_fatal
	fi
    fi

    if [ -f $dst/$name ]; then
	mv -f $dst/$name $dst/$name~ > /dev/null 2>&1
    fi

    mv -f $src $dst >/dev/null 2>&1
    if [ $? != 0 ]; then
        cp $src $dst
	check_fatal
	rm -f $src
    fi
    chmod $perm $dst/$name
    (cd $dst; tar -xvf $name |
     awk '{ print "Installing " $2 " to '$dst' ... done" }' |
     sed 's/, / /' ) 2>/dev/null
    check_fatal
    for f in `(cd $dst; tar -tf $name 2>/dev/null)`; do 
	echo "Installed: $dst/$f" >> $instpath/installed.snmp
	chmod $perm $dst/$f
	check_fatal
	chown bin $dst/$f
	chgrp bin $dst/$f
    done
    rm -f $dst/$name
}

compute_echo () {
    if [ `echo "\c" | wc -l` = 1 ]; then
        echo true
    else
        echo ""
    fi
}

echo_n () {
    if [ $bsdecho ]; then
        echo -n "$*"
    else
        echo "$*\c"
    fi
}


check_fatal () {
    if [ $? != 0 ]; then
        if [ $override ]; then
            echo "Install failed.  Override set."
            return 0
        fi
        echo "Install failed.  Exiting"
        exit 1
    fi
}

check_status () {
    if [ $? != 0 ]; then
        if [ $override ]; then
            echo "Check status failed.  Override set."
            return 0
        fi
        return 1
    fi
    return 0
}


read_def () {
    prompt=$1
    default=$2

    echo_n "$prompt"
    read answer
    if [ -z "$answer" ]; then
        answer=$default
    fi
}


kill_ls3agent () {
        pidargs=-ax                     # BSD sunos
        ps -ax > /dev/null 2>&1
        if [ $? != "0" ]; then
                pidargs=-e              # svr3 svr4
        fi
        pids=`ps $pidargs | awk '/ls3agent/ { print $1 }'`
        kill -9 $pids > /dev/null 2>&1
}

#
# AIX specific procedures start here
#

aix_check_netview () {

 ps -eo command | awk '{ if ($1 == "ovw_binary" ) exit 1 }'
   if [ $? = 1 ] ; then
       # NetView GUI is running
       netview_running=true
   else
       # NetView GUI is not running
       netview_running=
  fi

}

aix_refresh_netview () {

if [ -n "$snmpd_running" ]; then
    echo "Refreshing SNMP subsystem..."
    /usr/bin/refresh -s snmpd
fi

}


aix_check_snmpd () {

ps -eo command | awk '{ if ($1 == "snmpd" ) exit 1 }'
   if [ $? = 1 ] ; then
       # SNMP daemon is running 
       snmpd_running=true
   else
       # SNMP daemon is not running
       snmpd_running=
  fi
}

aix_check_sysmand () {

ps -eo command | awk '{ if ($1 == "sysmand" ) exit 1 }'
   if [ $? = 1 ] ; then
       # sysmand daemon is running 
       sysmand_running=true
   else
       # sysmand daemon is not running
       sysmand_running=
  fi
}


aix_get_community_name () {

   ovbinroot=/usr/OV/bin

   if [ ! -f $ovbinroot/xnmsnmpconf ]; then
      	community_name=private
   else
        # Try first with hostname
        #
        $ovbinroot/xnmsnmpconf -read $this_node_name > /dev/null 2>&1
        if [ $? = 0 ]; then
            #
            # If it fails try with *.*.*.* 
            #
            community_name=`$ovbinroot/xnmsnmpconf -read \*.\*.\*.\* | awk -F: '{ print $8 }'`
            check_fatal
        else
            community_name=`$ovbinroot/xnmsnmpconf -read $this_node_name | awk -F: '{ print $8 }'`
            check_fatal
        fi
   fi
}

aix_check_systems_monitor () {
#
# This checks if lines 
#
# Systems Monitor (SLM) is installed, trap destinations should be
# configured via the SLM's trap destination table - NOT IN THIS FILE
#
# exists in /etc/snmpd.conf file
#
    snmpd_conf=/etc/snmpd.conf

grep ^"# Systems Monitor (SLM)" $snmpd_conf 2>/dev/null

if [ $? = 0 ]; then
     # Found the first line
     grep ^"# configured via the SLM" $snmpd_conf
     if [ $? = 0 ]; then
            # Found second line.
       	    SLM_installed=true
     else
	    # Found ONLY one line.
	    # Assuming false.
            SLM_installed=""
	      fi
else
    # Did not find any lines.
    SLM_installed=""
fi

}

aix_setup_snmpd_conf () {
    snmpd_conf=/etc/snmpd.conf
    #
    # Backup old snmpd.conf
    #
    cp $snmpd_conf ${snmpd_conf}.ls3.$$
    check_fatal
    #
    #

      sed -e '
$a\
# BEGIN LanSafe for SNMP settings
$a\
smux         1.3.6.1.2.1.33.1        ls3agent_passwd '$zero_ip' '$zero_ip' # LanSafe III SNMP Agent
$a\
# END LanSafe for SNMP settings
/^# BEGIN LanSafe for SNMP settings/,/^# END LanSafe for SNMP settings/d
' ${snmpd_conf} > $snmpd_conf.ls3.$$

   check_fatal
   
    #
    # Report differences
    #
    echo
    echo "Modified: $snmpd_conf" >> $instpath/installed.snmp
    echo "The following lines were removed from $snmpd_conf:"
    diff ${snmpd_conf}.ls3.$$ $snmpd_conf | grep '^>' | sed -e 's/> //'
    echo "The following lines were added to $snmpd_conf:"
    diff ${snmpd_conf}.ls3.$$ $snmpd_conf | grep '^<' | sed -e 's/< //'
   #
   # Copy modifed file back to original
   #
   cp $snmpd_conf.ls3.$$ ${snmpd_conf}
   check_fatal
   
   rm -f $snmpd_conf.ls3.$$
}


# This one inserts trap receiver into /etc/snmpd.conf
#
OLD_aix_setup_snmpd_conf () {
    snmpd_conf=/etc/snmpd.conf
    #
    # Backup old snmpd.conf
    #
    cp $snmpd_conf ${snmpd_conf}.ls3.$$
    check_fatal
    #
    #

    if [ -z "$trap_line_needed" ]; then
      sed -e '
$a\
# BEGIN LanSafe for SNMP settings
$a\
community    private         '$zero_ip'     '$zero_ip'  readWrite   1.3.33
$a\
view         1.3.33                  1.3.6.1.2.1.33.1
$a\
smux         1.3.6.1.2.1.33.1        ls3agent_passwd '$zero_ip' '$zero_ip' # LanSafe III SNMP Agent
$a\
# END LanSafe for SNMP settings
/^# BEGIN LanSafe for SNMP settings/,/^# END LanSafe for SNMP settings/d
' ${snmpd_conf} > $snmpd_conf.ls3.$$
    else
       #
       # here we add line 
       # trap public $trap_receiver 1.3.33.1 fe
       # 
      sed -e '
$a\
# BEGIN LanSafe for SNMP settings
$a\
community    private         '$zero_ip'     '$zero_ip'  readWrite   1.3.33
$a\
trap         public                  '$trap_receiver' 1.3.33.1     fe
$a\
view         1.3.33                  1.3.6.1.2.1.33.1
$a\
smux         1.3.6.1.2.1.33.1        ls3agent_passwd '$zero_ip' '$zero_ip' # LanSafe III SNMP Agent
$a\
# END LanSafe for SNMP settings
/^# BEGIN LanSafe for SNMP settings/,/^# END LanSafe for SNMP settings/d
' ${snmpd_conf} > $snmpd_conf.ls3.$$
    fi

   check_fatal
   
    #
    # Report differences
    #
    echo
    echo "Modified: $snmpd_conf" >> $instpath/installed.snmp
    echo "The following lines were removed from $snmpd_conf:"
    diff ${snmpd_conf}.ls3.$$ $snmpd_conf | grep '^>' | sed -e 's/> //'
    echo "The following lines were added to $snmpd_conf:"
    diff ${snmpd_conf}.ls3.$$ $snmpd_conf | grep '^<' | sed -e 's/< //'
   #
   # Copy modifed file back to original
   #
   cp $snmpd_conf.ls3.$$ ${snmpd_conf}
   check_fatal
   
   rm -f $snmpd_conf.ls3.$$
}


aix_inittab_startatboot () {
    inittab=/etc/inittab
    #
    # Backup old inittab
    #
    mv -f $inittab ${inittab}.ls3agent
    check_fatal
    #
    # Use sed to remove old occurance of form below and add new
    # lines of the form below
    #
    # ls3agent:234:once:$instpath/ls3agent
    #
    if [ $startatboot = "yes" ]; then
        sed -e '
$a\
ls3agent:234:once:'$instpath'/ls3agent&
/^ls3agent:234:once:/d
' ${inittab}.ls3agent > $inittab
        check_fatal
    else
        sed -e '
/^ls3agent:234:once:/d
' ${inittab}.ls3agent > $inittab
        check_fatal
    fi
    #
    # Fixup perms on inittab.
    #
    chmod 444 $inittab
    check_fatal
    #
    # Report differences
    #
    echo
    echo "Modified: $inittab" >> $instpath/installed.snmp
    echo "The following lines were removed from $inittab:"
    diff ${inittab}.ls3agent $inittab | grep '^<' | sed -e 's/< //'
    echo "The following lines were added to $inittab:"
    diff ${inittab}.ls3agent $inittab | grep '^>' | sed -e 's/> //'
}

aix_setup_snmpd_peers () {
    snmpd_peers=/etc/snmpd.peers
    #
    # Backup old snmpd.peers
    #
    cp $snmpd_peers ${snmpd_peers}.ls3.$$
    check_fatal
    #
    # Use sed to remove old occurance of form below and add new
    # lines of the form below
    #
    # "ls3agent" 1.3.6.1.2.1.33.1              "ls3agent_passwd"
    #
    sed -e '
$a\
"ls3agent" 1.3.6.1.2.1.33.1              "ls3agent_passwd"
/^"ls3agent" 1.3.6.1.2.1.33.1/d
' $snmpd_peers > ${snmpd_peers}.ls3.$$ 
check_fatal
    
    # Report differences
    #
    echo
    echo "Modified: $snmpd_peers" >> $instpath/installed.snmp
    echo "The following lines were added from $snmpd_peers:"
    diff ${snmpd_peers}.ls3.$$ $snmpd_peers | grep '^<' | sed -e 's/< //'
    echo "The following lines were removed to $snmpd_peers:"
    diff ${snmpd_peers}.ls3.$$ $snmpd_peers | grep '^>' | sed -e 's/> //'
    #
    # Copy modified file to original
    #
    cp ${snmpd_peers}.ls3.$$ $snmpd_peers
    check_fatal
    #
    rm -f ${snmpd_peers}.ls3.$$
}


aix_setup_mib_defs () {
    mib_defs=/etc/mib.defs
    #
    # Backup old mib.defs
    #
    cp $mib_defs ${mib_defs}.ls3.$$
    check_fatal
    #
    # Use sed to remove old occurance of UPS-MIB i.e. ALL the lines
    # between lines:
    #
    # -- BEGIN LanSafe III MIB Defs
    #
    # and
    #
    # -- END LanSafe III MIB Defs
    #
    sed -e '
/^-- BEGIN LanSafe III MIB Defs/,/^-- END LanSafe III MIB Defs/d
' ${mib_defs}.ls3.$$ > $mib_defs
check_fatal
    #
    # Concatenate rfc1628.defs files into the end of /etc/mib.defs
    #
    # XXX
    cat $instpath/rfc1628.defs >>$mib_defs
    check_fatal
    #
    # Report differences
    #
    echo
    echo "Modified: $mib_defs. See $instpath/installed.snmp for details."
    echo "Modified: $mib_defs" >> $instpath/installed.snmp
    echo "The following lines were removed from $mib_defs:"  >> $instpath/installed.snmp
    diff ${mib_defs}.ls3.$$ $mib_defs | grep '^<' | sed -e 's/< //'  >> $instpath/installed.snmp
    echo "The following lines were added to $mib_defs:"  >> $instpath/installed.snmp
    diff ${mib_defs}.ls3.$$ $mib_defs | grep '^>' | sed -e 's/> //'  >> $instpath/installed.snmp

    rm -f ${mib_defs}.ls3.$$
}

#
# AIX specific procedures end here
#

#
# HP-UX specific procedures start here
#

compute_hpux_system () {
    set `uname -a`
    case $3 in
	    *.10.*)
		echo hpux10
		;;
	    *)
		echo hpux9
		;;
    esac
}

compute_hpux_SYSTEM () {
    set `uname -a`
    case $3 in
	    *.10.*)
		echo HPUX10
		;;
	    *)
		echo HPUX9
		;;
    esac
}

hpux_check_for_dfix1350 () {
#
# This checks if DFIX 1350 patch is installed on HP-UX 9.x
#
case $hp_system in
  hpux9)
	 #
	 # Ext. subagent file for HP-UX 9.x is /etc/snmpd.ea
         #
	 what `hpux_get_extend_file` | grep "Contains DFIX1350" >/dev/null 2>/dev/null

	 if [ $? = 0 ]; then
	   echo "WARNING! Patch DFIX1350 is not installed in HP OpenView Extensible SNMP Agent /etc/snmpd.ea."
	   echo
	 fi
  ;;
  *)
         # null
  ;;
esac
}

#
# Only for hpux 9.x
#
hpux_check_for_agentversion () {
#
# This checks the version number of Extensible subagent on HP-UX 9.x
#
case $hp_system in
  hpux9)
	 #
	 # Ext. subagent file for HP-UX 9.x is /etc/snmpd.ea
         #
	 what `hpux_get_extend_file` | grep "Release 3." >/dev/null 2>/dev/null

	 if [ $? = 0 ]; then
	   echo extagentv4
	 else
	   echo extagentv3
	 fi
  ;;
  *)
         # null
  ;;
esac
}

hpux_check_for_counter32 () {

extend_file=`hpux_get_extend_file`
case $hp_system in
  hpux9) 
         # hpux9 extend_file is /etc/snmp.ea
         #
	 grep "Counter32 ::= INTEGER" $extend_file >/dev/null 2>/dev/null

	 if [ $? != 0 ]; then
	   # counter32 not found
	   echo "Counter32 ::= INTEGER" >>$extend_file
	 fi
  ;;
  *)
     # null
  ;;
esac
}

hpux_check_extended_agent () {

case $hp_system in

  hpux9)
	 # XXX
	   ps -e | awk '{ if (match($4, "snmpd.ea") != 0) exit 1 }'
	     if [ $? = 1 ] ; then
	       # Ext. agent is running
	     echo
	     echo "Good! Extensible Agent for HP-UX is running."
	      extagent_running=true
	    elif [ -x /etc/snmpd.ea ]; then
	      # Ext. agent is not running, but it is installed
	      echo
	      echo "WARNING! Extensible Agent for HP-UX is installed on this system, "
	      echo "but it is not running."
	      echo
	      echo "You need to have Extensible Agent from HP-UX running on your system."
	      echo "to be able to run LanSafe III SNMP agent ls3agent."
	      extagent_running=true
	      snmpd_running=true
	    else
	      echo
	      echo "Extensible Agent for HP-UX is not installed on this system."
	      echo
	      echo "If you purchase Extensible Agent from HP, you can later install"
	      echo "LanSafe SNMP Agent by running this agent.sh script."
	      echo
	      echo "Can't continue LanSafe III SNMP Agent installation. Exiting."
	      exit 1
	      extagent_running=""
	      snmpd_running=""
	    fi
  ;;
  hpux10)
#
# On HP-UX 10.x:
#
# ls -ls /usr/sbin/extsubagt
# 1776 -r-xr-xr-x   1 root       sys         898616 Jun 10  1997 /usr/sbin/extsubagt
#
# ls -ls /usr/sbin/*.ea
#   2 lrwxrwxr-x   1 root       sys             15 Apr 17  1997 /usr/sbin/snmpd.ea -> /usr/sbin/snmpd
#
	  ps -e | awk '{ if (match($4, "extsubagt") != 0) exit 1 }'
	    if [ $? = 1 ] ; then
	      # Ext. agent is running
	      echo
	      echo "Good! Extensible Agent for HP-UX is running."
	      extagent_running=true
	    elif [ -x /usr/sbin/extsubagt ]; then
	      # Ext. agent is not running, but it is installed
	      echo
	      echo "WARNING! Extensible Agent for HP-UX is installed on this system, "
	      echo "but it is not running."
	      echo
	      echo "You need to have Extensible Agent from HP-UX running on your system."
	      echo "to be able to run LanSafe III SNMP agent ls3agent."
	      extagent_running=true
	      snmpd_running=true
	    else
	      echo
	      echo "Extensible Agent for HP-UX is not installed on this system."
	      echo
	      echo "If you purchase Extensible Agent from HP, you can later install"
	      echo "LanSafe SNMP Agent by running this hpagent.sh script."
	      echo
	      echo "Can't continue LanSafe III SNMP Agent installation. Exiting."
	      exit 1
	      extagent_running=""
	      snmpd_running=""
	    fi
	    ;;
esac
}

hpux_setup_extend_file () {
    #
    # hp 9.x /etc/snmpd.extend
    # hp 10.x /etc/SnmpAgent.d/snmpd.extend

    case $hp_system in
	hpux9)
	        if [ x"$hpux9_agentversion" = xextagentv3 ]; then
		    extend_file=/etc/snmpd.extend
		    file_to_add=$instpath/snmpd.extend.v3
		else
		    # Ext. subagent v4 on hpux9
		    extend_file=/etc/SnmpAgent.d/snmpd.extend
		    file_to_add=$instpath/snmpd.extend.v4
		fi
	;;
	hpux10)
		extend_file=/etc/SnmpAgent.d/snmpd.extend
		file_to_add=$instpath/snmpd.extend.v4
        ;;
    esac
		
    #
    # Backup old extend file.
    #
    if [ -f "$extend_file" ]; then
      cp $extend_file ${extend_file}.ls3.$$
      check_fatal
      #echo "Backing up original "$extend_file" as ${extend_file}.ls3."
      #cp -p $extend_file ${extend_file}.ls3
      check_fatal
    else
      touch ${extend_file}.ls3.$$
    fi

    if [ ! -f "$extend_file" ]; then
      echo 
      echo "File $extend_file does not exist on your system."
      echo
      echo "Creating $extend_file and adding rfc1628 MIB to it..."
      cat $file_to_add >>$extend_file
      check_fatal
      echo "Done."
    else
    #
    # Use sed to remove old occurance of UPS-MIB i.e. ALL the lines
    # between lines:
    #
    # -- BEGIN LanSafe III MIB Defs
    #
    # and
    #
    # -- END LanSafe III MIB Defs
    #
    sed -e '
/^-- BEGIN LanSafe III MIB Defs/,/^-- END LanSafe III MIB Defs/d
' ${extend_file}.ls3.$$ > $extend_file
check_fatal
    #
    # Concatenate rfc1628.defs files into the end of $extend_file
    #
    cat $file_to_add >>$extend_file
    check_fatal
  fi
    #
    # Report differences
    #
    echo
    echo "Modified: $extend_file. "
    echo "See $instpath/installed.snmp for details."
    echo "Modified: $extend_file" >> $instpath/installed.snmp
    echo "The following lines were removed from $extend_file:"  >> $instpath/installed.snmp
    diff ${extend_file}.ls3.$$ $extend_file | grep '^<' | sed -e 's/< //'  >> $instpath/installed.snmp
    echo "The following lines were added to $extend_file:"  >> $instpath/installed.snmp
    diff ${extend_file}.ls3.$$ $extend_file | grep '^>' | sed -e 's/> //'  >> $instpath/installed.snmp

    rm -f ${extend_file}.ls3.$$
}

hpux_find_snmptrap_path () {
#
# This will find the path to snmptrap
# and echo it back to be used in PATH definition 
# in the beginning of ls3agent.init
# 
case $hp_system in

  hpux9)
	# XXX
	 if [ -x /usr/OV/bin/snmptrap ]; then
	   trap_path=/usr/OV/bin
	 elif [ -x /bin/snmptrap ]; then
	   trap_path=/bin
	 fi
	 ;;
  hpux10)
	  if [ -x /opt/OV/bin/snmptrap ]; then
	    trap_path=/opt/OV/bin
	  else 
	    do_find_for_snmp_trap
	  fi
	  ;;
esac
}

hpux_do_find_for_snmp_trap () {

find / -name snmptrap -fsonly hfs -print 1>/tmp/hpagentfind.$$ 2>/dev/null

if [ -f /tmp/hpagentfind.$$ ]; then
  for eachfile in `cat /tmp/hpagentfind.$$` 
    do
      if [ -x $eachfile ]; then
	trap_path=`basename "$eachfile"`
	continue 2
      fi
    done
else
  echo
  echo "Can't find snmptrap executable on your system. Check your system setup."
  echo "You will not be able to receive traps from ls3agent to your management station."
  trap_path=""
fi

rm -f /tmp/hpagentfind.$$

}

hpux_get_extend_file () {

case $hp_system in

    hpux9)
	echo /etc/snmpd.extend
    ;;
    hpux10)
	echo /etc/SnmpAgent.d/snmpd.extend
    ;;
esac

}

hpux10_startatboot () {

  initfile=/sbin/init.d/ls3agent.init
  startfile=/sbin/rc2.d/S760ls3agent.init
  stopfile=/sbin/rc1.d/K485ls3agent.init

# This returns trap_path
  hpux_find_snmptrap_path

#   Cleanup previous install

  if [ -f $initfile ]; then
    rm -f $initfile
    echo "Removed: $initfile" >> $instpath/installed.snmp
  fi

  if [ -f $startfile ]; then
    rm -f $startfile
    echo "Removed: $startfile" >> $instpath/installed.snmp
  fi

  if [ -f $stopfile ]; then
    rm -f $stopfile
    echo "Removed: $stopfile" >> $instpath/installed.snmp
  fi
  
  #
  # Copy ls3.init while setting install path
  #      
  if [ -n "$cdrom_install" ]; then
    InstallFile=1_INSTAL/LS3AGENT.INI
  else
    InstallFile=1_install/ls3agent.init
  fi

# Old sed line sed '/PATH=\$PATH:\/usr\/OV\/bin\/snmptrap; export PATH/\c
  
  if [ "$startatboot" = "yes" ]; then
    echo_n "Installing ls3agent.init to init.d ... "
sed -e '/PATH=/c\
PATH=$PATH:'$trap_path'; export PATH
/\usr\/ls3/c\
instpath='$instpath'
    ' $InstallFile > $initfile
    check_fatal
    #
    # Set permissions
    #
    chmod 755 $initfile
    check_fatal
    echo "Installed: $initfile" >> $instpath/installed.snmp
    echo "done"
    #
    # Link init file in rc dirs.
    # 
    echo_n "Linking $startfile to $initfile ... "
    if [ -d /sbin/init.d -o -d /etc/rc.d/init.d ]; then
      ln -fs $initfile $startfile
    else
      ln $initfile $startfile
    fi
    check_fatal
    echo "Linked: $startfile to $initfile" >> $instpath/installed.snmp
    echo "done"
    
    echo_n "Linking $stopfile to $initfile ... "
    if [ -d /sbin/init.d -o -d /etc/rc.d/init.d ]; then
      ln -fs $initfile $stopfile
    else
      ln $initfile $stopfile
    fi
    check_fatal
    echo "Linked: $stopfile to $initfile" >> $instpath/installed.snmp
    echo "done"
  fi
# end-of hpux10_startatboot 
}

#
# This is not called anymore, since /usr/ls3/ls3.sh takes care of starting ls3agent.
#
hpux9_startatboot () {

    inittab=/etc/inittab
    #
    # Backup old inittab
    #
    mv -f $inittab ${inittab}.ls3agent
    check_fatal
    #
    # Use sed to remove old occurance of form below and add new
    # lines of the form below
    #
    # ls3agent:234:once:$instpath/ls3agent.sh
    #
    if [ $startatboot = "yes" ]; then
	sed -e '
$a\
ls3agent:234:once:'$instpath'/ls3agent.sh&
/^ls3agent:234:once:/d
' ${inittab}.ls3agent > $inittab
	check_fatal
    else
	sed -e '
/^ls3agent:234:once:/d
' ${inittab}.ls3agent > $inittab
	check_fatal
    fi
    #
    # Fixup perms on inittab.
    #
    chmod 444 $inittab
    check_fatal
    #
    # Report differences
    #
    echo "Modified: $inittab" >> $instpath/installed.snmp
    echo "The following lines were removed from $inittab:"
    diff ${inittab}.ls3agent $inittab | grep '^<' | sed -e 's/< //'
    echo "The following lines were added to $inittab:"
    diff ${inittab}.ls3agent $inittab | grep '^>' | sed -e 's/> //'

# modify ls3agent.sh

	InstallFile=$instpath/ls3agent.tmp
	FinalFile=$instpath/ls3agent.sh
	mv $FinalFile $InstallFile

	sed '/\usr\/ls3/c\
instpath='$instpath'
' $InstallFile > $FinalFile

	chmod 744 $instpath/ls3agent.sh

}

#
# HP-UX specific procedures end here
#


#
# SCO5 specific procedures start here
#

sco5_setup_snmpd_peers () {

    snmpd_peers=/etc/snmpd.peers
    #
    # Backup old snmpd.peers
    #
    cp $snmpd_peers ${snmpd_peers}.ls3.$$
    check_fatal
    #
    # Use sed to remove old occurance of form below and add new
    # lines of the form below
    #
    # "ls3agent" 1.3.6.1.2.1.33.1              "ls3agent_passwd"
    #
    sed -e '
$a\
"ls3agent" 1.3.6.1.2.1.33.1              "ls3agent_passwd"
/^"ls3agent" 1.3.6.1.2.1.33.1/d
' $snmpd_peers > ${snmpd_peers}.ls3.$$ 
check_fatal
    
    # Report differences
    #
    echo
    echo "Modified: $snmpd_peers" >> $instpath/installed.snmp
    echo "The following lines were added from $snmpd_peers:"
    diff ${snmpd_peers}.ls3.$$ $snmpd_peers | grep '^<' | sed -e 's/< //'
    echo "The following lines were removed to $snmpd_peers:"
    diff ${snmpd_peers}.ls3.$$ $snmpd_peers | grep '^>' | sed -e 's/> //'
    #
    # Copy modified file to original
    #
    cp ${snmpd_peers}.ls3.$$ $snmpd_peers
    check_fatal
    #
    rm -f ${snmpd_peers}.ls3.$$
}

sco5_check_snmpd () {
#
# $4 is the last field in ps -ef output of sco5.
#
ps -e | awk '{ if (match($4, "snmpd") != 0) exit 1 }'
   if [ $? = 1 ] ; then
       # SNMP daemon is running 
       snmpd_running=true
   else
       # SNMP daemon is not running
       snmpd_running=
  fi
}

#
# SCO5 specific procedures end here
#


#
# UnixWare2 specific procedures start here
#

uw2_setup_snmpd_peers () {

    snmpd_peers=/etc/netmgt/snmpd.peers
    #
    # Backup old snmpd.peers
    #
    cp $snmpd_peers ${snmpd_peers}.ls3.$$
    check_fatal
    #
    # Use sed to remove old occurance of form below and add new
    # lines of the form below
    #
    # "ls3agent" 1.3.6.1.2.1.33.1              "ls3agent_passwd"
    #
    sed -e '
$a\
"ls3agent" 1.3.6.1.2.1.33.1              "ls3agent_passwd"
/^"ls3agent" 1.3.6.1.2.1.33.1/d
' $snmpd_peers > ${snmpd_peers}.ls3.$$ 
check_fatal
    
    # Report differences
    #
    echo
    echo "Modified: $snmpd_peers" >> $instpath/installed.snmp
    echo "The following lines were added from $snmpd_peers:"
    diff ${snmpd_peers}.ls3.$$ $snmpd_peers | grep '^<' | sed -e 's/< //'
    echo "The following lines were removed to $snmpd_peers:"
    diff ${snmpd_peers}.ls3.$$ $snmpd_peers | grep '^>' | sed -e 's/> //'
    #
    # Copy modified file to original
    #
    cp ${snmpd_peers}.ls3.$$ $snmpd_peers
    check_fatal
    #
    rm -f ${snmpd_peers}.ls3.$$
}

uw2_check_snmpd () {
#
# $6 is the last field in ps -ef output of uw2.
#
ps -e | awk '{ if (match($6, "in.snmpd") != 0) exit 1 }'
   if [ $? = 1 ] ; then
       # SNMP daemon is running 
       snmpd_running=true
   else
       # SNMP daemon is not running
       snmpd_running=
  fi
}

#
# UnixWare2 specific procedures end here
#


#
# Solaris 2.x specific procedures start here
#

solaris_check_extended_agent () {
#
# On Solaris:
#
# ls -ls /usr/sbin/extsubagt
# 584 -r-x------  1 root       586188 Feb 10 10:01 /usr/sbin/extsubagt
#
# ls -ls /usr/sbin/*.ea
#   1 lrwxrwxrwx  1 root           15 Feb 10 10:01 /usr/sbin/snmpd.ea -> /usr/sbin/snmpd
#
# $4 is the last field in ps -e output of Solaris.
#
# MUST use awk's index instead of match here.
#
# MUST try to find match for extsubag (NOT extsubagt), since last field
# in "ps -e" output is truncated.
#
ps -e | awk '{ if (index($4, "extsubag") != 0) exit 1 }'
    if [ $? = 1 ] ; then
	# Ext. agent is running 
	echo
	echo "Good! Extensible Agent for Solaris is running."
        extagent_running=true
    elif [ -x /usr/sbin/extsubagt ] ;then
	# Ext. agent is not running, but it is installed
	echo
	echo "WARNING! Extensible Agent for Solaris is installed on this system, "
	echo "but it is not running."
	echo
	echo "You need to have Extensible Agent from Solaris running on your system."
	echo "to be able to run LanSafe III SNMP agent ls3agent."
	extagent_running=true
	snmpd_running=true
    else
	echo
	echo "Extensible Agent for Solaris is not installed on this system."
	echo
	echo "If you purchase Extensible Agent from Sun Microsystems, you can later install"
	echo "LanSafe SNMP Agent by running this agent.sh script."
	echo
	echo "Can't continue LanSafe III SNMP Agent installation. Exiting."
	exit 1
	extagent_running=""
	snmpd_running=""
    fi
}

solaris_setup_extend_file () {

    extend_file=/etc/SnmpAgent.d/snmpd.extend
    file_to_add=$instpath/snmpd.extend.v4
		
    #
    # Backup old extend file.
    #
    if [ -f "$extend_file" ]; then
      cp $extend_file ${extend_file}.ls3.$$
      check_fatal
      #echo "Backing up original "$extend_file" as ${extend_file}.ls3."
      #cp -p $extend_file ${extend_file}.ls3
      check_fatal
    else
      touch ${extend_file}.ls3.$$
    fi

    if [ ! -f "$extend_file" ]; then
      echo 
      echo "File $extend_file does not exist on your system."
      echo
      echo "Creating $extend_file and adding rfc1628 MIB to it..."
      cat $file_to_add >>$extend_file
      check_fatal
      echo "Done."
    else
    #
    # Use sed to remove old occurance of UPS-MIB i.e. ALL the lines
    # between lines:
    #
    # -- BEGIN LanSafe III MIB Defs
    #
    # and
    #
    # -- END LanSafe III MIB Defs
    #
    sed -e '
/^-- BEGIN LanSafe III MIB Defs/,/^-- END LanSafe III MIB Defs/d
' ${extend_file}.ls3.$$ > $extend_file
check_fatal
    #
    # Concatenate rfc1628.defs files into the end of $extend_file
    #
    cat $file_to_add >>$extend_file
    check_fatal
  fi
    #
    # Report differences
    #
    echo
    echo "Modified: $extend_file. "
    echo "See $instpath/installed.snmp for details."
    echo "Modified: $extend_file" >> $instpath/installed.snmp
    echo "The following lines were removed from $extend_file:"  >> $instpath/installed.snmp
    diff ${extend_file}.ls3.$$ $extend_file | grep '^<' | sed -e 's/< //'  >> $instpath/installed.snmp
    echo "The following lines were added to $extend_file:"  >> $instpath/installed.snmp
    diff ${extend_file}.ls3.$$ $extend_file | grep '^>' | sed -e 's/> //'  >> $instpath/installed.snmp

    rm -f ${extend_file}.ls3.$$
}

#
# Solaris 2.x specific procedures end here
#

#
# Common/shared procedures start here
#

#
# for uw2, sco5 and solaris
#
sysv_startatboot () {

    if [ -d /etc/init.d ]; then
	initfile=/etc/init.d/ls3agent.init

	if [ "$system" = solari -o "$SYSTEM" = SOLARI ]; then
	    startfile=/etc/rc2.d/S99ls3agent.init
	else
	    startfile=/etc/rc2.d/S89ls3agent.init
	fi

        stopfile=/etc/rc0.d/K99ls3agent.init
    else
	echo "Directory /etc/init.d does not exist."
	echo "Skipping ls3agent modifications to rc files."
	return
    fi

#
#
#
    if [ '(' "$system" = solari -o  "$SYSTEM" = SOLARI ')' -a '(' ! -x /opt/OV/bin/snmptrap ')' ]; then
	    echo " "
	    echo "NOTE! snmptrap executable can not be found in its default location /opt/OV/bin."
	    echo "Please manually edit PATH variable setting in "
	    echo " "
	    echo "$initfile and $startfile files."
	    echo " "
	    echo "to reflect your system setup."
	    echo " "
     fi

    #
    # Cleanup from previous install, okay for these to fail
    #  

    if [ -f $initfile ]; then
        rm -f $initfile
        echo "Removed: $initfile" >> $instpath/installed.snmp
    fi
    if [ -f $startfile ]; then
        rm -f $startfile
        echo "Removed: $startfile" >> $instpath/installed.snmp
    fi
    if [ -f $stopfile ]; then
        rm -f $stopfile
        echo "Removed: $stopfile" >> $instpath/installed.snmp
    fi
    #
    # Copy ls3agent.init while setting install path
    #      
        if [ -n "$cdrom_install" ]; then
              InstallFile=1_INSTAL/LS3AGENT.INI
        else
              InstallFile=1_install/ls3agent.init
        fi

    if [ "$startatboot" = "yes" ]; then
        echo_n "Installing ls3agent.init to init.d ... "
        sed '/\usr\/ls3/c\
instpath='$instpath'
' $InstallFile > $initfile
        check_fatal
        #
        # Set permissions
        #
        chmod 755 $initfile
        check_fatal
        echo "Installed: $initfile" >> $instpath/installed.snmp
        echo "done"
        #
        # Link init file in rc dirs.
        # 
        echo_n "Linking $startfile to $initfile ... "
	#
	# sym. link with force for sco
	#
	if [ "$system" = sco -o "$SYSTEM" = SCO ]; then
	    ln -fs $initfile $startfile
	else
	    ln $initfile $startfile
	fi
        check_fatal

        echo "Linked: $startfile to $initfile" >> $instpath/installed.snmp
        echo "done"

        echo_n "Linking $stopfile to $initfile ... "

	# sym. link with force for sco
	if [ "$system" = sco -o "$SYSTEM" = SCO ]; then
	    ln -fs $initfile $stopfile
	else
	    ln $initfile $stopfile
	fi
        check_fatal

        echo "Linked: $stopfile to $initfile" >> $instpath/installed.snmp
        echo "done"
fi

# end-of sysvstartatboot
}


#
# Common/shared procedures end here
#

check_ls3 () {

        pidargs=-ax                     # BSD sunos
        ps -ax > /dev/null 2>&1
        if [ $? != "0" ]; then
                pidargs=-e              # svr3 svr4
        fi
	#
        # ps $pidargs | grep ls3 | grep -v grep | awk '{ print $9 }' | grep ls3$
 	# Above doesn't seem to work.
	#
	# XXX This should work on all systems now.
	#
        ps $pidargs | awk '{ if ($1 == "ls3") exit 1 }'
	if [ $? = 1 ]; then
		echo
		echo "Good! LanSafe for Unix Power Monitor daemon ls3 is running."
		echo
	else
		echo
		echo "NOTE! LanSafe for Unix Power Monitor daemon ls3 is not running."
		echo 
		echo "     LanSafe SNMP agent requires ls3 power monitor daemon to be running"
                echo "     in order to communicate with the SNMP daemon snmpd."
 	        echo
		echo "Please start ls3 manually or reboot your system to get it running "
		echo "if it was configured to start at boot."
		echo
	fi
}


OLD_aix_get_trap_receiver () {

  trap_receiver=""

  echo "Please enter the hostname or IP address of a node that should"
  echo "receive UPS traps from this node. "
  echo
  echo "Node receiving traps is typically a node running network management"
  echo "system."
  echo
  echo "You can later add additional trap receivers by editing LanSafe "
  echo "section in /etc/snmpd.conf file."
  echo
  echo "An example:"
  echo
  echo "    trap	public	hostname_or_IP	1.3.33.x	fe"
  echo
  echo "where x is unique number not found in any other LanSafe trap lines."
  echo
  while [ -z "$trap_receiver" ]; do
    read_def "   Please enter hostname or IP address: "
     host $answer > /dev/null 2>&1
      check_status
          if [ $? != 0 ]; then
                 echo
                 echo "You entered invalid hostname or IP address."
                 trap_receiver=""
          else
                 trap_receiver=$answer
                 #echo "Trap receiver set to: " $trap_receiver
          fi
done

}


compute_hostname_cmd () {
    case "$system" in
	sco)
	    if [ -x /usr/bin/hostname ]; then
		echo /usr/bin/hostname
	    else
		echo hostname
	    fi
	;;
	uw2)
	    if [ -x /usr/ucb/hostname ]; then
		echo /usr/ucb/hostname
	    else
		echo hostname
	    fi
	;;
	aix4)
	    if [ -x /usr/bin/hostname ]; then
		echo /usr/bin/hostname
	    else
		echo hostname
	    fi
	;;
	*)
	    echo hostname
	;;
     esac
}

get_hostname () {

if [ "$system" = aix4 ]; then
    temphostname=`compute_hostname_cmd`
    
    temphostname2=`host $temphostname`

    echo $temphostname2 | awk '{ print $1 }'
fi

}

#
# This works only on aix4!
# 
# XXX Danger here!
#
get_IP_address () {

if [ "$system" = aix4 ]; then
    temphostname=`hostname`
    check_fatal
    temphostname2=`host $temphostname`
    check_fatal

    echo $temphostname2 | awk '{ print $3 }'
fi

}

get_tardev () {
    tardev=""
    while [ -z "$tardev" ]; do
        echo
        echo "Please enter the name of the device (or tarfile) to install from."
        read_def "   Install device: "
        if [ -z "$answer" ]; then
            continue
        fi
        if [ '(' -c "$answer" ')' -o '(' -b "$answer" ')' ]; then
            tardev=$answer
        elif [ -d $answer ]; then
            echo "'$answer' is a invalid because it is a directory?"
        elif [ -f $answer ]; then
            echo "Expecting a device name, but '$answer' is a file?"
            tardev=$answer
            read_def "   Is this okay? (y/n) [n] " "n"
            case $answer in
           #(
            [yY]|[yY][eE][sS])
                tar_install=true
                ;;
            #(
            *)
                tardev=""
                ;;
            esac
        else
            echo "'$answer' does not exist or is not a device?"
            if [ $override ]; then
                echo "Override set, using '$answer'."
                tardev=$answer
            else
                continue
            fi
        fi
    done
}


get_boot_flag () {

                # Get start at boot flag
                #
		echo
                echo "Automatic Startup"
  		echo
                echo "To automatically run LanSafe SNMP agent upon startup on the computer"
                echo "being installed, enter (y)es, otherwise enter (n)o."
		echo
                echo "NOTE: It is strongly recommended that you select Yes for this option"
                echo "in order to provide complete SNMP management capability."
                echo
                read_def "   Automatically run LanSafe SNMP agent on startup? (y/n) [y] " "y"
                case $answer in
                #(
                [yY]|[yY][eE][sS])
                    startatboot="yes"
                    ;;
                #(
                *)
                    startatboot="no"
                    ;;
                esac
}


echo_config () {

 #
                # Echo configuration and verify
                #
	if [ $# -eq 1 ]; then
                echo
                echo "---------------------------------------------------------------"
                echo "LanSafe III SNMP Agent Installation Parameters:"
                echo
                echo "                     Directory to install to is:  $instpath"
		echo "Automatically run LanSafe SNMP agent on startup:  $startatboot"
                echo "---------------------------------------------------------------"
                echo
    	else
		echo
                echo "---------------------------------------------------------------"
                echo "LanSafe III SNMP Agent Installation Parameters:"
                echo
                echo "                     Device to install from is :  $tardev"
                echo "                     Directory to install to is:  $instpath"
                echo "Automatically run LanSafe SNMP agent on startup:  $startatboot"
                echo "---------------------------------------------------------------"
                echo
	fi
                answer=""
                while [ -z "$answer" ]; do
                    echo
                    read_def "  Are these installation parameters acceptable? (y/n) "
                done
                case $answer in
                #(
                [yY]|[yY][eE][sS])
                    userverified=true
                    ;;
		#(
		*)
		    userverified=""
		    ;;
                esac
}

extract_files () {
    firsttime=true
    while [ -z "$tardev" -o ! -z "$firsttime" ]; do
	#
	# Prompt for different device name only if extract below fails
	# i.e firsttime=""
	#
	if [ -z "$firsttime" ]; then
	    get_tardev
	fi
	firsttime=""
	case $tardev in
	#(
	*f0*|*f1*|*fd*|*floppy*|*dsk*)
	    media=disk
	    #
	    # For each disk
	    #
	    for disk in `compute_disks`; do
		if [ $disk != "1" ]; then
		    maybe_eject
		    if [ "$system" = "ia" ]; then
			LongName="Interactive"
		    else
			LongName="$system"
		    fi	
		    echo
		    echo_n "Insert $LongName disk #"$disk "... press Enter when ready. "
		    read x
		fi
		echo   "Extracting files ..."
		if [ $disk != 1 ]; then
		    tar -xf $tardev ${disk}_$system > /dev/null 2>&1
		else
		    tar -xf $tardev ${disk}_install > /dev/null 2>&1
		fi
		check_status
		if [ $? != 0 ]; then
		    echo "Error extracting files?"
		    tardev=
		    continue 2
		fi
	    done
	    maybe_eject
	    ;;
	#(
	*st*|*mt*|*)
	    media=tape
	    echo
	    echo   "Extracting files ..."
	    tar -xf $tardev `compute_tapedirs` > /dev/null 2>&1
	    check_status 
	    if [ $? != 0 ]; then
		echo "Error extracting files?"
		tardev=
		continue
	    fi
	    ;;
	esac
    done
# end-of extract_files
} 

create_path() {
    fullpath=""
    for path in `echo $1 | sed 's/\// /g'`; do
	fullpath=$fullpath/$path
	if [ ! -d $fullpath ]; then
	    mkdir $fullpath
	    if [ $? != 0 ]; then
		return 1
	    fi
	    chmod 755 $fullpath
	    chown bin $fullpath
	    chgrp bin $fullpath
	    if [ $? != 0 ]; then
		return 1
	    fi
	fi
    done
    if [ -d $1 ]; then
	return 0
    fi
    return 1
}

compute_topath () {
    case $1 in
	*)
	  echo $instpath
    ;;
    esac
}

compute_toperm () {
    case $1 in
	rfc*)
	    echo 0444
	;;
	ls3agent|ls3agent.sh)
	    echo 0744
	;;
	*)
	    echo 0444
	;;
    esac
}

compute_tapedirs () {
    for disk in `compute_disks`; do
	case $disk in
	1)
		if [ -n "$cdrom_install" ]; then	
	    		echo_n ${disk}_INSTAL " "
		else
               	echo_n ${disk}_install " " 
		fi
	    ;;
	*)
		if [ -n "$cdrom_install" ]; then
			echo_n ${disk}_$SYSTEM " "
		else
			echo_n ${disk}_$system " "
		fi
	    ;;
	esac
    done
    echo
}

install_to () {
    name=$1
    dst=$2
    perm=$3
    prefix=.
    lc_name=$name

    if [ -n "$cdrom_install" ]; then
	name=`Convert_Case $name`
    fi

    echo_n "Installing $lc_name to $dst ... "
    for subdir in `compute_tapedirs`; do
        
	   if [ -f $subdir/$name ]; then
	 	  prefix=$subdir
	   fi
	  if [ -f $subdir/$name.z ]; then
	    	  prefix=$subdir
	  fi
	  if [ -f $subdir/$name.Z ]; then
	    	  prefix=$subdir
	  fi
     done

#
#src=$subdir/$name

src=$prefix/$name

    create_path $dst
    check_fatal

    if [ ! -f $src ]; then
	if [ -f $src.z ]; then
	    $uncompress_cmd $src.z
	    check_fatal
	fi
	if [ -f $src.Z ]; then
		if [ -n "$cdrom_install" ]; then
			cp $src.Z /tmp/$name.Z
			$uncompress_cmd /tmp/$name.Z
			src=/tmp/$name
	   	else
	    		$uncompress_cmd $src.Z
		fi
	    check_fatal
	fi
    fi

    rm -f $dst/$lc_name
    if [ -f $dst/$lc_name ]; then
	mv -f $dst/$lc_name $dst/$lc_name~ > /dev/null 2>&1
    fi

     if [ -n "$cdrom_install" ]; then
		cp $src $dst/$lc_name
		check_fatal
	else
 		mv -f $src $dst/$lc_name >/dev/null 2>&1

    	if [ $? != "0" ]; then
                cp $src $dst/$lc_name
		check_fatal
		rm -f $src
    	fi
    fi
	
    chmod $perm $dst/$lc_name
    check_fatal
    chown bin $dst/$lc_name
    chgrp bin $dst/$lc_name
    echo "Installed: $dst/$lc_name" >> $instpath/installed.snmp
    echo "done"

# end-of install_to
}


install_files () {
    echo
    rm -f $instpath/installed.snmp
    uncompress_cmd=`compute_uncompress`

     for f in `compute_files`; do
	topath=$instpath
	toperm=`compute_toperm $f`
	
	    case $f in
		*.tar)
		    untar_to $f $topath $toperm
		    ;;
		*)
		    install_to $f $topath $toperm
		    ;;
	     esac
     done
}


Get_custompath () {
     custompath=""
             while [ -z "$custompath" ]; do
                echo
                echo "Please enter the absolute custom path where LanSafe for Unix is installed."
                echo
                read_def "   Enter absolute path: "
                enteredpath=$answer
                     case $enteredpath in
                        #(
                        /*)
                             if [ '(' -c "$enteredpath" ')' -o '(' -b "$enteredpath" ')' -o '(' -f "$enteredpath" ')' ]; then
				echo
                                echo "'$enteredpath' is a invalid because it is not a directory?"
                                custompath=""
		             elif [ -d $enteredpath -a ! -f $enteredpath/ls3 ]; then
			 	echo 
				echo "Directory $enteredpath exists, but there is no LanSafe power monitor ls3 executable." 
				read_def "   Is this okay? (y/n) [n] " "n"

					 case $answer in
				            #(
				            [yY]|[yY][eE][sS])
						custompath=$enteredpath
                				;;
				            #(
				            *)
				                custompath=""
				                ;;
			                 esac
			     else 
				if [ ! -d $enteredpath ]; then
				   echo
  				   echo "$enteredpath does not exist."
				   custompath=""
				else
                                   custompath=$enteredpath
 				fi
                             fi
                        ;;
                        #(
                        *)
                           echo
                           echo "You must enter absolute path to LanSafe install directory."
                           custompath=""
                        ;;
                     esac
            done
}



#
# main
#

main () {

system=`compute_system`
SYSTEM=`compute_SYSTEM`

    # Need to know if we are on sco3 or sco5 at this point.
    #
    if [ "$system" = sco -o "$SYSTEM" = SCO ]; then
	sco_system=`compute_sco_system`
    fi

#
# ls3agent is not available for these systems:
#
#  aix3, dec, interactive, linux, sunos, svr4 and sco3
#
if [ '(' "$system" = aix3 ')' -o '(' "$system" = dec ')' -o '(' "$system" = ia ')' -o '(' "$system" = linux ')' \
    -o '(' "$system" = sunos ')' -o '(' "$system" = svr4 ')' -o '(' "$SYSTEM" = AIX3 ')' -o '(' "$SYSTEM" = DEC ')' \
    -o '(' "$SYSTEM" = IA ')' -o '(' "$SYSTEM" = LINUX ')' -o '(' "$SYSTEM" = SUNOS ')' -o '(' "$SYSTEM" = SVR4 ')' \
    -o '(' x$sco_system = xsco3 ')' ];
then 
     echo 
     echo "LanSafe III SNMP agent is not available for this system."
     echo "Cannot continue agent.sh execution."
     exit 0
fi


if [ "$system" = aix4 ]; then
#    this_node_name=`get_hostname`
#    this_node_ip=`get_IP_address`
    zero_ip=0.0.0.0
fi

#
# Need to find out if it is HP 9.x or HP 10.x
#
if [ "$system" = hpux ]; then
  hp_system=`compute_hpux_system`
fi

#
# Set $1 to be the tardev specifed by user in install.sh
#
if [ $# -eq 1 ]; then

    tardev="$1"

   if [ "$tardev" = CD_ROM ]; then
        skip_extract=true
        skip_gettardev=tar
   elif [ -c "$tardev" -o -b "$tardev" ]; then
	skip_gettardev=tar
   elif [ -f ./"$tardev" ]; then
	# tar installation
	tar_install=true
	skip_gettardev=tar
   else
	echo "$tardev: not a device name."
	exit 0
   fi

fi

#
# If two parameters
#
if [ x"$two_parameters" = xtrue ]; then

    tardev="$1"
    instpath="$2"

     if [ "$tardev" = CD_ROM ]; then
        skip_extract=true
        skip_gettardev=tar
     elif [ -c "$tardev" -o -b "$tardev" ]; then
        skip_gettardev=tar
     elif [ -f ./"$tardev" ]; then
	# tar installtion
	tar_install=true
	skip_gettardev=tar
     else
        echo "$tardev: not a device name."
        exit 0
     fi

    if [ -d "$instpath" ]; then
	skip_instpath=true
    else
        echo "$instpath: No such directory."
	exit 0
    fi
fi


#
# Say hello
# 

# If agent.sh is directly called from install.sh 
# with two parameters then do not display this banner.

if [ ! $# -eq 2 ]; then

 echo
    echo   "           Welcome to LanSafe SNMP Agent!"
    echo   "                Version 4.00"
    echo
    echo   "To install LanSafe SNMP agent, press <ENTER>"
    echo   "and fill in the configuration items as they are presented to you."
    echo
    echo   "NOTE that in order to run LanSafe SNMP agent you need to"
    echo   "have LanSafe for Unix already installed in your system."
    echo

    if [ ! x"$two_parameters" = xtrue ]; then
	echo   "This installation script will later prompt you to enter the directory"
	echo   "in which LanSafe for Unix was installed unless LS3 is not found under /usr/ls3."
    fi

    echo
    read_def "  Continue installation? (y/n) [y] " "y"
    case $answer in
    #(
    [yY]|[yY][eE][sS])
        ;;
    #(
    *)
        exit 0
        ;;
    esac
fi

#system=`compute_system`
bsdecho=`compute_echo`

#
#if [ "$system" = aix4 ]; then
#  aix_get_community_name
#fi

#
# Check first if snmpd is running
#

snmpd_running=""

if [ "$system" = aix4 ]; then
  aix_check_snmpd
fi

if [ "$system" = hpux ]; then
  hpux_check_extended_agent
fi

if [ "$hp_system" = hpux9 ]; then
    hpux_check_for_dfix1350 
fi

if [ "$system" = sco ]; then
  sco5_check_snmpd
fi

if [ "$system" = uw2 ]; then
  uw2_check_snmpd
fi

if [ "$system" = solari ]; then
  solaris_check_extended_agent
fi


if [ '(' "$system" = hpux ')' -o '(' "$system" = solari ')' -o '(' "$SYSTEM" = HPUX ')' -o \
     '(' "$SYSTEM" = SOLARI ')' ]; then
     echo

  elif [ -n "$snmpd_running" ]; then
     echo
     echo "Good! SNMP daemon snmpd is running on this node."
     echo
  else
     echo
     echo "WARNING! SNMP daemon snmpd is not running on this node."
     echo "SNMP daemon must be running in order to use the LanSafe"
     echo "SNMP agent."
     echo "Please consult your system's documentation for instructions"
     echo "on installing and running the SNMP daemon."
  fi


if [ "$system" = aix4 ]; then
  #
  # Check if sysmand is running
  #

  #sysmand_running=""

  #aix_check_sysmand

  #
  # check if there are lines for Systems Monitor in 
  # /etc/snmpd.conf
  #

  #SLM_installed=""

  #aix_check_systems_monitor

  #
  # Determine if trap line is needed in /etc/snmpd.conf
  # See function setup_snmpd_conf
  #
  # It is NOT needed if sysmand is running OR
  # SLM line are found on /etc/snmpd.conf
  #
  # We do not add trap receivers anymore.
  #
  #if [ -n "$sysmand_running" -o -n "$SLM_installed" ]; then
  #  trap_line_needed=""
  #else
  #  trap_line_needed=true
  #fi
  
  # Check if NetView for AIX GUI is running
  #
  
  netview_running=""
  
#  if [ "$system" = aix4 ]; then
#    aix_check_netview
#  fi
  
#  if [ -n "$netview_running" ]; then
#    echo
#    echo "NetView for AIX GUI is running."
#  fi

#  aix_get_trap_receiver

fi

        #       Is the installation from a cd-rom?
        #       if the name of this file is in CAPITAL letters
        #       then it is on a CD-ROM.
        CD_Script=AGENT.SH
        if [ -f ./AGENT.SH ]; then
                cdrom_install=true
                skip_extract=true
                skip_gettardev=tar
                skip_cleanup=true
                tardev=CD_ROM
                SYSTEM=`compute_SYSTEM`
        fi


  #       Kill the ls3agent if it is running so the copy during
  #       installation will run OK
  kill_ls3agent

# XXX
# tardev and instpath were provided from install.sh where
# agent.sh was called as
#
# agent.sh $tardev $instpath
#
if [ ! -z "$skip_tardev" -a ! -z "$skip_instpath" ]; then
	if [ -z "$skip_extract" ]; then
	    extract_files
        fi
	install_files
	if [ -z "$skip_cleanup" ]; then
                   rm -rf `compute_tapedirs`
                   rm -f agent.sh
        fi
	#exit 0
fi

    if [ '(' x"$two_parameters" = xtrue ')' -a '(' -d "$instpath" ')' -a '(' -f "$instpath"/ls3 ')' ]; then
          echo
          echo "LanSafe SNMP agent will be installed in the same directory ($instpath) "
          echo "as LanSafe for Unix."
          echo
                if [ -z "$skip_gettardev" ]; then
                    get_tardev
                fi
                get_boot_flag
                if [ -z "$skip_extract" ]; then
                      extract_files
                fi
                install_files
     elif [ -d /usr/ls3 -a -f /usr/ls3/ls3 ]; then
           echo
           echo "LanSafe for Unix installation has been detected in the "
           echo "directory /usr/ls3."
           echo 
   	   echo "LanSafe SNMP agent must be installed in the same directory"
           echo "as LanSafe for Unix."
           echo
		instpath=/usr/ls3
		if [ -z "$skip_gettardev" ]; then
                        get_tardev
                fi
		get_boot_flag
		if [ -z "$skip_extract" ]; then
                   extract_files
                fi
		install_files
else
   echo
   echo "Could not find LanSafe for Unix installation in the standard installation"
   echo "directory /usr/ls3."
   echo
   read_def " Do you want to continue LanSafe SNMP agent installation by specifying your custom LanSafe III for Unix installation directory? (y/n) [y] " "y"

     case $answer in
            [yY]|[yY][eE][sS])
		Get_custompath
                instpath=$custompath
                userverified=""
                     while [ -z "$userverified" ]; do
                         if [ -z "$skip_gettardev" ]; then
                             get_tardev
                         fi
                         if [ -z "$instpath" ]; then
                             Get_custompath
                             instpath=$custompath
                         fi
                       get_boot_flag
                       echo_config
                         if [ -z "$userverified" ]; then
                             instpath=""
                             skip_gettardev=""
                         fi
                     done
                         if [ -z "$skip_extract" ]; then
                             extract_files
                         fi
                install_files
                ;;
            *)
		if [ -z "$skip_cleanup" ]; then
                   rm -rf 1_install 2_$system
                   rm -f agent.sh
                fi
		exit 0
                ;;
     esac

 
fi

#
# Check if ls3 daemon is running

check_ls3


if [ "$system" = aix4 -o "$SYSTEM" = AIX4 ]; then
#
# Setup /etc/snmpd.conf, /etc/snmpd.peers and /etc/mib.defs.
#

  aix_setup_snmpd_conf
  check_fatal

  aix_setup_snmpd_peers
  check_fatal

  aix_setup_mib_defs
  check_fatal
  
#  aix_refresh_netview
#  check_fatal

fi


if [ "$system" = hpux ]; then
#
# extensible subagent files on hpux:
#
# hp 9.x: /etc/snmpd.extend
# hp 10.x: /etc/SnmpAgent.d/snmpd.extend
#
  hpux_get_extend_file
  check_fatal

  if [ "$hp_system" = hpux9 ];then
    hpux9_agentversion=`hpux_check_for_agentversion`
  else
    hpux9_agentversion=""
  fi

  hpux_setup_extend_file
  check_fatal
#
# Setup auto start on boot
#
    case $hp_system in

       hpux10)
	   hpux10_startatboot
	   ;;
       hpux9)
	   # nul
	   #hpux9_startatboot
	   ;;
    esac
# end-of system = hpux
fi

#
# Now ls3.sh takes care of starting ls3agent too.
#
#if [ "$system" = aix4 ]; then
#  aix_inittab_startatboot
#fi


if [ "$system" = sco ]; then
    sco5_setup_snmpd_peers
fi

if [ "$system" = uw2 ]; then
    uw2_setup_snmpd_peers
fi

if [ "$system" = solari ]; then
    solaris_setup_extend_file
fi


if [ "$system" = uw2 -o "$system" = sco -o "$system" = solari ]; then
    sysv_startatboot
fi


    #
    # Clean up
    #
    if [ -z "$skip_cleanup" ]; then
        rm -rf `compute_tapedirs`
	#rm -f install.sh
        rm -f agent.sh
    fi

    echo
    echo "---------------------------------------------------------------------------"
    echo "     LanSafe III SNMP Agent was successfully installed on your system.     "
    echo "---------------------------------------------------------------------------"




}

#
# Check command line parameters
# This code segment must be out of main() in order to work.
#
# If this script is called from install.sh:
#
# $1 has the value of tar device
# $2 has the value of instpath
#

if [ $# -gt 2 ]; then
   echo "Invalid number of command line parameters."
   exit 0
fi

if [ $# -eq 2 ]; then
   two_parameters=true
else
   two_parameters=""
fi


tardev="$1"
instpath="$2"

main $tardev $instpath






