
################################################################
## copyright 2006 Compaq Information Technologies Group, L.P. ##
################################################################

.PHONY: all clean install

# LINUX_KERN_DIR=$(shell uname -r)
LINUX_KERN_BASE=$(shell uname -r | sed -e 's/-default//g' -e 's/-smp//g' -e 's/-bigsmp//g')
OS_VERSION_UP=$(LINUX_KERN_BASE)-default
OS_VERSION_MP=$(LINUX_KERN_BASE)-smp
OS_VERSION_HM=$(LINUX_KERN_BASE)-bigsmp

PWD=`pwd`


LINUX_BUILD_UP = /usr/src/linux-obj/x86_64/default
LINUX_BUILD_MP = /usr/src/linux-obj/x86_64/smp
LINUX_BUILD_HM = /usr/src/linux-obj/x86_64/bigsmp

ifeq "$(EFS_VER)" ""
	EFS_VER=$(LINUX_KERN_BASE)
endif


# IPMI_DEVINTF_VERSION = $(EFS_VER)
# IPMI_KCS_VERSION = $(EFS_VER)
# IPMI_MSGHANDLER_VERSION = $(EFS_VER)
# IPMI_SI_VERSION = $(EFS_VER)


    
all:	init up smp hm

init:
	if [ ! -f /usr/src/linux/include/linux/ipmi.h.ORIG ]; then \
		mv /usr/src/linux/include/linux/ipmi.h /usr/src/linux/include/linux/ipmi.h.ORIG; \
	fi ;\
	if [ ! -f /usr/src/linux/include/linux/ipmi_msgdefs.h.ORIG ]; then \
		mv /usr/src/linux/include/linux/ipmi_msgdefs.h /usr/src/linux/include/linux/ipmi_msgdefs.h.ORIG; \
	fi ;\
	if [ ! -f /usr/src/linux/include/linux/ipmi_smi.h.ORIG ];  then \
		mv /usr/src/linux/include/linux/ipmi_smi.h /usr/src/linux/include/linux/ipmi_smi.h.ORIG; \
	fi ;\
	cp include/linux/ipmi.h /usr/src/linux/include/linux/ipmi.h ;\
	cp include/linux/ipmi_msgdefs.h /usr/src/linux/include/linux/ipmi_msgdefs.h ;\
	cp include/linux/ipmi_smi.h /usr/src/linux/include/linux/ipmi_smi.h ;



#
# Due to a quirk in the Linux 2.6 Kernel Environment, we need to clean up 
# some temporary (and hidden) files inbetween each build. NOTE:
# this is NOT a full clean and is not designed to be.
#
up:
	if [ -d $(LINUX_BUILD_UP) ]; then \
		mkdir -p $(PWD)/bin/$(OS_VERSION_UP) ;\
		rm -f drivers/char/ipmi/*.o ;\
		rm -f drivers/char/ipmi/*.ko ;\
		rm -f drivers/char/ipmi/*.mod.c ;\
		rm -f drivers/char/ipmi/.ipmi*.cmd ;\
		rm -rf drivers/char/ipmi/.tmp_versions ;\
		make -C $(LINUX_BUILD_UP) V=1 M=$(PWD)/drivers/char/ipmi modules ;\
		mv -f drivers/char/ipmi/ipmi_*.ko $(PWD)/bin/$(OS_VERSION_UP)/. ;\
	fi

smp:
	if [ -d $(LINUX_BUILD_MP) ]; then \
		mkdir -p $(PWD)/bin/$(OS_VERSION_MP)  ;\
		rm -f drivers/char/ipmi/*.o  ;\
		rm -f drivers/char/ipmi/*.ko  ;\
		rm -f drivers/char/ipmi/*.mod.c  ;\
		rm -f drivers/char/ipmi/.ipmi*.cmd  ;\
		rm -rf drivers/char/ipmi/.tmp_versions  ;\
		make -C $(LINUX_BUILD_MP) V=1 M=$(PWD)/drivers/char/ipmi modules  ;\
		mv -f drivers/char/ipmi/ipmi_*.ko $(PWD)/bin/$(OS_VERSION_MP)/.  ;\
	fi

hm:
	if [ -d $(LINUX_BUILD_HM) ]; then \
		mkdir -p $(PWD)/bin/$(OS_VERSION_HM) ;\
		rm -f drivers/char/ipmi/*.o ;\
		rm -f drivers/char/ipmi/*.ko ;\
		rm -f drivers/char/ipmi/*.mod.c ;\
		rm -f drivers/char/ipmi/.ipmi*.cmd ;\
		rm -rf drivers/char/ipmi/.tmp_versions ;\
		make -C $(LINUX_BUILD_HM) V=1 M=$(PWD)/drivers/char/ipmi modules ;\
		mv -f drivers/char/ipmi/ipmi_*.ko $(PWD)/bin/$(OS_VERSION_HM)/. ;\
	fi

clean:
	rm -f drivers/char/ipmi/*.o
	rm -f drivers/char/ipmi/*.ko
	rm -f drivers/char/ipmi/*.ko-??
	rm -f drivers/char/ipmi/*.mod.c
	rm -f drivers/char/ipmi/.*.cmd
	rm -rf drivers/char/ipmi/.tmp_versions
	if [ $(PWD) != "/" ] ; then \
		rm -rf $(PWD)/bin ;\
	fi

	if [ -f /usr/src/linux/include/linux/ipmi.h.ORIG ]; then \
		rm /usr/src/linux/include/linux/ipmi.h ;\
		mv /usr/src/linux/include/linux/ipmi.h.ORIG /usr/src/linux/include/linux/ipmi.h ;\
	fi ;\
	if [ -f /usr/src/linux/include/linux/ipmi_msgdefs.h.ORIG ]; then \
		rm /usr/src/linux/include/linux/ipmi_msgdefs.h ;\
		mv /usr/src/linux/include/linux/ipmi_msgdefs.h.ORIG /usr/src/linux/include/linux/ipmi_msgdefs.h ;\
	fi ;\
	if [ -f /usr/src/linux/include/linux/ipmi_smi.h.ORIG ];  then \
		rm /usr/src/linux/include/linux/ipmi_smi.h ;\
		mv /usr/src/linux/include/linux/ipmi_smi.h.ORIG /usr/src/linux/include/linux/ipmi_smi.h ;\
	fi ;\

install:
ifneq "$(RPM_BUILD_ROOT)" ""
	sh make_install $(RPM_MAKE_ROOT) $(RPM_BUILD_ROOT)
endif


