<?php

	session_start();
	
	require_once("../Util/Constant.php");
	
	require_once("../Util/String.php");
	require_once("../Util/Unit.php");
	require_once("../Hardware/DiskDrive.php");
	require_once("../Control/Control.php");
	require_once("../Control/ClientWindow.php");
	require_once("../Control/DropDownList.php");
	require_once("../Control/Link.php");
	require_once("../Control/CheckBox.php");
	require_once("../Xml/RecommendSolutionXml.php");
	require_once( CONST_DIR_DATA_PROTECTION()."/Compound/MasterPage.php");
?>

<?php

	function CONST_OVERVIEW_CONTROL() { return "ID_REC_OVERVIEW"; }
	function CONST_ASSUMPTIONS_CONTROL() { return "ID_REC_ASSUMPTIONS"; }
	function CONST_REQUIREMENTS_CONTROL() { return "REQUIREMENTS_CONTROL"; }
	function CONST_RECOMMENDATIONS_CONTROL() { return "RECOMMENDATIONS_CONTROL"; }
		
	///////////////////////////////////////////////////////////////////////
	//
	//	Recommend Solution Page
	//
	class RecommendSolutionPage extends MasterPage
	{
		var $XmlRecommendSolution;
		
		function RecommendSolutionPage ($name, $parent)
		{
			parent::MasterPage($name, $parent);
		}
		
		function OnInit()
		{
			$xmlRecommendSolution = new RecommendSolutionXml();
			$xmlRecommendSolution->BuildFromXmlFile( CONST_XML_FILE_RECOMMEND_SOLUTION() );

			$this->XmlRecommendSolution = $xmlRecommendSolution;
			
			$requirements = new Requirements( CONST_REQUIREMENTS_CONTROL(), $this, $xmlRecommendSolution );
			$devRecommended = new Recommendations( CONST_RECOMMENDATIONS_CONTROL(), $this, $xmlRecommendSolution );
			
			$this->AddControl( $requirements );
			$this->AddControl( $devRecommended );
			
			parent::OnInit();
		}
		
		function OnSymbolTable()
		{
			parent::OnSymbolTable();
		}
		
		function OnRequest()
		{
			parent::OnRequest();
		}
			
		function OnProcess()
		{
			$userdata = 0;
			
			$cReq = & $this->FindControl( CONST_REQUIREMENTS_CONTROL() );
			$userdata = $cReq->TotalUserData;

			$sUserData = FormatNumber($userdata, 2)."B";
			
			if ( OSServerPlatform() == CONST_OS_LINUX() )
				$cmd = CONST_DIR_DATA_PROTECTION()."/RecommendSolution -userdata=".$sUserData." -output:machine ".CONST_XML_FILE_RECOMMEND_SOLUTION();
			else if ( OSServerPlatform() == CONST_OS_WINDOWS() )
				$cmd = CONST_DIR_DATA_PROTECTION()."/RecommendSolution.exe -userdata=".$sUserData." -output:machine ".CONST_XML_FILE_RECOMMEND_SOLUTION();
			
			//
			// Executable of Recommend Solution is being invoked
			//
			$output = array(); $return_var = 0;
			exec( $cmd, $output, $return_var );
			
			foreach ( $output as $o )
			{
				if ( StrExist( $o, "TAPE_TOTAL_BACKUP_SIZE:" ) == true )
					$totalTapeBackupSize = StrReplaceAll ( $o, "TAPE_TOTAL_BACKUP_SIZE:", "" );
				else if ( StrExist( $o, "AUTOLOADER_TOTAL_BACKUP_SIZE:" ) == true )
					$totalAutoloaderBackupSize = StrReplaceAll ( $o, "AUTOLOADER_TOTAL_BACKUP_SIZE:", "" );
				else if ( StrExist( $o, "DEVICES:" ) == true )
					$devices = StrReplaceAll ( $o, "DEVICES:", "" );
				else 
					print ( $o."<br/>" );
			}

			$annualGrowth = $this->XmlRecommendSolution->BackupDataAutoloader->AnnualGrowth;
			if ( is_float( $annualGrowth ) )
			{
				$annualGrowth = floatval( $annualGrowth ) * 100 /* To make it percentage */;
				$this->SymbolTable->Update( "\${Growth}", $annualGrowth );
			}
			
			$partial = $this->XmlRecommendSolution->BackupDataAutoloader->Partial;
			if ( is_float( $partial ) || is_int( $partial ) )
			{
				$partial = floatval( $partial );
				$this->SymbolTable->Update( "\${Partial}", $partial );
			}
			
			$cRec = & $this->FindControl( CONST_RECOMMENDATIONS_CONTROL() );
			$cRec->IsAutomation = $cReq->IsAutomation;
			$cRec->Devices = $devices;

			parent::OnProcess();
		}

		function OnPreRender()
		{
			//
			// Extract all elements of an array
			//
			
			$cOverview 			= & $this->FindControl( CONST_OVERVIEW_CONTROL() );
			$cRequirements 		= & $this->FindControl( CONST_REQUIREMENTS_CONTROL() );
			$cRecommendations 	= & $this->FindControl( CONST_RECOMMENDATIONS_CONTROL() );
			$cAssumptions 		= & $this->FindControl( CONST_ASSUMPTIONS_CONTROL() );
			
			//
			// Check and warning if any element is missing
			//
			
			if ( ! isset( $cOverview ) )
				print ( "Overview section missing<br/>" );
				
			if ( ! isset( $cRequirements) )
				print ( "Requirements section missing<br/>" );
				
			if ( ! isset( $cRecommendations ) )
				print ( "Recommendations section missing<br/>" );
				
			if ( ! isset( $cAssumptions ) )
				print ("Assumptions section missing<br/>");
				
			//
			// Re-organize array to display in desired order
			// by removing all controls and adding them in
			// order that is desirable to be displayed.
			//
			
			$this->RemoveAllControls();
			
			$this->AddControl( $cOverview );
			$this->AddControl( $cRequirements );
			$this->AddControl( $cRecommendations );
			$this->AddControl( $cAssumptions );
			
			parent::OnPreRender();
		}
		
		function OnRender()
		{
			parent::OnRender();
		}
	}
	
	///////////////////////////////////////////////////////////////////////
	//
	//	Requirements
	//
	class Requirements extends Control 
	{
		var $XmlRecommendSolution;
		
		var $arrLogicalDisk = array();
		
		var $chkDiskDrives = array();
		var $chkAutomation;
		var $txtUserData;
		
		var $TotalUserData = 0;
		var $IsAutomation = true;
		
		var $CalculateButton;
		var $RescanButton;
		
		function Requirements ( $name, $parent, & $xmlRecommendSolution )
		{
			parent::Control($name, $parent);
			$this->XmlRecommendSolution = $xmlRecommendSolution;
			$this->Text = "ID_REC_HEADING_DATASTORAGE";
		}
		
		function OnInit()
		{
			$EnumMode = new Mode();
			
			if ( ! $this->IsPostBack()  )
			{
				$this->arrLogicalDisk = & ScanDiskDrives();
				$_SESSION["SCANNED_DISKS"] = & $this->arrLogicalDisk;
			}
			else 
			{
				 $this->arrLogicalDisk = & $_SESSION["SCANNED_DISKS"];
			}
			
			foreach ( $this->arrLogicalDisk as $logicalDisk )
			{
				$checkBox = new CheckBox ( $logicalDisk->Name, $this );
				$checkBox->Text = $logicalDisk->Name." ".
					// "[ ".
					"ID_REC_LABEL_USED"." ".FormatNumber( $logicalDisk->UsedSize, 2 )."B".
					", ".
					"ID_REC_LABEL_MAX_CAPACITY"." ".FormatNumber( $logicalDisk->TotalSize, 2 )."B".
					// ", ".
					// "ID_REC_LABEL_REMAINING"." ".FormatNumber( $logicalDisk->FreeSize, 2 )."B".
					// " ]";
					"";
				$checkBox->Mode_ = $EnumMode->EDIT;
				$checkBox->IsChecked = true;
				
				array_push( $this->chkDiskDrives, $checkBox );
			}
						
			$this->txtUserData = new TextBox( "txtUserData", $this );
			$this->txtUserData->Text = "";
			$this->txtUserData->Width = 6;
			$this->txtUserData->Style = "text-align:center";
			$this->txtUserData->Mode_ = $EnumMode->EDIT;
			
			$this->chkAutomation = new CheckBox ( "Automation", $this );
			$this->chkAutomation->Text = "ID_REC_MESSAGE_INCLUDE_AUTOMATION";
			$this->chkAutomation->Mode_ = $EnumMode->EDIT;
			$this->chkAutomation->IsChecked = true;

			$this->CalculateButton = new Button( "CalculateButton", $this );
			$this->CalculateButton->Text = "ID_REC_LABEL_UPDATE_SOLUTION";
			
			$this->RescanButton = new Button( "RescanButton", $this );
			$this->RescanButton->Text = "ID_REC_LABEL_RESCAN_DEVICES";
			$this->RescanButton->ClickHandler = new RescanDevicesClickHandler ( $this );
			
			parent::OnInit();
		}
		
		function OnSymbolTable()
		{
			$this->Text 					= $this->SymbolTable->Evaluate( $this->Text );

			$len=count( $this->chkDiskDrives);
			for ( $i=0; $i<$len; $i++ )
			{
				$chk = & $this->chkDiskDrives[$i];
				$chk->Text = $this->SymbolTable->Evaluate( $chk->Text );
			}
			
			$this->chkAutomation->Text 		= $this->SymbolTable->Evaluate( $this->chkAutomation->Text );
			$this->CalculateButton->Text 	= $this->SymbolTable->Evaluate( $this->CalculateButton->Text );
			$this->RescanButton->Text 		= $this->SymbolTable->Evaluate( $this->RescanButton->Text );
			
			parent::OnSymbolTable();
		}
		
		function OnRequest()
		{
			//
			// Process Http Request
			//
			
			$this->txtUserData->OnRequest();
			$this->chkAutomation->OnRequest();
			
			$iLen= count ( $this->chkDiskDrives );
			for ( $i=0; $i<$iLen; $i++ )
			{
				$this->chkDiskDrives[$i]->OnRequest();
			}
			
			$this->IsAutomation = $this->chkAutomation->IsChecked;
			
			//
			// Calculate Total User Data
			//
			
			$this->TotalUserData = 0;

			$sDataAdditional = $this->txtUserData->Text;
			$sDataAdditional = trim ( $sDataAdditional );
			if ( is_numeric( $sDataAdditional ) )
			{
				$dataAdditional = floatval( $sDataAdditional );
				$dataAdditional = $dataAdditional * GigaByte();
				$this->TotalUserData += $dataAdditional;
			}
			
			$iLen= count ( $this->chkDiskDrives );
			for ( $i=0; $i<$iLen; $i++ )
			{
				$chkDiskDrv = $this->chkDiskDrives[$i];
				
				if ( $chkDiskDrv->IsChecked == false )
					continue;
				
				$jLen = count ( $this->arrLogicalDisk );
				for ( $j=0; $j < $jLen; $j++ )
				{
					$disk = $this->arrLogicalDisk[$j];
					$diskName = trim ( $disk->Name );
					$diskId = trim ( $chkDiskDrv->Name );
					
					if ( $diskName == $diskId )
					{
						if (  is_numeric( $disk->UsedSize ) )
						{
							$this->TotalUserData += floatval( $disk->UsedSize );
						}
					}
				}
			}

			$this->RescanButton->OnRequest();
			
			parent::OnRequest();
		}
			
		function OnProcess()
		{
			$len = count ( $this->chkDiskDrives );
			for ( $i=0; $i<$len; $i++ )
			{
				$chkDiskDrv = $this->chkDiskDrives[$i];
				if ( $chkDiskDrv->IsChecked == true )
				{
					$name = $chkDiskDrv->Name;
				}
			}
			
			$name = $this->txtUserData->Text;

			parent::OnProcess();
		}

		function OnRender()
		{
			parent::OnRender();
			
			print ( "<a name='$this->Name'>");
			print ( "<b>".$this->Text."</b>");
			
			?>
				<br/>
				<table border="0" cellpadding="5px">
					<tr>
						<td>
							<?php
								
								foreach ( $this->chkDiskDrives as $chkDiskDrv )
								{
									$chkDiskDrv->OnRender();
									print ( "<br/>" );
								}
							?>
						</td>
						<td>
						</td>
					</tr>
					<tr>
						<td>
							<?php
								$this->txtUserData->Display();
								print ( " ".$this->SymbolTable->Evaluate("ID_REC_LABEL_ENTER_ADDITIONAL_DATA") );
							?>
						</td>
						<td>
						</td>
					</tr>
					<tr>
						<td>
							<?php
								$userdatasize = $this->TotalUserData;
								if ( !isset( $userdatasize ) || $userdatasize == "" )
									$userdatasize = "0";
								print ( "<b>".FormatNumber( $userdatasize, 2)."B ".$this->SymbolTable->Evaluate("ID_REC_LABEL_TOTAL_USER_DATA")."</b>" );
							?>
						</td>
						<td>
						</td>
					</tr>	
					<tr>
						<td>
							<?php
								$this->chkAutomation->Display();
							?>
						</td>
						<td>
						</td>
					</tr>	
					<tr>
						<td>
							<?php
								$this->CalculateButton->Display();
								print ( " " );
								$this->RescanButton->Display();
							?>
						</td>
						<td>
						</td>
					</tr>	
				</table>
			<?php
		}				
	}
	
	class RescanDevicesClickHandler extends ClickHandler
	{
		var $control;
		
		function RescanDevicesClickHandler ( & $control )
		{
			$this->control = & $control;
		}
		
		function Execute()
		{
			$arrLogicalDisk = & ScanDiskDrives();
			$_SESSION["SCANNED_DISKS"] = & $arrLogicalDisk;
		}
	}
	
	///////////////////////////////////////////////////////////////////////	
	//
	//	Recommended Device
	//
	class Recommendations extends Control 
	{
		var $XmlRecommendSolution;
		var $Devices;
		var $IsAutomation = true;
		var $IsTape = true;
		
		function Recommendations ( $name, & $parent, & $xmlRecommendSolution )
		{
			parent::Control($name, $parent);
			$this->XmlRecommendSolution = $xmlRecommendSolution;			
			$this->Text = "ID_REC_HEADING_RECOMMENDATIONS";
			$this->VerifySolution = "ID_REC_MESSAGE_VERIFY_SOLUTION";
		}
		
		function OnSymbolTable()
		{
			$this->Text = $this->SymbolTable->Evaluate ( $this->Text );
			
			parent::OnSymbolTable();
		}
		
		function OnRequest()
		{
			parent::OnRequest();
		}
			
		function OnProcess()
		{
			parent::OnProcess();
		}

		function OnRender()
		{
			$_devLst = explode ( " ", $this->Devices );
			$deviceList = array();
			foreach ( $_devLst as $deviceId )
			{
				if ( trim( $deviceId )!="" )
					array_add( $deviceList, $deviceId );
			}
			
			parent::OnRender();
			
			print ( "<a name='$this->Name'>");
			print ( "<b>".$this->Text."</b>");
			print ( "<br/>" );
			
			$this->RenderDevices( $deviceList );
			print ( "<br/>" );
		}	
		
		function RenderDevices( & $deviceList )
		{
			?>
				<table border="0" cellpadding="5px">
						<?php 	
						foreach ( $deviceList as $deviceId )
						{ 
						?> 
								<tr>
									<td colspan="2"></td>
								</tr>
						<?php
							
							$device = $this->XmlRecommendSolution->FindDevice ( $deviceId );
							if ( isset( $device ) )
							{
								if ( $device->Status != "Shipping" )
									continue;
								
								if ( $this->IsTape == false && ( $device->Storage_->TapeRW || $device->Storage_->TapeWorm ) )
									continue;
										
								if ( $this->IsAutomation == false && ( $device->Storage_->AutoRW || $device->Storage_->AutoWorm ) )
									continue;
								
								$this->SymbolTable->Update ("\${RECOMMENDED_DRIVE}", $device->Label);									
						?>
								<tr>
									<td colspan="2">
											<div style='background:#eeeeee;border:solid 1 gray; padding:5px; width:100%'>
											<table width="100%">
												<tr>
													<td width="80%">
														<?php print ( "<b>".$device->Label."</b>" ); ?>
													</td>
													<td align="right">
														<?php
															print ( "<a href=javascript:NewWindow('".$device->QuickSpec_->URL."')><font color=black>".$this->SymbolTable->Evaluate("ID_REC_LABEL_QUICKSPEC")."</font></a>");
															print ( "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" );
															print ( "<a href=javascript:NewWindow('".$device->Compatibility_->URL."')><font color=black>".$this->SymbolTable->Evaluate("ID_REC_LABEL_COMPATIBILITY")."</font></a>");
														?>
													</td>
												</tr>
											</table>
											</div>
									</td>
								</tr>
								<tr>
									<td valign="top">
										<?php
										
											$devNativeCapacity = $device->Capacity_->NativeValue;
											$devNativeUnit =  $device->Capacity_->NativeUnit;
											$devCompressionRatioTypical = $device->Capacity_->CompressionRatioTypical;
											$devCompressionRatioPublished = $device->Capacity_->CompressionRatioPublished;
											
											logline( "Native Capacity = $devNativeCapacity, Compression Ratio Typical = $devCompressionRatioTypical, Published = $devCompressionRatioPublished<br/>");
											
											$devNativeCapacity = floatval( $devNativeCapacity );
											$devNativeUnit = $devNativeUnit; // No change. Only for consistency.
											$devCompressionRatioTypical = floatval( $devCompressionRatioTypical );
											$devCompressionRatioPublished = floatval( $devCompressionRatioPublished );
											
											logline ( "Native Capacity = $devNativeCapacity, Compression Ratio Typical = $devCompressionRatioTypical, Published = $devCompressionRatioPublished<br/> ");
											
											$devCapacityCompressionTypical = $devNativeCapacity * $devCompressionRatioTypical;
											$devCapacityCompressionPublished = $devNativeCapacity * $devCompressionRatioPublished;
											
											// print ( "The $device->Label has been selected for your specific data protection needs. " ); 
											$txtRecommended = $this->SymbolTable->Evaluate ( "ID_REC_MESSAGE_SELECTED_DRIVE" );
											print ( $txtRecommended );
											logline ( "The $device->Label stores ".$devCapacityCompressionPublished.$devNativeUnit." of data at compression ".$devCompressionRatioPublished.":1.<br/>" );
											print ( "<br/>" );
											print ( "<br/>" );
											
											logline ( "Capacity: ".$device->Capacity_->NativeValue.$device->Capacity_->NativeUnit."<br/>" );

											$ioList = $device->IOList;
											foreach ( $device->IOList as $io )
											{
												print ( "<b>".$this->SymbolTable->Evaluate("ID_REC_LABEL_CAPACITY").":</b> ".$devCapacityCompressionPublished." ".$devNativeUnit." [".$devCompressionRatioPublished.":1 ".$this->SymbolTable->Evaluate("ID_REC_LABEL_COMPRESSION_RATIO")."]"."<br/>" );
												// print ( $this->SymbolTable->Evaluate("ID_REC_LABEL_NATIVE").":</b> ".$devNativeCapacity." ".$devNativeUnit."<br/>" );
												print ( "<b>".$this->SymbolTable->Evaluate("ID_REC_LABEL_PERFORMANCE").":</b> ".$io->Throughput." ".FormatUnit($io->Unit)." [".$devCompressionRatioPublished.":1 ".$this->SymbolTable->Evaluate("ID_REC_LABEL_COMPRESSION_RATIO")."]"."<br/>" );
												print ( "<b>".$this->SymbolTable->Evaluate("ID_REC_LABEL_INTERFACE").":</b> ".$io->Label."<br/>" );
												print ( "<b>".$this->SymbolTable->Evaluate("ID_REC_LABEL_FORMFACTOR").":</b> " );
												// Print form factors with a comma
												$len = count ( $io->FormFactorList );
												for ( $i=0; $i<$len; $i++ )
												{
													$formFactor = $io->FormFactorList[$i];
													print ( $formFactor->Type );
													if ( $i < $len - 1 )
														print ( ", " );
												}

												print ( "<br/>" );
												print ( "<br/>" );
											}
											
											if ( $device->Storage_->TapeWorm == true || $device->Storage_->AutoWorm == true )
											{
												print ( $this->SymbolTable->Evaluate("ID_REC_LABEL_WORM") );
												print ( "<br/>" );
											}
											
										?>
									</td>
									<td valign="top" align="right">
										<img src='<?php print ( CONST_URL_IMAGE()."/".$device->Image->Url); ?>' width=200 style='border:solid 1px gray;background:white'></img>
										<br/>
										<?php
										
											$dropDownList = new DropDownList( "PurchaseList".$deviceId /* append device Id to create a unique name for each drop down list */, $this );
											$dropDownList->Add( $this->SymbolTable->Evaluate("ID_REC_LABEL_PURCHASE_TAPEDRIVE_MEDIA"), "");
											$dropDownList->Add( "-----------------------------", "");
											$dropDownList->Add( $this->SymbolTable->Evaluate("ID_REC_LABEL_PURCHASE_USA"), $this->SymbolTable->Evaluate("ID_REC_URL_PURCHASE_USA") );
											$dropDownList->Add( $this->SymbolTable->Evaluate("ID_REC_LABEL_PURCHASE_OTHER_COUNTRIES"), $this->SymbolTable->Evaluate("ID_REC_URL_PURCHASE_OTHER_COUNTRIES") );
											$dropDownList->OnRender();
										?>
									</td>
								</tr>
								<tr>
									<td style="color:darkred;font:bold 9pt">
										<?php
											print ( $this->SymbolTable->Evaluate ( "ID_REC_MESSAGE_VERIFY_SOLUTION" ) );
										?>
									</td>
								</tr>
						<?php 
							} 
						}
						?>
				</table>
			<?php
				
				if ( count ( $deviceList ) <= 0 )
				{
					print ( "<br/>".$this->SymbolTable->Evaluate("ID_REC_LABEL_NO_SOLUTION_FOUND")."<br/>");
				}
			?>
				<br/>
				<div align='right'><a href="#Top">Top</a>
				</div>
			<?php
		}	
	}
	
	class DiskInfo
	{
		var $Name;
		var $TotalSize;
		var $FreeSize;
		var $UsedSize;
	}
	
?>

<?php

	require_once("../Util/Constant.php");
	require_once( CONST_DIR_DATA_PROTECTION()."/Compound/MasterPage.php");
	
	$Page = new RecommendSolutionPage("RECOMMEND_SOLUTION", null);
	$Page->BuildFromXmlFile();
 	$Page->Display();

?>