<?php

	class Fruit 
	{
		var $Name;
		var $SeedCount=0;
		
		function Fruit ( $name )
		{
			$this->Name = $name;
		}
		
		function Print_ ()
		{
			print ( "\t\tFruit ".$this->Name.", Seed Count ".$this->SeedCount."\n" );	
		}
	}
	
	$f1 = new Fruit("lemon");
	$f1->SeedCount = 10;

	//-----------------------------------------------------------------------------
	
	print ( "Test : Assignment without reference ...\n");	
	$f2 = $f1;
	$f2->SeedCount = 20;
	$f1->Print_();
	$f2->Print_();
	print ( "\tResult : Different values for seed count show up\n" );
	PrintSeparator ();
	
	//-----------------------------------------------------------------------------
	
	print ( "Test : Assignment by reference ...\n");	
	$f2 = & $f1;
	$f2->SeedCount = 20;
	$f1->Print_();
	$f2->Print_();
	print ( "\tResult : Same values for seed count show up\n" );
	PrintSeparator ();
	 
	//-----------------------------------------------------------------------------
	
	print ( "Test : Passing to function without reference ...\n");	
	IncrementSeeds( $f1);
	$f1->Print_();
	print ( "\tResult : Different values for seed count show up\n" );
	PrintSeparator ();
	
	//-----------------------------------------------------------------------------
	
	print ( "Test : Passing to function with reference ...\n");	
	IncrementSeeds( & $f1);
	$f1->Print_();
	print ( "\tResult : Same values for seed count show up\n" );
	print ( "\tNote : Putting & as formal or actual parameter, works both ways\n" );
	PrintSeparator ();
	
	//-----------------------------------------------------------------------------
	
	print ( "Test : Pointer assignment i.e. $ f2 = & $ f1 ...\n");	

	$arrFruit = array();

	$f1 = new Fruit("Orange");
	$f2 = new Fruit("Melon"); 
	$f3 = new Fruit("Apple");
	
	$f1->Print_();
	$f2->Print_();
	$f3->Print_();
	print ( "\tResult : BIG WARNING - f2 points towards f1 i.e. $ f2 = & $ f1, from previous test. Above f1 is now Melon f2.\n" );
	PrintSeparator ();
	
	//-----------------------------------------------------------------------------
	
	print ( "Test : array_push( $ arrFruit, $ item ) - adding item with or without reference \n");	
	
	$f1 = new Fruit("Orange");
	$f3 = new Fruit("Apple");

	print ( "\tarray_push ( $ arrFruit, $ f1 ) - without reference, copy will be made \n" );
	print ( "\tarray_push ( $ arrFruit, & $ f3 ) - with reference, copy will be made \n" );
	array_push( & $arrFruit, & $f1 );
	array_push( & $arrFruit, $f3 );
	
	$f1->SeedCount++;
	$f3->SeedCount++;
	
	foreach ( $arrFruit as $fruit )
	{
		$fruit->Print_();
	}

	print ( "\tResult : Notice that f1 ( Orange )'s seeds are incremented but not f3 ( Apple )'s seeds.\n" );
	print ( "\tReason : f1 was passed by refence but not f3.\n" );
	
	PrintSeparator ();
	
	//-----------------------------------------------------------------------------
	
	print ( "Test : foreach does copy ( bad implementation ). Work around is to use for ( $ i; $ i < $ len; i ++ ) \n");	
	
	print ( "Part 1 : Use foreach and increment Seed Count of each fruit and then print array in separater foreach\n");
	
	print ( "\tInitializing seed count to 0 for all fruits... \n" );
	for ( $i=0; $i<count($arrFruit); $i++ )
	{
		// BIG PROBLEM : Using & would cause 1st element to always be assigned to item at index $ i in array
		// $fruit = & $arrFruit[$i]; 
		// $fruit->SeedCount = 0;
		
		// WORKS, but little complex because fruit has to be assigned back ( see line 3 )
		// $fruit = $arrFruit[$i];
		// $fruit->SeedCount = 0;
		// $arrFruit[$i] = $fruit; // OBSERVE : Reassigning, because in $fruit = $arrFruit[$i];
		
		// BEST APPROACH 
		$arrFruit[$i]->SeedCount = 0;
	}
	
	print ( "\tBefore incrementing... \n" );
	foreach ( $arrFruit as $fruit )
	{
		$fruit->Print_();
	}
	print ( "\tNow  incrementing... \n" );
	foreach ( $arrFruit as $fruit )
	{
		$fruit->SeedCount++;
		print ( "\t\t".$fruit->Name." incremented\n" );
	}
	print ( "\tAfter incrementing... \n" );
	foreach ( $arrFruit as $fruit )
	{
		$fruit->Print_();
	}
	print ( "\tResult : No increment in seed count occured. Same as before, because foreach made copies before incrementing.\n");
	
	//-----------------------------------------------------------------------------

	print ( "Part 2 : Use for ( ... )and increment Seed Count of each fruit and then print array in separater foreach\n");
	
	print ( "\tInitializing seed count to 0 for all fruits... \n" );
	for ( $i=0; $i<count($arrFruit); $i++ )
	{
		// BIG PROBLEM : Using & would cause 1st element to always be assigned to item at index $ i in array
		// $fruit = & $arrFruit[$i]; 
		// $fruit->SeedCount = 0;
		
		// WORKS, but little complex because fruit has to be assigned back ( see line 3 ). However,
		// any reference to original object is now lost because a copy was made of original approach ( VERY BAD )
		// $fruit = $arrFruit[$i];
		// $fruit->SeedCount = 0;
		// $arrFruit[$i] = $fruit; // OBSERVE : Reassigning, because in $fruit = $arrFruit[$i];
		
		// BEST APPROACH 
		$arrFruit[$i]->SeedCount = 0;
	}
	
	print ( "\tBefore incrementing... \n" );
	for ( $i=0; $i<count($arrFruit); $i++ )
	{
		$arrFruit[$i]->Print_();
	}
	print ( "\tNow  incrementing... \n" );
	for ( $i=0; $i<count($arrFruit); $i++ )
	{
		$arrFruit[$i]->SeedCount++;
		print ( "\t\t".$arrFruit[$i]->Name." incremented\n" );
	}

	print ( "\tAfter incrementing... \n" );
	for ( $i=0; $i<count($arrFruit); $i++ )
	{
		$arrFruit[$i]->Print_();
	}
	print ( "\tResult : Increment in seed count occured. Because for (...) did not made any scopies before and during incrementing.\n");
	
	//-----------------------------------------------------------------------------

	function IncrementSeeds ( $fruit )
	{
		$fruit->SeedCount++;
		$fruit->Print_();
	}

	function PrintSeparator ()
	{
		print ( "-----------------------------------------\n");
	}
?>