<?php 

 	// Session start not only starts a new session, if needed
 	// but also 'enables' session on this page. If not called
 	// on this page, even though session is established, but
 	// this page will not see any session information that is
 	// stored in form of variables. - Imran Salim
	session_start();
	
	require_once( "../Util/Constant.php");
	require_once( CONST_DIR_DATA_PROTECTION()."/Control/Control.php");

	// Used to build cgi-ftp script
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Guid.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Platform.php");
			
	
?>

<?php

	class UpdateContent extends Control
	{
		function UpdateContent($name, $parent)
		{
			parent::Control($name, $parent);
		}
		
		//////////////////////////////////////////////////
		//
		// 		On Request - This is where 'Request' is
		//			processed. Here syncronization of
		//			controls should take place from Request
		//			to variables.
		//
		function OnRequest()
		{
			parent::OnRequest();
		}
		
		function OnRequestNormal()
		{
		}

		function OnRequestSelect()
		{
		}

		function OnRequestEdit()
		{
		}

		//////////////////////////////////////////////////
		//
		// 		On Process - This is where drawing
		//		and displaying logic should reside
		//
		function OnProcess()
		{
			parent::OnProcess();
		}

		function OnProcessNormal()
		{
		}

		function OnProcessSelect()
		{
		}

		function OnProcessEdit()
		{
		}
			
		//////////////////////////////////////////////////
		//
		// 		On Response - This is where 'Response' is
		//			processed. Here syncronization of
		//			controls should take place from variables
		//			to Response.
		//
		function OnRender()
		{
			parent::OnRender();
		}
			
		function OnRenderNormal()
		{
			 $isFtpChecked = $_SESSION[ CONST_IS_FTP_CHECKED_FOR_XML() ];
			 
			 if ( CONST_DEBUG()==true )
				 print ( "Is ftp checked before = ".$isFtpChecked."<br/>" );
			 
			 if ( ! isset( $isFtpChecked ) )
			 {
			 	if ( CONST_DEBUG()==true )
			 		print ( "Downloading xml file<br/>");

			 	$this->DownloadXmlAsync( CONST_FTP_HP_URL(), CONST_FTP_HP_USERNAME(), CONST_FTP_HP_PASSWORD(), CONST_XML_URL_DATA_PROTECTION(), CONST_XML_FILE_TMP_DATA_PROTECTION() );
				$this->DownloadXmlAsync( CONST_FTP_HP_URL(), CONST_FTP_HP_USERNAME(), CONST_FTP_HP_PASSWORD(), CONST_XSD_URL_DATA_PROTECTION(), CONST_XSD_FILE_TMP_DATA_PROTECTION() );
				
				$this->DownloadXmlAsync( CONST_FTP_HP_URL(), CONST_FTP_HP_USERNAME(), CONST_FTP_HP_PASSWORD(), CONST_XML_URL_RECOMMEND_SOLUTION(), CONST_XML_FILE_TMP_RECOMMEND_SOLUTION() );
				$this->DownloadXmlAsync( CONST_FTP_HP_URL(), CONST_FTP_HP_USERNAME(), CONST_FTP_HP_PASSWORD(), CONST_XSD_URL_RECOMMEND_SOLUTION(), CONST_XSD_FILE_TMP_RECOMMEND_SOLUTION() );
				
				$_SESSION[ CONST_IS_FTP_CHECKED_FOR_XML() ] = true;
			 }
			
			 // NOTE : Don't place the code below in if (..) statement above.
			 // Reason : The code under if (..) statement i.e. DownloadXml is asynchronus - uses frames to achieve asynch behavior.
			 // If code below [ UpdatexmlDataProtectionFile ] is placed under if (..) block, the UpdateDataProtectionFile(..) will 
			 // only be called once, during which file may or may not be downloaded, because it is asynchronus call. - Imran Salim
			 $this->UpdateXmlDataProtectionFile();
			 $this->UpdateXmlRecommendSolutionFile();
		}
			
		function OnRenderSelect()
		{
		}
			
		function OnRenderEdit()
		{
		}
		
		function DownloadXmlAsync ( $url, $username, $password, $remotePath, $localPath )
		{
			//
			// PART I of II - Build Ftp Script
			//
			$ftpScriptName = $this->BuildFTPScript( $url, $username, $password, $remotePath, $localPath );
			
			//
			// PART II of II - Use Frame to call cgi script to start download
			//
			
			if ( OSClientPlatform()==CONST_OS_WINDOWS() )
			{
				$cgiFtp = "CgiFTP.exe";
			}
			else if ( OSClientPlatform()==CONST_OS_LINUX() )
			{
				$cgiFtp = "CgiFTP";
			}
			else 
			{
				print ( __FILE__." ".__LINE__." - Unknown Operating System.<br/>");
				exit(-1);
			}

			?>

				<iframe id="downloadFrame_<?php $this->mangle();?>" height="0" width="0" frameborder=no scrolling=no src="/cgi-bin/<?php print ( $cgiFtp ); ?>?SectionInfo=<?php print ( $ftpScriptName ); ?>" >

						<!-- OS command is issed using this iframe -->

						<!-- Why Frame is used : It is also possible that PHP code is placed here that calls OS ftp command,
							 and not called from frame (as in this case) that will initiate download process, but problem
							 is that the approach without frame cause browser to keep waiting for 'end response' signal, 
							 eventhough the browser has been redirected to a different location using javascript on
							 this page. Using a frame and asking frame to go to a different location and then redirecting
							 this window prevents browser from waiting for 'end response' signal.
							 
							 Commented By : Imran Salim
						-->

					</iframe>
			
			<?php
			
			sleep(1);
		}
		
		//
		// Copy recommend solution ( xsd and xml ) from temp to permanent
		//
		function UpdateXmlRecommendSolutionFile()
		{
			if ( file_exists( CONST_XML_FILE_TMP_RECOMMEND_SOLUTION() ) && filesize( CONST_XML_FILE_TMP_RECOMMEND_SOLUTION() ) > 0 && $this->IsNewerXmlFile(CONST_XML_FILE_RECOMMEND_SOLUTION(), CONST_XML_FILE_TMP_RECOMMEND_SOLUTION())==true  )
				copy ( CONST_XML_FILE_TMP_RECOMMEND_SOLUTION(), CONST_XML_FILE_RECOMMEND_SOLUTION() );
			
			if ( file_exists( CONST_XML_FILE_TMP_RECOMMEND_SOLUTION() )	&& filesize ( CONST_XML_FILE_TMP_RECOMMEND_SOLUTION() ) > 0 && $this->IsNewerXmlFile(CONST_XSD_FILE_RECOMMEND_SOLUTION(), CONST_XSD_FILE_TMP_RECOMMEND_SOLUTION())==true )
				copy ( CONST_XSD_FILE_TMP_RECOMMEND_SOLUTION(), CONST_XSD_FILE_RECOMMEND_SOLUTION() );
		}
		
		 //
		 // Check Ftp for latest version of xml, if not already checked,
		 // download the file, and check code version against version of file.
		 // If compatible, replace old xml file with new one. - Imran Salim
		 //
		function UpdateXmlDataProtectionFile()
		{
			if ( file_exists( CONST_XML_FILE_TMP_DATA_PROTECTION() )==false ||  filesize( CONST_XML_FILE_TMP_DATA_PROTECTION() ) <= 0 )
				return;
				
			if ( CONST_DEBUG()==true )				
				print ( "Checking Content Updates ....<br/> ");
				
			if (  $this->IsCodeCompatible( CONST_XML_FILE_TMP_DATA_PROTECTION()) == true && $this->IsNewerXmlFile( CONST_XML_FILE_DATA_PROTECTION(), CONST_XML_FILE_TMP_DATA_PROTECTION())==true)
			{
				copy ( CONST_XML_FILE_TMP_DATA_PROTECTION(), CONST_XML_FILE_DATA_PROTECTION() );
				copy ( CONST_XSD_FILE_TMP_DATA_PROTECTION(), CONST_XSD_FILE_DATA_PROTECTION() );
				
				if ( CONST_DEBUG()==true )
					print ( "Updated Contents from Hewlett Packard.");
			}
			else 
			{
				if ( CONST_DEBUG()==true )
					print ( "No contents updated. Using existing ones." );
			}
		}

		function IsNewerXmlFile ( $xmlExistingFile, $xmlDownloadedFile )
		{
			if ( file_exists( $xmlExistingFile )==false || filesize( $xmlExistingFile)<=0 )
				return;
				
			if ( file_exists( $xmlDownloadedFile )==false || filesize( $xmlDownloadedFile)<=0 )
				return;
				
			// Existing File
			$domE = domxml_open_file( $xmlExistingFile  );
			$xmlnodeRootE = $domE->document_element();
			
			$xmlVersionE_ = $xmlnodeRootE->get_attribute("XMLVersion");
			$xmlVersionE = floatval( $xmlVersionE_ );
			
			// Downloaded File 
			$dom = domxml_open_file( $xmlDownloadedFile  );
			$xmlnodeRoot = $dom->document_element();
			
			$xmlVersion_ = $xmlnodeRoot->get_attribute("XMLVersion");
			$xmlVersion = floatval( $xmlVersion_ );
			
			//
			// Check if newer version of xml file is downloaded
			//
			if ( $xmlVersionE < $xmlVersion )
				return true;
			else 
				return false;
		}
		
		function IsCodeCompatible ( $xmlDownloadedFile )
		{
			if ( file_exists( $xmlDownloadedFile ) == false || filesize( $xmlDownloadedFile) <= 0 )
				return false;
			
			// Downloaded File 
			$dom = domxml_open_file( $xmlDownloadedFile  );
			$xmlnodeRoot = $dom->document_element();
			
			//
			// Check code compatbility against xml
			//
			
			$xmlVersion_ = $xmlnodeRoot->get_attribute("XMLVersion");
			$codeStart_ = $xmlnodeRoot->get_attribute("CodeStart");
			$codeEnd_ = $xmlnodeRoot->get_attribute("CodeEnd");
			
			$codeStart = intval( $codeStart_ );
			$codeEnd = intval( $codeEnd_ );
			$xmlVersion = intval( $xmlVersion_ );
			
			// print ( "<br/>" );
			// print ( "Code Start = ".$codeStart_."<br/>") ;
			// print ( "Code End = ".$codeEnd_."<br/>") ;
			// print ( "Code Start = ".$codeStart."<br/>") ;
			// print ( "Code End = ".$codeEnd."<br/>") ;
			// print ( "Code Version = ".CONST_CODE_VERSION()."<br/>") ;
			
			if ( $codeStart <= CONST_CODE_VERSION() && CONST_CODE_VERSION() <= $codeEnd )
				return true;
			else 
				return false;
		}
		

		//--------------------------------------------------------------------
		//
		//				Region : Helper Methods 
		//
		//--------------------------------------------------------------------
		
		function BuildFTPScript( $url, $username, $password, $remotePath, $localPath )
		{
			// print ( "URL = ".$url."<br/>" );
			// print ( "Username = ".$username."<br/>" );
			// print ( "Local Path = ".$localPath."<br/>");

			if ( OSClientPlatform()==CONST_OS_WINDOWS() )
				return $this->BuildFTPScriptWindows( $url, $username, $password, $remotePath, $localPath );
			else if ( OSClientPlatform()==CONST_OS_LINUX() )
				return $this->BuildFTPScriptLinux( $url, $username, $password, $remotePath, $localPath );
			return 
				"UnableToBuildScript";
		}
		
		function BuildFTPScriptWindows( $url, $username, $password, $remotePath, $localPath )
		{
			// Create script for downloading
			$fname = NewGuid().".ftp"; // Security Measure - a unqiue filename for every download request
			$file = fopen( CONST_DIR_SERVER_DOWNLOAD()."/".$fname, "wb" );
			fwrite( $file, "open ".$url."\r\n" );
			fwrite( $file, $username."\r\n" );
			fwrite( $file, $password."\r\n" );
			fwrite( $file, "binary"."\r\n");
			// fwrite( $file, "cd ".$fileInfo->remoteFilePath."\r\n" );
			// The line below (get method) has two parts - 1. Remote filename and 2. Local filename along with local path
			fwrite( $file, "get \"".$remotePath."\" \"".$localPath."\"\r\n" );
			fwrite( $file, "quit"."\r\n" );
			fclose( $file );
			
			// return file name
			return $fname;
		}
	
		function BuildFTPScriptLinux( $url, $username, $password, $remotePath, $localPath )
		{
			// Create script for downloading
			$fname = NewGuid().".ftp"; // Security Measure - a unqiue filename for every download request
			$file = fopen( CONST_DIR_SERVER_DOWNLOAD()."/".$fname, "wb" );
			fwrite( $file, "open ".$url."\n" );
			fwrite( $file, "user ".$username." ".$password."\n" );
			fwrite( $file, "binary"."\n");
			// fwrite( $file, "cd ".$fileInfo->remoteFilePath."\n" );
			// The line below (get method) has two parts - 1. Remote filename and 2. Local filename along with local path
			fwrite( $file, "get \"".$remotePath."\" \"".$localPath."\"\n" );
			fwrite( $file, "bye"."\n" );
			fclose( $file );
			
			// return file name
			return $fname;
		}
	}
	
?>