<?php
	
	require_once("../Util/Constant.php");
	require_once("../Util/Array.php");
	require_once("../Util/Log.php");
	
	session_start();

	class RecommendSolutionXml
	{
		var $BackupDataTape;
		var $BackupDataAutoloader;
		var $DeviceList = array();
		
		function RecommendSolutionXml()
		{
		}
		
		function FindDevice ( $id )
		{
			foreach ( $this->DeviceList as $device )
			{
				if ( $device->Type == $id )
					return $device;
			}
		}
		
		function BuildFromXmlFile ( $filepath )
		{
			$dom = domxml_open_file ( $filepath );
			if ( ! $dom )
				print ( __FILE." ".__LINE__.", Error occured during parsing<br/>" );
			
			$xmlnodeRoot = $dom->document_element();
			
			//
			// Root
			//
			$xmlnodeVersion = $xmlnodeRoot->get_attribute("Version");
			$xmlnodeReleaseDate = $xmlnodeRoot->get_attribute("ReleaseDate");
			
			//
			// Backup Data
			//
			$xmlnodeBackupDataList = $xmlnodeRoot->get_elements_by_tagname("BackupData");
			if ( $xmlnodeBackupDataList != null && count ( $xmlnodeBackupDataList ) > 0 )
			{
				$xmlnodeBackupData = $xmlnodeBackupDataList[0];
				
				$xmlnodeTapeBackupList = $xmlnodeBackupData->get_elements_by_tagname("Tape");
				if ( $xmlnodeTapeBackupList != null && count ( $xmlnodeTapeBackupList ) > 0 )
				{
					$xmlnodeTapeBackup = $xmlnodeTapeBackupList[0];
					
					$backupData = new BackupData();
					$backupData->BuildFromXmlNode( $xmlnodeTapeBackup );

					$this->BackupDataTape = $backupData;
				}
					
				$xmlnodeAutoloaderList = $xmlnodeBackupData->get_elements_by_tagname("Autoloader");
				if ( $xmlnodeAutoloaderList != null && count ( $xmlnodeAutoloaderList ) > 0 )
				{
					$xmlnodeAutoloader = $xmlnodeAutoloaderList[0];
					
					$backupData = new BackupData();
					$backupData->BuildFromXmlNode( $xmlnodeAutoloader );
					
					$this->BackupDataAutoloader = $backupData;
				}
			}
			
			logline ( "<hr/>" );
			
			//
			// Tape Products
			//
			$xmlnodeTapeProductList = $xmlnodeRoot->get_elements_by_tagname("TapeProducts");
			if ( $xmlnodeTapeProductList != null && count ( $xmlnodeTapeProductList ) > 0 )
			{
				$xmlnodeTapeProducts = $xmlnodeTapeProductList[0];
				
				//
				// Device 
				//
				$xmlnodeDeviceList = $xmlnodeTapeProducts->get_elements_by_tagname("Device");
				foreach ( $xmlnodeDeviceList as $xmlnodeDevice )
				{
					$device = new Device();
					$device->BuildFromXmlNode( $xmlnodeDevice );
					$this->AddDevice( $device );
				}
			}
		}
		
		function AddDevice ( $device )
		{
			array_add ( $this->DeviceList, $device );
		}
	}

	class BackupData 
	{
		var $ID;
		var $Full;
		var $Partial;
		var $PartialPercent;
		var $AnnualGrowth;
		var $Join;
		
		function BackupData()
		{
		}
		
		function BuildFromXmlNode ( $xmlNodeBackupData )
		{
			$this->ID = $xmlNodeBackupData->get_attribute("ID");
			$this->Full = intval( $xmlNodeBackupData->get_attribute("Full") );
			$this->Partial = intval( $xmlNodeBackupData->get_attribute("Partial") );
			$this->PartialPercent = floatval( $xmlNodeBackupData->get_attribute("PartialPercent") );
			$this->AnnualGrowth = floatval( $xmlNodeBackupData->get_attribute("AnnualGrowth") );
			$this->Join = intval( $xmlNodeBackupData->get_attribute("Join") );
			
			$this->Full = intval( $this->Full );
			$this->Partial = intval( $this->Partial );
			$this->PartialPercent = floatval( $this->PartialPercent );
			$this->AnnualGrowth = floatval( $this->AnnualGrowth );
			$this->Join = intval( $this->Join );

			logline ( "Id = $this->ID, Full = $this->Full, Partial = $this->Partial, Partial Percent = $this->PartialPercent, Annual Growth = $this->AnnualGrowth, Join = $this->Join" );
		}
	}
	
	class Device
	{
		var $Type;
		var $Label;
		var $Height;
		var $Status;
		var $MarketingWeight;
		var $Image;
		var $Capacity_;
		var $IOList = array();
		var $QuickSpec_;
		var $Compatibility_;
		var $Storage_;
		
		function BuildFromXmlNode ( $xmlnodeDevice )
		{
			//
			//	Type and Label
			//
			$type = $xmlnodeDevice->get_attribute("Type");
			$label = $xmlnodeDevice->get_attribute("Label");
			$status = $xmlnodeDevice->get_attribute("Status");
			$height = $xmlnodeDevice->get_attribute("Height");
			$marketingWeight = $xmlnodeDevice->get_attribute("MktWeight");
			
			logline ( "Type = ".$type.", Label = ".$label );
			
			$this->Type = $type;
			$this->Label = $label;
			$this->Status = $status;
			$this->Height = $height;
			$this->MarketingWeight = $marketingWeight;
			
			//
			//	Image
			//
			$xmlnodeImageList = $xmlnodeDevice->get_elements_by_tagname("Image");
			if ( $xmlnodeImageList != null && count ( $xmlnodeImageList ) > 0 )
			{
				$xmlnodeImage = $xmlnodeImageList[0];
				$fileImage = $xmlnodeImage->get_attribute("FileName");
				
				logline ( $fileImage );
				
				$image = new ImageInfo();
				$image->Url = $fileImage;
				
				$this->Image = $image;
			}
			
			//
			// Capacity
			//
			$xmlnodeCapacityList = $xmlnodeDevice->get_elements_by_tagname("Capacity");
			if ( $xmlnodeCapacityList != null && count ( $xmlnodeCapacityList ) > 0 )
			{
				$xmlnodeCapacity = $xmlnodeCapacityList[0];
				
				$xmlnodeCapacityNativeList = $xmlnodeCapacity->get_elements_by_tagname("Native");
				if ( $xmlnodeCapacityNativeList != null && count ( $xmlnodeCapacityNativeList ) > 0 )
				{
					$xmlnodeCapacityNative = $xmlnodeCapacityNativeList[0];
					$capacityNativeValue = $xmlnodeCapacityNative->get_attribute("Value");
					$capacityNativeUnit = $xmlnodeCapacityNative->get_attribute("Unit");

					logline ( "Value = ".$capacityNativeValue." Unit = ".$capacityNativeUnit );
				}
				
				$xmlnodeCompressionList = $xmlnodeCapacity->get_elements_by_tagname("Compression");
				if ( $xmlnodeCompressionList != null && count ( $xmlnodeCompressionList ) > 0 )
				{
					$xmlnodeCompression = $xmlnodeCompressionList[0];
					$publishedRatio = $xmlnodeCompression->get_attribute("PublishedRatio");
					$typicalRatio = $xmlnodeCompression->get_attribute("TypicalRatio");
					
					logline ( "Published Ratio = ".$publishedRatio.", Typical Ratio = ".$typicalRatio );
				}
				
				$xmlnodeLimitsList = $xmlnodeCapacity->get_elements_by_tagname("Limits");
				if ( $xmlnodeLimitsList != null && count ( $xmlnodeLimitsList ) > 0 )
				{
					$xmlnodeLimit = $xmlnodeLimitsList[0];
					$upper = $xmlnodeLimit->get_attribute("Upper");
					$lower = $xmlnodeLimit->get_attribute("Lower");
					
					logline ( "Limits : Upper = ".$upper.", Lower = ".$lower );
				}
				
				$capacity = new Capacity();
				
				$capacity->NativeValue = $capacityNativeValue;
				$capacity->NativeUnit = $capacityNativeUnit;
				$capacity->CompressionRatioPublished = $publishedRatio;
				$capacity->CompressionRatioTypical = $typicalRatio;
				$capacity->LimitsLower = $lower;
				$capacity->LimitsUpper = $upper;
				
				$this->Capacity_ = $capacity;
			}

			//
			//	IO
			//
			$xmlnodeIOList = $xmlnodeDevice->get_elements_by_tagname("IO");
			if ( $xmlnodeIOList != null && count ( $xmlnodeIOList ) > 0 )
			{
				$xmlnodeIO = $xmlnodeIOList[0];
				$xmlnodeIOTypeList = $xmlnodeIO->get_elements_by_tagname("Type");
				foreach ( $xmlnodeIOTypeList as $xmlnodeIOType )
				{
					$io = new IO();
					$io->BuildFromXmlNode( $xmlnodeIOType );
					$this->AddIO( $io );
				}
			}
			
			//
			//	QuickSpec
			//
			$xmlnodeQuickSpecList = $xmlnodeDevice->get_elements_by_tagname("QuickSpec");
			if ( $xmlnodeQuickSpecList != null && count ( $xmlnodeQuickSpecList ) > 0 )
			{
				$xmlnodeQuickSpec = $xmlnodeQuickSpecList[0];
				$quickSpec = $xmlnodeQuickSpec->get_attribute ( "URL" );
				
				logline ( "QuickSpec = ".$quickSpec );
				
				$qs = new QuickSpec($quickSpec);
				$this->QuickSpec_ = $qs;
			}
			
			//
			//	Compatibility
			//
			$xmlnodeCompatibilityList = $xmlnodeDevice->get_elements_by_tagname("Compatibility");
			if ( $xmlnodeCompatibilityList != null && count ( $xmlnodeCompatibilityList ) > 0 )
			{
				$xmlnodeCompatibility = $xmlnodeCompatibilityList[0];
				$compatibility = $xmlnodeCompatibility->get_attribute("URL");
				
				logline ( "Compatibility = ".$compatibility );
				
				$cmp = new Compatibility($compatibility);
				$this->Compatibility_ = $cmp;
			}
			
			//
			//	Storage
			//
			$xmlnodeStorageList = $xmlnodeDevice->get_elements_by_tagname("Storage");
			if ( $xmlnodeStorageList != null && count ( $xmlnodeStorageList ) > 0 )
			{
				$xmlnodeStorage = $xmlnodeStorageList[0];
				$tapeRw 	= $xmlnodeStorage->get_attribute("Tape_RW");
				$tapeWorm 	= $xmlnodeStorage->get_attribute("Tape_Worm");
				$autoRw 	= $xmlnodeStorage->get_attribute("Auto_RW");
				$autoWorm 	= $xmlnodeStorage->get_attribute("Auto_Worm");						
				
				$tapeRw 	= $tapeRw 	== "true" ? true : false;
				$tapeWorm 	= $tapeWorm == "true" ? true : false;
				$autoRw 	= $autoRw 	== "true" ? true : false;
				$autoWorm 	= $autoWorm == "true" ? true : false;
				
				logline ( "Tape RW = $tapeRw, Tape Worm = $tapeWorm, Auto RW = $autoRw, Auto Worm = $autoWorm" );
				
				$storage = new Storage( $tapeRw, $tapeWorm, $autoRw, $autoWorm );
				$this->Storage_ = $storage;
			}
			
			log_("<hr/>");
		}
		
		function AddIO ( $io )
		{
			array_add( $this->IOList, $io );
		}
	}
	
	class ImageInfo
	{
		var $Url;
	}
	
	class Capacity
	{
		var $NativeValue;
		var $NativeUnit;
		var $CompressionRatioPublished;
		var $CompressionRatioTypical;
		var $LimitsUpper;
		var $LimitsLower;
	}
	
	class IO
	{
		var $Type;
		var $Throughput;
		var $Unit;
		var $Label;
		var $FormFactorList = array();
		
		function BuildFromXmlNode ( $xmlnodeIOType )
		{
			$type = $xmlnodeIOType->get_attribute("Type");
			$throughput = $xmlnodeIOType->get_attribute("Throughput");
			$unit = $xmlnodeIOType->get_attribute("Unit");
			$label = $xmlnodeIOType->get_attribute("Label");
			
			logline ( "Type = ".$type.", Throughput = ".$throughput.", Unit = ".$unit.", Label = ".$label );
			
			$this->Type = $type;
			$this->Throughput = $throughput;
			$this->Unit = $unit;
			$this->Label = $label;
			
			$xmlnodeFormFactorList = $xmlnodeIOType->get_elements_by_tagname("FormFactor");
			foreach ( $xmlnodeFormFactorList as $xmlnodeFormFactor )
			{
				$formFactor = new FormFactor();
				$formFactor->BuildFromXmlNode( $xmlnodeFormFactor );
				$this->AddFormFactor( $formFactor );
			}
		}
		
		function AddFormFactor ( $formFactor )
		{
			array_add( $this->FormFactorList, $formFactor );
		}
	}
	
	class FormFactor
	{
		var $Type;
		
		function FormFactor ()
		{
		}
		
		function BuildFromXmlNode ( $xmlnodeFormFactor )
		{
			$formFactorType = $xmlnodeFormFactor->get_attribute("Type");
			log_ ( $formFactorType." " );
			
			$this->Type = $formFactorType;
		}
	}
	
	class QuickSpec
	{
		var $URL;
		
		function QuickSpec ( $url )
		{
			$this->URL = $url;
		}
	}
	
	class Compatibility
	{
		var $URL;
		
		function Compatibility ( $url )
		{
			$this->URL = $url;
		}
	}
	
	class Storage
	{
		var $TapeRW;
		var $TapeWorm;
		var $AutoRW;
		var $AutoWorm;
		
		function Storage ( $tapeRW, $tapeWorm, $autoRW, $autoWorm )
		{
			$this->TapeRW = $tapeRW;
			$this->TapeWorm = $tapeWorm;
			$this->AutoRW = $autoRW;
			$this->AutoWorm = $autoWorm;
		}
	}

?>

<?php

	// $rcXml = new RecommendSolutionXml();
	// $rcXml->BuildFromXmlFile( CONST_XML_FILE_RECOMMEND_SOLUTION() );
	
?>