<?php
	
	////////////////////////////////////////////////////////////////////////
	//
	//	INTRODUCTION
	//	This file holds download info for each section, from master xml 
	//	file that is main source of information. Currenty, as of 3/22/2005
	//	the file name is dataprotection.xml (filenames may change later on).
	//  ** Reliable Information ** The information in this class, read from
	//	xml file is always reliable and fresh. This is considered primary
	//	source of information for other modules such as 
	//	SoftwareDeployment.php (filename as of 3/22/2005). Other modules
	//	may hold same information for cache or record keeping purposes,
	//	but other modules are supposed to check *this* file on periodic
	//	basis for upto data information.
	//
	//	STRUCTURE
	//	This class holds a collection of Download Info, whose key is
	//	section id and value is download info. Download info holds a
	//	mapping of file info to os.
	//
	// 	Commeted By : Imran Salim
	//	

	require_once("../Util/Constant.php");
	
	session_start();

	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Log.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Util.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Array.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/String.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Platform.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Hardware/Networking.php");

?>
<!-- ----------------------------------------------------------------------
 --------------------------------------------------------------------------
 ---------------------------------------------------------------------- -->
<?php
	
	//
	// Builds InfoSectionFtp and InfoFtp from Xml file and returns $ftpInfo
	// for specified section id and correct operating system.
	//
	// Returns $ftpInfo object that contains following useful fields
	// 		$ftpInfo->url;
	// 		$ftpInfo->username;
	// 		$ftpInfo->password;
	// 		$ftpInfo->remoteFilePath;
	// 		$ftpInfo->remoteFileName;
	// 		$ftpInfo->ExistInternetConnection;
	// 		$ftpInfo->ExistRemoteFile;
	//
	function FtpInfoMANAGER( $sectionId, $updateRemoteFileInfo=false )
	{
		$MgrDownloadInfo = new InfoSectionFtp();
		$MgrDownloadInfo->BuildFromXmlFile( CONST_XML_FILE_DATA_PROTECTION() );

		$downloadInfo = & $MgrDownloadInfo->ArrayDownloadInfo[$sectionId];
		if ( ! isset( $downloadInfo ) || $downloadInfo == null )
		{
			print ( "Error : Could not find ftp info for Section=".$sectionId."<br/>" );
			return null;
		}

		// The object installInfo is not currently used.
		$installInfo = $MgrDownloadInfo->ArrayInstallInfo[$sectionId];
		if ( isset( $installInfo ) && $installInfo != null )
		{
			$installCommand = $installInfo->OSInstallCommandList[ OSClientPlatform() ];
		}

		$ftpInfo = & $downloadInfo->GetFileInfo( OSClientPlatform() );
		if ( ! isset( $ftpInfo ) || $ftpInfo == null )
		{
			print ( "Error : Could not find ftp info for OS=".OSClientPlatform()."<br/>" );
			return null;
		}
		
		//
		// This statement determines internet connection and existance of remote
		// file without going to remote ftp site. Hence it is more efficient.
		//
		// NOTE : This statement should be above $ftpInfo->UpdateRemoteFileInfo();
		//
		$ftpInfo->UpdateInfo();
		
		//
		// Expesnive in time, because it reaches for ftp site. Not performed for every read,
		// 	but only when optional parameter $updateRemoteFileInfo is true. The purpose
		//  of updating remote file info is to fetech it's size, that can be retrieved using
		//  RemoteSizeMax() method on $ftpInfo.
		//
		// NOTE : This statement should be below $ftpInfo->UpdateInfo();
		//
		if ( $updateRemoteFileInfo == true )
		{
			$ftpInfo->UpdateRemoteFileInfo();
			// $ftpInfo->RemoteSizeMax(); - only available if UpdateRemoteFileInfo() is called
		}
		
		//-------------------------------------------------------------------------
		//
		//	Return value
		//
		//-------------------------------------------------------------------------
		
		return $ftpInfo;
	}

?>
<!-- ----------------------------------------------------------------------
 --------------------------------------------------------------------------
 ---------------------------------------------------------------------- -->
<?php

	////////////////////////////////////////////////////////////////////////
	//
	//	This file holds FTP+OS Info, mapped to SectionId, that is built
	//	using xml file, currently named as dataprotection.xml as of 3/22/2005
	//
	//	Commend By : Imran Salim
	//

	class InfoSectionFtp
	{
		var $ArrayDownloadInfo = array();
		var $ArrayInstallInfo = array();
		
		function InfoSectionFtp()
		{
		}
		
		function BuildFromXmlFile ( $filepath )
		{
			$dom = domxml_open_file( $filepath );
			$xmlnodeRoot = $dom->document_element();
			
			//
			// 		Root
			//
			logline( "Root=".$xmlnodeRoot );
		
			$xmlnodeLastUpdate 	= $xmlnodeRoot->get_attribute("LastUpdate");
			$xmlnodeCodeStart  	= $xmlnodeRoot->get_attribute("CodeStart");
			$xmlnodeCodeEnd 	= $xmlnodeRoot->get_attribute("CodeEnd");
			
			//
			//		Page
			//
			$xmlnodePageList = $xmlnodeRoot->get_elements_by_tagname("Page");
			foreach ( $xmlnodePageList as $xmlnodePage )
			{
				$pagetitle = $xmlnodePage->get_attribute("Title");
				$subtitle = $xmlnodePage->get_attribute("SubTitle");
		
				//
				//		Section
				//
				$xmlnodeSectionList = $xmlnodePage->get_elements_by_tagname("Section");
				foreach ( $xmlnodeSectionList as $xmlnodeSection )
				{
					$xmlnodeSection = $xmlnodeSection;
					$id = $xmlnodeSection->get_attribute("ID");				
		
					//
					//		Download
					//
					$xmlnodeDownloadList = $xmlnodeSection->get_elements_by_tagname("Download");	
					if ( $xmlnodeDownloadList != null && count ( $xmlnodeDownloadList ) > 0 )
					{
						$xmlnodeDownload = $xmlnodeDownloadList[0];
						
						$infoftpos = new InfoFtpOS( $id );
						$infoftpos->BuildFromXmlNode ( $xmlnodeDownload );
						
						$this->ArrayDownloadInfo[ $id ] = $infoftpos;
					}
					
					//
					//		Install
					//
					$xmlnodeInstallList = $xmlnodeSection->get_elements_by_tagname("Install");
					if ( $xmlnodeInstallList != null && count ( $xmlnodeInstallList ) > 0 )
					{
						$xmlnodeInstall = $xmlnodeInstallList[0];
						
						$infoInstall = new InstallInfo( $id );
						$infoInstall->BuildFromXmlNode ( $xmlnodeInstall );
						
						$this->ArrayInstallInfo[ $id ] = $infoInstall;
					}
				}
			}
		}
	}
	
?>
<!-- ----------------------------------------------------------------------
 --------------------------------------------------------------------------
 ---------------------------------------------------------------------- -->
<?php
	
	
	////////////////////////////////////////////////////////////////////////
	//
	//	This file holds FTP File Info, mapped to an operating system,
	//  that is built using xml file, currently named as dataprotection.xml 
	//	as of 3/22/2005
	//
	//	Commend By : Imran Salim
	//
	
	class InfoFtpOS
	{
		var $sectionId;			 
		var $arrFileInfoAndOS = array();
		
		function InfoFtpOS ($sectionId)
		{
			$this->sectionId = $sectionId;
		}
		
		function BuildFromXmlNode ( $xmlnodeDownload )
		{
			//
			// File
			//
			$xmlnodeFileList = $xmlnodeDownload->get_elements_by_tagname("File");
			foreach ( $xmlnodeFileList as $xmlnodeFile )
			{
				$url = $xmlnodeFile->get_attribute("Url");
				
				$loginname = $xmlnodeFile->get_attribute("Username");
				$loginpassword = $xmlnodeFile->get_attribute("Password");
				
				$remotepath = $xmlnodeFile->get_attribute("Path");
				$remotefilename = $xmlnodeFile->get_attribute("Name");

				// X $localfilepath = $_SERVER['DOCUMENT_ROOT']."/dataprotection/server/";
				// X $localfilename = $remotefilename; // local file name remains unchanged i.e. same as remote file name
								
				//
				// Operating Systems (supported)
				//
				$xmlnodeOSList = $xmlnodeFile->get_elements_by_tagname("OS");
				foreach ( $xmlnodeOSList as $xmlnodeOS )
				{
					$os = $xmlnodeOS->get_content();
					// print ( "- - OS=$os<br/>" );

					// X $fileInfo = new InfoFTP( $url, $loginname, $loginpassword, $remotepath, $remotefilename, $localfilepath, $localfilename );
					$fileInfo = new InfoFTP( $url, $loginname, $loginpassword, $remotepath, $remotefilename );
					$this->arrFileInfoAndOS[ $os ] = $fileInfo;
				}
			}
		}
		 
		function AddOSAndFileInfo ( $os, $fileInfo )
		{
			$this->arrFileInfoandOS[ $os ] = $fileInfo;
		}
		 
		// X function Add ( $os, $url, $loginname, $loginpassword, $remotepath, $remotefilename, $localfilepath, $localfilenam )
		// X {
		// X 	$fileInfo = new InfoFTP( $url, $loginname, $loginpassword, $remotepath, $remotefilename, $localfilepath, $localfilename );
		// X 	$this->arrFileInfoandOS[ $os ] = $fileInfo;
		// X }
		
		function Add ( $os, $url, $loginname, $loginpassword, $remotepath, $remotefilename )
		{
			$fileInfo = new InfoFTP( $url, $loginname, $loginpassword, $remotepath, $remotefilename );
		 	$this->arrFileInfoandOS[ $os ] = $fileInfo;
		}
		 
		function GetFileInfo ( $os )
		{
			return $this->arrFileInfoAndOS[ $os ];
		}
		
		function Print_ ()
		{
			print ( "SECTION ID = ".$this->sectionId."<br/>" );
			foreach ( $this->arrFileInfoAndOS as $fileInfo )
			{
				print ( $fileInfo->url.", Remote File=".$fileInfo->RemotePathFull()."<br/>" );
			}
		}
	}

?>
<!-- ----------------------------------------------------------------------
 --------------------------------------------------------------------------
 ---------------------------------------------------------------------- -->
<?php

	////////////////////////////////////////////////////////////////////////
	//
	//	This file holds FTP File Info that is built using xml file, 
	//	currently named as dataprotection.xml as of 3/22/2005
	//
	//	Commend By : Imran Salim
	//

	class InfoFtp
	{
		var $username;
		var $password;
		
		var $url;
		var $remoteFilePath;
		var $remoteFileName;
		
		// X var $localFilePath;
		// X var $localFileName;
		
		// These data members are used for download process		
		var $ftp;
		var $remoteSizeMax;
		
		// Info about internet connection, remote file and local file
		var $ExistInternetConnection = false;
		var $ExistRemoteFile = false;
		// X var $ExistLocalFile = false;
		
		//
		// Constructor
		//
		// X function InfoFtp( $url, $username, $password, $remoteFilePath, $remoteFileName, $localFilePath, $localFileName )
		function InfoFtp( $url, $username, $password, $remoteFilePath, $remoteFileName )
		{
			$this->url = $url;
			
			$this->username = $username;
			$this->password = $password;
			
			$this->remoteFilePath = $remoteFilePath;
			$this->remoteFileName = $remoteFileName;
			
			// X $this->localFilePath = $localFilePath;
			// X $this->localFileName = $localFileName;
			
			// X $this->Print_();
		}

		function RemotePathFull ()
		{
			return $this->url."/".$this->remoteFilePath."/".$this->remoteFileName;
		}
		
		// X function LocalPathFull ()
		// X {
		// X	return $this->localFilePath."/".$this->localFileName;
		// X }
		
		// X
		// X Returns local size
		// X
		// X function LocalSizeCurrent()
		// X {
		// X 	// Hack : Bug Fix : If size of same file is continuously
		// X 	// extracted, the consecutive requests does not report
		// X 	// any new changes. A workaround is to extract size of
		// X 	// a different file, on each consecutive request. Hence,
		// X 	// in line below, the size of currently executing script
		// X 	// is extracted and then size of currently downloading 
		// X 	// file. This helps updating the new size of currently
		// X 	// downloading file. - Imran Salim
		// X 	filesize( __FILE__ /* name of this script */ );
		// X 	if ( file_exists( $this->LocalPathFull() )==true )
		// X 	{
		// X 		return filesize($this->LocalPathFull() );
		// X 	}
		// X 	else 
		// X 	{
		// X 		return 0;
		// X 	}
		// X }
		// X 
		
		//
		// Returns remote size
		//
		function RemoteSizeMax ()
		{
			return $this->remoteSizeMax;
		}

		// X
		// X Update Info - This method can be quite expensive in terms of time,
		// X	and resources because it fetch info about local as well as remote
		// X	file. 
		// X
		// X function UpdateStateInfo ()
		// X {
		// X 	$this->UpdateRemoteFileInfo();
		// X 	// X $this->UpdateLocalFileInfo();
		// X }
		// X 

		// X
		// X Update Local File Info
		// X
		// X function UpdateLocalFileInfo()
		// X {
		// X 	$this->ExistLocalFile = file_exists( $this->LocalPathFull() );
		// X }
		// X 

		//
		// Initialize Control
		//
		function UpdateInfo()
		{
			if ( $this->remoteFileName == null || ! isset( $this->remoteFileName ) || strcmp ( trim( $this->remoteFileName ), "" ) == 0 )
				$this->ExistRemoteFile = false;
			else
				$this->ExistRemoteFile = true;
				
			// Preliminary checking is for network connection only.
			// It may be possible that network connection exist
			// but internet may be unreachable. The checking
			// for internet being reachable is performed when
			// person clicks on download ( Windows only ). In Linux
			// 'Download' button is just a link to ftp.hp.com
			// and no checking for internet connection is done.
			$this->ExistInternetConnection = ExistNetworkConnection();
		}
		

		//
		// Remote File Info
		//
		function UpdateRemoteFileInfo()
		{
			$this->GetRemoteFileInfo();
			$this->Close();
		}
		
		//
		// Initialize Control
		//
		function GetRemoteFileInfo()
		{
			// no error reporting
			$prevErrorReportingLevel = error_reporting(0); 

			$this->ftp = ftp_connect($this->url);
			
			// set previous level of error reporting
			error_reporting( $prevErrorReportingLevel );
			
			if ( $this->ftp == null || $this->ftp == false )
			{
				if ( $debug )
					print ("Unable to connect\n<br/>");
				$this->ExistInternetConnection = false;					
				return;
			}
			else 
			{
				$this->ExistInternetConnection = true;
			}

			// no error reporting
			$prevErrorReportingLevel = error_reporting(0); 

			$login_status = ftp_login( $this->ftp, $this->username, $this->password);

			// set previous level of error reporting
			error_reporting( $prevErrorReportingLevel );

			if ( $login_status == null || $login_status == false )
			{
				if ( $debug )
					print ("Unable to login\n<br/>");
				return;
			}

			$this->remoteSizeMax = ftp_size( $this->ftp, $this->remoteFilePath."/".$this->remoteFileName );
			if ( $this->remoteSizeMax > 0 )
				$this->ExistRemoteFile = true;
			else 
				$this->ExistRemoteFile = false;
	
			// X $this->ExistLocalFile = file_exists( $this->LocalPathFull() );
		}

		//
		// Close file info
		//
		function Close()
		{
			if ( $this->ftp != null && $this->ftp != false )			
				ftp_close( $this->ftp );
			$this->ftp = null;
		}
		
		function Print_ ()
		{
			// X print ( "Url=".$this->url.", Remote File=".$this->RemotePathFull().", Local File=".$this->LocalPathFull()."<br/>");
			print ( "Url=".$this->url.", Remote File=".$this->RemotePathFull()."<br/>" );
		}
	}

	////////////////////////////////////////////////////////////////////////	
	//
	//	Unit Test of InfoFtp
	//
	function UTestInfoFtp()
	{
		$fileInfo = new InfoFtp( "ftp.hp.com", "anonymous", "imran@bm.com", "/pub/softlib/software3/COL5358/co-18262-2/hp_ltt_install_support.exe", "FTPControl.php" );
		// $fileInfo = new InfoFtp("ftp.linux.ee", "anonymous", "guest", "/pub/gentoo/distfiles/releases/x86/2004.3/packagecd/packages-x86-2004.3-r1.iso", "hp_ltt_install_support.exe" );
		// $fileInfo = new InfoFtp( "ftp.hp.com", "anonymous", "imran@bm.com", "/pub/softlib/software3/COL5358/co-18262-2/hp_ltt_install_support.exe", "hp_ltt_install_support.exe" );
		
		$fileInfo->UpdateRemoteFileInfo();
		
		// X print ( "Local File Path= ".$fileInfo->localFilePath." <br/>" );
		print ( "Total Size (Remote) = ".$fileInfo->RemoteSizeMax()." B"."<br/>" );
		// X print ( "Size Current (Local) = ".$fileInfo->LocalSizeCurrent()."<br/>" );
	}
	// UTestInfoFtp();

?>

<!-- ----------------------------------------------------------------------
 --------------------------------------------------------------------------
 ---------------------------------------------------------------------- -->
<?php

	class InstallInfo
	{
		var $SectionId;
		var $OSInstallCommandList = array();
				
		function InstallInfo ( $sectionId )
		{
			$this->SectionId = $sectionId;
		}
		
		function BuildFromXmlNode ( $xmlnodeInstall )
		{
			$xmlnodeCommandList = $xmlnodeInstall->get_elements_by_tagname("Commands");
			foreach ( $xmlnodeCommandList as $xmlnodeCommand )			
			{
				$installCmd = new InstallCommandInfo();
				$installCmd->BuildFromXmlNode( $xmlnodeCommand );
				$os = $installCmd->OS;

				$this->OSInstallCommandList[ $os ] = $installCmd;
			}
		}
	}
	
	class InstallCommandInfo
	{
		var $UnZip;
		var $UnTar;
		var $RpmInstall;
		var $DirExtract;
		var $SetupFile;
		var $OS;

		function InstallCommandInfo ()
		{
		}
		
		function BuildFromXmlNode ( $xmlnodeCommand )
		{
			$this->UnZip 		= $xmlnodeCommand->get_attribute("UnZip");
			$this->UnTar 		= $xmlnodeCommand->get_attribute("UnTar");
			$this->RpmInstall 	= $xmlnodeCommand->get_attribute("RpmInstall");
			$this->DirExtract	= $xmlnodeCommand->get_attribute("DirExtract");
			$this->SetupFile	= $xmlnodeCommand->get_attribute("SetupFile");
			$this->OS 			= $xmlnodeCommand->get_attribute("OS");
		}
	}
	
?>






<!-- ----------------------------------------------------------------------
 --------------------------------------------------------------------------
 ---------------------------------------------------------------------- -->




<?php

	////////////////////////////////////////////////////////////////////////	
	//
	//		Unit Test of SectionInfoFtp
	//
	function UTestInfoSectionFtp()
	{
		$MgrDownloadInfo = new InfoSectionFtp();
		$MgrDownloadInfo->BuildFromXmlFile( CONST_XML_FILE_DATA_PROTECTION() );
		
		print ("<hr/>");
		
		foreach ( $MgrDownloadInfo->ArrayDownloadInfo as $downloadInfo )
		{
			$downloadInfo->Print_();
		}
		
		print ("- - - - - - - - - - - - - - - - - - <br/>");
		
		$downloadInfo = $MgrDownloadInfo->ArrayDownloadInfo["LTT_LOCAL_REQUEST"];
		$fileInfo = $downloadInfo->GetFileInfo( "WinXP" );
		$fileInfo->UpdateStateInfo();
		// X print ( "File Info Local".$fileInfo->LocalPathFull()." " );
		// X print ( "Remote Path ".$fileInfo->LocalPathFull()."<br/>" );
		
		print ("- - - - - - - - - - - - - - - - - - <br/>");
	}
	// UTestInfoSectionFtp();
	
?>