<?php

	function KiloByte ()
	{
		return ( 1024 );
	}
	
	function MegaByte ()
	{
		return ( 1024 * 1024 );
	}
	
	function GigaByte ()
	{
		return ( 1024 * 1024 * 1024 );
	}
	
	function PetaByte ()
	{
		return ( 1024 * 1024 * 1024 * 1024 );
	}

	function ExaByte ()
	{
		return ( 1024 * 1024 * 1024 * 1024 * 1024 );
	}
	
	function FormatNumber ( $number, $precision=2 /* Two decimals */ )
	{
		$suffix = "";
		
		$arrSuffix = array();
		// array_push( $arrSuffix, "" );
		array_push( $arrSuffix, "K" );
		array_push( $arrSuffix, "M" );
		array_push( $arrSuffix, "G" );
		array_push( $arrSuffix, "T" );
		array_push( $arrSuffix, "P" );
		array_push( $arrSuffix, "E" );
		
		$len = count ( $arrSuffix );
		
		$number = trim ( $number );
		if ( ! isset( $number ) || $number == "" )
			$number = 0;
			
		for ( $i=0; $i<$len; $i++ )
		{
			if ( $number > 1024 )
			{
				$number = $number / 1024;
				$suffix = $arrSuffix[$i];
			}
			else 
			{
				break;
			}
		}

		$number = round( $number, $precision );
		return $number.$suffix;
	}
	
	function FormatUnit ( $unit )
	{
		switch ( $unit )
		{
			case "KBS" : return "KB/s";
			case "MBS" : return "MB/s";
			case "GBS" : return "GB/s";
			case "TBS" : return "TB/s";

			case "KBM" : return "KB/m";
			case "MBM" : return "MB/m";
			case "GBM" : return "GB/m";
			case "TBM" : return "TB/m";

			case "KBH" : return "KB/h";
			case "MBH" : return "MB/h";
			case "GBH" : return "GB/h";
			case "TBH" : return "TB/h";
			
			default: 	 return $unit;
		}
	}
	
	// print ( FormatNumber( 1000 )."\n" );
	// print ( FormatNumber( 1500 )."\n" );
	// print ( FormatNumber( 2000000 )."\n" );
	// print ( FormatNumber( 2000000000 )."\n" );

?>