<?php

	//
	// Holds name-value pairs. The name-value pairs are typically read from 
	// xml file. There are two methods of using this class
	// 1. Directly retrieve name-value pairs by calling method Get ( $id )
	// 2. Calling Evaluate( $s ) method, that search for all $id(s) in text
	// 		and replace it with $value. The $id(s) and $value(s) are read
	//		from arrData array that is member of this class.
	//
	class SymbolTable
	{
		var $arrData = array();
		
		function SymbolTable()
		{
			//
			// Following are supported Html Tags
			//
			
			$this->Set( "\${br}", "<br>");
			
			$this->Set( "\${b}", "<b>");
			$this->Set( "\${/b}", "</b>");
			
			$this->Set( "\${i}", "<i>");
			$this->Set( "\${/i}", "</i>");

			$this->Set( "\${image}", "<image "); // add space to avoid mixing tag name with attributes such as src
			$this->Set( "\${/image}", " />");
			
			$this->Set( "\${a}", "<a href=");
			$this->Set( "\${/a}", ">click here</a>");
			
			$this->Set( "\${apopup}", "<a href=JavaScript:NewWindow('");
			$this->Set( "\${/apopup}", "');>click here</a>");

			$this->Set( "\${dirdataprotection}", "/DataProtection");
		}
		
		//
		// Sets value ( parameter $data ) for key ( parameter $id ) in arrData.
		//
		function Set( $id, $data )
		{
			$existing_data = $this->arrData[$id];
			if ( isset( $existing_data ) )
			{
				print ("ERROR : Data already set in DataTable for Id=$id.<br/>Please report this error to vendor.<br/>");
				return;
			}
			else 
			{
				$this->arrData[$id] = $data;
			}
		}
		
		//
		// Update data with new value
		//
		function Update ( $id, $data )
		{
			$this->arrData[$id] = $data;
		}
		
		//
		// Retrieves value for key ( parameter $id ) that is stored
		// in arrData.
		//
		function Get( $id )
		{
			$data = $this->arrData[$id];
			return isset ( $data ) ? $data : "\${$id}";
		}
		
		//
		// Replace ${symbol} with  value(s). The ${symbol} and value
		// are stored a key-name value pairs in array ( arrData ).
		//
		function Evaluate ( $s )
		{
			foreach ( $this->arrData as $key=>$value )
			{
				$s = str_replace ( $key, $value, $s );
			}
			return $s;
		}
		
		//
		// Total number of key-value pairs in table
		//
		function Count()
		{
			return count ( $this->arrData );
		}
		
		//
		// Prints symbol table
		//
		function Print_()
		{
			print ("  Symbol Table - Item Count = ".count($this->arrData)."<br/>");
			if ( count ( $this->arrData ) <= 0 )
				return;
				
			$style = "style='border:solid 1px silver'";
			print ( "<table $style>" );
			foreach ( $this->arrData as $key=>$value )
			{
				$v = $value; $k = $key;
				$v = str_replace( "<", "&lt;", $v );
				$v = str_replace( ">", "&gt;", $v );
				$k = str_replace( "<", "&lt;", $k );
				$k = str_replace( ">", "&gt;", $k );
				
				print ( "<tr>" );
					print ( "<td>" );
					print ( "$k" );
					print ( "</td>" );
					print ( "<td>" );
					print ( "$v" );
					print ( "</td>" );
				print ( "</tr>" );
			}
			print ( "</table>" );
		}
	}

?>