<?php

	require_once("../Util/Constant.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Array.php");

	function IPAddresses()
	{
		$arr_ipaddress = array();
	
	  	if ( OSServerPlatform()==CONST_OS_LINUX() )
	    {
	      $cmd_ifconfig = shell_exec ("ifconfig | grep 'inet addr'");
	      $arr_ifconfig=explode (" ", $cmd_ifconfig);
	      
	      	foreach ( $arr_ifconfig as $v )
			{
				// Caution : Don't use 'inet addr' because it is exploded with " " above
			  	$exist=StrExist ( $v, "addr" );
			  	// echo $v." "."exist=".$exist."<br/>";
			  	if ( $exist==true )
			    {
			      	$arr_v=explode ( ":", $v );
			      	$len = count ( $arr_v );
			      	if ( $len==2 )
					{
				  		$ip = $arr_v[1];
				  		// echo "IP Found = ".$ip."<br/>";
				  		array_add ( $arr_ipaddress, $ip );
					}
			    }
			}
	
	      	// echo "Printing IP Addresses....<br/>";
	      	// foreach ( $arr_ipaddress as $ip )
	      	//   echo "IP Address = ".$ip;
	      	// echo "<br/>";
		}
	  	else if ( OSServerPlatform()==CONST_OS_WINDOWS() )
	    {
	      	$ip_address = gethostbyname($SERVER_NAME);
	      	$server_name = gethostbyaddr($ip_address); // Not used
	
	      	// echo "Server Name=".$server_name.", IP Address=".$ip_address."<br/>";
	      
	      	$ip = trim ( $ip_address );
	      	array_add ( $arr_ipaddress, $ip );
	    }
	    else 
	    {
	    	print __FILE__." ".__LINE__." Unable to determine OS.<br/>";
	    }
	    
	  	return $arr_ipaddress;
	}
	
?>

<?php
	
	function    ExistNetworkConnection()
	{
	  	// Initially, it is assumed that internet connection does not exist
	  	$existNetworkConnection = false;
	  
	  	// Get IP Addresses and continue searching for ip address which is neither
	  	// null, nor "" nor 127.0.0.1 not localhost. If any such ip address if found
	  	// it means that network connection does not exist.
	  	$arr_ipaddress=IPAddresses();
	  	foreach ( $arr_ipaddress as $ip_address )
	    {
	  		if (  $ip_address==null || !isset ( $ip_address ) || strcmp( $ip_address, "" )==0 )
	  			continue;
	  
	  		if ( strcasecmp( $ip_address, "127.0.0.1" ) == 0 || strcasecmp( $ip_address, "localhost" )==0 || strcasecmp( $ip_address, "0.0.0.0" )==0 )
	  			continue;
	      
	      		$existNetworkConnection = true;
	      		break;
	    }
	  	return $existNetworkConnection;
	}
		
?>