<?php

	require_once("../Util/Constant.php");
	require_once("../Util/String.php");

	function ScanDiskDrives ()
	{
		$arrLogicalDisk = array();
		
		if ( OSServerPlatform() == CONST_OS_LINUX() )
		{
			$cmd = "df";
			
			$output = array(); $return_var = 0;
			exec ( $cmd, $output, $return_var );
			
			$i=0;  
			
			// Use pre to show spaces during debug on html pages.
			// Html truncates multiple consequetve spaces under
			// normal circumstances.
			// print ("<pre>");
			
			foreach ( $output as $line )
			{
				//
				// The space symbol is used to 'explode' (php function)
				// line into different substring each representing a value
				// such as 'Size', 'Used', 'Avail' etc.
				//
				// The $line may have more than one consequetive spaces " ",
				// causing 'explode' (php function) to break into superflous
				// empty "" substring and confusing column alignments. Therefore
				// it is important to clean the string before exploding to make
				// sure that only one consequetive space " " is present b/w
				// any two characters, to prevent superflous spaces causing
				// column mis-alignments.
				//

			  	$attempts=0;
			  	do 
			    {
					$previousLine = $line;
					$line = str_replace("  " /* double space */, " " /* single space */, $previousLine );
					// print ( "New ".$line." : Previous".$previousLine."<br/>" );
					$attempts++;
			    }
			  	while ( $previousLine != $line && $attempts<100 );

			  	//
			  	// Now explode the line into substrings and parse them
			  	// to populate diskinfo object.
			  	//
			  
			  	$pieces = explode ( " ", $line );
				
			  	// print ("..........................................<br/>");

			  	//
			  	// First line is always column header
			  	//
			  	if ( $i==0 ) 
			    {
					$columns = $pieces;
				  	$lenCol = count ( $columns );
			    }
			    
			    //
			    // Remaining lines ( other than first ) are rows
			    //
			  	else 
			    {
			    	$data = $pieces;
			      	$diskPartition = new DiskInfo();
			      
			      	// print ( $i." of ".$lenCol."<br/>" );
			      
			      	for ( $j=0; $j<$lenCol; $j++ )
					{
				  		$col = trim ( $columns[$j] );
				  		$val = trim ( $data[$j] );

				  		// print ($col." = ".$val."<br/>" );
				  		switch ( $col )
				    	{
				    		case "Filesystem" :
				      			$diskPartition->Name = $val;
				      			break;
				    		case "1K-blocks" :
				      			$diskPartition->TotalSize = floatval($val) * 1024;
				      			break;
				    		case "Used" :
				      			$diskPartition->UsedSize = floatval($val) * 1024;
				      			break;
				    		case "Available" :
				      			$diskPartition->FreeSize = floatval($val) * 1024;
				      			break;
				    		case "Use%" :
				      			break;
				    		case "Mounted":
				      			break;
				      		case "on";
				      			break;
				    		default:
				    	}	
					}
			      	array_push ( $arrLogicalDisk, $diskPartition );
				}
				$i++;
			}
			// print ("</pre>");
		}
		else if ( OSServerPlatform() == CONST_OS_WINDOWS() )
		{
			$cmd = "cscript.exe ".CONST_DIR_DATA_PROTECTION()."/Hardware/DiskInfo.vbs //nologo";
			// print ( "Command=".$cmd."<br/>" );

			$output = array(); $return_var = 0;
			exec( $cmd, $output, $return_var );
			foreach ( $output as $line )
			{
				// print ( $line."<br/>" );

				$diskPartition = new DiskInfo();
				$listParamVal= explode(" ", $line );
				
				foreach ( $listParamVal as $pairParamVal )
				{
					$sLen = strlen( $pairParamVal );
					$index = strpos ( $pairParamVal, "=" );
					
					if ( $sLen <= 0 )
					{
						print ( __FILE__." ".__LINE__." Unable to interpret string =".$pairParamVal."<br/>" );
						continue;
					}
					
					if ( is_int ( $index ) == false )
					{
						print ( __FILE__." ".__LINE__." Unable to interpret string =".$pairParamVal."<br/>" );
						continue;
					}

					$param = substr ( $pairParamVal, 0, 	   $index );
					$value = substr ( $pairParamVal, $index+1, $sLen-1 );
					
					// print ( "Param Value [".$pairParamVal."], Length=".$sLen.", Equals Sign Index=".$index." " );
					// print ( " -- Broken As (Param=".$param.", Value=".$value.")<br/>" );
					
					if ( StrExist( $pairParamVal, "DeviceID=") )
					{
						$diskPartition->Name=$value;
					}
					else if ( StrExist( $pairParamVal, "TotalSize=") )
					{
						$diskPartition->TotalSize=$value;
					}
					else if ( StrExist( $pairParamVal, "UsedSpace=") )
					{
						$diskPartition->UsedSize=$value;
					}
					else if ( StrExist( $pairParamVal, "FreeSpace=") )
					{
						$diskPartition->FreeSize=$value;
					}
					else
					{
						print ( __FILE__." ".__LINE__." Unrecognized Parameter =".$param."<br/>" );
					}
				}
				
				// print ( "Adding ".$diskPartition->Name."<br/>" );
				array_push( $arrLogicalDisk, $diskPartition );
			}
		}
		
		return $arrLogicalDisk;
	}

?>