<!-- -------------------------------------------------------- 
			EDUCATION - Item and Film -  Common to all
-------------------------------------------------------- -->

<script language="javascript" src="/<?php print ( CONST_DATAPROTECTION() ); ?>/Browser.js">
</script>

<script language="JavaScript" src="/<?php print ( CONST_DATAPROTECTION() ); ?>/Cookie.js">
</script>

<script language="javascript">

	/* CLASS */ function EducationItem ()
	{
		this.Show = true;
		this.DisplayTime = 10;
		this.BackgroundColor = "";
		this.FontColor = "black";
		this.Text = "";
		this.ImageName 	= "";
		this.ImageURL 	= "";
		this.ImageWidth = "";
		this.ImageHeight = "";
		this.ImageAlign = ""; //left, right or center
	}
	
	/* CLASS */ function EducationFilm ()
	{
		//
		// The name of variable that holds the instance of this class
		// This is sort of hack, for timer to know, which objects' method
		// to call.
		//
		this.InstanceName = '';
		//
		// The array that holds instances of EducationItem
		//
		this.ArrayEducationList = new Array(); 
		//
		// Current index on education array i.e. arrayEducationList
		//
		this.Index = 0; 
		//
		// The ID of current timer
		//
		this.TimerID; 
		//
		// Area where main items are displayed
		//
		this.DivStage;
		//
		// Area where debug information is displayed
		//
		this.DivDebug;
		
		//
		// Displays the next slide
		//
		function NextSlide()
		{
			this.Index++; // Simple increments
			
			// var randomNumberUnrounded = Math.random()*this.ArrayEducationList.length;
			// var randomNumberRounded = Math.round ( randomNumberUnrounded );
			// this.Index = randomNumberRounded;
			
			if ( this.Index >= this.ArrayEducationList.length )
				this.Index=0;
			
			var html = "";
				
			var eduItem = this.ArrayEducationList[this.Index];
			
			if (  eduItem.ImageURL != null && eduItem.ImageURL != "" )
			{
				html += "<div style='border: 1px solid silver; width:100%;text-align:center;background:white'>";
					html += "<img src=" + "\"<?php print ( CONST_URL_DATA_PROTECTION() ); ?>" + eduItem.ImageURL + "\" ";
					
					if ( eduItem.ImageAlign != undefined && eduItem.ImageAlign != "" )
						html += " align="+ eduItem.ImageAlign + " ";
					if ( eduItem.ImageWidth != undefined && eduItem.ImageWidth != "" )
						html += " width=" + eduItem.ImageWidth + " ";
					if ( eduItem.ImageHeight != undefined && eduItem.ImageHeight != "" )
						html += " height=" + eduItem.ImageHeight + " ";
					
					html += "/>";
				html += "</div>";
			}
			html += "<br/>";
			if ( eduItem.Text.length <=150 )
			{
				html += eduItem.Text;
			}
			else
			{
				html += eduItem.Text.substring (0, 149 ) + " - - - Too long text !";
				// html += eduItem.Text.substring (0, 149 ) + " - - - <a href=''>more</a>";
			}

			if ( is_ie5up ==true && this.DivStage.filters.length >= 1 )
			{
				// Transition Filter : Start
				this.DivStage.filters[0].apply();
				// Assign new informaton
				this.DivStage.innerHTML = html;
				this.DivStage.style.background =  eduItem.BackgroundColor;
				this.DivStage.style.color = eduItem.FontColor;
				this.DivStage.style.fontFamily = "futura bk";
				this.DivStage.style.fontSize = "16";
				this.DivStage.style.fontWeight = "bold";
				this.DivStage.style.textAlign = "left";
				// Transition Filter : End
				this.DivStage.filters[0].play();
				
				return;
			}
			else
			{
				this.DivStage.innerHTML = html;
				// this.DivStage.style.background =  eduItem.BackgroundColor; // - background color does not work on non-ie browsers
				this.DivStage.style.color = "black";
				this.DivStage.style.fontFamily = "futura bk";
				this.DivStage.style.fontSize = "16px";
				this.DivStage.style.fontWeight = "bold";
				this.DivStage.style.textAlign = "left";

				return;
			}
		}
		this.NextSlide = NextSlide; // Make NextSlide() method public - This is how JavaScript makes methods public
		
		//
		//
		//
		function DisplayDebugEducationArray()
		{
			this.DivDebug.innerHTML =  "";
			this.DivDebug.innerHTML += "<hr/>";
			this.DivDebug.innerHTML += "DEBUG - Printing Education Items<br/>";
			this.DivDebug.innerHTML += "<hr/>";
		
			for ( j=0; j<arrayEducationList.length; j++ )
			{
				this.DivDebug.innerHTML += "<b>" + this.ArrayEducationList[j].ImageName + " : " + "</b>" + this.ArrayEducationList[j].Text + "<br/>";
			}
		
			this.DivDebug.innerHTML += "<hr/>";
		}
		this.DisplayDebugEducationArray = DisplayDebugEducationArray; // Make DisplayDebugEducationArray() method public - This is how JavaScript makes methods public
		
		//
		// SAMPLE Spans for different types of transitions
		// 
		// <span id=divEducation style="FILTER: progid:DXImageTransform.Microsoft.Fade(Overlap=5.00); width:400;height:400; border-width:2; border-color:black">
		// </span>
		// 
		// <span id=divEducation style="FILTER: progid:DXImageTransform.Microsoft.RandomDissolve(); width:400; height:400; border:silver 1 solid; padding: 10; text-align:justify;">
		// </span>
		// 
		// <span id=divEducation style="FILTER: progid:DXImageTransform.Microsoft.Stretch(stretchstyle=PUSH); width:400;height:400; border-width:2; border-color:black">
		// </span>
		// 
	}

</script>

<!-- -------------------------------------------------------- 
		EXECUTOR - Executes the film, slide by slide
-------------------------------------------------------- -->

<script language="javascript"> 

	function StartFilm ( film )
	{
		var index = getCookie ( film.InstanceName );
		if ( index == null || index == '' )
			index = 0;
		
		if ( index >= film.ArrayEducationList.length )
			index = 0;
			
		film.Index = index;
		
		NextEvent ( film );
	}

	function StartFilmRandom ( film )
	{
		rangeMax = film.ArrayEducationList.length -1;
		film.Index = Math.round ( Math.random() * rangeMax );
		StartFilm(film);
	}
	
	function NextEvent( film )
	{
		film.NextSlide();
		
		setCookie ( film.InstanceName, film.Index, null, "", "", "" );
		
		// Clear old timer
		if ( film.TimerID != undefined ) // Calling clearInterval() on 'undefined' Timer ID after several calls, cause browser to chocking
			clearInterval (  film.TimerID ); // NOTE : Clearing old timer interval is important because current film item may have a different interval
		
		// Determine timer interval
		var displayInterval = parseInt (  film.ArrayEducationList[ film.Index].DisplayTime );
		displayInterval = ( displayInterval > 0 ) ? displayInterval : 5;

		// Setup Timer
		film.TimerID = setInterval ( "NextEvent(" + film.InstanceName + ");", displayInterval * 1000 /* Display Time or Interval */ );
	}

	function StopFilm ( film )
	{
		if ( film.TimerID != undefined )
			clearInterval ( film.TimerID );
	}
	
</script>

<!-- -------------------------------------------------------- 
	PHP : The PHP control (server side) generates code that
		uses Javascript classes (above), to generate slide show.
		Javascript is client side and actual work horse.  PHP is
		server side that generates code (Javascript) that in turn
		uses Javascript classes above.
		Control that generates required JavaScript
		for each of it's (PHP) object by name
		mangling. Hence unique function and variable
		names are generated for each instance of
		this control
-------------------------------------------------------- -->
<?php
	
	require_once("../Util/Constant.php");

	require_once(CONST_DIR_DATA_PROTECTION()."/Control/Control.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Log.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Platform.php");
		
	class SlideShow extends Control
	{
		var $xmlFile;
		var $xmlNode;
		var $divStage;
		var $divDebug;
		var $transition;
		var $imageHeight;
		var $imageWidth;
		var $imageAlign;
		
		function SlideShow($name, $parent)
		{
			parent::Control($name, $parent);
			$this->divStage = "divStage".$this->InstanceName();
			$this->divDebug = "divDebug".$this->InstanceName();
			$this->DefaultStyle();;
		}
		
		function DefaultStyle ()
		{
			$this->Height = ""; // Set by class that use this control
			$this->Width =""; // Set by class that use this control
			$this->transition  = "";
			$this->imageHeight = "100px"; // default
			$this->imageWidth  = "250"; // default
			$this->imageAlign  = "center"; // default
		}
		
		//
		// Possible values are stretch, dissolve, fade
		//
		function SetTransition ( $t )
		{
			$this->transition = $t;
		}
		
		function ArrayName ()
		{
			return "array_".$this->InstanceName();
		}
		
		function InstanceName ()
		{
			return "_slide_show_".$this->FullName();
		}
		
		//////////////////////////////////////////////////
		//
		// 		On Response - This is where 'Response' is
		//			processed. Here syncronization of
		//			controls should take place from variables
		//			to Response.
		//
		function OnRender()
		{
			parent::OnRender();
			
			$arrTranitionList = array();
			$arrTranitionList [0] = "fade";
			$arrTranitionList [1] = "dissolve";
			// $arrTranitionList [2] = "stretch";
			
			if ( strtolower( $this->transition ) == "random" || $this->transition == "" )
			{
				srand (doubleval( microtime()) * 1000000 );
				// $index = rand (0,2);
				$index = rand (0,1);
				$transition = $arrTranitionList [$index];
			}
			else
			{
				$transition = $this->transition;
			}
			
			
			$style = "width:$this->Width;height:$this->Height; padding: 10; text-align:justify;"; 	// POTENTIAL BUG : Not putting border in this statement, but in IE specific block below.
																									//		Want to avoid using border in generic style, because in mozilla, borders
																									// 		are not well understood by developer or they are buggy or confusing to use.
																									// 		Hence avoiding borders for generic style. - Imran Salim
			if ( BrowserPlatform()==CONST_BROWSER_INTERNET_EXPLORER() )
			{
				if (  strtolower($transition) =="fade" )
					$style .= "FILTER: progid:DXImageTransform.Microsoft.Fade(Overlap=5.00);";
				// elseif (  strtolower($transition) =="stretch" )
				//	$style .= "FILTER: progid:DXImageTransform.Microsoft.Stretch(stretchstyle=PUSH); ";
				elseif (  strtolower($transition) =="dissolve" )
					$style .= "FILTER: progid:DXImageTransform.Microsoft.RandomDissolve();";
				else
					$style .= "FILTER: progid:DXImageTransform.Microsoft.RandomDissolve();"; // Default Transition
					
				$style .= "border:silver 1px solid;";
			}

			if ( BrowserPlatform()==CONST_BROWSER_INTERNET_EXPLORER() )
			{
				print ( "<span id=$this->divStage style=\"$style\"></span>" );
				print ( "<span id=$this->divDebug></span>" );
			}
			else 
			{
				print ( "<table bgcolor='f0f0f0' cellpadding=7 height=.$this->Height width=.$this->Width >" );
					print ( "<tr valign=top>" );
						print ( "<td>" );
			 				print ( "<span id=$this->divStage style=\"$style\"></span>" );
			 				print ( "<span id=$this->divDebug></span>" );
			 			print ( "</td>" );
			 		print ( "</tr>" );
			 	print ( "</table>" );
			}
			
			$this->PopulateData();
			
			$arrayName = $this->ArrayName(); 
			$instanceName = $this->InstanceName();
			
			?>

			<script language="javascript">
				
				var <?php print($arrayName) ?> = new Array();
				var <?php print ($instanceName) ?> = new EducationFilm ("<?php print ($instanceName) ?>");

				<?php print($arrayName) ?> 	= PopulateData<?php print ($instanceName) ?>();
	 			<?php print ($instanceName) ?>.InstanceName = "<?php print ($instanceName) ?>";
	 			<?php print ($instanceName) ?>.ArrayEducationList = <?php print ( $this->ArrayName()) ?>;
				<?php print ($instanceName) ?>.DivStage = <?php print ( $this->divStage ) ?>;
				<?php print ($instanceName) ?>.DivDebug = <?php print ( $this->divDebug ) ?>;
				
				StartFilm(<?php print ($instanceName) ?>);
				// StartFilmRandom(<?php print ($instanceName) ?>);				
				
			</script>
				
			<?php
		}
			
		//
		//
		//
		function PopulateData()
		{
			if ( $this->xmlNode != null )
				$this->PopulateFromXMLNode($this->xmlNode);
			else if ( $this->xmlFile != null )
				$this->PopulateFromXMLFile($this->xmlFile);
		}
		
		//
		//
		//
		function PopulateFromXMLFile($xmlFile)
		{
			$dom = domxml_open_file($xmlFile);
			$education = $dom->document_element();
			$this->PopulateFromXMLNode($education);
		}

		//
		//	Generates client side JavaScript for populating array
		//
		function PopulateFromXMLNode($education /* xml node */)
		{
			?>
			
			<script language="javascript">
					
			<?php 
				$instanceName = $this->InstanceName();
			?>
			
			function PopulateData<?php print ($instanceName) ?>()
			{
				var array = new Array();
				<?php
									
					$itemList = $education->get_elements_by_tagname("Item");
					foreach ( $itemList as $item )
					{
							$show 			= $item->get_attribute("Show");
							$displaytime 	= $item->get_attribute("DisplayTime");
							$fontcolor 		= $item->get_attribute("FontColor");
							$backgroundcolor= $item->get_attribute("BackgroundColor");
							$t= $item->get_elements_by_tagname("Text");
							$text = $t[0]->get_content();
							$i= $item->get_elements_by_tagname("Image");
							if ( isset ( $i )==true && count ( $i )>0 )
							{
								$image= $i[0];
								$imgname = $image->get_attribute("Name");
								$imgurl  = $image->get_attribute("URL");
							}
							else 
							{
								$imgname = null;
								$imgurl = null;
							}
				?>
				//
				// JavaScript
				//
				var eduItem = new EducationItem();
				eduItem.Show=				"<?php print ( $show ) 			?>";
				eduItem.DisplayTime=		"<?php print ( $displaytime ) 	?>";
				eduItem.FontColor=			"<?php print ( $fontcolor ) 	?>";
				eduItem.BackgroundColor=	"<?php print ( $backgroundcolor )?>";
				eduItem.Text=				"<?php print ( $text ) 			?>";
				eduItem.ImageName=			"<?php print ( $imgname ) 		?>";
				eduItem.ImageURL=			"<?php print ( $imgurl ) 		?>";
				eduItem.ImageHeight=		"<?php print ( $this->imageHeight ) ?>";
				eduItem.ImageWidth=			"<?php print ( $this->imageWidth )  ?>";
				eduItem.ImageAlign=			"<?php print ( $this->imageAlign )  ?>";
				array.push ( eduItem );
				<?php 
					} 
				?>
				return array;
			};
					
			</script>
			<?php
		}
	}

?>


<!-- -----------------------------------------------------------------------------------
	 		Sample of JavaScript that is generated from SlideShow.php's class
----------------------------------------------------------------------------------------

<span id=divStage_demo style="width:;height:; border:silver 1 solid; padding: 10; text-align:justify;"></span><span id=divDebug_demo></span>			

<script language="javascript">
						
function PopulateData_demo()
{
	var array = new Array();
				
	//
	// JavaScript
	//
	var eduItem = new EducationItem();
	eduItem.Show=			"true";
	eduItem.DisplayTime=		"15";
	eduItem.FontColor=		"White";
	eduItem.BackgroundColor=	"Green";
	eduItem.Text=			"Unlimited locally-attached tape drives Single drive, unlimited slot autoloader support USB, IDE and SCSI tape device support Quick-start backup and restore wizards User and predefined backup schedules Language support for English, French, Italian, German, Spanish and Japanese ";
	eduItem.ImageName=		"Something";
	eduItem.ImageURL=		"image/connected_networks_big.jpg";
	eduItem.ImageHeight=		"100px";
	eduItem.ImageWidth=		"100px";
	eduItem.ImageAlign=		"center";
	array.push ( eduItem );
					
	//
	// JavaScript
	//
	var eduItem = new EducationItem();
	eduItem.Show=			"true";
	eduItem.DisplayTime=		"15";
	eduItem.FontColor=		"Black";
	eduItem.BackgroundColor=	"Blue";
	eduItem.Text=			"When it comes to data protection for the small-to-medium enterprise, Yosemite TapeWare 7 is the only solution you need. With platform support that includes Microsoft Windows, Linux, NetWare and UNIX and the ability to protect both servers and PC desktops with one product, backup can be centralized, consistent and simplified.";
	eduItem.ImageName=		"tapedrive";
	eduItem.ImageURL=		"image/HPLogo.gif";
	eduItem.ImageHeight=		"100px";
	eduItem.ImageWidth=		"100px";
	eduItem.ImageAlign=		"center";
	array.push ( eduItem );
					
	//
	// JavaScript
	//
	var eduItem = new EducationItem();
	eduItem.Show=			"true";
	eduItem.DisplayTime=		"15";
	eduItem.FontColor=		"";
	eduItem.BackgroundColor=	"";
	eduItem.Text=			"Small-to-medium enterprises (SME) seeking to protect their mission critical data resources are often tantalized by the functionality of an enterprise-strength data backup solution and are consequently lured to vendors who specialize in such offerings.";
	eduItem.ImageName=		"Something";
	eduItem.ImageURL=		"image/wht_abgw.jpg";
	eduItem.ImageHeight=		"100px";
	eduItem.ImageWidth=		"100px";
	eduItem.ImageAlign=		"center";
	array.push ( eduItem );
	
	return array;
};
					
</script>
			
<script language="javascript">
				
	var array__demo = new Array();
	var _demo = new EducationFilm ("_demo");

	array__demo 	= PopulateData_demo();
	_demo.InstanceName = "_demo";
	_demo.ArrayEducationList = array__demo;
	_demo.DivStage = divStage_demo;
	_demo.DivDebug = divDebug_demo;
				
	StartFilmRandom(_demo);
				
</script>
----------------------------------------------------------------------------------------
	 						End Sample
------------------------------------------------------------------------------------ -->