<?php

	require_once("Control.php");

	class LinkButton extends Control
	{
		var $ClickHandler;
		var $OnClick;
		var $ImageSource;
		var $PostBackAnchor; // Name of anchor, to which to scroll in case of click
				
		function LinkButton($name, $parent_)
		{
			parent::Control($name, $parent_);
		}
		
		//////////////////////////////////////////////////
		//
		// 		On Request - This is where 'Request' is
		//			processed. Here syncronization of
		//			controls should take place from Request
		//			to variables.
		//
		function OnRequest()
		{
			parent::OnRequest();
			
			$val = $_REQUEST[ $this->FullName() ];
			if ( $val==$this->FullName() )
			{
				if ( isset( $this->ClickHandler )  )
				{
					$this->ClickHandler->Execute();
				}
			}
		}
			
		//////////////////////////////////////////////////
		//
		// 		On Response - This is where 'Response' is
		//			processed. Here syncronization of
		//			controls should take place from variables
		//			to Response.
		//
			
		function OnRenderNormal()
		{
			$self = $_SERVER['PHP_SELF'];
			$href = $self."?".$this->FullName()."=".$this->FullName();
			
			if ( $this->PostBackAnchor != null )
				$href .= "#".$this->PostBackAnchor;
			
			$content = $this->Text;
			if ( $this->ImageSource != null )
				$content = "<img src='".$this->ImageSource."' border=0 />";

			print ( "<a href='$href' OnClick=\"$this->OnClick\">$content</a>" );
		}
			
		function OnRenderSelect()
		{
			$this->OnRenderNormal();
		}
			
		function OnRenderEdit()
		{
			$this->OnRenderNormal();
		}
	}
	
?>

<?php

	/*
	$btn1 = new LinkButton("MyButton");
	$btn1->Text="salim";
	print ("<br>\n");
	$btn1->Display();
	print ("<br>\n");
	print ( $btn1->Name );
	print ("<br>\n");
	
	$btn2 = new LinkButton("MyButton");
	$btn2->Text="uddin";
	print ("<br>\n");
	$btn2->Display();
	print ("<br>\n");
	print ( $btn2->Name );
	*/
?>