<?php

	require_once("../Util/Constant.php");

	require_once("Control.php");
	require_once("Dialog.php");
	require_once("Image.php");
	require_once("ClientWindow.php");
	
	class Link extends Control
	{
		function Link( $name, & $parent_)
		{
			parent::Control($name, $parent_);
		}

		// These items must be set, in order to use 
		// an instance of this page
		var $Url;
		var $DocumentName;
		var $Label;
		var $FontColor;
		var $OpenSeparateWindow = false;
		var $Tracking = false;
		
		var $ImageSource;
		
		//////////////////////////////////////////////////
		//
		// 		On Response - This is where 'Response' is
		//			processed. Here syncronization of
		//			controls should take place from variables
		//			to Response.
		//
			
		function OnRenderNormal()
		{
			$linkHtml = $this->BuildLinkHtml();
			print ( $linkHtml );
		}
		
		function BuildLinkHtml () 
		{
			$href = $this->BuildLinkHref();
			$content = $this->BuildLinkContent();
			
			$linkHtml =  "<a href=\"$href\">".$content."</a>";
			
			return $linkHtml;
		}

		function BuildLinkHref()
		{
			$href = "";
						
			//---------------------------------------------
			// Uniform Resource Locator
			//---------------------------------------------
			
			if ( $this->Url == "#" )
				$href = $this->Url.$this->DocumentName;
			else  if ( $this->DocumentName == "" )
				$href = $this->Url;
			else
				$href = $this->Url."/".$this->DocumentName;
			
			//---------------------------------------------
			// Query String
			//---------------------------------------------
			
			$queryString = ""; // Query string -  Build
			
			if ( $this->Tracking==true )
				$queryString .= CONST_URL_TRACKING_QUERY_PARAMETER ();
			
			if ( trim( $queryString ) != "" )
				$href .= "?".$queryString; // Query string - Assign
				
			//---------------------------------------------
			// Open Separate Window
			//---------------------------------------------
			
			if ( $this->OpenSeparateWindow == true ) // only wrap in javascript's NewWindow(..) function call
				$href = "javascript:NewWindow('".$href."');";
			
			return $href;
		}
		
		function BuildLinkContent()
		{
			$content = "";
						
			//---------------------------------------------
			// Font - Color etc
			//---------------------------------------------
			
			if ( $this->FontColor == null )
				$contentText = $this->Label;
			else 
				$contentText = "<font color=".$this->FontColor.">".$this->Label."</font>";
				
			if ( $this->ImageSource != null )
				$contentImage = "<img src='".$this->ImageSource."' border=0 />";
			
			//---------------------------------------------
			// Content - Image or Text
			//---------------------------------------------

			if ( $this->ImageSource != null )
				$content = $contentImage;
			else 
				$content = $contentText;
			
			return $content;
		}

		function __Obsolete__BuildLinkHtml()
		{
			$href = "";
			$content = "";
						
			//---------------------------------------------
			// Uniform Resource Locator
			//---------------------------------------------
			
			if ( $this->Url == "#" )
				$href = $this->Url.$this->DocumentName;
			else  if ( $this->DocumentName == "" )
				$href = $this->Url;
			else
				$href = $this->Url."/".$this->DocumentName;
			
			//---------------------------------------------
			// Query String
			//---------------------------------------------
			
			$queryString = ""; // Query string -  Build
			
			if ( $this->Tracking==true )
				$queryString .= CONST_URL_TRACKING_QUERY_PARAMETER ();
			
			if ( trim( $queryString ) != "" )
				$href .= "?".$queryString; // Query string - Assign
				
			//---------------------------------------------
			// Open Separate Window
			//---------------------------------------------
			
			if ( $this->OpenSeparateWindow == true ) // only wrap in javascript's NewWindow(..) function call
				$href = "javascript:NewWindow('".$href."');";
			
			//---------------------------------------------
			// Font - Color etc
			//---------------------------------------------
			
			if ( $this->FontColor == null )
				$contentText = $this->Label;
			else 
				$contentText = "<font color=".$this->FontColor.">".$this->Label."</font>";
				
			if ( $this->ImageSource != null )
				$contentImage = "<img src='".$this->ImageSource."' border=0 />";
			
			//---------------------------------------------
			// Content - Image or Text
			//---------------------------------------------

			if ( $this->ImageSource != null )
				$content = $contentImage;
			else 
				$content = $contentText;
				
			//---------------------------------------------
			// Print the link in html format
			//---------------------------------------------
			
			$linkHtml =  "<a href=\"$href\">".$content."</a>";
			return $linkHtml;
		}
			
		function OnRenderSelect()
		{
			$this->OnRenderNormal();
		}
			
		function OnRenderEdit()
		{
			$this->OnRenderNormal();
		}
	}
	
?>
				
<?php

	/*
	$btn1 = new Link("MyButton");
	$btn1->Text="salim";
	print ("<br>\n");
	$btn1->Display();
	print ("<br>\n");
	print ( $btn1->Name );
	print ("<br>\n");
	
	$btn2 = new Link("MyButton");
	$btn2->Text="uddin";
	print ("<br>\n");
	$btn2->Display();
	print ("<br>\n");
	print ( $btn2->Name );
	*/
?>