<?php

	require_once("../Util/Constant.php");
	require_once("Control.php");
	require_once(CONST_DIR_DATA_PROTECTION()."/Util/Log.php");

	class FTP extends Control
	{
		var $url;
		var $username;
		var $password;
		var $remoteFilePath;
		var $localFilePath;
		
		// These data members are used during download process		
		var $fileLocal;
		var $ftp;
		var $remoteSizeMax;
		
		//
		// Constructor
		//
		function FTP ( $name, $parent, $url, $username, $password, $remoteFilePath, $localFilePath )
		{
			$this->url = $url;
			$this->username = $username;
			$this->password = $password;
			$this->remoteFilePath = $remoteFilePath;
			$this->localFilePath = $localFilePath;
			
			parent::Control($name, $parent);
		}
		
		//
		// Initialize Control
		//
		function OnInit()
		{
			$this->ftp = ftp_connect($this->url);
			if ( $this->ftp == null || $this->ftp == false )
			{
				if ( $debug )
					print ("Unable to connect\n<br/>");
				exit();
			}

			$login_status = ftp_login( $this->ftp, $this->username, $this->password);
			if ( $login_status == null || $login_status == false )
			{
				if ( $debug )
					print ("Unable to login\n<br/>");
				exit();
			}

			$this->fileLocal = fopen( $this->localFilePath, "w");
			if ( $this->fileLocal == null || $this->fileLocal == false )
			{
				if ( $debug )
					print ("Unable to open file\n<br/>");
				exit();
			}
			
			$this->remoteSizeMax = ftp_size( $this->ftp, $this->remoteFilePath);
			
		}

		//
		// Start 
		//
		function Start()
		{
			$status = ftp_nb_fget( $this->ftp, $this->fileLocal, $this->remoteFilePath, FTP_BINARY);
			if ( $status == FTP_FAILED )
			{
				if ( $debug )
					print ("Unable to get remote file\n<br/>");
			}
			else 
			{
				if ( $debug )
					print ("Downloading .... \n<br/>");
			}
			return $status;
		}
		
		//
		//
		// Status can return - FTP_FAILED, FTP_FINISHED, FTP_MOREDATA
		//
		function Update()
		{
			// while( $status == FTP_MOREDATA )
			// {
			//		$debug = "Still Downloading\n";
			//		print ($debug );
			//		usleep(.010);
			//	
			//		$status = ftp_nb_continue( $ftp );
			// }

			$status = ftp_nb_continue( $this->ftp );
			return  $status;
		}
		
		//
		//
		//
		function Close()
		{
			fclose( $this->fileLocal );
			ftp_close( $this->ftp );
		}
		
		//
		//
		//
		function LocalSizeCurrent()
		{
			// Hack : Bug Fix : If size of same file is continuously
			// extracted, the consecutive requests does not report
			// any new changes. A workaround is to extract size of
			// a different file, on each consecutive request. Hence,
			// in line below, the size of currently executing script
			// is extracted and then size of currently downloading 
			// file. This helps updating the new size of currently
			// downloading file. - Imran Salim
			filesize( __FILE__ /* name of this script */ );
		 	return  filesize($this->localFilePath);
		}
		
		//
		//
		//
		function RemoteSizeMax ()
		{
			return $this->remoteSizeMax;
		}

		//
		//
		//
		function RemoteSizeMaxMB ()
		{
			return $this->remoteSizeMax /1024 / 1024;
		}
	}
	
?>

<?php

	//////////////////////////////////////////////////////////////////////////////
	//																			//
	//							Sample File										//
	//																			//
	function _FTPControlSample_()
	{
		$lastRecorderSize = 0;
		$newRecordedSize = 0;
	
		$download = new FTP("mydownloader", null, "ftp.linux.ee", "anonymous", "guest", "/pub/gentoo/distfiles/releases/x86/2004.3/packagecd/packages-x86-2004.3-r1.iso", "hp_ltt_install_support.exe" );
		// $download = new FTP( "mydownloader", null, "ftp.hp.com", "anonymous", "imran@bm.com", "/pub/softlib/software3/COL5358/co-18262-2/hp_ltt_install_support.exe", "hp_ltt_install_support.exe" );
		$download->Start();
		
		print ( "Total Size ".$download->RemoteSizeMaxMB()." MB"."<br/>" );
		
		while ( $download->Update() == FTP_MOREDATA )
		{
			sleep(.02);
			$newRecordedSize = $download-> LocalSizeCurrent();
			if ( $lastRecorderSize != $newRecordedSize )
			{
				print ( "Downloading = ".$newRecordedSize."<br/>" );
				flush();
			}
			$lastRecorderSize = $newRecordedSize;
		}
	
		$download->Close();
		
		print ( "Successfully Downloaded = ".$download->fileLocalPath." <br/>" );
		print ( "File Size (after close) = ".$download->TotalSize()." " );
	}
	// _FTPControlSample_();
	// https://localhost:2381/dataprotection/control/downloader.php

?>